
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/OP15/scene/OP15.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'ddbf4iIJnhHIImfp+SKRF1C', 'OP15');
// OP15/scene/OP15.js

"use strict";

var _util = require("../script/util");

var _defaultData = require("../script/defaultData");

var _xstate = require("../script/xstate");

function _createForOfIteratorHelperLoose(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } it = o[Symbol.iterator](); return it.next.bind(it); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var pure = _xstate.actions.pure,
    send = _xstate.actions.send,
    raise = _xstate.actions.raise,
    sendParent = _xstate.actions.sendParent;
cc.Class({
  "extends": cc.Component,
  properties: {
    /*ant: {
    	default: null,
    	type: cc.Node,
    },
    apple: {
    	default: null,
    	type: cc.Node,
    },
    bird: {
    	default: null,
    	type: cc.Node,
    },
    car: {
    	default: null,
    	type: cc.Node,
    },
    cat: {
    	default: null,
    	type: cc.Node,
    },
    cow: {
    	default: null,
    	type: cc.Node,
    },
    duck: {
    	default: null,
    	type: cc.Node,
    },
    egg: {
    	default: null,
    	type: cc.Node,
    },
    farmer: {
    	default: null,
    	type: cc.Node,
    },
    fish: {
    	default: null,
    	type: cc.Node,
    },
    girl: {
    	default: null,
    	type: cc.Node,
    },
    hen: {
    	default: null,
    	type: cc.Node,
    },
    house: {
    	default: null,
    	type: cc.Node,
    },*/
    rightAudio: {
      "default": null,
      type: cc.AudioClip
    },
    wrongAudio: {
      "default": null,
      type: cc.AudioClip
    },
    logoCat: {
      "default": null,
      type: cc.Node
    }
  },
  playAni: function playAni(idx, name, options) {
    var times = options && options.times || 1;
    var cb = options && options.callback || null; // const cat = cc.find(`Canvas/frame-border/ground/${node}`);

    var node = this._figurePointRectArray[idx].node;
    var dragonDisplay = node.getComponent(dragonBones.ArmatureDisplay);
    var state = dragonDisplay.playAnimation(name, times); // dragonDisplay.addEventListener(dragonBones.EventObject.COMPLETE, (event) => {
    // 	//TODO 这里写触发事件
    // 	//event.name为事件名称
    // 	console.log(event.name)
    // }, this);
    // animationDisplay.addEventListener(dragonBones.EventObject.COMPLETE, completeCallback);

    return state;
  },
  // 生命周期 onLoad
  onLoad: function onLoad() {
    this._timeoutIds = [];
    this._intervalIds = [];
    this.initSceneData();
    this.initSize();
    window.ccc = this;
  },
  _imageResList: null,
  _audioResList: null,
  _animaResList: null,
  _lastFingerPosition: null,
  _hintsNodeList: null,
  _figurePointRectArray: null,
  _allAnimationNodes: null,
  initSceneData: function initSceneData() {
    this._imageResList = [];
    this._audioResList = [];
    this._animaResList = [];
    this._allAnimationNodes = [];
    this._hintsNodeList = [];
    this._lastFingerPosition = {
      pos: null,
      dirty: false
    };
    this._figurePointRectArray = [];
  },
  _designSize: null,
  // 设计分辨率
  _frameSize: null,
  // 屏幕分辨率
  _mapScaleMin: null,
  // 场景中常用缩放（取大值）
  _mapScaleMax: null,
  // 场景中常用缩放（取小值）
  _cocosScale: null,
  // cocos 自缩放 （较少用到）
  initSize: function initSize() {
    // 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
    var screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height;
    var design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height;
    var f = screen_size >= design_size;
    cc.Canvas.instance.fitHeight = f;
    cc.Canvas.instance.fitWidth = !f;
    var frameSize = cc.view.getFrameSize();
    this._frameSize = frameSize;
    this._designSize = cc.view.getDesignResolutionSize();
    var sx = cc.winSize.width / frameSize.width;
    var sy = cc.winSize.height / frameSize.height;
    this._cocosScale = Math.min(sx, sy);
    sx = frameSize.width / this._designSize.width;
    sy = frameSize.height / this._designSize.height;
    this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
    this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;
  },
  createStateMachine: function createStateMachine() {
    var _this = this;

    var check = [{
      target: '#game.end',
      cond: function cond(ctx, evt) {
        console.log('[answer NEXT] check if end', ctx.questionIndex >= ctx.questionsCount - 1);
        return ctx.questionIndex >= ctx.questionsCount - 1;
      }
    }, {
      target: 'hint'
    } // reenter 'hint' state
    ];
    var QuestionState = {
      id: 'question',
      initial: 'hint',
      states: {
        hint: {
          invoke: {
            src: function src(ctx, event) {
              console.log("[hint] play question " + ctx.questionIndex + ": " + ctx.questionPlayTimes + " audio");
              ctx.questionPlayTimes += 1;
              return new Promise(function (resolve, reject) {
                (0, _util.playAudioByUrl)(ctx.questions[ctx.questionIndex].audio_url, function () {
                  console.log('hint finish');
                  resolve();
                });
              });
            },
            onDone: 'answer',
            onError: 'answer'
          }
        },
        answer: {
          after: {
            8000: [{
              target: 'wrong'
            } // reenter 'hint' state
            ]
          },
          invoke: {
            src: function src(context, event) {
              return function (callback, onReceive) {
                console.log('[answer] thinking and playing'); // check every second

                var id = setInterval(function () {
                  if (!_this._lastFingerPosition.dirty) {
                    return;
                  }

                  var region = context.questions[context.questionIndex];

                  var result = _this.checkInRegion(region.rect);

                  if (result === null) {
                    return;
                  }

                  console.log('[Genise JS] checkInRegion' + result);

                  if (result) {
                    callback('RIGHT');
                  } else {
                    callback('WRONG');
                  }
                }, 100);

                _this._intervalIds.push(id); // Perform cleanup


                return function () {
                  return clearInterval(id);
                };
              };
            }
          },
          on: {
            RIGHT: {
              target: 'right'
            },
            WRONG: {
              target: 'wrong'
            }
          }
        },
        right: {
          invoke: {
            src: function src(context, event) {
              _this._lastFingerPosition.pos = null;
              _this._lastFingerPosition.dirty = false;
              return new Promise(function (resolve, reject) {
                console.log('answer right'); // this.playAni(context.questionIndex, 'normal')

                var an = context.questions[context.questionIndex].node;
                console.log('in right ' + typeof an);
                an.active = true;

                if (an.isSpine) {
                  var skeleton = an.getComponent(sp.Skeleton);
                  skeleton.setToSetupPose();
                  setTimeout(function () {
                    skeleton.setAnimation(0, 'normal', true);
                  }, 1);
                } else {
                  var dragonDisplay = an.getComponent(dragonBones.ArmatureDisplay);
                  dragonDisplay.playAnimation('normal', 0);
                }

                var ddLogoCat = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

                ddLogoCat.playAnimation('right', 1);
                ddLogoCat.once(dragonBones.EventObject.COMPLETE, function () {
                  this.logoCat.getComponent(dragonBones.ArmatureDisplay).playAnimation('normal', 0);
                }, _this);
                (0, _util.playAudioByUrl)(_this.rightAudio, function () {
                  resolve();
                });
              });
            },
            onDone: {
              target: '#QuestionsArray.next',
              actions: raise('CHECK')
            },
            onError: {
              target: '#QuestionsArray.next',
              actions: raise('CHECK')
            }
          }
        },
        wrong: {
          invoke: {
            src: function src(context, event) {
              _this._lastFingerPosition.pos = null;
              _this._lastFingerPosition.dirty = false;
              return new Promise(function (resolve, reject) {
                console.log('answer wrong', context.questionIndex, context.questionPlayTimes, context.maxQuestionTryTimes);

                var ddLogoCat = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

                ddLogoCat.playAnimation('wrong', 1);
                ddLogoCat.once(dragonBones.EventObject.COMPLETE, function () {
                  this.logoCat.getComponent(dragonBones.ArmatureDisplay).playAnimation('normal', 0);
                }, _this);
                var wrongEffect = _this.wrongAudio; // 第一和第二题的提示音

                if ([0, 1].includes(context.questionIndex)) {
                  wrongEffect = _this.data["wrong_audio" + context.questionPlayTimes];
                } else {
                  // 非第一和第二题，并且做第二遍的提示音
                  if (context.questionPlayTimes == 2) {
                    wrongEffect = _this.data["wrong_audio" + context.questionPlayTimes];
                  }
                }

                if (context.questionPlayTimes >= context.maxQuestionTryTimes) {
                  var an = context.questions[context.questionIndex].node;
                  an.active = true;

                  if (an.isSpine) {
                    var skeleton = an.getComponent(sp.Skeleton);
                    skeleton.setToSetupPose();
                    setTimeout(function () {
                      skeleton.setAnimation(0, 'normal', true);
                    }, 1);
                  } else {
                    var dragonDisplay = an.getComponent(dragonBones.ArmatureDisplay);
                    dragonDisplay.playAnimation('normal', 0);
                    console.log('show animation', an.active);
                  }
                }

                (0, _util.playAudioByUrl)(wrongEffect, function () {
                  if (context.questionPlayTimes >= context.maxQuestionTryTimes) {
                    // const an = context.questions[context.questionIndex].node;
                    // an.active = true;
                    // const dragonDisplay = an.getComponent(dragonBones.ArmatureDisplay);
                    // dragonDisplay.playAnimation('normal', 0);
                    // console.log('show animation', an.active);
                    reject();
                  } else {
                    resolve();
                  }
                });
              });
            },
            onDone: {
              target: 'hint' // actions: raise('CHECK')

            },
            onError: {
              target: '#QuestionsArray.next',
              actions: raise('CHECK')
            }
          }
        }
      }
    };
    var QuestionsArrayStatus = {
      id: 'QuestionsArray',
      initial: 'play',
      states: {
        play: _extends({}, QuestionState),
        next: {
          on: {
            CHECK: [{
              target: '#game.end',
              cond: function cond(ctx, evt) {
                ctx.questionIndex += 1;
                ctx.questionPlayTimes = 0;
                console.log('#game.end', ctx.questionIndex >= ctx.questionsCount);
                return ctx.questionIndex >= ctx.questionsCount;
              }
            }, {
              target: 'play'
            }]
          }
        }
      }
    };
    var state = {
      id: 'game',
      initial: 'begin',
      context: {
        questionIndex: 0,
        questionPlayTimes: 0,
        maxQuestionTryTimes: 2,
        questionsCount: this._figurePointRectArray.length,
        questions: this._figurePointRectArray
      },
      states: {
        begin: {
          invoke: {
            src: function src(ctx) {
              console.log('game begin 1');

              if (window.courseware && window.courseware.openOsmoFingerRead) {
                _this.isOpenedOsmoFingerRead = true;
                window.courseware.openOsmoFingerRead({
                  "page_id": 27,
                  "book_id": "opw1"
                });
              }

              var dragonDisplay = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

              var state = dragonDisplay.playAnimation('begin', 0);
              return new Promise(function (resolve, reject) {
                (0, _util.playAudioByUrl)(_this.data.begin_audio, function () {
                  console.log('game begin audio finish');
                  resolve();
                });
              });
            },
            onDone: 'guide',
            onError: 'guide'
          }
        },
        guide: {
          invoke: {
            src: function src(ctx) {
              return new Promise(function (resolve, reject) {
                (0, _util.playAudioByUrl)(_this.data.guide_audio, function () {
                  console.log('game guide audio finish');
                  reject();
                });
              });
            },
            onDone: 'playing',
            onError: 'playing'
          }
        },
        playing: _extends({
          entry: function entry(ctx) {
            console.log('entry play stage');

            var dragonDisplay = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

            var state = dragonDisplay.playAnimation('normal', 0);
            cc.assetManager.loadRemote(_this.data.playing_audio, function (err, audioClip) {
              cc.audioEngine.playMusic(audioClip, true, 0.8);
            });
            ctx.questions.forEach(function (block) {
              block.node.active = false;
            });
          },
          exit: function exit() {
            console.log('exit play stage');
            cc.audioEngine.stopMusic();
          },
          on: {
            NEXT: 'end'
          }
        }, QuestionsArrayStatus),
        end: {
          entry: function entry(ctx, event) {
            console.log('game end');

            var dragonDisplay = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

            var state = dragonDisplay.playAnimation('finish', 0);

            if (window.courseware && window.courseware.closeOsmoFingerRead) {
              _this.isOpenedOsmoFingerRead = false;
              window.courseware.closeOsmoFingerRead();
            }

            (0, _util.playAudioByUrl)(_this.data.end_audio, function () {
              console.log('game finish');
              (0, _util.onHomeworkFinish)();
            }); // return new Promise((resolve,reject) => {
            // 	setTimeout(() => {
            // 		console.log('hint finish');
            // 		resolve()
            // 	}, 2000)
            // })
          }
        }
      }
    };
    var after = {};

    var _loop = function _loop(i) {
      var t = _this._hintsNodeList[i].node;
      var k = _this._hintsNodeList[i].after;
      after[k] = {
        actions: function actions() {
          if (t.isSpine) {
            var skeleton = t.getComponent(sp.Skeleton);
            skeleton.setToSetupPose();
            setTimeout(function () {
              skeleton.setAnimation(0, 'enlarge', false);
            }, 1); // skeleton.animation = skeleton.animationNames[0];
          } else {
            var dragonDisplay = t.getComponent(dragonBones.ArmatureDisplay);
            dragonDisplay.playAnimation('enlarge', 1);
            console.log(dragonDisplay._armatureKey, 'enlarge');
            dragonDisplay.addEventListener(dragonBones.EventObject.COMPLETE, function (event) {// TODO 这里写触发事件
              // event.name为事件名称
              // event.armature.animation.play('normal', 0);
              // console.log(event.animationState.name, dragonDisplay._armatureKey, 'end')
            }, _this);
          } // const dragonDisplay = t.getComponent(dragonBones.ArmatureDisplay);
          // dragonDisplay.playAnimation('enlarge', 1);
          // console.log(dragonDisplay._armatureKey, 'enlarge')
          // dragonDisplay.addEventListener(dragonBones.EventObject.COMPLETE, (event) => {
          // 	//TODO 这里写触发事件
          // 	//event.name为事件名称
          // 	event.armature.animation.play('normal', 0);
          // 	console.log(event.animationState.name, dragonDisplay._armatureKey, 'end')
          // }, this);

        }
      };
    };

    for (var i = 0; i < this._hintsNodeList.length; i++) {
      _loop(i);
    }

    if (this.data.begin_sep_time) {
      var t = +this.data.begin_sep_time * 1000;
      after[t] = {
        actions: function actions() {
          console.log('game begin 2');

          for (var _i = 0; _i < _this._allAnimationNodes.length; _i++) {
            var _t = _this._allAnimationNodes[_i];

            if (_t.isSpine) {
              (function () {
                var skeleton = _t.getComponent(sp.Skeleton);

                console.log('skeleton: ', skeleton);
                skeleton.setToSetupPose();
                setTimeout(function () {
                  skeleton.setAnimation(0, 'normal', true);
                }, 1);
                console.log('skeleton 22: ', skeleton); // skeleton.animation = skeleton.animationNames[0];
              })();
            } else {
              var dragonDisplay = _t.getComponent(dragonBones.ArmatureDisplay);

              dragonDisplay.playAnimation('normal', 0);
            }
          }
        }
      };
    }

    state.states.begin.after = after;
    var gameMachine = (0, _xstate.createMachine)(state);
    window.gameMachine = gameMachine;
    this.gameMachineService = (0, _xstate.interpret)(gameMachine).onTransition(function (state) {// console.log(1, state.value, state.context);
    });
    this.gameMachineService.start();

    if (window.gameMachineService) {
      window.gameMachineService = gameMachineService;
    }
  },
  // 生命周期 start
  start: function start() {
    var _this2 = this;

    var getData = this.getData.bind(this);

    if (window && window.courseware) {
      getData = window.courseware.getData;
    }

    getData(function (data) {
      // console.log('data:', data);
      _this2.data = data || _this2.getDefaultData();
      _this2.data = JSON.parse(JSON.stringify(_this2.data));

      _this2.preloadItem();
    });
    window.air = window.air || {};

    if (window.air) {
      window.air.osmoFingerReadCallback = function (result) {
        if (!_this2.gameMachineService) {
          return;
        } // const st = this.gameMachineService.state.value.constructor.name == 'Object' 
        // && this.gameMachineService.state.value['playing']
        // && this.gameMachineService.state.value['playing'].constructor.name == 'Object'
        // && this.gameMachineService.state.value['playing']['play']
        // && this.gameMachineService.state.value['playing']['play'] == 'answer'
        // if (st) {
        // }


        var resultObj = JSON.parse(result);
        console.log('[Genise JS] ' + JSON.stringify(resultObj.finger_pos_in_page));
        var p = resultObj.finger_pos_in_page;

        if (p.x == -1 || p.y == -1) {
          _this2._lastFingerPosition.pos = null;
          _this2._lastFingerPosition.dirty = false;
          return;
        }

        _this2._lastFingerPosition = {
          pos: {
            x: p.x,
            y: p.y
          },
          dirty: true
        };

        _this2.debugPointer(p.x, p.y);
      };
    }

    this.isDebug = false;
  },
  checkInRegion: function checkInRegion(r) {
    if (!this._lastFingerPosition && !this._lastFingerPosition.pos) {
      return null;
    }

    var p = this._lastFingerPosition ? this._lastFingerPosition.pos || {
      x: 0,
      y: 0
    } : {
      x: 0,
      y: 0
    };
    console.log('~p: ', p);
    console.log('~r: ', r);
    var w = p.x > r.x && p.x < r.x + r.width;
    var h = p.y > r.y && p.y < r.y + r.height;
    return w && h;
  },
  getData: function getData(func) {
    if (window && window.courseware) {
      window.courseware.getData(func, 'scene');
      return;
    }

    var middleLayer = cc.find('middleLayer');

    if (middleLayer) {
      var middleLayerComponent = middleLayer.getComponent('middleLayer');
      middleLayerComponent.getData(func);
      return;
    }

    func(this.getDefaultData());
  },
  getDefaultData: function getDefaultData() {
    return {
      "begin_audio": "https://teach.cdn.ireadabc.com/9be46c9adb540ed8a60763f1e657ccb7.mp3",
      "begin_sep_time": 66,
      "guide_audio": "https://teach.cdn.ireadabc.com/9523c8ed45faee686363dd157b0d7426.mp3",
      "playing_audio": "https://teach.cdn.ireadabc.com/d6a953052a6f80549730cb4307c55719.mp3",
      "right_audio": "https://teach.cdn.ireadabc.com/43791fc418e666df5e9ec1b7bf936409.mp3",
      "wrong_audio": "https://teach.cdn.ireadabc.com/7dd85f025a132c2eef8daee38d900287.mp3",
      "wrong_audio1": "https://teach.cdn.ireadabc.com/a76afb06af0799bf538e38f9f80a2261.mp3",
      "wrong_audio2": "https://teach.cdn.ireadabc.com/daee88b6f2eadd78b60436eedffcae08.mp3",
      "end_audio": "https://teach.cdn.ireadabc.com/9c1e87b3c184b06e14e44bb058b9804e.mp3",
      "bgItem": {
        "url": "https://teach.cdn.ireadabc.com/16b6dacd8e6c1ce6da16f500a66b366b.jpg",
        "rect": {
          "x": 319.68,
          "y": 0,
          "width": 257.64,
          "height": 342
        }
      },
      "hotZoneItemArr": [{
        "id": "1650544807877",
        "index": 0,
        "itemType": "pic",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 176.65207877461702
        },
        "gIdx": "1",
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/66c7c0847c33f7f95cb0035fe14c4405.json",
          "name": "monkey_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/98a8272cd2d97047b090ff10e948b978.json",
          "name": "monkey_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/c35ced408ad68a52c4ec5375373d3627.png",
          "name": "monkey_tex.png"
        },
        "rect": {
          "x": 128.83,
          "y": 171,
          "width": 0,
          "height": 0
        }
      }, {
        "id": "1650546079000",
        "index": 1,
        "audio_url": "https://teach.cdn.ireadabc.com/f9edc84a669688c5abddd55e2aab015d.mp3",
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "0",
        "labelText": "21.3",
        "posX": 692.4127500193598,
        "posY": 218.14695959185556,
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/e3c67a25dd3bb34fe113e126e6e1cc81.json",
          "name": "ox_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/81d487bf31d3a4d0f25f44c184ba9233.json",
          "name": "ox_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/e199392b52a735f6e37a6815ec3bb10e.png",
          "name": "ox_tex.png"
        },
        "rect": {
          "x": 159.34,
          "y": 138.66,
          "width": 38.83,
          "height": 38.83
        }
      }, {
        "id": "1650546232189",
        "index": 2,
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "1",
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/0a3ea93c62ff4087859ed587020c53b5.json",
          "name": "car_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/6000e4fbbb95f545afa5456c64d8c7d1.json",
          "name": "car_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/75e9972c15d2a67deedf60d448fd4e69.png",
          "name": "car_tex.png"
        },
        "rect": {
          "x": 36.4,
          "y": 78.56,
          "width": 184.87,
          "height": 184.87
        }
      }, {
        "id": "1650546321127",
        "index": 3,
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "1",
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/d4c1e1abcf3d8f5415747fd2599b8a8c.json",
          "name": "Chair_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/1d7254eb7fa3008e8178347bb944cdcb.json",
          "name": "Chair_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/48e85e8ff384eed72dfe865fc981e18c.png",
          "name": "Chair_tex.png"
        },
        "rect": {
          "x": 36.4,
          "y": 78.56,
          "width": 184.87,
          "height": 184.87
        }
      }, {
        "id": "1650546335240",
        "index": 4,
        "audio_url": "https://teach.cdn.ireadabc.com/6182d46bad09fccb8934217d33557204.mp3",
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "0",
        "labelText": "53",
        "posX": 452.5,
        "posY": 129,
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/b462d80c21aa75995dd99f0f43ccf1e6.json",
          "name": "quilt_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/866c9e2987870947fc63bce108ef157a.json",
          "name": "quilt_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/d952c37f40c3cf07e024edfd4416423e.png",
          "name": "quilt_tex.png"
        },
        "rect": {
          "x": 71.99,
          "y": 100.75,
          "width": 50.83,
          "height": 36.97
        }
      }, {
        "id": "1650546644333",
        "index": 5,
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "1",
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/6b8a1a7b0fd23686ea60465279cd4da0.json",
          "name": "robot_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/31a74ed95fe48adab00702675811c3a8.json",
          "name": "robot_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/e57052537d89356b0a79d8cb77980219.png",
          "name": "robot_tex.png"
        },
        "rect": {
          "x": 36.4,
          "y": 78.56,
          "width": 184.87,
          "height": 184.87
        }
      }, {
        "id": "1650546658697",
        "index": 6,
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "1",
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/bf3616060460439eeb3fd5227370e15a.json",
          "name": "panda_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/2dafeb25c973c910035ff7ed1a6a6334.json",
          "name": "panda_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/75d90b05345fa470285ac488cb205cfd.png",
          "name": "panda_tex.png"
        },
        "rect": {
          "x": 36.4,
          "y": 78.56,
          "width": 184.87,
          "height": 184.87
        }
      }, {
        "id": "1650546672448",
        "index": 7,
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "1",
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/5feff811b0117dd8e67973072e60d310.json",
          "name": "queen_1_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/bb5856b92b09c5fe7a1da00bb68134ca.json",
          "name": "queen_1_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/f4e5a138b086ef3dcfa57432543b66e9.png",
          "name": "queen_1_tex.png"
        },
        "animType": "dragonBone",
        "rect": {
          "x": 36.4,
          "y": 78.56,
          "width": 184.87,
          "height": 184.87
        }
      }, {
        "id": "1650546687069",
        "index": 8,
        "audio_url": "https://teach.cdn.ireadabc.com/301858df7b07e661426a006acb26059c.mp3",
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "0",
        "labelText": "42.5",
        "posX": 512.3883524629834,
        "posY": 259.83617125849,
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/f3a8efcd1850ee8a6cee89a18e86dc4a.json",
          "name": "milk_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/73b05f19d419bd3ac17c2b92dab88423.json",
          "name": "milk_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/e38375da46f85a23202d5cbc812d62e4.png",
          "name": "milk_tex.png"
        },
        "rect": {
          "x": 37.72,
          "y": 168.1,
          "width": 21.17,
          "height": 40.34
        }
      }, {
        "id": "1650547060490",
        "index": 9,
        "audio_url": "https://teach.cdn.ireadabc.com/05e5b29aeffa4ef94bcc5b23167aec90.mp3",
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "0",
        "labelText": "47.7",
        "posX": 483.22135734006736,
        "posY": 245.38039407076505,
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/99a6e6d9361eca7e51ed34ca2e0fd017.json",
          "name": "bird_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/6a379ddbe6df1806368c43c8ee82332d.json",
          "name": "bird_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/cf04c63104d89511902578944061f980.png",
          "name": "bird_tex.png"
        },
        "rect": {
          "x": 17.91,
          "y": 140.83,
          "width": 18.52,
          "height": 73.95
        }
      }, {
        "id": "1650547373869",
        "index": 10,
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "1",
        "labelText": "60",
        "posX": 420.5,
        "posY": 295,
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/7ebc28f3f339b16ca48d20f2a3eb44c1.json",
          "name": "alligator_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/b04e8206fd217bd22dcdac1008393317.json",
          "name": "alligator_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/b3990d94612bd3d6e25cf200f85e4334.png",
          "name": "alligator_tex.png"
        },
        "rect": {
          "x": 16.06,
          "y": 229.24,
          "width": 103.52,
          "height": 86.89
        }
      }, {
        "id": "1650547482398",
        "index": 11,
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "1",
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/a19f2ed7c297c70c639e54e969d64593.json",
          "name": "rabbit_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/4b4f8189cf79fadd7e6533ad84db96be.json",
          "name": "rabbit_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/8f953c861eac94e4e22a8e4ec3eb56b5.png",
          "name": "rabbit_tex.png"
        },
        "rect": {
          "x": 36.4,
          "y": 78.56,
          "width": 184.87,
          "height": 184.87
        }
      }, {
        "id": "1650547496232",
        "index": 12,
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "1",
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/89e0fc6085c294866142803b4ff267ba.json",
          "name": "King_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/d6cfd2d9cd2cd9aff09ab7f03e287421.json",
          "name": "King_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/8c02c3561a2eea0423cb1102200e76f9.png",
          "name": "King_tex.png"
        },
        "rect": {
          "x": 36.4,
          "y": 78.56,
          "width": 184.87,
          "height": 184.87
        }
      }, {
        "id": "1650547510648",
        "index": 13,
        "audio_url": "https://teach.cdn.ireadabc.com/717ee9713b18d32d38ee089c0abc85ea.mp3",
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "0",
        "labelText": "10.2",
        "posX": 641.6680134951944,
        "posY": 288.93672702541255,
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/3b7113ebdedcae54be6d0b9633875b88.json",
          "name": "net_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/fc810762f1f2025585e722e43e94137b.json",
          "name": "net_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/5c90820da4f559280fee4579e8db2dbc.png",
          "name": "net_tex.png"
        },
        "rect": {
          "x": 123.03,
          "y": 183.02,
          "width": 37.9,
          "height": 52.68
        }
      }, {
        "id": "1650547555018",
        "index": 14,
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "1",
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/0a5c8df5a23aca7a7540b87340c7608f.json",
          "name": "ostrich_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/2478573c91d1a83fa038e7f6a9db8a85.json",
          "name": "ostrich_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/4619ace67e5770e1fd7fc3ff76e7263e.png",
          "name": "ostrich_tex.png"
        },
        "rect": {
          "x": 36.4,
          "y": 78.56,
          "width": 184.87,
          "height": 184.87
        }
      }, {
        "id": "1650547573305",
        "index": 15,
        "audio_url": "https://teach.cdn.ireadabc.com/b7bc161c3a3ee143a53058691abf4fa9.mp3",
        "itemType": "rect",
        "fontScale": 0.70078125,
        "imgScale": 1,
        "imgSizeW": 0,
        "imgSizeH": 0,
        "mapScale": 0.70078125,
        "dragDot": {
          "x": 448.5,
          "y": 170.54984583761566
        },
        "gIdx": "0",
        "labelText": "15.9",
        "posX": 670.8119839772754,
        "posY": 137.87940870201697,
        "skeJsonData": {
          "url": "https://teach.cdn.ireadabc.com/91e8ca03d1df89e4ec2404421d4c692f.json",
          "name": "durazno_ske.json"
        },
        "texJsonData": {
          "url": "https://teach.cdn.ireadabc.com/32d259b0194370625f8fe94b1ddc0a85.json",
          "name": "durazno_tex.json"
        },
        "texPngData": {
          "url": "https://teach.cdn.ireadabc.com/8eef56b20e221a36fce1d672199859ff.png",
          "name": "durazno_tex.png"
        },
        "rect": {
          "x": 146.92,
          "y": 83.73,
          "width": 32.34,
          "height": 32.34
        }
      }]
    }; // return  {"begin_audio":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","begin_sep_time":1,"guide_audio":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","playing_audio":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","right_audio":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","wrong_audio":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","wrong_audio1":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","wrong_audio2":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","end_audio":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/84ec6edc20bceaaa9dbe824092b6860d.png","rect":{"x":736.95,"y":0,"width":599.09,"height":775}},"hotZoneItemArr":[{"id":"1659333645573","index":0,"audio_url":"http://staging-teach.cdn.ireadabc.com/5a1a2670845bfe76662e86d9a3a69f81.mp3","itemType":"rect","fontScale":1.61953125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.61953125,"dragDot":{"x":1036.5,"y":387.5},"gIdx":"1","labelText":"1","posX":887.5,"posY":165.5,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/133a1f60719ed26247e35dc022d82862.json","name":"spineboy-pro.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/e0945b8265ea3b8053afb814c6b849d3.atlas","name":"spineboy-pro.atlas"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/517553f50224915148f9efc5b7556798.png","name":"spineboy-pro.png"},"animType":"spine","rect":{"x":48.05,"y":65.5,"width":205,"height":200}},{"id":"1659334098930","index":1,"audio_url":"http://staging-teach.cdn.ireadabc.com/16eb06a6beb9e4fa77c9b5d2d643ab29.mp3","itemType":"rect","fontScale":1.61953125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.61953125,"dragDot":{"x":1036.5,"y":387.5},"gIdx":"0","labelText":"1","posX":1212.5,"posY":643.5,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/679fed26daa464819d553de6331b3552.json","name":"alien-pro.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/65d8214c6b5c5d0496e17adb0408276a.atlas","name":"alien-pro.atlas"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/a319b372899239325b90bb4ec07b4970.png","name":"alien-pro.png"},"animType":"spine","rect":{"x":375.56,"y":543.5,"width":200,"height":200}}]}
    // return defaultData;
  },
  preloadItem: function preloadItem() {
    this.addPreloadImage();
    this.addPreloadAudio();
    this.addPreloadAnima();
    this.preload();
  },
  addPreloadImage: function addPreloadImage() {
    this._imageResList.push({
      url: this.data.bgItem.url
    });

    for (var _iterator = _createForOfIteratorHelperLoose(this.data.hotZoneItemArr), _step; !(_step = _iterator()).done;) {
      var q = _step.value;

      if (q.gIdx == '0') {
        this._imageResList.push({
          url: q.texPngData.url
        });
      }

      if (q.gIdx == '1') {
        this._imageResList.push({
          url: q.texPngData.url
        });
      }

      if (q.gIdx == '2') {
        this._imageResList.push({
          url: q.pic_url
        });
      }
    }
  },
  prepareAudioClip: function prepareAudioClip(url, key) {
    var _this3 = this;

    if (url) {
      cc.assetManager.loadRemote(url, function (err, audioClip) {
        if (audioClip) {
          _this3[key] = audioClip;
        }
      });
    }
  },
  addPreloadAudio: function addPreloadAudio() {
    this._audioResList.push({
      url: this.data.begin_audio
    }); // this.prepareAudioClip(this.data.begin_audio1, 'begin_audio1')
    // this._audioResList.push({ url: this.data.begin_audio2 });
    // this.prepareAudioClip(this.data.begin_audio2, 'begin_audio2')


    this._audioResList.push({
      url: this.data.guide_audio
    });

    this._audioResList.push({
      url: this.data.playing_audio
    });

    if (this.data.wrong_audio) {
      this._audioResList.push({
        url: this.data.wrong_audio
      });

      this.wrongAudio = this.data.wrong_audio;
    }

    if (this.data.right_audio) {
      this._audioResList.push({
        url: this.data.right_audio
      });

      this.rightAudio = this.data.right_audio;
    }

    this._audioResList.push({
      url: this.data.wrong_audio1
    });

    this._audioResList.push({
      url: this.data.wrong_audio2
    });

    this._audioResList.push({
      url: this.data.end_audio
    });

    for (var _iterator2 = _createForOfIteratorHelperLoose(this.data.hotZoneItemArr), _step2; !(_step2 = _iterator2()).done;) {
      var q = _step2.value;

      if (q.gIdx == '0') {
        this._audioResList.push({
          url: q.audio_url
        });
      }
    }
  },
  debugPointer: function debugPointer() {
    var boxDebugger = cc.find('Canvas/box-debugger');

    if (!this.isDebug) {
      boxDebugger.active = false;
      return;
    }

    if (!this.POINTER_NODE) {
      this.POINTER_NODE = new cc.Node();
      this.POINTER_NODE.parent = boxDebugger;
      this.POINTER_NODE.name = 'POINTER_NODE';
      this.POINTER_NODE.addComponent(cc.Graphics);
    }

    var grap = this.POINTER_NODE.getComponent(cc.Graphics);
    grap.clear();
    var ground = cc.find('Canvas/frame-border/ground');
    var baseW = ground.width,
        baseH = ground.height;
    var _this$_lastFingerPosi = this._lastFingerPosition.pos,
        px = _this$_lastFingerPosi.x,
        py = _this$_lastFingerPosi.y;
    var x = baseW * px - baseW / 2;
    var y = baseH - baseH * py - baseH / 2 - 16;
    var pn = new cc.Node();
    grap.fillColor = cc.color(255, 0, 0);
    grap.circle(x, y, 32);
    grap.fill();
    grap.stroke();
  },
  debugGraphics: function debugGraphics() {
    var boxDebugger = cc.find('Canvas/box-debugger');

    if (!this.isDebug) {
      boxDebugger.active = false;
      return;
    }

    boxDebugger.active = true;
    console.log('show debug graphics');
    var ground = cc.find('Canvas/frame-border/ground');
    var canvas = cc.find('Canvas');
    var baseW = ground.width,
        baseH = ground.height;
    var _this$data$bgItem$rec = this.data.bgItem.rect,
        bgW = _this$data$bgItem$rec.width,
        bgH = _this$data$bgItem$rec.height;
    var scaleX = bgW / baseW;
    var scaleY = bgH / baseH;
    var added = false;
    this.data.hotZoneItemArr.forEach(function (area) {
      if (added) {// return
      }

      if (area.gIdx != '0') {
        return;
      }

      added = true;
      var dn = new cc.Node();
      var lblNode = new cc.Node();
      lblNode.parent = dn;
      var lbl = lblNode.addComponent(cc.Label);
      lblNode.color = cc.color(0, 0, 0);
      lbl.string = area.skeJsonData.name.substring(0, area.skeJsonData.name.length - 9);
      dn.name = lbl.string;
      dn.parent = boxDebugger;
      dn.width = baseW;
      dn.height = baseH;
      var grap = dn.addComponent(cc.Graphics);
      var r = (0, _util.RandomInt)(1, 255);
      var g = (0, _util.RandomInt)(1, 255);
      var b = (0, _util.RandomInt)(1, 255);
      grap.fillColor = cc.color(r, g, b, 127);
      var _area$rect = area.rect,
          rx = _area$rect.x,
          ry = _area$rect.y,
          rw = _area$rect.width,
          rh = _area$rect.height;
      var w = rw / bgW * baseW;
      var h = rh / bgH * baseH;
      var x = rx / bgW * baseW - baseW / 2;
      var y = baseH - ry / bgH * baseH - h - baseH / 2; // w *= scaleX
      // h *= scaleY
      // x *= scaleX
      // y *= scaleY
      // const p = boxDebugger.convertToNodeSpaceAR(cc.v2(x,y));
      // x = p.x;
      // y = p.y;

      lblNode.x = x;
      lblNode.y = y + h; // dn.scaleX = scaleX;
      // dn.scaleY = scaleY;
      // dn.scale = area.mapScale; // minScale; // this._mapScaleMax * area.mapScale; // ;

      console.log('[debug]', area.skeJsonData.name, x, y, w, h);
      grap.fillRect(x, y, w, h);
      grap.stroke();
    });
  },
  addPreloadAnima: function addPreloadAnima() {},
  preload: function preload() {
    var _this4 = this;

    var preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList); // console.log(preloadArr);


    cc.assetManager.loadAny(preloadArr, null, function (f, t, item) {// console.log(f, t, item)
    }, function (err, data) {
      // console.log(err, data);
      var ground = cc.find("Canvas/frame-border/ground");
      var groundBg = cc.find("Canvas/frame-border/ground/bg");
      groundBg.active = false;
      var baseRect = _this4.data.bgItem.rect;
      (0, _util.getSpriteFrimeByUrl)(_this4.data.bgItem.url, function (sf) {
        var gs = groundBg.getComponent(cc.Sprite);
        gs.spriteFrame = sf;
        groundBg.active = true;
        var dbCount = 0;
        var finishDbCount = 0;

        for (var _iterator3 = _createForOfIteratorHelperLoose(_this4.data.hotZoneItemArr), _step3; !(_step3 = _iterator3()).done;) {
          var block = _step3.value;

          if (block.gIdx == '0' || block.gIdx == '1') {
            dbCount++;
          }
        }

        for (var _iterator4 = _createForOfIteratorHelperLoose(_this4.data.hotZoneItemArr), _step4; !(_step4 = _iterator4()).done;) {
          var _block = _step4.value;

          if (_block.gIdx == '2') {
            (function () {
              var s1 = (ground.width / _block.imgSizeW + ground.height / _block.imgSizeH) / 2;
              var node = new cc.Node();
              node.parent = ground;
              var spr = node.addComponent(cc.Sprite);
              (0, _util.getSpriteFrimeByUrl)(_block.pic_url, function (sf) {
                spr.spriteFrame = sf;
                node.scale = s1;
              });
            })();
          }

          if (_block.gIdx == '0' || _block.gIdx == '1') {
            (function () {
              var n = new cc.Node(); // n.scale = 0.25;

              n.scale = ground.width / groundBg.width;
              n.parent = ground;
              n.active = false;

              if (_block.animType == 'spine') {
                var skeleton = n.addComponent(sp.Skeleton);
                n.isSpine = true;
                (0, _util.loadSpine)(skeleton, _block.texPngData.name, {
                  tex: _block.texPngData.url,
                  atlas: _block.texJsonData.url,
                  ske: _block.skeJsonData.url
                }).then(function (_ref) {
                  var width = _ref.width,
                      height = _ref.height;
                  n.width = width;
                  n.height = height;
                  n.active = true; // db.playAnimation('null', 0);
                  // skeleton.setToSetupPose();
                  // skeleton.setAnimation(0, 'enlarge', true);				

                  _this4._allAnimationNodes.push(n);

                  finishDbCount++;
                  console.log(finishDbCount, dbCount);

                  if (finishDbCount == dbCount) {
                    _this4.loadEnd();
                  }
                })["catch"](function () {
                  finishDbCount++;
                  console.log(finishDbCount, dbCount);

                  if (finishDbCount == dbCount) {
                    _this4.loadEnd();
                  }
                });
              } else {
                var db = n.addComponent(dragonBones.ArmatureDisplay);
                (0, _util.loadDragonBones)(db, {
                  tex: _block.texPngData.url,
                  atlas: _block.texJsonData.url,
                  ske: _block.skeJsonData.url
                }).then(function (_ref2) {
                  var width = _ref2.width,
                      height = _ref2.height;
                  n.width = width;
                  n.height = height;
                  n.active = true;
                  db.playAnimation('null', 0);

                  _this4._allAnimationNodes.push(n);

                  finishDbCount++;
                  console.log(finishDbCount, dbCount);

                  if (finishDbCount == dbCount) {
                    _this4.loadEnd();
                  }
                })["catch"](function () {
                  finishDbCount++;
                  console.log(finishDbCount, dbCount);

                  if (finishDbCount == dbCount) {
                    _this4.loadEnd();
                  }
                });
              }

              if (_block.gIdx == '0') {
                var rectInfo = {
                  node: n,
                  audio_url: _block.audio_url,
                  rect: {
                    x: _block.rect.x / baseRect.width,
                    y: _block.rect.y / baseRect.height,
                    width: _block.rect.width / baseRect.width,
                    height: _block.rect.height / baseRect.height
                  }
                };

                _this4._figurePointRectArray.push(rectInfo); // this.addRectNodeListener(block);


                if (_block.labelText) {
                  var k = +_block.labelText * 1000;

                  if (!isNaN(k)) {
                    _this4._hintsNodeList.push({
                      node: n,
                      after: k
                    });
                  }
                }
              }
            })();
          }
        }
      }); // console.log(this.data);

      console.log('resource perload finish'); // <<<<<<< HEAD
      // =======
      // 			if (window && window["air"]) {
      // 				// cc.find('Canvas').opacity = 0;
      // 				window.air.onCourseInScreen = (next) => {
      // 					// cc.find('Canvas').opacity = 255;
      // 					this.loadEnd();
      // 					next();
      // 				}
      // 				window.air.hideAirClassLoading();
      // 			} else {
      // 				this.loadEnd();
      // 			}
      // >>>>>>> 2d461e1910571bcfc6ad4dc93c2cedafc20923ea

      cc.debug.setDisplayStats(false);
    });
  },
  loadEnd: function loadEnd() {
    if (window && window["air"] && window["air"].hideAirClassLoading) {
      window["air"].hideAirClassLoading();
    }

    this.initData(); // this.initAudio();
    // this.initView();

    this.initBg(); // this.initListener();

    this.debugGraphics();
    this.createStateMachine();
  },
  _cantouch: null,
  initData: function initData() {
    // 所有全局变量 默认都是null 
    this._cantouch = true;
  },
  // audioBtn: null,
  // initAudio() {
  // 	const audioNode = cc.find('Canvas/res/audio');
  // 	const getAudioByResName = (resName) => {
  // 		return audioNode.getChildByName(resName).getComponent(cc.AudioSource);
  // 	}
  // 	this.audioBtn = getAudioByResName('btn');
  // },
  // initView() {
  // 	// this.initBg();
  // 	// this.initPic();
  // 	// this.initBtn();
  // 	this.initIcon();
  // },
  addRectNodeListener: function addRectNodeListener(data) {
    var _this5 = this;

    var bg = cc.find("Canvas/frame-border/ground/bg").parent;
    var rate = bg.scale * bg.width / this.data.bgItem.rect.width;
    var rectNode = new cc.Node();
    rectNode.name = 'rect' + data.index;
    bg.addChild(rectNode, 20);
    var ctx = rectNode.addComponent(cc.Graphics); // 红色矩形

    ctx.lineWidth = 4;
    ctx.strokeColor = cc.Color.BLACK;
    ctx.fillColor = cc.Color.WHITE.setA(100);
    var scale = rate / bg.scaleY;
    console.log('scale~ : ', scale);
    rectNode.width = data.rect.width * scale;
    rectNode.height = data.rect.height * scale;
    rectNode.x = -bg.width / 2 + data.rect.x * scale + bg.x;
    rectNode.y = bg.height / 2 - data.rect.height * scale - data.rect.y * scale + bg.y;
    rectNode.anchorX = rectNode.anchorY = 0;
    console.log('data: ', data);
    console.log('rectNode: ', rectNode); // if (pageData.bgItem.isShowDebugLine) {

    ctx.rect(0, 0, rectNode.width, rectNode.height); // ctx.fillRect(0, 0, 200, 200);
    // }

    ctx.stroke();
    ctx.fill();
    rectNode.addComponent(cc.Button);
    rectNode.on("click", function () {
      console.log(" in rectNode click");

      var _x = rectNode.x / bg.width;

      var _y = rectNode.y / bg.height;

      var _w = rectNode.width / bg.width;

      var _h = rectNode.height / bg.height;

      var pos = {
        x: _x + _w / 2 + 0.5,
        y: -(_y + _h / 2 - 0.5)
      };
      _this5._lastFingerPosition = {
        pos: pos,
        dirty: true
      };
    });
  },
  initBg: function initBg() {
    var bgNode = cc.find('Canvas/bg');
    bgNode.scale = this._mapScaleMax;
    console.log('this._mapScaleMax', this._mapScaleMax);
  },

  /*initBtn() {
  		this.curPage = 0;
  	const bottomPart = cc.find('Canvas/bottomPart');
  	bottomPart.zIndex = 5; // 提高层级
  		bottomPart.x = bottomPart.parent.width / 2;
  	bottomPart.y = -bottomPart.parent.height / 2;
  		const leftBtnNode = bottomPart.getChildByName('btn_left');
  	//节点中添加了button组件 则可以添加click事件监听
  	leftBtnNode.on('click', () => {
  		if (!this._cantouch) {
  			return;
  		}
  		if (this.curPage == 0) {
  			return;
  		}
  		this.curPage = 0
  		this.leftMove();
  			// 游戏结束时需要调用这个方法通知系统作业完成
  		onHomeworkFinish();
  			cc.audioEngine.play(this.audioBtn.clip, false, 0.8)
  	})
  		const rightBtnNode = bottomPart.getChildByName('btn_right');
  	//节点中添加了button组件 则可以添加click事件监听
  	rightBtnNode.on('click', () => {
  		if (!this._cantouch) {
  			return;
  		}
  		if (this.curPage == 1) {
  			return;
  		}
  			this.curPage = 1
  		this.rightMove();
  			cc.audioEngine.play(this.audioBtn.clip, false, 0.5)
  	})
  },*/
  // update (dt) {},
  _timeoutIds: null,
  _intervalIds: null,
  // 生命周期
  onDestroy: function onDestroy() {
    console.log('op15 onDestroy');

    this._timeoutIds.forEach(function (id) {
      clearTimeout(id);
    });

    this._intervalIds.forEach(function (id) {
      clearInterval(id);
    });

    this.gameMachineService.stopChild();
    this.gameMachineService.stop();

    if (window.courseware && window.courseware.closeOsmoFingerRead) {
      if (this.isOpenedOsmoFingerRead) {
        window.courseware.closeOsmoFingerRead();
      }
    }
  }
});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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