
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/OP15/scene/OP15.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'ddbf4iIJnhHIImfp+SKRF1C', 'OP15');
// OP15/scene/OP15.js

"use strict";

var _util = require("../script/util");

var _defaultData = require("../script/defaultData");

var _xstate = require("../script/xstate");

function _createForOfIteratorHelperLoose(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } it = o[Symbol.iterator](); return it.next.bind(it); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var pure = _xstate.actions.pure,
    send = _xstate.actions.send,
    raise = _xstate.actions.raise,
    sendParent = _xstate.actions.sendParent;
cc.Class({
  "extends": cc.Component,
  properties: {
    /*ant: {
    	default: null,
    	type: cc.Node,
    },
    apple: {
    	default: null,
    	type: cc.Node,
    },
    bird: {
    	default: null,
    	type: cc.Node,
    },
    car: {
    	default: null,
    	type: cc.Node,
    },
    cat: {
    	default: null,
    	type: cc.Node,
    },
    cow: {
    	default: null,
    	type: cc.Node,
    },
    duck: {
    	default: null,
    	type: cc.Node,
    },
    egg: {
    	default: null,
    	type: cc.Node,
    },
    farmer: {
    	default: null,
    	type: cc.Node,
    },
    fish: {
    	default: null,
    	type: cc.Node,
    },
    girl: {
    	default: null,
    	type: cc.Node,
    },
    hen: {
    	default: null,
    	type: cc.Node,
    },
    house: {
    	default: null,
    	type: cc.Node,
    },*/
    rightAudio: {
      "default": null,
      type: cc.AudioClip
    },
    wrongAudio: {
      "default": null,
      type: cc.AudioClip
    },
    logoCat: {
      "default": null,
      type: cc.Node
    }
  },
  playAni: function playAni(idx, name, options) {
    var times = options && options.times || 1;
    var cb = options && options.callback || null; // const cat = cc.find(`Canvas/frame-border/ground/${node}`);

    var node = this._figurePointRectArray[idx].node;
    var dragonDisplay = node.getComponent(dragonBones.ArmatureDisplay);
    var state = dragonDisplay.playAnimation(name, times); // dragonDisplay.addEventListener(dragonBones.EventObject.COMPLETE, (event) => {
    // 	//TODO 这里写触发事件
    // 	//event.name为事件名称
    // 	console.log(event.name)
    // }, this);
    // animationDisplay.addEventListener(dragonBones.EventObject.COMPLETE, completeCallback);

    return state;
  },
  // 生命周期 onLoad
  onLoad: function onLoad() {
    this._timeoutIds = [];
    this._intervalIds = [];
    this.initSceneData();
    this.initSize();
    window.ccc = this;
  },
  _imageResList: null,
  _audioResList: null,
  _animaResList: null,
  _lastFingerPosition: null,
  _hintsNodeList: null,
  _figurePointRectArray: null,
  _allAnimationNodes: null,
  initSceneData: function initSceneData() {
    this._imageResList = [];
    this._audioResList = [];
    this._animaResList = [];
    this._allAnimationNodes = [];
    this._hintsNodeList = [];
    this._lastFingerPosition = {
      pos: null,
      dirty: false
    };
    this._figurePointRectArray = [];
  },
  _designSize: null,
  // 设计分辨率
  _frameSize: null,
  // 屏幕分辨率
  _mapScaleMin: null,
  // 场景中常用缩放（取大值）
  _mapScaleMax: null,
  // 场景中常用缩放（取小值）
  _cocosScale: null,
  // cocos 自缩放 （较少用到）
  initSize: function initSize() {
    // 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
    var screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height;
    var design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height;
    var f = screen_size >= design_size;
    cc.Canvas.instance.fitHeight = f;
    cc.Canvas.instance.fitWidth = !f;
    var frameSize = cc.view.getFrameSize();
    this._frameSize = frameSize;
    this._designSize = cc.view.getDesignResolutionSize();
    var sx = cc.winSize.width / frameSize.width;
    var sy = cc.winSize.height / frameSize.height;
    this._cocosScale = Math.min(sx, sy);
    sx = frameSize.width / this._designSize.width;
    sy = frameSize.height / this._designSize.height;
    this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
    this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;
  },
  createStateMachine: function createStateMachine() {
    var _this = this;

    var check = [{
      target: '#game.end',
      cond: function cond(ctx, evt) {
        console.log('[answer NEXT] check if end', ctx.questionIndex >= ctx.questionsCount - 1);
        return ctx.questionIndex >= ctx.questionsCount - 1;
      }
    }, {
      target: 'hint'
    } // reenter 'hint' state
    ];
    var QuestionState = {
      id: 'question',
      initial: 'hint',
      states: {
        hint: {
          invoke: {
            src: function src(ctx, event) {
              console.log("[hint] play question " + ctx.questionIndex + ": " + ctx.questionPlayTimes + " audio");
              ctx.questionPlayTimes += 1;
              return new Promise(function (resolve, reject) {
                (0, _util.playAudioByUrl)(ctx.questions[ctx.questionIndex].audio_url, function () {
                  console.log('hint finish');
                  resolve();
                });
              });
            },
            onDone: 'answer',
            onError: 'answer'
          }
        },
        answer: {
          after: {
            8000: [{
              target: 'wrong'
            } // reenter 'hint' state
            ]
          },
          invoke: {
            src: function src(context, event) {
              return function (callback, onReceive) {
                console.log('[answer] thinking and playing'); // check every second

                var id = setInterval(function () {
                  if (!_this._lastFingerPosition.dirty) {
                    return;
                  }

                  var region = context.questions[context.questionIndex];

                  var result = _this.checkInRegion(region.rect);

                  if (result === null) {
                    return;
                  }

                  console.log('[Genise JS] checkInRegion' + result);

                  if (result) {
                    callback('RIGHT');
                  } else {
                    callback('WRONG');
                  }
                }, 300);

                _this._intervalIds.push(id); // Perform cleanup


                return function () {
                  return clearInterval(id);
                };
              };
            }
          },
          on: {
            RIGHT: {
              target: 'right'
            },
            WRONG: {
              target: 'wrong'
            }
          }
        },
        right: {
          invoke: {
            src: function src(context, event) {
              _this._lastFingerPosition.pos = null;
              _this._lastFingerPosition.dirty = false;
              return new Promise(function (resolve, reject) {
                console.log('answer right'); // this.playAni(context.questionIndex, 'normal')

                var an = context.questions[context.questionIndex].node;
                console.log('in right ' + typeof an);
                an.active = true;
                var dragonDisplay = an.getComponent(dragonBones.ArmatureDisplay);
                dragonDisplay.playAnimation('normal', 0);

                var ddLogoCat = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

                ddLogoCat.playAnimation('right', 1);
                ddLogoCat.once(dragonBones.EventObject.COMPLETE, function () {
                  this.logoCat.getComponent(dragonBones.ArmatureDisplay).playAnimation('normal', 0);
                }, _this);
                (0, _util.playAudioByUrl)(_this.rightAudio, function () {
                  resolve();
                });
              });
            },
            onDone: {
              target: '#QuestionsArray.next',
              actions: raise('CHECK')
            },
            onError: {
              target: '#QuestionsArray.next',
              actions: raise('CHECK')
            }
          }
        },
        wrong: {
          invoke: {
            src: function src(context, event) {
              _this._lastFingerPosition.pos = null;
              _this._lastFingerPosition.dirty = false;
              return new Promise(function (resolve, reject) {
                console.log('answer wrong', context.questionIndex, context.questionPlayTimes, context.maxQuestionTryTimes);

                var ddLogoCat = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

                ddLogoCat.playAnimation('wrong', 1);
                ddLogoCat.once(dragonBones.EventObject.COMPLETE, function () {
                  this.logoCat.getComponent(dragonBones.ArmatureDisplay).playAnimation('normal', 0);
                }, _this);
                var wrongEffect = _this.wrongAudio; // 第一和第二题的提示音

                if ([0, 1].includes(context.questionIndex)) {
                  wrongEffect = _this.data["wrong_audio" + context.questionPlayTimes];
                } else {
                  // 非第一和第二题，并且做第二遍的提示音
                  if (context.questionPlayTimes == 2) {
                    wrongEffect = _this.data["wrong_audio" + context.questionPlayTimes];
                  }
                }

                if (context.questionPlayTimes >= context.maxQuestionTryTimes) {
                  var an = context.questions[context.questionIndex].node;
                  an.active = true;
                  var dragonDisplay = an.getComponent(dragonBones.ArmatureDisplay);
                  dragonDisplay.playAnimation('normal', 0);
                  console.log('show animation', an.active);
                }

                (0, _util.playAudioByUrl)(wrongEffect, function () {
                  if (context.questionPlayTimes >= context.maxQuestionTryTimes) {
                    // const an = context.questions[context.questionIndex].node;
                    // an.active = true;
                    // const dragonDisplay = an.getComponent(dragonBones.ArmatureDisplay);
                    // dragonDisplay.playAnimation('normal', 0);
                    // console.log('show animation', an.active);
                    reject();
                  } else {
                    resolve();
                  }
                });
              });
            },
            onDone: {
              target: 'hint' // actions: raise('CHECK')

            },
            onError: {
              target: '#QuestionsArray.next',
              actions: raise('CHECK')
            }
          }
        }
      }
    };
    var QuestionsArrayStatus = {
      id: 'QuestionsArray',
      initial: 'play',
      states: {
        play: _extends({}, QuestionState),
        next: {
          on: {
            CHECK: [{
              target: '#game.end',
              cond: function cond(ctx, evt) {
                ctx.questionIndex += 1;
                ctx.questionPlayTimes = 0;
                console.log('#game.end', ctx.questionIndex >= ctx.questionsCount);
                return ctx.questionIndex >= ctx.questionsCount;
              }
            }, {
              target: 'play'
            }]
          }
        }
      }
    };
    var state = {
      id: 'game',
      initial: 'begin',
      context: {
        questionIndex: 0,
        questionPlayTimes: 0,
        maxQuestionTryTimes: 2,
        questionsCount: this._figurePointRectArray.length,
        questions: this._figurePointRectArray
      },
      states: {
        begin: {
          invoke: {
            src: function src(ctx) {
              console.log('game begin 1');

              if (window.courseware && window.courseware.openOsmoFingerRead) {
                _this.isOpenedOsmoFingerRead = true;
                window.courseware.openOsmoFingerRead({
                  "page_id": 27,
                  "book_id": "opw1"
                });
              }

              var dragonDisplay = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

              var state = dragonDisplay.playAnimation('begin', 0);
              return new Promise(function (resolve, reject) {
                (0, _util.playAudioByUrl)(_this.data.begin_audio, function () {
                  console.log('game begin audio finish');
                  resolve();
                });
              });
            },
            onDone: 'guide',
            onError: 'guide'
          }
        },
        guide: {
          invoke: {
            src: function src(ctx) {
              return new Promise(function (resolve, reject) {
                (0, _util.playAudioByUrl)(_this.data.guide_audio, function () {
                  console.log('game guide audio finish');
                  reject();
                });
              });
            },
            onDone: 'playing',
            onError: 'playing'
          }
        },
        playing: _extends({
          entry: function entry(ctx) {
            console.log('entry play stage');

            var dragonDisplay = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

            var state = dragonDisplay.playAnimation('normal', 0);
            cc.assetManager.loadRemote(_this.data.playing_audio, function (err, audioClip) {
              cc.audioEngine.playMusic(audioClip, true, 0.8);
            });
            ctx.questions.forEach(function (block) {
              block.node.active = false;
            });
          },
          exit: function exit() {
            console.log('exit play stage');
            cc.audioEngine.stopMusic();
          },
          on: {
            NEXT: 'end'
          }
        }, QuestionsArrayStatus),
        end: {
          entry: function entry(ctx, event) {
            console.log('game end');

            var dragonDisplay = _this.logoCat.getComponent(dragonBones.ArmatureDisplay);

            var state = dragonDisplay.playAnimation('finish', 0);

            if (window.courseware && window.courseware.closeOsmoFingerRead) {
              _this.isOpenedOsmoFingerRead = false;
              window.courseware.closeOsmoFingerRead();
            }

            (0, _util.playAudioByUrl)(_this.data.end_audio, function () {
              console.log('game finish');
            }); // return new Promise((resolve,reject) => {
            // 	setTimeout(() => {
            // 		console.log('hint finish');
            // 		resolve()
            // 	}, 2000)
            // })
          }
        }
      }
    };
    var after = {};

    var _loop = function _loop(i) {
      var t = _this._hintsNodeList[i].node;
      var k = _this._hintsNodeList[i].after;
      after[k] = {
        actions: function actions() {
          var dragonDisplay = t.getComponent(dragonBones.ArmatureDisplay);
          dragonDisplay.playAnimation('enlarge', 1);
          console.log(dragonDisplay._armatureKey, 'enlarge');
          dragonDisplay.addEventListener(dragonBones.EventObject.COMPLETE, function (event) {// TODO 这里写触发事件
            // event.name为事件名称
            // event.armature.animation.play('normal', 0);
            // console.log(event.animationState.name, dragonDisplay._armatureKey, 'end')
          }, _this); // const dragonDisplay = t.getComponent(dragonBones.ArmatureDisplay);
          // dragonDisplay.playAnimation('enlarge', 1);
          // console.log(dragonDisplay._armatureKey, 'enlarge')
          // dragonDisplay.addEventListener(dragonBones.EventObject.COMPLETE, (event) => {
          // 	//TODO 这里写触发事件
          // 	//event.name为事件名称
          // 	event.armature.animation.play('normal', 0);
          // 	console.log(event.animationState.name, dragonDisplay._armatureKey, 'end')
          // }, this);
        }
      };
    };

    for (var i = 0; i < this._hintsNodeList.length; i++) {
      _loop(i);
    }

    if (this.data.begin_sep_time) {
      var t = +this.data.begin_sep_time * 1000;
      after[t] = {
        actions: function actions() {
          console.log('game begin 2');

          for (var _i = 0; _i < _this._allAnimationNodes.length; _i++) {
            var _t = _this._allAnimationNodes[_i];

            var dragonDisplay = _t.getComponent(dragonBones.ArmatureDisplay);

            dragonDisplay.playAnimation('normal', 0);
          }
        }
      };
    }

    state.states.begin.after = after;
    var gameMachine = (0, _xstate.createMachine)(state);
    window.gameMachine = gameMachine;
    this.gameMachineService = (0, _xstate.interpret)(gameMachine).onTransition(function (state) {// console.log(1, state.value, state.context);
    });
    this.gameMachineService.start();
    window.gameMachineService = gameMachineService;
  },
  // 生命周期 start
  start: function start() {
    var _this2 = this;

    var getData = this.getData.bind(this);

    if (window && window.courseware) {
      getData = window.courseware.getData;
    }

    getData(function (data) {
      // console.log('data:', data);
      _this2.data = data || _this2.getDefaultData();
      _this2.data = JSON.parse(JSON.stringify(_this2.data));

      _this2.preloadItem();
    });
    window.air = window.air || {};

    if (window.air) {
      window.air.osmoFingerReadCallback = function (result) {
        if (!_this2.gameMachineService) {
          return;
        } // const st = this.gameMachineService.state.value.constructor.name == 'Object' 
        // && this.gameMachineService.state.value['playing']
        // && this.gameMachineService.state.value['playing'].constructor.name == 'Object'
        // && this.gameMachineService.state.value['playing']['play']
        // && this.gameMachineService.state.value['playing']['play'] == 'answer'
        // if (st) {
        // }


        var resultObj = JSON.parse(result);
        console.log('[Genise JS] ' + JSON.stringify(resultObj.finger_pos_in_page));
        var p = resultObj.finger_pos_in_page;

        if (p.x == -1 || p.y == -1) {
          _this2._lastFingerPosition.pos = null;
          _this2._lastFingerPosition.dirty = false;
          return;
        }

        _this2._lastFingerPosition = {
          pos: {
            x: p.x,
            y: p.y
          },
          dirty: true
        };

        _this2.debugPointer(p.x, p.y);
      };
    }

    this.isDebug = false;
  },
  checkInRegion: function checkInRegion(r) {
    if (!this._lastFingerPosition && !this._lastFingerPosition.pos) {
      return null;
    }

    var p = this._lastFingerPosition ? this._lastFingerPosition.pos || {
      x: 0,
      y: 0
    } : {
      x: 0,
      y: 0
    };
    var w = p.x > r.x && p.x < r.x + r.width;
    var h = p.y > r.y && p.y < r.y + r.height;
    return w && h;
  },
  getData: function getData(func) {
    if (window && window.courseware) {
      window.courseware.getData(func, 'scene');
      return;
    }

    var middleLayer = cc.find('middleLayer');

    if (middleLayer) {
      var middleLayerComponent = middleLayer.getComponent('middleLayer');
      middleLayerComponent.getData(func);
      return;
    }

    func(this.getDefaultData());
  },
  getDefaultData: function getDefaultData() {
    return _defaultData.defaultData;
  },
  preloadItem: function preloadItem() {
    this.addPreloadImage();
    this.addPreloadAudio();
    this.addPreloadAnima();
    this.preload();
  },
  addPreloadImage: function addPreloadImage() {
    this._imageResList.push({
      url: this.data.bgItem.url
    });

    for (var _iterator = _createForOfIteratorHelperLoose(this.data.hotZoneItemArr), _step; !(_step = _iterator()).done;) {
      var q = _step.value;

      if (q.gIdx == '0') {
        this._imageResList.push({
          url: q.texPngData.url
        });
      }

      if (q.gIdx == '1') {
        this._imageResList.push({
          url: q.texPngData.url
        });
      }

      if (q.gIdx == '2') {
        this._imageResList.push({
          url: q.pic_url
        });
      }
    }
  },
  prepareAudioClip: function prepareAudioClip(url, key) {
    var _this3 = this;

    if (url) {
      cc.assetManager.loadRemote(url, function (err, audioClip) {
        if (audioClip) {
          _this3[key] = audioClip;
        }
      });
    }
  },
  addPreloadAudio: function addPreloadAudio() {
    this._audioResList.push({
      url: this.data.begin_audio
    }); // this.prepareAudioClip(this.data.begin_audio1, 'begin_audio1')
    // this._audioResList.push({ url: this.data.begin_audio2 });
    // this.prepareAudioClip(this.data.begin_audio2, 'begin_audio2')


    this._audioResList.push({
      url: this.data.guide_audio
    });

    this._audioResList.push({
      url: this.data.playing_audio
    });

    if (this.data.wrong_audio) {
      this._audioResList.push({
        url: this.data.wrong_audio
      });

      this.wrongAudio = this.data.wrong_audio;
    }

    if (this.data.right_audio) {
      this._audioResList.push({
        url: this.data.right_audio
      });

      this.rightAudio = this.data.right_audio;
    }

    this._audioResList.push({
      url: this.data.wrong_audio1
    });

    this._audioResList.push({
      url: this.data.wrong_audio2
    });

    this._audioResList.push({
      url: this.data.end_audio
    });

    for (var _iterator2 = _createForOfIteratorHelperLoose(this.data.hotZoneItemArr), _step2; !(_step2 = _iterator2()).done;) {
      var q = _step2.value;

      if (q.gIdx == '0') {
        this._audioResList.push({
          url: q.audio_url
        });
      }
    }
  },
  debugPointer: function debugPointer() {
    var boxDebugger = cc.find('Canvas/box-debugger');

    if (!this.isDebug) {
      boxDebugger.active = false;
      return;
    }

    if (!this.POINTER_NODE) {
      this.POINTER_NODE = new cc.Node();
      this.POINTER_NODE.parent = boxDebugger;
      this.POINTER_NODE.name = 'POINTER_NODE';
      this.POINTER_NODE.addComponent(cc.Graphics);
    }

    var grap = this.POINTER_NODE.getComponent(cc.Graphics);
    grap.clear();
    var ground = cc.find('Canvas/frame-border/ground');
    var baseW = ground.width,
        baseH = ground.height;
    var _this$_lastFingerPosi = this._lastFingerPosition.pos,
        px = _this$_lastFingerPosi.x,
        py = _this$_lastFingerPosi.y;
    var x = baseW * px - baseW / 2;
    var y = baseH - baseH * py - baseH / 2 - 16;
    var pn = new cc.Node();
    grap.fillColor = cc.color(255, 0, 0);
    grap.circle(x, y, 32);
    grap.fill();
    grap.stroke();
  },
  debugGraphics: function debugGraphics() {
    var boxDebugger = cc.find('Canvas/box-debugger');

    if (!this.isDebug) {
      boxDebugger.active = false;
      return;
    }

    boxDebugger.active = true;
    console.log('show debug graphics');
    var ground = cc.find('Canvas/frame-border/ground');
    var canvas = cc.find('Canvas');
    var baseW = ground.width,
        baseH = ground.height;
    var _this$data$bgItem$rec = this.data.bgItem.rect,
        bgW = _this$data$bgItem$rec.width,
        bgH = _this$data$bgItem$rec.height;
    var scaleX = bgW / baseW;
    var scaleY = bgH / baseH;
    var added = false;
    this.data.hotZoneItemArr.forEach(function (area) {
      if (added) {// return
      }

      if (area.gIdx != '0') {
        return;
      }

      added = true;
      var dn = new cc.Node();
      var lblNode = new cc.Node();
      lblNode.parent = dn;
      var lbl = lblNode.addComponent(cc.Label);
      lblNode.color = cc.color(0, 0, 0);
      lbl.string = area.skeJsonData.name.substring(0, area.skeJsonData.name.length - 9);
      dn.name = lbl.string;
      dn.parent = boxDebugger;
      dn.width = baseW;
      dn.height = baseH;
      var grap = dn.addComponent(cc.Graphics);
      var r = (0, _util.RandomInt)(1, 255);
      var g = (0, _util.RandomInt)(1, 255);
      var b = (0, _util.RandomInt)(1, 255);
      grap.fillColor = cc.color(r, g, b, 127);
      var _area$rect = area.rect,
          rx = _area$rect.x,
          ry = _area$rect.y,
          rw = _area$rect.width,
          rh = _area$rect.height;
      var w = rw / bgW * baseW;
      var h = rh / bgH * baseH;
      var x = rx / bgW * baseW - baseW / 2;
      var y = baseH - ry / bgH * baseH - h - baseH / 2; // w *= scaleX
      // h *= scaleY
      // x *= scaleX
      // y *= scaleY
      // const p = boxDebugger.convertToNodeSpaceAR(cc.v2(x,y));
      // x = p.x;
      // y = p.y;

      lblNode.x = x;
      lblNode.y = y + h; // dn.scaleX = scaleX;
      // dn.scaleY = scaleY;
      // dn.scale = area.mapScale; // minScale; // this._mapScaleMax * area.mapScale; // ;

      console.log('[debug]', area.skeJsonData.name, x, y, w, h);
      grap.fillRect(x, y, w, h);
      grap.stroke();
    });
  },
  addPreloadAnima: function addPreloadAnima() {},
  preload: function preload() {
    var _this4 = this;

    var preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList); // console.log(preloadArr);


    cc.assetManager.loadAny(preloadArr, null, function (f, t, item) {// console.log(f, t, item)
    }, function (err, data) {
      // console.log(err, data);
      var ground = cc.find("Canvas/frame-border/ground");
      var groundBg = cc.find("Canvas/frame-border/ground/bg");
      groundBg.active = false;
      var baseRect = _this4.data.bgItem.rect;
      (0, _util.getSpriteFrimeByUrl)(_this4.data.bgItem.url, function (sf) {
        var gs = groundBg.getComponent(cc.Sprite);
        gs.spriteFrame = sf;
        groundBg.active = true;
        var dbCount = 0;
        var finishDbCount = 0;

        for (var _iterator3 = _createForOfIteratorHelperLoose(_this4.data.hotZoneItemArr), _step3; !(_step3 = _iterator3()).done;) {
          var block = _step3.value;

          if (block.gIdx == '0' || block.gIdx == '1') {
            dbCount++;
          }
        }

        for (var _iterator4 = _createForOfIteratorHelperLoose(_this4.data.hotZoneItemArr), _step4; !(_step4 = _iterator4()).done;) {
          var _block = _step4.value;

          if (_block.gIdx == '2') {
            (function () {
              var s1 = (ground.width / _block.imgSizeW + ground.height / _block.imgSizeH) / 2;
              var node = new cc.Node();
              node.parent = ground;
              var spr = node.addComponent(cc.Sprite);
              (0, _util.getSpriteFrimeByUrl)(_block.pic_url, function (sf) {
                spr.spriteFrame = sf;
                node.scale = s1;
              });
            })();
          }

          if (_block.gIdx == '0' || _block.gIdx == '1') {
            (function () {
              var n = new cc.Node();
              n.scale = 0.25;
              var db = n.addComponent(dragonBones.ArmatureDisplay);
              n.parent = ground;
              n.active = false;
              (0, _util.loadDragonBones)(db, {
                tex: _block.texPngData.url,
                atlas: _block.texJsonData.url,
                ske: _block.skeJsonData.url
              }).then(function (_ref) {
                var width = _ref.width,
                    height = _ref.height;
                n.width = width;
                n.height = height;
                n.active = true;
                db.playAnimation('null', 0);

                _this4._allAnimationNodes.push(n);

                finishDbCount++;
                console.log(finishDbCount, dbCount);

                if (finishDbCount == dbCount) {
                  _this4.loadEnd();
                }
              })["catch"](function () {
                finishDbCount++;
                console.log(finishDbCount, dbCount);

                if (finishDbCount == dbCount) {
                  _this4.loadEnd();
                }
              });

              if (_block.gIdx == '0') {
                var rectInfo = {
                  node: n,
                  audio_url: _block.audio_url,
                  rect: {
                    x: _block.rect.x / baseRect.width,
                    y: _block.rect.y / baseRect.height,
                    width: _block.rect.width / baseRect.width,
                    height: _block.rect.height / baseRect.height
                  }
                };

                _this4._figurePointRectArray.push(rectInfo);

                if (_block.labelText) {
                  var k = +_block.labelText * 1000;

                  if (!isNaN(k)) {
                    _this4._hintsNodeList.push({
                      node: n,
                      after: k
                    });
                  }
                }
              }
            })();
          }
        }
      }); // console.log(this.data);

      console.log('resource perload finish'); // <<<<<<< HEAD
      // =======
      // 			if (window && window["air"]) {
      // 				// cc.find('Canvas').opacity = 0;
      // 				window.air.onCourseInScreen = (next) => {
      // 					// cc.find('Canvas').opacity = 255;
      // 					this.loadEnd();
      // 					next();
      // 				}
      // 				window.air.hideAirClassLoading();
      // 			} else {
      // 				this.loadEnd();
      // 			}
      // >>>>>>> 2d461e1910571bcfc6ad4dc93c2cedafc20923ea

      cc.debug.setDisplayStats(false);
    });
  },
  loadEnd: function loadEnd() {
    if (window && window["air"] && window["air"].hideAirClassLoading) {
      window["air"].hideAirClassLoading();
    }

    this.initData(); // this.initAudio();
    // this.initView();

    this.initBg(); // this.initListener();

    this.debugGraphics();
    this.createStateMachine();
  },
  _cantouch: null,
  initData: function initData() {
    // 所有全局变量 默认都是null 
    this._cantouch = true;
  },
  // audioBtn: null,
  // initAudio() {
  // 	const audioNode = cc.find('Canvas/res/audio');
  // 	const getAudioByResName = (resName) => {
  // 		return audioNode.getChildByName(resName).getComponent(cc.AudioSource);
  // 	}
  // 	this.audioBtn = getAudioByResName('btn');
  // },
  // initView() {
  // 	// this.initBg();
  // 	// this.initPic();
  // 	// this.initBtn();
  // 	this.initIcon();
  // },
  initBg: function initBg() {
    var bgNode = cc.find('Canvas/bg');
    bgNode.scale = this._mapScaleMax;
    console.log('this._mapScaleMax', this._mapScaleMax);
  },

  /*initBtn() {
  		this.curPage = 0;
  	const bottomPart = cc.find('Canvas/bottomPart');
  	bottomPart.zIndex = 5; // 提高层级
  		bottomPart.x = bottomPart.parent.width / 2;
  	bottomPart.y = -bottomPart.parent.height / 2;
  		const leftBtnNode = bottomPart.getChildByName('btn_left');
  	//节点中添加了button组件 则可以添加click事件监听
  	leftBtnNode.on('click', () => {
  		if (!this._cantouch) {
  			return;
  		}
  		if (this.curPage == 0) {
  			return;
  		}
  		this.curPage = 0
  		this.leftMove();
  			// 游戏结束时需要调用这个方法通知系统作业完成
  		onHomeworkFinish();
  			cc.audioEngine.play(this.audioBtn.clip, false, 0.8)
  	})
  		const rightBtnNode = bottomPart.getChildByName('btn_right');
  	//节点中添加了button组件 则可以添加click事件监听
  	rightBtnNode.on('click', () => {
  		if (!this._cantouch) {
  			return;
  		}
  		if (this.curPage == 1) {
  			return;
  		}
  			this.curPage = 1
  		this.rightMove();
  			cc.audioEngine.play(this.audioBtn.clip, false, 0.5)
  	})
  },*/
  // update (dt) {},
  _timeoutIds: null,
  _intervalIds: null,
  // 生命周期
  onDestroy: function onDestroy() {
    console.log('op15 onDestroy');

    this._timeoutIds.forEach(function (id) {
      clearTimeout(id);
    });

    this._intervalIds.forEach(function (id) {
      clearInterval(id);
    });

    this.gameMachineService.stopChild();
    this.gameMachineService.stop();

    if (window.courseware && window.courseware.closeOsmoFingerRead) {
      if (this.isOpenedOsmoFingerRead) {
        window.courseware.closeOsmoFingerRead();
      }
    }
  }
});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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