
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/OP15/script/util.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'ade7a9A1W1Ah7vGKIj+9VNT', 'util');
// OP15/script/util.js

"use strict";

exports.__esModule = true;
exports.getPosByAngle = getPosByAngle;
exports.getAngleByPos = getAngleByPos;
exports.exchangeNodePos = exchangeNodePos;
exports.RandomInt = RandomInt;
exports.randomSortByArr = randomSortByArr;
exports.setSprNodeMaxLen = setSprNodeMaxLen;
exports.localPosTolocalPos = localPosTolocalPos;
exports.worldPosToLocalPos = worldPosToLocalPos;
exports.getScaleRateBy2Node = getScaleRateBy2Node;
exports.getDistance = getDistance;
exports.playAudioByUrl = playAudioByUrl;
exports.btnClickAnima = btnClickAnima;
exports.getSpriteFrimeByUrl = getSpriteFrimeByUrl;
exports.getSprNode = getSprNode;
exports.getSprNodeByUrl = getSprNodeByUrl;
exports.playAudio = playAudio;
exports.asyncDelay = asyncDelay;
exports.showFireworks = showFireworks;
exports.asyncTweenTo = asyncTweenTo;
exports.asyncTweenBy = asyncTweenBy;
exports.showTrebleFirework = showTrebleFirework;
exports.onHomeworkFinish = onHomeworkFinish;
exports.loadDragonBones = loadDragonBones;
exports.FireworkSettings = void 0;

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function getPosByAngle(angle, len) {
  var radian = angle * Math.PI / 180;
  var x = Math.sin(radian) * len;
  var y = Math.cos(radian) * len;
  return {
    x: x,
    y: y
  };
}

function getAngleByPos(px, py, mx, my) {
  var x = Math.abs(px - mx);
  var y = Math.abs(py - my);
  var z = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
  var cos = y / z;
  var radina = Math.acos(cos); // 用反三角函数求弧度

  var angle = Math.floor(180 / (Math.PI / radina) * 100) / 100; // 将弧度转换成角度

  if (mx > px && my > py) {
    // 鼠标在第四象限
    angle = 180 - angle;
  }

  if (mx === px && my > py) {
    // 鼠标在y轴负方向上
    angle = 180;
  }

  if (mx > px && my === py) {
    // 鼠标在x轴正方向上
    angle = 90;
  }

  if (mx < px && my > py) {
    // 鼠标在第三象限
    angle = 180 + angle;
  }

  if (mx < px && my === py) {
    // 鼠标在x轴负方向
    angle = 270;
  }

  if (mx < px && my < py) {
    // 鼠标在第二象限
    angle = 360 - angle;
  } // console.log('angle: ', angle);


  return angle;
}

function exchangeNodePos(baseNode, targetNode) {
  return baseNode.convertToNodeSpaceAR(targetNode._parent.convertToWorldSpaceAR(cc.v2(targetNode.x, targetNode.y)));
}

function RandomInt(a, b) {
  if (b === void 0) {
    b = 0;
  }

  var max = Math.max(a, b);
  var min = Math.min(a, b);
  return Math.floor(Math.random() * (max - min) + min);
}

function randomSortByArr(arr) {
  var newArr = [];
  var tmpArr = arr.concat();

  while (tmpArr.length > 0) {
    var randomIndex = Math.floor(tmpArr.length * Math.random());
    newArr.push(tmpArr[randomIndex]);
    tmpArr.splice(randomIndex, 1);
  }

  return newArr;
}

function setSprNodeMaxLen(sprNode, maxW, maxH) {
  var sx = maxW / sprNode.width;
  var sy = maxH / sprNode.height;
  var s = Math.min(sx, sy);
  sprNode.scale = Math.round(s * 1000) / 1000;
}

function localPosTolocalPos(baseNode, targetNode) {
  var worldPos = targetNode.parent.convertToWorldSpaceAR(cc.v2(targetNode.x, targetNode.y));
  var localPos = baseNode.parent.convertToNodeSpaceAR(cc.v2(worldPos.x, worldPos.y));
  return localPos;
}

function worldPosToLocalPos(worldPos, baseNode) {
  var localPos = baseNode.parent.convertToNodeSpaceAR(cc.v2(worldPos.x, worldPos.y));
  return localPos;
}

function getScaleRateBy2Node(baseNode, targetNode, maxFlag) {
  if (maxFlag === void 0) {
    maxFlag = true;
  }

  var worldRect1 = targetNode.getBoundingBoxToWorld();
  var worldRect2 = baseNode.getBoundingBoxToWorld();
  var sx = worldRect1.width / worldRect2.width;
  var sy = worldRect1.height / worldRect2.height;

  if (maxFlag) {
    return Math.max(sx, sy);
  } else {
    return Math.min(sx, sy);
  }
}

function getDistance(start, end) {
  var pos = cc.v2(start.x - end.x, start.y - end.y);
  var dis = Math.sqrt(pos.x * pos.x + pos.y * pos.y);
  return dis;
}

function playAudioByUrl(audio_url, cb) {
  if (cb === void 0) {
    cb = null;
  }

  if (audio_url) {
    if (audio_url instanceof cc.AudioClip && audio_url.constructor.name == 'cc_AudioClip') {
      var audioId = cc.audioEngine.play(audio_url, false, 0.8);

      if (cb) {
        cc.audioEngine.setFinishCallback(audioId, function () {
          cb();
        });
      }
    } else {
      cc.assetManager.loadRemote(audio_url, function (err, audioClip) {
        var audioId = cc.audioEngine.play(audioClip, false, 0.8);

        if (cb) {
          cc.audioEngine.setFinishCallback(audioId, function () {
            cb();
          });
        }
      });
    }
  }
}

function btnClickAnima(btn, time, rate) {
  if (time === void 0) {
    time = 0.15;
  }

  if (rate === void 0) {
    rate = 1.05;
  }

  btn.tmpScale = btn.scale;
  btn.on(cc.Node.EventType.TOUCH_START, function () {
    cc.tween(btn).to(time / 2, {
      scale: btn.scale * rate
    }).start();
  });
  btn.on(cc.Node.EventType.TOUCH_CANCEL, function () {
    cc.tween(btn).to(time / 2, {
      scale: btn.tmpScale
    }).start();
  });
  btn.on(cc.Node.EventType.TOUCH_END, function () {
    cc.tween(btn).to(time / 2, {
      scale: btn.tmpScale
    }).start();
  });
}

function getSpriteFrimeByUrl(url, cb) {
  cc.loader.load({
    url: url
  }, function (err, img) {
    var spriteFrame = new cc.SpriteFrame(img);

    if (cb) {
      cb(spriteFrame);
    }
  });
}

function getSprNode(resName) {
  var sf = cc.find('Canvas/res/img/' + resName).getComponent(cc.Sprite).spriteFrame;
  var node = new cc.Node();
  node.addComponent(cc.Sprite).spriteFrame = sf;
  return node;
}

function getSprNodeByUrl(url, cb) {
  var node = new cc.Node();
  var spr = node.addComponent(cc.Sprite);
  getSpriteFrimeByUrl(url, function (sf) {
    spr.spriteFrame = sf;

    if (cb) {
      cb(spr);
    }
  });
}

function playAudio(audioClip, cb) {
  if (cb === void 0) {
    cb = null;
  }

  if (audioClip) {
    var audioId = cc.audioEngine.playEffect(audioClip, false, 0.8);

    if (cb) {
      cc.audioEngine.setFinishCallback(audioId, function () {
        cb();
      });
    }
  }
}

function asyncDelay(_x) {
  return _asyncDelay.apply(this, arguments);
}

function _asyncDelay() {
  _asyncDelay = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(time) {
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", new Promise(function (resolve, reject) {
              try {
                setTimeout(function () {
                  resolve();
                }, time * 1000);
              } catch (e) {
                reject(e);
              }
            }));

          case 1:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _asyncDelay.apply(this, arguments);
}

var FireworkSettings = /*#__PURE__*/function () {
  // 父节点
  // 火花节点的array
  // 发射点
  // 发射方向
  // 扩散范围
  // 发射数量
  // 缩放范围
  function FireworkSettings(baseNode, nodeList, pos, side, range, number, scalseRange) {
    if (pos === void 0) {
      pos = cc.v2(0, 0);
    }

    if (side === void 0) {
      side = cc.v2(0, 100);
    }

    if (range === void 0) {
      range = 50;
    }

    if (number === void 0) {
      number = 100;
    }

    if (scalseRange === void 0) {
      scalseRange = 0;
    }

    this.baseNode = void 0;
    this.nodeList = void 0;
    this.pos = void 0;
    this.side = void 0;
    this.range = void 0;
    this.number = void 0;
    this.scalseRange = void 0;
    this.baseNode = baseNode;
    this.nodeList = nodeList;
    this.pos = pos;
    this.side = side;
    this.range = range;
    this.number = number;
    this.scalseRange = scalseRange;
  }

  FireworkSettings.copy = function copy(firework) {
    return new FireworkSettings(firework.baseNode, firework.nodeList, firework.pos, firework.side, firework.range, firework.number);
  };

  return FireworkSettings;
}();

exports.FireworkSettings = FireworkSettings;

function showFireworks(_x2) {
  return _showFireworks.apply(this, arguments);
}

function _showFireworks() {
  _showFireworks = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(fireworkSettings) {
    var baseNode, nodeList, pos, side, range, number, scalseRange;
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            baseNode = fireworkSettings.baseNode, nodeList = fireworkSettings.nodeList, pos = fireworkSettings.pos, side = fireworkSettings.side, range = fireworkSettings.range, number = fireworkSettings.number, scalseRange = fireworkSettings.scalseRange;
            new Array(number).fill(' ').forEach( /*#__PURE__*/function () {
              var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(_, i) {
                var rabbonNode, node, rate, angle;
                return regeneratorRuntime.wrap(function _callee2$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        rabbonNode = new cc.Node();
                        rabbonNode.parent = baseNode;
                        rabbonNode.x = pos.x;
                        rabbonNode.y = pos.y;
                        rabbonNode.angle = 60 * Math.random() - 30;
                        node = cc.instantiate(nodeList[RandomInt(nodeList.length)]);
                        node.parent = rabbonNode;
                        node.active = true;
                        node.x = 0;
                        node.y = 0;
                        node.angle = 0;
                        node.scale = (Math.random() - 0.5) * scalseRange + 1;
                        rate = Math.random();
                        angle = Math.PI * (Math.random() * 2 - 1);
                        _context2.next = 16;
                        return asyncTweenBy(rabbonNode, 0.3, {
                          x: side.x * rate + Math.cos(angle) * range * rate,
                          y: side.y * rate + Math.sin(angle) * range * rate
                        }, {
                          easing: 'quadIn'
                        });

                      case 16:
                        cc.tween(rabbonNode).by(8, {
                          y: -2000
                        }).start();
                        cc.tween(rabbonNode).to(5, {
                          scale: (Math.random() - 0.5) * scalseRange + 1
                        }).start();
                        rabbonFall(rabbonNode);
                        _context2.next = 21;
                        return asyncDelay(Math.random());

                      case 21:
                        cc.tween(node).by(0.15, {
                          x: -10,
                          angle: -10
                        }).by(0.3, {
                          x: 20,
                          angle: 20
                        }).by(0.15, {
                          x: -10,
                          angle: -10
                        }).union().repeatForever().start();
                        cc.tween(rabbonNode).delay(5).to(0.3, {
                          opacity: 0
                        }).call(function () {
                          node.stopAllActions();
                          node.active = false;
                          node.parent = null;
                          node = null;
                        }).start();

                      case 23:
                      case "end":
                        return _context2.stop();
                    }
                  }
                }, _callee2);
              }));

              return function (_x12, _x13) {
                return _ref2.apply(this, arguments);
              };
            }());

          case 2:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _showFireworks.apply(this, arguments);
}

function rabbonFall(_x3) {
  return _rabbonFall.apply(this, arguments);
}

function _rabbonFall() {
  _rabbonFall = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(node) {
    var time, offsetX;
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            time = 1 + Math.random();
            offsetX = RandomInt(-200, 200) * time;
            _context4.next = 4;
            return asyncTweenBy(node, time, {
              x: offsetX,
              angle: offsetX * 60 / 200
            });

          case 4:
            rabbonFall(node);

          case 5:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _rabbonFall.apply(this, arguments);
}

function asyncTweenTo(_x4, _x5, _x6, _x7) {
  return _asyncTweenTo.apply(this, arguments);
}

function _asyncTweenTo() {
  _asyncTweenTo = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(node, duration, obj, ease) {
    return regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            if (ease === void 0) {
              ease = undefined;
            }

            return _context5.abrupt("return", new Promise(function (resolve, reject) {
              try {
                cc.tween(node).to(duration, obj, ease).call(function () {
                  resolve();
                }).start();
              } catch (e) {
                reject(e);
              }
            }));

          case 2:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  }));
  return _asyncTweenTo.apply(this, arguments);
}

function asyncTweenBy(_x8, _x9, _x10, _x11) {
  return _asyncTweenBy.apply(this, arguments);
}

function _asyncTweenBy() {
  _asyncTweenBy = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(node, duration, obj, ease) {
    return regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            if (ease === void 0) {
              ease = undefined;
            }

            return _context6.abrupt("return", new Promise(function (resolve, reject) {
              try {
                cc.tween(node).by(duration, obj, ease).call(function () {
                  resolve();
                }).start();
              } catch (e) {
                reject(e);
              }
            }));

          case 2:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6);
  }));
  return _asyncTweenBy.apply(this, arguments);
}

function showTrebleFirework(baseNode, rabbonList) {
  var middle = new FireworkSettings(baseNode, rabbonList);
  middle.pos = cc.v2(0, -400);
  middle.side = cc.v2(0, 1000);
  middle.range = 200;
  middle.number = 100;
  middle.scalseRange = 0.4;
  var left = FireworkSettings.copy(middle);
  left.pos = cc.v2(-600, -400);
  left.side = cc.v2(200, 1000);
  var right = FireworkSettings.copy(middle);
  right.pos = cc.v2(600, -400);
  right.side = cc.v2(-200, 1000);
  showFireworks(middle);
  showFireworks(left);
  showFireworks(right);
}

function onHomeworkFinish() {
  var middleLayer = cc.find('middleLayer');

  if (middleLayer) {
    var middleLayerComponent = middleLayer.getComponent('middleLayer');

    if (middleLayerComponent.role == 'student') {
      middleLayerComponent.onHomeworkFinish(function () {});
    }
  } else {
    console.log('onHomeworkFinish');
  }
}

function loadDragonBones(dragonDisplay, _ref) {
  var tex = _ref.tex,
      atlas = _ref.atlas,
      ske = _ref.ske;
  return new Promise(function (resolve, reject) {
    cc.loader.load({
      url: tex,
      type: 'png'
    }, function (error, texture) {
      if (error) {
        reject();
        return;
      }

      cc.loader.load({
        url: atlas,
        type: 'txt'
      }, function (error, atlasJson) {
        if (error) {
          reject();
          return;
        }

        cc.loader.load({
          url: ske,
          type: 'txt'
        }, function (error, dragonBonesJson) {
          if (error) {
            reject();
            return;
          }

          var atlasObj = new dragonBones.DragonBonesAtlasAsset();
          atlasObj.uuid = atlas;
          atlasObj.atlasJson = atlasJson;
          atlasObj.texture = texture;
          var asset = new dragonBones.DragonBonesAsset();
          asset.uuid = ske;
          asset.dragonBonesJson = dragonBonesJson;
          var armatureName = asset._dragonBonesJsonData.armature[0].name || 'default';
          dragonDisplay.armatureName = armatureName;
          dragonDisplay.dragonAtlasAsset = atlasObj;
          dragonDisplay.dragonAsset = asset;
          resolve(asset._dragonBonesJsonData.armature[0].aabb);
        });
      });
    });
  });
}

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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