/**
 * 资源管理器
 */
OP26.res_mgr = {
	//获得表数据数据
	getFormData() {
		console.log('初始化数据');
		try {
			window.courseware.getData((res) => {
				//存入数据管理器
				OP26.data_mgr.data = res;
				//数据处理
				OP26.data_mgr.proGameData();
				console.log("获得表单数据:" + res);
			});
		} catch (error) {
			//console.error('没有查找到courseware.getData方法', error);
			//获得默认数据
			OP26.data_mgr.data = OP26.data_mgr.getDefaultData();
			//数据处理
			OP26.data_mgr.proGameData();
		}
	},

	//得到图片资源
	getSpriteFrimeByUrl(url, cb) {
		cc.assetManager.loadRemote(url, cc.SpriteFrame, (e, sp) => {
			const spriteFrame = new cc.SpriteFrame(sp)
			cb && cb(spriteFrame);
		});
	},

	playAudioByUrl(audio_url, cb) {
		if (audio_url) {
			cc.assetManager.loadRemote(audio_url, (err, audioClip) => {
				cb && cb(audioClip);
			});
		}
	},

	//加载龙骨
	loadSpine(animationDisplay, Info, callback) {
		cc.assetManager.loadAny([{ url: Info.tex_json, ext: '.txt' }, { url: Info.ske_json, ext: '.txt' }], (error, assets) => {
			if (error) {
				console.log(error)
			}
			else {
				cc.assetManager.loadRemote(Info.tex_png, (error, texture) => {
					if (error) {
						console.log(error)
					}
					else {
						var atlas = new dragonBones.DragonBonesAtlasAsset();
						atlas._uuid = Info.tex_json;
						atlas.atlasJson = assets[0];
						atlas.texture = texture;

						var asset = new dragonBones.DragonBonesAsset();
						asset._uuid = Info.ske_json;
						asset.dragonBonesJson = assets[1];

						animationDisplay.dragonAtlasAsset = atlas;
						animationDisplay.dragonAsset = asset;
						let data = asset._dragonBonesJsonData.armature[0];
						if (!data) {
							return;
						}
						animationDisplay.armatureName = data.name;
						OP26.data_mgr.dragonName = data.animation[0].name;

						animationDisplay.node.active = true;

						callback && callback();
					}
				});
			}
		});
	},
}