var TouchDragger = cc.Class({
	extends: cc.Component,

	properties: {
		MaxHeight: {
			default: "",
			displayName: "最大高度"
		},
		MaxWidth: {
			default: "",
			displayName: "最大宽度"
		},
		grid: {
			default: null,
			type: cc.Prefab,
			displayName: "格子预制体"
		},
		hGrid: {
			default: "",
			displayName: "单个高度"
		},
		wGrid: {
			default: "",
			displayName: "单个宽度"
		}
	},
	ctor: function () {
		TouchDragger.inst = this;
		OP26.TouchDragger = TouchDragger;
	},
	onLoad: function () {
		this.arMap = [];
		this.isEnd = false;

		//是否是第一次执行移动
		this.isFirstMove = true;

		//初始化格子数据
		this.initGridInfo(OP26.data_mgr.challengeData.IngredientList);
	},

	start: function () {
		this.node.on(cc.Node.EventType.TOUCH_START, this.touchBegan, this);
		this.node.on(cc.Node.EventType.TOUCH_MOVE, this.touchMove, this);
		this.node.on(cc.Node.EventType.TOUCH_END, this.touchEnd, this);
		this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.touchCancel, this);
	},

	//触摸开始
	touchBegan: function (event) {
		if (this.isEnd) return;
		this.isMove = false;
		var posScreen = event.getLocation();//点击事件获取位置
		var posNode = this.node.parent.convertToNodeSpaceAR(posScreen);
		this.iposBegan = this.getFormatIPos(posNode);
		this.iposMove = cc.v2(-1, -1);
		if (this.iposBegan.x == -1) return;
		var ndBegan = this.arMap[this.iposBegan.y][this.iposBegan.x];
		if (!ndBegan.active) {
			return;
		}

		ndBegan.runAction(this.getAction("scale"));
		ndBegan.zIndex = 1;
		this.deltaPos = ndBegan.x + ndBegan.y;
	},

	//触摸移动
	touchMove: function (event) {
		if (this.isEnd || (GodGuide && GodGuide.getTask())) return;
		if (this.iposBegan.x == -1) return;

		var posScreen = event.getLocation(); //点击事件获取位置
		var posNode = this.node.parent.convertToNodeSpaceAR(posScreen);
		var iposTouch = this.getFormatIPos(posNode);
		if (this.isFirstMove == true) {
			this.iposBegan = this.getFormatIPos(posNode);
			this.isFirstMove = false;
		};
		var delta = event.getDelta();
		var ndBegan = this.arMap[this.iposBegan.y][this.iposBegan.x];
		if (!ndBegan.active) {
			return;
		}
		ndBegan.x += delta.x;
		ndBegan.y += delta.y;
		var deltaPos = ndBegan.x + ndBegan.y;
		if (Math.abs(this.deltaPos - deltaPos) > 10) {
			this.isMove = true;
		}
		this.iposMove = iposTouch;
	},

	//触摸结束
	touchEnd: function (event) {
		if (this.isEnd) return;
		if (this.iposBegan.x == -1) return;
		var ndBegan = this.arMap[this.iposBegan.y][this.iposBegan.x];
		if (!ndBegan.active) {
			this.isMove = false;
			return;
		}
		if (!this.isMove) {
			cc.log("点击了");
			ndBegan.stopAllActions();
			ndBegan.setScale(1);
			ndBegan.runAction(cc.moveTo(0.1, this.getGridOriginPos(this.iposBegan)));
			ndBegan.callback && ndBegan.callback();
			return
		}
		this.isFirstMove = true;
		this.arMap[this.iposBegan.y][this.iposBegan.x].zIndex = 0;
		if (this.iposBegan.x == -1 || this.iposMove.x >= 0 && this.iposMove.y >= 0) {
			ndBegan.stopAllActions();
			ndBegan.setScale(1);
			ndBegan.runAction(cc.moveTo(0.1, this.getGridOriginPos(this.iposMove)));
			if (this.iposMove.x != -1) {
				var ndMove = this.arMap[this.iposMove.y][this.iposMove.x];
				ndMove.stopAllActions();
				ndMove.runAction(cc.moveTo(0.1, this.getGridOriginPos(this.iposBegan)));

				this.arMap[this.iposMove.y][this.iposMove.x] = ndBegan;
				this.arMap[this.iposBegan.y][this.iposBegan.x] = ndMove;
			}
		} else {
			ndBegan.stopAllActions();
			ndBegan.setScale(1);
			ndBegan.runAction(cc.moveTo(0.1, this.getGridOriginPos(this.iposBegan)));
			if (this.iposMove.x != -1) {
				var ndMove = this.arMap[this.iposMove.y][this.iposMove.x];
				ndMove.stopAllActions();
				ndMove.runAction(cc.moveTo(0.1, this.getGridOriginPos(this.iposMove)));
			}
		}
		this.isMove = false;
	},

	//触摸取消
	touchCancel: function (event) {
		this.arMap[this.iposBegan.y][this.iposBegan.x].zIndex = 0;
		var ndBegan = this.arMap[this.iposBegan.y][this.iposBegan.x];
		ndBegan.stopAllActions();
		ndBegan.setScale(1);
		ndBegan.runAction(cc.moveTo(0.1, this.getGridOriginPos(this.iposBegan)));
		if (this.iposMove.x != -1) {
			var ndMove = this.arMap[this.iposMove.y][this.iposMove.x];
			ndMove.stopAllActions();
			ndMove.runAction(cc.moveTo(0.1, this.getGridOriginPos(this.iposMove)));
		}
		this.isMove = false;
	},

	//初始化格子数据
	initGridInfo: function (list) {
		for (var i = this.MaxHeight - 1; i >= 0; --i) {
			this.arMap[i] = [];
			for (var j = 0; j < this.MaxWidth; ++j) {
				var ndGrid = cc.instantiate(this.grid);
				ndGrid.parent = this.node;
				//获得节点的位置
				ndGrid.position = this.getGridOriginPos(cc.v2(j, i));
				this.arMap[i][j] = ndGrid;
				// ndGrid.getComponent("grid").updateUI(3, 30);
				var num = (this.MaxHeight - i - 1) * this.MaxWidth + j;
				ndGrid.active = list[num] != undefined;
				ndGrid.getComponent("grid").updateUI(list[num], 0);
			}
		}
	},

	//获得动作
	getAction: function (name) {
		if (name === "scale") {
			return cc.repeatForever(cc.sequence(cc.scaleTo(0.15, 1.3)
				, cc.scaleTo(0.3, 1)));
		}
		else if (name === "rotate") {
			return cc.repeatForever(cc.sequence(cc.rotateBy(0.15, 30), cc.rotateBy(0.3, -60), cc.rotateBy(0.15, 30)));
		}
		return null;
	},

	//获得直角坐标
	getFormatIPos: function (pos) {
		var ipos = cc.v2(Math.floor((pos.x - this.node.x) / this.wGrid), Math.floor((pos.y - this.node.y) / this.hGrid));
		if (ipos.x < 0 || ipos.x >= this.MaxWidth || ipos.y < 0 || ipos.y >= this.MaxHeight) {
			ipos.x = -1;
		}
		return ipos;
	},

	//获得格子起始坐标
	getGridOriginPos: function (ipos) {
		return cc.v2(10 + (ipos.x + 0.5) * this.wGrid, 10 + (ipos.y + 0.5) * this.hGrid);
	},
});