const WIDTH = 1280;
const HEIGTH = 720;

/**
 * 适配
 */
cc.Class({
	extends: cc.Component,

	properties: {
		bgScaleMax: {
			default: [],
			type: cc.Node,
			displayName: "背景适配"
		},

		nodeUIOffset: {
			default: [],
			type: cc.Node,
			displayName: "节点偏移"
		},

		canvasView: {
			default: null,
			type: cc.Canvas,
			displayName: "根节点"
		},
		isCanvas: {
			default: false,
		}
	},

	onLoad: function () { //开启适配
		this.widgetList = [];

		this.initSize();

		this.scheduleOnce(function () {
			if (!this.isCanvas) {
				this.init();
			} else {
				// var canvaSize = this.findCanvas();
				// var w = (canvaSize.width) / HEIGTH;
				// var h = (canvaSize.height) / WIDTH;
				this.MaxSize = 1 //w / h > 1 ? w / h : h / w;

				this.setBgScale();
				this.setUiPositon();
				var scene = cc.director.getScene();

				var list = scene.getComponentsInChildren(cc.Widget)
				for (var i in list) {
					// list[i].updateAlignment();
				}
			}
		}, 0);

		OP26.event_mgr.reg("adjustUI", () => {
			this.setBgScale();
			this.setUiPositon();
		});
		this.MaxSize = 1;
	},


	initSize() {
		// 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
		let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
		let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
		let f = screen_size >= design_size
		cc.Canvas.instance.fitHeight = f
		cc.Canvas.instance.fitWidth = !f

		const frameSize = cc.view.getFrameSize();
		this._frameSize = frameSize;

		this._designSize = cc.view.getDesignResolutionSize();

		let sx = cc.winSize.width / frameSize.width;
		let sy = cc.winSize.height / frameSize.height;
		this._cocosScale = Math.min(sx, sy);

		sx = frameSize.width / this._designSize.width;
		sy = frameSize.height / this._designSize.height;
		this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
		this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;

		this.canvas = cc.find("Canvas");
	},


	init: function () {
		// var canvaSize = this.findCanvas();
		// var diff = canvaSize.width / canvaSize.height;
		// var bili = WIDTH / HEIGTH;
		// if (diff > bili) {
		// 	this.canvasView.fitWidth = false;
		// 	this.canvasView.fitHeight = true;
		// } else if (diff < bili) {
		// 	this.canvasView.fitWidth = true;
		// 	this.canvasView.fitHeight = false;
		// } else {
		// 	this.canvasView.fitWidth = true;
		// 	this.canvasView.fitHeight = true;
		// }
		// var w = (canvaSize.width) / WIDTH;
		// var h = (canvaSize.height) / HEIGTH;
		this.MaxSize = 1 // w / h > 1 ? w / h : h / w;

		OP26.data_mgr.MaxSize = this.MaxSize;
		this.setBgScale();
		this.setUiPositon();
		var scene = cc.director.getScene();
		var list = scene.getComponentsInChildren(cc.Widget)
		for (var i in list) {
			// list[i].updateAlignment();
		}
	},

	onDestroy: function () {
		if (OP26.event_pump) {
			OP26.event_pump.unReg("adjustUI");
		}
	},


	//背景适配
	setBgScale: function () {
		const bg = cc.find('Canvas/bg');
		bg.scale = this._mapScaleMax;

		const grass = cc.find('Canvas/connent/bg_grass');
		grass.scaleX = this.canvas.width / grass.width;

		return;
		for (var i in this.bgScaleMax) {
			// 1. 先找到 SHOW_ALL 模式适配之后，本节点的实际宽高以及初始缩放值
			let scaleForShowAll = Math.min(
				cc.view.getCanvasSize().width / this.bgScaleMax[i].width,
				cc.view.getCanvasSize().height / this.bgScaleMax[i].height
			);
			let realWidth = this.bgScaleMax[i].width * scaleForShowAll;
			let realHeight = this.bgScaleMax[i].height * scaleForShowAll;

			// 2. 基于第一步的数据，再做缩放适配
			this.bgScaleMax[i].scale = Math.max(
				cc.view.getCanvasSize().width / realWidth,
				cc.view.getCanvasSize().height / realHeight
			);
		}
	},

	//适配节点位置
	setUiPositon: function () {
		for (var i in this.nodeUIOffset) {
			// 1. 先找到 SHOW_ALL 模式适配之后，本节点的实际宽高以及初始缩放值
			let srcScaleForShowAll = Math.min(
				cc.view.getCanvasSize().width / WIDTH,
				cc.view.getCanvasSize().height / HEIGTH
			);
			let realWidth = WIDTH * srcScaleForShowAll;
			let realHeight = HEIGTH * srcScaleForShowAll;

			// 2. 基于第一步的数据，再做节点宽高重置
			this.nodeUIOffset[i].width = WIDTH * (cc.view.getCanvasSize().width / realWidth);
			this.nodeUIOffset[i].height = HEIGTH * (cc.view.getCanvasSize().height / realHeight);
		}
	},

	findCanvas: function () {
		if (cc.sys.isNative) {
			return {
				width: cc.view.getFrameSize().width,
				height: cc.view.getFrameSize().height
			};
		} else {
			return {
				width: cc.game.canvas.clientWidth,
				height: cc.game.canvas.clientHeight
			};
		}
	}
});
