cc.Class({
	extends: cc.Component,

	properties: {
		nodBg: {
			default: null,
			type: cc.Node,
			displayName: "背景"
		},
		nodEffLight: {
			default: null,
			type: cc.Node,
			displayName: "旋转亮光"
		},
		dragonItem: {
			default: null,
			type: dragonBones.ArmatureDisplay,
			displayName: "龙骨动画"
		},

		nodScale: {
			default: null,
			type: cc.Node,
			displayName: "缩放节点"
		},
		dbStar: {
			default: null,
			type: dragonBones.ArmatureDisplay,
			displayName: "星星龙骨"
		},

	},

	start: function () {
		this._timeoutIds = [];
		this._intervalIds = [];
	},

	_timeoutIds: null,
	_intervalIds: null,
	// 生命周期
	onDestroy() {
		this.nodEffLight.stopAllActions();
		this._timeoutIds.forEach(id => {
			clearTimeout(id);
		});
		this._intervalIds.forEach(id => {
			clearInterval(id);
		});
	},

	onShow: function () {
		this.node.active = true;
		//初始化信息
		this.InitData();
	},

	onHide: function () {
		this.node.active = false;
		this.nodEffLight.stopAllActions();
	},

	//初始化信息
	InitData: function () {
		//背景渐入
		this.nodBg.opacity = 0;
		this.nodBg.runAction(cc.fadeIn(0.2))

		//显示龙骨动画
		this.setDragon();

		//设置缩放
		this.scaleItem(this.nodScale);

		//播放音效
		OP26.speaker.inst.playEffect(OP26.enum.E_Audio.ENDEFFECT);
	},


	rotateItem(item) {
		cc.tween(item)
			.by(0.1, { angle: 8 })
			.repeatForever()
			.start();
	},

	scaleItem(item) {
		item.scale = 0;
		cc.tween(item)
			.to(0.15, { scale: 1.2 })
			.to(0.15, { scale: 1 })
			.call(() => {
				this.rotateItem(this.nodEffLight)
				this.playStar();
				this._timeoutIds.push(setTimeout(() => {
					this.scaleItemHide(this.nodScale);
				}, 2000));
			})
			.start();
	},

	scaleItemHide(item) {
		cc.tween(item)
			.to(0.3, { scale: 0 })
			.call(() => {
				this.onHide();
				OP26.game.inst.showRestartBtn();
			})
			.start();
	},

	setDragon() {
		//先设置节点大小为0，
		var Info = {
			tex_json: OP26.data_mgr.data.tex_json1,
			ske_json: OP26.data_mgr.data.ske_json1,
			tex_png: OP26.data_mgr.data.tex_png1,
		}
		OP26.res_mgr.loadSpine(this.dragonItem, Info, () => {
			this.playDragon("finish");
		});
	},

	//播放星星动画
	playStar() {
		this.dbStar.node.active = true;
		this.dbStar.armatureName = "Armature";
		this.dbStar.playAnimation("normal", 1);
	},

	//播放动画
	playDragon(name) {
		this.dragonItem.armatureName = "Armature";
		this.dragonItem.playAnimation(name);
	},
});
