/**
 * item
 */

cc.Class({
	extends: cc.Component,

	properties: {
		Item_name: {
			default: null,
			type: cc.Label,
			displayName: "名字"
		},

		Item_photo: {
			default: null,
			type: cc.Node,
			displayName: "图片"
		},

	},

	start: function () {
		this._timeoutIds = [];
		this._intervalIds = [];
		this.handTip = 0;//手势提示次数
		this.node.on(cc.Node.EventType.TOUCH_START, this.touchBegan, this);
		this.node.on(cc.Node.EventType.TOUCH_MOVE, this.touchMove, this);
		this.node.on(cc.Node.EventType.TOUCH_END, this.touchEnd, this);
		this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.touchCancel, this);
	},


	//触摸开始
	touchBegan: function (event) {
		OP26.data_mgr.gameState = 2;
		OP26.data_mgr.time = 0;

		//如果有提示手则停止
		OP26.game.inst.handTween && OP26.game.inst.handTween.stop() && (OP26.game.inst.handTip.active = false);

		//狮子猫动画
		OP26.game.inst.playLionDragon("waiting");

		OP26.res_mgr.playAudioByUrl(this.itemInfo.audio_url, (url) => {
			OP26.snd_mgr.playEffect(url, null);
		});

		this.m_touchTime = 0;
		clearInterval(this.timer);
		//定时器
		this.timer = setInterval(() => {
			this.m_touchTime += 1;
			if (this.m_touchTime >= 3) {
				this.m_touchTime = 0;
				OP26.res_mgr.playAudioByUrl(this.itemInfo.audio_url, (url) => {
					OP26.snd_mgr.playEffect(url, null);
				});
			}
		}, 1000)
		this._intervalIds.push(this.timer);
		this.isMove = false;
		this.deltaPos = this.node.x + this.node.y;
	},

	//触摸移动
	touchMove: function (event) {
		if (this.node.isComplent || this._isRotate) {
			return
		}
		var delta = event.getDelta();
		this.node.x += delta.x;
		this.node.y += delta.y;

		var deltaPos = this.node.x + this.node.y;
		if (Math.abs(this.deltaPos - deltaPos) > 10) {
			this.isMove = true;
		}
	},

	//触摸结束
	touchEnd: function (event) {
		clearInterval(this.timer);
		//暂停音效
		OP26.snd_mgr.pauseVolume();

		OP26.data_mgr.gameState = 1;
		//获得世界坐标
		var posScreen = event.getLocation(); //点击事件获取位置
		var posNode = this.node.convertToNodeSpaceAR(posScreen);
		console.log("世界坐标" + posNode);

		if (!this.isMove) {
			cc.log("点击了");
			// this.onBtnRotate();
			this.handTip += 1;
			if (this.handTip >= 2) {
				OP26.game.inst.setHandTip(this.node.parent);
				this.handTip = 0;
			}
			//回到原来的位置
			this.node.x = 0;
			this.node.y = 0;
			return
		}

		//获得俩个节点的世界坐标
		var contentArrPos = OP26.game.inst.setAABB();

		// 获取 ScrollView Node 的左下角坐标在世界坐标系中的坐标
		let svLeftBottomPoint = this.node.parent.convertToWorldSpaceAR(
			cc.v2(
				this.node.x - this.node.anchorX * this.node.width,
				this.node.y - this.node.anchorY * this.node.height
			)
		);

		// 求出 ScrollView 可视区域在世界坐标系中的矩形（碰撞盒）
		var posNode_1 = cc.rect(
			svLeftBottomPoint.x,
			svLeftBottomPoint.y,
			0,
			0
		);
		var isIntersect = contentArrPos.containsRect(posNode_1);//判断是否被包含
		console.log("坐标" + svLeftBottomPoint.x + "," + svLeftBottomPoint.y + "是否包含" + isIntersect);
		if (isIntersect) {
			if (this.node.is_right == true) {
				this.setItemState();
			}
			else {
				this.errorEffect();
			}
		} else {
			this.handTip += 1;
			this.errorEffect();
		}
	},

	setItemState: function () {
		this.node.isComplent = true;
		this.node.active = false;
		OP26.data_mgr.nowNum -= 1;

		//狮子猫动画
		OP26.game.inst.playLionDragon("right");

		//先播放正确声音
		OP26.speaker.inst.playEffect(OP26.enum.E_Audio.Right);

		this._timeoutIds.push(setTimeout(() => {
			OP26.game.inst.playCatDragon("right");

			//先播放正确声音
			OP26.speaker.inst.playRightEffect();

			//当前关卡是否结束
			if (OP26.data_mgr.nowNum <= 0) {
				OP26.data_mgr.quesId += 1;
				OP26.game.inst.resetQues();
			}
		}, 500));
	},

	errorEffect: function () {
		//狮子猫动画
		OP26.game.inst.playCatDragon("wrong");
		OP26.game.inst.playLionDragon("wrong");

		//先播放错误声音
		OP26.speaker.inst.playEffect(OP26.enum.E_Audio.Error);

		cc.tween(this.node)
			.to(0.1, { scaleY: 0.9, scaleX: 1.1 })
			.to(0.15, { scaleY: 1.1, scaleX: 0.9 })
			.to(0.1, { scaleY: 1, scaleX: 1 })
			.start()
		this._timeoutIds.push(setTimeout(() => {
			//回到原来的位置
			this.node.x = 0;
			this.node.y = 0;

			let num = OP26.utils.randFromTo_Int(OP26.enum.E_Audio.CatError1, OP26.enum.E_Audio.CatError2);

			//先播放错误声音
			OP26.speaker.inst.playEffect(num, () => {
				OP26.game.inst.playCatDragon("normal");
			});
			OP26.game.inst.playCatDragon("wrong");
			OP26.game.inst.playLionDragon("normal");
			if (this.handTip >= 2) {
				OP26.game.inst.setHandTip(this.node.parent);
				this.handTip = 0;
			}
		}, 500));
	},

	//触摸取消
	touchCancel: function (event) {
		clearInterval(this.timer);

		//回到原来的位置
		this.node.x = 0;
		this.node.y = 0;

		this.isMove = false;
		OP26.data_mgr.gameState = 1;

	},

	//更新界面ui
	updateUI: function (Info) {
		//当前数据
		this.itemInfo = Info;

		//初始化数据
		this.InitData();

		//是否已经完成了
		this.node.isComplent = false;
	},

	//点击翻面
	onBtnRotate: function () {
		var scaleX = this.node.scaleY;
		this._isRotate = true;
		this._timeoutIds.push(setTimeout(() => {
			this._isRotate = false;
		}, 600));

		cc.tween(this.node)
			.to(0.3, { scaleX: 0 })
			.call(() => {
				if (this.Item_name.node.active) {
					this.Item_name.node.active = false;
					this.Item_photo.active = true;
				} else {
					this.Item_name.node.active = true;
					this.Item_photo.active = false;
				}
			})
			.to(0.3, { scaleX: scaleX })
			.start();
	},

	//初始化信息
	InitData: function () {
		//设置图片
		OP26.res_mgr.getSpriteFrimeByUrl(this.itemInfo.pic_url, (list) => {
			this.Item_photo.getComponent(cc.Sprite).spriteFrame = list;
			this.photoScare(this.Item_photo, OP26.game.inst.idx);
			// this.photoScare(this.nodeState[2].getChildByName("spt_item"), 1);
		});
		//设置名字
		this.Item_name.string = this.itemInfo.text;
	},

	//图片适配
	photoScare: function (node, type) {
		var maxNum = type == 0 ? 50 : 168;
		let maxSize = Math.min(maxNum / node.height, maxNum / node.width);
		if (node.perScale == undefined) {
			node.perScale = node.scaleX;
		} else {
			node.scaleX = node.perScale;
			node.scaleY = node.perScale;
		}
		node.scaleX *= maxSize;
		node.scaleY *= maxSize;
	},
	_timeoutIds: null,
	_intervalIds: null,
	// 生命周期
	onDestroy() {
		this._timeoutIds.forEach(id => {
			clearTimeout(id);
		});
		this._intervalIds.forEach(id => {
			clearInterval(id);
		});
	},
});
