/**
 * 数据管理器
 */
OP26.data_mgr = {
	data: null,//表所有数据
	quesId: 0,//题目id
	nowNum: 0,//剩余正确数量

	gameState: 2,//游戏状态1可操作 2不可操作

	//获得默认数据
	getDefaultData() {
		const dataJson = {
			"maxWrongNumber": 4,
			"question_arr": [{
				"question_audio_url": "http://staging-teach.cdn.ireadabc.com/25432da42768ff9681946ea7fc7ee272.mp3",
				"option_arr": [{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/e3921a16a8313df274d8bc4e3f2bedd8.mp3", "is_right": true, "text": "a" },
				{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/58eec304909298176bde6c408c9dac1b.mp3", "is_right": false, "text": "b" },
				{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/e3921a16a8313df274d8bc4e3f2bedd8.mp3", "is_right": true, "text": "c" }],
				"audio_url": "http://staging-teach.cdn.ireadabc.com/25432da42768ff9681946ea7fc7ee272.mp3"
			},
			{
				"question_audio_url": "http://staging-teach.cdn.ireadabc.com/25432da42768ff9681946ea7fc7ee272.mp3",
				"option_arr": [{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/e3921a16a8313df274d8bc4e3f2bedd8.mp3", "is_right": true, "text": "a" },
				{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/58eec304909298176bde6c408c9dac1b.mp3", "is_right": false, "text": "b" },
				{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/e3921a16a8313df274d8bc4e3f2bedd8.mp3", "is_right": true, "text": "c" },
				{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/58eec304909298176bde6c408c9dac1b.mp3", "is_right": false, "text": "d" }]
			},
			{
				"question_audio_url": "http://staging-teach.cdn.ireadabc.com/25432da42768ff9681946ea7fc7ee272.mp3",
				"option_arr": [{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/e3921a16a8313df274d8bc4e3f2bedd8.mp3", "is_right": true, "text": "a" }]
			},
			{
				"question_audio_url": "http://staging-teach.cdn.ireadabc.com/25432da42768ff9681946ea7fc7ee272.mp3",
				"option_arr": [
					{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/e3921a16a8313df274d8bc4e3f2bedd8.mp3", "is_right": true, "text": "a" },
					{ "pic_url": "http://staging-teach.cdn.ireadabc.com/3134325b66d1b8ecf2f83db853195da5.png", "audio_url": "http://staging-teach.cdn.ireadabc.com/58eec304909298176bde6c408c9dac1b.mp3", "is_right": false, "text": "b" }]
			}],
			"ske_json": "http://staging-teach.cdn.ireadabc.com/7355648029551e6848a2cf36ea8a6ba6.json",
			"ske_json_name": "lion_ske.json",
			"tex_json": "http://staging-teach.cdn.ireadabc.com/511fe163f2df10925e3da82f0f69590b.json",
			"tex_json_name": "lion_tex.json",
			"tex_png": "http://staging-teach.cdn.ireadabc.com/2fd2a53fcb36d36281a6ded9500dd54f.png",
			"tex_png_name": "lion_tex.png",

			"ske_json1": "http://staging-teach.cdn.ireadabc.com/7355648029551e6848a2cf36ea8a6ba6.json",
			"ske_json_name1": "lion_ske.json",
			"tex_json1": "http://staging-teach.cdn.ireadabc.com/511fe163f2df10925e3da82f0f69590b.json",
			"tex_json_name1": "lion_tex.json",
			"tex_png1": "http://staging-teach.cdn.ireadabc.com/2fd2a53fcb36d36281a6ded9500dd54f.png",
			"tex_png_name1": "lion_tex.png",

			"guideBegin_audio_url": "http://staging-teach.cdn.ireadabc.com/bd6e2b3a870ef3f9ee9ad9c0fda79228.mp3",
			"guideEnd_audio_url": "http://staging-teach.cdn.ireadabc.com/bd6e2b3a870ef3f9ee9ad9c0fda79228.mp3",
			"guideRestart_audio_url": "http://staging-teach.cdn.ireadabc.com/bd6e2b3a870ef3f9ee9ad9c0fda79228.mp3",
		}
		const data = dataJson;
		// const data = JSON.parse(dataJson);
		// const data = [];
		return data;
	},

	getAudioBegin() {
		if (!this.data.guideBegin_audio_url) return -1;
		return this.data.guideBegin_audio_url;
	},
	getAudioEnd() {
		if (!this.data.guideEnd_audio_url) return -1;
		return this.data.guideEnd_audio_url
	},
	getAudioReStart() {
		if (!this.data.guideRestart_audio_url) return -1;
		return this.data.guideRestart_audio_url
	},

	//数据处理
	resetQuestion() {
		for (var i in this.data.question_arr) {
			if (i % 2 == 0) {
				let num = OP26.utils.randFromTo_Int(0, 1);
				if (num == 0 && this.data.question_arr[~~i + 1]) {
					let swap = (arr, i, j) => {
						[arr[i], arr[j]] = [arr[j], arr[i]];
					}
					//交换
					swap(this.data.question_arr, ~~i, ~~i + 1)
				};
			}
		}
	},

	//获取问题列表
	getQuestionArr() {
		return this.data.question_arr;
	},

	//获得表单信息
	getQuestion(num) {
		return this.data.question_arr[num];
	},

	//获得单题列表
	getQuestionOneList(num) {
		return this.data.question_arr[num].option_arr;
	},

	//获得题干
	getQuestionStem(num) {
		return this.data.question_arr[num].question_audio_url;
	},


	//获得标题
	getTitle() {
		return this.data.title;
	},

	//获得表单信息
	getSheepfoldArr() {
		return this.data.sheepfoldArr;
	},

	//获得表单信息
	getSheepfold(num) {
		return this.data.sheepfoldArr[num];
	},

	//获得所有选项
	getSheepArr() {
		return this.data.sheepArr;
	},

	//获得单项信息
	getSheep(num) {
		return this.data.sheepArr[num];
	},

	//获取当前整页数据
	getPageInfo: function () {
		return this.data.contentObj.pageArr[this.pageId].pageInfo;
	},

	//获得整条数据
	getResultInfo: function (id) {
		var pageInfo = this.data.contentObj.pageArr[this.pageId].pageInfo;
		return pageInfo[id];
	},

	//处理数据
	proGameData: function () {
		this.resetQuestion();
		this.preload();
		console.log("数据处理完毕:");
	},

	preload() {
		cc.assetManager.loadAny(null, null, null, (err, data) => {
			if (window && window["air"]) {
				cc.find('Canvas').opacity = 0;
				window.air.onCourseInScreen = (next) => {
					cc.find('Canvas').opacity = 255;
					this.loadEnd();
					next();
				}
				window.air.hideAirClassLoading();
			} else {
				this.loadEnd();
			}
			cc.debug.setDisplayStats(false);
		});
	},

	loadEnd() {
		//更新游戏界面信息
		OP26.game.inst.guideGame();
		OP26.game.inst.isLoadEnd = true;
	},
}