// 声音管理器
OP26.snd_mgr = {
	bgmId: -1, // 背景音乐的音频ID
	effIds: [], // 音效的音频ID列表（由cc.audioEngine保证音频ID不重复）
	bgmVol: 1, // 背景音乐音量
	neweffId: null, //保存上一个音效ID
	effVol: 1, // 音效音量
	pausebgVol: 1,
	pauseeffVol: 1,
	sndNativeUrls: {},
	newsnd: null,
	init: function () {
		var local_storage = OP26.local_storage;
		var music_vol = local_storage.getMusicVolume();
		var effect_vol = local_storage.getEffectsVolume();
		music_vol != undefined && music_vol + "" != "" && this.setMusicVolume(music_vol);
		effect_vol != undefined && effect_vol + "" != "" && this.setEffectsVolume(effect_vol);
	},
	delAudId: function (id) {
		if (id == this.bgmId) {
			this.bgmId = -1;
			return;
		}
		for (var i = 0; i < this.effIds.length; ++i) {
			if (this.effIds[i] == id) {
				this.effIds.splice(i, 1);
				return;
			}
		}
	},
	playMusic: function (snd, _loop, finishCB) {
		if (!snd) return;
		this.newsnd = snd;
		var loop = _loop ? false : true; // 除非指定为false，否则默认为true
		// if (OP26.configs.platform == "vo") {
		// 	this.bgmId = cc.audioEngine.play(snd, loop);
		// 	return;
		// }
		this.bgmId = cc.audioEngine.playMusic(snd, loop);
		// 播放完成回调
		if (finishCB) {
			cc.audioEngine.setFinishCallback(this.bgmId, function () {
				finishCB();
			});
		}

	},
	playEffect: function (snd, finishCB) {
		if (!snd || this.effVol == 0) return;
		var id = cc.audioEngine.playEffect(snd, false); // 音效限定不能重复播放
		this.playaudioEffect(id, finishCB);
	},
	//播放音效
	playaudioEffect: function (id, finishCB) {
		var self = this;
		this.neweffId = id;
		this.effIds.push(id);
		// 播放完记得删ID
		cc.audioEngine.setFinishCallback(id, function () {
			self.delAudId(id);
			finishCB && finishCB();
		});
	},
	pauseVolume: function () {
		cc.audioEngine.stopAll();
	},
	resumeVolume: function () {
		if (this.newsnd != null) {
			cc.audioEngine.playMusic(this.newsnd)
		}
	},
	setMusicVolume: function (percent) {
		this.bgmVol = percent;
		cc.audioEngine.setMusicVolume(~~percent);
	},
	setEffectsVolume: function (percent) {
		this.effVol = percent;
		cc.audioEngine.setEffectsVolume(~~percent);
		cc.audioEngine.setMusicVolume(~~this.bgmVol);
	},
};