/**
 * eff_welldown
 */
var eff_well = cc.Class({
	extends: cc.Component,

	properties: {
		eff_welldown: {
			default: null,
			type: cc.Animation,
			displayName: "撒花特效"
		},
	},

	ctor: function () {
		eff_well.inst = this;
		OP26.eff_well = eff_well;
		this._timeoutIds = [];
		this._intervalIds = [];
	},

	//显示特效
	showEff: function () {
		this.node.active = true;
		this.eff_welldown.play();
		//播放撒花音效
		OP26.speaker.inst.play_congratulation();
		this._timeoutIds.push(setTimeout(() => {
			this.node.active = false;
		}, 2000));
	},
	_timeoutIds: null,
	_intervalIds: null,
	// 生命周期
	onDestroy() {
		this._timeoutIds.forEach(id => {
			clearTimeout(id);
		});
		this._intervalIds.forEach(id => {
			clearInterval(id);
		});
	},
});
