/**
 * 音效
 */

//一定按照顺序来
var E_Audio = {
	AllPop: 0,//全部弹出
	BtnCommom: 1,//按钮
	CatComplete: 2,
	CatHint: 3,
	Right: 4,
	Error: 5,
}

var speaker = cc.Class({
	extends: cc.Component,

	properties: {
		eff_audio: {
			default: [],
			type: cc.AudioClip,
			displayName: "音效列表"
		},
		eff_right: {
			default: [],
			type: cc.AudioClip,
			displayName: "正确音效"
		},
		eff_error: {
			default: [],
			type: cc.AudioClip,
			displayName: "答错音效"
		}
	},

	ctor: function () {
		speaker.inst = this;
		OP26.speaker = speaker;
	},

	//播放音效
	playEffect: function (num, cb) {
		OP26.snd_mgr.playEffect(this.eff_audio[num], cb);
	},

	//播放正确音效
	playRightEffect: function (cb) {
		let num = OP26.utils.randFromTo_Int(0, this.eff_right.length);

		OP26.snd_mgr.playEffect(this.eff_right[num], cb);
	},

	//播放失败音效
	playErrorEffect: function (cb) {
		let num = OP26.utils.randFromTo_Int(0, this.eff_error.length);

		OP26.snd_mgr.playEffect(this.eff_error[num], cb);
	}
});
