import SceneComponent from "../scene/OP71";
import { Item } from "./Item";

export class Cat extends Item {

    private _animationState: dragonBones.AnimationState;

    private _scene: SceneComponent;

    /**
     * 是否待机状态
     */
    private _standby = false;

    set standby(standby: boolean) {
        this._standby = standby;
    }

    get standby() {
        return this._standby;
    }

    constructor(scene: SceneComponent) {
        super();

        this._scene = scene;

        this._node = cc.find('Canvas/cat');
    }

    playAni(name, times = 1, cb = null) {

        if (this._animationState && this._animationState.name != name) {
            this._animationState.stop();
        }

        const cat = this.node;

        var dragonDisplay = cat.getComponent(dragonBones.ArmatureDisplay);

        const state = dragonDisplay.playAnimation(name, times);

        dragonDisplay.on(dragonBones.EventObject.COMPLETE, () => {
            if (cb) {
                cb();
            }
        })

        this._animationState = state;

        return state;
    }

    stopAni() {
        if (!this._animationState) {
            return;
        }

        this._animationState.stop();

        this._animationState = null;
    }

    init() {

        let btn = cc.find('click', this.node);

        btn.on('click', () => {
            
            if (!this.canTouch) {
                return;
            }

            if (this.standby) {
                return;
            }

            this.standby = true;

            this._scene._cantouch = false;

            let audoUrl = this.data.guideAudioUrl2;


            //播放待机音频
            if (audoUrl) {

                //播放待机动画
                this.playAni('begin', 0);

                //播放完成，停止动画
                this._scene.playAudioByUrl(audoUrl, () => {
                    this.playAni('normal', 0);
                    this.standby = false;

                    this._scene._cantouch = true;
                });
            }
            else {
                this.playAni('normal', 0);
                this.standby = false;
                this._scene._cantouch = true;
            }

        });
    }
}