import { Cat } from "./Cat";
import { Item } from "./Item";
import { delayCall, getSprNodeByUrl, playAudio } from "./util";

/**
 * 图片区域对象
 */
 export class PicArea extends Item {

    private _picUrl: string;

    private _audioUrl: string;

    //晃动最大次数
    readonly MAX_TIMES = 1;

    private _audioClip: cc.AudioClip;

    private _cat : Cat;

    private _initScale = 1;

    set picUrl(picUrl: string) {
        this._picUrl = picUrl;
    }

    get picUrl() {
        return this._picUrl;
    }

    set audioUrl(value: string) {
        this._audioUrl = value;

        //音频地址存在，则加载音频
        if (this._audioUrl && this._audioUrl != "") {
            cc.assetManager.loadRemote(this._audioUrl, (err, audioClip) => {
                if(audioClip.duration === undefined) {
                    const audioId = cc.audioEngine.play(audioClip, false, 0.1);
                    setTimeout(() => {
                        audioClip.duration = cc.audioEngine.getDuration(audioId)
                        cc.audioEngine.pause(audioId)
                    }, 50);
                }
                this._audioClip = audioClip;
            });
        }
    }

    get audioUrl() {
        return this._audioUrl;
    }

    constructor(cat: Cat){
        super();

        this._cat = cat;
    }

    /**
     * 初始化
     */
    init(){

        this.picUrl = this.data.picUrl;

        this.audioUrl = this.data.audioUrl;

        getSprNodeByUrl(this.picUrl, (sprNode) => {
 
            let pic = this.node;

            const picNode = sprNode;

            let scale = Math.min(pic.width / picNode.width, pic.height / picNode.height);

            //如果图片需要放大，则不处理
            if(scale > 1){
                scale = 1;
            }
            
            picNode.scale = scale;
            picNode.x = 0;
            picNode.y = 0;
            pic.addChild(picNode);

            this._initScale = scale;
        });
    }

    /**
     * 图片点击事件
     * @param callback 
     */
    click(callback = null) {

        if (!this._canTouch) {
            return;
        }

        this._canTouch = false;

        //动画时长
        let tweenDuration = 0.4;

        let times = 1;

        const enlarge = () => {
            cc.tween(this._node)
                .to(tweenDuration / 2, { scale: this._initScale * 1.5 })
                .to(tweenDuration / 2, { scale: this._initScale })
                .call(() => {

                    times += 1;

                    if (times > this.MAX_TIMES) {
                        this._canTouch = true;
                        return;
                    }

                    enlarge();
                })
                .start();
        }

        //放大图片
        enlarge();

        //播放音频
        if (this._audioClip) {

            //this._cat.playAni('begin', 0);

            playAudio(this._audioClip, () => {
                //this._cat.playAni('normal', 0);
            });
        }


        if (callback) {

            //获取音频时长
            let duration = this._audioClip == null ? 0 : this._audioClip.duration;

            //回调延迟时间
            let timeout = tweenDuration;

            //如果音频时长大于动画时长，则等音频播放完成后，再执行回待函数
            if (duration > tweenDuration) {
                timeout = duration;
            }

            delayCall(timeout, callback)
        }
    }
}