import {ApplicationRef, Component, EventEmitter, Input, OnChanges, OnDestroy, Output} from '@angular/core';
import { NzMessageService, UploadXHRArgs, UploadFile } from 'ng-zorro-antd';


@Component({
  selector: 'app-mult-rect',
  templateUrl: './mult-rect.component.html',
  styleUrls: ['./mult-rect.component.scss']
})
export class MultRectComponent implements OnDestroy, OnChanges {
  uploading = false;
  progress = 0;
  @Input()
  btnName = '配置多矩形集合';
  @Input()
  animaNames = [];

  @Input()
  rectArr = [];




  
  @Output()
  save = new EventEmitter();

  @Output()
  refreshEmitter = new EventEmitter();



  uploadUrl;
  uploadData;

  panelVisible = false;
  colorArr = [
    {name: 'red', color: '#ff0000'},
    {name: 'green', color: '#00ff00'},
    {name: 'blue', color: '#0000ff'},
    {name: 'black', color: '#000000'},
  ]

  constructor(private appRef: ApplicationRef, private nzMessageService: NzMessageService) {

    // this.uploadUrl = (<any> window).courseware.uploadUrl();
    // this.uploadData = (<any> window).courseware.uploadData();

    // window['air'].getUploadCallback = (url, data) => {
    //   this.uploadUrl = url;
    //   this.uploadData = data;
    // };

  }
  ngOnChanges() {
 
  }

  radioChange(e, item) {
    console.log('e: ', e);
    item.color = e;
  }
  
  addRect() {
    this.rectArr.push(
      {
        color: this.colorArr[0].color,
        width: 100,
        height: 100,
        x: -1,
        y: -1,
      
      }
    )
  }

  deleteRect(item) {
    const index = this.rectArr.indexOf(item);
    if (index != -1) {
      this.rectArr.splice(index, 1);
    }
  }


  /**
   * 刷新 渲染页面
   */
  refresh() {

    // this.refreshEmitter.emit();
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }


  setRectBtnClick() {
    this.panelVisible = true;
  }

  panelOk() {


    this.save.emit(this.rectArr)
    this.panelVisible = false;

  }

  panelCancel() {

    this.panelVisible = false;
    this.refresh();
  }





  ngOnDestroy() {
  }

}
