// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

// import { getSprNode } from "./util";
import { getSprNode, playAudioByUrl, showBtnAnima, getScaleRateBy2Node, localPosTolocalPos, randomSortByArr, loadDragonBones, playAudio, showTrebleFirework, getSprNodeByUrl, setSprNodeMaxLen, delayCall, asyncDelay, RandomInt, exchangeNodePos, onHomeworkFinish, roundNum, getAngleByPos} from "../script/OP72_util";

cc.Class({
	extends: cc.Component,

	properties: {
		baseWidth: {
			default: 1920,
			type: cc.Integer
		},
		baseHeight: {
			default: 1200,
			type: cc.Integer
		}
	},

	onLoad() {
		cc.debug.setDisplayStats(false);
		this.initSceneData();
		this.initSize();
	},

	initSceneData() {
		this._imageResList = [];
		this._audioResList = [];
		this._animaResList = [];
	},


	_designSize: null,
	_frameSize: null,
	_mapScaleMin: null,
	_mapScaleMax: null,
	_cocosScale: null,
	canvas: null,
	initSize() {


		// 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
		let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
		let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
		let f = screen_size >= design_size
		cc.Canvas.instance.fitHeight = f
		cc.Canvas.instance.fitWidth = !f

		const frameSize = cc.view.getFrameSize();
		this._frameSize = frameSize;

		this._designSize = cc.view.getDesignResolutionSize();

		let sx = cc.winSize.width / frameSize.width;
		let sy = cc.winSize.height / frameSize.height;
		this._cocosScale = Math.min(sx, sy);

		sx = frameSize.width / this._designSize.width;
		sy = frameSize.height / this._designSize.height;
		this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
		this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;

		this.canvas = cc.find('Canvas');


		// cc.log('cc.Canvas: ', cc.Canvas);
	},

	start() {

		console.log(' in start 1 ');

		let getData = this.getData.bind(this);
		if (window && window.courseware) {
			getData = window.courseware.getData;

			console.log(' in start 2 ');

		}
		getData((data) => {
			console.log('data:', data);
			this.data = data || this.getDefaultData();
			this.preloadItem()
		})
	},

	_imageResList: null,
	_audioResList: null,
	_animaResList: null,
	preloadItem() {
		this.addPreloadImage();
		this.addPreloadAudio();
		this.addPreloadAnima();
		this.preload();
	},


	getData(func) {
		if (window && window.courseware) {
			window.courseware.getData(func, 'dfzx_cocos_dqq');
			return;
		}
		
		const middleLayer = cc.find('middleLayer');
		if (middleLayer) {
			const middleLayerComponent = middleLayer.getComponent('middleLayer');
			middleLayerComponent.getData(func);
			return;
		}
		
		func(this.getDefaultData());
	},

	getDefaultData() {

		return {"lineType":"1","circleSize":"1","book_id":"Oxford_Phonics_World_2_SB","part_name":"c","bgItem":{"url":"http://teach.cdn.ireadabc.com/36f76c3cb474131b8604df32f9149d0e.png","rect":{"x":32.73,"y":0,"width":1534.54,"height":607}},"hotZoneItemArr":[{"id":"1671774862492","index":0,"itemType":"rect","fontScale":1.25,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.25,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/b24d187ab4ecc076abd1feca77811b12.json","name":"L2_am_C_circle_2_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/fc8b24fd4d09a9827c79edbc83bce7f3.json","name":"L2_am_C_circle_2_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/c12b0bf0b771dc0776f683417416533d.png","name":"L2_am_C_circle_2_tex.png"},"dragDot":{"x":800,"y":307.8464106844741},"gIdx":"2","posX":573,"posY":155.5,"rect":{"x":494.71,"y":90.85,"width":476.65,"height":227.79},"circleItem":1},{"id":"1671775050340","index":1,"itemType":"rect","fontScale":1.25,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.25,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/1f98fa5b5f375d603b6c3228e1a21f26.json","name":"L2_am_C_circle_3_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/ebe1d7ff673b82d4f62047f542eb7eb5.json","name":"L2_am_C_circle_3_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/c89bd80d6b3b6b95a55e7cd6714da313.png","name":"L2_am_C_circle_3_tex.png"},"dragDot":{"x":800,"y":307.8464106844741},"gIdx":"2","posX":1276.1129385964912,"posY":343.4176717836257,"rect":{"x":1125.5,"y":105,"width":235.77,"height":476.84},"circleItem":2},{"id":"1672968984816","index":2,"audio_url":"http://teach.cdn.ireadabc.com/7e043506497e60f53020f9ccebf2a94e.mp3","itemType":"rect","fontScale":1.25,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.25,"dragDot":{"x":800,"y":307.8464106844741},"gIdx":"3","posX":563,"posY":112.5,"rect":{"x":692.88,"y":121.14,"width":53.98,"height":53.98}},{"id":"1672969018191","index":3,"audio_url":"http://teach.cdn.ireadabc.com/8953a77c639130e11498758907746df2.mp3","itemType":"rect","fontScale":1.25,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.25,"dragDot":{"x":800,"y":307.8464106844741},"gIdx":"3","posX":732.9999891615365,"posY":115.50003387019854,"rect":{"x":916.72,"y":125.09,"width":53.98,"height":53.98}},{"id":"1672969018409","index":4,"audio_url":"http://teach.cdn.ireadabc.com/2d455592027e2a40d944df1d16929a4b.mp3","itemType":"rect","fontScale":1.25,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.25,"dragDot":{"x":800,"y":307.8464106844741},"gIdx":"3","posX":626.9999891615365,"posY":319.50003387019854,"rect":{"x":777.15,"y":393.69,"width":53.98,"height":53.98}},{"id":"1672969039862","index":5,"audio_url":"http://teach.cdn.ireadabc.com/fe3867f88652ec3b3f982a4e0c3f482b.mp3","itemType":"rect","fontScale":1.25,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.25,"dragDot":{"x":800,"y":307.8464106844741},"gIdx":"3","posX":953.0001038686089,"posY":110.50003387019855,"rect":{"x":1209.68,"y":121.8,"width":47.4,"height":47.4}},{"id":"1672969065345","index":6,"audio_url":"http://teach.cdn.ireadabc.com/bae5d9fc4b6f14595d31049f977ca488.mp3","itemType":"rect","fontScale":1.25,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.25,"dragDot":{"x":800,"y":307.8464106844741},"gIdx":"3","posX":854.0001038686089,"posY":268.50003387019854,"rect":{"x":1079.33,"y":329.83,"width":47.4,"height":47.4}},{"id":"1672969065560","index":7,"audio_url":"http://teach.cdn.ireadabc.com/1fa72b85405f910d8419b8d5043f741d.mp3","itemType":"rect","fontScale":1.25,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.25,"dragDot":{"x":800,"y":307.8464106844741},"gIdx":"3","posX":1051.000103868609,"posY":304.50003387019854,"rect":{"x":1338.72,"y":377.24,"width":47.4,"height":47.4}}],"typeArr":[{"gIdx":"2","name":"画圈"}],"page_id":"7","bgItem2":{"url":"http://teach.cdn.ireadabc.com/075c9306582f4a5d7fb75f6fd9fbb48e.png","rect":{"x":114.36,"y":0,"width":969.28,"height":1256}},"hotZoneItemArr2":[{"id":"1671775192010","index":0,"itemType":"rect","fontScale":0.9359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9359375,"dragDot":{"x":599,"y":628},"gIdx":"7","posX":580.9998818490478,"posY":238.0010371028025,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":293.64,"y":150,"width":346,"height":176}},{"id":"1671775216836","index":1,"itemType":"rect","fontScale":0.9359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9359375,"dragDot":{"x":599,"y":628},"gIdx":"7","posX":889.001277780668,"posY":318.00139593162027,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"multRect":[{"rect":{"x":736.64,"y":342,"width":128,"height":116},"color":"#ff0000"},{"rect":{"x":687.64,"y":176,"width":96,"height":118},"color":"#ff0000"}],"rect":{"x":667.64,"y":164,"width":214,"height":308}}],"begin_audio_url":"http://teach.cdn.ireadabc.com/e56aa2256f297d138f5f249efa08e90c.mp3","idle_audio_url":"http://teach.cdn.ireadabc.com/e56aa2256f297d138f5f249efa08e90c.mp3","finish_right_audio_url":"http://teach.cdn.ireadabc.com/c6d6f0c9be1d1a29dfa3c2de05023884.mp3","isDebug":true,"helpTime":10,"itemCombineGroup":[]}



		return this.item = {"lineType":"1","circleSize":"1","book_id":"Oxford_Phonics_World_2_SB","part_name":"b","page_id":"61","begin_audio_url":"http://teach.cdn.ireadabc.com/16d6967dba29498089154e832163391c.mp3","idle_audio_url":"http://teach.cdn.ireadabc.com/16d6967dba29498089154e832163391c.mp3","finish_right_audio_url":"http://teach.cdn.ireadabc.com/27796e9478ecbd16def01c101219e4ab.mp3","bgItem":{"url":"http://teach.cdn.ireadabc.com/e07c195669e39ca6f5a875d00e58ef20.png","rect":{"x":404.31,"y":0,"width":1239.38,"height":773}},"hotZoneItemArr":[{"id":"1671778549011","index":0,"audio_url":"http://teach.cdn.ireadabc.com/26510d45640b11d138331628cfc71dcc.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":554.2612834748717,"posY":92.92719655498931,"rect":{"x":224.33,"y":70.97,"width":67.58,"height":67.58}},{"id":"1671778583127","index":1,"audio_url":"http://teach.cdn.ireadabc.com/34636c515d7023cbbc347a517654663b.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":789.0490991381612,"posY":88.13858385504628,"rect":{"x":484.93,"y":69.76,"width":67.58,"height":67.58}},{"id":"1671778593765","index":2,"audio_url":"http://teach.cdn.ireadabc.com/7523d4983601b0a74755008e4a5febbc.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":525.3073923233785,"posY":228.81880031464007,"rect":{"x":191.69,"y":224.15,"width":67.58,"height":67.58}},{"id":"1671778615530","index":3,"audio_url":"http://teach.cdn.ireadabc.com/cea333dfcb0c18c0cc4e35751119ea64.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":781.8457783766746,"posY":209.4557108872742,"rect":{"x":476.46,"y":212.27,"width":67.58,"height":67.58}},{"id":"1671779002072","index":4,"audio_url":"http://teach.cdn.ireadabc.com/fdf8d8d5cca418d52f298f79700bd225.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":1055.674213386591,"posY":98.71523863626054,"rect":{"x":798.15,"y":82.18,"width":67.58,"height":67.58}},{"id":"1671779009059","index":5,"audio_url":"http://teach.cdn.ireadabc.com/c2b8483c85965da3e3980ac9759ec6f4.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":1335.6613657792589,"posY":72.90647555413736,"rect":{"x":1127.07,"y":51.85,"width":67.58,"height":67.58}},{"id":"1671779017504","index":6,"audio_url":"http://teach.cdn.ireadabc.com/98afbd7250e3f037fb7adadb7b8c213e.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":1142.7864432279687,"posY":216.83012529497506,"rect":{"x":887.76,"y":210.64,"width":67.58,"height":67.58}},{"id":"1671779026505","index":7,"audio_url":"http://teach.cdn.ireadabc.com/3e2715eb5bbcfba8ca813f67bec481ae.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":1336.7401645177392,"posY":199.33525279764234,"rect":{"x":1128.34,"y":200.38,"width":67.58,"height":67.58}},{"id":"1671779039022","index":8,"audio_url":"http://teach.cdn.ireadabc.com/2fba5e807a840d87b54586c243726a53.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":546.9907118868001,"posY":391.9357433284048,"rect":{"x":200.57,"y":426.64,"width":67.58,"height":67.58}},{"id":"1671779047561","index":9,"audio_url":"http://teach.cdn.ireadabc.com/c3941177c064888862ac8a1f2b5e2709.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":782.4012094982535,"posY":381.3899080533002,"rect":{"x":477.12,"y":414.26,"width":67.58,"height":67.58}},{"id":"1671779060840","index":10,"audio_url":"http://teach.cdn.ireadabc.com/e6e5bbfc6b96729b0761d40c20eae73c.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":570.657793219656,"posY":481.52460604600606,"rect":{"x":228.36,"y":531.89,"width":67.58,"height":67.58}},{"id":"1671779080028","index":11,"audio_url":"http://teach.cdn.ireadabc.com/983c6c1ec372468ebc600b7286c51ede.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":806.0490991381612,"posY":481.7262267784764,"rect":{"x":504.9,"y":532.12,"width":67.58,"height":67.58}},{"id":"1671779091305","index":12,"audio_url":"http://teach.cdn.ireadabc.com/0a688e54039c205bab71fda1e52974ab.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":1084.1999449078507,"posY":387.20826698189745,"rect":{"x":831.67,"y":421.08,"width":67.58,"height":67.58}},{"id":"1671779101424","index":13,"audio_url":"http://teach.cdn.ireadabc.com/510a04200fe676c5ee6aab5dd282263e.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":1349.744104358336,"posY":372.3691404241131,"rect":{"x":1143.61,"y":403.66,"width":67.58,"height":67.58}},{"id":"1671779110189","index":14,"audio_url":"http://teach.cdn.ireadabc.com/c5be6c28be02fb44f14dbcfcf62b1e2d.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":1094.5858188016366,"posY":499.01997409160447,"rect":{"x":843.86,"y":552.45,"width":67.58,"height":67.58}},{"id":"1671779118443","index":15,"audio_url":"http://teach.cdn.ireadabc.com/0be900e987648d05997b152adf085932.mp3","itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":385.024},"gIdx":"3","posX":1336.6825894388942,"posY":488.18163550193947,"rect":{"x":1128.27,"y":539.71,"width":67.58,"height":67.58}},{"id":"1671788288460","index":16,"itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1024,"y":385.024},"gIdx":"2","posX":613.3115008002104,"posY":253.79568342550056,"rect":{"x":78.85,"y":202.06,"width":466.83,"height":192.18}},{"id":"1671788644709","index":17,"itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1024,"y":385.024},"gIdx":"2","posX":1039.4768265903967,"posY":194.51277595741436,"rect":{"x":670.15,"y":72.84,"width":285.53,"height":311.35}},{"id":"1671788745139","index":18,"itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1024,"y":385.024},"gIdx":"2","posX":634.5098995456824,"posY":487.99440047104815,"rect":{"x":100.47,"y":423.35,"width":473.41,"height":299.86}},{"id":"1671788774838","index":19,"itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1024,"y":385.024},"gIdx":"2","posX":1275.4972622819128,"posY":483.4193216260726,"rect":{"x":961.54,"y":404.12,"width":257.29,"height":327.57}}],"typeArr":[{"gIdx":"2","name":"画圈"}],"bgItem2":{"url":"http://teach.cdn.ireadabc.com/c2ccd8cfa4c048c6b8140bdf5b9f5ac6.jpg","rect":{"x":210.12,"y":0,"width":1627.76,"height":2106}},"hotZoneItemArr2":[{"id":"1671777992400","index":0,"itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":1048.576},"gIdx":"7","posX":598.9806594612546,"posY":443.9990662325129,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":186.27,"y":413.68,"width":606.45,"height":216.24}},{"id":"1671778043374","index":1,"itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":1048.576},"gIdx":"7","posX":1057.9844007884078,"posY":371.99910473838867,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":859.67,"y":227.99,"width":338.5,"height":418.38}},{"id":"1671778081719","index":2,"itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":1048.576},"gIdx":"7","posX":591.9710252911406,"posY":707.998308148084,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"multRect":[{"color":"#ff0000","width":100,"height":100,"x":-1,"y":-1},{"color":"#ff0000","width":100,"height":100,"x":-1,"y":-1}],"rect":{"x":163.91,"y":640.5,"width":634.69,"height":383.12}},{"id":"1671789068725","index":3,"itemType":"rect","fontScale":1.6,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6,"dragDot":{"x":1024,"y":1048.576},"gIdx":"7","posX":1307.9587871611786,"posY":698.9983129613184,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1178.1,"y":627.57,"width":289.19,"height":387.82}}],"itemCombineGroup":[],"isDebug":false,"helpTime":"0"}

		// return this.item = {"book_id":"Oxford_Phonics_World_3_SB","part_name":"c","page_id":"61","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/0e1a5b24a6f95d9fe8ee39b6f95cdaad.png","rect":{"x":0,"y":29.37,"width":1712,"height":590.25}},"hotZoneItemArr":[{"id":"1673247490714","index":0,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":757,"posY":296.5,"rect":{"x":730,"y":240.13,"width":54,"height":54},"signItem":1},{"id":"1673247538958","index":1,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":979,"posY":297.5026163234172,"rect":{"x":953.5,"y":242.63,"width":51.01,"height":51.01},"signItem":2},{"id":"1673247543149","index":2,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":756,"posY":384.5026163234172,"rect":{"x":731.5,"y":330.63,"width":49.01,"height":49.01},"signItem":3},{"id":"1673247551247","index":3,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":978,"posY":386.5026163234172,"rect":{"x":951.5,"y":330.63,"width":53.01,"height":53.01},"signItem":4},{"id":"1673247555555","index":4,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":755,"posY":473.5026163234172,"rect":{"x":728.5,"y":417.63,"width":53.01,"height":53.01},"signItem":5},{"id":"1673247561878","index":5,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":978,"posY":475.5026163234172,"rect":{"x":952.5,"y":420.63,"width":51.01,"height":51.01},"signItem":6},{"id":"1673247567832","index":6,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":756,"posY":561.5026163234172,"rect":{"x":729,"y":505.13,"width":54,"height":54},"signItem":7},{"id":"1673247572724","index":7,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":978,"posY":562.5026163234172,"rect":{"x":951.5,"y":506.63,"width":53.01,"height":53.01},"signItem":8},{"id":"1673247577373","index":8,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1318,"posY":295.5026163234172,"rect":{"x":1292.5,"y":240.63,"width":51.01,"height":51.01},"signItem":9},{"id":"1673247583622","index":9,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1541,"posY":297.5026163234172,"rect":{"x":1516,"y":243.13,"width":50,"height":50},"signItem":10},{"id":"1673247616447","index":10,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1317,"posY":384.5026163234172,"rect":{"x":1292,"y":330.13,"width":50,"height":50},"signItem":11},{"id":"1673247623047","index":11,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1541,"posY":386.5026163234172,"rect":{"x":1516,"y":332.13,"width":50,"height":50},"signItem":12},{"id":"1673247633907","index":12,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1317,"posY":473.5026163234172,"rect":{"x":1292,"y":419.13,"width":50,"height":50},"signItem":13},{"id":"1673247640703","index":13,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1541,"posY":474.5026163234172,"rect":{"x":1516,"y":420.13,"width":50,"height":50},"signItem":14},{"id":"1673247647082","index":14,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1317,"posY":561.5026163234172,"rect":{"x":1292,"y":507.13,"width":50,"height":50},"signItem":15},{"id":"1673247653371","index":15,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1542,"posY":562.5026163234172,"rect":{"x":1517,"y":508.13,"width":50,"height":50},"signItem":16}],"typeArr":[{"gIdx":"4","name":"符号"}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/6922dfe773601c34e1c1561795178cdc.jpg","rect":{"x":142.27,"y":0,"width":1162.47,"height":1504}},"hotZoneItemArr2":[{"id":"1673247678740","index":0,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":784,"posY":1378.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":494.93,"y":1146.92,"width":50.16,"height":50.16}},{"id":"1673247934308","index":1,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":940.9950219427358,"posY":1378.4995799172086,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":627.56,"y":1146.07,"width":51.86,"height":51.86}},{"id":"1673249495457","index":2,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":783.9849741017512,"posY":1440.4995799172086,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":494.92,"y":1199.63,"width":50.16,"height":50.16}},{"id":"1673249512248","index":3,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":940.9850219457833,"posY":1441.499561023387,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":628.41,"y":1200.48,"width":50.16,"height":50.16}},{"id":"1673249519189","index":4,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":782.984974101751,"posY":1504.499560718648,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":494.06,"y":1254.04,"width":50.16,"height":50.16}},{"id":"1673249529824","index":5,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":940.9750222535697,"posY":1503.4995415200874,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":628.4,"y":1253.2,"width":50.16,"height":50.16}},{"id":"1673249536467","index":6,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":782.9749741047985,"posY":1566.4995418248263,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":494.05,"y":1306.75,"width":50.16,"height":50.16}},{"id":"1673249543258","index":7,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":941.9650222566172,"posY":1565.4995226262656,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":629.24,"y":1305.91,"width":50.16,"height":50.16}},{"id":"1673249549977","index":8,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1178.964973803107,"posY":1377.4995229310048,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":830.72,"y":1146.07,"width":50.16,"height":50.16}},{"id":"1673249558853","index":9,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1334.9549015829975,"posY":1379.4995802219478,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":963.35,"y":1147.77,"width":50.16,"height":50.16}},{"id":"1673249574484","index":10,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1177.944854046752,"posY":1441.4995796124695,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":829.86,"y":1200.48,"width":50.16,"height":50.16}},{"id":"1673249582426","index":11,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1335.9349018938315,"posY":1442.499560718648,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":964.18,"y":1201.34,"width":50.16,"height":50.16}},{"id":"1673249592072","index":12,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1178.9248537481076,"posY":1503.499560413909,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":830.69,"y":1253.2,"width":50.16,"height":50.16}},{"id":"1673249600338","index":13,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1335.914901595187,"posY":1502.4995418248263,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":964.16,"y":1252.34,"width":50.16,"height":50.16}},{"id":"1673249608730","index":14,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1178.9048537542026,"posY":1566.4995421295655,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":830.68,"y":1306.75,"width":50.16,"height":50.16}},{"id":"1673249617281","index":15,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1336.8949012965427,"posY":1566.4995226262656,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":965,"y":1306.75,"width":50.16,"height":50.16}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1","isDebug":false,"itemCombineGroup":[[0,1],[2,3],[4,5],[6,7],[8,9],[10,11],[12,13],[14,15]]}

		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"29","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/91af3a0f525a0e0ec07820cbbeaf9747.jpg","rect":{"x":263.2,"y":0,"width":1160.61,"height":640}},"hotZoneItemArr":[{"id":"1672975753932","index":0,"itemType":"rect","fontScale":1.31796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.31796875,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/c7c7c91328167e6eeb1384cf977de26f.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/69a853eac9a3d8a4c115034b4af05bba.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ed0af8b45d24d6504b2653166cadcca8.png","name":"right_tex.png"},"dragDot":{"x":843.5,"y":320},"gIdx":"5","rect":{"x":480.3,"y":220,"width":200,"height":200},"drawItem":1}],"typeArr":[{"gIdx":"5","name":"涂色"}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/29442195bf59b6a05397a5d2e3ed950a.jpg","rect":{"x":141.18,"y":0,"width":1151.65,"height":1490}},"hotZoneItemArr2":[{"id":"1672971595996","index":0,"itemType":"rect","fontScale":1.1203125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.1203125,"dragDot":{"x":717,"y":736.0088372093023},"gIdx":"9","posX":574,"posY":1040.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":161.95,"y":632.58,"width":151.22,"height":139.74}},{"id":"1673232526438","index":1,"itemType":"rect","fontScale":1.1203125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.1203125,"dragDot":{"x":717,"y":736.0088372093023},"gIdx":"9","posX":1041.0659790503555,"posY":716.0579668005769,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":793.36,"y":639.52,"width":194.05,"height":139.74}},{"id":"1673252107599","index":2,"itemType":"rect","fontScale":1.1203125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.1203125,"dragDot":{"x":717,"y":736.0088372093023},"gIdx":"9","posX":419.9420131687127,"posY":950.9590078853447,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":195.7,"y":919,"width":166.12,"height":63.92}},{"id":"1673252125095","index":3,"itemType":"rect","fontScale":1.1203125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.1203125,"dragDot":{"x":717,"y":736.0088372093023},"gIdx":"9","posX":796.626230333352,"posY":723.416573892408,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":805.96,"y":875.4,"width":179.15,"height":117.29}},{"id":"1673252139596","index":4,"itemType":"rect","fontScale":1.1203125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.1203125,"dragDot":{"x":717,"y":753.5683060109291},"gIdx":"2","posX":711.537768489452,"posY":818.3012080273556,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":51.31,"y":567,"width":1038.09,"height":502.6}}],"begin_audio_url":"http://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"http://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"http://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"http://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"http://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1","isDebug":false,"itemCombineGroup":[]}

		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/91af3a0f525a0e0ec07820cbbeaf9747.jpg","rect":{"x":263.2,"y":0,"width":1160.61,"height":640}},"hotZoneItemArr":[{"id":"1672975753932","index":0,"itemType":"rect","fontScale":1.31796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.31796875,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/c7c7c91328167e6eeb1384cf977de26f.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/69a853eac9a3d8a4c115034b4af05bba.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ed0af8b45d24d6504b2653166cadcca8.png","name":"right_tex.png"},"dragDot":{"x":843.5,"y":320},"gIdx":"5","rect":{"x":480.3,"y":220,"width":200,"height":200},"drawItem":1}],"typeArr":[{"gIdx":"5","name":"涂色"}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/29442195bf59b6a05397a5d2e3ed950a.jpg","rect":{"x":142.27,"y":0,"width":1162.47,"height":1504}},"hotZoneItemArr2":[{"id":"1672971595996","index":0,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":742.6811627906976},"gIdx":"9","posX":574,"posY":1040.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":163.48,"y":638.53,"width":152.64,"height":141.06}},{"id":"1673232526438","index":1,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":742.6811627906976},"gIdx":"9","posX":1041.0659790503555,"posY":716.0579668005769,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":800.86,"y":645.53,"width":195.87,"height":141.06}},{"id":"1673232537213","index":2,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":742.6811627906976},"gIdx":"9","posX":391.05908941019266,"posY":962.0579467283744,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":111.85,"y":895,"width":273.88,"height":134.12}},{"id":"1673232563876","index":3,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":742.6811627906976},"gIdx":"9","posX":1045.0559704766574,"posY":947.0572614060292,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":815.84,"y":895,"width":173.89,"height":104.11}},{"id":"1673232630680","index":4,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":752},"gIdx":"2","posX":727.5,"posY":826,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":51.73,"y":569,"width":1067,"height":514}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1","isDebug":false,"itemCombineGroup":[]}





		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/70645c5d8b0d23fbbbeb85bba273dd07.jpg","rect":{"x":347.65,"y":0,"width":1470.7,"height":811}},"hotZoneItemArr":[{"id":"1672383817653","index":0,"pic_url":"http://staging-teach.cdn.ireadabc.com/99d4213db464fa5612e5a6f2ce6e6205.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":1},{"id":"1672383823303","index":1,"pic_url":"http://staging-teach.cdn.ireadabc.com/a5a8cca90caeac412ff4823e44027338.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":2},{"id":"1672383831136","index":2,"pic_url":"http://staging-teach.cdn.ireadabc.com/02cca6d33697d3fae9344c27db6bf2aa.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":3},{"id":"1672886201232","index":3,"pic_url":"http://staging-teach.cdn.ireadabc.com/596b40f0099235118839304f5027b130.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":4},{"id":"1672886207036","index":4,"pic_url":"http://staging-teach.cdn.ireadabc.com/a3d1bc4260624bae7fd1fb63a3b15209.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":5},{"id":"1672886218851","index":5,"pic_url":"http://staging-teach.cdn.ireadabc.com/46ea80a59547e5a3840905a52fcb0dd5.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"7","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811}},{"id":"1672886599895","index":6,"pic_url":"http://staging-teach.cdn.ireadabc.com/b6a09122f8d5cfea891bc7284e133801.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":6},{"id":"1672887244335","index":7,"pic_url":"http://staging-teach.cdn.ireadabc.com/c10876c002bc823f6ca49b74066a5d76.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":7},{"id":"1672887249391","index":8,"pic_url":"http://staging-teach.cdn.ireadabc.com/f0851d82eb1334338bb4a50b186f9e93.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":8},{"id":"1672887253204","index":9,"pic_url":"http://staging-teach.cdn.ireadabc.com/28ea5ac29910d91da59d92710adc037c.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":9},{"id":"1672887257509","index":10,"pic_url":"http://staging-teach.cdn.ireadabc.com/72c0addd6c62e060a7f319679738927b.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":10},{"id":"1672887260662","index":11,"pic_url":"http://staging-teach.cdn.ireadabc.com/68c9c58fc8666b792c38ed5ab0d6c3fd.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":11},{"id":"1672887265072","index":12,"pic_url":"http://staging-teach.cdn.ireadabc.com/94ec59f1645b4135bb36f1df30f45794.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":12},{"id":"1672887268286","index":13,"pic_url":"http://staging-teach.cdn.ireadabc.com/5b5460e376b4baa1f9dc4b3dca87dfd6.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":13},{"id":"1672887288002","index":14,"pic_url":"http://staging-teach.cdn.ireadabc.com/37b853984d269135907b136e1b5acffa.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":14},{"id":"1672887300784","index":15,"pic_url":"http://staging-teach.cdn.ireadabc.com/8f51a61409fb2ac59699ab3ab2545216.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"7","rect":{"x":0,"y":0,"width":1470.7,"height":811}}],"typeArr":[{"gIdx":"5","name":"涂色"}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/29442195bf59b6a05397a5d2e3ed950a.jpg","rect":{"x":222.09,"y":0,"width":1705.83,"height":2207}},"hotZoneItemArr2":[{"id":"1672383940196","index":0,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":579.4385501858735,"posY":953.2112404894672,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":334.79,"y":943.21,"width":45.12,"height":20}},{"id":"1672384393835","index":1,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":577.0947552664188,"posY":1102.509809216233,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":318.1,"y":1090,"width":73.81,"height":25.02}},{"id":"1672887918046","index":2,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":576.2459194656462,"posY":1030.2192900474647,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":310.94,"y":1015,"width":86.44,"height":30.44}},{"id":"1672888737090","index":3,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":580.2408527911143,"posY":1066.2182385065726,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":336.39,"y":1056.22,"width":43.52,"height":20}},{"id":"1672888874155","index":4,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":579.2358459603731,"posY":986.2181769529593,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":335.39,"y":976.22,"width":43.52,"height":20}},{"id":"1672888913151","index":5,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1041,"posY":1363.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":801.41,"y":1346,"width":35,"height":35}},{"id":"1672888960358","index":6,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1255.995058142517,"posY":1436.4976686569003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1023.9,"y":1426.5,"width":20,"height":20}},{"id":"1672888996036","index":7,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1111.995058142517,"posY":1365.4976686569003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":872.4,"y":1348,"width":35,"height":35}},{"id":"1672889020443","index":8,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":922.9949367451134,"posY":1436.4976652372552,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":690.9,"y":1426.5,"width":20,"height":20}},{"id":"1672889070985","index":9,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":937.9852582088583,"posY":1438.497540420206,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":705.9,"y":1428.5,"width":20,"height":20}},{"id":"1672889118059","index":10,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1142.9949367451134,"posY":1388.4976652372552,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":910.89,"y":1378.5,"width":20,"height":20}},{"id":"1672889148050","index":11,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1087.9949367451134,"posY":1422.4976652372552,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":815.9,"y":1405,"width":100.01,"height":35}},{"id":"1672889174286","index":12,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":993.9899777894047,"posY":1470.4975626478997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":761.9,"y":1460.5,"width":20,"height":20}},{"id":"1672889204196","index":13,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1193.9851385212771,"posY":1472.4974857058833,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":961.89,"y":1462.5,"width":20,"height":20}},{"id":"1672890163649","index":14,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"2","posX":1059,"posY":1157.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":74.91,"y":727,"width":1524,"height":861}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1","isDebug":false}

		
		return {"write_big_0_audio_url":"http://teach.cdn.ireadabc.com/4cd906b89868b20cd4e3c2fc9848bac9.mp3","write_big_1_audio_url":"http://teach.cdn.ireadabc.com/4c5a39defde0e90f3a53bf50db6943f4.mp3","write_big_2_audio_url":"http://teach.cdn.ireadabc.com/53ba71d99f24bf8e78b68b0de658a0b6.mp3","write_small_0_audio_url":"http://teach.cdn.ireadabc.com/d099918c85ac7afc33f169c9038f46d4.mp3","write_small_1_audio_url":"http://teach.cdn.ireadabc.com/2f1ea180fb4d17dce34e8d7cc6cf9159.mp3","write_small_2_audio_url":"http://teach.cdn.ireadabc.com/763b51f3d318fc0447e13ff387d00660.mp3","finish_audio_url":"http://teach.cdn.ireadabc.com/7fb349c67a76d2112a0604e624acaa97.mp3","tip_audio_url":"http://teach.cdn.ireadabc.com/d5cdef3f02abe29b14ca8c16ad4e7543.mp3","letter":"B","animArr":[{"key":"letter_big_0","title":"大写彩色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/3741b9919c8ae9c020048e4eb1a7203d.json","name":"B大彩_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/95cf3f48a23cf811c20e77e557116392.json","name":"B大彩_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/1f1e837171567609ceb9ba1b78a3528c.png","name":"B大彩_tex.png"}},{"key":"letter_big_1","title":"大写黑色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/478486f6afc92495ee9165869a03b8a0.json","name":"B大黑_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/61035beb245a518cdc827930e3cee512.json","name":"B大黑_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/05c20f86a6750450cd00bf9a45fcbaa3.png","name":"B大黑_tex.png"}},{"key":"letter_small_0","title":"小写彩色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/691dc3ff5ef5ee86bd6ba8a85992c47a.json","name":"小b彩_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/72dc028c89a284f9994c74697c1c24cd.json","name":"小b彩_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/3aa9aa49d44935bebc0b881935d464b1.png","name":"小b彩_tex.png"}},{"key":"letter_small_1","title":"小写黑色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/d32405fafbe86b03c21d7d1f026ae0a1.json","name":"小b黑_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/c26da948585e6609a4d3f8eb590b9b78.json","name":"小b黑_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/980005c431cbdbd3e9e2188d6a13f579.png","name":"小b黑_tex.png"}}],"bg_pic_url":"http://teach.cdn.ireadabc.com/520b8785f6b253aef7ced8941711c1cf.png","dot_big_1_url":"http://teach.cdn.ireadabc.com/26b8a37d08cb332eacb3383e966a9d8c.png","dot_big_2_url":"http://teach.cdn.ireadabc.com/e80e0f8311cfce0faec44623057e10fd.png","dot_small_1_url":"http://teach.cdn.ireadabc.com/699666d2df22d79a7506e52a460b4bda.png","dot_small_2_url":"http://teach.cdn.ireadabc.com/92bb0fbeace4a5611d9aab1cd92a972c.png","page_id":"7","book_id":"Oxford_Phonics_World_1_SB","part_name":"c","bgItem2":{"url":"http://teach.cdn.ireadabc.com/a7a5c15622c72b46f13224112b75219f.png","rect":{"x":108.53,"y":0,"width":936.93,"height":1212}},"hotZoneItemArr2":[{"id":"1667981969225","index":0,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"3","labelText":"Trace w a say","posX":368,"posY":119,"rect":{"x":124.47,"y":101,"width":270,"height":36}},{"id":"1667982191278","index":1,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"5","labelText":"B","posX":236.00500001279102,"posY":191.00155025950244,"rect":{"x":99.48,"y":148,"width":55.99,"height":86}},{"id":"1667982331366","index":2,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_0_b","posX":413,"posY":190,"rect":{"x":274.47,"y":150,"width":60,"height":80}},{"id":"1667982505546","index":3,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_1_b","posX":500.0045804706154,"posY":192.00048605495954,"rect":{"x":361.47,"y":152,"width":60,"height":80}},{"id":"1667982528830","index":4,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_2_b","posX":588.0048030326232,"posY":191.00048861314355,"rect":{"x":449.47,"y":151,"width":60,"height":80}},{"id":"1667982696613","index":5,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_3_b","posX":674.0050281528149,"posY":191.00048861314355,"rect":{"x":535.49,"y":151,"width":60,"height":80}},{"id":"1667982762888","index":6,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_4_b","posX":764.0052481566387,"posY":191.00048861314355,"rect":{"x":625.5,"y":151,"width":60,"height":80}},{"id":"1667982780373","index":7,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_5_b","posX":851.0154758605963,"posY":192.0004911713275,"rect":{"x":712.51,"y":152,"width":60,"height":80}},{"id":"1667982820496","index":8,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_6_b","posX":936.0257010063699,"posY":192.0004937295115,"rect":{"x":797.52,"y":152,"width":60,"height":80}},{"id":"1667982922997","index":9,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_0_s","posX":413.0359184775915,"posY":313.0004911713275,"rect":{"x":278.54,"y":273,"width":51.93,"height":80}},{"id":"1667982963933","index":10,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_1_s","posX":502.0398031221596,"posY":312.00079815340723,"rect":{"x":367.54,"y":272,"width":51.93,"height":80}},{"id":"1667982981844","index":11,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_2_s","posX":588.0400256841674,"posY":312.00079815340723,"rect":{"x":453.54,"y":272,"width":51.93,"height":80}},{"id":"1667982997077","index":12,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_3_s","posX":675.050245713573,"posY":312.00079815340723,"rect":{"x":540.56,"y":272,"width":51.93,"height":80}},{"id":"1667983009421","index":13,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_4_s","posX":763.0604734175306,"posY":312.00079815340723,"rect":{"x":628.57,"y":272,"width":51.93,"height":80}},{"id":"1667983021501","index":14,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_5_s","posX":850.0706960051203,"posY":312.00080071159124,"rect":{"x":715.58,"y":272,"width":51.93,"height":80}},{"id":"1667983039040","index":15,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_6_s","posX":937.0809211508939,"posY":311.00079815340723,"rect":{"x":802.59,"y":271,"width":51.93,"height":80}},{"id":"1667983233606","index":16,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"2","posX":588.0050230364469,"posY":239.0006062896074,"rect":{"x":47.47,"y":88,"width":864,"height":302}}],"isDebug":false}




		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"https://teach.cdn.ireadabc.com/684f085ef1286bef60066720162381b8.png","rect":{"x":237.62,"y":0,"width":1252.76,"height":649}},"hotZoneItemArr":[{"id":"1669017611587","index":0,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":692.9602814259316,"posY":185.7589939450262,"rect":{"x":495.9,"y":177.44,"width":50.33,"height":50.33},"pointItem":1,"linkItem":2},{"id":"1669017628260","index":1,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":895.1838773664921,"posY":185.66390047751776,"rect":{"x":716.48,"y":177.35,"width":50.33,"height":50.33},"pointItem":2,"linkItem":1},{"id":"1669017628745","index":2,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":1077.07009039729,"posY":252.81717081690795,"rect":{"x":914.87,"y":250.59,"width":50.33,"height":50.33},"pointItem":3,"linkItem":4},{"id":"1669017629096","index":3,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":1084.4044361247306,"posY":406.36600093794283,"rect":{"x":922.87,"y":418.07,"width":50.33,"height":50.33},"pointItem":4,"linkItem":3},{"id":"1669017629331","index":4,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":910.7574753538651,"posY":448.46716877009555,"rect":{"x":733.47,"y":464,"width":50.33,"height":50.33},"pointItem":5,"linkItem":6},{"id":"1669017629556","index":5,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":681.5308422309823,"posY":448.3720753025871,"rect":{"x":483.45,"y":463.89,"width":50.33,"height":50.33},"pointItem":6,"linkItem":5},{"id":"1669017629775","index":6,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":500.83481613520166,"posY":398.3169356130275,"rect":{"x":286.34,"y":409.3,"width":50.33,"height":50.33},"pointItem":7,"linkItem":8},{"id":"1669017630034","index":7,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":499.92990960271015,"posY":251.81717081690795,"rect":{"x":285.35,"y":249.5,"width":50.33,"height":50.33},"pointItem":8,"linkItem":7},{"id":"1669017679915","index":8,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":746.6841125703726,"posY":244.38773162195878,"rect":{"x":554.5,"y":241.4,"width":50.33,"height":50.33},"pointItem":9,"linkItem":10},{"id":"1669017680161","index":9,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":850.0336442094241,"posY":245.6730120244842,"rect":{"x":667.24,"y":242.81,"width":50.33,"height":50.33},"pointItem":10,"linkItem":9},{"id":"1669017680397","index":10,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":906.2329426914074,"posY":277.34474066168775,"rect":{"x":728.54,"y":277.34,"width":50.33,"height":50.33},"pointItem":11,"linkItem":12},{"id":"1669017680628","index":11,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":905.3280361589159,"posY":363.9304873783493,"rect":{"x":727.54,"y":371.79,"width":50.33,"height":50.33},"pointItem":12,"linkItem":11},{"id":"1669017681310","index":12,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":849.223831144441,"posY":395.69730948306136,"rect":{"x":666.35,"y":406.43,"width":50.33,"height":50.33},"pointItem":13,"linkItem":14},{"id":"1669017681516","index":13,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":747.7792060378811,"posY":396.6022160155529,"rect":{"x":555.69,"y":407.43,"width":50.33,"height":50.33},"pointItem":14,"linkItem":13},{"id":"1669017681761","index":14,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":684.5308422309823,"posY":360.0255808458578,"rect":{"x":486.71,"y":367.53,"width":50.33,"height":50.33},"pointItem":15,"linkItem":16},{"id":"1669017681968","index":15,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":684.3406552959655,"posY":279.05946025916234,"rect":{"x":486.5,"y":279.21,"width":50.33,"height":50.33},"pointItem":16,"linkItem":15},{"id":"1672018943194","index":16,"pic_url":"http://staging-teach.cdn.ireadabc.com/85b7c85ca4f2183549abf13a10cf3621.png","itemType":"pic","fontScale":1.35,"imgScale":1.0263157894736843,"imgSizeW":185,"imgSizeH":114,"mapScale":1.35,"dragDot":{"x":864,"y":324.5},"gIdx":"6","rect":{"x":538.45,"y":294,"width":189.87,"height":117},"rectNew":17}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"6","name":"书写"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/7975e4a930fe51033b0e1321260d4046.png","rect":{"x":148.42,"y":0,"width":1154.16,"height":1493}},"hotZoneItemArr2":[{"id":"1669017732389","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":684.5,"posY":746.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":454.12,"y":661.3,"width":52.5,"height":52.5}},{"id":"1669017744633","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":905.4951316891791,"posY":743.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":657.65,"y":658.54,"width":52.5,"height":52.5}},{"id":"1669017744849","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1101.495131689179,"posY":819.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":838.17,"y":728.54,"width":52.5,"height":52.5}},{"id":"1669017745296","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1110.495131689179,"posY":986.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":846.46,"y":882.35,"width":52.5,"height":52.5}},{"id":"1669017745504","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":923.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":674.23,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745728","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":673.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":443.99,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745946","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":477.49513168917906,"posY":977.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":263.46,"y":874.06,"width":52.5,"height":52.5}},{"id":"1669017747640","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":475.49513168917906,"posY":815.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":261.62,"y":724.85,"width":52.5,"height":52.5}},{"id":"1669017780767","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":510.3,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781123","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":610.67,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781698","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":918.4951316891791,"posY":847.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":669.62,"y":754.33,"width":52.5,"height":52.5}},{"id":"1669017782166","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":916.4951316891791,"posY":935.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":667.78,"y":835.38,"width":52.5,"height":52.5}},{"id":"1669017783084","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":972.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":610.67,"y":869.46,"width":52.5,"height":52.5}},{"id":"1669017783667","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":976.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":510.3,"y":873.14,"width":52.5,"height":52.5}},{"id":"1669017784240","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":678.4951392139167,"posY":937.4988242597458,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":448.59,"y":837.22,"width":52.5,"height":52.5}},{"id":"1669017785006","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":675.4951316891791,"posY":843.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":445.83,"y":750.64,"width":52.5,"height":52.5}},{"id":"1669170012773","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":746.5},"gIdx":"6","labelText":"Cc","posX":734.5,"posY":820.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":486.08,"y":745,"width":200,"height":151}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1"}
		
		return this.item = {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"45","bgItem":{"url":"https://teach.cdn.ireadabc.com/457c72a9cb0f903e45e151f5a4c836e1.png","rect":{"x":224.33,"y":0,"width":1130.34,"height":595}},"hotZoneItemArr":[{"id":"1669027968644","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":440.5,"posY":169.5,"rect":{"x":99.67,"y":95,"width":233,"height":149},"rectNew":1},{"id":"1669028023205","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":443.499071286044,"posY":346.5004510516205,"rect":{"x":102.67,"y":272,"width":233,"height":149},"rectNew":2},{"id":"1669028023430","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/0a425bcf53cf83eca9b725f62957d873.json","name":"db_letter_i_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/65ba76a8bcbb05c926be163c60a67ab0.json","name":"db_letter_i_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/364b37a6c1e6c7b6f4a270cb81ec5f0b.png","name":"db_letter_i_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":443.4990792692586,"posY":513.501366460219,"rect":{"x":102.67,"y":439,"width":233,"height":149},"rectNew":3},{"id":"1669028023680","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/7fd4e5db04c04cdcf0dc6b0c12fc4764.json","name":"db_letter_k_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/c5c2c04b305ae8890c9f050d7cbbf97a.json","name":"db_letter_k_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/4d31a35f1a705b9ab198f044ed391fc0.png","name":"db_letter_k_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1189.499071286044,"posY":170.50045105162047,"rect":{"x":848.67,"y":96,"width":233,"height":149},"rectNew":4},{"id":"1669028023942","index":4,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1189.499071286044,"posY":342.5004510516205,"rect":{"x":848.67,"y":268,"width":233,"height":149},"rectNew":5},{"id":"1669028024195","index":5,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1192.501069750746,"posY":513.5013691212904,"rect":{"x":851.67,"y":439,"width":233,"height":149},"rectNew":6},{"id":"1669028676925","index":6,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":660.5,"posY":240.5,"rect":{"x":411.67,"y":216,"width":49,"height":49},"pointItem":7,"linkItem":16},{"id":"1669028762010","index":7,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":811.4996567217756,"posY":241.50063998769747,"rect":{"x":562.67,"y":217,"width":49,"height":49},"pointItem":8,"linkItem":18},{"id":"1669028762200","index":8,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":959.4996567217756,"posY":239.50063998769747,"rect":{"x":710.67,"y":215,"width":49,"height":49},"pointItem":9,"linkItem":14},{"id":"1669028762448","index":9,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":661.4996567217756,"posY":440.50063998769747,"rect":{"x":412.67,"y":416,"width":49,"height":49},"pointItem":10,"linkItem":15},{"id":"1669028762652","index":10,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":810.4996567217756,"posY":440.50063998769747,"rect":{"x":561.67,"y":416,"width":49,"height":49},"pointItem":11,"linkItem":13},{"id":"1669028762878","index":11,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":959.4996567217756,"posY":438.50063998769747,"rect":{"x":710.67,"y":414,"width":49,"height":49},"pointItem":12,"linkItem":17},{"id":"1669028763095","index":12,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":169.50063998769747,"rect":{"x":298.67,"y":145,"width":49,"height":49},"pointItem":13,"linkItem":11},{"id":"1669028763723","index":13,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":342.50063998769747,"rect":{"x":298.67,"y":318,"width":49,"height":49},"pointItem":14,"linkItem":9},{"id":"1669028763919","index":14,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":515.5006399876975,"rect":{"x":298.67,"y":491,"width":49,"height":49},"pointItem":15,"linkItem":10},{"id":"1669028764788","index":15,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1084.4996567217756,"posY":169.50063998769747,"rect":{"x":835.67,"y":145,"width":49,"height":49},"pointItem":16,"linkItem":7},{"id":"1669028765508","index":16,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1085.4996567217756,"posY":341.50063998769747,"rect":{"x":836.67,"y":317,"width":49,"height":49},"pointItem":17,"linkItem":12},{"id":"1669028766684","index":17,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1085.4996567217756,"posY":514.5006399876975,"rect":{"x":836.67,"y":490,"width":49,"height":49},"pointItem":18,"linkItem":8},{"id":"1669028965617","index":18,"audio_url":"https://teach.cdn.ireadabc.com/fa4edbee3e71acaac5426787327cc70e.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":555.5,"posY":98.5,"rect":{"x":305.67,"y":73,"width":51,"height":51}},{"id":"1669028987109","index":19,"audio_url":"https://teach.cdn.ireadabc.com/e7bcf57e7c23c38c0d276aa94b44cdad.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":564.4993746481958,"posY":268.5002674376865,"rect":{"x":314.67,"y":243,"width":51,"height":51}},{"id":"1669028988980","index":20,"audio_url":"https://teach.cdn.ireadabc.com/48bc4f1bf13394bc9dbc0a2943aa49bc.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":563.4993746481958,"posY":434.5002674376865,"rect":{"x":313.67,"y":409,"width":51,"height":51}},{"id":"1669028989259","index":21,"audio_url":"https://teach.cdn.ireadabc.com/b1cfbb3de49089766cc3445728a4ada7.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1311.499374648196,"posY":94.50026743768646,"rect":{"x":1061.67,"y":69,"width":51,"height":51}},{"id":"1669028989473","index":22,"audio_url":"https://teach.cdn.ireadabc.com/22b083172dcc1cd6cb29c31542df5fc5.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1308.499374648196,"posY":266.5002674376865,"rect":{"x":1058.67,"y":241,"width":51,"height":51}},{"id":"1669028989757","index":23,"audio_url":"https://teach.cdn.ireadabc.com/37e1f105a64fdfd3424e2dc8676b00a9.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1313.499374648196,"posY":438.5002674376865,"rect":{"x":1063.67,"y":413,"width":51,"height":51}}],"typeArr":[{"gIdx":"1","name":"手写"},{"gIdx":"0","name":"连线"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/58c55c5d77576fad7c547123ba68d02a.png","rect":{"x":162.95,"y":0,"width":1253.11,"height":1621}},"hotZoneItemArr2":[{"id":"1669028281208","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":405.5,"posY":715.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":112.05,"y":640,"width":261,"height":151}},{"id":"1669028304948","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":404.4954815894788,"posY":908.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":111.05,"y":833,"width":261,"height":151}},{"id":"1669028305153","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Ii","posX":406.4954815894788,"posY":1094.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":113.05,"y":1019,"width":261,"height":151}},{"id":"1669028305356","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Kk","posX":1232.495481589479,"posY":715.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":939.02,"y":640,"width":261,"height":151}},{"id":"1669028305571","index":4,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":1230.495481589479,"posY":910.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":937.02,"y":835,"width":261,"height":151}},{"id":"1669028305755","index":5,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":1233.495481589479,"posY":1101.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":940.02,"y":1026,"width":261,"height":151}},{"id":"1669028350559","index":6,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":649.5,"posY":793.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":463.05,"y":770,"width":47,"height":47}},{"id":"1669028390520","index":7,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":812.4951755834819,"posY":792.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.05,"y":769,"width":47,"height":47}},{"id":"1669028390701","index":8,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":979.4951755834819,"posY":794.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":793.03,"y":771,"width":47,"height":47}},{"id":"1669028390911","index":9,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":648.4951755834819,"posY":1013.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":462.05,"y":990,"width":47,"height":47}},{"id":"1669028391078","index":10,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":812.4951755834819,"posY":1016.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.05,"y":993,"width":47,"height":47}},{"id":"1669028391273","index":11,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":978.4951755834819,"posY":1014.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":792.03,"y":991,"width":47,"height":47}},{"id":"1669028427605","index":12,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":520.4951755834819,"posY":715.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":334.05,"y":692,"width":47,"height":47}},{"id":"1669028427782","index":13,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":523.4951755834819,"posY":904.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":337.05,"y":881,"width":47,"height":47}},{"id":"1669028427990","index":14,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":523.4951755834819,"posY":1094.4990048534487,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":337.05,"y":1071,"width":47,"height":47}},{"id":"1669028428167","index":15,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1119.4951755834818,"posY":715.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":933.03,"y":692,"width":47,"height":47}},{"id":"1669028428404","index":16,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1116.4951755834818,"posY":902.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":930.03,"y":879,"width":47,"height":47}},{"id":"1669028428589","index":17,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1118.4951755834818,"posY":1096.4990048534487,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":932.03,"y":1073,"width":47,"height":47}}],"firstGIdx":"1","begin_audio_url":"https://teach.cdn.ireadabc.com/165a2ffaf57e33e73a2ba10e5f81a38c.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/36e09d2c6e5b7191f2eaa367211a30e3.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/822af0678dc62dc2846ff8fa0f773ccc.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/822af0678dc62dc2846ff8fa0f773ccc.mp3","isDebug":true}
		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"https://teach.cdn.ireadabc.com/684f085ef1286bef60066720162381b8.png","rect":{"x":196.6,"y":0,"width":1057.8,"height":548}},"hotZoneItemArr":[{"id":"1669017611587","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":692.9602814259316,"posY":185.7589939450262,"rect":{"x":418.73,"y":149.83,"width":42.5,"height":42.5},"pointItem":1,"linkItem":9},{"id":"1669017628260","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":895.1838773664921,"posY":185.66390047751776,"rect":{"x":604.98,"y":149.75,"width":42.5,"height":42.5},"pointItem":2,"linkItem":10},{"id":"1669017628745","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":1077.07009039729,"posY":252.81717081690795,"rect":{"x":772.49,"y":211.59,"width":42.5,"height":42.5},"pointItem":3,"linkItem":11},{"id":"1669017629096","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":1084.4044361247306,"posY":406.36600093794283,"rect":{"x":779.25,"y":353.01,"width":42.5,"height":42.5},"pointItem":4,"linkItem":12},{"id":"1669017629331","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":910.7574753538651,"posY":448.46716877009555,"rect":{"x":619.32,"y":391.79,"width":42.5,"height":42.5},"pointItem":5,"linkItem":13},{"id":"1669017629556","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":681.5308422309823,"posY":448.3720753025871,"rect":{"x":408.21,"y":391.7,"width":42.5,"height":42.5},"pointItem":6,"linkItem":14},{"id":"1669017629775","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":500.83481613520166,"posY":398.3169356130275,"rect":{"x":241.78,"y":345.6,"width":42.5,"height":42.5},"pointItem":7,"linkItem":15},{"id":"1669017630034","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":499.92990960271015,"posY":251.81717081690795,"rect":{"x":240.94,"y":210.67,"width":42.5,"height":42.5},"pointItem":8,"linkItem":16},{"id":"1669017679915","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":746.6841125703726,"posY":244.38773162195878,"rect":{"x":468.21,"y":203.83,"width":42.5,"height":42.5},"pointItem":9,"linkItem":1},{"id":"1669017680161","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":850.0336442094241,"posY":245.6730120244842,"rect":{"x":563.4,"y":205.02,"width":42.5,"height":42.5},"pointItem":10,"linkItem":2},{"id":"1669017680397","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":906.2329426914074,"posY":277.34474066168775,"rect":{"x":615.16,"y":234.18,"width":42.5,"height":42.5},"pointItem":11,"linkItem":3},{"id":"1669017680628","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":905.3280361589159,"posY":363.9304873783493,"rect":{"x":614.32,"y":313.93,"width":42.5,"height":42.5},"pointItem":12,"linkItem":4},{"id":"1669017681310","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":849.223831144441,"posY":395.69730948306136,"rect":{"x":562.65,"y":343.18,"width":42.5,"height":42.5},"pointItem":13,"linkItem":5},{"id":"1669017681516","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":747.7792060378811,"posY":396.6022160155529,"rect":{"x":469.21,"y":344.02,"width":42.5,"height":42.5},"pointItem":14,"linkItem":6},{"id":"1669017681761","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":684.5308422309823,"posY":360.0255808458578,"rect":{"x":410.97,"y":310.33,"width":42.5,"height":42.5},"pointItem":15,"linkItem":7},{"id":"1669017681968","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":684.3406552959655,"posY":279.05946025916234,"rect":{"x":410.79,"y":235.76,"width":42.5,"height":42.5},"pointItem":16,"linkItem":8},{"id":"1669169946060","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/b213e3ebfa399bead9cef9a5b6089a5c.json","name":"db_letter_c_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/f2f7de385d5ec34d1f51c1d0d639d0db.json","name":"db_letter_c_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/bc2ecbb4ccad7ed8717ab0c6b9a15a40.png","name":"db_letter_c_tex.png"},"dragDot":{"x":725.5,"y":274},"gIdx":"1","posX":731.5,"posY":299,"rect":{"x":434.9,"y":231,"width":200,"height":136},"rectNew":17}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/7975e4a930fe51033b0e1321260d4046.png","rect":{"x":148.42,"y":0,"width":1154.16,"height":1493}},"hotZoneItemArr2":[{"id":"1669017732389","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":684.5,"posY":746.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":454.12,"y":661.3,"width":52.5,"height":52.5}},{"id":"1669017744633","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":905.4951316891791,"posY":743.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":657.65,"y":658.54,"width":52.5,"height":52.5}},{"id":"1669017744849","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1101.495131689179,"posY":819.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":838.17,"y":728.54,"width":52.5,"height":52.5}},{"id":"1669017745296","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1110.495131689179,"posY":986.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":846.46,"y":882.35,"width":52.5,"height":52.5}},{"id":"1669017745504","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":923.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":674.23,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745728","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":673.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":443.99,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745946","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":477.49513168917906,"posY":977.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":263.46,"y":874.06,"width":52.5,"height":52.5}},{"id":"1669017747640","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":475.49513168917906,"posY":815.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":261.62,"y":724.85,"width":52.5,"height":52.5}},{"id":"1669017780767","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":510.3,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781123","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":610.67,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781698","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":918.4951316891791,"posY":847.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":669.62,"y":754.33,"width":52.5,"height":52.5}},{"id":"1669017782166","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":916.4951316891791,"posY":935.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":667.78,"y":835.38,"width":52.5,"height":52.5}},{"id":"1669017783084","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":972.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":610.67,"y":869.46,"width":52.5,"height":52.5}},{"id":"1669017783667","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":976.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":510.3,"y":873.14,"width":52.5,"height":52.5}},{"id":"1669017784240","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":678.4951392139167,"posY":937.4988242597458,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":448.59,"y":837.22,"width":52.5,"height":52.5}},{"id":"1669017785006","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":675.4951316891791,"posY":843.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":445.83,"y":750.64,"width":52.5,"height":52.5}},{"id":"1669170012773","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":746.5},"gIdx":"6","labelText":"Cc","posX":734.5,"posY":820.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":486.08,"y":745,"width":200,"height":151}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"1"}
		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"13","bgItem":{"url":"http://teach.cdn.ireadabc.com/c5adfdc66a6e6c96ebe6da6565ec1f70.png","rect":{"x":219.09,"y":0,"width":1140.81,"height":595}},"hotZoneItemArr":[{"id":"1669018212234","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":465.5733991394584,"posY":265.738764146509,"rect":{"x":179.75,"y":199,"width":133.47,"height":133.47},"circleItem":1},{"id":"1669018428827","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":700.1100806305817,"posY":398.36855045738866,"rect":{"x":417.82,"y":335.17,"width":126.4,"height":126.4},"circleItem":2},{"id":"1669018440517","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":929.0410565137215,"posY":131.18563112412767,"rect":{"x":636.78,"y":58,"width":146.37,"height":146.37},"circleItem":3},{"id":"1669022543478","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":1168.5790418503811,"posY":528.7355952934026,"rect":{"x":882.76,"y":462,"width":133.47,"height":133.47},"circleItem":4},{"id":"1669088187793","index":4,"audio_url":"http://teach.cdn.ireadabc.com/253021eecc33765f06675cdad73b3a01.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":508.5,"posY":91.5,"rect":{"x":263.91,"y":66,"width":51,"height":51}},{"id":"1669088213504","index":5,"audio_url":"http://teach.cdn.ireadabc.com/2518788213ccb81735afd87efcea0d4b.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":746.5041818824636,"posY":85.5002731976987,"rect":{"x":501.91,"y":60,"width":51,"height":51}},{"id":"1669088213739","index":6,"audio_url":"http://teach.cdn.ireadabc.com/63d19e1ff307a581b796c8dd185def79.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":986.5041818824636,"posY":83.5002731976987,"rect":{"x":741.91,"y":58,"width":51,"height":51}},{"id":"1669088214011","index":7,"audio_url":"http://teach.cdn.ireadabc.com/4529ba230c0521bf20493eae24299643.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1199.5041818824636,"posY":97.5002731976987,"rect":{"x":954.91,"y":72,"width":51,"height":51}},{"id":"1669088215319","index":8,"audio_url":"http://teach.cdn.ireadabc.com/2c3a3676cd313c128abc9a47846bf379.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":521.5041818824636,"posY":239.5002731976987,"rect":{"x":276.91,"y":214,"width":51,"height":51}},{"id":"1669088215558","index":9,"audio_url":"http://teach.cdn.ireadabc.com/8517c90273b266fdeae51c7db4d78c4d.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":749.5041818824636,"posY":237.5002731976987,"rect":{"x":504.91,"y":212,"width":51,"height":51}},{"id":"1669088215822","index":10,"audio_url":"http://teach.cdn.ireadabc.com/3bb98de81b960185c16d81da98a35c0c.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":987.5041818824636,"posY":238.5002731976987,"rect":{"x":742.91,"y":213,"width":51,"height":51}},{"id":"1669088216062","index":11,"audio_url":"http://teach.cdn.ireadabc.com/1e79b88dd5762bc75dc4ca8114124eff.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1207.5041818824636,"posY":240.50027319769868,"rect":{"x":962.91,"y":215,"width":51,"height":51}},{"id":"1669088216898","index":12,"audio_url":"http://teach.cdn.ireadabc.com/02914cba7db081e503c3d66c7d01026f.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":517.5041818824636,"posY":365.5002731976987,"rect":{"x":272.91,"y":340,"width":51,"height":51}},{"id":"1669088217138","index":13,"audio_url":"http://teach.cdn.ireadabc.com/abccf8f6ce8893cf6c3ba8c43202fe0c.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":754.5041818824636,"posY":362.5002731976987,"rect":{"x":509.91,"y":337,"width":51,"height":51}},{"id":"1669088217360","index":14,"audio_url":"http://teach.cdn.ireadabc.com/625a6ca75e12a8db5e845566934dc2d5.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":995.5041818824636,"posY":364.5002731976987,"rect":{"x":750.91,"y":339,"width":51,"height":51}},{"id":"1669088217595","index":15,"audio_url":"http://teach.cdn.ireadabc.com/b2979f011a3377e73e8a0815f7cd4d93.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1214.5041818824636,"posY":361.5002731976987,"rect":{"x":969.91,"y":336,"width":51,"height":51}},{"id":"1669088218362","index":16,"audio_url":"http://teach.cdn.ireadabc.com/5caffaa50b270c638cb2cee922d8da4f.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":510.5041818824636,"posY":491.5002731976987,"rect":{"x":265.91,"y":466,"width":51,"height":51}},{"id":"1669088218571","index":17,"audio_url":"http://teach.cdn.ireadabc.com/eb58af12affc6159b6299ac73b8aacd6.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":760.5041818824636,"posY":489.5002731976987,"rect":{"x":515.91,"y":464,"width":51,"height":51}},{"id":"1669088218819","index":18,"audio_url":"http://teach.cdn.ireadabc.com/fc549fddfeed935929831d457d2544d6.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1001.5041818824636,"posY":489.5002731976987,"rect":{"x":756.91,"y":464,"width":51,"height":51}},{"id":"1669088219087","index":19,"audio_url":"http://teach.cdn.ireadabc.com/84ce55828bd07b8e7efb25bc31c4d0ed.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1214.5041818824636,"posY":489.5002731976987,"rect":{"x":969.91,"y":464,"width":51,"height":51}}],"typeArr":[{"gIdx":"2","name":"画圈"}],"bgItem2":{"url":"http://teach.cdn.ireadabc.com/2b25e222cf2e751984a18c7a589194f4.png","rect":{"x":162.95,"y":0,"width":1253.11,"height":1621}},"hotZoneItemArr2":[{"id":"1669018544051","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":439.49543894929894,"posY":821.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":160.04,"y":726,"width":233.01,"height":191}},{"id":"1669018570547","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":689.4954389492989,"posY":960.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":402.04,"y":850,"width":249.01,"height":221}},{"id":"1669018571312","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":946.4944845617431,"posY":673.4986123129693,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":673.04,"y":586,"width":221.01,"height":175}},{"id":"1669022636621","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":1203.495438949299,"posY":1107.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":942.04,"y":1026,"width":197.01,"height":163}}],"begin_audio_url":"http://teach.cdn.ireadabc.com/a382738d66f84a7dc453e1aee978f286.mp3","idle_audio_url":"http://teach.cdn.ireadabc.com/a4758f8c14cb5859b3395514578a5f0f.mp3","finish_right_audio_url":"http://teach.cdn.ireadabc.com/b019c28398d252f09042114e1260779c.mp3"}
		
		return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/1911e3568e927257c91a8fd25d118398.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":313.64,"y":0,"width":1130.71,"height":666}},"hotZoneItemArr":[{"id":"1668059700120","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":774,"posY":221,"rect":{"x":434.36,"y":195,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1668059708822","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":840.0046289463639,"posY":286.00078101674904,"rect":{"x":500.36,"y":260,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1668059715388","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":999.0048621911851,"posY":221.00101072755757,"rect":{"x":659.4,"y":195,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1668059723401","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0054240991628,"posY":285.00078101674904,"rect":{"x":609.41,"y":259,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1668059730444","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1199.015247433881,"posY":294.00100719354515,"rect":{"x":859.42,"y":268,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1668059737547","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.026130972331,"posY":322.0010389996571,"rect":{"x":671.43,"y":296,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1668059742714","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1206.0354666133326,"posY":463.00113795200537,"rect":{"x":866.44,"y":437,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1668059747117","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.0461557810982,"posY":415.00163624775934,"rect":{"x":671.45,"y":389,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1668059754005","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1017.0554666840126,"posY":508.00146661516226,"rect":{"x":677.46,"y":482,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1668059760443","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0654879234274,"posY":451.0017952783191,"rect":{"x":609.47,"y":425,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1668059768151","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":767.0752476459216,"posY":505.00159383961,"rect":{"x":427.44,"y":479,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1668059772490","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":836.0846044909979,"posY":451.0017846762818,"rect":{"x":496.44,"y":425,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1668059780036","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":569.0848483378562,"posY":455.00159383961005,"rect":{"x":229.44,"y":429,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1668059786972","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0839047565349,"posY":416.0016079756598,"rect":{"x":430.44,"y":390,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1668059793504","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":567.0846150930352,"posY":293.0014701491747,"rect":{"x":227.44,"y":267,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1668059803802","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0838976885101,"posY":321.00103546564463,"rect":{"x":430.44,"y":295,"width":52,"height":52},"linkItem":15,"pointItem":16},{"id":"1668062996049","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/8d6671efb002131453b527eeed3bf97f.json","name":"C大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/73fe384407514cdb6367e836a45cfa03.json","name":"C大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ef6a958b04c1fed3a47881a592483df7.png","name":"C大黑_tex.png"},"dragDot":{"x":879,"y":333},"gIdx":"1","posX":890,"posY":368,"rect":{"x":464.36,"y":293,"width":224,"height":150},"rectNew":17}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":177.27,"y":0,"width":1403.46,"height":1816}},"hotZoneItemArr2":[{"id":"1668060479065","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"0","posX":761,"posY":837,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":555.73,"y":809,"width":56,"height":56}},{"id":"1668060505242","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":831.0000317275176,"posY":909.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":627.73,"y":884,"width":52,"height":52}},{"id":"1668060522174","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1010.0000129061089,"posY":836.9997553216862,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":806.73,"y":811,"width":52,"height":52}},{"id":"1668060535017","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999647770779,"posY":906.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":748.73,"y":881,"width":52,"height":52}},{"id":"1668060544062","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1228.9999803719595,"posY":917.9997561283179,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1025.73,"y":892,"width":52,"height":52}},{"id":"1668060551250","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1021.9999058929563,"posY":947.999753170668,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":818.73,"y":922,"width":52,"height":52}},{"id":"1668060557455","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1236.9999615505508,"posY":1105.99974510435,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1033.73,"y":1080,"width":52,"height":52}},{"id":"1668060563678","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1020.9999037419382,"posY":1052.9997026217416,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":817.73,"y":1027,"width":52,"height":52}},{"id":"1668060572236","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1028.9999618194279,"posY":1155.9997168722368,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":825.73,"y":1130,"width":52,"height":52}},{"id":"1668060578650","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999596684097,"posY":1092.9996891778783,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":748.73,"y":1067,"width":52,"height":52}},{"id":"1668060585215","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":750.9999803719595,"posY":1152.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":547.73,"y":1127,"width":52,"height":52}},{"id":"1668060594729","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":830.0000344162903,"posY":1092.99968998451,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":626.73,"y":1067,"width":52,"height":52}},{"id":"1668060603472","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":530.0000131749862,"posY":1095.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":326.73,"y":1070,"width":52,"height":52}},{"id":"1668060610498","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":755.0000938381665,"posY":1050.9997053105142,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":551.73,"y":1025,"width":52,"height":52}},{"id":"1668060616544","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":528.0000333407812,"posY":914.9997174099913,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":324.73,"y":889,"width":52,"height":52}},{"id":"1668060624038","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":754.0000943759211,"posY":947.9997539772997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":550.73,"y":922,"width":52,"height":52}},{"id":"1668060653013","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"6","labelText":"Cc","posX":890,"posY":1001,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":583.73,"y":913,"width":258,"height":176}}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"firstGIdx":"0","change_step_audio_url":"http://staging-teach.cdn.ireadabc.com/5d328902664fecfc2c17552394c29921.mp3","idle_2_audio_url":"http://staging-teach.cdn.ireadabc.com/13b05d0e777233d9fd9b661c76ebee2e.mp3","isDebug":true}
		return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/1911e3568e927257c91a8fd25d118398.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":313.64,"y":0,"width":1130.71,"height":666}},"hotZoneItemArr":[{"id":"1668059700120","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":774,"posY":221,"rect":{"x":434.36,"y":195,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1668059708822","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":840.0046289463639,"posY":286.00078101674904,"rect":{"x":500.36,"y":260,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1668059715388","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":999.0048621911851,"posY":221.00101072755757,"rect":{"x":659.4,"y":195,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1668059723401","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0054240991628,"posY":285.00078101674904,"rect":{"x":609.41,"y":259,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1668059730444","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1199.015247433881,"posY":294.00100719354515,"rect":{"x":859.42,"y":268,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1668059737547","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.026130972331,"posY":322.0010389996571,"rect":{"x":671.43,"y":296,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1668059742714","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1206.0354666133326,"posY":463.00113795200537,"rect":{"x":866.44,"y":437,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1668059747117","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.0461557810982,"posY":415.00163624775934,"rect":{"x":671.45,"y":389,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1668059754005","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1017.0554666840126,"posY":508.00146661516226,"rect":{"x":677.46,"y":482,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1668059760443","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0654879234274,"posY":451.0017952783191,"rect":{"x":609.47,"y":425,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1668059768151","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":767.0752476459216,"posY":505.00159383961,"rect":{"x":427.44,"y":479,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1668059772490","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":836.0846044909979,"posY":451.0017846762818,"rect":{"x":496.44,"y":425,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1668059780036","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":569.0848483378562,"posY":455.00159383961005,"rect":{"x":229.44,"y":429,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1668059786972","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0839047565349,"posY":416.0016079756598,"rect":{"x":430.44,"y":390,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1668059793504","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":567.0846150930352,"posY":293.0014701491747,"rect":{"x":227.44,"y":267,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1668059803802","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0838976885101,"posY":321.00103546564463,"rect":{"x":430.44,"y":295,"width":52,"height":52},"linkItem":15,"pointItem":16},{"id":"1668062996049","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/8d6671efb002131453b527eeed3bf97f.json","name":"C大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/73fe384407514cdb6367e836a45cfa03.json","name":"C大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ef6a958b04c1fed3a47881a592483df7.png","name":"C大黑_tex.png"},"dragDot":{"x":879,"y":333},"gIdx":"1","posX":890,"posY":368,"rect":{"x":464.36,"y":293,"width":224,"height":150},"rectNew":17}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":177.27,"y":0,"width":1403.46,"height":1816}},"hotZoneItemArr2":[{"id":"1668060479065","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"0","posX":761,"posY":837,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":555.73,"y":809,"width":56,"height":56}},{"id":"1668060505242","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":831.0000317275176,"posY":909.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":627.73,"y":884,"width":52,"height":52}},{"id":"1668060522174","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1010.0000129061089,"posY":836.9997553216862,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":806.73,"y":811,"width":52,"height":52}},{"id":"1668060535017","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999647770779,"posY":906.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":748.73,"y":881,"width":52,"height":52}},{"id":"1668060544062","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1228.9999803719595,"posY":917.9997561283179,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1025.73,"y":892,"width":52,"height":52}},{"id":"1668060551250","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1021.9999058929563,"posY":947.999753170668,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":818.73,"y":922,"width":52,"height":52}},{"id":"1668060557455","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1236.9999615505508,"posY":1105.99974510435,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1033.73,"y":1080,"width":52,"height":52}},{"id":"1668060563678","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1020.9999037419382,"posY":1052.9997026217416,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":817.73,"y":1027,"width":52,"height":52}},{"id":"1668060572236","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1028.9999618194279,"posY":1155.9997168722368,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":825.73,"y":1130,"width":52,"height":52}},{"id":"1668060578650","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999596684097,"posY":1092.9996891778783,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":748.73,"y":1067,"width":52,"height":52}},{"id":"1668060585215","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":750.9999803719595,"posY":1152.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":547.73,"y":1127,"width":52,"height":52}},{"id":"1668060594729","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":830.0000344162903,"posY":1092.99968998451,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":626.73,"y":1067,"width":52,"height":52}},{"id":"1668060603472","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":530.0000131749862,"posY":1095.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":326.73,"y":1070,"width":52,"height":52}},{"id":"1668060610498","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":755.0000938381665,"posY":1050.9997053105142,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":551.73,"y":1025,"width":52,"height":52}},{"id":"1668060616544","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":528.0000333407812,"posY":914.9997174099913,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":324.73,"y":889,"width":52,"height":52}},{"id":"1668060624038","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":754.0000943759211,"posY":947.9997539772997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":550.73,"y":922,"width":52,"height":52}},{"id":"1668060653013","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"6","labelText":"Cc","posX":890,"posY":1001,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":583.73,"y":913,"width":258,"height":176}}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"firstGIdx":"0","change_step_audio_url":"http://staging-teach.cdn.ireadabc.com/5d328902664fecfc2c17552394c29921.mp3","idle_2_audio_url":"http://staging-teach.cdn.ireadabc.com/13b05d0e777233d9fd9b661c76ebee2e.mp3","isDebug":true}
		// return {"page_id":"22","book_id":"opw1","part_name":"c","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b5fb215276c7afd3779887787bce8ccb.png","rect":{"x":250.35,"y":0,"width":889.29,"height":531}},"hotZoneItemArr":[{"id":"1667901785398","index":0,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":703,"posY":266.5,"rect":{"x":419.65,"y":233.5,"width":66,"height":66},"signItem":1},{"id":"1667902509387","index":1,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":984.0050081832392,"posY":266.50027243388246,"rect":{"x":700.65,"y":233.5,"width":66,"height":66},"signItem":2},{"id":"1667902517894","index":2,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/0a7875b1266391503571437db9db3a0f.json","name":"ku_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/422a6815028fe9f40298d9c369492b96.json","name":"ku_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/19bac79724d78938de8a654d47885586.png","name":"ku_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":423.0052954399782,"posY":484.50027243388246,"rect":{"x":139.66,"y":451.5,"width":66,"height":66},"signItem":3},{"id":"1667902630462","index":3,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":701.0052954399782,"posY":484.50027243388246,"rect":{"x":417.66,"y":451.5,"width":66,"height":66},"signItem":4},{"id":"1667902644903","index":4,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/0a7875b1266391503571437db9db3a0f.json","name":"ku_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/422a6815028fe9f40298d9c369492b96.json","name":"ku_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/19bac79724d78938de8a654d47885586.png","name":"ku_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":983.0147219589887,"posY":485.5004952878651,"rect":{"x":699.66,"y":452.5,"width":66,"height":66},"signItem":5}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/8c5a7ff4254cbc7922cb79e4794729c7.png","rect":{"x":143.31,"y":0,"width":1172.38,"height":1517}},"hotZoneItemArr2":[{"id":"1667902765218","index":0,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":716,"posY":443.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":573.08,"y":429.83,"width":70.24,"height":70.24}},{"id":"1667902778386","index":1,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":1028.9949114424535,"posY":445.49812930355085,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":901.22,"y":431.93,"width":70.24,"height":70.24}},{"id":"1667902784590","index":2,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":403.99359119896144,"posY":688.4981208674902,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"cry","key":"2"},"rect":{"x":245.98,"y":686.68,"width":70.24,"height":70.24}},{"id":"1667902791896","index":3,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":716.986227510095,"posY":687.4970958861212,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":574.12,"y":685.63,"width":70.24,"height":70.24}},{"id":"1667902798477","index":4,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":1029.9849072666034,"posY":687.4971001041515,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"cry","key":"2"},"rect":{"x":902.26,"y":685.63,"width":70.24,"height":70.24}}]}
		// return {"page_id":"13","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bg_pic_url":"http://staging-teach.cdn.ireadabc.com/103588a383dfef103f7d88081131a58b.png","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b11402c53d03d9b8966c1a5386c4d0b4.png","rect":{"x":382.88,"y":0,"width":1467.24,"height":841}},"hotZoneItemArr":[{"id":"1667284178410","index":0,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":652.5,"posY":380.5,"rect":{"x":169.62,"y":302,"width":200,"height":157},"circleItem":1},{"id":"1667285795465","index":1,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1004.5005700463794,"posY":566.4995325373978,"rect":{"x":521.62,"y":488,"width":200,"height":157},"circleItem":2},{"id":"1667285801759","index":2,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1679.500137597402,"posY":754.4993040274268,"rect":{"x":1196.62,"y":676,"width":200,"height":157},"circleItem":3}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/ef323091055c36876dfe25b5e8ed0128.png","rect":{"x":196.5,"y":0,"width":1536,"height":1987}},"hotZoneItemArr2":[{"id":"1667284877942","index":0,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":620.5,"posY":1160.5,"multRect":[{"color":"#ff0000","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20}],"rect":{"x":184.68,"y":904.39,"width":306.26,"height":204.23}},{"id":"1667284894146","index":1,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":988.5001409500544,"posY":1354.4996702166568,"multRect":[{"color":"#ffff00","width":20,"height":20,"x":20,"y":20},{"color":"#ffff00","width":20,"height":20,"x":20,"y":20},{"color":"#ffff00","width":20,"height":20,"x":20,"y":20}],"rect":{"x":525.99,"y":1079.53,"width":261.98,"height":190.46}},{"id":"1667284911442","index":2,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":1700.5000363742076,"posY":1549.4996150869986,"multRect":[{"color":"#0000ff","width":20,"height":20,"x":20,"y":20},{"color":"#0000ff","width":20,"height":20,"x":20,"y":20}],"rect":{"x":1140.35,"y":1250.58,"width":268.3,"height":186.62}}],"isDebug":false}
		// return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":234.22,"y":0,"width":867.56,"height":511}},"hotZoneItemArr":[{"id":"1667887774583","index":0,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":590,"posY":170.5,"rect":{"x":336.28,"y":151,"width":39,"height":39},"linkItem":2,"pointItem":1},{"id":"1667887788202","index":1,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":638.0000145894242,"posY":221.4999681090152,"rect":{"x":384.28,"y":202,"width":39,"height":39},"linkItem":1,"pointItem":2},{"id":"1667887795720","index":2,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":761.000005611317,"posY":170.49995856977634,"rect":{"x":507.28,"y":151,"width":39,"height":39},"linkItem":4,"pointItem":3},{"id":"1667887801441","index":3,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":720.9999826049174,"posY":220.4999681090152,"rect":{"x":467.28,"y":201,"width":39,"height":39},"linkItem":3,"pointItem":4},{"id":"1667887806805","index":4,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":911.9999900866734,"posY":226.49995875682023,"rect":{"x":658.28,"y":207,"width":39,"height":39},"linkItem":6,"pointItem":5},{"id":"1667887814385","index":5,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":767.9999543612886,"posY":247.49995763455684,"rect":{"x":514.28,"y":228,"width":39,"height":39},"linkItem":5,"pointItem":6},{"id":"1667887820091","index":6,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":919.99998129561,"posY":356.499953706635,"rect":{"x":666.28,"y":337,"width":39,"height":39},"linkItem":8,"pointItem":7},{"id":"1667887826462","index":7,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":769.9999528649374,"posY":320.4999333188499,"rect":{"x":516.28,"y":301,"width":39,"height":39},"linkItem":7,"pointItem":8},{"id":"1667887833937","index":8,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":771.9999809215223,"posY":389.49994005243036,"rect":{"x":518.28,"y":370,"width":39,"height":39},"linkItem":10,"pointItem":9},{"id":"1667887840312","index":9,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":720.9999805474345,"posY":348.4999271464013,"rect":{"x":467.28,"y":329,"width":39,"height":39},"linkItem":9,"pointItem":10},{"id":"1667887846297","index":10,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":580.9999900866734,"posY":388.4999348152012,"rect":{"x":327.28,"y":369,"width":39,"height":39},"linkItem":12,"pointItem":11},{"id":"1667887879817","index":11,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":637.0000162728193,"posY":347.49992733344516,"rect":{"x":383.28,"y":328,"width":39,"height":39},"linkItem":11,"pointItem":12},{"id":"1667887885876","index":12,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":431.0000057983608,"posY":349.499935002245,"rect":{"x":177.28,"y":330,"width":39,"height":39},"linkItem":14,"pointItem":13},{"id":"1667887891550","index":13,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":584.0000443294042,"posY":320.49993462815723,"rect":{"x":330.28,"y":301,"width":39,"height":39},"linkItem":13,"pointItem":14},{"id":"1667887898232","index":14,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":429.0000157116875,"posY":226.49994005243036,"rect":{"x":175.28,"y":207,"width":39,"height":39},"linkItem":16,"pointItem":15},{"id":"1667887904615","index":15,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":585.000044703492,"posY":247.49995763455684,"rect":{"x":331.28,"y":228,"width":39,"height":39},"linkItem":15,"pointItem":16}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":129.72,"y":0,"width":1076.55,"height":1393}},"hotZoneItemArr2":[{"id":"1667887944389","index":0,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":577,"posY":643.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":424.78,"y":621,"width":45,"height":45}},{"id":"1667887960040","index":1,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":632.004792675414,"posY":698.5014661615592,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":479.78,"y":676,"width":45,"height":45}},{"id":"1667887965560","index":2,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":769.0049179883678,"posY":641.5015914745129,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":616.79,"y":619,"width":45,"height":45}},{"id":"1667887978234","index":3,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":724.0052301315435,"posY":698.5014616047245,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":571.8,"y":676,"width":45,"height":45}},{"id":"1667887985592","index":4,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":936.0151276255474,"posY":705.5015914745129,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":783.81,"y":683,"width":45,"height":45}},{"id":"1667887992372","index":5,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":779.0256106728078,"posY":728.5016074234343,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.82,"y":706,"width":45,"height":45}},{"id":"1667887999027","index":6,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":942.0352529840694,"posY":848.5016598270331,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":789.83,"y":826,"width":45,"height":45}},{"id":"1667888007133","index":7,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":778.0456243888804,"posY":807.501933237114,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":625.84,"y":785,"width":45,"height":45}},{"id":"1667888014504","index":8,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":784.0552507512206,"posY":886.501839822003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":631.85,"y":864,"width":45,"height":45}},{"id":"1667888022599","index":9,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":724.0652644445088,"posY":839.5020198169731,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":571.86,"y":817,"width":45,"height":45}},{"id":"1667888029229","index":10,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":570.0751277622525,"posY":884.501912731358,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":417.86,"y":862,"width":45,"height":45}},{"id":"1667888036936","index":11,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":630.084776908766,"posY":839.5020152601384,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":477.86,"y":817,"width":45,"height":45}},{"id":"1667888043743","index":12,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":401.08491361380663,"posY":842.501912731358,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":248.86,"y":820,"width":45,"height":45}},{"id":"1667888050282","index":13,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":573.0843918562354,"posY":807.50191956661,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":420.86,"y":785,"width":45,"height":45}},{"id":"1667888056672","index":14,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":399.0847837440182,"posY":702.501839822003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":246.86,"y":680,"width":45,"height":45}},{"id":"1667888064637","index":15,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":572.0843872994008,"posY":727.5016005881822,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":419.86,"y":705,"width":45,"height":45}}],"isDebug":false}
		// return {"page_id":"82","book_id":"opw3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/48ecdccc083571a554a0393e88aa8e17.png","rect":{"x":0,"y":44.55,"width":2178,"height":731.91}},"hotZoneItemArr":[{"id":"1667527075823","index":0,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":353.49534883720935,"rect":{"x":987.5,"y":269.45,"width":79,"height":79},"circleItem":1,"signItem":1},{"id":"1667527184155","index":1,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1299,"posY":353.49534883720935,"rect":{"x":1259.5,"y":269.45,"width":79,"height":79},"circleItem":2,"signItem":2},{"id":"1667527190579","index":2,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":460.49534883720935,"rect":{"x":987.5,"y":376.45,"width":79,"height":79},"signItem":3},{"id":"1667527194988","index":3,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1300,"posY":463.49534883720935,"rect":{"x":1260.5,"y":379.45,"width":79,"height":79},"signItem":4},{"id":"1667527200554","index":4,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1028,"posY":571.4953488372093,"rect":{"x":988.5,"y":487.45,"width":79,"height":79},"signItem":5},{"id":"1667527205347","index":5,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1300,"posY":570.4953488372093,"rect":{"x":1260.5,"y":486.45,"width":79,"height":79},"signItem":6},{"id":"1667527210543","index":6,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":677.4953488372093,"rect":{"x":987.5,"y":593.45,"width":79,"height":79},"signItem":7},{"id":"1667527216357","index":7,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1299,"posY":678.4953488372093,"rect":{"x":1259.5,"y":594.45,"width":79,"height":79},"signItem":8},{"id":"1667527221859","index":8,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1628,"posY":355.49534883720935,"rect":{"x":1588.5,"y":271.45,"width":79,"height":79},"signItem":9},{"id":"1667527229299","index":9,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":353.49534883720935,"rect":{"x":1860.5,"y":269.45,"width":79,"height":79},"signItem":10},{"id":"1667527237415","index":10,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1627,"posY":460.49534883720935,"rect":{"x":1587.5,"y":376.45,"width":79,"height":79},"signItem":11},{"id":"1667527242936","index":11,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":461.49534883720935,"rect":{"x":1860.5,"y":377.45,"width":79,"height":79},"signItem":12},{"id":"1667527249982","index":12,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1626,"posY":569.4953488372093,"rect":{"x":1586.5,"y":485.45,"width":79,"height":79},"signItem":13},{"id":"1667527256608","index":13,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":571.4953488372093,"rect":{"x":1860.5,"y":487.45,"width":79,"height":79},"signItem":14},{"id":"1667527262126","index":14,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1627,"posY":678.4953488372093,"rect":{"x":1587.5,"y":594.45,"width":79,"height":79},"signItem":15},{"id":"1667527269087","index":15,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":679.4953488372093,"rect":{"x":1860.5,"y":595.45,"width":79,"height":79},"signItem":16}],"part_name":"e","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/cdc23fe114c7fbe4ce688c5b7cdff70e.png","rect":{"x":224.98,"y":0,"width":1728.05,"height":2236}},"hotZoneItemArr2":[{"id":"1667527318185","index":0,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1068,"posY":1726,"rect":{"x":811.02,"y":1694,"width":64,"height":64}},{"id":"1667527349948","index":1,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1265.9950206411086,"posY":1725.9983039012782,"rect":{"x":1009.02,"y":1694,"width":64,"height":64}},{"id":"1667527354975","index":2,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1067.9948260712667,"posY":1803.9983039012782,"rect":{"x":811.01,"y":1772,"width":64,"height":64}},{"id":"1667527363008","index":3,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.9850206509354,"posY":1803.9982272525526,"rect":{"x":1010.01,"y":1772,"width":64,"height":64}},{"id":"1667527368695","index":4,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1068.9848250984178,"posY":1883.9982272525526,"rect":{"x":812,"y":1852,"width":64,"height":64}},{"id":"1667527374694","index":5,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.9750196780863,"posY":1882.9981486384752,"rect":{"x":1010,"y":1851,"width":64,"height":64}},{"id":"1667527380289","index":6,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1066.9748251082444,"posY":1962.998149621151,"rect":{"x":809.99,"y":1931,"width":64,"height":64}},{"id":"1667527388175","index":7,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.965021653265,"posY":1960.9980710070736,"rect":{"x":1009.99,"y":1929,"width":64,"height":64}},{"id":"1667527393603","index":8,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1506.964825118071,"posY":1724.9980729724255,"rect":{"x":1249.98,"y":1693,"width":64,"height":64}},{"id":"1667527399645","index":9,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.9545892856654,"posY":1724.998304883954,"rect":{"x":1448.97,"y":1693,"width":64,"height":64}},{"id":"1667527406504","index":10,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1505.9443937429746,"posY":1803.998304883954,"rect":{"x":1248.96,"y":1772,"width":64,"height":64}},{"id":"1667527414914","index":11,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.934590287995,"posY":1804.9982272525526,"rect":{"x":1448.95,"y":1773,"width":64,"height":64}},{"id":"1667527423039","index":12,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1506.924393762628,"posY":1883.9982262698766,"rect":{"x":1249.94,"y":1852,"width":64,"height":64}},{"id":"1667527431966","index":13,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.9145893249724,"posY":1883.9981486384752,"rect":{"x":1448.93,"y":1852,"width":64,"height":64}},{"id":"1667527439422","index":14,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1507.9043937822817,"posY":1962.9981486384752,"rect":{"x":1250.92,"y":1931,"width":64,"height":64}},{"id":"1667527445613","index":15,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.8945883619504,"posY":1963.9980710070736,"rect":{"x":1448.91,"y":1932,"width":64,"height":64}}],"isDebug":false}
		return this.item = {"begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","page_id":"7","book_id":"opw1","part_name":"d","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/75bcd934bdd589d901b1d1dcf9e05e2b.png","rect":{"x":455.89,"y":0,"width":1729.22,"height":992}},"hotZoneItemArr":[{"id":"1667291729830","index":0,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":496},"gIdx":"0","posX":714.5,"posY":509,"rect":{"x":232.61,"y":483,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1667291758660","index":1,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":863.4985828918223,"posY":708.0011902773308,"rect":{"x":381.61,"y":682,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1667291766274","index":2,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1038.4989313227106,"posY":767.0016556313363,"rect":{"x":556.61,"y":741,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1667291773931","index":3,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1208.4993405536202,"posY":565.0017936006144,"rect":{"x":726.61,"y":539,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1667291781144","index":4,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1365.499738092218,"posY":554.0013212312218,"rect":{"x":883.61,"y":528,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1667291787620","index":5,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1519.500105230805,"posY":368.0012955081361,"rect":{"x":1037.61,"y":342,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1667291794068","index":6,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1697.5004653540052,"posY":452.00086055414096,"rect":{"x":1215.61,"y":426,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1667291799074","index":7,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1762.5008816003017,"posY":565.0010569849775,"rect":{"x":1280.61,"y":539,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1667291806543","index":8,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1672.501033600354,"posY":721.0013212312218,"rect":{"x":1190.61,"y":695,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1667291814677","index":9,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1477.5008231387435,"posY":705.0016860313468,"rect":{"x":995.61,"y":679,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1667291823228","index":10,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1371.5003671385873,"posY":813.0016486159494,"rect":{"x":889.61,"y":787,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1667291830926","index":11,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1199.5001192615794,"posY":812.0019011698821,"rect":{"x":717.61,"y":786,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1667291842195","index":12,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1326.4997170460567,"posY":247.00189883141968,"rect":{"x":844.61,"y":221,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1667291853247","index":13,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1130.500014030774,"posY":267.00057760019786,"rect":{"x":648.61,"y":241,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1667291861161","index":14,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1060.4995556921554,"posY":407.00062436944467,"rect":{"x":578.61,"y":381,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1667291869501","index":15,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":891.4993919997917,"posY":447.0009517541722,"rect":{"x":409.61,"y":421,"width":52,"height":52},"linkItem":15,"pointItem":16}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/71e68ebc76a7ce04eef418353d3f1844.png","rect":{"x":191.67,"y":0,"width":1499.67,"height":1940}},"hotZoneItemArr2":[{"id":"1667380287432","index":0,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":670.5,"posY":1410.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":277.93,"y":1022.76,"width":36.15,"height":36.15}},{"id":"1667380314762","index":1,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":827.4994456359115,"posY":1617.5012714317836,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":393.79,"y":1175.51,"width":36.15,"height":36.15}},{"id":"1667380322503","index":2,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1007.4995871564998,"posY":1680.5014580226232,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":526.61,"y":1222,"width":36.15,"height":36.15}},{"id":"1667380329891","index":3,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1185.4997494094036,"posY":1470.5015148111395,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":657.96,"y":1067.03,"width":36.15,"height":36.15}},{"id":"1667380339099","index":4,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1346.4999098594978,"posY":1458.5013255160848,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":776.77,"y":1058.18,"width":36.15,"height":36.15}},{"id":"1667380346091","index":5,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1507.5000549857066,"posY":1264.5013146992246,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":895.57,"y":915.02,"width":36.15,"height":36.15}},{"id":"1667380353829","index":6,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1690.500200111915,"posY":1351.5011398266504,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1030.61,"y":979.22,"width":36.15,"height":36.15}},{"id":"1667380360920","index":7,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1756.500365069034,"posY":1469.5012182488872,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1079.31,"y":1066.3,"width":36.15,"height":36.15}},{"id":"1667380368760","index":8,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1664.5004245617654,"posY":1629.5013246146798,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1011.42,"y":1184.36,"width":36.15,"height":36.15}},{"id":"1667380374561","index":9,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1462.5003416325035,"posY":1613.5014688394833,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":862.36,"y":1172.56,"width":36.15,"height":36.15}},{"id":"1667380381923","index":10,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1350.500159548689,"posY":1725.501454417003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":779.72,"y":1255.2,"width":36.15,"height":36.15}},{"id":"1667380387739","index":11,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1174.5000585913265,"posY":1723.5015553743654,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":649.84,"y":1253.73,"width":36.15,"height":36.15}},{"id":"1667380395200","index":12,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1306.4998999440427,"posY":1140.5015535715554,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":747.24,"y":823.52,"width":36.15,"height":36.15}},{"id":"1667380402254","index":13,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1101.5000189295056,"posY":1160.5010280524275,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":595.97,"y":838.28,"width":36.15,"height":36.15}},{"id":"1667380408975","index":14,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1028.499834141476,"posY":1304.501046080528,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":542.1,"y":944.53,"width":36.15,"height":36.15}},{"id":"1667380417184","index":15,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":853.4997683389092,"posY":1346.5011758828512,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":412.97,"y":975.53,"width":36.15,"height":36.15}}],"isDebug":true}
	
	},

	preload() {
		const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
		console.log(' in preload preloadArr: ', preloadArr);
		cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {
			console.log(' preload data, ', data);


			this.addServerListener();
			// if (window && window["air"]) {
			// 	window["air"].hideAirClassLoading();
			// }
		});
	},

	addServerListener() {
		
		if (window && window["air"]) {
			// cc.find('Canvas').opacity = 0;
			// window.air.onCourseInScreen = (next) => {
			// 	//  cc.find('Canvas').opacity = 255;
			// 	this.loadEnd();
			// 	next();
			// }
			this.loadEnd();
			window.air.hideAirClassLoading();
		} else {
			this.loadEnd();
		}


		if (window.air) {

			window.air.osmoHandwritingCallback = (data) => {

				if (!data) {
					console.log('data is not exist!!!');
					return;
				}

				console.log('osmoHandwritingCallback data: ', data);

				if (typeof (data) == 'string') {
					console.log('data is string ');
					const dataObj = JSON.parse(data);

					this.photoEnd(dataObj);
					return;
				}

				// 哲学逻辑
				this.photoEnd(data);

			}

			
		}

	},

	addPreloadImage() {
	
		if (this.data.bg_pic_url) {
			this._imageResList.push({ url: this.data.bg_pic_url || ''});
		}

		if (this.data.bgItem) {
			this._imageResList.push({ url: this.data.bgItem.url || ''});
		}

		if (this.data.bgItem2) {
			this._imageResList.push({ url: this.data.bgItem2.url || ''});
		}

		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.pic_url) {
				this._imageResList.push({ url: item.pic_url || ''});
			}
		})
	},

	addPreloadAudio() {

		if (this.data.questionArr) {
			const arr = this.data.questionArr;
			for (let i=0 ;i<arr.length; i++) {
				this._audioResList.push({url: arr[i].audio_url || ''});
				this._audioResList.push({url: arr[i].video_url || ''});
			}
		}

	},

	addPreloadAnima() {
		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.skeJsonData) {
				this._animaResList.push({ url: item.skeJsonData.url || '' });
				this._animaResList.push({ url: item.texJsonData.url || ''});
				this._animaResList.push({ url: item.texPngData.url || ''});
			}
		})
	},

	loadEnd() {
		console.log(' in loadEnd');

		// this.data.isDebug = true;

		this.initData();
		this.initView();
		// this.initMusic();

		// this.startTesting();

		// cc.debug.setDisplayStats(true);

	},

	initMusic() {
		cc.assetManager.loadRemote(this.data.bg_audio_url, (err, clip) => {
			cc.audioEngine.setMusicVolume(0.3);
			const audioID = cc.audioEngine.playMusic(clip, true);
		});
	},

	curGroupIndex: null,
	curQuestionIndex: null,
	curQuestionData: null,

	picNodeArr: null,


	firstItemData: null,
	bottomItemData: null,
	animaNodeArr: null,
	circleAnimaNodeArr: null,
	signAnimaNodeArr: null,

	initData() {
		console.log(' in initData');

		// this.curGroupIndex = 0;
		// this.curQuestionIndex = 0;
		// this.setCurGroupAndQuestion()

		// console.log('this.curQuestionData', this.curQuestionData)

		this.CHECK_TYPE_LINE = 'LINE';
		this.CHECK_TYPE_WRITE = 'WRITE';
		this.CHECK_TYPE_CIRCLE = 'CIRCLE';
		this.CHECK_TYPE_SIGN = 'SIGN';
		this.CHECK_TYPE_COLOR = 'COLOR';

		this.isHelp = true;

		this.colorUnit = 0.004;
		this.serverUnitX =  0.00333334;
		this.serverUnitY = 0.00257734;
		this.colorSprPoolArr = [];

		this.totalLineArr = [];
		this.rectNodeArr = [];

		this.picAnimNodeArr = []
		this.colorPicNodeArr = [];

		this.animaNodeArr = [];

		this.circleAnimaNodeArr = [];
		this.signAnimaNodeArr = [];

		this.picNodeArr = [];
		this.initAudioEffect();

		this.linkRectGroup = [];

		this.centerItemArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '1');
		this.benchmark1Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '3')[0];
		this.benchmark2Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '4')[0];
		this.firstItemData = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '5')[0];

		this.lineRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '0');
		this.newRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '6');
		this.circleRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '7');
		this.signRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '8');
		this.colorRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '9');


		if (this.benchmark1Data) {
			this.initCheckBase();
		} 



		this.initTypeArr();
		
	},

	initTypeArr() {
		const typeArr = this.data.typeArr;
		
		console.log('this.data.typeArr: ', this.data);

		if (!this.data.firstGIdx) {
			this.data.firstGIdx = typeArr[0].gIdx;
		} else {

			const findItem = typeArr.find(it => {
				return it.gIdx == this.data.firstGIdx
			})

			console.log('findItem: ', findItem);

			if (!findItem) {
				this.data.firstGIdx = typeArr[0].gIdx;
			}

		}

		console.log('this.data.typeArr.length: ', this.data.typeArr.length);

		console.log('arr: ', JSON.stringify(this.data.typeArr));

		console.log('this.data.firstGIdx: ', this.data.firstGIdx);
		this.typeArr = [];
		const firstType = typeArr.find((t) => {
			console.log('t.gIdx: ', t.gIdx);
			return t.gIdx == this.data.firstGIdx;
		})

		const index = typeArr.indexOf(firstType);
		console.log('firstType: ', firstType);
		typeArr.splice(index, 1);

		this.typeArr = [firstType];
		this.typeArr = this.typeArr.concat(typeArr)
		this.typeArrIndex = 0;

		console.log("this.typeArr: ", this.typeArr);
	},

	initCheckBase() {


		console.log('benchmark1Data: ', this.benchmark1Data);
		console.log('benchmark2Data: ', this.benchmark2Data);
		console.log('centerItemArr: ', this.centerItemArr);

		const benchmark1Rect = this.benchmark1Data.rect;
		const benchmark2Rect = this.benchmark2Data.rect;
		
		const benchmark1CenterY = (benchmark1Rect.y + benchmark1Rect.height / 2);
		const benchmark2CenterY = (benchmark2Rect.y + benchmark2Rect.height / 2);
		
		let unitH = benchmark2CenterY - benchmark1CenterY;
		let unitW = benchmark2Rect.x + benchmark2Rect.width - benchmark1Rect.x;
		let baseX = benchmark1Rect.x;
		let baseY = benchmark1CenterY;


		if (this.firstItemData) {
			const firstItemRect = this.firstItemData.rect;
			baseX = firstItemRect.x + firstItemRect.width / 2;
			baseY = firstItemRect.y + firstItemRect.height / 2;
			unitW = benchmark1Rect.x + benchmark1Rect.width - (firstItemRect.x + firstItemRect.width / 2);
			unitH = (firstItemRect.y + firstItemRect.height / 2) - benchmark1CenterY;
		}


		for(let i=0; i<this.centerItemArr.length; i++) {

			const itemRect = this.centerItemArr[i].rect;
			const x = itemRect.x + itemRect.width / 2;
			const y = itemRect.y + itemRect.height / 2;

			const unitX = (x - baseX) / unitW;
			const unitY = (y - baseY) / unitH;
			const unitW2 = itemRect.width / unitW;
			const unitH2 = itemRect.height / unitH;


			this.centerItemArr[i].unitX = unitX;
			this.centerItemArr[i].unitY = unitY;
			this.centerItemArr[i].unitW = unitW2;
			this.centerItemArr[i].unitH = unitH2;

			// console.log('unitX: ', unitX)
			// console.log('unitY: ', unitY)
		}

		console.log('unitH: ', unitH)
		console.log('unitW: ', unitW)
		console.log('baseX: ', baseX)
		console.log('baseY: ', baseY)

	
		const centerX = this.data.bgItem2.rect.width / 2;
		this.centerUnitW = (centerX - baseX) / unitW;



	},

	getGroupArrByGIdx(arr, gIdx) {
		const groupArr = [];
		for (let i=0; i<arr.length; i++) {
			if (arr[i].gIdx == gIdx) {

				const data = JSON.parse(JSON.stringify(arr[i]));
				groupArr.push(data);
			}
		}

		return groupArr;
	},

	curGroup: null,
	setCurGroupAndQuestion() {
		this.curGroup = this.data.groupArr[this.curGroupIndex];

		if (!this.curGroup) {
			this.gameEnd();
		} else {
			this.curQuestionIndex = 0;
			this.setCurQuestionData();
		}
	},

	setCurQuestionData() {
		this.curQuestionData = this.curGroup.questionArr[this.curQuestionIndex];

		if (!this.curQuestionData) {

			this.hideVideo();
			this.showBigStar();
		}
	},

	hideVideo() {
		this.videoNode.active = false;

		this.videoNode.player.pause();
		this.videoNode.pauseBtn.active = false;
		this.videoNode.playBtn.active = true;
	},


	rightClip: null,
	wrongClip: null,
	bigStarClip: null,
	btnClip: null,
	finishClip: null,
	selectClip: null,
	starCountClip: null,
	helpClip: null,
	initAudioEffect() {
		this.rightClip = cc.find('Canvas/res/audio/right').getComponent(cc.AudioSource).clip;
		this.wrongClip = cc.find('Canvas/res/audio/wrong').getComponent(cc.AudioSource).clip;
		this.bigStarClip = cc.find('Canvas/res/audio/big_star').getComponent(cc.AudioSource).clip;
		this.btnClip = cc.find('Canvas/res/audio/btn').getComponent(cc.AudioSource).clip;
		this.finishClip = cc.find('Canvas/res/audio/finish').getComponent(cc.AudioSource).clip;
		this.selectClip = cc.find('Canvas/res/audio/select').getComponent(cc.AudioSource).clip;
		this.starCountClip = cc.find('Canvas/res/audio/star_count').getComponent(cc.AudioSource).clip;

		
		this.helpClip = cc.find('Canvas/res/audio/help').getComponent(cc.AudioSource).clip;
	},



	initView() {

		console.log(' in initView');

		this.initBg();
		this.initHotZone();
		this.initDebugLayer();

		console.log(' in initView 2');
	
		this.initCat();
	},


	initCat() {

		const cat = cc.find("Canvas/catNode/cat")
		cat.parent.zIndex = 10;
		this.cat = cat;

		this.canTouch = false;
		this.playCatAudio(this.data.begin_audio_url, () => {
			this.canTouch = true;
			// this.isPanelMoveEnd = true;

			this.catBeginEnd = true;
			this.checkStart();
		});

		this.curCatAudioUrl = this.data.idle_audio_url;

		const clickBox = cc.find("Canvas/catNode/clickBox")
		clickBox.on('touchstart', () => {

			console.log(' in cat touchstart')

			let url = this.curCatAudioUrl;
			if (!url) {
				return;
			}
 
			if (!this.canTouch) {
				return;
			}
			
			this.canTouch = false;

			this.playCatAudio(url, () => {
				this.canTouch = true;
			})

		})
	},

	playCatAudio(audioUrl, cb=null) {

		console.log('_ playCatAudio:  ', audioUrl);

		if (this.curCatAudioId) {
			cc.audioEngine.pauseEffect(this.curCatAudioId);
		}

		if (audioUrl) {

			this.playCatAnim('begin');
			playAudioByUrl(audioUrl, () => {
				this.playCatAnim('normal');
				cb && cb();
			})
		} else {
			cb && cb();

		}
		
	},

	playCatAnim(name, times = 0) {
		const cat = cc.find("Canvas/catNode/cat")		
		var dragonDisplay = cat.getComponent(dragonBones.ArmatureDisplay);
		const state = dragonDisplay.playAnimation(name, times);
	},
	


	initTestPointArr() {
		
		const linkeItemArr = this.data.hotZoneItemArr.filter(hzItem => {
			return hzItem.gIdx == '0';
		})

		const bgRect = this.data.bgItem2.rect;

		const setDebugCenterPos = (hzItem) => {

			const debugItemIndex = (Number(hzItem.pointItem) - 1) 
			const debugItem = this.data.hotZoneItemArr2[debugItemIndex];
			const {rect} = debugItem

			const left = Math.round( (rect.x ) / bgRect.width  * 1000 ) / 1000;
			const right =  Math.round( (rect.x + rect.width) / bgRect.width * 1000 ) / 1000;
			const top =  Math.round( (rect.y ) / bgRect.height * 1000 ) / 1000;
			const bottom =  Math.round( (rect.y + rect.height) / bgRect.height * 1000 ) / 1000;
	
			
			const x = left + (right - left) / 2;
			const y = bottom - (bottom - top) / 2;

			hzItem.debugCenterPos = [x, y];
		}

		console.log('linkeItemArr: ', linkeItemArr);

		linkeItemArr.forEach(hzItem => {
			return setDebugCenterPos(hzItem);
		})

		const startPosObj = {};
		const endPosObj = {};

		for (let i=0; i<linkeItemArr.length; i++) {
			const index = this.data.hotZoneItemArr.indexOf(linkeItemArr[i]);
			const key = (index + 1).toString();
			if (!startPosObj[key] && !endPosObj[key]) {
				startPosObj[key] = linkeItemArr[i];


				const endKey = linkeItemArr[i].linkItem.toString();
				const endIndex = Number(endKey) - 1;
				const endItem = this.data.hotZoneItemArr[endIndex];
				endPosObj[endKey] = endItem;
			}
		}

		console.log('startPosObj: ', startPosObj);
		console.log('endPosObj: ', endPosObj);

		
		console.log('this.end_points: ', this.end_points);

	
	},

	resetHotZoneBg() {

		this.hotZoneBg.opacity = 0;	
		const panel = this.hotZoneBg.parent;
		const w = panel.width * 0.95;
		const h = panel.height * 0.9;
		

		const region = this.getRegionsByGidx('2')[0];
		const partW = region.right - region.left;
		const partH = region.bottom - region.top;
		const scaleX = w / partW;
		const scaleY = h / partH;
		const scale = Math.min(scaleX, scaleY);
		const bgW = partW * scale;
		const bgH = partH * scale;

		const node = new cc.Node();
		node.parent = panel;
		node.width = bgW / partW;
		node.height = bgH / partH;

		const rectX = (-0.5 + region.left) * node.width;
		const rectY = (0.5 - region.bottom) * node.height;
		const rectW = partW * node.width;
		const rectH = partH * node.height;
		const ctx = node.addComponent(cc.Graphics);
		ctx.rect(rectX, rectY, rectW, rectH);
		ctx.fillColor = cc.Color.WHITE;
		ctx.fill();

		node.y = 3 - (rectY + rectH / 2);

		this.colorDrawLayer = new cc.Node();
		node.addChild(this.colorDrawLayer);
		
		this.colorBg = node;
	},


	checkStart() {

		console.log(' in checkStart')
		if (this.debugBgImg && this.hzLoadEnd && this.catBeginEnd) {
			this.startTesting();

		}

	},

	getSendCirclePoints(tempCirclePointArr) {

		console.log('tempCirclePointArr: ' , tempCirclePointArr);
		
		const sendCirclePointArr = [];

		for (let i=0; i<tempCirclePointArr.length; i++) {
			const {left, top, right, bottom, isMultRect} = tempCirclePointArr[i];

			let data;
			if (isMultRect) {
				console.log("in isMultRect")
				data = {
					left,
					right,
					top,
					bottom
				}
			} else {
				let newLeft = left + (right - left) / 2;
				let newTop = top + (bottom - top) / 2;
				newLeft = roundNum(newLeft, 10000);
				newTop = roundNum(newTop, 10000);
				data = {
					left: newLeft,
					right: newLeft,
					top: newTop,
					bottom: newTop
				}
			}

			console.log("data~:", data);
			sendCirclePointArr.push(data);
			// const tempLink1 = tempCirclePointArr[i];
			// const key2 = tempLink1.linkItem;
			// const tempLink2 = tempCirclePointArr[Number(key2)-1];

			// if (!tempLink1.isGetLinked && !tempLink2.isGetLinked) {
			// 	tempLink1.isGetLinked = true;
			// 	tempLink2.isGetLinked = true;

			// 	const pKey1 = tempLink1.pointItem;
			// 	const pKey2 = tempLink2.pointItem;

			// 	const pointItem1 = this.data.hotZoneItemArr2[Number(pKey1) - 1];
			// 	const pointItem2 = this.data.hotZoneItemArr2[Number(pKey2) - 1];

			// 	const region1 = this.getRegionByRect(pointItem1.rect, bgRect);
			// 	const region2 = this.getRegionByRect(pointItem2.rect, bgRect);

			// 	let x1 = region1.left + (region1.right - region1.left) / 2;
			// 	let y1 = region1.top + (region1.bottom - region1.top) / 2;

			// 	let x2 = region2.left + (region2.right - region2.left) / 2;
			// 	let y2 = region2.top + (region2.bottom - region2.top) / 2;

			// 	x1 = Math.floor(x1 * 1000) / 1000;
			// 	y1 = Math.floor(y1 * 1000) / 1000;
			// 	x2 = Math.floor(x2 * 1000) / 1000;
			// 	y2 = Math.floor(y2 * 1000) / 1000;

			// 	sendCirclePointArr.push( {left:x1, top: y1, right:x2, bottom: y2} )
			// }
		}

		console.log("sendCirclePointArr: ", sendCirclePointArr);
		return sendCirclePointArr;
	},


	getSendLinePoints() {

		const hotZoneItemArr = JSON.parse( JSON.stringify(this.data.hotZoneItemArr) );

		const tempLinkArr = this.getGroupArrByGIdx(hotZoneItemArr, '0');

		console.log('tempLinkArr: ' , tempLinkArr);

		const bgRect = this.data.bgItem2.rect;
		
		const sendLinkPointArr = [];


		for (let i=0; i<tempLinkArr.length; i++) {
			const tempLink1 = tempLinkArr[i];
			const key2 = tempLink1.linkItem;
			const tempLink2 = hotZoneItemArr[Number(key2)-1];

			if (!tempLink1.isGetLinked && !tempLink2.isGetLinked) {
				tempLink1.isGetLinked = true;
				tempLink2.isGetLinked = true;

				const pKey1 = tempLink1.pointItem;
				const pKey2 = tempLink2.pointItem;

				const pointItem1 = this.data.hotZoneItemArr2[Number(pKey1) - 1];
				const pointItem2 = this.data.hotZoneItemArr2[Number(pKey2) - 1];

				const region1 = this.getRegionByRect(pointItem1.rect, bgRect);
				const region2 = this.getRegionByRect(pointItem2.rect, bgRect);

				let x1 = region1.left + (region1.right - region1.left) / 2;
				let y1 = region1.top + (region1.bottom - region1.top) / 2;

				let x2 = region2.left + (region2.right - region2.left) / 2;
				let y2 = region2.top + (region2.bottom - region2.top) / 2;

				x1 = Math.floor(x1 * 1000) / 1000;
				y1 = Math.floor(y1 * 1000) / 1000;
				x2 = Math.floor(x2 * 1000) / 1000;
				y2 = Math.floor(y2 * 1000) / 1000;

				sendLinkPointArr.push( {left:x1, top: y1, right:x2, bottom: y2} )
			}
		}

		console.log("sendLinkPointArr: ", sendLinkPointArr);
		return sendLinkPointArr;

		// for (let i=0; i<regions.length; i++) {
		// 	const oneRegion = regions[i];
		// 	console.log('oneRegion: ', oneRegion);
		// 	const x = oneRegion.left + (oneRegion.right - oneRegion.left) / 2;
		// 	const y = oneRegion.top + (oneRegion.bottom - oneRegion.top) / 2;
		// }
	},


	resetHelperTime() {

		this.helperTime = new Date().getTime();

	},

	showHelper() {

		if (!this.isHelp) {
			return;
		}

		if (this.itemCombineGroup && this.itemCombineGroup.length > 0) {
			return;
		}

		console.log("in showHelper");

		this.helpAudioId = playAudio(this.helpClip, () => {

			this.helpAudioId = null;

			switch(this.curCheckGroup) {
				case this.CHECK_TYPE_LINE:
					this.showHelperLink();
					// 连线
					break;
	
				case this.CHECK_TYPE_WRITE:
					this.showHelperWrite();
					// 手写
					break;
	
				case this.CHECK_TYPE_CIRCLE:
					this.showHelperCircle();
					// 画圈
					break;
	
				case this.CHECK_TYPE_SIGN:
					this.showHelperSign();
					// 符号
					break;
			}

		})
		
	},

	showHelperSign() {

		for (let i = 0; i < this.signAnimaNodeArr.length; i++) {

			const animaNode = this.signAnimaNodeArr[i];

			if (!animaNode.isShowEnd) {
		
				this.showSign(animaNode);
				break;
			}
			
		}
	},
	

	showHelperCircle() {
		
		for (let i = 0; i < this.circleAnimaNodeArr.length; i++) {

			const animaNode = this.circleAnimaNodeArr[i];

			if (!animaNode.isShowEnd) {

				this.showCircle(animaNode);
				break;				
			}
			
		}

	},

	showHelperWrite() {

		let arr = this.animaNodeArr;
		if (this.picAnimNodeArr.length > 0) {
			arr = this.picAnimNodeArr;
		}

		for (let i = 0; i < arr.length; i++) {

			const animaNode = arr[i];
			if (!animaNode.isShowEnd) {

				if (this.picAnimNodeArr.length > 0) {
					this.showLetterPic(animaNode);
				} else {
					this.showLetter(animaNode);
				}
				break;
			}
		}
	},

	
	showHelperLink() {

		console.log(' in showHelperLink..');
		
		let item;
		for (let i=0; i<this.linkRectGroup.length; i++) {

			const {hzItemId} = this.linkRectGroup[i].linkData;

			const rectNode = this.getItemById(hzItemId);
			
			if (!rectNode.isShowEnd && this.linkRectGroup[i].isRightPoint) {
				item = this.linkRectGroup[i];
				break;
			}
		}

		if (item) {
			const {hzItemId, linkHzItemId} = item.linkData
			this.showSuccess(hzItemId, linkHzItemId);
		}
	},


	startHelper() {

		this.resetHelperTime();
		this.isHelpCountDown = true;

		const checkTime = () => {

			if (!this.isHelpCountDown) {
				return;
			}

			let disTime = 10;
			if (this.data.helpTime) {

				if (this.data.helpTime <= 0) {
					return;
				}
				disTime = this.data.helpTime;
			}

			const curTime = new Date().getTime();
			if (curTime - this.helperTime > disTime * 1000) {
				this.showHelper();
				this.resetHelperTime();
			} 
			// else {
	
			// 	delayCall(0.1, () => {
			// 		checkTime();
			// 	})
			// }

			delayCall(0.05, () => {
				checkTime();
			})
		}

		checkTime();
		
	},

	pauseHelper() {
		if (this.helpAudioId) {
			cc.audioEngine.stopEffect(this.helpAudioId);
			this.helpAudioId = null;
		}
	},

	stopHelper() {
		this.isHelpCountDown = false;
	},


	//调起检测
	startTesting() {


		this.isGameEnd = false;

		this.startHelper();


		const writeRegions = this.getRegionsByGidx('6')
		const circleRegions = this.getRegionsByGidx('7')
		const signRegions = this.getRegionsByGidx('8')
		const colorRegions = this.getRegionsByGidx('9')
		const partRegions = this.getRegionsByGidx('2')

		// this.changeRegionTo4Pos(signRegions);


		// let lineRegions = this.getRegionsByGidx('0')

		const newPoints = this.getSendLinePoints();
		const newCirclePoints = this.getSendCirclePoints(circleRegions);

		console.log('writeRegions: ', writeRegions);
		console.log('circleRegions: ', circleRegions);
		console.log('newPoints: ', newPoints);
		console.log('signRegions: ', JSON.stringify(signRegions));
		console.log('newCirclePoints: ', newCirclePoints);

		

	 

		// const tempType = this.typeArr[this.typeArrIndex];
		// this.curCheckType = '';
		// switch(tempType.gIdx) {
		// 	case "0":
		// 		// 连线
		// 		this.curCheckGroup = this.CHECK_TYPE_LINE;
		// 		break;

		// 	case "1":
		// 		// 手写
		// 		this.curCheckGroup = this.CHECK_TYPE_WRITE;
		// 		break;

		// 	case "2":
		// 		// 画圈
		// 		this.curCheckGroup = this.CHECK_TYPE_CIRCLE;
		// 		break;

		// 	case "4":
		// 		// 符号
		// 		this.curCheckGroup = this.CHECK_TYPE_SIGN;
		// 		this.initItemCombineGroup();
		// 		break;

		// 	case "5":
		// 		// 涂色
		// 		this.curCheckGroup = this.CHECK_TYPE_COLOR;
		// 		break;
		// 	}

		// 	// setInterval(() => {
		// 		this.getPhotoData((data) => { 
		// 			this.photoEnd(data);
		// 		});    
		// 	// }, 3000);

		// 	console.log('curCheckGroup: ', JSON.stringify( this.curCheckGroup ));

		// return;





		// write_regions : []

		let lineType = 1;
		let circleSize = 1;

		if (this.data.lineType == '0') {
			lineType = 0;
		}
		if (this.data.circleSize == '0') {
			circleSize = 0;
		}
		
		

		const para = {
			"library_id": "iplayabc",
			"page_id": this.data.page_id, //27,
			"book_id": this.data.book_id,//"opw1",
			"part_name": this.data.part_name, //"d",
		
			"write_regions": [],
			"circle_regions": [],//circleRegions,
			"line_regions": [],
			'sign_regions': [],
			'color_regions': [],
			lineType,
			circleSize
		}


	

		const curCheckGroup = this.typeArr[this.typeArrIndex];
		this.curCheckType = '';
		switch(curCheckGroup.gIdx) {
			case "0":
				// 连线
				para.line_regions = newPoints;
				this.curCheckGroup = this.CHECK_TYPE_LINE;
				break;

			case "1":
				// 手写
				para.write_regions = writeRegions;
				this.curCheckGroup = this.CHECK_TYPE_WRITE;
				break;

			case "2":
				// 画圈
				para.circle_regions = newCirclePoints;
				this.curCheckGroup = this.CHECK_TYPE_CIRCLE;
				break;

			case "4":
				// 符号
				para.sign_regions = signRegions;
				this.curCheckGroup = this.CHECK_TYPE_SIGN;
				this.initItemCombineGroup();
				break;

			case "5":
				// 涂色
				// para.color_regions = colorRegions;
				para.color_regions = partRegions;
				this.curCheckGroup = this.CHECK_TYPE_COLOR;
				this.preloadColorSpr();
				break;
				
			case "6":
				// 手写图片
				para.write_regions = writeRegions;
				this.curCheckGroup = this.CHECK_TYPE_WRITE;
				break;
		}


		console.log('curCheckGroup: ', JSON.stringify( this.curCheckGroup ));
		console.log('para: ', JSON.stringify( para ));


		const cw = window.courseware;
		if (!cw || !cw.openOsmoHandwriting) {

			console.log('cw.openOsmoHandwriting not exist');
			return;
		}

		cw.openOsmoHandwriting(para);

	},

	//结束检测
	endTesting() {
		
		this.stopHelper();

		const cw = window.courseware;
		if (!cw || !cw.closeOsmoHandwriting) {

			return;
		}
		cw.closeOsmoHandwriting();

		// const cw = window.courseware;
		// if (!cw || !cw.closeOsmoHandwritingMlkit) {

		// 	return;
		// }
		// cw.closeOsmoHandwritingMlkit();
		// // this.isTesting = false;
	},

	changeRegionTo4Pos(regions) {

		for (let i=0; i<regions.length; i++) {
			const {left, top, right, bottom} = regions[i];
			regions[i] = [

					left, top,
					right, top,
					right, bottom,
					left, bottom

			]
		}
		
	},

	initItemCombineGroup() {
		this.itemCombineGroup = this.data?.itemCombineGroup;
	},

	preloadColorSpr() {
		this.isHelp = false;
		for (let i=0; i<20000; i++) {
			const colorNode = this.getColorBgColorDot(0, 0, this.colorUnit, this.colorUnit);
		}
	},

	getRegionsByGidx(gIdx) {

		const arr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, gIdx);
		const bgRect = this.data.bgItem2.rect;
		
		console.log("arr:", arr);
		const newLocationArr = [];
		for (let i=0; i<arr.length; i++) {

			const hzItem = arr[i];
			const regionRect = hzItem.rect;

			let region = this.getRegionByRect(regionRect, bgRect);

			if (hzItem.multRect) {

				if (gIdx == "7") {
					region = this.getCircleRegionByMultRect(hzItem.multRect);
					console.log('region: ', region);
				}
			}

			newLocationArr.push(region)
		}

		return newLocationArr;

	},

	getRegionByRect(regionRect, bgRect) {

		const left = Math.round( (regionRect.x ) / bgRect.width  * 1000 ) / 1000;
		const right =  Math.round( (regionRect.x + regionRect.width) / bgRect.width * 1000 ) / 1000;
		const top =  Math.round( (regionRect.y ) / bgRect.height * 1000 ) / 1000;
		const bottom =  Math.round( (regionRect.y + regionRect.height) / bgRect.height * 1000 ) / 1000;

		return {left, top, right, bottom};
	},

	getCircleRegionByMultRect(multRect) {

		const bgRect = this.data.bgItem2.rect;
		const data1 = multRect[0];
		const data2 = multRect[1];
	
		const region1 = this.getRegionByRect(data1.rect, bgRect);
		const region2 = this.getRegionByRect(data2.rect, bgRect);

		let x1 = region1.left + (region1.right - region1.left) / 2;
		let y1 = region1.top + (region1.bottom - region1.top) / 2;
		let x2 = region2.left + (region2.right - region2.left) / 2;
		let y2 = region2.top + (region2.bottom - region2.top) / 2;

		x1 = roundNum(x1, 10000);
		y1 = roundNum(y1, 10000);
		x2 = roundNum(x2, 10000);
		y2 = roundNum(y2, 10000);

		return {left:x1, top:y1, right:x2, bottom:y2, isMultRect: true};
	},



	changeWriteData(result) {
		const curTextArr = result.text;
		const bboxTextArr = [];
		for (let i=0; i<curTextArr.length; i++) {

			const score = curTextArr[i].score;

			const {left, right, top, bottom} = curTextArr[i];
			const text = curTextArr[i].content;

			console.log('text..', JSON.stringify( curTextArr[i] ));
			console.log('text..', text);
			const disW = (right - left) / text.length;
			const disH = (bottom - top);
			for (let j=0; j<text.length; j++) {

				const x1 = left + j * disW;
				const y1 = top;

				const x2 = x1 + disW;
				const y2 = y1;

				const x3 = x2;
				const y3 = y2 + disH;

				const x4 = x1;
				const y4 = y3;

				// const bbox = [{x1, y1}, {x2, y2}, {x3, y3}, {x4, y4}]
				const bbox = {left: x1, right: x2, top: y1, bottom: y3}


				// this.changeBboxPos(bbox);

				const content = text[j];
				bboxTextArr.push({bbox, content, score});
			}

		}

		result.text = bboxTextArr;

	},


	locate(x1, y1, x2, y2, x3, y3) {
			var a, b;
			a = (y2 - y1) / (x2 - x1);
			b = y1 - a * x1;

			var xMiddle = (x1 + x2) / 2;
			var yMiddle = (y1 + y2) / 2;
			var c, lastX, lastY;
			if (a != 0) {
					c = yMiddle - (-1 / a) * xMiddle;
					lastX = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) - 2 * c * y1 + 2 * c * y3) / (2 * ((x1 - x3) - (1 / a) * (y1 - y3)));
					lastY = (-1 / a) * lastX + c;
			} else {
					lastX = c = xMiddle;
					lastY = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) + 2 * lastX * (x3 - x1)) / (2 * (y1 - y3));
			}
			console.log("定位点X坐标: " + lastX);
			console.log("定位点Y坐标: " + lastY);

			return {x: lastX, y: lastY};
	},

	

	setOneAnswerDataCircle(colorRect, answerData) {
		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);


		// const targetLabelText = colorRect.labelText;

		// const newRectCheckArr = this.newRectCheckArr;
		const checkArr = this.circleRectCheckArr;

		for (let i=0; i<checkArr.length; i++) {

			const checkRect = checkArr[i].ccRect;
			const key = checkArr[i].data.index + 1;

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (checkRect.contains(dotV2)) {

				answerData[key] = {isFinish: true};

			}

		}

	},


	setOneAnswerDataLink(firstPos, lastPos, answerData) {


		const w = this.debugLayer.width;
    const h = this.debugLayer.height;
    const checkP1 = cc.v2(firstPos.x * w, -firstPos.y * h);
    const checkP2 = cc.v2(lastPos.x * w, -lastPos.y * h);



		let firstPosRectId = -1;
		let lastPosRectId = -1;

		const worldPos1 = this.debugLayer.convertToWorldSpaceAR(cc.v2(checkP1.x, checkP1.y));
		const worldPos2 = this.debugLayer.convertToWorldSpaceAR(cc.v2(checkP2.x, checkP2.y));


		// console.log('worldPos1: ', JSON.stringify(worldPos1));
		// console.log('worldPos2: ', JSON.stringify(worldPos2));

		for (let i=0; i<this.linkRectGroup.length; i++) {
			const rect = this.linkRectGroup[i].ccRect;

			// console.log('rect: ', JSON.stringify(rect));


      if (rect.contains(worldPos1)) {
        firstPosRectId = i;
        // break;
			} 
      if (rect.contains(worldPos2)) {
        lastPosRectId = i;
        // break;
			} 
		}

		console.log('firstPosRectId: ', firstPosRectId);
		console.log('lastPosRectId: ', lastPosRectId);

		if (firstPosRectId != -1 && lastPosRectId != -1 && firstPosRectId != lastPosRectId) {

      answerData[firstPosRectId.toString()] = [firstPosRectId, lastPosRectId];
      this.addDebugLayerDot(checkP1.x, checkP1.y, 10, cc.Color.GREEN);
      this.addDebugLayerDot(checkP2.x, checkP2.y, 10, cc.Color.GREEN);
    }

	},

	addDebugLayerDot(x, y, r=10, color = null) {
    const dotNode = new cc.Node();

    const ctx = dotNode.addComponent(cc.Graphics);
    ctx.fillColor = color || cc.Color.BLUE;
    ctx.circle(x, y, r);
    ctx.fill();

    this.debugDrawLayer.addChild(dotNode);

    const w = this.debugLayer.width;
    const h = this.debugLayer.height;
    const rateX = x / w;
    const rateY = y / h;
    
    console.log('ratePos: {x: ' + rateX + ', y: ' + rateY + '}')
  },

	photoEndLineRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}



		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const points = oneTextData.points;

			const point1_x = points[0];
			const point1_y = points[1];
			const point2_x = points[2];
			const point2_y = points[3];

			// const rect1 = {
			// 	x:point1_x,
			// 	y: -point1_y,
			// 	width: 0.01,
			// 	height: 0.01
			// }

			// const colorRect1 = this.getColorDot(rect1.x, rect1.y, rect1.width, rect1.height, "purple");
			// this.debugDrawLayer.addChild(colorRect1, 1);
		

			// const rect2 = {
			// 	x:point2_x,
			// 	y: -point2_y,
			// 	width: 0.01,
			// 	height: 0.01
			// }

			// const colorRect2 = this.getColorDot(rect2.x, rect2.y, rect1.width, rect1.height, "purple");
			// this.debugDrawLayer.addChild(colorRect2, 1);

			this.drawUserLine([{x:point1_x, y: point1_y}, {x: point2_x, y: point2_y}]);

			this.setOneAnswerDataLink({x:point1_x, y: point1_y}, {x: point2_x, y: point2_y}, answerData);
		}


		this.showLinkAnswer(answerData);
	},

	drawUserLine(path) {
		this.drawOnePath(path);
	},

	drawOnePath(path) {
    const lineNode = new cc.Node();
    this.debugDrawLayer.addChild(lineNode);

    const w = this.debugLayer.width;
    const h = this.debugLayer.height;



    const subY = 0; //-canvas.height / 2;
    const ctx = lineNode.addComponent(cc.Graphics);
    ctx.lineWidth = 10;
    ctx.strokeColor = cc.Color.RED;
    ctx.fillColor = cc.Color.BLACK;
    

    ctx.moveTo(path[0].x * w, -path[0].y * h + subY);

    for (let i = 1; i < path.length; i++) {
      const x = path[i].x * w;
      const y = -path[i].y * h + subY;

      ctx.lineTo(x, y);
    }
    ctx.stroke();
  },

	showLinkAnswer(answerData) {

    for (let key in answerData) {

      const tempArr = answerData[key];

      const firstItemIndex = tempArr[0];
      const lastItemIndex = tempArr[1];

			const debugFirstItem = this.linkRectGroup[firstItemIndex];
			const debugLastItem = this.linkRectGroup[lastItemIndex];

			console.log('linkdebugId: ', debugFirstItem.linkData.linkDebugItemId);
			console.log('debugLastItem.linkData.debugItemId: ', debugLastItem.linkData.debugItemId)
			console.log('debugFirstItem.isRightPoint: ', debugFirstItem.isRightPoint)

			const hzItemIdFirst = debugFirstItem.linkData.hzItemId
			const hzItemIdLast = debugLastItem.linkData.hzItemId
			const startItem = this.getItemById(hzItemIdFirst);
			const endItem = this.getItemById(hzItemIdLast);
			if (startItem.isShowEnd || endItem.isShowEnd) {
				return;
			}

			if ((startItem.isRightPoint && endItem.isRightPoint) && debugFirstItem.linkData.linkDebugItemId == debugLastItem.linkData.debugItemId) {
				
				const {hzItemId, linkHzItemId} = debugFirstItem.linkData
				this.showSuccess(hzItemId, linkHzItemId);

			} else {			

			}

    }


		// for (let key in answerData) {

    //   const tempArr = answerData[key];

    //   const firstItemIndex = tempArr[0];
    //   const lastItemIndex = tempArr[1];

		// 	const debugFirstItem = this.linkRectGroup[firstItemIndex];
		// 	const debugLastItem = this.linkRectGroup[lastItemIndex];

		// 	console.log('linkdebugId: ', debugFirstItem.linkData.linkDebugItemId);
		// 	console.log('debugLastItem.linkData.debugItemId: ', debugLastItem.linkData.debugItemId)
		// 	console.log('debugFirstItem.isRightPoint: ', debugFirstItem.isRightPoint)

		// 	const hzItemIdFirst = debugFirstItem.linkData.hzItemId
		// 	const hzItemIdLast = debugLastItem.linkData.hzItemId
		// 	const startItem = this.getItemById(hzItemIdFirst);
		// 	const endItem = this.getItemById(hzItemIdLast);
		// 	if (startItem.isShowEnd || endItem.isShowEnd) {
		// 		return;
		// 	}

		// 	if (debugFirstItem.isRightPoint && debugFirstItem.linkData.linkDebugItemId == debugLastItem.linkData.debugItemId) {
				
		// 		// const {hzItemId, linkHzItemId} = debugFirstItem.linkData
		// 		// this.showSuccess(hzItemId, linkHzItemId);

		// 	} else {			

				
		// 		this.showFail(hzItemIdFirst, hzItemIdLast);
		// 		this.playCatAudio(this.data.error_link_audio_url);

		// 	}

    // }


  },

	showSuccess(startItemId, endItemId) {

		console.log( ' in showSuccess');

		const startItem = this.getItemById(startItemId);
		const endItem = this.getItemById(endItemId);

		if (startItem.isShowEnd || endItem.isShowEnd) {
			return;
		}
		startItem.isShowEnd = true;
		endItem.isShowEnd = true;

		const isLinked = this.checkIsLinked(startItem, endItem);
		if (isLinked) {
			return;
		}

		this.addLinkItem(startItem, endItem);
		this.addLinkItem(endItem, startItem);


		const pos1 = startItem.getPosition();
		pos1.x += startItem.width / 2;
		pos1.y += startItem.height / 2;
		const pos2 = endItem.getPosition();
		pos2.x += endItem.width / 2;
		pos2.y += endItem.height / 2;

		const greenColor = new cc.Color();
		greenColor.fromHEX("#519F00"); 
		const line = this.getLine(pos1, pos2, greenColor);
		this.addLinkLine(startItem, endItem, line);
		line.isRight = true;

		const maskNode = new cc.Node();
		maskNode.width = 0;
		maskNode.height = 0;
		maskNode.x = pos1.x;
		maskNode.y = pos1.y;
		this.hotZoneBg.addChild(maskNode);


		const mask = maskNode.addComponent(cc.Mask);
		mask.type = cc.Mask.Type.ELLIPSE;
		mask.segments = 32;

		maskNode.addChild(line);
		// line.mask = mask;

		this.isCurLinked = true;

		cc.tween(maskNode)
			.to(1.5, {width: this.canvas.width * 2, height: this.canvas.height * 2}, {easing: 'sineOut'})
			.call(() => {
				maskNode.removeComponent(cc.Mask);
			})
			.start();
		
		playAudio(this.rightClip, () => {
			
		})
		
		if (!this.isGameEnd) {
			const arr = this.rectNodeArr.filter((r) => {
				return r.isRightPoint == true;
			})
			this.checkGameEnd(arr);
		}
	},

	addLinkLine(item1, item2, line) {
		if ( !item1.lineArr ) {
			item1.lineArr = [];
		}

		if (!item2.lineArr) {
			item2.lineArr = [];
		}
		
		item1.lineArr.push(line);
		item2.lineArr.push(line);
		line.itemArr = [item1, item2];
		this.totalLineArr.push(line);
	},

	checkIsLinked(startItem, endItem) {
		const linkItemArr1 = startItem.linkItemArr || [];
		const linkItemArr2 = endItem.linkItemArr || [];

		return (linkItemArr1.indexOf(endItem) != -1 && linkItemArr2.indexOf(startItem) != -1);
	},

	addLinkItem(item, linkItem) {
		if (!item.linkItemArr) {
			item.linkItemArr = [];
		}

		if (item.linkItemArr.indexOf(linkItem) == -1) {
			item.linkItemArr.push(linkItem);
		}
	},

	getLine(item1, item2, color=cc.Color.BLACK) {
		const lineNode = new cc.Node();


		const ctx = lineNode.addComponent(cc.Graphics);
		ctx.lineWidth = 5;
    ctx.strokeColor = color;
    ctx.fillColor = color;

    ctx.moveTo(0, 0);
		ctx.lineTo(item2.x - item1.x, item2.y - item1.y);
		ctx.stroke();

		const dot1 = this.getDot(0, 0, ctx.lineWidth/2, ctx.strokeColor);
		dot1.parent = lineNode;

		const dot2 = this.getDot(item2.x - item1.x, item2.y - item1.y, ctx.lineWidth/2, ctx.strokeColor);
		dot2.parent = lineNode;

		return lineNode;
	},

	getDot(x, y, r, color) {

		const dotNode = new cc.Node();

    const ctx = dotNode.addComponent(cc.Graphics);
    ctx.fillColor = color || cc.Color.BLUE;
    ctx.circle(x, y, r);
    ctx.fill();

		return dotNode;
	},


	getItemById(id) {

		console.log('getItemById id:', id);
		console.log('this.rectNodeArr: ', this.rectNodeArr);

		const targetItem = this.rectNodeArr.find( node => {

			const data = node.data;

			console.log('data~~: ', JSON.stringify(data));


			if (data && (data.index + 1 == id)) {
				return true;
			}
		})
		return targetItem;
	},


	cleanColorDrawLayer() {
		const layer = this.colorDrawLayer;
		const children = layer.children;
		for (let i=0; i<children.length; i++) {
			this.pushColorPoolSpr(children[i]);
		}
	},

	pushColorPoolSpr(spr) {
		spr.opacity = 0

		this.colorSprPoolArr.push(spr);
	},

	getColorPoolSpr() {
		let spr;
		if (this.colorSprPoolArr.length > 0) {
			spr = this.colorSprPoolArr.pop();
			spr.opacity = 255;
		} else {
			spr = getSprNode('white_dot');
			this.colorDrawLayer.addChild(spr);
		}

		return spr;
	},

	photoEndColorRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			console.log(' photoEndColorRect 1')
			return;
		}

		const {colors, points} = textArr[0]
		if (!colors || !points) {
			console.log(' photoEndColorRect 2')
			return;
		}

		this.cleanColorDrawLayer();


		for (let i=0; i<this.colorRectCheckArr.length; i++) {
			const leftEdgeX = this.colorRectCheckArr[i].x / this.debugBgImg.width;
			const rightEdgeX = (this.colorRectCheckArr[i].x + this.colorRectCheckArr[i].width * this.colorRectCheckArr[i].scaleX) / this.debugBgImg.width;
			// const topEdgeY = (this.debugBgImg.height + this.colorRectCheckArr[i].y - this.colorRectCheckArr[i].height)  / this.debugBgImg.height;
			const topEdgeY = -(this.colorRectCheckArr[i].y + this.colorRectCheckArr[i].height * this.colorRectCheckArr[i].scaleY)  / this.debugBgImg.height;
			// const bottomEdgeY = (this.debugBgImg.height + this.colorRectCheckArr[i].y)  / this.debugBgImg.height;
			const bottomEdgeY = -(this.colorRectCheckArr[i].y)  / this.debugBgImg.height;
			

			console.log("leftEdgeX: ", leftEdgeX);
			console.log("rightEdgeX: ", rightEdgeX);
			console.log("topEdgeY: ", topEdgeY);
			console.log("bottomEdgeY: ", bottomEdgeY);

			this.colorRectCheckArr[i].leftEdgeX = leftEdgeX
			this.colorRectCheckArr[i].rightEdgeX = rightEdgeX
			this.colorRectCheckArr[i].topEdgeY = topEdgeY
			this.colorRectCheckArr[i].bottomEdgeY = bottomEdgeY
			this.colorRectCheckArr[i].colorPoints = [];
		}
		
		for (let i=0; i<points.length; i+=2) {


			const pointX = points[i];

			if (!pointX) {
				break;
			}
			const pointY = points[i+1];
			const color = colors[i/2];


			for (let j=0; j<this.colorRectCheckArr.length; j++) {
			
				const {leftEdgeX,rightEdgeX, topEdgeY, bottomEdgeY} = this.colorRectCheckArr[j];

				if (pointX < leftEdgeX) {
					// console.log(' return ~ 1');
					continue;
				}
				if (pointX > rightEdgeX) {
					// console.log(' return ~ 2');
					continue;
				}
				if (pointY < topEdgeY) {
					// console.log(' return ~ 3');
					continue;
				}
				if (pointY > bottomEdgeY) {
					// console.log(' return ~ 4');
					continue;
				}
		
				const r = color[0];
				const g = color[1];
				const b = color[2];

				if (!(r > 230 && g > 230 && b > 230)) {
					// this.colorRectCheckArr[j].colorPoints.push({pointX, pointY, color});
					this.colorRectCheckArr[j].colorPoints.push({});
				}


			}


				const colorNode = this.getColorBgColorDot(pointX, -pointY, this.colorUnit, this.colorUnit);

				colorNode.x -= this.colorBg.width / 2;
				colorNode.y += this.colorBg.height / 2;

				const pointColor = new cc.Color();

	
				pointColor.r = color[0] * 1.1
				pointColor.g = color[1] * 1.1
				pointColor.b = color[2] * 1.1
				colorNode.color = pointColor;


	
			// }

		}



		const answerData = {};


		for (let i=0; i<this.colorRectCheckArr.length; i++) {
			const colorPoints = this.colorRectCheckArr[i].colorPoints;
			const pointsMax = this.colorRectCheckArr[i].pointsMax;

			console.log('point rate : ', (colorPoints.length / pointsMax));

			if (colorPoints.length / pointsMax >= 0.8) {

				const key = (this.colorRectCheckArr[i].data.index + 1).toString();
				answerData[key] = {colorRectCheckItem: this.colorRectCheckArr[i], isFinish: true}; 
			}
		}


		// for (let i=0; i<this.colorRectCheckArr.length; i++) {

		// 	const colorPoints = this.colorRectCheckArr[i].colorPoints;

		// 	if (colorPoints.length == 0) {
		// 		continue;
		// 	}
		// 	console.log('colorPoints: ', colorPoints);

		// 	let r = 0;
		// 	let g = 0;
		// 	let b = 0;

		// 	for (let j=0; j<colorPoints.length; j++) {
		// 		const {color} = colorPoints[j];
		// 		r += color[0];
		// 		g += color[1];
		// 		b += color[2];
		// 	}

		// 	r /= colorPoints.length;
		// 	g /= colorPoints.length;
		// 	b /= colorPoints.length;
			
		// 	r = Math.round(r);
		// 	g = Math.round(g);
		// 	b = Math.round(b);

		// 	console.log('r~:', r);
		// 	console.log('g~:', g);
		// 	console.log('b~:', b);

		// 	const key = this.colorRectCheckArr[i].data.index + 1;

		// 	if (!(r > 220 && g > 220 && b > 220)) {
		// 		answerData[key] = {r, g, b, isFinish:true};
		// 	}
		// }
		

		console.log('answerData: ', answerData);

		this.showColorAnswer(answerData);

	},


	showColorAnim(oneAnswer) {
		
		console.log(" in showColorAnim 1");

		const colorRectCheckItem = oneAnswer.colorRectCheckItem;
		if (colorRectCheckItem.isShowEnd) {
			return;
		}

		colorRectCheckItem.hitCount++;
		if (colorRectCheckItem.hitCount < 3) {

			console.log("colorRectCheckItem.hitCount: " + colorRectCheckItem.hitCount);

			return;
		}

		colorRectCheckItem.isShowEnd = true;
		console.log(" in showColorAnim 2");


		const animaNodeBase = this.colorPicNodeArr[0];

		console.log('animaNodeBase: ' , animaNodeBase);

		const animaNode = cc.instantiate(animaNodeBase);

		console.log('animaNode: ' , animaNode);

		const {leftEdgeX, rightEdgeX, topEdgeY, bottomEdgeY} = colorRectCheckItem;
		const animX = -this.colorBg.width / 2 + (leftEdgeX + (rightEdgeX - leftEdgeX) / 2) * this.colorBg.width;
		const animY = this.colorBg.height / 2 - (topEdgeY + (bottomEdgeY - topEdgeY) / 2) * this.colorBg.height;


		animaNode.x = animX //colorRectCheckItem.x + colorRectCheckItem.width / 2 * colorRectCheckItem.scaleX;
		animaNode.y = animY //colorRectCheckItem.y + colorRectCheckItem.height / 2 * colorRectCheckItem.scaleY;
		// animaNode.parent = this.colorBg
		this.colorBg.addChild(animaNode, 5);

		animaNode.active = true;
		animaNode.opacity = 255;
		
		const dragonDisplay = animaNode.getComponent(dragonBones.ArmatureDisplay);

		console.log('dragonDisplay: ' , dragonDisplay);
		console.log('animaNode: ' , animaNode);


		delayCall(0.01, () => {
			const animationNames = animaNodeBase.animationNames;
			dragonDisplay.playAnimation(animationNames[0], 0);
		})

		playAudio(this.rightClip, () => {
		
		})

		if (!this.isGameEnd) {
			this.checkGameEnd(this.colorRectCheckArr);
		}

	},


	showColorAnswer(answerData) {
		
		console.log('in showColorAnswer 1');
		if (Object.keys(answerData).length == 0) {
			return;
		}

		console.log('in showColorAnswer 2');



		for (let i=0; i<this.colorRectCheckArr.length; i++) {

			const key = (this.colorRectCheckArr[i].data.index + 1).toString();

			if (!this.colorRectCheckArr[i].hitCount) {
				this.colorRectCheckArr[i].hitCount = 0;
			}

			console.log('hitCount i: ' + i);

			if (answerData[key]) {
				this.showColorAnim(answerData[key]);
			} else {
				console.log('i: ' + i + " hitCount = 0");
				this.colorRectCheckArr[i].hitCount = 0;
			}
		}



		// for (key in answerData) {

		// 	console.log('in showColorAnswer 3: ' + key);
		// 	this.showColorAnim(answerData[key]);

		// }

		// for (let i = 0; i < this.colorPicNodeArr.length; i++) {

		// 	const picNode = this.colorPicNodeArr[i];

		// 	const key = picNode.data.drawItem // i.toString();


		// 	console.log('~picNode.data: ', picNode.data)
		// 	console.log('~key: ', key)

		// 	if (!picNode.hitCount) {
		// 		picNode.hitCount = 0;
		// 	}

		// 	if (answerData[key] && answerData[key].isFinish) {
		// 		console.log('~show Color')
		// 		this.showColorPic(picNode, answerData[key]);

		// 	} else {

		// 		picNode.hitCount = 0;
		// 	}
		// }

	},


	photoEndSignRect(data) {

		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const symbol = textArr[0]?.symbol
		if (!symbol) {
			return;
		}

		// return 
		const answerData = {};


		for (let i=0; i<this.signRectCheckArr.length; i++) {
			
			const signDebugItem = this.signRectCheckArr[i];
			const dropDownItem = signDebugItem.data.dropDownItem;

			const curSignKey = symbol[i].toString();
			
			if (dropDownItem.key == curSignKey) {


				const label = this.getLabel(dropDownItem.label, signDebugItem.ccRect.width);
				label.x = signDebugItem.x;
				label.y = signDebugItem.y;
				label.color = cc.Color.BLACK;
	
				this.debugDrawLayer.addChild(label, 2);


				const key = signDebugItem.data.index + 1;
				answerData[key] = {isFinish: true};

			}
		}

		this.showSignAnswer(answerData);

		return ;

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];

			const signId = '2'

			// const points = oneTextData.points;

			// const tempDisNum = Math.floor(points.length / 2);
			// const point1_x = points[0];
			// const point1_y = points[1];
			// const point2_x = points[tempDisNum];
			// const point2_y = points[tempDisNum + 1];

			// let centerPX = Number(point1_x) + (point2_x - point1_x) / 2;
			// let centerPY = Number(point1_y) + (point2_y - point1_y) / 2;

			// console.log('centerPX: ' ,centerPX);
			// console.log('centerPY: ' ,centerPY);

			// const colorRect = this.getColorDot(centerPX, -centerPY, 0.02, 0.02, "purple");
			// this.debugDrawLayer.addChild(colorRect, 1);


			// this.setOneAnswerDataCircle(colorRect, answerData);

		}

		console.log('answerData: ' , answerData);


		// this.showCircleAnswer(answerData);

	},

	showSignAnswer(answerData) {

		console.log('answerData: ', answerData);
		if (Object.keys(answerData).length == 0) {
			return;
		}

		console.log("signAnimaNodeArr: ", this.signAnimaNodeArr);

		for (let i = 0; i < this.signAnimaNodeArr.length; i++) {

			const animaNode = this.signAnimaNodeArr[i];

			const key = animaNode.data.signItem // i.toString();


			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showSign')
				this.showSign(animaNode);

			} else {

				animaNode.hitCount = 0;
			}
		}

	},

	showSign(node, isRight = true) {

		console.log('in showCircle 1');


		node.hitCount++;
		if (node.hitCount < 1) {
			return;
		}


		console.log('in showCircle 2');


		if (node.isShowEnd) {
			return;
		}

		if (this.itemCombineGroup && this.itemCombineGroup.length > 0) {
			const gourpIsShowEnd = this.checkOneCombineGroupEnd(node);
			if (gourpIsShowEnd) {
				return;
			}
		}


		console.log('in showCircle 3');

		node.isShowEnd = true;
		node.isRight = isRight;


		// node.playRightAnim();
		this.playRightAnim(node);

		if (!this.isGameEnd) {

			if (this.itemCombineGroup && this.itemCombineGroup.length > 0) {
				this.checkGameEndCombineGroup();
			} else {
				this.checkGameEnd(this.signAnimaNodeArr);
			}
		}

		return;

	},

	photoEndCircleRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const points = oneTextData.points;

			const tempDisNum = Math.floor(points.length / 2);
			const point1_x = points[0];
			const point1_y = points[1];
			const point2_x = points[tempDisNum];
			const point2_y = points[tempDisNum + 1];
			// const point3_x = points[tempDisNum*2];
			// const point3_y = points[tempDisNum*2 + 1];

			// let centerP = this.locate(point1_x, point1_y, point2_x, point2_y, point3_x, point3_y);
			let centerPX = Number(point1_x) + (point2_x - point1_x) / 2;
			let centerPY = Number(point1_y) + (point2_y - point1_y) / 2;

			console.log('centerPX: ' ,centerPX);
			console.log('centerPY: ' ,centerPY);


			const colorRect = this.getColorDot(centerPX, -centerPY, 0.02, 0.02, "purple");
			this.debugDrawLayer.addChild(colorRect, 1);


			this.setOneAnswerDataCircle(colorRect, answerData);
		}

		console.log('answerData: ' , answerData);


		this.showCircleAnswer(answerData);

		// this.showUserRightNew(answerData);
	},

	showCircleAnswer(answerData) {

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.circleAnimaNodeArr.length; i++) {

			const animaNode = this.circleAnimaNodeArr[i];

			const key = animaNode.data.circleItem // i.toString();

			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showLetter')
				this.showCircle(animaNode);
				// this.showCircle2(animaNode);

			} else {

				animaNode.hitCount = 0;
			}
		}

	},

	showCircle(node, isRight = true) {

		console.log('in showCircle 1');


		node.hitCount++;
		if (node.hitCount < 1) {
			return;
		}


		console.log('in showCircle 2');


		if (node.isShowEnd) {
			return;
		}

		console.log('in showCircle 3');

		node.isShowEnd = true;
		node.isRight = isRight;



		// this.playRightAnim(node);

		
		this.showCircle2(node);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.circleAnimaNodeArr);
		}

		return;

	},
	

	photoEndNewRect(data) {

		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const x = oneTextData.left//oneTextData.left + (oneTextData.right - oneTextData.left) / 2;
			const y = -oneTextData.bottom//-oneTextData.top - (oneTextData.bottom - oneTextData.top) / 2;
			const w = oneTextData.right - oneTextData.left;
			const h = oneTextData.bottom - oneTextData.top;

			const rect = {
				x, y,
				width: w,
				height: h
			}

			console.log('oneTextData: ', oneTextData);

			const content = oneTextData.content;
			const colorRect = this.getColorRect(rect, "red");
			colorRect.labelText = content;
			this.debugDrawLayer.addChild(colorRect, 1);

			const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
			label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
			label.color = cc.Color.BLACK;

			this.debugDrawLayer.addChild(label, 2);

			this.setOneAnswerDataNew(colorRect, answerData);

		}

		console.log('answerData:' , answerData);
		this.showUserRightNew(answerData);
	},

	showUserRightNew(answerData) {

		if (Object.keys(answerData).length == 0) {
			return;
		}

		let arr = this.animaNodeArr;
		if (this.picAnimNodeArr.length > 0) {
			arr = this.picAnimNodeArr;
		}

		for (let i = 0; i < arr.length; i++) {

			const animaNode = arr[i];

			const key = animaNode.data.rectNew // i.toString();

			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showLetter')

				if (this.picAnimNodeArr.length > 0) {
					this.showLetterPic(animaNode);
				} else {
					this.showLetter(animaNode);
				}
			} else {

				animaNode.hitCount = 0;
			}
		}
	},

	photoEnd(data) {
		
		console.log(' this.photo end ', data);


		// if (this.newRectArr && this.newRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_WRITE) {
			this.photoEndNewRect(data);
			return;
		}


		// if (this.circleRectArr && this.circleRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_CIRCLE) {
			this.photoEndCircleRect(data);
			return;
		}

		// if (this.lineRectArr && this.lineRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_LINE) {
			this.photoEndLineRect(data);
			return;
		}

		// if (this.signRectArr && this.signRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_SIGN) {
			this.photoEndSignRect(data);
			return;
		}

		if (this.curCheckGroup == this.CHECK_TYPE_COLOR) {
			this.photoEndColorRect(data);
			return;
		}

		


		// this.changeBboxPos(data);

		const isRightArea = this.checkIsRightArea(data);
		if (!isRightArea) {
			console.log('没有检测到区域')
			return;
		}



		if (this.isCanDraw) {
			return;
		}
		this.isCanDraw = true;


		delayCall(0.01, () => {
			this.isCanDraw = false;
		})



		this.debugDrawLayer.removeAllChildren();

		// const benchmark1Text = this.benchmark1Data.labelText
		// const benchmark1TextArr = benchmark1Text.split(' ');
		// const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, data?.result?.text);

		// const benchmark2Text = this.benchmark2Data.labelText
		// const benchmark2TextArr = benchmark2Text.split(' ');
		// const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr,  data?.result?.text);




		const answerData = this.getAnswerData(data);

		this.showUserRight(answerData, data);

		return;


		const answerWrongData = this.getAnswerWrongData(data);
		let isShowWrong = false;
		if (this.oldAnswerWrongData) {
		
			for (let key in answerWrongData) {
				const wrongData = answerWrongData[key];
				const oldWrongData = this.oldAnswerWrongData[key];
				if (oldWrongData && oldWrongData.sentence == wrongData.sentence) {
					wrongData.count += oldWrongData.count;

					if (wrongData.count >= 3) {
						isShowWrong = true;
					}
				}
			}
		}

		if (isShowWrong) {
			this.showUserWrong(answerWrongData);
		}

		this.oldAnswerWrongData = answerWrongData;


		console.log('answerWrongData: ', JSON.stringify( answerWrongData) );
	},







	checkIsRightArea(data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}

		const benchmark1Text = this.benchmark1Data.labelText
		const benchmark1TextArr = benchmark1Text.split(' ');
		console.log('benchmark1TextArr: ', benchmark1TextArr);
		// const letter = this.data.letter || 'Aa';

		const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, text, false);
		if (!benchmark1LabelData) {
			console.log('!benchmark1LabelData')
			return false;
		}
		this.benchmark1LabelData = benchmark1LabelData;
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		

		if ( this.firstItemData ) {

			const firstText = this.firstItemData.labelText
			const firstTextArr = firstText.split(' ');

			const firstItemLabelData = this.getTopLeftLetter2(firstText, text, this.benchmark1LabelData);

			if (!firstItemLabelData) {
				return false;
			}
			this.firstItemLabelData = firstItemLabelData;

			console.log('firstItemLabelData: ', firstItemLabelData);
			return true

		} else if (this.benchmark2Data) {
		
			const benchmark2Text = this.benchmark2Data.labelText
			const benchmark2TextArr = benchmark2Text.split(' ');
			const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr, text, false);
			if (!benchmark2LabelData) {
				return false;
			}
			this.benchmark2LabelData = benchmark2LabelData;
			return true;
		}



		return false;

	


		// const block = data?.block
		// if (!block) {
		// 	return false;
		// }

		// const topText = this.topItemData.labelText
		// const topTextArr = topText.split(' ');
		// console.log('topTextArr: ', topTextArr);
		// // const letter = this.data.letter || 'Aa';

		// const topLabelData = this.getPhotoLabelData(topTextArr, block);
		// if (!topLabelData) {
		// 	console.log('!topLabelData')
		// 	return false;
		// }
		// this.topLabelData = topLabelData;
		// console.log('topLabelData: ', topLabelData);

		

		// if (this.bottomItemData) {
			
		// 	const bottomText = this.bottomItemData.labelText
		// 	const bottomTextArr = bottomText.split(' ');
		// 	const bottomLabelData = this.getPhotoLabelData(bottomTextArr, block);
		// 	if (!bottomLabelData) {
		// 		return false;
		// 	}
		// 	this.bottomLabelData = bottomLabelData;
		// 	return true

		// } else if (this.firstItemData) {

		// 	const firstText = this.firstItemData.labelText
		// 	const firstTextArr = firstText.split(' ');
		// 	const topLeftLetter = this.getPhotoLabelData(firstTextArr, block);


		// 	// const topLeftLetter = this.getTopLeftLetter(this.firstItemData.labelText, block, topLabelData);
		// 	if (!topLeftLetter) {
		// 		return false;
		// 	}
		// 	this.topLeftLetter = topLeftLetter;

		// 	console.log('topLeftLetter: ', topLeftLetter);
		// 	return true;
		// }



		// return false;

	
	},

	changeBboxPos(data) {

		const text = data?.result?.text;
		if (!text) {
			return;
		}


		for (let i=0; i<text.length; i++) {

			let {left, top, right, bottom} = text[i];

			const q_left = this.ques_region[0];
			const q_top = this.ques_region[1];
			const q_right = this.ques_region[2];
			const q_bottom = this.ques_region[7];

			const rect = {x: q_left, y: q_top, width: q_right - q_left, height: q_bottom - q_top};

			text[i].left = q_left + left * rect.width;
			text[i].top = q_top + top * rect.height;
			text[i].right = q_left + right * rect.width;
			text[i].bottom = q_top + bottom * rect.height;

		}

		// console.log('bbox: ', bbox);
		// const x1 = bbox[0].x1;
		// const y1 = bbox[0].y1;
		// const x2 = bbox[1].x2;
		// const y2 = bbox[1].y2;
		// const x3 = bbox[2].x3;
		// const y3 = bbox[2].y3;
		// const x4 = bbox[3].x4;
		// const y4 = bbox[3].y4;

		// const left = this.ques_region[0];
		// const top = this.ques_region[1];
		// const right = this.ques_region[2];
		// const bottom = this.ques_region[7];

		// const rect = {x: left, y:top, width: right - left, height: bottom - top};

		// const y1_new = top + y1 * rect.height;
		// const y2_new = y1_new;
		// const y3_new = top + y3 * rect.height;
		// const y4_new = y3_new;

		// const x1_new = left + x1 * rect.width;
		// const x2_new = left + x2 * rect.width;
		// const x3_new = x2_new;
		// const x4_new = x1_new;

		// bbox[0].x1 = x1_new;
		// bbox[0].y1 = y1_new;
		// bbox[1].x2 = x2_new;
		// bbox[1].y2 = y2_new;
		// bbox[2].x3 = x3_new;
		// bbox[2].y3 = y3_new;
		// bbox[3].x4 = x4_new;
		// bbox[3].y4 = y4_new;

		// console.log('~~rect: ', rect);

	
	},



	getTopLeftLetter2(text, block, topLabelData) {

		const benchmark1Rect = this.benchmark1Data.rect;

		const rect = {
			x: topLabelData.left, 
			y: -topLabelData.bottom, 
			width: Math.abs( topLabelData.right - topLabelData.left ), 
			height: Math.abs( topLabelData.bottom - topLabelData.top ), 
		}                        
		const colorRect = this.getColorRect(rect, "green");
		this.debugDrawLayer.addChild(colorRect);
		


		const tempUnitW = benchmark1Rect.x + benchmark1Rect.width;
		const tempUnitH = benchmark1Rect.y + benchmark1Rect.height;
		const tempBaseX = benchmark1Rect.x + benchmark1Rect.width / 2;
		const tempBaseY = benchmark1Rect.y + benchmark1Rect.height / 2;


		const firstItemData = this.firstItemData;		
		const firstItemRect = this.firstItemData.rect;

	
		const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		const unitX = (firstItemX - tempBaseX) / tempUnitW;
		const unitY = (firstItemY - tempBaseY) / tempUnitH;
		const unitW2 = firstItemRect.width / tempUnitW;
		const unitH2 = firstItemRect.height / tempUnitH;



		console.log('tempUnitW: ', tempUnitW);
		console.log('tempUnitH: ', tempUnitH);
		console.log('tempBaseX: ', tempBaseX);
		console.log('tempBaseY: ', tempBaseY);

		console.log('firstItemY: ', firstItemY);
		console.log('tempBaseY: ', tempBaseY);
		console.log('tempUnitH: ', tempUnitH);

		firstItemData.unitX = unitX;
		firstItemData.unitY = unitY;
		firstItemData.unitW = unitW2;
		firstItemData.unitH = unitH2;



		const topLocationLeft = topLabelData.left;
		const topLocationTop = topLabelData.top;
		const topLocationRight = topLabelData.right;
		const topLocationBottom = topLabelData.bottom;

		const baseX = topLocationLeft + (topLocationRight - topLocationLeft) / 2;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight;
		const unitH = topLocationTop + (topLocationBottom - topLocationTop);
		

		const checkLetter = firstItemData;

		console.log('baseY: ', baseY);
		console.log('checkLetter.unitY: ', checkLetter.unitY);
		console.log('unitH: ', unitH);


		let x = baseX + checkLetter.unitX * unitW;
		const y = baseY + checkLetter.unitY * unitH;
		const w = checkLetter.unitW * unitW;
		const h = checkLetter.unitH * unitH;
		const r = Math.min(w, h) / 2;


		console.log(' baseX:  ', baseX);
		console.log(' checkLetter.unitX:  ', checkLetter.unitX);
		console.log(' unitW:  ', unitW);
		console.log(' x:  ', x);
		console.log(' y:  ', y);
		console.log(' r:  ', r);
		console.log(' checkLetter:  ', checkLetter);

		const dot = this.getColorDot(x, -y, r, r, 'blue');
		this.debugDrawLayer.addChild(dot, 5);

		dot.labelText = checkLetter.labelText;


		const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		let topLeftLetterData;


		const {dotRect, labelText} = dot
		


		for (let i=0; i<wordDataArr.length; i++) {

			// const tempWordArr = wordDataArr[i].word;
			const tempWordArr = this.getTempWordArr(wordDataArr[i],['']);



			for (let k=0; k<tempWordArr.length; k++) {
					
				const {location , content} = tempWordArr[k];

				const rect = {
					x: location.left, 
					y: -location.bottom, 
					width: Math.abs( location.right - location.left ), 
					height: Math.abs( location.bottom - location.top ), 
				}                        
				const colorRect = this.getColorRect(rect, "purple");
				colorRect.labelText = content;
				this.debugDrawLayer.addChild(colorRect);

				// console.log('colorRect: ', colorRect);

				const label = this.getLabel(content);
				label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
				label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
				label.color = cc.Color.GREEN;
				this.debugDrawLayer.addChild(label);




				///------

				const checkRect = colorRect.ccRect;
				const targetLabelText = colorRect.labelText;

				const {dotRect, labelText, key} = dot;

				if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && checkRect.intersects(dotRect)) {
					return tempWordArr[k];
				}

				///------
				

			}





			// const lineRect = this.getLineRect( wordDataArr[i] );
			// const isInLineRect = lineRect.intersects(dotRect)
			// if (!isInLineRect) {
			// 	continue;
			// }

			// for (let k=0; k<tempWordArr.length; k++) {
			// 	const {location , content} = tempWordArr[k];

			// 	const tempRect = {
			// 		x: location.left, 
			// 		y: -location.bottom, 
			// 		width: Math.abs( location.right - location.left ), 
			// 		height: Math.abs( location.bottom - location.top ), 
			// 	}
			// 	const colorRect = this.getColorRect(tempRect);
			// 	colorRect.labelText = content;
			// 	// this.debugDrawLayer.addChild(colorRect);

			// 	const label = this.getLabel(content);
			// 	label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			// 	label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
			// 	label.color = cc.Color.GREEN;
			// 	// this.debugDrawLayer.addChild(label);
				


						
			// 	const rect = colorRect.ccRect;
			// 	const targetLabelText = colorRect.labelText;



			

			// 	// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
			// 	// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


			// 	const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

			// 	if (isInLineText) {
			// 	// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
			// 		topLeftLetterData = wordDataArr[i];
			// 		// answerData[i.toString()] = colorRect;
			// 		// return;
			// 	}

			// }
			
		}

			
		return null;


	},


	getTopLeftLetter(text, block, topLabelData) {

		// const topItemRect = this.topItemData.rect;

		// const tempUnitW = topItemRect.width;
		// const tempUnitH = topItemRect.height;
		// const tempBaseX = topItemRect.x;
		// const tempBaseY = topItemRect.y + topItemRect.height / 2;


		// const firstItemData = this.firstItemData;
		// console.log('firstItemData: ', firstItemData);
		
		// const firstItemRect = this.firstItemData.rect;


	
		// const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		// const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		// const unitX = (firstItemX - tempBaseX) / tempUnitW;
		// const unitY = (firstItemY - tempBaseY) / tempUnitH;
		// const unitW2 = firstItemRect.width / tempUnitW;
		// const unitH2 = firstItemRect.height / tempUnitH;


		// console.log('firstItemY: ', firstItemY);
		// console.log('tempBaseY: ', tempBaseY);
		// console.log('tempUnitH: ', tempUnitH);

		// firstItemData.unitX = unitX;
		// firstItemData.unitY = unitY;
		// firstItemData.unitW = unitW2;
		// firstItemData.unitH = unitH2;



		// // const topLabelData = this.topLabelData;

		// const firstTopWordLocation = topLabelData.word[0].location;
		// const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		// const topLocationLeft = firstTopWordLocation.left;
		// const topLocationTop = firstTopWordLocation.top;
		// const topLocationRight = lastTopWordLocation.right;
		// const topLocationBottom = lastTopWordLocation.bottom;

		// const baseX = topLocationLeft;
		// const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		// const unitW = topLocationRight - topLocationLeft;
		// const unitH = topLocationBottom - topLocationTop;
		

		// const checkLetter = firstItemData;

		// console.log('baseY: ', baseY);
		// console.log('checkLetter.unitY: ', checkLetter.unitY);
		// console.log('unitH: ', unitH);


		// let x = baseX + checkLetter.unitX * unitW;
		// const y = baseY + checkLetter.unitY * unitH;
		// const w = checkLetter.unitW * unitW;
		// const h = checkLetter.unitH * unitH;
		// const r = Math.min(w, h) / 2;

		// 	// const centerX = baseX + this.centerUnitW * unitW;
		// 	// x += (centerX - x) * 0.005  * (y * 0.05);

		// console.log(' x:  ', x);
		// console.log(' y:  ', y);
		// console.log(' r:  ', r);

		// const dot = this.getColorDot(x, -y, r, r, 'purple');
		// this.debugDrawLayer.addChild(dot, 5);

		// dot.labelText = checkLetter.labelText;


		// const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// let topLeftLetterData;


		// const {dotRect, labelText} = dot
		


		// for (let i=0; i<wordDataArr.length; i++) {

		// 	const tempWordArr = wordDataArr[i].word;

		// 	const lineRect = this.getLineRect( wordDataArr[i] );
		// 	const isInLineRect = lineRect.intersects(dotRect)
		// 	if (!isInLineRect) {
		// 		continue;
		// 	}

		// 	for (let k=0; k<tempWordArr.length; k++) {
		// 		const {location , content} = tempWordArr[k];

		// 		const tempRect = {
		// 			x: location.left, 
		// 			y: -location.bottom, 
		// 			width: Math.abs( location.right - location.left ), 
		// 			height: Math.abs( location.bottom - location.top ), 
		// 		}
		// 		const colorRect = this.getColorRect(tempRect);
		// 		colorRect.labelText = content;
		// 		// this.debugDrawLayer.addChild(colorRect);

		// 		const label = this.getLabel(content);
		// 		label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
		// 		label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
		// 		label.color = cc.Color.GREEN;
		// 		// this.debugDrawLayer.addChild(label);
				


						
		// 		const rect = colorRect.ccRect;
		// 		const targetLabelText = colorRect.labelText;



			

		// 		// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
		// 		// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


		// 		const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

		// 		if (isInLineText) {
		// 		// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
		// 			topLeftLetterData = wordDataArr[i];
		// 			// answerData[i.toString()] = colorRect;
		// 			// return;
		// 		}

		// 	}
			
		// }

			
		// return topLeftLetterData;









		// // const topRect = this.topItemData.rect;

		// // const topCenterY = (topRect.y + topRect.height / 2);
		// // const bottomCenterY = (bottomRect.y + bottomRect.height / 2);
		
		// // const unitH = bottomCenterY - topCenterY;
		// // const unitW = topRect.width;
		// // const baseX = topRect.x;
		// // const baseY = topRect.y + topRect.height;


		

		// // const titleBottom = this.getTitleBottom();
		// // console.log("titleBottom: ", titleBottom);

		// // let topLeftLetter;
		// // const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// // for (let i=0; i<wordDataArr.length; i++) {

		// // 	const tempWordArr = wordDataArr[i].word;
		// // 	for (let k=0; k<tempWordArr.length; k++) {
		// // 		const {location , content} = tempWordArr[k];


		// // 		// console.log('location: ~~ ', location);

		// // 		// if (location.top <= titleBottom) {
		// // 		// 	continue;
		// // 		// }

		// // 		wordDataArr[i].tmpLen = this.getToZeroLen(location)

					



		// // 		if (!topLeftLetter) {
		// // 			topLeftLetter = wordDataArr[i];
		// // 		} else {
		// // 			if (topLeftLetter.tmpLen > wordDataArr[i].tmpLen) {
		// // 				topLeftLetter = wordDataArr[i];
		// // 			}
		// // 		}
		// // 	}
			
		// // }

		// // return topLeftLetter;


	},

	getLineRect(line) {

		const tempWordArr = line.word;

		let sentenceRect;
		let left;
		let right;
		for (let k=0; k<tempWordArr.length; k++) {
			const {location , content} = tempWordArr[k];

			const tempRect = {
				x: location.left, 
				y: -location.bottom, 
				width: Math.abs( location.right - location.left ), 
				height: Math.abs( location.bottom - location.top ), 
			}
			const colorRect = this.getColorRect(tempRect);
			colorRect.labelText = content;
			// this.debugDrawLayer.addChild(colorRect);

					
			const rect = colorRect.ccRect;
			if (!sentenceRect) {
				sentenceRect = rect;
				left = rect.x;
				right = rect.x + rect.width;
			} else {
				if (rect.x + rect.width > right) {
					right = rect.x + rect.width;
				}
			}



		


		}

		if (sentenceRect) {
			sentenceRect.width = right - left;
		}

		return sentenceRect;



	},

	checkWordIsInLine(line, text) {

		console.log(" in checkWordIsInLine ");
		console.log(" line:  ", line);
		console.log(" word:  ", text);

		const textArr = text.trim().toLowerCase().split('');

		const word = line.word;
		let sentence = ''
		word.forEach(item => {
			sentence += item.content + ' ';
		});

		sentence.trim();
		sentence = sentence.toLowerCase();

		line.sentence = sentence;

		console.log(" sentence:  ", sentence);
		

		if (this.checkIsInsert(textArr, sentence)) {
			return true;
		}

		
		return false;

	},


	getTitleBottom() {
		let maxBottom = 0;
		const word = this.topLabelData.word;
		for (let i=0; i<word.length; i++) {
			if (word[i].location.bottom > maxBottom) {
				maxBottom = word[i].location.bottom;
			}
		}

		return maxBottom;
	},

	getToZeroLen(location) {
		const {top, left} = location;
		const len = Math.sqrt( Math.pow(left, 2) + Math.pow(top, 2) );
		return len;
	},



	getPhotoLabelData(textArr, block, isShow=true) {


		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}

			const sentence = line.content;


			if (isShow) {
				const label = this.getLabel(sentence, 150);
				label.x = line.left * this.debugBgImg.width;
				label.y = -(line.top + (line.bottom - line.top) / 2) * this.debugBgImg.height;
				label.parent = this.debugDrawLayer;
				label.zIndex = 200;
				// label.color = cc.Color.RED;
				const l = label.getComponent(cc.Label);
				label.anchorX = 0;
				console.log(' sentence~:  ', sentence);
			}




			if (this.checkIsInsert(textArr, sentence)) {
				return line;
			}

		}

		return false;

		// for(let j=0; j<block.length; j++) {

		// 	const line = block[j].line;
		// 	if (!line) {
		// 		continue;
		// 	}

		// 	for (let i=0; i<line.length; i++) {

		// 		const word = line[i].word;
		// 		let sentence = ''
		// 		word.forEach(item => {
		// 			sentence += item.content + ' ';
		// 		});
	
		// 		sentence.trim();
		// 		sentence = sentence.toLowerCase();
	
		// 		line[i].sentence = sentence;

		// 		if (this.checkIsInsert(textArr, sentence)) {
		// 			return line[i];
		// 		}
		// 	}
		// }

		// return false;
	},

	checkIsInsert(textArr, sentence) {
		// console.log('textArr: ', textArr);
		// console.log('sentence: ', sentence);

		sentence = sentence.toLowerCase();

		let index = -1;
		for (let i=0; i<textArr.length; i++) {
			index = sentence.indexOf(textArr[i].toLowerCase(), index);
			// console.log('index: ', index);
			if (index == -1) {
				return false;
			}
		}

		return true;
	},


	showUserRight(answerData, data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log('answerData: ', answerData);
		// console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}



		for (let i = 0; i < this.animaNodeArr.length; i++) {

			const animaNode = this.animaNodeArr[i];

			const key = animaNode.data.rectItem // i.toString();

			console.log('key: ', key)

			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				this.showLetter(animaNode);
				// this.removeLine(answerData[key].line, block);
			} else {

				animaNode.hitCount = 0;
			}
		}


		// for (let i = 0; i < this.picNodeArr.length; i++) {

		// 	const picNode = this.picNodeArr[i];

		// 	const key = picNode.data.rectItem // i.toString();

		// 	console.log('key: ', key)

		// 	if (answerData[key] && answerData[key].isFinish) {
		// 		this.showLetter(picNode);
		// 		this.removeLine(answerData[key].line, block);
		// 	} else {

		// 		picNode.hitCount = 0;
		// 	}
		// }


	},

	removeLine(line, block) {

		console.log('block: ', JSON.stringify(block));
		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
	
			const index = lineArr.indexOf(line);
			if (index != -1) {
				lineArr.splice(index, 1);
				console.log(' ```splice lineArr.length: ' , lineArr.length);
			}
		}
	},

	showUserWrong(answerData) {

		console.log('answerData: ', answerData);
		console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.picNodeArr.length; i++) {

			const picNode = this.picNodeArr[i];

			const key = picNode.data.rectItem // i.toString();

			console.log('key: ', key)

			if (answerData[key] && answerData[key].count >= 3) {
				this.showLetter(picNode, false);
			}
		}


	},



	showColorPic(picNode, data, isRight = true) {

		console.log('in showLetterPic 1');

		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}

		console.log('in showLetterPic 2');

		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetterPic 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.opacity = 0;
		picNode.active = true

		const picColor = new cc.Color();
		picColor.r = data.r;
		picColor.g = data.g;
		picColor.b = data.b;
		picNode.sprNode.color = picColor;




		// cc.tween(picNode)
		// 	.to(2, {opacity: 255}, {easing:"cubicOut"})
		// 	.start();

		playAudio(this.rightClip, () => {
		
		})
		
		if (!this.isGameEnd) {
			this.checkGameEnd(this.colorPicNodeArr);
		}

	},

	
	showLetterPic(picNode, isRight = true) {

		console.log('in showLetterPic 1');


		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}


		console.log('in showLetterPic 2');


		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetterPic 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.playRightAnim();
		// this.playRightAnim(picNode);

		picNode.opacity = 0;
		picNode.active = true
		cc.tween(picNode)
			.to(2, {opacity: 255}, {easing:"cubicOut"})
			.start();

		playAudio(this.rightClip, () => {
		
		})
		
		if (!this.isGameEnd) {
			this.checkGameEnd(this.picAnimNodeArr);
		}

	},


	showLetter(picNode, isRight = true) {

		// let writeRect = this.writeNodeArr[Number(index)];

		console.log('in showLetter 1');


		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}


		console.log('in showLetter 2');


		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetter 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.playRightAnim();
		this.playRightAnim(picNode);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.animaNodeArr);
		}

		return;


		picNode.answerPic.active = true;



		if (!isRight) {
			console.log(' ~ !isRight');
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#ef7961')
			playAudio(this.wrongClip);

			if (!this.isGameEnd) {
				this.checkGameEnd();
			}
			return;
		} else {
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#548fd4')
			playAudio(this.rightClip);

		}

		this.showAnimaStar(picNode, ()=> {
			
			if (!this.isGameEnd) {
				this.checkGameEnd();
			}

		});

	
	},

	showAnimaStar(node, cb) {

		const resDragonBone = cc.find("Canvas/res/anim/right")
		const dNode = cc.instantiate(resDragonBone)
		node.addChild(dNode, 20);

		const dragonDisplay = dNode.getComponent(dragonBones.ArmatureDisplay);

		dragonDisplay.playAnimation('newAnimation', 1);

		dragonDisplay.on(dragonBones.EventObject.COMPLETE, ()=> {
			console.log('play end');
			cb && cb();
		})
		

	},


	getAnswerData(data) {
		
		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log(' in getAnswerData: ', text);


		const benchmark1LabelData = this.benchmark1LabelData;
		let benchmark2LabelData ;

		const centerItemArr = this.centerItemArr;

		const benchmark1Left = benchmark1LabelData.left;
		const benchmark1Top = benchmark1LabelData.top;
		const benchmark1Right = benchmark1LabelData.right;
		const benchmark1Bottom = benchmark1LabelData.bottom;

		let baseX;
		let baseY;
		let unitW;
		let unitH;

		if (this.benchmark2LabelData) {
			benchmark2LabelData = this.benchmark2LabelData;


			const benchmark2Left = benchmark2LabelData.left;
			const benchmark2Top = benchmark2LabelData.top;
			const benchmark2Right = benchmark2LabelData.right;
			const benchmark2Bottom = benchmark2LabelData.bottom;


			const bottomLocation = benchmark2LabelData;

			baseX = benchmark1Left;
			baseY =	benchmark1Top + (benchmark1Bottom - benchmark1Top) / 2;
			unitW = benchmark2Right - benchmark1Left;
			unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;


			const benchmark2Rect = {
				x: benchmark2Left, 
				y: -benchmark2Bottom,
				width: Math.abs( benchmark2Left - benchmark2Right ), 
				height: Math.abs( benchmark2Top - benchmark2Bottom ), 
			}
			
			const colorbenchmark2Rect = this.getColorRect(benchmark2Rect, 'green');
			this.debugDrawLayer.addChild(colorbenchmark2Rect);
		} 

	



		if (this.firstItemLabelData) {
			const {location} = this.firstItemLabelData;
			const firstItemLeft = location.left;
			const firstItemRight = location.right;
			const firstItemTop = location.top;
			const firstItemBottom = location.bottom;

			console.log(' location: ', location);
			console.log(' firstItemLeft: ', firstItemLeft);
			console.log(' firstItemRight: ', firstItemRight);
			console.log(' firstItemTop: ', firstItemTop);
			console.log(' firstItemBottom: ', firstItemBottom);

			baseX = firstItemLeft + (firstItemRight - firstItemLeft) / 2;
			baseY =	firstItemTop + (firstItemBottom - firstItemTop) / 2;
			unitW = benchmark1Left + (benchmark1Right -  benchmark1Left) - ( firstItemLeft + (firstItemRight - firstItemLeft) / 2 );
			unitH = ( firstItemTop + (firstItemBottom - firstItemTop) / 2 ) - (benchmark1Top + (benchmark1Bottom -  benchmark1Top) / 2);
		}


		console.log(' baseX ~~~ ', baseX);
		console.log(' baseY ~~~ ', baseY);
		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = 1 //this.data.scaleOffY || 0.055;
		let postionRate = 1 //this.data.positionOffY || 0.4;

		// if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
		// 	postionRate *= 1.7;
    // }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			// const centerX = baseX + this.centerUnitW * unitW;

			// const tempR = scaleRate * (checkLetter.unitY * unitH);
			// const newR = r - tempR; 

			// let newW = w - tempR; 
			// let newH = h - tempR;


			// const rate = newR / r;

			// const tempY = ( y - (baseY) ) * postionRate;
			// y = y - tempY * (1 - rate);


			// const tempX = (centerX - x) * postionRate;
			// x = x + tempX * (1-rate);


			// const newScale = 1.4;
			// const edgeOff = (newScale - 1) / 2;
			// x -= edgeOff * newW;
			// y += edgeOff * newH;
			// newW *= newScale;
			// newH *= newScale;

			// const dot = this.getColorDot(x, -y, newW, newH);

			const dot = this.getColorDot(x, -y, w / 2, h / 2);



			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}



		// console.log('dotArr: ', dotArr);
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		const answerData = {};

		for (let j=0; j<this.centerItemArr.length; j++) {
			const checkLetter = this.centerItemArr[j];

			const wordDataArr = this.getPhotoWordArr(checkLetter.labelText, text, benchmark1LabelData);

			console.log('~~~wordDataArr: ', wordDataArr);


			for (let i=0; i<wordDataArr.length; i++) {

				const tempWordArr = this.getTempWordArr(wordDataArr[i],['']); // wordDataArr[i].word;

				for (let k=0; k<tempWordArr.length; k++) {
					
					const {location , content} = tempWordArr[k];

					const rect = {
						x: location.left, 
						y: -location.bottom, 
						width: Math.abs( location.right - location.left ), 
						height: Math.abs( location.bottom - location.top ), 
					}                        
					const colorRect = this.getColorRect(rect, "purple");
					colorRect.labelText = content;
					this.debugDrawLayer.addChild(colorRect);

					// console.log('colorRect: ', colorRect);

					const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
					label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
					label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
					label.color = cc.Color.BLACK;

					this.debugDrawLayer.addChild(label);
					
	
					this.setOneAnswerData(colorRect, dotArr, answerData, wordDataArr[i]);
	
				}
				
			}

		
		}



		const benchmark1Rect = {
			x: benchmark1Left, 
			y: -benchmark1Bottom,
			width: Math.abs( benchmark1Left - benchmark1Right ), 
			height: Math.abs( benchmark1Top - benchmark1Bottom ), 
		}

		console.log('benchmark1Rect: ', benchmark1Rect);
		
		const colorbenchmark1Rect = this.getColorRect(benchmark1Rect, 'green');
		this.debugDrawLayer.addChild(colorbenchmark1Rect);





		// const rectTop = {
		// 	x: topLocationLeft, 
		// 	y: -topLocationBottom,
		// 	width: Math.abs( topLocationLeft - topLocationRight ), 
		// 	height: Math.abs( topLocationTop - topLocationBottom ), 
		// }
		
		// const colorRectTop = this.getColorRect(rectTop, 'green');
		// this.debugDrawLayer.addChild(colorRectTop);



		// const rectBottom = {
		// 	x: bottomLocation.left, 
		// 	y: -bottomLocation.bottom,
		// 	width: Math.abs( bottomLocation.left - bottomLocation.right ), 
		// 	height: Math.abs( bottomLocation.top - bottomLocation.bottom ), 
		// }
		
		// const colorRectBottom = this.getColorRect(rectBottom, 'green');
		// this.debugDrawLayer.addChild(colorRectBottom);






		return answerData;


	},

	getTempWordArr(line, splitText) {

		const lineBox = {left: line.left, top: line.top, right: line.right, bottom: line.bottom};
		const baseX = lineBox.left;

		let textIndex = 0;
		const oneDisW = (lineBox.right - lineBox.left) / line.content.length;

		const arr = line.content.split(splitText);
		const wordArr = [];
		for (let i=0; i<arr.length; i++) {
			const content = arr[i];
			const location = {}
			location.left = baseX + textIndex * oneDisW;
			location.right = location.left + oneDisW * content.length;
			location.top = lineBox.top;
			location.bottom = lineBox.bottom;
			
			wordArr.push({content, location});

			textIndex += content.length;
		}

		return wordArr;
	},




	getAnswerWrongData(data) {
		
		const block = data?.block
		if (!block) {
			return false;
		}


		console.log(' in getAnswerWrongData: ', block);

		const endKeyObj = {};
		for (let j = 0; j < this.picNodeArr.length; j++) {

			const picNode = this.picNodeArr[j];

			const key = picNode.data.rectItem // i.toString();

			if (picNode.isShowEnd) {
				endKeyObj[key] = true;
			}
		}


		const topLabelData = this.topLabelData;
		let bottomLabelData ;
		if (this.bottomLabelData) {
			bottomLabelData = this.bottomLabelData;
		} else {
			bottomLabelData = this.topLeftLetter;
		}
		// const bottomLabelData = this.bottomLabelData;
		const centerItemArr = this.centerItemArr;

		// console.log('topLabelData: ', topLabelData);

		const firstTopWordLocation = topLabelData.word[0].location;
		const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		const topLocationLeft = firstTopWordLocation.left;
		const topLocationTop = firstTopWordLocation.top;
		const topLocationRight = lastTopWordLocation.right;
		const topLocationBottom = lastTopWordLocation.bottom;


		const bottomLocation = bottomLabelData.word[0].location;

		const baseX = topLocationLeft;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight - topLocationLeft;
		const unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;

		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = this.data.scaleOffY || 0.055;
		let postionRate = this.data.positionOffY || 0.4;

		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			postionRate *= 1.7;
    }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			const key = centerItemArr[i].index + 1;
			if (endKeyObj[key]) {
				continue;
			}

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			const centerX = baseX + this.centerUnitW * unitW;
	
			
		
			// y -= ( y - (baseY + unitH) ) * 0.35;



			const tempR = scaleRate * (checkLetter.unitY * unitH);
			const newR = r - tempR; 

			let newW = w - tempR; 
			let newH = h - tempR;


			const rate = newR / r;

			const tempY = ( y - (baseY) ) * postionRate;
			y = y - tempY * (1 - rate);


			const tempX = (centerX - x) * postionRate;
			x = x + tempX * (1-rate);




			const newScale = 1.4;
			const edgeOff = (newScale - 1) / 2;
			x -= edgeOff * newW;
			y += edgeOff * newH;
			newW *= newScale;
			newH *= newScale;

			const dot = this.getColorDot(x, -y, newW, newH);
			// const dot = this.getColorDot(x, -y, newR, newR);

			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;
			dot.centerPos = cc.v2(dot.x+ dot.width / 2, dot.y + dot.height / 2);

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}


		console.log('topLabelData: ', topLabelData);

		const answerData = {};


		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
			if (!lineArr) {
				continue;
			}

			for (let m=0; m<lineArr.length; m++) {
				const line = lineArr[m];
				
				
				console.log('line: ', JSON.stringify(line));
				const lineRect = this.getLineRect( line );
				console.log('lineRect: ~  ', JSON.stringify(lineRect));
				const lineCenterPos = cc.v2(lineRect.x + lineRect.width / 2, lineRect.y + lineRect.height / 2);

	
				const tempDotArr = [];
				for (let j=0; j<dotArr.length; j++) {
					const isInLineRect = lineRect.intersects(dotArr[j].dotRect)
					if (isInLineRect) {
						tempDotArr.push(dotArr[j]);
					}
				}
				if (tempDotArr.length > 0) {
					const colorRect = this.getColorRect(lineRect, 'purple');
					this.debugDrawLayer.addChild(colorRect);

					console.log('tempDotArr.length > 0')
					let minDistance;
					let curDot;
					for (let j=0; j<tempDotArr.length; j++) {
						const curDistance = cc.Vec2.distance(lineCenterPos, tempDotArr[j].centerPos);
						if (minDistance == null || minDistance > curDistance) {
							minDistance = curDistance;
							curDot = tempDotArr[j];
						}
					}
	
					const tempWordArr = line.word;
					let sentence = ''
					tempWordArr.forEach(item => {
						sentence += item.content.trim();
					});
	
					console.log('sentence: ', sentence);
					console.log('curDot.labelText: ', curDot.labelText);
					if (sentence.length >= curDot.labelText.length) {
						if (!answerData[curDot.key]) {
							answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
						} else {                                        
							const oldData = answerData[curDot.key];
							if (oldData.minDistance > minDistance) {
								answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
							}
						}
					}
				} else {

					const colorRect = this.getColorRect(lineRect, 'red');
					this.debugDrawLayer.addChild(colorRect);
				}
			}

	
		}


		return answerData;


	},


	setCirclePosInRectArr(colorRect) {


		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);

		const circleRectCheckArr = this.circleRectCheckArr;

		for (let i=0; i<circleRectCheckArr.length; i++) {

			const checkRect = circleRectCheckArr[i].ccRect;
			const key = circleRectCheckArr[i].data.index + 1;

			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (checkRect.contains(dotV2)) {
				if (!colorRect.inRectArr) {
					colorRect.inRectArr = []
				}
				colorRect.inRectArr.push(key);
			}

		}
	},



	setOneAnswerDataNew(colorRect, answerData) {
		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);


		const targetLabelText = colorRect.labelText;

		const newRectCheckArr = this.newRectCheckArr;

		for (let i=0; i<newRectCheckArr.length; i++) {

			const labelText = newRectCheckArr[i].data.labelText;
			const checkRect = newRectCheckArr[i].ccRect;
			const key = newRectCheckArr[i].data.index + 1;


			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			// if (labelText == targetLabelText && checkRect.contains(dotV2)) {
			if (checkRect.contains(dotV2)) {
				// const len = targetLabelText.trim().length;

				// console.log('len: ', len);

				// if (newRectCheckArr[i].data.isFuzzy) {

				const index = labelText.indexOf("||");
				if (index != -1) {
					const keyArr = labelText.split("||");

					for (let j=0; j<keyArr.length; j++) {

						if (targetLabelText.indexOf(keyArr[j]) != -1 ) {
							answerData[key] = {isFinish: true};
							break;
						}

					}
				} else {

					if (targetLabelText.indexOf(labelText) != -1 ) {
						answerData[key] = {isFinish: true};
					}
				}


					// if (targetLabelText.indexOf(labelText) != -1 ) {
					// 	answerData[key] = {isFinish: true};
					// }

				// } else {
				// 	if (labelText == targetLabelText) {
				// 		answerData[key] = {isFinish: true};
				// 	}
				// }


			}

		}
	},

	setOneAnswerData(colorRect, dotArr, answerData, line) {

		console.log(' in setOneAnswerData')
		console.log('colorRect: ', colorRect)
		console.log('dotArr: ', dotArr)
		console.log('answerData: ', answerData)

		
		const rect = colorRect.ccRect;
		const targetLabelText = colorRect.labelText;

		for (let i=0; i<dotArr.length; i++) {

			const {dotRect, labelText, key} = dotArr[i];

				console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
				console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );
				console.log('rect.intersects(dotRect) : ', rect.intersects(dotRect) );

			if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
				const len = targetLabelText.trim().length;

				console.log('len: ', len);

				if (!answerData[key]) {
					answerData[key] = {colorRect, count: len};
				} else {
					answerData[key].count += len;

					// console.log('len: ', len);
					// console.log('	answerData[key].count: ', 	answerData[key].count);

				}

				if ( labelText.length <= 1) {
					answerData[key].isFinish = true;
					answerData[key].line = line;

				} else {
					if (answerData[key].count >= labelText.length) {
						answerData[key].isFinish = true;
						answerData[key].line = line;
					}
				}
				

			
				// return;
			}

		}

	},

	getColorRect(rect, color=null) {

		if (!color) {
			color = 'red'
		}


		rect.x *= this.debugBgImg.width;
		rect.y *= this.debugBgImg.height;
		rect.width *= this.debugBgImg.width;
		rect.height *= this.debugBgImg.height;

		const node = getSprNode(color);
		node.anchorX = 0;
		node.anchorY = 0;
		node.x = rect.x;
		node.y = rect.y;
		node.scaleX = rect.width / node.width;
		node.scaleY = rect.height / node.height;

		node.ccRect = new cc.Rect(rect.x, rect.y, rect.width, rect.height);



		return node;
	},



	getColorDot(x, y, w=100, h=100, color='red') {
		const node = new cc.Node();

		if (!h) {
			h = w;
		}

		x *= this.debugBgImg.width;
		y *= this.debugBgImg.height;
		w *= this.debugBgImg.width;
		h *= this.debugBgImg.height;

		if (this.debugLayer.parent && this.debugLayer.active) {

			const rect = {
				x:- w/2,
				y: - h/ 2, 
				width:w, 
				height:h
			}
			// const colorDot = this.getColorRect(rect,'blue');
			// colorDot.fillColor = cc.Color.BLUE;
			// colorDot.fillRect( - r/2, - r/ 2, r, r);

			const colorDot = getSprNode(color);

			
			// colorDot.anchorX = 0;
			// colorDot.anchorY = 0;
			// colorDot.x = rect.x;
			// colorDot.y = rect.y;
			colorDot.scaleX = rect.width / colorDot.width;
			colorDot.scaleY = rect.height / colorDot.height;
			node.addChild(colorDot);



			// const rect1 = new cc.Rect(node.x -r/2, node.y -r/2, r, r);
			// const colorDot = this.getColorRect(rect1, 'green');

			// colorDot.dotRect = rect1;
			// return colorDot;
		}

		node.x = x;
		node.y = y;


		// node.opacity = 0.5;

		const rect = new cc.Rect(node.x -w/2, node.y -h/2, w, h);
		node.dotRect = rect;
		node.ccRect = rect;
		return node;
	},


	getColorBgColorDot(x, y, w=100, h=100) {
		
		// const node = new cc.Node();

		if (!h) {
			h = w;
		}

		x *= this.colorBg.width;
		y *= this.colorBg.height;
		w *= this.colorBg.width;
		h *= this.colorBg.height;

		x = Math.round(x * 100) / 100;
		y = Math.round(y * 100) / 100;
		w = Math.round(w * 100) / 100;
		h = Math.round(h * 100) / 100;

		const rect = {
			x:- w/2,
			y: - h/ 2, 
			width:w, 
			height:h
		}
	
		const colorDot = this.getColorPoolSpr();



		const sx = rect.width / colorDot.width;;
		const sy = rect.height / colorDot.height;
		colorDot.scale = Math.max(sx, sy);
		// colorDot.scaleX = rect.width / colorDot.width;
		// colorDot.scaleY = rect.height / colorDot.height;

		colorDot.x = x;
		colorDot.y = y;

		return colorDot;


		// node.addChild(colorDot);
		// node.colorDot = colorDot;



		
		// node.x = x;
		// node.y = y;

		// return node;
	},
	



	checkHasAnswer(data, text) {

		text = text.toLowerCase();
		text = text.replace(/(^\s+)|(\s+$)/g,"");



		// -----
		let sentence = data.allText.replace('/\n/g', "");

		sentence = sentence.trim();
		sentence = sentence.toLowerCase();
		 


		if (sentence.indexOf(text) != -1) {

			// this.setTestLabel(line[i])

			return true;
		}
		// -----



		const block = data.block;
		for (let j = 0; j < block.length; j++) {

			const line = block[j].line;
			if (!line) {
				continue;
			}


			for (let i = 0; i < line.length; i++) {

				const word = line[i].word;
				const location = line[i].word[0].location;
		
				// console.log(' center line: ', line[i]);


				let sentence = ''
				word.forEach(item => {
					sentence += item.content.trim();
				});

				sentence = sentence.trim();
				sentence = sentence.toLowerCase();

				line[i].sentence = sentence;
				console.log('sentence: ' + sentence + ', text: ' + text);


				if (sentence.indexOf(text) != -1) {


					if (sentence) {
						this.setTestLabel(line[i])
					}

					// line[i].tmpLen = this.getToZeroLen(location)
					// if (!topLeftLetter) {
					// 	topLeftLetter = line[i];
					// } else {
					// 	if (topLeftLetter.tmpLen > line[i].tmpLen) {
					// 		topLeftLetter = line[i];
					// 	}
					// }

					return true;
				}
			}
		}

	},

	


	setTestLabel(labelData) {

		if (!this.debugLayer.parent || !this.debugLayer.active) {
			return;
		}
		// console.log('labelData: ', labelData)
		const location = labelData.word[0].location;
		const label = this.getLabel(labelData.sentence);
		label.anchorX = 0;
		// label.anchorY = 1;
		label.x = location.left;
		label.y = -location.top
		label.zIndex = 50;


		const rect = {};
		rect.width = location.right - location.left;
		rect.height = location.bottom - location.top;
		rect.x = location.left;
		rect.y = -location.top;
		// const colorRect = this.getColorRect(rect, cc.Color.YELLOW);
		// this.debugLayer.addChild(colorRect);

		this.debugLayer.addChild(label);
	},

	getLabel(text, fontSize = 20) {
		const labelNode = new cc.Node();
		const label = labelNode.addComponent(cc.Label);
		label.string = text;
		labelNode.color = cc.Color.BLACK;
		label.fontSize = fontSize;
		label.lineHeight = fontSize;
		return labelNode;
	},



	debugLayer: null,
	initDebugLayer() {


		console.log(' in initDebugLayer');
		const layer = new cc.Node();

		if (this.data.isDebug) {
			layer.parent = cc.find('Canvas');
		}


		layer.width = this.canvas.width / 2;
		layer.height = this.canvas.height / 2;

		layer.zIndex = 100;
		layer.anchorX = 0;
		layer.anchorY = 1;


		if (!this.data.bgItem2) {
			return;
		}


		cc.loader.load({url: this.data.bgItem2.url}, (err, img) => {

			this.debugBgImg = img;
			this.checkBg = img;
			layer.width = img.width;
			layer.height = img.height;

			layer.data = this.data.bgItem2;

			const sprNode = layer;
	
			var sf = new cc.SpriteFrame(img);

			const spr = sprNode.addComponent(cc.Sprite);
			spr.spriteFrame = sf			

			const sx = this.canvas.width / 2 / layer.width;
			const sy = (this.canvas.height) / 2 / layer.height;
			const s = Math.min(sx, sy);
			layer.scale = s;

			this.addNewRect();
			this.addCircleItem();
			this.addSignItem();
			this.addColorItem();

			this.initDebugRect();

			this.checkStart();
	
		});

		layer.x = -this.canvas.width / 2 + 10;
		layer.y = this.canvas.height / 2 - this.canvas.height / 3;
		layer.opacity = 150;

		// layer.scale = 2;
		this.debugLayer = layer;

		// const bgRectNode = new cc.Node();
		// const ctx = bgRectNode.addComponent(cc.Graphics);
		// ctx.fillRect(0, -layer.height, layer.width, layer.height);
		// ctx.fillColor = cc.Color.YELLOW.setA(100);
		// ctx.fill();
		// layer.addChild(bgRectNode);


		const drawLayer = new cc.Node();
    this.debugLayer.addChild(drawLayer, 2);

    this.debugDrawLayer = drawLayer;



	},

	initDebugRect() {

		console.log(' in initDebugRect');

		
		this.linkRectGroup = [];
		this.data.hotZoneItemArr2.forEach((item) => {
			switch (item.gIdx) {
				case "0":
					this.setOneDebugLinkRect(item);
					break;

		
				// case "1":
				// 	this.setOneDebugWriteRect(item);
				// 	break;

				default:
					break;
			}

		});
	

		console.log("this.linkRectGroup: ", this.linkRectGroup);
	},

	setOneMultRect(data) {
		const rate = (this.debugLayer.scale * this.debugLayer.width) / this.data.bgItem2.rect.width;
	
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.debugLayer.addChild(rectNode);

		let ctx = rectNode.addComponent(cc.Graphics);

		ctx.lineWidth = 4;

		const color = new cc.Color();
		cc.Color.fromHEX(color, data.color );

		ctx.strokeColor = color// cc.Color.RED;
		ctx.fillColor = color.setA(100);//cc.Color.WHITE.setA(100);

		const scale = rate / this.debugLayer.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.height * scale - data.rect.y * scale;
	

		rectNode.anchorX = 0;
		rectNode.anchorY = 0;

		if (this.data.isDebug) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();


		rectNode['data'] = data;
		// rectNode.opacity = 100;

		rectNode['ccRect'] = rectNode.getBoundingBoxToWorld()


		// rectNode.isRightPoint = data.checkbox.list[0].value == true;

		// this.linkRectGroup.push(rectNode);

	},

	setOneDebugLinkRect(data) {
		const rate = (this.debugLayer.scale * this.debugLayer.width) / this.data.bgItem2.rect.width;
	
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.debugLayer.addChild(rectNode);

		let ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.debugLayer.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.height * scale - data.rect.y * scale;
	

		rectNode.anchorX = 0;
		rectNode.anchorY = 0;

		if (this.data.isDebug) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();


		rectNode['data'] = data;
		rectNode.opacity = 100;

		rectNode['ccRect'] = rectNode.getBoundingBoxToWorld()


		rectNode.isRightPoint = data.checkbox.list[0].value == true;

		this.linkRectGroup.push(rectNode);

		this.setLinkDataByDebugItem(rectNode, data.index);

	},

	setLinkDataByDebugItem(item, index) {

		let hzItemId;
		let debugItemId;
		let linkHzItemId;
		let linkDebugItemId;


		debugItemId = index + 1;

		const hzItem = this.getHzItemByPoint(debugItemId)

		hzItemId = this.data.hotZoneItemArr.indexOf(hzItem) + 1;

		console.log(' hzItem: ', hzItem);
		console.log(' debugItemId: ', debugItemId);

		linkHzItemId = hzItem.linkItem;

		const linkHzItem = this.data.hotZoneItemArr[linkHzItemId-1]

		linkDebugItemId = linkHzItem.pointItem;


		const linkData = {hzItemId, debugItemId, linkHzItemId, linkDebugItemId};
		item.linkData = linkData;

	},

	getHzItemByPoint(pointId, gIdx = '0') {
		
		const hzItem = this.data.hotZoneItemArr.find((item) => {

			if (item.gIdx == gIdx) {
				return item.pointItem == pointId
			}
		});

		return hzItem;
	},


	addColorItem() {
		console.log('addColorItem 1');
		if (!this.colorRectArr) {
			return;
		}

		console.log('addColorItem 2');

		this.colorRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.colorRectArr.length; i++) {
			const oneData = this.colorRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.colorRectCheckArr.push(rect);
			this.setColorRectPointsMax(rect);

			console.log('oneData: ', oneData);
		}
	},

	setColorRectPointsMax(rect) {

		const data = rect.data;

		const bgRect = this.data.bgItem2.rect;
		const regionRect = data.rect;
		const region = this.getRegionByRect(regionRect, bgRect);

		const regionW = region.right - region.left;
		const regionH = region.bottom - region.top;


		const pointNumX = regionW / this.serverUnitX;
		const pointNumY = regionH / this.serverUnitY;
		const pointsMax = pointNumX * pointNumY;
		
		rect.pointsMax = Math.round( pointsMax );
		console.log('rect.pointsMax : ', rect.pointsMax );
	},

	addSignItem() {
		if (!this.signRectArr) {
			return;
		}

		this.signRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.signRectArr.length; i++) {
			const oneData = this.signRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.signRectCheckArr.push(rect);
			console.log('oneData: ', oneData);
		}
	},

	addCircleItem() {

		if (!this.circleRectArr) {
			return;
		}

		this.circleRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.circleRectArr.length; i++) {
			const oneData = this.circleRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.circleRectCheckArr.push(rect);

			if (oneData.multRect) {
				this.setMultRect(oneData);
			}
			console.log('oneData: ', oneData);
		}
	},

	setMultRect(data) {
		const multRect = data.multRect;
		for(let i=0; i<multRect.length; i++) {
			this.setOneMultRect(multRect[i]);
		}
		console.log("multRect: " , multRect);
	},

	setDebugRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'blue');
		colorRect.opacity = 180;
		colorRect.data = data;

		colorRect.rectNode = rectNode;

		bg.addChild(colorRect, 20);

		return colorRect;
	},

	addNewRect() {
		
		if (!this.newRectArr) {
			return;
		}

		this.newRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.newRectArr.length; i++) {
			const oneData = this.newRectArr[i];
			this.setNewRectDot(oneData, bg);
			console.log('oneData: ', oneData);
		}

	},


	setNewRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'green');
		colorRect.opacity = 180;
		colorRect.data = data;
		bg.addChild(colorRect, 20);

		this.newRectCheckArr.push(colorRect);                                                                                                                                                                                        


		// if (this.data.bgItem.isShowDebugLine || true) {
		// 	ctx.rect(0, 0, rectNode.width, rectNode.height);
		// }
		// ctx.stroke();
		// ctx.fill();

	},
	 


	getPhotoWordArr(text, block, benchmark1Data) {


		const wordArr = [];
		// const maxLen = 10;

		text = text.trim();

		const topY = -benchmark1Data.top;

		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}


			const sentence = line.content;
			if (sentence.indexOf(text) != -1 ) {
				wordArr.push( line );
			}

			// for (let i=0; i<line.length; i++) {


			// 	const location = line[i].word[0].location;

			// 	const curTop = -location.top;
			// 	if (curTop >= topY ) {
			// 		continue;
			// 	}


			// 	let word = line[i].word;
			// 	let sentence = ''

			// 	// if (word.length > maxLen) {
			// 	// 	console.log('continue ', word.length);
			// 	// 	continue;
			// 	// }

			// 	line[i].word = word = this.checkCutWordData(word);
			// 	// console.log('word1~ ', word);


			// 	word.forEach(item => {
			// 		sentence += item.content + '';
			// 	});

			// 	sentence = sentence.trim().toLowerCase();

			// 	text = text.toLowerCase();

			// 	line[i].sentence = sentence;
			// 	console.log('sentence: ', sentence);
			// 	console.log('text: ', text);

			// 	console.log('index: ', sentence.indexOf(text));
			// 	if (sentence.indexOf(text) != -1 ) {
			// 		wordArr.push( line[i] );
			// 	}
			// }
		}

		return wordArr;
	},


	checkCutWordData(wordArr) {


		// console.log('wordArr: ', wordArr);

		let newWordArr = [];
		for(let i=0; i<wordArr.length; i++) {

			let wordObj = wordArr[i];

			wordObj.content = wordObj.content.trim();

			if (wordObj.content.length > 1) {

				const tmpArr = [];
				const w = wordObj.location.right - wordObj.location.left
				const subW = w / wordObj.content.length;
				for (let j=0; j<wordObj.content.length; j++) {

					const subWordObj = {};
					subWordObj.content = wordObj.content[j];
					subWordObj.location = {
						top: wordObj.location.top,
						bottom: wordObj.location.bottom,
						left: wordObj.location.left + subW * j,
						right: wordObj.location.left + subW * (j + 1)
					}

					tmpArr.push(subWordObj);
				}
				newWordArr = newWordArr.concat(tmpArr)


			} else {
				newWordArr.push(wordObj)
			}

		}

		// console.log('newWordArr: ', newWordArr);
		return newWordArr;
	},

	getPhotoData(cb) {

		cb({"result":{"text":[{"points":[0.30666667,0.35824743,0.31,0.35824743,0.31333333,0.35824743,0.31666666,0.35824743,0.32,0.35824743,0.29666665,0.36082473,0.3,0.36082473,0.30333334,0.36082473,0.30666667,0.36082473,0.31,0.36082473,0.31333333,0.36082473,0.31666666,0.36082473,0.32,0.36082473,0.32333332,0.36082473,0.32666665,0.36082473,0.33,0.36082473,0.28666666,0.36340207,0.29,0.36340207,0.29333332,0.36340207,0.29666665,0.36340207,0.3,0.36340207,0.30333334,0.36340207,0.30666667,0.36340207,0.31,0.36340207,0.31333333,0.36340207,0.31666666,0.36340207,0.32,0.36340207,0.32333332,0.36340207,0.32666665,0.36340207,0.33,0.36340207,0.33333334,0.36340207,0.33666667,0.36340207,0.34,0.36340207,0.28333333,0.36597937,0.28666666,0.36597937,0.29,0.36597937,0.29333332,0.36597937,0.33333334,0.36597937,0.33666667,0.36597937,0.34,0.36597937,0.34333333,0.36597937,0.28,0.3685567,0.28333333,0.3685567,0.28666666,0.3685567,0.34,0.3685567,0.34333333,0.3685567,0.34666666,0.3685567,0.27666667,0.371134,0.28,0.371134,0.28333333,0.371134,0.34333333,0.371134,0.34666666,0.371134,0.35,0.371134,0.27333334,0.37371135,0.27666667,0.37371135,0.35,0.37371135,0.35333332,0.37371135,0.27,0.37628865,0.27333334,0.37628865,0.35333332,0.37628865,0.35666665,0.37628865,0.26666668,0.378866,0.27,0.378866,0.35666665,0.378866,0.36,0.378866,0.26666668,0.3814433,0.27,0.3814433,0.35666665,0.3814433,0.36,0.3814433,0.26333332,0.38402063,0.26666668,0.38402063,0.36,0.38402063,0.36333334,0.38402063,0.26333332,0.38659793,0.26666668,0.38659793,0.36,0.38659793,0.36333334,0.38659793,0.26,0.38917527,0.26333332,0.38917527,0.36333334,0.38917527,0.36666667,0.38917527,0.26,0.39175257,0.26333332,0.39175257,0.36333334,0.39175257,0.36666667,0.39175257,0.26,0.3943299,0.26333332,0.3943299,0.36333334,0.3943299,0.36666667,0.3943299,0.26,0.3969072,0.26333332,0.3969072,0.36333334,0.3969072,0.36666667,0.3969072,0.26,0.39948454,0.26333332,0.39948454,0.36333334,0.39948454,0.36666667,0.39948454,0.25666666,0.40206185,0.26,0.40206185,0.26333332,0.40206185,0.36333334,0.40206185,0.36666667,0.40206185,0.37,0.40206185,0.26,0.40463918,0.26333332,0.40463918,0.36333334,0.40463918,0.36666667,0.40463918,0.26,0.4072165,0.26333332,0.4072165,0.36333334,0.4072165,0.36666667,0.4072165,0.26,0.40979382,0.26333332,0.40979382,0.36333334,0.40979382,0.36666667,0.40979382,0.26,0.41237113,0.26333332,0.41237113,0.36333334,0.41237113,0.36666667,0.41237113,0.26,0.41494846,0.26333332,0.41494846,0.36333334,0.41494846,0.36666667,0.41494846,0.26333332,0.41752577,0.26666668,0.41752577,0.36,0.41752577,0.36333334,0.41752577,0.26333332,0.4201031,0.26666668,0.4201031,0.36,0.4201031,0.36333334,0.4201031,0.26666668,0.4226804,0.27,0.4226804,0.35666665,0.4226804,0.36,0.4226804,0.26666668,0.42525774,0.27,0.42525774,0.35666665,0.42525774,0.36,0.42525774,0.27,0.42783505,0.27333334,0.42783505,0.35333332,0.42783505,0.35666665,0.42783505,0.27333334,0.43041238,0.27666667,0.43041238,0.35,0.43041238,0.35333332,0.43041238,0.27666667,0.4329897,0.28,0.4329897,0.28333333,0.4329897,0.34333333,0.4329897,0.34666666,0.4329897,0.35,0.4329897,0.28,0.43556702,0.28333333,0.43556702,0.28666666,0.43556702,0.34,0.43556702,0.34333333,0.43556702,0.34666666,0.43556702,0.28333333,0.43814433,0.28666666,0.43814433,0.29,0.43814433,0.29333332,0.43814433,0.33333334,0.43814433,0.33666667,0.43814433,0.34,0.43814433,0.34333333,0.43814433,0.28666666,0.44072166,0.29,0.44072166,0.29333332,0.44072166,0.29666665,0.44072166,0.3,0.44072166,0.30333334,0.44072166,0.30666667,0.44072166,0.31,0.44072166,0.31333333,0.44072166,0.31666666,0.44072166,0.32,0.44072166,0.32333332,0.44072166,0.32666665,0.44072166,0.33,0.44072166,0.33333334,0.44072166,0.33666667,0.44072166,0.34,0.44072166,0.29666665,0.44329897,0.3,0.44329897,0.30333334,0.44329897,0.30666667,0.44329897,0.31,0.44329897,0.31333333,0.44329897,0.31666666,0.44329897,0.32,0.44329897,0.32333332,0.44329897,0.32666665,0.44329897,0.33,0.44329897,0.30666667,0.4458763,0.31,0.4458763,0.31333333,0.4458763,0.31666666,0.4458763,0.32,0.4458763]}]}});
		return;
	

		const tmpData1 = {"result":{"text":[{"points":[0.07333333,0.37628865,0.07666667,0.37628865,0.08,0.37628865,0.083333336,0.37628865,0.096666664,0.37628865,0.1,0.37628865,0.10333333,0.37628865,0.10666667,0.37628865,0.11,0.37628865,0.11333334,0.37628865,0.07333333,0.378866,0.07666667,0.378866,0.08,0.378866,0.083333336,0.378866,0.086666666,0.378866,0.09,0.378866,0.093333334,0.378866,0.096666664,0.378866,0.1,0.378866,0.10333333,0.378866,0.10666667,0.378866,0.11,0.378866,0.07666667,0.3814433,0.08,0.3814433,0.083333336,0.3814433,0.086666666,0.3814433,0.09,0.3814433,0.093333334,0.3814433,0.096666664,0.3814433,0.1,0.3814433,0.10333333,0.3814433,0.10666667,0.3814433,0.11,0.3814433,0.08,0.38402063,0.083333336,0.38402063,0.086666666,0.38402063,0.09,0.38402063,0.093333334,0.38402063,0.096666664,0.38402063,0.1,0.38402063,0.10333333,0.38402063,0.76,0.38402063,0.7633333,0.38402063,0.76666665,0.38402063,0.77,0.38402063,0.7733333,0.38402063,0.77666664,0.38402063,0.49333334,0.38659793,0.49666667,0.38659793,0.5,0.38659793,0.50333333,0.38659793,0.50666666,0.38659793,0.51,0.38659793,0.5133333,0.38659793,0.75333333,0.38659793,0.75666666,0.38659793,0.76,0.38659793,0.7633333,0.38659793,0.76666665,0.38659793,0.77,0.38659793,0.7733333,0.38659793,0.77666664,0.38659793,0.78,0.38659793,0.78333336,0.38659793,0.7866667,0.38659793,0.49,0.38917527,0.49333334,0.38917527,0.49666667,0.38917527,0.5,0.38917527,0.50333333,0.38917527,0.50666666,0.38917527,0.51,0.38917527,0.5133333,0.38917527,0.75,0.38917527,0.75333333,0.38917527,0.75666666,0.38917527,0.76,0.38917527,0.7633333,0.38917527,0.76666665,0.38917527,0.77,0.38917527,0.7733333,0.38917527,0.77666664,0.38917527,0.78,0.38917527,0.78333336,0.38917527,0.7866667,0.38917527,0.79,0.38917527,0.22,0.39175257,0.22333333,0.39175257,0.22666667,0.39175257,0.23,0.39175257,0.23333333,0.39175257,0.23666666,0.39175257,0.24,0.39175257,0.24333334,0.39175257,0.41666666,0.39175257,0.42,0.39175257,0.42333335,0.39175257,0.42666668,0.39175257,0.48666668,0.39175257,0.49,0.39175257,0.49333334,0.39175257,0.49666667,0.39175257,0.5,0.39175257,0.50333333,0.39175257,0.50666666,0.39175257,0.51,0.39175257,0.5133333,0.39175257,0.51666665,0.39175257,0.75,0.39175257,0.75333333,0.39175257,0.75666666,0.39175257,0.76,0.39175257,0.7633333,0.39175257,0.76666665,0.39175257,0.77,0.39175257,0.7733333,0.39175257,0.77666664,0.39175257,0.78,0.39175257,0.78333336,0.39175257,0.7866667,0.39175257,0.79,0.39175257,0.79333335,0.39175257,0.21333334,0.3943299,0.21666667,0.3943299,0.22,0.3943299,0.22333333,0.3943299,0.22666667,0.3943299,0.23,0.3943299,0.23333333,0.3943299,0.23666666,0.3943299,0.24,0.3943299,0.24333334,0.3943299,0.24666667,0.3943299,0.41333333,0.3943299,0.41666666,0.3943299,0.42,0.3943299,0.42333335,0.3943299,0.42666668,0.3943299,0.43,0.3943299,0.43333334,0.3943299,0.48666668,0.3943299,0.49,0.3943299,0.49333334,0.3943299,0.49666667,0.3943299,0.5,0.3943299,0.50333333,0.3943299,0.50666666,0.3943299,0.51,0.3943299,0.5133333,0.3943299,0.51666665,0.3943299,0.74666667,0.3943299,0.75,0.3943299,0.75333333,0.3943299,0.75666666,0.3943299,0.76,0.3943299,0.7633333,0.3943299,0.76666665,0.3943299,0.77,0.3943299,0.7733333,0.3943299,0.77666664,0.3943299,0.78,0.3943299,0.78333336,0.3943299,0.7866667,0.3943299,0.79,0.3943299,0.79333335,0.3943299,0.7966667,0.3943299,0.21,0.3969072,0.21333334,0.3969072,0.21666667,0.3969072,0.22,0.3969072,0.22333333,0.3969072,0.22666667,0.3969072,0.23,0.3969072,0.23333333,0.3969072,0.23666666,0.3969072,0.24,0.3969072,0.24333334,0.3969072,0.24666667,0.3969072,0.25,0.3969072,0.41666666,0.3969072,0.42,0.3969072,0.42333335,0.3969072,0.42666668,0.3969072,0.43,0.3969072,0.43333334,0.3969072,0.43666667,0.3969072,0.48333332,0.3969072,0.48666668,0.3969072,0.49,0.3969072,0.49333334,0.3969072,0.49666667,0.3969072,0.5,0.3969072,0.50333333,0.3969072,0.50666666,0.3969072,0.51,0.3969072,0.5133333,0.3969072,0.51666665,0.3969072,0.69,0.3969072,0.6933333,0.3969072,0.69666666,0.3969072,0.7,0.3969072,0.7033333,0.3969072,0.70666665,0.3969072,0.71,0.3969072,0.74666667,0.3969072,0.75,0.3969072,0.75333333,0.3969072,0.75666666,0.3969072,0.76,0.3969072,0.7633333,0.3969072,0.76666665,0.3969072,0.77,0.3969072,0.7733333,0.3969072,0.77666664,0.3969072,0.78,0.3969072,0.78333336,0.3969072,0.7866667,0.3969072,0.79,0.3969072,0.79333335,0.3969072,0.7966667,0.3969072,0.20666666,0.39948454,0.21,0.39948454,0.21333334,0.39948454,0.21666667,0.39948454,0.22,0.39948454,0.22333333,0.39948454,0.22666667,0.39948454,0.23,0.39948454,0.23333333,0.39948454,0.23666666,0.39948454,0.24,0.39948454,0.24333334,0.39948454,0.24666667,0.39948454,0.25,0.39948454,0.42,0.39948454,0.42333335,0.39948454,0.42666668,0.39948454,0.43,0.39948454,0.43333334,0.39948454,0.43666667,0.39948454,0.44,0.39948454,0.48333332,0.39948454,0.48666668,0.39948454,0.49,0.39948454,0.49333334,0.39948454,0.49666667,0.39948454,0.5,0.39948454,0.50333333,0.39948454,0.50666666,0.39948454,0.51,0.39948454,0.5133333,0.39948454,0.69,0.39948454,0.6933333,0.39948454,0.69666666,0.39948454,0.7,0.39948454,0.7033333,0.39948454,0.70666665,0.39948454,0.71,0.39948454,0.7133333,0.39948454,0.75,0.39948454,0.75333333,0.39948454,0.75666666,0.39948454,0.76,0.39948454,0.7633333,0.39948454,0.76666665,0.39948454,0.77,0.39948454,0.7733333,0.39948454,0.77666664,0.39948454,0.78,0.39948454,0.78333336,0.39948454,0.7866667,0.39948454,0.79,0.39948454,0.79333335,0.39948454,0.7966667,0.39948454,0.20666666,0.40206185,0.21,0.40206185,0.21333334,0.40206185,0.21666667,0.40206185,0.22,0.40206185,0.22333333,0.40206185,0.22666667,0.40206185,0.23,0.40206185,0.23333333,0.40206185,0.23666666,0.40206185,0.24,0.40206185,0.24333334,0.40206185,0.24666667,0.40206185,0.25,0.40206185,0.42333335,0.40206185,0.42666668,0.40206185,0.43,0.40206185,0.43333334,0.40206185,0.43666667,0.40206185,0.44,0.40206185,0.44333333,0.40206185,0.48333332,0.40206185,0.48666668,0.40206185,0.49,0.40206185,0.49333334,0.40206185,0.49666667,0.40206185,0.5,0.40206185,0.50333333,0.40206185,0.50666666,0.40206185,0.51,0.40206185,0.5133333,0.40206185,0.6933333,0.40206185,0.69666666,0.40206185,0.7,0.40206185,0.7033333,0.40206185,0.70666665,0.40206185,0.71,0.40206185,0.7133333,0.40206185,0.71666664,0.40206185,0.75,0.40206185,0.75333333,0.40206185,0.75666666,0.40206185,0.76,0.40206185,0.7633333,0.40206185,0.76666665,0.40206185,0.77,0.40206185,0.7733333,0.40206185,0.77666664,0.40206185,0.78,0.40206185,0.78333336,0.40206185,0.7866667,0.40206185,0.79,0.40206185,0.79333335,0.40206185,0.7966667,0.40206185,0.14,0.40463918,0.14333333,0.40463918,0.14666666,0.40463918,0.15,0.40463918,0.15333334,0.40463918,0.15666667,0.40463918,0.20333333,0.40463918,0.20666666,0.40463918,0.21,0.40463918,0.21333334,0.40463918,0.21666667,0.40463918,0.22,0.40463918,0.22333333,0.40463918,0.22666667,0.40463918,0.23,0.40463918,0.23333333,0.40463918,0.23666666,0.40463918,0.24,0.40463918,0.24333334,0.40463918,0.24666667,0.40463918,0.42333335,0.40463918,0.42666668,0.40463918,0.43,0.40463918,0.43333334,0.40463918,0.43666667,0.40463918,0.44,0.40463918,0.44333333,0.40463918,0.48333332,0.40463918,0.48666668,0.40463918,0.49,0.40463918,0.49333334,0.40463918,0.49666667,0.40463918,0.5,0.40463918,0.50333333,0.40463918,0.50666666,0.40463918,0.51,0.40463918,0.5133333,0.40463918,0.53333336,0.40463918,0.6766667,0.40463918,0.6933333,0.40463918,0.69666666,0.40463918,0.7,0.40463918,0.7033333,0.40463918,0.70666665,0.40463918,0.71,0.40463918,0.7133333,0.40463918,0.71666664,0.40463918,0.75,0.40463918,0.75333333,0.40463918,0.75666666,0.40463918,0.76,0.40463918,0.7633333,0.40463918,0.76666665,0.40463918,0.77,0.40463918,0.7733333,0.40463918,0.77666664,0.40463918,0.78,0.40463918,0.78333336,0.40463918,0.7866667,0.40463918,0.79,0.40463918,0.79333335,0.40463918,0.86333334,0.40463918,0.8666667,0.40463918,0.87,0.40463918,0.87333333,0.40463918,0.87666667,0.40463918,0.88,0.40463918,0.13666667,0.4072165,0.14,0.4072165,0.14333333,0.4072165,0.14666666,0.4072165,0.15,0.4072165,0.15333334,0.4072165,0.15666667,0.4072165,0.16,0.4072165,0.16333333,0.4072165,0.2,0.4072165,0.20333333,0.4072165,0.20666666,0.4072165,0.21,0.4072165,0.21333334,0.4072165,0.21666667,0.4072165,0.22,0.4072165,0.22333333,0.4072165,0.22666667,0.4072165,0.23,0.4072165,0.23333333,0.4072165,0.23666666,0.4072165,0.24,0.4072165,0.24333334,0.4072165,0.24666667,0.4072165,0.42333335,0.4072165,0.42666668,0.4072165,0.43,0.4072165,0.43333334,0.4072165,0.43666667,0.4072165,0.44,0.4072165,0.44333333,0.4072165,0.44666666,0.4072165,0.48,0.4072165,0.48333332,0.4072165,0.48666668,0.4072165,0.49,0.4072165,0.49333334,0.4072165,0.49666667,0.4072165,0.5,0.4072165,0.50333333,0.4072165,0.50666666,0.4072165,0.51,0.4072165,0.52666664,0.4072165,0.53,0.4072165,0.53333336,0.4072165,0.5366667,0.4072165,0.54,0.4072165,0.6766667,0.4072165,0.6933333,0.4072165,0.69666666,0.4072165,0.7,0.4072165,0.7033333,0.4072165,0.70666665,0.4072165,0.71,0.4072165,0.7133333,0.4072165,0.71666664,0.4072165,0.72,0.4072165,0.75333333,0.4072165,0.75666666,0.4072165,0.76,0.4072165,0.7633333,0.4072165,0.76666665,0.4072165,0.77,0.4072165,0.7733333,0.4072165,0.77666664,0.4072165,0.78,0.4072165,0.78333336,0.4072165,0.7866667,0.4072165,0.79,0.4072165,0.79333335,0.4072165,0.85333335,0.4072165,0.8566667,0.4072165,0.86,0.4072165,0.86333334,0.4072165,0.8666667,0.4072165,0.87,0.4072165,0.87333333,0.4072165,0.87666667,0.4072165,0.88,0.4072165,0.8833333,0.4072165,0.88666666,0.4072165,0.89,0.4072165,0.13666667,0.40979382,0.14,0.40979382,0.14333333,0.40979382,0.14666666,0.40979382,0.15,0.40979382,0.15333334,0.40979382,0.15666667,0.40979382,0.16,0.40979382,0.16333333,0.40979382,0.16666667,0.40979382,0.2,0.40979382,0.20333333,0.40979382,0.20666666,0.40979382,0.21,0.40979382,0.21333334,0.40979382,0.21666667,0.40979382,0.22,0.40979382,0.22333333,0.40979382,0.22666667,0.40979382,0.23,0.40979382,0.23333333,0.40979382,0.23666666,0.40979382,0.24,0.40979382,0.24333334,0.40979382,0.42333335,0.40979382,0.42666668,0.40979382,0.43,0.40979382,0.43333334,0.40979382,0.43666667,0.40979382,0.44,0.40979382,0.44333333,0.40979382,0.44666666,0.40979382,0.45,0.40979382,0.45333335,0.40979382,0.48,0.40979382,0.48333332,0.40979382,0.48666668,0.40979382,0.49,0.40979382,0.49333334,0.40979382,0.49666667,0.40979382,0.5,0.40979382,0.50333333,0.40979382,0.50666666,0.40979382,0.51,0.40979382,0.5233333,0.40979382,0.52666664,0.40979382,0.53,0.40979382,0.53333336,0.40979382,0.5366667,0.40979382,0.54,0.40979382,0.58666664,0.40979382,0.59,0.40979382,0.5933333,0.40979382,0.5966667,0.40979382,0.6,0.40979382,0.60333335,0.40979382,0.6066667,0.40979382,0.6766667,0.40979382,0.6933333,0.40979382,0.69666666,0.40979382,0.7,0.40979382,0.7033333,0.40979382,0.70666665,0.40979382,0.71,0.40979382,0.7133333,0.40979382,0.71666664,0.40979382,0.72,0.40979382,0.75333333,0.40979382,0.75666666,0.40979382,0.76,0.40979382,0.7633333,0.40979382,0.76666665,0.40979382,0.77,0.40979382,0.7733333,0.40979382,0.77666664,0.40979382,0.78,0.40979382,0.78333336,0.40979382,0.7866667,0.40979382,0.79,0.40979382,0.79333335,0.40979382,0.85,0.40979382,0.85333335,0.40979382,0.8566667,0.40979382,0.86,0.40979382,0.86333334,0.40979382,0.8666667,0.40979382,0.87,0.40979382,0.87333333,0.40979382,0.87666667,0.40979382,0.88,0.40979382,0.8833333,0.40979382,0.88666666,0.40979382,0.89,0.40979382,0.8933333,0.40979382,0.89666665,0.40979382,0.14,0.41237113,0.14333333,0.41237113,0.14666666,0.41237113,0.15,0.41237113,0.15333334,0.41237113,0.15666667,0.41237113,0.16,0.41237113,0.16333333,0.41237113,0.16666667,0.41237113,0.17,0.41237113,0.19666667,0.41237113,0.2,0.41237113,0.20333333,0.41237113,0.20666666,0.41237113,0.21,0.41237113,0.21333334,0.41237113,0.21666667,0.41237113,0.22,0.41237113,0.22333333,0.41237113,0.22666667,0.41237113,0.23,0.41237113,0.23333333,0.41237113,0.23666666,0.41237113,0.24,0.41237113,0.24333334,0.41237113,0.29333332,0.41237113,0.29666665,0.41237113,0.3,0.41237113,0.30333334,0.41237113,0.30666667,0.41237113,0.31,0.41237113,0.31333333,0.41237113,0.31666666,0.41237113,0.42333335,0.41237113,0.42666668,0.41237113,0.43,0.41237113,0.43333334,0.41237113,0.43666667,0.41237113,0.44,0.41237113,0.44333333,0.41237113,0.44666666,0.41237113,0.45,0.41237113,0.45333335,0.41237113,0.45666668,0.41237113,0.46,0.41237113,0.47333333,0.41237113,0.47666666,0.41237113,0.48,0.41237113,0.48333332,0.41237113,0.48666668,0.41237113,0.49,0.41237113,0.49333334,0.41237113,0.49666667,0.41237113,0.5,0.41237113,0.50333333,0.41237113,0.50666666,0.41237113,0.51,0.41237113,0.5133333,0.41237113,0.51666665,0.41237113,0.52,0.41237113,0.5233333,0.41237113,0.52666664,0.41237113,0.53,0.41237113,0.53333336,0.41237113,0.5366667,0.41237113,0.54,0.41237113,0.57666665,0.41237113,0.58,0.41237113,0.5833333,0.41237113,0.58666664,0.41237113,0.59,0.41237113,0.5933333,0.41237113,0.5966667,0.41237113,0.6,0.41237113,0.60333335,0.41237113,0.6066667,0.41237113,0.61,0.41237113,0.6766667,0.41237113,0.6933333,0.41237113,0.69666666,0.41237113,0.7,0.41237113,0.7033333,0.41237113,0.70666665,0.41237113,0.71,0.41237113,0.7133333,0.41237113,0.71666664,0.41237113,0.72,0.41237113,0.72333336,0.41237113,0.75666666,0.41237113,0.76,0.41237113,0.7633333,0.41237113,0.76666665,0.41237113,0.77,0.41237113,0.7733333,0.41237113,0.77666664,0.41237113,0.78,0.41237113,0.78333336,0.41237113,0.7866667,0.41237113,0.79,0.41237113,0.79333335,0.41237113,0.8466667,0.41237113,0.85,0.41237113,0.85333335,0.41237113,0.8566667,0.41237113,0.86,0.41237113,0.86333334,0.41237113,0.8666667,0.41237113,0.87,0.41237113,0.87333333,0.41237113,0.87666667,0.41237113,0.88,0.41237113,0.8833333,0.41237113,0.88666666,0.41237113,0.89,0.41237113,0.8933333,0.41237113,0.89666665,0.41237113,0.9,0.41237113,0.14333333,0.41494846,0.14666666,0.41494846,0.15,0.41494846,0.15333334,0.41494846,0.15666667,0.41494846,0.16,0.41494846,0.16333333,0.41494846,0.16666667,0.41494846,0.17,0.41494846,0.17333333,0.41494846,0.17666666,0.41494846,0.19333333,0.41494846,0.19666667,0.41494846,0.2,0.41494846,0.20333333,0.41494846,0.20666666,0.41494846,0.21,0.41494846,0.21333334,0.41494846,0.21666667,0.41494846,0.22,0.41494846,0.22333333,0.41494846,0.22666667,0.41494846,0.23,0.41494846,0.23333333,0.41494846,0.23666666,0.41494846,0.24,0.41494846,0.24333334,0.41494846,0.28333333,0.41494846,0.28666666,0.41494846,0.29,0.41494846,0.29333332,0.41494846,0.29666665,0.41494846,0.3,0.41494846,0.30333334,0.41494846,0.30666667,0.41494846,0.31,0.41494846,0.31333333,0.41494846,0.31666666,0.41494846,0.32,0.41494846,0.42333335,0.41494846,0.42666668,0.41494846,0.43,0.41494846,0.43333334,0.41494846,0.43666667,0.41494846,0.44,0.41494846,0.44333333,0.41494846,0.44666666,0.41494846,0.45,0.41494846,0.45333335,0.41494846,0.45666668,0.41494846,0.46,0.41494846,0.46333334,0.41494846,0.46666667,0.41494846,0.47,0.41494846,0.47333333,0.41494846,0.47666666,0.41494846,0.48,0.41494846,0.48333332,0.41494846,0.48666668,0.41494846,0.49,0.41494846,0.49333334,0.41494846,0.49666667,0.41494846,0.5,0.41494846,0.50333333,0.41494846,0.50666666,0.41494846,0.51,0.41494846,0.5133333,0.41494846,0.51666665,0.41494846,0.52,0.41494846,0.5233333,0.41494846,0.52666664,0.41494846,0.53,0.41494846,0.53333336,0.41494846,0.5366667,0.41494846,0.54,0.41494846,0.57,0.41494846,0.5733333,0.41494846,0.57666665,0.41494846,0.58,0.41494846,0.5833333,0.41494846,0.58666664,0.41494846,0.59,0.41494846,0.5933333,0.41494846,0.5966667,0.41494846,0.6,0.41494846,0.60333335,0.41494846,0.6066667,0.41494846,0.61,0.41494846,0.61333334,0.41494846,0.69,0.41494846,0.6933333,0.41494846,0.69666666,0.41494846,0.7,0.41494846,0.7033333,0.41494846,0.70666665,0.41494846,0.71,0.41494846,0.7133333,0.41494846,0.71666664,0.41494846,0.72,0.41494846,0.72333336,0.41494846,0.7266667,0.41494846,0.75666666,0.41494846,0.76,0.41494846,0.7633333,0.41494846,0.76666665,0.41494846,0.77,0.41494846,0.7733333,0.41494846,0.77666664,0.41494846,0.78,0.41494846,0.78333336,0.41494846,0.7866667,0.41494846,0.79,0.41494846,0.79333335,0.41494846,0.84,0.41494846,0.8433333,0.41494846,0.8466667,0.41494846,0.85,0.41494846,0.85333335,0.41494846,0.8566667,0.41494846,0.86,0.41494846,0.86333334,0.41494846,0.8666667,0.41494846,0.87,0.41494846,0.87333333,0.41494846,0.87666667,0.41494846,0.88,0.41494846,0.8833333,0.41494846,0.88666666,0.41494846,0.89,0.41494846,0.8933333,0.41494846,0.89666665,0.41494846,0.9,0.41494846,0.14333333,0.41752577,0.14666666,0.41752577,0.15,0.41752577,0.15333334,0.41752577,0.15666667,0.41752577,0.16,0.41752577,0.16333333,0.41752577,0.16666667,0.41752577,0.17,0.41752577,0.17333333,0.41752577,0.17666666,0.41752577,0.18,0.41752577,0.18333334,0.41752577,0.18666667,0.41752577,0.19,0.41752577,0.19333333,0.41752577,0.19666667,0.41752577,0.2,0.41752577,0.20333333,0.41752577,0.20666666,0.41752577,0.21,0.41752577,0.21333334,0.41752577,0.21666667,0.41752577,0.22,0.41752577,0.22333333,0.41752577,0.22666667,0.41752577,0.23,0.41752577,0.23333333,0.41752577,0.23666666,0.41752577,0.24,0.41752577,0.28,0.41752577,0.28333333,0.41752577,0.28666666,0.41752577,0.29,0.41752577,0.29333332,0.41752577,0.29666665,0.41752577,0.3,0.41752577,0.30333334,0.41752577,0.30666667,0.41752577,0.31,0.41752577,0.31333333,0.41752577,0.31666666,0.41752577,0.32,0.41752577,0.32333332,0.41752577,0.42,0.41752577,0.42333335,0.41752577,0.42666668,0.41752577,0.43,0.41752577,0.43333334,0.41752577,0.43666667,0.41752577,0.44,0.41752577,0.44333333,0.41752577,0.44666666,0.41752577,0.45,0.41752577,0.45333335,0.41752577,0.45666668,0.41752577,0.46,0.41752577,0.46333334,0.41752577,0.46666667,0.41752577,0.47,0.41752577,0.47333333,0.41752577,0.47666666,0.41752577,0.48,0.41752577,0.48333332,0.41752577,0.48666668,0.41752577,0.49,0.41752577,0.49333334,0.41752577,0.49666667,0.41752577,0.5,0.41752577,0.50333333,0.41752577,0.50666666,0.41752577,0.51,0.41752577,0.5133333,0.41752577,0.51666665,0.41752577,0.52,0.41752577,0.5233333,0.41752577,0.52666664,0.41752577,0.53,0.41752577,0.53333336,0.41752577,0.5366667,0.41752577,0.54,0.41752577,0.56333333,0.41752577,0.56666666,0.41752577,0.57,0.41752577,0.5733333,0.41752577,0.57666665,0.41752577,0.58,0.41752577,0.5833333,0.41752577,0.58666664,0.41752577,0.59,0.41752577,0.5933333,0.41752577,0.5966667,0.41752577,0.6,0.41752577,0.60333335,0.41752577,0.6066667,0.41752577,0.61,0.41752577,0.61333334,0.41752577,0.68666667,0.41752577,0.69,0.41752577,0.6933333,0.41752577,0.69666666,0.41752577,0.7,0.41752577,0.7033333,0.41752577,0.70666665,0.41752577,0.71,0.41752577,0.7133333,0.41752577,0.71666664,0.41752577,0.72,0.41752577,0.72333336,0.41752577,0.7266667,0.41752577,0.73,0.41752577,0.75666666,0.41752577,0.76,0.41752577,0.7633333,0.41752577,0.76666665,0.41752577,0.77,0.41752577,0.7733333,0.41752577,0.77666664,0.41752577,0.78,0.41752577,0.78333336,0.41752577,0.7866667,0.41752577,0.79,0.41752577,0.79333335,0.41752577,0.83666664,0.41752577,0.84,0.41752577,0.8433333,0.41752577,0.8466667,0.41752577,0.85,0.41752577,0.85333335,0.41752577,0.8566667,0.41752577,0.86,0.41752577,0.86333334,0.41752577,0.8666667,0.41752577,0.87,0.41752577,0.87333333,0.41752577,0.87666667,0.41752577,0.88,0.41752577,0.8833333,0.41752577,0.88666666,0.41752577,0.89,0.41752577,0.8933333,0.41752577,0.89666665,0.41752577,0.9,0.41752577,0.14333333,0.4201031,0.14666666,0.4201031,0.15,0.4201031,0.15333334,0.4201031,0.15666667,0.4201031,0.16,0.4201031,0.16333333,0.4201031,0.16666667,0.4201031,0.17,0.4201031,0.17333333,0.4201031,0.17666666,0.4201031,0.18,0.4201031,0.18333334,0.4201031,0.18666667,0.4201031,0.19,0.4201031,0.19333333,0.4201031,0.19666667,0.4201031,0.2,0.4201031,0.20333333,0.4201031,0.20666666,0.4201031,0.21,0.4201031,0.21333334,0.4201031,0.21666667,0.4201031,0.22,0.4201031,0.22333333,0.4201031,0.22666667,0.4201031,0.23,0.4201031,0.23333333,0.4201031,0.23666666,0.4201031,0.24,0.4201031,0.24333334,0.4201031,0.27,0.4201031,0.27333334,0.4201031,0.27666667,0.4201031,0.28,0.4201031,0.28333333,0.4201031,0.28666666,0.4201031,0.29,0.4201031,0.29333332,0.4201031,0.29666665,0.4201031,0.3,0.4201031,0.30333334,0.4201031,0.30666667,0.4201031,0.31,0.4201031,0.31333333,0.4201031,0.31666666,0.4201031,0.32,0.4201031,0.32333332,0.4201031,0.32666665,0.4201031,0.41666666,0.4201031,0.42,0.4201031,0.42333335,0.4201031,0.42666668,0.4201031,0.43,0.4201031,0.43333334,0.4201031,0.43666667,0.4201031,0.44,0.4201031,0.44333333,0.4201031,0.44666666,0.4201031,0.45,0.4201031,0.45333335,0.4201031,0.45666668,0.4201031,0.46,0.4201031,0.46333334,0.4201031,0.46666667,0.4201031,0.47,0.4201031,0.47333333,0.4201031,0.47666666,0.4201031,0.48,0.4201031,0.48333332,0.4201031,0.48666668,0.4201031,0.49,0.4201031,0.49333334,0.4201031,0.49666667,0.4201031,0.5,0.4201031,0.50333333,0.4201031,0.50666666,0.4201031,0.51,0.4201031,0.5133333,0.4201031,0.51666665,0.4201031,0.52,0.4201031,0.5233333,0.4201031,0.52666664,0.4201031,0.53,0.4201031,0.53333336,0.4201031,0.5366667,0.4201031,0.54,0.4201031,0.54333335,0.4201031,0.5466667,0.4201031,0.55,0.4201031,0.55333334,0.4201031,0.5566667,0.4201031,0.56,0.4201031,0.56333333,0.4201031,0.56666666,0.4201031,0.57,0.4201031,0.5733333,0.4201031,0.57666665,0.4201031,0.58,0.4201031,0.5833333,0.4201031,0.58666664,0.4201031,0.59,0.4201031,0.5933333,0.4201031,0.5966667,0.4201031,0.6,0.4201031,0.60333335,0.4201031,0.6066667,0.4201031,0.61,0.4201031,0.61333334,0.4201031,0.68333334,0.4201031,0.68666667,0.4201031,0.69,0.4201031,0.6933333,0.4201031,0.69666666,0.4201031,0.7,0.4201031,0.7033333,0.4201031,0.70666665,0.4201031,0.71,0.4201031,0.7133333,0.4201031,0.71666664,0.4201031,0.72,0.4201031,0.72333336,0.4201031,0.7266667,0.4201031,0.73,0.4201031,0.73333335,0.4201031,0.75,0.4201031,0.75333333,0.4201031,0.75666666,0.4201031,0.76,0.4201031,0.7633333,0.4201031,0.76666665,0.4201031,0.77,0.4201031,0.7733333,0.4201031,0.77666664,0.4201031,0.78,0.4201031,0.78333336,0.4201031,0.7866667,0.4201031,0.79,0.4201031,0.79333335,0.4201031,0.7966667,0.4201031,0.8333333,0.4201031,0.83666664,0.4201031,0.84,0.4201031,0.8433333,0.4201031,0.8466667,0.4201031,0.85,0.4201031,0.85333335,0.4201031,0.8566667,0.4201031,0.86,0.4201031,0.86333334,0.4201031,0.8666667,0.4201031,0.87,0.4201031,0.87333333,0.4201031,0.87666667,0.4201031,0.88,0.4201031,0.8833333,0.4201031,0.88666666,0.4201031,0.89,0.4201031,0.8933333,0.4201031,0.89666665,0.4201031,0.9,0.4201031,0.9033333,0.4201031,0.14333333,0.4226804,0.14666666,0.4226804,0.15,0.4226804,0.15333334,0.4226804,0.15666667,0.4226804,0.16,0.4226804,0.16333333,0.4226804,0.16666667,0.4226804,0.17,0.4226804,0.17333333,0.4226804,0.17666666,0.4226804,0.18,0.4226804,0.18333334,0.4226804,0.18666667,0.4226804,0.19,0.4226804,0.19333333,0.4226804,0.19666667,0.4226804,0.2,0.4226804,0.20333333,0.4226804,0.20666666,0.4226804,0.21,0.4226804,0.21333334,0.4226804,0.21666667,0.4226804,0.22,0.4226804,0.22333333,0.4226804,0.22666667,0.4226804,0.23,0.4226804,0.23333333,0.4226804,0.23666666,0.4226804,0.24,0.4226804,0.24333334,0.4226804,0.24666667,0.4226804,0.26,0.4226804,0.26333332,0.4226804,0.26666668,0.4226804,0.27,0.4226804,0.27333334,0.4226804,0.27666667,0.4226804,0.28,0.4226804,0.28333333,0.4226804,0.28666666,0.4226804,0.29,0.4226804,0.29333332,0.4226804,0.29666665,0.4226804,0.3,0.4226804,0.30333334,0.4226804,0.30666667,0.4226804,0.31,0.4226804,0.31333333,0.4226804,0.31666666,0.4226804,0.32,0.4226804,0.32333332,0.4226804,0.32666665,0.4226804,0.33,0.4226804,0.41333333,0.4226804,0.41666666,0.4226804,0.42,0.4226804,0.42333335,0.4226804,0.42666668,0.4226804,0.43,0.4226804,0.43333334,0.4226804,0.43666667,0.4226804,0.44,0.4226804,0.44333333,0.4226804,0.44666666,0.4226804,0.45,0.4226804,0.45333335,0.4226804,0.45666668,0.4226804,0.46,0.4226804,0.46333334,0.4226804,0.46666667,0.4226804,0.47,0.4226804,0.47333333,0.4226804,0.47666666,0.4226804,0.48,0.4226804,0.48333332,0.4226804,0.48666668,0.4226804,0.49,0.4226804,0.49333334,0.4226804,0.49666667,0.4226804,0.5,0.4226804,0.50333333,0.4226804,0.50666666,0.4226804,0.51,0.4226804,0.5133333,0.4226804,0.51666665,0.4226804,0.52,0.4226804,0.5233333,0.4226804,0.52666664,0.4226804,0.53,0.4226804,0.53333336,0.4226804,0.5366667,0.4226804,0.54,0.4226804,0.54333335,0.4226804,0.5466667,0.4226804,0.55,0.4226804,0.55333334,0.4226804,0.5566667,0.4226804,0.56,0.4226804,0.56333333,0.4226804,0.56666666,0.4226804,0.57,0.4226804,0.5733333,0.4226804,0.57666665,0.4226804,0.58,0.4226804,0.5833333,0.4226804,0.58666664,0.4226804,0.59,0.4226804,0.5933333,0.4226804,0.5966667,0.4226804,0.6,0.4226804,0.60333335,0.4226804,0.6066667,0.4226804,0.61,0.4226804,0.61333334,0.4226804,0.68333334,0.4226804,0.68666667,0.4226804,0.69,0.4226804,0.6933333,0.4226804,0.69666666,0.4226804,0.7,0.4226804,0.7033333,0.4226804,0.70666665,0.4226804,0.71,0.4226804,0.7133333,0.4226804,0.71666664,0.4226804,0.72,0.4226804,0.72333336,0.4226804,0.7266667,0.4226804,0.73,0.4226804,0.73333335,0.4226804,0.7366667,0.4226804,0.74,0.4226804,0.74333334,0.4226804,0.74666667,0.4226804,0.75,0.4226804,0.75333333,0.4226804,0.75666666,0.4226804,0.76,0.4226804,0.7633333,0.4226804,0.76666665,0.4226804,0.77,0.4226804,0.7733333,0.4226804,0.77666664,0.4226804,0.78,0.4226804,0.78333336,0.4226804,0.7866667,0.4226804,0.79,0.4226804,0.79333335,0.4226804,0.7966667,0.4226804,0.82666665,0.4226804,0.83,0.4226804,0.8333333,0.4226804,0.83666664,0.4226804,0.84,0.4226804,0.8433333,0.4226804,0.8466667,0.4226804,0.85,0.4226804,0.85333335,0.4226804,0.8566667,0.4226804,0.86,0.4226804,0.86333334,0.4226804,0.8666667,0.4226804,0.87,0.4226804,0.87333333,0.4226804,0.87666667,0.4226804,0.88,0.4226804,0.8833333,0.4226804,0.88666666,0.4226804,0.89,0.4226804,0.8933333,0.4226804,0.89666665,0.4226804,0.9,0.4226804,0.9033333,0.4226804,0.14333333,0.42525774,0.14666666,0.42525774,0.15,0.42525774,0.15333334,0.42525774,0.15666667,0.42525774,0.16,0.42525774,0.16333333,0.42525774,0.16666667,0.42525774,0.17,0.42525774,0.17333333,0.42525774,0.17666666,0.42525774,0.18,0.42525774,0.18333334,0.42525774,0.18666667,0.42525774,0.19,0.42525774,0.19333333,0.42525774,0.19666667,0.42525774,0.2,0.42525774,0.20333333,0.42525774,0.20666666,0.42525774,0.21,0.42525774,0.21333334,0.42525774,0.21666667,0.42525774,0.22,0.42525774,0.22333333,0.42525774,0.22666667,0.42525774,0.23,0.42525774,0.23333333,0.42525774,0.23666666,0.42525774,0.24,0.42525774,0.24333334,0.42525774,0.24666667,0.42525774,0.25,0.42525774,0.25333333,0.42525774,0.25666666,0.42525774,0.26,0.42525774,0.26333332,0.42525774,0.26666668,0.42525774,0.27,0.42525774,0.27333334,0.42525774,0.27666667,0.42525774,0.28,0.42525774,0.28333333,0.42525774,0.28666666,0.42525774,0.29,0.42525774,0.29333332,0.42525774,0.29666665,0.42525774,0.3,0.42525774,0.30333334,0.42525774,0.30666667,0.42525774,0.31,0.42525774,0.31333333,0.42525774,0.31666666,0.42525774,0.32,0.42525774,0.32333332,0.42525774,0.32666665,0.42525774,0.33,0.42525774,0.41333333,0.42525774,0.41666666,0.42525774,0.42,0.42525774,0.42333335,0.42525774,0.42666668,0.42525774,0.43,0.42525774,0.43333334,0.42525774,0.43666667,0.42525774,0.44,0.42525774,0.44333333,0.42525774,0.44666666,0.42525774,0.45,0.42525774,0.45333335,0.42525774,0.45666668,0.42525774,0.46,0.42525774,0.46333334,0.42525774,0.46666667,0.42525774,0.47,0.42525774,0.47333333,0.42525774,0.49333334,0.42525774,0.49666667,0.42525774,0.5,0.42525774,0.50333333,0.42525774,0.50666666,0.42525774,0.51,0.42525774,0.5133333,0.42525774,0.51666665,0.42525774,0.52,0.42525774,0.5233333,0.42525774,0.52666664,0.42525774,0.53,0.42525774,0.53333336,0.42525774,0.5366667,0.42525774,0.54,0.42525774,0.54333335,0.42525774,0.5466667,0.42525774,0.55,0.42525774,0.55333334,0.42525774,0.5566667,0.42525774,0.56,0.42525774,0.56333333,0.42525774,0.56666666,0.42525774,0.57,0.42525774,0.5733333,0.42525774,0.57666665,0.42525774,0.58,0.42525774,0.5833333,0.42525774,0.58666664,0.42525774,0.59,0.42525774,0.5933333,0.42525774,0.5966667,0.42525774,0.6,0.42525774,0.60333335,0.42525774,0.6066667,0.42525774,0.61,0.42525774,0.61333334,0.42525774,0.68,0.42525774,0.68333334,0.42525774,0.68666667,0.42525774,0.69,0.42525774,0.6933333,0.42525774,0.69666666,0.42525774,0.7,0.42525774,0.7033333,0.42525774,0.70666665,0.42525774,0.71,0.42525774,0.7133333,0.42525774,0.71666664,0.42525774,0.72,0.42525774,0.72333336,0.42525774,0.7266667,0.42525774,0.73,0.42525774,0.73333335,0.42525774,0.7366667,0.42525774,0.74,0.42525774,0.74333334,0.42525774,0.74666667,0.42525774,0.75,0.42525774,0.75333333,0.42525774,0.75666666,0.42525774,0.76,0.42525774,0.7633333,0.42525774,0.76666665,0.42525774,0.77,0.42525774,0.7733333,0.42525774,0.77666664,0.42525774,0.78,0.42525774,0.78333336,0.42525774,0.7866667,0.42525774,0.79,0.42525774,0.79333335,0.42525774,0.7966667,0.42525774,0.8,0.42525774,0.80333334,0.42525774,0.8233333,0.42525774,0.82666665,0.42525774,0.83,0.42525774,0.8333333,0.42525774,0.83666664,0.42525774,0.84,0.42525774,0.8433333,0.42525774,0.8466667,0.42525774,0.85,0.42525774,0.85333335,0.42525774,0.8566667,0.42525774,0.86,0.42525774,0.86333334,0.42525774,0.8666667,0.42525774,0.87,0.42525774,0.87333333,0.42525774,0.87666667,0.42525774,0.88,0.42525774,0.8833333,0.42525774,0.88666666,0.42525774,0.89,0.42525774,0.8933333,0.42525774,0.89666665,0.42525774,0.9,0.42525774,0.9033333,0.42525774,0.14,0.42783505,0.14333333,0.42783505,0.14666666,0.42783505,0.15,0.42783505,0.15333334,0.42783505,0.15666667,0.42783505,0.16,0.42783505,0.16333333,0.42783505,0.16666667,0.42783505,0.17,0.42783505,0.17333333,0.42783505,0.17666666,0.42783505,0.18,0.42783505,0.18333334,0.42783505,0.18666667,0.42783505,0.19,0.42783505,0.19333333,0.42783505,0.19666667,0.42783505,0.2,0.42783505,0.20333333,0.42783505,0.20666666,0.42783505,0.21,0.42783505,0.21333334,0.42783505,0.21666667,0.42783505,0.22,0.42783505,0.22333333,0.42783505,0.22666667,0.42783505,0.23,0.42783505,0.23333333,0.42783505,0.23666666,0.42783505,0.24,0.42783505,0.24333334,0.42783505,0.24666667,0.42783505,0.25,0.42783505,0.25333333,0.42783505,0.25666666,0.42783505,0.26,0.42783505,0.26333332,0.42783505,0.26666668,0.42783505,0.27,0.42783505,0.27333334,0.42783505,0.27666667,0.42783505,0.28,0.42783505,0.28333333,0.42783505,0.28666666,0.42783505,0.29,0.42783505,0.29333332,0.42783505,0.29666665,0.42783505,0.3,0.42783505,0.30333334,0.42783505,0.30666667,0.42783505,0.31,0.42783505,0.31333333,0.42783505,0.31666666,0.42783505,0.32,0.42783505,0.32333332,0.42783505,0.32666665,0.42783505,0.33,0.42783505,0.41333333,0.42783505,0.41666666,0.42783505,0.42,0.42783505,0.42333335,0.42783505,0.42666668,0.42783505,0.43,0.42783505,0.43333334,0.42783505,0.43666667,0.42783505,0.44,0.42783505,0.44333333,0.42783505,0.44666666,0.42783505,0.45,0.42783505,0.45333335,0.42783505,0.45666668,0.42783505,0.46,0.42783505,0.46333334,0.42783505,0.46666667,0.42783505,0.49666667,0.42783505,0.5,0.42783505,0.50333333,0.42783505,0.50666666,0.42783505,0.51,0.42783505,0.5133333,0.42783505,0.51666665,0.42783505,0.52,0.42783505,0.5233333,0.42783505,0.52666664,0.42783505,0.53,0.42783505,0.53333336,0.42783505,0.5366667,0.42783505,0.54,0.42783505,0.54333335,0.42783505,0.5466667,0.42783505,0.55,0.42783505,0.55333334,0.42783505,0.5566667,0.42783505,0.56,0.42783505,0.56333333,0.42783505,0.56666666,0.42783505,0.57,0.42783505,0.5733333,0.42783505,0.57666665,0.42783505,0.58,0.42783505,0.5833333,0.42783505,0.58666664,0.42783505,0.59,0.42783505,0.5933333,0.42783505,0.5966667,0.42783505,0.6,0.42783505,0.60333335,0.42783505,0.6066667,0.42783505,0.61,0.42783505,0.6333333,0.42783505,0.63666666,0.42783505,0.6766667,0.42783505,0.68,0.42783505,0.68333334,0.42783505,0.68666667,0.42783505,0.69,0.42783505,0.6933333,0.42783505,0.69666666,0.42783505,0.7,0.42783505,0.7033333,0.42783505,0.70666665,0.42783505,0.71,0.42783505,0.7133333,0.42783505,0.71666664,0.42783505,0.72,0.42783505,0.72333336,0.42783505,0.7266667,0.42783505,0.73,0.42783505,0.73333335,0.42783505,0.7366667,0.42783505,0.74,0.42783505,0.74333334,0.42783505,0.74666667,0.42783505,0.75,0.42783505,0.75333333,0.42783505,0.75666666,0.42783505,0.76,0.42783505,0.7633333,0.42783505,0.76666665,0.42783505,0.77,0.42783505,0.7733333,0.42783505,0.77666664,0.42783505,0.78,0.42783505,0.78333336,0.42783505,0.7866667,0.42783505,0.79,0.42783505,0.79333335,0.42783505,0.7966667,0.42783505,0.8,0.42783505,0.80333334,0.42783505,0.8066667,0.42783505,0.81,0.42783505,0.81333333,0.42783505,0.81666666,0.42783505,0.82,0.42783505,0.8233333,0.42783505,0.82666665,0.42783505,0.83,0.42783505,0.8333333,0.42783505,0.83666664,0.42783505,0.84,0.42783505,0.8433333,0.42783505,0.8466667,0.42783505,0.85,0.42783505,0.85333335,0.42783505,0.8566667,0.42783505,0.86,0.42783505,0.86333334,0.42783505,0.8666667,0.42783505,0.87,0.42783505,0.87333333,0.42783505,0.87666667,0.42783505,0.88,0.42783505,0.8833333,0.42783505,0.88666666,0.42783505,0.89,0.42783505,0.8933333,0.42783505,0.89666665,0.42783505,0.9,0.42783505,0.14,0.43041238,0.14333333,0.43041238,0.14666666,0.43041238,0.15,0.43041238,0.15333334,0.43041238,0.15666667,0.43041238,0.16,0.43041238,0.16333333,0.43041238,0.16666667,0.43041238,0.17,0.43041238,0.17333333,0.43041238,0.17666666,0.43041238,0.18,0.43041238,0.18333334,0.43041238,0.18666667,0.43041238,0.19,0.43041238,0.19333333,0.43041238,0.19666667,0.43041238,0.2,0.43041238,0.20333333,0.43041238,0.20666666,0.43041238,0.21,0.43041238,0.21333334,0.43041238,0.21666667,0.43041238,0.22,0.43041238,0.22333333,0.43041238,0.22666667,0.43041238,0.23,0.43041238,0.23333333,0.43041238,0.23666666,0.43041238,0.24,0.43041238,0.24333334,0.43041238,0.24666667,0.43041238,0.25,0.43041238,0.25333333,0.43041238,0.25666666,0.43041238,0.26,0.43041238,0.26333332,0.43041238,0.26666668,0.43041238,0.27,0.43041238,0.27333334,0.43041238,0.27666667,0.43041238,0.28,0.43041238,0.28333333,0.43041238,0.28666666,0.43041238,0.29,0.43041238,0.29333332,0.43041238,0.29666665,0.43041238,0.3,0.43041238,0.30333334,0.43041238,0.30666667,0.43041238,0.31,0.43041238,0.31333333,0.43041238,0.31666666,0.43041238,0.32,0.43041238,0.32333332,0.43041238,0.32666665,0.43041238,0.41333333,0.43041238,0.41666666,0.43041238,0.42,0.43041238,0.42333335,0.43041238,0.42666668,0.43041238,0.43,0.43041238,0.43333334,0.43041238,0.43666667,0.43041238,0.44,0.43041238,0.44333333,0.43041238,0.44666666,0.43041238,0.45,0.43041238,0.45333335,0.43041238,0.45666668,0.43041238,0.46,0.43041238,0.50333333,0.43041238,0.50666666,0.43041238,0.51,0.43041238,0.5133333,0.43041238,0.51666665,0.43041238,0.52,0.43041238,0.5233333,0.43041238,0.52666664,0.43041238,0.53,0.43041238,0.53333336,0.43041238,0.5366667,0.43041238,0.54,0.43041238,0.54333335,0.43041238,0.5466667,0.43041238,0.55,0.43041238,0.55333334,0.43041238,0.5566667,0.43041238,0.56,0.43041238,0.56333333,0.43041238,0.56666666,0.43041238,0.57,0.43041238,0.5733333,0.43041238,0.57666665,0.43041238,0.58,0.43041238,0.5833333,0.43041238,0.58666664,0.43041238,0.59,0.43041238,0.5933333,0.43041238,0.5966667,0.43041238,0.6,0.43041238,0.60333335,0.43041238,0.6066667,0.43041238,0.61,0.43041238,0.63,0.43041238,0.6333333,0.43041238,0.63666666,0.43041238,0.64,0.43041238,0.6433333,0.43041238,0.64666665,0.43041238,0.65,0.43041238,0.6533333,0.43041238,0.6566667,0.43041238,0.67,0.43041238,0.67333335,0.43041238,0.6766667,0.43041238,0.68,0.43041238,0.68333334,0.43041238,0.68666667,0.43041238,0.69,0.43041238,0.6933333,0.43041238,0.69666666,0.43041238,0.7,0.43041238,0.7033333,0.43041238,0.70666665,0.43041238,0.71,0.43041238,0.7133333,0.43041238,0.71666664,0.43041238,0.72,0.43041238,0.72333336,0.43041238,0.7266667,0.43041238,0.73,0.43041238,0.73333335,0.43041238,0.7366667,0.43041238,0.74,0.43041238,0.74333334,0.43041238,0.74666667,0.43041238,0.75,0.43041238,0.75333333,0.43041238,0.79333335,0.43041238,0.7966667,0.43041238,0.8,0.43041238,0.80333334,0.43041238,0.8066667,0.43041238,0.81,0.43041238,0.81333333,0.43041238,0.81666666,0.43041238,0.82,0.43041238,0.8233333,0.43041238,0.82666665,0.43041238,0.83,0.43041238,0.8333333,0.43041238,0.83666664,0.43041238,0.84,0.43041238,0.8433333,0.43041238,0.8466667,0.43041238,0.85,0.43041238,0.85333335,0.43041238,0.8566667,0.43041238,0.86,0.43041238,0.86333334,0.43041238,0.8666667,0.43041238,0.87,0.43041238,0.87333333,0.43041238,0.87666667,0.43041238,0.88,0.43041238,0.8833333,0.43041238,0.88666666,0.43041238,0.89,0.43041238,0.8933333,0.43041238,0.14666666,0.4329897,0.15,0.4329897,0.15333334,0.4329897,0.15666667,0.4329897,0.16,0.4329897,0.16333333,0.4329897,0.16666667,0.4329897,0.17,0.4329897,0.17333333,0.4329897,0.17666666,0.4329897,0.18,0.4329897,0.18333334,0.4329897,0.18666667,0.4329897,0.19,0.4329897,0.19333333,0.4329897,0.22333333,0.4329897,0.22666667,0.4329897,0.23,0.4329897,0.23333333,0.4329897,0.23666666,0.4329897,0.24,0.4329897,0.24333334,0.4329897,0.24666667,0.4329897,0.25,0.4329897,0.25333333,0.4329897,0.25666666,0.4329897,0.26,0.4329897,0.26333332,0.4329897,0.26666668,0.4329897,0.27,0.4329897,0.27333334,0.4329897,0.27666667,0.4329897,0.28,0.4329897,0.28333333,0.4329897,0.28666666,0.4329897,0.29,0.4329897,0.29333332,0.4329897,0.29666665,0.4329897,0.3,0.4329897,0.30333334,0.4329897,0.30666667,0.4329897,0.31,0.4329897,0.31333333,0.4329897,0.31666666,0.4329897,0.32,0.4329897,0.32333332,0.4329897,0.35333332,0.4329897,0.35666665,0.4329897,0.36,0.4329897,0.36333334,0.4329897,0.36666667,0.4329897,0.37,0.4329897,0.41,0.4329897,0.41333333,0.4329897,0.41666666,0.4329897,0.42,0.4329897,0.42333335,0.4329897,0.42666668,0.4329897,0.43,0.4329897,0.43333334,0.4329897,0.43666667,0.4329897,0.44,0.4329897,0.44333333,0.4329897,0.44666666,0.4329897,0.45,0.4329897,0.45333335,0.4329897,0.45666668,0.4329897,0.50666666,0.4329897,0.51,0.4329897,0.5133333,0.4329897,0.51666665,0.4329897,0.52,0.4329897,0.5233333,0.4329897,0.52666664,0.4329897,0.53,0.4329897,0.53333336,0.4329897,0.5366667,0.4329897,0.54,0.4329897,0.54333335,0.4329897,0.5466667,0.4329897,0.55,0.4329897,0.55333334,0.4329897,0.5566667,0.4329897,0.56,0.4329897,0.56333333,0.4329897,0.56666666,0.4329897,0.57,0.4329897,0.5733333,0.4329897,0.57666665,0.4329897,0.58,0.4329897,0.5833333,0.4329897,0.58666664,0.4329897,0.59,0.4329897,0.5933333,0.4329897,0.5966667,0.4329897,0.6,0.4329897,0.62666667,0.4329897,0.63,0.4329897,0.6333333,0.4329897,0.63666666,0.4329897,0.64,0.4329897,0.6433333,0.4329897,0.64666665,0.4329897,0.65,0.4329897,0.6533333,0.4329897,0.6566667,0.4329897,0.66,0.4329897,0.66333336,0.4329897,0.6666667,0.4329897,0.67,0.4329897,0.67333335,0.4329897,0.6766667,0.4329897,0.68,0.4329897,0.68333334,0.4329897,0.68666667,0.4329897,0.69,0.4329897,0.6933333,0.4329897,0.69666666,0.4329897,0.7,0.4329897,0.7033333,0.4329897,0.70666665,0.4329897,0.71,0.4329897,0.7133333,0.4329897,0.71666664,0.4329897,0.72,0.4329897,0.72333336,0.4329897,0.7266667,0.4329897,0.73,0.4329897,0.73333335,0.4329897,0.7366667,0.4329897,0.74,0.4329897,0.74333334,0.4329897,0.8066667,0.4329897,0.81,0.4329897,0.81333333,0.4329897,0.81666666,0.4329897,0.82,0.4329897,0.8233333,0.4329897,0.82666665,0.4329897,0.83,0.4329897,0.8333333,0.4329897,0.83666664,0.4329897,0.84,0.4329897,0.8433333,0.4329897,0.8466667,0.4329897,0.85,0.4329897,0.85333335,0.4329897,0.8566667,0.4329897,0.86,0.4329897,0.86333334,0.4329897,0.8666667,0.4329897,0.87,0.4329897,0.87333333,0.4329897,0.87666667,0.4329897,0.88,0.4329897,0.8833333,0.4329897,0.88666666,0.4329897,0.15,0.43556702,0.15333334,0.43556702,0.15666667,0.43556702,0.16,0.43556702,0.16333333,0.43556702,0.16666667,0.43556702,0.17,0.43556702,0.17333333,0.43556702,0.17666666,0.43556702,0.23,0.43556702,0.23333333,0.43556702,0.23666666,0.43556702,0.24,0.43556702,0.24333334,0.43556702,0.24666667,0.43556702,0.25,0.43556702,0.25333333,0.43556702,0.25666666,0.43556702,0.26,0.43556702,0.26333332,0.43556702,0.26666668,0.43556702,0.27,0.43556702,0.27333334,0.43556702,0.27666667,0.43556702,0.28,0.43556702,0.28333333,0.43556702,0.28666666,0.43556702,0.29,0.43556702,0.29333332,0.43556702,0.29666665,0.43556702,0.3,0.43556702,0.30333334,0.43556702,0.30666667,0.43556702,0.31,0.43556702,0.31333333,0.43556702,0.31666666,0.43556702,0.34666666,0.43556702,0.35,0.43556702,0.35333332,0.43556702,0.35666665,0.43556702,0.36,0.43556702,0.36333334,0.43556702,0.36666667,0.43556702,0.37,0.43556702,0.37333333,0.43556702,0.37666667,0.43556702,0.38,0.43556702,0.38333333,0.43556702,0.38666666,0.43556702,0.39,0.43556702,0.39333335,0.43556702,0.39666668,0.43556702,0.4,0.43556702,0.40333334,0.43556702,0.40666667,0.43556702,0.41,0.43556702,0.41333333,0.43556702,0.41666666,0.43556702,0.42,0.43556702,0.42333335,0.43556702,0.42666668,0.43556702,0.43,0.43556702,0.43333334,0.43556702,0.43666667,0.43556702,0.44,0.43556702,0.44333333,0.43556702,0.44666666,0.43556702,0.45,0.43556702,0.51,0.43556702,0.5133333,0.43556702,0.51666665,0.43556702,0.52,0.43556702,0.5233333,0.43556702,0.52666664,0.43556702,0.53,0.43556702,0.53333336,0.43556702,0.5366667,0.43556702,0.54,0.43556702,0.54333335,0.43556702,0.5466667,0.43556702,0.55,0.43556702,0.55333334,0.43556702,0.5566667,0.43556702,0.56,0.43556702,0.56333333,0.43556702,0.56666666,0.43556702,0.57,0.43556702,0.5733333,0.43556702,0.57666665,0.43556702,0.58,0.43556702,0.5833333,0.43556702,0.62666667,0.43556702,0.63,0.43556702,0.6333333,0.43556702,0.63666666,0.43556702,0.64,0.43556702,0.6433333,0.43556702,0.64666665,0.43556702,0.65,0.43556702,0.6533333,0.43556702,0.6566667,0.43556702,0.66,0.43556702,0.66333336,0.43556702,0.6666667,0.43556702,0.67,0.43556702,0.67333335,0.43556702,0.6766667,0.43556702,0.68,0.43556702,0.68333334,0.43556702,0.68666667,0.43556702,0.69,0.43556702,0.6933333,0.43556702,0.69666666,0.43556702,0.7,0.43556702,0.7033333,0.43556702,0.70666665,0.43556702,0.71,0.43556702,0.7133333,0.43556702,0.71666664,0.43556702,0.72,0.43556702,0.72333336,0.43556702,0.7266667,0.43556702,0.73,0.43556702,0.73333335,0.43556702,0.7366667,0.43556702,0.81666666,0.43556702,0.82,0.43556702,0.8233333,0.43556702,0.82666665,0.43556702,0.83,0.43556702,0.8333333,0.43556702,0.83666664,0.43556702,0.84,0.43556702,0.8433333,0.43556702,0.8466667,0.43556702,0.85,0.43556702,0.85333335,0.43556702,0.8566667,0.43556702,0.86,0.43556702,0.86333334,0.43556702,0.8666667,0.43556702,0.87,0.43556702,0.87333333,0.43556702,0.15,0.43814433,0.15333334,0.43814433,0.15666667,0.43814433,0.16,0.43814433,0.16333333,0.43814433,0.16666667,0.43814433,0.17,0.43814433,0.23,0.43814433,0.23333333,0.43814433,0.23666666,0.43814433,0.24,0.43814433,0.24333334,0.43814433,0.24666667,0.43814433,0.25,0.43814433,0.25333333,0.43814433,0.25666666,0.43814433,0.26,0.43814433,0.26333332,0.43814433,0.26666668,0.43814433,0.27,0.43814433,0.27333334,0.43814433,0.27666667,0.43814433,0.28,0.43814433,0.28333333,0.43814433,0.28666666,0.43814433,0.29,0.43814433,0.29333332,0.43814433,0.29666665,0.43814433,0.3,0.43814433,0.30333334,0.43814433,0.30666667,0.43814433,0.31,0.43814433,0.34333333,0.43814433,0.34666666,0.43814433,0.35,0.43814433,0.35333332,0.43814433,0.35666665,0.43814433,0.36,0.43814433,0.36333334,0.43814433,0.36666667,0.43814433,0.37,0.43814433,0.37333333,0.43814433,0.37666667,0.43814433,0.38,0.43814433,0.38333333,0.43814433,0.38666666,0.43814433,0.39,0.43814433,0.39333335,0.43814433,0.39666668,0.43814433,0.4,0.43814433,0.40333334,0.43814433,0.40666667,0.43814433,0.41,0.43814433,0.41333333,0.43814433,0.41666666,0.43814433,0.42,0.43814433,0.42333335,0.43814433,0.42666668,0.43814433,0.43,0.43814433,0.43333334,0.43814433,0.43666667,0.43814433,0.44,0.43814433,0.44333333,0.43814433,0.44666666,0.43814433,0.51666665,0.43814433,0.52,0.43814433,0.5233333,0.43814433,0.52666664,0.43814433,0.53,0.43814433,0.53333336,0.43814433,0.5366667,0.43814433,0.54,0.43814433,0.54333335,0.43814433,0.5466667,0.43814433,0.55,0.43814433,0.55333334,0.43814433,0.5566667,0.43814433,0.56,0.43814433,0.56333333,0.43814433,0.56666666,0.43814433,0.57,0.43814433,0.5733333,0.43814433,0.57666665,0.43814433,0.58,0.43814433,0.62666667,0.43814433,0.63,0.43814433,0.6333333,0.43814433,0.63666666,0.43814433,0.64,0.43814433,0.6433333,0.43814433,0.64666665,0.43814433,0.65,0.43814433,0.6533333,0.43814433,0.6566667,0.43814433,0.66,0.43814433,0.66333336,0.43814433,0.6666667,0.43814433,0.67,0.43814433,0.67333335,0.43814433,0.6766667,0.43814433,0.68,0.43814433,0.68333334,0.43814433,0.68666667,0.43814433,0.69,0.43814433,0.6933333,0.43814433,0.69666666,0.43814433,0.7,0.43814433,0.7033333,0.43814433,0.70666665,0.43814433,0.71,0.43814433,0.7133333,0.43814433,0.71666664,0.43814433,0.72,0.43814433,0.72333336,0.43814433,0.7266667,0.43814433,0.73,0.43814433,0.82,0.43814433,0.8233333,0.43814433,0.82666665,0.43814433,0.83,0.43814433,0.8333333,0.43814433,0.83666664,0.43814433,0.84,0.43814433,0.8433333,0.43814433,0.8466667,0.43814433,0.85,0.43814433,0.85333335,0.43814433,0.8566667,0.43814433,0.86,0.43814433,0.86333334,0.43814433,0.8666667,0.43814433,0.15,0.44072166,0.15333334,0.44072166,0.15666667,0.44072166,0.16,0.44072166,0.16333333,0.44072166,0.16666667,0.44072166,0.17,0.44072166,0.23,0.44072166,0.23333333,0.44072166,0.23666666,0.44072166,0.24,0.44072166,0.24333334,0.44072166,0.24666667,0.44072166,0.25,0.44072166,0.25333333,0.44072166,0.25666666,0.44072166,0.26,0.44072166,0.26333332,0.44072166,0.26666668,0.44072166,0.27,0.44072166,0.27333334,0.44072166,0.27666667,0.44072166,0.28,0.44072166,0.28333333,0.44072166,0.28666666,0.44072166,0.29,0.44072166,0.29333332,0.44072166,0.29666665,0.44072166,0.3,0.44072166,0.34,0.44072166,0.34333333,0.44072166,0.34666666,0.44072166,0.35,0.44072166,0.35333332,0.44072166,0.35666665,0.44072166,0.36,0.44072166,0.36333334,0.44072166,0.36666667,0.44072166,0.37,0.44072166,0.37333333,0.44072166,0.37666667,0.44072166,0.38,0.44072166,0.38333333,0.44072166,0.38666666,0.44072166,0.39,0.44072166,0.39333335,0.44072166,0.39666668,0.44072166,0.4,0.44072166,0.40333334,0.44072166,0.40666667,0.44072166,0.41,0.44072166,0.41333333,0.44072166,0.41666666,0.44072166,0.42,0.44072166,0.42333335,0.44072166,0.42666668,0.44072166,0.43,0.44072166,0.43333334,0.44072166,0.43666667,0.44072166,0.44,0.44072166,0.52,0.44072166,0.5233333,0.44072166,0.52666664,0.44072166,0.53,0.44072166,0.53333336,0.44072166,0.5366667,0.44072166,0.54,0.44072166,0.54333335,0.44072166,0.5466667,0.44072166,0.55,0.44072166,0.55333334,0.44072166,0.5566667,0.44072166,0.56,0.44072166,0.56333333,0.44072166,0.56666666,0.44072166,0.57,0.44072166,0.5733333,0.44072166,0.57666665,0.44072166,0.62666667,0.44072166,0.63,0.44072166,0.6333333,0.44072166,0.63666666,0.44072166,0.64,0.44072166,0.6433333,0.44072166,0.64666665,0.44072166,0.65,0.44072166,0.6533333,0.44072166,0.6566667,0.44072166,0.66,0.44072166,0.66333336,0.44072166,0.6666667,0.44072166,0.67,0.44072166,0.67333335,0.44072166,0.6766667,0.44072166,0.68,0.44072166,0.68333334,0.44072166,0.68666667,0.44072166,0.69,0.44072166,0.6933333,0.44072166,0.69666666,0.44072166,0.7,0.44072166,0.7033333,0.44072166,0.70666665,0.44072166,0.71,0.44072166,0.7133333,0.44072166,0.71666664,0.44072166,0.72,0.44072166,0.72333336,0.44072166,0.7266667,0.44072166,0.82666665,0.44072166,0.83,0.44072166,0.8333333,0.44072166,0.83666664,0.44072166,0.84,0.44072166,0.8433333,0.44072166,0.8466667,0.44072166,0.85,0.44072166,0.85333335,0.44072166,0.8566667,0.44072166,0.86,0.44072166,0.14666666,0.44329897,0.15,0.44329897,0.15333334,0.44329897,0.15666667,0.44329897,0.16,0.44329897,0.16333333,0.44329897,0.16666667,0.44329897,0.17,0.44329897,0.23,0.44329897,0.23333333,0.44329897,0.23666666,0.44329897,0.24,0.44329897,0.24333334,0.44329897,0.24666667,0.44329897,0.25,0.44329897,0.25333333,0.44329897,0.25666666,0.44329897,0.26,0.44329897,0.26333332,0.44329897,0.26666668,0.44329897,0.27,0.44329897,0.27333334,0.44329897,0.27666667,0.44329897,0.28,0.44329897,0.28333333,0.44329897,0.28666666,0.44329897,0.29,0.44329897,0.29333332,0.44329897,0.29666665,0.44329897,0.34,0.44329897,0.34333333,0.44329897,0.34666666,0.44329897,0.35,0.44329897,0.35333332,0.44329897,0.35666665,0.44329897,0.36,0.44329897,0.36333334,0.44329897,0.36666667,0.44329897,0.37,0.44329897,0.37333333,0.44329897,0.37666667,0.44329897,0.38,0.44329897,0.38333333,0.44329897,0.38666666,0.44329897,0.39,0.44329897,0.39333335,0.44329897,0.39666668,0.44329897,0.4,0.44329897,0.40333334,0.44329897,0.40666667,0.44329897,0.41,0.44329897,0.41333333,0.44329897,0.41666666,0.44329897,0.42,0.44329897,0.42333335,0.44329897,0.42666668,0.44329897,0.43,0.44329897,0.43333334,0.44329897,0.43666667,0.44329897,0.52666664,0.44329897,0.53,0.44329897,0.53333336,0.44329897,0.5366667,0.44329897,0.54,0.44329897,0.54333335,0.44329897,0.5466667,0.44329897,0.55,0.44329897,0.55333334,0.44329897,0.5566667,0.44329897,0.56,0.44329897,0.56333333,0.44329897,0.56666666,0.44329897,0.57,0.44329897,0.5733333,0.44329897,0.57666665,0.44329897,0.62666667,0.44329897,0.63,0.44329897,0.6333333,0.44329897,0.63666666,0.44329897,0.64,0.44329897,0.6433333,0.44329897,0.64666665,0.44329897,0.65,0.44329897,0.6533333,0.44329897,0.6566667,0.44329897,0.66,0.44329897,0.66333336,0.44329897,0.6666667,0.44329897,0.67,0.44329897,0.67333335,0.44329897,0.6766667,0.44329897,0.68,0.44329897,0.68333334,0.44329897,0.68666667,0.44329897,0.69,0.44329897,0.6933333,0.44329897,0.69666666,0.44329897,0.7,0.44329897,0.7033333,0.44329897,0.70666665,0.44329897,0.71,0.44329897,0.7133333,0.44329897,0.71666664,0.44329897,0.72,0.44329897,0.72333336,0.44329897,0.83,0.44329897,0.8333333,0.44329897,0.83666664,0.44329897,0.84,0.44329897,0.8433333,0.44329897,0.8466667,0.44329897,0.85,0.44329897,0.85333335,0.44329897,0.8566667,0.44329897,0.14,0.4458763,0.14333333,0.4458763,0.14666666,0.4458763,0.15,0.4458763,0.15333334,0.4458763,0.15666667,0.4458763,0.16,0.4458763,0.16333333,0.4458763,0.16666667,0.4458763,0.23333333,0.4458763,0.23666666,0.4458763,0.24,0.4458763,0.24333334,0.4458763,0.24666667,0.4458763,0.25,0.4458763,0.25333333,0.4458763,0.25666666,0.4458763,0.26,0.4458763,0.26333332,0.4458763,0.26666668,0.4458763,0.27,0.4458763,0.27333334,0.4458763,0.27666667,0.4458763,0.28,0.4458763,0.28333333,0.4458763,0.28666666,0.4458763,0.29,0.4458763,0.29333332,0.4458763,0.34,0.4458763,0.34333333,0.4458763,0.34666666,0.4458763,0.35,0.4458763,0.35333332,0.4458763,0.35666665,0.4458763,0.36,0.4458763,0.36333334,0.4458763,0.36666667,0.4458763,0.37,0.4458763,0.37333333,0.4458763,0.37666667,0.4458763,0.38,0.4458763,0.38333333,0.4458763,0.38666666,0.4458763,0.39,0.4458763,0.39333335,0.4458763,0.39666668,0.4458763,0.4,0.4458763,0.40333334,0.4458763,0.40666667,0.4458763,0.41,0.4458763,0.41333333,0.4458763,0.41666666,0.4458763,0.42,0.4458763,0.42333335,0.4458763,0.42666668,0.4458763,0.43,0.4458763,0.53,0.4458763,0.53333336,0.4458763,0.5366667,0.4458763,0.54,0.4458763,0.54333335,0.4458763,0.5466667,0.4458763,0.55,0.4458763,0.55333334,0.4458763,0.5566667,0.4458763,0.56,0.4458763,0.56333333,0.4458763,0.56666666,0.4458763,0.57,0.4458763,0.5733333,0.4458763,0.57666665,0.4458763,0.63,0.4458763,0.6333333,0.4458763,0.63666666,0.4458763,0.64,0.4458763,0.6433333,0.4458763,0.64666665,0.4458763,0.65,0.4458763,0.6533333,0.4458763,0.6566667,0.4458763,0.66,0.4458763,0.66333336,0.4458763,0.6666667,0.4458763,0.67,0.4458763,0.67333335,0.4458763,0.6766667,0.4458763,0.68,0.4458763,0.68333334,0.4458763,0.68666667,0.4458763,0.69,0.4458763,0.6933333,0.4458763,0.69666666,0.4458763,0.7,0.4458763,0.7033333,0.4458763,0.70666665,0.4458763,0.71,0.4458763,0.7133333,0.4458763,0.71666664,0.4458763,0.83666664,0.4458763,0.84,0.4458763,0.8433333,0.4458763,0.8466667,0.4458763,0.85,0.4458763,0.85333335,0.4458763,0.8566667,0.4458763,0.06666667,0.4484536,0.07,0.4484536,0.07333333,0.4484536,0.07666667,0.4484536,0.08,0.4484536,0.083333336,0.4484536,0.086666666,0.4484536,0.09,0.4484536,0.093333334,0.4484536,0.096666664,0.4484536,0.13333334,0.4484536,0.13666667,0.4484536,0.14,0.4484536,0.14333333,0.4484536,0.14666666,0.4484536,0.15,0.4484536,0.15333334,0.4484536,0.15666667,0.4484536,0.16,0.4484536,0.16333333,0.4484536,0.16666667,0.4484536,0.23333333,0.4484536,0.23666666,0.4484536,0.24,0.4484536,0.24333334,0.4484536,0.24666667,0.4484536,0.25,0.4484536,0.25333333,0.4484536,0.25666666,0.4484536,0.26,0.4484536,0.26333332,0.4484536,0.26666668,0.4484536,0.27,0.4484536,0.27333334,0.4484536,0.27666667,0.4484536,0.28,0.4484536,0.28333333,0.4484536,0.28666666,0.4484536,0.29,0.4484536,0.34,0.4484536,0.34333333,0.4484536,0.34666666,0.4484536,0.35,0.4484536,0.35333332,0.4484536,0.35666665,0.4484536,0.36,0.4484536,0.36333334,0.4484536,0.36666667,0.4484536,0.37,0.4484536,0.37333333,0.4484536,0.37666667,0.4484536,0.38,0.4484536,0.38333333,0.4484536,0.38666666,0.4484536,0.39,0.4484536,0.39333335,0.4484536,0.39666668,0.4484536,0.4,0.4484536,0.40333334,0.4484536,0.40666667,0.4484536,0.41,0.4484536,0.41333333,0.4484536,0.41666666,0.4484536,0.42,0.4484536,0.42333335,0.4484536,0.42666668,0.4484536,0.53333336,0.4484536,0.5366667,0.4484536,0.54,0.4484536,0.54333335,0.4484536,0.5466667,0.4484536,0.55,0.4484536,0.55333334,0.4484536,0.5566667,0.4484536,0.56,0.4484536,0.56333333,0.4484536,0.56666666,0.4484536,0.57,0.4484536,0.5733333,0.4484536,0.57666665,0.4484536,0.58,0.4484536,0.5833333,0.4484536,0.58666664,0.4484536,0.59,0.4484536,0.5933333,0.4484536,0.63,0.4484536,0.6333333,0.4484536,0.63666666,0.4484536,0.64,0.4484536,0.6433333,0.4484536,0.64666665,0.4484536,0.65,0.4484536,0.6533333,0.4484536,0.6566667,0.4484536,0.66,0.4484536,0.66333336,0.4484536,0.6666667,0.4484536,0.67,0.4484536,0.67333335,0.4484536,0.6766667,0.4484536,0.68,0.4484536,0.68333334,0.4484536,0.68666667,0.4484536,0.69,0.4484536,0.6933333,0.4484536,0.69666666,0.4484536,0.7,0.4484536,0.7033333,0.4484536,0.70666665,0.4484536,0.71,0.4484536,0.7133333,0.4484536,0.84,0.4484536,0.8433333,0.4484536,0.8466667,0.4484536,0.85,0.4484536,0.85333335,0.4484536,0.8566667,0.4484536,0.06333333,0.45103094,0.06666667,0.45103094,0.07,0.45103094,0.07333333,0.45103094,0.07666667,0.45103094,0.08,0.45103094,0.083333336,0.45103094,0.086666666,0.45103094,0.09,0.45103094,0.093333334,0.45103094,0.096666664,0.45103094,0.1,0.45103094,0.10333333,0.45103094,0.10666667,0.45103094,0.11,0.45103094,0.11333334,0.45103094,0.11666667,0.45103094,0.12,0.45103094,0.123333335,0.45103094,0.12666667,0.45103094,0.13,0.45103094,0.13333334,0.45103094,0.13666667,0.45103094,0.14,0.45103094,0.14333333,0.45103094,0.14666666,0.45103094,0.15,0.45103094,0.15333334,0.45103094,0.15666667,0.45103094,0.16,0.45103094,0.16333333,0.45103094,0.16666667,0.45103094,0.23,0.45103094,0.23333333,0.45103094,0.23666666,0.45103094,0.24,0.45103094,0.24333334,0.45103094,0.24666667,0.45103094,0.25,0.45103094,0.25333333,0.45103094,0.25666666,0.45103094,0.26,0.45103094,0.26333332,0.45103094,0.26666668,0.45103094,0.27,0.45103094,0.27333334,0.45103094,0.27666667,0.45103094,0.28,0.45103094,0.28333333,0.45103094,0.28666666,0.45103094,0.29,0.45103094,0.34,0.45103094,0.34333333,0.45103094,0.34666666,0.45103094,0.35,0.45103094,0.35333332,0.45103094,0.35666665,0.45103094,0.36,0.45103094,0.36333334,0.45103094,0.36666667,0.45103094,0.37,0.45103094,0.37333333,0.45103094,0.37666667,0.45103094,0.38,0.45103094,0.38333333,0.45103094,0.38666666,0.45103094,0.39,0.45103094,0.39333335,0.45103094,0.39666668,0.45103094,0.4,0.45103094,0.40333334,0.45103094,0.40666667,0.45103094,0.41,0.45103094,0.41333333,0.45103094,0.41666666,0.45103094,0.42,0.45103094,0.54,0.45103094,0.54333335,0.45103094,0.5466667,0.45103094,0.55,0.45103094,0.55333334,0.45103094,0.5566667,0.45103094,0.56,0.45103094,0.56333333,0.45103094,0.56666666,0.45103094,0.57,0.45103094,0.5733333,0.45103094,0.57666665,0.45103094,0.58,0.45103094,0.5833333,0.45103094,0.58666664,0.45103094,0.59,0.45103094,0.5933333,0.45103094,0.5966667,0.45103094,0.6,0.45103094,0.6333333,0.45103094,0.63666666,0.45103094,0.64,0.45103094,0.6433333,0.45103094,0.64666665,0.45103094,0.65,0.45103094,0.6533333,0.45103094,0.6566667,0.45103094,0.66,0.45103094,0.66333336,0.45103094,0.6666667,0.45103094,0.67,0.45103094,0.67333335,0.45103094,0.6766667,0.45103094,0.68,0.45103094,0.68333334,0.45103094,0.68666667,0.45103094,0.69,0.45103094,0.6933333,0.45103094,0.69666666,0.45103094,0.7,0.45103094,0.7033333,0.45103094,0.70666665,0.45103094,0.71,0.45103094,0.7133333,0.45103094,0.8433333,0.45103094,0.8466667,0.45103094,0.85,0.45103094,0.85333335,0.45103094,0.8566667,0.45103094,0.86,0.45103094,0.06333333,0.45360824,0.06666667,0.45360824,0.07,0.45360824,0.07333333,0.45360824,0.07666667,0.45360824,0.08,0.45360824,0.083333336,0.45360824,0.086666666,0.45360824,0.09,0.45360824,0.093333334,0.45360824,0.096666664,0.45360824,0.1,0.45360824,0.10333333,0.45360824,0.10666667,0.45360824,0.11,0.45360824,0.11333334,0.45360824,0.11666667,0.45360824,0.12,0.45360824,0.123333335,0.45360824,0.12666667,0.45360824,0.13,0.45360824,0.13333334,0.45360824,0.13666667,0.45360824,0.14,0.45360824,0.14333333,0.45360824,0.14666666,0.45360824,0.15,0.45360824,0.15333334,0.45360824,0.15666667,0.45360824,0.16,0.45360824,0.16333333,0.45360824,0.16666667,0.45360824,0.23333333,0.45360824,0.23666666,0.45360824,0.24,0.45360824,0.24333334,0.45360824,0.24666667,0.45360824,0.25,0.45360824,0.25333333,0.45360824,0.25666666,0.45360824,0.26,0.45360824,0.26333332,0.45360824,0.26666668,0.45360824,0.27,0.45360824,0.27333334,0.45360824,0.27666667,0.45360824,0.28,0.45360824,0.28333333,0.45360824,0.28666666,0.45360824,0.29,0.45360824,0.34333333,0.45360824,0.34666666,0.45360824,0.35,0.45360824,0.35333332,0.45360824,0.35666665,0.45360824,0.36,0.45360824,0.36333334,0.45360824,0.36666667,0.45360824,0.37,0.45360824,0.37333333,0.45360824,0.37666667,0.45360824,0.38,0.45360824,0.38333333,0.45360824,0.38666666,0.45360824,0.39,0.45360824,0.39333335,0.45360824,0.39666668,0.45360824,0.4,0.45360824,0.40333334,0.45360824,0.40666667,0.45360824,0.41,0.45360824,0.41333333,0.45360824,0.54333335,0.45360824,0.5466667,0.45360824,0.55,0.45360824,0.55333334,0.45360824,0.5566667,0.45360824,0.56,0.45360824,0.56333333,0.45360824,0.56666666,0.45360824,0.57,0.45360824,0.5733333,0.45360824,0.57666665,0.45360824,0.58,0.45360824,0.5833333,0.45360824,0.58666664,0.45360824,0.59,0.45360824,0.5933333,0.45360824,0.5966667,0.45360824,0.6,0.45360824,0.60333335,0.45360824,0.6333333,0.45360824,0.63666666,0.45360824,0.64,0.45360824,0.6433333,0.45360824,0.64666665,0.45360824,0.65,0.45360824,0.6533333,0.45360824,0.6566667,0.45360824,0.66,0.45360824,0.68333334,0.45360824,0.68666667,0.45360824,0.69,0.45360824,0.6933333,0.45360824,0.69666666,0.45360824,0.7,0.45360824,0.7033333,0.45360824,0.70666665,0.45360824,0.71,0.45360824,0.8433333,0.45360824,0.8466667,0.45360824,0.85,0.45360824,0.85333335,0.45360824,0.8566667,0.45360824,0.86,0.45360824,0.86333334,0.45360824,0.06,0.45618558,0.06333333,0.45618558,0.06666667,0.45618558,0.07,0.45618558,0.07333333,0.45618558,0.07666667,0.45618558,0.08,0.45618558,0.083333336,0.45618558,0.086666666,0.45618558,0.09,0.45618558,0.093333334,0.45618558,0.096666664,0.45618558,0.1,0.45618558,0.10333333,0.45618558,0.10666667,0.45618558,0.11,0.45618558,0.11333334,0.45618558,0.11666667,0.45618558,0.12,0.45618558,0.123333335,0.45618558,0.12666667,0.45618558,0.13,0.45618558,0.13333334,0.45618558,0.13666667,0.45618558,0.14,0.45618558,0.14333333,0.45618558,0.14666666,0.45618558,0.15,0.45618558,0.15333334,0.45618558,0.15666667,0.45618558,0.16,0.45618558,0.16333333,0.45618558,0.16666667,0.45618558,0.23666666,0.45618558,0.24,0.45618558,0.24333334,0.45618558,0.24666667,0.45618558,0.25,0.45618558,0.25333333,0.45618558,0.25666666,0.45618558,0.26,0.45618558,0.26333332,0.45618558,0.26666668,0.45618558,0.27,0.45618558,0.27333334,0.45618558,0.27666667,0.45618558,0.28,0.45618558,0.28333333,0.45618558,0.28666666,0.45618558,0.29,0.45618558,0.36333334,0.45618558,0.36666667,0.45618558,0.37,0.45618558,0.37333333,0.45618558,0.37666667,0.45618558,0.38,0.45618558,0.38333333,0.45618558,0.38666666,0.45618558,0.39,0.45618558,0.39333335,0.45618558,0.39666668,0.45618558,0.4,0.45618558,0.40333334,0.45618558,0.40666667,0.45618558,0.41,0.45618558,0.5466667,0.45618558,0.55,0.45618558,0.55333334,0.45618558,0.5566667,0.45618558,0.56,0.45618558,0.56333333,0.45618558,0.56666666,0.45618558,0.57,0.45618558,0.5733333,0.45618558,0.57666665,0.45618558,0.58,0.45618558,0.5833333,0.45618558,0.58666664,0.45618558,0.59,0.45618558,0.5933333,0.45618558,0.5966667,0.45618558,0.6,0.45618558,0.60333335,0.45618558,0.64,0.45618558,0.6433333,0.45618558,0.64666665,0.45618558,0.65,0.45618558,0.68666667,0.45618558,0.69,0.45618558,0.6933333,0.45618558,0.69666666,0.45618558,0.7,0.45618558,0.7033333,0.45618558,0.70666665,0.45618558,0.8466667,0.45618558,0.85,0.45618558,0.85333335,0.45618558,0.8566667,0.45618558,0.86,0.45618558,0.86333334,0.45618558,0.8666667,0.45618558,0.87,0.45618558,0.87333333,0.45618558,0.87666667,0.45618558,0.88,0.45618558,0.8833333,0.45618558,0.88666666,0.45618558,0.89,0.45618558,0.8933333,0.45618558,0.06,0.45876288,0.06333333,0.45876288,0.06666667,0.45876288,0.07,0.45876288,0.07333333,0.45876288,0.07666667,0.45876288,0.08,0.45876288,0.083333336,0.45876288,0.086666666,0.45876288,0.09,0.45876288,0.093333334,0.45876288,0.096666664,0.45876288,0.1,0.45876288,0.10333333,0.45876288,0.10666667,0.45876288,0.11,0.45876288,0.11333334,0.45876288,0.11666667,0.45876288,0.12,0.45876288,0.123333335,0.45876288,0.12666667,0.45876288,0.13,0.45876288,0.13333334,0.45876288,0.13666667,0.45876288,0.14,0.45876288,0.14333333,0.45876288,0.14666666,0.45876288,0.15,0.45876288,0.15333334,0.45876288,0.15666667,0.45876288,0.16,0.45876288,0.16333333,0.45876288,0.16666667,0.45876288,0.24333334,0.45876288,0.24666667,0.45876288,0.25,0.45876288,0.25333333,0.45876288,0.25666666,0.45876288,0.26,0.45876288,0.26333332,0.45876288,0.26666668,0.45876288,0.27,0.45876288,0.27333334,0.45876288,0.27666667,0.45876288,0.28,0.45876288,0.28333333,0.45876288,0.28666666,0.45876288,0.29,0.45876288,0.29333332,0.45876288,0.29666665,0.45876288,0.37666667,0.45876288,0.38,0.45876288,0.38333333,0.45876288,0.38666666,0.45876288,0.39,0.45876288,0.39333335,0.45876288,0.39666668,0.45876288,0.4,0.45876288,0.40333334,0.45876288,0.40666667,0.45876288,0.55,0.45876288,0.55333334,0.45876288,0.5566667,0.45876288,0.56,0.45876288,0.56333333,0.45876288,0.56666666,0.45876288,0.57,0.45876288,0.5733333,0.45876288,0.57666665,0.45876288,0.58,0.45876288,0.5833333,0.45876288,0.58666664,0.45876288,0.59,0.45876288,0.5933333,0.45876288,0.5966667,0.45876288,0.6,0.45876288,0.60333335,0.45876288,0.68666667,0.45876288,0.69,0.45876288,0.6933333,0.45876288,0.69666666,0.45876288,0.7,0.45876288,0.7033333,0.45876288,0.8466667,0.45876288,0.85,0.45876288,0.85333335,0.45876288,0.8566667,0.45876288,0.86,0.45876288,0.86333334,0.45876288,0.8666667,0.45876288,0.87,0.45876288,0.87333333,0.45876288,0.87666667,0.45876288,0.88,0.45876288,0.8833333,0.45876288,0.88666666,0.45876288,0.89,0.45876288,0.8933333,0.45876288,0.89666665,0.45876288,0.9,0.45876288,0.9033333,0.45876288,0.06,0.46134022,0.06333333,0.46134022,0.06666667,0.46134022,0.07,0.46134022,0.07333333,0.46134022,0.07666667,0.46134022,0.08,0.46134022,0.083333336,0.46134022,0.086666666,0.46134022,0.09,0.46134022,0.093333334,0.46134022,0.096666664,0.46134022,0.1,0.46134022,0.10333333,0.46134022,0.10666667,0.46134022,0.11,0.46134022,0.11333334,0.46134022,0.11666667,0.46134022,0.12,0.46134022,0.123333335,0.46134022,0.12666667,0.46134022,0.13,0.46134022,0.13333334,0.46134022,0.13666667,0.46134022,0.14,0.46134022,0.14333333,0.46134022,0.14666666,0.46134022,0.15,0.46134022,0.15333334,0.46134022,0.15666667,0.46134022,0.16,0.46134022,0.16333333,0.46134022,0.25,0.46134022,0.25333333,0.46134022,0.25666666,0.46134022,0.26,0.46134022,0.26333332,0.46134022,0.26666668,0.46134022,0.27,0.46134022,0.27333334,0.46134022,0.27666667,0.46134022,0.28,0.46134022,0.28333333,0.46134022,0.28666666,0.46134022,0.29,0.46134022,0.29333332,0.46134022,0.29666665,0.46134022,0.3,0.46134022,0.30333334,0.46134022,0.30666667,0.46134022,0.31,0.46134022,0.31333333,0.46134022,0.31666666,0.46134022,0.38,0.46134022,0.38333333,0.46134022,0.38666666,0.46134022,0.39,0.46134022,0.39333335,0.46134022,0.39666668,0.46134022,0.4,0.46134022,0.40333334,0.46134022,0.40666667,0.46134022,0.55333334,0.46134022,0.5566667,0.46134022,0.56,0.46134022,0.56333333,0.46134022,0.56666666,0.46134022,0.57,0.46134022,0.5733333,0.46134022,0.57666665,0.46134022,0.58,0.46134022,0.5833333,0.46134022,0.58666664,0.46134022,0.59,0.46134022,0.5933333,0.46134022,0.5966667,0.46134022,0.6,0.46134022,0.60333335,0.46134022,0.68666667,0.46134022,0.69,0.46134022,0.6933333,0.46134022,0.69666666,0.46134022,0.7,0.46134022,0.7033333,0.46134022,0.85,0.46134022,0.85333335,0.46134022,0.8566667,0.46134022,0.86,0.46134022,0.86333334,0.46134022,0.8666667,0.46134022,0.87,0.46134022,0.87333333,0.46134022,0.87666667,0.46134022,0.88,0.46134022,0.8833333,0.46134022,0.88666666,0.46134022,0.89,0.46134022,0.8933333,0.46134022,0.89666665,0.46134022,0.9,0.46134022,0.9033333,0.46134022,0.9066667,0.46134022,0.06,0.46391752,0.06333333,0.46391752,0.06666667,0.46391752,0.07,0.46391752,0.07333333,0.46391752,0.07666667,0.46391752,0.08,0.46391752,0.083333336,0.46391752,0.086666666,0.46391752,0.09,0.46391752,0.093333334,0.46391752,0.096666664,0.46391752,0.1,0.46391752,0.10333333,0.46391752,0.10666667,0.46391752,0.11,0.46391752,0.11333334,0.46391752,0.11666667,0.46391752,0.12,0.46391752,0.123333335,0.46391752,0.12666667,0.46391752,0.13,0.46391752,0.13333334,0.46391752,0.13666667,0.46391752,0.14,0.46391752,0.14333333,0.46391752,0.14666666,0.46391752,0.15,0.46391752,0.15333334,0.46391752,0.15666667,0.46391752,0.16,0.46391752,0.25666666,0.46391752,0.26333332,0.46391752,0.26666668,0.46391752,0.27,0.46391752,0.27333334,0.46391752,0.27666667,0.46391752,0.28,0.46391752,0.28333333,0.46391752,0.28666666,0.46391752,0.29,0.46391752,0.29333332,0.46391752,0.29666665,0.46391752,0.3,0.46391752,0.30333334,0.46391752,0.30666667,0.46391752,0.31,0.46391752,0.31333333,0.46391752,0.31666666,0.46391752,0.32,0.46391752,0.32333332,0.46391752,0.32666665,0.46391752,0.38333333,0.46391752,0.38666666,0.46391752,0.39,0.46391752,0.39333335,0.46391752,0.39666668,0.46391752,0.4,0.46391752,0.40333334,0.46391752,0.40666667,0.46391752,0.55333334,0.46391752,0.5566667,0.46391752,0.56,0.46391752,0.56333333,0.46391752,0.56666666,0.46391752,0.57,0.46391752,0.5733333,0.46391752,0.57666665,0.46391752,0.58,0.46391752,0.5833333,0.46391752,0.58666664,0.46391752,0.59,0.46391752,0.5933333,0.46391752,0.5966667,0.46391752,0.6,0.46391752,0.68666667,0.46391752,0.69,0.46391752,0.6933333,0.46391752,0.69666666,0.46391752,0.7,0.46391752,0.7033333,0.46391752,0.85,0.46391752,0.85333335,0.46391752,0.8566667,0.46391752,0.86,0.46391752,0.86333334,0.46391752,0.8666667,0.46391752,0.87,0.46391752,0.87333333,0.46391752,0.87666667,0.46391752,0.88,0.46391752,0.8833333,0.46391752,0.88666666,0.46391752,0.89,0.46391752,0.8933333,0.46391752,0.89666665,0.46391752,0.9,0.46391752,0.9033333,0.46391752,0.9066667,0.46391752,0.91,0.46391752,0.06333333,0.46649486,0.06666667,0.46649486,0.07,0.46649486,0.07333333,0.46649486,0.07666667,0.46649486,0.08,0.46649486,0.083333336,0.46649486,0.086666666,0.46649486,0.09,0.46649486,0.093333334,0.46649486,0.096666664,0.46649486,0.1,0.46649486,0.10333333,0.46649486,0.10666667,0.46649486,0.11,0.46649486,0.11333334,0.46649486,0.11666667,0.46649486,0.12,0.46649486,0.123333335,0.46649486,0.12666667,0.46649486,0.13,0.46649486,0.13333334,0.46649486,0.13666667,0.46649486,0.14,0.46649486,0.14333333,0.46649486,0.14666666,0.46649486,0.15,0.46649486,0.15333334,0.46649486,0.26666668,0.46649486,0.27,0.46649486,0.27333334,0.46649486,0.27666667,0.46649486,0.28,0.46649486,0.28333333,0.46649486,0.28666666,0.46649486,0.29,0.46649486,0.29333332,0.46649486,0.29666665,0.46649486,0.3,0.46649486,0.30333334,0.46649486,0.30666667,0.46649486,0.31,0.46649486,0.31333333,0.46649486,0.31666666,0.46649486,0.32,0.46649486,0.32333332,0.46649486,0.32666665,0.46649486,0.33,0.46649486,0.33333334,0.46649486,0.38333333,0.46649486,0.38666666,0.46649486,0.39,0.46649486,0.39333335,0.46649486,0.39666668,0.46649486,0.4,0.46649486,0.40333334,0.46649486,0.40666667,0.46649486,0.55333334,0.46649486,0.5566667,0.46649486,0.56,0.46649486,0.56333333,0.46649486,0.56666666,0.46649486,0.57,0.46649486,0.5733333,0.46649486,0.57666665,0.46649486,0.58,0.46649486,0.5833333,0.46649486,0.58666664,0.46649486,0.59,0.46649486,0.5933333,0.46649486,0.69,0.46649486,0.6933333,0.46649486,0.69666666,0.46649486,0.7,0.46649486,0.85333335,0.46649486,0.8566667,0.46649486,0.86,0.46649486,0.86333334,0.46649486,0.8666667,0.46649486,0.87,0.46649486,0.87333333,0.46649486,0.87666667,0.46649486,0.88,0.46649486,0.8833333,0.46649486,0.88666666,0.46649486,0.89,0.46649486,0.8933333,0.46649486,0.89666665,0.46649486,0.9,0.46649486,0.9033333,0.46649486,0.9066667,0.46649486,0.91,0.46649486,0.91333336,0.46649486,0.06666667,0.46907216,0.07,0.46907216,0.07333333,0.46907216,0.07666667,0.46907216,0.08,0.46907216,0.083333336,0.46907216,0.086666666,0.46907216,0.09,0.46907216,0.093333334,0.46907216,0.096666664,0.46907216,0.1,0.46907216,0.10333333,0.46907216,0.10666667,0.46907216,0.11,0.46907216,0.11333334,0.46907216,0.11666667,0.46907216,0.12,0.46907216,0.123333335,0.46907216,0.12666667,0.46907216,0.13,0.46907216,0.13333334,0.46907216,0.13666667,0.46907216,0.14,0.46907216,0.14333333,0.46907216,0.14666666,0.46907216,0.15,0.46907216,0.26666668,0.46907216,0.27,0.46907216,0.27333334,0.46907216,0.27666667,0.46907216,0.28,0.46907216,0.28333333,0.46907216,0.28666666,0.46907216,0.29,0.46907216,0.29333332,0.46907216,0.29666665,0.46907216,0.3,0.46907216,0.30333334,0.46907216,0.30666667,0.46907216,0.31,0.46907216,0.31333333,0.46907216,0.31666666,0.46907216,0.32,0.46907216,0.32333332,0.46907216,0.32666665,0.46907216,0.33,0.46907216,0.33333334,0.46907216,0.33666667,0.46907216,0.38333333,0.46907216,0.38666666,0.46907216,0.39,0.46907216,0.39333335,0.46907216,0.39666668,0.46907216,0.4,0.46907216,0.40333334,0.46907216,0.40666667,0.46907216,0.55333334,0.46907216,0.5566667,0.46907216,0.56,0.46907216,0.56333333,0.46907216,0.56666666,0.46907216,0.57,0.46907216,0.5733333,0.46907216,0.57666665,0.46907216,0.58,0.46907216,0.5833333,0.46907216,0.58666664,0.46907216,0.68666667,0.46907216,0.69,0.46907216,0.6933333,0.46907216,0.69666666,0.46907216,0.7,0.46907216,0.85333335,0.46907216,0.8566667,0.46907216,0.86,0.46907216,0.86333334,0.46907216,0.8666667,0.46907216,0.87,0.46907216,0.87333333,0.46907216,0.87666667,0.46907216,0.88,0.46907216,0.8833333,0.46907216,0.88666666,0.46907216,0.89,0.46907216,0.8933333,0.46907216,0.89666665,0.46907216,0.9,0.46907216,0.9033333,0.46907216,0.9066667,0.46907216,0.91,0.46907216,0.91333336,0.46907216,0.07,0.4716495,0.07333333,0.4716495,0.07666667,0.4716495,0.08,0.4716495,0.083333336,0.4716495,0.086666666,0.4716495,0.09,0.4716495,0.093333334,0.4716495,0.096666664,0.4716495,0.1,0.4716495,0.10333333,0.4716495,0.10666667,0.4716495,0.11,0.4716495,0.11333334,0.4716495,0.11666667,0.4716495,0.12,0.4716495,0.123333335,0.4716495,0.12666667,0.4716495,0.13,0.4716495,0.13333334,0.4716495,0.13666667,0.4716495,0.14,0.4716495,0.14333333,0.4716495,0.26666668,0.4716495,0.27,0.4716495,0.27333334,0.4716495,0.27666667,0.4716495,0.28,0.4716495,0.28333333,0.4716495,0.28666666,0.4716495,0.29,0.4716495,0.29333332,0.4716495,0.29666665,0.4716495,0.3,0.4716495,0.30333334,0.4716495,0.30666667,0.4716495,0.31,0.4716495,0.31333333,0.4716495,0.31666666,0.4716495,0.32,0.4716495,0.32333332,0.4716495,0.32666665,0.4716495,0.33,0.4716495,0.33333334,0.4716495,0.33666667,0.4716495,0.38333333,0.4716495,0.38666666,0.4716495,0.39,0.4716495,0.39333335,0.4716495,0.39666668,0.4716495,0.4,0.4716495,0.40333334,0.4716495,0.40666667,0.4716495,0.55333334,0.4716495,0.5566667,0.4716495,0.56,0.4716495,0.56333333,0.4716495,0.56666666,0.4716495,0.57,0.4716495,0.5733333,0.4716495,0.57666665,0.4716495,0.58,0.4716495,0.5833333,0.4716495,0.68666667,0.4716495,0.69,0.4716495,0.6933333,0.4716495,0.69666666,0.4716495,0.85333335,0.4716495,0.8566667,0.4716495,0.86,0.4716495,0.86333334,0.4716495,0.8666667,0.4716495,0.87,0.4716495,0.87333333,0.4716495,0.87666667,0.4716495,0.88,0.4716495,0.8833333,0.4716495,0.88666666,0.4716495,0.89,0.4716495,0.8933333,0.4716495,0.89666665,0.4716495,0.9,0.4716495,0.9033333,0.4716495,0.9066667,0.4716495,0.91,0.4716495,0.91333336,0.4716495,0.9166667,0.4716495,0.10666667,0.4742268,0.11,0.4742268,0.11333334,0.4742268,0.11666667,0.4742268,0.12,0.4742268,0.123333335,0.4742268,0.12666667,0.4742268,0.13,0.4742268,0.13333334,0.4742268,0.13666667,0.4742268,0.26666668,0.4742268,0.27,0.4742268,0.27333334,0.4742268,0.27666667,0.4742268,0.28,0.4742268,0.28333333,0.4742268,0.28666666,0.4742268,0.29,0.4742268,0.29333332,0.4742268,0.29666665,0.4742268,0.3,0.4742268,0.30333334,0.4742268,0.30666667,0.4742268,0.31,0.4742268,0.31333333,0.4742268,0.31666666,0.4742268,0.32,0.4742268,0.32333332,0.4742268,0.32666665,0.4742268,0.33,0.4742268,0.33333334,0.4742268,0.33666667,0.4742268,0.34,0.4742268,0.38,0.4742268,0.38333333,0.4742268,0.38666666,0.4742268,0.39,0.4742268,0.39333335,0.4742268,0.39666668,0.4742268,0.4,0.4742268,0.40333334,0.4742268,0.40666667,0.4742268,0.55333334,0.4742268,0.5566667,0.4742268,0.56,0.4742268,0.56333333,0.4742268,0.56666666,0.4742268,0.57,0.4742268,0.5733333,0.4742268,0.57666665,0.4742268,0.58,0.4742268,0.5833333,0.4742268,0.58666664,0.4742268,0.68333334,0.4742268,0.68666667,0.4742268,0.69,0.4742268,0.6933333,0.4742268,0.69666666,0.4742268,0.8566667,0.4742268,0.86,0.4742268,0.86333334,0.4742268,0.8666667,0.4742268,0.87,0.4742268,0.87333333,0.4742268,0.87666667,0.4742268,0.88,0.4742268,0.8833333,0.4742268,0.88666666,0.4742268,0.89,0.4742268,0.8933333,0.4742268,0.89666665,0.4742268,0.9,0.4742268,0.9033333,0.4742268,0.9066667,0.4742268,0.91,0.4742268,0.91333336,0.4742268,0.9166667,0.4742268,0.11,0.47680414,0.11333334,0.47680414,0.11666667,0.47680414,0.12,0.47680414,0.123333335,0.47680414,0.12666667,0.47680414,0.13,0.47680414,0.13333334,0.47680414,0.13666667,0.47680414,0.26666668,0.47680414,0.27,0.47680414,0.27333334,0.47680414,0.27666667,0.47680414,0.28,0.47680414,0.28333333,0.47680414,0.28666666,0.47680414,0.29,0.47680414,0.29333332,0.47680414,0.29666665,0.47680414,0.3,0.47680414,0.30333334,0.47680414,0.30666667,0.47680414,0.31,0.47680414,0.31333333,0.47680414,0.31666666,0.47680414,0.32,0.47680414,0.32333332,0.47680414,0.32666665,0.47680414,0.33,0.47680414,0.33333334,0.47680414,0.33666667,0.47680414,0.34,0.47680414,0.38,0.47680414,0.38333333,0.47680414,0.38666666,0.47680414,0.39,0.47680414,0.39333335,0.47680414,0.39666668,0.47680414,0.4,0.47680414,0.40333334,0.47680414,0.40666667,0.47680414,0.55333334,0.47680414,0.5566667,0.47680414,0.56,0.47680414,0.56333333,0.47680414,0.56666666,0.47680414,0.57,0.47680414,0.5733333,0.47680414,0.57666665,0.47680414,0.58,0.47680414,0.5833333,0.47680414,0.58666664,0.47680414,0.59,0.47680414,0.68,0.47680414,0.68333334,0.47680414,0.68666667,0.47680414,0.69,0.47680414,0.6933333,0.47680414,0.69666666,0.47680414,0.8566667,0.47680414,0.86,0.47680414,0.86333334,0.47680414,0.8666667,0.47680414,0.87,0.47680414,0.87333333,0.47680414,0.87666667,0.47680414,0.88,0.47680414,0.8833333,0.47680414,0.88666666,0.47680414,0.89,0.47680414,0.8933333,0.47680414,0.89666665,0.47680414,0.9,0.47680414,0.9033333,0.47680414,0.9066667,0.47680414,0.91,0.47680414,0.91333336,0.47680414,0.9166667,0.47680414,0.11333334,0.47938144,0.11666667,0.47938144,0.12,0.47938144,0.123333335,0.47938144,0.12666667,0.47938144,0.13,0.47938144,0.13333334,0.47938144,0.13666667,0.47938144,0.26666668,0.47938144,0.27,0.47938144,0.27333334,0.47938144,0.27666667,0.47938144,0.28,0.47938144,0.28333333,0.47938144,0.28666666,0.47938144,0.29,0.47938144,0.29333332,0.47938144,0.29666665,0.47938144,0.3,0.47938144,0.30333334,0.47938144,0.30666667,0.47938144,0.31,0.47938144,0.31333333,0.47938144,0.31666666,0.47938144,0.32,0.47938144,0.32333332,0.47938144,0.32666665,0.47938144,0.33,0.47938144,0.33333334,0.47938144,0.33666667,0.47938144,0.34,0.47938144,0.37666667,0.47938144,0.38,0.47938144,0.38333333,0.47938144,0.38666666,0.47938144,0.39,0.47938144,0.39333335,0.47938144,0.39666668,0.47938144,0.4,0.47938144,0.40333334,0.47938144,0.40666667,0.47938144,0.55333334,0.47938144,0.5566667,0.47938144,0.56,0.47938144,0.56333333,0.47938144,0.56666666,0.47938144,0.57,0.47938144,0.5733333,0.47938144,0.57666665,0.47938144,0.58,0.47938144,0.5833333,0.47938144,0.58666664,0.47938144,0.59,0.47938144,0.5933333,0.47938144,0.5966667,0.47938144,0.6,0.47938144,0.6666667,0.47938144,0.67,0.47938144,0.67333335,0.47938144,0.6766667,0.47938144,0.68,0.47938144,0.68333334,0.47938144,0.68666667,0.47938144,0.69,0.47938144,0.6933333,0.47938144,0.8566667,0.47938144,0.86,0.47938144,0.86333334,0.47938144,0.8666667,0.47938144,0.87,0.47938144,0.87333333,0.47938144,0.87666667,0.47938144,0.88,0.47938144,0.8833333,0.47938144,0.88666666,0.47938144,0.89,0.47938144,0.8933333,0.47938144,0.89666665,0.47938144,0.9,0.47938144,0.9033333,0.47938144,0.9066667,0.47938144,0.91,0.47938144,0.91333336,0.47938144,0.9166667,0.47938144,0.11333334,0.48195878,0.11666667,0.48195878,0.12,0.48195878,0.123333335,0.48195878,0.12666667,0.48195878,0.13,0.48195878,0.13333334,0.48195878,0.13666667,0.48195878,0.26666668,0.48195878,0.27,0.48195878,0.27333334,0.48195878,0.27666667,0.48195878,0.28,0.48195878,0.28333333,0.48195878,0.28666666,0.48195878,0.29,0.48195878,0.29333332,0.48195878,0.29666665,0.48195878,0.3,0.48195878,0.30333334,0.48195878,0.30666667,0.48195878,0.31,0.48195878,0.31333333,0.48195878,0.31666666,0.48195878,0.32,0.48195878,0.32333332,0.48195878,0.32666665,0.48195878,0.33,0.48195878,0.33333334,0.48195878,0.33666667,0.48195878,0.34,0.48195878,0.37333333,0.48195878,0.37666667,0.48195878,0.38,0.48195878,0.38333333,0.48195878,0.38666666,0.48195878,0.39,0.48195878,0.39333335,0.48195878,0.39666668,0.48195878,0.4,0.48195878,0.40333334,0.48195878,0.40666667,0.48195878,0.55333334,0.48195878,0.5566667,0.48195878,0.56,0.48195878,0.56333333,0.48195878,0.56666666,0.48195878,0.57,0.48195878,0.5733333,0.48195878,0.57666665,0.48195878,0.58,0.48195878,0.5833333,0.48195878,0.58666664,0.48195878,0.59,0.48195878,0.5933333,0.48195878,0.5966667,0.48195878,0.6,0.48195878,0.60333335,0.48195878,0.6066667,0.48195878,0.61,0.48195878,0.6566667,0.48195878,0.66,0.48195878,0.66333336,0.48195878,0.6666667,0.48195878,0.67,0.48195878,0.67333335,0.48195878,0.6766667,0.48195878,0.68,0.48195878,0.68333334,0.48195878,0.68666667,0.48195878,0.69,0.48195878,0.6933333,0.48195878,0.8566667,0.48195878,0.86,0.48195878,0.86333334,0.48195878,0.8666667,0.48195878,0.87,0.48195878,0.87333333,0.48195878,0.87666667,0.48195878,0.88,0.48195878,0.8833333,0.48195878,0.88666666,0.48195878,0.89,0.48195878,0.8933333,0.48195878,0.89666665,0.48195878,0.9,0.48195878,0.9033333,0.48195878,0.9066667,0.48195878,0.91,0.48195878,0.91333336,0.48195878,0.9166667,0.48195878,0.11333334,0.48453608,0.11666667,0.48453608,0.12,0.48453608,0.123333335,0.48453608,0.12666667,0.48453608,0.13,0.48453608,0.13333334,0.48453608,0.13666667,0.48453608,0.26333332,0.48453608,0.26666668,0.48453608,0.27,0.48453608,0.27333334,0.48453608,0.27666667,0.48453608,0.28,0.48453608,0.28333333,0.48453608,0.28666666,0.48453608,0.29,0.48453608,0.29333332,0.48453608,0.29666665,0.48453608,0.3,0.48453608,0.30333334,0.48453608,0.30666667,0.48453608,0.31,0.48453608,0.31333333,0.48453608,0.31666666,0.48453608,0.32,0.48453608,0.32333332,0.48453608,0.32666665,0.48453608,0.33,0.48453608,0.33333334,0.48453608,0.33666667,0.48453608,0.34,0.48453608,0.37,0.48453608,0.37333333,0.48453608,0.37666667,0.48453608,0.38,0.48453608,0.38333333,0.48453608,0.38666666,0.48453608,0.39,0.48453608,0.39333335,0.48453608,0.39666668,0.48453608,0.4,0.48453608,0.40333334,0.48453608,0.40666667,0.48453608,0.55333334,0.48453608,0.5566667,0.48453608,0.56,0.48453608,0.56333333,0.48453608,0.56666666,0.48453608,0.57,0.48453608,0.5733333,0.48453608,0.57666665,0.48453608,0.58,0.48453608,0.5833333,0.48453608,0.58666664,0.48453608,0.59,0.48453608,0.5933333,0.48453608,0.5966667,0.48453608,0.6,0.48453608,0.60333335,0.48453608,0.6066667,0.48453608,0.61,0.48453608,0.61333334,0.48453608,0.6166667,0.48453608,0.65,0.48453608,0.6533333,0.48453608,0.6566667,0.48453608,0.66,0.48453608,0.66333336,0.48453608,0.6666667,0.48453608,0.67,0.48453608,0.67333335,0.48453608,0.6766667,0.48453608,0.68,0.48453608,0.68333334,0.48453608,0.68666667,0.48453608,0.69,0.48453608,0.6933333,0.48453608,0.8566667,0.48453608,0.86,0.48453608,0.86333334,0.48453608,0.8666667,0.48453608,0.87,0.48453608,0.87333333,0.48453608,0.87666667,0.48453608,0.88,0.48453608,0.8833333,0.48453608,0.88666666,0.48453608,0.89,0.48453608,0.8933333,0.48453608,0.89666665,0.48453608,0.9,0.48453608,0.9033333,0.48453608,0.9066667,0.48453608,0.91,0.48453608,0.91333336,0.48453608,0.11333334,0.48711342,0.11666667,0.48711342,0.12,0.48711342,0.123333335,0.48711342,0.12666667,0.48711342,0.13,0.48711342,0.13333334,0.48711342,0.13666667,0.48711342,0.26333332,0.48711342,0.26666668,0.48711342,0.27,0.48711342,0.27333334,0.48711342,0.27666667,0.48711342,0.28,0.48711342,0.28333333,0.48711342,0.28666666,0.48711342,0.29,0.48711342,0.29333332,0.48711342,0.29666665,0.48711342,0.3,0.48711342,0.30333334,0.48711342,0.30666667,0.48711342,0.31,0.48711342,0.31333333,0.48711342,0.31666666,0.48711342,0.32,0.48711342,0.32333332,0.48711342,0.32666665,0.48711342,0.33,0.48711342,0.33333334,0.48711342,0.33666667,0.48711342,0.36666667,0.48711342,0.37,0.48711342,0.37333333,0.48711342,0.37666667,0.48711342,0.38,0.48711342,0.38333333,0.48711342,0.38666666,0.48711342,0.39,0.48711342,0.39333335,0.48711342,0.39666668,0.48711342,0.4,0.48711342,0.40333334,0.48711342,0.40666667,0.48711342,0.55333334,0.48711342,0.5566667,0.48711342,0.56,0.48711342,0.56333333,0.48711342,0.56666666,0.48711342,0.57,0.48711342,0.5733333,0.48711342,0.57666665,0.48711342,0.58,0.48711342,0.5833333,0.48711342,0.58666664,0.48711342,0.59,0.48711342,0.5933333,0.48711342,0.5966667,0.48711342,0.6,0.48711342,0.60333335,0.48711342,0.6066667,0.48711342,0.61,0.48711342,0.61333334,0.48711342,0.6166667,0.48711342,0.62,0.48711342,0.64666665,0.48711342,0.65,0.48711342,0.6533333,0.48711342,0.6566667,0.48711342,0.66,0.48711342,0.66333336,0.48711342,0.6666667,0.48711342,0.67,0.48711342,0.67333335,0.48711342,0.6766667,0.48711342,0.68,0.48711342,0.68333334,0.48711342,0.68666667,0.48711342,0.69,0.48711342,0.6933333,0.48711342,0.85333335,0.48711342,0.8566667,0.48711342,0.86,0.48711342,0.86333334,0.48711342,0.8666667,0.48711342,0.88666666,0.48711342,0.89,0.48711342,0.8933333,0.48711342,0.89666665,0.48711342,0.9,0.48711342,0.9033333,0.48711342,0.9066667,0.48711342,0.91,0.48711342,0.10666667,0.48969072,0.11,0.48969072,0.11333334,0.48969072,0.11666667,0.48969072,0.12,0.48969072,0.123333335,0.48969072,0.12666667,0.48969072,0.13,0.48969072,0.13333334,0.48969072,0.13666667,0.48969072,0.14,0.48969072,0.26333332,0.48969072,0.26666668,0.48969072,0.27,0.48969072,0.27333334,0.48969072,0.27666667,0.48969072,0.28,0.48969072,0.28333333,0.48969072,0.28666666,0.48969072,0.29,0.48969072,0.29333332,0.48969072,0.29666665,0.48969072,0.3,0.48969072,0.30333334,0.48969072,0.30666667,0.48969072,0.31,0.48969072,0.31333333,0.48969072,0.31666666,0.48969072,0.32,0.48969072,0.32333332,0.48969072,0.32666665,0.48969072,0.33,0.48969072,0.33333334,0.48969072,0.36333334,0.48969072,0.36666667,0.48969072,0.37,0.48969072,0.37333333,0.48969072,0.37666667,0.48969072,0.38,0.48969072,0.38333333,0.48969072,0.38666666,0.48969072,0.39,0.48969072,0.39333335,0.48969072,0.39666668,0.48969072,0.4,0.48969072,0.40333334,0.48969072,0.40666667,0.48969072,0.55333334,0.48969072,0.5566667,0.48969072,0.56,0.48969072,0.56333333,0.48969072,0.56666666,0.48969072,0.57,0.48969072,0.5733333,0.48969072,0.57666665,0.48969072,0.58,0.48969072,0.5833333,0.48969072,0.58666664,0.48969072,0.59,0.48969072,0.5933333,0.48969072,0.5966667,0.48969072,0.6,0.48969072,0.60333335,0.48969072,0.6066667,0.48969072,0.61,0.48969072,0.61333334,0.48969072,0.6166667,0.48969072,0.62,0.48969072,0.6433333,0.48969072,0.64666665,0.48969072,0.65,0.48969072,0.6533333,0.48969072,0.6566667,0.48969072,0.66,0.48969072,0.66333336,0.48969072,0.6666667,0.48969072,0.67,0.48969072,0.67333335,0.48969072,0.6766667,0.48969072,0.68,0.48969072,0.68333334,0.48969072,0.68666667,0.48969072,0.69,0.48969072,0.8566667,0.48969072,0.86,0.48969072,0.86333334,0.48969072,0.89666665,0.48969072,0.9,0.48969072,0.9033333,0.48969072,0.10333333,0.49226806,0.10666667,0.49226806,0.11,0.49226806,0.11333334,0.49226806,0.11666667,0.49226806,0.12,0.49226806,0.123333335,0.49226806,0.12666667,0.49226806,0.13,0.49226806,0.13333334,0.49226806,0.13666667,0.49226806,0.14,0.49226806,0.26333332,0.49226806,0.26666668,0.49226806,0.27,0.49226806,0.27333334,0.49226806,0.27666667,0.49226806,0.28,0.49226806,0.28333333,0.49226806,0.28666666,0.49226806,0.29,0.49226806,0.29333332,0.49226806,0.29666665,0.49226806,0.3,0.49226806,0.30333334,0.49226806,0.30666667,0.49226806,0.31,0.49226806,0.31333333,0.49226806,0.31666666,0.49226806,0.32,0.49226806,0.32333332,0.49226806,0.32666665,0.49226806,0.33,0.49226806,0.36,0.49226806,0.36333334,0.49226806,0.36666667,0.49226806,0.37,0.49226806,0.37333333,0.49226806,0.37666667,0.49226806,0.38,0.49226806,0.38333333,0.49226806,0.38666666,0.49226806,0.39,0.49226806,0.39333335,0.49226806,0.39666668,0.49226806,0.4,0.49226806,0.40333334,0.49226806,0.40666667,0.49226806,0.55333334,0.49226806,0.5566667,0.49226806,0.56,0.49226806,0.56333333,0.49226806,0.56666666,0.49226806,0.57,0.49226806,0.5733333,0.49226806,0.57666665,0.49226806,0.58,0.49226806,0.5833333,0.49226806,0.58666664,0.49226806,0.59,0.49226806,0.5933333,0.49226806,0.5966667,0.49226806,0.6,0.49226806,0.60333335,0.49226806,0.6066667,0.49226806,0.61,0.49226806,0.61333334,0.49226806,0.6166667,0.49226806,0.62,0.49226806,0.62333333,0.49226806,0.6433333,0.49226806,0.64666665,0.49226806,0.65,0.49226806,0.6533333,0.49226806,0.6566667,0.49226806,0.66,0.49226806,0.66333336,0.49226806,0.6666667,0.49226806,0.67,0.49226806,0.67333335,0.49226806,0.6766667,0.49226806,0.68,0.49226806,0.68333334,0.49226806,0.68666667,0.49226806,0.69,0.49226806,0.85333335,0.49226806,0.8566667,0.49226806,0.86,0.49226806,0.86333334,0.49226806,0.1,0.49484536,0.10333333,0.49484536,0.10666667,0.49484536,0.11,0.49484536,0.11333334,0.49484536,0.11666667,0.49484536,0.12,0.49484536,0.123333335,0.49484536,0.12666667,0.49484536,0.13,0.49484536,0.13333334,0.49484536,0.13666667,0.49484536,0.14,0.49484536,0.26333332,0.49484536,0.26666668,0.49484536,0.27,0.49484536,0.27333334,0.49484536,0.27666667,0.49484536,0.28,0.49484536,0.28333333,0.49484536,0.28666666,0.49484536,0.29,0.49484536,0.29333332,0.49484536,0.29666665,0.49484536,0.3,0.49484536,0.30333334,0.49484536,0.30666667,0.49484536,0.31,0.49484536,0.31333333,0.49484536,0.35666665,0.49484536,0.36,0.49484536,0.36333334,0.49484536,0.36666667,0.49484536,0.37,0.49484536,0.37333333,0.49484536,0.37666667,0.49484536,0.38,0.49484536,0.38333333,0.49484536,0.38666666,0.49484536,0.39,0.49484536,0.39333335,0.49484536,0.39666668,0.49484536,0.4,0.49484536,0.40333334,0.49484536,0.40666667,0.49484536,0.55333334,0.49484536,0.5566667,0.49484536,0.56,0.49484536,0.56333333,0.49484536,0.56666666,0.49484536,0.57,0.49484536,0.5733333,0.49484536,0.57666665,0.49484536,0.58,0.49484536,0.5833333,0.49484536,0.58666664,0.49484536,0.59,0.49484536,0.5933333,0.49484536,0.5966667,0.49484536,0.6,0.49484536,0.60333335,0.49484536,0.6066667,0.49484536,0.61,0.49484536,0.61333334,0.49484536,0.6166667,0.49484536,0.62,0.49484536,0.62333333,0.49484536,0.6433333,0.49484536,0.64666665,0.49484536,0.65,0.49484536,0.6533333,0.49484536,0.6566667,0.49484536,0.66,0.49484536,0.66333336,0.49484536,0.6666667,0.49484536,0.67,0.49484536,0.67333335,0.49484536,0.6766667,0.49484536,0.68,0.49484536,0.68333334,0.49484536,0.68666667,0.49484536,0.69,0.49484536,0.85333335,0.49484536,0.8566667,0.49484536,0.86,0.49484536,0.86333334,0.49484536,0.09,0.4974227,0.093333334,0.4974227,0.096666664,0.4974227,0.1,0.4974227,0.10333333,0.4974227,0.10666667,0.4974227,0.11,0.4974227,0.11333334,0.4974227,0.11666667,0.4974227,0.12,0.4974227,0.123333335,0.4974227,0.12666667,0.4974227,0.13,0.4974227,0.13333334,0.4974227,0.13666667,0.4974227,0.14,0.4974227,0.26333332,0.4974227,0.26666668,0.4974227,0.27,0.4974227,0.27333334,0.4974227,0.27666667,0.4974227,0.28,0.4974227,0.28333333,0.4974227,0.28666666,0.4974227,0.29,0.4974227,0.29333332,0.4974227,0.29666665,0.4974227,0.3,0.4974227,0.30333334,0.4974227,0.35333332,0.4974227,0.35666665,0.4974227,0.36,0.4974227,0.36333334,0.4974227,0.36666667,0.4974227,0.37,0.4974227,0.37333333,0.4974227,0.37666667,0.4974227,0.38,0.4974227,0.38333333,0.4974227,0.38666666,0.4974227,0.39,0.4974227,0.39333335,0.4974227,0.39666668,0.4974227,0.4,0.4974227,0.40333334,0.4974227,0.40666667,0.4974227,0.55333334,0.4974227,0.5566667,0.4974227,0.56,0.4974227,0.56333333,0.4974227,0.56666666,0.4974227,0.57,0.4974227,0.5733333,0.4974227,0.57666665,0.4974227,0.58,0.4974227,0.5833333,0.4974227,0.58666664,0.4974227,0.59,0.4974227,0.5933333,0.4974227,0.5966667,0.4974227,0.6,0.4974227,0.60333335,0.4974227,0.6066667,0.4974227,0.61,0.4974227,0.61333334,0.4974227,0.6166667,0.4974227,0.62,0.4974227,0.62333333,0.4974227,0.6433333,0.4974227,0.64666665,0.4974227,0.65,0.4974227,0.6533333,0.4974227,0.6566667,0.4974227,0.66,0.4974227,0.66333336,0.4974227,0.6666667,0.4974227,0.67,0.4974227,0.67333335,0.4974227,0.6766667,0.4974227,0.68,0.4974227,0.68333334,0.4974227,0.68666667,0.4974227,0.85333335,0.4974227,0.8566667,0.4974227,0.86,0.4974227,0.083333336,0.5,0.086666666,0.5,0.09,0.5,0.093333334,0.5,0.096666664,0.5,0.1,0.5,0.10333333,0.5,0.10666667,0.5,0.11,0.5,0.11333334,0.5,0.11666667,0.5,0.12,0.5,0.123333335,0.5,0.12666667,0.5,0.13,0.5,0.13333334,0.5,0.13666667,0.5,0.14,0.5,0.26333332,0.5,0.26666668,0.5,0.27,0.5,0.27333334,0.5,0.27666667,0.5,0.28,0.5,0.28333333,0.5,0.28666666,0.5,0.29,0.5,0.29333332,0.5,0.29666665,0.5,0.3,0.5,0.35333332,0.5,0.35666665,0.5,0.36,0.5,0.36333334,0.5,0.36666667,0.5,0.37,0.5,0.37333333,0.5,0.37666667,0.5,0.38,0.5,0.38333333,0.5,0.38666666,0.5,0.39,0.5,0.39333335,0.5,0.39666668,0.5,0.4,0.5,0.40333334,0.5,0.40666667,0.5,0.55333334,0.5,0.5566667,0.5,0.56,0.5,0.56333333,0.5,0.56666666,0.5,0.57,0.5,0.5733333,0.5,0.57666665,0.5,0.58,0.5,0.5833333,0.5,0.58666664,0.5,0.59,0.5,0.5933333,0.5,0.5966667,0.5,0.6,0.5,0.60333335,0.5,0.6066667,0.5,0.61,0.5,0.61333334,0.5,0.6166667,0.5,0.62,0.5,0.64666665,0.5,0.65,0.5,0.6533333,0.5,0.6566667,0.5,0.66,0.5,0.66333336,0.5,0.6666667,0.5,0.67,0.5,0.67333335,0.5,0.6766667,0.5,0.68,0.5,0.68333334,0.5,0.68666667,0.5,0.85333335,0.5,0.8566667,0.5,0.86,0.5,0.86333334,0.5,0.07666667,0.5025773,0.08,0.5025773,0.083333336,0.5025773,0.086666666,0.5025773,0.09,0.5025773,0.093333334,0.5025773,0.096666664,0.5025773,0.1,0.5025773,0.10333333,0.5025773,0.10666667,0.5025773,0.11,0.5025773,0.11333334,0.5025773,0.11666667,0.5025773,0.12,0.5025773,0.123333335,0.5025773,0.12666667,0.5025773,0.13,0.5025773,0.13333334,0.5025773,0.13666667,0.5025773,0.14,0.5025773,0.26333332,0.5025773,0.26666668,0.5025773,0.27,0.5025773,0.27333334,0.5025773,0.27666667,0.5025773,0.28,0.5025773,0.28333333,0.5025773,0.28666666,0.5025773,0.29,0.5025773,0.29333332,0.5025773,0.29666665,0.5025773,0.3,0.5025773,0.35,0.5025773,0.35333332,0.5025773,0.35666665,0.5025773,0.36,0.5025773,0.36333334,0.5025773,0.36666667,0.5025773,0.37,0.5025773,0.37333333,0.5025773,0.37666667,0.5025773,0.38,0.5025773,0.38333333,0.5025773,0.38666666,0.5025773,0.39,0.5025773,0.39333335,0.5025773,0.39666668,0.5025773,0.4,0.5025773,0.40333334,0.5025773,0.40666667,0.5025773,0.41,0.5025773,0.41333333,0.5025773,0.41666666,0.5025773,0.42,0.5025773,0.42333335,0.5025773,0.42666668,0.5025773,0.43,0.5025773,0.43333334,0.5025773,0.43666667,0.5025773,0.44,0.5025773,0.44333333,0.5025773,0.44666666,0.5025773,0.45,0.5025773,0.45333335,0.5025773,0.45666668,0.5025773,0.46,0.5025773,0.46333334,0.5025773,0.46666667,0.5025773,0.47,0.5025773,0.47333333,0.5025773,0.47666666,0.5025773,0.48,0.5025773,0.48333332,0.5025773,0.48666668,0.5025773,0.49,0.5025773,0.49333334,0.5025773,0.49666667,0.5025773,0.5,0.5025773,0.50333333,0.5025773,0.50666666,0.5025773,0.51,0.5025773,0.5133333,0.5025773,0.51666665,0.5025773,0.52,0.5025773,0.5233333,0.5025773,0.55333334,0.5025773,0.5566667,0.5025773,0.56,0.5025773,0.56333333,0.5025773,0.56666666,0.5025773,0.57,0.5025773,0.5733333,0.5025773,0.57666665,0.5025773,0.58,0.5025773,0.5833333,0.5025773,0.58666664,0.5025773,0.59,0.5025773,0.5933333,0.5025773,0.5966667,0.5025773,0.6,0.5025773,0.60333335,0.5025773,0.6066667,0.5025773,0.61,0.5025773,0.61333334,0.5025773,0.6166667,0.5025773,0.62,0.5025773,0.65,0.5025773,0.6533333,0.5025773,0.6566667,0.5025773,0.66,0.5025773,0.66333336,0.5025773,0.6666667,0.5025773,0.67,0.5025773,0.67333335,0.5025773,0.6766667,0.5025773,0.68,0.5025773,0.68333334,0.5025773,0.68666667,0.5025773,0.69,0.5025773,0.6933333,0.5025773,0.85333335,0.5025773,0.8566667,0.5025773,0.86,0.5025773,0.86333334,0.5025773,0.07333333,0.5051546,0.07666667,0.5051546,0.08,0.5051546,0.083333336,0.5051546,0.086666666,0.5051546,0.09,0.5051546,0.093333334,0.5051546,0.096666664,0.5051546,0.1,0.5051546,0.10333333,0.5051546,0.10666667,0.5051546,0.11,0.5051546,0.11333334,0.5051546,0.11666667,0.5051546,0.12,0.5051546,0.123333335,0.5051546,0.12666667,0.5051546,0.13,0.5051546,0.13333334,0.5051546,0.13666667,0.5051546,0.14,0.5051546,0.26333332,0.5051546,0.26666668,0.5051546,0.27,0.5051546,0.27333334,0.5051546,0.27666667,0.5051546,0.28,0.5051546,0.28333333,0.5051546,0.28666666,0.5051546,0.29,0.5051546,0.29333332,0.5051546,0.29666665,0.5051546,0.3,0.5051546,0.30333334,0.5051546,0.35,0.5051546,0.35333332,0.5051546,0.35666665,0.5051546,0.36,0.5051546,0.36333334,0.5051546,0.36666667,0.5051546,0.37,0.5051546,0.37333333,0.5051546,0.38666666,0.5051546,0.39,0.5051546,0.39333335,0.5051546,0.39666668,0.5051546,0.4,0.5051546,0.40333334,0.5051546,0.40666667,0.5051546,0.41,0.5051546,0.41333333,0.5051546,0.41666666,0.5051546,0.42,0.5051546,0.42333335,0.5051546,0.42666668,0.5051546,0.43,0.5051546,0.43333334,0.5051546,0.43666667,0.5051546,0.44,0.5051546,0.44333333,0.5051546,0.44666666,0.5051546,0.45,0.5051546,0.45333335,0.5051546,0.45666668,0.5051546,0.46,0.5051546,0.46333334,0.5051546,0.46666667,0.5051546,0.47,0.5051546,0.47333333,0.5051546,0.47666666,0.5051546,0.48,0.5051546,0.48333332,0.5051546,0.48666668,0.5051546,0.49,0.5051546,0.49333334,0.5051546,0.49666667,0.5051546,0.5,0.5051546,0.50333333,0.5051546,0.50666666,0.5051546,0.51,0.5051546,0.5133333,0.5051546,0.51666665,0.5051546,0.52,0.5051546,0.5233333,0.5051546,0.52666664,0.5051546,0.53,0.5051546,0.53333336,0.5051546,0.5366667,0.5051546,0.54,0.5051546,0.54333335,0.5051546,0.5466667,0.5051546,0.55,0.5051546,0.55333334,0.5051546,0.5566667,0.5051546,0.56,0.5051546,0.56333333,0.5051546,0.56666666,0.5051546,0.57,0.5051546,0.5733333,0.5051546,0.57666665,0.5051546,0.58666664,0.5051546,0.59,0.5051546,0.5933333,0.5051546,0.5966667,0.5051546,0.6,0.5051546,0.60333335,0.5051546,0.6066667,0.5051546,0.61,0.5051546,0.61333334,0.5051546,0.6766667,0.5051546,0.68,0.5051546,0.68333334,0.5051546,0.68666667,0.5051546,0.69,0.5051546,0.6933333,0.5051546,0.69666666,0.5051546,0.85333335,0.5051546,0.8566667,0.5051546,0.86,0.5051546,0.86333334,0.5051546,0.8666667,0.5051546,0.87,0.5051546,0.07,0.507732,0.07333333,0.507732,0.07666667,0.507732,0.08,0.507732,0.083333336,0.507732,0.086666666,0.507732,0.09,0.507732,0.093333334,0.507732,0.096666664,0.507732,0.1,0.507732,0.10333333,0.507732,0.10666667,0.507732,0.11,0.507732,0.11333334,0.507732,0.11666667,0.507732,0.12,0.507732,0.123333335,0.507732,0.12666667,0.507732,0.13,0.507732,0.13333334,0.507732,0.13666667,0.507732,0.14,0.507732,0.26,0.507732,0.26333332,0.507732,0.26666668,0.507732,0.27,0.507732,0.27333334,0.507732,0.27666667,0.507732,0.28,0.507732,0.28333333,0.507732,0.28666666,0.507732,0.29,0.507732,0.29333332,0.507732,0.29666665,0.507732,0.3,0.507732,0.30333334,0.507732,0.35333332,0.507732,0.35666665,0.507732,0.36,0.507732,0.36333334,0.507732,0.36666667,0.507732,0.39,0.507732,0.39333335,0.507732,0.39666668,0.507732,0.4,0.507732,0.40333334,0.507732,0.40666667,0.507732,0.41,0.507732,0.41333333,0.507732,0.41666666,0.507732,0.42,0.507732,0.42333335,0.507732,0.42666668,0.507732,0.43,0.507732,0.43333334,0.507732,0.43666667,0.507732,0.44,0.507732,0.44333333,0.507732,0.44666666,0.507732,0.45,0.507732,0.45333335,0.507732,0.45666668,0.507732,0.46,0.507732,0.46333334,0.507732,0.46666667,0.507732,0.47,0.507732,0.47333333,0.507732,0.47666666,0.507732,0.48,0.507732,0.48333332,0.507732,0.48666668,0.507732,0.49,0.507732,0.49333334,0.507732,0.49666667,0.507732,0.5,0.507732,0.50333333,0.507732,0.50666666,0.507732,0.51,0.507732,0.5133333,0.507732,0.51666665,0.507732,0.52,0.507732,0.5233333,0.507732,0.52666664,0.507732,0.53,0.507732,0.53333336,0.507732,0.5366667,0.507732,0.54,0.507732,0.54333335,0.507732,0.5466667,0.507732,0.55,0.507732,0.55333334,0.507732,0.5566667,0.507732,0.56,0.507732,0.56333333,0.507732,0.56666666,0.507732,0.57,0.507732,0.68,0.507732,0.68333334,0.507732,0.68666667,0.507732,0.69,0.507732,0.6933333,0.507732,0.85333335,0.507732,0.8566667,0.507732,0.86,0.507732,0.86333334,0.507732,0.8666667,0.507732,0.87,0.507732,0.87333333,0.507732,0.07,0.5103093,0.07333333,0.5103093,0.07666667,0.5103093,0.08,0.5103093,0.083333336,0.5103093,0.086666666,0.5103093,0.09,0.5103093,0.093333334,0.5103093,0.096666664,0.5103093,0.1,0.5103093,0.10333333,0.5103093,0.10666667,0.5103093,0.11,0.5103093,0.11333334,0.5103093,0.11666667,0.5103093,0.12,0.5103093,0.123333335,0.5103093,0.12666667,0.5103093,0.13,0.5103093,0.13333334,0.5103093,0.13666667,0.5103093,0.14,0.5103093,0.14333333,0.5103093,0.25666666,0.5103093,0.26,0.5103093,0.26333332,0.5103093,0.26666668,0.5103093,0.27,0.5103093,0.27333334,0.5103093,0.27666667,0.5103093,0.28,0.5103093,0.28333333,0.5103093,0.28666666,0.5103093,0.29,0.5103093,0.29333332,0.5103093,0.29666665,0.5103093,0.3,0.5103093,0.30333334,0.5103093,0.30666667,0.5103093,0.39333335,0.5103093,0.39666668,0.5103093,0.4,0.5103093,0.40333334,0.5103093,0.40666667,0.5103093,0.41,0.5103093,0.41333333,0.5103093,0.41666666,0.5103093,0.42,0.5103093,0.42333335,0.5103093,0.42666668,0.5103093,0.43,0.5103093,0.43333334,0.5103093,0.43666667,0.5103093,0.44,0.5103093,0.44333333,0.5103093,0.44666666,0.5103093,0.45,0.5103093,0.45333335,0.5103093,0.45666668,0.5103093,0.46,0.5103093,0.46333334,0.5103093,0.46666667,0.5103093,0.47,0.5103093,0.47333333,0.5103093,0.47666666,0.5103093,0.48,0.5103093,0.48333332,0.5103093,0.48666668,0.5103093,0.49,0.5103093,0.49333334,0.5103093,0.49666667,0.5103093,0.5,0.5103093,0.50333333,0.5103093,0.50666666,0.5103093,0.51,0.5103093,0.5133333,0.5103093,0.51666665,0.5103093,0.52,0.5103093,0.5233333,0.5103093,0.52666664,0.5103093,0.53,0.5103093,0.53333336,0.5103093,0.5366667,0.5103093,0.54,0.5103093,0.54333335,0.5103093,0.5466667,0.5103093,0.55,0.5103093,0.55333334,0.5103093,0.5566667,0.5103093,0.56,0.5103093,0.56333333,0.5103093,0.56666666,0.5103093,0.57,0.5103093,0.68,0.5103093,0.68333334,0.5103093,0.68666667,0.5103093,0.69,0.5103093,0.6933333,0.5103093,0.7366667,0.5103093,0.74,0.5103093,0.74333334,0.5103093,0.8433333,0.5103093,0.8466667,0.5103093,0.85,0.5103093,0.85333335,0.5103093,0.8566667,0.5103093,0.86,0.5103093,0.86333334,0.5103093,0.8666667,0.5103093,0.87,0.5103093,0.87333333,0.5103093,0.87666667,0.5103093,0.06666667,0.5128866,0.07,0.5128866,0.07333333,0.5128866,0.07666667,0.5128866,0.08,0.5128866,0.083333336,0.5128866,0.086666666,0.5128866,0.09,0.5128866,0.093333334,0.5128866,0.096666664,0.5128866,0.1,0.5128866,0.10333333,0.5128866,0.10666667,0.5128866,0.11,0.5128866,0.11333334,0.5128866,0.11666667,0.5128866,0.12,0.5128866,0.123333335,0.5128866,0.12666667,0.5128866,0.13,0.5128866,0.13333334,0.5128866,0.13666667,0.5128866,0.14,0.5128866,0.14333333,0.5128866,0.24666667,0.5128866,0.25,0.5128866,0.25333333,0.5128866,0.25666666,0.5128866,0.26,0.5128866,0.26333332,0.5128866,0.26666668,0.5128866,0.27,0.5128866,0.27333334,0.5128866,0.27666667,0.5128866,0.28,0.5128866,0.28333333,0.5128866,0.28666666,0.5128866,0.29,0.5128866,0.29333332,0.5128866,0.29666665,0.5128866,0.3,0.5128866,0.30333334,0.5128866,0.30666667,0.5128866,0.31,0.5128866,0.39333335,0.5128866,0.39666668,0.5128866,0.4,0.5128866,0.40333334,0.5128866,0.40666667,0.5128866,0.41,0.5128866,0.41333333,0.5128866,0.41666666,0.5128866,0.42,0.5128866,0.42333335,0.5128866,0.42666668,0.5128866,0.43,0.5128866,0.43333334,0.5128866,0.43666667,0.5128866,0.44,0.5128866,0.44333333,0.5128866,0.44666666,0.5128866,0.45,0.5128866,0.45333335,0.5128866,0.45666668,0.5128866,0.46,0.5128866,0.46333334,0.5128866,0.46666667,0.5128866,0.47,0.5128866,0.47333333,0.5128866,0.47666666,0.5128866,0.48,0.5128866,0.48333332,0.5128866,0.48666668,0.5128866,0.49,0.5128866,0.49333334,0.5128866,0.49666667,0.5128866,0.5,0.5128866,0.50333333,0.5128866,0.50666666,0.5128866,0.51,0.5128866,0.5133333,0.5128866,0.51666665,0.5128866,0.52,0.5128866,0.5233333,0.5128866,0.52666664,0.5128866,0.53,0.5128866,0.53333336,0.5128866,0.5366667,0.5128866,0.54,0.5128866,0.54333335,0.5128866,0.5466667,0.5128866,0.55,0.5128866,0.55333334,0.5128866,0.5566667,0.5128866,0.56,0.5128866,0.56333333,0.5128866,0.56666666,0.5128866,0.68,0.5128866,0.68333334,0.5128866,0.68666667,0.5128866,0.69,0.5128866,0.6933333,0.5128866,0.73,0.5128866,0.73333335,0.5128866,0.7366667,0.5128866,0.74,0.5128866,0.74333334,0.5128866,0.74666667,0.5128866,0.82666665,0.5128866,0.83,0.5128866,0.8333333,0.5128866,0.83666664,0.5128866,0.84,0.5128866,0.8433333,0.5128866,0.8466667,0.5128866,0.85,0.5128866,0.85333335,0.5128866,0.8566667,0.5128866,0.86,0.5128866,0.86333334,0.5128866,0.8666667,0.5128866,0.87,0.5128866,0.87333333,0.5128866,0.87666667,0.5128866,0.88,0.5128866,0.06666667,0.5154639,0.07,0.5154639,0.07333333,0.5154639,0.07666667,0.5154639,0.08,0.5154639,0.083333336,0.5154639,0.086666666,0.5154639,0.09,0.5154639,0.093333334,0.5154639,0.096666664,0.5154639,0.1,0.5154639,0.10333333,0.5154639,0.10666667,0.5154639,0.11,0.5154639,0.11333334,0.5154639,0.11666667,0.5154639,0.12,0.5154639,0.13,0.5154639,0.13333334,0.5154639,0.13666667,0.5154639,0.14,0.5154639,0.14333333,0.5154639,0.23666666,0.5154639,0.24,0.5154639,0.24333334,0.5154639,0.24666667,0.5154639,0.25,0.5154639,0.25333333,0.5154639,0.25666666,0.5154639,0.26,0.5154639,0.26333332,0.5154639,0.26666668,0.5154639,0.27,0.5154639,0.27333334,0.5154639,0.27666667,0.5154639,0.28,0.5154639,0.28333333,0.5154639,0.28666666,0.5154639,0.29,0.5154639,0.29333332,0.5154639,0.29666665,0.5154639,0.3,0.5154639,0.30333334,0.5154639,0.30666667,0.5154639,0.31,0.5154639,0.39333335,0.5154639,0.39666668,0.5154639,0.4,0.5154639,0.40333334,0.5154639,0.40666667,0.5154639,0.41,0.5154639,0.41333333,0.5154639,0.41666666,0.5154639,0.42,0.5154639,0.42333335,0.5154639,0.42666668,0.5154639,0.43,0.5154639,0.43333334,0.5154639,0.43666667,0.5154639,0.44,0.5154639,0.44333333,0.5154639,0.44666666,0.5154639,0.45,0.5154639,0.45333335,0.5154639,0.45666668,0.5154639,0.46,0.5154639,0.46333334,0.5154639,0.46666667,0.5154639,0.47,0.5154639,0.47333333,0.5154639,0.47666666,0.5154639,0.48,0.5154639,0.48333332,0.5154639,0.48666668,0.5154639,0.49,0.5154639,0.49333334,0.5154639,0.49666667,0.5154639,0.5,0.5154639,0.50333333,0.5154639,0.50666666,0.5154639,0.51,0.5154639,0.5133333,0.5154639,0.51666665,0.5154639,0.52,0.5154639,0.5233333,0.5154639,0.52666664,0.5154639,0.53,0.5154639,0.53333336,0.5154639,0.5366667,0.5154639,0.54,0.5154639,0.54333335,0.5154639,0.5466667,0.5154639,0.55,0.5154639,0.55333334,0.5154639,0.5566667,0.5154639,0.56,0.5154639,0.56333333,0.5154639,0.56666666,0.5154639,0.68,0.5154639,0.68333334,0.5154639,0.68666667,0.5154639,0.69,0.5154639,0.6933333,0.5154639,0.69666666,0.5154639,0.72333336,0.5154639,0.7266667,0.5154639,0.73,0.5154639,0.73333335,0.5154639,0.7366667,0.5154639,0.74,0.5154639,0.74333334,0.5154639,0.74666667,0.5154639,0.7866667,0.5154639,0.79,0.5154639,0.79333335,0.5154639,0.7966667,0.5154639,0.8,0.5154639,0.80333334,0.5154639,0.8066667,0.5154639,0.81,0.5154639,0.81333333,0.5154639,0.81666666,0.5154639,0.82,0.5154639,0.8233333,0.5154639,0.82666665,0.5154639,0.83,0.5154639,0.8333333,0.5154639,0.83666664,0.5154639,0.84,0.5154639,0.8433333,0.5154639,0.8466667,0.5154639,0.85,0.5154639,0.85333335,0.5154639,0.8566667,0.5154639,0.86,0.5154639,0.86333334,0.5154639,0.8666667,0.5154639,0.87,0.5154639,0.87333333,0.5154639,0.87666667,0.5154639,0.88,0.5154639,0.06666667,0.51804125,0.07,0.51804125,0.07333333,0.51804125,0.07666667,0.51804125,0.08,0.51804125,0.083333336,0.51804125,0.086666666,0.51804125,0.09,0.51804125,0.093333334,0.51804125,0.096666664,0.51804125,0.1,0.51804125,0.10333333,0.51804125,0.10666667,0.51804125,0.11,0.51804125,0.11333334,0.51804125,0.13,0.51804125,0.13333334,0.51804125,0.13666667,0.51804125,0.14,0.51804125,0.14333333,0.51804125,0.14666666,0.51804125,0.15,0.51804125,0.15333334,0.51804125,0.15666667,0.51804125,0.16,0.51804125,0.16333333,0.51804125,0.22666667,0.51804125,0.23,0.51804125,0.23333333,0.51804125,0.23666666,0.51804125,0.24,0.51804125,0.24333334,0.51804125,0.24666667,0.51804125,0.25,0.51804125,0.25333333,0.51804125,0.25666666,0.51804125,0.26,0.51804125,0.26333332,0.51804125,0.26666668,0.51804125,0.27,0.51804125,0.27333334,0.51804125,0.27666667,0.51804125,0.28,0.51804125,0.28333333,0.51804125,0.28666666,0.51804125,0.29,0.51804125,0.29333332,0.51804125,0.29666665,0.51804125,0.3,0.51804125,0.30333334,0.51804125,0.30666667,0.51804125,0.31,0.51804125,0.39333335,0.51804125,0.39666668,0.51804125,0.4,0.51804125,0.40333334,0.51804125,0.40666667,0.51804125,0.41,0.51804125,0.41333333,0.51804125,0.42666668,0.51804125,0.43,0.51804125,0.43333334,0.51804125,0.43666667,0.51804125,0.44,0.51804125,0.44333333,0.51804125,0.44666666,0.51804125,0.45,0.51804125,0.45333335,0.51804125,0.45666668,0.51804125,0.46,0.51804125,0.46333334,0.51804125,0.46666667,0.51804125,0.47,0.51804125,0.47333333,0.51804125,0.47666666,0.51804125,0.48,0.51804125,0.48333332,0.51804125,0.48666668,0.51804125,0.49,0.51804125,0.49333334,0.51804125,0.49666667,0.51804125,0.5,0.51804125,0.50333333,0.51804125,0.50666666,0.51804125,0.51,0.51804125,0.5133333,0.51804125,0.51666665,0.51804125,0.52,0.51804125,0.5233333,0.51804125,0.52666664,0.51804125,0.53,0.51804125,0.53333336,0.51804125,0.5366667,0.51804125,0.54,0.51804125,0.54333335,0.51804125,0.5466667,0.51804125,0.55,0.51804125,0.55333334,0.51804125,0.5566667,0.51804125,0.56,0.51804125,0.56333333,0.51804125,0.56666666,0.51804125,0.6766667,0.51804125,0.68,0.51804125,0.68333334,0.51804125,0.68666667,0.51804125,0.69,0.51804125,0.6933333,0.51804125,0.69666666,0.51804125,0.7,0.51804125,0.7033333,0.51804125,0.70666665,0.51804125,0.71,0.51804125,0.7133333,0.51804125,0.71666664,0.51804125,0.72,0.51804125,0.72333336,0.51804125,0.7266667,0.51804125,0.73,0.51804125,0.73333335,0.51804125,0.7366667,0.51804125,0.74,0.51804125,0.74333334,0.51804125,0.74666667,0.51804125,0.78,0.51804125,0.78333336,0.51804125,0.7866667,0.51804125,0.79,0.51804125,0.79333335,0.51804125,0.7966667,0.51804125,0.8,0.51804125,0.80333334,0.51804125,0.8066667,0.51804125,0.81,0.51804125,0.81333333,0.51804125,0.81666666,0.51804125,0.82,0.51804125,0.8233333,0.51804125,0.82666665,0.51804125,0.83,0.51804125,0.8333333,0.51804125,0.83666664,0.51804125,0.84,0.51804125,0.8433333,0.51804125,0.8466667,0.51804125,0.85,0.51804125,0.85333335,0.51804125,0.8566667,0.51804125,0.86,0.51804125,0.86333334,0.51804125,0.8666667,0.51804125,0.87,0.51804125,0.87333333,0.51804125,0.87666667,0.51804125,0.88,0.51804125,0.8833333,0.51804125,0.06666667,0.52061856,0.07,0.52061856,0.07333333,0.52061856,0.07666667,0.52061856,0.08,0.52061856,0.083333336,0.52061856,0.086666666,0.52061856,0.09,0.52061856,0.093333334,0.52061856,0.096666664,0.52061856,0.1,0.52061856,0.10333333,0.52061856,0.10666667,0.52061856,0.13,0.52061856,0.13333334,0.52061856,0.13666667,0.52061856,0.14,0.52061856,0.14333333,0.52061856,0.14666666,0.52061856,0.15,0.52061856,0.15333334,0.52061856,0.15666667,0.52061856,0.16,0.52061856,0.16333333,0.52061856,0.16666667,0.52061856,0.17,0.52061856,0.17333333,0.52061856,0.17666666,0.52061856,0.18,0.52061856,0.18333334,0.52061856,0.18666667,0.52061856,0.19,0.52061856,0.19333333,0.52061856,0.19666667,0.52061856,0.2,0.52061856,0.20333333,0.52061856,0.20666666,0.52061856,0.21,0.52061856,0.21333334,0.52061856,0.21666667,0.52061856,0.22,0.52061856,0.22333333,0.52061856,0.22666667,0.52061856,0.23,0.52061856,0.23333333,0.52061856,0.23666666,0.52061856,0.24,0.52061856,0.24333334,0.52061856,0.24666667,0.52061856,0.25,0.52061856,0.25333333,0.52061856,0.25666666,0.52061856,0.26,0.52061856,0.26333332,0.52061856,0.26666668,0.52061856,0.28,0.52061856,0.28333333,0.52061856,0.28666666,0.52061856,0.29,0.52061856,0.29333332,0.52061856,0.29666665,0.52061856,0.3,0.52061856,0.30333334,0.52061856,0.30666667,0.52061856,0.31,0.52061856,0.31333333,0.52061856,0.39333335,0.52061856,0.39666668,0.52061856,0.4,0.52061856,0.40333334,0.52061856,0.40666667,0.52061856,0.41,0.52061856,0.43,0.52061856,0.43333334,0.52061856,0.43666667,0.52061856,0.44,0.52061856,0.44333333,0.52061856,0.44666666,0.52061856,0.45,0.52061856,0.45333335,0.52061856,0.45666668,0.52061856,0.46,0.52061856,0.48666668,0.52061856,0.49,0.52061856,0.49333334,0.52061856,0.49666667,0.52061856,0.5,0.52061856,0.50333333,0.52061856,0.50666666,0.52061856,0.51,0.52061856,0.5133333,0.52061856,0.51666665,0.52061856,0.52,0.52061856,0.5233333,0.52061856,0.52666664,0.52061856,0.53,0.52061856,0.53333336,0.52061856,0.5366667,0.52061856,0.54,0.52061856,0.54333335,0.52061856,0.5466667,0.52061856,0.55,0.52061856,0.55333334,0.52061856,0.5566667,0.52061856,0.56,0.52061856,0.56333333,0.52061856,0.56666666,0.52061856,0.57,0.52061856,0.67333335,0.52061856,0.6766667,0.52061856,0.68,0.52061856,0.68333334,0.52061856,0.68666667,0.52061856,0.69,0.52061856,0.6933333,0.52061856,0.69666666,0.52061856,0.7,0.52061856,0.7033333,0.52061856,0.70666665,0.52061856,0.71,0.52061856,0.7133333,0.52061856,0.71666664,0.52061856,0.72,0.52061856,0.72333336,0.52061856,0.7266667,0.52061856,0.74,0.52061856,0.74333334,0.52061856,0.74666667,0.52061856,0.75,0.52061856,0.75333333,0.52061856,0.75666666,0.52061856,0.76,0.52061856,0.7633333,0.52061856,0.76666665,0.52061856,0.77,0.52061856,0.7733333,0.52061856,0.77666664,0.52061856,0.78,0.52061856,0.78333336,0.52061856,0.7866667,0.52061856,0.79,0.52061856,0.79333335,0.52061856,0.7966667,0.52061856,0.8,0.52061856,0.80333334,0.52061856,0.8066667,0.52061856,0.81,0.52061856,0.81333333,0.52061856,0.81666666,0.52061856,0.82,0.52061856,0.8233333,0.52061856,0.82666665,0.52061856,0.83,0.52061856,0.8333333,0.52061856,0.83666664,0.52061856,0.84,0.52061856,0.8433333,0.52061856,0.8466667,0.52061856,0.85,0.52061856,0.85333335,0.52061856,0.8566667,0.52061856,0.86,0.52061856,0.86333334,0.52061856,0.8666667,0.52061856,0.87,0.52061856,0.87333333,0.52061856,0.87666667,0.52061856,0.88,0.52061856,0.8833333,0.52061856,0.07,0.52319586,0.07333333,0.52319586,0.07666667,0.52319586,0.08,0.52319586,0.083333336,0.52319586,0.086666666,0.52319586,0.09,0.52319586,0.093333334,0.52319586,0.096666664,0.52319586,0.1,0.52319586,0.13,0.52319586,0.13333334,0.52319586,0.13666667,0.52319586,0.14,0.52319586,0.14333333,0.52319586,0.14666666,0.52319586,0.15,0.52319586,0.15333334,0.52319586,0.15666667,0.52319586,0.16,0.52319586,0.16333333,0.52319586,0.16666667,0.52319586,0.17,0.52319586,0.17333333,0.52319586,0.17666666,0.52319586,0.18,0.52319586,0.18333334,0.52319586,0.18666667,0.52319586,0.19,0.52319586,0.19333333,0.52319586,0.19666667,0.52319586,0.2,0.52319586,0.20333333,0.52319586,0.20666666,0.52319586,0.21,0.52319586,0.21333334,0.52319586,0.21666667,0.52319586,0.22,0.52319586,0.22333333,0.52319586,0.22666667,0.52319586,0.23,0.52319586,0.23333333,0.52319586,0.23666666,0.52319586,0.24,0.52319586,0.24333334,0.52319586,0.24666667,0.52319586,0.25,0.52319586,0.25333333,0.52319586,0.25666666,0.52319586,0.26,0.52319586,0.26333332,0.52319586,0.26666668,0.52319586,0.28,0.52319586,0.28333333,0.52319586,0.28666666,0.52319586,0.29,0.52319586,0.29333332,0.52319586,0.29666665,0.52319586,0.3,0.52319586,0.30333334,0.52319586,0.30666667,0.52319586,0.31,0.52319586,0.31333333,0.52319586,0.39,0.52319586,0.39333335,0.52319586,0.39666668,0.52319586,0.4,0.52319586,0.40333334,0.52319586,0.40666667,0.52319586,0.43,0.52319586,0.43333334,0.52319586,0.43666667,0.52319586,0.44,0.52319586,0.44333333,0.52319586,0.44666666,0.52319586,0.45,0.52319586,0.45333335,0.52319586,0.45666668,0.52319586,0.49333334,0.52319586,0.49666667,0.52319586,0.5,0.52319586,0.50333333,0.52319586,0.50666666,0.52319586,0.51,0.52319586,0.5133333,0.52319586,0.51666665,0.52319586,0.52,0.52319586,0.54333335,0.52319586,0.5466667,0.52319586,0.55,0.52319586,0.55333334,0.52319586,0.5566667,0.52319586,0.56,0.52319586,0.56333333,0.52319586,0.56666666,0.52319586,0.57,0.52319586,0.67333335,0.52319586,0.6766667,0.52319586,0.68,0.52319586,0.68333334,0.52319586,0.68666667,0.52319586,0.69,0.52319586,0.6933333,0.52319586,0.69666666,0.52319586,0.7,0.52319586,0.7033333,0.52319586,0.70666665,0.52319586,0.71,0.52319586,0.7133333,0.52319586,0.71666664,0.52319586,0.72,0.52319586,0.72333336,0.52319586,0.74,0.52319586,0.74333334,0.52319586,0.74666667,0.52319586,0.75,0.52319586,0.75333333,0.52319586,0.75666666,0.52319586,0.76,0.52319586,0.7633333,0.52319586,0.76666665,0.52319586,0.77,0.52319586,0.7733333,0.52319586,0.77666664,0.52319586,0.78,0.52319586,0.78333336,0.52319586,0.7866667,0.52319586,0.79,0.52319586,0.79333335,0.52319586,0.7966667,0.52319586,0.8,0.52319586,0.80333334,0.52319586,0.8066667,0.52319586,0.81,0.52319586,0.81333333,0.52319586,0.8233333,0.52319586,0.82666665,0.52319586,0.83,0.52319586,0.8333333,0.52319586,0.83666664,0.52319586,0.84,0.52319586,0.8433333,0.52319586,0.8466667,0.52319586,0.85,0.52319586,0.85333335,0.52319586,0.8566667,0.52319586,0.86,0.52319586,0.86333334,0.52319586,0.8666667,0.52319586,0.87,0.52319586,0.87333333,0.52319586,0.87666667,0.52319586,0.88,0.52319586,0.8833333,0.52319586,0.07333333,0.52577317,0.07666667,0.52577317,0.08,0.52577317,0.083333336,0.52577317,0.086666666,0.52577317,0.09,0.52577317,0.093333334,0.52577317,0.13,0.52577317,0.13333334,0.52577317,0.13666667,0.52577317,0.14,0.52577317,0.14333333,0.52577317,0.14666666,0.52577317,0.15,0.52577317,0.15333334,0.52577317,0.15666667,0.52577317,0.16,0.52577317,0.16333333,0.52577317,0.16666667,0.52577317,0.17,0.52577317,0.17333333,0.52577317,0.17666666,0.52577317,0.18,0.52577317,0.18333334,0.52577317,0.18666667,0.52577317,0.19,0.52577317,0.19333333,0.52577317,0.19666667,0.52577317,0.2,0.52577317,0.20333333,0.52577317,0.20666666,0.52577317,0.21,0.52577317,0.21333334,0.52577317,0.21666667,0.52577317,0.22,0.52577317,0.22333333,0.52577317,0.22666667,0.52577317,0.23,0.52577317,0.23333333,0.52577317,0.23666666,0.52577317,0.24,0.52577317,0.24333334,0.52577317,0.24666667,0.52577317,0.25,0.52577317,0.25333333,0.52577317,0.25666666,0.52577317,0.26,0.52577317,0.26333332,0.52577317,0.28333333,0.52577317,0.28666666,0.52577317,0.29,0.52577317,0.29333332,0.52577317,0.29666665,0.52577317,0.3,0.52577317,0.30333334,0.52577317,0.30666667,0.52577317,0.31,0.52577317,0.31333333,0.52577317,0.39,0.52577317,0.39333335,0.52577317,0.39666668,0.52577317,0.4,0.52577317,0.40333334,0.52577317,0.40666667,0.52577317,0.43333334,0.52577317,0.43666667,0.52577317,0.44,0.52577317,0.44333333,0.52577317,0.44666666,0.52577317,0.45,0.52577317,0.45333335,0.52577317,0.45666668,0.52577317,0.49666667,0.52577317,0.5,0.52577317,0.50333333,0.52577317,0.50666666,0.52577317,0.51,0.52577317,0.5133333,0.52577317,0.51666665,0.52577317,0.54333335,0.52577317,0.5466667,0.52577317,0.55,0.52577317,0.55333334,0.52577317,0.5566667,0.52577317,0.56,0.52577317,0.56333333,0.52577317,0.56666666,0.52577317,0.57,0.52577317,0.5733333,0.52577317,0.67333335,0.52577317,0.6766667,0.52577317,0.68,0.52577317,0.68333334,0.52577317,0.68666667,0.52577317,0.69,0.52577317,0.6933333,0.52577317,0.69666666,0.52577317,0.7,0.52577317,0.7033333,0.52577317,0.70666665,0.52577317,0.71,0.52577317,0.7133333,0.52577317,0.71666664,0.52577317,0.72,0.52577317,0.7366667,0.52577317,0.74,0.52577317,0.74333334,0.52577317,0.74666667,0.52577317,0.75,0.52577317,0.75333333,0.52577317,0.75666666,0.52577317,0.76,0.52577317,0.7633333,0.52577317,0.76666665,0.52577317,0.77,0.52577317,0.7733333,0.52577317,0.77666664,0.52577317,0.78,0.52577317,0.78333336,0.52577317,0.7866667,0.52577317,0.79,0.52577317,0.79333335,0.52577317,0.7966667,0.52577317,0.8,0.52577317,0.80333334,0.52577317,0.8066667,0.52577317,0.81,0.52577317,0.8333333,0.52577317,0.83666664,0.52577317,0.84,0.52577317,0.8433333,0.52577317,0.8466667,0.52577317,0.85,0.52577317,0.85333335,0.52577317,0.8566667,0.52577317,0.86,0.52577317,0.86333334,0.52577317,0.8666667,0.52577317,0.87,0.52577317,0.87333333,0.52577317,0.87666667,0.52577317,0.88,0.52577317,0.8833333,0.52577317,0.07666667,0.52835053,0.08,0.52835053,0.083333336,0.52835053,0.086666666,0.52835053,0.12666667,0.52835053,0.13,0.52835053,0.13333334,0.52835053,0.13666667,0.52835053,0.14,0.52835053,0.14333333,0.52835053,0.14666666,0.52835053,0.15,0.52835053,0.15333334,0.52835053,0.15666667,0.52835053,0.16,0.52835053,0.16333333,0.52835053,0.16666667,0.52835053,0.17,0.52835053,0.17333333,0.52835053,0.17666666,0.52835053,0.18,0.52835053,0.18333334,0.52835053,0.18666667,0.52835053,0.19,0.52835053,0.19333333,0.52835053,0.19666667,0.52835053,0.2,0.52835053,0.20333333,0.52835053,0.20666666,0.52835053,0.21,0.52835053,0.21333334,0.52835053,0.21666667,0.52835053,0.22,0.52835053,0.22333333,0.52835053,0.22666667,0.52835053,0.23,0.52835053,0.23333333,0.52835053,0.23666666,0.52835053,0.24,0.52835053,0.24333334,0.52835053,0.24666667,0.52835053,0.25,0.52835053,0.25333333,0.52835053,0.25666666,0.52835053,0.26,0.52835053,0.26333332,0.52835053,0.26666668,0.52835053,0.28333333,0.52835053,0.28666666,0.52835053,0.29,0.52835053,0.29333332,0.52835053,0.29666665,0.52835053,0.3,0.52835053,0.30333334,0.52835053,0.30666667,0.52835053,0.31,0.52835053,0.39,0.52835053,0.39333335,0.52835053,0.39666668,0.52835053,0.4,0.52835053,0.40333334,0.52835053,0.43333334,0.52835053,0.43666667,0.52835053,0.44,0.52835053,0.44333333,0.52835053,0.44666666,0.52835053,0.45,0.52835053,0.45333335,0.52835053,0.5,0.52835053,0.50333333,0.52835053,0.50666666,0.52835053,0.51,0.52835053,0.5133333,0.52835053,0.51666665,0.52835053,0.5466667,0.52835053,0.55,0.52835053,0.55333334,0.52835053,0.5566667,0.52835053,0.56,0.52835053,0.56333333,0.52835053,0.56666666,0.52835053,0.57,0.52835053,0.5733333,0.52835053,0.67333335,0.52835053,0.6766667,0.52835053,0.68,0.52835053,0.68333334,0.52835053,0.68666667,0.52835053,0.69,0.52835053,0.6933333,0.52835053,0.69666666,0.52835053,0.7,0.52835053,0.7033333,0.52835053,0.70666665,0.52835053,0.71,0.52835053,0.7133333,0.52835053,0.71666664,0.52835053,0.7366667,0.52835053,0.74,0.52835053,0.74333334,0.52835053,0.74666667,0.52835053,0.75,0.52835053,0.75333333,0.52835053,0.75666666,0.52835053,0.76,0.52835053,0.7633333,0.52835053,0.77666664,0.52835053,0.78,0.52835053,0.78333336,0.52835053,0.7866667,0.52835053,0.79,0.52835053,0.79333335,0.52835053,0.7966667,0.52835053,0.8,0.52835053,0.80333334,0.52835053,0.8066667,0.52835053,0.83666664,0.52835053,0.84,0.52835053,0.8433333,0.52835053,0.8466667,0.52835053,0.85,0.52835053,0.85333335,0.52835053,0.8566667,0.52835053,0.86,0.52835053,0.86333334,0.52835053,0.8666667,0.52835053,0.87,0.52835053,0.87333333,0.52835053,0.87666667,0.52835053,0.88,0.52835053,0.8833333,0.52835053,0.12666667,0.53092784,0.13,0.53092784,0.13333334,0.53092784,0.13666667,0.53092784,0.14,0.53092784,0.14333333,0.53092784,0.14666666,0.53092784,0.15,0.53092784,0.15333334,0.53092784,0.15666667,0.53092784,0.16,0.53092784,0.16333333,0.53092784,0.16666667,0.53092784,0.17,0.53092784,0.17333333,0.53092784,0.17666666,0.53092784,0.18,0.53092784,0.18333334,0.53092784,0.18666667,0.53092784,0.19,0.53092784,0.19333333,0.53092784,0.19666667,0.53092784,0.2,0.53092784,0.20333333,0.53092784,0.20666666,0.53092784,0.21,0.53092784,0.21333334,0.53092784,0.21666667,0.53092784,0.22,0.53092784,0.23333333,0.53092784,0.23666666,0.53092784,0.24,0.53092784,0.24333334,0.53092784,0.24666667,0.53092784,0.25,0.53092784,0.25333333,0.53092784,0.25666666,0.53092784,0.26,0.53092784,0.26333332,0.53092784,0.28666666,0.53092784,0.29,0.53092784,0.29333332,0.53092784,0.29666665,0.53092784,0.3,0.53092784,0.30333334,0.53092784,0.30666667,0.53092784,0.31,0.53092784,0.39,0.53092784,0.39333335,0.53092784,0.39666668,0.53092784,0.4,0.53092784,0.40333334,0.53092784,0.43333334,0.53092784,0.43666667,0.53092784,0.44,0.53092784,0.44333333,0.53092784,0.44666666,0.53092784,0.45,0.53092784,0.45333335,0.53092784,0.5,0.53092784,0.50333333,0.53092784,0.50666666,0.53092784,0.51,0.53092784,0.5133333,0.53092784,0.51666665,0.53092784,0.55,0.53092784,0.55333334,0.53092784,0.5566667,0.53092784,0.56,0.53092784,0.56333333,0.53092784,0.56666666,0.53092784,0.57,0.53092784,0.5733333,0.53092784,0.57666665,0.53092784,0.6766667,0.53092784,0.68,0.53092784,0.68333334,0.53092784,0.68666667,0.53092784,0.69,0.53092784,0.6933333,0.53092784,0.69666666,0.53092784,0.7,0.53092784,0.7033333,0.53092784,0.70666665,0.53092784,0.71,0.53092784,0.7133333,0.53092784,0.73333335,0.53092784,0.7366667,0.53092784,0.74,0.53092784,0.74333334,0.53092784,0.74666667,0.53092784,0.75,0.53092784,0.75333333,0.53092784,0.75666666,0.53092784,0.76,0.53092784,0.78,0.53092784,0.78333336,0.53092784,0.7866667,0.53092784,0.79,0.53092784,0.79333335,0.53092784,0.7966667,0.53092784,0.8,0.53092784,0.80333334,0.53092784,0.8433333,0.53092784,0.8466667,0.53092784,0.85,0.53092784,0.85333335,0.53092784,0.8566667,0.53092784,0.86,0.53092784,0.86333334,0.53092784,0.8666667,0.53092784,0.87,0.53092784,0.87333333,0.53092784,0.87666667,0.53092784,0.88,0.53092784,0.123333335,0.53350514,0.12666667,0.53350514,0.13,0.53350514,0.13333334,0.53350514,0.13666667,0.53350514,0.14,0.53350514,0.14333333,0.53350514,0.14666666,0.53350514,0.15,0.53350514,0.15333334,0.53350514,0.15666667,0.53350514,0.16,0.53350514,0.16333333,0.53350514,0.16666667,0.53350514,0.17,0.53350514,0.17333333,0.53350514,0.17666666,0.53350514,0.18,0.53350514,0.18333334,0.53350514,0.18666667,0.53350514,0.19,0.53350514,0.19333333,0.53350514,0.19666667,0.53350514,0.2,0.53350514,0.20333333,0.53350514,0.20666666,0.53350514,0.21,0.53350514,0.21333334,0.53350514,0.21666667,0.53350514,0.23666666,0.53350514,0.24,0.53350514,0.24333334,0.53350514,0.24666667,0.53350514,0.25,0.53350514,0.25333333,0.53350514,0.25666666,0.53350514,0.26,0.53350514,0.26333332,0.53350514,0.29,0.53350514,0.29333332,0.53350514,0.29666665,0.53350514,0.3,0.53350514,0.30333334,0.53350514,0.39,0.53350514,0.39333335,0.53350514,0.39666668,0.53350514,0.4,0.53350514,0.43333334,0.53350514,0.43666667,0.53350514,0.44,0.53350514,0.44333333,0.53350514,0.44666666,0.53350514,0.45,0.53350514,0.50333333,0.53350514,0.50666666,0.53350514,0.51,0.53350514,0.5133333,0.53350514,0.55,0.53350514,0.55333334,0.53350514,0.5566667,0.53350514,0.56,0.53350514,0.56333333,0.53350514,0.56666666,0.53350514,0.57,0.53350514,0.5733333,0.53350514,0.57666665,0.53350514,0.68,0.53350514,0.68333334,0.53350514,0.68666667,0.53350514,0.69,0.53350514,0.6933333,0.53350514,0.69666666,0.53350514,0.7,0.53350514,0.7033333,0.53350514,0.70666665,0.53350514,0.71,0.53350514,0.73333335,0.53350514,0.7366667,0.53350514,0.74,0.53350514,0.74333334,0.53350514,0.74666667,0.53350514,0.75,0.53350514,0.75333333,0.53350514,0.75666666,0.53350514,0.76,0.53350514,0.78333336,0.53350514,0.7866667,0.53350514,0.79,0.53350514,0.79333335,0.53350514,0.7966667,0.53350514,0.8,0.53350514,0.80333334,0.53350514,0.85,0.53350514,0.85333335,0.53350514,0.8566667,0.53350514,0.86,0.53350514,0.86333334,0.53350514,0.8666667,0.53350514,0.87,0.53350514,0.87333333,0.53350514,0.87666667,0.53350514,0.123333335,0.53608245,0.12666667,0.53608245,0.13,0.53608245,0.13333334,0.53608245,0.13666667,0.53608245,0.14,0.53608245,0.14333333,0.53608245,0.14666666,0.53608245,0.15,0.53608245,0.15333334,0.53608245,0.15666667,0.53608245,0.17333333,0.53608245,0.17666666,0.53608245,0.18,0.53608245,0.18333334,0.53608245,0.18666667,0.53608245,0.19,0.53608245,0.19333333,0.53608245,0.19666667,0.53608245,0.2,0.53608245,0.20333333,0.53608245,0.20666666,0.53608245,0.21,0.53608245,0.21333334,0.53608245,0.23666666,0.53608245,0.24,0.53608245,0.24333334,0.53608245,0.24666667,0.53608245,0.25,0.53608245,0.25333333,0.53608245,0.25666666,0.53608245,0.26,0.53608245,0.26333332,0.53608245,0.29,0.53608245,0.29333332,0.53608245,0.29666665,0.53608245,0.3,0.53608245,0.43333334,0.53608245,0.43666667,0.53608245,0.44,0.53608245,0.44333333,0.53608245,0.44666666,0.53608245,0.45,0.53608245,0.55333334,0.53608245,0.5566667,0.53608245,0.56,0.53608245,0.56333333,0.53608245,0.56666666,0.53608245,0.57,0.53608245,0.5733333,0.53608245,0.57666665,0.53608245,0.68333334,0.53608245,0.68666667,0.53608245,0.69,0.53608245,0.6933333,0.53608245,0.69666666,0.53608245,0.7,0.53608245,0.7033333,0.53608245,0.70666665,0.53608245,0.71,0.53608245,0.73333335,0.53608245,0.7366667,0.53608245,0.74,0.53608245,0.74333334,0.53608245,0.74666667,0.53608245,0.75,0.53608245,0.75333333,0.53608245,0.75666666,0.53608245,0.7866667,0.53608245,0.79,0.53608245,0.79333335,0.53608245,0.7966667,0.53608245,0.8,0.53608245,0.8566667,0.53608245,0.86,0.53608245,0.86333334,0.53608245,0.8666667,0.53608245,0.87,0.53608245,0.87333333,0.53608245,0.12666667,0.5386598,0.13,0.5386598,0.13333334,0.5386598,0.13666667,0.5386598,0.14,0.5386598,0.14333333,0.5386598,0.14666666,0.5386598,0.15,0.5386598,0.17333333,0.5386598,0.17666666,0.5386598,0.18,0.5386598,0.18333334,0.5386598,0.18666667,0.5386598,0.19,0.5386598,0.19333333,0.5386598,0.19666667,0.5386598,0.2,0.5386598,0.20333333,0.5386598,0.20666666,0.5386598,0.21,0.5386598,0.24333334,0.5386598,0.24666667,0.5386598,0.25,0.5386598,0.25333333,0.5386598,0.25666666,0.5386598,0.26,0.5386598,0.26333332,0.5386598,0.43666667,0.5386598,0.44,0.5386598,0.44333333,0.5386598,0.5566667,0.5386598,0.56,0.5386598,0.56333333,0.5386598,0.56666666,0.5386598,0.57,0.5386598,0.5733333,0.5386598,0.57666665,0.5386598,0.69,0.5386598,0.6933333,0.5386598,0.69666666,0.5386598,0.7,0.5386598,0.7366667,0.5386598,0.74,0.5386598,0.74333334,0.5386598,0.74666667,0.5386598,0.75,0.5386598,0.75333333,0.5386598,0.79,0.5386598,0.79333335,0.5386598,0.7966667,0.5386598,0.86,0.5386598,0.86333334,0.5386598,0.8666667,0.5386598,0.13,0.5412371,0.13333334,0.5412371,0.13666667,0.5412371,0.14,0.5412371,0.17333333,0.5412371,0.17666666,0.5412371,0.18,0.5412371,0.18333334,0.5412371,0.18666667,0.5412371,0.19,0.5412371,0.19333333,0.5412371,0.19666667,0.5412371,0.2,0.5412371,0.20333333,0.5412371,0.20666666,0.5412371,0.24333334,0.5412371,0.24666667,0.5412371,0.25,0.5412371,0.25333333,0.5412371,0.25666666,0.5412371,0.26,0.5412371,0.26333332,0.5412371,0.56,0.5412371,0.56333333,0.5412371,0.56666666,0.5412371,0.57,0.5412371,0.5733333,0.5412371,0.57666665,0.5412371,0.17333333,0.5438144,0.17666666,0.5438144,0.18,0.5438144,0.18333334,0.5438144,0.18666667,0.5438144,0.19,0.5438144,0.19333333,0.5438144,0.19666667,0.5438144,0.2,0.5438144,0.20333333,0.5438144,0.25,0.5438144,0.25333333,0.5438144,0.25666666,0.5438144,0.26,0.5438144,0.56333333,0.5438144,0.56666666,0.5438144,0.57,0.5438144,0.17333333,0.5463917,0.17666666,0.5463917,0.18,0.5463917,0.18333334,0.5463917,0.18666667,0.5463917,0.19,0.5463917,0.19333333,0.5463917,0.19666667,0.5463917,0.2,0.5463917,0.50666666,0.5463917,0.51,0.5463917,0.5133333,0.5463917,0.51666665,0.5463917,0.52,0.5463917,0.5233333,0.5463917,0.52666664,0.5463917,0.53,0.5463917,0.53333336,0.5463917,0.17666666,0.5489691,0.18,0.5489691,0.18333334,0.5489691,0.18666667,0.5489691,0.19,0.5489691,0.19333333,0.5489691,0.19666667,0.5489691,0.50333333,0.5489691,0.50666666,0.5489691,0.51,0.5489691,0.5133333,0.5489691,0.51666665,0.5489691,0.52,0.5489691,0.5233333,0.5489691,0.52666664,0.5489691,0.53,0.5489691,0.53333336,0.5489691,0.5366667,0.5489691,0.17666666,0.5515464,0.18,0.5515464,0.18333334,0.5515464,0.18666667,0.5515464,0.19,0.5515464,0.5,0.5515464,0.50333333,0.5515464,0.50666666,0.5515464,0.51,0.5515464,0.5133333,0.5515464,0.51666665,0.5515464,0.52,0.5515464,0.5233333,0.5515464,0.52666664,0.5515464,0.53,0.5515464,0.53333336,0.5515464,0.5366667,0.5515464,0.54,0.5515464,0.72333336,0.5515464,0.7266667,0.5515464,0.49666667,0.5541237,0.5,0.5541237,0.50333333,0.5541237,0.50666666,0.5541237,0.51,0.5541237,0.5133333,0.5541237,0.51666665,0.5541237,0.52,0.5541237,0.5233333,0.5541237,0.52666664,0.5541237,0.53,0.5541237,0.53333336,0.5541237,0.5366667,0.5541237,0.54,0.5541237,0.54333335,0.5541237,0.7033333,0.5541237,0.70666665,0.5541237,0.71,0.5541237,0.7133333,0.5541237,0.71666664,0.5541237,0.72,0.5541237,0.72333336,0.5541237,0.7266667,0.5541237,0.73,0.5541237,0.73333335,0.5541237,0.7366667,0.5541237,0.74,0.5541237,0.74333334,0.5541237,0.49666667,0.556701,0.5,0.556701,0.50333333,0.556701,0.50666666,0.556701,0.51,0.556701,0.5133333,0.556701,0.51666665,0.556701,0.52,0.556701,0.5233333,0.556701,0.52666664,0.556701,0.53,0.556701,0.53333336,0.556701,0.5366667,0.556701,0.54,0.556701,0.54333335,0.556701,0.7,0.556701,0.7033333,0.556701,0.70666665,0.556701,0.71,0.556701,0.7133333,0.556701,0.71666664,0.556701,0.72,0.556701,0.72333336,0.556701,0.7266667,0.556701,0.73,0.556701,0.73333335,0.556701,0.7366667,0.556701,0.74,0.556701,0.74333334,0.556701,0.74666667,0.556701,0.43333334,0.55927837,0.43666667,0.55927837,0.44,0.55927837,0.44333333,0.55927837,0.49333334,0.55927837,0.49666667,0.55927837,0.5,0.55927837,0.50333333,0.55927837,0.50666666,0.55927837,0.51,0.55927837,0.5133333,0.55927837,0.51666665,0.55927837,0.52,0.55927837,0.5233333,0.55927837,0.52666664,0.55927837,0.53,0.55927837,0.53333336,0.55927837,0.5366667,0.55927837,0.54,0.55927837,0.54333335,0.55927837,0.7,0.55927837,0.7033333,0.55927837,0.70666665,0.55927837,0.71,0.55927837,0.7133333,0.55927837,0.71666664,0.55927837,0.72,0.55927837,0.72333336,0.55927837,0.7266667,0.55927837,0.73333335,0.55927837,0.7366667,0.55927837,0.74,0.55927837,0.74333334,0.55927837,0.74666667,0.55927837,0.75,0.55927837,0.80333334,0.55927837,0.8066667,0.55927837,0.81,0.55927837,0.81333333,0.55927837,0.81666666,0.55927837,0.82,0.55927837,0.8233333,0.55927837,0.43333334,0.5618557,0.43666667,0.5618557,0.44,0.5618557,0.44333333,0.5618557,0.44666666,0.5618557,0.49333334,0.5618557,0.49666667,0.5618557,0.5,0.5618557,0.50333333,0.5618557,0.50666666,0.5618557,0.51,0.5618557,0.5133333,0.5618557,0.51666665,0.5618557,0.52,0.5618557,0.5233333,0.5618557,0.52666664,0.5618557,0.53,0.5618557,0.53333336,0.5618557,0.5366667,0.5618557,0.54,0.5618557,0.7,0.5618557,0.7033333,0.5618557,0.70666665,0.5618557,0.71,0.5618557,0.7133333,0.5618557,0.71666664,0.5618557,0.72,0.5618557,0.72333336,0.5618557,0.7366667,0.5618557,0.74,0.5618557,0.74333334,0.5618557,0.74666667,0.5618557,0.75,0.5618557,0.75333333,0.5618557,0.7966667,0.5618557,0.8,0.5618557,0.80333334,0.5618557,0.8066667,0.5618557,0.81,0.5618557,0.81333333,0.5618557,0.81666666,0.5618557,0.82,0.5618557,0.8233333,0.5618557,0.82666665,0.5618557,0.43333334,0.564433,0.43666667,0.564433,0.44,0.564433,0.44333333,0.564433,0.44666666,0.564433,0.45,0.564433,0.49333334,0.564433,0.49666667,0.564433,0.5,0.564433,0.50333333,0.564433,0.50666666,0.564433,0.51,0.564433,0.5133333,0.564433,0.51666665,0.564433,0.52,0.564433,0.5233333,0.564433,0.52666664,0.564433,0.53,0.564433,0.53333336,0.564433,0.5366667,0.564433,0.54,0.564433,0.70666665,0.564433,0.71,0.564433,0.7133333,0.564433,0.71666664,0.564433,0.72,0.564433,0.72333336,0.564433,0.7366667,0.564433,0.74,0.564433,0.74333334,0.564433,0.74666667,0.564433,0.75,0.564433,0.75333333,0.564433,0.75666666,0.564433,0.79333335,0.564433,0.7966667,0.564433,0.8,0.564433,0.80333334,0.564433,0.8066667,0.564433,0.81,0.564433,0.81333333,0.564433,0.81666666,0.564433,0.82,0.564433,0.8233333,0.564433,0.82666665,0.564433,0.83,0.564433,0.21666667,0.5670103,0.29,0.5670103,0.29333332,0.5670103,0.29666665,0.5670103,0.3,0.5670103,0.30333334,0.5670103,0.43333334,0.5670103,0.43666667,0.5670103,0.44,0.5670103,0.44333333,0.5670103,0.44666666,0.5670103,0.45,0.5670103,0.45333335,0.5670103,0.49333334,0.5670103,0.49666667,0.5670103,0.5,0.5670103,0.50333333,0.5670103,0.50666666,0.5670103,0.51,0.5670103,0.5133333,0.5670103,0.51666665,0.5670103,0.52,0.5670103,0.5233333,0.5670103,0.52666664,0.5670103,0.53,0.5670103,0.53333336,0.5670103,0.5366667,0.5670103,0.70666665,0.5670103,0.71,0.5670103,0.7133333,0.5670103,0.71666664,0.5670103,0.72,0.5670103,0.72333336,0.5670103,0.74,0.5670103,0.74333334,0.5670103,0.74666667,0.5670103,0.75,0.5670103,0.75333333,0.5670103,0.75666666,0.5670103,0.79333335,0.5670103,0.7966667,0.5670103,0.8,0.5670103,0.80333334,0.5670103,0.8066667,0.5670103,0.81,0.5670103,0.81333333,0.5670103,0.81666666,0.5670103,0.82,0.5670103,0.8233333,0.5670103,0.82666665,0.5670103,0.83,0.5670103,0.20666666,0.56958765,0.21,0.56958765,0.21333334,0.56958765,0.21666667,0.56958765,0.22,0.56958765,0.22333333,0.56958765,0.22666667,0.56958765,0.27666667,0.56958765,0.28,0.56958765,0.28333333,0.56958765,0.28666666,0.56958765,0.29,0.56958765,0.29333332,0.56958765,0.29666665,0.56958765,0.3,0.56958765,0.30333334,0.56958765,0.30666667,0.56958765,0.31,0.56958765,0.31333333,0.56958765,0.31666666,0.56958765,0.43333334,0.56958765,0.43666667,0.56958765,0.44,0.56958765,0.44333333,0.56958765,0.44666666,0.56958765,0.45,0.56958765,0.45333335,0.56958765,0.45666668,0.56958765,0.49,0.56958765,0.49333334,0.56958765,0.49666667,0.56958765,0.5,0.56958765,0.50333333,0.56958765,0.50666666,0.56958765,0.51,0.56958765,0.5133333,0.56958765,0.51666665,0.56958765,0.52,0.56958765,0.5233333,0.56958765,0.52666664,0.56958765,0.53,0.56958765,0.53333336,0.56958765,0.5366667,0.56958765,0.68666667,0.56958765,0.69,0.56958765,0.71,0.56958765,0.7133333,0.56958765,0.71666664,0.56958765,0.72,0.56958765,0.72333336,0.56958765,0.7266667,0.56958765,0.74333334,0.56958765,0.74666667,0.56958765,0.75,0.56958765,0.75333333,0.56958765,0.75666666,0.56958765,0.76,0.56958765,0.79,0.56958765,0.79333335,0.56958765,0.7966667,0.56958765,0.8,0.56958765,0.80333334,0.56958765,0.8066667,0.56958765,0.81,0.56958765,0.81333333,0.56958765,0.81666666,0.56958765,0.82,0.56958765,0.8233333,0.56958765,0.82666665,0.56958765,0.83,0.56958765,0.8333333,0.56958765,0.20333333,0.57216495,0.20666666,0.57216495,0.21,0.57216495,0.21333334,0.57216495,0.21666667,0.57216495,0.22,0.57216495,0.22333333,0.57216495,0.22666667,0.57216495,0.23,0.57216495,0.27,0.57216495,0.27333334,0.57216495,0.27666667,0.57216495,0.28,0.57216495,0.28333333,0.57216495,0.28666666,0.57216495,0.29,0.57216495,0.29333332,0.57216495,0.29666665,0.57216495,0.3,0.57216495,0.30333334,0.57216495,0.30666667,0.57216495,0.31,0.57216495,0.31333333,0.57216495,0.31666666,0.57216495,0.32,0.57216495,0.43,0.57216495,0.43333334,0.57216495,0.43666667,0.57216495,0.44,0.57216495,0.44333333,0.57216495,0.44666666,0.57216495,0.45,0.57216495,0.45333335,0.57216495,0.45666668,0.57216495,0.49,0.57216495,0.49333334,0.57216495,0.49666667,0.57216495,0.5,0.57216495,0.50333333,0.57216495,0.50666666,0.57216495,0.51,0.57216495,0.5133333,0.57216495,0.51666665,0.57216495,0.52,0.57216495,0.5233333,0.57216495,0.52666664,0.57216495,0.53,0.57216495,0.53333336,0.57216495,0.5966667,0.57216495,0.6,0.57216495,0.60333335,0.57216495,0.6066667,0.57216495,0.68666667,0.57216495,0.69,0.57216495,0.6933333,0.57216495,0.71,0.57216495,0.7133333,0.57216495,0.71666664,0.57216495,0.72,0.57216495,0.72333336,0.57216495,0.7266667,0.57216495,0.73,0.57216495,0.74333334,0.57216495,0.74666667,0.57216495,0.75,0.57216495,0.75333333,0.57216495,0.75666666,0.57216495,0.76,0.57216495,0.7633333,0.57216495,0.79,0.57216495,0.79333335,0.57216495,0.7966667,0.57216495,0.8,0.57216495,0.80333334,0.57216495,0.8066667,0.57216495,0.81,0.57216495,0.81333333,0.57216495,0.81666666,0.57216495,0.82,0.57216495,0.8233333,0.57216495,0.82666665,0.57216495,0.83,0.57216495,0.8333333,0.57216495,0.14333333,0.57474226,0.14666666,0.57474226,0.15,0.57474226,0.15333334,0.57474226,0.15666667,0.57474226,0.2,0.57474226,0.20333333,0.57474226,0.20666666,0.57474226,0.21,0.57474226,0.21333334,0.57474226,0.21666667,0.57474226,0.22,0.57474226,0.22333333,0.57474226,0.22666667,0.57474226,0.23,0.57474226,0.23333333,0.57474226,0.26666668,0.57474226,0.27,0.57474226,0.27333334,0.57474226,0.27666667,0.57474226,0.28,0.57474226,0.28333333,0.57474226,0.28666666,0.57474226,0.29,0.57474226,0.29333332,0.57474226,0.29666665,0.57474226,0.3,0.57474226,0.30333334,0.57474226,0.30666667,0.57474226,0.31,0.57474226,0.31333333,0.57474226,0.31666666,0.57474226,0.32,0.57474226,0.32333332,0.57474226,0.32666665,0.57474226,0.43,0.57474226,0.43333334,0.57474226,0.43666667,0.57474226,0.44,0.57474226,0.44333333,0.57474226,0.44666666,0.57474226,0.45,0.57474226,0.45333335,0.57474226,0.45666668,0.57474226,0.46,0.57474226,0.48666668,0.57474226,0.49,0.57474226,0.49333334,0.57474226,0.49666667,0.57474226,0.5,0.57474226,0.50333333,0.57474226,0.50666666,0.57474226,0.51,0.57474226,0.5133333,0.57474226,0.51666665,0.57474226,0.52,0.57474226,0.5233333,0.57474226,0.52666664,0.57474226,0.53,0.57474226,0.53333336,0.57474226,0.5833333,0.57474226,0.58666664,0.57474226,0.59,0.57474226,0.5933333,0.57474226,0.5966667,0.57474226,0.6,0.57474226,0.60333335,0.57474226,0.6066667,0.57474226,0.61,0.57474226,0.61333334,0.57474226,0.68333334,0.57474226,0.68666667,0.57474226,0.69,0.57474226,0.6933333,0.57474226,0.71,0.57474226,0.7133333,0.57474226,0.71666664,0.57474226,0.72,0.57474226,0.72333336,0.57474226,0.7266667,0.57474226,0.73,0.57474226,0.74333334,0.57474226,0.74666667,0.57474226,0.75,0.57474226,0.75333333,0.57474226,0.75666666,0.57474226,0.76,0.57474226,0.7633333,0.57474226,0.7866667,0.57474226,0.79,0.57474226,0.79333335,0.57474226,0.7966667,0.57474226,0.8,0.57474226,0.80333334,0.57474226,0.8066667,0.57474226,0.81,0.57474226,0.81333333,0.57474226,0.81666666,0.57474226,0.82,0.57474226,0.8233333,0.57474226,0.82666665,0.57474226,0.83,0.57474226,0.8333333,0.57474226,0.14333333,0.57731956,0.14666666,0.57731956,0.15,0.57731956,0.15333334,0.57731956,0.15666667,0.57731956,0.16,0.57731956,0.16333333,0.57731956,0.19666667,0.57731956,0.2,0.57731956,0.20333333,0.57731956,0.20666666,0.57731956,0.21,0.57731956,0.21333334,0.57731956,0.21666667,0.57731956,0.22,0.57731956,0.22333333,0.57731956,0.22666667,0.57731956,0.23,0.57731956,0.23333333,0.57731956,0.26333332,0.57731956,0.26666668,0.57731956,0.27,0.57731956,0.27333334,0.57731956,0.27666667,0.57731956,0.28,0.57731956,0.28333333,0.57731956,0.28666666,0.57731956,0.29,0.57731956,0.29333332,0.57731956,0.29666665,0.57731956,0.3,0.57731956,0.30333334,0.57731956,0.30666667,0.57731956,0.31,0.57731956,0.31333333,0.57731956,0.31666666,0.57731956,0.32,0.57731956,0.32333332,0.57731956,0.32666665,0.57731956,0.33,0.57731956,0.42666668,0.57731956,0.43,0.57731956,0.43333334,0.57731956,0.43666667,0.57731956,0.44,0.57731956,0.44333333,0.57731956,0.44666666,0.57731956,0.45,0.57731956,0.45333335,0.57731956,0.45666668,0.57731956,0.46,0.57731956,0.46333334,0.57731956,0.48666668,0.57731956,0.49,0.57731956,0.49333334,0.57731956,0.49666667,0.57731956,0.5,0.57731956,0.50333333,0.57731956,0.50666666,0.57731956,0.51,0.57731956,0.5133333,0.57731956,0.51666665,0.57731956,0.52,0.57731956,0.5233333,0.57731956,0.52666664,0.57731956,0.53,0.57731956,0.53333336,0.57731956,0.58,0.57731956,0.5833333,0.57731956,0.58666664,0.57731956,0.59,0.57731956,0.5933333,0.57731956,0.5966667,0.57731956,0.6,0.57731956,0.60333335,0.57731956,0.6066667,0.57731956,0.61,0.57731956,0.61333334,0.57731956,0.6166667,0.57731956,0.62,0.57731956,0.68333334,0.57731956,0.68666667,0.57731956,0.69,0.57731956,0.6933333,0.57731956,0.70666665,0.57731956,0.71,0.57731956,0.7133333,0.57731956,0.71666664,0.57731956,0.72,0.57731956,0.72333336,0.57731956,0.7266667,0.57731956,0.73,0.57731956,0.73333335,0.57731956,0.74333334,0.57731956,0.74666667,0.57731956,0.75,0.57731956,0.75333333,0.57731956,0.75666666,0.57731956,0.76,0.57731956,0.7633333,0.57731956,0.76666665,0.57731956,0.7866667,0.57731956,0.79,0.57731956,0.79333335,0.57731956,0.7966667,0.57731956,0.8,0.57731956,0.80333334,0.57731956,0.8066667,0.57731956,0.81,0.57731956,0.81333333,0.57731956,0.81666666,0.57731956,0.82,0.57731956,0.8233333,0.57731956,0.82666665,0.57731956,0.83,0.57731956,0.8333333,0.57731956,0.8666667,0.57731956,0.87,0.57731956,0.87333333,0.57731956,0.87666667,0.57731956,0.88,0.57731956,0.8833333,0.57731956,0.88666666,0.57731956,0.89,0.57731956,0.8933333,0.57731956,0.89666665,0.57731956,0.14333333,0.5798969,0.14666666,0.5798969,0.15,0.5798969,0.15333334,0.5798969,0.15666667,0.5798969,0.16,0.5798969,0.16333333,0.5798969,0.16666667,0.5798969,0.19333333,0.5798969,0.19666667,0.5798969,0.2,0.5798969,0.20333333,0.5798969,0.20666666,0.5798969,0.21,0.5798969,0.21333334,0.5798969,0.21666667,0.5798969,0.22,0.5798969,0.22333333,0.5798969,0.22666667,0.5798969,0.23,0.5798969,0.23333333,0.5798969,0.25666666,0.5798969,0.26,0.5798969,0.26333332,0.5798969,0.26666668,0.5798969,0.27,0.5798969,0.27333334,0.5798969,0.27666667,0.5798969,0.28,0.5798969,0.28333333,0.5798969,0.28666666,0.5798969,0.29,0.5798969,0.29333332,0.5798969,0.29666665,0.5798969,0.3,0.5798969,0.30333334,0.5798969,0.30666667,0.5798969,0.31,0.5798969,0.31333333,0.5798969,0.31666666,0.5798969,0.32,0.5798969,0.32333332,0.5798969,0.32666665,0.5798969,0.33,0.5798969,0.33333334,0.5798969,0.42333335,0.5798969,0.42666668,0.5798969,0.43,0.5798969,0.43333334,0.5798969,0.43666667,0.5798969,0.44,0.5798969,0.44333333,0.5798969,0.44666666,0.5798969,0.45,0.5798969,0.45333335,0.5798969,0.45666668,0.5798969,0.46,0.5798969,0.46333334,0.5798969,0.46666667,0.5798969,0.47,0.5798969,0.47333333,0.5798969,0.47666666,0.5798969,0.48,0.5798969,0.48333332,0.5798969,0.48666668,0.5798969,0.49,0.5798969,0.49333334,0.5798969,0.49666667,0.5798969,0.5,0.5798969,0.50333333,0.5798969,0.50666666,0.5798969,0.51,0.5798969,0.5133333,0.5798969,0.51666665,0.5798969,0.52,0.5798969,0.5233333,0.5798969,0.52666664,0.5798969,0.53,0.5798969,0.53333336,0.5798969,0.5733333,0.5798969,0.57666665,0.5798969,0.58,0.5798969,0.5833333,0.5798969,0.58666664,0.5798969,0.59,0.5798969,0.5933333,0.5798969,0.5966667,0.5798969,0.6,0.5798969,0.60333335,0.5798969,0.6066667,0.5798969,0.61,0.5798969,0.61333334,0.5798969,0.6166667,0.5798969,0.62,0.5798969,0.62333333,0.5798969,0.7033333,0.5798969,0.70666665,0.5798969,0.71,0.5798969,0.7133333,0.5798969,0.71666664,0.5798969,0.72,0.5798969,0.72333336,0.5798969,0.7266667,0.5798969,0.73,0.5798969,0.73333335,0.5798969,0.74666667,0.5798969,0.75,0.5798969,0.75333333,0.5798969,0.75666666,0.5798969,0.76,0.5798969,0.7633333,0.5798969,0.76666665,0.5798969,0.77,0.5798969,0.78333336,0.5798969,0.7866667,0.5798969,0.79,0.5798969,0.79333335,0.5798969,0.7966667,0.5798969,0.8,0.5798969,0.80333334,0.5798969,0.8066667,0.5798969,0.81,0.5798969,0.81333333,0.5798969,0.81666666,0.5798969,0.82,0.5798969,0.8233333,0.5798969,0.82666665,0.5798969,0.83,0.5798969,0.8333333,0.5798969,0.86333334,0.5798969,0.8666667,0.5798969,0.87,0.5798969,0.87333333,0.5798969,0.87666667,0.5798969,0.88,0.5798969,0.8833333,0.5798969,0.88666666,0.5798969,0.89,0.5798969,0.8933333,0.5798969,0.89666665,0.5798969,0.9,0.5798969,0.14333333,0.58247423,0.14666666,0.58247423,0.15,0.58247423,0.15333334,0.58247423,0.15666667,0.58247423,0.16,0.58247423,0.16333333,0.58247423,0.16666667,0.58247423,0.17,0.58247423,0.19333333,0.58247423,0.19666667,0.58247423,0.2,0.58247423,0.20333333,0.58247423,0.20666666,0.58247423,0.21,0.58247423,0.21333334,0.58247423,0.21666667,0.58247423,0.22,0.58247423,0.22333333,0.58247423,0.22666667,0.58247423,0.23,0.58247423,0.23333333,0.58247423,0.23666666,0.58247423,0.25333333,0.58247423,0.25666666,0.58247423,0.26,0.58247423,0.26333332,0.58247423,0.26666668,0.58247423,0.27,0.58247423,0.27333334,0.58247423,0.27666667,0.58247423,0.28,0.58247423,0.28333333,0.58247423,0.28666666,0.58247423,0.29,0.58247423,0.29333332,0.58247423,0.29666665,0.58247423,0.3,0.58247423,0.30333334,0.58247423,0.30666667,0.58247423,0.31,0.58247423,0.31333333,0.58247423,0.31666666,0.58247423,0.32,0.58247423,0.32333332,0.58247423,0.32666665,0.58247423,0.33,0.58247423,0.33333334,0.58247423,0.42333335,0.58247423,0.42666668,0.58247423,0.43,0.58247423,0.43333334,0.58247423,0.43666667,0.58247423,0.44,0.58247423,0.44333333,0.58247423,0.44666666,0.58247423,0.45,0.58247423,0.45333335,0.58247423,0.45666668,0.58247423,0.46,0.58247423,0.46333334,0.58247423,0.46666667,0.58247423,0.47,0.58247423,0.47333333,0.58247423,0.47666666,0.58247423,0.48,0.58247423,0.48333332,0.58247423,0.48666668,0.58247423,0.49,0.58247423,0.49333334,0.58247423,0.49666667,0.58247423,0.5,0.58247423,0.50333333,0.58247423,0.50666666,0.58247423,0.51,0.58247423,0.5133333,0.58247423,0.51666665,0.58247423,0.52,0.58247423,0.5233333,0.58247423,0.52666664,0.58247423,0.53,0.58247423,0.53333336,0.58247423,0.56666666,0.58247423,0.57,0.58247423,0.5733333,0.58247423,0.57666665,0.58247423,0.58,0.58247423,0.5833333,0.58247423,0.58666664,0.58247423,0.59,0.58247423,0.5933333,0.58247423,0.5966667,0.58247423,0.6,0.58247423,0.60333335,0.58247423,0.6066667,0.58247423,0.61,0.58247423,0.61333334,0.58247423,0.6166667,0.58247423,0.62,0.58247423,0.62333333,0.58247423,0.7,0.58247423,0.7033333,0.58247423,0.70666665,0.58247423,0.71,0.58247423,0.7133333,0.58247423,0.71666664,0.58247423,0.72,0.58247423,0.72333336,0.58247423,0.7266667,0.58247423,0.73,0.58247423,0.73333335,0.58247423,0.74666667,0.58247423,0.75,0.58247423,0.75333333,0.58247423,0.75666666,0.58247423,0.76,0.58247423,0.7633333,0.58247423,0.76666665,0.58247423,0.77,0.58247423,0.7733333,0.58247423,0.77666664,0.58247423,0.78,0.58247423,0.78333336,0.58247423,0.7866667,0.58247423,0.79,0.58247423,0.79333335,0.58247423,0.7966667,0.58247423,0.8,0.58247423,0.80333334,0.58247423,0.8066667,0.58247423,0.81,0.58247423,0.81333333,0.58247423,0.81666666,0.58247423,0.82,0.58247423,0.8233333,0.58247423,0.82666665,0.58247423,0.83,0.58247423,0.8566667,0.58247423,0.86,0.58247423,0.86333334,0.58247423,0.8666667,0.58247423,0.87,0.58247423,0.87333333,0.58247423,0.87666667,0.58247423,0.88,0.58247423,0.8833333,0.58247423,0.88666666,0.58247423,0.89,0.58247423,0.8933333,0.58247423,0.89666665,0.58247423,0.9,0.58247423,0.9033333,0.58247423,0.14333333,0.58505154,0.14666666,0.58505154,0.15,0.58505154,0.15333334,0.58505154,0.15666667,0.58505154,0.16,0.58505154,0.16333333,0.58505154,0.16666667,0.58505154,0.17,0.58505154,0.17333333,0.58505154,0.19333333,0.58505154,0.19666667,0.58505154,0.2,0.58505154,0.20333333,0.58505154,0.20666666,0.58505154,0.21,0.58505154,0.21333334,0.58505154,0.21666667,0.58505154,0.22,0.58505154,0.22333333,0.58505154,0.22666667,0.58505154,0.23,0.58505154,0.23333333,0.58505154,0.23666666,0.58505154,0.24,0.58505154,0.24666667,0.58505154,0.25,0.58505154,0.25333333,0.58505154,0.25666666,0.58505154,0.26,0.58505154,0.26333332,0.58505154,0.26666668,0.58505154,0.27,0.58505154,0.27333334,0.58505154,0.27666667,0.58505154,0.28,0.58505154,0.28333333,0.58505154,0.28666666,0.58505154,0.29,0.58505154,0.29333332,0.58505154,0.29666665,0.58505154,0.3,0.58505154,0.30333334,0.58505154,0.30666667,0.58505154,0.31,0.58505154,0.31333333,0.58505154,0.31666666,0.58505154,0.32,0.58505154,0.32333332,0.58505154,0.32666665,0.58505154,0.33,0.58505154,0.33333334,0.58505154,0.33666667,0.58505154,0.42666668,0.58505154,0.43,0.58505154,0.43333334,0.58505154,0.43666667,0.58505154,0.44,0.58505154,0.44333333,0.58505154,0.44666666,0.58505154,0.45,0.58505154,0.45333335,0.58505154,0.45666668,0.58505154,0.46,0.58505154,0.46333334,0.58505154,0.46666667,0.58505154,0.47,0.58505154,0.47333333,0.58505154,0.47666666,0.58505154,0.48,0.58505154,0.48333332,0.58505154,0.48666668,0.58505154,0.49,0.58505154,0.49333334,0.58505154,0.49666667,0.58505154,0.5,0.58505154,0.50333333,0.58505154,0.50666666,0.58505154,0.51,0.58505154,0.5133333,0.58505154,0.51666665,0.58505154,0.52,0.58505154,0.5233333,0.58505154,0.52666664,0.58505154,0.53,0.58505154,0.53333336,0.58505154,0.56333333,0.58505154,0.56666666,0.58505154,0.57,0.58505154,0.5733333,0.58505154,0.57666665,0.58505154,0.58,0.58505154,0.5833333,0.58505154,0.58666664,0.58505154,0.59,0.58505154,0.5933333,0.58505154,0.5966667,0.58505154,0.6,0.58505154,0.60333335,0.58505154,0.6066667,0.58505154,0.61,0.58505154,0.61333334,0.58505154,0.6166667,0.58505154,0.62,0.58505154,0.62333333,0.58505154,0.62666667,0.58505154,0.68666667,0.58505154,0.69,0.58505154,0.6933333,0.58505154,0.69666666,0.58505154,0.7,0.58505154,0.7033333,0.58505154,0.70666665,0.58505154,0.71,0.58505154,0.7133333,0.58505154,0.71666664,0.58505154,0.72,0.58505154,0.72333336,0.58505154,0.7266667,0.58505154,0.73,0.58505154,0.73333335,0.58505154,0.74666667,0.58505154,0.75,0.58505154,0.75333333,0.58505154,0.75666666,0.58505154,0.76,0.58505154,0.7633333,0.58505154,0.76666665,0.58505154,0.77,0.58505154,0.7733333,0.58505154,0.77666664,0.58505154,0.78,0.58505154,0.78333336,0.58505154,0.7866667,0.58505154,0.79,0.58505154,0.8,0.58505154,0.80333334,0.58505154,0.8066667,0.58505154,0.81,0.58505154,0.81333333,0.58505154,0.81666666,0.58505154,0.82,0.58505154,0.8233333,0.58505154,0.82666665,0.58505154,0.83,0.58505154,0.85333335,0.58505154,0.8566667,0.58505154,0.86,0.58505154,0.86333334,0.58505154,0.8666667,0.58505154,0.87,0.58505154,0.87333333,0.58505154,0.87666667,0.58505154,0.88,0.58505154,0.8833333,0.58505154,0.88666666,0.58505154,0.89,0.58505154,0.8933333,0.58505154,0.89666665,0.58505154,0.9,0.58505154,0.9033333,0.58505154,0.14333333,0.58762884,0.14666666,0.58762884,0.15,0.58762884,0.15333334,0.58762884,0.15666667,0.58762884,0.16,0.58762884,0.16333333,0.58762884,0.16666667,0.58762884,0.17,0.58762884,0.17333333,0.58762884,0.17666666,0.58762884,0.19333333,0.58762884,0.19666667,0.58762884,0.2,0.58762884,0.20333333,0.58762884,0.20666666,0.58762884,0.21,0.58762884,0.21333334,0.58762884,0.21666667,0.58762884,0.22,0.58762884,0.22333333,0.58762884,0.22666667,0.58762884,0.23,0.58762884,0.23333333,0.58762884,0.23666666,0.58762884,0.24,0.58762884,0.24333334,0.58762884,0.24666667,0.58762884,0.25,0.58762884,0.25333333,0.58762884,0.25666666,0.58762884,0.26,0.58762884,0.26333332,0.58762884,0.26666668,0.58762884,0.27,0.58762884,0.27333334,0.58762884,0.27666667,0.58762884,0.28,0.58762884,0.28333333,0.58762884,0.28666666,0.58762884,0.29,0.58762884,0.29333332,0.58762884,0.29666665,0.58762884,0.3,0.58762884,0.30333334,0.58762884,0.30666667,0.58762884,0.31,0.58762884,0.31333333,0.58762884,0.31666666,0.58762884,0.32,0.58762884,0.32333332,0.58762884,0.32666665,0.58762884,0.33,0.58762884,0.33333334,0.58762884,0.33666667,0.58762884,0.34,0.58762884,0.37333333,0.58762884,0.37666667,0.58762884,0.38,0.58762884,0.38333333,0.58762884,0.38666666,0.58762884,0.39,0.58762884,0.43,0.58762884,0.43333334,0.58762884,0.43666667,0.58762884,0.44,0.58762884,0.44333333,0.58762884,0.44666666,0.58762884,0.45,0.58762884,0.45333335,0.58762884,0.45666668,0.58762884,0.46,0.58762884,0.46333334,0.58762884,0.46666667,0.58762884,0.47,0.58762884,0.47333333,0.58762884,0.47666666,0.58762884,0.48,0.58762884,0.48333332,0.58762884,0.48666668,0.58762884,0.49,0.58762884,0.49333334,0.58762884,0.49666667,0.58762884,0.5,0.58762884,0.50333333,0.58762884,0.50666666,0.58762884,0.51,0.58762884,0.5133333,0.58762884,0.51666665,0.58762884,0.52,0.58762884,0.5233333,0.58762884,0.52666664,0.58762884,0.53,0.58762884,0.53333336,0.58762884,0.5366667,0.58762884,0.56,0.58762884,0.56333333,0.58762884,0.56666666,0.58762884,0.57,0.58762884,0.5733333,0.58762884,0.57666665,0.58762884,0.58,0.58762884,0.5833333,0.58762884,0.58666664,0.58762884,0.59,0.58762884,0.5933333,0.58762884,0.5966667,0.58762884,0.6,0.58762884,0.60333335,0.58762884,0.6066667,0.58762884,0.61,0.58762884,0.61333334,0.58762884,0.6166667,0.58762884,0.62,0.58762884,0.62333333,0.58762884,0.62666667,0.58762884,0.6766667,0.58762884,0.68,0.58762884,0.68333334,0.58762884,0.68666667,0.58762884,0.69,0.58762884,0.6933333,0.58762884,0.69666666,0.58762884,0.7,0.58762884,0.7033333,0.58762884,0.70666665,0.58762884,0.71,0.58762884,0.7133333,0.58762884,0.71666664,0.58762884,0.72,0.58762884,0.72333336,0.58762884,0.7266667,0.58762884,0.73,0.58762884,0.73333335,0.58762884,0.7366667,0.58762884,0.74666667,0.58762884,0.75,0.58762884,0.75333333,0.58762884,0.75666666,0.58762884,0.76,0.58762884,0.7633333,0.58762884,0.76666665,0.58762884,0.77,0.58762884,0.7733333,0.58762884,0.77666664,0.58762884,0.78,0.58762884,0.78333336,0.58762884,0.80333334,0.58762884,0.8066667,0.58762884,0.81,0.58762884,0.81333333,0.58762884,0.81666666,0.58762884,0.82,0.58762884,0.8233333,0.58762884,0.82666665,0.58762884,0.83,0.58762884,0.8333333,0.58762884,0.84,0.58762884,0.8433333,0.58762884,0.8466667,0.58762884,0.85,0.58762884,0.85333335,0.58762884,0.8566667,0.58762884,0.86,0.58762884,0.86333334,0.58762884,0.8666667,0.58762884,0.87,0.58762884,0.87333333,0.58762884,0.87666667,0.58762884,0.88,0.58762884,0.8833333,0.58762884,0.88666666,0.58762884,0.89,0.58762884,0.8933333,0.58762884,0.89666665,0.58762884,0.9,0.58762884,0.9033333,0.58762884,0.086666666,0.5902062,0.09,0.5902062,0.093333334,0.5902062,0.096666664,0.5902062,0.1,0.5902062,0.10333333,0.5902062,0.14,0.5902062,0.14333333,0.5902062,0.14666666,0.5902062,0.15,0.5902062,0.15333334,0.5902062,0.15666667,0.5902062,0.16,0.5902062,0.16333333,0.5902062,0.16666667,0.5902062,0.17,0.5902062,0.17333333,0.5902062,0.17666666,0.5902062,0.19333333,0.5902062,0.19666667,0.5902062,0.2,0.5902062,0.20333333,0.5902062,0.20666666,0.5902062,0.21,0.5902062,0.21333334,0.5902062,0.21666667,0.5902062,0.22,0.5902062,0.22333333,0.5902062,0.22666667,0.5902062,0.23,0.5902062,0.23333333,0.5902062,0.23666666,0.5902062,0.24,0.5902062,0.24333334,0.5902062,0.24666667,0.5902062,0.25,0.5902062,0.25333333,0.5902062,0.25666666,0.5902062,0.26,0.5902062,0.26333332,0.5902062,0.26666668,0.5902062,0.27,0.5902062,0.27333334,0.5902062,0.27666667,0.5902062,0.28,0.5902062,0.28333333,0.5902062,0.28666666,0.5902062,0.29,0.5902062,0.29333332,0.5902062,0.29666665,0.5902062,0.3,0.5902062,0.30333334,0.5902062,0.30666667,0.5902062,0.31,0.5902062,0.31333333,0.5902062,0.31666666,0.5902062,0.32,0.5902062,0.32333332,0.5902062,0.32666665,0.5902062,0.33,0.5902062,0.33333334,0.5902062,0.33666667,0.5902062,0.34,0.5902062,0.37,0.5902062,0.37333333,0.5902062,0.37666667,0.5902062,0.38,0.5902062,0.38333333,0.5902062,0.38666666,0.5902062,0.39,0.5902062,0.39333335,0.5902062,0.39666668,0.5902062,0.43333334,0.5902062,0.43666667,0.5902062,0.44,0.5902062,0.44333333,0.5902062,0.44666666,0.5902062,0.45,0.5902062,0.45333335,0.5902062,0.45666668,0.5902062,0.46,0.5902062,0.46333334,0.5902062,0.46666667,0.5902062,0.47,0.5902062,0.47333333,0.5902062,0.47666666,0.5902062,0.48,0.5902062,0.48333332,0.5902062,0.48666668,0.5902062,0.49,0.5902062,0.49333334,0.5902062,0.49666667,0.5902062,0.5,0.5902062,0.50333333,0.5902062,0.50666666,0.5902062,0.51,0.5902062,0.5133333,0.5902062,0.51666665,0.5902062,0.52,0.5902062,0.5233333,0.5902062,0.52666664,0.5902062,0.53,0.5902062,0.53333336,0.5902062,0.5366667,0.5902062,0.54,0.5902062,0.54333335,0.5902062,0.5466667,0.5902062,0.55,0.5902062,0.55333334,0.5902062,0.5566667,0.5902062,0.56,0.5902062,0.56333333,0.5902062,0.56666666,0.5902062,0.57,0.5902062,0.5733333,0.5902062,0.57666665,0.5902062,0.58,0.5902062,0.5833333,0.5902062,0.58666664,0.5902062,0.59,0.5902062,0.5933333,0.5902062,0.5966667,0.5902062,0.6,0.5902062,0.60333335,0.5902062,0.6066667,0.5902062,0.61,0.5902062,0.61333334,0.5902062,0.6166667,0.5902062,0.62,0.5902062,0.62333333,0.5902062,0.62666667,0.5902062,0.66333336,0.5902062,0.6666667,0.5902062,0.67,0.5902062,0.67333335,0.5902062,0.6766667,0.5902062,0.68,0.5902062,0.68333334,0.5902062,0.68666667,0.5902062,0.69,0.5902062,0.6933333,0.5902062,0.69666666,0.5902062,0.7,0.5902062,0.7033333,0.5902062,0.70666665,0.5902062,0.71,0.5902062,0.7133333,0.5902062,0.71666664,0.5902062,0.72,0.5902062,0.72333336,0.5902062,0.7266667,0.5902062,0.73,0.5902062,0.73333335,0.5902062,0.7366667,0.5902062,0.74666667,0.5902062,0.75,0.5902062,0.75333333,0.5902062,0.75666666,0.5902062,0.76,0.5902062,0.7633333,0.5902062,0.76666665,0.5902062,0.77,0.5902062,0.7733333,0.5902062,0.77666664,0.5902062,0.78,0.5902062,0.80333334,0.5902062,0.8066667,0.5902062,0.81,0.5902062,0.81333333,0.5902062,0.81666666,0.5902062,0.82,0.5902062,0.8233333,0.5902062,0.82666665,0.5902062,0.84,0.5902062,0.8433333,0.5902062,0.8466667,0.5902062,0.85,0.5902062,0.85333335,0.5902062,0.8566667,0.5902062,0.86,0.5902062,0.86333334,0.5902062,0.8666667,0.5902062,0.87,0.5902062,0.87333333,0.5902062,0.87666667,0.5902062,0.88,0.5902062,0.8833333,0.5902062,0.88666666,0.5902062,0.89,0.5902062,0.8933333,0.5902062,0.89666665,0.5902062,0.9,0.5902062,0.9033333,0.5902062,0.9066667,0.5902062,0.07,0.5927835,0.07333333,0.5927835,0.07666667,0.5927835,0.08,0.5927835,0.083333336,0.5927835,0.086666666,0.5927835,0.09,0.5927835,0.093333334,0.5927835,0.096666664,0.5927835,0.1,0.5927835,0.10333333,0.5927835,0.10666667,0.5927835,0.13666667,0.5927835,0.14,0.5927835,0.14333333,0.5927835,0.14666666,0.5927835,0.15,0.5927835,0.15333334,0.5927835,0.15666667,0.5927835,0.16,0.5927835,0.16333333,0.5927835,0.16666667,0.5927835,0.17,0.5927835,0.17333333,0.5927835,0.17666666,0.5927835,0.19333333,0.5927835,0.19666667,0.5927835,0.2,0.5927835,0.20333333,0.5927835,0.20666666,0.5927835,0.21,0.5927835,0.21333334,0.5927835,0.21666667,0.5927835,0.22,0.5927835,0.22333333,0.5927835,0.22666667,0.5927835,0.23,0.5927835,0.23333333,0.5927835,0.23666666,0.5927835,0.24,0.5927835,0.24333334,0.5927835,0.24666667,0.5927835,0.25,0.5927835,0.25333333,0.5927835,0.25666666,0.5927835,0.26,0.5927835,0.26333332,0.5927835,0.26666668,0.5927835,0.27,0.5927835,0.27333334,0.5927835,0.27666667,0.5927835,0.28,0.5927835,0.28333333,0.5927835,0.28666666,0.5927835,0.29,0.5927835,0.29333332,0.5927835,0.29666665,0.5927835,0.3,0.5927835,0.30333334,0.5927835,0.30666667,0.5927835,0.31,0.5927835,0.31333333,0.5927835,0.31666666,0.5927835,0.32,0.5927835,0.32333332,0.5927835,0.32666665,0.5927835,0.33,0.5927835,0.33333334,0.5927835,0.33666667,0.5927835,0.34,0.5927835,0.36666667,0.5927835,0.37,0.5927835,0.37333333,0.5927835,0.37666667,0.5927835,0.38,0.5927835,0.38333333,0.5927835,0.38666666,0.5927835,0.39,0.5927835,0.39333335,0.5927835,0.39666668,0.5927835,0.4,0.5927835,0.43666667,0.5927835,0.44,0.5927835,0.44333333,0.5927835,0.44666666,0.5927835,0.45,0.5927835,0.45333335,0.5927835,0.45666668,0.5927835,0.46,0.5927835,0.46333334,0.5927835,0.46666667,0.5927835,0.47,0.5927835,0.47333333,0.5927835,0.47666666,0.5927835,0.48,0.5927835,0.48333332,0.5927835,0.48666668,0.5927835,0.49,0.5927835,0.49333334,0.5927835,0.49666667,0.5927835,0.5,0.5927835,0.50333333,0.5927835,0.50666666,0.5927835,0.51,0.5927835,0.5133333,0.5927835,0.51666665,0.5927835,0.52,0.5927835,0.5233333,0.5927835,0.52666664,0.5927835,0.53,0.5927835,0.53333336,0.5927835,0.5366667,0.5927835,0.54,0.5927835,0.54333335,0.5927835,0.5466667,0.5927835,0.55,0.5927835,0.55333334,0.5927835,0.5566667,0.5927835,0.56,0.5927835,0.56333333,0.5927835,0.56666666,0.5927835,0.57,0.5927835,0.5733333,0.5927835,0.57666665,0.5927835,0.58,0.5927835,0.5833333,0.5927835,0.58666664,0.5927835,0.59,0.5927835,0.5933333,0.5927835,0.5966667,0.5927835,0.6,0.5927835,0.60333335,0.5927835,0.6066667,0.5927835,0.61,0.5927835,0.61333334,0.5927835,0.6166667,0.5927835,0.62,0.5927835,0.62333333,0.5927835,0.62666667,0.5927835,0.6566667,0.5927835,0.66,0.5927835,0.66333336,0.5927835,0.6666667,0.5927835,0.67,0.5927835,0.67333335,0.5927835,0.6766667,0.5927835,0.68,0.5927835,0.68333334,0.5927835,0.68666667,0.5927835,0.69,0.5927835,0.6933333,0.5927835,0.69666666,0.5927835,0.7,0.5927835,0.7033333,0.5927835,0.70666665,0.5927835,0.71,0.5927835,0.7133333,0.5927835,0.71666664,0.5927835,0.72,0.5927835,0.72333336,0.5927835,0.7266667,0.5927835,0.73,0.5927835,0.73333335,0.5927835,0.7366667,0.5927835,0.74666667,0.5927835,0.75,0.5927835,0.75333333,0.5927835,0.75666666,0.5927835,0.76,0.5927835,0.7633333,0.5927835,0.76666665,0.5927835,0.77,0.5927835,0.7733333,0.5927835,0.80333334,0.5927835,0.8066667,0.5927835,0.81,0.5927835,0.81333333,0.5927835,0.81666666,0.5927835,0.82,0.5927835,0.8233333,0.5927835,0.8433333,0.5927835,0.8466667,0.5927835,0.85,0.5927835,0.85333335,0.5927835,0.8566667,0.5927835,0.86,0.5927835,0.86333334,0.5927835,0.8666667,0.5927835,0.87,0.5927835,0.87333333,0.5927835,0.87666667,0.5927835,0.88,0.5927835,0.8833333,0.5927835,0.88666666,0.5927835,0.89,0.5927835,0.8933333,0.5927835,0.89666665,0.5927835,0.9,0.5927835,0.9033333,0.5927835,0.9066667,0.5927835,0.06666667,0.5953608,0.07,0.5953608,0.07333333,0.5953608,0.07666667,0.5953608,0.08,0.5953608,0.083333336,0.5953608,0.086666666,0.5953608,0.09,0.5953608,0.093333334,0.5953608,0.096666664,0.5953608,0.1,0.5953608,0.10333333,0.5953608,0.10666667,0.5953608,0.11,0.5953608,0.13333334,0.5953608,0.13666667,0.5953608,0.14,0.5953608,0.14333333,0.5953608,0.14666666,0.5953608,0.15,0.5953608,0.15333334,0.5953608,0.15666667,0.5953608,0.16,0.5953608,0.16333333,0.5953608,0.16666667,0.5953608,0.17,0.5953608,0.17333333,0.5953608,0.17666666,0.5953608,0.19,0.5953608,0.19333333,0.5953608,0.19666667,0.5953608,0.2,0.5953608,0.20333333,0.5953608,0.20666666,0.5953608,0.21,0.5953608,0.21333334,0.5953608,0.21666667,0.5953608,0.22,0.5953608,0.22333333,0.5953608,0.22666667,0.5953608,0.23,0.5953608,0.23333333,0.5953608,0.23666666,0.5953608,0.24,0.5953608,0.24333334,0.5953608,0.24666667,0.5953608,0.25,0.5953608,0.25333333,0.5953608,0.25666666,0.5953608,0.26,0.5953608,0.26333332,0.5953608,0.26666668,0.5953608,0.27,0.5953608,0.27333334,0.5953608,0.27666667,0.5953608,0.28,0.5953608,0.28333333,0.5953608,0.28666666,0.5953608,0.29,0.5953608,0.29333332,0.5953608,0.29666665,0.5953608,0.3,0.5953608,0.32,0.5953608,0.32333332,0.5953608,0.32666665,0.5953608,0.33,0.5953608,0.33333334,0.5953608,0.33666667,0.5953608,0.34,0.5953608,0.34333333,0.5953608,0.36666667,0.5953608,0.37,0.5953608,0.37333333,0.5953608,0.37666667,0.5953608,0.38,0.5953608,0.38333333,0.5953608,0.38666666,0.5953608,0.39,0.5953608,0.39333335,0.5953608,0.39666668,0.5953608,0.4,0.5953608,0.40333334,0.5953608,0.43666667,0.5953608,0.44,0.5953608,0.44333333,0.5953608,0.44666666,0.5953608,0.45,0.5953608,0.45333335,0.5953608,0.45666668,0.5953608,0.46,0.5953608,0.46333334,0.5953608,0.46666667,0.5953608,0.47,0.5953608,0.47333333,0.5953608,0.47666666,0.5953608,0.48,0.5953608,0.48333332,0.5953608,0.48666668,0.5953608,0.49,0.5953608,0.49333334,0.5953608,0.49666667,0.5953608,0.5,0.5953608,0.50333333,0.5953608,0.50666666,0.5953608,0.51,0.5953608,0.5133333,0.5953608,0.51666665,0.5953608,0.52,0.5953608,0.5233333,0.5953608,0.52666664,0.5953608,0.53,0.5953608,0.53333336,0.5953608,0.5366667,0.5953608,0.54,0.5953608,0.54333335,0.5953608,0.5466667,0.5953608,0.55,0.5953608,0.55333334,0.5953608,0.5566667,0.5953608,0.56,0.5953608,0.56333333,0.5953608,0.56666666,0.5953608,0.57,0.5953608,0.5733333,0.5953608,0.57666665,0.5953608,0.58,0.5953608,0.5833333,0.5953608,0.58666664,0.5953608,0.59,0.5953608,0.5933333,0.5953608,0.5966667,0.5953608,0.6,0.5953608,0.60333335,0.5953608,0.6066667,0.5953608,0.61,0.5953608,0.61333334,0.5953608,0.6166667,0.5953608,0.62,0.5953608,0.62333333,0.5953608,0.6533333,0.5953608,0.6566667,0.5953608,0.66,0.5953608,0.66333336,0.5953608,0.6666667,0.5953608,0.67,0.5953608,0.67333335,0.5953608,0.6766667,0.5953608,0.68,0.5953608,0.68333334,0.5953608,0.68666667,0.5953608,0.69,0.5953608,0.6933333,0.5953608,0.69666666,0.5953608,0.7,0.5953608,0.7033333,0.5953608,0.70666665,0.5953608,0.71,0.5953608,0.7133333,0.5953608,0.71666664,0.5953608,0.72,0.5953608,0.72333336,0.5953608,0.7266667,0.5953608,0.73,0.5953608,0.73333335,0.5953608,0.7366667,0.5953608,0.75,0.5953608,0.75333333,0.5953608,0.75666666,0.5953608,0.76,0.5953608,0.7633333,0.5953608,0.76666665,0.5953608,0.7866667,0.5953608,0.79,0.5953608,0.80333334,0.5953608,0.8066667,0.5953608,0.81,0.5953608,0.81333333,0.5953608,0.81666666,0.5953608,0.82,0.5953608,0.8433333,0.5953608,0.8466667,0.5953608,0.85,0.5953608,0.85333335,0.5953608,0.8566667,0.5953608,0.86,0.5953608,0.86333334,0.5953608,0.8666667,0.5953608,0.87,0.5953608,0.87333333,0.5953608,0.87666667,0.5953608,0.88,0.5953608,0.8833333,0.5953608,0.88666666,0.5953608,0.89,0.5953608,0.8933333,0.5953608,0.89666665,0.5953608,0.9,0.5953608,0.9033333,0.5953608,0.9066667,0.5953608,0.06333333,0.5979381,0.06666667,0.5979381,0.07,0.5979381,0.07333333,0.5979381,0.07666667,0.5979381,0.08,0.5979381,0.083333336,0.5979381,0.086666666,0.5979381,0.09,0.5979381,0.093333334,0.5979381,0.096666664,0.5979381,0.1,0.5979381,0.10333333,0.5979381,0.10666667,0.5979381,0.11,0.5979381,0.11333334,0.5979381,0.11666667,0.5979381,0.12,0.5979381,0.123333335,0.5979381,0.12666667,0.5979381,0.13,0.5979381,0.13333334,0.5979381,0.13666667,0.5979381,0.14,0.5979381,0.14333333,0.5979381,0.14666666,0.5979381,0.15,0.5979381,0.15333334,0.5979381,0.15666667,0.5979381,0.16,0.5979381,0.16333333,0.5979381,0.16666667,0.5979381,0.17,0.5979381,0.17333333,0.5979381,0.17666666,0.5979381,0.18,0.5979381,0.18333334,0.5979381,0.18666667,0.5979381,0.19,0.5979381,0.19333333,0.5979381,0.19666667,0.5979381,0.2,0.5979381,0.20333333,0.5979381,0.20666666,0.5979381,0.21,0.5979381,0.21333334,0.5979381,0.21666667,0.5979381,0.22,0.5979381,0.22333333,0.5979381,0.22666667,0.5979381,0.23,0.5979381,0.23333333,0.5979381,0.23666666,0.5979381,0.24,0.5979381,0.24333334,0.5979381,0.24666667,0.5979381,0.25,0.5979381,0.25333333,0.5979381,0.25666666,0.5979381,0.26,0.5979381,0.26333332,0.5979381,0.26666668,0.5979381,0.27,0.5979381,0.27333334,0.5979381,0.27666667,0.5979381,0.28,0.5979381,0.28333333,0.5979381,0.28666666,0.5979381,0.29,0.5979381,0.29333332,0.5979381,0.30333334,0.5979381,0.30666667,0.5979381,0.31,0.5979381,0.32666665,0.5979381,0.33,0.5979381,0.33333334,0.5979381,0.33666667,0.5979381,0.34,0.5979381,0.34333333,0.5979381,0.36666667,0.5979381,0.37,0.5979381,0.37333333,0.5979381,0.37666667,0.5979381,0.38,0.5979381,0.38333333,0.5979381,0.38666666,0.5979381,0.39,0.5979381,0.39333335,0.5979381,0.39666668,0.5979381,0.4,0.5979381,0.40333334,0.5979381,0.40666667,0.5979381,0.43666667,0.5979381,0.44,0.5979381,0.44333333,0.5979381,0.44666666,0.5979381,0.45,0.5979381,0.45333335,0.5979381,0.45666668,0.5979381,0.46,0.5979381,0.46333334,0.5979381,0.46666667,0.5979381,0.47,0.5979381,0.47333333,0.5979381,0.47666666,0.5979381,0.48333332,0.5979381,0.5366667,0.5979381,0.54,0.5979381,0.54333335,0.5979381,0.5466667,0.5979381,0.55,0.5979381,0.55333334,0.5979381,0.5566667,0.5979381,0.56,0.5979381,0.56333333,0.5979381,0.56666666,0.5979381,0.57,0.5979381,0.5733333,0.5979381,0.57666665,0.5979381,0.58,0.5979381,0.5833333,0.5979381,0.58666664,0.5979381,0.59,0.5979381,0.5933333,0.5979381,0.5966667,0.5979381,0.6,0.5979381,0.60333335,0.5979381,0.6066667,0.5979381,0.61,0.5979381,0.61333334,0.5979381,0.6166667,0.5979381,0.62,0.5979381,0.62333333,0.5979381,0.6533333,0.5979381,0.6566667,0.5979381,0.66,0.5979381,0.66333336,0.5979381,0.6666667,0.5979381,0.67,0.5979381,0.67333335,0.5979381,0.6766667,0.5979381,0.68,0.5979381,0.68333334,0.5979381,0.68666667,0.5979381,0.69,0.5979381,0.6933333,0.5979381,0.69666666,0.5979381,0.7,0.5979381,0.7033333,0.5979381,0.70666665,0.5979381,0.71,0.5979381,0.7133333,0.5979381,0.71666664,0.5979381,0.72,0.5979381,0.72333336,0.5979381,0.7266667,0.5979381,0.73,0.5979381,0.73333335,0.5979381,0.7366667,0.5979381,0.74,0.5979381,0.74333334,0.5979381,0.75333333,0.5979381,0.75666666,0.5979381,0.76,0.5979381,0.7633333,0.5979381,0.8066667,0.5979381,0.81,0.5979381,0.81333333,0.5979381,0.81666666,0.5979381,0.8466667,0.5979381,0.85,0.5979381,0.85333335,0.5979381,0.8566667,0.5979381,0.86,0.5979381,0.86333334,0.5979381,0.8666667,0.5979381,0.87,0.5979381,0.87333333,0.5979381,0.87666667,0.5979381,0.88,0.5979381,0.8833333,0.5979381,0.88666666,0.5979381,0.89,0.5979381,0.8933333,0.5979381,0.89666665,0.5979381,0.9,0.5979381,0.9033333,0.5979381,0.9066667,0.5979381,0.06333333,0.6005155,0.06666667,0.6005155,0.07,0.6005155,0.07333333,0.6005155,0.07666667,0.6005155,0.08,0.6005155,0.083333336,0.6005155,0.086666666,0.6005155,0.09,0.6005155,0.093333334,0.6005155,0.096666664,0.6005155,0.1,0.6005155,0.10333333,0.6005155,0.10666667,0.6005155,0.11,0.6005155,0.11333334,0.6005155,0.11666667,0.6005155,0.12,0.6005155,0.123333335,0.6005155,0.12666667,0.6005155,0.13,0.6005155,0.13333334,0.6005155,0.13666667,0.6005155,0.14,0.6005155,0.14333333,0.6005155,0.14666666,0.6005155,0.15,0.6005155,0.15333334,0.6005155,0.15666667,0.6005155,0.16,0.6005155,0.16333333,0.6005155,0.16666667,0.6005155,0.17,0.6005155,0.17333333,0.6005155,0.17666666,0.6005155,0.18,0.6005155,0.18333334,0.6005155,0.18666667,0.6005155,0.19,0.6005155,0.19333333,0.6005155,0.19666667,0.6005155,0.2,0.6005155,0.20333333,0.6005155,0.20666666,0.6005155,0.21,0.6005155,0.21333334,0.6005155,0.21666667,0.6005155,0.22,0.6005155,0.22333333,0.6005155,0.22666667,0.6005155,0.23,0.6005155,0.23333333,0.6005155,0.23666666,0.6005155,0.24,0.6005155,0.24333334,0.6005155,0.24666667,0.6005155,0.25,0.6005155,0.25333333,0.6005155,0.25666666,0.6005155,0.26,0.6005155,0.26333332,0.6005155,0.26666668,0.6005155,0.27,0.6005155,0.27333334,0.6005155,0.27666667,0.6005155,0.28,0.6005155,0.28333333,0.6005155,0.28666666,0.6005155,0.30666667,0.6005155,0.31,0.6005155,0.33,0.6005155,0.33333334,0.6005155,0.33666667,0.6005155,0.34,0.6005155,0.34333333,0.6005155,0.36666667,0.6005155,0.37,0.6005155,0.37333333,0.6005155,0.37666667,0.6005155,0.38,0.6005155,0.38333333,0.6005155,0.38666666,0.6005155,0.39,0.6005155,0.39333335,0.6005155,0.39666668,0.6005155,0.4,0.6005155,0.40333334,0.6005155,0.40666667,0.6005155,0.41,0.6005155,0.43333334,0.6005155,0.43666667,0.6005155,0.44,0.6005155,0.44333333,0.6005155,0.44666666,0.6005155,0.45,0.6005155,0.54,0.6005155,0.54333335,0.6005155,0.5466667,0.6005155,0.55,0.6005155,0.55333334,0.6005155,0.5566667,0.6005155,0.56,0.6005155,0.56333333,0.6005155,0.56666666,0.6005155,0.57,0.6005155,0.5733333,0.6005155,0.57666665,0.6005155,0.58,0.6005155,0.5833333,0.6005155,0.58666664,0.6005155,0.59,0.6005155,0.5933333,0.6005155,0.5966667,0.6005155,0.6,0.6005155,0.60333335,0.6005155,0.6066667,0.6005155,0.61,0.6005155,0.61333334,0.6005155,0.6166667,0.6005155,0.65,0.6005155,0.6533333,0.6005155,0.6566667,0.6005155,0.66,0.6005155,0.66333336,0.6005155,0.6666667,0.6005155,0.67,0.6005155,0.67333335,0.6005155,0.6766667,0.6005155,0.68,0.6005155,0.68333334,0.6005155,0.68666667,0.6005155,0.69,0.6005155,0.6933333,0.6005155,0.69666666,0.6005155,0.7,0.6005155,0.7033333,0.6005155,0.70666665,0.6005155,0.71,0.6005155,0.7133333,0.6005155,0.71666664,0.6005155,0.72,0.6005155,0.72333336,0.6005155,0.85333335,0.6005155,0.8566667,0.6005155,0.86,0.6005155,0.86333334,0.6005155,0.8666667,0.6005155,0.87,0.6005155,0.87333333,0.6005155,0.87666667,0.6005155,0.88,0.6005155,0.8833333,0.6005155,0.88666666,0.6005155,0.89,0.6005155,0.8933333,0.6005155,0.89666665,0.6005155,0.9,0.6005155,0.06,0.6030928,0.06333333,0.6030928,0.06666667,0.6030928,0.07,0.6030928,0.07333333,0.6030928,0.07666667,0.6030928,0.08,0.6030928,0.083333336,0.6030928,0.086666666,0.6030928,0.09,0.6030928,0.093333334,0.6030928,0.096666664,0.6030928,0.1,0.6030928,0.10333333,0.6030928,0.10666667,0.6030928,0.11,0.6030928,0.11333334,0.6030928,0.11666667,0.6030928,0.12,0.6030928,0.123333335,0.6030928,0.12666667,0.6030928,0.13,0.6030928,0.13333334,0.6030928,0.13666667,0.6030928,0.14,0.6030928,0.14333333,0.6030928,0.14666666,0.6030928,0.15,0.6030928,0.15333334,0.6030928,0.15666667,0.6030928,0.16,0.6030928,0.16333333,0.6030928,0.16666667,0.6030928,0.17,0.6030928,0.17333333,0.6030928,0.17666666,0.6030928,0.18,0.6030928,0.18333334,0.6030928,0.18666667,0.6030928,0.19,0.6030928,0.19333333,0.6030928,0.19666667,0.6030928,0.2,0.6030928,0.20333333,0.6030928,0.20666666,0.6030928,0.21,0.6030928,0.21333334,0.6030928,0.21666667,0.6030928,0.22,0.6030928,0.22333333,0.6030928,0.22666667,0.6030928,0.23,0.6030928,0.23333333,0.6030928,0.23666666,0.6030928,0.24,0.6030928,0.24333334,0.6030928,0.24666667,0.6030928,0.25,0.6030928,0.25333333,0.6030928,0.25666666,0.6030928,0.26,0.6030928,0.26333332,0.6030928,0.26666668,0.6030928,0.27,0.6030928,0.27333334,0.6030928,0.27666667,0.6030928,0.28,0.6030928,0.33,0.6030928,0.33333334,0.6030928,0.33666667,0.6030928,0.34,0.6030928,0.34333333,0.6030928,0.36666667,0.6030928,0.37,0.6030928,0.37333333,0.6030928,0.37666667,0.6030928,0.38,0.6030928,0.38333333,0.6030928,0.38666666,0.6030928,0.39,0.6030928,0.39333335,0.6030928,0.39666668,0.6030928,0.4,0.6030928,0.40333334,0.6030928,0.40666667,0.6030928,0.41,0.6030928,0.41333333,0.6030928,0.41666666,0.6030928,0.42,0.6030928,0.42666668,0.6030928,0.43,0.6030928,0.43333334,0.6030928,0.43666667,0.6030928,0.44,0.6030928,0.44333333,0.6030928,0.44666666,0.6030928,0.45,0.6030928,0.54,0.6030928,0.54333335,0.6030928,0.5466667,0.6030928,0.55,0.6030928,0.55333334,0.6030928,0.5566667,0.6030928,0.56,0.6030928,0.56333333,0.6030928,0.56666666,0.6030928,0.57,0.6030928,0.5733333,0.6030928,0.57666665,0.6030928,0.58,0.6030928,0.5833333,0.6030928,0.58666664,0.6030928,0.59,0.6030928,0.5933333,0.6030928,0.5966667,0.6030928,0.6,0.6030928,0.60333335,0.6030928,0.65,0.6030928,0.6533333,0.6030928,0.6566667,0.6030928,0.66,0.6030928,0.66333336,0.6030928,0.6666667,0.6030928,0.67,0.6030928,0.67333335,0.6030928,0.6766667,0.6030928,0.68,0.6030928,0.68333334,0.6030928,0.68666667,0.6030928,0.69,0.6030928,0.6933333,0.6030928,0.69666666,0.6030928,0.7,0.6030928,0.7033333,0.6030928,0.70666665,0.6030928,0.72,0.6030928,0.85333335,0.6030928,0.8566667,0.6030928,0.86,0.6030928,0.86333334,0.6030928,0.8666667,0.6030928,0.87,0.6030928,0.87333333,0.6030928,0.87666667,0.6030928,0.88,0.6030928,0.8833333,0.6030928,0.88666666,0.6030928,0.89,0.6030928,0.06,0.6056701,0.06333333,0.6056701,0.06666667,0.6056701,0.07,0.6056701,0.07333333,0.6056701,0.07666667,0.6056701,0.08,0.6056701,0.083333336,0.6056701,0.086666666,0.6056701,0.09,0.6056701,0.093333334,0.6056701,0.096666664,0.6056701,0.1,0.6056701,0.10333333,0.6056701,0.10666667,0.6056701,0.11,0.6056701,0.11333334,0.6056701,0.11666667,0.6056701,0.12,0.6056701,0.123333335,0.6056701,0.12666667,0.6056701,0.13,0.6056701,0.13333334,0.6056701,0.13666667,0.6056701,0.14,0.6056701,0.14333333,0.6056701,0.14666666,0.6056701,0.15,0.6056701,0.15333334,0.6056701,0.15666667,0.6056701,0.16,0.6056701,0.16333333,0.6056701,0.16666667,0.6056701,0.17,0.6056701,0.17333333,0.6056701,0.17666666,0.6056701,0.18,0.6056701,0.18333334,0.6056701,0.18666667,0.6056701,0.19,0.6056701,0.19333333,0.6056701,0.19666667,0.6056701,0.2,0.6056701,0.20333333,0.6056701,0.20666666,0.6056701,0.21,0.6056701,0.21333334,0.6056701,0.21666667,0.6056701,0.22,0.6056701,0.22333333,0.6056701,0.22666667,0.6056701,0.23,0.6056701,0.23333333,0.6056701,0.23666666,0.6056701,0.24,0.6056701,0.24333334,0.6056701,0.24666667,0.6056701,0.25,0.6056701,0.25333333,0.6056701,0.25666666,0.6056701,0.26,0.6056701,0.26333332,0.6056701,0.26666668,0.6056701,0.27,0.6056701,0.27333334,0.6056701,0.32666665,0.6056701,0.33,0.6056701,0.33333334,0.6056701,0.33666667,0.6056701,0.34,0.6056701,0.34333333,0.6056701,0.36666667,0.6056701,0.37,0.6056701,0.37333333,0.6056701,0.37666667,0.6056701,0.38,0.6056701,0.38333333,0.6056701,0.38666666,0.6056701,0.39,0.6056701,0.39333335,0.6056701,0.39666668,0.6056701,0.4,0.6056701,0.40333334,0.6056701,0.40666667,0.6056701,0.41,0.6056701,0.41333333,0.6056701,0.41666666,0.6056701,0.42,0.6056701,0.42333335,0.6056701,0.42666668,0.6056701,0.43,0.6056701,0.43333334,0.6056701,0.43666667,0.6056701,0.44,0.6056701,0.44333333,0.6056701,0.44666666,0.6056701,0.54333335,0.6056701,0.5466667,0.6056701,0.55,0.6056701,0.55333334,0.6056701,0.5566667,0.6056701,0.56,0.6056701,0.56333333,0.6056701,0.56666666,0.6056701,0.57,0.6056701,0.5733333,0.6056701,0.57666665,0.6056701,0.58,0.6056701,0.5833333,0.6056701,0.58666664,0.6056701,0.59,0.6056701,0.5933333,0.6056701,0.65,0.6056701,0.6533333,0.6056701,0.6566667,0.6056701,0.66,0.6056701,0.66333336,0.6056701,0.6666667,0.6056701,0.67,0.6056701,0.67333335,0.6056701,0.6766667,0.6056701,0.68,0.6056701,0.68333334,0.6056701,0.68666667,0.6056701,0.69,0.6056701,0.6933333,0.6056701,0.69666666,0.6056701,0.7,0.6056701,0.8566667,0.6056701,0.86,0.6056701,0.86333334,0.6056701,0.8666667,0.6056701,0.87,0.6056701,0.87333333,0.6056701,0.05666667,0.6082474,0.06,0.6082474,0.06333333,0.6082474,0.06666667,0.6082474,0.07,0.6082474,0.07333333,0.6082474,0.07666667,0.6082474,0.08,0.6082474,0.083333336,0.6082474,0.086666666,0.6082474,0.09,0.6082474,0.093333334,0.6082474,0.096666664,0.6082474,0.1,0.6082474,0.10333333,0.6082474,0.10666667,0.6082474,0.11,0.6082474,0.11333334,0.6082474,0.11666667,0.6082474,0.12,0.6082474,0.123333335,0.6082474,0.12666667,0.6082474,0.13,0.6082474,0.13333334,0.6082474,0.13666667,0.6082474,0.14,0.6082474,0.14333333,0.6082474,0.14666666,0.6082474,0.15,0.6082474,0.15333334,0.6082474,0.15666667,0.6082474,0.16,0.6082474,0.16333333,0.6082474,0.16666667,0.6082474,0.17,0.6082474,0.17333333,0.6082474,0.17666666,0.6082474,0.18,0.6082474,0.18333334,0.6082474,0.18666667,0.6082474,0.19,0.6082474,0.19333333,0.6082474,0.19666667,0.6082474,0.2,0.6082474,0.20333333,0.6082474,0.20666666,0.6082474,0.21,0.6082474,0.21333334,0.6082474,0.21666667,0.6082474,0.22,0.6082474,0.22333333,0.6082474,0.22666667,0.6082474,0.23,0.6082474,0.23333333,0.6082474,0.23666666,0.6082474,0.24,0.6082474,0.24333334,0.6082474,0.24666667,0.6082474,0.25,0.6082474,0.25333333,0.6082474,0.25666666,0.6082474,0.26,0.6082474,0.26333332,0.6082474,0.26666668,0.6082474,0.27,0.6082474,0.31666666,0.6082474,0.32333332,0.6082474,0.32666665,0.6082474,0.33,0.6082474,0.33333334,0.6082474,0.33666667,0.6082474,0.34,0.6082474,0.34333333,0.6082474,0.37,0.6082474,0.37333333,0.6082474,0.37666667,0.6082474,0.38,0.6082474,0.38333333,0.6082474,0.38666666,0.6082474,0.39,0.6082474,0.39333335,0.6082474,0.39666668,0.6082474,0.4,0.6082474,0.40333334,0.6082474,0.40666667,0.6082474,0.41,0.6082474,0.41333333,0.6082474,0.41666666,0.6082474,0.42,0.6082474,0.42333335,0.6082474,0.42666668,0.6082474,0.43,0.6082474,0.43333334,0.6082474,0.43666667,0.6082474,0.44,0.6082474,0.44333333,0.6082474,0.54333335,0.6082474,0.5466667,0.6082474,0.55,0.6082474,0.55333334,0.6082474,0.5566667,0.6082474,0.56,0.6082474,0.56333333,0.6082474,0.56666666,0.6082474,0.57,0.6082474,0.5733333,0.6082474,0.57666665,0.6082474,0.58,0.6082474,0.5833333,0.6082474,0.58666664,0.6082474,0.59,0.6082474,0.65,0.6082474,0.6533333,0.6082474,0.6566667,0.6082474,0.66,0.6082474,0.66333336,0.6082474,0.6666667,0.6082474,0.67,0.6082474,0.67333335,0.6082474,0.6766667,0.6082474,0.68,0.6082474,0.68333334,0.6082474,0.68666667,0.6082474,0.69,0.6082474,0.6933333,0.6082474,0.69666666,0.6082474,0.8566667,0.6082474,0.86,0.6082474,0.86333334,0.6082474,0.8666667,0.6082474,0.87,0.6082474,0.05666667,0.61082476,0.06,0.61082476,0.06333333,0.61082476,0.06666667,0.61082476,0.07,0.61082476,0.07333333,0.61082476,0.07666667,0.61082476,0.08,0.61082476,0.083333336,0.61082476,0.086666666,0.61082476,0.09,0.61082476,0.093333334,0.61082476,0.096666664,0.61082476,0.1,0.61082476,0.10333333,0.61082476,0.10666667,0.61082476,0.11,0.61082476,0.11333334,0.61082476,0.11666667,0.61082476,0.12,0.61082476,0.123333335,0.61082476,0.12666667,0.61082476,0.13,0.61082476,0.13333334,0.61082476,0.13666667,0.61082476,0.14,0.61082476,0.14333333,0.61082476,0.14666666,0.61082476,0.15,0.61082476,0.15333334,0.61082476,0.15666667,0.61082476,0.16,0.61082476,0.16333333,0.61082476,0.16666667,0.61082476,0.17,0.61082476,0.17333333,0.61082476,0.17666666,0.61082476,0.18,0.61082476,0.18333334,0.61082476,0.18666667,0.61082476,0.19,0.61082476,0.19333333,0.61082476,0.19666667,0.61082476,0.2,0.61082476,0.20333333,0.61082476,0.20666666,0.61082476,0.21,0.61082476,0.21333334,0.61082476,0.21666667,0.61082476,0.22,0.61082476,0.22333333,0.61082476,0.22666667,0.61082476,0.23,0.61082476,0.23333333,0.61082476,0.23666666,0.61082476,0.24,0.61082476,0.24333334,0.61082476,0.24666667,0.61082476,0.25,0.61082476,0.25333333,0.61082476,0.25666666,0.61082476,0.26,0.61082476,0.26333332,0.61082476,0.26666668,0.61082476,0.32,0.61082476,0.32333332,0.61082476,0.32666665,0.61082476,0.33,0.61082476,0.33333334,0.61082476,0.33666667,0.61082476,0.34,0.61082476,0.34333333,0.61082476,0.37,0.61082476,0.37333333,0.61082476,0.37666667,0.61082476,0.38,0.61082476,0.38333333,0.61082476,0.38666666,0.61082476,0.39,0.61082476,0.39333335,0.61082476,0.39666668,0.61082476,0.4,0.61082476,0.40333334,0.61082476,0.40666667,0.61082476,0.41,0.61082476,0.41333333,0.61082476,0.41666666,0.61082476,0.42,0.61082476,0.42333335,0.61082476,0.42666668,0.61082476,0.43,0.61082476,0.43333334,0.61082476,0.43666667,0.61082476,0.44,0.61082476,0.44333333,0.61082476,0.5466667,0.61082476,0.55,0.61082476,0.55333334,0.61082476,0.5566667,0.61082476,0.56,0.61082476,0.56333333,0.61082476,0.56666666,0.61082476,0.57,0.61082476,0.5733333,0.61082476,0.57666665,0.61082476,0.58,0.61082476,0.5833333,0.61082476,0.58666664,0.61082476,0.65,0.61082476,0.6533333,0.61082476,0.6566667,0.61082476,0.66,0.61082476,0.66333336,0.61082476,0.6666667,0.61082476,0.67,0.61082476,0.67333335,0.61082476,0.6766667,0.61082476,0.68,0.61082476,0.68333334,0.61082476,0.68666667,0.61082476,0.69,0.61082476,0.6933333,0.61082476,0.8566667,0.61082476,0.86,0.61082476,0.86333334,0.61082476,0.8666667,0.61082476,0.05666667,0.61340207,0.06,0.61340207,0.06333333,0.61340207,0.06666667,0.61340207,0.07,0.61340207,0.07333333,0.61340207,0.07666667,0.61340207,0.08,0.61340207,0.083333336,0.61340207,0.086666666,0.61340207,0.09,0.61340207,0.093333334,0.61340207,0.096666664,0.61340207,0.1,0.61340207,0.10333333,0.61340207,0.10666667,0.61340207,0.11,0.61340207,0.11333334,0.61340207,0.11666667,0.61340207,0.12,0.61340207,0.123333335,0.61340207,0.12666667,0.61340207,0.13,0.61340207,0.13333334,0.61340207,0.13666667,0.61340207,0.14,0.61340207,0.14333333,0.61340207,0.14666666,0.61340207,0.15,0.61340207,0.15333334,0.61340207,0.15666667,0.61340207,0.16,0.61340207,0.16333333,0.61340207,0.16666667,0.61340207,0.17,0.61340207,0.17333333,0.61340207,0.17666666,0.61340207,0.18,0.61340207,0.18333334,0.61340207,0.18666667,0.61340207,0.19,0.61340207,0.19333333,0.61340207,0.19666667,0.61340207,0.2,0.61340207,0.20333333,0.61340207,0.20666666,0.61340207,0.21,0.61340207,0.21333334,0.61340207,0.21666667,0.61340207,0.22,0.61340207,0.22333333,0.61340207,0.22666667,0.61340207,0.23,0.61340207,0.23333333,0.61340207,0.23666666,0.61340207,0.24,0.61340207,0.24333334,0.61340207,0.24666667,0.61340207,0.25,0.61340207,0.25333333,0.61340207,0.25666666,0.61340207,0.31666666,0.61340207,0.32,0.61340207,0.32333332,0.61340207,0.32666665,0.61340207,0.33,0.61340207,0.33333334,0.61340207,0.33666667,0.61340207,0.34,0.61340207,0.34333333,0.61340207,0.37666667,0.61340207,0.38,0.61340207,0.38333333,0.61340207,0.38666666,0.61340207,0.39,0.61340207,0.39333335,0.61340207,0.39666668,0.61340207,0.4,0.61340207,0.40333334,0.61340207,0.40666667,0.61340207,0.41,0.61340207,0.41333333,0.61340207,0.41666666,0.61340207,0.42,0.61340207,0.42333335,0.61340207,0.42666668,0.61340207,0.43,0.61340207,0.43333334,0.61340207,0.43666667,0.61340207,0.44,0.61340207,0.55,0.61340207,0.55333334,0.61340207,0.5566667,0.61340207,0.56,0.61340207,0.56333333,0.61340207,0.56666666,0.61340207,0.57,0.61340207,0.5733333,0.61340207,0.57666665,0.61340207,0.58,0.61340207,0.5833333,0.61340207,0.58666664,0.61340207,0.65,0.61340207,0.6533333,0.61340207,0.6566667,0.61340207,0.66,0.61340207,0.66333336,0.61340207,0.6666667,0.61340207,0.67,0.61340207,0.67333335,0.61340207,0.6766667,0.61340207,0.68,0.61340207,0.68333334,0.61340207,0.68666667,0.61340207,0.69,0.61340207,0.6933333,0.61340207,0.8566667,0.61340207,0.86,0.61340207,0.86333334,0.61340207,0.05666667,0.6159794,0.06,0.6159794,0.06333333,0.6159794,0.06666667,0.6159794,0.07,0.6159794,0.07333333,0.6159794,0.07666667,0.6159794,0.08,0.6159794,0.083333336,0.6159794,0.086666666,0.6159794,0.09,0.6159794,0.093333334,0.6159794,0.096666664,0.6159794,0.1,0.6159794,0.10333333,0.6159794,0.10666667,0.6159794,0.11,0.6159794,0.11333334,0.6159794,0.11666667,0.6159794,0.12,0.6159794,0.123333335,0.6159794,0.12666667,0.6159794,0.13,0.6159794,0.13333334,0.6159794,0.13666667,0.6159794,0.14,0.6159794,0.14333333,0.6159794,0.14666666,0.6159794,0.15,0.6159794,0.15333334,0.6159794,0.15666667,0.6159794,0.16,0.6159794,0.16333333,0.6159794,0.16666667,0.6159794,0.17,0.6159794,0.17333333,0.6159794,0.17666666,0.6159794,0.18,0.6159794,0.18333334,0.6159794,0.18666667,0.6159794,0.19,0.6159794,0.19333333,0.6159794,0.19666667,0.6159794,0.2,0.6159794,0.20333333,0.6159794,0.20666666,0.6159794,0.21,0.6159794,0.21333334,0.6159794,0.21666667,0.6159794,0.22,0.6159794,0.22333333,0.6159794,0.22666667,0.6159794,0.23,0.6159794,0.23333333,0.6159794,0.23666666,0.6159794,0.24,0.6159794,0.24333334,0.6159794,0.24666667,0.6159794,0.25,0.6159794,0.31,0.6159794,0.31333333,0.6159794,0.31666666,0.6159794,0.32,0.6159794,0.32333332,0.6159794,0.32666665,0.6159794,0.33,0.6159794,0.33333334,0.6159794,0.33666667,0.6159794,0.34,0.6159794,0.38333333,0.6159794,0.38666666,0.6159794,0.39,0.6159794,0.39333335,0.6159794,0.39666668,0.6159794,0.4,0.6159794,0.40333334,0.6159794,0.40666667,0.6159794,0.41,0.6159794,0.41333333,0.6159794,0.41666666,0.6159794,0.42,0.6159794,0.42333335,0.6159794,0.42666668,0.6159794,0.43,0.6159794,0.43333334,0.6159794,0.43666667,0.6159794,0.55,0.6159794,0.55333334,0.6159794,0.5566667,0.6159794,0.56,0.6159794,0.56333333,0.6159794,0.56666666,0.6159794,0.57,0.6159794,0.5733333,0.6159794,0.57666665,0.6159794,0.58,0.6159794,0.5833333,0.6159794,0.58666664,0.6159794,0.59,0.6159794,0.6533333,0.6159794,0.6566667,0.6159794,0.66,0.6159794,0.66333336,0.6159794,0.6666667,0.6159794,0.67,0.6159794,0.67333335,0.6159794,0.6766667,0.6159794,0.68,0.6159794,0.68333334,0.6159794,0.68666667,0.6159794,0.69,0.6159794,0.6933333,0.6159794,0.85333335,0.6159794,0.8566667,0.6159794,0.86,0.6159794,0.86333334,0.6159794,0.05666667,0.6185567,0.06,0.6185567,0.06333333,0.6185567,0.06666667,0.6185567,0.07,0.6185567,0.07333333,0.6185567,0.07666667,0.6185567,0.08,0.6185567,0.083333336,0.6185567,0.086666666,0.6185567,0.09,0.6185567,0.093333334,0.6185567,0.096666664,0.6185567,0.1,0.6185567,0.10333333,0.6185567,0.10666667,0.6185567,0.11,0.6185567,0.11333334,0.6185567,0.11666667,0.6185567,0.12,0.6185567,0.123333335,0.6185567,0.12666667,0.6185567,0.13,0.6185567,0.13333334,0.6185567,0.13666667,0.6185567,0.14,0.6185567,0.14333333,0.6185567,0.14666666,0.6185567,0.15,0.6185567,0.15333334,0.6185567,0.15666667,0.6185567,0.16,0.6185567,0.16333333,0.6185567,0.16666667,0.6185567,0.17,0.6185567,0.17333333,0.6185567,0.17666666,0.6185567,0.18,0.6185567,0.18333334,0.6185567,0.18666667,0.6185567,0.19,0.6185567,0.19333333,0.6185567,0.19666667,0.6185567,0.2,0.6185567,0.20333333,0.6185567,0.20666666,0.6185567,0.21,0.6185567,0.21333334,0.6185567,0.21666667,0.6185567,0.22,0.6185567,0.22333333,0.6185567,0.22666667,0.6185567,0.23,0.6185567,0.23333333,0.6185567,0.23666666,0.6185567,0.24,0.6185567,0.30666667,0.6185567,0.31,0.6185567,0.31333333,0.6185567,0.31666666,0.6185567,0.32,0.6185567,0.32333332,0.6185567,0.32666665,0.6185567,0.33,0.6185567,0.33333334,0.6185567,0.33666667,0.6185567,0.34,0.6185567,0.39333335,0.6185567,0.39666668,0.6185567,0.4,0.6185567,0.40333334,0.6185567,0.40666667,0.6185567,0.41,0.6185567,0.41333333,0.6185567,0.41666666,0.6185567,0.42,0.6185567,0.42333335,0.6185567,0.42666668,0.6185567,0.43,0.6185567,0.43333334,0.6185567,0.43666667,0.6185567,0.5566667,0.6185567,0.56,0.6185567,0.56333333,0.6185567,0.56666666,0.6185567,0.57,0.6185567,0.5733333,0.6185567,0.57666665,0.6185567,0.58,0.6185567,0.5833333,0.6185567,0.58666664,0.6185567,0.59,0.6185567,0.5933333,0.6185567,0.5966667,0.6185567,0.66,0.6185567,0.66333336,0.6185567,0.6666667,0.6185567,0.67,0.6185567,0.67333335,0.6185567,0.6766667,0.6185567,0.68,0.6185567,0.68333334,0.6185567,0.68666667,0.6185567,0.69,0.6185567,0.6933333,0.6185567,0.8433333,0.6185567,0.8466667,0.6185567,0.85,0.6185567,0.85333335,0.6185567,0.8566667,0.6185567,0.86,0.6185567,0.86333334,0.6185567,0.05666667,0.62113404,0.06,0.62113404,0.06333333,0.62113404,0.06666667,0.62113404,0.07,0.62113404,0.07333333,0.62113404,0.07666667,0.62113404,0.08,0.62113404,0.083333336,0.62113404,0.086666666,0.62113404,0.09,0.62113404,0.093333334,0.62113404,0.096666664,0.62113404,0.1,0.62113404,0.10333333,0.62113404,0.10666667,0.62113404,0.11,0.62113404,0.11333334,0.62113404,0.11666667,0.62113404,0.12,0.62113404,0.123333335,0.62113404,0.12666667,0.62113404,0.13,0.62113404,0.13333334,0.62113404,0.13666667,0.62113404,0.14,0.62113404,0.14333333,0.62113404,0.14666666,0.62113404,0.15,0.62113404,0.15333334,0.62113404,0.15666667,0.62113404,0.16,0.62113404,0.16333333,0.62113404,0.16666667,0.62113404,0.17,0.62113404,0.17333333,0.62113404,0.17666666,0.62113404,0.18,0.62113404,0.18333334,0.62113404,0.18666667,0.62113404,0.19,0.62113404,0.19333333,0.62113404,0.19666667,0.62113404,0.2,0.62113404,0.20333333,0.62113404,0.20666666,0.62113404,0.21,0.62113404,0.21333334,0.62113404,0.21666667,0.62113404,0.22,0.62113404,0.22333333,0.62113404,0.22666667,0.62113404,0.23,0.62113404,0.30333334,0.62113404,0.30666667,0.62113404,0.31,0.62113404,0.31333333,0.62113404,0.31666666,0.62113404,0.32,0.62113404,0.32333332,0.62113404,0.32666665,0.62113404,0.33,0.62113404,0.33333334,0.62113404,0.33666667,0.62113404,0.39333335,0.62113404,0.39666668,0.62113404,0.4,0.62113404,0.40333334,0.62113404,0.40666667,0.62113404,0.41,0.62113404,0.41333333,0.62113404,0.41666666,0.62113404,0.42,0.62113404,0.42333335,0.62113404,0.42666668,0.62113404,0.43,0.62113404,0.43333334,0.62113404,0.57666665,0.62113404,0.58,0.62113404,0.5833333,0.62113404,0.58666664,0.62113404,0.59,0.62113404,0.5933333,0.62113404,0.5966667,0.62113404,0.6,0.62113404,0.60333335,0.62113404,0.6066667,0.62113404,0.6666667,0.62113404,0.67,0.62113404,0.67333335,0.62113404,0.6766667,0.62113404,0.68,0.62113404,0.68333334,0.62113404,0.68666667,0.62113404,0.69,0.62113404,0.6933333,0.62113404,0.84,0.62113404,0.8433333,0.62113404,0.8466667,0.62113404,0.85,0.62113404,0.85333335,0.62113404,0.8566667,0.62113404,0.86,0.62113404,0.86333334,0.62113404,0.05666667,0.62371135,0.06,0.62371135,0.06333333,0.62371135,0.06666667,0.62371135,0.07,0.62371135,0.07333333,0.62371135,0.07666667,0.62371135,0.08,0.62371135,0.083333336,0.62371135,0.086666666,0.62371135,0.09,0.62371135,0.093333334,0.62371135,0.096666664,0.62371135,0.1,0.62371135,0.10333333,0.62371135,0.10666667,0.62371135,0.11,0.62371135,0.11333334,0.62371135,0.11666667,0.62371135,0.12,0.62371135,0.123333335,0.62371135,0.12666667,0.62371135,0.13,0.62371135,0.13333334,0.62371135,0.13666667,0.62371135,0.14,0.62371135,0.14333333,0.62371135,0.14666666,0.62371135,0.15,0.62371135,0.15333334,0.62371135,0.15666667,0.62371135,0.16,0.62371135,0.16333333,0.62371135,0.16666667,0.62371135,0.17,0.62371135,0.17333333,0.62371135,0.17666666,0.62371135,0.18,0.62371135,0.18333334,0.62371135,0.18666667,0.62371135,0.19,0.62371135,0.19333333,0.62371135,0.19666667,0.62371135,0.2,0.62371135,0.20333333,0.62371135,0.21333334,0.62371135,0.21666667,0.62371135,0.22,0.62371135,0.22333333,0.62371135,0.3,0.62371135,0.30333334,0.62371135,0.30666667,0.62371135,0.31,0.62371135,0.31333333,0.62371135,0.31666666,0.62371135,0.32,0.62371135,0.32333332,0.62371135,0.32666665,0.62371135,0.33,0.62371135,0.33333334,0.62371135,0.33666667,0.62371135,0.39666668,0.62371135,0.4,0.62371135,0.40333334,0.62371135,0.40666667,0.62371135,0.41,0.62371135,0.41333333,0.62371135,0.41666666,0.62371135,0.42,0.62371135,0.42333335,0.62371135,0.5966667,0.62371135,0.6,0.62371135,0.60333335,0.62371135,0.6066667,0.62371135,0.61,0.62371135,0.61333334,0.62371135,0.6166667,0.62371135,0.62,0.62371135,0.67333335,0.62371135,0.6766667,0.62371135,0.68,0.62371135,0.68333334,0.62371135,0.68666667,0.62371135,0.69,0.62371135,0.6933333,0.62371135,0.84,0.62371135,0.8433333,0.62371135,0.8466667,0.62371135,0.85,0.62371135,0.85333335,0.62371135,0.8566667,0.62371135,0.86,0.62371135,0.86333334,0.62371135,0.05666667,0.62628865,0.06,0.62628865,0.06333333,0.62628865,0.06666667,0.62628865,0.07,0.62628865,0.07333333,0.62628865,0.07666667,0.62628865,0.08,0.62628865,0.083333336,0.62628865,0.086666666,0.62628865,0.09,0.62628865,0.093333334,0.62628865,0.096666664,0.62628865,0.1,0.62628865,0.10333333,0.62628865,0.10666667,0.62628865,0.11,0.62628865,0.11333334,0.62628865,0.11666667,0.62628865,0.12,0.62628865,0.123333335,0.62628865,0.12666667,0.62628865,0.13,0.62628865,0.13333334,0.62628865,0.13666667,0.62628865,0.14,0.62628865,0.14333333,0.62628865,0.14666666,0.62628865,0.15,0.62628865,0.15333334,0.62628865,0.15666667,0.62628865,0.16,0.62628865,0.16333333,0.62628865,0.16666667,0.62628865,0.17,0.62628865,0.17333333,0.62628865,0.17666666,0.62628865,0.18,0.62628865,0.19333333,0.62628865,0.29666665,0.62628865,0.3,0.62628865,0.30333334,0.62628865,0.30666667,0.62628865,0.31,0.62628865,0.31333333,0.62628865,0.31666666,0.62628865,0.32,0.62628865,0.32333332,0.62628865,0.32666665,0.62628865,0.33,0.62628865,0.33333334,0.62628865,0.4,0.62628865,0.40333334,0.62628865,0.40666667,0.62628865,0.41,0.62628865,0.41333333,0.62628865,0.41666666,0.62628865,0.5966667,0.62628865,0.6,0.62628865,0.60333335,0.62628865,0.6066667,0.62628865,0.61,0.62628865,0.61333334,0.62628865,0.6166667,0.62628865,0.62,0.62628865,0.62333333,0.62628865,0.62666667,0.62628865,0.6766667,0.62628865,0.68,0.62628865,0.68333334,0.62628865,0.68666667,0.62628865,0.69,0.62628865,0.6933333,0.62628865,0.84,0.62628865,0.8433333,0.62628865,0.8466667,0.62628865,0.85,0.62628865,0.85333335,0.62628865,0.8566667,0.62628865,0.86,0.62628865,0.86333334,0.62628865,0.05666667,0.62886596,0.06,0.62886596,0.06333333,0.62886596,0.06666667,0.62886596,0.07,0.62886596,0.07333333,0.62886596,0.07666667,0.62886596,0.08,0.62886596,0.083333336,0.62886596,0.086666666,0.62886596,0.09,0.62886596,0.093333334,0.62886596,0.096666664,0.62886596,0.1,0.62886596,0.10333333,0.62886596,0.10666667,0.62886596,0.11,0.62886596,0.11333334,0.62886596,0.11666667,0.62886596,0.12,0.62886596,0.123333335,0.62886596,0.12666667,0.62886596,0.13,0.62886596,0.13333334,0.62886596,0.13666667,0.62886596,0.14,0.62886596,0.14333333,0.62886596,0.14666666,0.62886596,0.15,0.62886596,0.15333334,0.62886596,0.15666667,0.62886596,0.16,0.62886596,0.16333333,0.62886596,0.16666667,0.62886596,0.17,0.62886596,0.17333333,0.62886596,0.17666666,0.62886596,0.18,0.62886596,0.29333332,0.62886596,0.29666665,0.62886596,0.3,0.62886596,0.30333334,0.62886596,0.30666667,0.62886596,0.31,0.62886596,0.31333333,0.62886596,0.31666666,0.62886596,0.32,0.62886596,0.32333332,0.62886596,0.32666665,0.62886596,0.33,0.62886596,0.4,0.62886596,0.40333334,0.62886596,0.40666667,0.62886596,0.41,0.62886596,0.5966667,0.62886596,0.6,0.62886596,0.60333335,0.62886596,0.6066667,0.62886596,0.61,0.62886596,0.61333334,0.62886596,0.6166667,0.62886596,0.62,0.62886596,0.62333333,0.62886596,0.62666667,0.62886596,0.63,0.62886596,0.68333334,0.62886596,0.68666667,0.62886596,0.69,0.62886596,0.6933333,0.62886596,0.69666666,0.62886596,0.84,0.62886596,0.8433333,0.62886596,0.8466667,0.62886596,0.85,0.62886596,0.85333335,0.62886596,0.8566667,0.62886596,0.86,0.62886596,0.86333334,0.62886596,0.06,0.6314433,0.06333333,0.6314433,0.06666667,0.6314433,0.07,0.6314433,0.07333333,0.6314433,0.07666667,0.6314433,0.08,0.6314433,0.083333336,0.6314433,0.086666666,0.6314433,0.09,0.6314433,0.093333334,0.6314433,0.096666664,0.6314433,0.1,0.6314433,0.10333333,0.6314433,0.10666667,0.6314433,0.11,0.6314433,0.11333334,0.6314433,0.11666667,0.6314433,0.12,0.6314433,0.123333335,0.6314433,0.12666667,0.6314433,0.13,0.6314433,0.13333334,0.6314433,0.13666667,0.6314433,0.14,0.6314433,0.14333333,0.6314433,0.14666666,0.6314433,0.15,0.6314433,0.15333334,0.6314433,0.15666667,0.6314433,0.16,0.6314433,0.16333333,0.6314433,0.16666667,0.6314433,0.17,0.6314433,0.17333333,0.6314433,0.17666666,0.6314433,0.29333332,0.6314433,0.29666665,0.6314433,0.3,0.6314433,0.30333334,0.6314433,0.30666667,0.6314433,0.31,0.6314433,0.31333333,0.6314433,0.31666666,0.6314433,0.32,0.6314433,0.32333332,0.6314433,0.32666665,0.6314433,0.4,0.6314433,0.40333334,0.6314433,0.40666667,0.6314433,0.5966667,0.6314433,0.6,0.6314433,0.60333335,0.6314433,0.6066667,0.6314433,0.61,0.6314433,0.61333334,0.6314433,0.6166667,0.6314433,0.62,0.6314433,0.62333333,0.6314433,0.62666667,0.6314433,0.63,0.6314433,0.6333333,0.6314433,0.68666667,0.6314433,0.69,0.6314433,0.6933333,0.6314433,0.69666666,0.6314433,0.7,0.6314433,0.84,0.6314433,0.8433333,0.6314433,0.8466667,0.6314433,0.85,0.6314433,0.85333335,0.6314433,0.8566667,0.6314433,0.86,0.6314433,0.86333334,0.6314433,0.8666667,0.6314433,0.06,0.6340206,0.06333333,0.6340206,0.06666667,0.6340206,0.07,0.6340206,0.07333333,0.6340206,0.07666667,0.6340206,0.08,0.6340206,0.083333336,0.6340206,0.086666666,0.6340206,0.09,0.6340206,0.093333334,0.6340206,0.096666664,0.6340206,0.1,0.6340206,0.10333333,0.6340206,0.10666667,0.6340206,0.11,0.6340206,0.11333334,0.6340206,0.11666667,0.6340206,0.12,0.6340206,0.123333335,0.6340206,0.12666667,0.6340206,0.13,0.6340206,0.13333334,0.6340206,0.13666667,0.6340206,0.14,0.6340206,0.14333333,0.6340206,0.14666666,0.6340206,0.15,0.6340206,0.15333334,0.6340206,0.15666667,0.6340206,0.16,0.6340206,0.16333333,0.6340206,0.16666667,0.6340206,0.17,0.6340206,0.17333333,0.6340206,0.3,0.6340206,0.30333334,0.6340206,0.30666667,0.6340206,0.31,0.6340206,0.31333333,0.6340206,0.31666666,0.6340206,0.32,0.6340206,0.32333332,0.6340206,0.32666665,0.6340206,0.4,0.6340206,0.40333334,0.6340206,0.40666667,0.6340206,0.5966667,0.6340206,0.6,0.6340206,0.60333335,0.6340206,0.6066667,0.6340206,0.61,0.6340206,0.61333334,0.6340206,0.6166667,0.6340206,0.62,0.6340206,0.62333333,0.6340206,0.62666667,0.6340206,0.63,0.6340206,0.6333333,0.6340206,0.63666666,0.6340206,0.69,0.6340206,0.6933333,0.6340206,0.69666666,0.6340206,0.7,0.6340206,0.84,0.6340206,0.8433333,0.6340206,0.8466667,0.6340206,0.85,0.6340206,0.85333335,0.6340206,0.8566667,0.6340206,0.86,0.6340206,0.86333334,0.6340206,0.8666667,0.6340206,0.87666667,0.6340206,0.88,0.6340206,0.8833333,0.6340206,0.88666666,0.6340206,0.89,0.6340206,0.8933333,0.6340206,0.06333333,0.63659793,0.06666667,0.63659793,0.07,0.63659793,0.07333333,0.63659793,0.07666667,0.63659793,0.08,0.63659793,0.083333336,0.63659793,0.086666666,0.63659793,0.09,0.63659793,0.093333334,0.63659793,0.096666664,0.63659793,0.1,0.63659793,0.10333333,0.63659793,0.10666667,0.63659793,0.11,0.63659793,0.11333334,0.63659793,0.11666667,0.63659793,0.12,0.63659793,0.123333335,0.63659793,0.12666667,0.63659793,0.13,0.63659793,0.13333334,0.63659793,0.13666667,0.63659793,0.14,0.63659793,0.14333333,0.63659793,0.14666666,0.63659793,0.15,0.63659793,0.15333334,0.63659793,0.15666667,0.63659793,0.16,0.63659793,0.16333333,0.63659793,0.16666667,0.63659793,0.17,0.63659793,0.17333333,0.63659793,0.30333334,0.63659793,0.30666667,0.63659793,0.31,0.63659793,0.31333333,0.63659793,0.31666666,0.63659793,0.32,0.63659793,0.32333332,0.63659793,0.32666665,0.63659793,0.39666668,0.63659793,0.4,0.63659793,0.40333334,0.63659793,0.6,0.63659793,0.60333335,0.63659793,0.6066667,0.63659793,0.61,0.63659793,0.61333334,0.63659793,0.6166667,0.63659793,0.62,0.63659793,0.62333333,0.63659793,0.62666667,0.63659793,0.63,0.63659793,0.6333333,0.63659793,0.63666666,0.63659793,0.64,0.63659793,0.69,0.63659793,0.6933333,0.63659793,0.69666666,0.63659793,0.7,0.63659793,0.7033333,0.63659793,0.8433333,0.63659793,0.8466667,0.63659793,0.85,0.63659793,0.85333335,0.63659793,0.8566667,0.63659793,0.86,0.63659793,0.88,0.63659793,0.8833333,0.63659793,0.88666666,0.63659793,0.89,0.63659793,0.8933333,0.63659793,0.89666665,0.63659793,0.9,0.63659793,0.06666667,0.63917524,0.07,0.63917524,0.07333333,0.63917524,0.07666667,0.63917524,0.08,0.63917524,0.083333336,0.63917524,0.086666666,0.63917524,0.09,0.63917524,0.093333334,0.63917524,0.096666664,0.63917524,0.1,0.63917524,0.10333333,0.63917524,0.10666667,0.63917524,0.11,0.63917524,0.11333334,0.63917524,0.11666667,0.63917524,0.12,0.63917524,0.123333335,0.63917524,0.12666667,0.63917524,0.13,0.63917524,0.13333334,0.63917524,0.13666667,0.63917524,0.14,0.63917524,0.14333333,0.63917524,0.14666666,0.63917524,0.15,0.63917524,0.15333334,0.63917524,0.15666667,0.63917524,0.16,0.63917524,0.16333333,0.63917524,0.16666667,0.63917524,0.17,0.63917524,0.17333333,0.63917524,0.30333334,0.63917524,0.30666667,0.63917524,0.31,0.63917524,0.31333333,0.63917524,0.31666666,0.63917524,0.32,0.63917524,0.32333332,0.63917524,0.32666665,0.63917524,0.33,0.63917524,0.33333334,0.63917524,0.33666667,0.63917524,0.39666668,0.63917524,0.4,0.63917524,0.40333334,0.63917524,0.6066667,0.63917524,0.61,0.63917524,0.61333334,0.63917524,0.6166667,0.63917524,0.62,0.63917524,0.62333333,0.63917524,0.62666667,0.63917524,0.63,0.63917524,0.6333333,0.63917524,0.63666666,0.63917524,0.64,0.63917524,0.69,0.63917524,0.6933333,0.63917524,0.69666666,0.63917524,0.7,0.63917524,0.7033333,0.63917524,0.70666665,0.63917524,0.82,0.63917524,0.8233333,0.63917524,0.82666665,0.63917524,0.85,0.63917524,0.85333335,0.63917524,0.8566667,0.63917524,0.86,0.63917524,0.8666667,0.63917524,0.88,0.63917524,0.8833333,0.63917524,0.88666666,0.63917524,0.89,0.63917524,0.8933333,0.63917524,0.89666665,0.63917524,0.9,0.63917524,0.9033333,0.63917524,0.9066667,0.63917524,0.91,0.63917524,0.07,0.6417526,0.07333333,0.6417526,0.07666667,0.6417526,0.08,0.6417526,0.083333336,0.6417526,0.086666666,0.6417526,0.09,0.6417526,0.093333334,0.6417526,0.096666664,0.6417526,0.1,0.6417526,0.10333333,0.6417526,0.10666667,0.6417526,0.11,0.6417526,0.11333334,0.6417526,0.11666667,0.6417526,0.12,0.6417526,0.123333335,0.6417526,0.12666667,0.6417526,0.13,0.6417526,0.13333334,0.6417526,0.13666667,0.6417526,0.14,0.6417526,0.14333333,0.6417526,0.14666666,0.6417526,0.15,0.6417526,0.15333334,0.6417526,0.15666667,0.6417526,0.16,0.6417526,0.16333333,0.6417526,0.16666667,0.6417526,0.17,0.6417526,0.17333333,0.6417526,0.3,0.6417526,0.30333334,0.6417526,0.30666667,0.6417526,0.31,0.6417526,0.31333333,0.6417526,0.31666666,0.6417526,0.32,0.6417526,0.32333332,0.6417526,0.32666665,0.6417526,0.33,0.6417526,0.33333334,0.6417526,0.33666667,0.6417526,0.34,0.6417526,0.39333335,0.6417526,0.39666668,0.6417526,0.4,0.6417526,0.40333334,0.6417526,0.61,0.6417526,0.61333334,0.6417526,0.6166667,0.6417526,0.62,0.6417526,0.62333333,0.6417526,0.62666667,0.6417526,0.63,0.6417526,0.6333333,0.6417526,0.63666666,0.6417526,0.64,0.6417526,0.6433333,0.6417526,0.69,0.6417526,0.6933333,0.6417526,0.69666666,0.6417526,0.7,0.6417526,0.7033333,0.6417526,0.70666665,0.6417526,0.71,0.6417526,0.81666666,0.6417526,0.82,0.6417526,0.8233333,0.6417526,0.82666665,0.6417526,0.83,0.6417526,0.8333333,0.6417526,0.85,0.6417526,0.85333335,0.6417526,0.8566667,0.6417526,0.86,0.6417526,0.87,0.6417526,0.88,0.6417526,0.8833333,0.6417526,0.88666666,0.6417526,0.89,0.6417526,0.8933333,0.6417526,0.89666665,0.6417526,0.9,0.6417526,0.9033333,0.6417526,0.9066667,0.6417526,0.91,0.6417526,0.07333333,0.6443299,0.07666667,0.6443299,0.08,0.6443299,0.083333336,0.6443299,0.086666666,0.6443299,0.09,0.6443299,0.093333334,0.6443299,0.096666664,0.6443299,0.1,0.6443299,0.10333333,0.6443299,0.10666667,0.6443299,0.11,0.6443299,0.11333334,0.6443299,0.11666667,0.6443299,0.12,0.6443299,0.123333335,0.6443299,0.12666667,0.6443299,0.13,0.6443299,0.13333334,0.6443299,0.26,0.6443299,0.26333332,0.6443299,0.26666668,0.6443299,0.3,0.6443299,0.30333334,0.6443299,0.30666667,0.6443299,0.31,0.6443299,0.31333333,0.6443299,0.31666666,0.6443299,0.32,0.6443299,0.32333332,0.6443299,0.32666665,0.6443299,0.33,0.6443299,0.33333334,0.6443299,0.33666667,0.6443299,0.34,0.6443299,0.34333333,0.6443299,0.34666666,0.6443299,0.39,0.6443299,0.39333335,0.6443299,0.39666668,0.6443299,0.4,0.6443299,0.40333334,0.6443299,0.61,0.6443299,0.61333334,0.6443299,0.6166667,0.6443299,0.62,0.6443299,0.62333333,0.6443299,0.62666667,0.6443299,0.63,0.6443299,0.6333333,0.6443299,0.63666666,0.6443299,0.64,0.6443299,0.6433333,0.6443299,0.69,0.6443299,0.6933333,0.6443299,0.69666666,0.6443299,0.7,0.6443299,0.7033333,0.6443299,0.70666665,0.6443299,0.71,0.6443299,0.81666666,0.6443299,0.82,0.6443299,0.8233333,0.6443299,0.82666665,0.6443299,0.83,0.6443299,0.8333333,0.6443299,0.85333335,0.6443299,0.8566667,0.6443299,0.86,0.6443299,0.86333334,0.6443299,0.88,0.6443299,0.8833333,0.6443299,0.88666666,0.6443299,0.89,0.6443299,0.8933333,0.6443299,0.89666665,0.6443299,0.9,0.6443299,0.9033333,0.6443299,0.9066667,0.6443299,0.91,0.6443299,0.91333336,0.6443299,0.08,0.6469072,0.083333336,0.6469072,0.086666666,0.6469072,0.09,0.6469072,0.093333334,0.6469072,0.096666664,0.6469072,0.1,0.6469072,0.10333333,0.6469072,0.10666667,0.6469072,0.11,0.6469072,0.11333334,0.6469072,0.25,0.6469072,0.25333333,0.6469072,0.25666666,0.6469072,0.26,0.6469072,0.26333332,0.6469072,0.26666668,0.6469072,0.3,0.6469072,0.30333334,0.6469072,0.30666667,0.6469072,0.31,0.6469072,0.31333333,0.6469072,0.31666666,0.6469072,0.32,0.6469072,0.32333332,0.6469072,0.32666665,0.6469072,0.33,0.6469072,0.33333334,0.6469072,0.33666667,0.6469072,0.34,0.6469072,0.34333333,0.6469072,0.34666666,0.6469072,0.35,0.6469072,0.38666666,0.6469072,0.39,0.6469072,0.39333335,0.6469072,0.39666668,0.6469072,0.4,0.6469072,0.40333334,0.6469072,0.61,0.6469072,0.61333334,0.6469072,0.6166667,0.6469072,0.62,0.6469072,0.62333333,0.6469072,0.62666667,0.6469072,0.63,0.6469072,0.6333333,0.6469072,0.63666666,0.6469072,0.64,0.6469072,0.6433333,0.6469072,0.68666667,0.6469072,0.69,0.6469072,0.6933333,0.6469072,0.69666666,0.6469072,0.7,0.6469072,0.7033333,0.6469072,0.70666665,0.6469072,0.71,0.6469072,0.82,0.6469072,0.8233333,0.6469072,0.82666665,0.6469072,0.83,0.6469072,0.8333333,0.6469072,0.85333335,0.6469072,0.8566667,0.6469072,0.86,0.6469072,0.87333333,0.6469072,0.87666667,0.6469072,0.88,0.6469072,0.8833333,0.6469072,0.88666666,0.6469072,0.89,0.6469072,0.8933333,0.6469072,0.89666665,0.6469072,0.9,0.6469072,0.9033333,0.6469072,0.9066667,0.6469072,0.91,0.6469072,0.91333336,0.6469072,0.08,0.6494845,0.083333336,0.6494845,0.086666666,0.6494845,0.09,0.6494845,0.093333334,0.6494845,0.096666664,0.6494845,0.1,0.6494845,0.10333333,0.6494845,0.24,0.6494845,0.24333334,0.6494845,0.24666667,0.6494845,0.25,0.6494845,0.25333333,0.6494845,0.25666666,0.6494845,0.26,0.6494845,0.26333332,0.6494845,0.26666668,0.6494845,0.3,0.6494845,0.30333334,0.6494845,0.30666667,0.6494845,0.31,0.6494845,0.31333333,0.6494845,0.31666666,0.6494845,0.32,0.6494845,0.32333332,0.6494845,0.32666665,0.6494845,0.33,0.6494845,0.33333334,0.6494845,0.33666667,0.6494845,0.34,0.6494845,0.34333333,0.6494845,0.34666666,0.6494845,0.35,0.6494845,0.38,0.6494845,0.38333333,0.6494845,0.38666666,0.6494845,0.39,0.6494845,0.39333335,0.6494845,0.39666668,0.6494845,0.4,0.6494845,0.40333334,0.6494845,0.6066667,0.6494845,0.61,0.6494845,0.61333334,0.6494845,0.6166667,0.6494845,0.62,0.6494845,0.62333333,0.6494845,0.62666667,0.6494845,0.63,0.6494845,0.6333333,0.6494845,0.63666666,0.6494845,0.64,0.6494845,0.6433333,0.6494845,0.68333334,0.6494845,0.68666667,0.6494845,0.69,0.6494845,0.6933333,0.6494845,0.69666666,0.6494845,0.7,0.6494845,0.7033333,0.6494845,0.70666665,0.6494845,0.71,0.6494845,0.7133333,0.6494845,0.82666665,0.6494845,0.83,0.6494845,0.8333333,0.6494845,0.83666664,0.6494845,0.85333335,0.6494845,0.8566667,0.6494845,0.86333334,0.6494845,0.8666667,0.6494845,0.87333333,0.6494845,0.87666667,0.6494845,0.88,0.6494845,0.8833333,0.6494845,0.88666666,0.6494845,0.89,0.6494845,0.8933333,0.6494845,0.89666665,0.6494845,0.9,0.6494845,0.9033333,0.6494845,0.9066667,0.6494845,0.91,0.6494845,0.91333336,0.6494845,0.9166667,0.6494845,0.08,0.6520619,0.083333336,0.6520619,0.086666666,0.6520619,0.09,0.6520619,0.093333334,0.6520619,0.096666664,0.6520619,0.17666666,0.6520619,0.18,0.6520619,0.18333334,0.6520619,0.18666667,0.6520619,0.22666667,0.6520619,0.23,0.6520619,0.23333333,0.6520619,0.23666666,0.6520619,0.24,0.6520619,0.24333334,0.6520619,0.24666667,0.6520619,0.25,0.6520619,0.25333333,0.6520619,0.25666666,0.6520619,0.26,0.6520619,0.26333332,0.6520619,0.26666668,0.6520619,0.27,0.6520619,0.3,0.6520619,0.30333334,0.6520619,0.30666667,0.6520619,0.31,0.6520619,0.31333333,0.6520619,0.31666666,0.6520619,0.32,0.6520619,0.32333332,0.6520619,0.32666665,0.6520619,0.33,0.6520619,0.33333334,0.6520619,0.33666667,0.6520619,0.34,0.6520619,0.34333333,0.6520619,0.34666666,0.6520619,0.35,0.6520619,0.37666667,0.6520619,0.38,0.6520619,0.38333333,0.6520619,0.38666666,0.6520619,0.39,0.6520619,0.39333335,0.6520619,0.39666668,0.6520619,0.4,0.6520619,0.40333334,0.6520619,0.6066667,0.6520619,0.61,0.6520619,0.61333334,0.6520619,0.6166667,0.6520619,0.62,0.6520619,0.62333333,0.6520619,0.62666667,0.6520619,0.63,0.6520619,0.6333333,0.6520619,0.63666666,0.6520619,0.64,0.6520619,0.6433333,0.6520619,0.67,0.6520619,0.67333335,0.6520619,0.6766667,0.6520619,0.68,0.6520619,0.68333334,0.6520619,0.68666667,0.6520619,0.69,0.6520619,0.6933333,0.6520619,0.69666666,0.6520619,0.7,0.6520619,0.7033333,0.6520619,0.70666665,0.6520619,0.72,0.6520619,0.72333336,0.6520619,0.7266667,0.6520619,0.73,0.6520619,0.73333335,0.6520619,0.7366667,0.6520619,0.81,0.6520619,0.81333333,0.6520619,0.83,0.6520619,0.8333333,0.6520619,0.83666664,0.6520619,0.85333335,0.6520619,0.8666667,0.6520619,0.87333333,0.6520619,0.87666667,0.6520619,0.88,0.6520619,0.8833333,0.6520619,0.88666666,0.6520619,0.89,0.6520619,0.8933333,0.6520619,0.89666665,0.6520619,0.9,0.6520619,0.9033333,0.6520619,0.9066667,0.6520619,0.91,0.6520619,0.91333336,0.6520619,0.9166667,0.6520619,0.08,0.6546392,0.083333336,0.6546392,0.086666666,0.6546392,0.09,0.6546392,0.093333334,0.6546392,0.13,0.6546392,0.13333334,0.6546392,0.13666667,0.6546392,0.14,0.6546392,0.14333333,0.6546392,0.14666666,0.6546392,0.15,0.6546392,0.15333334,0.6546392,0.15666667,0.6546392,0.16,0.6546392,0.16333333,0.6546392,0.16666667,0.6546392,0.17,0.6546392,0.17333333,0.6546392,0.17666666,0.6546392,0.18,0.6546392,0.18333334,0.6546392,0.18666667,0.6546392,0.19,0.6546392,0.22333333,0.6546392,0.22666667,0.6546392,0.23,0.6546392,0.23333333,0.6546392,0.23666666,0.6546392,0.24,0.6546392,0.24333334,0.6546392,0.24666667,0.6546392,0.25,0.6546392,0.25333333,0.6546392,0.25666666,0.6546392,0.26,0.6546392,0.26333332,0.6546392,0.26666668,0.6546392,0.27,0.6546392,0.27333334,0.6546392,0.30333334,0.6546392,0.30666667,0.6546392,0.31,0.6546392,0.31333333,0.6546392,0.31666666,0.6546392,0.32,0.6546392,0.32333332,0.6546392,0.32666665,0.6546392,0.33,0.6546392,0.33333334,0.6546392,0.33666667,0.6546392,0.34,0.6546392,0.34333333,0.6546392,0.34666666,0.6546392,0.35,0.6546392,0.35333332,0.6546392,0.37333333,0.6546392,0.37666667,0.6546392,0.38,0.6546392,0.38333333,0.6546392,0.38666666,0.6546392,0.39,0.6546392,0.39333335,0.6546392,0.39666668,0.6546392,0.4,0.6546392,0.5966667,0.6546392,0.6,0.6546392,0.60333335,0.6546392,0.6066667,0.6546392,0.61,0.6546392,0.61333334,0.6546392,0.6166667,0.6546392,0.62,0.6546392,0.62333333,0.6546392,0.62666667,0.6546392,0.63,0.6546392,0.6333333,0.6546392,0.63666666,0.6546392,0.64,0.6546392,0.6433333,0.6546392,0.66333336,0.6546392,0.6666667,0.6546392,0.67,0.6546392,0.67333335,0.6546392,0.6766667,0.6546392,0.68,0.6546392,0.68333334,0.6546392,0.68666667,0.6546392,0.69,0.6546392,0.6933333,0.6546392,0.69666666,0.6546392,0.7,0.6546392,0.7033333,0.6546392,0.72,0.6546392,0.72333336,0.6546392,0.7266667,0.6546392,0.73,0.6546392,0.73333335,0.6546392,0.7366667,0.6546392,0.74,0.6546392,0.74333334,0.6546392,0.74666667,0.6546392,0.75,0.6546392,0.8066667,0.6546392,0.81,0.6546392,0.81333333,0.6546392,0.81666666,0.6546392,0.8333333,0.6546392,0.83666664,0.6546392,0.85333335,0.6546392,0.8666667,0.6546392,0.87333333,0.6546392,0.87666667,0.6546392,0.88,0.6546392,0.8833333,0.6546392,0.88666666,0.6546392,0.89,0.6546392,0.8933333,0.6546392,0.89666665,0.6546392,0.9,0.6546392,0.9033333,0.6546392,0.9066667,0.6546392,0.91,0.6546392,0.91333336,0.6546392,0.9166667,0.6546392,0.07666667,0.6572165,0.08,0.6572165,0.083333336,0.6572165,0.086666666,0.6572165,0.09,0.6572165,0.11,0.6572165,0.11333334,0.6572165,0.11666667,0.6572165,0.12,0.6572165,0.123333335,0.6572165,0.12666667,0.6572165,0.13,0.6572165,0.13333334,0.6572165,0.13666667,0.6572165,0.14,0.6572165,0.14333333,0.6572165,0.14666666,0.6572165,0.15,0.6572165,0.15333334,0.6572165,0.15666667,0.6572165,0.16,0.6572165,0.16333333,0.6572165,0.16666667,0.6572165,0.17,0.6572165,0.17333333,0.6572165,0.17666666,0.6572165,0.18,0.6572165,0.18333334,0.6572165,0.18666667,0.6572165,0.22333333,0.6572165,0.22666667,0.6572165,0.23,0.6572165,0.23333333,0.6572165,0.23666666,0.6572165,0.24,0.6572165,0.24333334,0.6572165,0.24666667,0.6572165,0.25,0.6572165,0.25333333,0.6572165,0.25666666,0.6572165,0.26,0.6572165,0.26333332,0.6572165,0.26666668,0.6572165,0.27,0.6572165,0.27333334,0.6572165,0.27666667,0.6572165,0.28,0.6572165,0.29333332,0.6572165,0.29666665,0.6572165,0.3,0.6572165,0.30333334,0.6572165,0.30666667,0.6572165,0.31,0.6572165,0.31333333,0.6572165,0.31666666,0.6572165,0.32,0.6572165,0.32333332,0.6572165,0.32666665,0.6572165,0.33,0.6572165,0.33333334,0.6572165,0.33666667,0.6572165,0.34,0.6572165,0.34333333,0.6572165,0.34666666,0.6572165,0.35,0.6572165,0.35333332,0.6572165,0.37,0.6572165,0.37333333,0.6572165,0.37666667,0.6572165,0.38,0.6572165,0.38333333,0.6572165,0.38666666,0.6572165,0.39,0.6572165,0.39333335,0.6572165,0.39666668,0.6572165,0.4,0.6572165,0.40333334,0.6572165,0.50333333,0.6572165,0.50666666,0.6572165,0.51,0.6572165,0.5133333,0.6572165,0.51666665,0.6572165,0.52,0.6572165,0.5233333,0.6572165,0.52666664,0.6572165,0.53,0.6572165,0.53333336,0.6572165,0.5366667,0.6572165,0.58666664,0.6572165,0.59,0.6572165,0.5933333,0.6572165,0.5966667,0.6572165,0.6,0.6572165,0.60333335,0.6572165,0.6066667,0.6572165,0.61,0.6572165,0.61333334,0.6572165,0.6166667,0.6572165,0.62,0.6572165,0.62333333,0.6572165,0.62666667,0.6572165,0.63,0.6572165,0.6333333,0.6572165,0.63666666,0.6572165,0.64,0.6572165,0.6566667,0.6572165,0.66,0.6572165,0.66333336,0.6572165,0.6666667,0.6572165,0.67,0.6572165,0.67333335,0.6572165,0.6766667,0.6572165,0.68,0.6572165,0.68333334,0.6572165,0.68666667,0.6572165,0.69,0.6572165,0.6933333,0.6572165,0.69666666,0.6572165,0.7,0.6572165,0.71666664,0.6572165,0.72,0.6572165,0.72333336,0.6572165,0.7266667,0.6572165,0.73,0.6572165,0.73333335,0.6572165,0.7366667,0.6572165,0.74,0.6572165,0.74333334,0.6572165,0.74666667,0.6572165,0.75,0.6572165,0.75333333,0.6572165,0.75666666,0.6572165,0.76,0.6572165,0.7633333,0.6572165,0.76666665,0.6572165,0.7733333,0.6572165,0.77666664,0.6572165,0.78,0.6572165,0.78333336,0.6572165,0.7866667,0.6572165,0.79,0.6572165,0.81,0.6572165,0.81333333,0.6572165,0.81666666,0.6572165,0.82,0.6572165,0.8333333,0.6572165,0.83666664,0.6572165,0.85,0.6572165,0.85333335,0.6572165,0.88,0.6572165,0.8833333,0.6572165,0.88666666,0.6572165,0.89,0.6572165,0.8933333,0.6572165,0.89666665,0.6572165,0.9,0.6572165,0.9033333,0.6572165,0.9066667,0.6572165,0.91,0.6572165,0.91333336,0.6572165,0.9166667,0.6572165,0.07333333,0.6597938,0.07666667,0.6597938,0.08,0.6597938,0.083333336,0.6597938,0.086666666,0.6597938,0.09,0.6597938,0.10666667,0.6597938,0.11,0.6597938,0.11333334,0.6597938,0.11666667,0.6597938,0.12,0.6597938,0.123333335,0.6597938,0.12666667,0.6597938,0.13,0.6597938,0.13333334,0.6597938,0.13666667,0.6597938,0.14,0.6597938,0.14333333,0.6597938,0.14666666,0.6597938,0.15,0.6597938,0.15333334,0.6597938,0.15666667,0.6597938,0.16,0.6597938,0.16333333,0.6597938,0.16666667,0.6597938,0.17,0.6597938,0.17333333,0.6597938,0.17666666,0.6597938,0.18,0.6597938,0.18333334,0.6597938,0.18666667,0.6597938,0.19,0.6597938,0.22333333,0.6597938,0.22666667,0.6597938,0.23,0.6597938,0.23333333,0.6597938,0.23666666,0.6597938,0.24,0.6597938,0.24333334,0.6597938,0.24666667,0.6597938,0.25,0.6597938,0.25333333,0.6597938,0.25666666,0.6597938,0.26,0.6597938,0.26333332,0.6597938,0.26666668,0.6597938,0.27,0.6597938,0.27333334,0.6597938,0.27666667,0.6597938,0.28,0.6597938,0.28333333,0.6597938,0.28666666,0.6597938,0.29,0.6597938,0.29333332,0.6597938,0.29666665,0.6597938,0.3,0.6597938,0.30333334,0.6597938,0.30666667,0.6597938,0.31,0.6597938,0.31333333,0.6597938,0.31666666,0.6597938,0.32,0.6597938,0.32333332,0.6597938,0.32666665,0.6597938,0.33,0.6597938,0.33333334,0.6597938,0.33666667,0.6597938,0.34,0.6597938,0.34333333,0.6597938,0.34666666,0.6597938,0.35,0.6597938,0.35333332,0.6597938,0.37,0.6597938,0.37333333,0.6597938,0.37666667,0.6597938,0.38,0.6597938,0.38333333,0.6597938,0.38666666,0.6597938,0.39,0.6597938,0.39333335,0.6597938,0.39666668,0.6597938,0.4,0.6597938,0.40333334,0.6597938,0.40666667,0.6597938,0.41,0.6597938,0.41333333,0.6597938,0.41666666,0.6597938,0.42,0.6597938,0.42333335,0.6597938,0.47333333,0.6597938,0.47666666,0.6597938,0.48,0.6597938,0.48333332,0.6597938,0.48666668,0.6597938,0.49,0.6597938,0.49333334,0.6597938,0.49666667,0.6597938,0.5,0.6597938,0.50333333,0.6597938,0.50666666,0.6597938,0.51,0.6597938,0.5133333,0.6597938,0.51666665,0.6597938,0.52,0.6597938,0.5233333,0.6597938,0.52666664,0.6597938,0.53,0.6597938,0.53333336,0.6597938,0.5366667,0.6597938,0.54,0.6597938,0.5833333,0.6597938,0.58666664,0.6597938,0.59,0.6597938,0.5933333,0.6597938,0.5966667,0.6597938,0.6,0.6597938,0.60333335,0.6597938,0.6066667,0.6597938,0.61,0.6597938,0.61333334,0.6597938,0.6166667,0.6597938,0.62,0.6597938,0.62333333,0.6597938,0.62666667,0.6597938,0.63,0.6597938,0.6333333,0.6597938,0.63666666,0.6597938,0.64,0.6597938,0.6533333,0.6597938,0.6566667,0.6597938,0.66,0.6597938,0.66333336,0.6597938,0.6666667,0.6597938,0.67,0.6597938,0.67333335,0.6597938,0.6766667,0.6597938,0.68,0.6597938,0.68333334,0.6597938,0.68666667,0.6597938,0.69,0.6597938,0.6933333,0.6597938,0.69666666,0.6597938,0.7,0.6597938,0.71666664,0.6597938,0.72,0.6597938,0.72333336,0.6597938,0.7266667,0.6597938,0.73,0.6597938,0.73333335,0.6597938,0.7366667,0.6597938,0.74,0.6597938,0.74333334,0.6597938,0.74666667,0.6597938,0.75,0.6597938,0.75333333,0.6597938,0.75666666,0.6597938,0.76,0.6597938,0.7633333,0.6597938,0.76666665,0.6597938,0.77,0.6597938,0.7733333,0.6597938,0.77666664,0.6597938,0.78,0.6597938,0.78333336,0.6597938,0.7866667,0.6597938,0.79,0.6597938,0.79333335,0.6597938,0.81,0.6597938,0.81333333,0.6597938,0.81666666,0.6597938,0.82,0.6597938,0.8333333,0.6597938,0.83666664,0.6597938,0.84,0.6597938,0.8466667,0.6597938,0.85,0.6597938,0.85333335,0.6597938,0.8566667,0.6597938,0.88,0.6597938,0.8833333,0.6597938,0.88666666,0.6597938,0.89,0.6597938,0.8933333,0.6597938,0.89666665,0.6597938,0.9,0.6597938,0.9033333,0.6597938,0.9066667,0.6597938,0.91,0.6597938,0.91333336,0.6597938,0.9166667,0.6597938,0.07333333,0.66237116,0.07666667,0.66237116,0.08,0.66237116,0.083333336,0.66237116,0.086666666,0.66237116,0.09,0.66237116,0.10333333,0.66237116,0.10666667,0.66237116,0.11,0.66237116,0.11333334,0.66237116,0.11666667,0.66237116,0.12,0.66237116,0.123333335,0.66237116,0.12666667,0.66237116,0.13,0.66237116,0.13333334,0.66237116,0.13666667,0.66237116,0.14,0.66237116,0.14333333,0.66237116,0.14666666,0.66237116,0.15,0.66237116,0.15333334,0.66237116,0.15666667,0.66237116,0.16,0.66237116,0.16333333,0.66237116,0.16666667,0.66237116,0.17,0.66237116,0.17333333,0.66237116,0.17666666,0.66237116,0.18,0.66237116,0.18333334,0.66237116,0.18666667,0.66237116,0.19,0.66237116,0.22666667,0.66237116,0.23,0.66237116,0.23333333,0.66237116,0.23666666,0.66237116,0.24,0.66237116,0.24333334,0.66237116,0.24666667,0.66237116,0.25,0.66237116,0.25333333,0.66237116,0.25666666,0.66237116,0.26,0.66237116,0.26333332,0.66237116,0.26666668,0.66237116,0.27,0.66237116,0.27333334,0.66237116,0.27666667,0.66237116,0.28,0.66237116,0.28333333,0.66237116,0.28666666,0.66237116,0.29,0.66237116,0.29333332,0.66237116,0.29666665,0.66237116,0.3,0.66237116,0.30333334,0.66237116,0.30666667,0.66237116,0.31,0.66237116,0.31333333,0.66237116,0.31666666,0.66237116,0.32,0.66237116,0.32333332,0.66237116,0.32666665,0.66237116,0.33,0.66237116,0.33333334,0.66237116,0.33666667,0.66237116,0.34,0.66237116,0.34333333,0.66237116,0.34666666,0.66237116,0.35,0.66237116,0.35333332,0.66237116,0.37,0.66237116,0.37333333,0.66237116,0.37666667,0.66237116,0.38,0.66237116,0.38333333,0.66237116,0.38666666,0.66237116,0.39,0.66237116,0.39333335,0.66237116,0.39666668,0.66237116,0.4,0.66237116,0.40333334,0.66237116,0.40666667,0.66237116,0.41,0.66237116,0.41333333,0.66237116,0.41666666,0.66237116,0.42,0.66237116,0.42333335,0.66237116,0.47,0.66237116,0.47333333,0.66237116,0.47666666,0.66237116,0.48,0.66237116,0.48333332,0.66237116,0.48666668,0.66237116,0.49,0.66237116,0.49333334,0.66237116,0.49666667,0.66237116,0.5,0.66237116,0.50333333,0.66237116,0.50666666,0.66237116,0.51,0.66237116,0.5133333,0.66237116,0.51666665,0.66237116,0.52,0.66237116,0.5233333,0.66237116,0.52666664,0.66237116,0.53,0.66237116,0.53333336,0.66237116,0.5366667,0.66237116,0.54,0.66237116,0.5833333,0.66237116,0.58666664,0.66237116,0.59,0.66237116,0.5933333,0.66237116,0.5966667,0.66237116,0.6,0.66237116,0.60333335,0.66237116,0.6066667,0.66237116,0.61,0.66237116,0.61333334,0.66237116,0.6166667,0.66237116,0.62,0.66237116,0.62333333,0.66237116,0.62666667,0.66237116,0.63,0.66237116,0.6333333,0.66237116,0.65,0.66237116,0.6533333,0.66237116,0.6566667,0.66237116,0.66,0.66237116,0.66333336,0.66237116,0.6666667,0.66237116,0.67,0.66237116,0.67333335,0.66237116,0.6766667,0.66237116,0.68,0.66237116,0.68333334,0.66237116,0.68666667,0.66237116,0.69,0.66237116,0.6933333,0.66237116,0.69666666,0.66237116,0.7133333,0.66237116,0.71666664,0.66237116,0.72,0.66237116,0.72333336,0.66237116,0.7266667,0.66237116,0.73,0.66237116,0.73333335,0.66237116,0.7366667,0.66237116,0.74,0.66237116,0.74333334,0.66237116,0.74666667,0.66237116,0.75,0.66237116,0.75333333,0.66237116,0.75666666,0.66237116,0.76,0.66237116,0.7633333,0.66237116,0.76666665,0.66237116,0.77,0.66237116,0.7733333,0.66237116,0.77666664,0.66237116,0.78,0.66237116,0.78333336,0.66237116,0.7866667,0.66237116,0.79,0.66237116,0.79333335,0.66237116,0.81,0.66237116,0.81333333,0.66237116,0.81666666,0.66237116,0.82,0.66237116,0.8333333,0.66237116,0.83666664,0.66237116,0.84,0.66237116,0.8433333,0.66237116,0.8466667,0.66237116,0.85,0.66237116,0.85333335,0.66237116,0.8566667,0.66237116,0.86,0.66237116,0.86333334,0.66237116,0.8666667,0.66237116,0.87,0.66237116,0.87333333,0.66237116,0.87666667,0.66237116,0.88,0.66237116,0.8833333,0.66237116,0.88666666,0.66237116,0.89,0.66237116,0.8933333,0.66237116,0.89666665,0.66237116,0.9,0.66237116,0.9033333,0.66237116,0.9066667,0.66237116,0.91,0.66237116,0.91333336,0.66237116,0.9166667,0.66237116,0.07,0.66494846,0.07333333,0.66494846,0.07666667,0.66494846,0.08,0.66494846,0.083333336,0.66494846,0.086666666,0.66494846,0.09,0.66494846,0.10333333,0.66494846,0.10666667,0.66494846,0.11,0.66494846,0.11333334,0.66494846,0.11666667,0.66494846,0.12,0.66494846,0.123333335,0.66494846,0.12666667,0.66494846,0.13,0.66494846,0.13333334,0.66494846,0.13666667,0.66494846,0.14,0.66494846,0.14333333,0.66494846,0.15,0.66494846,0.15333334,0.66494846,0.15666667,0.66494846,0.16,0.66494846,0.16333333,0.66494846,0.16666667,0.66494846,0.17,0.66494846,0.17333333,0.66494846,0.17666666,0.66494846,0.18,0.66494846,0.18333334,0.66494846,0.18666667,0.66494846,0.19,0.66494846,0.19333333,0.66494846,0.21,0.66494846,0.22333333,0.66494846,0.22666667,0.66494846,0.23,0.66494846,0.23333333,0.66494846,0.23666666,0.66494846,0.24,0.66494846,0.24333334,0.66494846,0.24666667,0.66494846,0.25,0.66494846,0.25333333,0.66494846,0.25666666,0.66494846,0.26,0.66494846,0.26333332,0.66494846,0.26666668,0.66494846,0.27,0.66494846,0.27333334,0.66494846,0.27666667,0.66494846,0.28,0.66494846,0.28333333,0.66494846,0.28666666,0.66494846,0.29,0.66494846,0.29333332,0.66494846,0.29666665,0.66494846,0.3,0.66494846,0.30333334,0.66494846,0.30666667,0.66494846,0.31,0.66494846,0.31333333,0.66494846,0.31666666,0.66494846,0.32,0.66494846,0.32333332,0.66494846,0.32666665,0.66494846,0.33,0.66494846,0.33333334,0.66494846,0.33666667,0.66494846,0.34,0.66494846,0.34333333,0.66494846,0.34666666,0.66494846,0.35,0.66494846,0.37,0.66494846,0.37333333,0.66494846,0.37666667,0.66494846,0.38,0.66494846,0.38333333,0.66494846,0.38666666,0.66494846,0.39,0.66494846,0.39333335,0.66494846,0.39666668,0.66494846,0.4,0.66494846,0.40333334,0.66494846,0.40666667,0.66494846,0.41,0.66494846,0.41333333,0.66494846,0.41666666,0.66494846,0.42,0.66494846,0.42333335,0.66494846,0.42666668,0.66494846,0.46666667,0.66494846,0.47,0.66494846,0.47333333,0.66494846,0.47666666,0.66494846,0.48,0.66494846,0.48333332,0.66494846,0.48666668,0.66494846,0.49,0.66494846,0.49333334,0.66494846,0.49666667,0.66494846,0.5,0.66494846,0.50333333,0.66494846,0.50666666,0.66494846,0.51,0.66494846,0.5133333,0.66494846,0.51666665,0.66494846,0.52,0.66494846,0.5233333,0.66494846,0.52666664,0.66494846,0.53,0.66494846,0.53333336,0.66494846,0.5366667,0.66494846,0.54,0.66494846,0.54333335,0.66494846,0.58,0.66494846,0.5833333,0.66494846,0.58666664,0.66494846,0.59,0.66494846,0.5933333,0.66494846,0.5966667,0.66494846,0.6,0.66494846,0.60333335,0.66494846,0.6066667,0.66494846,0.61,0.66494846,0.61333334,0.66494846,0.6166667,0.66494846,0.62,0.66494846,0.62333333,0.66494846,0.65,0.66494846,0.6533333,0.66494846,0.6566667,0.66494846,0.66,0.66494846,0.66333336,0.66494846,0.6666667,0.66494846,0.67,0.66494846,0.67333335,0.66494846,0.6766667,0.66494846,0.68,0.66494846,0.68333334,0.66494846,0.68666667,0.66494846,0.69,0.66494846,0.6933333,0.66494846,0.69666666,0.66494846,0.7133333,0.66494846,0.71666664,0.66494846,0.72,0.66494846,0.72333336,0.66494846,0.7266667,0.66494846,0.73,0.66494846,0.73333335,0.66494846,0.7366667,0.66494846,0.74,0.66494846,0.74333334,0.66494846,0.74666667,0.66494846,0.75,0.66494846,0.75333333,0.66494846,0.75666666,0.66494846,0.76,0.66494846,0.7633333,0.66494846,0.76666665,0.66494846,0.77,0.66494846,0.7733333,0.66494846,0.77666664,0.66494846,0.78,0.66494846,0.78333336,0.66494846,0.7866667,0.66494846,0.79,0.66494846,0.79333335,0.66494846,0.81,0.66494846,0.81333333,0.66494846,0.81666666,0.66494846,0.82,0.66494846,0.8233333,0.66494846,0.8333333,0.66494846,0.83666664,0.66494846,0.84,0.66494846,0.8433333,0.66494846,0.8466667,0.66494846,0.85,0.66494846,0.85333335,0.66494846,0.8566667,0.66494846,0.86,0.66494846,0.88,0.66494846,0.8833333,0.66494846,0.88666666,0.66494846,0.89,0.66494846,0.8933333,0.66494846,0.89666665,0.66494846,0.9,0.66494846,0.9033333,0.66494846,0.9066667,0.66494846,0.91333336,0.66494846,0.06666667,0.66752577,0.07,0.66752577,0.07333333,0.66752577,0.07666667,0.66752577,0.08,0.66752577,0.083333336,0.66752577,0.086666666,0.66752577,0.09,0.66752577,0.10333333,0.66752577,0.10666667,0.66752577,0.11,0.66752577,0.11333334,0.66752577,0.11666667,0.66752577,0.12,0.66752577,0.123333335,0.66752577,0.12666667,0.66752577,0.13,0.66752577,0.13333334,0.66752577,0.13666667,0.66752577,0.14,0.66752577,0.14333333,0.66752577,0.14666666,0.66752577,0.15,0.66752577,0.15333334,0.66752577,0.15666667,0.66752577,0.16,0.66752577,0.16333333,0.66752577,0.16666667,0.66752577,0.17,0.66752577,0.17333333,0.66752577,0.17666666,0.66752577,0.18,0.66752577,0.18333334,0.66752577,0.18666667,0.66752577,0.19,0.66752577,0.19333333,0.66752577,0.19666667,0.66752577,0.20666666,0.66752577,0.21,0.66752577,0.21666667,0.66752577,0.22,0.66752577,0.22333333,0.66752577,0.22666667,0.66752577,0.23,0.66752577,0.23333333,0.66752577,0.23666666,0.66752577,0.24,0.66752577,0.24333334,0.66752577,0.24666667,0.66752577,0.25,0.66752577,0.25333333,0.66752577,0.25666666,0.66752577,0.26,0.66752577,0.26333332,0.66752577,0.26666668,0.66752577,0.27,0.66752577,0.27333334,0.66752577,0.27666667,0.66752577,0.28,0.66752577,0.28333333,0.66752577,0.28666666,0.66752577,0.29,0.66752577,0.29333332,0.66752577,0.29666665,0.66752577,0.3,0.66752577,0.30333334,0.66752577,0.30666667,0.66752577,0.31,0.66752577,0.31333333,0.66752577,0.31666666,0.66752577,0.32,0.66752577,0.32333332,0.66752577,0.32666665,0.66752577,0.33,0.66752577,0.33333334,0.66752577,0.33666667,0.66752577,0.34,0.66752577,0.34333333,0.66752577,0.34666666,0.66752577,0.35,0.66752577,0.37,0.66752577,0.37333333,0.66752577,0.37666667,0.66752577,0.38,0.66752577,0.38333333,0.66752577,0.38666666,0.66752577,0.39,0.66752577,0.39333335,0.66752577,0.39666668,0.66752577,0.4,0.66752577,0.40333334,0.66752577,0.40666667,0.66752577,0.41,0.66752577,0.41333333,0.66752577,0.41666666,0.66752577,0.42,0.66752577,0.42333335,0.66752577,0.42666668,0.66752577,0.46666667,0.66752577,0.47,0.66752577,0.47333333,0.66752577,0.47666666,0.66752577,0.48,0.66752577,0.48333332,0.66752577,0.48666668,0.66752577,0.49,0.66752577,0.49333334,0.66752577,0.49666667,0.66752577,0.5,0.66752577,0.50333333,0.66752577,0.50666666,0.66752577,0.51,0.66752577,0.5133333,0.66752577,0.51666665,0.66752577,0.52,0.66752577,0.5233333,0.66752577,0.52666664,0.66752577,0.53,0.66752577,0.53333336,0.66752577,0.5366667,0.66752577,0.54,0.66752577,0.54333335,0.66752577,0.5466667,0.66752577,0.57666665,0.66752577,0.58,0.66752577,0.5833333,0.66752577,0.58666664,0.66752577,0.59,0.66752577,0.5933333,0.66752577,0.5966667,0.66752577,0.6,0.66752577,0.60333335,0.66752577,0.65,0.66752577,0.6533333,0.66752577,0.6566667,0.66752577,0.66,0.66752577,0.66333336,0.66752577,0.6666667,0.66752577,0.67,0.66752577,0.67333335,0.66752577,0.6766667,0.66752577,0.68,0.66752577,0.68333334,0.66752577,0.68666667,0.66752577,0.69,0.66752577,0.6933333,0.66752577,0.71,0.66752577,0.7133333,0.66752577,0.71666664,0.66752577,0.72,0.66752577,0.72333336,0.66752577,0.7266667,0.66752577,0.73,0.66752577,0.73333335,0.66752577,0.7366667,0.66752577,0.74,0.66752577,0.74333334,0.66752577,0.74666667,0.66752577,0.75,0.66752577,0.75333333,0.66752577,0.75666666,0.66752577,0.76,0.66752577,0.7633333,0.66752577,0.76666665,0.66752577,0.77,0.66752577,0.7733333,0.66752577,0.77666664,0.66752577,0.78,0.66752577,0.78333336,0.66752577,0.7866667,0.66752577,0.79,0.66752577,0.79333335,0.66752577,0.81,0.66752577,0.81333333,0.66752577,0.81666666,0.66752577,0.82,0.66752577,0.8233333,0.66752577,0.8333333,0.66752577,0.83666664,0.66752577,0.84,0.66752577,0.8433333,0.66752577,0.8466667,0.66752577,0.85,0.66752577,0.85333335,0.66752577,0.8566667,0.66752577,0.89,0.66752577,0.8933333,0.66752577,0.89666665,0.66752577,0.9,0.66752577,0.9033333,0.66752577,0.06666667,0.6701031,0.07,0.6701031,0.07333333,0.6701031,0.07666667,0.6701031,0.08,0.6701031,0.083333336,0.6701031,0.086666666,0.6701031,0.09,0.6701031,0.093333334,0.6701031,0.10333333,0.6701031,0.10666667,0.6701031,0.11,0.6701031,0.11333334,0.6701031,0.11666667,0.6701031,0.12,0.6701031,0.123333335,0.6701031,0.12666667,0.6701031,0.13,0.6701031,0.13333334,0.6701031,0.13666667,0.6701031,0.14,0.6701031,0.14333333,0.6701031,0.14666666,0.6701031,0.15,0.6701031,0.15333334,0.6701031,0.15666667,0.6701031,0.16,0.6701031,0.16333333,0.6701031,0.16666667,0.6701031,0.17,0.6701031,0.17333333,0.6701031,0.17666666,0.6701031,0.18,0.6701031,0.18333334,0.6701031,0.18666667,0.6701031,0.19,0.6701031,0.19333333,0.6701031,0.19666667,0.6701031,0.2,0.6701031,0.20333333,0.6701031,0.20666666,0.6701031,0.21,0.6701031,0.21333334,0.6701031,0.21666667,0.6701031,0.22,0.6701031,0.22333333,0.6701031,0.22666667,0.6701031,0.23,0.6701031,0.23333333,0.6701031,0.23666666,0.6701031,0.24,0.6701031,0.24333334,0.6701031,0.24666667,0.6701031,0.25,0.6701031,0.25333333,0.6701031,0.25666666,0.6701031,0.26,0.6701031,0.26333332,0.6701031,0.26666668,0.6701031,0.27,0.6701031,0.27333334,0.6701031,0.27666667,0.6701031,0.28,0.6701031,0.28333333,0.6701031,0.28666666,0.6701031,0.29,0.6701031,0.29333332,0.6701031,0.29666665,0.6701031,0.3,0.6701031,0.30333334,0.6701031,0.32,0.6701031,0.32333332,0.6701031,0.32666665,0.6701031,0.33,0.6701031,0.33333334,0.6701031,0.33666667,0.6701031,0.34,0.6701031,0.34333333,0.6701031,0.34666666,0.6701031,0.37,0.6701031,0.37333333,0.6701031,0.37666667,0.6701031,0.38,0.6701031,0.38333333,0.6701031,0.38666666,0.6701031,0.39,0.6701031,0.39333335,0.6701031,0.39666668,0.6701031,0.4,0.6701031,0.40333334,0.6701031,0.40666667,0.6701031,0.41,0.6701031,0.41333333,0.6701031,0.41666666,0.6701031,0.42,0.6701031,0.42333335,0.6701031,0.42666668,0.6701031,0.43,0.6701031,0.46333334,0.6701031,0.46666667,0.6701031,0.47,0.6701031,0.47333333,0.6701031,0.47666666,0.6701031,0.48,0.6701031,0.48333332,0.6701031,0.48666668,0.6701031,0.49,0.6701031,0.49333334,0.6701031,0.49666667,0.6701031,0.5,0.6701031,0.50333333,0.6701031,0.50666666,0.6701031,0.51,0.6701031,0.5133333,0.6701031,0.51666665,0.6701031,0.52,0.6701031,0.5233333,0.6701031,0.52666664,0.6701031,0.53,0.6701031,0.53333336,0.6701031,0.5366667,0.6701031,0.54,0.6701031,0.54333335,0.6701031,0.5466667,0.6701031,0.55,0.6701031,0.55333334,0.6701031,0.5566667,0.6701031,0.56666666,0.6701031,0.57,0.6701031,0.5733333,0.6701031,0.57666665,0.6701031,0.58,0.6701031,0.5833333,0.6701031,0.58666664,0.6701031,0.59,0.6701031,0.5933333,0.6701031,0.5966667,0.6701031,0.65,0.6701031,0.6533333,0.6701031,0.6566667,0.6701031,0.66,0.6701031,0.66333336,0.6701031,0.6666667,0.6701031,0.67,0.6701031,0.67333335,0.6701031,0.6766667,0.6701031,0.68,0.6701031,0.68333334,0.6701031,0.68666667,0.6701031,0.69,0.6701031,0.6933333,0.6701031,0.70666665,0.6701031,0.71,0.6701031,0.7133333,0.6701031,0.71666664,0.6701031,0.72,0.6701031,0.72333336,0.6701031,0.7266667,0.6701031,0.73,0.6701031,0.73333335,0.6701031,0.7366667,0.6701031,0.74,0.6701031,0.74333334,0.6701031,0.74666667,0.6701031,0.75,0.6701031,0.75333333,0.6701031,0.75666666,0.6701031,0.76,0.6701031,0.7633333,0.6701031,0.76666665,0.6701031,0.77,0.6701031,0.7733333,0.6701031,0.77666664,0.6701031,0.78,0.6701031,0.78333336,0.6701031,0.7866667,0.6701031,0.79,0.6701031,0.8066667,0.6701031,0.81,0.6701031,0.81333333,0.6701031,0.81666666,0.6701031,0.82,0.6701031,0.8233333,0.6701031,0.8333333,0.6701031,0.83666664,0.6701031,0.84,0.6701031,0.8433333,0.6701031,0.8466667,0.6701031,0.85,0.6701031,0.85333335,0.6701031,0.8566667,0.6701031,0.06666667,0.67268044,0.07,0.67268044,0.07333333,0.67268044,0.07666667,0.67268044,0.08,0.67268044,0.083333336,0.67268044,0.086666666,0.67268044,0.09,0.67268044,0.093333334,0.67268044,0.096666664,0.67268044,0.1,0.67268044,0.10333333,0.67268044,0.10666667,0.67268044,0.11,0.67268044,0.11333334,0.67268044,0.11666667,0.67268044,0.12,0.67268044,0.123333335,0.67268044,0.12666667,0.67268044,0.13,0.67268044,0.13333334,0.67268044,0.13666667,0.67268044,0.14,0.67268044,0.14333333,0.67268044,0.14666666,0.67268044,0.15,0.67268044,0.15333334,0.67268044,0.15666667,0.67268044,0.16,0.67268044,0.16333333,0.67268044,0.16666667,0.67268044,0.17,0.67268044,0.17333333,0.67268044,0.17666666,0.67268044,0.18,0.67268044,0.18333334,0.67268044,0.18666667,0.67268044,0.19,0.67268044,0.19333333,0.67268044,0.19666667,0.67268044,0.2,0.67268044,0.20333333,0.67268044,0.20666666,0.67268044,0.21,0.67268044,0.21333334,0.67268044,0.21666667,0.67268044,0.22,0.67268044,0.22333333,0.67268044,0.22666667,0.67268044,0.23,0.67268044,0.23333333,0.67268044,0.23666666,0.67268044,0.24,0.67268044,0.24333334,0.67268044,0.24666667,0.67268044,0.25,0.67268044,0.25333333,0.67268044,0.25666666,0.67268044,0.26,0.67268044,0.26333332,0.67268044,0.26666668,0.67268044,0.27,0.67268044,0.27333334,0.67268044,0.27666667,0.67268044,0.28,0.67268044,0.28333333,0.67268044,0.28666666,0.67268044,0.29,0.67268044,0.29333332,0.67268044,0.29666665,0.67268044,0.33333334,0.67268044,0.33666667,0.67268044,0.37333333,0.67268044,0.37666667,0.67268044,0.38,0.67268044,0.38333333,0.67268044,0.38666666,0.67268044,0.39,0.67268044,0.39333335,0.67268044,0.39666668,0.67268044,0.4,0.67268044,0.40333334,0.67268044,0.40666667,0.67268044,0.41,0.67268044,0.41333333,0.67268044,0.41666666,0.67268044,0.42,0.67268044,0.42333335,0.67268044,0.42666668,0.67268044,0.43,0.67268044,0.43333334,0.67268044,0.45666668,0.67268044,0.46,0.67268044,0.46333334,0.67268044,0.46666667,0.67268044,0.47,0.67268044,0.47333333,0.67268044,0.47666666,0.67268044,0.48,0.67268044,0.48333332,0.67268044,0.48666668,0.67268044,0.49,0.67268044,0.49333334,0.67268044,0.49666667,0.67268044,0.5,0.67268044,0.50333333,0.67268044,0.50666666,0.67268044,0.51,0.67268044,0.5133333,0.67268044,0.51666665,0.67268044,0.52,0.67268044,0.5233333,0.67268044,0.52666664,0.67268044,0.53,0.67268044,0.53333336,0.67268044,0.5366667,0.67268044,0.54,0.67268044,0.54333335,0.67268044,0.5466667,0.67268044,0.55,0.67268044,0.55333334,0.67268044,0.5566667,0.67268044,0.56,0.67268044,0.56333333,0.67268044,0.56666666,0.67268044,0.57,0.67268044,0.5733333,0.67268044,0.57666665,0.67268044,0.58,0.67268044,0.5833333,0.67268044,0.58666664,0.67268044,0.59,0.67268044,0.5933333,0.67268044,0.65,0.67268044,0.6533333,0.67268044,0.6566667,0.67268044,0.66,0.67268044,0.66333336,0.67268044,0.6666667,0.67268044,0.67,0.67268044,0.67333335,0.67268044,0.6766667,0.67268044,0.68,0.67268044,0.68333334,0.67268044,0.68666667,0.67268044,0.69,0.67268044,0.6933333,0.67268044,0.70666665,0.67268044,0.71,0.67268044,0.7133333,0.67268044,0.71666664,0.67268044,0.72,0.67268044,0.72333336,0.67268044,0.7266667,0.67268044,0.73,0.67268044,0.73333335,0.67268044,0.7366667,0.67268044,0.74,0.67268044,0.74333334,0.67268044,0.74666667,0.67268044,0.75,0.67268044,0.75333333,0.67268044,0.75666666,0.67268044,0.76,0.67268044,0.7633333,0.67268044,0.76666665,0.67268044,0.77,0.67268044,0.7733333,0.67268044,0.77666664,0.67268044,0.78,0.67268044,0.78333336,0.67268044,0.7866667,0.67268044,0.79,0.67268044,0.80333334,0.67268044,0.8066667,0.67268044,0.81,0.67268044,0.81333333,0.67268044,0.81666666,0.67268044,0.82,0.67268044,0.8233333,0.67268044,0.82666665,0.67268044,0.83,0.67268044,0.8333333,0.67268044,0.83666664,0.67268044,0.84,0.67268044,0.8433333,0.67268044,0.8466667,0.67268044,0.85,0.67268044,0.85333335,0.67268044,0.8566667,0.67268044,0.06333333,0.67525774,0.06666667,0.67525774,0.07,0.67525774,0.07333333,0.67525774,0.07666667,0.67525774,0.08,0.67525774,0.083333336,0.67525774,0.086666666,0.67525774,0.09,0.67525774,0.093333334,0.67525774,0.096666664,0.67525774,0.1,0.67525774,0.10333333,0.67525774,0.10666667,0.67525774,0.11,0.67525774,0.11333334,0.67525774,0.11666667,0.67525774,0.12,0.67525774,0.123333335,0.67525774,0.12666667,0.67525774,0.13,0.67525774,0.13333334,0.67525774,0.13666667,0.67525774,0.14,0.67525774,0.14333333,0.67525774,0.14666666,0.67525774,0.15,0.67525774,0.15333334,0.67525774,0.15666667,0.67525774,0.16,0.67525774,0.16333333,0.67525774,0.16666667,0.67525774,0.17,0.67525774,0.17333333,0.67525774,0.17666666,0.67525774,0.18,0.67525774,0.18333334,0.67525774,0.18666667,0.67525774,0.19,0.67525774,0.19333333,0.67525774,0.19666667,0.67525774,0.2,0.67525774,0.20333333,0.67525774,0.20666666,0.67525774,0.21,0.67525774,0.21333334,0.67525774,0.21666667,0.67525774,0.22,0.67525774,0.22333333,0.67525774,0.22666667,0.67525774,0.23,0.67525774,0.23333333,0.67525774,0.23666666,0.67525774,0.24,0.67525774,0.24333334,0.67525774,0.24666667,0.67525774,0.25,0.67525774,0.25333333,0.67525774,0.25666666,0.67525774,0.26,0.67525774,0.26333332,0.67525774,0.26666668,0.67525774,0.27,0.67525774,0.27333334,0.67525774,0.27666667,0.67525774,0.28,0.67525774,0.28333333,0.67525774,0.28666666,0.67525774,0.29,0.67525774,0.29333332,0.67525774,0.37333333,0.67525774,0.37666667,0.67525774,0.38,0.67525774,0.38333333,0.67525774,0.38666666,0.67525774,0.39,0.67525774,0.39333335,0.67525774,0.39666668,0.67525774,0.4,0.67525774,0.40333334,0.67525774,0.40666667,0.67525774,0.41,0.67525774,0.41333333,0.67525774,0.41666666,0.67525774,0.42,0.67525774,0.42333335,0.67525774,0.42666668,0.67525774,0.43,0.67525774,0.43333334,0.67525774,0.43666667,0.67525774,0.44,0.67525774,0.44333333,0.67525774,0.44666666,0.67525774,0.45,0.67525774,0.45333335,0.67525774,0.45666668,0.67525774,0.46,0.67525774,0.46333334,0.67525774,0.46666667,0.67525774,0.47,0.67525774,0.47333333,0.67525774,0.47666666,0.67525774,0.48,0.67525774,0.48333332,0.67525774,0.48666668,0.67525774,0.49,0.67525774,0.49333334,0.67525774,0.49666667,0.67525774,0.5,0.67525774,0.50333333,0.67525774,0.50666666,0.67525774,0.51,0.67525774,0.5133333,0.67525774,0.51666665,0.67525774,0.52,0.67525774,0.5233333,0.67525774,0.52666664,0.67525774,0.53,0.67525774,0.53333336,0.67525774,0.5366667,0.67525774,0.54,0.67525774,0.54333335,0.67525774,0.5466667,0.67525774,0.55,0.67525774,0.55333334,0.67525774,0.5566667,0.67525774,0.56,0.67525774,0.56333333,0.67525774,0.56666666,0.67525774,0.57,0.67525774,0.5733333,0.67525774,0.57666665,0.67525774,0.58,0.67525774,0.5833333,0.67525774,0.58666664,0.67525774,0.65,0.67525774,0.6533333,0.67525774,0.6566667,0.67525774,0.66,0.67525774,0.66333336,0.67525774,0.6666667,0.67525774,0.67,0.67525774,0.67333335,0.67525774,0.6766667,0.67525774,0.68,0.67525774,0.68333334,0.67525774,0.68666667,0.67525774,0.69,0.67525774,0.7033333,0.67525774,0.70666665,0.67525774,0.71,0.67525774,0.7133333,0.67525774,0.71666664,0.67525774,0.72,0.67525774,0.72333336,0.67525774,0.74666667,0.67525774,0.75,0.67525774,0.75333333,0.67525774,0.75666666,0.67525774,0.76,0.67525774,0.7633333,0.67525774,0.76666665,0.67525774,0.77,0.67525774,0.7733333,0.67525774,0.77666664,0.67525774,0.78,0.67525774,0.78333336,0.67525774,0.7866667,0.67525774,0.79,0.67525774,0.79333335,0.67525774,0.7966667,0.67525774,0.8,0.67525774,0.80333334,0.67525774,0.8066667,0.67525774,0.81,0.67525774,0.81333333,0.67525774,0.81666666,0.67525774,0.82,0.67525774,0.8233333,0.67525774,0.82666665,0.67525774,0.83,0.67525774,0.8333333,0.67525774,0.83666664,0.67525774,0.84,0.67525774,0.8433333,0.67525774,0.8466667,0.67525774,0.85,0.67525774,0.85333335,0.67525774,0.06333333,0.67783505,0.06666667,0.67783505,0.07,0.67783505,0.07333333,0.67783505,0.07666667,0.67783505,0.08,0.67783505,0.083333336,0.67783505,0.086666666,0.67783505,0.09,0.67783505,0.093333334,0.67783505,0.096666664,0.67783505,0.1,0.67783505,0.10333333,0.67783505,0.10666667,0.67783505,0.11,0.67783505,0.11333334,0.67783505,0.11666667,0.67783505,0.12,0.67783505,0.123333335,0.67783505,0.12666667,0.67783505,0.13,0.67783505,0.13333334,0.67783505,0.13666667,0.67783505,0.14,0.67783505,0.14333333,0.67783505,0.14666666,0.67783505,0.15,0.67783505,0.15333334,0.67783505,0.15666667,0.67783505,0.16,0.67783505,0.16333333,0.67783505,0.16666667,0.67783505,0.17,0.67783505,0.17333333,0.67783505,0.17666666,0.67783505,0.18,0.67783505,0.18333334,0.67783505,0.18666667,0.67783505,0.19,0.67783505,0.19333333,0.67783505,0.19666667,0.67783505,0.2,0.67783505,0.20333333,0.67783505,0.20666666,0.67783505,0.21,0.67783505,0.21333334,0.67783505,0.21666667,0.67783505,0.22,0.67783505,0.22333333,0.67783505,0.22666667,0.67783505,0.23,0.67783505,0.23333333,0.67783505,0.23666666,0.67783505,0.24,0.67783505,0.24333334,0.67783505,0.24666667,0.67783505,0.25,0.67783505,0.25333333,0.67783505,0.25666666,0.67783505,0.26,0.67783505,0.26333332,0.67783505,0.26666668,0.67783505,0.27,0.67783505,0.27333334,0.67783505,0.27666667,0.67783505,0.28,0.67783505,0.28333333,0.67783505,0.28666666,0.67783505,0.29,0.67783505,0.37666667,0.67783505,0.38,0.67783505,0.38333333,0.67783505,0.38666666,0.67783505,0.39,0.67783505,0.39333335,0.67783505,0.39666668,0.67783505,0.4,0.67783505,0.40333334,0.67783505,0.40666667,0.67783505,0.41,0.67783505,0.43,0.67783505,0.43333334,0.67783505,0.43666667,0.67783505,0.44,0.67783505,0.44333333,0.67783505,0.44666666,0.67783505,0.45,0.67783505,0.45333335,0.67783505,0.45666668,0.67783505,0.46,0.67783505,0.46333334,0.67783505,0.46666667,0.67783505,0.47,0.67783505,0.47333333,0.67783505,0.47666666,0.67783505,0.48,0.67783505,0.48333332,0.67783505,0.48666668,0.67783505,0.49,0.67783505,0.49333334,0.67783505,0.49666667,0.67783505,0.5,0.67783505,0.50333333,0.67783505,0.50666666,0.67783505,0.51,0.67783505,0.5133333,0.67783505,0.51666665,0.67783505,0.52,0.67783505,0.5233333,0.67783505,0.52666664,0.67783505,0.53,0.67783505,0.53333336,0.67783505,0.5366667,0.67783505,0.54,0.67783505,0.54333335,0.67783505,0.5466667,0.67783505,0.55,0.67783505,0.55333334,0.67783505,0.5566667,0.67783505,0.56,0.67783505,0.56333333,0.67783505,0.56666666,0.67783505,0.57,0.67783505,0.5733333,0.67783505,0.57666665,0.67783505,0.58,0.67783505,0.5833333,0.67783505,0.58666664,0.67783505,0.6533333,0.67783505,0.6566667,0.67783505,0.66,0.67783505,0.66333336,0.67783505,0.6666667,0.67783505,0.67,0.67783505,0.67333335,0.67783505,0.6766667,0.67783505,0.68,0.67783505,0.68333334,0.67783505,0.68666667,0.67783505,0.69,0.67783505,0.6933333,0.67783505,0.69666666,0.67783505,0.7,0.67783505,0.7033333,0.67783505,0.70666665,0.67783505,0.71,0.67783505,0.7133333,0.67783505,0.71666664,0.67783505,0.75333333,0.67783505,0.75666666,0.67783505,0.76,0.67783505,0.7633333,0.67783505,0.76666665,0.67783505,0.77,0.67783505,0.7733333,0.67783505,0.77666664,0.67783505,0.78,0.67783505,0.78333336,0.67783505,0.7866667,0.67783505,0.79,0.67783505,0.79333335,0.67783505,0.7966667,0.67783505,0.8,0.67783505,0.80333334,0.67783505,0.8066667,0.67783505,0.81,0.67783505,0.81333333,0.67783505,0.81666666,0.67783505,0.82,0.67783505,0.8233333,0.67783505,0.82666665,0.67783505,0.83,0.67783505,0.8333333,0.67783505,0.83666664,0.67783505,0.84,0.67783505,0.8433333,0.67783505,0.8466667,0.67783505,0.85,0.67783505,0.85333335,0.67783505,0.06333333,0.68041235,0.06666667,0.68041235,0.07,0.68041235,0.07333333,0.68041235,0.07666667,0.68041235,0.08,0.68041235,0.083333336,0.68041235,0.086666666,0.68041235,0.09,0.68041235,0.093333334,0.68041235,0.096666664,0.68041235,0.1,0.68041235,0.10333333,0.68041235,0.10666667,0.68041235,0.11,0.68041235,0.11333334,0.68041235,0.11666667,0.68041235,0.12,0.68041235,0.123333335,0.68041235,0.12666667,0.68041235,0.13,0.68041235,0.13333334,0.68041235,0.13666667,0.68041235,0.14,0.68041235,0.14333333,0.68041235,0.14666666,0.68041235,0.15,0.68041235,0.15333334,0.68041235,0.15666667,0.68041235,0.16,0.68041235,0.16333333,0.68041235,0.16666667,0.68041235,0.17,0.68041235,0.17333333,0.68041235,0.17666666,0.68041235,0.18,0.68041235,0.18333334,0.68041235,0.18666667,0.68041235,0.19,0.68041235,0.19333333,0.68041235,0.19666667,0.68041235,0.2,0.68041235,0.20333333,0.68041235,0.20666666,0.68041235,0.21,0.68041235,0.21333334,0.68041235,0.21666667,0.68041235,0.22,0.68041235,0.22333333,0.68041235,0.22666667,0.68041235,0.23,0.68041235,0.23333333,0.68041235,0.23666666,0.68041235,0.24,0.68041235,0.24333334,0.68041235,0.24666667,0.68041235,0.25,0.68041235,0.25333333,0.68041235,0.25666666,0.68041235,0.26,0.68041235,0.26333332,0.68041235,0.26666668,0.68041235,0.27,0.68041235,0.27333334,0.68041235,0.27666667,0.68041235,0.28,0.68041235,0.28333333,0.68041235,0.28666666,0.68041235,0.29,0.68041235,0.38,0.68041235,0.38333333,0.68041235,0.38666666,0.68041235,0.39,0.68041235,0.39333335,0.68041235,0.39666668,0.68041235,0.4,0.68041235,0.40333334,0.68041235,0.43333334,0.68041235,0.43666667,0.68041235,0.44,0.68041235,0.44333333,0.68041235,0.44666666,0.68041235,0.45,0.68041235,0.45333335,0.68041235,0.45666668,0.68041235,0.46,0.68041235,0.46333334,0.68041235,0.46666667,0.68041235,0.47,0.68041235,0.47333333,0.68041235,0.47666666,0.68041235,0.48,0.68041235,0.48333332,0.68041235,0.48666668,0.68041235,0.49,0.68041235,0.49333334,0.68041235,0.49666667,0.68041235,0.5,0.68041235,0.50333333,0.68041235,0.50666666,0.68041235,0.51,0.68041235,0.5133333,0.68041235,0.51666665,0.68041235,0.52,0.68041235,0.5233333,0.68041235,0.52666664,0.68041235,0.53,0.68041235,0.53333336,0.68041235,0.5366667,0.68041235,0.54,0.68041235,0.54333335,0.68041235,0.5466667,0.68041235,0.55,0.68041235,0.55333334,0.68041235,0.5566667,0.68041235,0.56,0.68041235,0.56333333,0.68041235,0.56666666,0.68041235,0.57,0.68041235,0.5733333,0.68041235,0.57666665,0.68041235,0.58,0.68041235,0.5833333,0.68041235,0.6533333,0.68041235,0.6566667,0.68041235,0.66,0.68041235,0.66333336,0.68041235,0.6666667,0.68041235,0.67,0.68041235,0.67333335,0.68041235,0.6766667,0.68041235,0.68,0.68041235,0.68333334,0.68041235,0.68666667,0.68041235,0.69,0.68041235,0.6933333,0.68041235,0.69666666,0.68041235,0.7,0.68041235,0.7033333,0.68041235,0.70666665,0.68041235,0.71,0.68041235,0.7133333,0.68041235,0.75333333,0.68041235,0.75666666,0.68041235,0.76,0.68041235,0.7633333,0.68041235,0.76666665,0.68041235,0.77,0.68041235,0.7733333,0.68041235,0.77666664,0.68041235,0.78,0.68041235,0.78333336,0.68041235,0.7866667,0.68041235,0.79,0.68041235,0.79333335,0.68041235,0.7966667,0.68041235,0.8,0.68041235,0.80333334,0.68041235,0.8066667,0.68041235,0.81,0.68041235,0.81333333,0.68041235,0.81666666,0.68041235,0.82,0.68041235,0.8233333,0.68041235,0.82666665,0.68041235,0.83,0.68041235,0.8333333,0.68041235,0.83666664,0.68041235,0.84,0.68041235,0.8433333,0.68041235,0.8466667,0.68041235,0.85,0.68041235,0.85333335,0.68041235,0.06333333,0.6829897,0.06666667,0.6829897,0.07,0.6829897,0.07333333,0.6829897,0.07666667,0.6829897,0.08,0.6829897,0.083333336,0.6829897,0.086666666,0.6829897,0.09,0.6829897,0.093333334,0.6829897,0.096666664,0.6829897,0.1,0.6829897,0.10333333,0.6829897,0.10666667,0.6829897,0.11,0.6829897,0.11333334,0.6829897,0.11666667,0.6829897,0.12,0.6829897,0.123333335,0.6829897,0.12666667,0.6829897,0.13,0.6829897,0.14333333,0.6829897,0.14666666,0.6829897,0.15,0.6829897,0.15333334,0.6829897,0.15666667,0.6829897,0.16,0.6829897,0.16333333,0.6829897,0.16666667,0.6829897,0.17,0.6829897,0.17333333,0.6829897,0.17666666,0.6829897,0.18,0.6829897,0.18333334,0.6829897,0.18666667,0.6829897,0.19,0.6829897,0.19333333,0.6829897,0.19666667,0.6829897,0.2,0.6829897,0.20333333,0.6829897,0.20666666,0.6829897,0.21,0.6829897,0.21333334,0.6829897,0.21666667,0.6829897,0.22,0.6829897,0.22333333,0.6829897,0.22666667,0.6829897,0.23,0.6829897,0.23333333,0.6829897,0.23666666,0.6829897,0.25333333,0.6829897,0.25666666,0.6829897,0.26,0.6829897,0.26333332,0.6829897,0.26666668,0.6829897,0.27,0.6829897,0.27333334,0.6829897,0.27666667,0.6829897,0.28,0.6829897,0.28333333,0.6829897,0.28666666,0.6829897,0.29,0.6829897,0.38666666,0.6829897,0.39,0.6829897,0.39333335,0.6829897,0.44,0.6829897,0.44333333,0.6829897,0.44666666,0.6829897,0.45,0.6829897,0.45333335,0.6829897,0.45666668,0.6829897,0.46,0.6829897,0.46333334,0.6829897,0.46666667,0.6829897,0.47,0.6829897,0.47333333,0.6829897,0.47666666,0.6829897,0.48,0.6829897,0.48333332,0.6829897,0.48666668,0.6829897,0.49,0.6829897,0.49333334,0.6829897,0.49666667,0.6829897,0.5,0.6829897,0.50333333,0.6829897,0.50666666,0.6829897,0.51,0.6829897,0.5133333,0.6829897,0.51666665,0.6829897,0.52,0.6829897,0.5233333,0.6829897,0.52666664,0.6829897,0.53,0.6829897,0.53333336,0.6829897,0.5366667,0.6829897,0.54,0.6829897,0.54333335,0.6829897,0.5466667,0.6829897,0.55,0.6829897,0.55333334,0.6829897,0.5566667,0.6829897,0.56,0.6829897,0.56333333,0.6829897,0.56666666,0.6829897,0.57,0.6829897,0.5733333,0.6829897,0.57666665,0.6829897,0.58,0.6829897,0.5833333,0.6829897,0.6566667,0.6829897,0.66,0.6829897,0.66333336,0.6829897,0.6666667,0.6829897,0.67,0.6829897,0.67333335,0.6829897,0.6766667,0.6829897,0.68,0.6829897,0.68333334,0.6829897,0.68666667,0.6829897,0.69,0.6829897,0.6933333,0.6829897,0.69666666,0.6829897,0.7,0.6829897,0.7033333,0.6829897,0.70666665,0.6829897,0.71,0.6829897,0.75333333,0.6829897,0.75666666,0.6829897,0.76,0.6829897,0.7633333,0.6829897,0.76666665,0.6829897,0.77,0.6829897,0.7733333,0.6829897,0.77666664,0.6829897,0.78,0.6829897,0.78333336,0.6829897,0.7866667,0.6829897,0.79,0.6829897,0.8,0.6829897,0.80333334,0.6829897,0.8066667,0.6829897,0.81,0.6829897,0.81333333,0.6829897,0.81666666,0.6829897,0.82,0.6829897,0.8233333,0.6829897,0.82666665,0.6829897,0.83,0.6829897,0.8333333,0.6829897,0.83666664,0.6829897,0.84,0.6829897,0.8433333,0.6829897,0.8466667,0.6829897,0.85,0.6829897,0.06333333,0.685567,0.06666667,0.685567,0.07,0.685567,0.07333333,0.685567,0.07666667,0.685567,0.08,0.685567,0.083333336,0.685567,0.086666666,0.685567,0.09,0.685567,0.093333334,0.685567,0.096666664,0.685567,0.1,0.685567,0.10333333,0.685567,0.10666667,0.685567,0.11,0.685567,0.11333334,0.685567,0.11666667,0.685567,0.12,0.685567,0.123333335,0.685567,0.12666667,0.685567,0.14666666,0.685567,0.15,0.685567,0.15333334,0.685567,0.15666667,0.685567,0.16,0.685567,0.16333333,0.685567,0.16666667,0.685567,0.17,0.685567,0.17333333,0.685567,0.17666666,0.685567,0.18,0.685567,0.18333334,0.685567,0.18666667,0.685567,0.19,0.685567,0.19333333,0.685567,0.19666667,0.685567,0.2,0.685567,0.20333333,0.685567,0.20666666,0.685567,0.21,0.685567,0.21333334,0.685567,0.21666667,0.685567,0.22,0.685567,0.22333333,0.685567,0.22666667,0.685567,0.23,0.685567,0.23333333,0.685567,0.25666666,0.685567,0.26,0.685567,0.26333332,0.685567,0.26666668,0.685567,0.27,0.685567,0.27333334,0.685567,0.27666667,0.685567,0.28,0.685567,0.28333333,0.685567,0.28666666,0.685567,0.29,0.685567,0.44333333,0.685567,0.44666666,0.685567,0.45,0.685567,0.45333335,0.685567,0.45666668,0.685567,0.46,0.685567,0.46333334,0.685567,0.46666667,0.685567,0.47,0.685567,0.47333333,0.685567,0.47666666,0.685567,0.48,0.685567,0.48333332,0.685567,0.51,0.685567,0.5133333,0.685567,0.51666665,0.685567,0.52,0.685567,0.5233333,0.685567,0.52666664,0.685567,0.53,0.685567,0.53333336,0.685567,0.5366667,0.685567,0.54,0.685567,0.54333335,0.685567,0.5466667,0.685567,0.55,0.685567,0.55333334,0.685567,0.5566667,0.685567,0.56,0.685567,0.56333333,0.685567,0.56666666,0.685567,0.57,0.685567,0.5733333,0.685567,0.57666665,0.685567,0.58,0.685567,0.5833333,0.685567,0.6666667,0.685567,0.67,0.685567,0.67333335,0.685567,0.6766667,0.685567,0.68,0.685567,0.68333334,0.685567,0.68666667,0.685567,0.69,0.685567,0.6933333,0.685567,0.69666666,0.685567,0.7,0.685567,0.7033333,0.685567,0.70666665,0.685567,0.71,0.685567,0.75333333,0.685567,0.75666666,0.685567,0.76,0.685567,0.7633333,0.685567,0.76666665,0.685567,0.77,0.685567,0.7733333,0.685567,0.77666664,0.685567,0.78,0.685567,0.78333336,0.685567,0.8066667,0.685567,0.81,0.685567,0.81333333,0.685567,0.81666666,0.685567,0.82,0.685567,0.8233333,0.685567,0.82666665,0.685567,0.83,0.685567,0.8333333,0.685567,0.83666664,0.685567,0.84,0.685567,0.8433333,0.685567,0.8466667,0.685567,0.06333333,0.6881443,0.06666667,0.6881443,0.07,0.6881443,0.07333333,0.6881443,0.07666667,0.6881443,0.08,0.6881443,0.083333336,0.6881443,0.086666666,0.6881443,0.09,0.6881443,0.093333334,0.6881443,0.096666664,0.6881443,0.1,0.6881443,0.10333333,0.6881443,0.10666667,0.6881443,0.11,0.6881443,0.11333334,0.6881443,0.11666667,0.6881443,0.12,0.6881443,0.123333335,0.6881443,0.14666666,0.6881443,0.15,0.6881443,0.15333334,0.6881443,0.15666667,0.6881443,0.16,0.6881443,0.16333333,0.6881443,0.16666667,0.6881443,0.17,0.6881443,0.17333333,0.6881443,0.17666666,0.6881443,0.18,0.6881443,0.18333334,0.6881443,0.18666667,0.6881443,0.2,0.6881443,0.20333333,0.6881443,0.20666666,0.6881443,0.21,0.6881443,0.21333334,0.6881443,0.21666667,0.6881443,0.22,0.6881443,0.22333333,0.6881443,0.22666667,0.6881443,0.23,0.6881443,0.25666666,0.6881443,0.26,0.6881443,0.26333332,0.6881443,0.26666668,0.6881443,0.27,0.6881443,0.27333334,0.6881443,0.27666667,0.6881443,0.28,0.6881443,0.28333333,0.6881443,0.28666666,0.6881443,0.29,0.6881443,0.44666666,0.6881443,0.45,0.6881443,0.45333335,0.6881443,0.45666668,0.6881443,0.46,0.6881443,0.46333334,0.6881443,0.46666667,0.6881443,0.47,0.6881443,0.47333333,0.6881443,0.47666666,0.6881443,0.48,0.6881443,0.5133333,0.6881443,0.51666665,0.6881443,0.52,0.6881443,0.5233333,0.6881443,0.52666664,0.6881443,0.53,0.6881443,0.53333336,0.6881443,0.5366667,0.6881443,0.54,0.6881443,0.54333335,0.6881443,0.5466667,0.6881443,0.55,0.6881443,0.55333334,0.6881443,0.5566667,0.6881443,0.56,0.6881443,0.56333333,0.6881443,0.56666666,0.6881443,0.57,0.6881443,0.5733333,0.6881443,0.57666665,0.6881443,0.58,0.6881443,0.67333335,0.6881443,0.6766667,0.6881443,0.68,0.6881443,0.68333334,0.6881443,0.68666667,0.6881443,0.69,0.6881443,0.6933333,0.6881443,0.69666666,0.6881443,0.7,0.6881443,0.7033333,0.6881443,0.75333333,0.6881443,0.75666666,0.6881443,0.76,0.6881443,0.7633333,0.6881443,0.76666665,0.6881443,0.77,0.6881443,0.7733333,0.6881443,0.77666664,0.6881443,0.78,0.6881443,0.81,0.6881443,0.81333333,0.6881443,0.81666666,0.6881443,0.82,0.6881443,0.8233333,0.6881443,0.82666665,0.6881443,0.83,0.6881443,0.8333333,0.6881443,0.83666664,0.6881443,0.84,0.6881443,0.8433333,0.6881443,0.06333333,0.69072163,0.06666667,0.69072163,0.07,0.69072163,0.07333333,0.69072163,0.07666667,0.69072163,0.08,0.69072163,0.083333336,0.69072163,0.086666666,0.69072163,0.09,0.69072163,0.093333334,0.69072163,0.096666664,0.69072163,0.1,0.69072163,0.10333333,0.69072163,0.10666667,0.69072163,0.11,0.69072163,0.11333334,0.69072163,0.11666667,0.69072163,0.12,0.69072163,0.15,0.69072163,0.15333334,0.69072163,0.15666667,0.69072163,0.16,0.69072163,0.16333333,0.69072163,0.16666667,0.69072163,0.17,0.69072163,0.17333333,0.69072163,0.17666666,0.69072163,0.18,0.69072163,0.20333333,0.69072163,0.20666666,0.69072163,0.21,0.69072163,0.21333334,0.69072163,0.21666667,0.69072163,0.22,0.69072163,0.22333333,0.69072163,0.22666667,0.69072163,0.23,0.69072163,0.26,0.69072163,0.26333332,0.69072163,0.26666668,0.69072163,0.27,0.69072163,0.27333334,0.69072163,0.27666667,0.69072163,0.28,0.69072163,0.28333333,0.69072163,0.28666666,0.69072163,0.29,0.69072163,0.44666666,0.69072163,0.45,0.69072163,0.45333335,0.69072163,0.45666668,0.69072163,0.46,0.69072163,0.46333334,0.69072163,0.46666667,0.69072163,0.47,0.69072163,0.47333333,0.69072163,0.51666665,0.69072163,0.52,0.69072163,0.5233333,0.69072163,0.52666664,0.69072163,0.53,0.69072163,0.53333336,0.69072163,0.5366667,0.69072163,0.54,0.69072163,0.54333335,0.69072163,0.5466667,0.69072163,0.55,0.69072163,0.55333334,0.69072163,0.5566667,0.69072163,0.56,0.69072163,0.56333333,0.69072163,0.56666666,0.69072163,0.57,0.69072163,0.5733333,0.69072163,0.57666665,0.69072163,0.58,0.69072163,0.75,0.69072163,0.75333333,0.69072163,0.75666666,0.69072163,0.76,0.69072163,0.7633333,0.69072163,0.76666665,0.69072163,0.77,0.69072163,0.7733333,0.69072163,0.77666664,0.69072163,0.78,0.69072163,0.81666666,0.69072163,0.82,0.69072163,0.8233333,0.69072163,0.82666665,0.69072163,0.83,0.69072163,0.8333333,0.69072163,0.83666664,0.69072163,0.84,0.69072163,0.06333333,0.693299,0.06666667,0.693299,0.07,0.693299,0.07333333,0.693299,0.07666667,0.693299,0.08,0.693299,0.083333336,0.693299,0.086666666,0.693299,0.09,0.693299,0.093333334,0.693299,0.096666664,0.693299,0.1,0.693299,0.10333333,0.693299,0.10666667,0.693299,0.11,0.693299,0.11333334,0.693299,0.11666667,0.693299,0.12,0.693299,0.15,0.693299,0.15333334,0.693299,0.15666667,0.693299,0.16,0.693299,0.16333333,0.693299,0.16666667,0.693299,0.17,0.693299,0.17333333,0.693299,0.17666666,0.693299,0.20666666,0.693299,0.21,0.693299,0.21333334,0.693299,0.21666667,0.693299,0.22,0.693299,0.22333333,0.693299,0.22666667,0.693299,0.23,0.693299,0.26,0.693299,0.26333332,0.693299,0.26666668,0.693299,0.27,0.693299,0.27333334,0.693299,0.27666667,0.693299,0.28,0.693299,0.28333333,0.693299,0.28666666,0.693299,0.29,0.693299,0.45,0.693299,0.45333335,0.693299,0.45666668,0.693299,0.46,0.693299,0.46333334,0.693299,0.46666667,0.693299,0.47,0.693299,0.51666665,0.693299,0.52,0.693299,0.5233333,0.693299,0.52666664,0.693299,0.53,0.693299,0.53333336,0.693299,0.5366667,0.693299,0.54,0.693299,0.54333335,0.693299,0.5466667,0.693299,0.55,0.693299,0.55333334,0.693299,0.5566667,0.693299,0.56,0.693299,0.56333333,0.693299,0.56666666,0.693299,0.57,0.693299,0.5733333,0.693299,0.57666665,0.693299,0.75,0.693299,0.75333333,0.693299,0.75666666,0.693299,0.76,0.693299,0.7633333,0.693299,0.76666665,0.693299,0.77,0.693299,0.7733333,0.693299,0.77666664,0.693299,0.06666667,0.6958763,0.07,0.6958763,0.07333333,0.6958763,0.07666667,0.6958763,0.08,0.6958763,0.083333336,0.6958763,0.086666666,0.6958763,0.09,0.6958763,0.093333334,0.6958763,0.096666664,0.6958763,0.1,0.6958763,0.10333333,0.6958763,0.10666667,0.6958763,0.11,0.6958763,0.11333334,0.6958763,0.11666667,0.6958763,0.15333334,0.6958763,0.15666667,0.6958763,0.16,0.6958763,0.16333333,0.6958763,0.16666667,0.6958763,0.17,0.6958763,0.17333333,0.6958763,0.21,0.6958763,0.21333334,0.6958763,0.21666667,0.6958763,0.22,0.6958763,0.22333333,0.6958763,0.22666667,0.6958763,0.23,0.6958763,0.26333332,0.6958763,0.26666668,0.6958763,0.27,0.6958763,0.27333334,0.6958763,0.27666667,0.6958763,0.28,0.6958763,0.28333333,0.6958763,0.28666666,0.6958763,0.45333335,0.6958763,0.45666668,0.6958763,0.46,0.6958763,0.46333334,0.6958763,0.46666667,0.6958763,0.52,0.6958763,0.5233333,0.6958763,0.52666664,0.6958763,0.53,0.6958763,0.53333336,0.6958763,0.5366667,0.6958763,0.54,0.6958763,0.54333335,0.6958763,0.5466667,0.6958763,0.55,0.6958763,0.56666666,0.6958763,0.57,0.6958763,0.75,0.6958763,0.75333333,0.6958763,0.75666666,0.6958763,0.76,0.6958763,0.7633333,0.6958763,0.76666665,0.6958763,0.77,0.6958763,0.7733333,0.6958763,0.77666664,0.6958763,0.06666667,0.6984536,0.07,0.6984536,0.07333333,0.6984536,0.07666667,0.6984536,0.08,0.6984536,0.083333336,0.6984536,0.086666666,0.6984536,0.09,0.6984536,0.093333334,0.6984536,0.096666664,0.6984536,0.1,0.6984536,0.10333333,0.6984536,0.10666667,0.6984536,0.11,0.6984536,0.11333334,0.6984536,0.15666667,0.6984536,0.16,0.6984536,0.16333333,0.6984536,0.16666667,0.6984536,0.21,0.6984536,0.21333334,0.6984536,0.21666667,0.6984536,0.22,0.6984536,0.22333333,0.6984536,0.22666667,0.6984536,0.23,0.6984536,0.26666668,0.6984536,0.27,0.6984536,0.27333334,0.6984536,0.27666667,0.6984536,0.28,0.6984536,0.28333333,0.6984536,0.28666666,0.6984536,0.52,0.6984536,0.5233333,0.6984536,0.52666664,0.6984536,0.53,0.6984536,0.53333336,0.6984536,0.5366667,0.6984536,0.54,0.6984536,0.54333335,0.6984536,0.75333333,0.6984536,0.75666666,0.6984536,0.76,0.6984536,0.7633333,0.6984536,0.76666665,0.6984536,0.77,0.6984536,0.7733333,0.6984536,0.77666664,0.6984536,0.07,0.7010309,0.07333333,0.7010309,0.07666667,0.7010309,0.08,0.7010309,0.083333336,0.7010309,0.086666666,0.7010309,0.09,0.7010309,0.093333334,0.7010309,0.096666664,0.7010309,0.1,0.7010309,0.10333333,0.7010309,0.10666667,0.7010309,0.11,0.7010309,0.21333334,0.7010309,0.21666667,0.7010309,0.22,0.7010309,0.22333333,0.7010309,0.22666667,0.7010309,0.5233333,0.7010309,0.52666664,0.7010309,0.53,0.7010309,0.53333336,0.7010309,0.5366667,0.7010309,0.75666666,0.7010309,0.76,0.7010309,0.7633333,0.7010309,0.76666665,0.7010309,0.77,0.7010309,0.7733333,0.7010309,0.07333333,0.7036083,0.07666667,0.7036083,0.08,0.7036083,0.083333336,0.7036083,0.086666666,0.7036083,0.09,0.7036083,0.093333334,0.7036083,0.096666664,0.7036083,0.1,0.7036083,0.10333333,0.7036083,0.10666667,0.7036083,0.21666667,0.7036083,0.22,0.7036083,0.75666666,0.7036083,0.76,0.7036083,0.7633333,0.7036083,0.76666665,0.7036083,0.77,0.7036083,0.07666667,0.7061856,0.08,0.7061856,0.083333336,0.7061856,0.086666666,0.7061856,0.09,0.7061856,0.093333334,0.7061856,0.096666664,0.7061856,0.1,0.7061856,0.10333333,0.7061856,0.7633333,0.7061856,0.76666665,0.7061856,0.083333336,0.7087629,0.086666666,0.7087629,0.09,0.7087629,0.093333334,0.7087629],"colors":[[212,191,159],[184,156,109],[187,157,108],[205,175,134],[228,198,160],[206,174,121],[188,154,91],[184,152,87],[187,155,90],[202,189,164],[231,218,197],[200,173,132],[189,158,111],[191,160,113],[191,160,112],[190,160,109],[189,156,105],[185,153,101],[185,151,97],[185,151,91],[184,151,89],[198,172,119],[229,213,190],[201,176,139],[191,161,116],[187,157,108],[184,152,100],[180,149,97],[180,149,96],[182,150,95],[185,152,96],[204,176,128],[231,219,197],[234,220,206],[216,197,172],[196,173,141],[183,160,126],[177,154,118],[180,157,121],[194,172,136],[221,201,167],[235,222,212],[228,212,188],[220,204,179],[214,200,176],[214,202,182],[222,212,196],[160,190,159],[119,164,117],[108,154,106],[108,152,106],[110,153,109],[118,160,117],[168,194,167],[230,217,204],[227,198,147],[214,175,113],[209,164,84],[207,161,77],[205,161,78],[204,161,80],[203,161,84],[202,165,103],[211,180,141],[228,210,189],[131,175,131],[105,158,103],[104,157,102],[104,156,100],[104,157,103],[106,158,104],[105,157,104],[109,156,107],[228,211,189],[221,177,103],[220,165,68],[222,163,60],[222,163,60],[222,163,61],[223,164,61],[224,164,61],[222,162,60],[220,162,60],[219,161,60],[218,167,76],[220,190,139],[212,164,158],[201,125,119],[190,111,105],[184,108,101],[180,108,101],[180,111,104],[188,124,118],[204,158,154],[143,160,141],[136,157,135],[137,158,137],[148,164,148],[146,187,146],[104,159,103],[104,159,102],[103,158,101],[102,157,101],[102,157,100],[104,159,104],[103,156,102],[101,153,99],[160,186,160],[213,176,118],[223,164,61],[224,163,61],[224,164,61],[225,164,60],[225,165,61],[226,165,61],[225,165,60],[224,164,60],[224,163,60],[223,163,60],[222,164,61],[217,164,64],[208,181,128],[215,182,178],[199,119,113],[198,103,95],[198,102,94],[197,101,93],[198,101,94],[198,103,94],[197,102,93],[195,100,93],[193,105,97],[184,136,129],[142,163,140],[124,151,122],[114,149,113],[112,148,109],[109,147,108],[111,149,109],[141,167,140],[108,162,107],[104,159,104],[104,159,103],[103,158,101],[102,157,100],[103,158,101],[103,158,101],[101,156,99],[103,154,100],[147,181,145],[233,220,200],[210,163,79],[224,165,61],[224,164,59],[224,164,59],[225,165,60],[225,165,60],[226,165,60],[226,166,60],[225,165,60],[224,164,59],[223,163,59],[222,164,60],[221,165,61],[207,163,76],[221,206,178],[219,176,171],[197,109,103],[200,103,95],[200,104,95],[198,101,93],[197,100,92],[197,100,92],[198,101,93],[198,101,93],[196,99,91],[197,100,92],[188,102,93],[185,161,152],[158,185,158],[116,154,114],[107,150,103],[105,150,102],[104,151,100],[104,150,101],[138,166,136],[184,219,185],[103,158,103],[103,157,103],[103,158,102],[101,157,100],[102,158,101],[103,158,101],[104,158,101],[103,158,101],[102,155,100],[182,203,181],[221,209,198],[216,187,130],[207,173,100],[199,163,94],[196,161,95],[198,166,105],[220,197,148],[233,221,201],[208,160,73],[224,164,61],[224,164,59],[224,164,59],[225,165,60],[226,165,60],[226,164,60],[226,165,60],[225,165,60],[224,164,59],[224,164,59],[224,164,59],[223,166,62],[210,164,74],[215,199,169],[224,191,186],[199,111,104],[197,100,92],[198,102,93],[199,102,94],[198,101,93],[197,100,92],[196,100,91],[197,100,92],[198,101,93],[195,98,90],[197,100,92],[195,100,91],[187,146,138],[163,196,161],[105,152,101],[100,149,97],[101,151,97],[103,153,99],[103,151,100],[153,179,151],[147,188,147],[103,158,103],[102,156,100],[102,158,101],[101,158,100],[101,158,100],[102,158,101],[101,156,99],[101,156,99],[113,161,111],[212,184,149],[213,163,67],[221,166,61],[221,166,61],[221,166,61],[219,165,61],[215,166,69],[222,195,148],[210,164,83],[224,163,61],[225,164,59],[225,164,59],[227,165,60],[228,165,60],[227,164,60],[226,164,60],[227,165,60],[226,164,60],[226,164,60],[225,165,61],[225,165,62],[212,166,77],[216,202,182],[201,128,122],[199,103,95],[198,101,93],[197,100,92],[197,100,92],[198,101,93],[197,100,92],[197,100,92],[195,99,90],[194,98,89],[194,98,89],[196,100,92],[189,101,92],[206,175,168],[123,168,121],[98,150,93],[99,153,95],[101,154,97],[101,154,97],[107,154,103],[174,200,173],[117,166,117],[101,157,101],[102,158,101],[102,159,101],[100,158,100],[101,158,100],[100,158,100],[99,156,99],[100,156,98],[150,190,150],[219,165,67],[224,165,58],[226,166,60],[227,167,60],[226,166,59],[224,165,59],[220,168,75],[230,212,182],[223,182,124],[224,163,59],[226,165,60],[225,165,60],[226,164,60],[227,164,60],[227,164,60],[227,164,60],[227,164,60],[228,165,61],[226,165,60],[226,166,61],[226,166,62],[216,170,78],[230,216,189],[190,171,168],[171,142,140],[162,131,128],[163,132,129],[172,143,140],[195,172,169],[215,166,161],[197,105,97],[199,103,94],[197,100,92],[197,100,92],[197,100,92],[197,100,92],[196,99,91],[196,99,91],[195,99,90],[194,98,89],[194,97,89],[195,98,90],[176,116,105],[166,206,163],[96,150,90],[100,155,95],[100,155,96],[100,155,96],[101,156,96],[111,158,107],[102,155,102],[100,155,100],[101,158,102],[102,159,101],[100,158,100],[100,158,100],[101,158,100],[100,157,99],[102,156,101],[193,226,194],[154,174,156],[177,173,142],[224,173,98],[223,163,56],[226,165,59],[229,167,60],[228,167,60],[226,167,59],[224,165,60],[214,179,123],[234,205,170],[222,162,58],[225,164,59],[227,164,60],[227,164,60],[228,165,61],[228,165,61],[227,164,60],[227,164,60],[227,164,60],[227,165,60],[227,166,61],[227,167,62],[217,172,92],[225,202,173],[216,192,158],[212,190,157],[211,190,159],[217,197,169],[229,212,191],[174,149,146],[166,120,118],[175,107,107],[178,103,102],[180,101,98],[180,101,99],[178,106,102],[182,131,126],[203,181,176],[229,204,199],[200,115,108],[200,103,95],[199,103,94],[199,101,93],[198,101,93],[197,101,92],[196,99,91],[195,98,90],[196,99,91],[196,99,91],[194,98,89],[194,97,88],[190,97,88],[212,168,162],[201,233,200],[96,151,90],[99,154,93],[100,155,94],[98,154,94],[100,155,94],[101,156,97],[118,159,114],[168,198,170],[101,154,99],[100,154,100],[101,157,102],[103,159,103],[101,158,100],[100,157,100],[100,157,101],[102,156,100],[105,156,104],[146,183,146],[102,153,103],[102,151,101],[103,151,103],[124,157,124],[176,171,140],[226,182,119],[224,162,56],[227,165,58],[230,167,60],[229,168,60],[228,166,59],[227,166,59],[220,167,76],[227,208,180],[223,165,68],[226,164,60],[228,165,61],[228,165,61],[228,165,61],[228,165,61],[227,164,60],[227,164,60],[228,165,61],[228,165,61],[228,166,61],[227,166,62],[226,181,105],[230,207,181],[221,182,116],[220,173,89],[216,169,84],[215,168,82],[214,167,82],[212,165,83],[211,165,85],[210,166,91],[213,172,107],[220,188,138],[230,210,181],[217,200,196],[189,145,142],[178,108,107],[184,103,100],[187,101,95],[189,100,96],[189,99,92],[187,100,93],[184,112,106],[197,161,155],[205,141,135],[197,102,95],[199,103,94],[199,102,94],[198,101,93],[197,100,92],[197,100,92],[198,101,93],[195,99,90],[195,99,90],[195,98,90],[195,98,89],[195,98,89],[181,112,102],[205,233,204],[96,150,90],[98,154,92],[98,153,91],[97,153,91],[100,155,94],[100,155,95],[100,155,95],[121,161,120],[186,207,187],[112,160,113],[102,154,100],[100,154,99],[102,157,102],[103,159,104],[100,157,101],[100,156,100],[99,156,100],[101,155,101],[106,158,106],[145,187,144],[101,154,101],[100,154,99],[100,154,99],[101,154,100],[119,157,119],[169,195,169],[153,181,152],[142,171,141],[136,164,135],[138,165,136],[144,169,142],[167,186,166],[177,173,139],[228,185,122],[225,162,56],[228,166,59],[229,167,60],[229,167,59],[228,166,59],[228,166,58],[225,165,60],[217,181,108],[232,181,93],[225,164,60],[228,165,61],[228,165,61],[228,165,61],[228,165,61],[227,164,60],[227,164,60],[228,165,61],[227,164,60],[228,165,61],[226,166,63],[226,188,123],[226,196,152],[223,174,86],[224,170,73],[227,171,70],[226,170,69],[226,170,69],[226,170,69],[225,168,67],[225,169,68],[223,167,66],[221,166,66],[219,166,69],[215,168,86],[216,182,126],[227,212,185],[230,206,202],[194,129,126],[186,102,97],[190,100,94],[191,100,94],[190,98,92],[193,101,94],[192,102,95],[189,109,102],[193,148,142],[214,166,159],[196,106,99],[198,103,95],[198,102,94],[198,101,93],[197,100,92],[197,100,92],[197,100,92],[197,100,92],[197,100,92],[196,99,91],[196,99,91],[195,99,90],[194,98,89],[206,150,142],[221,183,179],[207,165,159],[195,152,148],[187,147,141],[186,148,140],[191,158,151],[202,174,169],[216,197,193],[177,213,176],[95,150,89],[98,153,91],[98,154,92],[98,154,93],[98,154,93],[101,155,96],[102,156,98],[101,156,98],[117,158,117],[166,193,166],[201,223,202],[173,194,174],[121,165,122],[104,153,104],[103,154,102],[100,154,100],[101,156,101],[102,157,103],[99,155,99],[99,155,100],[100,157,102],[103,157,103],[103,158,103],[145,192,145],[161,208,162],[129,180,130],[102,156,101],[100,154,99],[102,156,102],[101,155,100],[101,154,100],[122,161,122],[171,198,172],[140,174,138],[118,156,115],[107,150,104],[105,150,102],[106,151,103],[107,152,104],[107,152,104],[107,151,104],[108,150,104],[126,157,124],[180,176,147],[227,175,90],[227,164,58],[229,167,60],[229,167,60],[229,167,59],[228,167,59],[228,166,58],[228,166,59],[220,166,71],[225,198,163],[224,163,59],[227,165,61],[228,166,62],[228,165,61],[228,165,61],[229,166,62],[229,166,61],[228,165,61],[227,164,60],[227,165,60],[224,165,61],[221,190,143],[226,191,132],[226,173,79],[227,170,69],[228,171,70],[229,172,70],[228,171,69],[227,170,69],[227,170,69],[225,168,66],[226,169,67],[223,167,65],[223,167,65],[222,166,65],[220,166,64],[218,166,66],[211,172,94],[221,211,193],[223,175,172],[189,102,97],[192,100,94],[191,99,92],[191,99,91],[193,101,93],[195,103,96],[195,104,96],[191,106,98],[191,135,128],[214,195,187],[213,176,169],[191,107,100],[196,102,95],[197,103,95],[199,102,94],[198,101,93],[197,100,92],[197,100,92],[197,100,92],[197,100,92],[197,100,92],[195,98,90],[194,98,89],[196,99,91],[194,98,91],[232,193,187],[220,193,187],[208,146,140],[193,121,114],[195,109,102],[196,103,96],[193,100,92],[192,100,92],[192,100,92],[193,102,94],[192,103,96],[188,114,107],[188,151,145],[122,171,119],[96,151,91],[99,154,94],[100,156,94],[100,156,95],[99,155,95],[100,154,95],[102,155,98],[102,155,98],[103,154,99],[108,153,105],[123,163,122],[127,166,126],[130,167,130],[121,161,120],[108,152,107],[105,152,104],[105,153,104],[105,155,104],[103,156,103],[103,158,103],[102,156,102],[99,155,100],[100,157,101],[100,157,101],[102,158,103],[102,157,103],[101,157,101],[101,157,101],[99,156,99],[101,157,101],[101,157,101],[101,156,100],[99,155,99],[101,155,100],[124,163,123],[169,197,169],[127,168,124],[110,155,107],[105,153,103],[104,153,101],[102,151,100],[105,153,103],[106,153,103],[107,153,103],[106,153,102],[107,154,104],[105,151,103],[108,151,106],[131,159,128],[234,209,179],[220,162,66],[227,165,58],[229,167,60],[229,167,60],[229,166,59],[229,167,59],[228,166,59],[228,166,59],[226,165,60],[218,169,89],[225,211,197],[223,162,58],[225,165,60],[227,166,61],[228,165,61],[228,165,61],[228,165,61],[229,165,62],[228,165,61],[227,164,60],[225,164,60],[223,163,58],[221,187,133],[235,219,205],[223,185,120],[226,173,73],[227,171,68],[229,171,69],[228,172,68],[229,171,68],[229,171,68],[228,169,68],[226,169,66],[226,168,66],[225,167,66],[223,167,65],[223,167,65],[222,166,64],[220,164,63],[219,165,65],[215,167,68],[206,180,129],[232,206,202],[191,111,104],[192,100,92],[191,99,91],[193,101,93],[194,102,94],[195,103,95],[196,105,97],[196,105,97],[192,105,97],[185,123,114],[205,165,155],[223,193,184],[223,194,185],[206,154,145],[188,107,99],[192,100,93],[195,101,94],[196,102,94],[195,99,93],[196,100,92],[197,100,93],[197,100,92],[196,99,91],[196,99,91],[196,99,91],[196,99,91],[195,98,90],[196,99,91],[198,108,101],[206,142,135],[194,110,102],[197,102,93],[199,103,94],[200,103,95],[200,103,95],[199,103,94],[197,101,93],[198,102,94],[198,103,94],[196,102,93],[194,101,93],[189,101,93],[180,129,120],[181,207,179],[99,153,96],[97,153,93],[99,154,94],[100,156,95],[101,156,96],[100,155,95],[100,153,96],[102,156,99],[101,153,96],[101,153,98],[102,152,99],[102,151,100],[104,151,102],[104,150,103],[103,150,102],[105,151,103],[107,153,106],[107,155,106],[110,159,108],[104,156,103],[103,157,103],[103,157,103],[101,155,101],[101,157,102],[101,157,102],[101,157,101],[101,157,102],[101,158,101],[101,158,101],[99,156,98],[100,157,99],[101,158,101],[100,157,100],[99,156,98],[101,157,100],[115,158,114],[183,206,183],[134,174,134],[105,154,103],[102,154,100],[103,154,101],[106,156,103],[105,155,102],[104,153,100],[106,155,103],[105,154,103],[106,154,104],[106,153,103],[107,153,103],[107,152,105],[109,153,106],[116,150,113],[233,217,204],[221,172,95],[223,161,56],[228,165,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[227,165,58],[223,165,63],[211,172,108],[226,211,198],[222,163,59],[225,165,60],[227,166,61],[227,165,61],[228,165,61],[228,165,61],[228,164,61],[226,164,60],[225,163,59],[223,163,58],[223,163,58],[217,176,108],[233,213,187],[219,180,122],[223,168,71],[227,171,68],[227,171,67],[228,171,67],[227,171,67],[227,170,67],[228,170,67],[227,170,67],[226,168,65],[226,168,65],[226,168,65],[224,168,65],[223,166,64],[221,165,63],[221,165,63],[219,165,64],[217,167,66],[205,167,90],[232,209,204],[191,109,101],[192,100,93],[193,101,93],[193,101,93],[194,102,94],[194,103,94],[195,103,95],[196,105,97],[195,104,96],[193,104,96],[192,105,97],[191,106,98],[190,106,98],[188,102,94],[193,102,94],[194,102,94],[194,101,94],[195,101,95],[195,100,94],[195,101,93],[196,101,93],[197,101,93],[197,100,92],[196,99,91],[196,99,91],[195,99,90],[194,97,89],[194,98,89],[199,113,105],[233,206,198],[214,201,193],[203,145,137],[194,110,103],[197,100,93],[200,101,93],[200,102,94],[200,101,94],[198,101,93],[199,102,94],[198,101,93],[197,100,92],[198,102,93],[197,101,93],[196,100,92],[195,100,91],[193,98,91],[189,98,90],[182,128,121],[177,203,176],[110,157,107],[100,154,95],[98,154,94],[100,155,95],[100,156,95],[102,156,97],[101,156,96],[101,155,96],[103,156,98],[102,155,98],[102,154,99],[105,156,102],[104,153,102],[106,152,104],[106,152,104],[105,151,104],[106,152,104],[115,160,114],[149,192,149],[171,214,171],[131,181,131],[106,160,106],[103,158,103],[102,156,102],[102,157,102],[101,158,103],[102,158,102],[101,157,102],[102,159,101],[101,159,101],[101,158,100],[101,159,101],[100,157,99],[99,156,98],[101,159,101],[102,159,101],[106,156,105],[146,186,147],[187,219,187],[197,227,197],[193,222,194],[174,206,174],[139,179,138],[109,158,106],[101,155,99],[102,155,99],[101,155,100],[103,155,101],[104,155,102],[103,155,102],[103,154,100],[104,154,101],[105,154,102],[105,155,102],[104,153,102],[106,152,102],[106,153,103],[108,151,105],[115,151,111],[234,212,184],[214,171,109],[222,161,58],[226,163,57],[228,166,59],[228,166,59],[228,166,59],[229,167,60],[228,166,59],[228,166,59],[228,166,59],[226,165,58],[222,163,57],[218,163,64],[211,170,98],[211,194,175],[229,211,200],[216,172,103],[222,164,60],[224,164,61],[226,166,61],[225,165,61],[227,166,61],[227,166,61],[226,165,60],[224,164,59],[224,164,59],[223,163,59],[224,164,59],[211,165,85],[228,214,199],[228,203,172],[219,175,104],[224,168,68],[227,169,66],[227,170,66],[227,169,66],[227,170,66],[228,170,67],[228,170,67],[227,169,66],[227,169,66],[226,168,65],[226,168,64],[225,167,65],[225,167,65],[224,166,63],[221,164,63],[221,165,63],[220,164,64],[218,166,64],[208,165,77],[224,210,180],[224,193,186],[191,103,95],[194,102,94],[194,102,95],[194,102,94],[194,102,94],[195,103,95],[196,104,96],[197,105,97],[196,104,96],[196,104,96],[193,101,94],[193,101,94],[194,102,95],[193,101,94],[195,103,95],[195,103,95],[194,101,94],[196,102,95],[195,101,94],[196,102,95],[196,102,94],[197,102,93],[196,100,91],[197,100,92],[197,100,92],[194,98,89],[194,97,89],[193,97,88],[192,101,92],[190,131,121],[212,181,172],[229,210,203],[205,184,176],[204,138,130],[196,103,95],[196,99,90],[200,101,93],[200,101,93],[200,102,93],[199,101,91],[199,101,92],[198,100,92],[198,101,93],[199,102,94],[198,101,93],[199,102,93],[198,101,93],[195,99,91],[194,99,90],[192,98,89],[194,99,91],[187,105,98],[187,171,164],[199,218,197],[105,154,102],[100,152,96],[100,155,95],[98,153,94],[99,155,95],[101,156,96],[102,157,97],[102,156,98],[104,157,98],[104,157,98],[103,155,98],[105,156,101],[105,155,102],[106,154,103],[106,153,103],[107,152,105],[110,154,107],[132,170,131],[173,205,173],[203,228,205],[209,234,210],[198,230,199],[156,198,156],[112,165,111],[103,158,103],[104,159,104],[101,159,101],[102,159,101],[102,159,101],[102,159,101],[101,159,101],[102,159,102],[102,159,101],[102,159,101],[100,157,99],[101,159,101],[102,159,101],[101,158,100],[100,157,99],[106,159,103],[109,160,106],[107,160,105],[102,157,100],[99,155,98],[101,156,99],[101,157,99],[101,157,99],[101,156,99],[102,155,99],[103,156,100],[103,155,100],[102,154,100],[102,154,100],[104,153,100],[104,153,100],[104,153,101],[105,152,102],[105,152,102],[108,153,106],[121,155,118],[219,173,101],[223,162,56],[226,163,57],[227,165,58],[228,166,59],[228,166,59],[229,167,60],[228,166,59],[228,166,59],[228,167,60],[227,166,59],[225,165,58],[222,163,58],[220,164,59],[215,161,63],[205,160,78],[207,171,99],[216,185,124],[221,191,135],[217,187,131],[200,168,109],[206,161,78],[220,164,62],[222,165,62],[222,164,61],[224,164,62],[225,165,61],[225,165,61],[226,166,61],[224,164,59],[223,163,59],[223,164,60],[223,164,61],[220,164,63],[204,175,122],[235,222,210],[224,192,146],[216,168,88],[224,167,67],[226,168,64],[227,169,66],[227,169,66],[227,168,65],[227,169,66],[227,169,66],[228,170,67],[227,169,66],[227,169,66],[227,169,66],[226,168,66],[226,168,65],[224,166,64],[224,165,63],[222,165,63],[221,164,63],[221,165,64],[218,165,64],[210,165,77],[221,204,174],[203,158,151],[192,101,93],[194,102,94],[193,101,94],[194,102,94],[195,103,95],[196,104,96],[197,105,97],[197,105,97],[196,104,96],[195,103,95],[196,104,96],[196,104,96],[195,103,96],[196,104,96],[195,103,95],[195,103,95],[195,102,95],[197,103,96],[198,104,95],[197,103,95],[199,103,95],[198,102,94],[198,101,93],[198,101,93],[198,101,93],[195,98,90],[195,98,90],[196,98,90],[197,99,92],[195,99,90],[192,106,97],[197,118,109],[200,123,113],[199,122,113],[197,111,103],[195,100,92],[196,100,91],[198,99,91],[199,100,91],[201,102,92],[202,103,94],[200,101,92],[197,99,91],[197,99,90],[197,99,91],[197,100,92],[200,102,94],[198,101,93],[199,102,94],[199,102,94],[197,100,92],[196,101,92],[194,100,92],[193,99,91],[194,104,97],[181,143,136],[199,223,196],[103,153,98],[102,155,96],[101,155,96],[99,155,95],[99,154,94],[100,155,95],[102,157,98],[101,156,96],[105,158,98],[104,157,99],[104,157,98],[104,155,99],[106,156,102],[106,155,104],[107,154,104],[118,159,115],[158,189,157],[198,220,200],[173,212,172],[122,172,121],[103,158,103],[101,158,102],[102,159,102],[102,158,102],[102,160,102],[103,160,102],[102,159,101],[102,159,101],[101,158,101],[100,157,99],[100,158,98],[101,158,99],[100,158,98],[99,157,96],[98,156,95],[98,155,95],[98,154,95],[98,156,95],[98,155,95],[100,158,98],[99,156,96],[100,157,98],[102,157,100],[101,156,98],[101,155,98],[101,155,98],[104,155,101],[102,154,100],[100,150,97],[104,153,100],[104,153,101],[106,153,103],[106,152,102],[110,154,107],[144,172,141],[234,204,162],[224,163,63],[227,164,58],[227,165,58],[227,165,58],[228,166,59],[229,167,60],[229,167,60],[229,167,60],[228,166,59],[228,166,59],[227,166,59],[226,165,58],[223,163,59],[219,163,59],[215,162,61],[210,161,63],[205,160,65],[202,160,69],[202,160,71],[203,162,74],[204,162,73],[208,163,69],[215,162,62],[218,162,61],[220,163,60],[220,163,60],[221,163,61],[222,163,61],[223,163,62],[221,163,60],[220,163,60],[220,163,60],[219,163,59],[217,163,62],[207,164,72],[189,167,125],[208,195,184],[221,202,181],[212,177,118],[216,164,72],[221,165,64],[223,167,64],[226,168,64],[225,167,63],[226,168,64],[226,168,64],[226,168,65],[227,169,66],[227,169,65],[227,169,66],[227,169,66],[227,169,66],[227,169,65],[226,168,65],[225,167,63],[223,165,63],[222,165,63],[222,165,63],[221,165,63],[218,165,64],[215,174,93],[229,219,203],[227,208,203],[187,115,107],[195,103,95],[194,102,95],[194,102,95],[196,104,96],[195,103,95],[197,105,97],[197,105,97],[195,104,97],[195,104,96],[194,104,95],[194,104,96],[195,104,96],[194,104,96],[194,103,95],[193,102,95],[193,101,94],[194,101,95],[196,102,95],[196,104,95],[196,103,96],[197,103,95],[197,102,94],[197,101,93],[197,101,92],[197,100,92],[196,100,91],[197,100,92],[197,99,91],[197,98,91],[198,99,91],[198,99,91],[197,98,90],[197,99,89],[197,98,89],[197,99,90],[199,101,90],[198,100,90],[198,100,90],[202,101,92],[201,103,92],[200,101,91],[201,102,92],[199,101,91],[199,100,90],[200,101,92],[200,101,92],[201,102,93],[199,102,94],[199,102,94],[199,103,94],[199,102,94],[197,102,94],[197,103,94],[196,102,94],[187,107,99],[189,165,157],[198,226,195],[102,152,97],[101,154,95],[100,155,95],[100,155,95],[101,156,96],[100,155,95],[101,156,97],[102,156,97],[102,157,97],[104,157,99],[104,156,99],[105,156,100],[106,155,101],[109,158,106],[134,175,132],[184,207,182],[195,226,196],[139,189,138],[105,159,105],[102,157,101],[102,159,102],[101,158,101],[102,159,101],[102,159,101],[99,156,98],[101,159,101],[100,158,100],[100,158,99],[101,159,100],[99,158,97],[100,159,98],[99,158,97],[100,158,97],[99,157,97],[98,156,95],[100,158,97],[100,158,98],[100,158,98],[101,158,99],[102,157,100],[101,156,99],[101,155,98],[101,153,97],[103,155,99],[101,153,99],[100,150,97],[103,152,99],[104,152,100],[105,152,102],[106,153,103],[121,160,118],[224,215,199],[222,214,197],[232,214,201],[227,176,93],[226,163,57],[227,164,58],[227,165,58],[228,166,59],[228,166,59],[229,167,60],[229,167,60],[229,167,60],[228,166,59],[228,166,59],[228,166,59],[227,166,59],[223,164,59],[220,164,59],[215,162,61],[211,162,63],[207,162,65],[205,162,68],[202,161,69],[201,161,73],[201,162,77],[205,166,84],[211,172,95],[216,176,102],[217,177,104],[217,178,104],[218,177,103],[218,176,101],[222,178,100],[225,180,99],[225,178,94],[219,171,85],[212,165,78],[207,162,73],[202,162,75],[190,160,88],[183,157,100],[192,167,126],[208,186,156],[213,191,162],[208,185,148],[200,172,116],[201,163,89],[209,162,71],[218,164,64],[221,165,64],[222,166,63],[225,167,63],[225,168,64],[226,168,64],[226,168,64],[226,168,64],[227,169,65],[227,169,66],[227,169,66],[227,169,66],[227,169,65],[227,169,65],[227,169,65],[225,167,64],[224,165,64],[224,166,65],[222,165,63],[221,165,65],[224,173,81],[229,204,161],[216,191,184],[198,117,110],[195,103,95],[196,104,96],[195,103,95],[196,104,96],[195,103,95],[196,104,96],[195,104,96],[195,105,97],[194,106,97],[192,103,94],[190,104,95],[188,108,101],[190,113,105],[193,117,109],[199,124,117],[207,131,125],[214,136,130],[216,141,135],[217,145,138],[217,147,141],[218,149,143],[218,148,142],[215,140,132],[210,127,120],[205,114,106],[199,104,96],[197,100,92],[196,98,91],[195,97,89],[196,97,89],[196,97,90],[197,98,90],[199,101,91],[200,101,91],[198,100,90],[198,100,90],[200,100,91],[199,101,91],[200,102,92],[199,101,91],[201,100,91],[199,101,91],[199,100,90],[198,100,90],[199,101,91],[200,101,91],[200,103,92],[198,102,93],[200,103,95],[200,103,95],[200,104,95],[199,103,95],[199,104,96],[196,111,103],[199,152,143],[166,202,164],[100,152,94],[99,153,94],[102,154,96],[101,154,95],[101,155,96],[101,157,97],[102,156,98],[102,156,97],[105,158,99],[105,158,99],[105,157,100],[104,156,99],[118,166,113],[163,194,162],[164,203,165],[116,169,116],[102,158,102],[101,158,102],[100,158,100],[101,158,100],[99,156,98],[102,159,101],[100,157,99],[99,156,98],[101,159,100],[100,158,98],[100,158,98],[100,159,98],[101,158,98],[99,158,97],[100,157,97],[102,159,99],[101,158,98],[101,158,98],[101,158,98],[102,159,99],[103,157,100],[103,157,100],[102,155,98],[102,154,99],[105,154,101],[105,154,102],[113,159,110],[116,162,113],[120,165,117],[135,173,131],[186,209,184],[215,181,135],[203,165,93],[200,162,86],[200,162,90],[202,166,115],[208,173,134],[211,179,146],[217,187,161],[229,203,186],[234,213,202],[223,189,149],[221,170,91],[222,163,61],[225,164,58],[227,165,58],[228,166,59],[228,166,59],[228,166,59],[227,165,58],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[227,166,59],[224,164,58],[220,163,59],[216,163,60],[211,162,63],[206,161,65],[202,162,72],[205,169,90],[205,178,126],[212,192,160],[228,212,188],[233,217,183],[228,207,170],[211,189,147],[196,174,125],[185,163,110],[182,158,102],[186,159,97],[192,162,89],[200,162,78],[205,162,71],[212,163,66],[217,164,64],[220,164,64],[222,165,63],[224,166,64],[223,167,64],[225,167,64],[225,168,65],[225,168,64],[226,168,65],[226,168,65],[227,169,66],[228,170,66],[227,169,66],[226,168,65],[226,168,64],[225,167,63],[223,165,65],[220,165,67],[223,170,75],[227,186,106],[210,123,116],[196,104,96],[196,103,96],[195,103,94],[195,103,94],[194,102,95],[195,104,96],[194,105,96],[194,113,104],[200,134,124],[217,159,151],[224,185,177],[231,200,194],[232,207,200],[229,210,203],[235,211,205],[229,196,189],[219,151,144],[199,103,95],[196,98,90],[195,96,88],[196,97,89],[196,97,89],[198,99,90],[200,101,91],[200,101,91],[199,100,91],[199,100,90],[199,101,91],[200,100,90],[200,101,91],[199,101,91],[198,100,90],[201,101,92],[201,102,92],[198,100,90],[199,101,91],[199,100,90],[199,101,91],[201,104,93],[201,104,95],[201,104,96],[202,106,97],[202,115,105],[203,141,132],[223,186,178],[180,198,178],[164,186,162],[161,181,159],[162,182,160],[168,188,164],[177,197,176],[201,223,198],[119,166,115],[100,154,94],[100,154,94],[101,154,95],[99,154,94],[100,155,95],[101,156,96],[102,157,98],[102,157,98],[105,157,99],[104,157,99],[108,160,102],[136,178,132],[184,209,183],[182,219,183],[127,181,127],[103,158,103],[101,159,101],[99,156,98],[99,156,98],[100,157,99],[101,159,101],[99,158,100],[102,160,100],[100,159,98],[101,159,99],[100,159,98],[100,159,98],[99,159,97],[99,158,97],[100,159,98],[100,159,98],[101,158,98],[100,159,98],[102,159,99],[102,159,99],[102,157,98],[112,165,108],[137,185,134],[159,199,155],[175,211,174],[191,219,190],[205,226,204],[223,204,178],[219,163,66],[223,164,61],[222,163,60],[223,162,59],[223,162,60],[222,161,60],[221,161,61],[220,161,63],[219,161,64],[221,163,69],[223,166,74],[223,168,76],[220,165,76],[219,162,68],[225,163,58],[226,164,60],[227,164,60],[227,164,59],[227,164,60],[228,165,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[226,166,59],[224,165,58],[221,164,59],[218,163,60],[211,163,67],[211,172,89],[215,190,142],[224,210,189],[224,213,200],[212,194,167],[197,174,115],[194,164,85],[202,165,78],[206,165,72],[213,164,67],[217,164,64],[219,164,63],[221,165,63],[223,166,64],[223,166,65],[224,166,64],[224,168,65],[224,167,65],[226,168,66],[226,168,66],[226,169,65],[227,169,67],[226,169,66],[224,166,65],[220,166,68],[220,167,74],[223,174,91],[230,190,126],[203,110,101],[195,102,93],[195,102,93],[195,102,93],[197,103,95],[196,105,96],[203,131,122],[229,192,184],[232,218,209],[229,198,191],[198,112,104],[196,97,90],[195,96,89],[197,98,90],[197,99,90],[199,100,90],[200,100,91],[201,102,92],[201,101,92],[201,101,92],[202,101,92],[200,101,91],[202,103,93],[198,100,90],[200,101,91],[199,101,91],[200,102,92],[199,101,91],[201,102,92],[201,102,92],[201,102,92],[200,102,92],[203,108,98],[210,129,120],[213,160,150],[228,191,182],[157,181,152],[122,159,115],[111,152,104],[109,150,102],[108,149,101],[108,148,101],[108,148,101],[108,148,102],[113,151,108],[122,158,118],[138,169,132],[161,189,156],[186,212,182],[200,224,197],[207,229,205],[207,230,204],[204,229,203],[200,224,198],[174,200,171],[126,166,120],[104,155,97],[103,156,97],[101,154,95],[100,153,94],[100,153,94],[101,155,96],[102,156,96],[104,157,98],[102,156,97],[105,156,99],[122,169,115],[167,202,165],[200,224,201],[147,197,147],[108,165,108],[99,156,98],[100,157,99],[100,157,99],[102,159,101],[100,158,100],[101,159,99],[99,158,98],[99,159,98],[99,159,98],[99,159,97],[98,158,96],[98,158,97],[99,159,98],[101,158,98],[100,159,98],[100,160,98],[101,159,98],[100,158,98],[124,174,120],[181,219,178],[215,188,135],[221,164,64],[224,164,61],[224,164,59],[223,163,58],[224,164,59],[223,163,58],[224,164,59],[223,163,59],[223,163,58],[223,162,58],[223,161,57],[224,162,57],[226,164,59],[226,163,59],[227,163,60],[228,165,60],[227,164,60],[227,164,59],[228,165,60],[227,165,59],[229,167,60],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[227,167,59],[226,166,59],[223,166,61],[221,171,77],[226,192,130],[225,211,189],[214,193,161],[204,169,96],[206,164,72],[212,164,68],[217,165,65],[219,165,64],[220,165,63],[222,166,64],[223,167,65],[223,167,65],[224,167,65],[224,167,66],[224,168,66],[224,168,66],[225,168,67],[223,169,73],[224,173,87],[232,186,106],[205,121,112],[195,101,92],[196,102,93],[195,101,92],[196,102,93],[195,112,102],[231,198,188],[224,205,199],[204,120,112],[197,98,91],[196,97,90],[196,97,89],[198,99,90],[199,101,91],[200,101,91],[199,100,90],[198,100,90],[201,100,91],[202,101,92],[200,100,90],[202,101,92],[199,100,91],[199,98,89],[199,101,91],[199,101,91],[200,100,90],[200,101,91],[201,102,92],[204,106,96],[214,137,127],[220,182,173],[235,210,202],[147,173,141],[111,151,102],[109,151,101],[108,153,102],[108,153,101],[107,152,98],[106,151,98],[105,152,97],[104,151,97],[106,153,98],[104,151,97],[106,152,98],[108,154,101],[112,157,105],[115,160,109],[116,160,110],[114,159,108],[113,158,107],[114,158,107],[108,156,102],[104,155,98],[103,155,97],[101,154,95],[101,154,95],[100,153,94],[101,154,95],[101,154,95],[103,155,97],[104,156,98],[110,161,104],[149,187,145],[198,218,195],[168,207,169],[118,174,118],[100,158,100],[100,158,100],[100,158,100],[103,160,102],[102,159,99],[100,159,98],[100,159,98],[100,161,99],[99,159,98],[99,159,98],[100,160,99],[100,159,98],[99,159,98],[100,159,98],[100,160,97],[99,159,96],[107,160,102],[193,224,190],[214,188,118],[220,163,62],[223,163,60],[224,164,59],[224,164,59],[224,164,59],[223,162,58],[223,163,58],[222,161,56],[223,161,57],[225,162,58],[224,162,58],[225,162,58],[227,164,60],[227,164,60],[227,164,60],[228,165,60],[227,164,60],[227,165,59],[228,165,59],[228,166,59],[228,165,58],[228,166,59],[228,167,59],[229,167,60],[228,166,59],[228,166,59],[229,167,60],[228,166,59],[225,166,63],[228,180,95],[233,209,167],[232,219,198],[220,185,120],[212,163,71],[217,165,66],[219,165,64],[220,165,63],[222,165,63],[222,166,64],[223,167,65],[224,167,65],[224,168,66],[225,168,66],[222,167,65],[224,175,86],[234,197,136],[197,110,100],[196,102,93],[195,101,92],[195,101,92],[196,102,93],[197,125,114],[232,214,205],[228,203,198],[212,121,114],[197,98,91],[195,96,88],[196,97,88],[198,99,90],[199,100,90],[199,100,90],[199,100,90],[200,100,90],[199,99,89],[200,99,90],[201,100,91],[199,100,90],[201,100,91],[199,98,89],[199,99,90],[200,99,90],[199,100,91],[200,101,91],[207,120,109],[224,183,173],[180,198,174],[113,150,106],[110,152,102],[109,151,101],[107,152,100],[108,154,100],[105,152,97],[105,152,98],[104,151,96],[104,152,97],[106,153,99],[105,152,98],[108,156,100],[107,157,100],[107,158,100],[106,157,99],[105,156,98],[105,155,97],[104,155,97],[103,155,96],[106,158,99],[104,156,98],[103,156,97],[103,156,97],[102,154,96],[101,154,95],[101,154,95],[100,153,94],[103,155,97],[124,170,119],[173,205,169],[194,222,196],[136,185,134],[104,161,103],[103,160,102],[103,160,102],[101,159,100],[100,158,97],[101,158,98],[100,159,98],[100,160,98],[100,160,99],[99,159,98],[101,159,99],[100,160,99],[101,160,100],[101,161,99],[100,159,97],[124,172,120],[222,196,130],[219,163,62],[224,163,59],[223,163,58],[224,164,59],[223,163,58],[223,162,58],[222,161,57],[222,161,57],[222,160,56],[225,162,58],[226,163,59],[227,164,60],[227,164,60],[228,165,61],[228,165,61],[228,165,61],[227,165,60],[228,166,59],[227,165,59],[227,165,58],[228,166,59],[227,165,58],[228,166,60],[229,167,60],[228,166,59],[227,165,58],[228,166,59],[225,167,67],[228,187,118],[233,216,193],[231,200,139],[219,170,75],[217,163,62],[219,165,63],[221,165,63],[222,166,64],[222,166,64],[223,167,65],[224,167,66],[224,168,67],[227,178,94],[216,148,140],[192,99,90],[194,100,91],[194,100,91],[195,101,92],[195,101,92],[190,128,116],[225,211,203],[226,202,198],[207,123,115],[198,99,91],[196,97,89],[196,97,88],[199,100,91],[200,101,92],[203,102,93],[202,101,91],[201,100,91],[201,100,91],[200,99,91],[200,99,90],[201,100,92],[201,100,91],[201,100,91],[200,99,90],[201,100,91],[201,100,91],[206,120,108],[229,209,198],[144,172,137],[112,150,105],[109,151,101],[109,151,100],[107,152,100],[107,152,98],[106,152,98],[105,152,98],[105,152,97],[104,152,97],[105,153,98],[107,155,100],[107,155,99],[106,157,100],[107,158,100],[107,158,100],[106,157,99],[106,157,99],[105,156,98],[106,157,99],[107,158,100],[104,156,98],[104,156,97],[103,155,97],[103,156,97],[102,154,95],[101,153,94],[108,158,103],[143,186,138],[196,217,195],[158,202,157],[113,170,112],[100,158,100],[100,158,98],[100,157,98],[101,158,98],[99,157,96],[99,158,97],[100,160,99],[102,162,101],[101,161,100],[100,160,99],[100,160,99],[101,161,100],[100,159,99],[144,189,142],[235,211,161],[217,161,64],[223,163,58],[222,162,58],[222,162,57],[224,164,59],[223,163,59],[223,163,58],[223,162,58],[223,161,57],[226,163,59],[228,165,61],[227,164,60],[227,164,61],[228,165,61],[228,165,61],[228,166,61],[228,165,60],[228,165,59],[227,165,59],[227,165,58],[227,165,58],[227,165,58],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[227,168,65],[232,191,123],[233,222,207],[234,209,171],[222,171,79],[219,163,61],[221,165,62],[222,166,64],[222,166,64],[223,167,65],[223,167,65],[222,169,74],[222,196,189],[202,132,125],[191,100,93],[192,98,89],[193,99,90],[194,100,91],[195,101,92],[196,102,93],[189,122,113],[201,123,116],[199,100,93],[199,100,92],[198,99,91],[199,100,91],[201,101,92],[203,102,93],[202,101,92],[202,101,92],[201,100,91],[201,100,91],[201,100,91],[201,100,91],[200,99,90],[201,100,91],[201,100,91],[202,101,92],[201,104,93],[228,204,192],[134,164,128],[113,152,107],[109,151,102],[109,151,100],[107,152,100],[107,153,99],[108,154,100],[107,154,100],[107,154,100],[106,153,99],[106,154,98],[107,154,99],[107,155,99],[107,157,99],[106,157,99],[107,158,100],[107,158,100],[107,158,100],[107,158,100],[107,158,100],[107,158,100],[106,157,99],[104,155,97],[103,155,96],[103,155,97],[106,154,99],[125,171,118],[171,201,168],[180,214,181],[128,180,127],[102,159,101],[98,155,95],[98,156,95],[99,157,96],[100,158,98],[100,158,97],[101,159,98],[101,159,99],[100,159,98],[99,158,97],[99,159,97],[101,159,98],[153,193,150],[212,159,69],[222,163,58],[222,162,57],[223,162,58],[223,163,58],[224,163,59],[223,163,58],[224,163,59],[225,163,58],[227,164,60],[227,164,60],[227,164,60],[228,165,61],[227,164,60],[228,165,61],[229,166,61],[228,165,60],[228,166,60],[228,166,59],[227,165,60],[228,165,59],[228,166,59],[228,166,59],[228,166,59],[228,166,59],[226,167,65],[233,191,116],[227,175,78],[221,165,63],[223,166,64],[222,166,63],[223,166,64],[222,166,64],[224,171,78],[201,181,177],[187,141,136],[180,128,123],[176,125,119],[174,127,121],[175,131,125],[182,142,137],[194,160,154],[210,185,179],[225,210,203],[206,182,176],[198,136,129],[188,103,96],[187,96,89],[192,97,90],[192,97,89],[192,98,89],[193,99,90],[194,99,91],[196,102,93],[186,117,109],[208,124,117],[199,100,93],[201,102,94],[200,100,93],[199,101,93],[201,101,93],[201,101,92],[200,101,91],[200,100,91],[202,101,92],[202,101,92],[201,100,91],[200,99,90],[201,100,91],[202,101,91],[200,99,90],[201,100,90],[221,140,131],[151,180,144],[113,153,105],[110,152,103],[110,152,102],[107,152,100],[108,153,100],[109,155,101],[108,154,100],[107,155,100],[108,156,101],[107,154,99],[107,155,100],[108,155,99],[107,155,98],[106,156,98],[107,158,100],[107,158,100],[108,159,101],[108,158,100],[106,157,99],[106,156,99],[105,155,97],[104,154,96],[103,154,96],[117,162,111],[155,192,150],[201,222,198],[204,229,205],[147,192,145],[104,162,101],[100,158,97],[100,158,97],[99,157,96],[100,158,98],[101,159,99],[102,159,99],[101,159,98],[99,157,94],[99,157,95],[101,158,98],[122,169,120],[181,215,180],[189,219,188],[190,219,190],[196,221,194],[201,224,199],[216,170,89],[221,162,59],[222,162,60],[223,163,59],[224,164,60],[224,164,61],[225,165,60],[225,164,60],[225,165,60],[225,164,59],[224,164,59],[226,163,59],[227,164,60],[228,165,61],[228,165,61],[228,165,61],[228,165,61],[228,165,60],[227,165,60],[227,164,60],[227,165,59],[228,166,58],[228,166,59],[229,167,60],[227,166,61],[227,185,116],[223,171,78],[222,166,64],[223,167,63],[223,167,64],[223,167,64],[223,170,74],[203,165,164],[186,117,113],[190,114,107],[189,111,104],[188,110,104],[187,108,102],[186,109,101],[184,109,102],[182,112,104],[183,119,111],[186,133,125],[192,149,142],[200,162,156],[208,173,167],[213,181,175],[211,183,177],[206,181,173],[194,168,161],[185,150,142],[182,133,126],[186,114,106],[188,102,94],[189,97,90],[190,96,89],[190,96,89],[191,97,90],[193,98,90],[193,99,90],[194,100,92],[194,100,93],[196,102,95],[178,116,107],[225,205,202],[209,125,119],[197,99,92],[199,100,93],[199,100,93],[199,100,92],[199,101,93],[201,102,93],[203,102,93],[201,100,91],[201,101,92],[202,102,93],[200,99,90],[202,101,92],[200,99,90],[201,100,91],[200,99,90],[198,98,88],[233,172,162],[193,212,186],[137,172,129],[114,155,107],[109,152,101],[107,152,100],[107,152,98],[108,153,99],[108,154,100],[108,155,101],[109,155,101],[106,153,98],[106,154,99],[108,155,100],[109,157,100],[109,158,100],[108,159,101],[107,158,100],[108,158,100],[108,158,100],[107,158,100],[106,157,99],[104,155,97],[103,152,96],[136,177,130],[186,211,183],[168,207,168],[116,170,113],[99,157,96],[97,155,94],[99,156,96],[102,159,99],[101,159,99],[103,160,100],[101,159,99],[100,157,97],[102,158,98],[102,156,97],[107,160,103],[111,161,106],[113,161,108],[116,160,110],[120,161,114],[132,166,127],[164,187,163],[222,166,66],[221,163,60],[221,163,60],[222,162,61],[223,164,61],[224,164,62],[223,163,61],[223,162,60],[221,162,59],[220,162,60],[221,161,64],[223,164,66],[225,167,65],[225,165,63],[224,164,60],[226,165,60],[226,165,61],[225,165,60],[225,163,59],[227,164,59],[228,165,60],[228,166,61],[227,166,62],[228,179,95],[235,220,197],[220,166,68],[222,167,64],[222,166,64],[223,167,64],[222,167,68],[229,190,137],[184,122,119],[193,114,109],[193,112,108],[194,112,106],[194,110,104],[193,109,101],[193,108,101],[194,109,102],[193,108,100],[194,107,100],[192,105,98],[192,104,97],[191,106,97],[191,105,98],[191,105,97],[190,103,96],[188,101,93],[188,99,92],[188,98,90],[189,98,89],[192,99,90],[193,99,89],[193,98,91],[192,97,89],[191,96,88],[193,98,89],[193,99,90],[192,98,89],[195,101,92],[195,101,93],[197,104,96],[180,116,107],[217,169,164],[214,129,122],[205,107,100],[200,101,93],[199,101,93],[202,103,94],[204,104,94],[204,103,93],[202,102,92],[201,101,92],[199,100,91],[200,100,90],[201,101,91],[200,100,91],[200,99,90],[202,101,92],[198,99,90],[224,175,165],[204,224,197],[174,205,167],[156,191,149],[147,184,139],[140,178,133],[134,175,127],[127,170,119],[120,163,112],[115,159,106],[111,156,103],[106,154,99],[108,156,101],[109,157,100],[109,157,100],[108,157,100],[108,158,100],[107,158,100],[106,157,99],[106,157,99],[105,156,98],[112,156,104],[157,191,153],[184,214,184],[134,184,132],[104,160,100],[99,155,95],[102,158,97],[101,158,98],[103,159,99],[103,160,100],[102,158,99],[103,158,99],[103,158,99],[104,158,99],[105,158,99],[107,157,101],[109,157,103],[110,154,104],[114,154,107],[118,153,112],[149,171,147],[235,201,136],[216,170,85],[210,163,69],[209,162,65],[212,162,65],[214,163,68],[216,165,76],[225,175,91],[235,190,109],[229,173,75],[224,164,61],[224,164,61],[225,164,59],[226,164,60],[227,165,61],[226,165,61],[222,169,78],[235,209,167],[231,189,106],[222,168,65],[222,167,64],[222,167,64],[223,168,66],[220,169,81],[228,197,155],[206,177,174],[189,115,112],[192,113,109],[193,112,108],[195,112,106],[195,111,105],[195,109,102],[194,109,101],[195,107,100],[195,107,100],[195,107,100],[195,106,98],[196,106,98],[197,107,99],[196,105,97],[194,104,96],[194,101,94],[192,100,93],[193,100,93],[193,98,91],[193,99,90],[195,101,91],[195,99,91],[194,99,90],[193,97,88],[193,99,89],[192,98,89],[193,99,89],[195,100,91],[195,100,92],[197,103,94],[198,106,97],[181,121,112],[234,201,196],[228,173,167],[216,142,136],[208,115,108],[203,104,96],[203,104,94],[204,104,94],[202,103,93],[202,102,92],[201,102,92],[201,100,91],[200,100,91],[201,102,92],[201,100,91],[202,101,92],[199,100,91],[190,143,130],[206,228,202],[195,222,191],[183,215,178],[161,200,156],[126,173,120],[110,158,103],[107,157,100],[109,158,100],[108,158,100],[107,158,100],[107,157,99],[107,157,99],[105,156,98],[110,157,102],[172,202,167],[193,219,192],[162,205,159],[107,162,102],[102,157,98],[102,158,98],[103,158,99],[104,160,101],[104,159,100],[103,158,99],[104,159,99],[106,159,100],[106,159,100],[107,157,101],[110,158,103],[112,157,106],[115,156,109],[116,155,110],[122,153,117],[233,211,161],[227,202,147],[227,202,145],[232,206,152],[224,165,63],[224,165,60],[224,164,59],[224,163,58],[225,165,60],[223,165,64],[231,193,127],[222,173,81],[222,168,66],[222,167,66],[222,167,67],[223,169,68],[219,170,82],[217,183,134],[231,201,162],[234,207,174],[233,209,180],[229,208,184],[229,208,187],[228,211,193],[230,215,198],[233,219,207],[205,161,158],[190,117,113],[195,115,110],[195,113,108],[197,114,108],[196,110,104],[195,109,102],[194,108,101],[195,107,101],[195,107,100],[195,107,99],[195,106,98],[197,107,98],[197,107,98],[196,105,97],[195,104,96],[195,103,95],[194,102,94],[194,100,94],[194,100,91],[194,100,91],[194,100,90],[194,100,91],[193,99,89],[193,98,89],[193,98,89],[193,98,89],[193,99,90],[194,99,90],[195,99,91],[196,102,93],[194,114,105],[206,176,168],[235,208,203],[232,181,175],[218,146,138],[208,119,111],[205,107,97],[202,103,93],[200,102,92],[200,102,92],[199,101,91],[201,101,92],[200,101,91],[199,100,90],[199,100,90],[199,100,91],[195,103,92],[193,151,139],[202,191,180],[194,224,191],[145,188,138],[111,161,103],[108,160,100],[108,160,100],[107,158,99],[106,158,98],[107,158,98],[105,155,96],[140,179,133],[206,229,207],[164,207,161],[101,156,96],[102,157,98],[104,159,100],[105,160,101],[104,159,100],[105,160,101],[105,160,100],[106,159,100],[107,160,101],[109,159,103],[111,159,104],[113,159,107],[115,157,109],[117,155,110],[132,163,126],[226,171,74],[224,164,59],[223,165,59],[224,164,59],[223,164,60],[221,173,91],[233,197,137],[222,167,67],[224,169,66],[224,169,67],[225,169,68],[225,169,68],[223,167,68],[221,168,72],[218,167,77],[214,167,81],[212,166,84],[211,165,87],[209,166,88],[207,165,93],[205,166,98],[204,167,105],[207,176,123],[216,192,161],[206,164,161],[193,118,115],[197,116,112],[197,114,108],[197,114,107],[196,111,103],[195,109,102],[196,109,102],[195,108,101],[195,107,101],[195,106,99],[195,106,97],[195,106,97],[196,106,97],[196,104,96],[196,104,96],[195,103,95],[193,101,94],[193,99,92],[193,99,90],[195,100,90],[196,99,91],[194,99,90],[194,99,90],[194,99,90],[194,99,90],[196,99,91],[194,98,90],[194,99,90],[197,102,94],[205,134,126],[227,193,185],[232,208,203],[231,182,176],[220,149,140],[207,121,113],[202,104,96],[201,102,92],[200,102,92],[201,102,92],[201,102,92],[200,101,91],[197,99,89],[197,99,89],[196,99,89],[190,101,91],[190,107,97],[191,117,107],[190,134,125],[194,152,143],[201,171,161],[209,188,178],[217,201,192],[198,229,196],[123,171,116],[107,159,99],[106,159,98],[106,159,98],[107,160,99],[106,158,97],[105,156,95],[156,190,150],[197,230,197],[101,156,97],[105,160,101],[104,159,100],[105,160,101],[103,158,99],[105,160,101],[104,159,100],[107,161,101],[107,160,101],[109,160,103],[111,160,104],[112,158,105],[113,157,107],[128,165,121],[182,203,178],[232,183,89],[222,163,58],[222,163,58],[223,164,59],[220,165,61],[230,200,145],[224,173,82],[225,169,65],[226,169,67],[227,169,66],[227,169,66],[227,169,67],[227,169,66],[227,169,67],[227,169,67],[227,170,68],[227,170,69],[226,170,67],[226,169,67],[225,168,68],[224,167,67],[221,166,67],[218,165,68],[213,173,104],[232,186,184],[200,123,119],[197,116,111],[198,114,108],[196,113,107],[197,112,104],[197,112,104],[197,110,103],[196,109,102],[195,108,100],[195,106,99],[195,106,97],[195,105,97],[196,105,97],[196,104,96],[196,104,96],[195,103,95],[193,100,92],[194,99,91],[193,99,90],[194,99,90],[196,99,91],[195,99,90],[196,100,91],[197,100,92],[198,101,93],[198,101,93],[196,100,91],[200,115,107],[216,165,158],[233,213,207],[234,213,208],[225,149,140],[204,109,99],[201,102,92],[199,101,91],[201,102,92],[201,102,92],[199,101,91],[198,100,90],[199,100,90],[198,100,90],[197,99,89],[198,100,90],[191,100,90],[186,101,92],[184,106,96],[181,110,100],[180,115,107],[182,124,114],[187,138,130],[203,168,159],[140,187,134],[107,160,99],[107,161,99],[107,160,99],[108,160,99],[106,159,98],[105,157,96],[160,192,154],[200,233,200],[102,157,98],[104,161,101],[104,159,100],[104,160,100],[105,160,100],[106,161,101],[104,160,100],[107,161,102],[107,161,101],[108,161,102],[118,166,110],[134,179,128],[158,194,152],[192,216,188],[235,194,101],[220,163,59],[220,163,58],[220,164,59],[221,172,80],[235,222,197],[232,193,122],[224,167,66],[227,169,66],[227,169,66],[227,169,65],[227,169,66],[227,169,66],[227,169,66],[227,169,67],[227,169,67],[228,168,67],[227,169,66],[227,169,66],[227,169,67],[225,168,66],[225,169,66],[223,167,65],[219,166,66],[212,173,99],[222,157,153],[198,118,112],[195,113,106],[196,112,105],[197,112,104],[197,111,104],[197,110,103],[196,108,102],[196,108,101],[195,107,100],[195,105,98],[195,105,97],[195,104,96],[196,104,96],[195,103,95],[195,103,95],[195,101,94],[194,99,92],[193,99,90],[192,98,88],[194,98,89],[195,98,90],[196,99,91],[197,100,92],[198,101,93],[198,105,97],[205,140,131],[227,198,190],[208,123,114],[201,102,92],[201,102,92],[199,101,91],[200,102,92],[198,101,91],[197,99,89],[197,99,89],[198,100,90],[197,99,89],[200,102,92],[198,101,90],[198,100,90],[201,102,92],[199,103,92],[199,102,93],[197,100,92],[195,100,91],[187,103,95],[177,131,122],[199,189,178],[142,188,135],[107,160,99],[108,161,99],[107,160,99],[107,159,98],[107,160,99],[105,157,97],[156,188,151],[201,234,200],[101,156,97],[104,161,101],[104,160,100],[103,161,98],[106,162,100],[106,162,100],[105,161,99],[106,161,101],[106,161,101],[127,176,122],[176,212,172],[208,233,205],[218,163,59],[219,164,59],[218,163,60],[221,191,138],[222,167,71],[226,168,66],[227,169,65],[226,168,64],[226,167,64],[226,168,64],[227,169,65],[227,169,66],[227,169,66],[227,169,65],[227,168,67],[227,169,66],[226,168,67],[225,168,65],[223,167,65],[223,167,64],[221,167,64],[216,166,67],[212,190,136],[223,161,156],[203,121,114],[195,110,103],[195,109,102],[195,109,101],[195,108,101],[195,107,100],[195,106,100],[195,106,99],[195,105,97],[194,103,96],[194,103,96],[194,104,95],[195,104,96],[196,104,96],[194,102,94],[193,99,92],[194,99,91],[193,99,89],[194,98,89],[196,99,91],[197,100,92],[197,101,92],[202,120,112],[216,171,164],[231,213,206],[211,123,114],[200,101,91],[201,103,93],[200,101,91],[201,102,92],[198,100,90],[198,99,89],[199,101,91],[198,100,90],[199,101,91],[198,100,90],[197,99,89],[199,101,91],[200,102,92],[202,104,93],[201,102,92],[199,102,94],[198,101,93],[196,99,91],[192,99,90],[178,119,109],[203,192,181],[133,181,126],[107,158,98],[108,160,99],[107,160,99],[107,160,99],[107,160,99],[105,158,97],[158,187,153],[201,234,200],[101,157,97],[103,160,99],[102,160,97],[102,160,97],[105,163,100],[104,162,99],[105,160,98],[104,160,99],[109,162,104],[187,223,184],[229,182,92],[215,163,60],[216,164,60],[213,164,70],[229,214,189],[226,175,89],[226,168,65],[226,168,64],[226,168,64],[226,168,64],[226,168,64],[226,168,64],[226,168,64],[226,168,64],[226,168,65],[226,168,64],[226,167,65],[226,168,65],[225,167,65],[224,167,64],[223,167,65],[220,166,64],[218,167,65],[209,170,86],[235,196,190],[222,166,159],[210,145,139],[200,131,125],[194,122,116],[192,117,111],[193,116,109],[196,117,110],[199,118,111],[201,119,110],[198,114,106],[193,104,96],[194,103,95],[196,104,96],[195,102,95],[193,99,92],[193,98,90],[193,98,89],[194,98,89],[194,98,89],[196,102,94],[213,146,137],[232,201,191],[210,121,112],[199,100,90],[200,99,90],[199,99,90],[199,100,90],[198,100,90],[198,100,90],[198,100,90],[197,99,90],[200,101,92],[198,100,90],[198,100,90],[199,101,91],[201,102,92],[202,103,94],[200,102,92],[199,102,92],[198,101,92],[197,100,92],[196,99,91],[191,99,90],[181,132,121],[119,169,111],[107,159,98],[107,159,98],[106,159,98],[107,160,99],[107,160,99],[105,157,96],[161,188,157],[200,234,200],[101,156,97],[103,160,98],[103,160,97],[103,162,99],[105,163,100],[104,162,99],[103,160,98],[104,160,99],[111,162,105],[213,167,80],[215,165,61],[213,164,59],[219,177,93],[234,191,117],[225,166,63],[226,168,65],[226,168,65],[226,168,64],[226,168,64],[226,168,64],[226,168,64],[226,169,65],[226,168,65],[226,168,64],[226,168,65],[227,169,67],[225,168,64],[225,167,66],[224,168,66],[222,166,64],[219,167,64],[211,167,71],[219,208,186],[222,148,140],[200,110,102],[198,104,95],[197,103,95],[195,98,90],[194,98,89],[194,98,89],[195,99,90],[193,97,89],[212,144,134],[208,119,110],[199,100,90],[200,100,91],[198,97,88],[198,99,89],[198,100,90],[199,100,90],[197,99,89],[198,100,90],[199,101,91],[198,100,90],[198,100,90],[200,101,91],[201,102,92],[201,102,93],[201,103,93],[200,102,92],[197,100,92],[196,100,91],[196,100,91],[195,99,90],[184,104,95],[197,186,175],[179,211,177],[108,160,100],[106,159,98],[107,160,99],[106,159,99],[107,160,99],[106,159,98],[104,156,95],[159,187,155],[201,233,200],[101,156,97],[104,160,99],[104,160,98],[104,162,99],[104,162,99],[104,162,99],[104,160,98],[107,162,100],[108,161,102],[172,206,170],[211,189,168],[212,165,69],[215,166,62],[211,164,65],[217,194,151],[225,167,65],[226,167,64],[226,167,64],[225,167,63],[226,168,64],[225,167,63],[226,168,64],[227,169,66],[227,169,65],[226,168,64],[226,169,65],[227,169,65],[225,167,63],[226,167,66],[225,167,66],[223,167,65],[220,167,64],[213,168,70],[216,199,160],[226,149,140],[203,107,99],[199,103,95],[195,99,90],[193,97,88],[193,96,88],[193,97,88],[188,96,88],[219,174,164],[201,117,108],[200,99,90],[199,99,89],[198,99,89],[199,98,89],[198,99,89],[198,99,89],[198,99,89],[198,100,90],[198,100,90],[198,100,90],[197,99,89],[199,101,91],[200,101,91],[201,102,93],[200,101,92],[199,102,92],[198,101,92],[196,99,90],[196,99,91],[196,100,91],[191,102,93],[190,154,143],[136,177,129],[106,158,98],[107,159,99],[108,160,99],[107,160,99],[106,158,97],[105,156,96],[105,155,95],[156,186,149],[201,233,201],[102,156,97],[104,160,100],[104,160,100],[105,161,99],[105,161,99],[106,161,99],[105,161,100],[106,162,100],[107,161,100],[120,167,116],[180,209,178],[212,185,144],[208,166,89],[213,164,63],[215,166,64],[212,168,72],[228,217,203],[225,169,69],[225,167,64],[226,167,64],[225,167,64],[226,168,65],[225,167,65],[226,168,65],[227,169,65],[227,169,65],[226,168,65],[226,168,66],[227,169,66],[227,169,65],[225,168,64],[224,167,65],[223,167,65],[223,169,66],[216,168,70],[222,200,152],[208,116,108],[197,101,92],[196,99,91],[193,97,88],[193,97,88],[193,97,88],[189,97,88],[215,161,153],[201,114,106],[200,100,91],[200,99,90],[199,100,90],[199,98,88],[198,99,90],[198,100,90],[199,99,90],[199,101,91],[198,100,90],[198,100,90],[199,100,90],[199,101,91],[201,102,92],[201,102,92],[201,103,92],[199,103,92],[198,101,91],[196,99,90],[196,99,90],[196,99,89],[193,101,93],[181,145,134],[171,204,166],[109,158,101],[106,157,97],[107,158,98],[108,158,98],[106,158,97],[104,155,95],[105,156,96],[103,154,93],[153,186,148],[201,232,200],[103,156,98],[104,159,100],[104,159,100],[104,159,100],[105,161,99],[105,160,99],[106,160,101],[106,159,100],[107,160,101],[109,161,103],[115,163,110],[145,183,141],[171,200,168],[192,214,191],[222,207,196],[213,190,169],[215,178,116],[212,169,93],[210,163,74],[214,162,61],[214,163,60],[216,164,62],[213,174,95],[225,171,74],[224,168,64],[225,167,65],[225,167,64],[225,167,65],[225,168,65],[227,169,66],[227,169,66],[226,169,66],[227,170,66],[227,169,66],[227,168,66],[226,168,67],[224,168,66],[226,169,68],[225,168,67],[225,170,68],[220,170,72],[225,207,172],[213,127,119],[198,100,92],[197,99,91],[195,97,88],[194,96,88],[195,97,89],[194,97,88],[194,145,136],[204,112,104],[202,101,92],[201,100,91],[200,100,90],[198,99,89],[198,99,89],[199,99,90],[198,99,89],[198,99,89],[198,100,90],[199,101,91],[201,102,92],[200,101,91],[199,101,91],[200,102,92],[201,103,92],[199,102,92],[196,99,91],[196,100,89],[197,100,90],[197,100,92],[190,101,91],[186,160,149],[192,218,191],[118,162,111],[105,156,98],[106,157,98],[108,159,99],[109,160,99],[108,159,99],[107,157,97],[107,157,97],[103,153,93],[151,184,147],[202,231,201],[104,157,100],[106,159,100],[105,159,100],[105,158,99],[106,159,100],[107,160,101],[107,160,102],[106,159,100],[107,159,100],[108,159,101],[108,158,101],[110,157,103],[113,155,106],[118,157,112],[127,162,121],[140,171,134],[170,192,165],[216,205,193],[211,182,145],[216,172,92],[212,164,79],[210,160,76],[214,161,66],[218,161,60],[219,162,61],[218,162,60],[218,163,61],[215,162,61],[226,191,123],[224,172,77],[223,167,65],[223,168,66],[223,166,65],[223,167,63],[223,167,63],[225,167,65],[226,168,65],[226,168,65],[228,170,67],[227,171,67],[227,170,66],[226,169,67],[226,169,66],[227,170,68],[226,169,68],[226,170,69],[222,176,94],[234,221,201],[211,120,112],[198,101,93],[196,99,91],[194,97,88],[194,97,88],[194,98,89],[193,97,89],[186,126,117],[231,204,198],[205,110,102],[200,100,91],[199,99,90],[198,99,89],[198,100,90],[198,100,90],[199,100,91],[197,99,89],[198,99,89],[197,99,89],[199,101,91],[201,102,92],[199,101,91],[199,101,91],[199,101,91],[200,102,92],[198,102,93],[197,100,91],[195,99,89],[197,100,92],[197,101,92],[187,105,95],[215,200,190],[196,216,195],[127,168,122],[105,153,97],[105,155,97],[106,157,99],[106,157,99],[108,159,99],[107,158,98],[107,158,98],[106,157,97],[103,154,94],[151,182,147],[201,231,201],[105,157,99],[106,159,100],[106,159,100],[106,159,100],[107,160,101],[108,160,101],[108,161,102],[107,160,101],[107,159,100],[107,158,100],[108,158,102],[109,157,102],[110,157,103],[110,157,103],[111,157,103],[111,156,103],[116,155,108],[131,163,125],[167,185,163],[213,196,182],[211,174,113],[216,167,76],[215,162,70],[218,162,63],[220,162,62],[220,163,62],[220,163,61],[220,163,62],[220,163,61],[220,164,61],[219,163,61],[216,162,63],[229,204,159],[215,171,88],[216,166,69],[217,166,69],[216,165,70],[225,174,84],[233,182,93],[231,179,88],[225,171,77],[223,168,70],[224,169,67],[224,169,67],[225,168,67],[225,168,67],[225,169,67],[226,169,67],[226,169,68],[227,172,74],[228,199,149],[201,106,98],[198,101,93],[196,98,91],[194,97,88],[194,97,89],[194,98,89],[194,98,89],[180,115,107],[234,202,196],[202,108,98],[198,100,90],[197,99,89],[199,99,90],[198,100,90],[199,101,90],[199,101,91],[198,100,90],[198,100,90],[198,100,91],[200,101,91],[200,102,92],[201,102,92],[200,101,92],[201,102,92],[200,102,93],[200,102,94],[198,101,91],[198,102,92],[198,101,93],[194,102,94],[205,155,145],[188,211,186],[127,164,122],[107,154,99],[107,154,99],[105,155,97],[105,156,98],[106,157,99],[107,158,99],[107,158,99],[106,157,97],[106,157,99],[103,153,95],[150,180,147],[202,232,201],[105,158,99],[106,159,100],[106,159,100],[106,160,101],[107,160,101],[107,160,101],[108,161,102],[108,161,101],[108,160,101],[109,159,101],[110,160,102],[110,158,102],[110,158,103],[111,158,103],[112,158,104],[113,158,104],[111,156,103],[113,156,105],[118,154,110],[148,167,144],[208,180,131],[213,164,73],[215,163,64],[219,162,61],[219,161,60],[219,162,61],[221,163,62],[220,163,61],[221,164,61],[220,163,61],[219,163,61],[220,164,60],[219,163,59],[219,165,65],[231,216,200],[235,220,207],[207,172,103],[208,168,79],[206,167,80],[218,182,118],[231,191,110],[219,176,91],[210,166,78],[208,163,72],[209,163,71],[213,166,74],[222,176,85],[235,198,133],[234,217,210],[204,137,129],[197,100,92],[197,100,92],[195,98,89],[193,97,88],[194,98,89],[195,99,90],[195,99,90],[179,108,100],[219,204,196],[233,197,191],[201,106,96],[197,99,89],[197,99,89],[198,98,89],[197,99,89],[198,100,90],[199,100,90],[198,100,90],[199,101,91],[201,102,92],[201,102,92],[201,102,92],[201,102,93],[199,101,91],[200,101,93],[200,102,93],[200,102,93],[197,100,92],[198,102,94],[201,111,102],[215,155,146],[180,202,177],[120,159,115],[107,152,99],[107,154,100],[108,155,100],[107,156,99],[105,156,98],[106,157,99],[106,157,99],[106,157,97],[106,157,98],[106,157,98],[103,153,95],[153,180,149],[199,232,199],[105,157,99],[107,160,101],[106,159,100],[107,160,101],[108,161,102],[108,161,102],[108,161,102],[108,161,102],[108,160,101],[110,160,102],[110,160,102],[110,159,103],[110,158,103],[110,158,103],[112,158,103],[113,158,104],[111,156,103],[113,156,105],[115,156,106],[118,154,112],[204,180,149],[213,163,71],[218,163,62],[219,162,61],[219,162,61],[220,162,62],[220,163,62],[221,164,62],[222,165,62],[221,164,61],[221,163,61],[221,163,60],[221,165,61],[220,163,60],[219,168,76],[203,171,104],[204,169,80],[207,175,102],[231,210,184],[229,206,176],[232,209,177],[225,205,198],[205,139,130],[195,102,94],[197,101,93],[197,100,92],[195,98,90],[193,97,88],[193,97,89],[194,98,89],[196,99,91],[184,103,94],[208,190,181],[235,191,187],[200,104,95],[198,98,89],[198,99,89],[197,98,89],[198,100,90],[199,101,91],[199,101,91],[199,100,90],[199,101,91],[200,101,91],[201,102,92],[203,105,95],[202,103,93],[201,102,92],[201,108,98],[204,113,105],[209,118,110],[219,127,119],[230,153,145],[230,201,192],[170,194,167],[120,156,114],[106,150,99],[108,153,100],[108,155,101],[107,154,100],[107,155,100],[105,156,98],[105,156,98],[106,157,99],[106,157,99],[106,157,99],[105,156,97],[104,153,95],[155,181,151],[198,231,199],[105,158,100],[107,160,101],[107,160,101],[106,159,100],[107,160,101],[108,161,102],[108,161,102],[107,160,101],[109,160,102],[109,159,101],[110,159,101],[110,160,103],[110,158,103],[111,159,104],[112,158,104],[113,158,104],[112,157,104],[113,156,105],[116,157,108],[116,156,110],[152,177,147],[197,164,91],[216,165,66],[219,164,64],[219,163,61],[219,162,61],[220,163,62],[220,163,62],[220,163,61],[222,164,62],[221,164,61],[220,163,61],[220,162,59],[220,163,59],[221,163,60],[218,173,98],[234,219,206],[200,169,105],[201,167,84],[219,195,154],[196,162,155],[190,117,110],[194,101,93],[196,100,92],[195,99,90],[196,99,91],[194,98,89],[193,97,88],[193,97,89],[193,97,88],[193,98,89],[182,102,93],[196,177,169],[229,193,187],[199,104,95],[198,99,89],[197,98,88],[199,98,89],[198,98,88],[199,100,90],[199,99,90],[198,99,90],[198,99,89],[198,99,90],[199,100,90],[202,104,94],[207,117,107],[228,146,137],[235,178,168],[162,185,159],[120,156,114],[113,154,105],[109,152,102],[109,154,102],[108,155,101],[107,154,100],[107,155,99],[105,156,98],[105,155,97],[105,155,97],[105,156,98],[107,155,98],[107,155,98],[105,153,96],[153,179,150],[198,231,199],[106,158,99],[107,160,101],[108,160,102],[107,160,100],[107,160,101],[108,161,102],[107,160,101],[109,160,102],[109,159,101],[110,160,102],[110,160,103],[110,159,103],[111,159,104],[112,159,104],[112,159,104],[113,158,104],[113,158,104],[115,157,106],[116,158,110],[116,156,109],[147,175,143],[205,171,98],[216,165,64],[218,164,64],[218,163,61],[219,163,61],[219,163,61],[220,164,61],[221,164,62],[223,164,62],[221,163,62],[220,162,61],[220,162,59],[220,163,60],[220,163,60],[226,182,113],[231,219,207],[199,170,112],[200,169,96],[231,212,192],[203,185,178],[193,150,142],[186,119,112],[186,105,98],[194,103,96],[196,102,94],[195,101,93],[195,100,91],[194,98,89],[195,98,90],[194,98,89],[195,98,90],[193,97,88],[193,98,90],[186,98,91],[194,153,147],[226,189,181],[199,104,94],[199,99,90],[199,99,89],[200,99,90],[198,98,88],[198,98,88],[199,98,89],[200,99,90],[201,100,91],[200,99,90],[199,100,91],[216,135,124],[165,186,161],[121,153,116],[115,153,109],[113,154,107],[110,153,103],[110,154,103],[109,154,100],[107,153,99],[106,154,97],[105,155,97],[104,155,97],[104,154,96],[104,154,96],[106,154,96],[107,155,98],[106,153,96],[151,179,146],[198,230,199],[106,158,101],[108,161,102],[107,160,102],[107,160,101],[106,159,100],[109,162,103],[107,160,101],[108,160,102],[108,158,100],[109,159,101],[111,159,103],[112,159,105],[112,159,104],[112,159,104],[113,160,105],[114,159,105],[115,160,107],[115,157,107],[116,158,108],[117,156,110],[171,193,168],[230,205,151],[212,162,67],[217,163,63],[218,163,62],[219,163,62],[220,164,62],[220,163,62],[220,164,62],[221,164,62],[221,165,63],[221,164,63],[220,164,61],[221,165,63],[221,164,60],[230,217,203],[201,172,102],[204,172,93],[195,165,159],[185,128,122],[189,111,104],[190,106,98],[193,103,96],[196,102,95],[196,102,95],[195,100,93],[194,99,92],[194,99,91],[195,99,91],[195,99,91],[195,98,90],[195,98,90],[194,97,89],[191,97,89],[186,96,88],[188,137,130],[229,189,181],[201,103,94],[200,100,90],[199,99,89],[199,98,89],[199,98,88],[199,98,89],[199,98,89],[200,99,90],[201,100,91],[200,99,90],[198,104,94],[124,155,120],[119,153,113],[115,152,109],[113,152,106],[110,151,103],[109,151,101],[108,153,100],[107,153,98],[104,152,97],[104,152,96],[105,153,96],[103,152,95],[105,153,96],[106,154,97],[105,153,98],[107,153,99],[143,176,138],[197,229,196],[106,159,100],[108,161,102],[106,159,100],[107,159,101],[107,161,101],[108,161,102],[106,159,100],[107,159,100],[107,158,100],[109,159,101],[110,159,103],[112,159,105],[111,159,104],[111,159,104],[113,160,105],[114,159,106],[115,160,109],[116,159,108],[116,158,108],[131,167,124],[227,194,120],[215,164,67],[214,162,61],[216,162,61],[217,161,61],[219,162,61],[220,163,62],[221,164,63],[220,163,62],[221,164,63],[220,164,62],[221,165,63],[220,163,61],[232,215,202],[202,171,101],[201,168,92],[235,215,190],[203,168,165],[189,123,118],[189,109,101],[191,105,97],[196,104,96],[196,104,96],[195,103,96],[195,102,95],[195,101,94],[194,99,92],[193,98,92],[193,98,92],[194,99,91],[194,99,92],[194,98,89],[194,99,90],[193,98,89],[191,96,88],[188,96,88],[174,123,116],[229,179,172],[200,102,93],[199,100,90],[197,98,88],[199,98,89],[198,98,88],[198,98,89],[200,99,90],[200,99,90],[200,99,90],[199,101,91],[202,113,104],[156,179,154],[122,152,118],[118,151,114],[113,149,108],[113,151,108],[110,151,104],[115,155,108],[138,179,132],[156,198,150],[155,198,148],[146,190,139],[127,173,120],[108,156,102],[106,153,98],[108,153,99],[108,153,101],[109,153,102],[121,160,114],[161,192,157],[162,191,159],[163,190,161],[163,188,160],[161,185,159],[159,184,157],[155,180,154],[149,173,149],[149,172,148],[152,173,151],[153,174,153],[155,175,154],[159,178,159],[159,177,158],[161,178,160],[161,179,161],[159,178,159],[151,177,147],[150,178,147],[151,177,148],[148,177,146],[150,176,147],[149,177,146],[153,179,151],[158,184,157],[161,185,157],[165,189,162],[166,191,164],[165,189,164],[166,191,165],[168,192,167],[169,192,169],[172,193,172],[176,196,176],[178,198,178],[178,210,178],[107,158,102],[110,160,104],[110,160,104],[110,160,103],[110,161,104],[111,161,105],[119,170,113],[129,178,121],[125,174,118],[120,169,113],[116,164,110],[113,161,107],[111,158,103],[111,157,103],[111,158,105],[114,159,106],[118,162,110],[127,168,122],[146,182,138],[192,212,187],[233,207,167],[225,192,140],[222,184,127],[222,181,120],[225,181,115],[230,185,114],[226,176,93],[219,163,64],[219,163,62],[219,164,62],[220,163,62],[220,164,62],[223,175,85],[222,203,182],[231,214,193],[205,170,95],[205,168,79],[216,192,148],[202,154,147],[190,111,105],[194,107,101],[198,107,101],[197,105,98],[196,104,97],[196,104,96],[194,102,94],[194,101,94],[194,100,93],[193,99,92],[194,99,92],[194,98,92],[193,98,91],[194,99,91],[193,99,90],[194,99,91],[193,98,91],[191,95,89],[188,96,88],[174,109,102],[227,162,155],[199,101,91],[198,100,90],[197,99,89],[198,99,89],[198,99,89],[198,100,90],[199,99,90],[197,99,89],[198,100,90],[200,101,91],[200,109,99],[219,193,180],[172,194,169],[123,152,119],[117,148,112],[114,147,108],[115,150,109],[132,166,127],[176,206,172],[208,233,206],[197,227,193],[151,191,145],[111,154,103],[108,151,100],[108,151,100],[110,152,102],[109,150,101],[109,150,103],[110,151,105],[111,150,106],[111,150,105],[110,149,105],[109,149,103],[109,149,103],[107,149,102],[107,149,102],[105,147,100],[104,146,100],[107,147,101],[108,150,104],[109,148,103],[109,147,104],[110,148,105],[112,150,106],[111,149,106],[111,150,106],[112,149,107],[112,149,105],[112,148,107],[111,150,105],[111,149,107],[113,151,109],[115,152,110],[117,154,112],[116,153,112],[117,152,112],[115,154,111],[116,154,111],[116,154,113],[118,154,113],[119,156,114],[118,156,113],[118,155,113],[118,155,113],[117,155,113],[117,155,113],[119,157,114],[121,160,117],[124,162,119],[126,165,121],[123,165,118],[112,159,108],[112,160,106],[111,159,106],[111,159,106],[117,164,111],[157,196,154],[194,227,192],[197,231,194],[187,223,185],[176,213,173],[167,204,162],[161,198,155],[160,198,155],[163,202,157],[172,208,165],[189,216,187],[221,167,68],[218,164,63],[218,164,63],[219,165,63],[219,165,65],[212,166,82],[232,219,203],[227,209,184],[208,170,89],[208,169,78],[203,168,87],[212,186,153],[234,218,210],[205,169,165],[192,112,106],[195,108,103],[197,107,101],[197,107,101],[195,105,98],[195,103,96],[195,103,95],[194,102,94],[192,100,93],[193,100,93],[193,99,92],[193,98,92],[194,98,92],[194,100,93],[193,99,92],[193,99,91],[194,99,91],[192,97,90],[190,95,88],[188,94,87],[171,100,93],[227,203,198],[214,126,119],[198,100,91],[197,99,89],[197,98,88],[198,99,89],[198,100,90],[198,100,90],[196,97,88],[197,98,88],[199,100,90],[201,102,92],[201,103,93],[191,132,121],[157,182,155],[135,162,133],[139,166,135],[167,193,163],[203,225,203],[205,231,205],[130,169,124],[108,150,99],[110,152,102],[111,153,103],[109,151,102],[109,151,103],[110,151,103],[110,152,104],[110,152,104],[108,150,102],[109,151,102],[109,151,103],[109,151,102],[109,151,103],[106,148,100],[105,148,99],[106,148,101],[107,150,101],[107,149,101],[108,150,102],[110,151,104],[109,151,102],[109,151,103],[110,152,106],[110,152,105],[109,150,103],[110,151,105],[110,152,104],[111,152,106],[112,153,107],[111,153,107],[112,154,107],[114,153,108],[113,154,108],[114,154,108],[115,155,108],[115,155,109],[115,155,110],[115,157,111],[115,157,108],[114,156,108],[113,155,107],[113,155,108],[113,154,107],[113,155,107],[113,156,108],[113,156,108],[113,157,108],[113,158,108],[114,159,108],[112,159,107],[113,159,108],[113,159,109],[156,192,152],[217,163,62],[219,164,62],[219,165,62],[220,166,63],[216,164,69],[214,187,153],[212,169,84],[214,170,74],[212,167,73],[209,166,83],[211,176,112],[227,210,191],[191,126,121],[196,109,103],[196,108,101],[198,107,101],[196,105,99],[194,103,97],[193,102,94],[193,101,94],[192,100,92],[192,100,93],[192,100,93],[193,99,92],[194,100,93],[194,100,93],[195,101,94],[194,100,93],[194,99,92],[194,99,92],[193,98,91],[191,97,90],[188,96,88],[176,97,91],[203,181,177],[200,164,159],[195,123,118],[197,101,94],[198,100,92],[197,99,89],[196,97,88],[197,99,89],[197,99,89],[198,100,90],[197,98,88],[197,99,89],[198,100,91],[199,101,91],[201,103,93],[192,106,96],[199,151,140],[152,188,147],[109,151,102],[110,152,104],[110,152,103],[110,152,103],[110,152,104],[110,152,104],[109,151,102],[108,150,101],[107,149,101],[109,151,102],[109,151,103],[109,151,102],[109,151,102],[109,151,103],[108,153,104],[110,152,104],[110,152,103],[109,151,102],[110,152,104],[109,150,103],[109,151,103],[108,149,103],[110,152,104],[110,152,104],[110,152,104],[111,153,105],[111,153,105],[111,153,106],[112,154,107],[112,154,106],[112,153,106],[113,153,107],[113,154,108],[115,155,108],[116,156,109],[115,155,109],[112,154,106],[114,155,109],[113,155,109],[115,156,109],[115,157,108],[115,157,108],[113,155,107],[114,157,108],[113,157,108],[113,158,109],[114,158,109],[114,158,109],[113,158,108],[113,158,107],[113,158,108],[122,163,118],[207,233,206],[217,163,64],[221,166,63],[220,166,63],[220,166,64],[216,165,71],[201,192,177],[190,177,150],[177,164,138],[218,203,190],[213,188,159],[209,177,124],[211,169,90],[217,170,77],[218,170,75],[216,169,73],[215,168,70],[212,166,73],[207,170,100],[222,207,187],[217,196,190],[191,114,108],[196,108,103],[196,107,101],[196,106,100],[195,104,98],[193,103,96],[192,101,95],[193,102,95],[192,101,94],[192,100,93],[193,101,94],[194,100,94],[195,102,94],[195,101,94],[195,101,94],[194,100,93],[195,100,94],[194,100,93],[193,98,91],[192,99,92],[189,97,89],[176,97,90],[189,166,160],[204,183,178],[191,153,148],[180,125,119],[186,104,98],[194,98,92],[196,99,92],[197,100,92],[197,98,90],[196,97,88],[197,99,89],[197,99,89],[197,98,89],[197,99,90],[197,99,89],[196,99,90],[197,100,91],[197,100,91],[198,101,93],[189,109,100],[212,190,184],[154,190,149],[110,152,104],[110,152,103],[109,151,102],[109,151,102],[110,152,103],[110,152,103],[116,158,109],[116,157,109],[111,153,105],[108,150,101],[108,150,101],[107,148,100],[110,152,103],[109,151,102],[110,152,104],[110,153,104],[110,152,103],[110,152,104],[110,152,104],[109,151,103],[110,151,104],[109,150,103],[109,151,103],[109,151,102],[109,151,104],[110,152,104],[110,152,104],[112,154,106],[112,154,107],[113,153,106],[113,153,107],[113,154,107],[114,154,108],[114,154,107],[115,156,109],[114,155,108],[114,156,108],[115,157,109],[115,156,110],[116,157,110],[114,157,108],[114,156,108],[114,156,107],[114,156,108],[114,158,109],[114,158,109],[115,160,110],[114,159,109],[113,157,108],[113,157,108],[112,157,107],[131,169,127],[219,165,64],[222,166,64],[221,167,64],[221,167,64],[215,164,73],[201,189,172],[192,175,144],[189,167,121],[194,165,94],[192,166,96],[220,210,193],[210,201,189],[204,194,179],[204,185,163],[201,176,144],[202,171,122],[204,167,98],[209,166,84],[214,167,76],[216,168,71],[219,168,73],[219,169,72],[219,169,71],[218,168,70],[217,167,69],[216,169,71],[208,172,103],[222,210,193],[208,176,170],[195,112,107],[196,109,103],[195,106,100],[195,106,99],[194,104,98],[194,104,97],[192,102,96],[192,102,96],[192,101,95],[191,100,93],[192,100,93],[192,101,94],[193,102,95],[197,109,102],[211,127,120],[229,154,146],[209,122,115],[189,100,93],[184,97,89],[179,95,89],[183,143,137],[202,184,179],[191,156,152],[171,126,122],[172,108,103],[184,99,94],[191,98,92],[194,100,93],[195,101,94],[196,99,92],[196,100,92],[194,98,89],[193,97,88],[195,98,89],[197,99,90],[198,100,92],[198,100,92],[197,98,91],[195,98,89],[197,100,92],[197,99,91],[198,101,93],[195,103,94],[184,138,131],[146,182,140],[111,153,104],[110,152,103],[109,152,103],[110,152,104],[109,152,102],[139,176,134],[183,218,179],[186,222,182],[164,202,159],[122,163,116],[108,150,101],[106,149,100],[108,151,101],[108,152,103],[109,153,104],[109,151,102],[108,150,102],[110,152,103],[110,152,103],[110,151,104],[109,150,103],[109,151,104],[112,154,107],[114,155,107],[114,155,108],[114,156,107],[112,154,107],[111,153,105],[112,153,106],[114,153,106],[114,153,107],[113,154,107],[113,154,106],[113,154,108],[113,155,108],[114,155,107],[114,156,107],[115,157,108],[114,156,108],[115,157,108],[113,155,107],[113,154,107],[113,155,107],[112,155,107],[114,158,109],[113,157,108],[113,157,108],[114,158,108],[113,158,108],[114,158,109],[111,155,107],[130,169,126],[219,165,63],[220,166,63],[219,165,63],[221,167,64],[216,165,71],[232,207,176],[202,189,172],[189,172,148],[185,165,125],[193,167,96],[199,169,87],[200,169,83],[197,168,90],[229,215,192],[220,206,187],[207,188,152],[196,177,134],[190,172,130],[191,174,135],[193,176,140],[193,177,143],[192,176,145],[190,174,141],[187,169,137],[185,167,134],[187,166,127],[189,165,118],[190,163,107],[198,164,92],[203,164,80],[207,164,76],[211,165,73],[215,167,70],[218,168,69],[220,169,70],[220,169,71],[219,169,70],[220,168,70],[220,170,71],[218,168,69],[218,169,69],[219,170,71],[207,177,115],[218,174,170],[198,113,108],[197,110,105],[195,107,102],[195,106,99],[194,104,98],[193,103,97],[192,103,96],[192,103,97],[192,102,96],[191,101,95],[191,101,95],[197,112,106],[218,141,134],[233,181,174],[229,162,155],[185,100,94],[182,98,92],[180,96,93],[173,109,104],[171,126,120],[171,134,128],[174,146,140],[179,157,152],[186,168,163],[195,181,175],[181,161,155],[174,139,135],[167,120,116],[168,109,105],[179,99,94],[186,96,92],[189,97,92],[189,97,92],[191,99,93],[194,100,94],[192,99,92],[193,98,92],[194,99,90],[201,106,98],[214,122,113],[209,115,106],[200,103,94],[199,102,94],[197,100,92],[197,100,92],[196,99,91],[197,100,92],[198,100,93],[198,101,93],[198,103,94],[181,112,103],[135,171,129],[110,153,103],[109,151,102],[109,151,103],[110,152,103],[127,166,121],[204,228,203],[182,218,179],[116,158,110],[106,150,101],[107,152,101],[108,153,103],[108,152,103],[107,152,102],[107,151,101],[107,151,102],[107,150,102],[109,152,104],[134,170,129],[166,198,164],[184,213,181],[184,215,181],[181,213,178],[170,204,167],[152,188,148],[131,169,125],[113,154,106],[113,153,106],[114,153,107],[114,155,107],[115,154,108],[114,155,107],[113,155,107],[114,154,106],[113,155,107],[113,155,107],[114,156,109],[123,164,116],[127,168,123],[125,167,120],[121,162,115],[113,157,108],[115,158,110],[115,159,111],[114,158,109],[113,157,108],[113,157,108],[113,157,108],[111,156,106],[126,164,122],[222,186,122],[219,166,65],[220,165,65],[221,166,65],[220,167,65],[219,167,68],[216,176,99],[217,188,131],[212,188,138],[210,188,146],[207,189,154],[203,186,155],[197,181,151],[188,172,140],[185,166,128],[187,166,127],[197,174,121],[205,179,110],[204,174,96],[199,167,83],[197,165,86],[210,192,157],[210,195,179],[202,182,145],[197,170,112],[195,164,92],[199,166,84],[201,168,84],[199,167,84],[199,168,86],[198,169,88],[198,170,89],[198,170,91],[197,170,91],[198,171,92],[199,171,91],[200,170,91],[201,169,86],[203,168,82],[206,166,75],[210,166,71],[212,165,68],[216,166,69],[218,167,68],[220,168,69],[221,170,71],[220,168,69],[221,169,69],[220,169,70],[220,169,70],[220,170,70],[221,172,70],[217,172,73],[211,195,162],[235,189,185],[204,120,115],[196,110,105],[194,106,101],[194,106,99],[193,106,99],[192,103,97],[191,103,97],[191,104,97],[191,102,96],[197,115,109],[219,148,142],[229,196,189],[228,169,164],[186,100,95],[186,100,95],[185,99,94],[182,99,93],[179,99,93],[175,99,94],[169,101,95],[166,104,99],[164,108,102],[164,113,106],[163,117,111],[165,121,115],[168,129,122],[175,140,133],[181,148,141],[184,153,147],[187,158,151],[189,161,155],[191,165,157],[192,168,160],[188,163,156],[184,155,149],[180,150,143],[176,142,137],[171,130,126],[167,121,117],[163,116,113],[165,113,109],[165,108,102],[175,102,98],[183,99,96],[185,99,94],[185,98,93],[187,99,94],[188,98,93],[188,98,92],[190,99,93],[191,99,94],[191,98,92],[191,98,91],[198,109,101],[215,126,118],[198,103,96],[195,100,93],[194,99,92],[196,99,91],[197,100,92],[197,100,92],[198,101,93],[199,103,94],[188,105,96],[208,194,187],[122,158,115],[110,152,103],[109,151,103],[109,151,103],[109,150,103],[175,203,172],[151,189,146],[107,151,102],[107,151,102],[108,152,102],[106,151,100],[106,150,100],[107,152,101],[108,152,103],[107,152,102],[148,181,145],[202,229,198],[164,198,158],[123,162,118],[113,153,106],[114,153,106],[113,153,107],[112,154,106],[114,156,108],[112,154,106],[113,155,107],[116,158,111],[150,187,146],[185,214,182],[202,230,201],[205,234,203],[192,224,190],[146,184,144],[114,159,110],[115,160,110],[115,160,111],[111,156,107],[110,155,106],[113,157,108],[112,157,108],[119,159,115],[204,226,205],[231,222,206],[214,171,80],[219,167,66],[219,167,66],[220,168,67],[219,167,66],[218,167,67],[215,167,67],[210,166,72],[208,168,79],[206,169,84],[200,169,91],[196,167,95],[193,168,100],[189,166,108],[195,172,122],[217,194,152],[200,167,86],[198,165,84],[194,165,95],[197,169,110],[200,174,119],[201,176,125],[200,175,127],[198,174,127],[194,172,126],[191,169,124],[190,168,122],[192,167,117],[194,165,106],[197,163,89],[202,164,76],[204,165,76],[205,167,76],[206,168,77],[205,168,79],[207,171,83],[203,170,85],[200,169,87],[200,172,95],[201,173,97],[200,172,94],[199,170,91],[200,169,86],[202,170,84],[205,170,81],[207,167,76],[209,167,72],[213,166,69],[216,167,69],[218,168,68],[220,169,70],[221,169,71],[221,169,70],[220,169,69],[220,168,69],[220,168,69],[220,170,68],[221,172,71],[220,174,73],[204,185,141],[218,146,141],[197,112,107],[191,106,100],[190,105,98],[191,105,98],[191,104,98],[190,104,98],[197,116,111],[218,150,143],[229,197,190],[208,147,142],[188,101,97],[188,100,96],[188,101,96],[187,100,95],[187,100,95],[184,97,92],[184,98,93],[184,99,94],[185,100,95],[186,102,96],[186,102,97],[187,103,98],[186,104,99],[186,105,100],[185,105,100],[184,106,101],[183,107,101],[181,106,101],[179,108,101],[178,108,101],[177,107,101],[175,105,99],[173,103,97],[174,104,98],[178,103,99],[181,102,98],[185,102,99],[185,103,99],[187,102,98],[186,102,97],[187,100,97],[185,99,95],[185,100,94],[186,99,93],[188,99,94],[188,98,93],[190,99,93],[191,100,94],[191,99,93],[191,99,93],[218,170,161],[232,177,169],[203,110,102],[194,100,93],[195,101,94],[195,100,93],[195,99,92],[195,100,92],[197,102,94],[199,104,96],[190,105,97],[205,187,182],[196,216,195],[114,151,108],[110,151,103],[109,150,102],[110,152,103],[122,157,119],[188,218,185],[109,152,104],[107,152,103],[107,152,102],[106,151,101],[107,151,100],[106,153,103],[108,154,104],[117,156,113],[187,214,185],[122,162,116],[114,154,107],[113,154,108],[113,155,107],[114,156,109],[114,156,107],[115,155,109],[165,195,162],[143,184,139],[114,159,109],[115,159,110],[112,156,107],[112,156,107],[112,158,108],[111,158,108],[113,157,109],[150,178,149],[218,197,168],[214,166,69],[218,167,66],[218,166,65],[220,168,67],[219,167,66],[218,167,66],[215,168,67],[214,166,66],[214,168,69],[213,171,73],[210,171,73],[207,172,76],[199,171,84],[201,180,122],[230,212,177],[207,169,80],[205,167,74],[204,167,75],[201,165,75],[200,165,78],[201,166,82],[202,167,85],[202,167,87],[202,167,88],[202,167,88],[202,167,87],[202,166,83],[203,166,77],[204,166,76],[205,165,74],[206,166,75],[206,166,75],[206,166,75],[208,169,78],[210,171,82],[205,170,86],[208,180,115],[232,210,167],[229,207,160],[215,189,124],[206,175,96],[204,169,81],[207,168,77],[210,168,73],[213,167,71],[215,167,69],[217,167,68],[220,169,70],[221,169,71],[220,169,70],[219,169,69],[220,169,70],[219,168,69],[220,170,69],[221,172,71],[222,175,75],[211,187,128],[210,140,135],[188,114,109],[185,109,103],[190,114,108],[200,124,118],[222,155,149],[230,198,192],[195,118,114],[190,103,98],[188,102,97],[187,101,96],[187,102,96],[186,101,95],[184,98,93],[185,99,94],[186,100,95],[186,101,95],[188,102,97],[188,102,97],[190,104,99],[190,104,99],[191,106,100],[192,107,101],[192,107,101],[191,106,100],[190,104,99],[189,104,99],[189,105,99],[189,103,98],[187,102,96],[187,101,96],[186,101,96],[186,102,97],[187,102,100],[188,102,99],[188,102,99],[188,102,98],[189,103,98],[188,102,97],[187,101,96],[186,100,95],[187,99,94],[187,100,94],[188,99,93],[189,99,93],[190,99,93],[189,98,92],[196,106,101],[213,129,122],[196,102,95],[196,101,95],[196,102,94],[195,100,94],[195,101,94],[196,102,95],[197,103,96],[188,104,97],[215,199,193],[174,201,172],[113,151,107],[112,151,105],[110,151,103],[110,151,104],[156,184,154],[112,155,108],[108,153,103],[108,153,103],[106,151,100],[107,152,102],[107,153,102],[108,154,103],[163,190,162],[172,208,168],[114,155,109],[113,154,108],[115,155,109],[113,155,107],[114,156,108],[132,167,128],[200,233,198],[124,168,119],[115,160,110],[113,157,108],[111,156,107],[113,157,108],[114,158,109],[113,157,108],[118,157,115],[171,192,172],[202,179,143],[214,167,70],[219,168,67],[219,166,66],[219,167,66],[219,167,66],[219,167,67],[216,167,68],[216,167,68],[213,167,69],[213,171,72],[211,171,73],[207,172,77],[205,179,100],[234,218,189],[229,207,167],[207,169,77],[208,169,73],[207,168,72],[205,166,72],[204,166,72],[205,168,75],[207,170,77],[206,169,79],[208,173,91],[219,185,108],[218,183,99],[206,169,79],[206,169,78],[206,168,76],[206,166,74],[206,166,75],[206,166,75],[205,165,74],[207,168,76],[208,169,79],[207,175,100],[229,212,178],[220,191,129],[212,173,83],[211,169,74],[215,169,73],[217,169,72],[218,169,71],[219,169,69],[221,169,70],[221,169,71],[220,169,69],[219,169,70],[219,169,70],[221,171,72],[222,172,73],[222,175,75],[226,197,128],[224,189,185],[219,182,177],[226,196,190],[234,212,206],[220,168,164],[192,105,102],[191,104,100],[187,102,96],[187,101,96],[185,100,94],[185,100,94],[184,98,93],[185,99,94],[184,99,93],[186,100,95],[189,103,98],[189,103,98],[189,103,98],[191,106,100],[190,105,99],[191,106,100],[192,106,101],[191,105,100],[191,105,100],[190,105,99],[189,105,99],[188,103,97],[187,103,97],[187,101,96],[187,102,96],[186,101,97],[185,102,98],[187,102,99],[198,116,112],[207,129,124],[204,121,117],[190,104,101],[187,102,97],[186,101,95],[186,99,94],[187,99,94],[188,98,93],[187,97,91],[188,98,93],[190,99,93],[194,108,102],[229,210,202],[228,168,160],[201,108,101],[197,103,96],[196,102,95],[195,101,94],[195,101,94],[196,102,95],[194,101,94],[194,126,117],[154,183,152],[114,152,108],[113,152,107],[112,151,106],[116,151,112],[120,162,116],[108,153,103],[106,151,102],[106,150,99],[107,152,102],[107,152,101],[113,153,108],[140,180,134],[115,154,110],[116,156,110],[115,155,108],[115,154,109],[169,199,168],[169,210,166],[115,159,110],[114,159,109],[113,158,108],[113,158,108],[113,158,108],[112,156,107],[114,157,109],[126,159,121],[216,193,161],[212,165,68],[218,168,67],[219,167,66],[219,167,66],[219,168,66],[218,167,67],[217,167,68],[216,168,68],[215,169,70],[216,173,74],[211,171,73],[205,173,91],[231,210,168],[211,182,118],[209,170,76],[208,169,73],[207,166,71],[205,167,71],[206,166,72],[207,168,74],[205,168,78],[211,179,108],[231,200,132],[207,169,84],[208,168,77],[207,167,75],[206,166,74],[206,166,75],[206,166,75],[208,168,77],[208,169,81],[217,191,137],[235,211,163],[221,183,108],[216,171,76],[217,169,73],[219,170,73],[219,169,70],[220,169,70],[219,168,69],[219,169,69],[218,168,69],[219,169,69],[221,171,72],[221,172,73],[224,179,84],[232,212,176],[197,132,129],[189,103,100],[189,102,98],[188,102,97],[188,102,97],[186,99,95],[185,99,94],[184,99,94],[185,99,94],[185,99,94],[185,100,94],[186,101,95],[187,101,96],[189,103,98],[191,105,100],[190,105,99],[192,107,101],[192,106,101],[192,107,101],[192,106,101],[190,105,100],[189,103,98],[187,102,97],[187,102,97],[187,102,96],[187,102,97],[187,102,98],[186,109,104],[214,146,141],[221,145,141],[191,106,102],[187,102,96],[188,101,96],[186,97,93],[188,98,93],[187,97,91],[190,100,94],[191,101,95],[186,106,100],[213,129,122],[196,103,96],[195,101,95],[194,101,94],[193,101,94],[194,104,98],[206,131,124],[225,196,189],[144,172,140],[114,150,110],[114,151,109],[112,151,107],[150,180,147],[131,168,128],[110,153,105],[108,153,104],[107,151,102],[107,152,103],[107,152,103],[154,182,154],[202,228,200],[131,169,126],[116,155,110],[116,155,110],[131,165,125],[208,231,210],[140,180,136],[113,157,109],[114,159,110],[113,157,108],[112,157,107],[112,155,107],[114,156,109],[117,156,113],[147,170,147],[222,176,82],[217,166,66],[219,167,66],[219,167,66],[219,168,67],[216,167,65],[218,168,68],[215,167,67],[217,171,72],[217,172,74],[211,171,80],[217,195,146],[216,198,168],[205,171,89],[212,172,77],[211,170,74],[207,168,72],[207,168,72],[207,168,73],[206,167,75],[209,177,102],[231,200,134],[208,168,79],[207,168,76],[206,166,74],[206,166,74],[208,168,77],[209,170,78],[212,175,90],[233,199,135],[221,176,86],[219,169,73],[219,169,71],[218,168,69],[219,168,69],[218,167,69],[219,168,70],[220,170,71],[221,171,72],[222,173,74],[234,198,128],[222,204,200],[185,114,111],[190,104,101],[188,101,99],[186,100,95],[184,99,94],[184,98,93],[184,99,93],[184,99,93],[184,98,93],[184,99,94],[190,105,100],[201,116,110],[205,120,114],[197,111,106],[190,104,99],[192,106,101],[191,105,100],[191,105,100],[191,106,100],[191,105,100],[190,104,99],[188,102,97],[188,102,97],[188,102,97],[188,102,97],[188,102,97],[187,110,105],[216,173,166],[218,141,136],[190,104,99],[191,101,97],[190,100,95],[189,99,93],[189,98,92],[191,101,95],[193,102,97],[179,106,100],[204,123,119],[188,103,99],[190,104,99],[201,118,113],[221,159,153],[166,193,164],[126,158,122],[124,157,120],[142,174,138],[155,189,153],[111,153,106],[109,153,104],[108,153,104],[108,152,103],[127,165,123],[196,222,195],[162,190,160],[155,185,153],[189,215,189],[197,227,197],[122,163,118],[113,158,110],[113,158,108],[112,156,108],[112,155,108],[116,156,111],[119,157,115],[130,158,129],[222,175,84],[218,166,65],[218,166,65],[219,168,67],[217,168,67],[218,168,69],[216,168,68],[219,171,72],[216,171,74],[218,185,110],[203,181,123],[208,172,82],[212,173,79],[212,172,77],[211,172,76],[210,171,75],[208,169,75],[207,172,91],[232,209,165],[221,188,112],[206,167,75],[207,168,74],[209,167,76],[208,168,77],[210,170,80],[226,197,134],[233,189,108],[219,173,79],[215,168,71],[216,167,71],[216,167,70],[217,168,71],[217,169,72],[221,172,76],[231,193,126],[228,202,198],[195,120,116],[186,104,101],[186,102,99],[183,100,96],[181,99,94],[182,100,96],[186,105,101],[197,118,113],[208,139,134],[219,163,158],[197,116,111],[190,106,100],[191,106,100],[192,107,101],[191,106,100],[190,104,99],[189,103,98],[189,103,98],[189,103,98],[188,102,97],[187,101,96],[188,108,103],[213,175,169],[233,200,194],[207,123,119],[191,100,96],[190,99,94],[189,98,94],[189,99,93],[191,101,96],[193,101,96],[179,111,104],[230,189,188],[216,164,164],[219,170,169],[228,201,197],[194,221,192],[121,160,117],[112,153,109],[114,154,110],[130,168,127],[193,214,190],[174,208,173],[119,161,114],[115,158,111],[113,156,109],[115,156,110],[117,156,114],[120,157,117],[128,159,126],[229,182,94],[215,167,72],[212,163,68],[212,163,67],[212,163,67],[212,166,69],[216,169,74],[223,181,94],[235,218,191],[214,189,125],[207,171,81],[211,173,79],[211,172,77],[211,172,76],[212,172,78],[213,175,85],[224,198,140],[220,187,110],[203,165,76],[203,165,75],[204,167,80],[217,185,119],[225,187,104],[209,169,82],[205,164,75],[208,166,75],[222,180,90],[234,203,147],[230,173,169],[200,132,129],[186,115,113],[186,115,111],[199,130,126],[212,155,152],[223,182,177],[233,205,201],[214,144,139],[191,108,102],[192,109,103],[193,108,102],[192,106,100],[190,105,99],[190,105,99],[190,104,99],[189,104,98],[187,102,96],[188,107,101],[209,168,162],[202,117,114],[190,100,96],[190,99,95],[190,99,95],[191,100,96],[192,101,97],[188,129,122],[174,204,174],[159,190,159],[172,201,171],[163,196,161],[121,161,117],[116,156,111],[116,155,112],[118,155,112],[120,156,116],[146,175,144],[222,189,123],[216,183,114],[216,183,113],[226,192,120],[216,186,113],[208,175,88],[208,173,84],[210,175,87],[218,184,100],[234,204,132],[228,208,166],[213,188,133],[217,194,146],[234,218,197],[225,208,183],[230,210,184],[228,210,206],[223,203,199],[223,203,198],[231,212,207],[225,163,158],[192,110,104],[194,110,105],[193,108,102],[192,107,99],[192,107,99],[191,106,98],[190,104,97],[189,103,98],[189,106,100],[211,163,156],[232,179,176],[206,125,123],[189,104,101],[187,101,98],[190,103,101],[200,121,117],[222,189,185],[172,202,172],[133,169,129],[125,162,121],[131,165,126],[155,186,153],[202,224,203],[228,175,170],[195,111,105],[195,109,104],[192,107,101],[192,107,99],[191,106,98],[191,106,98],[189,104,96],[192,110,105],[218,167,162],[222,165,163],[218,157,156],[226,167,166],[230,201,198],[207,233,207],[202,228,201],[204,230,204],[233,188,184],[197,114,108],[196,111,106],[194,109,103],[191,106,98],[191,106,99],[190,104,98],[198,120,114],[227,182,176],[179,192,199],[131,149,176],[103,124,155],[95,115,146],[94,113,145],[95,115,144],[100,118,147],[108,127,152],[149,166,178],[199,123,119],[189,108,102],[187,106,99],[187,105,100],[197,116,110],[213,154,148],[232,204,197],[144,162,182],[100,121,162],[88,111,157],[87,110,157],[86,111,157],[88,111,157],[89,113,158],[88,112,157],[88,111,155],[92,114,149],[121,138,157],[216,172,169],[194,139,136],[194,139,136],[207,161,157],[230,199,194],[143,162,187],[88,113,158],[85,111,162],[86,111,163],[86,112,162],[84,111,162],[87,112,163],[87,112,163],[87,113,162],[88,112,161],[86,110,159],[89,111,155],[114,129,155],[235,226,211],[235,226,212],[182,196,209],[88,113,160],[83,111,163],[86,112,165],[86,111,164],[85,111,164],[84,110,163],[86,111,164],[85,111,163],[87,113,164],[86,110,161],[87,111,160],[88,111,159],[91,112,153],[149,160,171],[233,224,201],[230,222,189],[226,218,180],[223,214,174],[221,210,172],[219,208,168],[219,209,167],[220,208,169],[220,209,171],[219,207,177],[221,209,181],[227,217,191],[235,225,206],[114,134,173],[83,109,162],[84,111,163],[85,112,165],[86,112,164],[84,111,164],[86,111,164],[84,111,164],[86,112,164],[87,112,164],[86,112,162],[86,110,159],[87,111,157],[91,112,155],[131,145,168],[221,212,195],[222,212,166],[223,218,120],[221,219,108],[219,217,105],[220,215,108],[219,215,109],[219,215,119],[221,215,129],[220,214,133],[219,212,133],[218,211,135],[218,212,137],[222,215,148],[231,223,170],[152,165,172],[119,132,141],[128,140,148],[154,164,172],[196,212,228],[86,112,163],[84,110,163],[83,109,161],[84,111,163],[83,110,163],[84,112,164],[86,112,165],[84,112,164],[85,111,164],[85,110,162],[84,110,161],[87,113,162],[89,113,159],[92,113,155],[163,177,194],[219,208,186],[218,210,134],[221,219,92],[222,221,88],[221,220,88],[221,220,89],[221,220,91],[224,220,112],[233,228,137],[227,221,131],[220,216,118],[219,216,112],[221,217,108],[224,219,118],[229,221,166],[235,226,193],[229,220,178],[221,214,171],[218,211,169],[217,210,172],[220,213,179],[226,219,196],[138,153,179],[85,102,140],[87,104,141],[90,107,140],[120,132,151],[145,167,201],[83,110,162],[84,110,163],[83,110,162],[84,111,164],[83,111,163],[85,113,165],[85,113,165],[85,112,164],[84,110,163],[85,110,162],[84,110,161],[86,111,161],[89,112,160],[111,132,169],[234,225,207],[223,214,141],[220,219,85],[222,221,83],[222,221,83],[223,221,84],[222,220,87],[229,223,120],[226,220,136],[220,218,109],[222,220,95],[222,220,93],[224,219,117],[230,221,177],[235,227,201],[232,225,164],[231,225,132],[227,222,119],[224,218,116],[222,216,116],[220,214,118],[219,213,124],[218,213,137],[221,216,171],[148,163,193],[83,103,148],[86,105,149],[83,102,147],[85,106,146],[111,126,152],[97,123,175],[83,110,162],[82,109,161],[84,111,163],[83,111,163],[84,112,164],[84,112,164],[84,112,164],[84,111,163],[84,110,163],[84,110,163],[85,111,163],[85,111,162],[97,119,161],[182,197,216],[219,216,98],[222,220,82],[222,221,82],[223,220,82],[222,221,85],[229,223,122],[235,224,167],[225,221,114],[222,221,90],[222,221,87],[223,222,89],[223,218,120],[232,224,190],[233,226,203],[232,224,157],[230,226,117],[228,226,93],[227,225,84],[226,224,83],[225,223,82],[224,221,82],[224,221,82],[222,221,83],[220,218,106],[221,216,175],[164,179,183],[171,188,194],[159,176,183],[155,172,178],[162,178,184],[173,188,192],[143,161,192],[80,102,149],[82,104,151],[81,103,150],[85,106,154],[87,107,150],[127,141,157],[78,106,158],[83,110,163],[81,109,161],[82,110,162],[83,110,164],[85,112,165],[84,112,164],[84,112,164],[83,111,163],[84,112,164],[84,112,164],[83,111,163],[84,110,159],[143,162,189],[229,221,132],[222,220,81],[223,220,82],[223,220,82],[223,221,84],[226,221,111],[232,224,135],[223,221,91],[222,221,85],[222,222,85],[224,223,92],[224,218,137],[229,223,177],[228,224,116],[229,227,89],[228,226,84],[227,225,82],[226,224,81],[226,224,81],[225,223,80],[224,222,79],[224,222,80],[223,221,89],[215,214,142],[173,195,200],[123,152,157],[96,130,136],[91,125,134],[94,128,135],[110,138,143],[141,162,165],[175,196,201],[134,168,175],[105,145,153],[94,135,143],[90,133,141],[89,131,140],[90,130,141],[92,130,140],[97,134,142],[110,141,149],[129,153,160],[149,169,172],[178,193,197],[117,136,173],[81,103,150],[81,102,151],[82,103,153],[82,104,152],[85,107,156],[88,107,142],[169,180,188],[184,203,234],[77,105,157],[81,109,161],[81,109,162],[82,110,162],[82,110,163],[83,111,165],[84,111,164],[83,111,164],[83,111,163],[84,112,164],[85,113,165],[83,111,163],[94,120,164],[206,218,230],[183,176,161],[202,195,181],[221,219,79],[223,220,82],[223,220,82],[224,221,84],[226,221,99],[232,220,150],[224,222,96],[223,222,86],[222,221,85],[223,222,86],[223,220,99],[227,221,160],[231,224,198],[225,221,144],[226,225,94],[228,226,85],[227,225,82],[226,224,81],[226,224,81],[226,224,81],[225,223,80],[224,222,79],[224,222,79],[223,222,85],[217,216,126],[230,225,207],[146,177,184],[90,139,149],[77,135,144],[75,134,143],[74,132,142],[73,131,140],[76,132,141],[87,135,144],[122,151,158],[185,206,212],[129,164,172],[98,143,152],[81,138,147],[76,137,146],[75,137,147],[73,135,145],[74,136,147],[77,137,148],[76,136,147],[75,135,145],[78,136,146],[81,137,147],[90,138,148],[102,142,151],[135,160,165],[188,198,216],[88,108,153],[83,104,152],[83,104,152],[83,104,154],[84,105,154],[87,108,157],[85,107,155],[105,119,142],[122,144,189],[78,106,158],[81,108,160],[81,109,162],[82,110,162],[83,110,164],[82,110,162],[83,111,164],[85,113,165],[84,111,164],[84,112,164],[86,113,166],[84,111,163],[127,148,183],[174,186,197],[167,178,189],[168,180,190],[179,189,199],[191,184,170],[190,183,166],[219,210,197],[221,218,80],[224,221,81],[224,222,84],[225,222,84],[225,222,89],[226,222,108],[233,222,151],[227,223,100],[222,221,85],[221,220,84],[222,221,85],[222,221,86],[222,219,112],[232,225,189],[226,221,173],[224,221,115],[224,224,87],[226,224,83],[225,223,81],[225,223,80],[226,224,81],[226,224,81],[225,223,80],[225,223,80],[224,222,79],[224,222,83],[219,216,118],[229,224,201],[127,149,154],[110,134,138],[106,130,135],[112,135,141],[134,154,159],[152,184,193],[82,140,150],[72,140,151],[72,141,152],[69,138,150],[67,136,149],[67,134,147],[67,135,147],[70,137,148],[79,138,147],[142,170,175],[166,193,197],[102,150,158],[78,138,148],[75,140,150],[75,140,150],[74,139,148],[73,139,148],[73,138,148],[71,136,146],[74,138,148],[73,138,148],[73,138,148],[75,139,149],[78,141,151],[80,141,151],[78,138,147],[83,138,147],[104,146,153],[159,180,185],[114,130,166],[83,104,151],[83,105,153],[83,105,152],[83,104,153],[82,104,153],[85,107,156],[86,108,158],[85,106,153],[127,141,162],[207,220,231],[84,109,158],[79,105,158],[79,107,159],[81,109,161],[81,109,161],[81,109,161],[83,111,163],[84,112,165],[85,113,165],[85,113,165],[85,113,166],[85,113,165],[85,111,161],[165,182,204],[192,204,216],[152,166,189],[115,132,158],[101,117,142],[97,115,142],[97,115,142],[98,115,141],[101,118,143],[115,129,150],[148,160,175],[188,180,164],[214,207,193],[207,199,180],[207,197,180],[222,220,81],[224,221,83],[225,222,84],[223,222,83],[223,223,85],[225,224,90],[229,222,109],[229,225,107],[223,222,86],[222,221,85],[222,221,85],[222,221,85],[221,221,92],[223,219,144],[232,225,201],[223,216,156],[223,220,110],[224,222,89],[225,222,83],[225,223,81],[225,223,80],[226,224,81],[225,223,80],[225,223,80],[224,222,79],[223,222,79],[223,222,81],[221,217,117],[231,225,198],[142,172,176],[93,136,142],[89,132,140],[87,131,138],[89,131,139],[104,141,147],[136,163,169],[177,205,211],[86,144,155],[73,140,154],[73,142,155],[72,141,155],[71,140,153],[67,138,150],[66,136,149],[67,136,149],[70,139,151],[71,139,150],[109,152,161],[151,181,186],[90,143,151],[73,139,149],[73,140,150],[73,140,149],[74,141,151],[73,140,150],[73,140,149],[72,139,148],[72,138,147],[72,138,148],[72,139,148],[73,138,148],[73,139,149],[76,142,151],[77,141,152],[76,140,149],[77,139,149],[78,137,146],[91,137,145],[146,173,180],[127,140,168],[89,107,150],[86,108,154],[82,105,152],[81,103,151],[82,104,151],[83,105,154],[84,106,154],[86,107,156],[84,107,155],[86,106,146],[131,144,158],[137,155,181],[78,103,154],[79,105,158],[80,107,159],[79,107,159],[80,108,160],[81,109,161],[84,112,164],[84,111,164],[83,112,164],[84,112,164],[85,113,165],[85,113,165],[85,112,161],[188,204,221],[147,164,187],[110,129,160],[97,117,157],[92,115,158],[90,114,156],[92,115,158],[92,115,157],[91,114,156],[91,114,156],[92,115,156],[97,117,156],[115,131,157],[167,176,185],[211,203,185],[204,197,183],[210,202,184],[230,220,201],[231,223,134],[223,221,82],[225,222,82],[225,222,83],[225,222,84],[225,223,84],[225,223,85],[225,221,94],[232,221,169],[232,226,121],[223,222,85],[223,223,86],[222,221,85],[222,221,85],[222,221,88],[222,219,106],[228,221,174],[224,217,185],[218,214,139],[221,219,104],[223,221,90],[226,223,84],[226,223,82],[226,223,81],[226,224,81],[227,223,81],[226,223,80],[225,223,80],[225,222,80],[224,222,81],[222,217,120],[233,227,197],[235,226,200],[233,223,185],[229,219,175],[228,217,170],[226,216,167],[225,215,165],[225,215,167],[225,216,174],[229,221,187],[235,227,205],[165,199,205],[85,139,149],[81,137,147],[79,136,145],[77,133,143],[78,133,142],[88,135,143],[128,157,162],[211,230,235],[111,161,170],[74,141,154],[73,141,155],[71,141,154],[70,141,154],[68,138,151],[67,138,150],[66,137,150],[67,137,151],[70,139,152],[70,139,151],[93,143,152],[204,220,228],[136,171,180],[81,143,154],[73,140,150],[74,141,152],[73,139,150],[72,138,148],[72,139,150],[72,139,149],[72,138,148],[72,138,149],[72,139,148],[72,139,148],[72,139,148],[73,140,149],[73,140,149],[76,142,152],[75,139,149],[74,139,148],[75,140,150],[75,139,149],[76,136,146],[89,137,146],[156,177,181],[138,149,171],[95,112,151],[90,111,154],[86,108,155],[83,105,153],[83,104,152],[83,105,152],[84,106,153],[85,107,154],[85,107,154],[85,107,155],[85,106,153],[85,105,145],[107,125,156],[151,165,182],[179,191,206],[185,197,212],[178,191,207],[134,152,175],[84,107,149],[78,104,156],[77,104,156],[81,107,160],[78,106,158],[80,108,160],[82,110,162],[81,109,161],[83,111,163],[84,112,164],[84,112,164],[85,113,165],[86,114,166],[86,113,162],[191,207,223],[168,184,201],[119,138,164],[94,116,158],[90,115,159],[92,117,161],[91,116,160],[91,115,160],[93,117,162],[93,116,161],[93,116,160],[94,116,161],[94,117,161],[95,118,161],[97,118,159],[106,123,154],[163,173,185],[235,224,192],[225,219,103],[225,222,83],[225,222,82],[225,222,82],[225,222,83],[224,222,84],[224,222,84],[223,220,91],[227,216,160],[223,223,86],[224,224,86],[222,221,85],[221,220,84],[222,222,86],[222,221,91],[222,217,129],[232,223,187],[227,220,195],[217,210,173],[217,212,139],[219,218,107],[223,221,92],[225,223,85],[225,223,83],[226,224,82],[226,224,81],[227,223,81],[225,223,80],[225,223,80],[225,223,81],[225,222,82],[224,219,122],[235,228,196],[235,226,161],[233,224,139],[229,223,116],[228,222,110],[228,222,111],[228,222,113],[228,221,115],[227,220,117],[225,219,120],[224,218,128],[225,220,143],[228,223,179],[170,207,214],[79,139,151],[74,137,149],[72,136,147],[72,135,147],[71,135,146],[73,133,144],[86,134,143],[134,161,167],[169,210,217],[79,143,154],[74,142,153],[73,141,155],[72,141,154],[71,141,154],[69,140,152],[68,138,151],[67,137,150],[68,137,150],[68,137,150],[69,138,150],[81,134,145],[177,199,206],[188,210,217],[119,160,170],[77,142,153],[73,141,152],[74,141,152],[72,140,151],[72,138,148],[73,139,149],[72,139,150],[72,139,149],[71,138,149],[72,139,150],[72,139,148],[72,139,148],[73,140,149],[74,141,150],[73,140,149],[74,141,150],[75,140,149],[74,141,150],[73,140,149],[74,139,148],[75,139,149],[75,138,148],[100,139,148],[180,193,212],[110,129,167],[90,111,156],[86,108,155],[86,108,155],[84,105,153],[84,106,153],[83,107,153],[84,108,154],[85,108,155],[85,108,155],[85,109,155],[83,106,153],[83,106,150],[87,107,142],[92,111,144],[94,113,145],[92,111,144],[83,106,148],[81,105,154],[79,105,154],[79,105,155],[81,107,158],[78,106,158],[82,109,161],[82,110,162],[81,109,161],[83,111,163],[85,113,165],[85,112,165],[85,113,165],[86,114,166],[85,111,161],[171,186,205],[206,218,228],[143,160,182],[97,120,160],[90,115,160],[90,115,162],[91,115,163],[90,115,161],[91,115,162],[92,116,163],[92,116,162],[92,116,163],[92,116,163],[94,117,162],[94,117,162],[95,117,162],[97,119,162],[98,119,159],[112,127,157],[233,222,196],[224,214,151],[225,221,91],[225,222,84],[224,222,82],[224,222,83],[225,222,83],[223,221,83],[222,222,83],[222,220,89],[223,214,148],[223,223,86],[223,223,86],[223,222,86],[222,221,85],[222,221,86],[222,221,88],[223,220,101],[220,213,142],[223,217,173],[229,222,186],[225,218,185],[218,210,177],[217,210,172],[223,217,162],[226,221,144],[226,223,116],[227,225,92],[228,225,86],[226,223,83],[226,224,82],[226,224,82],[225,223,81],[225,223,81],[227,225,84],[227,224,85],[226,221,118],[234,226,186],[232,224,146],[232,226,110],[232,225,101],[231,225,94],[230,225,92],[230,225,91],[231,226,93],[230,226,93],[230,226,94],[228,225,93],[227,224,94],[227,224,98],[225,221,123],[225,221,184],[158,199,207],[74,136,148],[72,137,149],[71,137,149],[70,136,148],[71,137,149],[70,136,148],[73,137,148],[90,138,148],[166,188,196],[132,182,191],[74,142,154],[73,141,153],[74,142,155],[73,141,155],[72,141,154],[70,140,152],[70,140,153],[68,138,151],[68,137,150],[68,137,150],[69,137,148],[72,135,147],[132,168,177],[197,220,228],[203,225,233],[164,193,200],[95,150,159],[74,139,150],[73,141,152],[74,141,153],[74,141,152],[71,139,150],[71,139,149],[73,140,150],[72,139,150],[72,139,149],[72,139,149],[73,139,150],[73,140,149],[74,141,150],[74,140,150],[74,141,150],[74,141,150],[74,141,150],[73,140,149],[73,140,149],[74,141,150],[72,139,148],[75,140,150],[75,139,149],[78,138,147],[120,156,162],[179,195,221],[103,124,167],[86,108,154],[87,108,156],[83,106,153],[83,107,154],[82,107,154],[83,107,154],[83,107,155],[84,108,155],[83,108,154],[84,108,156],[83,108,155],[81,106,153],[81,106,153],[81,105,154],[82,105,155],[83,107,156],[83,107,156],[79,106,154],[79,105,155],[80,105,156],[80,107,157],[80,108,160],[82,110,162],[82,110,160],[83,111,163],[82,111,163],[83,111,163],[85,113,164],[87,114,166],[85,112,162],[129,147,172],[202,215,226],[131,149,173],[90,114,157],[89,115,162],[90,117,165],[89,115,163],[90,116,164],[88,114,161],[90,116,162],[91,115,161],[91,115,161],[91,115,162],[92,116,163],[92,116,163],[94,117,162],[95,117,162],[96,118,162],[99,120,163],[102,121,160],[131,142,158],[233,226,203],[233,225,197],[231,222,188],[225,214,175],[222,213,146],[223,216,116],[225,221,86],[225,222,84],[225,222,83],[223,220,82],[224,221,83],[222,221,83],[221,221,82],[222,221,87],[222,215,138],[224,224,87],[224,223,87],[223,223,86],[222,221,85],[222,221,86],[222,221,87],[222,221,95],[218,215,123],[214,208,151],[213,206,165],[214,207,172],[219,211,177],[226,219,184],[235,228,188],[232,229,117],[228,226,91],[227,224,85],[226,223,83],[226,224,84],[226,223,83],[227,224,85],[230,227,89],[230,227,92],[229,225,116],[232,225,168],[232,227,131],[232,227,106],[231,226,92],[232,227,89],[231,226,88],[230,225,87],[231,226,88],[231,226,88],[231,226,88],[230,226,88],[229,225,87],[228,225,87],[228,225,90],[227,225,92],[221,220,129],[124,174,184],[71,136,148],[71,138,151],[70,137,150],[67,136,149],[68,136,150],[69,136,148],[71,137,149],[74,136,149],[122,159,168],[209,226,233],[109,165,176],[71,139,152],[72,141,154],[74,142,156],[72,141,154],[72,141,153],[70,141,153],[71,140,153],[70,140,152],[68,137,149],[68,137,149],[68,137,149],[68,137,149],[81,139,151],[119,163,174],[133,174,185],[117,164,174],[80,141,152],[71,138,149],[72,139,151],[74,141,152],[73,140,151],[73,139,150],[72,138,150],[70,137,149],[72,138,149],[72,139,150],[72,138,150],[73,139,150],[74,141,150],[74,141,150],[74,141,151],[73,140,150],[74,141,150],[74,140,149],[74,140,149],[74,140,150],[74,140,149],[73,140,149],[74,141,150],[75,139,149],[76,139,150],[77,142,152],[84,140,148],[184,201,206],[183,193,205],[141,154,171],[115,128,145],[110,122,140],[115,128,143],[136,147,160],[173,190,219],[98,119,165],[85,108,155],[85,108,155],[84,108,155],[83,107,154],[82,106,154],[83,107,155],[84,108,155],[84,108,157],[84,108,157],[84,108,157],[83,107,155],[82,106,155],[83,107,156],[83,107,156],[82,106,155],[83,108,158],[81,107,155],[78,103,154],[81,107,157],[81,107,157],[79,106,159],[81,109,160],[81,109,161],[81,109,161],[80,108,160],[84,111,162],[85,113,163],[86,113,164],[86,113,163],[96,117,155],[166,178,196],[183,196,209],[126,145,174],[89,115,160],[87,113,161],[89,115,163],[90,116,165],[89,115,163],[89,115,164],[89,115,163],[89,115,163],[89,115,162],[90,115,161],[93,117,164],[93,117,164],[90,114,161],[94,116,161],[95,118,162],[94,117,161],[99,120,163],[101,121,162],[115,129,155],[235,228,211],[231,223,201],[226,219,167],[219,212,144],[216,209,140],[217,210,135],[220,212,130],[223,216,110],[224,219,93],[225,222,86],[225,223,85],[224,221,84],[223,220,83],[223,220,83],[222,221,83],[222,221,83],[222,221,86],[223,215,128],[235,224,200],[228,227,96],[226,226,89],[224,224,87],[222,221,85],[221,221,86],[221,221,88],[221,220,93],[219,217,111],[216,212,138],[215,210,162],[219,212,181],[229,222,192],[229,226,104],[227,225,88],[226,224,86],[226,223,85],[226,224,86],[229,226,92],[231,227,100],[232,228,108],[231,228,128],[233,225,180],[235,225,201],[231,221,193],[229,218,180],[227,221,149],[230,225,122],[231,227,100],[231,227,89],[230,225,86],[231,226,87],[230,225,86],[230,225,85],[230,226,86],[230,225,86],[230,226,86],[230,225,86],[230,225,86],[228,225,87],[227,224,87],[226,224,89],[221,221,110],[179,195,199],[171,188,191],[160,180,184],[152,172,178],[145,164,169],[135,152,156],[185,215,222],[86,145,157],[71,137,150],[71,138,152],[70,138,151],[69,138,151],[70,139,152],[70,137,150],[71,137,149],[72,137,149],[95,141,152],[195,217,225],[91,153,164],[68,137,150],[72,141,155],[71,142,155],[71,142,155],[70,140,153],[70,140,153],[70,141,153],[68,139,151],[67,138,150],[68,138,151],[70,139,152],[69,138,151],[69,137,148],[70,136,147],[71,137,148],[72,137,148],[71,140,151],[72,140,151],[73,140,151],[75,141,153],[74,142,153],[73,140,151],[72,139,151],[73,141,151],[72,139,150],[73,139,151],[74,140,152],[73,140,151],[75,141,153],[76,142,153],[75,141,151],[75,141,151],[78,143,153],[79,144,154],[78,144,153],[76,142,152],[75,141,150],[74,139,149],[76,140,150],[76,140,150],[77,141,151],[78,143,153],[80,141,149],[134,164,169],[173,184,199],[107,123,153],[92,110,149],[88,107,145],[87,106,144],[86,105,143],[90,108,144],[105,119,148],[154,165,178],[156,175,212],[87,110,157],[84,108,155],[86,109,156],[83,107,154],[84,108,156],[84,108,156],[83,107,155],[84,108,157],[84,108,156],[84,108,156],[82,106,155],[84,108,156],[81,105,154],[80,104,153],[81,105,154],[82,107,157],[81,107,156],[78,104,155],[82,108,158],[79,105,156],[79,106,157],[81,108,158],[81,108,159],[80,107,158],[80,107,158],[82,108,159],[84,110,161],[85,112,162],[85,111,161],[89,113,160],[101,119,153],[134,149,168],[157,171,188],[167,180,197],[170,182,199],[161,174,192],[135,153,179],[103,126,164],[89,114,160],[90,116,163],[89,115,164],[89,115,164],[90,116,165],[91,118,166],[90,117,165],[90,116,164],[90,116,164],[89,115,162],[89,115,161],[91,115,162],[91,116,162],[88,113,159],[92,116,160],[96,118,163],[96,118,163],[99,120,162],[100,120,161],[119,133,164],[234,229,211],[233,227,202],[231,223,191],[230,222,174],[230,221,163],[226,219,153],[226,219,123],[224,218,106],[223,217,105],[223,218,100],[224,219,94],[225,221,88],[224,220,87],[225,221,87],[225,222,86],[224,221,85],[222,219,84],[222,221,85],[224,221,85],[224,221,87],[223,221,90],[224,217,123],[233,223,194],[233,229,116],[227,226,92],[225,224,89],[223,222,88],[223,222,88],[223,222,90],[221,221,95],[219,218,112],[218,215,141],[224,218,172],[230,223,197],[231,227,134],[227,225,94],[227,224,89],[228,225,91],[228,225,96],[230,227,116],[232,226,143],[234,227,162],[234,224,199],[222,213,181],[219,211,153],[223,218,117],[228,224,90],[230,225,86],[230,225,85],[229,224,85],[229,224,85],[230,225,85],[230,225,84],[230,226,84],[231,226,85],[231,226,85],[230,225,85],[229,224,85],[228,225,86],[228,225,87],[227,225,88],[223,224,99],[218,216,194],[185,205,209],[136,168,173],[114,151,159],[103,143,151],[96,137,145],[91,132,141],[89,129,137],[86,127,136],[86,126,136],[88,128,137],[91,127,136],[129,154,161],[197,216,220],[112,158,168],[71,137,150],[70,139,152],[69,138,151],[69,138,151],[70,139,152],[69,138,151],[70,139,151],[72,138,151],[71,137,149],[83,136,147],[181,208,217],[79,144,156],[70,139,152],[72,142,155],[71,142,155],[71,142,155],[71,142,155],[71,142,154],[70,141,154],[68,139,151],[68,139,151],[69,139,152],[68,137,151],[70,139,151],[68,137,148],[69,138,150],[70,139,150],[71,139,151],[71,140,151],[71,140,151],[73,141,152],[76,143,154],[75,143,154],[73,141,152],[74,141,152],[73,141,152],[73,140,151],[73,140,151],[74,141,151],[73,140,150],[76,142,153],[79,143,154],[89,151,161],[115,171,180],[137,191,200],[144,197,206],[142,197,207],[134,188,198],[117,174,184],[97,156,166],[82,145,154],[76,140,150],[76,141,150],[77,142,151],[77,140,147],[98,140,146],[203,213,225],[109,126,160],[89,109,152],[89,109,152],[88,108,151],[87,107,149],[87,107,151],[88,108,153],[89,108,151],[94,112,146],[140,153,174],[107,128,173],[83,107,154],[85,107,155],[84,108,155],[85,109,157],[84,108,154],[82,105,154],[82,106,153],[82,107,153],[83,107,153],[81,106,152],[79,104,150],[78,103,149],[79,103,150],[80,104,151],[81,106,154],[81,105,153],[78,103,151],[80,105,153],[81,106,155],[83,108,156],[83,108,156],[84,109,157],[90,114,161],[94,118,165],[91,115,162],[90,114,162],[89,114,161],[90,115,161],[91,115,161],[91,113,157],[91,112,153],[91,113,153],[92,113,155],[92,114,155],[89,113,155],[86,112,157],[87,113,158],[87,114,161],[90,116,164],[89,115,164],[89,115,163],[89,115,163],[91,117,165],[90,116,164],[90,116,165],[90,116,164],[90,117,164],[90,117,162],[91,116,163],[92,116,163],[92,116,162],[92,117,161],[97,119,164],[97,119,164],[98,120,163],[101,121,162],[154,166,187],[231,228,202],[229,224,184],[226,221,166],[226,221,150],[226,221,138],[227,220,126],[226,219,114],[224,219,108],[225,221,91],[224,221,87],[225,221,88],[224,220,88],[225,221,88],[224,220,87],[225,221,88],[225,221,88],[225,221,88],[224,221,86],[224,221,85],[226,223,88],[227,224,91],[228,224,101],[229,225,116],[232,224,147],[234,224,192],[235,229,147],[226,225,101],[223,222,95],[222,221,93],[224,222,94],[224,223,98],[226,224,109],[226,222,135],[228,222,173],[232,227,162],[226,223,112],[224,221,98],[225,222,101],[228,223,124],[231,225,160],[234,226,185],[230,222,192],[221,215,145],[225,220,104],[229,224,87],[229,224,84],[229,224,84],[229,224,83],[230,225,83],[231,225,83],[232,225,84],[232,226,84],[232,226,85],[232,226,84],[231,227,84],[230,225,86],[230,225,85],[229,227,88],[228,226,89],[226,225,95],[222,218,183],[162,190,195],[103,145,155],[86,138,148],[83,137,147],[79,136,146],[78,134,146],[77,135,147],[75,133,144],[74,132,143],[75,132,143],[78,134,145],[79,132,143],[94,135,144],[158,178,183],[179,203,208],[107,155,165],[74,135,149],[72,139,153],[71,139,152],[69,137,150],[70,138,151],[71,140,153],[71,139,152],[71,138,151],[71,137,150],[71,137,149],[77,135,147],[163,196,206],[146,193,204],[74,140,153],[73,141,155],[72,143,156],[71,142,154],[70,140,153],[70,141,153],[71,142,155],[70,141,154],[68,139,152],[68,138,151],[68,136,150],[68,137,150],[70,139,151],[69,138,149],[69,138,150],[70,139,150],[71,140,151],[73,142,152],[72,140,152],[74,142,154],[76,142,154],[75,143,154],[74,142,154],[75,143,154],[75,141,153],[74,140,152],[73,139,151],[76,142,152],[93,154,165],[110,168,177],[126,178,189],[158,201,209],[190,221,230],[170,214,222],[132,184,194],[95,155,165],[77,141,149],[76,141,149],[76,139,147],[82,134,141],[181,199,203],[153,167,188],[91,111,152],[90,111,154],[88,109,152],[89,109,152],[86,106,152],[87,107,152],[87,107,153],[88,108,154],[88,108,152],[92,110,147],[140,154,175],[130,151,190],[83,106,153],[86,107,155],[86,108,155],[85,109,156],[89,111,157],[95,118,162],[97,119,163],[100,121,162],[101,123,164],[104,126,166],[108,129,168],[110,132,170],[113,134,173],[115,137,175],[119,141,180],[125,146,183],[129,151,187],[135,156,192],[142,163,200],[146,167,205],[147,169,205],[152,175,212],[167,187,223],[176,195,231],[175,195,227],[171,192,223],[170,191,221],[166,187,218],[157,178,213],[112,134,176],[92,114,158],[91,114,158],[87,111,156],[88,112,158],[88,113,159],[88,115,162],[89,115,161],[89,115,163],[89,115,164],[87,113,162],[88,114,163],[89,115,163],[88,114,162],[89,115,164],[89,116,164],[90,117,164],[90,116,163],[90,117,163],[88,115,160],[91,115,161],[93,117,164],[94,119,163],[97,120,165],[99,122,166],[104,126,167],[135,152,182],[230,226,200],[227,224,158],[226,221,135],[225,220,118],[224,221,101],[225,222,88],[226,222,85],[225,222,84],[225,222,84],[225,222,84],[225,222,85],[224,221,85],[224,221,85],[225,222,86],[223,220,85],[225,222,86],[225,222,86],[224,221,86],[224,221,85],[224,221,86],[227,224,91],[229,225,108],[230,225,138],[231,224,167],[234,225,181],[232,223,195],[229,226,136],[223,220,119],[220,218,113],[222,219,114],[226,224,120],[232,229,138],[234,227,211],[232,225,209],[233,227,191],[227,222,156],[222,219,139],[221,217,137],[228,222,162],[234,227,195],[235,228,204],[228,222,162],[226,222,105],[230,225,88],[230,224,84],[229,224,83],[230,225,83],[230,224,82],[230,224,83],[231,225,84],[231,226,85],[232,225,83],[231,227,85],[230,226,84],[231,226,84],[230,226,87],[229,227,88],[229,227,91],[228,227,105],[227,224,177],[172,195,200],[98,146,154],[84,142,154],[83,142,154],[80,140,152],[77,139,150],[75,138,151],[75,138,151],[74,137,150],[71,135,148],[71,135,149],[72,135,148],[72,133,146],[75,131,142],[95,137,146],[137,166,173],[175,199,205],[185,207,213],[182,204,210],[169,195,201],[136,170,177],[92,141,152],[72,135,148],[73,139,153],[73,139,153],[71,139,152],[68,136,150],[70,137,151],[71,139,153],[70,139,152],[71,137,151],[71,137,150],[72,138,150],[74,137,149],[117,161,172],[150,186,195],[153,188,199],[133,177,189],[87,148,160],[76,142,154],[74,142,155],[74,142,156],[73,142,156],[71,140,153],[70,141,153],[71,141,154],[70,141,154],[70,141,153],[69,138,151],[68,136,150],[69,137,150],[70,139,152],[70,139,150],[69,138,149],[71,140,150],[71,140,151],[74,143,154],[74,142,154],[75,142,154],[76,142,154],[76,143,155],[76,142,154],[77,143,155],[76,142,154],[74,140,152],[87,147,160],[132,181,190],[175,210,217],[191,222,229],[199,226,233],[205,224,232],[203,222,230],[205,224,232],[156,205,215],[102,161,169],[75,139,146],[78,140,148],[77,136,143],[143,169,173],[118,134,168],[90,110,153],[90,111,154],[89,108,152],[89,109,152],[87,107,152],[87,107,152],[87,107,152],[89,109,155],[89,109,155],[91,111,156],[96,114,149],[153,166,183],[127,148,187],[84,106,152],[85,107,154],[85,107,154],[89,112,157],[148,166,200],[182,198,222],[188,204,226],[191,206,227],[190,204,226],[191,206,227],[194,208,229],[197,212,231],[201,217,235],[172,189,217],[93,115,157],[93,116,158],[89,114,158],[90,115,159],[89,116,161],[90,117,162],[89,116,163],[89,115,163],[89,115,164],[89,115,164],[89,115,164],[89,116,164],[90,117,165],[90,117,165],[90,117,164],[90,117,163],[90,117,163],[89,115,163],[90,115,161],[92,116,162],[92,116,163],[96,120,164],[106,128,172],[126,146,186],[161,176,206],[206,217,232],[224,221,169],[225,223,117],[225,223,92],[225,221,85],[226,223,84],[227,223,84],[227,222,83],[226,222,84],[225,222,83],[225,222,84],[225,222,84],[224,221,84],[223,220,84],[225,222,86],[225,221,88],[224,219,93],[224,219,96],[223,220,97],[224,220,98],[225,221,100],[227,223,112],[229,223,151],[228,222,182],[228,220,202],[231,223,206],[232,224,207],[234,225,208],[235,227,209],[234,228,180],[230,226,174],[230,225,172],[233,228,179],[233,228,198],[229,225,189],[226,221,184],[229,223,196],[235,227,188],[229,223,122],[231,224,89],[230,224,83],[230,223,82],[231,224,83],[231,225,83],[231,225,84],[231,225,84],[231,226,85],[232,226,84],[232,226,84],[233,227,86],[232,227,86],[232,227,87],[231,228,91],[231,228,98],[232,229,128],[233,230,190],[109,154,162],[86,145,155],[83,144,156],[81,143,156],[79,140,153],[75,139,151],[75,140,152],[76,140,152],[74,138,151],[70,136,150],[70,136,150],[70,136,150],[70,135,149],[71,135,149],[72,132,145],[78,133,144],[89,139,150],[91,141,151],[89,138,148],[84,134,146],[76,132,144],[71,135,148],[72,138,152],[72,139,152],[72,139,153],[71,139,152],[69,138,151],[71,138,152],[70,139,152],[70,137,151],[71,137,151],[71,137,149],[72,138,150],[73,138,150],[75,137,148],[75,136,148],[76,137,150],[76,140,151],[76,142,153],[76,142,154],[75,142,155],[74,142,156],[75,143,157],[73,141,154],[73,142,155],[71,141,154],[70,140,152],[70,140,153],[69,138,151],[68,138,151],[69,137,150],[70,139,151],[69,138,149],[69,138,149],[70,139,150],[70,139,150],[74,142,153],[73,142,152],[74,141,152],[74,141,152],[75,141,153],[76,142,154],[77,143,155],[77,142,152],[100,155,166],[160,196,204],[196,221,228],[208,228,234],[205,220,228],[207,223,231],[138,187,196],[74,136,145],[74,137,143],[78,137,144],[116,143,151],[114,131,167],[88,108,151],[88,108,152],[88,108,152],[86,107,150],[87,107,152],[87,107,153],[88,108,153],[88,108,154],[89,109,155],[91,111,156],[93,113,158],[99,117,154],[158,173,190],[206,220,234],[102,124,166],[85,108,153],[87,109,154],[86,107,153],[146,162,189],[123,142,176],[92,115,158],[91,115,159],[89,114,160],[88,115,160],[88,115,160],[89,115,162],[88,114,162],[88,114,162],[90,116,165],[89,115,164],[89,115,163],[90,117,165],[89,116,164],[90,117,165],[91,118,164],[90,117,163],[90,116,161],[95,120,165],[108,132,176],[128,151,190],[149,169,201],[175,191,217],[202,216,235],[225,223,196],[221,220,133],[224,223,93],[224,222,84],[224,221,83],[225,221,83],[226,222,83],[226,222,82],[227,223,83],[226,223,83],[226,222,83],[225,222,84],[225,222,85],[226,223,87],[226,221,96],[227,221,107],[227,221,129],[229,222,138],[230,225,141],[232,225,142],[231,225,147],[230,225,157],[229,223,194],[231,223,92],[230,224,83],[230,224,82],[230,225,83],[230,224,82],[231,224,83],[231,225,84],[231,225,84],[233,226,85],[233,226,86],[234,227,88],[233,228,90],[233,229,94],[234,230,107],[235,231,126],[149,181,187],[89,145,155],[86,145,155],[83,144,157],[79,143,156],[77,141,154],[75,141,154],[76,141,155],[73,139,153],[72,139,153],[69,138,151],[70,138,151],[69,137,150],[68,136,150],[69,137,151],[68,135,150],[69,135,150],[68,134,148],[67,133,148],[65,132,146],[67,134,148],[69,135,150],[70,136,151],[70,137,151],[70,139,152],[71,140,153],[71,139,152],[70,139,152],[72,140,153],[70,139,152],[70,139,152],[70,136,150],[71,137,149],[71,137,149],[71,137,149],[73,139,150],[73,137,150],[73,139,150],[74,141,152],[76,142,154],[74,141,152],[76,142,155],[74,142,156],[75,143,156],[74,142,156],[73,142,156],[71,140,153],[70,139,152],[70,139,152],[71,139,152],[69,138,151],[70,139,152],[70,139,151],[69,138,149],[70,139,150],[70,139,150],[71,139,150],[73,140,151],[73,139,151],[74,141,152],[73,140,151],[75,141,152],[76,142,154],[78,142,153],[110,161,171],[176,207,214],[205,223,229],[120,170,178],[73,135,144],[74,137,143],[80,138,145],[109,137,143],[135,150,183],[89,109,152],[88,108,152],[89,109,153],[88,108,152],[87,108,153],[88,109,154],[88,108,153],[88,108,153],[88,109,154],[90,110,156],[92,112,157],[90,110,154],[98,116,149],[139,153,175],[184,196,211],[209,220,233],[209,221,234],[186,198,213],[126,144,176],[88,109,154],[87,108,154],[87,109,154],[106,123,158],[209,219,232],[184,200,223],[96,117,160],[89,113,158],[89,114,160],[87,114,160],[87,114,160],[88,114,162],[88,114,162],[88,114,162],[88,114,163],[86,113,161],[86,113,161],[87,113,161],[89,115,163],[90,116,164],[90,116,163],[100,125,170],[124,148,187],[155,176,208],[184,202,229],[216,216,171],[221,220,108],[225,223,86],[223,221,81],[223,220,81],[224,220,81],[225,221,81],[226,222,82],[227,222,82],[226,222,82],[225,222,82],[226,222,83],[225,222,83],[226,223,91],[227,220,126],[231,223,148],[233,225,174],[235,229,187],[234,228,208],[233,225,104],[230,224,84],[230,223,83],[230,224,83],[231,224,83],[232,225,85],[231,225,85],[234,226,86],[234,227,89],[235,227,92],[235,228,97],[234,229,104],[107,151,158],[87,144,154],[83,144,155],[80,142,155],[79,143,156],[78,142,156],[75,141,156],[74,141,155],[73,141,155],[70,139,152],[70,138,151],[68,137,150],[68,136,150],[68,137,150],[67,136,151],[67,136,152],[69,137,152],[68,137,151],[68,137,152],[65,135,150],[68,136,152],[68,137,151],[69,137,153],[70,138,154],[71,139,154],[71,139,152],[69,138,151],[69,138,151],[70,139,152],[70,139,152],[70,139,152],[69,136,150],[70,136,148],[69,135,147],[71,137,149],[72,138,150],[72,138,149],[74,140,152],[75,141,153],[74,141,152],[75,141,153],[76,142,155],[73,142,153],[73,142,153],[73,141,156],[71,140,153],[71,139,152],[71,140,152],[70,139,152],[70,139,151],[69,138,150],[69,138,151],[70,139,151],[70,139,150],[70,139,150],[71,140,150],[73,140,151],[72,139,151],[71,139,150],[73,140,151],[73,140,151],[74,140,151],[80,144,154],[116,169,179],[187,217,225],[175,211,221],[86,145,153],[74,136,144],[77,139,146],[82,138,144],[122,150,156],[176,192,215],[101,122,162],[88,108,152],[88,108,152],[88,108,151],[88,109,153],[88,109,154],[88,109,154],[87,108,154],[88,108,154],[89,109,155],[90,110,156],[90,110,155],[90,110,153],[91,109,147],[101,118,153],[116,132,164],[123,139,171],[118,134,165],[101,117,149],[89,108,151],[90,110,155],[88,108,153],[87,107,149],[176,188,205],[135,155,191],[88,112,157],[88,113,159],[87,114,159],[88,114,161],[87,114,162],[88,114,162],[89,115,163],[88,114,162],[87,114,162],[86,114,161],[87,114,162],[89,115,163],[90,115,162],[114,138,180],[168,188,218],[212,213,153],[221,221,95],[224,222,83],[223,220,80],[222,220,80],[223,220,80],[225,222,80],[226,222,80],[226,222,81],[226,222,80],[224,222,80],[225,222,81],[224,221,82],[226,223,97],[229,222,160],[234,224,194],[230,224,85],[230,223,85],[230,223,85],[231,225,87],[232,225,87],[233,226,89],[169,200,206],[90,141,151],[85,142,154],[81,142,154],[80,142,155],[78,143,156],[77,143,157],[76,142,156],[75,142,156],[74,142,156],[72,140,153],[71,140,153],[69,138,151],[69,138,152],[68,137,151],[67,136,151],[68,138,153],[68,136,152],[67,137,152],[66,137,152],[65,136,151],[66,136,151],[66,137,152],[67,137,152],[68,139,153],[71,141,156],[71,140,155],[69,139,154],[69,139,154],[70,140,153],[70,139,152],[70,139,152],[69,137,150],[69,135,148],[69,135,148],[71,138,149],[72,138,150],[73,140,151],[75,141,153],[74,141,152],[75,141,153],[76,142,154],[77,143,155],[75,143,155],[73,141,153],[74,142,156],[73,141,154],[73,141,154],[72,141,151],[70,139,151],[70,139,150],[70,139,151],[69,138,150],[70,139,151],[71,140,151],[72,139,151],[72,139,150],[73,139,151],[71,137,149],[70,137,148],[74,138,150],[82,144,154],[99,156,166],[132,183,191],[190,221,229],[212,228,235],[193,220,229],[110,161,170],[75,138,146],[74,138,145],[76,140,146],[83,138,144],[138,165,170],[148,167,201],[98,118,160],[86,107,152],[87,107,153],[85,107,152],[86,107,152],[88,108,153],[87,109,154],[88,108,154],[88,110,154],[90,110,155],[91,111,157],[90,110,156],[90,110,154],[87,107,149],[86,106,147],[86,105,147],[86,106,148],[87,107,150],[88,108,152],[91,112,155],[88,109,152],[121,138,169],[193,209,232],[96,121,165],[88,114,160],[88,115,161],[89,115,162],[88,114,162],[88,114,162],[89,115,163],[88,114,162],[88,114,162],[88,114,162],[89,116,164],[88,115,163],[98,122,167],[184,204,232],[213,216,145],[220,221,92],[224,223,83],[222,220,80],[223,220,80],[223,221,80],[224,221,79],[225,221,79],[225,221,79],[225,221,79],[224,222,79],[225,222,79],[224,221,81],[227,223,111],[233,225,193],[230,224,87],[229,223,87],[230,223,87],[230,225,88],[233,226,92],[139,179,186],[88,141,151],[84,142,154],[81,141,154],[79,142,155],[77,143,156],[76,142,156],[75,141,156],[74,141,155],[73,141,155],[70,139,152],[69,138,151],[68,136,151],[69,137,153],[67,137,152],[66,137,152],[67,137,152],[67,138,153],[68,138,153],[66,137,152],[67,137,152],[66,137,152],[67,138,153],[66,137,152],[68,138,153],[70,141,156],[71,141,156],[70,140,155],[70,140,155],[70,140,153],[70,139,152],[69,138,151],[69,137,150],[69,135,148],[69,135,147],[69,136,148],[72,138,150],[73,140,151],[74,141,152],[74,140,151],[73,140,151],[77,143,155],[78,144,156],[77,143,155],[75,142,154],[74,143,153],[72,141,154],[72,140,154],[71,140,153],[70,139,151],[69,138,150],[70,137,149],[69,137,149],[70,138,150],[70,138,150],[72,138,150],[72,137,149],[74,137,149],[80,142,152],[91,150,162],[111,164,175],[141,188,197],[174,208,214],[201,221,226],[195,221,230],[128,171,180],[80,141,149],[74,139,146],[76,140,148],[77,141,148],[84,138,145],[158,185,191],[206,219,235],[155,171,204],[107,127,169],[86,107,151],[85,106,150],[85,108,152],[89,110,156],[90,111,157],[90,110,156],[89,109,155],[89,109,155],[89,109,155],[90,110,155],[90,110,156],[87,107,151],[87,107,150],[88,108,152],[88,108,152],[88,108,151],[89,109,152],[91,112,155],[94,113,152],[194,205,220],[150,171,205],[87,112,158],[86,113,159],[88,115,162],[88,114,161],[88,114,162],[90,115,164],[89,115,163],[88,114,162],[88,114,162],[89,115,164],[89,115,163],[106,131,171],[218,220,167],[220,220,97],[224,222,83],[223,221,80],[223,221,80],[222,220,79],[224,221,78],[225,221,79],[226,222,80],[225,221,79],[224,221,79],[225,222,79],[224,222,81],[230,224,135],[231,223,91],[230,222,88],[230,223,89],[231,225,94],[117,160,168],[87,141,151],[83,142,154],[82,143,155],[80,143,156],[78,144,158],[77,143,157],[76,143,157],[73,141,155],[71,140,153],[71,139,152],[69,138,154],[68,138,153],[68,138,153],[68,138,153],[68,138,153],[68,138,153],[68,138,153],[67,138,153],[67,137,152],[68,138,153],[68,138,153],[69,139,154],[67,137,152],[69,139,154],[70,140,155],[70,140,155],[69,139,154],[69,139,154],[70,139,153],[69,138,151],[69,138,151],[70,136,150],[69,135,148],[70,136,148],[69,135,147],[70,135,147],[71,137,148],[73,139,150],[72,138,150],[73,139,151],[75,141,153],[76,142,154],[76,142,154],[75,142,153],[73,141,153],[74,141,154],[73,140,154],[72,139,153],[71,138,151],[69,137,149],[70,137,149],[69,136,148],[69,135,147],[74,137,149],[83,144,156],[99,156,166],[121,173,183],[143,187,196],[165,206,213],[189,217,224],[194,219,226],[128,171,179],[82,143,151],[77,142,150],[76,141,149],[79,141,150],[79,140,149],[87,140,147],[190,212,218],[183,198,223],[141,157,191],[109,129,168],[93,115,157],[89,111,155],[90,111,155],[91,111,157],[89,109,155],[90,111,156],[89,109,153],[89,109,154],[88,108,154],[87,107,150],[86,106,149],[89,109,152],[88,108,152],[87,107,151],[90,111,154],[92,112,155],[148,162,188],[117,140,179],[87,112,157],[87,113,158],[87,113,160],[88,115,161],[90,117,163],[90,116,164],[90,116,163],[90,117,164],[92,118,166],[91,117,164],[102,126,166],[227,227,198],[225,224,123],[224,223,92],[224,221,82],[224,221,80],[224,221,80],[224,222,79],[226,222,80],[225,221,79],[225,221,79],[224,222,79],[224,221,79],[222,220,80],[234,228,145],[231,225,94],[229,223,88],[230,223,90],[113,159,167],[85,141,152],[84,143,155],[81,143,156],[79,143,157],[78,144,158],[78,144,158],[76,143,157],[73,141,155],[71,140,153],[71,139,152],[68,137,153],[68,138,153],[68,138,153],[68,138,153],[68,138,153],[68,138,153],[68,138,153],[66,136,152],[68,138,153],[69,139,154],[68,138,153],[69,139,154],[68,138,153],[70,140,155],[70,141,156],[70,141,156],[70,141,156],[70,140,155],[70,138,153],[69,138,151],[70,137,151],[70,136,149],[70,136,148],[71,135,147],[85,147,158],[106,165,175],[108,166,176],[97,157,169],[85,148,159],[80,144,154],[79,142,154],[81,145,156],[79,144,155],[78,142,153],[74,140,152],[75,140,151],[72,138,150],[72,137,149],[71,136,148],[69,134,145],[73,136,147],[90,150,161],[110,167,177],[136,184,194],[159,202,211],[180,213,221],[198,221,227],[204,222,227],[211,229,235],[185,211,218],[121,164,171],[78,140,148],[76,141,149],[77,141,150],[77,141,149],[76,139,148],[79,139,148],[126,167,174],[188,204,230],[160,178,211],[125,145,183],[95,115,158],[90,112,156],[91,112,155],[90,110,154],[89,109,153],[88,108,153],[88,108,153],[87,107,151],[85,105,148],[86,106,149],[85,105,148],[85,105,148],[91,112,155],[123,140,173],[191,207,233],[135,156,194],[114,136,176],[100,124,167],[94,119,162],[92,117,160],[89,115,160],[89,115,160],[91,116,161],[93,117,163],[93,117,164],[96,118,160],[155,171,192],[232,229,171],[228,225,123],[226,223,94],[225,222,84],[225,223,81],[227,223,81],[226,222,80],[226,222,80],[226,221,81],[224,221,80],[225,221,79],[223,219,81],[234,228,152],[235,225,133],[232,225,94],[230,223,87],[231,224,89],[118,163,172],[85,142,153],[83,144,156],[81,143,156],[78,144,157],[78,144,158],[78,145,158],[74,142,156],[73,141,155],[72,140,155],[70,138,154],[68,137,153],[69,139,154],[68,138,153],[68,138,153],[68,138,153],[67,138,153],[67,138,152],[67,137,152],[68,138,153],[68,139,154],[69,139,154],[70,140,155],[70,140,155],[70,140,155],[69,139,155],[69,139,154],[70,140,155],[70,140,155],[69,139,152],[68,138,151],[69,137,151],[70,136,149],[70,134,146],[102,155,165],[161,202,212],[179,218,227],[177,217,226],[166,210,221],[151,198,207],[120,172,182],[88,144,155],[86,143,154],[82,142,152],[81,140,150],[81,141,150],[82,142,152],[79,140,150],[76,135,146],[73,133,144],[89,145,157],[134,184,193],[174,208,218],[194,220,228],[204,225,232],[207,224,230],[205,222,228],[165,195,201],[104,155,163],[75,137,146],[73,138,147],[76,140,150],[75,139,149],[76,140,150],[74,137,146],[97,149,157],[192,214,220],[136,155,193],[93,112,155],[91,111,154],[89,110,153],[88,109,152],[88,108,152],[88,108,152],[87,107,150],[85,105,148],[84,105,148],[88,107,147],[101,120,156],[134,149,182],[192,204,222],[196,213,233],[184,202,225],[170,190,218],[154,174,208],[133,155,192],[120,141,179],[111,132,171],[104,126,166],[101,123,163],[101,122,161],[117,135,164],[158,172,190],[195,207,220],[232,228,137],[228,223,104],[226,223,87],[227,223,83],[227,222,81],[226,222,82],[226,222,82],[225,222,81],[225,221,80],[224,219,82],[232,226,151],[234,226,211],[232,221,198],[232,221,169],[232,224,123],[232,225,93],[232,225,88],[230,223,87],[125,172,180],[85,143,154],[82,143,155],[81,143,156],[78,144,156],[78,144,158],[77,144,158],[74,142,156],[74,142,156],[72,140,156],[70,138,154],[69,139,154],[69,139,154],[67,138,153],[67,138,153],[67,138,153],[68,138,153],[65,136,151],[66,137,152],[66,137,152],[68,138,154],[70,140,155],[70,140,155],[69,139,154],[69,139,154],[70,140,155],[69,139,154],[70,140,155],[70,140,155],[69,139,154],[69,139,153],[69,138,151],[69,136,150],[86,144,154],[166,202,210],[190,218,227],[191,218,225],[192,219,226],[194,222,231],[197,226,233],[169,206,214],[101,146,156],[93,142,151],[101,149,159],[120,167,176],[144,187,196],[157,198,206],[145,188,196],[115,161,170],[120,163,172],[173,203,211],[201,224,228],[207,224,230],[188,207,213],[137,172,179],[88,143,152],[74,137,146],[73,137,147],[75,139,149],[76,140,150],[76,140,150],[74,139,148],[85,143,151],[162,197,203],[201,215,235],[121,139,178],[89,110,152],[89,109,152],[88,108,152],[88,108,151],[87,107,150],[87,107,149],[93,113,152],[112,131,167],[147,162,191],[181,194,217],[206,218,235],[195,210,229],[182,198,219],[171,186,210],[157,173,200],[147,163,189],[143,159,180],[125,139,160],[144,157,175],[171,184,200],[193,205,218],[233,227,124],[231,226,104],[228,224,90],[227,222,84],[226,222,83],[225,221,82],[224,221,82],[224,219,83],[229,222,142],[232,224,208],[231,221,199],[230,220,177],[232,223,141],[233,226,109],[232,225,92],[233,225,89],[231,224,88],[147,189,197],[88,145,157],[82,143,156],[79,143,156],[79,144,156],[78,144,158],[76,144,157],[74,142,156],[73,141,155],[71,139,154],[70,138,154],[69,139,154],[68,139,154],[68,138,153],[68,138,153],[68,138,153],[68,138,153],[65,136,151],[66,137,152],[67,138,153],[68,138,153],[70,140,155],[70,140,155],[69,139,154],[69,139,154],[70,140,155],[71,141,156],[71,142,157],[71,142,157],[70,141,156],[71,141,156],[70,139,152],[71,137,149],[132,176,186],[193,218,226],[193,214,223],[194,215,222],[196,216,223],[201,220,227],[206,226,231],[198,221,227],[131,162,170],[141,172,180],[177,202,209],[203,224,228],[205,226,230],[196,218,222],[197,218,224],[206,223,228],[152,177,183],[115,151,158],[88,139,147],[76,138,147],[75,139,149],[75,139,149],[76,140,151],[76,141,150],[75,140,150],[80,139,147],[149,190,197],[210,229,233],[179,195,222],[94,114,154],[89,110,152],[89,109,151],[89,109,148],[101,120,157],[127,144,177],[162,179,205],[195,209,228],[130,146,172],[101,118,148],[103,119,149],[111,127,153],[128,141,163],[144,157,176],[160,173,189],[184,195,206],[233,228,120],[230,225,98],[227,222,89],[225,221,84],[225,221,84],[224,220,85],[227,221,126],[228,220,199],[228,219,179],[231,222,148],[233,226,112],[235,227,95],[233,225,91],[233,225,89],[233,225,90],[177,210,217],[97,153,165],[83,144,157],[80,144,157],[81,145,157],[78,144,158],[75,143,157],[74,142,156],[74,143,157],[71,139,154],[71,139,155],[69,139,154],[68,138,153],[67,138,153],[68,138,153],[67,137,152],[67,137,152],[66,137,152],[67,137,152],[67,138,153],[68,138,153],[68,139,154],[69,139,154],[70,140,155],[70,140,155],[70,140,155],[71,142,157],[71,142,157],[71,142,157],[70,140,155],[70,139,153],[70,139,152],[83,142,154],[174,207,217],[197,218,225],[195,215,222],[198,215,223],[199,216,222],[197,215,220],[130,159,164],[105,141,148],[94,139,147],[84,141,149],[77,139,149],[75,139,149],[76,140,150],[76,142,151],[76,142,152],[76,140,149],[130,176,184],[209,228,234],[117,136,170],[90,110,150],[95,114,151],[138,156,186],[177,193,218],[202,216,231],[158,173,200],[100,120,156],[100,119,157],[98,116,155],[95,115,151],[96,114,150],[97,115,149],[103,120,151],[120,134,162],[160,172,189],[235,228,138],[231,226,107],[227,223,91],[224,221,87],[223,220,87],[224,221,106],[224,216,186],[227,218,150],[230,223,111],[232,226,94],[232,225,91],[232,224,89],[233,225,89],[234,226,90],[202,226,230],[120,172,182],[85,146,159],[80,144,157],[81,145,157],[78,143,157],[76,142,156],[75,143,157],[74,142,157],[71,139,154],[70,138,153],[69,137,153],[69,137,153],[67,137,152],[66,137,152],[65,136,151],[66,137,152],[66,137,152],[67,137,153],[67,137,152],[68,138,153],[68,138,153],[67,138,153],[69,139,154],[68,139,154],[70,141,156],[71,142,157],[71,142,157],[72,142,158],[73,141,156],[70,139,152],[71,139,152],[100,147,157],[188,215,223],[199,221,227],[200,220,227],[202,220,225],[202,218,224],[170,189,192],[118,151,157],[102,141,149],[89,138,146],[82,140,148],[77,140,148],[75,139,149],[75,140,150],[74,141,150],[76,141,151],[102,157,165],[194,222,228],[140,158,186],[90,109,146],[133,147,173],[210,221,234],[175,191,218],[100,120,159],[99,120,160],[97,118,159],[96,116,158],[96,116,158],[95,114,157],[94,113,153],[95,114,152],[100,117,148],[128,142,164],[229,225,116],[223,221,90],[222,220,87],[221,219,95],[227,218,186],[221,213,176],[224,218,130],[229,222,103],[232,225,91],[231,224,88],[232,225,88],[233,226,88],[234,227,89],[163,202,212],[95,155,168],[84,148,161],[82,146,159],[79,145,159],[76,143,157],[76,145,158],[74,142,156],[73,141,155],[70,138,153],[69,138,152],[70,138,154],[68,137,153],[68,137,153],[67,137,152],[67,136,152],[67,137,152],[67,137,152],[69,139,154],[68,138,153],[68,138,153],[67,138,153],[66,137,152],[67,138,153],[70,141,156],[70,140,155],[71,141,156],[73,141,157],[74,142,156],[74,141,154],[75,139,151],[88,142,153],[136,172,181],[151,179,187],[181,202,208],[206,222,228],[195,213,217],[173,198,204],[147,181,189],[118,164,172],[84,143,151],[76,140,149],[75,139,149],[75,141,150],[75,142,151],[77,139,149],[145,186,196],[144,160,186],[90,108,141],[169,181,194],[188,203,228],[103,122,163],[99,119,161],[98,118,161],[97,117,161],[96,117,161],[97,117,161],[94,116,159],[96,117,161],[96,116,160],[96,115,153],[117,131,155],[227,223,109],[221,220,88],[221,219,91],[219,213,149],[228,220,205],[224,215,178],[224,218,129],[228,222,102],[232,225,91],[231,224,87],[231,224,87],[233,226,87],[234,227,88],[234,227,89],[201,223,229],[133,181,192],[89,152,164],[83,147,161],[81,146,160],[79,145,159],[76,144,157],[75,144,157],[72,140,155],[70,139,153],[69,137,151],[68,136,152],[69,137,152],[68,137,152],[69,137,152],[68,136,152],[68,137,151],[70,138,153],[71,139,154],[69,137,153],[68,136,152],[69,137,153],[67,135,151],[69,139,154],[70,141,155],[69,138,151],[73,141,156],[74,142,157],[75,141,156],[76,140,154],[77,139,152],[81,138,149],[92,138,147],[101,136,144],[152,175,181],[195,214,219],[184,216,222],[103,159,168],[76,140,150],[74,139,149],[75,141,150],[75,142,151],[76,137,147],[167,200,211],[125,141,170],[92,108,138],[183,193,203],[203,217,235],[120,139,175],[98,118,161],[96,116,160],[96,116,161],[95,115,161],[96,117,162],[94,117,161],[95,118,163],[94,117,162],[95,117,162],[96,116,159],[113,129,156],[222,219,90],[221,219,89],[219,214,113],[222,214,179],[232,224,190],[227,220,138],[228,222,104],[231,224,89],[233,225,86],[233,226,86],[234,226,87],[235,227,87],[234,227,88],[234,225,99],[233,222,119],[233,223,132],[234,223,148],[234,225,164],[235,227,180],[184,216,222],[120,171,183],[87,149,162],[81,147,160],[80,146,160],[77,143,157],[75,142,156],[71,139,153],[70,138,151],[69,138,151],[69,137,150],[69,136,150],[69,137,150],[68,136,150],[69,138,151],[69,137,150],[69,137,151],[70,138,153],[69,137,151],[69,138,151],[68,136,150],[68,137,151],[70,139,153],[71,140,153],[70,138,152],[73,140,155],[75,142,154],[76,140,154],[77,139,151],[78,138,150],[82,138,149],[90,138,148],[98,137,147],[153,177,184],[195,218,225],[108,164,174],[74,139,149],[75,141,151],[76,143,152],[76,142,152],[77,137,147],[159,196,206],[199,212,230],[99,118,152],[93,110,137],[181,199,225],[141,160,197],[107,126,169],[95,115,160],[95,115,160],[94,115,160],[93,116,161],[95,117,162],[95,117,162],[95,118,163],[97,118,163],[96,116,158],[129,140,164],[224,221,98],[221,219,89],[220,217,91],[219,212,133],[223,215,192],[235,227,157],[229,224,111],[232,225,89],[234,225,85],[233,226,85],[235,226,86],[234,225,89],[233,225,92],[232,225,96],[232,224,105],[229,222,120],[229,221,139],[233,225,158],[177,213,222],[115,171,182],[86,148,161],[79,144,158],[79,145,158],[77,143,157],[75,141,155],[72,138,152],[71,137,151],[71,137,151],[70,137,151],[70,137,151],[69,136,150],[71,138,152],[70,137,150],[69,136,150],[70,137,151],[69,136,150],[69,136,150],[70,136,150],[72,137,151],[74,139,152],[76,140,153],[77,140,153],[79,141,154],[83,142,155],[85,143,155],[88,144,155],[92,147,158],[103,153,163],[121,163,173],[138,172,180],[180,200,207],[180,208,215],[92,151,160],[74,140,149],[77,143,152],[77,144,153],[77,143,153],[77,141,151],[105,155,165],[139,175,183],[156,185,192],[175,198,204],[140,156,182],[92,111,147],[117,131,157],[168,185,218],[95,117,162],[92,113,158],[92,114,159],[92,115,160],[95,117,163],[96,118,164],[94,117,162],[96,118,164],[97,118,163],[101,117,155],[226,222,106],[220,218,89],[220,218,90],[218,214,101],[217,210,152],[223,216,192],[208,204,187],[211,206,189],[220,215,197],[233,226,93],[234,225,84],[234,225,83],[235,227,84],[235,227,84],[235,226,83],[234,226,83],[234,226,83],[234,226,85],[232,224,91],[231,223,101],[231,224,110],[231,225,131],[231,225,170],[234,229,207],[179,216,224],[125,178,190],[92,151,164],[80,144,157],[79,143,156],[76,140,153],[75,140,153],[72,136,149],[72,136,149],[72,137,150],[70,135,149],[70,135,148],[72,137,150],[72,135,149],[72,134,147],[75,136,149],[79,139,152],[84,142,156],[97,154,167],[110,165,178],[122,174,187],[129,180,192],[135,185,196],[143,190,201],[157,200,210],[163,204,214],[168,209,218],[174,211,221],[187,218,228],[202,225,233],[207,228,235],[208,226,232],[198,214,220],[128,169,176],[77,139,149],[76,140,151],[77,143,153],[76,143,153],[75,141,151],[74,140,150],[73,136,146],[77,136,145],[82,136,146],[93,142,150],[129,162,169],[165,179,196],[93,112,147],[92,111,145],[168,181,201],[109,131,173],[91,113,160],[92,114,160],[93,115,161],[95,117,164],[94,116,164],[93,116,162],[95,117,163],[96,119,164],[97,118,161],[127,138,158],[227,223,109],[220,218,90],[220,217,90],[217,215,92],[215,210,118],[216,209,156],[222,216,197],[219,215,195],[212,207,181],[209,203,174],[213,207,178],[224,218,191],[235,229,202],[234,227,102],[234,226,84],[234,226,83],[235,226,84],[235,227,83],[234,226,81],[234,226,81],[234,226,81],[234,227,82],[234,226,82],[233,226,82],[233,226,83],[231,226,88],[228,223,115],[228,224,157],[194,224,233],[147,194,205],[95,154,166],[81,141,153],[78,140,153],[74,137,150],[74,136,149],[72,135,147],[73,136,148],[76,136,149],[87,145,157],[99,155,167],[105,160,171],[117,169,181],[129,179,190],[144,191,202],[156,200,211],[174,213,223],[188,223,233],[190,208,212],[158,178,184],[150,165,170],[183,206,211],[102,156,165],[74,138,148],[75,141,150],[74,141,150],[75,142,151],[74,141,150],[74,141,150],[72,139,148],[74,139,148],[75,138,147],[75,136,145],[80,133,142],[110,148,156],[169,191,198],[164,177,197],[93,112,146],[87,108,149],[97,115,149],[198,211,222],[125,144,182],[91,113,160],[92,114,161],[92,114,162],[93,115,163],[93,115,163],[94,116,164],[95,117,163],[95,117,162],[97,117,163],[109,122,149],[225,222,107],[221,219,92],[219,216,91],[217,215,92],[215,213,103],[215,209,130],[217,209,178],[230,226,205],[224,217,187],[214,207,170],[211,204,163],[216,207,167],[231,222,182],[234,225,85],[234,225,83],[234,226,83],[235,227,83],[235,227,82],[234,226,81],[234,226,81],[233,227,81],[233,227,81],[232,227,81],[232,226,80],[232,226,83],[230,226,85],[228,225,97],[225,221,163],[126,178,190],[81,140,152],[80,140,153],[77,137,150],[75,136,149],[75,134,145],[88,144,155],[121,172,184],[158,202,213],[177,216,227],[186,222,233],[204,224,228],[184,206,212],[149,174,180],[117,148,153],[102,135,141],[120,144,150],[188,210,215],[147,194,202],[91,153,162],[74,140,150],[76,142,152],[77,143,153],[76,142,152],[74,142,151],[74,141,150],[75,141,151],[76,141,151],[74,139,149],[73,137,147],[77,135,144],[109,148,156],[187,202,208],[155,172,193],[91,111,146],[86,106,147],[87,107,150],[97,116,151],[202,214,226],[128,147,185],[91,113,160],[91,113,160],[92,114,161],[92,114,162],[93,115,162],[94,116,164],[95,117,164],[95,117,163],[96,117,163],[108,121,150],[233,227,144],[223,221,101],[221,219,92],[220,217,94],[218,216,95],[217,213,110],[217,211,131],[221,212,172],[235,229,201],[226,218,182],[217,209,164],[214,206,155],[220,211,159],[234,226,87],[235,226,84],[235,227,84],[235,227,82],[235,227,82],[235,227,82],[234,226,81],[234,226,81],[234,226,81],[232,227,81],[232,226,80],[230,225,79],[231,225,80],[230,226,82],[229,226,84],[223,221,115],[151,196,208],[82,138,151],[82,139,152],[78,135,147],[78,134,146],[106,156,167],[155,194,205],[189,219,227],[201,219,225],[189,210,216],[165,191,197],[131,166,173],[104,144,153],[91,135,144],[88,136,143],[88,137,145],[106,143,150],[199,218,224],[187,221,229],[140,192,200],[79,144,153],[75,141,151],[74,141,150],[75,142,152],[74,141,150],[74,141,150],[74,141,150],[74,141,150],[74,141,150],[75,140,149],[75,139,149],[82,138,146],[142,167,174],[193,206,222],[135,153,179],[91,110,146],[85,106,147],[86,107,149],[87,107,150],[98,115,150],[201,212,223],[202,215,232],[112,133,172],[92,114,161],[92,114,161],[92,114,161],[92,114,161],[92,114,161],[93,115,163],[95,117,165],[95,117,163],[96,117,163],[112,127,157],[231,224,151],[226,222,113],[222,219,95],[221,219,93],[221,218,94],[219,215,99],[219,214,123],[224,215,155],[231,221,186],[235,228,209],[228,219,177],[218,209,155],[217,209,146],[228,218,165],[234,227,88],[235,227,84],[235,227,83],[234,226,82],[235,227,82],[235,227,82],[235,227,82],[233,226,81],[234,226,81],[234,226,81],[232,227,81],[231,226,80],[231,226,80],[230,225,79],[230,225,81],[230,226,82],[226,225,91],[216,213,178],[151,190,199],[82,137,148],[82,138,149],[84,137,148],[132,173,184],[185,215,224],[205,224,230],[193,212,218],[182,201,205],[164,183,188],[193,211,215],[166,188,194],[155,180,185],[149,174,179],[124,161,167],[103,146,155],[87,139,149],[79,136,146],[80,136,146],[82,138,148],[82,138,149],[82,138,149],[90,141,150],[175,197,203],[209,227,233],[203,226,234],[175,217,226],[80,145,154],[73,140,149],[73,140,149],[74,141,150],[75,141,151],[75,141,151],[74,140,150],[74,141,150],[74,141,150],[73,140,149],[76,141,148],[79,140,148],[101,144,150],[165,180,200],[110,129,159],[85,107,146],[83,105,149],[85,106,149],[86,106,149],[86,107,150],[97,113,146],[198,210,221],[161,177,204],[95,117,160],[93,115,160],[94,116,162],[93,115,162],[92,114,161],[93,115,163],[92,115,162],[96,118,165],[96,118,164],[96,117,162],[129,143,171],[235,226,191],[233,225,168],[231,225,146],[228,222,129],[227,222,108],[225,221,95],[223,220,92],[222,220,92],[222,220,94],[220,217,105],[225,218,140],[234,224,174],[235,228,205],[229,224,200],[223,219,193],[219,214,190],[220,215,195],[222,217,199],[217,213,193],[228,222,201],[227,218,165],[220,212,142],[223,213,156],[234,227,90],[235,228,83],[235,227,82],[235,227,82],[235,227,82],[234,227,82],[234,226,81],[234,226,81],[233,227,81],[232,226,80],[231,226,80],[230,225,79],[230,226,81],[230,226,82],[229,226,84],[219,216,154],[121,166,176],[81,136,147],[88,138,148],[142,181,190],[195,223,232],[201,227,235],[199,225,232],[197,223,231],[196,221,228],[192,218,227],[187,214,224],[185,212,221],[184,212,221],[183,211,220],[179,208,216],[172,202,211],[162,196,205],[148,185,194],[136,173,181],[125,162,169],[112,148,155],[106,141,148],[116,144,149],[192,208,213],[179,197,201],[133,166,173],[99,145,153],[85,137,146],[81,136,144],[77,134,144],[77,135,145],[75,136,147],[76,137,148],[78,139,149],[80,141,151],[79,139,150],[80,140,151],[81,138,148],[116,153,162],[180,200,206],[198,222,229],[152,193,202],[78,142,152],[74,141,150],[73,140,149],[73,140,149],[75,142,151],[75,141,151],[74,141,150],[73,140,149],[73,140,148],[72,139,148],[75,140,147],[79,142,149],[88,141,146],[172,195,199],[161,175,193],[98,116,150],[83,104,147],[84,106,151],[84,107,151],[84,107,150],[86,108,150],[85,108,150],[96,113,143],[196,207,220],[185,198,215],[162,176,199],[113,131,166],[94,116,159],[93,116,160],[94,116,162],[94,117,163],[94,116,163],[94,116,162],[94,116,163],[96,118,164],[95,118,163],[98,120,162],[171,183,203],[233,228,186],[232,226,157],[229,222,140],[227,222,117],[226,222,101],[225,221,96],[225,221,91],[225,221,89],[224,221,89],[224,221,92],[224,222,94],[225,221,115],[231,223,156],[232,225,182],[223,218,169],[215,211,159],[211,209,155],[212,208,158],[216,211,166],[220,216,174],[225,219,186],[228,221,195],[230,223,203],[229,223,203],[219,213,180],[218,212,173],[229,223,190],[222,215,146],[224,214,152],[234,227,93],[235,228,84],[235,227,82],[234,227,81],[235,227,82],[234,227,81],[234,226,81],[234,226,81],[233,227,81],[232,227,81],[231,226,80],[230,225,79],[230,225,80],[230,226,82],[229,227,84],[223,221,147],[175,209,218],[93,144,154],[85,137,147],[122,164,174],[190,220,229],[201,226,234],[193,219,226],[175,203,212],[162,191,199],[156,183,192],[143,173,182],[129,163,172],[126,160,168],[125,159,167],[124,159,168],[124,160,170],[122,162,172],[126,168,177],[112,156,165],[106,149,159],[102,147,156],[99,144,154],[93,140,150],[85,135,145],[83,131,141],[83,132,141],[86,134,143],[87,135,144],[116,150,157],[153,183,188],[116,157,166],[91,144,153],[81,138,147],[76,138,146],[76,137,147],[76,138,148],[76,138,149],[74,138,148],[76,139,150],[77,139,150],[75,138,148],[77,140,151],[77,138,149],[82,135,144],[134,166,173],[207,224,230],[206,222,229],[209,226,232],[209,227,232],[187,212,219],[128,171,178],[92,152,160],[80,145,155],[76,142,152],[74,141,150],[74,141,150],[76,142,152],[75,142,151],[73,140,149],[75,142,151],[73,140,149],[74,140,149],[77,142,149],[80,143,150],[83,141,147],[152,176,180],[192,205,222],[101,119,153],[87,108,149],[86,106,149],[86,107,150],[85,107,150],[86,107,150],[86,107,150],[86,108,151],[95,113,143],[199,211,221],[204,216,228],[194,206,221],[187,201,216],[179,193,207],[175,188,203],[175,188,202],[176,188,204],[175,187,201],[175,187,200],[177,188,200],[179,189,199],[151,164,184],[126,139,162],[121,135,156],[119,133,156],[112,128,157],[104,121,154],[97,117,156],[95,117,160],[94,116,160],[95,117,161],[94,117,161],[94,117,161],[94,117,161],[94,116,160],[94,116,160],[95,117,160],[133,152,183],[232,228,193],[228,224,161],[227,222,133],[227,222,108],[226,221,99],[225,222,92],[226,223,87],[226,223,88],[225,222,88],[225,221,88],[225,221,89],[225,221,90],[224,222,95],[229,224,127],[234,225,175],[226,220,146],[220,217,129],[218,215,118],[217,215,118],[216,213,118],[216,213,122],[217,213,130],[219,214,139],[222,216,149],[224,219,160],[228,222,169],[230,224,178],[232,226,185],[233,226,189],[234,227,191],[234,227,194],[230,224,193],[229,223,193],[226,220,192],[226,219,194],[229,222,199],[227,220,172],[220,213,148],[223,217,157],[232,225,176],[226,220,147],[223,216,144],[234,226,127],[233,226,96],[234,226,81],[234,227,81],[234,227,81],[234,227,81],[233,226,80],[233,227,81],[232,226,80],[231,226,80],[231,226,82],[231,227,83],[230,228,91],[227,225,155],[200,227,235],[120,164,174],[87,139,149],[90,138,148],[165,198,208],[200,225,235],[183,212,220],[136,170,179],[118,153,162],[103,143,150],[94,135,143],[94,134,142],[94,134,143],[93,134,142],[94,134,142],[95,135,144],[95,136,145],[98,141,149],[120,161,170],[130,176,185],[89,140,149],[85,137,147],[83,136,146],[81,137,148],[80,137,148],[79,137,147],[78,137,147],[78,136,146],[81,138,149],[83,138,149],[104,147,155],[182,200,205],[187,208,213],[161,193,200],[119,165,175],[81,140,150],[75,138,147],[75,137,148],[75,138,149],[73,137,147],[73,138,148],[75,139,150],[76,139,150],[75,139,149],[76,139,150],[76,138,149],[75,137,147],[100,152,159],[199,220,227],[204,224,231],[193,214,221],[187,207,214],[204,224,231],[208,227,234],[193,218,224],[123,165,173],[84,141,149],[79,142,152],[80,145,155],[77,142,153],[75,142,151],[73,141,149],[76,143,152],[75,142,151],[74,140,149],[76,141,151],[76,142,152],[77,143,152],[80,144,152],[81,143,151],[83,142,147],[162,184,187],[143,158,183],[90,111,151],[88,108,151],[85,106,149],[88,109,152],[85,106,149],[87,107,150],[88,109,152],[88,109,152],[90,110,145],[135,150,172],[152,166,185],[161,173,191],[166,177,193],[168,178,193],[169,179,192],[179,189,199],[177,188,208],[174,187,207],[172,185,204],[166,179,199],[159,174,192],[150,165,185],[143,159,179],[138,154,174],[132,147,167],[121,138,163],[113,132,160],[104,125,155],[99,120,150],[97,117,149],[96,117,149],[97,118,150],[98,118,150],[99,119,151],[100,120,152],[102,121,150],[135,150,170],[181,193,209],[101,117,146],[92,111,143],[93,111,143],[95,113,145],[96,115,151],[98,116,155],[98,118,157],[96,117,158],[95,115,159],[95,116,159],[93,116,158],[94,115,158],[95,115,158],[99,119,161],[111,131,172],[142,159,190],[204,213,227],[227,225,182],[225,222,145],[224,220,116],[224,220,99],[225,222,88],[225,222,84],[225,222,84],[226,222,84],[226,223,86],[225,222,86],[225,222,87],[225,221,88],[226,222,89],[226,224,99],[231,224,142],[227,221,147],[221,219,118],[219,218,104],[219,218,101],[219,218,101],[219,218,99],[219,217,99],[218,216,102],[218,215,106],[219,216,112],[220,217,119],[223,219,126],[225,220,135],[227,222,142],[229,224,146],[230,224,149],[230,224,151],[228,223,150],[224,218,150],[221,215,149],[218,212,148],[217,212,149],[218,211,154],[223,216,175],[230,224,165],[220,215,128],[220,216,126],[224,217,144],[230,223,143],[222,217,131],[232,224,154],[232,224,143],[229,222,119],[231,224,97],[235,227,89],[235,227,83],[235,228,83],[235,227,82],[235,227,82],[234,226,81],[233,227,81],[233,227,81],[232,226,80],[233,227,83],[232,228,84],[232,228,107],[231,227,170],[144,182,190],[91,141,150],[88,139,149],[98,144,153],[184,212,222],[198,224,233],[201,228,235],[143,179,187],[95,136,145],[95,138,145],[94,137,144],[93,136,143],[93,137,144],[93,136,144],[93,136,143],[94,136,143],[95,136,144],[102,143,152],[127,167,175],[173,208,217],[145,188,198],[86,138,147],[83,139,149],[82,139,149],[81,139,151],[80,140,152],[79,139,150],[79,138,149],[79,138,148],[82,140,150],[82,139,149],[87,139,149],[136,167,174],[194,217,223],[167,205,215],[89,148,159],[75,137,148],[76,139,149],[74,138,148],[73,137,147],[75,139,149],[75,139,149],[75,139,149],[76,140,150],[77,140,150],[73,137,147],[77,139,150],[88,145,154],[159,196,205],[158,196,204],[119,162,170],[113,153,161],[153,189,196],[174,205,213],[139,177,183],[90,142,150],[81,142,151],[79,143,152],[78,143,153],[77,141,151],[74,141,150],[75,140,150],[76,141,151],[77,142,152],[76,142,152],[77,141,151],[78,143,153],[79,143,151],[81,145,153],[81,144,150],[85,141,146],[188,205,208],[120,137,165],[91,111,152],[87,107,150],[86,106,149],[87,107,150],[87,107,150],[87,107,150],[88,109,152],[89,110,153],[88,109,148],[90,107,143],[92,109,142],[96,112,143],[97,113,143],[99,113,142],[101,115,142],[112,125,146],[139,154,178],[99,117,152],[94,114,148],[94,114,147],[92,112,146],[90,111,145],[88,110,145],[87,110,148],[87,109,148],[86,110,149],[87,111,151],[84,111,153],[85,111,155],[85,111,156],[84,110,155],[83,109,154],[83,109,153],[83,109,155],[83,108,154],[83,108,153],[83,108,150],[97,119,153],[131,146,169],[93,111,145],[94,113,147],[95,115,149],[96,116,150],[97,116,152],[97,116,153],[97,116,153],[96,116,155],[99,118,158],[102,120,160],[106,125,164],[110,130,168],[121,139,174],[146,163,193],[180,195,220],[222,222,198],[220,218,145],[223,221,110],[224,221,91],[224,221,83],[224,221,82],[225,222,84],[225,221,83],[226,221,83],[225,222,84],[225,222,85],[225,222,86],[225,223,88],[226,224,92],[228,225,113],[230,223,153],[221,217,126],[219,218,106],[219,218,98],[220,219,96],[219,219,94],[220,219,92],[220,218,91],[220,219,91],[221,219,92],[221,220,94],[222,221,95],[224,221,97],[224,221,100],[225,222,103],[226,222,105],[226,222,106],[225,221,107],[224,222,107],[223,220,108],[221,219,110],[220,218,111],[220,216,116],[218,215,129],[221,215,156],[231,224,156],[220,217,119],[222,218,116],[222,216,125],[233,227,135],[222,218,119],[226,220,128],[228,221,131],[226,219,122],[225,219,112],[228,223,101],[231,225,94],[234,226,92],[235,228,92],[235,227,90],[234,227,89],[234,227,88],[234,227,86],[234,226,86],[233,227,85],[234,227,85],[234,227,85],[235,227,85],[234,228,85],[234,228,84],[234,228,84],[233,228,86],[233,228,92],[233,228,130],[235,229,190],[173,204,212],[96,143,152],[89,142,151],[86,138,148],[104,147,156],[184,211,221],[198,223,233],[200,226,235],[146,181,189],[100,142,149],[96,140,146],[95,139,145],[94,138,144],[93,137,143],[93,135,141],[96,137,143],[105,145,151],[126,164,171],[154,189,198],[181,213,222],[121,165,175],[85,138,148],[82,138,149],[82,140,150],[81,141,153],[82,141,153],[80,140,152],[79,139,150],[80,139,150],[81,139,149],[82,139,149],[82,138,148],[99,142,152],[170,195,200],[185,201,206],[203,220,225],[197,217,223],[184,217,226],[96,156,165],[75,137,147],[74,138,148],[74,139,149],[75,139,149],[75,139,149],[77,141,151],[77,141,151],[77,141,152],[77,140,151],[76,140,150],[79,143,153],[82,143,153],[94,148,158],[92,146,155],[83,140,149],[84,138,147],[97,146,154],[109,152,160],[97,144,151],[87,140,148],[86,142,151],[88,146,154],[88,147,157],[88,149,158],[87,148,158],[82,144,154],[76,139,149],[76,140,150],[77,140,150],[77,142,149],[77,142,150],[78,142,151],[82,143,150],[84,143,149],[127,164,168],[121,138,166],[92,112,153],[88,109,152],[88,108,151],[88,108,151],[87,107,150],[88,108,151],[89,109,151],[88,109,150],[88,109,150],[88,108,149],[89,109,150],[93,112,151],[93,112,150],[93,112,148],[95,111,146],[96,110,142],[163,173,186],[180,192,209],[91,113,154],[84,108,153],[85,110,154],[85,109,156],[85,109,155],[84,109,155],[84,111,156],[86,112,160],[85,111,158],[87,113,161],[87,113,160],[84,111,158],[87,113,161],[86,112,160],[85,112,160],[85,112,159],[84,113,159],[84,113,160],[84,112,159],[82,110,158],[81,109,154],[84,109,151],[145,160,181],[171,184,201],[100,117,148],[95,113,146],[96,113,146],[97,114,147],[96,113,146],[100,116,150],[111,127,158],[134,149,176],[154,168,193],[166,182,206],[176,190,215],[185,199,222],[195,208,230],[213,215,173],[218,218,111],[223,223,84],[223,221,81],[222,220,80],[223,221,81],[224,221,81],[225,222,82],[225,222,82],[226,223,83],[225,222,84],[225,222,86],[226,223,89],[225,223,100],[232,227,132],[223,218,135],[218,216,115],[218,217,103],[218,218,97],[219,219,95],[219,219,93],[221,219,90],[221,219,90],[222,220,91],[221,219,90],[222,221,89],[223,221,89],[225,222,90],[226,223,90],[226,223,89],[226,223,90],[226,223,90],[226,222,92],[226,223,93],[225,222,94],[225,221,95],[224,221,98],[221,220,104],[221,217,122],[226,219,154],[231,225,152],[222,218,115],[223,220,114],[222,218,115],[233,225,151],[234,229,127],[222,219,111],[225,220,114],[225,219,113],[224,218,111],[224,219,112],[226,222,106],[229,223,107],[234,226,114],[232,224,106],[230,223,101],[230,222,97],[231,223,97],[231,224,95],[232,225,94],[233,225,93],[233,226,94],[233,228,96],[235,229,165],[207,227,233],[115,159,168],[88,140,149],[88,141,150],[86,138,148],[99,144,153],[166,197,206],[194,220,228],[200,226,235],[181,213,220],[135,174,180],[107,147,154],[99,139,145],[96,138,144],[101,142,149],[117,156,163],[140,176,184],[166,199,206],[183,212,221],[189,218,227],[192,221,230],[170,207,217],[94,145,155],[83,138,149],[82,139,149],[81,140,150],[81,141,152],[80,140,152],[79,139,150],[79,139,150],[79,139,150],[81,139,149],[82,139,149],[83,140,150],[89,139,149],[126,158,165],[188,209,214],[174,196,201],[128,149,155],[206,224,229],[205,221,227],[204,223,229],[200,222,229],[172,214,222],[86,147,156],[75,137,147],[74,138,148],[74,138,148],[74,139,149],[75,139,149],[77,142,152],[78,142,152],[77,141,151],[77,142,152],[77,142,152],[79,143,154],[78,143,153],[78,142,152],[79,142,153],[79,141,151],[80,141,151],[81,139,146],[87,138,146],[92,139,148],[105,152,161],[131,176,184],[154,195,203],[167,206,213],[167,207,215],[156,199,209],[128,176,185],[98,151,159],[89,143,151],[84,141,148],[83,140,147],[82,139,146],[83,138,146],[93,144,152],[123,166,172],[200,221,225],[144,161,189],[94,114,155],[90,111,153],[87,107,151],[88,108,151],[87,107,150],[88,108,151],[88,108,150],[88,109,149],[90,111,152],[89,109,150],[90,111,152],[94,113,152],[96,114,153],[98,115,152],[97,113,149],[97,112,146],[118,129,150],[114,134,168],[85,109,155],[85,110,156],[87,111,158],[87,112,159],[86,112,158],[85,112,158],[86,113,160],[85,113,160],[85,112,159],[85,112,160],[86,113,160],[84,111,159],[87,113,161],[86,113,161],[84,112,160],[85,114,161],[85,114,161],[86,115,162],[86,115,162],[83,112,160],[83,111,159],[84,111,158],[94,117,152],[164,178,195],[179,191,209],[114,130,160],[94,112,146],[96,113,147],[95,112,145],[98,115,146],[120,135,163],[155,168,191],[187,200,219],[212,213,144],[219,221,93],[223,222,82],[222,220,82],[223,220,81],[224,221,81],[224,221,81],[225,222,82],[225,222,82],[225,222,83],[225,222,84],[225,222,85],[226,223,89],[228,225,113],[227,220,148],[218,215,124],[218,217,114],[218,218,107],[217,218,99],[219,218,97],[219,219,95],[220,219,91],[220,219,90],[221,219,90],[221,220,89],[222,221,89],[223,222,89],[225,222,89],[226,223,88],[227,224,88],[226,223,87],[227,224,88],[226,223,89],[227,224,90],[226,222,89],[225,221,91],[224,221,94],[223,221,100],[223,218,122],[231,223,162],[230,222,147],[223,219,112],[222,219,110],[222,219,111],[231,223,143],[233,229,122],[224,221,111],[225,220,112],[224,219,110],[222,217,109],[224,219,112],[226,221,111],[231,224,123],[232,223,131],[228,220,124],[228,220,122],[230,222,121],[233,224,124],[162,194,202],[89,140,149],[87,140,150],[86,139,149],[87,140,150],[90,139,149],[138,172,181],[186,210,219],[201,225,233],[201,225,233],[201,226,234],[186,216,224],[164,195,202],[159,190,198],[165,196,204],[175,204,213],[185,213,220],[192,219,226],[194,221,228],[192,218,227],[187,215,223],[161,196,204],[109,156,165],[85,139,150],[83,139,150],[81,138,149],[79,139,151],[80,140,152],[80,140,152],[79,139,150],[79,139,151],[79,139,149],[82,140,150],[83,139,149],[86,141,151],[88,141,150],[96,141,149],[143,174,179],[192,212,219],[202,225,231],[128,163,170],[98,136,143],[197,218,224],[204,224,230],[203,222,229],[193,219,227],[158,196,204],[117,170,180],[78,138,148],[77,139,149],[76,139,149],[75,139,149],[75,139,149],[76,140,150],[77,141,152],[77,141,151],[77,141,151],[77,141,151],[77,141,152],[79,144,154],[79,144,154],[77,142,152],[80,144,154],[77,141,152],[78,141,149],[78,140,148],[88,138,147],[129,165,172],[184,208,213],[206,228,233],[198,226,233],[179,212,218],[162,197,204],[146,184,191],[132,173,178],[127,169,175],[135,176,182],[161,197,204],[201,223,228],[183,198,222],[101,121,161],[90,111,152],[89,110,153],[88,108,151],[87,107,150],[89,109,152],[88,108,150],[88,109,150],[90,111,152],[90,110,151],[91,111,152],[94,113,151],[95,113,151],[97,113,150],[97,114,148],[100,114,147],[102,114,140],[143,153,167],[140,157,187],[87,110,154],[86,110,157],[85,109,155],[86,111,158],[88,112,159],[87,113,159],[86,112,158],[86,113,160],[85,112,159],[83,110,158],[84,111,159],[84,111,159],[85,112,160],[85,112,160],[86,112,160],[84,112,160],[84,113,160],[85,114,161],[87,116,163],[88,116,164],[85,114,161],[85,114,161],[85,112,160],[84,110,155],[98,121,158],[143,161,185],[184,199,218],[203,217,234],[205,219,234],[189,202,221],[150,166,188],[110,126,156],[93,110,145],[94,111,148],[95,112,146],[99,116,147],[142,157,181],[194,206,224],[211,211,145],[218,220,98],[223,222,85],[223,220,82],[223,220,81],[224,221,82],[224,221,81],[225,222,82],[225,222,82],[225,223,83],[225,222,84],[225,222,84],[226,223,90],[232,227,129],[233,226,158],[218,213,135],[213,212,119],[216,214,115],[217,215,112],[216,216,108],[217,216,106],[218,216,105],[218,216,102],[218,215,101],[219,216,99],[220,218,96],[222,221,92],[223,221,90],[226,223,89],[226,223,88],[227,224,88],[226,223,87],[226,223,87],[227,223,87],[226,223,89],[226,222,89],[225,222,91],[223,221,94],[223,221,102],[225,221,128],[234,225,176],[228,220,141],[222,218,111],[220,217,108],[221,219,108],[228,224,129],[228,224,116],[224,220,110],[225,220,110],[222,218,108],[222,217,108],[224,219,111],[225,221,114],[232,226,137],[116,161,170],[86,139,149],[85,138,148],[85,139,150],[85,140,151],[86,137,148],[110,150,160],[160,188,197],[192,215,223],[202,226,234],[205,227,235],[203,224,233],[203,226,234],[202,225,234],[201,225,233],[201,226,233],[202,226,234],[202,225,233],[199,222,230],[198,222,229],[194,221,229],[178,206,214],[145,178,186],[108,149,158],[90,140,150],[86,140,151],[83,139,150],[81,139,149],[80,139,151],[79,139,151],[79,140,151],[81,141,152],[81,141,153],[81,139,151],[82,138,149],[84,139,150],[85,140,150],[89,142,151],[90,140,148],[101,145,151],[147,182,188],[148,186,193],[98,141,147],[99,141,148],[193,217,224],[200,224,231],[197,224,231],[132,172,181],[91,141,150],[79,137,146],[78,138,148],[79,140,151],[77,139,150],[76,140,150],[77,141,151],[76,140,151],[76,140,151],[77,141,151],[77,141,152],[77,141,152],[76,140,150],[79,143,154],[78,142,152],[77,142,152],[81,145,155],[78,142,153],[77,140,151],[80,139,148],[120,157,163],[202,221,226],[212,231,235],[210,230,234],[129,148,184],[92,113,154],[89,110,153],[87,107,150],[87,107,150],[91,112,154],[92,112,153],[91,111,152],[92,113,153],[93,112,153],[93,111,151],[93,111,148],[95,111,148],[96,113,147],[97,112,145],[99,113,144],[102,115,143],[107,118,142],[135,146,163],[176,187,206],[129,146,174],[90,111,152],[86,108,153],[85,109,156],[85,109,155],[86,110,157],[87,111,158],[87,113,159],[86,111,158],[87,113,160],[86,113,160],[83,110,158],[84,111,159],[84,111,159],[84,111,159],[83,110,158],[84,111,159],[83,111,159],[86,113,161],[86,115,162],[87,116,163],[87,115,163],[86,113,161],[88,115,162],[85,112,160],[84,111,158],[85,110,154],[89,113,151],[102,123,158],[117,137,170],[120,141,171],[122,140,169],[120,138,166],[110,128,157],[95,115,148],[89,109,146],[91,111,148],[94,111,149],[97,114,148],[146,161,188],[210,221,235],[213,214,160],[216,218,103],[223,222,86],[222,220,82],[222,220,81],[223,220,81],[223,221,81],[224,221,81],[224,221,82],[225,223,83],[225,222,84],[225,222,84],[226,223,91],[234,227,141],[224,217,148],[214,209,134],[212,207,126],[214,209,128],[214,210,131],[216,212,134],[221,217,138],[223,218,139],[225,220,139],[227,223,137],[227,223,133],[226,221,125],[225,220,111],[225,221,98],[228,224,90],[227,224,88],[227,224,88],[227,223,87],[226,223,87],[226,223,87],[226,222,89],[226,222,89],[226,222,91],[223,221,95],[224,222,102],[227,223,128],[233,225,168],[227,221,150],[225,219,128],[221,218,110],[220,218,106],[222,218,106],[225,221,115],[233,227,131],[230,224,121],[225,221,111],[224,220,109],[224,219,109],[222,219,108],[222,217,107],[223,219,111],[225,222,117],[234,228,155],[199,225,230],[95,147,157],[87,141,150],[86,139,150],[85,140,151],[84,138,149],[85,137,149],[90,140,150],[116,155,165],[158,188,196],[191,216,224],[203,226,234],[203,226,235],[202,226,234],[202,224,232],[202,224,233],[202,224,233],[201,224,232],[201,223,232],[198,221,229],[189,213,221],[161,188,196],[128,162,170],[107,148,157],[97,144,154],[92,144,153],[86,141,152],[85,141,151],[82,139,150],[82,139,151],[80,140,152],[80,140,151],[81,141,153],[82,141,153],[81,139,150],[81,138,147],[83,139,148],[85,139,148],[89,141,150],[89,140,148],[89,137,146],[100,143,150],[96,140,148],[91,139,146],[101,142,150],[191,220,228],[198,226,234],[158,195,203],[85,137,146],[78,135,143],[79,137,146],[78,138,148],[77,138,148],[75,138,148],[75,139,149],[75,139,149],[75,139,149],[77,141,151],[76,141,151],[76,140,150],[76,140,150],[74,138,148],[77,142,152],[78,143,153],[79,143,153],[80,145,155],[77,141,152],[77,141,152],[82,138,147],[178,200,205],[187,201,225],[118,136,172],[89,108,150],[87,107,150],[88,109,152],[91,112,153],[93,113,154],[93,113,154],[93,112,153],[95,113,153],[104,120,157],[123,139,172],[141,155,186],[147,161,189],[140,154,181],[131,143,168],[118,130,156],[109,121,146],[109,120,144],[117,128,149],[123,133,155],[125,137,157],[125,137,160],[124,136,160],[117,130,155],[100,116,148],[85,105,146],[85,107,153],[87,109,154],[85,109,155],[85,109,156],[85,109,156],[85,109,156],[88,112,159],[89,113,161],[85,112,160],[84,111,159],[84,111,159],[83,110,158],[84,111,159],[84,111,159],[85,112,160],[84,112,160],[85,113,160],[84,113,160],[85,114,161],[86,115,162],[87,116,163],[87,114,162],[87,115,162],[87,113,161],[86,112,160],[84,111,157],[83,109,155],[84,108,152],[85,109,153],[85,110,153],[86,109,152],[86,109,150],[86,109,150],[88,109,150],[90,111,152],[91,112,154],[93,112,152],[124,141,170],[220,222,186],[217,218,117],[222,221,90],[223,220,83],[224,221,83],[224,221,81],[224,221,81],[224,221,81],[225,221,82],[225,221,82],[225,222,84],[225,222,84],[227,224,94],[228,220,157],[217,210,144],[213,206,138],[214,206,140],[218,212,150],[225,219,163],[231,225,174],[235,228,155],[226,221,116],[228,223,90],[228,224,88],[227,224,88],[228,222,87],[228,222,87],[227,223,88],[226,222,88],[226,222,89],[226,222,91],[224,222,95],[223,222,102],[225,222,121],[235,228,158],[234,226,163],[230,222,157],[224,218,147],[223,218,131],[224,219,118],[221,218,108],[221,219,105],[223,219,106],[223,219,107],[224,219,110],[225,220,110],[224,220,107],[224,220,107],[223,220,108],[223,219,108],[224,219,109],[223,220,113],[229,224,133],[177,210,216],[88,141,151],[89,141,153],[86,140,152],[85,140,151],[84,138,149],[87,140,152],[86,140,151],[92,139,149],[111,151,161],[147,181,189],[181,208,217],[196,221,230],[199,225,233],[200,225,233],[201,225,233],[199,224,232],[194,219,227],[179,205,212],[159,186,193],[135,166,174],[119,154,162],[112,151,159],[107,147,156],[97,144,153],[91,142,152],[85,140,151],[84,139,150],[82,139,149],[79,138,149],[80,140,151],[80,140,152],[80,140,151],[82,140,151],[81,138,149],[82,138,147],[84,139,148],[86,139,149],[89,140,149],[88,139,147],[89,139,147],[91,139,148],[90,139,146],[91,140,146],[98,138,147],[183,219,228],[181,218,227],[99,148,158],[81,135,144],[80,136,144],[77,135,143],[78,136,145],[77,137,146],[88,148,157],[94,156,166],[91,154,165],[84,147,157],[78,141,151],[76,139,150],[76,139,150],[76,139,149],[73,137,147],[77,141,151],[78,142,153],[79,144,154],[79,144,154],[78,142,153],[77,141,152],[86,138,147],[184,199,225],[123,142,179],[94,114,153],[89,109,148],[89,109,149],[90,111,151],[95,115,155],[108,126,162],[133,149,181],[171,183,204],[205,214,228],[166,175,193],[129,140,162],[107,119,143],[103,115,141],[100,114,141],[96,111,143],[92,108,143],[89,106,142],[84,104,145],[84,105,148],[86,108,152],[85,108,153],[84,108,153],[86,109,155],[86,109,156],[86,111,157],[88,112,158],[88,112,159],[86,111,158],[84,110,157],[83,110,158],[82,109,157],[82,109,157],[84,111,159],[86,113,161],[85,114,161],[86,114,161],[84,113,160],[84,113,160],[85,114,161],[87,116,163],[86,115,162],[87,115,162],[87,114,161],[86,112,160],[84,111,159],[84,111,157],[86,110,157],[87,111,158],[87,111,158],[88,112,158],[88,113,156],[89,112,156],[88,110,153],[89,111,154],[91,112,155],[96,114,149],[178,189,205],[222,222,157],[221,220,110],[223,221,88],[223,220,84],[223,221,83],[224,221,83],[224,221,83],[225,222,83],[225,222,83],[225,222,86],[226,223,86],[226,222,92],[235,228,139],[235,227,157],[227,219,152],[220,212,146],[215,208,143],[215,207,146],[220,211,160],[228,222,182],[227,223,88],[229,223,88],[227,223,88],[228,223,86],[227,223,86],[227,223,87],[227,223,88],[227,223,90],[226,222,91],[224,221,96],[223,220,101],[222,219,114],[224,219,136],[223,217,143],[222,216,140],[221,217,132],[222,218,119],[222,219,110],[221,219,106],[222,219,104],[223,219,104],[223,219,104],[223,219,103],[222,219,104],[222,220,105],[223,220,105],[223,219,106],[223,219,107],[224,220,108],[226,221,119],[232,226,155],[157,195,203],[89,142,152],[90,144,155],[86,140,152],[86,141,152],[84,139,150],[85,140,151],[85,140,151],[86,139,149],[87,139,148],[98,144,153],[119,156,165],[136,167,176],[145,177,185],[154,186,194],[157,187,196],[145,178,185],[127,163,170],[113,148,156],[108,144,150],[121,155,162],[147,179,186],[167,199,207],[155,190,198],[119,162,171],[91,143,152],[85,140,150],[82,139,149],[81,138,148],[78,137,148],[79,139,151],[80,140,152],[81,140,150],[84,142,152],[81,138,148],[82,138,147],[84,139,148],[89,140,150],[89,139,148],[87,138,146],[89,138,147],[91,139,148],[92,140,148],[92,140,148],[94,140,149],[128,172,182],[108,155,163],[81,134,141],[83,135,145],[81,135,144],[79,135,143],[81,135,145],[123,167,176],[168,211,220],[178,224,233],[175,220,231],[147,197,206],[102,158,168],[78,141,151],[78,140,150],[78,141,151],[75,139,149],[76,140,150],[77,141,152],[78,142,153],[78,143,153],[78,143,153],[78,141,151],[98,148,154],[199,211,231],[154,169,194],[125,140,166],[118,133,160],[126,143,169],[158,171,195],[183,195,214],[208,218,234],[200,210,225],[155,166,188],[109,122,149],[100,115,147],[98,114,149],[94,113,151],[90,109,147],[87,108,149],[87,107,150],[88,109,152],[85,108,150],[86,108,153],[86,109,154],[87,110,156],[88,113,157],[87,111,155],[87,111,157],[92,115,158],[94,118,162],[99,124,165],[99,124,165],[91,116,162],[84,111,158],[84,111,159],[85,114,161],[86,114,161],[85,112,160],[85,113,160],[87,114,162],[86,115,162],[87,114,162],[87,114,161],[88,114,162],[87,113,161],[86,112,160],[85,112,159],[87,113,159],[88,113,159],[88,112,158],[89,113,158],[89,113,157],[90,113,157],[91,114,156],[91,113,155],[92,112,154],[109,126,155],[231,230,203],[226,223,161],[224,221,122],[223,221,96],[222,221,86],[224,221,85],[225,222,85],[225,222,85],[225,222,85],[225,222,86],[225,222,88],[225,221,90],[223,219,115],[221,216,134],[218,211,137],[216,209,138],[216,209,145],[220,212,158],[228,221,185],[227,223,89],[227,223,86],[227,222,86],[227,223,85],[227,223,86],[227,222,87],[228,223,89],[226,223,90],[226,222,93],[224,221,99],[223,221,107],[222,219,117],[220,216,128],[220,214,137],[220,215,135],[220,216,127],[221,217,117],[221,218,110],[221,219,107],[221,219,104],[220,219,103],[222,220,104],[222,219,103],[223,220,103],[223,220,105],[223,219,104],[222,219,105],[223,220,107],[225,221,113],[230,223,134],[235,228,177],[143,184,193],[89,142,152],[89,143,154],[86,141,152],[87,142,153],[85,141,152],[85,140,151],[85,140,151],[85,140,150],[84,139,148],[82,136,145],[82,134,144],[84,133,141],[86,134,141],[89,136,143],[90,135,143],[89,133,141],[90,133,141],[96,136,144],[123,156,163],[175,203,210],[170,207,215],[110,160,169],[87,142,152],[83,140,150],[79,136,147],[76,135,146],[79,139,150],[78,138,149],[79,139,149],[83,141,151],[83,139,149],[83,139,148],[85,139,148],[89,140,148],[99,147,155],[103,149,157],[100,146,154],[93,141,149],[91,140,147],[92,140,147],[90,138,147],[87,135,144],[79,129,137],[80,134,141],[81,135,143],[80,134,142],[79,133,142],[113,155,163],[196,222,230],[162,205,214],[97,156,164],[78,140,149],[78,141,149],[78,141,150],[76,140,150],[77,142,151],[78,143,153],[78,143,153],[78,143,152],[79,143,151],[101,149,156],[210,220,233],[207,217,230],[210,221,234],[161,173,198],[105,119,153],[98,114,151],[96,114,153],[92,111,150],[91,111,152],[88,108,151],[88,108,152],[87,107,150],[87,108,153],[86,108,152],[87,110,154],[89,112,155],[105,126,161],[134,154,188],[161,181,212],[175,195,229],[183,203,233],[182,203,234],[170,192,229],[141,166,206],[101,126,172],[85,112,160],[87,113,161],[87,114,162],[85,112,160],[88,114,162],[88,114,162],[86,113,161],[87,113,161],[88,114,162],[87,113,161],[86,113,159],[88,114,160],[87,113,159],[88,112,159],[89,113,159],[90,114,159],[90,114,158],[90,112,157],[90,113,155],[90,113,155],[94,113,153],[142,156,181],[234,231,202],[232,227,167],[229,225,128],[225,222,107],[224,220,98],[224,220,92],[224,221,90],[224,221,89],[224,221,89],[224,221,90],[224,220,92],[222,217,105],[219,215,120],[217,210,137],[217,209,145],[220,213,162],[229,221,185],[227,223,92],[226,223,86],[227,223,85],[227,222,84],[227,222,86],[227,223,88],[227,224,90],[227,223,91],[227,223,101],[227,224,119],[229,225,138],[234,227,154],[232,224,161],[222,217,146],[220,215,127],[221,218,112],[221,218,108],[222,219,106],[221,218,104],[223,220,104],[223,219,104],[223,220,103],[223,219,105],[223,220,105],[223,219,106],[223,220,111],[226,222,125],[233,225,158],[147,184,190],[88,142,153],[87,142,153],[85,140,151],[87,142,153],[86,141,152],[84,139,150],[84,139,150],[85,141,151],[83,140,149],[83,138,148],[82,136,146],[80,134,142],[81,133,142],[83,134,142],[83,134,142],[86,135,143],[90,136,143],[117,153,160],[186,212,219],[156,199,207],[99,152,163],[83,141,151],[75,134,145],[73,133,144],[79,139,149],[78,138,149],[79,139,149],[80,140,150],[83,140,150],[82,137,147],[96,146,155],[136,175,182],[170,204,211],[183,215,221],[175,208,214],[141,182,188],[105,149,156],[92,141,147],[89,139,147],[86,137,145],[81,133,141],[82,134,141],[81,134,141],[80,135,141],[83,134,141],[170,193,199],[146,188,197],[83,144,153],[79,141,150],[79,141,149],[79,142,151],[78,142,151],[80,144,153],[80,143,152],[79,143,151],[81,145,153],[96,144,151],[144,158,185],[96,114,152],[94,113,152],[92,111,150],[90,110,151],[89,110,150],[88,109,151],[88,108,151],[87,108,151],[87,108,151],[91,113,152],[127,147,181],[181,197,217],[181,200,225],[107,133,177],[86,112,160],[86,112,160],[83,110,158],[86,113,161],[87,114,162],[86,113,161],[88,114,162],[87,113,161],[88,115,161],[88,115,160],[88,115,160],[88,115,160],[88,113,159],[89,114,160],[90,115,161],[90,114,158],[91,113,158],[92,115,158],[91,114,156],[99,118,155],[185,196,211],[232,225,160],[227,220,139],[222,218,116],[219,216,109],[218,216,106],[218,215,107],[219,215,107],[219,215,108],[218,214,115],[217,211,134],[218,210,157],[223,215,174],[229,223,191],[234,228,207],[227,224,98],[226,223,87],[227,223,85],[227,224,86],[227,224,86],[226,223,88],[226,223,88],[227,223,95],[228,223,128],[233,227,162],[227,221,156],[222,218,131],[221,218,117],[223,219,110],[222,219,109],[223,219,107],[223,219,106],[223,219,106],[222,218,107],[223,220,109],[224,221,110],[225,221,124],[229,223,150],[159,196,204],[89,143,154],[86,141,152],[86,141,152],[85,140,151],[84,140,151],[83,139,150],[84,139,150],[83,139,150],[82,139,149],[83,138,149],[84,139,148],[81,137,145],[82,135,144],[83,137,144],[84,136,144],[87,137,145],[101,141,149],[175,200,207],[201,227,233],[129,175,184],[85,143,153],[77,135,146],[75,135,147],[79,139,151],[80,140,151],[81,140,151],[81,140,150],[83,138,148],[105,150,159],[166,202,208],[204,229,235],[200,227,233],[155,193,199],[102,151,158],[87,138,146],[85,137,144],[80,133,140],[81,135,142],[81,135,142],[80,136,142],[88,139,146],[191,218,225],[108,161,169],[81,142,151],[79,142,150],[80,142,151],[79,142,150],[81,144,153],[82,145,153],[80,145,153],[83,146,154],[101,144,151],[109,127,163],[95,114,153],[94,113,152],[92,111,152],[90,110,151],[90,111,152],[89,109,152],[87,107,150],[91,111,152],[143,160,190],[204,217,227],[184,202,228],[94,119,163],[87,113,161],[84,111,159],[85,112,160],[85,113,161],[87,113,161],[88,114,162],[87,113,161],[90,117,162],[89,116,161],[88,115,160],[88,115,160],[90,115,161],[91,115,161],[91,116,162],[92,115,159],[92,115,159],[93,116,158],[93,115,156],[131,146,173],[233,228,178],[227,222,165],[221,216,155],[220,214,152],[220,214,149],[221,216,149],[223,218,152],[227,222,170],[232,225,191],[235,228,205],[226,222,103],[227,224,87],[227,223,85],[228,223,86],[228,223,86],[227,223,87],[226,223,88],[227,223,104],[230,225,159],[233,226,170],[227,222,144],[225,221,126],[222,217,119],[221,216,117],[220,216,116],[221,216,118],[222,217,119],[223,219,121],[226,221,126],[229,224,151],[185,216,221],[100,155,163],[89,143,154],[89,144,154],[86,141,151],[86,141,152],[85,140,151],[85,141,151],[83,139,150],[83,139,150],[83,139,148],[81,137,145],[81,136,145],[82,135,143],[84,137,144],[85,136,144],[91,137,145],[147,179,185],[170,207,216],[98,150,160],[83,139,150],[80,137,148],[82,140,152],[82,140,151],[83,141,151],[84,140,150],[99,146,155],[176,205,211],[206,227,232],[145,185,192],[93,144,152],[84,137,144],[82,135,142],[81,135,142],[82,135,142],[81,135,142],[100,145,152],[144,188,195],[86,147,155],[81,143,152],[80,142,151],[79,141,150],[83,145,154],[83,145,154],[82,144,153],[87,146,155],[106,146,154],[162,177,207],[102,120,158],[95,114,153],[92,111,151],[92,110,151],[93,111,153],[90,109,150],[96,115,155],[144,162,190],[140,163,200],[86,112,159],[85,112,160],[87,113,161],[87,113,161],[88,114,162],[88,114,162],[88,114,160],[89,116,161],[89,115,161],[87,113,159],[86,113,158],[89,113,159],[89,113,160],[89,113,158],[89,113,157],[91,113,157],[94,116,155],[118,135,168],[191,202,217],[233,226,182],[225,220,107],[227,224,88],[227,224,86],[227,223,85],[227,223,85],[228,224,86],[227,224,90],[228,223,117],[234,228,188],[231,226,174],[224,219,163],[221,216,155],[221,215,152],[222,215,151],[223,216,152],[226,220,155],[232,226,163],[205,228,232],[128,177,185],[92,146,155],[90,146,155],[87,143,152],[86,142,150],[84,140,148],[85,140,149],[84,139,148],[84,140,149],[82,138,146],[82,138,146],[83,136,145],[83,136,143],[84,137,144],[86,135,144],[116,153,160],[205,223,228],[201,226,234],[133,177,186],[96,146,155],[88,139,150],[85,137,149],[86,138,148],[88,140,149],[99,147,157],[166,194,201],[189,217,224],[110,158,166],[86,140,147],[84,138,145],[83,136,143],[83,135,143],[84,136,143],[121,156,162],[187,217,222],[109,165,173],[85,144,153],[81,141,151],[80,141,150],[83,143,152],[82,144,153],[84,146,154],[87,144,151],[138,165,171],[156,170,194],[110,127,161],[94,112,149],[93,110,146],[95,113,149],[110,126,158],[162,176,199],[195,212,234],[88,115,161],[88,114,161],[89,115,162],[88,114,161],[88,115,160],[88,115,161],[88,114,160],[89,116,160],[97,122,165],[109,133,172],[117,139,174],[121,141,175],[123,143,177],[123,142,176],[122,140,173],[121,139,172],[135,152,183],[189,201,222],[231,225,187],[224,219,111],[227,224,89],[227,224,87],[226,223,85],[226,223,85],[226,223,86],[227,224,94],[228,223,135],[166,201,210],[101,153,162],[91,146,155],[89,145,153],[84,140,148],[84,140,149],[85,141,149],[83,139,147],[83,139,147],[82,137,145],[83,137,146],[84,137,145],[84,137,145],[85,137,144],[98,141,148],[179,204,210],[189,213,219],[137,170,178],[113,149,158],[106,142,152],[108,145,153],[130,161,167],[179,200,204],[137,180,187],[92,144,151],[87,139,146],[86,138,145],[86,137,145],[86,136,145],[143,167,172],[167,203,210],[113,160,168],[90,142,150],[86,139,147],[87,140,148],[86,141,149],[92,145,153],[121,163,170],[185,197,216],[150,163,187],[135,149,174],[146,160,185],[189,200,219],[124,147,186],[88,114,158],[91,115,160],[90,115,160],[90,115,160],[91,116,159],[100,122,162],[131,151,183],[167,186,213],[190,208,234],[207,218,234],[208,218,233],[232,227,197],[223,218,118],[227,224,91],[226,223,88],[226,223,87],[226,222,87],[227,224,90],[228,226,101],[231,225,154],[200,222,228],[127,172,182],[95,149,158],[88,143,151],[86,140,149],[85,139,149],[85,139,149],[83,138,147],[85,140,149],[85,139,148],[84,137,146],[86,139,146],[86,139,146],[92,140,148],[154,185,190],[203,220,225],[191,209,214],[182,202,208],[185,204,209],[174,206,213],[115,161,167],[91,139,145],[88,136,142],[86,136,142],[100,143,150],[184,200,204],[178,207,213],[137,172,178],[120,158,164],[117,156,162],[126,165,171],[155,189,196],[201,220,225],[187,205,230],[109,130,166],[93,114,152],[93,115,153],[102,124,162],[122,143,179],[163,182,211],[207,219,235],[226,222,151],[224,222,107],[223,221,95],[223,221,95],[223,221,96],[226,224,103],[229,226,122],[235,229,176],[171,204,212],[120,166,175],[96,147,156],[89,141,150],[88,141,150],[86,139,148],[86,139,149],[87,140,149],[87,140,147],[87,138,146],[87,138,146],[94,143,150],[151,181,188],[168,195,200],[127,159,165],[113,148,152],[123,156,160],[166,190,195],[187,201,221],[153,170,192],[157,173,196],[177,192,213],[203,216,231],[228,225,145],[224,221,125],[222,219,117],[222,219,117],[225,222,126],[231,229,151],[169,203,211],[130,173,181],[104,151,159],[94,142,152],[89,140,148],[88,139,147],[90,139,147],[90,139,148],[95,141,150],[109,149,157],[163,189,193],[196,214,219],[190,211,214],[235,231,188],[229,225,165],[224,220,154],[225,219,155],[229,224,168],[192,214,218],[164,192,197],[137,170,178],[123,158,167],[123,159,167],[127,162,170],[137,169,176],[154,186,191],[185,211,216],[234,231,209],[234,230,209],[206,225,230],[200,221,227],[201,222,228],[204,224,230]]}]}}




		// const tmpData1 = {"result":{"text":[{"left":0.4309999942779541,"right":0.5609999895095825,"top":0.5094433426856995,"bottom":0.5751649737358093,"score":0.8339493274688721,"content":"Cc","characters":[{"character":"C","centerLoc":[0.47766668,0.53908247],"poly":[0.45433334,0.50944334,0.50266665,0.50944334,0.50266665,0.56872165,0.45433334,0.56872165]},{"character":"c","centerLoc":[0.531,0.55068046],"poly":[0.5126667,0.53135055,0.551,0.53135055,0.551,0.56872165,0.5126667,0.56872165]}]}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.4259999990463257,"right":0.5609999895095825,"top":0.5081546306610107,"bottom":0.5777422785758972,"score":0.8703044652938843,"content":"Cc","characters":[{"character":"C","centerLoc":[0.476,0.5377938],"poly":[0.451,0.50815463,0.501,0.50815463,0.501,0.56872165,0.451,0.56872165]},{"character":"c","centerLoc":[0.5276667,0.54939175],"poly":[0.5093334,0.53135055,0.54766667,0.53135055,0.54766667,0.56872165,0.5093334,0.56872165]}]}]}}
		// const tmpData1 =  {"result":{"text":[{"points":[0.749,0.505,0.601,0.522]}]}}
		// const tmpData1 = {"result":{"text":[{"symbol":[4,2,3,3,3]}]}};
		// const tmpData1 = {"result":{"text":[{"points":[0.20666666,0.45618558,0.21,0.45618558,0.21333334,0.45618558,0.21666667,0.45618558,0.22,0.45618558,0.22333333,0.45618558,0.22666667,0.45618558,0.23,0.45618558,0.23333333,0.45618558,0.2,0.45876288,0.20333333,0.45876288,0.20666666,0.45876288,0.21,0.45876288,0.21333334,0.45876288,0.21666667,0.45876288,0.22,0.45876288,0.22333333,0.45876288,0.22666667,0.45876288,0.23,0.45876288,0.23333333,0.45876288,0.23666666,0.45876288,0.24,0.45876288,0.19,0.46134022,0.19333333,0.46134022,0.19666667,0.46134022,0.2,0.46134022,0.20333333,0.46134022,0.20666666,0.46134022,0.21,0.46134022,0.21333334,0.46134022,0.21666667,0.46134022,0.22,0.46134022,0.22333333,0.46134022,0.22666667,0.46134022,0.23,0.46134022,0.23333333,0.46134022,0.23666666,0.46134022,0.24,0.46134022,0.24333334,0.46134022,0.24666667,0.46134022,0.25,0.46134022,0.17666666,0.46391752,0.18333334,0.46391752,0.18666667,0.46391752,0.19,0.46391752,0.19333333,0.46391752,0.19666667,0.46391752,0.24333334,0.46391752,0.24666667,0.46391752,0.25,0.46391752,0.25333333,0.46391752,0.25666666,0.46391752,0.26333332,0.46391752,0.17333333,0.46649486,0.17666666,0.46649486,0.18,0.46649486,0.18333334,0.46649486,0.25666666,0.46649486,0.26,0.46649486,0.26333332,0.46649486,0.26666668,0.46649486,0.17,0.46907216,0.17333333,0.46907216,0.17666666,0.46907216,0.26333332,0.46907216,0.26666668,0.46907216,0.27,0.46907216,0.16333333,0.4716495,0.16666667,0.4716495,0.17,0.4716495,0.17333333,0.4716495,0.26666668,0.4716495,0.27,0.4716495,0.27333334,0.4716495,0.27666667,0.4716495,0.16,0.4742268,0.16333333,0.4742268,0.16666667,0.4742268,0.27333334,0.4742268,0.27666667,0.4742268,0.28,0.4742268,0.15666667,0.47680414,0.16,0.47680414,0.16333333,0.47680414,0.27666667,0.47680414,0.28,0.47680414,0.28333333,0.47680414,0.15666667,0.47938144,0.16,0.47938144,0.28,0.47938144,0.28333333,0.47938144,0.15333334,0.48195878,0.15666667,0.48195878,0.28333333,0.48195878,0.28666666,0.48195878,0.14666666,0.48453608,0.15,0.48453608,0.15333334,0.48453608,0.28666666,0.48453608,0.29,0.48453608,0.29333332,0.48453608,0.14666666,0.48711342,0.15,0.48711342,0.15333334,0.48711342,0.28666666,0.48711342,0.29,0.48711342,0.29333332,0.48711342,0.14333333,0.48969072,0.14666666,0.48969072,0.15,0.48969072,0.29,0.48969072,0.29333332,0.48969072,0.29666665,0.48969072,0.14333333,0.49226806,0.14666666,0.49226806,0.29333332,0.49226806,0.29666665,0.49226806,0.14333333,0.49484536,0.29666665,0.49484536,0.14,0.4974227,0.14333333,0.4974227,0.29666665,0.4974227,0.3,0.4974227,0.14,0.5,0.3,0.5,0.13666667,0.5025773,0.14,0.5025773,0.3,0.5025773,0.30333334,0.5025773,0.13666667,0.5051546,0.14,0.5051546,0.3,0.5051546,0.30333334,0.5051546,0.13333334,0.507732,0.13666667,0.507732,0.14,0.507732,0.3,0.507732,0.30333334,0.507732,0.30666667,0.507732,0.13333334,0.5103093,0.13666667,0.5103093,0.30333334,0.5103093,0.30666667,0.5103093,0.13333334,0.5128866,0.13666667,0.5128866,0.30333334,0.5128866,0.30666667,0.5128866,0.13333334,0.5154639,0.13666667,0.5154639,0.30333334,0.5154639,0.30666667,0.5154639,0.13333334,0.51804125,0.13666667,0.51804125,0.30333334,0.51804125,0.30666667,0.51804125,0.13333334,0.52061856,0.13666667,0.52061856,0.30333334,0.52061856,0.30666667,0.52061856,0.13333334,0.52319586,0.13666667,0.52319586,0.30333334,0.52319586,0.30666667,0.52319586,0.13,0.52577317,0.13333334,0.52577317,0.13666667,0.52577317,0.30333334,0.52577317,0.30666667,0.52577317,0.31,0.52577317,0.13333334,0.52835053,0.13666667,0.52835053,0.30333334,0.52835053,0.30666667,0.52835053,0.13333334,0.53092784,0.13666667,0.53092784,0.30333334,0.53092784,0.30666667,0.53092784,0.13333334,0.53350514,0.13666667,0.53350514,0.30333334,0.53350514,0.30666667,0.53350514,0.13333334,0.53608245,0.13666667,0.53608245,0.30333334,0.53608245,0.30666667,0.53608245,0.13333334,0.5386598,0.13666667,0.5386598,0.30333334,0.5386598,0.30666667,0.5386598,0.13333334,0.5412371,0.13666667,0.5412371,0.30333334,0.5412371,0.30666667,0.5412371,0.13333334,0.5438144,0.13666667,0.5438144,0.14,0.5438144,0.3,0.5438144,0.30333334,0.5438144,0.30666667,0.5438144,0.13666667,0.5463917,0.14,0.5463917,0.3,0.5463917,0.30333334,0.5463917,0.13666667,0.5489691,0.14,0.5489691,0.3,0.5489691,0.30333334,0.5489691,0.14,0.5515464,0.3,0.5515464,0.14,0.5541237,0.14333333,0.5541237,0.29666665,0.5541237,0.3,0.5541237,0.14333333,0.556701,0.29666665,0.556701,0.14333333,0.55927837,0.14666666,0.55927837,0.29333332,0.55927837,0.29666665,0.55927837,0.14333333,0.5618557,0.14666666,0.5618557,0.15,0.5618557,0.29,0.5618557,0.29333332,0.5618557,0.29666665,0.5618557,0.14666666,0.564433,0.15,0.564433,0.15333334,0.564433,0.28666666,0.564433,0.29,0.564433,0.29333332,0.564433,0.14666666,0.5670103,0.15,0.5670103,0.15333334,0.5670103,0.28666666,0.5670103,0.29,0.5670103,0.29333332,0.5670103,0.15333334,0.56958765,0.15666667,0.56958765,0.28333333,0.56958765,0.28666666,0.56958765,0.15666667,0.57216495,0.16,0.57216495,0.28,0.57216495,0.28333333,0.57216495,0.15666667,0.57474226,0.16,0.57474226,0.16333333,0.57474226,0.27666667,0.57474226,0.28,0.57474226,0.28333333,0.57474226,0.16,0.57731956,0.16333333,0.57731956,0.16666667,0.57731956,0.27333334,0.57731956,0.27666667,0.57731956,0.28,0.57731956,0.16333333,0.5798969,0.16666667,0.5798969,0.17,0.5798969,0.17333333,0.5798969,0.26666668,0.5798969,0.27,0.5798969,0.27333334,0.5798969,0.27666667,0.5798969,0.17,0.58247423,0.17333333,0.58247423,0.17666666,0.58247423,0.26333332,0.58247423,0.26666668,0.58247423,0.27,0.58247423,0.17333333,0.58505154,0.17666666,0.58505154,0.18,0.58505154,0.18333334,0.58505154,0.25666666,0.58505154,0.26,0.58505154,0.26333332,0.58505154,0.26666668,0.58505154,0.17666666,0.58762884,0.18333334,0.58762884,0.18666667,0.58762884,0.19,0.58762884,0.19333333,0.58762884,0.19666667,0.58762884,0.24333334,0.58762884,0.24666667,0.58762884,0.25,0.58762884,0.25333333,0.58762884,0.25666666,0.58762884,0.26333332,0.58762884,0.19,0.5902062,0.19333333,0.5902062,0.19666667,0.5902062,0.2,0.5902062,0.20333333,0.5902062,0.20666666,0.5902062,0.21,0.5902062,0.21333334,0.5902062,0.21666667,0.5902062,0.22,0.5902062,0.22333333,0.5902062,0.22666667,0.5902062,0.23,0.5902062,0.23333333,0.5902062,0.23666666,0.5902062,0.24,0.5902062,0.24333334,0.5902062,0.24666667,0.5902062,0.25,0.5902062,0.2,0.5927835,0.20333333,0.5927835,0.20666666,0.5927835,0.21,0.5927835,0.21333334,0.5927835,0.21666667,0.5927835,0.22,0.5927835,0.22333333,0.5927835,0.22666667,0.5927835,0.23,0.5927835,0.23333333,0.5927835,0.23666666,0.5927835,0.24,0.5927835,0.20666666,0.5953608,0.21,0.5953608,0.21333334,0.5953608,0.21666667,0.5953608,0.22,0.5953608,0.22333333,0.5953608,0.22666667,0.5953608,0.23,0.5953608,0.23333333,0.5953608]}]}}


		// const tmpData1 = {"result":{"text":[{"type":1,"points":[0.23666666,0.45360824,0.24,0.45360824,0.22,0.45618558,0.22333333,0.45618558,0.22666667,0.45618558,0.23,0.45618558,0.23333333,0.45618558,0.24333334,0.45618558,0.24666667,0.45618558,0.25,0.45618558,0.25333333,0.45618558,0.25666666,0.45618558,0.26,0.45618558,0.20666666,0.45876288,0.21,0.45876288,0.21333334,0.45876288,0.21666667,0.45876288,0.26333332,0.45876288,0.26666668,0.45876288,0.27,0.45876288,0.27333334,0.45876288,0.19666667,0.46134022,0.2,0.46134022,0.20333333,0.46134022,0.27666667,0.46134022,0.28,0.46134022,0.28333333,0.46134022,0.17666666,0.46391752,0.18,0.46391752,0.18333334,0.46391752,0.18666667,0.46391752,0.19,0.46391752,0.19333333,0.46391752,0.28666666,0.46391752,0.29,0.46391752,0.29333332,0.46391752,0.29666665,0.46391752,0.3,0.46391752,0.30333334,0.46391752,0.30666667,0.46391752,0.31,0.46391752,0.31333333,0.46391752,0.31666666,0.46391752,0.32,0.46391752,0.32333332,0.46391752,0.32666665,0.46391752,0.17,0.46649486,0.17333333,0.46649486,0.28666666,0.46649486,0.33,0.46649486,0.33333334,0.46649486,0.33666667,0.46649486,0.34,0.46649486,0.34333333,0.46649486,0.34666666,0.46649486,0.35,0.46649486,0.35333332,0.46649486,0.35666665,0.46649486,0.36,0.46649486,0.36333334,0.46649486,0.36666667,0.46649486,0.37,0.46649486,0.16666667,0.46907216,0.28666666,0.46907216,0.16333333,0.4716495,0.28666666,0.4716495,0.16333333,0.4742268,0.28666666,0.4742268,0.16333333,0.47680414,0.28666666,0.47680414,0.16,0.47938144,0.28666666,0.47938144,0.16,0.48195878,0.28666666,0.48195878,0.16,0.48453608,0.28666666,0.48453608,0.16,0.48711342,0.29,0.48711342,0.15666667,0.48969072,0.29,0.48969072,0.15333334,0.49226806,0.29,0.49226806,0.15333334,0.49484536,0.29,0.49484536,0.15333334,0.4974227,0.29,0.4974227,0.15,0.5,0.29,0.5,0.15,0.5025773,0.29,0.5025773,0.15,0.5051546,0.29,0.5051546,0.15,0.507732,0.28666666,0.507732,0.15,0.5103093,0.28666666,0.5103093,0.15,0.5128866,0.28666666,0.5128866,0.15,0.5154639,0.28666666,0.5154639,0.15,0.51804125,0.28666666,0.51804125,0.15,0.52061856,0.28666666,0.52061856,0.15,0.52319586,0.28333333,0.52319586,0.15333334,0.52577317,0.28333333,0.52577317,0.15333334,0.52835053,0.28,0.52835053,0.15333334,0.53092784,0.27666667,0.53092784,0.15333334,0.53350514,0.27333334,0.53350514,0.15333334,0.53608245,0.26666668,0.53608245,0.27,0.53608245,0.15333334,0.5386598,0.25666666,0.5386598,0.26,0.5386598,0.26333332,0.5386598,0.15666667,0.5412371,0.25,0.5412371,0.25333333,0.5412371,0.15666667,0.5438144,0.24333334,0.5438144,0.24666667,0.5438144,0.15666667,0.5463917,0.23333333,0.5463917,0.23666666,0.5463917,0.24,0.5463917,0.16,0.5489691,0.23,0.5489691,0.16333333,0.5515464,0.22333333,0.5515464,0.22666667,0.5515464,0.16666667,0.5541237,0.17,0.5541237,0.17333333,0.5541237,0.17666666,0.5541237,0.18,0.5541237,0.18333334,0.5541237,0.18666667,0.5541237,0.19,0.5541237,0.19333333,0.5541237,0.19666667,0.5541237,0.2,0.5541237,0.20333333,0.5541237,0.20666666,0.5541237,0.21,0.5541237,0.21333334,0.5541237,0.21666667,0.5541237,0.22,0.5541237]}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.22833333909511566,"right":0.3166666626930237,"top":0.5590206384658813,"bottom":0.628608226776123,"score":0.8552894592285156,"content":"Aa"},{"left":0.6816666126251221,"right":0.7666666507720947,"top":0.42257729172706604,"bottom":0.49860823154449463,"score":0.8148108720779419,"content":"Aa"},{"left":0.6983333230018616,"right":0.7666666507720947,"top":0.5564433336257935,"bottom":0.628608226776123,"score":0.7532452344894409,"content":"Aa"}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.09814612567424774,"right":0.4471101462841034,"top":0.006644518114626408,"bottom":0.15614618360996246,"score":1,"content":"CTrace,write,and say."},{"left":0.10796073824167252,"right":0.5049073100090027,"top":0.1827242523431778,"bottom":0.4518272280693054,"score":0.9702169299125671,"content":"AAAA"},{"left":0.5834242105484009,"right":0.659760057926178,"top":0.17607973515987396,"bottom":0.4485049843788147,"score":0.9523985981941223,"content":"A"},{"left":0.6706652045249939,"right":0.8298800587654114,"top":0.15614618360996246,"bottom":0.43853819370269775,"score":0.9089533090591431,"content":"A"},{"left":0.5866957306861877,"right":0.6521264910697937,"top":0.634551465511322,"bottom":0.8504983186721802,"score":0.8326067328453064,"content":"a"},{"left":0.7699018716812134,"right":0.8276990056037903,"top":0.6411960124969482,"bottom":0.8039867281913757,"score":0.8035371899604797,"content":"a"}]}}
		cb(tmpData1);
		return;
	// const tmpData = {"allText":"Look and Trace\nblackboard\nwindow","block":[{"line":[{"word":[{"content":"Look","cornerPoint":[{"x":87,"y":203},{"x":83,"y":166},{"x":93,"y":164},{"x":97,"y":201}],"location":{"bottom":97,"left":85,"right":124,"top":83},"recognizedLanguage":"und"},{"content":"and","cornerPoint":[{"x":85,"y":161},{"x":82,"y":138},{"x":90,"y":137},{"x":93,"y":160}],"location":{"bottom":93,"left":127,"right":151,"top":82},"recognizedLanguage":"und"},{"content":"Trace","cornerPoint":[{"x":81,"y":132},{"x":77,"y":96},{"x":86,"y":95},{"x":90,"y":131}],"location":{"bottom":90,"left":156,"right":193,"top":77},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"blackboard","cornerPoint":[{"x":119,"y":129},{"x":116,"y":58},{"x":131,"y":57},{"x":134,"y":128}],"location":{"bottom":134,"left":159,"right":231,"top":116},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"window","cornerPoint":[{"x":171,"y":123},{"x":166,"y":72},{"x":177,"y":70},{"x":182,"y":121}],"location":{"bottom":182,"left":165,"right":218,"top":166},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"Trace ttre letters\nLook! She is Short\nShe is a\ngirl.\nShe is a\ngirl.\nShe is smiling. She is","block":[{"line":[{"word":[{"content":"Trace","cornerPoint":[{"x":460,"y":366},{"x":416,"y":366},{"x":416,"y":354},{"x":460,"y":354}],"location":{"bottom":126,"left":20,"right":64,"top":114},"recognizedLanguage":"und"},{"content":"ttre","cornerPoint":[{"x":412,"y":367},{"x":387,"y":367},{"x":387,"y":354},{"x":412,"y":354}],"location":{"bottom":126,"left":68,"right":93,"top":113},"recognizedLanguage":"und"},{"content":"letters","cornerPoint":[{"x":384,"y":367},{"x":334,"y":367},{"x":334,"y":354},{"x":384,"y":354}],"location":{"bottom":126,"left":96,"right":146,"top":113},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Look!","cornerPoint":[{"x":340,"y":316},{"x":300,"y":318},{"x":299,"y":305},{"x":339,"y":303}],"location":{"bottom":177,"left":140,"right":181,"top":162},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"e-Tnace the lettEr5\nAa Aa\nAa\nB b Bb Bbb\nBb\nCc\nCc","block":[{"line":[{"word":[{"content":"e-Tnace","cornerPoint":[{"x":399,"y":393},{"x":317,"y":395},{"x":316,"y":379},{"x":398,"y":377}],"location":{"bottom":103,"left":81,"right":164,"top":85},"recognizedLanguage":"und"},{"content":"the","cornerPoint":[{"x":313,"y":396},{"x":282,"y":396},{"x":281,"y":380},{"x":312,"y":380}],"location":{"bottom":100,"left":167,"right":199,"top":84},"recognizedLanguage":"und"},{"content":"lettEr5","cornerPoint":[{"x":278,"y":397},{"x":217,"y":398},{"x":216,"y":382},{"x":277,"y":381}],"location":{"bottom":99,"left":202,"right":264,"top":82},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Aa","cornerPoint":[{"x":436,"y":362},{"x":349,"y":363},{"x":348,"y":322},{"x":435,"y":321}],"location":{"bottom":159,"left":44,"right":132,"top":117},"recognizedLanguage":"und"}]}]}]}

		cb(tmpData);
	},


	checkOneCombineGroupEnd(node) {

		const signItem = node.data.signItem;

		for (let i=0; i<this.itemCombineGroup.length; i++) {
			const key1 = this.itemCombineGroup[i][0] + 1;
			const key2 = this.itemCombineGroup[i][1] + 1;

			if (key1 == signItem || key2 == signItem) {

				let item1, item2;
				for (let j=0; j<this.signAnimaNodeArr.length; j++) {
					const data = this.signAnimaNodeArr[j].data;
					if (data.signItem == key1) {
						item1 = this.signAnimaNodeArr[j];
					} else if (data.signItem == item2) {
						item2 =  this.signAnimaNodeArr[j];
					}
				}

				if (item1?.isShowEnd || item2?.isShowEnd) {
					return true;
				}
				return false;
			}
			
		}
	},

	checkGameEndCombineGroup() {
		// const arr = this.signAnimaNodeArr;
		console.log(' in checkGameEndCombineGroup');

		for (let i=0; i<this.itemCombineGroup.length; i++) {
			const key1 = this.itemCombineGroup[i][0] + 1;
			const key2 = this.itemCombineGroup[i][1] + 1;

			let item1, item2;

			for (let j=0; j<this.signAnimaNodeArr.length; j++) {
				const data = this.signAnimaNodeArr[j].data;
				if (data.signItem == key1) {
					item1 = this.signAnimaNodeArr[j];
				} else if (data.signItem == key2) {
					item2 =  this.signAnimaNodeArr[j];
				}
			}

			if (!item1.isShowEnd && !item2.isShowEnd) {
				this.resetHelperTime();
				return;
			}
			
		}

		this.gameEnd();
	},


	checkGameEnd( arr ) {

		this.pauseHelper()

		console.log(' in checkGameEnd arr.length: ', arr.length);
		if (!arr) {
			arr = this.animaNodeArr;
		}
		const isEnd = arr.every(node => {
			return node.isShowEnd;
		})

		if (isEnd) {
			this.gameEnd();
		} else {

			this.resetHelperTime();

			// this.endTesting();

			// setTimeout(() => {
			// 	this.startTesting();
			// }, 8000);

		}
	},














	bigStarArr: null,
	initStar() {
		const gArr = this.data.groupArr;
		if (gArr.length <= 1) {
			return;
		}

		this.cleanStar();

		this.bigStarArr = [];

		let baseX = this.canvas.width / 2 - 80 * this._mapScaleMin;
		let baseY = this.canvas.height / 2 - 80 * this._mapScaleMin;
		let disH = 80 * this._mapScaleMin;
		let disScale = 1;
		if (gArr.length > 5) {
			disH = (400 / gArr.length) * this._mapScaleMin;
			disScale = 5 / gArr.length;
		}
		for (let i = 0; i < gArr.length; i++) {
			const starBg = getSprNode('star_bg');
			this.canvas.addChild(starBg, 10);
			starBg.x = baseX;
			starBg.y = baseY - i * disH;
			starBg.scale = disScale;

			const starTop = getSprNode('star');
			starBg.addChild(starTop);
			starTop.active = false;
			starBg.star = starTop;

			const starBig = getSprNode('icon_bigstar');
			starTop.addChild(starBig);
			starBig.angle = -90;
			starBg.starBig = starBig;

			this.bigStarArr.push(starBg);
		}

		console.log("bigStarArr: ", this.bigStarArr);
	},

	cleanStar() {
		if (this.bigStarArr && this.bigStarArr.length > 0) {
			for (let i=0; i<this.bigStarArr.length; i++) {
				this.bigStarArr[i].removeFromParent();
			}
		}
	},


	showBigStar() {
		if (!this.bigStarArr || this.bigStarArr.length <= 0) {
			this.checkGameEnd();
			return;
		}
		const bigStarBg = this.bigStarArr[this.curGroupIndex];

		const starBig = bigStarBg.starBig;
		starBig.scale = 1;
		const star = bigStarBg.star;
		star.active = true;
		star.scaleX = 0.7 / bigStarBg.scale;
		star.scaleY = 1 / bigStarBg.scale;
		star.angle = 90;
		const canvas = cc.find('Canvas');
		const startPos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 2));
		const middlePos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 4));
		star.x = startPos.x;
		star.y = startPos.y - starBig.height;

		console.log('middlePos = ' + JSON.stringify(middlePos));
		const time = 1;
		cc.tween(star)
			.to(0.3, { y: middlePos.y + 80 }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y + 40, scaleX: 1.2 / bigStarBg.scale, scaleY: 0.8 / bigStarBg.scale }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y, scaleX: 1 / bigStarBg.scale, scaleY: 1 / bigStarBg.scale }, { easing: 'quadOut' })
			.delay(0.1)
			.to(0.8, { angle: -720, scale: 1 })
			.start();

		cc.tween(star)
			.delay(0.6)
			.to(0.8, { x: 0 }, { easing: 'quadIn' })
			.start();
		cc.tween(star)
			.delay(0.6)
			.to(0.8, { y: 0 }, { easing: 'quadOut' })
			.start();

		cc.tween(starBig)
			.delay(0.6)
			.to(0.8, { scale: 0 }, { easing: 'quadOut' })
			.call(() => {
				this.checkGameEnd();
				playAudio(this.starCountClip);
			})
			.start();

		playAudio(this.bigStarClip);
	},

	// checkGameEnd() {
	
	// 	this.curGroupIndex ++;
	// 	this.setCurGroupAndQuestion();



	// 	if (!this.curQuestionData) {
	// 		// this.gameEnd();
	// 		return;
	// 	}

	// 	this.showChangeQuesAnim();
	// },

	


	checkBtn: null,
	initBtn() {
		const checkBtn = getSprNode("btn_check");
		checkBtn.scale = this._mapScaleMin;
		this.canvas.addChild(checkBtn);
		checkBtn.x = -500 * this._mapScaleMin;
		checkBtn.y = -35 * this._mapScaleMin;
		checkBtn.baseX = checkBtn.x;
		checkBtn.baseY = checkBtn.y;
		checkBtn.opacity = 0;
		this.checkBtn = checkBtn;

		checkBtn.on(cc.Node.EventType.TOUCH_START, () => {
			if (checkBtn.opacity == 0) {
				return;
			}
			showBtnAnima(checkBtn);
			this.checkBtnClick();
		})

	},

	refreshCheckBtn() {

		this.checkBtn.opacity = 0;

		const arr = this.curOptionArr;
		for (let i=0; i<arr.length; i++) {
			if (arr[i].light.opacity > 254) {
				this.checkBtn.opacity = 255;
				return;
			}
		}
	},

	tryagain: null,
	initIcon() {
		const icon = getSprNode("try_again");
		icon.opacity = 0;
		icon.scale = this._mapScaleMin;
		this.canvas.addChild(icon);

		this.tryagain = icon;
	},

	showTryAgain() {
		const time = 0.3;
		cc.tween(this.tryagain)
			.to(time, {opacity: 255}, {easing: "cubicOut"})
			.delay(0.3)
			.to(time, {opacity: 0}, {easing: "cubicIn"})
			.start();
	},


	initQuestion() {
		this.initPicQuestion();
		this.initTextQuestion();
		this.initVideoQuestion();
		this.initAudioQuestion();
	},

	quesPicBg: null,
	initPicQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesPicBg = picBg;
		picBg.active = false;

		this.addQuesAudio(picBg)
	},

	quesTextBg: null,
	initTextQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesTextBg = picBg;


		const labelNode = new cc.Node();
		labelNode.parent = picBg;
		const label = labelNode.addComponent(cc.RichText);
		const size = 80
		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		// label.string = `<outline color=#a83c13 width=2><size=${size}><color=#ffffff>${this.data.title || " " }</color></size></outline>`
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.CENTER

		label.maxWidth = 648;
	
		picBg.label = label;

		picBg.active = false;
		this.addQuesAudio(picBg)
	},

	quesVideoBg: null,
	videoNode: null,
	initVideoQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesVideoBg = picBg;

		const videoNode = new cc.Node();
		const vPlayer = videoNode.addComponent(cc.VideoPlayer);
		picBg.addChild(videoNode);

		videoNode.width = 678;
		videoNode.height = 396;
		this.videoNode = videoNode;

		picBg.video = vPlayer;


		const btnNode = new cc.Node();
		picBg.addChild(btnNode);
		btnNode.x = picBg.width / 2 + 50;

		const playBtn = getSprNode("video_play");
		btnNode.addChild(playBtn);

		const pauseBtn = getSprNode("video_pause");
		btnNode.addChild(pauseBtn);
		pauseBtn.active = false;


		videoNode.player = vPlayer;
		videoNode.playBtn = playBtn;
		videoNode.pauseBtn = pauseBtn;

		playBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.play();
			playBtn.active = false;
			pauseBtn.active = true;
		})

		pauseBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.pause();
			pauseBtn.active = false;
			playBtn.active = true;
		})

		videoNode.on('completed', () => {
			pauseBtn.active = false;
			playBtn.active = true;
		})


		picBg.active = false;
	},

	quesAudioBg: null,
	initAudioQuestion() {

		
		const audioNode = new cc.Node();
		audioNode.active = false;

		this.canvas.addChild(audioNode);
		audioNode.x = 440 * this._mapScaleMin;
		audioNode.y = -60 * this._mapScaleMin;
		this.quesAudioBg = audioNode;
		
		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/audio_big"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('audio_big')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}

			if (!audioNode.audioClip) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('audio_big');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

	},


	addQuesAudio(bg) {
		const audioNode = new cc.Node();
		bg.addChild(audioNode);
		audioNode.x = bg.width / 2 + 50;


		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/ques_audio"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('ques_audio')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('ques_audio');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

		bg.audioNode = audioNode;
	},

	initOption() {
		this.initPicOption();
		this.initAudioOption();
		this.initTextOption();

		this.initPicOptionBig();
		this.initAudioOptionBig();
		this.initTextOptionBig();
	},

	optionPicBgArr: null,
	initPicOption() {
		// console.log('this.data: ', this.data);
		this.optionPicBgArr = [];
		for (let i=0; i<4; i++) {
		
			const pic = this.getOnePicOption();
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.y = -235 * this._mapScaleMin;
			this.optionPicBgArr.push(pic);

		} 
	},

	optionPicBgBigArr: null,
	initPicOptionBig() {
		this.optionPicBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;


		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}
			const pic = this.getOnePicOption(true);
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.x = baseX + count * disW;
			pic.y = baseY;
			this.optionPicBgBigArr.push(pic);

			count ++;
		} 
	},

	getOnePicOption(isBig = false) {
		const picBgParent = new cc.Node();

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const light = getSprNode(lightResName);
		picBgParent.addChild(light);
		light.opacity = 0;
		picBgParent.light = light;

		const picBg = getSprNode(bgResName);
		picBgParent.addChild(picBg);
		picBgParent.picBg = picBg;

		picBgParent.width = picBg.width;
		picBgParent.height = picBg.height;


		const soundNode = new cc.Node();
		picBgParent.addChild(soundNode);
		picBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = picBgParent.width / 2 - soundIconTop.width / 2;
		soundNode.y = picBgParent.height / 2 //- soundIconTop.height / 2;
		soundNode.active = false;


		picBgParent.active = false;


		picBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}

			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return picBgParent;
	},

	addIconRight(bg) {

		const px = bg.width / 2;
		const py = -bg.height / 2 ;
		const worldPos = bg.convertToWorldSpaceAR(cc.v2(px, py));
		const localPos = this.canvas.convertToNodeSpaceAR(worldPos);


		const iconRight = getSprNode('icon_right');
		iconRight.scale = this._mapScaleMin;
		this.canvas.addChild(iconRight, 1);
		iconRight.x = localPos.x;
		iconRight.y = localPos.y + 50 * this._mapScaleMin;

		bg.iconRight = iconRight;


		this.showOneFirework(cc.v2(0, -bg.height / 3), bg, cc.find('paperBase').children, 200, 300, 20, 1);
	},


	optionAudioBgArr: null,
	initAudioOption() {
		this.optionAudioBgArr = [];
		for (let i=0; i<4; i++) {
		
			const audio = this.getOneAudioOption();
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.y = -235 * this._mapScaleMin;
			this.optionAudioBgArr.push(audio);
		} 
	},

	optionAudioBgBigArr: null,
	initAudioOptionBig() {

		this.optionAudioBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;

		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}

			const audio = this.getOneAudioOption(true);
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.x = baseX + count * disW;
			audio.y = baseY;
			this.optionAudioBgBigArr.push(audio);

			count ++;
		} 
	},


	optionTextBgArr: null,
	initTextOption() {
		this.optionTextBgArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption();
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			// textOption.y = -235 * this._mapScaleMin;
			this.optionTextBgArr.push(textOption);
		} 
	},

	optionTextBgBigArr: null,
	initTextOptionBig() {

		const baseX = -180 * this._mapScaleMin;
		const disW = 100 * this._mapScaleMin;
		let baseY = 220 * this._mapScaleMin;
		const disH = 150 * this._mapScaleMin;

		this.optionTextBgBigArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption(true);
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			textOption.x = baseX;
			textOption.y = baseY - i * disH;
			this.optionTextBgBigArr.push(textOption);
		}
	},

	getOneAudioOption(isBig=false) {

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const audioBgNode = new cc.Node();

		const light = getSprNode(lightResName);
		audioBgNode.addChild(light);
		light.opacity = 0;
		audioBgNode.light = light;

		const picBg = getSprNode(bgResName);
		audioBgNode.addChild(picBg);
		audioBgNode.picBg = picBg;

		audioBgNode.width = picBg.width;
		audioBgNode.height = picBg.height;

		const animNode = cc.instantiate(cc.find("Canvas/res/anim/op_audio"))
		audioBgNode.addChild(animNode);
		animNode.anchorX = 0.6;


		const animTop = getSprNode('op_audio');
		audioBgNode.addChild(animTop);
		animTop.anchorX = 0.6;

		const anim = animNode.getComponent(cc.Animation);
		animNode.opacity = 0;

		audioBgNode.anim = anim;
		audioBgNode.animNode = animNode;
		audioBgNode.animTop = animTop;
		
		audioBgNode.showAnim = () => {
			this.playItemAnim(audioBgNode);
			cc.audioEngine.stop(audioBgNode.audioId);
		}
		audioBgNode.stopAnim = () => {
			cc.audioEngine.stop(audioBgNode.audioId);
			this.stopItemAnim(audioBgNode);
		}

		audioBgNode.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
				
				audioBgNode.showAnim();
				if (audioBgNode.audioClip) {
					audioBgNode.audioId = playAudio(audioBgNode.audioClip, () => {
						this.stopItemAnim(audioBgNode);
					});
				}

			} else {
				light.opacity = 0;
				audioBgNode.stopAnim();
			}

			this.refreshCheckBtn();

		});

		audioBgNode.active = false;

		return audioBgNode;
	},

	getOneTextOption(isBig=false) {

		let lightResName = "option_text_bg_l";
		let bgResName = "option_text_bg";
		if (isBig) {
			lightResName = "op_text_bg_big_l";
			bgResName = "op_text_bg_big";
		}

		const textBgParent = new cc.Node();
		textBgParent.active = false;

		const light = getSprNode(lightResName);
		textBgParent.addChild(light);
		light.opacity = 0;
		textBgParent.light = light;

		const textBg = getSprNode(bgResName);
		textBgParent.addChild(textBg);
		textBgParent.textBg = textBg;

		textBgParent.width = textBg.width;
		textBgParent.height = textBg.height;

		const labelNode = new cc.Node();
		labelNode.parent = textBgParent;
		const label = labelNode.addComponent(cc.Label);

		label.fontSize = 56;
		label.lineHeight = 56;
		if (isBig) {
			label.fontSize = 64;
			label.lineHeight = 64;
		}

		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		textBgParent.label = label;

		const color = new cc.Color();
		cc.Color.fromHEX(color, '#023659' );
		labelNode.color = color;


		const soundNode = new cc.Node();
		textBgParent.addChild(soundNode);
		textBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = textBgParent.width / 2 - 15; // - soundIconTop.width / 2;
		soundNode.y = textBgParent.height / 2 - 15; //- soundIconTop.height / 2;
		soundNode.active = false;


		textBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}
			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return textBgParent;
	},

	playItemAnim(item) {
		item.anim.play();
		item.animNode.opacity = 255;
		item.animTop.opacity = 0;
	},

	stopItemAnim(item) {
		item.animNode.opacity = 0;
		item.animTop.opacity = 255;
	},

	setCurQuestion() {
		
		switch(this.curQuestionData.questionType) {
			case "pic":
				this.setQuestionPic();
				break;
			case "text":
				this.setQuestionText();
				break;
			case "video":
				this.setQuestionVideo();
				break;
			case "audio":
				this.setQuestionAudio();
				break;
		}

		this.refreshCheckBtnPos();
	},

	refreshCheckBtnPos() {
		if (this.curQuestionData.questionType == 'audio') {
			this.checkBtn.x = 440 * this._mapScaleMin;
			this.checkBtn.y = -240 * this._mapScaleMin;
		} else {
			this.checkBtn.x = this.checkBtn.baseX;
			this.checkBtn.y = this.checkBtn.baseY;
		}
	},

	curQuesBg: null,
	setQuestionPic() {

		this.curQuesBg = this.quesPicBg;
		this.curQuesBg.active = true;


		if (this.quesPicBg.pic) {
			this.quesPicBg.pic.removeFromParent();
			this.quesPicBg.pic = null;
		}
		if (this.curQuestionData.pic_url) {
			getSprNodeByUrl(this.curQuestionData.pic_url, (spr) => {
				const sprNode = spr.node;
				setSprNodeMaxLen(sprNode, 678, 396);
				this.quesPicBg.addChild(sprNode)
				this.quesPicBg.pic = sprNode;
			})
		}
	
		const audioNode = this.quesPicBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionText() {
		this.curQuesBg = this.quesTextBg;
		this.curQuesBg.active = true;

		
		const label = this.curQuesBg.label;
		const size = 80; 
		label.string = `<size=${size}><color=#fff4b6>${this.curQuestionData.text}</color></size>`

		const maxH = this.curQuesBg.height * 0.98;

		if (label.node.height > maxH) {
			label.node.scale = maxH / label.node.height
		} else {
			label.node.scale = 1;
		}


		const audioNode = this.curQuesBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionVideo() {
		this.curQuesBg = this.quesVideoBg;
		this.curQuesBg.active = true;
		this.videoNode.active = true;

		if (this.curQuestionData.video_url) {
			this.curQuesBg.video.remoteURL = this.curQuestionData.video_url;
		}
	},

	setQuestionAudio() {
		this.curQuesBg = this.quesAudioBg;
		this.curQuesBg.active = true;


		this.curQuesBg.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				this.curQuesBg.audioClip = audioClip;
			});
		}
	},



	setCurOption() {
		const arr = this.curQuestionData.answerArr;

		const isBig = this.curQuestionData.questionType == 'audio';

		switch(this.curQuestionData.answerType) {
			case "pic":
				this.setOptionPic(arr, isBig);
				break;
			case "audio":
				this.setOptionAudio(arr, isBig);
				break;
			case "text":
				this.setOptionText(arr, isBig);
				break;
		}
		
	},



	curOptionArr: null,
	setOptionPic(arr, isBig=false) {

		let opItemArr = this.optionPicBgArr;
		if (isBig) {
			opItemArr = this.optionPicBgBigArr;
		}
		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const picBg = opItemArr[i].picBg;
			picBg.removeAllChildren();
			
			const data = arr[i];
			if (data.pic_url) {
				getSprNodeByUrl, getSprNodeByUrl(data.pic_url, (spr) => {
					let maxW = 280;
					let maxH = 190;
					if (isBig) {
						maxW = 366;
						maxH = 248;
					}

					setSprNodeMaxLen(spr.node, maxW, maxH);
					console.log('spr: ', spr);
					picBg.addChild(spr.node);
				})
			}

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},


	setOptionAudio(arr, isBig=false) {

		let opItemArr = this.optionAudioBgArr;
		if (isBig) {
			opItemArr = this.optionAudioBgBigArr;
		}

		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if(!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const data = arr[i];

			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					opItemArr[i].audioClip = audioClip;
				});
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},

	setOptionAudioBig(arr) {
		this.curOptionArr = [];
		for (let i=0; i<arr.length; i++) {
			
			this.optionAudioBgArr[i].active = true;

			const data = arr[i];

			this.optionAudioBgArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					this.optionAudioBgArr[i].audioClip = audioClip;
				});
			}

			this.optionAudioBgArr[i].data = data;
			this.curOptionArr.push(this.optionAudioBgArr[i]);
		}
	},


	setOptionText(options, isBig=false) {

		console.log(' in setOptionText, isBig: ', isBig);

		let opItemArr = this.optionTextBgArr;
		if (isBig) {
			opItemArr = this.optionTextBgBigArr
		}

		this.curOptionArr = [];
		const disW = 315 * this._mapScaleMin;
		const disH = 120 * this._mapScaleMin;
		const baseX = - disW ;
		let baseY = -235 * this._mapScaleMin;
		if (options.length > 2) {
			baseY = -170 * this._mapScaleMin;
		}
		let count = 0;
		for (let i=0; i<options.length; i++) {

			if ( i == 2 ) {
				baseY -= disH;
				count = 0;
			}
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + count * disW * 2;
				opItemArr[i].y = baseY;
			}
		
			const data = options[i];

			opItemArr[i].label.string = data.text;
			opItemArr[i].label["_forceUpdateRenderData"](true);
			if (opItemArr[i].label.node.width > opItemArr[i].width * 0.9) {
				opItemArr[i].label.node.scale = opItemArr[i].width * 0.9 / opItemArr[i].label.node.width;
			} else {
				opItemArr[i].label.node.scale = 1;
			}
			

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);

			count++;
		}
	},



	shakeArr: null,
	wrongArr: null,
	checkBtnClick() {

		this.shakeArr = [];
		this.wrongArr = [];
		this.checkItemWrong();

		if (this.wrongArr.length > 0) {
			//有选错的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		const isRightAll = this.checkItemRightCount();
		if (!isRightAll) {
			// 有漏选的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		this.showAllRight();
		this.showMask();

		playAudio(this.rightClip, () => {
			this.playAnswerAudio(0);
		})
		
	},

	playAnswerAudio(index) {
		const arr = this.curOptionArr;
		if (!arr[index]) {

			// delayCall(0.5, () => {
				this.changeNextQuestion();
			// })

		} else {
			if ( arr[index].light.opacity > 254 && arr[index].audioClip ) {
				playAudio(arr[index].audioClip, () => {
					this.playAnswerAudio(index + 1);
				})
			} else {
				this.playAnswerAudio(index + 1);
			}
		}
	},


	checkItemWrong() {
		const arr = this.curOptionArr;
		console.log('arr: ', arr);
		for (let i=0; i<arr.length; i++) {
			const itemBg = arr[i];
			if (itemBg.light.opacity >= 254) {
				this.shakeArr.push(itemBg);
				console.log('aaa', itemBg.data);;
				if (itemBg.data.answerRight == '0') {
					this.wrongArr.push(itemBg);
				}
			}
		}
	},

	checkItemRightCount() {
		let rightTotalCount = 0;
		const answerArr = this.curQuestionData.answerArr;
		for (let i=0; i<answerArr.length; i++) {
			if (answerArr[i].answerRight == '1') {
				rightTotalCount ++;
			}
		}

		let curRightCount = 0;
		const curOptionArr = this.curOptionArr;
		for (let i=0; i<curOptionArr.length; i++) {
			if (curOptionArr[i].light.opacity > 254) {
				curRightCount ++;
			}
		}

		return rightTotalCount == curRightCount;
	},

	itemShake() {
		let rate = 1;
		if (this.curQuestionData.answerType == 'text') {
			rate = 0.5;
		}

		const arr = this.shakeArr;
		for (let i=0; i<arr.length; i++) {
			this.rotateShake(arr[i], rate);
			if (arr[i].stopAnim) {
				arr[i].stopAnim();
			}
		}

		this.showTryAgain();
	},

	hideLight() {
		const arr = this.curOptionArr;
		for (let i=0; i<arr.length; i++) {
			arr[i].light.opacity = 0;
		}
		this.checkBtn.opacity = 0;
	},

	rotateShake(item, rate = 1) {

		const time = 0.9;
		cc.tween(item)
			.to(time / 6 / 2, {angle: -20 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 12 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: -7 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 4 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: -2 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 1 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 0 * rate}, {easing: 'sineInOut'})
			.start();

	},

	showAllRight() {
		const curOptionArr = this.curOptionArr;
		for (let i=0; i<curOptionArr.length; i++) {
			if (curOptionArr[i].light.opacity > 254) {
				this.addIconRight(curOptionArr[i]);
			}
		}
	},

	changeNextQuestion() {
		console.log(' in changeNextQuestion')

		this.curQuestionIndex ++ ;
		this.setCurQuestionData();

		if (!this.curQuestionData) {
			// this.gameEnd();
			return;
		}

		this.showChangeQuesAnim();
	
	},

	showChangeQuesAnim() {
		this.hideLight();

		this.hideCurOptionAnim(() => {
			this.setCurOption();
			this.showCurOptionAnim();
			this.hideMask();
		});

		this.hideCurQuestion(() => {
			this.setCurQuestion();
			this.showCurQuestionAnim();
		});
	},


	maskLayer: null,
	initMask() {
		const maskLayer = new cc.Node();
		maskLayer.width = this.canvas.width;
		maskLayer.height = this.canvas.height;
		this.canvas.addChild(maskLayer, 20);

		maskLayer.addComponent(cc.BlockInputEvents);
		this.maskLayer = maskLayer;
		this.maskLayer.active = false;
	},

	showMask() {
		this.maskLayer.active = true;
	},

	hideMask() {
		this.maskLayer.active = false;
	},

	hideCurOptionAnim(cb) {
		const arr = this.curOptionArr;
		const time = 0.5;
		for (let i=0; i<arr.length; i++) {
			if (arr[i].iconRight) {
				arr[i].iconRight.removeFromParent();
				arr[i].iconRight = null;
			}
			cc.tween(arr[i])
				.to(time, {opacity: 0}, {easing: "cubicOut"})
				.call(() => {
					arr[i].active = false;
				})
				.start();
		}
		delayCall(time, () => {
			cb();
		})
	},

	showCurOptionAnim(cb=null) {
		const arr = this.curOptionArr;
		const time = 0.5;
		for (let i=0; i<arr.length; i++) {
			arr[i].opacity = 0;
			cc.tween(arr[i])
				.to(time, {opacity: 255}, {easing: "cubicIn"})
				.start();
		}

		if (cb) {
			delayCall(time, () => {
				cb();
			})
		}
	
	},

	hideCurQuestion(cb) {
		const time = 0.5;
		cc.tween(this.curQuesBg)
			.to(time, {opacity: 0}, {easing: "cubicOut"})
			.call(() => {
				this.curQuesBg.active = false;
				cb();
			})
			.start();
	},

	showCurQuestionAnim() {

		this.curQuesBg.active = true;
		this.curQuesBg.opacity = 0;

		const time = 0.5;
		cc.tween(this.curQuesBg)
			.to(time, {opacity: 255}, {easing: "cubicIn"})
			.start();
	},


	changeStep() {

		this.typeArrIndex ++;
		this.curCatAudioUrl = this.data.idle_2_audio_url;
		
		if (!this.data.change_step_audio_url) {
			this.startTesting();
			return;
		}
		playAudioByUrl(this.data.change_step_audio_url, () => {
			this.startTesting();
		})

	},

	gameEnd() {
		console.log('game end !')

		this.isGameEnd = true;
		this.endTesting();


		if (this.typeArrIndex < this.typeArr.length - 1) {

			this.changeStep();

			return;
		}





		// this.showRestart();
		// this.showGoodjob();
		// this.showOneFirework(cc.v2(0, -this.canvas.height / 2), this.canvas, cc.find('paperBase').children, this.canvas.width / 2.5, this.canvas.height * 2, 100, 1);
		playAudio(this.finishClip);

		if (!this.data.finish_right_audio_url) {
			const endData = this.getEndData();
			onHomeworkFinish(endData);
		}
		
		playAudioByUrl(this.data.finish_right_audio_url, () => {
			const endData = this.getEndData();
			onHomeworkFinish(endData);
		})

	

		const camera = cc.find('Canvas/Main Camera');
		camera.zIndex = 100;

		showTrebleFirework(camera, cc.find('RibbonNodeBase').children);


	

	},

	getEndData() {

		return {};

		const arr = this.picNodeArr;
		const customData = [];
		let stone = 0;
		const oneQuesStone = 10 / arr.length;
		arr.forEach(node => {
			customData.push({isRight: node.isRight})
			if (node.isRight) {
				stone += oneQuesStone;
			}
		})
		stone = Math.round(stone * 10) / 10;
		return {customData, stone};
	},

	showGoodjob() {

		const icon = getSprNode("goodjob");
		icon.scale = this._mapScaleMin;
		icon.baseS = icon.scale;
		this.canvas.addChild(icon, 20);


		const time = 1;
		icon.scale = 0;
		cc.tween(icon)
			.to(0.8,  {scale: icon.baseS}, {easing: "elasticOut"})
			.delay(1)
			.to(0.5, {scale: 0} , {easing: "cubicIn"})

			.start();



	},

	showRestart() {

		const btn = getSprNode("btn_restart");
		btn.scale = this._mapScaleMin;
		btn.baseS = btn.scale;
		this.canvas.addChild(btn, 21);

		btn.on(cc.Node.EventType.TOUCH_START, () => {
			// btn.removeFromParent();
			// this.initData();
			// this.initStar();
			// this.showChangeQuesAnim();
			// playAudio(this.btnClip);

			const middleLayer = cc.find('middleLayer');
			if (middleLayer) {
				middleLayer.getComponent('middleLayer').reloadBundle();
			}
		})

		const time = 0.9;
		btn.scale = 0;
		cc.tween(btn)
			.delay(2.5)
			.to(time,  {scale: btn.baseS}, {easing: "elasticOut"})
			.start();

	},



	async showOneFirework(pos, parentNode, nodeList, w, h, n, timeRate=1) {

		for (let i = 0; i < 3; i++) {
				this.showFirework(pos, parentNode, nodeList, w, h, n, timeRate);
				await asyncDelay(0.1);
		}
	},

	showFirework(pos, parentNode, nodeList, width = 200, height = 500, number = 30, timeRate=1) {
			const subTime = 1;
			for (let i = 0; i < number; i++) {
					const quad = this.createQuads(pos, parentNode, nodeList);
					const targetX = RandomInt(width / 2, -width / 2);
					const targetY = RandomInt(height);

					cc.tween(quad)
							.by(0.5 * timeRate, { x: targetX })
							.by((2 + subTime *  Math.random()) * timeRate, { x: targetX * 2 })
							.start();

					cc.tween(quad)
							.by(0.5 * timeRate, { y: targetY }, { easing: 'quadOut' })
							.to((3 + subTime * Math.random()) * timeRate, { y: -parentNode.height * 2 }, { easing: 'quadIn' })
							.removeSelf()
							.start();

					cc.tween(quad)
							.delay(1  * timeRate)
							.to((0.5 + subTime * Math.random()) * timeRate , { opacity: 0 })
							.start();
			}
	},

	createQuads(pos, parentNode, nodeList) {
			const quadBase = cc.instantiate(nodeList[RandomInt(nodeList.length)]);

			quadBase.x = pos.x;
			quadBase.y = pos.y;
			quadBase.z = pos.z;
			quadBase.angle = RandomInt(180);
			quadBase.parent = parentNode;

			const quad = quadBase.getChildByName('quad');
			quad.x = 0;
			quad.y = 0;
			quad.angle = RandomInt(180);

			const paper = quad.getChildByName('paper');
			paper.scaleX = Math.random() * 0.8 + 0.2;
			paper.scaleY = Math.random() * 0.8 + 0.2;

			quadBase.scaleX = Math.random();
			cc.tween(quadBase)
					.to((1 - quadBase.scaleX) * 0.3, { scaleX: 1 })
					.call(() => {
							const time = Math.random() * 0.2;
							cc.tween(quadBase)
									.to(0.1 + time, { scaleX: -1 })
									.to(0.1 + time, { scaleX: 1 })
									.union()
									.repeatForever()
									.start();
					})
					.start();


			return quadBase;
	},


















	restart() {
		
	},


	initTitle() {

		const offX = 96;
		const offY = 11;
		const title = getSprNode('title_bg');
		title.parent = this.canvas;
		title.scale = this._mapScaleMin;
		title.zIndex = 10;

		title.x = -this.canvas.width / 2 + title.width / 2 * title.scale + offX;
		title.y = this.canvas.height / 2 - title.height / 2 * title.scale - offY;

		// console.log('this.data: ', this.data);

		title.addComponent(cc.Button)
		title.on('click', () => {
			if (this.data.title_audio_url) {
				playAudioByUrl(this.data.title_audio_url);
			}
		})

		const labelNode = new cc.Node();
		labelNode.parent = title;
		const label = labelNode.addComponent(cc.RichText);
		const size = 42
		label.font = cc.find('Canvas/res/font/aharoni').getComponent(cc.Label).font;
		label.string = `<outline color=#a83c13 width=2><size=${size}><color=#ffffff>${this.data.title || " " }</color></size></outline>`
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.LEFT
		labelNode.anchorX = 0;
		labelNode.anchorY = 1
		labelNode.x = -title.width / 2 + 90;

		const maxLen = 305;
		if (labelNode.width > maxLen) {
			labelNode.scale = maxLen / labelNode.width;
		}

		labelNode.y = labelNode.height / 2 * labelNode.scale + 15;

	},


	initBg() {
		
		console.log("this.data.bg_pic_url: ", this.data.bg_pic_url);

		const bg = getSprNode('bg');
		const scaleX =  this.canvas.width / bg.width
		const scaleY = this.canvas.height / bg.height 
		const scale = Math.max(scaleX, scaleY);
		bg.scale = scale;
		this.canvas.addChild(bg);
	},
	


	initHotZone() {
		this.initHotZoneBg();
	},


	hotZoneBg: null,
	initHotZoneBg() {
		this.hotZoneBg = new cc.Node();
		this.hotZoneBg.name = 'hotZoneBg';
		this.hotZoneBg.parent = cc.find('Canvas');
		this.hotZoneBg.zIndex = 4;

		if (!this.data.bgItem) {
			return;
		}

		cc.loader.load({url: this.data.bgItem.url}, (err, img) => {

			// this.addMask(this.hotZoneBg);

			this.hotZoneBg.width = img.width;
			this.hotZoneBg.height = img.height;


			const sprNode = new cc.Node();
			sprNode.name = 'bgItemSpr'
			var sf = new cc.SpriteFrame(img);
			// const spr = this.hotZoneBg.addComponent(cc.Sprite);
			const spr = sprNode.addComponent(cc.Sprite);
			spr.spriteFrame = sf
			sprNode.width = this.hotZoneBg.width;
			sprNode.height = this.hotZoneBg.height;
			sprNode.parent = this.hotZoneBg;
			window['bg'] =sprNode 


			// const sx = this.canvas.width / this.hotZoneBg.width;
			// const sy = (this.canvas.height) / this.hotZoneBg.height;
			// const s = Math.min(sx, sy);
			// this.hotZoneBg.scale = s;


			const panel = getSprNode('panel');
			panel.scale = this._mapScaleMin * 1.5;
			this.canvas.addChild(panel);
			panel.x = -this.canvas.width;



			const parent = panel;
			const sx = parent.width / this.hotZoneBg.width;
			const sy = parent.height / this.hotZoneBg.height;
			const s = Math.min(sx, sy);

			this.hotZoneBg.scale = s * 0.9;
			this.hotZoneBg.parent = panel;

			// this.data.bgItem.isShowDebugLine = true;
			this.initHotZoneItem();


			if (this.colorRectArr.length > 0) {
				this.resetHotZoneBg();
			}

			cc.tween(panel)
			.to(1, {x: 0}, {easing: 'cubicOut'})
			.call(() => {
				this.hzLoadEnd = true;
				this.checkStart();
			})
			.start();
			
		});

	},

	initHotZoneItem() {

		this.picNodeArr = [];

		this.data.hotZoneItemArr.forEach((item) => {
			console.log('item.gIdx: ', item.gIdx);
			switch (item.gIdx) {

				case "0":
					this.setOneLinkRect(item);

					break;

				case "1":
					this.setOneWriteAnima(item);
					break;

				case "2":
					this.setOneCircleAnima(item);
					break;

				case "3":
					this.setOneAudioBtn(item);
					break;

				case "4":
					this.setOneSignAnima(item);
					break;

				case "5":
					this.setOneColorPic(item);
					break;

				case "6":
					this.setOnePicAnima(item);
					break;

				// case "0":
				// 	this.setOneHotZonePic(item);
				// 	break;
						
				default:
					break;
			}

		});

	},

	setOneLinkRect(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		// rectNode.scale = 1 / data.mapScale;

		rectNode.anchorX = rectNode.anchorY = 0;


		if (this.data.isDebug) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();

		rectNode.data = data;

		console.log(" data is ~~~ : ", data);

		this.rectNodeArr.push(rectNode)


		const debugItemId = data.pointItem;
		const debugItemData = this.data.hotZoneItemArr2[Number(debugItemId) - 1];
		rectNode.isRightPoint = debugItemData.checkbox.list[0].value == true;

		console.log('debugItemData.checkbox.list[0].value: ', debugItemData.checkbox.list[0].value);

	},


	addMask(node) {
		const mask = node.addComponent(cc.Mask);
		mask.type = cc.Mask.Type.RECT;
	},


	setOneDragAction(data) {

		const rate =  (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY ;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		const {x, y, width, height} = rectNode;
		// rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(-rectNode.width / 2, -rectNode.height / 2, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();
		rectNode.x += rectNode.width / 2;
		rectNode.y += rectNode.height / 2;

		rectNode.baseX = rectNode.x;
		rectNode.baseY = rectNode.y;
		rectNode.targetOff();

		rectNode.on(cc.Node.EventType.TOUCH_START, () => {

			if (rectNode.isDragEnd) {
				if (rectNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
				}
				return;
			}
			this._curShowItem = rectNode;
		})
		

		const realRate = this.hotZoneBg.width / this.data.bgItem.rect.width;
		rectNode.targetPx = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
		rectNode.targetPy = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				rectNode.audioClip = audioClip;
			});
		}



		console.log('setOneAction ~~ data: ', data)
		const actionData = data['actionData_' + data.gIdx];
		if (!actionData) {
			return;
		}
		if (actionData.type == 'text') {
			const label = this.setOneActionText(rectNode, actionData);
			label.node.scale = scale * data.fontScale;

			label.node.targetOff();
		
	

			// label.overflow = cc.Label.Overflow.NONE;
			// label.node.setContentSize(new cc.Size(0, lineHeight));
			label["_forceUpdateRenderData"](true);
		
			
		} else if (actionData.type == 'pic') {

			const pic = this.setOneActionPic(rectNode, actionData);

		} else if (actionData.type == 'anima') {

			const anima = this.setOneActionAnima(rectNode, actionData);
		}
	},



	setOneAction(data) {

		const rate =  (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY ;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		const {x, y, width, height} = rectNode;
		rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();



		console.log('setOneAction ~~ data: ', data)
		const actionData = data['actionData_' + data.gIdx];
		if (!actionData) {
			return;
		}
		if (actionData.type == 'text') {
			const label = this.setOneActionText(rectNode, actionData);
			label.node.scale = scale * data.fontScale;

			// label.overflow = cc.Label.Overflow.NONE;
			// label.node.setContentSize(new cc.Size(0, lineHeight));
			label["_forceUpdateRenderData"](true);
		
			
		} else if (actionData.type == 'pic') {

			const pic = this.setOneActionPic(rectNode, actionData);

		} else if (actionData.type == 'anima') {

			const anima = this.setOneActionAnima(rectNode, actionData);
		}
	},

	setOneActionText(rectNode, actionData) {


		const labelNode = new cc.Node();
		labelNode.parent = rectNode;
		const label = labelNode.addComponent(cc.Label);

		label.font = cc.find('Canvas/res/font/ahronbd-1').getComponent(cc.Label).font;
		label.string = actionData.text;
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		// label.lineHeight = size;
		// label.horizontalAlign = cc.macro.TextAlignment.LEFT
		// labelNode.anchorX = 0;
		// labelNode.anchorY = 1
		labelNode.color = cc.Color.BLACK;


		const opArr = actionData.changeOption
		// console.log('opArr', opArr);


		const tweenArr = [];

		for (let i = 0; i < opArr.length; i++ ) {

			const opData = opArr[i];
			console.log('opArr[0]', opArr[i])
			if (opData[0] == 'fontColor') {
				const color = new cc.Color();
				cc.Color.fromHEX(color, opData[1] );
				labelNode.color = color;

			} else if (opData[0] == 'opacity') {
				// console.log('opData: ', opData)
				labelNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
				// console.log(labelNode.opacity);
				tweenArr.push({item: labelNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[0]},)

			} else {
				label[opData[0]] = opData[1];
				tweenArr.push({item: label, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[0]})

			}
		}


		// if (actionData.audio_url) {
		// 	cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
		// 		labelNode.audioClip = audioClip;
		// 	});
		// }


		label.lineHeight = label.fontSize;

		// labelNode.y += rectNode.height / 2;
		// labelNode.x += rectNode.width / 2;
		

		// rectNode.addComponent(cc.Button);
		// rectNode.on('click', () => {

		// 	if (labelNode.audioClip) {
		// 		cc.audioEngine.stopAllEffects();
		// 		cc.audioEngine.playEffect(labelNode.audioClip, false, 0.8);
		// 	}

		// 	if (labelNode.isClicked) {
		// 		// return;
		// 	}
		// 	labelNode.isClicked = true;

		// 	for (let i=0; i<tweenArr.length; i++) {
		// 		const tweenData = tweenArr[i];

		// 		if (tweenData.optionName == 'opacity') {
		// 			console.log('~~~ ',  tweenData.item[tweenData.optionName] );

		// 			cc.tween(tweenData.item)
		// 				.to(actionData.changeTime,  JSON.parse(tweenData.option) )
		// 				.start();
		// 		}
				

		// 	}

		// });


		return label;
	},

	setOneActionPic(rectNode, actionData) {

		console.log('setOneActionPic actionData: ', actionData)
		const picNode = new cc.Node();
		rectNode.addChild(picNode);

		cc.loader.load({url: actionData.pic_url}, (err, img) => {

			const spr = picNode.addComponent(cc.Sprite);
			spr.spriteFrame = new cc.SpriteFrame(img)

			picNode.y += rectNode.height / 2;
			picNode.x += rectNode.width / 2;

			picNode.scaleX = rectNode.width / picNode.width;
			picNode.scaleY = rectNode.height / picNode.height;

			const opArr = actionData.changeOption	
			const tweenArr = [];
	
			for (let i = 0; i < opArr.length; i++ ) {
	
				const opData = opArr[i];
				console.log('opData: ~~~ ', opData);

				if (opData[0] == 'opacity') {
					picNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
					console.log(picNode.opacity);
					tweenArr.push({item: picNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[0]},)
	
				}  else {
					// picNode[opData[0]] = Number(opData[1]);
					// tweenArr.push({item: picNode, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[0]})
				}

	
				if (actionData.audio_url) {
					cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
						rectNode.audioClip = audioClip;
					});
				}
				

				rectNode.addComponent(cc.Button);
				rectNode.on('click', () => {

					if (rectNode.audioClip) {
						cc.audioEngine.stopAllEffects();
						cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
					}
		
					if (rectNode.isClicked) {
						// return;
					}
					rectNode.isClicked = true;

					for (let i=0; i<tweenArr.length; i++) {
						const tweenData = tweenArr[i];
		
						if (tweenData.optionName == 'opacity') {
							cc.tween(tweenData.item)
								.to(actionData.changeTime,  JSON.parse(tweenData.option) )
								.start();
						}
					}
		
				});
			}

		});
	},

	setOneActionAnima(rectNode, actionData) {


		const animaNode = new cc.Node();
		rectNode.addChild(animaNode);

		if (actionData.audio_url) {
			cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
				rectNode.audioClip = audioClip;
			});
		}

		const data = actionData;

		const dragonDisplay = animaNode.addComponent(dragonBones.ArmatureDisplay);
		if (!data.texPngData) {
			return
		}



		const image = data.texPngData.url//"http://staging-teach.cdn.ireadabc.com/5a0c5af3e952acd0ac83a6e5c6f03ff1.png";
		const ske = data.skeJsonData.url//"http://staging-teach.cdn.ireadabc.com/bd825dcceea298d1146be8067ae3d17f.json";
		const atlas = data.texJsonData.url//"http://staging-teach.cdn.ireadabc.com/246f8991b729fa3e5a7f4802de828efa.json";
		cc.loader.load(image, (error, texture) => {

			cc.loader.load({url: atlas, type: 'txt'}, (error, atlasJson) => {

				cc.loader.load({url: ske, type: 'txt'}, (error, dragonBonesJson) => {

					const atlas = new dragonBones.DragonBonesAtlasAsset();
					atlas.atlasJson = atlasJson;
					atlas.texture = texture;

					const asset = new dragonBones.DragonBonesAsset();
					asset.dragonBonesJson = dragonBonesJson;

					dragonDisplay.dragonAtlasAsset = atlas;
					dragonDisplay.dragonAsset = asset;


					let json = JSON.parse(asset.dragonBonesJson);
					let armatures = json["armature"];
					let armatureNames = [];
					for (let i = 0; i < armatures.length; i++) {
						armatureNames.push(armatures[i].name);
					}
					// console.log('armatureNames: ', armatureNames);

					let animationNames = [];

					if (armatureNames.length > 0) {
						let defaultArmatureName = armatureNames[0];
						dragonDisplay.armatureName = defaultArmatureName;
						// let animationNames = dragonDisplay.getAnimationNames(defaultArmatureName);
						let defaultArmature = armatures[0];
						let animations = defaultArmature.animation;
						for (let i = 0; i < animations.length; i++) {
							animationNames.push(animations[i].name);
						}

						// rectNode.addComponent(cc.Button);
						// rectNode.on('click', () => {
						// 	if (rectNode.isClicked) {
						// 		// return;
						// 	}
						// 	rectNode.isClicked = true;
						// 	console.log('clicked');

						// 	if (rectNode.audioClip) {
						// 		cc.audioEngine.stopAllEffects();
						// 		cc.director.emit('STOP_ALL_AUDIO')
						// 		cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
						// 	}

						// 	if (animationNames.length > 0) {
						// 		dragonDisplay.playAnimation(animationNames[0], 1);
						// 	}
						// });
					}


					// animaNode.x = rectNode.x + rectNode.width / 2;
					// animaNode.y = rectNode.y + rectNode.height / 2;

					// const sx = rectNode.width / animaNode.width;
					// const sy = rectNode.height / animaNode.height;
					// const scale = Math.min(sx, sy);
					// animaNode.scale = scale;
					


			


					animaNode.y += rectNode.height / 2;
					animaNode.x += rectNode.width / 2;

					animaNode.scaleX = rectNode.width / animaNode.width;
					animaNode.scaleY = rectNode.height / animaNode.height;
		
					const opArr = actionData.changeOption	
					const tweenArr = [];
			
					for (let i = 0; i < opArr.length; i++ ) {
			
						const opData = opArr[i];
						console.log('opData: ~~~ ', opData);
		
						if (opData[0] == 'opacity') {
							animaNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
							console.log(animaNode.opacity);
							tweenArr.push({item: animaNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[2] == null ? '' : opData[0]},)
			
						}  else {
							// animaNode[opData[0]] = Number(opData[1]);
							// tweenArr.push({item: animaNode, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[2] == null ? '' : opData[0]})
						}
		
			
						if (actionData.audio_url) {
							cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
								rectNode.audioClip = audioClip;
							});
						}
						
		
						rectNode.addComponent(cc.Button);
						rectNode.on('click', () => {
		
							if (rectNode.audioClip) {
								cc.audioEngine.stopAllEffects();
								cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
							}
				
							if (rectNode.isClicked) {
								// return;
							}
							rectNode.isClicked = true;
		
							for (let j=0; j<tweenArr.length; j++) {
								const tweenData = tweenArr[j];
				
								console.log('tweenData: ', tweenData);

								if (tweenData.optionName) {

									cc.tween(tweenData.item)
										.to(actionData.changeTime,  JSON.parse(tweenData.option))
										.start();

								}

							}
						
							if (animationNames.length > 0) {
								dragonDisplay.playAnimation(animationNames[0], 1);
							}
				
						});
					}
		
					
				});
			});
		});

	},
	

	setOneWriteAnima(data) {

		const animaNode = this.setOneAnimaSmall(data);

		const letterH = 125;
		const rectNode = animaNode.rectNode;
		const sy = rectNode.height / letterH
		animaNode.scale = sy

		this.animaNodeArr.push(animaNode);

	},


	setOneCircleAnima(data) {

		const animaNode = this.setOneRect(data);
		// const animaNode = this.setOneAnimaSmall(data);
		const circle = this.getCircleNode(animaNode);
		animaNode.ctxCircle = circle;

		this.circleAnimaNodeArr.push(animaNode);
	},

	showCircle2(animaNode) {
		const ctxCircle = animaNode.ctxCircle;

		let a = 0;

		const showColorAnim = () => {

			a ++;
			const color = ctxCircle.strokeColor
			color.a = a;

			ctxCircle.strokeColor = color
			ctxCircle.stroke();

			if (a < 255 && !this.isDestroy) {
				delayCall(0.02, () => {
					showColorAnim();
				})
			}
		
		}
	
		showColorAnim();
		
		playAudio(this.rightClip, () => {
			
		})
	},


	setOneColorPic(data) {

		// const picNode = this.setOnePic(data);
		// picNode.data = data;
		// this.colorPicNodeArr.push(picNode);

		const animaNode = this.setOneAnimaSmall(data);
		this.colorPicNodeArr.push(animaNode);

	},

	setOnePicAnima(data) {
		const picNode = this.setOnePic(data);
		// picNode.active = false;
		picNode.opacity = 0;


		// picNode.on("touchstart", () => {
		// 	this.showLetterPic(picNode);
		// })

		picNode.data = data;
		this.picAnimNodeArr.push(picNode);

	},

	setOneSignAnima(data) {
		const animaNode = this.setOneAnimaSmall(data);

		const signW = 200;
		const signH = 200;
		const rectNode = animaNode.rectNode;
		const sx = rectNode.width / signW;
		const sy = rectNode.height / signH;
		const minS = Math.min(sx, sy);
		animaNode.scale = minS;

		this.signAnimaNodeArr.push(animaNode);
	},

	setOneAudioBtn(data) {

		const btn = this.getAudioSpr(data);
		btn.addComponent(cc.Button);
		btn.on("click", () => {

			if (!this.canTouch) {
				return;
			}
			if (data.audio_url) {

				cc.audioEngine.stopAllEffects();
				playAudioByUrl(data.audio_url);
			}
		})
	},

	getCircleNode(rectNode) {

		const data = rectNode.data;
		const circleItem = data.circleItem;
		const index = Number(circleItem - 1);
		console.log('index: ', index);
		const debugCircleData = this.data.hotZoneItemArr2[index];
		let multRect = debugCircleData?.multRect;
		if (debugCircleData?.multRect) {
			console.log("debugCircleData:", debugCircleData);
		}



		// const rectNode = animaNode.rectNode;

		console.log('rectNode: ',rectNode);

		const node = new cc.Node();
		rectNode.parent.addChild(node);
		const ctx = node.addComponent(cc.Graphics);

		let circleRW = rectNode.width / 2;
		let circleRH = rectNode.height / 2;
		let posX = rectNode.x + rectNode.width / 2;
		let posY = rectNode.y + rectNode.height / 2;

		if (multRect) {
			// circleRH = rectNode.height / 4; 
			const angle = this.getAngleByMultRect(multRect);
			node.angle = angle;
		} 
		ctx.ellipse(0, 0, circleRW, circleRH );

		const color = new cc.Color();
		cc.Color.fromHEX(color, '#007ec7')

		let strokeColor = color // cc.Color.BLACK;
		strokeColor.a = 0;
		ctx.lineWidth = 10;
		ctx.strokeColor = strokeColor;

		node.x = posX;
		node.y = posY;

		ctx.stroke();

		return ctx;
		// ctx.fill();
	},

	getAngleByMultRect(multRect) {
		const rect1 = multRect[0].rect;
		const rect2 = multRect[1].rect;
		console.log('rect1: ', rect1);
		console.log('rect2: ', rect2);

		const centerPX1 = rect1.x + rect1.width / 2;
		const centerPY1 = -(rect1.y + rect1.height / 2);
		const centerPX2 = rect2.x + rect2.width / 2;
		const centerPY2 = -(rect2.y + rect2.height / 2);

		let angle = getAngleByPos(centerPX1, centerPY1, centerPX2, centerPY2);
		// angle = 90 - angle ;
		console.log('angle: ', angle);

		return angle;
		// return angle;
	},


	getAudioSpr(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const picNode = new cc.Node();
		picNode.name= 'pic' + data.index;
		picNode.data = data;
		this.hotZoneBg.addChild(picNode);

		const sprNode = getSprNode("btn_sound");
		sprNode.anchorX = 0;
		sprNode.anchorY = 0;

		picNode.anchorX = 0;
		picNode.anchorY = 0;

		
		picNode.addChild(sprNode);

		const scale = rate / this.hotZoneBg.scaleY;

		picNode.width = sprNode.width = data.rect.width * scale;
		picNode.height = sprNode.height = data.rect.height * scale;
		picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;


		return picNode;

	},

	setOneAnimaSmall(data) {


		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

		rectNode.anchorX = rectNode.anchorY = 0;


		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();




		const animaNode = new cc.Node();
		animaNode.name = 'anima_' + data.index;
		this.hotZoneBg.addChild(animaNode);

		animaNode.data = data;
		animaNode.rectNode = rectNode;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				animaNode.audioClip = audioClip;
			});
		}


		const dragonDisplay = animaNode.addComponent(dragonBones.ArmatureDisplay);
		if (!data.texPngData) {
			return animaNode
		}
		
		const image = data.texPngData.url//"http://staging-teach.cdn.ireadabc.com/5a0c5af3e952acd0ac83a6e5c6f03ff1.png";
		const ske = data.skeJsonData.url//"http://staging-teach.cdn.ireadabc.com/bd825dcceea298d1146be8067ae3d17f.json";
		const atlas = data.texJsonData.url//"http://staging-teach.cdn.ireadabc.com/246f8991b729fa3e5a7f4802de828efa.json";
		cc.loader.load(image, (error, texture) => {

			cc.loader.load({url: atlas, type: 'txt'}, (error, atlasJson) => {

				cc.loader.load({url: ske, type: 'txt'}, (error, dragonBonesJson) => {

					const atlas = new dragonBones.DragonBonesAtlasAsset();
					atlas.atlasJson = atlasJson;
					atlas.texture = texture;

					const asset = new dragonBones.DragonBonesAsset();
					asset.dragonBonesJson = dragonBonesJson;

					dragonDisplay.dragonAtlasAsset = atlas;
					dragonDisplay.dragonAsset = asset;

					

					let json = JSON.parse(asset.dragonBonesJson);
					let armatures = json["armature"];
					// console.log('armatures: ', armatures);
					let armatureNames = [];
					for (let i = 0; i < armatures.length; i++) {
						armatureNames.push(armatures[i].name);
					}
					// console.log('armatureNames: ', armatureNames);
					if (armatureNames.length > 0) {
						let defaultArmatureName = armatureNames[0];
						dragonDisplay.armatureName = defaultArmatureName;
						// let animationNames = dragonDisplay.getAnimationNames(defaultArmatureName);
						let defaultArmature = armatures[0];
						let animations = defaultArmature.animation;
						let animationNames = [];
						for (let i = 0; i < animations.length; i++) {
							animationNames.push(animations[i].name);
						}

						animaNode.animationNames = animationNames;

						rectNode.addComponent(cc.Button);
						rectNode.on('click', () => {
							if (rectNode.isClicked) {
								// return;
							}
							rectNode.isClicked = true;
							console.log('clicked');

							if (animaNode.audioClip) {
								cc.audioEngine.stopAllEffects();
								cc.director.emit('STOP_ALL_AUDIO')
								cc.audioEngine.playEffect(animaNode.audioClip, false, 0.8);
							}

							if (animationNames.length > 0) {
								dragonDisplay.playAnimation(animationNames[0], 1);
							}
						});

						// animaNode.playRightAnim = () => {
						// 	animaNode.active = true;
						// 	if (animationNames.length > 0) {
						// 		dragonDisplay.playAnimation(animationNames[0], 1);
						// 	}
						// }
						animaNode.dragonDisplay = dragonDisplay;
					}


					animaNode.x = rectNode.x + rectNode.width / 2;
					animaNode.y = rectNode.y + rectNode.height / 2;

					const sx = rectNode.width / animaNode.width;
					const sy = rectNode.height / animaNode.height;
					const scale = Math.min(sx, sy);
					// animaNode.scale = scale;

					// animaNode.active = false;
					animaNode.opacity = 0;
					animaNode.hitCount = 0;
					// animaNode.opacity = 20;
			
					
				});
			});
		});


		return animaNode;

	},

	playRightAnim(animaNode) {
		const animationNames = animaNode.animationNames;
		const dragonDisplay = animaNode.dragonDisplay;

		animaNode.active = true;
		animaNode.opacity = 255;
		// animaNode.opacity = 255;
		if (dragonDisplay && animationNames && animationNames.length > 0) {
			dragonDisplay.playAnimation(animationNames[0], 1);
		}

		playAudio(this.rightClip, () => {
			
		})
	},

	setOneHotZonePic(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const picNode = new cc.Node();
		picNode.name= 'pic' + data.index;
		picNode.data = data;
		this.hotZoneBg.addChild(picNode);

		this.picNodeArr.push(picNode);
		picNode.hitCount = 0;

		cc.loader.load({url: data.pic_url}, (err, img) => {

			const spr = picNode.addComponent(cc.Sprite);
			spr.spriteFrame = new cc.SpriteFrame(img)

			const scale = rate / this.hotZoneBg.scaleY;

			picNode.width = data.rect.width * scale;
			picNode.height = data.rect.height * scale;
			picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
			picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

			picNode.x += picNode.width / 2 * picNode.scaleX;
			picNode.y += picNode.height / 2 * picNode.scaleX;


			getSprNodeByUrl(data.answer_pic_url, (spr) => {

				const sprNode = spr.node;
				sprNode.active = false;
				picNode.addChild(sprNode);
				picNode.answerPic = sprNode;

				picNode.isLoadEnd = true;
				// this.checkStart();
			})

			// picNode.anchorX = picNode.anchorY = 0;

			// if (data.audio_url) {
			// 	this.addPicAudio(picNode);
			// }

			// this.addDragPoint(picNode, data)

		});

	},

	addDragPoint(picNode, data) {


		picNode.baseX = picNode.x;
		picNode.baseY = picNode.y;

		const realRate = this.hotZoneBg.width / this.data.bgItem.rect.width;
		picNode.targetPx = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
		picNode.targetPy = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				picNode.audioClip = audioClip;
			});
		}


		picNode.on(cc.Node.EventType.TOUCH_START, () => {
			if (picNode.isDragEnd) {
				if (picNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(picNode.audioClip, false, 0.8);
				}
				return;
			}
			this._curShowItem = picNode;

			// picNode.x = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
			// picNode.y = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;

		})
	},


	setOnePic(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const picNode = new cc.Node();
		picNode.name= 'pic' + data.index;
		picNode.data = data;
		this.hotZoneBg.addChild(picNode);

		getSprNodeByUrl(data.pic_url, (spr) => {

			const sprNode = spr.node;
			picNode.addChild(sprNode);

			const scale = rate / this.hotZoneBg.scaleY;

			picNode.width = sprNode.width = data.rect.width * scale;
			picNode.height = sprNode.height = data.rect.height * scale;
			picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
			picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

			sprNode.anchorX = sprNode.anchorY = 0;
			picNode.anchorX = picNode.anchorY = 0;


			picNode.sprNode = sprNode;
		})

		return picNode;

		// cc.loader.load({url: data.pic_url}, (err, img) => {

		// 	const spr = picNode.addComponent(cc.Sprite);
		// 	spr.spriteFrame = new cc.SpriteFrame(img)

		// 	const scale = rate / this.hotZoneBg.scaleY;

		// 	picNode.width = data.rect.width * scale;
		// 	picNode.height = data.rect.height * scale;
		// 	picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		// 	picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

		// 	picNode.anchorX = picNode.anchorY = 0;

		// 	// if (data.audio_url) {
		// 	// 	this.addPicAudio(picNode);
		// 	// }

		// });

		// picNode.on('touchstart', () => {
		// 	this.show
		// })

	},


	setOneRect(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY;
		// console.log('scale: ', scale);
		// console.log('scale2: ', scale / data.mapScale);


		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		// rectNode.scale = 1 / data.mapScale;

		rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine || this.data.isDebug) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();


		// console.log('```data: ', data)

		// this.dragEndRectArr.push(rectNode);

		// if (data.audio_url) {
		// 	cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
		// 		rectNode.audioClip = audioClip;
		// 	});
		// }

		rectNode.data = data;
		return rectNode;

	},

	addPicAudio(picNode) {
		const data = picNode.data;
		
		cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
			picNode.audioClip = audioClip;
		});

		picNode.addComponent(cc.Button);
		picNode.on('click', () => {
				
				if (picNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(picNode.audioClip, false, 0.8);
				}
		});
	},


	initListener() {

		const canvas = cc.find('Canvas');
		
		let downFlag = false;

		const touchMove = (e) => {
			this.canvasTouchMove(e);
			if (canvas.hasEventListener(cc.Node.EventType.MOUSE_MOVE)) {
				canvas.off(cc.Node.EventType.MOUSE_MOVE, mouseMove)
			}
		}

		const mouseMove = (e) => {
			if (!downFlag) {
				return;
			}
			this.canvasTouchMove(e);
			if (canvas.hasEventListener(cc.Node.EventType.TOUCH_MOVE)) {
				canvas.off(cc.Node.EventType.TOUCH_MOVE, touchMove)
				this.removeHtmlCanvasListener('touchmove');
			}
		}

		const touchEnd = (e) => {
		
			downFlag = false;
			this.canvasTouchEnd(e);

			if (canvas.hasEventListener(cc.Node.EventType.MOUSE_UP)) {
				canvas.off(cc.Node.EventType.MOUSE_UP, mouseUp)
			}
			if (canvas.hasEventListener(cc.Node.EventType.MOUSE_LEAVE)) {
				canvas.off(cc.Node.EventType.MOUSE_LEAVE, mouseUp)
			}
			this.removeHtmlTouchEnd();
		}

		const mouseUp = (e) => {
	
			downFlag = false;

			this.canvasTouchEnd(e);

			if (canvas.hasEventListener(cc.Node.EventType.TOUCH_END)) {
				canvas.off(cc.Node.EventType.TOUCH_END, touchEnd)
			}
			if (canvas.hasEventListener(cc.Node.EventType.TOUCH_CANCEL)) {
				canvas.off(cc.Node.EventType.TOUCH_CANCEL, touchEnd)
			}
		}
		

		canvas.on(cc.Node.EventType.TOUCH_MOVE, touchMove)
		canvas.on(cc.Node.EventType.MOUSE_MOVE, mouseMove)

		canvas.on(cc.Node.EventType.TOUCH_END, touchEnd)
		canvas.on(cc.Node.EventType.TOUCH_CANCEL, touchEnd)
		canvas.on(cc.Node.EventType.MOUSE_UP, mouseUp)

	},

	removeHtmlCanvasListener(type) {
		const canvasHtml = document.querySelector('canvas');
		canvasHtml.addEventListener(type, (e) => {})
	},	
	removeHtmlTouchEnd() {
		const canvasHtml = document.querySelector('canvas');
		canvasHtml.removeEventListener('touchend', this.htmlCanvasTouchendFunc, this);
	},

	canvasTouchMove(e) {

		if (!this._curShowItem) {
			return;
		}
		const pos = e.getLocation();
		this._curShowItem.x = pos.x - e.currentTarget.width / 2;
		this._curShowItem.y = pos.y - e.currentTarget.height / 2;

		// console.log('pos: ', pos.x);
	},

	canvasTouchEnd(e) {

		if (!this._curShowItem) {
			return;
		}
		this.checkOnDragEndRect();
		this._curShowItem = null;
	},



	checkOnDragEndRect() {

		console.log('emptyGroupArr: ',  this.emptyGroupArr);
		for (let i = 0; i < this.dragEndRectArr.length; i++) {

			const rect = this.dragEndRectArr[i];

			const worldPos = this._curShowItem.parent.convertToWorldSpaceAR(cc.v2(this._curShowItem.x, this._curShowItem.y));
			const worldRect = rect.getBoundingBoxToWorld();
			if (worldRect.contains(worldPos)) {
			
				console.log('rect in ')
				this.checkIsDragEndTarget(rect);
				// removeItemFromArr(this.emptyGroupArr, letterGroup);
				// this.showLetterSuccess(letterGroup);
				// this.checkGroupEnd();
				return;
			}
			
		}

		this.itemBack();
	},

	itemBack() {

		cc.audioEngine.playEffect(this.wrongClip, false, 0.8);

		cc.tween(this._curShowItem)
			.to(0.5, {x: this._curShowItem.baseX, y: this._curShowItem.baseY}, {easing: "elasticOut"})
			.start();
	},

	checkIsDragEndTarget(rect) {

		const worldPos = this._curShowItem.parent.convertToWorldSpaceAR(cc.v2(this._curShowItem.targetPx, this._curShowItem.targetPy));
		const worldRect = rect.getBoundingBoxToWorld();
		if (worldRect.contains(worldPos)) {
			this._curShowItem.x = this._curShowItem.targetPx;
			this._curShowItem.y = this._curShowItem.targetPy;
			this._curShowItem.isDragEnd = true;


			cc.audioEngine.playEffect(this.rightClip, false, 0.8);

		} else {
			this.itemBack();
		}
	},


	onDestroy() {
		this.isDestroy = true;
	},


});
