// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

// import { getSprNode } from "./util";
import { getSprNode, playAudioByUrl, showBtnAnima, getScaleRateBy2Node, localPosTolocalPos, randomSortByArr, loadDragonBones, playAudio, showTrebleFirework, getSprNodeByUrl, setSprNodeMaxLen, delayCall, asyncDelay, RandomInt, exchangeNodePos, onHomeworkFinish} from "../script/OP72_util";

cc.Class({
	extends: cc.Component,

	properties: {
		baseWidth: {
			default: 1920,
			type: cc.Integer
		},
		baseHeight: {
			default: 1200,
			type: cc.Integer
		}
	},

	onLoad() {
		cc.debug.setDisplayStats(false);
		this.initSceneData();
		this.initSize();
	},

	initSceneData() {
		this._imageResList = [];
		this._audioResList = [];
		this._animaResList = [];
	},


	_designSize: null,
	_frameSize: null,
	_mapScaleMin: null,
	_mapScaleMax: null,
	_cocosScale: null,
	canvas: null,
	initSize() {


		// 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
		let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
		let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
		let f = screen_size >= design_size
		cc.Canvas.instance.fitHeight = f
		cc.Canvas.instance.fitWidth = !f

		const frameSize = cc.view.getFrameSize();
		this._frameSize = frameSize;

		this._designSize = cc.view.getDesignResolutionSize();

		let sx = cc.winSize.width / frameSize.width;
		let sy = cc.winSize.height / frameSize.height;
		this._cocosScale = Math.min(sx, sy);

		sx = frameSize.width / this._designSize.width;
		sy = frameSize.height / this._designSize.height;
		this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
		this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;

		this.canvas = cc.find('Canvas');


		// cc.log('cc.Canvas: ', cc.Canvas);
	},

	start() {

		console.log(' in start 1 ');

		let getData = this.getData.bind(this);
		if (window && window.courseware) {
			getData = window.courseware.getData;

			console.log(' in start 2 ');

		}
		getData((data) => {
			console.log('data:', data);
			this.data = data || this.getDefaultData();
			this.preloadItem()
		})
	},

	_imageResList: null,
	_audioResList: null,
	_animaResList: null,
	preloadItem() {
		this.addPreloadImage();
		this.addPreloadAudio();
		this.addPreloadAnima();
		this.preload();
	},


	getData(func) {
		if (window && window.courseware) {
			window.courseware.getData(func, 'dfzx_cocos_dqq');
			return;
		}
		
		const middleLayer = cc.find('middleLayer');
		if (middleLayer) {
			const middleLayerComponent = middleLayer.getComponent('middleLayer');
			middleLayerComponent.getData(func);
			return;
		}
		
		func(this.getDefaultData());
	},

	getDefaultData() {

		return this.item = {"book_id":"Oxford_Phonics_World_3_SB","part_name":"c","page_id":"61","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/0e1a5b24a6f95d9fe8ee39b6f95cdaad.png","rect":{"x":0,"y":29.37,"width":1712,"height":590.25}},"hotZoneItemArr":[{"id":"1673247490714","index":0,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":757,"posY":296.5,"rect":{"x":730,"y":240.13,"width":54,"height":54},"signItem":1},{"id":"1673247538958","index":1,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":979,"posY":297.5026163234172,"rect":{"x":953.5,"y":242.63,"width":51.01,"height":51.01},"signItem":2},{"id":"1673247543149","index":2,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":756,"posY":384.5026163234172,"rect":{"x":731.5,"y":330.63,"width":49.01,"height":49.01},"signItem":3},{"id":"1673247551247","index":3,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":978,"posY":386.5026163234172,"rect":{"x":951.5,"y":330.63,"width":53.01,"height":53.01},"signItem":4},{"id":"1673247555555","index":4,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":755,"posY":473.5026163234172,"rect":{"x":728.5,"y":417.63,"width":53.01,"height":53.01},"signItem":5},{"id":"1673247561878","index":5,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":978,"posY":475.5026163234172,"rect":{"x":952.5,"y":420.63,"width":51.01,"height":51.01},"signItem":6},{"id":"1673247567832","index":6,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":756,"posY":561.5026163234172,"rect":{"x":729,"y":505.13,"width":54,"height":54},"signItem":7},{"id":"1673247572724","index":7,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":978,"posY":562.5026163234172,"rect":{"x":951.5,"y":506.63,"width":53.01,"height":53.01},"signItem":8},{"id":"1673247577373","index":8,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1318,"posY":295.5026163234172,"rect":{"x":1292.5,"y":240.63,"width":51.01,"height":51.01},"signItem":9},{"id":"1673247583622","index":9,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1541,"posY":297.5026163234172,"rect":{"x":1516,"y":243.13,"width":50,"height":50},"signItem":10},{"id":"1673247616447","index":10,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1317,"posY":384.5026163234172,"rect":{"x":1292,"y":330.13,"width":50,"height":50},"signItem":11},{"id":"1673247623047","index":11,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1541,"posY":386.5026163234172,"rect":{"x":1516,"y":332.13,"width":50,"height":50},"signItem":12},{"id":"1673247633907","index":12,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1317,"posY":473.5026163234172,"rect":{"x":1292,"y":419.13,"width":50,"height":50},"signItem":13},{"id":"1673247640703","index":13,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1541,"posY":474.5026163234172,"rect":{"x":1516,"y":420.13,"width":50,"height":50},"signItem":14},{"id":"1673247647082","index":14,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1317,"posY":561.5026163234172,"rect":{"x":1292,"y":507.13,"width":50,"height":50},"signItem":15},{"id":"1673247653371","index":15,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/765eb83bf69f9044552b9442ade97026.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/1e520ed50e8e9761929e40c505b7a82b.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/0996ced24a99139e333732ee5315519b.png","name":"right_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"4","posX":1542,"posY":562.5026163234172,"rect":{"x":1517,"y":508.13,"width":50,"height":50},"signItem":16}],"typeArr":[{"gIdx":"4","name":"符号"}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/6922dfe773601c34e1c1561795178cdc.jpg","rect":{"x":142.27,"y":0,"width":1162.47,"height":1504}},"hotZoneItemArr2":[{"id":"1673247678740","index":0,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":784,"posY":1378.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":494.93,"y":1146.92,"width":50.16,"height":50.16}},{"id":"1673247934308","index":1,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":940.9950219427358,"posY":1378.4995799172086,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":627.56,"y":1146.07,"width":51.86,"height":51.86}},{"id":"1673249495457","index":2,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":783.9849741017512,"posY":1440.4995799172086,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":494.92,"y":1199.63,"width":50.16,"height":50.16}},{"id":"1673249512248","index":3,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":940.9850219457833,"posY":1441.499561023387,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":628.41,"y":1200.48,"width":50.16,"height":50.16}},{"id":"1673249519189","index":4,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":782.984974101751,"posY":1504.499560718648,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":494.06,"y":1254.04,"width":50.16,"height":50.16}},{"id":"1673249529824","index":5,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":940.9750222535697,"posY":1503.4995415200874,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":628.4,"y":1253.2,"width":50.16,"height":50.16}},{"id":"1673249536467","index":6,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":782.9749741047985,"posY":1566.4995418248263,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":494.05,"y":1306.75,"width":50.16,"height":50.16}},{"id":"1673249543258","index":7,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":941.9650222566172,"posY":1565.4995226262656,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":629.24,"y":1305.91,"width":50.16,"height":50.16}},{"id":"1673249549977","index":8,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1178.964973803107,"posY":1377.4995229310048,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":830.72,"y":1146.07,"width":50.16,"height":50.16}},{"id":"1673249558853","index":9,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1334.9549015829975,"posY":1379.4995802219478,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":963.35,"y":1147.77,"width":50.16,"height":50.16}},{"id":"1673249574484","index":10,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1177.944854046752,"posY":1441.4995796124695,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":829.86,"y":1200.48,"width":50.16,"height":50.16}},{"id":"1673249582426","index":11,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1335.9349018938315,"posY":1442.499560718648,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":964.18,"y":1201.34,"width":50.16,"height":50.16}},{"id":"1673249592072","index":12,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1178.9248537481076,"posY":1503.499560413909,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":830.69,"y":1253.2,"width":50.16,"height":50.16}},{"id":"1673249600338","index":13,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1335.914901595187,"posY":1502.4995418248263,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":964.16,"y":1252.34,"width":50.16,"height":50.16}},{"id":"1673249608730","index":14,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1178.9048537542026,"posY":1566.4995421295655,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":830.68,"y":1306.75,"width":50.16,"height":50.16}},{"id":"1673249617281","index":15,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":747.5884929906542},"gIdx":"8","posX":1336.8949012965427,"posY":1566.4995226262656,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"right","key":"3"},"rect":{"x":965,"y":1306.75,"width":50.16,"height":50.16}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1","isDebug":false,"itemCombineGroup":[[0,1],[2,3],[4,5],[6,7],[8,9],[10,11],[12,13],[14,15]]}


		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/91af3a0f525a0e0ec07820cbbeaf9747.jpg","rect":{"x":263.2,"y":0,"width":1160.61,"height":640}},"hotZoneItemArr":[{"id":"1672975753932","index":0,"itemType":"rect","fontScale":1.31796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.31796875,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/c7c7c91328167e6eeb1384cf977de26f.json","name":"right_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/69a853eac9a3d8a4c115034b4af05bba.json","name":"right_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ed0af8b45d24d6504b2653166cadcca8.png","name":"right_tex.png"},"dragDot":{"x":843.5,"y":320},"gIdx":"5","rect":{"x":480.3,"y":220,"width":200,"height":200},"drawItem":1}],"typeArr":[{"gIdx":"5","name":"涂色"}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/29442195bf59b6a05397a5d2e3ed950a.jpg","rect":{"x":142.27,"y":0,"width":1162.47,"height":1504}},"hotZoneItemArr2":[{"id":"1672971595996","index":0,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":742.6811627906976},"gIdx":"9","posX":574,"posY":1040.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":163.48,"y":638.53,"width":152.64,"height":141.06}},{"id":"1673232526438","index":1,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":742.6811627906976},"gIdx":"9","posX":1041.0659790503555,"posY":716.0579668005769,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":800.86,"y":645.53,"width":195.87,"height":141.06}},{"id":"1673232537213","index":2,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":742.6811627906976},"gIdx":"9","posX":391.05908941019266,"posY":962.0579467283744,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":111.85,"y":895,"width":273.88,"height":134.12}},{"id":"1673232563876","index":3,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":742.6811627906976},"gIdx":"9","posX":1045.0559704766574,"posY":947.0572614060292,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":815.84,"y":895,"width":173.89,"height":104.11}},{"id":"1673232630680","index":4,"itemType":"rect","fontScale":1.13046875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13046875,"dragDot":{"x":723.5,"y":752},"gIdx":"2","posX":727.5,"posY":826,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":51.73,"y":569,"width":1067,"height":514}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1","isDebug":false,"itemCombineGroup":[]}




		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/70645c5d8b0d23fbbbeb85bba273dd07.jpg","rect":{"x":347.65,"y":0,"width":1470.7,"height":811}},"hotZoneItemArr":[{"id":"1672383817653","index":0,"pic_url":"http://staging-teach.cdn.ireadabc.com/99d4213db464fa5612e5a6f2ce6e6205.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":1},{"id":"1672383823303","index":1,"pic_url":"http://staging-teach.cdn.ireadabc.com/a5a8cca90caeac412ff4823e44027338.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":2},{"id":"1672383831136","index":2,"pic_url":"http://staging-teach.cdn.ireadabc.com/02cca6d33697d3fae9344c27db6bf2aa.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":3},{"id":"1672886201232","index":3,"pic_url":"http://staging-teach.cdn.ireadabc.com/596b40f0099235118839304f5027b130.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":4},{"id":"1672886207036","index":4,"pic_url":"http://staging-teach.cdn.ireadabc.com/a3d1bc4260624bae7fd1fb63a3b15209.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"5","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811},"drawItem":5},{"id":"1672886218851","index":5,"pic_url":"http://staging-teach.cdn.ireadabc.com/46ea80a59547e5a3840905a52fcb0dd5.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":409.8490706319702},"gIdx":"7","rect":{"x":0,"y":-23.45,"width":1470.7,"height":811}},{"id":"1672886599895","index":6,"pic_url":"http://staging-teach.cdn.ireadabc.com/b6a09122f8d5cfea891bc7284e133801.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":6},{"id":"1672887244335","index":7,"pic_url":"http://staging-teach.cdn.ireadabc.com/c10876c002bc823f6ca49b74066a5d76.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":7},{"id":"1672887249391","index":8,"pic_url":"http://staging-teach.cdn.ireadabc.com/f0851d82eb1334338bb4a50b186f9e93.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":8},{"id":"1672887253204","index":9,"pic_url":"http://staging-teach.cdn.ireadabc.com/28ea5ac29910d91da59d92710adc037c.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":9},{"id":"1672887257509","index":10,"pic_url":"http://staging-teach.cdn.ireadabc.com/72c0addd6c62e060a7f319679738927b.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":10},{"id":"1672887260662","index":11,"pic_url":"http://staging-teach.cdn.ireadabc.com/68c9c58fc8666b792c38ed5ab0d6c3fd.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":11},{"id":"1672887265072","index":12,"pic_url":"http://staging-teach.cdn.ireadabc.com/94ec59f1645b4135bb36f1df30f45794.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":12},{"id":"1672887268286","index":13,"pic_url":"http://staging-teach.cdn.ireadabc.com/5b5460e376b4baa1f9dc4b3dca87dfd6.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":13},{"id":"1672887288002","index":14,"pic_url":"http://staging-teach.cdn.ireadabc.com/37b853984d269135907b136e1b5acffa.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"5","rect":{"x":0,"y":0,"width":1470.7,"height":811},"drawItem":14},{"id":"1672887300784","index":15,"pic_url":"http://staging-teach.cdn.ireadabc.com/8f51a61409fb2ac59699ab3ab2545216.png","itemType":"pic","fontScale":1.6921875,"imgScale":0.6815126050420168,"imgSizeW":2158,"imgSizeH":1190,"mapScale":1.6921875,"dragDot":{"x":1083,"y":405.5},"gIdx":"7","rect":{"x":0,"y":0,"width":1470.7,"height":811}}],"typeArr":[{"gIdx":"5","name":"涂色"}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/29442195bf59b6a05397a5d2e3ed950a.jpg","rect":{"x":222.09,"y":0,"width":1705.83,"height":2207}},"hotZoneItemArr2":[{"id":"1672383940196","index":0,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":579.4385501858735,"posY":953.2112404894672,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":334.79,"y":943.21,"width":45.12,"height":20}},{"id":"1672384393835","index":1,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":577.0947552664188,"posY":1102.509809216233,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":318.1,"y":1090,"width":73.81,"height":25.02}},{"id":"1672887918046","index":2,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":576.2459194656462,"posY":1030.2192900474647,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":310.94,"y":1015,"width":86.44,"height":30.44}},{"id":"1672888737090","index":3,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":580.2408527911143,"posY":1066.2182385065726,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":336.39,"y":1056.22,"width":43.52,"height":20}},{"id":"1672888874155","index":4,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1108.5687732342008},"gIdx":"9","posX":579.2358459603731,"posY":986.2181769529593,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":335.39,"y":976.22,"width":43.52,"height":20}},{"id":"1672888913151","index":5,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1041,"posY":1363.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":801.41,"y":1346,"width":35,"height":35}},{"id":"1672888960358","index":6,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1255.995058142517,"posY":1436.4976686569003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1023.9,"y":1426.5,"width":20,"height":20}},{"id":"1672888996036","index":7,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1111.995058142517,"posY":1365.4976686569003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":872.4,"y":1348,"width":35,"height":35}},{"id":"1672889020443","index":8,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":922.9949367451134,"posY":1436.4976652372552,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":690.9,"y":1426.5,"width":20,"height":20}},{"id":"1672889070985","index":9,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":937.9852582088583,"posY":1438.497540420206,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":705.9,"y":1428.5,"width":20,"height":20}},{"id":"1672889118059","index":10,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1142.9949367451134,"posY":1388.4976652372552,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":910.89,"y":1378.5,"width":20,"height":20}},{"id":"1672889148050","index":11,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1087.9949367451134,"posY":1422.4976652372552,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":815.9,"y":1405,"width":100.01,"height":35}},{"id":"1672889174286","index":12,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":993.9899777894047,"posY":1470.4975626478997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":761.9,"y":1460.5,"width":20,"height":20}},{"id":"1672889204196","index":13,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"9","posX":1193.9851385212771,"posY":1472.4974857058833,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":961.89,"y":1462.5,"width":20,"height":20}},{"id":"1672890163649","index":14,"itemType":"rect","fontScale":1.6796875,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.6796875,"dragDot":{"x":1075,"y":1103.5},"gIdx":"2","posX":1059,"posY":1157.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":74.91,"y":727,"width":1524,"height":861}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1","isDebug":false}

		
		return {"write_big_0_audio_url":"http://teach.cdn.ireadabc.com/4cd906b89868b20cd4e3c2fc9848bac9.mp3","write_big_1_audio_url":"http://teach.cdn.ireadabc.com/4c5a39defde0e90f3a53bf50db6943f4.mp3","write_big_2_audio_url":"http://teach.cdn.ireadabc.com/53ba71d99f24bf8e78b68b0de658a0b6.mp3","write_small_0_audio_url":"http://teach.cdn.ireadabc.com/d099918c85ac7afc33f169c9038f46d4.mp3","write_small_1_audio_url":"http://teach.cdn.ireadabc.com/2f1ea180fb4d17dce34e8d7cc6cf9159.mp3","write_small_2_audio_url":"http://teach.cdn.ireadabc.com/763b51f3d318fc0447e13ff387d00660.mp3","finish_audio_url":"http://teach.cdn.ireadabc.com/7fb349c67a76d2112a0604e624acaa97.mp3","tip_audio_url":"http://teach.cdn.ireadabc.com/d5cdef3f02abe29b14ca8c16ad4e7543.mp3","letter":"B","animArr":[{"key":"letter_big_0","title":"大写彩色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/3741b9919c8ae9c020048e4eb1a7203d.json","name":"B大彩_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/95cf3f48a23cf811c20e77e557116392.json","name":"B大彩_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/1f1e837171567609ceb9ba1b78a3528c.png","name":"B大彩_tex.png"}},{"key":"letter_big_1","title":"大写黑色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/478486f6afc92495ee9165869a03b8a0.json","name":"B大黑_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/61035beb245a518cdc827930e3cee512.json","name":"B大黑_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/05c20f86a6750450cd00bf9a45fcbaa3.png","name":"B大黑_tex.png"}},{"key":"letter_small_0","title":"小写彩色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/691dc3ff5ef5ee86bd6ba8a85992c47a.json","name":"小b彩_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/72dc028c89a284f9994c74697c1c24cd.json","name":"小b彩_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/3aa9aa49d44935bebc0b881935d464b1.png","name":"小b彩_tex.png"}},{"key":"letter_small_1","title":"小写黑色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/d32405fafbe86b03c21d7d1f026ae0a1.json","name":"小b黑_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/c26da948585e6609a4d3f8eb590b9b78.json","name":"小b黑_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/980005c431cbdbd3e9e2188d6a13f579.png","name":"小b黑_tex.png"}}],"bg_pic_url":"http://teach.cdn.ireadabc.com/520b8785f6b253aef7ced8941711c1cf.png","dot_big_1_url":"http://teach.cdn.ireadabc.com/26b8a37d08cb332eacb3383e966a9d8c.png","dot_big_2_url":"http://teach.cdn.ireadabc.com/e80e0f8311cfce0faec44623057e10fd.png","dot_small_1_url":"http://teach.cdn.ireadabc.com/699666d2df22d79a7506e52a460b4bda.png","dot_small_2_url":"http://teach.cdn.ireadabc.com/92bb0fbeace4a5611d9aab1cd92a972c.png","page_id":"7","book_id":"Oxford_Phonics_World_1_SB","part_name":"c","bgItem2":{"url":"http://teach.cdn.ireadabc.com/a7a5c15622c72b46f13224112b75219f.png","rect":{"x":108.53,"y":0,"width":936.93,"height":1212}},"hotZoneItemArr2":[{"id":"1667981969225","index":0,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"3","labelText":"Trace w a say","posX":368,"posY":119,"rect":{"x":124.47,"y":101,"width":270,"height":36}},{"id":"1667982191278","index":1,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"5","labelText":"B","posX":236.00500001279102,"posY":191.00155025950244,"rect":{"x":99.48,"y":148,"width":55.99,"height":86}},{"id":"1667982331366","index":2,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_0_b","posX":413,"posY":190,"rect":{"x":274.47,"y":150,"width":60,"height":80}},{"id":"1667982505546","index":3,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_1_b","posX":500.0045804706154,"posY":192.00048605495954,"rect":{"x":361.47,"y":152,"width":60,"height":80}},{"id":"1667982528830","index":4,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_2_b","posX":588.0048030326232,"posY":191.00048861314355,"rect":{"x":449.47,"y":151,"width":60,"height":80}},{"id":"1667982696613","index":5,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_3_b","posX":674.0050281528149,"posY":191.00048861314355,"rect":{"x":535.49,"y":151,"width":60,"height":80}},{"id":"1667982762888","index":6,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_4_b","posX":764.0052481566387,"posY":191.00048861314355,"rect":{"x":625.5,"y":151,"width":60,"height":80}},{"id":"1667982780373","index":7,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_5_b","posX":851.0154758605963,"posY":192.0004911713275,"rect":{"x":712.51,"y":152,"width":60,"height":80}},{"id":"1667982820496","index":8,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_6_b","posX":936.0257010063699,"posY":192.0004937295115,"rect":{"x":797.52,"y":152,"width":60,"height":80}},{"id":"1667982922997","index":9,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_0_s","posX":413.0359184775915,"posY":313.0004911713275,"rect":{"x":278.54,"y":273,"width":51.93,"height":80}},{"id":"1667982963933","index":10,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_1_s","posX":502.0398031221596,"posY":312.00079815340723,"rect":{"x":367.54,"y":272,"width":51.93,"height":80}},{"id":"1667982981844","index":11,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_2_s","posX":588.0400256841674,"posY":312.00079815340723,"rect":{"x":453.54,"y":272,"width":51.93,"height":80}},{"id":"1667982997077","index":12,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_3_s","posX":675.050245713573,"posY":312.00079815340723,"rect":{"x":540.56,"y":272,"width":51.93,"height":80}},{"id":"1667983009421","index":13,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_4_s","posX":763.0604734175306,"posY":312.00079815340723,"rect":{"x":628.57,"y":272,"width":51.93,"height":80}},{"id":"1667983021501","index":14,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_5_s","posX":850.0706960051203,"posY":312.00080071159124,"rect":{"x":715.58,"y":272,"width":51.93,"height":80}},{"id":"1667983039040","index":15,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_6_s","posX":937.0809211508939,"posY":311.00079815340723,"rect":{"x":802.59,"y":271,"width":51.93,"height":80}},{"id":"1667983233606","index":16,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"2","posX":588.0050230364469,"posY":239.0006062896074,"rect":{"x":47.47,"y":88,"width":864,"height":302}}],"isDebug":false}




		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"https://teach.cdn.ireadabc.com/684f085ef1286bef60066720162381b8.png","rect":{"x":237.62,"y":0,"width":1252.76,"height":649}},"hotZoneItemArr":[{"id":"1669017611587","index":0,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":692.9602814259316,"posY":185.7589939450262,"rect":{"x":495.9,"y":177.44,"width":50.33,"height":50.33},"pointItem":1,"linkItem":2},{"id":"1669017628260","index":1,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":895.1838773664921,"posY":185.66390047751776,"rect":{"x":716.48,"y":177.35,"width":50.33,"height":50.33},"pointItem":2,"linkItem":1},{"id":"1669017628745","index":2,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":1077.07009039729,"posY":252.81717081690795,"rect":{"x":914.87,"y":250.59,"width":50.33,"height":50.33},"pointItem":3,"linkItem":4},{"id":"1669017629096","index":3,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":1084.4044361247306,"posY":406.36600093794283,"rect":{"x":922.87,"y":418.07,"width":50.33,"height":50.33},"pointItem":4,"linkItem":3},{"id":"1669017629331","index":4,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":910.7574753538651,"posY":448.46716877009555,"rect":{"x":733.47,"y":464,"width":50.33,"height":50.33},"pointItem":5,"linkItem":6},{"id":"1669017629556","index":5,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":681.5308422309823,"posY":448.3720753025871,"rect":{"x":483.45,"y":463.89,"width":50.33,"height":50.33},"pointItem":6,"linkItem":5},{"id":"1669017629775","index":6,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":500.83481613520166,"posY":398.3169356130275,"rect":{"x":286.34,"y":409.3,"width":50.33,"height":50.33},"pointItem":7,"linkItem":8},{"id":"1669017630034","index":7,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":499.92990960271015,"posY":251.81717081690795,"rect":{"x":285.35,"y":249.5,"width":50.33,"height":50.33},"pointItem":8,"linkItem":7},{"id":"1669017679915","index":8,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":746.6841125703726,"posY":244.38773162195878,"rect":{"x":554.5,"y":241.4,"width":50.33,"height":50.33},"pointItem":9,"linkItem":10},{"id":"1669017680161","index":9,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":850.0336442094241,"posY":245.6730120244842,"rect":{"x":667.24,"y":242.81,"width":50.33,"height":50.33},"pointItem":10,"linkItem":9},{"id":"1669017680397","index":10,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":906.2329426914074,"posY":277.34474066168775,"rect":{"x":728.54,"y":277.34,"width":50.33,"height":50.33},"pointItem":11,"linkItem":12},{"id":"1669017680628","index":11,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":905.3280361589159,"posY":363.9304873783493,"rect":{"x":727.54,"y":371.79,"width":50.33,"height":50.33},"pointItem":12,"linkItem":11},{"id":"1669017681310","index":12,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":849.223831144441,"posY":395.69730948306136,"rect":{"x":666.35,"y":406.43,"width":50.33,"height":50.33},"pointItem":13,"linkItem":14},{"id":"1669017681516","index":13,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":747.7792060378811,"posY":396.6022160155529,"rect":{"x":555.69,"y":407.43,"width":50.33,"height":50.33},"pointItem":14,"linkItem":13},{"id":"1669017681761","index":14,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":684.5308422309823,"posY":360.0255808458578,"rect":{"x":486.71,"y":367.53,"width":50.33,"height":50.33},"pointItem":15,"linkItem":16},{"id":"1669017681968","index":15,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":684.3406552959655,"posY":279.05946025916234,"rect":{"x":486.5,"y":279.21,"width":50.33,"height":50.33},"pointItem":16,"linkItem":15},{"id":"1672018943194","index":16,"pic_url":"http://staging-teach.cdn.ireadabc.com/85b7c85ca4f2183549abf13a10cf3621.png","itemType":"pic","fontScale":1.35,"imgScale":1.0263157894736843,"imgSizeW":185,"imgSizeH":114,"mapScale":1.35,"dragDot":{"x":864,"y":324.5},"gIdx":"6","rect":{"x":538.45,"y":294,"width":189.87,"height":117},"rectNew":17}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"6","name":"书写"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/7975e4a930fe51033b0e1321260d4046.png","rect":{"x":148.42,"y":0,"width":1154.16,"height":1493}},"hotZoneItemArr2":[{"id":"1669017732389","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":684.5,"posY":746.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":454.12,"y":661.3,"width":52.5,"height":52.5}},{"id":"1669017744633","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":905.4951316891791,"posY":743.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":657.65,"y":658.54,"width":52.5,"height":52.5}},{"id":"1669017744849","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1101.495131689179,"posY":819.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":838.17,"y":728.54,"width":52.5,"height":52.5}},{"id":"1669017745296","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1110.495131689179,"posY":986.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":846.46,"y":882.35,"width":52.5,"height":52.5}},{"id":"1669017745504","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":923.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":674.23,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745728","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":673.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":443.99,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745946","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":477.49513168917906,"posY":977.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":263.46,"y":874.06,"width":52.5,"height":52.5}},{"id":"1669017747640","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":475.49513168917906,"posY":815.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":261.62,"y":724.85,"width":52.5,"height":52.5}},{"id":"1669017780767","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":510.3,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781123","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":610.67,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781698","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":918.4951316891791,"posY":847.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":669.62,"y":754.33,"width":52.5,"height":52.5}},{"id":"1669017782166","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":916.4951316891791,"posY":935.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":667.78,"y":835.38,"width":52.5,"height":52.5}},{"id":"1669017783084","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":972.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":610.67,"y":869.46,"width":52.5,"height":52.5}},{"id":"1669017783667","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":976.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":510.3,"y":873.14,"width":52.5,"height":52.5}},{"id":"1669017784240","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":678.4951392139167,"posY":937.4988242597458,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":448.59,"y":837.22,"width":52.5,"height":52.5}},{"id":"1669017785006","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":675.4951316891791,"posY":843.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":445.83,"y":750.64,"width":52.5,"height":52.5}},{"id":"1669170012773","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":746.5},"gIdx":"6","labelText":"Cc","posX":734.5,"posY":820.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":486.08,"y":745,"width":200,"height":151}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1"}
		
		return this.item = {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"45","bgItem":{"url":"https://teach.cdn.ireadabc.com/457c72a9cb0f903e45e151f5a4c836e1.png","rect":{"x":224.33,"y":0,"width":1130.34,"height":595}},"hotZoneItemArr":[{"id":"1669027968644","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":440.5,"posY":169.5,"rect":{"x":99.67,"y":95,"width":233,"height":149},"rectNew":1},{"id":"1669028023205","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":443.499071286044,"posY":346.5004510516205,"rect":{"x":102.67,"y":272,"width":233,"height":149},"rectNew":2},{"id":"1669028023430","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/0a425bcf53cf83eca9b725f62957d873.json","name":"db_letter_i_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/65ba76a8bcbb05c926be163c60a67ab0.json","name":"db_letter_i_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/364b37a6c1e6c7b6f4a270cb81ec5f0b.png","name":"db_letter_i_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":443.4990792692586,"posY":513.501366460219,"rect":{"x":102.67,"y":439,"width":233,"height":149},"rectNew":3},{"id":"1669028023680","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/7fd4e5db04c04cdcf0dc6b0c12fc4764.json","name":"db_letter_k_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/c5c2c04b305ae8890c9f050d7cbbf97a.json","name":"db_letter_k_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/4d31a35f1a705b9ab198f044ed391fc0.png","name":"db_letter_k_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1189.499071286044,"posY":170.50045105162047,"rect":{"x":848.67,"y":96,"width":233,"height":149},"rectNew":4},{"id":"1669028023942","index":4,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1189.499071286044,"posY":342.5004510516205,"rect":{"x":848.67,"y":268,"width":233,"height":149},"rectNew":5},{"id":"1669028024195","index":5,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1192.501069750746,"posY":513.5013691212904,"rect":{"x":851.67,"y":439,"width":233,"height":149},"rectNew":6},{"id":"1669028676925","index":6,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":660.5,"posY":240.5,"rect":{"x":411.67,"y":216,"width":49,"height":49},"pointItem":7,"linkItem":16},{"id":"1669028762010","index":7,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":811.4996567217756,"posY":241.50063998769747,"rect":{"x":562.67,"y":217,"width":49,"height":49},"pointItem":8,"linkItem":18},{"id":"1669028762200","index":8,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":959.4996567217756,"posY":239.50063998769747,"rect":{"x":710.67,"y":215,"width":49,"height":49},"pointItem":9,"linkItem":14},{"id":"1669028762448","index":9,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":661.4996567217756,"posY":440.50063998769747,"rect":{"x":412.67,"y":416,"width":49,"height":49},"pointItem":10,"linkItem":15},{"id":"1669028762652","index":10,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":810.4996567217756,"posY":440.50063998769747,"rect":{"x":561.67,"y":416,"width":49,"height":49},"pointItem":11,"linkItem":13},{"id":"1669028762878","index":11,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":959.4996567217756,"posY":438.50063998769747,"rect":{"x":710.67,"y":414,"width":49,"height":49},"pointItem":12,"linkItem":17},{"id":"1669028763095","index":12,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":169.50063998769747,"rect":{"x":298.67,"y":145,"width":49,"height":49},"pointItem":13,"linkItem":11},{"id":"1669028763723","index":13,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":342.50063998769747,"rect":{"x":298.67,"y":318,"width":49,"height":49},"pointItem":14,"linkItem":9},{"id":"1669028763919","index":14,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":515.5006399876975,"rect":{"x":298.67,"y":491,"width":49,"height":49},"pointItem":15,"linkItem":10},{"id":"1669028764788","index":15,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1084.4996567217756,"posY":169.50063998769747,"rect":{"x":835.67,"y":145,"width":49,"height":49},"pointItem":16,"linkItem":7},{"id":"1669028765508","index":16,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1085.4996567217756,"posY":341.50063998769747,"rect":{"x":836.67,"y":317,"width":49,"height":49},"pointItem":17,"linkItem":12},{"id":"1669028766684","index":17,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1085.4996567217756,"posY":514.5006399876975,"rect":{"x":836.67,"y":490,"width":49,"height":49},"pointItem":18,"linkItem":8},{"id":"1669028965617","index":18,"audio_url":"https://teach.cdn.ireadabc.com/fa4edbee3e71acaac5426787327cc70e.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":555.5,"posY":98.5,"rect":{"x":305.67,"y":73,"width":51,"height":51}},{"id":"1669028987109","index":19,"audio_url":"https://teach.cdn.ireadabc.com/e7bcf57e7c23c38c0d276aa94b44cdad.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":564.4993746481958,"posY":268.5002674376865,"rect":{"x":314.67,"y":243,"width":51,"height":51}},{"id":"1669028988980","index":20,"audio_url":"https://teach.cdn.ireadabc.com/48bc4f1bf13394bc9dbc0a2943aa49bc.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":563.4993746481958,"posY":434.5002674376865,"rect":{"x":313.67,"y":409,"width":51,"height":51}},{"id":"1669028989259","index":21,"audio_url":"https://teach.cdn.ireadabc.com/b1cfbb3de49089766cc3445728a4ada7.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1311.499374648196,"posY":94.50026743768646,"rect":{"x":1061.67,"y":69,"width":51,"height":51}},{"id":"1669028989473","index":22,"audio_url":"https://teach.cdn.ireadabc.com/22b083172dcc1cd6cb29c31542df5fc5.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1308.499374648196,"posY":266.5002674376865,"rect":{"x":1058.67,"y":241,"width":51,"height":51}},{"id":"1669028989757","index":23,"audio_url":"https://teach.cdn.ireadabc.com/37e1f105a64fdfd3424e2dc8676b00a9.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1313.499374648196,"posY":438.5002674376865,"rect":{"x":1063.67,"y":413,"width":51,"height":51}}],"typeArr":[{"gIdx":"1","name":"手写"},{"gIdx":"0","name":"连线"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/58c55c5d77576fad7c547123ba68d02a.png","rect":{"x":162.95,"y":0,"width":1253.11,"height":1621}},"hotZoneItemArr2":[{"id":"1669028281208","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":405.5,"posY":715.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":112.05,"y":640,"width":261,"height":151}},{"id":"1669028304948","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":404.4954815894788,"posY":908.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":111.05,"y":833,"width":261,"height":151}},{"id":"1669028305153","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Ii","posX":406.4954815894788,"posY":1094.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":113.05,"y":1019,"width":261,"height":151}},{"id":"1669028305356","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Kk","posX":1232.495481589479,"posY":715.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":939.02,"y":640,"width":261,"height":151}},{"id":"1669028305571","index":4,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":1230.495481589479,"posY":910.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":937.02,"y":835,"width":261,"height":151}},{"id":"1669028305755","index":5,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":1233.495481589479,"posY":1101.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":940.02,"y":1026,"width":261,"height":151}},{"id":"1669028350559","index":6,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":649.5,"posY":793.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":463.05,"y":770,"width":47,"height":47}},{"id":"1669028390520","index":7,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":812.4951755834819,"posY":792.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.05,"y":769,"width":47,"height":47}},{"id":"1669028390701","index":8,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":979.4951755834819,"posY":794.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":793.03,"y":771,"width":47,"height":47}},{"id":"1669028390911","index":9,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":648.4951755834819,"posY":1013.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":462.05,"y":990,"width":47,"height":47}},{"id":"1669028391078","index":10,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":812.4951755834819,"posY":1016.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.05,"y":993,"width":47,"height":47}},{"id":"1669028391273","index":11,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":978.4951755834819,"posY":1014.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":792.03,"y":991,"width":47,"height":47}},{"id":"1669028427605","index":12,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":520.4951755834819,"posY":715.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":334.05,"y":692,"width":47,"height":47}},{"id":"1669028427782","index":13,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":523.4951755834819,"posY":904.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":337.05,"y":881,"width":47,"height":47}},{"id":"1669028427990","index":14,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":523.4951755834819,"posY":1094.4990048534487,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":337.05,"y":1071,"width":47,"height":47}},{"id":"1669028428167","index":15,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1119.4951755834818,"posY":715.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":933.03,"y":692,"width":47,"height":47}},{"id":"1669028428404","index":16,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1116.4951755834818,"posY":902.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":930.03,"y":879,"width":47,"height":47}},{"id":"1669028428589","index":17,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1118.4951755834818,"posY":1096.4990048534487,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":932.03,"y":1073,"width":47,"height":47}}],"firstGIdx":"1","begin_audio_url":"https://teach.cdn.ireadabc.com/165a2ffaf57e33e73a2ba10e5f81a38c.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/36e09d2c6e5b7191f2eaa367211a30e3.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/822af0678dc62dc2846ff8fa0f773ccc.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/822af0678dc62dc2846ff8fa0f773ccc.mp3","isDebug":true}
		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"https://teach.cdn.ireadabc.com/684f085ef1286bef60066720162381b8.png","rect":{"x":196.6,"y":0,"width":1057.8,"height":548}},"hotZoneItemArr":[{"id":"1669017611587","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":692.9602814259316,"posY":185.7589939450262,"rect":{"x":418.73,"y":149.83,"width":42.5,"height":42.5},"pointItem":1,"linkItem":9},{"id":"1669017628260","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":895.1838773664921,"posY":185.66390047751776,"rect":{"x":604.98,"y":149.75,"width":42.5,"height":42.5},"pointItem":2,"linkItem":10},{"id":"1669017628745","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":1077.07009039729,"posY":252.81717081690795,"rect":{"x":772.49,"y":211.59,"width":42.5,"height":42.5},"pointItem":3,"linkItem":11},{"id":"1669017629096","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":1084.4044361247306,"posY":406.36600093794283,"rect":{"x":779.25,"y":353.01,"width":42.5,"height":42.5},"pointItem":4,"linkItem":12},{"id":"1669017629331","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":910.7574753538651,"posY":448.46716877009555,"rect":{"x":619.32,"y":391.79,"width":42.5,"height":42.5},"pointItem":5,"linkItem":13},{"id":"1669017629556","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":681.5308422309823,"posY":448.3720753025871,"rect":{"x":408.21,"y":391.7,"width":42.5,"height":42.5},"pointItem":6,"linkItem":14},{"id":"1669017629775","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":500.83481613520166,"posY":398.3169356130275,"rect":{"x":241.78,"y":345.6,"width":42.5,"height":42.5},"pointItem":7,"linkItem":15},{"id":"1669017630034","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":499.92990960271015,"posY":251.81717081690795,"rect":{"x":240.94,"y":210.67,"width":42.5,"height":42.5},"pointItem":8,"linkItem":16},{"id":"1669017679915","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":746.6841125703726,"posY":244.38773162195878,"rect":{"x":468.21,"y":203.83,"width":42.5,"height":42.5},"pointItem":9,"linkItem":1},{"id":"1669017680161","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":850.0336442094241,"posY":245.6730120244842,"rect":{"x":563.4,"y":205.02,"width":42.5,"height":42.5},"pointItem":10,"linkItem":2},{"id":"1669017680397","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":906.2329426914074,"posY":277.34474066168775,"rect":{"x":615.16,"y":234.18,"width":42.5,"height":42.5},"pointItem":11,"linkItem":3},{"id":"1669017680628","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":905.3280361589159,"posY":363.9304873783493,"rect":{"x":614.32,"y":313.93,"width":42.5,"height":42.5},"pointItem":12,"linkItem":4},{"id":"1669017681310","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":849.223831144441,"posY":395.69730948306136,"rect":{"x":562.65,"y":343.18,"width":42.5,"height":42.5},"pointItem":13,"linkItem":5},{"id":"1669017681516","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":747.7792060378811,"posY":396.6022160155529,"rect":{"x":469.21,"y":344.02,"width":42.5,"height":42.5},"pointItem":14,"linkItem":6},{"id":"1669017681761","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":684.5308422309823,"posY":360.0255808458578,"rect":{"x":410.97,"y":310.33,"width":42.5,"height":42.5},"pointItem":15,"linkItem":7},{"id":"1669017681968","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":684.3406552959655,"posY":279.05946025916234,"rect":{"x":410.79,"y":235.76,"width":42.5,"height":42.5},"pointItem":16,"linkItem":8},{"id":"1669169946060","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/b213e3ebfa399bead9cef9a5b6089a5c.json","name":"db_letter_c_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/f2f7de385d5ec34d1f51c1d0d639d0db.json","name":"db_letter_c_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/bc2ecbb4ccad7ed8717ab0c6b9a15a40.png","name":"db_letter_c_tex.png"},"dragDot":{"x":725.5,"y":274},"gIdx":"1","posX":731.5,"posY":299,"rect":{"x":434.9,"y":231,"width":200,"height":136},"rectNew":17}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/7975e4a930fe51033b0e1321260d4046.png","rect":{"x":148.42,"y":0,"width":1154.16,"height":1493}},"hotZoneItemArr2":[{"id":"1669017732389","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":684.5,"posY":746.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":454.12,"y":661.3,"width":52.5,"height":52.5}},{"id":"1669017744633","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":905.4951316891791,"posY":743.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":657.65,"y":658.54,"width":52.5,"height":52.5}},{"id":"1669017744849","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1101.495131689179,"posY":819.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":838.17,"y":728.54,"width":52.5,"height":52.5}},{"id":"1669017745296","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1110.495131689179,"posY":986.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":846.46,"y":882.35,"width":52.5,"height":52.5}},{"id":"1669017745504","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":923.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":674.23,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745728","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":673.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":443.99,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745946","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":477.49513168917906,"posY":977.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":263.46,"y":874.06,"width":52.5,"height":52.5}},{"id":"1669017747640","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":475.49513168917906,"posY":815.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":261.62,"y":724.85,"width":52.5,"height":52.5}},{"id":"1669017780767","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":510.3,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781123","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":610.67,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781698","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":918.4951316891791,"posY":847.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":669.62,"y":754.33,"width":52.5,"height":52.5}},{"id":"1669017782166","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":916.4951316891791,"posY":935.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":667.78,"y":835.38,"width":52.5,"height":52.5}},{"id":"1669017783084","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":972.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":610.67,"y":869.46,"width":52.5,"height":52.5}},{"id":"1669017783667","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":976.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":510.3,"y":873.14,"width":52.5,"height":52.5}},{"id":"1669017784240","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":678.4951392139167,"posY":937.4988242597458,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":448.59,"y":837.22,"width":52.5,"height":52.5}},{"id":"1669017785006","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":675.4951316891791,"posY":843.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":445.83,"y":750.64,"width":52.5,"height":52.5}},{"id":"1669170012773","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":746.5},"gIdx":"6","labelText":"Cc","posX":734.5,"posY":820.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":486.08,"y":745,"width":200,"height":151}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"1"}
		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"13","bgItem":{"url":"http://teach.cdn.ireadabc.com/c5adfdc66a6e6c96ebe6da6565ec1f70.png","rect":{"x":219.09,"y":0,"width":1140.81,"height":595}},"hotZoneItemArr":[{"id":"1669018212234","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":465.5733991394584,"posY":265.738764146509,"rect":{"x":179.75,"y":199,"width":133.47,"height":133.47},"circleItem":1},{"id":"1669018428827","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":700.1100806305817,"posY":398.36855045738866,"rect":{"x":417.82,"y":335.17,"width":126.4,"height":126.4},"circleItem":2},{"id":"1669018440517","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":929.0410565137215,"posY":131.18563112412767,"rect":{"x":636.78,"y":58,"width":146.37,"height":146.37},"circleItem":3},{"id":"1669022543478","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":1168.5790418503811,"posY":528.7355952934026,"rect":{"x":882.76,"y":462,"width":133.47,"height":133.47},"circleItem":4},{"id":"1669088187793","index":4,"audio_url":"http://teach.cdn.ireadabc.com/253021eecc33765f06675cdad73b3a01.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":508.5,"posY":91.5,"rect":{"x":263.91,"y":66,"width":51,"height":51}},{"id":"1669088213504","index":5,"audio_url":"http://teach.cdn.ireadabc.com/2518788213ccb81735afd87efcea0d4b.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":746.5041818824636,"posY":85.5002731976987,"rect":{"x":501.91,"y":60,"width":51,"height":51}},{"id":"1669088213739","index":6,"audio_url":"http://teach.cdn.ireadabc.com/63d19e1ff307a581b796c8dd185def79.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":986.5041818824636,"posY":83.5002731976987,"rect":{"x":741.91,"y":58,"width":51,"height":51}},{"id":"1669088214011","index":7,"audio_url":"http://teach.cdn.ireadabc.com/4529ba230c0521bf20493eae24299643.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1199.5041818824636,"posY":97.5002731976987,"rect":{"x":954.91,"y":72,"width":51,"height":51}},{"id":"1669088215319","index":8,"audio_url":"http://teach.cdn.ireadabc.com/2c3a3676cd313c128abc9a47846bf379.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":521.5041818824636,"posY":239.5002731976987,"rect":{"x":276.91,"y":214,"width":51,"height":51}},{"id":"1669088215558","index":9,"audio_url":"http://teach.cdn.ireadabc.com/8517c90273b266fdeae51c7db4d78c4d.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":749.5041818824636,"posY":237.5002731976987,"rect":{"x":504.91,"y":212,"width":51,"height":51}},{"id":"1669088215822","index":10,"audio_url":"http://teach.cdn.ireadabc.com/3bb98de81b960185c16d81da98a35c0c.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":987.5041818824636,"posY":238.5002731976987,"rect":{"x":742.91,"y":213,"width":51,"height":51}},{"id":"1669088216062","index":11,"audio_url":"http://teach.cdn.ireadabc.com/1e79b88dd5762bc75dc4ca8114124eff.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1207.5041818824636,"posY":240.50027319769868,"rect":{"x":962.91,"y":215,"width":51,"height":51}},{"id":"1669088216898","index":12,"audio_url":"http://teach.cdn.ireadabc.com/02914cba7db081e503c3d66c7d01026f.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":517.5041818824636,"posY":365.5002731976987,"rect":{"x":272.91,"y":340,"width":51,"height":51}},{"id":"1669088217138","index":13,"audio_url":"http://teach.cdn.ireadabc.com/abccf8f6ce8893cf6c3ba8c43202fe0c.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":754.5041818824636,"posY":362.5002731976987,"rect":{"x":509.91,"y":337,"width":51,"height":51}},{"id":"1669088217360","index":14,"audio_url":"http://teach.cdn.ireadabc.com/625a6ca75e12a8db5e845566934dc2d5.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":995.5041818824636,"posY":364.5002731976987,"rect":{"x":750.91,"y":339,"width":51,"height":51}},{"id":"1669088217595","index":15,"audio_url":"http://teach.cdn.ireadabc.com/b2979f011a3377e73e8a0815f7cd4d93.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1214.5041818824636,"posY":361.5002731976987,"rect":{"x":969.91,"y":336,"width":51,"height":51}},{"id":"1669088218362","index":16,"audio_url":"http://teach.cdn.ireadabc.com/5caffaa50b270c638cb2cee922d8da4f.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":510.5041818824636,"posY":491.5002731976987,"rect":{"x":265.91,"y":466,"width":51,"height":51}},{"id":"1669088218571","index":17,"audio_url":"http://teach.cdn.ireadabc.com/eb58af12affc6159b6299ac73b8aacd6.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":760.5041818824636,"posY":489.5002731976987,"rect":{"x":515.91,"y":464,"width":51,"height":51}},{"id":"1669088218819","index":18,"audio_url":"http://teach.cdn.ireadabc.com/fc549fddfeed935929831d457d2544d6.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1001.5041818824636,"posY":489.5002731976987,"rect":{"x":756.91,"y":464,"width":51,"height":51}},{"id":"1669088219087","index":19,"audio_url":"http://teach.cdn.ireadabc.com/84ce55828bd07b8e7efb25bc31c4d0ed.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1214.5041818824636,"posY":489.5002731976987,"rect":{"x":969.91,"y":464,"width":51,"height":51}}],"typeArr":[{"gIdx":"2","name":"画圈"}],"bgItem2":{"url":"http://teach.cdn.ireadabc.com/2b25e222cf2e751984a18c7a589194f4.png","rect":{"x":162.95,"y":0,"width":1253.11,"height":1621}},"hotZoneItemArr2":[{"id":"1669018544051","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":439.49543894929894,"posY":821.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":160.04,"y":726,"width":233.01,"height":191}},{"id":"1669018570547","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":689.4954389492989,"posY":960.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":402.04,"y":850,"width":249.01,"height":221}},{"id":"1669018571312","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":946.4944845617431,"posY":673.4986123129693,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":673.04,"y":586,"width":221.01,"height":175}},{"id":"1669022636621","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":1203.495438949299,"posY":1107.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":942.04,"y":1026,"width":197.01,"height":163}}],"begin_audio_url":"http://teach.cdn.ireadabc.com/a382738d66f84a7dc453e1aee978f286.mp3","idle_audio_url":"http://teach.cdn.ireadabc.com/a4758f8c14cb5859b3395514578a5f0f.mp3","finish_right_audio_url":"http://teach.cdn.ireadabc.com/b019c28398d252f09042114e1260779c.mp3"}
		
		return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/1911e3568e927257c91a8fd25d118398.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":313.64,"y":0,"width":1130.71,"height":666}},"hotZoneItemArr":[{"id":"1668059700120","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":774,"posY":221,"rect":{"x":434.36,"y":195,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1668059708822","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":840.0046289463639,"posY":286.00078101674904,"rect":{"x":500.36,"y":260,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1668059715388","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":999.0048621911851,"posY":221.00101072755757,"rect":{"x":659.4,"y":195,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1668059723401","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0054240991628,"posY":285.00078101674904,"rect":{"x":609.41,"y":259,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1668059730444","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1199.015247433881,"posY":294.00100719354515,"rect":{"x":859.42,"y":268,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1668059737547","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.026130972331,"posY":322.0010389996571,"rect":{"x":671.43,"y":296,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1668059742714","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1206.0354666133326,"posY":463.00113795200537,"rect":{"x":866.44,"y":437,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1668059747117","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.0461557810982,"posY":415.00163624775934,"rect":{"x":671.45,"y":389,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1668059754005","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1017.0554666840126,"posY":508.00146661516226,"rect":{"x":677.46,"y":482,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1668059760443","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0654879234274,"posY":451.0017952783191,"rect":{"x":609.47,"y":425,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1668059768151","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":767.0752476459216,"posY":505.00159383961,"rect":{"x":427.44,"y":479,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1668059772490","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":836.0846044909979,"posY":451.0017846762818,"rect":{"x":496.44,"y":425,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1668059780036","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":569.0848483378562,"posY":455.00159383961005,"rect":{"x":229.44,"y":429,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1668059786972","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0839047565349,"posY":416.0016079756598,"rect":{"x":430.44,"y":390,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1668059793504","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":567.0846150930352,"posY":293.0014701491747,"rect":{"x":227.44,"y":267,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1668059803802","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0838976885101,"posY":321.00103546564463,"rect":{"x":430.44,"y":295,"width":52,"height":52},"linkItem":15,"pointItem":16},{"id":"1668062996049","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/8d6671efb002131453b527eeed3bf97f.json","name":"C大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/73fe384407514cdb6367e836a45cfa03.json","name":"C大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ef6a958b04c1fed3a47881a592483df7.png","name":"C大黑_tex.png"},"dragDot":{"x":879,"y":333},"gIdx":"1","posX":890,"posY":368,"rect":{"x":464.36,"y":293,"width":224,"height":150},"rectNew":17}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":177.27,"y":0,"width":1403.46,"height":1816}},"hotZoneItemArr2":[{"id":"1668060479065","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"0","posX":761,"posY":837,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":555.73,"y":809,"width":56,"height":56}},{"id":"1668060505242","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":831.0000317275176,"posY":909.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":627.73,"y":884,"width":52,"height":52}},{"id":"1668060522174","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1010.0000129061089,"posY":836.9997553216862,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":806.73,"y":811,"width":52,"height":52}},{"id":"1668060535017","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999647770779,"posY":906.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":748.73,"y":881,"width":52,"height":52}},{"id":"1668060544062","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1228.9999803719595,"posY":917.9997561283179,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1025.73,"y":892,"width":52,"height":52}},{"id":"1668060551250","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1021.9999058929563,"posY":947.999753170668,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":818.73,"y":922,"width":52,"height":52}},{"id":"1668060557455","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1236.9999615505508,"posY":1105.99974510435,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1033.73,"y":1080,"width":52,"height":52}},{"id":"1668060563678","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1020.9999037419382,"posY":1052.9997026217416,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":817.73,"y":1027,"width":52,"height":52}},{"id":"1668060572236","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1028.9999618194279,"posY":1155.9997168722368,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":825.73,"y":1130,"width":52,"height":52}},{"id":"1668060578650","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999596684097,"posY":1092.9996891778783,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":748.73,"y":1067,"width":52,"height":52}},{"id":"1668060585215","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":750.9999803719595,"posY":1152.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":547.73,"y":1127,"width":52,"height":52}},{"id":"1668060594729","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":830.0000344162903,"posY":1092.99968998451,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":626.73,"y":1067,"width":52,"height":52}},{"id":"1668060603472","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":530.0000131749862,"posY":1095.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":326.73,"y":1070,"width":52,"height":52}},{"id":"1668060610498","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":755.0000938381665,"posY":1050.9997053105142,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":551.73,"y":1025,"width":52,"height":52}},{"id":"1668060616544","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":528.0000333407812,"posY":914.9997174099913,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":324.73,"y":889,"width":52,"height":52}},{"id":"1668060624038","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":754.0000943759211,"posY":947.9997539772997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":550.73,"y":922,"width":52,"height":52}},{"id":"1668060653013","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"6","labelText":"Cc","posX":890,"posY":1001,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":583.73,"y":913,"width":258,"height":176}}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"firstGIdx":"0","change_step_audio_url":"http://staging-teach.cdn.ireadabc.com/5d328902664fecfc2c17552394c29921.mp3","idle_2_audio_url":"http://staging-teach.cdn.ireadabc.com/13b05d0e777233d9fd9b661c76ebee2e.mp3","isDebug":true}
		return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/1911e3568e927257c91a8fd25d118398.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":313.64,"y":0,"width":1130.71,"height":666}},"hotZoneItemArr":[{"id":"1668059700120","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":774,"posY":221,"rect":{"x":434.36,"y":195,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1668059708822","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":840.0046289463639,"posY":286.00078101674904,"rect":{"x":500.36,"y":260,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1668059715388","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":999.0048621911851,"posY":221.00101072755757,"rect":{"x":659.4,"y":195,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1668059723401","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0054240991628,"posY":285.00078101674904,"rect":{"x":609.41,"y":259,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1668059730444","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1199.015247433881,"posY":294.00100719354515,"rect":{"x":859.42,"y":268,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1668059737547","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.026130972331,"posY":322.0010389996571,"rect":{"x":671.43,"y":296,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1668059742714","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1206.0354666133326,"posY":463.00113795200537,"rect":{"x":866.44,"y":437,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1668059747117","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.0461557810982,"posY":415.00163624775934,"rect":{"x":671.45,"y":389,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1668059754005","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1017.0554666840126,"posY":508.00146661516226,"rect":{"x":677.46,"y":482,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1668059760443","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0654879234274,"posY":451.0017952783191,"rect":{"x":609.47,"y":425,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1668059768151","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":767.0752476459216,"posY":505.00159383961,"rect":{"x":427.44,"y":479,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1668059772490","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":836.0846044909979,"posY":451.0017846762818,"rect":{"x":496.44,"y":425,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1668059780036","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":569.0848483378562,"posY":455.00159383961005,"rect":{"x":229.44,"y":429,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1668059786972","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0839047565349,"posY":416.0016079756598,"rect":{"x":430.44,"y":390,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1668059793504","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":567.0846150930352,"posY":293.0014701491747,"rect":{"x":227.44,"y":267,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1668059803802","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0838976885101,"posY":321.00103546564463,"rect":{"x":430.44,"y":295,"width":52,"height":52},"linkItem":15,"pointItem":16},{"id":"1668062996049","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/8d6671efb002131453b527eeed3bf97f.json","name":"C大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/73fe384407514cdb6367e836a45cfa03.json","name":"C大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ef6a958b04c1fed3a47881a592483df7.png","name":"C大黑_tex.png"},"dragDot":{"x":879,"y":333},"gIdx":"1","posX":890,"posY":368,"rect":{"x":464.36,"y":293,"width":224,"height":150},"rectNew":17}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":177.27,"y":0,"width":1403.46,"height":1816}},"hotZoneItemArr2":[{"id":"1668060479065","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"0","posX":761,"posY":837,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":555.73,"y":809,"width":56,"height":56}},{"id":"1668060505242","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":831.0000317275176,"posY":909.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":627.73,"y":884,"width":52,"height":52}},{"id":"1668060522174","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1010.0000129061089,"posY":836.9997553216862,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":806.73,"y":811,"width":52,"height":52}},{"id":"1668060535017","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999647770779,"posY":906.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":748.73,"y":881,"width":52,"height":52}},{"id":"1668060544062","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1228.9999803719595,"posY":917.9997561283179,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1025.73,"y":892,"width":52,"height":52}},{"id":"1668060551250","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1021.9999058929563,"posY":947.999753170668,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":818.73,"y":922,"width":52,"height":52}},{"id":"1668060557455","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1236.9999615505508,"posY":1105.99974510435,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1033.73,"y":1080,"width":52,"height":52}},{"id":"1668060563678","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1020.9999037419382,"posY":1052.9997026217416,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":817.73,"y":1027,"width":52,"height":52}},{"id":"1668060572236","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1028.9999618194279,"posY":1155.9997168722368,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":825.73,"y":1130,"width":52,"height":52}},{"id":"1668060578650","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999596684097,"posY":1092.9996891778783,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":748.73,"y":1067,"width":52,"height":52}},{"id":"1668060585215","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":750.9999803719595,"posY":1152.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":547.73,"y":1127,"width":52,"height":52}},{"id":"1668060594729","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":830.0000344162903,"posY":1092.99968998451,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":626.73,"y":1067,"width":52,"height":52}},{"id":"1668060603472","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":530.0000131749862,"posY":1095.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":326.73,"y":1070,"width":52,"height":52}},{"id":"1668060610498","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":755.0000938381665,"posY":1050.9997053105142,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":551.73,"y":1025,"width":52,"height":52}},{"id":"1668060616544","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":528.0000333407812,"posY":914.9997174099913,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":324.73,"y":889,"width":52,"height":52}},{"id":"1668060624038","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":754.0000943759211,"posY":947.9997539772997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":550.73,"y":922,"width":52,"height":52}},{"id":"1668060653013","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"6","labelText":"Cc","posX":890,"posY":1001,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":583.73,"y":913,"width":258,"height":176}}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"firstGIdx":"0","change_step_audio_url":"http://staging-teach.cdn.ireadabc.com/5d328902664fecfc2c17552394c29921.mp3","idle_2_audio_url":"http://staging-teach.cdn.ireadabc.com/13b05d0e777233d9fd9b661c76ebee2e.mp3","isDebug":true}
		// return {"page_id":"22","book_id":"opw1","part_name":"c","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b5fb215276c7afd3779887787bce8ccb.png","rect":{"x":250.35,"y":0,"width":889.29,"height":531}},"hotZoneItemArr":[{"id":"1667901785398","index":0,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":703,"posY":266.5,"rect":{"x":419.65,"y":233.5,"width":66,"height":66},"signItem":1},{"id":"1667902509387","index":1,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":984.0050081832392,"posY":266.50027243388246,"rect":{"x":700.65,"y":233.5,"width":66,"height":66},"signItem":2},{"id":"1667902517894","index":2,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/0a7875b1266391503571437db9db3a0f.json","name":"ku_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/422a6815028fe9f40298d9c369492b96.json","name":"ku_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/19bac79724d78938de8a654d47885586.png","name":"ku_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":423.0052954399782,"posY":484.50027243388246,"rect":{"x":139.66,"y":451.5,"width":66,"height":66},"signItem":3},{"id":"1667902630462","index":3,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":701.0052954399782,"posY":484.50027243388246,"rect":{"x":417.66,"y":451.5,"width":66,"height":66},"signItem":4},{"id":"1667902644903","index":4,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/0a7875b1266391503571437db9db3a0f.json","name":"ku_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/422a6815028fe9f40298d9c369492b96.json","name":"ku_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/19bac79724d78938de8a654d47885586.png","name":"ku_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":983.0147219589887,"posY":485.5004952878651,"rect":{"x":699.66,"y":452.5,"width":66,"height":66},"signItem":5}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/8c5a7ff4254cbc7922cb79e4794729c7.png","rect":{"x":143.31,"y":0,"width":1172.38,"height":1517}},"hotZoneItemArr2":[{"id":"1667902765218","index":0,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":716,"posY":443.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":573.08,"y":429.83,"width":70.24,"height":70.24}},{"id":"1667902778386","index":1,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":1028.9949114424535,"posY":445.49812930355085,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":901.22,"y":431.93,"width":70.24,"height":70.24}},{"id":"1667902784590","index":2,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":403.99359119896144,"posY":688.4981208674902,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"cry","key":"2"},"rect":{"x":245.98,"y":686.68,"width":70.24,"height":70.24}},{"id":"1667902791896","index":3,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":716.986227510095,"posY":687.4970958861212,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":574.12,"y":685.63,"width":70.24,"height":70.24}},{"id":"1667902798477","index":4,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":1029.9849072666034,"posY":687.4971001041515,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"cry","key":"2"},"rect":{"x":902.26,"y":685.63,"width":70.24,"height":70.24}}]}
		// return {"page_id":"13","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bg_pic_url":"http://staging-teach.cdn.ireadabc.com/103588a383dfef103f7d88081131a58b.png","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b11402c53d03d9b8966c1a5386c4d0b4.png","rect":{"x":382.88,"y":0,"width":1467.24,"height":841}},"hotZoneItemArr":[{"id":"1667284178410","index":0,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":652.5,"posY":380.5,"rect":{"x":169.62,"y":302,"width":200,"height":157},"circleItem":1},{"id":"1667285795465","index":1,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1004.5005700463794,"posY":566.4995325373978,"rect":{"x":521.62,"y":488,"width":200,"height":157},"circleItem":2},{"id":"1667285801759","index":2,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1679.500137597402,"posY":754.4993040274268,"rect":{"x":1196.62,"y":676,"width":200,"height":157},"circleItem":3}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/ef323091055c36876dfe25b5e8ed0128.png","rect":{"x":196.5,"y":0,"width":1536,"height":1987}},"hotZoneItemArr2":[{"id":"1667284877942","index":0,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":620.5,"posY":1160.5,"multRect":[{"color":"#ff0000","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20}],"rect":{"x":184.68,"y":904.39,"width":306.26,"height":204.23}},{"id":"1667284894146","index":1,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":988.5001409500544,"posY":1354.4996702166568,"multRect":[{"color":"#ffff00","width":20,"height":20,"x":20,"y":20},{"color":"#ffff00","width":20,"height":20,"x":20,"y":20},{"color":"#ffff00","width":20,"height":20,"x":20,"y":20}],"rect":{"x":525.99,"y":1079.53,"width":261.98,"height":190.46}},{"id":"1667284911442","index":2,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":1700.5000363742076,"posY":1549.4996150869986,"multRect":[{"color":"#0000ff","width":20,"height":20,"x":20,"y":20},{"color":"#0000ff","width":20,"height":20,"x":20,"y":20}],"rect":{"x":1140.35,"y":1250.58,"width":268.3,"height":186.62}}],"isDebug":false}
		// return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":234.22,"y":0,"width":867.56,"height":511}},"hotZoneItemArr":[{"id":"1667887774583","index":0,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":590,"posY":170.5,"rect":{"x":336.28,"y":151,"width":39,"height":39},"linkItem":2,"pointItem":1},{"id":"1667887788202","index":1,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":638.0000145894242,"posY":221.4999681090152,"rect":{"x":384.28,"y":202,"width":39,"height":39},"linkItem":1,"pointItem":2},{"id":"1667887795720","index":2,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":761.000005611317,"posY":170.49995856977634,"rect":{"x":507.28,"y":151,"width":39,"height":39},"linkItem":4,"pointItem":3},{"id":"1667887801441","index":3,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":720.9999826049174,"posY":220.4999681090152,"rect":{"x":467.28,"y":201,"width":39,"height":39},"linkItem":3,"pointItem":4},{"id":"1667887806805","index":4,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":911.9999900866734,"posY":226.49995875682023,"rect":{"x":658.28,"y":207,"width":39,"height":39},"linkItem":6,"pointItem":5},{"id":"1667887814385","index":5,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":767.9999543612886,"posY":247.49995763455684,"rect":{"x":514.28,"y":228,"width":39,"height":39},"linkItem":5,"pointItem":6},{"id":"1667887820091","index":6,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":919.99998129561,"posY":356.499953706635,"rect":{"x":666.28,"y":337,"width":39,"height":39},"linkItem":8,"pointItem":7},{"id":"1667887826462","index":7,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":769.9999528649374,"posY":320.4999333188499,"rect":{"x":516.28,"y":301,"width":39,"height":39},"linkItem":7,"pointItem":8},{"id":"1667887833937","index":8,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":771.9999809215223,"posY":389.49994005243036,"rect":{"x":518.28,"y":370,"width":39,"height":39},"linkItem":10,"pointItem":9},{"id":"1667887840312","index":9,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":720.9999805474345,"posY":348.4999271464013,"rect":{"x":467.28,"y":329,"width":39,"height":39},"linkItem":9,"pointItem":10},{"id":"1667887846297","index":10,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":580.9999900866734,"posY":388.4999348152012,"rect":{"x":327.28,"y":369,"width":39,"height":39},"linkItem":12,"pointItem":11},{"id":"1667887879817","index":11,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":637.0000162728193,"posY":347.49992733344516,"rect":{"x":383.28,"y":328,"width":39,"height":39},"linkItem":11,"pointItem":12},{"id":"1667887885876","index":12,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":431.0000057983608,"posY":349.499935002245,"rect":{"x":177.28,"y":330,"width":39,"height":39},"linkItem":14,"pointItem":13},{"id":"1667887891550","index":13,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":584.0000443294042,"posY":320.49993462815723,"rect":{"x":330.28,"y":301,"width":39,"height":39},"linkItem":13,"pointItem":14},{"id":"1667887898232","index":14,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":429.0000157116875,"posY":226.49994005243036,"rect":{"x":175.28,"y":207,"width":39,"height":39},"linkItem":16,"pointItem":15},{"id":"1667887904615","index":15,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":585.000044703492,"posY":247.49995763455684,"rect":{"x":331.28,"y":228,"width":39,"height":39},"linkItem":15,"pointItem":16}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":129.72,"y":0,"width":1076.55,"height":1393}},"hotZoneItemArr2":[{"id":"1667887944389","index":0,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":577,"posY":643.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":424.78,"y":621,"width":45,"height":45}},{"id":"1667887960040","index":1,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":632.004792675414,"posY":698.5014661615592,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":479.78,"y":676,"width":45,"height":45}},{"id":"1667887965560","index":2,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":769.0049179883678,"posY":641.5015914745129,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":616.79,"y":619,"width":45,"height":45}},{"id":"1667887978234","index":3,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":724.0052301315435,"posY":698.5014616047245,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":571.8,"y":676,"width":45,"height":45}},{"id":"1667887985592","index":4,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":936.0151276255474,"posY":705.5015914745129,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":783.81,"y":683,"width":45,"height":45}},{"id":"1667887992372","index":5,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":779.0256106728078,"posY":728.5016074234343,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.82,"y":706,"width":45,"height":45}},{"id":"1667887999027","index":6,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":942.0352529840694,"posY":848.5016598270331,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":789.83,"y":826,"width":45,"height":45}},{"id":"1667888007133","index":7,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":778.0456243888804,"posY":807.501933237114,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":625.84,"y":785,"width":45,"height":45}},{"id":"1667888014504","index":8,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":784.0552507512206,"posY":886.501839822003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":631.85,"y":864,"width":45,"height":45}},{"id":"1667888022599","index":9,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":724.0652644445088,"posY":839.5020198169731,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":571.86,"y":817,"width":45,"height":45}},{"id":"1667888029229","index":10,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":570.0751277622525,"posY":884.501912731358,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":417.86,"y":862,"width":45,"height":45}},{"id":"1667888036936","index":11,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":630.084776908766,"posY":839.5020152601384,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":477.86,"y":817,"width":45,"height":45}},{"id":"1667888043743","index":12,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":401.08491361380663,"posY":842.501912731358,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":248.86,"y":820,"width":45,"height":45}},{"id":"1667888050282","index":13,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":573.0843918562354,"posY":807.50191956661,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":420.86,"y":785,"width":45,"height":45}},{"id":"1667888056672","index":14,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":399.0847837440182,"posY":702.501839822003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":246.86,"y":680,"width":45,"height":45}},{"id":"1667888064637","index":15,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":572.0843872994008,"posY":727.5016005881822,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":419.86,"y":705,"width":45,"height":45}}],"isDebug":false}
		// return {"page_id":"82","book_id":"opw3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/48ecdccc083571a554a0393e88aa8e17.png","rect":{"x":0,"y":44.55,"width":2178,"height":731.91}},"hotZoneItemArr":[{"id":"1667527075823","index":0,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":353.49534883720935,"rect":{"x":987.5,"y":269.45,"width":79,"height":79},"circleItem":1,"signItem":1},{"id":"1667527184155","index":1,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1299,"posY":353.49534883720935,"rect":{"x":1259.5,"y":269.45,"width":79,"height":79},"circleItem":2,"signItem":2},{"id":"1667527190579","index":2,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":460.49534883720935,"rect":{"x":987.5,"y":376.45,"width":79,"height":79},"signItem":3},{"id":"1667527194988","index":3,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1300,"posY":463.49534883720935,"rect":{"x":1260.5,"y":379.45,"width":79,"height":79},"signItem":4},{"id":"1667527200554","index":4,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1028,"posY":571.4953488372093,"rect":{"x":988.5,"y":487.45,"width":79,"height":79},"signItem":5},{"id":"1667527205347","index":5,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1300,"posY":570.4953488372093,"rect":{"x":1260.5,"y":486.45,"width":79,"height":79},"signItem":6},{"id":"1667527210543","index":6,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":677.4953488372093,"rect":{"x":987.5,"y":593.45,"width":79,"height":79},"signItem":7},{"id":"1667527216357","index":7,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1299,"posY":678.4953488372093,"rect":{"x":1259.5,"y":594.45,"width":79,"height":79},"signItem":8},{"id":"1667527221859","index":8,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1628,"posY":355.49534883720935,"rect":{"x":1588.5,"y":271.45,"width":79,"height":79},"signItem":9},{"id":"1667527229299","index":9,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":353.49534883720935,"rect":{"x":1860.5,"y":269.45,"width":79,"height":79},"signItem":10},{"id":"1667527237415","index":10,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1627,"posY":460.49534883720935,"rect":{"x":1587.5,"y":376.45,"width":79,"height":79},"signItem":11},{"id":"1667527242936","index":11,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":461.49534883720935,"rect":{"x":1860.5,"y":377.45,"width":79,"height":79},"signItem":12},{"id":"1667527249982","index":12,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1626,"posY":569.4953488372093,"rect":{"x":1586.5,"y":485.45,"width":79,"height":79},"signItem":13},{"id":"1667527256608","index":13,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":571.4953488372093,"rect":{"x":1860.5,"y":487.45,"width":79,"height":79},"signItem":14},{"id":"1667527262126","index":14,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1627,"posY":678.4953488372093,"rect":{"x":1587.5,"y":594.45,"width":79,"height":79},"signItem":15},{"id":"1667527269087","index":15,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":679.4953488372093,"rect":{"x":1860.5,"y":595.45,"width":79,"height":79},"signItem":16}],"part_name":"e","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/cdc23fe114c7fbe4ce688c5b7cdff70e.png","rect":{"x":224.98,"y":0,"width":1728.05,"height":2236}},"hotZoneItemArr2":[{"id":"1667527318185","index":0,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1068,"posY":1726,"rect":{"x":811.02,"y":1694,"width":64,"height":64}},{"id":"1667527349948","index":1,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1265.9950206411086,"posY":1725.9983039012782,"rect":{"x":1009.02,"y":1694,"width":64,"height":64}},{"id":"1667527354975","index":2,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1067.9948260712667,"posY":1803.9983039012782,"rect":{"x":811.01,"y":1772,"width":64,"height":64}},{"id":"1667527363008","index":3,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.9850206509354,"posY":1803.9982272525526,"rect":{"x":1010.01,"y":1772,"width":64,"height":64}},{"id":"1667527368695","index":4,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1068.9848250984178,"posY":1883.9982272525526,"rect":{"x":812,"y":1852,"width":64,"height":64}},{"id":"1667527374694","index":5,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.9750196780863,"posY":1882.9981486384752,"rect":{"x":1010,"y":1851,"width":64,"height":64}},{"id":"1667527380289","index":6,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1066.9748251082444,"posY":1962.998149621151,"rect":{"x":809.99,"y":1931,"width":64,"height":64}},{"id":"1667527388175","index":7,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.965021653265,"posY":1960.9980710070736,"rect":{"x":1009.99,"y":1929,"width":64,"height":64}},{"id":"1667527393603","index":8,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1506.964825118071,"posY":1724.9980729724255,"rect":{"x":1249.98,"y":1693,"width":64,"height":64}},{"id":"1667527399645","index":9,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.9545892856654,"posY":1724.998304883954,"rect":{"x":1448.97,"y":1693,"width":64,"height":64}},{"id":"1667527406504","index":10,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1505.9443937429746,"posY":1803.998304883954,"rect":{"x":1248.96,"y":1772,"width":64,"height":64}},{"id":"1667527414914","index":11,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.934590287995,"posY":1804.9982272525526,"rect":{"x":1448.95,"y":1773,"width":64,"height":64}},{"id":"1667527423039","index":12,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1506.924393762628,"posY":1883.9982262698766,"rect":{"x":1249.94,"y":1852,"width":64,"height":64}},{"id":"1667527431966","index":13,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.9145893249724,"posY":1883.9981486384752,"rect":{"x":1448.93,"y":1852,"width":64,"height":64}},{"id":"1667527439422","index":14,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1507.9043937822817,"posY":1962.9981486384752,"rect":{"x":1250.92,"y":1931,"width":64,"height":64}},{"id":"1667527445613","index":15,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.8945883619504,"posY":1963.9980710070736,"rect":{"x":1448.91,"y":1932,"width":64,"height":64}}],"isDebug":false}
		return this.item = {"begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","page_id":"7","book_id":"opw1","part_name":"d","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/75bcd934bdd589d901b1d1dcf9e05e2b.png","rect":{"x":455.89,"y":0,"width":1729.22,"height":992}},"hotZoneItemArr":[{"id":"1667291729830","index":0,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":496},"gIdx":"0","posX":714.5,"posY":509,"rect":{"x":232.61,"y":483,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1667291758660","index":1,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":863.4985828918223,"posY":708.0011902773308,"rect":{"x":381.61,"y":682,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1667291766274","index":2,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1038.4989313227106,"posY":767.0016556313363,"rect":{"x":556.61,"y":741,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1667291773931","index":3,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1208.4993405536202,"posY":565.0017936006144,"rect":{"x":726.61,"y":539,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1667291781144","index":4,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1365.499738092218,"posY":554.0013212312218,"rect":{"x":883.61,"y":528,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1667291787620","index":5,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1519.500105230805,"posY":368.0012955081361,"rect":{"x":1037.61,"y":342,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1667291794068","index":6,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1697.5004653540052,"posY":452.00086055414096,"rect":{"x":1215.61,"y":426,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1667291799074","index":7,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1762.5008816003017,"posY":565.0010569849775,"rect":{"x":1280.61,"y":539,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1667291806543","index":8,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1672.501033600354,"posY":721.0013212312218,"rect":{"x":1190.61,"y":695,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1667291814677","index":9,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1477.5008231387435,"posY":705.0016860313468,"rect":{"x":995.61,"y":679,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1667291823228","index":10,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1371.5003671385873,"posY":813.0016486159494,"rect":{"x":889.61,"y":787,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1667291830926","index":11,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1199.5001192615794,"posY":812.0019011698821,"rect":{"x":717.61,"y":786,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1667291842195","index":12,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1326.4997170460567,"posY":247.00189883141968,"rect":{"x":844.61,"y":221,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1667291853247","index":13,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1130.500014030774,"posY":267.00057760019786,"rect":{"x":648.61,"y":241,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1667291861161","index":14,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1060.4995556921554,"posY":407.00062436944467,"rect":{"x":578.61,"y":381,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1667291869501","index":15,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":891.4993919997917,"posY":447.0009517541722,"rect":{"x":409.61,"y":421,"width":52,"height":52},"linkItem":15,"pointItem":16}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/71e68ebc76a7ce04eef418353d3f1844.png","rect":{"x":191.67,"y":0,"width":1499.67,"height":1940}},"hotZoneItemArr2":[{"id":"1667380287432","index":0,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":670.5,"posY":1410.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":277.93,"y":1022.76,"width":36.15,"height":36.15}},{"id":"1667380314762","index":1,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":827.4994456359115,"posY":1617.5012714317836,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":393.79,"y":1175.51,"width":36.15,"height":36.15}},{"id":"1667380322503","index":2,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1007.4995871564998,"posY":1680.5014580226232,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":526.61,"y":1222,"width":36.15,"height":36.15}},{"id":"1667380329891","index":3,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1185.4997494094036,"posY":1470.5015148111395,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":657.96,"y":1067.03,"width":36.15,"height":36.15}},{"id":"1667380339099","index":4,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1346.4999098594978,"posY":1458.5013255160848,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":776.77,"y":1058.18,"width":36.15,"height":36.15}},{"id":"1667380346091","index":5,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1507.5000549857066,"posY":1264.5013146992246,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":895.57,"y":915.02,"width":36.15,"height":36.15}},{"id":"1667380353829","index":6,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1690.500200111915,"posY":1351.5011398266504,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1030.61,"y":979.22,"width":36.15,"height":36.15}},{"id":"1667380360920","index":7,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1756.500365069034,"posY":1469.5012182488872,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1079.31,"y":1066.3,"width":36.15,"height":36.15}},{"id":"1667380368760","index":8,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1664.5004245617654,"posY":1629.5013246146798,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1011.42,"y":1184.36,"width":36.15,"height":36.15}},{"id":"1667380374561","index":9,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1462.5003416325035,"posY":1613.5014688394833,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":862.36,"y":1172.56,"width":36.15,"height":36.15}},{"id":"1667380381923","index":10,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1350.500159548689,"posY":1725.501454417003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":779.72,"y":1255.2,"width":36.15,"height":36.15}},{"id":"1667380387739","index":11,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1174.5000585913265,"posY":1723.5015553743654,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":649.84,"y":1253.73,"width":36.15,"height":36.15}},{"id":"1667380395200","index":12,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1306.4998999440427,"posY":1140.5015535715554,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":747.24,"y":823.52,"width":36.15,"height":36.15}},{"id":"1667380402254","index":13,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1101.5000189295056,"posY":1160.5010280524275,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":595.97,"y":838.28,"width":36.15,"height":36.15}},{"id":"1667380408975","index":14,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1028.499834141476,"posY":1304.501046080528,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":542.1,"y":944.53,"width":36.15,"height":36.15}},{"id":"1667380417184","index":15,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":853.4997683389092,"posY":1346.5011758828512,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":412.97,"y":975.53,"width":36.15,"height":36.15}}],"isDebug":true}
	
	},

	preload() {
		const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
		console.log(' in preload preloadArr: ', preloadArr);
		cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {
			console.log(' preload data, ', data);


			this.addServerListener();
			// if (window && window["air"]) {
			// 	window["air"].hideAirClassLoading();
			// }
		});
	},

	addServerListener() {
		
		if (window && window["air"]) {
			// cc.find('Canvas').opacity = 0;
			// window.air.onCourseInScreen = (next) => {
			// 	//  cc.find('Canvas').opacity = 255;
			// 	this.loadEnd();
			// 	next();
			// }
			this.loadEnd();
			window.air.hideAirClassLoading();
		} else {
			this.loadEnd();
		}


		if (window.air) {

			window.air.osmoHandwritingCallback = (data) => {

				if (!data) {
					console.log('data is not exist!!!');
					return;
				}

				console.log('osmoHandwritingCallback data: ', data);

				if (typeof (data) == 'string') {
					console.log('data is string ');
					const dataObj = JSON.parse(data);

					this.photoEnd(dataObj);
					return;
				}

				// 哲学逻辑
				this.photoEnd(data);

			}

			
		}

	},

	addPreloadImage() {
	
		if (this.data.bg_pic_url) {
			this._imageResList.push({ url: this.data.bg_pic_url || ''});
		}

		if (this.data.bgItem) {
			this._imageResList.push({ url: this.data.bgItem.url || ''});
		}

		if (this.data.bgItem2) {
			this._imageResList.push({ url: this.data.bgItem2.url || ''});
		}

		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.pic_url) {
				this._imageResList.push({ url: item.pic_url || ''});
			}
		})
	},

	addPreloadAudio() {

		if (this.data.questionArr) {
			const arr = this.data.questionArr;
			for (let i=0 ;i<arr.length; i++) {
				this._audioResList.push({url: arr[i].audio_url || ''});
				this._audioResList.push({url: arr[i].video_url || ''});
			}
		}

	},

	addPreloadAnima() {
		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.skeJsonData) {
				this._animaResList.push({ url: item.skeJsonData.url || '' });
				this._animaResList.push({ url: item.texJsonData.url || ''});
				this._animaResList.push({ url: item.texPngData.url || ''});
			}
		})
	},

	loadEnd() {
		console.log(' in loadEnd');

		// this.data.isDebug = true;

		this.initData();
		this.initView();
		// this.initMusic();

		// this.startTesting();

		// cc.debug.setDisplayStats(true);

	},

	initMusic() {
		cc.assetManager.loadRemote(this.data.bg_audio_url, (err, clip) => {
			cc.audioEngine.setMusicVolume(0.3);
			const audioID = cc.audioEngine.playMusic(clip, true);
		});
	},

	curGroupIndex: null,
	curQuestionIndex: null,
	curQuestionData: null,

	picNodeArr: null,


	firstItemData: null,
	bottomItemData: null,
	animaNodeArr: null,
	circleAnimaNodeArr: null,
	signAnimaNodeArr: null,

	initData() {
		console.log(' in initData');

		// this.curGroupIndex = 0;
		// this.curQuestionIndex = 0;
		// this.setCurGroupAndQuestion()

		// console.log('this.curQuestionData', this.curQuestionData)

		this.CHECK_TYPE_LINE = 'LINE';
		this.CHECK_TYPE_WRITE = 'WRITE';
		this.CHECK_TYPE_CIRCLE = 'CIRCLE';
		this.CHECK_TYPE_SIGN = 'SIGN';
		this.CHECK_TYPE_COLOR = 'COLOR';

		this.isHelp = true;

		this.colorUnit = 0.0035;
		this.colorSprPoolArr = [];

		this.totalLineArr = [];
		this.rectNodeArr = [];

		this.picAnimNodeArr = []
		this.colorPicNodeArr = [];

		this.animaNodeArr = [];

		this.circleAnimaNodeArr = [];
		this.signAnimaNodeArr = [];

		this.picNodeArr = [];
		this.initAudioEffect();

		this.linkRectGroup = [];

		this.centerItemArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '1');
		this.benchmark1Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '3')[0];
		this.benchmark2Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '4')[0];
		this.firstItemData = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '5')[0];

		this.lineRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '0');
		this.newRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '6');
		this.circleRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '7');
		this.signRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '8');
		this.colorRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '9');


		if (this.benchmark1Data) {
			this.initCheckBase();
		} 



		this.initTypeArr();
		
	},

	initTypeArr() {
		const typeArr = this.data.typeArr;
		
		console.log('this.data.typeArr: ', this.data);

		if (!this.data.firstGIdx) {
			this.data.firstGIdx = typeArr[0].gIdx;
		} else {

			const findItem = typeArr.find(it => {
				return it.gIdx == this.data.firstGIdx
			})

			console.log('findItem: ', findItem);

			if (!findItem) {
				this.data.firstGIdx = typeArr[0].gIdx;
			}

		}

		console.log('this.data.typeArr.length: ', this.data.typeArr.length);

		console.log('arr: ', JSON.stringify(this.data.typeArr));

		console.log('this.data.firstGIdx: ', this.data.firstGIdx);
		this.typeArr = [];
		const firstType = typeArr.find((t) => {
			console.log('t.gIdx: ', t.gIdx);
			return t.gIdx == this.data.firstGIdx;
		})

		const index = typeArr.indexOf(firstType);
		console.log('firstType: ', firstType);
		typeArr.splice(index, 1);

		this.typeArr = [firstType];
		this.typeArr = this.typeArr.concat(typeArr)
		this.typeArrIndex = 0;

		console.log("this.typeArr: ", this.typeArr);
	},

	initCheckBase() {


		console.log('benchmark1Data: ', this.benchmark1Data);
		console.log('benchmark2Data: ', this.benchmark2Data);
		console.log('centerItemArr: ', this.centerItemArr);

		const benchmark1Rect = this.benchmark1Data.rect;
		const benchmark2Rect = this.benchmark2Data.rect;
		
		const benchmark1CenterY = (benchmark1Rect.y + benchmark1Rect.height / 2);
		const benchmark2CenterY = (benchmark2Rect.y + benchmark2Rect.height / 2);
		
		let unitH = benchmark2CenterY - benchmark1CenterY;
		let unitW = benchmark2Rect.x + benchmark2Rect.width - benchmark1Rect.x;
		let baseX = benchmark1Rect.x;
		let baseY = benchmark1CenterY;


		if (this.firstItemData) {
			const firstItemRect = this.firstItemData.rect;
			baseX = firstItemRect.x + firstItemRect.width / 2;
			baseY = firstItemRect.y + firstItemRect.height / 2;
			unitW = benchmark1Rect.x + benchmark1Rect.width - (firstItemRect.x + firstItemRect.width / 2);
			unitH = (firstItemRect.y + firstItemRect.height / 2) - benchmark1CenterY;
		}


		for(let i=0; i<this.centerItemArr.length; i++) {

			const itemRect = this.centerItemArr[i].rect;
			const x = itemRect.x + itemRect.width / 2;
			const y = itemRect.y + itemRect.height / 2;

			const unitX = (x - baseX) / unitW;
			const unitY = (y - baseY) / unitH;
			const unitW2 = itemRect.width / unitW;
			const unitH2 = itemRect.height / unitH;


			this.centerItemArr[i].unitX = unitX;
			this.centerItemArr[i].unitY = unitY;
			this.centerItemArr[i].unitW = unitW2;
			this.centerItemArr[i].unitH = unitH2;

			// console.log('unitX: ', unitX)
			// console.log('unitY: ', unitY)
		}

		console.log('unitH: ', unitH)
		console.log('unitW: ', unitW)
		console.log('baseX: ', baseX)
		console.log('baseY: ', baseY)

	
		const centerX = this.data.bgItem2.rect.width / 2;
		this.centerUnitW = (centerX - baseX) / unitW;



	},

	getGroupArrByGIdx(arr, gIdx) {
		const groupArr = [];
		for (let i=0; i<arr.length; i++) {
			if (arr[i].gIdx == gIdx) {

				const data = JSON.parse(JSON.stringify(arr[i]));
				groupArr.push(data);
			}
		}

		return groupArr;
	},

	curGroup: null,
	setCurGroupAndQuestion() {
		this.curGroup = this.data.groupArr[this.curGroupIndex];

		if (!this.curGroup) {
			this.gameEnd();
		} else {
			this.curQuestionIndex = 0;
			this.setCurQuestionData();
		}
	},

	setCurQuestionData() {
		this.curQuestionData = this.curGroup.questionArr[this.curQuestionIndex];

		if (!this.curQuestionData) {

			this.hideVideo();
			this.showBigStar();
		}
	},

	hideVideo() {
		this.videoNode.active = false;

		this.videoNode.player.pause();
		this.videoNode.pauseBtn.active = false;
		this.videoNode.playBtn.active = true;
	},


	rightClip: null,
	wrongClip: null,
	bigStarClip: null,
	btnClip: null,
	finishClip: null,
	selectClip: null,
	starCountClip: null,
	helpClip: null,
	initAudioEffect() {
		this.rightClip = cc.find('Canvas/res/audio/right').getComponent(cc.AudioSource).clip;
		this.wrongClip = cc.find('Canvas/res/audio/wrong').getComponent(cc.AudioSource).clip;
		this.bigStarClip = cc.find('Canvas/res/audio/big_star').getComponent(cc.AudioSource).clip;
		this.btnClip = cc.find('Canvas/res/audio/btn').getComponent(cc.AudioSource).clip;
		this.finishClip = cc.find('Canvas/res/audio/finish').getComponent(cc.AudioSource).clip;
		this.selectClip = cc.find('Canvas/res/audio/select').getComponent(cc.AudioSource).clip;
		this.starCountClip = cc.find('Canvas/res/audio/star_count').getComponent(cc.AudioSource).clip;

		
		this.helpClip = cc.find('Canvas/res/audio/help').getComponent(cc.AudioSource).clip;
	},



	initView() {

		console.log(' in initView');

		this.initBg();
		this.initHotZone();
		this.initDebugLayer();

		console.log(' in initView 2');
	
		this.initCat();
	},


	initCat() {

		const cat = cc.find("Canvas/catNode/cat")
		cat.parent.zIndex = 10;
		this.cat = cat;

		this.canTouch = false;
		this.playCatAudio(this.data.begin_audio_url, () => {
			this.canTouch = true;
			// this.isPanelMoveEnd = true;

			this.catBeginEnd = true;
			this.checkStart();
		});

		this.curCatAudioUrl = this.data.idle_audio_url;

		const clickBox = cc.find("Canvas/catNode/clickBox")
		clickBox.on('touchstart', () => {

			console.log(' in cat touchstart')

			let url = this.curCatAudioUrl;
			if (!url) {
				return;
			}
 
			if (!this.canTouch) {
				return;
			}
			
			this.canTouch = false;

			this.playCatAudio(url, () => {
				this.canTouch = true;
			})

		})
	},

	playCatAudio(audioUrl, cb=null) {

		console.log('_ playCatAudio:  ', audioUrl);

		if (this.curCatAudioId) {
			cc.audioEngine.pauseEffect(this.curCatAudioId);
		}

		if (audioUrl) {

			this.playCatAnim('begin');
			playAudioByUrl(audioUrl, () => {
				this.playCatAnim('normal');
				cb && cb();
			})
		} else {
			cb && cb();

		}
		
	},

	playCatAnim(name, times = 0) {
		const cat = cc.find("Canvas/catNode/cat")		
		var dragonDisplay = cat.getComponent(dragonBones.ArmatureDisplay);
		const state = dragonDisplay.playAnimation(name, times);
	},
	


	initTestPointArr() {
		
		const linkeItemArr = this.data.hotZoneItemArr.filter(hzItem => {
			return hzItem.gIdx == '0';
		})

		const bgRect = this.data.bgItem2.rect;

		const setDebugCenterPos = (hzItem) => {

			const debugItemIndex = (Number(hzItem.pointItem) - 1) 
			const debugItem = this.data.hotZoneItemArr2[debugItemIndex];
			const {rect} = debugItem

			const left = Math.round( (rect.x ) / bgRect.width  * 1000 ) / 1000;
			const right =  Math.round( (rect.x + rect.width) / bgRect.width * 1000 ) / 1000;
			const top =  Math.round( (rect.y ) / bgRect.height * 1000 ) / 1000;
			const bottom =  Math.round( (rect.y + rect.height) / bgRect.height * 1000 ) / 1000;
	
			
			const x = left + (right - left) / 2;
			const y = bottom - (bottom - top) / 2;

			hzItem.debugCenterPos = [x, y];
		}

		console.log('linkeItemArr: ', linkeItemArr);

		linkeItemArr.forEach(hzItem => {
			return setDebugCenterPos(hzItem);
		})

		const startPosObj = {};
		const endPosObj = {};

		for (let i=0; i<linkeItemArr.length; i++) {
			const index = this.data.hotZoneItemArr.indexOf(linkeItemArr[i]);
			const key = (index + 1).toString();
			if (!startPosObj[key] && !endPosObj[key]) {
				startPosObj[key] = linkeItemArr[i];


				const endKey = linkeItemArr[i].linkItem.toString();
				const endIndex = Number(endKey) - 1;
				const endItem = this.data.hotZoneItemArr[endIndex];
				endPosObj[endKey] = endItem;
			}
		}

		console.log('startPosObj: ', startPosObj);
		console.log('endPosObj: ', endPosObj);

		
		console.log('this.end_points: ', this.end_points);

	
	},

	resetHotZoneBg() {

		this.hotZoneBg.opacity = 0;	
		const panel = this.hotZoneBg.parent;
		const w = panel.width * 0.95;
		const h = panel.height * 0.9;
		

		const region = this.getRegionsByGidx('2')[0];
		const partW = region.right - region.left;
		const partH = region.bottom - region.top;
		const scaleX = w / partW;
		const scaleY = h / partH;
		const scale = Math.min(scaleX, scaleY);
		const bgW = partW * scale;
		const bgH = partH * scale;

		const node = new cc.Node();
		node.parent = panel;
		node.width = bgW / partW;
		node.height = bgH / partH;

		const rectX = (-0.5 + region.left) * node.width;
		const rectY = (0.5 - region.bottom) * node.height;
		const rectW = partW * node.width;
		const rectH = partH * node.height;
		const ctx = node.addComponent(cc.Graphics);
		ctx.rect(rectX, rectY, rectW, rectH);
		ctx.fillColor = cc.Color.WHITE;
		ctx.fill();

		node.y = 3 - (rectY + rectH / 2);

		this.colorDrawLayer = new cc.Node();
		node.addChild(this.colorDrawLayer);
		
		this.colorBg = node;
	},


	checkStart() {

		console.log(' in checkStart')
		if (this.debugBgImg && this.hzLoadEnd && this.catBeginEnd) {
			this.startTesting();

		}

	},

	getSendCirclePoints(tempCirclePointArr) {

		console.log('tempCirclePointArr: ' , tempCirclePointArr);


		
		const sendCirclePointArr = [];

		for (let i=0; i<tempCirclePointArr.length; i++) {
			const {left, top, right, bottom} = tempCirclePointArr[i];

			const newLeft = left + (right - left) / 2;
			const newTop = top + (bottom - top) / 2;
			const data = {
				left: newLeft,
				right: newLeft,
				top: newTop,
				bottom: newTop
			}

			sendCirclePointArr.push(data);
			// const tempLink1 = tempCirclePointArr[i];
			// const key2 = tempLink1.linkItem;
			// const tempLink2 = tempCirclePointArr[Number(key2)-1];

			// if (!tempLink1.isGetLinked && !tempLink2.isGetLinked) {
			// 	tempLink1.isGetLinked = true;
			// 	tempLink2.isGetLinked = true;

			// 	const pKey1 = tempLink1.pointItem;
			// 	const pKey2 = tempLink2.pointItem;

			// 	const pointItem1 = this.data.hotZoneItemArr2[Number(pKey1) - 1];
			// 	const pointItem2 = this.data.hotZoneItemArr2[Number(pKey2) - 1];

			// 	const region1 = this.getRegionByRect(pointItem1.rect, bgRect);
			// 	const region2 = this.getRegionByRect(pointItem2.rect, bgRect);

			// 	let x1 = region1.left + (region1.right - region1.left) / 2;
			// 	let y1 = region1.top + (region1.bottom - region1.top) / 2;

			// 	let x2 = region2.left + (region2.right - region2.left) / 2;
			// 	let y2 = region2.top + (region2.bottom - region2.top) / 2;

			// 	x1 = Math.floor(x1 * 1000) / 1000;
			// 	y1 = Math.floor(y1 * 1000) / 1000;
			// 	x2 = Math.floor(x2 * 1000) / 1000;
			// 	y2 = Math.floor(y2 * 1000) / 1000;

			// 	sendCirclePointArr.push( {left:x1, top: y1, right:x2, bottom: y2} )
			// }
		}

		console.log("sendCirclePointArr: ", sendCirclePointArr);
		return sendCirclePointArr;
	},


	getSendLinePoints() {

		const hotZoneItemArr = JSON.parse( JSON.stringify(this.data.hotZoneItemArr) );

		const tempLinkArr = this.getGroupArrByGIdx(hotZoneItemArr, '0');

		console.log('tempLinkArr: ' , tempLinkArr);

		const bgRect = this.data.bgItem2.rect;
		
		const sendLinkPointArr = [];


		for (let i=0; i<tempLinkArr.length; i++) {
			const tempLink1 = tempLinkArr[i];
			const key2 = tempLink1.linkItem;
			const tempLink2 = hotZoneItemArr[Number(key2)-1];

			if (!tempLink1.isGetLinked && !tempLink2.isGetLinked) {
				tempLink1.isGetLinked = true;
				tempLink2.isGetLinked = true;

				const pKey1 = tempLink1.pointItem;
				const pKey2 = tempLink2.pointItem;

				const pointItem1 = this.data.hotZoneItemArr2[Number(pKey1) - 1];
				const pointItem2 = this.data.hotZoneItemArr2[Number(pKey2) - 1];

				const region1 = this.getRegionByRect(pointItem1.rect, bgRect);
				const region2 = this.getRegionByRect(pointItem2.rect, bgRect);

				let x1 = region1.left + (region1.right - region1.left) / 2;
				let y1 = region1.top + (region1.bottom - region1.top) / 2;

				let x2 = region2.left + (region2.right - region2.left) / 2;
				let y2 = region2.top + (region2.bottom - region2.top) / 2;

				x1 = Math.floor(x1 * 1000) / 1000;
				y1 = Math.floor(y1 * 1000) / 1000;
				x2 = Math.floor(x2 * 1000) / 1000;
				y2 = Math.floor(y2 * 1000) / 1000;

				sendLinkPointArr.push( {left:x1, top: y1, right:x2, bottom: y2} )
			}
		}

		console.log("sendLinkPointArr: ", sendLinkPointArr);
		return sendLinkPointArr;

		// for (let i=0; i<regions.length; i++) {
		// 	const oneRegion = regions[i];
		// 	console.log('oneRegion: ', oneRegion);
		// 	const x = oneRegion.left + (oneRegion.right - oneRegion.left) / 2;
		// 	const y = oneRegion.top + (oneRegion.bottom - oneRegion.top) / 2;
		// }
	},


	resetHelperTime() {

		this.helperTime = new Date().getTime();

	},

	showHelper() {

		if (!this.isHelp) {
			return;
		}

		if (this.itemCombineGroup && this.itemCombineGroup.length > 0) {
			return;
		}

		console.log("in showHelper");

		playAudio(this.helpClip, () => {

			switch(this.curCheckGroup) {
				case this.CHECK_TYPE_LINE:
					this.showHelperLink();
					// 连线
					break;
	
				case this.CHECK_TYPE_WRITE:
					this.showHelperWrite();
					// 手写
					break;
	
				case this.CHECK_TYPE_CIRCLE:
					this.showHelperCircle();
					// 画圈
					break;
	
				case this.CHECK_TYPE_SIGN:
					this.showHelperSign();
					// 符号
					break;
			}

		})

		
	},

	showHelperSign() {

		for (let i = 0; i < this.signAnimaNodeArr.length; i++) {

			const animaNode = this.signAnimaNodeArr[i];

			if (!animaNode.isShowEnd) {
		
				this.showSign(animaNode);
				break;
			}
			
		}
	},
	

	showHelperCircle() {
		
		for (let i = 0; i < this.circleAnimaNodeArr.length; i++) {

			const animaNode = this.circleAnimaNodeArr[i];

			if (!animaNode.isShowEnd) {

				this.showCircle(animaNode);
				break;				
			}
			
		}

	},

	showHelperWrite() {

		let arr = this.animaNodeArr;
		if (this.picAnimNodeArr.length > 0) {
			arr = this.picAnimNodeArr;
		}

		for (let i = 0; i < arr.length; i++) {

			const animaNode = arr[i];
			if (!animaNode.isShowEnd) {

				if (this.picAnimNodeArr.length > 0) {
					this.showLetterPic(animaNode);
				} else {
					this.showLetter(animaNode);
				}
				break;
			}
		}
	},

	
	showHelperLink() {

		console.log(' in showHelperLink..');
		
		let item;
		for (let i=0; i<this.linkRectGroup.length; i++) {

			const {hzItemId} = this.linkRectGroup[i].linkData;

			const rectNode = this.getItemById(hzItemId);
			
			if (!rectNode.isShowEnd && this.linkRectGroup[i].isRightPoint) {
				item = this.linkRectGroup[i];
				break;
			}
		}

		if (item) {
			const {hzItemId, linkHzItemId} = item.linkData
			this.showSuccess(hzItemId, linkHzItemId);
		}
	},


	startHelper() {

		this.resetHelperTime();
		this.isHelpCountDown = true;

		const checkTime = () => {

			if (!this.isHelpCountDown) {
				return;
			}

			const curTime = new Date().getTime();
			if (curTime - this.helperTime > 10 * 1000) {
				this.showHelper();
				this.resetHelperTime();
			} 
			// else {
	
			// 	delayCall(0.1, () => {
			// 		checkTime();
			// 	})
			// }

			delayCall(0.05, () => {
				checkTime();
			})
		}

		checkTime();
		
	},

	stopHelper() {
		this.isHelpCountDown = false;
	},


	//调起检测
	startTesting() {


		this.isGameEnd = false;

		this.startHelper();


		const writeRegions = this.getRegionsByGidx('6')
		const circleRegions = this.getRegionsByGidx('7')
		const signRegions = this.getRegionsByGidx('8')
		const colorRegions = this.getRegionsByGidx('9')
		const partRegions = this.getRegionsByGidx('2')

		// this.changeRegionTo4Pos(signRegions);


		// let lineRegions = this.getRegionsByGidx('0')

		const newPoints = this.getSendLinePoints();
		const newCirclePoints = this.getSendCirclePoints(circleRegions);

		console.log('writeRegions: ', writeRegions);
		console.log('circleRegions: ', circleRegions);
		console.log('newPoints: ', newPoints);
		console.log('signRegions: ', JSON.stringify(signRegions));
		console.log('newCirclePoints: ', newCirclePoints);

		

	 

		// const tempType = this.typeArr[this.typeArrIndex];
		// this.curCheckType = '';
		// switch(tempType.gIdx) {
		// 	case "0":
		// 		// 连线
		// 		this.curCheckGroup = this.CHECK_TYPE_LINE;
		// 		break;

		// 	case "1":
		// 		// 手写
		// 		this.curCheckGroup = this.CHECK_TYPE_WRITE;
		// 		break;

		// 	case "2":
		// 		// 画圈
		// 		this.curCheckGroup = this.CHECK_TYPE_CIRCLE;
		// 		break;

		// 	case "4":
		// 		// 符号
		// 		this.curCheckGroup = this.CHECK_TYPE_SIGN;
		// 		this.initItemCombineGroup();
		// 		break;

		// 	case "5":
		// 		// 涂色
		// 		this.curCheckGroup = this.CHECK_TYPE_COLOR;
		// 		break;
		// 	}

		// 	// setInterval(() => {
		// 		this.getPhotoData((data) => { 
		// 			this.photoEnd(data);
		// 		});    
		// 	// }, 3000);

		// 	console.log('curCheckGroup: ', JSON.stringify( this.curCheckGroup ));

		// return;





		// write_regions : []

		let lineType = 1;
		let circleSize = 1;

		if (this.data.lineType == '0') {
			lineType = 0;
		}
		if (this.data.circleSize == '0') {
			circleSize = 0;
		}
		
		

		const para = {
			"library_id": "iplayabc",
			"page_id": this.data.page_id, //27,
			"book_id": this.data.book_id,//"opw1",
			"part_name": this.data.part_name, //"d",
		
			"write_regions": [],
			"circle_regions": [],//circleRegions,
			"line_regions": [],
			'sign_regions': [],
			'color_regions': [],
			lineType,
			circleSize
		}


	

		const curCheckGroup = this.typeArr[this.typeArrIndex];
		this.curCheckType = '';
		switch(curCheckGroup.gIdx) {
			case "0":
				// 连线
				para.line_regions = newPoints;
				this.curCheckGroup = this.CHECK_TYPE_LINE;
				break;

			case "1":
				// 手写
				para.write_regions = writeRegions;
				this.curCheckGroup = this.CHECK_TYPE_WRITE;
				break;

			case "2":
				// 画圈
				para.circle_regions = newCirclePoints;
				this.curCheckGroup = this.CHECK_TYPE_CIRCLE;
				break;

			case "4":
				// 符号
				para.sign_regions = signRegions;
				this.curCheckGroup = this.CHECK_TYPE_SIGN;
				this.initItemCombineGroup();
				break;

			case "5":
				// 涂色
				// para.color_regions = colorRegions;
				para.color_regions = partRegions;
				this.curCheckGroup = this.CHECK_TYPE_COLOR;
				this.preloadColorSpr();
				break;
				
			case "6":
				// 手写图片
				para.write_regions = writeRegions;
				this.curCheckGroup = this.CHECK_TYPE_WRITE;
				break;
		}


		console.log('curCheckGroup: ', JSON.stringify( this.curCheckGroup ));
		console.log('para: ', JSON.stringify( para ));


		const cw = window.courseware;
		if (!cw || !cw.openOsmoHandwriting) {

			console.log('cw.openOsmoHandwriting not exist');
			return;
		}

		cw.openOsmoHandwriting(para);

	},

	//结束检测
	endTesting() {
		
		this.stopHelper();

		const cw = window.courseware;
		if (!cw || !cw.closeOsmoHandwriting) {

			return;
		}
		cw.closeOsmoHandwriting();

		// const cw = window.courseware;
		// if (!cw || !cw.closeOsmoHandwritingMlkit) {

		// 	return;
		// }
		// cw.closeOsmoHandwritingMlkit();
		// // this.isTesting = false;
	},

	changeRegionTo4Pos(regions) {

		for (let i=0; i<regions.length; i++) {
			const {left, top, right, bottom} = regions[i];
			regions[i] = [

					left, top,
					right, top,
					right, bottom,
					left, bottom

			]
		}
		
	},

	initItemCombineGroup() {
		this.itemCombineGroup = this.data?.itemCombineGroup;
	},

	preloadColorSpr() {
		for (let i=0; i<20000; i++) {

			const colorNode = this.getColorBgColorDot(0, 0, this.colorUnit, this.colorUnit);
		}
	},

	getRegionsByGidx(gIdx) {

		const arr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, gIdx);
		const bgRect = this.data.bgItem2.rect;
		
		console.log("arr:", arr);
		const newLocationArr = [];
		for (let i=0; i<arr.length; i++) {

			const hzItem = arr[i];
			const regionRect = hzItem.rect;

			const region = this.getRegionByRect(regionRect, bgRect);

			newLocationArr.push(region)
		}

		return newLocationArr;

	},

	getRegionByRect(regionRect, bgRect) {

		const left = Math.round( (regionRect.x ) / bgRect.width  * 1000 ) / 1000;
		const right =  Math.round( (regionRect.x + regionRect.width) / bgRect.width * 1000 ) / 1000;
		const top =  Math.round( (regionRect.y ) / bgRect.height * 1000 ) / 1000;
		const bottom =  Math.round( (regionRect.y + regionRect.height) / bgRect.height * 1000 ) / 1000;

		return {left, top, right, bottom};
	},



	changeWriteData(result) {
		const curTextArr = result.text;
		const bboxTextArr = [];
		for (let i=0; i<curTextArr.length; i++) {

			const score = curTextArr[i].score;

			const {left, right, top, bottom} = curTextArr[i];
			const text = curTextArr[i].content;

			console.log('text..', JSON.stringify( curTextArr[i] ));
			console.log('text..', text);
			const disW = (right - left) / text.length;
			const disH = (bottom - top);
			for (let j=0; j<text.length; j++) {

				const x1 = left + j * disW;
				const y1 = top;

				const x2 = x1 + disW;
				const y2 = y1;

				const x3 = x2;
				const y3 = y2 + disH;

				const x4 = x1;
				const y4 = y3;

				// const bbox = [{x1, y1}, {x2, y2}, {x3, y3}, {x4, y4}]
				const bbox = {left: x1, right: x2, top: y1, bottom: y3}


				// this.changeBboxPos(bbox);

				const content = text[j];
				bboxTextArr.push({bbox, content, score});
			}

		}

		result.text = bboxTextArr;

	},


	locate(x1, y1, x2, y2, x3, y3) {
			var a, b;
			a = (y2 - y1) / (x2 - x1);
			b = y1 - a * x1;

			var xMiddle = (x1 + x2) / 2;
			var yMiddle = (y1 + y2) / 2;
			var c, lastX, lastY;
			if (a != 0) {
					c = yMiddle - (-1 / a) * xMiddle;
					lastX = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) - 2 * c * y1 + 2 * c * y3) / (2 * ((x1 - x3) - (1 / a) * (y1 - y3)));
					lastY = (-1 / a) * lastX + c;
			} else {
					lastX = c = xMiddle;
					lastY = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) + 2 * lastX * (x3 - x1)) / (2 * (y1 - y3));
			}
			console.log("定位点X坐标: " + lastX);
			console.log("定位点Y坐标: " + lastY);

			return {x: lastX, y: lastY};
	},

	

	setOneAnswerDataCircle(colorRect, answerData) {
		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);


		// const targetLabelText = colorRect.labelText;

		// const newRectCheckArr = this.newRectCheckArr;
		const checkArr = this.circleRectCheckArr;

		for (let i=0; i<checkArr.length; i++) {

			const checkRect = checkArr[i].ccRect;
			const key = checkArr[i].data.index + 1;

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (checkRect.contains(dotV2)) {

				answerData[key] = {isFinish: true};

			}

		}

	},


	setOneAnswerDataLink(firstPos, lastPos, answerData) {


		const w = this.debugLayer.width;
    const h = this.debugLayer.height;
    const checkP1 = cc.v2(firstPos.x * w, -firstPos.y * h);
    const checkP2 = cc.v2(lastPos.x * w, -lastPos.y * h);



		let firstPosRectId = -1;
		let lastPosRectId = -1;

		const worldPos1 = this.debugLayer.convertToWorldSpaceAR(cc.v2(checkP1.x, checkP1.y));
		const worldPos2 = this.debugLayer.convertToWorldSpaceAR(cc.v2(checkP2.x, checkP2.y));


		// console.log('worldPos1: ', JSON.stringify(worldPos1));
		// console.log('worldPos2: ', JSON.stringify(worldPos2));

		for (let i=0; i<this.linkRectGroup.length; i++) {
			const rect = this.linkRectGroup[i].ccRect;

			// console.log('rect: ', JSON.stringify(rect));


      if (rect.contains(worldPos1)) {
        firstPosRectId = i;
        // break;
			} 
      if (rect.contains(worldPos2)) {
        lastPosRectId = i;
        // break;
			} 
		}

		console.log('firstPosRectId: ', firstPosRectId);
		console.log('lastPosRectId: ', lastPosRectId);

		if (firstPosRectId != -1 && lastPosRectId != -1 && firstPosRectId != lastPosRectId) {

      answerData[firstPosRectId.toString()] = [firstPosRectId, lastPosRectId];
      this.addDebugLayerDot(checkP1.x, checkP1.y, 10, cc.Color.GREEN);
      this.addDebugLayerDot(checkP2.x, checkP2.y, 10, cc.Color.GREEN);
    }

	},

	addDebugLayerDot(x, y, r=10, color = null) {
    const dotNode = new cc.Node();

    const ctx = dotNode.addComponent(cc.Graphics);
    ctx.fillColor = color || cc.Color.BLUE;
    ctx.circle(x, y, r);
    ctx.fill();

    this.debugDrawLayer.addChild(dotNode);

    const w = this.debugLayer.width;
    const h = this.debugLayer.height;
    const rateX = x / w;
    const rateY = y / h;
    
    console.log('ratePos: {x: ' + rateX + ', y: ' + rateY + '}')
  },

	photoEndLineRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}



		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const points = oneTextData.points;

			const point1_x = points[0];
			const point1_y = points[1];
			const point2_x = points[2];
			const point2_y = points[3];

			// const rect1 = {
			// 	x:point1_x,
			// 	y: -point1_y,
			// 	width: 0.01,
			// 	height: 0.01
			// }

			// const colorRect1 = this.getColorDot(rect1.x, rect1.y, rect1.width, rect1.height, "purple");
			// this.debugDrawLayer.addChild(colorRect1, 1);
		

			// const rect2 = {
			// 	x:point2_x,
			// 	y: -point2_y,
			// 	width: 0.01,
			// 	height: 0.01
			// }

			// const colorRect2 = this.getColorDot(rect2.x, rect2.y, rect1.width, rect1.height, "purple");
			// this.debugDrawLayer.addChild(colorRect2, 1);

			this.drawUserLine([{x:point1_x, y: point1_y}, {x: point2_x, y: point2_y}]);

			this.setOneAnswerDataLink({x:point1_x, y: point1_y}, {x: point2_x, y: point2_y}, answerData);
		}


		this.showLinkAnswer(answerData);
	},

	drawUserLine(path) {
		this.drawOnePath(path);
	},

	drawOnePath(path) {
    const lineNode = new cc.Node();
    this.debugDrawLayer.addChild(lineNode);

    const w = this.debugLayer.width;
    const h = this.debugLayer.height;



    const subY = 0; //-canvas.height / 2;
    const ctx = lineNode.addComponent(cc.Graphics);
    ctx.lineWidth = 10;
    ctx.strokeColor = cc.Color.RED;
    ctx.fillColor = cc.Color.BLACK;
    

    ctx.moveTo(path[0].x * w, -path[0].y * h + subY);

    for (let i = 1; i < path.length; i++) {
      const x = path[i].x * w;
      const y = -path[i].y * h + subY;

      ctx.lineTo(x, y);
    }
    ctx.stroke();
  },

	showLinkAnswer(answerData) {

    for (let key in answerData) {

      const tempArr = answerData[key];

      const firstItemIndex = tempArr[0];
      const lastItemIndex = tempArr[1];

			const debugFirstItem = this.linkRectGroup[firstItemIndex];
			const debugLastItem = this.linkRectGroup[lastItemIndex];

			console.log('linkdebugId: ', debugFirstItem.linkData.linkDebugItemId);
			console.log('debugLastItem.linkData.debugItemId: ', debugLastItem.linkData.debugItemId)
			console.log('debugFirstItem.isRightPoint: ', debugFirstItem.isRightPoint)

			const hzItemIdFirst = debugFirstItem.linkData.hzItemId
			const hzItemIdLast = debugLastItem.linkData.hzItemId
			const startItem = this.getItemById(hzItemIdFirst);
			const endItem = this.getItemById(hzItemIdLast);
			if (startItem.isShowEnd || endItem.isShowEnd) {
				return;
			}

			if ((startItem.isRightPoint && endItem.isRightPoint) && debugFirstItem.linkData.linkDebugItemId == debugLastItem.linkData.debugItemId) {
				
				const {hzItemId, linkHzItemId} = debugFirstItem.linkData
				this.showSuccess(hzItemId, linkHzItemId);

			} else {			

			}

    }


		// for (let key in answerData) {

    //   const tempArr = answerData[key];

    //   const firstItemIndex = tempArr[0];
    //   const lastItemIndex = tempArr[1];

		// 	const debugFirstItem = this.linkRectGroup[firstItemIndex];
		// 	const debugLastItem = this.linkRectGroup[lastItemIndex];

		// 	console.log('linkdebugId: ', debugFirstItem.linkData.linkDebugItemId);
		// 	console.log('debugLastItem.linkData.debugItemId: ', debugLastItem.linkData.debugItemId)
		// 	console.log('debugFirstItem.isRightPoint: ', debugFirstItem.isRightPoint)

		// 	const hzItemIdFirst = debugFirstItem.linkData.hzItemId
		// 	const hzItemIdLast = debugLastItem.linkData.hzItemId
		// 	const startItem = this.getItemById(hzItemIdFirst);
		// 	const endItem = this.getItemById(hzItemIdLast);
		// 	if (startItem.isShowEnd || endItem.isShowEnd) {
		// 		return;
		// 	}

		// 	if (debugFirstItem.isRightPoint && debugFirstItem.linkData.linkDebugItemId == debugLastItem.linkData.debugItemId) {
				
		// 		// const {hzItemId, linkHzItemId} = debugFirstItem.linkData
		// 		// this.showSuccess(hzItemId, linkHzItemId);

		// 	} else {			

				
		// 		this.showFail(hzItemIdFirst, hzItemIdLast);
		// 		this.playCatAudio(this.data.error_link_audio_url);

		// 	}

    // }


  },

	showSuccess(startItemId, endItemId) {

		console.log( ' in showSuccess');

		const startItem = this.getItemById(startItemId);
		const endItem = this.getItemById(endItemId);

		if (startItem.isShowEnd || endItem.isShowEnd) {
			return;
		}
		startItem.isShowEnd = true;
		endItem.isShowEnd = true;

		const isLinked = this.checkIsLinked(startItem, endItem);
		if (isLinked) {
			return;
		}

		this.addLinkItem(startItem, endItem);
		this.addLinkItem(endItem, startItem);


		const pos1 = startItem.getPosition();
		pos1.x += startItem.width / 2;
		pos1.y += startItem.height / 2;
		const pos2 = endItem.getPosition();
		pos2.x += endItem.width / 2;
		pos2.y += endItem.height / 2;

		const greenColor = new cc.Color();
		greenColor.fromHEX("#519F00"); 
		const line = this.getLine(pos1, pos2, greenColor);
		this.addLinkLine(startItem, endItem, line);
		line.isRight = true;

		const maskNode = new cc.Node();
		maskNode.width = 0;
		maskNode.height = 0;
		maskNode.x = pos1.x;
		maskNode.y = pos1.y;
		this.hotZoneBg.addChild(maskNode);


		const mask = maskNode.addComponent(cc.Mask);
		mask.type = cc.Mask.Type.ELLIPSE;
		mask.segments = 32;

		maskNode.addChild(line);
		// line.mask = mask;

		this.isCurLinked = true;

		cc.tween(maskNode)
			.to(1.5, {width: this.canvas.width * 2, height: this.canvas.height * 2}, {easing: 'sineOut'})
			.call(() => {
				maskNode.removeComponent(cc.Mask);
			})
			.start();
		
		playAudio(this.rightClip, () => {
			
		})
		
		if (!this.isGameEnd) {
			const arr = this.rectNodeArr.filter((r) => {
				return r.isRightPoint == true;
			})
			this.checkGameEnd(arr);
		}
	},

	addLinkLine(item1, item2, line) {
		if ( !item1.lineArr ) {
			item1.lineArr = [];
		}

		if (!item2.lineArr) {
			item2.lineArr = [];
		}
		
		item1.lineArr.push(line);
		item2.lineArr.push(line);
		line.itemArr = [item1, item2];
		this.totalLineArr.push(line);
	},

	checkIsLinked(startItem, endItem) {
		const linkItemArr1 = startItem.linkItemArr || [];
		const linkItemArr2 = endItem.linkItemArr || [];

		return (linkItemArr1.indexOf(endItem) != -1 && linkItemArr2.indexOf(startItem) != -1);
	},

	addLinkItem(item, linkItem) {
		if (!item.linkItemArr) {
			item.linkItemArr = [];
		}

		if (item.linkItemArr.indexOf(linkItem) == -1) {
			item.linkItemArr.push(linkItem);
		}
	},

	getLine(item1, item2, color=cc.Color.BLACK) {
		const lineNode = new cc.Node();


		const ctx = lineNode.addComponent(cc.Graphics);
		ctx.lineWidth = 5;
    ctx.strokeColor = color;
    ctx.fillColor = color;

    ctx.moveTo(0, 0);
		ctx.lineTo(item2.x - item1.x, item2.y - item1.y);
		ctx.stroke();

		const dot1 = this.getDot(0, 0, ctx.lineWidth/2, ctx.strokeColor);
		dot1.parent = lineNode;

		const dot2 = this.getDot(item2.x - item1.x, item2.y - item1.y, ctx.lineWidth/2, ctx.strokeColor);
		dot2.parent = lineNode;

		return lineNode;
	},

	getDot(x, y, r, color) {

		const dotNode = new cc.Node();

    const ctx = dotNode.addComponent(cc.Graphics);
    ctx.fillColor = color || cc.Color.BLUE;
    ctx.circle(x, y, r);
    ctx.fill();

		return dotNode;
	},


	getItemById(id) {

		console.log('getItemById id:', id);
		console.log('this.rectNodeArr: ', this.rectNodeArr);

		const targetItem = this.rectNodeArr.find( node => {

			const data = node.data;

			console.log('data~~: ', JSON.stringify(data));


			if (data && (data.index + 1 == id)) {
				return true;
			}
		})
		return targetItem;
	},


	cleanColorDrawLayer() {
		const layer = this.colorDrawLayer;
		const children = layer.children;
		for (let i=0; i<children.length; i++) {
			this.pushColorPoolSpr(children[i]);
		}
	},

	pushColorPoolSpr(spr) {
		spr.opacity = 0

		this.colorSprPoolArr.push(spr);
	},

	getColorPoolSpr() {
		let spr;
		if (this.colorSprPoolArr.length > 0) {
			spr = this.colorSprPoolArr.pop();
			spr.opacity = 255;
		} else {
			spr = getSprNode('white');
			this.colorDrawLayer.addChild(spr);
		}

		return spr;
	},

	photoEndColorRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			console.log(' photoEndColorRect 1')
			return;
		}

		const {colors, points} = textArr[0]
		if (!colors || !points) {
			console.log(' photoEndColorRect 2')
			return;
		}

		this.cleanColorDrawLayer();


		for (let i=0; i<this.colorRectCheckArr.length; i++) {
			const leftEdgeX = this.colorRectCheckArr[i].x / this.debugBgImg.width;
			const rightEdgeX = (this.colorRectCheckArr[i].x + this.colorRectCheckArr[i].width * this.colorRectCheckArr[i].scaleX) / this.debugBgImg.width;
			// const topEdgeY = (this.debugBgImg.height + this.colorRectCheckArr[i].y - this.colorRectCheckArr[i].height)  / this.debugBgImg.height;
			const topEdgeY = -(this.colorRectCheckArr[i].y + this.colorRectCheckArr[i].height * this.colorRectCheckArr[i].scaleY)  / this.debugBgImg.height;
			// const bottomEdgeY = (this.debugBgImg.height + this.colorRectCheckArr[i].y)  / this.debugBgImg.height;
			const bottomEdgeY = -(this.colorRectCheckArr[i].y)  / this.debugBgImg.height;
			

			console.log("leftEdgeX: ", leftEdgeX);
			console.log("rightEdgeX: ", rightEdgeX);
			console.log("topEdgeY: ", topEdgeY);
			console.log("bottomEdgeY: ", bottomEdgeY);

			this.colorRectCheckArr[i].leftEdgeX = leftEdgeX
			this.colorRectCheckArr[i].rightEdgeX = rightEdgeX
			this.colorRectCheckArr[i].topEdgeY = topEdgeY
			this.colorRectCheckArr[i].bottomEdgeY = bottomEdgeY
			this.colorRectCheckArr[i].colorPoints = [];
		}
		
		for (let i=0; i<points.length; i+=2) {


			const pointX = points[i];

			if (!pointX) {
				break;
			}
			const pointY = points[i+1];
			const color = colors[i/2];


			for (let j=0; j<this.colorRectCheckArr.length; j++) {
			
				const {leftEdgeX,rightEdgeX, topEdgeY, bottomEdgeY} = this.colorRectCheckArr[j];

				if (pointX < leftEdgeX) {
					// console.log(' return ~ 1');
					continue;
				}
				if (pointX > rightEdgeX) {
					// console.log(' return ~ 2');
					continue;
				}
				if (pointY < topEdgeY) {
					// console.log(' return ~ 3');
					continue;
				}
				if (pointY > bottomEdgeY) {
					// console.log(' return ~ 4');
					continue;
				}
		
				const r = color[0];
				const g = color[1];
				const b = color[2];

				if (!(r > 250 && g > 250 && b > 250)) {
					// this.colorRectCheckArr[j].colorPoints.push({pointX, pointY, color});
					this.colorRectCheckArr[j].colorPoints.push({});
				}


			}


				const colorNode = this.getColorBgColorDot(pointX, -pointY, this.colorUnit, this.colorUnit);

				colorNode.x -= this.colorBg.width / 2;
				colorNode.y += this.colorBg.height / 2;

				const pointColor = new cc.Color();

	
				pointColor.r = color[0] * 1.2
				pointColor.g = color[1] * 1.2
				pointColor.b = color[2] * 1.2
				colorNode.color = pointColor;


	
			// }

		}



		const answerData = {};


		for (let i=0; i<this.colorRectCheckArr.length; i++) {
			const colorPoints = this.colorRectCheckArr[i].colorPoints;
			const pointsMax = this.colorRectCheckArr[i].pointsMax;

			console.log('point rate : ', (colorPoints.length / pointsMax));

			if (colorPoints.length / pointsMax >= 0.5) {

				const key = this.colorRectCheckArr[i].data.index + 1;
				answerData[key] = {colorRectCheckItem: this.colorRectCheckArr[i], isFinish: true}; 
			}
		}


		// for (let i=0; i<this.colorRectCheckArr.length; i++) {

		// 	const colorPoints = this.colorRectCheckArr[i].colorPoints;

		// 	if (colorPoints.length == 0) {
		// 		continue;
		// 	}
		// 	console.log('colorPoints: ', colorPoints);

		// 	let r = 0;
		// 	let g = 0;
		// 	let b = 0;

		// 	for (let j=0; j<colorPoints.length; j++) {
		// 		const {color} = colorPoints[j];
		// 		r += color[0];
		// 		g += color[1];
		// 		b += color[2];
		// 	}

		// 	r /= colorPoints.length;
		// 	g /= colorPoints.length;
		// 	b /= colorPoints.length;
			
		// 	r = Math.round(r);
		// 	g = Math.round(g);
		// 	b = Math.round(b);

		// 	console.log('r~:', r);
		// 	console.log('g~:', g);
		// 	console.log('b~:', b);

		// 	const key = this.colorRectCheckArr[i].data.index + 1;

		// 	if (!(r > 220 && g > 220 && b > 220)) {
		// 		answerData[key] = {r, g, b, isFinish:true};
		// 	}
		// }
		

		console.log('answerData: ', answerData);

		this.showColorAnswer(answerData);

	},


	showColorAnim(oneAnswer) {

		const colorRectCheckItem = oneAnswer.colorRectCheckItem;
		if (colorRectCheckItem.isShowEnd) {
			return;
		}
		colorRectCheckItem.isShowEnd = true;

		const animaNodeBase = this.colorPicNodeArr[0];

		console.log('animaNodeBase: ' , animaNodeBase);

		const animaNode = cc.instantiate(animaNodeBase);

		console.log('animaNode: ' , animaNode);

		const {leftEdgeX, rightEdgeX, topEdgeY, bottomEdgeY} = colorRectCheckItem;
		const animX = -this.colorBg.width / 2 + (leftEdgeX + (rightEdgeX - leftEdgeX) / 2) * this.colorBg.width;
		const animY = this.colorBg.height / 2 - (topEdgeY + (bottomEdgeY - topEdgeY) / 2) * this.colorBg.height;


		animaNode.x = animX //colorRectCheckItem.x + colorRectCheckItem.width / 2 * colorRectCheckItem.scaleX;
		animaNode.y = animY //colorRectCheckItem.y + colorRectCheckItem.height / 2 * colorRectCheckItem.scaleY;
		// animaNode.parent = this.colorBg
		this.colorBg.addChild(animaNode, 5);

		animaNode.active = true;
		animaNode.opacity = 255;
		
		const dragonDisplay = animaNode.getComponent(dragonBones.ArmatureDisplay);

		console.log('dragonDisplay: ' , dragonDisplay);
		console.log('animaNode: ' , animaNode);


		delayCall(0.01, () => {
			const animationNames = animaNodeBase.animationNames;
			dragonDisplay.playAnimation(animationNames[0], 0);


		})

		playAudio(this.rightClip, () => {
		
		})
	


		if (!this.isGameEnd) {
			this.checkGameEnd(this.colorRectCheckArr);
		}

	},


	showColorAnswer(answerData) {
		
		console.log('answerData: ', answerData);
		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (key in answerData) {

			this.showColorAnim(answerData[key]);

		}

		// for (let i = 0; i < this.colorPicNodeArr.length; i++) {

		// 	const picNode = this.colorPicNodeArr[i];

		// 	const key = picNode.data.drawItem // i.toString();


		// 	console.log('~picNode.data: ', picNode.data)
		// 	console.log('~key: ', key)

		// 	if (!picNode.hitCount) {
		// 		picNode.hitCount = 0;
		// 	}

		// 	if (answerData[key] && answerData[key].isFinish) {
		// 		console.log('~show Color')
		// 		this.showColorPic(picNode, answerData[key]);

		// 	} else {

		// 		picNode.hitCount = 0;
		// 	}
		// }

	},


	photoEndSignRect(data) {

		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const symbol = textArr[0]?.symbol
		if (!symbol) {
			return;
		}

		// return 
		const answerData = {};


		for (let i=0; i<this.signRectCheckArr.length; i++) {
			
			const signDebugItem = this.signRectCheckArr[i];
			const dropDownItem = signDebugItem.data.dropDownItem;

			const curSignKey = symbol[i].toString();
			
			if (dropDownItem.key == curSignKey) {


				const label = this.getLabel(dropDownItem.label, signDebugItem.ccRect.width);
				label.x = signDebugItem.x;
				label.y = signDebugItem.y;
				label.color = cc.Color.BLACK;
	
				this.debugDrawLayer.addChild(label, 2);


				const key = signDebugItem.data.index + 1;
				answerData[key] = {isFinish: true};

			}
		}

		this.showSignAnswer(answerData);

		return ;

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];

			const signId = '2'

			// const points = oneTextData.points;

			// const tempDisNum = Math.floor(points.length / 2);
			// const point1_x = points[0];
			// const point1_y = points[1];
			// const point2_x = points[tempDisNum];
			// const point2_y = points[tempDisNum + 1];

			// let centerPX = Number(point1_x) + (point2_x - point1_x) / 2;
			// let centerPY = Number(point1_y) + (point2_y - point1_y) / 2;

			// console.log('centerPX: ' ,centerPX);
			// console.log('centerPY: ' ,centerPY);

			// const colorRect = this.getColorDot(centerPX, -centerPY, 0.02, 0.02, "purple");
			// this.debugDrawLayer.addChild(colorRect, 1);


			// this.setOneAnswerDataCircle(colorRect, answerData);

		}

		console.log('answerData: ' , answerData);


		// this.showCircleAnswer(answerData);

	},

	showSignAnswer(answerData) {

		console.log('answerData: ', answerData);
		if (Object.keys(answerData).length == 0) {
			return;
		}

		console.log("signAnimaNodeArr: ", this.signAnimaNodeArr);

		for (let i = 0; i < this.signAnimaNodeArr.length; i++) {

			const animaNode = this.signAnimaNodeArr[i];

			const key = animaNode.data.signItem // i.toString();


			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showSign')
				this.showSign(animaNode);

			} else {

				animaNode.hitCount = 0;
			}
		}

	},

	showSign(node, isRight = true) {

		console.log('in showCircle 1');


		node.hitCount++;
		if (node.hitCount < 1) {
			return;
		}


		console.log('in showCircle 2');


		if (node.isShowEnd) {
			return;
		}

		if (this.itemCombineGroup && this.itemCombineGroup.length > 0) {
			const gourpIsShowEnd = this.checkOneCombineGroupEnd(node);
			if (gourpIsShowEnd) {
				return;
			}
		}


		console.log('in showCircle 3');

		node.isShowEnd = true;
		node.isRight = isRight;


		// node.playRightAnim();
		this.playRightAnim(node);

		if (!this.isGameEnd) {

			if (this.itemCombineGroup && this.itemCombineGroup.length > 0) {
				this.checkGameEndCombineGroup();
			} else {
				this.checkGameEnd(this.signAnimaNodeArr);
			}
		}

		return;

	},

	photoEndCircleRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const points = oneTextData.points;

			const tempDisNum = Math.floor(points.length / 2);
			const point1_x = points[0];
			const point1_y = points[1];
			const point2_x = points[tempDisNum];
			const point2_y = points[tempDisNum + 1];
			// const point3_x = points[tempDisNum*2];
			// const point3_y = points[tempDisNum*2 + 1];

			// let centerP = this.locate(point1_x, point1_y, point2_x, point2_y, point3_x, point3_y);
			let centerPX = Number(point1_x) + (point2_x - point1_x) / 2;
			let centerPY = Number(point1_y) + (point2_y - point1_y) / 2;

			console.log('centerPX: ' ,centerPX);
			console.log('centerPY: ' ,centerPY);


			const colorRect = this.getColorDot(centerPX, -centerPY, 0.02, 0.02, "purple");
			this.debugDrawLayer.addChild(colorRect, 1);


			this.setOneAnswerDataCircle(colorRect, answerData);


			// console.log('points: ', points);
		
			// for (let j=0; j<points.length; j+=2) {
			// 	const x = points[j]//centerP.x
			// 	const y = -points[j+1]//-centerP.y
			// 	const w = 0.01;
			// 	const h = 0.01;
	
			// 	const rect = {
			// 		x, y,
			// 		width: w,
			// 		height: h
			// 	}
	

	
			// 	const colorRect = this.getColorDot(rect.x, rect.y, w, h, "red");
			// 	this.debugDrawLayer.addChild(colorRect, 1);


			// 	// this.setCirclePosInRectArr(colorRect);
				
	
			// }
		


		}

		console.log('answerData: ' , answerData);


		this.showCircleAnswer(answerData);

		// this.showUserRightNew(answerData);
	},

	showCircleAnswer(answerData) {

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.circleAnimaNodeArr.length; i++) {

			const animaNode = this.circleAnimaNodeArr[i];

			const key = animaNode.data.circleItem // i.toString();

			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showLetter')
				this.showCircle(animaNode);
				// this.showCircle2(animaNode);

			} else {

				animaNode.hitCount = 0;
			}
		}

	},

	showCircle(node, isRight = true) {

		console.log('in showCircle 1');


		node.hitCount++;
		if (node.hitCount < 1) {
			return;
		}


		console.log('in showCircle 2');


		if (node.isShowEnd) {
			return;
		}

		console.log('in showCircle 3');

		node.isShowEnd = true;
		node.isRight = isRight;



		// this.playRightAnim(node);
		this.showCircle2(node);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.circleAnimaNodeArr);
		}

		return;

	},
	

	photoEndNewRect(data) {

		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const x = oneTextData.left//oneTextData.left + (oneTextData.right - oneTextData.left) / 2;
			const y = -oneTextData.bottom//-oneTextData.top - (oneTextData.bottom - oneTextData.top) / 2;
			const w = oneTextData.right - oneTextData.left;
			const h = oneTextData.bottom - oneTextData.top;

			const rect = {
				x, y,
				width: w,
				height: h
			}

			console.log('oneTextData: ', oneTextData);

			const content = oneTextData.content;
			const colorRect = this.getColorRect(rect, "red");
			colorRect.labelText = content;
			this.debugDrawLayer.addChild(colorRect, 1);

			const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
			label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
			label.color = cc.Color.BLACK;

			this.debugDrawLayer.addChild(label, 2);

			this.setOneAnswerDataNew(colorRect, answerData);

		}

		console.log('answerData:' , answerData);
		this.showUserRightNew(answerData);
	},

	showUserRightNew(answerData) {

		if (Object.keys(answerData).length == 0) {
			return;
		}

		let arr = this.animaNodeArr;
		if (this.picAnimNodeArr.length > 0) {
			arr = this.picAnimNodeArr;
		}

		for (let i = 0; i < arr.length; i++) {

			const animaNode = arr[i];

			const key = animaNode.data.rectNew // i.toString();

			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showLetter')

				if (this.picAnimNodeArr.length > 0) {
					this.showLetterPic(animaNode);
				} else {
					this.showLetter(animaNode);
				}
			} else {

				animaNode.hitCount = 0;
			}
		}
	},

	photoEnd(data) {
		
		console.log(' this.photo end ', data);


		// if (this.newRectArr && this.newRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_WRITE) {
			this.photoEndNewRect(data);
			return;
		}


		// if (this.circleRectArr && this.circleRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_CIRCLE) {
			this.photoEndCircleRect(data);
			return;
		}

		// if (this.lineRectArr && this.lineRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_LINE) {
			this.photoEndLineRect(data);
			return;
		}

		// if (this.signRectArr && this.signRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_SIGN) {
			this.photoEndSignRect(data);
			return;
		}

		if (this.curCheckGroup == this.CHECK_TYPE_COLOR) {
			this.photoEndColorRect(data);
			return;
		}

		


		// this.changeBboxPos(data);

		const isRightArea = this.checkIsRightArea(data);
		if (!isRightArea) {
			console.log('没有检测到区域')
			return;
		}



		if (this.isCanDraw) {
			return;
		}
		this.isCanDraw = true;


		delayCall(0.01, () => {
			this.isCanDraw = false;
		})



		this.debugDrawLayer.removeAllChildren();

		// const benchmark1Text = this.benchmark1Data.labelText
		// const benchmark1TextArr = benchmark1Text.split(' ');
		// const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, data?.result?.text);

		// const benchmark2Text = this.benchmark2Data.labelText
		// const benchmark2TextArr = benchmark2Text.split(' ');
		// const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr,  data?.result?.text);




		const answerData = this.getAnswerData(data);

		this.showUserRight(answerData, data);

		return;


		const answerWrongData = this.getAnswerWrongData(data);
		let isShowWrong = false;
		if (this.oldAnswerWrongData) {
		
			for (let key in answerWrongData) {
				const wrongData = answerWrongData[key];
				const oldWrongData = this.oldAnswerWrongData[key];
				if (oldWrongData && oldWrongData.sentence == wrongData.sentence) {
					wrongData.count += oldWrongData.count;

					if (wrongData.count >= 3) {
						isShowWrong = true;
					}
				}
			}
		}

		if (isShowWrong) {
			this.showUserWrong(answerWrongData);
		}

		this.oldAnswerWrongData = answerWrongData;


		console.log('answerWrongData: ', JSON.stringify( answerWrongData) );
	},







	checkIsRightArea(data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}

		const benchmark1Text = this.benchmark1Data.labelText
		const benchmark1TextArr = benchmark1Text.split(' ');
		console.log('benchmark1TextArr: ', benchmark1TextArr);
		// const letter = this.data.letter || 'Aa';

		const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, text, false);
		if (!benchmark1LabelData) {
			console.log('!benchmark1LabelData')
			return false;
		}
		this.benchmark1LabelData = benchmark1LabelData;
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		

		if ( this.firstItemData ) {

			const firstText = this.firstItemData.labelText
			const firstTextArr = firstText.split(' ');

			const firstItemLabelData = this.getTopLeftLetter2(firstText, text, this.benchmark1LabelData);

			if (!firstItemLabelData) {
				return false;
			}
			this.firstItemLabelData = firstItemLabelData;

			console.log('firstItemLabelData: ', firstItemLabelData);
			return true

		} else if (this.benchmark2Data) {
		
			const benchmark2Text = this.benchmark2Data.labelText
			const benchmark2TextArr = benchmark2Text.split(' ');
			const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr, text, false);
			if (!benchmark2LabelData) {
				return false;
			}
			this.benchmark2LabelData = benchmark2LabelData;
			return true;
		}



		return false;

	


		// const block = data?.block
		// if (!block) {
		// 	return false;
		// }

		// const topText = this.topItemData.labelText
		// const topTextArr = topText.split(' ');
		// console.log('topTextArr: ', topTextArr);
		// // const letter = this.data.letter || 'Aa';

		// const topLabelData = this.getPhotoLabelData(topTextArr, block);
		// if (!topLabelData) {
		// 	console.log('!topLabelData')
		// 	return false;
		// }
		// this.topLabelData = topLabelData;
		// console.log('topLabelData: ', topLabelData);

		

		// if (this.bottomItemData) {
			
		// 	const bottomText = this.bottomItemData.labelText
		// 	const bottomTextArr = bottomText.split(' ');
		// 	const bottomLabelData = this.getPhotoLabelData(bottomTextArr, block);
		// 	if (!bottomLabelData) {
		// 		return false;
		// 	}
		// 	this.bottomLabelData = bottomLabelData;
		// 	return true

		// } else if (this.firstItemData) {

		// 	const firstText = this.firstItemData.labelText
		// 	const firstTextArr = firstText.split(' ');
		// 	const topLeftLetter = this.getPhotoLabelData(firstTextArr, block);


		// 	// const topLeftLetter = this.getTopLeftLetter(this.firstItemData.labelText, block, topLabelData);
		// 	if (!topLeftLetter) {
		// 		return false;
		// 	}
		// 	this.topLeftLetter = topLeftLetter;

		// 	console.log('topLeftLetter: ', topLeftLetter);
		// 	return true;
		// }



		// return false;

	
	},

	changeBboxPos(data) {

		const text = data?.result?.text;
		if (!text) {
			return;
		}


		for (let i=0; i<text.length; i++) {

			let {left, top, right, bottom} = text[i];

			const q_left = this.ques_region[0];
			const q_top = this.ques_region[1];
			const q_right = this.ques_region[2];
			const q_bottom = this.ques_region[7];

			const rect = {x: q_left, y: q_top, width: q_right - q_left, height: q_bottom - q_top};

			text[i].left = q_left + left * rect.width;
			text[i].top = q_top + top * rect.height;
			text[i].right = q_left + right * rect.width;
			text[i].bottom = q_top + bottom * rect.height;

		}

		// console.log('bbox: ', bbox);
		// const x1 = bbox[0].x1;
		// const y1 = bbox[0].y1;
		// const x2 = bbox[1].x2;
		// const y2 = bbox[1].y2;
		// const x3 = bbox[2].x3;
		// const y3 = bbox[2].y3;
		// const x4 = bbox[3].x4;
		// const y4 = bbox[3].y4;

		// const left = this.ques_region[0];
		// const top = this.ques_region[1];
		// const right = this.ques_region[2];
		// const bottom = this.ques_region[7];

		// const rect = {x: left, y:top, width: right - left, height: bottom - top};

		// const y1_new = top + y1 * rect.height;
		// const y2_new = y1_new;
		// const y3_new = top + y3 * rect.height;
		// const y4_new = y3_new;

		// const x1_new = left + x1 * rect.width;
		// const x2_new = left + x2 * rect.width;
		// const x3_new = x2_new;
		// const x4_new = x1_new;

		// bbox[0].x1 = x1_new;
		// bbox[0].y1 = y1_new;
		// bbox[1].x2 = x2_new;
		// bbox[1].y2 = y2_new;
		// bbox[2].x3 = x3_new;
		// bbox[2].y3 = y3_new;
		// bbox[3].x4 = x4_new;
		// bbox[3].y4 = y4_new;

		// console.log('~~rect: ', rect);

	
	},



	getTopLeftLetter2(text, block, topLabelData) {

		const benchmark1Rect = this.benchmark1Data.rect;

		const rect = {
			x: topLabelData.left, 
			y: -topLabelData.bottom, 
			width: Math.abs( topLabelData.right - topLabelData.left ), 
			height: Math.abs( topLabelData.bottom - topLabelData.top ), 
		}                        
		const colorRect = this.getColorRect(rect, "green");
		this.debugDrawLayer.addChild(colorRect);
		


		const tempUnitW = benchmark1Rect.x + benchmark1Rect.width;
		const tempUnitH = benchmark1Rect.y + benchmark1Rect.height;
		const tempBaseX = benchmark1Rect.x + benchmark1Rect.width / 2;
		const tempBaseY = benchmark1Rect.y + benchmark1Rect.height / 2;


		const firstItemData = this.firstItemData;		
		const firstItemRect = this.firstItemData.rect;

	
		const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		const unitX = (firstItemX - tempBaseX) / tempUnitW;
		const unitY = (firstItemY - tempBaseY) / tempUnitH;
		const unitW2 = firstItemRect.width / tempUnitW;
		const unitH2 = firstItemRect.height / tempUnitH;



		console.log('tempUnitW: ', tempUnitW);
		console.log('tempUnitH: ', tempUnitH);
		console.log('tempBaseX: ', tempBaseX);
		console.log('tempBaseY: ', tempBaseY);

		console.log('firstItemY: ', firstItemY);
		console.log('tempBaseY: ', tempBaseY);
		console.log('tempUnitH: ', tempUnitH);

		firstItemData.unitX = unitX;
		firstItemData.unitY = unitY;
		firstItemData.unitW = unitW2;
		firstItemData.unitH = unitH2;



		const topLocationLeft = topLabelData.left;
		const topLocationTop = topLabelData.top;
		const topLocationRight = topLabelData.right;
		const topLocationBottom = topLabelData.bottom;

		const baseX = topLocationLeft + (topLocationRight - topLocationLeft) / 2;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight;
		const unitH = topLocationTop + (topLocationBottom - topLocationTop);
		

		const checkLetter = firstItemData;

		console.log('baseY: ', baseY);
		console.log('checkLetter.unitY: ', checkLetter.unitY);
		console.log('unitH: ', unitH);


		let x = baseX + checkLetter.unitX * unitW;
		const y = baseY + checkLetter.unitY * unitH;
		const w = checkLetter.unitW * unitW;
		const h = checkLetter.unitH * unitH;
		const r = Math.min(w, h) / 2;


		console.log(' baseX:  ', baseX);
		console.log(' checkLetter.unitX:  ', checkLetter.unitX);
		console.log(' unitW:  ', unitW);
		console.log(' x:  ', x);
		console.log(' y:  ', y);
		console.log(' r:  ', r);
		console.log(' checkLetter:  ', checkLetter);

		const dot = this.getColorDot(x, -y, r, r, 'blue');
		this.debugDrawLayer.addChild(dot, 5);

		dot.labelText = checkLetter.labelText;


		const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		let topLeftLetterData;


		const {dotRect, labelText} = dot
		


		for (let i=0; i<wordDataArr.length; i++) {

			// const tempWordArr = wordDataArr[i].word;
			const tempWordArr = this.getTempWordArr(wordDataArr[i],['']);



			for (let k=0; k<tempWordArr.length; k++) {
					
				const {location , content} = tempWordArr[k];

				const rect = {
					x: location.left, 
					y: -location.bottom, 
					width: Math.abs( location.right - location.left ), 
					height: Math.abs( location.bottom - location.top ), 
				}                        
				const colorRect = this.getColorRect(rect, "purple");
				colorRect.labelText = content;
				this.debugDrawLayer.addChild(colorRect);

				// console.log('colorRect: ', colorRect);

				const label = this.getLabel(content);
				label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
				label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
				label.color = cc.Color.GREEN;
				this.debugDrawLayer.addChild(label);




				///------

				const checkRect = colorRect.ccRect;
				const targetLabelText = colorRect.labelText;

				const {dotRect, labelText, key} = dot;

				if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && checkRect.intersects(dotRect)) {
					return tempWordArr[k];
				}

				///------
				

			}





			// const lineRect = this.getLineRect( wordDataArr[i] );
			// const isInLineRect = lineRect.intersects(dotRect)
			// if (!isInLineRect) {
			// 	continue;
			// }

			// for (let k=0; k<tempWordArr.length; k++) {
			// 	const {location , content} = tempWordArr[k];

			// 	const tempRect = {
			// 		x: location.left, 
			// 		y: -location.bottom, 
			// 		width: Math.abs( location.right - location.left ), 
			// 		height: Math.abs( location.bottom - location.top ), 
			// 	}
			// 	const colorRect = this.getColorRect(tempRect);
			// 	colorRect.labelText = content;
			// 	// this.debugDrawLayer.addChild(colorRect);

			// 	const label = this.getLabel(content);
			// 	label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			// 	label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
			// 	label.color = cc.Color.GREEN;
			// 	// this.debugDrawLayer.addChild(label);
				


						
			// 	const rect = colorRect.ccRect;
			// 	const targetLabelText = colorRect.labelText;



			

			// 	// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
			// 	// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


			// 	const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

			// 	if (isInLineText) {
			// 	// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
			// 		topLeftLetterData = wordDataArr[i];
			// 		// answerData[i.toString()] = colorRect;
			// 		// return;
			// 	}

			// }
			
		}

			
		return null;


	},


	getTopLeftLetter(text, block, topLabelData) {

		// const topItemRect = this.topItemData.rect;

		// const tempUnitW = topItemRect.width;
		// const tempUnitH = topItemRect.height;
		// const tempBaseX = topItemRect.x;
		// const tempBaseY = topItemRect.y + topItemRect.height / 2;


		// const firstItemData = this.firstItemData;
		// console.log('firstItemData: ', firstItemData);
		
		// const firstItemRect = this.firstItemData.rect;


	
		// const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		// const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		// const unitX = (firstItemX - tempBaseX) / tempUnitW;
		// const unitY = (firstItemY - tempBaseY) / tempUnitH;
		// const unitW2 = firstItemRect.width / tempUnitW;
		// const unitH2 = firstItemRect.height / tempUnitH;


		// console.log('firstItemY: ', firstItemY);
		// console.log('tempBaseY: ', tempBaseY);
		// console.log('tempUnitH: ', tempUnitH);

		// firstItemData.unitX = unitX;
		// firstItemData.unitY = unitY;
		// firstItemData.unitW = unitW2;
		// firstItemData.unitH = unitH2;



		// // const topLabelData = this.topLabelData;

		// const firstTopWordLocation = topLabelData.word[0].location;
		// const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		// const topLocationLeft = firstTopWordLocation.left;
		// const topLocationTop = firstTopWordLocation.top;
		// const topLocationRight = lastTopWordLocation.right;
		// const topLocationBottom = lastTopWordLocation.bottom;

		// const baseX = topLocationLeft;
		// const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		// const unitW = topLocationRight - topLocationLeft;
		// const unitH = topLocationBottom - topLocationTop;
		

		// const checkLetter = firstItemData;

		// console.log('baseY: ', baseY);
		// console.log('checkLetter.unitY: ', checkLetter.unitY);
		// console.log('unitH: ', unitH);


		// let x = baseX + checkLetter.unitX * unitW;
		// const y = baseY + checkLetter.unitY * unitH;
		// const w = checkLetter.unitW * unitW;
		// const h = checkLetter.unitH * unitH;
		// const r = Math.min(w, h) / 2;

		// 	// const centerX = baseX + this.centerUnitW * unitW;
		// 	// x += (centerX - x) * 0.005  * (y * 0.05);

		// console.log(' x:  ', x);
		// console.log(' y:  ', y);
		// console.log(' r:  ', r);

		// const dot = this.getColorDot(x, -y, r, r, 'purple');
		// this.debugDrawLayer.addChild(dot, 5);

		// dot.labelText = checkLetter.labelText;


		// const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// let topLeftLetterData;


		// const {dotRect, labelText} = dot
		


		// for (let i=0; i<wordDataArr.length; i++) {

		// 	const tempWordArr = wordDataArr[i].word;

		// 	const lineRect = this.getLineRect( wordDataArr[i] );
		// 	const isInLineRect = lineRect.intersects(dotRect)
		// 	if (!isInLineRect) {
		// 		continue;
		// 	}

		// 	for (let k=0; k<tempWordArr.length; k++) {
		// 		const {location , content} = tempWordArr[k];

		// 		const tempRect = {
		// 			x: location.left, 
		// 			y: -location.bottom, 
		// 			width: Math.abs( location.right - location.left ), 
		// 			height: Math.abs( location.bottom - location.top ), 
		// 		}
		// 		const colorRect = this.getColorRect(tempRect);
		// 		colorRect.labelText = content;
		// 		// this.debugDrawLayer.addChild(colorRect);

		// 		const label = this.getLabel(content);
		// 		label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
		// 		label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
		// 		label.color = cc.Color.GREEN;
		// 		// this.debugDrawLayer.addChild(label);
				


						
		// 		const rect = colorRect.ccRect;
		// 		const targetLabelText = colorRect.labelText;



			

		// 		// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
		// 		// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


		// 		const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

		// 		if (isInLineText) {
		// 		// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
		// 			topLeftLetterData = wordDataArr[i];
		// 			// answerData[i.toString()] = colorRect;
		// 			// return;
		// 		}

		// 	}
			
		// }

			
		// return topLeftLetterData;









		// // const topRect = this.topItemData.rect;

		// // const topCenterY = (topRect.y + topRect.height / 2);
		// // const bottomCenterY = (bottomRect.y + bottomRect.height / 2);
		
		// // const unitH = bottomCenterY - topCenterY;
		// // const unitW = topRect.width;
		// // const baseX = topRect.x;
		// // const baseY = topRect.y + topRect.height;


		

		// // const titleBottom = this.getTitleBottom();
		// // console.log("titleBottom: ", titleBottom);

		// // let topLeftLetter;
		// // const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// // for (let i=0; i<wordDataArr.length; i++) {

		// // 	const tempWordArr = wordDataArr[i].word;
		// // 	for (let k=0; k<tempWordArr.length; k++) {
		// // 		const {location , content} = tempWordArr[k];


		// // 		// console.log('location: ~~ ', location);

		// // 		// if (location.top <= titleBottom) {
		// // 		// 	continue;
		// // 		// }

		// // 		wordDataArr[i].tmpLen = this.getToZeroLen(location)

					



		// // 		if (!topLeftLetter) {
		// // 			topLeftLetter = wordDataArr[i];
		// // 		} else {
		// // 			if (topLeftLetter.tmpLen > wordDataArr[i].tmpLen) {
		// // 				topLeftLetter = wordDataArr[i];
		// // 			}
		// // 		}
		// // 	}
			
		// // }

		// // return topLeftLetter;


	},

	getLineRect(line) {

		const tempWordArr = line.word;

		let sentenceRect;
		let left;
		let right;
		for (let k=0; k<tempWordArr.length; k++) {
			const {location , content} = tempWordArr[k];

			const tempRect = {
				x: location.left, 
				y: -location.bottom, 
				width: Math.abs( location.right - location.left ), 
				height: Math.abs( location.bottom - location.top ), 
			}
			const colorRect = this.getColorRect(tempRect);
			colorRect.labelText = content;
			// this.debugDrawLayer.addChild(colorRect);

					
			const rect = colorRect.ccRect;
			if (!sentenceRect) {
				sentenceRect = rect;
				left = rect.x;
				right = rect.x + rect.width;
			} else {
				if (rect.x + rect.width > right) {
					right = rect.x + rect.width;
				}
			}



		


		}

		if (sentenceRect) {
			sentenceRect.width = right - left;
		}

		return sentenceRect;



	},

	checkWordIsInLine(line, text) {

		console.log(" in checkWordIsInLine ");
		console.log(" line:  ", line);
		console.log(" word:  ", text);

		const textArr = text.trim().toLowerCase().split('');

		const word = line.word;
		let sentence = ''
		word.forEach(item => {
			sentence += item.content + ' ';
		});

		sentence.trim();
		sentence = sentence.toLowerCase();

		line.sentence = sentence;

		console.log(" sentence:  ", sentence);
		

		if (this.checkIsInsert(textArr, sentence)) {
			return true;
		}

		
		return false;

	},


	getTitleBottom() {
		let maxBottom = 0;
		const word = this.topLabelData.word;
		for (let i=0; i<word.length; i++) {
			if (word[i].location.bottom > maxBottom) {
				maxBottom = word[i].location.bottom;
			}
		}

		return maxBottom;
	},

	getToZeroLen(location) {
		const {top, left} = location;
		const len = Math.sqrt( Math.pow(left, 2) + Math.pow(top, 2) );
		return len;
	},



	getPhotoLabelData(textArr, block, isShow=true) {


		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}

			const sentence = line.content;


			if (isShow) {
				const label = this.getLabel(sentence, 150);
				label.x = line.left * this.debugBgImg.width;
				label.y = -(line.top + (line.bottom - line.top) / 2) * this.debugBgImg.height;
				label.parent = this.debugDrawLayer;
				label.zIndex = 200;
				// label.color = cc.Color.RED;
				const l = label.getComponent(cc.Label);
				label.anchorX = 0;
				console.log(' sentence~:  ', sentence);
			}




			if (this.checkIsInsert(textArr, sentence)) {
				return line;
			}

		}

		return false;

		// for(let j=0; j<block.length; j++) {

		// 	const line = block[j].line;
		// 	if (!line) {
		// 		continue;
		// 	}

		// 	for (let i=0; i<line.length; i++) {

		// 		const word = line[i].word;
		// 		let sentence = ''
		// 		word.forEach(item => {
		// 			sentence += item.content + ' ';
		// 		});
	
		// 		sentence.trim();
		// 		sentence = sentence.toLowerCase();
	
		// 		line[i].sentence = sentence;

		// 		if (this.checkIsInsert(textArr, sentence)) {
		// 			return line[i];
		// 		}
		// 	}
		// }

		// return false;
	},

	checkIsInsert(textArr, sentence) {
		// console.log('textArr: ', textArr);
		// console.log('sentence: ', sentence);

		sentence = sentence.toLowerCase();

		let index = -1;
		for (let i=0; i<textArr.length; i++) {
			index = sentence.indexOf(textArr[i].toLowerCase(), index);
			// console.log('index: ', index);
			if (index == -1) {
				return false;
			}
		}

		return true;
	},


	showUserRight(answerData, data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log('answerData: ', answerData);
		// console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}



		for (let i = 0; i < this.animaNodeArr.length; i++) {

			const animaNode = this.animaNodeArr[i];

			const key = animaNode.data.rectItem // i.toString();

			console.log('key: ', key)

			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				this.showLetter(animaNode);
				// this.removeLine(answerData[key].line, block);
			} else {

				animaNode.hitCount = 0;
			}
		}


		// for (let i = 0; i < this.picNodeArr.length; i++) {

		// 	const picNode = this.picNodeArr[i];

		// 	const key = picNode.data.rectItem // i.toString();

		// 	console.log('key: ', key)

		// 	if (answerData[key] && answerData[key].isFinish) {
		// 		this.showLetter(picNode);
		// 		this.removeLine(answerData[key].line, block);
		// 	} else {

		// 		picNode.hitCount = 0;
		// 	}
		// }


	},

	removeLine(line, block) {

		console.log('block: ', JSON.stringify(block));
		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
	
			const index = lineArr.indexOf(line);
			if (index != -1) {
				lineArr.splice(index, 1);
				console.log(' ```splice lineArr.length: ' , lineArr.length);
			}
		}
	},

	showUserWrong(answerData) {

		console.log('answerData: ', answerData);
		console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.picNodeArr.length; i++) {

			const picNode = this.picNodeArr[i];

			const key = picNode.data.rectItem // i.toString();

			console.log('key: ', key)

			if (answerData[key] && answerData[key].count >= 3) {
				this.showLetter(picNode, false);
			}
		}


	},



	showColorPic(picNode, data, isRight = true) {

		console.log('in showLetterPic 1');

		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}

		console.log('in showLetterPic 2');

		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetterPic 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.opacity = 0;
		picNode.active = true

		const picColor = new cc.Color();
		picColor.r = data.r;
		picColor.g = data.g;
		picColor.b = data.b;
		picNode.sprNode.color = picColor;




		// cc.tween(picNode)
		// 	.to(2, {opacity: 255}, {easing:"cubicOut"})
		// 	.start();

		playAudio(this.rightClip, () => {
		
		})
		
		if (!this.isGameEnd) {
			this.checkGameEnd(this.colorPicNodeArr);
		}

	},

	
	showLetterPic(picNode, isRight = true) {

		console.log('in showLetterPic 1');


		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}


		console.log('in showLetterPic 2');


		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetterPic 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.playRightAnim();
		// this.playRightAnim(picNode);

		picNode.opacity = 0;
		picNode.active = true
		cc.tween(picNode)
			.to(2, {opacity: 255}, {easing:"cubicOut"})
			.start();

		playAudio(this.rightClip, () => {
		
		})
		
		if (!this.isGameEnd) {
			this.checkGameEnd(this.picAnimNodeArr);
		}

	},


	showLetter(picNode, isRight = true) {

		// let writeRect = this.writeNodeArr[Number(index)];

		console.log('in showLetter 1');


		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}


		console.log('in showLetter 2');


		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetter 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.playRightAnim();
		this.playRightAnim(picNode);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.animaNodeArr);
		}

		return;


		picNode.answerPic.active = true;



		if (!isRight) {
			console.log(' ~ !isRight');
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#ef7961')
			playAudio(this.wrongClip);

			if (!this.isGameEnd) {
				this.checkGameEnd();
			}
			return;
		} else {
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#548fd4')
			playAudio(this.rightClip);

		}

		this.showAnimaStar(picNode, ()=> {
			
			if (!this.isGameEnd) {
				this.checkGameEnd();
			}

		});

	
	},

	showAnimaStar(node, cb) {

		const resDragonBone = cc.find("Canvas/res/anim/right")
		const dNode = cc.instantiate(resDragonBone)
		node.addChild(dNode, 20);

		const dragonDisplay = dNode.getComponent(dragonBones.ArmatureDisplay);

		dragonDisplay.playAnimation('newAnimation', 1);

		dragonDisplay.on(dragonBones.EventObject.COMPLETE, ()=> {
			console.log('play end');
			cb && cb();
		})
		

	},


	getAnswerData(data) {
		
		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log(' in getAnswerData: ', text);


		const benchmark1LabelData = this.benchmark1LabelData;
		let benchmark2LabelData ;

		const centerItemArr = this.centerItemArr;

		const benchmark1Left = benchmark1LabelData.left;
		const benchmark1Top = benchmark1LabelData.top;
		const benchmark1Right = benchmark1LabelData.right;
		const benchmark1Bottom = benchmark1LabelData.bottom;

		let baseX;
		let baseY;
		let unitW;
		let unitH;

		if (this.benchmark2LabelData) {
			benchmark2LabelData = this.benchmark2LabelData;


			const benchmark2Left = benchmark2LabelData.left;
			const benchmark2Top = benchmark2LabelData.top;
			const benchmark2Right = benchmark2LabelData.right;
			const benchmark2Bottom = benchmark2LabelData.bottom;


			const bottomLocation = benchmark2LabelData;

			baseX = benchmark1Left;
			baseY =	benchmark1Top + (benchmark1Bottom - benchmark1Top) / 2;
			unitW = benchmark2Right - benchmark1Left;
			unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;


			const benchmark2Rect = {
				x: benchmark2Left, 
				y: -benchmark2Bottom,
				width: Math.abs( benchmark2Left - benchmark2Right ), 
				height: Math.abs( benchmark2Top - benchmark2Bottom ), 
			}
			
			const colorbenchmark2Rect = this.getColorRect(benchmark2Rect, 'green');
			this.debugDrawLayer.addChild(colorbenchmark2Rect);
		} 

	



		if (this.firstItemLabelData) {
			const {location} = this.firstItemLabelData;
			const firstItemLeft = location.left;
			const firstItemRight = location.right;
			const firstItemTop = location.top;
			const firstItemBottom = location.bottom;

			console.log(' location: ', location);
			console.log(' firstItemLeft: ', firstItemLeft);
			console.log(' firstItemRight: ', firstItemRight);
			console.log(' firstItemTop: ', firstItemTop);
			console.log(' firstItemBottom: ', firstItemBottom);

			baseX = firstItemLeft + (firstItemRight - firstItemLeft) / 2;
			baseY =	firstItemTop + (firstItemBottom - firstItemTop) / 2;
			unitW = benchmark1Left + (benchmark1Right -  benchmark1Left) - ( firstItemLeft + (firstItemRight - firstItemLeft) / 2 );
			unitH = ( firstItemTop + (firstItemBottom - firstItemTop) / 2 ) - (benchmark1Top + (benchmark1Bottom -  benchmark1Top) / 2);
		}


		console.log(' baseX ~~~ ', baseX);
		console.log(' baseY ~~~ ', baseY);
		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = 1 //this.data.scaleOffY || 0.055;
		let postionRate = 1 //this.data.positionOffY || 0.4;

		// if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
		// 	postionRate *= 1.7;
    // }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			// const centerX = baseX + this.centerUnitW * unitW;

			// const tempR = scaleRate * (checkLetter.unitY * unitH);
			// const newR = r - tempR; 

			// let newW = w - tempR; 
			// let newH = h - tempR;


			// const rate = newR / r;

			// const tempY = ( y - (baseY) ) * postionRate;
			// y = y - tempY * (1 - rate);


			// const tempX = (centerX - x) * postionRate;
			// x = x + tempX * (1-rate);


			// const newScale = 1.4;
			// const edgeOff = (newScale - 1) / 2;
			// x -= edgeOff * newW;
			// y += edgeOff * newH;
			// newW *= newScale;
			// newH *= newScale;

			// const dot = this.getColorDot(x, -y, newW, newH);

			const dot = this.getColorDot(x, -y, w / 2, h / 2);



			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}



		// console.log('dotArr: ', dotArr);
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		const answerData = {};

		for (let j=0; j<this.centerItemArr.length; j++) {
			const checkLetter = this.centerItemArr[j];

			const wordDataArr = this.getPhotoWordArr(checkLetter.labelText, text, benchmark1LabelData);

			console.log('~~~wordDataArr: ', wordDataArr);


			for (let i=0; i<wordDataArr.length; i++) {

				const tempWordArr = this.getTempWordArr(wordDataArr[i],['']); // wordDataArr[i].word;

				for (let k=0; k<tempWordArr.length; k++) {
					
					const {location , content} = tempWordArr[k];

					const rect = {
						x: location.left, 
						y: -location.bottom, 
						width: Math.abs( location.right - location.left ), 
						height: Math.abs( location.bottom - location.top ), 
					}                        
					const colorRect = this.getColorRect(rect, "purple");
					colorRect.labelText = content;
					this.debugDrawLayer.addChild(colorRect);

					// console.log('colorRect: ', colorRect);

					const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
					label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
					label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
					label.color = cc.Color.BLACK;

					this.debugDrawLayer.addChild(label);
					
	
					this.setOneAnswerData(colorRect, dotArr, answerData, wordDataArr[i]);
	
				}
				
			}

		
		}



		const benchmark1Rect = {
			x: benchmark1Left, 
			y: -benchmark1Bottom,
			width: Math.abs( benchmark1Left - benchmark1Right ), 
			height: Math.abs( benchmark1Top - benchmark1Bottom ), 
		}

		console.log('benchmark1Rect: ', benchmark1Rect);
		
		const colorbenchmark1Rect = this.getColorRect(benchmark1Rect, 'green');
		this.debugDrawLayer.addChild(colorbenchmark1Rect);





		// const rectTop = {
		// 	x: topLocationLeft, 
		// 	y: -topLocationBottom,
		// 	width: Math.abs( topLocationLeft - topLocationRight ), 
		// 	height: Math.abs( topLocationTop - topLocationBottom ), 
		// }
		
		// const colorRectTop = this.getColorRect(rectTop, 'green');
		// this.debugDrawLayer.addChild(colorRectTop);



		// const rectBottom = {
		// 	x: bottomLocation.left, 
		// 	y: -bottomLocation.bottom,
		// 	width: Math.abs( bottomLocation.left - bottomLocation.right ), 
		// 	height: Math.abs( bottomLocation.top - bottomLocation.bottom ), 
		// }
		
		// const colorRectBottom = this.getColorRect(rectBottom, 'green');
		// this.debugDrawLayer.addChild(colorRectBottom);






		return answerData;


	},

	getTempWordArr(line, splitText) {

		const lineBox = {left: line.left, top: line.top, right: line.right, bottom: line.bottom};
		const baseX = lineBox.left;

		let textIndex = 0;
		const oneDisW = (lineBox.right - lineBox.left) / line.content.length;

		const arr = line.content.split(splitText);
		const wordArr = [];
		for (let i=0; i<arr.length; i++) {
			const content = arr[i];
			const location = {}
			location.left = baseX + textIndex * oneDisW;
			location.right = location.left + oneDisW * content.length;
			location.top = lineBox.top;
			location.bottom = lineBox.bottom;
			
			wordArr.push({content, location});

			textIndex += content.length;
		}

		return wordArr;
	},




	getAnswerWrongData(data) {
		
		const block = data?.block
		if (!block) {
			return false;
		}


		console.log(' in getAnswerWrongData: ', block);

		const endKeyObj = {};
		for (let j = 0; j < this.picNodeArr.length; j++) {

			const picNode = this.picNodeArr[j];

			const key = picNode.data.rectItem // i.toString();

			if (picNode.isShowEnd) {
				endKeyObj[key] = true;
			}
		}


		const topLabelData = this.topLabelData;
		let bottomLabelData ;
		if (this.bottomLabelData) {
			bottomLabelData = this.bottomLabelData;
		} else {
			bottomLabelData = this.topLeftLetter;
		}
		// const bottomLabelData = this.bottomLabelData;
		const centerItemArr = this.centerItemArr;

		// console.log('topLabelData: ', topLabelData);

		const firstTopWordLocation = topLabelData.word[0].location;
		const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		const topLocationLeft = firstTopWordLocation.left;
		const topLocationTop = firstTopWordLocation.top;
		const topLocationRight = lastTopWordLocation.right;
		const topLocationBottom = lastTopWordLocation.bottom;


		const bottomLocation = bottomLabelData.word[0].location;

		const baseX = topLocationLeft;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight - topLocationLeft;
		const unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;

		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = this.data.scaleOffY || 0.055;
		let postionRate = this.data.positionOffY || 0.4;

		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			postionRate *= 1.7;
    }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			const key = centerItemArr[i].index + 1;
			if (endKeyObj[key]) {
				continue;
			}

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			const centerX = baseX + this.centerUnitW * unitW;
	
			
		
			// y -= ( y - (baseY + unitH) ) * 0.35;



			const tempR = scaleRate * (checkLetter.unitY * unitH);
			const newR = r - tempR; 

			let newW = w - tempR; 
			let newH = h - tempR;


			const rate = newR / r;

			const tempY = ( y - (baseY) ) * postionRate;
			y = y - tempY * (1 - rate);


			const tempX = (centerX - x) * postionRate;
			x = x + tempX * (1-rate);




			const newScale = 1.4;
			const edgeOff = (newScale - 1) / 2;
			x -= edgeOff * newW;
			y += edgeOff * newH;
			newW *= newScale;
			newH *= newScale;

			const dot = this.getColorDot(x, -y, newW, newH);
			// const dot = this.getColorDot(x, -y, newR, newR);

			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;
			dot.centerPos = cc.v2(dot.x+ dot.width / 2, dot.y + dot.height / 2);

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}


		console.log('topLabelData: ', topLabelData);

		const answerData = {};


		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
			if (!lineArr) {
				continue;
			}

			for (let m=0; m<lineArr.length; m++) {
				const line = lineArr[m];
				
				
				console.log('line: ', JSON.stringify(line));
				const lineRect = this.getLineRect( line );
				console.log('lineRect: ~  ', JSON.stringify(lineRect));
				const lineCenterPos = cc.v2(lineRect.x + lineRect.width / 2, lineRect.y + lineRect.height / 2);

	
				const tempDotArr = [];
				for (let j=0; j<dotArr.length; j++) {
					const isInLineRect = lineRect.intersects(dotArr[j].dotRect)
					if (isInLineRect) {
						tempDotArr.push(dotArr[j]);
					}
				}
				if (tempDotArr.length > 0) {
					const colorRect = this.getColorRect(lineRect, 'purple');
					this.debugDrawLayer.addChild(colorRect);

					console.log('tempDotArr.length > 0')
					let minDistance;
					let curDot;
					for (let j=0; j<tempDotArr.length; j++) {
						const curDistance = cc.Vec2.distance(lineCenterPos, tempDotArr[j].centerPos);
						if (minDistance == null || minDistance > curDistance) {
							minDistance = curDistance;
							curDot = tempDotArr[j];
						}
					}
	
					const tempWordArr = line.word;
					let sentence = ''
					tempWordArr.forEach(item => {
						sentence += item.content.trim();
					});
	
					console.log('sentence: ', sentence);
					console.log('curDot.labelText: ', curDot.labelText);
					if (sentence.length >= curDot.labelText.length) {
						if (!answerData[curDot.key]) {
							answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
						} else {                                        
							const oldData = answerData[curDot.key];
							if (oldData.minDistance > minDistance) {
								answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
							}
						}
					}
				} else {

					const colorRect = this.getColorRect(lineRect, 'red');
					this.debugDrawLayer.addChild(colorRect);
				}
			}

	
		}


		return answerData;


	},


	setCirclePosInRectArr(colorRect) {


		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);

		const circleRectCheckArr = this.circleRectCheckArr;

		for (let i=0; i<circleRectCheckArr.length; i++) {

			const checkRect = circleRectCheckArr[i].ccRect;
			const key = circleRectCheckArr[i].data.index + 1;

			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (checkRect.contains(dotV2)) {
				if (!colorRect.inRectArr) {
					colorRect.inRectArr = []
				}
				colorRect.inRectArr.push(key);
			}

		}
	},



	setOneAnswerDataNew(colorRect, answerData) {
		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);


		const targetLabelText = colorRect.labelText;

		const newRectCheckArr = this.newRectCheckArr;

		for (let i=0; i<newRectCheckArr.length; i++) {

			const labelText = newRectCheckArr[i].data.labelText;
			const checkRect = newRectCheckArr[i].ccRect;
			const key = newRectCheckArr[i].data.index + 1;


			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			// if (labelText == targetLabelText && checkRect.contains(dotV2)) {
			if (checkRect.contains(dotV2)) {
				// const len = targetLabelText.trim().length;

				// console.log('len: ', len);

				// if (newRectCheckArr[i].data.isFuzzy) {

				const index = labelText.indexOf("||");
				if (index != -1) {
					const keyArr = labelText.split("||");

					for (let j=0; j<keyArr.length; j++) {

						if (targetLabelText.indexOf(keyArr[j]) != -1 ) {
							answerData[key] = {isFinish: true};
							break;
						}

					}
				} else {

					if (targetLabelText.indexOf(labelText) != -1 ) {
						answerData[key] = {isFinish: true};
					}
				}


					// if (targetLabelText.indexOf(labelText) != -1 ) {
					// 	answerData[key] = {isFinish: true};
					// }

				// } else {
				// 	if (labelText == targetLabelText) {
				// 		answerData[key] = {isFinish: true};
				// 	}
				// }


			}

		}
	},

	setOneAnswerData(colorRect, dotArr, answerData, line) {

		console.log(' in setOneAnswerData')
		console.log('colorRect: ', colorRect)
		console.log('dotArr: ', dotArr)
		console.log('answerData: ', answerData)

		
		const rect = colorRect.ccRect;
		const targetLabelText = colorRect.labelText;

		for (let i=0; i<dotArr.length; i++) {

			const {dotRect, labelText, key} = dotArr[i];

				console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
				console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );
				console.log('rect.intersects(dotRect) : ', rect.intersects(dotRect) );

			if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
				const len = targetLabelText.trim().length;

				console.log('len: ', len);

				if (!answerData[key]) {
					answerData[key] = {colorRect, count: len};
				} else {
					answerData[key].count += len;

					// console.log('len: ', len);
					// console.log('	answerData[key].count: ', 	answerData[key].count);

				}

				if ( labelText.length <= 1) {
					answerData[key].isFinish = true;
					answerData[key].line = line;

				} else {
					if (answerData[key].count >= labelText.length) {
						answerData[key].isFinish = true;
						answerData[key].line = line;
					}
				}
				

			
				// return;
			}

		}

	},

	getColorRect(rect, color=null) {

		if (!color) {
			color = 'red'
		}


		rect.x *= this.debugBgImg.width;
		rect.y *= this.debugBgImg.height;
		rect.width *= this.debugBgImg.width;
		rect.height *= this.debugBgImg.height;

		const node = getSprNode(color);
		node.anchorX = 0;
		node.anchorY = 0;
		node.x = rect.x;
		node.y = rect.y;
		node.scaleX = rect.width / node.width;
		node.scaleY = rect.height / node.height;

		node.ccRect = new cc.Rect(rect.x, rect.y, rect.width, rect.height);



		return node;
	},



	getColorDot(x, y, w=100, h=100, color='red') {
		const node = new cc.Node();

		if (!h) {
			h = w;
		}

		x *= this.debugBgImg.width;
		y *= this.debugBgImg.height;
		w *= this.debugBgImg.width;
		h *= this.debugBgImg.height;

		if (this.debugLayer.parent && this.debugLayer.active) {

			const rect = {
				x:- w/2,
				y: - h/ 2, 
				width:w, 
				height:h
			}
			// const colorDot = this.getColorRect(rect,'blue');
			// colorDot.fillColor = cc.Color.BLUE;
			// colorDot.fillRect( - r/2, - r/ 2, r, r);

			const colorDot = getSprNode(color);

			
			// colorDot.anchorX = 0;
			// colorDot.anchorY = 0;
			// colorDot.x = rect.x;
			// colorDot.y = rect.y;
			colorDot.scaleX = rect.width / colorDot.width;
			colorDot.scaleY = rect.height / colorDot.height;
			node.addChild(colorDot);



			// const rect1 = new cc.Rect(node.x -r/2, node.y -r/2, r, r);
			// const colorDot = this.getColorRect(rect1, 'green');

			// colorDot.dotRect = rect1;
			// return colorDot;
		}

		node.x = x;
		node.y = y;


		// node.opacity = 0.5;

		const rect = new cc.Rect(node.x -w/2, node.y -h/2, w, h);
		node.dotRect = rect;
		node.ccRect = rect;
		return node;
	},


	getColorBgColorDot(x, y, w=100, h=100) {
		
		// const node = new cc.Node();

		if (!h) {
			h = w;
		}

		x *= this.colorBg.width;
		y *= this.colorBg.height;
		w *= this.colorBg.width;
		h *= this.colorBg.height;

		x = Math.round(x * 100) / 100;
		y = Math.round(y * 100) / 100;
		w = Math.round(w * 100) / 100;
		h = Math.round(h * 100) / 100;

		const rect = {
			x:- w/2,
			y: - h/ 2, 
			width:w, 
			height:h
		}
	
		const colorDot = this.getColorPoolSpr();



	
		colorDot.scaleX = rect.width / colorDot.width;
		colorDot.scaleY = rect.height / colorDot.height;

		colorDot.x = x;
		colorDot.y = y;

		return colorDot;


		// node.addChild(colorDot);
		// node.colorDot = colorDot;



		
		// node.x = x;
		// node.y = y;

		// return node;
	},
	



	checkHasAnswer(data, text) {

		text = text.toLowerCase();
		text = text.replace(/(^\s+)|(\s+$)/g,"");



		// -----
		let sentence = data.allText.replace('/\n/g', "");

		sentence = sentence.trim();
		sentence = sentence.toLowerCase();
		 


		if (sentence.indexOf(text) != -1) {

			// this.setTestLabel(line[i])

			return true;
		}
		// -----



		const block = data.block;
		for (let j = 0; j < block.length; j++) {

			const line = block[j].line;
			if (!line) {
				continue;
			}


			for (let i = 0; i < line.length; i++) {

				const word = line[i].word;
				const location = line[i].word[0].location;
		
				// console.log(' center line: ', line[i]);


				let sentence = ''
				word.forEach(item => {
					sentence += item.content.trim();
				});

				sentence = sentence.trim();
				sentence = sentence.toLowerCase();

				line[i].sentence = sentence;
				console.log('sentence: ' + sentence + ', text: ' + text);


				if (sentence.indexOf(text) != -1) {


					if (sentence) {
						this.setTestLabel(line[i])
					}

					// line[i].tmpLen = this.getToZeroLen(location)
					// if (!topLeftLetter) {
					// 	topLeftLetter = line[i];
					// } else {
					// 	if (topLeftLetter.tmpLen > line[i].tmpLen) {
					// 		topLeftLetter = line[i];
					// 	}
					// }

					return true;
				}
			}
		}

	},

	


	setTestLabel(labelData) {

		if (!this.debugLayer.parent || !this.debugLayer.active) {
			return;
		}
		// console.log('labelData: ', labelData)
		const location = labelData.word[0].location;
		const label = this.getLabel(labelData.sentence);
		label.anchorX = 0;
		// label.anchorY = 1;
		label.x = location.left;
		label.y = -location.top
		label.zIndex = 50;


		const rect = {};
		rect.width = location.right - location.left;
		rect.height = location.bottom - location.top;
		rect.x = location.left;
		rect.y = -location.top;
		// const colorRect = this.getColorRect(rect, cc.Color.YELLOW);
		// this.debugLayer.addChild(colorRect);

		this.debugLayer.addChild(label);
	},

	getLabel(text, fontSize = 20) {
		const labelNode = new cc.Node();
		const label = labelNode.addComponent(cc.Label);
		label.string = text;
		labelNode.color = cc.Color.BLACK;
		label.fontSize = fontSize;
		label.lineHeight = fontSize;
		return labelNode;
	},



	debugLayer: null,
	initDebugLayer() {


		console.log(' in initDebugLayer');
		const layer = new cc.Node();

		if (this.data.isDebug) {
			layer.parent = cc.find('Canvas');
		}


		layer.width = this.canvas.width / 2;
		layer.height = this.canvas.height / 2;

		layer.zIndex = 100;
		layer.anchorX = 0;
		layer.anchorY = 1;


		if (!this.data.bgItem2) {
			return;
		}


		cc.loader.load({url: this.data.bgItem2.url}, (err, img) => {

			this.debugBgImg = img;
			this.checkBg = img;
			layer.width = img.width;
			layer.height = img.height;

			layer.data = this.data.bgItem2;

			const sprNode = layer;
	
			var sf = new cc.SpriteFrame(img);

			const spr = sprNode.addComponent(cc.Sprite);
			spr.spriteFrame = sf			

			const sx = this.canvas.width / 2 / layer.width;
			const sy = (this.canvas.height) / 2 / layer.height;
			const s = Math.min(sx, sy);
			layer.scale = s;

			this.addNewRect();
			this.addCircleItem();
			this.addSignItem();
			this.addColorItem();

			this.initDebugRect();

			this.checkStart();
	
		});

		layer.x = -this.canvas.width / 2 + 10;
		layer.y = this.canvas.height / 2 - this.canvas.height / 3;
		layer.opacity = 150;

		// layer.scale = 2;
		this.debugLayer = layer;

		// const bgRectNode = new cc.Node();
		// const ctx = bgRectNode.addComponent(cc.Graphics);
		// ctx.fillRect(0, -layer.height, layer.width, layer.height);
		// ctx.fillColor = cc.Color.YELLOW.setA(100);
		// ctx.fill();
		// layer.addChild(bgRectNode);


		const drawLayer = new cc.Node();
    this.debugLayer.addChild(drawLayer, 2);

    this.debugDrawLayer = drawLayer;



	},

	initDebugRect() {

		console.log(' in initDebugRect');

		
		this.linkRectGroup = [];
		this.data.hotZoneItemArr2.forEach((item) => {
			switch (item.gIdx) {
				case "0":
					this.setOneDebugLinkRect(item);
					break;

				// case "1":
				// 	this.setOneDebugWriteRect(item);
				// 	break;

				default:
					break;
			}

		});
	

		console.log("this.linkRectGroup: ", this.linkRectGroup);
	},

	setOneDebugLinkRect(data) {
		const rate = (this.debugLayer.scale * this.debugLayer.width) / this.data.bgItem2.rect.width;
	
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.debugLayer.addChild(rectNode);

		let ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.debugLayer.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.height * scale - data.rect.y * scale;
	

		rectNode.anchorX = 0;
		rectNode.anchorY = 0;

		if (this.data.isDebug) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();


		rectNode['data'] = data;
		rectNode.opacity = 100;

		rectNode['ccRect'] = rectNode.getBoundingBoxToWorld()


		rectNode.isRightPoint = data.checkbox.list[0].value == true;

		this.linkRectGroup.push(rectNode);

		this.setLinkDataByDebugItem(rectNode, data.index);

	},

	setLinkDataByDebugItem(item, index) {

		let hzItemId;
		let debugItemId;
		let linkHzItemId;
		let linkDebugItemId;


		debugItemId = index + 1;

		const hzItem = this.getHzItemByPoint(debugItemId)

		hzItemId = this.data.hotZoneItemArr.indexOf(hzItem) + 1;

		console.log(' hzItem: ', hzItem);
		console.log(' debugItemId: ', debugItemId);

		linkHzItemId = hzItem.linkItem;

		const linkHzItem = this.data.hotZoneItemArr[linkHzItemId-1]

		linkDebugItemId = linkHzItem.pointItem;


		const linkData = {hzItemId, debugItemId, linkHzItemId, linkDebugItemId};
		item.linkData = linkData;

	},

	getHzItemByPoint(pointId, gidx = '0') {
		
		const hzItem = this.data.hotZoneItemArr.find((item) => {

			if (item.gIdx == gidx) {
				return item.pointItem == pointId
			}
		});

		return hzItem;
	},


	addColorItem() {
		console.log('addColorItem 1');
		if (!this.colorRectArr) {
			return;
		}

		console.log('addColorItem 2');

		this.colorRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.colorRectArr.length; i++) {
			const oneData = this.colorRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.colorRectCheckArr.push(rect);
			this.setColorRectPointsMax(rect);

			console.log('oneData: ', oneData);
		}
	},

	setColorRectPointsMax(rect) {

		const data = rect.data;

		const bgRect = this.data.bgItem2.rect;
		const regionRect = data.rect;
		const region = this.getRegionByRect(regionRect, bgRect);

		const regionW = region.right - region.left;
		const regionH = region.bottom - region.top;


		const pointRowNum = regionW / this.colorUnit;
		const pointColNum = regionH / this.colorUnit;
		const pointsMax = pointRowNum * pointColNum;
		
		rect.pointsMax = Math.round( pointsMax );
		console.log('rect.pointsMax : ', rect.pointsMax );
	},

	addSignItem() {
		if (!this.signRectArr) {
			return;
		}

		this.signRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.signRectArr.length; i++) {
			const oneData = this.signRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.signRectCheckArr.push(rect);
			console.log('oneData: ', oneData);
		}
	},

	addCircleItem() {

		if (!this.circleRectArr) {
			return;
		}

		this.circleRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.circleRectArr.length; i++) {
			const oneData = this.circleRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.circleRectCheckArr.push(rect);
			console.log('oneData: ', oneData);
		}
	},


	setDebugRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'blue');
		colorRect.opacity = 180;
		colorRect.data = data;

		colorRect.rectNode = rectNode;

		bg.addChild(colorRect, 20);

		return colorRect;
	},

	addNewRect() {
		
		if (!this.newRectArr) {
			return;
		}

		this.newRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.newRectArr.length; i++) {
			const oneData = this.newRectArr[i];
			this.setNewRectDot(oneData, bg);
			console.log('oneData: ', oneData);
		}

	},


	setNewRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'green');
		colorRect.opacity = 180;
		colorRect.data = data;
		bg.addChild(colorRect, 20);

		this.newRectCheckArr.push(colorRect);                                                                                                                                                                                        


		// if (this.data.bgItem.isShowDebugLine || true) {
		// 	ctx.rect(0, 0, rectNode.width, rectNode.height);
		// }
		// ctx.stroke();
		// ctx.fill();

	},
	 


	getPhotoWordArr(text, block, benchmark1Data) {


		const wordArr = [];
		// const maxLen = 10;

		text = text.trim();

		const topY = -benchmark1Data.top;

		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}


			const sentence = line.content;
			if (sentence.indexOf(text) != -1 ) {
				wordArr.push( line );
			}

			// for (let i=0; i<line.length; i++) {


			// 	const location = line[i].word[0].location;

			// 	const curTop = -location.top;
			// 	if (curTop >= topY ) {
			// 		continue;
			// 	}


			// 	let word = line[i].word;
			// 	let sentence = ''

			// 	// if (word.length > maxLen) {
			// 	// 	console.log('continue ', word.length);
			// 	// 	continue;
			// 	// }

			// 	line[i].word = word = this.checkCutWordData(word);
			// 	// console.log('word1~ ', word);


			// 	word.forEach(item => {
			// 		sentence += item.content + '';
			// 	});

			// 	sentence = sentence.trim().toLowerCase();

			// 	text = text.toLowerCase();

			// 	line[i].sentence = sentence;
			// 	console.log('sentence: ', sentence);
			// 	console.log('text: ', text);

			// 	console.log('index: ', sentence.indexOf(text));
			// 	if (sentence.indexOf(text) != -1 ) {
			// 		wordArr.push( line[i] );
			// 	}
			// }
		}

		return wordArr;
	},


	checkCutWordData(wordArr) {


		// console.log('wordArr: ', wordArr);

		let newWordArr = [];
		for(let i=0; i<wordArr.length; i++) {

			let wordObj = wordArr[i];

			wordObj.content = wordObj.content.trim();

			if (wordObj.content.length > 1) {

				const tmpArr = [];
				const w = wordObj.location.right - wordObj.location.left
				const subW = w / wordObj.content.length;
				for (let j=0; j<wordObj.content.length; j++) {

					const subWordObj = {};
					subWordObj.content = wordObj.content[j];
					subWordObj.location = {
						top: wordObj.location.top,
						bottom: wordObj.location.bottom,
						left: wordObj.location.left + subW * j,
						right: wordObj.location.left + subW * (j + 1)
					}

					tmpArr.push(subWordObj);
				}
				newWordArr = newWordArr.concat(tmpArr)


			} else {
				newWordArr.push(wordObj)
			}

		}

		// console.log('newWordArr: ', newWordArr);
		return newWordArr;
	},

	getPhotoData(cb) {

		cb({"result":{"text":[{"symbol":[3,1,1,3,3,1,1,3,3,1,3,1,1,3,1,3]}]}});
		return;
	

		const tmpData1 ={"result":{"text":[{"points":[0.096666664,0.34149486,0.1,0.34149486,0.10333333,0.34149486,0.086666666,0.34407216,0.09,0.34407216,0.093333334,0.34407216,0.096666664,0.34407216,0.1,0.34407216,0.10333333,0.34407216,0.10666667,0.34407216,0.11,0.34407216,0.11333334,0.34407216,0.083333336,0.3466495,0.086666666,0.3466495,0.09,0.3466495,0.093333334,0.3466495,0.096666664,0.3466495,0.1,0.3466495,0.10333333,0.3466495,0.10666667,0.3466495,0.11,0.3466495,0.11333334,0.3466495,0.11666667,0.3466495,0.08,0.3492268,0.083333336,0.3492268,0.086666666,0.3492268,0.09,0.3492268,0.093333334,0.3492268,0.096666664,0.3492268,0.1,0.3492268,0.10333333,0.3492268,0.10666667,0.3492268,0.11,0.3492268,0.11333334,0.3492268,0.11666667,0.3492268,0.12,0.3492268,0.07666667,0.35180414,0.08,0.35180414,0.083333336,0.35180414,0.086666666,0.35180414,0.09,0.35180414,0.093333334,0.35180414,0.096666664,0.35180414,0.1,0.35180414,0.10333333,0.35180414,0.10666667,0.35180414,0.11,0.35180414,0.11333334,0.35180414,0.11666667,0.35180414,0.12,0.35180414,0.20333333,0.35180414,0.62,0.35180414,0.07666667,0.35438144,0.08,0.35438144,0.083333336,0.35438144,0.086666666,0.35438144,0.09,0.35438144,0.096666664,0.35438144,0.1,0.35438144,0.10333333,0.35438144,0.10666667,0.35438144,0.11,0.35438144,0.11333334,0.35438144,0.11666667,0.35438144,0.12,0.35438144,0.16666667,0.35438144,0.20333333,0.35438144,0.20666666,0.35438144,0.25,0.35438144,0.27333334,0.35438144,0.42333335,0.35438144,0.5,0.35438144,0.62,0.35438144,0.74333334,0.35438144,0.07666667,0.35695878,0.08,0.35695878,0.083333336,0.35695878,0.086666666,0.35695878,0.09,0.35695878,0.093333334,0.35695878,0.096666664,0.35695878,0.1,0.35695878,0.10666667,0.35695878,0.11,0.35695878,0.11333334,0.35695878,0.11666667,0.35695878,0.12,0.35695878,0.14333333,0.35695878,0.15333334,0.35695878,0.16333333,0.35695878,0.20333333,0.35695878,0.24666667,0.35695878,0.26666668,0.35695878,0.27333334,0.35695878,0.32,0.35695878,0.35333332,0.35695878,0.36,0.35695878,0.4,0.35695878,0.41666666,0.35695878,0.42333335,0.35695878,0.5,0.35695878,0.63,0.35695878,0.71,0.35695878,0.74666667,0.35695878,0.07666667,0.35953608,0.08,0.35953608,0.083333336,0.35953608,0.086666666,0.35953608,0.09,0.35953608,0.093333334,0.35953608,0.096666664,0.35953608,0.1,0.35953608,0.10666667,0.35953608,0.11,0.35953608,0.11333334,0.35953608,0.11666667,0.35953608,0.12,0.35953608,0.14,0.35953608,0.14333333,0.35953608,0.15,0.35953608,0.15333334,0.35953608,0.16333333,0.35953608,0.17333333,0.35953608,0.18,0.35953608,0.20333333,0.35953608,0.24666667,0.35953608,0.25666666,0.35953608,0.34666666,0.35953608,0.35333332,0.35953608,0.36,0.35953608,0.38666666,0.35953608,0.39,0.35953608,0.40666667,0.35953608,0.42333335,0.35953608,0.45,0.35953608,0.46666667,0.35953608,0.57,0.35953608,0.58666664,0.35953608,0.63,0.35953608,0.71,0.35953608,0.71666664,0.35953608,0.74666667,0.35953608,0.07666667,0.36211342,0.08,0.36211342,0.083333336,0.36211342,0.086666666,0.36211342,0.09,0.36211342,0.093333334,0.36211342,0.096666664,0.36211342,0.1,0.36211342,0.10333333,0.36211342,0.10666667,0.36211342,0.11,0.36211342,0.11333334,0.36211342,0.11666667,0.36211342,0.12,0.36211342,0.14,0.36211342,0.14333333,0.36211342,0.15,0.36211342,0.15333334,0.36211342,0.16333333,0.36211342,0.17333333,0.36211342,0.18,0.36211342,0.25666666,0.36211342,0.27,0.36211342,0.34666666,0.36211342,0.56,0.36211342,0.57,0.36211342,0.63,0.36211342,0.6533333,0.36211342,0.68,0.36211342,0.68333334,0.36211342,0.70666665,0.36211342,0.71,0.36211342,0.71666664,0.36211342,0.7266667,0.36211342,0.82,0.36211342,0.07666667,0.36469072,0.08,0.36469072,0.083333336,0.36469072,0.086666666,0.36469072,0.09,0.36469072,0.093333334,0.36469072,0.096666664,0.36469072,0.1,0.36469072,0.10333333,0.36469072,0.10666667,0.36469072,0.11,0.36469072,0.11333334,0.36469072,0.11666667,0.36469072,0.12,0.36469072,0.34333333,0.36469072,0.34666666,0.36469072,0.81,0.36469072,0.82,0.36469072,0.08,0.36726806,0.083333336,0.36726806,0.086666666,0.36726806,0.09,0.36726806,0.093333334,0.36726806,0.096666664,0.36726806,0.1,0.36726806,0.10333333,0.36726806,0.10666667,0.36726806,0.11,0.36726806,0.11333334,0.36726806,0.11666667,0.36726806,0.08,0.36984536,0.083333336,0.36984536,0.086666666,0.36984536,0.09,0.36984536,0.093333334,0.36984536,0.096666664,0.36984536,0.1,0.36984536,0.10333333,0.36984536,0.10666667,0.36984536,0.11,0.36984536,0.11333334,0.36984536,0.083333336,0.3724227,0.086666666,0.3724227,0.09,0.3724227,0.093333334,0.3724227,0.096666664,0.3724227,0.1,0.3724227,0.10333333,0.3724227,0.10666667,0.3724227,0.11,0.3724227,0.086666666,0.375,0.09,0.375,0.093333334,0.375,0.096666664,0.375,0.1,0.375,0.10333333,0.375,0.5,0.38273194,0.50333333,0.38273194,0.50666666,0.38273194,0.22,0.38530928,0.22333333,0.38530928,0.22666667,0.38530928,0.23,0.38530928,0.23333333,0.38530928,0.23666666,0.38530928,0.24,0.38530928,0.24333334,0.38530928,0.49333334,0.38530928,0.49666667,0.38530928,0.5,0.38530928,0.50333333,0.38530928,0.50666666,0.38530928,0.51,0.38530928,0.5133333,0.38530928,0.21666667,0.38788658,0.22,0.38788658,0.22333333,0.38788658,0.22666667,0.38788658,0.23,0.38788658,0.23333333,0.38788658,0.23666666,0.38788658,0.24,0.38788658,0.24333334,0.38788658,0.24666667,0.38788658,0.42,0.38788658,0.49,0.38788658,0.49333334,0.38788658,0.49666667,0.38788658,0.5,0.38788658,0.50333333,0.38788658,0.50666666,0.38788658,0.51,0.38788658,0.5133333,0.38788658,0.75333333,0.38788658,0.75666666,0.38788658,0.76,0.38788658,0.7633333,0.38788658,0.76666665,0.38788658,0.77,0.38788658,0.7733333,0.38788658,0.77666664,0.38788658,0.78,0.38788658,0.21333334,0.39046392,0.21666667,0.39046392,0.22,0.39046392,0.22333333,0.39046392,0.22666667,0.39046392,0.23,0.39046392,0.23333333,0.39046392,0.23666666,0.39046392,0.24,0.39046392,0.24333334,0.39046392,0.24666667,0.39046392,0.25,0.39046392,0.41333333,0.39046392,0.41666666,0.39046392,0.42,0.39046392,0.42333335,0.39046392,0.42666668,0.39046392,0.43,0.39046392,0.43333334,0.39046392,0.48666668,0.39046392,0.49,0.39046392,0.49333334,0.39046392,0.49666667,0.39046392,0.5,0.39046392,0.50333333,0.39046392,0.50666666,0.39046392,0.51,0.39046392,0.5133333,0.39046392,0.51666665,0.39046392,0.75,0.39046392,0.75333333,0.39046392,0.75666666,0.39046392,0.76,0.39046392,0.7633333,0.39046392,0.76666665,0.39046392,0.77,0.39046392,0.7733333,0.39046392,0.77666664,0.39046392,0.78,0.39046392,0.78333336,0.39046392,0.7866667,0.39046392,0.21,0.39304122,0.21333334,0.39304122,0.21666667,0.39304122,0.22,0.39304122,0.22333333,0.39304122,0.22666667,0.39304122,0.23,0.39304122,0.23333333,0.39304122,0.23666666,0.39304122,0.24,0.39304122,0.24333334,0.39304122,0.24666667,0.39304122,0.25,0.39304122,0.25333333,0.39304122,0.41333333,0.39304122,0.41666666,0.39304122,0.42,0.39304122,0.42333335,0.39304122,0.42666668,0.39304122,0.43,0.39304122,0.43333334,0.39304122,0.43666667,0.39304122,0.48666668,0.39304122,0.49,0.39304122,0.49333334,0.39304122,0.49666667,0.39304122,0.5,0.39304122,0.50333333,0.39304122,0.50666666,0.39304122,0.51,0.39304122,0.5133333,0.39304122,0.51666665,0.39304122,0.74666667,0.39304122,0.75,0.39304122,0.75333333,0.39304122,0.75666666,0.39304122,0.76,0.39304122,0.7633333,0.39304122,0.76666665,0.39304122,0.77,0.39304122,0.7733333,0.39304122,0.77666664,0.39304122,0.78,0.39304122,0.78333336,0.39304122,0.7866667,0.39304122,0.79,0.39304122,0.14333333,0.39561856,0.14666666,0.39561856,0.15,0.39561856,0.15333334,0.39561856,0.15666667,0.39561856,0.21,0.39561856,0.21333334,0.39561856,0.21666667,0.39561856,0.22,0.39561856,0.22333333,0.39561856,0.22666667,0.39561856,0.23,0.39561856,0.23333333,0.39561856,0.23666666,0.39561856,0.24,0.39561856,0.24333334,0.39561856,0.24666667,0.39561856,0.25,0.39561856,0.25333333,0.39561856,0.41666666,0.39561856,0.42,0.39561856,0.42333335,0.39561856,0.42666668,0.39561856,0.43,0.39561856,0.43333334,0.39561856,0.43666667,0.39561856,0.44,0.39561856,0.48333332,0.39561856,0.48666668,0.39561856,0.49,0.39561856,0.49333334,0.39561856,0.49666667,0.39561856,0.5,0.39561856,0.50333333,0.39561856,0.50666666,0.39561856,0.51,0.39561856,0.5133333,0.39561856,0.51666665,0.39561856,0.69666666,0.39561856,0.7,0.39561856,0.7033333,0.39561856,0.74666667,0.39561856,0.75,0.39561856,0.75333333,0.39561856,0.75666666,0.39561856,0.76,0.39561856,0.7633333,0.39561856,0.76666665,0.39561856,0.77,0.39561856,0.7733333,0.39561856,0.77666664,0.39561856,0.78,0.39561856,0.78333336,0.39561856,0.7866667,0.39561856,0.79,0.39561856,0.79333335,0.39561856,0.14,0.39819586,0.14333333,0.39819586,0.14666666,0.39819586,0.15,0.39819586,0.15333334,0.39819586,0.15666667,0.39819586,0.16,0.39819586,0.16333333,0.39819586,0.20666666,0.39819586,0.21,0.39819586,0.21333334,0.39819586,0.21666667,0.39819586,0.22,0.39819586,0.22333333,0.39819586,0.22666667,0.39819586,0.23,0.39819586,0.23333333,0.39819586,0.23666666,0.39819586,0.24,0.39819586,0.24333334,0.39819586,0.24666667,0.39819586,0.25,0.39819586,0.42,0.39819586,0.42333335,0.39819586,0.42666668,0.39819586,0.43,0.39819586,0.43333334,0.39819586,0.43666667,0.39819586,0.44,0.39819586,0.48333332,0.39819586,0.48666668,0.39819586,0.49,0.39819586,0.49333334,0.39819586,0.49666667,0.39819586,0.5,0.39819586,0.50333333,0.39819586,0.50666666,0.39819586,0.51,0.39819586,0.5133333,0.39819586,0.51666665,0.39819586,0.69,0.39819586,0.6933333,0.39819586,0.69666666,0.39819586,0.7,0.39819586,0.7033333,0.39819586,0.70666665,0.39819586,0.71,0.39819586,0.74666667,0.39819586,0.75,0.39819586,0.75333333,0.39819586,0.75666666,0.39819586,0.76,0.39819586,0.7633333,0.39819586,0.76666665,0.39819586,0.77,0.39819586,0.7733333,0.39819586,0.77666664,0.39819586,0.78,0.39819586,0.78333336,0.39819586,0.7866667,0.39819586,0.79,0.39819586,0.79333335,0.39819586,0.14,0.4007732,0.14333333,0.4007732,0.14666666,0.4007732,0.15,0.4007732,0.15333334,0.4007732,0.15666667,0.4007732,0.16,0.4007732,0.16333333,0.4007732,0.16666667,0.4007732,0.20333333,0.4007732,0.20666666,0.4007732,0.21,0.4007732,0.21333334,0.4007732,0.21666667,0.4007732,0.22,0.4007732,0.22333333,0.4007732,0.22666667,0.4007732,0.23,0.4007732,0.23333333,0.4007732,0.23666666,0.4007732,0.24,0.4007732,0.24333334,0.4007732,0.24666667,0.4007732,0.25,0.4007732,0.42333335,0.4007732,0.42666668,0.4007732,0.43,0.4007732,0.43333334,0.4007732,0.43666667,0.4007732,0.44,0.4007732,0.44333333,0.4007732,0.48333332,0.4007732,0.48666668,0.4007732,0.49,0.4007732,0.49333334,0.4007732,0.49666667,0.4007732,0.5,0.4007732,0.50333333,0.4007732,0.50666666,0.4007732,0.51,0.4007732,0.5133333,0.4007732,0.51666665,0.4007732,0.69,0.4007732,0.6933333,0.4007732,0.69666666,0.4007732,0.7,0.4007732,0.7033333,0.4007732,0.70666665,0.4007732,0.71,0.4007732,0.7133333,0.4007732,0.74666667,0.4007732,0.75,0.4007732,0.75333333,0.4007732,0.75666666,0.4007732,0.76,0.4007732,0.7633333,0.4007732,0.76666665,0.4007732,0.77,0.4007732,0.7733333,0.4007732,0.77666664,0.4007732,0.78,0.4007732,0.78333336,0.4007732,0.7866667,0.4007732,0.79,0.4007732,0.79333335,0.4007732,0.7966667,0.4007732,0.14333333,0.4033505,0.14666666,0.4033505,0.15,0.4033505,0.15333334,0.4033505,0.15666667,0.4033505,0.16,0.4033505,0.16333333,0.4033505,0.16666667,0.4033505,0.17,0.4033505,0.20333333,0.4033505,0.20666666,0.4033505,0.21,0.4033505,0.21333334,0.4033505,0.21666667,0.4033505,0.22,0.4033505,0.22333333,0.4033505,0.22666667,0.4033505,0.23,0.4033505,0.23333333,0.4033505,0.23666666,0.4033505,0.24,0.4033505,0.24333334,0.4033505,0.24666667,0.4033505,0.25,0.4033505,0.40666667,0.4033505,0.41,0.4033505,0.42333335,0.4033505,0.42666668,0.4033505,0.43,0.4033505,0.43333334,0.4033505,0.43666667,0.4033505,0.44,0.4033505,0.44333333,0.4033505,0.44666666,0.4033505,0.48333332,0.4033505,0.48666668,0.4033505,0.49,0.4033505,0.49333334,0.4033505,0.49666667,0.4033505,0.5,0.4033505,0.50333333,0.4033505,0.50666666,0.4033505,0.51,0.4033505,0.5133333,0.4033505,0.53,0.4033505,0.53333336,0.4033505,0.5366667,0.4033505,0.67333335,0.4033505,0.69,0.4033505,0.6933333,0.4033505,0.69666666,0.4033505,0.7,0.4033505,0.7033333,0.4033505,0.70666665,0.4033505,0.71,0.4033505,0.7133333,0.4033505,0.71666664,0.4033505,0.74666667,0.4033505,0.75,0.4033505,0.75333333,0.4033505,0.75666666,0.4033505,0.76,0.4033505,0.7633333,0.4033505,0.76666665,0.4033505,0.77,0.4033505,0.7733333,0.4033505,0.77666664,0.4033505,0.78,0.4033505,0.78333336,0.4033505,0.7866667,0.4033505,0.79,0.4033505,0.79333335,0.4033505,0.7966667,0.4033505,0.14666666,0.40592784,0.15,0.40592784,0.15333334,0.40592784,0.15666667,0.40592784,0.16,0.40592784,0.16333333,0.40592784,0.16666667,0.40592784,0.17,0.40592784,0.17333333,0.40592784,0.2,0.40592784,0.20333333,0.40592784,0.20666666,0.40592784,0.21,0.40592784,0.21333334,0.40592784,0.21666667,0.40592784,0.22,0.40592784,0.22333333,0.40592784,0.22666667,0.40592784,0.23,0.40592784,0.23333333,0.40592784,0.23666666,0.40592784,0.24,0.40592784,0.24333334,0.40592784,0.24666667,0.40592784,0.41,0.40592784,0.42666668,0.40592784,0.43,0.40592784,0.43333334,0.40592784,0.43666667,0.40592784,0.44,0.40592784,0.44333333,0.40592784,0.44666666,0.40592784,0.45,0.40592784,0.48,0.40592784,0.48333332,0.40592784,0.48666668,0.40592784,0.49,0.40592784,0.49333334,0.40592784,0.49666667,0.40592784,0.5,0.40592784,0.50333333,0.40592784,0.50666666,0.40592784,0.51,0.40592784,0.5133333,0.40592784,0.52666664,0.40592784,0.53,0.40592784,0.53333336,0.40592784,0.5366667,0.40592784,0.54,0.40592784,0.67,0.40592784,0.67333335,0.40592784,0.6766667,0.40592784,0.69,0.40592784,0.6933333,0.40592784,0.69666666,0.40592784,0.7,0.40592784,0.7033333,0.40592784,0.70666665,0.40592784,0.71,0.40592784,0.7133333,0.40592784,0.71666664,0.40592784,0.75,0.40592784,0.75333333,0.40592784,0.75666666,0.40592784,0.76,0.40592784,0.7633333,0.40592784,0.76666665,0.40592784,0.77,0.40592784,0.7733333,0.40592784,0.77666664,0.40592784,0.78,0.40592784,0.78333336,0.40592784,0.7866667,0.40592784,0.79,0.40592784,0.79333335,0.40592784,0.14666666,0.40850514,0.15,0.40850514,0.15333334,0.40850514,0.15666667,0.40850514,0.16,0.40850514,0.16333333,0.40850514,0.16666667,0.40850514,0.17,0.40850514,0.17333333,0.40850514,0.17666666,0.40850514,0.18,0.40850514,0.19666667,0.40850514,0.2,0.40850514,0.20333333,0.40850514,0.20666666,0.40850514,0.21,0.40850514,0.21333334,0.40850514,0.21666667,0.40850514,0.22,0.40850514,0.22333333,0.40850514,0.22666667,0.40850514,0.23,0.40850514,0.23333333,0.40850514,0.23666666,0.40850514,0.24,0.40850514,0.24333334,0.40850514,0.24666667,0.40850514,0.40666667,0.40850514,0.41,0.40850514,0.42666668,0.40850514,0.43,0.40850514,0.43333334,0.40850514,0.43666667,0.40850514,0.44,0.40850514,0.44333333,0.40850514,0.44666666,0.40850514,0.45,0.40850514,0.45333335,0.40850514,0.47666666,0.40850514,0.48,0.40850514,0.48333332,0.40850514,0.48666668,0.40850514,0.49,0.40850514,0.49333334,0.40850514,0.49666667,0.40850514,0.5,0.40850514,0.50333333,0.40850514,0.50666666,0.40850514,0.51,0.40850514,0.5133333,0.40850514,0.5233333,0.40850514,0.52666664,0.40850514,0.53,0.40850514,0.53333336,0.40850514,0.5366667,0.40850514,0.54,0.40850514,0.59,0.40850514,0.5933333,0.40850514,0.5966667,0.40850514,0.67333335,0.40850514,0.6766667,0.40850514,0.6933333,0.40850514,0.69666666,0.40850514,0.7,0.40850514,0.7033333,0.40850514,0.70666665,0.40850514,0.71,0.40850514,0.7133333,0.40850514,0.71666664,0.40850514,0.72,0.40850514,0.75,0.40850514,0.75333333,0.40850514,0.75666666,0.40850514,0.76,0.40850514,0.7633333,0.40850514,0.76666665,0.40850514,0.77,0.40850514,0.7733333,0.40850514,0.77666664,0.40850514,0.78,0.40850514,0.78333336,0.40850514,0.7866667,0.40850514,0.79,0.40850514,0.79333335,0.40850514,0.14666666,0.41108248,0.15,0.41108248,0.15333334,0.41108248,0.15666667,0.41108248,0.16,0.41108248,0.16333333,0.41108248,0.16666667,0.41108248,0.17,0.41108248,0.17333333,0.41108248,0.17666666,0.41108248,0.18,0.41108248,0.18333334,0.41108248,0.18666667,0.41108248,0.19,0.41108248,0.19333333,0.41108248,0.19666667,0.41108248,0.2,0.41108248,0.20333333,0.41108248,0.20666666,0.41108248,0.21,0.41108248,0.21333334,0.41108248,0.21666667,0.41108248,0.22,0.41108248,0.22333333,0.41108248,0.22666667,0.41108248,0.23,0.41108248,0.23333333,0.41108248,0.23666666,0.41108248,0.24,0.41108248,0.24333334,0.41108248,0.29,0.41108248,0.29333332,0.41108248,0.29666665,0.41108248,0.3,0.41108248,0.30333334,0.41108248,0.30666667,0.41108248,0.31,0.41108248,0.31333333,0.41108248,0.31666666,0.41108248,0.40333334,0.41108248,0.40666667,0.41108248,0.42666668,0.41108248,0.43,0.41108248,0.43333334,0.41108248,0.43666667,0.41108248,0.44,0.41108248,0.44333333,0.41108248,0.44666666,0.41108248,0.45,0.41108248,0.45333335,0.41108248,0.45666668,0.41108248,0.46,0.41108248,0.47333333,0.41108248,0.47666666,0.41108248,0.48,0.41108248,0.48333332,0.41108248,0.48666668,0.41108248,0.49,0.41108248,0.49333334,0.41108248,0.49666667,0.41108248,0.5,0.41108248,0.50333333,0.41108248,0.50666666,0.41108248,0.51,0.41108248,0.5133333,0.41108248,0.51666665,0.41108248,0.52,0.41108248,0.5233333,0.41108248,0.52666664,0.41108248,0.53,0.41108248,0.53333336,0.41108248,0.5366667,0.41108248,0.54,0.41108248,0.58,0.41108248,0.5833333,0.41108248,0.58666664,0.41108248,0.59,0.41108248,0.5933333,0.41108248,0.5966667,0.41108248,0.6,0.41108248,0.60333335,0.41108248,0.6066667,0.41108248,0.61,0.41108248,0.67333335,0.41108248,0.6766667,0.41108248,0.6933333,0.41108248,0.69666666,0.41108248,0.7,0.41108248,0.7033333,0.41108248,0.70666665,0.41108248,0.71,0.41108248,0.7133333,0.41108248,0.71666664,0.41108248,0.72,0.41108248,0.75,0.41108248,0.75333333,0.41108248,0.75666666,0.41108248,0.76,0.41108248,0.7633333,0.41108248,0.76666665,0.41108248,0.77,0.41108248,0.7733333,0.41108248,0.77666664,0.41108248,0.78,0.41108248,0.78333336,0.41108248,0.7866667,0.41108248,0.79,0.41108248,0.79333335,0.41108248,0.14666666,0.41365978,0.15,0.41365978,0.15333334,0.41365978,0.15666667,0.41365978,0.16,0.41365978,0.16333333,0.41365978,0.16666667,0.41365978,0.17,0.41365978,0.17333333,0.41365978,0.17666666,0.41365978,0.18,0.41365978,0.18333334,0.41365978,0.18666667,0.41365978,0.19,0.41365978,0.19333333,0.41365978,0.19666667,0.41365978,0.2,0.41365978,0.20333333,0.41365978,0.20666666,0.41365978,0.21,0.41365978,0.21333334,0.41365978,0.21666667,0.41365978,0.22,0.41365978,0.22333333,0.41365978,0.22666667,0.41365978,0.23,0.41365978,0.23333333,0.41365978,0.23666666,0.41365978,0.24,0.41365978,0.24333334,0.41365978,0.28333333,0.41365978,0.28666666,0.41365978,0.29,0.41365978,0.29333332,0.41365978,0.29666665,0.41365978,0.3,0.41365978,0.30333334,0.41365978,0.30666667,0.41365978,0.31,0.41365978,0.31333333,0.41365978,0.31666666,0.41365978,0.32,0.41365978,0.32333332,0.41365978,0.40333334,0.41365978,0.40666667,0.41365978,0.42333335,0.41365978,0.42666668,0.41365978,0.43,0.41365978,0.43333334,0.41365978,0.43666667,0.41365978,0.44,0.41365978,0.44333333,0.41365978,0.44666666,0.41365978,0.45,0.41365978,0.45333335,0.41365978,0.45666668,0.41365978,0.46,0.41365978,0.46333334,0.41365978,0.46666667,0.41365978,0.47,0.41365978,0.47333333,0.41365978,0.47666666,0.41365978,0.48,0.41365978,0.48333332,0.41365978,0.48666668,0.41365978,0.49,0.41365978,0.49333334,0.41365978,0.49666667,0.41365978,0.5,0.41365978,0.50333333,0.41365978,0.50666666,0.41365978,0.51,0.41365978,0.5133333,0.41365978,0.51666665,0.41365978,0.52,0.41365978,0.5233333,0.41365978,0.52666664,0.41365978,0.53,0.41365978,0.53333336,0.41365978,0.5366667,0.41365978,0.54,0.41365978,0.57,0.41365978,0.5733333,0.41365978,0.57666665,0.41365978,0.58,0.41365978,0.5833333,0.41365978,0.58666664,0.41365978,0.59,0.41365978,0.5933333,0.41365978,0.5966667,0.41365978,0.6,0.41365978,0.60333335,0.41365978,0.6066667,0.41365978,0.61,0.41365978,0.67333335,0.41365978,0.6766667,0.41365978,0.69,0.41365978,0.6933333,0.41365978,0.69666666,0.41365978,0.7,0.41365978,0.7033333,0.41365978,0.70666665,0.41365978,0.71,0.41365978,0.7133333,0.41365978,0.71666664,0.41365978,0.72,0.41365978,0.72333336,0.41365978,0.75,0.41365978,0.75333333,0.41365978,0.75666666,0.41365978,0.76,0.41365978,0.7633333,0.41365978,0.76666665,0.41365978,0.77,0.41365978,0.7733333,0.41365978,0.77666664,0.41365978,0.78,0.41365978,0.78333336,0.41365978,0.7866667,0.41365978,0.79,0.41365978,0.79333335,0.41365978,0.85333335,0.41365978,0.8566667,0.41365978,0.86,0.41365978,0.86333334,0.41365978,0.8666667,0.41365978,0.87,0.41365978,0.87333333,0.41365978,0.87666667,0.41365978,0.88,0.41365978,0.14666666,0.41623712,0.15,0.41623712,0.15333334,0.41623712,0.15666667,0.41623712,0.16,0.41623712,0.16333333,0.41623712,0.16666667,0.41623712,0.17,0.41623712,0.17333333,0.41623712,0.17666666,0.41623712,0.18,0.41623712,0.18333334,0.41623712,0.18666667,0.41623712,0.19,0.41623712,0.19333333,0.41623712,0.19666667,0.41623712,0.2,0.41623712,0.20333333,0.41623712,0.20666666,0.41623712,0.21,0.41623712,0.21333334,0.41623712,0.21666667,0.41623712,0.22,0.41623712,0.22333333,0.41623712,0.22666667,0.41623712,0.23,0.41623712,0.23333333,0.41623712,0.23666666,0.41623712,0.24,0.41623712,0.24333334,0.41623712,0.27666667,0.41623712,0.28,0.41623712,0.28333333,0.41623712,0.28666666,0.41623712,0.29,0.41623712,0.29333332,0.41623712,0.29666665,0.41623712,0.3,0.41623712,0.30333334,0.41623712,0.30666667,0.41623712,0.31,0.41623712,0.31333333,0.41623712,0.31666666,0.41623712,0.32,0.41623712,0.32333332,0.41623712,0.32666665,0.41623712,0.42333335,0.41623712,0.42666668,0.41623712,0.43,0.41623712,0.43333334,0.41623712,0.43666667,0.41623712,0.44,0.41623712,0.44333333,0.41623712,0.44666666,0.41623712,0.45,0.41623712,0.45333335,0.41623712,0.45666668,0.41623712,0.46,0.41623712,0.46333334,0.41623712,0.46666667,0.41623712,0.47,0.41623712,0.47333333,0.41623712,0.47666666,0.41623712,0.48,0.41623712,0.48333332,0.41623712,0.48666668,0.41623712,0.49,0.41623712,0.49333334,0.41623712,0.49666667,0.41623712,0.5,0.41623712,0.50333333,0.41623712,0.50666666,0.41623712,0.51,0.41623712,0.5133333,0.41623712,0.51666665,0.41623712,0.52,0.41623712,0.5233333,0.41623712,0.52666664,0.41623712,0.53,0.41623712,0.53333336,0.41623712,0.5366667,0.41623712,0.54,0.41623712,0.54333335,0.41623712,0.56333333,0.41623712,0.56666666,0.41623712,0.57,0.41623712,0.5733333,0.41623712,0.57666665,0.41623712,0.58,0.41623712,0.5833333,0.41623712,0.58666664,0.41623712,0.59,0.41623712,0.5933333,0.41623712,0.5966667,0.41623712,0.6,0.41623712,0.60333335,0.41623712,0.6066667,0.41623712,0.61,0.41623712,0.61333334,0.41623712,0.67333335,0.41623712,0.69,0.41623712,0.6933333,0.41623712,0.69666666,0.41623712,0.7,0.41623712,0.7033333,0.41623712,0.70666665,0.41623712,0.71,0.41623712,0.7133333,0.41623712,0.71666664,0.41623712,0.72,0.41623712,0.72333336,0.41623712,0.7266667,0.41623712,0.75333333,0.41623712,0.75666666,0.41623712,0.76,0.41623712,0.7633333,0.41623712,0.76666665,0.41623712,0.77,0.41623712,0.7733333,0.41623712,0.77666664,0.41623712,0.78,0.41623712,0.78333336,0.41623712,0.7866667,0.41623712,0.79,0.41623712,0.79333335,0.41623712,0.85,0.41623712,0.85333335,0.41623712,0.8566667,0.41623712,0.86,0.41623712,0.86333334,0.41623712,0.8666667,0.41623712,0.87,0.41623712,0.87333333,0.41623712,0.87666667,0.41623712,0.88,0.41623712,0.8833333,0.41623712,0.88666666,0.41623712,0.14333333,0.41881442,0.14666666,0.41881442,0.15,0.41881442,0.15333334,0.41881442,0.15666667,0.41881442,0.16,0.41881442,0.16333333,0.41881442,0.16666667,0.41881442,0.17,0.41881442,0.17333333,0.41881442,0.17666666,0.41881442,0.18,0.41881442,0.18333334,0.41881442,0.18666667,0.41881442,0.19,0.41881442,0.19333333,0.41881442,0.19666667,0.41881442,0.2,0.41881442,0.20333333,0.41881442,0.20666666,0.41881442,0.21,0.41881442,0.21333334,0.41881442,0.21666667,0.41881442,0.22,0.41881442,0.22333333,0.41881442,0.22666667,0.41881442,0.23,0.41881442,0.23333333,0.41881442,0.23666666,0.41881442,0.24,0.41881442,0.24333334,0.41881442,0.24666667,0.41881442,0.27,0.41881442,0.27333334,0.41881442,0.27666667,0.41881442,0.28,0.41881442,0.28333333,0.41881442,0.28666666,0.41881442,0.29,0.41881442,0.29333332,0.41881442,0.29666665,0.41881442,0.3,0.41881442,0.30333334,0.41881442,0.30666667,0.41881442,0.31,0.41881442,0.31333333,0.41881442,0.31666666,0.41881442,0.32,0.41881442,0.32333332,0.41881442,0.32666665,0.41881442,0.33,0.41881442,0.42,0.41881442,0.42333335,0.41881442,0.42666668,0.41881442,0.43,0.41881442,0.43333334,0.41881442,0.43666667,0.41881442,0.44,0.41881442,0.44333333,0.41881442,0.44666666,0.41881442,0.45,0.41881442,0.45333335,0.41881442,0.45666668,0.41881442,0.46,0.41881442,0.46333334,0.41881442,0.46666667,0.41881442,0.47,0.41881442,0.47333333,0.41881442,0.47666666,0.41881442,0.48,0.41881442,0.48333332,0.41881442,0.48666668,0.41881442,0.49,0.41881442,0.49333334,0.41881442,0.49666667,0.41881442,0.5,0.41881442,0.50333333,0.41881442,0.50666666,0.41881442,0.51,0.41881442,0.5133333,0.41881442,0.51666665,0.41881442,0.52,0.41881442,0.5233333,0.41881442,0.52666664,0.41881442,0.53,0.41881442,0.53333336,0.41881442,0.5366667,0.41881442,0.54,0.41881442,0.54333335,0.41881442,0.56,0.41881442,0.56333333,0.41881442,0.56666666,0.41881442,0.57,0.41881442,0.5733333,0.41881442,0.57666665,0.41881442,0.58,0.41881442,0.5833333,0.41881442,0.58666664,0.41881442,0.59,0.41881442,0.5933333,0.41881442,0.5966667,0.41881442,0.6,0.41881442,0.60333335,0.41881442,0.6066667,0.41881442,0.61,0.41881442,0.61333334,0.41881442,0.68666667,0.41881442,0.69,0.41881442,0.6933333,0.41881442,0.69666666,0.41881442,0.7,0.41881442,0.7033333,0.41881442,0.70666665,0.41881442,0.71,0.41881442,0.7133333,0.41881442,0.71666664,0.41881442,0.72,0.41881442,0.72333336,0.41881442,0.7266667,0.41881442,0.75333333,0.41881442,0.75666666,0.41881442,0.76,0.41881442,0.7633333,0.41881442,0.76666665,0.41881442,0.77,0.41881442,0.7733333,0.41881442,0.77666664,0.41881442,0.78,0.41881442,0.78333336,0.41881442,0.7866667,0.41881442,0.79,0.41881442,0.79333335,0.41881442,0.8466667,0.41881442,0.85,0.41881442,0.85333335,0.41881442,0.8566667,0.41881442,0.86,0.41881442,0.86333334,0.41881442,0.8666667,0.41881442,0.87,0.41881442,0.87333333,0.41881442,0.87666667,0.41881442,0.88,0.41881442,0.8833333,0.41881442,0.88666666,0.41881442,0.89,0.41881442,0.8933333,0.41881442,0.14333333,0.42139176,0.14666666,0.42139176,0.15,0.42139176,0.15333334,0.42139176,0.15666667,0.42139176,0.16,0.42139176,0.16333333,0.42139176,0.16666667,0.42139176,0.17,0.42139176,0.17333333,0.42139176,0.17666666,0.42139176,0.18,0.42139176,0.18333334,0.42139176,0.18666667,0.42139176,0.19,0.42139176,0.19333333,0.42139176,0.19666667,0.42139176,0.2,0.42139176,0.20333333,0.42139176,0.20666666,0.42139176,0.21,0.42139176,0.21333334,0.42139176,0.21666667,0.42139176,0.22,0.42139176,0.22333333,0.42139176,0.22666667,0.42139176,0.23,0.42139176,0.23333333,0.42139176,0.23666666,0.42139176,0.24,0.42139176,0.24333334,0.42139176,0.24666667,0.42139176,0.25,0.42139176,0.25333333,0.42139176,0.25666666,0.42139176,0.26,0.42139176,0.26333332,0.42139176,0.26666668,0.42139176,0.27,0.42139176,0.27333334,0.42139176,0.27666667,0.42139176,0.28,0.42139176,0.28333333,0.42139176,0.28666666,0.42139176,0.29,0.42139176,0.29333332,0.42139176,0.29666665,0.42139176,0.3,0.42139176,0.30333334,0.42139176,0.30666667,0.42139176,0.31,0.42139176,0.31333333,0.42139176,0.31666666,0.42139176,0.32,0.42139176,0.32333332,0.42139176,0.32666665,0.42139176,0.33,0.42139176,0.41666666,0.42139176,0.42,0.42139176,0.42333335,0.42139176,0.42666668,0.42139176,0.43,0.42139176,0.43333334,0.42139176,0.43666667,0.42139176,0.44,0.42139176,0.44333333,0.42139176,0.44666666,0.42139176,0.45,0.42139176,0.45333335,0.42139176,0.45666668,0.42139176,0.46,0.42139176,0.46333334,0.42139176,0.46666667,0.42139176,0.47,0.42139176,0.47333333,0.42139176,0.47666666,0.42139176,0.48,0.42139176,0.48333332,0.42139176,0.48666668,0.42139176,0.49,0.42139176,0.49333334,0.42139176,0.49666667,0.42139176,0.5,0.42139176,0.50333333,0.42139176,0.50666666,0.42139176,0.51,0.42139176,0.5133333,0.42139176,0.51666665,0.42139176,0.52,0.42139176,0.5233333,0.42139176,0.52666664,0.42139176,0.53,0.42139176,0.53333336,0.42139176,0.5366667,0.42139176,0.54,0.42139176,0.54333335,0.42139176,0.5466667,0.42139176,0.55,0.42139176,0.55333334,0.42139176,0.5566667,0.42139176,0.56,0.42139176,0.56333333,0.42139176,0.56666666,0.42139176,0.57,0.42139176,0.5733333,0.42139176,0.57666665,0.42139176,0.58,0.42139176,0.5833333,0.42139176,0.58666664,0.42139176,0.59,0.42139176,0.5933333,0.42139176,0.5966667,0.42139176,0.6,0.42139176,0.60333335,0.42139176,0.6066667,0.42139176,0.61,0.42139176,0.61333334,0.42139176,0.68333334,0.42139176,0.68666667,0.42139176,0.69,0.42139176,0.6933333,0.42139176,0.69666666,0.42139176,0.7,0.42139176,0.7033333,0.42139176,0.70666665,0.42139176,0.71,0.42139176,0.7133333,0.42139176,0.71666664,0.42139176,0.72,0.42139176,0.72333336,0.42139176,0.7266667,0.42139176,0.73,0.42139176,0.73333335,0.42139176,0.75,0.42139176,0.75333333,0.42139176,0.75666666,0.42139176,0.76,0.42139176,0.7633333,0.42139176,0.76666665,0.42139176,0.77,0.42139176,0.7733333,0.42139176,0.77666664,0.42139176,0.78,0.42139176,0.78333336,0.42139176,0.7866667,0.42139176,0.79,0.42139176,0.79333335,0.42139176,0.84,0.42139176,0.8433333,0.42139176,0.8466667,0.42139176,0.85,0.42139176,0.85333335,0.42139176,0.8566667,0.42139176,0.86,0.42139176,0.86333334,0.42139176,0.8666667,0.42139176,0.87,0.42139176,0.87333333,0.42139176,0.87666667,0.42139176,0.88,0.42139176,0.8833333,0.42139176,0.88666666,0.42139176,0.89,0.42139176,0.8933333,0.42139176,0.89666665,0.42139176,0.9,0.42139176,0.14333333,0.42396906,0.14666666,0.42396906,0.15,0.42396906,0.15333334,0.42396906,0.15666667,0.42396906,0.16,0.42396906,0.16333333,0.42396906,0.16666667,0.42396906,0.17,0.42396906,0.17333333,0.42396906,0.17666666,0.42396906,0.18,0.42396906,0.18333334,0.42396906,0.18666667,0.42396906,0.19,0.42396906,0.19333333,0.42396906,0.19666667,0.42396906,0.2,0.42396906,0.20333333,0.42396906,0.20666666,0.42396906,0.21,0.42396906,0.21333334,0.42396906,0.21666667,0.42396906,0.22,0.42396906,0.22333333,0.42396906,0.22666667,0.42396906,0.23,0.42396906,0.23333333,0.42396906,0.23666666,0.42396906,0.24,0.42396906,0.24333334,0.42396906,0.24666667,0.42396906,0.25,0.42396906,0.25333333,0.42396906,0.25666666,0.42396906,0.26,0.42396906,0.26333332,0.42396906,0.26666668,0.42396906,0.27,0.42396906,0.27333334,0.42396906,0.27666667,0.42396906,0.28,0.42396906,0.28333333,0.42396906,0.28666666,0.42396906,0.29,0.42396906,0.29333332,0.42396906,0.29666665,0.42396906,0.3,0.42396906,0.30333334,0.42396906,0.30666667,0.42396906,0.31,0.42396906,0.31333333,0.42396906,0.31666666,0.42396906,0.32,0.42396906,0.32333332,0.42396906,0.32666665,0.42396906,0.33,0.42396906,0.41666666,0.42396906,0.42,0.42396906,0.42333335,0.42396906,0.42666668,0.42396906,0.43,0.42396906,0.43333334,0.42396906,0.43666667,0.42396906,0.44,0.42396906,0.44333333,0.42396906,0.44666666,0.42396906,0.45,0.42396906,0.45333335,0.42396906,0.45666668,0.42396906,0.46,0.42396906,0.46333334,0.42396906,0.46666667,0.42396906,0.47,0.42396906,0.47333333,0.42396906,0.47666666,0.42396906,0.48,0.42396906,0.48333332,0.42396906,0.48666668,0.42396906,0.49,0.42396906,0.49333334,0.42396906,0.49666667,0.42396906,0.5,0.42396906,0.50333333,0.42396906,0.50666666,0.42396906,0.51,0.42396906,0.5133333,0.42396906,0.51666665,0.42396906,0.52,0.42396906,0.5233333,0.42396906,0.52666664,0.42396906,0.53,0.42396906,0.53333336,0.42396906,0.5366667,0.42396906,0.54,0.42396906,0.54333335,0.42396906,0.5466667,0.42396906,0.55,0.42396906,0.55333334,0.42396906,0.5566667,0.42396906,0.56,0.42396906,0.56333333,0.42396906,0.56666666,0.42396906,0.57,0.42396906,0.5733333,0.42396906,0.57666665,0.42396906,0.58,0.42396906,0.5833333,0.42396906,0.58666664,0.42396906,0.59,0.42396906,0.5933333,0.42396906,0.5966667,0.42396906,0.6,0.42396906,0.60333335,0.42396906,0.6066667,0.42396906,0.61,0.42396906,0.61333334,0.42396906,0.68,0.42396906,0.68333334,0.42396906,0.68666667,0.42396906,0.69,0.42396906,0.6933333,0.42396906,0.69666666,0.42396906,0.7,0.42396906,0.7033333,0.42396906,0.70666665,0.42396906,0.71,0.42396906,0.7133333,0.42396906,0.71666664,0.42396906,0.72,0.42396906,0.72333336,0.42396906,0.7266667,0.42396906,0.73,0.42396906,0.73333335,0.42396906,0.7366667,0.42396906,0.74,0.42396906,0.74333334,0.42396906,0.74666667,0.42396906,0.75,0.42396906,0.75333333,0.42396906,0.75666666,0.42396906,0.76,0.42396906,0.7633333,0.42396906,0.76666665,0.42396906,0.77,0.42396906,0.7733333,0.42396906,0.77666664,0.42396906,0.78,0.42396906,0.78333336,0.42396906,0.7866667,0.42396906,0.79,0.42396906,0.79333335,0.42396906,0.7966667,0.42396906,0.83666664,0.42396906,0.84,0.42396906,0.8433333,0.42396906,0.8466667,0.42396906,0.85,0.42396906,0.85333335,0.42396906,0.8566667,0.42396906,0.86,0.42396906,0.86333334,0.42396906,0.8666667,0.42396906,0.87,0.42396906,0.87333333,0.42396906,0.87666667,0.42396906,0.88,0.42396906,0.8833333,0.42396906,0.88666666,0.42396906,0.89,0.42396906,0.8933333,0.42396906,0.89666665,0.42396906,0.9,0.42396906,0.9033333,0.42396906,0.14666666,0.4265464,0.15,0.4265464,0.15333334,0.4265464,0.15666667,0.4265464,0.16,0.4265464,0.16333333,0.4265464,0.16666667,0.4265464,0.17,0.4265464,0.17333333,0.4265464,0.17666666,0.4265464,0.18,0.4265464,0.18333334,0.4265464,0.18666667,0.4265464,0.19,0.4265464,0.19333333,0.4265464,0.19666667,0.4265464,0.2,0.4265464,0.20333333,0.4265464,0.20666666,0.4265464,0.21,0.4265464,0.21333334,0.4265464,0.21666667,0.4265464,0.22,0.4265464,0.22333333,0.4265464,0.22666667,0.4265464,0.23,0.4265464,0.23333333,0.4265464,0.23666666,0.4265464,0.24,0.4265464,0.24333334,0.4265464,0.24666667,0.4265464,0.25,0.4265464,0.25333333,0.4265464,0.25666666,0.4265464,0.26,0.4265464,0.26333332,0.4265464,0.26666668,0.4265464,0.27,0.4265464,0.27333334,0.4265464,0.27666667,0.4265464,0.28,0.4265464,0.28333333,0.4265464,0.28666666,0.4265464,0.29,0.4265464,0.29333332,0.4265464,0.29666665,0.4265464,0.3,0.4265464,0.30333334,0.4265464,0.30666667,0.4265464,0.31,0.4265464,0.31333333,0.4265464,0.31666666,0.4265464,0.32,0.4265464,0.32333332,0.4265464,0.32666665,0.4265464,0.33,0.4265464,0.41666666,0.4265464,0.42,0.4265464,0.42333335,0.4265464,0.42666668,0.4265464,0.43,0.4265464,0.43333334,0.4265464,0.43666667,0.4265464,0.44,0.4265464,0.44333333,0.4265464,0.44666666,0.4265464,0.45,0.4265464,0.45333335,0.4265464,0.45666668,0.4265464,0.46,0.4265464,0.46333334,0.4265464,0.46666667,0.4265464,0.47,0.4265464,0.47333333,0.4265464,0.47666666,0.4265464,0.48,0.4265464,0.48333332,0.4265464,0.48666668,0.4265464,0.49,0.4265464,0.49333334,0.4265464,0.49666667,0.4265464,0.5,0.4265464,0.50333333,0.4265464,0.50666666,0.4265464,0.51,0.4265464,0.5133333,0.4265464,0.51666665,0.4265464,0.52,0.4265464,0.5233333,0.4265464,0.52666664,0.4265464,0.53,0.4265464,0.53333336,0.4265464,0.5366667,0.4265464,0.54,0.4265464,0.54333335,0.4265464,0.5466667,0.4265464,0.55,0.4265464,0.55333334,0.4265464,0.5566667,0.4265464,0.56,0.4265464,0.56333333,0.4265464,0.56666666,0.4265464,0.57,0.4265464,0.5733333,0.4265464,0.57666665,0.4265464,0.58,0.4265464,0.5833333,0.4265464,0.58666664,0.4265464,0.59,0.4265464,0.5933333,0.4265464,0.5966667,0.4265464,0.6,0.4265464,0.60333335,0.4265464,0.6066667,0.4265464,0.61,0.4265464,0.61333334,0.4265464,0.68,0.4265464,0.68333334,0.4265464,0.68666667,0.4265464,0.69,0.4265464,0.6933333,0.4265464,0.69666666,0.4265464,0.7,0.4265464,0.7033333,0.4265464,0.70666665,0.4265464,0.71,0.4265464,0.7133333,0.4265464,0.71666664,0.4265464,0.72,0.4265464,0.72333336,0.4265464,0.7266667,0.4265464,0.73,0.4265464,0.73333335,0.4265464,0.7366667,0.4265464,0.74,0.4265464,0.74333334,0.4265464,0.74666667,0.4265464,0.75,0.4265464,0.75333333,0.4265464,0.75666666,0.4265464,0.76,0.4265464,0.7633333,0.4265464,0.76666665,0.4265464,0.77,0.4265464,0.7733333,0.4265464,0.77666664,0.4265464,0.78,0.4265464,0.78333336,0.4265464,0.7866667,0.4265464,0.79,0.4265464,0.79333335,0.4265464,0.7966667,0.4265464,0.8,0.4265464,0.8333333,0.4265464,0.83666664,0.4265464,0.84,0.4265464,0.8433333,0.4265464,0.8466667,0.4265464,0.85,0.4265464,0.85333335,0.4265464,0.8566667,0.4265464,0.86,0.4265464,0.86333334,0.4265464,0.8666667,0.4265464,0.87,0.4265464,0.87333333,0.4265464,0.87666667,0.4265464,0.88,0.4265464,0.8833333,0.4265464,0.88666666,0.4265464,0.89,0.4265464,0.8933333,0.4265464,0.89666665,0.4265464,0.9,0.4265464,0.9033333,0.4265464,0.15,0.4291237,0.15333334,0.4291237,0.15666667,0.4291237,0.16,0.4291237,0.16333333,0.4291237,0.16666667,0.4291237,0.17,0.4291237,0.17333333,0.4291237,0.17666666,0.4291237,0.18,0.4291237,0.18333334,0.4291237,0.18666667,0.4291237,0.19,0.4291237,0.19333333,0.4291237,0.19666667,0.4291237,0.2,0.4291237,0.20333333,0.4291237,0.20666666,0.4291237,0.21,0.4291237,0.21333334,0.4291237,0.21666667,0.4291237,0.22,0.4291237,0.22333333,0.4291237,0.22666667,0.4291237,0.23,0.4291237,0.23333333,0.4291237,0.23666666,0.4291237,0.24,0.4291237,0.24333334,0.4291237,0.24666667,0.4291237,0.25,0.4291237,0.25333333,0.4291237,0.25666666,0.4291237,0.26,0.4291237,0.26333332,0.4291237,0.26666668,0.4291237,0.27,0.4291237,0.27333334,0.4291237,0.27666667,0.4291237,0.28,0.4291237,0.28333333,0.4291237,0.28666666,0.4291237,0.29,0.4291237,0.29333332,0.4291237,0.29666665,0.4291237,0.3,0.4291237,0.30333334,0.4291237,0.30666667,0.4291237,0.31,0.4291237,0.31333333,0.4291237,0.31666666,0.4291237,0.32,0.4291237,0.32333332,0.4291237,0.32666665,0.4291237,0.33,0.4291237,0.41666666,0.4291237,0.42,0.4291237,0.42333335,0.4291237,0.42666668,0.4291237,0.43,0.4291237,0.43333334,0.4291237,0.43666667,0.4291237,0.44,0.4291237,0.44333333,0.4291237,0.44666666,0.4291237,0.45,0.4291237,0.45333335,0.4291237,0.45666668,0.4291237,0.46,0.4291237,0.46333334,0.4291237,0.46666667,0.4291237,0.47,0.4291237,0.47333333,0.4291237,0.47666666,0.4291237,0.48,0.4291237,0.48333332,0.4291237,0.48666668,0.4291237,0.49,0.4291237,0.49333334,0.4291237,0.49666667,0.4291237,0.5,0.4291237,0.50333333,0.4291237,0.50666666,0.4291237,0.51,0.4291237,0.5133333,0.4291237,0.51666665,0.4291237,0.52,0.4291237,0.5233333,0.4291237,0.52666664,0.4291237,0.53,0.4291237,0.53333336,0.4291237,0.5366667,0.4291237,0.54,0.4291237,0.54333335,0.4291237,0.5466667,0.4291237,0.55,0.4291237,0.55333334,0.4291237,0.5566667,0.4291237,0.56,0.4291237,0.56333333,0.4291237,0.56666666,0.4291237,0.57,0.4291237,0.5733333,0.4291237,0.57666665,0.4291237,0.58,0.4291237,0.5833333,0.4291237,0.58666664,0.4291237,0.59,0.4291237,0.5933333,0.4291237,0.5966667,0.4291237,0.6,0.4291237,0.60333335,0.4291237,0.6066667,0.4291237,0.61,0.4291237,0.61333334,0.4291237,0.63,0.4291237,0.6333333,0.4291237,0.63666666,0.4291237,0.64,0.4291237,0.6766667,0.4291237,0.68,0.4291237,0.68333334,0.4291237,0.68666667,0.4291237,0.69,0.4291237,0.6933333,0.4291237,0.69666666,0.4291237,0.7,0.4291237,0.7033333,0.4291237,0.70666665,0.4291237,0.71,0.4291237,0.7133333,0.4291237,0.71666664,0.4291237,0.72,0.4291237,0.72333336,0.4291237,0.7266667,0.4291237,0.73,0.4291237,0.73333335,0.4291237,0.7366667,0.4291237,0.74,0.4291237,0.74333334,0.4291237,0.74666667,0.4291237,0.75,0.4291237,0.75333333,0.4291237,0.75666666,0.4291237,0.76,0.4291237,0.7633333,0.4291237,0.76666665,0.4291237,0.77,0.4291237,0.7733333,0.4291237,0.77666664,0.4291237,0.78,0.4291237,0.78333336,0.4291237,0.7866667,0.4291237,0.79,0.4291237,0.79333335,0.4291237,0.7966667,0.4291237,0.8,0.4291237,0.80333334,0.4291237,0.82666665,0.4291237,0.83,0.4291237,0.8333333,0.4291237,0.83666664,0.4291237,0.84,0.4291237,0.8433333,0.4291237,0.8466667,0.4291237,0.85,0.4291237,0.85333335,0.4291237,0.8566667,0.4291237,0.86,0.4291237,0.86333334,0.4291237,0.8666667,0.4291237,0.87,0.4291237,0.87333333,0.4291237,0.87666667,0.4291237,0.88,0.4291237,0.8833333,0.4291237,0.88666666,0.4291237,0.89,0.4291237,0.8933333,0.4291237,0.89666665,0.4291237,0.9,0.4291237,0.9033333,0.4291237,0.9066667,0.4291237,0.15,0.43170103,0.15333334,0.43170103,0.15666667,0.43170103,0.16,0.43170103,0.16333333,0.43170103,0.16666667,0.43170103,0.17,0.43170103,0.18,0.43170103,0.18333334,0.43170103,0.18666667,0.43170103,0.19,0.43170103,0.19333333,0.43170103,0.19666667,0.43170103,0.2,0.43170103,0.20333333,0.43170103,0.20666666,0.43170103,0.21,0.43170103,0.21333334,0.43170103,0.21666667,0.43170103,0.22,0.43170103,0.22333333,0.43170103,0.22666667,0.43170103,0.23,0.43170103,0.23333333,0.43170103,0.23666666,0.43170103,0.24,0.43170103,0.24333334,0.43170103,0.24666667,0.43170103,0.25,0.43170103,0.25333333,0.43170103,0.25666666,0.43170103,0.26,0.43170103,0.26333332,0.43170103,0.26666668,0.43170103,0.27,0.43170103,0.27333334,0.43170103,0.27666667,0.43170103,0.28,0.43170103,0.28333333,0.43170103,0.28666666,0.43170103,0.29,0.43170103,0.29333332,0.43170103,0.29666665,0.43170103,0.3,0.43170103,0.30333334,0.43170103,0.30666667,0.43170103,0.31,0.43170103,0.31333333,0.43170103,0.31666666,0.43170103,0.32,0.43170103,0.32333332,0.43170103,0.32666665,0.43170103,0.36,0.43170103,0.36333334,0.43170103,0.36666667,0.43170103,0.41,0.43170103,0.41333333,0.43170103,0.41666666,0.43170103,0.42,0.43170103,0.42333335,0.43170103,0.42666668,0.43170103,0.43,0.43170103,0.43333334,0.43170103,0.43666667,0.43170103,0.44,0.43170103,0.44333333,0.43170103,0.44666666,0.43170103,0.45,0.43170103,0.45333335,0.43170103,0.45666668,0.43170103,0.46,0.43170103,0.46333334,0.43170103,0.46666667,0.43170103,0.47,0.43170103,0.47333333,0.43170103,0.47666666,0.43170103,0.48,0.43170103,0.48333332,0.43170103,0.48666668,0.43170103,0.49,0.43170103,0.49333334,0.43170103,0.49666667,0.43170103,0.5,0.43170103,0.50333333,0.43170103,0.50666666,0.43170103,0.51,0.43170103,0.5133333,0.43170103,0.51666665,0.43170103,0.52,0.43170103,0.5233333,0.43170103,0.52666664,0.43170103,0.53,0.43170103,0.53333336,0.43170103,0.5366667,0.43170103,0.54,0.43170103,0.54333335,0.43170103,0.5466667,0.43170103,0.55,0.43170103,0.55333334,0.43170103,0.5566667,0.43170103,0.56,0.43170103,0.56333333,0.43170103,0.56666666,0.43170103,0.57,0.43170103,0.5733333,0.43170103,0.57666665,0.43170103,0.58,0.43170103,0.5833333,0.43170103,0.58666664,0.43170103,0.59,0.43170103,0.5933333,0.43170103,0.5966667,0.43170103,0.6,0.43170103,0.60333335,0.43170103,0.6066667,0.43170103,0.61,0.43170103,0.62666667,0.43170103,0.63,0.43170103,0.6333333,0.43170103,0.63666666,0.43170103,0.64,0.43170103,0.6433333,0.43170103,0.64666665,0.43170103,0.65,0.43170103,0.6533333,0.43170103,0.6566667,0.43170103,0.66,0.43170103,0.66333336,0.43170103,0.6666667,0.43170103,0.67,0.43170103,0.67333335,0.43170103,0.6766667,0.43170103,0.68,0.43170103,0.68333334,0.43170103,0.68666667,0.43170103,0.69,0.43170103,0.6933333,0.43170103,0.69666666,0.43170103,0.7,0.43170103,0.7033333,0.43170103,0.70666665,0.43170103,0.71,0.43170103,0.7133333,0.43170103,0.71666664,0.43170103,0.72,0.43170103,0.72333336,0.43170103,0.7266667,0.43170103,0.73,0.43170103,0.73333335,0.43170103,0.7366667,0.43170103,0.74,0.43170103,0.74333334,0.43170103,0.74666667,0.43170103,0.75,0.43170103,0.75333333,0.43170103,0.75666666,0.43170103,0.76,0.43170103,0.7633333,0.43170103,0.76666665,0.43170103,0.77,0.43170103,0.7733333,0.43170103,0.77666664,0.43170103,0.78,0.43170103,0.78333336,0.43170103,0.7866667,0.43170103,0.79,0.43170103,0.79333335,0.43170103,0.7966667,0.43170103,0.8,0.43170103,0.80333334,0.43170103,0.8066667,0.43170103,0.82,0.43170103,0.8233333,0.43170103,0.82666665,0.43170103,0.83,0.43170103,0.8333333,0.43170103,0.83666664,0.43170103,0.84,0.43170103,0.8433333,0.43170103,0.8466667,0.43170103,0.85,0.43170103,0.85333335,0.43170103,0.8566667,0.43170103,0.86,0.43170103,0.86333334,0.43170103,0.8666667,0.43170103,0.87,0.43170103,0.87333333,0.43170103,0.87666667,0.43170103,0.88,0.43170103,0.8833333,0.43170103,0.88666666,0.43170103,0.89,0.43170103,0.8933333,0.43170103,0.89666665,0.43170103,0.9,0.43170103,0.9033333,0.43170103,0.9066667,0.43170103,0.15,0.43427834,0.15333334,0.43427834,0.15666667,0.43427834,0.16,0.43427834,0.16333333,0.43427834,0.16666667,0.43427834,0.17,0.43427834,0.18333334,0.43427834,0.18666667,0.43427834,0.19,0.43427834,0.19333333,0.43427834,0.19666667,0.43427834,0.2,0.43427834,0.20333333,0.43427834,0.20666666,0.43427834,0.21,0.43427834,0.21333334,0.43427834,0.21666667,0.43427834,0.22,0.43427834,0.22333333,0.43427834,0.22666667,0.43427834,0.23,0.43427834,0.23333333,0.43427834,0.23666666,0.43427834,0.24,0.43427834,0.24333334,0.43427834,0.24666667,0.43427834,0.25,0.43427834,0.25333333,0.43427834,0.25666666,0.43427834,0.26,0.43427834,0.26333332,0.43427834,0.26666668,0.43427834,0.27,0.43427834,0.27333334,0.43427834,0.27666667,0.43427834,0.28,0.43427834,0.28333333,0.43427834,0.28666666,0.43427834,0.29,0.43427834,0.29333332,0.43427834,0.29666665,0.43427834,0.3,0.43427834,0.30333334,0.43427834,0.30666667,0.43427834,0.31,0.43427834,0.31333333,0.43427834,0.31666666,0.43427834,0.32,0.43427834,0.32333332,0.43427834,0.35,0.43427834,0.35333332,0.43427834,0.35666665,0.43427834,0.36,0.43427834,0.36333334,0.43427834,0.36666667,0.43427834,0.37,0.43427834,0.37333333,0.43427834,0.37666667,0.43427834,0.38,0.43427834,0.38333333,0.43427834,0.38666666,0.43427834,0.40666667,0.43427834,0.41,0.43427834,0.41333333,0.43427834,0.41666666,0.43427834,0.42,0.43427834,0.42333335,0.43427834,0.42666668,0.43427834,0.43,0.43427834,0.43333334,0.43427834,0.43666667,0.43427834,0.44,0.43427834,0.44333333,0.43427834,0.44666666,0.43427834,0.45,0.43427834,0.45333335,0.43427834,0.45666668,0.43427834,0.46,0.43427834,0.46333334,0.43427834,0.46666667,0.43427834,0.47,0.43427834,0.47333333,0.43427834,0.47666666,0.43427834,0.48,0.43427834,0.48333332,0.43427834,0.48666668,0.43427834,0.49,0.43427834,0.49333334,0.43427834,0.49666667,0.43427834,0.5,0.43427834,0.50333333,0.43427834,0.50666666,0.43427834,0.51,0.43427834,0.5133333,0.43427834,0.51666665,0.43427834,0.52,0.43427834,0.5233333,0.43427834,0.52666664,0.43427834,0.53,0.43427834,0.53333336,0.43427834,0.5366667,0.43427834,0.54,0.43427834,0.54333335,0.43427834,0.5466667,0.43427834,0.55,0.43427834,0.55333334,0.43427834,0.5566667,0.43427834,0.56,0.43427834,0.56333333,0.43427834,0.56666666,0.43427834,0.57,0.43427834,0.5733333,0.43427834,0.57666665,0.43427834,0.58,0.43427834,0.5833333,0.43427834,0.58666664,0.43427834,0.59,0.43427834,0.5933333,0.43427834,0.5966667,0.43427834,0.62666667,0.43427834,0.63,0.43427834,0.6333333,0.43427834,0.63666666,0.43427834,0.64,0.43427834,0.6433333,0.43427834,0.64666665,0.43427834,0.65,0.43427834,0.6533333,0.43427834,0.6566667,0.43427834,0.66,0.43427834,0.66333336,0.43427834,0.6666667,0.43427834,0.67,0.43427834,0.67333335,0.43427834,0.6766667,0.43427834,0.68,0.43427834,0.68333334,0.43427834,0.68666667,0.43427834,0.69,0.43427834,0.6933333,0.43427834,0.69666666,0.43427834,0.7,0.43427834,0.7033333,0.43427834,0.70666665,0.43427834,0.71,0.43427834,0.7133333,0.43427834,0.71666664,0.43427834,0.72,0.43427834,0.72333336,0.43427834,0.7266667,0.43427834,0.73,0.43427834,0.73333335,0.43427834,0.7366667,0.43427834,0.74,0.43427834,0.74333334,0.43427834,0.74666667,0.43427834,0.75,0.43427834,0.75333333,0.43427834,0.75666666,0.43427834,0.76,0.43427834,0.7633333,0.43427834,0.76666665,0.43427834,0.77,0.43427834,0.7733333,0.43427834,0.77666664,0.43427834,0.78,0.43427834,0.78333336,0.43427834,0.7866667,0.43427834,0.79,0.43427834,0.79333335,0.43427834,0.7966667,0.43427834,0.8,0.43427834,0.80333334,0.43427834,0.8066667,0.43427834,0.81,0.43427834,0.81333333,0.43427834,0.81666666,0.43427834,0.82,0.43427834,0.8233333,0.43427834,0.82666665,0.43427834,0.83,0.43427834,0.8333333,0.43427834,0.83666664,0.43427834,0.84,0.43427834,0.8433333,0.43427834,0.8466667,0.43427834,0.85,0.43427834,0.85333335,0.43427834,0.8566667,0.43427834,0.86,0.43427834,0.86333334,0.43427834,0.8666667,0.43427834,0.87,0.43427834,0.87333333,0.43427834,0.87666667,0.43427834,0.88,0.43427834,0.8833333,0.43427834,0.88666666,0.43427834,0.89,0.43427834,0.8933333,0.43427834,0.89666665,0.43427834,0.9,0.43427834,0.9033333,0.43427834,0.9066667,0.43427834,0.14666666,0.43685567,0.15,0.43685567,0.15333334,0.43685567,0.15666667,0.43685567,0.16,0.43685567,0.16333333,0.43685567,0.16666667,0.43685567,0.17,0.43685567,0.18333334,0.43685567,0.18666667,0.43685567,0.19,0.43685567,0.19333333,0.43685567,0.19666667,0.43685567,0.2,0.43685567,0.20333333,0.43685567,0.20666666,0.43685567,0.21,0.43685567,0.21333334,0.43685567,0.21666667,0.43685567,0.22,0.43685567,0.22333333,0.43685567,0.22666667,0.43685567,0.23333333,0.43685567,0.23666666,0.43685567,0.24,0.43685567,0.24333334,0.43685567,0.24666667,0.43685567,0.25,0.43685567,0.25333333,0.43685567,0.25666666,0.43685567,0.26,0.43685567,0.26333332,0.43685567,0.26666668,0.43685567,0.27,0.43685567,0.27333334,0.43685567,0.27666667,0.43685567,0.28,0.43685567,0.28333333,0.43685567,0.28666666,0.43685567,0.29,0.43685567,0.29333332,0.43685567,0.29666665,0.43685567,0.3,0.43685567,0.30333334,0.43685567,0.30666667,0.43685567,0.31,0.43685567,0.31333333,0.43685567,0.34666666,0.43685567,0.35,0.43685567,0.35333332,0.43685567,0.35666665,0.43685567,0.36,0.43685567,0.36333334,0.43685567,0.36666667,0.43685567,0.37,0.43685567,0.37333333,0.43685567,0.37666667,0.43685567,0.38,0.43685567,0.38333333,0.43685567,0.38666666,0.43685567,0.39,0.43685567,0.39333335,0.43685567,0.39666668,0.43685567,0.4,0.43685567,0.40333334,0.43685567,0.40666667,0.43685567,0.41,0.43685567,0.41333333,0.43685567,0.41666666,0.43685567,0.42,0.43685567,0.42333335,0.43685567,0.42666668,0.43685567,0.43,0.43685567,0.43333334,0.43685567,0.43666667,0.43685567,0.44,0.43685567,0.44333333,0.43685567,0.44666666,0.43685567,0.45,0.43685567,0.45333335,0.43685567,0.45666668,0.43685567,0.46,0.43685567,0.46333334,0.43685567,0.46666667,0.43685567,0.47,0.43685567,0.47333333,0.43685567,0.47666666,0.43685567,0.48,0.43685567,0.48333332,0.43685567,0.48666668,0.43685567,0.49,0.43685567,0.49333334,0.43685567,0.49666667,0.43685567,0.5,0.43685567,0.50333333,0.43685567,0.50666666,0.43685567,0.51,0.43685567,0.5133333,0.43685567,0.51666665,0.43685567,0.52,0.43685567,0.5233333,0.43685567,0.52666664,0.43685567,0.53,0.43685567,0.53333336,0.43685567,0.5366667,0.43685567,0.54,0.43685567,0.54333335,0.43685567,0.5466667,0.43685567,0.55,0.43685567,0.55333334,0.43685567,0.5566667,0.43685567,0.56,0.43685567,0.56333333,0.43685567,0.56666666,0.43685567,0.57,0.43685567,0.5733333,0.43685567,0.57666665,0.43685567,0.58,0.43685567,0.5833333,0.43685567,0.62666667,0.43685567,0.63,0.43685567,0.6333333,0.43685567,0.63666666,0.43685567,0.64,0.43685567,0.6433333,0.43685567,0.64666665,0.43685567,0.65,0.43685567,0.6533333,0.43685567,0.6566667,0.43685567,0.66,0.43685567,0.66333336,0.43685567,0.6666667,0.43685567,0.67,0.43685567,0.67333335,0.43685567,0.6766667,0.43685567,0.68,0.43685567,0.68333334,0.43685567,0.68666667,0.43685567,0.69,0.43685567,0.6933333,0.43685567,0.69666666,0.43685567,0.7,0.43685567,0.7033333,0.43685567,0.70666665,0.43685567,0.71,0.43685567,0.7133333,0.43685567,0.71666664,0.43685567,0.72,0.43685567,0.72333336,0.43685567,0.7266667,0.43685567,0.73,0.43685567,0.73333335,0.43685567,0.7366667,0.43685567,0.74,0.43685567,0.8,0.43685567,0.80333334,0.43685567,0.8066667,0.43685567,0.81,0.43685567,0.81333333,0.43685567,0.81666666,0.43685567,0.82,0.43685567,0.8233333,0.43685567,0.82666665,0.43685567,0.83,0.43685567,0.8333333,0.43685567,0.83666664,0.43685567,0.84,0.43685567,0.8433333,0.43685567,0.8466667,0.43685567,0.85,0.43685567,0.85333335,0.43685567,0.8566667,0.43685567,0.86,0.43685567,0.86333334,0.43685567,0.8666667,0.43685567,0.87,0.43685567,0.87333333,0.43685567,0.87666667,0.43685567,0.88,0.43685567,0.8833333,0.43685567,0.88666666,0.43685567,0.89,0.43685567,0.8933333,0.43685567,0.89666665,0.43685567,0.9,0.43685567,0.9033333,0.43685567,0.9066667,0.43685567,0.07,0.43943298,0.07333333,0.43943298,0.07666667,0.43943298,0.08,0.43943298,0.083333336,0.43943298,0.086666666,0.43943298,0.09,0.43943298,0.093333334,0.43943298,0.14,0.43943298,0.14333333,0.43943298,0.14666666,0.43943298,0.15,0.43943298,0.15333334,0.43943298,0.15666667,0.43943298,0.16,0.43943298,0.16333333,0.43943298,0.16666667,0.43943298,0.17,0.43943298,0.23333333,0.43943298,0.23666666,0.43943298,0.24,0.43943298,0.24333334,0.43943298,0.24666667,0.43943298,0.25,0.43943298,0.25333333,0.43943298,0.25666666,0.43943298,0.26,0.43943298,0.26333332,0.43943298,0.26666668,0.43943298,0.27,0.43943298,0.27333334,0.43943298,0.27666667,0.43943298,0.28,0.43943298,0.28333333,0.43943298,0.28666666,0.43943298,0.29,0.43943298,0.29333332,0.43943298,0.29666665,0.43943298,0.3,0.43943298,0.30333334,0.43943298,0.34333333,0.43943298,0.34666666,0.43943298,0.35,0.43943298,0.35333332,0.43943298,0.35666665,0.43943298,0.36,0.43943298,0.36333334,0.43943298,0.36666667,0.43943298,0.37,0.43943298,0.37333333,0.43943298,0.37666667,0.43943298,0.38,0.43943298,0.38333333,0.43943298,0.38666666,0.43943298,0.39,0.43943298,0.39333335,0.43943298,0.39666668,0.43943298,0.4,0.43943298,0.40333334,0.43943298,0.40666667,0.43943298,0.41,0.43943298,0.41333333,0.43943298,0.41666666,0.43943298,0.42,0.43943298,0.42333335,0.43943298,0.42666668,0.43943298,0.43,0.43943298,0.43333334,0.43943298,0.43666667,0.43943298,0.44,0.43943298,0.44333333,0.43943298,0.44666666,0.43943298,0.45333335,0.43943298,0.45666668,0.43943298,0.46,0.43943298,0.46333334,0.43943298,0.46666667,0.43943298,0.47,0.43943298,0.47333333,0.43943298,0.47666666,0.43943298,0.48,0.43943298,0.48333332,0.43943298,0.48666668,0.43943298,0.49,0.43943298,0.49333334,0.43943298,0.49666667,0.43943298,0.5,0.43943298,0.50333333,0.43943298,0.50666666,0.43943298,0.51,0.43943298,0.5133333,0.43943298,0.51666665,0.43943298,0.52,0.43943298,0.5233333,0.43943298,0.52666664,0.43943298,0.53,0.43943298,0.53333336,0.43943298,0.5366667,0.43943298,0.54,0.43943298,0.54333335,0.43943298,0.5466667,0.43943298,0.55,0.43943298,0.55333334,0.43943298,0.5566667,0.43943298,0.56,0.43943298,0.56333333,0.43943298,0.56666666,0.43943298,0.57,0.43943298,0.5733333,0.43943298,0.57666665,0.43943298,0.58,0.43943298,0.62666667,0.43943298,0.63,0.43943298,0.6333333,0.43943298,0.63666666,0.43943298,0.64,0.43943298,0.6433333,0.43943298,0.64666665,0.43943298,0.65,0.43943298,0.6533333,0.43943298,0.6566667,0.43943298,0.66,0.43943298,0.66333336,0.43943298,0.6666667,0.43943298,0.67,0.43943298,0.67333335,0.43943298,0.6766667,0.43943298,0.68,0.43943298,0.68333334,0.43943298,0.68666667,0.43943298,0.69,0.43943298,0.6933333,0.43943298,0.69666666,0.43943298,0.7,0.43943298,0.7033333,0.43943298,0.70666665,0.43943298,0.71,0.43943298,0.7133333,0.43943298,0.71666664,0.43943298,0.72,0.43943298,0.72333336,0.43943298,0.7266667,0.43943298,0.73,0.43943298,0.73333335,0.43943298,0.76666665,0.43943298,0.77,0.43943298,0.7733333,0.43943298,0.77666664,0.43943298,0.81,0.43943298,0.81333333,0.43943298,0.81666666,0.43943298,0.82,0.43943298,0.8233333,0.43943298,0.82666665,0.43943298,0.83,0.43943298,0.8333333,0.43943298,0.83666664,0.43943298,0.84,0.43943298,0.8433333,0.43943298,0.8466667,0.43943298,0.85,0.43943298,0.85333335,0.43943298,0.8566667,0.43943298,0.86,0.43943298,0.86333334,0.43943298,0.8666667,0.43943298,0.87,0.43943298,0.87333333,0.43943298,0.87666667,0.43943298,0.88,0.43943298,0.8833333,0.43943298,0.88666666,0.43943298,0.89,0.43943298,0.8933333,0.43943298,0.89666665,0.43943298,0.9,0.43943298,0.9033333,0.43943298,0.9066667,0.43943298,0.06666667,0.4420103,0.07,0.4420103,0.07333333,0.4420103,0.07666667,0.4420103,0.08,0.4420103,0.083333336,0.4420103,0.086666666,0.4420103,0.09,0.4420103,0.093333334,0.4420103,0.096666664,0.4420103,0.1,0.4420103,0.10333333,0.4420103,0.10666667,0.4420103,0.11,0.4420103,0.11333334,0.4420103,0.11666667,0.4420103,0.12,0.4420103,0.123333335,0.4420103,0.12666667,0.4420103,0.13,0.4420103,0.13333334,0.4420103,0.13666667,0.4420103,0.14,0.4420103,0.14333333,0.4420103,0.14666666,0.4420103,0.15,0.4420103,0.15333334,0.4420103,0.15666667,0.4420103,0.16,0.4420103,0.16333333,0.4420103,0.16666667,0.4420103,0.17,0.4420103,0.23333333,0.4420103,0.23666666,0.4420103,0.24,0.4420103,0.24333334,0.4420103,0.24666667,0.4420103,0.25,0.4420103,0.25333333,0.4420103,0.25666666,0.4420103,0.26,0.4420103,0.26333332,0.4420103,0.26666668,0.4420103,0.27,0.4420103,0.27333334,0.4420103,0.27666667,0.4420103,0.28,0.4420103,0.28333333,0.4420103,0.28666666,0.4420103,0.29,0.4420103,0.29333332,0.4420103,0.29666665,0.4420103,0.34,0.4420103,0.34333333,0.4420103,0.34666666,0.4420103,0.35,0.4420103,0.35333332,0.4420103,0.35666665,0.4420103,0.36,0.4420103,0.36333334,0.4420103,0.36666667,0.4420103,0.37,0.4420103,0.37333333,0.4420103,0.37666667,0.4420103,0.38,0.4420103,0.38333333,0.4420103,0.38666666,0.4420103,0.39,0.4420103,0.39333335,0.4420103,0.39666668,0.4420103,0.4,0.4420103,0.40333334,0.4420103,0.40666667,0.4420103,0.41,0.4420103,0.41333333,0.4420103,0.41666666,0.4420103,0.42,0.4420103,0.42333335,0.4420103,0.42666668,0.4420103,0.43,0.4420103,0.43333334,0.4420103,0.43666667,0.4420103,0.44,0.4420103,0.44333333,0.4420103,0.44666666,0.4420103,0.45666668,0.4420103,0.46,0.4420103,0.46333334,0.4420103,0.46666667,0.4420103,0.47,0.4420103,0.47333333,0.4420103,0.47666666,0.4420103,0.48,0.4420103,0.48333332,0.4420103,0.48666668,0.4420103,0.49,0.4420103,0.49333334,0.4420103,0.49666667,0.4420103,0.5,0.4420103,0.50333333,0.4420103,0.50666666,0.4420103,0.51,0.4420103,0.5133333,0.4420103,0.51666665,0.4420103,0.52,0.4420103,0.5233333,0.4420103,0.52666664,0.4420103,0.53,0.4420103,0.53333336,0.4420103,0.5366667,0.4420103,0.54,0.4420103,0.54333335,0.4420103,0.5466667,0.4420103,0.55,0.4420103,0.55333334,0.4420103,0.5566667,0.4420103,0.56,0.4420103,0.56333333,0.4420103,0.56666666,0.4420103,0.57,0.4420103,0.5733333,0.4420103,0.57666665,0.4420103,0.58,0.4420103,0.62666667,0.4420103,0.63,0.4420103,0.6333333,0.4420103,0.63666666,0.4420103,0.64,0.4420103,0.6433333,0.4420103,0.64666665,0.4420103,0.65,0.4420103,0.6533333,0.4420103,0.6566667,0.4420103,0.66,0.4420103,0.66333336,0.4420103,0.6666667,0.4420103,0.67,0.4420103,0.67333335,0.4420103,0.6766667,0.4420103,0.68,0.4420103,0.68333334,0.4420103,0.68666667,0.4420103,0.69,0.4420103,0.6933333,0.4420103,0.69666666,0.4420103,0.7,0.4420103,0.7033333,0.4420103,0.70666665,0.4420103,0.71,0.4420103,0.7133333,0.4420103,0.71666664,0.4420103,0.72,0.4420103,0.72333336,0.4420103,0.7266667,0.4420103,0.76,0.4420103,0.7633333,0.4420103,0.76666665,0.4420103,0.77,0.4420103,0.7733333,0.4420103,0.77666664,0.4420103,0.78,0.4420103,0.79,0.4420103,0.81666666,0.4420103,0.82,0.4420103,0.8233333,0.4420103,0.82666665,0.4420103,0.83,0.4420103,0.8333333,0.4420103,0.83666664,0.4420103,0.84,0.4420103,0.8433333,0.4420103,0.8466667,0.4420103,0.85,0.4420103,0.85333335,0.4420103,0.8566667,0.4420103,0.86,0.4420103,0.86333334,0.4420103,0.8666667,0.4420103,0.87,0.4420103,0.87333333,0.4420103,0.87666667,0.4420103,0.88,0.4420103,0.8833333,0.4420103,0.88666666,0.4420103,0.89,0.4420103,0.8933333,0.4420103,0.89666665,0.4420103,0.9,0.4420103,0.9033333,0.4420103,0.9066667,0.4420103,0.06333333,0.44458762,0.06666667,0.44458762,0.07,0.44458762,0.07333333,0.44458762,0.07666667,0.44458762,0.08,0.44458762,0.083333336,0.44458762,0.086666666,0.44458762,0.09,0.44458762,0.093333334,0.44458762,0.096666664,0.44458762,0.1,0.44458762,0.10333333,0.44458762,0.10666667,0.44458762,0.11,0.44458762,0.11333334,0.44458762,0.11666667,0.44458762,0.12,0.44458762,0.123333335,0.44458762,0.12666667,0.44458762,0.13,0.44458762,0.13333334,0.44458762,0.13666667,0.44458762,0.14,0.44458762,0.14333333,0.44458762,0.14666666,0.44458762,0.15,0.44458762,0.15333334,0.44458762,0.15666667,0.44458762,0.16,0.44458762,0.16333333,0.44458762,0.16666667,0.44458762,0.17,0.44458762,0.23333333,0.44458762,0.23666666,0.44458762,0.24,0.44458762,0.24333334,0.44458762,0.24666667,0.44458762,0.25,0.44458762,0.25333333,0.44458762,0.25666666,0.44458762,0.26,0.44458762,0.26333332,0.44458762,0.26666668,0.44458762,0.27,0.44458762,0.27333334,0.44458762,0.27666667,0.44458762,0.28,0.44458762,0.28333333,0.44458762,0.28666666,0.44458762,0.29,0.44458762,0.29333332,0.44458762,0.34,0.44458762,0.34333333,0.44458762,0.34666666,0.44458762,0.35,0.44458762,0.35333332,0.44458762,0.35666665,0.44458762,0.36,0.44458762,0.36333334,0.44458762,0.36666667,0.44458762,0.37,0.44458762,0.37333333,0.44458762,0.37666667,0.44458762,0.38,0.44458762,0.38333333,0.44458762,0.38666666,0.44458762,0.39,0.44458762,0.39333335,0.44458762,0.39666668,0.44458762,0.4,0.44458762,0.40333334,0.44458762,0.40666667,0.44458762,0.41,0.44458762,0.41333333,0.44458762,0.41666666,0.44458762,0.42,0.44458762,0.42333335,0.44458762,0.42666668,0.44458762,0.43,0.44458762,0.43333334,0.44458762,0.43666667,0.44458762,0.44,0.44458762,0.44333333,0.44458762,0.44666666,0.44458762,0.45333335,0.44458762,0.45666668,0.44458762,0.46,0.44458762,0.46333334,0.44458762,0.46666667,0.44458762,0.47,0.44458762,0.47333333,0.44458762,0.47666666,0.44458762,0.48,0.44458762,0.48333332,0.44458762,0.48666668,0.44458762,0.49,0.44458762,0.49333334,0.44458762,0.49666667,0.44458762,0.5,0.44458762,0.50333333,0.44458762,0.50666666,0.44458762,0.51,0.44458762,0.5133333,0.44458762,0.51666665,0.44458762,0.52,0.44458762,0.5233333,0.44458762,0.52666664,0.44458762,0.53,0.44458762,0.53333336,0.44458762,0.5366667,0.44458762,0.54,0.44458762,0.54333335,0.44458762,0.5466667,0.44458762,0.55,0.44458762,0.55333334,0.44458762,0.5566667,0.44458762,0.56,0.44458762,0.56333333,0.44458762,0.56666666,0.44458762,0.57,0.44458762,0.5733333,0.44458762,0.57666665,0.44458762,0.62666667,0.44458762,0.63,0.44458762,0.6333333,0.44458762,0.63666666,0.44458762,0.64,0.44458762,0.6433333,0.44458762,0.64666665,0.44458762,0.65,0.44458762,0.6533333,0.44458762,0.6566667,0.44458762,0.66,0.44458762,0.66333336,0.44458762,0.6666667,0.44458762,0.67,0.44458762,0.67333335,0.44458762,0.6766667,0.44458762,0.68,0.44458762,0.68333334,0.44458762,0.68666667,0.44458762,0.69,0.44458762,0.6933333,0.44458762,0.69666666,0.44458762,0.7,0.44458762,0.7033333,0.44458762,0.70666665,0.44458762,0.71,0.44458762,0.7133333,0.44458762,0.71666664,0.44458762,0.72,0.44458762,0.72333336,0.44458762,0.7633333,0.44458762,0.76666665,0.44458762,0.77,0.44458762,0.7733333,0.44458762,0.77666664,0.44458762,0.78,0.44458762,0.78333336,0.44458762,0.7866667,0.44458762,0.79,0.44458762,0.79333335,0.44458762,0.7966667,0.44458762,0.8233333,0.44458762,0.82666665,0.44458762,0.83,0.44458762,0.8333333,0.44458762,0.83666664,0.44458762,0.84,0.44458762,0.8433333,0.44458762,0.8466667,0.44458762,0.85,0.44458762,0.85333335,0.44458762,0.8566667,0.44458762,0.86,0.44458762,0.86333334,0.44458762,0.8666667,0.44458762,0.87,0.44458762,0.87333333,0.44458762,0.87666667,0.44458762,0.88,0.44458762,0.8833333,0.44458762,0.88666666,0.44458762,0.89,0.44458762,0.8933333,0.44458762,0.89666665,0.44458762,0.9,0.44458762,0.06,0.44716495,0.06333333,0.44716495,0.06666667,0.44716495,0.07,0.44716495,0.07333333,0.44716495,0.07666667,0.44716495,0.08,0.44716495,0.083333336,0.44716495,0.086666666,0.44716495,0.09,0.44716495,0.093333334,0.44716495,0.096666664,0.44716495,0.1,0.44716495,0.10333333,0.44716495,0.10666667,0.44716495,0.11,0.44716495,0.11333334,0.44716495,0.11666667,0.44716495,0.12,0.44716495,0.123333335,0.44716495,0.12666667,0.44716495,0.13,0.44716495,0.13333334,0.44716495,0.13666667,0.44716495,0.14,0.44716495,0.14333333,0.44716495,0.14666666,0.44716495,0.15,0.44716495,0.15333334,0.44716495,0.15666667,0.44716495,0.16,0.44716495,0.16333333,0.44716495,0.16666667,0.44716495,0.17,0.44716495,0.23333333,0.44716495,0.23666666,0.44716495,0.24,0.44716495,0.24333334,0.44716495,0.24666667,0.44716495,0.25,0.44716495,0.25333333,0.44716495,0.25666666,0.44716495,0.26,0.44716495,0.26333332,0.44716495,0.26666668,0.44716495,0.27,0.44716495,0.27333334,0.44716495,0.27666667,0.44716495,0.28,0.44716495,0.28333333,0.44716495,0.28666666,0.44716495,0.29,0.44716495,0.29333332,0.44716495,0.34,0.44716495,0.34333333,0.44716495,0.34666666,0.44716495,0.35,0.44716495,0.35333332,0.44716495,0.35666665,0.44716495,0.36,0.44716495,0.36333334,0.44716495,0.36666667,0.44716495,0.37,0.44716495,0.37333333,0.44716495,0.37666667,0.44716495,0.38,0.44716495,0.38333333,0.44716495,0.38666666,0.44716495,0.39,0.44716495,0.39333335,0.44716495,0.39666668,0.44716495,0.4,0.44716495,0.40333334,0.44716495,0.40666667,0.44716495,0.41,0.44716495,0.41333333,0.44716495,0.41666666,0.44716495,0.42,0.44716495,0.42333335,0.44716495,0.42666668,0.44716495,0.43,0.44716495,0.43333334,0.44716495,0.43666667,0.44716495,0.44,0.44716495,0.44333333,0.44716495,0.44666666,0.44716495,0.45,0.44716495,0.45333335,0.44716495,0.45666668,0.44716495,0.46,0.44716495,0.46333334,0.44716495,0.46666667,0.44716495,0.47,0.44716495,0.47333333,0.44716495,0.47666666,0.44716495,0.48,0.44716495,0.48333332,0.44716495,0.48666668,0.44716495,0.49,0.44716495,0.49333334,0.44716495,0.49666667,0.44716495,0.5,0.44716495,0.50333333,0.44716495,0.50666666,0.44716495,0.51,0.44716495,0.5133333,0.44716495,0.51666665,0.44716495,0.52,0.44716495,0.5233333,0.44716495,0.52666664,0.44716495,0.53,0.44716495,0.53333336,0.44716495,0.5366667,0.44716495,0.54,0.44716495,0.54333335,0.44716495,0.5466667,0.44716495,0.55,0.44716495,0.55333334,0.44716495,0.5566667,0.44716495,0.56,0.44716495,0.56333333,0.44716495,0.56666666,0.44716495,0.57,0.44716495,0.5733333,0.44716495,0.57666665,0.44716495,0.58,0.44716495,0.62666667,0.44716495,0.63,0.44716495,0.6333333,0.44716495,0.63666666,0.44716495,0.64,0.44716495,0.6433333,0.44716495,0.64666665,0.44716495,0.65,0.44716495,0.6533333,0.44716495,0.6566667,0.44716495,0.66,0.44716495,0.66333336,0.44716495,0.6666667,0.44716495,0.67,0.44716495,0.67333335,0.44716495,0.6766667,0.44716495,0.68,0.44716495,0.68333334,0.44716495,0.68666667,0.44716495,0.69,0.44716495,0.6933333,0.44716495,0.69666666,0.44716495,0.7,0.44716495,0.7033333,0.44716495,0.70666665,0.44716495,0.71,0.44716495,0.7133333,0.44716495,0.71666664,0.44716495,0.72,0.44716495,0.7633333,0.44716495,0.76666665,0.44716495,0.77,0.44716495,0.7733333,0.44716495,0.77666664,0.44716495,0.78,0.44716495,0.78333336,0.44716495,0.7866667,0.44716495,0.79,0.44716495,0.79333335,0.44716495,0.7966667,0.44716495,0.82666665,0.44716495,0.83,0.44716495,0.8333333,0.44716495,0.83666664,0.44716495,0.84,0.44716495,0.8433333,0.44716495,0.8466667,0.44716495,0.85,0.44716495,0.85333335,0.44716495,0.8566667,0.44716495,0.86,0.44716495,0.86333334,0.44716495,0.8666667,0.44716495,0.87,0.44716495,0.87333333,0.44716495,0.87666667,0.44716495,0.88,0.44716495,0.8833333,0.44716495,0.88666666,0.44716495,0.89,0.44716495,0.8933333,0.44716495,0.06,0.44974226,0.06333333,0.44974226,0.06666667,0.44974226,0.07,0.44974226,0.07333333,0.44974226,0.07666667,0.44974226,0.08,0.44974226,0.083333336,0.44974226,0.086666666,0.44974226,0.09,0.44974226,0.093333334,0.44974226,0.096666664,0.44974226,0.1,0.44974226,0.10333333,0.44974226,0.10666667,0.44974226,0.11,0.44974226,0.11333334,0.44974226,0.11666667,0.44974226,0.12,0.44974226,0.123333335,0.44974226,0.12666667,0.44974226,0.13,0.44974226,0.13333334,0.44974226,0.13666667,0.44974226,0.14,0.44974226,0.14333333,0.44974226,0.14666666,0.44974226,0.15,0.44974226,0.15333334,0.44974226,0.15666667,0.44974226,0.16,0.44974226,0.16333333,0.44974226,0.16666667,0.44974226,0.17,0.44974226,0.23333333,0.44974226,0.23666666,0.44974226,0.24,0.44974226,0.24333334,0.44974226,0.24666667,0.44974226,0.25,0.44974226,0.25333333,0.44974226,0.25666666,0.44974226,0.26,0.44974226,0.26333332,0.44974226,0.26666668,0.44974226,0.27,0.44974226,0.27333334,0.44974226,0.27666667,0.44974226,0.28,0.44974226,0.28333333,0.44974226,0.28666666,0.44974226,0.29,0.44974226,0.34,0.44974226,0.34333333,0.44974226,0.34666666,0.44974226,0.35,0.44974226,0.35333332,0.44974226,0.35666665,0.44974226,0.36,0.44974226,0.36333334,0.44974226,0.36666667,0.44974226,0.37,0.44974226,0.37333333,0.44974226,0.37666667,0.44974226,0.38,0.44974226,0.38333333,0.44974226,0.38666666,0.44974226,0.39,0.44974226,0.39333335,0.44974226,0.39666668,0.44974226,0.4,0.44974226,0.40333334,0.44974226,0.40666667,0.44974226,0.41,0.44974226,0.41333333,0.44974226,0.41666666,0.44974226,0.42,0.44974226,0.42333335,0.44974226,0.42666668,0.44974226,0.43,0.44974226,0.43333334,0.44974226,0.43666667,0.44974226,0.44,0.44974226,0.44333333,0.44974226,0.44666666,0.44974226,0.45,0.44974226,0.45333335,0.44974226,0.45666668,0.44974226,0.46,0.44974226,0.46333334,0.44974226,0.46666667,0.44974226,0.47,0.44974226,0.47333333,0.44974226,0.47666666,0.44974226,0.48,0.44974226,0.48333332,0.44974226,0.48666668,0.44974226,0.49,0.44974226,0.49333334,0.44974226,0.49666667,0.44974226,0.5,0.44974226,0.50333333,0.44974226,0.50666666,0.44974226,0.51,0.44974226,0.5133333,0.44974226,0.51666665,0.44974226,0.52,0.44974226,0.5233333,0.44974226,0.52666664,0.44974226,0.53,0.44974226,0.53333336,0.44974226,0.5366667,0.44974226,0.54,0.44974226,0.54333335,0.44974226,0.5466667,0.44974226,0.55,0.44974226,0.55333334,0.44974226,0.5566667,0.44974226,0.56,0.44974226,0.56333333,0.44974226,0.56666666,0.44974226,0.57,0.44974226,0.5733333,0.44974226,0.57666665,0.44974226,0.58,0.44974226,0.5833333,0.44974226,0.58666664,0.44974226,0.59,0.44974226,0.5933333,0.44974226,0.63,0.44974226,0.6333333,0.44974226,0.63666666,0.44974226,0.64,0.44974226,0.6433333,0.44974226,0.64666665,0.44974226,0.65,0.44974226,0.6533333,0.44974226,0.6566667,0.44974226,0.66,0.44974226,0.66333336,0.44974226,0.6666667,0.44974226,0.67,0.44974226,0.67333335,0.44974226,0.6766667,0.44974226,0.68,0.44974226,0.68333334,0.44974226,0.68666667,0.44974226,0.69,0.44974226,0.6933333,0.44974226,0.69666666,0.44974226,0.7,0.44974226,0.7033333,0.44974226,0.70666665,0.44974226,0.71,0.44974226,0.7133333,0.44974226,0.71666664,0.44974226,0.7633333,0.44974226,0.76666665,0.44974226,0.77,0.44974226,0.7733333,0.44974226,0.77666664,0.44974226,0.78,0.44974226,0.78333336,0.44974226,0.7866667,0.44974226,0.79,0.44974226,0.79333335,0.44974226,0.7966667,0.44974226,0.83,0.44974226,0.8333333,0.44974226,0.83666664,0.44974226,0.84,0.44974226,0.8433333,0.44974226,0.8466667,0.44974226,0.85,0.44974226,0.85333335,0.44974226,0.8566667,0.44974226,0.86,0.44974226,0.86333334,0.44974226,0.8666667,0.44974226,0.87,0.44974226,0.06,0.4523196,0.06333333,0.4523196,0.06666667,0.4523196,0.07,0.4523196,0.07333333,0.4523196,0.07666667,0.4523196,0.08,0.4523196,0.083333336,0.4523196,0.086666666,0.4523196,0.09,0.4523196,0.093333334,0.4523196,0.096666664,0.4523196,0.1,0.4523196,0.10333333,0.4523196,0.10666667,0.4523196,0.11,0.4523196,0.11333334,0.4523196,0.11666667,0.4523196,0.12,0.4523196,0.123333335,0.4523196,0.12666667,0.4523196,0.13,0.4523196,0.13333334,0.4523196,0.13666667,0.4523196,0.14,0.4523196,0.14333333,0.4523196,0.14666666,0.4523196,0.15,0.4523196,0.15333334,0.4523196,0.15666667,0.4523196,0.16,0.4523196,0.16333333,0.4523196,0.16666667,0.4523196,0.23666666,0.4523196,0.24,0.4523196,0.24333334,0.4523196,0.24666667,0.4523196,0.25,0.4523196,0.25333333,0.4523196,0.25666666,0.4523196,0.26,0.4523196,0.26333332,0.4523196,0.26666668,0.4523196,0.27,0.4523196,0.27333334,0.4523196,0.27666667,0.4523196,0.28,0.4523196,0.28333333,0.4523196,0.28666666,0.4523196,0.29,0.4523196,0.34,0.4523196,0.34333333,0.4523196,0.34666666,0.4523196,0.35,0.4523196,0.35333332,0.4523196,0.35666665,0.4523196,0.36,0.4523196,0.36333334,0.4523196,0.36666667,0.4523196,0.37,0.4523196,0.37333333,0.4523196,0.37666667,0.4523196,0.38,0.4523196,0.38333333,0.4523196,0.38666666,0.4523196,0.39,0.4523196,0.39333335,0.4523196,0.39666668,0.4523196,0.4,0.4523196,0.40333334,0.4523196,0.40666667,0.4523196,0.41,0.4523196,0.41333333,0.4523196,0.41666666,0.4523196,0.42,0.4523196,0.42333335,0.4523196,0.42666668,0.4523196,0.43,0.4523196,0.43333334,0.4523196,0.43666667,0.4523196,0.44,0.4523196,0.44333333,0.4523196,0.44666666,0.4523196,0.45,0.4523196,0.45333335,0.4523196,0.45666668,0.4523196,0.46,0.4523196,0.46333334,0.4523196,0.46666667,0.4523196,0.47,0.4523196,0.47333333,0.4523196,0.47666666,0.4523196,0.48,0.4523196,0.48333332,0.4523196,0.48666668,0.4523196,0.49,0.4523196,0.49333334,0.4523196,0.49666667,0.4523196,0.5,0.4523196,0.50333333,0.4523196,0.50666666,0.4523196,0.51,0.4523196,0.5133333,0.4523196,0.51666665,0.4523196,0.52,0.4523196,0.5233333,0.4523196,0.52666664,0.4523196,0.53,0.4523196,0.53333336,0.4523196,0.5366667,0.4523196,0.54,0.4523196,0.54333335,0.4523196,0.5466667,0.4523196,0.55,0.4523196,0.55333334,0.4523196,0.5566667,0.4523196,0.56,0.4523196,0.56333333,0.4523196,0.56666666,0.4523196,0.57,0.4523196,0.5733333,0.4523196,0.57666665,0.4523196,0.58,0.4523196,0.5833333,0.4523196,0.58666664,0.4523196,0.59,0.4523196,0.5933333,0.4523196,0.5966667,0.4523196,0.6,0.4523196,0.63,0.4523196,0.6333333,0.4523196,0.63666666,0.4523196,0.64,0.4523196,0.6433333,0.4523196,0.64666665,0.4523196,0.65,0.4523196,0.6533333,0.4523196,0.6566667,0.4523196,0.66,0.4523196,0.66333336,0.4523196,0.6666667,0.4523196,0.67,0.4523196,0.67333335,0.4523196,0.6766667,0.4523196,0.68,0.4523196,0.68333334,0.4523196,0.68666667,0.4523196,0.69,0.4523196,0.6933333,0.4523196,0.69666666,0.4523196,0.7,0.4523196,0.7033333,0.4523196,0.70666665,0.4523196,0.71,0.4523196,0.7133333,0.4523196,0.7633333,0.4523196,0.76666665,0.4523196,0.77,0.4523196,0.7733333,0.4523196,0.77666664,0.4523196,0.78,0.4523196,0.78333336,0.4523196,0.7866667,0.4523196,0.79,0.4523196,0.79333335,0.4523196,0.7966667,0.4523196,0.8333333,0.4523196,0.83666664,0.4523196,0.84,0.4523196,0.8433333,0.4523196,0.8466667,0.4523196,0.85,0.4523196,0.85333335,0.4523196,0.8566667,0.4523196,0.86,0.4523196,0.86333334,0.4523196,0.06,0.4548969,0.06333333,0.4548969,0.06666667,0.4548969,0.07,0.4548969,0.07333333,0.4548969,0.07666667,0.4548969,0.08,0.4548969,0.083333336,0.4548969,0.086666666,0.4548969,0.09,0.4548969,0.093333334,0.4548969,0.096666664,0.4548969,0.1,0.4548969,0.10333333,0.4548969,0.10666667,0.4548969,0.11,0.4548969,0.11333334,0.4548969,0.11666667,0.4548969,0.12,0.4548969,0.123333335,0.4548969,0.12666667,0.4548969,0.13,0.4548969,0.13333334,0.4548969,0.13666667,0.4548969,0.14,0.4548969,0.14333333,0.4548969,0.14666666,0.4548969,0.15,0.4548969,0.15333334,0.4548969,0.15666667,0.4548969,0.16,0.4548969,0.16333333,0.4548969,0.16666667,0.4548969,0.20333333,0.4548969,0.21666667,0.4548969,0.24,0.4548969,0.24333334,0.4548969,0.24666667,0.4548969,0.25,0.4548969,0.25333333,0.4548969,0.25666666,0.4548969,0.26,0.4548969,0.26333332,0.4548969,0.26666668,0.4548969,0.27,0.4548969,0.27333334,0.4548969,0.27666667,0.4548969,0.28,0.4548969,0.28333333,0.4548969,0.28666666,0.4548969,0.29,0.4548969,0.34333333,0.4548969,0.34666666,0.4548969,0.35,0.4548969,0.35333332,0.4548969,0.35666665,0.4548969,0.36,0.4548969,0.36333334,0.4548969,0.36666667,0.4548969,0.37,0.4548969,0.37333333,0.4548969,0.37666667,0.4548969,0.38,0.4548969,0.38333333,0.4548969,0.38666666,0.4548969,0.39,0.4548969,0.39333335,0.4548969,0.39666668,0.4548969,0.4,0.4548969,0.40333334,0.4548969,0.40666667,0.4548969,0.41,0.4548969,0.41333333,0.4548969,0.41666666,0.4548969,0.42,0.4548969,0.42333335,0.4548969,0.42666668,0.4548969,0.43,0.4548969,0.43333334,0.4548969,0.43666667,0.4548969,0.44,0.4548969,0.44333333,0.4548969,0.44666666,0.4548969,0.45,0.4548969,0.45333335,0.4548969,0.45666668,0.4548969,0.46,0.4548969,0.46333334,0.4548969,0.46666667,0.4548969,0.47,0.4548969,0.47333333,0.4548969,0.47666666,0.4548969,0.48,0.4548969,0.48333332,0.4548969,0.48666668,0.4548969,0.49,0.4548969,0.49333334,0.4548969,0.49666667,0.4548969,0.5,0.4548969,0.50333333,0.4548969,0.50666666,0.4548969,0.51,0.4548969,0.5133333,0.4548969,0.51666665,0.4548969,0.52,0.4548969,0.5233333,0.4548969,0.52666664,0.4548969,0.53,0.4548969,0.53333336,0.4548969,0.5366667,0.4548969,0.54,0.4548969,0.54333335,0.4548969,0.5466667,0.4548969,0.55,0.4548969,0.55333334,0.4548969,0.5566667,0.4548969,0.56,0.4548969,0.56333333,0.4548969,0.56666666,0.4548969,0.57,0.4548969,0.5733333,0.4548969,0.57666665,0.4548969,0.58,0.4548969,0.5833333,0.4548969,0.58666664,0.4548969,0.59,0.4548969,0.5933333,0.4548969,0.5966667,0.4548969,0.6,0.4548969,0.60333335,0.4548969,0.6333333,0.4548969,0.63666666,0.4548969,0.64,0.4548969,0.6433333,0.4548969,0.64666665,0.4548969,0.65,0.4548969,0.6533333,0.4548969,0.6566667,0.4548969,0.66,0.4548969,0.66333336,0.4548969,0.6666667,0.4548969,0.67,0.4548969,0.67333335,0.4548969,0.6766667,0.4548969,0.68,0.4548969,0.68333334,0.4548969,0.68666667,0.4548969,0.69,0.4548969,0.6933333,0.4548969,0.69666666,0.4548969,0.7,0.4548969,0.7033333,0.4548969,0.70666665,0.4548969,0.71,0.4548969,0.7133333,0.4548969,0.76666665,0.4548969,0.77,0.4548969,0.7733333,0.4548969,0.77666664,0.4548969,0.78,0.4548969,0.78333336,0.4548969,0.7866667,0.4548969,0.79,0.4548969,0.79333335,0.4548969,0.7966667,0.4548969,0.83666664,0.4548969,0.84,0.4548969,0.8433333,0.4548969,0.8466667,0.4548969,0.85,0.4548969,0.85333335,0.4548969,0.8566667,0.4548969,0.86,0.4548969,0.86333334,0.4548969,0.05666667,0.45747423,0.06,0.45747423,0.06333333,0.45747423,0.06666667,0.45747423,0.07,0.45747423,0.07333333,0.45747423,0.07666667,0.45747423,0.08,0.45747423,0.083333336,0.45747423,0.086666666,0.45747423,0.09,0.45747423,0.093333334,0.45747423,0.096666664,0.45747423,0.1,0.45747423,0.10333333,0.45747423,0.10666667,0.45747423,0.11,0.45747423,0.11333334,0.45747423,0.11666667,0.45747423,0.12,0.45747423,0.123333335,0.45747423,0.12666667,0.45747423,0.13,0.45747423,0.13333334,0.45747423,0.13666667,0.45747423,0.14,0.45747423,0.14333333,0.45747423,0.14666666,0.45747423,0.15,0.45747423,0.15333334,0.45747423,0.15666667,0.45747423,0.16,0.45747423,0.17333333,0.45747423,0.17666666,0.45747423,0.18,0.45747423,0.18333334,0.45747423,0.18666667,0.45747423,0.19,0.45747423,0.19333333,0.45747423,0.19666667,0.45747423,0.2,0.45747423,0.20333333,0.45747423,0.20666666,0.45747423,0.21,0.45747423,0.21333334,0.45747423,0.21666667,0.45747423,0.22,0.45747423,0.22333333,0.45747423,0.22666667,0.45747423,0.23,0.45747423,0.23333333,0.45747423,0.23666666,0.45747423,0.24,0.45747423,0.24333334,0.45747423,0.24666667,0.45747423,0.25,0.45747423,0.25333333,0.45747423,0.25666666,0.45747423,0.26,0.45747423,0.26333332,0.45747423,0.26666668,0.45747423,0.27,0.45747423,0.27333334,0.45747423,0.27666667,0.45747423,0.28,0.45747423,0.28333333,0.45747423,0.28666666,0.45747423,0.29,0.45747423,0.29333332,0.45747423,0.36,0.45747423,0.36333334,0.45747423,0.36666667,0.45747423,0.37,0.45747423,0.37333333,0.45747423,0.37666667,0.45747423,0.38,0.45747423,0.38333333,0.45747423,0.38666666,0.45747423,0.39,0.45747423,0.39333335,0.45747423,0.39666668,0.45747423,0.4,0.45747423,0.40333334,0.45747423,0.40666667,0.45747423,0.41,0.45747423,0.41333333,0.45747423,0.41666666,0.45747423,0.42,0.45747423,0.42333335,0.45747423,0.42666668,0.45747423,0.43,0.45747423,0.43333334,0.45747423,0.43666667,0.45747423,0.44,0.45747423,0.44333333,0.45747423,0.44666666,0.45747423,0.45,0.45747423,0.45333335,0.45747423,0.45666668,0.45747423,0.46,0.45747423,0.46333334,0.45747423,0.46666667,0.45747423,0.47,0.45747423,0.47333333,0.45747423,0.47666666,0.45747423,0.48,0.45747423,0.48333332,0.45747423,0.48666668,0.45747423,0.49,0.45747423,0.49333334,0.45747423,0.49666667,0.45747423,0.5,0.45747423,0.50333333,0.45747423,0.50666666,0.45747423,0.51,0.45747423,0.5133333,0.45747423,0.51666665,0.45747423,0.52,0.45747423,0.5233333,0.45747423,0.52666664,0.45747423,0.53,0.45747423,0.53333336,0.45747423,0.5366667,0.45747423,0.54,0.45747423,0.54333335,0.45747423,0.5466667,0.45747423,0.55,0.45747423,0.55333334,0.45747423,0.5566667,0.45747423,0.56,0.45747423,0.56333333,0.45747423,0.56666666,0.45747423,0.57,0.45747423,0.5733333,0.45747423,0.57666665,0.45747423,0.58,0.45747423,0.5833333,0.45747423,0.58666664,0.45747423,0.59,0.45747423,0.5933333,0.45747423,0.5966667,0.45747423,0.6,0.45747423,0.60333335,0.45747423,0.63666666,0.45747423,0.64,0.45747423,0.6433333,0.45747423,0.64666665,0.45747423,0.65,0.45747423,0.6533333,0.45747423,0.6566667,0.45747423,0.66,0.45747423,0.66333336,0.45747423,0.6666667,0.45747423,0.67,0.45747423,0.67333335,0.45747423,0.6766667,0.45747423,0.68,0.45747423,0.68333334,0.45747423,0.68666667,0.45747423,0.69,0.45747423,0.6933333,0.45747423,0.69666666,0.45747423,0.7,0.45747423,0.7033333,0.45747423,0.70666665,0.45747423,0.71,0.45747423,0.7633333,0.45747423,0.76666665,0.45747423,0.77,0.45747423,0.7733333,0.45747423,0.77666664,0.45747423,0.78,0.45747423,0.78333336,0.45747423,0.7866667,0.45747423,0.79,0.45747423,0.79333335,0.45747423,0.84,0.45747423,0.8433333,0.45747423,0.8466667,0.45747423,0.85,0.45747423,0.85333335,0.45747423,0.8566667,0.45747423,0.86,0.45747423,0.86333334,0.45747423,0.06,0.46005154,0.06333333,0.46005154,0.06666667,0.46005154,0.07,0.46005154,0.07333333,0.46005154,0.07666667,0.46005154,0.08,0.46005154,0.083333336,0.46005154,0.086666666,0.46005154,0.09,0.46005154,0.093333334,0.46005154,0.096666664,0.46005154,0.1,0.46005154,0.10333333,0.46005154,0.10666667,0.46005154,0.11,0.46005154,0.11333334,0.46005154,0.11666667,0.46005154,0.12,0.46005154,0.123333335,0.46005154,0.12666667,0.46005154,0.13,0.46005154,0.13333334,0.46005154,0.13666667,0.46005154,0.14,0.46005154,0.14333333,0.46005154,0.14666666,0.46005154,0.15,0.46005154,0.15333334,0.46005154,0.15666667,0.46005154,0.16666667,0.46005154,0.17,0.46005154,0.17333333,0.46005154,0.17666666,0.46005154,0.18,0.46005154,0.18333334,0.46005154,0.18666667,0.46005154,0.19,0.46005154,0.19333333,0.46005154,0.19666667,0.46005154,0.2,0.46005154,0.20333333,0.46005154,0.20666666,0.46005154,0.21,0.46005154,0.21333334,0.46005154,0.21666667,0.46005154,0.22,0.46005154,0.22333333,0.46005154,0.22666667,0.46005154,0.23,0.46005154,0.23333333,0.46005154,0.23666666,0.46005154,0.24,0.46005154,0.24333334,0.46005154,0.24666667,0.46005154,0.25,0.46005154,0.25333333,0.46005154,0.25666666,0.46005154,0.26,0.46005154,0.26333332,0.46005154,0.26666668,0.46005154,0.27,0.46005154,0.27333334,0.46005154,0.27666667,0.46005154,0.28,0.46005154,0.28333333,0.46005154,0.28666666,0.46005154,0.29,0.46005154,0.29333332,0.46005154,0.29666665,0.46005154,0.3,0.46005154,0.30333334,0.46005154,0.37333333,0.46005154,0.37666667,0.46005154,0.38,0.46005154,0.38333333,0.46005154,0.38666666,0.46005154,0.39,0.46005154,0.39333335,0.46005154,0.39666668,0.46005154,0.4,0.46005154,0.40333334,0.46005154,0.40666667,0.46005154,0.41,0.46005154,0.41333333,0.46005154,0.41666666,0.46005154,0.42,0.46005154,0.42333335,0.46005154,0.42666668,0.46005154,0.43,0.46005154,0.43333334,0.46005154,0.43666667,0.46005154,0.44,0.46005154,0.44333333,0.46005154,0.44666666,0.46005154,0.45,0.46005154,0.45333335,0.46005154,0.45666668,0.46005154,0.46,0.46005154,0.46333334,0.46005154,0.46666667,0.46005154,0.47,0.46005154,0.47333333,0.46005154,0.47666666,0.46005154,0.48,0.46005154,0.48333332,0.46005154,0.48666668,0.46005154,0.49,0.46005154,0.49333334,0.46005154,0.49666667,0.46005154,0.5,0.46005154,0.50333333,0.46005154,0.50666666,0.46005154,0.51,0.46005154,0.5133333,0.46005154,0.51666665,0.46005154,0.52,0.46005154,0.5233333,0.46005154,0.52666664,0.46005154,0.53,0.46005154,0.53333336,0.46005154,0.5366667,0.46005154,0.54,0.46005154,0.54333335,0.46005154,0.5466667,0.46005154,0.55,0.46005154,0.55333334,0.46005154,0.5566667,0.46005154,0.56,0.46005154,0.56333333,0.46005154,0.56666666,0.46005154,0.57,0.46005154,0.5733333,0.46005154,0.57666665,0.46005154,0.58,0.46005154,0.5833333,0.46005154,0.58666664,0.46005154,0.59,0.46005154,0.5933333,0.46005154,0.5966667,0.46005154,0.6,0.46005154,0.60333335,0.46005154,0.68333334,0.46005154,0.68666667,0.46005154,0.69,0.46005154,0.6933333,0.46005154,0.69666666,0.46005154,0.7,0.46005154,0.7033333,0.46005154,0.70666665,0.46005154,0.7633333,0.46005154,0.76666665,0.46005154,0.77,0.46005154,0.7733333,0.46005154,0.77666664,0.46005154,0.78,0.46005154,0.78333336,0.46005154,0.7866667,0.46005154,0.79,0.46005154,0.79333335,0.46005154,0.83,0.46005154,0.8433333,0.46005154,0.8466667,0.46005154,0.85,0.46005154,0.85333335,0.46005154,0.8566667,0.46005154,0.86,0.46005154,0.86333334,0.46005154,0.06,0.46262887,0.06333333,0.46262887,0.06666667,0.46262887,0.07,0.46262887,0.07333333,0.46262887,0.07666667,0.46262887,0.08,0.46262887,0.083333336,0.46262887,0.086666666,0.46262887,0.09,0.46262887,0.093333334,0.46262887,0.096666664,0.46262887,0.1,0.46262887,0.10333333,0.46262887,0.10666667,0.46262887,0.11,0.46262887,0.11333334,0.46262887,0.11666667,0.46262887,0.12,0.46262887,0.123333335,0.46262887,0.12666667,0.46262887,0.13,0.46262887,0.13333334,0.46262887,0.13666667,0.46262887,0.14,0.46262887,0.14333333,0.46262887,0.14666666,0.46262887,0.15,0.46262887,0.16333333,0.46262887,0.16666667,0.46262887,0.17,0.46262887,0.17333333,0.46262887,0.17666666,0.46262887,0.18,0.46262887,0.18333334,0.46262887,0.18666667,0.46262887,0.19,0.46262887,0.19333333,0.46262887,0.19666667,0.46262887,0.2,0.46262887,0.20333333,0.46262887,0.20666666,0.46262887,0.21,0.46262887,0.21333334,0.46262887,0.21666667,0.46262887,0.22,0.46262887,0.22333333,0.46262887,0.22666667,0.46262887,0.23,0.46262887,0.23333333,0.46262887,0.23666666,0.46262887,0.24,0.46262887,0.24333334,0.46262887,0.24666667,0.46262887,0.25,0.46262887,0.25333333,0.46262887,0.25666666,0.46262887,0.26,0.46262887,0.26333332,0.46262887,0.26666668,0.46262887,0.27,0.46262887,0.27333334,0.46262887,0.27666667,0.46262887,0.28,0.46262887,0.28333333,0.46262887,0.28666666,0.46262887,0.29,0.46262887,0.29333332,0.46262887,0.29666665,0.46262887,0.3,0.46262887,0.30333334,0.46262887,0.30666667,0.46262887,0.31,0.46262887,0.31333333,0.46262887,0.31666666,0.46262887,0.32,0.46262887,0.38,0.46262887,0.38333333,0.46262887,0.38666666,0.46262887,0.39,0.46262887,0.39333335,0.46262887,0.39666668,0.46262887,0.4,0.46262887,0.40333334,0.46262887,0.40666667,0.46262887,0.41,0.46262887,0.41333333,0.46262887,0.41666666,0.46262887,0.42,0.46262887,0.42333335,0.46262887,0.42666668,0.46262887,0.43,0.46262887,0.43333334,0.46262887,0.43666667,0.46262887,0.44,0.46262887,0.44333333,0.46262887,0.44666666,0.46262887,0.45,0.46262887,0.45333335,0.46262887,0.45666668,0.46262887,0.46,0.46262887,0.46333334,0.46262887,0.46666667,0.46262887,0.47,0.46262887,0.47333333,0.46262887,0.47666666,0.46262887,0.48,0.46262887,0.48333332,0.46262887,0.48666668,0.46262887,0.49,0.46262887,0.49333334,0.46262887,0.49666667,0.46262887,0.5,0.46262887,0.50333333,0.46262887,0.50666666,0.46262887,0.51,0.46262887,0.5133333,0.46262887,0.51666665,0.46262887,0.52,0.46262887,0.5233333,0.46262887,0.52666664,0.46262887,0.53,0.46262887,0.53333336,0.46262887,0.5366667,0.46262887,0.54,0.46262887,0.54333335,0.46262887,0.5466667,0.46262887,0.55,0.46262887,0.55333334,0.46262887,0.5566667,0.46262887,0.56,0.46262887,0.56333333,0.46262887,0.56666666,0.46262887,0.57,0.46262887,0.5733333,0.46262887,0.57666665,0.46262887,0.58,0.46262887,0.5833333,0.46262887,0.58666664,0.46262887,0.59,0.46262887,0.5933333,0.46262887,0.5966667,0.46262887,0.6,0.46262887,0.60333335,0.46262887,0.68666667,0.46262887,0.69,0.46262887,0.6933333,0.46262887,0.69666666,0.46262887,0.7,0.46262887,0.7033333,0.46262887,0.70666665,0.46262887,0.76666665,0.46262887,0.77,0.46262887,0.7733333,0.46262887,0.77666664,0.46262887,0.78,0.46262887,0.78333336,0.46262887,0.7866667,0.46262887,0.79,0.46262887,0.79333335,0.46262887,0.83,0.46262887,0.8466667,0.46262887,0.85,0.46262887,0.85333335,0.46262887,0.8566667,0.46262887,0.86,0.46262887,0.86333334,0.46262887,0.8666667,0.46262887,0.06333333,0.46520618,0.06666667,0.46520618,0.07,0.46520618,0.07333333,0.46520618,0.07666667,0.46520618,0.08,0.46520618,0.083333336,0.46520618,0.086666666,0.46520618,0.09,0.46520618,0.093333334,0.46520618,0.096666664,0.46520618,0.1,0.46520618,0.10333333,0.46520618,0.10666667,0.46520618,0.11,0.46520618,0.11333334,0.46520618,0.11666667,0.46520618,0.12,0.46520618,0.123333335,0.46520618,0.12666667,0.46520618,0.13,0.46520618,0.13333334,0.46520618,0.13666667,0.46520618,0.14,0.46520618,0.14333333,0.46520618,0.16,0.46520618,0.16333333,0.46520618,0.16666667,0.46520618,0.17,0.46520618,0.17333333,0.46520618,0.17666666,0.46520618,0.18,0.46520618,0.18333334,0.46520618,0.18666667,0.46520618,0.19,0.46520618,0.19333333,0.46520618,0.19666667,0.46520618,0.2,0.46520618,0.20333333,0.46520618,0.20666666,0.46520618,0.21,0.46520618,0.21333334,0.46520618,0.21666667,0.46520618,0.22,0.46520618,0.22333333,0.46520618,0.22666667,0.46520618,0.23,0.46520618,0.23333333,0.46520618,0.23666666,0.46520618,0.24,0.46520618,0.24333334,0.46520618,0.24666667,0.46520618,0.25,0.46520618,0.25333333,0.46520618,0.25666666,0.46520618,0.26666668,0.46520618,0.27,0.46520618,0.27333334,0.46520618,0.27666667,0.46520618,0.28,0.46520618,0.28333333,0.46520618,0.28666666,0.46520618,0.29,0.46520618,0.29333332,0.46520618,0.29666665,0.46520618,0.3,0.46520618,0.30333334,0.46520618,0.30666667,0.46520618,0.31,0.46520618,0.31333333,0.46520618,0.31666666,0.46520618,0.32,0.46520618,0.32333332,0.46520618,0.32666665,0.46520618,0.38,0.46520618,0.38333333,0.46520618,0.38666666,0.46520618,0.39,0.46520618,0.39333335,0.46520618,0.39666668,0.46520618,0.4,0.46520618,0.40333334,0.46520618,0.40666667,0.46520618,0.41,0.46520618,0.41333333,0.46520618,0.41666666,0.46520618,0.42,0.46520618,0.42333335,0.46520618,0.42666668,0.46520618,0.43,0.46520618,0.43333334,0.46520618,0.43666667,0.46520618,0.44,0.46520618,0.44333333,0.46520618,0.44666666,0.46520618,0.45,0.46520618,0.45333335,0.46520618,0.45666668,0.46520618,0.46,0.46520618,0.46333334,0.46520618,0.46666667,0.46520618,0.47,0.46520618,0.47333333,0.46520618,0.47666666,0.46520618,0.48,0.46520618,0.48333332,0.46520618,0.48666668,0.46520618,0.49,0.46520618,0.49333334,0.46520618,0.49666667,0.46520618,0.5,0.46520618,0.50333333,0.46520618,0.50666666,0.46520618,0.51,0.46520618,0.5133333,0.46520618,0.51666665,0.46520618,0.52,0.46520618,0.5233333,0.46520618,0.52666664,0.46520618,0.53,0.46520618,0.53333336,0.46520618,0.5366667,0.46520618,0.54,0.46520618,0.54333335,0.46520618,0.5466667,0.46520618,0.55,0.46520618,0.55333334,0.46520618,0.5566667,0.46520618,0.56,0.46520618,0.56333333,0.46520618,0.56666666,0.46520618,0.57,0.46520618,0.5733333,0.46520618,0.57666665,0.46520618,0.58,0.46520618,0.5833333,0.46520618,0.58666664,0.46520618,0.59,0.46520618,0.5933333,0.46520618,0.5966667,0.46520618,0.6,0.46520618,0.68666667,0.46520618,0.69,0.46520618,0.6933333,0.46520618,0.69666666,0.46520618,0.7,0.46520618,0.7033333,0.46520618,0.77,0.46520618,0.7733333,0.46520618,0.78,0.46520618,0.78333336,0.46520618,0.7866667,0.46520618,0.79,0.46520618,0.79333335,0.46520618,0.83,0.46520618,0.8333333,0.46520618,0.83666664,0.46520618,0.8466667,0.46520618,0.85,0.46520618,0.85333335,0.46520618,0.8566667,0.46520618,0.86,0.46520618,0.86333334,0.46520618,0.8666667,0.46520618,0.87,0.46520618,0.08,0.4677835,0.083333336,0.4677835,0.10333333,0.4677835,0.10666667,0.4677835,0.11,0.4677835,0.11333334,0.4677835,0.11666667,0.4677835,0.12,0.4677835,0.123333335,0.4677835,0.12666667,0.4677835,0.13,0.4677835,0.13333334,0.4677835,0.13666667,0.4677835,0.14,0.4677835,0.15666667,0.4677835,0.16,0.4677835,0.16333333,0.4677835,0.16666667,0.4677835,0.17,0.4677835,0.17333333,0.4677835,0.17666666,0.4677835,0.18,0.4677835,0.18333334,0.4677835,0.18666667,0.4677835,0.19,0.4677835,0.19333333,0.4677835,0.19666667,0.4677835,0.2,0.4677835,0.20333333,0.4677835,0.20666666,0.4677835,0.21,0.4677835,0.21333334,0.4677835,0.21666667,0.4677835,0.22,0.4677835,0.22333333,0.4677835,0.22666667,0.4677835,0.23,0.4677835,0.23333333,0.4677835,0.23666666,0.4677835,0.24,0.4677835,0.24333334,0.4677835,0.24666667,0.4677835,0.25,0.4677835,0.25333333,0.4677835,0.25666666,0.4677835,0.26666668,0.4677835,0.27,0.4677835,0.27333334,0.4677835,0.27666667,0.4677835,0.28,0.4677835,0.28333333,0.4677835,0.28666666,0.4677835,0.29,0.4677835,0.29333332,0.4677835,0.29666665,0.4677835,0.3,0.4677835,0.30333334,0.4677835,0.30666667,0.4677835,0.31,0.4677835,0.31333333,0.4677835,0.31666666,0.4677835,0.32,0.4677835,0.32333332,0.4677835,0.32666665,0.4677835,0.33,0.4677835,0.33333334,0.4677835,0.38333333,0.4677835,0.38666666,0.4677835,0.39,0.4677835,0.39333335,0.4677835,0.39666668,0.4677835,0.4,0.4677835,0.40333334,0.4677835,0.40666667,0.4677835,0.41,0.4677835,0.41333333,0.4677835,0.41666666,0.4677835,0.42,0.4677835,0.42333335,0.4677835,0.42666668,0.4677835,0.43,0.4677835,0.43333334,0.4677835,0.43666667,0.4677835,0.44,0.4677835,0.44333333,0.4677835,0.44666666,0.4677835,0.45,0.4677835,0.45333335,0.4677835,0.45666668,0.4677835,0.46,0.4677835,0.46333334,0.4677835,0.46666667,0.4677835,0.47,0.4677835,0.47333333,0.4677835,0.47666666,0.4677835,0.48,0.4677835,0.48333332,0.4677835,0.48666668,0.4677835,0.49,0.4677835,0.49333334,0.4677835,0.49666667,0.4677835,0.5,0.4677835,0.50333333,0.4677835,0.50666666,0.4677835,0.51,0.4677835,0.5133333,0.4677835,0.51666665,0.4677835,0.52,0.4677835,0.5233333,0.4677835,0.52666664,0.4677835,0.53,0.4677835,0.53333336,0.4677835,0.5366667,0.4677835,0.54,0.4677835,0.54333335,0.4677835,0.5466667,0.4677835,0.55,0.4677835,0.55333334,0.4677835,0.5566667,0.4677835,0.56,0.4677835,0.56333333,0.4677835,0.56666666,0.4677835,0.57,0.4677835,0.5733333,0.4677835,0.57666665,0.4677835,0.58,0.4677835,0.5833333,0.4677835,0.58666664,0.4677835,0.59,0.4677835,0.5933333,0.4677835,0.68666667,0.4677835,0.69,0.4677835,0.6933333,0.4677835,0.69666666,0.4677835,0.7,0.4677835,0.7033333,0.4677835,0.78333336,0.4677835,0.83,0.4677835,0.8333333,0.4677835,0.83666664,0.4677835,0.85,0.4677835,0.85333335,0.4677835,0.8566667,0.4677835,0.86,0.4677835,0.86333334,0.4677835,0.8666667,0.4677835,0.87,0.4677835,0.87333333,0.4677835,0.87666667,0.4677835,0.11,0.47036082,0.11333334,0.47036082,0.11666667,0.47036082,0.12,0.47036082,0.123333335,0.47036082,0.12666667,0.47036082,0.13,0.47036082,0.13333334,0.47036082,0.13666667,0.47036082,0.15666667,0.47036082,0.16,0.47036082,0.16333333,0.47036082,0.16666667,0.47036082,0.17,0.47036082,0.17333333,0.47036082,0.17666666,0.47036082,0.18,0.47036082,0.18333334,0.47036082,0.18666667,0.47036082,0.19,0.47036082,0.19333333,0.47036082,0.19666667,0.47036082,0.2,0.47036082,0.20333333,0.47036082,0.20666666,0.47036082,0.21,0.47036082,0.21333334,0.47036082,0.21666667,0.47036082,0.22,0.47036082,0.22333333,0.47036082,0.22666667,0.47036082,0.23,0.47036082,0.23333333,0.47036082,0.23666666,0.47036082,0.24,0.47036082,0.24333334,0.47036082,0.24666667,0.47036082,0.25,0.47036082,0.25333333,0.47036082,0.25666666,0.47036082,0.26666668,0.47036082,0.27,0.47036082,0.27333334,0.47036082,0.27666667,0.47036082,0.28,0.47036082,0.28333333,0.47036082,0.28666666,0.47036082,0.29,0.47036082,0.29333332,0.47036082,0.29666665,0.47036082,0.3,0.47036082,0.30333334,0.47036082,0.30666667,0.47036082,0.31,0.47036082,0.31333333,0.47036082,0.31666666,0.47036082,0.32,0.47036082,0.32333332,0.47036082,0.32666665,0.47036082,0.33,0.47036082,0.33333334,0.47036082,0.33666667,0.47036082,0.38333333,0.47036082,0.38666666,0.47036082,0.39,0.47036082,0.39333335,0.47036082,0.39666668,0.47036082,0.4,0.47036082,0.40333334,0.47036082,0.40666667,0.47036082,0.41,0.47036082,0.41333333,0.47036082,0.41666666,0.47036082,0.42,0.47036082,0.42333335,0.47036082,0.42666668,0.47036082,0.43,0.47036082,0.43333334,0.47036082,0.43666667,0.47036082,0.44,0.47036082,0.44333333,0.47036082,0.44666666,0.47036082,0.45,0.47036082,0.45333335,0.47036082,0.45666668,0.47036082,0.46,0.47036082,0.46333334,0.47036082,0.46666667,0.47036082,0.47,0.47036082,0.47333333,0.47036082,0.47666666,0.47036082,0.48,0.47036082,0.48333332,0.47036082,0.48666668,0.47036082,0.49,0.47036082,0.49333334,0.47036082,0.49666667,0.47036082,0.5,0.47036082,0.50333333,0.47036082,0.50666666,0.47036082,0.51,0.47036082,0.5133333,0.47036082,0.51666665,0.47036082,0.52,0.47036082,0.5233333,0.47036082,0.52666664,0.47036082,0.53,0.47036082,0.53333336,0.47036082,0.5366667,0.47036082,0.54,0.47036082,0.54333335,0.47036082,0.5466667,0.47036082,0.55,0.47036082,0.55333334,0.47036082,0.5566667,0.47036082,0.56,0.47036082,0.56333333,0.47036082,0.56666666,0.47036082,0.57,0.47036082,0.5733333,0.47036082,0.57666665,0.47036082,0.58,0.47036082,0.5833333,0.47036082,0.58666664,0.47036082,0.59,0.47036082,0.68666667,0.47036082,0.69,0.47036082,0.6933333,0.47036082,0.69666666,0.47036082,0.7,0.47036082,0.73333335,0.47036082,0.78333336,0.47036082,0.7866667,0.47036082,0.79,0.47036082,0.7966667,0.47036082,0.81,0.47036082,0.8333333,0.47036082,0.83666664,0.47036082,0.85,0.47036082,0.85333335,0.47036082,0.8566667,0.47036082,0.86,0.47036082,0.86333334,0.47036082,0.8666667,0.47036082,0.87,0.47036082,0.87333333,0.47036082,0.87666667,0.47036082,0.88,0.47036082,0.8833333,0.47036082,0.88666666,0.47036082,0.89,0.47036082,0.8933333,0.47036082,0.11,0.47293815,0.11333334,0.47293815,0.11666667,0.47293815,0.12,0.47293815,0.123333335,0.47293815,0.12666667,0.47293815,0.13,0.47293815,0.13333334,0.47293815,0.13666667,0.47293815,0.15666667,0.47293815,0.16,0.47293815,0.16333333,0.47293815,0.16666667,0.47293815,0.17,0.47293815,0.17333333,0.47293815,0.17666666,0.47293815,0.18,0.47293815,0.18333334,0.47293815,0.18666667,0.47293815,0.19,0.47293815,0.19333333,0.47293815,0.19666667,0.47293815,0.2,0.47293815,0.20333333,0.47293815,0.20666666,0.47293815,0.21,0.47293815,0.21333334,0.47293815,0.21666667,0.47293815,0.22,0.47293815,0.22333333,0.47293815,0.22666667,0.47293815,0.23,0.47293815,0.23333333,0.47293815,0.23666666,0.47293815,0.24,0.47293815,0.24333334,0.47293815,0.24666667,0.47293815,0.25,0.47293815,0.25333333,0.47293815,0.25666666,0.47293815,0.26666668,0.47293815,0.27,0.47293815,0.27333334,0.47293815,0.27666667,0.47293815,0.28,0.47293815,0.28333333,0.47293815,0.28666666,0.47293815,0.29,0.47293815,0.29333332,0.47293815,0.29666665,0.47293815,0.3,0.47293815,0.30333334,0.47293815,0.30666667,0.47293815,0.31,0.47293815,0.31333333,0.47293815,0.31666666,0.47293815,0.32,0.47293815,0.32333332,0.47293815,0.32666665,0.47293815,0.33,0.47293815,0.33333334,0.47293815,0.33666667,0.47293815,0.38333333,0.47293815,0.38666666,0.47293815,0.39,0.47293815,0.39333335,0.47293815,0.39666668,0.47293815,0.4,0.47293815,0.40333334,0.47293815,0.40666667,0.47293815,0.41,0.47293815,0.41333333,0.47293815,0.41666666,0.47293815,0.42,0.47293815,0.42333335,0.47293815,0.42666668,0.47293815,0.43,0.47293815,0.43333334,0.47293815,0.43666667,0.47293815,0.44,0.47293815,0.44333333,0.47293815,0.44666666,0.47293815,0.45,0.47293815,0.45333335,0.47293815,0.45666668,0.47293815,0.46,0.47293815,0.46333334,0.47293815,0.46666667,0.47293815,0.47,0.47293815,0.47333333,0.47293815,0.47666666,0.47293815,0.48,0.47293815,0.48333332,0.47293815,0.48666668,0.47293815,0.49,0.47293815,0.49333334,0.47293815,0.49666667,0.47293815,0.5,0.47293815,0.50333333,0.47293815,0.50666666,0.47293815,0.51,0.47293815,0.5133333,0.47293815,0.51666665,0.47293815,0.52,0.47293815,0.5233333,0.47293815,0.52666664,0.47293815,0.53,0.47293815,0.53333336,0.47293815,0.5366667,0.47293815,0.54,0.47293815,0.54333335,0.47293815,0.5466667,0.47293815,0.55,0.47293815,0.55333334,0.47293815,0.5566667,0.47293815,0.56,0.47293815,0.56333333,0.47293815,0.56666666,0.47293815,0.57,0.47293815,0.5733333,0.47293815,0.57666665,0.47293815,0.58,0.47293815,0.5833333,0.47293815,0.58666664,0.47293815,0.68666667,0.47293815,0.69,0.47293815,0.6933333,0.47293815,0.69666666,0.47293815,0.7,0.47293815,0.71666664,0.47293815,0.72,0.47293815,0.72333336,0.47293815,0.7266667,0.47293815,0.73,0.47293815,0.73333335,0.47293815,0.7366667,0.47293815,0.78333336,0.47293815,0.7866667,0.47293815,0.79,0.47293815,0.79333335,0.47293815,0.7966667,0.47293815,0.80333334,0.47293815,0.8066667,0.47293815,0.81,0.47293815,0.81333333,0.47293815,0.85,0.47293815,0.85333335,0.47293815,0.8566667,0.47293815,0.86,0.47293815,0.86333334,0.47293815,0.8666667,0.47293815,0.87,0.47293815,0.87333333,0.47293815,0.87666667,0.47293815,0.88,0.47293815,0.8833333,0.47293815,0.88666666,0.47293815,0.89,0.47293815,0.8933333,0.47293815,0.89666665,0.47293815,0.9,0.47293815,0.9033333,0.47293815,0.9066667,0.47293815,0.11333334,0.47551546,0.11666667,0.47551546,0.12,0.47551546,0.123333335,0.47551546,0.12666667,0.47551546,0.13,0.47551546,0.13333334,0.47551546,0.13666667,0.47551546,0.15666667,0.47551546,0.16,0.47551546,0.16333333,0.47551546,0.16666667,0.47551546,0.17,0.47551546,0.17333333,0.47551546,0.17666666,0.47551546,0.18,0.47551546,0.18333334,0.47551546,0.18666667,0.47551546,0.19,0.47551546,0.19333333,0.47551546,0.19666667,0.47551546,0.2,0.47551546,0.20333333,0.47551546,0.20666666,0.47551546,0.21,0.47551546,0.21333334,0.47551546,0.21666667,0.47551546,0.22,0.47551546,0.22333333,0.47551546,0.22666667,0.47551546,0.23,0.47551546,0.23333333,0.47551546,0.23666666,0.47551546,0.24,0.47551546,0.24333334,0.47551546,0.24666667,0.47551546,0.25,0.47551546,0.25333333,0.47551546,0.26666668,0.47551546,0.27,0.47551546,0.27333334,0.47551546,0.27666667,0.47551546,0.28,0.47551546,0.28333333,0.47551546,0.28666666,0.47551546,0.29,0.47551546,0.29333332,0.47551546,0.29666665,0.47551546,0.3,0.47551546,0.30333334,0.47551546,0.30666667,0.47551546,0.31,0.47551546,0.31333333,0.47551546,0.31666666,0.47551546,0.32,0.47551546,0.32333332,0.47551546,0.32666665,0.47551546,0.33,0.47551546,0.33333334,0.47551546,0.33666667,0.47551546,0.34,0.47551546,0.38333333,0.47551546,0.38666666,0.47551546,0.39,0.47551546,0.39333335,0.47551546,0.39666668,0.47551546,0.4,0.47551546,0.40333334,0.47551546,0.40666667,0.47551546,0.41,0.47551546,0.41333333,0.47551546,0.41666666,0.47551546,0.42,0.47551546,0.42333335,0.47551546,0.42666668,0.47551546,0.43,0.47551546,0.43333334,0.47551546,0.43666667,0.47551546,0.44,0.47551546,0.44333333,0.47551546,0.44666666,0.47551546,0.45,0.47551546,0.45333335,0.47551546,0.45666668,0.47551546,0.46,0.47551546,0.46333334,0.47551546,0.46666667,0.47551546,0.47,0.47551546,0.47333333,0.47551546,0.47666666,0.47551546,0.48,0.47551546,0.48333332,0.47551546,0.48666668,0.47551546,0.49,0.47551546,0.49333334,0.47551546,0.49666667,0.47551546,0.5,0.47551546,0.50333333,0.47551546,0.50666666,0.47551546,0.51,0.47551546,0.5133333,0.47551546,0.51666665,0.47551546,0.52,0.47551546,0.5233333,0.47551546,0.52666664,0.47551546,0.53,0.47551546,0.53333336,0.47551546,0.5366667,0.47551546,0.54,0.47551546,0.54333335,0.47551546,0.5466667,0.47551546,0.55,0.47551546,0.55333334,0.47551546,0.5566667,0.47551546,0.56,0.47551546,0.56333333,0.47551546,0.56666666,0.47551546,0.57,0.47551546,0.5733333,0.47551546,0.57666665,0.47551546,0.58,0.47551546,0.5833333,0.47551546,0.58666664,0.47551546,0.68333334,0.47551546,0.68666667,0.47551546,0.69,0.47551546,0.6933333,0.47551546,0.69666666,0.47551546,0.7,0.47551546,0.7133333,0.47551546,0.71666664,0.47551546,0.72,0.47551546,0.72333336,0.47551546,0.78333336,0.47551546,0.7866667,0.47551546,0.79,0.47551546,0.79333335,0.47551546,0.7966667,0.47551546,0.8,0.47551546,0.80333334,0.47551546,0.8066667,0.47551546,0.81,0.47551546,0.81333333,0.47551546,0.85,0.47551546,0.85333335,0.47551546,0.8566667,0.47551546,0.86,0.47551546,0.86333334,0.47551546,0.8666667,0.47551546,0.87,0.47551546,0.87333333,0.47551546,0.87666667,0.47551546,0.88,0.47551546,0.8833333,0.47551546,0.88666666,0.47551546,0.89,0.47551546,0.8933333,0.47551546,0.89666665,0.47551546,0.9,0.47551546,0.9033333,0.47551546,0.9066667,0.47551546,0.91,0.47551546,0.91333336,0.47551546,0.11,0.4780928,0.11333334,0.4780928,0.11666667,0.4780928,0.12,0.4780928,0.123333335,0.4780928,0.12666667,0.4780928,0.13,0.4780928,0.13333334,0.4780928,0.13666667,0.4780928,0.15666667,0.4780928,0.16,0.4780928,0.16333333,0.4780928,0.16666667,0.4780928,0.17,0.4780928,0.17333333,0.4780928,0.17666666,0.4780928,0.18,0.4780928,0.18333334,0.4780928,0.18666667,0.4780928,0.19,0.4780928,0.19333333,0.4780928,0.19666667,0.4780928,0.2,0.4780928,0.20333333,0.4780928,0.20666666,0.4780928,0.21,0.4780928,0.21333334,0.4780928,0.21666667,0.4780928,0.22,0.4780928,0.22333333,0.4780928,0.22666667,0.4780928,0.23,0.4780928,0.23333333,0.4780928,0.23666666,0.4780928,0.24,0.4780928,0.24333334,0.4780928,0.24666667,0.4780928,0.25,0.4780928,0.26666668,0.4780928,0.27,0.4780928,0.27333334,0.4780928,0.27666667,0.4780928,0.28,0.4780928,0.28333333,0.4780928,0.28666666,0.4780928,0.29,0.4780928,0.29333332,0.4780928,0.29666665,0.4780928,0.3,0.4780928,0.30333334,0.4780928,0.30666667,0.4780928,0.31,0.4780928,0.31333333,0.4780928,0.31666666,0.4780928,0.32,0.4780928,0.32333332,0.4780928,0.32666665,0.4780928,0.33,0.4780928,0.33333334,0.4780928,0.33666667,0.4780928,0.34,0.4780928,0.38,0.4780928,0.38333333,0.4780928,0.38666666,0.4780928,0.39,0.4780928,0.39333335,0.4780928,0.39666668,0.4780928,0.4,0.4780928,0.40333334,0.4780928,0.40666667,0.4780928,0.41,0.4780928,0.41333333,0.4780928,0.41666666,0.4780928,0.42,0.4780928,0.42333335,0.4780928,0.42666668,0.4780928,0.43,0.4780928,0.43333334,0.4780928,0.43666667,0.4780928,0.44,0.4780928,0.44333333,0.4780928,0.44666666,0.4780928,0.45,0.4780928,0.45333335,0.4780928,0.45666668,0.4780928,0.46,0.4780928,0.46333334,0.4780928,0.46666667,0.4780928,0.47,0.4780928,0.47333333,0.4780928,0.47666666,0.4780928,0.48,0.4780928,0.48333332,0.4780928,0.48666668,0.4780928,0.49,0.4780928,0.49333334,0.4780928,0.49666667,0.4780928,0.5,0.4780928,0.50333333,0.4780928,0.50666666,0.4780928,0.51,0.4780928,0.5133333,0.4780928,0.51666665,0.4780928,0.52,0.4780928,0.5233333,0.4780928,0.52666664,0.4780928,0.53,0.4780928,0.53333336,0.4780928,0.5366667,0.4780928,0.54,0.4780928,0.54333335,0.4780928,0.5466667,0.4780928,0.55,0.4780928,0.55333334,0.4780928,0.5566667,0.4780928,0.56,0.4780928,0.56333333,0.4780928,0.56666666,0.4780928,0.57,0.4780928,0.5733333,0.4780928,0.57666665,0.4780928,0.58,0.4780928,0.5833333,0.4780928,0.58666664,0.4780928,0.59,0.4780928,0.68,0.4780928,0.68333334,0.4780928,0.68666667,0.4780928,0.69,0.4780928,0.6933333,0.4780928,0.69666666,0.4780928,0.71666664,0.4780928,0.72,0.4780928,0.72333336,0.4780928,0.78333336,0.4780928,0.7866667,0.4780928,0.79,0.4780928,0.79333335,0.4780928,0.7966667,0.4780928,0.8,0.4780928,0.80333334,0.4780928,0.8066667,0.4780928,0.81,0.4780928,0.81333333,0.4780928,0.81666666,0.4780928,0.85333335,0.4780928,0.8566667,0.4780928,0.86,0.4780928,0.86333334,0.4780928,0.8666667,0.4780928,0.87,0.4780928,0.87333333,0.4780928,0.87666667,0.4780928,0.88,0.4780928,0.8833333,0.4780928,0.88666666,0.4780928,0.89,0.4780928,0.8933333,0.4780928,0.89666665,0.4780928,0.9,0.4780928,0.9033333,0.4780928,0.9066667,0.4780928,0.91,0.4780928,0.91333336,0.4780928,0.9166667,0.4780928,0.11,0.4806701,0.11333334,0.4806701,0.11666667,0.4806701,0.12,0.4806701,0.123333335,0.4806701,0.12666667,0.4806701,0.13,0.4806701,0.13333334,0.4806701,0.13666667,0.4806701,0.16,0.4806701,0.16333333,0.4806701,0.16666667,0.4806701,0.17,0.4806701,0.17333333,0.4806701,0.17666666,0.4806701,0.18,0.4806701,0.18333334,0.4806701,0.18666667,0.4806701,0.19,0.4806701,0.19333333,0.4806701,0.19666667,0.4806701,0.2,0.4806701,0.20333333,0.4806701,0.20666666,0.4806701,0.21,0.4806701,0.21333334,0.4806701,0.21666667,0.4806701,0.22,0.4806701,0.22333333,0.4806701,0.22666667,0.4806701,0.24,0.4806701,0.24333334,0.4806701,0.26666668,0.4806701,0.27,0.4806701,0.27333334,0.4806701,0.27666667,0.4806701,0.28,0.4806701,0.28333333,0.4806701,0.28666666,0.4806701,0.29,0.4806701,0.29333332,0.4806701,0.29666665,0.4806701,0.3,0.4806701,0.30333334,0.4806701,0.30666667,0.4806701,0.31,0.4806701,0.31333333,0.4806701,0.31666666,0.4806701,0.32,0.4806701,0.32333332,0.4806701,0.32666665,0.4806701,0.33,0.4806701,0.33333334,0.4806701,0.33666667,0.4806701,0.34,0.4806701,0.38,0.4806701,0.38333333,0.4806701,0.38666666,0.4806701,0.39,0.4806701,0.39333335,0.4806701,0.39666668,0.4806701,0.4,0.4806701,0.40333334,0.4806701,0.40666667,0.4806701,0.41,0.4806701,0.41333333,0.4806701,0.41666666,0.4806701,0.42,0.4806701,0.42333335,0.4806701,0.42666668,0.4806701,0.43,0.4806701,0.43333334,0.4806701,0.43666667,0.4806701,0.44,0.4806701,0.44333333,0.4806701,0.44666666,0.4806701,0.45,0.4806701,0.45333335,0.4806701,0.45666668,0.4806701,0.46,0.4806701,0.46333334,0.4806701,0.46666667,0.4806701,0.47,0.4806701,0.47333333,0.4806701,0.47666666,0.4806701,0.48,0.4806701,0.48333332,0.4806701,0.48666668,0.4806701,0.49,0.4806701,0.49333334,0.4806701,0.49666667,0.4806701,0.5,0.4806701,0.50333333,0.4806701,0.50666666,0.4806701,0.51,0.4806701,0.5133333,0.4806701,0.51666665,0.4806701,0.52,0.4806701,0.5233333,0.4806701,0.52666664,0.4806701,0.53,0.4806701,0.53333336,0.4806701,0.5366667,0.4806701,0.54,0.4806701,0.54333335,0.4806701,0.5466667,0.4806701,0.55,0.4806701,0.55333334,0.4806701,0.5566667,0.4806701,0.56,0.4806701,0.56333333,0.4806701,0.56666666,0.4806701,0.57,0.4806701,0.5733333,0.4806701,0.57666665,0.4806701,0.58,0.4806701,0.5833333,0.4806701,0.58666664,0.4806701,0.59,0.4806701,0.5933333,0.4806701,0.5966667,0.4806701,0.6766667,0.4806701,0.68,0.4806701,0.68333334,0.4806701,0.68666667,0.4806701,0.69,0.4806701,0.6933333,0.4806701,0.69666666,0.4806701,0.78333336,0.4806701,0.7866667,0.4806701,0.79,0.4806701,0.79333335,0.4806701,0.7966667,0.4806701,0.8,0.4806701,0.80333334,0.4806701,0.8066667,0.4806701,0.81,0.4806701,0.81333333,0.4806701,0.85333335,0.4806701,0.8566667,0.4806701,0.86,0.4806701,0.86333334,0.4806701,0.8666667,0.4806701,0.87,0.4806701,0.87333333,0.4806701,0.87666667,0.4806701,0.88,0.4806701,0.8833333,0.4806701,0.88666666,0.4806701,0.89,0.4806701,0.8933333,0.4806701,0.89666665,0.4806701,0.9,0.4806701,0.9033333,0.4806701,0.9066667,0.4806701,0.91,0.4806701,0.91333336,0.4806701,0.9166667,0.4806701,0.11,0.48324743,0.11333334,0.48324743,0.11666667,0.48324743,0.12,0.48324743,0.123333335,0.48324743,0.12666667,0.48324743,0.13,0.48324743,0.13333334,0.48324743,0.13666667,0.48324743,0.16,0.48324743,0.16333333,0.48324743,0.16666667,0.48324743,0.17,0.48324743,0.17333333,0.48324743,0.17666666,0.48324743,0.18,0.48324743,0.18333334,0.48324743,0.18666667,0.48324743,0.19,0.48324743,0.19333333,0.48324743,0.19666667,0.48324743,0.2,0.48324743,0.20333333,0.48324743,0.20666666,0.48324743,0.21,0.48324743,0.21333334,0.48324743,0.21666667,0.48324743,0.22,0.48324743,0.22333333,0.48324743,0.22666667,0.48324743,0.23,0.48324743,0.23333333,0.48324743,0.23666666,0.48324743,0.24,0.48324743,0.24333334,0.48324743,0.24666667,0.48324743,0.25,0.48324743,0.26666668,0.48324743,0.27,0.48324743,0.27333334,0.48324743,0.27666667,0.48324743,0.28,0.48324743,0.28333333,0.48324743,0.28666666,0.48324743,0.29,0.48324743,0.29333332,0.48324743,0.29666665,0.48324743,0.3,0.48324743,0.30333334,0.48324743,0.30666667,0.48324743,0.31,0.48324743,0.31333333,0.48324743,0.31666666,0.48324743,0.32,0.48324743,0.32333332,0.48324743,0.32666665,0.48324743,0.33,0.48324743,0.33333334,0.48324743,0.33666667,0.48324743,0.34,0.48324743,0.37666667,0.48324743,0.38,0.48324743,0.38333333,0.48324743,0.38666666,0.48324743,0.39,0.48324743,0.39333335,0.48324743,0.39666668,0.48324743,0.4,0.48324743,0.40333334,0.48324743,0.40666667,0.48324743,0.41,0.48324743,0.41333333,0.48324743,0.41666666,0.48324743,0.42,0.48324743,0.42333335,0.48324743,0.42666668,0.48324743,0.43,0.48324743,0.43333334,0.48324743,0.43666667,0.48324743,0.44,0.48324743,0.44333333,0.48324743,0.44666666,0.48324743,0.45,0.48324743,0.45333335,0.48324743,0.45666668,0.48324743,0.46,0.48324743,0.46333334,0.48324743,0.46666667,0.48324743,0.47,0.48324743,0.47333333,0.48324743,0.47666666,0.48324743,0.48,0.48324743,0.48333332,0.48324743,0.48666668,0.48324743,0.49,0.48324743,0.49333334,0.48324743,0.49666667,0.48324743,0.5,0.48324743,0.50333333,0.48324743,0.50666666,0.48324743,0.51,0.48324743,0.5133333,0.48324743,0.51666665,0.48324743,0.52,0.48324743,0.5233333,0.48324743,0.52666664,0.48324743,0.53,0.48324743,0.53333336,0.48324743,0.5366667,0.48324743,0.54,0.48324743,0.54333335,0.48324743,0.5466667,0.48324743,0.55,0.48324743,0.55333334,0.48324743,0.5566667,0.48324743,0.56,0.48324743,0.56333333,0.48324743,0.56666666,0.48324743,0.57,0.48324743,0.5733333,0.48324743,0.57666665,0.48324743,0.58,0.48324743,0.5833333,0.48324743,0.58666664,0.48324743,0.59,0.48324743,0.5933333,0.48324743,0.5966667,0.48324743,0.6,0.48324743,0.60333335,0.48324743,0.6066667,0.48324743,0.66,0.48324743,0.66333336,0.48324743,0.6666667,0.48324743,0.67,0.48324743,0.67333335,0.48324743,0.6766667,0.48324743,0.68,0.48324743,0.68333334,0.48324743,0.68666667,0.48324743,0.69,0.48324743,0.6933333,0.48324743,0.69666666,0.48324743,0.78333336,0.48324743,0.7866667,0.48324743,0.79,0.48324743,0.79333335,0.48324743,0.7966667,0.48324743,0.8,0.48324743,0.80333334,0.48324743,0.8066667,0.48324743,0.81,0.48324743,0.81333333,0.48324743,0.81666666,0.48324743,0.8566667,0.48324743,0.86,0.48324743,0.86333334,0.48324743,0.8666667,0.48324743,0.87,0.48324743,0.87333333,0.48324743,0.87666667,0.48324743,0.88,0.48324743,0.8833333,0.48324743,0.88666666,0.48324743,0.89,0.48324743,0.8933333,0.48324743,0.89666665,0.48324743,0.9,0.48324743,0.9033333,0.48324743,0.9066667,0.48324743,0.91,0.48324743,0.91333336,0.48324743,0.9166667,0.48324743,0.92,0.48324743,0.10666667,0.48582473,0.11,0.48582473,0.11333334,0.48582473,0.11666667,0.48582473,0.12,0.48582473,0.123333335,0.48582473,0.12666667,0.48582473,0.13,0.48582473,0.13333334,0.48582473,0.13666667,0.48582473,0.15666667,0.48582473,0.16,0.48582473,0.16333333,0.48582473,0.16666667,0.48582473,0.17,0.48582473,0.17333333,0.48582473,0.17666666,0.48582473,0.18,0.48582473,0.18333334,0.48582473,0.18666667,0.48582473,0.19,0.48582473,0.19333333,0.48582473,0.19666667,0.48582473,0.2,0.48582473,0.20333333,0.48582473,0.20666666,0.48582473,0.21,0.48582473,0.21333334,0.48582473,0.21666667,0.48582473,0.22,0.48582473,0.22333333,0.48582473,0.22666667,0.48582473,0.23,0.48582473,0.23333333,0.48582473,0.23666666,0.48582473,0.24,0.48582473,0.24333334,0.48582473,0.24666667,0.48582473,0.25,0.48582473,0.26333332,0.48582473,0.26666668,0.48582473,0.27,0.48582473,0.27333334,0.48582473,0.27666667,0.48582473,0.28,0.48582473,0.28333333,0.48582473,0.28666666,0.48582473,0.29,0.48582473,0.29333332,0.48582473,0.29666665,0.48582473,0.3,0.48582473,0.30333334,0.48582473,0.30666667,0.48582473,0.31,0.48582473,0.31333333,0.48582473,0.31666666,0.48582473,0.32,0.48582473,0.32333332,0.48582473,0.32666665,0.48582473,0.33,0.48582473,0.33333334,0.48582473,0.33666667,0.48582473,0.34,0.48582473,0.37333333,0.48582473,0.37666667,0.48582473,0.38,0.48582473,0.38333333,0.48582473,0.38666666,0.48582473,0.39,0.48582473,0.39333335,0.48582473,0.39666668,0.48582473,0.4,0.48582473,0.40333334,0.48582473,0.40666667,0.48582473,0.41,0.48582473,0.41333333,0.48582473,0.41666666,0.48582473,0.42,0.48582473,0.42333335,0.48582473,0.42666668,0.48582473,0.43,0.48582473,0.43333334,0.48582473,0.43666667,0.48582473,0.44,0.48582473,0.44333333,0.48582473,0.44666666,0.48582473,0.45,0.48582473,0.45333335,0.48582473,0.45666668,0.48582473,0.46,0.48582473,0.46333334,0.48582473,0.46666667,0.48582473,0.47,0.48582473,0.47333333,0.48582473,0.47666666,0.48582473,0.48,0.48582473,0.48333332,0.48582473,0.48666668,0.48582473,0.49,0.48582473,0.49333334,0.48582473,0.49666667,0.48582473,0.5,0.48582473,0.50333333,0.48582473,0.50666666,0.48582473,0.51,0.48582473,0.5133333,0.48582473,0.51666665,0.48582473,0.52,0.48582473,0.5233333,0.48582473,0.52666664,0.48582473,0.53,0.48582473,0.53333336,0.48582473,0.5366667,0.48582473,0.54,0.48582473,0.54333335,0.48582473,0.5466667,0.48582473,0.55,0.48582473,0.55333334,0.48582473,0.5566667,0.48582473,0.56,0.48582473,0.56333333,0.48582473,0.56666666,0.48582473,0.57,0.48582473,0.5733333,0.48582473,0.57666665,0.48582473,0.58,0.48582473,0.5833333,0.48582473,0.58666664,0.48582473,0.59,0.48582473,0.5933333,0.48582473,0.5966667,0.48582473,0.6,0.48582473,0.60333335,0.48582473,0.6066667,0.48582473,0.61,0.48582473,0.61333334,0.48582473,0.6166667,0.48582473,0.6533333,0.48582473,0.6566667,0.48582473,0.66,0.48582473,0.66333336,0.48582473,0.6666667,0.48582473,0.67,0.48582473,0.67333335,0.48582473,0.6766667,0.48582473,0.68,0.48582473,0.68333334,0.48582473,0.68666667,0.48582473,0.69,0.48582473,0.6933333,0.48582473,0.69666666,0.48582473,0.78333336,0.48582473,0.7866667,0.48582473,0.79333335,0.48582473,0.7966667,0.48582473,0.8,0.48582473,0.80333334,0.48582473,0.8066667,0.48582473,0.81,0.48582473,0.81333333,0.48582473,0.8566667,0.48582473,0.86,0.48582473,0.86333334,0.48582473,0.8666667,0.48582473,0.87,0.48582473,0.87333333,0.48582473,0.87666667,0.48582473,0.88,0.48582473,0.8833333,0.48582473,0.88666666,0.48582473,0.89,0.48582473,0.8933333,0.48582473,0.89666665,0.48582473,0.9,0.48582473,0.9033333,0.48582473,0.9066667,0.48582473,0.91,0.48582473,0.91333336,0.48582473,0.9166667,0.48582473,0.92,0.48582473,0.92333335,0.48582473,0.1,0.48840207,0.10333333,0.48840207,0.10666667,0.48840207,0.11,0.48840207,0.11333334,0.48840207,0.11666667,0.48840207,0.12,0.48840207,0.123333335,0.48840207,0.12666667,0.48840207,0.13,0.48840207,0.13333334,0.48840207,0.13666667,0.48840207,0.16,0.48840207,0.16333333,0.48840207,0.16666667,0.48840207,0.17,0.48840207,0.17333333,0.48840207,0.17666666,0.48840207,0.18,0.48840207,0.18333334,0.48840207,0.18666667,0.48840207,0.19,0.48840207,0.19333333,0.48840207,0.19666667,0.48840207,0.2,0.48840207,0.20333333,0.48840207,0.20666666,0.48840207,0.21,0.48840207,0.21333334,0.48840207,0.21666667,0.48840207,0.22,0.48840207,0.22333333,0.48840207,0.22666667,0.48840207,0.23,0.48840207,0.23333333,0.48840207,0.23666666,0.48840207,0.24,0.48840207,0.24333334,0.48840207,0.24666667,0.48840207,0.25,0.48840207,0.25333333,0.48840207,0.26333332,0.48840207,0.26666668,0.48840207,0.27,0.48840207,0.27333334,0.48840207,0.27666667,0.48840207,0.28,0.48840207,0.28333333,0.48840207,0.28666666,0.48840207,0.29,0.48840207,0.29333332,0.48840207,0.29666665,0.48840207,0.3,0.48840207,0.30333334,0.48840207,0.30666667,0.48840207,0.31,0.48840207,0.31333333,0.48840207,0.31666666,0.48840207,0.32,0.48840207,0.32333332,0.48840207,0.32666665,0.48840207,0.33,0.48840207,0.33333334,0.48840207,0.33666667,0.48840207,0.34,0.48840207,0.37,0.48840207,0.37333333,0.48840207,0.37666667,0.48840207,0.38,0.48840207,0.38333333,0.48840207,0.38666666,0.48840207,0.39,0.48840207,0.39333335,0.48840207,0.39666668,0.48840207,0.4,0.48840207,0.40333334,0.48840207,0.40666667,0.48840207,0.41,0.48840207,0.41333333,0.48840207,0.41666666,0.48840207,0.42,0.48840207,0.42333335,0.48840207,0.42666668,0.48840207,0.43,0.48840207,0.43333334,0.48840207,0.43666667,0.48840207,0.44,0.48840207,0.44333333,0.48840207,0.44666666,0.48840207,0.45,0.48840207,0.45333335,0.48840207,0.45666668,0.48840207,0.46,0.48840207,0.46333334,0.48840207,0.46666667,0.48840207,0.47,0.48840207,0.47333333,0.48840207,0.47666666,0.48840207,0.48,0.48840207,0.48333332,0.48840207,0.48666668,0.48840207,0.49,0.48840207,0.49333334,0.48840207,0.49666667,0.48840207,0.5,0.48840207,0.50333333,0.48840207,0.50666666,0.48840207,0.51,0.48840207,0.5133333,0.48840207,0.51666665,0.48840207,0.52,0.48840207,0.5233333,0.48840207,0.52666664,0.48840207,0.53,0.48840207,0.53333336,0.48840207,0.5366667,0.48840207,0.54,0.48840207,0.54333335,0.48840207,0.5466667,0.48840207,0.55,0.48840207,0.55333334,0.48840207,0.5566667,0.48840207,0.56,0.48840207,0.56333333,0.48840207,0.56666666,0.48840207,0.57,0.48840207,0.5733333,0.48840207,0.57666665,0.48840207,0.58,0.48840207,0.5833333,0.48840207,0.58666664,0.48840207,0.59,0.48840207,0.5933333,0.48840207,0.5966667,0.48840207,0.6,0.48840207,0.60333335,0.48840207,0.6066667,0.48840207,0.61,0.48840207,0.61333334,0.48840207,0.6166667,0.48840207,0.62,0.48840207,0.64666665,0.48840207,0.65,0.48840207,0.6533333,0.48840207,0.6566667,0.48840207,0.66,0.48840207,0.66333336,0.48840207,0.6666667,0.48840207,0.67,0.48840207,0.67333335,0.48840207,0.6766667,0.48840207,0.68,0.48840207,0.68333334,0.48840207,0.68666667,0.48840207,0.69,0.48840207,0.6933333,0.48840207,0.69666666,0.48840207,0.7966667,0.48840207,0.8,0.48840207,0.80333334,0.48840207,0.8066667,0.48840207,0.81,0.48840207,0.81333333,0.48840207,0.8566667,0.48840207,0.86,0.48840207,0.86333334,0.48840207,0.8666667,0.48840207,0.87,0.48840207,0.87333333,0.48840207,0.87666667,0.48840207,0.88,0.48840207,0.8833333,0.48840207,0.88666666,0.48840207,0.89,0.48840207,0.8933333,0.48840207,0.89666665,0.48840207,0.9,0.48840207,0.9033333,0.48840207,0.9066667,0.48840207,0.91,0.48840207,0.91333336,0.48840207,0.9166667,0.48840207,0.92,0.48840207,0.92333335,0.48840207,0.093333334,0.49097937,0.096666664,0.49097937,0.1,0.49097937,0.10333333,0.49097937,0.10666667,0.49097937,0.11,0.49097937,0.11333334,0.49097937,0.11666667,0.49097937,0.12,0.49097937,0.123333335,0.49097937,0.12666667,0.49097937,0.13,0.49097937,0.13333334,0.49097937,0.13666667,0.49097937,0.14666666,0.49097937,0.15,0.49097937,0.15333334,0.49097937,0.17,0.49097937,0.17333333,0.49097937,0.17666666,0.49097937,0.18,0.49097937,0.18333334,0.49097937,0.18666667,0.49097937,0.19,0.49097937,0.19333333,0.49097937,0.19666667,0.49097937,0.2,0.49097937,0.20333333,0.49097937,0.20666666,0.49097937,0.21,0.49097937,0.21333334,0.49097937,0.21666667,0.49097937,0.22,0.49097937,0.22333333,0.49097937,0.22666667,0.49097937,0.23,0.49097937,0.23333333,0.49097937,0.23666666,0.49097937,0.24,0.49097937,0.24333334,0.49097937,0.24666667,0.49097937,0.25,0.49097937,0.25333333,0.49097937,0.26333332,0.49097937,0.26666668,0.49097937,0.27,0.49097937,0.27333334,0.49097937,0.27666667,0.49097937,0.28,0.49097937,0.28333333,0.49097937,0.28666666,0.49097937,0.29,0.49097937,0.29333332,0.49097937,0.29666665,0.49097937,0.3,0.49097937,0.30333334,0.49097937,0.30666667,0.49097937,0.31,0.49097937,0.31333333,0.49097937,0.31666666,0.49097937,0.32,0.49097937,0.32333332,0.49097937,0.32666665,0.49097937,0.33,0.49097937,0.33333334,0.49097937,0.33666667,0.49097937,0.36666667,0.49097937,0.37,0.49097937,0.37333333,0.49097937,0.37666667,0.49097937,0.38,0.49097937,0.38333333,0.49097937,0.38666666,0.49097937,0.39,0.49097937,0.39333335,0.49097937,0.39666668,0.49097937,0.4,0.49097937,0.40333334,0.49097937,0.40666667,0.49097937,0.41,0.49097937,0.41333333,0.49097937,0.41666666,0.49097937,0.42,0.49097937,0.42333335,0.49097937,0.42666668,0.49097937,0.43,0.49097937,0.43333334,0.49097937,0.43666667,0.49097937,0.44,0.49097937,0.44333333,0.49097937,0.44666666,0.49097937,0.45,0.49097937,0.45333335,0.49097937,0.45666668,0.49097937,0.46,0.49097937,0.46333334,0.49097937,0.46666667,0.49097937,0.47,0.49097937,0.47333333,0.49097937,0.47666666,0.49097937,0.48,0.49097937,0.48333332,0.49097937,0.48666668,0.49097937,0.49,0.49097937,0.49333334,0.49097937,0.49666667,0.49097937,0.5,0.49097937,0.50333333,0.49097937,0.50666666,0.49097937,0.51,0.49097937,0.5133333,0.49097937,0.51666665,0.49097937,0.52,0.49097937,0.5233333,0.49097937,0.52666664,0.49097937,0.53,0.49097937,0.53333336,0.49097937,0.5366667,0.49097937,0.54,0.49097937,0.54333335,0.49097937,0.5466667,0.49097937,0.55,0.49097937,0.55333334,0.49097937,0.5566667,0.49097937,0.56,0.49097937,0.56333333,0.49097937,0.56666666,0.49097937,0.57,0.49097937,0.5733333,0.49097937,0.57666665,0.49097937,0.58,0.49097937,0.5833333,0.49097937,0.58666664,0.49097937,0.59,0.49097937,0.5933333,0.49097937,0.5966667,0.49097937,0.6,0.49097937,0.60333335,0.49097937,0.6066667,0.49097937,0.61,0.49097937,0.61333334,0.49097937,0.6166667,0.49097937,0.62,0.49097937,0.6433333,0.49097937,0.64666665,0.49097937,0.65,0.49097937,0.6533333,0.49097937,0.6566667,0.49097937,0.66,0.49097937,0.66333336,0.49097937,0.6666667,0.49097937,0.67,0.49097937,0.67333335,0.49097937,0.6766667,0.49097937,0.68,0.49097937,0.68333334,0.49097937,0.68666667,0.49097937,0.69,0.49097937,0.6933333,0.49097937,0.69666666,0.49097937,0.79333335,0.49097937,0.7966667,0.49097937,0.8,0.49097937,0.80333334,0.49097937,0.8066667,0.49097937,0.81,0.49097937,0.81333333,0.49097937,0.85,0.49097937,0.86,0.49097937,0.86333334,0.49097937,0.8666667,0.49097937,0.87,0.49097937,0.87333333,0.49097937,0.87666667,0.49097937,0.88,0.49097937,0.8833333,0.49097937,0.88666666,0.49097937,0.89,0.49097937,0.8933333,0.49097937,0.89666665,0.49097937,0.9,0.49097937,0.9033333,0.49097937,0.9066667,0.49097937,0.91,0.49097937,0.91333336,0.49097937,0.9166667,0.49097937,0.92,0.49097937,0.92333335,0.49097937,0.9266667,0.49097937,0.083333336,0.4935567,0.086666666,0.4935567,0.09,0.4935567,0.093333334,0.4935567,0.096666664,0.4935567,0.1,0.4935567,0.10333333,0.4935567,0.10666667,0.4935567,0.11,0.4935567,0.11333334,0.4935567,0.11666667,0.4935567,0.12,0.4935567,0.123333335,0.4935567,0.12666667,0.4935567,0.13,0.4935567,0.13333334,0.4935567,0.13666667,0.4935567,0.14666666,0.4935567,0.15,0.4935567,0.15333334,0.4935567,0.15666667,0.4935567,0.16,0.4935567,0.16333333,0.4935567,0.16666667,0.4935567,0.17,0.4935567,0.17333333,0.4935567,0.17666666,0.4935567,0.18,0.4935567,0.18333334,0.4935567,0.18666667,0.4935567,0.19,0.4935567,0.19333333,0.4935567,0.19666667,0.4935567,0.2,0.4935567,0.20333333,0.4935567,0.20666666,0.4935567,0.21,0.4935567,0.21333334,0.4935567,0.21666667,0.4935567,0.22,0.4935567,0.22333333,0.4935567,0.22666667,0.4935567,0.23,0.4935567,0.23333333,0.4935567,0.23666666,0.4935567,0.24,0.4935567,0.24333334,0.4935567,0.24666667,0.4935567,0.25,0.4935567,0.25333333,0.4935567,0.26333332,0.4935567,0.26666668,0.4935567,0.27,0.4935567,0.27333334,0.4935567,0.27666667,0.4935567,0.28,0.4935567,0.28333333,0.4935567,0.28666666,0.4935567,0.29,0.4935567,0.29333332,0.4935567,0.29666665,0.4935567,0.3,0.4935567,0.30333334,0.4935567,0.30666667,0.4935567,0.31,0.4935567,0.31333333,0.4935567,0.31666666,0.4935567,0.32,0.4935567,0.32333332,0.4935567,0.32666665,0.4935567,0.33,0.4935567,0.33333334,0.4935567,0.36333334,0.4935567,0.36666667,0.4935567,0.37,0.4935567,0.37333333,0.4935567,0.37666667,0.4935567,0.38,0.4935567,0.38333333,0.4935567,0.38666666,0.4935567,0.39,0.4935567,0.39333335,0.4935567,0.39666668,0.4935567,0.4,0.4935567,0.40333334,0.4935567,0.40666667,0.4935567,0.41,0.4935567,0.41333333,0.4935567,0.41666666,0.4935567,0.42,0.4935567,0.42333335,0.4935567,0.42666668,0.4935567,0.43,0.4935567,0.43333334,0.4935567,0.43666667,0.4935567,0.44,0.4935567,0.44333333,0.4935567,0.44666666,0.4935567,0.45,0.4935567,0.45333335,0.4935567,0.45666668,0.4935567,0.46,0.4935567,0.46333334,0.4935567,0.46666667,0.4935567,0.47,0.4935567,0.47333333,0.4935567,0.47666666,0.4935567,0.48,0.4935567,0.48333332,0.4935567,0.48666668,0.4935567,0.49,0.4935567,0.49333334,0.4935567,0.49666667,0.4935567,0.5,0.4935567,0.50333333,0.4935567,0.50666666,0.4935567,0.51,0.4935567,0.5133333,0.4935567,0.51666665,0.4935567,0.52,0.4935567,0.5233333,0.4935567,0.52666664,0.4935567,0.53,0.4935567,0.53333336,0.4935567,0.5366667,0.4935567,0.54,0.4935567,0.54333335,0.4935567,0.5466667,0.4935567,0.55,0.4935567,0.55333334,0.4935567,0.5566667,0.4935567,0.56,0.4935567,0.56333333,0.4935567,0.56666666,0.4935567,0.57,0.4935567,0.5733333,0.4935567,0.57666665,0.4935567,0.58,0.4935567,0.5833333,0.4935567,0.58666664,0.4935567,0.59,0.4935567,0.5933333,0.4935567,0.5966667,0.4935567,0.6,0.4935567,0.60333335,0.4935567,0.6066667,0.4935567,0.61,0.4935567,0.61333334,0.4935567,0.6166667,0.4935567,0.62,0.4935567,0.62333333,0.4935567,0.6433333,0.4935567,0.64666665,0.4935567,0.65,0.4935567,0.6533333,0.4935567,0.6566667,0.4935567,0.66,0.4935567,0.66333336,0.4935567,0.6666667,0.4935567,0.67,0.4935567,0.67333335,0.4935567,0.6766667,0.4935567,0.68,0.4935567,0.68333334,0.4935567,0.68666667,0.4935567,0.69,0.4935567,0.6933333,0.4935567,0.69666666,0.4935567,0.86,0.4935567,0.86333334,0.4935567,0.8666667,0.4935567,0.87,0.4935567,0.87333333,0.4935567,0.87666667,0.4935567,0.88,0.4935567,0.8833333,0.4935567,0.88666666,0.4935567,0.89,0.4935567,0.8933333,0.4935567,0.89666665,0.4935567,0.9,0.4935567,0.9033333,0.4935567,0.9066667,0.4935567,0.91,0.4935567,0.91333336,0.4935567,0.9166667,0.4935567,0.92,0.4935567,0.92333335,0.4935567,0.9266667,0.4935567,0.07666667,0.496134,0.08,0.496134,0.083333336,0.496134,0.086666666,0.496134,0.09,0.496134,0.093333334,0.496134,0.096666664,0.496134,0.1,0.496134,0.10333333,0.496134,0.10666667,0.496134,0.11,0.496134,0.11333334,0.496134,0.11666667,0.496134,0.12,0.496134,0.123333335,0.496134,0.12666667,0.496134,0.13,0.496134,0.13333334,0.496134,0.13666667,0.496134,0.14666666,0.496134,0.15,0.496134,0.15333334,0.496134,0.15666667,0.496134,0.16,0.496134,0.16333333,0.496134,0.16666667,0.496134,0.17,0.496134,0.17333333,0.496134,0.17666666,0.496134,0.18,0.496134,0.18333334,0.496134,0.18666667,0.496134,0.19,0.496134,0.19333333,0.496134,0.19666667,0.496134,0.2,0.496134,0.20333333,0.496134,0.20666666,0.496134,0.21,0.496134,0.21333334,0.496134,0.21666667,0.496134,0.22,0.496134,0.22333333,0.496134,0.22666667,0.496134,0.23,0.496134,0.23333333,0.496134,0.23666666,0.496134,0.24,0.496134,0.24333334,0.496134,0.24666667,0.496134,0.25,0.496134,0.25333333,0.496134,0.25666666,0.496134,0.26333332,0.496134,0.26666668,0.496134,0.27,0.496134,0.27333334,0.496134,0.27666667,0.496134,0.28,0.496134,0.28333333,0.496134,0.28666666,0.496134,0.29,0.496134,0.29333332,0.496134,0.29666665,0.496134,0.3,0.496134,0.30333334,0.496134,0.30666667,0.496134,0.31,0.496134,0.31333333,0.496134,0.31666666,0.496134,0.32,0.496134,0.32333332,0.496134,0.32666665,0.496134,0.33,0.496134,0.36,0.496134,0.36333334,0.496134,0.36666667,0.496134,0.37,0.496134,0.37333333,0.496134,0.37666667,0.496134,0.38,0.496134,0.38333333,0.496134,0.38666666,0.496134,0.39,0.496134,0.39333335,0.496134,0.39666668,0.496134,0.4,0.496134,0.40333334,0.496134,0.40666667,0.496134,0.41,0.496134,0.41333333,0.496134,0.41666666,0.496134,0.42,0.496134,0.42333335,0.496134,0.42666668,0.496134,0.43,0.496134,0.43333334,0.496134,0.43666667,0.496134,0.44,0.496134,0.44333333,0.496134,0.44666666,0.496134,0.45,0.496134,0.45333335,0.496134,0.45666668,0.496134,0.46,0.496134,0.46333334,0.496134,0.46666667,0.496134,0.47,0.496134,0.47333333,0.496134,0.47666666,0.496134,0.48,0.496134,0.48333332,0.496134,0.48666668,0.496134,0.49,0.496134,0.49333334,0.496134,0.49666667,0.496134,0.5,0.496134,0.50333333,0.496134,0.50666666,0.496134,0.51,0.496134,0.5133333,0.496134,0.51666665,0.496134,0.52,0.496134,0.5233333,0.496134,0.52666664,0.496134,0.53,0.496134,0.53333336,0.496134,0.5366667,0.496134,0.54,0.496134,0.54333335,0.496134,0.5466667,0.496134,0.55,0.496134,0.55333334,0.496134,0.5566667,0.496134,0.56,0.496134,0.56333333,0.496134,0.56666666,0.496134,0.57,0.496134,0.5733333,0.496134,0.57666665,0.496134,0.58,0.496134,0.5833333,0.496134,0.58666664,0.496134,0.59,0.496134,0.5933333,0.496134,0.5966667,0.496134,0.6,0.496134,0.60333335,0.496134,0.6066667,0.496134,0.61,0.496134,0.61333334,0.496134,0.6166667,0.496134,0.62,0.496134,0.62333333,0.496134,0.6433333,0.496134,0.64666665,0.496134,0.65,0.496134,0.6533333,0.496134,0.6566667,0.496134,0.66,0.496134,0.66333336,0.496134,0.6666667,0.496134,0.67,0.496134,0.67333335,0.496134,0.6766667,0.496134,0.68,0.496134,0.68333334,0.496134,0.68666667,0.496134,0.69,0.496134,0.6933333,0.496134,0.69666666,0.496134,0.86,0.496134,0.86333334,0.496134,0.8666667,0.496134,0.87,0.496134,0.87333333,0.496134,0.87666667,0.496134,0.88,0.496134,0.8833333,0.496134,0.88666666,0.496134,0.89,0.496134,0.8933333,0.496134,0.89666665,0.496134,0.9,0.496134,0.9033333,0.496134,0.9066667,0.496134,0.91,0.496134,0.91333336,0.496134,0.9166667,0.496134,0.92,0.496134,0.92333335,0.496134,0.9266667,0.496134,0.07333333,0.49871135,0.07666667,0.49871135,0.08,0.49871135,0.083333336,0.49871135,0.086666666,0.49871135,0.09,0.49871135,0.093333334,0.49871135,0.096666664,0.49871135,0.1,0.49871135,0.10333333,0.49871135,0.10666667,0.49871135,0.11,0.49871135,0.11333334,0.49871135,0.11666667,0.49871135,0.12,0.49871135,0.123333335,0.49871135,0.12666667,0.49871135,0.13,0.49871135,0.13333334,0.49871135,0.13666667,0.49871135,0.14,0.49871135,0.14666666,0.49871135,0.15,0.49871135,0.15333334,0.49871135,0.15666667,0.49871135,0.16,0.49871135,0.16333333,0.49871135,0.16666667,0.49871135,0.17,0.49871135,0.17333333,0.49871135,0.17666666,0.49871135,0.18,0.49871135,0.18333334,0.49871135,0.18666667,0.49871135,0.19,0.49871135,0.19333333,0.49871135,0.19666667,0.49871135,0.2,0.49871135,0.20333333,0.49871135,0.20666666,0.49871135,0.21,0.49871135,0.21333334,0.49871135,0.21666667,0.49871135,0.22,0.49871135,0.22333333,0.49871135,0.22666667,0.49871135,0.23,0.49871135,0.23333333,0.49871135,0.23666666,0.49871135,0.24,0.49871135,0.24333334,0.49871135,0.24666667,0.49871135,0.25,0.49871135,0.25333333,0.49871135,0.25666666,0.49871135,0.26333332,0.49871135,0.26666668,0.49871135,0.27,0.49871135,0.27333334,0.49871135,0.27666667,0.49871135,0.28,0.49871135,0.28333333,0.49871135,0.28666666,0.49871135,0.29,0.49871135,0.29333332,0.49871135,0.29666665,0.49871135,0.3,0.49871135,0.30333334,0.49871135,0.30666667,0.49871135,0.31,0.49871135,0.31333333,0.49871135,0.35666665,0.49871135,0.36,0.49871135,0.36333334,0.49871135,0.36666667,0.49871135,0.37,0.49871135,0.37333333,0.49871135,0.37666667,0.49871135,0.38,0.49871135,0.38333333,0.49871135,0.38666666,0.49871135,0.39,0.49871135,0.39333335,0.49871135,0.39666668,0.49871135,0.4,0.49871135,0.40333334,0.49871135,0.40666667,0.49871135,0.41,0.49871135,0.41333333,0.49871135,0.41666666,0.49871135,0.42,0.49871135,0.42333335,0.49871135,0.42666668,0.49871135,0.43,0.49871135,0.43333334,0.49871135,0.43666667,0.49871135,0.44,0.49871135,0.44333333,0.49871135,0.44666666,0.49871135,0.45,0.49871135,0.45333335,0.49871135,0.45666668,0.49871135,0.46,0.49871135,0.46333334,0.49871135,0.46666667,0.49871135,0.47,0.49871135,0.47333333,0.49871135,0.48,0.49871135,0.48333332,0.49871135,0.48666668,0.49871135,0.49,0.49871135,0.49333334,0.49871135,0.49666667,0.49871135,0.5,0.49871135,0.50333333,0.49871135,0.50666666,0.49871135,0.51,0.49871135,0.5133333,0.49871135,0.51666665,0.49871135,0.52,0.49871135,0.5233333,0.49871135,0.52666664,0.49871135,0.53,0.49871135,0.53333336,0.49871135,0.5366667,0.49871135,0.54,0.49871135,0.54333335,0.49871135,0.5466667,0.49871135,0.55,0.49871135,0.55333334,0.49871135,0.5566667,0.49871135,0.56,0.49871135,0.56333333,0.49871135,0.56666666,0.49871135,0.57,0.49871135,0.5733333,0.49871135,0.57666665,0.49871135,0.58,0.49871135,0.5833333,0.49871135,0.58666664,0.49871135,0.59,0.49871135,0.5933333,0.49871135,0.5966667,0.49871135,0.6,0.49871135,0.60333335,0.49871135,0.6066667,0.49871135,0.61,0.49871135,0.61333334,0.49871135,0.6166667,0.49871135,0.62,0.49871135,0.62333333,0.49871135,0.6433333,0.49871135,0.64666665,0.49871135,0.65,0.49871135,0.6533333,0.49871135,0.6566667,0.49871135,0.66,0.49871135,0.66333336,0.49871135,0.6666667,0.49871135,0.67,0.49871135,0.67333335,0.49871135,0.6766667,0.49871135,0.68,0.49871135,0.68333334,0.49871135,0.68666667,0.49871135,0.69,0.49871135,0.6933333,0.49871135,0.69666666,0.49871135,0.86,0.49871135,0.86333334,0.49871135,0.8666667,0.49871135,0.87,0.49871135,0.87333333,0.49871135,0.87666667,0.49871135,0.88,0.49871135,0.8833333,0.49871135,0.88666666,0.49871135,0.89,0.49871135,0.8933333,0.49871135,0.89666665,0.49871135,0.9,0.49871135,0.9033333,0.49871135,0.9066667,0.49871135,0.91,0.49871135,0.91333336,0.49871135,0.9166667,0.49871135,0.92,0.49871135,0.92333335,0.49871135,0.9266667,0.49871135,0.07,0.50128865,0.07333333,0.50128865,0.07666667,0.50128865,0.08,0.50128865,0.083333336,0.50128865,0.086666666,0.50128865,0.09,0.50128865,0.093333334,0.50128865,0.096666664,0.50128865,0.1,0.50128865,0.10333333,0.50128865,0.10666667,0.50128865,0.11,0.50128865,0.11333334,0.50128865,0.11666667,0.50128865,0.12,0.50128865,0.123333335,0.50128865,0.12666667,0.50128865,0.13,0.50128865,0.13333334,0.50128865,0.13666667,0.50128865,0.14,0.50128865,0.14666666,0.50128865,0.15,0.50128865,0.15333334,0.50128865,0.15666667,0.50128865,0.16,0.50128865,0.16333333,0.50128865,0.16666667,0.50128865,0.17,0.50128865,0.17333333,0.50128865,0.17666666,0.50128865,0.18,0.50128865,0.18333334,0.50128865,0.18666667,0.50128865,0.19,0.50128865,0.19333333,0.50128865,0.19666667,0.50128865,0.2,0.50128865,0.20333333,0.50128865,0.20666666,0.50128865,0.21,0.50128865,0.21333334,0.50128865,0.21666667,0.50128865,0.22,0.50128865,0.22333333,0.50128865,0.22666667,0.50128865,0.23,0.50128865,0.23333333,0.50128865,0.23666666,0.50128865,0.24,0.50128865,0.24333334,0.50128865,0.24666667,0.50128865,0.25,0.50128865,0.25333333,0.50128865,0.26333332,0.50128865,0.26666668,0.50128865,0.27,0.50128865,0.27333334,0.50128865,0.27666667,0.50128865,0.28,0.50128865,0.28333333,0.50128865,0.28666666,0.50128865,0.29,0.50128865,0.29333332,0.50128865,0.29666665,0.50128865,0.3,0.50128865,0.30333334,0.50128865,0.35333332,0.50128865,0.35666665,0.50128865,0.36,0.50128865,0.36333334,0.50128865,0.36666667,0.50128865,0.37,0.50128865,0.37333333,0.50128865,0.37666667,0.50128865,0.38,0.50128865,0.38333333,0.50128865,0.38666666,0.50128865,0.39,0.50128865,0.39333335,0.50128865,0.39666668,0.50128865,0.4,0.50128865,0.40333334,0.50128865,0.40666667,0.50128865,0.41,0.50128865,0.41333333,0.50128865,0.41666666,0.50128865,0.42,0.50128865,0.42333335,0.50128865,0.42666668,0.50128865,0.43,0.50128865,0.43333334,0.50128865,0.43666667,0.50128865,0.44,0.50128865,0.44333333,0.50128865,0.44666666,0.50128865,0.45,0.50128865,0.45333335,0.50128865,0.45666668,0.50128865,0.46,0.50128865,0.46333334,0.50128865,0.46666667,0.50128865,0.47,0.50128865,0.47333333,0.50128865,0.48,0.50128865,0.48333332,0.50128865,0.48666668,0.50128865,0.49,0.50128865,0.49333334,0.50128865,0.49666667,0.50128865,0.5,0.50128865,0.50333333,0.50128865,0.50666666,0.50128865,0.51,0.50128865,0.5133333,0.50128865,0.51666665,0.50128865,0.52,0.50128865,0.5233333,0.50128865,0.52666664,0.50128865,0.53,0.50128865,0.53333336,0.50128865,0.5366667,0.50128865,0.54,0.50128865,0.54333335,0.50128865,0.5466667,0.50128865,0.55,0.50128865,0.55333334,0.50128865,0.5566667,0.50128865,0.56,0.50128865,0.56333333,0.50128865,0.56666666,0.50128865,0.57,0.50128865,0.5733333,0.50128865,0.57666665,0.50128865,0.58,0.50128865,0.5833333,0.50128865,0.58666664,0.50128865,0.59,0.50128865,0.5933333,0.50128865,0.5966667,0.50128865,0.6,0.50128865,0.60333335,0.50128865,0.6066667,0.50128865,0.61,0.50128865,0.61333334,0.50128865,0.6166667,0.50128865,0.62,0.50128865,0.62333333,0.50128865,0.6433333,0.50128865,0.64666665,0.50128865,0.65,0.50128865,0.6533333,0.50128865,0.6566667,0.50128865,0.66,0.50128865,0.66333336,0.50128865,0.6666667,0.50128865,0.67,0.50128865,0.67333335,0.50128865,0.6766667,0.50128865,0.68,0.50128865,0.68333334,0.50128865,0.68666667,0.50128865,0.69,0.50128865,0.6933333,0.50128865,0.69666666,0.50128865,0.81,0.50128865,0.81666666,0.50128865,0.86,0.50128865,0.86333334,0.50128865,0.8666667,0.50128865,0.87,0.50128865,0.87333333,0.50128865,0.87666667,0.50128865,0.88,0.50128865,0.8833333,0.50128865,0.88666666,0.50128865,0.89,0.50128865,0.8933333,0.50128865,0.89666665,0.50128865,0.9,0.50128865,0.9033333,0.50128865,0.9066667,0.50128865,0.91,0.50128865,0.91333336,0.50128865,0.9166667,0.50128865,0.92,0.50128865,0.92333335,0.50128865,0.9266667,0.50128865,0.06666667,0.50386596,0.07,0.50386596,0.07333333,0.50386596,0.07666667,0.50386596,0.08,0.50386596,0.083333336,0.50386596,0.086666666,0.50386596,0.09,0.50386596,0.093333334,0.50386596,0.096666664,0.50386596,0.1,0.50386596,0.10333333,0.50386596,0.10666667,0.50386596,0.11,0.50386596,0.11333334,0.50386596,0.11666667,0.50386596,0.12,0.50386596,0.123333335,0.50386596,0.12666667,0.50386596,0.13,0.50386596,0.13333334,0.50386596,0.13666667,0.50386596,0.14,0.50386596,0.14666666,0.50386596,0.15,0.50386596,0.15333334,0.50386596,0.15666667,0.50386596,0.16,0.50386596,0.16333333,0.50386596,0.16666667,0.50386596,0.17,0.50386596,0.17333333,0.50386596,0.17666666,0.50386596,0.18,0.50386596,0.18333334,0.50386596,0.18666667,0.50386596,0.19,0.50386596,0.19333333,0.50386596,0.19666667,0.50386596,0.2,0.50386596,0.20333333,0.50386596,0.20666666,0.50386596,0.21,0.50386596,0.21333334,0.50386596,0.21666667,0.50386596,0.22,0.50386596,0.22333333,0.50386596,0.22666667,0.50386596,0.23,0.50386596,0.23333333,0.50386596,0.23666666,0.50386596,0.24,0.50386596,0.24333334,0.50386596,0.24666667,0.50386596,0.25,0.50386596,0.25333333,0.50386596,0.26333332,0.50386596,0.26666668,0.50386596,0.27,0.50386596,0.27333334,0.50386596,0.27666667,0.50386596,0.28,0.50386596,0.28333333,0.50386596,0.28666666,0.50386596,0.29,0.50386596,0.29333332,0.50386596,0.29666665,0.50386596,0.3,0.50386596,0.30333334,0.50386596,0.35,0.50386596,0.35333332,0.50386596,0.35666665,0.50386596,0.36,0.50386596,0.36333334,0.50386596,0.36666667,0.50386596,0.37,0.50386596,0.37333333,0.50386596,0.37666667,0.50386596,0.38,0.50386596,0.38333333,0.50386596,0.38666666,0.50386596,0.39,0.50386596,0.39333335,0.50386596,0.39666668,0.50386596,0.4,0.50386596,0.40333334,0.50386596,0.40666667,0.50386596,0.41,0.50386596,0.41333333,0.50386596,0.41666666,0.50386596,0.42,0.50386596,0.42333335,0.50386596,0.42666668,0.50386596,0.43,0.50386596,0.43333334,0.50386596,0.43666667,0.50386596,0.44,0.50386596,0.44333333,0.50386596,0.44666666,0.50386596,0.45,0.50386596,0.45333335,0.50386596,0.45666668,0.50386596,0.46,0.50386596,0.46333334,0.50386596,0.46666667,0.50386596,0.47,0.50386596,0.48,0.50386596,0.48333332,0.50386596,0.48666668,0.50386596,0.49,0.50386596,0.49333334,0.50386596,0.49666667,0.50386596,0.5,0.50386596,0.50333333,0.50386596,0.50666666,0.50386596,0.51,0.50386596,0.5133333,0.50386596,0.51666665,0.50386596,0.52,0.50386596,0.5233333,0.50386596,0.52666664,0.50386596,0.53,0.50386596,0.53333336,0.50386596,0.5366667,0.50386596,0.54,0.50386596,0.54333335,0.50386596,0.5466667,0.50386596,0.55,0.50386596,0.55333334,0.50386596,0.5566667,0.50386596,0.56,0.50386596,0.56333333,0.50386596,0.56666666,0.50386596,0.57,0.50386596,0.5733333,0.50386596,0.57666665,0.50386596,0.58,0.50386596,0.5833333,0.50386596,0.58666664,0.50386596,0.59,0.50386596,0.5933333,0.50386596,0.5966667,0.50386596,0.6,0.50386596,0.60333335,0.50386596,0.6066667,0.50386596,0.61,0.50386596,0.61333334,0.50386596,0.6166667,0.50386596,0.62,0.50386596,0.62333333,0.50386596,0.64666665,0.50386596,0.65,0.50386596,0.6533333,0.50386596,0.6566667,0.50386596,0.66,0.50386596,0.66333336,0.50386596,0.6666667,0.50386596,0.67,0.50386596,0.67333335,0.50386596,0.6766667,0.50386596,0.68,0.50386596,0.68333334,0.50386596,0.68666667,0.50386596,0.69,0.50386596,0.6933333,0.50386596,0.69666666,0.50386596,0.81,0.50386596,0.81333333,0.50386596,0.81666666,0.50386596,0.82,0.50386596,0.86,0.50386596,0.86333334,0.50386596,0.8666667,0.50386596,0.87,0.50386596,0.87333333,0.50386596,0.88666666,0.50386596,0.89,0.50386596,0.8933333,0.50386596,0.89666665,0.50386596,0.9,0.50386596,0.9033333,0.50386596,0.9066667,0.50386596,0.91,0.50386596,0.91333336,0.50386596,0.9166667,0.50386596,0.92,0.50386596,0.92333335,0.50386596,0.9266667,0.50386596,0.06666667,0.5064433,0.07,0.5064433,0.07333333,0.5064433,0.07666667,0.5064433,0.08,0.5064433,0.083333336,0.5064433,0.086666666,0.5064433,0.09,0.5064433,0.093333334,0.5064433,0.096666664,0.5064433,0.1,0.5064433,0.10333333,0.5064433,0.10666667,0.5064433,0.11,0.5064433,0.11333334,0.5064433,0.11666667,0.5064433,0.12,0.5064433,0.123333335,0.5064433,0.12666667,0.5064433,0.13,0.5064433,0.13333334,0.5064433,0.13666667,0.5064433,0.14,0.5064433,0.14666666,0.5064433,0.15,0.5064433,0.15333334,0.5064433,0.15666667,0.5064433,0.16,0.5064433,0.16333333,0.5064433,0.16666667,0.5064433,0.17,0.5064433,0.17333333,0.5064433,0.17666666,0.5064433,0.18,0.5064433,0.18333334,0.5064433,0.18666667,0.5064433,0.19,0.5064433,0.19333333,0.5064433,0.19666667,0.5064433,0.2,0.5064433,0.20333333,0.5064433,0.20666666,0.5064433,0.21,0.5064433,0.21333334,0.5064433,0.21666667,0.5064433,0.22,0.5064433,0.22333333,0.5064433,0.22666667,0.5064433,0.23,0.5064433,0.23333333,0.5064433,0.23666666,0.5064433,0.24,0.5064433,0.24333334,0.5064433,0.24666667,0.5064433,0.25,0.5064433,0.25333333,0.5064433,0.26333332,0.5064433,0.26666668,0.5064433,0.27,0.5064433,0.27333334,0.5064433,0.27666667,0.5064433,0.28,0.5064433,0.28333333,0.5064433,0.28666666,0.5064433,0.29,0.5064433,0.29333332,0.5064433,0.29666665,0.5064433,0.3,0.5064433,0.35,0.5064433,0.35333332,0.5064433,0.35666665,0.5064433,0.36,0.5064433,0.36333334,0.5064433,0.36666667,0.5064433,0.37,0.5064433,0.37333333,0.5064433,0.37666667,0.5064433,0.38,0.5064433,0.38333333,0.5064433,0.38666666,0.5064433,0.39,0.5064433,0.39333335,0.5064433,0.39666668,0.5064433,0.4,0.5064433,0.40333334,0.5064433,0.40666667,0.5064433,0.41,0.5064433,0.41333333,0.5064433,0.41666666,0.5064433,0.42,0.5064433,0.42333335,0.5064433,0.42666668,0.5064433,0.43,0.5064433,0.43333334,0.5064433,0.43666667,0.5064433,0.44,0.5064433,0.44333333,0.5064433,0.44666666,0.5064433,0.45,0.5064433,0.45333335,0.5064433,0.45666668,0.5064433,0.46,0.5064433,0.46333334,0.5064433,0.46666667,0.5064433,0.47,0.5064433,0.47333333,0.5064433,0.47666666,0.5064433,0.48,0.5064433,0.48333332,0.5064433,0.48666668,0.5064433,0.49,0.5064433,0.49333334,0.5064433,0.49666667,0.5064433,0.5,0.5064433,0.50333333,0.5064433,0.50666666,0.5064433,0.51,0.5064433,0.5133333,0.5064433,0.51666665,0.5064433,0.52,0.5064433,0.5233333,0.5064433,0.52666664,0.5064433,0.53,0.5064433,0.53333336,0.5064433,0.5366667,0.5064433,0.54,0.5064433,0.54333335,0.5064433,0.5466667,0.5064433,0.55,0.5064433,0.55333334,0.5064433,0.5566667,0.5064433,0.56,0.5064433,0.56333333,0.5064433,0.56666666,0.5064433,0.57,0.5064433,0.5733333,0.5064433,0.57666665,0.5064433,0.58,0.5064433,0.5833333,0.5064433,0.58666664,0.5064433,0.59,0.5064433,0.5933333,0.5064433,0.5966667,0.5064433,0.6,0.5064433,0.60333335,0.5064433,0.6066667,0.5064433,0.61,0.5064433,0.61333334,0.5064433,0.6166667,0.5064433,0.62,0.5064433,0.65,0.5064433,0.6533333,0.5064433,0.6566667,0.5064433,0.66,0.5064433,0.66333336,0.5064433,0.6666667,0.5064433,0.67,0.5064433,0.67333335,0.5064433,0.6766667,0.5064433,0.68,0.5064433,0.68333334,0.5064433,0.68666667,0.5064433,0.69,0.5064433,0.6933333,0.5064433,0.69666666,0.5064433,0.81,0.5064433,0.81333333,0.5064433,0.81666666,0.5064433,0.82,0.5064433,0.82666665,0.5064433,0.83,0.5064433,0.8333333,0.5064433,0.86,0.5064433,0.86333334,0.5064433,0.8666667,0.5064433,0.87,0.5064433,0.8933333,0.5064433,0.89666665,0.5064433,0.9,0.5064433,0.9033333,0.5064433,0.9066667,0.5064433,0.91,0.5064433,0.91333336,0.5064433,0.9166667,0.5064433,0.92,0.5064433,0.92333335,0.5064433,0.9266667,0.5064433,0.06333333,0.5090206,0.06666667,0.5090206,0.07,0.5090206,0.07333333,0.5090206,0.07666667,0.5090206,0.08,0.5090206,0.083333336,0.5090206,0.086666666,0.5090206,0.09,0.5090206,0.093333334,0.5090206,0.096666664,0.5090206,0.1,0.5090206,0.10333333,0.5090206,0.10666667,0.5090206,0.11,0.5090206,0.11333334,0.5090206,0.11666667,0.5090206,0.12,0.5090206,0.123333335,0.5090206,0.12666667,0.5090206,0.13,0.5090206,0.13333334,0.5090206,0.13666667,0.5090206,0.14,0.5090206,0.14666666,0.5090206,0.15,0.5090206,0.15333334,0.5090206,0.15666667,0.5090206,0.16,0.5090206,0.16333333,0.5090206,0.16666667,0.5090206,0.17,0.5090206,0.17333333,0.5090206,0.17666666,0.5090206,0.18,0.5090206,0.18333334,0.5090206,0.18666667,0.5090206,0.19,0.5090206,0.19333333,0.5090206,0.19666667,0.5090206,0.2,0.5090206,0.20333333,0.5090206,0.20666666,0.5090206,0.21,0.5090206,0.21333334,0.5090206,0.21666667,0.5090206,0.22,0.5090206,0.22333333,0.5090206,0.22666667,0.5090206,0.23,0.5090206,0.23333333,0.5090206,0.23666666,0.5090206,0.24,0.5090206,0.24333334,0.5090206,0.24666667,0.5090206,0.25,0.5090206,0.26333332,0.5090206,0.26666668,0.5090206,0.27,0.5090206,0.27333334,0.5090206,0.27666667,0.5090206,0.28,0.5090206,0.28333333,0.5090206,0.28666666,0.5090206,0.29,0.5090206,0.29333332,0.5090206,0.29666665,0.5090206,0.3,0.5090206,0.30333334,0.5090206,0.35,0.5090206,0.35333332,0.5090206,0.35666665,0.5090206,0.36,0.5090206,0.36333334,0.5090206,0.36666667,0.5090206,0.37,0.5090206,0.37333333,0.5090206,0.37666667,0.5090206,0.38,0.5090206,0.38333333,0.5090206,0.38666666,0.5090206,0.39,0.5090206,0.39333335,0.5090206,0.39666668,0.5090206,0.4,0.5090206,0.40333334,0.5090206,0.40666667,0.5090206,0.41,0.5090206,0.41333333,0.5090206,0.41666666,0.5090206,0.42,0.5090206,0.42333335,0.5090206,0.42666668,0.5090206,0.43,0.5090206,0.43333334,0.5090206,0.43666667,0.5090206,0.44,0.5090206,0.44333333,0.5090206,0.44666666,0.5090206,0.45,0.5090206,0.45333335,0.5090206,0.45666668,0.5090206,0.46,0.5090206,0.46333334,0.5090206,0.46666667,0.5090206,0.47,0.5090206,0.47333333,0.5090206,0.47666666,0.5090206,0.48,0.5090206,0.48333332,0.5090206,0.48666668,0.5090206,0.49,0.5090206,0.49333334,0.5090206,0.49666667,0.5090206,0.5,0.5090206,0.50333333,0.5090206,0.50666666,0.5090206,0.51,0.5090206,0.5133333,0.5090206,0.51666665,0.5090206,0.52,0.5090206,0.5233333,0.5090206,0.52666664,0.5090206,0.53,0.5090206,0.53333336,0.5090206,0.5366667,0.5090206,0.54,0.5090206,0.54333335,0.5090206,0.5466667,0.5090206,0.55,0.5090206,0.55333334,0.5090206,0.5566667,0.5090206,0.56,0.5090206,0.56333333,0.5090206,0.56666666,0.5090206,0.57,0.5090206,0.5733333,0.5090206,0.57666665,0.5090206,0.58,0.5090206,0.5833333,0.5090206,0.58666664,0.5090206,0.59,0.5090206,0.5933333,0.5090206,0.5966667,0.5090206,0.6,0.5090206,0.60333335,0.5090206,0.6066667,0.5090206,0.61,0.5090206,0.61333334,0.5090206,0.6166667,0.5090206,0.66,0.5090206,0.66333336,0.5090206,0.6666667,0.5090206,0.67,0.5090206,0.67333335,0.5090206,0.6766667,0.5090206,0.68,0.5090206,0.68333334,0.5090206,0.68666667,0.5090206,0.69,0.5090206,0.6933333,0.5090206,0.69666666,0.5090206,0.7,0.5090206,0.81,0.5090206,0.81333333,0.5090206,0.81666666,0.5090206,0.82,0.5090206,0.8233333,0.5090206,0.82666665,0.5090206,0.83,0.5090206,0.8333333,0.5090206,0.83666664,0.5090206,0.86,0.5090206,0.86333334,0.5090206,0.8666667,0.5090206,0.87,0.5090206,0.9,0.5090206,0.9033333,0.5090206,0.9066667,0.5090206,0.91,0.5090206,0.91333336,0.5090206,0.9166667,0.5090206,0.92,0.5090206,0.92333335,0.5090206,0.06333333,0.51159793,0.06666667,0.51159793,0.07,0.51159793,0.07333333,0.51159793,0.07666667,0.51159793,0.08,0.51159793,0.083333336,0.51159793,0.086666666,0.51159793,0.09,0.51159793,0.093333334,0.51159793,0.096666664,0.51159793,0.1,0.51159793,0.10333333,0.51159793,0.10666667,0.51159793,0.11,0.51159793,0.11333334,0.51159793,0.11666667,0.51159793,0.12,0.51159793,0.123333335,0.51159793,0.12666667,0.51159793,0.13,0.51159793,0.13333334,0.51159793,0.13666667,0.51159793,0.14,0.51159793,0.15333334,0.51159793,0.15666667,0.51159793,0.16,0.51159793,0.16333333,0.51159793,0.16666667,0.51159793,0.17,0.51159793,0.17333333,0.51159793,0.17666666,0.51159793,0.18,0.51159793,0.18333334,0.51159793,0.18666667,0.51159793,0.19,0.51159793,0.19333333,0.51159793,0.19666667,0.51159793,0.2,0.51159793,0.20333333,0.51159793,0.20666666,0.51159793,0.21,0.51159793,0.21333334,0.51159793,0.21666667,0.51159793,0.22,0.51159793,0.22333333,0.51159793,0.22666667,0.51159793,0.23,0.51159793,0.23333333,0.51159793,0.25666666,0.51159793,0.26,0.51159793,0.26333332,0.51159793,0.26666668,0.51159793,0.27,0.51159793,0.27333334,0.51159793,0.27666667,0.51159793,0.28,0.51159793,0.28333333,0.51159793,0.28666666,0.51159793,0.29,0.51159793,0.29333332,0.51159793,0.29666665,0.51159793,0.3,0.51159793,0.30333334,0.51159793,0.35,0.51159793,0.35333332,0.51159793,0.35666665,0.51159793,0.36,0.51159793,0.36333334,0.51159793,0.36666667,0.51159793,0.37,0.51159793,0.38666666,0.51159793,0.39,0.51159793,0.39333335,0.51159793,0.39666668,0.51159793,0.4,0.51159793,0.40333334,0.51159793,0.40666667,0.51159793,0.41,0.51159793,0.41333333,0.51159793,0.41666666,0.51159793,0.42,0.51159793,0.42333335,0.51159793,0.42666668,0.51159793,0.43,0.51159793,0.43333334,0.51159793,0.43666667,0.51159793,0.44,0.51159793,0.44333333,0.51159793,0.44666666,0.51159793,0.45,0.51159793,0.45333335,0.51159793,0.45666668,0.51159793,0.46,0.51159793,0.46333334,0.51159793,0.46666667,0.51159793,0.47,0.51159793,0.47333333,0.51159793,0.47666666,0.51159793,0.48,0.51159793,0.48333332,0.51159793,0.48666668,0.51159793,0.49,0.51159793,0.49333334,0.51159793,0.49666667,0.51159793,0.5,0.51159793,0.50333333,0.51159793,0.50666666,0.51159793,0.51,0.51159793,0.5133333,0.51159793,0.51666665,0.51159793,0.52,0.51159793,0.5233333,0.51159793,0.52666664,0.51159793,0.53,0.51159793,0.53333336,0.51159793,0.5366667,0.51159793,0.54,0.51159793,0.54333335,0.51159793,0.5466667,0.51159793,0.55,0.51159793,0.55333334,0.51159793,0.5566667,0.51159793,0.56,0.51159793,0.56333333,0.51159793,0.56666666,0.51159793,0.57,0.51159793,0.5733333,0.51159793,0.6,0.51159793,0.60333335,0.51159793,0.6066667,0.51159793,0.6766667,0.51159793,0.68,0.51159793,0.68333334,0.51159793,0.68666667,0.51159793,0.69,0.51159793,0.6933333,0.51159793,0.69666666,0.51159793,0.7,0.51159793,0.81,0.51159793,0.81333333,0.51159793,0.81666666,0.51159793,0.82,0.51159793,0.8233333,0.51159793,0.82666665,0.51159793,0.83,0.51159793,0.8333333,0.51159793,0.86,0.51159793,0.86333334,0.51159793,0.8666667,0.51159793,0.87,0.51159793,0.9066667,0.51159793,0.91,0.51159793,0.91333336,0.51159793,0.9166667,0.51159793,0.92,0.51159793,0.92333335,0.51159793,0.06333333,0.51417524,0.06666667,0.51417524,0.07,0.51417524,0.07333333,0.51417524,0.07666667,0.51417524,0.08,0.51417524,0.083333336,0.51417524,0.086666666,0.51417524,0.09,0.51417524,0.093333334,0.51417524,0.096666664,0.51417524,0.1,0.51417524,0.10333333,0.51417524,0.10666667,0.51417524,0.11,0.51417524,0.11333334,0.51417524,0.11666667,0.51417524,0.12,0.51417524,0.123333335,0.51417524,0.12666667,0.51417524,0.13,0.51417524,0.13333334,0.51417524,0.13666667,0.51417524,0.14,0.51417524,0.16,0.51417524,0.16333333,0.51417524,0.16666667,0.51417524,0.17,0.51417524,0.17333333,0.51417524,0.17666666,0.51417524,0.18,0.51417524,0.18333334,0.51417524,0.18666667,0.51417524,0.19,0.51417524,0.19333333,0.51417524,0.19666667,0.51417524,0.2,0.51417524,0.20333333,0.51417524,0.25,0.51417524,0.25333333,0.51417524,0.25666666,0.51417524,0.26,0.51417524,0.26333332,0.51417524,0.26666668,0.51417524,0.27,0.51417524,0.27333334,0.51417524,0.27666667,0.51417524,0.28,0.51417524,0.28333333,0.51417524,0.28666666,0.51417524,0.29,0.51417524,0.29333332,0.51417524,0.29666665,0.51417524,0.3,0.51417524,0.30333334,0.51417524,0.30666667,0.51417524,0.35333332,0.51417524,0.35666665,0.51417524,0.36,0.51417524,0.36333334,0.51417524,0.39,0.51417524,0.39333335,0.51417524,0.39666668,0.51417524,0.4,0.51417524,0.40333334,0.51417524,0.40666667,0.51417524,0.41,0.51417524,0.41333333,0.51417524,0.41666666,0.51417524,0.42,0.51417524,0.42333335,0.51417524,0.42666668,0.51417524,0.43,0.51417524,0.43333334,0.51417524,0.43666667,0.51417524,0.44,0.51417524,0.44333333,0.51417524,0.44666666,0.51417524,0.45,0.51417524,0.45333335,0.51417524,0.45666668,0.51417524,0.46,0.51417524,0.46333334,0.51417524,0.46666667,0.51417524,0.47,0.51417524,0.47333333,0.51417524,0.47666666,0.51417524,0.48,0.51417524,0.48333332,0.51417524,0.48666668,0.51417524,0.49,0.51417524,0.49333334,0.51417524,0.49666667,0.51417524,0.5,0.51417524,0.50333333,0.51417524,0.50666666,0.51417524,0.51,0.51417524,0.5133333,0.51417524,0.51666665,0.51417524,0.52,0.51417524,0.5233333,0.51417524,0.52666664,0.51417524,0.53,0.51417524,0.53333336,0.51417524,0.5366667,0.51417524,0.54,0.51417524,0.54333335,0.51417524,0.5466667,0.51417524,0.55,0.51417524,0.55333334,0.51417524,0.5566667,0.51417524,0.56,0.51417524,0.56333333,0.51417524,0.56666666,0.51417524,0.57,0.51417524,0.6766667,0.51417524,0.68,0.51417524,0.68333334,0.51417524,0.68666667,0.51417524,0.69,0.51417524,0.6933333,0.51417524,0.69666666,0.51417524,0.7,0.51417524,0.8233333,0.51417524,0.82666665,0.51417524,0.83,0.51417524,0.8333333,0.51417524,0.86,0.51417524,0.86333334,0.51417524,0.8666667,0.51417524,0.87,0.51417524,0.06333333,0.5167526,0.06666667,0.5167526,0.07,0.5167526,0.07333333,0.5167526,0.07666667,0.5167526,0.08,0.5167526,0.083333336,0.5167526,0.086666666,0.5167526,0.09,0.5167526,0.093333334,0.5167526,0.096666664,0.5167526,0.1,0.5167526,0.10333333,0.5167526,0.10666667,0.5167526,0.12666667,0.5167526,0.13,0.5167526,0.13333334,0.5167526,0.13666667,0.5167526,0.14,0.5167526,0.14333333,0.5167526,0.14666666,0.5167526,0.15,0.5167526,0.16666667,0.5167526,0.17,0.5167526,0.23666666,0.5167526,0.24,0.5167526,0.24333334,0.5167526,0.24666667,0.5167526,0.25,0.5167526,0.25333333,0.5167526,0.25666666,0.5167526,0.26,0.5167526,0.26333332,0.5167526,0.26666668,0.5167526,0.27,0.5167526,0.27333334,0.5167526,0.27666667,0.5167526,0.28,0.5167526,0.28333333,0.5167526,0.28666666,0.5167526,0.29,0.5167526,0.29333332,0.5167526,0.29666665,0.5167526,0.3,0.5167526,0.30333334,0.5167526,0.30666667,0.5167526,0.39333335,0.5167526,0.39666668,0.5167526,0.4,0.5167526,0.40333334,0.5167526,0.40666667,0.5167526,0.41,0.5167526,0.41333333,0.5167526,0.41666666,0.5167526,0.42,0.5167526,0.42333335,0.5167526,0.42666668,0.5167526,0.43,0.5167526,0.43333334,0.5167526,0.43666667,0.5167526,0.44,0.5167526,0.44333333,0.5167526,0.44666666,0.5167526,0.45,0.5167526,0.45333335,0.5167526,0.45666668,0.5167526,0.46,0.5167526,0.46333334,0.5167526,0.46666667,0.5167526,0.47,0.5167526,0.47333333,0.5167526,0.47666666,0.5167526,0.48,0.5167526,0.48333332,0.5167526,0.48666668,0.5167526,0.49,0.5167526,0.49333334,0.5167526,0.49666667,0.5167526,0.5,0.5167526,0.50333333,0.5167526,0.50666666,0.5167526,0.51,0.5167526,0.5133333,0.5167526,0.51666665,0.5167526,0.52,0.5167526,0.5233333,0.5167526,0.52666664,0.5167526,0.53,0.5167526,0.53333336,0.5167526,0.5366667,0.5167526,0.54,0.5167526,0.54333335,0.5167526,0.5466667,0.5167526,0.55,0.5167526,0.55333334,0.5167526,0.5566667,0.5167526,0.56,0.5167526,0.56333333,0.5167526,0.56666666,0.5167526,0.57,0.5167526,0.68,0.5167526,0.68333334,0.5167526,0.68666667,0.5167526,0.69,0.5167526,0.6933333,0.5167526,0.69666666,0.5167526,0.7,0.5167526,0.73333335,0.5167526,0.7366667,0.5167526,0.74,0.5167526,0.74333334,0.5167526,0.74666667,0.5167526,0.86,0.5167526,0.86333334,0.5167526,0.8666667,0.5167526,0.87,0.5167526,0.06333333,0.5193299,0.06666667,0.5193299,0.07,0.5193299,0.07333333,0.5193299,0.07666667,0.5193299,0.08,0.5193299,0.083333336,0.5193299,0.086666666,0.5193299,0.09,0.5193299,0.093333334,0.5193299,0.096666664,0.5193299,0.1,0.5193299,0.12666667,0.5193299,0.13,0.5193299,0.13333334,0.5193299,0.13666667,0.5193299,0.14,0.5193299,0.14333333,0.5193299,0.14666666,0.5193299,0.15,0.5193299,0.15333334,0.5193299,0.15666667,0.5193299,0.16,0.5193299,0.16333333,0.5193299,0.16666667,0.5193299,0.17,0.5193299,0.17333333,0.5193299,0.22333333,0.5193299,0.22666667,0.5193299,0.23,0.5193299,0.23333333,0.5193299,0.23666666,0.5193299,0.24,0.5193299,0.24333334,0.5193299,0.24666667,0.5193299,0.25,0.5193299,0.25333333,0.5193299,0.25666666,0.5193299,0.26,0.5193299,0.26333332,0.5193299,0.26666668,0.5193299,0.27,0.5193299,0.27333334,0.5193299,0.27666667,0.5193299,0.28,0.5193299,0.28333333,0.5193299,0.28666666,0.5193299,0.29,0.5193299,0.29333332,0.5193299,0.29666665,0.5193299,0.3,0.5193299,0.30333334,0.5193299,0.30666667,0.5193299,0.31,0.5193299,0.39333335,0.5193299,0.39666668,0.5193299,0.4,0.5193299,0.40333334,0.5193299,0.40666667,0.5193299,0.41,0.5193299,0.41333333,0.5193299,0.41666666,0.5193299,0.42,0.5193299,0.42333335,0.5193299,0.42666668,0.5193299,0.43,0.5193299,0.43333334,0.5193299,0.43666667,0.5193299,0.44,0.5193299,0.44333333,0.5193299,0.44666666,0.5193299,0.45,0.5193299,0.45333335,0.5193299,0.45666668,0.5193299,0.46,0.5193299,0.46333334,0.5193299,0.46666667,0.5193299,0.47,0.5193299,0.47333333,0.5193299,0.47666666,0.5193299,0.48,0.5193299,0.48333332,0.5193299,0.48666668,0.5193299,0.49,0.5193299,0.49333334,0.5193299,0.49666667,0.5193299,0.5,0.5193299,0.50333333,0.5193299,0.50666666,0.5193299,0.51,0.5193299,0.5133333,0.5193299,0.51666665,0.5193299,0.52,0.5193299,0.5233333,0.5193299,0.52666664,0.5193299,0.53,0.5193299,0.53333336,0.5193299,0.5366667,0.5193299,0.54,0.5193299,0.54333335,0.5193299,0.5466667,0.5193299,0.55,0.5193299,0.55333334,0.5193299,0.5566667,0.5193299,0.56,0.5193299,0.56333333,0.5193299,0.56666666,0.5193299,0.57,0.5193299,0.68,0.5193299,0.68333334,0.5193299,0.68666667,0.5193299,0.69,0.5193299,0.6933333,0.5193299,0.69666666,0.5193299,0.7,0.5193299,0.7033333,0.5193299,0.70666665,0.5193299,0.71,0.5193299,0.7133333,0.5193299,0.7266667,0.5193299,0.73,0.5193299,0.73333335,0.5193299,0.7366667,0.5193299,0.74,0.5193299,0.74333334,0.5193299,0.74666667,0.5193299,0.75,0.5193299,0.86,0.5193299,0.86333334,0.5193299,0.8666667,0.5193299,0.87,0.5193299,0.87333333,0.5193299,0.06333333,0.5219072,0.06666667,0.5219072,0.07,0.5219072,0.07333333,0.5219072,0.07666667,0.5219072,0.08,0.5219072,0.083333336,0.5219072,0.086666666,0.5219072,0.09,0.5219072,0.093333334,0.5219072,0.12666667,0.5219072,0.13,0.5219072,0.13333334,0.5219072,0.13666667,0.5219072,0.14,0.5219072,0.14333333,0.5219072,0.14666666,0.5219072,0.15,0.5219072,0.15333334,0.5219072,0.15666667,0.5219072,0.16,0.5219072,0.16333333,0.5219072,0.16666667,0.5219072,0.17,0.5219072,0.17333333,0.5219072,0.17666666,0.5219072,0.18,0.5219072,0.18333334,0.5219072,0.18666667,0.5219072,0.19,0.5219072,0.19333333,0.5219072,0.19666667,0.5219072,0.2,0.5219072,0.20333333,0.5219072,0.20666666,0.5219072,0.21,0.5219072,0.21333334,0.5219072,0.21666667,0.5219072,0.22,0.5219072,0.22333333,0.5219072,0.22666667,0.5219072,0.23,0.5219072,0.23333333,0.5219072,0.23666666,0.5219072,0.24,0.5219072,0.24333334,0.5219072,0.24666667,0.5219072,0.25,0.5219072,0.25333333,0.5219072,0.25666666,0.5219072,0.26,0.5219072,0.26333332,0.5219072,0.26666668,0.5219072,0.27,0.5219072,0.27333334,0.5219072,0.27666667,0.5219072,0.28,0.5219072,0.28333333,0.5219072,0.28666666,0.5219072,0.29,0.5219072,0.29333332,0.5219072,0.29666665,0.5219072,0.3,0.5219072,0.30333334,0.5219072,0.30666667,0.5219072,0.31,0.5219072,0.39333335,0.5219072,0.39666668,0.5219072,0.4,0.5219072,0.40333334,0.5219072,0.40666667,0.5219072,0.41,0.5219072,0.41333333,0.5219072,0.41666666,0.5219072,0.42,0.5219072,0.42333335,0.5219072,0.42666668,0.5219072,0.43,0.5219072,0.43333334,0.5219072,0.43666667,0.5219072,0.44,0.5219072,0.44333333,0.5219072,0.44666666,0.5219072,0.45,0.5219072,0.45333335,0.5219072,0.45666668,0.5219072,0.46,0.5219072,0.46333334,0.5219072,0.46666667,0.5219072,0.47,0.5219072,0.47333333,0.5219072,0.47666666,0.5219072,0.48,0.5219072,0.48333332,0.5219072,0.48666668,0.5219072,0.49,0.5219072,0.49333334,0.5219072,0.49666667,0.5219072,0.5,0.5219072,0.50333333,0.5219072,0.50666666,0.5219072,0.51,0.5219072,0.5133333,0.5219072,0.51666665,0.5219072,0.52,0.5219072,0.5233333,0.5219072,0.52666664,0.5219072,0.53,0.5219072,0.53333336,0.5219072,0.5366667,0.5219072,0.54,0.5219072,0.54333335,0.5219072,0.5466667,0.5219072,0.55,0.5219072,0.55333334,0.5219072,0.5566667,0.5219072,0.56,0.5219072,0.56333333,0.5219072,0.56666666,0.5219072,0.57,0.5219072,0.6766667,0.5219072,0.68,0.5219072,0.68333334,0.5219072,0.68666667,0.5219072,0.69,0.5219072,0.6933333,0.5219072,0.69666666,0.5219072,0.7,0.5219072,0.7033333,0.5219072,0.70666665,0.5219072,0.71,0.5219072,0.7133333,0.5219072,0.71666664,0.5219072,0.72,0.5219072,0.72333336,0.5219072,0.7266667,0.5219072,0.73,0.5219072,0.73333335,0.5219072,0.7366667,0.5219072,0.74,0.5219072,0.74333334,0.5219072,0.74666667,0.5219072,0.75,0.5219072,0.79333335,0.5219072,0.7966667,0.5219072,0.8,0.5219072,0.80333334,0.5219072,0.8066667,0.5219072,0.81,0.5219072,0.81333333,0.5219072,0.81666666,0.5219072,0.8566667,0.5219072,0.86,0.5219072,0.86333334,0.5219072,0.8666667,0.5219072,0.87,0.5219072,0.87333333,0.5219072,0.87666667,0.5219072,0.06666667,0.5244845,0.07,0.5244845,0.07333333,0.5244845,0.07666667,0.5244845,0.08,0.5244845,0.083333336,0.5244845,0.12666667,0.5244845,0.13,0.5244845,0.13333334,0.5244845,0.13666667,0.5244845,0.14,0.5244845,0.14333333,0.5244845,0.14666666,0.5244845,0.15,0.5244845,0.15333334,0.5244845,0.15666667,0.5244845,0.16,0.5244845,0.16333333,0.5244845,0.16666667,0.5244845,0.17,0.5244845,0.17333333,0.5244845,0.17666666,0.5244845,0.18,0.5244845,0.18333334,0.5244845,0.18666667,0.5244845,0.19,0.5244845,0.19333333,0.5244845,0.19666667,0.5244845,0.2,0.5244845,0.20333333,0.5244845,0.20666666,0.5244845,0.21,0.5244845,0.21333334,0.5244845,0.21666667,0.5244845,0.22,0.5244845,0.22333333,0.5244845,0.22666667,0.5244845,0.23,0.5244845,0.23333333,0.5244845,0.23666666,0.5244845,0.24,0.5244845,0.24333334,0.5244845,0.24666667,0.5244845,0.25,0.5244845,0.25333333,0.5244845,0.25666666,0.5244845,0.26,0.5244845,0.26333332,0.5244845,0.26666668,0.5244845,0.27,0.5244845,0.27333334,0.5244845,0.27666667,0.5244845,0.28,0.5244845,0.28333333,0.5244845,0.28666666,0.5244845,0.29,0.5244845,0.29333332,0.5244845,0.29666665,0.5244845,0.3,0.5244845,0.30333334,0.5244845,0.30666667,0.5244845,0.31,0.5244845,0.39333335,0.5244845,0.39666668,0.5244845,0.4,0.5244845,0.40333334,0.5244845,0.40666667,0.5244845,0.41,0.5244845,0.41333333,0.5244845,0.42666668,0.5244845,0.43,0.5244845,0.43333334,0.5244845,0.43666667,0.5244845,0.44,0.5244845,0.44333333,0.5244845,0.44666666,0.5244845,0.45,0.5244845,0.45333335,0.5244845,0.45666668,0.5244845,0.46,0.5244845,0.46333334,0.5244845,0.46666667,0.5244845,0.47,0.5244845,0.47333333,0.5244845,0.47666666,0.5244845,0.48,0.5244845,0.48333332,0.5244845,0.48666668,0.5244845,0.49,0.5244845,0.49333334,0.5244845,0.49666667,0.5244845,0.5,0.5244845,0.50333333,0.5244845,0.50666666,0.5244845,0.51,0.5244845,0.5133333,0.5244845,0.51666665,0.5244845,0.52,0.5244845,0.5233333,0.5244845,0.52666664,0.5244845,0.53,0.5244845,0.53333336,0.5244845,0.5366667,0.5244845,0.54,0.5244845,0.54333335,0.5244845,0.5466667,0.5244845,0.55,0.5244845,0.55333334,0.5244845,0.5566667,0.5244845,0.56,0.5244845,0.56333333,0.5244845,0.56666666,0.5244845,0.57,0.5244845,0.6766667,0.5244845,0.68,0.5244845,0.68333334,0.5244845,0.68666667,0.5244845,0.69,0.5244845,0.6933333,0.5244845,0.69666666,0.5244845,0.7,0.5244845,0.7033333,0.5244845,0.70666665,0.5244845,0.71,0.5244845,0.7133333,0.5244845,0.71666664,0.5244845,0.72,0.5244845,0.72333336,0.5244845,0.7266667,0.5244845,0.73,0.5244845,0.73333335,0.5244845,0.7366667,0.5244845,0.74,0.5244845,0.74333334,0.5244845,0.74666667,0.5244845,0.75,0.5244845,0.75333333,0.5244845,0.76,0.5244845,0.7633333,0.5244845,0.76666665,0.5244845,0.78333336,0.5244845,0.7866667,0.5244845,0.79,0.5244845,0.79333335,0.5244845,0.7966667,0.5244845,0.8,0.5244845,0.80333334,0.5244845,0.8066667,0.5244845,0.81,0.5244845,0.81333333,0.5244845,0.81666666,0.5244845,0.82,0.5244845,0.8233333,0.5244845,0.82666665,0.5244845,0.83,0.5244845,0.8333333,0.5244845,0.83666664,0.5244845,0.84,0.5244845,0.8433333,0.5244845,0.8466667,0.5244845,0.85,0.5244845,0.85333335,0.5244845,0.8566667,0.5244845,0.86,0.5244845,0.86333334,0.5244845,0.8666667,0.5244845,0.87,0.5244845,0.87333333,0.5244845,0.87666667,0.5244845,0.88,0.5244845,0.123333335,0.5270619,0.12666667,0.5270619,0.13,0.5270619,0.13333334,0.5270619,0.13666667,0.5270619,0.14,0.5270619,0.14333333,0.5270619,0.14666666,0.5270619,0.15,0.5270619,0.15333334,0.5270619,0.15666667,0.5270619,0.16,0.5270619,0.16333333,0.5270619,0.16666667,0.5270619,0.17,0.5270619,0.17333333,0.5270619,0.17666666,0.5270619,0.18,0.5270619,0.18333334,0.5270619,0.18666667,0.5270619,0.19,0.5270619,0.19333333,0.5270619,0.19666667,0.5270619,0.2,0.5270619,0.20333333,0.5270619,0.20666666,0.5270619,0.21,0.5270619,0.21333334,0.5270619,0.21666667,0.5270619,0.22,0.5270619,0.22333333,0.5270619,0.22666667,0.5270619,0.23,0.5270619,0.23333333,0.5270619,0.23666666,0.5270619,0.24,0.5270619,0.24333334,0.5270619,0.24666667,0.5270619,0.25,0.5270619,0.25333333,0.5270619,0.25666666,0.5270619,0.26,0.5270619,0.26333332,0.5270619,0.26666668,0.5270619,0.28,0.5270619,0.28333333,0.5270619,0.28666666,0.5270619,0.29,0.5270619,0.29333332,0.5270619,0.29666665,0.5270619,0.3,0.5270619,0.30333334,0.5270619,0.30666667,0.5270619,0.31,0.5270619,0.39333335,0.5270619,0.39666668,0.5270619,0.4,0.5270619,0.40333334,0.5270619,0.40666667,0.5270619,0.41,0.5270619,0.43,0.5270619,0.43333334,0.5270619,0.43666667,0.5270619,0.44,0.5270619,0.44333333,0.5270619,0.44666666,0.5270619,0.45,0.5270619,0.45333335,0.5270619,0.45666668,0.5270619,0.46,0.5270619,0.46333334,0.5270619,0.48666668,0.5270619,0.49,0.5270619,0.49333334,0.5270619,0.49666667,0.5270619,0.5,0.5270619,0.50333333,0.5270619,0.50666666,0.5270619,0.51,0.5270619,0.5133333,0.5270619,0.51666665,0.5270619,0.52,0.5270619,0.5233333,0.5270619,0.52666664,0.5270619,0.53,0.5270619,0.5366667,0.5270619,0.54,0.5270619,0.54333335,0.5270619,0.5466667,0.5270619,0.55,0.5270619,0.55333334,0.5270619,0.5566667,0.5270619,0.56,0.5270619,0.56333333,0.5270619,0.56666666,0.5270619,0.57,0.5270619,0.6766667,0.5270619,0.68,0.5270619,0.68333334,0.5270619,0.68666667,0.5270619,0.69,0.5270619,0.6933333,0.5270619,0.69666666,0.5270619,0.7,0.5270619,0.7033333,0.5270619,0.70666665,0.5270619,0.71,0.5270619,0.7133333,0.5270619,0.71666664,0.5270619,0.72,0.5270619,0.72333336,0.5270619,0.7266667,0.5270619,0.73,0.5270619,0.73333335,0.5270619,0.7366667,0.5270619,0.74,0.5270619,0.74333334,0.5270619,0.74666667,0.5270619,0.75,0.5270619,0.75333333,0.5270619,0.75666666,0.5270619,0.76,0.5270619,0.7633333,0.5270619,0.76666665,0.5270619,0.77,0.5270619,0.7733333,0.5270619,0.77666664,0.5270619,0.78,0.5270619,0.78333336,0.5270619,0.7866667,0.5270619,0.79,0.5270619,0.79333335,0.5270619,0.7966667,0.5270619,0.8,0.5270619,0.80333334,0.5270619,0.8066667,0.5270619,0.81,0.5270619,0.81333333,0.5270619,0.81666666,0.5270619,0.82,0.5270619,0.8233333,0.5270619,0.82666665,0.5270619,0.83,0.5270619,0.8333333,0.5270619,0.83666664,0.5270619,0.84,0.5270619,0.8433333,0.5270619,0.8466667,0.5270619,0.85,0.5270619,0.85333335,0.5270619,0.8566667,0.5270619,0.86,0.5270619,0.86333334,0.5270619,0.8666667,0.5270619,0.87,0.5270619,0.87333333,0.5270619,0.87666667,0.5270619,0.88,0.5270619,0.8833333,0.5270619,0.123333335,0.5296392,0.12666667,0.5296392,0.13,0.5296392,0.13333334,0.5296392,0.13666667,0.5296392,0.14,0.5296392,0.14333333,0.5296392,0.14666666,0.5296392,0.15,0.5296392,0.15333334,0.5296392,0.15666667,0.5296392,0.16,0.5296392,0.16333333,0.5296392,0.16666667,0.5296392,0.17,0.5296392,0.17333333,0.5296392,0.17666666,0.5296392,0.18,0.5296392,0.18333334,0.5296392,0.18666667,0.5296392,0.19,0.5296392,0.19333333,0.5296392,0.19666667,0.5296392,0.2,0.5296392,0.20333333,0.5296392,0.20666666,0.5296392,0.21,0.5296392,0.21333334,0.5296392,0.21666667,0.5296392,0.22,0.5296392,0.22333333,0.5296392,0.22666667,0.5296392,0.23,0.5296392,0.23333333,0.5296392,0.23666666,0.5296392,0.24,0.5296392,0.24333334,0.5296392,0.24666667,0.5296392,0.25,0.5296392,0.25333333,0.5296392,0.25666666,0.5296392,0.26,0.5296392,0.26333332,0.5296392,0.28,0.5296392,0.28333333,0.5296392,0.28666666,0.5296392,0.29,0.5296392,0.29333332,0.5296392,0.29666665,0.5296392,0.3,0.5296392,0.30333334,0.5296392,0.30666667,0.5296392,0.31,0.5296392,0.39,0.5296392,0.39333335,0.5296392,0.39666668,0.5296392,0.4,0.5296392,0.40333334,0.5296392,0.40666667,0.5296392,0.41,0.5296392,0.43,0.5296392,0.43333334,0.5296392,0.43666667,0.5296392,0.44,0.5296392,0.44333333,0.5296392,0.44666666,0.5296392,0.45,0.5296392,0.45333335,0.5296392,0.45666668,0.5296392,0.46,0.5296392,0.49333334,0.5296392,0.49666667,0.5296392,0.5,0.5296392,0.50333333,0.5296392,0.50666666,0.5296392,0.51,0.5296392,0.5133333,0.5296392,0.51666665,0.5296392,0.52,0.5296392,0.5233333,0.5296392,0.54333335,0.5296392,0.5466667,0.5296392,0.55,0.5296392,0.55333334,0.5296392,0.5566667,0.5296392,0.56,0.5296392,0.56333333,0.5296392,0.56666666,0.5296392,0.57,0.5296392,0.5733333,0.5296392,0.6766667,0.5296392,0.68,0.5296392,0.68333334,0.5296392,0.68666667,0.5296392,0.69,0.5296392,0.6933333,0.5296392,0.69666666,0.5296392,0.7,0.5296392,0.7033333,0.5296392,0.70666665,0.5296392,0.71,0.5296392,0.7133333,0.5296392,0.71666664,0.5296392,0.72,0.5296392,0.72333336,0.5296392,0.7266667,0.5296392,0.74,0.5296392,0.74333334,0.5296392,0.74666667,0.5296392,0.75,0.5296392,0.75333333,0.5296392,0.75666666,0.5296392,0.76,0.5296392,0.7633333,0.5296392,0.76666665,0.5296392,0.77,0.5296392,0.7733333,0.5296392,0.77666664,0.5296392,0.78,0.5296392,0.78333336,0.5296392,0.7866667,0.5296392,0.79,0.5296392,0.79333335,0.5296392,0.7966667,0.5296392,0.8,0.5296392,0.80333334,0.5296392,0.8066667,0.5296392,0.81,0.5296392,0.81333333,0.5296392,0.81666666,0.5296392,0.82,0.5296392,0.8233333,0.5296392,0.82666665,0.5296392,0.83,0.5296392,0.8333333,0.5296392,0.83666664,0.5296392,0.84,0.5296392,0.8433333,0.5296392,0.8466667,0.5296392,0.85,0.5296392,0.85333335,0.5296392,0.8566667,0.5296392,0.86,0.5296392,0.86333334,0.5296392,0.8666667,0.5296392,0.87,0.5296392,0.87333333,0.5296392,0.87666667,0.5296392,0.88,0.5296392,0.8833333,0.5296392,0.88666666,0.5296392,0.123333335,0.5322165,0.12666667,0.5322165,0.13,0.5322165,0.13333334,0.5322165,0.13666667,0.5322165,0.14,0.5322165,0.14333333,0.5322165,0.14666666,0.5322165,0.15,0.5322165,0.15333334,0.5322165,0.15666667,0.5322165,0.16,0.5322165,0.16333333,0.5322165,0.16666667,0.5322165,0.17,0.5322165,0.17333333,0.5322165,0.17666666,0.5322165,0.18,0.5322165,0.18333334,0.5322165,0.18666667,0.5322165,0.19,0.5322165,0.19333333,0.5322165,0.19666667,0.5322165,0.2,0.5322165,0.20333333,0.5322165,0.20666666,0.5322165,0.21,0.5322165,0.21333334,0.5322165,0.21666667,0.5322165,0.22,0.5322165,0.22333333,0.5322165,0.22666667,0.5322165,0.23,0.5322165,0.23333333,0.5322165,0.23666666,0.5322165,0.24,0.5322165,0.24333334,0.5322165,0.24666667,0.5322165,0.25,0.5322165,0.25333333,0.5322165,0.25666666,0.5322165,0.26,0.5322165,0.26333332,0.5322165,0.28,0.5322165,0.28333333,0.5322165,0.28666666,0.5322165,0.29,0.5322165,0.29333332,0.5322165,0.29666665,0.5322165,0.3,0.5322165,0.30333334,0.5322165,0.30666667,0.5322165,0.31,0.5322165,0.39,0.5322165,0.39333335,0.5322165,0.39666668,0.5322165,0.4,0.5322165,0.40333334,0.5322165,0.40666667,0.5322165,0.43,0.5322165,0.43333334,0.5322165,0.43666667,0.5322165,0.44,0.5322165,0.44333333,0.5322165,0.44666666,0.5322165,0.45,0.5322165,0.45333335,0.5322165,0.45666668,0.5322165,0.49666667,0.5322165,0.5,0.5322165,0.50333333,0.5322165,0.50666666,0.5322165,0.51,0.5322165,0.5133333,0.5322165,0.51666665,0.5322165,0.52,0.5322165,0.5466667,0.5322165,0.55,0.5322165,0.55333334,0.5322165,0.5566667,0.5322165,0.56,0.5322165,0.56333333,0.5322165,0.56666666,0.5322165,0.57,0.5322165,0.5733333,0.5322165,0.6766667,0.5322165,0.68,0.5322165,0.68333334,0.5322165,0.68666667,0.5322165,0.69,0.5322165,0.6933333,0.5322165,0.69666666,0.5322165,0.7,0.5322165,0.7033333,0.5322165,0.70666665,0.5322165,0.71,0.5322165,0.7133333,0.5322165,0.71666664,0.5322165,0.72,0.5322165,0.72333336,0.5322165,0.74,0.5322165,0.74333334,0.5322165,0.74666667,0.5322165,0.75,0.5322165,0.75333333,0.5322165,0.75666666,0.5322165,0.76,0.5322165,0.7633333,0.5322165,0.76666665,0.5322165,0.77,0.5322165,0.7733333,0.5322165,0.77666664,0.5322165,0.78,0.5322165,0.78333336,0.5322165,0.7866667,0.5322165,0.79,0.5322165,0.79333335,0.5322165,0.7966667,0.5322165,0.8,0.5322165,0.80333334,0.5322165,0.8066667,0.5322165,0.81,0.5322165,0.81333333,0.5322165,0.81666666,0.5322165,0.82,0.5322165,0.8233333,0.5322165,0.82666665,0.5322165,0.83,0.5322165,0.8333333,0.5322165,0.83666664,0.5322165,0.84,0.5322165,0.8433333,0.5322165,0.8466667,0.5322165,0.85,0.5322165,0.85333335,0.5322165,0.8566667,0.5322165,0.86,0.5322165,0.86333334,0.5322165,0.8666667,0.5322165,0.87,0.5322165,0.87333333,0.5322165,0.87666667,0.5322165,0.88,0.5322165,0.8833333,0.5322165,0.88666666,0.5322165,0.12,0.5347938,0.123333335,0.5347938,0.12666667,0.5347938,0.13,0.5347938,0.13333334,0.5347938,0.13666667,0.5347938,0.14,0.5347938,0.14333333,0.5347938,0.14666666,0.5347938,0.15,0.5347938,0.15333334,0.5347938,0.15666667,0.5347938,0.16,0.5347938,0.16333333,0.5347938,0.16666667,0.5347938,0.17,0.5347938,0.17333333,0.5347938,0.17666666,0.5347938,0.18,0.5347938,0.18333334,0.5347938,0.18666667,0.5347938,0.19,0.5347938,0.19333333,0.5347938,0.19666667,0.5347938,0.2,0.5347938,0.20333333,0.5347938,0.20666666,0.5347938,0.21,0.5347938,0.21333334,0.5347938,0.21666667,0.5347938,0.23,0.5347938,0.23333333,0.5347938,0.23666666,0.5347938,0.24,0.5347938,0.24333334,0.5347938,0.24666667,0.5347938,0.25,0.5347938,0.25333333,0.5347938,0.25666666,0.5347938,0.26,0.5347938,0.26333332,0.5347938,0.28333333,0.5347938,0.28666666,0.5347938,0.29,0.5347938,0.29333332,0.5347938,0.29666665,0.5347938,0.3,0.5347938,0.30333334,0.5347938,0.30666667,0.5347938,0.31,0.5347938,0.39,0.5347938,0.39333335,0.5347938,0.39666668,0.5347938,0.4,0.5347938,0.40333334,0.5347938,0.40666667,0.5347938,0.43333334,0.5347938,0.43666667,0.5347938,0.44,0.5347938,0.44333333,0.5347938,0.44666666,0.5347938,0.45,0.5347938,0.45333335,0.5347938,0.45666668,0.5347938,0.49666667,0.5347938,0.5,0.5347938,0.50333333,0.5347938,0.50666666,0.5347938,0.51,0.5347938,0.5133333,0.5347938,0.51666665,0.5347938,0.5466667,0.5347938,0.55,0.5347938,0.55333334,0.5347938,0.5566667,0.5347938,0.56,0.5347938,0.56333333,0.5347938,0.56666666,0.5347938,0.57,0.5347938,0.5733333,0.5347938,0.57666665,0.5347938,0.6766667,0.5347938,0.68,0.5347938,0.68333334,0.5347938,0.68666667,0.5347938,0.69,0.5347938,0.6933333,0.5347938,0.69666666,0.5347938,0.7,0.5347938,0.7033333,0.5347938,0.70666665,0.5347938,0.71,0.5347938,0.7133333,0.5347938,0.71666664,0.5347938,0.72,0.5347938,0.74,0.5347938,0.74333334,0.5347938,0.74666667,0.5347938,0.75,0.5347938,0.75333333,0.5347938,0.75666666,0.5347938,0.76,0.5347938,0.7633333,0.5347938,0.76666665,0.5347938,0.77,0.5347938,0.7733333,0.5347938,0.77666664,0.5347938,0.78,0.5347938,0.78333336,0.5347938,0.7866667,0.5347938,0.79,0.5347938,0.79333335,0.5347938,0.7966667,0.5347938,0.8,0.5347938,0.80333334,0.5347938,0.8066667,0.5347938,0.81,0.5347938,0.81333333,0.5347938,0.81666666,0.5347938,0.82,0.5347938,0.8233333,0.5347938,0.82666665,0.5347938,0.83,0.5347938,0.8333333,0.5347938,0.83666664,0.5347938,0.84,0.5347938,0.8433333,0.5347938,0.8466667,0.5347938,0.85,0.5347938,0.85333335,0.5347938,0.8566667,0.5347938,0.86,0.5347938,0.86333334,0.5347938,0.8666667,0.5347938,0.87,0.5347938,0.87333333,0.5347938,0.87666667,0.5347938,0.88,0.5347938,0.8833333,0.5347938,0.88666666,0.5347938,0.89,0.5347938,0.123333335,0.53737116,0.12666667,0.53737116,0.13,0.53737116,0.13333334,0.53737116,0.13666667,0.53737116,0.14,0.53737116,0.14333333,0.53737116,0.14666666,0.53737116,0.15,0.53737116,0.15333334,0.53737116,0.15666667,0.53737116,0.16,0.53737116,0.16333333,0.53737116,0.16666667,0.53737116,0.17,0.53737116,0.17333333,0.53737116,0.17666666,0.53737116,0.18,0.53737116,0.18333334,0.53737116,0.18666667,0.53737116,0.19,0.53737116,0.19333333,0.53737116,0.19666667,0.53737116,0.2,0.53737116,0.20333333,0.53737116,0.20666666,0.53737116,0.21,0.53737116,0.23333333,0.53737116,0.23666666,0.53737116,0.24,0.53737116,0.24333334,0.53737116,0.24666667,0.53737116,0.25,0.53737116,0.25333333,0.53737116,0.25666666,0.53737116,0.26,0.53737116,0.26333332,0.53737116,0.28333333,0.53737116,0.28666666,0.53737116,0.29,0.53737116,0.29333332,0.53737116,0.29666665,0.53737116,0.3,0.53737116,0.30333334,0.53737116,0.30666667,0.53737116,0.39,0.53737116,0.39333335,0.53737116,0.39666668,0.53737116,0.4,0.53737116,0.40333334,0.53737116,0.43333334,0.53737116,0.43666667,0.53737116,0.44,0.53737116,0.44333333,0.53737116,0.44666666,0.53737116,0.45,0.53737116,0.45333335,0.53737116,0.5,0.53737116,0.50333333,0.53737116,0.50666666,0.53737116,0.51,0.53737116,0.5133333,0.53737116,0.51666665,0.53737116,0.55,0.53737116,0.55333334,0.53737116,0.5566667,0.53737116,0.56,0.53737116,0.56333333,0.53737116,0.56666666,0.53737116,0.57,0.53737116,0.5733333,0.53737116,0.57666665,0.53737116,0.6766667,0.53737116,0.68,0.53737116,0.68333334,0.53737116,0.68666667,0.53737116,0.69,0.53737116,0.6933333,0.53737116,0.69666666,0.53737116,0.7,0.53737116,0.7033333,0.53737116,0.70666665,0.53737116,0.71,0.53737116,0.7133333,0.53737116,0.71666664,0.53737116,0.7366667,0.53737116,0.74,0.53737116,0.74333334,0.53737116,0.74666667,0.53737116,0.75,0.53737116,0.75333333,0.53737116,0.75666666,0.53737116,0.76,0.53737116,0.7633333,0.53737116,0.76666665,0.53737116,0.78,0.53737116,0.78333336,0.53737116,0.7866667,0.53737116,0.79,0.53737116,0.79333335,0.53737116,0.7966667,0.53737116,0.8,0.53737116,0.80333334,0.53737116,0.8066667,0.53737116,0.81,0.53737116,0.81333333,0.53737116,0.8333333,0.53737116,0.83666664,0.53737116,0.84,0.53737116,0.8433333,0.53737116,0.8466667,0.53737116,0.85,0.53737116,0.85333335,0.53737116,0.8566667,0.53737116,0.86,0.53737116,0.86333334,0.53737116,0.8666667,0.53737116,0.87,0.53737116,0.87333333,0.53737116,0.87666667,0.53737116,0.88,0.53737116,0.8833333,0.53737116,0.88666666,0.53737116,0.89,0.53737116,0.8933333,0.53737116,0.123333335,0.53994846,0.12666667,0.53994846,0.13,0.53994846,0.13333334,0.53994846,0.13666667,0.53994846,0.14,0.53994846,0.14333333,0.53994846,0.16666667,0.53994846,0.17,0.53994846,0.17333333,0.53994846,0.17666666,0.53994846,0.18,0.53994846,0.18333334,0.53994846,0.18666667,0.53994846,0.19,0.53994846,0.19333333,0.53994846,0.19666667,0.53994846,0.2,0.53994846,0.20333333,0.53994846,0.20666666,0.53994846,0.23666666,0.53994846,0.24,0.53994846,0.24333334,0.53994846,0.24666667,0.53994846,0.25,0.53994846,0.25333333,0.53994846,0.25666666,0.53994846,0.26,0.53994846,0.26333332,0.53994846,0.28666666,0.53994846,0.29,0.53994846,0.29333332,0.53994846,0.29666665,0.53994846,0.3,0.53994846,0.30333334,0.53994846,0.39,0.53994846,0.39333335,0.53994846,0.39666668,0.53994846,0.4,0.53994846,0.40333334,0.53994846,0.43333334,0.53994846,0.43666667,0.53994846,0.44,0.53994846,0.44333333,0.53994846,0.44666666,0.53994846,0.45,0.53994846,0.45333335,0.53994846,0.50333333,0.53994846,0.50666666,0.53994846,0.51,0.53994846,0.5133333,0.53994846,0.55,0.53994846,0.55333334,0.53994846,0.5566667,0.53994846,0.56,0.53994846,0.56333333,0.53994846,0.56666666,0.53994846,0.57,0.53994846,0.5733333,0.53994846,0.57666665,0.53994846,0.58,0.53994846,0.68,0.53994846,0.68333334,0.53994846,0.68666667,0.53994846,0.69,0.53994846,0.6933333,0.53994846,0.69666666,0.53994846,0.7,0.53994846,0.7033333,0.53994846,0.70666665,0.53994846,0.71,0.53994846,0.7133333,0.53994846,0.71666664,0.53994846,0.7366667,0.53994846,0.74,0.53994846,0.74333334,0.53994846,0.74666667,0.53994846,0.75,0.53994846,0.75333333,0.53994846,0.75666666,0.53994846,0.76,0.53994846,0.7633333,0.53994846,0.78333336,0.53994846,0.7866667,0.53994846,0.79,0.53994846,0.79333335,0.53994846,0.7966667,0.53994846,0.8,0.53994846,0.80333334,0.53994846,0.8066667,0.53994846,0.81,0.53994846,0.81333333,0.53994846,0.84,0.53994846,0.8433333,0.53994846,0.8466667,0.53994846,0.85,0.53994846,0.85333335,0.53994846,0.8566667,0.53994846,0.86,0.53994846,0.86333334,0.53994846,0.8666667,0.53994846,0.87,0.53994846,0.87333333,0.53994846,0.87666667,0.53994846,0.88,0.53994846,0.8833333,0.53994846,0.88666666,0.53994846,0.89,0.53994846,0.8933333,0.53994846,0.17,0.54252577,0.17333333,0.54252577,0.17666666,0.54252577,0.18,0.54252577,0.18333334,0.54252577,0.18666667,0.54252577,0.19,0.54252577,0.19333333,0.54252577,0.19666667,0.54252577,0.2,0.54252577,0.20333333,0.54252577,0.23666666,0.54252577,0.24,0.54252577,0.24333334,0.54252577,0.24666667,0.54252577,0.25,0.54252577,0.25333333,0.54252577,0.25666666,0.54252577,0.26,0.54252577,0.26333332,0.54252577,0.28666666,0.54252577,0.29,0.54252577,0.29333332,0.54252577,0.29666665,0.54252577,0.3,0.54252577,0.39,0.54252577,0.39333335,0.54252577,0.39666668,0.54252577,0.4,0.54252577,0.43333334,0.54252577,0.43666667,0.54252577,0.44,0.54252577,0.44333333,0.54252577,0.44666666,0.54252577,0.45,0.54252577,0.55333334,0.54252577,0.5566667,0.54252577,0.56,0.54252577,0.56333333,0.54252577,0.56666666,0.54252577,0.57,0.54252577,0.5733333,0.54252577,0.57666665,0.54252577,0.58,0.54252577,0.68333334,0.54252577,0.68666667,0.54252577,0.69,0.54252577,0.6933333,0.54252577,0.69666666,0.54252577,0.7,0.54252577,0.7033333,0.54252577,0.70666665,0.54252577,0.71,0.54252577,0.7133333,0.54252577,0.7366667,0.54252577,0.74,0.54252577,0.74333334,0.54252577,0.74666667,0.54252577,0.75,0.54252577,0.75333333,0.54252577,0.75666666,0.54252577,0.76,0.54252577,0.7633333,0.54252577,0.7866667,0.54252577,0.79,0.54252577,0.79333335,0.54252577,0.7966667,0.54252577,0.8,0.54252577,0.80333334,0.54252577,0.8066667,0.54252577,0.81,0.54252577,0.8433333,0.54252577,0.8466667,0.54252577,0.85,0.54252577,0.85333335,0.54252577,0.8566667,0.54252577,0.86,0.54252577,0.86333334,0.54252577,0.8666667,0.54252577,0.87,0.54252577,0.87333333,0.54252577,0.87666667,0.54252577,0.88,0.54252577,0.8833333,0.54252577,0.88666666,0.54252577,0.89,0.54252577,0.8933333,0.54252577,0.17,0.5451031,0.17333333,0.5451031,0.17666666,0.5451031,0.18,0.5451031,0.18333334,0.5451031,0.18666667,0.5451031,0.19,0.5451031,0.19333333,0.5451031,0.19666667,0.5451031,0.2,0.5451031,0.24,0.5451031,0.24333334,0.5451031,0.24666667,0.5451031,0.25,0.5451031,0.25333333,0.5451031,0.25666666,0.5451031,0.26,0.5451031,0.43666667,0.5451031,0.44,0.5451031,0.44333333,0.5451031,0.44666666,0.5451031,0.5566667,0.5451031,0.56,0.5451031,0.56333333,0.5451031,0.56666666,0.5451031,0.57,0.5451031,0.5733333,0.5451031,0.57666665,0.5451031,0.58,0.5451031,0.68666667,0.5451031,0.69,0.5451031,0.6933333,0.5451031,0.69666666,0.5451031,0.7,0.5451031,0.7033333,0.5451031,0.70666665,0.5451031,0.71,0.5451031,0.7366667,0.5451031,0.74,0.5451031,0.74333334,0.5451031,0.74666667,0.5451031,0.75,0.5451031,0.75333333,0.5451031,0.75666666,0.5451031,0.76,0.5451031,0.79,0.5451031,0.79333335,0.5451031,0.7966667,0.5451031,0.8,0.5451031,0.80333334,0.5451031,0.8066667,0.5451031,0.85,0.5451031,0.85333335,0.5451031,0.8566667,0.5451031,0.86,0.5451031,0.86333334,0.5451031,0.8666667,0.5451031,0.87,0.5451031,0.87333333,0.5451031,0.87666667,0.5451031,0.88,0.5451031,0.8833333,0.5451031,0.88666666,0.5451031,0.89,0.5451031,0.8933333,0.5451031,0.89666665,0.5451031,0.17,0.54768044,0.17333333,0.54768044,0.17666666,0.54768044,0.18,0.54768044,0.18333334,0.54768044,0.18666667,0.54768044,0.19,0.54768044,0.19333333,0.54768044,0.19666667,0.54768044,0.24333334,0.54768044,0.24666667,0.54768044,0.25,0.54768044,0.25333333,0.54768044,0.25666666,0.54768044,0.26,0.54768044,0.56,0.54768044,0.56333333,0.54768044,0.56666666,0.54768044,0.57,0.54768044,0.5733333,0.54768044,0.57666665,0.54768044,0.6933333,0.54768044,0.69666666,0.54768044,0.7,0.54768044,0.7033333,0.54768044,0.70666665,0.54768044,0.74,0.54768044,0.74333334,0.54768044,0.74666667,0.54768044,0.75,0.54768044,0.75333333,0.54768044,0.75666666,0.54768044,0.79333335,0.54768044,0.7966667,0.54768044,0.8,0.54768044,0.80333334,0.54768044,0.8066667,0.54768044,0.85333335,0.54768044,0.8566667,0.54768044,0.86,0.54768044,0.86333334,0.54768044,0.8666667,0.54768044,0.87,0.54768044,0.87333333,0.54768044,0.87666667,0.54768044,0.88,0.54768044,0.8833333,0.54768044,0.88666666,0.54768044,0.89,0.54768044,0.8933333,0.54768044,0.89666665,0.54768044,0.17,0.55025774,0.17333333,0.55025774,0.17666666,0.55025774,0.18,0.55025774,0.18333334,0.55025774,0.18666667,0.55025774,0.19,0.55025774,0.19333333,0.55025774,0.24666667,0.55025774,0.25,0.55025774,0.25333333,0.55025774,0.25666666,0.55025774,0.51666665,0.55025774,0.52,0.55025774,0.5233333,0.55025774,0.52666664,0.55025774,0.53,0.55025774,0.56333333,0.55025774,0.56666666,0.55025774,0.57,0.55025774,0.5733333,0.55025774,0.74333334,0.55025774,0.74666667,0.55025774,0.75,0.55025774,0.75333333,0.55025774,0.8,0.55025774,0.8566667,0.55025774,0.86,0.55025774,0.86333334,0.55025774,0.8666667,0.55025774,0.87,0.55025774,0.87333333,0.55025774,0.87666667,0.55025774,0.88,0.55025774,0.8833333,0.55025774,0.88666666,0.55025774,0.89,0.55025774,0.8933333,0.55025774,0.17333333,0.55283505,0.17666666,0.55283505,0.18,0.55283505,0.18333334,0.55283505,0.18666667,0.55283505,0.19,0.55283505,0.51,0.55283505,0.5133333,0.55283505,0.51666665,0.55283505,0.52,0.55283505,0.5233333,0.55283505,0.52666664,0.55283505,0.53,0.55283505,0.53333336,0.55283505,0.5366667,0.55283505,0.86,0.55283505,0.86333334,0.55283505,0.8666667,0.55283505,0.87,0.55283505,0.87333333,0.55283505,0.87666667,0.55283505,0.88,0.55283505,0.8833333,0.55283505,0.88666666,0.55283505,0.89,0.55283505,0.8933333,0.55283505,0.17333333,0.55541235,0.17666666,0.55541235,0.18,0.55541235,0.18333334,0.55541235,0.50333333,0.55541235,0.50666666,0.55541235,0.51,0.55541235,0.5133333,0.55541235,0.51666665,0.55541235,0.52,0.55541235,0.5233333,0.55541235,0.52666664,0.55541235,0.53,0.55541235,0.53333336,0.55541235,0.5366667,0.55541235,0.54,0.55541235,0.86333334,0.55541235,0.8666667,0.55541235,0.87,0.55541235,0.87333333,0.55541235,0.87666667,0.55541235,0.88,0.55541235,0.8833333,0.55541235,0.88666666,0.55541235,0.89,0.55541235,0.50333333,0.5579897,0.50666666,0.5579897,0.51,0.5579897,0.5133333,0.5579897,0.51666665,0.5579897,0.52,0.5579897,0.5233333,0.5579897,0.52666664,0.5579897,0.53,0.5579897,0.53333336,0.5579897,0.5366667,0.5579897,0.54,0.5579897,0.54333335,0.5579897,0.87,0.5579897,0.87333333,0.5579897,0.87666667,0.5579897,0.88,0.5579897,0.8833333,0.5579897,0.88666666,0.5579897,0.5,0.560567,0.50333333,0.560567,0.50666666,0.560567,0.51,0.560567,0.5133333,0.560567,0.51666665,0.560567,0.52,0.560567,0.5233333,0.560567,0.52666664,0.560567,0.53,0.560567,0.53333336,0.560567,0.5366667,0.560567,0.54,0.560567,0.54333335,0.560567,0.5466667,0.560567,0.71,0.560567,0.7133333,0.560567,0.71666664,0.560567,0.72,0.560567,0.72333336,0.560567,0.7266667,0.560567,0.73,0.560567,0.73333335,0.560567,0.7366667,0.560567,0.43666667,0.5631443,0.44,0.5631443,0.49666667,0.5631443,0.5,0.5631443,0.50333333,0.5631443,0.50666666,0.5631443,0.51,0.5631443,0.5133333,0.5631443,0.51666665,0.5631443,0.52,0.5631443,0.5233333,0.5631443,0.52666664,0.5631443,0.53,0.5631443,0.53333336,0.5631443,0.5366667,0.5631443,0.54,0.5631443,0.54333335,0.5631443,0.5466667,0.5631443,0.70666665,0.5631443,0.71,0.5631443,0.7133333,0.5631443,0.71666664,0.5631443,0.72,0.5631443,0.72333336,0.5631443,0.7266667,0.5631443,0.73,0.5631443,0.73333335,0.5631443,0.7366667,0.5631443,0.74,0.5631443,0.74333334,0.5631443,0.74666667,0.5631443,0.43333334,0.56572163,0.43666667,0.56572163,0.44,0.56572163,0.44333333,0.56572163,0.44666666,0.56572163,0.49666667,0.56572163,0.5,0.56572163,0.50333333,0.56572163,0.50666666,0.56572163,0.51,0.56572163,0.5133333,0.56572163,0.51666665,0.56572163,0.52,0.56572163,0.5233333,0.56572163,0.52666664,0.56572163,0.53,0.56572163,0.53333336,0.56572163,0.5366667,0.56572163,0.54,0.56572163,0.54333335,0.56572163,0.5466667,0.56572163,0.7,0.56572163,0.7033333,0.56572163,0.70666665,0.56572163,0.71,0.56572163,0.7133333,0.56572163,0.71666664,0.56572163,0.72,0.56572163,0.72333336,0.56572163,0.7266667,0.56572163,0.73,0.56572163,0.73333335,0.56572163,0.7366667,0.56572163,0.74,0.56572163,0.74333334,0.56572163,0.74666667,0.56572163,0.75,0.56572163,0.75333333,0.56572163,0.41333333,0.568299,0.43333334,0.568299,0.43666667,0.568299,0.44,0.568299,0.44333333,0.568299,0.44666666,0.568299,0.45,0.568299,0.49333334,0.568299,0.49666667,0.568299,0.5,0.568299,0.50333333,0.568299,0.50666666,0.568299,0.51,0.568299,0.5133333,0.568299,0.51666665,0.568299,0.52,0.568299,0.5233333,0.568299,0.52666664,0.568299,0.53,0.568299,0.53333336,0.568299,0.5366667,0.568299,0.54,0.568299,0.54333335,0.568299,0.5466667,0.568299,0.7033333,0.568299,0.70666665,0.568299,0.71,0.568299,0.7133333,0.568299,0.71666664,0.568299,0.72,0.568299,0.72333336,0.568299,0.7266667,0.568299,0.73,0.568299,0.73333335,0.568299,0.7366667,0.568299,0.74,0.568299,0.74333334,0.568299,0.74666667,0.568299,0.75,0.568299,0.75333333,0.568299,0.75666666,0.568299,0.20333333,0.5708763,0.20666666,0.5708763,0.21,0.5708763,0.21333334,0.5708763,0.21666667,0.5708763,0.22,0.5708763,0.41333333,0.5708763,0.41666666,0.5708763,0.43333334,0.5708763,0.43666667,0.5708763,0.44,0.5708763,0.44333333,0.5708763,0.44666666,0.5708763,0.45,0.5708763,0.45333335,0.5708763,0.49333334,0.5708763,0.49666667,0.5708763,0.5,0.5708763,0.50333333,0.5708763,0.50666666,0.5708763,0.51,0.5708763,0.5133333,0.5708763,0.51666665,0.5708763,0.52,0.5708763,0.5233333,0.5708763,0.52666664,0.5708763,0.53,0.5708763,0.53333336,0.5708763,0.5366667,0.5708763,0.54,0.5708763,0.54333335,0.5708763,0.7033333,0.5708763,0.70666665,0.5708763,0.71,0.5708763,0.7133333,0.5708763,0.71666664,0.5708763,0.72,0.5708763,0.72333336,0.5708763,0.7266667,0.5708763,0.73,0.5708763,0.73333335,0.5708763,0.7366667,0.5708763,0.74,0.5708763,0.74333334,0.5708763,0.74666667,0.5708763,0.75,0.5708763,0.75333333,0.5708763,0.75666666,0.5708763,0.80333334,0.5708763,0.8066667,0.5708763,0.81,0.5708763,0.81333333,0.5708763,0.81666666,0.5708763,0.82,0.5708763,0.8233333,0.5708763,0.82666665,0.5708763,0.2,0.5734536,0.20333333,0.5734536,0.20666666,0.5734536,0.21,0.5734536,0.21333334,0.5734536,0.21666667,0.5734536,0.22,0.5734536,0.22333333,0.5734536,0.28333333,0.5734536,0.28666666,0.5734536,0.29,0.5734536,0.29333332,0.5734536,0.29666665,0.5734536,0.41333333,0.5734536,0.41666666,0.5734536,0.43333334,0.5734536,0.43666667,0.5734536,0.44,0.5734536,0.44333333,0.5734536,0.44666666,0.5734536,0.45,0.5734536,0.45333335,0.5734536,0.45666668,0.5734536,0.49333334,0.5734536,0.49666667,0.5734536,0.5,0.5734536,0.50333333,0.5734536,0.50666666,0.5734536,0.51,0.5734536,0.5133333,0.5734536,0.51666665,0.5734536,0.52,0.5734536,0.5233333,0.5734536,0.52666664,0.5734536,0.53,0.5734536,0.53333336,0.5734536,0.5366667,0.5734536,0.54,0.5734536,0.54333335,0.5734536,0.70666665,0.5734536,0.71,0.5734536,0.7133333,0.5734536,0.71666664,0.5734536,0.72,0.5734536,0.72333336,0.5734536,0.7266667,0.5734536,0.73,0.5734536,0.73333335,0.5734536,0.7366667,0.5734536,0.74,0.5734536,0.74333334,0.5734536,0.74666667,0.5734536,0.75,0.5734536,0.75333333,0.5734536,0.75666666,0.5734536,0.76,0.5734536,0.80333334,0.5734536,0.8066667,0.5734536,0.81,0.5734536,0.81333333,0.5734536,0.81666666,0.5734536,0.82,0.5734536,0.8233333,0.5734536,0.82666665,0.5734536,0.83,0.5734536,0.8333333,0.5734536,0.13333334,0.5760309,0.13666667,0.5760309,0.14,0.5760309,0.14333333,0.5760309,0.14666666,0.5760309,0.15,0.5760309,0.15333334,0.5760309,0.19666667,0.5760309,0.2,0.5760309,0.20333333,0.5760309,0.20666666,0.5760309,0.21,0.5760309,0.21333334,0.5760309,0.21666667,0.5760309,0.22,0.5760309,0.22333333,0.5760309,0.22666667,0.5760309,0.27333334,0.5760309,0.27666667,0.5760309,0.28,0.5760309,0.28333333,0.5760309,0.28666666,0.5760309,0.29,0.5760309,0.29333332,0.5760309,0.29666665,0.5760309,0.3,0.5760309,0.30333334,0.5760309,0.30666667,0.5760309,0.31,0.5760309,0.41666666,0.5760309,0.43333334,0.5760309,0.43666667,0.5760309,0.44,0.5760309,0.44333333,0.5760309,0.44666666,0.5760309,0.45,0.5760309,0.45333335,0.5760309,0.45666668,0.5760309,0.49333334,0.5760309,0.49666667,0.5760309,0.5,0.5760309,0.50333333,0.5760309,0.50666666,0.5760309,0.51,0.5760309,0.5133333,0.5760309,0.51666665,0.5760309,0.52,0.5760309,0.5233333,0.5760309,0.52666664,0.5760309,0.53,0.5760309,0.53333336,0.5760309,0.5366667,0.5760309,0.54,0.5760309,0.54333335,0.5760309,0.71,0.5760309,0.7133333,0.5760309,0.71666664,0.5760309,0.72,0.5760309,0.72333336,0.5760309,0.7266667,0.5760309,0.73,0.5760309,0.73333335,0.5760309,0.7366667,0.5760309,0.74,0.5760309,0.74333334,0.5760309,0.74666667,0.5760309,0.75,0.5760309,0.75333333,0.5760309,0.75666666,0.5760309,0.76,0.5760309,0.7633333,0.5760309,0.8,0.5760309,0.80333334,0.5760309,0.8066667,0.5760309,0.81,0.5760309,0.81333333,0.5760309,0.81666666,0.5760309,0.82,0.5760309,0.8233333,0.5760309,0.82666665,0.5760309,0.83,0.5760309,0.8333333,0.5760309,0.83666664,0.5760309,0.13333334,0.5786083,0.13666667,0.5786083,0.14,0.5786083,0.14333333,0.5786083,0.14666666,0.5786083,0.15,0.5786083,0.15333334,0.5786083,0.15666667,0.5786083,0.19333333,0.5786083,0.19666667,0.5786083,0.2,0.5786083,0.20333333,0.5786083,0.20666666,0.5786083,0.21,0.5786083,0.21333334,0.5786083,0.21666667,0.5786083,0.22,0.5786083,0.22333333,0.5786083,0.22666667,0.5786083,0.23,0.5786083,0.26666668,0.5786083,0.27,0.5786083,0.27333334,0.5786083,0.27666667,0.5786083,0.28,0.5786083,0.28333333,0.5786083,0.28666666,0.5786083,0.29,0.5786083,0.29333332,0.5786083,0.29666665,0.5786083,0.3,0.5786083,0.30333334,0.5786083,0.30666667,0.5786083,0.31,0.5786083,0.31333333,0.5786083,0.31666666,0.5786083,0.43,0.5786083,0.43333334,0.5786083,0.43666667,0.5786083,0.44,0.5786083,0.44333333,0.5786083,0.44666666,0.5786083,0.45,0.5786083,0.45333335,0.5786083,0.45666668,0.5786083,0.46,0.5786083,0.49,0.5786083,0.49333334,0.5786083,0.49666667,0.5786083,0.5,0.5786083,0.50333333,0.5786083,0.50666666,0.5786083,0.51,0.5786083,0.5133333,0.5786083,0.51666665,0.5786083,0.52,0.5786083,0.5233333,0.5786083,0.52666664,0.5786083,0.53,0.5786083,0.53333336,0.5786083,0.5366667,0.5786083,0.54,0.5786083,0.5933333,0.5786083,0.5966667,0.5786083,0.6,0.5786083,0.60333335,0.5786083,0.6066667,0.5786083,0.61,0.5786083,0.61333334,0.5786083,0.69,0.5786083,0.6933333,0.5786083,0.71,0.5786083,0.7133333,0.5786083,0.71666664,0.5786083,0.72,0.5786083,0.72333336,0.5786083,0.7266667,0.5786083,0.73,0.5786083,0.73333335,0.5786083,0.7366667,0.5786083,0.74,0.5786083,0.74333334,0.5786083,0.74666667,0.5786083,0.75,0.5786083,0.75333333,0.5786083,0.75666666,0.5786083,0.76,0.5786083,0.7633333,0.5786083,0.7966667,0.5786083,0.8,0.5786083,0.80333334,0.5786083,0.8066667,0.5786083,0.81,0.5786083,0.81333333,0.5786083,0.81666666,0.5786083,0.82,0.5786083,0.8233333,0.5786083,0.82666665,0.5786083,0.83,0.5786083,0.8333333,0.5786083,0.83666664,0.5786083,0.13333334,0.5811856,0.13666667,0.5811856,0.14,0.5811856,0.14333333,0.5811856,0.14666666,0.5811856,0.15,0.5811856,0.15333334,0.5811856,0.15666667,0.5811856,0.16,0.5811856,0.19333333,0.5811856,0.19666667,0.5811856,0.2,0.5811856,0.20333333,0.5811856,0.20666666,0.5811856,0.21,0.5811856,0.21333334,0.5811856,0.21666667,0.5811856,0.22,0.5811856,0.22333333,0.5811856,0.22666667,0.5811856,0.23,0.5811856,0.26333332,0.5811856,0.26666668,0.5811856,0.27,0.5811856,0.27333334,0.5811856,0.27666667,0.5811856,0.28,0.5811856,0.28333333,0.5811856,0.28666666,0.5811856,0.29,0.5811856,0.29333332,0.5811856,0.29666665,0.5811856,0.3,0.5811856,0.30333334,0.5811856,0.30666667,0.5811856,0.31,0.5811856,0.31333333,0.5811856,0.31666666,0.5811856,0.32,0.5811856,0.43,0.5811856,0.43333334,0.5811856,0.43666667,0.5811856,0.44,0.5811856,0.44333333,0.5811856,0.44666666,0.5811856,0.45,0.5811856,0.45333335,0.5811856,0.45666668,0.5811856,0.46,0.5811856,0.46333334,0.5811856,0.49,0.5811856,0.49333334,0.5811856,0.49666667,0.5811856,0.5,0.5811856,0.50333333,0.5811856,0.50666666,0.5811856,0.51,0.5811856,0.5133333,0.5811856,0.51666665,0.5811856,0.52,0.5811856,0.5233333,0.5811856,0.52666664,0.5811856,0.53,0.5811856,0.53333336,0.5811856,0.5366667,0.5811856,0.5833333,0.5811856,0.58666664,0.5811856,0.59,0.5811856,0.5933333,0.5811856,0.5966667,0.5811856,0.6,0.5811856,0.60333335,0.5811856,0.6066667,0.5811856,0.61,0.5811856,0.61333334,0.5811856,0.6166667,0.5811856,0.68666667,0.5811856,0.69,0.5811856,0.6933333,0.5811856,0.69666666,0.5811856,0.71,0.5811856,0.7133333,0.5811856,0.71666664,0.5811856,0.72,0.5811856,0.72333336,0.5811856,0.7266667,0.5811856,0.73,0.5811856,0.73333335,0.5811856,0.7366667,0.5811856,0.74,0.5811856,0.74333334,0.5811856,0.74666667,0.5811856,0.75,0.5811856,0.75333333,0.5811856,0.75666666,0.5811856,0.76,0.5811856,0.7633333,0.5811856,0.76666665,0.5811856,0.7966667,0.5811856,0.8,0.5811856,0.80333334,0.5811856,0.8066667,0.5811856,0.81,0.5811856,0.81333333,0.5811856,0.81666666,0.5811856,0.82,0.5811856,0.8233333,0.5811856,0.82666665,0.5811856,0.83,0.5811856,0.8333333,0.5811856,0.83666664,0.5811856,0.84,0.5811856,0.13333334,0.5837629,0.13666667,0.5837629,0.14,0.5837629,0.14333333,0.5837629,0.14666666,0.5837629,0.15,0.5837629,0.15333334,0.5837629,0.15666667,0.5837629,0.16,0.5837629,0.16333333,0.5837629,0.19,0.5837629,0.19333333,0.5837629,0.19666667,0.5837629,0.2,0.5837629,0.20333333,0.5837629,0.20666666,0.5837629,0.21,0.5837629,0.21333334,0.5837629,0.21666667,0.5837629,0.22,0.5837629,0.22333333,0.5837629,0.22666667,0.5837629,0.23,0.5837629,0.26,0.5837629,0.26333332,0.5837629,0.26666668,0.5837629,0.27,0.5837629,0.27333334,0.5837629,0.27666667,0.5837629,0.28,0.5837629,0.28333333,0.5837629,0.28666666,0.5837629,0.29,0.5837629,0.29333332,0.5837629,0.29666665,0.5837629,0.3,0.5837629,0.30333334,0.5837629,0.30666667,0.5837629,0.31,0.5837629,0.31333333,0.5837629,0.31666666,0.5837629,0.32,0.5837629,0.32333332,0.5837629,0.42666668,0.5837629,0.43,0.5837629,0.43333334,0.5837629,0.43666667,0.5837629,0.44,0.5837629,0.44333333,0.5837629,0.44666666,0.5837629,0.45,0.5837629,0.45333335,0.5837629,0.45666668,0.5837629,0.46,0.5837629,0.46333334,0.5837629,0.46666667,0.5837629,0.48666668,0.5837629,0.49,0.5837629,0.49333334,0.5837629,0.49666667,0.5837629,0.5,0.5837629,0.50333333,0.5837629,0.50666666,0.5837629,0.51,0.5837629,0.5133333,0.5837629,0.51666665,0.5837629,0.52,0.5837629,0.5233333,0.5837629,0.52666664,0.5837629,0.53,0.5837629,0.53333336,0.5837629,0.5366667,0.5837629,0.57666665,0.5837629,0.58,0.5837629,0.5833333,0.5837629,0.58666664,0.5837629,0.59,0.5837629,0.5933333,0.5837629,0.5966667,0.5837629,0.6,0.5837629,0.60333335,0.5837629,0.6066667,0.5837629,0.61,0.5837629,0.61333334,0.5837629,0.6166667,0.5837629,0.62,0.5837629,0.62333333,0.5837629,0.68666667,0.5837629,0.69,0.5837629,0.6933333,0.5837629,0.69666666,0.5837629,0.71,0.5837629,0.7133333,0.5837629,0.71666664,0.5837629,0.72,0.5837629,0.72333336,0.5837629,0.7266667,0.5837629,0.73,0.5837629,0.73333335,0.5837629,0.7366667,0.5837629,0.74,0.5837629,0.74333334,0.5837629,0.74666667,0.5837629,0.75,0.5837629,0.75333333,0.5837629,0.75666666,0.5837629,0.76,0.5837629,0.7633333,0.5837629,0.76666665,0.5837629,0.77,0.5837629,0.79333335,0.5837629,0.7966667,0.5837629,0.8,0.5837629,0.80333334,0.5837629,0.8066667,0.5837629,0.81,0.5837629,0.81333333,0.5837629,0.81666666,0.5837629,0.82,0.5837629,0.8233333,0.5837629,0.82666665,0.5837629,0.83,0.5837629,0.8333333,0.5837629,0.83666664,0.5837629,0.84,0.5837629,0.11666667,0.5863402,0.12,0.5863402,0.13666667,0.5863402,0.14,0.5863402,0.14333333,0.5863402,0.14666666,0.5863402,0.15,0.5863402,0.15333334,0.5863402,0.15666667,0.5863402,0.16,0.5863402,0.16333333,0.5863402,0.16666667,0.5863402,0.18666667,0.5863402,0.19,0.5863402,0.19333333,0.5863402,0.19666667,0.5863402,0.2,0.5863402,0.20333333,0.5863402,0.20666666,0.5863402,0.21,0.5863402,0.21333334,0.5863402,0.21666667,0.5863402,0.22,0.5863402,0.22333333,0.5863402,0.22666667,0.5863402,0.23,0.5863402,0.25666666,0.5863402,0.26,0.5863402,0.26333332,0.5863402,0.26666668,0.5863402,0.27,0.5863402,0.27333334,0.5863402,0.27666667,0.5863402,0.28,0.5863402,0.28333333,0.5863402,0.28666666,0.5863402,0.29,0.5863402,0.29333332,0.5863402,0.29666665,0.5863402,0.3,0.5863402,0.30333334,0.5863402,0.30666667,0.5863402,0.31,0.5863402,0.31333333,0.5863402,0.31666666,0.5863402,0.32,0.5863402,0.32333332,0.5863402,0.32666665,0.5863402,0.42333335,0.5863402,0.42666668,0.5863402,0.43,0.5863402,0.43333334,0.5863402,0.43666667,0.5863402,0.44,0.5863402,0.44333333,0.5863402,0.44666666,0.5863402,0.45,0.5863402,0.45333335,0.5863402,0.45666668,0.5863402,0.46,0.5863402,0.46333334,0.5863402,0.46666667,0.5863402,0.47,0.5863402,0.47333333,0.5863402,0.47666666,0.5863402,0.48,0.5863402,0.48333332,0.5863402,0.48666668,0.5863402,0.49,0.5863402,0.49333334,0.5863402,0.49666667,0.5863402,0.5,0.5863402,0.50333333,0.5863402,0.50666666,0.5863402,0.51,0.5863402,0.5133333,0.5863402,0.51666665,0.5863402,0.52,0.5863402,0.5233333,0.5863402,0.52666664,0.5863402,0.53,0.5863402,0.53333336,0.5863402,0.5366667,0.5863402,0.5733333,0.5863402,0.57666665,0.5863402,0.58,0.5863402,0.5833333,0.5863402,0.58666664,0.5863402,0.59,0.5863402,0.5933333,0.5863402,0.5966667,0.5863402,0.6,0.5863402,0.60333335,0.5863402,0.6066667,0.5863402,0.61,0.5863402,0.61333334,0.5863402,0.6166667,0.5863402,0.62,0.5863402,0.62333333,0.5863402,0.62666667,0.5863402,0.69,0.5863402,0.6933333,0.5863402,0.69666666,0.5863402,0.71,0.5863402,0.7133333,0.5863402,0.71666664,0.5863402,0.72,0.5863402,0.72333336,0.5863402,0.7266667,0.5863402,0.73,0.5863402,0.73333335,0.5863402,0.7366667,0.5863402,0.74,0.5863402,0.74333334,0.5863402,0.74666667,0.5863402,0.75,0.5863402,0.75333333,0.5863402,0.75666666,0.5863402,0.76,0.5863402,0.7633333,0.5863402,0.76666665,0.5863402,0.77,0.5863402,0.79333335,0.5863402,0.7966667,0.5863402,0.8,0.5863402,0.80333334,0.5863402,0.8066667,0.5863402,0.81,0.5863402,0.81333333,0.5863402,0.81666666,0.5863402,0.82,0.5863402,0.8233333,0.5863402,0.82666665,0.5863402,0.83,0.5863402,0.8333333,0.5863402,0.83666664,0.5863402,0.84,0.5863402,0.11666667,0.58891755,0.12,0.58891755,0.13666667,0.58891755,0.14,0.58891755,0.14333333,0.58891755,0.14666666,0.58891755,0.15,0.58891755,0.15333334,0.58891755,0.15666667,0.58891755,0.16,0.58891755,0.16333333,0.58891755,0.16666667,0.58891755,0.18666667,0.58891755,0.19,0.58891755,0.19333333,0.58891755,0.19666667,0.58891755,0.2,0.58891755,0.20333333,0.58891755,0.20666666,0.58891755,0.21,0.58891755,0.21333334,0.58891755,0.21666667,0.58891755,0.22,0.58891755,0.22333333,0.58891755,0.22666667,0.58891755,0.23,0.58891755,0.23333333,0.58891755,0.25,0.58891755,0.25333333,0.58891755,0.25666666,0.58891755,0.26,0.58891755,0.26333332,0.58891755,0.26666668,0.58891755,0.27,0.58891755,0.27333334,0.58891755,0.27666667,0.58891755,0.28,0.58891755,0.28333333,0.58891755,0.28666666,0.58891755,0.29,0.58891755,0.29333332,0.58891755,0.29666665,0.58891755,0.3,0.58891755,0.30333334,0.58891755,0.30666667,0.58891755,0.31,0.58891755,0.31333333,0.58891755,0.31666666,0.58891755,0.32,0.58891755,0.32333332,0.58891755,0.32666665,0.58891755,0.33,0.58891755,0.42333335,0.58891755,0.42666668,0.58891755,0.43,0.58891755,0.43333334,0.58891755,0.43666667,0.58891755,0.44,0.58891755,0.44333333,0.58891755,0.44666666,0.58891755,0.45,0.58891755,0.45333335,0.58891755,0.45666668,0.58891755,0.46,0.58891755,0.46333334,0.58891755,0.46666667,0.58891755,0.47,0.58891755,0.47333333,0.58891755,0.47666666,0.58891755,0.48,0.58891755,0.48333332,0.58891755,0.48666668,0.58891755,0.49,0.58891755,0.49333334,0.58891755,0.49666667,0.58891755,0.5,0.58891755,0.50333333,0.58891755,0.50666666,0.58891755,0.51,0.58891755,0.5133333,0.58891755,0.51666665,0.58891755,0.52,0.58891755,0.5233333,0.58891755,0.52666664,0.58891755,0.53,0.58891755,0.53333336,0.58891755,0.5366667,0.58891755,0.5733333,0.58891755,0.57666665,0.58891755,0.58,0.58891755,0.5833333,0.58891755,0.58666664,0.58891755,0.59,0.58891755,0.5933333,0.58891755,0.5966667,0.58891755,0.6,0.58891755,0.60333335,0.58891755,0.6066667,0.58891755,0.61,0.58891755,0.61333334,0.58891755,0.6166667,0.58891755,0.62,0.58891755,0.62333333,0.58891755,0.62666667,0.58891755,0.70666665,0.58891755,0.71,0.58891755,0.7133333,0.58891755,0.71666664,0.58891755,0.72,0.58891755,0.72333336,0.58891755,0.7266667,0.58891755,0.73,0.58891755,0.73333335,0.58891755,0.7366667,0.58891755,0.74,0.58891755,0.74333334,0.58891755,0.74666667,0.58891755,0.75,0.58891755,0.75333333,0.58891755,0.75666666,0.58891755,0.76,0.58891755,0.7633333,0.58891755,0.76666665,0.58891755,0.77,0.58891755,0.7733333,0.58891755,0.79,0.58891755,0.79333335,0.58891755,0.7966667,0.58891755,0.8,0.58891755,0.80333334,0.58891755,0.8066667,0.58891755,0.81,0.58891755,0.81333333,0.58891755,0.81666666,0.58891755,0.82,0.58891755,0.8233333,0.58891755,0.82666665,0.58891755,0.83,0.58891755,0.8333333,0.58891755,0.83666664,0.58891755,0.84,0.58891755,0.07,0.59149486,0.07333333,0.59149486,0.07666667,0.59149486,0.08,0.59149486,0.083333336,0.59149486,0.086666666,0.59149486,0.09,0.59149486,0.093333334,0.59149486,0.096666664,0.59149486,0.1,0.59149486,0.12,0.59149486,0.13666667,0.59149486,0.14,0.59149486,0.14333333,0.59149486,0.14666666,0.59149486,0.15,0.59149486,0.15333334,0.59149486,0.15666667,0.59149486,0.16,0.59149486,0.16333333,0.59149486,0.16666667,0.59149486,0.17,0.59149486,0.18666667,0.59149486,0.19,0.59149486,0.19333333,0.59149486,0.19666667,0.59149486,0.2,0.59149486,0.20333333,0.59149486,0.20666666,0.59149486,0.21,0.59149486,0.21333334,0.59149486,0.21666667,0.59149486,0.22,0.59149486,0.22333333,0.59149486,0.22666667,0.59149486,0.23,0.59149486,0.23333333,0.59149486,0.24666667,0.59149486,0.25,0.59149486,0.25333333,0.59149486,0.25666666,0.59149486,0.26,0.59149486,0.26333332,0.59149486,0.26666668,0.59149486,0.27,0.59149486,0.27333334,0.59149486,0.27666667,0.59149486,0.28,0.59149486,0.28333333,0.59149486,0.28666666,0.59149486,0.29,0.59149486,0.29333332,0.59149486,0.29666665,0.59149486,0.3,0.59149486,0.30333334,0.59149486,0.30666667,0.59149486,0.31,0.59149486,0.31333333,0.59149486,0.31666666,0.59149486,0.32,0.59149486,0.32333332,0.59149486,0.32666665,0.59149486,0.33,0.59149486,0.33333334,0.59149486,0.42333335,0.59149486,0.42666668,0.59149486,0.43,0.59149486,0.43333334,0.59149486,0.43666667,0.59149486,0.44,0.59149486,0.44333333,0.59149486,0.44666666,0.59149486,0.45,0.59149486,0.45333335,0.59149486,0.45666668,0.59149486,0.46,0.59149486,0.46333334,0.59149486,0.46666667,0.59149486,0.47,0.59149486,0.47333333,0.59149486,0.47666666,0.59149486,0.48,0.59149486,0.48333332,0.59149486,0.48666668,0.59149486,0.49,0.59149486,0.49333334,0.59149486,0.49666667,0.59149486,0.5,0.59149486,0.50333333,0.59149486,0.50666666,0.59149486,0.51,0.59149486,0.5133333,0.59149486,0.51666665,0.59149486,0.52,0.59149486,0.5233333,0.59149486,0.52666664,0.59149486,0.53,0.59149486,0.53333336,0.59149486,0.5366667,0.59149486,0.57,0.59149486,0.5733333,0.59149486,0.57666665,0.59149486,0.58,0.59149486,0.5833333,0.59149486,0.58666664,0.59149486,0.59,0.59149486,0.5933333,0.59149486,0.5966667,0.59149486,0.6,0.59149486,0.60333335,0.59149486,0.6066667,0.59149486,0.61,0.59149486,0.61333334,0.59149486,0.6166667,0.59149486,0.62,0.59149486,0.62333333,0.59149486,0.62666667,0.59149486,0.63,0.59149486,0.70666665,0.59149486,0.71,0.59149486,0.7133333,0.59149486,0.71666664,0.59149486,0.72,0.59149486,0.72333336,0.59149486,0.7266667,0.59149486,0.73,0.59149486,0.73333335,0.59149486,0.7366667,0.59149486,0.74,0.59149486,0.74333334,0.59149486,0.74666667,0.59149486,0.75,0.59149486,0.75333333,0.59149486,0.75666666,0.59149486,0.76,0.59149486,0.7633333,0.59149486,0.76666665,0.59149486,0.77,0.59149486,0.7733333,0.59149486,0.77666664,0.59149486,0.79,0.59149486,0.79333335,0.59149486,0.7966667,0.59149486,0.8,0.59149486,0.80333334,0.59149486,0.8066667,0.59149486,0.81,0.59149486,0.81333333,0.59149486,0.81666666,0.59149486,0.82,0.59149486,0.8233333,0.59149486,0.82666665,0.59149486,0.83,0.59149486,0.8333333,0.59149486,0.83666664,0.59149486,0.84,0.59149486,0.06333333,0.59407216,0.06666667,0.59407216,0.07,0.59407216,0.07333333,0.59407216,0.07666667,0.59407216,0.08,0.59407216,0.083333336,0.59407216,0.086666666,0.59407216,0.09,0.59407216,0.093333334,0.59407216,0.096666664,0.59407216,0.1,0.59407216,0.13333334,0.59407216,0.13666667,0.59407216,0.14,0.59407216,0.14333333,0.59407216,0.14666666,0.59407216,0.15,0.59407216,0.15333334,0.59407216,0.15666667,0.59407216,0.16,0.59407216,0.16333333,0.59407216,0.16666667,0.59407216,0.17,0.59407216,0.18666667,0.59407216,0.19,0.59407216,0.19333333,0.59407216,0.19666667,0.59407216,0.2,0.59407216,0.20333333,0.59407216,0.20666666,0.59407216,0.21,0.59407216,0.21333334,0.59407216,0.21666667,0.59407216,0.22,0.59407216,0.22333333,0.59407216,0.22666667,0.59407216,0.23,0.59407216,0.23333333,0.59407216,0.23666666,0.59407216,0.24,0.59407216,0.24333334,0.59407216,0.24666667,0.59407216,0.25,0.59407216,0.25333333,0.59407216,0.25666666,0.59407216,0.26,0.59407216,0.26333332,0.59407216,0.26666668,0.59407216,0.27,0.59407216,0.27333334,0.59407216,0.27666667,0.59407216,0.28,0.59407216,0.28333333,0.59407216,0.28666666,0.59407216,0.29,0.59407216,0.29333332,0.59407216,0.29666665,0.59407216,0.3,0.59407216,0.30333334,0.59407216,0.30666667,0.59407216,0.31,0.59407216,0.31333333,0.59407216,0.31666666,0.59407216,0.32,0.59407216,0.32333332,0.59407216,0.32666665,0.59407216,0.33,0.59407216,0.33333334,0.59407216,0.42333335,0.59407216,0.42666668,0.59407216,0.43,0.59407216,0.43333334,0.59407216,0.43666667,0.59407216,0.44,0.59407216,0.44333333,0.59407216,0.44666666,0.59407216,0.45,0.59407216,0.45333335,0.59407216,0.45666668,0.59407216,0.46,0.59407216,0.46333334,0.59407216,0.46666667,0.59407216,0.47,0.59407216,0.47333333,0.59407216,0.47666666,0.59407216,0.48,0.59407216,0.48333332,0.59407216,0.48666668,0.59407216,0.49,0.59407216,0.49333334,0.59407216,0.49666667,0.59407216,0.5,0.59407216,0.50333333,0.59407216,0.50666666,0.59407216,0.51,0.59407216,0.5133333,0.59407216,0.51666665,0.59407216,0.52,0.59407216,0.5233333,0.59407216,0.52666664,0.59407216,0.53,0.59407216,0.53333336,0.59407216,0.5366667,0.59407216,0.56666666,0.59407216,0.57,0.59407216,0.5733333,0.59407216,0.57666665,0.59407216,0.58,0.59407216,0.5833333,0.59407216,0.58666664,0.59407216,0.59,0.59407216,0.5933333,0.59407216,0.5966667,0.59407216,0.6,0.59407216,0.60333335,0.59407216,0.6066667,0.59407216,0.61,0.59407216,0.61333334,0.59407216,0.6166667,0.59407216,0.62,0.59407216,0.62333333,0.59407216,0.62666667,0.59407216,0.63,0.59407216,0.7033333,0.59407216,0.70666665,0.59407216,0.71,0.59407216,0.7133333,0.59407216,0.71666664,0.59407216,0.72,0.59407216,0.72333336,0.59407216,0.7266667,0.59407216,0.73,0.59407216,0.73333335,0.59407216,0.7366667,0.59407216,0.74,0.59407216,0.74333334,0.59407216,0.74666667,0.59407216,0.75,0.59407216,0.75333333,0.59407216,0.75666666,0.59407216,0.76,0.59407216,0.7633333,0.59407216,0.76666665,0.59407216,0.77,0.59407216,0.7733333,0.59407216,0.77666664,0.59407216,0.78,0.59407216,0.78333336,0.59407216,0.7866667,0.59407216,0.79,0.59407216,0.79333335,0.59407216,0.7966667,0.59407216,0.8,0.59407216,0.80333334,0.59407216,0.8066667,0.59407216,0.81,0.59407216,0.81333333,0.59407216,0.81666666,0.59407216,0.82,0.59407216,0.8233333,0.59407216,0.82666665,0.59407216,0.83,0.59407216,0.8333333,0.59407216,0.83666664,0.59407216,0.84,0.59407216,0.06,0.59664947,0.06333333,0.59664947,0.06666667,0.59664947,0.07,0.59664947,0.07333333,0.59664947,0.07666667,0.59664947,0.08,0.59664947,0.083333336,0.59664947,0.086666666,0.59664947,0.09,0.59664947,0.093333334,0.59664947,0.096666664,0.59664947,0.1,0.59664947,0.10333333,0.59664947,0.13333334,0.59664947,0.13666667,0.59664947,0.14,0.59664947,0.14333333,0.59664947,0.14666666,0.59664947,0.15,0.59664947,0.15333334,0.59664947,0.15666667,0.59664947,0.16,0.59664947,0.16333333,0.59664947,0.16666667,0.59664947,0.17,0.59664947,0.18333334,0.59664947,0.18666667,0.59664947,0.19,0.59664947,0.19333333,0.59664947,0.19666667,0.59664947,0.2,0.59664947,0.20333333,0.59664947,0.20666666,0.59664947,0.21,0.59664947,0.21333334,0.59664947,0.21666667,0.59664947,0.22,0.59664947,0.22333333,0.59664947,0.22666667,0.59664947,0.23,0.59664947,0.23333333,0.59664947,0.23666666,0.59664947,0.24,0.59664947,0.24333334,0.59664947,0.24666667,0.59664947,0.25,0.59664947,0.25333333,0.59664947,0.25666666,0.59664947,0.26,0.59664947,0.26333332,0.59664947,0.26666668,0.59664947,0.27,0.59664947,0.27333334,0.59664947,0.27666667,0.59664947,0.28,0.59664947,0.28333333,0.59664947,0.28666666,0.59664947,0.29,0.59664947,0.29333332,0.59664947,0.29666665,0.59664947,0.3,0.59664947,0.30333334,0.59664947,0.30666667,0.59664947,0.31,0.59664947,0.31333333,0.59664947,0.31666666,0.59664947,0.32,0.59664947,0.32333332,0.59664947,0.32666665,0.59664947,0.33,0.59664947,0.33333334,0.59664947,0.33666667,0.59664947,0.37333333,0.59664947,0.37666667,0.59664947,0.38,0.59664947,0.38333333,0.59664947,0.38666666,0.59664947,0.39,0.59664947,0.39333335,0.59664947,0.42666668,0.59664947,0.43,0.59664947,0.43333334,0.59664947,0.43666667,0.59664947,0.44,0.59664947,0.44333333,0.59664947,0.44666666,0.59664947,0.45,0.59664947,0.45333335,0.59664947,0.45666668,0.59664947,0.46,0.59664947,0.46333334,0.59664947,0.46666667,0.59664947,0.47,0.59664947,0.47333333,0.59664947,0.47666666,0.59664947,0.48,0.59664947,0.48333332,0.59664947,0.48666668,0.59664947,0.49,0.59664947,0.49333334,0.59664947,0.49666667,0.59664947,0.5,0.59664947,0.50333333,0.59664947,0.50666666,0.59664947,0.51,0.59664947,0.5133333,0.59664947,0.51666665,0.59664947,0.52,0.59664947,0.5233333,0.59664947,0.52666664,0.59664947,0.53,0.59664947,0.53333336,0.59664947,0.5366667,0.59664947,0.54,0.59664947,0.56,0.59664947,0.56333333,0.59664947,0.56666666,0.59664947,0.57,0.59664947,0.5733333,0.59664947,0.57666665,0.59664947,0.58,0.59664947,0.5833333,0.59664947,0.58666664,0.59664947,0.59,0.59664947,0.5933333,0.59664947,0.5966667,0.59664947,0.6,0.59664947,0.60333335,0.59664947,0.6066667,0.59664947,0.61,0.59664947,0.61333334,0.59664947,0.6166667,0.59664947,0.62,0.59664947,0.62333333,0.59664947,0.62666667,0.59664947,0.63,0.59664947,0.6333333,0.59664947,0.68666667,0.59664947,0.69,0.59664947,0.6933333,0.59664947,0.69666666,0.59664947,0.7,0.59664947,0.7033333,0.59664947,0.70666665,0.59664947,0.71,0.59664947,0.7133333,0.59664947,0.71666664,0.59664947,0.72,0.59664947,0.72333336,0.59664947,0.7266667,0.59664947,0.73,0.59664947,0.73333335,0.59664947,0.7366667,0.59664947,0.74,0.59664947,0.74333334,0.59664947,0.74666667,0.59664947,0.75,0.59664947,0.75333333,0.59664947,0.75666666,0.59664947,0.76,0.59664947,0.7633333,0.59664947,0.76666665,0.59664947,0.77,0.59664947,0.7733333,0.59664947,0.77666664,0.59664947,0.78,0.59664947,0.78333336,0.59664947,0.7866667,0.59664947,0.79,0.59664947,0.79333335,0.59664947,0.7966667,0.59664947,0.8,0.59664947,0.80333334,0.59664947,0.8066667,0.59664947,0.81,0.59664947,0.81333333,0.59664947,0.81666666,0.59664947,0.82,0.59664947,0.8233333,0.59664947,0.82666665,0.59664947,0.83,0.59664947,0.8333333,0.59664947,0.83666664,0.59664947,0.84,0.59664947,0.05666667,0.59922683,0.06,0.59922683,0.06333333,0.59922683,0.06666667,0.59922683,0.07,0.59922683,0.07333333,0.59922683,0.07666667,0.59922683,0.08,0.59922683,0.083333336,0.59922683,0.086666666,0.59922683,0.09,0.59922683,0.093333334,0.59922683,0.096666664,0.59922683,0.1,0.59922683,0.10333333,0.59922683,0.10666667,0.59922683,0.11,0.59922683,0.11333334,0.59922683,0.11666667,0.59922683,0.12666667,0.59922683,0.13,0.59922683,0.13333334,0.59922683,0.13666667,0.59922683,0.14,0.59922683,0.14333333,0.59922683,0.14666666,0.59922683,0.15,0.59922683,0.15333334,0.59922683,0.15666667,0.59922683,0.16,0.59922683,0.16333333,0.59922683,0.16666667,0.59922683,0.17,0.59922683,0.18333334,0.59922683,0.18666667,0.59922683,0.19,0.59922683,0.19333333,0.59922683,0.19666667,0.59922683,0.2,0.59922683,0.20333333,0.59922683,0.20666666,0.59922683,0.21,0.59922683,0.21333334,0.59922683,0.21666667,0.59922683,0.22,0.59922683,0.22333333,0.59922683,0.22666667,0.59922683,0.23,0.59922683,0.23333333,0.59922683,0.23666666,0.59922683,0.24,0.59922683,0.24333334,0.59922683,0.24666667,0.59922683,0.25,0.59922683,0.25333333,0.59922683,0.25666666,0.59922683,0.26,0.59922683,0.26333332,0.59922683,0.26666668,0.59922683,0.27,0.59922683,0.27333334,0.59922683,0.27666667,0.59922683,0.28,0.59922683,0.28333333,0.59922683,0.28666666,0.59922683,0.29,0.59922683,0.29333332,0.59922683,0.29666665,0.59922683,0.3,0.59922683,0.30333334,0.59922683,0.30666667,0.59922683,0.31,0.59922683,0.31333333,0.59922683,0.31666666,0.59922683,0.32,0.59922683,0.32333332,0.59922683,0.32666665,0.59922683,0.33,0.59922683,0.33333334,0.59922683,0.33666667,0.59922683,0.37,0.59922683,0.37333333,0.59922683,0.37666667,0.59922683,0.38,0.59922683,0.38333333,0.59922683,0.38666666,0.59922683,0.39,0.59922683,0.39333335,0.59922683,0.39666668,0.59922683,0.43,0.59922683,0.43333334,0.59922683,0.43666667,0.59922683,0.44,0.59922683,0.44333333,0.59922683,0.44666666,0.59922683,0.45,0.59922683,0.45333335,0.59922683,0.45666668,0.59922683,0.46,0.59922683,0.46333334,0.59922683,0.46666667,0.59922683,0.47,0.59922683,0.47333333,0.59922683,0.47666666,0.59922683,0.48,0.59922683,0.48333332,0.59922683,0.48666668,0.59922683,0.49,0.59922683,0.49333334,0.59922683,0.49666667,0.59922683,0.5,0.59922683,0.50333333,0.59922683,0.50666666,0.59922683,0.51,0.59922683,0.5133333,0.59922683,0.51666665,0.59922683,0.52,0.59922683,0.5233333,0.59922683,0.52666664,0.59922683,0.53,0.59922683,0.53333336,0.59922683,0.5366667,0.59922683,0.54,0.59922683,0.54333335,0.59922683,0.5466667,0.59922683,0.55,0.59922683,0.55333334,0.59922683,0.5566667,0.59922683,0.56,0.59922683,0.56333333,0.59922683,0.56666666,0.59922683,0.57,0.59922683,0.5733333,0.59922683,0.57666665,0.59922683,0.58,0.59922683,0.5833333,0.59922683,0.58666664,0.59922683,0.59,0.59922683,0.5933333,0.59922683,0.5966667,0.59922683,0.6,0.59922683,0.60333335,0.59922683,0.6066667,0.59922683,0.61,0.59922683,0.61333334,0.59922683,0.6166667,0.59922683,0.62,0.59922683,0.62333333,0.59922683,0.62666667,0.59922683,0.63,0.59922683,0.6333333,0.59922683,0.6766667,0.59922683,0.68,0.59922683,0.68333334,0.59922683,0.68666667,0.59922683,0.69,0.59922683,0.6933333,0.59922683,0.69666666,0.59922683,0.7,0.59922683,0.7033333,0.59922683,0.70666665,0.59922683,0.71,0.59922683,0.7133333,0.59922683,0.71666664,0.59922683,0.72,0.59922683,0.72333336,0.59922683,0.7266667,0.59922683,0.73,0.59922683,0.73333335,0.59922683,0.7366667,0.59922683,0.74,0.59922683,0.74333334,0.59922683,0.74666667,0.59922683,0.75,0.59922683,0.75333333,0.59922683,0.75666666,0.59922683,0.76,0.59922683,0.7633333,0.59922683,0.76666665,0.59922683,0.77,0.59922683,0.7733333,0.59922683,0.77666664,0.59922683,0.78,0.59922683,0.78333336,0.59922683,0.7866667,0.59922683,0.79,0.59922683,0.79333335,0.59922683,0.7966667,0.59922683,0.8,0.59922683,0.80333334,0.59922683,0.8066667,0.59922683,0.81,0.59922683,0.81333333,0.59922683,0.81666666,0.59922683,0.82,0.59922683,0.8233333,0.59922683,0.82666665,0.59922683,0.83,0.59922683,0.8333333,0.59922683,0.83666664,0.59922683,0.84,0.59922683,0.8833333,0.59922683,0.88666666,0.59922683,0.053333335,0.60180414,0.05666667,0.60180414,0.06,0.60180414,0.06333333,0.60180414,0.06666667,0.60180414,0.07,0.60180414,0.07333333,0.60180414,0.07666667,0.60180414,0.08,0.60180414,0.083333336,0.60180414,0.086666666,0.60180414,0.09,0.60180414,0.093333334,0.60180414,0.096666664,0.60180414,0.1,0.60180414,0.10333333,0.60180414,0.10666667,0.60180414,0.11,0.60180414,0.11333334,0.60180414,0.11666667,0.60180414,0.12,0.60180414,0.123333335,0.60180414,0.12666667,0.60180414,0.13,0.60180414,0.13333334,0.60180414,0.13666667,0.60180414,0.14,0.60180414,0.14333333,0.60180414,0.14666666,0.60180414,0.15,0.60180414,0.15333334,0.60180414,0.15666667,0.60180414,0.16,0.60180414,0.16333333,0.60180414,0.16666667,0.60180414,0.17,0.60180414,0.17333333,0.60180414,0.17666666,0.60180414,0.18,0.60180414,0.18333334,0.60180414,0.18666667,0.60180414,0.19,0.60180414,0.19333333,0.60180414,0.19666667,0.60180414,0.2,0.60180414,0.20333333,0.60180414,0.20666666,0.60180414,0.21,0.60180414,0.21333334,0.60180414,0.21666667,0.60180414,0.22,0.60180414,0.22333333,0.60180414,0.22666667,0.60180414,0.23,0.60180414,0.23333333,0.60180414,0.23666666,0.60180414,0.24,0.60180414,0.24333334,0.60180414,0.24666667,0.60180414,0.25,0.60180414,0.25333333,0.60180414,0.25666666,0.60180414,0.26,0.60180414,0.26333332,0.60180414,0.26666668,0.60180414,0.27,0.60180414,0.27333334,0.60180414,0.27666667,0.60180414,0.28,0.60180414,0.28333333,0.60180414,0.28666666,0.60180414,0.29,0.60180414,0.29333332,0.60180414,0.29666665,0.60180414,0.3,0.60180414,0.30333334,0.60180414,0.30666667,0.60180414,0.31,0.60180414,0.31333333,0.60180414,0.31666666,0.60180414,0.32,0.60180414,0.32333332,0.60180414,0.32666665,0.60180414,0.33,0.60180414,0.33333334,0.60180414,0.33666667,0.60180414,0.34,0.60180414,0.37,0.60180414,0.37333333,0.60180414,0.37666667,0.60180414,0.38,0.60180414,0.38333333,0.60180414,0.38666666,0.60180414,0.39,0.60180414,0.39333335,0.60180414,0.39666668,0.60180414,0.4,0.60180414,0.43,0.60180414,0.43333334,0.60180414,0.43666667,0.60180414,0.44,0.60180414,0.44333333,0.60180414,0.44666666,0.60180414,0.45,0.60180414,0.45333335,0.60180414,0.45666668,0.60180414,0.46,0.60180414,0.46333334,0.60180414,0.46666667,0.60180414,0.47,0.60180414,0.47333333,0.60180414,0.47666666,0.60180414,0.48,0.60180414,0.48333332,0.60180414,0.48666668,0.60180414,0.49,0.60180414,0.49333334,0.60180414,0.49666667,0.60180414,0.5,0.60180414,0.50333333,0.60180414,0.50666666,0.60180414,0.51,0.60180414,0.5133333,0.60180414,0.51666665,0.60180414,0.52,0.60180414,0.5233333,0.60180414,0.52666664,0.60180414,0.53,0.60180414,0.53333336,0.60180414,0.5366667,0.60180414,0.54,0.60180414,0.54333335,0.60180414,0.5466667,0.60180414,0.55,0.60180414,0.55333334,0.60180414,0.5566667,0.60180414,0.56,0.60180414,0.56333333,0.60180414,0.56666666,0.60180414,0.57,0.60180414,0.5733333,0.60180414,0.57666665,0.60180414,0.58,0.60180414,0.5833333,0.60180414,0.58666664,0.60180414,0.59,0.60180414,0.5933333,0.60180414,0.5966667,0.60180414,0.6,0.60180414,0.60333335,0.60180414,0.6066667,0.60180414,0.61,0.60180414,0.61333334,0.60180414,0.6166667,0.60180414,0.62,0.60180414,0.62333333,0.60180414,0.62666667,0.60180414,0.63,0.60180414,0.6333333,0.60180414,0.66333336,0.60180414,0.6666667,0.60180414,0.67,0.60180414,0.67333335,0.60180414,0.6766667,0.60180414,0.68,0.60180414,0.68333334,0.60180414,0.68666667,0.60180414,0.69,0.60180414,0.6933333,0.60180414,0.69666666,0.60180414,0.7,0.60180414,0.7033333,0.60180414,0.70666665,0.60180414,0.71,0.60180414,0.7133333,0.60180414,0.71666664,0.60180414,0.72,0.60180414,0.72333336,0.60180414,0.7266667,0.60180414,0.73,0.60180414,0.73333335,0.60180414,0.7366667,0.60180414,0.74,0.60180414,0.74333334,0.60180414,0.74666667,0.60180414,0.75,0.60180414,0.75333333,0.60180414,0.75666666,0.60180414,0.76,0.60180414,0.7633333,0.60180414,0.76666665,0.60180414,0.77,0.60180414,0.7733333,0.60180414,0.77666664,0.60180414,0.78,0.60180414,0.78333336,0.60180414,0.7866667,0.60180414,0.79,0.60180414,0.79333335,0.60180414,0.7966667,0.60180414,0.8,0.60180414,0.80333334,0.60180414,0.8066667,0.60180414,0.81,0.60180414,0.81333333,0.60180414,0.81666666,0.60180414,0.82,0.60180414,0.8233333,0.60180414,0.82666665,0.60180414,0.83,0.60180414,0.8333333,0.60180414,0.83666664,0.60180414,0.84,0.60180414,0.8433333,0.60180414,0.87333333,0.60180414,0.87666667,0.60180414,0.88,0.60180414,0.8833333,0.60180414,0.88666666,0.60180414,0.89,0.60180414,0.8933333,0.60180414,0.89666665,0.60180414,0.9,0.60180414,0.9033333,0.60180414,0.05,0.60438144,0.053333335,0.60438144,0.05666667,0.60438144,0.06,0.60438144,0.06333333,0.60438144,0.06666667,0.60438144,0.07,0.60438144,0.07333333,0.60438144,0.07666667,0.60438144,0.08,0.60438144,0.083333336,0.60438144,0.086666666,0.60438144,0.09,0.60438144,0.093333334,0.60438144,0.096666664,0.60438144,0.1,0.60438144,0.10333333,0.60438144,0.10666667,0.60438144,0.11,0.60438144,0.11333334,0.60438144,0.11666667,0.60438144,0.12,0.60438144,0.123333335,0.60438144,0.12666667,0.60438144,0.13,0.60438144,0.13333334,0.60438144,0.13666667,0.60438144,0.14,0.60438144,0.14333333,0.60438144,0.14666666,0.60438144,0.15,0.60438144,0.15333334,0.60438144,0.15666667,0.60438144,0.16,0.60438144,0.16333333,0.60438144,0.16666667,0.60438144,0.17,0.60438144,0.17333333,0.60438144,0.17666666,0.60438144,0.18,0.60438144,0.18333334,0.60438144,0.18666667,0.60438144,0.19,0.60438144,0.19333333,0.60438144,0.19666667,0.60438144,0.2,0.60438144,0.20333333,0.60438144,0.20666666,0.60438144,0.21,0.60438144,0.21333334,0.60438144,0.21666667,0.60438144,0.22,0.60438144,0.22333333,0.60438144,0.22666667,0.60438144,0.23,0.60438144,0.23333333,0.60438144,0.23666666,0.60438144,0.24,0.60438144,0.24333334,0.60438144,0.24666667,0.60438144,0.25,0.60438144,0.25333333,0.60438144,0.25666666,0.60438144,0.26,0.60438144,0.26333332,0.60438144,0.26666668,0.60438144,0.27,0.60438144,0.27333334,0.60438144,0.27666667,0.60438144,0.28,0.60438144,0.28333333,0.60438144,0.28666666,0.60438144,0.29,0.60438144,0.29333332,0.60438144,0.29666665,0.60438144,0.3,0.60438144,0.30333334,0.60438144,0.30666667,0.60438144,0.31,0.60438144,0.31333333,0.60438144,0.31666666,0.60438144,0.32,0.60438144,0.32333332,0.60438144,0.32666665,0.60438144,0.33,0.60438144,0.33333334,0.60438144,0.33666667,0.60438144,0.34,0.60438144,0.36666667,0.60438144,0.37,0.60438144,0.37333333,0.60438144,0.37666667,0.60438144,0.38,0.60438144,0.38333333,0.60438144,0.38666666,0.60438144,0.39,0.60438144,0.39333335,0.60438144,0.39666668,0.60438144,0.4,0.60438144,0.40333334,0.60438144,0.43333334,0.60438144,0.43666667,0.60438144,0.44,0.60438144,0.44333333,0.60438144,0.44666666,0.60438144,0.45,0.60438144,0.45333335,0.60438144,0.45666668,0.60438144,0.46,0.60438144,0.46333334,0.60438144,0.46666667,0.60438144,0.47,0.60438144,0.47333333,0.60438144,0.47666666,0.60438144,0.48,0.60438144,0.48333332,0.60438144,0.48666668,0.60438144,0.49,0.60438144,0.49333334,0.60438144,0.49666667,0.60438144,0.5,0.60438144,0.50333333,0.60438144,0.50666666,0.60438144,0.51,0.60438144,0.5133333,0.60438144,0.51666665,0.60438144,0.52,0.60438144,0.5233333,0.60438144,0.52666664,0.60438144,0.53,0.60438144,0.53333336,0.60438144,0.5366667,0.60438144,0.54,0.60438144,0.54333335,0.60438144,0.5466667,0.60438144,0.55,0.60438144,0.55333334,0.60438144,0.5566667,0.60438144,0.56,0.60438144,0.56333333,0.60438144,0.56666666,0.60438144,0.57,0.60438144,0.5733333,0.60438144,0.57666665,0.60438144,0.58,0.60438144,0.5833333,0.60438144,0.58666664,0.60438144,0.59,0.60438144,0.5933333,0.60438144,0.5966667,0.60438144,0.6,0.60438144,0.60333335,0.60438144,0.6066667,0.60438144,0.61,0.60438144,0.61333334,0.60438144,0.6166667,0.60438144,0.62,0.60438144,0.62333333,0.60438144,0.62666667,0.60438144,0.63,0.60438144,0.66,0.60438144,0.66333336,0.60438144,0.6666667,0.60438144,0.67,0.60438144,0.67333335,0.60438144,0.6766667,0.60438144,0.68,0.60438144,0.68333334,0.60438144,0.68666667,0.60438144,0.69,0.60438144,0.6933333,0.60438144,0.69666666,0.60438144,0.7,0.60438144,0.7033333,0.60438144,0.70666665,0.60438144,0.71,0.60438144,0.7133333,0.60438144,0.71666664,0.60438144,0.72,0.60438144,0.72333336,0.60438144,0.7266667,0.60438144,0.73,0.60438144,0.73333335,0.60438144,0.7366667,0.60438144,0.74,0.60438144,0.74333334,0.60438144,0.74666667,0.60438144,0.75,0.60438144,0.75333333,0.60438144,0.75666666,0.60438144,0.76,0.60438144,0.7633333,0.60438144,0.76666665,0.60438144,0.77,0.60438144,0.7733333,0.60438144,0.77666664,0.60438144,0.78,0.60438144,0.78333336,0.60438144,0.7866667,0.60438144,0.79,0.60438144,0.79333335,0.60438144,0.7966667,0.60438144,0.8,0.60438144,0.80333334,0.60438144,0.8066667,0.60438144,0.81,0.60438144,0.81333333,0.60438144,0.81666666,0.60438144,0.82,0.60438144,0.8233333,0.60438144,0.82666665,0.60438144,0.83,0.60438144,0.8333333,0.60438144,0.83666664,0.60438144,0.84,0.60438144,0.8433333,0.60438144,0.8666667,0.60438144,0.87,0.60438144,0.87333333,0.60438144,0.87666667,0.60438144,0.88,0.60438144,0.8833333,0.60438144,0.88666666,0.60438144,0.89,0.60438144,0.8933333,0.60438144,0.89666665,0.60438144,0.9,0.60438144,0.9033333,0.60438144,0.9066667,0.60438144,0.91,0.60438144,0.05,0.60695875,0.053333335,0.60695875,0.05666667,0.60695875,0.06,0.60695875,0.06333333,0.60695875,0.06666667,0.60695875,0.07,0.60695875,0.07333333,0.60695875,0.07666667,0.60695875,0.08,0.60695875,0.083333336,0.60695875,0.086666666,0.60695875,0.09,0.60695875,0.093333334,0.60695875,0.096666664,0.60695875,0.1,0.60695875,0.10333333,0.60695875,0.10666667,0.60695875,0.11,0.60695875,0.11333334,0.60695875,0.11666667,0.60695875,0.12,0.60695875,0.123333335,0.60695875,0.12666667,0.60695875,0.13,0.60695875,0.13333334,0.60695875,0.13666667,0.60695875,0.14,0.60695875,0.14333333,0.60695875,0.14666666,0.60695875,0.15,0.60695875,0.15333334,0.60695875,0.15666667,0.60695875,0.16,0.60695875,0.16333333,0.60695875,0.16666667,0.60695875,0.17,0.60695875,0.17333333,0.60695875,0.17666666,0.60695875,0.18,0.60695875,0.18333334,0.60695875,0.18666667,0.60695875,0.19,0.60695875,0.19333333,0.60695875,0.19666667,0.60695875,0.2,0.60695875,0.20333333,0.60695875,0.20666666,0.60695875,0.21,0.60695875,0.21333334,0.60695875,0.21666667,0.60695875,0.22,0.60695875,0.22333333,0.60695875,0.22666667,0.60695875,0.23,0.60695875,0.23333333,0.60695875,0.23666666,0.60695875,0.24,0.60695875,0.24333334,0.60695875,0.24666667,0.60695875,0.25,0.60695875,0.25333333,0.60695875,0.25666666,0.60695875,0.26,0.60695875,0.26333332,0.60695875,0.26666668,0.60695875,0.27,0.60695875,0.27333334,0.60695875,0.27666667,0.60695875,0.28,0.60695875,0.28333333,0.60695875,0.28666666,0.60695875,0.29,0.60695875,0.29333332,0.60695875,0.29666665,0.60695875,0.3,0.60695875,0.30333334,0.60695875,0.30666667,0.60695875,0.31,0.60695875,0.31333333,0.60695875,0.31666666,0.60695875,0.32,0.60695875,0.32333332,0.60695875,0.32666665,0.60695875,0.33,0.60695875,0.33333334,0.60695875,0.33666667,0.60695875,0.34,0.60695875,0.36333334,0.60695875,0.36666667,0.60695875,0.37,0.60695875,0.37333333,0.60695875,0.37666667,0.60695875,0.38,0.60695875,0.38333333,0.60695875,0.38666666,0.60695875,0.39,0.60695875,0.39333335,0.60695875,0.39666668,0.60695875,0.4,0.60695875,0.40333334,0.60695875,0.40666667,0.60695875,0.43333334,0.60695875,0.43666667,0.60695875,0.44,0.60695875,0.44333333,0.60695875,0.44666666,0.60695875,0.45,0.60695875,0.45333335,0.60695875,0.45666668,0.60695875,0.46,0.60695875,0.46333334,0.60695875,0.46666667,0.60695875,0.47,0.60695875,0.47333333,0.60695875,0.47666666,0.60695875,0.48,0.60695875,0.48333332,0.60695875,0.48666668,0.60695875,0.49,0.60695875,0.49333334,0.60695875,0.49666667,0.60695875,0.5,0.60695875,0.50333333,0.60695875,0.50666666,0.60695875,0.51,0.60695875,0.5133333,0.60695875,0.51666665,0.60695875,0.52,0.60695875,0.5233333,0.60695875,0.52666664,0.60695875,0.53,0.60695875,0.53333336,0.60695875,0.5366667,0.60695875,0.54,0.60695875,0.54333335,0.60695875,0.5466667,0.60695875,0.55,0.60695875,0.55333334,0.60695875,0.5566667,0.60695875,0.56,0.60695875,0.56333333,0.60695875,0.56666666,0.60695875,0.57,0.60695875,0.5733333,0.60695875,0.57666665,0.60695875,0.58,0.60695875,0.5833333,0.60695875,0.58666664,0.60695875,0.59,0.60695875,0.5933333,0.60695875,0.5966667,0.60695875,0.6,0.60695875,0.60333335,0.60695875,0.6066667,0.60695875,0.61,0.60695875,0.61333334,0.60695875,0.6166667,0.60695875,0.62,0.60695875,0.62333333,0.60695875,0.62666667,0.60695875,0.63,0.60695875,0.6566667,0.60695875,0.66,0.60695875,0.66333336,0.60695875,0.6666667,0.60695875,0.67,0.60695875,0.67333335,0.60695875,0.6766667,0.60695875,0.68,0.60695875,0.68333334,0.60695875,0.68666667,0.60695875,0.69,0.60695875,0.6933333,0.60695875,0.69666666,0.60695875,0.7,0.60695875,0.7033333,0.60695875,0.70666665,0.60695875,0.71,0.60695875,0.7133333,0.60695875,0.71666664,0.60695875,0.72,0.60695875,0.72333336,0.60695875,0.7266667,0.60695875,0.73,0.60695875,0.73333335,0.60695875,0.7366667,0.60695875,0.74,0.60695875,0.74333334,0.60695875,0.74666667,0.60695875,0.75,0.60695875,0.75333333,0.60695875,0.75666666,0.60695875,0.76,0.60695875,0.7633333,0.60695875,0.76666665,0.60695875,0.77,0.60695875,0.7733333,0.60695875,0.77666664,0.60695875,0.78,0.60695875,0.78333336,0.60695875,0.7866667,0.60695875,0.79,0.60695875,0.79333335,0.60695875,0.7966667,0.60695875,0.8,0.60695875,0.80333334,0.60695875,0.8066667,0.60695875,0.81,0.60695875,0.81333333,0.60695875,0.81666666,0.60695875,0.82,0.60695875,0.8233333,0.60695875,0.82666665,0.60695875,0.83,0.60695875,0.8333333,0.60695875,0.83666664,0.60695875,0.84,0.60695875,0.8433333,0.60695875,0.8466667,0.60695875,0.85,0.60695875,0.85333335,0.60695875,0.8566667,0.60695875,0.86,0.60695875,0.86333334,0.60695875,0.8666667,0.60695875,0.87,0.60695875,0.87333333,0.60695875,0.87666667,0.60695875,0.88,0.60695875,0.8833333,0.60695875,0.88666666,0.60695875,0.89,0.60695875,0.8933333,0.60695875,0.89666665,0.60695875,0.9,0.60695875,0.9033333,0.60695875,0.9066667,0.60695875,0.91,0.60695875,0.91333336,0.60695875,0.046666667,0.6095361,0.05,0.6095361,0.053333335,0.6095361,0.05666667,0.6095361,0.06,0.6095361,0.06333333,0.6095361,0.06666667,0.6095361,0.07,0.6095361,0.07333333,0.6095361,0.07666667,0.6095361,0.08,0.6095361,0.083333336,0.6095361,0.086666666,0.6095361,0.09,0.6095361,0.093333334,0.6095361,0.096666664,0.6095361,0.1,0.6095361,0.10333333,0.6095361,0.10666667,0.6095361,0.11,0.6095361,0.11333334,0.6095361,0.11666667,0.6095361,0.12,0.6095361,0.123333335,0.6095361,0.12666667,0.6095361,0.13,0.6095361,0.13333334,0.6095361,0.13666667,0.6095361,0.14,0.6095361,0.14333333,0.6095361,0.14666666,0.6095361,0.15,0.6095361,0.15333334,0.6095361,0.15666667,0.6095361,0.16,0.6095361,0.16333333,0.6095361,0.16666667,0.6095361,0.17,0.6095361,0.17333333,0.6095361,0.17666666,0.6095361,0.18,0.6095361,0.18333334,0.6095361,0.18666667,0.6095361,0.19,0.6095361,0.19333333,0.6095361,0.19666667,0.6095361,0.2,0.6095361,0.20333333,0.6095361,0.20666666,0.6095361,0.21,0.6095361,0.21333334,0.6095361,0.21666667,0.6095361,0.22,0.6095361,0.22333333,0.6095361,0.22666667,0.6095361,0.23,0.6095361,0.23333333,0.6095361,0.23666666,0.6095361,0.24,0.6095361,0.24333334,0.6095361,0.24666667,0.6095361,0.25,0.6095361,0.25333333,0.6095361,0.25666666,0.6095361,0.26,0.6095361,0.26333332,0.6095361,0.26666668,0.6095361,0.27,0.6095361,0.27333334,0.6095361,0.27666667,0.6095361,0.28,0.6095361,0.28333333,0.6095361,0.28666666,0.6095361,0.29,0.6095361,0.29333332,0.6095361,0.29666665,0.6095361,0.30666667,0.6095361,0.31,0.6095361,0.31333333,0.6095361,0.31666666,0.6095361,0.32,0.6095361,0.32333332,0.6095361,0.32666665,0.6095361,0.33,0.6095361,0.33333334,0.6095361,0.33666667,0.6095361,0.34,0.6095361,0.34333333,0.6095361,0.36333334,0.6095361,0.36666667,0.6095361,0.37,0.6095361,0.37333333,0.6095361,0.37666667,0.6095361,0.38,0.6095361,0.38333333,0.6095361,0.38666666,0.6095361,0.39,0.6095361,0.39333335,0.6095361,0.39666668,0.6095361,0.4,0.6095361,0.40333334,0.6095361,0.40666667,0.6095361,0.41,0.6095361,0.43,0.6095361,0.43333334,0.6095361,0.43666667,0.6095361,0.44,0.6095361,0.44333333,0.6095361,0.44666666,0.6095361,0.45,0.6095361,0.45333335,0.6095361,0.45666668,0.6095361,0.46,0.6095361,0.46333334,0.6095361,0.46666667,0.6095361,0.47,0.6095361,0.47333333,0.6095361,0.47666666,0.6095361,0.48,0.6095361,0.48333332,0.6095361,0.48666668,0.6095361,0.49,0.6095361,0.49333334,0.6095361,0.49666667,0.6095361,0.5,0.6095361,0.50333333,0.6095361,0.5133333,0.6095361,0.51666665,0.6095361,0.52,0.6095361,0.5233333,0.6095361,0.52666664,0.6095361,0.53,0.6095361,0.53333336,0.6095361,0.5366667,0.6095361,0.54,0.6095361,0.54333335,0.6095361,0.5466667,0.6095361,0.55,0.6095361,0.55333334,0.6095361,0.5566667,0.6095361,0.56,0.6095361,0.56333333,0.6095361,0.56666666,0.6095361,0.57,0.6095361,0.5733333,0.6095361,0.57666665,0.6095361,0.58,0.6095361,0.5833333,0.6095361,0.58666664,0.6095361,0.59,0.6095361,0.5933333,0.6095361,0.5966667,0.6095361,0.6,0.6095361,0.60333335,0.6095361,0.6066667,0.6095361,0.61,0.6095361,0.61333334,0.6095361,0.6166667,0.6095361,0.62,0.6095361,0.62333333,0.6095361,0.62666667,0.6095361,0.6566667,0.6095361,0.66,0.6095361,0.66333336,0.6095361,0.6666667,0.6095361,0.67,0.6095361,0.67333335,0.6095361,0.6766667,0.6095361,0.68,0.6095361,0.68333334,0.6095361,0.68666667,0.6095361,0.69,0.6095361,0.6933333,0.6095361,0.69666666,0.6095361,0.7,0.6095361,0.7033333,0.6095361,0.70666665,0.6095361,0.71,0.6095361,0.7133333,0.6095361,0.71666664,0.6095361,0.72,0.6095361,0.72333336,0.6095361,0.7266667,0.6095361,0.73,0.6095361,0.73333335,0.6095361,0.7366667,0.6095361,0.74,0.6095361,0.74333334,0.6095361,0.74666667,0.6095361,0.75,0.6095361,0.75333333,0.6095361,0.75666666,0.6095361,0.76,0.6095361,0.7633333,0.6095361,0.76666665,0.6095361,0.77,0.6095361,0.7733333,0.6095361,0.77666664,0.6095361,0.78,0.6095361,0.78333336,0.6095361,0.7866667,0.6095361,0.79,0.6095361,0.79333335,0.6095361,0.7966667,0.6095361,0.8,0.6095361,0.80333334,0.6095361,0.8066667,0.6095361,0.81,0.6095361,0.81333333,0.6095361,0.81666666,0.6095361,0.82,0.6095361,0.8233333,0.6095361,0.82666665,0.6095361,0.83,0.6095361,0.8333333,0.6095361,0.83666664,0.6095361,0.84,0.6095361,0.8433333,0.6095361,0.8466667,0.6095361,0.85,0.6095361,0.85333335,0.6095361,0.8566667,0.6095361,0.86,0.6095361,0.86333334,0.6095361,0.8666667,0.6095361,0.87,0.6095361,0.87333333,0.6095361,0.87666667,0.6095361,0.88,0.6095361,0.8833333,0.6095361,0.88666666,0.6095361,0.89,0.6095361,0.8933333,0.6095361,0.89666665,0.6095361,0.9,0.6095361,0.9033333,0.6095361,0.9066667,0.6095361,0.91,0.6095361,0.91333336,0.6095361,0.9166667,0.6095361,0.046666667,0.6121134,0.05,0.6121134,0.053333335,0.6121134,0.05666667,0.6121134,0.06,0.6121134,0.06333333,0.6121134,0.06666667,0.6121134,0.07,0.6121134,0.07333333,0.6121134,0.07666667,0.6121134,0.08,0.6121134,0.083333336,0.6121134,0.086666666,0.6121134,0.09,0.6121134,0.093333334,0.6121134,0.096666664,0.6121134,0.1,0.6121134,0.10333333,0.6121134,0.10666667,0.6121134,0.11,0.6121134,0.11333334,0.6121134,0.11666667,0.6121134,0.12,0.6121134,0.123333335,0.6121134,0.12666667,0.6121134,0.13,0.6121134,0.13333334,0.6121134,0.13666667,0.6121134,0.14,0.6121134,0.14333333,0.6121134,0.14666666,0.6121134,0.15,0.6121134,0.15333334,0.6121134,0.15666667,0.6121134,0.16,0.6121134,0.16333333,0.6121134,0.16666667,0.6121134,0.17,0.6121134,0.17333333,0.6121134,0.17666666,0.6121134,0.18,0.6121134,0.18333334,0.6121134,0.18666667,0.6121134,0.19,0.6121134,0.19333333,0.6121134,0.19666667,0.6121134,0.2,0.6121134,0.20333333,0.6121134,0.20666666,0.6121134,0.21,0.6121134,0.21333334,0.6121134,0.21666667,0.6121134,0.22,0.6121134,0.22333333,0.6121134,0.22666667,0.6121134,0.23,0.6121134,0.23333333,0.6121134,0.23666666,0.6121134,0.24,0.6121134,0.24333334,0.6121134,0.24666667,0.6121134,0.25,0.6121134,0.25333333,0.6121134,0.25666666,0.6121134,0.26,0.6121134,0.26333332,0.6121134,0.26666668,0.6121134,0.27,0.6121134,0.27333334,0.6121134,0.27666667,0.6121134,0.28,0.6121134,0.28333333,0.6121134,0.32,0.6121134,0.32333332,0.6121134,0.32666665,0.6121134,0.33,0.6121134,0.33333334,0.6121134,0.33666667,0.6121134,0.34,0.6121134,0.34333333,0.6121134,0.36333334,0.6121134,0.36666667,0.6121134,0.37,0.6121134,0.37333333,0.6121134,0.37666667,0.6121134,0.38,0.6121134,0.38333333,0.6121134,0.38666666,0.6121134,0.39,0.6121134,0.39333335,0.6121134,0.39666668,0.6121134,0.4,0.6121134,0.40333334,0.6121134,0.40666667,0.6121134,0.41,0.6121134,0.41333333,0.6121134,0.41666666,0.6121134,0.42,0.6121134,0.42333335,0.6121134,0.42666668,0.6121134,0.43,0.6121134,0.43333334,0.6121134,0.43666667,0.6121134,0.44,0.6121134,0.44333333,0.6121134,0.44666666,0.6121134,0.45,0.6121134,0.45333335,0.6121134,0.50666666,0.6121134,0.5366667,0.6121134,0.54,0.6121134,0.54333335,0.6121134,0.5466667,0.6121134,0.55,0.6121134,0.55333334,0.6121134,0.5566667,0.6121134,0.56,0.6121134,0.56333333,0.6121134,0.56666666,0.6121134,0.57,0.6121134,0.5733333,0.6121134,0.57666665,0.6121134,0.58,0.6121134,0.5833333,0.6121134,0.58666664,0.6121134,0.59,0.6121134,0.5933333,0.6121134,0.5966667,0.6121134,0.6,0.6121134,0.60333335,0.6121134,0.6066667,0.6121134,0.61,0.6121134,0.61333334,0.6121134,0.6166667,0.6121134,0.62,0.6121134,0.62333333,0.6121134,0.6533333,0.6121134,0.6566667,0.6121134,0.66,0.6121134,0.66333336,0.6121134,0.6666667,0.6121134,0.67,0.6121134,0.67333335,0.6121134,0.6766667,0.6121134,0.68,0.6121134,0.68333334,0.6121134,0.68666667,0.6121134,0.69,0.6121134,0.6933333,0.6121134,0.69666666,0.6121134,0.7,0.6121134,0.7033333,0.6121134,0.70666665,0.6121134,0.71,0.6121134,0.7133333,0.6121134,0.71666664,0.6121134,0.72,0.6121134,0.72333336,0.6121134,0.7266667,0.6121134,0.73,0.6121134,0.73333335,0.6121134,0.7366667,0.6121134,0.74,0.6121134,0.74333334,0.6121134,0.74666667,0.6121134,0.75,0.6121134,0.75333333,0.6121134,0.75666666,0.6121134,0.76,0.6121134,0.7633333,0.6121134,0.76666665,0.6121134,0.77,0.6121134,0.7733333,0.6121134,0.77666664,0.6121134,0.78,0.6121134,0.78333336,0.6121134,0.7866667,0.6121134,0.79,0.6121134,0.79333335,0.6121134,0.7966667,0.6121134,0.8,0.6121134,0.80333334,0.6121134,0.8066667,0.6121134,0.81,0.6121134,0.81333333,0.6121134,0.81666666,0.6121134,0.82,0.6121134,0.8233333,0.6121134,0.82666665,0.6121134,0.83,0.6121134,0.8333333,0.6121134,0.83666664,0.6121134,0.84,0.6121134,0.8433333,0.6121134,0.8466667,0.6121134,0.85,0.6121134,0.85333335,0.6121134,0.8566667,0.6121134,0.86,0.6121134,0.86333334,0.6121134,0.8666667,0.6121134,0.87,0.6121134,0.87333333,0.6121134,0.87666667,0.6121134,0.88,0.6121134,0.8833333,0.6121134,0.88666666,0.6121134,0.89,0.6121134,0.8933333,0.6121134,0.89666665,0.6121134,0.9,0.6121134,0.9033333,0.6121134,0.9066667,0.6121134,0.91,0.6121134,0.91333336,0.6121134,0.9166667,0.6121134,0.92,0.6121134,0.043333333,0.6146907,0.046666667,0.6146907,0.05,0.6146907,0.053333335,0.6146907,0.05666667,0.6146907,0.06,0.6146907,0.06333333,0.6146907,0.06666667,0.6146907,0.07,0.6146907,0.07333333,0.6146907,0.07666667,0.6146907,0.08,0.6146907,0.083333336,0.6146907,0.086666666,0.6146907,0.09,0.6146907,0.093333334,0.6146907,0.096666664,0.6146907,0.1,0.6146907,0.10333333,0.6146907,0.10666667,0.6146907,0.11,0.6146907,0.11333334,0.6146907,0.11666667,0.6146907,0.12,0.6146907,0.123333335,0.6146907,0.12666667,0.6146907,0.13,0.6146907,0.13333334,0.6146907,0.13666667,0.6146907,0.14,0.6146907,0.14333333,0.6146907,0.14666666,0.6146907,0.15,0.6146907,0.15333334,0.6146907,0.15666667,0.6146907,0.16,0.6146907,0.16333333,0.6146907,0.16666667,0.6146907,0.17,0.6146907,0.17333333,0.6146907,0.17666666,0.6146907,0.18,0.6146907,0.18333334,0.6146907,0.18666667,0.6146907,0.19,0.6146907,0.19333333,0.6146907,0.19666667,0.6146907,0.2,0.6146907,0.20333333,0.6146907,0.20666666,0.6146907,0.21,0.6146907,0.21333334,0.6146907,0.21666667,0.6146907,0.22,0.6146907,0.22333333,0.6146907,0.22666667,0.6146907,0.23,0.6146907,0.23333333,0.6146907,0.23666666,0.6146907,0.24,0.6146907,0.24333334,0.6146907,0.24666667,0.6146907,0.25,0.6146907,0.25333333,0.6146907,0.25666666,0.6146907,0.26,0.6146907,0.26333332,0.6146907,0.26666668,0.6146907,0.27,0.6146907,0.27333334,0.6146907,0.27666667,0.6146907,0.32333332,0.6146907,0.32666665,0.6146907,0.33,0.6146907,0.33333334,0.6146907,0.33666667,0.6146907,0.34,0.6146907,0.34333333,0.6146907,0.36333334,0.6146907,0.36666667,0.6146907,0.37,0.6146907,0.37333333,0.6146907,0.37666667,0.6146907,0.38,0.6146907,0.38333333,0.6146907,0.38666666,0.6146907,0.39,0.6146907,0.39333335,0.6146907,0.39666668,0.6146907,0.4,0.6146907,0.40333334,0.6146907,0.40666667,0.6146907,0.41,0.6146907,0.41333333,0.6146907,0.41666666,0.6146907,0.42,0.6146907,0.42333335,0.6146907,0.42666668,0.6146907,0.43,0.6146907,0.43333334,0.6146907,0.43666667,0.6146907,0.44,0.6146907,0.44333333,0.6146907,0.44666666,0.6146907,0.45,0.6146907,0.50666666,0.6146907,0.51,0.6146907,0.5133333,0.6146907,0.51666665,0.6146907,0.52,0.6146907,0.5233333,0.6146907,0.52666664,0.6146907,0.53,0.6146907,0.54,0.6146907,0.54333335,0.6146907,0.5466667,0.6146907,0.55,0.6146907,0.55333334,0.6146907,0.5566667,0.6146907,0.56,0.6146907,0.56333333,0.6146907,0.56666666,0.6146907,0.57,0.6146907,0.5733333,0.6146907,0.57666665,0.6146907,0.58,0.6146907,0.5833333,0.6146907,0.58666664,0.6146907,0.59,0.6146907,0.5933333,0.6146907,0.5966667,0.6146907,0.6,0.6146907,0.60333335,0.6146907,0.6066667,0.6146907,0.61,0.6146907,0.61333334,0.6146907,0.6533333,0.6146907,0.6566667,0.6146907,0.66,0.6146907,0.66333336,0.6146907,0.6666667,0.6146907,0.67,0.6146907,0.67333335,0.6146907,0.6766667,0.6146907,0.68,0.6146907,0.68333334,0.6146907,0.68666667,0.6146907,0.69,0.6146907,0.6933333,0.6146907,0.69666666,0.6146907,0.7,0.6146907,0.7033333,0.6146907,0.70666665,0.6146907,0.71,0.6146907,0.7133333,0.6146907,0.71666664,0.6146907,0.72,0.6146907,0.72333336,0.6146907,0.7266667,0.6146907,0.73,0.6146907,0.73333335,0.6146907,0.7366667,0.6146907,0.74,0.6146907,0.74333334,0.6146907,0.74666667,0.6146907,0.75,0.6146907,0.75333333,0.6146907,0.75666666,0.6146907,0.76,0.6146907,0.7633333,0.6146907,0.76666665,0.6146907,0.77,0.6146907,0.7733333,0.6146907,0.77666664,0.6146907,0.78,0.6146907,0.78333336,0.6146907,0.7866667,0.6146907,0.79,0.6146907,0.79333335,0.6146907,0.7966667,0.6146907,0.8,0.6146907,0.80333334,0.6146907,0.8066667,0.6146907,0.81,0.6146907,0.81333333,0.6146907,0.81666666,0.6146907,0.82,0.6146907,0.8233333,0.6146907,0.82666665,0.6146907,0.83,0.6146907,0.8333333,0.6146907,0.83666664,0.6146907,0.84,0.6146907,0.8433333,0.6146907,0.8466667,0.6146907,0.85,0.6146907,0.85333335,0.6146907,0.8566667,0.6146907,0.86,0.6146907,0.86333334,0.6146907,0.8666667,0.6146907,0.87,0.6146907,0.87333333,0.6146907,0.87666667,0.6146907,0.88,0.6146907,0.8833333,0.6146907,0.88666666,0.6146907,0.89,0.6146907,0.8933333,0.6146907,0.89666665,0.6146907,0.9,0.6146907,0.9033333,0.6146907,0.9066667,0.6146907,0.91,0.6146907,0.91333336,0.6146907,0.9166667,0.6146907,0.92,0.6146907,0.043333333,0.617268,0.046666667,0.617268,0.05,0.617268,0.053333335,0.617268,0.05666667,0.617268,0.06,0.617268,0.06333333,0.617268,0.06666667,0.617268,0.07,0.617268,0.07333333,0.617268,0.07666667,0.617268,0.08,0.617268,0.083333336,0.617268,0.086666666,0.617268,0.09,0.617268,0.093333334,0.617268,0.096666664,0.617268,0.1,0.617268,0.10333333,0.617268,0.10666667,0.617268,0.11,0.617268,0.11333334,0.617268,0.11666667,0.617268,0.12,0.617268,0.123333335,0.617268,0.12666667,0.617268,0.13,0.617268,0.13333334,0.617268,0.13666667,0.617268,0.14,0.617268,0.14333333,0.617268,0.14666666,0.617268,0.15,0.617268,0.15333334,0.617268,0.15666667,0.617268,0.16,0.617268,0.16333333,0.617268,0.16666667,0.617268,0.17,0.617268,0.17333333,0.617268,0.17666666,0.617268,0.18,0.617268,0.18333334,0.617268,0.18666667,0.617268,0.19,0.617268,0.19333333,0.617268,0.19666667,0.617268,0.2,0.617268,0.20333333,0.617268,0.20666666,0.617268,0.21,0.617268,0.21333334,0.617268,0.21666667,0.617268,0.22,0.617268,0.22333333,0.617268,0.22666667,0.617268,0.23,0.617268,0.23333333,0.617268,0.23666666,0.617268,0.24,0.617268,0.24333334,0.617268,0.24666667,0.617268,0.25,0.617268,0.25333333,0.617268,0.25666666,0.617268,0.26,0.617268,0.26333332,0.617268,0.26666668,0.617268,0.27,0.617268,0.27333334,0.617268,0.32333332,0.617268,0.32666665,0.617268,0.33,0.617268,0.33333334,0.617268,0.33666667,0.617268,0.34,0.617268,0.34333333,0.617268,0.36333334,0.617268,0.36666667,0.617268,0.37,0.617268,0.37333333,0.617268,0.37666667,0.617268,0.38,0.617268,0.38333333,0.617268,0.38666666,0.617268,0.39,0.617268,0.39333335,0.617268,0.39666668,0.617268,0.4,0.617268,0.40333334,0.617268,0.40666667,0.617268,0.41,0.617268,0.41333333,0.617268,0.41666666,0.617268,0.42,0.617268,0.42333335,0.617268,0.42666668,0.617268,0.43,0.617268,0.43333334,0.617268,0.43666667,0.617268,0.44,0.617268,0.44333333,0.617268,0.44666666,0.617268,0.50333333,0.617268,0.50666666,0.617268,0.51,0.617268,0.5133333,0.617268,0.51666665,0.617268,0.52,0.617268,0.5233333,0.617268,0.52666664,0.617268,0.53,0.617268,0.53333336,0.617268,0.54333335,0.617268,0.5466667,0.617268,0.55,0.617268,0.55333334,0.617268,0.5566667,0.617268,0.56,0.617268,0.56333333,0.617268,0.56666666,0.617268,0.57,0.617268,0.5733333,0.617268,0.57666665,0.617268,0.58,0.617268,0.5833333,0.617268,0.58666664,0.617268,0.59,0.617268,0.5933333,0.617268,0.5966667,0.617268,0.6,0.617268,0.60333335,0.617268,0.6533333,0.617268,0.6566667,0.617268,0.66,0.617268,0.66333336,0.617268,0.6666667,0.617268,0.67,0.617268,0.67333335,0.617268,0.6766667,0.617268,0.68,0.617268,0.68333334,0.617268,0.68666667,0.617268,0.69,0.617268,0.6933333,0.617268,0.69666666,0.617268,0.7,0.617268,0.7033333,0.617268,0.70666665,0.617268,0.71,0.617268,0.7133333,0.617268,0.71666664,0.617268,0.72,0.617268,0.72333336,0.617268,0.7266667,0.617268,0.73,0.617268,0.73333335,0.617268,0.7366667,0.617268,0.74,0.617268,0.74333334,0.617268,0.74666667,0.617268,0.75,0.617268,0.75333333,0.617268,0.75666666,0.617268,0.76,0.617268,0.7633333,0.617268,0.76666665,0.617268,0.77,0.617268,0.7733333,0.617268,0.77666664,0.617268,0.78,0.617268,0.78333336,0.617268,0.7866667,0.617268,0.79,0.617268,0.79333335,0.617268,0.7966667,0.617268,0.8,0.617268,0.80333334,0.617268,0.8066667,0.617268,0.81,0.617268,0.81333333,0.617268,0.81666666,0.617268,0.82,0.617268,0.8233333,0.617268,0.82666665,0.617268,0.83,0.617268,0.8333333,0.617268,0.83666664,0.617268,0.84,0.617268,0.8433333,0.617268,0.8466667,0.617268,0.85,0.617268,0.85333335,0.617268,0.8566667,0.617268,0.86,0.617268,0.86333334,0.617268,0.8666667,0.617268,0.87,0.617268,0.87333333,0.617268,0.87666667,0.617268,0.88,0.617268,0.8833333,0.617268,0.88666666,0.617268,0.89,0.617268,0.8933333,0.617268,0.89666665,0.617268,0.9,0.617268,0.9033333,0.617268,0.9066667,0.617268,0.91,0.617268,0.91333336,0.617268,0.9166667,0.617268,0.92,0.617268,0.92333335,0.617268,0.043333333,0.6198454,0.046666667,0.6198454,0.05,0.6198454,0.053333335,0.6198454,0.05666667,0.6198454,0.06,0.6198454,0.06333333,0.6198454,0.06666667,0.6198454,0.07,0.6198454,0.07333333,0.6198454,0.07666667,0.6198454,0.08,0.6198454,0.083333336,0.6198454,0.086666666,0.6198454,0.09,0.6198454,0.093333334,0.6198454,0.096666664,0.6198454,0.1,0.6198454,0.10333333,0.6198454,0.10666667,0.6198454,0.11,0.6198454,0.11333334,0.6198454,0.11666667,0.6198454,0.12,0.6198454,0.123333335,0.6198454,0.12666667,0.6198454,0.13,0.6198454,0.13333334,0.6198454,0.13666667,0.6198454,0.14,0.6198454,0.14333333,0.6198454,0.14666666,0.6198454,0.15,0.6198454,0.15333334,0.6198454,0.15666667,0.6198454,0.16,0.6198454,0.16333333,0.6198454,0.16666667,0.6198454,0.17,0.6198454,0.17333333,0.6198454,0.17666666,0.6198454,0.18,0.6198454,0.18333334,0.6198454,0.18666667,0.6198454,0.19,0.6198454,0.19333333,0.6198454,0.19666667,0.6198454,0.2,0.6198454,0.20333333,0.6198454,0.20666666,0.6198454,0.21,0.6198454,0.21333334,0.6198454,0.21666667,0.6198454,0.22,0.6198454,0.22333333,0.6198454,0.22666667,0.6198454,0.23,0.6198454,0.23333333,0.6198454,0.23666666,0.6198454,0.24,0.6198454,0.24333334,0.6198454,0.24666667,0.6198454,0.25,0.6198454,0.25333333,0.6198454,0.25666666,0.6198454,0.26,0.6198454,0.26333332,0.6198454,0.26666668,0.6198454,0.27,0.6198454,0.27333334,0.6198454,0.32,0.6198454,0.32333332,0.6198454,0.32666665,0.6198454,0.33,0.6198454,0.33333334,0.6198454,0.33666667,0.6198454,0.34,0.6198454,0.34333333,0.6198454,0.36333334,0.6198454,0.36666667,0.6198454,0.37,0.6198454,0.37333333,0.6198454,0.37666667,0.6198454,0.38,0.6198454,0.38333333,0.6198454,0.38666666,0.6198454,0.39,0.6198454,0.39333335,0.6198454,0.39666668,0.6198454,0.4,0.6198454,0.40333334,0.6198454,0.40666667,0.6198454,0.41,0.6198454,0.41333333,0.6198454,0.41666666,0.6198454,0.42,0.6198454,0.42333335,0.6198454,0.42666668,0.6198454,0.43,0.6198454,0.43333334,0.6198454,0.43666667,0.6198454,0.44,0.6198454,0.44333333,0.6198454,0.44666666,0.6198454,0.50333333,0.6198454,0.50666666,0.6198454,0.51,0.6198454,0.5133333,0.6198454,0.51666665,0.6198454,0.52,0.6198454,0.5233333,0.6198454,0.52666664,0.6198454,0.53,0.6198454,0.53333336,0.6198454,0.54333335,0.6198454,0.5466667,0.6198454,0.55,0.6198454,0.55333334,0.6198454,0.5566667,0.6198454,0.56,0.6198454,0.56333333,0.6198454,0.56666666,0.6198454,0.57,0.6198454,0.5733333,0.6198454,0.57666665,0.6198454,0.58,0.6198454,0.5833333,0.6198454,0.58666664,0.6198454,0.59,0.6198454,0.5933333,0.6198454,0.5966667,0.6198454,0.6533333,0.6198454,0.6566667,0.6198454,0.66,0.6198454,0.66333336,0.6198454,0.6666667,0.6198454,0.67,0.6198454,0.67333335,0.6198454,0.6766667,0.6198454,0.68,0.6198454,0.68333334,0.6198454,0.68666667,0.6198454,0.69,0.6198454,0.6933333,0.6198454,0.69666666,0.6198454,0.7,0.6198454,0.7033333,0.6198454,0.70666665,0.6198454,0.71,0.6198454,0.7133333,0.6198454,0.71666664,0.6198454,0.72,0.6198454,0.72333336,0.6198454,0.7266667,0.6198454,0.73,0.6198454,0.73333335,0.6198454,0.7366667,0.6198454,0.74,0.6198454,0.74333334,0.6198454,0.74666667,0.6198454,0.75,0.6198454,0.75333333,0.6198454,0.75666666,0.6198454,0.76,0.6198454,0.7633333,0.6198454,0.76666665,0.6198454,0.77,0.6198454,0.7733333,0.6198454,0.77666664,0.6198454,0.78,0.6198454,0.78333336,0.6198454,0.7866667,0.6198454,0.79,0.6198454,0.79333335,0.6198454,0.7966667,0.6198454,0.8,0.6198454,0.80333334,0.6198454,0.8066667,0.6198454,0.81,0.6198454,0.81333333,0.6198454,0.81666666,0.6198454,0.82,0.6198454,0.8233333,0.6198454,0.82666665,0.6198454,0.83,0.6198454,0.8333333,0.6198454,0.83666664,0.6198454,0.84,0.6198454,0.8433333,0.6198454,0.8466667,0.6198454,0.85,0.6198454,0.85333335,0.6198454,0.8566667,0.6198454,0.86,0.6198454,0.86333334,0.6198454,0.8666667,0.6198454,0.87,0.6198454,0.87333333,0.6198454,0.87666667,0.6198454,0.88,0.6198454,0.8833333,0.6198454,0.88666666,0.6198454,0.89,0.6198454,0.8933333,0.6198454,0.89666665,0.6198454,0.9,0.6198454,0.9033333,0.6198454,0.9066667,0.6198454,0.91,0.6198454,0.91333336,0.6198454,0.9166667,0.6198454,0.92,0.6198454,0.92333335,0.6198454,0.043333333,0.6224227,0.046666667,0.6224227,0.05,0.6224227,0.053333335,0.6224227,0.05666667,0.6224227,0.06,0.6224227,0.06333333,0.6224227,0.06666667,0.6224227,0.07,0.6224227,0.07333333,0.6224227,0.07666667,0.6224227,0.08,0.6224227,0.083333336,0.6224227,0.086666666,0.6224227,0.09,0.6224227,0.093333334,0.6224227,0.096666664,0.6224227,0.1,0.6224227,0.10333333,0.6224227,0.10666667,0.6224227,0.11,0.6224227,0.11333334,0.6224227,0.11666667,0.6224227,0.12,0.6224227,0.123333335,0.6224227,0.12666667,0.6224227,0.13,0.6224227,0.13333334,0.6224227,0.13666667,0.6224227,0.14,0.6224227,0.14333333,0.6224227,0.14666666,0.6224227,0.15,0.6224227,0.15333334,0.6224227,0.15666667,0.6224227,0.16,0.6224227,0.16333333,0.6224227,0.16666667,0.6224227,0.17,0.6224227,0.17333333,0.6224227,0.17666666,0.6224227,0.18,0.6224227,0.18333334,0.6224227,0.18666667,0.6224227,0.19,0.6224227,0.19333333,0.6224227,0.19666667,0.6224227,0.2,0.6224227,0.20333333,0.6224227,0.20666666,0.6224227,0.21,0.6224227,0.21333334,0.6224227,0.21666667,0.6224227,0.22,0.6224227,0.22333333,0.6224227,0.22666667,0.6224227,0.23,0.6224227,0.23333333,0.6224227,0.23666666,0.6224227,0.24,0.6224227,0.24333334,0.6224227,0.24666667,0.6224227,0.25,0.6224227,0.25333333,0.6224227,0.25666666,0.6224227,0.26,0.6224227,0.26333332,0.6224227,0.26666668,0.6224227,0.31666666,0.6224227,0.32,0.6224227,0.32333332,0.6224227,0.32666665,0.6224227,0.33,0.6224227,0.33333334,0.6224227,0.33666667,0.6224227,0.34,0.6224227,0.34333333,0.6224227,0.36666667,0.6224227,0.37,0.6224227,0.37333333,0.6224227,0.37666667,0.6224227,0.38,0.6224227,0.38333333,0.6224227,0.38666666,0.6224227,0.39,0.6224227,0.39333335,0.6224227,0.39666668,0.6224227,0.4,0.6224227,0.40333334,0.6224227,0.40666667,0.6224227,0.41,0.6224227,0.41333333,0.6224227,0.41666666,0.6224227,0.42,0.6224227,0.42333335,0.6224227,0.42666668,0.6224227,0.43,0.6224227,0.43333334,0.6224227,0.43666667,0.6224227,0.44,0.6224227,0.44333333,0.6224227,0.50333333,0.6224227,0.50666666,0.6224227,0.51,0.6224227,0.5133333,0.6224227,0.51666665,0.6224227,0.52,0.6224227,0.5233333,0.6224227,0.52666664,0.6224227,0.53,0.6224227,0.53333336,0.6224227,0.5366667,0.6224227,0.5466667,0.6224227,0.55,0.6224227,0.55333334,0.6224227,0.5566667,0.6224227,0.56,0.6224227,0.56333333,0.6224227,0.56666666,0.6224227,0.57,0.6224227,0.5733333,0.6224227,0.57666665,0.6224227,0.58,0.6224227,0.5833333,0.6224227,0.58666664,0.6224227,0.59,0.6224227,0.5933333,0.6224227,0.6533333,0.6224227,0.6566667,0.6224227,0.66,0.6224227,0.66333336,0.6224227,0.6666667,0.6224227,0.67,0.6224227,0.67333335,0.6224227,0.6766667,0.6224227,0.68,0.6224227,0.68333334,0.6224227,0.68666667,0.6224227,0.69,0.6224227,0.6933333,0.6224227,0.69666666,0.6224227,0.7,0.6224227,0.7033333,0.6224227,0.70666665,0.6224227,0.71,0.6224227,0.7133333,0.6224227,0.71666664,0.6224227,0.72,0.6224227,0.72333336,0.6224227,0.7266667,0.6224227,0.73,0.6224227,0.73333335,0.6224227,0.7366667,0.6224227,0.74,0.6224227,0.74333334,0.6224227,0.74666667,0.6224227,0.75,0.6224227,0.75333333,0.6224227,0.75666666,0.6224227,0.76,0.6224227,0.7633333,0.6224227,0.76666665,0.6224227,0.77,0.6224227,0.7733333,0.6224227,0.77666664,0.6224227,0.78,0.6224227,0.78333336,0.6224227,0.7866667,0.6224227,0.79,0.6224227,0.79333335,0.6224227,0.7966667,0.6224227,0.8,0.6224227,0.80333334,0.6224227,0.8066667,0.6224227,0.81,0.6224227,0.81333333,0.6224227,0.81666666,0.6224227,0.82,0.6224227,0.8233333,0.6224227,0.82666665,0.6224227,0.83,0.6224227,0.8333333,0.6224227,0.83666664,0.6224227,0.84,0.6224227,0.8433333,0.6224227,0.8466667,0.6224227,0.85,0.6224227,0.85333335,0.6224227,0.8566667,0.6224227,0.86,0.6224227,0.86333334,0.6224227,0.8666667,0.6224227,0.87,0.6224227,0.87333333,0.6224227,0.87666667,0.6224227,0.88,0.6224227,0.8833333,0.6224227,0.88666666,0.6224227,0.89,0.6224227,0.8933333,0.6224227,0.89666665,0.6224227,0.9,0.6224227,0.9033333,0.6224227,0.9066667,0.6224227,0.91,0.6224227,0.91333336,0.6224227,0.9166667,0.6224227,0.92,0.6224227,0.92333335,0.6224227,0.043333333,0.625,0.046666667,0.625,0.05,0.625,0.053333335,0.625,0.05666667,0.625,0.06,0.625,0.06333333,0.625,0.06666667,0.625,0.07,0.625,0.07333333,0.625,0.07666667,0.625,0.08,0.625,0.083333336,0.625,0.086666666,0.625,0.09,0.625,0.093333334,0.625,0.096666664,0.625,0.1,0.625,0.10333333,0.625,0.10666667,0.625,0.11,0.625,0.11333334,0.625,0.11666667,0.625,0.12,0.625,0.123333335,0.625,0.12666667,0.625,0.13,0.625,0.13333334,0.625,0.13666667,0.625,0.14,0.625,0.14333333,0.625,0.14666666,0.625,0.15,0.625,0.15333334,0.625,0.15666667,0.625,0.16,0.625,0.16333333,0.625,0.16666667,0.625,0.17,0.625,0.17333333,0.625,0.17666666,0.625,0.18,0.625,0.18333334,0.625,0.18666667,0.625,0.19,0.625,0.19333333,0.625,0.19666667,0.625,0.2,0.625,0.20333333,0.625,0.20666666,0.625,0.21,0.625,0.21333334,0.625,0.21666667,0.625,0.22,0.625,0.22333333,0.625,0.22666667,0.625,0.23,0.625,0.23333333,0.625,0.23666666,0.625,0.24,0.625,0.24333334,0.625,0.24666667,0.625,0.25,0.625,0.25333333,0.625,0.25666666,0.625,0.26,0.625,0.26333332,0.625,0.26666668,0.625,0.27,0.625,0.31333333,0.625,0.31666666,0.625,0.32,0.625,0.32333332,0.625,0.32666665,0.625,0.33,0.625,0.33333334,0.625,0.33666667,0.625,0.34,0.625,0.34333333,0.625,0.36666667,0.625,0.37,0.625,0.37333333,0.625,0.37666667,0.625,0.38,0.625,0.38333333,0.625,0.38666666,0.625,0.39,0.625,0.39333335,0.625,0.39666668,0.625,0.4,0.625,0.40333334,0.625,0.40666667,0.625,0.41,0.625,0.41333333,0.625,0.41666666,0.625,0.42,0.625,0.42333335,0.625,0.42666668,0.625,0.43,0.625,0.43333334,0.625,0.43666667,0.625,0.44,0.625,0.44333333,0.625,0.50333333,0.625,0.50666666,0.625,0.51,0.625,0.5133333,0.625,0.51666665,0.625,0.52,0.625,0.5233333,0.625,0.52666664,0.625,0.53,0.625,0.53333336,0.625,0.5366667,0.625,0.5466667,0.625,0.55,0.625,0.55333334,0.625,0.5566667,0.625,0.56,0.625,0.56333333,0.625,0.56666666,0.625,0.57,0.625,0.5733333,0.625,0.57666665,0.625,0.58,0.625,0.5833333,0.625,0.58666664,0.625,0.59,0.625,0.5933333,0.625,0.6533333,0.625,0.6566667,0.625,0.66,0.625,0.66333336,0.625,0.6666667,0.625,0.67,0.625,0.67333335,0.625,0.6766667,0.625,0.68,0.625,0.68333334,0.625,0.68666667,0.625,0.69,0.625,0.6933333,0.625,0.69666666,0.625,0.7,0.625,0.7033333,0.625,0.70666665,0.625,0.71,0.625,0.7133333,0.625,0.71666664,0.625,0.72,0.625,0.72333336,0.625,0.7266667,0.625,0.73,0.625,0.73333335,0.625,0.7366667,0.625,0.74,0.625,0.74333334,0.625,0.74666667,0.625,0.75,0.625,0.75333333,0.625,0.75666666,0.625,0.76,0.625,0.7633333,0.625,0.76666665,0.625,0.77,0.625,0.7733333,0.625,0.77666664,0.625,0.78,0.625,0.78333336,0.625,0.7866667,0.625,0.79,0.625,0.79333335,0.625,0.7966667,0.625,0.8,0.625,0.80333334,0.625,0.8066667,0.625,0.81,0.625,0.81333333,0.625,0.81666666,0.625,0.82,0.625,0.8233333,0.625,0.82666665,0.625,0.83,0.625,0.8333333,0.625,0.83666664,0.625,0.84,0.625,0.8433333,0.625,0.8466667,0.625,0.85,0.625,0.85333335,0.625,0.8566667,0.625,0.86,0.625,0.86333334,0.625,0.8666667,0.625,0.87,0.625,0.87333333,0.625,0.87666667,0.625,0.88,0.625,0.8833333,0.625,0.88666666,0.625,0.89,0.625,0.8933333,0.625,0.89666665,0.625,0.9,0.625,0.9033333,0.625,0.9066667,0.625,0.91,0.625,0.91333336,0.625,0.9166667,0.625,0.92,0.625,0.92333335,0.625,0.043333333,0.6275773,0.046666667,0.6275773,0.05,0.6275773,0.053333335,0.6275773,0.05666667,0.6275773,0.06,0.6275773,0.06333333,0.6275773,0.06666667,0.6275773,0.07,0.6275773,0.07333333,0.6275773,0.07666667,0.6275773,0.08,0.6275773,0.083333336,0.6275773,0.086666666,0.6275773,0.09,0.6275773,0.093333334,0.6275773,0.096666664,0.6275773,0.1,0.6275773,0.10333333,0.6275773,0.10666667,0.6275773,0.11,0.6275773,0.11333334,0.6275773,0.11666667,0.6275773,0.12,0.6275773,0.123333335,0.6275773,0.12666667,0.6275773,0.13,0.6275773,0.13333334,0.6275773,0.13666667,0.6275773,0.14,0.6275773,0.14333333,0.6275773,0.14666666,0.6275773,0.15,0.6275773,0.15333334,0.6275773,0.15666667,0.6275773,0.16,0.6275773,0.16333333,0.6275773,0.16666667,0.6275773,0.17,0.6275773,0.17333333,0.6275773,0.17666666,0.6275773,0.18,0.6275773,0.18333334,0.6275773,0.18666667,0.6275773,0.19,0.6275773,0.19333333,0.6275773,0.19666667,0.6275773,0.2,0.6275773,0.20333333,0.6275773,0.20666666,0.6275773,0.21,0.6275773,0.21333334,0.6275773,0.21666667,0.6275773,0.22,0.6275773,0.22333333,0.6275773,0.22666667,0.6275773,0.23,0.6275773,0.23333333,0.6275773,0.23666666,0.6275773,0.24,0.6275773,0.24333334,0.6275773,0.24666667,0.6275773,0.25,0.6275773,0.25333333,0.6275773,0.25666666,0.6275773,0.26,0.6275773,0.26333332,0.6275773,0.26666668,0.6275773,0.27,0.6275773,0.31,0.6275773,0.31333333,0.6275773,0.31666666,0.6275773,0.32,0.6275773,0.32333332,0.6275773,0.32666665,0.6275773,0.33,0.6275773,0.33333334,0.6275773,0.33666667,0.6275773,0.34,0.6275773,0.37,0.6275773,0.37333333,0.6275773,0.37666667,0.6275773,0.38,0.6275773,0.38333333,0.6275773,0.38666666,0.6275773,0.39,0.6275773,0.39333335,0.6275773,0.39666668,0.6275773,0.4,0.6275773,0.40333334,0.6275773,0.40666667,0.6275773,0.41,0.6275773,0.41333333,0.6275773,0.41666666,0.6275773,0.42,0.6275773,0.42333335,0.6275773,0.42666668,0.6275773,0.43,0.6275773,0.43333334,0.6275773,0.43666667,0.6275773,0.44,0.6275773,0.50333333,0.6275773,0.50666666,0.6275773,0.51,0.6275773,0.5133333,0.6275773,0.51666665,0.6275773,0.52,0.6275773,0.5233333,0.6275773,0.52666664,0.6275773,0.53,0.6275773,0.53333336,0.6275773,0.5366667,0.6275773,0.55,0.6275773,0.55333334,0.6275773,0.5566667,0.6275773,0.56,0.6275773,0.56333333,0.6275773,0.56666666,0.6275773,0.57,0.6275773,0.5733333,0.6275773,0.57666665,0.6275773,0.58,0.6275773,0.5833333,0.6275773,0.58666664,0.6275773,0.59,0.6275773,0.5933333,0.6275773,0.5966667,0.6275773,0.6566667,0.6275773,0.66,0.6275773,0.66333336,0.6275773,0.6666667,0.6275773,0.67,0.6275773,0.67333335,0.6275773,0.6766667,0.6275773,0.68,0.6275773,0.68333334,0.6275773,0.68666667,0.6275773,0.69,0.6275773,0.6933333,0.6275773,0.69666666,0.6275773,0.7,0.6275773,0.7033333,0.6275773,0.70666665,0.6275773,0.71,0.6275773,0.7133333,0.6275773,0.71666664,0.6275773,0.72,0.6275773,0.72333336,0.6275773,0.7266667,0.6275773,0.73,0.6275773,0.73333335,0.6275773,0.7366667,0.6275773,0.74,0.6275773,0.74333334,0.6275773,0.74666667,0.6275773,0.75,0.6275773,0.75333333,0.6275773,0.75666666,0.6275773,0.76,0.6275773,0.7633333,0.6275773,0.76666665,0.6275773,0.77,0.6275773,0.7733333,0.6275773,0.77666664,0.6275773,0.78,0.6275773,0.78333336,0.6275773,0.7866667,0.6275773,0.79,0.6275773,0.79333335,0.6275773,0.7966667,0.6275773,0.8,0.6275773,0.80333334,0.6275773,0.8066667,0.6275773,0.81,0.6275773,0.81333333,0.6275773,0.81666666,0.6275773,0.82,0.6275773,0.8233333,0.6275773,0.82666665,0.6275773,0.83,0.6275773,0.8333333,0.6275773,0.83666664,0.6275773,0.84,0.6275773,0.8433333,0.6275773,0.8466667,0.6275773,0.85,0.6275773,0.85333335,0.6275773,0.8566667,0.6275773,0.86,0.6275773,0.86333334,0.6275773,0.8666667,0.6275773,0.87,0.6275773,0.87333333,0.6275773,0.87666667,0.6275773,0.88,0.6275773,0.8833333,0.6275773,0.88666666,0.6275773,0.89,0.6275773,0.8933333,0.6275773,0.89666665,0.6275773,0.9,0.6275773,0.9033333,0.6275773,0.9066667,0.6275773,0.91,0.6275773,0.91333336,0.6275773,0.9166667,0.6275773,0.92,0.6275773,0.92333335,0.6275773,0.043333333,0.6301546,0.046666667,0.6301546,0.05,0.6301546,0.053333335,0.6301546,0.05666667,0.6301546,0.06,0.6301546,0.06333333,0.6301546,0.06666667,0.6301546,0.07,0.6301546,0.07333333,0.6301546,0.07666667,0.6301546,0.08,0.6301546,0.083333336,0.6301546,0.086666666,0.6301546,0.09,0.6301546,0.093333334,0.6301546,0.096666664,0.6301546,0.1,0.6301546,0.10333333,0.6301546,0.10666667,0.6301546,0.11,0.6301546,0.11333334,0.6301546,0.11666667,0.6301546,0.12,0.6301546,0.123333335,0.6301546,0.12666667,0.6301546,0.13,0.6301546,0.13333334,0.6301546,0.13666667,0.6301546,0.14,0.6301546,0.14333333,0.6301546,0.14666666,0.6301546,0.15,0.6301546,0.15333334,0.6301546,0.15666667,0.6301546,0.16,0.6301546,0.16333333,0.6301546,0.16666667,0.6301546,0.17,0.6301546,0.17333333,0.6301546,0.17666666,0.6301546,0.18,0.6301546,0.18333334,0.6301546,0.18666667,0.6301546,0.19,0.6301546,0.19333333,0.6301546,0.19666667,0.6301546,0.2,0.6301546,0.20333333,0.6301546,0.20666666,0.6301546,0.21,0.6301546,0.21333334,0.6301546,0.21666667,0.6301546,0.22,0.6301546,0.22333333,0.6301546,0.22666667,0.6301546,0.23,0.6301546,0.23333333,0.6301546,0.23666666,0.6301546,0.24,0.6301546,0.24333334,0.6301546,0.24666667,0.6301546,0.25,0.6301546,0.25333333,0.6301546,0.25666666,0.6301546,0.26,0.6301546,0.26333332,0.6301546,0.26666668,0.6301546,0.27,0.6301546,0.30333334,0.6301546,0.30666667,0.6301546,0.31,0.6301546,0.31333333,0.6301546,0.31666666,0.6301546,0.32,0.6301546,0.32333332,0.6301546,0.32666665,0.6301546,0.33,0.6301546,0.33333334,0.6301546,0.33666667,0.6301546,0.34,0.6301546,0.37333333,0.6301546,0.37666667,0.6301546,0.38,0.6301546,0.38333333,0.6301546,0.38666666,0.6301546,0.39,0.6301546,0.39333335,0.6301546,0.39666668,0.6301546,0.4,0.6301546,0.40333334,0.6301546,0.40666667,0.6301546,0.41,0.6301546,0.41333333,0.6301546,0.41666666,0.6301546,0.42,0.6301546,0.42333335,0.6301546,0.42666668,0.6301546,0.43,0.6301546,0.43333334,0.6301546,0.43666667,0.6301546,0.44333333,0.6301546,0.44666666,0.6301546,0.50333333,0.6301546,0.50666666,0.6301546,0.51,0.6301546,0.5133333,0.6301546,0.51666665,0.6301546,0.52,0.6301546,0.5233333,0.6301546,0.52666664,0.6301546,0.53,0.6301546,0.53333336,0.6301546,0.55,0.6301546,0.55333334,0.6301546,0.5566667,0.6301546,0.56,0.6301546,0.56333333,0.6301546,0.56666666,0.6301546,0.57,0.6301546,0.5733333,0.6301546,0.57666665,0.6301546,0.58,0.6301546,0.5833333,0.6301546,0.58666664,0.6301546,0.59,0.6301546,0.5933333,0.6301546,0.5966667,0.6301546,0.6,0.6301546,0.66,0.6301546,0.66333336,0.6301546,0.6666667,0.6301546,0.67,0.6301546,0.67333335,0.6301546,0.6766667,0.6301546,0.68,0.6301546,0.68333334,0.6301546,0.68666667,0.6301546,0.69,0.6301546,0.6933333,0.6301546,0.69666666,0.6301546,0.7,0.6301546,0.7033333,0.6301546,0.70666665,0.6301546,0.71,0.6301546,0.7133333,0.6301546,0.71666664,0.6301546,0.72,0.6301546,0.72333336,0.6301546,0.7266667,0.6301546,0.73,0.6301546,0.73333335,0.6301546,0.7366667,0.6301546,0.74,0.6301546,0.74333334,0.6301546,0.74666667,0.6301546,0.75,0.6301546,0.75333333,0.6301546,0.75666666,0.6301546,0.76,0.6301546,0.7633333,0.6301546,0.76666665,0.6301546,0.77,0.6301546,0.7733333,0.6301546,0.77666664,0.6301546,0.78,0.6301546,0.78333336,0.6301546,0.7866667,0.6301546,0.79,0.6301546,0.79333335,0.6301546,0.7966667,0.6301546,0.8,0.6301546,0.80333334,0.6301546,0.8066667,0.6301546,0.81,0.6301546,0.81333333,0.6301546,0.81666666,0.6301546,0.82,0.6301546,0.8233333,0.6301546,0.82666665,0.6301546,0.83,0.6301546,0.8333333,0.6301546,0.83666664,0.6301546,0.84,0.6301546,0.8433333,0.6301546,0.8466667,0.6301546,0.85,0.6301546,0.85333335,0.6301546,0.8566667,0.6301546,0.86,0.6301546,0.86333334,0.6301546,0.8666667,0.6301546,0.87,0.6301546,0.87333333,0.6301546,0.87666667,0.6301546,0.88,0.6301546,0.8833333,0.6301546,0.88666666,0.6301546,0.89,0.6301546,0.8933333,0.6301546,0.89666665,0.6301546,0.9,0.6301546,0.9033333,0.6301546,0.9066667,0.6301546,0.91,0.6301546,0.91333336,0.6301546,0.9166667,0.6301546,0.92,0.6301546,0.92333335,0.6301546,0.043333333,0.632732,0.046666667,0.632732,0.05,0.632732,0.053333335,0.632732,0.05666667,0.632732,0.06,0.632732,0.06333333,0.632732,0.06666667,0.632732,0.07,0.632732,0.07333333,0.632732,0.07666667,0.632732,0.08,0.632732,0.083333336,0.632732,0.086666666,0.632732,0.09,0.632732,0.093333334,0.632732,0.096666664,0.632732,0.1,0.632732,0.10333333,0.632732,0.10666667,0.632732,0.11,0.632732,0.11333334,0.632732,0.11666667,0.632732,0.12,0.632732,0.123333335,0.632732,0.12666667,0.632732,0.13,0.632732,0.13333334,0.632732,0.13666667,0.632732,0.14,0.632732,0.14333333,0.632732,0.14666666,0.632732,0.15,0.632732,0.15333334,0.632732,0.15666667,0.632732,0.16,0.632732,0.16333333,0.632732,0.16666667,0.632732,0.17,0.632732,0.17333333,0.632732,0.17666666,0.632732,0.18,0.632732,0.18333334,0.632732,0.18666667,0.632732,0.19,0.632732,0.19333333,0.632732,0.19666667,0.632732,0.2,0.632732,0.20333333,0.632732,0.20666666,0.632732,0.21,0.632732,0.21333334,0.632732,0.21666667,0.632732,0.22,0.632732,0.22333333,0.632732,0.22666667,0.632732,0.23,0.632732,0.23333333,0.632732,0.23666666,0.632732,0.24,0.632732,0.24333334,0.632732,0.24666667,0.632732,0.25,0.632732,0.25333333,0.632732,0.25666666,0.632732,0.26,0.632732,0.26333332,0.632732,0.26666668,0.632732,0.27,0.632732,0.27333334,0.632732,0.3,0.632732,0.30333334,0.632732,0.30666667,0.632732,0.31,0.632732,0.31333333,0.632732,0.31666666,0.632732,0.32,0.632732,0.32333332,0.632732,0.32666665,0.632732,0.33,0.632732,0.33333334,0.632732,0.33666667,0.632732,0.34,0.632732,0.38333333,0.632732,0.38666666,0.632732,0.39,0.632732,0.39333335,0.632732,0.39666668,0.632732,0.4,0.632732,0.40333334,0.632732,0.40666667,0.632732,0.41,0.632732,0.41333333,0.632732,0.41666666,0.632732,0.42,0.632732,0.42333335,0.632732,0.42666668,0.632732,0.43,0.632732,0.43333334,0.632732,0.44,0.632732,0.44333333,0.632732,0.44666666,0.632732,0.50666666,0.632732,0.51,0.632732,0.5133333,0.632732,0.51666665,0.632732,0.52,0.632732,0.5233333,0.632732,0.52666664,0.632732,0.53,0.632732,0.53333336,0.632732,0.55333334,0.632732,0.5566667,0.632732,0.56,0.632732,0.56333333,0.632732,0.56666666,0.632732,0.57,0.632732,0.5733333,0.632732,0.57666665,0.632732,0.58,0.632732,0.5833333,0.632732,0.58666664,0.632732,0.59,0.632732,0.5933333,0.632732,0.5966667,0.632732,0.6,0.632732,0.60333335,0.632732,0.6066667,0.632732,0.66,0.632732,0.66333336,0.632732,0.6666667,0.632732,0.67,0.632732,0.67333335,0.632732,0.6766667,0.632732,0.68,0.632732,0.68333334,0.632732,0.68666667,0.632732,0.69,0.632732,0.6933333,0.632732,0.69666666,0.632732,0.7,0.632732,0.7033333,0.632732,0.70666665,0.632732,0.71,0.632732,0.7133333,0.632732,0.71666664,0.632732,0.72,0.632732,0.72333336,0.632732,0.7266667,0.632732,0.73,0.632732,0.73333335,0.632732,0.7366667,0.632732,0.74,0.632732,0.74333334,0.632732,0.74666667,0.632732,0.75,0.632732,0.75333333,0.632732,0.75666666,0.632732,0.76,0.632732,0.7633333,0.632732,0.76666665,0.632732,0.77,0.632732,0.7733333,0.632732,0.77666664,0.632732,0.78,0.632732,0.78333336,0.632732,0.7866667,0.632732,0.79,0.632732,0.79333335,0.632732,0.7966667,0.632732,0.8,0.632732,0.80333334,0.632732,0.8066667,0.632732,0.81,0.632732,0.81333333,0.632732,0.81666666,0.632732,0.82,0.632732,0.8233333,0.632732,0.82666665,0.632732,0.83,0.632732,0.8333333,0.632732,0.83666664,0.632732,0.84,0.632732,0.8433333,0.632732,0.8466667,0.632732,0.85,0.632732,0.85333335,0.632732,0.8566667,0.632732,0.86,0.632732,0.86333334,0.632732,0.8666667,0.632732,0.87,0.632732,0.87333333,0.632732,0.87666667,0.632732,0.88,0.632732,0.8833333,0.632732,0.88666666,0.632732,0.89,0.632732,0.8933333,0.632732,0.89666665,0.632732,0.9,0.632732,0.9033333,0.632732,0.9066667,0.632732,0.91,0.632732,0.91333336,0.632732,0.9166667,0.632732,0.92,0.632732,0.043333333,0.6353093,0.046666667,0.6353093,0.05,0.6353093,0.053333335,0.6353093,0.05666667,0.6353093,0.06,0.6353093,0.06333333,0.6353093,0.06666667,0.6353093,0.07,0.6353093,0.07333333,0.6353093,0.07666667,0.6353093,0.08,0.6353093,0.083333336,0.6353093,0.086666666,0.6353093,0.09,0.6353093,0.093333334,0.6353093,0.096666664,0.6353093,0.1,0.6353093,0.10333333,0.6353093,0.10666667,0.6353093,0.11,0.6353093,0.11333334,0.6353093,0.11666667,0.6353093,0.12,0.6353093,0.123333335,0.6353093,0.12666667,0.6353093,0.13,0.6353093,0.13333334,0.6353093,0.13666667,0.6353093,0.14,0.6353093,0.14333333,0.6353093,0.14666666,0.6353093,0.15,0.6353093,0.15333334,0.6353093,0.15666667,0.6353093,0.16,0.6353093,0.16333333,0.6353093,0.16666667,0.6353093,0.18333334,0.6353093,0.18666667,0.6353093,0.19,0.6353093,0.19333333,0.6353093,0.19666667,0.6353093,0.20666666,0.6353093,0.21,0.6353093,0.21333334,0.6353093,0.22333333,0.6353093,0.22666667,0.6353093,0.23,0.6353093,0.23333333,0.6353093,0.23666666,0.6353093,0.24,0.6353093,0.24333334,0.6353093,0.24666667,0.6353093,0.25,0.6353093,0.25333333,0.6353093,0.25666666,0.6353093,0.26,0.6353093,0.26333332,0.6353093,0.26666668,0.6353093,0.27,0.6353093,0.27333334,0.6353093,0.29333332,0.6353093,0.29666665,0.6353093,0.3,0.6353093,0.30333334,0.6353093,0.30666667,0.6353093,0.31,0.6353093,0.31333333,0.6353093,0.31666666,0.6353093,0.32,0.6353093,0.32333332,0.6353093,0.32666665,0.6353093,0.33,0.6353093,0.33333334,0.6353093,0.33666667,0.6353093,0.39,0.6353093,0.39333335,0.6353093,0.39666668,0.6353093,0.4,0.6353093,0.40333334,0.6353093,0.40666667,0.6353093,0.41,0.6353093,0.41333333,0.6353093,0.41666666,0.6353093,0.42,0.6353093,0.42333335,0.6353093,0.42666668,0.6353093,0.43666667,0.6353093,0.44,0.6353093,0.44333333,0.6353093,0.44666666,0.6353093,0.45,0.6353093,0.50666666,0.6353093,0.51,0.6353093,0.5133333,0.6353093,0.51666665,0.6353093,0.52,0.6353093,0.5233333,0.6353093,0.52666664,0.6353093,0.53,0.6353093,0.53333336,0.6353093,0.56,0.6353093,0.56333333,0.6353093,0.56666666,0.6353093,0.57,0.6353093,0.5733333,0.6353093,0.57666665,0.6353093,0.58,0.6353093,0.5833333,0.6353093,0.58666664,0.6353093,0.59,0.6353093,0.5933333,0.6353093,0.5966667,0.6353093,0.6,0.6353093,0.60333335,0.6353093,0.6066667,0.6353093,0.61,0.6353093,0.61333334,0.6353093,0.6166667,0.6353093,0.62,0.6353093,0.6666667,0.6353093,0.67,0.6353093,0.67333335,0.6353093,0.6766667,0.6353093,0.68,0.6353093,0.68333334,0.6353093,0.68666667,0.6353093,0.69,0.6353093,0.6933333,0.6353093,0.69666666,0.6353093,0.7,0.6353093,0.7033333,0.6353093,0.70666665,0.6353093,0.71,0.6353093,0.7133333,0.6353093,0.71666664,0.6353093,0.72,0.6353093,0.72333336,0.6353093,0.7266667,0.6353093,0.73,0.6353093,0.73333335,0.6353093,0.7366667,0.6353093,0.74,0.6353093,0.74333334,0.6353093,0.74666667,0.6353093,0.75,0.6353093,0.75333333,0.6353093,0.75666666,0.6353093,0.76,0.6353093,0.7633333,0.6353093,0.76666665,0.6353093,0.77,0.6353093,0.7733333,0.6353093,0.77666664,0.6353093,0.78,0.6353093,0.78333336,0.6353093,0.7866667,0.6353093,0.79,0.6353093,0.79333335,0.6353093,0.7966667,0.6353093,0.8,0.6353093,0.80333334,0.6353093,0.8066667,0.6353093,0.81,0.6353093,0.81333333,0.6353093,0.81666666,0.6353093,0.82,0.6353093,0.8233333,0.6353093,0.82666665,0.6353093,0.83,0.6353093,0.8333333,0.6353093,0.83666664,0.6353093,0.84,0.6353093,0.8433333,0.6353093,0.8466667,0.6353093,0.85,0.6353093,0.85333335,0.6353093,0.8566667,0.6353093,0.86,0.6353093,0.86333334,0.6353093,0.8666667,0.6353093,0.87,0.6353093,0.87333333,0.6353093,0.87666667,0.6353093,0.88,0.6353093,0.8833333,0.6353093,0.88666666,0.6353093,0.89,0.6353093,0.8933333,0.6353093,0.89666665,0.6353093,0.9,0.6353093,0.9033333,0.6353093,0.9066667,0.6353093,0.91,0.6353093,0.91333336,0.6353093,0.9166667,0.6353093,0.92,0.6353093,0.043333333,0.6378866,0.046666667,0.6378866,0.05,0.6378866,0.053333335,0.6378866,0.05666667,0.6378866,0.06,0.6378866,0.06333333,0.6378866,0.06666667,0.6378866,0.07,0.6378866,0.07333333,0.6378866,0.07666667,0.6378866,0.08,0.6378866,0.083333336,0.6378866,0.086666666,0.6378866,0.09,0.6378866,0.093333334,0.6378866,0.096666664,0.6378866,0.1,0.6378866,0.10333333,0.6378866,0.10666667,0.6378866,0.11,0.6378866,0.11333334,0.6378866,0.11666667,0.6378866,0.12,0.6378866,0.123333335,0.6378866,0.12666667,0.6378866,0.13,0.6378866,0.13333334,0.6378866,0.13666667,0.6378866,0.14,0.6378866,0.14333333,0.6378866,0.14666666,0.6378866,0.15,0.6378866,0.15333334,0.6378866,0.15666667,0.6378866,0.16,0.6378866,0.16333333,0.6378866,0.18333334,0.6378866,0.18666667,0.6378866,0.19,0.6378866,0.22,0.6378866,0.22333333,0.6378866,0.22666667,0.6378866,0.23,0.6378866,0.23333333,0.6378866,0.23666666,0.6378866,0.24,0.6378866,0.24333334,0.6378866,0.24666667,0.6378866,0.25,0.6378866,0.25333333,0.6378866,0.25666666,0.6378866,0.26,0.6378866,0.26333332,0.6378866,0.26666668,0.6378866,0.27,0.6378866,0.27333334,0.6378866,0.29333332,0.6378866,0.29666665,0.6378866,0.3,0.6378866,0.30333334,0.6378866,0.30666667,0.6378866,0.31,0.6378866,0.31333333,0.6378866,0.31666666,0.6378866,0.32,0.6378866,0.32333332,0.6378866,0.32666665,0.6378866,0.33,0.6378866,0.33333334,0.6378866,0.39333335,0.6378866,0.39666668,0.6378866,0.4,0.6378866,0.40333334,0.6378866,0.40666667,0.6378866,0.41,0.6378866,0.41333333,0.6378866,0.41666666,0.6378866,0.42333335,0.6378866,0.42666668,0.6378866,0.43,0.6378866,0.43333334,0.6378866,0.43666667,0.6378866,0.44,0.6378866,0.44333333,0.6378866,0.44666666,0.6378866,0.45,0.6378866,0.50666666,0.6378866,0.51,0.6378866,0.5133333,0.6378866,0.51666665,0.6378866,0.52,0.6378866,0.5233333,0.6378866,0.52666664,0.6378866,0.53,0.6378866,0.57666665,0.6378866,0.58,0.6378866,0.5833333,0.6378866,0.58666664,0.6378866,0.59,0.6378866,0.5933333,0.6378866,0.5966667,0.6378866,0.6,0.6378866,0.60333335,0.6378866,0.6066667,0.6378866,0.61,0.6378866,0.61333334,0.6378866,0.6166667,0.6378866,0.62,0.6378866,0.62333333,0.6378866,0.62666667,0.6378866,0.67,0.6378866,0.67333335,0.6378866,0.6766667,0.6378866,0.68,0.6378866,0.68333334,0.6378866,0.68666667,0.6378866,0.69,0.6378866,0.6933333,0.6378866,0.69666666,0.6378866,0.7,0.6378866,0.7033333,0.6378866,0.70666665,0.6378866,0.71,0.6378866,0.7133333,0.6378866,0.71666664,0.6378866,0.72,0.6378866,0.72333336,0.6378866,0.7266667,0.6378866,0.73,0.6378866,0.73333335,0.6378866,0.7366667,0.6378866,0.74,0.6378866,0.74333334,0.6378866,0.74666667,0.6378866,0.75,0.6378866,0.75333333,0.6378866,0.75666666,0.6378866,0.76,0.6378866,0.7633333,0.6378866,0.76666665,0.6378866,0.77,0.6378866,0.7733333,0.6378866,0.77666664,0.6378866,0.78,0.6378866,0.78333336,0.6378866,0.7866667,0.6378866,0.79,0.6378866,0.79333335,0.6378866,0.7966667,0.6378866,0.8,0.6378866,0.80333334,0.6378866,0.8066667,0.6378866,0.81,0.6378866,0.81333333,0.6378866,0.81666666,0.6378866,0.82,0.6378866,0.8233333,0.6378866,0.82666665,0.6378866,0.83,0.6378866,0.8333333,0.6378866,0.83666664,0.6378866,0.84,0.6378866,0.8433333,0.6378866,0.8466667,0.6378866,0.85,0.6378866,0.85333335,0.6378866,0.8566667,0.6378866,0.86,0.6378866,0.86333334,0.6378866,0.8666667,0.6378866,0.87,0.6378866,0.87333333,0.6378866,0.87666667,0.6378866,0.88,0.6378866,0.8833333,0.6378866,0.88666666,0.6378866,0.89,0.6378866,0.8933333,0.6378866,0.89666665,0.6378866,0.9,0.6378866,0.9033333,0.6378866,0.9066667,0.6378866,0.91,0.6378866,0.043333333,0.6404639,0.046666667,0.6404639,0.05,0.6404639,0.053333335,0.6404639,0.05666667,0.6404639,0.06,0.6404639,0.06333333,0.6404639,0.06666667,0.6404639,0.07,0.6404639,0.07333333,0.6404639,0.07666667,0.6404639,0.08,0.6404639,0.083333336,0.6404639,0.086666666,0.6404639,0.09,0.6404639,0.093333334,0.6404639,0.096666664,0.6404639,0.1,0.6404639,0.10333333,0.6404639,0.10666667,0.6404639,0.11,0.6404639,0.11333334,0.6404639,0.11666667,0.6404639,0.12,0.6404639,0.123333335,0.6404639,0.12666667,0.6404639,0.13,0.6404639,0.13333334,0.6404639,0.13666667,0.6404639,0.14,0.6404639,0.14333333,0.6404639,0.14666666,0.6404639,0.15,0.6404639,0.15333334,0.6404639,0.15666667,0.6404639,0.16,0.6404639,0.16333333,0.6404639,0.16666667,0.6404639,0.22,0.6404639,0.22333333,0.6404639,0.22666667,0.6404639,0.23,0.6404639,0.23333333,0.6404639,0.23666666,0.6404639,0.24,0.6404639,0.24333334,0.6404639,0.24666667,0.6404639,0.25,0.6404639,0.25333333,0.6404639,0.25666666,0.6404639,0.26,0.6404639,0.26333332,0.6404639,0.26666668,0.6404639,0.27,0.6404639,0.27333334,0.6404639,0.29,0.6404639,0.29333332,0.6404639,0.29666665,0.6404639,0.3,0.6404639,0.30333334,0.6404639,0.30666667,0.6404639,0.31,0.6404639,0.31333333,0.6404639,0.31666666,0.6404639,0.32,0.6404639,0.32333332,0.6404639,0.32666665,0.6404639,0.33,0.6404639,0.33333334,0.6404639,0.39666668,0.6404639,0.4,0.6404639,0.40333334,0.6404639,0.40666667,0.6404639,0.41,0.6404639,0.41666666,0.6404639,0.42,0.6404639,0.42333335,0.6404639,0.42666668,0.6404639,0.43,0.6404639,0.43333334,0.6404639,0.43666667,0.6404639,0.44,0.6404639,0.44333333,0.6404639,0.44666666,0.6404639,0.45,0.6404639,0.5133333,0.6404639,0.51666665,0.6404639,0.5933333,0.6404639,0.5966667,0.6404639,0.6,0.6404639,0.60333335,0.6404639,0.6066667,0.6404639,0.61,0.6404639,0.61333334,0.6404639,0.6166667,0.6404639,0.62,0.6404639,0.62333333,0.6404639,0.62666667,0.6404639,0.63,0.6404639,0.6333333,0.6404639,0.67333335,0.6404639,0.6766667,0.6404639,0.68,0.6404639,0.68333334,0.6404639,0.68666667,0.6404639,0.69,0.6404639,0.6933333,0.6404639,0.69666666,0.6404639,0.7,0.6404639,0.7033333,0.6404639,0.70666665,0.6404639,0.71,0.6404639,0.7133333,0.6404639,0.71666664,0.6404639,0.72,0.6404639,0.72333336,0.6404639,0.7266667,0.6404639,0.73,0.6404639,0.73333335,0.6404639,0.7366667,0.6404639,0.74,0.6404639,0.74333334,0.6404639,0.74666667,0.6404639,0.75,0.6404639,0.75333333,0.6404639,0.75666666,0.6404639,0.76,0.6404639,0.7633333,0.6404639,0.76666665,0.6404639,0.77,0.6404639,0.7733333,0.6404639,0.77666664,0.6404639,0.78,0.6404639,0.78333336,0.6404639,0.7866667,0.6404639,0.79,0.6404639,0.79333335,0.6404639,0.7966667,0.6404639,0.8,0.6404639,0.80333334,0.6404639,0.8066667,0.6404639,0.81,0.6404639,0.81333333,0.6404639,0.81666666,0.6404639,0.82,0.6404639,0.8233333,0.6404639,0.82666665,0.6404639,0.83,0.6404639,0.8333333,0.6404639,0.83666664,0.6404639,0.84,0.6404639,0.8433333,0.6404639,0.8466667,0.6404639,0.85,0.6404639,0.85333335,0.6404639,0.8566667,0.6404639,0.86,0.6404639,0.86333334,0.6404639,0.8666667,0.6404639,0.87,0.6404639,0.87333333,0.6404639,0.87666667,0.6404639,0.88,0.6404639,0.8833333,0.6404639,0.88666666,0.6404639,0.89,0.6404639,0.8933333,0.6404639,0.89666665,0.6404639,0.043333333,0.64304125,0.046666667,0.64304125,0.05,0.64304125,0.053333335,0.64304125,0.05666667,0.64304125,0.06,0.64304125,0.06333333,0.64304125,0.06666667,0.64304125,0.07,0.64304125,0.07333333,0.64304125,0.07666667,0.64304125,0.08,0.64304125,0.083333336,0.64304125,0.086666666,0.64304125,0.09,0.64304125,0.093333334,0.64304125,0.096666664,0.64304125,0.1,0.64304125,0.10333333,0.64304125,0.10666667,0.64304125,0.11,0.64304125,0.11333334,0.64304125,0.11666667,0.64304125,0.12,0.64304125,0.123333335,0.64304125,0.12666667,0.64304125,0.13,0.64304125,0.13333334,0.64304125,0.13666667,0.64304125,0.14,0.64304125,0.14333333,0.64304125,0.14666666,0.64304125,0.15,0.64304125,0.15333334,0.64304125,0.15666667,0.64304125,0.16,0.64304125,0.16333333,0.64304125,0.16666667,0.64304125,0.21666667,0.64304125,0.22,0.64304125,0.22333333,0.64304125,0.22666667,0.64304125,0.23,0.64304125,0.23333333,0.64304125,0.23666666,0.64304125,0.24,0.64304125,0.24333334,0.64304125,0.24666667,0.64304125,0.25,0.64304125,0.25333333,0.64304125,0.25666666,0.64304125,0.26,0.64304125,0.26333332,0.64304125,0.26666668,0.64304125,0.27,0.64304125,0.27333334,0.64304125,0.29,0.64304125,0.29333332,0.64304125,0.29666665,0.64304125,0.3,0.64304125,0.30333334,0.64304125,0.30666667,0.64304125,0.31,0.64304125,0.31333333,0.64304125,0.31666666,0.64304125,0.32,0.64304125,0.32333332,0.64304125,0.32666665,0.64304125,0.33,0.64304125,0.39666668,0.64304125,0.4,0.64304125,0.40333334,0.64304125,0.40666667,0.64304125,0.41333333,0.64304125,0.41666666,0.64304125,0.42,0.64304125,0.42333335,0.64304125,0.42666668,0.64304125,0.43,0.64304125,0.43333334,0.64304125,0.43666667,0.64304125,0.44,0.64304125,0.44333333,0.64304125,0.44666666,0.64304125,0.45,0.64304125,0.6,0.64304125,0.60333335,0.64304125,0.6066667,0.64304125,0.61,0.64304125,0.61333334,0.64304125,0.6166667,0.64304125,0.62,0.64304125,0.62333333,0.64304125,0.62666667,0.64304125,0.63,0.64304125,0.6333333,0.64304125,0.63666666,0.64304125,0.68,0.64304125,0.68333334,0.64304125,0.68666667,0.64304125,0.69,0.64304125,0.6933333,0.64304125,0.69666666,0.64304125,0.7,0.64304125,0.7033333,0.64304125,0.70666665,0.64304125,0.71,0.64304125,0.7133333,0.64304125,0.71666664,0.64304125,0.72,0.64304125,0.72333336,0.64304125,0.7266667,0.64304125,0.73,0.64304125,0.73333335,0.64304125,0.7366667,0.64304125,0.74,0.64304125,0.74333334,0.64304125,0.74666667,0.64304125,0.75,0.64304125,0.75333333,0.64304125,0.75666666,0.64304125,0.76,0.64304125,0.7633333,0.64304125,0.76666665,0.64304125,0.77,0.64304125,0.7733333,0.64304125,0.77666664,0.64304125,0.78,0.64304125,0.78333336,0.64304125,0.7866667,0.64304125,0.79,0.64304125,0.79333335,0.64304125,0.7966667,0.64304125,0.8,0.64304125,0.80333334,0.64304125,0.8066667,0.64304125,0.81,0.64304125,0.81333333,0.64304125,0.81666666,0.64304125,0.82,0.64304125,0.8233333,0.64304125,0.82666665,0.64304125,0.83,0.64304125,0.8333333,0.64304125,0.83666664,0.64304125,0.84,0.64304125,0.8433333,0.64304125,0.8466667,0.64304125,0.85,0.64304125,0.85333335,0.64304125,0.8566667,0.64304125,0.86,0.64304125,0.86333334,0.64304125,0.8666667,0.64304125,0.87,0.64304125,0.87333333,0.64304125,0.87666667,0.64304125,0.88,0.64304125,0.8833333,0.64304125,0.88666666,0.64304125,0.89,0.64304125,0.043333333,0.64561856,0.046666667,0.64561856,0.05,0.64561856,0.053333335,0.64561856,0.05666667,0.64561856,0.06,0.64561856,0.06333333,0.64561856,0.06666667,0.64561856,0.07,0.64561856,0.07333333,0.64561856,0.07666667,0.64561856,0.08,0.64561856,0.083333336,0.64561856,0.086666666,0.64561856,0.09,0.64561856,0.093333334,0.64561856,0.096666664,0.64561856,0.1,0.64561856,0.10333333,0.64561856,0.10666667,0.64561856,0.11,0.64561856,0.11333334,0.64561856,0.11666667,0.64561856,0.12,0.64561856,0.123333335,0.64561856,0.12666667,0.64561856,0.13,0.64561856,0.13333334,0.64561856,0.13666667,0.64561856,0.14,0.64561856,0.14333333,0.64561856,0.14666666,0.64561856,0.15,0.64561856,0.15333334,0.64561856,0.15666667,0.64561856,0.16,0.64561856,0.16333333,0.64561856,0.16666667,0.64561856,0.21666667,0.64561856,0.22,0.64561856,0.22333333,0.64561856,0.22666667,0.64561856,0.23,0.64561856,0.23333333,0.64561856,0.23666666,0.64561856,0.24,0.64561856,0.24333334,0.64561856,0.24666667,0.64561856,0.25,0.64561856,0.25333333,0.64561856,0.25666666,0.64561856,0.26,0.64561856,0.26333332,0.64561856,0.26666668,0.64561856,0.27,0.64561856,0.27333334,0.64561856,0.29,0.64561856,0.29333332,0.64561856,0.29666665,0.64561856,0.3,0.64561856,0.30333334,0.64561856,0.30666667,0.64561856,0.31,0.64561856,0.31333333,0.64561856,0.31666666,0.64561856,0.32,0.64561856,0.32333332,0.64561856,0.32666665,0.64561856,0.39666668,0.64561856,0.4,0.64561856,0.40333334,0.64561856,0.40666667,0.64561856,0.41333333,0.64561856,0.41666666,0.64561856,0.42,0.64561856,0.42333335,0.64561856,0.42666668,0.64561856,0.43,0.64561856,0.43333334,0.64561856,0.43666667,0.64561856,0.44,0.64561856,0.44333333,0.64561856,0.44666666,0.64561856,0.45,0.64561856,0.6,0.64561856,0.60333335,0.64561856,0.6066667,0.64561856,0.61,0.64561856,0.61333334,0.64561856,0.6166667,0.64561856,0.62,0.64561856,0.62333333,0.64561856,0.62666667,0.64561856,0.63,0.64561856,0.6333333,0.64561856,0.63666666,0.64561856,0.64,0.64561856,0.68666667,0.64561856,0.69,0.64561856,0.6933333,0.64561856,0.69666666,0.64561856,0.7,0.64561856,0.7033333,0.64561856,0.70666665,0.64561856,0.71,0.64561856,0.7133333,0.64561856,0.71666664,0.64561856,0.72,0.64561856,0.72333336,0.64561856,0.7266667,0.64561856,0.73,0.64561856,0.73333335,0.64561856,0.7366667,0.64561856,0.74,0.64561856,0.74333334,0.64561856,0.74666667,0.64561856,0.75,0.64561856,0.75333333,0.64561856,0.75666666,0.64561856,0.76,0.64561856,0.7633333,0.64561856,0.76666665,0.64561856,0.77,0.64561856,0.7733333,0.64561856,0.77666664,0.64561856,0.78,0.64561856,0.78333336,0.64561856,0.7866667,0.64561856,0.79,0.64561856,0.79333335,0.64561856,0.7966667,0.64561856,0.8,0.64561856,0.80333334,0.64561856,0.8066667,0.64561856,0.81,0.64561856,0.81333333,0.64561856,0.81666666,0.64561856,0.82,0.64561856,0.8233333,0.64561856,0.82666665,0.64561856,0.83,0.64561856,0.8333333,0.64561856,0.83666664,0.64561856,0.84,0.64561856,0.8433333,0.64561856,0.8466667,0.64561856,0.85,0.64561856,0.85333335,0.64561856,0.8566667,0.64561856,0.86,0.64561856,0.86333334,0.64561856,0.8666667,0.64561856,0.87,0.64561856,0.87333333,0.64561856,0.87666667,0.64561856,0.88,0.64561856,0.8833333,0.64561856,0.88666666,0.64561856,0.046666667,0.64819586,0.05,0.64819586,0.053333335,0.64819586,0.05666667,0.64819586,0.06,0.64819586,0.06333333,0.64819586,0.06666667,0.64819586,0.07,0.64819586,0.07333333,0.64819586,0.07666667,0.64819586,0.08,0.64819586,0.083333336,0.64819586,0.086666666,0.64819586,0.09,0.64819586,0.093333334,0.64819586,0.096666664,0.64819586,0.1,0.64819586,0.10333333,0.64819586,0.10666667,0.64819586,0.11,0.64819586,0.11333334,0.64819586,0.11666667,0.64819586,0.12,0.64819586,0.123333335,0.64819586,0.12666667,0.64819586,0.13,0.64819586,0.13333334,0.64819586,0.13666667,0.64819586,0.14,0.64819586,0.14333333,0.64819586,0.14666666,0.64819586,0.15,0.64819586,0.15333334,0.64819586,0.15666667,0.64819586,0.16,0.64819586,0.16333333,0.64819586,0.16666667,0.64819586,0.21666667,0.64819586,0.22,0.64819586,0.22333333,0.64819586,0.22666667,0.64819586,0.23,0.64819586,0.23333333,0.64819586,0.23666666,0.64819586,0.24,0.64819586,0.24333334,0.64819586,0.24666667,0.64819586,0.25,0.64819586,0.25333333,0.64819586,0.25666666,0.64819586,0.26,0.64819586,0.26333332,0.64819586,0.26666668,0.64819586,0.29,0.64819586,0.29333332,0.64819586,0.29666665,0.64819586,0.3,0.64819586,0.30333334,0.64819586,0.30666667,0.64819586,0.31,0.64819586,0.31333333,0.64819586,0.31666666,0.64819586,0.32,0.64819586,0.32333332,0.64819586,0.32666665,0.64819586,0.39666668,0.64819586,0.4,0.64819586,0.40333334,0.64819586,0.40666667,0.64819586,0.41333333,0.64819586,0.41666666,0.64819586,0.42,0.64819586,0.42333335,0.64819586,0.42666668,0.64819586,0.43,0.64819586,0.43333334,0.64819586,0.43666667,0.64819586,0.44,0.64819586,0.44333333,0.64819586,0.44666666,0.64819586,0.45,0.64819586,0.6,0.64819586,0.60333335,0.64819586,0.6066667,0.64819586,0.61,0.64819586,0.61333334,0.64819586,0.6166667,0.64819586,0.62,0.64819586,0.62333333,0.64819586,0.62666667,0.64819586,0.63,0.64819586,0.6333333,0.64819586,0.63666666,0.64819586,0.64,0.64819586,0.6433333,0.64819586,0.69,0.64819586,0.6933333,0.64819586,0.69666666,0.64819586,0.7,0.64819586,0.7033333,0.64819586,0.70666665,0.64819586,0.71,0.64819586,0.7133333,0.64819586,0.71666664,0.64819586,0.72,0.64819586,0.72333336,0.64819586,0.7266667,0.64819586,0.73,0.64819586,0.73333335,0.64819586,0.7366667,0.64819586,0.74,0.64819586,0.74333334,0.64819586,0.74666667,0.64819586,0.75,0.64819586,0.75333333,0.64819586,0.75666666,0.64819586,0.76,0.64819586,0.7633333,0.64819586,0.76666665,0.64819586,0.77,0.64819586,0.7733333,0.64819586,0.77666664,0.64819586,0.78,0.64819586,0.78333336,0.64819586,0.7866667,0.64819586,0.79,0.64819586,0.79333335,0.64819586,0.7966667,0.64819586,0.8,0.64819586,0.80333334,0.64819586,0.8066667,0.64819586,0.81,0.64819586,0.81333333,0.64819586,0.81666666,0.64819586,0.82,0.64819586,0.8233333,0.64819586,0.82666665,0.64819586,0.83,0.64819586,0.8333333,0.64819586,0.83666664,0.64819586,0.84,0.64819586,0.8433333,0.64819586,0.8466667,0.64819586,0.85,0.64819586,0.85333335,0.64819586,0.8566667,0.64819586,0.86,0.64819586,0.86333334,0.64819586,0.8666667,0.64819586,0.87,0.64819586,0.87333333,0.64819586,0.87666667,0.64819586,0.88,0.64819586,0.8833333,0.64819586,0.05,0.65077317,0.053333335,0.65077317,0.05666667,0.65077317,0.06,0.65077317,0.06333333,0.65077317,0.06666667,0.65077317,0.07,0.65077317,0.07333333,0.65077317,0.07666667,0.65077317,0.08,0.65077317,0.083333336,0.65077317,0.086666666,0.65077317,0.09,0.65077317,0.093333334,0.65077317,0.096666664,0.65077317,0.1,0.65077317,0.10333333,0.65077317,0.10666667,0.65077317,0.11,0.65077317,0.11333334,0.65077317,0.11666667,0.65077317,0.12,0.65077317,0.123333335,0.65077317,0.12666667,0.65077317,0.13,0.65077317,0.13333334,0.65077317,0.13666667,0.65077317,0.14,0.65077317,0.14333333,0.65077317,0.14666666,0.65077317,0.15,0.65077317,0.15333334,0.65077317,0.15666667,0.65077317,0.16,0.65077317,0.16333333,0.65077317,0.16666667,0.65077317,0.17,0.65077317,0.17333333,0.65077317,0.17666666,0.65077317,0.18,0.65077317,0.18333334,0.65077317,0.18666667,0.65077317,0.21666667,0.65077317,0.22,0.65077317,0.22333333,0.65077317,0.22666667,0.65077317,0.23,0.65077317,0.23333333,0.65077317,0.23666666,0.65077317,0.24,0.65077317,0.24333334,0.65077317,0.24666667,0.65077317,0.25,0.65077317,0.25333333,0.65077317,0.25666666,0.65077317,0.26,0.65077317,0.29,0.65077317,0.29333332,0.65077317,0.29666665,0.65077317,0.3,0.65077317,0.30333334,0.65077317,0.30666667,0.65077317,0.31,0.65077317,0.31333333,0.65077317,0.31666666,0.65077317,0.32,0.65077317,0.32333332,0.65077317,0.32666665,0.65077317,0.39666668,0.65077317,0.4,0.65077317,0.40333334,0.65077317,0.40666667,0.65077317,0.41333333,0.65077317,0.41666666,0.65077317,0.42,0.65077317,0.42333335,0.65077317,0.42666668,0.65077317,0.43,0.65077317,0.43333334,0.65077317,0.43666667,0.65077317,0.44,0.65077317,0.44333333,0.65077317,0.44666666,0.65077317,0.45,0.65077317,0.45333335,0.65077317,0.6,0.65077317,0.60333335,0.65077317,0.6066667,0.65077317,0.61,0.65077317,0.61333334,0.65077317,0.6166667,0.65077317,0.62,0.65077317,0.62333333,0.65077317,0.62666667,0.65077317,0.63,0.65077317,0.6333333,0.65077317,0.63666666,0.65077317,0.64,0.65077317,0.6433333,0.65077317,0.69,0.65077317,0.6933333,0.65077317,0.69666666,0.65077317,0.7,0.65077317,0.7033333,0.65077317,0.70666665,0.65077317,0.71,0.65077317,0.7133333,0.65077317,0.71666664,0.65077317,0.72,0.65077317,0.72333336,0.65077317,0.7266667,0.65077317,0.73,0.65077317,0.73333335,0.65077317,0.7366667,0.65077317,0.74,0.65077317,0.74333334,0.65077317,0.74666667,0.65077317,0.75,0.65077317,0.75333333,0.65077317,0.75666666,0.65077317,0.76,0.65077317,0.7633333,0.65077317,0.76666665,0.65077317,0.77,0.65077317,0.7733333,0.65077317,0.77666664,0.65077317,0.78,0.65077317,0.78333336,0.65077317,0.7866667,0.65077317,0.79,0.65077317,0.79333335,0.65077317,0.7966667,0.65077317,0.8,0.65077317,0.80333334,0.65077317,0.8066667,0.65077317,0.81,0.65077317,0.81333333,0.65077317,0.81666666,0.65077317,0.82,0.65077317,0.8233333,0.65077317,0.82666665,0.65077317,0.83,0.65077317,0.8333333,0.65077317,0.83666664,0.65077317,0.84,0.65077317,0.8433333,0.65077317,0.8466667,0.65077317,0.85,0.65077317,0.85333335,0.65077317,0.8566667,0.65077317,0.86,0.65077317,0.86333334,0.65077317,0.8666667,0.65077317,0.87,0.65077317,0.87333333,0.65077317,0.87666667,0.65077317,0.88,0.65077317,0.8833333,0.65077317,0.053333335,0.65335053,0.05666667,0.65335053,0.06,0.65335053,0.06333333,0.65335053,0.06666667,0.65335053,0.07,0.65335053,0.07333333,0.65335053,0.07666667,0.65335053,0.08,0.65335053,0.083333336,0.65335053,0.086666666,0.65335053,0.09,0.65335053,0.093333334,0.65335053,0.096666664,0.65335053,0.1,0.65335053,0.10333333,0.65335053,0.10666667,0.65335053,0.11,0.65335053,0.11333334,0.65335053,0.11666667,0.65335053,0.12,0.65335053,0.123333335,0.65335053,0.12666667,0.65335053,0.13,0.65335053,0.13333334,0.65335053,0.13666667,0.65335053,0.14,0.65335053,0.14333333,0.65335053,0.14666666,0.65335053,0.15,0.65335053,0.15333334,0.65335053,0.15666667,0.65335053,0.16,0.65335053,0.16333333,0.65335053,0.16666667,0.65335053,0.17,0.65335053,0.17333333,0.65335053,0.17666666,0.65335053,0.18,0.65335053,0.18333334,0.65335053,0.18666667,0.65335053,0.21666667,0.65335053,0.22,0.65335053,0.22333333,0.65335053,0.22666667,0.65335053,0.23,0.65335053,0.23333333,0.65335053,0.23666666,0.65335053,0.24,0.65335053,0.24333334,0.65335053,0.24666667,0.65335053,0.25,0.65335053,0.25333333,0.65335053,0.25666666,0.65335053,0.29,0.65335053,0.29333332,0.65335053,0.29666665,0.65335053,0.3,0.65335053,0.30333334,0.65335053,0.30666667,0.65335053,0.31,0.65335053,0.31333333,0.65335053,0.31666666,0.65335053,0.32,0.65335053,0.32333332,0.65335053,0.32666665,0.65335053,0.33,0.65335053,0.33333334,0.65335053,0.33666667,0.65335053,0.39333335,0.65335053,0.39666668,0.65335053,0.4,0.65335053,0.40333334,0.65335053,0.40666667,0.65335053,0.41333333,0.65335053,0.41666666,0.65335053,0.42,0.65335053,0.42333335,0.65335053,0.42666668,0.65335053,0.43,0.65335053,0.43333334,0.65335053,0.43666667,0.65335053,0.44,0.65335053,0.44333333,0.65335053,0.44666666,0.65335053,0.45,0.65335053,0.45333335,0.65335053,0.45666668,0.65335053,0.60333335,0.65335053,0.6066667,0.65335053,0.61,0.65335053,0.61333334,0.65335053,0.6166667,0.65335053,0.62,0.65335053,0.62333333,0.65335053,0.62666667,0.65335053,0.63,0.65335053,0.6333333,0.65335053,0.63666666,0.65335053,0.64,0.65335053,0.6433333,0.65335053,0.64666665,0.65335053,0.6933333,0.65335053,0.69666666,0.65335053,0.7,0.65335053,0.7033333,0.65335053,0.70666665,0.65335053,0.71,0.65335053,0.7133333,0.65335053,0.71666664,0.65335053,0.72,0.65335053,0.72333336,0.65335053,0.7266667,0.65335053,0.73,0.65335053,0.73333335,0.65335053,0.7366667,0.65335053,0.74,0.65335053,0.74333334,0.65335053,0.74666667,0.65335053,0.75,0.65335053,0.75333333,0.65335053,0.75666666,0.65335053,0.76,0.65335053,0.7633333,0.65335053,0.76666665,0.65335053,0.77,0.65335053,0.7733333,0.65335053,0.77666664,0.65335053,0.78,0.65335053,0.78333336,0.65335053,0.7866667,0.65335053,0.79,0.65335053,0.79333335,0.65335053,0.7966667,0.65335053,0.8,0.65335053,0.80333334,0.65335053,0.8066667,0.65335053,0.81,0.65335053,0.81333333,0.65335053,0.81666666,0.65335053,0.82,0.65335053,0.8233333,0.65335053,0.82666665,0.65335053,0.83,0.65335053,0.8333333,0.65335053,0.83666664,0.65335053,0.84,0.65335053,0.8433333,0.65335053,0.8466667,0.65335053,0.85,0.65335053,0.85333335,0.65335053,0.8566667,0.65335053,0.86,0.65335053,0.86333334,0.65335053,0.8666667,0.65335053,0.87,0.65335053,0.87333333,0.65335053,0.87666667,0.65335053,0.88,0.65335053,0.8833333,0.65335053,0.05666667,0.65592784,0.06,0.65592784,0.06333333,0.65592784,0.06666667,0.65592784,0.07,0.65592784,0.07333333,0.65592784,0.07666667,0.65592784,0.08,0.65592784,0.083333336,0.65592784,0.086666666,0.65592784,0.09,0.65592784,0.093333334,0.65592784,0.096666664,0.65592784,0.1,0.65592784,0.10333333,0.65592784,0.10666667,0.65592784,0.11,0.65592784,0.11333334,0.65592784,0.11666667,0.65592784,0.12,0.65592784,0.123333335,0.65592784,0.12666667,0.65592784,0.13,0.65592784,0.13333334,0.65592784,0.13666667,0.65592784,0.14,0.65592784,0.14333333,0.65592784,0.14666666,0.65592784,0.15,0.65592784,0.15333334,0.65592784,0.15666667,0.65592784,0.16,0.65592784,0.16333333,0.65592784,0.16666667,0.65592784,0.17,0.65592784,0.17333333,0.65592784,0.17666666,0.65592784,0.18,0.65592784,0.18333334,0.65592784,0.18666667,0.65592784,0.22,0.65592784,0.22333333,0.65592784,0.22666667,0.65592784,0.23,0.65592784,0.23333333,0.65592784,0.23666666,0.65592784,0.24,0.65592784,0.24333334,0.65592784,0.24666667,0.65592784,0.25,0.65592784,0.25333333,0.65592784,0.25666666,0.65592784,0.26,0.65592784,0.29333332,0.65592784,0.29666665,0.65592784,0.3,0.65592784,0.30333334,0.65592784,0.30666667,0.65592784,0.31,0.65592784,0.31333333,0.65592784,0.31666666,0.65592784,0.32,0.65592784,0.32333332,0.65592784,0.32666665,0.65592784,0.33,0.65592784,0.33333334,0.65592784,0.33666667,0.65592784,0.34,0.65592784,0.39,0.65592784,0.39333335,0.65592784,0.39666668,0.65592784,0.4,0.65592784,0.40333334,0.65592784,0.41,0.65592784,0.41333333,0.65592784,0.41666666,0.65592784,0.42,0.65592784,0.42333335,0.65592784,0.42666668,0.65592784,0.43,0.65592784,0.43333334,0.65592784,0.43666667,0.65592784,0.44,0.65592784,0.44333333,0.65592784,0.44666666,0.65592784,0.45,0.65592784,0.45333335,0.65592784,0.45666668,0.65592784,0.46,0.65592784,0.60333335,0.65592784,0.6066667,0.65592784,0.61,0.65592784,0.61333334,0.65592784,0.6166667,0.65592784,0.62,0.65592784,0.62333333,0.65592784,0.62666667,0.65592784,0.63,0.65592784,0.6333333,0.65592784,0.63666666,0.65592784,0.64,0.65592784,0.6433333,0.65592784,0.64666665,0.65592784,0.65,0.65592784,0.6933333,0.65592784,0.69666666,0.65592784,0.7,0.65592784,0.7033333,0.65592784,0.70666665,0.65592784,0.71,0.65592784,0.7133333,0.65592784,0.71666664,0.65592784,0.72,0.65592784,0.72333336,0.65592784,0.7266667,0.65592784,0.73,0.65592784,0.73333335,0.65592784,0.7366667,0.65592784,0.74,0.65592784,0.74333334,0.65592784,0.74666667,0.65592784,0.75,0.65592784,0.75333333,0.65592784,0.75666666,0.65592784,0.76,0.65592784,0.7633333,0.65592784,0.76666665,0.65592784,0.77,0.65592784,0.7733333,0.65592784,0.77666664,0.65592784,0.78,0.65592784,0.78333336,0.65592784,0.7866667,0.65592784,0.79,0.65592784,0.79333335,0.65592784,0.7966667,0.65592784,0.8,0.65592784,0.80333334,0.65592784,0.8066667,0.65592784,0.81,0.65592784,0.81333333,0.65592784,0.81666666,0.65592784,0.82,0.65592784,0.8233333,0.65592784,0.82666665,0.65592784,0.83,0.65592784,0.8333333,0.65592784,0.83666664,0.65592784,0.84,0.65592784,0.8433333,0.65592784,0.8466667,0.65592784,0.85,0.65592784,0.85333335,0.65592784,0.8566667,0.65592784,0.86,0.65592784,0.86333334,0.65592784,0.8666667,0.65592784,0.87,0.65592784,0.87333333,0.65592784,0.87666667,0.65592784,0.88,0.65592784,0.8833333,0.65592784,0.88666666,0.65592784,0.06333333,0.65850514,0.06666667,0.65850514,0.07,0.65850514,0.07333333,0.65850514,0.07666667,0.65850514,0.08,0.65850514,0.083333336,0.65850514,0.086666666,0.65850514,0.09,0.65850514,0.093333334,0.65850514,0.096666664,0.65850514,0.1,0.65850514,0.10333333,0.65850514,0.10666667,0.65850514,0.11,0.65850514,0.11333334,0.65850514,0.11666667,0.65850514,0.12,0.65850514,0.123333335,0.65850514,0.12666667,0.65850514,0.13,0.65850514,0.13333334,0.65850514,0.13666667,0.65850514,0.14,0.65850514,0.14333333,0.65850514,0.14666666,0.65850514,0.15,0.65850514,0.15333334,0.65850514,0.15666667,0.65850514,0.16,0.65850514,0.16333333,0.65850514,0.16666667,0.65850514,0.17,0.65850514,0.17333333,0.65850514,0.17666666,0.65850514,0.18,0.65850514,0.18333334,0.65850514,0.22,0.65850514,0.22333333,0.65850514,0.22666667,0.65850514,0.23,0.65850514,0.23333333,0.65850514,0.23666666,0.65850514,0.24,0.65850514,0.24333334,0.65850514,0.24666667,0.65850514,0.25,0.65850514,0.25333333,0.65850514,0.25666666,0.65850514,0.26,0.65850514,0.26333332,0.65850514,0.29333332,0.65850514,0.29666665,0.65850514,0.3,0.65850514,0.30333334,0.65850514,0.30666667,0.65850514,0.31,0.65850514,0.31333333,0.65850514,0.31666666,0.65850514,0.32,0.65850514,0.32333332,0.65850514,0.32666665,0.65850514,0.33,0.65850514,0.33333334,0.65850514,0.33666667,0.65850514,0.34,0.65850514,0.34333333,0.65850514,0.38666666,0.65850514,0.39,0.65850514,0.39333335,0.65850514,0.39666668,0.65850514,0.4,0.65850514,0.40333334,0.65850514,0.40666667,0.65850514,0.41,0.65850514,0.41333333,0.65850514,0.41666666,0.65850514,0.42,0.65850514,0.42333335,0.65850514,0.42666668,0.65850514,0.43,0.65850514,0.43333334,0.65850514,0.43666667,0.65850514,0.44,0.65850514,0.44333333,0.65850514,0.44666666,0.65850514,0.45,0.65850514,0.45333335,0.65850514,0.45666668,0.65850514,0.46,0.65850514,0.46333334,0.65850514,0.5566667,0.65850514,0.56,0.65850514,0.56333333,0.65850514,0.56666666,0.65850514,0.57,0.65850514,0.5733333,0.65850514,0.57666665,0.65850514,0.6066667,0.65850514,0.61,0.65850514,0.61333334,0.65850514,0.6166667,0.65850514,0.62,0.65850514,0.62333333,0.65850514,0.62666667,0.65850514,0.63,0.65850514,0.6333333,0.65850514,0.63666666,0.65850514,0.64,0.65850514,0.6433333,0.65850514,0.64666665,0.65850514,0.65,0.65850514,0.6933333,0.65850514,0.69666666,0.65850514,0.7,0.65850514,0.7033333,0.65850514,0.70666665,0.65850514,0.71,0.65850514,0.7133333,0.65850514,0.71666664,0.65850514,0.72,0.65850514,0.72333336,0.65850514,0.7266667,0.65850514,0.73,0.65850514,0.73333335,0.65850514,0.7366667,0.65850514,0.74,0.65850514,0.74333334,0.65850514,0.74666667,0.65850514,0.75,0.65850514,0.75333333,0.65850514,0.75666666,0.65850514,0.76,0.65850514,0.7633333,0.65850514,0.76666665,0.65850514,0.77,0.65850514,0.7733333,0.65850514,0.77666664,0.65850514,0.78,0.65850514,0.78333336,0.65850514,0.7866667,0.65850514,0.79,0.65850514,0.79333335,0.65850514,0.7966667,0.65850514,0.8,0.65850514,0.80333334,0.65850514,0.8066667,0.65850514,0.81,0.65850514,0.81333333,0.65850514,0.81666666,0.65850514,0.82,0.65850514,0.8233333,0.65850514,0.82666665,0.65850514,0.83,0.65850514,0.8333333,0.65850514,0.83666664,0.65850514,0.84,0.65850514,0.8433333,0.65850514,0.8466667,0.65850514,0.85,0.65850514,0.85333335,0.65850514,0.8566667,0.65850514,0.86,0.65850514,0.86333334,0.65850514,0.8666667,0.65850514,0.87,0.65850514,0.87333333,0.65850514,0.87666667,0.65850514,0.88,0.65850514,0.8833333,0.65850514,0.88666666,0.65850514,0.89,0.65850514,0.06333333,0.66108245,0.06666667,0.66108245,0.07,0.66108245,0.07333333,0.66108245,0.07666667,0.66108245,0.08,0.66108245,0.083333336,0.66108245,0.086666666,0.66108245,0.09,0.66108245,0.093333334,0.66108245,0.096666664,0.66108245,0.1,0.66108245,0.10333333,0.66108245,0.10666667,0.66108245,0.11,0.66108245,0.11333334,0.66108245,0.11666667,0.66108245,0.12,0.66108245,0.123333335,0.66108245,0.12666667,0.66108245,0.13,0.66108245,0.13333334,0.66108245,0.13666667,0.66108245,0.14,0.66108245,0.14333333,0.66108245,0.14666666,0.66108245,0.15,0.66108245,0.15333334,0.66108245,0.15666667,0.66108245,0.16,0.66108245,0.16333333,0.66108245,0.16666667,0.66108245,0.17,0.66108245,0.17333333,0.66108245,0.17666666,0.66108245,0.18,0.66108245,0.22,0.66108245,0.22333333,0.66108245,0.22666667,0.66108245,0.23,0.66108245,0.23333333,0.66108245,0.23666666,0.66108245,0.24,0.66108245,0.24333334,0.66108245,0.24666667,0.66108245,0.25,0.66108245,0.25333333,0.66108245,0.25666666,0.66108245,0.26,0.66108245,0.26333332,0.66108245,0.29333332,0.66108245,0.29666665,0.66108245,0.3,0.66108245,0.30333334,0.66108245,0.30666667,0.66108245,0.31,0.66108245,0.31333333,0.66108245,0.31666666,0.66108245,0.32,0.66108245,0.32333332,0.66108245,0.32666665,0.66108245,0.33,0.66108245,0.33333334,0.66108245,0.33666667,0.66108245,0.34,0.66108245,0.34333333,0.66108245,0.34666666,0.66108245,0.38333333,0.66108245,0.38666666,0.66108245,0.39,0.66108245,0.39333335,0.66108245,0.39666668,0.66108245,0.4,0.66108245,0.40666667,0.66108245,0.41,0.66108245,0.41333333,0.66108245,0.41666666,0.66108245,0.42,0.66108245,0.42333335,0.66108245,0.42666668,0.66108245,0.43,0.66108245,0.43333334,0.66108245,0.43666667,0.66108245,0.44,0.66108245,0.44333333,0.66108245,0.44666666,0.66108245,0.45,0.66108245,0.45333335,0.66108245,0.45666668,0.66108245,0.46,0.66108245,0.46333334,0.66108245,0.46666667,0.66108245,0.55333334,0.66108245,0.5566667,0.66108245,0.56,0.66108245,0.56333333,0.66108245,0.56666666,0.66108245,0.57,0.66108245,0.5733333,0.66108245,0.57666665,0.66108245,0.58,0.66108245,0.61,0.66108245,0.61333334,0.66108245,0.6166667,0.66108245,0.62,0.66108245,0.62333333,0.66108245,0.62666667,0.66108245,0.63,0.66108245,0.6333333,0.66108245,0.63666666,0.66108245,0.64,0.66108245,0.6433333,0.66108245,0.64666665,0.66108245,0.65,0.66108245,0.6933333,0.66108245,0.69666666,0.66108245,0.7,0.66108245,0.7033333,0.66108245,0.70666665,0.66108245,0.71,0.66108245,0.7133333,0.66108245,0.71666664,0.66108245,0.72,0.66108245,0.72333336,0.66108245,0.7266667,0.66108245,0.73,0.66108245,0.73333335,0.66108245,0.7366667,0.66108245,0.74,0.66108245,0.74333334,0.66108245,0.74666667,0.66108245,0.75,0.66108245,0.75333333,0.66108245,0.75666666,0.66108245,0.76,0.66108245,0.7633333,0.66108245,0.76666665,0.66108245,0.77,0.66108245,0.7733333,0.66108245,0.77666664,0.66108245,0.78,0.66108245,0.78333336,0.66108245,0.7866667,0.66108245,0.79,0.66108245,0.79333335,0.66108245,0.7966667,0.66108245,0.8,0.66108245,0.80333334,0.66108245,0.8066667,0.66108245,0.81,0.66108245,0.81333333,0.66108245,0.81666666,0.66108245,0.82,0.66108245,0.8233333,0.66108245,0.82666665,0.66108245,0.83,0.66108245,0.8333333,0.66108245,0.83666664,0.66108245,0.84,0.66108245,0.8433333,0.66108245,0.8466667,0.66108245,0.85,0.66108245,0.85333335,0.66108245,0.8566667,0.66108245,0.86,0.66108245,0.86333334,0.66108245,0.8666667,0.66108245,0.87,0.66108245,0.87333333,0.66108245,0.87666667,0.66108245,0.88,0.66108245,0.8833333,0.66108245,0.88666666,0.66108245,0.89,0.66108245,0.8933333,0.66108245,0.06333333,0.6636598,0.06666667,0.6636598,0.07,0.6636598,0.07333333,0.6636598,0.07666667,0.6636598,0.08,0.6636598,0.083333336,0.6636598,0.086666666,0.6636598,0.09,0.6636598,0.093333334,0.6636598,0.096666664,0.6636598,0.1,0.6636598,0.10333333,0.6636598,0.10666667,0.6636598,0.11,0.6636598,0.11333334,0.6636598,0.11666667,0.6636598,0.12,0.6636598,0.123333335,0.6636598,0.12666667,0.6636598,0.13,0.6636598,0.13333334,0.6636598,0.13666667,0.6636598,0.14,0.6636598,0.16,0.6636598,0.16333333,0.6636598,0.16666667,0.6636598,0.17,0.6636598,0.21666667,0.6636598,0.22,0.6636598,0.22333333,0.6636598,0.22666667,0.6636598,0.23,0.6636598,0.23333333,0.6636598,0.23666666,0.6636598,0.24,0.6636598,0.24333334,0.6636598,0.24666667,0.6636598,0.25,0.6636598,0.25333333,0.6636598,0.25666666,0.6636598,0.26,0.6636598,0.26333332,0.6636598,0.29333332,0.6636598,0.29666665,0.6636598,0.3,0.6636598,0.30333334,0.6636598,0.30666667,0.6636598,0.31,0.6636598,0.31333333,0.6636598,0.31666666,0.6636598,0.32,0.6636598,0.32333332,0.6636598,0.32666665,0.6636598,0.33,0.6636598,0.33333334,0.6636598,0.33666667,0.6636598,0.34,0.6636598,0.34333333,0.6636598,0.34666666,0.6636598,0.37666667,0.6636598,0.38,0.6636598,0.38333333,0.6636598,0.38666666,0.6636598,0.39,0.6636598,0.39333335,0.6636598,0.39666668,0.6636598,0.4,0.6636598,0.40666667,0.6636598,0.41,0.6636598,0.41333333,0.6636598,0.41666666,0.6636598,0.42,0.6636598,0.42333335,0.6636598,0.42666668,0.6636598,0.43,0.6636598,0.43333334,0.6636598,0.43666667,0.6636598,0.44,0.6636598,0.44333333,0.6636598,0.44666666,0.6636598,0.45,0.6636598,0.45333335,0.6636598,0.45666668,0.6636598,0.46,0.6636598,0.46333334,0.6636598,0.46666667,0.6636598,0.55,0.6636598,0.55333334,0.6636598,0.5566667,0.6636598,0.56,0.6636598,0.56333333,0.6636598,0.56666666,0.6636598,0.57,0.6636598,0.5733333,0.6636598,0.57666665,0.6636598,0.58,0.6636598,0.5833333,0.6636598,0.61,0.6636598,0.61333334,0.6636598,0.6166667,0.6636598,0.62,0.6636598,0.62333333,0.6636598,0.62666667,0.6636598,0.63,0.6636598,0.6333333,0.6636598,0.63666666,0.6636598,0.64,0.6636598,0.6433333,0.6636598,0.64666665,0.6636598,0.65,0.6636598,0.69,0.6636598,0.6933333,0.6636598,0.69666666,0.6636598,0.7,0.6636598,0.7033333,0.6636598,0.70666665,0.6636598,0.71,0.6636598,0.7133333,0.6636598,0.71666664,0.6636598,0.72,0.6636598,0.72333336,0.6636598,0.7266667,0.6636598,0.73,0.6636598,0.73333335,0.6636598,0.7366667,0.6636598,0.74,0.6636598,0.74333334,0.6636598,0.74666667,0.6636598,0.75,0.6636598,0.75333333,0.6636598,0.75666666,0.6636598,0.76,0.6636598,0.7633333,0.6636598,0.76666665,0.6636598,0.77,0.6636598,0.7733333,0.6636598,0.77666664,0.6636598,0.78,0.6636598,0.78333336,0.6636598,0.7866667,0.6636598,0.79,0.6636598,0.79333335,0.6636598,0.7966667,0.6636598,0.8,0.6636598,0.80333334,0.6636598,0.8066667,0.6636598,0.81,0.6636598,0.81333333,0.6636598,0.81666666,0.6636598,0.82,0.6636598,0.8233333,0.6636598,0.82666665,0.6636598,0.83,0.6636598,0.8333333,0.6636598,0.83666664,0.6636598,0.84,0.6636598,0.8433333,0.6636598,0.8466667,0.6636598,0.85,0.6636598,0.85333335,0.6636598,0.8566667,0.6636598,0.86,0.6636598,0.86333334,0.6636598,0.8666667,0.6636598,0.87,0.6636598,0.87333333,0.6636598,0.87666667,0.6636598,0.88,0.6636598,0.8833333,0.6636598,0.88666666,0.6636598,0.89,0.6636598,0.8933333,0.6636598,0.89666665,0.6636598,0.9,0.6636598,0.06333333,0.6662371,0.06666667,0.6662371,0.07,0.6662371,0.07333333,0.6662371,0.07666667,0.6662371,0.08,0.6662371,0.083333336,0.6662371,0.086666666,0.6662371,0.09,0.6662371,0.093333334,0.6662371,0.096666664,0.6662371,0.10333333,0.6662371,0.10666667,0.6662371,0.11,0.6662371,0.11333334,0.6662371,0.11666667,0.6662371,0.12,0.6662371,0.123333335,0.6662371,0.12666667,0.6662371,0.13,0.6662371,0.13333334,0.6662371,0.13666667,0.6662371,0.14,0.6662371,0.14333333,0.6662371,0.14666666,0.6662371,0.15,0.6662371,0.15333334,0.6662371,0.15666667,0.6662371,0.16,0.6662371,0.16333333,0.6662371,0.16666667,0.6662371,0.17,0.6662371,0.17333333,0.6662371,0.17666666,0.6662371,0.18,0.6662371,0.21666667,0.6662371,0.22,0.6662371,0.22333333,0.6662371,0.22666667,0.6662371,0.23,0.6662371,0.23333333,0.6662371,0.23666666,0.6662371,0.24,0.6662371,0.24333334,0.6662371,0.24666667,0.6662371,0.25,0.6662371,0.25333333,0.6662371,0.25666666,0.6662371,0.26,0.6662371,0.26333332,0.6662371,0.26666668,0.6662371,0.29666665,0.6662371,0.3,0.6662371,0.30333334,0.6662371,0.30666667,0.6662371,0.31,0.6662371,0.31333333,0.6662371,0.31666666,0.6662371,0.32,0.6662371,0.32333332,0.6662371,0.32666665,0.6662371,0.33,0.6662371,0.33333334,0.6662371,0.33666667,0.6662371,0.34,0.6662371,0.34333333,0.6662371,0.34666666,0.6662371,0.35,0.6662371,0.37333333,0.6662371,0.37666667,0.6662371,0.38,0.6662371,0.38333333,0.6662371,0.38666666,0.6662371,0.39,0.6662371,0.39333335,0.6662371,0.39666668,0.6662371,0.4,0.6662371,0.40333334,0.6662371,0.41,0.6662371,0.41333333,0.6662371,0.41666666,0.6662371,0.42,0.6662371,0.42333335,0.6662371,0.42666668,0.6662371,0.43,0.6662371,0.43333334,0.6662371,0.43666667,0.6662371,0.44,0.6662371,0.44333333,0.6662371,0.44666666,0.6662371,0.45,0.6662371,0.45333335,0.6662371,0.45666668,0.6662371,0.46,0.6662371,0.46333334,0.6662371,0.46666667,0.6662371,0.47,0.6662371,0.55,0.6662371,0.55333334,0.6662371,0.5566667,0.6662371,0.56,0.6662371,0.56333333,0.6662371,0.5733333,0.6662371,0.57666665,0.6662371,0.58,0.6662371,0.5833333,0.6662371,0.61,0.6662371,0.61333334,0.6662371,0.6166667,0.6662371,0.62,0.6662371,0.62333333,0.6662371,0.62666667,0.6662371,0.63,0.6662371,0.6333333,0.6662371,0.63666666,0.6662371,0.64,0.6662371,0.6433333,0.6662371,0.64666665,0.6662371,0.65,0.6662371,0.68666667,0.6662371,0.69,0.6662371,0.6933333,0.6662371,0.69666666,0.6662371,0.7,0.6662371,0.7033333,0.6662371,0.70666665,0.6662371,0.71,0.6662371,0.7133333,0.6662371,0.71666664,0.6662371,0.72,0.6662371,0.72333336,0.6662371,0.7266667,0.6662371,0.73,0.6662371,0.73333335,0.6662371,0.7366667,0.6662371,0.74,0.6662371,0.74333334,0.6662371,0.74666667,0.6662371,0.75,0.6662371,0.75333333,0.6662371,0.75666666,0.6662371,0.76,0.6662371,0.7633333,0.6662371,0.76666665,0.6662371,0.77,0.6662371,0.7733333,0.6662371,0.77666664,0.6662371,0.78,0.6662371,0.78333336,0.6662371,0.7866667,0.6662371,0.79,0.6662371,0.79333335,0.6662371,0.7966667,0.6662371,0.8,0.6662371,0.80333334,0.6662371,0.8066667,0.6662371,0.81,0.6662371,0.81333333,0.6662371,0.81666666,0.6662371,0.82,0.6662371,0.8233333,0.6662371,0.82666665,0.6662371,0.83,0.6662371,0.8333333,0.6662371,0.83666664,0.6662371,0.84,0.6662371,0.8433333,0.6662371,0.8466667,0.6662371,0.85,0.6662371,0.85333335,0.6662371,0.8566667,0.6662371,0.86,0.6662371,0.86333334,0.6662371,0.8666667,0.6662371,0.87,0.6662371,0.87333333,0.6662371,0.87666667,0.6662371,0.88,0.6662371,0.8833333,0.6662371,0.88666666,0.6662371,0.89,0.6662371,0.8933333,0.6662371,0.89666665,0.6662371,0.9,0.6662371,0.9033333,0.6662371,0.9066667,0.6662371,0.91,0.6662371,0.06333333,0.6688144,0.06666667,0.6688144,0.07,0.6688144,0.07333333,0.6688144,0.07666667,0.6688144,0.08,0.6688144,0.083333336,0.6688144,0.086666666,0.6688144,0.09,0.6688144,0.096666664,0.6688144,0.1,0.6688144,0.10333333,0.6688144,0.10666667,0.6688144,0.11,0.6688144,0.11333334,0.6688144,0.11666667,0.6688144,0.12,0.6688144,0.123333335,0.6688144,0.12666667,0.6688144,0.13,0.6688144,0.13333334,0.6688144,0.13666667,0.6688144,0.14,0.6688144,0.14333333,0.6688144,0.14666666,0.6688144,0.15,0.6688144,0.15333334,0.6688144,0.15666667,0.6688144,0.16,0.6688144,0.16333333,0.6688144,0.16666667,0.6688144,0.17,0.6688144,0.17333333,0.6688144,0.17666666,0.6688144,0.18,0.6688144,0.21333334,0.6688144,0.21666667,0.6688144,0.22,0.6688144,0.22333333,0.6688144,0.22666667,0.6688144,0.23,0.6688144,0.23333333,0.6688144,0.23666666,0.6688144,0.24,0.6688144,0.24333334,0.6688144,0.24666667,0.6688144,0.25,0.6688144,0.25333333,0.6688144,0.25666666,0.6688144,0.26,0.6688144,0.26333332,0.6688144,0.26666668,0.6688144,0.3,0.6688144,0.30333334,0.6688144,0.30666667,0.6688144,0.31,0.6688144,0.31333333,0.6688144,0.31666666,0.6688144,0.32,0.6688144,0.32333332,0.6688144,0.32666665,0.6688144,0.33,0.6688144,0.33333334,0.6688144,0.33666667,0.6688144,0.34,0.6688144,0.34333333,0.6688144,0.34666666,0.6688144,0.35,0.6688144,0.37,0.6688144,0.37333333,0.6688144,0.37666667,0.6688144,0.38,0.6688144,0.38333333,0.6688144,0.38666666,0.6688144,0.39,0.6688144,0.39333335,0.6688144,0.39666668,0.6688144,0.4,0.6688144,0.40333334,0.6688144,0.41,0.6688144,0.41333333,0.6688144,0.43,0.6688144,0.43333334,0.6688144,0.43666667,0.6688144,0.44,0.6688144,0.44333333,0.6688144,0.44666666,0.6688144,0.45,0.6688144,0.45333335,0.6688144,0.45666668,0.6688144,0.46,0.6688144,0.46333334,0.6688144,0.46666667,0.6688144,0.47,0.6688144,0.55,0.6688144,0.55333334,0.6688144,0.5566667,0.6688144,0.56,0.6688144,0.5733333,0.6688144,0.57666665,0.6688144,0.58,0.6688144,0.5833333,0.6688144,0.61,0.6688144,0.61333334,0.6688144,0.6166667,0.6688144,0.62,0.6688144,0.62333333,0.6688144,0.62666667,0.6688144,0.63,0.6688144,0.6333333,0.6688144,0.63666666,0.6688144,0.64,0.6688144,0.6433333,0.6688144,0.64666665,0.6688144,0.65,0.6688144,0.68,0.6688144,0.68333334,0.6688144,0.68666667,0.6688144,0.69,0.6688144,0.6933333,0.6688144,0.69666666,0.6688144,0.7,0.6688144,0.7033333,0.6688144,0.70666665,0.6688144,0.71,0.6688144,0.7133333,0.6688144,0.71666664,0.6688144,0.72,0.6688144,0.72333336,0.6688144,0.7266667,0.6688144,0.73,0.6688144,0.73333335,0.6688144,0.7366667,0.6688144,0.74,0.6688144,0.74333334,0.6688144,0.74666667,0.6688144,0.75,0.6688144,0.75333333,0.6688144,0.75666666,0.6688144,0.76,0.6688144,0.7633333,0.6688144,0.76666665,0.6688144,0.77,0.6688144,0.7733333,0.6688144,0.77666664,0.6688144,0.78,0.6688144,0.78333336,0.6688144,0.7866667,0.6688144,0.79,0.6688144,0.79333335,0.6688144,0.7966667,0.6688144,0.8,0.6688144,0.80333334,0.6688144,0.8066667,0.6688144,0.81,0.6688144,0.81333333,0.6688144,0.81666666,0.6688144,0.82,0.6688144,0.8233333,0.6688144,0.82666665,0.6688144,0.83,0.6688144,0.8333333,0.6688144,0.83666664,0.6688144,0.84,0.6688144,0.8433333,0.6688144,0.8466667,0.6688144,0.85,0.6688144,0.85333335,0.6688144,0.8566667,0.6688144,0.86,0.6688144,0.86333334,0.6688144,0.8666667,0.6688144,0.87,0.6688144,0.87333333,0.6688144,0.87666667,0.6688144,0.88,0.6688144,0.8833333,0.6688144,0.88666666,0.6688144,0.89,0.6688144,0.8933333,0.6688144,0.89666665,0.6688144,0.9,0.6688144,0.9033333,0.6688144,0.9066667,0.6688144,0.91,0.6688144,0.91333336,0.6688144,0.9166667,0.6688144,0.06,0.6713917,0.06333333,0.6713917,0.06666667,0.6713917,0.07,0.6713917,0.07333333,0.6713917,0.07666667,0.6713917,0.08,0.6713917,0.083333336,0.6713917,0.086666666,0.6713917,0.09,0.6713917,0.096666664,0.6713917,0.1,0.6713917,0.10333333,0.6713917,0.10666667,0.6713917,0.11,0.6713917,0.11333334,0.6713917,0.11666667,0.6713917,0.12,0.6713917,0.123333335,0.6713917,0.12666667,0.6713917,0.13,0.6713917,0.13333334,0.6713917,0.13666667,0.6713917,0.14,0.6713917,0.14333333,0.6713917,0.14666666,0.6713917,0.15,0.6713917,0.15333334,0.6713917,0.15666667,0.6713917,0.16,0.6713917,0.16333333,0.6713917,0.16666667,0.6713917,0.17,0.6713917,0.17333333,0.6713917,0.17666666,0.6713917,0.18,0.6713917,0.18333334,0.6713917,0.21333334,0.6713917,0.21666667,0.6713917,0.22,0.6713917,0.22333333,0.6713917,0.22666667,0.6713917,0.23,0.6713917,0.23333333,0.6713917,0.23666666,0.6713917,0.24,0.6713917,0.24333334,0.6713917,0.24666667,0.6713917,0.25,0.6713917,0.25333333,0.6713917,0.25666666,0.6713917,0.26,0.6713917,0.26333332,0.6713917,0.26666668,0.6713917,0.27,0.6713917,0.29666665,0.6713917,0.3,0.6713917,0.30333334,0.6713917,0.30666667,0.6713917,0.31,0.6713917,0.31333333,0.6713917,0.31666666,0.6713917,0.32,0.6713917,0.32333332,0.6713917,0.32666665,0.6713917,0.33,0.6713917,0.33333334,0.6713917,0.33666667,0.6713917,0.34,0.6713917,0.34333333,0.6713917,0.34666666,0.6713917,0.35,0.6713917,0.36666667,0.6713917,0.37,0.6713917,0.37333333,0.6713917,0.37666667,0.6713917,0.38,0.6713917,0.38333333,0.6713917,0.38666666,0.6713917,0.39,0.6713917,0.39333335,0.6713917,0.39666668,0.6713917,0.4,0.6713917,0.40333334,0.6713917,0.40666667,0.6713917,0.41,0.6713917,0.41333333,0.6713917,0.41666666,0.6713917,0.42,0.6713917,0.42333335,0.6713917,0.43333334,0.6713917,0.43666667,0.6713917,0.44,0.6713917,0.44333333,0.6713917,0.44666666,0.6713917,0.45,0.6713917,0.45333335,0.6713917,0.45666668,0.6713917,0.46,0.6713917,0.46333334,0.6713917,0.46666667,0.6713917,0.47,0.6713917,0.55,0.6713917,0.55333334,0.6713917,0.5566667,0.6713917,0.56,0.6713917,0.5733333,0.6713917,0.57666665,0.6713917,0.58,0.6713917,0.5833333,0.6713917,0.6,0.6713917,0.6066667,0.6713917,0.61,0.6713917,0.61333334,0.6713917,0.6166667,0.6713917,0.62,0.6713917,0.62333333,0.6713917,0.62666667,0.6713917,0.63,0.6713917,0.6333333,0.6713917,0.63666666,0.6713917,0.64,0.6713917,0.6433333,0.6713917,0.64666665,0.6713917,0.65,0.6713917,0.67,0.6713917,0.67333335,0.6713917,0.6766667,0.6713917,0.68,0.6713917,0.68333334,0.6713917,0.68666667,0.6713917,0.69,0.6713917,0.6933333,0.6713917,0.69666666,0.6713917,0.7,0.6713917,0.7033333,0.6713917,0.70666665,0.6713917,0.71,0.6713917,0.7133333,0.6713917,0.71666664,0.6713917,0.72,0.6713917,0.72333336,0.6713917,0.7266667,0.6713917,0.73,0.6713917,0.73333335,0.6713917,0.7366667,0.6713917,0.74,0.6713917,0.74333334,0.6713917,0.74666667,0.6713917,0.75,0.6713917,0.75333333,0.6713917,0.75666666,0.6713917,0.76,0.6713917,0.7633333,0.6713917,0.76666665,0.6713917,0.77,0.6713917,0.7733333,0.6713917,0.77666664,0.6713917,0.78,0.6713917,0.78333336,0.6713917,0.7866667,0.6713917,0.79,0.6713917,0.79333335,0.6713917,0.7966667,0.6713917,0.8,0.6713917,0.80333334,0.6713917,0.8066667,0.6713917,0.81,0.6713917,0.81333333,0.6713917,0.81666666,0.6713917,0.82,0.6713917,0.8233333,0.6713917,0.82666665,0.6713917,0.83,0.6713917,0.8333333,0.6713917,0.83666664,0.6713917,0.84,0.6713917,0.8433333,0.6713917,0.8466667,0.6713917,0.85,0.6713917,0.85333335,0.6713917,0.8566667,0.6713917,0.86,0.6713917,0.86333334,0.6713917,0.8666667,0.6713917,0.87,0.6713917,0.87333333,0.6713917,0.87666667,0.6713917,0.88,0.6713917,0.8833333,0.6713917,0.88666666,0.6713917,0.89,0.6713917,0.8933333,0.6713917,0.89666665,0.6713917,0.9,0.6713917,0.9033333,0.6713917,0.9066667,0.6713917,0.91,0.6713917,0.91333336,0.6713917,0.9166667,0.6713917,0.92,0.6713917,0.92333335,0.6713917,0.06,0.6739691,0.06333333,0.6739691,0.06666667,0.6739691,0.07,0.6739691,0.07333333,0.6739691,0.07666667,0.6739691,0.08,0.6739691,0.083333336,0.6739691,0.086666666,0.6739691,0.093333334,0.6739691,0.096666664,0.6739691,0.1,0.6739691,0.10333333,0.6739691,0.10666667,0.6739691,0.11,0.6739691,0.11333334,0.6739691,0.11666667,0.6739691,0.12,0.6739691,0.123333335,0.6739691,0.12666667,0.6739691,0.13,0.6739691,0.13333334,0.6739691,0.13666667,0.6739691,0.14,0.6739691,0.14333333,0.6739691,0.14666666,0.6739691,0.15,0.6739691,0.15333334,0.6739691,0.15666667,0.6739691,0.16,0.6739691,0.16333333,0.6739691,0.16666667,0.6739691,0.17,0.6739691,0.17333333,0.6739691,0.17666666,0.6739691,0.18,0.6739691,0.18333334,0.6739691,0.21333334,0.6739691,0.21666667,0.6739691,0.22,0.6739691,0.22333333,0.6739691,0.22666667,0.6739691,0.23,0.6739691,0.23333333,0.6739691,0.23666666,0.6739691,0.24,0.6739691,0.24333334,0.6739691,0.24666667,0.6739691,0.25,0.6739691,0.25333333,0.6739691,0.25666666,0.6739691,0.26,0.6739691,0.26333332,0.6739691,0.26666668,0.6739691,0.27,0.6739691,0.27333334,0.6739691,0.27666667,0.6739691,0.28,0.6739691,0.28333333,0.6739691,0.29,0.6739691,0.29333332,0.6739691,0.29666665,0.6739691,0.3,0.6739691,0.30333334,0.6739691,0.30666667,0.6739691,0.31,0.6739691,0.31333333,0.6739691,0.31666666,0.6739691,0.32,0.6739691,0.32333332,0.6739691,0.32666665,0.6739691,0.33,0.6739691,0.33333334,0.6739691,0.33666667,0.6739691,0.34,0.6739691,0.34333333,0.6739691,0.34666666,0.6739691,0.35,0.6739691,0.36666667,0.6739691,0.37,0.6739691,0.37333333,0.6739691,0.37666667,0.6739691,0.38,0.6739691,0.38333333,0.6739691,0.38666666,0.6739691,0.39,0.6739691,0.39333335,0.6739691,0.39666668,0.6739691,0.4,0.6739691,0.40333334,0.6739691,0.40666667,0.6739691,0.41,0.6739691,0.41333333,0.6739691,0.41666666,0.6739691,0.42,0.6739691,0.42333335,0.6739691,0.42666668,0.6739691,0.43333334,0.6739691,0.43666667,0.6739691,0.44,0.6739691,0.44333333,0.6739691,0.44666666,0.6739691,0.45,0.6739691,0.45333335,0.6739691,0.45666668,0.6739691,0.46,0.6739691,0.46333334,0.6739691,0.46666667,0.6739691,0.47,0.6739691,0.47333333,0.6739691,0.47666666,0.6739691,0.48,0.6739691,0.48333332,0.6739691,0.48666668,0.6739691,0.49,0.6739691,0.49333334,0.6739691,0.49666667,0.6739691,0.5,0.6739691,0.50333333,0.6739691,0.50666666,0.6739691,0.51,0.6739691,0.5133333,0.6739691,0.51666665,0.6739691,0.52,0.6739691,0.5233333,0.6739691,0.52666664,0.6739691,0.53,0.6739691,0.53333336,0.6739691,0.5366667,0.6739691,0.54,0.6739691,0.55,0.6739691,0.55333334,0.6739691,0.5566667,0.6739691,0.56,0.6739691,0.5733333,0.6739691,0.57666665,0.6739691,0.58,0.6739691,0.5833333,0.6739691,0.59,0.6739691,0.5933333,0.6739691,0.5966667,0.6739691,0.6,0.6739691,0.60333335,0.6739691,0.6066667,0.6739691,0.61,0.6739691,0.61333334,0.6739691,0.6166667,0.6739691,0.62,0.6739691,0.62333333,0.6739691,0.62666667,0.6739691,0.63,0.6739691,0.6333333,0.6739691,0.63666666,0.6739691,0.64,0.6739691,0.6433333,0.6739691,0.64666665,0.6739691,0.65,0.6739691,0.6666667,0.6739691,0.67,0.6739691,0.67333335,0.6739691,0.6766667,0.6739691,0.68,0.6739691,0.68333334,0.6739691,0.68666667,0.6739691,0.69,0.6739691,0.6933333,0.6739691,0.69666666,0.6739691,0.7,0.6739691,0.7033333,0.6739691,0.70666665,0.6739691,0.71,0.6739691,0.7133333,0.6739691,0.71666664,0.6739691,0.72,0.6739691,0.72333336,0.6739691,0.7266667,0.6739691,0.73,0.6739691,0.73333335,0.6739691,0.7366667,0.6739691,0.74,0.6739691,0.74333334,0.6739691,0.74666667,0.6739691,0.75,0.6739691,0.75333333,0.6739691,0.75666666,0.6739691,0.76,0.6739691,0.7633333,0.6739691,0.76666665,0.6739691,0.77,0.6739691,0.7733333,0.6739691,0.77666664,0.6739691,0.78,0.6739691,0.78333336,0.6739691,0.7866667,0.6739691,0.79,0.6739691,0.79333335,0.6739691,0.7966667,0.6739691,0.8,0.6739691,0.80333334,0.6739691,0.8066667,0.6739691,0.81,0.6739691,0.81333333,0.6739691,0.81666666,0.6739691,0.82,0.6739691,0.8233333,0.6739691,0.82666665,0.6739691,0.83,0.6739691,0.8333333,0.6739691,0.83666664,0.6739691,0.84,0.6739691,0.8433333,0.6739691,0.8466667,0.6739691,0.85,0.6739691,0.85333335,0.6739691,0.8566667,0.6739691,0.86,0.6739691,0.86333334,0.6739691,0.8666667,0.6739691,0.87,0.6739691,0.87333333,0.6739691,0.87666667,0.6739691,0.88,0.6739691,0.8833333,0.6739691,0.88666666,0.6739691,0.89,0.6739691,0.8933333,0.6739691,0.89666665,0.6739691,0.9,0.6739691,0.9033333,0.6739691,0.9066667,0.6739691,0.91,0.6739691,0.91333336,0.6739691,0.9166667,0.6739691,0.92,0.6739691,0.92333335,0.6739691,0.9266667,0.6739691,0.05666667,0.6765464,0.06,0.6765464,0.06333333,0.6765464,0.06666667,0.6765464,0.07,0.6765464,0.07333333,0.6765464,0.07666667,0.6765464,0.08,0.6765464,0.083333336,0.6765464,0.086666666,0.6765464,0.096666664,0.6765464,0.1,0.6765464,0.10333333,0.6765464,0.10666667,0.6765464,0.11,0.6765464,0.11333334,0.6765464,0.11666667,0.6765464,0.12,0.6765464,0.123333335,0.6765464,0.12666667,0.6765464,0.13,0.6765464,0.13333334,0.6765464,0.13666667,0.6765464,0.14,0.6765464,0.14333333,0.6765464,0.14666666,0.6765464,0.15,0.6765464,0.15333334,0.6765464,0.15666667,0.6765464,0.16,0.6765464,0.16333333,0.6765464,0.16666667,0.6765464,0.17,0.6765464,0.17333333,0.6765464,0.17666666,0.6765464,0.18,0.6765464,0.18333334,0.6765464,0.18666667,0.6765464,0.20333333,0.6765464,0.21666667,0.6765464,0.22,0.6765464,0.22333333,0.6765464,0.22666667,0.6765464,0.23,0.6765464,0.23333333,0.6765464,0.23666666,0.6765464,0.24,0.6765464,0.24333334,0.6765464,0.24666667,0.6765464,0.25,0.6765464,0.25333333,0.6765464,0.25666666,0.6765464,0.26,0.6765464,0.26333332,0.6765464,0.26666668,0.6765464,0.27,0.6765464,0.27333334,0.6765464,0.27666667,0.6765464,0.28,0.6765464,0.28333333,0.6765464,0.28666666,0.6765464,0.29,0.6765464,0.29333332,0.6765464,0.29666665,0.6765464,0.3,0.6765464,0.30333334,0.6765464,0.30666667,0.6765464,0.31,0.6765464,0.31333333,0.6765464,0.31666666,0.6765464,0.32,0.6765464,0.32333332,0.6765464,0.32666665,0.6765464,0.33,0.6765464,0.33333334,0.6765464,0.33666667,0.6765464,0.34,0.6765464,0.34333333,0.6765464,0.34666666,0.6765464,0.35,0.6765464,0.36666667,0.6765464,0.37,0.6765464,0.37333333,0.6765464,0.37666667,0.6765464,0.38,0.6765464,0.38333333,0.6765464,0.38666666,0.6765464,0.39,0.6765464,0.39333335,0.6765464,0.39666668,0.6765464,0.4,0.6765464,0.40333334,0.6765464,0.40666667,0.6765464,0.41,0.6765464,0.41333333,0.6765464,0.41666666,0.6765464,0.42,0.6765464,0.42333335,0.6765464,0.42666668,0.6765464,0.43666667,0.6765464,0.44,0.6765464,0.44333333,0.6765464,0.44666666,0.6765464,0.45,0.6765464,0.45333335,0.6765464,0.45666668,0.6765464,0.46,0.6765464,0.46333334,0.6765464,0.46666667,0.6765464,0.47,0.6765464,0.47333333,0.6765464,0.47666666,0.6765464,0.48,0.6765464,0.48333332,0.6765464,0.48666668,0.6765464,0.49,0.6765464,0.49333334,0.6765464,0.49666667,0.6765464,0.5,0.6765464,0.50333333,0.6765464,0.50666666,0.6765464,0.51,0.6765464,0.5133333,0.6765464,0.51666665,0.6765464,0.52,0.6765464,0.5233333,0.6765464,0.52666664,0.6765464,0.53,0.6765464,0.53333336,0.6765464,0.5366667,0.6765464,0.54,0.6765464,0.54333335,0.6765464,0.55333334,0.6765464,0.5566667,0.6765464,0.56,0.6765464,0.56333333,0.6765464,0.56666666,0.6765464,0.57,0.6765464,0.5733333,0.6765464,0.57666665,0.6765464,0.58,0.6765464,0.58666664,0.6765464,0.59,0.6765464,0.5933333,0.6765464,0.5966667,0.6765464,0.6,0.6765464,0.60333335,0.6765464,0.6066667,0.6765464,0.61,0.6765464,0.61333334,0.6765464,0.6166667,0.6765464,0.62,0.6765464,0.62333333,0.6765464,0.62666667,0.6765464,0.63,0.6765464,0.6333333,0.6765464,0.63666666,0.6765464,0.64,0.6765464,0.6433333,0.6765464,0.64666665,0.6765464,0.65,0.6765464,0.66333336,0.6765464,0.6666667,0.6765464,0.67,0.6765464,0.67333335,0.6765464,0.6766667,0.6765464,0.68,0.6765464,0.68333334,0.6765464,0.68666667,0.6765464,0.69,0.6765464,0.6933333,0.6765464,0.69666666,0.6765464,0.7,0.6765464,0.7033333,0.6765464,0.70666665,0.6765464,0.71,0.6765464,0.7133333,0.6765464,0.71666664,0.6765464,0.72,0.6765464,0.72333336,0.6765464,0.7266667,0.6765464,0.73,0.6765464,0.73333335,0.6765464,0.7366667,0.6765464,0.74,0.6765464,0.74333334,0.6765464,0.74666667,0.6765464,0.75,0.6765464,0.75333333,0.6765464,0.75666666,0.6765464,0.76,0.6765464,0.7633333,0.6765464,0.76666665,0.6765464,0.77,0.6765464,0.7733333,0.6765464,0.77666664,0.6765464,0.78,0.6765464,0.78333336,0.6765464,0.7866667,0.6765464,0.79,0.6765464,0.79333335,0.6765464,0.7966667,0.6765464,0.8,0.6765464,0.80333334,0.6765464,0.8066667,0.6765464,0.81,0.6765464,0.81333333,0.6765464,0.81666666,0.6765464,0.82,0.6765464,0.8233333,0.6765464,0.82666665,0.6765464,0.83,0.6765464,0.8333333,0.6765464,0.83666664,0.6765464,0.84,0.6765464,0.8433333,0.6765464,0.8466667,0.6765464,0.85,0.6765464,0.85333335,0.6765464,0.8566667,0.6765464,0.86,0.6765464,0.86333334,0.6765464,0.8666667,0.6765464,0.87,0.6765464,0.87333333,0.6765464,0.87666667,0.6765464,0.88,0.6765464,0.8833333,0.6765464,0.88666666,0.6765464,0.89,0.6765464,0.8933333,0.6765464,0.89666665,0.6765464,0.9,0.6765464,0.9033333,0.6765464,0.9066667,0.6765464,0.91,0.6765464,0.91333336,0.6765464,0.9166667,0.6765464,0.92,0.6765464,0.92333335,0.6765464,0.9266667,0.6765464,0.93,0.6765464,0.053333335,0.6791237,0.05666667,0.6791237,0.06,0.6791237,0.06333333,0.6791237,0.06666667,0.6791237,0.07,0.6791237,0.07333333,0.6791237,0.07666667,0.6791237,0.08,0.6791237,0.083333336,0.6791237,0.086666666,0.6791237,0.096666664,0.6791237,0.1,0.6791237,0.10333333,0.6791237,0.10666667,0.6791237,0.11,0.6791237,0.11333334,0.6791237,0.11666667,0.6791237,0.12,0.6791237,0.123333335,0.6791237,0.12666667,0.6791237,0.13,0.6791237,0.13333334,0.6791237,0.13666667,0.6791237,0.14,0.6791237,0.14333333,0.6791237,0.14666666,0.6791237,0.15,0.6791237,0.15333334,0.6791237,0.15666667,0.6791237,0.16,0.6791237,0.16333333,0.6791237,0.16666667,0.6791237,0.17,0.6791237,0.17333333,0.6791237,0.17666666,0.6791237,0.18,0.6791237,0.18333334,0.6791237,0.18666667,0.6791237,0.2,0.6791237,0.20333333,0.6791237,0.22,0.6791237,0.22333333,0.6791237,0.22666667,0.6791237,0.23,0.6791237,0.23333333,0.6791237,0.23666666,0.6791237,0.24,0.6791237,0.24333334,0.6791237,0.24666667,0.6791237,0.25,0.6791237,0.25333333,0.6791237,0.25666666,0.6791237,0.26,0.6791237,0.26333332,0.6791237,0.26666668,0.6791237,0.27,0.6791237,0.27333334,0.6791237,0.27666667,0.6791237,0.28,0.6791237,0.28333333,0.6791237,0.28666666,0.6791237,0.29,0.6791237,0.29333332,0.6791237,0.29666665,0.6791237,0.3,0.6791237,0.30333334,0.6791237,0.30666667,0.6791237,0.31,0.6791237,0.31333333,0.6791237,0.31666666,0.6791237,0.32,0.6791237,0.32333332,0.6791237,0.32666665,0.6791237,0.33,0.6791237,0.33333334,0.6791237,0.33666667,0.6791237,0.34,0.6791237,0.34333333,0.6791237,0.34666666,0.6791237,0.35,0.6791237,0.36666667,0.6791237,0.37,0.6791237,0.37333333,0.6791237,0.37666667,0.6791237,0.38,0.6791237,0.38333333,0.6791237,0.38666666,0.6791237,0.39,0.6791237,0.39333335,0.6791237,0.39666668,0.6791237,0.4,0.6791237,0.40333334,0.6791237,0.40666667,0.6791237,0.41,0.6791237,0.41333333,0.6791237,0.41666666,0.6791237,0.42,0.6791237,0.42333335,0.6791237,0.42666668,0.6791237,0.43,0.6791237,0.44,0.6791237,0.44333333,0.6791237,0.44666666,0.6791237,0.45,0.6791237,0.45333335,0.6791237,0.45666668,0.6791237,0.46,0.6791237,0.46333334,0.6791237,0.46666667,0.6791237,0.47,0.6791237,0.47333333,0.6791237,0.47666666,0.6791237,0.48,0.6791237,0.48333332,0.6791237,0.48666668,0.6791237,0.49,0.6791237,0.49333334,0.6791237,0.49666667,0.6791237,0.5,0.6791237,0.50333333,0.6791237,0.50666666,0.6791237,0.51,0.6791237,0.5133333,0.6791237,0.51666665,0.6791237,0.52,0.6791237,0.5233333,0.6791237,0.52666664,0.6791237,0.53,0.6791237,0.53333336,0.6791237,0.5366667,0.6791237,0.54,0.6791237,0.54333335,0.6791237,0.5466667,0.6791237,0.5566667,0.6791237,0.56,0.6791237,0.56333333,0.6791237,0.56666666,0.6791237,0.57,0.6791237,0.5733333,0.6791237,0.57666665,0.6791237,0.58,0.6791237,0.58666664,0.6791237,0.59,0.6791237,0.5933333,0.6791237,0.5966667,0.6791237,0.6,0.6791237,0.60333335,0.6791237,0.6066667,0.6791237,0.61,0.6791237,0.61333334,0.6791237,0.6166667,0.6791237,0.62,0.6791237,0.62333333,0.6791237,0.62666667,0.6791237,0.63,0.6791237,0.6333333,0.6791237,0.63666666,0.6791237,0.64,0.6791237,0.6433333,0.6791237,0.64666665,0.6791237,0.66,0.6791237,0.66333336,0.6791237,0.6666667,0.6791237,0.67,0.6791237,0.67333335,0.6791237,0.6766667,0.6791237,0.68,0.6791237,0.68333334,0.6791237,0.68666667,0.6791237,0.69,0.6791237,0.6933333,0.6791237,0.69666666,0.6791237,0.7,0.6791237,0.7033333,0.6791237,0.70666665,0.6791237,0.71,0.6791237,0.7133333,0.6791237,0.71666664,0.6791237,0.72,0.6791237,0.72333336,0.6791237,0.7266667,0.6791237,0.73,0.6791237,0.73333335,0.6791237,0.7366667,0.6791237,0.74,0.6791237,0.74333334,0.6791237,0.74666667,0.6791237,0.75,0.6791237,0.75333333,0.6791237,0.75666666,0.6791237,0.76,0.6791237,0.7633333,0.6791237,0.76666665,0.6791237,0.77,0.6791237,0.7733333,0.6791237,0.77666664,0.6791237,0.78,0.6791237,0.78333336,0.6791237,0.7866667,0.6791237,0.79,0.6791237,0.79333335,0.6791237,0.7966667,0.6791237,0.8,0.6791237,0.80333334,0.6791237,0.8066667,0.6791237,0.81,0.6791237,0.81333333,0.6791237,0.81666666,0.6791237,0.82,0.6791237,0.8233333,0.6791237,0.82666665,0.6791237,0.83,0.6791237,0.8333333,0.6791237,0.83666664,0.6791237,0.84,0.6791237,0.8433333,0.6791237,0.8466667,0.6791237,0.85,0.6791237,0.85333335,0.6791237,0.8566667,0.6791237,0.86,0.6791237,0.86333334,0.6791237,0.8666667,0.6791237,0.87,0.6791237,0.87333333,0.6791237,0.87666667,0.6791237,0.88,0.6791237,0.8833333,0.6791237,0.88666666,0.6791237,0.89,0.6791237,0.8933333,0.6791237,0.89666665,0.6791237,0.9,0.6791237,0.9033333,0.6791237,0.9066667,0.6791237,0.91,0.6791237,0.91333336,0.6791237,0.9166667,0.6791237,0.92,0.6791237,0.92333335,0.6791237,0.9266667,0.6791237,0.93,0.6791237,0.053333335,0.681701,0.05666667,0.681701,0.06,0.681701,0.06333333,0.681701,0.06666667,0.681701,0.07,0.681701,0.07333333,0.681701,0.07666667,0.681701,0.08,0.681701,0.083333336,0.681701,0.086666666,0.681701,0.1,0.681701,0.10333333,0.681701,0.10666667,0.681701,0.11,0.681701,0.11333334,0.681701,0.11666667,0.681701,0.12,0.681701,0.123333335,0.681701,0.12666667,0.681701,0.13,0.681701,0.13333334,0.681701,0.13666667,0.681701,0.14,0.681701,0.14333333,0.681701,0.14666666,0.681701,0.15,0.681701,0.15333334,0.681701,0.15666667,0.681701,0.16,0.681701,0.16333333,0.681701,0.16666667,0.681701,0.17,0.681701,0.17333333,0.681701,0.17666666,0.681701,0.18,0.681701,0.18333334,0.681701,0.18666667,0.681701,0.19,0.681701,0.19666667,0.681701,0.2,0.681701,0.20333333,0.681701,0.22,0.681701,0.22333333,0.681701,0.22666667,0.681701,0.23,0.681701,0.23333333,0.681701,0.23666666,0.681701,0.24,0.681701,0.24333334,0.681701,0.24666667,0.681701,0.25,0.681701,0.25333333,0.681701,0.25666666,0.681701,0.26,0.681701,0.26333332,0.681701,0.26666668,0.681701,0.27,0.681701,0.27333334,0.681701,0.27666667,0.681701,0.28,0.681701,0.28333333,0.681701,0.28666666,0.681701,0.29,0.681701,0.29333332,0.681701,0.29666665,0.681701,0.3,0.681701,0.30333334,0.681701,0.30666667,0.681701,0.31,0.681701,0.31333333,0.681701,0.31666666,0.681701,0.32,0.681701,0.32333332,0.681701,0.32666665,0.681701,0.33,0.681701,0.33333334,0.681701,0.33666667,0.681701,0.34,0.681701,0.34333333,0.681701,0.34666666,0.681701,0.35,0.681701,0.36666667,0.681701,0.37,0.681701,0.37333333,0.681701,0.37666667,0.681701,0.38,0.681701,0.38333333,0.681701,0.38666666,0.681701,0.39,0.681701,0.39333335,0.681701,0.39666668,0.681701,0.4,0.681701,0.40333334,0.681701,0.40666667,0.681701,0.41,0.681701,0.41333333,0.681701,0.41666666,0.681701,0.42,0.681701,0.42333335,0.681701,0.42666668,0.681701,0.43,0.681701,0.43333334,0.681701,0.44666666,0.681701,0.45,0.681701,0.45333335,0.681701,0.45666668,0.681701,0.46,0.681701,0.46333334,0.681701,0.46666667,0.681701,0.47,0.681701,0.47333333,0.681701,0.47666666,0.681701,0.48,0.681701,0.48333332,0.681701,0.48666668,0.681701,0.49,0.681701,0.49333334,0.681701,0.49666667,0.681701,0.5,0.681701,0.50333333,0.681701,0.50666666,0.681701,0.51,0.681701,0.5133333,0.681701,0.51666665,0.681701,0.52,0.681701,0.5233333,0.681701,0.52666664,0.681701,0.53,0.681701,0.53333336,0.681701,0.5366667,0.681701,0.54,0.681701,0.54333335,0.681701,0.5466667,0.681701,0.56,0.681701,0.56333333,0.681701,0.56666666,0.681701,0.57,0.681701,0.5733333,0.681701,0.57666665,0.681701,0.5833333,0.681701,0.58666664,0.681701,0.59,0.681701,0.5933333,0.681701,0.5966667,0.681701,0.6,0.681701,0.60333335,0.681701,0.6066667,0.681701,0.61,0.681701,0.61333334,0.681701,0.6166667,0.681701,0.62,0.681701,0.62333333,0.681701,0.62666667,0.681701,0.63,0.681701,0.6333333,0.681701,0.63666666,0.681701,0.64,0.681701,0.6433333,0.681701,0.64666665,0.681701,0.6566667,0.681701,0.66,0.681701,0.66333336,0.681701,0.6666667,0.681701,0.67,0.681701,0.67333335,0.681701,0.6766667,0.681701,0.68,0.681701,0.68333334,0.681701,0.68666667,0.681701,0.69,0.681701,0.6933333,0.681701,0.69666666,0.681701,0.7,0.681701,0.7033333,0.681701,0.70666665,0.681701,0.71,0.681701,0.7133333,0.681701,0.71666664,0.681701,0.72,0.681701,0.72333336,0.681701,0.7266667,0.681701,0.73,0.681701,0.73333335,0.681701,0.7366667,0.681701,0.74,0.681701,0.74333334,0.681701,0.74666667,0.681701,0.75,0.681701,0.75333333,0.681701,0.75666666,0.681701,0.76,0.681701,0.7633333,0.681701,0.76666665,0.681701,0.77,0.681701,0.7733333,0.681701,0.77666664,0.681701,0.78,0.681701,0.78333336,0.681701,0.7866667,0.681701,0.79,0.681701,0.79333335,0.681701,0.7966667,0.681701,0.8,0.681701,0.80333334,0.681701,0.8066667,0.681701,0.81,0.681701,0.81333333,0.681701,0.81666666,0.681701,0.82,0.681701,0.8233333,0.681701,0.82666665,0.681701,0.83,0.681701,0.8333333,0.681701,0.83666664,0.681701,0.84,0.681701,0.8433333,0.681701,0.8466667,0.681701,0.85,0.681701,0.85333335,0.681701,0.8566667,0.681701,0.86,0.681701,0.86333334,0.681701,0.8666667,0.681701,0.87,0.681701,0.87333333,0.681701,0.87666667,0.681701,0.88,0.681701,0.8833333,0.681701,0.88666666,0.681701,0.89,0.681701,0.8933333,0.681701,0.89666665,0.681701,0.9,0.681701,0.9033333,0.681701,0.9066667,0.681701,0.91,0.681701,0.91333336,0.681701,0.9166667,0.681701,0.92,0.681701,0.92333335,0.681701,0.9266667,0.681701,0.93,0.681701,0.93333334,0.681701,0.05,0.68427837,0.053333335,0.68427837,0.05666667,0.68427837,0.06,0.68427837,0.06333333,0.68427837,0.06666667,0.68427837,0.07,0.68427837,0.07333333,0.68427837,0.07666667,0.68427837,0.08,0.68427837,0.083333336,0.68427837,0.10333333,0.68427837,0.10666667,0.68427837,0.11,0.68427837,0.11333334,0.68427837,0.11666667,0.68427837,0.12,0.68427837,0.123333335,0.68427837,0.12666667,0.68427837,0.13,0.68427837,0.13333334,0.68427837,0.13666667,0.68427837,0.14,0.68427837,0.14333333,0.68427837,0.14666666,0.68427837,0.15,0.68427837,0.15333334,0.68427837,0.15666667,0.68427837,0.16,0.68427837,0.16333333,0.68427837,0.16666667,0.68427837,0.17,0.68427837,0.17333333,0.68427837,0.17666666,0.68427837,0.18,0.68427837,0.18333334,0.68427837,0.18666667,0.68427837,0.19,0.68427837,0.19333333,0.68427837,0.19666667,0.68427837,0.2,0.68427837,0.20333333,0.68427837,0.21333334,0.68427837,0.21666667,0.68427837,0.22,0.68427837,0.22333333,0.68427837,0.22666667,0.68427837,0.23,0.68427837,0.23333333,0.68427837,0.23666666,0.68427837,0.24,0.68427837,0.24333334,0.68427837,0.24666667,0.68427837,0.25,0.68427837,0.25333333,0.68427837,0.25666666,0.68427837,0.26,0.68427837,0.26333332,0.68427837,0.26666668,0.68427837,0.27,0.68427837,0.27333334,0.68427837,0.27666667,0.68427837,0.28,0.68427837,0.28333333,0.68427837,0.28666666,0.68427837,0.29,0.68427837,0.29333332,0.68427837,0.29666665,0.68427837,0.3,0.68427837,0.30333334,0.68427837,0.30666667,0.68427837,0.31,0.68427837,0.31333333,0.68427837,0.31666666,0.68427837,0.32,0.68427837,0.32333332,0.68427837,0.32666665,0.68427837,0.33,0.68427837,0.33333334,0.68427837,0.33666667,0.68427837,0.34,0.68427837,0.34333333,0.68427837,0.34666666,0.68427837,0.36666667,0.68427837,0.37,0.68427837,0.37333333,0.68427837,0.37666667,0.68427837,0.38,0.68427837,0.38333333,0.68427837,0.38666666,0.68427837,0.39,0.68427837,0.39333335,0.68427837,0.39666668,0.68427837,0.4,0.68427837,0.40333334,0.68427837,0.40666667,0.68427837,0.41,0.68427837,0.41333333,0.68427837,0.41666666,0.68427837,0.42,0.68427837,0.42333335,0.68427837,0.42666668,0.68427837,0.43,0.68427837,0.43333334,0.68427837,0.43666667,0.68427837,0.44,0.68427837,0.45666668,0.68427837,0.46,0.68427837,0.46333334,0.68427837,0.46666667,0.68427837,0.47,0.68427837,0.47333333,0.68427837,0.47666666,0.68427837,0.48,0.68427837,0.48333332,0.68427837,0.48666668,0.68427837,0.49,0.68427837,0.49333334,0.68427837,0.49666667,0.68427837,0.5,0.68427837,0.50333333,0.68427837,0.50666666,0.68427837,0.51,0.68427837,0.5133333,0.68427837,0.51666665,0.68427837,0.52,0.68427837,0.5233333,0.68427837,0.52666664,0.68427837,0.53,0.68427837,0.53333336,0.68427837,0.5366667,0.68427837,0.54,0.68427837,0.54333335,0.68427837,0.5466667,0.68427837,0.55,0.68427837,0.56666666,0.68427837,0.57,0.68427837,0.5733333,0.68427837,0.58,0.68427837,0.5833333,0.68427837,0.58666664,0.68427837,0.59,0.68427837,0.5933333,0.68427837,0.5966667,0.68427837,0.6,0.68427837,0.60333335,0.68427837,0.6066667,0.68427837,0.61,0.68427837,0.61333334,0.68427837,0.6166667,0.68427837,0.62,0.68427837,0.62333333,0.68427837,0.62666667,0.68427837,0.63,0.68427837,0.6333333,0.68427837,0.63666666,0.68427837,0.64,0.68427837,0.6433333,0.68427837,0.6566667,0.68427837,0.66,0.68427837,0.66333336,0.68427837,0.6666667,0.68427837,0.67,0.68427837,0.67333335,0.68427837,0.6766667,0.68427837,0.68,0.68427837,0.68333334,0.68427837,0.68666667,0.68427837,0.69,0.68427837,0.6933333,0.68427837,0.69666666,0.68427837,0.7,0.68427837,0.7033333,0.68427837,0.70666665,0.68427837,0.71,0.68427837,0.7133333,0.68427837,0.71666664,0.68427837,0.72,0.68427837,0.72333336,0.68427837,0.7266667,0.68427837,0.73,0.68427837,0.73333335,0.68427837,0.7366667,0.68427837,0.74,0.68427837,0.74333334,0.68427837,0.74666667,0.68427837,0.75,0.68427837,0.75333333,0.68427837,0.75666666,0.68427837,0.76,0.68427837,0.7633333,0.68427837,0.76666665,0.68427837,0.77,0.68427837,0.7733333,0.68427837,0.77666664,0.68427837,0.78,0.68427837,0.78333336,0.68427837,0.7866667,0.68427837,0.79,0.68427837,0.79333335,0.68427837,0.7966667,0.68427837,0.8,0.68427837,0.80333334,0.68427837,0.8066667,0.68427837,0.81,0.68427837,0.81333333,0.68427837,0.81666666,0.68427837,0.82,0.68427837,0.8233333,0.68427837,0.82666665,0.68427837,0.83,0.68427837,0.8333333,0.68427837,0.83666664,0.68427837,0.84,0.68427837,0.8433333,0.68427837,0.8466667,0.68427837,0.85,0.68427837,0.85333335,0.68427837,0.8566667,0.68427837,0.86,0.68427837,0.86333334,0.68427837,0.8666667,0.68427837,0.87,0.68427837,0.87333333,0.68427837,0.87666667,0.68427837,0.88,0.68427837,0.8833333,0.68427837,0.88666666,0.68427837,0.89,0.68427837,0.8933333,0.68427837,0.89666665,0.68427837,0.9,0.68427837,0.9033333,0.68427837,0.9066667,0.68427837,0.91,0.68427837,0.91333336,0.68427837,0.9166667,0.68427837,0.92,0.68427837,0.92333335,0.68427837,0.9266667,0.68427837,0.93,0.68427837,0.93333334,0.68427837,0.05,0.6868557,0.053333335,0.6868557,0.05666667,0.6868557,0.06,0.6868557,0.06333333,0.6868557,0.06666667,0.6868557,0.07,0.6868557,0.07333333,0.6868557,0.07666667,0.6868557,0.08,0.6868557,0.083333336,0.6868557,0.086666666,0.6868557,0.123333335,0.6868557,0.12666667,0.6868557,0.13,0.6868557,0.13333334,0.6868557,0.13666667,0.6868557,0.14,0.6868557,0.14333333,0.6868557,0.14666666,0.6868557,0.15,0.6868557,0.15333334,0.6868557,0.15666667,0.6868557,0.16,0.6868557,0.16333333,0.6868557,0.16666667,0.6868557,0.17,0.6868557,0.17333333,0.6868557,0.17666666,0.6868557,0.18,0.6868557,0.18333334,0.6868557,0.18666667,0.6868557,0.19,0.6868557,0.19333333,0.6868557,0.19666667,0.6868557,0.2,0.6868557,0.20333333,0.6868557,0.20666666,0.6868557,0.21333334,0.6868557,0.21666667,0.6868557,0.22,0.6868557,0.22333333,0.6868557,0.22666667,0.6868557,0.23,0.6868557,0.23333333,0.6868557,0.23666666,0.6868557,0.24,0.6868557,0.24333334,0.6868557,0.24666667,0.6868557,0.25,0.6868557,0.25333333,0.6868557,0.25666666,0.6868557,0.26,0.6868557,0.26333332,0.6868557,0.26666668,0.6868557,0.27,0.6868557,0.27333334,0.6868557,0.27666667,0.6868557,0.28,0.6868557,0.28333333,0.6868557,0.28666666,0.6868557,0.29,0.6868557,0.29333332,0.6868557,0.29666665,0.6868557,0.3,0.6868557,0.30333334,0.6868557,0.30666667,0.6868557,0.31,0.6868557,0.31333333,0.6868557,0.31666666,0.6868557,0.32,0.6868557,0.32333332,0.6868557,0.32666665,0.6868557,0.33,0.6868557,0.33333334,0.6868557,0.33666667,0.6868557,0.34,0.6868557,0.34333333,0.6868557,0.34666666,0.6868557,0.36666667,0.6868557,0.37,0.6868557,0.37333333,0.6868557,0.37666667,0.6868557,0.38,0.6868557,0.38333333,0.6868557,0.38666666,0.6868557,0.39,0.6868557,0.39333335,0.6868557,0.39666668,0.6868557,0.4,0.6868557,0.40333334,0.6868557,0.40666667,0.6868557,0.41,0.6868557,0.41333333,0.6868557,0.41666666,0.6868557,0.42,0.6868557,0.42333335,0.6868557,0.42666668,0.6868557,0.43,0.6868557,0.43333334,0.6868557,0.43666667,0.6868557,0.44,0.6868557,0.44333333,0.6868557,0.44666666,0.6868557,0.45,0.6868557,0.45333335,0.6868557,0.45666668,0.6868557,0.46,0.6868557,0.46333334,0.6868557,0.46666667,0.6868557,0.47,0.6868557,0.47333333,0.6868557,0.47666666,0.6868557,0.48,0.6868557,0.48333332,0.6868557,0.48666668,0.6868557,0.49,0.6868557,0.49333334,0.6868557,0.49666667,0.6868557,0.5,0.6868557,0.50333333,0.6868557,0.50666666,0.6868557,0.51,0.6868557,0.5133333,0.6868557,0.51666665,0.6868557,0.52,0.6868557,0.5233333,0.6868557,0.52666664,0.6868557,0.53,0.6868557,0.53333336,0.6868557,0.5366667,0.6868557,0.54,0.6868557,0.54333335,0.6868557,0.5466667,0.6868557,0.55,0.6868557,0.55333334,0.6868557,0.5566667,0.6868557,0.57666665,0.6868557,0.58,0.6868557,0.5833333,0.6868557,0.58666664,0.6868557,0.59,0.6868557,0.5933333,0.6868557,0.5966667,0.6868557,0.6,0.6868557,0.60333335,0.6868557,0.6066667,0.6868557,0.61,0.6868557,0.61333334,0.6868557,0.6166667,0.6868557,0.62,0.6868557,0.62333333,0.6868557,0.62666667,0.6868557,0.63,0.6868557,0.6333333,0.6868557,0.63666666,0.6868557,0.6533333,0.6868557,0.6566667,0.6868557,0.66,0.6868557,0.66333336,0.6868557,0.6666667,0.6868557,0.67,0.6868557,0.67333335,0.6868557,0.6766667,0.6868557,0.68,0.6868557,0.68333334,0.6868557,0.68666667,0.6868557,0.69,0.6868557,0.6933333,0.6868557,0.69666666,0.6868557,0.7,0.6868557,0.7033333,0.6868557,0.70666665,0.6868557,0.71,0.6868557,0.7133333,0.6868557,0.71666664,0.6868557,0.72,0.6868557,0.72333336,0.6868557,0.7266667,0.6868557,0.73,0.6868557,0.73333335,0.6868557,0.7366667,0.6868557,0.74,0.6868557,0.74333334,0.6868557,0.74666667,0.6868557,0.75,0.6868557,0.75333333,0.6868557,0.75666666,0.6868557,0.76,0.6868557,0.7633333,0.6868557,0.76666665,0.6868557,0.77,0.6868557,0.7733333,0.6868557,0.77666664,0.6868557,0.78,0.6868557,0.78333336,0.6868557,0.7866667,0.6868557,0.79,0.6868557,0.79333335,0.6868557,0.7966667,0.6868557,0.8,0.6868557,0.80333334,0.6868557,0.8066667,0.6868557,0.81,0.6868557,0.81333333,0.6868557,0.81666666,0.6868557,0.82,0.6868557,0.8233333,0.6868557,0.82666665,0.6868557,0.83,0.6868557,0.8333333,0.6868557,0.83666664,0.6868557,0.84,0.6868557,0.8433333,0.6868557,0.8466667,0.6868557,0.85,0.6868557,0.85333335,0.6868557,0.8566667,0.6868557,0.86,0.6868557,0.86333334,0.6868557,0.8666667,0.6868557,0.87,0.6868557,0.87333333,0.6868557,0.87666667,0.6868557,0.88,0.6868557,0.8833333,0.6868557,0.88666666,0.6868557,0.89,0.6868557,0.8933333,0.6868557,0.89666665,0.6868557,0.9,0.6868557,0.9033333,0.6868557,0.9066667,0.6868557,0.91,0.6868557,0.91333336,0.6868557,0.9166667,0.6868557,0.92,0.6868557,0.92333335,0.6868557,0.9266667,0.6868557,0.93,0.6868557,0.93333334,0.6868557,0.05,0.689433,0.053333335,0.689433,0.05666667,0.689433,0.06,0.689433,0.06333333,0.689433,0.06666667,0.689433,0.07,0.689433,0.07333333,0.689433,0.07666667,0.689433,0.08,0.689433,0.083333336,0.689433,0.086666666,0.689433,0.09,0.689433,0.093333334,0.689433,0.11,0.689433,0.11333334,0.689433,0.11666667,0.689433,0.12,0.689433,0.123333335,0.689433,0.12666667,0.689433,0.13,0.689433,0.13333334,0.689433,0.13666667,0.689433,0.14,0.689433,0.14333333,0.689433,0.14666666,0.689433,0.15,0.689433,0.15333334,0.689433,0.15666667,0.689433,0.16,0.689433,0.16333333,0.689433,0.16666667,0.689433,0.17,0.689433,0.17333333,0.689433,0.17666666,0.689433,0.18,0.689433,0.18333334,0.689433,0.18666667,0.689433,0.19,0.689433,0.19333333,0.689433,0.19666667,0.689433,0.2,0.689433,0.20333333,0.689433,0.20666666,0.689433,0.21,0.689433,0.21333334,0.689433,0.21666667,0.689433,0.22,0.689433,0.22333333,0.689433,0.22666667,0.689433,0.23,0.689433,0.23333333,0.689433,0.23666666,0.689433,0.24,0.689433,0.24333334,0.689433,0.24666667,0.689433,0.25,0.689433,0.25333333,0.689433,0.25666666,0.689433,0.26,0.689433,0.26333332,0.689433,0.26666668,0.689433,0.27,0.689433,0.27333334,0.689433,0.27666667,0.689433,0.28,0.689433,0.28333333,0.689433,0.28666666,0.689433,0.29,0.689433,0.29333332,0.689433,0.29666665,0.689433,0.31333333,0.689433,0.31666666,0.689433,0.32,0.689433,0.32333332,0.689433,0.32666665,0.689433,0.33,0.689433,0.33333334,0.689433,0.33666667,0.689433,0.34,0.689433,0.34333333,0.689433,0.36666667,0.689433,0.37,0.689433,0.37333333,0.689433,0.37666667,0.689433,0.38,0.689433,0.38333333,0.689433,0.38666666,0.689433,0.39,0.689433,0.39333335,0.689433,0.39666668,0.689433,0.4,0.689433,0.40333334,0.689433,0.40666667,0.689433,0.41,0.689433,0.41333333,0.689433,0.41666666,0.689433,0.42,0.689433,0.42333335,0.689433,0.42666668,0.689433,0.43,0.689433,0.43333334,0.689433,0.43666667,0.689433,0.44,0.689433,0.44333333,0.689433,0.44666666,0.689433,0.45,0.689433,0.45333335,0.689433,0.45666668,0.689433,0.46,0.689433,0.46333334,0.689433,0.46666667,0.689433,0.47,0.689433,0.47333333,0.689433,0.47666666,0.689433,0.48,0.689433,0.48333332,0.689433,0.48666668,0.689433,0.49,0.689433,0.49333334,0.689433,0.49666667,0.689433,0.5,0.689433,0.50333333,0.689433,0.50666666,0.689433,0.51,0.689433,0.5133333,0.689433,0.51666665,0.689433,0.52,0.689433,0.5233333,0.689433,0.52666664,0.689433,0.53,0.689433,0.53333336,0.689433,0.5366667,0.689433,0.54,0.689433,0.54333335,0.689433,0.5466667,0.689433,0.55,0.689433,0.55333334,0.689433,0.5566667,0.689433,0.56,0.689433,0.56333333,0.689433,0.56666666,0.689433,0.57,0.689433,0.5733333,0.689433,0.57666665,0.689433,0.58,0.689433,0.5833333,0.689433,0.58666664,0.689433,0.59,0.689433,0.5933333,0.689433,0.5966667,0.689433,0.6,0.689433,0.60333335,0.689433,0.6066667,0.689433,0.61,0.689433,0.61333334,0.689433,0.6166667,0.689433,0.62,0.689433,0.62333333,0.689433,0.62666667,0.689433,0.6533333,0.689433,0.6566667,0.689433,0.66,0.689433,0.66333336,0.689433,0.6666667,0.689433,0.67,0.689433,0.67333335,0.689433,0.6766667,0.689433,0.68,0.689433,0.68333334,0.689433,0.68666667,0.689433,0.69,0.689433,0.6933333,0.689433,0.69666666,0.689433,0.7,0.689433,0.7033333,0.689433,0.70666665,0.689433,0.71,0.689433,0.7133333,0.689433,0.71666664,0.689433,0.72,0.689433,0.72333336,0.689433,0.7266667,0.689433,0.73,0.689433,0.73333335,0.689433,0.7366667,0.689433,0.74,0.689433,0.74333334,0.689433,0.74666667,0.689433,0.75,0.689433,0.75333333,0.689433,0.75666666,0.689433,0.76,0.689433,0.7633333,0.689433,0.76666665,0.689433,0.77,0.689433,0.7733333,0.689433,0.77666664,0.689433,0.78,0.689433,0.78333336,0.689433,0.7866667,0.689433,0.79,0.689433,0.79333335,0.689433,0.7966667,0.689433,0.8,0.689433,0.80333334,0.689433,0.8066667,0.689433,0.81,0.689433,0.81333333,0.689433,0.81666666,0.689433,0.82,0.689433,0.8233333,0.689433,0.82666665,0.689433,0.83,0.689433,0.8333333,0.689433,0.83666664,0.689433,0.84,0.689433,0.8433333,0.689433,0.8466667,0.689433,0.85,0.689433,0.85333335,0.689433,0.8566667,0.689433,0.86,0.689433,0.86333334,0.689433,0.8666667,0.689433,0.87,0.689433,0.87333333,0.689433,0.87666667,0.689433,0.88,0.689433,0.8833333,0.689433,0.88666666,0.689433,0.89,0.689433,0.8933333,0.689433,0.89666665,0.689433,0.9,0.689433,0.9033333,0.689433,0.9066667,0.689433,0.91,0.689433,0.91333336,0.689433,0.9166667,0.689433,0.92,0.689433,0.92333335,0.689433,0.9266667,0.689433,0.93,0.689433,0.93333334,0.689433,0.046666667,0.6920103,0.05,0.6920103,0.053333335,0.6920103,0.05666667,0.6920103,0.06,0.6920103,0.06333333,0.6920103,0.06666667,0.6920103,0.07,0.6920103,0.07333333,0.6920103,0.07666667,0.6920103,0.08,0.6920103,0.083333336,0.6920103,0.086666666,0.6920103,0.09,0.6920103,0.093333334,0.6920103,0.096666664,0.6920103,0.1,0.6920103,0.10333333,0.6920103,0.10666667,0.6920103,0.11,0.6920103,0.11333334,0.6920103,0.11666667,0.6920103,0.12,0.6920103,0.123333335,0.6920103,0.12666667,0.6920103,0.13,0.6920103,0.13333334,0.6920103,0.13666667,0.6920103,0.14,0.6920103,0.14333333,0.6920103,0.14666666,0.6920103,0.15,0.6920103,0.15333334,0.6920103,0.15666667,0.6920103,0.16,0.6920103,0.16333333,0.6920103,0.16666667,0.6920103,0.17,0.6920103,0.17333333,0.6920103,0.17666666,0.6920103,0.18,0.6920103,0.18333334,0.6920103,0.18666667,0.6920103,0.19,0.6920103,0.19333333,0.6920103,0.19666667,0.6920103,0.2,0.6920103,0.20333333,0.6920103,0.20666666,0.6920103,0.21,0.6920103,0.21333334,0.6920103,0.21666667,0.6920103,0.22,0.6920103,0.22333333,0.6920103,0.22666667,0.6920103,0.23,0.6920103,0.23333333,0.6920103,0.23666666,0.6920103,0.24,0.6920103,0.24333334,0.6920103,0.24666667,0.6920103,0.25,0.6920103,0.25333333,0.6920103,0.25666666,0.6920103,0.26,0.6920103,0.26333332,0.6920103,0.26666668,0.6920103,0.27,0.6920103,0.27333334,0.6920103,0.27666667,0.6920103,0.28,0.6920103,0.28333333,0.6920103,0.28666666,0.6920103,0.29,0.6920103,0.37,0.6920103,0.37333333,0.6920103,0.37666667,0.6920103,0.38,0.6920103,0.38333333,0.6920103,0.38666666,0.6920103,0.39,0.6920103,0.39333335,0.6920103,0.39666668,0.6920103,0.4,0.6920103,0.40333334,0.6920103,0.40666667,0.6920103,0.41,0.6920103,0.41333333,0.6920103,0.41666666,0.6920103,0.42,0.6920103,0.42333335,0.6920103,0.42666668,0.6920103,0.43,0.6920103,0.43333334,0.6920103,0.43666667,0.6920103,0.44,0.6920103,0.44333333,0.6920103,0.44666666,0.6920103,0.45,0.6920103,0.45333335,0.6920103,0.45666668,0.6920103,0.46,0.6920103,0.46333334,0.6920103,0.46666667,0.6920103,0.47,0.6920103,0.47333333,0.6920103,0.47666666,0.6920103,0.48,0.6920103,0.48333332,0.6920103,0.48666668,0.6920103,0.49,0.6920103,0.49333334,0.6920103,0.49666667,0.6920103,0.5,0.6920103,0.50333333,0.6920103,0.50666666,0.6920103,0.51,0.6920103,0.5133333,0.6920103,0.51666665,0.6920103,0.52,0.6920103,0.5233333,0.6920103,0.52666664,0.6920103,0.53,0.6920103,0.53333336,0.6920103,0.5366667,0.6920103,0.54,0.6920103,0.54333335,0.6920103,0.5466667,0.6920103,0.55,0.6920103,0.55333334,0.6920103,0.5566667,0.6920103,0.56,0.6920103,0.56333333,0.6920103,0.56666666,0.6920103,0.57,0.6920103,0.5733333,0.6920103,0.57666665,0.6920103,0.58,0.6920103,0.5833333,0.6920103,0.58666664,0.6920103,0.59,0.6920103,0.5933333,0.6920103,0.5966667,0.6920103,0.6,0.6920103,0.60333335,0.6920103,0.6533333,0.6920103,0.6566667,0.6920103,0.66,0.6920103,0.66333336,0.6920103,0.6666667,0.6920103,0.67,0.6920103,0.67333335,0.6920103,0.6766667,0.6920103,0.68,0.6920103,0.68333334,0.6920103,0.68666667,0.6920103,0.69,0.6920103,0.6933333,0.6920103,0.69666666,0.6920103,0.7,0.6920103,0.7033333,0.6920103,0.70666665,0.6920103,0.71,0.6920103,0.7133333,0.6920103,0.71666664,0.6920103,0.72,0.6920103,0.72333336,0.6920103,0.7266667,0.6920103,0.73,0.6920103,0.73333335,0.6920103,0.7366667,0.6920103,0.74,0.6920103,0.74333334,0.6920103,0.74666667,0.6920103,0.75,0.6920103,0.75333333,0.6920103,0.75666666,0.6920103,0.76,0.6920103,0.7633333,0.6920103,0.76666665,0.6920103,0.77,0.6920103,0.7733333,0.6920103,0.77666664,0.6920103,0.78,0.6920103,0.78333336,0.6920103,0.7866667,0.6920103,0.79,0.6920103,0.79333335,0.6920103,0.7966667,0.6920103,0.8,0.6920103,0.80333334,0.6920103,0.8066667,0.6920103,0.81,0.6920103,0.81333333,0.6920103,0.81666666,0.6920103,0.82,0.6920103,0.8233333,0.6920103,0.82666665,0.6920103,0.83,0.6920103,0.8333333,0.6920103,0.83666664,0.6920103,0.84,0.6920103,0.8433333,0.6920103,0.8466667,0.6920103,0.85,0.6920103,0.85333335,0.6920103,0.8566667,0.6920103,0.86,0.6920103,0.86333334,0.6920103,0.8666667,0.6920103,0.87,0.6920103,0.87333333,0.6920103,0.87666667,0.6920103,0.88,0.6920103,0.8833333,0.6920103,0.88666666,0.6920103,0.89,0.6920103,0.8933333,0.6920103,0.89666665,0.6920103,0.9,0.6920103,0.9033333,0.6920103,0.9066667,0.6920103,0.91,0.6920103,0.91333336,0.6920103,0.9166667,0.6920103,0.92,0.6920103,0.92333335,0.6920103,0.9266667,0.6920103,0.93,0.6920103,0.93333334,0.6920103,0.046666667,0.69458765,0.05,0.69458765,0.053333335,0.69458765,0.05666667,0.69458765,0.06,0.69458765,0.06333333,0.69458765,0.06666667,0.69458765,0.07,0.69458765,0.07333333,0.69458765,0.07666667,0.69458765,0.08,0.69458765,0.083333336,0.69458765,0.086666666,0.69458765,0.09,0.69458765,0.093333334,0.69458765,0.096666664,0.69458765,0.1,0.69458765,0.10333333,0.69458765,0.10666667,0.69458765,0.11,0.69458765,0.11333334,0.69458765,0.11666667,0.69458765,0.12,0.69458765,0.123333335,0.69458765,0.12666667,0.69458765,0.13,0.69458765,0.13333334,0.69458765,0.13666667,0.69458765,0.14,0.69458765,0.14333333,0.69458765,0.14666666,0.69458765,0.15,0.69458765,0.15333334,0.69458765,0.15666667,0.69458765,0.16,0.69458765,0.16333333,0.69458765,0.16666667,0.69458765,0.17,0.69458765,0.17333333,0.69458765,0.17666666,0.69458765,0.18,0.69458765,0.18333334,0.69458765,0.18666667,0.69458765,0.19,0.69458765,0.19333333,0.69458765,0.19666667,0.69458765,0.2,0.69458765,0.20333333,0.69458765,0.20666666,0.69458765,0.21,0.69458765,0.21333334,0.69458765,0.21666667,0.69458765,0.22,0.69458765,0.22333333,0.69458765,0.22666667,0.69458765,0.23,0.69458765,0.23333333,0.69458765,0.23666666,0.69458765,0.24,0.69458765,0.24333334,0.69458765,0.24666667,0.69458765,0.25,0.69458765,0.25333333,0.69458765,0.25666666,0.69458765,0.26,0.69458765,0.26333332,0.69458765,0.26666668,0.69458765,0.27,0.69458765,0.27333334,0.69458765,0.27666667,0.69458765,0.28,0.69458765,0.28333333,0.69458765,0.28666666,0.69458765,0.29,0.69458765,0.37,0.69458765,0.37333333,0.69458765,0.37666667,0.69458765,0.38,0.69458765,0.38333333,0.69458765,0.38666666,0.69458765,0.39,0.69458765,0.39333335,0.69458765,0.39666668,0.69458765,0.4,0.69458765,0.40333334,0.69458765,0.40666667,0.69458765,0.41,0.69458765,0.42333335,0.69458765,0.42666668,0.69458765,0.43,0.69458765,0.43333334,0.69458765,0.43666667,0.69458765,0.44,0.69458765,0.44333333,0.69458765,0.44666666,0.69458765,0.45,0.69458765,0.45333335,0.69458765,0.45666668,0.69458765,0.46,0.69458765,0.46333334,0.69458765,0.46666667,0.69458765,0.47,0.69458765,0.47333333,0.69458765,0.47666666,0.69458765,0.48,0.69458765,0.48333332,0.69458765,0.48666668,0.69458765,0.49,0.69458765,0.49333334,0.69458765,0.49666667,0.69458765,0.5,0.69458765,0.50333333,0.69458765,0.50666666,0.69458765,0.51,0.69458765,0.5133333,0.69458765,0.51666665,0.69458765,0.52,0.69458765,0.5233333,0.69458765,0.52666664,0.69458765,0.53,0.69458765,0.53333336,0.69458765,0.5366667,0.69458765,0.54,0.69458765,0.54333335,0.69458765,0.5466667,0.69458765,0.55,0.69458765,0.55333334,0.69458765,0.5566667,0.69458765,0.56,0.69458765,0.56333333,0.69458765,0.56666666,0.69458765,0.57,0.69458765,0.5733333,0.69458765,0.57666665,0.69458765,0.58,0.69458765,0.5833333,0.69458765,0.58666664,0.69458765,0.59,0.69458765,0.5933333,0.69458765,0.5966667,0.69458765,0.6,0.69458765,0.6566667,0.69458765,0.66,0.69458765,0.66333336,0.69458765,0.6666667,0.69458765,0.67,0.69458765,0.67333335,0.69458765,0.6766667,0.69458765,0.68,0.69458765,0.68333334,0.69458765,0.68666667,0.69458765,0.69,0.69458765,0.6933333,0.69458765,0.69666666,0.69458765,0.7,0.69458765,0.7033333,0.69458765,0.70666665,0.69458765,0.71,0.69458765,0.7133333,0.69458765,0.71666664,0.69458765,0.72,0.69458765,0.72333336,0.69458765,0.7266667,0.69458765,0.73,0.69458765,0.73333335,0.69458765,0.7366667,0.69458765,0.74,0.69458765,0.74333334,0.69458765,0.74666667,0.69458765,0.75,0.69458765,0.75333333,0.69458765,0.75666666,0.69458765,0.76,0.69458765,0.7633333,0.69458765,0.76666665,0.69458765,0.77,0.69458765,0.7733333,0.69458765,0.77666664,0.69458765,0.78,0.69458765,0.78333336,0.69458765,0.7866667,0.69458765,0.79,0.69458765,0.79333335,0.69458765,0.7966667,0.69458765,0.8,0.69458765,0.80333334,0.69458765,0.8066667,0.69458765,0.81,0.69458765,0.81333333,0.69458765,0.81666666,0.69458765,0.82,0.69458765,0.8233333,0.69458765,0.82666665,0.69458765,0.83,0.69458765,0.8333333,0.69458765,0.83666664,0.69458765,0.84,0.69458765,0.8433333,0.69458765,0.8466667,0.69458765,0.85,0.69458765,0.85333335,0.69458765,0.8566667,0.69458765,0.86,0.69458765,0.86333334,0.69458765,0.8666667,0.69458765,0.87,0.69458765,0.87333333,0.69458765,0.87666667,0.69458765,0.88,0.69458765,0.8833333,0.69458765,0.88666666,0.69458765,0.89,0.69458765,0.8933333,0.69458765,0.89666665,0.69458765,0.9,0.69458765,0.9033333,0.69458765,0.9066667,0.69458765,0.91,0.69458765,0.91333336,0.69458765,0.9166667,0.69458765,0.92,0.69458765,0.92333335,0.69458765,0.9266667,0.69458765,0.93,0.69458765,0.93333334,0.69458765,0.046666667,0.69716495,0.05,0.69716495,0.053333335,0.69716495,0.05666667,0.69716495,0.06,0.69716495,0.06333333,0.69716495,0.06666667,0.69716495,0.07,0.69716495,0.07333333,0.69716495,0.07666667,0.69716495,0.08,0.69716495,0.083333336,0.69716495,0.086666666,0.69716495,0.09,0.69716495,0.093333334,0.69716495,0.096666664,0.69716495,0.1,0.69716495,0.10333333,0.69716495,0.10666667,0.69716495,0.11,0.69716495,0.11333334,0.69716495,0.11666667,0.69716495,0.12,0.69716495,0.123333335,0.69716495,0.12666667,0.69716495,0.13,0.69716495,0.13333334,0.69716495,0.13666667,0.69716495,0.14,0.69716495,0.14333333,0.69716495,0.14666666,0.69716495,0.15,0.69716495,0.15333334,0.69716495,0.15666667,0.69716495,0.16,0.69716495,0.16333333,0.69716495,0.16666667,0.69716495,0.17,0.69716495,0.17333333,0.69716495,0.17666666,0.69716495,0.18,0.69716495,0.18333334,0.69716495,0.18666667,0.69716495,0.19,0.69716495,0.19333333,0.69716495,0.19666667,0.69716495,0.2,0.69716495,0.20333333,0.69716495,0.20666666,0.69716495,0.21,0.69716495,0.21333334,0.69716495,0.21666667,0.69716495,0.22,0.69716495,0.22333333,0.69716495,0.22666667,0.69716495,0.23,0.69716495,0.23333333,0.69716495,0.23666666,0.69716495,0.24,0.69716495,0.24333334,0.69716495,0.24666667,0.69716495,0.25,0.69716495,0.25333333,0.69716495,0.25666666,0.69716495,0.26,0.69716495,0.26333332,0.69716495,0.26666668,0.69716495,0.27,0.69716495,0.27333334,0.69716495,0.27666667,0.69716495,0.28,0.69716495,0.28333333,0.69716495,0.28666666,0.69716495,0.37666667,0.69716495,0.38,0.69716495,0.38333333,0.69716495,0.38666666,0.69716495,0.39,0.69716495,0.39333335,0.69716495,0.39666668,0.69716495,0.4,0.69716495,0.43333334,0.69716495,0.43666667,0.69716495,0.44,0.69716495,0.44333333,0.69716495,0.44666666,0.69716495,0.45,0.69716495,0.45333335,0.69716495,0.45666668,0.69716495,0.46,0.69716495,0.46333334,0.69716495,0.46666667,0.69716495,0.47,0.69716495,0.47333333,0.69716495,0.47666666,0.69716495,0.48,0.69716495,0.48333332,0.69716495,0.48666668,0.69716495,0.49,0.69716495,0.49333334,0.69716495,0.49666667,0.69716495,0.5,0.69716495,0.50333333,0.69716495,0.50666666,0.69716495,0.51,0.69716495,0.5133333,0.69716495,0.51666665,0.69716495,0.52,0.69716495,0.5233333,0.69716495,0.52666664,0.69716495,0.53,0.69716495,0.53333336,0.69716495,0.5366667,0.69716495,0.54,0.69716495,0.54333335,0.69716495,0.5466667,0.69716495,0.55,0.69716495,0.55333334,0.69716495,0.5566667,0.69716495,0.56,0.69716495,0.56333333,0.69716495,0.56666666,0.69716495,0.57,0.69716495,0.5733333,0.69716495,0.57666665,0.69716495,0.58,0.69716495,0.5833333,0.69716495,0.58666664,0.69716495,0.59,0.69716495,0.5933333,0.69716495,0.5966667,0.69716495,0.6566667,0.69716495,0.66,0.69716495,0.66333336,0.69716495,0.6666667,0.69716495,0.67,0.69716495,0.67333335,0.69716495,0.6766667,0.69716495,0.68,0.69716495,0.68333334,0.69716495,0.68666667,0.69716495,0.69,0.69716495,0.6933333,0.69716495,0.69666666,0.69716495,0.7,0.69716495,0.7033333,0.69716495,0.70666665,0.69716495,0.71,0.69716495,0.7133333,0.69716495,0.71666664,0.69716495,0.72,0.69716495,0.72333336,0.69716495,0.7266667,0.69716495,0.73,0.69716495,0.75333333,0.69716495,0.75666666,0.69716495,0.76,0.69716495,0.7633333,0.69716495,0.76666665,0.69716495,0.77,0.69716495,0.7733333,0.69716495,0.77666664,0.69716495,0.78,0.69716495,0.78333336,0.69716495,0.7866667,0.69716495,0.79,0.69716495,0.79333335,0.69716495,0.7966667,0.69716495,0.8,0.69716495,0.80333334,0.69716495,0.8066667,0.69716495,0.81,0.69716495,0.81333333,0.69716495,0.81666666,0.69716495,0.82,0.69716495,0.8233333,0.69716495,0.82666665,0.69716495,0.83,0.69716495,0.8333333,0.69716495,0.83666664,0.69716495,0.84,0.69716495,0.8433333,0.69716495,0.8466667,0.69716495,0.85,0.69716495,0.85333335,0.69716495,0.8566667,0.69716495,0.86,0.69716495,0.86333334,0.69716495,0.8666667,0.69716495,0.87,0.69716495,0.87333333,0.69716495,0.87666667,0.69716495,0.88,0.69716495,0.8833333,0.69716495,0.88666666,0.69716495,0.89,0.69716495,0.8933333,0.69716495,0.89666665,0.69716495,0.9,0.69716495,0.9033333,0.69716495,0.9066667,0.69716495,0.91,0.69716495,0.91333336,0.69716495,0.9166667,0.69716495,0.92,0.69716495,0.92333335,0.69716495,0.9266667,0.69716495,0.93,0.69716495,0.93333334,0.69716495,0.046666667,0.69974226,0.05,0.69974226,0.053333335,0.69974226,0.05666667,0.69974226,0.06,0.69974226,0.06333333,0.69974226,0.06666667,0.69974226,0.07,0.69974226,0.07333333,0.69974226,0.07666667,0.69974226,0.08,0.69974226,0.083333336,0.69974226,0.086666666,0.69974226,0.09,0.69974226,0.093333334,0.69974226,0.096666664,0.69974226,0.1,0.69974226,0.10333333,0.69974226,0.10666667,0.69974226,0.11,0.69974226,0.11333334,0.69974226,0.11666667,0.69974226,0.12,0.69974226,0.123333335,0.69974226,0.12666667,0.69974226,0.13,0.69974226,0.13333334,0.69974226,0.13666667,0.69974226,0.14,0.69974226,0.14333333,0.69974226,0.14666666,0.69974226,0.15,0.69974226,0.15333334,0.69974226,0.15666667,0.69974226,0.16,0.69974226,0.16333333,0.69974226,0.16666667,0.69974226,0.17,0.69974226,0.17333333,0.69974226,0.17666666,0.69974226,0.18,0.69974226,0.18333334,0.69974226,0.18666667,0.69974226,0.19,0.69974226,0.19333333,0.69974226,0.19666667,0.69974226,0.2,0.69974226,0.20333333,0.69974226,0.20666666,0.69974226,0.21,0.69974226,0.21333334,0.69974226,0.21666667,0.69974226,0.22,0.69974226,0.22333333,0.69974226,0.22666667,0.69974226,0.23,0.69974226,0.23333333,0.69974226,0.23666666,0.69974226,0.24,0.69974226,0.24333334,0.69974226,0.24666667,0.69974226,0.25,0.69974226,0.25333333,0.69974226,0.25666666,0.69974226,0.26,0.69974226,0.26333332,0.69974226,0.26666668,0.69974226,0.27,0.69974226,0.27333334,0.69974226,0.27666667,0.69974226,0.28,0.69974226,0.28333333,0.69974226,0.28666666,0.69974226,0.38,0.69974226,0.38333333,0.69974226,0.38666666,0.69974226,0.39,0.69974226,0.39333335,0.69974226,0.39666668,0.69974226,0.44,0.69974226,0.44333333,0.69974226,0.44666666,0.69974226,0.45,0.69974226,0.45333335,0.69974226,0.45666668,0.69974226,0.46,0.69974226,0.46333334,0.69974226,0.46666667,0.69974226,0.47,0.69974226,0.47333333,0.69974226,0.47666666,0.69974226,0.48,0.69974226,0.48333332,0.69974226,0.48666668,0.69974226,0.49,0.69974226,0.49333334,0.69974226,0.49666667,0.69974226,0.5,0.69974226,0.50333333,0.69974226,0.50666666,0.69974226,0.51,0.69974226,0.5133333,0.69974226,0.51666665,0.69974226,0.52,0.69974226,0.5233333,0.69974226,0.52666664,0.69974226,0.53,0.69974226,0.53333336,0.69974226,0.5366667,0.69974226,0.54,0.69974226,0.54333335,0.69974226,0.5466667,0.69974226,0.55,0.69974226,0.55333334,0.69974226,0.5566667,0.69974226,0.56,0.69974226,0.56333333,0.69974226,0.56666666,0.69974226,0.57,0.69974226,0.5733333,0.69974226,0.57666665,0.69974226,0.58,0.69974226,0.5833333,0.69974226,0.58666664,0.69974226,0.59,0.69974226,0.5933333,0.69974226,0.66,0.69974226,0.66333336,0.69974226,0.6666667,0.69974226,0.67,0.69974226,0.67333335,0.69974226,0.6766667,0.69974226,0.68,0.69974226,0.68333334,0.69974226,0.68666667,0.69974226,0.69,0.69974226,0.6933333,0.69974226,0.69666666,0.69974226,0.7,0.69974226,0.7033333,0.69974226,0.70666665,0.69974226,0.71,0.69974226,0.7133333,0.69974226,0.71666664,0.69974226,0.72,0.69974226,0.72333336,0.69974226,0.75666666,0.69974226,0.76,0.69974226,0.7633333,0.69974226,0.76666665,0.69974226,0.77,0.69974226,0.7733333,0.69974226,0.77666664,0.69974226,0.78,0.69974226,0.78333336,0.69974226,0.7866667,0.69974226,0.79,0.69974226,0.79333335,0.69974226,0.7966667,0.69974226,0.8,0.69974226,0.80333334,0.69974226,0.8066667,0.69974226,0.81,0.69974226,0.81333333,0.69974226,0.81666666,0.69974226,0.82,0.69974226,0.8233333,0.69974226,0.82666665,0.69974226,0.83,0.69974226,0.8333333,0.69974226,0.83666664,0.69974226,0.84,0.69974226,0.8433333,0.69974226,0.8466667,0.69974226,0.85,0.69974226,0.85333335,0.69974226,0.8566667,0.69974226,0.86,0.69974226,0.86333334,0.69974226,0.8666667,0.69974226,0.87,0.69974226,0.87333333,0.69974226,0.87666667,0.69974226,0.88,0.69974226,0.8833333,0.69974226,0.88666666,0.69974226,0.89,0.69974226,0.8933333,0.69974226,0.89666665,0.69974226,0.9,0.69974226,0.9033333,0.69974226,0.9066667,0.69974226,0.91,0.69974226,0.91333336,0.69974226,0.9166667,0.69974226,0.92,0.69974226,0.92333335,0.69974226,0.9266667,0.69974226,0.93,0.69974226,0.93333334,0.69974226,0.046666667,0.70231956,0.05,0.70231956,0.053333335,0.70231956,0.05666667,0.70231956,0.06,0.70231956,0.06333333,0.70231956,0.06666667,0.70231956,0.07,0.70231956,0.07333333,0.70231956,0.07666667,0.70231956,0.08,0.70231956,0.083333336,0.70231956,0.086666666,0.70231956,0.09,0.70231956,0.093333334,0.70231956,0.096666664,0.70231956,0.1,0.70231956,0.10333333,0.70231956,0.10666667,0.70231956,0.11,0.70231956,0.11333334,0.70231956,0.11666667,0.70231956,0.13,0.70231956,0.13333334,0.70231956,0.13666667,0.70231956,0.14,0.70231956,0.14333333,0.70231956,0.14666666,0.70231956,0.15,0.70231956,0.15333334,0.70231956,0.15666667,0.70231956,0.16,0.70231956,0.16333333,0.70231956,0.16666667,0.70231956,0.17,0.70231956,0.17333333,0.70231956,0.17666666,0.70231956,0.18,0.70231956,0.18333334,0.70231956,0.18666667,0.70231956,0.19,0.70231956,0.19333333,0.70231956,0.19666667,0.70231956,0.2,0.70231956,0.20333333,0.70231956,0.20666666,0.70231956,0.21,0.70231956,0.21333334,0.70231956,0.21666667,0.70231956,0.22,0.70231956,0.22333333,0.70231956,0.22666667,0.70231956,0.24333334,0.70231956,0.24666667,0.70231956,0.25,0.70231956,0.25333333,0.70231956,0.25666666,0.70231956,0.26,0.70231956,0.26333332,0.70231956,0.26666668,0.70231956,0.27,0.70231956,0.27333334,0.70231956,0.27666667,0.70231956,0.28,0.70231956,0.28333333,0.70231956,0.28666666,0.70231956,0.44,0.70231956,0.44333333,0.70231956,0.44666666,0.70231956,0.45,0.70231956,0.45333335,0.70231956,0.45666668,0.70231956,0.46,0.70231956,0.46333334,0.70231956,0.46666667,0.70231956,0.47,0.70231956,0.47333333,0.70231956,0.47666666,0.70231956,0.48,0.70231956,0.48333332,0.70231956,0.48666668,0.70231956,0.49,0.70231956,0.49333334,0.70231956,0.49666667,0.70231956,0.5,0.70231956,0.50333333,0.70231956,0.50666666,0.70231956,0.51,0.70231956,0.5133333,0.70231956,0.51666665,0.70231956,0.52,0.70231956,0.5233333,0.70231956,0.52666664,0.70231956,0.53,0.70231956,0.53333336,0.70231956,0.5366667,0.70231956,0.54,0.70231956,0.54333335,0.70231956,0.5466667,0.70231956,0.55,0.70231956,0.55333334,0.70231956,0.5566667,0.70231956,0.56,0.70231956,0.56333333,0.70231956,0.56666666,0.70231956,0.57,0.70231956,0.5733333,0.70231956,0.57666665,0.70231956,0.58,0.70231956,0.5833333,0.70231956,0.58666664,0.70231956,0.59,0.70231956,0.66,0.70231956,0.66333336,0.70231956,0.6666667,0.70231956,0.67,0.70231956,0.67333335,0.70231956,0.6766667,0.70231956,0.68,0.70231956,0.68333334,0.70231956,0.68666667,0.70231956,0.69,0.70231956,0.6933333,0.70231956,0.69666666,0.70231956,0.7,0.70231956,0.7033333,0.70231956,0.70666665,0.70231956,0.71,0.70231956,0.7133333,0.70231956,0.71666664,0.70231956,0.72,0.70231956,0.76,0.70231956,0.7633333,0.70231956,0.76666665,0.70231956,0.77,0.70231956,0.7733333,0.70231956,0.77666664,0.70231956,0.78,0.70231956,0.78333336,0.70231956,0.7866667,0.70231956,0.79,0.70231956,0.79333335,0.70231956,0.7966667,0.70231956,0.8,0.70231956,0.80333334,0.70231956,0.8066667,0.70231956,0.81,0.70231956,0.81333333,0.70231956,0.81666666,0.70231956,0.82,0.70231956,0.8233333,0.70231956,0.82666665,0.70231956,0.83,0.70231956,0.8333333,0.70231956,0.83666664,0.70231956,0.84,0.70231956,0.8433333,0.70231956,0.8466667,0.70231956,0.85,0.70231956,0.85333335,0.70231956,0.8566667,0.70231956,0.86,0.70231956,0.86333334,0.70231956,0.8666667,0.70231956,0.87,0.70231956,0.87333333,0.70231956,0.87666667,0.70231956,0.89,0.70231956,0.8933333,0.70231956,0.89666665,0.70231956,0.9,0.70231956,0.9033333,0.70231956,0.9066667,0.70231956,0.91,0.70231956,0.91333336,0.70231956,0.9166667,0.70231956,0.92,0.70231956,0.92333335,0.70231956,0.9266667,0.70231956,0.93,0.70231956,0.93333334,0.70231956,0.046666667,0.7048969,0.05,0.7048969,0.053333335,0.7048969,0.05666667,0.7048969,0.06,0.7048969,0.06333333,0.7048969,0.06666667,0.7048969,0.07,0.7048969,0.07333333,0.7048969,0.07666667,0.7048969,0.08,0.7048969,0.083333336,0.7048969,0.086666666,0.7048969,0.09,0.7048969,0.093333334,0.7048969,0.096666664,0.7048969,0.1,0.7048969,0.10333333,0.7048969,0.10666667,0.7048969,0.11,0.7048969,0.11333334,0.7048969,0.13333334,0.7048969,0.13666667,0.7048969,0.14,0.7048969,0.14333333,0.7048969,0.14666666,0.7048969,0.15,0.7048969,0.15333334,0.7048969,0.15666667,0.7048969,0.16,0.7048969,0.16333333,0.7048969,0.16666667,0.7048969,0.17,0.7048969,0.17333333,0.7048969,0.17666666,0.7048969,0.19,0.7048969,0.19333333,0.7048969,0.19666667,0.7048969,0.2,0.7048969,0.20333333,0.7048969,0.20666666,0.7048969,0.21,0.7048969,0.21333334,0.7048969,0.21666667,0.7048969,0.22,0.7048969,0.22333333,0.7048969,0.22666667,0.7048969,0.24666667,0.7048969,0.25,0.7048969,0.25333333,0.7048969,0.25666666,0.7048969,0.26,0.7048969,0.26333332,0.7048969,0.26666668,0.7048969,0.27,0.7048969,0.27333334,0.7048969,0.27666667,0.7048969,0.28,0.7048969,0.28333333,0.7048969,0.28666666,0.7048969,0.44333333,0.7048969,0.44666666,0.7048969,0.45,0.7048969,0.45333335,0.7048969,0.45666668,0.7048969,0.46,0.7048969,0.46333334,0.7048969,0.46666667,0.7048969,0.47,0.7048969,0.47333333,0.7048969,0.47666666,0.7048969,0.48,0.7048969,0.48333332,0.7048969,0.48666668,0.7048969,0.49,0.7048969,0.49333334,0.7048969,0.49666667,0.7048969,0.5,0.7048969,0.50333333,0.7048969,0.50666666,0.7048969,0.51,0.7048969,0.5133333,0.7048969,0.51666665,0.7048969,0.52,0.7048969,0.5233333,0.7048969,0.52666664,0.7048969,0.53,0.7048969,0.53333336,0.7048969,0.5366667,0.7048969,0.54,0.7048969,0.54333335,0.7048969,0.5466667,0.7048969,0.55,0.7048969,0.55333334,0.7048969,0.5566667,0.7048969,0.56,0.7048969,0.56333333,0.7048969,0.56666666,0.7048969,0.57,0.7048969,0.5733333,0.7048969,0.57666665,0.7048969,0.58,0.7048969,0.5833333,0.7048969,0.58666664,0.7048969,0.59,0.7048969,0.66333336,0.7048969,0.6666667,0.7048969,0.67,0.7048969,0.67333335,0.7048969,0.6766667,0.7048969,0.68,0.7048969,0.68333334,0.7048969,0.68666667,0.7048969,0.69,0.7048969,0.6933333,0.7048969,0.69666666,0.7048969,0.7,0.7048969,0.7033333,0.7048969,0.70666665,0.7048969,0.71,0.7048969,0.7133333,0.7048969,0.71666664,0.7048969,0.76,0.7048969,0.7633333,0.7048969,0.76666665,0.7048969,0.77,0.7048969,0.7733333,0.7048969,0.77666664,0.7048969,0.78,0.7048969,0.78333336,0.7048969,0.7866667,0.7048969,0.79,0.7048969,0.79333335,0.7048969,0.7966667,0.7048969,0.8,0.7048969,0.80333334,0.7048969,0.8066667,0.7048969,0.81,0.7048969,0.81333333,0.7048969,0.81666666,0.7048969,0.82,0.7048969,0.8233333,0.7048969,0.82666665,0.7048969,0.83,0.7048969,0.8333333,0.7048969,0.83666664,0.7048969,0.84,0.7048969,0.8433333,0.7048969,0.8466667,0.7048969,0.85,0.7048969,0.85333335,0.7048969,0.8566667,0.7048969,0.86,0.7048969,0.86333334,0.7048969,0.8666667,0.7048969,0.87,0.7048969,0.87333333,0.7048969,0.89666665,0.7048969,0.9,0.7048969,0.9033333,0.7048969,0.9066667,0.7048969,0.91,0.7048969,0.91333336,0.7048969,0.9166667,0.7048969,0.92,0.7048969,0.92333335,0.7048969,0.9266667,0.7048969,0.93,0.7048969,0.93333334,0.7048969,0.046666667,0.70747423,0.05,0.70747423,0.053333335,0.70747423,0.05666667,0.70747423,0.06,0.70747423,0.06333333,0.70747423,0.06666667,0.70747423,0.07,0.70747423,0.07333333,0.70747423,0.07666667,0.70747423,0.08,0.70747423,0.083333336,0.70747423,0.086666666,0.70747423,0.09,0.70747423,0.093333334,0.70747423,0.096666664,0.70747423,0.1,0.70747423,0.10333333,0.70747423,0.10666667,0.70747423,0.11,0.70747423,0.13666667,0.70747423,0.14,0.70747423,0.14333333,0.70747423,0.14666666,0.70747423,0.15,0.70747423,0.15333334,0.70747423,0.15666667,0.70747423,0.16,0.70747423,0.16333333,0.70747423,0.16666667,0.70747423,0.17,0.70747423,0.17333333,0.70747423,0.19333333,0.70747423,0.19666667,0.70747423,0.2,0.70747423,0.20333333,0.70747423,0.20666666,0.70747423,0.21,0.70747423,0.21333334,0.70747423,0.21666667,0.70747423,0.22,0.70747423,0.22333333,0.70747423,0.24666667,0.70747423,0.25,0.70747423,0.25333333,0.70747423,0.25666666,0.70747423,0.26,0.70747423,0.26333332,0.70747423,0.26666668,0.70747423,0.27,0.70747423,0.27333334,0.70747423,0.27666667,0.70747423,0.28,0.70747423,0.28333333,0.70747423,0.28666666,0.70747423,0.44333333,0.70747423,0.44666666,0.70747423,0.45,0.70747423,0.45333335,0.70747423,0.45666668,0.70747423,0.46,0.70747423,0.46333334,0.70747423,0.46666667,0.70747423,0.47,0.70747423,0.47333333,0.70747423,0.47666666,0.70747423,0.48,0.70747423,0.48333332,0.70747423,0.50666666,0.70747423,0.51,0.70747423,0.5133333,0.70747423,0.51666665,0.70747423,0.52,0.70747423,0.5233333,0.70747423,0.52666664,0.70747423,0.53,0.70747423,0.53333336,0.70747423,0.5366667,0.70747423,0.54,0.70747423,0.54333335,0.70747423,0.5466667,0.70747423,0.55,0.70747423,0.55333334,0.70747423,0.5566667,0.70747423,0.56,0.70747423,0.56333333,0.70747423,0.56666666,0.70747423,0.57,0.70747423,0.5733333,0.70747423,0.57666665,0.70747423,0.58,0.70747423,0.5833333,0.70747423,0.58666664,0.70747423,0.59,0.70747423,0.67,0.70747423,0.67333335,0.70747423,0.6766667,0.70747423,0.68,0.70747423,0.68333334,0.70747423,0.68666667,0.70747423,0.69,0.70747423,0.6933333,0.70747423,0.69666666,0.70747423,0.7,0.70747423,0.7033333,0.70747423,0.70666665,0.70747423,0.71,0.70747423,0.7133333,0.70747423,0.76,0.70747423,0.7633333,0.70747423,0.76666665,0.70747423,0.77,0.70747423,0.7733333,0.70747423,0.77666664,0.70747423,0.78,0.70747423,0.78333336,0.70747423,0.7866667,0.70747423,0.79,0.70747423,0.79333335,0.70747423,0.7966667,0.70747423,0.81333333,0.70747423,0.81666666,0.70747423,0.82,0.70747423,0.8233333,0.70747423,0.82666665,0.70747423,0.83,0.70747423,0.8333333,0.70747423,0.83666664,0.70747423,0.84,0.70747423,0.8433333,0.70747423,0.8466667,0.70747423,0.85,0.70747423,0.85333335,0.70747423,0.8566667,0.70747423,0.86,0.70747423,0.86333334,0.70747423,0.8666667,0.70747423,0.87,0.70747423,0.87333333,0.70747423,0.9066667,0.70747423,0.91,0.70747423,0.91333336,0.70747423,0.9166667,0.70747423,0.92,0.70747423,0.92333335,0.70747423,0.9266667,0.70747423,0.93,0.70747423,0.93333334,0.70747423,0.046666667,0.71005154,0.05,0.71005154,0.053333335,0.71005154,0.05666667,0.71005154,0.06,0.71005154,0.06333333,0.71005154,0.06666667,0.71005154,0.07,0.71005154,0.07333333,0.71005154,0.07666667,0.71005154,0.08,0.71005154,0.083333336,0.71005154,0.086666666,0.71005154,0.09,0.71005154,0.093333334,0.71005154,0.096666664,0.71005154,0.1,0.71005154,0.10333333,0.71005154,0.10666667,0.71005154,0.13666667,0.71005154,0.14,0.71005154,0.14333333,0.71005154,0.14666666,0.71005154,0.15,0.71005154,0.15333334,0.71005154,0.15666667,0.71005154,0.16,0.71005154,0.16333333,0.71005154,0.16666667,0.71005154,0.17,0.71005154,0.19666667,0.71005154,0.2,0.71005154,0.20333333,0.71005154,0.20666666,0.71005154,0.21,0.71005154,0.21333334,0.71005154,0.21666667,0.71005154,0.22,0.71005154,0.22333333,0.71005154,0.25,0.71005154,0.25333333,0.71005154,0.25666666,0.71005154,0.26,0.71005154,0.26333332,0.71005154,0.26666668,0.71005154,0.27,0.71005154,0.27333334,0.71005154,0.27666667,0.71005154,0.28,0.71005154,0.28333333,0.71005154,0.28666666,0.71005154,0.44666666,0.71005154,0.45,0.71005154,0.45333335,0.71005154,0.45666668,0.71005154,0.46,0.71005154,0.46333334,0.71005154,0.46666667,0.71005154,0.47,0.71005154,0.47333333,0.71005154,0.47666666,0.71005154,0.5133333,0.71005154,0.51666665,0.71005154,0.52,0.71005154,0.5233333,0.71005154,0.52666664,0.71005154,0.53,0.71005154,0.53333336,0.71005154,0.5366667,0.71005154,0.54,0.71005154,0.54333335,0.71005154,0.5466667,0.71005154,0.55,0.71005154,0.55333334,0.71005154,0.5566667,0.71005154,0.56,0.71005154,0.56333333,0.71005154,0.56666666,0.71005154,0.57,0.71005154,0.5733333,0.71005154,0.57666665,0.71005154,0.58,0.71005154,0.5833333,0.71005154,0.58666664,0.71005154,0.67333335,0.71005154,0.6766667,0.71005154,0.68,0.71005154,0.68333334,0.71005154,0.68666667,0.71005154,0.69,0.71005154,0.6933333,0.71005154,0.69666666,0.71005154,0.7,0.71005154,0.7033333,0.71005154,0.70666665,0.71005154,0.71,0.71005154,0.76,0.71005154,0.7633333,0.71005154,0.76666665,0.71005154,0.77,0.71005154,0.7733333,0.71005154,0.77666664,0.71005154,0.78,0.71005154,0.78333336,0.71005154,0.7866667,0.71005154,0.79,0.71005154,0.79333335,0.71005154,0.81666666,0.71005154,0.82,0.71005154,0.8233333,0.71005154,0.82666665,0.71005154,0.83,0.71005154,0.8333333,0.71005154,0.83666664,0.71005154,0.84,0.71005154,0.8433333,0.71005154,0.8466667,0.71005154,0.85,0.71005154,0.85333335,0.71005154,0.8566667,0.71005154,0.86,0.71005154,0.86333334,0.71005154,0.8666667,0.71005154,0.87,0.71005154,0.9166667,0.71005154,0.92,0.71005154,0.92333335,0.71005154,0.9266667,0.71005154,0.93,0.71005154,0.93333334,0.71005154,0.046666667,0.71262884,0.05,0.71262884,0.053333335,0.71262884,0.05666667,0.71262884,0.06,0.71262884,0.06333333,0.71262884,0.06666667,0.71262884,0.07,0.71262884,0.07333333,0.71262884,0.07666667,0.71262884,0.08,0.71262884,0.083333336,0.71262884,0.086666666,0.71262884,0.09,0.71262884,0.093333334,0.71262884,0.096666664,0.71262884,0.1,0.71262884,0.10333333,0.71262884,0.14,0.71262884,0.14333333,0.71262884,0.14666666,0.71262884,0.15,0.71262884,0.15333334,0.71262884,0.15666667,0.71262884,0.16,0.71262884,0.16333333,0.71262884,0.16666667,0.71262884,0.19666667,0.71262884,0.2,0.71262884,0.20333333,0.71262884,0.20666666,0.71262884,0.21,0.71262884,0.21333334,0.71262884,0.21666667,0.71262884,0.22,0.71262884,0.22333333,0.71262884,0.25,0.71262884,0.25333333,0.71262884,0.25666666,0.71262884,0.26,0.71262884,0.26333332,0.71262884,0.26666668,0.71262884,0.27,0.71262884,0.27333334,0.71262884,0.27666667,0.71262884,0.28,0.71262884,0.28333333,0.71262884,0.28666666,0.71262884,0.45,0.71262884,0.45333335,0.71262884,0.45666668,0.71262884,0.46,0.71262884,0.46333334,0.71262884,0.46666667,0.71262884,0.47,0.71262884,0.47333333,0.71262884,0.51666665,0.71262884,0.52,0.71262884,0.5233333,0.71262884,0.52666664,0.71262884,0.53,0.71262884,0.53333336,0.71262884,0.5366667,0.71262884,0.54,0.71262884,0.54333335,0.71262884,0.5466667,0.71262884,0.55,0.71262884,0.55333334,0.71262884,0.5566667,0.71262884,0.56,0.71262884,0.56333333,0.71262884,0.56666666,0.71262884,0.57,0.71262884,0.5733333,0.71262884,0.57666665,0.71262884,0.58,0.71262884,0.5833333,0.71262884,0.58666664,0.71262884,0.68,0.71262884,0.68333334,0.71262884,0.68666667,0.71262884,0.69,0.71262884,0.6933333,0.71262884,0.69666666,0.71262884,0.7,0.71262884,0.7033333,0.71262884,0.70666665,0.71262884,0.76,0.71262884,0.7633333,0.71262884,0.76666665,0.71262884,0.77,0.71262884,0.7733333,0.71262884,0.77666664,0.71262884,0.78,0.71262884,0.78333336,0.71262884,0.7866667,0.71262884,0.79,0.71262884,0.8233333,0.71262884,0.82666665,0.71262884,0.83,0.71262884,0.8333333,0.71262884,0.83666664,0.71262884,0.84,0.71262884,0.8433333,0.71262884,0.8466667,0.71262884,0.85,0.71262884,0.85333335,0.71262884,0.8566667,0.71262884,0.86,0.71262884,0.86333334,0.71262884,0.8666667,0.71262884,0.05,0.7152062,0.053333335,0.7152062,0.05666667,0.7152062,0.06,0.7152062,0.06333333,0.7152062,0.06666667,0.7152062,0.07,0.7152062,0.07333333,0.7152062,0.07666667,0.7152062,0.08,0.7152062,0.083333336,0.7152062,0.086666666,0.7152062,0.09,0.7152062,0.093333334,0.7152062,0.096666664,0.7152062,0.1,0.7152062,0.10333333,0.7152062,0.14,0.7152062,0.14333333,0.7152062,0.14666666,0.7152062,0.15,0.7152062,0.15333334,0.7152062,0.15666667,0.7152062,0.16,0.7152062,0.16333333,0.7152062,0.2,0.7152062,0.20333333,0.7152062,0.20666666,0.7152062,0.21,0.7152062,0.21333334,0.7152062,0.21666667,0.7152062,0.22,0.7152062,0.22333333,0.7152062,0.25333333,0.7152062,0.25666666,0.7152062,0.26,0.7152062,0.26333332,0.7152062,0.26666668,0.7152062,0.27,0.7152062,0.27333334,0.7152062,0.27666667,0.7152062,0.28,0.7152062,0.28333333,0.7152062,0.45333335,0.7152062,0.45666668,0.7152062,0.46,0.7152062,0.46333334,0.7152062,0.46666667,0.7152062,0.47,0.7152062,0.51666665,0.7152062,0.52,0.7152062,0.5233333,0.7152062,0.52666664,0.7152062,0.53,0.7152062,0.53333336,0.7152062,0.5366667,0.7152062,0.54,0.7152062,0.54333335,0.7152062,0.5466667,0.7152062,0.55,0.7152062,0.55333334,0.7152062,0.5566667,0.7152062,0.56,0.7152062,0.56333333,0.7152062,0.56666666,0.7152062,0.57,0.7152062,0.5733333,0.7152062,0.57666665,0.7152062,0.58,0.7152062,0.5833333,0.7152062,0.76,0.7152062,0.7633333,0.7152062,0.76666665,0.7152062,0.77,0.7152062,0.7733333,0.7152062,0.77666664,0.7152062,0.78,0.7152062,0.78333336,0.7152062,0.7866667,0.7152062,0.79,0.7152062,0.82666665,0.7152062,0.83,0.7152062,0.8333333,0.7152062,0.83666664,0.7152062,0.84,0.7152062,0.8433333,0.7152062,0.8466667,0.7152062,0.85,0.7152062,0.85333335,0.7152062,0.8566667,0.7152062,0.86,0.7152062,0.86333334,0.7152062,0.8666667,0.7152062],"colors":[[170,162,151],[168,159,149],[168,160,150],[180,170,156],[160,141,116],[154,131,100],[155,131,97],[157,131,98],[159,133,98],[162,137,104],[168,149,124],[179,169,156],[174,159,138],[156,129,96],[156,125,89],[159,128,91],[161,132,91],[163,133,91],[168,133,91],[168,133,87],[168,134,88],[170,141,105],[180,164,145],[176,161,140],[155,126,88],[157,125,85],[161,132,100],[172,147,120],[173,149,119],[171,146,114],[170,142,108],[172,136,93],[174,135,84],[173,133,84],[172,142,104],[188,175,159],[183,177,165],[155,131,95],[157,124,81],[162,129,90],[177,158,136],[193,182,171],[189,174,158],[185,170,151],[180,161,143],[175,142,110],[174,134,86],[176,135,86],[175,138,92],[178,156,132],[121,121,134],[87,90,98],[167,154,134],[153,124,82],[162,126,83],[170,136,100],[190,176,161],[177,160,140],[184,166,146],[193,182,170],[181,159,134],[175,135,89],[177,136,84],[177,136,87],[179,149,114],[102,100,112],[116,117,130],[103,100,112],[113,110,123],[96,94,104],[94,96,104],[154,138,149],[96,98,107],[82,83,91],[159,142,118],[159,126,82],[165,130,86],[174,140,104],[192,179,165],[193,182,171],[171,142,109],[172,147,120],[190,171,152],[175,136,92],[175,135,83],[178,136,86],[180,147,110],[103,105,115],[94,94,104],[93,94,106],[116,118,132],[113,114,126],[96,96,107],[109,110,121],[85,83,93],[93,96,103],[98,97,108],[133,140,148],[123,126,137],[103,106,118],[152,134,147],[96,98,107],[90,92,101],[128,133,142],[158,137,108],[163,128,85],[170,133,87],[178,143,105],[194,181,166],[191,179,167],[169,137,105],[168,142,120],[187,168,146],[174,135,87],[176,134,85],[178,137,88],[177,148,121],[78,78,92],[134,138,152],[90,89,101],[110,109,124],[102,103,118],[110,112,122],[119,121,132],[122,123,138],[121,120,135],[118,119,133],[95,94,104],[107,110,120],[109,110,122],[142,146,159],[121,126,137],[118,120,131],[124,127,140],[111,114,123],[119,122,132],[100,103,111],[91,94,101],[99,103,113],[91,94,104],[107,110,121],[128,132,142],[161,141,117],[163,129,87],[172,135,87],[178,144,106],[195,182,167],[191,180,170],[170,149,129],[177,162,151],[195,186,176],[182,154,118],[174,133,85],[175,134,85],[176,137,91],[178,157,138],[106,107,124],[170,175,189],[122,121,136],[149,150,166],[119,121,136],[124,125,138],[133,137,149],[148,150,166],[131,135,145],[105,107,118],[132,138,147],[124,131,141],[123,127,139],[135,141,150],[119,124,133],[138,144,153],[112,115,125],[103,108,117],[126,130,141],[128,133,142],[109,112,121],[164,151,137],[163,132,93],[171,134,88],[177,144,107],[193,177,157],[196,184,171],[189,172,159],[189,175,161],[184,163,136],[177,140,94],[173,131,85],[170,132,84],[174,138,103],[186,171,161],[126,127,140],[140,144,157],[117,121,130],[117,122,132],[163,138,112],[174,136,94],[175,140,100],[180,155,123],[185,161,136],[181,155,128],[173,147,117],[172,139,96],[171,133,88],[168,128,84],[166,132,93],[174,151,134],[170,155,141],[173,142,107],[175,140,99],[177,143,102],[175,142,104],[171,137,100],[169,135,97],[170,135,94],[170,133,93],[166,132,97],[171,148,129],[178,162,144],[175,149,117],[176,144,110],[174,141,108],[170,138,105],[168,136,103],[169,137,104],[170,142,116],[177,158,141],[188,176,164],[181,164,148],[177,158,141],[176,156,140],[178,158,142],[182,166,153],[169,187,180],[160,181,171],[161,180,170],[195,172,177],[187,153,158],[183,145,150],[181,143,145],[180,142,144],[182,145,149],[187,154,159],[194,169,176],[156,176,163],[125,160,133],[108,150,118],[102,145,111],[99,144,109],[110,149,116],[150,175,155],[188,156,158],[177,128,130],[179,121,122],[181,123,123],[182,124,123],[182,123,123],[182,124,123],[181,125,126],[180,131,133],[185,148,151],[162,180,173],[143,169,150],[102,146,111],[85,142,97],[82,141,95],[83,141,96],[84,142,98],[86,141,98],[101,144,108],[189,178,170],[182,165,147],[176,152,127],[173,145,117],[171,141,114],[170,141,115],[172,146,123],[177,156,136],[183,171,158],[188,156,159],[177,124,122],[179,116,115],[182,119,116],[183,120,119],[183,121,119],[183,123,121],[185,122,121],[185,122,121],[185,123,122],[184,126,125],[185,146,146],[133,156,143],[114,148,124],[105,146,117],[106,146,116],[114,150,124],[129,159,140],[157,178,168],[158,179,166],[104,147,113],[85,141,98],[82,142,97],[82,142,97],[82,142,97],[83,143,98],[83,143,98],[86,140,98],[130,159,139],[183,165,150],[174,145,117],[170,134,97],[170,129,86],[171,126,82],[173,126,81],[174,128,83],[173,128,84],[172,129,87],[171,134,98],[175,147,122],[185,169,157],[193,167,169],[178,126,124],[180,117,116],[182,119,116],[184,121,118],[185,123,121],[185,123,121],[185,123,122],[186,123,122],[187,122,122],[186,122,120],[187,123,121],[183,129,129],[193,170,174],[131,156,141],[108,148,120],[90,143,105],[87,144,101],[88,144,100],[91,144,104],[105,148,114],[146,170,150],[123,158,133],[87,141,100],[84,143,97],[82,142,96],[82,142,96],[80,143,97],[82,143,97],[82,142,98],[84,140,98],[118,151,128],[187,171,156],[171,138,105],[171,128,83],[173,125,77],[173,125,75],[174,125,76],[174,125,76],[174,125,76],[174,126,77],[175,125,77],[175,126,80],[174,127,83],[172,134,98],[181,156,136],[184,157,159],[184,146,151],[183,145,150],[184,150,156],[190,161,168],[182,135,134],[184,122,119],[183,120,117],[184,121,118],[186,123,121],[187,124,121],[186,124,120],[185,124,122],[186,123,122],[187,123,122],[186,122,121],[186,122,121],[183,124,126],[190,165,171],[157,184,170],[110,154,129],[85,143,103],[81,143,98],[82,145,99],[84,145,99],[105,147,110],[154,176,157],[173,192,183],[102,148,113],[84,142,98],[82,142,97],[82,142,97],[82,143,97],[80,143,97],[82,142,96],[81,141,96],[83,140,99],[122,157,137],[186,171,163],[183,170,160],[184,172,165],[178,154,133],[170,127,85],[172,125,76],[174,125,75],[174,124,76],[174,124,77],[173,125,75],[173,125,74],[173,125,75],[174,125,75],[175,125,76],[175,125,77],[175,127,80],[171,130,88],[179,158,136],[170,142,145],[174,128,128],[179,124,124],[177,122,122],[177,124,124],[178,127,130],[183,140,142],[192,164,170],[189,151,150],[183,125,122],[185,122,118],[185,121,119],[186,122,120],[186,124,120],[186,124,120],[186,123,120],[186,123,122],[186,122,122],[186,122,122],[185,122,120],[185,122,121],[181,128,133],[164,189,185],[100,149,121],[80,141,98],[81,143,98],[81,145,98],[87,145,99],[109,150,112],[158,181,167],[93,145,104],[83,143,98],[83,143,97],[82,143,96],[83,143,96],[81,143,97],[80,142,96],[79,140,94],[87,142,105],[144,174,162],[181,161,143],[176,146,119],[174,137,103],[171,134,100],[170,135,102],[173,144,117],[187,172,158],[175,149,127],[172,125,80],[173,125,75],[174,125,75],[175,125,77],[174,125,76],[174,124,76],[174,125,75],[174,125,75],[174,124,75],[175,126,78],[175,126,76],[175,126,77],[175,127,79],[172,137,103],[186,166,170],[176,136,135],[177,123,120],[180,121,118],[180,121,119],[182,122,119],[181,124,121],[182,132,134],[190,154,158],[201,175,176],[182,128,126],[185,122,119],[184,121,117],[185,121,118],[186,122,119],[186,123,119],[186,122,120],[187,123,120],[187,123,120],[187,123,122],[186,122,122],[185,121,120],[183,122,123],[185,146,153],[137,173,161],[83,141,102],[81,142,97],[83,145,100],[82,145,99],[89,144,98],[121,155,122],[140,169,149],[87,143,100],[82,144,98],[82,143,96],[82,143,97],[83,144,98],[82,144,98],[80,142,96],[78,139,94],[102,150,121],[173,196,191],[169,138,110],[172,127,86],[174,126,80],[175,127,80],[174,127,81],[172,128,83],[172,139,102],[189,175,161],[176,154,137],[172,126,83],[174,125,77],[175,126,77],[174,125,77],[174,125,77],[174,126,77],[174,126,76],[175,126,76],[174,125,76],[174,125,77],[174,125,78],[175,126,79],[175,126,80],[173,135,98],[186,173,164],[185,163,167],[174,127,128],[179,120,117],[179,119,117],[182,120,117],[183,120,118],[182,122,119],[181,126,126],[187,150,151],[185,138,135],[183,122,119],[185,121,117],[184,121,117],[184,121,117],[184,121,117],[185,121,118],[186,122,119],[186,123,120],[186,121,120],[186,121,121],[186,121,121],[185,122,123],[182,128,133],[197,178,188],[178,168,160],[165,155,147],[174,198,196],[95,145,114],[82,142,97],[84,146,101],[84,145,100],[86,145,100],[95,143,101],[134,158,136],[120,157,129],[85,143,98],[81,144,98],[81,144,96],[82,143,97],[83,144,97],[81,142,97],[80,142,96],[80,139,96],[124,163,143],[167,187,174],[148,173,156],[148,169,154],[175,163,156],[172,150,131],[171,125,82],[173,125,78],[175,126,78],[176,127,78],[175,126,77],[172,127,80],[175,145,113],[197,188,178],[182,168,155],[171,128,89],[174,125,77],[175,126,78],[174,125,78],[175,126,77],[175,126,77],[175,126,77],[175,126,77],[175,126,77],[175,125,78],[175,126,79],[176,126,80],[175,126,82],[173,135,102],[186,174,165],[180,142,145],[178,121,120],[180,120,117],[184,121,119],[184,120,118],[183,120,118],[182,120,120],[180,125,124],[188,149,152],[190,147,145],[182,122,119],[184,121,118],[183,120,116],[184,120,116],[183,120,116],[184,121,116],[184,121,116],[185,121,118],[186,122,119],[186,122,119],[185,121,118],[185,121,119],[183,121,123],[185,147,155],[167,155,146],[101,149,119],[81,141,95],[81,145,97],[82,144,96],[79,145,95],[82,144,95],[98,143,103],[141,165,144],[161,183,169],[102,147,110],[84,143,98],[82,144,97],[82,144,97],[83,144,97],[82,144,96],[79,142,96],[78,141,95],[83,141,98],[144,177,160],[150,175,154],[116,154,121],[103,146,109],[101,142,106],[129,156,135],[176,165,156],[175,155,137],[167,150,135],[182,172,162],[169,127,86],[172,126,78],[175,127,78],[175,126,77],[175,126,77],[175,126,78],[172,129,87],[187,164,140],[170,135,104],[173,125,76],[174,125,76],[175,125,78],[174,124,76],[174,125,75],[174,125,75],[174,125,76],[175,126,77],[175,125,78],[175,126,77],[175,127,78],[174,128,81],[173,138,109],[186,158,165],[177,121,121],[182,119,118],[183,122,118],[183,121,118],[183,120,117],[183,119,118],[183,120,118],[181,127,125],[185,146,147],[198,175,179],[190,154,151],[182,124,121],[183,120,118],[183,120,118],[183,120,117],[185,120,117],[184,121,117],[183,120,116],[184,121,117],[186,122,119],[185,122,118],[187,121,120],[185,121,119],[184,121,120],[181,124,127],[195,174,185],[177,166,156],[178,167,159],[100,147,115],[82,141,96],[82,145,99],[81,146,99],[79,145,97],[79,146,95],[83,144,95],[97,146,102],[144,167,147],[177,196,185],[125,159,130],[90,143,100],[83,144,97],[82,144,97],[81,144,96],[83,143,96],[82,143,96],[80,143,96],[78,142,95],[83,142,98],[146,179,159],[154,176,159],[109,149,113],[90,143,97],[88,143,96],[91,143,98],[111,148,120],[163,182,171],[161,179,167],[161,179,167],[178,158,141],[168,148,130],[167,130,93],[173,125,77],[174,126,77],[174,127,77],[175,126,77],[174,125,77],[174,126,79],[176,140,104],[196,187,176],[174,148,124],[172,125,79],[175,125,77],[174,125,75],[173,125,73],[174,125,75],[174,125,74],[174,125,74],[175,126,76],[175,125,77],[174,125,76],[174,127,77],[175,129,83],[174,143,115],[187,162,169],[176,118,118],[182,119,117],[184,122,118],[183,120,116],[183,121,117],[184,121,117],[185,121,118],[184,122,118],[180,125,124],[183,139,139],[190,161,161],[197,173,174],[193,167,169],[185,145,144],[181,125,121],[183,121,118],[184,121,117],[184,121,117],[184,120,116],[184,120,116],[184,120,117],[183,120,116],[184,121,116],[185,121,118],[187,122,119],[185,121,119],[184,121,117],[185,122,121],[183,135,141],[207,184,187],[196,167,171],[191,157,161],[188,151,155],[186,147,152],[186,148,152],[187,152,155],[193,160,164],[199,173,179],[178,168,158],[170,156,143],[94,143,109],[82,142,96],[83,144,97],[84,145,98],[82,145,97],[80,145,96],[82,145,96],[86,144,96],[101,145,105],[130,161,136],[164,186,173],[160,184,167],[127,163,134],[97,144,104],[87,143,99],[83,145,98],[82,144,97],[81,144,96],[82,143,96],[83,143,97],[81,143,96],[79,142,95],[83,142,96],[122,161,131],[160,185,168],[149,175,156],[112,150,116],[87,141,96],[83,143,94],[82,143,93],[84,143,94],[111,150,120],[151,172,157],[130,161,138],[115,150,123],[105,144,111],[102,143,107],[102,144,108],[104,143,109],[111,147,116],[126,156,132],[159,177,163],[179,164,148],[166,145,128],[167,133,100],[172,124,77],[173,127,77],[174,127,77],[174,127,77],[174,125,76],[175,126,77],[174,128,84],[185,161,136],[183,165,146],[171,128,86],[174,124,76],[174,125,74],[174,125,74],[174,125,75],[174,125,75],[175,124,75],[176,125,78],[174,125,76],[174,126,77],[174,127,79],[174,130,87],[177,150,128],[188,155,159],[178,117,117],[182,119,117],[184,121,118],[183,121,117],[183,121,117],[183,121,117],[184,121,117],[186,122,118],[184,123,120],[182,126,122],[179,128,126],[178,130,129],[180,130,127],[182,124,121],[184,122,118],[184,121,117],[184,121,117],[185,121,118],[185,121,116],[185,120,117],[185,120,117],[183,120,116],[184,121,117],[186,121,120],[187,122,119],[186,122,117],[185,122,118],[185,123,120],[188,147,152],[206,178,180],[191,153,153],[185,137,137],[183,131,132],[184,128,128],[184,127,127],[184,126,126],[184,127,126],[183,128,126],[184,129,128],[184,133,133],[188,147,148],[199,172,176],[179,169,159],[181,168,157],[151,175,159],[87,139,101],[81,144,99],[81,145,98],[83,145,97],[84,144,97],[84,144,97],[85,146,98],[86,146,97],[88,145,98],[94,144,102],[107,149,115],[122,159,129],[128,164,134],[123,160,129],[108,152,116],[94,145,104],[88,143,99],[86,144,99],[83,145,98],[82,144,97],[80,144,96],[81,145,98],[82,142,96],[82,143,95],[81,142,95],[82,142,95],[93,143,100],[106,149,110],[103,146,106],[89,141,96],[83,142,94],[82,143,94],[81,142,93],[82,141,93],[108,150,119],[165,186,171],[135,166,143],[113,151,121],[100,141,106],[91,139,99],[89,140,98],[86,139,97],[84,139,93],[82,138,92],[82,137,91],[85,138,93],[88,138,96],[107,143,108],[179,165,152],[168,151,137],[186,176,164],[166,133,99],[172,125,78],[174,127,78],[175,128,78],[174,127,77],[174,126,75],[175,126,77],[176,127,78],[174,135,96],[194,179,163],[193,179,165],[172,133,96],[174,125,77],[174,126,76],[174,125,75],[175,126,76],[174,125,75],[175,125,75],[175,124,76],[174,125,75],[175,126,77],[175,127,79],[174,130,88],[180,156,136],[187,176,168],[183,160,144],[174,148,126],[172,143,120],[171,142,120],[171,145,123],[173,150,130],[178,160,141],[184,173,160],[182,140,143],[179,117,117],[182,119,117],[183,120,117],[183,120,117],[183,121,118],[184,122,119],[185,122,120],[187,123,122],[185,123,120],[185,124,120],[185,125,119],[185,126,121],[185,124,120],[185,124,119],[183,122,118],[184,120,118],[184,121,117],[184,121,117],[183,120,116],[185,120,117],[184,119,116],[183,120,117],[184,121,117],[184,122,118],[185,122,120],[186,123,119],[186,122,119],[185,124,122],[192,148,152],[205,178,180],[191,151,153],[186,136,133],[185,128,125],[186,126,123],[187,125,123],[187,125,123],[186,125,122],[185,125,122],[187,125,121],[186,125,121],[188,125,122],[187,125,121],[187,126,123],[186,136,134],[198,168,168],[111,148,118],[83,139,98],[79,144,99],[80,146,97],[83,146,98],[84,146,98],[84,145,97],[84,145,97],[85,145,99],[85,145,97],[84,146,97],[87,144,100],[91,144,104],[94,144,104],[94,144,102],[89,144,100],[87,144,100],[87,143,101],[88,144,103],[85,143,99],[82,143,98],[81,144,97],[81,144,98],[82,143,96],[81,143,96],[81,142,95],[82,142,95],[83,142,95],[85,142,92],[84,142,92],[82,142,91],[82,142,94],[82,142,95],[83,142,95],[84,141,94],[101,146,109],[170,189,177],[168,190,175],[140,170,145],[111,152,116],[95,142,102],[89,140,97],[86,138,94],[82,139,92],[82,139,94],[81,139,94],[81,139,93],[81,139,92],[81,139,92],[81,139,93],[83,139,94],[88,138,94],[122,151,126],[174,163,157],[178,156,131],[166,127,87],[173,125,77],[176,127,78],[175,127,78],[174,126,77],[174,126,76],[174,126,77],[176,126,77],[174,126,79],[178,146,112],[200,189,176],[175,140,106],[174,125,78],[174,125,75],[175,126,77],[174,125,75],[174,124,75],[175,124,75],[176,124,76],[175,124,76],[175,126,77],[175,126,80],[175,130,88],[183,159,138],[181,165,148],[173,146,120],[172,133,98],[170,128,88],[171,127,85],[172,127,85],[172,127,86],[172,129,88],[172,130,91],[173,136,99],[175,147,116],[181,163,144],[194,175,181],[175,126,128],[179,118,117],[181,119,117],[182,120,117],[183,119,118],[183,120,118],[183,120,118],[184,121,120],[186,122,121],[186,122,119],[185,124,120],[183,124,118],[182,124,119],[183,124,119],[184,123,119],[185,122,118],[185,121,118],[185,121,118],[185,122,118],[184,121,117],[184,120,117],[184,120,117],[183,120,116],[183,121,116],[183,122,117],[184,121,117],[186,122,119],[186,122,119],[185,123,119],[186,133,130],[195,161,160],[198,170,172],[188,148,149],[183,134,133],[185,128,125],[186,126,122],[186,126,121],[187,126,122],[187,126,122],[187,126,122],[186,125,122],[186,126,123],[188,126,123],[187,126,122],[187,125,122],[188,125,121],[189,126,122],[187,127,122],[184,136,131],[201,179,179],[123,156,128],[92,140,101],[83,142,98],[80,144,98],[80,145,98],[84,147,98],[84,146,98],[83,146,98],[82,146,97],[84,146,98],[84,146,98],[81,145,96],[80,145,98],[83,144,101],[87,144,102],[87,143,101],[87,143,102],[89,143,105],[103,150,118],[117,158,133],[102,150,118],[85,143,105],[81,143,99],[81,143,97],[80,143,97],[80,143,97],[80,142,96],[82,142,95],[83,143,96],[85,143,95],[83,143,95],[81,142,92],[81,141,93],[80,143,93],[80,142,93],[80,142,92],[87,141,93],[131,164,133],[146,173,152],[118,154,122],[97,142,103],[90,140,96],[87,140,95],[85,140,95],[83,139,93],[80,138,92],[79,139,92],[81,139,94],[81,139,93],[79,138,91],[80,138,92],[80,139,93],[82,140,95],[84,138,93],[104,143,110],[186,172,154],[171,137,99],[171,127,80],[174,125,77],[176,127,78],[175,127,78],[175,127,78],[175,126,77],[175,127,78],[175,127,78],[176,127,78],[173,129,82],[184,154,123],[179,145,111],[174,126,78],[175,126,77],[175,126,77],[174,125,76],[174,125,75],[175,125,77],[175,125,76],[174,125,76],[175,126,77],[175,126,79],[175,128,83],[182,155,129],[180,162,140],[172,139,104],[172,128,86],[173,124,78],[173,125,76],[172,125,77],[174,125,77],[175,126,79],[175,125,79],[174,125,78],[176,127,81],[173,130,84],[169,131,89],[170,140,106],[176,158,139],[178,151,157],[173,122,125],[180,120,118],[180,119,117],[183,119,117],[182,119,117],[182,121,117],[183,120,118],[185,121,120],[185,121,120],[184,122,119],[185,123,120],[185,125,120],[185,125,119],[183,125,120],[183,123,121],[185,123,120],[185,123,119],[184,123,119],[186,123,120],[184,122,118],[184,121,118],[184,121,119],[183,122,117],[184,123,119],[184,123,116],[183,122,117],[184,123,116],[186,123,118],[187,124,117],[186,126,119],[183,131,126],[184,143,142],[190,156,156],[194,161,163],[192,158,160],[185,150,152],[179,140,139],[180,132,130],[184,128,125],[184,125,120],[186,126,122],[186,125,122],[187,125,121],[186,126,121],[187,126,121],[187,127,122],[186,126,122],[187,126,123],[187,126,124],[188,127,125],[188,126,124],[188,125,122],[187,124,121],[186,125,122],[185,128,123],[186,147,142],[127,158,136],[92,143,100],[85,143,98],[82,144,98],[82,145,99],[81,146,99],[84,146,100],[83,147,98],[81,146,98],[83,146,98],[83,146,99],[84,146,98],[80,145,98],[81,144,99],[82,143,100],[84,144,102],[85,145,104],[87,144,113],[106,154,134],[134,169,155],[158,185,179],[141,174,162],[103,153,132],[82,143,107],[78,142,97],[78,142,95],[80,142,97],[80,143,97],[81,142,96],[83,143,96],[84,142,94],[82,143,95],[82,142,94],[80,142,94],[79,142,94],[79,142,93],[80,141,93],[80,141,89],[93,144,97],[116,154,120],[125,158,129],[123,157,128],[116,151,120],[103,145,107],[93,140,98],[85,141,95],[87,140,95],[85,139,94],[84,139,94],[83,139,93],[80,139,93],[80,140,92],[80,139,94],[80,139,93],[81,139,92],[81,139,92],[81,139,94],[81,139,94],[83,139,93],[103,143,109],[185,171,156],[171,142,112],[170,128,85],[174,127,79],[175,126,77],[176,127,77],[176,127,77],[176,127,78],[176,127,77],[176,128,77],[175,128,78],[175,128,78],[174,127,78],[174,130,86],[180,153,123],[190,180,170],[192,182,171],[178,142,106],[174,127,79],[176,126,77],[175,126,76],[174,125,75],[174,125,76],[175,125,76],[175,126,76],[174,125,76],[174,126,76],[175,126,78],[175,127,81],[180,148,115],[187,177,163],[180,156,131],[172,136,99],[171,126,81],[173,124,77],[173,124,75],[173,124,74],[172,124,75],[172,124,77],[172,125,79],[174,124,79],[174,124,77],[176,125,79],[174,127,78],[173,126,77],[171,127,78],[170,129,87],[172,141,110],[184,170,155],[184,160,167],[176,132,135],[177,121,120],[180,119,117],[182,120,117],[182,120,117],[182,120,117],[182,120,118],[184,121,119],[184,121,119],[184,124,120],[182,126,120],[183,127,120],[181,128,119],[178,128,120],[178,127,120],[178,128,122],[180,129,123],[181,131,124],[182,133,123],[180,133,121],[181,132,120],[181,131,118],[181,129,116],[181,128,116],[181,126,114],[183,124,116],[184,123,118],[186,122,119],[187,124,118],[188,124,118],[187,125,119],[184,126,123],[182,128,124],[182,128,126],[182,128,125],[183,128,125],[184,127,122],[185,127,123],[186,126,121],[187,124,121],[188,124,121],[188,124,122],[188,125,121],[187,126,122],[188,125,121],[187,126,122],[187,126,122],[188,126,123],[188,126,123],[188,125,124],[187,126,123],[187,125,122],[187,126,122],[187,126,124],[187,126,124],[182,132,128],[113,152,124],[85,144,97],[83,144,97],[82,145,97],[83,145,98],[83,145,100],[84,145,99],[83,147,98],[84,147,99],[84,146,100],[83,146,99],[82,145,99],[80,144,99],[85,145,101],[84,143,102],[88,143,108],[93,149,123],[101,158,144],[139,182,185],[157,188,193],[165,189,196],[164,189,192],[137,179,178],[91,152,134],[80,144,111],[79,142,102],[78,142,99],[78,142,95],[81,142,97],[83,143,96],[82,142,95],[80,142,93],[82,142,93],[81,142,94],[80,143,95],[80,143,93],[82,142,92],[81,142,91],[81,141,91],[84,140,94],[89,139,97],[88,140,95],[89,140,97],[88,141,96],[86,140,95],[82,141,92],[84,140,93],[84,140,94],[83,140,94],[82,141,93],[80,139,93],[80,139,91],[80,140,93],[81,140,93],[82,140,93],[82,140,94],[81,139,94],[81,139,93],[84,138,96],[110,147,119],[189,175,161],[170,141,110],[169,128,87],[174,126,82],[175,126,79],[175,126,78],[176,127,78],[176,127,77],[176,127,78],[176,127,78],[175,128,76],[177,129,78],[177,128,79],[176,128,77],[175,127,78],[175,132,84],[174,143,108],[178,158,138],[185,170,157],[186,172,161],[183,169,157],[176,155,132],[172,133,92],[173,127,79],[175,127,78],[174,127,77],[173,127,77],[173,127,77],[174,126,76],[175,126,76],[175,126,77],[174,126,76],[175,126,77],[175,127,80],[175,135,95],[193,180,158],[188,174,161],[177,152,123],[174,136,94],[172,126,80],[174,125,77],[174,125,76],[175,126,77],[174,125,75],[174,125,75],[174,125,76],[174,125,76],[174,125,75],[174,125,75],[175,125,78],[174,125,77],[174,125,75],[173,125,77],[171,125,76],[169,127,82],[170,137,102],[186,176,163],[188,157,162],[175,125,126],[178,119,117],[179,120,116],[181,120,117],[182,119,117],[181,119,118],[182,120,119],[181,123,122],[178,131,122],[175,138,121],[176,148,124],[176,156,130],[176,160,137],[180,163,144],[180,165,144],[177,166,139],[175,165,133],[171,163,125],[165,161,114],[162,158,108],[159,155,101],[157,151,96],[156,146,93],[164,142,98],[174,133,108],[181,125,115],[186,122,119],[186,123,118],[188,124,118],[187,124,119],[187,125,121],[186,125,121],[186,125,121],[187,125,122],[187,124,122],[187,125,120],[186,125,121],[185,124,120],[187,123,121],[188,122,122],[188,124,123],[189,124,122],[189,125,122],[187,125,122],[187,127,122],[187,126,123],[188,126,125],[189,125,125],[189,127,125],[189,127,125],[187,126,125],[188,127,123],[187,125,123],[186,127,125],[181,136,137],[109,153,122],[84,145,97],[82,145,97],[82,145,96],[83,145,97],[84,146,100],[84,146,100],[83,145,99],[84,146,99],[84,146,100],[84,146,101],[83,146,100],[81,145,101],[86,144,103],[95,145,113],[115,157,139],[125,172,167],[112,170,176],[153,200,214],[154,196,210],[162,196,209],[171,199,210],[147,190,200],[100,163,167],[100,160,154],[88,149,125],[75,141,104],[75,140,95],[78,142,97],[80,143,99],[82,142,96],[80,141,93],[80,142,93],[81,142,94],[80,142,94],[81,142,94],[82,142,94],[81,141,93],[80,141,92],[81,141,92],[81,140,92],[82,141,91],[83,140,93],[82,140,95],[81,140,94],[82,141,94],[83,141,95],[83,141,95],[82,141,95],[80,140,92],[80,139,93],[79,138,92],[80,139,93],[81,138,93],[80,139,93],[81,138,94],[81,139,92],[80,138,92],[90,137,102],[131,159,142],[181,157,132],[170,131,89],[174,128,79],[176,127,80],[176,127,79],[176,127,78],[176,127,78],[176,127,78],[176,127,78],[176,127,78],[174,127,76],[175,129,77],[176,129,79],[176,128,79],[176,128,78],[174,129,77],[175,131,82],[171,133,93],[170,137,101],[173,140,106],[172,139,106],[170,133,96],[171,129,86],[174,127,80],[176,127,78],[174,127,78],[173,126,78],[172,127,78],[173,126,78],[175,126,77],[175,126,76],[175,126,77],[174,126,77],[174,127,80],[173,128,83],[177,149,112],[196,186,169],[184,168,151],[176,147,116],[171,133,92],[172,128,81],[174,126,78],[175,126,77],[174,125,77],[175,126,77],[175,126,77],[175,126,76],[175,126,77],[174,125,75],[174,125,76],[174,125,76],[175,126,78],[175,126,78],[174,125,75],[173,124,75],[173,124,75],[173,127,77],[170,127,80],[171,146,116],[180,138,140],[178,118,116],[179,119,115],[180,119,115],[182,120,116],[181,119,119],[182,124,127],[184,149,147],[188,172,162],[170,170,139],[153,166,111],[153,170,113],[153,173,115],[155,174,117],[155,174,117],[152,173,110],[149,171,103],[146,169,95],[141,167,89],[134,163,80],[133,160,76],[135,160,75],[135,160,74],[143,160,81],[159,152,96],[175,134,112],[183,122,117],[186,123,118],[187,123,119],[186,123,119],[187,123,120],[187,123,119],[187,123,121],[186,122,121],[187,122,120],[186,123,120],[186,123,119],[186,123,119],[187,123,120],[187,124,120],[188,124,122],[188,124,122],[188,125,122],[189,125,123],[189,126,124],[189,127,123],[188,126,124],[188,126,125],[188,128,125],[189,127,125],[188,127,125],[187,127,124],[186,126,125],[181,131,134],[189,161,167],[101,150,114],[84,145,98],[83,146,98],[81,145,96],[81,146,97],[81,146,97],[82,146,99],[82,146,98],[82,145,98],[84,146,100],[84,146,100],[84,145,101],[86,144,104],[104,151,122],[132,164,152],[158,184,183],[160,200,209],[118,181,197],[142,197,215],[139,195,211],[156,199,212],[179,208,221],[141,191,205],[99,167,182],[130,185,195],[115,171,167],[77,146,127],[70,138,98],[76,141,97],[80,143,97],[83,142,96],[81,141,94],[81,141,93],[80,141,93],[77,142,92],[79,141,92],[81,141,93],[81,141,93],[81,141,91],[80,141,91],[80,140,90],[80,140,90],[80,140,90],[81,139,93],[80,140,94],[82,141,94],[82,141,94],[82,141,95],[82,142,95],[81,141,94],[80,139,94],[80,138,94],[81,137,95],[83,136,96],[82,136,96],[82,137,96],[83,138,95],[85,138,98],[109,148,123],[163,181,176],[198,185,176],[193,177,164],[191,178,166],[195,183,173],[188,175,160],[174,141,105],[175,129,82],[175,128,77],[176,127,77],[175,127,77],[176,127,77],[176,127,77],[176,127,77],[176,127,76],[176,127,78],[175,128,78],[175,128,78],[175,128,78],[176,128,79],[175,129,79],[175,130,79],[175,130,80],[175,130,83],[172,131,84],[171,130,83],[171,130,85],[171,129,86],[172,129,87],[173,129,88],[174,130,87],[173,130,88],[171,128,88],[169,129,88],[170,129,88],[172,129,87],[174,129,85],[174,128,82],[174,127,80],[174,128,82],[175,129,82],[172,132,89],[178,149,116],[193,181,165],[188,178,168],[179,159,136],[173,141,107],[173,132,89],[173,129,81],[173,128,77],[173,126,77],[175,126,78],[176,127,79],[176,127,78],[174,127,77],[174,126,77],[175,126,78],[175,126,77],[175,126,78],[175,126,78],[175,126,78],[175,126,77],[175,126,77],[174,125,76],[174,126,77],[173,127,77],[173,127,78],[170,131,87],[184,171,154],[189,148,150],[178,119,116],[180,119,115],[181,119,115],[181,120,117],[180,119,120],[185,144,147],[171,185,158],[125,166,86],[105,160,50],[97,157,39],[103,158,46],[109,162,51],[109,160,53],[109,161,57],[114,162,60],[116,162,62],[111,158,57],[109,154,55],[115,157,60],[120,161,64],[125,165,72],[149,170,103],[173,145,119],[182,122,116],[184,121,117],[186,122,119],[186,122,120],[186,122,119],[186,122,119],[186,122,119],[186,122,119],[185,121,118],[186,122,119],[186,122,119],[186,122,117],[186,123,119],[185,122,118],[186,123,120],[187,124,121],[188,124,122],[188,124,122],[189,125,124],[189,126,124],[189,126,124],[189,127,125],[188,129,126],[186,128,125],[184,127,126],[182,128,128],[183,137,142],[192,163,171],[169,190,180],[168,189,180],[173,193,185],[187,207,196],[136,172,144],[88,145,100],[83,144,96],[83,145,97],[83,145,97],[82,145,97],[82,145,99],[82,145,100],[82,145,99],[83,145,100],[85,146,102],[87,144,103],[95,146,113],[113,154,131],[148,177,169],[178,196,202],[179,200,208],[159,203,218],[123,191,210],[130,195,213],[119,190,209],[141,196,212],[169,206,219],[134,192,209],[102,180,199],[146,196,209],[133,184,194],[91,162,164],[76,148,129],[78,143,109],[79,141,99],[82,142,96],[81,140,94],[80,140,93],[80,141,94],[78,140,93],[79,141,92],[81,141,92],[81,141,93],[80,140,91],[80,141,91],[80,141,91],[80,140,90],[80,140,90],[80,140,93],[80,139,94],[81,140,94],[81,141,93],[81,140,93],[81,141,95],[81,140,96],[85,139,100],[90,139,105],[98,142,112],[102,144,116],[105,145,119],[109,147,122],[109,148,124],[117,154,132],[150,175,166],[194,179,166],[183,152,117],[177,141,102],[176,140,102],[176,142,107],[179,148,115],[182,155,128],[185,161,139],[189,168,149],[195,177,161],[199,186,174],[202,189,178],[200,188,176],[196,183,171],[188,169,148],[175,147,116],[173,132,87],[176,127,78],[177,127,77],[177,127,77],[177,127,77],[175,127,75],[175,127,75],[176,128,76],[176,128,76],[176,127,75],[174,127,77],[174,128,78],[176,128,79],[176,127,79],[175,129,79],[175,129,79],[174,130,80],[174,131,82],[172,131,88],[170,132,92],[169,134,96],[168,136,104],[170,140,112],[171,142,117],[171,144,119],[171,144,119],[171,142,116],[168,137,108],[168,133,103],[169,136,107],[172,140,112],[172,140,109],[172,137,103],[170,133,100],[171,131,93],[171,130,92],[170,131,92],[172,142,106],[181,164,144],[188,177,168],[182,162,148],[177,146,118],[174,135,95],[174,130,84],[174,128,80],[175,128,80],[174,127,78],[175,126,77],[176,126,78],[175,127,77],[175,127,77],[174,127,77],[175,126,77],[176,126,78],[175,126,78],[175,126,78],[175,125,78],[175,126,77],[175,126,77],[175,126,78],[175,126,78],[174,126,77],[173,127,77],[173,127,78],[172,128,80],[171,150,123],[184,141,140],[179,118,116],[181,119,115],[182,119,117],[181,119,117],[180,120,123],[191,163,169],[129,171,103],[104,161,60],[95,156,47],[100,158,53],[105,160,58],[104,159,62],[107,160,68],[111,162,70],[112,160,73],[111,158,73],[107,156,69],[108,156,72],[115,159,79],[126,164,96],[158,180,135],[179,152,137],[181,121,116],[184,120,117],[184,121,118],[184,121,117],[184,121,118],[184,121,117],[184,121,118],[185,121,118],[184,121,117],[185,121,118],[185,121,118],[187,122,119],[186,122,119],[185,122,119],[186,122,120],[187,122,120],[187,123,121],[187,123,121],[189,125,123],[189,124,123],[188,126,125],[186,127,128],[183,129,128],[182,133,135],[181,142,145],[189,157,161],[198,178,186],[150,176,157],[130,161,135],[117,154,123],[111,152,120],[112,152,120],[113,152,121],[118,155,125],[125,158,133],[136,164,144],[153,175,160],[167,188,174],[178,198,189],[166,188,173],[133,166,142],[98,147,107],[83,145,96],[83,145,97],[82,145,97],[82,145,97],[82,145,98],[84,145,100],[83,144,100],[84,144,101],[86,144,102],[90,144,110],[103,148,122],[130,166,152],[153,178,175],[183,200,206],[197,215,224],[186,210,222],[154,202,217],[122,194,211],[120,194,213],[111,191,211],[120,193,212],[135,197,216],[111,188,207],[101,185,205],[153,202,214],[152,196,208],[106,173,187],[89,161,164],[90,156,148],[86,147,123],[84,143,104],[83,142,98],[80,141,95],[80,141,96],[81,141,95],[80,141,93],[81,141,91],[81,141,92],[80,141,91],[80,141,91],[81,141,92],[81,140,91],[81,140,92],[80,140,93],[81,141,95],[80,140,95],[80,140,93],[80,139,93],[80,139,95],[85,141,102],[104,149,123],[126,159,143],[144,170,160],[155,178,171],[164,183,177],[184,159,134],[174,132,86],[175,130,83],[178,131,82],[177,131,82],[175,131,83],[174,133,86],[174,132,90],[174,135,95],[177,138,102],[178,144,111],[182,151,116],[181,151,118],[178,146,115],[175,138,101],[173,130,86],[174,128,78],[176,127,77],[177,127,77],[178,126,77],[178,126,77],[176,127,75],[175,127,75],[174,128,76],[175,128,76],[175,128,76],[174,127,77],[174,128,79],[175,128,79],[176,128,79],[176,129,82],[174,129,83],[173,130,88],[170,134,95],[168,140,112],[169,147,128],[172,154,137],[173,158,142],[175,161,148],[173,160,149],[169,158,146],[164,153,141],[161,149,137],[154,140,126],[149,132,115],[153,135,121],[161,146,134],[172,159,147],[183,166,152],[179,161,144],[179,155,138],[174,146,125],[170,137,105],[171,134,96],[167,134,98],[167,138,109],[171,145,118],[173,147,121],[172,144,113],[170,136,100],[171,130,86],[175,130,83],[175,128,79],[174,128,78],[174,128,79],[174,127,78],[174,126,76],[175,127,77],[175,127,76],[176,128,76],[175,128,76],[176,128,77],[175,127,78],[175,126,77],[175,126,77],[174,125,75],[174,125,75],[175,126,77],[175,126,78],[175,126,78],[175,126,79],[175,128,78],[174,128,80],[173,129,82],[171,141,107],[192,159,159],[180,125,125],[182,118,116],[182,119,117],[182,118,119],[182,118,118],[180,123,125],[195,168,172],[154,180,147],[139,173,123],[134,169,116],[139,174,121],[139,174,124],[139,172,125],[145,177,133],[148,180,134],[147,178,134],[149,179,136],[149,179,136],[151,182,139],[158,187,149],[164,187,157],[184,152,150],[182,121,117],[184,121,117],[184,121,117],[184,121,117],[184,121,117],[184,121,117],[184,121,117],[184,121,117],[184,121,117],[184,121,117],[185,120,118],[185,121,118],[185,121,118],[185,121,118],[185,121,118],[185,121,118],[186,122,121],[186,122,121],[187,123,123],[185,125,125],[180,130,133],[181,140,145],[187,156,160],[198,174,180],[122,159,129],[102,149,110],[96,147,106],[92,145,101],[91,147,100],[93,150,103],[92,149,101],[93,149,102],[93,146,102],[97,147,105],[103,149,110],[106,151,112],[116,156,124],[125,163,134],[133,166,141],[134,166,141],[130,162,137],[122,158,130],[111,152,118],[99,145,109],[88,144,100],[83,146,97],[83,146,98],[82,146,97],[81,145,96],[81,145,98],[82,144,100],[82,143,101],[83,143,103],[92,144,113],[115,156,137],[142,170,163],[177,198,200],[186,204,209],[186,205,212],[194,213,224],[172,207,220],[133,196,213],[118,194,212],[117,194,213],[109,192,211],[106,192,212],[104,190,211],[95,186,207],[97,185,206],[154,204,217],[165,206,218],[114,184,202],[93,172,187],[98,169,181],[102,164,160],[96,152,135],[89,143,110],[83,141,98],[81,142,96],[80,141,96],[81,141,97],[81,141,94],[80,141,92],[80,141,92],[80,141,91],[80,140,93],[80,139,93],[80,140,94],[80,140,94],[80,140,94],[79,141,96],[79,139,95],[78,137,93],[81,137,99],[106,153,128],[152,182,174],[181,150,123],[177,130,84],[179,131,83],[180,131,81],[179,131,81],[180,131,81],[180,132,80],[180,131,79],[179,131,79],[179,130,80],[177,131,81],[175,130,80],[176,130,82],[175,130,83],[175,129,81],[175,128,77],[175,127,76],[176,127,77],[177,126,77],[177,127,76],[177,127,77],[177,127,76],[175,127,75],[175,127,75],[175,128,76],[175,127,77],[175,127,79],[176,128,82],[176,128,82],[175,129,82],[174,130,86],[172,132,93],[173,140,111],[177,154,136],[177,165,155],[179,167,158],[173,155,138],[169,146,120],[169,137,103],[168,131,92],[170,131,92],[170,130,89],[172,130,86],[174,130,85],[176,129,82],[174,128,78],[174,128,78],[174,128,78],[176,127,77],[175,126,76],[174,127,75],[175,127,76],[175,127,75],[176,127,76],[176,127,77],[176,127,78],[174,127,78],[173,126,76],[173,125,76],[174,125,75],[174,125,77],[175,126,77],[175,126,78],[176,127,79],[175,127,79],[175,128,81],[173,130,87],[172,143,113],[190,170,174],[184,156,159],[179,147,150],[175,143,146],[175,144,147],[178,149,153],[183,159,164],[190,171,176],[196,170,174],[186,146,147],[181,126,127],[182,118,119],[182,119,115],[182,118,116],[183,119,117],[182,119,116],[181,124,122],[195,166,169],[186,150,152],[180,119,116],[183,120,116],[183,120,116],[183,120,117],[183,120,116],[184,120,117],[185,121,118],[185,121,118],[184,121,117],[184,121,117],[185,120,117],[186,120,118],[185,120,117],[184,121,117],[184,121,117],[184,120,118],[184,120,120],[183,120,122],[181,124,127],[177,137,142],[187,162,168],[123,158,130],[91,145,102],[87,146,100],[89,147,102],[88,147,101],[88,148,100],[89,149,100],[88,148,100],[88,147,100],[88,147,99],[91,149,101],[93,150,102],[93,149,101],[94,149,103],[96,148,104],[96,147,105],[95,147,105],[95,147,105],[94,146,104],[91,146,103],[90,146,101],[87,146,100],[82,145,98],[83,147,99],[82,145,97],[80,145,96],[80,145,99],[81,144,102],[84,144,109],[91,147,120],[116,160,146],[163,189,186],[194,210,215],[193,212,220],[177,205,216],[170,206,220],[136,196,213],[112,193,210],[114,195,213],[113,193,212],[107,191,211],[100,190,211],[94,188,210],[91,186,209],[93,185,206],[154,204,218],[170,208,221],[116,188,208],[94,181,202],[99,179,198],[109,175,186],[123,172,174],[121,162,148],[97,145,114],[86,142,100],[81,142,97],[80,140,97],[80,140,95],[80,141,93],[80,141,92],[79,141,91],[79,139,91],[80,139,93],[80,140,93],[80,140,93],[80,141,93],[79,140,93],[79,139,94],[78,137,95],[92,142,112],[148,180,169],[181,150,124],[177,130,82],[180,131,82],[178,130,80],[177,130,80],[178,129,81],[180,131,81],[179,130,79],[179,130,78],[179,129,78],[178,130,78],[177,129,76],[177,129,76],[176,127,75],[176,127,75],[176,128,75],[176,128,75],[175,127,73],[175,127,74],[176,126,74],[176,128,76],[176,128,76],[175,127,75],[176,127,77],[174,127,77],[175,127,77],[175,128,78],[175,129,80],[176,129,81],[174,130,85],[172,136,100],[174,148,124],[176,161,148],[110,122,122],[110,123,124],[109,123,124],[112,122,124],[173,162,149],[170,149,126],[169,134,102],[170,128,88],[172,129,84],[175,129,84],[175,128,82],[174,128,79],[173,127,78],[174,127,78],[174,127,76],[175,126,75],[174,127,74],[174,127,75],[175,127,75],[175,127,76],[176,127,78],[176,127,78],[173,127,77],[172,127,76],[172,125,76],[172,125,76],[174,125,77],[175,125,77],[175,125,78],[175,126,79],[176,126,82],[175,129,86],[171,134,97],[173,153,134],[177,148,149],[171,124,126],[168,118,119],[167,117,116],[168,116,118],[168,116,117],[167,118,119],[169,124,124],[169,129,131],[174,138,142],[178,148,151],[182,157,160],[186,162,165],[190,167,170],[191,171,174],[194,174,178],[198,175,178],[196,173,175],[192,166,168],[189,159,162],[185,153,154],[182,141,143],[180,129,130],[180,122,121],[181,119,119],[183,117,118],[182,118,116],[182,119,115],[182,119,116],[182,119,116],[180,123,122],[192,167,170],[183,148,152],[181,119,116],[183,120,116],[183,120,116],[184,119,116],[185,119,118],[186,119,119],[186,119,117],[185,120,117],[184,119,116],[184,119,116],[185,119,116],[184,119,117],[185,119,116],[185,120,117],[185,120,117],[185,119,118],[183,118,119],[178,121,126],[182,146,153],[156,179,166],[96,145,104],[84,145,96],[83,145,96],[85,144,99],[85,145,99],[86,146,99],[87,147,100],[87,147,99],[87,147,99],[87,147,99],[88,148,99],[88,148,99],[88,148,100],[88,148,100],[88,147,99],[88,147,100],[87,147,100],[87,146,100],[86,146,100],[87,146,100],[86,146,99],[86,146,100],[84,145,99],[82,145,99],[83,145,99],[82,145,98],[83,145,101],[90,146,111],[111,159,143],[124,170,167],[142,180,182],[187,206,212],[185,210,222],[145,198,214],[130,196,214],[109,189,209],[105,191,212],[111,194,213],[110,193,212],[105,192,212],[97,190,210],[94,189,210],[91,186,209],[91,184,206],[151,204,218],[171,208,222],[115,189,209],[93,184,207],[96,183,204],[110,182,199],[148,192,202],[164,193,193],[128,164,150],[104,150,121],[87,142,103],[80,139,97],[79,139,96],[79,141,94],[80,141,93],[80,140,90],[79,140,91],[80,140,92],[80,140,94],[79,141,93],[80,140,92],[80,140,92],[80,139,93],[82,138,97],[108,151,127],[175,198,192],[180,152,128],[177,129,83],[178,130,81],[178,130,79],[178,130,80],[179,129,80],[180,130,81],[180,130,81],[179,130,80],[178,129,79],[178,129,77],[177,129,77],[177,128,76],[176,128,75],[176,128,74],[176,128,75],[176,128,74],[176,128,73],[175,127,73],[176,128,76],[176,128,76],[176,128,76],[175,127,75],[176,127,77],[175,126,77],[174,127,77],[174,128,78],[176,129,80],[174,131,87],[174,140,108],[177,157,141],[109,121,125],[108,122,125],[112,125,127],[115,129,131],[115,128,130],[116,127,130],[117,127,130],[111,121,124],[174,160,149],[168,142,119],[168,130,92],[173,127,82],[174,127,81],[172,127,80],[173,126,79],[174,126,78],[175,127,77],[174,126,75],[174,127,74],[174,127,75],[175,127,76],[175,128,77],[176,128,79],[176,128,79],[175,128,79],[174,129,80],[173,128,81],[174,127,81],[174,127,80],[175,127,81],[175,128,82],[173,127,82],[172,128,88],[171,133,97],[174,148,121],[186,173,164],[175,144,145],[167,117,116],[169,112,111],[171,114,112],[171,113,111],[171,113,111],[172,113,112],[172,114,113],[172,115,113],[172,116,114],[173,118,118],[172,120,119],[172,122,120],[174,124,123],[176,127,126],[177,130,129],[178,130,131],[179,130,130],[179,129,127],[179,126,125],[178,126,123],[179,125,122],[180,122,120],[180,120,119],[182,120,118],[183,118,118],[182,117,117],[182,118,117],[181,120,117],[181,119,116],[181,118,117],[179,123,123],[188,166,170],[181,148,152],[179,119,117],[181,120,115],[183,120,116],[184,119,116],[185,119,117],[185,119,117],[185,119,116],[185,120,116],[185,119,116],[184,119,116],[183,119,115],[183,119,116],[185,119,116],[185,119,116],[184,119,116],[184,119,118],[180,119,120],[183,142,149],[132,163,144],[89,145,99],[82,145,96],[82,145,97],[83,144,98],[84,144,97],[85,145,97],[86,146,99],[86,146,99],[86,146,99],[86,146,97],[86,146,98],[87,147,99],[87,146,99],[85,145,98],[86,146,99],[87,147,99],[87,146,99],[87,147,100],[86,146,99],[85,146,99],[86,147,98],[84,146,101],[84,145,102],[85,146,103],[85,145,102],[86,145,104],[98,152,119],[119,163,147],[146,183,184],[149,193,205],[152,193,206],[187,210,219],[197,213,224],[160,203,219],[110,189,210],[101,189,210],[102,189,212],[104,191,212],[109,194,213],[106,192,212],[102,191,211],[97,190,211],[94,188,210],[91,185,209],[91,184,206],[147,201,218],[172,209,222],[116,190,209],[92,185,206],[94,185,206],[114,189,208],[164,204,217],[181,206,213],[153,182,184],[145,177,169],[110,156,131],[86,142,105],[78,139,96],[78,140,94],[79,140,92],[79,141,92],[80,140,92],[80,140,93],[80,140,92],[79,139,90],[80,140,92],[81,141,93],[81,139,93],[83,137,95],[119,156,132],[183,159,140],[175,129,84],[178,129,81],[178,130,80],[178,130,80],[179,129,79],[179,130,80],[179,131,81],[179,130,80],[179,130,80],[177,129,77],[178,130,77],[177,129,77],[177,129,75],[176,128,75],[176,128,76],[176,128,74],[176,128,74],[176,128,75],[176,127,75],[175,126,75],[176,127,76],[176,128,76],[175,126,77],[175,127,78],[176,128,79],[175,128,80],[173,130,87],[171,140,110],[176,157,141],[116,129,132],[108,122,124],[111,125,127],[116,130,132],[117,130,133],[120,132,135],[127,137,142],[120,129,134],[115,124,128],[113,124,129],[117,130,134],[171,154,139],[168,133,100],[171,127,84],[172,126,81],[173,126,81],[175,126,79],[175,126,77],[175,126,75],[174,126,74],[174,126,76],[175,126,77],[175,126,79],[177,129,81],[176,130,84],[175,130,85],[173,132,90],[173,131,93],[172,131,93],[170,130,91],[172,132,93],[172,135,97],[173,138,104],[173,145,120],[178,159,141],[180,157,158],[167,119,117],[171,113,111],[171,112,110],[172,113,111],[171,112,110],[172,113,110],[172,114,111],[173,114,113],[174,114,113],[176,115,112],[177,117,113],[177,116,113],[175,116,113],[176,116,114],[175,116,114],[177,117,115],[177,119,117],[179,120,117],[178,120,116],[178,118,115],[179,120,115],[181,120,116],[182,119,116],[182,119,115],[182,119,116],[182,118,117],[182,118,117],[183,119,118],[181,119,117],[180,118,116],[179,118,118],[177,122,125],[189,165,169],[182,150,153],[178,122,120],[181,120,116],[181,120,115],[183,120,116],[183,120,117],[185,119,116],[184,120,116],[185,119,116],[184,120,116],[183,120,116],[183,120,116],[183,120,117],[184,119,117],[185,119,117],[184,119,117],[184,119,118],[179,123,127],[201,180,187],[122,158,136],[89,145,102],[83,144,99],[81,145,97],[83,144,98],[84,144,98],[84,144,97],[86,145,99],[86,145,99],[86,146,99],[87,147,99],[87,146,100],[86,146,98],[85,146,99],[85,146,99],[86,147,99],[87,147,99],[87,147,99],[87,147,99],[86,146,99],[83,146,98],[83,145,98],[86,145,100],[87,145,104],[91,144,109],[97,148,118],[112,160,137],[131,174,169],[140,178,183],[156,192,204],[147,196,211],[143,194,209],[176,207,218],[193,212,222],[174,207,219],[124,193,211],[96,186,208],[95,188,210],[99,189,211],[104,191,212],[108,194,214],[104,192,212],[101,190,211],[99,189,211],[95,188,209],[93,186,208],[92,184,207],[143,200,216],[170,209,221],[119,192,211],[91,185,206],[95,186,207],[116,190,209],[164,204,218],[176,206,217],[154,190,202],[168,197,204],[148,179,176],[111,158,142],[84,141,108],[79,139,96],[78,139,94],[78,139,93],[78,139,94],[80,139,94],[81,140,94],[80,140,90],[80,139,93],[81,140,93],[81,140,94],[80,140,94],[113,154,123],[176,195,185],[189,172,159],[173,130,89],[180,131,82],[178,130,80],[178,130,80],[177,129,80],[177,129,80],[178,129,80],[177,129,79],[178,129,79],[177,129,79],[178,129,78],[177,129,77],[177,129,77],[177,129,77],[176,128,75],[176,128,76],[176,128,76],[176,128,75],[176,128,77],[176,127,76],[176,128,76],[176,128,76],[176,128,78],[174,128,78],[174,128,81],[171,128,87],[172,139,111],[175,160,146],[122,134,138],[108,122,125],[108,122,125],[112,126,128],[115,130,132],[120,134,136],[129,142,145],[121,134,136],[115,124,128],[117,128,133],[129,141,147],[174,158,145],[169,138,109],[170,127,85],[173,125,81],[175,125,80],[175,126,78],[175,126,75],[173,126,74],[174,127,76],[173,126,78],[174,128,81],[176,132,89],[175,136,100],[174,141,110],[176,147,120],[176,150,128],[175,153,133],[178,157,137],[180,161,141],[182,167,150],[188,175,161],[169,133,134],[169,113,112],[171,112,110],[171,112,110],[172,112,111],[172,112,111],[172,114,111],[174,115,113],[174,115,113],[175,116,113],[175,117,112],[175,117,112],[175,116,112],[175,115,112],[177,116,111],[177,116,111],[177,116,113],[178,117,115],[179,118,116],[179,118,115],[179,118,115],[179,119,114],[181,119,115],[182,119,115],[182,119,115],[182,118,116],[182,118,116],[182,118,115],[182,119,116],[182,118,118],[180,119,118],[181,119,121],[175,123,126],[189,168,172],[185,158,165],[176,127,128],[179,120,119],[180,120,115],[182,120,116],[183,120,117],[184,121,117],[184,120,116],[184,120,116],[183,120,116],[183,120,116],[183,120,116],[183,119,117],[185,119,117],[185,119,117],[185,119,117],[185,118,119],[183,134,139],[132,165,152],[92,146,108],[87,146,103],[85,146,101],[85,146,100],[85,146,100],[85,145,99],[85,145,100],[85,145,99],[86,146,100],[85,146,100],[85,146,100],[84,146,99],[83,145,98],[84,146,98],[86,147,98],[85,146,98],[86,147,98],[86,147,99],[85,146,100],[84,145,100],[83,144,99],[86,143,101],[91,144,108],[106,150,130],[133,169,160],[148,184,184],[148,190,202],[146,187,201],[163,201,216],[142,195,212],[128,190,208],[161,203,219],[171,207,221],[138,196,213],[102,188,210],[87,185,208],[90,187,210],[96,188,210],[102,190,211],[105,193,213],[103,190,211],[101,190,211],[99,189,210],[97,188,210],[93,187,207],[92,184,206],[139,198,214],[168,209,221],[119,191,209],[91,185,206],[95,187,207],[112,191,209],[148,201,214],[153,199,214],[139,191,206],[172,204,215],[175,200,206],[150,189,193],[105,158,147],[87,146,117],[78,140,100],[77,139,93],[78,140,93],[79,140,93],[80,140,92],[79,139,89],[80,140,91],[79,140,92],[78,141,92],[78,139,90],[91,143,99],[128,162,134],[145,170,148],[148,172,154],[154,176,160],[163,183,169],[173,137,107],[179,131,87],[178,130,82],[177,129,81],[177,129,80],[177,129,80],[177,130,80],[177,129,79],[177,129,80],[176,129,79],[177,128,79],[178,129,77],[178,130,78],[178,130,78],[177,128,76],[177,128,75],[177,128,77],[178,128,77],[176,127,78],[175,126,77],[175,127,77],[176,128,76],[175,128,78],[174,128,80],[172,130,85],[170,136,105],[179,160,147],[122,135,138],[106,119,122],[108,121,124],[109,122,125],[110,124,126],[113,126,128],[114,128,130],[112,124,127],[110,120,123],[115,127,130],[135,146,153],[176,161,151],[168,135,106],[172,124,83],[175,125,81],[175,126,78],[174,126,77],[173,126,77],[174,126,77],[174,126,77],[173,130,86],[175,141,109],[181,158,138],[187,172,161],[166,121,121],[171,112,110],[172,111,109],[172,111,110],[173,112,112],[174,112,112],[175,113,113],[175,115,114],[174,115,113],[175,117,113],[175,116,112],[177,116,112],[176,115,111],[176,115,110],[176,115,110],[176,115,110],[176,116,113],[177,115,114],[178,116,115],[178,117,115],[180,118,115],[180,119,114],[181,119,115],[182,119,115],[182,119,115],[181,118,115],[181,118,115],[180,119,114],[181,119,115],[180,117,116],[180,119,120],[180,120,126],[176,133,139],[185,154,159],[179,138,139],[178,126,124],[180,121,118],[182,120,117],[183,121,117],[183,121,117],[183,121,118],[183,120,117],[182,119,116],[183,120,116],[182,119,116],[184,119,116],[184,118,115],[185,119,116],[184,117,117],[182,140,143],[168,191,191],[117,156,138],[98,147,115],[94,145,109],[90,144,105],[88,144,104],[87,143,102],[85,144,102],[86,144,101],[85,144,99],[81,143,98],[82,144,98],[81,145,98],[83,145,98],[84,146,99],[84,146,98],[84,146,98],[84,146,98],[84,145,98],[85,145,101],[86,145,100],[87,144,101],[94,147,109],[110,157,133],[137,175,172],[163,196,204],[158,193,205],[142,189,206],[146,193,208],[163,206,220],[132,194,211],[117,190,209],[142,201,219],[139,199,217],[113,191,210],[93,187,209],[85,184,207],[89,185,208],[95,186,208],[102,190,210],[104,191,211],[101,189,210],[101,189,210],[99,188,210],[98,188,209],[91,185,207],[91,184,204],[135,196,213],[166,208,220],[120,193,209],[91,185,206],[95,187,207],[110,190,209],[128,196,210],[128,192,209],[126,187,204],[168,204,214],[184,208,215],[159,197,208],[116,172,178],[108,166,161],[89,150,128],[73,137,100],[77,139,93],[78,141,92],[80,140,93],[79,140,91],[80,140,91],[79,140,91],[77,141,90],[77,141,89],[78,139,89],[90,138,97],[97,138,103],[93,136,100],[96,137,103],[100,139,105],[111,144,115],[135,158,138],[184,158,144],[176,133,96],[178,132,85],[178,131,82],[178,131,83],[178,131,82],[178,132,83],[178,131,83],[178,131,83],[177,130,82],[180,131,82],[180,132,82],[180,131,83],[180,131,82],[180,131,79],[179,129,77],[178,128,77],[178,128,76],[177,129,78],[176,127,77],[177,126,78],[177,127,77],[176,127,78],[175,129,84],[171,133,97],[176,153,134],[127,138,141],[106,118,120],[110,121,124],[111,123,125],[109,121,124],[107,118,122],[102,114,117],[102,113,115],[102,114,116],[110,122,126],[136,148,154],[178,164,153],[171,134,103],[173,125,82],[175,126,78],[174,127,78],[175,127,77],[173,127,76],[174,128,78],[172,135,97],[180,162,142],[168,117,116],[172,112,110],[173,112,110],[172,111,110],[173,112,112],[174,113,113],[175,113,114],[175,116,114],[176,116,113],[176,116,112],[177,116,112],[177,116,112],[177,116,112],[177,116,112],[177,116,112],[176,115,111],[177,115,112],[178,117,114],[179,118,115],[179,117,115],[181,118,114],[181,118,115],[181,118,114],[181,118,115],[181,118,115],[181,117,115],[181,119,115],[180,119,115],[181,120,116],[178,119,118],[179,123,127],[182,136,146],[191,168,180],[195,202,216],[190,198,212],[186,167,176],[180,149,155],[177,133,139],[180,124,125],[180,122,120],[181,122,119],[183,121,119],[183,120,118],[183,119,117],[183,120,117],[183,120,116],[184,119,116],[185,119,115],[185,120,115],[183,117,114],[183,135,134],[170,192,190],[143,173,159],[129,162,145],[120,157,136],[113,153,130],[108,150,124],[101,147,118],[98,146,114],[93,145,108],[89,145,106],[82,144,101],[81,145,99],[81,145,98],[84,146,99],[84,146,99],[84,146,98],[84,146,98],[83,146,97],[83,145,99],[84,146,101],[94,149,113],[121,165,148],[148,184,184],[145,184,196],[157,196,212],[157,198,213],[133,189,206],[139,194,210],[153,204,219],[119,193,210],[104,187,207],[122,195,214],[118,194,213],[100,188,209],[86,183,206],[83,182,205],[90,184,206],[96,185,208],[102,188,209],[103,189,209],[99,188,208],[99,188,208],[99,187,208],[96,186,207],[89,182,204],[91,181,203],[129,195,211],[158,205,218],[118,191,209],[91,184,205],[95,186,206],[108,190,208],[116,192,208],[114,189,205],[115,186,203],[157,199,211],[184,208,217],[150,194,206],[116,179,194],[134,189,198],[110,168,168],[76,142,124],[74,140,108],[78,141,99],[80,141,93],[79,140,92],[80,140,92],[78,140,91],[79,141,90],[78,141,89],[76,140,89],[79,138,91],[84,138,94],[81,138,91],[84,139,93],[84,138,92],[87,138,95],[99,139,102],[131,155,134],[177,148,128],[176,134,96],[175,131,87],[176,131,88],[177,132,90],[176,132,91],[175,134,94],[174,134,97],[173,135,96],[174,136,100],[174,138,105],[175,138,108],[176,139,107],[175,137,103],[174,132,93],[176,129,82],[178,128,76],[177,128,75],[178,128,77],[178,126,77],[178,127,78],[176,128,79],[172,129,87],[172,145,123],[182,169,161],[107,118,122],[108,120,123],[110,124,126],[109,123,126],[104,117,119],[101,112,116],[99,110,113],[98,110,113],[104,117,120],[136,147,152],[181,163,149],[171,131,97],[173,125,77],[175,126,77],[174,126,77],[173,127,77],[174,127,79],[175,139,103],[192,180,168],[180,161,167],[168,120,121],[171,112,110],[172,111,109],[171,111,111],[172,112,112],[173,112,112],[175,113,113],[176,114,112],[175,115,111],[177,116,112],[177,116,112],[177,116,112],[177,116,112],[177,115,112],[177,116,112],[177,116,112],[177,116,113],[178,118,115],[179,118,115],[180,118,115],[181,118,115],[181,118,115],[181,118,115],[181,117,116],[181,117,116],[180,117,116],[179,118,116],[181,118,117],[181,120,122],[183,128,134],[192,153,162],[188,196,210],[175,190,211],[157,178,208],[159,178,208],[173,189,216],[179,194,218],[172,188,212],[171,188,215],[161,179,209],[158,176,210],[169,186,215],[181,198,223],[168,187,217],[165,183,216],[178,193,222],[192,204,225],[203,211,227],[203,211,226],[196,203,220],[183,188,212],[178,180,204],[180,174,196],[178,158,177],[181,141,154],[177,131,138],[177,124,127],[180,122,122],[183,121,119],[183,120,119],[183,119,118],[183,120,116],[183,120,116],[184,119,116],[184,120,114],[183,117,114],[180,123,120],[193,162,164],[167,187,182],[159,182,174],[150,176,165],[138,170,155],[121,161,138],[98,149,118],[85,144,105],[81,143,100],[83,144,101],[84,145,102],[84,146,101],[84,146,99],[84,146,98],[82,144,98],[86,146,104],[118,163,150],[155,188,194],[156,191,203],[117,177,196],[120,183,205],[130,191,211],[109,182,202],[116,184,203],[127,192,208],[101,183,203],[96,183,204],[105,187,207],[103,186,207],[91,182,205],[78,177,200],[78,177,200],[84,180,202],[91,181,204],[100,184,205],[100,186,207],[96,184,204],[96,184,205],[95,183,203],[92,182,203],[86,179,200],[86,176,199],[107,183,202],[136,196,212],[109,185,205],[85,177,198],[90,179,199],[99,182,202],[106,185,203],[102,182,200],[101,180,199],[139,192,207],[164,202,213],[126,185,200],[107,180,195],[127,189,202],[114,175,185],[90,153,153],[94,154,144],[89,146,118],[80,141,93],[79,140,91],[80,140,92],[79,140,91],[80,140,91],[80,140,90],[78,140,90],[79,140,91],[80,140,91],[78,139,89],[84,140,94],[85,140,95],[86,139,96],[90,138,98],[107,141,113],[186,163,147],[177,149,128],[173,145,121],[172,144,122],[174,146,124],[178,150,130],[181,157,139],[186,164,145],[189,169,153],[192,173,160],[195,177,165],[195,178,166],[193,174,160],[185,162,142],[175,138,103],[176,128,78],[177,128,76],[178,128,77],[177,126,78],[178,127,78],[174,127,80],[172,133,99],[178,163,153],[125,137,139],[106,118,121],[106,119,122],[111,125,127],[109,125,126],[105,119,120],[101,114,117],[100,112,115],[95,108,110],[99,111,114],[180,159,142],[170,127,89],[176,125,78],[175,126,77],[175,127,78],[175,128,78],[174,136,95],[194,179,163],[167,128,134],[172,113,114],[171,110,110],[171,110,110],[171,110,110],[173,112,111],[174,112,112],[175,114,110],[175,114,111],[176,115,111],[176,115,110],[176,115,111],[177,116,113],[176,115,111],[176,115,111],[176,115,110],[177,116,113],[178,117,115],[178,118,115],[180,117,115],[181,117,115],[181,117,115],[181,118,114],[180,116,115],[181,118,116],[180,116,116],[181,119,119],[181,124,127],[185,143,148],[194,169,177],[187,196,212],[168,185,212],[151,177,213],[120,157,206],[98,142,199],[105,146,202],[121,158,209],[126,162,210],[122,158,208],[115,153,205],[104,143,198],[102,141,197],[120,158,209],[131,167,214],[111,150,204],[104,143,200],[116,150,204],[145,173,216],[173,195,227],[176,196,226],[158,181,216],[137,161,204],[138,159,200],[143,159,198],[149,153,187],[161,151,179],[172,149,168],[177,141,151],[177,130,135],[179,124,124],[182,120,120],[183,120,118],[183,120,118],[184,119,118],[185,120,119],[185,121,117],[184,119,116],[183,119,116],[182,130,127],[186,148,148],[194,165,169],[202,181,186],[180,201,199],[153,181,174],[109,157,134],[83,143,104],[83,144,101],[83,145,100],[83,145,98],[83,145,98],[83,145,98],[81,145,96],[91,150,113],[136,178,182],[156,190,203],[154,196,210],[104,179,201],[98,177,202],[115,187,207],[101,182,203],[104,181,202],[115,190,208],[100,184,205],[96,186,206],[100,186,207],[99,185,207],[88,180,203],[74,176,199],[74,175,197],[82,179,202],[88,178,200],[102,183,205],[102,185,206],[96,183,204],[95,183,204],[95,182,203],[93,181,202],[87,178,199],[84,174,196],[97,179,198],[118,192,207],[104,185,203],[86,177,199],[87,177,198],[94,181,200],[101,183,201],[97,180,199],[95,177,196],[127,187,202],[149,196,209],[115,181,198],[100,177,196],[111,183,198],[108,176,189],[101,164,173],[117,170,175],[115,164,148],[83,142,98],[80,141,92],[80,141,93],[80,140,91],[80,140,91],[80,139,90],[80,140,90],[79,139,90],[78,140,90],[76,138,88],[83,140,93],[84,140,95],[84,139,95],[88,138,99],[108,144,118],[186,167,150],[175,133,91],[177,128,79],[177,127,77],[176,126,78],[177,126,80],[174,128,86],[178,148,125],[129,140,143],[106,119,122],[106,120,123],[116,130,134],[116,131,134],[108,122,126],[106,119,123],[107,121,125],[102,115,118],[101,114,117],[106,117,121],[172,150,130],[171,125,83],[174,125,77],[176,126,77],[176,127,76],[173,130,81],[183,160,129],[178,150,157],[169,125,129],[166,117,118],[166,114,114],[167,114,114],[169,114,114],[171,114,114],[172,115,114],[173,116,116],[173,118,115],[173,118,115],[174,118,116],[175,117,115],[175,118,114],[176,116,112],[177,116,112],[177,116,114],[178,117,115],[178,117,115],[179,116,115],[180,116,115],[181,117,116],[181,117,116],[180,116,115],[179,117,117],[179,120,126],[182,134,141],[188,159,167],[183,193,215],[150,172,211],[109,147,202],[89,136,200],[72,126,197],[65,124,196],[66,123,195],[70,125,195],[71,125,195],[70,125,195],[68,123,195],[65,121,194],[67,125,196],[73,130,197],[82,135,201],[73,130,199],[63,120,193],[61,116,190],[81,128,193],[103,144,199],[103,142,195],[87,133,193],[80,130,194],[83,130,193],[85,127,190],[89,123,187],[107,131,183],[148,150,186],[175,165,184],[184,162,172],[178,142,148],[180,123,126],[184,120,118],[184,119,116],[185,120,116],[185,120,117],[186,121,117],[186,121,115],[186,120,115],[184,120,120],[180,122,121],[180,127,125],[181,135,135],[183,142,143],[189,151,152],[195,163,166],[201,175,178],[208,186,190],[157,188,181],[94,147,117],[83,143,101],[85,145,100],[85,145,98],[85,145,99],[85,145,98],[82,145,98],[91,151,118],[123,178,185],[135,185,201],[143,197,215],[95,182,206],[90,182,206],[112,191,211],[104,188,209],[105,188,208],[114,194,212],[102,188,210],[100,189,211],[101,190,211],[102,190,211],[93,187,209],[77,180,204],[78,180,202],[88,183,205],[94,183,205],[114,191,211],[112,191,211],[103,187,208],[100,187,208],[98,188,206],[98,186,206],[91,182,203],[89,180,201],[99,185,205],[116,194,210],[109,192,208],[92,184,203],[93,182,202],[101,185,203],[104,185,203],[100,183,202],[98,181,200],[124,189,205],[144,198,212],[115,185,202],[101,181,199],[106,185,201],[108,182,197],[108,177,191],[128,180,189],[142,182,172],[90,145,105],[80,141,93],[80,140,92],[80,140,91],[80,140,92],[81,140,92],[80,140,91],[79,139,90],[79,139,90],[77,140,90],[81,140,94],[87,141,99],[89,138,99],[96,140,108],[130,159,142],[176,143,113],[176,127,79],[176,127,79],[177,127,79],[178,126,84],[174,135,104],[186,168,158],[114,127,130],[113,127,130],[127,141,145],[135,148,151],[119,132,137],[117,131,137],[129,142,147],[127,140,145],[120,133,137],[122,133,138],[167,137,109],[171,125,76],[174,126,78],[176,127,78],[176,128,77],[176,136,93],[191,171,145],[180,162,167],[176,148,152],[170,135,139],[167,130,133],[167,128,132],[168,126,130],[170,129,131],[174,132,133],[175,134,135],[178,138,138],[182,140,139],[182,137,139],[178,131,131],[176,122,120],[176,117,115],[177,117,114],[177,116,114],[177,116,114],[179,116,115],[180,116,114],[180,117,114],[180,117,114],[179,119,118],[177,130,135],[184,153,163],[175,188,214],[124,153,202],[85,127,194],[56,114,191],[55,116,194],[59,120,198],[60,122,200],[60,122,200],[57,120,199],[55,118,196],[56,118,196],[55,118,196],[55,117,196],[57,122,198],[59,124,198],[69,130,202],[65,128,201],[53,120,199],[43,112,196],[53,115,194],[65,122,198],[66,121,197],[61,119,196],[61,121,199],[60,121,198],[57,117,196],[47,110,190],[62,113,189],[107,135,189],[169,177,202],[180,132,137],[183,122,120],[183,120,115],[185,120,117],[187,121,119],[186,120,117],[186,121,117],[186,121,118],[186,120,120],[185,122,119],[186,123,119],[184,124,120],[183,124,122],[183,126,123],[183,129,128],[182,134,134],[184,140,141],[185,148,149],[191,161,166],[189,209,210],[118,162,140],[84,143,102],[85,145,99],[85,145,99],[85,146,98],[85,146,99],[81,146,100],[83,151,121],[101,175,182],[109,180,199],[117,192,213],[82,182,206],[81,182,206],[112,195,214],[103,189,210],[103,189,209],[113,195,214],[102,190,212],[100,190,212],[101,191,213],[102,192,214],[91,188,211],[79,180,205],[79,180,204],[89,183,204],[94,184,204],[124,195,213],[119,193,212],[104,188,208],[103,189,209],[102,187,208],[103,189,209],[97,184,205],[92,182,203],[99,187,206],[112,194,211],[108,193,211],[96,187,206],[94,180,200],[103,184,202],[103,184,203],[99,182,202],[93,177,197],[109,183,200],[126,192,208],[107,183,199],[97,180,197],[100,183,198],[106,184,199],[111,183,198],[142,189,199],[156,191,180],[95,148,107],[81,141,95],[80,140,94],[80,140,94],[81,140,95],[82,140,95],[81,140,94],[78,140,91],[80,140,92],[83,139,96],[92,140,106],[106,147,120],[119,153,134],[140,166,156],[179,154,130],[176,128,83],[177,128,82],[177,128,82],[177,128,89],[174,147,125],[127,140,143],[138,151,154],[132,145,148],[123,138,142],[144,157,161],[150,162,166],[135,148,152],[139,151,157],[104,118,120],[98,109,109],[177,164,153],[167,127,89],[173,126,77],[175,126,78],[177,127,78],[178,129,81],[178,140,101],[192,172,149],[189,170,174],[192,173,177],[194,170,174],[183,146,148],[175,123,121],[176,116,113],[179,115,114],[179,115,114],[179,115,113],[179,115,113],[179,115,113],[178,118,115],[181,131,133],[192,171,178],[198,206,220],[134,159,200],[69,116,187],[50,106,188],[43,108,191],[48,113,194],[54,118,197],[57,120,199],[58,122,201],[54,119,200],[52,117,198],[56,118,198],[57,119,199],[55,120,198],[56,121,199],[59,125,200],[67,131,203],[68,131,204],[54,121,200],[40,112,195],[46,114,197],[56,119,199],[60,119,199],[60,120,200],[60,121,200],[58,120,198],[51,114,196],[47,110,193],[56,114,193],[89,131,186],[169,186,208],[182,137,141],[183,123,121],[184,121,117],[185,121,118],[186,122,119],[185,121,118],[185,121,117],[185,122,118],[185,121,119],[185,121,117],[186,121,118],[187,123,119],[187,122,119],[187,122,118],[187,124,119],[186,125,120],[185,125,122],[184,125,123],[183,131,130],[186,144,147],[198,172,177],[134,170,151],[87,143,103],[84,144,99],[85,145,99],[84,145,97],[83,146,99],[79,145,98],[77,149,120],[85,172,181],[81,172,194],[88,183,208],[73,182,208],[77,182,206],[115,196,217],[98,189,211],[100,188,210],[113,194,214],[101,190,212],[100,190,212],[103,191,213],[103,193,213],[91,189,212],[76,182,206],[72,176,199],[81,177,198],[88,179,198],[120,191,207],[120,191,207],[104,185,205],[104,186,206],[102,184,203],[106,188,207],[98,183,204],[90,179,200],[98,187,206],[107,193,211],[106,192,210],[97,187,207],[89,176,195],[101,181,199],[101,183,202],[97,180,200],[88,174,193],[91,173,191],[106,184,200],[99,181,197],[92,177,194],[88,173,189],[102,181,196],[113,185,199],[147,189,198],[163,192,182],[100,148,109],[82,141,94],[81,141,93],[80,140,93],[81,141,93],[80,140,92],[80,140,92],[80,140,92],[80,139,93],[93,145,112],[131,162,148],[160,181,175],[183,163,142],[174,130,86],[177,128,83],[177,128,85],[175,133,100],[182,165,151],[119,132,132],[157,168,174],[120,133,137],[106,119,121],[168,143,120],[171,126,81],[175,126,77],[177,126,79],[178,128,78],[176,129,83],[177,140,102],[185,163,140],[191,179,170],[179,139,141],[175,116,114],[178,115,114],[179,115,113],[179,115,113],[179,115,113],[179,116,113],[179,119,118],[190,156,161],[196,206,220],[122,156,206],[58,112,190],[43,104,189],[43,106,191],[46,110,192],[51,115,196],[55,119,196],[60,123,198],[51,117,196],[52,115,197],[58,117,197],[57,118,197],[57,120,199],[55,121,199],[60,126,201],[67,131,202],[79,139,203],[67,130,200],[44,113,194],[48,115,196],[55,118,198],[59,120,199],[62,122,200],[60,122,198],[60,121,199],[53,116,196],[51,112,192],[53,114,190],[96,140,192],[180,195,215],[180,134,136],[183,123,121],[185,122,118],[185,122,117],[187,123,119],[186,122,119],[186,122,118],[185,122,117],[185,122,118],[185,122,118],[186,122,119],[187,124,120],[186,123,120],[186,123,119],[187,123,120],[188,125,121],[188,123,121],[188,123,120],[187,124,122],[186,125,125],[184,134,134],[202,173,176],[130,166,145],[85,144,102],[83,144,99],[85,146,99],[84,146,98],[83,147,99],[79,146,99],[73,148,119],[74,170,180],[63,168,192],[74,181,208],[67,181,208],[76,181,207],[117,197,219],[95,187,212],[98,188,212],[112,194,215],[103,190,212],[102,190,213],[103,192,213],[104,193,213],[91,189,212],[74,182,206],[68,172,195],[76,172,194],[81,173,193],[112,183,200],[114,183,199],[102,179,197],[104,182,200],[102,179,198],[107,183,202],[95,177,197],[86,173,193],[96,185,203],[105,193,211],[105,192,211],[99,188,208],[85,173,192],[100,180,198],[103,185,203],[98,182,202],[89,177,197],[83,170,188],[100,183,201],[101,183,201],[96,180,198],[82,169,188],[93,177,195],[108,184,200],[136,184,193],[162,191,183],[102,149,110],[83,142,95],[81,141,93],[81,141,93],[81,141,93],[80,140,93],[80,140,92],[81,141,93],[83,142,95],[125,165,145],[177,198,194],[186,167,147],[174,131,90],[176,129,86],[174,128,91],[175,145,121],[117,128,130],[112,124,125],[112,126,127],[136,149,151],[139,151,154],[125,136,139],[149,160,166],[135,146,150],[175,160,147],[169,130,93],[175,125,77],[177,126,81],[178,128,79],[179,128,79],[176,129,83],[171,131,90],[173,138,106],[173,146,118],[174,150,129],[178,157,139],[184,166,152],[191,175,166],[188,161,163],[174,120,118],[178,115,113],[179,115,113],[179,115,113],[179,115,113],[179,116,114],[178,120,120],[191,165,170],[196,207,224],[124,162,212],[60,113,191],[47,105,189],[46,105,189],[46,107,190],[54,116,195],[67,126,197],[78,133,200],[60,119,195],[53,115,196],[54,116,196],[59,119,196],[61,122,198],[57,119,194],[64,126,198],[81,138,199],[129,170,213],[113,158,207],[62,121,193],[52,117,195],[61,119,196],[65,123,196],[67,127,196],[68,128,197],[65,126,198],[57,117,193],[58,115,191],[64,119,188],[125,161,204],[193,203,217],[178,132,134],[184,123,121],[185,122,119],[186,123,118],[186,123,118],[186,123,118],[187,124,119],[186,123,118],[186,122,118],[186,122,119],[186,122,119],[187,124,120],[186,123,119],[186,123,119],[187,122,119],[188,123,120],[188,124,121],[187,123,120],[187,123,119],[186,122,119],[184,124,120],[186,140,137],[117,157,130],[82,144,99],[82,144,99],[82,145,99],[82,145,99],[81,146,99],[78,145,99],[70,147,120],[71,170,182],[61,170,195],[69,180,208],[67,181,209],[77,181,206],[121,198,219],[91,186,210],[96,188,212],[112,194,216],[102,191,213],[101,191,213],[103,193,215],[103,194,214],[89,189,212],[71,181,205],[66,170,192],[73,169,191],[80,171,191],[112,183,201],[114,181,198],[103,175,192],[107,180,198],[103,177,195],[110,182,200],[92,173,192],[86,171,190],[96,184,202],[106,193,211],[107,194,212],[102,191,211],[86,173,192],[98,179,196],[101,183,201],[95,179,200],[84,173,193],[79,167,186],[97,180,198],[99,180,198],[95,178,198],[80,167,187],[89,175,193],[110,186,202],[138,186,196],[164,192,184],[103,149,112],[84,141,96],[81,141,94],[82,141,94],[80,141,93],[80,140,92],[80,141,92],[82,141,93],[84,141,96],[148,182,162],[186,164,138],[173,132,91],[177,131,88],[173,132,100],[177,159,146],[109,121,123],[113,125,128],[118,129,132],[119,130,133],[119,129,133],[121,132,135],[127,136,142],[110,121,123],[106,117,120],[115,127,130],[128,139,142],[124,138,140],[126,136,140],[124,134,138],[116,126,130],[122,131,137],[164,153,144],[173,139,112],[174,126,82],[176,127,78],[177,128,75],[178,128,78],[177,129,77],[176,129,81],[176,129,81],[174,128,81],[172,128,83],[171,128,83],[171,129,88],[170,131,95],[173,138,105],[176,148,118],[183,160,137],[193,179,167],[173,124,123],[178,115,114],[179,115,114],[179,116,114],[179,116,114],[180,116,114],[176,119,118],[193,162,164],[196,209,226],[131,166,211],[65,117,190],[48,104,187],[47,102,184],[53,106,187],[69,120,193],[106,147,201],[127,162,209],[89,133,195],[63,117,191],[62,117,193],[75,125,195],[96,141,199],[108,150,202],[112,153,205],[134,166,207],[180,201,225],[157,187,218],[88,137,196],[67,123,193],[80,129,194],[103,148,203],[110,153,204],[109,154,205],[97,144,199],[87,133,193],[89,133,194],[107,146,198],[174,195,223],[175,129,130],[184,123,120],[186,123,119],[187,124,118],[186,122,118],[187,123,120],[187,124,119],[186,123,118],[186,122,118],[186,122,119],[187,123,121],[187,124,120],[187,124,120],[187,122,119],[187,124,120],[188,124,120],[188,124,122],[188,125,121],[187,124,120],[187,124,120],[187,124,120],[181,126,120],[198,171,170],[102,146,113],[83,144,99],[81,145,98],[82,147,100],[81,146,99],[80,146,100],[77,145,99],[69,147,120],[75,171,183],[60,170,194],[65,179,206],[65,179,208],[74,179,206],[121,199,219],[88,185,208],[96,189,213],[110,195,215],[101,192,213],[99,191,213],[103,193,214],[103,194,214],[90,191,214],[70,181,206],[65,169,193],[73,169,189],[87,176,197],[123,193,211],[128,194,210],[121,189,206],[123,192,210],[111,184,202],[125,192,208],[97,175,193],[86,170,189],[98,183,202],[107,192,211],[105,191,211],[103,192,211],[87,175,194],[97,178,197],[102,184,202],[95,180,199],[86,174,194],[78,166,185],[95,179,197],[98,181,199],[96,179,197],[79,167,185],[88,175,193],[114,186,202],[148,189,199],[166,195,186],[102,150,112],[82,141,94],[81,141,93],[82,142,95],[82,142,94],[81,141,93],[81,141,92],[82,140,93],[83,139,94],[126,163,135],[201,189,176],[180,150,116],[173,130,88],[175,130,90],[172,138,110],[182,172,163],[111,122,123],[112,123,127],[115,128,131],[121,132,136],[111,122,125],[106,117,120],[109,120,123],[116,127,130],[116,128,131],[116,128,130],[119,130,133],[118,129,133],[114,124,127],[117,126,132],[138,130,122],[172,146,125],[173,128,87],[177,127,78],[177,129,78],[177,129,77],[177,129,77],[177,130,78],[177,130,78],[176,129,79],[176,129,80],[176,129,80],[177,130,80],[177,130,82],[176,129,84],[175,131,85],[174,132,88],[174,138,99],[184,159,133],[199,186,174],[196,177,180],[175,123,121],[179,116,113],[178,116,113],[179,115,114],[178,114,113],[178,115,114],[176,117,117],[191,157,160],[198,210,225],[145,174,208],[85,127,190],[62,106,183],[74,97,164],[85,98,162],[100,113,170],[138,140,178],[145,143,177],[108,108,154],[84,86,142],[83,91,147],[105,122,172],[142,159,196],[162,177,207],[162,177,208],[176,188,213],[197,205,220],[182,196,218],[121,151,197],[89,128,186],[118,150,198],[156,178,210],[165,186,216],[167,189,217],[156,177,211],[150,171,208],[155,175,212],[171,189,218],[176,128,129],[184,123,120],[186,123,120],[187,123,120],[186,122,120],[187,123,120],[186,123,119],[186,123,118],[186,122,119],[186,123,117],[186,123,119],[188,125,119],[187,123,118],[186,123,117],[186,123,117],[189,124,120],[188,125,122],[188,125,121],[188,125,121],[187,124,120],[187,123,120],[183,124,119],[188,151,148],[152,176,160],[95,144,105],[86,145,100],[82,146,99],[82,146,100],[81,145,100],[80,146,100],[78,146,98],[68,147,120],[76,172,183],[64,169,192],[64,179,206],[62,180,207],[72,179,206],[120,197,219],[87,184,207],[99,191,214],[112,196,216],[101,192,213],[100,193,213],[105,195,215],[105,195,215],[93,192,215],[71,182,207],[65,170,193],[72,168,188],[89,181,202],[131,200,219],[137,200,217],[130,194,210],[136,200,216],[121,190,207],[141,201,215],[105,178,195],[83,168,188],[98,183,201],[110,194,212],[106,191,210],[105,192,210],[89,176,194],[97,179,197],[102,184,204],[96,181,201],[89,176,196],[79,169,188],[95,180,199],[100,183,203],[98,181,201],[83,171,190],[85,175,193],[112,187,203],[146,188,197],[168,195,187],[102,150,112],[82,141,93],[80,141,93],[80,142,93],[81,142,93],[80,141,92],[82,141,93],[82,140,93],[82,140,92],[96,141,102],[147,172,153],[204,195,183],[189,168,142],[174,135,94],[175,131,87],[175,132,93],[173,147,123],[119,128,132],[124,135,138],[135,146,150],[110,121,124],[106,118,121],[108,119,122],[112,122,125],[115,126,129],[116,129,130],[117,129,131],[115,126,129],[110,122,124],[113,124,128],[136,145,151],[162,146,131],[171,134,97],[176,127,79],[177,128,79],[177,129,77],[176,129,76],[176,129,76],[175,129,76],[175,128,76],[175,128,76],[176,129,78],[176,129,79],[178,128,79],[177,128,80],[177,129,80],[176,128,79],[175,129,81],[173,130,87],[178,148,116],[195,185,169],[189,161,161],[176,118,115],[178,116,112],[178,116,112],[179,115,114],[179,115,114],[178,116,114],[177,117,117],[186,153,156],[163,177,204],[119,139,187],[97,97,150],[113,65,98],[118,60,90],[125,65,94],[134,71,94],[133,69,91],[120,53,80],[103,42,72],[106,52,79],[125,82,107],[151,117,137],[164,136,154],[170,144,161],[178,152,167],[185,159,171],[177,153,172],[146,132,163],[129,121,161],[152,144,172],[181,168,186],[182,170,190],[178,128,127],[185,123,119],[186,124,120],[187,124,120],[187,123,122],[186,123,120],[186,122,119],[186,123,119],[187,124,120],[186,123,119],[187,123,120],[187,124,119],[187,124,119],[187,124,119],[187,124,119],[189,125,121],[188,125,121],[188,125,121],[188,125,121],[187,124,121],[186,123,119],[185,124,121],[184,144,142],[118,154,125],[89,145,101],[85,145,100],[82,145,101],[81,146,100],[82,146,100],[81,146,101],[78,145,99],[66,147,120],[77,173,184],[65,170,193],[62,179,205],[61,180,208],[70,179,205],[116,197,219],[86,183,205],[102,192,214],[115,197,218],[102,192,212],[100,193,213],[105,194,215],[104,194,214],[94,193,215],[71,182,206],[65,171,192],[69,168,186],[88,182,203],[130,201,218],[142,201,217],[131,195,210],[138,201,217],[125,191,208],[151,205,219],[113,180,197],[84,168,186],[99,184,201],[111,194,212],[109,193,210],[109,193,211],[95,181,200],[97,179,199],[101,184,203],[94,181,200],[89,177,197],[84,171,192],[94,179,199],[99,182,202],[97,181,201],[89,175,196],[87,176,195],[110,188,204],[144,188,199],[168,194,188],[103,150,114],[82,142,94],[80,141,92],[79,142,91],[80,142,91],[79,141,91],[81,140,91],[82,140,92],[81,139,90],[84,140,91],[104,145,107],[137,162,139],[159,179,163],[196,185,172],[187,167,141],[175,143,106],[176,131,89],[178,132,88],[172,132,93],[176,156,139],[110,121,124],[105,116,119],[106,117,120],[109,120,123],[113,125,126],[114,128,128],[116,128,130],[114,126,128],[110,123,124],[113,126,128],[145,137,127],[168,139,111],[176,129,81],[177,128,80],[177,128,78],[177,129,77],[177,130,78],[176,129,77],[175,128,76],[174,129,75],[175,128,76],[176,129,78],[177,128,78],[178,128,78],[177,129,79],[177,129,79],[176,128,78],[175,126,76],[172,128,81],[176,147,113],[177,136,134],[178,118,114],[178,116,112],[179,116,111],[179,115,113],[179,115,114],[178,115,114],[177,118,118],[183,148,151],[159,137,160],[141,109,137],[138,77,98],[135,52,67],[137,45,59],[140,44,58],[145,46,60],[146,47,63],[138,44,59],[132,41,56],[132,45,59],[137,51,64],[138,58,70],[141,67,79],[144,76,87],[148,82,92],[152,87,98],[152,88,103],[147,82,101],[146,84,104],[152,95,107],[156,102,111],[153,100,109],[151,97,105],[149,94,103],[148,98,109],[156,113,124],[166,149,156],[179,126,123],[185,123,119],[187,124,120],[187,124,121],[187,123,121],[186,122,119],[186,122,120],[187,122,119],[187,123,119],[187,123,119],[187,123,119],[187,124,120],[187,124,120],[187,124,120],[187,124,120],[187,125,121],[188,125,121],[188,125,121],[188,125,122],[188,124,121],[186,123,120],[184,124,123],[185,144,145],[142,173,147],[94,145,104],[85,146,101],[82,146,99],[82,147,98],[82,147,100],[82,147,100],[81,146,102],[76,144,102],[64,146,122],[75,172,184],[61,169,192],[66,181,208],[64,181,209],[70,179,205],[109,196,218],[84,183,207],[103,192,215],[114,197,217],[103,192,213],[99,191,212],[105,194,214],[104,194,214],[96,192,213],[72,183,206],[68,172,193],[70,167,187],[90,183,204],[132,201,217],[147,203,220],[135,196,212],[141,201,216],[126,191,207],[157,206,219],[117,182,199],[84,166,186],[102,183,200],[111,195,213],[105,192,210],[107,193,210],[101,189,208],[101,186,206],[104,188,207],[98,185,205],[95,182,203],[91,179,199],[95,183,203],[99,185,204],[100,183,203],[95,180,201],[94,181,200],[109,187,204],[141,187,199],[169,195,189],[103,151,114],[83,143,94],[80,142,92],[80,143,92],[80,143,92],[79,142,91],[81,141,92],[82,141,91],[81,139,90],[81,140,88],[84,141,89],[92,142,95],[104,148,107],[117,154,119],[130,161,132],[146,171,150],[203,192,183],[197,184,170],[192,177,160],[188,169,149],[184,161,137],[179,150,122],[176,140,102],[177,133,89],[178,131,87],[178,131,87],[173,135,98],[184,168,154],[112,123,126],[104,114,117],[106,116,119],[107,120,121],[111,124,125],[114,128,128],[116,129,129],[115,126,128],[112,123,126],[113,127,129],[141,150,156],[164,144,120],[176,130,84],[177,129,80],[177,129,78],[178,130,78],[177,129,77],[176,129,77],[176,129,77],[176,129,76],[176,128,76],[177,128,76],[176,128,76],[178,128,77],[177,129,78],[176,128,79],[176,127,78],[176,127,77],[174,128,77],[172,129,86],[182,155,127],[180,142,137],[176,119,116],[178,117,113],[178,116,112],[180,116,113],[180,116,114],[179,115,114],[179,115,114],[177,118,116],[185,143,143],[154,133,140],[140,88,99],[136,73,86],[139,66,74],[139,57,62],[139,51,54],[140,48,52],[145,50,55],[149,52,59],[147,52,60],[146,52,61],[148,53,62],[150,51,59],[148,48,56],[145,48,57],[142,48,55],[142,48,55],[144,50,59],[146,51,59],[146,50,57],[144,50,56],[141,51,53],[140,52,56],[140,52,58],[135,52,56],[127,56,58],[121,63,63],[119,77,70],[133,133,120],[200,179,183],[182,124,122],[187,123,118],[187,124,119],[187,123,120],[186,122,121],[186,122,121],[186,122,120],[186,122,119],[186,122,119],[186,122,118],[186,122,118],[187,124,120],[187,123,119],[187,123,119],[187,124,120],[187,124,120],[187,124,119],[188,125,120],[188,124,122],[187,124,120],[186,123,121],[183,125,126],[193,158,163],[158,182,164],[104,149,111],[86,145,99],[83,147,100],[81,146,99],[81,147,99],[83,147,100],[83,147,100],[80,147,102],[75,144,102],[64,146,122],[74,171,183],[61,169,193],[70,183,209],[65,181,209],[71,180,207],[102,194,217],[81,182,207],[101,192,214],[111,196,216],[104,192,213],[101,191,213],[105,194,214],[104,193,215],[92,192,214],[70,183,207],[71,171,194],[75,167,186],[95,183,204],[133,200,217],[150,203,218],[138,197,210],[144,201,216],[129,191,208],[160,206,219],[122,183,199],[88,164,184],[106,182,199],[114,195,213],[103,189,208],[108,193,211],[105,191,210],[106,190,210],[108,192,211],[104,191,210],[99,187,207],[95,184,204],[97,185,204],[100,188,207],[101,188,207],[99,185,206],[99,184,203],[108,186,202],[135,184,197],[167,193,187],[103,150,114],[83,143,93],[81,143,92],[81,143,92],[81,143,92],[80,142,92],[80,141,92],[81,141,91],[81,140,90],[79,139,88],[78,141,88],[80,141,86],[84,141,89],[88,141,92],[93,143,96],[99,143,101],[110,148,111],[130,159,131],[164,182,165],[197,184,170],[189,169,149],[184,157,133],[178,147,117],[175,141,105],[174,138,98],[176,134,92],[178,133,90],[177,132,85],[178,130,84],[176,131,86],[177,131,89],[175,140,110],[186,172,162],[119,129,132],[103,112,114],[106,117,119],[107,120,122],[110,125,126],[114,128,128],[112,126,126],[109,122,125],[113,127,130],[158,145,127],[172,133,91],[176,129,79],[178,130,80],[178,131,78],[178,130,78],[178,130,78],[178,129,78],[178,129,78],[179,130,78],[179,129,78],[178,129,77],[179,129,78],[178,130,78],[177,129,78],[177,128,79],[177,128,79],[176,127,80],[175,127,81],[172,133,90],[186,173,149],[188,160,163],[178,136,133],[176,120,116],[178,117,115],[177,116,114],[178,116,114],[178,116,114],[179,115,114],[177,116,114],[177,116,114],[178,119,116],[183,137,138],[160,127,129],[161,119,121],[161,116,116],[160,109,107],[154,101,92],[153,96,86],[154,92,83],[155,88,80],[157,84,81],[157,78,79],[156,74,76],[155,70,73],[153,67,69],[149,65,66],[144,60,60],[142,60,59],[145,60,63],[147,62,63],[145,62,63],[142,62,62],[129,61,52],[126,63,55],[129,73,66],[137,91,86],[146,116,110],[136,126,107],[104,122,83],[122,153,118],[168,191,176],[198,174,177],[182,124,122],[187,124,118],[187,124,119],[187,123,120],[187,123,121],[186,122,120],[186,122,119],[185,121,118],[186,121,118],[186,122,118],[186,122,119],[187,124,120],[186,122,119],[187,122,119],[187,123,119],[187,123,120],[187,124,120],[187,124,121],[187,123,122],[185,124,121],[184,123,124],[182,131,137],[202,182,191],[165,186,171],[112,152,121],[90,144,101],[84,147,97],[82,147,100],[81,146,99],[82,147,100],[83,147,101],[85,147,100],[81,148,102],[75,146,102],[65,145,122],[79,174,186],[65,172,196],[67,182,209],[64,181,209],[69,180,208],[94,191,215],[78,182,207],[103,193,215],[113,198,217],[104,192,212],[101,191,212],[103,193,212],[103,194,213],[90,191,212],[74,184,208],[72,172,194],[74,166,185],[93,181,202],[133,200,216],[156,205,220],[143,197,212],[147,201,216],[134,193,208],[164,207,219],[130,187,201],[96,167,184],[112,183,198],[122,197,214],[104,190,208],[108,192,211],[107,192,211],[106,191,210],[109,193,211],[106,191,210],[100,188,208],[95,185,205],[97,186,205],[100,189,208],[99,188,207],[100,187,206],[104,186,204],[114,188,203],[138,188,198],[165,194,186],[104,151,113],[83,143,92],[82,143,92],[82,143,93],[82,143,92],[82,143,92],[81,142,92],[81,142,91],[81,140,90],[80,140,90],[80,141,89],[81,141,88],[85,141,90],[86,141,90],[87,143,92],[88,142,92],[92,142,95],[98,142,99],[112,146,113],[153,172,153],[198,187,176],[189,166,144],[178,147,115],[174,137,98],[175,131,89],[178,132,87],[180,133,86],[181,134,86],[179,133,83],[178,131,81],[179,131,81],[179,131,82],[178,131,84],[176,130,89],[177,146,119],[182,170,160],[100,112,112],[104,118,118],[110,124,123],[111,124,122],[110,122,123],[114,127,130],[153,145,132],[170,137,103],[177,130,81],[178,131,80],[179,131,80],[179,130,80],[178,130,79],[178,130,78],[179,130,78],[180,129,78],[180,129,78],[180,129,78],[180,130,78],[179,130,78],[178,130,78],[177,129,77],[177,130,78],[176,128,79],[176,127,79],[174,128,81],[175,145,108],[183,153,156],[180,136,139],[178,124,126],[178,118,119],[177,116,115],[177,116,114],[178,117,114],[178,117,115],[179,117,114],[178,117,113],[179,118,113],[179,118,116],[179,119,116],[178,135,134],[171,190,183],[167,191,179],[170,192,180],[168,168,151],[148,153,123],[142,145,109],[143,142,108],[148,140,108],[158,139,117],[167,140,125],[169,134,125],[166,128,122],[157,123,111],[147,116,100],[141,110,92],[139,111,91],[147,118,101],[151,120,108],[151,122,110],[138,124,103],[109,118,81],[105,120,80],[125,140,106],[150,165,139],[165,183,160],[124,166,122],[74,140,71],[92,151,92],[143,183,149],[196,170,174],[180,123,121],[186,124,120],[187,124,119],[187,123,120],[186,123,121],[186,122,119],[185,122,118],[184,121,117],[185,122,118],[186,122,119],[186,122,119],[187,124,120],[186,123,119],[187,124,120],[187,124,120],[187,124,121],[187,124,122],[187,125,123],[186,124,123],[185,125,125],[181,129,135],[190,159,169],[163,186,169],[116,154,123],[93,144,104],[87,146,100],[83,146,98],[82,147,100],[82,147,100],[82,147,100],[83,148,101],[85,147,101],[81,147,103],[76,145,102],[67,145,121],[84,176,189],[68,172,197],[68,182,209],[62,180,207],[69,182,208],[88,189,213],[74,181,204],[101,192,214],[111,197,216],[103,192,213],[101,191,213],[102,192,213],[101,193,212],[90,189,212],[77,183,208],[76,173,194],[74,166,183],[96,183,204],[135,200,216],[165,206,219],[159,202,215],[159,204,217],[136,193,208],[166,207,218],[140,191,203],[103,168,183],[120,184,197],[132,200,215],[105,190,208],[108,192,210],[109,193,211],[107,191,210],[109,192,209],[107,191,209],[100,188,207],[95,185,205],[97,186,205],[99,188,207],[98,189,208],[97,188,207],[103,186,205],[114,187,204],[134,186,198],[165,194,187],[104,151,114],[85,142,93],[82,143,92],[82,143,92],[82,143,93],[82,143,93],[82,143,93],[82,143,92],[81,142,91],[80,140,89],[80,141,88],[81,141,88],[84,141,89],[85,141,91],[85,141,90],[85,141,90],[88,141,93],[90,142,96],[92,140,97],[108,144,108],[198,186,176],[181,154,126],[178,137,94],[179,132,82],[180,132,82],[181,132,81],[181,133,82],[182,133,83],[182,133,82],[182,133,83],[180,132,84],[178,132,82],[178,131,83],[179,131,85],[176,131,90],[178,151,126],[175,163,154],[106,114,118],[99,110,113],[101,113,115],[108,119,120],[108,120,120],[110,121,122],[117,129,130],[126,135,140],[171,141,110],[177,131,82],[178,132,80],[179,132,80],[178,132,79],[177,131,79],[177,130,78],[179,130,78],[180,129,78],[180,130,79],[179,130,78],[178,130,78],[179,129,78],[179,130,78],[178,130,78],[177,129,77],[176,128,77],[177,128,79],[177,129,80],[172,134,92],[190,182,168],[190,169,171],[183,149,151],[179,134,133],[175,123,122],[175,119,118],[177,117,117],[177,116,115],[178,117,114],[178,117,113],[178,117,115],[178,116,114],[179,118,114],[179,118,114],[180,118,115],[180,119,117],[179,120,116],[176,131,129],[155,183,167],[142,180,155],[140,181,153],[131,175,142],[124,169,131],[126,170,133],[138,179,144],[133,175,136],[104,160,102],[92,155,90],[94,154,91],[105,156,98],[130,165,120],[146,174,141],[151,178,147],[145,175,143],[131,170,130],[123,166,122],[119,163,117],[122,163,118],[136,169,131],[146,172,141],[149,174,143],[126,165,123],[89,148,87],[90,152,87],[105,164,106],[119,171,123],[121,174,126],[70,148,78],[44,135,49],[65,146,69],[121,172,128],[194,166,169],[180,122,120],[186,124,120],[187,124,120],[187,124,120],[187,124,120],[186,123,120],[185,122,118],[184,122,116],[186,121,117],[186,121,120],[186,122,121],[185,121,120],[186,122,121],[187,123,122],[187,124,123],[185,125,124],[183,126,127],[182,127,129],[179,127,128],[181,136,140],[189,160,169],[158,181,163],[115,153,118],[91,144,100],[87,147,100],[87,148,100],[84,147,99],[84,147,101],[83,147,100],[83,146,100],[84,147,101],[83,148,102],[81,147,102],[76,145,102],[72,146,122],[100,180,193],[76,172,197],[71,182,210],[63,180,208],[69,182,208],[87,189,211],[79,181,205],[103,191,212],[111,197,216],[102,192,213],[99,191,212],[101,192,213],[100,192,213],[90,190,211],[81,184,207],[80,175,194],[78,165,183],[99,183,203],[136,199,214],[179,210,220],[178,208,218],[170,206,217],[140,193,207],[166,206,217],[154,195,206],[117,172,183],[136,186,196],[146,202,215],[107,190,208],[111,193,211],[114,193,212],[109,191,208],[110,190,209],[110,191,209],[104,189,207],[97,185,204],[95,185,205],[99,187,206],[101,188,206],[98,187,205],[103,188,206],[113,188,203],[131,186,196],[163,194,188],[106,150,117],[83,143,93],[82,143,92],[82,143,92],[82,142,92],[82,143,92],[82,142,92],[81,141,91],[81,141,91],[81,141,90],[80,141,90],[81,141,89],[83,142,90],[85,142,91],[84,141,90],[85,141,90],[88,141,93],[87,143,93],[86,143,94],[89,141,95],[125,153,126],[188,166,145],[174,136,98],[178,133,86],[180,132,81],[181,132,81],[181,132,80],[181,132,80],[182,133,81],[182,133,81],[182,133,84],[181,133,85],[179,133,82],[178,131,82],[178,132,84],[175,133,89],[177,152,127],[160,148,138],[173,145,116],[177,131,84],[178,132,81],[179,132,83],[179,133,82],[178,132,81],[177,131,79],[178,130,79],[179,131,79],[179,130,78],[179,130,78],[178,130,78],[178,130,78],[179,130,78],[179,131,79],[178,130,78],[176,128,77],[176,128,79],[176,128,79],[174,131,87],[180,165,144],[193,171,171],[181,145,143],[174,129,127],[175,122,119],[176,119,117],[177,118,116],[177,116,114],[178,116,115],[177,117,114],[178,117,114],[178,117,114],[179,117,114],[180,117,114],[179,117,113],[180,118,114],[181,118,116],[180,119,117],[179,120,116],[178,128,127],[137,177,152],[116,171,131],[96,161,108],[64,141,74],[58,137,68],[67,146,77],[83,160,91],[82,159,88],[58,147,64],[47,144,56],[47,144,57],[62,147,66],[88,162,92],[103,173,110],[109,178,116],[102,172,110],[93,169,102],[91,168,102],[88,163,97],[87,162,95],[96,167,105],[106,171,115],[110,170,117],[92,162,100],[69,151,76],[67,152,76],[65,149,75],[67,146,78],[59,144,71],[37,139,51],[30,136,41],[48,144,58],[108,168,117],[162,185,170],[193,163,166],[180,121,117],[187,124,120],[187,123,120],[187,124,120],[186,123,119],[186,123,119],[186,123,117],[186,123,117],[186,122,118],[186,123,118],[186,122,121],[185,122,122],[184,125,126],[181,128,131],[181,133,135],[181,139,140],[182,145,147],[186,151,156],[194,165,168],[205,184,188],[154,174,156],[114,152,118],[93,147,100],[85,147,97],[86,148,99],[87,148,100],[85,147,99],[85,147,99],[85,148,99],[84,147,99],[85,147,99],[85,148,101],[82,148,102],[76,146,101],[84,149,122],[125,186,193],[78,171,191],[77,183,207],[65,180,204],[70,181,204],[93,187,208],[86,183,206],[105,192,211],[112,197,216],[101,192,212],[98,192,212],[100,192,213],[97,190,212],[87,187,207],[83,184,205],[84,174,192],[86,167,184],[103,185,203],[138,198,214],[190,212,221],[195,213,220],[180,208,218],[143,192,207],[166,203,214],[170,200,208],[142,178,187],[158,191,199],[161,205,217],[110,189,206],[115,193,211],[119,195,212],[111,190,207],[110,190,207],[110,191,207],[104,188,205],[98,184,203],[96,184,204],[100,187,203],[104,187,204],[104,187,204],[106,187,203],[116,188,203],[133,185,195],[163,195,188],[107,152,119],[84,143,94],[82,143,92],[83,142,93],[81,141,91],[82,143,93],[82,143,93],[82,143,92],[81,141,92],[81,141,91],[79,141,91],[80,141,91],[83,142,91],[84,142,92],[83,141,91],[83,142,90],[87,143,92],[87,142,95],[84,141,95],[86,142,96],[111,146,116],[184,156,134],[177,133,90],[179,133,85],[181,133,82],[181,133,82],[182,133,81],[182,134,82],[182,134,82],[182,133,81],[183,133,83],[181,133,83],[181,133,83],[179,132,82],[178,132,84],[176,135,91],[173,148,122],[142,132,123],[175,151,122],[176,131,84],[177,132,81],[178,132,83],[179,133,86],[178,133,84],[178,132,82],[178,131,81],[178,131,78],[177,129,77],[177,129,77],[178,130,78],[178,130,80],[179,130,80],[180,131,81],[179,131,80],[177,129,79],[176,129,79],[175,128,79],[174,130,85],[176,153,126],[188,155,154],[175,129,127],[173,120,117],[176,119,115],[176,118,113],[177,118,114],[177,116,113],[177,117,114],[178,117,114],[178,117,114],[178,118,114],[178,117,114],[180,117,114],[180,118,114],[181,118,115],[182,119,115],[182,119,116],[180,118,116],[181,118,117],[180,123,126],[195,176,176],[134,173,146],[105,166,115],[69,150,81],[28,127,44],[19,123,39],[23,130,42],[35,139,48],[34,139,50],[28,136,44],[26,135,41],[24,134,42],[31,137,47],[53,148,66],[66,156,77],[67,157,79],[61,155,74],[58,154,71],[61,155,75],[55,151,71],[52,148,68],[53,148,71],[56,146,71],[61,146,75],[59,149,73],[61,151,71],[55,149,68],[50,147,65],[46,145,63],[35,142,56],[23,138,46],[27,137,44],[39,144,58],[104,167,116],[161,184,168],[190,158,159],[183,121,118],[185,122,119],[187,123,120],[187,123,120],[187,124,120],[187,124,118],[187,124,118],[187,123,118],[186,122,118],[186,122,120],[185,123,122],[180,126,128],[183,142,146],[191,160,166],[202,179,183],[148,170,151],[110,146,114],[94,145,103],[90,148,98],[86,148,98],[86,149,100],[86,149,101],[85,148,100],[86,147,98],[84,147,99],[84,147,99],[84,147,100],[83,148,100],[81,148,100],[81,147,101],[97,154,123],[133,190,193],[81,168,187],[92,186,208],[86,182,203],[82,180,202],[101,189,209],[88,182,203],[104,189,209],[116,198,216],[104,191,211],[102,190,210],[102,192,212],[99,191,211],[93,190,209],[87,186,205],[90,173,190],[92,169,184],[103,182,197],[142,198,212],[193,212,219],[184,209,216],[145,192,205],[166,201,210],[183,204,210],[162,184,190],[170,192,199],[167,207,217],[113,189,206],[115,192,208],[123,197,213],[114,191,207],[110,189,205],[111,189,205],[106,186,202],[100,184,202],[98,182,201],[99,185,201],[102,186,202],[105,187,204],[108,188,204],[117,189,202],[129,179,187],[161,192,185],[106,151,118],[83,143,94],[82,143,93],[83,142,93],[81,141,91],[81,141,91],[82,142,92],[81,143,91],[81,141,91],[81,141,93],[81,141,93],[81,141,93],[83,140,93],[83,141,91],[84,142,93],[84,143,93],[85,142,94],[85,141,93],[86,141,95],[89,143,98],[110,146,116],[186,163,145],[177,133,93],[179,132,87],[181,133,84],[181,134,84],[183,135,83],[182,135,83],[183,135,84],[183,134,82],[183,133,83],[182,133,83],[182,133,83],[180,132,83],[178,132,86],[175,136,94],[168,146,122],[134,127,118],[181,156,137],[177,132,86],[178,132,82],[178,134,88],[176,136,99],[175,138,103],[175,136,100],[173,133,93],[176,132,85],[177,130,81],[177,129,78],[177,129,78],[178,130,80],[179,131,81],[179,130,81],[178,131,81],[178,130,80],[176,129,80],[174,128,80],[173,130,86],[174,148,118],[187,153,153],[176,124,124],[175,118,117],[176,117,114],[176,117,114],[176,116,113],[177,116,112],[177,116,112],[176,117,113],[177,117,114],[178,117,114],[178,117,114],[179,119,114],[178,118,113],[179,118,114],[182,119,115],[182,119,115],[182,119,116],[181,117,115],[181,118,115],[180,125,124],[193,171,172],[126,171,140],[100,166,115],[68,153,85],[25,126,46],[9,119,33],[13,124,34],[17,129,38],[15,131,39],[16,132,39],[18,134,40],[19,133,42],[27,138,48],[45,149,62],[57,156,71],[54,153,68],[46,149,64],[44,147,61],[43,147,61],[42,148,63],[46,150,67],[39,146,62],[37,142,60],[44,143,62],[55,152,72],[56,150,71],[50,148,66],[54,150,69],[47,148,67],[36,146,62],[30,143,57],[30,140,55],[53,147,73],[114,169,124],[190,152,154],[185,121,118],[186,123,119],[187,124,120],[188,123,120],[187,123,120],[188,123,119],[187,124,118],[187,124,120],[187,122,120],[187,123,121],[183,125,126],[186,148,153],[149,169,154],[106,147,115],[95,147,106],[90,147,101],[87,147,97],[87,148,98],[87,149,100],[86,147,100],[86,147,99],[87,147,99],[86,146,100],[85,147,100],[85,147,99],[83,147,99],[81,147,99],[83,148,100],[102,157,126],[133,190,191],[89,169,185],[109,187,203],[123,194,209],[106,183,200],[112,190,207],[94,181,199],[106,185,202],[122,195,213],[107,185,203],[103,184,201],[104,189,205],[97,185,202],[94,185,203],[91,185,202],[91,170,184],[99,173,184],[107,178,189],[152,197,206],[190,209,212],[182,205,210],[145,188,196],[155,191,196],[183,205,210],[167,185,189],[170,189,191],[171,207,214],[118,186,198],[113,187,200],[132,197,210],[123,187,199],[119,187,199],[115,185,197],[105,179,191],[100,179,193],[96,176,190],[98,179,192],[104,183,196],[107,183,197],[115,188,203],[120,188,200],[123,172,179],[156,187,180],[107,152,119],[83,142,94],[83,144,94],[82,143,93],[81,141,91],[81,142,91],[82,143,92],[81,143,92],[81,142,92],[81,140,92],[81,140,93],[82,141,94],[82,141,92],[83,141,92],[82,140,92],[83,142,93],[85,142,94],[86,142,94],[88,142,97],[91,142,101],[117,151,128],[196,182,174],[176,140,108],[180,135,92],[182,134,86],[181,135,86],[182,135,84],[181,135,84],[183,135,85],[182,135,84],[183,134,85],[182,133,83],[182,133,85],[180,134,83],[179,133,86],[175,137,97],[165,144,121],[147,137,127],[116,128,129],[121,134,134],[180,159,144],[175,133,90],[176,132,85],[175,136,98],[179,150,124],[184,161,141],[188,164,144],[180,155,129],[176,142,107],[175,134,92],[176,132,84],[177,130,81],[177,130,81],[178,131,82],[178,130,82],[178,131,81],[178,131,81],[177,130,83],[176,129,84],[173,132,89],[176,150,123],[189,163,163],[174,123,123],[177,118,118],[175,116,115],[175,116,114],[175,116,112],[176,115,112],[176,115,112],[177,116,113],[176,116,113],[177,117,113],[177,117,113],[179,119,114],[179,119,114],[178,118,114],[179,118,115],[181,119,116],[182,118,115],[182,118,116],[182,118,115],[181,120,114],[178,124,120],[194,165,166],[128,171,143],[112,171,130],[81,158,101],[32,128,57],[10,118,32],[13,124,34],[13,129,37],[12,129,37],[12,130,38],[13,131,39],[20,133,44],[26,139,51],[43,148,63],[54,155,72],[50,152,69],[43,148,65],[40,146,61],[33,144,59],[36,146,61],[46,150,68],[32,141,58],[26,138,53],[40,143,59],[58,153,76],[54,150,72],[45,143,66],[58,151,76],[62,152,82],[66,156,89],[65,156,87],[56,147,76],[83,156,99],[135,177,145],[191,147,150],[183,120,117],[186,122,119],[188,124,121],[188,122,121],[187,122,119],[187,123,120],[187,124,119],[187,124,120],[186,123,120],[187,124,121],[186,134,136],[209,188,196],[162,182,168],[106,149,113],[93,147,104],[89,148,102],[88,148,102],[86,147,101],[87,147,102],[88,147,104],[88,148,104],[89,147,102],[89,147,101],[86,146,101],[85,148,99],[85,147,101],[85,147,100],[83,147,100],[85,147,101],[102,156,123],[127,183,177],[98,167,172],[121,182,187],[147,197,203],[127,183,191],[120,187,194],[102,177,186],[107,177,184],[126,190,197],[112,179,186],[107,176,182],[107,180,186],[91,170,177],[87,169,175],[92,175,179],[90,165,169],[106,172,177],[118,173,176],[151,188,185],[166,192,187],[130,175,173],[129,172,167],[170,195,190],[161,183,176],[156,179,173],[162,197,193],[107,172,171],[102,172,172],[131,188,188],[128,178,179],[129,184,184],[119,178,179],[102,168,169],[99,172,176],[96,169,174],[100,171,177],[117,186,193],[118,182,189],[127,188,195],[125,185,191],[120,169,172],[146,178,170],[107,152,119],[83,143,96],[82,143,93],[82,143,93],[83,143,93],[83,143,94],[86,144,96],[86,144,95],[85,143,95],[84,142,95],[83,141,96],[84,141,95],[84,141,94],[84,141,95],[84,142,95],[84,142,94],[85,142,96],[86,141,95],[92,141,100],[101,143,113],[142,167,154],[189,163,145],[178,138,101],[178,134,88],[182,134,89],[181,135,86],[182,134,86],[183,135,84],[183,135,85],[181,134,86],[180,134,84],[180,134,85],[181,133,85],[179,132,85],[175,136,96],[166,144,120],[158,148,135],[108,122,122],[109,122,122],[116,130,130],[117,129,130],[182,161,146],[174,132,93],[173,132,89],[178,146,116],[190,174,160],[194,179,164],[187,159,136],[180,142,105],[177,134,89],[177,131,83],[177,131,81],[178,130,81],[179,131,82],[177,131,81],[177,130,83],[175,131,87],[171,135,100],[177,157,139],[174,132,129],[176,116,118],[175,116,116],[175,115,114],[175,116,114],[175,115,112],[176,115,112],[177,116,112],[177,116,113],[175,116,112],[177,117,114],[178,119,116],[179,119,117],[179,118,114],[178,118,114],[180,120,116],[182,120,117],[183,120,117],[182,119,116],[182,120,116],[184,120,117],[182,125,121],[191,158,158],[144,177,158],[136,182,154],[105,169,126],[55,143,81],[22,124,45],[13,123,37],[13,128,38],[12,129,37],[9,127,35],[13,128,38],[20,133,45],[26,140,52],[42,149,65],[51,153,71],[47,152,68],[39,146,63],[40,145,62],[34,141,57],[45,149,68],[54,154,77],[37,143,63],[28,137,54],[42,142,63],[67,156,87],[69,155,90],[65,149,87],[82,159,105],[99,164,119],[122,178,141],[123,181,142],[100,165,119],[120,171,135],[158,185,166],[189,141,143],[185,122,119],[186,123,119],[188,123,122],[188,123,120],[187,122,119],[187,122,119],[187,123,120],[187,124,120],[188,125,119],[186,125,120],[189,142,141],[126,156,136],[95,146,108],[91,148,105],[89,148,103],[89,148,104],[89,147,104],[95,149,110],[104,150,121],[110,155,126],[108,153,124],[102,150,117],[92,148,108],[85,146,101],[85,147,101],[85,147,101],[86,148,101],[88,147,102],[96,152,114],[110,165,145],[102,159,146],[118,165,152],[134,172,158],[125,168,153],[117,166,152],[105,161,146],[108,163,148],[114,167,152],[110,163,149],[105,161,146],[97,160,143],[84,154,134],[87,154,134],[90,157,137],[93,156,134],[106,162,141],[115,162,140],[127,167,144],[138,170,146],[131,164,138],[126,164,140],[104,156,134],[102,155,131],[130,168,146],[132,167,145],[125,162,140],[122,165,145],[90,153,137],[86,150,133],[106,158,140],[112,158,141],[115,161,145],[110,162,145],[95,154,138],[88,154,139],[92,155,141],[101,157,145],[113,166,151],[115,165,151],[115,167,152],[107,163,147],[106,158,141],[118,162,140],[99,149,112],[85,143,97],[85,143,97],[85,143,98],[85,143,99],[91,142,104],[101,146,114],[107,148,117],[105,149,116],[100,145,113],[95,141,108],[91,140,104],[90,141,103],[90,141,102],[90,141,102],[91,141,102],[90,142,102],[92,141,103],[106,147,116],[130,163,143],[198,175,158],[189,157,126],[183,148,117],[181,144,113],[182,144,113],[182,145,112],[180,142,105],[180,137,94],[181,134,87],[180,133,82],[182,133,82],[181,132,82],[179,133,89],[172,142,109],[166,152,133],[107,120,120],[107,120,120],[114,126,127],[116,128,129],[112,124,124],[107,118,119],[113,123,127],[185,164,146],[173,132,94],[173,135,94],[184,162,139],[192,178,165],[182,159,132],[176,144,108],[175,135,94],[176,133,88],[179,133,88],[178,133,89],[177,132,90],[174,133,94],[172,142,116],[183,169,160],[187,168,166],[172,121,119],[176,116,116],[176,116,114],[175,116,113],[176,116,113],[176,115,112],[176,115,111],[177,116,113],[176,116,113],[176,117,114],[176,117,114],[178,119,116],[178,120,115],[179,119,115],[179,121,118],[180,123,119],[179,122,118],[180,122,118],[181,121,118],[181,120,117],[184,122,119],[183,125,122],[188,155,155],[165,187,178],[165,196,181],[138,187,160],[94,165,120],[52,142,79],[29,132,55],[22,131,46],[15,131,42],[13,130,41],[17,132,45],[33,139,56],[44,146,67],[56,153,77],[55,155,78],[53,153,76],[49,147,71],[61,151,82],[65,150,88],[81,158,102],[95,166,112],[80,157,98],[68,148,85],[74,151,92],[98,164,118],[111,169,129],[117,173,135],[136,184,153],[155,193,172],[175,204,191],[170,201,184],[150,185,163],[160,188,169],[185,135,134],[186,123,120],[187,124,120],[189,124,122],[188,123,120],[188,123,120],[187,123,120],[187,124,120],[187,124,119],[187,124,119],[188,125,119],[187,136,132],[205,183,184],[121,154,136],[95,147,110],[93,150,108],[93,148,108],[93,148,109],[99,150,116],[116,158,133],[142,172,159],[156,183,173],[158,186,175],[146,179,164],[123,167,141],[96,150,113],[85,146,102],[85,147,100],[87,147,100],[89,147,100],[91,148,102],[91,150,107],[92,150,111],[101,151,115],[105,150,114],[102,150,112],[102,150,113],[98,150,113],[96,149,112],[96,149,112],[96,149,112],[95,150,112],[86,146,108],[80,144,106],[84,146,109],[86,147,109],[86,147,109],[92,149,110],[97,148,109],[99,147,109],[102,147,112],[102,147,111],[98,146,109],[83,141,104],[83,142,105],[95,146,109],[98,146,110],[94,146,109],[91,145,108],[82,144,107],[79,143,103],[89,144,105],[95,146,106],[96,147,107],[93,147,107],[87,144,105],[85,144,106],[87,144,106],[90,146,106],[93,147,107],[93,147,107],[92,148,107],[89,148,109],[90,148,110],[93,149,109],[89,145,100],[86,144,97],[85,144,98],[87,143,98],[92,143,107],[115,155,132],[146,173,159],[161,185,173],[162,189,174],[155,183,167],[143,174,158],[131,166,146],[120,158,135],[113,154,128],[113,153,127],[113,153,128],[119,158,134],[129,166,142],[155,180,165],[194,180,172],[193,177,169],[192,177,168],[190,171,161],[183,154,134],[178,137,101],[180,133,86],[181,133,83],[181,133,82],[180,133,85],[177,137,97],[170,151,126],[163,157,147],[108,119,120],[107,120,120],[112,124,125],[116,128,129],[115,127,128],[111,123,124],[104,115,116],[109,121,124],[140,150,157],[181,164,147],[173,134,93],[173,139,101],[189,175,161],[187,175,164],[178,156,135],[173,143,113],[172,138,105],[172,136,105],[171,137,106],[170,140,113],[177,156,140],[179,149,147],[175,117,118],[176,116,116],[175,116,114],[175,117,113],[175,116,113],[176,115,111],[177,116,113],[177,116,113],[175,117,113],[176,118,115],[178,119,118],[178,120,118],[176,120,118],[174,121,119],[175,124,124],[177,131,130],[181,135,132],[180,132,131],[179,124,123],[180,120,118],[182,121,119],[182,124,123],[185,152,152],[176,201,190],[148,189,165],[115,171,135],[80,153,97],[49,140,69],[37,137,61],[45,140,67],[66,150,87],[87,158,108],[99,164,119],[101,168,121],[91,163,111],[86,161,107],[84,158,104],[108,167,129],[126,175,145],[147,189,162],[157,197,171],[141,184,155],[132,178,145],[135,180,150],[151,190,168],[165,197,180],[172,199,185],[177,201,191],[196,178,177],[187,151,151],[184,128,126],[187,125,121],[187,124,120],[187,124,120],[187,124,119],[187,124,120],[187,124,120],[187,124,120],[188,124,122],[188,124,121],[189,125,121],[186,126,123],[194,151,150],[144,173,164],[102,148,119],[99,149,116],[100,147,117],[109,152,125],[133,168,151],[167,191,185],[181,204,199],[135,173,155],[91,148,109],[86,149,101],[86,149,100],[88,148,98],[91,149,99],[89,149,101],[87,149,104],[91,148,106],[94,147,105],[97,147,104],[94,148,104],[90,147,102],[92,146,103],[92,146,102],[94,147,102],[92,146,102],[87,146,102],[83,146,102],[84,146,103],[86,145,102],[85,146,102],[86,146,100],[90,146,100],[91,145,100],[93,146,104],[95,146,105],[89,145,100],[80,143,97],[80,142,98],[87,144,99],[89,144,100],[85,143,99],[83,143,98],[83,144,99],[80,144,98],[83,144,98],[88,144,99],[89,143,98],[87,143,97],[85,142,98],[83,143,97],[83,143,96],[85,143,96],[85,142,97],[85,141,97],[85,143,96],[84,144,96],[83,144,97],[85,144,97],[85,144,96],[86,144,96],[86,144,98],[88,142,100],[106,150,122],[156,185,173],[176,198,193],[176,195,191],[177,197,192],[188,161,140],[178,134,90],[180,134,84],[180,134,83],[181,134,85],[178,136,91],[175,150,123],[167,160,150],[111,122,123],[111,124,124],[117,131,131],[120,133,134],[117,130,132],[112,125,126],[104,115,116],[104,116,118],[177,164,149],[172,133,94],[174,139,103],[193,181,169],[198,184,173],[189,171,156],[184,163,149],[184,162,148],[189,171,157],[196,184,176],[175,139,139],[176,117,118],[175,115,115],[175,116,114],[174,116,113],[175,115,113],[177,116,113],[177,116,114],[176,116,113],[176,117,114],[178,119,118],[178,121,122],[175,122,123],[176,128,129],[185,145,146],[196,163,164],[207,178,180],[212,187,189],[204,175,178],[184,141,142],[181,123,121],[184,123,121],[183,124,124],[186,144,143],[168,190,178],[136,174,145],[108,156,115],[99,150,106],[109,159,118],[133,173,147],[148,184,164],[157,191,173],[157,194,172],[142,183,156],[139,184,153],[142,184,156],[166,196,182],[183,204,195],[190,170,170],[187,153,152],[185,137,135],[185,127,124],[186,125,121],[187,125,121],[188,125,121],[188,125,121],[188,125,121],[188,125,121],[188,125,121],[188,125,121],[188,125,121],[188,125,121],[189,125,122],[187,125,123],[185,132,130],[202,170,170],[136,169,156],[124,161,144],[134,165,151],[160,183,176],[180,202,202],[108,156,131],[88,148,103],[88,148,102],[89,148,102],[91,148,100],[90,148,103],[89,148,103],[91,147,104],[96,147,106],[95,147,104],[91,147,102],[88,147,100],[89,146,101],[91,147,101],[91,146,101],[90,146,100],[87,146,100],[84,146,101],[86,146,102],[87,146,102],[85,146,101],[85,146,100],[88,147,100],[90,146,100],[90,145,101],[90,144,101],[87,145,101],[84,144,100],[85,145,100],[86,145,100],[86,144,100],[85,144,99],[84,144,99],[83,145,100],[85,145,101],[85,144,100],[86,145,98],[87,144,97],[86,143,98],[86,143,99],[85,143,98],[85,143,97],[85,143,98],[85,142,97],[86,142,97],[86,143,97],[85,144,95],[83,144,94],[83,144,94],[84,145,95],[86,143,96],[86,144,99],[91,143,105],[132,169,150],[204,190,179],[181,141,100],[179,133,84],[179,133,83],[179,133,86],[179,134,90],[178,148,118],[171,162,152],[129,141,143],[118,131,134],[110,121,124],[105,116,119],[178,165,150],[170,134,92],[174,136,95],[190,176,160],[173,140,143],[173,117,118],[175,116,116],[176,118,116],[175,117,114],[175,116,114],[177,116,114],[177,117,116],[176,117,115],[176,119,118],[176,122,123],[178,131,134],[186,149,155],[199,171,179],[189,158,158],[180,125,121],[184,123,121],[184,123,122],[185,133,130],[190,153,154],[193,167,169],[200,178,181],[162,172,154],[161,173,153],[192,173,176],[190,164,165],[189,154,154],[187,143,141],[185,133,133],[186,129,128],[186,127,124],[186,125,123],[186,125,122],[186,126,121],[188,126,122],[188,125,121],[188,125,121],[187,124,121],[189,125,122],[188,125,121],[188,125,120],[187,125,121],[188,124,122],[188,125,123],[185,127,122],[187,144,141],[120,161,140],[88,147,104],[90,148,104],[91,148,104],[92,148,104],[93,148,105],[93,147,107],[95,146,109],[98,146,110],[94,145,107],[91,147,102],[88,148,102],[88,147,102],[88,146,101],[88,146,101],[88,146,101],[88,147,102],[86,147,102],[87,147,99],[87,146,100],[87,146,101],[85,146,99],[86,147,99],[87,146,99],[90,146,100],[91,145,102],[88,145,100],[87,145,100],[86,145,99],[86,144,99],[85,144,97],[84,143,97],[82,143,97],[83,144,97],[85,145,98],[84,144,97],[86,145,98],[86,144,97],[86,143,97],[86,143,98],[85,143,97],[85,142,97],[87,143,99],[85,142,98],[85,142,98],[86,143,97],[84,144,96],[84,145,95],[84,145,95],[84,146,96],[85,144,97],[86,143,99],[92,144,108],[157,185,173],[183,148,110],[180,133,84],[180,133,83],[180,134,86],[178,133,88],[179,147,114],[176,166,153],[188,178,168],[183,168,155],[175,158,139],[171,151,128],[171,154,135],[182,166,147],[170,133,91],[174,132,85],[187,163,132],[177,149,153],[173,122,121],[176,119,118],[175,118,117],[175,118,117],[177,119,118],[177,119,119],[176,120,122],[176,123,126],[177,132,137],[184,150,156],[195,174,182],[191,159,157],[181,124,122],[184,124,122],[184,125,122],[183,126,123],[180,129,126],[180,134,133],[182,138,138],[183,144,145],[184,151,150],[184,155,154],[180,155,151],[175,157,148],[176,161,153],[184,167,164],[198,174,176],[197,165,168],[194,156,158],[189,148,147],[185,139,138],[183,133,129],[184,129,125],[186,127,123],[188,127,125],[188,126,124],[187,126,124],[187,126,123],[186,125,123],[186,126,124],[186,128,124],[186,127,122],[187,125,120],[187,125,120],[188,125,121],[188,125,121],[188,125,121],[187,125,121],[188,125,122],[187,125,122],[187,126,120],[183,130,125],[196,168,169],[120,162,138],[88,147,103],[90,148,103],[92,149,106],[92,148,106],[94,146,108],[103,150,119],[119,161,135],[122,163,136],[107,154,124],[94,148,109],[88,148,102],[88,147,102],[89,147,102],[88,148,101],[88,148,100],[88,147,100],[88,148,100],[89,147,101],[88,147,100],[88,146,101],[89,147,102],[88,146,101],[89,147,102],[90,146,102],[91,146,102],[88,146,101],[88,146,101],[87,146,100],[85,145,98],[82,143,96],[83,144,95],[83,143,96],[84,145,97],[84,144,97],[84,144,96],[86,145,97],[87,145,97],[86,144,97],[86,143,98],[86,145,98],[88,144,98],[90,145,100],[86,143,99],[85,142,98],[85,142,96],[83,143,96],[83,144,95],[85,145,95],[84,145,95],[86,144,96],[86,142,97],[95,145,107],[170,193,182],[184,151,116],[182,135,87],[180,133,84],[180,133,87],[179,133,88],[180,145,107],[188,171,153],[165,158,145],[156,151,139],[153,150,137],[149,146,133],[186,175,162],[183,165,147],[177,156,134],[172,148,123],[171,143,113],[171,140,108],[170,145,116],[179,171,161],[184,165,141],[172,133,89],[177,132,82],[175,139,94],[193,180,156],[187,166,170],[174,132,131],[171,121,120],[174,120,119],[174,120,119],[175,120,120],[174,123,125],[176,133,139],[183,152,159],[194,175,180],[187,148,146],[181,124,120],[185,126,123],[185,126,123],[184,127,122],[185,128,124],[185,128,125],[184,128,126],[182,128,127],[181,129,127],[180,130,128],[179,132,129],[179,136,132],[178,136,133],[179,135,134],[179,134,134],[180,136,134],[183,140,137],[185,142,141],[187,144,145],[189,147,147],[193,150,151],[197,154,154],[198,154,155],[199,154,155],[200,153,153],[198,150,150],[195,147,147],[191,141,140],[187,137,135],[186,134,132],[185,130,127],[185,129,126],[184,128,125],[187,129,125],[189,128,124],[189,128,124],[189,127,125],[188,127,124],[187,126,124],[186,126,123],[187,127,124],[184,129,129],[183,134,134],[183,134,133],[183,129,125],[186,125,122],[188,125,121],[188,125,121],[188,125,122],[187,126,122],[188,125,123],[188,125,121],[187,126,122],[185,127,121],[189,148,145],[117,159,134],[89,149,104],[90,148,103],[92,149,106],[93,150,108],[99,148,115],[134,167,153],[172,195,189],[177,197,192],[156,185,174],[115,161,138],[90,147,105],[90,148,103],[88,148,102],[89,149,103],[89,148,100],[90,147,100],[90,147,100],[89,147,101],[89,147,101],[90,147,104],[94,145,109],[99,146,115],[104,149,119],[104,149,118],[101,147,114],[98,145,112],[94,144,108],[92,144,105],[89,145,101],[85,145,97],[83,144,96],[84,144,97],[84,146,98],[86,146,98],[87,145,98],[86,146,98],[87,145,97],[87,146,98],[89,147,100],[91,146,100],[90,144,102],[91,145,104],[89,147,104],[84,143,98],[83,143,94],[85,144,96],[84,144,96],[85,145,96],[87,145,97],[88,146,98],[90,144,99],[97,145,108],[171,191,180],[205,192,177],[182,149,110],[180,135,85],[182,135,82],[182,134,85],[180,134,87],[179,138,94],[189,161,131],[182,163,140],[173,159,138],[170,158,139],[166,156,136],[175,163,146],[180,167,150],[180,162,141],[177,155,130],[174,147,118],[173,142,109],[172,139,103],[174,137,100],[174,137,97],[172,141,104],[184,174,159],[191,179,166],[181,167,149],[176,162,148],[177,164,151],[176,165,152],[179,170,158],[179,170,160],[181,173,163],[179,169,154],[178,154,125],[175,131,85],[181,133,82],[178,135,83],[177,144,100],[191,179,156],[183,163,163],[176,145,146],[172,138,139],[173,138,140],[177,146,146],[184,159,162],[178,134,131],[181,124,119],[185,126,122],[184,125,121],[184,126,122],[186,127,124],[186,127,123],[186,127,123],[187,128,125],[187,128,125],[187,128,125],[187,128,125],[187,128,125],[187,128,125],[186,126,124],[186,125,122],[186,127,122],[186,128,124],[186,127,124],[186,127,123],[187,128,125],[187,128,125],[188,130,127],[188,132,129],[188,133,130],[187,131,129],[186,129,129],[188,131,130],[187,131,131],[187,130,129],[187,131,130],[188,131,128],[188,130,126],[187,127,125],[188,128,125],[187,127,123],[189,127,125],[189,127,125],[189,127,124],[188,127,124],[186,127,123],[184,127,123],[188,146,146],[203,174,180],[203,177,181],[188,148,152],[184,127,125],[188,124,121],[187,124,122],[188,124,123],[187,124,123],[187,126,124],[187,126,124],[187,125,123],[185,125,123],[187,135,136],[109,153,126],[88,148,103],[88,147,102],[90,147,104],[92,147,107],[113,155,130],[177,197,193],[161,190,184],[101,151,120],[90,146,105],[88,148,102],[89,149,103],[88,148,100],[90,148,101],[89,148,100],[89,147,100],[90,147,103],[93,146,110],[117,157,135],[144,176,160],[157,187,174],[162,191,177],[159,191,174],[153,186,168],[137,174,151],[117,159,131],[100,149,112],[88,144,100],[83,143,96],[84,144,97],[84,144,97],[86,146,98],[85,145,96],[86,145,97],[88,145,98],[91,145,101],[98,147,109],[108,149,119],[115,153,129],[120,155,134],[113,154,129],[98,145,113],[87,142,98],[85,142,96],[84,142,96],[85,145,97],[85,145,96],[86,144,95],[87,144,96],[92,146,102],[153,180,159],[198,177,153],[179,140,96],[180,134,83],[180,135,81],[181,134,82],[180,134,84],[179,134,86],[179,141,98],[179,147,111],[176,148,114],[173,148,118],[171,148,119],[172,149,119],[175,149,118],[173,145,110],[174,142,106],[174,143,107],[174,144,108],[175,142,106],[174,138,98],[175,135,91],[175,138,96],[182,162,140],[187,178,167],[162,152,140],[155,142,125],[163,155,141],[184,173,158],[186,171,153],[182,160,135],[178,151,119],[175,144,108],[172,141,106],[173,142,111],[173,145,116],[173,147,118],[173,149,121],[174,152,126],[178,157,132],[180,161,138],[181,164,143],[181,166,148],[181,169,154],[180,167,153],[177,165,148],[181,166,146],[182,164,144],[179,158,138],[175,152,127],[170,143,111],[173,137,97],[178,130,81],[179,130,79],[180,132,80],[177,133,82],[178,143,99],[193,175,152],[189,164,165],[177,127,123],[183,124,121],[185,126,123],[185,126,123],[186,127,124],[186,127,124],[186,127,124],[184,128,124],[185,129,125],[185,129,125],[185,129,125],[184,128,126],[184,128,124],[185,127,124],[185,126,123],[185,126,123],[186,127,122],[186,127,122],[186,126,122],[187,126,123],[188,127,125],[188,127,124],[190,129,125],[189,130,128],[189,131,130],[189,131,132],[190,131,132],[190,133,132],[190,132,132],[188,131,131],[188,131,131],[187,131,128],[188,128,125],[189,128,125],[187,127,124],[186,125,123],[187,125,123],[189,127,124],[188,127,124],[187,127,123],[186,125,122],[185,136,135],[205,184,191],[180,133,137],[185,124,123],[188,124,123],[188,124,123],[188,124,123],[189,125,124],[189,126,124],[188,125,125],[187,125,125],[184,128,131],[102,150,117],[92,148,105],[93,147,105],[95,148,106],[99,146,114],[147,175,163],[131,171,152],[90,146,105],[88,148,101],[89,149,103],[88,148,100],[88,147,100],[88,148,100],[90,147,102],[93,145,107],[112,156,132],[171,193,189],[170,192,186],[141,173,157],[104,150,123],[87,142,100],[86,143,97],[84,143,96],[87,145,98],[86,145,97],[86,144,97],[88,145,100],[95,144,111],[119,155,137],[148,170,163],[165,183,180],[165,186,182],[136,167,155],[96,144,113],[87,143,99],[84,143,96],[84,144,96],[86,145,97],[86,145,95],[86,144,95],[88,146,97],[120,156,124],[188,161,132],[178,136,90],[181,135,84],[181,135,84],[181,135,83],[180,135,83],[180,134,84],[180,134,82],[180,135,87],[179,136,89],[179,137,92],[177,136,95],[175,137,97],[174,138,98],[174,141,101],[178,148,115],[184,159,133],[188,171,149],[191,172,152],[177,150,120],[175,136,94],[178,134,88],[178,141,102],[183,155,123],[179,157,131],[170,150,126],[164,142,116],[166,146,122],[175,156,135],[176,157,134],[174,155,130],[173,153,128],[176,152,122],[174,147,113],[176,141,103],[176,138,95],[176,136,89],[176,135,88],[176,135,90],[176,135,92],[175,135,90],[175,137,93],[176,137,93],[175,136,94],[175,138,94],[174,138,93],[175,139,94],[174,138,96],[173,140,98],[176,139,98],[175,137,94],[176,135,92],[176,133,89],[176,132,87],[176,132,86],[178,130,83],[176,130,76],[177,131,78],[179,131,82],[179,132,80],[177,132,81],[178,142,99],[194,176,154],[177,142,142],[181,125,124],[182,125,121],[183,125,122],[185,126,123],[185,127,124],[184,128,124],[184,128,124],[185,127,125],[187,128,126],[185,128,125],[185,129,125],[185,128,125],[186,128,123],[187,127,124],[187,127,122],[186,127,122],[186,126,122],[185,126,122],[186,126,122],[187,126,123],[187,126,123],[187,126,123],[190,129,125],[188,129,126],[187,129,128],[188,132,131],[188,131,132],[188,133,133],[187,134,135],[185,133,134],[186,133,133],[186,132,129],[187,129,126],[187,127,125],[187,126,124],[186,125,123],[187,126,123],[189,127,124],[188,128,124],[187,126,124],[185,125,123],[189,150,153],[184,148,155],[183,127,127],[187,124,123],[188,125,123],[188,126,123],[189,125,124],[190,126,125],[189,126,126],[188,126,127],[182,130,133],[167,188,176],[96,147,107],[92,148,105],[93,147,105],[95,147,108],[112,152,128],[177,196,193],[163,194,185],[94,146,110],[89,148,101],[88,148,102],[88,149,101],[87,148,100],[87,148,100],[91,146,104],[101,148,119],[158,186,177],[150,177,172],[101,146,122],[87,143,100],[85,142,98],[87,145,99],[88,146,101],[87,144,100],[89,143,104],[116,154,135],[166,188,184],[133,168,151],[92,143,106],[84,142,96],[84,143,95],[85,146,97],[86,145,96],[86,145,96],[86,146,96],[97,146,101],[151,175,151],[181,148,116],[180,136,88],[182,136,84],[181,136,86],[181,136,85],[180,136,85],[180,135,84],[181,135,83],[180,134,84],[180,135,87],[180,135,89],[178,136,92],[176,137,97],[173,140,106],[178,153,128],[187,172,157],[189,170,149],[177,138,96],[180,134,85],[180,135,86],[178,138,91],[176,140,99],[171,140,104],[168,139,104],[168,140,108],[170,142,111],[171,142,111],[173,142,106],[174,141,102],[175,139,99],[176,137,93],[177,134,86],[178,134,86],[178,133,85],[178,133,82],[178,133,84],[178,133,85],[176,134,88],[176,137,90],[177,137,93],[177,137,94],[177,136,90],[177,136,87],[178,136,88],[179,137,88],[179,137,86],[179,135,84],[179,134,80],[179,134,81],[179,134,80],[178,132,79],[177,132,78],[178,131,78],[177,131,76],[178,132,78],[180,132,81],[180,133,80],[180,134,79],[178,134,82],[175,143,104],[195,182,167],[176,129,128],[182,125,123],[182,124,122],[182,124,123],[185,126,124],[185,127,125],[185,127,125],[183,127,125],[184,128,125],[184,128,126],[185,128,127],[185,130,128],[185,130,128],[187,129,127],[187,127,124],[186,127,122],[187,126,122],[187,127,122],[187,127,122],[187,126,124],[187,126,124],[187,126,123],[188,127,124],[189,128,125],[188,128,124],[187,130,128],[187,131,130],[185,131,133],[186,141,145],[194,158,162],[202,168,171],[199,163,166],[190,145,145],[185,131,127],[187,129,126],[188,127,125],[186,125,123],[186,125,123],[188,127,124],[188,127,124],[186,126,123],[183,125,125],[192,157,160],[197,171,178],[182,131,133],[186,124,124],[188,125,123],[188,126,123],[189,125,124],[189,126,125],[187,126,124],[188,126,126],[183,137,139],[146,173,156],[93,146,102],[92,148,105],[93,148,107],[95,146,112],[133,167,150],[181,204,200],[101,151,117],[90,148,101],[89,148,100],[87,150,101],[88,149,101],[88,148,101],[91,145,107],[123,161,142],[140,172,162],[93,143,110],[86,143,99],[87,145,99],[88,146,101],[88,145,101],[99,147,116],[151,179,171],[117,159,136],[88,142,102],[85,144,97],[85,145,96],[87,145,97],[87,147,98],[86,146,98],[90,147,100],[108,150,109],[178,143,111],[180,136,88],[181,135,84],[182,136,86],[180,135,85],[180,136,85],[182,136,86],[181,135,85],[181,135,83],[180,134,83],[180,135,87],[178,136,92],[172,136,100],[171,148,125],[190,178,166],[189,171,147],[179,140,97],[181,134,85],[182,135,82],[181,136,83],[180,135,87],[176,136,92],[173,138,97],[171,139,103],[172,140,106],[175,139,105],[176,137,101],[175,136,92],[177,135,90],[177,135,90],[179,134,87],[178,135,87],[178,133,85],[177,133,83],[177,133,83],[177,133,84],[175,134,88],[173,138,100],[176,147,118],[178,151,123],[178,148,119],[175,141,108],[176,138,98],[178,136,91],[180,137,88],[180,134,85],[180,134,80],[179,133,80],[179,133,80],[179,133,79],[179,133,78],[178,132,77],[178,132,77],[179,132,78],[179,132,79],[179,133,80],[180,134,80],[180,134,81],[176,134,82],[178,148,113],[188,169,176],[175,128,129],[180,126,125],[180,125,123],[181,124,123],[181,126,124],[182,126,126],[182,127,127],[181,127,127],[179,128,128],[178,131,131],[183,137,136],[186,139,138],[184,136,137],[185,133,134],[186,128,126],[187,128,122],[187,127,123],[187,127,122],[187,127,122],[187,126,123],[187,126,124],[188,127,125],[189,128,125],[189,127,125],[188,126,125],[187,125,128],[185,128,134],[188,146,155],[206,183,191],[204,178,181],[188,144,144],[186,132,131],[188,129,128],[186,126,124],[188,126,124],[187,126,124],[187,126,124],[186,126,125],[183,125,125],[191,158,162],[183,138,144],[185,125,126],[188,126,125],[189,128,126],[189,127,126],[189,128,127],[188,128,127],[184,130,132],[191,157,166],[130,162,142],[92,147,104],[91,147,105],[93,148,110],[99,145,119],[161,186,179],[111,156,128],[91,148,102],[90,149,102],[89,149,101],[89,149,101],[88,148,104],[97,145,119],[155,183,174],[183,203,203],[121,160,142],[88,143,103],[88,145,99],[91,147,102],[91,146,105],[118,157,135],[162,188,181],[100,147,117],[86,144,99],[85,145,98],[87,146,97],[88,147,97],[85,145,97],[87,146,98],[90,145,99],[127,160,130],[181,151,125],[180,136,91],[181,135,84],[182,136,86],[182,135,85],[182,134,86],[181,135,85],[182,136,85],[182,135,84],[179,134,84],[179,134,86],[177,136,95],[174,142,112],[186,170,157],[183,159,128],[180,137,93],[181,134,84],[182,136,80],[181,135,83],[180,135,85],[177,136,89],[176,136,97],[172,141,113],[178,155,133],[189,164,145],[184,157,137],[174,140,106],[177,134,90],[179,134,88],[179,134,86],[179,134,86],[179,134,86],[178,133,84],[178,133,84],[178,133,87],[174,133,92],[173,147,120],[186,171,159],[194,184,174],[196,184,174],[192,175,161],[184,159,137],[178,143,109],[175,136,92],[179,135,87],[181,135,83],[180,134,81],[180,134,81],[180,134,81],[179,133,78],[179,132,78],[179,133,78],[180,133,79],[180,134,80],[180,134,80],[181,133,81],[181,133,80],[180,135,79],[178,135,85],[185,157,124],[179,142,146],[177,130,131],[177,127,128],[178,127,127],[179,130,130],[179,133,133],[182,136,139],[184,140,143],[187,149,153],[191,158,162],[195,167,170],[201,175,178],[200,172,177],[194,153,159],[183,130,130],[187,126,125],[187,126,124],[187,127,123],[186,126,124],[187,127,125],[188,126,124],[189,128,125],[189,129,125],[188,128,126],[188,127,128],[184,127,133],[185,148,155],[201,171,176],[184,139,139],[187,131,130],[187,128,126],[187,126,125],[187,126,125],[186,125,124],[186,125,125],[181,125,127],[190,158,162],[193,161,169],[181,130,130],[189,128,128],[190,128,129],[189,129,129],[187,128,129],[185,131,133],[188,150,158],[120,157,134],[93,148,107],[92,145,108],[93,145,111],[120,159,143],[122,163,142],[92,149,105],[90,148,104],[89,149,104],[91,149,104],[92,146,111],[120,155,140],[168,192,188],[107,153,126],[92,145,105],[93,146,105],[101,148,117],[144,172,162],[136,169,155],[91,145,107],[87,147,98],[87,147,98],[88,147,99],[86,146,99],[87,147,99],[89,148,99],[103,148,109],[193,174,163],[179,140,108],[179,136,88],[182,135,85],[181,135,85],[182,134,86],[181,135,85],[181,135,85],[182,134,85],[181,134,87],[181,136,90],[175,137,101],[183,156,134],[192,179,161],[179,146,106],[180,135,86],[181,135,84],[181,136,82],[180,134,83],[181,136,86],[178,136,87],[174,139,105],[178,157,139],[184,170,159],[171,140,110],[176,133,88],[180,135,84],[180,136,85],[180,134,88],[179,133,84],[178,132,84],[178,133,89],[175,138,103],[183,163,145],[198,179,163],[183,154,123],[176,138,99],[178,134,88],[180,135,83],[180,134,82],[180,135,80],[179,133,78],[179,134,79],[179,133,78],[179,134,79],[180,134,80],[180,135,79],[180,134,82],[182,133,82],[180,134,80],[180,135,82],[179,139,89],[196,180,159],[195,171,177],[188,155,157],[185,148,151],[189,150,153],[192,158,161],[197,168,173],[201,177,185],[205,184,193],[186,141,144],[185,127,126],[186,126,124],[186,127,125],[187,127,125],[187,128,125],[187,126,124],[189,128,125],[189,129,125],[188,129,127],[186,129,134],[186,147,154],[193,157,162],[188,134,134],[189,131,129],[188,127,127],[187,126,125],[186,125,124],[186,125,124],[181,124,124],[193,161,167],[184,149,153],[185,132,135],[185,130,132],[184,132,134],[186,140,146],[195,163,170],[124,157,141],[97,146,115],[100,147,118],[112,151,133],[166,185,185],[141,172,161],[97,148,112],[94,148,108],[93,149,108],[96,148,112],[108,151,127],[158,182,177],[155,183,177],[119,155,137],[112,151,127],[130,159,145],[178,198,196],[112,156,131],[89,145,102],[88,147,99],[88,146,99],[88,147,100],[89,147,102],[91,149,102],[95,147,103],[144,167,151],[191,163,145],[178,141,103],[181,138,89],[182,137,87],[181,135,86],[182,135,85],[184,135,86],[183,135,87],[183,135,90],[181,136,95],[179,148,120],[193,177,166],[186,162,138],[179,137,95],[183,136,88],[182,136,86],[182,136,85],[181,135,84],[180,136,86],[176,139,92],[175,152,130],[184,170,158],[170,136,101],[177,134,85],[179,135,85],[180,134,87],[179,132,85],[179,132,86],[176,134,93],[179,149,124],[192,181,173],[186,165,145],[177,142,108],[178,135,88],[179,133,81],[180,134,82],[179,135,81],[180,134,83],[180,134,81],[179,135,79],[180,135,79],[180,135,80],[181,135,83],[181,135,84],[180,135,82],[180,135,84],[178,135,88],[182,156,126],[190,151,155],[184,127,127],[186,127,125],[187,128,127],[187,128,125],[187,127,124],[188,126,124],[188,128,125],[188,128,128],[186,130,132],[189,146,154],[207,183,193],[190,145,149],[188,133,133],[189,130,128],[189,127,127],[188,127,127],[187,127,126],[182,129,132],[200,175,182],[205,183,191],[196,162,167],[192,157,160],[199,164,169],[206,182,188],[167,186,185],[142,170,160],[144,173,162],[165,188,184],[168,192,188],[110,154,127],[101,148,115],[103,149,118],[114,156,132],[150,177,169],[154,185,174],[101,149,116],[92,146,104],[91,147,102],[91,147,103],[92,147,106],[95,148,108],[98,148,108],[139,165,147],[193,166,145],[178,142,102],[177,135,88],[182,136,88],[182,135,86],[182,135,87],[181,134,92],[180,136,93],[179,142,110],[186,168,155],[180,153,131],[181,137,97],[183,137,91],[183,137,90],[183,137,90],[181,136,89],[179,137,92],[178,148,114],[188,176,165],[179,159,143],[174,135,94],[181,136,89],[180,135,88],[180,133,89],[179,134,90],[176,139,105],[185,164,151],[185,172,162],[173,145,120],[175,134,92],[178,134,82],[179,134,81],[179,135,82],[179,135,81],[180,135,82],[181,136,81],[181,136,81],[181,136,83],[182,135,85],[180,136,85],[180,136,86],[180,138,90],[178,147,113],[192,154,159],[184,128,129],[186,127,126],[187,128,127],[187,128,125],[188,127,125],[189,128,126],[189,129,129],[186,130,132],[191,147,155],[200,171,179],[188,144,145],[187,134,134],[189,133,134],[189,132,133],[185,131,134],[184,142,149],[151,180,170],[133,166,149],[140,170,158],[165,187,181],[143,174,162],[102,147,117],[93,146,105],[93,146,106],[95,146,109],[99,147,115],[112,152,127],[158,178,171],[195,179,167],[183,155,128],[178,143,109],[177,139,103],[176,139,104],[179,142,111],[182,147,122],[188,164,150],[182,163,148],[177,139,105],[180,138,97],[181,138,97],[182,138,97],[181,139,98],[181,146,110],[188,167,146],[178,152,129],[176,136,98],[180,136,94],[179,134,93],[178,138,99],[180,153,131],[177,152,128],[175,136,97],[180,134,85],[180,134,84],[180,135,84],[180,135,84],[181,136,82],[181,136,82],[182,136,83],[183,137,86],[181,137,87],[181,137,88],[180,138,92],[179,146,112],[195,183,172],[192,158,167],[185,129,131],[187,128,128],[187,128,127],[187,128,127],[188,127,125],[188,128,127],[187,133,137],[192,152,161],[200,174,179],[187,150,153],[183,141,144],[184,140,144],[186,147,152],[203,179,189],[151,177,167],[119,156,133],[109,148,125],[113,151,131],[127,160,144],[151,178,167],[200,187,178],[196,180,168],[193,177,163],[195,178,166],[198,181,171],[184,159,136],[179,146,116],[177,144,113],[180,145,114],[186,152,125],[189,165,146],[184,163,145],[176,147,123],[176,146,121],[182,155,134],[189,175,165],[183,156,133],[176,136,99],[179,134,87],[179,135,85],[180,135,86],[181,136,84],[182,136,83],[181,137,84],[182,138,87],[182,138,89],[181,138,90],[179,139,95],[180,150,122],[199,186,178],[194,165,177],[182,131,137],[186,128,131],[186,128,131],[186,129,133],[185,131,136],[183,140,146],[190,162,170],[216,195,201],[212,188,193],[214,188,194],[216,195,202],[184,194,208],[178,191,206],[177,190,207],[181,194,210],[190,201,214],[175,195,188],[160,184,175],[161,184,176],[176,196,190],[201,187,176],[197,183,170],[197,183,173],[202,189,181],[190,180,171],[183,160,142],[177,138,103],[178,134,88],[180,135,87],[181,137,85],[182,137,84],[181,137,85],[182,137,88],[181,137,93],[179,139,94],[176,141,104],[185,162,143],[181,142,150],[180,135,140],[182,137,142],[186,144,151],[194,160,168],[205,184,192],[168,182,200],[145,166,190],[131,156,185],[124,151,181],[122,150,181],[127,153,183],[138,162,189],[159,175,198],[186,194,209],[186,170,157],[178,147,118],[177,138,98],[180,138,92],[181,138,91],[182,139,91],[181,140,93],[179,139,97],[177,141,104],[179,151,125],[192,176,165],[198,175,183],[194,167,174],[203,176,183],[214,190,199],[188,196,212],[152,170,193],[120,147,179],[101,136,171],[93,131,169],[91,130,168],[93,130,169],[95,131,170],[98,132,169],[108,136,171],[129,149,175],[164,177,192],[194,181,170],[184,159,139],[180,146,114],[178,141,104],[179,142,103],[179,144,106],[179,146,112],[182,154,125],[193,173,158],[147,163,187],[108,137,169],[94,130,169],[89,131,172],[87,131,174],[86,131,173],[87,131,173],[90,132,175],[91,132,175],[92,132,176],[96,133,172],[119,144,175],[171,181,198],[194,173,158],[187,159,137],[186,158,133],[188,161,137],[191,169,148],[197,179,164],[157,170,191],[109,137,171],[90,130,170],[87,131,174],[87,132,176],[87,132,175],[87,132,174],[89,133,175],[89,133,175],[91,134,176],[88,133,177],[85,131,174],[91,132,173],[123,148,178],[190,196,211],[206,199,184],[201,194,175],[197,189,169],[194,186,164],[192,184,163],[189,182,162],[189,183,162],[190,184,165],[194,189,172],[191,201,216],[193,204,217],[181,190,205],[120,145,174],[91,131,170],[85,130,172],[85,130,174],[87,130,175],[86,131,175],[87,132,175],[88,133,175],[87,132,174],[88,132,176],[89,132,176],[87,132,177],[87,132,174],[103,134,169],[174,185,201],[195,187,161],[189,178,141],[185,171,127],[182,166,120],[181,164,115],[180,163,115],[179,164,115],[180,165,117],[180,163,114],[182,165,117],[186,171,125],[191,180,137],[200,193,168],[169,182,199],[142,162,186],[143,166,188],[158,175,196],[184,194,210],[145,163,187],[96,132,169],[87,131,173],[86,131,174],[86,131,175],[87,131,176],[86,131,175],[87,132,175],[87,133,176],[88,132,175],[88,132,175],[88,132,175],[88,132,176],[88,133,174],[105,137,172],[172,185,202],[191,184,172],[185,173,146],[181,166,118],[178,161,100],[177,159,92],[178,159,89],[178,157,89],[175,157,90],[175,159,95],[178,161,101],[178,160,100],[177,157,93],[180,158,89],[181,160,94],[184,166,111],[194,182,140],[206,202,180],[177,165,159],[151,172,192],[96,132,167],[94,134,171],[105,139,174],[130,153,182],[175,184,202],[188,197,209],[116,142,173],[90,130,171],[85,131,174],[87,132,175],[87,132,175],[87,132,176],[86,132,175],[87,132,175],[87,132,176],[88,132,176],[87,132,174],[87,131,174],[90,132,175],[91,131,172],[119,149,182],[184,195,211],[179,166,133],[174,157,98],[175,156,86],[174,155,81],[175,156,79],[176,157,81],[176,157,87],[177,161,97],[181,169,111],[181,170,115],[178,162,104],[180,159,87],[183,161,85],[181,159,87],[179,160,96],[187,176,129],[203,200,179],[203,214,226],[185,204,219],[170,194,209],[171,193,207],[176,197,210],[189,205,217],[180,165,157],[185,171,165],[150,171,192],[88,130,169],[88,134,178],[89,133,179],[97,135,176],[124,149,181],[177,190,209],[170,183,199],[103,134,170],[89,132,175],[87,131,175],[87,132,176],[88,132,175],[87,133,176],[86,133,176],[88,133,177],[86,133,176],[87,132,175],[86,131,175],[88,131,175],[90,132,173],[100,136,171],[150,174,199],[188,182,163],[173,159,111],[174,155,86],[175,156,80],[175,156,77],[175,155,79],[176,156,86],[176,162,98],[182,176,119],[187,184,133],[187,178,130],[178,161,99],[179,158,82],[181,159,78],[180,160,80],[180,162,91],[188,177,130],[203,198,183],[196,188,161],[190,179,140],[184,174,131],[180,171,128],[180,172,132],[185,178,145],[192,190,164],[195,209,221],[158,186,202],[126,164,184],[112,155,176],[112,155,174],[118,158,176],[135,169,185],[165,189,201],[205,217,228],[204,216,227],[202,216,225],[202,216,226],[205,219,229],[188,175,169],[183,169,163],[150,170,192],[87,129,169],[88,134,179],[86,132,180],[90,132,178],[99,135,174],[129,153,182],[191,199,215],[150,166,190],[96,133,172],[89,132,176],[89,133,177],[89,132,177],[88,132,176],[89,133,176],[88,133,176],[89,133,176],[88,132,177],[88,132,176],[87,132,175],[89,132,175],[93,132,171],[127,154,183],[183,199,217],[185,177,147],[170,153,91],[175,155,80],[176,156,78],[176,156,79],[176,156,82],[177,163,95],[183,179,120],[185,186,137],[188,188,147],[182,173,128],[178,159,87],[180,160,74],[180,160,76],[180,160,78],[181,164,90],[193,184,146],[194,183,152],[185,169,122],[178,161,102],[174,157,93],[172,155,89],[169,154,89],[170,156,96],[172,162,109],[181,176,139],[196,195,177],[187,195,207],[162,179,194],[150,177,192],[157,183,198],[168,191,207],[182,201,217],[196,209,223],[191,207,220],[143,173,188],[107,150,172],[91,145,170],[86,145,170],[86,146,171],[89,146,171],[98,150,171],[118,159,175],[161,183,196],[201,214,226],[184,205,218],[169,196,212],[157,188,206],[153,184,200],[150,182,199],[149,182,198],[154,185,200],[162,190,204],[174,196,209],[185,203,215],[197,211,222],[183,169,163],[139,163,186],[88,130,172],[88,134,180],[86,133,181],[88,133,180],[88,134,178],[98,135,173],[149,166,188],[130,151,179],[94,133,176],[89,132,177],[90,133,177],[88,133,176],[87,132,176],[89,133,176],[89,133,176],[89,133,177],[88,133,177],[86,132,177],[87,132,176],[88,131,174],[104,138,173],[163,185,206],[204,214,226],[174,162,113],[172,153,78],[176,156,78],[176,155,76],[175,154,76],[176,158,82],[182,174,106],[186,186,128],[188,191,147],[188,186,150],[176,164,109],[178,159,78],[180,159,74],[180,160,75],[181,161,83],[182,166,104],[201,197,167],[193,184,154],[183,167,117],[179,160,93],[178,157,83],[177,156,78],[176,156,77],[175,156,75],[173,155,74],[172,155,76],[173,159,88],[177,169,120],[198,197,178],[177,189,202],[131,159,176],[103,147,165],[101,147,168],[111,154,175],[126,163,184],[150,179,197],[180,198,212],[200,212,224],[141,172,189],[95,146,168],[83,144,170],[79,144,172],[77,145,172],[79,145,174],[80,145,173],[82,146,172],[86,147,170],[122,160,178],[188,200,213],[204,217,228],[183,203,217],[152,181,199],[124,162,180],[107,152,173],[101,149,170],[100,147,170],[99,147,170],[99,148,170],[100,150,170],[107,153,171],[117,157,174],[129,164,180],[145,174,189],[168,190,202],[193,206,219],[186,199,209],[117,145,172],[86,130,174],[88,134,179],[86,134,180],[87,133,181],[88,132,180],[90,132,177],[111,140,174],[177,188,204],[184,193,205],[112,140,174],[92,134,176],[89,132,177],[88,133,177],[88,133,176],[88,133,176],[89,133,176],[89,133,177],[88,133,177],[87,133,176],[85,133,176],[87,132,176],[90,132,173],[130,158,186],[190,205,219],[187,197,214],[180,191,210],[177,188,208],[176,185,205],[177,187,205],[184,194,211],[196,204,217],[183,166,152],[184,168,155],[184,175,138],[168,150,76],[176,155,75],[178,156,76],[178,157,76],[178,157,77],[176,161,87],[180,175,107],[185,186,129],[189,191,153],[182,174,132],[176,157,86],[179,159,75],[180,159,75],[182,161,80],[182,162,88],[185,174,124],[197,192,169],[182,170,114],[176,158,83],[178,158,79],[178,156,78],[177,155,76],[175,155,75],[175,154,74],[174,155,72],[176,155,72],[174,155,73],[172,158,83],[179,172,127],[190,204,217],[139,169,186],[93,144,164],[84,142,166],[86,142,167],[90,142,167],[101,146,169],[132,165,184],[172,190,204],[156,183,199],[93,146,170],[79,144,171],[79,145,173],[78,146,173],[77,145,172],[77,145,172],[77,145,172],[79,146,172],[79,145,169],[100,148,168],[163,184,199],[195,210,222],[160,186,200],[124,162,181],[101,149,171],[90,145,169],[84,145,170],[85,147,172],[85,148,174],[83,148,175],[81,147,174],[78,146,173],[80,147,170],[87,148,171],[92,151,173],[98,153,175],[117,162,183],[150,180,197],[180,197,210],[151,170,190],[97,132,169],[85,131,176],[88,135,179],[88,133,180],[86,133,181],[86,133,180],[85,134,179],[92,133,173],[132,156,182],[191,200,215],[159,175,192],[99,134,171],[90,134,176],[88,132,177],[86,133,176],[88,133,176],[88,133,176],[88,133,176],[89,132,177],[88,132,176],[85,132,176],[84,132,175],[86,130,175],[95,134,172],[157,180,200],[192,201,216],[173,187,205],[153,173,196],[139,163,190],[131,154,184],[127,149,181],[126,148,179],[127,148,179],[133,153,182],[147,164,188],[167,182,198],[191,177,167],[185,164,146],[182,161,143],[195,185,174],[192,185,151],[166,148,77],[175,154,73],[176,156,74],[177,156,74],[177,156,74],[174,156,76],[172,161,84],[177,174,103],[188,190,146],[188,184,149],[176,159,96],[177,158,77],[178,158,75],[180,160,76],[183,162,81],[179,163,90],[194,188,149],[191,182,144],[177,161,92],[176,158,75],[177,156,78],[178,156,78],[176,155,76],[174,154,73],[175,156,73],[174,155,73],[176,156,74],[176,157,74],[176,159,76],[172,160,96],[189,187,161],[201,214,223],[155,183,197],[92,145,166],[79,142,168],[81,143,170],[78,143,170],[79,142,169],[96,147,174],[131,165,184],[174,191,206],[182,202,217],[105,152,172],[77,142,168],[75,144,171],[76,143,171],[77,145,172],[78,147,174],[77,147,174],[77,145,172],[78,146,172],[79,147,172],[89,144,166],[141,170,186],[189,203,214],[144,175,192],[105,153,174],[87,147,172],[80,145,172],[78,145,171],[77,145,170],[78,147,173],[80,148,174],[80,148,176],[79,148,176],[77,147,174],[76,147,173],[78,147,173],[78,148,171],[78,146,170],[84,148,171],[101,151,173],[127,162,180],[164,187,201],[165,178,197],[113,141,171],[89,130,171],[85,133,177],[88,134,179],[86,133,180],[86,133,181],[87,134,181],[85,136,180],[87,134,176],[102,136,171],[144,161,186],[187,195,212],[188,198,209],[128,153,177],[92,132,173],[88,132,177],[86,133,175],[86,133,176],[87,132,176],[87,132,175],[87,132,176],[87,132,176],[86,131,175],[84,131,176],[84,131,175],[83,130,175],[100,138,173],[176,194,209],[194,204,215],[175,188,205],[149,167,190],[125,148,178],[109,139,173],[99,135,172],[97,133,172],[94,130,171],[95,129,171],[95,129,172],[96,129,170],[100,133,170],[115,141,174],[141,160,185],[181,190,205],[182,168,159],[189,167,152],[187,168,152],[184,171,159],[192,186,154],[166,149,79],[174,154,72],[175,155,72],[176,156,74],[177,157,73],[176,156,72],[171,155,69],[171,162,79],[186,186,131],[190,190,157],[179,163,108],[178,157,79],[177,158,74],[179,159,75],[180,161,77],[182,162,84],[182,168,104],[205,201,173],[202,195,172],[183,171,118],[177,158,84],[176,156,74],[177,156,76],[178,156,75],[177,155,75],[176,155,72],[175,156,71],[174,156,71],[175,156,74],[175,156,74],[175,158,75],[174,158,81],[182,175,132],[202,189,182],[187,168,154],[163,189,201],[90,142,165],[80,142,169],[79,144,170],[76,143,170],[76,142,170],[81,142,169],[93,146,168],[134,167,185],[184,199,211],[206,216,228],[141,173,190],[83,142,165],[74,145,171],[74,143,171],[76,145,171],[77,145,172],[77,145,172],[77,147,174],[77,145,172],[77,146,171],[77,145,172],[82,145,169],[127,164,179],[181,197,210],[133,168,188],[96,150,173],[84,147,172],[80,147,173],[77,146,173],[77,145,172],[76,145,171],[76,146,173],[78,147,173],[79,147,174],[78,146,174],[76,146,173],[75,147,173],[75,146,173],[74,147,172],[74,147,172],[77,148,172],[81,145,169],[89,144,165],[116,153,171],[161,180,192],[163,173,190],[123,145,173],[97,130,169],[88,131,175],[86,133,178],[87,134,180],[86,133,180],[86,134,181],[87,133,180],[85,133,178],[85,134,178],[90,133,175],[108,139,175],[142,160,189],[172,184,205],[189,198,213],[197,204,218],[197,204,219],[188,198,212],[152,171,193],[99,137,172],[88,131,174],[87,132,174],[87,133,176],[85,133,176],[85,132,175],[86,132,176],[87,132,176],[86,132,175],[83,130,175],[82,130,175],[82,130,175],[84,130,174],[106,142,175],[188,201,215],[187,198,209],[160,177,196],[130,153,178],[107,136,171],[96,130,170],[90,129,169],[85,128,171],[86,129,173],[85,130,174],[86,130,175],[88,131,176],[88,130,175],[88,130,174],[90,130,171],[100,133,171],[129,151,181],[183,192,207],[185,166,154],[191,174,162],[189,176,164],[183,178,137],[167,150,76],[173,155,69],[174,156,70],[175,156,71],[175,157,72],[175,156,71],[173,155,70],[170,157,71],[181,179,117],[193,192,158],[179,168,115],[176,158,78],[178,159,76],[180,160,76],[180,160,76],[181,161,82],[178,161,87],[191,179,129],[193,185,149],[178,163,99],[178,157,79],[178,157,75],[177,156,74],[178,157,72],[178,157,71],[177,157,72],[176,156,70],[177,157,71],[176,158,74],[175,157,74],[174,158,76],[175,159,80],[179,171,118],[195,181,171],[183,162,148],[155,186,197],[81,139,162],[77,142,168],[76,143,168],[74,142,169],[74,142,169],[76,141,169],[78,139,163],[105,147,168],[160,181,195],[189,205,219],[106,153,171],[77,144,169],[72,144,170],[73,144,170],[76,145,172],[77,146,173],[77,146,173],[77,146,173],[76,145,172],[74,145,171],[74,146,171],[76,145,170],[111,156,175],[187,204,214],[199,212,222],[171,192,207],[126,163,181],[93,148,170],[84,147,170],[82,148,174],[79,148,175],[77,146,173],[77,145,172],[77,145,172],[75,145,171],[76,144,171],[78,145,173],[77,145,173],[77,146,173],[74,146,173],[73,145,171],[72,145,170],[72,145,171],[74,147,173],[74,146,171],[78,147,171],[88,146,170],[118,158,175],[163,184,195],[146,162,184],[105,136,171],[92,131,175],[87,131,177],[85,132,178],[86,133,179],[84,133,179],[84,133,180],[86,132,180],[86,133,179],[86,134,179],[86,135,178],[91,136,178],[102,140,180],[121,153,187],[143,169,198],[152,175,203],[154,175,203],[143,166,195],[111,143,177],[90,132,173],[86,132,175],[85,132,176],[86,132,175],[86,133,176],[84,131,175],[85,132,175],[86,131,176],[84,130,175],[82,130,175],[81,130,175],[82,130,175],[83,129,174],[107,141,175],[189,201,215],[153,172,190],[119,148,177],[97,134,169],[88,129,169],[84,128,171],[85,129,171],[83,127,171],[83,128,172],[84,128,172],[83,128,172],[85,128,175],[85,128,174],[85,128,174],[88,131,175],[89,130,173],[95,130,169],[134,153,179],[198,195,174],[175,164,110],[169,149,71],[174,154,72],[175,155,71],[175,156,70],[175,156,71],[174,156,70],[173,155,69],[170,154,66],[173,171,97],[191,193,148],[181,172,122],[176,158,80],[178,158,76],[179,159,76],[179,160,77],[181,161,81],[180,160,83],[180,163,95],[197,191,155],[198,194,174],[187,173,122],[179,159,88],[178,157,77],[178,157,74],[177,157,73],[176,156,72],[176,156,72],[177,156,72],[176,156,72],[178,157,73],[177,157,73],[177,156,76],[174,158,77],[174,159,80],[179,170,117],[193,205,216],[187,201,214],[180,195,209],[175,192,206],[169,189,202],[167,187,200],[162,183,197],[154,176,191],[154,174,187],[180,191,203],[181,165,156],[133,171,186],[75,137,161],[75,143,169],[75,143,168],[75,142,169],[74,143,169],[74,143,170],[74,143,168],[84,143,165],[131,163,181],[192,205,217],[170,194,208],[89,147,168],[76,144,172],[73,144,171],[73,145,171],[76,145,172],[77,145,172],[77,145,172],[77,145,172],[76,145,172],[74,146,171],[72,145,171],[73,144,171],[95,149,170],[162,188,200],[193,206,218],[159,183,198],[120,158,176],[92,147,167],[81,146,170],[81,148,172],[81,147,175],[78,147,174],[78,147,174],[77,146,173],[77,145,172],[75,145,172],[75,145,172],[77,145,173],[77,146,173],[77,147,173],[74,145,171],[74,145,173],[74,146,172],[75,146,172],[75,146,173],[75,146,172],[76,147,174],[77,146,173],[88,147,171],[116,160,177],[175,193,203],[168,184,203],[117,148,180],[91,131,174],[87,131,177],[83,132,178],[83,134,180],[82,133,179],[84,134,179],[85,133,179],[85,132,178],[86,133,179],[86,134,179],[86,134,176],[89,134,176],[94,134,172],[101,136,172],[104,137,173],[105,137,173],[101,135,171],[93,132,172],[86,130,173],[84,130,174],[84,131,175],[85,132,175],[86,132,176],[84,131,175],[83,129,174],[84,129,176],[83,130,175],[81,130,175],[81,129,174],[82,129,175],[83,129,174],[103,136,173],[185,195,212],[152,169,191],[110,140,173],[90,130,168],[85,128,169],[83,128,171],[80,127,170],[83,127,170],[82,127,171],[83,127,171],[83,126,170],[82,127,171],[84,127,173],[84,128,173],[83,127,172],[84,127,172],[85,129,173],[84,127,171],[100,130,166],[160,171,190],[186,178,143],[168,154,90],[170,151,72],[176,155,73],[178,157,73],[176,157,71],[175,156,71],[175,157,70],[173,155,69],[171,155,65],[169,165,83],[183,186,130],[182,176,125],[178,161,87],[179,158,76],[179,158,76],[180,160,78],[180,160,80],[181,161,84],[180,161,85],[184,169,105],[199,193,167],[191,182,142],[182,165,104],[180,159,90],[179,157,81],[178,156,74],[178,156,73],[177,156,72],[176,155,72],[176,156,72],[176,156,72],[177,156,71],[178,157,72],[177,157,74],[175,157,76],[175,159,81],[181,171,119],[184,199,210],[162,185,202],[143,172,191],[131,163,184],[125,158,179],[121,155,175],[115,153,172],[113,152,171],[113,150,170],[106,143,165],[112,146,164],[154,174,188],[185,203,210],[105,150,169],[74,140,165],[75,143,170],[74,143,170],[73,143,170],[74,143,170],[75,143,170],[73,144,170],[77,141,168],[106,150,173],[176,194,208],[149,181,197],[81,144,170],[76,145,172],[74,145,172],[73,146,172],[74,146,172],[76,145,172],[76,146,173],[76,146,172],[75,146,172],[74,146,171],[73,145,170],[73,144,171],[84,144,167],[131,166,182],[175,195,207],[186,204,216],[178,196,210],[145,172,190],[106,151,172],[88,146,169],[79,146,171],[78,146,172],[81,148,174],[79,148,174],[78,147,174],[79,148,175],[78,147,174],[76,146,171],[75,145,172],[75,146,170],[74,145,170],[76,146,172],[77,147,174],[74,145,172],[73,146,171],[74,147,172],[75,146,172],[75,147,172],[74,146,171],[76,146,173],[77,147,174],[78,145,172],[92,147,170],[137,166,180],[197,207,219],[161,183,205],[114,148,181],[88,131,175],[82,131,177],[82,133,178],[82,132,179],[82,132,179],[84,132,179],[85,132,179],[85,132,179],[85,132,178],[84,133,178],[86,134,177],[90,134,175],[92,134,175],[94,134,175],[90,132,175],[88,132,175],[87,130,175],[84,130,174],[84,130,174],[84,131,175],[85,132,175],[86,131,175],[84,130,174],[83,129,174],[83,129,174],[82,128,173],[82,129,173],[82,129,174],[83,128,175],[83,129,173],[95,130,171],[163,178,200],[155,171,191],[114,138,170],[90,126,166],[83,127,170],[81,128,171],[80,127,170],[80,128,171],[81,128,171],[83,128,172],[83,128,172],[83,127,171],[82,127,171],[82,127,171],[84,128,172],[86,129,174],[85,128,172],[86,129,174],[85,128,172],[90,128,170],[124,146,175],[184,178,150],[171,159,108],[168,151,79],[171,152,72],[175,155,73],[178,157,73],[177,156,72],[175,157,72],[176,156,72],[175,157,72],[171,154,68],[167,160,74],[176,181,107],[181,180,118],[178,163,93],[177,157,76],[179,158,76],[180,159,77],[180,160,79],[180,159,83],[182,160,86],[179,162,90],[185,172,118],[199,190,154],[203,195,166],[196,185,153],[184,171,122],[181,164,109],[179,161,105],[178,159,96],[177,157,81],[178,156,73],[178,156,72],[178,156,72],[176,156,72],[176,156,72],[178,157,71],[178,157,71],[178,158,73],[176,158,76],[176,159,82],[183,172,123],[171,189,201],[131,164,181],[108,149,171],[96,141,166],[90,138,163],[89,136,162],[89,137,162],[85,138,161],[84,138,162],[83,137,163],[83,135,162],[86,137,161],[125,156,173],[175,189,199],[134,166,179],[82,138,162],[73,141,168],[75,143,170],[72,143,170],[72,144,170],[73,143,170],[73,143,169],[72,144,170],[74,142,169],[91,144,167],[160,184,198],[202,216,226],[131,171,189],[78,143,171],[76,144,173],[75,146,174],[74,146,173],[73,145,173],[73,145,173],[75,146,174],[74,147,174],[74,146,174],[73,145,172],[73,144,171],[74,145,171],[79,144,169],[100,149,172],[118,160,181],[119,161,182],[107,153,175],[89,146,170],[80,146,171],[77,147,172],[75,146,173],[75,148,174],[76,149,173],[77,147,174],[76,147,174],[76,147,174],[78,147,173],[77,146,172],[76,145,172],[75,145,171],[74,145,172],[75,146,173],[76,146,174],[74,146,173],[74,146,171],[74,146,171],[75,146,171],[75,147,171],[75,147,172],[76,146,173],[76,147,174],[77,147,175],[82,146,171],[107,148,166],[171,188,199],[199,208,222],[180,193,214],[168,181,206],[163,178,202],[167,181,204],[179,190,209],[196,204,219],[191,206,221],[155,182,206],[102,142,181],[82,130,174],[81,132,178],[82,132,179],[82,131,179],[84,131,179],[84,131,179],[85,132,179],[85,132,178],[84,133,178],[85,134,178],[88,134,176],[90,134,175],[89,133,176],[86,131,175],[85,131,175],[84,130,174],[85,130,175],[83,130,175],[83,130,177],[83,130,176],[85,129,175],[83,129,174],[82,128,173],[81,128,173],[81,128,173],[82,129,173],[82,129,174],[83,129,174],[84,129,173],[87,127,169],[125,147,178],[183,192,209],[185,193,205],[153,167,186],[117,140,169],[95,127,167],[85,126,171],[78,125,171],[79,127,172],[79,127,170],[80,126,170],[79,127,171],[80,127,171],[82,127,172],[83,128,172],[81,127,171],[79,127,171],[83,128,172],[86,129,174],[85,128,172],[84,127,172],[84,127,172],[87,129,172],[106,136,169],[184,194,208],[190,182,160],[181,173,145],[181,173,144],[180,171,139],[173,164,125],[170,157,101],[170,152,83],[173,153,75],[175,155,75],[177,155,75],[177,156,74],[175,156,72],[176,156,74],[175,156,74],[175,156,74],[174,156,77],[168,160,79],[174,176,99],[178,180,111],[178,167,97],[178,159,79],[177,158,76],[178,159,78],[180,160,81],[180,160,84],[181,161,86],[180,162,87],[177,163,96],[178,165,112],[181,169,124],[182,169,126],[181,167,116],[184,171,121],[189,177,133],[187,173,125],[181,164,101],[178,156,77],[178,155,72],[179,156,73],[177,156,72],[176,156,72],[177,157,71],[178,157,71],[178,158,73],[177,158,75],[176,158,81],[183,172,121],[172,188,200],[117,151,170],[85,139,162],[75,135,161],[72,134,162],[72,133,162],[75,134,163],[76,137,164],[74,137,163],[73,137,164],[74,137,164],[73,138,166],[75,136,164],[97,144,164],[140,168,182],[174,191,202],[191,204,214],[198,210,220],[201,212,223],[183,201,210],[142,172,184],[91,141,160],[75,139,165],[73,142,169],[73,143,170],[71,144,170],[71,145,170],[72,145,170],[73,144,170],[72,144,170],[74,142,170],[84,142,166],[147,177,193],[191,209,220],[112,160,181],[78,144,172],[77,143,173],[77,145,172],[76,145,172],[74,145,173],[73,146,173],[73,146,174],[74,147,174],[72,145,173],[72,145,173],[72,145,172],[70,144,171],[71,143,171],[79,144,171],[86,144,170],[86,146,171],[85,145,170],[81,146,172],[78,147,174],[77,147,174],[77,147,173],[75,147,174],[76,149,174],[76,149,174],[76,147,174],[75,147,173],[78,146,172],[78,146,173],[76,145,172],[75,144,171],[74,144,172],[74,144,171],[74,144,171],[74,145,171],[76,145,171],[77,145,171],[77,145,172],[75,146,172],[75,147,173],[75,146,172],[75,146,172],[77,148,174],[78,147,173],[88,146,168],[135,166,180],[191,201,218],[153,173,198],[129,155,189],[122,149,185],[120,146,182],[126,151,184],[138,159,189],[157,175,198],[184,194,211],[190,205,221],[138,172,202],[84,131,174],[81,131,178],[82,131,178],[82,131,179],[84,132,179],[85,131,179],[85,132,178],[84,132,177],[84,132,177],[85,133,177],[87,133,176],[89,133,175],[89,131,176],[87,130,176],[86,130,175],[85,130,174],[85,131,175],[82,129,174],[81,128,173],[82,128,174],[83,128,173],[82,127,172],[80,127,172],[79,127,172],[81,127,172],[81,128,173],[81,127,173],[83,129,173],[83,128,172],[85,128,172],[98,129,167],[134,153,179],[159,174,195],[168,183,201],[171,186,203],[167,183,198],[157,173,192],[136,157,184],[111,139,172],[92,128,168],[86,126,171],[81,126,172],[78,126,171],[80,128,171],[79,127,171],[79,127,170],[79,126,172],[80,126,170],[80,127,171],[81,128,171],[79,127,171],[79,127,172],[81,127,172],[84,128,172],[85,128,172],[84,127,171],[82,127,170],[86,128,170],[106,139,172],[179,191,206],[199,193,172],[196,190,163],[191,182,149],[184,168,119],[176,159,98],[176,157,96],[174,157,95],[171,156,88],[170,153,79],[173,154,77],[175,155,76],[176,155,76],[176,156,75],[177,156,76],[177,156,75],[176,157,76],[175,156,75],[175,156,74],[174,157,79],[170,160,82],[173,173,96],[179,180,107],[180,170,100],[178,159,81],[177,158,77],[178,160,79],[180,160,81],[180,161,84],[180,161,86],[179,162,86],[178,164,91],[178,165,98],[181,169,108],[185,173,120],[183,176,126],[185,181,139],[194,191,158],[194,190,155],[188,178,132],[180,163,93],[176,155,72],[177,156,72],[178,157,73],[176,156,72],[178,157,73],[178,157,72],[178,158,75],[177,159,77],[176,159,79],[183,172,114],[193,190,173],[192,189,171],[179,194,204],[116,151,170],[78,135,160],[72,135,162],[71,135,163],[71,135,163],[71,135,163],[72,135,163],[73,137,165],[73,137,165],[74,138,165],[72,137,165],[70,137,164],[70,135,163],[80,136,161],[104,148,167],[128,162,179],[151,179,195],[166,192,208],[172,195,210],[169,192,206],[157,182,197],[130,163,177],[97,143,161],[77,138,163],[73,141,168],[73,143,169],[71,144,169],[71,144,169],[71,145,170],[71,144,170],[73,144,170],[72,143,170],[74,143,170],[82,143,167],[134,170,188],[194,209,221],[203,216,226],[198,213,223],[161,190,204],[92,150,174],[76,143,172],[76,144,172],[77,145,173],[75,145,172],[73,146,173],[72,145,172],[73,146,173],[74,146,174],[73,146,173],[72,145,173],[71,144,172],[70,144,172],[72,145,172],[76,145,172],[80,146,173],[80,146,173],[80,146,173],[79,146,174],[78,148,174],[78,147,174],[77,147,174],[75,148,174],[75,148,173],[75,148,173],[75,147,173],[75,147,172],[79,147,173],[79,147,174],[77,146,173],[75,145,171],[77,145,170],[80,144,170],[81,144,170],[81,145,170],[86,147,172],[86,147,172],[84,146,170],[80,145,170],[79,146,171],[78,146,173],[76,146,172],[76,146,173],[76,147,173],[81,146,172],[107,151,171],[184,199,210],[149,165,192],[109,142,176],[98,136,178],[96,134,179],[97,134,178],[98,135,176],[100,136,176],[112,144,179],[141,161,188],[178,188,206],[202,212,224],[174,198,219],[100,142,179],[83,130,176],[83,131,178],[83,131,178],[85,132,178],[87,132,176],[87,132,174],[89,133,175],[89,134,174],[89,134,175],[89,133,173],[90,132,174],[91,132,174],[91,132,175],[89,131,173],[88,131,173],[88,132,174],[88,132,174],[84,130,173],[84,127,172],[84,127,172],[84,127,172],[82,128,172],[81,128,173],[84,129,173],[84,128,172],[83,128,171],[85,127,171],[83,128,171],[85,128,171],[86,127,169],[96,130,168],[106,136,171],[113,140,175],[114,141,176],[113,142,175],[107,138,173],[97,131,170],[90,128,171],[84,125,169],[83,125,172],[81,126,173],[79,126,173],[79,127,172],[79,127,172],[78,127,172],[79,127,172],[80,127,171],[80,127,171],[82,127,171],[79,126,171],[78,125,170],[80,126,171],[82,126,171],[84,126,171],[84,128,172],[81,127,169],[86,127,168],[121,151,183],[185,197,211],[204,197,177],[197,188,161],[195,183,149],[191,177,134],[187,169,119],[184,167,110],[182,165,103],[179,159,90],[176,155,79],[176,155,81],[174,156,82],[172,156,82],[173,155,81],[175,156,79],[175,155,77],[176,156,77],[175,156,76],[176,156,77],[177,156,77],[176,157,77],[176,157,79],[175,157,77],[173,158,81],[170,160,84],[170,170,92],[178,180,107],[180,172,102],[178,160,85],[177,158,78],[178,159,79],[179,160,80],[179,161,82],[179,162,84],[178,163,85],[178,165,89],[179,167,100],[179,171,112],[181,178,122],[186,185,140],[190,189,151],[193,195,158],[195,197,161],[191,189,150],[184,174,119],[175,156,79],[176,156,72],[177,156,72],[176,157,72],[176,157,73],[176,157,72],[177,157,74],[177,159,77],[178,161,82],[180,168,105],[201,199,172],[193,186,160],[188,178,145],[184,173,136],[181,169,128],[179,167,123],[179,168,123],[181,172,128],[184,174,136],[185,177,142],[192,187,161],[187,200,210],[130,161,178],[80,134,160],[71,134,162],[71,134,162],[70,134,162],[70,134,162],[71,136,163],[72,137,164],[73,137,165],[73,137,165],[73,137,165],[71,137,165],[70,137,165],[70,137,164],[73,136,163],[84,139,163],[95,143,165],[106,149,169],[114,153,174],[115,154,174],[111,151,171],[102,146,167],[88,141,163],[78,140,165],[73,141,168],[74,143,169],[73,143,169],[71,144,170],[71,145,170],[71,145,170],[71,144,169],[74,144,171],[74,144,170],[75,143,170],[80,143,169],[112,160,181],[155,187,204],[161,192,208],[148,183,201],[112,161,181],[80,145,170],[76,144,171],[77,144,172],[76,144,173],[74,145,173],[72,145,172],[72,144,172],[73,145,173],[73,146,173],[73,146,173],[71,144,172],[70,144,172],[72,145,172],[72,145,172],[74,145,172],[77,146,173],[77,146,173],[77,146,173],[78,146,173],[78,147,174],[78,147,174],[77,147,173],[75,147,173],[75,147,173],[75,146,172],[74,146,173],[75,147,172],[78,147,173],[83,147,173],[83,148,171],[82,146,168],[85,145,168],[98,148,171],[117,158,179],[127,167,186],[133,172,192],[132,172,193],[124,169,190],[113,162,183],[98,152,176],[87,147,173],[78,146,172],[75,146,171],[75,146,172],[76,145,172],[93,145,167],[160,181,194],[163,177,199],[109,139,178],[93,135,180],[90,137,182],[89,136,182],[90,135,182],[93,135,181],[90,137,181],[89,135,179],[99,138,178],[127,151,185],[170,183,205],[194,211,226],[119,155,188],[85,130,175],[85,132,178],[84,131,177],[87,132,175],[95,136,173],[102,140,175],[106,142,178],[105,141,175],[104,140,175],[102,140,175],[99,137,174],[98,137,173],[99,137,173],[98,136,173],[98,136,174],[97,134,172],[99,135,171],[99,135,171],[99,133,172],[98,133,171],[97,132,170],[98,132,170],[96,132,170],[96,132,168],[96,133,169],[96,132,169],[96,131,169],[95,131,169],[94,130,169],[88,129,169],[87,128,170],[91,128,171],[93,129,171],[92,129,170],[92,129,170],[90,127,169],[87,126,169],[84,126,171],[83,127,172],[82,126,172],[81,126,173],[80,126,174],[80,127,172],[79,127,172],[78,126,171],[78,126,171],[78,125,171],[80,126,170],[82,127,171],[80,126,170],[80,126,170],[82,127,171],[82,126,171],[86,127,172],[86,128,170],[86,128,166],[101,137,170],[152,174,199],[200,188,155],[192,176,131],[187,169,115],[184,165,107],[182,162,100],[180,160,94],[178,158,87],[177,158,81],[178,157,78],[178,156,75],[178,157,76],[176,157,77],[174,156,79],[174,156,81],[176,156,80],[176,156,78],[176,157,78],[176,157,77],[176,157,78],[177,156,78],[176,157,79],[177,158,85],[177,160,89],[176,161,91],[170,162,89],[168,168,91],[175,178,105],[177,174,105],[178,163,91],[177,158,80],[177,158,78],[179,161,80],[179,162,81],[178,163,84],[177,164,87],[177,167,92],[178,172,102],[182,179,117],[182,182,124],[186,187,134],[188,190,143],[190,193,149],[193,197,158],[191,193,154],[187,183,137],[178,163,94],[177,157,74],[177,157,72],[176,157,72],[175,157,73],[177,159,75],[177,160,76],[179,163,83],[180,164,88],[180,168,102],[193,188,149],[195,190,166],[191,181,144],[185,170,117],[182,164,100],[180,161,94],[177,159,90],[175,156,85],[174,155,83],[174,156,85],[175,158,90],[174,158,92],[177,162,102],[187,173,128],[198,190,159],[157,179,191],[93,138,160],[72,131,160],[69,132,161],[70,133,162],[70,133,162],[69,135,161],[71,136,163],[73,137,163],[72,136,164],[73,137,165],[72,138,165],[71,138,165],[69,137,165],[69,137,165],[69,137,164],[72,137,165],[76,139,167],[81,142,167],[85,143,168],[83,142,168],[79,142,167],[75,140,165],[75,141,166],[75,142,167],[72,141,167],[74,143,168],[73,143,170],[72,144,169],[72,144,170],[72,144,170],[71,144,169],[73,144,170],[75,144,170],[75,143,170],[77,144,170],[91,146,169],[106,150,172],[103,150,171],[95,146,168],[84,145,169],[77,145,171],[74,145,172],[76,145,173],[76,144,173],[74,145,173],[73,145,173],[74,145,173],[72,144,173],[72,145,173],[73,146,173],[72,144,172],[71,144,172],[73,145,173],[73,145,172],[74,145,171],[75,146,172],[76,145,172],[76,146,173],[77,147,173],[77,147,174],[76,147,173],[76,148,174],[76,148,174],[74,147,172],[75,146,173],[76,146,174],[75,146,171],[83,146,170],[96,150,172],[109,157,177],[115,161,181],[124,166,186],[143,177,195],[166,191,206],[170,194,208],[170,194,208],[170,196,212],[169,198,214],[159,191,208],[138,177,198],[113,163,186],[89,151,176],[76,145,171],[75,146,172],[75,148,174],[82,145,169],[132,164,180],[191,202,217],[121,148,183],[98,136,181],[93,136,184],[87,135,182],[87,135,182],[88,136,181],[90,135,181],[87,136,182],[84,136,181],[88,136,179],[100,138,178],[128,153,184],[172,186,205],[194,208,223],[123,156,187],[86,130,176],[84,131,179],[85,131,177],[93,136,174],[128,159,185],[148,174,195],[153,174,197],[156,176,198],[157,177,198],[156,176,197],[154,174,195],[153,173,194],[153,173,195],[151,172,195],[151,172,194],[150,172,195],[152,171,194],[151,171,194],[149,170,193],[148,168,191],[146,163,187],[144,163,186],[141,164,186],[140,162,185],[138,161,185],[137,159,184],[133,157,183],[132,156,183],[130,155,184],[112,145,178],[86,127,168],[84,125,170],[85,125,171],[85,127,172],[85,127,172],[85,127,172],[84,127,171],[81,126,171],[81,126,172],[81,126,172],[81,126,172],[81,126,172],[82,127,173],[81,126,172],[80,125,171],[80,125,171],[80,125,171],[81,126,170],[82,127,170],[82,128,168],[85,128,170],[85,127,170],[87,126,167],[91,127,168],[92,129,166],[105,138,168],[137,161,186],[181,196,211],[201,191,167],[188,171,120],[183,162,99],[182,160,90],[180,159,86],[180,157,83],[180,157,82],[179,158,79],[177,156,74],[178,157,74],[178,157,75],[178,157,75],[177,156,75],[176,156,77],[176,157,80],[177,158,80],[176,157,80],[176,157,79],[176,157,77],[176,157,78],[176,157,80],[175,157,86],[174,161,102],[178,169,116],[178,173,117],[173,170,107],[165,167,91],[172,176,101],[174,177,108],[178,171,106],[176,162,89],[176,159,82],[176,159,79],[177,161,80],[176,164,83],[177,167,88],[176,172,95],[178,175,104],[181,181,116],[182,183,123],[180,182,122],[179,181,124],[179,182,129],[188,192,148],[189,193,154],[187,189,148],[181,175,113],[176,160,80],[176,158,74],[175,157,73],[176,158,75],[179,161,83],[177,165,84],[178,170,95],[181,174,101],[181,175,108],[186,181,125],[196,191,158],[198,195,169],[197,196,167],[198,194,166],[195,190,159],[190,181,146],[184,171,125],[180,164,105],[176,158,89],[176,156,80],[176,155,76],[175,155,76],[178,156,77],[179,155,76],[177,155,74],[176,156,75],[175,154,73],[173,152,72],[174,154,84],[178,163,107],[192,184,154],[183,197,206],[117,151,168],[76,132,159],[70,133,162],[69,133,161],[70,133,162],[70,134,162],[69,135,163],[71,137,164],[72,137,165],[73,137,165],[73,137,165],[71,138,165],[70,138,165],[69,137,164],[71,137,166],[70,138,165],[70,139,165],[73,140,168],[74,140,167],[76,141,168],[78,141,169],[77,142,168],[76,143,168],[74,142,167],[73,141,167],[73,142,169],[74,143,170],[73,144,170],[73,144,170],[73,143,169],[72,144,170],[71,145,170],[73,144,170],[75,144,170],[74,144,170],[75,143,170],[81,144,170],[86,146,173],[83,145,172],[79,144,170],[77,145,171],[75,145,172],[75,146,173],[75,146,173],[75,146,172],[74,145,173],[72,144,172],[73,144,172],[73,144,172],[74,145,173],[73,145,173],[72,145,173],[72,145,173],[74,145,173],[74,145,172],[75,146,172],[74,145,172],[76,145,172],[75,146,173],[77,147,173],[77,147,174],[76,147,174],[77,147,174],[77,148,174],[76,147,174],[76,146,173],[77,147,173],[81,146,171],[105,155,175],[135,174,190],[160,189,205],[170,194,210],[177,198,212],[186,202,214],[194,204,215],[185,198,205],[194,207,216],[193,206,216],[182,199,212],[160,188,205],[128,172,192],[92,153,176],[77,145,170],[75,146,172],[78,145,168],[110,155,171],[192,205,216],[172,190,211],[101,136,177],[95,137,183],[90,135,183],[86,135,182],[86,135,182],[86,135,181],[89,135,182],[85,135,181],[81,136,179],[83,134,178],[87,134,177],[100,136,175],[130,155,182],[172,184,202],[195,204,216],[171,189,207],[109,143,178],[86,131,176],[84,132,178],[87,132,175],[117,152,182],[169,188,202],[180,195,203],[183,194,205],[185,195,208],[184,194,206],[184,195,207],[181,193,204],[179,191,203],[179,193,205],[178,192,205],[176,189,203],[178,191,205],[177,189,202],[179,190,205],[176,189,202],[173,180,194],[176,186,198],[175,184,197],[172,181,194],[170,175,189],[171,179,193],[170,180,194],[172,184,199],[156,178,199],[102,139,174],[83,125,168],[84,126,171],[82,125,171],[83,126,172],[83,126,173],[84,126,173],[80,125,171],[80,125,171],[81,126,172],[81,126,172],[81,126,172],[80,125,171],[79,126,171],[80,124,171],[80,124,170],[79,125,170],[82,126,168],[83,126,166],[87,127,165],[92,128,166],[99,132,169],[107,138,172],[116,143,177],[129,155,184],[149,172,195],[177,193,211],[190,176,136],[181,160,91],[181,158,80],[181,157,78],[181,157,79],[181,157,79],[180,156,78],[179,157,76],[178,157,74],[179,158,74],[178,156,76],[178,156,77],[178,156,77],[178,156,78],[177,158,80],[178,159,82],[177,159,85],[175,158,84],[175,157,82],[174,156,82],[174,156,84],[175,160,97],[177,170,119],[180,177,130],[179,179,130],[174,174,117],[163,165,94],[165,170,97],[173,179,110],[180,179,117],[180,173,107],[178,168,96],[176,163,86],[177,164,84],[175,167,85],[176,172,91],[178,177,100],[178,179,106],[178,179,109],[182,181,117],[177,178,111],[173,175,106],[171,173,109],[182,185,135],[189,192,153],[188,192,152],[181,184,127],[177,168,94],[177,162,83],[175,160,80],[176,163,89],[179,169,101],[176,171,92],[177,175,94],[179,180,101],[181,180,106],[184,182,114],[189,184,132],[187,181,138],[182,175,129],[184,175,127],[183,171,122],[180,166,112],[175,159,97],[174,155,84],[175,154,75],[175,154,73],[177,155,70],[176,155,72],[177,155,73],[178,156,74],[178,156,72],[178,156,70],[176,155,65],[176,154,62],[179,155,67],[178,156,76],[180,163,97],[193,187,152],[156,178,190],[89,138,160],[71,133,161],[70,132,161],[69,133,162],[69,134,162],[70,135,163],[69,135,163],[71,137,164],[72,137,165],[72,138,165],[72,138,165],[71,138,165],[71,138,165],[71,138,166],[72,138,167],[71,140,167],[71,140,167],[71,141,168],[73,142,169],[74,141,169],[77,140,169],[75,141,167],[75,142,167],[75,143,168],[73,142,169],[72,142,168],[72,143,169],[72,143,169],[74,144,169],[74,145,169],[73,144,170],[71,145,170],[71,145,170],[74,144,171],[74,144,171],[75,144,171],[77,143,171],[79,146,174],[78,146,173],[77,145,172],[76,145,171],[74,145,172],[74,145,173],[75,145,172],[75,145,172],[73,145,172],[72,145,172],[72,144,172],[72,144,172],[74,145,173],[73,144,172],[72,144,172],[73,144,172],[75,145,172],[76,146,173],[75,146,172],[75,146,173],[75,146,173],[75,146,173],[78,148,174],[78,148,175],[78,148,174],[78,147,174],[78,147,174],[78,147,176],[77,146,172],[84,149,174],[109,160,182],[155,183,198],[178,196,207],[194,207,216],[189,205,217],[170,197,211],[117,169,189],[76,145,169],[76,147,172],[77,146,170],[97,147,166],[185,200,211],[160,182,207],[95,135,178],[93,138,184],[90,134,183],[86,135,180],[86,135,182],[86,135,182],[88,135,183],[86,135,181],[83,135,179],[85,135,180],[85,135,179],[88,136,178],[99,139,177],[127,154,187],[159,176,202],[178,192,212],[186,200,218],[185,201,218],[178,195,213],[162,185,206],[127,157,187],[91,131,171],[87,132,177],[86,131,175],[99,139,174],[156,179,200],[187,199,209],[162,136,142],[181,191,201],[138,165,190],[89,128,169],[84,125,170],[81,125,170],[82,126,172],[83,126,173],[82,126,172],[80,125,171],[80,125,171],[81,126,172],[81,126,172],[79,126,172],[79,125,171],[79,126,171],[79,125,171],[80,125,171],[80,125,169],[87,127,167],[93,132,166],[105,138,171],[120,148,180],[135,160,189],[149,170,196],[162,179,202],[176,191,210],[189,202,216],[199,190,161],[181,164,108],[179,157,81],[180,156,76],[180,156,77],[180,157,78],[181,158,79],[179,156,77],[178,156,73],[178,157,72],[178,157,72],[178,157,75],[178,156,76],[178,157,76],[178,157,79],[176,158,86],[177,160,90],[177,162,96],[177,163,98],[177,162,98],[177,162,97],[174,161,97],[178,166,109],[181,177,130],[177,179,134],[176,179,131],[172,175,120],[163,167,100],[160,165,95],[169,175,108],[179,185,121],[180,182,122],[180,181,118],[175,173,107],[175,172,97],[175,174,94],[175,176,99],[178,180,107],[177,180,109],[174,177,106],[173,175,105],[175,175,106],[175,174,110],[176,177,119],[183,186,137],[190,193,151],[186,190,143],[179,183,121],[177,177,101],[175,171,90],[174,168,89],[178,172,104],[182,179,119],[176,176,104],[175,177,90],[175,180,94],[177,179,97],[181,182,104],[186,184,117],[186,181,124],[178,168,108],[176,161,94],[178,160,90],[179,159,84],[177,158,79],[176,156,74],[174,154,70],[175,154,71],[175,154,71],[175,154,71],[174,155,70],[175,155,70],[176,155,71],[178,155,72],[177,154,70],[174,153,66],[177,155,68],[178,156,71],[178,157,77],[183,167,102],[200,195,166],[189,203,212],[119,155,172],[76,133,160],[70,133,162],[70,133,162],[70,133,162],[69,133,162],[70,135,163],[69,135,163],[69,135,163],[70,136,164],[70,137,164],[70,136,164],[71,138,165],[72,139,166],[71,137,166],[70,138,165],[70,138,166],[70,138,167],[69,139,166],[71,140,169],[74,140,169],[75,141,169],[75,141,168],[73,142,167],[72,142,169],[71,142,168],[70,143,169],[72,144,170],[73,144,170],[75,144,169],[76,144,170],[74,144,171],[73,144,170],[73,144,170],[75,144,170],[75,144,171],[75,144,170],[77,144,171],[77,146,173],[78,146,173],[77,145,172],[75,146,172],[74,145,173],[74,145,172],[74,145,172],[74,145,171],[74,145,172],[73,145,173],[72,145,173],[73,145,173],[73,144,172],[73,145,172],[73,145,172],[74,145,172],[77,145,172],[77,145,172],[75,146,172],[75,146,173],[75,146,173],[75,146,172],[76,146,173],[78,147,174],[79,147,174],[79,148,175],[80,146,174],[81,144,173],[93,149,173],[125,169,187],[158,189,202],[187,204,214],[183,203,214],[124,172,189],[76,144,168],[75,146,170],[73,145,169],[92,145,167],[184,200,211],[158,182,206],[95,137,178],[92,137,183],[88,135,181],[86,135,182],[86,136,182],[87,135,183],[86,136,182],[83,135,180],[83,134,180],[86,134,179],[86,134,179],[86,135,179],[88,134,178],[98,135,178],[111,141,179],[126,152,184],[133,160,190],[137,163,191],[129,156,184],[112,144,177],[97,133,172],[88,129,173],[89,131,177],[89,131,172],[131,162,189],[184,199,213],[155,95,95],[171,116,121],[191,156,164],[186,152,158],[178,136,140],[171,121,127],[178,136,140],[185,153,157],[170,188,204],[108,143,174],[83,126,167],[80,126,170],[80,126,170],[83,127,173],[82,127,173],[81,126,172],[81,126,172],[81,126,172],[80,126,171],[78,125,171],[79,127,171],[79,126,171],[79,124,170],[79,125,169],[88,130,169],[111,143,176],[133,159,185],[154,175,195],[173,187,206],[185,196,212],[192,203,215],[191,178,138],[178,159,91],[179,157,77],[181,157,77],[182,158,78],[182,157,78],[181,157,77],[179,156,76],[179,156,73],[179,157,71],[178,157,71],[179,157,73],[179,157,76],[178,157,76],[179,159,83],[179,163,97],[180,168,108],[181,172,115],[183,176,124],[183,176,128],[182,176,129],[180,175,125],[179,174,121],[178,178,126],[174,179,126],[171,178,122],[170,175,116],[163,168,103],[161,165,99],[166,170,108],[177,184,121],[176,184,119],[178,185,119],[176,183,118],[178,180,120],[180,182,121],[180,183,120],[179,181,117],[176,178,108],[172,175,102],[167,170,98],[174,176,107],[178,179,117],[183,185,130],[188,191,144],[189,192,145],[184,189,131],[174,180,106],[173,180,97],[172,178,94],[171,176,96],[175,178,112],[183,186,136],[179,184,121],[172,176,85],[173,179,82],[174,179,86],[177,181,93],[179,180,103],[184,184,121],[187,179,120],[178,161,89],[179,159,77],[179,157,74],[178,156,72],[178,158,73],[178,156,73],[177,155,72],[177,155,72],[177,155,72],[176,156,71],[176,157,70],[176,156,70],[176,155,69],[176,155,70],[176,155,69],[177,156,70],[178,157,71],[179,159,74],[180,162,87],[186,177,128],[172,192,202],[92,139,161],[72,134,161],[70,134,162],[70,134,162],[70,133,162],[71,135,163],[70,135,163],[69,135,163],[67,135,163],[69,137,164],[68,137,164],[68,137,164],[69,137,164],[70,138,165],[70,138,165],[69,138,165],[68,139,165],[69,140,166],[70,140,167],[71,141,167],[72,141,168],[73,142,168],[72,142,167],[72,143,168],[72,142,169],[72,143,169],[73,143,170],[73,143,170],[73,143,169],[75,144,170],[76,144,170],[76,144,171],[75,144,171],[74,144,171],[75,144,171],[75,145,171],[75,145,171],[76,145,172],[77,146,173],[77,146,173],[76,145,171],[75,145,172],[75,145,173],[74,145,172],[75,145,173],[74,145,171],[74,145,173],[74,146,173],[73,145,173],[74,145,173],[73,145,172],[72,145,173],[73,145,172],[76,145,172],[77,145,172],[78,146,173],[75,146,172],[75,146,173],[75,146,172],[75,146,172],[76,145,171],[76,146,170],[79,146,172],[83,145,172],[87,147,173],[103,152,176],[138,174,193],[172,197,212],[179,198,210],[172,193,204],[107,156,175],[75,144,169],[73,146,171],[72,146,171],[90,147,168],[183,202,213],[172,191,212],[107,143,180],[94,136,181],[90,136,182],[87,134,181],[87,136,182],[86,136,183],[85,136,182],[82,134,179],[82,134,179],[84,134,179],[83,134,179],[82,134,179],[85,135,180],[91,134,180],[96,134,178],[98,133,174],[98,135,173],[101,136,174],[98,135,173],[94,133,176],[89,130,176],[88,131,177],[89,130,177],[104,140,177],[167,188,205],[189,166,170],[150,72,75],[154,71,77],[162,93,101],[157,90,98],[149,77,84],[144,68,73],[146,75,81],[151,92,94],[185,154,156],[144,171,193],[88,129,166],[79,125,169],[79,125,170],[80,125,171],[81,126,172],[81,126,172],[81,126,171],[80,126,171],[78,126,170],[77,126,171],[80,126,172],[80,125,170],[79,124,170],[82,126,169],[113,149,180],[154,176,197],[178,193,209],[192,203,216],[185,171,124],[179,158,84],[180,157,76],[182,158,78],[181,158,76],[182,158,76],[180,157,76],[179,156,74],[180,157,74],[179,157,72],[179,157,71],[178,156,71],[178,156,75],[179,158,78],[178,161,92],[181,172,122],[183,181,132],[180,182,127],[183,187,132],[184,190,141],[184,190,145],[184,189,138],[178,180,122],[170,175,106],[168,175,102],[172,179,113],[171,178,117],[163,168,112],[159,163,108],[164,169,115],[173,180,119],[173,180,112],[171,181,106],[176,186,118],[184,191,140],[187,191,148],[186,190,144],[184,186,136],[176,178,114],[173,174,104],[169,173,101],[175,179,111],[178,183,121],[181,186,130],[187,192,140],[185,191,134],[177,186,111],[168,180,85],[169,180,82],[171,182,86],[171,181,93],[175,181,111],[182,187,140],[183,190,134],[168,177,78],[168,179,67],[170,180,71],[173,182,80],[175,181,91],[175,179,105],[186,185,125],[182,172,108],[176,157,77],[179,158,73],[179,157,70],[178,157,71],[179,157,73],[178,156,72],[178,156,73],[179,156,73],[178,157,72],[178,157,70],[178,157,71],[177,156,70],[176,156,70],[179,157,71],[178,157,71],[178,157,71],[178,158,73],[181,162,81],[179,165,100],[201,200,174],[149,175,189],[81,135,159],[71,134,162],[70,134,162],[71,135,163],[71,135,163],[71,135,163],[70,135,163],[69,135,163],[67,135,162],[67,135,163],[69,137,164],[69,137,164],[70,137,164],[70,138,165],[70,138,165],[70,138,165],[69,139,166],[69,139,167],[71,140,168],[71,141,168],[72,142,169],[72,142,167],[72,143,168],[72,142,168],[72,142,169],[72,142,170],[73,143,171],[74,143,170],[74,143,170],[75,143,170],[75,143,169],[76,144,169],[75,144,170],[74,144,170],[75,144,171],[74,145,172],[74,145,171],[74,145,171],[77,146,173],[76,146,172],[74,145,171],[77,145,172],[78,144,173],[76,143,173],[76,144,173],[74,144,171],[74,146,172],[74,145,172],[74,145,173],[74,145,173],[74,145,173],[74,144,172],[76,145,172],[79,146,173],[80,146,173],[80,146,172],[77,146,171],[76,146,170],[77,145,170],[79,145,170],[82,146,171],[86,147,171],[92,147,173],[100,151,177],[114,159,185],[143,176,199],[182,201,219],[195,208,221],[193,205,216],[185,201,209],[137,172,186],[85,145,166],[73,145,169],[72,146,169],[71,147,169],[93,148,168],[188,204,215],[192,206,223],[136,165,195],[99,139,179],[90,135,179],[88,135,180],[87,136,181],[85,135,181],[84,135,181],[81,135,179],[81,134,178],[83,133,179],[82,134,180],[83,134,180],[85,135,181],[89,135,182],[92,135,182],[93,133,180],[91,132,178],[90,131,177],[89,131,176],[91,131,179],[89,131,178],[88,131,177],[92,132,173],[138,165,190],[188,202,212],[186,160,166],[150,64,70],[156,53,60],[150,52,60],[150,50,60],[154,52,60],[153,50,56],[152,51,58],[151,58,62],[166,106,106],[175,190,202],[114,148,174],[80,125,166],[78,124,171],[78,125,171],[79,126,170],[80,125,170],[81,126,171],[81,126,170],[80,126,171],[81,126,171],[82,126,171],[81,125,171],[80,124,170],[92,133,171],[151,180,204],[188,203,217],[183,168,122],[181,159,82],[180,158,76],[180,157,75],[180,157,74],[180,158,73],[180,159,73],[179,158,72],[180,156,73],[180,157,74],[179,156,73],[179,156,73],[178,157,76],[179,158,85],[180,166,108],[185,180,133],[187,187,137],[181,185,126],[178,185,119],[180,189,128],[183,192,136],[182,191,131],[174,180,112],[164,170,90],[160,169,84],[170,179,104],[178,186,123],[174,181,131],[163,168,123],[164,169,122],[169,176,119],[168,175,106],[161,170,88],[167,178,105],[184,193,149],[191,197,171],[190,196,171],[189,194,164],[185,186,142],[176,178,118],[174,177,113],[176,181,119],[179,184,123],[177,184,119],[177,186,115],[177,186,110],[171,181,91],[166,178,73],[166,180,70],[169,180,76],[170,181,83],[171,181,95],[176,183,119],[181,189,127],[169,179,82],[166,178,62],[168,180,64],[171,182,70],[174,183,81],[175,181,96],[180,183,118],[189,184,128],[177,162,89],[179,157,72],[180,158,70],[180,158,70],[180,157,72],[179,156,73],[179,156,73],[180,157,74],[179,157,72],[179,157,71],[179,158,72],[179,157,72],[178,157,71],[179,157,71],[179,157,71],[178,158,71],[179,158,73],[182,160,79],[181,164,92],[191,188,151],[129,159,176],[73,132,157],[70,134,162],[70,133,162],[70,133,162],[71,135,163],[71,135,163],[70,134,164],[67,135,164],[66,135,163],[67,135,163],[68,136,163],[69,137,164],[69,137,164],[69,138,165],[70,138,165],[70,138,166],[70,139,167],[70,138,167],[71,140,168],[71,141,168],[71,142,167],[72,143,167],[72,143,168],[73,142,169],[72,142,169],[72,142,170],[73,143,170],[75,143,170],[74,143,170],[73,143,169],[75,144,169],[76,143,169],[75,144,169],[75,144,170],[75,145,171],[77,145,172],[76,142,170],[78,144,170],[80,145,172],[78,145,169],[77,144,170],[79,145,174],[79,143,173],[79,143,173],[76,144,172],[75,144,172],[75,145,171],[74,145,171],[73,145,172],[74,145,173],[75,145,174],[75,144,171],[78,145,171],[82,146,172],[84,147,172],[84,146,171],[82,146,169],[81,145,169],[85,147,171],[90,148,172],[98,152,176],[114,160,184],[130,168,191],[142,174,198],[153,175,202],[166,177,206],[191,197,220],[190,204,214],[151,180,194],[99,150,168],[78,144,166],[74,146,170],[72,146,169],[72,146,168],[99,149,169],[193,208,219],[174,195,215],[126,162,193],[98,140,180],[89,134,178],[88,135,180],[86,135,180],[85,134,180],[82,134,178],[83,133,178],[85,134,179],[88,134,180],[85,133,179],[85,134,179],[87,133,180],[89,133,180],[91,133,178],[89,131,177],[88,131,176],[88,132,176],[90,132,179],[88,131,178],[89,130,174],[112,145,177],[172,191,207],[187,161,167],[151,63,69],[162,50,58],[160,47,56],[160,46,57],[160,46,56],[160,46,57],[157,45,55],[155,48,57],[155,73,76],[192,167,169],[155,177,193],[92,131,165],[79,125,170],[79,127,171],[79,127,171],[79,126,170],[81,127,171],[81,126,170],[82,126,171],[83,126,171],[83,128,172],[82,126,172],[83,125,169],[98,136,172],[173,197,216],[185,171,132],[179,157,81],[179,157,74],[180,158,73],[179,156,73],[180,157,74],[180,158,72],[179,158,72],[179,158,74],[180,157,75],[179,156,74],[179,156,74],[179,157,76],[179,159,89],[185,174,122],[186,185,139],[184,186,132],[180,185,121],[174,181,104],[172,181,104],[173,184,111],[173,184,110],[170,178,97],[162,169,79],[156,165,70],[166,177,92],[178,188,121],[183,193,146],[174,180,141],[169,174,129],[170,176,120],[165,172,103],[151,159,78],[153,162,82],[171,180,124],[187,196,164],[190,198,176],[190,198,175],[192,198,166],[186,192,145],[178,183,124],[175,182,120],[175,182,118],[174,183,111],[173,183,106],[172,182,101],[166,177,84],[164,176,67],[166,180,65],[167,179,68],[167,179,72],[168,180,78],[172,182,95],[174,183,108],[169,179,81],[165,177,61],[166,178,60],[169,181,61],[171,183,71],[175,183,86],[178,184,109],[186,186,134],[185,174,115],[177,157,75],[179,158,69],[179,159,70],[179,158,70],[179,157,73],[180,157,74],[179,156,73],[179,157,73],[179,158,72],[179,159,72],[179,158,73],[178,157,73],[179,158,73],[179,157,73],[179,158,73],[180,160,74],[182,161,80],[183,165,92],[190,182,139],[111,149,168],[70,133,159],[70,133,162],[69,133,162],[69,133,162],[69,133,162],[70,134,163],[69,134,164],[67,135,164],[67,135,163],[68,136,164],[68,136,164],[69,137,165],[69,137,164],[69,138,164],[70,138,165],[72,138,166],[73,138,168],[72,140,168],[72,140,168],[72,140,169],[72,143,167],[72,143,167],[73,144,168],[73,143,168],[72,142,169],[74,141,169],[75,143,169],[74,143,170],[72,143,170],[72,143,169],[75,144,170],[74,143,168],[75,144,169],[75,144,171],[76,144,171],[81,145,170],[96,151,174],[105,156,177],[101,154,175],[95,150,172],[90,148,171],[83,145,172],[81,145,174],[82,145,174],[78,145,173],[77,145,173],[78,145,172],[77,146,172],[74,146,173],[75,146,173],[77,146,174],[76,146,172],[81,145,169],[90,147,170],[95,147,170],[103,151,172],[110,156,177],[121,164,184],[135,173,193],[144,177,198],[150,180,200],[165,190,210],[171,191,213],[166,179,211],[156,155,204],[152,143,198],[173,165,209],[192,190,215],[193,205,215],[161,183,195],[109,154,171],[80,144,167],[74,145,170],[73,146,169],[73,146,168],[76,146,167],[115,159,177],[199,214,224],[200,212,225],[170,193,213],[138,167,196],[111,148,183],[96,139,177],[92,137,177],[88,134,177],[86,134,178],[85,134,178],[86,134,179],[87,134,180],[86,133,178],[85,132,178],[86,132,178],[88,132,178],[89,132,177],[88,132,177],[87,131,176],[86,131,175],[87,130,177],[88,130,176],[96,135,176],[146,171,194],[185,197,205],[189,165,170],[152,64,71],[160,49,57],[161,48,56],[162,48,57],[161,47,56],[159,45,55],[157,44,54],[157,48,58],[150,64,71],[181,151,155],[178,192,202],[127,158,183],[86,129,167],[81,127,169],[82,128,171],[81,128,170],[80,127,169],[81,127,170],[83,127,170],[83,126,171],[82,127,171],[82,126,171],[83,125,169],[95,132,168],[169,190,207],[194,184,160],[179,159,95],[180,157,78],[181,158,74],[180,157,74],[181,158,74],[180,158,73],[179,158,72],[179,158,73],[180,157,76],[179,157,75],[179,156,75],[179,156,76],[178,160,92],[188,181,135],[186,186,140],[181,186,125],[180,185,112],[172,180,90],[164,175,75],[167,178,83],[172,182,91],[171,181,88],[166,177,82],[155,166,69],[162,172,78],[174,183,101],[183,191,131],[180,188,134],[172,178,123],[172,180,119],[169,177,109],[149,157,76],[148,157,75],[160,169,103],[178,186,146],[185,193,164],[192,200,174],[193,200,171],[190,197,155],[182,189,129],[175,183,119],[172,181,112],[171,181,104],[173,183,103],[174,185,102],[170,181,91],[165,175,69],[164,178,60],[169,181,64],[168,180,64],[165,180,62],[169,181,70],[170,181,84],[167,178,74],[163,175,60],[165,177,59],[167,179,58],[169,181,66],[172,184,78],[177,185,102],[183,186,129],[191,186,140],[179,163,93],[179,157,70],[180,158,70],[180,159,71],[179,157,72],[179,157,73],[179,157,73],[178,157,74],[179,158,72],[179,159,73],[179,158,74],[179,157,75],[179,158,75],[179,157,75],[179,158,75],[180,160,77],[181,161,82],[182,164,96],[191,181,136],[103,146,168],[70,133,161],[70,133,162],[69,133,162],[69,133,163],[68,133,162],[69,133,163],[68,135,163],[68,135,165],[68,136,165],[68,136,165],[68,136,164],[69,136,165],[69,137,165],[69,137,166],[70,138,166],[71,138,166],[73,139,167],[71,139,168],[72,140,169],[72,142,168],[71,142,168],[72,143,168],[73,144,168],[72,143,167],[73,143,169],[74,143,169],[75,143,169],[74,144,170],[73,144,169],[73,144,170],[74,143,170],[74,144,169],[74,145,170],[75,144,170],[78,144,169],[106,157,179],[141,176,193],[149,180,195],[139,172,187],[129,164,182],[118,161,177],[94,150,173],[82,145,172],[83,146,173],[82,145,173],[82,144,171],[84,146,171],[84,146,170],[79,145,171],[78,144,170],[80,144,170],[87,146,170],[111,156,177],[134,167,188],[147,177,195],[158,185,201],[161,187,203],[164,189,206],[170,191,211],[169,186,210],[169,181,211],[179,188,217],[178,182,217],[155,151,204],[132,114,189],[127,105,184],[151,130,195],[179,171,207],[190,203,214],[160,183,196],[114,155,172],[86,147,167],[75,146,170],[74,146,171],[72,146,169],[74,146,168],[84,146,167],[147,180,198],[198,213,225],[178,200,218],[154,181,205],[131,164,192],[115,150,185],[103,141,180],[93,137,177],[87,134,177],[85,133,178],[84,133,178],[85,133,177],[85,133,177],[88,133,177],[89,133,177],[90,131,175],[88,131,175],[87,131,176],[86,131,176],[89,131,175],[97,138,178],[124,156,189],[172,188,201],[193,169,175],[155,68,76],[160,50,58],[160,48,57],[161,48,57],[161,49,59],[159,47,57],[159,46,55],[158,51,61],[158,76,85],[182,151,158],[166,184,200],[116,149,176],[98,135,172],[91,130,169],[87,129,167],[82,126,167],[82,126,168],[82,126,168],[82,125,169],[83,125,170],[84,126,171],[82,125,170],[88,127,167],[137,160,186],[188,198,212],[189,173,133],[182,160,93],[183,159,79],[180,157,74],[180,157,74],[180,157,74],[179,157,71],[179,157,71],[178,157,73],[180,157,72],[179,157,74],[178,156,74],[178,161,92],[191,185,142],[188,188,141],[182,186,120],[178,184,102],[172,180,87],[162,172,74],[164,174,78],[171,182,89],[172,183,90],[174,184,91],[166,177,82],[162,173,78],[169,178,88],[174,184,108],[177,185,119],[171,179,114],[172,180,115],[176,185,114],[157,166,84],[150,160,76],[160,169,95],[173,180,131],[175,182,146],[188,195,162],[192,199,167],[188,197,153],[183,192,129],[179,188,119],[175,185,110],[171,181,102],[171,182,102],[174,186,108],[177,188,115],[171,180,97],[166,178,68],[169,180,64],[169,181,64],[166,179,61],[165,178,61],[169,180,70],[170,181,73],[162,174,61],[164,175,60],[166,179,60],[169,181,62],[170,182,70],[177,185,95],[182,187,125],[188,188,145],[187,174,117],[181,159,75],[181,159,71],[180,159,72],[181,159,74],[180,159,75],[180,159,73],[179,158,74],[178,157,72],[179,159,75],[180,159,75],[180,159,77],[180,159,77],[179,158,77],[180,159,78],[181,160,81],[180,162,88],[183,168,110],[195,186,152],[106,149,172],[72,133,161],[69,133,162],[69,133,162],[67,133,162],[67,133,162],[66,134,162],[66,134,163],[68,136,164],[68,136,164],[68,136,164],[68,136,164],[68,137,164],[68,137,164],[68,137,165],[69,138,166],[70,139,166],[71,139,166],[71,140,167],[71,141,168],[71,142,168],[72,142,169],[71,142,167],[72,143,167],[72,143,168],[73,142,169],[74,143,169],[74,143,170],[74,143,170],[75,143,170],[76,144,171],[74,144,170],[75,144,169],[75,143,170],[77,144,168],[102,155,175],[155,184,198],[176,193,203],[175,191,201],[169,186,196],[168,188,199],[164,189,201],[123,166,187],[89,147,171],[87,145,170],[93,147,171],[107,154,176],[121,162,183],[122,165,185],[117,163,185],[106,154,177],[104,152,174],[125,167,188],[159,186,204],[173,193,210],[180,198,214],[189,204,219],[184,198,213],[181,193,212],[181,189,216],[172,174,211],[167,163,209],[168,162,208],[155,144,201],[127,105,186],[108,77,177],[105,72,175],[123,91,180],[161,145,196],[196,207,217],[182,201,212],[152,181,196],[112,156,174],[89,147,167],[81,147,169],[75,146,170],[74,146,171],[75,146,170],[78,145,166],[107,156,175],[182,205,219],[202,215,224],[194,209,223],[180,199,218],[165,186,211],[145,172,202],[119,154,189],[93,137,177],[84,132,177],[83,131,177],[85,132,179],[85,132,178],[90,133,176],[92,133,175],[93,132,174],[91,131,172],[90,131,171],[101,136,174],[120,149,182],[137,161,187],[150,168,189],[145,126,124],[163,146,145],[196,174,180],[157,74,82],[161,53,62],[162,51,61],[161,50,61],[160,50,62],[158,49,59],[159,51,60],[158,60,71],[165,102,115],[183,193,203],[160,178,195],[143,165,189],[131,155,184],[121,150,178],[112,145,175],[107,140,174],[99,135,170],[94,132,169],[92,129,169],[90,129,170],[88,128,170],[89,127,167],[110,136,167],[151,167,187],[181,193,206],[187,171,131],[182,160,96],[181,158,80],[180,157,75],[178,156,74],[179,156,72],[179,156,72],[178,156,72],[179,156,71],[179,156,72],[179,155,72],[179,161,90],[194,186,144],[186,187,140],[182,187,118],[176,184,98],[171,179,83],[160,169,72],[163,173,76],[173,185,92],[175,187,95],[176,186,94],[174,185,91],[170,182,86],[170,180,85],[171,182,89],[173,184,104],[171,181,105],[170,179,107],[177,187,112],[167,178,92],[160,170,82],[164,173,93],[175,181,124],[177,182,137],[177,183,136],[186,193,143],[184,194,133],[181,192,117],[181,191,114],[180,190,110],[175,186,103],[171,183,100],[171,184,104],[177,190,122],[179,189,126],[172,181,97],[169,180,70],[170,182,64],[168,181,61],[166,178,59],[166,178,63],[171,183,71],[166,178,67],[162,173,60],[165,177,60],[167,179,61],[170,181,66],[175,185,88],[182,189,121],[186,189,143],[191,183,139],[183,162,84],[183,160,74],[182,159,73],[181,159,75],[180,160,77],[180,159,75],[179,158,75],[179,158,76],[179,158,74],[180,159,75],[179,158,76],[178,159,79],[179,157,80],[179,160,83],[180,162,90],[182,166,102],[184,175,130],[197,193,171],[116,155,176],[75,133,160],[69,134,162],[69,134,162],[68,134,162],[67,133,162],[66,133,162],[67,134,162],[67,135,163],[67,136,163],[68,136,164],[67,136,164],[66,137,163],[67,138,164],[67,138,164],[68,138,164],[68,139,165],[69,139,166],[71,141,167],[71,142,168],[71,142,168],[71,142,168],[71,142,168],[71,142,168],[71,142,169],[73,143,169],[74,142,169],[74,142,169],[74,143,170],[75,143,170],[74,144,171],[73,144,170],[74,144,170],[74,144,169],[86,146,169],[143,181,196],[177,195,204],[176,190,198],[176,189,197],[178,190,198],[188,201,210],[187,203,214],[148,182,200],[109,155,176],[110,155,176],[127,167,186],[154,184,201],[167,192,208],[169,196,211],[165,193,210],[151,181,199],[148,178,195],[173,193,210],[194,206,219],[195,203,217],[194,201,218],[196,202,221],[190,194,216],[178,177,209],[154,142,195],[135,114,188],[131,108,190],[128,102,191],[118,88,186],[105,73,180],[99,66,177],[100,65,175],[111,75,177],[147,123,190],[199,197,219],[190,204,213],[174,196,210],[140,174,190],[107,152,171],[90,147,168],[82,148,169],[80,148,171],[75,147,171],[75,146,171],[79,146,169],[92,149,170],[154,188,205],[206,218,230],[200,210,224],[190,205,221],[166,190,212],[121,156,186],[89,135,175],[82,132,176],[84,132,178],[87,132,177],[89,133,175],[92,131,172],[94,130,171],[110,139,172],[110,138,169],[116,138,167],[141,154,177],[153,160,177],[144,125,128],[123,89,84],[138,107,103],[158,88,96],[156,57,65],[159,54,64],[160,57,65],[159,64,74],[159,68,77],[162,67,77],[161,81,93],[176,134,147],[182,193,204],[175,190,206],[167,183,204],[160,179,200],[152,175,198],[147,171,196],[137,164,190],[127,156,185],[117,148,180],[108,139,175],[100,133,170],[96,131,167],[99,129,164],[113,138,166],[138,156,180],[165,177,196],[185,194,208],[202,194,177],[189,174,137],[181,161,102],[180,158,85],[178,157,78],[179,157,74],[179,156,74],[179,156,73],[180,158,71],[179,156,72],[179,155,72],[178,160,87],[194,185,143],[185,186,138],[180,186,114],[176,184,94],[171,180,81],[160,169,72],[163,175,78],[174,186,92],[177,188,97],[179,189,97],[178,189,96],[176,187,93],[174,185,88],[172,184,85],[174,186,96],[173,184,99],[169,179,100],[175,185,104],[174,183,94],[166,175,82],[165,175,88],[174,182,122],[180,187,142],[175,180,128],[175,182,119],[177,187,112],[178,189,106],[179,190,107],[180,192,106],[180,191,105],[176,188,103],[174,187,105],[176,189,121],[179,189,135],[180,188,125],[173,182,85],[168,181,64],[169,182,61],[167,178,59],[166,178,59],[168,180,65],[168,182,70],[164,175,65],[165,175,61],[168,179,61],[170,180,63],[174,183,77],[184,189,116],[186,189,141],[191,187,146],[186,166,94],[183,160,74],[183,160,75],[183,160,76],[182,160,79],[181,160,78],[181,160,77],[180,160,79],[181,160,82],[180,160,83],[178,159,85],[177,159,88],[178,160,92],[179,162,98],[182,168,112],[188,175,128],[194,186,155],[130,166,185],[80,137,162],[69,134,162],[69,134,162],[68,134,162],[68,134,163],[68,134,164],[68,135,163],[67,136,163],[66,136,163],[67,136,164],[66,137,163],[67,138,164],[67,139,165],[68,139,165],[69,139,166],[70,139,166],[71,139,166],[71,141,168],[71,142,167],[71,142,167],[71,142,167],[72,142,169],[71,142,168],[72,142,168],[74,142,169],[75,143,170],[74,143,170],[75,143,170],[74,143,170],[73,144,170],[73,144,170],[73,144,170],[74,143,169],[99,155,175],[170,199,209],[179,194,201],[179,191,199],[174,194,209],[147,178,194],[156,182,198],[176,195,208],[196,209,220],[193,205,216],[187,201,212],[186,198,211],[195,195,217],[182,177,214],[173,164,212],[170,160,212],[155,138,203],[126,99,187],[118,86,185],[117,84,187],[115,82,186],[110,76,183],[104,71,181],[101,68,178],[101,67,177],[106,71,175],[133,108,182],[187,183,210],[188,201,209],[180,197,207],[162,187,200],[129,167,185],[99,150,171],[85,147,170],[82,148,172],[79,148,171],[79,148,172],[77,147,172],[78,147,172],[91,149,172],[133,174,192],[198,214,227],[193,208,224],[159,186,208],[103,145,180],[83,131,175],[84,131,176],[88,133,175],[96,136,174],[101,135,171],[103,130,165],[130,146,170],[129,140,161],[127,129,149],[134,108,111],[120,84,79],[114,69,65],[124,80,75],[166,141,137],[169,122,132],[156,79,89],[155,65,75],[158,67,76],[169,96,104],[175,109,117],[174,102,111],[169,110,121],[187,163,174],[189,199,210],[185,196,209],[180,193,205],[180,193,206],[176,190,204],[171,186,202],[165,181,200],[160,177,198],[152,170,192],[139,163,186],[129,154,179],[118,145,173],[108,135,168],[116,141,174],[132,153,182],[153,169,191],[169,180,200],[180,189,206],[189,196,211],[191,177,142],[180,162,106],[178,157,87],[179,158,78],[180,157,78],[178,155,72],[178,155,69],[178,155,74],[179,156,73],[177,159,79],[191,183,138],[184,184,138],[177,183,108],[174,182,92],[170,179,82],[158,169,71],[166,177,83],[175,185,94],[176,187,96],[179,189,98],[179,190,98],[178,189,95],[177,188,91],[173,186,85],[174,186,91],[174,186,96],[170,181,96],[171,181,96],[173,183,91],[165,175,78],[162,173,80],[173,182,117],[183,190,147],[179,183,131],[172,179,106],[169,179,91],[175,186,96],[178,189,101],[179,191,101],[181,192,103],[179,190,103],[179,189,105],[177,189,116],[178,189,133],[181,190,142],[177,185,114],[171,181,76],[169,182,60],[168,181,58],[165,177,54],[167,178,60],[170,182,67],[168,179,69],[164,174,67],[169,179,67],[171,179,68],[173,181,72],[181,187,104],[187,190,137],[189,188,147],[187,172,104],[183,160,76],[184,161,76],[183,161,76],[182,161,80],[181,162,83],[180,160,82],[180,160,85],[180,160,91],[181,163,97],[181,164,103],[181,166,109],[185,171,118],[189,176,130],[193,183,146],[198,191,164],[205,201,185],[148,176,193],[91,142,166],[72,134,162],[70,134,163],[68,134,162],[68,134,163],[68,134,163],[69,135,164],[68,136,163],[68,136,163],[67,136,163],[66,137,164],[67,138,164],[68,139,165],[69,138,165],[72,140,167],[72,140,167],[73,140,168],[71,141,167],[71,141,166],[72,143,167],[72,143,167],[72,143,168],[72,143,168],[73,142,168],[74,142,169],[75,143,170],[75,143,170],[75,144,171],[73,144,170],[74,144,170],[74,144,170],[75,144,169],[75,144,169],[107,159,179],[169,192,202],[176,193,201],[193,205,214],[188,202,212],[190,203,213],[195,192,218],[172,160,208],[142,126,191],[132,112,186],[129,107,186],[120,92,182],[109,76,180],[111,75,186],[111,76,186],[110,74,186],[107,72,183],[104,70,181],[102,68,177],[100,67,174],[102,70,174],[123,97,178],[179,172,207],[162,185,196],[137,170,185],[112,157,177],[90,148,171],[80,147,169],[79,147,171],[80,149,174],[81,149,173],[79,149,172],[79,147,171],[89,149,172],[130,170,189],[184,206,220],[189,207,222],[133,168,196],[90,134,175],[86,131,176],[96,137,176],[120,152,179],[125,143,167],[117,124,149],[135,119,129],[127,97,104],[124,93,99],[124,87,94],[121,80,81],[118,73,72],[117,71,69],[121,76,73],[155,124,121],[192,170,182],[178,134,145],[167,102,114],[163,95,108],[186,148,156],[200,175,181],[196,167,172],[178,153,162],[187,197,207],[184,193,204],[183,192,204],[179,189,201],[170,184,199],[160,178,195],[147,169,190],[108,138,171],[93,126,166],[97,129,167],[111,138,171],[128,149,178],[143,159,186],[156,171,192],[171,181,201],[188,195,211],[194,185,161],[183,169,126],[176,159,97],[176,156,82],[179,156,75],[180,155,71],[180,155,73],[179,155,72],[177,157,77],[188,179,129],[185,185,141],[176,182,109],[175,181,93],[171,180,83],[158,168,71],[167,176,85],[176,186,97],[175,186,95],[179,189,99],[179,189,99],[179,189,95],[178,189,92],[175,188,87],[174,186,85],[174,186,92],[173,184,94],[170,181,90],[169,180,85],[163,175,73],[160,172,72],[172,182,110],[183,189,145],[177,184,128],[171,181,94],[162,173,69],[166,176,76],[176,187,96],[177,189,99],[180,190,100],[181,192,103],[180,191,103],[179,190,110],[180,191,126],[182,189,142],[180,187,134],[176,184,98],[170,181,68],[169,180,61],[166,177,57],[168,178,61],[170,180,66],[171,181,72],[167,175,72],[170,179,73],[173,181,75],[173,180,74],[177,183,92],[187,189,130],[191,189,144],[188,175,110],[184,162,79],[183,162,76],[182,161,75],[182,162,80],[180,162,87],[180,163,92],[181,163,102],[182,167,113],[185,172,125],[189,178,139],[192,184,152],[194,187,159],[197,192,170],[169,190,203],[117,156,176],[81,137,160],[72,135,163],[71,136,164],[69,134,162],[68,134,162],[70,135,164],[70,136,164],[69,137,164],[68,136,163],[68,137,164],[69,138,165],[69,139,165],[69,139,165],[72,140,166],[71,140,166],[74,140,168],[73,142,167],[72,142,166],[72,142,166],[71,143,166],[72,143,168],[74,143,167],[76,143,168],[75,142,169],[75,142,169],[75,143,169],[75,144,168],[74,144,168],[75,145,169],[74,144,169],[75,144,170],[76,145,169],[104,156,175],[140,175,191],[157,184,198],[182,198,207],[165,155,199],[134,112,187],[109,84,176],[104,75,175],[104,72,175],[103,69,177],[103,69,181],[106,73,185],[109,73,186],[106,71,185],[104,71,182],[103,71,181],[104,74,179],[104,74,175],[105,75,174],[121,97,177],[182,176,213],[164,185,196],[122,159,176],[103,150,171],[94,150,172],[87,149,174],[80,149,173],[79,149,173],[80,149,174],[80,149,173],[80,149,171],[84,147,170],[119,167,188],[179,206,222],[209,221,232],[166,190,211],[99,139,176],[85,130,174],[119,154,185],[160,176,193],[131,111,117],[133,108,109],[127,94,94],[120,79,79],[118,76,78],[120,77,79],[120,75,74],[119,74,72],[116,71,70],[123,77,74],[153,119,117],[199,174,186],[188,160,174],[181,192,202],[171,186,200],[126,156,184],[82,124,166],[82,125,169],[83,123,169],[88,124,168],[93,126,168],[98,129,167],[108,135,170],[121,146,176],[150,166,187],[181,189,203],[197,191,172],[187,176,141],[179,165,112],[177,157,91],[179,155,78],[179,155,73],[178,154,70],[177,155,75],[183,171,116],[187,186,143],[177,181,115],[176,182,98],[171,180,84],[160,169,73],[162,170,82],[176,185,98],[174,184,96],[178,188,100],[181,190,102],[179,189,98],[179,190,94],[177,188,88],[174,187,83],[174,186,85],[174,186,90],[174,185,91],[171,182,86],[163,177,71],[161,175,68],[171,182,104],[183,189,146],[176,183,130],[170,181,90],[162,174,62],[160,171,61],[169,179,85],[176,187,98],[179,189,99],[180,192,101],[180,191,101],[179,190,103],[180,191,119],[183,192,140],[181,188,143],[181,189,119],[174,183,81],[169,181,66],[167,178,60],[169,178,64],[171,180,67],[172,181,74],[170,178,77],[172,179,79],[176,183,83],[176,181,80],[176,180,85],[185,186,115],[192,187,132],[188,173,107],[182,163,77],[184,162,76],[182,163,73],[181,164,80],[181,167,99],[182,172,121],[188,178,142],[190,184,157],[193,189,168],[184,200,213],[146,177,195],[100,148,171],[79,137,165],[75,137,166],[71,136,163],[69,135,163],[70,136,164],[70,136,164],[70,136,164],[71,137,164],[71,137,165],[72,138,166],[70,139,166],[70,139,165],[72,141,164],[72,140,164],[77,141,166],[77,141,165],[77,142,164],[75,142,164],[75,142,165],[75,142,165],[77,143,166],[78,143,166],[76,143,167],[76,143,168],[76,143,168],[76,145,168],[75,145,169],[76,145,169],[75,145,170],[76,146,170],[81,147,171],[93,147,168],[101,148,167],[124,159,174],[175,192,201],[196,199,224],[143,127,193],[111,80,181],[96,67,174],[94,64,174],[95,63,175],[97,65,177],[100,69,180],[103,71,184],[106,72,184],[104,71,184],[102,73,180],[104,79,177],[112,91,176],[120,98,178],[119,97,177],[136,120,183],[194,192,221],[144,168,181],[112,153,173],[98,149,171],[88,148,170],[84,150,174],[80,149,174],[81,151,175],[82,151,174],[81,151,173],[82,149,170],[101,157,177],[166,198,214],[207,221,232],[182,201,218],[104,141,176],[87,130,172],[151,177,200],[146,128,131],[138,103,100],[133,93,89],[126,82,79],[120,74,73],[118,73,72],[118,73,71],[120,75,72],[119,75,71],[118,72,70],[128,82,80],[153,118,118],[145,167,190],[85,123,163],[80,125,171],[79,125,170],[79,125,170],[81,124,170],[84,125,168],[88,126,169],[91,127,169],[107,135,170],[134,153,179],[168,180,196],[193,185,160],[185,168,125],[177,156,93],[178,155,75],[179,154,71],[178,154,74],[178,162,98],[188,185,142],[181,182,131],[179,182,112],[173,181,89],[164,173,74],[157,165,74],[174,183,97],[174,184,95],[176,187,97],[179,189,101],[179,190,102],[179,189,95],[178,189,89],[175,187,84],[175,186,83],[176,186,85],[176,186,89],[174,186,86],[166,178,71],[163,176,67],[169,182,94],[184,193,148],[176,184,137],[169,180,91],[163,175,59],[161,173,54],[166,176,77],[176,185,100],[178,188,100],[180,190,100],[181,192,99],[179,190,98],[178,190,109],[182,194,134],[182,191,147],[183,190,138],[178,186,98],[170,180,71],[169,178,64],[169,178,65],[170,178,68],[172,179,77],[173,179,81],[172,177,82],[179,184,90],[177,179,82],[177,176,81],[181,178,95],[189,180,111],[187,171,93],[182,163,74],[183,163,74],[183,164,73],[183,168,88],[187,177,121],[192,186,151],[198,193,173],[195,207,216],[172,194,208],[134,169,190],[100,148,173],[84,140,166],[75,137,163],[72,137,164],[73,137,165],[72,137,165],[71,137,163],[72,137,164],[73,137,164],[74,139,165],[72,139,165],[71,139,164],[71,141,164],[74,141,165],[77,142,165],[78,142,165],[78,143,164],[78,143,164],[79,143,166],[78,143,165],[79,144,165],[80,144,166],[78,143,166],[78,143,168],[77,143,168],[76,145,167],[77,145,167],[77,145,168],[76,145,169],[80,146,170],[85,147,170],[90,146,169],[89,145,166],[109,151,165],[170,189,196],[200,204,229],[141,126,194],[100,72,174],[93,65,174],[92,62,175],[93,62,175],[96,65,177],[97,67,178],[101,70,182],[104,72,182],[103,75,182],[108,84,181],[129,111,191],[160,149,210],[175,163,219],[168,157,213],[181,175,215],[209,213,232],[155,176,189],[133,167,182],[118,161,177],[97,153,173],[80,148,172],[78,149,173],[80,150,174],[82,150,175],[83,150,175],[85,148,171],[129,171,189],[198,216,228],[183,200,215],[104,140,175],[95,134,173],[171,188,207],[147,117,112],[141,99,95],[132,86,83],[124,77,75],[121,74,72],[120,74,72],[118,74,70],[120,76,72],[121,76,73],[121,77,73],[136,88,84],[154,118,116],[156,175,196],[90,125,165],[81,125,171],[78,125,171],[78,125,171],[79,125,171],[80,125,171],[82,126,171],[81,124,171],[88,124,169],[98,128,165],[123,145,172],[171,180,195],[186,173,145],[177,156,95],[180,155,79],[179,155,76],[177,156,84],[184,176,120],[185,185,139],[182,184,130],[177,184,108],[169,178,82],[158,166,74],[166,175,88],[173,183,96],[173,184,94],[177,187,100],[180,190,105],[180,190,100],[177,189,92],[177,187,86],[176,186,83],[176,185,81],[176,185,83],[175,186,82],[166,178,69],[162,175,62],[168,180,84],[184,195,146],[181,190,148],[168,180,95],[163,177,57],[161,174,50],[165,178,72],[177,186,110],[177,187,106],[179,189,101],[180,190,97],[180,191,93],[179,191,98],[182,194,120],[186,196,145],[182,189,145],[180,188,110],[171,181,77],[169,179,67],[170,178,67],[172,179,72],[173,179,78],[174,179,84],[174,177,87],[181,183,94],[179,178,88],[179,174,84],[178,171,85],[184,171,92],[183,167,84],[183,163,74],[183,164,74],[183,164,72],[188,173,95],[195,188,144],[202,200,180],[190,203,213],[168,191,205],[139,172,189],[110,154,175],[88,143,166],[80,140,165],[77,139,166],[74,138,166],[72,137,163],[73,138,163],[74,138,164],[74,139,164],[74,140,165],[73,141,163],[74,142,163],[76,142,164],[76,142,162],[78,140,163],[79,141,163],[82,143,164],[82,143,163],[83,144,163],[83,144,163],[83,144,162],[82,143,163],[83,144,166],[82,144,166],[81,145,165],[83,147,164],[87,148,163],[90,148,163],[96,150,163],[99,151,163],[100,150,164],[99,149,161],[121,155,159],[164,182,181],[206,210,234],[153,141,205],[103,77,176],[93,65,173],[93,63,175],[94,64,176],[95,65,177],[96,66,178],[99,70,179],[102,75,180],[108,86,183],[131,116,194],[170,166,213],[191,192,221],[195,197,220],[190,192,215],[168,182,190],[156,178,188],[153,181,192],[124,170,187],[83,148,172],[79,149,173],[79,150,174],[81,150,174],[81,149,173],[85,147,170],[145,179,196],[205,219,229],[172,190,207],[101,137,176],[101,138,175],[180,194,211],[145,112,106],[138,95,89],[129,83,80],[122,76,73],[121,74,71],[121,75,72],[119,75,71],[121,76,72],[121,76,73],[122,76,73],[134,87,82],[152,114,109],[164,180,198],[98,131,169],[81,125,169],[78,125,169],[78,125,170],[78,125,171],[78,125,170],[80,125,171],[80,125,172],[81,125,172],[83,124,169],[89,124,166],[120,143,173],[177,185,200],[186,171,133],[176,155,89],[178,154,79],[177,155,79],[177,164,99],[189,184,137],[182,184,141],[183,188,129],[172,181,95],[164,173,80],[164,171,84],[170,179,94],[170,179,93],[173,183,97],[179,189,104],[179,190,104],[177,189,96],[177,186,91],[176,186,83],[174,184,79],[174,184,77],[171,182,75],[163,175,63],[161,173,57],[166,178,73],[182,193,137],[188,197,158],[169,180,103],[162,178,58],[158,174,45],[161,176,58],[179,190,112],[179,188,120],[179,187,106],[180,190,98],[181,191,94],[179,190,94],[180,192,108],[187,197,138],[183,191,145],[179,187,114],[172,181,82],[169,178,69],[171,178,69],[173,179,73],[173,178,77],[173,178,84],[175,177,91],[180,180,97],[182,177,94],[182,172,87],[182,169,85],[183,166,82],[184,165,77],[183,164,75],[182,163,73],[183,165,75],[188,174,100],[201,197,164],[190,205,216],[172,195,209],[143,177,196],[113,158,178],[95,146,168],[82,141,166],[75,138,164],[73,138,163],[73,138,163],[74,139,164],[76,139,163],[76,140,162],[78,141,160],[80,143,160],[83,142,161],[83,141,158],[86,142,160],[89,143,161],[92,144,158],[95,145,156],[95,145,156],[95,145,153],[98,146,151],[95,145,151],[98,146,151],[102,148,149],[107,149,148],[114,152,145],[118,154,146],[121,156,148],[126,157,149],[128,159,151],[129,160,154],[130,160,152],[145,164,151],[161,172,155],[176,181,160],[180,182,160],[175,175,149],[174,173,143],[176,177,145],[178,180,154],[210,215,234],[170,162,217],[114,92,183],[94,65,170],[93,63,174],[95,66,176],[97,68,177],[101,73,177],[106,81,179],[116,99,182],[136,126,192],[169,165,213],[198,201,225],[201,207,224],[168,180,188],[166,183,190],[171,192,202],[142,184,199],[87,151,175],[80,150,174],[80,150,174],[81,150,174],[81,150,173],[87,148,171],[143,176,192],[195,210,220],[146,170,193],[97,136,175],[110,143,177],[185,197,213],[145,109,104],[133,89,84],[127,80,77],[122,76,73],[120,74,71],[120,75,72],[120,76,72],[121,76,73],[120,75,72],[119,75,72],[126,80,74],[144,104,95],[184,166,165],[170,184,196],[114,145,175],[85,128,168],[77,124,167],[77,124,170],[79,123,171],[77,123,170],[79,124,170],[78,124,170],[77,124,170],[79,124,170],[81,123,168],[90,125,164],[132,150,175],[200,194,178],[181,163,111],[177,155,84],[177,154,78],[177,156,85],[187,173,120],[186,183,147],[185,190,149],[179,185,124],[169,178,93],[166,176,87],[168,179,93],[168,179,93],[168,178,92],[171,183,96],[174,186,100],[176,188,99],[175,185,92],[173,184,83],[172,183,77],[170,182,73],[166,178,70],[161,174,62],[160,173,60],[166,179,74],[179,191,128],[192,201,164],[173,183,115],[163,178,64],[159,175,47],[159,175,50],[175,189,100],[184,194,136],[179,188,118],[180,190,102],[181,190,95],[180,191,94],[180,191,101],[185,195,125],[184,190,137],[176,181,109],[174,180,89],[172,179,79],[172,179,74],[173,180,75],[173,179,77],[175,179,85],[177,178,92],[181,175,95],[184,175,94],[185,171,89],[184,168,85],[184,166,85],[186,166,83],[186,165,78],[184,165,76],[184,165,76],[186,170,95],[205,199,165],[193,207,217],[180,201,213],[162,189,202],[139,173,188],[103,153,173],[80,140,164],[75,139,163],[73,140,163],[76,139,164],[77,140,162],[78,140,161],[84,141,156],[92,143,152],[110,149,147],[119,152,150],[123,155,155],[123,156,154],[120,153,148],[118,152,146],[110,148,142],[116,149,137],[121,152,135],[118,152,135],[123,154,135],[126,156,135],[131,156,134],[138,159,131],[138,159,133],[141,160,135],[146,162,135],[149,163,137],[152,166,139],[156,167,137],[159,167,134],[160,162,124],[165,163,117],[167,165,112],[166,163,107],[169,164,108],[169,168,110],[175,175,137],[212,218,235],[190,189,227],[141,129,197],[113,93,180],[103,79,176],[104,79,177],[114,92,181],[124,106,186],[136,122,193],[156,150,205],[177,176,218],[190,195,224],[198,206,222],[173,184,192],[178,192,199],[177,195,204],[138,178,194],[85,150,174],[78,148,174],[81,150,174],[81,149,174],[79,149,173],[85,150,173],[121,165,182],[158,185,198],[170,192,205],[179,199,212],[192,208,218],[174,189,202],[116,146,175],[97,137,177],[128,156,186],[186,193,207],[145,107,104],[128,83,80],[122,76,72],[119,73,71],[119,74,71],[119,75,71],[118,75,71],[117,74,70],[114,72,68],[114,72,68],[117,74,68],[127,86,78],[155,123,120],[178,160,164],[146,168,189],[109,144,175],[85,128,166],[77,122,167],[78,123,170],[77,123,170],[79,124,170],[78,124,170],[77,124,170],[78,124,170],[80,125,171],[83,125,170],[98,128,162],[154,165,184],[191,180,151],[177,155,92],[177,155,82],[176,155,82],[179,161,94],[186,178,126],[188,189,150],[187,190,147],[178,184,120],[171,180,100],[171,180,96],[170,181,95],[168,179,93],[166,178,91],[170,182,96],[173,185,99],[174,184,94],[172,183,85],[170,182,78],[167,179,73],[165,177,70],[162,176,66],[162,176,67],[167,182,79],[181,193,123],[194,202,166],[179,187,129],[166,180,76],[162,177,56],[158,176,51],[169,183,79],[186,197,140],[181,190,139],[180,190,115],[180,190,98],[179,190,94],[179,190,97],[183,192,114],[185,190,126],[174,176,106],[175,177,91],[175,178,88],[174,179,86],[175,181,83],[176,182,84],[176,182,91],[182,183,102],[180,176,97],[183,171,91],[186,169,88],[185,167,85],[185,166,84],[186,167,82],[186,166,80],[186,166,78],[186,166,78],[184,167,86],[198,189,144],[196,210,218],[191,208,216],[176,198,208],[133,171,185],[87,143,163],[74,140,163],[75,140,165],[76,139,163],[79,139,158],[85,140,153],[95,143,146],[111,148,140],[132,156,139],[142,161,146],[145,163,148],[144,161,142],[138,158,136],[132,154,133],[125,150,128],[136,154,121],[143,157,117],[144,157,114],[149,161,114],[150,160,112],[150,160,112],[152,159,112],[146,156,116],[147,156,117],[151,157,113],[156,159,115],[159,161,115],[162,164,115],[163,164,114],[162,160,103],[165,160,95],[165,159,91],[165,160,94],[167,162,99],[166,165,113],[182,183,158],[203,206,233],[176,170,219],[145,133,200],[126,110,190],[127,110,189],[145,133,199],[163,156,209],[175,171,214],[191,194,222],[196,205,225],[193,205,221],[191,205,217],[184,197,210],[184,198,204],[165,188,200],[118,163,183],[84,150,174],[78,149,175],[80,150,174],[81,150,174],[80,149,175],[83,149,173],[101,153,173],[114,156,174],[119,158,175],[128,164,180],[149,177,190],[182,197,209],[187,199,211],[134,161,185],[99,137,177],[104,142,180],[152,165,186],[165,147,143],[137,101,96],[124,80,77],[120,75,72],[118,73,70],[118,74,70],[118,75,71],[118,75,71],[113,71,67],[109,68,63],[111,70,65],[111,70,65],[113,72,66],[117,81,77],[127,98,99],[156,134,137],[173,188,202],[147,173,194],[114,150,180],[81,124,166],[77,122,169],[77,124,170],[79,125,171],[79,125,171],[77,124,170],[77,124,170],[77,124,170],[78,125,171],[83,125,168],[116,140,170],[184,189,204],[199,192,172],[178,159,100],[176,155,83],[177,156,82],[174,155,81],[176,163,101],[185,181,137],[188,189,150],[184,188,139],[176,183,113],[172,181,100],[172,181,97],[170,182,96],[169,181,95],[170,182,96],[171,183,97],[173,182,97],[171,182,91],[170,181,83],[169,179,78],[167,179,76],[167,179,75],[167,181,79],[172,184,90],[184,194,125],[192,201,158],[182,192,131],[170,183,85],[164,180,65],[160,177,58],[165,180,74],[183,196,132],[186,197,154],[183,193,141],[183,193,122],[180,191,105],[177,187,95],[177,186,101],[183,188,118],[177,177,107],[176,173,93],[177,177,92],[176,178,90],[176,180,88],[177,183,88],[178,184,93],[187,188,110],[187,185,110],[184,171,93],[187,169,88],[187,167,85],[186,167,83],[186,167,80],[185,166,79],[186,166,79],[186,166,79],[185,165,81],[190,174,106],[204,198,167],[192,209,217],[157,189,200],[91,148,167],[76,142,165],[77,141,165],[79,139,159],[89,140,148],[99,142,140],[115,148,132],[132,153,121],[141,157,125],[147,159,133],[151,158,131],[146,155,119],[139,151,113],[136,149,112],[135,149,110],[146,155,108],[153,157,106],[155,160,106],[157,162,109],[157,161,105],[159,161,106],[157,159,106],[151,155,107],[149,152,106],[150,152,105],[152,154,107],[155,156,107],[160,160,111],[162,162,113],[164,161,107],[167,163,103],[167,163,103],[168,165,111],[167,166,117],[169,170,135],[204,211,226],[192,196,223],[178,175,217],[163,160,209],[166,163,209],[182,185,218],[192,200,223],[194,202,222],[196,207,222],[187,204,217],[168,193,207],[148,178,194],[141,167,184],[186,197,209],[180,194,201],[151,177,190],[108,155,175],[85,150,175],[79,150,174],[81,151,175],[82,150,174],[80,149,175],[82,149,173],[87,149,171],[91,149,171],[91,147,170],[92,148,169],[107,154,171],[141,167,183],[182,195,205],[188,197,213],[146,168,193],[106,142,178],[96,138,181],[111,145,182],[158,165,181],[151,136,138],[141,115,111],[128,89,87],[123,79,76],[121,76,73],[120,75,72],[119,76,72],[119,77,73],[119,76,73],[110,69,64],[107,65,61],[108,67,63],[107,68,63],[112,75,70],[111,74,68],[110,71,68],[119,87,84],[158,133,134],[144,130,135],[117,99,107],[104,85,94],[116,96,101],[136,115,118],[143,123,125],[159,143,145],[174,190,200],[149,174,191],[98,136,170],[77,123,167],[77,124,170],[78,126,171],[80,126,172],[79,125,171],[79,124,170],[78,124,169],[78,125,169],[81,126,169],[96,128,165],[156,168,188],[201,194,176],[181,163,108],[176,154,83],[177,157,81],[176,156,80],[176,157,87],[178,165,109],[185,181,137],[186,188,146],[179,184,127],[173,181,108],[171,181,102],[170,181,100],[171,183,97],[172,183,97],[170,182,97],[172,181,100],[172,182,97],[170,182,90],[170,181,86],[170,181,87],[172,182,88],[172,184,91],[176,187,101],[185,195,125],[188,197,144],[182,192,126],[175,187,94],[167,182,71],[162,179,64],[164,180,73],[179,194,123],[187,200,159],[189,198,161],[189,199,150],[186,196,127],[177,188,99],[173,182,93],[178,185,107],[180,179,109],[178,171,96],[179,173,93],[178,175,93],[178,179,94],[178,184,90],[179,187,93],[184,190,110],[190,193,125],[186,180,111],[184,169,90],[187,168,86],[187,167,83],[185,167,80],[187,167,80],[187,167,80],[186,166,79],[185,165,79],[185,167,87],[192,178,117],[203,198,167],[198,212,220],[164,193,204],[87,144,165],[77,142,165],[81,143,162],[98,146,148],[119,147,125],[134,151,113],[143,154,107],[144,154,109],[143,154,110],[146,155,122],[148,157,129],[146,156,127],[142,154,123],[137,149,112],[141,150,110],[148,155,113],[155,159,113],[159,163,117],[159,165,120],[160,164,116],[161,165,120],[160,162,119],[156,160,119],[153,157,116],[153,156,116],[155,158,116],[158,160,117],[161,162,118],[164,163,121],[168,167,124],[172,170,126],[170,171,132],[170,174,148],[167,172,152],[198,207,221],[191,202,220],[188,199,223],[184,196,223],[182,193,220],[186,201,222],[186,203,220],[178,198,214],[169,192,207],[149,180,197],[126,168,186],[109,156,175],[115,153,170],[175,191,203],[172,186,193],[152,178,191],[112,157,177],[88,150,174],[78,149,173],[81,150,174],[83,150,175],[80,149,174],[80,149,174],[84,149,173],[84,149,172],[82,148,173],[80,147,172],[85,148,169],[106,152,172],[143,170,186],[191,202,212],[183,196,211],[149,166,191],[110,143,177],[96,139,180],[95,139,182],[117,149,183],[136,111,113],[126,92,91],[123,83,83],[121,77,77],[122,79,76],[124,80,77],[124,81,77],[122,81,77],[118,76,72],[109,67,63],[107,66,62],[105,65,60],[102,68,64],[114,91,87],[111,83,77],[105,67,59],[103,66,58],[124,88,82],[178,155,154],[151,132,131],[116,90,93],[101,75,81],[101,77,82],[113,89,92],[132,102,102],[137,103,101],[140,103,101],[162,136,135],[167,185,199],[116,149,179],[79,124,167],[77,124,170],[78,125,171],[79,126,171],[80,125,171],[80,125,171],[80,126,171],[79,126,169],[79,125,169],[86,124,165],[131,150,175],[199,189,156],[182,163,102],[174,155,78],[177,156,79],[177,156,80],[177,157,81],[174,158,84],[175,165,103],[180,181,128],[179,183,125],[174,181,111],[171,180,106],[171,179,103],[170,181,101],[172,182,101],[172,182,101],[172,181,104],[171,181,101],[170,181,96],[171,182,94],[171,182,95],[174,184,96],[176,185,98],[177,188,106],[181,191,118],[181,191,126],[179,189,117],[179,189,102],[170,185,79],[165,181,70],[166,181,76],[176,190,114],[186,199,155],[190,199,169],[194,201,173],[192,200,159],[181,191,118],[173,181,93],[175,182,100],[181,182,108],[180,174,99],[179,171,92],[180,171,92],[181,176,96],[180,181,94],[178,185,89],[182,189,98],[187,193,118],[193,193,130],[186,174,106],[185,168,87],[187,168,84],[187,168,82],[187,167,80],[187,167,80],[187,168,81],[186,166,79],[184,165,81],[184,165,89],[186,176,121],[195,191,164],[198,211,220],[147,181,194],[80,142,164],[75,142,164],[101,148,155],[129,155,132],[145,157,112],[151,156,103],[152,156,101],[149,154,110],[147,154,115],[152,161,135],[154,167,147],[151,165,148],[148,163,141],[144,159,129],[147,157,125],[150,160,127],[156,164,130],[161,169,138],[161,169,142],[162,170,144],[163,174,153],[162,172,154],[163,169,149],[164,169,145],[170,175,155],[171,178,160],[199,209,221],[189,204,218],[180,199,215],[175,196,216],[174,196,217],[170,193,213],[166,192,209],[156,185,202],[141,173,190],[123,160,180],[104,151,174],[91,149,172],[86,148,171],[102,151,171],[162,186,199],[178,190,197],[168,188,200],[136,171,189],[98,155,176],[81,149,172],[82,150,174],[83,150,174],[84,149,173],[83,149,173],[85,150,174],[84,150,174],[83,150,174],[81,150,174],[82,149,172],[91,147,171],[114,152,172],[160,178,191],[202,210,225],[178,191,210],[142,163,189],[110,143,180],[93,139,181],[94,140,183],[95,139,180],[119,151,184],[134,112,119],[121,87,88],[122,84,88],[126,86,88],[127,87,86],[126,86,83],[128,87,84],[126,86,82],[119,79,74],[110,69,65],[107,66,62],[103,63,58],[102,70,66],[127,112,109],[120,100,94],[108,70,64],[105,65,59],[109,69,63],[143,111,109],[174,156,155],[125,95,93],[100,70,71],[99,75,80],[108,89,95],[122,106,110],[135,116,116],[139,111,107],[128,89,83],[135,98,96],[171,153,155],[173,188,200],[126,154,182],[81,124,166],[77,124,170],[78,125,171],[78,126,171],[78,126,171],[80,125,171],[78,126,170],[80,125,170],[78,125,169],[83,125,168],[115,142,171],[200,195,170],[189,177,130],[176,157,88],[174,155,77],[177,156,78],[176,157,79],[176,157,79],[174,158,79],[172,161,91],[174,172,114],[174,179,121],[172,178,113],[172,178,109],[171,178,108],[172,180,108],[172,182,107],[171,181,106],[171,179,107],[171,180,107],[171,181,104],[172,183,103],[173,184,103],[174,184,102],[176,185,102],[176,187,105],[176,187,109],[176,186,108],[176,187,105],[178,190,103],[174,187,93],[171,183,86],[171,184,93],[177,189,118],[185,197,148],[189,199,161],[192,200,168],[194,202,167],[187,195,136],[176,183,102],[176,181,99],[180,182,105],[182,179,103],[180,172,94],[179,169,92],[180,170,92],[181,177,94],[177,181,86],[177,183,85],[182,189,104],[191,196,134],[194,188,129],[187,171,97],[187,168,85],[187,168,83],[187,167,81],[188,168,81],[188,168,82],[187,167,80],[186,166,79],[186,165,80],[185,167,91],[188,173,117],[193,184,144],[196,195,171],[188,204,213],[119,162,178],[75,141,163],[82,144,165],[127,159,152],[148,159,116],[155,157,99],[157,157,95],[158,158,104],[159,161,125],[157,165,143],[152,175,172],[145,170,168],[142,168,163],[138,161,156],[139,159,151],[144,162,153],[146,166,157],[152,171,162],[155,172,164],[157,176,168],[158,177,173],[158,176,172],[156,177,174],[154,176,175],[157,177,177],[157,177,176],[154,172,169],[151,168,164],[148,168,163],[147,169,168],[144,169,169],[141,168,168],[138,164,167],[155,174,176],[181,198,210],[159,185,200],[141,174,194],[132,169,192],[126,166,189],[119,161,185],[112,157,179],[102,151,173],[94,147,169],[91,147,171],[89,149,174],[84,150,175],[83,151,176],[94,151,174],[141,177,193],[192,208,217],[188,203,212],[163,192,207],[113,165,186],[83,150,172],[83,150,173],[83,150,173],[86,150,174],[85,149,173],[85,149,174],[85,150,174],[83,150,173],[82,150,173],[83,150,174],[85,148,173],[94,147,170],[125,157,174],[188,199,209],[191,202,217],[161,179,204],[131,159,191],[108,144,182],[99,140,181],[97,139,184],[97,140,184],[97,139,181],[122,152,185],[176,183,200],[131,105,111],[131,100,107],[138,110,114],[142,114,116],[135,105,106],[134,102,103],[132,98,96],[123,85,81],[115,74,71],[108,68,64],[104,64,59],[104,74,70],[134,124,121],[127,112,107],[113,76,73],[110,69,65],[109,67,63],[124,85,80],[182,160,161],[147,123,123],[109,75,73],[98,66,66],[107,85,88],[124,112,117],[147,126,121],[131,90,83],[131,88,83],[149,122,124],[174,186,197],[127,153,179],[82,125,166],[78,125,170],[79,127,170],[78,125,171],[78,125,171],[78,125,171],[78,125,170],[78,125,170],[77,125,170],[82,126,168],[110,139,170],[198,194,174],[189,180,142],[178,164,103],[174,155,79],[174,155,77],[176,157,79],[176,157,78],[175,157,77],[175,160,80],[174,163,92],[174,172,111],[176,179,121],[173,178,118],[174,178,117],[174,179,119],[172,177,116],[174,181,120],[174,181,121],[170,177,117],[172,179,121],[174,181,122],[174,182,118],[176,183,114],[178,184,112],[179,185,112],[176,185,114],[177,184,117],[175,183,112],[174,185,108],[177,187,109],[177,188,110],[176,188,107],[179,190,114],[181,191,125],[183,194,138],[186,196,148],[183,193,151],[188,197,157],[188,195,142],[178,184,108],[180,185,103],[180,183,102],[182,181,103],[183,178,101],[183,172,98],[181,167,92],[181,170,90],[179,175,84],[174,177,73],[176,184,84],[186,195,122],[196,198,146],[192,181,121],[187,168,89],[188,168,83],[188,168,81],[187,167,80],[187,167,80],[187,167,80],[187,166,79],[187,167,80],[185,165,84],[184,164,93],[182,166,102],[183,172,121],[189,182,143],[197,191,162],[202,199,176],[159,181,193],[96,146,167],[78,143,167],[99,151,165],[145,166,155],[150,157,114],[152,154,97],[157,155,100],[163,164,123],[154,173,172],[135,165,171],[124,161,172],[119,158,169],[120,158,165],[118,155,161],[116,153,159],[121,155,162],[122,156,162],[124,157,164],[124,157,163],[127,160,165],[129,161,167],[131,161,168],[125,160,169],[123,160,170],[125,161,171],[125,160,169],[124,157,165],[121,156,165],[117,156,167],[112,155,169],[108,154,171],[105,152,169],[107,151,168],[150,177,186],[187,201,211],[153,178,194],[120,161,179],[101,153,174],[93,151,175],[91,150,174],[90,150,175],[91,150,175],[91,149,173],[90,150,174],[88,148,174],[87,150,176],[85,151,177],[85,151,178],[90,150,175],[118,161,181],[165,188,200],[177,201,213],[121,171,191],[83,150,174],[84,151,174],[83,150,173],[84,150,174],[85,149,173],[84,149,173],[84,150,173],[83,149,173],[80,149,173],[78,148,174],[80,148,174],[83,148,172],[100,149,171],[157,180,194],[194,204,223],[153,172,197],[124,153,185],[106,141,180],[98,139,181],[98,140,184],[98,140,184],[97,140,184],[98,139,181],[122,152,185],[178,190,209],[155,139,151],[151,132,144],[147,126,128],[130,95,94],[121,82,79],[111,70,68],[105,65,64],[107,75,73],[131,118,111],[122,104,98],[115,78,76],[113,73,71],[108,69,66],[117,78,76],[155,130,133],[130,103,104],[106,68,67],[98,64,64],[118,99,101],[145,126,124],[131,93,88],[134,91,84],[144,116,118],[167,180,195],[118,146,175],[83,125,167],[78,125,170],[79,127,171],[78,127,172],[79,126,171],[79,125,171],[78,124,170],[79,125,171],[77,125,170],[82,126,169],[114,143,174],[199,193,173],[193,187,157],[186,175,131],[178,165,103],[175,157,84],[175,155,76],[174,155,77],[175,157,79],[176,157,78],[174,159,81],[174,164,89],[176,169,101],[177,174,116],[180,181,127],[177,178,124],[178,179,122],[179,179,123],[175,174,118],[176,176,121],[177,180,126],[171,176,123],[175,180,129],[178,183,134],[177,183,129],[178,184,121],[180,184,120],[182,187,122],[182,189,126],[184,190,131],[184,191,131],[180,189,122],[181,189,122],[184,194,129],[184,195,132],[187,196,138],[183,192,135],[181,191,131],[184,194,131],[180,190,128],[180,189,128],[185,192,132],[177,182,109],[179,183,103],[180,184,102],[181,183,101],[182,183,104],[185,181,110],[181,170,101],[179,166,88],[177,169,80],[173,173,71],[173,179,71],[182,191,103],[194,200,147],[197,192,142],[188,170,100],[186,165,81],[187,167,81],[187,167,80],[187,166,80],[186,166,79],[187,167,80],[187,167,80],[186,165,82],[186,164,85],[185,165,86],[183,164,92],[179,165,99],[180,168,111],[183,173,125],[189,184,147],[197,194,173],[180,197,206],[116,156,172],[84,144,167],[78,144,166],[115,160,171],[150,169,159],[149,155,110],[149,151,94],[158,158,106],[171,174,147],[137,162,171],[110,149,163],[101,146,165],[101,147,163],[102,148,162],[101,148,161],[99,147,163],[101,148,164],[102,147,164],[102,148,165],[101,148,165],[102,149,164],[111,155,170],[114,159,176],[95,148,169],[91,149,170],[89,148,171],[88,149,171],[87,149,170],[86,148,170],[87,149,171],[86,149,172],[85,149,171],[88,149,172],[93,149,170],[141,176,190],[189,205,213],[176,190,201],[151,177,193],[124,164,183],[98,153,175],[87,150,175],[84,150,175],[84,151,176],[85,150,176],[88,150,176],[88,150,176],[87,149,175],[85,150,176],[83,150,175],[84,150,178],[85,149,175],[98,152,176],[132,166,182],[184,197,208],[178,198,207],[152,186,199],[106,161,182],[86,152,174],[85,152,174],[81,149,173],[80,148,173],[83,149,173],[82,149,173],[84,150,174],[85,149,172],[82,149,173],[80,149,174],[81,149,175],[80,148,174],[92,148,171],[136,167,183],[203,212,225],[160,177,200],[118,147,180],[103,142,181],[98,140,183],[98,141,184],[98,141,185],[98,140,184],[99,140,184],[98,140,182],[120,150,182],[170,185,206],[173,181,199],[165,170,188],[161,164,185],[163,169,189],[168,173,193],[165,170,186],[135,107,106],[125,87,84],[114,73,73],[110,69,68],[109,74,70],[117,91,87],[115,84,81],[116,76,77],[114,74,74],[111,71,70],[119,79,81],[143,119,126],[127,103,107],[106,67,69],[100,62,63],[123,102,103],[137,120,116],[128,92,87],[134,92,88],[146,121,124],[176,182,195],[182,190,204],[151,167,188],[105,136,170],[84,126,168],[79,126,171],[79,126,172],[79,125,171],[81,126,170],[81,126,172],[80,125,172],[80,125,170],[80,125,169],[85,128,168],[125,153,182],[201,197,180],[198,190,164],[191,180,144],[186,173,128],[181,166,113],[176,161,97],[175,159,86],[176,157,79],[175,156,77],[174,155,79],[174,155,79],[175,157,79],[175,161,86],[176,168,99],[177,174,110],[178,176,119],[182,182,128],[181,179,127],[178,174,119],[176,171,114],[174,167,111],[173,167,111],[175,172,119],[172,173,122],[175,177,132],[180,184,142],[180,184,138],[180,185,129],[180,184,126],[182,187,130],[185,191,141],[188,193,150],[193,197,158],[190,194,149],[186,190,138],[189,195,145],[191,198,150],[192,199,152],[189,196,147],[185,192,134],[181,192,120],[177,188,107],[176,185,107],[180,186,118],[178,179,111],[178,176,100],[179,179,95],[181,182,97],[181,184,101],[186,187,116],[188,181,122],[181,169,98],[178,167,81],[172,168,69],[170,173,65],[177,185,86],[190,198,139],[197,198,153],[192,177,115],[187,166,83],[188,167,81],[187,167,80],[187,166,81],[186,165,79],[186,166,79],[186,166,79],[185,165,79],[186,165,83],[185,164,82],[185,163,80],[183,161,77],[182,162,78],[182,163,85],[184,167,98],[188,174,114],[195,189,151],[204,204,184],[135,168,181],[92,144,163],[77,144,166],[79,145,165],[121,164,173],[151,168,159],[148,154,108],[146,148,93],[162,162,118],[169,184,189],[126,156,168],[101,145,165],[95,145,165],[95,145,163],[94,147,164],[93,146,162],[94,146,162],[97,147,164],[97,147,161],[99,147,160],[102,147,158],[105,146,156],[130,167,176],[124,168,183],[86,146,168],[82,148,171],[82,148,173],[82,148,173],[81,148,171],[83,148,170],[83,148,173],[83,148,173],[81,148,173],[85,150,174],[89,148,172],[121,161,177],[174,195,205],[178,193,203],[169,190,204],[147,181,198],[111,163,185],[88,152,176],[85,152,177],[84,151,176],[86,151,176],[88,150,177],[88,150,176],[86,150,176],[83,150,175],[82,151,175],[80,150,176],[82,149,175],[88,150,174],[109,155,176],[169,190,203],[193,205,216],[190,203,213],[191,206,217],[196,209,218],[190,202,211],[179,196,208],[138,170,185],[115,160,177],[95,153,174],[86,152,175],[85,152,174],[81,150,173],[80,148,173],[81,148,174],[82,149,173],[83,149,173],[86,150,173],[83,150,173],[83,150,174],[82,149,175],[80,148,175],[88,148,172],[130,166,182],[185,199,217],[126,153,184],[103,142,179],[102,143,185],[97,141,184],[97,141,184],[99,141,185],[99,141,185],[99,141,184],[99,141,183],[111,145,182],[142,166,195],[146,167,194],[142,161,189],[138,157,187],[139,159,188],[142,162,189],[148,165,188],[184,195,208],[147,126,128],[129,95,93],[120,81,80],[116,76,74],[111,74,71],[112,76,73],[115,75,76],[117,76,77],[116,77,78],[118,76,79],[122,83,91],[132,115,129],[152,162,180],[161,176,196],[165,178,199],[166,181,201],[167,182,201],[169,183,203],[171,185,203],[172,185,204],[173,185,203],[172,185,203],[173,186,203],[173,184,202],[174,185,203],[172,184,201],[170,181,199],[173,184,201],[174,185,202],[174,185,202],[170,183,200],[170,182,199],[175,184,201],[142,125,132],[109,73,79],[97,60,63],[112,88,89],[126,107,102],[125,90,84],[134,95,94],[151,131,137],[175,184,196],[166,177,196],[163,176,195],[158,173,193],[157,170,190],[147,164,186],[118,146,176],[89,128,170],[83,126,171],[81,126,172],[81,126,172],[80,126,171],[81,127,171],[80,126,172],[80,125,171],[79,125,171],[83,125,169],[97,133,170],[146,168,192],[199,193,171],[193,183,147],[186,172,126],[180,164,109],[177,159,97],[176,157,88],[175,156,82],[176,157,78],[176,156,76],[175,155,77],[175,156,80],[174,156,79],[175,157,81],[176,163,92],[177,173,109],[177,177,120],[178,178,122],[182,179,124],[182,175,119],[179,168,105],[176,162,90],[175,159,85],[175,158,84],[176,162,90],[176,164,96],[175,167,105],[180,175,122],[179,175,125],[181,179,127],[180,181,127],[182,183,132],[188,189,145],[188,189,152],[194,194,162],[195,196,160],[188,188,145],[189,189,144],[192,192,146],[191,192,146],[191,192,143],[188,190,134],[181,190,117],[175,185,98],[175,184,98],[179,186,110],[180,180,114],[178,172,100],[177,171,87],[177,175,86],[179,182,95],[185,188,114],[191,191,138],[188,179,120],[179,166,84],[173,164,69],[170,168,66],[175,179,78],[189,195,129],[194,197,154],[194,183,124],[187,167,87],[187,167,80],[187,167,80],[187,167,81],[186,165,80],[186,166,79],[186,166,79],[185,164,78],[185,164,80],[186,164,81],[185,164,81],[186,164,80],[184,163,77],[183,163,77],[182,163,81],[181,161,84],[182,169,106],[190,182,141],[203,200,180],[157,182,192],[98,147,165],[80,143,165],[73,144,165],[80,145,163],[116,160,169],[146,165,154],[144,152,115],[144,147,98],[165,167,132],[140,164,171],[112,149,162],[100,146,161],[95,145,162],[93,146,163],[93,147,162],[94,147,162],[97,146,160],[99,145,156],[105,147,153],[111,148,152],[119,153,154],[149,181,186],[117,163,179],[81,146,170],[79,149,172],[79,148,173],[79,148,173],[80,148,172],[82,149,173],[82,149,174],[82,149,174],[82,149,174],[84,149,175],[87,149,173],[103,152,173],[151,180,194],[191,205,214],[185,196,205],[186,200,209],[168,193,205],[135,179,198],[91,153,177],[85,151,177],[86,152,177],[86,151,176],[87,149,176],[86,149,176],[84,150,175],[82,150,175],[81,151,175],[80,151,176],[81,150,176],[82,150,174],[97,150,172],[149,178,194],[176,194,208],[163,184,198],[152,175,188],[162,183,195],[178,195,207],[173,192,204],[139,169,186],[105,152,173],[96,151,173],[90,152,175],[86,152,175],[85,151,175],[82,151,174],[81,150,174],[81,150,174],[83,150,174],[84,150,174],[85,150,174],[83,150,174],[85,149,174],[86,149,175],[85,150,175],[92,149,173],[138,170,187],[166,185,206],[107,142,177],[102,142,182],[101,143,186],[97,141,185],[96,141,184],[98,141,186],[99,142,185],[99,142,185],[99,140,183],[103,142,182],[113,146,183],[114,146,182],[114,146,183],[112,143,181],[109,142,179],[110,143,178],[120,148,179],[167,183,201],[141,117,118],[130,98,97],[122,84,84],[116,77,77],[116,76,77],[117,77,79],[118,79,81],[121,81,87],[121,85,92],[121,92,105],[115,116,142],[114,142,172],[119,148,181],[121,149,181],[123,151,182],[125,152,183],[128,154,184],[130,156,185],[133,157,187],[134,158,185],[135,158,185],[137,158,185],[137,158,183],[138,159,184],[138,159,184],[138,157,184],[138,157,184],[139,157,184],[139,160,185],[137,158,183],[137,157,183],[141,156,182],[167,177,195],[128,102,112],[102,68,76],[100,71,73],[112,88,87],[117,97,95],[122,101,100],[125,94,92],[129,89,89],[138,102,108],[169,177,190],[140,159,180],[117,143,175],[116,142,176],[116,142,174],[115,142,173],[112,140,172],[99,131,168],[87,128,170],[84,128,172],[81,126,171],[81,126,172],[82,126,171],[82,127,171],[80,126,170],[80,125,169],[81,125,169],[89,128,170],[120,148,180],[171,187,205],[195,188,159],[187,176,132],[182,165,104],[178,159,85],[178,156,79],[178,156,77],[178,157,76],[177,157,75],[175,156,74],[174,156,75],[173,156,78],[173,156,78],[173,156,78],[173,159,82],[175,168,100],[178,177,119],[181,181,130],[181,178,125],[181,172,116],[178,165,99],[174,159,87],[174,157,81],[175,157,78],[175,158,78],[175,158,81],[176,159,83],[174,159,87],[177,164,100],[177,166,105],[179,168,110],[180,173,117],[181,175,123],[187,181,134],[185,180,141],[188,183,147],[193,189,151],[188,184,140],[185,179,133],[187,179,129],[185,177,125],[184,177,123],[185,181,122],[183,185,113],[176,183,94],[174,183,92],[179,186,109],[182,184,118],[179,172,102],[178,166,83],[176,166,76],[175,170,78],[180,184,98],[191,195,138],[193,190,147],[182,172,109],[176,165,76],[172,165,69],[175,176,80],[188,191,122],[195,196,153],[194,185,131],[187,168,91],[187,166,80],[187,167,81],[188,168,81],[187,166,80],[186,166,79],[186,166,79],[185,165,79],[185,164,78],[186,165,80],[186,164,81],[186,165,81],[186,164,79],[184,164,75],[184,162,74],[184,161,74],[182,160,79],[182,164,96],[189,179,130],[203,202,181],[183,200,206],[111,155,170],[85,144,165],[79,144,166],[75,144,166],[79,144,166],[105,154,164],[136,160,150],[139,152,124],[141,148,110],[163,168,143],[157,178,179],[126,158,166],[107,150,158],[101,146,157],[97,146,155],[97,146,156],[101,147,157],[103,146,155],[109,149,153],[117,151,149],[123,152,146],[133,158,153],[148,178,181],[102,153,171],[77,146,170],[78,147,172],[80,149,174],[79,149,173],[80,149,173],[82,149,173],[81,149,174],[82,149,174],[81,149,174],[81,149,176],[86,150,177],[92,150,174],[121,164,181],[169,194,203],[171,187,200],[165,182,193],[177,199,209],[149,191,208],[92,154,178],[85,151,176],[86,151,177],[86,151,176],[88,151,178],[85,150,176],[83,150,175],[82,151,175],[82,152,176],[79,150,175],[79,150,175],[78,150,174],[86,149,173],[118,164,185],[135,172,191],[120,162,183],[112,157,177],[124,165,183],[143,177,195],[136,173,191],[104,153,174],[94,151,173],[91,150,173],[90,150,174],[91,150,173],[91,151,174],[88,150,174],[84,149,175],[83,149,174],[82,149,173],[84,150,174],[85,150,174],[84,150,174],[86,149,174],[88,150,175],[89,149,174],[101,152,174],[159,186,201],[155,177,201],[100,140,178],[101,142,185],[99,143,185],[96,141,185],[96,141,185],[97,141,185],[99,140,185],[100,141,186],[98,141,184],[97,140,183],[97,140,183],[97,139,183],[98,140,182],[97,139,181],[96,138,180],[98,139,180],[103,140,178],[137,162,189],[191,201,217],[146,128,131],[130,103,105],[121,91,94],[120,88,93],[120,88,93],[122,90,97],[126,96,107],[124,104,118],[120,110,130],[107,123,155],[97,133,172],[98,136,175],[98,136,175],[99,136,176],[100,136,176],[101,138,176],[101,138,176],[102,138,177],[102,138,175],[102,138,174],[103,137,174],[102,137,173],[103,136,175],[101,137,174],[101,136,174],[101,134,172],[101,134,173],[100,134,172],[98,134,172],[100,134,172],[101,132,171],[133,153,181],[192,202,215],[121,102,110],[100,74,77],[101,73,74],[104,77,77],[114,83,85],[124,90,90],[130,94,98],[143,118,128],[157,170,188],[117,142,170],[96,130,169],[97,130,170],[97,130,168],[95,130,167],[95,130,168],[93,129,168],[89,129,171],[86,129,172],[83,127,170],[81,126,171],[83,127,171],[83,128,170],[83,129,169],[86,129,171],[91,131,171],[109,141,177],[151,171,193],[189,181,144],[181,169,112],[177,161,91],[177,158,79],[176,157,75],[177,155,73],[177,155,73],[177,156,73],[177,156,74],[176,157,75],[176,156,76],[175,156,77],[173,157,77],[173,157,79],[172,160,85],[176,171,106],[179,179,125],[183,183,135],[180,175,122],[176,165,104],[173,157,86],[173,156,78],[175,156,77],[175,156,75],[176,157,75],[176,157,76],[177,157,75],[177,156,75],[178,157,80],[178,159,83],[180,159,87],[181,163,94],[182,165,101],[184,168,106],[183,169,109],[184,170,110],[185,171,110],[185,168,106],[185,168,100],[183,168,95],[181,166,92],[180,166,92],[180,169,91],[177,173,88],[176,178,88],[174,181,88],[181,186,107],[183,185,118],[183,174,105],[179,165,84],[178,163,74],[171,162,70],[172,172,81],[188,192,126],[196,197,155],[189,181,130],[178,166,84],[176,166,74],[175,173,83],[185,186,115],[195,195,148],[193,183,128],[186,169,94],[187,166,81],[187,167,81],[187,167,81],[187,167,80],[186,166,79],[186,165,79],[186,166,79],[185,165,78],[186,165,80],[186,164,80],[185,164,79],[185,164,77],[183,164,75],[182,162,75],[184,161,76],[184,161,77],[184,161,83],[184,165,95],[190,180,128],[144,173,183],[91,144,163],[82,144,167],[79,144,167],[77,144,167],[78,143,167],[97,148,161],[124,155,151],[134,153,136],[141,153,124],[156,164,147],[139,162,162],[123,154,151],[120,150,143],[119,149,139],[122,151,142],[125,152,143],[130,155,145],[135,158,149],[137,159,152],[138,160,157],[136,162,165],[123,163,175],[86,147,169],[77,146,170],[78,147,172],[79,149,174],[78,149,173],[79,150,174],[79,150,175],[79,149,174],[80,149,174],[79,149,174],[79,148,176],[83,149,177],[85,148,175],[100,153,173],[140,174,187],[171,190,198],[193,205,216],[137,164,180],[148,171,185],[175,197,206],[143,186,202],[90,153,178],[84,151,176],[87,151,178],[87,151,177],[87,151,177],[85,150,176],[83,150,175],[83,152,176],[81,152,175],[80,151,175],[79,150,176],[76,149,175],[80,148,175],[95,152,177],[99,152,175],[92,148,171],[90,148,171],[97,149,172],[106,153,174],[104,152,172],[101,151,173],[102,152,174],[105,154,175],[107,155,177],[109,157,179],[108,157,179],[101,154,177],[91,150,175],[87,148,173],[85,149,173],[85,149,173],[87,150,174],[86,150,173],[88,149,174],[91,150,174],[96,150,173],[123,163,183],[188,206,220],[155,179,202],[99,140,180],[99,142,186],[97,144,186],[94,142,185],[96,141,185],[97,142,186],[96,141,186],[96,141,184],[96,141,184],[95,139,182],[94,139,182],[95,139,182],[95,140,183],[94,140,182],[96,141,182],[98,142,182],[99,140,180],[115,146,178],[164,179,201],[191,201,214],[153,134,143],[147,125,136],[146,125,135],[147,126,139],[143,128,145],[126,128,152],[109,125,155],[97,130,167],[89,133,175],[91,135,179],[89,134,178],[90,135,179],[90,136,180],[91,136,180],[91,136,178],[92,136,179],[91,135,177],[92,135,176],[93,135,176],[94,136,176],[94,135,177],[91,133,176],[93,132,176],[92,132,175],[91,132,174],[90,133,174],[91,132,174],[94,133,175],[93,130,172],[107,137,169],[165,180,198],[130,112,115],[114,90,92],[111,84,85],[118,85,89],[129,95,98],[141,112,119],[166,171,187],[138,156,180],[100,131,169],[87,128,173],[89,130,172],[90,128,169],[89,128,168],[93,130,170],[94,130,169],[93,132,169],[91,131,169],[89,129,168],[87,128,170],[91,129,171],[92,130,169],[97,134,170],[106,140,173],[123,150,180],[149,169,192],[178,192,205],[188,183,153],[180,166,115],[175,158,91],[176,157,79],[177,157,74],[177,157,72],[178,156,73],[177,156,72],[177,156,72],[176,156,73],[177,156,74],[177,157,75],[177,156,77],[174,157,77],[172,157,80],[172,161,90],[179,175,115],[182,182,132],[183,182,134],[177,171,117],[172,160,91],[170,155,78],[172,154,78],[174,155,80],[175,156,79],[175,156,76],[175,157,75],[176,157,74],[176,156,71],[177,155,73],[178,157,75],[178,157,75],[180,158,77],[180,160,80],[180,162,83],[180,162,86],[179,163,87],[181,164,89],[183,163,90],[184,164,88],[184,165,86],[182,165,86],[181,164,85],[179,166,81],[176,168,80],[177,174,84],[175,179,86],[183,187,106],[187,189,121],[184,176,109],[179,164,84],[179,163,75],[173,160,68],[166,161,67],[179,183,106],[194,197,153],[193,187,143],[180,169,92],[178,168,77],[179,172,90],[183,182,111],[192,189,129],[193,180,117],[187,167,89],[187,166,81],[187,167,80],[187,167,80],[186,166,79],[186,166,79],[186,166,79],[185,165,78],[185,165,78],[185,164,79],[185,164,79],[184,163,77],[184,164,77],[184,164,76],[183,162,76],[183,162,77],[183,162,78],[184,162,81],[185,163,86],[181,165,96],[193,186,148],[185,201,211],[110,152,169],[82,142,166],[79,142,168],[78,143,168],[76,143,168],[78,143,167],[89,146,165],[108,151,160],[124,155,152],[141,159,148],[145,162,148],[144,161,146],[146,163,150],[148,167,155],[148,167,159],[154,172,165],[151,170,166],[146,168,166],[135,164,168],[122,157,168],[98,150,167],[81,146,170],[78,147,171],[78,147,172],[79,148,173],[78,149,173],[79,150,174],[79,150,175],[78,149,174],[78,149,174],[78,149,174],[78,149,175],[80,148,177],[80,147,176],[90,149,175],[112,156,175],[143,173,184],[172,191,200],[158,186,200],[109,152,171],[136,169,185],[190,203,211],[166,190,201],[144,180,193],[111,164,183],[85,151,176],[85,152,177],[87,152,178],[86,150,176],[85,149,175],[86,150,176],[84,150,175],[81,151,175],[80,150,174],[80,151,175],[79,150,175],[76,148,175],[78,148,176],[83,148,175],[86,149,174],[85,150,175],[83,149,174],[87,148,173],[93,150,172],[97,151,172],[113,158,178],[134,171,190],[151,183,201],[159,189,207],[161,190,207],[157,188,205],[143,179,197],[123,167,187],[109,157,181],[102,152,175],[99,151,172],[99,152,174],[101,153,174],[102,152,173],[108,153,173],[126,164,183],[168,193,209],[168,189,210],[107,144,181],[99,141,185],[96,143,187],[94,143,185],[96,142,186],[97,142,186],[96,141,186],[96,142,184],[96,141,183],[95,140,182],[94,140,183],[96,140,182],[96,140,183],[94,140,181],[96,142,181],[96,141,180],[97,140,181],[105,141,178],[133,157,185],[166,183,202],[180,194,210],[180,190,205],[155,157,174],[146,152,176],[116,143,174],[95,131,170],[89,133,173],[89,134,177],[91,134,178],[89,133,178],[89,134,178],[88,133,178],[88,133,178],[89,134,177],[89,134,178],[88,133,176],[89,134,176],[90,133,176],[91,133,176],[90,133,176],[87,132,176],[88,132,176],[88,131,176],[86,131,175],[85,132,176],[87,132,176],[90,132,177],[87,131,173],[91,130,168],[128,150,178],[179,188,203],[136,121,127],[134,118,125],[141,125,133],[160,163,180],[150,166,187],[113,141,174],[91,129,172],[87,129,173],[89,130,173],[92,130,169],[90,128,164],[96,129,163],[101,132,163],[107,139,168],[112,143,173],[112,144,175],[114,146,178],[119,148,182],[125,154,185],[134,162,190],[146,171,196],[161,181,201],[181,195,209],[180,169,125],[175,157,93],[175,155,79],[175,155,73],[177,156,73],[177,156,71],[178,157,74],[178,157,73],[177,157,73],[177,156,72],[177,157,75],[177,156,75],[175,156,76],[174,157,76],[171,156,81],[173,164,101],[182,178,127],[185,183,137],[181,177,128],[174,164,107],[170,156,85],[169,154,78],[172,154,79],[174,155,80],[175,154,79],[175,155,77],[175,156,75],[175,156,74],[175,156,72],[178,156,74],[178,157,75],[180,158,74],[181,159,73],[180,160,73],[180,160,75],[179,160,75],[178,160,75],[180,161,76],[182,162,79],[185,164,82],[185,164,82],[183,164,84],[183,164,84],[181,166,80],[179,167,79],[178,173,82],[176,179,88],[182,186,107],[189,191,124],[184,177,112],[180,165,85],[180,162,74],[175,160,67],[165,155,61],[172,172,91],[190,194,144],[193,189,147],[184,171,101],[180,166,77],[182,171,84],[185,177,100],[188,179,111],[190,175,105],[188,168,89],[187,167,83],[188,167,81],[188,168,82],[187,167,80],[186,166,80],[186,166,79],[185,165,78],[184,165,77],[184,165,77],[185,164,78],[184,163,77],[183,163,77],[184,163,77],[183,163,77],[183,162,78],[183,163,79],[182,162,80],[183,162,83],[183,163,86],[184,169,107],[158,184,196],[92,145,166],[77,143,170],[76,142,168],[74,143,169],[74,143,169],[74,142,168],[80,143,166],[93,145,163],[112,151,159],[134,160,158],[149,167,161],[152,173,175],[138,164,170],[116,155,169],[98,148,168],[85,147,169],[80,147,173],[78,147,172],[78,147,173],[79,149,174],[78,148,175],[81,150,175],[80,150,174],[80,150,174],[80,150,175],[79,150,174],[81,150,175],[84,150,176],[84,149,175],[90,149,175],[98,150,171],[115,159,177],[137,173,190],[120,163,183],[97,149,172],[132,169,186],[196,209,218],[171,193,206],[127,164,182],[107,154,173],[91,152,173],[85,152,177],[86,152,177],[87,151,177],[87,151,177],[86,150,176],[87,150,176],[85,150,175],[80,151,175],[80,151,175],[80,151,176],[79,150,175],[77,148,175],[76,148,176],[79,148,176],[79,149,174],[80,149,174],[82,149,174],[83,148,173],[89,148,171],[109,156,177],[154,183,198],[181,201,215],[195,211,222],[201,215,227],[201,216,228],[198,214,227],[188,208,222],[172,198,215],[155,187,206],[142,177,195],[133,171,188],[130,168,186],[131,169,187],[136,174,191],[152,185,202],[174,200,216],[200,216,229],[188,205,223],[128,160,193],[101,143,185],[97,143,186],[94,143,185],[96,142,185],[97,142,186],[97,142,186],[97,143,184],[97,142,184],[96,142,183],[97,142,183],[99,141,181],[102,142,182],[104,144,181],[108,144,181],[106,143,178],[105,143,177],[109,143,178],[117,146,179],[130,155,185],[150,171,198],[161,182,205],[164,184,206],[164,180,202],[160,174,196],[155,170,191],[147,163,187],[136,154,182],[108,143,179],[93,134,177],[88,134,176],[88,133,177],[89,133,177],[88,133,177],[87,133,178],[88,133,177],[88,133,177],[89,134,178],[87,133,176],[87,133,176],[88,133,176],[88,132,175],[89,132,176],[88,132,176],[87,132,176],[86,132,175],[86,131,175],[84,130,174],[84,131,175],[86,131,175],[86,131,175],[84,131,174],[86,130,173],[100,133,171],[143,162,189],[175,188,208],[185,194,209],[159,163,182],[153,165,187],[126,149,177],[96,130,168],[87,128,172],[86,129,172],[88,129,171],[95,132,168],[105,140,171],[124,153,179],[139,164,188],[150,174,197],[158,180,201],[160,182,203],[162,182,203],[165,183,205],[170,186,207],[175,192,209],[184,197,211],[194,188,165],[174,159,100],[174,155,79],[174,155,76],[175,155,74],[178,157,74],[177,156,73],[178,157,73],[178,157,73],[178,157,73],[177,157,73],[177,156,75],[176,155,75],[174,155,75],[172,156,77],[170,157,87],[178,171,114],[184,182,134],[185,182,136],[179,171,119],[172,161,98],[171,156,83],[170,154,79],[171,154,80],[173,154,81],[173,153,79],[174,154,77],[174,155,75],[173,155,73],[174,155,73],[174,154,74],[178,156,76],[179,158,75],[180,159,74],[180,159,73],[180,160,73],[180,160,73],[179,161,74],[180,162,75],[182,162,76],[183,163,79],[184,163,81],[183,164,83],[183,164,85],[182,166,85],[181,169,85],[178,173,86],[178,179,92],[184,186,108],[190,189,121],[184,177,112],[180,165,86],[180,163,74],[177,160,69],[169,156,63],[173,169,88],[186,189,132],[192,189,144],[184,172,105],[182,166,78],[183,168,79],[186,174,92],[186,174,99],[187,171,96],[188,168,88],[188,168,84],[188,168,83],[187,168,83],[187,167,82],[187,165,82],[186,166,80],[185,165,78],[184,165,76],[184,165,76],[184,166,77],[185,164,78],[185,164,79],[185,164,78],[184,163,77],[184,164,78],[183,163,78],[183,162,78],[183,162,82],[183,163,84],[182,164,92],[135,168,183],[83,142,166],[75,143,169],[73,142,167],[73,143,169],[73,143,169],[72,142,169],[75,143,168],[82,142,166],[93,143,161],[115,153,160],[134,161,163],[150,169,167],[159,178,173],[173,189,193],[166,185,193],[156,179,190],[143,170,181],[126,159,172],[112,151,167],[97,147,168],[87,146,170],[83,147,171],[81,148,172],[79,148,172],[79,148,173],[79,149,174],[79,149,175],[83,150,176],[81,151,175],[80,150,174],[80,150,175],[80,150,175],[83,150,176],[85,150,176],[85,150,175],[87,149,175],[92,151,173],[100,151,174],[108,155,178],[97,152,177],[92,150,174],[131,170,187],[191,207,217],[186,203,212],[132,169,188],[95,151,173],[91,151,174],[84,151,175],[84,152,177],[86,151,177],[87,151,177],[86,150,176],[86,150,176],[86,150,176],[84,150,175],[82,151,175],[81,151,175],[81,150,176],[81,150,176],[78,149,175],[78,149,175],[79,148,174],[79,149,173],[80,149,174],[81,149,174],[84,149,172],[96,150,171],[148,183,200],[197,215,228],[211,223,234],[209,220,232],[203,219,231],[196,215,229],[190,210,225],[183,205,220],[180,202,216],[178,201,216],[183,204,219],[194,211,224],[202,216,228],[203,215,227],[161,183,207],[115,151,187],[100,144,185],[95,142,185],[96,142,185],[96,142,184],[96,142,184],[97,142,183],[99,142,181],[101,142,181],[104,143,180],[112,145,179],[123,153,185],[136,165,194],[147,172,200],[145,171,199],[136,166,194],[129,157,187],[120,148,180],[116,144,176],[119,145,175],[119,147,177],[121,151,180],[124,152,182],[127,153,182],[125,152,182],[120,148,179],[111,142,176],[98,137,176],[95,135,179],[90,135,177],[88,134,177],[87,134,177],[87,133,176],[86,133,177],[88,133,177],[88,133,178],[88,133,178],[85,133,176],[87,133,176],[87,132,176],[87,132,176],[88,131,176],[87,131,176],[86,131,176],[85,132,176],[85,131,175],[83,131,174],[84,131,175],[85,131,175],[85,131,174],[82,130,173],[84,130,174],[90,130,171],[107,135,170],[130,151,177],[149,166,187],[159,173,194],[161,171,191],[158,169,188],[152,164,186],[145,160,182],[141,156,183],[129,148,176],[103,133,168],[88,127,169],[85,127,171],[85,127,170],[99,136,174],[120,151,181],[142,166,187],[162,180,194],[175,188,202],[182,195,207],[188,200,210],[190,202,212],[190,202,212],[193,202,215],[191,185,161],[173,157,94],[174,154,76],[175,155,76],[176,156,74],[177,157,75],[178,157,74],[178,157,73],[179,157,73],[178,157,73],[177,157,73],[177,157,75],[176,156,75],[174,155,75],[172,158,80],[173,164,98],[182,178,127],[183,182,138],[182,176,129],[176,165,107],[172,156,90],[172,156,83],[172,156,82],[171,154,82],[172,154,83],[175,155,86],[176,156,85],[176,156,84],[175,155,80],[174,155,78],[175,154,75],[176,155,73],[178,157,73],[179,159,73],[180,159,72],[180,160,73],[180,160,73],[179,160,73],[181,162,76],[181,162,76],[182,162,77],[182,163,79],[182,163,82],[181,164,84],[181,165,86],[182,170,90],[179,173,91],[179,178,95],[183,183,106],[188,185,115],[185,176,108],[181,165,87],[181,163,75],[179,161,72],[172,158,67],[176,168,87],[182,181,119],[189,187,133],[183,172,104],[183,165,80],[184,167,77],[187,170,84],[187,171,93],[186,169,92],[187,167,89],[189,168,86],[186,168,83],[186,168,84],[187,166,82],[187,166,82],[187,166,81],[185,165,79],[184,164,77],[185,165,78],[185,165,79],[186,165,79],[185,165,80],[184,165,79],[183,164,78],[184,164,79],[184,164,79],[183,163,78],[183,163,82],[184,163,84],[183,164,86],[191,206,214],[117,156,173],[79,142,167],[74,143,168],[75,143,167],[75,143,169],[75,143,170],[75,143,169],[75,144,168],[77,142,168],[80,142,166],[91,147,167],[104,152,168],[117,158,171],[127,164,174],[137,170,182],[146,176,187],[146,175,187],[145,174,187],[142,173,186],[134,167,184],[127,161,179],[122,155,171],[116,152,169],[107,149,167],[94,146,169],[87,147,171],[83,148,171],[81,147,171],[79,148,173],[79,148,173],[79,148,174],[80,150,174],[83,150,176],[81,151,175],[79,150,174],[79,150,175],[80,149,175],[82,149,176],[84,150,177],[83,151,176],[84,150,177],[89,151,177],[93,151,177],[95,152,178],[92,151,177],[93,151,177],[124,167,185],[172,198,209],[145,179,193],[96,152,174],[84,150,173],[82,151,174],[82,152,176],[86,151,176],[92,151,176],[97,153,177],[96,152,175],[92,150,174],[88,149,174],[84,150,174],[82,151,175],[82,151,176],[82,150,176],[81,150,176],[79,150,175],[80,150,175],[80,149,175],[79,149,174],[81,149,174],[81,149,173],[84,148,171],[117,164,183],[187,209,223],[188,205,223],[144,174,202],[114,153,187],[101,144,183],[100,142,183],[100,142,183],[100,142,182],[102,143,181],[108,145,182],[115,149,184],[129,158,190],[150,173,199],[169,189,212],[180,198,218],[189,203,221],[189,204,221],[182,199,217],[171,190,210],[154,176,200],[137,161,188],[120,148,181],[106,143,180],[100,142,180],[101,142,180],[103,141,180],[102,141,180],[98,139,177],[95,136,176],[92,137,178],[93,137,181],[92,136,179],[88,135,178],[86,134,178],[86,133,177],[87,133,177],[87,133,176],[86,132,177],[87,132,176],[85,132,175],[87,132,176],[87,132,176],[86,131,175],[87,131,175],[86,131,175],[86,132,176],[85,133,176],[84,132,175],[84,132,175],[84,132,175],[85,131,174],[85,131,173],[82,131,174],[85,132,175],[84,131,173],[87,130,174],[100,137,172],[115,145,178],[122,151,184],[126,153,185],[126,154,186],[123,151,184],[117,147,181],[110,141,177],[101,133,171],[91,129,170],[86,128,170],[85,128,168],[97,136,171],[129,159,186],[160,178,199],[180,194,208],[192,188,166],[173,157,96],[175,154,76],[175,155,75],[176,156,74],[177,156,74],[178,157,75],[178,157,75],[178,157,74],[178,157,75],[178,157,75],[177,157,75],[176,156,77],[174,156,78],[175,161,91],[175,170,113],[182,180,133],[183,180,132],[179,169,115],[174,159,94],[172,155,85],[172,155,86],[171,155,91],[170,154,97],[169,154,99],[172,156,102],[175,158,104],[175,158,103],[175,158,101],[175,157,95],[173,155,88],[173,153,76],[176,156,71],[178,158,72],[179,158,72],[181,159,72],[182,160,74],[181,160,73],[181,161,74],[181,162,77],[181,162,77],[182,162,78],[182,163,81],[181,164,83],[179,166,87],[183,173,97],[181,175,99],[181,177,101],[183,179,103],[185,178,103],[184,172,97],[181,166,85],[180,164,78],[179,162,76],[174,160,70],[176,166,83],[181,175,106],[186,178,114],[186,171,99],[182,166,80],[184,166,78],[186,168,82],[187,169,89],[187,169,92],[187,168,91],[189,169,90],[188,169,88],[187,169,88],[188,168,87],[188,167,85],[187,166,84],[186,166,82],[185,165,80],[185,164,79],[186,165,81],[186,165,80],[184,165,81],[183,165,80],[183,165,80],[184,164,80],[184,165,81],[184,164,80],[183,164,81],[184,164,84],[184,164,85],[181,198,208],[106,150,168],[80,143,168],[75,143,168],[76,144,168],[74,143,169],[75,143,170],[74,143,169],[76,143,168],[76,142,168],[74,140,167],[79,141,166],[86,143,165],[94,146,166],[99,147,166],[106,151,171],[113,156,174],[113,154,174],[111,153,174],[106,150,171],[103,149,171],[110,151,172],[120,156,174],[129,164,182],[127,165,185],[108,156,178],[91,149,170],[84,148,170],[81,147,173],[80,147,172],[80,147,173],[81,149,174],[81,149,174],[82,151,176],[81,151,175],[80,150,174],[79,149,175],[79,150,174],[81,149,175],[87,151,177],[87,150,176],[87,149,177],[89,150,176],[92,151,176],[93,152,176],[92,152,178],[93,152,177],[110,157,179],[134,174,189],[105,155,173],[85,151,173],[81,152,175],[80,151,175],[82,152,175],[90,152,176],[107,158,180],[120,165,186],[119,165,186],[111,160,182],[99,153,178],[86,150,173],[83,150,174],[82,151,175],[81,149,176],[81,150,177],[79,149,174],[79,150,176],[80,149,176],[81,149,176],[80,149,176],[82,149,175],[86,148,171],[141,179,195],[207,220,230],[204,215,228],[179,200,218],[148,176,202],[123,157,188],[115,149,183],[116,148,183],[120,151,185],[129,158,188],[142,166,195],[158,178,201],[178,192,209],[194,203,217],[202,211,225],[205,215,227],[200,212,225],[190,205,220],[173,191,209],[146,170,194],[113,149,183],[97,140,179],[94,139,180],[94,138,180],[94,139,181],[94,138,180],[92,137,180],[92,138,181],[92,137,181],[91,137,181],[89,135,179],[87,134,179],[87,133,177],[88,134,177],[88,134,177],[87,133,177],[88,133,177],[86,133,176],[87,132,176],[87,133,177],[87,132,176],[86,131,175],[86,130,176],[87,132,176],[85,132,177],[83,132,175],[84,132,175],[83,131,174],[84,132,175],[84,131,175],[82,130,174],[83,130,174],[84,130,175],[81,128,172],[86,128,169],[88,128,168],[92,129,170],[94,130,170],[94,130,169],[95,130,168],[92,128,167],[90,128,167],[90,128,168],[88,129,170],[85,127,169],[90,130,168],[123,156,184],[166,189,209],[194,205,219],[174,160,114],[173,154,80],[175,155,75],[175,155,75],[177,156,76],[178,157,75],[179,158,76],[178,157,75],[178,157,75],[178,157,75],[177,157,75],[176,157,77],[176,157,80],[178,164,99],[178,172,119],[181,176,129],[180,174,123],[174,162,104],[171,156,89],[170,155,85],[171,156,93],[173,159,109],[178,163,122],[178,167,130],[183,170,136],[187,175,141],[190,178,143],[190,177,143],[188,174,137],[183,168,123],[175,156,93],[174,153,71],[176,156,71],[179,158,71],[179,158,72],[181,158,72],[181,160,72],[181,161,73],[181,161,75],[181,161,77],[182,162,79],[181,163,80],[180,163,81],[179,166,86],[183,173,99],[182,175,102],[182,176,102],[183,175,101],[183,171,96],[182,168,90],[180,164,82],[181,164,79],[178,162,75],[175,161,72],[175,165,79],[182,172,99],[182,171,101],[183,167,92],[184,166,81],[185,168,80],[186,168,83],[186,169,87],[186,169,90],[186,169,91],[189,170,94],[190,171,96],[190,172,99],[190,171,99],[189,169,95],[188,167,91],[188,167,87],[185,166,84],[185,165,83],[184,166,83],[186,165,83],[184,165,84],[183,164,84],[183,164,84],[183,164,84],[183,164,84],[184,165,84],[184,164,85],[184,164,85],[185,165,87],[170,192,203],[98,148,168],[80,143,168],[76,144,169],[75,142,168],[74,142,169],[76,144,169],[76,142,169],[76,143,169],[75,143,168],[74,142,169],[75,143,170],[76,143,169],[77,144,169],[79,142,170],[78,142,167],[81,144,169],[85,144,170],[87,144,171],[90,146,172],[104,152,174],[138,172,188],[170,194,207],[182,203,215],[175,199,213],[150,183,201],[118,162,182],[93,149,170],[83,147,172],[81,147,173],[80,148,173],[81,149,174],[81,150,175],[82,151,176],[81,151,176],[80,150,175],[79,150,175],[82,150,175],[85,150,175],[93,151,177],[98,153,179],[99,153,179],[99,154,178],[99,154,177],[96,152,177],[91,151,176],[89,150,176],[94,150,176],[95,152,174],[85,150,172],[80,151,173],[79,152,174],[83,152,174],[83,150,173],[108,161,183],[156,188,205],[179,204,217],[182,205,220],[171,198,213],[142,181,199],[105,159,181],[87,150,174],[82,150,174],[81,149,175],[81,150,175],[77,149,175],[78,150,176],[78,150,176],[80,150,176],[79,149,176],[80,149,174],[87,147,170],[156,189,204],[190,206,220],[172,192,213],[162,183,206],[160,180,204],[163,182,207],[173,191,213],[184,199,220],[194,207,223],[199,211,223],[180,198,216],[139,171,200],[101,143,180],[93,139,180],[93,139,182],[92,139,183],[92,138,182],[92,138,182],[91,137,181],[90,136,181],[90,136,181],[89,135,180],[89,135,180],[91,134,178],[92,134,177],[92,134,176],[91,134,174],[93,135,174],[91,133,174],[91,133,174],[90,133,175],[89,133,176],[86,131,175],[86,131,176],[86,132,176],[84,132,176],[83,131,175],[83,131,174],[83,131,174],[84,132,175],[84,131,175],[83,129,173],[81,129,172],[83,129,174],[81,128,173],[83,128,172],[84,128,173],[86,129,174],[88,129,175],[87,129,173],[88,130,173],[87,129,173],[86,129,170],[86,131,170],[86,130,169],[85,127,167],[104,140,173],[155,180,199],[191,205,216],[185,175,145],[174,156,96],[175,155,79],[176,156,77],[178,157,77],[179,157,76],[178,157,75],[178,157,75],[178,157,75],[178,157,75],[177,156,76],[176,157,78],[177,158,83],[183,168,106],[183,173,123],[180,172,121],[175,165,110],[172,157,96],[172,156,90],[171,156,94],[175,162,114],[180,169,143],[185,178,161],[193,187,169],[184,173,136],[174,156,88],[176,155,73],[179,159,73],[180,159,71],[179,157,70],[182,159,72],[181,160,73],[181,161,74],[182,161,77],[182,161,81],[181,163,81],[180,164,83],[179,165,85],[182,172,97],[182,174,101],[181,173,100],[181,171,97],[182,169,92],[183,167,86],[181,165,81],[181,164,79],[179,163,76],[175,160,71],[174,162,73],[181,169,91],[183,169,91],[183,167,87],[184,167,81],[186,169,82],[186,168,84],[187,169,88],[186,169,89],[187,168,91],[188,170,95],[189,173,109],[193,179,127],[191,178,129],[190,175,124],[187,170,112],[186,168,102],[185,167,94],[185,165,89],[185,166,87],[185,166,84],[184,165,86],[183,164,86],[183,163,85],[182,164,87],[182,164,87],[183,165,87],[184,165,87],[185,166,88],[186,167,91],[159,189,202],[95,148,171],[78,144,169],[76,143,170],[73,141,168],[75,142,169],[76,142,169],[76,143,169],[76,142,169],[75,143,168],[75,144,170],[75,143,169],[75,144,168],[77,143,171],[78,144,170],[79,144,171],[80,145,172],[82,145,172],[84,144,171],[97,148,172],[136,173,191],[177,200,213],[195,212,223],[200,215,225],[197,213,224],[180,203,218],[149,183,201],[107,157,177],[85,147,171],[81,147,173],[80,149,174],[80,149,174],[80,149,175],[82,149,177],[82,150,177],[79,149,175],[80,150,174],[86,150,175],[96,153,177],[116,160,184],[135,171,192],[148,181,199],[150,183,202],[142,176,197],[120,163,187],[97,151,177],[88,150,176],[88,151,178],[84,151,175],[81,151,175],[79,151,175],[82,152,175],[81,151,174],[92,153,173],[152,189,206],[197,215,228],[208,220,231],[207,220,232],[197,215,226],[175,204,217],[134,178,198],[96,153,176],[83,150,175],[82,150,175],[80,150,175],[77,149,175],[77,151,176],[77,151,176],[78,150,176],[78,149,175],[79,148,174],[89,148,171],[165,192,207],[199,212,227],[196,209,225],[193,206,223],[196,209,225],[204,214,230],[209,218,232],[176,198,216],[122,157,188],[96,138,179],[94,139,181],[94,139,181],[92,139,182],[93,138,182],[90,138,182],[89,137,181],[90,136,181],[90,136,180],[91,136,179],[96,136,177],[103,139,177],[110,144,180],[114,146,182],[115,149,182],[112,147,181],[108,143,178],[101,139,176],[95,135,174],[90,133,175],[87,132,175],[85,131,175],[83,131,175],[83,131,175],[83,131,174],[83,131,174],[84,131,176],[84,131,174],[83,129,172],[83,129,173],[84,130,174],[84,130,174],[84,129,174],[83,128,174],[84,129,174],[86,128,176],[86,128,174],[87,130,174],[89,130,174],[87,129,171],[87,130,171],[89,130,171],[92,130,168],[127,155,183],[184,199,211],[181,166,125],[174,155,89],[177,156,81],[179,157,77],[180,157,77],[180,158,77],[179,156,77],[178,156,77],[179,157,77],[178,156,79],[176,156,80],[177,156,84],[179,162,98],[182,169,112],[178,165,107],[173,159,99],[170,154,93],[173,157,100],[174,161,116],[181,173,145],[197,191,171],[181,165,110],[175,154,75],[177,158,71],[180,159,71],[181,158,70],[183,160,72],[181,160,73],[181,161,74],[181,161,78],[183,162,84],[183,164,86],[183,166,89],[182,167,90],[183,171,97],[181,171,99],[179,170,96],[178,168,92],[179,166,88],[181,166,84],[181,166,82],[181,165,80],[180,162,77],[178,161,74],[177,161,72],[180,166,84],[182,168,89],[183,167,87],[184,167,83],[185,168,81],[186,168,83],[187,169,88],[187,170,91],[186,168,91],[185,168,97],[192,178,123],[204,195,157],[209,202,168],[210,201,166],[206,195,153],[198,185,133],[191,176,116],[187,169,104],[184,166,94],[184,165,89],[185,166,90],[184,165,90],[182,162,88],[181,164,89],[182,164,90],[183,165,90],[183,165,89],[184,166,91],[185,167,96],[160,187,200],[102,150,173],[81,144,169],[76,143,170],[74,142,169],[75,142,169],[76,143,169],[76,142,169],[75,142,169],[74,143,169],[76,144,169],[75,144,169],[76,144,169],[76,143,169],[77,144,170],[78,144,171],[78,144,172],[80,145,172],[88,145,170],[127,167,187],[180,202,216],[201,215,224],[203,215,227],[184,203,217],[135,172,190],[94,149,173],[82,147,172],[81,149,174],[79,148,173],[80,149,174],[80,149,174],[81,150,174],[80,149,174],[83,149,174],[97,151,174],[128,168,188],[164,191,207],[184,206,219],[193,212,225],[191,211,225],[182,204,220],[155,187,207],[115,163,186],[92,151,176],[87,152,178],[83,152,176],[81,152,176],[80,151,176],[82,152,175],[81,150,173],[110,163,181],[188,211,224],[202,219,229],[169,200,215],[114,164,186],[86,150,175],[82,151,175],[80,151,176],[78,150,174],[77,151,176],[77,151,176],[77,150,176],[78,150,175],[80,149,174],[91,148,172],[166,190,205],[198,212,225],[155,183,207],[104,145,181],[95,140,181],[94,139,181],[92,139,182],[94,139,183],[92,139,183],[90,138,181],[91,138,182],[91,137,180],[94,137,179],[107,142,180],[125,155,186],[143,167,194],[155,176,202],[159,180,204],[157,178,203],[149,173,197],[136,163,189],[118,151,181],[101,140,175],[89,132,174],[84,131,175],[81,130,175],[82,131,175],[85,131,175],[85,130,176],[83,130,175],[83,130,174],[84,129,173],[84,130,173],[85,130,174],[85,130,174],[85,129,174],[84,129,174],[85,129,175],[87,130,176],[86,128,176],[85,129,174],[88,130,175],[86,130,172],[88,130,172],[91,130,172],[99,134,170],[151,173,197],[193,187,172],[181,167,130],[177,159,102],[178,157,86],[178,158,80],[180,158,80],[179,157,80],[178,156,80],[178,157,80],[178,157,81],[177,158,82],[177,156,84],[174,157,89],[177,161,101],[174,159,98],[172,157,96],[171,156,99],[175,161,114],[183,173,140],[185,174,133],[174,154,78],[176,156,70],[180,158,72],[180,159,71],[182,159,73],[181,161,74],[180,161,76],[180,161,79],[181,163,89],[183,166,101],[185,170,111],[186,173,116],[185,174,117],[184,173,117],[180,170,110],[178,167,98],[178,165,89],[180,165,86],[180,165,83],[181,165,82],[180,163,79],[181,162,78],[180,163,77],[180,165,82],[181,166,88],[183,167,88],[184,167,85],[185,167,83],[185,169,84],[187,169,88],[187,170,94],[186,169,95],[186,171,106],[195,186,143],[205,202,184],[205,201,180],[201,194,165],[197,186,148],[190,176,129],[185,170,111],[185,168,103],[186,168,100],[185,166,96],[183,165,93],[183,166,94],[184,166,96],[185,167,97],[185,167,99],[185,170,107],[170,193,207],[115,159,180],[85,145,171],[79,144,171],[74,143,169],[75,143,169],[76,144,169],[76,142,169],[76,142,169],[74,142,170],[76,143,170],[75,144,169],[76,143,170],[75,144,168],[77,144,169],[78,144,171],[78,144,172],[82,143,170],[111,155,177],[173,196,211],[203,215,226],[199,214,225],[163,192,207],[108,157,179],[86,147,172],[82,149,174],[81,149,174],[81,149,174],[81,149,174],[82,150,174],[82,150,174],[90,150,174],[126,170,192],[174,201,217],[199,216,226],[206,218,229],[187,207,223],[144,182,202],[99,155,178],[86,152,176],[83,152,177],[82,152,176],[81,152,175],[83,152,175],[85,148,172],[134,173,190],[205,218,229],[195,214,227],[142,182,201],[92,152,175],[84,150,175],[82,150,176],[80,150,176],[78,150,176],[78,150,176],[78,150,175],[80,150,176],[83,150,175],[96,150,172],[166,189,203],[184,205,222],[129,166,195],[99,142,182],[94,138,180],[93,138,182],[94,139,183],[94,139,183],[92,139,182],[93,140,181],[97,140,179],[111,148,182],[141,168,195],[168,188,206],[184,200,214],[193,205,219],[194,207,220],[193,206,218],[188,203,215],[180,197,212],[165,185,204],[139,165,191],[106,143,177],[86,131,173],[82,130,174],[82,130,174],[85,131,175],[85,131,175],[83,130,175],[84,130,175],[85,131,175],[84,130,174],[86,131,175],[85,131,175],[86,130,175],[85,129,175],[86,128,176],[86,129,175],[85,129,176],[83,128,175],[86,130,175],[86,129,173],[87,130,172],[92,130,172],[115,144,177],[172,189,208],[195,187,167],[186,172,132],[180,162,105],[178,160,91],[180,158,86],[179,157,84],[177,157,83],[176,157,83],[177,157,83],[177,157,83],[176,158,84],[175,158,87],[174,158,94],[173,157,95],[173,159,103],[176,164,118],[180,173,144],[186,177,139],[173,154,80],[176,155,72],[179,157,73],[180,159,73],[181,159,73],[180,159,74],[180,160,78],[179,161,83],[181,165,99],[186,173,120],[193,181,140],[198,188,149],[199,190,151],[198,189,150],[194,185,141],[184,174,119],[180,167,98],[181,165,91],[183,166,87],[183,166,85],[181,165,83],[181,163,81],[182,164,81],[182,166,84],[182,166,90],[184,167,93],[182,166,90],[183,166,87],[184,167,86],[186,169,91],[188,171,97],[186,170,106],[189,177,126],[200,194,163],[210,206,189],[204,196,171],[195,185,149],[189,177,130],[186,171,117],[185,169,110],[184,168,106],[183,169,104],[185,168,105],[185,169,108],[186,169,109],[188,174,121],[184,200,212],[135,171,189],[94,148,171],[80,144,170],[74,143,168],[75,143,169],[75,143,169],[76,143,169],[76,142,169],[76,143,170],[77,143,169],[76,143,169],[76,143,170],[77,144,169],[77,144,169],[79,145,171],[81,144,171],[93,146,171],[152,184,202],[201,215,227],[183,207,220],[129,172,191],[93,150,174],[86,150,174],[84,150,175],[84,150,175],[83,150,174],[85,151,174],[90,152,175],[118,165,186],[176,202,217],[207,218,231],[206,218,230],[176,201,216],[118,164,184],[87,151,174],[83,153,177],[81,152,176],[81,152,176],[82,151,175],[86,147,170],[147,182,199],[206,220,232],[167,201,219],[108,163,185],[87,151,176],[84,151,177],[81,150,177],[81,150,177],[80,150,176],[79,150,175],[82,150,175],[84,150,175],[99,150,172],[172,193,207],[202,215,225],[169,193,211],[125,158,188],[103,143,179],[95,139,178],[96,139,179],[96,140,178],[96,139,178],[103,144,179],[120,154,186],[147,174,199],[178,196,214],[196,208,221],[194,206,218],[177,195,212],[141,170,196],[96,138,178],[84,130,174],[83,130,174],[85,131,175],[86,131,175],[84,130,174],[85,131,175],[85,131,175],[85,131,175],[84,130,174],[84,130,173],[86,131,175],[86,129,175],[86,128,176],[86,129,176],[85,129,175],[83,129,175],[86,130,175],[87,130,173],[88,131,172],[97,133,171],[135,159,185],[187,199,215],[192,184,155],[184,170,126],[181,161,110],[178,158,99],[177,155,93],[176,155,91],[176,156,91],[176,157,93],[174,158,94],[175,159,98],[174,158,104],[175,162,114],[179,169,130],[185,179,150],[185,176,141],[174,154,83],[175,154,73],[177,157,74],[180,159,75],[180,159,75],[180,159,76],[180,159,80],[179,160,89],[183,170,116],[190,183,153],[198,194,177],[196,193,169],[188,179,140],[184,169,114],[184,167,98],[185,167,92],[184,166,90],[184,166,87],[184,166,85],[184,167,87],[185,169,92],[185,168,91],[184,168,92],[183,167,89],[184,168,89],[186,170,94],[188,172,103],[190,175,119],[195,186,146],[204,201,179],[202,197,175],[196,188,156],[192,181,142],[188,176,132],[185,175,128],[184,174,126],[185,175,131],[188,178,137],[192,185,152],[194,207,219],[157,187,202],[109,157,178],[84,146,169],[75,143,167],[75,143,169],[76,143,169],[77,143,169],[77,144,169],[78,144,170],[78,144,170],[78,144,170],[78,143,170],[78,144,170],[79,144,170],[82,145,171],[87,145,172],[128,169,191],[191,209,223],[199,214,225],[159,188,204],[113,158,180],[97,149,173],[94,149,175],[93,149,173],[92,149,173],[98,151,174],[117,162,183],[164,194,211],[203,219,230],[195,216,228],[139,180,200],[92,154,177],[84,153,177],[84,154,177],[83,154,177],[82,152,176],[88,149,171],[161,192,207],[191,215,229],[135,177,198],[96,154,179],[85,151,178],[82,150,178],[83,151,179],[83,150,179],[80,150,175],[83,151,175],[87,150,175],[110,155,176],[184,201,213],[193,211,225],[161,186,208],[131,165,194],[112,150,183],[107,145,180],[106,146,179],[110,148,181],[129,161,191],[155,180,205],[183,199,216],[181,197,211],[125,159,189],[87,132,172],[82,130,174],[85,131,175],[86,131,175],[86,131,175],[86,131,175],[86,131,173],[86,130,174],[85,129,173],[85,129,171],[88,131,173],[87,130,173],[87,129,173],[87,129,173],[87,130,173],[86,130,173],[89,131,173],[89,131,171],[92,133,170],[114,146,179],[162,181,202],[196,190,168],[191,180,150],[185,172,136],[182,167,125],[181,164,119],[179,163,115],[179,164,116],[179,165,117],[178,165,119],[180,167,126],[183,172,138],[189,182,158],[182,174,139],[173,155,84],[174,154,74],[176,156,74],[178,157,75],[179,158,76],[180,159,77],[180,159,82],[180,161,97],[188,177,138],[201,197,180],[203,199,180],[193,184,149],[188,174,122],[185,169,105],[185,168,98],[185,168,95],[185,168,93],[185,168,91],[186,168,94],[185,168,93],[184,167,92],[183,169,93],[183,169,93],[185,171,98],[188,173,111],[195,182,140],[201,196,171],[197,194,174],[193,189,166],[192,188,163],[192,189,165],[196,192,170],[202,198,180],[202,213,224],[177,201,214],[133,173,192],[93,151,172],[80,145,170],[78,145,170],[80,145,171],[81,146,170],[81,145,172],[80,144,170],[80,144,171],[80,144,170],[80,144,170],[80,145,171],[83,146,170],[92,148,171],[118,161,183],[179,201,217],[181,202,216],[145,178,196],[123,164,184],[115,159,180],[113,158,178],[117,161,183],[134,174,194],[164,194,211],[198,215,229],[207,222,232],[163,196,213],[106,161,184],[89,152,177],[88,153,177],[87,152,176],[89,152,176],[99,153,176],[177,203,216],[206,221,233],[166,196,214],[115,164,186],[92,152,177],[87,150,178],[87,151,179],[87,151,179],[85,152,175],[87,151,175],[97,152,176],[133,170,189],[198,212,224],[196,208,221],[175,194,213],[157,177,201],[145,167,192],[142,165,190],[151,172,194],[174,191,206],[194,206,218],[162,188,209],[98,139,175],[83,130,173],[86,132,176],[87,131,176],[87,131,176],[88,132,175],[89,132,174],[89,131,174],[89,131,172],[92,133,172],[95,135,173],[94,136,174],[95,135,174],[95,135,174],[95,135,174],[96,135,174],[98,136,173],[101,139,173],[115,146,177],[147,169,194],[188,201,214],[198,193,176],[193,186,166],[190,181,158],[188,179,153],[188,179,155],[188,179,157],[190,182,160],[193,187,168],[197,192,178],[180,171,139],[171,154,84],[174,154,76],[175,155,75],[177,157,77],[178,158,78],[180,159,79],[180,159,85],[180,162,104],[194,184,153],[199,190,165],[191,178,133],[188,171,114],[186,169,106],[187,168,105],[186,167,102],[186,167,101],[185,167,100],[184,169,100],[185,169,101],[185,171,104],[189,174,114],[192,181,134],[202,194,166],[193,207,217],[163,189,202],[121,163,181],[98,150,172],[89,146,170],[86,145,170],[87,145,170],[86,145,171],[84,144,171],[84,143,170],[84,144,169],[86,145,170],[88,146,169],[94,148,171],[116,161,182],[166,195,213],[204,216,229],[202,215,226],[185,204,218],[172,194,209],[163,187,202],[160,186,200],[168,192,206],[183,203,215],[202,215,225],[186,211,225],[138,178,197],[111,159,181],[103,154,175],[102,153,175],[108,157,180],[133,173,192],[198,216,227],[190,212,225],[147,187,206],[114,165,189],[100,155,182],[97,153,180],[94,153,177],[95,154,177],[100,155,178],[123,167,188],[173,197,213],[202,211,224],[193,205,222],[186,199,217],[184,199,216],[191,205,219],[203,213,225],[189,206,219],[124,158,186],[88,132,173],[88,132,176],[88,131,176],[88,132,176],[90,133,176],[94,133,174],[95,134,172],[104,137,172],[113,142,175],[120,149,177],[125,153,182],[127,156,185],[128,155,185],[127,155,184],[127,155,183],[126,154,182],[131,158,183],[149,171,193],[179,194,210],[179,172,142],[169,152,86],[173,154,78],[175,154,79],[176,157,79],[177,158,80],[179,159,82],[180,160,89],[182,166,115],[197,190,167],[204,198,177],[198,189,155],[192,182,141],[191,179,135],[191,176,130],[188,173,123],[187,171,118],[185,172,116],[186,173,118],[188,175,122],[195,183,136],[202,193,160],[210,205,187]]}]}}




		// const tmpData1 = {"result":{"text":[{"left":0.4309999942779541,"right":0.5609999895095825,"top":0.5094433426856995,"bottom":0.5751649737358093,"score":0.8339493274688721,"content":"Cc","characters":[{"character":"C","centerLoc":[0.47766668,0.53908247],"poly":[0.45433334,0.50944334,0.50266665,0.50944334,0.50266665,0.56872165,0.45433334,0.56872165]},{"character":"c","centerLoc":[0.531,0.55068046],"poly":[0.5126667,0.53135055,0.551,0.53135055,0.551,0.56872165,0.5126667,0.56872165]}]}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.4259999990463257,"right":0.5609999895095825,"top":0.5081546306610107,"bottom":0.5777422785758972,"score":0.8703044652938843,"content":"Cc","characters":[{"character":"C","centerLoc":[0.476,0.5377938],"poly":[0.451,0.50815463,0.501,0.50815463,0.501,0.56872165,0.451,0.56872165]},{"character":"c","centerLoc":[0.5276667,0.54939175],"poly":[0.5093334,0.53135055,0.54766667,0.53135055,0.54766667,0.56872165,0.5093334,0.56872165]}]}]}}
		// const tmpData1 =  {"result":{"text":[{"points":[0.749,0.505,0.601,0.522]}]}}
		// const tmpData1 = {"result":{"text":[{"symbol":[4,2,3,3,3]}]}};
		// const tmpData1 = {"result":{"text":[{"points":[0.20666666,0.45618558,0.21,0.45618558,0.21333334,0.45618558,0.21666667,0.45618558,0.22,0.45618558,0.22333333,0.45618558,0.22666667,0.45618558,0.23,0.45618558,0.23333333,0.45618558,0.2,0.45876288,0.20333333,0.45876288,0.20666666,0.45876288,0.21,0.45876288,0.21333334,0.45876288,0.21666667,0.45876288,0.22,0.45876288,0.22333333,0.45876288,0.22666667,0.45876288,0.23,0.45876288,0.23333333,0.45876288,0.23666666,0.45876288,0.24,0.45876288,0.19,0.46134022,0.19333333,0.46134022,0.19666667,0.46134022,0.2,0.46134022,0.20333333,0.46134022,0.20666666,0.46134022,0.21,0.46134022,0.21333334,0.46134022,0.21666667,0.46134022,0.22,0.46134022,0.22333333,0.46134022,0.22666667,0.46134022,0.23,0.46134022,0.23333333,0.46134022,0.23666666,0.46134022,0.24,0.46134022,0.24333334,0.46134022,0.24666667,0.46134022,0.25,0.46134022,0.17666666,0.46391752,0.18333334,0.46391752,0.18666667,0.46391752,0.19,0.46391752,0.19333333,0.46391752,0.19666667,0.46391752,0.24333334,0.46391752,0.24666667,0.46391752,0.25,0.46391752,0.25333333,0.46391752,0.25666666,0.46391752,0.26333332,0.46391752,0.17333333,0.46649486,0.17666666,0.46649486,0.18,0.46649486,0.18333334,0.46649486,0.25666666,0.46649486,0.26,0.46649486,0.26333332,0.46649486,0.26666668,0.46649486,0.17,0.46907216,0.17333333,0.46907216,0.17666666,0.46907216,0.26333332,0.46907216,0.26666668,0.46907216,0.27,0.46907216,0.16333333,0.4716495,0.16666667,0.4716495,0.17,0.4716495,0.17333333,0.4716495,0.26666668,0.4716495,0.27,0.4716495,0.27333334,0.4716495,0.27666667,0.4716495,0.16,0.4742268,0.16333333,0.4742268,0.16666667,0.4742268,0.27333334,0.4742268,0.27666667,0.4742268,0.28,0.4742268,0.15666667,0.47680414,0.16,0.47680414,0.16333333,0.47680414,0.27666667,0.47680414,0.28,0.47680414,0.28333333,0.47680414,0.15666667,0.47938144,0.16,0.47938144,0.28,0.47938144,0.28333333,0.47938144,0.15333334,0.48195878,0.15666667,0.48195878,0.28333333,0.48195878,0.28666666,0.48195878,0.14666666,0.48453608,0.15,0.48453608,0.15333334,0.48453608,0.28666666,0.48453608,0.29,0.48453608,0.29333332,0.48453608,0.14666666,0.48711342,0.15,0.48711342,0.15333334,0.48711342,0.28666666,0.48711342,0.29,0.48711342,0.29333332,0.48711342,0.14333333,0.48969072,0.14666666,0.48969072,0.15,0.48969072,0.29,0.48969072,0.29333332,0.48969072,0.29666665,0.48969072,0.14333333,0.49226806,0.14666666,0.49226806,0.29333332,0.49226806,0.29666665,0.49226806,0.14333333,0.49484536,0.29666665,0.49484536,0.14,0.4974227,0.14333333,0.4974227,0.29666665,0.4974227,0.3,0.4974227,0.14,0.5,0.3,0.5,0.13666667,0.5025773,0.14,0.5025773,0.3,0.5025773,0.30333334,0.5025773,0.13666667,0.5051546,0.14,0.5051546,0.3,0.5051546,0.30333334,0.5051546,0.13333334,0.507732,0.13666667,0.507732,0.14,0.507732,0.3,0.507732,0.30333334,0.507732,0.30666667,0.507732,0.13333334,0.5103093,0.13666667,0.5103093,0.30333334,0.5103093,0.30666667,0.5103093,0.13333334,0.5128866,0.13666667,0.5128866,0.30333334,0.5128866,0.30666667,0.5128866,0.13333334,0.5154639,0.13666667,0.5154639,0.30333334,0.5154639,0.30666667,0.5154639,0.13333334,0.51804125,0.13666667,0.51804125,0.30333334,0.51804125,0.30666667,0.51804125,0.13333334,0.52061856,0.13666667,0.52061856,0.30333334,0.52061856,0.30666667,0.52061856,0.13333334,0.52319586,0.13666667,0.52319586,0.30333334,0.52319586,0.30666667,0.52319586,0.13,0.52577317,0.13333334,0.52577317,0.13666667,0.52577317,0.30333334,0.52577317,0.30666667,0.52577317,0.31,0.52577317,0.13333334,0.52835053,0.13666667,0.52835053,0.30333334,0.52835053,0.30666667,0.52835053,0.13333334,0.53092784,0.13666667,0.53092784,0.30333334,0.53092784,0.30666667,0.53092784,0.13333334,0.53350514,0.13666667,0.53350514,0.30333334,0.53350514,0.30666667,0.53350514,0.13333334,0.53608245,0.13666667,0.53608245,0.30333334,0.53608245,0.30666667,0.53608245,0.13333334,0.5386598,0.13666667,0.5386598,0.30333334,0.5386598,0.30666667,0.5386598,0.13333334,0.5412371,0.13666667,0.5412371,0.30333334,0.5412371,0.30666667,0.5412371,0.13333334,0.5438144,0.13666667,0.5438144,0.14,0.5438144,0.3,0.5438144,0.30333334,0.5438144,0.30666667,0.5438144,0.13666667,0.5463917,0.14,0.5463917,0.3,0.5463917,0.30333334,0.5463917,0.13666667,0.5489691,0.14,0.5489691,0.3,0.5489691,0.30333334,0.5489691,0.14,0.5515464,0.3,0.5515464,0.14,0.5541237,0.14333333,0.5541237,0.29666665,0.5541237,0.3,0.5541237,0.14333333,0.556701,0.29666665,0.556701,0.14333333,0.55927837,0.14666666,0.55927837,0.29333332,0.55927837,0.29666665,0.55927837,0.14333333,0.5618557,0.14666666,0.5618557,0.15,0.5618557,0.29,0.5618557,0.29333332,0.5618557,0.29666665,0.5618557,0.14666666,0.564433,0.15,0.564433,0.15333334,0.564433,0.28666666,0.564433,0.29,0.564433,0.29333332,0.564433,0.14666666,0.5670103,0.15,0.5670103,0.15333334,0.5670103,0.28666666,0.5670103,0.29,0.5670103,0.29333332,0.5670103,0.15333334,0.56958765,0.15666667,0.56958765,0.28333333,0.56958765,0.28666666,0.56958765,0.15666667,0.57216495,0.16,0.57216495,0.28,0.57216495,0.28333333,0.57216495,0.15666667,0.57474226,0.16,0.57474226,0.16333333,0.57474226,0.27666667,0.57474226,0.28,0.57474226,0.28333333,0.57474226,0.16,0.57731956,0.16333333,0.57731956,0.16666667,0.57731956,0.27333334,0.57731956,0.27666667,0.57731956,0.28,0.57731956,0.16333333,0.5798969,0.16666667,0.5798969,0.17,0.5798969,0.17333333,0.5798969,0.26666668,0.5798969,0.27,0.5798969,0.27333334,0.5798969,0.27666667,0.5798969,0.17,0.58247423,0.17333333,0.58247423,0.17666666,0.58247423,0.26333332,0.58247423,0.26666668,0.58247423,0.27,0.58247423,0.17333333,0.58505154,0.17666666,0.58505154,0.18,0.58505154,0.18333334,0.58505154,0.25666666,0.58505154,0.26,0.58505154,0.26333332,0.58505154,0.26666668,0.58505154,0.17666666,0.58762884,0.18333334,0.58762884,0.18666667,0.58762884,0.19,0.58762884,0.19333333,0.58762884,0.19666667,0.58762884,0.24333334,0.58762884,0.24666667,0.58762884,0.25,0.58762884,0.25333333,0.58762884,0.25666666,0.58762884,0.26333332,0.58762884,0.19,0.5902062,0.19333333,0.5902062,0.19666667,0.5902062,0.2,0.5902062,0.20333333,0.5902062,0.20666666,0.5902062,0.21,0.5902062,0.21333334,0.5902062,0.21666667,0.5902062,0.22,0.5902062,0.22333333,0.5902062,0.22666667,0.5902062,0.23,0.5902062,0.23333333,0.5902062,0.23666666,0.5902062,0.24,0.5902062,0.24333334,0.5902062,0.24666667,0.5902062,0.25,0.5902062,0.2,0.5927835,0.20333333,0.5927835,0.20666666,0.5927835,0.21,0.5927835,0.21333334,0.5927835,0.21666667,0.5927835,0.22,0.5927835,0.22333333,0.5927835,0.22666667,0.5927835,0.23,0.5927835,0.23333333,0.5927835,0.23666666,0.5927835,0.24,0.5927835,0.20666666,0.5953608,0.21,0.5953608,0.21333334,0.5953608,0.21666667,0.5953608,0.22,0.5953608,0.22333333,0.5953608,0.22666667,0.5953608,0.23,0.5953608,0.23333333,0.5953608]}]}}


		// const tmpData1 = {"result":{"text":[{"type":1,"points":[0.23666666,0.45360824,0.24,0.45360824,0.22,0.45618558,0.22333333,0.45618558,0.22666667,0.45618558,0.23,0.45618558,0.23333333,0.45618558,0.24333334,0.45618558,0.24666667,0.45618558,0.25,0.45618558,0.25333333,0.45618558,0.25666666,0.45618558,0.26,0.45618558,0.20666666,0.45876288,0.21,0.45876288,0.21333334,0.45876288,0.21666667,0.45876288,0.26333332,0.45876288,0.26666668,0.45876288,0.27,0.45876288,0.27333334,0.45876288,0.19666667,0.46134022,0.2,0.46134022,0.20333333,0.46134022,0.27666667,0.46134022,0.28,0.46134022,0.28333333,0.46134022,0.17666666,0.46391752,0.18,0.46391752,0.18333334,0.46391752,0.18666667,0.46391752,0.19,0.46391752,0.19333333,0.46391752,0.28666666,0.46391752,0.29,0.46391752,0.29333332,0.46391752,0.29666665,0.46391752,0.3,0.46391752,0.30333334,0.46391752,0.30666667,0.46391752,0.31,0.46391752,0.31333333,0.46391752,0.31666666,0.46391752,0.32,0.46391752,0.32333332,0.46391752,0.32666665,0.46391752,0.17,0.46649486,0.17333333,0.46649486,0.28666666,0.46649486,0.33,0.46649486,0.33333334,0.46649486,0.33666667,0.46649486,0.34,0.46649486,0.34333333,0.46649486,0.34666666,0.46649486,0.35,0.46649486,0.35333332,0.46649486,0.35666665,0.46649486,0.36,0.46649486,0.36333334,0.46649486,0.36666667,0.46649486,0.37,0.46649486,0.16666667,0.46907216,0.28666666,0.46907216,0.16333333,0.4716495,0.28666666,0.4716495,0.16333333,0.4742268,0.28666666,0.4742268,0.16333333,0.47680414,0.28666666,0.47680414,0.16,0.47938144,0.28666666,0.47938144,0.16,0.48195878,0.28666666,0.48195878,0.16,0.48453608,0.28666666,0.48453608,0.16,0.48711342,0.29,0.48711342,0.15666667,0.48969072,0.29,0.48969072,0.15333334,0.49226806,0.29,0.49226806,0.15333334,0.49484536,0.29,0.49484536,0.15333334,0.4974227,0.29,0.4974227,0.15,0.5,0.29,0.5,0.15,0.5025773,0.29,0.5025773,0.15,0.5051546,0.29,0.5051546,0.15,0.507732,0.28666666,0.507732,0.15,0.5103093,0.28666666,0.5103093,0.15,0.5128866,0.28666666,0.5128866,0.15,0.5154639,0.28666666,0.5154639,0.15,0.51804125,0.28666666,0.51804125,0.15,0.52061856,0.28666666,0.52061856,0.15,0.52319586,0.28333333,0.52319586,0.15333334,0.52577317,0.28333333,0.52577317,0.15333334,0.52835053,0.28,0.52835053,0.15333334,0.53092784,0.27666667,0.53092784,0.15333334,0.53350514,0.27333334,0.53350514,0.15333334,0.53608245,0.26666668,0.53608245,0.27,0.53608245,0.15333334,0.5386598,0.25666666,0.5386598,0.26,0.5386598,0.26333332,0.5386598,0.15666667,0.5412371,0.25,0.5412371,0.25333333,0.5412371,0.15666667,0.5438144,0.24333334,0.5438144,0.24666667,0.5438144,0.15666667,0.5463917,0.23333333,0.5463917,0.23666666,0.5463917,0.24,0.5463917,0.16,0.5489691,0.23,0.5489691,0.16333333,0.5515464,0.22333333,0.5515464,0.22666667,0.5515464,0.16666667,0.5541237,0.17,0.5541237,0.17333333,0.5541237,0.17666666,0.5541237,0.18,0.5541237,0.18333334,0.5541237,0.18666667,0.5541237,0.19,0.5541237,0.19333333,0.5541237,0.19666667,0.5541237,0.2,0.5541237,0.20333333,0.5541237,0.20666666,0.5541237,0.21,0.5541237,0.21333334,0.5541237,0.21666667,0.5541237,0.22,0.5541237]}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.22833333909511566,"right":0.3166666626930237,"top":0.5590206384658813,"bottom":0.628608226776123,"score":0.8552894592285156,"content":"Aa"},{"left":0.6816666126251221,"right":0.7666666507720947,"top":0.42257729172706604,"bottom":0.49860823154449463,"score":0.8148108720779419,"content":"Aa"},{"left":0.6983333230018616,"right":0.7666666507720947,"top":0.5564433336257935,"bottom":0.628608226776123,"score":0.7532452344894409,"content":"Aa"}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.09814612567424774,"right":0.4471101462841034,"top":0.006644518114626408,"bottom":0.15614618360996246,"score":1,"content":"CTrace,write,and say."},{"left":0.10796073824167252,"right":0.5049073100090027,"top":0.1827242523431778,"bottom":0.4518272280693054,"score":0.9702169299125671,"content":"AAAA"},{"left":0.5834242105484009,"right":0.659760057926178,"top":0.17607973515987396,"bottom":0.4485049843788147,"score":0.9523985981941223,"content":"A"},{"left":0.6706652045249939,"right":0.8298800587654114,"top":0.15614618360996246,"bottom":0.43853819370269775,"score":0.9089533090591431,"content":"A"},{"left":0.5866957306861877,"right":0.6521264910697937,"top":0.634551465511322,"bottom":0.8504983186721802,"score":0.8326067328453064,"content":"a"},{"left":0.7699018716812134,"right":0.8276990056037903,"top":0.6411960124969482,"bottom":0.8039867281913757,"score":0.8035371899604797,"content":"a"}]}}
		cb(tmpData1);
		return;
	// const tmpData = {"allText":"Look and Trace\nblackboard\nwindow","block":[{"line":[{"word":[{"content":"Look","cornerPoint":[{"x":87,"y":203},{"x":83,"y":166},{"x":93,"y":164},{"x":97,"y":201}],"location":{"bottom":97,"left":85,"right":124,"top":83},"recognizedLanguage":"und"},{"content":"and","cornerPoint":[{"x":85,"y":161},{"x":82,"y":138},{"x":90,"y":137},{"x":93,"y":160}],"location":{"bottom":93,"left":127,"right":151,"top":82},"recognizedLanguage":"und"},{"content":"Trace","cornerPoint":[{"x":81,"y":132},{"x":77,"y":96},{"x":86,"y":95},{"x":90,"y":131}],"location":{"bottom":90,"left":156,"right":193,"top":77},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"blackboard","cornerPoint":[{"x":119,"y":129},{"x":116,"y":58},{"x":131,"y":57},{"x":134,"y":128}],"location":{"bottom":134,"left":159,"right":231,"top":116},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"window","cornerPoint":[{"x":171,"y":123},{"x":166,"y":72},{"x":177,"y":70},{"x":182,"y":121}],"location":{"bottom":182,"left":165,"right":218,"top":166},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"Trace ttre letters\nLook! She is Short\nShe is a\ngirl.\nShe is a\ngirl.\nShe is smiling. She is","block":[{"line":[{"word":[{"content":"Trace","cornerPoint":[{"x":460,"y":366},{"x":416,"y":366},{"x":416,"y":354},{"x":460,"y":354}],"location":{"bottom":126,"left":20,"right":64,"top":114},"recognizedLanguage":"und"},{"content":"ttre","cornerPoint":[{"x":412,"y":367},{"x":387,"y":367},{"x":387,"y":354},{"x":412,"y":354}],"location":{"bottom":126,"left":68,"right":93,"top":113},"recognizedLanguage":"und"},{"content":"letters","cornerPoint":[{"x":384,"y":367},{"x":334,"y":367},{"x":334,"y":354},{"x":384,"y":354}],"location":{"bottom":126,"left":96,"right":146,"top":113},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Look!","cornerPoint":[{"x":340,"y":316},{"x":300,"y":318},{"x":299,"y":305},{"x":339,"y":303}],"location":{"bottom":177,"left":140,"right":181,"top":162},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"e-Tnace the lettEr5\nAa Aa\nAa\nB b Bb Bbb\nBb\nCc\nCc","block":[{"line":[{"word":[{"content":"e-Tnace","cornerPoint":[{"x":399,"y":393},{"x":317,"y":395},{"x":316,"y":379},{"x":398,"y":377}],"location":{"bottom":103,"left":81,"right":164,"top":85},"recognizedLanguage":"und"},{"content":"the","cornerPoint":[{"x":313,"y":396},{"x":282,"y":396},{"x":281,"y":380},{"x":312,"y":380}],"location":{"bottom":100,"left":167,"right":199,"top":84},"recognizedLanguage":"und"},{"content":"lettEr5","cornerPoint":[{"x":278,"y":397},{"x":217,"y":398},{"x":216,"y":382},{"x":277,"y":381}],"location":{"bottom":99,"left":202,"right":264,"top":82},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Aa","cornerPoint":[{"x":436,"y":362},{"x":349,"y":363},{"x":348,"y":322},{"x":435,"y":321}],"location":{"bottom":159,"left":44,"right":132,"top":117},"recognizedLanguage":"und"}]}]}]}

		cb(tmpData);
	},


	checkOneCombineGroupEnd(node) {

		const signItem = node.data.signItem;

		for (let i=0; i<this.itemCombineGroup.length; i++) {
			const key1 = this.itemCombineGroup[i][0] + 1;
			const key2 = this.itemCombineGroup[i][1] + 1;

			if (key1 == signItem || key2 == signItem) {

				let item1, item2;
				for (let j=0; j<this.signAnimaNodeArr.length; j++) {
					const data = this.signAnimaNodeArr[j].data;
					if (data.signItem == key1) {
						item1 = this.signAnimaNodeArr[j];
					} else if (data.signItem == item2) {
						item2 =  this.signAnimaNodeArr[j];
					}
				}

				if (item1?.isShowEnd || item2?.isShowEnd) {
					return true;
				}
				return false;
			}
			
		}
	},

	checkGameEndCombineGroup() {
		// const arr = this.signAnimaNodeArr;
		console.log(' in checkGameEndCombineGroup');

		for (let i=0; i<this.itemCombineGroup.length; i++) {
			const key1 = this.itemCombineGroup[i][0] + 1;
			const key2 = this.itemCombineGroup[i][1] + 1;

			let item1, item2;

			for (let j=0; j<this.signAnimaNodeArr.length; j++) {
				const data = this.signAnimaNodeArr[j].data;
				if (data.signItem == key1) {
					item1 = this.signAnimaNodeArr[j];
				} else if (data.signItem == key2) {
					item2 =  this.signAnimaNodeArr[j];
				}
			}

			if (!item1.isShowEnd && !item2.isShowEnd) {
				this.resetHelperTime();
				return;
			}
			
		}

		this.gameEnd();
	},


	checkGameEnd( arr ) {

		console.log(' in checkGameEnd arr.length: ', arr.length);
		if (!arr) {
			arr = this.animaNodeArr;
		}
		const isEnd = arr.every(node => {
			return node.isShowEnd;
		})

		if (isEnd) {
			this.gameEnd();
		} else {

			this.resetHelperTime();

			// this.endTesting();

			// setTimeout(() => {
			// 	this.startTesting();
			// }, 8000);

		}
	},














	bigStarArr: null,
	initStar() {
		const gArr = this.data.groupArr;
		if (gArr.length <= 1) {
			return;
		}

		this.cleanStar();

		this.bigStarArr = [];

		let baseX = this.canvas.width / 2 - 80 * this._mapScaleMin;
		let baseY = this.canvas.height / 2 - 80 * this._mapScaleMin;
		let disH = 80 * this._mapScaleMin;
		let disScale = 1;
		if (gArr.length > 5) {
			disH = (400 / gArr.length) * this._mapScaleMin;
			disScale = 5 / gArr.length;
		}
		for (let i = 0; i < gArr.length; i++) {
			const starBg = getSprNode('star_bg');
			this.canvas.addChild(starBg, 10);
			starBg.x = baseX;
			starBg.y = baseY - i * disH;
			starBg.scale = disScale;

			const starTop = getSprNode('star');
			starBg.addChild(starTop);
			starTop.active = false;
			starBg.star = starTop;

			const starBig = getSprNode('icon_bigstar');
			starTop.addChild(starBig);
			starBig.angle = -90;
			starBg.starBig = starBig;

			this.bigStarArr.push(starBg);
		}

		console.log("bigStarArr: ", this.bigStarArr);
	},

	cleanStar() {
		if (this.bigStarArr && this.bigStarArr.length > 0) {
			for (let i=0; i<this.bigStarArr.length; i++) {
				this.bigStarArr[i].removeFromParent();
			}
		}
	},


	showBigStar() {
		if (!this.bigStarArr || this.bigStarArr.length <= 0) {
			this.checkGameEnd();
			return;
		}
		const bigStarBg = this.bigStarArr[this.curGroupIndex];

		const starBig = bigStarBg.starBig;
		starBig.scale = 1;
		const star = bigStarBg.star;
		star.active = true;
		star.scaleX = 0.7 / bigStarBg.scale;
		star.scaleY = 1 / bigStarBg.scale;
		star.angle = 90;
		const canvas = cc.find('Canvas');
		const startPos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 2));
		const middlePos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 4));
		star.x = startPos.x;
		star.y = startPos.y - starBig.height;

		console.log('middlePos = ' + JSON.stringify(middlePos));
		const time = 1;
		cc.tween(star)
			.to(0.3, { y: middlePos.y + 80 }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y + 40, scaleX: 1.2 / bigStarBg.scale, scaleY: 0.8 / bigStarBg.scale }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y, scaleX: 1 / bigStarBg.scale, scaleY: 1 / bigStarBg.scale }, { easing: 'quadOut' })
			.delay(0.1)
			.to(0.8, { angle: -720, scale: 1 })
			.start();

		cc.tween(star)
			.delay(0.6)
			.to(0.8, { x: 0 }, { easing: 'quadIn' })
			.start();
		cc.tween(star)
			.delay(0.6)
			.to(0.8, { y: 0 }, { easing: 'quadOut' })
			.start();

		cc.tween(starBig)
			.delay(0.6)
			.to(0.8, { scale: 0 }, { easing: 'quadOut' })
			.call(() => {
				this.checkGameEnd();
				playAudio(this.starCountClip);
			})
			.start();

		playAudio(this.bigStarClip);
	},

	// checkGameEnd() {
	
	// 	this.curGroupIndex ++;
	// 	this.setCurGroupAndQuestion();



	// 	if (!this.curQuestionData) {
	// 		// this.gameEnd();
	// 		return;
	// 	}

	// 	this.showChangeQuesAnim();
	// },

	


	checkBtn: null,
	initBtn() {
		const checkBtn = getSprNode("btn_check");
		checkBtn.scale = this._mapScaleMin;
		this.canvas.addChild(checkBtn);
		checkBtn.x = -500 * this._mapScaleMin;
		checkBtn.y = -35 * this._mapScaleMin;
		checkBtn.baseX = checkBtn.x;
		checkBtn.baseY = checkBtn.y;
		checkBtn.opacity = 0;
		this.checkBtn = checkBtn;

		checkBtn.on(cc.Node.EventType.TOUCH_START, () => {
			if (checkBtn.opacity == 0) {
				return;
			}
			showBtnAnima(checkBtn);
			this.checkBtnClick();
		})

	},

	refreshCheckBtn() {

		this.checkBtn.opacity = 0;

		const arr = this.curOptionArr;
		for (let i=0; i<arr.length; i++) {
			if (arr[i].light.opacity > 254) {
				this.checkBtn.opacity = 255;
				return;
			}
		}
	},

	tryagain: null,
	initIcon() {
		const icon = getSprNode("try_again");
		icon.opacity = 0;
		icon.scale = this._mapScaleMin;
		this.canvas.addChild(icon);

		this.tryagain = icon;
	},

	showTryAgain() {
		const time = 0.3;
		cc.tween(this.tryagain)
			.to(time, {opacity: 255}, {easing: "cubicOut"})
			.delay(0.3)
			.to(time, {opacity: 0}, {easing: "cubicIn"})
			.start();
	},


	initQuestion() {
		this.initPicQuestion();
		this.initTextQuestion();
		this.initVideoQuestion();
		this.initAudioQuestion();
	},

	quesPicBg: null,
	initPicQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesPicBg = picBg;
		picBg.active = false;

		this.addQuesAudio(picBg)
	},

	quesTextBg: null,
	initTextQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesTextBg = picBg;


		const labelNode = new cc.Node();
		labelNode.parent = picBg;
		const label = labelNode.addComponent(cc.RichText);
		const size = 80
		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		// label.string = `<outline color=#a83c13 width=2><size=${size}><color=#ffffff>${this.data.title || " " }</color></size></outline>`
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.CENTER

		label.maxWidth = 648;
	
		picBg.label = label;

		picBg.active = false;
		this.addQuesAudio(picBg)
	},

	quesVideoBg: null,
	videoNode: null,
	initVideoQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesVideoBg = picBg;

		const videoNode = new cc.Node();
		const vPlayer = videoNode.addComponent(cc.VideoPlayer);
		picBg.addChild(videoNode);

		videoNode.width = 678;
		videoNode.height = 396;
		this.videoNode = videoNode;

		picBg.video = vPlayer;


		const btnNode = new cc.Node();
		picBg.addChild(btnNode);
		btnNode.x = picBg.width / 2 + 50;

		const playBtn = getSprNode("video_play");
		btnNode.addChild(playBtn);

		const pauseBtn = getSprNode("video_pause");
		btnNode.addChild(pauseBtn);
		pauseBtn.active = false;


		videoNode.player = vPlayer;
		videoNode.playBtn = playBtn;
		videoNode.pauseBtn = pauseBtn;

		playBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.play();
			playBtn.active = false;
			pauseBtn.active = true;
		})

		pauseBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.pause();
			pauseBtn.active = false;
			playBtn.active = true;
		})

		videoNode.on('completed', () => {
			pauseBtn.active = false;
			playBtn.active = true;
		})


		picBg.active = false;
	},

	quesAudioBg: null,
	initAudioQuestion() {

		
		const audioNode = new cc.Node();
		audioNode.active = false;

		this.canvas.addChild(audioNode);
		audioNode.x = 440 * this._mapScaleMin;
		audioNode.y = -60 * this._mapScaleMin;
		this.quesAudioBg = audioNode;
		
		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/audio_big"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('audio_big')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}

			if (!audioNode.audioClip) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('audio_big');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

	},


	addQuesAudio(bg) {
		const audioNode = new cc.Node();
		bg.addChild(audioNode);
		audioNode.x = bg.width / 2 + 50;


		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/ques_audio"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('ques_audio')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('ques_audio');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

		bg.audioNode = audioNode;
	},

	initOption() {
		this.initPicOption();
		this.initAudioOption();
		this.initTextOption();

		this.initPicOptionBig();
		this.initAudioOptionBig();
		this.initTextOptionBig();
	},

	optionPicBgArr: null,
	initPicOption() {
		// console.log('this.data: ', this.data);
		this.optionPicBgArr = [];
		for (let i=0; i<4; i++) {
		
			const pic = this.getOnePicOption();
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.y = -235 * this._mapScaleMin;
			this.optionPicBgArr.push(pic);

		} 
	},

	optionPicBgBigArr: null,
	initPicOptionBig() {
		this.optionPicBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;


		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}
			const pic = this.getOnePicOption(true);
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.x = baseX + count * disW;
			pic.y = baseY;
			this.optionPicBgBigArr.push(pic);

			count ++;
		} 
	},

	getOnePicOption(isBig = false) {
		const picBgParent = new cc.Node();

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const light = getSprNode(lightResName);
		picBgParent.addChild(light);
		light.opacity = 0;
		picBgParent.light = light;

		const picBg = getSprNode(bgResName);
		picBgParent.addChild(picBg);
		picBgParent.picBg = picBg;

		picBgParent.width = picBg.width;
		picBgParent.height = picBg.height;


		const soundNode = new cc.Node();
		picBgParent.addChild(soundNode);
		picBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = picBgParent.width / 2 - soundIconTop.width / 2;
		soundNode.y = picBgParent.height / 2 //- soundIconTop.height / 2;
		soundNode.active = false;


		picBgParent.active = false;


		picBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}

			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return picBgParent;
	},

	addIconRight(bg) {

		const px = bg.width / 2;
		const py = -bg.height / 2 ;
		const worldPos = bg.convertToWorldSpaceAR(cc.v2(px, py));
		const localPos = this.canvas.convertToNodeSpaceAR(worldPos);


		const iconRight = getSprNode('icon_right');
		iconRight.scale = this._mapScaleMin;
		this.canvas.addChild(iconRight, 1);
		iconRight.x = localPos.x;
		iconRight.y = localPos.y + 50 * this._mapScaleMin;

		bg.iconRight = iconRight;


		this.showOneFirework(cc.v2(0, -bg.height / 3), bg, cc.find('paperBase').children, 200, 300, 20, 1);
	},


	optionAudioBgArr: null,
	initAudioOption() {
		this.optionAudioBgArr = [];
		for (let i=0; i<4; i++) {
		
			const audio = this.getOneAudioOption();
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.y = -235 * this._mapScaleMin;
			this.optionAudioBgArr.push(audio);
		} 
	},

	optionAudioBgBigArr: null,
	initAudioOptionBig() {

		this.optionAudioBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;

		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}

			const audio = this.getOneAudioOption(true);
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.x = baseX + count * disW;
			audio.y = baseY;
			this.optionAudioBgBigArr.push(audio);

			count ++;
		} 
	},


	optionTextBgArr: null,
	initTextOption() {
		this.optionTextBgArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption();
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			// textOption.y = -235 * this._mapScaleMin;
			this.optionTextBgArr.push(textOption);
		} 
	},

	optionTextBgBigArr: null,
	initTextOptionBig() {

		const baseX = -180 * this._mapScaleMin;
		const disW = 100 * this._mapScaleMin;
		let baseY = 220 * this._mapScaleMin;
		const disH = 150 * this._mapScaleMin;

		this.optionTextBgBigArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption(true);
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			textOption.x = baseX;
			textOption.y = baseY - i * disH;
			this.optionTextBgBigArr.push(textOption);
		}
	},

	getOneAudioOption(isBig=false) {

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const audioBgNode = new cc.Node();

		const light = getSprNode(lightResName);
		audioBgNode.addChild(light);
		light.opacity = 0;
		audioBgNode.light = light;

		const picBg = getSprNode(bgResName);
		audioBgNode.addChild(picBg);
		audioBgNode.picBg = picBg;

		audioBgNode.width = picBg.width;
		audioBgNode.height = picBg.height;

		const animNode = cc.instantiate(cc.find("Canvas/res/anim/op_audio"))
		audioBgNode.addChild(animNode);
		animNode.anchorX = 0.6;


		const animTop = getSprNode('op_audio');
		audioBgNode.addChild(animTop);
		animTop.anchorX = 0.6;

		const anim = animNode.getComponent(cc.Animation);
		animNode.opacity = 0;

		audioBgNode.anim = anim;
		audioBgNode.animNode = animNode;
		audioBgNode.animTop = animTop;
		
		audioBgNode.showAnim = () => {
			this.playItemAnim(audioBgNode);
			cc.audioEngine.stop(audioBgNode.audioId);
		}
		audioBgNode.stopAnim = () => {
			cc.audioEngine.stop(audioBgNode.audioId);
			this.stopItemAnim(audioBgNode);
		}

		audioBgNode.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
				
				audioBgNode.showAnim();
				if (audioBgNode.audioClip) {
					audioBgNode.audioId = playAudio(audioBgNode.audioClip, () => {
						this.stopItemAnim(audioBgNode);
					});
				}

			} else {
				light.opacity = 0;
				audioBgNode.stopAnim();
			}

			this.refreshCheckBtn();

		});

		audioBgNode.active = false;

		return audioBgNode;
	},

	getOneTextOption(isBig=false) {

		let lightResName = "option_text_bg_l";
		let bgResName = "option_text_bg";
		if (isBig) {
			lightResName = "op_text_bg_big_l";
			bgResName = "op_text_bg_big";
		}

		const textBgParent = new cc.Node();
		textBgParent.active = false;

		const light = getSprNode(lightResName);
		textBgParent.addChild(light);
		light.opacity = 0;
		textBgParent.light = light;

		const textBg = getSprNode(bgResName);
		textBgParent.addChild(textBg);
		textBgParent.textBg = textBg;

		textBgParent.width = textBg.width;
		textBgParent.height = textBg.height;

		const labelNode = new cc.Node();
		labelNode.parent = textBgParent;
		const label = labelNode.addComponent(cc.Label);

		label.fontSize = 56;
		label.lineHeight = 56;
		if (isBig) {
			label.fontSize = 64;
			label.lineHeight = 64;
		}

		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		textBgParent.label = label;

		const color = new cc.Color();
		cc.Color.fromHEX(color, '#023659' );
		labelNode.color = color;


		const soundNode = new cc.Node();
		textBgParent.addChild(soundNode);
		textBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = textBgParent.width / 2 - 15; // - soundIconTop.width / 2;
		soundNode.y = textBgParent.height / 2 - 15; //- soundIconTop.height / 2;
		soundNode.active = false;


		textBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}
			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return textBgParent;
	},

	playItemAnim(item) {
		item.anim.play();
		item.animNode.opacity = 255;
		item.animTop.opacity = 0;
	},

	stopItemAnim(item) {
		item.animNode.opacity = 0;
		item.animTop.opacity = 255;
	},

	setCurQuestion() {
		
		switch(this.curQuestionData.questionType) {
			case "pic":
				this.setQuestionPic();
				break;
			case "text":
				this.setQuestionText();
				break;
			case "video":
				this.setQuestionVideo();
				break;
			case "audio":
				this.setQuestionAudio();
				break;
		}

		this.refreshCheckBtnPos();
	},

	refreshCheckBtnPos() {
		if (this.curQuestionData.questionType == 'audio') {
			this.checkBtn.x = 440 * this._mapScaleMin;
			this.checkBtn.y = -240 * this._mapScaleMin;
		} else {
			this.checkBtn.x = this.checkBtn.baseX;
			this.checkBtn.y = this.checkBtn.baseY;
		}
	},

	curQuesBg: null,
	setQuestionPic() {

		this.curQuesBg = this.quesPicBg;
		this.curQuesBg.active = true;


		if (this.quesPicBg.pic) {
			this.quesPicBg.pic.removeFromParent();
			this.quesPicBg.pic = null;
		}
		if (this.curQuestionData.pic_url) {
			getSprNodeByUrl(this.curQuestionData.pic_url, (spr) => {
				const sprNode = spr.node;
				setSprNodeMaxLen(sprNode, 678, 396);
				this.quesPicBg.addChild(sprNode)
				this.quesPicBg.pic = sprNode;
			})
		}
	
		const audioNode = this.quesPicBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionText() {
		this.curQuesBg = this.quesTextBg;
		this.curQuesBg.active = true;

		
		const label = this.curQuesBg.label;
		const size = 80; 
		label.string = `<size=${size}><color=#fff4b6>${this.curQuestionData.text}</color></size>`

		const maxH = this.curQuesBg.height * 0.98;

		if (label.node.height > maxH) {
			label.node.scale = maxH / label.node.height
		} else {
			label.node.scale = 1;
		}


		const audioNode = this.curQuesBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionVideo() {
		this.curQuesBg = this.quesVideoBg;
		this.curQuesBg.active = true;
		this.videoNode.active = true;

		if (this.curQuestionData.video_url) {
			this.curQuesBg.video.remoteURL = this.curQuestionData.video_url;
		}
	},

	setQuestionAudio() {
		this.curQuesBg = this.quesAudioBg;
		this.curQuesBg.active = true;


		this.curQuesBg.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				this.curQuesBg.audioClip = audioClip;
			});
		}
	},



	setCurOption() {
		const arr = this.curQuestionData.answerArr;

		const isBig = this.curQuestionData.questionType == 'audio';

		switch(this.curQuestionData.answerType) {
			case "pic":
				this.setOptionPic(arr, isBig);
				break;
			case "audio":
				this.setOptionAudio(arr, isBig);
				break;
			case "text":
				this.setOptionText(arr, isBig);
				break;
		}
		
	},



	curOptionArr: null,
	setOptionPic(arr, isBig=false) {

		let opItemArr = this.optionPicBgArr;
		if (isBig) {
			opItemArr = this.optionPicBgBigArr;
		}
		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const picBg = opItemArr[i].picBg;
			picBg.removeAllChildren();
			
			const data = arr[i];
			if (data.pic_url) {
				getSprNodeByUrl, getSprNodeByUrl(data.pic_url, (spr) => {
					let maxW = 280;
					let maxH = 190;
					if (isBig) {
						maxW = 366;
						maxH = 248;
					}

					setSprNodeMaxLen(spr.node, maxW, maxH);
					console.log('spr: ', spr);
					picBg.addChild(spr.node);
				})
			}

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},


	setOptionAudio(arr, isBig=false) {

		let opItemArr = this.optionAudioBgArr;
		if (isBig) {
			opItemArr = this.optionAudioBgBigArr;
		}

		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if(!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const data = arr[i];

			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					opItemArr[i].audioClip = audioClip;
				});
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},

	setOptionAudioBig(arr) {
		this.curOptionArr = [];
		for (let i=0; i<arr.length; i++) {
			
			this.optionAudioBgArr[i].active = true;

			const data = arr[i];

			this.optionAudioBgArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					this.optionAudioBgArr[i].audioClip = audioClip;
				});
			}

			this.optionAudioBgArr[i].data = data;
			this.curOptionArr.push(this.optionAudioBgArr[i]);
		}
	},


	setOptionText(options, isBig=false) {

		console.log(' in setOptionText, isBig: ', isBig);

		let opItemArr = this.optionTextBgArr;
		if (isBig) {
			opItemArr = this.optionTextBgBigArr
		}

		this.curOptionArr = [];
		const disW = 315 * this._mapScaleMin;
		const disH = 120 * this._mapScaleMin;
		const baseX = - disW ;
		let baseY = -235 * this._mapScaleMin;
		if (options.length > 2) {
			baseY = -170 * this._mapScaleMin;
		}
		let count = 0;
		for (let i=0; i<options.length; i++) {

			if ( i == 2 ) {
				baseY -= disH;
				count = 0;
			}
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + count * disW * 2;
				opItemArr[i].y = baseY;
			}
		
			const data = options[i];

			opItemArr[i].label.string = data.text;
			opItemArr[i].label["_forceUpdateRenderData"](true);
			if (opItemArr[i].label.node.width > opItemArr[i].width * 0.9) {
				opItemArr[i].label.node.scale = opItemArr[i].width * 0.9 / opItemArr[i].label.node.width;
			} else {
				opItemArr[i].label.node.scale = 1;
			}
			

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);

			count++;
		}
	},



	shakeArr: null,
	wrongArr: null,
	checkBtnClick() {

		this.shakeArr = [];
		this.wrongArr = [];
		this.checkItemWrong();

		if (this.wrongArr.length > 0) {
			//有选错的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		const isRightAll = this.checkItemRightCount();
		if (!isRightAll) {
			// 有漏选的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		this.showAllRight();
		this.showMask();

		playAudio(this.rightClip, () => {
			this.playAnswerAudio(0);
		})
		
	},

	playAnswerAudio(index) {
		const arr = this.curOptionArr;
		if (!arr[index]) {

			// delayCall(0.5, () => {
				this.changeNextQuestion();
			// })

		} else {
			if ( arr[index].light.opacity > 254 && arr[index].audioClip ) {
				playAudio(arr[index].audioClip, () => {
					this.playAnswerAudio(index + 1);
				})
			} else {
				this.playAnswerAudio(index + 1);
			}
		}
	},


	checkItemWrong() {
		const arr = this.curOptionArr;
		console.log('arr: ', arr);
		for (let i=0; i<arr.length; i++) {
			const itemBg = arr[i];
			if (itemBg.light.opacity >= 254) {
				this.shakeArr.push(itemBg);
				console.log('aaa', itemBg.data);;
				if (itemBg.data.answerRight == '0') {
					this.wrongArr.push(itemBg);
				}
			}
		}
	},

	checkItemRightCount() {
		let rightTotalCount = 0;
		const answerArr = this.curQuestionData.answerArr;
		for (let i=0; i<answerArr.length; i++) {
			if (answerArr[i].answerRight == '1') {
				rightTotalCount ++;
			}
		}

		let curRightCount = 0;
		const curOptionArr = this.curOptionArr;
		for (let i=0; i<curOptionArr.length; i++) {
			if (curOptionArr[i].light.opacity > 254) {
				curRightCount ++;
			}
		}

		return rightTotalCount == curRightCount;
	},

	itemShake() {
		let rate = 1;
		if (this.curQuestionData.answerType == 'text') {
			rate = 0.5;
		}

		const arr = this.shakeArr;
		for (let i=0; i<arr.length; i++) {
			this.rotateShake(arr[i], rate);
			if (arr[i].stopAnim) {
				arr[i].stopAnim();
			}
		}

		this.showTryAgain();
	},

	hideLight() {
		const arr = this.curOptionArr;
		for (let i=0; i<arr.length; i++) {
			arr[i].light.opacity = 0;
		}
		this.checkBtn.opacity = 0;
	},

	rotateShake(item, rate = 1) {

		const time = 0.9;
		cc.tween(item)
			.to(time / 6 / 2, {angle: -20 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 12 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: -7 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 4 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: -2 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 1 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 0 * rate}, {easing: 'sineInOut'})
			.start();

	},

	showAllRight() {
		const curOptionArr = this.curOptionArr;
		for (let i=0; i<curOptionArr.length; i++) {
			if (curOptionArr[i].light.opacity > 254) {
				this.addIconRight(curOptionArr[i]);
			}
		}
	},

	changeNextQuestion() {
		console.log(' in changeNextQuestion')

		this.curQuestionIndex ++ ;
		this.setCurQuestionData();

		if (!this.curQuestionData) {
			// this.gameEnd();
			return;
		}

		this.showChangeQuesAnim();
	
	},

	showChangeQuesAnim() {
		this.hideLight();

		this.hideCurOptionAnim(() => {
			this.setCurOption();
			this.showCurOptionAnim();
			this.hideMask();
		});

		this.hideCurQuestion(() => {
			this.setCurQuestion();
			this.showCurQuestionAnim();
		});
	},


	maskLayer: null,
	initMask() {
		const maskLayer = new cc.Node();
		maskLayer.width = this.canvas.width;
		maskLayer.height = this.canvas.height;
		this.canvas.addChild(maskLayer, 20);

		maskLayer.addComponent(cc.BlockInputEvents);
		this.maskLayer = maskLayer;
		this.maskLayer.active = false;
	},

	showMask() {
		this.maskLayer.active = true;
	},

	hideMask() {
		this.maskLayer.active = false;
	},

	hideCurOptionAnim(cb) {
		const arr = this.curOptionArr;
		const time = 0.5;
		for (let i=0; i<arr.length; i++) {
			if (arr[i].iconRight) {
				arr[i].iconRight.removeFromParent();
				arr[i].iconRight = null;
			}
			cc.tween(arr[i])
				.to(time, {opacity: 0}, {easing: "cubicOut"})
				.call(() => {
					arr[i].active = false;
				})
				.start();
		}
		delayCall(time, () => {
			cb();
		})
	},

	showCurOptionAnim(cb=null) {
		const arr = this.curOptionArr;
		const time = 0.5;
		for (let i=0; i<arr.length; i++) {
			arr[i].opacity = 0;
			cc.tween(arr[i])
				.to(time, {opacity: 255}, {easing: "cubicIn"})
				.start();
		}

		if (cb) {
			delayCall(time, () => {
				cb();
			})
		}
	
	},

	hideCurQuestion(cb) {
		const time = 0.5;
		cc.tween(this.curQuesBg)
			.to(time, {opacity: 0}, {easing: "cubicOut"})
			.call(() => {
				this.curQuesBg.active = false;
				cb();
			})
			.start();
	},

	showCurQuestionAnim() {

		this.curQuesBg.active = true;
		this.curQuesBg.opacity = 0;

		const time = 0.5;
		cc.tween(this.curQuesBg)
			.to(time, {opacity: 255}, {easing: "cubicIn"})
			.start();
	},


	changeStep() {

		this.typeArrIndex ++;
		this.curCatAudioUrl = this.data.idle_2_audio_url;
		
		if (!this.data.change_step_audio_url) {
			this.startTesting();
			return;
		}
		playAudioByUrl(this.data.change_step_audio_url, () => {
			this.startTesting();
		})

	},

	gameEnd() {
		console.log('game end !')

		this.isGameEnd = true;
		this.endTesting();


		if (this.typeArrIndex < this.typeArr.length - 1) {

			this.changeStep();

			return;
		}





		// this.showRestart();
		// this.showGoodjob();
		// this.showOneFirework(cc.v2(0, -this.canvas.height / 2), this.canvas, cc.find('paperBase').children, this.canvas.width / 2.5, this.canvas.height * 2, 100, 1);
		playAudio(this.finishClip);

		if (!this.data.finish_right_audio_url) {
			const endData = this.getEndData();
			onHomeworkFinish(endData);
		}
		
		playAudioByUrl(this.data.finish_right_audio_url, () => {
			const endData = this.getEndData();
			onHomeworkFinish(endData);
		})

	

		const camera = cc.find('Canvas/Main Camera');
		camera.zIndex = 100;

		showTrebleFirework(camera, cc.find('RibbonNodeBase').children);


	

	},

	getEndData() {

		return {};

		const arr = this.picNodeArr;
		const customData = [];
		let stone = 0;
		const oneQuesStone = 10 / arr.length;
		arr.forEach(node => {
			customData.push({isRight: node.isRight})
			if (node.isRight) {
				stone += oneQuesStone;
			}
		})
		stone = Math.round(stone * 10) / 10;
		return {customData, stone};
	},

	showGoodjob() {

		const icon = getSprNode("goodjob");
		icon.scale = this._mapScaleMin;
		icon.baseS = icon.scale;
		this.canvas.addChild(icon, 20);


		const time = 1;
		icon.scale = 0;
		cc.tween(icon)
			.to(0.8,  {scale: icon.baseS}, {easing: "elasticOut"})
			.delay(1)
			.to(0.5, {scale: 0} , {easing: "cubicIn"})

			.start();



	},

	showRestart() {

		const btn = getSprNode("btn_restart");
		btn.scale = this._mapScaleMin;
		btn.baseS = btn.scale;
		this.canvas.addChild(btn, 21);

		btn.on(cc.Node.EventType.TOUCH_START, () => {
			// btn.removeFromParent();
			// this.initData();
			// this.initStar();
			// this.showChangeQuesAnim();
			// playAudio(this.btnClip);

			const middleLayer = cc.find('middleLayer');
			if (middleLayer) {
				middleLayer.getComponent('middleLayer').reloadBundle();
			}
		})

		const time = 0.9;
		btn.scale = 0;
		cc.tween(btn)
			.delay(2.5)
			.to(time,  {scale: btn.baseS}, {easing: "elasticOut"})
			.start();

	},



	async showOneFirework(pos, parentNode, nodeList, w, h, n, timeRate=1) {

		for (let i = 0; i < 3; i++) {
				this.showFirework(pos, parentNode, nodeList, w, h, n, timeRate);
				await asyncDelay(0.1);
		}
	},

	showFirework(pos, parentNode, nodeList, width = 200, height = 500, number = 30, timeRate=1) {
			const subTime = 1;
			for (let i = 0; i < number; i++) {
					const quad = this.createQuads(pos, parentNode, nodeList);
					const targetX = RandomInt(width / 2, -width / 2);
					const targetY = RandomInt(height);

					cc.tween(quad)
							.by(0.5 * timeRate, { x: targetX })
							.by((2 + subTime *  Math.random()) * timeRate, { x: targetX * 2 })
							.start();

					cc.tween(quad)
							.by(0.5 * timeRate, { y: targetY }, { easing: 'quadOut' })
							.to((3 + subTime * Math.random()) * timeRate, { y: -parentNode.height * 2 }, { easing: 'quadIn' })
							.removeSelf()
							.start();

					cc.tween(quad)
							.delay(1  * timeRate)
							.to((0.5 + subTime * Math.random()) * timeRate , { opacity: 0 })
							.start();
			}
	},

	createQuads(pos, parentNode, nodeList) {
			const quadBase = cc.instantiate(nodeList[RandomInt(nodeList.length)]);

			quadBase.x = pos.x;
			quadBase.y = pos.y;
			quadBase.z = pos.z;
			quadBase.angle = RandomInt(180);
			quadBase.parent = parentNode;

			const quad = quadBase.getChildByName('quad');
			quad.x = 0;
			quad.y = 0;
			quad.angle = RandomInt(180);

			const paper = quad.getChildByName('paper');
			paper.scaleX = Math.random() * 0.8 + 0.2;
			paper.scaleY = Math.random() * 0.8 + 0.2;

			quadBase.scaleX = Math.random();
			cc.tween(quadBase)
					.to((1 - quadBase.scaleX) * 0.3, { scaleX: 1 })
					.call(() => {
							const time = Math.random() * 0.2;
							cc.tween(quadBase)
									.to(0.1 + time, { scaleX: -1 })
									.to(0.1 + time, { scaleX: 1 })
									.union()
									.repeatForever()
									.start();
					})
					.start();


			return quadBase;
	},


















	restart() {
		
	},


	initTitle() {

		const offX = 96;
		const offY = 11;
		const title = getSprNode('title_bg');
		title.parent = this.canvas;
		title.scale = this._mapScaleMin;
		title.zIndex = 10;

		title.x = -this.canvas.width / 2 + title.width / 2 * title.scale + offX;
		title.y = this.canvas.height / 2 - title.height / 2 * title.scale - offY;

		// console.log('this.data: ', this.data);

		title.addComponent(cc.Button)
		title.on('click', () => {
			if (this.data.title_audio_url) {
				playAudioByUrl(this.data.title_audio_url);
			}
		})

		const labelNode = new cc.Node();
		labelNode.parent = title;
		const label = labelNode.addComponent(cc.RichText);
		const size = 42
		label.font = cc.find('Canvas/res/font/aharoni').getComponent(cc.Label).font;
		label.string = `<outline color=#a83c13 width=2><size=${size}><color=#ffffff>${this.data.title || " " }</color></size></outline>`
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.LEFT
		labelNode.anchorX = 0;
		labelNode.anchorY = 1
		labelNode.x = -title.width / 2 + 90;

		const maxLen = 305;
		if (labelNode.width > maxLen) {
			labelNode.scale = maxLen / labelNode.width;
		}

		labelNode.y = labelNode.height / 2 * labelNode.scale + 15;

	},


	initBg() {
		
		console.log("this.data.bg_pic_url: ", this.data.bg_pic_url);

		const bg = getSprNode('bg');
		const scaleX =  this.canvas.width / bg.width
		const scaleY = this.canvas.height / bg.height 
		const scale = Math.max(scaleX, scaleY);
		bg.scale = scale;
		this.canvas.addChild(bg);
	},
	


	initHotZone() {
		this.initHotZoneBg();
	},


	hotZoneBg: null,
	initHotZoneBg() {
		this.hotZoneBg = new cc.Node();
		this.hotZoneBg.name = 'hotZoneBg';
		this.hotZoneBg.parent = cc.find('Canvas');
		this.hotZoneBg.zIndex = 4;

		if (!this.data.bgItem) {
			return;
		}

		cc.loader.load({url: this.data.bgItem.url}, (err, img) => {

			// this.addMask(this.hotZoneBg);

			this.hotZoneBg.width = img.width;
			this.hotZoneBg.height = img.height;


			const sprNode = new cc.Node();
			sprNode.name = 'bgItemSpr'
			var sf = new cc.SpriteFrame(img);
			// const spr = this.hotZoneBg.addComponent(cc.Sprite);
			const spr = sprNode.addComponent(cc.Sprite);
			spr.spriteFrame = sf
			sprNode.width = this.hotZoneBg.width;
			sprNode.height = this.hotZoneBg.height;
			sprNode.parent = this.hotZoneBg;
			window['bg'] =sprNode 


			// const sx = this.canvas.width / this.hotZoneBg.width;
			// const sy = (this.canvas.height) / this.hotZoneBg.height;
			// const s = Math.min(sx, sy);
			// this.hotZoneBg.scale = s;


			const panel = getSprNode('panel');
			panel.scale = this._mapScaleMin * 1.5;
			this.canvas.addChild(panel);
			panel.x = -this.canvas.width;



			const parent = panel;
			const sx = parent.width / this.hotZoneBg.width;
			const sy = parent.height / this.hotZoneBg.height;
			const s = Math.min(sx, sy);

			this.hotZoneBg.scale = s * 0.9;
			this.hotZoneBg.parent = panel;

			// this.data.bgItem.isShowDebugLine = true;
			this.initHotZoneItem();


			if (this.colorRectArr.length > 0) {
				this.resetHotZoneBg();
			}

			cc.tween(panel)
			.to(1, {x: 0}, {easing: 'cubicOut'})
			.call(() => {
				this.hzLoadEnd = true;
				this.checkStart();
			})
			.start();
			
		});

	},

	initHotZoneItem() {

		this.picNodeArr = [];

		this.data.hotZoneItemArr.forEach((item) => {
			console.log('item.gIdx: ', item.gIdx);
			switch (item.gIdx) {

				case "0":
					this.setOneLinkRect(item);

					break;

				case "1":
					this.setOneWriteAnima(item);
					break;

				case "2":
					this.setOneCircleAnima(item);
					break;

				case "3":
					this.setOneAudioBtn(item);
					break;

				case "4":
					this.setOneSignAnima(item);
					break;

				case "5":
					this.setOneColorPic(item);
					break;

				case "6":
					this.setOnePicAnima(item);
					break;

				// case "0":
				// 	this.setOneHotZonePic(item);
				// 	break;
						
				default:
					break;
			}

		});

	},

	setOneLinkRect(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		// rectNode.scale = 1 / data.mapScale;

		rectNode.anchorX = rectNode.anchorY = 0;


		if (this.data.isDebug) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();

		rectNode.data = data;

		console.log(" data is ~~~ : ", data);

		this.rectNodeArr.push(rectNode)


		const debugItemId = data.pointItem;
		const debugItemData = this.data.hotZoneItemArr2[Number(debugItemId) - 1];
		rectNode.isRightPoint = debugItemData.checkbox.list[0].value == true;

		console.log('debugItemData.checkbox.list[0].value: ', debugItemData.checkbox.list[0].value);

	},


	addMask(node) {
		const mask = node.addComponent(cc.Mask);
		mask.type = cc.Mask.Type.RECT;
	},


	setOneDragAction(data) {

		const rate =  (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY ;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		const {x, y, width, height} = rectNode;
		// rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(-rectNode.width / 2, -rectNode.height / 2, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();
		rectNode.x += rectNode.width / 2;
		rectNode.y += rectNode.height / 2;

		rectNode.baseX = rectNode.x;
		rectNode.baseY = rectNode.y;
		rectNode.targetOff();

		rectNode.on(cc.Node.EventType.TOUCH_START, () => {

			if (rectNode.isDragEnd) {
				if (rectNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
				}
				return;
			}
			this._curShowItem = rectNode;
		})
		

		const realRate = this.hotZoneBg.width / this.data.bgItem.rect.width;
		rectNode.targetPx = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
		rectNode.targetPy = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				rectNode.audioClip = audioClip;
			});
		}



		console.log('setOneAction ~~ data: ', data)
		const actionData = data['actionData_' + data.gIdx];
		if (!actionData) {
			return;
		}
		if (actionData.type == 'text') {
			const label = this.setOneActionText(rectNode, actionData);
			label.node.scale = scale * data.fontScale;

			label.node.targetOff();
		
	

			// label.overflow = cc.Label.Overflow.NONE;
			// label.node.setContentSize(new cc.Size(0, lineHeight));
			label["_forceUpdateRenderData"](true);
		
			
		} else if (actionData.type == 'pic') {

			const pic = this.setOneActionPic(rectNode, actionData);

		} else if (actionData.type == 'anima') {

			const anima = this.setOneActionAnima(rectNode, actionData);
		}
	},



	setOneAction(data) {

		const rate =  (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY ;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		const {x, y, width, height} = rectNode;
		rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();



		console.log('setOneAction ~~ data: ', data)
		const actionData = data['actionData_' + data.gIdx];
		if (!actionData) {
			return;
		}
		if (actionData.type == 'text') {
			const label = this.setOneActionText(rectNode, actionData);
			label.node.scale = scale * data.fontScale;

			// label.overflow = cc.Label.Overflow.NONE;
			// label.node.setContentSize(new cc.Size(0, lineHeight));
			label["_forceUpdateRenderData"](true);
		
			
		} else if (actionData.type == 'pic') {

			const pic = this.setOneActionPic(rectNode, actionData);

		} else if (actionData.type == 'anima') {

			const anima = this.setOneActionAnima(rectNode, actionData);
		}
	},

	setOneActionText(rectNode, actionData) {


		const labelNode = new cc.Node();
		labelNode.parent = rectNode;
		const label = labelNode.addComponent(cc.Label);

		label.font = cc.find('Canvas/res/font/ahronbd-1').getComponent(cc.Label).font;
		label.string = actionData.text;
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		// label.lineHeight = size;
		// label.horizontalAlign = cc.macro.TextAlignment.LEFT
		// labelNode.anchorX = 0;
		// labelNode.anchorY = 1
		labelNode.color = cc.Color.BLACK;


		const opArr = actionData.changeOption
		// console.log('opArr', opArr);


		const tweenArr = [];

		for (let i = 0; i < opArr.length; i++ ) {

			const opData = opArr[i];
			console.log('opArr[0]', opArr[i])
			if (opData[0] == 'fontColor') {
				const color = new cc.Color();
				cc.Color.fromHEX(color, opData[1] );
				labelNode.color = color;

			} else if (opData[0] == 'opacity') {
				// console.log('opData: ', opData)
				labelNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
				// console.log(labelNode.opacity);
				tweenArr.push({item: labelNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[0]},)

			} else {
				label[opData[0]] = opData[1];
				tweenArr.push({item: label, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[0]})

			}
		}


		// if (actionData.audio_url) {
		// 	cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
		// 		labelNode.audioClip = audioClip;
		// 	});
		// }


		label.lineHeight = label.fontSize;

		// labelNode.y += rectNode.height / 2;
		// labelNode.x += rectNode.width / 2;
		

		// rectNode.addComponent(cc.Button);
		// rectNode.on('click', () => {

		// 	if (labelNode.audioClip) {
		// 		cc.audioEngine.stopAllEffects();
		// 		cc.audioEngine.playEffect(labelNode.audioClip, false, 0.8);
		// 	}

		// 	if (labelNode.isClicked) {
		// 		// return;
		// 	}
		// 	labelNode.isClicked = true;

		// 	for (let i=0; i<tweenArr.length; i++) {
		// 		const tweenData = tweenArr[i];

		// 		if (tweenData.optionName == 'opacity') {
		// 			console.log('~~~ ',  tweenData.item[tweenData.optionName] );

		// 			cc.tween(tweenData.item)
		// 				.to(actionData.changeTime,  JSON.parse(tweenData.option) )
		// 				.start();
		// 		}
				

		// 	}

		// });


		return label;
	},

	setOneActionPic(rectNode, actionData) {

		console.log('setOneActionPic actionData: ', actionData)
		const picNode = new cc.Node();
		rectNode.addChild(picNode);

		cc.loader.load({url: actionData.pic_url}, (err, img) => {

			const spr = picNode.addComponent(cc.Sprite);
			spr.spriteFrame = new cc.SpriteFrame(img)

			picNode.y += rectNode.height / 2;
			picNode.x += rectNode.width / 2;

			picNode.scaleX = rectNode.width / picNode.width;
			picNode.scaleY = rectNode.height / picNode.height;

			const opArr = actionData.changeOption	
			const tweenArr = [];
	
			for (let i = 0; i < opArr.length; i++ ) {
	
				const opData = opArr[i];
				console.log('opData: ~~~ ', opData);

				if (opData[0] == 'opacity') {
					picNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
					console.log(picNode.opacity);
					tweenArr.push({item: picNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[0]},)
	
				}  else {
					// picNode[opData[0]] = Number(opData[1]);
					// tweenArr.push({item: picNode, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[0]})
				}

	
				if (actionData.audio_url) {
					cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
						rectNode.audioClip = audioClip;
					});
				}
				

				rectNode.addComponent(cc.Button);
				rectNode.on('click', () => {

					if (rectNode.audioClip) {
						cc.audioEngine.stopAllEffects();
						cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
					}
		
					if (rectNode.isClicked) {
						// return;
					}
					rectNode.isClicked = true;

					for (let i=0; i<tweenArr.length; i++) {
						const tweenData = tweenArr[i];
		
						if (tweenData.optionName == 'opacity') {
							cc.tween(tweenData.item)
								.to(actionData.changeTime,  JSON.parse(tweenData.option) )
								.start();
						}
					}
		
				});
			}

		});
	},

	setOneActionAnima(rectNode, actionData) {


		const animaNode = new cc.Node();
		rectNode.addChild(animaNode);

		if (actionData.audio_url) {
			cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
				rectNode.audioClip = audioClip;
			});
		}

		const data = actionData;

		const dragonDisplay = animaNode.addComponent(dragonBones.ArmatureDisplay);
		if (!data.texPngData) {
			return
		}



		const image = data.texPngData.url//"http://staging-teach.cdn.ireadabc.com/5a0c5af3e952acd0ac83a6e5c6f03ff1.png";
		const ske = data.skeJsonData.url//"http://staging-teach.cdn.ireadabc.com/bd825dcceea298d1146be8067ae3d17f.json";
		const atlas = data.texJsonData.url//"http://staging-teach.cdn.ireadabc.com/246f8991b729fa3e5a7f4802de828efa.json";
		cc.loader.load(image, (error, texture) => {

			cc.loader.load({url: atlas, type: 'txt'}, (error, atlasJson) => {

				cc.loader.load({url: ske, type: 'txt'}, (error, dragonBonesJson) => {

					const atlas = new dragonBones.DragonBonesAtlasAsset();
					atlas.atlasJson = atlasJson;
					atlas.texture = texture;

					const asset = new dragonBones.DragonBonesAsset();
					asset.dragonBonesJson = dragonBonesJson;

					dragonDisplay.dragonAtlasAsset = atlas;
					dragonDisplay.dragonAsset = asset;


					let json = JSON.parse(asset.dragonBonesJson);
					let armatures = json["armature"];
					let armatureNames = [];
					for (let i = 0; i < armatures.length; i++) {
						armatureNames.push(armatures[i].name);
					}
					// console.log('armatureNames: ', armatureNames);

					let animationNames = [];

					if (armatureNames.length > 0) {
						let defaultArmatureName = armatureNames[0];
						dragonDisplay.armatureName = defaultArmatureName;
						// let animationNames = dragonDisplay.getAnimationNames(defaultArmatureName);
						let defaultArmature = armatures[0];
						let animations = defaultArmature.animation;
						for (let i = 0; i < animations.length; i++) {
							animationNames.push(animations[i].name);
						}

						// rectNode.addComponent(cc.Button);
						// rectNode.on('click', () => {
						// 	if (rectNode.isClicked) {
						// 		// return;
						// 	}
						// 	rectNode.isClicked = true;
						// 	console.log('clicked');

						// 	if (rectNode.audioClip) {
						// 		cc.audioEngine.stopAllEffects();
						// 		cc.director.emit('STOP_ALL_AUDIO')
						// 		cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
						// 	}

						// 	if (animationNames.length > 0) {
						// 		dragonDisplay.playAnimation(animationNames[0], 1);
						// 	}
						// });
					}


					// animaNode.x = rectNode.x + rectNode.width / 2;
					// animaNode.y = rectNode.y + rectNode.height / 2;

					// const sx = rectNode.width / animaNode.width;
					// const sy = rectNode.height / animaNode.height;
					// const scale = Math.min(sx, sy);
					// animaNode.scale = scale;
					


			


					animaNode.y += rectNode.height / 2;
					animaNode.x += rectNode.width / 2;

					animaNode.scaleX = rectNode.width / animaNode.width;
					animaNode.scaleY = rectNode.height / animaNode.height;
		
					const opArr = actionData.changeOption	
					const tweenArr = [];
			
					for (let i = 0; i < opArr.length; i++ ) {
			
						const opData = opArr[i];
						console.log('opData: ~~~ ', opData);
		
						if (opData[0] == 'opacity') {
							animaNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
							console.log(animaNode.opacity);
							tweenArr.push({item: animaNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[2] == null ? '' : opData[0]},)
			
						}  else {
							// animaNode[opData[0]] = Number(opData[1]);
							// tweenArr.push({item: animaNode, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[2] == null ? '' : opData[0]})
						}
		
			
						if (actionData.audio_url) {
							cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
								rectNode.audioClip = audioClip;
							});
						}
						
		
						rectNode.addComponent(cc.Button);
						rectNode.on('click', () => {
		
							if (rectNode.audioClip) {
								cc.audioEngine.stopAllEffects();
								cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
							}
				
							if (rectNode.isClicked) {
								// return;
							}
							rectNode.isClicked = true;
		
							for (let j=0; j<tweenArr.length; j++) {
								const tweenData = tweenArr[j];
				
								console.log('tweenData: ', tweenData);

								if (tweenData.optionName) {

									cc.tween(tweenData.item)
										.to(actionData.changeTime,  JSON.parse(tweenData.option))
										.start();

								}

							}
						
							if (animationNames.length > 0) {
								dragonDisplay.playAnimation(animationNames[0], 1);
							}
				
						});
					}
		
					
				});
			});
		});

	},
	

	setOneWriteAnima(data) {

		const animaNode = this.setOneAnimaSmall(data);

		const letterH = 125;
		const rectNode = animaNode.rectNode;
		const sy = rectNode.height / letterH
		animaNode.scale = sy

		this.animaNodeArr.push(animaNode);

	},


	setOneCircleAnima(data) {



		const animaNode = this.setOneAnimaSmall(data);
		const circle = this.getCircleNode(animaNode);
		animaNode.ctxCircle = circle;

		// this.showCircle2(animaNode);

		this.circleAnimaNodeArr.push(animaNode);
	},

	showCircle2(animaNode) {
		const ctxCircle = animaNode.ctxCircle;

		let a = 0;

		const showColorAnim = () => {

			a ++;
			const color = cc.Color.BLACK;
			color.a = a;

			ctxCircle.strokeColor = color
			ctxCircle.stroke();

			if (a < 10 && !this.isDestroy) {
				delayCall(0.1, () => {
					showColorAnim();
				})
			}
		
		}
	
		showColorAnim();
		
		playAudio(this.rightClip, () => {
			
		})
	},


	setOneColorPic(data) {

		// const picNode = this.setOnePic(data);
		// picNode.data = data;
		// this.colorPicNodeArr.push(picNode);

		const animaNode = this.setOneAnimaSmall(data);
		this.colorPicNodeArr.push(animaNode);

	},

	setOnePicAnima(data) {
		const picNode = this.setOnePic(data);
		// picNode.active = false;
		picNode.opacity = 0;


		// picNode.on("touchstart", () => {
		// 	this.showLetterPic(picNode);
		// })

		picNode.data = data;
		this.picAnimNodeArr.push(picNode);

	},

	setOneSignAnima(data) {
		const animaNode = this.setOneAnimaSmall(data);

		const signW = 200;
		const signH = 200;
		const rectNode = animaNode.rectNode;
		const sx = rectNode.width / signW;
		const sy = rectNode.height / signH;
		const minS = Math.min(sx, sy);
		animaNode.scale = minS;

		this.signAnimaNodeArr.push(animaNode);
	},

	setOneAudioBtn(data) {

		const btn = this.getAudioSpr(data);
		btn.addComponent(cc.Button);
		btn.on("click", () => {

			if (!this.canTouch) {
				return;
			}
			if (data.audio_url) {

				cc.audioEngine.stopAllEffects();
				playAudioByUrl(data.audio_ur