import { data } from "./words";

export function checkAnswer(type, string, word) {
  console.log('word: ', word);
  switch (type) {
    case 'device':
    case 'side':
    case 'work':
    case 'adj':
      return WordData.getInstance().check(type, string);
    case 'name':
    case 'city':
      return checkCity(string);
    case 'time':
      return checkTime(string);
    case 'date':
      return checkDate(string);
    case 'word':
      return checkWord(string, word);
    case 'wordList':
      return checkWordInList(string, word);
    default:
      throw "错误的格式";
  }
}

function checkCity(string) {
  const bigCase = ('ABCDEFGHIJKLMNOPQRSTUVWXYZ').split('');
  const smallCase = ('abcdefghijklmnopqrstuvwxyz').split('');
  const right = string.split(' ')
    .filter(word => word != '')
    .every(word => {
      return word.split('')
        .every((letter, idx) => {
          if (idx == 0) {
            return bigCase.includes(letter)
              && !smallCase.includes(letter);
          } else {
            return !bigCase.includes(letter)
              && smallCase.includes(letter);
          }
        });
    });

  return {
    right: right,
    info: '专有名词首字母应该大写。',
  }
}

function checkTime(string) {
  const rightResult = {
    right: true,
    info: '',
  }
  const wrongResult = {
    right: false,
    info: 'time格式填写错误。正确格式为“时 分”, 例如：ten thirty',
  };
  if (string.includes(":")) {
    const words = string.split(":");
    if (words.length != 2) {
      return wrongResult;
    }

    if (words.some(word => word.length > 2)) {
      return wrongResult;
    }

    const hour = parseInt(words[0]);
    const minute = parseInt(words[1]);
    if (hour < 0 || 12 < hour) {
      return wrongResult;
    }
    if (minute < 0 || 59 < minute) {
      return wrongResult;
    }
    return rightResult;
  }

  const hours = [
    "one", "two", "three", "four", "five", "six",
    "seven", "eight", "nine", "ten", "eleven", "twelve"
  ];

  const minutes = [
    "o'clock", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten",
    "eleven", "twelve", "thirteen", "fourteen", "fifteen", "a quarter", "sixteen", "seventeen", "eighteen", "nineteen", "twenty",
    "twenty-one", "twenty-two", "twenty-three", "twenty-four", "twenty-five", "twenty-six", "twenty-seven", "twenty-eight", "twenty-nine", "thirty", "half",
    "thirty-one", "thirty-two", "thirty-three", "thirty-four", "thirty-five", "thirty-six", "thirty-seven", "thirty-eight", "thirty-nine", "forty",
    "forty-one", "forty-two", "forty-three", "forty-four", "forty-five", "three quarter", "forty-six", "forty-seven", "forty-eight", "forty-nine", "fifty",
    "fifty-one", "fifty-two", "fifty-three", "fifty-four", "fifty-five", "fifty-six", "fifty-seven", "fifty-eight", "fifty-nine",
  ];

  const middles = [
    'to',
    'past'
  ];

  const middleWord = middles.find(word => string.includes(word));
  if (middleWord) {
    const strings = string.split(middleWord);
    if (minutes.some(word => strings[0].trim().toLowerCase() == word)) {
      if (hours.some(word => strings[1].trim().toLowerCase() == word)) {
        return rightResult;
      }
    }
    return wrongResult;
  }

  const strings = string.split(' ');
  if (hours.some(word => strings[0].trim().toLowerCase() == word)) {
    if (minutes.some(word => strings[1].trim().toLowerCase() == word)) {
      return rightResult;
    }
  }
  return wrongResult;
}

function checkDate(string: string) {
  const wrongResult = {
    right: false,
    info: 'date格式填写错误。正确格式为“日 月 年”, 例如：15th August 2008',
  };
  const rightResult = {
    right: true,
    info: '',
  }

  let numberList = [];

  if (string.includes('.')) {
    numberList = string.split('.').map(string => parseInt(string));
  } else {
    const days1 = [
      'none',
      'First', 'second', 'third', 'fourth',
      'fifth', 'sixth', 'seventh', 'eighth',
      'ninth', 'tenth', 'eleventh', 'twelfth',
      'thirteenth', 'fourteenth', 'fifteenth', 'sixteenth',
      'seventeenth', 'eighteenth', 'nineteenth', 'Twentieth',
      'twenty-first', 'twenty-second', 'Twenty-third', 'twenty-fourth',
      'Twenty-fifth', 'Twenty-sixth', 'twenty-seventh', 'Twenty-eighth',
      'twenty-ninth', 'Thirtieth', 'Thirty-first'
    ];
    const days2 = [
      'none',
      '1st', '2nd', '3rd', '4th',
      '5th', '6th', '7th', '8th',
      '9th', '10th', '11th', '12th',
      '13th', '14th', '15th', '16th',
      '17th', '18th', '19th', '20th',
      '21st', '22nd', '23rd', '24th',
      '25th', '26th', '27th', '28th',
      '29th', '30th', '31st'
    ]
    const months = [
      'none',
      'January', 'February', 'March', 'April',
      'May', 'June', 'July', 'August',
      'September', 'October', 'November', 'December'
    ];
    let yearFlg = false;
    let monthFlg = false;
    let dayFlg = false;
    numberList = string.split(' ').map(string => {
      if (!monthFlg) {
        const month = months.findIndex(str => str == string);
        if (month >= 1) {
          monthFlg = true;
          return month;
        }
      }
      if (!dayFlg) {
        let day = days1.findIndex(str => str == string);
        if (day >= 1) {
          dayFlg = true;
          return day;
        }
        day = days2.findIndex(str => str == string);
        if (day >= 1) {
          dayFlg = true;
          return day;
        }
      }
      if (!yearFlg) {
        const year: number = parseInt(string);
        if (!isNaN(year)) {
          yearFlg = true;
          return year;
        }
      }
    });
  }

  console.log('numberList = ' + JSON.stringify(numberList));

  if (numberList.length < 2 || 3 < numberList.length) {
    return wrongResult;
  }

  if (numberList.some(num => !num)) {
    // 有null或者undefind
    return wrongResult;
  }

  if (numberList.some(num => num <= 0)) {
    // 负数
    return wrongResult;
  }

  let rightFlg = true;
  let yearFlg = false;
  let monthFlg = false;
  let dayFlg = false;
  numberList.forEach((number, idx) => {
    if (number > 31) {
      if (!yearFlg) {
        if (idx == 1) {
          rightFlg = false;
        } else {
          yearFlg = true;
        }
      } else {
        rightFlg = false;
      }
    } else if (number > 12) {
      if (!dayFlg) {
        dayFlg = true;
      } else {
        rightFlg = false;
      }
    } else {
      if (!monthFlg) {
        monthFlg = true;
      } else if (!dayFlg) {
        dayFlg = true;
      } else {
        rightFlg = false;
      }
    }
  });

  if (!monthFlg || !dayFlg) {
    rightFlg = false;
  }

  if (rightFlg) {
    return rightResult;
  }

  return wrongResult;
}

function checkWord(string: string, word: string) {
  if (string.trim() != word.replace(/_/g, " ").trim()) {
    return { right: false, info: word.replace(/_/g, " ").trim() };
  }
  return { right: true, info: '' };
}

function checkWordInList(string: any, word: any) {
  const wordList: Array<string> = word;
  if (wordList.includes(string)) {
    return {
      right: wordList.includes(string),
      info: '错误的单词。'
    };
  } else {
    return {
      right: false,
      info: '错误的单词。'
    }
  }
}

export class WordData {

  static _instance = null;
  static getInstance(): WordData {
    if (!WordData._instance) {
      WordData._instance = new WordData();
    }
    return WordData._instance;
  }

  constructor() {
    this.device = data.device;
    this.side = data.side;
    this.work = data.work;
    this.adj = data.adj;
  }

  device = ['TV', 'heater'];
  side = ['north'];
  work = ['teacher', 'worker'];
  adj = ['big', 'small'];

  check(type: any, string: any) {
    const wrongString = {
      device: '电器名错误。',
      side: '方向名词错误。',
      work: '工作名错误。',
      adj: '形容词错误。',
    }
    return {
      right: this[type].includes(string.trim()),
      info: wrongString[type],
    };
  }
}

