// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

// import { getSprNode } from "./util";
import { getSprNode, playAudioByUrl, showBtnAnima, getScaleRateBy2Node, localPosTolocalPos, randomSortByArr, loadDragonBones, playAudio, showTrebleFirework, getSprNodeByUrl, setSprNodeMaxLen, delayCall, asyncDelay, RandomInt, exchangeNodePos, onHomeworkFinish} from "../script/OP72_util";

cc.Class({
	extends: cc.Component,

	properties: {
		baseWidth: {
			default: 1920,
			type: cc.Integer
		},
		baseHeight: {
			default: 1200,
			type: cc.Integer
		}
	},

	onLoad() {
		cc.debug.setDisplayStats(false);
		this.initSceneData();
		this.initSize();
	},

	initSceneData() {
		this._imageResList = [];
		this._audioResList = [];
		this._animaResList = [];
	},


	_designSize: null,
	_frameSize: null,
	_mapScaleMin: null,
	_mapScaleMax: null,
	_cocosScale: null,
	canvas: null,
	initSize() {


		// 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
		let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
		let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
		let f = screen_size >= design_size
		cc.Canvas.instance.fitHeight = f
		cc.Canvas.instance.fitWidth = !f

		const frameSize = cc.view.getFrameSize();
		this._frameSize = frameSize;

		this._designSize = cc.view.getDesignResolutionSize();

		let sx = cc.winSize.width / frameSize.width;
		let sy = cc.winSize.height / frameSize.height;
		this._cocosScale = Math.min(sx, sy);

		sx = frameSize.width / this._designSize.width;
		sy = frameSize.height / this._designSize.height;
		this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
		this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;

		this.canvas = cc.find('Canvas');


		// cc.log('cc.Canvas: ', cc.Canvas);
	},

	start() {

		console.log(' in start 1 ');

		let getData = this.getData.bind(this);
		if (window && window.courseware) {
			getData = window.courseware.getData;

			console.log(' in start 2 ');

		}
		getData((data) => {
			console.log('data:', data);
			this.data = data || this.getDefaultData();
			this.preloadItem()
		})
	},

	_imageResList: null,
	_audioResList: null,
	_animaResList: null,
	preloadItem() {
		this.addPreloadImage();
		this.addPreloadAudio();
		this.addPreloadAnima();
		this.preload();
	},


	getData(func) {
		if (window && window.courseware) {
			window.courseware.getData(func, 'dfzx_cocos_dqq');
			return;
		}
		
		const middleLayer = cc.find('middleLayer');
		if (middleLayer) {
			const middleLayerComponent = middleLayer.getComponent('middleLayer');
			middleLayerComponent.getData(func);
			return;
		}
		
		func(this.getDefaultData());
	},

	getDefaultData() {

		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/589f865ee20144c83295c42c330a9437.png","rect":{"x":182.65,"y":0,"width":979.7,"height":509}},"hotZoneItemArr":[{"id":"1672383817653","index":0,"pic_url":"http://staging-teach.cdn.ireadabc.com/71dd062e8ac876361a80facc8de90dce.png","itemType":"pic","fontScale":1.05078125,"imgScale":0.6963064295485636,"imgSizeW":1407,"imgSizeH":731,"mapScale":1.05078125,"dragDot":{"x":672.5,"y":254.5},"gIdx":"5","rect":{"x":0,"y":0,"width":979.7,"height":509},"drawItem":1},{"id":"1672383823303","index":1,"pic_url":"http://staging-teach.cdn.ireadabc.com/bf19928fa8dfad8a1c5e883f099f0184.png","itemType":"pic","fontScale":1.05078125,"imgScale":0.6963064295485636,"imgSizeW":1407,"imgSizeH":731,"mapScale":1.05078125,"dragDot":{"x":672.5,"y":254.5},"gIdx":"5","rect":{"x":0,"y":0,"width":979.7,"height":509},"drawItem":2},{"id":"1672383831136","index":2,"pic_url":"http://staging-teach.cdn.ireadabc.com/c95f715c0b478f34345d70cdb7dd9048.png","itemType":"pic","fontScale":1.05078125,"imgScale":0.6963064295485636,"imgSizeW":1407,"imgSizeH":731,"mapScale":1.05078125,"dragDot":{"x":672.5,"y":254.5},"gIdx":"5","rect":{"x":0,"y":0,"width":979.7,"height":509},"drawItem":3}],"typeArr":[{"gIdx":"5","name":"涂色"}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/589f865ee20144c83295c42c330a9437.png","rect":{"x":0,"y":344.11,"width":1345,"height":698.79}},"hotZoneItemArr2":[{"id":"1672383928963","index":0,"itemType":"rect","fontScale":1.05078125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.05078125,"dragDot":{"x":672.5,"y":693.5},"gIdx":"9","posX":248.5,"posY":671.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":200,"y":278.89,"width":97,"height":97}},{"id":"1672383940196","index":1,"itemType":"rect","fontScale":1.05078125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.05078125,"dragDot":{"x":672.5,"y":693.5},"gIdx":"9","posX":696.5,"posY":466.4908990760483,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":609,"y":101.89,"width":175,"height":40.98}},{"id":"1672384393835","index":2,"itemType":"rect","fontScale":1.05078125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.05078125,"dragDot":{"x":672.5,"y":693.5},"gIdx":"9","posX":814.5,"posY":810.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":773,"y":424.89,"width":83,"height":83}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1"}

		
		return {"write_big_0_audio_url":"http://teach.cdn.ireadabc.com/4cd906b89868b20cd4e3c2fc9848bac9.mp3","write_big_1_audio_url":"http://teach.cdn.ireadabc.com/4c5a39defde0e90f3a53bf50db6943f4.mp3","write_big_2_audio_url":"http://teach.cdn.ireadabc.com/53ba71d99f24bf8e78b68b0de658a0b6.mp3","write_small_0_audio_url":"http://teach.cdn.ireadabc.com/d099918c85ac7afc33f169c9038f46d4.mp3","write_small_1_audio_url":"http://teach.cdn.ireadabc.com/2f1ea180fb4d17dce34e8d7cc6cf9159.mp3","write_small_2_audio_url":"http://teach.cdn.ireadabc.com/763b51f3d318fc0447e13ff387d00660.mp3","finish_audio_url":"http://teach.cdn.ireadabc.com/7fb349c67a76d2112a0604e624acaa97.mp3","tip_audio_url":"http://teach.cdn.ireadabc.com/d5cdef3f02abe29b14ca8c16ad4e7543.mp3","letter":"B","animArr":[{"key":"letter_big_0","title":"大写彩色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/3741b9919c8ae9c020048e4eb1a7203d.json","name":"B大彩_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/95cf3f48a23cf811c20e77e557116392.json","name":"B大彩_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/1f1e837171567609ceb9ba1b78a3528c.png","name":"B大彩_tex.png"}},{"key":"letter_big_1","title":"大写黑色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/478486f6afc92495ee9165869a03b8a0.json","name":"B大黑_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/61035beb245a518cdc827930e3cee512.json","name":"B大黑_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/05c20f86a6750450cd00bf9a45fcbaa3.png","name":"B大黑_tex.png"}},{"key":"letter_small_0","title":"小写彩色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/691dc3ff5ef5ee86bd6ba8a85992c47a.json","name":"小b彩_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/72dc028c89a284f9994c74697c1c24cd.json","name":"小b彩_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/3aa9aa49d44935bebc0b881935d464b1.png","name":"小b彩_tex.png"}},{"key":"letter_small_1","title":"小写黑色动画","skeJsonData":{"url":"http://teach.cdn.ireadabc.com/d32405fafbe86b03c21d7d1f026ae0a1.json","name":"小b黑_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/c26da948585e6609a4d3f8eb590b9b78.json","name":"小b黑_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/980005c431cbdbd3e9e2188d6a13f579.png","name":"小b黑_tex.png"}}],"bg_pic_url":"http://teach.cdn.ireadabc.com/520b8785f6b253aef7ced8941711c1cf.png","dot_big_1_url":"http://teach.cdn.ireadabc.com/26b8a37d08cb332eacb3383e966a9d8c.png","dot_big_2_url":"http://teach.cdn.ireadabc.com/e80e0f8311cfce0faec44623057e10fd.png","dot_small_1_url":"http://teach.cdn.ireadabc.com/699666d2df22d79a7506e52a460b4bda.png","dot_small_2_url":"http://teach.cdn.ireadabc.com/92bb0fbeace4a5611d9aab1cd92a972c.png","page_id":"7","book_id":"Oxford_Phonics_World_1_SB","part_name":"c","bgItem2":{"url":"http://teach.cdn.ireadabc.com/a7a5c15622c72b46f13224112b75219f.png","rect":{"x":108.53,"y":0,"width":936.93,"height":1212}},"hotZoneItemArr2":[{"id":"1667981969225","index":0,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"3","labelText":"Trace w a say","posX":368,"posY":119,"rect":{"x":124.47,"y":101,"width":270,"height":36}},{"id":"1667982191278","index":1,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"5","labelText":"B","posX":236.00500001279102,"posY":191.00155025950244,"rect":{"x":99.48,"y":148,"width":55.99,"height":86}},{"id":"1667982331366","index":2,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_0_b","posX":413,"posY":190,"rect":{"x":274.47,"y":150,"width":60,"height":80}},{"id":"1667982505546","index":3,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_1_b","posX":500.0045804706154,"posY":192.00048605495954,"rect":{"x":361.47,"y":152,"width":60,"height":80}},{"id":"1667982528830","index":4,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_2_b","posX":588.0048030326232,"posY":191.00048861314355,"rect":{"x":449.47,"y":151,"width":60,"height":80}},{"id":"1667982696613","index":5,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_3_b","posX":674.0050281528149,"posY":191.00048861314355,"rect":{"x":535.49,"y":151,"width":60,"height":80}},{"id":"1667982762888","index":6,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_4_b","posX":764.0052481566387,"posY":191.00048861314355,"rect":{"x":625.5,"y":151,"width":60,"height":80}},{"id":"1667982780373","index":7,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_5_b","posX":851.0154758605963,"posY":192.0004911713275,"rect":{"x":712.51,"y":152,"width":60,"height":80}},{"id":"1667982820496","index":8,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"B_6_b","posX":936.0257010063699,"posY":192.0004937295115,"rect":{"x":797.52,"y":152,"width":60,"height":80}},{"id":"1667982922997","index":9,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_0_s","posX":413.0359184775915,"posY":313.0004911713275,"rect":{"x":278.54,"y":273,"width":51.93,"height":80}},{"id":"1667982963933","index":10,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_1_s","posX":502.0398031221596,"posY":312.00079815340723,"rect":{"x":367.54,"y":272,"width":51.93,"height":80}},{"id":"1667982981844","index":11,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_2_s","posX":588.0400256841674,"posY":312.00079815340723,"rect":{"x":453.54,"y":272,"width":51.93,"height":80}},{"id":"1667982997077","index":12,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_3_s","posX":675.050245713573,"posY":312.00079815340723,"rect":{"x":540.56,"y":272,"width":51.93,"height":80}},{"id":"1667983009421","index":13,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_4_s","posX":763.0604734175306,"posY":312.00079815340723,"rect":{"x":628.57,"y":272,"width":51.93,"height":80}},{"id":"1667983021501","index":14,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_5_s","posX":850.0706960051203,"posY":312.00080071159124,"rect":{"x":715.58,"y":272,"width":51.93,"height":80}},{"id":"1667983039040","index":15,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"1","labelText":"b_6_s","posX":937.0809211508939,"posY":311.00079815340723,"rect":{"x":802.59,"y":271,"width":51.93,"height":80}},{"id":"1667983233606","index":16,"itemType":"rect","fontScale":0.9015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":0.9015625,"dragDot":{"x":577,"y":606},"gIdx":"2","posX":588.0050230364469,"posY":239.0006062896074,"rect":{"x":47.47,"y":88,"width":864,"height":302}}],"isDebug":false}




		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"https://teach.cdn.ireadabc.com/684f085ef1286bef60066720162381b8.png","rect":{"x":237.62,"y":0,"width":1252.76,"height":649}},"hotZoneItemArr":[{"id":"1669017611587","index":0,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":692.9602814259316,"posY":185.7589939450262,"rect":{"x":495.9,"y":177.44,"width":50.33,"height":50.33},"pointItem":1,"linkItem":2},{"id":"1669017628260","index":1,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":895.1838773664921,"posY":185.66390047751776,"rect":{"x":716.48,"y":177.35,"width":50.33,"height":50.33},"pointItem":2,"linkItem":1},{"id":"1669017628745","index":2,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":1077.07009039729,"posY":252.81717081690795,"rect":{"x":914.87,"y":250.59,"width":50.33,"height":50.33},"pointItem":3,"linkItem":4},{"id":"1669017629096","index":3,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":1084.4044361247306,"posY":406.36600093794283,"rect":{"x":922.87,"y":418.07,"width":50.33,"height":50.33},"pointItem":4,"linkItem":3},{"id":"1669017629331","index":4,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":910.7574753538651,"posY":448.46716877009555,"rect":{"x":733.47,"y":464,"width":50.33,"height":50.33},"pointItem":5,"linkItem":6},{"id":"1669017629556","index":5,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":681.5308422309823,"posY":448.3720753025871,"rect":{"x":483.45,"y":463.89,"width":50.33,"height":50.33},"pointItem":6,"linkItem":5},{"id":"1669017629775","index":6,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":500.83481613520166,"posY":398.3169356130275,"rect":{"x":286.34,"y":409.3,"width":50.33,"height":50.33},"pointItem":7,"linkItem":8},{"id":"1669017630034","index":7,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":499.92990960271015,"posY":251.81717081690795,"rect":{"x":285.35,"y":249.5,"width":50.33,"height":50.33},"pointItem":8,"linkItem":7},{"id":"1669017679915","index":8,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":746.6841125703726,"posY":244.38773162195878,"rect":{"x":554.5,"y":241.4,"width":50.33,"height":50.33},"pointItem":9,"linkItem":10},{"id":"1669017680161","index":9,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":850.0336442094241,"posY":245.6730120244842,"rect":{"x":667.24,"y":242.81,"width":50.33,"height":50.33},"pointItem":10,"linkItem":9},{"id":"1669017680397","index":10,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":906.2329426914074,"posY":277.34474066168775,"rect":{"x":728.54,"y":277.34,"width":50.33,"height":50.33},"pointItem":11,"linkItem":12},{"id":"1669017680628","index":11,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":905.3280361589159,"posY":363.9304873783493,"rect":{"x":727.54,"y":371.79,"width":50.33,"height":50.33},"pointItem":12,"linkItem":11},{"id":"1669017681310","index":12,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":849.223831144441,"posY":395.69730948306136,"rect":{"x":666.35,"y":406.43,"width":50.33,"height":50.33},"pointItem":13,"linkItem":14},{"id":"1669017681516","index":13,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":747.7792060378811,"posY":396.6022160155529,"rect":{"x":555.69,"y":407.43,"width":50.33,"height":50.33},"pointItem":14,"linkItem":13},{"id":"1669017681761","index":14,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":684.5308422309823,"posY":360.0255808458578,"rect":{"x":486.71,"y":367.53,"width":50.33,"height":50.33},"pointItem":15,"linkItem":16},{"id":"1669017681968","index":15,"itemType":"rect","fontScale":1.35,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.35,"dragDot":{"x":864,"y":325.57314756174793},"gIdx":"0","posX":684.3406552959655,"posY":279.05946025916234,"rect":{"x":486.5,"y":279.21,"width":50.33,"height":50.33},"pointItem":16,"linkItem":15},{"id":"1672018943194","index":16,"pic_url":"http://staging-teach.cdn.ireadabc.com/85b7c85ca4f2183549abf13a10cf3621.png","itemType":"pic","fontScale":1.35,"imgScale":1.0263157894736843,"imgSizeW":185,"imgSizeH":114,"mapScale":1.35,"dragDot":{"x":864,"y":324.5},"gIdx":"6","rect":{"x":538.45,"y":294,"width":189.87,"height":117},"rectNew":17}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"6","name":"书写"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/7975e4a930fe51033b0e1321260d4046.png","rect":{"x":148.42,"y":0,"width":1154.16,"height":1493}},"hotZoneItemArr2":[{"id":"1669017732389","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":684.5,"posY":746.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":454.12,"y":661.3,"width":52.5,"height":52.5}},{"id":"1669017744633","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":905.4951316891791,"posY":743.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":657.65,"y":658.54,"width":52.5,"height":52.5}},{"id":"1669017744849","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1101.495131689179,"posY":819.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":838.17,"y":728.54,"width":52.5,"height":52.5}},{"id":"1669017745296","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1110.495131689179,"posY":986.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":846.46,"y":882.35,"width":52.5,"height":52.5}},{"id":"1669017745504","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":923.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":674.23,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745728","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":673.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":443.99,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745946","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":477.49513168917906,"posY":977.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":263.46,"y":874.06,"width":52.5,"height":52.5}},{"id":"1669017747640","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":475.49513168917906,"posY":815.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":261.62,"y":724.85,"width":52.5,"height":52.5}},{"id":"1669017780767","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":510.3,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781123","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":610.67,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781698","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":918.4951316891791,"posY":847.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":669.62,"y":754.33,"width":52.5,"height":52.5}},{"id":"1669017782166","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":916.4951316891791,"posY":935.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":667.78,"y":835.38,"width":52.5,"height":52.5}},{"id":"1669017783084","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":972.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":610.67,"y":869.46,"width":52.5,"height":52.5}},{"id":"1669017783667","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":976.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":510.3,"y":873.14,"width":52.5,"height":52.5}},{"id":"1669017784240","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":678.4951392139167,"posY":937.4988242597458,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":448.59,"y":837.22,"width":52.5,"height":52.5}},{"id":"1669017785006","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":675.4951316891791,"posY":843.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":445.83,"y":750.64,"width":52.5,"height":52.5}},{"id":"1669170012773","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":746.5},"gIdx":"6","labelText":"Cc","posX":734.5,"posY":820.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":486.08,"y":745,"width":200,"height":151}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"6","lineType":"1","circleSize":"1"}
		
		return this.item = {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"45","bgItem":{"url":"https://teach.cdn.ireadabc.com/457c72a9cb0f903e45e151f5a4c836e1.png","rect":{"x":224.33,"y":0,"width":1130.34,"height":595}},"hotZoneItemArr":[{"id":"1669027968644","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":440.5,"posY":169.5,"rect":{"x":99.67,"y":95,"width":233,"height":149},"rectNew":1},{"id":"1669028023205","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":443.499071286044,"posY":346.5004510516205,"rect":{"x":102.67,"y":272,"width":233,"height":149},"rectNew":2},{"id":"1669028023430","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/0a425bcf53cf83eca9b725f62957d873.json","name":"db_letter_i_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/65ba76a8bcbb05c926be163c60a67ab0.json","name":"db_letter_i_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/364b37a6c1e6c7b6f4a270cb81ec5f0b.png","name":"db_letter_i_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":443.4990792692586,"posY":513.501366460219,"rect":{"x":102.67,"y":439,"width":233,"height":149},"rectNew":3},{"id":"1669028023680","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/7fd4e5db04c04cdcf0dc6b0c12fc4764.json","name":"db_letter_k_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/c5c2c04b305ae8890c9f050d7cbbf97a.json","name":"db_letter_k_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/4d31a35f1a705b9ab198f044ed391fc0.png","name":"db_letter_k_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1189.499071286044,"posY":170.50045105162047,"rect":{"x":848.67,"y":96,"width":233,"height":149},"rectNew":4},{"id":"1669028023942","index":4,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1189.499071286044,"posY":342.5004510516205,"rect":{"x":848.67,"y":268,"width":233,"height":149},"rectNew":5},{"id":"1669028024195","index":5,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1192.501069750746,"posY":513.5013691212904,"rect":{"x":851.67,"y":439,"width":233,"height":149},"rectNew":6},{"id":"1669028676925","index":6,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":660.5,"posY":240.5,"rect":{"x":411.67,"y":216,"width":49,"height":49},"pointItem":7,"linkItem":16},{"id":"1669028762010","index":7,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":811.4996567217756,"posY":241.50063998769747,"rect":{"x":562.67,"y":217,"width":49,"height":49},"pointItem":8,"linkItem":18},{"id":"1669028762200","index":8,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":959.4996567217756,"posY":239.50063998769747,"rect":{"x":710.67,"y":215,"width":49,"height":49},"pointItem":9,"linkItem":14},{"id":"1669028762448","index":9,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":661.4996567217756,"posY":440.50063998769747,"rect":{"x":412.67,"y":416,"width":49,"height":49},"pointItem":10,"linkItem":15},{"id":"1669028762652","index":10,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":810.4996567217756,"posY":440.50063998769747,"rect":{"x":561.67,"y":416,"width":49,"height":49},"pointItem":11,"linkItem":13},{"id":"1669028762878","index":11,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":959.4996567217756,"posY":438.50063998769747,"rect":{"x":710.67,"y":414,"width":49,"height":49},"pointItem":12,"linkItem":17},{"id":"1669028763095","index":12,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":169.50063998769747,"rect":{"x":298.67,"y":145,"width":49,"height":49},"pointItem":13,"linkItem":11},{"id":"1669028763723","index":13,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":342.50063998769747,"rect":{"x":298.67,"y":318,"width":49,"height":49},"pointItem":14,"linkItem":9},{"id":"1669028763919","index":14,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":515.5006399876975,"rect":{"x":298.67,"y":491,"width":49,"height":49},"pointItem":15,"linkItem":10},{"id":"1669028764788","index":15,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1084.4996567217756,"posY":169.50063998769747,"rect":{"x":835.67,"y":145,"width":49,"height":49},"pointItem":16,"linkItem":7},{"id":"1669028765508","index":16,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1085.4996567217756,"posY":341.50063998769747,"rect":{"x":836.67,"y":317,"width":49,"height":49},"pointItem":17,"linkItem":12},{"id":"1669028766684","index":17,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1085.4996567217756,"posY":514.5006399876975,"rect":{"x":836.67,"y":490,"width":49,"height":49},"pointItem":18,"linkItem":8},{"id":"1669028965617","index":18,"audio_url":"https://teach.cdn.ireadabc.com/fa4edbee3e71acaac5426787327cc70e.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":555.5,"posY":98.5,"rect":{"x":305.67,"y":73,"width":51,"height":51}},{"id":"1669028987109","index":19,"audio_url":"https://teach.cdn.ireadabc.com/e7bcf57e7c23c38c0d276aa94b44cdad.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":564.4993746481958,"posY":268.5002674376865,"rect":{"x":314.67,"y":243,"width":51,"height":51}},{"id":"1669028988980","index":20,"audio_url":"https://teach.cdn.ireadabc.com/48bc4f1bf13394bc9dbc0a2943aa49bc.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":563.4993746481958,"posY":434.5002674376865,"rect":{"x":313.67,"y":409,"width":51,"height":51}},{"id":"1669028989259","index":21,"audio_url":"https://teach.cdn.ireadabc.com/b1cfbb3de49089766cc3445728a4ada7.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1311.499374648196,"posY":94.50026743768646,"rect":{"x":1061.67,"y":69,"width":51,"height":51}},{"id":"1669028989473","index":22,"audio_url":"https://teach.cdn.ireadabc.com/22b083172dcc1cd6cb29c31542df5fc5.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1308.499374648196,"posY":266.5002674376865,"rect":{"x":1058.67,"y":241,"width":51,"height":51}},{"id":"1669028989757","index":23,"audio_url":"https://teach.cdn.ireadabc.com/37e1f105a64fdfd3424e2dc8676b00a9.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1313.499374648196,"posY":438.5002674376865,"rect":{"x":1063.67,"y":413,"width":51,"height":51}}],"typeArr":[{"gIdx":"1","name":"手写"},{"gIdx":"0","name":"连线"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/58c55c5d77576fad7c547123ba68d02a.png","rect":{"x":162.95,"y":0,"width":1253.11,"height":1621}},"hotZoneItemArr2":[{"id":"1669028281208","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":405.5,"posY":715.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":112.05,"y":640,"width":261,"height":151}},{"id":"1669028304948","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":404.4954815894788,"posY":908.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":111.05,"y":833,"width":261,"height":151}},{"id":"1669028305153","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Ii","posX":406.4954815894788,"posY":1094.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":113.05,"y":1019,"width":261,"height":151}},{"id":"1669028305356","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Kk","posX":1232.495481589479,"posY":715.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":939.02,"y":640,"width":261,"height":151}},{"id":"1669028305571","index":4,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":1230.495481589479,"posY":910.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":937.02,"y":835,"width":261,"height":151}},{"id":"1669028305755","index":5,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":1233.495481589479,"posY":1101.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":940.02,"y":1026,"width":261,"height":151}},{"id":"1669028350559","index":6,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":649.5,"posY":793.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":463.05,"y":770,"width":47,"height":47}},{"id":"1669028390520","index":7,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":812.4951755834819,"posY":792.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.05,"y":769,"width":47,"height":47}},{"id":"1669028390701","index":8,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":979.4951755834819,"posY":794.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":793.03,"y":771,"width":47,"height":47}},{"id":"1669028390911","index":9,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":648.4951755834819,"posY":1013.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":462.05,"y":990,"width":47,"height":47}},{"id":"1669028391078","index":10,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":812.4951755834819,"posY":1016.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.05,"y":993,"width":47,"height":47}},{"id":"1669028391273","index":11,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":978.4951755834819,"posY":1014.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":792.03,"y":991,"width":47,"height":47}},{"id":"1669028427605","index":12,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":520.4951755834819,"posY":715.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":334.05,"y":692,"width":47,"height":47}},{"id":"1669028427782","index":13,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":523.4951755834819,"posY":904.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":337.05,"y":881,"width":47,"height":47}},{"id":"1669028427990","index":14,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":523.4951755834819,"posY":1094.4990048534487,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":337.05,"y":1071,"width":47,"height":47}},{"id":"1669028428167","index":15,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1119.4951755834818,"posY":715.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":933.03,"y":692,"width":47,"height":47}},{"id":"1669028428404","index":16,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1116.4951755834818,"posY":902.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":930.03,"y":879,"width":47,"height":47}},{"id":"1669028428589","index":17,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1118.4951755834818,"posY":1096.4990048534487,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":932.03,"y":1073,"width":47,"height":47}}],"firstGIdx":"1","begin_audio_url":"https://teach.cdn.ireadabc.com/165a2ffaf57e33e73a2ba10e5f81a38c.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/36e09d2c6e5b7191f2eaa367211a30e3.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/822af0678dc62dc2846ff8fa0f773ccc.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/822af0678dc62dc2846ff8fa0f773ccc.mp3","isDebug":true}
		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"https://teach.cdn.ireadabc.com/684f085ef1286bef60066720162381b8.png","rect":{"x":196.6,"y":0,"width":1057.8,"height":548}},"hotZoneItemArr":[{"id":"1669017611587","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":692.9602814259316,"posY":185.7589939450262,"rect":{"x":418.73,"y":149.83,"width":42.5,"height":42.5},"pointItem":1,"linkItem":9},{"id":"1669017628260","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":895.1838773664921,"posY":185.66390047751776,"rect":{"x":604.98,"y":149.75,"width":42.5,"height":42.5},"pointItem":2,"linkItem":10},{"id":"1669017628745","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":1077.07009039729,"posY":252.81717081690795,"rect":{"x":772.49,"y":211.59,"width":42.5,"height":42.5},"pointItem":3,"linkItem":11},{"id":"1669017629096","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":1084.4044361247306,"posY":406.36600093794283,"rect":{"x":779.25,"y":353.01,"width":42.5,"height":42.5},"pointItem":4,"linkItem":12},{"id":"1669017629331","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":910.7574753538651,"posY":448.46716877009555,"rect":{"x":619.32,"y":391.79,"width":42.5,"height":42.5},"pointItem":5,"linkItem":13},{"id":"1669017629556","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":681.5308422309823,"posY":448.3720753025871,"rect":{"x":408.21,"y":391.7,"width":42.5,"height":42.5},"pointItem":6,"linkItem":14},{"id":"1669017629775","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":500.83481613520166,"posY":398.3169356130275,"rect":{"x":241.78,"y":345.6,"width":42.5,"height":42.5},"pointItem":7,"linkItem":15},{"id":"1669017630034","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":499.92990960271015,"posY":251.81717081690795,"rect":{"x":240.94,"y":210.67,"width":42.5,"height":42.5},"pointItem":8,"linkItem":16},{"id":"1669017679915","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":746.6841125703726,"posY":244.38773162195878,"rect":{"x":468.21,"y":203.83,"width":42.5,"height":42.5},"pointItem":9,"linkItem":1},{"id":"1669017680161","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":850.0336442094241,"posY":245.6730120244842,"rect":{"x":563.4,"y":205.02,"width":42.5,"height":42.5},"pointItem":10,"linkItem":2},{"id":"1669017680397","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":906.2329426914074,"posY":277.34474066168775,"rect":{"x":615.16,"y":234.18,"width":42.5,"height":42.5},"pointItem":11,"linkItem":3},{"id":"1669017680628","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":905.3280361589159,"posY":363.9304873783493,"rect":{"x":614.32,"y":313.93,"width":42.5,"height":42.5},"pointItem":12,"linkItem":4},{"id":"1669017681310","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":849.223831144441,"posY":395.69730948306136,"rect":{"x":562.65,"y":343.18,"width":42.5,"height":42.5},"pointItem":13,"linkItem":5},{"id":"1669017681516","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":747.7792060378811,"posY":396.6022160155529,"rect":{"x":469.21,"y":344.02,"width":42.5,"height":42.5},"pointItem":14,"linkItem":6},{"id":"1669017681761","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":684.5308422309823,"posY":360.0255808458578,"rect":{"x":410.97,"y":310.33,"width":42.5,"height":42.5},"pointItem":15,"linkItem":7},{"id":"1669017681968","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":684.3406552959655,"posY":279.05946025916234,"rect":{"x":410.79,"y":235.76,"width":42.5,"height":42.5},"pointItem":16,"linkItem":8},{"id":"1669169946060","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/b213e3ebfa399bead9cef9a5b6089a5c.json","name":"db_letter_c_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/f2f7de385d5ec34d1f51c1d0d639d0db.json","name":"db_letter_c_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/bc2ecbb4ccad7ed8717ab0c6b9a15a40.png","name":"db_letter_c_tex.png"},"dragDot":{"x":725.5,"y":274},"gIdx":"1","posX":731.5,"posY":299,"rect":{"x":434.9,"y":231,"width":200,"height":136},"rectNew":17}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/7975e4a930fe51033b0e1321260d4046.png","rect":{"x":148.42,"y":0,"width":1154.16,"height":1493}},"hotZoneItemArr2":[{"id":"1669017732389","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":684.5,"posY":746.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":454.12,"y":661.3,"width":52.5,"height":52.5}},{"id":"1669017744633","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":905.4951316891791,"posY":743.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":657.65,"y":658.54,"width":52.5,"height":52.5}},{"id":"1669017744849","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1101.495131689179,"posY":819.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":838.17,"y":728.54,"width":52.5,"height":52.5}},{"id":"1669017745296","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1110.495131689179,"posY":986.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":846.46,"y":882.35,"width":52.5,"height":52.5}},{"id":"1669017745504","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":923.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":674.23,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745728","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":673.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":443.99,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745946","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":477.49513168917906,"posY":977.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":263.46,"y":874.06,"width":52.5,"height":52.5}},{"id":"1669017747640","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":475.49513168917906,"posY":815.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":261.62,"y":724.85,"width":52.5,"height":52.5}},{"id":"1669017780767","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":510.3,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781123","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":610.67,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781698","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":918.4951316891791,"posY":847.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":669.62,"y":754.33,"width":52.5,"height":52.5}},{"id":"1669017782166","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":916.4951316891791,"posY":935.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":667.78,"y":835.38,"width":52.5,"height":52.5}},{"id":"1669017783084","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":972.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":610.67,"y":869.46,"width":52.5,"height":52.5}},{"id":"1669017783667","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":976.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":510.3,"y":873.14,"width":52.5,"height":52.5}},{"id":"1669017784240","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":678.4951392139167,"posY":937.4988242597458,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":448.59,"y":837.22,"width":52.5,"height":52.5}},{"id":"1669017785006","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":675.4951316891791,"posY":843.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":445.83,"y":750.64,"width":52.5,"height":52.5}},{"id":"1669170012773","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":746.5},"gIdx":"6","labelText":"Cc","posX":734.5,"posY":820.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":486.08,"y":745,"width":200,"height":151}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"1"}
		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"13","bgItem":{"url":"http://teach.cdn.ireadabc.com/c5adfdc66a6e6c96ebe6da6565ec1f70.png","rect":{"x":219.09,"y":0,"width":1140.81,"height":595}},"hotZoneItemArr":[{"id":"1669018212234","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":465.5733991394584,"posY":265.738764146509,"rect":{"x":179.75,"y":199,"width":133.47,"height":133.47},"circleItem":1},{"id":"1669018428827","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":700.1100806305817,"posY":398.36855045738866,"rect":{"x":417.82,"y":335.17,"width":126.4,"height":126.4},"circleItem":2},{"id":"1669018440517","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":929.0410565137215,"posY":131.18563112412767,"rect":{"x":636.78,"y":58,"width":146.37,"height":146.37},"circleItem":3},{"id":"1669022543478","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":1168.5790418503811,"posY":528.7355952934026,"rect":{"x":882.76,"y":462,"width":133.47,"height":133.47},"circleItem":4},{"id":"1669088187793","index":4,"audio_url":"http://teach.cdn.ireadabc.com/253021eecc33765f06675cdad73b3a01.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":508.5,"posY":91.5,"rect":{"x":263.91,"y":66,"width":51,"height":51}},{"id":"1669088213504","index":5,"audio_url":"http://teach.cdn.ireadabc.com/2518788213ccb81735afd87efcea0d4b.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":746.5041818824636,"posY":85.5002731976987,"rect":{"x":501.91,"y":60,"width":51,"height":51}},{"id":"1669088213739","index":6,"audio_url":"http://teach.cdn.ireadabc.com/63d19e1ff307a581b796c8dd185def79.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":986.5041818824636,"posY":83.5002731976987,"rect":{"x":741.91,"y":58,"width":51,"height":51}},{"id":"1669088214011","index":7,"audio_url":"http://teach.cdn.ireadabc.com/4529ba230c0521bf20493eae24299643.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1199.5041818824636,"posY":97.5002731976987,"rect":{"x":954.91,"y":72,"width":51,"height":51}},{"id":"1669088215319","index":8,"audio_url":"http://teach.cdn.ireadabc.com/2c3a3676cd313c128abc9a47846bf379.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":521.5041818824636,"posY":239.5002731976987,"rect":{"x":276.91,"y":214,"width":51,"height":51}},{"id":"1669088215558","index":9,"audio_url":"http://teach.cdn.ireadabc.com/8517c90273b266fdeae51c7db4d78c4d.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":749.5041818824636,"posY":237.5002731976987,"rect":{"x":504.91,"y":212,"width":51,"height":51}},{"id":"1669088215822","index":10,"audio_url":"http://teach.cdn.ireadabc.com/3bb98de81b960185c16d81da98a35c0c.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":987.5041818824636,"posY":238.5002731976987,"rect":{"x":742.91,"y":213,"width":51,"height":51}},{"id":"1669088216062","index":11,"audio_url":"http://teach.cdn.ireadabc.com/1e79b88dd5762bc75dc4ca8114124eff.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1207.5041818824636,"posY":240.50027319769868,"rect":{"x":962.91,"y":215,"width":51,"height":51}},{"id":"1669088216898","index":12,"audio_url":"http://teach.cdn.ireadabc.com/02914cba7db081e503c3d66c7d01026f.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":517.5041818824636,"posY":365.5002731976987,"rect":{"x":272.91,"y":340,"width":51,"height":51}},{"id":"1669088217138","index":13,"audio_url":"http://teach.cdn.ireadabc.com/abccf8f6ce8893cf6c3ba8c43202fe0c.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":754.5041818824636,"posY":362.5002731976987,"rect":{"x":509.91,"y":337,"width":51,"height":51}},{"id":"1669088217360","index":14,"audio_url":"http://teach.cdn.ireadabc.com/625a6ca75e12a8db5e845566934dc2d5.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":995.5041818824636,"posY":364.5002731976987,"rect":{"x":750.91,"y":339,"width":51,"height":51}},{"id":"1669088217595","index":15,"audio_url":"http://teach.cdn.ireadabc.com/b2979f011a3377e73e8a0815f7cd4d93.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1214.5041818824636,"posY":361.5002731976987,"rect":{"x":969.91,"y":336,"width":51,"height":51}},{"id":"1669088218362","index":16,"audio_url":"http://teach.cdn.ireadabc.com/5caffaa50b270c638cb2cee922d8da4f.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":510.5041818824636,"posY":491.5002731976987,"rect":{"x":265.91,"y":466,"width":51,"height":51}},{"id":"1669088218571","index":17,"audio_url":"http://teach.cdn.ireadabc.com/eb58af12affc6159b6299ac73b8aacd6.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":760.5041818824636,"posY":489.5002731976987,"rect":{"x":515.91,"y":464,"width":51,"height":51}},{"id":"1669088218819","index":18,"audio_url":"http://teach.cdn.ireadabc.com/fc549fddfeed935929831d457d2544d6.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1001.5041818824636,"posY":489.5002731976987,"rect":{"x":756.91,"y":464,"width":51,"height":51}},{"id":"1669088219087","index":19,"audio_url":"http://teach.cdn.ireadabc.com/84ce55828bd07b8e7efb25bc31c4d0ed.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1214.5041818824636,"posY":489.5002731976987,"rect":{"x":969.91,"y":464,"width":51,"height":51}}],"typeArr":[{"gIdx":"2","name":"画圈"}],"bgItem2":{"url":"http://teach.cdn.ireadabc.com/2b25e222cf2e751984a18c7a589194f4.png","rect":{"x":162.95,"y":0,"width":1253.11,"height":1621}},"hotZoneItemArr2":[{"id":"1669018544051","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":439.49543894929894,"posY":821.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":160.04,"y":726,"width":233.01,"height":191}},{"id":"1669018570547","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":689.4954389492989,"posY":960.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":402.04,"y":850,"width":249.01,"height":221}},{"id":"1669018571312","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":946.4944845617431,"posY":673.4986123129693,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":673.04,"y":586,"width":221.01,"height":175}},{"id":"1669022636621","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":1203.495438949299,"posY":1107.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":942.04,"y":1026,"width":197.01,"height":163}}],"begin_audio_url":"http://teach.cdn.ireadabc.com/a382738d66f84a7dc453e1aee978f286.mp3","idle_audio_url":"http://teach.cdn.ireadabc.com/a4758f8c14cb5859b3395514578a5f0f.mp3","finish_right_audio_url":"http://teach.cdn.ireadabc.com/b019c28398d252f09042114e1260779c.mp3"}
		
		return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/1911e3568e927257c91a8fd25d118398.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":313.64,"y":0,"width":1130.71,"height":666}},"hotZoneItemArr":[{"id":"1668059700120","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":774,"posY":221,"rect":{"x":434.36,"y":195,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1668059708822","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":840.0046289463639,"posY":286.00078101674904,"rect":{"x":500.36,"y":260,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1668059715388","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":999.0048621911851,"posY":221.00101072755757,"rect":{"x":659.4,"y":195,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1668059723401","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0054240991628,"posY":285.00078101674904,"rect":{"x":609.41,"y":259,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1668059730444","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1199.015247433881,"posY":294.00100719354515,"rect":{"x":859.42,"y":268,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1668059737547","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.026130972331,"posY":322.0010389996571,"rect":{"x":671.43,"y":296,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1668059742714","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1206.0354666133326,"posY":463.00113795200537,"rect":{"x":866.44,"y":437,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1668059747117","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.0461557810982,"posY":415.00163624775934,"rect":{"x":671.45,"y":389,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1668059754005","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1017.0554666840126,"posY":508.00146661516226,"rect":{"x":677.46,"y":482,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1668059760443","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0654879234274,"posY":451.0017952783191,"rect":{"x":609.47,"y":425,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1668059768151","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":767.0752476459216,"posY":505.00159383961,"rect":{"x":427.44,"y":479,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1668059772490","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":836.0846044909979,"posY":451.0017846762818,"rect":{"x":496.44,"y":425,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1668059780036","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":569.0848483378562,"posY":455.00159383961005,"rect":{"x":229.44,"y":429,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1668059786972","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0839047565349,"posY":416.0016079756598,"rect":{"x":430.44,"y":390,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1668059793504","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":567.0846150930352,"posY":293.0014701491747,"rect":{"x":227.44,"y":267,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1668059803802","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0838976885101,"posY":321.00103546564463,"rect":{"x":430.44,"y":295,"width":52,"height":52},"linkItem":15,"pointItem":16},{"id":"1668062996049","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/8d6671efb002131453b527eeed3bf97f.json","name":"C大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/73fe384407514cdb6367e836a45cfa03.json","name":"C大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ef6a958b04c1fed3a47881a592483df7.png","name":"C大黑_tex.png"},"dragDot":{"x":879,"y":333},"gIdx":"1","posX":890,"posY":368,"rect":{"x":464.36,"y":293,"width":224,"height":150},"rectNew":17}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":177.27,"y":0,"width":1403.46,"height":1816}},"hotZoneItemArr2":[{"id":"1668060479065","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"0","posX":761,"posY":837,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":555.73,"y":809,"width":56,"height":56}},{"id":"1668060505242","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":831.0000317275176,"posY":909.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":627.73,"y":884,"width":52,"height":52}},{"id":"1668060522174","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1010.0000129061089,"posY":836.9997553216862,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":806.73,"y":811,"width":52,"height":52}},{"id":"1668060535017","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999647770779,"posY":906.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":748.73,"y":881,"width":52,"height":52}},{"id":"1668060544062","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1228.9999803719595,"posY":917.9997561283179,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1025.73,"y":892,"width":52,"height":52}},{"id":"1668060551250","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1021.9999058929563,"posY":947.999753170668,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":818.73,"y":922,"width":52,"height":52}},{"id":"1668060557455","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1236.9999615505508,"posY":1105.99974510435,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1033.73,"y":1080,"width":52,"height":52}},{"id":"1668060563678","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1020.9999037419382,"posY":1052.9997026217416,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":817.73,"y":1027,"width":52,"height":52}},{"id":"1668060572236","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1028.9999618194279,"posY":1155.9997168722368,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":825.73,"y":1130,"width":52,"height":52}},{"id":"1668060578650","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999596684097,"posY":1092.9996891778783,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":748.73,"y":1067,"width":52,"height":52}},{"id":"1668060585215","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":750.9999803719595,"posY":1152.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":547.73,"y":1127,"width":52,"height":52}},{"id":"1668060594729","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":830.0000344162903,"posY":1092.99968998451,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":626.73,"y":1067,"width":52,"height":52}},{"id":"1668060603472","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":530.0000131749862,"posY":1095.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":326.73,"y":1070,"width":52,"height":52}},{"id":"1668060610498","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":755.0000938381665,"posY":1050.9997053105142,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":551.73,"y":1025,"width":52,"height":52}},{"id":"1668060616544","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":528.0000333407812,"posY":914.9997174099913,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":324.73,"y":889,"width":52,"height":52}},{"id":"1668060624038","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":754.0000943759211,"posY":947.9997539772997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":550.73,"y":922,"width":52,"height":52}},{"id":"1668060653013","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"6","labelText":"Cc","posX":890,"posY":1001,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":583.73,"y":913,"width":258,"height":176}}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"firstGIdx":"0","change_step_audio_url":"http://staging-teach.cdn.ireadabc.com/5d328902664fecfc2c17552394c29921.mp3","idle_2_audio_url":"http://staging-teach.cdn.ireadabc.com/13b05d0e777233d9fd9b661c76ebee2e.mp3","isDebug":true}
		return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/1911e3568e927257c91a8fd25d118398.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":313.64,"y":0,"width":1130.71,"height":666}},"hotZoneItemArr":[{"id":"1668059700120","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":774,"posY":221,"rect":{"x":434.36,"y":195,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1668059708822","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":840.0046289463639,"posY":286.00078101674904,"rect":{"x":500.36,"y":260,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1668059715388","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":999.0048621911851,"posY":221.00101072755757,"rect":{"x":659.4,"y":195,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1668059723401","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0054240991628,"posY":285.00078101674904,"rect":{"x":609.41,"y":259,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1668059730444","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1199.015247433881,"posY":294.00100719354515,"rect":{"x":859.42,"y":268,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1668059737547","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.026130972331,"posY":322.0010389996571,"rect":{"x":671.43,"y":296,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1668059742714","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1206.0354666133326,"posY":463.00113795200537,"rect":{"x":866.44,"y":437,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1668059747117","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.0461557810982,"posY":415.00163624775934,"rect":{"x":671.45,"y":389,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1668059754005","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1017.0554666840126,"posY":508.00146661516226,"rect":{"x":677.46,"y":482,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1668059760443","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0654879234274,"posY":451.0017952783191,"rect":{"x":609.47,"y":425,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1668059768151","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":767.0752476459216,"posY":505.00159383961,"rect":{"x":427.44,"y":479,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1668059772490","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":836.0846044909979,"posY":451.0017846762818,"rect":{"x":496.44,"y":425,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1668059780036","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":569.0848483378562,"posY":455.00159383961005,"rect":{"x":229.44,"y":429,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1668059786972","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0839047565349,"posY":416.0016079756598,"rect":{"x":430.44,"y":390,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1668059793504","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":567.0846150930352,"posY":293.0014701491747,"rect":{"x":227.44,"y":267,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1668059803802","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0838976885101,"posY":321.00103546564463,"rect":{"x":430.44,"y":295,"width":52,"height":52},"linkItem":15,"pointItem":16},{"id":"1668062996049","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/8d6671efb002131453b527eeed3bf97f.json","name":"C大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/73fe384407514cdb6367e836a45cfa03.json","name":"C大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ef6a958b04c1fed3a47881a592483df7.png","name":"C大黑_tex.png"},"dragDot":{"x":879,"y":333},"gIdx":"1","posX":890,"posY":368,"rect":{"x":464.36,"y":293,"width":224,"height":150},"rectNew":17}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":177.27,"y":0,"width":1403.46,"height":1816}},"hotZoneItemArr2":[{"id":"1668060479065","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"0","posX":761,"posY":837,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":555.73,"y":809,"width":56,"height":56}},{"id":"1668060505242","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":831.0000317275176,"posY":909.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":627.73,"y":884,"width":52,"height":52}},{"id":"1668060522174","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1010.0000129061089,"posY":836.9997553216862,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":806.73,"y":811,"width":52,"height":52}},{"id":"1668060535017","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999647770779,"posY":906.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":748.73,"y":881,"width":52,"height":52}},{"id":"1668060544062","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1228.9999803719595,"posY":917.9997561283179,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1025.73,"y":892,"width":52,"height":52}},{"id":"1668060551250","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1021.9999058929563,"posY":947.999753170668,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":818.73,"y":922,"width":52,"height":52}},{"id":"1668060557455","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1236.9999615505508,"posY":1105.99974510435,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1033.73,"y":1080,"width":52,"height":52}},{"id":"1668060563678","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1020.9999037419382,"posY":1052.9997026217416,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":817.73,"y":1027,"width":52,"height":52}},{"id":"1668060572236","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1028.9999618194279,"posY":1155.9997168722368,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":825.73,"y":1130,"width":52,"height":52}},{"id":"1668060578650","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999596684097,"posY":1092.9996891778783,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":748.73,"y":1067,"width":52,"height":52}},{"id":"1668060585215","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":750.9999803719595,"posY":1152.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":547.73,"y":1127,"width":52,"height":52}},{"id":"1668060594729","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":830.0000344162903,"posY":1092.99968998451,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":626.73,"y":1067,"width":52,"height":52}},{"id":"1668060603472","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":530.0000131749862,"posY":1095.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":326.73,"y":1070,"width":52,"height":52}},{"id":"1668060610498","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":755.0000938381665,"posY":1050.9997053105142,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":551.73,"y":1025,"width":52,"height":52}},{"id":"1668060616544","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":528.0000333407812,"posY":914.9997174099913,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":324.73,"y":889,"width":52,"height":52}},{"id":"1668060624038","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":754.0000943759211,"posY":947.9997539772997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":550.73,"y":922,"width":52,"height":52}},{"id":"1668060653013","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"6","labelText":"Cc","posX":890,"posY":1001,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":583.73,"y":913,"width":258,"height":176}}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"firstGIdx":"0","change_step_audio_url":"http://staging-teach.cdn.ireadabc.com/5d328902664fecfc2c17552394c29921.mp3","idle_2_audio_url":"http://staging-teach.cdn.ireadabc.com/13b05d0e777233d9fd9b661c76ebee2e.mp3","isDebug":true}
		// return {"page_id":"22","book_id":"opw1","part_name":"c","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b5fb215276c7afd3779887787bce8ccb.png","rect":{"x":250.35,"y":0,"width":889.29,"height":531}},"hotZoneItemArr":[{"id":"1667901785398","index":0,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":703,"posY":266.5,"rect":{"x":419.65,"y":233.5,"width":66,"height":66},"signItem":1},{"id":"1667902509387","index":1,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":984.0050081832392,"posY":266.50027243388246,"rect":{"x":700.65,"y":233.5,"width":66,"height":66},"signItem":2},{"id":"1667902517894","index":2,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/0a7875b1266391503571437db9db3a0f.json","name":"ku_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/422a6815028fe9f40298d9c369492b96.json","name":"ku_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/19bac79724d78938de8a654d47885586.png","name":"ku_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":423.0052954399782,"posY":484.50027243388246,"rect":{"x":139.66,"y":451.5,"width":66,"height":66},"signItem":3},{"id":"1667902630462","index":3,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":701.0052954399782,"posY":484.50027243388246,"rect":{"x":417.66,"y":451.5,"width":66,"height":66},"signItem":4},{"id":"1667902644903","index":4,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/0a7875b1266391503571437db9db3a0f.json","name":"ku_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/422a6815028fe9f40298d9c369492b96.json","name":"ku_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/19bac79724d78938de8a654d47885586.png","name":"ku_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":983.0147219589887,"posY":485.5004952878651,"rect":{"x":699.66,"y":452.5,"width":66,"height":66},"signItem":5}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/8c5a7ff4254cbc7922cb79e4794729c7.png","rect":{"x":143.31,"y":0,"width":1172.38,"height":1517}},"hotZoneItemArr2":[{"id":"1667902765218","index":0,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":716,"posY":443.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":573.08,"y":429.83,"width":70.24,"height":70.24}},{"id":"1667902778386","index":1,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":1028.9949114424535,"posY":445.49812930355085,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":901.22,"y":431.93,"width":70.24,"height":70.24}},{"id":"1667902784590","index":2,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":403.99359119896144,"posY":688.4981208674902,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"cry","key":"2"},"rect":{"x":245.98,"y":686.68,"width":70.24,"height":70.24}},{"id":"1667902791896","index":3,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":716.986227510095,"posY":687.4970958861212,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":574.12,"y":685.63,"width":70.24,"height":70.24}},{"id":"1667902798477","index":4,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":1029.9849072666034,"posY":687.4971001041515,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"cry","key":"2"},"rect":{"x":902.26,"y":685.63,"width":70.24,"height":70.24}}]}
		// return {"page_id":"13","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bg_pic_url":"http://staging-teach.cdn.ireadabc.com/103588a383dfef103f7d88081131a58b.png","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b11402c53d03d9b8966c1a5386c4d0b4.png","rect":{"x":382.88,"y":0,"width":1467.24,"height":841}},"hotZoneItemArr":[{"id":"1667284178410","index":0,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":652.5,"posY":380.5,"rect":{"x":169.62,"y":302,"width":200,"height":157},"circleItem":1},{"id":"1667285795465","index":1,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1004.5005700463794,"posY":566.4995325373978,"rect":{"x":521.62,"y":488,"width":200,"height":157},"circleItem":2},{"id":"1667285801759","index":2,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1679.500137597402,"posY":754.4993040274268,"rect":{"x":1196.62,"y":676,"width":200,"height":157},"circleItem":3}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/ef323091055c36876dfe25b5e8ed0128.png","rect":{"x":196.5,"y":0,"width":1536,"height":1987}},"hotZoneItemArr2":[{"id":"1667284877942","index":0,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":620.5,"posY":1160.5,"multRect":[{"color":"#ff0000","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20}],"rect":{"x":184.68,"y":904.39,"width":306.26,"height":204.23}},{"id":"1667284894146","index":1,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":988.5001409500544,"posY":1354.4996702166568,"multRect":[{"color":"#ffff00","width":20,"height":20,"x":20,"y":20},{"color":"#ffff00","width":20,"height":20,"x":20,"y":20},{"color":"#ffff00","width":20,"height":20,"x":20,"y":20}],"rect":{"x":525.99,"y":1079.53,"width":261.98,"height":190.46}},{"id":"1667284911442","index":2,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":1700.5000363742076,"posY":1549.4996150869986,"multRect":[{"color":"#0000ff","width":20,"height":20,"x":20,"y":20},{"color":"#0000ff","width":20,"height":20,"x":20,"y":20}],"rect":{"x":1140.35,"y":1250.58,"width":268.3,"height":186.62}}],"isDebug":false}
		// return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":234.22,"y":0,"width":867.56,"height":511}},"hotZoneItemArr":[{"id":"1667887774583","index":0,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":590,"posY":170.5,"rect":{"x":336.28,"y":151,"width":39,"height":39},"linkItem":2,"pointItem":1},{"id":"1667887788202","index":1,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":638.0000145894242,"posY":221.4999681090152,"rect":{"x":384.28,"y":202,"width":39,"height":39},"linkItem":1,"pointItem":2},{"id":"1667887795720","index":2,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":761.000005611317,"posY":170.49995856977634,"rect":{"x":507.28,"y":151,"width":39,"height":39},"linkItem":4,"pointItem":3},{"id":"1667887801441","index":3,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":720.9999826049174,"posY":220.4999681090152,"rect":{"x":467.28,"y":201,"width":39,"height":39},"linkItem":3,"pointItem":4},{"id":"1667887806805","index":4,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":911.9999900866734,"posY":226.49995875682023,"rect":{"x":658.28,"y":207,"width":39,"height":39},"linkItem":6,"pointItem":5},{"id":"1667887814385","index":5,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":767.9999543612886,"posY":247.49995763455684,"rect":{"x":514.28,"y":228,"width":39,"height":39},"linkItem":5,"pointItem":6},{"id":"1667887820091","index":6,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":919.99998129561,"posY":356.499953706635,"rect":{"x":666.28,"y":337,"width":39,"height":39},"linkItem":8,"pointItem":7},{"id":"1667887826462","index":7,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":769.9999528649374,"posY":320.4999333188499,"rect":{"x":516.28,"y":301,"width":39,"height":39},"linkItem":7,"pointItem":8},{"id":"1667887833937","index":8,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":771.9999809215223,"posY":389.49994005243036,"rect":{"x":518.28,"y":370,"width":39,"height":39},"linkItem":10,"pointItem":9},{"id":"1667887840312","index":9,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":720.9999805474345,"posY":348.4999271464013,"rect":{"x":467.28,"y":329,"width":39,"height":39},"linkItem":9,"pointItem":10},{"id":"1667887846297","index":10,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":580.9999900866734,"posY":388.4999348152012,"rect":{"x":327.28,"y":369,"width":39,"height":39},"linkItem":12,"pointItem":11},{"id":"1667887879817","index":11,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":637.0000162728193,"posY":347.49992733344516,"rect":{"x":383.28,"y":328,"width":39,"height":39},"linkItem":11,"pointItem":12},{"id":"1667887885876","index":12,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":431.0000057983608,"posY":349.499935002245,"rect":{"x":177.28,"y":330,"width":39,"height":39},"linkItem":14,"pointItem":13},{"id":"1667887891550","index":13,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":584.0000443294042,"posY":320.49993462815723,"rect":{"x":330.28,"y":301,"width":39,"height":39},"linkItem":13,"pointItem":14},{"id":"1667887898232","index":14,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":429.0000157116875,"posY":226.49994005243036,"rect":{"x":175.28,"y":207,"width":39,"height":39},"linkItem":16,"pointItem":15},{"id":"1667887904615","index":15,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":585.000044703492,"posY":247.49995763455684,"rect":{"x":331.28,"y":228,"width":39,"height":39},"linkItem":15,"pointItem":16}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":129.72,"y":0,"width":1076.55,"height":1393}},"hotZoneItemArr2":[{"id":"1667887944389","index":0,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":577,"posY":643.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":424.78,"y":621,"width":45,"height":45}},{"id":"1667887960040","index":1,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":632.004792675414,"posY":698.5014661615592,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":479.78,"y":676,"width":45,"height":45}},{"id":"1667887965560","index":2,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":769.0049179883678,"posY":641.5015914745129,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":616.79,"y":619,"width":45,"height":45}},{"id":"1667887978234","index":3,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":724.0052301315435,"posY":698.5014616047245,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":571.8,"y":676,"width":45,"height":45}},{"id":"1667887985592","index":4,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":936.0151276255474,"posY":705.5015914745129,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":783.81,"y":683,"width":45,"height":45}},{"id":"1667887992372","index":5,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":779.0256106728078,"posY":728.5016074234343,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.82,"y":706,"width":45,"height":45}},{"id":"1667887999027","index":6,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":942.0352529840694,"posY":848.5016598270331,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":789.83,"y":826,"width":45,"height":45}},{"id":"1667888007133","index":7,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":778.0456243888804,"posY":807.501933237114,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":625.84,"y":785,"width":45,"height":45}},{"id":"1667888014504","index":8,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":784.0552507512206,"posY":886.501839822003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":631.85,"y":864,"width":45,"height":45}},{"id":"1667888022599","index":9,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":724.0652644445088,"posY":839.5020198169731,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":571.86,"y":817,"width":45,"height":45}},{"id":"1667888029229","index":10,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":570.0751277622525,"posY":884.501912731358,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":417.86,"y":862,"width":45,"height":45}},{"id":"1667888036936","index":11,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":630.084776908766,"posY":839.5020152601384,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":477.86,"y":817,"width":45,"height":45}},{"id":"1667888043743","index":12,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":401.08491361380663,"posY":842.501912731358,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":248.86,"y":820,"width":45,"height":45}},{"id":"1667888050282","index":13,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":573.0843918562354,"posY":807.50191956661,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":420.86,"y":785,"width":45,"height":45}},{"id":"1667888056672","index":14,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":399.0847837440182,"posY":702.501839822003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":246.86,"y":680,"width":45,"height":45}},{"id":"1667888064637","index":15,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":572.0843872994008,"posY":727.5016005881822,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":419.86,"y":705,"width":45,"height":45}}],"isDebug":false}
		// return {"page_id":"82","book_id":"opw3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/48ecdccc083571a554a0393e88aa8e17.png","rect":{"x":0,"y":44.55,"width":2178,"height":731.91}},"hotZoneItemArr":[{"id":"1667527075823","index":0,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":353.49534883720935,"rect":{"x":987.5,"y":269.45,"width":79,"height":79},"circleItem":1,"signItem":1},{"id":"1667527184155","index":1,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1299,"posY":353.49534883720935,"rect":{"x":1259.5,"y":269.45,"width":79,"height":79},"circleItem":2,"signItem":2},{"id":"1667527190579","index":2,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":460.49534883720935,"rect":{"x":987.5,"y":376.45,"width":79,"height":79},"signItem":3},{"id":"1667527194988","index":3,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1300,"posY":463.49534883720935,"rect":{"x":1260.5,"y":379.45,"width":79,"height":79},"signItem":4},{"id":"1667527200554","index":4,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1028,"posY":571.4953488372093,"rect":{"x":988.5,"y":487.45,"width":79,"height":79},"signItem":5},{"id":"1667527205347","index":5,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1300,"posY":570.4953488372093,"rect":{"x":1260.5,"y":486.45,"width":79,"height":79},"signItem":6},{"id":"1667527210543","index":6,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":677.4953488372093,"rect":{"x":987.5,"y":593.45,"width":79,"height":79},"signItem":7},{"id":"1667527216357","index":7,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1299,"posY":678.4953488372093,"rect":{"x":1259.5,"y":594.45,"width":79,"height":79},"signItem":8},{"id":"1667527221859","index":8,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1628,"posY":355.49534883720935,"rect":{"x":1588.5,"y":271.45,"width":79,"height":79},"signItem":9},{"id":"1667527229299","index":9,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":353.49534883720935,"rect":{"x":1860.5,"y":269.45,"width":79,"height":79},"signItem":10},{"id":"1667527237415","index":10,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1627,"posY":460.49534883720935,"rect":{"x":1587.5,"y":376.45,"width":79,"height":79},"signItem":11},{"id":"1667527242936","index":11,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":461.49534883720935,"rect":{"x":1860.5,"y":377.45,"width":79,"height":79},"signItem":12},{"id":"1667527249982","index":12,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1626,"posY":569.4953488372093,"rect":{"x":1586.5,"y":485.45,"width":79,"height":79},"signItem":13},{"id":"1667527256608","index":13,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":571.4953488372093,"rect":{"x":1860.5,"y":487.45,"width":79,"height":79},"signItem":14},{"id":"1667527262126","index":14,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1627,"posY":678.4953488372093,"rect":{"x":1587.5,"y":594.45,"width":79,"height":79},"signItem":15},{"id":"1667527269087","index":15,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":679.4953488372093,"rect":{"x":1860.5,"y":595.45,"width":79,"height":79},"signItem":16}],"part_name":"e","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/cdc23fe114c7fbe4ce688c5b7cdff70e.png","rect":{"x":224.98,"y":0,"width":1728.05,"height":2236}},"hotZoneItemArr2":[{"id":"1667527318185","index":0,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1068,"posY":1726,"rect":{"x":811.02,"y":1694,"width":64,"height":64}},{"id":"1667527349948","index":1,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1265.9950206411086,"posY":1725.9983039012782,"rect":{"x":1009.02,"y":1694,"width":64,"height":64}},{"id":"1667527354975","index":2,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1067.9948260712667,"posY":1803.9983039012782,"rect":{"x":811.01,"y":1772,"width":64,"height":64}},{"id":"1667527363008","index":3,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.9850206509354,"posY":1803.9982272525526,"rect":{"x":1010.01,"y":1772,"width":64,"height":64}},{"id":"1667527368695","index":4,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1068.9848250984178,"posY":1883.9982272525526,"rect":{"x":812,"y":1852,"width":64,"height":64}},{"id":"1667527374694","index":5,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.9750196780863,"posY":1882.9981486384752,"rect":{"x":1010,"y":1851,"width":64,"height":64}},{"id":"1667527380289","index":6,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1066.9748251082444,"posY":1962.998149621151,"rect":{"x":809.99,"y":1931,"width":64,"height":64}},{"id":"1667527388175","index":7,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.965021653265,"posY":1960.9980710070736,"rect":{"x":1009.99,"y":1929,"width":64,"height":64}},{"id":"1667527393603","index":8,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1506.964825118071,"posY":1724.9980729724255,"rect":{"x":1249.98,"y":1693,"width":64,"height":64}},{"id":"1667527399645","index":9,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.9545892856654,"posY":1724.998304883954,"rect":{"x":1448.97,"y":1693,"width":64,"height":64}},{"id":"1667527406504","index":10,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1505.9443937429746,"posY":1803.998304883954,"rect":{"x":1248.96,"y":1772,"width":64,"height":64}},{"id":"1667527414914","index":11,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.934590287995,"posY":1804.9982272525526,"rect":{"x":1448.95,"y":1773,"width":64,"height":64}},{"id":"1667527423039","index":12,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1506.924393762628,"posY":1883.9982262698766,"rect":{"x":1249.94,"y":1852,"width":64,"height":64}},{"id":"1667527431966","index":13,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.9145893249724,"posY":1883.9981486384752,"rect":{"x":1448.93,"y":1852,"width":64,"height":64}},{"id":"1667527439422","index":14,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1507.9043937822817,"posY":1962.9981486384752,"rect":{"x":1250.92,"y":1931,"width":64,"height":64}},{"id":"1667527445613","index":15,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.8945883619504,"posY":1963.9980710070736,"rect":{"x":1448.91,"y":1932,"width":64,"height":64}}],"isDebug":false}
		return this.item = {"begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","page_id":"7","book_id":"opw1","part_name":"d","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/75bcd934bdd589d901b1d1dcf9e05e2b.png","rect":{"x":455.89,"y":0,"width":1729.22,"height":992}},"hotZoneItemArr":[{"id":"1667291729830","index":0,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":496},"gIdx":"0","posX":714.5,"posY":509,"rect":{"x":232.61,"y":483,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1667291758660","index":1,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":863.4985828918223,"posY":708.0011902773308,"rect":{"x":381.61,"y":682,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1667291766274","index":2,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1038.4989313227106,"posY":767.0016556313363,"rect":{"x":556.61,"y":741,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1667291773931","index":3,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1208.4993405536202,"posY":565.0017936006144,"rect":{"x":726.61,"y":539,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1667291781144","index":4,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1365.499738092218,"posY":554.0013212312218,"rect":{"x":883.61,"y":528,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1667291787620","index":5,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1519.500105230805,"posY":368.0012955081361,"rect":{"x":1037.61,"y":342,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1667291794068","index":6,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1697.5004653540052,"posY":452.00086055414096,"rect":{"x":1215.61,"y":426,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1667291799074","index":7,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1762.5008816003017,"posY":565.0010569849775,"rect":{"x":1280.61,"y":539,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1667291806543","index":8,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1672.501033600354,"posY":721.0013212312218,"rect":{"x":1190.61,"y":695,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1667291814677","index":9,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1477.5008231387435,"posY":705.0016860313468,"rect":{"x":995.61,"y":679,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1667291823228","index":10,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1371.5003671385873,"posY":813.0016486159494,"rect":{"x":889.61,"y":787,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1667291830926","index":11,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1199.5001192615794,"posY":812.0019011698821,"rect":{"x":717.61,"y":786,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1667291842195","index":12,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1326.4997170460567,"posY":247.00189883141968,"rect":{"x":844.61,"y":221,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1667291853247","index":13,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1130.500014030774,"posY":267.00057760019786,"rect":{"x":648.61,"y":241,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1667291861161","index":14,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1060.4995556921554,"posY":407.00062436944467,"rect":{"x":578.61,"y":381,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1667291869501","index":15,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":891.4993919997917,"posY":447.0009517541722,"rect":{"x":409.61,"y":421,"width":52,"height":52},"linkItem":15,"pointItem":16}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/71e68ebc76a7ce04eef418353d3f1844.png","rect":{"x":191.67,"y":0,"width":1499.67,"height":1940}},"hotZoneItemArr2":[{"id":"1667380287432","index":0,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":670.5,"posY":1410.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":277.93,"y":1022.76,"width":36.15,"height":36.15}},{"id":"1667380314762","index":1,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":827.4994456359115,"posY":1617.5012714317836,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":393.79,"y":1175.51,"width":36.15,"height":36.15}},{"id":"1667380322503","index":2,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1007.4995871564998,"posY":1680.5014580226232,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":526.61,"y":1222,"width":36.15,"height":36.15}},{"id":"1667380329891","index":3,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1185.4997494094036,"posY":1470.5015148111395,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":657.96,"y":1067.03,"width":36.15,"height":36.15}},{"id":"1667380339099","index":4,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1346.4999098594978,"posY":1458.5013255160848,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":776.77,"y":1058.18,"width":36.15,"height":36.15}},{"id":"1667380346091","index":5,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1507.5000549857066,"posY":1264.5013146992246,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":895.57,"y":915.02,"width":36.15,"height":36.15}},{"id":"1667380353829","index":6,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1690.500200111915,"posY":1351.5011398266504,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1030.61,"y":979.22,"width":36.15,"height":36.15}},{"id":"1667380360920","index":7,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1756.500365069034,"posY":1469.5012182488872,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1079.31,"y":1066.3,"width":36.15,"height":36.15}},{"id":"1667380368760","index":8,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1664.5004245617654,"posY":1629.5013246146798,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1011.42,"y":1184.36,"width":36.15,"height":36.15}},{"id":"1667380374561","index":9,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1462.5003416325035,"posY":1613.5014688394833,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":862.36,"y":1172.56,"width":36.15,"height":36.15}},{"id":"1667380381923","index":10,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1350.500159548689,"posY":1725.501454417003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":779.72,"y":1255.2,"width":36.15,"height":36.15}},{"id":"1667380387739","index":11,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1174.5000585913265,"posY":1723.5015553743654,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":649.84,"y":1253.73,"width":36.15,"height":36.15}},{"id":"1667380395200","index":12,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1306.4998999440427,"posY":1140.5015535715554,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":747.24,"y":823.52,"width":36.15,"height":36.15}},{"id":"1667380402254","index":13,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1101.5000189295056,"posY":1160.5010280524275,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":595.97,"y":838.28,"width":36.15,"height":36.15}},{"id":"1667380408975","index":14,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1028.499834141476,"posY":1304.501046080528,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":542.1,"y":944.53,"width":36.15,"height":36.15}},{"id":"1667380417184","index":15,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":853.4997683389092,"posY":1346.5011758828512,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":412.97,"y":975.53,"width":36.15,"height":36.15}}],"isDebug":true}
	
	},

	preload() {
		const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
		console.log(' in preload preloadArr: ', preloadArr);
		cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {
			console.log(' preload data, ', data);


			this.addServerListener();
			// if (window && window["air"]) {
			// 	window["air"].hideAirClassLoading();
			// }
		});
	},

	addServerListener() {
		
		if (window && window["air"]) {
			// cc.find('Canvas').opacity = 0;
			// window.air.onCourseInScreen = (next) => {
			// 	//  cc.find('Canvas').opacity = 255;
			// 	this.loadEnd();
			// 	next();
			// }
			this.loadEnd();
			window.air.hideAirClassLoading();
		} else {
			this.loadEnd();
		}


		if (window.air) {

			window.air.osmoHandwritingCallback = (data) => {

				if (!data) {
					console.log('data is not exist!!!');
					return;
				}

				console.log('osmoHandwritingCallback data: ', data);

				if (typeof (data) == 'string') {
					console.log('data is string ');
					const dataObj = JSON.parse(data);

					this.photoEnd(dataObj);
					return;
				}

				// 哲学逻辑
				this.photoEnd(data);

			}

			
		}

	},

	addPreloadImage() {
	
		if (this.data.bg_pic_url) {
			this._imageResList.push({ url: this.data.bg_pic_url || ''});
		}

		if (this.data.bgItem) {
			this._imageResList.push({ url: this.data.bgItem.url || ''});
		}

		if (this.data.bgItem2) {
			this._imageResList.push({ url: this.data.bgItem2.url || ''});
		}

		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.pic_url) {
				this._imageResList.push({ url: item.pic_url || ''});
			}
		})
	},

	addPreloadAudio() {

		if (this.data.questionArr) {
			const arr = this.data.questionArr;
			for (let i=0 ;i<arr.length; i++) {
				this._audioResList.push({url: arr[i].audio_url || ''});
				this._audioResList.push({url: arr[i].video_url || ''});
			}
		}

	},

	addPreloadAnima() {
		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.skeJsonData) {
				this._animaResList.push({ url: item.skeJsonData.url || '' });
				this._animaResList.push({ url: item.texJsonData.url || ''});
				this._animaResList.push({ url: item.texPngData.url || ''});
			}
		})
	},

	loadEnd() {
		console.log(' in loadEnd');

		// this.data.isDebug = true;

		this.initData();
		this.initView();
		// this.initMusic();

		// this.startTesting();

		// cc.debug.setDisplayStats(true);

	},

	initMusic() {
		cc.assetManager.loadRemote(this.data.bg_audio_url, (err, clip) => {
			cc.audioEngine.setMusicVolume(0.3);
			const audioID = cc.audioEngine.playMusic(clip, true);
		});
	},

	curGroupIndex: null,
	curQuestionIndex: null,
	curQuestionData: null,

	picNodeArr: null,


	firstItemData: null,
	bottomItemData: null,
	animaNodeArr: null,
	circleAnimaNodeArr: null,
	signAnimaNodeArr: null,

	initData() {
		console.log(' in initData');

		// this.curGroupIndex = 0;
		// this.curQuestionIndex = 0;
		// this.setCurGroupAndQuestion()

		// console.log('this.curQuestionData', this.curQuestionData)

		this.CHECK_TYPE_LINE = 'LINE';
		this.CHECK_TYPE_WRITE = 'WRITE';
		this.CHECK_TYPE_CIRCLE = 'CIRCLE';
		this.CHECK_TYPE_SIGN = 'SIGN';
		this.CHECK_TYPE_COLOR = 'COLOR';

		this.isHelp = false;


		this.totalLineArr = [];
		this.rectNodeArr = [];

		this.picAnimNodeArr = []
		this.colorPicNodeArr = [];

		this.animaNodeArr = [];

		this.circleAnimaNodeArr = [];
		this.signAnimaNodeArr = [];

		this.picNodeArr = [];
		this.initAudioEffect();

		this.linkRectGroup = [];

		this.centerItemArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '1');
		this.benchmark1Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '3')[0];
		this.benchmark2Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '4')[0];
		this.firstItemData = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '5')[0];

		this.lineRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '0');
		this.newRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '6');
		this.circleRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '7');
		this.signRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '8');
		this.colorRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '9');


		if (this.benchmark1Data) {
			this.initCheckBase();
		} 

		this.initTypeArr();
	},

	initTypeArr() {
		const typeArr = this.data.typeArr;
		
		console.log('this.data.typeArr: ', this.data);

		if (!this.data.firstGIdx) {
			this.data.firstGIdx = typeArr[0].gIdx;
		} else {

			if (typeArr.indexOf(this.data.firstGIdx) == -1) {
				this.data.firstGIdx = typeArr[0].gIdx;
			}


		}

		console.log('this.data.typeArr.length: ', this.data.typeArr.length);

		console.log('arr: ', JSON.stringify(this.data.typeArr));

		console.log('this.data.firstGIdx: ', this.data.firstGIdx);
		this.typeArr = [];
		const firstType = typeArr.find((t) => {
			console.log('t.gIdx: ', t.gIdx);
			return t.gIdx == this.data.firstGIdx;
		})

		const index = typeArr.indexOf(firstType);
		console.log('firstType: ', firstType);
		typeArr.splice(index, 1);

		this.typeArr = [firstType];
		this.typeArr = this.typeArr.concat(typeArr)
		this.typeArrIndex = 0;

		console.log("this.typeArr: ", this.typeArr);
	},

	initCheckBase() {


		console.log('benchmark1Data: ', this.benchmark1Data);
		console.log('benchmark2Data: ', this.benchmark2Data);
		console.log('centerItemArr: ', this.centerItemArr);

		const benchmark1Rect = this.benchmark1Data.rect;
		const benchmark2Rect = this.benchmark2Data.rect;
		
		const benchmark1CenterY = (benchmark1Rect.y + benchmark1Rect.height / 2);
		const benchmark2CenterY = (benchmark2Rect.y + benchmark2Rect.height / 2);
		
		let unitH = benchmark2CenterY - benchmark1CenterY;
		let unitW = benchmark2Rect.x + benchmark2Rect.width - benchmark1Rect.x;
		let baseX = benchmark1Rect.x;
		let baseY = benchmark1CenterY;


		if (this.firstItemData) {
			const firstItemRect = this.firstItemData.rect;
			baseX = firstItemRect.x + firstItemRect.width / 2;
			baseY = firstItemRect.y + firstItemRect.height / 2;
			unitW = benchmark1Rect.x + benchmark1Rect.width - (firstItemRect.x + firstItemRect.width / 2);
			unitH = (firstItemRect.y + firstItemRect.height / 2) - benchmark1CenterY;
		}


		for(let i=0; i<this.centerItemArr.length; i++) {

			const itemRect = this.centerItemArr[i].rect;
			const x = itemRect.x + itemRect.width / 2;
			const y = itemRect.y + itemRect.height / 2;

			const unitX = (x - baseX) / unitW;
			const unitY = (y - baseY) / unitH;
			const unitW2 = itemRect.width / unitW;
			const unitH2 = itemRect.height / unitH;


			this.centerItemArr[i].unitX = unitX;
			this.centerItemArr[i].unitY = unitY;
			this.centerItemArr[i].unitW = unitW2;
			this.centerItemArr[i].unitH = unitH2;

			// console.log('unitX: ', unitX)
			// console.log('unitY: ', unitY)
		}

		console.log('unitH: ', unitH)
		console.log('unitW: ', unitW)
		console.log('baseX: ', baseX)
		console.log('baseY: ', baseY)

	
		const centerX = this.data.bgItem2.rect.width / 2;
		this.centerUnitW = (centerX - baseX) / unitW;



	},

	getGroupArrByGIdx(arr, gIdx) {
		const groupArr = [];
		for (let i=0; i<arr.length; i++) {
			if (arr[i].gIdx == gIdx) {

				const data = JSON.parse(JSON.stringify(arr[i]));
				groupArr.push(data);
			}
		}

		return groupArr;
	},

	curGroup: null,
	setCurGroupAndQuestion() {
		this.curGroup = this.data.groupArr[this.curGroupIndex];

		if (!this.curGroup) {
			this.gameEnd();
		} else {
			this.curQuestionIndex = 0;
			this.setCurQuestionData();
		}
	},

	setCurQuestionData() {
		this.curQuestionData = this.curGroup.questionArr[this.curQuestionIndex];

		if (!this.curQuestionData) {

			this.hideVideo();
			this.showBigStar();
		}
	},

	hideVideo() {
		this.videoNode.active = false;

		this.videoNode.player.pause();
		this.videoNode.pauseBtn.active = false;
		this.videoNode.playBtn.active = true;
	},


	rightClip: null,
	wrongClip: null,
	bigStarClip: null,
	btnClip: null,
	finishClip: null,
	selectClip: null,
	starCountClip: null,
	helpClip: null,
	initAudioEffect() {
		this.rightClip = cc.find('Canvas/res/audio/right').getComponent(cc.AudioSource).clip;
		this.wrongClip = cc.find('Canvas/res/audio/wrong').getComponent(cc.AudioSource).clip;
		this.bigStarClip = cc.find('Canvas/res/audio/big_star').getComponent(cc.AudioSource).clip;
		this.btnClip = cc.find('Canvas/res/audio/btn').getComponent(cc.AudioSource).clip;
		this.finishClip = cc.find('Canvas/res/audio/finish').getComponent(cc.AudioSource).clip;
		this.selectClip = cc.find('Canvas/res/audio/select').getComponent(cc.AudioSource).clip;
		this.starCountClip = cc.find('Canvas/res/audio/star_count').getComponent(cc.AudioSource).clip;

		
		this.helpClip = cc.find('Canvas/res/audio/help').getComponent(cc.AudioSource).clip;
	},



	initView() {

		console.log(' in initView');

		this.initBg();
		this.initHotZone();
		this.initDebugLayer();

		console.log(' in initView 2');

	
		this.initCat();
	
	},


	initCat() {

		const cat = cc.find("Canvas/catNode/cat")
		cat.parent.zIndex = 10;
		this.cat = cat;

		this.canTouch = false;
		this.playCatAudio(this.data.begin_audio_url, () => {
			this.canTouch = true;
			// this.isPanelMoveEnd = true;

			this.catBeginEnd = true;
			this.checkStart();
		});

		this.curCatAudioUrl = this.data.idle_audio_url;

		const clickBox = cc.find("Canvas/catNode/clickBox")
		clickBox.on('touchstart', () => {

			console.log(' in cat touchstart')

			let url = this.curCatAudioUrl;
			if (!url) {
				return;
			}
 
			if (!this.canTouch) {
				return;
			}
			
			this.canTouch = false;

			this.playCatAudio(url, () => {
				this.canTouch = true;
			})

		})
	},

	playCatAudio(audioUrl, cb=null) {

		console.log('_ playCatAudio:  ', audioUrl);

		if (this.curCatAudioId) {
			cc.audioEngine.pauseEffect(this.curCatAudioId);
		}

		if (audioUrl) {

			this.playCatAnim('begin');
			playAudioByUrl(audioUrl, () => {
				this.playCatAnim('normal');
				cb && cb();
			})
		} else {
			cb && cb();

		}
		
	},

	playCatAnim(name, times = 0) {
		const cat = cc.find("Canvas/catNode/cat")		
		var dragonDisplay = cat.getComponent(dragonBones.ArmatureDisplay);
		const state = dragonDisplay.playAnimation(name, times);
	},
	


	initTestPointArr() {
		
		const linkeItemArr = this.data.hotZoneItemArr.filter(hzItem => {
			return hzItem.gIdx == '0';
		})

		const bgRect = this.data.bgItem2.rect;

		const setDebugCenterPos = (hzItem) => {

			const debugItemIndex = (Number(hzItem.pointItem) - 1) 
			const debugItem = this.data.hotZoneItemArr2[debugItemIndex];
			const {rect} = debugItem

			const left = Math.round( (rect.x ) / bgRect.width  * 1000 ) / 1000;
			const right =  Math.round( (rect.x + rect.width) / bgRect.width * 1000 ) / 1000;
			const top =  Math.round( (rect.y ) / bgRect.height * 1000 ) / 1000;
			const bottom =  Math.round( (rect.y + rect.height) / bgRect.height * 1000 ) / 1000;
	
			
			const x = left + (right - left) / 2;
			const y = bottom - (bottom - top) / 2;

			hzItem.debugCenterPos = [x, y];
		}

		console.log('linkeItemArr: ', linkeItemArr);

		linkeItemArr.forEach(hzItem => {
			return setDebugCenterPos(hzItem);
		})

		const startPosObj = {};
		const endPosObj = {};

		for (let i=0; i<linkeItemArr.length; i++) {
			const index = this.data.hotZoneItemArr.indexOf(linkeItemArr[i]);
			const key = (index + 1).toString();
			if (!startPosObj[key] && !endPosObj[key]) {
				startPosObj[key] = linkeItemArr[i];


				const endKey = linkeItemArr[i].linkItem.toString();
				const endIndex = Number(endKey) - 1;
				const endItem = this.data.hotZoneItemArr[endIndex];
				endPosObj[endKey] = endItem;
			}
		}

		console.log('startPosObj: ', startPosObj);
		console.log('endPosObj: ', endPosObj);

		
		console.log('this.end_points: ', this.end_points);

	
	},

	checkStart() {

		console.log(' in checkStart')
		if (this.debugBgImg && this.hzLoadEnd && this.catBeginEnd) {
			this.startTesting();
		}

	},

	getSendCirclePoints(tempCirclePointArr) {

		console.log('tempCirclePointArr: ' , tempCirclePointArr);


		
		const sendCirclePointArr = [];

		for (let i=0; i<tempCirclePointArr.length; i++) {
			const {left, top, right, bottom} = tempCirclePointArr[i];

			const newLeft = left + (right - left) / 2;
			const newTop = top + (bottom - top) / 2;
			const data = {
				left: newLeft,
				right: newLeft,
				top: newTop,
				bottom: newTop
			}

			sendCirclePointArr.push(data);
			// const tempLink1 = tempCirclePointArr[i];
			// const key2 = tempLink1.linkItem;
			// const tempLink2 = tempCirclePointArr[Number(key2)-1];

			// if (!tempLink1.isGetLinked && !tempLink2.isGetLinked) {
			// 	tempLink1.isGetLinked = true;
			// 	tempLink2.isGetLinked = true;

			// 	const pKey1 = tempLink1.pointItem;
			// 	const pKey2 = tempLink2.pointItem;

			// 	const pointItem1 = this.data.hotZoneItemArr2[Number(pKey1) - 1];
			// 	const pointItem2 = this.data.hotZoneItemArr2[Number(pKey2) - 1];

			// 	const region1 = this.getRegionByRect(pointItem1.rect, bgRect);
			// 	const region2 = this.getRegionByRect(pointItem2.rect, bgRect);

			// 	let x1 = region1.left + (region1.right - region1.left) / 2;
			// 	let y1 = region1.top + (region1.bottom - region1.top) / 2;

			// 	let x2 = region2.left + (region2.right - region2.left) / 2;
			// 	let y2 = region2.top + (region2.bottom - region2.top) / 2;

			// 	x1 = Math.floor(x1 * 1000) / 1000;
			// 	y1 = Math.floor(y1 * 1000) / 1000;
			// 	x2 = Math.floor(x2 * 1000) / 1000;
			// 	y2 = Math.floor(y2 * 1000) / 1000;

			// 	sendCirclePointArr.push( {left:x1, top: y1, right:x2, bottom: y2} )
			// }
		}

		console.log("sendCirclePointArr: ", sendCirclePointArr);
		return sendCirclePointArr;
	},


	getSendLinePoints() {

		const hotZoneItemArr = JSON.parse( JSON.stringify(this.data.hotZoneItemArr) );

		const tempLinkArr = this.getGroupArrByGIdx(hotZoneItemArr, '0');

		console.log('tempLinkArr: ' , tempLinkArr);

		const bgRect = this.data.bgItem2.rect;
		
		const sendLinkPointArr = [];


		for (let i=0; i<tempLinkArr.length; i++) {
			const tempLink1 = tempLinkArr[i];
			const key2 = tempLink1.linkItem;
			const tempLink2 = hotZoneItemArr[Number(key2)-1];

			if (!tempLink1.isGetLinked && !tempLink2.isGetLinked) {
				tempLink1.isGetLinked = true;
				tempLink2.isGetLinked = true;

				const pKey1 = tempLink1.pointItem;
				const pKey2 = tempLink2.pointItem;

				const pointItem1 = this.data.hotZoneItemArr2[Number(pKey1) - 1];
				const pointItem2 = this.data.hotZoneItemArr2[Number(pKey2) - 1];

				const region1 = this.getRegionByRect(pointItem1.rect, bgRect);
				const region2 = this.getRegionByRect(pointItem2.rect, bgRect);

				let x1 = region1.left + (region1.right - region1.left) / 2;
				let y1 = region1.top + (region1.bottom - region1.top) / 2;

				let x2 = region2.left + (region2.right - region2.left) / 2;
				let y2 = region2.top + (region2.bottom - region2.top) / 2;

				x1 = Math.floor(x1 * 1000) / 1000;
				y1 = Math.floor(y1 * 1000) / 1000;
				x2 = Math.floor(x2 * 1000) / 1000;
				y2 = Math.floor(y2 * 1000) / 1000;

				sendLinkPointArr.push( {left:x1, top: y1, right:x2, bottom: y2} )
			}
		}

		console.log("sendLinkPointArr: ", sendLinkPointArr);
		return sendLinkPointArr;

		// for (let i=0; i<regions.length; i++) {
		// 	const oneRegion = regions[i];
		// 	console.log('oneRegion: ', oneRegion);
		// 	const x = oneRegion.left + (oneRegion.right - oneRegion.left) / 2;
		// 	const y = oneRegion.top + (oneRegion.bottom - oneRegion.top) / 2;
		// }
	},


	resetHelperTime() {

		this.helperTime = new Date().getTime();

	},

	showHelper() {

		if (!this.isHelp) {
			return;
		}
		console.log("in showHelper");

		playAudio(this.helpClip, () => {

			switch(this.curCheckGroup) {
				case this.CHECK_TYPE_LINE:
					this.showHelperLink();
					// 连线
					break;
	
				case this.CHECK_TYPE_WRITE:
					this.showHelperWrite();
					// 手写
					break;
	
				case this.CHECK_TYPE_CIRCLE:
					this.showHelperCircle();
					// 画圈
					break;
	
				case this.CHECK_TYPE_SIGN:
					this.showHelperSign();
					// 符号
					break;
			}

		})

		
	},

	showHelperSign() {

		for (let i = 0; i < this.signAnimaNodeArr.length; i++) {

			const animaNode = this.signAnimaNodeArr[i];

			if (!animaNode.isShowEnd) {
		
				this.showSign(animaNode);
				break;
			}
			
		}
	},
	

	showHelperCircle() {
		
		for (let i = 0; i < this.circleAnimaNodeArr.length; i++) {

			const animaNode = this.circleAnimaNodeArr[i];

			if (!animaNode.isShowEnd) {

				this.showCircle(animaNode);
				break;				
			}
			
		}

	},

	showHelperWrite() {

		let arr = this.animaNodeArr;
		if (this.picAnimNodeArr.length > 0) {
			arr = this.picAnimNodeArr;
		}

		for (let i = 0; i < arr.length; i++) {

			const animaNode = arr[i];
			if (!animaNode.isShowEnd) {

				if (this.picAnimNodeArr.length > 0) {
					this.showLetterPic(animaNode);
				} else {
					this.showLetter(animaNode);
				}
				break;
			}
		}
	},

	
	showHelperLink() {

		console.log(' in showHelperLink..');
		
		let item;
		for (let i=0; i<this.linkRectGroup.length; i++) {

			const {hzItemId} = this.linkRectGroup[i].linkData;

			const rectNode = this.getItemById(hzItemId);
			
			if (!rectNode.isShowEnd && this.linkRectGroup[i].isRightPoint) {
				item = this.linkRectGroup[i];
				break;
			}
		}

		if (item) {
			const {hzItemId, linkHzItemId} = item.linkData
			this.showSuccess(hzItemId, linkHzItemId);
		}
	},


	startHelper() {

		this.resetHelperTime();
		this.isHelpCountDown = true;

		const checkTime = () => {

			if (!this.isHelpCountDown) {
				return;
			}

			const curTime = new Date().getTime();
			if (curTime - this.helperTime > 10 * 1000) {
				this.showHelper();
				this.resetHelperTime();
			} 
			// else {
	
			// 	delayCall(0.1, () => {
			// 		checkTime();
			// 	})
			// }

			delayCall(0.05, () => {
				checkTime();
			})
		}

		checkTime();
		
	},

	stopHelper() {
		this.isHelpCountDown = false;
	},


	//调起检测
	startTesting() {

		this.isGameEnd = false;

		this.startHelper();


		const writeRegions = this.getRegionsByGidx('6')
		const circleRegions = this.getRegionsByGidx('7')
		const signRegions = this.getRegionsByGidx('8')
		const colorRegions = this.getRegionsByGidx('9')

		// this.changeRegionTo4Pos(signRegions);


		// let lineRegions = this.getRegionsByGidx('0')

		const newPoints = this.getSendLinePoints();
		const newCirclePoints = this.getSendCirclePoints(circleRegions);

		console.log('writeRegions: ', writeRegions);
		console.log('circleRegions: ', circleRegions);
		console.log('newPoints: ', newPoints);
		console.log('signRegions: ', JSON.stringify(signRegions));
		console.log('newCirclePoints: ', newCirclePoints);

		

	 

		// const tempType = this.typeArr[this.typeArrIndex];
		// this.curCheckType = '';
		// switch(tempType.gIdx) {
		// 	case "0":
		// 		// 连线
		// 		this.curCheckGroup = this.CHECK_TYPE_LINE;
		// 		break;

		// 	case "1":
		// 		// 手写
		// 		this.curCheckGroup = this.CHECK_TYPE_WRITE;
		// 		break;

		// 	case "2":
		// 		// 画圈
		// 		this.curCheckGroup = this.CHECK_TYPE_CIRCLE;
		// 		break;

		// 	case "4":
		// 		// 符号
		// 		this.curCheckGroup = this.CHECK_TYPE_SIGN;
		// 		break;

		// 	case "5":
		// 		// 涂色
		// 		this.curCheckGroup = this.CHECK_TYPE_COLOR;
		// 		break;
		// 	}

		// 	// setInterval(() => {
		// 		this.getPhotoData((data) => { 
		// 			this.photoEnd(data);
		// 		});    
		// 	// }, 3000);

		// 	console.log('curCheckGroup: ', JSON.stringify( this.curCheckGroup ));

		// return;





		// write_regions : []

		let lineType = 1;
		let circleSize = 1;

		if (this.data.lineType == '0') {
			lineType = 0;
		}
		if (this.data.circleSize == '0') {
			circleSize = 0;
		}
		
		

		const para = {
			"library_id": "iplayabc",
			"page_id": this.data.page_id, //27,
			"book_id": this.data.book_id,//"opw1",
			"part_name": this.data.part_name, //"d",
		
			"write_regions": [],
			"circle_regions": [],//circleRegions,
			"line_regions": [],
			'sign_regions': [],
			'color_regions': [],
			lineType,
			circleSize
		}

		const curCheckGroup = this.typeArr[this.typeArrIndex];
		this.curCheckType = '';
		switch(curCheckGroup.gIdx) {
			case "0":
				// 连线
				para.line_regions = newPoints;
				this.curCheckGroup = this.CHECK_TYPE_LINE;
				break;

			case "1":
				// 手写
				para.write_regions = writeRegions;
				this.curCheckGroup = this.CHECK_TYPE_WRITE;
				break;

			case "2":
				// 画圈
				para.circle_regions = newCirclePoints;
				this.curCheckGroup = this.CHECK_TYPE_CIRCLE;
				break;

			case "4":
				// 符号
				para.sign_regions = signRegions;
				this.curCheckGroup = this.CHECK_TYPE_SIGN;
				break;

			case "5":
				// 涂色
				para.color_regions = colorRegions;
				this.curCheckGroup = this.CHECK_TYPE_COLOR;
				break;
				
			case "6":
				// 手写图片
				para.write_regions = writeRegions;
				this.curCheckGroup = this.CHECK_TYPE_WRITE;
				break;
		}


		console.log('curCheckGroup: ', JSON.stringify( this.curCheckGroup ));
		console.log('para: ', JSON.stringify( para ));


		const cw = window.courseware;
		if (!cw || !cw.openOsmoHandwriting) {

			console.log('cw.openOsmoHandwriting not exist');
			return;
		}

		cw.openOsmoHandwriting(para);


	},

	//结束检测
	endTesting() {
		
		this.stopHelper();

		const cw = window.courseware;
		if (!cw || !cw.closeOsmoHandwriting) {

			return;
		}
		cw.closeOsmoHandwriting();

		// const cw = window.courseware;
		// if (!cw || !cw.closeOsmoHandwritingMlkit) {

		// 	return;
		// }
		// cw.closeOsmoHandwritingMlkit();
		// // this.isTesting = false;
	},

	changeRegionTo4Pos(regions) {

		for (let i=0; i<regions.length; i++) {
			const {left, top, right, bottom} = regions[i];
			regions[i] = [

					left, top,
					right, top,
					right, bottom,
					left, bottom

			]
		}
		
	},

	getRegionsByGidx(gIdx) {

		const arr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, gIdx);
		const bgRect = this.data.bgItem2.rect;
		
		console.log("arr:", arr);
		const newLocationArr = [];
		for (let i=0; i<arr.length; i++) {

			const hzItem = arr[i];
			const regionRect = hzItem.rect;

			const region = this.getRegionByRect(regionRect, bgRect);

			newLocationArr.push(region)
		}

		return newLocationArr;

	},

	getRegionByRect(regionRect, bgRect) {

		const left = Math.round( (regionRect.x ) / bgRect.width  * 1000 ) / 1000;
		const right =  Math.round( (regionRect.x + regionRect.width) / bgRect.width * 1000 ) / 1000;
		const top =  Math.round( (regionRect.y ) / bgRect.height * 1000 ) / 1000;
		const bottom =  Math.round( (regionRect.y + regionRect.height) / bgRect.height * 1000 ) / 1000;

		return {left, top, right, bottom};
	},



	changeWriteData(result) {
		const curTextArr = result.text;
		const bboxTextArr = [];
		for (let i=0; i<curTextArr.length; i++) {

			const score = curTextArr[i].score;

			const {left, right, top, bottom} = curTextArr[i];
			const text = curTextArr[i].content;

			console.log('text..', JSON.stringify( curTextArr[i] ));
			console.log('text..', text);
			const disW = (right - left) / text.length;
			const disH = (bottom - top);
			for (let j=0; j<text.length; j++) {

				const x1 = left + j * disW;
				const y1 = top;

				const x2 = x1 + disW;
				const y2 = y1;

				const x3 = x2;
				const y3 = y2 + disH;

				const x4 = x1;
				const y4 = y3;

				// const bbox = [{x1, y1}, {x2, y2}, {x3, y3}, {x4, y4}]
				const bbox = {left: x1, right: x2, top: y1, bottom: y3}


				// this.changeBboxPos(bbox);

				const content = text[j];
				bboxTextArr.push({bbox, content, score});
			}

		}

		result.text = bboxTextArr;

	},


	locate(x1, y1, x2, y2, x3, y3) {
			var a, b;
			a = (y2 - y1) / (x2 - x1);
			b = y1 - a * x1;

			var xMiddle = (x1 + x2) / 2;
			var yMiddle = (y1 + y2) / 2;
			var c, lastX, lastY;
			if (a != 0) {
					c = yMiddle - (-1 / a) * xMiddle;
					lastX = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) - 2 * c * y1 + 2 * c * y3) / (2 * ((x1 - x3) - (1 / a) * (y1 - y3)));
					lastY = (-1 / a) * lastX + c;
			} else {
					lastX = c = xMiddle;
					lastY = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) + 2 * lastX * (x3 - x1)) / (2 * (y1 - y3));
			}
			console.log("定位点X坐标: " + lastX);
			console.log("定位点Y坐标: " + lastY);

			return {x: lastX, y: lastY};
	},

	

	setOneAnswerDataCircle(colorRect, answerData) {
		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);


		// const targetLabelText = colorRect.labelText;

		// const newRectCheckArr = this.newRectCheckArr;
		const checkArr = this.circleRectCheckArr;

		for (let i=0; i<checkArr.length; i++) {

			const checkRect = checkArr[i].ccRect;
			const key = checkArr[i].data.index + 1;

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (checkRect.contains(dotV2)) {

				answerData[key] = {isFinish: true};

			}

		}

	},


	setOneAnswerDataLink(firstPos, lastPos, answerData) {


		const w = this.debugLayer.width;
    const h = this.debugLayer.height;
    const checkP1 = cc.v2(firstPos.x * w, -firstPos.y * h);
    const checkP2 = cc.v2(lastPos.x * w, -lastPos.y * h);



		let firstPosRectId = -1;
		let lastPosRectId = -1;

		const worldPos1 = this.debugLayer.convertToWorldSpaceAR(cc.v2(checkP1.x, checkP1.y));
		const worldPos2 = this.debugLayer.convertToWorldSpaceAR(cc.v2(checkP2.x, checkP2.y));


		// console.log('worldPos1: ', JSON.stringify(worldPos1));
		// console.log('worldPos2: ', JSON.stringify(worldPos2));

		for (let i=0; i<this.linkRectGroup.length; i++) {
			const rect = this.linkRectGroup[i].ccRect;

			// console.log('rect: ', JSON.stringify(rect));


      if (rect.contains(worldPos1)) {
        firstPosRectId = i;
        // break;
			} 
      if (rect.contains(worldPos2)) {
        lastPosRectId = i;
        // break;
			} 
		}

		console.log('firstPosRectId: ', firstPosRectId);
		console.log('lastPosRectId: ', lastPosRectId);

		if (firstPosRectId != -1 && lastPosRectId != -1 && firstPosRectId != lastPosRectId) {

      answerData[firstPosRectId.toString()] = [firstPosRectId, lastPosRectId];
      this.addDebugLayerDot(checkP1.x, checkP1.y, 10, cc.Color.GREEN);
      this.addDebugLayerDot(checkP2.x, checkP2.y, 10, cc.Color.GREEN);
    }

	},

	addDebugLayerDot(x, y, r=10, color = null) {
    const dotNode = new cc.Node();

    const ctx = dotNode.addComponent(cc.Graphics);
    ctx.fillColor = color || cc.Color.BLUE;
    ctx.circle(x, y, r);
    ctx.fill();

    this.debugDrawLayer.addChild(dotNode);

    const w = this.debugLayer.width;
    const h = this.debugLayer.height;
    const rateX = x / w;
    const rateY = y / h;
    
    console.log('ratePos: {x: ' + rateX + ', y: ' + rateY + '}')
  },

	photoEndLineRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}



		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const points = oneTextData.points;

			const point1_x = points[0];
			const point1_y = points[1];
			const point2_x = points[2];
			const point2_y = points[3];

			// const rect1 = {
			// 	x:point1_x,
			// 	y: -point1_y,
			// 	width: 0.01,
			// 	height: 0.01
			// }

			// const colorRect1 = this.getColorDot(rect1.x, rect1.y, rect1.width, rect1.height, "purple");
			// this.debugDrawLayer.addChild(colorRect1, 1);
		

			// const rect2 = {
			// 	x:point2_x,
			// 	y: -point2_y,
			// 	width: 0.01,
			// 	height: 0.01
			// }

			// const colorRect2 = this.getColorDot(rect2.x, rect2.y, rect1.width, rect1.height, "purple");
			// this.debugDrawLayer.addChild(colorRect2, 1);

			this.drawUserLine([{x:point1_x, y: point1_y}, {x: point2_x, y: point2_y}]);

			this.setOneAnswerDataLink({x:point1_x, y: point1_y}, {x: point2_x, y: point2_y}, answerData);
		}


		this.showLinkAnswer(answerData);
	},

	drawUserLine(path) {
		this.drawOnePath(path);
	},

	drawOnePath(path) {
    const lineNode = new cc.Node();
    this.debugDrawLayer.addChild(lineNode);

    const w = this.debugLayer.width;
    const h = this.debugLayer.height;



    const subY = 0; //-canvas.height / 2;
    const ctx = lineNode.addComponent(cc.Graphics);
    ctx.lineWidth = 10;
    ctx.strokeColor = cc.Color.RED;
    ctx.fillColor = cc.Color.BLACK;
    

    ctx.moveTo(path[0].x * w, -path[0].y * h + subY);

    for (let i = 1; i < path.length; i++) {
      const x = path[i].x * w;
      const y = -path[i].y * h + subY;

      ctx.lineTo(x, y);
    }
    ctx.stroke();
  },

	showLinkAnswer(answerData) {

    for (let key in answerData) {

      const tempArr = answerData[key];

      const firstItemIndex = tempArr[0];
      const lastItemIndex = tempArr[1];

			const debugFirstItem = this.linkRectGroup[firstItemIndex];
			const debugLastItem = this.linkRectGroup[lastItemIndex];

			console.log('linkdebugId: ', debugFirstItem.linkData.linkDebugItemId);
			console.log('debugLastItem.linkData.debugItemId: ', debugLastItem.linkData.debugItemId)
			console.log('debugFirstItem.isRightPoint: ', debugFirstItem.isRightPoint)

			const hzItemIdFirst = debugFirstItem.linkData.hzItemId
			const hzItemIdLast = debugLastItem.linkData.hzItemId
			const startItem = this.getItemById(hzItemIdFirst);
			const endItem = this.getItemById(hzItemIdLast);
			if (startItem.isShowEnd || endItem.isShowEnd) {
				return;
			}

			if ((startItem.isRightPoint && endItem.isRightPoint) && debugFirstItem.linkData.linkDebugItemId == debugLastItem.linkData.debugItemId) {
				
				const {hzItemId, linkHzItemId} = debugFirstItem.linkData
				this.showSuccess(hzItemId, linkHzItemId);

			} else {			

			}

    }


		// for (let key in answerData) {

    //   const tempArr = answerData[key];

    //   const firstItemIndex = tempArr[0];
    //   const lastItemIndex = tempArr[1];

		// 	const debugFirstItem = this.linkRectGroup[firstItemIndex];
		// 	const debugLastItem = this.linkRectGroup[lastItemIndex];

		// 	console.log('linkdebugId: ', debugFirstItem.linkData.linkDebugItemId);
		// 	console.log('debugLastItem.linkData.debugItemId: ', debugLastItem.linkData.debugItemId)
		// 	console.log('debugFirstItem.isRightPoint: ', debugFirstItem.isRightPoint)

		// 	const hzItemIdFirst = debugFirstItem.linkData.hzItemId
		// 	const hzItemIdLast = debugLastItem.linkData.hzItemId
		// 	const startItem = this.getItemById(hzItemIdFirst);
		// 	const endItem = this.getItemById(hzItemIdLast);
		// 	if (startItem.isShowEnd || endItem.isShowEnd) {
		// 		return;
		// 	}

		// 	if (debugFirstItem.isRightPoint && debugFirstItem.linkData.linkDebugItemId == debugLastItem.linkData.debugItemId) {
				
		// 		// const {hzItemId, linkHzItemId} = debugFirstItem.linkData
		// 		// this.showSuccess(hzItemId, linkHzItemId);

		// 	} else {			

				
		// 		this.showFail(hzItemIdFirst, hzItemIdLast);
		// 		this.playCatAudio(this.data.error_link_audio_url);

		// 	}

    // }


  },

	showSuccess(startItemId, endItemId) {

		console.log( ' in showSuccess');

		const startItem = this.getItemById(startItemId);
		const endItem = this.getItemById(endItemId);

		if (startItem.isShowEnd || endItem.isShowEnd) {
			return;
		}
		startItem.isShowEnd = true;
		endItem.isShowEnd = true;

		const isLinked = this.checkIsLinked(startItem, endItem);
		if (isLinked) {
			return;
		}

		this.addLinkItem(startItem, endItem);
		this.addLinkItem(endItem, startItem);


		const pos1 = startItem.getPosition();
		pos1.x += startItem.width / 2;
		pos1.y += startItem.height / 2;
		const pos2 = endItem.getPosition();
		pos2.x += endItem.width / 2;
		pos2.y += endItem.height / 2;

		const greenColor = new cc.Color();
		greenColor.fromHEX("#519F00"); 
		const line = this.getLine(pos1, pos2, greenColor);
		this.addLinkLine(startItem, endItem, line);
		line.isRight = true;

		const maskNode = new cc.Node();
		maskNode.width = 0;
		maskNode.height = 0;
		maskNode.x = pos1.x;
		maskNode.y = pos1.y;
		this.hotZoneBg.addChild(maskNode);


		const mask = maskNode.addComponent(cc.Mask);
		mask.type = cc.Mask.Type.ELLIPSE;
		mask.segments = 32;

		maskNode.addChild(line);
		// line.mask = mask;

		this.isCurLinked = true;

		cc.tween(maskNode)
			.to(1.5, {width: this.canvas.width * 2, height: this.canvas.height * 2}, {easing: 'sineOut'})
			.call(() => {
				maskNode.removeComponent(cc.Mask);
			})
			.start();
		
		playAudio(this.rightClip, () => {
			
		})
		
		if (!this.isGameEnd) {
			const arr = this.rectNodeArr.filter((r) => {
				return r.isRightPoint == true;
			})
			this.checkGameEnd(arr);
		}
	},

	addLinkLine(item1, item2, line) {
		if ( !item1.lineArr ) {
			item1.lineArr = [];
		}

		if (!item2.lineArr) {
			item2.lineArr = [];
		}
		
		item1.lineArr.push(line);
		item2.lineArr.push(line);
		line.itemArr = [item1, item2];
		this.totalLineArr.push(line);
	},

	checkIsLinked(startItem, endItem) {
		const linkItemArr1 = startItem.linkItemArr || [];
		const linkItemArr2 = endItem.linkItemArr || [];

		return (linkItemArr1.indexOf(endItem) != -1 && linkItemArr2.indexOf(startItem) != -1);
	},

	addLinkItem(item, linkItem) {
		if (!item.linkItemArr) {
			item.linkItemArr = [];
		}

		if (item.linkItemArr.indexOf(linkItem) == -1) {
			item.linkItemArr.push(linkItem);
		}
	},

	getLine(item1, item2, color=cc.Color.BLACK) {
		const lineNode = new cc.Node();


		const ctx = lineNode.addComponent(cc.Graphics);
		ctx.lineWidth = 5;
    ctx.strokeColor = color;
    ctx.fillColor = color;

    ctx.moveTo(0, 0);
		ctx.lineTo(item2.x - item1.x, item2.y - item1.y);
		ctx.stroke();

		const dot1 = this.getDot(0, 0, ctx.lineWidth/2, ctx.strokeColor);
		dot1.parent = lineNode;

		const dot2 = this.getDot(item2.x - item1.x, item2.y - item1.y, ctx.lineWidth/2, ctx.strokeColor);
		dot2.parent = lineNode;

		return lineNode;
	},

	getDot(x, y, r, color) {

		const dotNode = new cc.Node();

    const ctx = dotNode.addComponent(cc.Graphics);
    ctx.fillColor = color || cc.Color.BLUE;
    ctx.circle(x, y, r);
    ctx.fill();

		return dotNode;
	},


	getItemById(id) {

		console.log('getItemById id:', id);
		console.log('this.rectNodeArr: ', this.rectNodeArr);

		const targetItem = this.rectNodeArr.find( node => {

			const data = node.data;

			console.log('data~~: ', JSON.stringify(data));


			if (data && (data.index + 1 == id)) {
				return true;
			}
		})
		return targetItem;
	},

	photoEndColorRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			console.log(' photoEndColorRect 1')
			return;
		}

		const {colors, points} = textArr[0]
		if (!colors || !points) {
			console.log(' photoEndColorRect 2')
			return;
		}



		for (let i=0; i<this.colorRectCheckArr.length; i++) {
			const leftEdgeX = this.colorRectCheckArr[i].x / this.debugBgImg.width;
			const rightEdgeX = (this.colorRectCheckArr[i].x + this.colorRectCheckArr[i].width * this.colorRectCheckArr[i].scaleX) / this.debugBgImg.width;
			// const topEdgeY = (this.debugBgImg.height + this.colorRectCheckArr[i].y - this.colorRectCheckArr[i].height)  / this.debugBgImg.height;
			const topEdgeY = -(this.colorRectCheckArr[i].y + this.colorRectCheckArr[i].height * this.colorRectCheckArr[i].scaleY)  / this.debugBgImg.height;
			// const bottomEdgeY = (this.debugBgImg.height + this.colorRectCheckArr[i].y)  / this.debugBgImg.height;
			const bottomEdgeY = -(this.colorRectCheckArr[i].y)  / this.debugBgImg.height;
			

			console.log("leftEdgeX: ", leftEdgeX);
			console.log("rightEdgeX: ", rightEdgeX);
			console.log("topEdgeY: ", topEdgeY);
			console.log("bottomEdgeY: ", bottomEdgeY);

			this.colorRectCheckArr[i].leftEdgeX = leftEdgeX
			this.colorRectCheckArr[i].rightEdgeX = rightEdgeX
			this.colorRectCheckArr[i].topEdgeY = topEdgeY
			this.colorRectCheckArr[i].bottomEdgeY = bottomEdgeY
			this.colorRectCheckArr[i].colorPoints = [];
		}
		
		for (let i=0; i<points.length; i+=2) {
			const pointX = points[i];
			const pointY = points[i+1];
			const color = colors[i/2];


			for (let j=0; j<this.colorRectCheckArr.length; j++) {
			
				const {leftEdgeX,rightEdgeX, topEdgeY, bottomEdgeY} = this.colorRectCheckArr[j];

				if (pointX < leftEdgeX) {
					// console.log(' return ~ 1');
					continue;
				}
				if (pointX > rightEdgeX) {
					// console.log(' return ~ 2');
					continue;
				}
				if (pointY < topEdgeY) {
					// console.log(' return ~ 3');
					continue;
				}
				if (pointY > bottomEdgeY) {
					// console.log(' return ~ 4');
					continue;
				}
		
				
				this.colorRectCheckArr[j].colorPoints.push({pointX, pointY, color});


				// const colorNode = this.getCustomColorDot(pointX, -pointY, 0.01, 0.01);

				// const ccColor = new cc.Color();
				// ccColor.r = color[0]
				// ccColor.g = color[1]
				// ccColor.b = color[2]
				// colorNode.colorDot.color = ccColor;

				// console.log('~~ color: ', color);
				// this.debugDrawLayer.addChild(colorNode);
			}

		}



		const answerData = {};

		for (let i=0; i<this.colorRectCheckArr.length; i++) {

			const colorPoints = this.colorRectCheckArr[i].colorPoints;

			if (colorPoints.length == 0) {
				continue;
			}
			console.log('colorPoints: ', colorPoints);

			let r = 0;
			let g = 0;
			let b = 0;

			for (let j=0; j<colorPoints.length; j++) {
				const {color} = colorPoints[j];
				r += color[0];
				g += color[1];
				b += color[2];
			}

			r /= colorPoints.length;
			g /= colorPoints.length;
			b /= colorPoints.length;
			
			r = Math.round(r);
			g = Math.round(g);
			b = Math.round(b);

			console.log('r~:', r);
			console.log('g~:', g);
			console.log('b~:', b);

			const key = this.colorRectCheckArr[i].data.index + 1;

			if (r < 220 && g < 220 && b < 220) {
				answerData[key] = {r, g, b, isFinish:true};
			}
		}
		

		console.log('answerData: ', answerData);

		this.showColorAnswer(answerData);

	},

	showColorAnswer(answerData) {
		
		console.log('answerData: ', answerData);
		if (Object.keys(answerData).length == 0) {
			return;
		}

		for (let i = 0; i < this.colorPicNodeArr.length; i++) {

			const picNode = this.colorPicNodeArr[i];

			const key = picNode.data.drawItem // i.toString();


			console.log('~picNode.data: ', picNode.data)
			console.log('~key: ', key)

			if (!picNode.hitCount) {
				picNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~show Color')
				this.showColorPic(picNode, answerData[key]);

			} else {

				picNode.hitCount = 0;
			}
		}

	},


	photoEndSignRect(data) {

		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const symbol = textArr[0]?.symbol
		if (!symbol) {
			return;
		}

		// return 
		const answerData = {};


		for (let i=0; i<this.signRectCheckArr.length; i++) {
			
			const signDebugItem = this.signRectCheckArr[i];
			const dropDownItem = signDebugItem.data.dropDownItem;

			const curSignKey = symbol[i].toString();
			
			if (dropDownItem.key == curSignKey) {


				const label = this.getLabel(dropDownItem.label, signDebugItem.ccRect.width);
				label.x = signDebugItem.x;
				label.y = signDebugItem.y;
				label.color = cc.Color.BLACK;
	
				this.debugDrawLayer.addChild(label, 2);


				const key = signDebugItem.data.index + 1;
				answerData[key] = {isFinish: true};

			}
		}

		this.showSignAnswer(answerData);

		return ;

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];

			const signId = '2'

			// const points = oneTextData.points;

			// const tempDisNum = Math.floor(points.length / 2);
			// const point1_x = points[0];
			// const point1_y = points[1];
			// const point2_x = points[tempDisNum];
			// const point2_y = points[tempDisNum + 1];

			// let centerPX = Number(point1_x) + (point2_x - point1_x) / 2;
			// let centerPY = Number(point1_y) + (point2_y - point1_y) / 2;

			// console.log('centerPX: ' ,centerPX);
			// console.log('centerPY: ' ,centerPY);

			// const colorRect = this.getColorDot(centerPX, -centerPY, 0.02, 0.02, "purple");
			// this.debugDrawLayer.addChild(colorRect, 1);


			// this.setOneAnswerDataCircle(colorRect, answerData);

		}

		console.log('answerData: ' , answerData);


		// this.showCircleAnswer(answerData);

	},

	showSignAnswer(answerData) {

		console.log('answerData: ', answerData);
		if (Object.keys(answerData).length == 0) {
			return;
		}

		console.log("signAnimaNodeArr: ", this.signAnimaNodeArr);

		for (let i = 0; i < this.signAnimaNodeArr.length; i++) {

			const animaNode = this.signAnimaNodeArr[i];

			const key = animaNode.data.signItem // i.toString();


			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showSign')
				this.showSign(animaNode);

			} else {

				animaNode.hitCount = 0;
			}
		}

	},

	showSign(node, isRight = true) {

		console.log('in showCircle 1');


		node.hitCount++;
		if (node.hitCount < 1) {
			return;
		}


		console.log('in showCircle 2');


		if (node.isShowEnd) {
			return;
		}

		console.log('in showCircle 3');

		node.isShowEnd = true;
		node.isRight = isRight;


		// node.playRightAnim();
		this.playRightAnim(node);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.signAnimaNodeArr);
		}

		return;

	},

	photoEndCircleRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const points = oneTextData.points;

			const tempDisNum = Math.floor(points.length / 2);
			const point1_x = points[0];
			const point1_y = points[1];
			const point2_x = points[tempDisNum];
			const point2_y = points[tempDisNum + 1];
			// const point3_x = points[tempDisNum*2];
			// const point3_y = points[tempDisNum*2 + 1];

			// let centerP = this.locate(point1_x, point1_y, point2_x, point2_y, point3_x, point3_y);
			let centerPX = Number(point1_x) + (point2_x - point1_x) / 2;
			let centerPY = Number(point1_y) + (point2_y - point1_y) / 2;

			console.log('centerPX: ' ,centerPX);
			console.log('centerPY: ' ,centerPY);


			const colorRect = this.getColorDot(centerPX, -centerPY, 0.02, 0.02, "purple");
			this.debugDrawLayer.addChild(colorRect, 1);


			this.setOneAnswerDataCircle(colorRect, answerData);


			// console.log('points: ', points);
		
			// for (let j=0; j<points.length; j+=2) {
			// 	const x = points[j]//centerP.x
			// 	const y = -points[j+1]//-centerP.y
			// 	const w = 0.01;
			// 	const h = 0.01;
	
			// 	const rect = {
			// 		x, y,
			// 		width: w,
			// 		height: h
			// 	}
	

	
			// 	const colorRect = this.getColorDot(rect.x, rect.y, w, h, "red");
			// 	this.debugDrawLayer.addChild(colorRect, 1);


			// 	// this.setCirclePosInRectArr(colorRect);
				
	
			// }
		


		}

		console.log('answerData: ' , answerData);


		this.showCircleAnswer(answerData);

		// this.showUserRightNew(answerData);
	},

	showCircleAnswer(answerData) {

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.circleAnimaNodeArr.length; i++) {

			const animaNode = this.circleAnimaNodeArr[i];

			const key = animaNode.data.circleItem // i.toString();

			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showLetter')
				this.showCircle(animaNode);
				// this.showCircle2(animaNode);

			} else {

				animaNode.hitCount = 0;
			}
		}

	},

	showCircle(node, isRight = true) {

		console.log('in showCircle 1');


		node.hitCount++;
		if (node.hitCount < 1) {
			return;
		}


		console.log('in showCircle 2');


		if (node.isShowEnd) {
			return;
		}

		console.log('in showCircle 3');

		node.isShowEnd = true;
		node.isRight = isRight;



		// this.playRightAnim(node);
		this.showCircle2(node);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.circleAnimaNodeArr);
		}

		return;

	},
	

	photoEndNewRect(data) {

		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const x = oneTextData.left//oneTextData.left + (oneTextData.right - oneTextData.left) / 2;
			const y = -oneTextData.bottom//-oneTextData.top - (oneTextData.bottom - oneTextData.top) / 2;
			const w = oneTextData.right - oneTextData.left;
			const h = oneTextData.bottom - oneTextData.top;

			const rect = {
				x, y,
				width: w,
				height: h
			}

			console.log('oneTextData: ', oneTextData);

			const content = oneTextData.content;
			const colorRect = this.getColorRect(rect, "red");
			colorRect.labelText = content;
			this.debugDrawLayer.addChild(colorRect, 1);

			const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
			label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
			label.color = cc.Color.BLACK;

			this.debugDrawLayer.addChild(label, 2);

			this.setOneAnswerDataNew(colorRect, answerData);

		}

		console.log('answerData:' , answerData);
		this.showUserRightNew(answerData);
	},

	showUserRightNew(answerData) {

		if (Object.keys(answerData).length == 0) {
			return;
		}

		let arr = this.animaNodeArr;
		if (this.picAnimNodeArr.length > 0) {
			arr = this.picAnimNodeArr;
		}

		for (let i = 0; i < arr.length; i++) {

			const animaNode = arr[i];

			const key = animaNode.data.rectNew // i.toString();

			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showLetter')

				if (this.picAnimNodeArr.length > 0) {
					this.showLetterPic(animaNode);
				} else {
					this.showLetter(animaNode);
				}
			} else {

				animaNode.hitCount = 0;
			}
		}
	},

	photoEnd(data) {
		
		console.log(' this.photo end ', data);


		// if (this.newRectArr && this.newRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_WRITE) {
			this.photoEndNewRect(data);
			return;
		}


		// if (this.circleRectArr && this.circleRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_CIRCLE) {
			this.photoEndCircleRect(data);
			return;
		}

		// if (this.lineRectArr && this.lineRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_LINE) {
			this.photoEndLineRect(data);
			return;
		}

		// if (this.signRectArr && this.signRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_SIGN) {
			this.photoEndSignRect(data);
			return;
		}

		if (this.curCheckGroup == this.CHECK_TYPE_COLOR) {
			this.photoEndColorRect(data);
			return;
		}

		


		// this.changeBboxPos(data);

		const isRightArea = this.checkIsRightArea(data);
		if (!isRightArea) {
			console.log('没有检测到区域')
			return;
		}



		if (this.isCanDraw) {
			return;
		}
		this.isCanDraw = true;


		delayCall(0.01, () => {
			this.isCanDraw = false;
		})



		this.debugDrawLayer.removeAllChildren();

		// const benchmark1Text = this.benchmark1Data.labelText
		// const benchmark1TextArr = benchmark1Text.split(' ');
		// const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, data?.result?.text);

		// const benchmark2Text = this.benchmark2Data.labelText
		// const benchmark2TextArr = benchmark2Text.split(' ');
		// const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr,  data?.result?.text);




		const answerData = this.getAnswerData(data);

		this.showUserRight(answerData, data);

		return;


		const answerWrongData = this.getAnswerWrongData(data);
		let isShowWrong = false;
		if (this.oldAnswerWrongData) {
		
			for (let key in answerWrongData) {
				const wrongData = answerWrongData[key];
				const oldWrongData = this.oldAnswerWrongData[key];
				if (oldWrongData && oldWrongData.sentence == wrongData.sentence) {
					wrongData.count += oldWrongData.count;

					if (wrongData.count >= 3) {
						isShowWrong = true;
					}
				}
			}
		}

		if (isShowWrong) {
			this.showUserWrong(answerWrongData);
		}

		this.oldAnswerWrongData = answerWrongData;


		console.log('answerWrongData: ', JSON.stringify( answerWrongData) );
	},







	checkIsRightArea(data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}

		const benchmark1Text = this.benchmark1Data.labelText
		const benchmark1TextArr = benchmark1Text.split(' ');
		console.log('benchmark1TextArr: ', benchmark1TextArr);
		// const letter = this.data.letter || 'Aa';

		const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, text, false);
		if (!benchmark1LabelData) {
			console.log('!benchmark1LabelData')
			return false;
		}
		this.benchmark1LabelData = benchmark1LabelData;
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		

		if ( this.firstItemData ) {

			const firstText = this.firstItemData.labelText
			const firstTextArr = firstText.split(' ');

			const firstItemLabelData = this.getTopLeftLetter2(firstText, text, this.benchmark1LabelData);

			if (!firstItemLabelData) {
				return false;
			}
			this.firstItemLabelData = firstItemLabelData;

			console.log('firstItemLabelData: ', firstItemLabelData);
			return true

		} else if (this.benchmark2Data) {
		
			const benchmark2Text = this.benchmark2Data.labelText
			const benchmark2TextArr = benchmark2Text.split(' ');
			const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr, text, false);
			if (!benchmark2LabelData) {
				return false;
			}
			this.benchmark2LabelData = benchmark2LabelData;
			return true;
		}



		return false;

	


		// const block = data?.block
		// if (!block) {
		// 	return false;
		// }

		// const topText = this.topItemData.labelText
		// const topTextArr = topText.split(' ');
		// console.log('topTextArr: ', topTextArr);
		// // const letter = this.data.letter || 'Aa';

		// const topLabelData = this.getPhotoLabelData(topTextArr, block);
		// if (!topLabelData) {
		// 	console.log('!topLabelData')
		// 	return false;
		// }
		// this.topLabelData = topLabelData;
		// console.log('topLabelData: ', topLabelData);

		

		// if (this.bottomItemData) {
			
		// 	const bottomText = this.bottomItemData.labelText
		// 	const bottomTextArr = bottomText.split(' ');
		// 	const bottomLabelData = this.getPhotoLabelData(bottomTextArr, block);
		// 	if (!bottomLabelData) {
		// 		return false;
		// 	}
		// 	this.bottomLabelData = bottomLabelData;
		// 	return true

		// } else if (this.firstItemData) {

		// 	const firstText = this.firstItemData.labelText
		// 	const firstTextArr = firstText.split(' ');
		// 	const topLeftLetter = this.getPhotoLabelData(firstTextArr, block);


		// 	// const topLeftLetter = this.getTopLeftLetter(this.firstItemData.labelText, block, topLabelData);
		// 	if (!topLeftLetter) {
		// 		return false;
		// 	}
		// 	this.topLeftLetter = topLeftLetter;

		// 	console.log('topLeftLetter: ', topLeftLetter);
		// 	return true;
		// }



		// return false;

	
	},

	changeBboxPos(data) {

		const text = data?.result?.text;
		if (!text) {
			return;
		}


		for (let i=0; i<text.length; i++) {

			let {left, top, right, bottom} = text[i];

			const q_left = this.ques_region[0];
			const q_top = this.ques_region[1];
			const q_right = this.ques_region[2];
			const q_bottom = this.ques_region[7];

			const rect = {x: q_left, y: q_top, width: q_right - q_left, height: q_bottom - q_top};

			text[i].left = q_left + left * rect.width;
			text[i].top = q_top + top * rect.height;
			text[i].right = q_left + right * rect.width;
			text[i].bottom = q_top + bottom * rect.height;

		}

		// console.log('bbox: ', bbox);
		// const x1 = bbox[0].x1;
		// const y1 = bbox[0].y1;
		// const x2 = bbox[1].x2;
		// const y2 = bbox[1].y2;
		// const x3 = bbox[2].x3;
		// const y3 = bbox[2].y3;
		// const x4 = bbox[3].x4;
		// const y4 = bbox[3].y4;

		// const left = this.ques_region[0];
		// const top = this.ques_region[1];
		// const right = this.ques_region[2];
		// const bottom = this.ques_region[7];

		// const rect = {x: left, y:top, width: right - left, height: bottom - top};

		// const y1_new = top + y1 * rect.height;
		// const y2_new = y1_new;
		// const y3_new = top + y3 * rect.height;
		// const y4_new = y3_new;

		// const x1_new = left + x1 * rect.width;
		// const x2_new = left + x2 * rect.width;
		// const x3_new = x2_new;
		// const x4_new = x1_new;

		// bbox[0].x1 = x1_new;
		// bbox[0].y1 = y1_new;
		// bbox[1].x2 = x2_new;
		// bbox[1].y2 = y2_new;
		// bbox[2].x3 = x3_new;
		// bbox[2].y3 = y3_new;
		// bbox[3].x4 = x4_new;
		// bbox[3].y4 = y4_new;

		// console.log('~~rect: ', rect);

	
	},



	getTopLeftLetter2(text, block, topLabelData) {

		const benchmark1Rect = this.benchmark1Data.rect;

		const rect = {
			x: topLabelData.left, 
			y: -topLabelData.bottom, 
			width: Math.abs( topLabelData.right - topLabelData.left ), 
			height: Math.abs( topLabelData.bottom - topLabelData.top ), 
		}                        
		const colorRect = this.getColorRect(rect, "green");
		this.debugDrawLayer.addChild(colorRect);
		


		const tempUnitW = benchmark1Rect.x + benchmark1Rect.width;
		const tempUnitH = benchmark1Rect.y + benchmark1Rect.height;
		const tempBaseX = benchmark1Rect.x + benchmark1Rect.width / 2;
		const tempBaseY = benchmark1Rect.y + benchmark1Rect.height / 2;


		const firstItemData = this.firstItemData;		
		const firstItemRect = this.firstItemData.rect;

	
		const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		const unitX = (firstItemX - tempBaseX) / tempUnitW;
		const unitY = (firstItemY - tempBaseY) / tempUnitH;
		const unitW2 = firstItemRect.width / tempUnitW;
		const unitH2 = firstItemRect.height / tempUnitH;



		console.log('tempUnitW: ', tempUnitW);
		console.log('tempUnitH: ', tempUnitH);
		console.log('tempBaseX: ', tempBaseX);
		console.log('tempBaseY: ', tempBaseY);

		console.log('firstItemY: ', firstItemY);
		console.log('tempBaseY: ', tempBaseY);
		console.log('tempUnitH: ', tempUnitH);

		firstItemData.unitX = unitX;
		firstItemData.unitY = unitY;
		firstItemData.unitW = unitW2;
		firstItemData.unitH = unitH2;



		const topLocationLeft = topLabelData.left;
		const topLocationTop = topLabelData.top;
		const topLocationRight = topLabelData.right;
		const topLocationBottom = topLabelData.bottom;

		const baseX = topLocationLeft + (topLocationRight - topLocationLeft) / 2;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight;
		const unitH = topLocationTop + (topLocationBottom - topLocationTop);
		

		const checkLetter = firstItemData;

		console.log('baseY: ', baseY);
		console.log('checkLetter.unitY: ', checkLetter.unitY);
		console.log('unitH: ', unitH);


		let x = baseX + checkLetter.unitX * unitW;
		const y = baseY + checkLetter.unitY * unitH;
		const w = checkLetter.unitW * unitW;
		const h = checkLetter.unitH * unitH;
		const r = Math.min(w, h) / 2;


		console.log(' baseX:  ', baseX);
		console.log(' checkLetter.unitX:  ', checkLetter.unitX);
		console.log(' unitW:  ', unitW);
		console.log(' x:  ', x);
		console.log(' y:  ', y);
		console.log(' r:  ', r);
		console.log(' checkLetter:  ', checkLetter);

		const dot = this.getColorDot(x, -y, r, r, 'blue');
		this.debugDrawLayer.addChild(dot, 5);

		dot.labelText = checkLetter.labelText;


		const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		let topLeftLetterData;


		const {dotRect, labelText} = dot
		


		for (let i=0; i<wordDataArr.length; i++) {

			// const tempWordArr = wordDataArr[i].word;
			const tempWordArr = this.getTempWordArr(wordDataArr[i],['']);



			for (let k=0; k<tempWordArr.length; k++) {
					
				const {location , content} = tempWordArr[k];

				const rect = {
					x: location.left, 
					y: -location.bottom, 
					width: Math.abs( location.right - location.left ), 
					height: Math.abs( location.bottom - location.top ), 
				}                        
				const colorRect = this.getColorRect(rect, "purple");
				colorRect.labelText = content;
				this.debugDrawLayer.addChild(colorRect);

				// console.log('colorRect: ', colorRect);

				const label = this.getLabel(content);
				label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
				label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
				label.color = cc.Color.GREEN;
				this.debugDrawLayer.addChild(label);




				///------

				const checkRect = colorRect.ccRect;
				const targetLabelText = colorRect.labelText;

				const {dotRect, labelText, key} = dot;

				if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && checkRect.intersects(dotRect)) {
					return tempWordArr[k];
				}

				///------
				

			}





			// const lineRect = this.getLineRect( wordDataArr[i] );
			// const isInLineRect = lineRect.intersects(dotRect)
			// if (!isInLineRect) {
			// 	continue;
			// }

			// for (let k=0; k<tempWordArr.length; k++) {
			// 	const {location , content} = tempWordArr[k];

			// 	const tempRect = {
			// 		x: location.left, 
			// 		y: -location.bottom, 
			// 		width: Math.abs( location.right - location.left ), 
			// 		height: Math.abs( location.bottom - location.top ), 
			// 	}
			// 	const colorRect = this.getColorRect(tempRect);
			// 	colorRect.labelText = content;
			// 	// this.debugDrawLayer.addChild(colorRect);

			// 	const label = this.getLabel(content);
			// 	label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			// 	label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
			// 	label.color = cc.Color.GREEN;
			// 	// this.debugDrawLayer.addChild(label);
				


						
			// 	const rect = colorRect.ccRect;
			// 	const targetLabelText = colorRect.labelText;



			

			// 	// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
			// 	// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


			// 	const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

			// 	if (isInLineText) {
			// 	// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
			// 		topLeftLetterData = wordDataArr[i];
			// 		// answerData[i.toString()] = colorRect;
			// 		// return;
			// 	}

			// }
			
		}

			
		return null;


	},


	getTopLeftLetter(text, block, topLabelData) {

		// const topItemRect = this.topItemData.rect;

		// const tempUnitW = topItemRect.width;
		// const tempUnitH = topItemRect.height;
		// const tempBaseX = topItemRect.x;
		// const tempBaseY = topItemRect.y + topItemRect.height / 2;


		// const firstItemData = this.firstItemData;
		// console.log('firstItemData: ', firstItemData);
		
		// const firstItemRect = this.firstItemData.rect;


	
		// const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		// const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		// const unitX = (firstItemX - tempBaseX) / tempUnitW;
		// const unitY = (firstItemY - tempBaseY) / tempUnitH;
		// const unitW2 = firstItemRect.width / tempUnitW;
		// const unitH2 = firstItemRect.height / tempUnitH;


		// console.log('firstItemY: ', firstItemY);
		// console.log('tempBaseY: ', tempBaseY);
		// console.log('tempUnitH: ', tempUnitH);

		// firstItemData.unitX = unitX;
		// firstItemData.unitY = unitY;
		// firstItemData.unitW = unitW2;
		// firstItemData.unitH = unitH2;



		// // const topLabelData = this.topLabelData;

		// const firstTopWordLocation = topLabelData.word[0].location;
		// const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		// const topLocationLeft = firstTopWordLocation.left;
		// const topLocationTop = firstTopWordLocation.top;
		// const topLocationRight = lastTopWordLocation.right;
		// const topLocationBottom = lastTopWordLocation.bottom;

		// const baseX = topLocationLeft;
		// const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		// const unitW = topLocationRight - topLocationLeft;
		// const unitH = topLocationBottom - topLocationTop;
		

		// const checkLetter = firstItemData;

		// console.log('baseY: ', baseY);
		// console.log('checkLetter.unitY: ', checkLetter.unitY);
		// console.log('unitH: ', unitH);


		// let x = baseX + checkLetter.unitX * unitW;
		// const y = baseY + checkLetter.unitY * unitH;
		// const w = checkLetter.unitW * unitW;
		// const h = checkLetter.unitH * unitH;
		// const r = Math.min(w, h) / 2;

		// 	// const centerX = baseX + this.centerUnitW * unitW;
		// 	// x += (centerX - x) * 0.005  * (y * 0.05);

		// console.log(' x:  ', x);
		// console.log(' y:  ', y);
		// console.log(' r:  ', r);

		// const dot = this.getColorDot(x, -y, r, r, 'purple');
		// this.debugDrawLayer.addChild(dot, 5);

		// dot.labelText = checkLetter.labelText;


		// const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// let topLeftLetterData;


		// const {dotRect, labelText} = dot
		


		// for (let i=0; i<wordDataArr.length; i++) {

		// 	const tempWordArr = wordDataArr[i].word;

		// 	const lineRect = this.getLineRect( wordDataArr[i] );
		// 	const isInLineRect = lineRect.intersects(dotRect)
		// 	if (!isInLineRect) {
		// 		continue;
		// 	}

		// 	for (let k=0; k<tempWordArr.length; k++) {
		// 		const {location , content} = tempWordArr[k];

		// 		const tempRect = {
		// 			x: location.left, 
		// 			y: -location.bottom, 
		// 			width: Math.abs( location.right - location.left ), 
		// 			height: Math.abs( location.bottom - location.top ), 
		// 		}
		// 		const colorRect = this.getColorRect(tempRect);
		// 		colorRect.labelText = content;
		// 		// this.debugDrawLayer.addChild(colorRect);

		// 		const label = this.getLabel(content);
		// 		label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
		// 		label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
		// 		label.color = cc.Color.GREEN;
		// 		// this.debugDrawLayer.addChild(label);
				


						
		// 		const rect = colorRect.ccRect;
		// 		const targetLabelText = colorRect.labelText;



			

		// 		// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
		// 		// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


		// 		const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

		// 		if (isInLineText) {
		// 		// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
		// 			topLeftLetterData = wordDataArr[i];
		// 			// answerData[i.toString()] = colorRect;
		// 			// return;
		// 		}

		// 	}
			
		// }

			
		// return topLeftLetterData;









		// // const topRect = this.topItemData.rect;

		// // const topCenterY = (topRect.y + topRect.height / 2);
		// // const bottomCenterY = (bottomRect.y + bottomRect.height / 2);
		
		// // const unitH = bottomCenterY - topCenterY;
		// // const unitW = topRect.width;
		// // const baseX = topRect.x;
		// // const baseY = topRect.y + topRect.height;


		

		// // const titleBottom = this.getTitleBottom();
		// // console.log("titleBottom: ", titleBottom);

		// // let topLeftLetter;
		// // const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// // for (let i=0; i<wordDataArr.length; i++) {

		// // 	const tempWordArr = wordDataArr[i].word;
		// // 	for (let k=0; k<tempWordArr.length; k++) {
		// // 		const {location , content} = tempWordArr[k];


		// // 		// console.log('location: ~~ ', location);

		// // 		// if (location.top <= titleBottom) {
		// // 		// 	continue;
		// // 		// }

		// // 		wordDataArr[i].tmpLen = this.getToZeroLen(location)

					



		// // 		if (!topLeftLetter) {
		// // 			topLeftLetter = wordDataArr[i];
		// // 		} else {
		// // 			if (topLeftLetter.tmpLen > wordDataArr[i].tmpLen) {
		// // 				topLeftLetter = wordDataArr[i];
		// // 			}
		// // 		}
		// // 	}
			
		// // }

		// // return topLeftLetter;


	},

	getLineRect(line) {

		const tempWordArr = line.word;

		let sentenceRect;
		let left;
		let right;
		for (let k=0; k<tempWordArr.length; k++) {
			const {location , content} = tempWordArr[k];

			const tempRect = {
				x: location.left, 
				y: -location.bottom, 
				width: Math.abs( location.right - location.left ), 
				height: Math.abs( location.bottom - location.top ), 
			}
			const colorRect = this.getColorRect(tempRect);
			colorRect.labelText = content;
			// this.debugDrawLayer.addChild(colorRect);

					
			const rect = colorRect.ccRect;
			if (!sentenceRect) {
				sentenceRect = rect;
				left = rect.x;
				right = rect.x + rect.width;
			} else {
				if (rect.x + rect.width > right) {
					right = rect.x + rect.width;
				}
			}



		


		}

		if (sentenceRect) {
			sentenceRect.width = right - left;
		}

		return sentenceRect;



	},

	checkWordIsInLine(line, text) {

		console.log(" in checkWordIsInLine ");
		console.log(" line:  ", line);
		console.log(" word:  ", text);

		const textArr = text.trim().toLowerCase().split('');

		const word = line.word;
		let sentence = ''
		word.forEach(item => {
			sentence += item.content + ' ';
		});

		sentence.trim();
		sentence = sentence.toLowerCase();

		line.sentence = sentence;

		console.log(" sentence:  ", sentence);
		

		if (this.checkIsInsert(textArr, sentence)) {
			return true;
		}

		
		return false;

	},


	getTitleBottom() {
		let maxBottom = 0;
		const word = this.topLabelData.word;
		for (let i=0; i<word.length; i++) {
			if (word[i].location.bottom > maxBottom) {
				maxBottom = word[i].location.bottom;
			}
		}

		return maxBottom;
	},

	getToZeroLen(location) {
		const {top, left} = location;
		const len = Math.sqrt( Math.pow(left, 2) + Math.pow(top, 2) );
		return len;
	},



	getPhotoLabelData(textArr, block, isShow=true) {


		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}

			const sentence = line.content;


			if (isShow) {
				const label = this.getLabel(sentence, 150);
				label.x = line.left * this.debugBgImg.width;
				label.y = -(line.top + (line.bottom - line.top) / 2) * this.debugBgImg.height;
				label.parent = this.debugDrawLayer;
				label.zIndex = 200;
				// label.color = cc.Color.RED;
				const l = label.getComponent(cc.Label);
				label.anchorX = 0;
				console.log(' sentence~:  ', sentence);
			}




			if (this.checkIsInsert(textArr, sentence)) {
				return line;
			}

		}

		return false;

		// for(let j=0; j<block.length; j++) {

		// 	const line = block[j].line;
		// 	if (!line) {
		// 		continue;
		// 	}

		// 	for (let i=0; i<line.length; i++) {

		// 		const word = line[i].word;
		// 		let sentence = ''
		// 		word.forEach(item => {
		// 			sentence += item.content + ' ';
		// 		});
	
		// 		sentence.trim();
		// 		sentence = sentence.toLowerCase();
	
		// 		line[i].sentence = sentence;

		// 		if (this.checkIsInsert(textArr, sentence)) {
		// 			return line[i];
		// 		}
		// 	}
		// }

		// return false;
	},

	checkIsInsert(textArr, sentence) {
		// console.log('textArr: ', textArr);
		// console.log('sentence: ', sentence);

		sentence = sentence.toLowerCase();

		let index = -1;
		for (let i=0; i<textArr.length; i++) {
			index = sentence.indexOf(textArr[i].toLowerCase(), index);
			// console.log('index: ', index);
			if (index == -1) {
				return false;
			}
		}

		return true;
	},


	showUserRight(answerData, data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log('answerData: ', answerData);
		// console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}



		for (let i = 0; i < this.animaNodeArr.length; i++) {

			const animaNode = this.animaNodeArr[i];

			const key = animaNode.data.rectItem // i.toString();

			console.log('key: ', key)

			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				this.showLetter(animaNode);
				// this.removeLine(answerData[key].line, block);
			} else {

				animaNode.hitCount = 0;
			}
		}


		// for (let i = 0; i < this.picNodeArr.length; i++) {

		// 	const picNode = this.picNodeArr[i];

		// 	const key = picNode.data.rectItem // i.toString();

		// 	console.log('key: ', key)

		// 	if (answerData[key] && answerData[key].isFinish) {
		// 		this.showLetter(picNode);
		// 		this.removeLine(answerData[key].line, block);
		// 	} else {

		// 		picNode.hitCount = 0;
		// 	}
		// }


	},

	removeLine(line, block) {

		console.log('block: ', JSON.stringify(block));
		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
	
			const index = lineArr.indexOf(line);
			if (index != -1) {
				lineArr.splice(index, 1);
				console.log(' ```splice lineArr.length: ' , lineArr.length);
			}
		}
	},

	showUserWrong(answerData) {

		console.log('answerData: ', answerData);
		console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.picNodeArr.length; i++) {

			const picNode = this.picNodeArr[i];

			const key = picNode.data.rectItem // i.toString();

			console.log('key: ', key)

			if (answerData[key] && answerData[key].count >= 3) {
				this.showLetter(picNode, false);
			}
		}


	},



	showColorPic(picNode, data, isRight = true) {

		console.log('in showLetterPic 1');

		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}

		console.log('in showLetterPic 2');

		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetterPic 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.opacity = 0;
		picNode.active = true

		const picColor = new cc.Color();
		picColor.r = data.r;
		picColor.g = data.g;
		picColor.b = data.b;
		picNode.sprNode.color = picColor;




		// cc.tween(picNode)
		// 	.to(2, {opacity: 255}, {easing:"cubicOut"})
		// 	.start();

		playAudio(this.rightClip, () => {
		
		})
		
		if (!this.isGameEnd) {
			this.checkGameEnd(this.colorPicNodeArr);
		}

	},

	
	showLetterPic(picNode, isRight = true) {

		console.log('in showLetterPic 1');


		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}


		console.log('in showLetterPic 2');


		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetterPic 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.playRightAnim();
		// this.playRightAnim(picNode);

		picNode.opacity = 0;
		picNode.active = true
		cc.tween(picNode)
			.to(2, {opacity: 255}, {easing:"cubicOut"})
			.start();

		playAudio(this.rightClip, () => {
		
		})
		
		if (!this.isGameEnd) {
			this.checkGameEnd(this.picAnimNodeArr);
		}

	},


	showLetter(picNode, isRight = true) {

		// let writeRect = this.writeNodeArr[Number(index)];

		console.log('in showLetter 1');


		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}


		console.log('in showLetter 2');


		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetter 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.playRightAnim();
		this.playRightAnim(picNode);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.animaNodeArr);
		}

		return;


		picNode.answerPic.active = true;



		if (!isRight) {
			console.log(' ~ !isRight');
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#ef7961')
			playAudio(this.wrongClip);

			if (!this.isGameEnd) {
				this.checkGameEnd();
			}
			return;
		} else {
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#548fd4')
			playAudio(this.rightClip);

		}

		this.showAnimaStar(picNode, ()=> {
			
			if (!this.isGameEnd) {
				this.checkGameEnd();
			}

		});

	
	},

	showAnimaStar(node, cb) {

		const resDragonBone = cc.find("Canvas/res/anim/right")
		const dNode = cc.instantiate(resDragonBone)
		node.addChild(dNode, 20);

		const dragonDisplay = dNode.getComponent(dragonBones.ArmatureDisplay);

		dragonDisplay.playAnimation('newAnimation', 1);

		dragonDisplay.on(dragonBones.EventObject.COMPLETE, ()=> {
			console.log('play end');
			cb && cb();
		})
		

	},


	getAnswerData(data) {
		
		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log(' in getAnswerData: ', text);


		const benchmark1LabelData = this.benchmark1LabelData;
		let benchmark2LabelData ;

		const centerItemArr = this.centerItemArr;

		const benchmark1Left = benchmark1LabelData.left;
		const benchmark1Top = benchmark1LabelData.top;
		const benchmark1Right = benchmark1LabelData.right;
		const benchmark1Bottom = benchmark1LabelData.bottom;

		let baseX;
		let baseY;
		let unitW;
		let unitH;

		if (this.benchmark2LabelData) {
			benchmark2LabelData = this.benchmark2LabelData;


			const benchmark2Left = benchmark2LabelData.left;
			const benchmark2Top = benchmark2LabelData.top;
			const benchmark2Right = benchmark2LabelData.right;
			const benchmark2Bottom = benchmark2LabelData.bottom;


			const bottomLocation = benchmark2LabelData;

			baseX = benchmark1Left;
			baseY =	benchmark1Top + (benchmark1Bottom - benchmark1Top) / 2;
			unitW = benchmark2Right - benchmark1Left;
			unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;


			const benchmark2Rect = {
				x: benchmark2Left, 
				y: -benchmark2Bottom,
				width: Math.abs( benchmark2Left - benchmark2Right ), 
				height: Math.abs( benchmark2Top - benchmark2Bottom ), 
			}
			
			const colorbenchmark2Rect = this.getColorRect(benchmark2Rect, 'green');
			this.debugDrawLayer.addChild(colorbenchmark2Rect);
		} 

	



		if (this.firstItemLabelData) {
			const {location} = this.firstItemLabelData;
			const firstItemLeft = location.left;
			const firstItemRight = location.right;
			const firstItemTop = location.top;
			const firstItemBottom = location.bottom;

			console.log(' location: ', location);
			console.log(' firstItemLeft: ', firstItemLeft);
			console.log(' firstItemRight: ', firstItemRight);
			console.log(' firstItemTop: ', firstItemTop);
			console.log(' firstItemBottom: ', firstItemBottom);

			baseX = firstItemLeft + (firstItemRight - firstItemLeft) / 2;
			baseY =	firstItemTop + (firstItemBottom - firstItemTop) / 2;
			unitW = benchmark1Left + (benchmark1Right -  benchmark1Left) - ( firstItemLeft + (firstItemRight - firstItemLeft) / 2 );
			unitH = ( firstItemTop + (firstItemBottom - firstItemTop) / 2 ) - (benchmark1Top + (benchmark1Bottom -  benchmark1Top) / 2);
		}


		console.log(' baseX ~~~ ', baseX);
		console.log(' baseY ~~~ ', baseY);
		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = 1 //this.data.scaleOffY || 0.055;
		let postionRate = 1 //this.data.positionOffY || 0.4;

		// if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
		// 	postionRate *= 1.7;
    // }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			// const centerX = baseX + this.centerUnitW * unitW;

			// const tempR = scaleRate * (checkLetter.unitY * unitH);
			// const newR = r - tempR; 

			// let newW = w - tempR; 
			// let newH = h - tempR;


			// const rate = newR / r;

			// const tempY = ( y - (baseY) ) * postionRate;
			// y = y - tempY * (1 - rate);


			// const tempX = (centerX - x) * postionRate;
			// x = x + tempX * (1-rate);


			// const newScale = 1.4;
			// const edgeOff = (newScale - 1) / 2;
			// x -= edgeOff * newW;
			// y += edgeOff * newH;
			// newW *= newScale;
			// newH *= newScale;

			// const dot = this.getColorDot(x, -y, newW, newH);

			const dot = this.getColorDot(x, -y, w / 2, h / 2);



			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}



		// console.log('dotArr: ', dotArr);
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		const answerData = {};

		for (let j=0; j<this.centerItemArr.length; j++) {
			const checkLetter = this.centerItemArr[j];

			const wordDataArr = this.getPhotoWordArr(checkLetter.labelText, text, benchmark1LabelData);

			console.log('~~~wordDataArr: ', wordDataArr);


			for (let i=0; i<wordDataArr.length; i++) {

				const tempWordArr = this.getTempWordArr(wordDataArr[i],['']); // wordDataArr[i].word;

				for (let k=0; k<tempWordArr.length; k++) {
					
					const {location , content} = tempWordArr[k];

					const rect = {
						x: location.left, 
						y: -location.bottom, 
						width: Math.abs( location.right - location.left ), 
						height: Math.abs( location.bottom - location.top ), 
					}                        
					const colorRect = this.getColorRect(rect, "purple");
					colorRect.labelText = content;
					this.debugDrawLayer.addChild(colorRect);

					// console.log('colorRect: ', colorRect);

					const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
					label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
					label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
					label.color = cc.Color.BLACK;

					this.debugDrawLayer.addChild(label);
					
	
					this.setOneAnswerData(colorRect, dotArr, answerData, wordDataArr[i]);
	
				}
				
			}

		
		}



		const benchmark1Rect = {
			x: benchmark1Left, 
			y: -benchmark1Bottom,
			width: Math.abs( benchmark1Left - benchmark1Right ), 
			height: Math.abs( benchmark1Top - benchmark1Bottom ), 
		}

		console.log('benchmark1Rect: ', benchmark1Rect);
		
		const colorbenchmark1Rect = this.getColorRect(benchmark1Rect, 'green');
		this.debugDrawLayer.addChild(colorbenchmark1Rect);





		// const rectTop = {
		// 	x: topLocationLeft, 
		// 	y: -topLocationBottom,
		// 	width: Math.abs( topLocationLeft - topLocationRight ), 
		// 	height: Math.abs( topLocationTop - topLocationBottom ), 
		// }
		
		// const colorRectTop = this.getColorRect(rectTop, 'green');
		// this.debugDrawLayer.addChild(colorRectTop);



		// const rectBottom = {
		// 	x: bottomLocation.left, 
		// 	y: -bottomLocation.bottom,
		// 	width: Math.abs( bottomLocation.left - bottomLocation.right ), 
		// 	height: Math.abs( bottomLocation.top - bottomLocation.bottom ), 
		// }
		
		// const colorRectBottom = this.getColorRect(rectBottom, 'green');
		// this.debugDrawLayer.addChild(colorRectBottom);






		return answerData;


	},

	getTempWordArr(line, splitText) {

		const lineBox = {left: line.left, top: line.top, right: line.right, bottom: line.bottom};
		const baseX = lineBox.left;

		let textIndex = 0;
		const oneDisW = (lineBox.right - lineBox.left) / line.content.length;

		const arr = line.content.split(splitText);
		const wordArr = [];
		for (let i=0; i<arr.length; i++) {
			const content = arr[i];
			const location = {}
			location.left = baseX + textIndex * oneDisW;
			location.right = location.left + oneDisW * content.length;
			location.top = lineBox.top;
			location.bottom = lineBox.bottom;
			
			wordArr.push({content, location});

			textIndex += content.length;
		}

		return wordArr;
	},




	getAnswerWrongData(data) {
		
		const block = data?.block
		if (!block) {
			return false;
		}


		console.log(' in getAnswerWrongData: ', block);

		const endKeyObj = {};
		for (let j = 0; j < this.picNodeArr.length; j++) {

			const picNode = this.picNodeArr[j];

			const key = picNode.data.rectItem // i.toString();

			if (picNode.isShowEnd) {
				endKeyObj[key] = true;
			}
		}


		const topLabelData = this.topLabelData;
		let bottomLabelData ;
		if (this.bottomLabelData) {
			bottomLabelData = this.bottomLabelData;
		} else {
			bottomLabelData = this.topLeftLetter;
		}
		// const bottomLabelData = this.bottomLabelData;
		const centerItemArr = this.centerItemArr;

		// console.log('topLabelData: ', topLabelData);

		const firstTopWordLocation = topLabelData.word[0].location;
		const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		const topLocationLeft = firstTopWordLocation.left;
		const topLocationTop = firstTopWordLocation.top;
		const topLocationRight = lastTopWordLocation.right;
		const topLocationBottom = lastTopWordLocation.bottom;


		const bottomLocation = bottomLabelData.word[0].location;

		const baseX = topLocationLeft;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight - topLocationLeft;
		const unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;

		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = this.data.scaleOffY || 0.055;
		let postionRate = this.data.positionOffY || 0.4;

		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			postionRate *= 1.7;
    }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			const key = centerItemArr[i].index + 1;
			if (endKeyObj[key]) {
				continue;
			}

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			const centerX = baseX + this.centerUnitW * unitW;
	
			
		
			// y -= ( y - (baseY + unitH) ) * 0.35;



			const tempR = scaleRate * (checkLetter.unitY * unitH);
			const newR = r - tempR; 

			let newW = w - tempR; 
			let newH = h - tempR;


			const rate = newR / r;

			const tempY = ( y - (baseY) ) * postionRate;
			y = y - tempY * (1 - rate);


			const tempX = (centerX - x) * postionRate;
			x = x + tempX * (1-rate);




			const newScale = 1.4;
			const edgeOff = (newScale - 1) / 2;
			x -= edgeOff * newW;
			y += edgeOff * newH;
			newW *= newScale;
			newH *= newScale;

			const dot = this.getColorDot(x, -y, newW, newH);
			// const dot = this.getColorDot(x, -y, newR, newR);

			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;
			dot.centerPos = cc.v2(dot.x+ dot.width / 2, dot.y + dot.height / 2);

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}


		console.log('topLabelData: ', topLabelData);

		const answerData = {};


		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
			if (!lineArr) {
				continue;
			}

			for (let m=0; m<lineArr.length; m++) {
				const line = lineArr[m];
				
				
				console.log('line: ', JSON.stringify(line));
				const lineRect = this.getLineRect( line );
				console.log('lineRect: ~  ', JSON.stringify(lineRect));
				const lineCenterPos = cc.v2(lineRect.x + lineRect.width / 2, lineRect.y + lineRect.height / 2);

	
				const tempDotArr = [];
				for (let j=0; j<dotArr.length; j++) {
					const isInLineRect = lineRect.intersects(dotArr[j].dotRect)
					if (isInLineRect) {
						tempDotArr.push(dotArr[j]);
					}
				}
				if (tempDotArr.length > 0) {
					const colorRect = this.getColorRect(lineRect, 'purple');
					this.debugDrawLayer.addChild(colorRect);

					console.log('tempDotArr.length > 0')
					let minDistance;
					let curDot;
					for (let j=0; j<tempDotArr.length; j++) {
						const curDistance = cc.Vec2.distance(lineCenterPos, tempDotArr[j].centerPos);
						if (minDistance == null || minDistance > curDistance) {
							minDistance = curDistance;
							curDot = tempDotArr[j];
						}
					}
	
					const tempWordArr = line.word;
					let sentence = ''
					tempWordArr.forEach(item => {
						sentence += item.content.trim();
					});
	
					console.log('sentence: ', sentence);
					console.log('curDot.labelText: ', curDot.labelText);
					if (sentence.length >= curDot.labelText.length) {
						if (!answerData[curDot.key]) {
							answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
						} else {                                        
							const oldData = answerData[curDot.key];
							if (oldData.minDistance > minDistance) {
								answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
							}
						}
					}
				} else {

					const colorRect = this.getColorRect(lineRect, 'red');
					this.debugDrawLayer.addChild(colorRect);
				}
			}

	
		}


		return answerData;


	},


	setCirclePosInRectArr(colorRect) {


		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);

		const circleRectCheckArr = this.circleRectCheckArr;

		for (let i=0; i<circleRectCheckArr.length; i++) {

			const checkRect = circleRectCheckArr[i].ccRect;
			const key = circleRectCheckArr[i].data.index + 1;

			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (checkRect.contains(dotV2)) {
				if (!colorRect.inRectArr) {
					colorRect.inRectArr = []
				}
				colorRect.inRectArr.push(key);
			}

		}
	},



	setOneAnswerDataNew(colorRect, answerData) {
		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);


		const targetLabelText = colorRect.labelText;

		const newRectCheckArr = this.newRectCheckArr;

		for (let i=0; i<newRectCheckArr.length; i++) {

			const labelText = newRectCheckArr[i].data.labelText;
			const checkRect = newRectCheckArr[i].ccRect;
			const key = newRectCheckArr[i].data.index + 1;


			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			// if (labelText == targetLabelText && checkRect.contains(dotV2)) {
			if (checkRect.contains(dotV2)) {
				// const len = targetLabelText.trim().length;

				// console.log('len: ', len);

				// if (newRectCheckArr[i].data.isFuzzy) {

				const index = labelText.indexOf("||");
				if (index != -1) {
					const keyArr = labelText.split("||");

					for (let j=0; j<keyArr.length; j++) {

						if (targetLabelText.indexOf(keyArr[j]) != -1 ) {
							answerData[key] = {isFinish: true};
							break;
						}

					}
				} else {

					if (targetLabelText.indexOf(labelText) != -1 ) {
						answerData[key] = {isFinish: true};
					}
				}


					// if (targetLabelText.indexOf(labelText) != -1 ) {
					// 	answerData[key] = {isFinish: true};
					// }

				// } else {
				// 	if (labelText == targetLabelText) {
				// 		answerData[key] = {isFinish: true};
				// 	}
				// }


			}

		}
	},

	setOneAnswerData(colorRect, dotArr, answerData, line) {

		console.log(' in setOneAnswerData')
		console.log('colorRect: ', colorRect)
		console.log('dotArr: ', dotArr)
		console.log('answerData: ', answerData)

		
		const rect = colorRect.ccRect;
		const targetLabelText = colorRect.labelText;

		for (let i=0; i<dotArr.length; i++) {

			const {dotRect, labelText, key} = dotArr[i];

				console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
				console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );
				console.log('rect.intersects(dotRect) : ', rect.intersects(dotRect) );

			if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
				const len = targetLabelText.trim().length;

				console.log('len: ', len);

				if (!answerData[key]) {
					answerData[key] = {colorRect, count: len};
				} else {
					answerData[key].count += len;

					// console.log('len: ', len);
					// console.log('	answerData[key].count: ', 	answerData[key].count);

				}

				if ( labelText.length <= 1) {
					answerData[key].isFinish = true;
					answerData[key].line = line;

				} else {
					if (answerData[key].count >= labelText.length) {
						answerData[key].isFinish = true;
						answerData[key].line = line;
					}
				}
				

			
				// return;
			}

		}

	},

	getColorRect(rect, color=null) {

		if (!color) {
			color = 'red'
		}


		rect.x *= this.debugBgImg.width;
		rect.y *= this.debugBgImg.height;
		rect.width *= this.debugBgImg.width;
		rect.height *= this.debugBgImg.height;

		const node = getSprNode(color);
		node.anchorX = 0;
		node.anchorY = 0;
		node.x = rect.x;
		node.y = rect.y;
		node.scaleX = rect.width / node.width;
		node.scaleY = rect.height / node.height;

		node.ccRect = new cc.Rect(rect.x, rect.y, rect.width, rect.height);



		return node;
	},



	getColorDot(x, y, w=100, h=100, color='red') {
		const node = new cc.Node();

		if (!h) {
			h = w;
		}

		x *= this.debugBgImg.width;
		y *= this.debugBgImg.height;
		w *= this.debugBgImg.width;
		h *= this.debugBgImg.height;

		if (this.debugLayer.parent && this.debugLayer.active) {

			const rect = {
				x:- w/2,
				y: - h/ 2, 
				width:w, 
				height:h
			}
			// const colorDot = this.getColorRect(rect,'blue');
			// colorDot.fillColor = cc.Color.BLUE;
			// colorDot.fillRect( - r/2, - r/ 2, r, r);

			const colorDot = getSprNode(color);

			
			// colorDot.anchorX = 0;
			// colorDot.anchorY = 0;
			// colorDot.x = rect.x;
			// colorDot.y = rect.y;
			colorDot.scaleX = rect.width / colorDot.width;
			colorDot.scaleY = rect.height / colorDot.height;
			node.addChild(colorDot);



			// const rect1 = new cc.Rect(node.x -r/2, node.y -r/2, r, r);
			// const colorDot = this.getColorRect(rect1, 'green');

			// colorDot.dotRect = rect1;
			// return colorDot;
		}

		node.x = x;
		node.y = y;


		// node.opacity = 0.5;

		const rect = new cc.Rect(node.x -w/2, node.y -h/2, w, h);
		node.dotRect = rect;
		node.ccRect = rect;
		return node;
	},


	getCustomColorDot(x, y, w=100, h=100) {
		
		const node = new cc.Node();

		if (!h) {
			h = w;
		}

		x *= this.debugBgImg.width;
		y *= this.debugBgImg.height;
		w *= this.debugBgImg.width;
		h *= this.debugBgImg.height;

		if (this.debugLayer.parent && this.debugLayer.active) {

			const rect = {
				x:- w/2,
				y: - h/ 2, 
				width:w, 
				height:h
			}
		
			const colorDot = getSprNode('white');

		
			colorDot.scaleX = rect.width / colorDot.width;
			colorDot.scaleY = rect.height / colorDot.height;

			// const ccColor = new cc.Color();
			// cc.Color.fromHEX(ccColor, '#ff0000' );
			// colorDot.color = ccColor;

			node.addChild(colorDot);
			node.colorDot = colorDot;
		}

		node.x = x;
		node.y = y;


		const rect = new cc.Rect(node.x -w/2, node.y -h/2, w, h);
		node.dotRect = rect;
		node.ccRect = rect;
		return node;
	},
	



	checkHasAnswer(data, text) {

		text = text.toLowerCase();
		text = text.replace(/(^\s+)|(\s+$)/g,"");



		// -----
		let sentence = data.allText.replace('/\n/g', "");

		sentence = sentence.trim();
		sentence = sentence.toLowerCase();
		 


		if (sentence.indexOf(text) != -1) {

			// this.setTestLabel(line[i])

			return true;
		}
		// -----



		const block = data.block;
		for (let j = 0; j < block.length; j++) {

			const line = block[j].line;
			if (!line) {
				continue;
			}


			for (let i = 0; i < line.length; i++) {

				const word = line[i].word;
				const location = line[i].word[0].location;
		
				// console.log(' center line: ', line[i]);


				let sentence = ''
				word.forEach(item => {
					sentence += item.content.trim();
				});

				sentence = sentence.trim();
				sentence = sentence.toLowerCase();

				line[i].sentence = sentence;
				console.log('sentence: ' + sentence + ', text: ' + text);


				if (sentence.indexOf(text) != -1) {


					if (sentence) {
						this.setTestLabel(line[i])
					}

					// line[i].tmpLen = this.getToZeroLen(location)
					// if (!topLeftLetter) {
					// 	topLeftLetter = line[i];
					// } else {
					// 	if (topLeftLetter.tmpLen > line[i].tmpLen) {
					// 		topLeftLetter = line[i];
					// 	}
					// }

					return true;
				}
			}
		}

	},

	


	setTestLabel(labelData) {

		if (!this.debugLayer.parent || !this.debugLayer.active) {
			return;
		}
		// console.log('labelData: ', labelData)
		const location = labelData.word[0].location;
		const label = this.getLabel(labelData.sentence);
		label.anchorX = 0;
		// label.anchorY = 1;
		label.x = location.left;
		label.y = -location.top
		label.zIndex = 50;


		const rect = {};
		rect.width = location.right - location.left;
		rect.height = location.bottom - location.top;
		rect.x = location.left;
		rect.y = -location.top;
		// const colorRect = this.getColorRect(rect, cc.Color.YELLOW);
		// this.debugLayer.addChild(colorRect);

		this.debugLayer.addChild(label);
	},

	getLabel(text, fontSize = 20) {
		const labelNode = new cc.Node();
		const label = labelNode.addComponent(cc.Label);
		label.string = text;
		labelNode.color = cc.Color.BLACK;
		label.fontSize = fontSize;
		label.lineHeight = fontSize;
		return labelNode;
	},



	debugLayer: null,
	initDebugLayer() {


		console.log(' in initDebugLayer');
		const layer = new cc.Node();

		if (this.data.isDebug) {
			layer.parent = cc.find('Canvas');
		}


		layer.width = this.canvas.width / 2;
		layer.height = this.canvas.height / 2;

		layer.zIndex = 100;
		layer.anchorX = 0;
		layer.anchorY = 1;


		if (!this.data.bgItem2) {
			return;
		}


		cc.loader.load({url: this.data.bgItem2.url}, (err, img) => {

			this.debugBgImg = img;
			this.checkBg = img;
			layer.width = img.width;
			layer.height = img.height;

			layer.data = this.data.bgItem2;

			const sprNode = layer;
	
			var sf = new cc.SpriteFrame(img);

			const spr = sprNode.addComponent(cc.Sprite);
			spr.spriteFrame = sf			

			const sx = this.canvas.width / 2 / layer.width;
			const sy = (this.canvas.height) / 2 / layer.height;
			const s = Math.min(sx, sy);
			layer.scale = s;

			this.addNewRect();
			this.addCircleItem();
			this.addSignItem();
			this.addColorItem();

			this.initDebugRect();

			this.checkStart();
	
		});

		layer.x = -this.canvas.width / 2 + 10;
		layer.y = this.canvas.height / 2 - this.canvas.height / 3;
		layer.opacity = 150;

		// layer.scale = 2;
		this.debugLayer = layer;

		// const bgRectNode = new cc.Node();
		// const ctx = bgRectNode.addComponent(cc.Graphics);
		// ctx.fillRect(0, -layer.height, layer.width, layer.height);
		// ctx.fillColor = cc.Color.YELLOW.setA(100);
		// ctx.fill();
		// layer.addChild(bgRectNode);


		const drawLayer = new cc.Node();
    this.debugLayer.addChild(drawLayer, 2);

    this.debugDrawLayer = drawLayer;



	},

	initDebugRect() {

		console.log(' in initDebugRect');

		
		this.linkRectGroup = [];
		this.data.hotZoneItemArr2.forEach((item) => {
			switch (item.gIdx) {
				case "0":
					this.setOneDebugLinkRect(item);
					break;

				// case "1":
				// 	this.setOneDebugWriteRect(item);
				// 	break;

				default:
					break;
			}

		});
	

		console.log("this.linkRectGroup: ", this.linkRectGroup);
	},

	setOneDebugLinkRect(data) {
		const rate = (this.debugLayer.scale * this.debugLayer.width) / this.data.bgItem2.rect.width;
	
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.debugLayer.addChild(rectNode);

		let ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.debugLayer.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.height * scale - data.rect.y * scale;
	

		rectNode.anchorX = 0;
		rectNode.anchorY = 0;

		if (this.data.isDebug) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();


		rectNode['data'] = data;
		rectNode.opacity = 100;

		rectNode['ccRect'] = rectNode.getBoundingBoxToWorld()


		rectNode.isRightPoint = data.checkbox.list[0].value == true;

		this.linkRectGroup.push(rectNode);

		this.setLinkDataByDebugItem(rectNode, data.index);

	},

	setLinkDataByDebugItem(item, index) {

		let hzItemId;
		let debugItemId;
		let linkHzItemId;
		let linkDebugItemId;


		debugItemId = index + 1;

		const hzItem = this.getHzItemByPoint(debugItemId)

		hzItemId = this.data.hotZoneItemArr.indexOf(hzItem) + 1;

		console.log(' hzItem: ', hzItem);
		console.log(' debugItemId: ', debugItemId);

		linkHzItemId = hzItem.linkItem;

		const linkHzItem = this.data.hotZoneItemArr[linkHzItemId-1]

		linkDebugItemId = linkHzItem.pointItem;


		const linkData = {hzItemId, debugItemId, linkHzItemId, linkDebugItemId};
		item.linkData = linkData;

	},

	getHzItemByPoint(pointId, gidx = '0') {
		
		const hzItem = this.data.hotZoneItemArr.find((item) => {

			if (item.gIdx == gidx) {
				return item.pointItem == pointId
			}
		});

		return hzItem;
	},


	addColorItem() {
		console.log('addColorItem 1');
		if (!this.colorRectArr) {
			return;
		}

		console.log('addColorItem 2');

		this.colorRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.colorRectArr.length; i++) {
			const oneData = this.colorRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.colorRectCheckArr.push(rect);
			console.log('oneData: ', oneData);
		}
	},

	addSignItem() {
		if (!this.signRectArr) {
			return;
		}

		this.signRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.signRectArr.length; i++) {
			const oneData = this.signRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.signRectCheckArr.push(rect);
			console.log('oneData: ', oneData);
		}
	},

	addCircleItem() {

		if (!this.circleRectArr) {
			return;
		}

		this.circleRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.circleRectArr.length; i++) {
			const oneData = this.circleRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.circleRectCheckArr.push(rect);
			console.log('oneData: ', oneData);
		}
	},


	setDebugRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'blue');
		colorRect.opacity = 180;
		colorRect.data = data;

		colorRect.rectNode = rectNode;

		bg.addChild(colorRect, 20);

		return colorRect;
	},

	addNewRect() {
		
		if (!this.newRectArr) {
			return;
		}

		this.newRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.newRectArr.length; i++) {
			const oneData = this.newRectArr[i];
			this.setNewRectDot(oneData, bg);
			console.log('oneData: ', oneData);
		}

	},


	setNewRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'green');
		colorRect.opacity = 180;
		colorRect.data = data;
		bg.addChild(colorRect, 20);

		this.newRectCheckArr.push(colorRect);                                                                                                                                                                                        


		// if (this.data.bgItem.isShowDebugLine || true) {
		// 	ctx.rect(0, 0, rectNode.width, rectNode.height);
		// }
		// ctx.stroke();
		// ctx.fill();

	},
	 


	getPhotoWordArr(text, block, benchmark1Data) {


		const wordArr = [];
		// const maxLen = 10;

		text = text.trim();

		const topY = -benchmark1Data.top;

		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}


			const sentence = line.content;
			if (sentence.indexOf(text) != -1 ) {
				wordArr.push( line );
			}

			// for (let i=0; i<line.length; i++) {


			// 	const location = line[i].word[0].location;

			// 	const curTop = -location.top;
			// 	if (curTop >= topY ) {
			// 		continue;
			// 	}


			// 	let word = line[i].word;
			// 	let sentence = ''

			// 	// if (word.length > maxLen) {
			// 	// 	console.log('continue ', word.length);
			// 	// 	continue;
			// 	// }

			// 	line[i].word = word = this.checkCutWordData(word);
			// 	// console.log('word1~ ', word);


			// 	word.forEach(item => {
			// 		sentence += item.content + '';
			// 	});

			// 	sentence = sentence.trim().toLowerCase();

			// 	text = text.toLowerCase();

			// 	line[i].sentence = sentence;
			// 	console.log('sentence: ', sentence);
			// 	console.log('text: ', text);

			// 	console.log('index: ', sentence.indexOf(text));
			// 	if (sentence.indexOf(text) != -1 ) {
			// 		wordArr.push( line[i] );
			// 	}
			// }
		}

		return wordArr;
	},


	checkCutWordData(wordArr) {


		// console.log('wordArr: ', wordArr);

		let newWordArr = [];
		for(let i=0; i<wordArr.length; i++) {

			let wordObj = wordArr[i];

			wordObj.content = wordObj.content.trim();

			if (wordObj.content.length > 1) {

				const tmpArr = [];
				const w = wordObj.location.right - wordObj.location.left
				const subW = w / wordObj.content.length;
				for (let j=0; j<wordObj.content.length; j++) {

					const subWordObj = {};
					subWordObj.content = wordObj.content[j];
					subWordObj.location = {
						top: wordObj.location.top,
						bottom: wordObj.location.bottom,
						left: wordObj.location.left + subW * j,
						right: wordObj.location.left + subW * (j + 1)
					}

					tmpArr.push(subWordObj);
				}
				newWordArr = newWordArr.concat(tmpArr)


			} else {
				newWordArr.push(wordObj)
			}

		}

		// console.log('newWordArr: ', newWordArr);
		return newWordArr;
	},

	getPhotoData(cb) {
	

		const tmpData1 ={"result":{"text":[{"points":[0.05,0.10953608,0.053333335,0.10953608,0.05666667,0.10953608,0.06,0.10953608,0.06333333,0.10953608,0.06666667,0.10953608,0.07,0.10953608,0.07333333,0.10953608,0.07666667,0.10953608,0.08,0.10953608,0.083333336,0.10953608,0.086666666,0.10953608,0.09,0.10953608,0.093333334,0.10953608,0.096666664,0.10953608,0.1,0.10953608,0.10333333,0.10953608,0.10666667,0.10953608,0.11,0.10953608,0.11333334,0.10953608,0.11666667,0.10953608,0.12,0.10953608,0.123333335,0.10953608,0.12666667,0.10953608,0.13,0.10953608,0.13333334,0.10953608,0.13666667,0.10953608,0.14,0.10953608,0.14333333,0.10953608,0.14666666,0.10953608,0.15,0.10953608,0.15333334,0.10953608,0.15666667,0.10953608,0.16,0.10953608,0.16333333,0.10953608,0.16666667,0.10953608,0.17,0.10953608,0.17333333,0.10953608,0.17666666,0.10953608,0.18,0.10953608,0.18333334,0.10953608,0.18666667,0.10953608,0.19,0.10953608,0.19333333,0.10953608,0.19666667,0.10953608,0.2,0.10953608,0.20333333,0.10953608,0.20666666,0.10953608,0.21,0.10953608,0.21333334,0.10953608,0.21666667,0.10953608,0.22,0.10953608,0.22333333,0.10953608,0.22666667,0.10953608,0.23,0.10953608,0.23333333,0.10953608,0.23666666,0.10953608,0.24,0.10953608,0.24333334,0.10953608,0.24666667,0.10953608,0.25,0.10953608,0.25333333,0.10953608,0.25666666,0.10953608,0.26,0.10953608,0.26333332,0.10953608,0.26666668,0.10953608,0.27,0.10953608,0.27333334,0.10953608,0.27666667,0.10953608,0.28,0.10953608,0.28333333,0.10953608,0.28666666,0.10953608,0.29,0.10953608,0.29333332,0.10953608,0.29666665,0.10953608,0.3,0.10953608,0.30333334,0.10953608,0.30666667,0.10953608,0.31,0.10953608,0.31333333,0.10953608,0.31666666,0.10953608,0.32,0.10953608,0.32333332,0.10953608,0.32666665,0.10953608,0.33,0.10953608,0.33333334,0.10953608,0.33666667,0.10953608,0.34,0.10953608,0.34333333,0.10953608,0.34666666,0.10953608,0.35,0.10953608,0.35333332,0.10953608,0.35666665,0.10953608,0.36,0.10953608,0.36333334,0.10953608,0.36666667,0.10953608,0.37,0.10953608,0.37333333,0.10953608,0.37666667,0.10953608,0.38,0.10953608,0.38333333,0.10953608,0.38666666,0.10953608,0.39,0.10953608,0.39333335,0.10953608,0.39666668,0.10953608,0.4,0.10953608,0.40333334,0.10953608,0.40666667,0.10953608,0.41,0.10953608,0.41333333,0.10953608,0.41666666,0.10953608,0.42,0.10953608,0.42333335,0.10953608,0.42666668,0.10953608,0.43,0.10953608,0.43333334,0.10953608,0.43666667,0.10953608,0.44,0.10953608,0.44333333,0.10953608,0.44666666,0.10953608,0.45,0.10953608,0.45333335,0.10953608,0.45666668,0.10953608,0.46,0.10953608,0.46333334,0.10953608,0.46666667,0.10953608,0.47,0.10953608,0.47333333,0.10953608,0.47666666,0.10953608,0.48,0.10953608,0.48333332,0.10953608,0.48666668,0.10953608,0.49,0.10953608,0.49333334,0.10953608,0.49666667,0.10953608,0.5,0.10953608,0.50333333,0.10953608,0.50666666,0.10953608,0.51,0.10953608,0.5133333,0.10953608,0.51666665,0.10953608,0.52,0.10953608,0.5233333,0.10953608,0.52666664,0.10953608,0.53,0.10953608,0.53333336,0.10953608,0.5366667,0.10953608,0.54,0.10953608,0.54333335,0.10953608,0.5466667,0.10953608,0.55,0.10953608,0.55333334,0.10953608,0.5566667,0.10953608,0.56,0.10953608,0.56333333,0.10953608,0.56666666,0.10953608,0.57,0.10953608,0.5733333,0.10953608,0.57666665,0.10953608,0.58,0.10953608,0.5833333,0.10953608,0.58666664,0.10953608,0.59,0.10953608,0.5933333,0.10953608,0.5966667,0.10953608,0.6,0.10953608,0.60333335,0.10953608,0.6066667,0.10953608,0.61,0.10953608,0.61333334,0.10953608,0.6166667,0.10953608,0.62,0.10953608,0.62333333,0.10953608,0.62666667,0.10953608,0.63,0.10953608,0.6333333,0.10953608,0.63666666,0.10953608,0.64,0.10953608,0.6433333,0.10953608,0.64666665,0.10953608,0.65,0.10953608,0.6533333,0.10953608,0.66,0.10953608,0.66333336,0.10953608,0.6666667,0.10953608,0.67,0.10953608,0.67333335,0.10953608,0.6766667,0.10953608,0.68,0.10953608,0.68333334,0.10953608,0.68666667,0.10953608,0.69,0.10953608,0.6933333,0.10953608,0.69666666,0.10953608,0.7,0.10953608,0.7033333,0.10953608,0.70666665,0.10953608,0.71,0.10953608,0.7133333,0.10953608,0.71666664,0.10953608,0.72,0.10953608,0.72333336,0.10953608,0.7266667,0.10953608,0.73,0.10953608,0.73333335,0.10953608,0.7366667,0.10953608,0.74,0.10953608,0.74333334,0.10953608,0.7633333,0.10953608,0.76666665,0.10953608,0.77,0.10953608,0.7733333,0.10953608,0.77666664,0.10953608,0.78,0.10953608,0.78333336,0.10953608,0.7866667,0.10953608,0.79,0.10953608,0.79333335,0.10953608,0.7966667,0.10953608,0.8,0.10953608,0.80333334,0.10953608,0.8066667,0.10953608,0.81,0.10953608,0.81333333,0.10953608,0.81666666,0.10953608,0.82,0.10953608,0.8233333,0.10953608,0.82666665,0.10953608,0.83,0.10953608,0.8333333,0.10953608,0.83666664,0.10953608,0.84,0.10953608,0.8433333,0.10953608,0.8466667,0.10953608,0.85,0.10953608,0.85333335,0.10953608,0.8566667,0.10953608,0.86,0.10953608,0.86333334,0.10953608,0.8666667,0.10953608,0.87,0.10953608,0.87333333,0.10953608,0.87666667,0.10953608,0.88,0.10953608,0.8833333,0.10953608,0.88666666,0.10953608,0.89,0.10953608,0.8933333,0.10953608,0.89666665,0.10953608,0.9,0.10953608,0.9033333,0.10953608,0.9066667,0.10953608,0.91,0.10953608,0.91333336,0.10953608,0.9166667,0.10953608,0.92,0.10953608,0.92333335,0.10953608,0.9266667,0.10953608,0.93333334,0.10953608,0.93666667,0.10953608,0.94,0.10953608,0.9433333,0.10953608,0.94666666,0.10953608,0.05,0.1121134,0.053333335,0.1121134,0.05666667,0.1121134,0.06,0.1121134,0.06333333,0.1121134,0.06666667,0.1121134,0.07,0.1121134,0.07333333,0.1121134,0.07666667,0.1121134,0.08,0.1121134,0.083333336,0.1121134,0.086666666,0.1121134,0.09,0.1121134,0.093333334,0.1121134,0.096666664,0.1121134,0.1,0.1121134,0.10333333,0.1121134,0.10666667,0.1121134,0.11,0.1121134,0.11333334,0.1121134,0.11666667,0.1121134,0.12,0.1121134,0.123333335,0.1121134,0.12666667,0.1121134,0.13,0.1121134,0.13333334,0.1121134,0.13666667,0.1121134,0.14,0.1121134,0.14333333,0.1121134,0.14666666,0.1121134,0.15,0.1121134,0.15333334,0.1121134,0.15666667,0.1121134,0.16,0.1121134,0.16333333,0.1121134,0.16666667,0.1121134,0.17,0.1121134,0.17333333,0.1121134,0.17666666,0.1121134,0.18,0.1121134,0.18333334,0.1121134,0.18666667,0.1121134,0.19,0.1121134,0.19333333,0.1121134,0.19666667,0.1121134,0.2,0.1121134,0.20333333,0.1121134,0.20666666,0.1121134,0.21,0.1121134,0.21333334,0.1121134,0.21666667,0.1121134,0.22,0.1121134,0.22333333,0.1121134,0.22666667,0.1121134,0.23,0.1121134,0.23333333,0.1121134,0.23666666,0.1121134,0.24,0.1121134,0.24333334,0.1121134,0.24666667,0.1121134,0.25,0.1121134,0.25333333,0.1121134,0.25666666,0.1121134,0.26,0.1121134,0.26333332,0.1121134,0.26666668,0.1121134,0.27,0.1121134,0.27333334,0.1121134,0.27666667,0.1121134,0.28,0.1121134,0.28333333,0.1121134,0.28666666,0.1121134,0.29,0.1121134,0.29333332,0.1121134,0.29666665,0.1121134,0.3,0.1121134,0.30333334,0.1121134,0.30666667,0.1121134,0.31,0.1121134,0.31333333,0.1121134,0.31666666,0.1121134,0.32,0.1121134,0.32333332,0.1121134,0.32666665,0.1121134,0.33,0.1121134,0.33333334,0.1121134,0.33666667,0.1121134,0.34,0.1121134,0.34333333,0.1121134,0.34666666,0.1121134,0.35,0.1121134,0.35333332,0.1121134,0.35666665,0.1121134,0.36,0.1121134,0.36333334,0.1121134,0.36666667,0.1121134,0.37,0.1121134,0.37333333,0.1121134,0.37666667,0.1121134,0.38,0.1121134,0.38333333,0.1121134,0.38666666,0.1121134,0.39,0.1121134,0.39333335,0.1121134,0.39666668,0.1121134,0.4,0.1121134,0.40333334,0.1121134,0.40666667,0.1121134,0.41,0.1121134,0.41333333,0.1121134,0.41666666,0.1121134,0.42,0.1121134,0.42333335,0.1121134,0.42666668,0.1121134,0.43,0.1121134,0.43333334,0.1121134,0.43666667,0.1121134,0.44,0.1121134,0.44333333,0.1121134,0.44666666,0.1121134,0.45,0.1121134,0.45333335,0.1121134,0.45666668,0.1121134,0.46,0.1121134,0.46333334,0.1121134,0.46666667,0.1121134,0.47,0.1121134,0.47333333,0.1121134,0.47666666,0.1121134,0.48,0.1121134,0.48333332,0.1121134,0.48666668,0.1121134,0.49,0.1121134,0.49333334,0.1121134,0.49666667,0.1121134,0.5,0.1121134,0.50333333,0.1121134,0.50666666,0.1121134,0.51,0.1121134,0.5133333,0.1121134,0.51666665,0.1121134,0.52,0.1121134,0.5233333,0.1121134,0.52666664,0.1121134,0.53,0.1121134,0.53333336,0.1121134,0.5366667,0.1121134,0.54,0.1121134,0.54333335,0.1121134,0.5466667,0.1121134,0.55,0.1121134,0.55333334,0.1121134,0.5566667,0.1121134,0.56,0.1121134,0.56333333,0.1121134,0.56666666,0.1121134,0.57,0.1121134,0.5733333,0.1121134,0.57666665,0.1121134,0.58,0.1121134,0.5833333,0.1121134,0.58666664,0.1121134,0.59,0.1121134,0.5933333,0.1121134,0.5966667,0.1121134,0.6,0.1121134,0.60333335,0.1121134,0.6066667,0.1121134,0.61,0.1121134,0.61333334,0.1121134,0.6166667,0.1121134,0.62,0.1121134,0.62333333,0.1121134,0.62666667,0.1121134,0.63,0.1121134,0.6333333,0.1121134,0.63666666,0.1121134,0.64,0.1121134,0.6433333,0.1121134,0.64666665,0.1121134,0.65,0.1121134,0.6533333,0.1121134,0.6566667,0.1121134,0.66,0.1121134,0.66333336,0.1121134,0.6666667,0.1121134,0.67,0.1121134,0.67333335,0.1121134,0.6766667,0.1121134,0.68,0.1121134,0.68333334,0.1121134,0.68666667,0.1121134,0.69,0.1121134,0.6933333,0.1121134,0.69666666,0.1121134,0.7,0.1121134,0.7033333,0.1121134,0.70666665,0.1121134,0.71,0.1121134,0.7133333,0.1121134,0.71666664,0.1121134,0.72,0.1121134,0.72333336,0.1121134,0.7266667,0.1121134,0.73,0.1121134,0.73333335,0.1121134,0.7366667,0.1121134,0.74,0.1121134,0.7633333,0.1121134,0.76666665,0.1121134,0.77,0.1121134,0.7733333,0.1121134,0.77666664,0.1121134,0.78,0.1121134,0.78333336,0.1121134,0.7866667,0.1121134,0.79,0.1121134,0.79333335,0.1121134,0.7966667,0.1121134,0.8,0.1121134,0.80333334,0.1121134,0.8066667,0.1121134,0.81,0.1121134,0.81333333,0.1121134,0.81666666,0.1121134,0.82,0.1121134,0.8233333,0.1121134,0.82666665,0.1121134,0.83,0.1121134,0.8333333,0.1121134,0.83666664,0.1121134,0.84,0.1121134,0.8433333,0.1121134,0.8466667,0.1121134,0.85,0.1121134,0.85333335,0.1121134,0.8566667,0.1121134,0.86,0.1121134,0.86333334,0.1121134,0.8666667,0.1121134,0.87,0.1121134,0.87333333,0.1121134,0.87666667,0.1121134,0.88,0.1121134,0.8833333,0.1121134,0.88666666,0.1121134,0.89,0.1121134,0.8933333,0.1121134,0.89666665,0.1121134,0.9,0.1121134,0.9033333,0.1121134,0.9066667,0.1121134,0.91,0.1121134,0.91333336,0.1121134,0.9166667,0.1121134,0.92,0.1121134,0.92333335,0.1121134,0.9266667,0.1121134,0.93,0.1121134,0.93666667,0.1121134,0.94,0.1121134,0.9433333,0.1121134,0.94666666,0.1121134,0.05,0.11469072,0.053333335,0.11469072,0.05666667,0.11469072,0.06,0.11469072,0.06333333,0.11469072,0.06666667,0.11469072,0.07,0.11469072,0.07333333,0.11469072,0.07666667,0.11469072,0.08,0.11469072,0.083333336,0.11469072,0.086666666,0.11469072,0.09,0.11469072,0.093333334,0.11469072,0.096666664,0.11469072,0.1,0.11469072,0.10333333,0.11469072,0.10666667,0.11469072,0.11,0.11469072,0.11333334,0.11469072,0.11666667,0.11469072,0.12,0.11469072,0.123333335,0.11469072,0.12666667,0.11469072,0.13,0.11469072,0.13333334,0.11469072,0.13666667,0.11469072,0.14,0.11469072,0.14333333,0.11469072,0.14666666,0.11469072,0.15,0.11469072,0.15333334,0.11469072,0.15666667,0.11469072,0.16,0.11469072,0.16333333,0.11469072,0.16666667,0.11469072,0.17,0.11469072,0.17333333,0.11469072,0.17666666,0.11469072,0.18,0.11469072,0.18333334,0.11469072,0.18666667,0.11469072,0.19,0.11469072,0.19333333,0.11469072,0.19666667,0.11469072,0.2,0.11469072,0.20333333,0.11469072,0.20666666,0.11469072,0.21,0.11469072,0.21333334,0.11469072,0.21666667,0.11469072,0.22,0.11469072,0.22333333,0.11469072,0.22666667,0.11469072,0.23,0.11469072,0.23333333,0.11469072,0.23666666,0.11469072,0.24,0.11469072,0.24333334,0.11469072,0.24666667,0.11469072,0.25,0.11469072,0.25333333,0.11469072,0.25666666,0.11469072,0.26,0.11469072,0.26333332,0.11469072,0.26666668,0.11469072,0.27,0.11469072,0.27333334,0.11469072,0.27666667,0.11469072,0.28,0.11469072,0.28333333,0.11469072,0.28666666,0.11469072,0.29,0.11469072,0.29333332,0.11469072,0.29666665,0.11469072,0.3,0.11469072,0.30333334,0.11469072,0.30666667,0.11469072,0.31,0.11469072,0.31333333,0.11469072,0.31666666,0.11469072,0.32,0.11469072,0.32333332,0.11469072,0.32666665,0.11469072,0.33,0.11469072,0.33333334,0.11469072,0.33666667,0.11469072,0.34,0.11469072,0.34333333,0.11469072,0.34666666,0.11469072,0.35,0.11469072,0.35333332,0.11469072,0.35666665,0.11469072,0.36,0.11469072,0.36333334,0.11469072,0.36666667,0.11469072,0.37,0.11469072,0.37333333,0.11469072,0.37666667,0.11469072,0.38,0.11469072,0.38333333,0.11469072,0.38666666,0.11469072,0.39,0.11469072,0.39333335,0.11469072,0.39666668,0.11469072,0.4,0.11469072,0.40333334,0.11469072,0.40666667,0.11469072,0.41,0.11469072,0.41333333,0.11469072,0.41666666,0.11469072,0.42,0.11469072,0.42333335,0.11469072,0.42666668,0.11469072,0.43,0.11469072,0.43333334,0.11469072,0.43666667,0.11469072,0.44,0.11469072,0.44333333,0.11469072,0.44666666,0.11469072,0.45,0.11469072,0.45333335,0.11469072,0.45666668,0.11469072,0.46,0.11469072,0.46333334,0.11469072,0.46666667,0.11469072,0.47,0.11469072,0.47333333,0.11469072,0.47666666,0.11469072,0.48,0.11469072,0.48333332,0.11469072,0.48666668,0.11469072,0.49,0.11469072,0.49333334,0.11469072,0.49666667,0.11469072,0.5,0.11469072,0.50333333,0.11469072,0.50666666,0.11469072,0.51,0.11469072,0.5133333,0.11469072,0.51666665,0.11469072,0.52,0.11469072,0.5233333,0.11469072,0.52666664,0.11469072,0.53,0.11469072,0.53333336,0.11469072,0.5366667,0.11469072,0.54,0.11469072,0.54333335,0.11469072,0.5466667,0.11469072,0.55,0.11469072,0.55333334,0.11469072,0.5566667,0.11469072,0.56,0.11469072,0.56333333,0.11469072,0.56666666,0.11469072,0.57,0.11469072,0.5733333,0.11469072,0.57666665,0.11469072,0.58,0.11469072,0.5833333,0.11469072,0.58666664,0.11469072,0.59,0.11469072,0.5933333,0.11469072,0.5966667,0.11469072,0.6,0.11469072,0.60333335,0.11469072,0.6066667,0.11469072,0.61,0.11469072,0.61333334,0.11469072,0.6166667,0.11469072,0.62,0.11469072,0.62333333,0.11469072,0.62666667,0.11469072,0.63,0.11469072,0.6333333,0.11469072,0.63666666,0.11469072,0.64,0.11469072,0.6433333,0.11469072,0.64666665,0.11469072,0.65,0.11469072,0.6533333,0.11469072,0.6566667,0.11469072,0.66,0.11469072,0.66333336,0.11469072,0.6666667,0.11469072,0.67,0.11469072,0.67333335,0.11469072,0.6766667,0.11469072,0.68,0.11469072,0.68333334,0.11469072,0.68666667,0.11469072,0.69,0.11469072,0.6933333,0.11469072,0.69666666,0.11469072,0.7,0.11469072,0.7033333,0.11469072,0.70666665,0.11469072,0.71,0.11469072,0.7133333,0.11469072,0.71666664,0.11469072,0.72,0.11469072,0.72333336,0.11469072,0.7266667,0.11469072,0.73,0.11469072,0.73333335,0.11469072,0.7366667,0.11469072,0.74,0.11469072,0.75666666,0.11469072,0.76,0.11469072,0.7633333,0.11469072,0.76666665,0.11469072,0.77,0.11469072,0.7733333,0.11469072,0.77666664,0.11469072,0.78,0.11469072,0.78333336,0.11469072,0.7866667,0.11469072,0.79,0.11469072,0.79333335,0.11469072,0.7966667,0.11469072,0.8,0.11469072,0.80333334,0.11469072,0.8066667,0.11469072,0.81,0.11469072,0.81333333,0.11469072,0.81666666,0.11469072,0.82,0.11469072,0.8233333,0.11469072,0.82666665,0.11469072,0.85,0.11469072,0.85333335,0.11469072,0.8566667,0.11469072,0.86,0.11469072,0.86333334,0.11469072,0.8666667,0.11469072,0.87,0.11469072,0.87333333,0.11469072,0.87666667,0.11469072,0.88,0.11469072,0.8833333,0.11469072,0.88666666,0.11469072,0.89,0.11469072,0.8933333,0.11469072,0.89666665,0.11469072,0.9,0.11469072,0.9033333,0.11469072,0.9066667,0.11469072,0.91,0.11469072,0.91333336,0.11469072,0.9166667,0.11469072,0.92,0.11469072,0.92333335,0.11469072,0.9266667,0.11469072,0.93,0.11469072,0.93333334,0.11469072,0.93666667,0.11469072,0.94,0.11469072,0.9433333,0.11469072,0.94666666,0.11469072,0.05,0.11726804,0.053333335,0.11726804,0.05666667,0.11726804,0.06,0.11726804,0.06333333,0.11726804,0.06666667,0.11726804,0.07,0.11726804,0.07333333,0.11726804,0.07666667,0.11726804,0.08,0.11726804,0.083333336,0.11726804,0.086666666,0.11726804,0.09,0.11726804,0.093333334,0.11726804,0.096666664,0.11726804,0.1,0.11726804,0.10333333,0.11726804,0.10666667,0.11726804,0.11,0.11726804,0.11333334,0.11726804,0.11666667,0.11726804,0.12,0.11726804,0.123333335,0.11726804,0.12666667,0.11726804,0.13,0.11726804,0.13333334,0.11726804,0.13666667,0.11726804,0.14,0.11726804,0.14333333,0.11726804,0.14666666,0.11726804,0.15,0.11726804,0.15333334,0.11726804,0.15666667,0.11726804,0.16,0.11726804,0.16333333,0.11726804,0.16666667,0.11726804,0.17,0.11726804,0.17333333,0.11726804,0.17666666,0.11726804,0.18,0.11726804,0.18333334,0.11726804,0.18666667,0.11726804,0.19,0.11726804,0.19333333,0.11726804,0.19666667,0.11726804,0.2,0.11726804,0.20333333,0.11726804,0.20666666,0.11726804,0.21,0.11726804,0.21333334,0.11726804,0.21666667,0.11726804,0.22,0.11726804,0.22333333,0.11726804,0.22666667,0.11726804,0.23,0.11726804,0.23333333,0.11726804,0.23666666,0.11726804,0.24,0.11726804,0.24333334,0.11726804,0.24666667,0.11726804,0.25,0.11726804,0.25333333,0.11726804,0.25666666,0.11726804,0.26,0.11726804,0.26333332,0.11726804,0.26666668,0.11726804,0.27,0.11726804,0.27333334,0.11726804,0.27666667,0.11726804,0.28,0.11726804,0.28333333,0.11726804,0.28666666,0.11726804,0.29,0.11726804,0.29333332,0.11726804,0.29666665,0.11726804,0.3,0.11726804,0.30333334,0.11726804,0.30666667,0.11726804,0.31,0.11726804,0.31333333,0.11726804,0.31666666,0.11726804,0.32,0.11726804,0.32333332,0.11726804,0.32666665,0.11726804,0.33,0.11726804,0.33333334,0.11726804,0.33666667,0.11726804,0.34,0.11726804,0.34333333,0.11726804,0.34666666,0.11726804,0.35,0.11726804,0.35333332,0.11726804,0.35666665,0.11726804,0.36,0.11726804,0.36333334,0.11726804,0.36666667,0.11726804,0.37,0.11726804,0.37333333,0.11726804,0.37666667,0.11726804,0.38,0.11726804,0.38333333,0.11726804,0.38666666,0.11726804,0.39,0.11726804,0.39333335,0.11726804,0.39666668,0.11726804,0.4,0.11726804,0.40333334,0.11726804,0.40666667,0.11726804,0.41,0.11726804,0.41333333,0.11726804,0.41666666,0.11726804,0.42,0.11726804,0.42333335,0.11726804,0.42666668,0.11726804,0.43,0.11726804,0.43333334,0.11726804,0.43666667,0.11726804,0.44,0.11726804,0.44333333,0.11726804,0.44666666,0.11726804,0.45,0.11726804,0.45333335,0.11726804,0.45666668,0.11726804,0.46,0.11726804,0.46333334,0.11726804,0.46666667,0.11726804,0.47,0.11726804,0.47333333,0.11726804,0.47666666,0.11726804,0.48,0.11726804,0.48333332,0.11726804,0.48666668,0.11726804,0.49,0.11726804,0.49333334,0.11726804,0.49666667,0.11726804,0.5,0.11726804,0.50333333,0.11726804,0.50666666,0.11726804,0.51,0.11726804,0.5133333,0.11726804,0.51666665,0.11726804,0.52,0.11726804,0.5233333,0.11726804,0.52666664,0.11726804,0.53,0.11726804,0.53333336,0.11726804,0.5366667,0.11726804,0.54,0.11726804,0.54333335,0.11726804,0.5466667,0.11726804,0.55,0.11726804,0.55333334,0.11726804,0.5566667,0.11726804,0.56,0.11726804,0.56333333,0.11726804,0.56666666,0.11726804,0.57,0.11726804,0.5733333,0.11726804,0.57666665,0.11726804,0.58,0.11726804,0.5833333,0.11726804,0.58666664,0.11726804,0.59,0.11726804,0.5933333,0.11726804,0.5966667,0.11726804,0.6,0.11726804,0.60333335,0.11726804,0.6066667,0.11726804,0.61,0.11726804,0.61333334,0.11726804,0.6166667,0.11726804,0.62,0.11726804,0.62333333,0.11726804,0.62666667,0.11726804,0.63,0.11726804,0.6333333,0.11726804,0.63666666,0.11726804,0.64,0.11726804,0.6433333,0.11726804,0.64666665,0.11726804,0.65,0.11726804,0.6533333,0.11726804,0.6566667,0.11726804,0.66,0.11726804,0.66333336,0.11726804,0.6666667,0.11726804,0.67,0.11726804,0.67333335,0.11726804,0.6766667,0.11726804,0.68,0.11726804,0.68333334,0.11726804,0.68666667,0.11726804,0.69,0.11726804,0.6933333,0.11726804,0.69666666,0.11726804,0.7,0.11726804,0.7033333,0.11726804,0.70666665,0.11726804,0.71,0.11726804,0.7133333,0.11726804,0.71666664,0.11726804,0.72,0.11726804,0.72333336,0.11726804,0.7266667,0.11726804,0.73,0.11726804,0.73333335,0.11726804,0.7366667,0.11726804,0.74,0.11726804,0.76,0.11726804,0.7633333,0.11726804,0.76666665,0.11726804,0.77,0.11726804,0.79,0.11726804,0.79333335,0.11726804,0.7966667,0.11726804,0.82,0.11726804,0.8233333,0.11726804,0.82666665,0.11726804,0.85,0.11726804,0.85333335,0.11726804,0.8566667,0.11726804,0.86,0.11726804,0.86333334,0.11726804,0.8666667,0.11726804,0.87,0.11726804,0.87333333,0.11726804,0.87666667,0.11726804,0.88,0.11726804,0.8833333,0.11726804,0.88666666,0.11726804,0.89,0.11726804,0.8933333,0.11726804,0.89666665,0.11726804,0.9,0.11726804,0.9033333,0.11726804,0.9066667,0.11726804,0.91,0.11726804,0.91333336,0.11726804,0.9166667,0.11726804,0.92,0.11726804,0.92333335,0.11726804,0.9266667,0.11726804,0.93,0.11726804,0.93333334,0.11726804,0.94,0.11726804,0.9433333,0.11726804,0.94666666,0.11726804,0.05,0.11984536,0.053333335,0.11984536,0.05666667,0.11984536,0.06,0.11984536,0.06333333,0.11984536,0.06666667,0.11984536,0.07,0.11984536,0.07333333,0.11984536,0.07666667,0.11984536,0.08,0.11984536,0.083333336,0.11984536,0.086666666,0.11984536,0.09,0.11984536,0.093333334,0.11984536,0.096666664,0.11984536,0.1,0.11984536,0.10333333,0.11984536,0.10666667,0.11984536,0.11,0.11984536,0.11333334,0.11984536,0.11666667,0.11984536,0.12,0.11984536,0.123333335,0.11984536,0.12666667,0.11984536,0.13,0.11984536,0.13333334,0.11984536,0.13666667,0.11984536,0.14,0.11984536,0.14333333,0.11984536,0.14666666,0.11984536,0.15,0.11984536,0.15333334,0.11984536,0.15666667,0.11984536,0.16,0.11984536,0.16333333,0.11984536,0.16666667,0.11984536,0.17,0.11984536,0.17333333,0.11984536,0.17666666,0.11984536,0.18,0.11984536,0.18333334,0.11984536,0.18666667,0.11984536,0.19,0.11984536,0.19333333,0.11984536,0.19666667,0.11984536,0.2,0.11984536,0.20333333,0.11984536,0.20666666,0.11984536,0.21,0.11984536,0.21333334,0.11984536,0.21666667,0.11984536,0.22,0.11984536,0.22333333,0.11984536,0.22666667,0.11984536,0.23,0.11984536,0.23333333,0.11984536,0.23666666,0.11984536,0.24,0.11984536,0.24333334,0.11984536,0.24666667,0.11984536,0.25,0.11984536,0.25333333,0.11984536,0.25666666,0.11984536,0.26,0.11984536,0.26333332,0.11984536,0.26666668,0.11984536,0.27,0.11984536,0.27333334,0.11984536,0.27666667,0.11984536,0.28,0.11984536,0.28333333,0.11984536,0.28666666,0.11984536,0.29,0.11984536,0.29333332,0.11984536,0.29666665,0.11984536,0.3,0.11984536,0.30333334,0.11984536,0.30666667,0.11984536,0.31,0.11984536,0.31333333,0.11984536,0.31666666,0.11984536,0.32,0.11984536,0.32333332,0.11984536,0.32666665,0.11984536,0.33,0.11984536,0.33333334,0.11984536,0.33666667,0.11984536,0.34,0.11984536,0.34333333,0.11984536,0.34666666,0.11984536,0.35,0.11984536,0.35333332,0.11984536,0.35666665,0.11984536,0.36,0.11984536,0.36333334,0.11984536,0.36666667,0.11984536,0.37,0.11984536,0.37333333,0.11984536,0.37666667,0.11984536,0.38,0.11984536,0.38333333,0.11984536,0.38666666,0.11984536,0.39,0.11984536,0.39333335,0.11984536,0.39666668,0.11984536,0.4,0.11984536,0.40333334,0.11984536,0.40666667,0.11984536,0.41,0.11984536,0.41333333,0.11984536,0.41666666,0.11984536,0.42,0.11984536,0.42333335,0.11984536,0.42666668,0.11984536,0.43,0.11984536,0.43333334,0.11984536,0.43666667,0.11984536,0.44,0.11984536,0.44333333,0.11984536,0.44666666,0.11984536,0.45,0.11984536,0.45333335,0.11984536,0.45666668,0.11984536,0.46,0.11984536,0.46333334,0.11984536,0.46666667,0.11984536,0.47,0.11984536,0.47333333,0.11984536,0.47666666,0.11984536,0.48,0.11984536,0.48333332,0.11984536,0.48666668,0.11984536,0.49,0.11984536,0.49333334,0.11984536,0.49666667,0.11984536,0.5,0.11984536,0.50333333,0.11984536,0.50666666,0.11984536,0.51,0.11984536,0.5133333,0.11984536,0.51666665,0.11984536,0.52,0.11984536,0.5233333,0.11984536,0.52666664,0.11984536,0.53,0.11984536,0.53333336,0.11984536,0.5366667,0.11984536,0.54,0.11984536,0.54333335,0.11984536,0.5466667,0.11984536,0.55,0.11984536,0.55333334,0.11984536,0.5566667,0.11984536,0.56,0.11984536,0.56333333,0.11984536,0.56666666,0.11984536,0.57,0.11984536,0.5733333,0.11984536,0.57666665,0.11984536,0.58,0.11984536,0.5833333,0.11984536,0.58666664,0.11984536,0.59,0.11984536,0.5933333,0.11984536,0.5966667,0.11984536,0.6,0.11984536,0.60333335,0.11984536,0.6066667,0.11984536,0.61,0.11984536,0.61333334,0.11984536,0.6166667,0.11984536,0.62,0.11984536,0.62333333,0.11984536,0.62666667,0.11984536,0.63,0.11984536,0.6333333,0.11984536,0.63666666,0.11984536,0.64,0.11984536,0.6433333,0.11984536,0.64666665,0.11984536,0.65,0.11984536,0.6566667,0.11984536,0.66,0.11984536,0.66333336,0.11984536,0.6666667,0.11984536,0.67,0.11984536,0.67333335,0.11984536,0.6766667,0.11984536,0.68,0.11984536,0.68333334,0.11984536,0.68666667,0.11984536,0.69,0.11984536,0.6933333,0.11984536,0.69666666,0.11984536,0.7,0.11984536,0.7033333,0.11984536,0.70666665,0.11984536,0.71,0.11984536,0.7133333,0.11984536,0.71666664,0.11984536,0.72,0.11984536,0.72333336,0.11984536,0.7266667,0.11984536,0.73,0.11984536,0.73333335,0.11984536,0.7366667,0.11984536,0.74,0.11984536,0.74333334,0.11984536,0.74666667,0.11984536,0.7633333,0.11984536,0.76666665,0.11984536,0.77,0.11984536,0.78,0.11984536,0.79333335,0.11984536,0.7966667,0.11984536,0.81,0.11984536,0.8233333,0.11984536,0.8333333,0.11984536,0.83666664,0.11984536,0.84,0.11984536,0.85,0.11984536,0.85333335,0.11984536,0.8566667,0.11984536,0.86,0.11984536,0.86333334,0.11984536,0.8666667,0.11984536,0.87,0.11984536,0.87333333,0.11984536,0.87666667,0.11984536,0.88,0.11984536,0.8833333,0.11984536,0.88666666,0.11984536,0.89,0.11984536,0.8933333,0.11984536,0.89666665,0.11984536,0.9,0.11984536,0.9033333,0.11984536,0.9066667,0.11984536,0.91,0.11984536,0.91333336,0.11984536,0.9166667,0.11984536,0.92,0.11984536,0.92333335,0.11984536,0.9266667,0.11984536,0.93,0.11984536,0.93333334,0.11984536,0.94,0.11984536,0.9433333,0.11984536,0.94666666,0.11984536,0.05,0.12242268,0.053333335,0.12242268,0.05666667,0.12242268,0.06,0.12242268,0.06333333,0.12242268,0.06666667,0.12242268,0.07,0.12242268,0.07333333,0.12242268,0.07666667,0.12242268,0.08,0.12242268,0.083333336,0.12242268,0.086666666,0.12242268,0.09,0.12242268,0.093333334,0.12242268,0.096666664,0.12242268,0.1,0.12242268,0.10333333,0.12242268,0.10666667,0.12242268,0.11,0.12242268,0.11333334,0.12242268,0.11666667,0.12242268,0.12,0.12242268,0.123333335,0.12242268,0.12666667,0.12242268,0.13,0.12242268,0.13333334,0.12242268,0.13666667,0.12242268,0.14,0.12242268,0.14333333,0.12242268,0.14666666,0.12242268,0.15,0.12242268,0.15333334,0.12242268,0.15666667,0.12242268,0.16,0.12242268,0.16333333,0.12242268,0.16666667,0.12242268,0.17,0.12242268,0.17333333,0.12242268,0.17666666,0.12242268,0.18,0.12242268,0.18333334,0.12242268,0.18666667,0.12242268,0.19,0.12242268,0.19333333,0.12242268,0.19666667,0.12242268,0.2,0.12242268,0.20333333,0.12242268,0.20666666,0.12242268,0.21,0.12242268,0.21333334,0.12242268,0.21666667,0.12242268,0.22,0.12242268,0.22333333,0.12242268,0.22666667,0.12242268,0.23,0.12242268,0.23333333,0.12242268,0.23666666,0.12242268,0.24,0.12242268,0.24333334,0.12242268,0.24666667,0.12242268,0.25,0.12242268,0.25333333,0.12242268,0.25666666,0.12242268,0.26,0.12242268,0.26333332,0.12242268,0.26666668,0.12242268,0.27,0.12242268,0.27333334,0.12242268,0.27666667,0.12242268,0.28,0.12242268,0.28333333,0.12242268,0.28666666,0.12242268,0.29,0.12242268,0.29333332,0.12242268,0.29666665,0.12242268,0.3,0.12242268,0.30333334,0.12242268,0.30666667,0.12242268,0.31,0.12242268,0.31333333,0.12242268,0.31666666,0.12242268,0.32,0.12242268,0.32333332,0.12242268,0.32666665,0.12242268,0.33,0.12242268,0.33333334,0.12242268,0.33666667,0.12242268,0.34,0.12242268,0.34333333,0.12242268,0.34666666,0.12242268,0.35,0.12242268,0.35333332,0.12242268,0.35666665,0.12242268,0.36,0.12242268,0.36333334,0.12242268,0.36666667,0.12242268,0.37,0.12242268,0.37333333,0.12242268,0.37666667,0.12242268,0.38,0.12242268,0.38333333,0.12242268,0.38666666,0.12242268,0.39,0.12242268,0.39333335,0.12242268,0.39666668,0.12242268,0.4,0.12242268,0.40333334,0.12242268,0.40666667,0.12242268,0.41,0.12242268,0.41333333,0.12242268,0.41666666,0.12242268,0.42,0.12242268,0.42333335,0.12242268,0.42666668,0.12242268,0.43,0.12242268,0.43333334,0.12242268,0.43666667,0.12242268,0.44,0.12242268,0.44333333,0.12242268,0.44666666,0.12242268,0.45,0.12242268,0.45333335,0.12242268,0.45666668,0.12242268,0.46,0.12242268,0.46333334,0.12242268,0.46666667,0.12242268,0.47,0.12242268,0.47333333,0.12242268,0.47666666,0.12242268,0.48,0.12242268,0.48333332,0.12242268,0.48666668,0.12242268,0.49,0.12242268,0.49333334,0.12242268,0.49666667,0.12242268,0.5,0.12242268,0.50333333,0.12242268,0.50666666,0.12242268,0.51,0.12242268,0.5133333,0.12242268,0.51666665,0.12242268,0.52,0.12242268,0.5233333,0.12242268,0.52666664,0.12242268,0.53,0.12242268,0.53333336,0.12242268,0.5366667,0.12242268,0.54,0.12242268,0.54333335,0.12242268,0.5466667,0.12242268,0.55,0.12242268,0.55333334,0.12242268,0.5566667,0.12242268,0.56,0.12242268,0.56333333,0.12242268,0.56666666,0.12242268,0.57,0.12242268,0.5733333,0.12242268,0.57666665,0.12242268,0.58,0.12242268,0.5833333,0.12242268,0.58666664,0.12242268,0.59,0.12242268,0.5933333,0.12242268,0.5966667,0.12242268,0.6,0.12242268,0.60333335,0.12242268,0.6066667,0.12242268,0.61,0.12242268,0.61333334,0.12242268,0.6166667,0.12242268,0.62,0.12242268,0.62333333,0.12242268,0.62666667,0.12242268,0.63,0.12242268,0.6333333,0.12242268,0.63666666,0.12242268,0.64,0.12242268,0.6433333,0.12242268,0.64666665,0.12242268,0.6566667,0.12242268,0.66,0.12242268,0.66333336,0.12242268,0.6666667,0.12242268,0.67,0.12242268,0.67333335,0.12242268,0.6766667,0.12242268,0.68,0.12242268,0.68333334,0.12242268,0.68666667,0.12242268,0.69,0.12242268,0.6933333,0.12242268,0.69666666,0.12242268,0.7,0.12242268,0.7033333,0.12242268,0.70666665,0.12242268,0.71,0.12242268,0.7133333,0.12242268,0.71666664,0.12242268,0.72,0.12242268,0.72333336,0.12242268,0.7266667,0.12242268,0.73,0.12242268,0.73333335,0.12242268,0.7366667,0.12242268,0.74,0.12242268,0.74333334,0.12242268,0.74666667,0.12242268,0.75,0.12242268,0.76666665,0.12242268,0.77,0.12242268,0.78,0.12242268,0.78333336,0.12242268,0.79333335,0.12242268,0.7966667,0.12242268,0.8066667,0.12242268,0.81,0.12242268,0.81333333,0.12242268,0.8233333,0.12242268,0.8333333,0.12242268,0.83666664,0.12242268,0.84,0.12242268,0.85,0.12242268,0.85333335,0.12242268,0.8566667,0.12242268,0.86,0.12242268,0.86333334,0.12242268,0.8666667,0.12242268,0.87,0.12242268,0.87333333,0.12242268,0.87666667,0.12242268,0.88,0.12242268,0.8833333,0.12242268,0.88666666,0.12242268,0.89,0.12242268,0.8933333,0.12242268,0.89666665,0.12242268,0.9,0.12242268,0.9033333,0.12242268,0.9066667,0.12242268,0.91,0.12242268,0.91333336,0.12242268,0.9166667,0.12242268,0.92,0.12242268,0.92333335,0.12242268,0.9266667,0.12242268,0.93,0.12242268,0.93333334,0.12242268,0.94666666,0.12242268,0.05,0.125,0.053333335,0.125,0.05666667,0.125,0.06,0.125,0.06333333,0.125,0.06666667,0.125,0.07,0.125,0.07333333,0.125,0.07666667,0.125,0.08,0.125,0.083333336,0.125,0.086666666,0.125,0.09,0.125,0.093333334,0.125,0.096666664,0.125,0.1,0.125,0.10333333,0.125,0.10666667,0.125,0.11,0.125,0.11333334,0.125,0.11666667,0.125,0.12,0.125,0.123333335,0.125,0.12666667,0.125,0.13,0.125,0.13333334,0.125,0.13666667,0.125,0.14,0.125,0.14333333,0.125,0.14666666,0.125,0.15,0.125,0.15333334,0.125,0.15666667,0.125,0.16,0.125,0.16333333,0.125,0.16666667,0.125,0.17,0.125,0.17333333,0.125,0.17666666,0.125,0.18,0.125,0.18333334,0.125,0.18666667,0.125,0.19,0.125,0.19333333,0.125,0.19666667,0.125,0.2,0.125,0.20333333,0.125,0.20666666,0.125,0.21,0.125,0.21333334,0.125,0.21666667,0.125,0.22,0.125,0.22333333,0.125,0.22666667,0.125,0.23,0.125,0.23333333,0.125,0.23666666,0.125,0.24,0.125,0.24333334,0.125,0.24666667,0.125,0.25,0.125,0.25333333,0.125,0.25666666,0.125,0.26,0.125,0.26333332,0.125,0.26666668,0.125,0.27,0.125,0.27333334,0.125,0.27666667,0.125,0.28,0.125,0.28333333,0.125,0.28666666,0.125,0.29,0.125,0.29333332,0.125,0.29666665,0.125,0.3,0.125,0.30333334,0.125,0.30666667,0.125,0.31,0.125,0.31333333,0.125,0.31666666,0.125,0.32,0.125,0.32333332,0.125,0.32666665,0.125,0.33,0.125,0.33333334,0.125,0.33666667,0.125,0.34,0.125,0.34333333,0.125,0.34666666,0.125,0.35,0.125,0.35333332,0.125,0.35666665,0.125,0.36,0.125,0.36333334,0.125,0.36666667,0.125,0.37,0.125,0.37333333,0.125,0.37666667,0.125,0.38,0.125,0.38333333,0.125,0.38666666,0.125,0.39,0.125,0.39333335,0.125,0.39666668,0.125,0.4,0.125,0.40333334,0.125,0.40666667,0.125,0.41,0.125,0.41333333,0.125,0.41666666,0.125,0.42,0.125,0.42333335,0.125,0.42666668,0.125,0.43,0.125,0.43333334,0.125,0.43666667,0.125,0.44,0.125,0.44333333,0.125,0.44666666,0.125,0.45,0.125,0.45333335,0.125,0.45666668,0.125,0.46,0.125,0.46333334,0.125,0.46666667,0.125,0.47,0.125,0.47333333,0.125,0.47666666,0.125,0.48,0.125,0.48333332,0.125,0.48666668,0.125,0.49,0.125,0.49333334,0.125,0.49666667,0.125,0.5,0.125,0.50333333,0.125,0.50666666,0.125,0.51,0.125,0.5133333,0.125,0.51666665,0.125,0.52,0.125,0.5233333,0.125,0.52666664,0.125,0.53,0.125,0.53333336,0.125,0.5366667,0.125,0.54,0.125,0.54333335,0.125,0.5466667,0.125,0.55,0.125,0.55333334,0.125,0.5566667,0.125,0.56,0.125,0.56333333,0.125,0.56666666,0.125,0.57,0.125,0.5733333,0.125,0.57666665,0.125,0.58,0.125,0.5833333,0.125,0.58666664,0.125,0.59,0.125,0.5933333,0.125,0.5966667,0.125,0.6,0.125,0.60333335,0.125,0.6066667,0.125,0.61,0.125,0.61333334,0.125,0.6166667,0.125,0.62,0.125,0.62333333,0.125,0.63,0.125,0.6333333,0.125,0.63666666,0.125,0.64,0.125,0.6433333,0.125,0.64666665,0.125,0.65,0.125,0.6533333,0.125,0.6566667,0.125,0.66,0.125,0.66333336,0.125,0.6666667,0.125,0.67,0.125,0.67333335,0.125,0.6766667,0.125,0.68,0.125,0.68333334,0.125,0.68666667,0.125,0.69,0.125,0.6933333,0.125,0.69666666,0.125,0.7,0.125,0.7033333,0.125,0.70666665,0.125,0.71,0.125,0.7133333,0.125,0.71666664,0.125,0.72,0.125,0.72333336,0.125,0.7266667,0.125,0.73,0.125,0.73333335,0.125,0.7366667,0.125,0.74,0.125,0.74333334,0.125,0.74666667,0.125,0.75,0.125,0.75333333,0.125,0.76666665,0.125,0.77,0.125,0.78,0.125,0.78333336,0.125,0.79333335,0.125,0.7966667,0.125,0.8066667,0.125,0.81,0.125,0.81333333,0.125,0.8233333,0.125,0.83666664,0.125,0.85,0.125,0.85333335,0.125,0.8566667,0.125,0.86,0.125,0.86333334,0.125,0.8666667,0.125,0.87,0.125,0.87333333,0.125,0.87666667,0.125,0.88,0.125,0.8833333,0.125,0.88666666,0.125,0.89,0.125,0.8933333,0.125,0.89666665,0.125,0.9,0.125,0.9033333,0.125,0.9066667,0.125,0.91,0.125,0.91333336,0.125,0.9166667,0.125,0.92,0.125,0.92333335,0.125,0.9266667,0.125,0.93,0.125,0.93333334,0.125,0.93666667,0.125,0.9433333,0.125,0.94666666,0.125,0.05,0.12757732,0.053333335,0.12757732,0.05666667,0.12757732,0.06,0.12757732,0.06333333,0.12757732,0.06666667,0.12757732,0.07,0.12757732,0.07333333,0.12757732,0.07666667,0.12757732,0.08,0.12757732,0.083333336,0.12757732,0.086666666,0.12757732,0.09,0.12757732,0.093333334,0.12757732,0.096666664,0.12757732,0.1,0.12757732,0.10333333,0.12757732,0.10666667,0.12757732,0.11,0.12757732,0.11333334,0.12757732,0.11666667,0.12757732,0.12,0.12757732,0.123333335,0.12757732,0.12666667,0.12757732,0.13,0.12757732,0.13333334,0.12757732,0.13666667,0.12757732,0.14,0.12757732,0.14333333,0.12757732,0.14666666,0.12757732,0.15,0.12757732,0.15333334,0.12757732,0.15666667,0.12757732,0.16,0.12757732,0.16333333,0.12757732,0.16666667,0.12757732,0.17,0.12757732,0.17333333,0.12757732,0.17666666,0.12757732,0.18,0.12757732,0.18333334,0.12757732,0.18666667,0.12757732,0.19,0.12757732,0.19333333,0.12757732,0.19666667,0.12757732,0.2,0.12757732,0.20333333,0.12757732,0.20666666,0.12757732,0.21,0.12757732,0.21333334,0.12757732,0.21666667,0.12757732,0.22,0.12757732,0.22333333,0.12757732,0.22666667,0.12757732,0.23,0.12757732,0.23333333,0.12757732,0.23666666,0.12757732,0.24,0.12757732,0.24333334,0.12757732,0.24666667,0.12757732,0.25,0.12757732,0.25333333,0.12757732,0.25666666,0.12757732,0.26,0.12757732,0.26333332,0.12757732,0.26666668,0.12757732,0.27,0.12757732,0.27333334,0.12757732,0.27666667,0.12757732,0.28,0.12757732,0.28333333,0.12757732,0.28666666,0.12757732,0.29,0.12757732,0.29333332,0.12757732,0.29666665,0.12757732,0.3,0.12757732,0.30333334,0.12757732,0.30666667,0.12757732,0.31,0.12757732,0.31333333,0.12757732,0.31666666,0.12757732,0.32,0.12757732,0.32333332,0.12757732,0.32666665,0.12757732,0.33,0.12757732,0.33333334,0.12757732,0.33666667,0.12757732,0.34,0.12757732,0.34333333,0.12757732,0.34666666,0.12757732,0.35,0.12757732,0.35333332,0.12757732,0.35666665,0.12757732,0.36,0.12757732,0.36333334,0.12757732,0.36666667,0.12757732,0.37,0.12757732,0.37333333,0.12757732,0.37666667,0.12757732,0.38,0.12757732,0.38333333,0.12757732,0.38666666,0.12757732,0.39,0.12757732,0.39333335,0.12757732,0.39666668,0.12757732,0.4,0.12757732,0.40333334,0.12757732,0.40666667,0.12757732,0.41,0.12757732,0.41333333,0.12757732,0.41666666,0.12757732,0.42,0.12757732,0.42333335,0.12757732,0.42666668,0.12757732,0.43,0.12757732,0.43333334,0.12757732,0.43666667,0.12757732,0.44,0.12757732,0.44333333,0.12757732,0.44666666,0.12757732,0.45,0.12757732,0.45333335,0.12757732,0.45666668,0.12757732,0.46,0.12757732,0.46333334,0.12757732,0.46666667,0.12757732,0.47,0.12757732,0.47333333,0.12757732,0.47666666,0.12757732,0.48,0.12757732,0.48333332,0.12757732,0.48666668,0.12757732,0.49,0.12757732,0.49333334,0.12757732,0.49666667,0.12757732,0.5,0.12757732,0.50333333,0.12757732,0.50666666,0.12757732,0.51,0.12757732,0.5133333,0.12757732,0.51666665,0.12757732,0.52,0.12757732,0.5233333,0.12757732,0.52666664,0.12757732,0.53,0.12757732,0.53333336,0.12757732,0.5366667,0.12757732,0.54,0.12757732,0.54333335,0.12757732,0.5466667,0.12757732,0.55,0.12757732,0.55333334,0.12757732,0.5566667,0.12757732,0.56,0.12757732,0.56333333,0.12757732,0.56666666,0.12757732,0.57,0.12757732,0.5733333,0.12757732,0.57666665,0.12757732,0.58,0.12757732,0.5833333,0.12757732,0.58666664,0.12757732,0.59,0.12757732,0.5933333,0.12757732,0.5966667,0.12757732,0.6,0.12757732,0.60333335,0.12757732,0.6066667,0.12757732,0.61,0.12757732,0.61333334,0.12757732,0.6166667,0.12757732,0.62,0.12757732,0.62333333,0.12757732,0.62666667,0.12757732,0.63,0.12757732,0.6333333,0.12757732,0.63666666,0.12757732,0.64,0.12757732,0.6433333,0.12757732,0.64666665,0.12757732,0.65,0.12757732,0.6533333,0.12757732,0.6566667,0.12757732,0.66,0.12757732,0.66333336,0.12757732,0.6666667,0.12757732,0.67,0.12757732,0.67333335,0.12757732,0.6766667,0.12757732,0.68,0.12757732,0.68333334,0.12757732,0.68666667,0.12757732,0.69,0.12757732,0.6933333,0.12757732,0.69666666,0.12757732,0.7,0.12757732,0.7033333,0.12757732,0.70666665,0.12757732,0.71,0.12757732,0.7133333,0.12757732,0.71666664,0.12757732,0.72,0.12757732,0.72333336,0.12757732,0.7266667,0.12757732,0.73,0.12757732,0.73333335,0.12757732,0.7366667,0.12757732,0.74,0.12757732,0.74333334,0.12757732,0.75,0.12757732,0.75333333,0.12757732,0.76666665,0.12757732,0.77,0.12757732,0.79333335,0.12757732,0.7966667,0.12757732,0.8066667,0.12757732,0.81,0.12757732,0.81333333,0.12757732,0.8233333,0.12757732,0.82666665,0.12757732,0.85,0.12757732,0.85333335,0.12757732,0.8566667,0.12757732,0.86,0.12757732,0.86333334,0.12757732,0.8666667,0.12757732,0.87,0.12757732,0.87333333,0.12757732,0.87666667,0.12757732,0.88,0.12757732,0.8833333,0.12757732,0.88666666,0.12757732,0.89,0.12757732,0.8933333,0.12757732,0.89666665,0.12757732,0.9,0.12757732,0.9033333,0.12757732,0.9066667,0.12757732,0.91,0.12757732,0.91333336,0.12757732,0.9166667,0.12757732,0.92,0.12757732,0.92333335,0.12757732,0.9266667,0.12757732,0.93,0.12757732,0.93333334,0.12757732,0.93666667,0.12757732,0.94,0.12757732,0.9433333,0.12757732,0.94666666,0.12757732,0.05,0.13015464,0.053333335,0.13015464,0.05666667,0.13015464,0.06,0.13015464,0.06333333,0.13015464,0.06666667,0.13015464,0.07,0.13015464,0.07333333,0.13015464,0.07666667,0.13015464,0.08,0.13015464,0.083333336,0.13015464,0.086666666,0.13015464,0.09,0.13015464,0.093333334,0.13015464,0.096666664,0.13015464,0.1,0.13015464,0.10333333,0.13015464,0.10666667,0.13015464,0.11,0.13015464,0.11333334,0.13015464,0.11666667,0.13015464,0.12,0.13015464,0.123333335,0.13015464,0.12666667,0.13015464,0.13,0.13015464,0.13333334,0.13015464,0.13666667,0.13015464,0.14,0.13015464,0.14333333,0.13015464,0.14666666,0.13015464,0.15,0.13015464,0.15333334,0.13015464,0.15666667,0.13015464,0.16,0.13015464,0.16333333,0.13015464,0.16666667,0.13015464,0.17,0.13015464,0.17333333,0.13015464,0.17666666,0.13015464,0.18,0.13015464,0.18333334,0.13015464,0.18666667,0.13015464,0.19,0.13015464,0.19333333,0.13015464,0.19666667,0.13015464,0.2,0.13015464,0.20333333,0.13015464,0.20666666,0.13015464,0.21,0.13015464,0.21333334,0.13015464,0.21666667,0.13015464,0.22,0.13015464,0.22333333,0.13015464,0.22666667,0.13015464,0.23,0.13015464,0.23333333,0.13015464,0.23666666,0.13015464,0.24,0.13015464,0.24333334,0.13015464,0.24666667,0.13015464,0.25,0.13015464,0.25333333,0.13015464,0.25666666,0.13015464,0.26,0.13015464,0.26333332,0.13015464,0.26666668,0.13015464,0.27,0.13015464,0.27333334,0.13015464,0.27666667,0.13015464,0.28,0.13015464,0.28333333,0.13015464,0.28666666,0.13015464,0.29,0.13015464,0.29333332,0.13015464,0.29666665,0.13015464,0.3,0.13015464,0.30333334,0.13015464,0.30666667,0.13015464,0.31,0.13015464,0.31333333,0.13015464,0.31666666,0.13015464,0.32,0.13015464,0.32333332,0.13015464,0.32666665,0.13015464,0.33,0.13015464,0.33333334,0.13015464,0.33666667,0.13015464,0.34,0.13015464,0.34333333,0.13015464,0.34666666,0.13015464,0.35,0.13015464,0.35333332,0.13015464,0.35666665,0.13015464,0.36,0.13015464,0.36333334,0.13015464,0.36666667,0.13015464,0.37,0.13015464,0.37333333,0.13015464,0.37666667,0.13015464,0.38,0.13015464,0.38333333,0.13015464,0.38666666,0.13015464,0.39,0.13015464,0.39333335,0.13015464,0.39666668,0.13015464,0.4,0.13015464,0.40333334,0.13015464,0.40666667,0.13015464,0.41,0.13015464,0.41333333,0.13015464,0.41666666,0.13015464,0.42,0.13015464,0.42333335,0.13015464,0.42666668,0.13015464,0.43,0.13015464,0.43333334,0.13015464,0.43666667,0.13015464,0.44,0.13015464,0.44333333,0.13015464,0.44666666,0.13015464,0.45,0.13015464,0.45333335,0.13015464,0.45666668,0.13015464,0.46,0.13015464,0.46333334,0.13015464,0.46666667,0.13015464,0.47,0.13015464,0.47333333,0.13015464,0.47666666,0.13015464,0.48,0.13015464,0.48333332,0.13015464,0.48666668,0.13015464,0.49,0.13015464,0.49333334,0.13015464,0.49666667,0.13015464,0.5,0.13015464,0.50333333,0.13015464,0.50666666,0.13015464,0.51,0.13015464,0.5133333,0.13015464,0.51666665,0.13015464,0.52,0.13015464,0.5233333,0.13015464,0.52666664,0.13015464,0.53,0.13015464,0.53333336,0.13015464,0.5366667,0.13015464,0.54,0.13015464,0.54333335,0.13015464,0.5466667,0.13015464,0.55333334,0.13015464,0.5566667,0.13015464,0.56,0.13015464,0.56333333,0.13015464,0.56666666,0.13015464,0.57,0.13015464,0.5733333,0.13015464,0.57666665,0.13015464,0.58,0.13015464,0.5833333,0.13015464,0.58666664,0.13015464,0.59,0.13015464,0.5933333,0.13015464,0.5966667,0.13015464,0.6,0.13015464,0.60333335,0.13015464,0.6066667,0.13015464,0.61,0.13015464,0.61333334,0.13015464,0.6166667,0.13015464,0.62,0.13015464,0.62333333,0.13015464,0.62666667,0.13015464,0.63,0.13015464,0.6333333,0.13015464,0.63666666,0.13015464,0.64,0.13015464,0.6433333,0.13015464,0.64666665,0.13015464,0.65,0.13015464,0.6533333,0.13015464,0.6566667,0.13015464,0.66,0.13015464,0.66333336,0.13015464,0.6666667,0.13015464,0.67,0.13015464,0.67333335,0.13015464,0.6766667,0.13015464,0.68,0.13015464,0.68333334,0.13015464,0.68666667,0.13015464,0.69,0.13015464,0.6933333,0.13015464,0.69666666,0.13015464,0.7,0.13015464,0.7033333,0.13015464,0.70666665,0.13015464,0.71,0.13015464,0.7133333,0.13015464,0.71666664,0.13015464,0.72,0.13015464,0.72333336,0.13015464,0.7266667,0.13015464,0.73,0.13015464,0.73333335,0.13015464,0.7366667,0.13015464,0.74,0.13015464,0.74333334,0.13015464,0.7633333,0.13015464,0.76666665,0.13015464,0.77,0.13015464,0.7733333,0.13015464,0.79,0.13015464,0.79333335,0.13015464,0.7966667,0.13015464,0.8066667,0.13015464,0.81,0.13015464,0.81333333,0.13015464,0.82,0.13015464,0.8233333,0.13015464,0.82666665,0.13015464,0.83,0.13015464,0.8466667,0.13015464,0.85,0.13015464,0.85333335,0.13015464,0.8566667,0.13015464,0.86,0.13015464,0.86333334,0.13015464,0.8666667,0.13015464,0.87,0.13015464,0.87333333,0.13015464,0.87666667,0.13015464,0.88,0.13015464,0.8833333,0.13015464,0.88666666,0.13015464,0.89,0.13015464,0.8933333,0.13015464,0.89666665,0.13015464,0.9,0.13015464,0.9033333,0.13015464,0.9066667,0.13015464,0.91,0.13015464,0.91333336,0.13015464,0.9166667,0.13015464,0.92,0.13015464,0.92333335,0.13015464,0.9266667,0.13015464,0.93,0.13015464,0.93333334,0.13015464,0.93666667,0.13015464,0.94,0.13015464,0.9433333,0.13015464,0.94666666,0.13015464,0.05,0.13273196,0.053333335,0.13273196,0.05666667,0.13273196,0.06,0.13273196,0.06333333,0.13273196,0.06666667,0.13273196,0.07,0.13273196,0.07333333,0.13273196,0.07666667,0.13273196,0.08,0.13273196,0.083333336,0.13273196,0.086666666,0.13273196,0.09,0.13273196,0.093333334,0.13273196,0.096666664,0.13273196,0.1,0.13273196,0.10333333,0.13273196,0.10666667,0.13273196,0.11,0.13273196,0.11333334,0.13273196,0.11666667,0.13273196,0.12,0.13273196,0.123333335,0.13273196,0.12666667,0.13273196,0.13,0.13273196,0.13333334,0.13273196,0.13666667,0.13273196,0.14,0.13273196,0.14333333,0.13273196,0.14666666,0.13273196,0.15,0.13273196,0.15333334,0.13273196,0.15666667,0.13273196,0.16,0.13273196,0.16333333,0.13273196,0.16666667,0.13273196,0.17,0.13273196,0.17333333,0.13273196,0.17666666,0.13273196,0.18,0.13273196,0.18333334,0.13273196,0.18666667,0.13273196,0.19,0.13273196,0.19333333,0.13273196,0.19666667,0.13273196,0.2,0.13273196,0.20333333,0.13273196,0.20666666,0.13273196,0.21,0.13273196,0.21333334,0.13273196,0.21666667,0.13273196,0.22,0.13273196,0.22333333,0.13273196,0.22666667,0.13273196,0.23,0.13273196,0.23333333,0.13273196,0.23666666,0.13273196,0.24,0.13273196,0.24333334,0.13273196,0.24666667,0.13273196,0.25,0.13273196,0.25333333,0.13273196,0.25666666,0.13273196,0.26,0.13273196,0.26333332,0.13273196,0.26666668,0.13273196,0.27,0.13273196,0.27333334,0.13273196,0.27666667,0.13273196,0.28,0.13273196,0.28333333,0.13273196,0.28666666,0.13273196,0.29,0.13273196,0.29333332,0.13273196,0.29666665,0.13273196,0.3,0.13273196,0.30333334,0.13273196,0.30666667,0.13273196,0.31,0.13273196,0.31333333,0.13273196,0.31666666,0.13273196,0.32,0.13273196,0.32333332,0.13273196,0.32666665,0.13273196,0.33,0.13273196,0.33333334,0.13273196,0.33666667,0.13273196,0.34,0.13273196,0.34333333,0.13273196,0.34666666,0.13273196,0.35,0.13273196,0.35333332,0.13273196,0.35666665,0.13273196,0.36,0.13273196,0.36333334,0.13273196,0.36666667,0.13273196,0.37,0.13273196,0.37333333,0.13273196,0.37666667,0.13273196,0.38,0.13273196,0.38333333,0.13273196,0.38666666,0.13273196,0.39,0.13273196,0.39333335,0.13273196,0.39666668,0.13273196,0.4,0.13273196,0.40333334,0.13273196,0.40666667,0.13273196,0.41,0.13273196,0.41333333,0.13273196,0.41666666,0.13273196,0.42,0.13273196,0.42333335,0.13273196,0.42666668,0.13273196,0.43,0.13273196,0.43333334,0.13273196,0.43666667,0.13273196,0.44,0.13273196,0.44333333,0.13273196,0.44666666,0.13273196,0.45,0.13273196,0.45333335,0.13273196,0.45666668,0.13273196,0.46,0.13273196,0.46333334,0.13273196,0.46666667,0.13273196,0.47,0.13273196,0.47333333,0.13273196,0.47666666,0.13273196,0.48,0.13273196,0.48333332,0.13273196,0.48666668,0.13273196,0.49,0.13273196,0.49333334,0.13273196,0.49666667,0.13273196,0.5,0.13273196,0.50333333,0.13273196,0.50666666,0.13273196,0.51,0.13273196,0.5133333,0.13273196,0.51666665,0.13273196,0.52,0.13273196,0.5233333,0.13273196,0.52666664,0.13273196,0.53,0.13273196,0.53333336,0.13273196,0.5366667,0.13273196,0.54,0.13273196,0.54333335,0.13273196,0.5466667,0.13273196,0.55,0.13273196,0.55333334,0.13273196,0.5566667,0.13273196,0.56,0.13273196,0.56333333,0.13273196,0.56666666,0.13273196,0.57,0.13273196,0.5733333,0.13273196,0.57666665,0.13273196,0.58,0.13273196,0.5833333,0.13273196,0.58666664,0.13273196,0.59,0.13273196,0.5933333,0.13273196,0.5966667,0.13273196,0.6,0.13273196,0.60333335,0.13273196,0.6066667,0.13273196,0.61,0.13273196,0.61333334,0.13273196,0.6166667,0.13273196,0.62,0.13273196,0.62333333,0.13273196,0.62666667,0.13273196,0.63,0.13273196,0.6333333,0.13273196,0.64,0.13273196,0.6433333,0.13273196,0.64666665,0.13273196,0.65,0.13273196,0.6533333,0.13273196,0.6566667,0.13273196,0.66,0.13273196,0.66333336,0.13273196,0.6666667,0.13273196,0.67,0.13273196,0.67333335,0.13273196,0.6766667,0.13273196,0.68,0.13273196,0.68333334,0.13273196,0.68666667,0.13273196,0.69,0.13273196,0.6933333,0.13273196,0.69666666,0.13273196,0.7,0.13273196,0.7033333,0.13273196,0.70666665,0.13273196,0.71,0.13273196,0.7133333,0.13273196,0.71666664,0.13273196,0.72,0.13273196,0.72333336,0.13273196,0.7266667,0.13273196,0.73,0.13273196,0.73333335,0.13273196,0.7366667,0.13273196,0.74,0.13273196,0.74333334,0.13273196,0.74666667,0.13273196,0.75,0.13273196,0.75333333,0.13273196,0.75666666,0.13273196,0.76,0.13273196,0.7633333,0.13273196,0.76666665,0.13273196,0.77,0.13273196,0.7733333,0.13273196,0.77666664,0.13273196,0.78,0.13273196,0.78333336,0.13273196,0.7866667,0.13273196,0.79,0.13273196,0.79333335,0.13273196,0.7966667,0.13273196,0.8,0.13273196,0.80333334,0.13273196,0.8066667,0.13273196,0.81,0.13273196,0.81333333,0.13273196,0.81666666,0.13273196,0.82,0.13273196,0.8233333,0.13273196,0.82666665,0.13273196,0.8466667,0.13273196,0.85,0.13273196,0.85333335,0.13273196,0.8566667,0.13273196,0.86,0.13273196,0.86333334,0.13273196,0.8666667,0.13273196,0.87,0.13273196,0.87333333,0.13273196,0.87666667,0.13273196,0.88,0.13273196,0.8833333,0.13273196,0.88666666,0.13273196,0.89,0.13273196,0.8933333,0.13273196,0.89666665,0.13273196,0.9,0.13273196,0.9033333,0.13273196,0.9066667,0.13273196,0.91,0.13273196,0.91333336,0.13273196,0.9166667,0.13273196,0.92,0.13273196,0.92333335,0.13273196,0.9266667,0.13273196,0.93,0.13273196,0.93333334,0.13273196,0.93666667,0.13273196,0.94,0.13273196,0.9433333,0.13273196,0.94666666,0.13273196,0.05,0.13530928,0.053333335,0.13530928,0.05666667,0.13530928,0.06,0.13530928,0.06333333,0.13530928,0.06666667,0.13530928,0.07,0.13530928,0.07333333,0.13530928,0.07666667,0.13530928,0.08,0.13530928,0.083333336,0.13530928,0.086666666,0.13530928,0.09,0.13530928,0.093333334,0.13530928,0.096666664,0.13530928,0.1,0.13530928,0.10333333,0.13530928,0.10666667,0.13530928,0.11,0.13530928,0.11333334,0.13530928,0.11666667,0.13530928,0.12,0.13530928,0.123333335,0.13530928,0.12666667,0.13530928,0.13,0.13530928,0.13333334,0.13530928,0.13666667,0.13530928,0.14,0.13530928,0.14333333,0.13530928,0.14666666,0.13530928,0.15,0.13530928,0.15333334,0.13530928,0.15666667,0.13530928,0.16,0.13530928,0.16333333,0.13530928,0.16666667,0.13530928,0.17,0.13530928,0.17333333,0.13530928,0.17666666,0.13530928,0.18,0.13530928,0.18333334,0.13530928,0.18666667,0.13530928,0.19,0.13530928,0.19333333,0.13530928,0.19666667,0.13530928,0.2,0.13530928,0.20333333,0.13530928,0.20666666,0.13530928,0.21,0.13530928,0.21333334,0.13530928,0.21666667,0.13530928,0.22,0.13530928,0.22333333,0.13530928,0.22666667,0.13530928,0.23,0.13530928,0.23333333,0.13530928,0.23666666,0.13530928,0.24,0.13530928,0.24333334,0.13530928,0.24666667,0.13530928,0.25,0.13530928,0.25333333,0.13530928,0.25666666,0.13530928,0.26,0.13530928,0.26333332,0.13530928,0.26666668,0.13530928,0.27,0.13530928,0.27333334,0.13530928,0.27666667,0.13530928,0.28,0.13530928,0.28333333,0.13530928,0.28666666,0.13530928,0.29,0.13530928,0.29333332,0.13530928,0.29666665,0.13530928,0.3,0.13530928,0.30333334,0.13530928,0.30666667,0.13530928,0.31,0.13530928,0.31333333,0.13530928,0.31666666,0.13530928,0.32,0.13530928,0.32333332,0.13530928,0.32666665,0.13530928,0.33,0.13530928,0.33333334,0.13530928,0.33666667,0.13530928,0.34,0.13530928,0.34333333,0.13530928,0.34666666,0.13530928,0.35,0.13530928,0.35333332,0.13530928,0.35666665,0.13530928,0.36,0.13530928,0.36333334,0.13530928,0.36666667,0.13530928,0.37,0.13530928,0.37333333,0.13530928,0.37666667,0.13530928,0.38,0.13530928,0.38333333,0.13530928,0.38666666,0.13530928,0.39,0.13530928,0.39333335,0.13530928,0.39666668,0.13530928,0.4,0.13530928,0.40333334,0.13530928,0.40666667,0.13530928,0.41,0.13530928,0.41333333,0.13530928,0.41666666,0.13530928,0.42,0.13530928,0.42333335,0.13530928,0.42666668,0.13530928,0.43,0.13530928,0.43333334,0.13530928,0.43666667,0.13530928,0.44,0.13530928,0.44333333,0.13530928,0.44666666,0.13530928,0.45,0.13530928,0.45333335,0.13530928,0.45666668,0.13530928,0.46,0.13530928,0.46333334,0.13530928,0.46666667,0.13530928,0.47,0.13530928,0.47333333,0.13530928,0.47666666,0.13530928,0.48,0.13530928,0.48333332,0.13530928,0.48666668,0.13530928,0.49,0.13530928,0.49333334,0.13530928,0.49666667,0.13530928,0.5,0.13530928,0.50333333,0.13530928,0.50666666,0.13530928,0.51,0.13530928,0.5133333,0.13530928,0.51666665,0.13530928,0.52,0.13530928,0.5233333,0.13530928,0.52666664,0.13530928,0.53,0.13530928,0.53333336,0.13530928,0.5366667,0.13530928,0.54,0.13530928,0.54333335,0.13530928,0.5466667,0.13530928,0.55,0.13530928,0.55333334,0.13530928,0.5566667,0.13530928,0.56,0.13530928,0.56333333,0.13530928,0.56666666,0.13530928,0.57,0.13530928,0.5733333,0.13530928,0.57666665,0.13530928,0.58,0.13530928,0.5833333,0.13530928,0.58666664,0.13530928,0.59,0.13530928,0.5933333,0.13530928,0.5966667,0.13530928,0.6,0.13530928,0.60333335,0.13530928,0.6066667,0.13530928,0.61,0.13530928,0.61333334,0.13530928,0.6166667,0.13530928,0.62,0.13530928,0.62333333,0.13530928,0.62666667,0.13530928,0.63,0.13530928,0.6333333,0.13530928,0.6433333,0.13530928,0.64666665,0.13530928,0.65,0.13530928,0.6533333,0.13530928,0.6566667,0.13530928,0.66,0.13530928,0.66333336,0.13530928,0.6666667,0.13530928,0.67,0.13530928,0.67333335,0.13530928,0.6766667,0.13530928,0.68,0.13530928,0.68333334,0.13530928,0.68666667,0.13530928,0.69,0.13530928,0.6933333,0.13530928,0.69666666,0.13530928,0.7,0.13530928,0.7033333,0.13530928,0.70666665,0.13530928,0.71,0.13530928,0.7133333,0.13530928,0.71666664,0.13530928,0.72,0.13530928,0.72333336,0.13530928,0.7266667,0.13530928,0.73,0.13530928,0.73333335,0.13530928,0.7366667,0.13530928,0.74,0.13530928,0.74333334,0.13530928,0.74666667,0.13530928,0.75,0.13530928,0.75333333,0.13530928,0.75666666,0.13530928,0.76,0.13530928,0.7633333,0.13530928,0.76666665,0.13530928,0.77,0.13530928,0.7733333,0.13530928,0.77666664,0.13530928,0.78,0.13530928,0.78333336,0.13530928,0.7866667,0.13530928,0.79,0.13530928,0.79333335,0.13530928,0.7966667,0.13530928,0.8,0.13530928,0.80333334,0.13530928,0.8066667,0.13530928,0.81,0.13530928,0.81333333,0.13530928,0.81666666,0.13530928,0.82,0.13530928,0.8233333,0.13530928,0.82666665,0.13530928,0.83,0.13530928,0.8433333,0.13530928,0.8466667,0.13530928,0.85,0.13530928,0.85333335,0.13530928,0.8566667,0.13530928,0.86,0.13530928,0.86333334,0.13530928,0.8666667,0.13530928,0.87,0.13530928,0.87333333,0.13530928,0.87666667,0.13530928,0.88,0.13530928,0.8833333,0.13530928,0.88666666,0.13530928,0.89,0.13530928,0.8933333,0.13530928,0.89666665,0.13530928,0.9,0.13530928,0.9033333,0.13530928,0.9066667,0.13530928,0.91,0.13530928,0.91333336,0.13530928,0.9166667,0.13530928,0.92,0.13530928,0.92333335,0.13530928,0.9266667,0.13530928,0.93,0.13530928,0.93333334,0.13530928,0.93666667,0.13530928,0.94,0.13530928,0.9433333,0.13530928,0.94666666,0.13530928,0.05,0.1378866,0.053333335,0.1378866,0.05666667,0.1378866,0.06,0.1378866,0.06333333,0.1378866,0.06666667,0.1378866,0.07,0.1378866,0.07333333,0.1378866,0.07666667,0.1378866,0.08,0.1378866,0.083333336,0.1378866,0.086666666,0.1378866,0.09,0.1378866,0.093333334,0.1378866,0.096666664,0.1378866,0.1,0.1378866,0.10333333,0.1378866,0.10666667,0.1378866,0.11,0.1378866,0.11333334,0.1378866,0.11666667,0.1378866,0.12,0.1378866,0.123333335,0.1378866,0.12666667,0.1378866,0.13,0.1378866,0.13333334,0.1378866,0.13666667,0.1378866,0.14,0.1378866,0.14333333,0.1378866,0.14666666,0.1378866,0.15,0.1378866,0.15333334,0.1378866,0.15666667,0.1378866,0.16,0.1378866,0.16333333,0.1378866,0.16666667,0.1378866,0.17,0.1378866,0.17333333,0.1378866,0.17666666,0.1378866,0.18,0.1378866,0.18333334,0.1378866,0.18666667,0.1378866,0.19,0.1378866,0.19333333,0.1378866,0.19666667,0.1378866,0.2,0.1378866,0.20333333,0.1378866,0.20666666,0.1378866,0.21,0.1378866,0.21333334,0.1378866,0.21666667,0.1378866,0.22,0.1378866,0.22333333,0.1378866,0.22666667,0.1378866,0.23,0.1378866,0.23333333,0.1378866,0.23666666,0.1378866,0.24,0.1378866,0.24333334,0.1378866,0.24666667,0.1378866,0.25,0.1378866,0.25333333,0.1378866,0.25666666,0.1378866,0.26,0.1378866,0.26333332,0.1378866,0.26666668,0.1378866,0.27,0.1378866,0.27333334,0.1378866,0.27666667,0.1378866,0.28,0.1378866,0.28333333,0.1378866,0.28666666,0.1378866,0.29,0.1378866,0.29333332,0.1378866,0.29666665,0.1378866,0.3,0.1378866,0.30333334,0.1378866,0.30666667,0.1378866,0.31,0.1378866,0.31333333,0.1378866,0.31666666,0.1378866,0.32,0.1378866,0.32333332,0.1378866,0.32666665,0.1378866,0.33,0.1378866,0.33333334,0.1378866,0.33666667,0.1378866,0.34,0.1378866,0.34333333,0.1378866,0.34666666,0.1378866,0.35,0.1378866,0.35333332,0.1378866,0.35666665,0.1378866,0.36,0.1378866,0.36333334,0.1378866,0.36666667,0.1378866,0.37,0.1378866,0.37333333,0.1378866,0.37666667,0.1378866,0.38,0.1378866,0.38333333,0.1378866,0.38666666,0.1378866,0.39,0.1378866,0.39333335,0.1378866,0.39666668,0.1378866,0.4,0.1378866,0.40333334,0.1378866,0.40666667,0.1378866,0.41,0.1378866,0.41333333,0.1378866,0.41666666,0.1378866,0.42,0.1378866,0.42333335,0.1378866,0.42666668,0.1378866,0.43,0.1378866,0.43333334,0.1378866,0.43666667,0.1378866,0.44,0.1378866,0.44333333,0.1378866,0.44666666,0.1378866,0.45,0.1378866,0.45333335,0.1378866,0.45666668,0.1378866,0.46,0.1378866,0.46333334,0.1378866,0.46666667,0.1378866,0.47,0.1378866,0.47333333,0.1378866,0.47666666,0.1378866,0.48,0.1378866,0.48333332,0.1378866,0.48666668,0.1378866,0.49,0.1378866,0.49333334,0.1378866,0.49666667,0.1378866,0.5,0.1378866,0.50333333,0.1378866,0.50666666,0.1378866,0.51,0.1378866,0.5133333,0.1378866,0.51666665,0.1378866,0.52,0.1378866,0.5233333,0.1378866,0.52666664,0.1378866,0.53,0.1378866,0.53333336,0.1378866,0.5366667,0.1378866,0.54,0.1378866,0.54333335,0.1378866,0.5466667,0.1378866,0.55,0.1378866,0.55333334,0.1378866,0.5566667,0.1378866,0.56,0.1378866,0.56333333,0.1378866,0.56666666,0.1378866,0.57,0.1378866,0.5733333,0.1378866,0.57666665,0.1378866,0.58,0.1378866,0.5833333,0.1378866,0.58666664,0.1378866,0.59,0.1378866,0.5933333,0.1378866,0.5966667,0.1378866,0.6,0.1378866,0.60333335,0.1378866,0.6066667,0.1378866,0.61,0.1378866,0.61333334,0.1378866,0.6166667,0.1378866,0.62,0.1378866,0.62333333,0.1378866,0.62666667,0.1378866,0.63,0.1378866,0.6333333,0.1378866,0.6433333,0.1378866,0.64666665,0.1378866,0.65,0.1378866,0.6533333,0.1378866,0.6566667,0.1378866,0.66,0.1378866,0.66333336,0.1378866,0.6666667,0.1378866,0.67,0.1378866,0.67333335,0.1378866,0.6766667,0.1378866,0.68,0.1378866,0.68333334,0.1378866,0.68666667,0.1378866,0.69,0.1378866,0.6933333,0.1378866,0.69666666,0.1378866,0.7,0.1378866,0.7033333,0.1378866,0.70666665,0.1378866,0.71,0.1378866,0.7133333,0.1378866,0.71666664,0.1378866,0.72,0.1378866,0.72333336,0.1378866,0.7266667,0.1378866,0.73,0.1378866,0.73333335,0.1378866,0.7366667,0.1378866,0.74,0.1378866,0.74333334,0.1378866,0.74666667,0.1378866,0.75,0.1378866,0.75333333,0.1378866,0.75666666,0.1378866,0.76,0.1378866,0.7633333,0.1378866,0.76666665,0.1378866,0.77,0.1378866,0.7733333,0.1378866,0.77666664,0.1378866,0.78,0.1378866,0.78333336,0.1378866,0.7866667,0.1378866,0.79,0.1378866,0.79333335,0.1378866,0.7966667,0.1378866,0.8,0.1378866,0.80333334,0.1378866,0.8066667,0.1378866,0.81,0.1378866,0.81333333,0.1378866,0.81666666,0.1378866,0.82,0.1378866,0.8233333,0.1378866,0.82666665,0.1378866,0.83,0.1378866,0.8333333,0.1378866,0.83666664,0.1378866,0.84,0.1378866,0.8433333,0.1378866,0.8466667,0.1378866,0.85,0.1378866,0.85333335,0.1378866,0.8566667,0.1378866,0.86,0.1378866,0.86333334,0.1378866,0.8666667,0.1378866,0.87,0.1378866,0.87333333,0.1378866,0.87666667,0.1378866,0.88,0.1378866,0.8833333,0.1378866,0.88666666,0.1378866,0.89,0.1378866,0.8933333,0.1378866,0.89666665,0.1378866,0.9,0.1378866,0.9033333,0.1378866,0.9066667,0.1378866,0.91,0.1378866,0.91333336,0.1378866,0.9166667,0.1378866,0.92,0.1378866,0.92333335,0.1378866,0.9266667,0.1378866,0.93,0.1378866,0.93333334,0.1378866,0.93666667,0.1378866,0.94,0.1378866,0.9433333,0.1378866,0.94666666,0.1378866,0.05,0.14046392,0.053333335,0.14046392,0.05666667,0.14046392,0.06,0.14046392,0.06333333,0.14046392,0.06666667,0.14046392,0.07,0.14046392,0.07333333,0.14046392,0.07666667,0.14046392,0.08,0.14046392,0.083333336,0.14046392,0.086666666,0.14046392,0.09,0.14046392,0.093333334,0.14046392,0.096666664,0.14046392,0.1,0.14046392,0.10333333,0.14046392,0.10666667,0.14046392,0.11,0.14046392,0.11333334,0.14046392,0.11666667,0.14046392,0.12,0.14046392,0.123333335,0.14046392,0.12666667,0.14046392,0.13,0.14046392,0.13333334,0.14046392,0.13666667,0.14046392,0.14,0.14046392,0.14333333,0.14046392,0.14666666,0.14046392,0.15,0.14046392,0.15333334,0.14046392,0.15666667,0.14046392,0.16,0.14046392,0.16333333,0.14046392,0.16666667,0.14046392,0.17,0.14046392,0.17333333,0.14046392,0.17666666,0.14046392,0.18,0.14046392,0.18333334,0.14046392,0.18666667,0.14046392,0.19,0.14046392,0.19333333,0.14046392,0.19666667,0.14046392,0.2,0.14046392,0.20333333,0.14046392,0.20666666,0.14046392,0.21,0.14046392,0.21333334,0.14046392,0.21666667,0.14046392,0.22,0.14046392,0.22333333,0.14046392,0.22666667,0.14046392,0.23,0.14046392,0.23333333,0.14046392,0.23666666,0.14046392,0.24,0.14046392,0.24333334,0.14046392,0.24666667,0.14046392,0.25,0.14046392,0.25333333,0.14046392,0.25666666,0.14046392,0.26,0.14046392,0.26333332,0.14046392,0.26666668,0.14046392,0.27,0.14046392,0.27333334,0.14046392,0.27666667,0.14046392,0.28,0.14046392,0.28333333,0.14046392,0.28666666,0.14046392,0.29,0.14046392,0.29333332,0.14046392,0.29666665,0.14046392,0.3,0.14046392,0.30333334,0.14046392,0.30666667,0.14046392,0.31,0.14046392,0.31333333,0.14046392,0.31666666,0.14046392,0.32,0.14046392,0.32333332,0.14046392,0.32666665,0.14046392,0.33,0.14046392,0.33333334,0.14046392,0.33666667,0.14046392,0.34,0.14046392,0.34333333,0.14046392,0.34666666,0.14046392,0.35,0.14046392,0.35333332,0.14046392,0.35666665,0.14046392,0.36,0.14046392,0.36333334,0.14046392,0.36666667,0.14046392,0.37,0.14046392,0.37333333,0.14046392,0.37666667,0.14046392,0.38,0.14046392,0.38333333,0.14046392,0.38666666,0.14046392,0.39,0.14046392,0.39333335,0.14046392,0.39666668,0.14046392,0.4,0.14046392,0.40333334,0.14046392,0.40666667,0.14046392,0.41,0.14046392,0.41333333,0.14046392,0.41666666,0.14046392,0.42,0.14046392,0.42333335,0.14046392,0.42666668,0.14046392,0.43,0.14046392,0.43333334,0.14046392,0.43666667,0.14046392,0.44,0.14046392,0.44333333,0.14046392,0.44666666,0.14046392,0.45,0.14046392,0.45333335,0.14046392,0.45666668,0.14046392,0.46,0.14046392,0.46333334,0.14046392,0.46666667,0.14046392,0.47,0.14046392,0.47333333,0.14046392,0.47666666,0.14046392,0.48,0.14046392,0.48333332,0.14046392,0.48666668,0.14046392,0.49,0.14046392,0.49333334,0.14046392,0.49666667,0.14046392,0.5,0.14046392,0.50333333,0.14046392,0.50666666,0.14046392,0.51,0.14046392,0.5133333,0.14046392,0.51666665,0.14046392,0.52,0.14046392,0.5233333,0.14046392,0.52666664,0.14046392,0.53,0.14046392,0.53333336,0.14046392,0.5366667,0.14046392,0.54,0.14046392,0.54333335,0.14046392,0.5466667,0.14046392,0.55,0.14046392,0.55333334,0.14046392,0.5566667,0.14046392,0.56,0.14046392,0.56333333,0.14046392,0.56666666,0.14046392,0.57,0.14046392,0.5733333,0.14046392,0.57666665,0.14046392,0.58,0.14046392,0.5833333,0.14046392,0.58666664,0.14046392,0.59,0.14046392,0.5933333,0.14046392,0.5966667,0.14046392,0.6,0.14046392,0.60333335,0.14046392,0.6066667,0.14046392,0.61,0.14046392,0.61333334,0.14046392,0.6166667,0.14046392,0.62,0.14046392,0.62333333,0.14046392,0.62666667,0.14046392,0.63,0.14046392,0.63666666,0.14046392,0.64,0.14046392,0.6433333,0.14046392,0.64666665,0.14046392,0.65,0.14046392,0.6533333,0.14046392,0.6566667,0.14046392,0.66,0.14046392,0.66333336,0.14046392,0.6666667,0.14046392,0.67,0.14046392,0.67333335,0.14046392,0.6766667,0.14046392,0.68,0.14046392,0.68333334,0.14046392,0.68666667,0.14046392,0.69,0.14046392,0.6933333,0.14046392,0.69666666,0.14046392,0.7,0.14046392,0.7033333,0.14046392,0.70666665,0.14046392,0.71,0.14046392,0.7133333,0.14046392,0.71666664,0.14046392,0.72,0.14046392,0.72333336,0.14046392,0.7266667,0.14046392,0.73,0.14046392,0.73333335,0.14046392,0.7366667,0.14046392,0.74,0.14046392,0.74333334,0.14046392,0.74666667,0.14046392,0.75,0.14046392,0.75333333,0.14046392,0.75666666,0.14046392,0.76,0.14046392,0.7633333,0.14046392,0.76666665,0.14046392,0.77,0.14046392,0.7733333,0.14046392,0.77666664,0.14046392,0.78,0.14046392,0.78333336,0.14046392,0.7866667,0.14046392,0.79,0.14046392,0.79333335,0.14046392,0.7966667,0.14046392,0.8,0.14046392,0.80333334,0.14046392,0.8066667,0.14046392,0.81,0.14046392,0.81333333,0.14046392,0.81666666,0.14046392,0.82,0.14046392,0.8233333,0.14046392,0.82666665,0.14046392,0.83,0.14046392,0.8333333,0.14046392,0.83666664,0.14046392,0.84,0.14046392,0.8433333,0.14046392,0.8466667,0.14046392,0.85,0.14046392,0.85333335,0.14046392,0.8566667,0.14046392,0.86,0.14046392,0.86333334,0.14046392,0.8666667,0.14046392,0.87,0.14046392,0.87333333,0.14046392,0.87666667,0.14046392,0.88,0.14046392,0.8833333,0.14046392,0.88666666,0.14046392,0.89,0.14046392,0.8933333,0.14046392,0.89666665,0.14046392,0.9,0.14046392,0.9033333,0.14046392,0.9066667,0.14046392,0.91,0.14046392,0.91333336,0.14046392,0.9166667,0.14046392,0.92,0.14046392,0.92333335,0.14046392,0.94,0.14046392,0.9433333,0.14046392,0.94666666,0.14046392,0.05,0.14304124,0.053333335,0.14304124,0.05666667,0.14304124,0.06,0.14304124,0.06333333,0.14304124,0.06666667,0.14304124,0.07,0.14304124,0.07333333,0.14304124,0.07666667,0.14304124,0.08,0.14304124,0.083333336,0.14304124,0.086666666,0.14304124,0.09,0.14304124,0.093333334,0.14304124,0.096666664,0.14304124,0.1,0.14304124,0.10333333,0.14304124,0.10666667,0.14304124,0.11,0.14304124,0.11333334,0.14304124,0.11666667,0.14304124,0.12,0.14304124,0.123333335,0.14304124,0.12666667,0.14304124,0.13,0.14304124,0.13333334,0.14304124,0.13666667,0.14304124,0.14,0.14304124,0.14333333,0.14304124,0.14666666,0.14304124,0.15,0.14304124,0.15333334,0.14304124,0.15666667,0.14304124,0.16,0.14304124,0.16333333,0.14304124,0.16666667,0.14304124,0.17,0.14304124,0.17333333,0.14304124,0.17666666,0.14304124,0.18,0.14304124,0.18333334,0.14304124,0.18666667,0.14304124,0.19,0.14304124,0.19333333,0.14304124,0.19666667,0.14304124,0.2,0.14304124,0.20333333,0.14304124,0.20666666,0.14304124,0.21,0.14304124,0.21333334,0.14304124,0.21666667,0.14304124,0.22,0.14304124,0.22333333,0.14304124,0.22666667,0.14304124,0.23,0.14304124,0.23333333,0.14304124,0.23666666,0.14304124,0.24,0.14304124,0.24333334,0.14304124,0.24666667,0.14304124,0.25,0.14304124,0.25333333,0.14304124,0.25666666,0.14304124,0.26,0.14304124,0.26333332,0.14304124,0.26666668,0.14304124,0.27,0.14304124,0.27333334,0.14304124,0.27666667,0.14304124,0.28,0.14304124,0.28333333,0.14304124,0.28666666,0.14304124,0.29,0.14304124,0.29333332,0.14304124,0.29666665,0.14304124,0.3,0.14304124,0.30333334,0.14304124,0.30666667,0.14304124,0.31,0.14304124,0.31333333,0.14304124,0.31666666,0.14304124,0.32,0.14304124,0.32333332,0.14304124,0.32666665,0.14304124,0.33,0.14304124,0.33333334,0.14304124,0.33666667,0.14304124,0.34,0.14304124,0.34333333,0.14304124,0.34666666,0.14304124,0.35,0.14304124,0.35333332,0.14304124,0.35666665,0.14304124,0.36,0.14304124,0.36333334,0.14304124,0.36666667,0.14304124,0.37,0.14304124,0.37333333,0.14304124,0.37666667,0.14304124,0.38,0.14304124,0.38333333,0.14304124,0.38666666,0.14304124,0.39,0.14304124,0.39333335,0.14304124,0.39666668,0.14304124,0.4,0.14304124,0.40333334,0.14304124,0.40666667,0.14304124,0.41,0.14304124,0.41333333,0.14304124,0.41666666,0.14304124,0.42,0.14304124,0.42333335,0.14304124,0.42666668,0.14304124,0.43,0.14304124,0.43333334,0.14304124,0.43666667,0.14304124,0.44,0.14304124,0.44333333,0.14304124,0.44666666,0.14304124,0.45,0.14304124,0.45333335,0.14304124,0.45666668,0.14304124,0.46,0.14304124,0.46333334,0.14304124,0.46666667,0.14304124,0.47,0.14304124,0.47333333,0.14304124,0.47666666,0.14304124,0.48,0.14304124,0.48333332,0.14304124,0.48666668,0.14304124,0.49,0.14304124,0.49333334,0.14304124,0.49666667,0.14304124,0.5,0.14304124,0.50333333,0.14304124,0.50666666,0.14304124,0.51,0.14304124,0.5133333,0.14304124,0.51666665,0.14304124,0.52,0.14304124,0.5233333,0.14304124,0.52666664,0.14304124,0.53,0.14304124,0.53333336,0.14304124,0.5366667,0.14304124,0.54,0.14304124,0.54333335,0.14304124,0.5466667,0.14304124,0.55,0.14304124,0.55333334,0.14304124,0.5566667,0.14304124,0.56,0.14304124,0.56333333,0.14304124,0.56666666,0.14304124,0.57,0.14304124,0.5733333,0.14304124,0.57666665,0.14304124,0.58,0.14304124,0.5833333,0.14304124,0.58666664,0.14304124,0.59,0.14304124,0.5933333,0.14304124,0.5966667,0.14304124,0.6,0.14304124,0.60333335,0.14304124,0.6066667,0.14304124,0.61,0.14304124,0.61333334,0.14304124,0.6166667,0.14304124,0.62,0.14304124,0.62333333,0.14304124,0.62666667,0.14304124,0.6333333,0.14304124,0.63666666,0.14304124,0.64,0.14304124,0.6433333,0.14304124,0.64666665,0.14304124,0.65,0.14304124,0.6533333,0.14304124,0.6566667,0.14304124,0.68333334,0.14304124,0.68666667,0.14304124,0.69,0.14304124,0.6933333,0.14304124,0.69666666,0.14304124,0.7,0.14304124,0.7033333,0.14304124,0.70666665,0.14304124,0.71,0.14304124,0.7133333,0.14304124,0.71666664,0.14304124,0.72,0.14304124,0.72333336,0.14304124,0.7266667,0.14304124,0.73,0.14304124,0.73333335,0.14304124,0.7366667,0.14304124,0.74,0.14304124,0.74333334,0.14304124,0.74666667,0.14304124,0.75,0.14304124,0.75333333,0.14304124,0.75666666,0.14304124,0.76,0.14304124,0.7633333,0.14304124,0.76666665,0.14304124,0.77,0.14304124,0.7733333,0.14304124,0.77666664,0.14304124,0.78,0.14304124,0.78333336,0.14304124,0.7866667,0.14304124,0.79,0.14304124,0.79333335,0.14304124,0.7966667,0.14304124,0.8,0.14304124,0.80333334,0.14304124,0.8066667,0.14304124,0.81,0.14304124,0.81333333,0.14304124,0.81666666,0.14304124,0.82,0.14304124,0.8233333,0.14304124,0.82666665,0.14304124,0.83,0.14304124,0.8333333,0.14304124,0.83666664,0.14304124,0.84,0.14304124,0.8433333,0.14304124,0.8466667,0.14304124,0.85,0.14304124,0.85333335,0.14304124,0.8566667,0.14304124,0.86,0.14304124,0.86333334,0.14304124,0.8666667,0.14304124,0.87,0.14304124,0.87333333,0.14304124,0.87666667,0.14304124,0.88,0.14304124,0.8833333,0.14304124,0.88666666,0.14304124,0.89,0.14304124,0.8933333,0.14304124,0.9,0.14304124,0.9433333,0.14304124,0.94666666,0.14304124,0.05,0.14561856,0.053333335,0.14561856,0.05666667,0.14561856,0.06,0.14561856,0.06333333,0.14561856,0.06666667,0.14561856,0.07,0.14561856,0.07333333,0.14561856,0.07666667,0.14561856,0.08,0.14561856,0.083333336,0.14561856,0.086666666,0.14561856,0.09,0.14561856,0.093333334,0.14561856,0.096666664,0.14561856,0.1,0.14561856,0.10333333,0.14561856,0.10666667,0.14561856,0.11,0.14561856,0.11333334,0.14561856,0.11666667,0.14561856,0.12,0.14561856,0.123333335,0.14561856,0.12666667,0.14561856,0.13,0.14561856,0.13333334,0.14561856,0.13666667,0.14561856,0.14,0.14561856,0.14333333,0.14561856,0.14666666,0.14561856,0.15,0.14561856,0.15333334,0.14561856,0.15666667,0.14561856,0.16,0.14561856,0.16333333,0.14561856,0.16666667,0.14561856,0.17,0.14561856,0.17333333,0.14561856,0.17666666,0.14561856,0.18,0.14561856,0.18333334,0.14561856,0.18666667,0.14561856,0.19,0.14561856,0.19333333,0.14561856,0.19666667,0.14561856,0.2,0.14561856,0.20333333,0.14561856,0.20666666,0.14561856,0.21,0.14561856,0.21333334,0.14561856,0.21666667,0.14561856,0.22,0.14561856,0.22333333,0.14561856,0.22666667,0.14561856,0.23,0.14561856,0.23333333,0.14561856,0.23666666,0.14561856,0.24,0.14561856,0.24333334,0.14561856,0.24666667,0.14561856,0.25,0.14561856,0.25333333,0.14561856,0.25666666,0.14561856,0.26,0.14561856,0.26333332,0.14561856,0.26666668,0.14561856,0.27,0.14561856,0.27333334,0.14561856,0.27666667,0.14561856,0.28,0.14561856,0.28333333,0.14561856,0.28666666,0.14561856,0.29,0.14561856,0.29333332,0.14561856,0.29666665,0.14561856,0.3,0.14561856,0.30333334,0.14561856,0.30666667,0.14561856,0.31,0.14561856,0.31333333,0.14561856,0.31666666,0.14561856,0.32,0.14561856,0.32333332,0.14561856,0.32666665,0.14561856,0.33,0.14561856,0.33333334,0.14561856,0.33666667,0.14561856,0.34,0.14561856,0.34333333,0.14561856,0.34666666,0.14561856,0.35,0.14561856,0.35333332,0.14561856,0.35666665,0.14561856,0.36,0.14561856,0.36333334,0.14561856,0.36666667,0.14561856,0.37,0.14561856,0.37333333,0.14561856,0.37666667,0.14561856,0.38,0.14561856,0.38333333,0.14561856,0.38666666,0.14561856,0.39,0.14561856,0.39333335,0.14561856,0.39666668,0.14561856,0.4,0.14561856,0.40333334,0.14561856,0.40666667,0.14561856,0.41,0.14561856,0.41333333,0.14561856,0.41666666,0.14561856,0.42,0.14561856,0.42333335,0.14561856,0.42666668,0.14561856,0.43,0.14561856,0.43333334,0.14561856,0.43666667,0.14561856,0.44,0.14561856,0.44333333,0.14561856,0.44666666,0.14561856,0.45,0.14561856,0.45333335,0.14561856,0.45666668,0.14561856,0.46,0.14561856,0.46333334,0.14561856,0.46666667,0.14561856,0.47,0.14561856,0.47333333,0.14561856,0.47666666,0.14561856,0.48,0.14561856,0.48333332,0.14561856,0.48666668,0.14561856,0.49,0.14561856,0.49333334,0.14561856,0.49666667,0.14561856,0.5,0.14561856,0.50333333,0.14561856,0.50666666,0.14561856,0.51,0.14561856,0.5133333,0.14561856,0.51666665,0.14561856,0.52,0.14561856,0.5233333,0.14561856,0.52666664,0.14561856,0.53,0.14561856,0.53333336,0.14561856,0.5366667,0.14561856,0.54,0.14561856,0.54333335,0.14561856,0.5466667,0.14561856,0.55,0.14561856,0.55333334,0.14561856,0.5566667,0.14561856,0.56,0.14561856,0.56333333,0.14561856,0.56666666,0.14561856,0.57,0.14561856,0.5733333,0.14561856,0.57666665,0.14561856,0.58,0.14561856,0.5833333,0.14561856,0.58666664,0.14561856,0.59,0.14561856,0.5933333,0.14561856,0.5966667,0.14561856,0.6,0.14561856,0.60333335,0.14561856,0.6066667,0.14561856,0.61,0.14561856,0.61333334,0.14561856,0.6166667,0.14561856,0.62,0.14561856,0.62333333,0.14561856,0.63,0.14561856,0.6333333,0.14561856,0.63666666,0.14561856,0.64,0.14561856,0.6433333,0.14561856,0.64666665,0.14561856,0.65,0.14561856,0.6533333,0.14561856,0.6566667,0.14561856,0.66,0.14561856,0.66333336,0.14561856,0.68,0.14561856,0.7033333,0.14561856,0.70666665,0.14561856,0.71,0.14561856,0.7133333,0.14561856,0.71666664,0.14561856,0.72,0.14561856,0.72333336,0.14561856,0.7266667,0.14561856,0.73,0.14561856,0.73333335,0.14561856,0.7366667,0.14561856,0.74,0.14561856,0.74333334,0.14561856,0.74666667,0.14561856,0.75,0.14561856,0.75333333,0.14561856,0.75666666,0.14561856,0.76,0.14561856,0.7633333,0.14561856,0.76666665,0.14561856,0.77,0.14561856,0.7733333,0.14561856,0.77666664,0.14561856,0.78,0.14561856,0.78333336,0.14561856,0.7866667,0.14561856,0.79,0.14561856,0.79333335,0.14561856,0.7966667,0.14561856,0.8,0.14561856,0.80333334,0.14561856,0.8066667,0.14561856,0.81,0.14561856,0.81333333,0.14561856,0.81666666,0.14561856,0.82,0.14561856,0.8233333,0.14561856,0.82666665,0.14561856,0.83,0.14561856,0.8333333,0.14561856,0.83666664,0.14561856,0.84,0.14561856,0.8433333,0.14561856,0.8466667,0.14561856,0.85,0.14561856,0.85333335,0.14561856,0.8566667,0.14561856,0.86,0.14561856,0.86333334,0.14561856,0.8666667,0.14561856,0.87,0.14561856,0.87333333,0.14561856,0.87666667,0.14561856,0.88,0.14561856,0.8833333,0.14561856,0.9433333,0.14561856,0.94666666,0.14561856,0.05,0.14819588,0.053333335,0.14819588,0.05666667,0.14819588,0.06,0.14819588,0.06333333,0.14819588,0.06666667,0.14819588,0.07,0.14819588,0.07333333,0.14819588,0.07666667,0.14819588,0.08,0.14819588,0.083333336,0.14819588,0.086666666,0.14819588,0.09,0.14819588,0.093333334,0.14819588,0.096666664,0.14819588,0.1,0.14819588,0.10333333,0.14819588,0.10666667,0.14819588,0.11,0.14819588,0.11333334,0.14819588,0.11666667,0.14819588,0.12,0.14819588,0.123333335,0.14819588,0.12666667,0.14819588,0.13,0.14819588,0.13333334,0.14819588,0.13666667,0.14819588,0.14,0.14819588,0.14333333,0.14819588,0.14666666,0.14819588,0.15,0.14819588,0.15333334,0.14819588,0.15666667,0.14819588,0.16,0.14819588,0.16333333,0.14819588,0.16666667,0.14819588,0.17,0.14819588,0.17333333,0.14819588,0.17666666,0.14819588,0.18,0.14819588,0.18333334,0.14819588,0.18666667,0.14819588,0.19,0.14819588,0.19333333,0.14819588,0.19666667,0.14819588,0.2,0.14819588,0.20333333,0.14819588,0.20666666,0.14819588,0.21,0.14819588,0.21333334,0.14819588,0.21666667,0.14819588,0.22,0.14819588,0.22333333,0.14819588,0.22666667,0.14819588,0.23,0.14819588,0.23333333,0.14819588,0.23666666,0.14819588,0.24,0.14819588,0.24333334,0.14819588,0.24666667,0.14819588,0.25,0.14819588,0.25333333,0.14819588,0.25666666,0.14819588,0.26,0.14819588,0.26333332,0.14819588,0.26666668,0.14819588,0.27,0.14819588,0.27333334,0.14819588,0.27666667,0.14819588,0.28,0.14819588,0.28333333,0.14819588,0.28666666,0.14819588,0.29,0.14819588,0.29333332,0.14819588,0.29666665,0.14819588,0.3,0.14819588,0.30333334,0.14819588,0.30666667,0.14819588,0.31,0.14819588,0.31333333,0.14819588,0.31666666,0.14819588,0.32,0.14819588,0.32333332,0.14819588,0.32666665,0.14819588,0.33,0.14819588,0.33333334,0.14819588,0.33666667,0.14819588,0.34,0.14819588,0.34333333,0.14819588,0.34666666,0.14819588,0.35,0.14819588,0.35333332,0.14819588,0.35666665,0.14819588,0.36,0.14819588,0.36333334,0.14819588,0.36666667,0.14819588,0.37,0.14819588,0.37333333,0.14819588,0.37666667,0.14819588,0.38,0.14819588,0.38333333,0.14819588,0.38666666,0.14819588,0.39,0.14819588,0.39333335,0.14819588,0.39666668,0.14819588,0.4,0.14819588,0.40333334,0.14819588,0.40666667,0.14819588,0.41,0.14819588,0.41333333,0.14819588,0.41666666,0.14819588,0.42,0.14819588,0.42333335,0.14819588,0.42666668,0.14819588,0.43,0.14819588,0.43333334,0.14819588,0.43666667,0.14819588,0.44,0.14819588,0.44333333,0.14819588,0.44666666,0.14819588,0.45,0.14819588,0.45333335,0.14819588,0.45666668,0.14819588,0.46,0.14819588,0.46333334,0.14819588,0.46666667,0.14819588,0.47,0.14819588,0.47333333,0.14819588,0.47666666,0.14819588,0.48,0.14819588,0.48333332,0.14819588,0.48666668,0.14819588,0.49,0.14819588,0.49333334,0.14819588,0.49666667,0.14819588,0.5,0.14819588,0.50333333,0.14819588,0.50666666,0.14819588,0.51,0.14819588,0.5133333,0.14819588,0.51666665,0.14819588,0.52,0.14819588,0.5233333,0.14819588,0.52666664,0.14819588,0.53,0.14819588,0.53333336,0.14819588,0.5366667,0.14819588,0.54,0.14819588,0.54333335,0.14819588,0.5466667,0.14819588,0.55,0.14819588,0.55333334,0.14819588,0.5566667,0.14819588,0.56,0.14819588,0.56333333,0.14819588,0.56666666,0.14819588,0.57,0.14819588,0.5733333,0.14819588,0.57666665,0.14819588,0.58,0.14819588,0.5833333,0.14819588,0.58666664,0.14819588,0.59,0.14819588,0.5933333,0.14819588,0.5966667,0.14819588,0.6,0.14819588,0.60333335,0.14819588,0.6066667,0.14819588,0.61,0.14819588,0.61333334,0.14819588,0.6166667,0.14819588,0.62,0.14819588,0.62333333,0.14819588,0.6433333,0.14819588,0.64666665,0.14819588,0.65,0.14819588,0.6533333,0.14819588,0.6566667,0.14819588,0.66,0.14819588,0.66333336,0.14819588,0.6666667,0.14819588,0.67,0.14819588,0.67333335,0.14819588,0.6766667,0.14819588,0.68,0.14819588,0.68333334,0.14819588,0.68666667,0.14819588,0.69,0.14819588,0.7266667,0.14819588,0.73,0.14819588,0.73333335,0.14819588,0.7366667,0.14819588,0.74,0.14819588,0.74333334,0.14819588,0.74666667,0.14819588,0.75,0.14819588,0.75333333,0.14819588,0.75666666,0.14819588,0.76,0.14819588,0.7633333,0.14819588,0.76666665,0.14819588,0.77,0.14819588,0.7733333,0.14819588,0.77666664,0.14819588,0.78,0.14819588,0.78333336,0.14819588,0.7866667,0.14819588,0.79,0.14819588,0.79333335,0.14819588,0.7966667,0.14819588,0.8,0.14819588,0.80333334,0.14819588,0.8066667,0.14819588,0.81,0.14819588,0.81333333,0.14819588,0.81666666,0.14819588,0.82,0.14819588,0.8233333,0.14819588,0.82666665,0.14819588,0.83,0.14819588,0.8333333,0.14819588,0.83666664,0.14819588,0.84,0.14819588,0.8433333,0.14819588,0.8466667,0.14819588,0.85,0.14819588,0.85333335,0.14819588,0.8566667,0.14819588,0.86,0.14819588,0.05,0.1507732,0.053333335,0.1507732,0.05666667,0.1507732,0.06,0.1507732,0.06333333,0.1507732,0.06666667,0.1507732,0.07,0.1507732,0.07333333,0.1507732,0.07666667,0.1507732,0.08,0.1507732,0.083333336,0.1507732,0.086666666,0.1507732,0.09,0.1507732,0.093333334,0.1507732,0.096666664,0.1507732,0.1,0.1507732,0.10333333,0.1507732,0.10666667,0.1507732,0.11,0.1507732,0.11333334,0.1507732,0.11666667,0.1507732,0.12,0.1507732,0.123333335,0.1507732,0.12666667,0.1507732,0.13,0.1507732,0.13333334,0.1507732,0.13666667,0.1507732,0.14,0.1507732,0.14333333,0.1507732,0.14666666,0.1507732,0.15,0.1507732,0.15333334,0.1507732,0.15666667,0.1507732,0.16,0.1507732,0.16333333,0.1507732,0.16666667,0.1507732,0.17,0.1507732,0.17333333,0.1507732,0.17666666,0.1507732,0.18,0.1507732,0.18333334,0.1507732,0.18666667,0.1507732,0.19,0.1507732,0.19333333,0.1507732,0.19666667,0.1507732,0.2,0.1507732,0.20333333,0.1507732,0.20666666,0.1507732,0.21,0.1507732,0.21333334,0.1507732,0.21666667,0.1507732,0.22,0.1507732,0.22333333,0.1507732,0.22666667,0.1507732,0.23,0.1507732,0.23333333,0.1507732,0.23666666,0.1507732,0.24,0.1507732,0.24333334,0.1507732,0.24666667,0.1507732,0.25,0.1507732,0.25333333,0.1507732,0.25666666,0.1507732,0.26,0.1507732,0.26333332,0.1507732,0.26666668,0.1507732,0.27,0.1507732,0.27333334,0.1507732,0.27666667,0.1507732,0.28,0.1507732,0.28333333,0.1507732,0.28666666,0.1507732,0.29,0.1507732,0.29333332,0.1507732,0.29666665,0.1507732,0.3,0.1507732,0.30333334,0.1507732,0.30666667,0.1507732,0.31,0.1507732,0.31333333,0.1507732,0.31666666,0.1507732,0.32,0.1507732,0.32333332,0.1507732,0.32666665,0.1507732,0.33,0.1507732,0.33333334,0.1507732,0.33666667,0.1507732,0.34,0.1507732,0.34333333,0.1507732,0.34666666,0.1507732,0.35,0.1507732,0.35333332,0.1507732,0.35666665,0.1507732,0.36,0.1507732,0.36333334,0.1507732,0.36666667,0.1507732,0.37,0.1507732,0.37333333,0.1507732,0.37666667,0.1507732,0.38,0.1507732,0.38333333,0.1507732,0.38666666,0.1507732,0.39,0.1507732,0.39333335,0.1507732,0.39666668,0.1507732,0.4,0.1507732,0.40333334,0.1507732,0.40666667,0.1507732,0.41,0.1507732,0.41333333,0.1507732,0.41666666,0.1507732,0.42,0.1507732,0.42333335,0.1507732,0.42666668,0.1507732,0.43,0.1507732,0.43333334,0.1507732,0.43666667,0.1507732,0.44,0.1507732,0.44333333,0.1507732,0.44666666,0.1507732,0.45,0.1507732,0.45333335,0.1507732,0.45666668,0.1507732,0.46,0.1507732,0.46333334,0.1507732,0.46666667,0.1507732,0.47,0.1507732,0.47333333,0.1507732,0.47666666,0.1507732,0.48,0.1507732,0.48333332,0.1507732,0.48666668,0.1507732,0.49,0.1507732,0.49333334,0.1507732,0.49666667,0.1507732,0.5,0.1507732,0.50333333,0.1507732,0.50666666,0.1507732,0.51,0.1507732,0.5133333,0.1507732,0.51666665,0.1507732,0.52,0.1507732,0.5233333,0.1507732,0.52666664,0.1507732,0.53,0.1507732,0.53333336,0.1507732,0.5366667,0.1507732,0.54,0.1507732,0.54333335,0.1507732,0.5466667,0.1507732,0.55,0.1507732,0.55333334,0.1507732,0.5566667,0.1507732,0.56,0.1507732,0.56333333,0.1507732,0.56666666,0.1507732,0.57,0.1507732,0.5733333,0.1507732,0.57666665,0.1507732,0.58,0.1507732,0.5833333,0.1507732,0.58666664,0.1507732,0.59,0.1507732,0.5933333,0.1507732,0.5966667,0.1507732,0.6,0.1507732,0.60333335,0.1507732,0.6066667,0.1507732,0.61,0.1507732,0.61333334,0.1507732,0.6166667,0.1507732,0.62,0.1507732,0.62333333,0.1507732,0.62666667,0.1507732,0.63,0.1507732,0.6333333,0.1507732,0.63666666,0.1507732,0.66333336,0.1507732,0.6666667,0.1507732,0.67,0.1507732,0.67333335,0.1507732,0.6766667,0.1507732,0.68,0.1507732,0.68333334,0.1507732,0.68666667,0.1507732,0.69,0.1507732,0.6933333,0.1507732,0.7,0.1507732,0.7033333,0.1507732,0.70666665,0.1507732,0.71,0.1507732,0.7133333,0.1507732,0.71666664,0.1507732,0.75,0.1507732,0.75333333,0.1507732,0.75666666,0.1507732,0.76,0.1507732,0.7633333,0.1507732,0.76666665,0.1507732,0.77,0.1507732,0.7733333,0.1507732,0.77666664,0.1507732,0.78,0.1507732,0.78333336,0.1507732,0.7866667,0.1507732,0.79,0.1507732,0.79333335,0.1507732,0.7966667,0.1507732,0.8,0.1507732,0.80333334,0.1507732,0.8066667,0.1507732,0.81,0.1507732,0.81333333,0.1507732,0.81666666,0.1507732,0.82,0.1507732,0.8233333,0.1507732,0.82666665,0.1507732,0.83,0.1507732,0.8333333,0.1507732,0.83666664,0.1507732,0.84,0.1507732,0.87666667,0.1507732,0.8833333,0.1507732,0.88666666,0.1507732,0.89666665,0.1507732,0.9,0.1507732,0.9266667,0.1507732,0.93,0.1507732,0.93333334,0.1507732,0.93666667,0.1507732,0.94666666,0.1507732,0.05,0.15335052,0.053333335,0.15335052,0.05666667,0.15335052,0.06,0.15335052,0.06333333,0.15335052,0.06666667,0.15335052,0.07,0.15335052,0.07333333,0.15335052,0.07666667,0.15335052,0.08,0.15335052,0.083333336,0.15335052,0.086666666,0.15335052,0.09,0.15335052,0.093333334,0.15335052,0.096666664,0.15335052,0.1,0.15335052,0.10333333,0.15335052,0.10666667,0.15335052,0.11,0.15335052,0.11333334,0.15335052,0.11666667,0.15335052,0.12,0.15335052,0.123333335,0.15335052,0.12666667,0.15335052,0.13,0.15335052,0.13333334,0.15335052,0.13666667,0.15335052,0.14,0.15335052,0.14333333,0.15335052,0.14666666,0.15335052,0.15,0.15335052,0.15333334,0.15335052,0.15666667,0.15335052,0.16,0.15335052,0.16333333,0.15335052,0.16666667,0.15335052,0.17,0.15335052,0.17333333,0.15335052,0.17666666,0.15335052,0.18,0.15335052,0.18333334,0.15335052,0.18666667,0.15335052,0.19,0.15335052,0.19333333,0.15335052,0.19666667,0.15335052,0.2,0.15335052,0.20333333,0.15335052,0.20666666,0.15335052,0.21,0.15335052,0.21333334,0.15335052,0.21666667,0.15335052,0.22,0.15335052,0.22333333,0.15335052,0.22666667,0.15335052,0.23,0.15335052,0.23333333,0.15335052,0.23666666,0.15335052,0.24,0.15335052,0.24333334,0.15335052,0.24666667,0.15335052,0.25,0.15335052,0.25333333,0.15335052,0.25666666,0.15335052,0.26,0.15335052,0.26333332,0.15335052,0.26666668,0.15335052,0.27,0.15335052,0.27333334,0.15335052,0.27666667,0.15335052,0.28,0.15335052,0.28333333,0.15335052,0.28666666,0.15335052,0.29,0.15335052,0.29333332,0.15335052,0.29666665,0.15335052,0.3,0.15335052,0.30333334,0.15335052,0.30666667,0.15335052,0.31,0.15335052,0.31333333,0.15335052,0.31666666,0.15335052,0.32,0.15335052,0.32333332,0.15335052,0.32666665,0.15335052,0.33,0.15335052,0.33333334,0.15335052,0.33666667,0.15335052,0.34,0.15335052,0.34333333,0.15335052,0.34666666,0.15335052,0.35,0.15335052,0.35333332,0.15335052,0.35666665,0.15335052,0.36,0.15335052,0.36333334,0.15335052,0.36666667,0.15335052,0.37,0.15335052,0.37333333,0.15335052,0.37666667,0.15335052,0.38,0.15335052,0.38333333,0.15335052,0.38666666,0.15335052,0.39,0.15335052,0.39333335,0.15335052,0.39666668,0.15335052,0.4,0.15335052,0.40333334,0.15335052,0.40666667,0.15335052,0.41,0.15335052,0.41333333,0.15335052,0.41666666,0.15335052,0.42,0.15335052,0.42333335,0.15335052,0.42666668,0.15335052,0.43,0.15335052,0.43333334,0.15335052,0.43666667,0.15335052,0.44,0.15335052,0.44333333,0.15335052,0.44666666,0.15335052,0.45,0.15335052,0.45333335,0.15335052,0.45666668,0.15335052,0.46,0.15335052,0.46333334,0.15335052,0.46666667,0.15335052,0.47,0.15335052,0.47333333,0.15335052,0.47666666,0.15335052,0.48,0.15335052,0.48333332,0.15335052,0.48666668,0.15335052,0.49,0.15335052,0.49333334,0.15335052,0.49666667,0.15335052,0.5,0.15335052,0.50333333,0.15335052,0.50666666,0.15335052,0.51,0.15335052,0.5133333,0.15335052,0.51666665,0.15335052,0.52,0.15335052,0.5233333,0.15335052,0.52666664,0.15335052,0.53,0.15335052,0.53333336,0.15335052,0.5366667,0.15335052,0.54,0.15335052,0.54333335,0.15335052,0.5466667,0.15335052,0.55,0.15335052,0.55333334,0.15335052,0.5566667,0.15335052,0.56,0.15335052,0.56333333,0.15335052,0.56666666,0.15335052,0.57,0.15335052,0.5733333,0.15335052,0.57666665,0.15335052,0.58,0.15335052,0.5833333,0.15335052,0.58666664,0.15335052,0.59,0.15335052,0.5933333,0.15335052,0.5966667,0.15335052,0.6,0.15335052,0.60333335,0.15335052,0.6066667,0.15335052,0.61,0.15335052,0.61333334,0.15335052,0.6166667,0.15335052,0.62,0.15335052,0.62333333,0.15335052,0.62666667,0.15335052,0.63,0.15335052,0.6333333,0.15335052,0.63666666,0.15335052,0.64,0.15335052,0.6433333,0.15335052,0.64666665,0.15335052,0.65,0.15335052,0.6533333,0.15335052,0.6566667,0.15335052,0.66,0.15335052,0.66333336,0.15335052,0.68666667,0.15335052,0.69,0.15335052,0.6933333,0.15335052,0.7,0.15335052,0.7033333,0.15335052,0.70666665,0.15335052,0.71,0.15335052,0.7133333,0.15335052,0.71666664,0.15335052,0.72,0.15335052,0.72333336,0.15335052,0.7266667,0.15335052,0.73,0.15335052,0.73333335,0.15335052,0.7366667,0.15335052,0.74,0.15335052,0.7733333,0.15335052,0.77666664,0.15335052,0.78,0.15335052,0.78333336,0.15335052,0.79,0.15335052,0.79333335,0.15335052,0.7966667,0.15335052,0.8,0.15335052,0.81333333,0.15335052,0.85333335,0.15335052,0.86,0.15335052,0.86333334,0.15335052,0.8666667,0.15335052,0.87,0.15335052,0.87333333,0.15335052,0.87666667,0.15335052,0.88,0.15335052,0.8833333,0.15335052,0.88666666,0.15335052,0.89,0.15335052,0.92,0.15335052,0.92333335,0.15335052,0.9266667,0.15335052,0.93,0.15335052,0.93333334,0.15335052,0.93666667,0.15335052,0.94,0.15335052,0.9433333,0.15335052,0.94666666,0.15335052,0.05,0.15592784,0.053333335,0.15592784,0.05666667,0.15592784,0.06,0.15592784,0.06333333,0.15592784,0.06666667,0.15592784,0.07,0.15592784,0.07333333,0.15592784,0.07666667,0.15592784,0.08,0.15592784,0.083333336,0.15592784,0.086666666,0.15592784,0.09,0.15592784,0.093333334,0.15592784,0.096666664,0.15592784,0.1,0.15592784,0.10333333,0.15592784,0.10666667,0.15592784,0.11,0.15592784,0.11333334,0.15592784,0.11666667,0.15592784,0.12,0.15592784,0.123333335,0.15592784,0.12666667,0.15592784,0.13,0.15592784,0.13333334,0.15592784,0.13666667,0.15592784,0.14,0.15592784,0.14333333,0.15592784,0.14666666,0.15592784,0.15,0.15592784,0.15333334,0.15592784,0.15666667,0.15592784,0.16,0.15592784,0.16333333,0.15592784,0.16666667,0.15592784,0.17,0.15592784,0.17333333,0.15592784,0.17666666,0.15592784,0.18,0.15592784,0.18333334,0.15592784,0.18666667,0.15592784,0.19,0.15592784,0.19333333,0.15592784,0.19666667,0.15592784,0.2,0.15592784,0.20333333,0.15592784,0.20666666,0.15592784,0.21,0.15592784,0.21333334,0.15592784,0.21666667,0.15592784,0.22,0.15592784,0.22333333,0.15592784,0.22666667,0.15592784,0.23,0.15592784,0.23333333,0.15592784,0.23666666,0.15592784,0.24,0.15592784,0.24333334,0.15592784,0.24666667,0.15592784,0.25,0.15592784,0.25333333,0.15592784,0.25666666,0.15592784,0.26,0.15592784,0.26333332,0.15592784,0.26666668,0.15592784,0.27,0.15592784,0.27333334,0.15592784,0.27666667,0.15592784,0.28,0.15592784,0.28333333,0.15592784,0.28666666,0.15592784,0.29,0.15592784,0.29333332,0.15592784,0.29666665,0.15592784,0.3,0.15592784,0.30333334,0.15592784,0.30666667,0.15592784,0.31,0.15592784,0.31333333,0.15592784,0.31666666,0.15592784,0.32,0.15592784,0.32333332,0.15592784,0.32666665,0.15592784,0.33,0.15592784,0.33333334,0.15592784,0.33666667,0.15592784,0.34,0.15592784,0.34333333,0.15592784,0.34666666,0.15592784,0.35,0.15592784,0.35333332,0.15592784,0.35666665,0.15592784,0.36,0.15592784,0.36333334,0.15592784,0.36666667,0.15592784,0.37,0.15592784,0.37333333,0.15592784,0.37666667,0.15592784,0.38,0.15592784,0.38333333,0.15592784,0.38666666,0.15592784,0.39,0.15592784,0.39333335,0.15592784,0.39666668,0.15592784,0.4,0.15592784,0.40333334,0.15592784,0.40666667,0.15592784,0.41,0.15592784,0.41333333,0.15592784,0.41666666,0.15592784,0.42,0.15592784,0.42333335,0.15592784,0.42666668,0.15592784,0.43,0.15592784,0.43333334,0.15592784,0.43666667,0.15592784,0.44,0.15592784,0.44333333,0.15592784,0.44666666,0.15592784,0.45,0.15592784,0.45333335,0.15592784,0.45666668,0.15592784,0.46,0.15592784,0.46333334,0.15592784,0.46666667,0.15592784,0.47,0.15592784,0.47333333,0.15592784,0.47666666,0.15592784,0.48,0.15592784,0.48333332,0.15592784,0.48666668,0.15592784,0.49,0.15592784,0.49333334,0.15592784,0.49666667,0.15592784,0.5,0.15592784,0.50333333,0.15592784,0.50666666,0.15592784,0.51,0.15592784,0.5133333,0.15592784,0.51666665,0.15592784,0.52,0.15592784,0.5233333,0.15592784,0.52666664,0.15592784,0.53,0.15592784,0.53333336,0.15592784,0.5366667,0.15592784,0.54,0.15592784,0.54333335,0.15592784,0.5466667,0.15592784,0.55,0.15592784,0.55333334,0.15592784,0.5566667,0.15592784,0.56,0.15592784,0.56333333,0.15592784,0.56666666,0.15592784,0.57,0.15592784,0.5733333,0.15592784,0.57666665,0.15592784,0.58,0.15592784,0.5833333,0.15592784,0.58666664,0.15592784,0.59,0.15592784,0.5933333,0.15592784,0.5966667,0.15592784,0.6,0.15592784,0.60333335,0.15592784,0.6066667,0.15592784,0.61,0.15592784,0.61333334,0.15592784,0.6166667,0.15592784,0.62,0.15592784,0.62333333,0.15592784,0.62666667,0.15592784,0.63,0.15592784,0.6333333,0.15592784,0.63666666,0.15592784,0.64,0.15592784,0.6433333,0.15592784,0.64666665,0.15592784,0.65,0.15592784,0.6533333,0.15592784,0.6566667,0.15592784,0.66,0.15592784,0.66333336,0.15592784,0.6666667,0.15592784,0.67,0.15592784,0.67333335,0.15592784,0.6766667,0.15592784,0.68,0.15592784,0.68333334,0.15592784,0.68666667,0.15592784,0.7,0.15592784,0.7033333,0.15592784,0.70666665,0.15592784,0.71,0.15592784,0.7133333,0.15592784,0.71666664,0.15592784,0.72,0.15592784,0.72333336,0.15592784,0.7266667,0.15592784,0.73,0.15592784,0.73333335,0.15592784,0.7366667,0.15592784,0.74,0.15592784,0.74333334,0.15592784,0.74666667,0.15592784,0.75,0.15592784,0.75333333,0.15592784,0.75666666,0.15592784,0.76,0.15592784,0.7633333,0.15592784,0.76666665,0.15592784,0.77,0.15592784,0.7733333,0.15592784,0.77666664,0.15592784,0.78,0.15592784,0.78333336,0.15592784,0.7866667,0.15592784,0.79333335,0.15592784,0.7966667,0.15592784,0.8,0.15592784,0.80333334,0.15592784,0.8066667,0.15592784,0.8233333,0.15592784,0.82666665,0.15592784,0.83,0.15592784,0.8333333,0.15592784,0.83666664,0.15592784,0.84,0.15592784,0.8433333,0.15592784,0.8466667,0.15592784,0.85,0.15592784,0.85333335,0.15592784,0.8566667,0.15592784,0.86,0.15592784,0.86333334,0.15592784,0.8666667,0.15592784,0.87,0.15592784,0.87333333,0.15592784,0.87666667,0.15592784,0.88,0.15592784,0.8833333,0.15592784,0.88666666,0.15592784,0.89,0.15592784,0.8933333,0.15592784,0.89666665,0.15592784,0.9,0.15592784,0.9033333,0.15592784,0.9066667,0.15592784,0.91,0.15592784,0.91333336,0.15592784,0.9166667,0.15592784,0.92,0.15592784,0.92333335,0.15592784,0.9266667,0.15592784,0.93,0.15592784,0.93333334,0.15592784,0.93666667,0.15592784,0.94,0.15592784,0.9433333,0.15592784,0.94666666,0.15592784,0.05,0.15850516,0.053333335,0.15850516,0.05666667,0.15850516,0.06,0.15850516,0.06333333,0.15850516,0.06666667,0.15850516,0.07,0.15850516,0.07333333,0.15850516,0.07666667,0.15850516,0.08,0.15850516,0.083333336,0.15850516,0.086666666,0.15850516,0.09,0.15850516,0.093333334,0.15850516,0.096666664,0.15850516,0.1,0.15850516,0.10333333,0.15850516,0.10666667,0.15850516,0.11,0.15850516,0.11333334,0.15850516,0.11666667,0.15850516,0.12,0.15850516,0.123333335,0.15850516,0.12666667,0.15850516,0.13,0.15850516,0.13333334,0.15850516,0.13666667,0.15850516,0.14,0.15850516,0.14333333,0.15850516,0.14666666,0.15850516,0.15,0.15850516,0.15333334,0.15850516,0.15666667,0.15850516,0.16,0.15850516,0.16333333,0.15850516,0.16666667,0.15850516,0.17,0.15850516,0.17333333,0.15850516,0.17666666,0.15850516,0.18,0.15850516,0.18333334,0.15850516,0.18666667,0.15850516,0.19,0.15850516,0.19333333,0.15850516,0.19666667,0.15850516,0.2,0.15850516,0.20333333,0.15850516,0.20666666,0.15850516,0.21,0.15850516,0.21333334,0.15850516,0.21666667,0.15850516,0.22,0.15850516,0.22333333,0.15850516,0.22666667,0.15850516,0.23,0.15850516,0.23333333,0.15850516,0.23666666,0.15850516,0.24,0.15850516,0.24333334,0.15850516,0.24666667,0.15850516,0.25,0.15850516,0.25333333,0.15850516,0.25666666,0.15850516,0.26,0.15850516,0.26333332,0.15850516,0.26666668,0.15850516,0.27,0.15850516,0.27333334,0.15850516,0.27666667,0.15850516,0.28,0.15850516,0.28333333,0.15850516,0.28666666,0.15850516,0.29,0.15850516,0.29333332,0.15850516,0.29666665,0.15850516,0.3,0.15850516,0.30333334,0.15850516,0.30666667,0.15850516,0.31,0.15850516,0.31333333,0.15850516,0.31666666,0.15850516,0.32,0.15850516,0.32333332,0.15850516,0.32666665,0.15850516,0.33,0.15850516,0.33333334,0.15850516,0.33666667,0.15850516,0.34,0.15850516,0.34333333,0.15850516,0.34666666,0.15850516,0.35,0.15850516,0.35333332,0.15850516,0.35666665,0.15850516,0.36,0.15850516,0.36333334,0.15850516,0.36666667,0.15850516,0.37,0.15850516,0.37333333,0.15850516,0.37666667,0.15850516,0.38,0.15850516,0.38333333,0.15850516,0.38666666,0.15850516,0.39,0.15850516,0.39333335,0.15850516,0.39666668,0.15850516,0.4,0.15850516,0.40333334,0.15850516,0.40666667,0.15850516,0.41,0.15850516,0.41333333,0.15850516,0.41666666,0.15850516,0.42,0.15850516,0.42333335,0.15850516,0.42666668,0.15850516,0.43,0.15850516,0.43333334,0.15850516,0.43666667,0.15850516,0.44,0.15850516,0.44333333,0.15850516,0.44666666,0.15850516,0.45,0.15850516,0.45333335,0.15850516,0.45666668,0.15850516,0.46,0.15850516,0.46333334,0.15850516,0.46666667,0.15850516,0.47,0.15850516,0.47333333,0.15850516,0.47666666,0.15850516,0.48,0.15850516,0.48333332,0.15850516,0.48666668,0.15850516,0.49,0.15850516,0.49333334,0.15850516,0.49666667,0.15850516,0.5,0.15850516,0.50333333,0.15850516,0.50666666,0.15850516,0.51,0.15850516,0.5133333,0.15850516,0.51666665,0.15850516,0.52,0.15850516,0.5233333,0.15850516,0.52666664,0.15850516,0.53,0.15850516,0.53333336,0.15850516,0.5366667,0.15850516,0.54,0.15850516,0.54333335,0.15850516,0.5466667,0.15850516,0.55,0.15850516,0.55333334,0.15850516,0.5566667,0.15850516,0.56,0.15850516,0.56333333,0.15850516,0.56666666,0.15850516,0.57,0.15850516,0.5733333,0.15850516,0.57666665,0.15850516,0.58,0.15850516,0.5833333,0.15850516,0.58666664,0.15850516,0.59,0.15850516,0.5933333,0.15850516,0.5966667,0.15850516,0.6,0.15850516,0.60333335,0.15850516,0.6066667,0.15850516,0.61,0.15850516,0.61333334,0.15850516,0.6166667,0.15850516,0.62,0.15850516,0.62333333,0.15850516,0.62666667,0.15850516,0.63,0.15850516,0.6333333,0.15850516,0.63666666,0.15850516,0.64,0.15850516,0.6433333,0.15850516,0.64666665,0.15850516,0.65,0.15850516,0.6533333,0.15850516,0.6566667,0.15850516,0.66,0.15850516,0.66333336,0.15850516,0.6666667,0.15850516,0.67,0.15850516,0.67333335,0.15850516,0.6766667,0.15850516,0.68,0.15850516,0.68333334,0.15850516,0.68666667,0.15850516,0.69,0.15850516,0.6933333,0.15850516,0.69666666,0.15850516,0.7,0.15850516,0.7033333,0.15850516,0.70666665,0.15850516,0.71,0.15850516,0.7133333,0.15850516,0.71666664,0.15850516,0.72,0.15850516,0.72333336,0.15850516,0.7266667,0.15850516,0.73,0.15850516,0.73333335,0.15850516,0.7366667,0.15850516,0.74,0.15850516,0.74333334,0.15850516,0.74666667,0.15850516,0.75,0.15850516,0.75333333,0.15850516,0.75666666,0.15850516,0.76,0.15850516,0.7633333,0.15850516,0.76666665,0.15850516,0.77,0.15850516,0.7733333,0.15850516,0.77666664,0.15850516,0.78,0.15850516,0.78333336,0.15850516,0.7866667,0.15850516,0.79,0.15850516,0.79333335,0.15850516,0.7966667,0.15850516,0.8,0.15850516,0.80333334,0.15850516,0.8066667,0.15850516,0.81,0.15850516,0.81333333,0.15850516,0.81666666,0.15850516,0.82,0.15850516,0.8233333,0.15850516,0.82666665,0.15850516,0.83,0.15850516,0.8333333,0.15850516,0.83666664,0.15850516,0.84,0.15850516,0.8433333,0.15850516,0.8466667,0.15850516,0.85,0.15850516,0.85333335,0.15850516,0.8566667,0.15850516,0.86,0.15850516,0.86333334,0.15850516,0.8666667,0.15850516,0.87,0.15850516,0.87333333,0.15850516,0.87666667,0.15850516,0.88,0.15850516,0.8833333,0.15850516,0.88666666,0.15850516,0.89,0.15850516,0.8933333,0.15850516,0.89666665,0.15850516,0.9,0.15850516,0.9033333,0.15850516,0.9066667,0.15850516,0.91,0.15850516,0.91333336,0.15850516,0.9166667,0.15850516,0.92,0.15850516,0.92333335,0.15850516,0.9266667,0.15850516,0.93,0.15850516,0.93333334,0.15850516,0.93666667,0.15850516,0.94,0.15850516,0.9433333,0.15850516,0.94666666,0.15850516,0.05,0.16108248,0.053333335,0.16108248,0.05666667,0.16108248,0.06,0.16108248,0.06333333,0.16108248,0.06666667,0.16108248,0.07,0.16108248,0.07333333,0.16108248,0.07666667,0.16108248,0.08,0.16108248,0.083333336,0.16108248,0.086666666,0.16108248,0.09,0.16108248,0.093333334,0.16108248,0.096666664,0.16108248,0.1,0.16108248,0.10333333,0.16108248,0.10666667,0.16108248,0.11,0.16108248,0.11333334,0.16108248,0.11666667,0.16108248,0.12,0.16108248,0.123333335,0.16108248,0.12666667,0.16108248,0.13,0.16108248,0.13333334,0.16108248,0.13666667,0.16108248,0.14,0.16108248,0.14333333,0.16108248,0.14666666,0.16108248,0.15,0.16108248,0.15333334,0.16108248,0.15666667,0.16108248,0.16,0.16108248,0.16333333,0.16108248,0.16666667,0.16108248,0.17,0.16108248,0.17333333,0.16108248,0.17666666,0.16108248,0.18,0.16108248,0.18333334,0.16108248,0.18666667,0.16108248,0.19,0.16108248,0.19333333,0.16108248,0.19666667,0.16108248,0.2,0.16108248,0.20333333,0.16108248,0.20666666,0.16108248,0.21,0.16108248,0.21333334,0.16108248,0.21666667,0.16108248,0.22,0.16108248,0.22333333,0.16108248,0.22666667,0.16108248,0.23,0.16108248,0.23333333,0.16108248,0.23666666,0.16108248,0.24,0.16108248,0.24333334,0.16108248,0.24666667,0.16108248,0.25,0.16108248,0.25333333,0.16108248,0.25666666,0.16108248,0.26,0.16108248,0.26333332,0.16108248,0.26666668,0.16108248,0.27,0.16108248,0.27333334,0.16108248,0.27666667,0.16108248,0.28,0.16108248,0.28333333,0.16108248,0.28666666,0.16108248,0.29,0.16108248,0.29333332,0.16108248,0.29666665,0.16108248,0.3,0.16108248,0.30333334,0.16108248,0.30666667,0.16108248,0.31,0.16108248,0.31333333,0.16108248,0.31666666,0.16108248,0.32,0.16108248,0.32333332,0.16108248,0.32666665,0.16108248,0.33,0.16108248,0.33333334,0.16108248,0.33666667,0.16108248,0.34,0.16108248,0.34333333,0.16108248,0.34666666,0.16108248,0.35,0.16108248,0.35333332,0.16108248,0.35666665,0.16108248,0.36,0.16108248,0.36333334,0.16108248,0.36666667,0.16108248,0.37,0.16108248,0.37333333,0.16108248,0.37666667,0.16108248,0.38,0.16108248,0.38333333,0.16108248,0.38666666,0.16108248,0.39,0.16108248,0.39333335,0.16108248,0.39666668,0.16108248,0.4,0.16108248,0.40333334,0.16108248,0.40666667,0.16108248,0.41,0.16108248,0.41333333,0.16108248,0.41666666,0.16108248,0.42,0.16108248,0.42333335,0.16108248,0.42666668,0.16108248,0.43,0.16108248,0.43333334,0.16108248,0.43666667,0.16108248,0.44,0.16108248,0.44333333,0.16108248,0.44666666,0.16108248,0.45,0.16108248,0.45333335,0.16108248,0.45666668,0.16108248,0.46,0.16108248,0.46333334,0.16108248,0.46666667,0.16108248,0.47,0.16108248,0.47333333,0.16108248,0.47666666,0.16108248,0.48,0.16108248,0.48333332,0.16108248,0.48666668,0.16108248,0.49,0.16108248,0.49333334,0.16108248,0.49666667,0.16108248,0.5,0.16108248,0.50333333,0.16108248,0.50666666,0.16108248,0.51,0.16108248,0.5133333,0.16108248,0.51666665,0.16108248,0.52,0.16108248,0.5233333,0.16108248,0.52666664,0.16108248,0.53,0.16108248,0.53333336,0.16108248,0.5366667,0.16108248,0.54,0.16108248,0.54333335,0.16108248,0.5466667,0.16108248,0.55,0.16108248,0.55333334,0.16108248,0.5566667,0.16108248,0.56,0.16108248,0.56333333,0.16108248,0.56666666,0.16108248,0.57,0.16108248,0.5733333,0.16108248,0.57666665,0.16108248,0.58,0.16108248,0.5833333,0.16108248,0.58666664,0.16108248,0.59,0.16108248,0.5933333,0.16108248,0.5966667,0.16108248,0.6,0.16108248,0.60333335,0.16108248,0.6066667,0.16108248,0.61,0.16108248,0.61333334,0.16108248,0.6166667,0.16108248,0.62,0.16108248,0.62333333,0.16108248,0.62666667,0.16108248,0.63,0.16108248,0.6333333,0.16108248,0.63666666,0.16108248,0.64,0.16108248,0.6433333,0.16108248,0.64666665,0.16108248,0.65,0.16108248,0.6533333,0.16108248,0.6566667,0.16108248,0.66,0.16108248,0.66333336,0.16108248,0.6666667,0.16108248,0.67,0.16108248,0.67333335,0.16108248,0.6766667,0.16108248,0.68,0.16108248,0.68333334,0.16108248,0.68666667,0.16108248,0.69,0.16108248,0.6933333,0.16108248,0.69666666,0.16108248,0.7,0.16108248,0.7033333,0.16108248,0.70666665,0.16108248,0.71,0.16108248,0.7133333,0.16108248,0.71666664,0.16108248,0.72,0.16108248,0.72333336,0.16108248,0.7266667,0.16108248,0.73,0.16108248,0.73333335,0.16108248,0.7366667,0.16108248,0.74,0.16108248,0.74333334,0.16108248,0.74666667,0.16108248,0.75,0.16108248,0.75333333,0.16108248,0.75666666,0.16108248,0.76,0.16108248,0.7633333,0.16108248,0.76666665,0.16108248,0.77,0.16108248,0.7733333,0.16108248,0.77666664,0.16108248,0.78,0.16108248,0.78333336,0.16108248,0.7866667,0.16108248,0.79,0.16108248,0.79333335,0.16108248,0.7966667,0.16108248,0.8,0.16108248,0.80333334,0.16108248,0.8066667,0.16108248,0.81,0.16108248,0.81333333,0.16108248,0.81666666,0.16108248,0.82,0.16108248,0.8233333,0.16108248,0.82666665,0.16108248,0.83,0.16108248,0.8333333,0.16108248,0.83666664,0.16108248,0.84,0.16108248,0.8433333,0.16108248,0.8466667,0.16108248,0.85,0.16108248,0.85333335,0.16108248,0.8566667,0.16108248,0.86,0.16108248,0.86333334,0.16108248,0.8666667,0.16108248,0.87,0.16108248,0.87333333,0.16108248,0.87666667,0.16108248,0.88,0.16108248,0.8833333,0.16108248,0.88666666,0.16108248,0.89,0.16108248,0.8933333,0.16108248,0.89666665,0.16108248,0.9,0.16108248,0.9033333,0.16108248,0.9066667,0.16108248,0.91,0.16108248,0.91333336,0.16108248,0.9166667,0.16108248,0.92,0.16108248,0.92333335,0.16108248,0.9266667,0.16108248,0.93,0.16108248,0.93333334,0.16108248,0.93666667,0.16108248,0.94,0.16108248,0.9433333,0.16108248,0.94666666,0.16108248,0.05,0.1636598,0.053333335,0.1636598,0.05666667,0.1636598,0.06,0.1636598,0.06333333,0.1636598,0.06666667,0.1636598,0.07,0.1636598,0.07333333,0.1636598,0.07666667,0.1636598,0.08,0.1636598,0.083333336,0.1636598,0.086666666,0.1636598,0.09,0.1636598,0.093333334,0.1636598,0.096666664,0.1636598,0.1,0.1636598,0.10333333,0.1636598,0.10666667,0.1636598,0.11,0.1636598,0.11333334,0.1636598,0.11666667,0.1636598,0.12,0.1636598,0.123333335,0.1636598,0.12666667,0.1636598,0.13,0.1636598,0.13333334,0.1636598,0.13666667,0.1636598,0.14,0.1636598,0.14333333,0.1636598,0.14666666,0.1636598,0.15,0.1636598,0.15333334,0.1636598,0.15666667,0.1636598,0.16,0.1636598,0.16333333,0.1636598,0.16666667,0.1636598,0.17,0.1636598,0.17333333,0.1636598,0.17666666,0.1636598,0.18,0.1636598,0.18333334,0.1636598,0.18666667,0.1636598,0.19,0.1636598,0.19333333,0.1636598,0.19666667,0.1636598,0.2,0.1636598,0.20333333,0.1636598,0.20666666,0.1636598,0.21,0.1636598,0.21333334,0.1636598,0.21666667,0.1636598,0.22,0.1636598,0.22333333,0.1636598,0.22666667,0.1636598,0.23,0.1636598,0.23333333,0.1636598,0.23666666,0.1636598,0.24,0.1636598,0.24333334,0.1636598,0.24666667,0.1636598,0.25,0.1636598,0.25333333,0.1636598,0.25666666,0.1636598,0.26,0.1636598,0.26333332,0.1636598,0.26666668,0.1636598,0.27,0.1636598,0.27333334,0.1636598,0.27666667,0.1636598,0.28,0.1636598,0.28333333,0.1636598,0.28666666,0.1636598,0.29,0.1636598,0.29333332,0.1636598,0.29666665,0.1636598,0.3,0.1636598,0.30333334,0.1636598,0.30666667,0.1636598,0.31,0.1636598,0.31333333,0.1636598,0.31666666,0.1636598,0.32,0.1636598,0.32333332,0.1636598,0.32666665,0.1636598,0.33,0.1636598,0.33333334,0.1636598,0.33666667,0.1636598,0.34,0.1636598,0.34333333,0.1636598,0.34666666,0.1636598,0.35,0.1636598,0.35333332,0.1636598,0.35666665,0.1636598,0.36,0.1636598,0.36333334,0.1636598,0.36666667,0.1636598,0.37,0.1636598,0.37333333,0.1636598,0.37666667,0.1636598,0.38,0.1636598,0.38333333,0.1636598,0.38666666,0.1636598,0.39,0.1636598,0.39333335,0.1636598,0.39666668,0.1636598,0.4,0.1636598,0.40333334,0.1636598,0.40666667,0.1636598,0.41,0.1636598,0.41333333,0.1636598,0.41666666,0.1636598,0.42,0.1636598,0.42333335,0.1636598,0.42666668,0.1636598,0.43,0.1636598,0.43333334,0.1636598,0.43666667,0.1636598,0.44,0.1636598,0.44333333,0.1636598,0.44666666,0.1636598,0.45,0.1636598,0.45333335,0.1636598,0.45666668,0.1636598,0.46,0.1636598,0.46333334,0.1636598,0.46666667,0.1636598,0.47,0.1636598,0.47333333,0.1636598,0.47666666,0.1636598,0.48,0.1636598,0.48333332,0.1636598,0.48666668,0.1636598,0.49,0.1636598,0.49333334,0.1636598,0.49666667,0.1636598,0.5,0.1636598,0.50333333,0.1636598,0.50666666,0.1636598,0.51,0.1636598,0.5133333,0.1636598,0.51666665,0.1636598,0.52,0.1636598,0.5233333,0.1636598,0.52666664,0.1636598,0.53,0.1636598,0.53333336,0.1636598,0.5366667,0.1636598,0.54,0.1636598,0.54333335,0.1636598,0.5466667,0.1636598,0.55,0.1636598,0.55333334,0.1636598,0.5566667,0.1636598,0.56,0.1636598,0.56333333,0.1636598,0.56666666,0.1636598,0.57,0.1636598,0.5733333,0.1636598,0.57666665,0.1636598,0.58,0.1636598,0.5833333,0.1636598,0.58666664,0.1636598,0.59,0.1636598,0.5933333,0.1636598,0.5966667,0.1636598,0.6,0.1636598,0.60333335,0.1636598,0.6066667,0.1636598,0.61,0.1636598,0.61333334,0.1636598,0.6166667,0.1636598,0.62,0.1636598,0.62333333,0.1636598,0.62666667,0.1636598,0.63,0.1636598,0.6333333,0.1636598,0.63666666,0.1636598,0.64,0.1636598,0.6433333,0.1636598,0.64666665,0.1636598,0.65,0.1636598,0.6533333,0.1636598,0.6566667,0.1636598,0.66,0.1636598,0.66333336,0.1636598,0.6666667,0.1636598,0.67,0.1636598,0.67333335,0.1636598,0.6766667,0.1636598,0.68,0.1636598,0.68333334,0.1636598,0.68666667,0.1636598,0.69,0.1636598,0.6933333,0.1636598,0.69666666,0.1636598,0.7,0.1636598,0.7033333,0.1636598,0.70666665,0.1636598,0.71,0.1636598,0.7133333,0.1636598,0.71666664,0.1636598,0.72,0.1636598,0.72333336,0.1636598,0.7266667,0.1636598,0.73,0.1636598,0.73333335,0.1636598,0.7366667,0.1636598,0.74,0.1636598,0.74333334,0.1636598,0.74666667,0.1636598,0.75,0.1636598,0.75333333,0.1636598,0.75666666,0.1636598,0.76,0.1636598,0.7633333,0.1636598,0.76666665,0.1636598,0.77,0.1636598,0.7733333,0.1636598,0.77666664,0.1636598,0.78,0.1636598,0.78333336,0.1636598,0.7866667,0.1636598,0.79,0.1636598,0.79333335,0.1636598,0.7966667,0.1636598,0.8,0.1636598,0.80333334,0.1636598,0.8066667,0.1636598,0.81,0.1636598,0.81333333,0.1636598,0.81666666,0.1636598,0.82,0.1636598,0.8233333,0.1636598,0.82666665,0.1636598,0.83,0.1636598,0.8333333,0.1636598,0.83666664,0.1636598,0.84,0.1636598,0.8433333,0.1636598,0.8466667,0.1636598,0.85,0.1636598,0.85333335,0.1636598,0.8566667,0.1636598,0.86,0.1636598,0.86333334,0.1636598,0.8666667,0.1636598,0.87,0.1636598,0.87333333,0.1636598,0.87666667,0.1636598,0.88,0.1636598,0.8833333,0.1636598,0.88666666,0.1636598,0.89,0.1636598,0.8933333,0.1636598,0.89666665,0.1636598,0.9,0.1636598,0.9033333,0.1636598,0.9066667,0.1636598,0.91,0.1636598,0.91333336,0.1636598,0.9166667,0.1636598,0.92,0.1636598,0.92333335,0.1636598,0.9266667,0.1636598,0.93,0.1636598,0.93333334,0.1636598,0.93666667,0.1636598,0.94,0.1636598,0.9433333,0.1636598,0.94666666,0.1636598,0.05,0.16623712,0.053333335,0.16623712,0.05666667,0.16623712,0.06,0.16623712,0.06333333,0.16623712,0.06666667,0.16623712,0.07,0.16623712,0.07333333,0.16623712,0.07666667,0.16623712,0.08,0.16623712,0.083333336,0.16623712,0.086666666,0.16623712,0.09,0.16623712,0.093333334,0.16623712,0.096666664,0.16623712,0.1,0.16623712,0.10333333,0.16623712,0.10666667,0.16623712,0.11,0.16623712,0.11333334,0.16623712,0.11666667,0.16623712,0.12,0.16623712,0.123333335,0.16623712,0.12666667,0.16623712,0.13,0.16623712,0.13333334,0.16623712,0.13666667,0.16623712,0.14,0.16623712,0.14333333,0.16623712,0.14666666,0.16623712,0.15,0.16623712,0.15333334,0.16623712,0.15666667,0.16623712,0.16,0.16623712,0.16333333,0.16623712,0.16666667,0.16623712,0.17,0.16623712,0.17333333,0.16623712,0.17666666,0.16623712,0.18,0.16623712,0.18333334,0.16623712,0.18666667,0.16623712,0.19,0.16623712,0.19333333,0.16623712,0.19666667,0.16623712,0.2,0.16623712,0.20333333,0.16623712,0.20666666,0.16623712,0.21,0.16623712,0.21333334,0.16623712,0.21666667,0.16623712,0.22,0.16623712,0.22333333,0.16623712,0.22666667,0.16623712,0.23,0.16623712,0.23333333,0.16623712,0.23666666,0.16623712,0.24,0.16623712,0.24333334,0.16623712,0.24666667,0.16623712,0.25,0.16623712,0.25333333,0.16623712,0.25666666,0.16623712,0.26,0.16623712,0.26333332,0.16623712,0.26666668,0.16623712,0.27,0.16623712,0.27333334,0.16623712,0.27666667,0.16623712,0.28,0.16623712,0.28333333,0.16623712,0.28666666,0.16623712,0.29,0.16623712,0.29333332,0.16623712,0.29666665,0.16623712,0.3,0.16623712,0.30333334,0.16623712,0.30666667,0.16623712,0.31,0.16623712,0.31333333,0.16623712,0.31666666,0.16623712,0.32,0.16623712,0.32333332,0.16623712,0.32666665,0.16623712,0.33,0.16623712,0.33333334,0.16623712,0.33666667,0.16623712,0.34,0.16623712,0.34333333,0.16623712,0.34666666,0.16623712,0.35,0.16623712,0.35333332,0.16623712,0.35666665,0.16623712,0.36,0.16623712,0.36333334,0.16623712,0.36666667,0.16623712,0.37,0.16623712,0.37333333,0.16623712,0.37666667,0.16623712,0.38,0.16623712,0.38333333,0.16623712,0.38666666,0.16623712,0.39,0.16623712,0.39333335,0.16623712,0.39666668,0.16623712,0.4,0.16623712,0.40333334,0.16623712,0.40666667,0.16623712,0.41,0.16623712,0.41333333,0.16623712,0.41666666,0.16623712,0.42,0.16623712,0.42333335,0.16623712,0.42666668,0.16623712,0.43,0.16623712,0.43333334,0.16623712,0.43666667,0.16623712,0.44,0.16623712,0.44333333,0.16623712,0.44666666,0.16623712,0.45,0.16623712,0.45333335,0.16623712,0.45666668,0.16623712,0.46,0.16623712,0.46333334,0.16623712,0.46666667,0.16623712,0.47,0.16623712,0.47333333,0.16623712,0.47666666,0.16623712,0.48,0.16623712,0.48333332,0.16623712,0.48666668,0.16623712,0.49,0.16623712,0.49333334,0.16623712,0.49666667,0.16623712,0.5,0.16623712,0.50333333,0.16623712,0.50666666,0.16623712,0.51,0.16623712,0.5133333,0.16623712,0.51666665,0.16623712,0.52,0.16623712,0.5233333,0.16623712,0.52666664,0.16623712,0.53,0.16623712,0.53333336,0.16623712,0.5366667,0.16623712,0.54,0.16623712,0.54333335,0.16623712,0.5466667,0.16623712,0.55,0.16623712,0.55333334,0.16623712,0.5566667,0.16623712,0.56,0.16623712,0.56333333,0.16623712,0.56666666,0.16623712,0.57,0.16623712,0.5733333,0.16623712,0.57666665,0.16623712,0.58,0.16623712,0.5833333,0.16623712,0.58666664,0.16623712,0.59,0.16623712,0.5933333,0.16623712,0.5966667,0.16623712,0.6,0.16623712,0.60333335,0.16623712,0.6066667,0.16623712,0.61,0.16623712,0.61333334,0.16623712,0.6166667,0.16623712,0.62,0.16623712,0.62333333,0.16623712,0.62666667,0.16623712,0.63,0.16623712,0.6333333,0.16623712,0.63666666,0.16623712,0.64,0.16623712,0.6433333,0.16623712,0.64666665,0.16623712,0.65,0.16623712,0.6533333,0.16623712,0.6566667,0.16623712,0.66,0.16623712,0.66333336,0.16623712,0.6666667,0.16623712,0.67,0.16623712,0.67333335,0.16623712,0.6766667,0.16623712,0.68,0.16623712,0.68333334,0.16623712,0.68666667,0.16623712,0.69,0.16623712,0.6933333,0.16623712,0.69666666,0.16623712,0.7,0.16623712,0.7033333,0.16623712,0.70666665,0.16623712,0.71,0.16623712,0.7133333,0.16623712,0.71666664,0.16623712,0.72,0.16623712,0.72333336,0.16623712,0.7266667,0.16623712,0.73,0.16623712,0.73333335,0.16623712,0.7366667,0.16623712,0.74,0.16623712,0.74333334,0.16623712,0.74666667,0.16623712,0.75,0.16623712,0.75333333,0.16623712,0.75666666,0.16623712,0.76,0.16623712,0.7633333,0.16623712,0.76666665,0.16623712,0.77,0.16623712,0.7733333,0.16623712,0.77666664,0.16623712,0.78,0.16623712,0.78333336,0.16623712,0.7866667,0.16623712,0.79,0.16623712,0.79333335,0.16623712,0.7966667,0.16623712,0.8,0.16623712,0.80333334,0.16623712,0.8066667,0.16623712,0.81,0.16623712,0.81333333,0.16623712,0.81666666,0.16623712,0.82,0.16623712,0.8233333,0.16623712,0.82666665,0.16623712,0.83,0.16623712,0.8333333,0.16623712,0.83666664,0.16623712,0.84,0.16623712,0.8433333,0.16623712,0.8466667,0.16623712,0.85,0.16623712,0.85333335,0.16623712,0.8566667,0.16623712,0.86,0.16623712,0.86333334,0.16623712,0.8666667,0.16623712,0.87,0.16623712,0.87333333,0.16623712,0.87666667,0.16623712,0.88,0.16623712,0.8833333,0.16623712,0.88666666,0.16623712,0.89,0.16623712,0.8933333,0.16623712,0.89666665,0.16623712,0.9,0.16623712,0.9033333,0.16623712,0.9066667,0.16623712,0.91,0.16623712,0.91333336,0.16623712,0.9166667,0.16623712,0.92,0.16623712,0.92333335,0.16623712,0.9266667,0.16623712,0.93,0.16623712,0.93333334,0.16623712,0.93666667,0.16623712,0.94,0.16623712,0.9433333,0.16623712,0.94666666,0.16623712,0.05,0.16881444,0.053333335,0.16881444,0.05666667,0.16881444,0.06,0.16881444,0.06333333,0.16881444,0.06666667,0.16881444,0.07,0.16881444,0.07333333,0.16881444,0.07666667,0.16881444,0.08,0.16881444,0.083333336,0.16881444,0.086666666,0.16881444,0.09,0.16881444,0.093333334,0.16881444,0.096666664,0.16881444,0.1,0.16881444,0.10333333,0.16881444,0.10666667,0.16881444,0.11,0.16881444,0.11333334,0.16881444,0.11666667,0.16881444,0.12,0.16881444,0.123333335,0.16881444,0.12666667,0.16881444,0.13,0.16881444,0.13333334,0.16881444,0.13666667,0.16881444,0.14,0.16881444,0.14333333,0.16881444,0.14666666,0.16881444,0.15,0.16881444,0.15333334,0.16881444,0.15666667,0.16881444,0.16,0.16881444,0.16333333,0.16881444,0.16666667,0.16881444,0.17,0.16881444,0.17333333,0.16881444,0.17666666,0.16881444,0.18,0.16881444,0.18333334,0.16881444,0.18666667,0.16881444,0.19,0.16881444,0.19333333,0.16881444,0.19666667,0.16881444,0.2,0.16881444,0.20333333,0.16881444,0.20666666,0.16881444,0.21,0.16881444,0.21333334,0.16881444,0.21666667,0.16881444,0.22,0.16881444,0.22333333,0.16881444,0.22666667,0.16881444,0.23,0.16881444,0.23333333,0.16881444,0.23666666,0.16881444,0.24,0.16881444,0.24333334,0.16881444,0.24666667,0.16881444,0.25,0.16881444,0.25333333,0.16881444,0.25666666,0.16881444,0.26,0.16881444,0.26333332,0.16881444,0.26666668,0.16881444,0.27,0.16881444,0.27333334,0.16881444,0.27666667,0.16881444,0.28,0.16881444,0.28333333,0.16881444,0.28666666,0.16881444,0.29,0.16881444,0.29333332,0.16881444,0.29666665,0.16881444,0.3,0.16881444,0.30333334,0.16881444,0.30666667,0.16881444,0.31,0.16881444,0.31333333,0.16881444,0.31666666,0.16881444,0.32,0.16881444,0.32333332,0.16881444,0.32666665,0.16881444,0.33,0.16881444,0.33333334,0.16881444,0.33666667,0.16881444,0.34,0.16881444,0.34333333,0.16881444,0.34666666,0.16881444,0.35,0.16881444,0.35333332,0.16881444,0.35666665,0.16881444,0.36,0.16881444,0.36333334,0.16881444,0.36666667,0.16881444,0.37,0.16881444,0.37333333,0.16881444,0.37666667,0.16881444,0.38,0.16881444,0.38333333,0.16881444,0.38666666,0.16881444,0.39,0.16881444,0.39333335,0.16881444,0.39666668,0.16881444,0.4,0.16881444,0.40333334,0.16881444,0.40666667,0.16881444,0.41,0.16881444,0.41333333,0.16881444,0.41666666,0.16881444,0.42,0.16881444,0.42333335,0.16881444,0.42666668,0.16881444,0.43,0.16881444,0.43333334,0.16881444,0.43666667,0.16881444,0.44,0.16881444,0.44333333,0.16881444,0.44666666,0.16881444,0.45,0.16881444,0.45333335,0.16881444,0.45666668,0.16881444,0.46,0.16881444,0.46333334,0.16881444,0.46666667,0.16881444,0.47,0.16881444,0.47333333,0.16881444,0.47666666,0.16881444,0.48,0.16881444,0.48333332,0.16881444,0.48666668,0.16881444,0.49,0.16881444,0.49333334,0.16881444,0.49666667,0.16881444,0.5,0.16881444,0.50333333,0.16881444,0.50666666,0.16881444,0.51,0.16881444,0.5133333,0.16881444,0.51666665,0.16881444,0.52,0.16881444,0.5233333,0.16881444,0.52666664,0.16881444,0.53,0.16881444,0.53333336,0.16881444,0.5366667,0.16881444,0.54,0.16881444,0.54333335,0.16881444,0.5466667,0.16881444,0.55,0.16881444,0.55333334,0.16881444,0.5566667,0.16881444,0.56,0.16881444,0.56333333,0.16881444,0.56666666,0.16881444,0.57,0.16881444,0.5733333,0.16881444,0.57666665,0.16881444,0.58,0.16881444,0.5833333,0.16881444,0.58666664,0.16881444,0.59,0.16881444,0.5933333,0.16881444,0.5966667,0.16881444,0.6,0.16881444,0.60333335,0.16881444,0.6066667,0.16881444,0.61,0.16881444,0.61333334,0.16881444,0.6166667,0.16881444,0.62,0.16881444,0.62333333,0.16881444,0.62666667,0.16881444,0.63,0.16881444,0.6333333,0.16881444,0.63666666,0.16881444,0.64,0.16881444,0.6433333,0.16881444,0.64666665,0.16881444,0.65,0.16881444,0.6533333,0.16881444,0.6566667,0.16881444,0.66,0.16881444,0.66333336,0.16881444,0.6666667,0.16881444,0.67,0.16881444,0.67333335,0.16881444,0.6766667,0.16881444,0.68,0.16881444,0.68333334,0.16881444,0.68666667,0.16881444,0.69,0.16881444,0.6933333,0.16881444,0.69666666,0.16881444,0.7,0.16881444,0.7033333,0.16881444,0.70666665,0.16881444,0.71,0.16881444,0.7133333,0.16881444,0.71666664,0.16881444,0.72,0.16881444,0.72333336,0.16881444,0.7266667,0.16881444,0.73,0.16881444,0.73333335,0.16881444,0.7366667,0.16881444,0.74,0.16881444,0.74333334,0.16881444,0.74666667,0.16881444,0.75,0.16881444,0.75333333,0.16881444,0.75666666,0.16881444,0.76,0.16881444,0.7633333,0.16881444,0.76666665,0.16881444,0.77,0.16881444,0.7733333,0.16881444,0.77666664,0.16881444,0.78,0.16881444,0.78333336,0.16881444,0.7866667,0.16881444,0.79,0.16881444,0.79333335,0.16881444,0.7966667,0.16881444,0.8,0.16881444,0.80333334,0.16881444,0.8066667,0.16881444,0.81,0.16881444,0.81333333,0.16881444,0.81666666,0.16881444,0.82,0.16881444,0.8233333,0.16881444,0.82666665,0.16881444,0.83,0.16881444,0.8333333,0.16881444,0.83666664,0.16881444,0.84,0.16881444,0.8433333,0.16881444,0.8466667,0.16881444,0.85,0.16881444,0.85333335,0.16881444,0.8566667,0.16881444,0.86,0.16881444,0.86333334,0.16881444,0.8666667,0.16881444,0.87,0.16881444,0.87333333,0.16881444,0.87666667,0.16881444,0.88,0.16881444,0.8833333,0.16881444,0.88666666,0.16881444,0.89,0.16881444,0.8933333,0.16881444,0.89666665,0.16881444,0.9,0.16881444,0.9033333,0.16881444,0.9066667,0.16881444,0.91,0.16881444,0.91333336,0.16881444,0.9166667,0.16881444,0.92,0.16881444,0.92333335,0.16881444,0.9266667,0.16881444,0.93,0.16881444,0.93333334,0.16881444,0.93666667,0.16881444,0.94,0.16881444,0.9433333,0.16881444,0.94666666,0.16881444,0.05,0.17139176,0.053333335,0.17139176,0.05666667,0.17139176,0.06,0.17139176,0.06333333,0.17139176,0.06666667,0.17139176,0.07,0.17139176,0.07333333,0.17139176,0.07666667,0.17139176,0.08,0.17139176,0.083333336,0.17139176,0.086666666,0.17139176,0.09,0.17139176,0.093333334,0.17139176,0.096666664,0.17139176,0.1,0.17139176,0.10333333,0.17139176,0.10666667,0.17139176,0.11,0.17139176,0.11333334,0.17139176,0.11666667,0.17139176,0.12,0.17139176,0.123333335,0.17139176,0.12666667,0.17139176,0.13,0.17139176,0.13333334,0.17139176,0.13666667,0.17139176,0.14,0.17139176,0.14333333,0.17139176,0.14666666,0.17139176,0.15,0.17139176,0.15333334,0.17139176,0.15666667,0.17139176,0.16,0.17139176,0.16333333,0.17139176,0.16666667,0.17139176,0.17,0.17139176,0.17333333,0.17139176,0.17666666,0.17139176,0.18,0.17139176,0.18333334,0.17139176,0.18666667,0.17139176,0.19,0.17139176,0.19333333,0.17139176,0.19666667,0.17139176,0.2,0.17139176,0.20333333,0.17139176,0.20666666,0.17139176,0.21,0.17139176,0.21333334,0.17139176,0.21666667,0.17139176,0.22,0.17139176,0.22333333,0.17139176,0.22666667,0.17139176,0.23,0.17139176,0.23333333,0.17139176,0.23666666,0.17139176,0.24,0.17139176,0.24333334,0.17139176,0.24666667,0.17139176,0.25,0.17139176,0.25333333,0.17139176,0.25666666,0.17139176,0.26,0.17139176,0.26333332,0.17139176,0.26666668,0.17139176,0.27,0.17139176,0.27333334,0.17139176,0.27666667,0.17139176,0.28,0.17139176,0.28333333,0.17139176,0.28666666,0.17139176,0.29,0.17139176,0.29333332,0.17139176,0.29666665,0.17139176,0.3,0.17139176,0.30333334,0.17139176,0.30666667,0.17139176,0.31,0.17139176,0.31333333,0.17139176,0.31666666,0.17139176,0.32,0.17139176,0.32333332,0.17139176,0.32666665,0.17139176,0.33,0.17139176,0.33333334,0.17139176,0.33666667,0.17139176,0.34,0.17139176,0.34333333,0.17139176,0.34666666,0.17139176,0.35,0.17139176,0.35333332,0.17139176,0.35666665,0.17139176,0.36,0.17139176,0.36333334,0.17139176,0.36666667,0.17139176,0.37,0.17139176,0.37333333,0.17139176,0.37666667,0.17139176,0.38,0.17139176,0.38333333,0.17139176,0.38666666,0.17139176,0.39,0.17139176,0.39333335,0.17139176,0.39666668,0.17139176,0.4,0.17139176,0.40333334,0.17139176,0.40666667,0.17139176,0.41,0.17139176,0.41333333,0.17139176,0.41666666,0.17139176,0.42,0.17139176,0.42333335,0.17139176,0.42666668,0.17139176,0.43,0.17139176,0.43333334,0.17139176,0.43666667,0.17139176,0.44,0.17139176,0.44333333,0.17139176,0.44666666,0.17139176,0.45,0.17139176,0.45333335,0.17139176,0.45666668,0.17139176,0.46,0.17139176,0.46333334,0.17139176,0.46666667,0.17139176,0.47,0.17139176,0.47333333,0.17139176,0.47666666,0.17139176,0.48,0.17139176,0.48333332,0.17139176,0.48666668,0.17139176,0.49,0.17139176,0.49333334,0.17139176,0.49666667,0.17139176,0.5,0.17139176,0.50333333,0.17139176,0.50666666,0.17139176,0.51,0.17139176,0.5133333,0.17139176,0.51666665,0.17139176,0.52,0.17139176,0.5233333,0.17139176,0.52666664,0.17139176,0.53,0.17139176,0.53333336,0.17139176,0.5366667,0.17139176,0.54,0.17139176,0.54333335,0.17139176,0.5466667,0.17139176,0.55,0.17139176,0.55333334,0.17139176,0.5566667,0.17139176,0.56,0.17139176,0.56333333,0.17139176,0.56666666,0.17139176,0.57,0.17139176,0.5733333,0.17139176,0.57666665,0.17139176,0.58,0.17139176,0.5833333,0.17139176,0.58666664,0.17139176,0.59,0.17139176,0.5933333,0.17139176,0.5966667,0.17139176,0.6,0.17139176,0.60333335,0.17139176,0.6066667,0.17139176,0.61,0.17139176,0.61333334,0.17139176,0.6166667,0.17139176,0.62,0.17139176,0.62333333,0.17139176,0.62666667,0.17139176,0.63,0.17139176,0.6333333,0.17139176,0.63666666,0.17139176,0.64,0.17139176,0.6433333,0.17139176,0.64666665,0.17139176,0.65,0.17139176,0.6533333,0.17139176,0.6566667,0.17139176,0.66,0.17139176,0.66333336,0.17139176,0.6666667,0.17139176,0.67,0.17139176,0.67333335,0.17139176,0.6766667,0.17139176,0.68,0.17139176,0.68333334,0.17139176,0.68666667,0.17139176,0.69,0.17139176,0.6933333,0.17139176,0.69666666,0.17139176,0.7,0.17139176,0.7033333,0.17139176,0.70666665,0.17139176,0.71,0.17139176,0.7133333,0.17139176,0.71666664,0.17139176,0.72,0.17139176,0.72333336,0.17139176,0.7266667,0.17139176,0.73,0.17139176,0.73333335,0.17139176,0.7366667,0.17139176,0.74,0.17139176,0.74333334,0.17139176,0.74666667,0.17139176,0.75,0.17139176,0.75333333,0.17139176,0.75666666,0.17139176,0.76,0.17139176,0.7633333,0.17139176,0.76666665,0.17139176,0.77,0.17139176,0.7733333,0.17139176,0.77666664,0.17139176,0.78,0.17139176,0.78333336,0.17139176,0.7866667,0.17139176,0.79,0.17139176,0.79333335,0.17139176,0.7966667,0.17139176,0.8,0.17139176,0.80333334,0.17139176,0.8066667,0.17139176,0.81,0.17139176,0.81333333,0.17139176,0.81666666,0.17139176,0.82,0.17139176,0.8233333,0.17139176,0.82666665,0.17139176,0.83,0.17139176,0.8333333,0.17139176,0.83666664,0.17139176,0.84,0.17139176,0.8433333,0.17139176,0.8466667,0.17139176,0.85,0.17139176,0.85333335,0.17139176,0.8566667,0.17139176,0.86,0.17139176,0.86333334,0.17139176,0.8666667,0.17139176,0.87,0.17139176,0.87333333,0.17139176,0.87666667,0.17139176,0.88,0.17139176,0.8833333,0.17139176,0.88666666,0.17139176,0.89,0.17139176,0.8933333,0.17139176,0.89666665,0.17139176,0.9,0.17139176,0.9033333,0.17139176,0.9066667,0.17139176,0.91,0.17139176,0.91333336,0.17139176,0.9166667,0.17139176,0.92,0.17139176,0.92333335,0.17139176,0.9266667,0.17139176,0.93,0.17139176,0.93333334,0.17139176,0.93666667,0.17139176,0.94,0.17139176,0.9433333,0.17139176,0.94666666,0.17139176,0.05,0.17396908,0.053333335,0.17396908,0.05666667,0.17396908,0.06,0.17396908,0.06333333,0.17396908,0.06666667,0.17396908,0.07,0.17396908,0.07333333,0.17396908,0.07666667,0.17396908,0.08,0.17396908,0.083333336,0.17396908,0.086666666,0.17396908,0.09,0.17396908,0.093333334,0.17396908,0.096666664,0.17396908,0.1,0.17396908,0.10333333,0.17396908,0.10666667,0.17396908,0.11,0.17396908,0.11333334,0.17396908,0.11666667,0.17396908,0.12,0.17396908,0.123333335,0.17396908,0.12666667,0.17396908,0.13,0.17396908,0.13333334,0.17396908,0.13666667,0.17396908,0.14,0.17396908,0.14333333,0.17396908,0.14666666,0.17396908,0.15,0.17396908,0.15333334,0.17396908,0.15666667,0.17396908,0.16,0.17396908,0.16333333,0.17396908,0.16666667,0.17396908,0.17,0.17396908,0.17333333,0.17396908,0.17666666,0.17396908,0.18,0.17396908,0.18333334,0.17396908,0.18666667,0.17396908,0.19,0.17396908,0.19333333,0.17396908,0.19666667,0.17396908,0.2,0.17396908,0.20333333,0.17396908,0.20666666,0.17396908,0.21,0.17396908,0.21333334,0.17396908,0.21666667,0.17396908,0.22,0.17396908,0.22333333,0.17396908,0.22666667,0.17396908,0.23,0.17396908,0.23333333,0.17396908,0.23666666,0.17396908,0.24,0.17396908,0.24333334,0.17396908,0.24666667,0.17396908,0.25,0.17396908,0.25333333,0.17396908,0.25666666,0.17396908,0.26,0.17396908,0.26333332,0.17396908,0.26666668,0.17396908,0.27,0.17396908,0.27333334,0.17396908,0.27666667,0.17396908,0.28,0.17396908,0.28333333,0.17396908,0.28666666,0.17396908,0.29,0.17396908,0.29333332,0.17396908,0.29666665,0.17396908,0.3,0.17396908,0.30333334,0.17396908,0.30666667,0.17396908,0.31,0.17396908,0.31333333,0.17396908,0.31666666,0.17396908,0.32,0.17396908,0.32333332,0.17396908,0.32666665,0.17396908,0.33,0.17396908,0.33333334,0.17396908,0.33666667,0.17396908,0.34,0.17396908,0.34333333,0.17396908,0.34666666,0.17396908,0.35,0.17396908,0.35333332,0.17396908,0.35666665,0.17396908,0.36,0.17396908,0.36333334,0.17396908,0.36666667,0.17396908,0.37,0.17396908,0.37333333,0.17396908,0.37666667,0.17396908,0.38,0.17396908,0.38333333,0.17396908,0.38666666,0.17396908,0.39,0.17396908,0.39333335,0.17396908,0.39666668,0.17396908,0.4,0.17396908,0.40333334,0.17396908,0.40666667,0.17396908,0.41,0.17396908,0.41333333,0.17396908,0.41666666,0.17396908,0.42,0.17396908,0.42333335,0.17396908,0.42666668,0.17396908,0.43,0.17396908,0.43333334,0.17396908,0.43666667,0.17396908,0.44,0.17396908,0.44333333,0.17396908,0.44666666,0.17396908,0.45,0.17396908,0.45333335,0.17396908,0.45666668,0.17396908,0.46,0.17396908,0.46333334,0.17396908,0.46666667,0.17396908,0.47,0.17396908,0.47333333,0.17396908,0.47666666,0.17396908,0.48,0.17396908,0.48333332,0.17396908,0.48666668,0.17396908,0.49,0.17396908,0.49333334,0.17396908,0.49666667,0.17396908,0.5,0.17396908,0.50333333,0.17396908,0.50666666,0.17396908,0.51,0.17396908,0.5133333,0.17396908,0.51666665,0.17396908,0.52,0.17396908,0.5233333,0.17396908,0.52666664,0.17396908,0.53,0.17396908,0.53333336,0.17396908,0.5366667,0.17396908,0.54,0.17396908,0.54333335,0.17396908,0.5466667,0.17396908,0.55,0.17396908,0.55333334,0.17396908,0.5566667,0.17396908,0.56,0.17396908,0.56333333,0.17396908,0.56666666,0.17396908,0.57,0.17396908,0.5733333,0.17396908,0.57666665,0.17396908,0.58,0.17396908,0.5833333,0.17396908,0.58666664,0.17396908,0.59,0.17396908,0.5933333,0.17396908,0.5966667,0.17396908,0.6,0.17396908,0.60333335,0.17396908,0.6066667,0.17396908,0.61,0.17396908,0.61333334,0.17396908,0.6166667,0.17396908,0.62,0.17396908,0.62333333,0.17396908,0.62666667,0.17396908,0.63,0.17396908,0.6333333,0.17396908,0.63666666,0.17396908,0.64,0.17396908,0.6433333,0.17396908,0.64666665,0.17396908,0.65,0.17396908,0.6533333,0.17396908,0.6566667,0.17396908,0.66,0.17396908,0.66333336,0.17396908,0.6666667,0.17396908,0.67,0.17396908,0.67333335,0.17396908,0.6766667,0.17396908,0.68,0.17396908,0.68333334,0.17396908,0.68666667,0.17396908,0.69,0.17396908,0.6933333,0.17396908,0.69666666,0.17396908,0.7,0.17396908,0.7033333,0.17396908,0.70666665,0.17396908,0.71,0.17396908,0.7133333,0.17396908,0.71666664,0.17396908,0.72,0.17396908,0.72333336,0.17396908,0.7266667,0.17396908,0.73,0.17396908,0.73333335,0.17396908,0.7366667,0.17396908,0.74,0.17396908,0.74333334,0.17396908,0.74666667,0.17396908,0.75,0.17396908,0.75333333,0.17396908,0.75666666,0.17396908,0.76,0.17396908,0.7633333,0.17396908,0.76666665,0.17396908,0.77,0.17396908,0.7733333,0.17396908,0.77666664,0.17396908,0.78,0.17396908,0.78333336,0.17396908,0.7866667,0.17396908,0.79,0.17396908,0.79333335,0.17396908,0.7966667,0.17396908,0.8,0.17396908,0.80333334,0.17396908,0.8066667,0.17396908,0.81,0.17396908,0.81333333,0.17396908,0.81666666,0.17396908,0.82,0.17396908,0.8233333,0.17396908,0.82666665,0.17396908,0.83,0.17396908,0.8333333,0.17396908,0.83666664,0.17396908,0.84,0.17396908,0.8433333,0.17396908,0.8466667,0.17396908,0.85,0.17396908,0.85333335,0.17396908,0.8566667,0.17396908,0.86,0.17396908,0.86333334,0.17396908,0.8666667,0.17396908,0.87666667,0.17396908,0.88,0.17396908,0.9,0.17396908,0.9033333,0.17396908,0.9066667,0.17396908,0.91,0.17396908,0.91333336,0.17396908,0.9166667,0.17396908,0.92,0.17396908,0.92333335,0.17396908,0.9266667,0.17396908,0.93,0.17396908,0.93333334,0.17396908,0.93666667,0.17396908,0.94,0.17396908,0.9433333,0.17396908,0.94666666,0.17396908,0.05,0.1765464,0.053333335,0.1765464,0.05666667,0.1765464,0.06,0.1765464,0.06333333,0.1765464,0.06666667,0.1765464,0.07,0.1765464,0.07333333,0.1765464,0.07666667,0.1765464,0.08,0.1765464,0.083333336,0.1765464,0.086666666,0.1765464,0.09,0.1765464,0.093333334,0.1765464,0.096666664,0.1765464,0.1,0.1765464,0.10333333,0.1765464,0.10666667,0.1765464,0.11,0.1765464,0.11333334,0.1765464,0.11666667,0.1765464,0.12,0.1765464,0.123333335,0.1765464,0.12666667,0.1765464,0.13,0.1765464,0.13333334,0.1765464,0.13666667,0.1765464,0.14,0.1765464,0.14333333,0.1765464,0.14666666,0.1765464,0.15,0.1765464,0.15333334,0.1765464,0.15666667,0.1765464,0.16,0.1765464,0.16333333,0.1765464,0.16666667,0.1765464,0.17,0.1765464,0.17333333,0.1765464,0.17666666,0.1765464,0.18,0.1765464,0.18333334,0.1765464,0.18666667,0.1765464,0.19,0.1765464,0.19333333,0.1765464,0.19666667,0.1765464,0.2,0.1765464,0.20333333,0.1765464,0.20666666,0.1765464,0.21,0.1765464,0.21333334,0.1765464,0.21666667,0.1765464,0.22,0.1765464,0.22333333,0.1765464,0.22666667,0.1765464,0.23,0.1765464,0.23333333,0.1765464,0.23666666,0.1765464,0.24,0.1765464,0.24333334,0.1765464,0.24666667,0.1765464,0.25,0.1765464,0.25333333,0.1765464,0.25666666,0.1765464,0.26,0.1765464,0.26333332,0.1765464,0.26666668,0.1765464,0.27,0.1765464,0.27333334,0.1765464,0.27666667,0.1765464,0.28,0.1765464,0.28333333,0.1765464,0.28666666,0.1765464,0.29,0.1765464,0.29333332,0.1765464,0.29666665,0.1765464,0.3,0.1765464,0.30333334,0.1765464,0.30666667,0.1765464,0.31,0.1765464,0.31333333,0.1765464,0.31666666,0.1765464,0.32,0.1765464,0.32333332,0.1765464,0.32666665,0.1765464,0.33,0.1765464,0.33333334,0.1765464,0.33666667,0.1765464,0.34,0.1765464,0.34333333,0.1765464,0.34666666,0.1765464,0.35,0.1765464,0.35333332,0.1765464,0.35666665,0.1765464,0.36,0.1765464,0.36333334,0.1765464,0.36666667,0.1765464,0.37,0.1765464,0.37333333,0.1765464,0.37666667,0.1765464,0.38,0.1765464,0.38333333,0.1765464,0.38666666,0.1765464,0.39,0.1765464,0.39333335,0.1765464,0.39666668,0.1765464,0.4,0.1765464,0.40333334,0.1765464,0.40666667,0.1765464,0.41,0.1765464,0.41333333,0.1765464,0.41666666,0.1765464,0.42,0.1765464,0.42333335,0.1765464,0.42666668,0.1765464,0.43,0.1765464,0.43333334,0.1765464,0.43666667,0.1765464,0.44,0.1765464,0.44333333,0.1765464,0.44666666,0.1765464,0.45,0.1765464,0.45333335,0.1765464,0.45666668,0.1765464,0.46,0.1765464,0.46333334,0.1765464,0.46666667,0.1765464,0.47,0.1765464,0.47333333,0.1765464,0.47666666,0.1765464,0.48,0.1765464,0.48333332,0.1765464,0.48666668,0.1765464,0.49,0.1765464,0.49333334,0.1765464,0.49666667,0.1765464,0.5,0.1765464,0.50333333,0.1765464,0.50666666,0.1765464,0.51,0.1765464,0.5133333,0.1765464,0.51666665,0.1765464,0.52,0.1765464,0.5233333,0.1765464,0.52666664,0.1765464,0.53,0.1765464,0.53333336,0.1765464,0.5366667,0.1765464,0.54,0.1765464,0.54333335,0.1765464,0.5466667,0.1765464,0.55,0.1765464,0.55333334,0.1765464,0.5566667,0.1765464,0.56,0.1765464,0.56333333,0.1765464,0.56666666,0.1765464,0.57,0.1765464,0.5733333,0.1765464,0.57666665,0.1765464,0.58,0.1765464,0.5833333,0.1765464,0.58666664,0.1765464,0.59,0.1765464,0.5933333,0.1765464,0.5966667,0.1765464,0.6,0.1765464,0.60333335,0.1765464,0.6066667,0.1765464,0.61,0.1765464,0.61333334,0.1765464,0.6166667,0.1765464,0.62,0.1765464,0.62333333,0.1765464,0.62666667,0.1765464,0.63,0.1765464,0.6333333,0.1765464,0.63666666,0.1765464,0.64,0.1765464,0.6433333,0.1765464,0.64666665,0.1765464,0.65,0.1765464,0.6533333,0.1765464,0.6566667,0.1765464,0.66,0.1765464,0.66333336,0.1765464,0.6666667,0.1765464,0.67,0.1765464,0.67333335,0.1765464,0.6766667,0.1765464,0.68,0.1765464,0.68333334,0.1765464,0.68666667,0.1765464,0.69,0.1765464,0.6933333,0.1765464,0.69666666,0.1765464,0.7,0.1765464,0.7033333,0.1765464,0.70666665,0.1765464,0.71,0.1765464,0.7133333,0.1765464,0.71666664,0.1765464,0.72,0.1765464,0.72333336,0.1765464,0.7266667,0.1765464,0.73,0.1765464,0.73333335,0.1765464,0.7366667,0.1765464,0.74,0.1765464,0.74333334,0.1765464,0.74666667,0.1765464,0.75,0.1765464,0.75333333,0.1765464,0.75666666,0.1765464,0.76,0.1765464,0.7633333,0.1765464,0.76666665,0.1765464,0.77,0.1765464,0.7733333,0.1765464,0.77666664,0.1765464,0.78,0.1765464,0.78333336,0.1765464,0.7866667,0.1765464,0.79,0.1765464,0.79333335,0.1765464,0.7966667,0.1765464,0.8,0.1765464,0.80333334,0.1765464,0.8066667,0.1765464,0.81,0.1765464,0.81333333,0.1765464,0.81666666,0.1765464,0.82,0.1765464,0.8233333,0.1765464,0.82666665,0.1765464,0.83,0.1765464,0.8333333,0.1765464,0.83666664,0.1765464,0.84,0.1765464,0.8433333,0.1765464,0.8466667,0.1765464,0.85,0.1765464,0.85333335,0.1765464,0.8566667,0.1765464,0.86333334,0.1765464,0.8666667,0.1765464,0.87,0.1765464,0.87333333,0.1765464,0.87666667,0.1765464,0.88,0.1765464,0.8833333,0.1765464,0.88666666,0.1765464,0.89,0.1765464,0.8933333,0.1765464,0.89666665,0.1765464,0.9,0.1765464,0.9033333,0.1765464,0.9066667,0.1765464,0.91,0.1765464,0.91333336,0.1765464,0.9166667,0.1765464,0.92,0.1765464,0.92333335,0.1765464,0.9266667,0.1765464,0.93,0.1765464,0.93333334,0.1765464,0.93666667,0.1765464,0.94,0.1765464,0.9433333,0.1765464,0.94666666,0.1765464,0.05,0.17912371,0.053333335,0.17912371,0.05666667,0.17912371,0.06,0.17912371,0.06333333,0.17912371,0.06666667,0.17912371,0.07,0.17912371,0.07333333,0.17912371,0.07666667,0.17912371,0.08,0.17912371,0.083333336,0.17912371,0.086666666,0.17912371,0.09,0.17912371,0.093333334,0.17912371,0.096666664,0.17912371,0.1,0.17912371,0.10333333,0.17912371,0.10666667,0.17912371,0.11,0.17912371,0.11333334,0.17912371,0.11666667,0.17912371,0.12,0.17912371,0.123333335,0.17912371,0.12666667,0.17912371,0.13,0.17912371,0.13333334,0.17912371,0.13666667,0.17912371,0.14,0.17912371,0.14333333,0.17912371,0.14666666,0.17912371,0.15,0.17912371,0.15333334,0.17912371,0.15666667,0.17912371,0.16,0.17912371,0.16333333,0.17912371,0.16666667,0.17912371,0.17,0.17912371,0.17333333,0.17912371,0.17666666,0.17912371,0.18,0.17912371,0.18333334,0.17912371,0.18666667,0.17912371,0.19,0.17912371,0.19333333,0.17912371,0.19666667,0.17912371,0.2,0.17912371,0.20333333,0.17912371,0.20666666,0.17912371,0.21,0.17912371,0.21333334,0.17912371,0.21666667,0.17912371,0.22,0.17912371,0.22333333,0.17912371,0.22666667,0.17912371,0.23,0.17912371,0.23333333,0.17912371,0.23666666,0.17912371,0.24,0.17912371,0.24333334,0.17912371,0.24666667,0.17912371,0.25,0.17912371,0.25333333,0.17912371,0.25666666,0.17912371,0.26,0.17912371,0.26333332,0.17912371,0.26666668,0.17912371,0.27,0.17912371,0.27333334,0.17912371,0.27666667,0.17912371,0.28,0.17912371,0.28333333,0.17912371,0.28666666,0.17912371,0.29,0.17912371,0.29333332,0.17912371,0.29666665,0.17912371,0.3,0.17912371,0.30333334,0.17912371,0.30666667,0.17912371,0.31,0.17912371,0.31333333,0.17912371,0.31666666,0.17912371,0.32,0.17912371,0.32333332,0.17912371,0.32666665,0.17912371,0.33,0.17912371,0.33333334,0.17912371,0.33666667,0.17912371,0.34,0.17912371,0.34333333,0.17912371,0.34666666,0.17912371,0.35,0.17912371,0.35333332,0.17912371,0.35666665,0.17912371,0.36,0.17912371,0.36333334,0.17912371,0.36666667,0.17912371,0.37,0.17912371,0.37333333,0.17912371,0.37666667,0.17912371,0.38,0.17912371,0.38333333,0.17912371,0.38666666,0.17912371,0.39,0.17912371,0.39333335,0.17912371,0.39666668,0.17912371,0.4,0.17912371,0.40333334,0.17912371,0.40666667,0.17912371,0.41,0.17912371,0.41333333,0.17912371,0.41666666,0.17912371,0.42,0.17912371,0.42333335,0.17912371,0.42666668,0.17912371,0.43,0.17912371,0.43333334,0.17912371,0.43666667,0.17912371,0.44,0.17912371,0.44333333,0.17912371,0.44666666,0.17912371,0.45,0.17912371,0.45333335,0.17912371,0.45666668,0.17912371,0.46,0.17912371,0.46333334,0.17912371,0.46666667,0.17912371,0.47,0.17912371,0.47333333,0.17912371,0.47666666,0.17912371,0.48,0.17912371,0.48333332,0.17912371,0.48666668,0.17912371,0.49,0.17912371,0.49333334,0.17912371,0.49666667,0.17912371,0.5,0.17912371,0.50333333,0.17912371,0.50666666,0.17912371,0.51,0.17912371,0.5133333,0.17912371,0.51666665,0.17912371,0.52,0.17912371,0.5233333,0.17912371,0.52666664,0.17912371,0.53,0.17912371,0.53333336,0.17912371,0.5366667,0.17912371,0.54,0.17912371,0.54333335,0.17912371,0.5466667,0.17912371,0.55,0.17912371,0.55333334,0.17912371,0.5566667,0.17912371,0.56,0.17912371,0.56333333,0.17912371,0.56666666,0.17912371,0.57,0.17912371,0.5733333,0.17912371,0.57666665,0.17912371,0.58,0.17912371,0.5833333,0.17912371,0.58666664,0.17912371,0.59,0.17912371,0.5933333,0.17912371,0.5966667,0.17912371,0.6,0.17912371,0.60333335,0.17912371,0.6066667,0.17912371,0.61,0.17912371,0.61333334,0.17912371,0.6166667,0.17912371,0.62,0.17912371,0.62333333,0.17912371,0.62666667,0.17912371,0.63,0.17912371,0.6333333,0.17912371,0.63666666,0.17912371,0.64,0.17912371,0.6433333,0.17912371,0.64666665,0.17912371,0.65,0.17912371,0.6533333,0.17912371,0.6566667,0.17912371,0.66,0.17912371,0.66333336,0.17912371,0.6666667,0.17912371,0.67,0.17912371,0.67333335,0.17912371,0.6766667,0.17912371,0.68,0.17912371,0.68333334,0.17912371,0.68666667,0.17912371,0.69,0.17912371,0.6933333,0.17912371,0.69666666,0.17912371,0.7,0.17912371,0.7033333,0.17912371,0.70666665,0.17912371,0.71,0.17912371,0.7133333,0.17912371,0.71666664,0.17912371,0.72,0.17912371,0.72333336,0.17912371,0.7266667,0.17912371,0.73,0.17912371,0.73333335,0.17912371,0.7366667,0.17912371,0.74,0.17912371,0.74333334,0.17912371,0.74666667,0.17912371,0.75,0.17912371,0.75333333,0.17912371,0.75666666,0.17912371,0.76,0.17912371,0.7633333,0.17912371,0.76666665,0.17912371,0.77,0.17912371,0.7733333,0.17912371,0.77666664,0.17912371,0.78,0.17912371,0.78333336,0.17912371,0.7866667,0.17912371,0.79,0.17912371,0.79333335,0.17912371,0.7966667,0.17912371,0.8,0.17912371,0.80333334,0.17912371,0.8066667,0.17912371,0.81,0.17912371,0.81333333,0.17912371,0.81666666,0.17912371,0.82,0.17912371,0.8233333,0.17912371,0.82666665,0.17912371,0.83,0.17912371,0.8333333,0.17912371,0.83666664,0.17912371,0.84,0.17912371,0.8433333,0.17912371,0.8466667,0.17912371,0.85,0.17912371,0.85333335,0.17912371,0.86,0.17912371,0.86333334,0.17912371,0.8666667,0.17912371,0.87,0.17912371,0.87333333,0.17912371,0.87666667,0.17912371,0.88,0.17912371,0.8833333,0.17912371,0.88666666,0.17912371,0.89,0.17912371,0.8933333,0.17912371,0.89666665,0.17912371,0.9,0.17912371,0.9033333,0.17912371,0.9066667,0.17912371,0.91,0.17912371,0.91333336,0.17912371,0.9166667,0.17912371,0.92,0.17912371,0.92333335,0.17912371,0.9266667,0.17912371,0.93,0.17912371,0.93333334,0.17912371,0.93666667,0.17912371,0.94,0.17912371,0.9433333,0.17912371,0.94666666,0.17912371,0.05,0.18170103,0.053333335,0.18170103,0.05666667,0.18170103,0.06,0.18170103,0.06333333,0.18170103,0.06666667,0.18170103,0.07,0.18170103,0.07333333,0.18170103,0.07666667,0.18170103,0.08,0.18170103,0.083333336,0.18170103,0.086666666,0.18170103,0.09,0.18170103,0.093333334,0.18170103,0.096666664,0.18170103,0.1,0.18170103,0.10333333,0.18170103,0.10666667,0.18170103,0.11,0.18170103,0.11333334,0.18170103,0.11666667,0.18170103,0.12,0.18170103,0.123333335,0.18170103,0.12666667,0.18170103,0.13,0.18170103,0.13333334,0.18170103,0.13666667,0.18170103,0.14,0.18170103,0.14333333,0.18170103,0.14666666,0.18170103,0.15,0.18170103,0.15333334,0.18170103,0.15666667,0.18170103,0.16,0.18170103,0.16333333,0.18170103,0.16666667,0.18170103,0.17,0.18170103,0.17333333,0.18170103,0.17666666,0.18170103,0.18,0.18170103,0.18333334,0.18170103,0.18666667,0.18170103,0.19,0.18170103,0.19333333,0.18170103,0.19666667,0.18170103,0.2,0.18170103,0.20333333,0.18170103,0.20666666,0.18170103,0.21,0.18170103,0.21333334,0.18170103,0.21666667,0.18170103,0.22,0.18170103,0.22333333,0.18170103,0.22666667,0.18170103,0.23,0.18170103,0.23333333,0.18170103,0.23666666,0.18170103,0.24,0.18170103,0.24333334,0.18170103,0.24666667,0.18170103,0.25,0.18170103,0.25333333,0.18170103,0.25666666,0.18170103,0.26,0.18170103,0.26333332,0.18170103,0.26666668,0.18170103,0.27,0.18170103,0.27333334,0.18170103,0.27666667,0.18170103,0.28,0.18170103,0.28333333,0.18170103,0.28666666,0.18170103,0.29,0.18170103,0.29333332,0.18170103,0.29666665,0.18170103,0.3,0.18170103,0.30333334,0.18170103,0.30666667,0.18170103,0.31,0.18170103,0.31333333,0.18170103,0.31666666,0.18170103,0.32,0.18170103,0.32333332,0.18170103,0.32666665,0.18170103,0.33,0.18170103,0.33333334,0.18170103,0.33666667,0.18170103,0.34,0.18170103,0.34333333,0.18170103,0.34666666,0.18170103,0.35,0.18170103,0.35333332,0.18170103,0.35666665,0.18170103,0.36,0.18170103,0.36333334,0.18170103,0.36666667,0.18170103,0.37,0.18170103,0.37333333,0.18170103,0.37666667,0.18170103,0.38,0.18170103,0.38333333,0.18170103,0.38666666,0.18170103,0.39,0.18170103,0.39333335,0.18170103,0.39666668,0.18170103,0.4,0.18170103,0.40333334,0.18170103,0.40666667,0.18170103,0.41,0.18170103,0.41333333,0.18170103,0.41666666,0.18170103,0.42,0.18170103,0.42333335,0.18170103,0.42666668,0.18170103,0.43,0.18170103,0.43333334,0.18170103,0.43666667,0.18170103,0.44,0.18170103,0.44333333,0.18170103,0.44666666,0.18170103,0.45,0.18170103,0.45333335,0.18170103,0.45666668,0.18170103,0.46,0.18170103,0.46333334,0.18170103,0.46666667,0.18170103,0.47,0.18170103,0.47333333,0.18170103,0.47666666,0.18170103,0.48,0.18170103,0.48333332,0.18170103,0.48666668,0.18170103,0.49,0.18170103,0.49333334,0.18170103,0.49666667,0.18170103,0.5,0.18170103,0.50333333,0.18170103,0.50666666,0.18170103,0.51,0.18170103,0.5133333,0.18170103,0.51666665,0.18170103,0.52,0.18170103,0.5233333,0.18170103,0.52666664,0.18170103,0.53,0.18170103,0.53333336,0.18170103,0.5366667,0.18170103,0.54,0.18170103,0.54333335,0.18170103,0.5466667,0.18170103,0.55,0.18170103,0.55333334,0.18170103,0.5566667,0.18170103,0.56,0.18170103,0.56333333,0.18170103,0.56666666,0.18170103,0.57,0.18170103,0.5733333,0.18170103,0.57666665,0.18170103,0.58,0.18170103,0.5833333,0.18170103,0.58666664,0.18170103,0.59,0.18170103,0.5933333,0.18170103,0.5966667,0.18170103,0.6,0.18170103,0.60333335,0.18170103,0.6066667,0.18170103,0.61,0.18170103,0.61333334,0.18170103,0.6166667,0.18170103,0.62,0.18170103,0.62333333,0.18170103,0.62666667,0.18170103,0.63,0.18170103,0.6333333,0.18170103,0.63666666,0.18170103,0.64,0.18170103,0.6433333,0.18170103,0.64666665,0.18170103,0.65,0.18170103,0.6533333,0.18170103,0.6566667,0.18170103,0.66,0.18170103,0.66333336,0.18170103,0.6666667,0.18170103,0.67,0.18170103,0.67333335,0.18170103,0.6766667,0.18170103,0.68,0.18170103,0.68333334,0.18170103,0.68666667,0.18170103,0.69,0.18170103,0.6933333,0.18170103,0.69666666,0.18170103,0.7,0.18170103,0.7033333,0.18170103,0.70666665,0.18170103,0.71,0.18170103,0.7133333,0.18170103,0.71666664,0.18170103,0.72,0.18170103,0.72333336,0.18170103,0.7266667,0.18170103,0.73,0.18170103,0.73333335,0.18170103,0.7366667,0.18170103,0.74,0.18170103,0.74333334,0.18170103,0.74666667,0.18170103,0.75,0.18170103,0.75333333,0.18170103,0.75666666,0.18170103,0.76,0.18170103,0.7633333,0.18170103,0.76666665,0.18170103,0.77,0.18170103,0.7733333,0.18170103,0.77666664,0.18170103,0.78,0.18170103,0.78333336,0.18170103,0.7866667,0.18170103,0.79,0.18170103,0.79333335,0.18170103,0.7966667,0.18170103,0.8,0.18170103,0.80333334,0.18170103,0.8066667,0.18170103,0.81,0.18170103,0.81333333,0.18170103,0.81666666,0.18170103,0.82,0.18170103,0.8233333,0.18170103,0.82666665,0.18170103,0.83,0.18170103,0.8333333,0.18170103,0.83666664,0.18170103,0.84,0.18170103,0.8433333,0.18170103,0.8466667,0.18170103,0.85,0.18170103,0.85333335,0.18170103,0.8566667,0.18170103,0.86,0.18170103,0.86333334,0.18170103,0.8666667,0.18170103,0.87,0.18170103,0.87333333,0.18170103,0.87666667,0.18170103,0.88,0.18170103,0.8833333,0.18170103,0.88666666,0.18170103,0.89,0.18170103,0.8933333,0.18170103,0.89666665,0.18170103,0.9,0.18170103,0.9033333,0.18170103,0.9066667,0.18170103,0.91,0.18170103,0.91333336,0.18170103,0.9166667,0.18170103,0.92,0.18170103,0.92333335,0.18170103,0.9266667,0.18170103,0.93,0.18170103,0.93333334,0.18170103,0.93666667,0.18170103,0.94,0.18170103,0.9433333,0.18170103,0.94666666,0.18170103,0.05,0.18427835,0.053333335,0.18427835,0.05666667,0.18427835,0.06,0.18427835,0.06333333,0.18427835,0.06666667,0.18427835,0.07,0.18427835,0.07333333,0.18427835,0.07666667,0.18427835,0.08,0.18427835,0.083333336,0.18427835,0.086666666,0.18427835,0.09,0.18427835,0.093333334,0.18427835,0.096666664,0.18427835,0.1,0.18427835,0.10333333,0.18427835,0.10666667,0.18427835,0.11,0.18427835,0.11333334,0.18427835,0.11666667,0.18427835,0.12,0.18427835,0.123333335,0.18427835,0.12666667,0.18427835,0.13,0.18427835,0.13333334,0.18427835,0.13666667,0.18427835,0.14,0.18427835,0.14333333,0.18427835,0.14666666,0.18427835,0.15,0.18427835,0.15333334,0.18427835,0.15666667,0.18427835,0.16,0.18427835,0.16333333,0.18427835,0.16666667,0.18427835,0.17,0.18427835,0.17333333,0.18427835,0.17666666,0.18427835,0.18,0.18427835,0.18333334,0.18427835,0.18666667,0.18427835,0.19,0.18427835,0.19333333,0.18427835,0.19666667,0.18427835,0.2,0.18427835,0.20333333,0.18427835,0.20666666,0.18427835,0.21,0.18427835,0.21333334,0.18427835,0.21666667,0.18427835,0.22,0.18427835,0.22333333,0.18427835,0.22666667,0.18427835,0.23,0.18427835,0.23333333,0.18427835,0.23666666,0.18427835,0.24,0.18427835,0.24333334,0.18427835,0.24666667,0.18427835,0.25,0.18427835,0.25333333,0.18427835,0.25666666,0.18427835,0.26,0.18427835,0.26333332,0.18427835,0.26666668,0.18427835,0.27,0.18427835,0.27333334,0.18427835,0.27666667,0.18427835,0.28,0.18427835,0.28333333,0.18427835,0.28666666,0.18427835,0.29,0.18427835,0.29333332,0.18427835,0.29666665,0.18427835,0.3,0.18427835,0.30333334,0.18427835,0.30666667,0.18427835,0.31,0.18427835,0.31333333,0.18427835,0.31666666,0.18427835,0.32,0.18427835,0.32333332,0.18427835,0.32666665,0.18427835,0.33,0.18427835,0.33333334,0.18427835,0.33666667,0.18427835,0.34,0.18427835,0.34333333,0.18427835,0.34666666,0.18427835,0.35,0.18427835,0.35333332,0.18427835,0.35666665,0.18427835,0.36,0.18427835,0.36333334,0.18427835,0.36666667,0.18427835,0.37,0.18427835,0.37333333,0.18427835,0.37666667,0.18427835,0.38,0.18427835,0.38333333,0.18427835,0.38666666,0.18427835,0.39,0.18427835,0.39333335,0.18427835,0.39666668,0.18427835,0.4,0.18427835,0.40333334,0.18427835,0.40666667,0.18427835,0.41,0.18427835,0.41333333,0.18427835,0.41666666,0.18427835,0.42,0.18427835,0.42333335,0.18427835,0.42666668,0.18427835,0.43,0.18427835,0.43333334,0.18427835,0.43666667,0.18427835,0.44,0.18427835,0.44333333,0.18427835,0.44666666,0.18427835,0.45,0.18427835,0.45333335,0.18427835,0.45666668,0.18427835,0.46,0.18427835,0.46333334,0.18427835,0.46666667,0.18427835,0.47,0.18427835,0.47333333,0.18427835,0.47666666,0.18427835,0.48,0.18427835,0.48333332,0.18427835,0.48666668,0.18427835,0.49,0.18427835,0.49333334,0.18427835,0.49666667,0.18427835,0.5,0.18427835,0.50333333,0.18427835,0.50666666,0.18427835,0.51,0.18427835,0.5133333,0.18427835,0.51666665,0.18427835,0.52,0.18427835,0.5233333,0.18427835,0.52666664,0.18427835,0.53,0.18427835,0.53333336,0.18427835,0.5366667,0.18427835,0.54,0.18427835,0.54333335,0.18427835,0.5466667,0.18427835,0.55,0.18427835,0.55333334,0.18427835,0.5566667,0.18427835,0.56,0.18427835,0.56333333,0.18427835,0.56666666,0.18427835,0.57,0.18427835,0.5733333,0.18427835,0.57666665,0.18427835,0.58,0.18427835,0.5833333,0.18427835,0.58666664,0.18427835,0.59,0.18427835,0.5933333,0.18427835,0.5966667,0.18427835,0.6,0.18427835,0.60333335,0.18427835,0.6066667,0.18427835,0.61,0.18427835,0.61333334,0.18427835,0.6166667,0.18427835,0.62,0.18427835,0.62333333,0.18427835,0.62666667,0.18427835,0.63,0.18427835,0.6333333,0.18427835,0.63666666,0.18427835,0.64,0.18427835,0.6433333,0.18427835,0.64666665,0.18427835,0.65,0.18427835,0.6533333,0.18427835,0.6566667,0.18427835,0.66,0.18427835,0.66333336,0.18427835,0.6666667,0.18427835,0.67,0.18427835,0.67333335,0.18427835,0.6766667,0.18427835,0.68,0.18427835,0.68333334,0.18427835,0.68666667,0.18427835,0.69,0.18427835,0.6933333,0.18427835,0.69666666,0.18427835,0.7,0.18427835,0.7033333,0.18427835,0.70666665,0.18427835,0.71,0.18427835,0.7133333,0.18427835,0.71666664,0.18427835,0.72,0.18427835,0.72333336,0.18427835,0.7266667,0.18427835,0.73,0.18427835,0.73333335,0.18427835,0.7366667,0.18427835,0.74,0.18427835,0.74333334,0.18427835,0.74666667,0.18427835,0.75,0.18427835,0.75333333,0.18427835,0.75666666,0.18427835,0.76,0.18427835,0.7633333,0.18427835,0.76666665,0.18427835,0.77,0.18427835,0.7733333,0.18427835,0.77666664,0.18427835,0.78,0.18427835,0.78333336,0.18427835,0.7866667,0.18427835,0.79,0.18427835,0.79333335,0.18427835,0.7966667,0.18427835,0.8,0.18427835,0.80333334,0.18427835,0.8066667,0.18427835,0.81,0.18427835,0.81333333,0.18427835,0.81666666,0.18427835,0.82,0.18427835,0.8233333,0.18427835,0.82666665,0.18427835,0.83,0.18427835,0.8333333,0.18427835,0.83666664,0.18427835,0.84,0.18427835,0.8433333,0.18427835,0.8466667,0.18427835,0.85333335,0.18427835,0.8566667,0.18427835,0.86,0.18427835,0.86333334,0.18427835,0.8666667,0.18427835,0.87,0.18427835,0.87333333,0.18427835,0.87666667,0.18427835,0.88,0.18427835,0.8833333,0.18427835,0.88666666,0.18427835,0.89,0.18427835,0.8933333,0.18427835,0.89666665,0.18427835,0.9,0.18427835,0.9033333,0.18427835,0.9066667,0.18427835,0.91,0.18427835,0.91333336,0.18427835,0.9166667,0.18427835,0.92,0.18427835,0.92333335,0.18427835,0.9266667,0.18427835,0.93,0.18427835,0.93333334,0.18427835,0.93666667,0.18427835,0.94,0.18427835,0.9433333,0.18427835,0.94666666,0.18427835,0.05,0.18685567,0.053333335,0.18685567,0.05666667,0.18685567,0.06,0.18685567,0.06333333,0.18685567,0.06666667,0.18685567,0.07,0.18685567,0.07333333,0.18685567,0.07666667,0.18685567,0.08,0.18685567,0.083333336,0.18685567,0.086666666,0.18685567,0.09,0.18685567,0.093333334,0.18685567,0.096666664,0.18685567,0.1,0.18685567,0.10333333,0.18685567,0.10666667,0.18685567,0.11,0.18685567,0.11333334,0.18685567,0.11666667,0.18685567,0.12,0.18685567,0.123333335,0.18685567,0.12666667,0.18685567,0.13,0.18685567,0.13333334,0.18685567,0.13666667,0.18685567,0.14,0.18685567,0.14333333,0.18685567,0.14666666,0.18685567,0.15,0.18685567,0.15333334,0.18685567,0.15666667,0.18685567,0.16,0.18685567,0.16333333,0.18685567,0.16666667,0.18685567,0.17,0.18685567,0.17333333,0.18685567,0.17666666,0.18685567,0.18,0.18685567,0.18333334,0.18685567,0.18666667,0.18685567,0.19,0.18685567,0.19333333,0.18685567,0.19666667,0.18685567,0.2,0.18685567,0.20333333,0.18685567,0.20666666,0.18685567,0.21,0.18685567,0.21333334,0.18685567,0.21666667,0.18685567,0.22,0.18685567,0.22333333,0.18685567,0.22666667,0.18685567,0.23,0.18685567,0.23333333,0.18685567,0.23666666,0.18685567,0.24,0.18685567,0.24333334,0.18685567,0.24666667,0.18685567,0.25,0.18685567,0.25333333,0.18685567,0.25666666,0.18685567,0.26,0.18685567,0.26333332,0.18685567,0.26666668,0.18685567,0.27,0.18685567,0.27333334,0.18685567,0.27666667,0.18685567,0.28,0.18685567,0.28333333,0.18685567,0.28666666,0.18685567,0.29,0.18685567,0.29333332,0.18685567,0.29666665,0.18685567,0.3,0.18685567,0.30333334,0.18685567,0.30666667,0.18685567,0.31,0.18685567,0.31333333,0.18685567,0.31666666,0.18685567,0.32,0.18685567,0.32333332,0.18685567,0.32666665,0.18685567,0.33,0.18685567,0.33333334,0.18685567,0.33666667,0.18685567,0.34,0.18685567,0.34333333,0.18685567,0.34666666,0.18685567,0.35,0.18685567,0.35333332,0.18685567,0.35666665,0.18685567,0.36,0.18685567,0.36333334,0.18685567,0.36666667,0.18685567,0.37,0.18685567,0.37333333,0.18685567,0.37666667,0.18685567,0.38,0.18685567,0.38333333,0.18685567,0.38666666,0.18685567,0.39,0.18685567,0.39333335,0.18685567,0.39666668,0.18685567,0.4,0.18685567,0.40333334,0.18685567,0.40666667,0.18685567,0.41,0.18685567,0.41333333,0.18685567,0.41666666,0.18685567,0.42,0.18685567,0.42333335,0.18685567,0.42666668,0.18685567,0.43,0.18685567,0.43333334,0.18685567,0.43666667,0.18685567,0.44,0.18685567,0.44333333,0.18685567,0.44666666,0.18685567,0.45,0.18685567,0.45333335,0.18685567,0.45666668,0.18685567,0.46,0.18685567,0.46333334,0.18685567,0.46666667,0.18685567,0.47,0.18685567,0.47333333,0.18685567,0.47666666,0.18685567,0.48,0.18685567,0.48333332,0.18685567,0.48666668,0.18685567,0.49,0.18685567,0.49333334,0.18685567,0.49666667,0.18685567,0.5,0.18685567,0.50333333,0.18685567,0.50666666,0.18685567,0.51,0.18685567,0.5133333,0.18685567,0.51666665,0.18685567,0.52,0.18685567,0.5233333,0.18685567,0.52666664,0.18685567,0.53,0.18685567,0.53333336,0.18685567,0.5366667,0.18685567,0.54,0.18685567,0.54333335,0.18685567,0.5466667,0.18685567,0.55,0.18685567,0.55333334,0.18685567,0.5566667,0.18685567,0.56,0.18685567,0.56333333,0.18685567,0.56666666,0.18685567,0.57,0.18685567,0.5733333,0.18685567,0.57666665,0.18685567,0.58,0.18685567,0.5833333,0.18685567,0.58666664,0.18685567,0.59,0.18685567,0.5933333,0.18685567,0.5966667,0.18685567,0.6,0.18685567,0.60333335,0.18685567,0.6066667,0.18685567,0.61,0.18685567,0.61333334,0.18685567,0.6166667,0.18685567,0.62,0.18685567,0.62333333,0.18685567,0.62666667,0.18685567,0.63,0.18685567,0.6333333,0.18685567,0.63666666,0.18685567,0.64,0.18685567,0.6433333,0.18685567,0.64666665,0.18685567,0.65,0.18685567,0.6533333,0.18685567,0.6566667,0.18685567,0.66,0.18685567,0.66333336,0.18685567,0.6666667,0.18685567,0.67,0.18685567,0.67333335,0.18685567,0.6766667,0.18685567,0.68,0.18685567,0.68333334,0.18685567,0.68666667,0.18685567,0.69,0.18685567,0.6933333,0.18685567,0.69666666,0.18685567,0.7,0.18685567,0.7033333,0.18685567,0.70666665,0.18685567,0.71,0.18685567,0.7133333,0.18685567,0.71666664,0.18685567,0.72,0.18685567,0.72333336,0.18685567,0.7266667,0.18685567,0.73,0.18685567,0.73333335,0.18685567,0.7366667,0.18685567,0.74,0.18685567,0.74333334,0.18685567,0.74666667,0.18685567,0.75,0.18685567,0.75333333,0.18685567,0.75666666,0.18685567,0.76,0.18685567,0.7633333,0.18685567,0.76666665,0.18685567,0.77,0.18685567,0.7733333,0.18685567,0.77666664,0.18685567,0.78,0.18685567,0.78333336,0.18685567,0.7866667,0.18685567,0.79,0.18685567,0.79333335,0.18685567,0.7966667,0.18685567,0.8,0.18685567,0.80333334,0.18685567,0.8066667,0.18685567,0.81,0.18685567,0.81333333,0.18685567,0.81666666,0.18685567,0.82,0.18685567,0.8233333,0.18685567,0.82666665,0.18685567,0.83,0.18685567,0.8333333,0.18685567,0.83666664,0.18685567,0.84,0.18685567,0.8433333,0.18685567,0.85,0.18685567,0.85333335,0.18685567,0.8566667,0.18685567,0.86,0.18685567,0.86333334,0.18685567,0.8666667,0.18685567,0.87,0.18685567,0.87333333,0.18685567,0.87666667,0.18685567,0.88,0.18685567,0.8833333,0.18685567,0.88666666,0.18685567,0.89,0.18685567,0.8933333,0.18685567,0.89666665,0.18685567,0.9,0.18685567,0.9033333,0.18685567,0.9066667,0.18685567,0.91,0.18685567,0.91333336,0.18685567,0.9166667,0.18685567,0.92,0.18685567,0.92333335,0.18685567,0.9266667,0.18685567,0.93,0.18685567,0.93333334,0.18685567,0.93666667,0.18685567,0.94,0.18685567,0.9433333,0.18685567,0.94666666,0.18685567,0.05,0.189433,0.053333335,0.189433,0.05666667,0.189433,0.06,0.189433,0.06333333,0.189433,0.06666667,0.189433,0.07,0.189433,0.07333333,0.189433,0.07666667,0.189433,0.08,0.189433,0.083333336,0.189433,0.086666666,0.189433,0.09,0.189433,0.093333334,0.189433,0.096666664,0.189433,0.1,0.189433,0.10333333,0.189433,0.10666667,0.189433,0.11,0.189433,0.11333334,0.189433,0.11666667,0.189433,0.12,0.189433,0.123333335,0.189433,0.12666667,0.189433,0.13,0.189433,0.13333334,0.189433,0.13666667,0.189433,0.14,0.189433,0.14333333,0.189433,0.14666666,0.189433,0.15,0.189433,0.15333334,0.189433,0.15666667,0.189433,0.16,0.189433,0.16333333,0.189433,0.16666667,0.189433,0.17,0.189433,0.17333333,0.189433,0.17666666,0.189433,0.18,0.189433,0.18333334,0.189433,0.18666667,0.189433,0.19,0.189433,0.19333333,0.189433,0.19666667,0.189433,0.2,0.189433,0.20333333,0.189433,0.20666666,0.189433,0.21,0.189433,0.21333334,0.189433,0.21666667,0.189433,0.22,0.189433,0.22333333,0.189433,0.22666667,0.189433,0.23,0.189433,0.23333333,0.189433,0.23666666,0.189433,0.24,0.189433,0.24333334,0.189433,0.24666667,0.189433,0.25,0.189433,0.25333333,0.189433,0.25666666,0.189433,0.26,0.189433,0.26333332,0.189433,0.26666668,0.189433,0.27,0.189433,0.27333334,0.189433,0.27666667,0.189433,0.28,0.189433,0.28333333,0.189433,0.28666666,0.189433,0.29,0.189433,0.29333332,0.189433,0.29666665,0.189433,0.3,0.189433,0.30333334,0.189433,0.30666667,0.189433,0.31,0.189433,0.31333333,0.189433,0.31666666,0.189433,0.32,0.189433,0.32333332,0.189433,0.32666665,0.189433,0.33,0.189433,0.33333334,0.189433,0.33666667,0.189433,0.34,0.189433,0.34333333,0.189433,0.34666666,0.189433,0.35,0.189433,0.35333332,0.189433,0.35666665,0.189433,0.36,0.189433,0.36333334,0.189433,0.36666667,0.189433,0.37,0.189433,0.37333333,0.189433,0.37666667,0.189433,0.38,0.189433,0.38333333,0.189433,0.38666666,0.189433,0.39,0.189433,0.39333335,0.189433,0.39666668,0.189433,0.4,0.189433,0.40333334,0.189433,0.40666667,0.189433,0.41,0.189433,0.41333333,0.189433,0.41666666,0.189433,0.42,0.189433,0.42333335,0.189433,0.42666668,0.189433,0.43,0.189433,0.43333334,0.189433,0.43666667,0.189433,0.44,0.189433,0.44333333,0.189433,0.44666666,0.189433,0.45,0.189433,0.45333335,0.189433,0.45666668,0.189433,0.46,0.189433,0.46333334,0.189433,0.46666667,0.189433,0.47,0.189433,0.47333333,0.189433,0.47666666,0.189433,0.48,0.189433,0.48333332,0.189433,0.48666668,0.189433,0.49,0.189433,0.49333334,0.189433,0.49666667,0.189433,0.5,0.189433,0.50333333,0.189433,0.50666666,0.189433,0.51,0.189433,0.5133333,0.189433,0.51666665,0.189433,0.52,0.189433,0.5233333,0.189433,0.52666664,0.189433,0.53,0.189433,0.53333336,0.189433,0.5366667,0.189433,0.54,0.189433,0.54333335,0.189433,0.5466667,0.189433,0.55,0.189433,0.55333334,0.189433,0.5566667,0.189433,0.56,0.189433,0.56333333,0.189433,0.56666666,0.189433,0.57666665,0.189433,0.58,0.189433,0.5833333,0.189433,0.58666664,0.189433,0.59,0.189433,0.5933333,0.189433,0.5966667,0.189433,0.6,0.189433,0.60333335,0.189433,0.6066667,0.189433,0.61,0.189433,0.61333334,0.189433,0.6166667,0.189433,0.62,0.189433,0.62333333,0.189433,0.62666667,0.189433,0.63,0.189433,0.6333333,0.189433,0.63666666,0.189433,0.64,0.189433,0.6433333,0.189433,0.64666665,0.189433,0.65,0.189433,0.6533333,0.189433,0.6566667,0.189433,0.66,0.189433,0.66333336,0.189433,0.6666667,0.189433,0.67,0.189433,0.67333335,0.189433,0.6766667,0.189433,0.68,0.189433,0.68333334,0.189433,0.68666667,0.189433,0.69,0.189433,0.6933333,0.189433,0.69666666,0.189433,0.7,0.189433,0.7033333,0.189433,0.70666665,0.189433,0.71,0.189433,0.7133333,0.189433,0.71666664,0.189433,0.72,0.189433,0.72333336,0.189433,0.7266667,0.189433,0.73,0.189433,0.73333335,0.189433,0.7366667,0.189433,0.74,0.189433,0.74333334,0.189433,0.74666667,0.189433,0.75,0.189433,0.75333333,0.189433,0.75666666,0.189433,0.76,0.189433,0.7633333,0.189433,0.76666665,0.189433,0.77,0.189433,0.7733333,0.189433,0.77666664,0.189433,0.78,0.189433,0.78333336,0.189433,0.7866667,0.189433,0.79,0.189433,0.79333335,0.189433,0.7966667,0.189433,0.8,0.189433,0.80333334,0.189433,0.8066667,0.189433,0.81,0.189433,0.81333333,0.189433,0.81666666,0.189433,0.82,0.189433,0.8233333,0.189433,0.82666665,0.189433,0.83,0.189433,0.8333333,0.189433,0.83666664,0.189433,0.84,0.189433,0.8466667,0.189433,0.85,0.189433,0.85333335,0.189433,0.8566667,0.189433,0.86,0.189433,0.86333334,0.189433,0.8666667,0.189433,0.87,0.189433,0.87333333,0.189433,0.87666667,0.189433,0.88,0.189433,0.8833333,0.189433,0.88666666,0.189433,0.89,0.189433,0.8933333,0.189433,0.89666665,0.189433,0.9,0.189433,0.9033333,0.189433,0.9066667,0.189433,0.91,0.189433,0.91333336,0.189433,0.9166667,0.189433,0.92,0.189433,0.92333335,0.189433,0.9266667,0.189433,0.93,0.189433,0.93333334,0.189433,0.93666667,0.189433,0.94,0.189433,0.9433333,0.189433,0.94666666,0.189433,0.05,0.19201031,0.053333335,0.19201031,0.05666667,0.19201031,0.06,0.19201031,0.06333333,0.19201031,0.06666667,0.19201031,0.07,0.19201031,0.07333333,0.19201031,0.07666667,0.19201031,0.08,0.19201031,0.083333336,0.19201031,0.086666666,0.19201031,0.09,0.19201031,0.093333334,0.19201031,0.096666664,0.19201031,0.1,0.19201031,0.10333333,0.19201031,0.10666667,0.19201031,0.11,0.19201031,0.11333334,0.19201031,0.11666667,0.19201031,0.12,0.19201031,0.123333335,0.19201031,0.12666667,0.19201031,0.13,0.19201031,0.13333334,0.19201031,0.13666667,0.19201031,0.14,0.19201031,0.14333333,0.19201031,0.14666666,0.19201031,0.15,0.19201031,0.15333334,0.19201031,0.15666667,0.19201031,0.16,0.19201031,0.16333333,0.19201031,0.16666667,0.19201031,0.17,0.19201031,0.17333333,0.19201031,0.17666666,0.19201031,0.18,0.19201031,0.18333334,0.19201031,0.18666667,0.19201031,0.19,0.19201031,0.19333333,0.19201031,0.19666667,0.19201031,0.2,0.19201031,0.20333333,0.19201031,0.20666666,0.19201031,0.21,0.19201031,0.21333334,0.19201031,0.21666667,0.19201031,0.22,0.19201031,0.22333333,0.19201031,0.22666667,0.19201031,0.23,0.19201031,0.23333333,0.19201031,0.23666666,0.19201031,0.24,0.19201031,0.24333334,0.19201031,0.24666667,0.19201031,0.25,0.19201031,0.25333333,0.19201031,0.25666666,0.19201031,0.26,0.19201031,0.26333332,0.19201031,0.26666668,0.19201031,0.27,0.19201031,0.27333334,0.19201031,0.27666667,0.19201031,0.28,0.19201031,0.28333333,0.19201031,0.28666666,0.19201031,0.29,0.19201031,0.29333332,0.19201031,0.29666665,0.19201031,0.3,0.19201031,0.30333334,0.19201031,0.30666667,0.19201031,0.31,0.19201031,0.31333333,0.19201031,0.31666666,0.19201031,0.32,0.19201031,0.32333332,0.19201031,0.32666665,0.19201031,0.33,0.19201031,0.33333334,0.19201031,0.33666667,0.19201031,0.34,0.19201031,0.34333333,0.19201031,0.34666666,0.19201031,0.35,0.19201031,0.35333332,0.19201031,0.35666665,0.19201031,0.36,0.19201031,0.36333334,0.19201031,0.36666667,0.19201031,0.37,0.19201031,0.37333333,0.19201031,0.37666667,0.19201031,0.38,0.19201031,0.38333333,0.19201031,0.38666666,0.19201031,0.39,0.19201031,0.39333335,0.19201031,0.39666668,0.19201031,0.4,0.19201031,0.40333334,0.19201031,0.40666667,0.19201031,0.41,0.19201031,0.41333333,0.19201031,0.41666666,0.19201031,0.42,0.19201031,0.42333335,0.19201031,0.42666668,0.19201031,0.43,0.19201031,0.43333334,0.19201031,0.43666667,0.19201031,0.44,0.19201031,0.44333333,0.19201031,0.44666666,0.19201031,0.45,0.19201031,0.45333335,0.19201031,0.45666668,0.19201031,0.46,0.19201031,0.46333334,0.19201031,0.46666667,0.19201031,0.47,0.19201031,0.47333333,0.19201031,0.47666666,0.19201031,0.48,0.19201031,0.48333332,0.19201031,0.48666668,0.19201031,0.49,0.19201031,0.49333334,0.19201031,0.49666667,0.19201031,0.5,0.19201031,0.50333333,0.19201031,0.50666666,0.19201031,0.51,0.19201031,0.5133333,0.19201031,0.51666665,0.19201031,0.52,0.19201031,0.5233333,0.19201031,0.52666664,0.19201031,0.53,0.19201031,0.53333336,0.19201031,0.5366667,0.19201031,0.54,0.19201031,0.54333335,0.19201031,0.5466667,0.19201031,0.55,0.19201031,0.55333334,0.19201031,0.5566667,0.19201031,0.56,0.19201031,0.56333333,0.19201031,0.56666666,0.19201031,0.57,0.19201031,0.5733333,0.19201031,0.57666665,0.19201031,0.58,0.19201031,0.5833333,0.19201031,0.58666664,0.19201031,0.59,0.19201031,0.5933333,0.19201031,0.5966667,0.19201031,0.6,0.19201031,0.60333335,0.19201031,0.6066667,0.19201031,0.61,0.19201031,0.61333334,0.19201031,0.6166667,0.19201031,0.62,0.19201031,0.62333333,0.19201031,0.62666667,0.19201031,0.63,0.19201031,0.6333333,0.19201031,0.63666666,0.19201031,0.64,0.19201031,0.6433333,0.19201031,0.64666665,0.19201031,0.65,0.19201031,0.6533333,0.19201031,0.6566667,0.19201031,0.66,0.19201031,0.66333336,0.19201031,0.6666667,0.19201031,0.67,0.19201031,0.67333335,0.19201031,0.6766667,0.19201031,0.68,0.19201031,0.68333334,0.19201031,0.68666667,0.19201031,0.69,0.19201031,0.6933333,0.19201031,0.69666666,0.19201031,0.7,0.19201031,0.7033333,0.19201031,0.70666665,0.19201031,0.71,0.19201031,0.7133333,0.19201031,0.71666664,0.19201031,0.72,0.19201031,0.72333336,0.19201031,0.7266667,0.19201031,0.73,0.19201031,0.73333335,0.19201031,0.7366667,0.19201031,0.74,0.19201031,0.74333334,0.19201031,0.74666667,0.19201031,0.75,0.19201031,0.75333333,0.19201031,0.75666666,0.19201031,0.76,0.19201031,0.7633333,0.19201031,0.76666665,0.19201031,0.77,0.19201031,0.7733333,0.19201031,0.77666664,0.19201031,0.78,0.19201031,0.78333336,0.19201031,0.7866667,0.19201031,0.79,0.19201031,0.79333335,0.19201031,0.7966667,0.19201031,0.8,0.19201031,0.80333334,0.19201031,0.8066667,0.19201031,0.81,0.19201031,0.81333333,0.19201031,0.81666666,0.19201031,0.82,0.19201031,0.8233333,0.19201031,0.82666665,0.19201031,0.83,0.19201031,0.8333333,0.19201031,0.83666664,0.19201031,0.84,0.19201031,0.8433333,0.19201031,0.8466667,0.19201031,0.85,0.19201031,0.85333335,0.19201031,0.8566667,0.19201031,0.86,0.19201031,0.86333334,0.19201031,0.8666667,0.19201031,0.87,0.19201031,0.87333333,0.19201031,0.87666667,0.19201031,0.88,0.19201031,0.8833333,0.19201031,0.88666666,0.19201031,0.89,0.19201031,0.8933333,0.19201031,0.89666665,0.19201031,0.9,0.19201031,0.9033333,0.19201031,0.9066667,0.19201031,0.91,0.19201031,0.91333336,0.19201031,0.9166667,0.19201031,0.92,0.19201031,0.92333335,0.19201031,0.9266667,0.19201031,0.93,0.19201031,0.93333334,0.19201031,0.93666667,0.19201031,0.94,0.19201031,0.9433333,0.19201031,0.94666666,0.19201031,0.05,0.19458763,0.053333335,0.19458763,0.05666667,0.19458763,0.06,0.19458763,0.06333333,0.19458763,0.06666667,0.19458763,0.07,0.19458763,0.07333333,0.19458763,0.07666667,0.19458763,0.08,0.19458763,0.083333336,0.19458763,0.086666666,0.19458763,0.09,0.19458763,0.093333334,0.19458763,0.096666664,0.19458763,0.1,0.19458763,0.10333333,0.19458763,0.10666667,0.19458763,0.11,0.19458763,0.11333334,0.19458763,0.11666667,0.19458763,0.12,0.19458763,0.123333335,0.19458763,0.12666667,0.19458763,0.13,0.19458763,0.13333334,0.19458763,0.13666667,0.19458763,0.14,0.19458763,0.14333333,0.19458763,0.14666666,0.19458763,0.15,0.19458763,0.15333334,0.19458763,0.15666667,0.19458763,0.16,0.19458763,0.16333333,0.19458763,0.16666667,0.19458763,0.17,0.19458763,0.17333333,0.19458763,0.17666666,0.19458763,0.18,0.19458763,0.18333334,0.19458763,0.18666667,0.19458763,0.19,0.19458763,0.19333333,0.19458763,0.19666667,0.19458763,0.2,0.19458763,0.20333333,0.19458763,0.20666666,0.19458763,0.21,0.19458763,0.21333334,0.19458763,0.21666667,0.19458763,0.22,0.19458763,0.22333333,0.19458763,0.22666667,0.19458763,0.23,0.19458763,0.23333333,0.19458763,0.23666666,0.19458763,0.24,0.19458763,0.24333334,0.19458763,0.24666667,0.19458763,0.25,0.19458763,0.25333333,0.19458763,0.25666666,0.19458763,0.26,0.19458763,0.26333332,0.19458763,0.26666668,0.19458763,0.27,0.19458763,0.27333334,0.19458763,0.27666667,0.19458763,0.28,0.19458763,0.28333333,0.19458763,0.28666666,0.19458763,0.29,0.19458763,0.29333332,0.19458763,0.29666665,0.19458763,0.3,0.19458763,0.30333334,0.19458763,0.30666667,0.19458763,0.31,0.19458763,0.31333333,0.19458763,0.31666666,0.19458763,0.32,0.19458763,0.32333332,0.19458763,0.32666665,0.19458763,0.33,0.19458763,0.33333334,0.19458763,0.33666667,0.19458763,0.34,0.19458763,0.34333333,0.19458763,0.34666666,0.19458763,0.35,0.19458763,0.35333332,0.19458763,0.35666665,0.19458763,0.36,0.19458763,0.36333334,0.19458763,0.36666667,0.19458763,0.37,0.19458763,0.37333333,0.19458763,0.37666667,0.19458763,0.38,0.19458763,0.38333333,0.19458763,0.38666666,0.19458763,0.39,0.19458763,0.39333335,0.19458763,0.39666668,0.19458763,0.4,0.19458763,0.40333334,0.19458763,0.40666667,0.19458763,0.41,0.19458763,0.41333333,0.19458763,0.41666666,0.19458763,0.42,0.19458763,0.42333335,0.19458763,0.42666668,0.19458763,0.43,0.19458763,0.43333334,0.19458763,0.43666667,0.19458763,0.44,0.19458763,0.44333333,0.19458763,0.44666666,0.19458763,0.45,0.19458763,0.45333335,0.19458763,0.45666668,0.19458763,0.46,0.19458763,0.46333334,0.19458763,0.46666667,0.19458763,0.47,0.19458763,0.47333333,0.19458763,0.47666666,0.19458763,0.48,0.19458763,0.48333332,0.19458763,0.48666668,0.19458763,0.49,0.19458763,0.49333334,0.19458763,0.49666667,0.19458763,0.5,0.19458763,0.50333333,0.19458763,0.50666666,0.19458763,0.51,0.19458763,0.5133333,0.19458763,0.51666665,0.19458763,0.52,0.19458763,0.5233333,0.19458763,0.52666664,0.19458763,0.53,0.19458763,0.53333336,0.19458763,0.5366667,0.19458763,0.54,0.19458763,0.54333335,0.19458763,0.5466667,0.19458763,0.55,0.19458763,0.55333334,0.19458763,0.5566667,0.19458763,0.56,0.19458763,0.56333333,0.19458763,0.56666666,0.19458763,0.57,0.19458763,0.5733333,0.19458763,0.57666665,0.19458763,0.58,0.19458763,0.5833333,0.19458763,0.58666664,0.19458763,0.59,0.19458763,0.5933333,0.19458763,0.5966667,0.19458763,0.6,0.19458763,0.60333335,0.19458763,0.6066667,0.19458763,0.61,0.19458763,0.61333334,0.19458763,0.6166667,0.19458763,0.62,0.19458763,0.62333333,0.19458763,0.62666667,0.19458763,0.63,0.19458763,0.6333333,0.19458763,0.63666666,0.19458763,0.64,0.19458763,0.6433333,0.19458763,0.64666665,0.19458763,0.65,0.19458763,0.6533333,0.19458763,0.6566667,0.19458763,0.66,0.19458763,0.66333336,0.19458763,0.6666667,0.19458763,0.67,0.19458763,0.67333335,0.19458763,0.6766667,0.19458763,0.68,0.19458763,0.68333334,0.19458763,0.68666667,0.19458763,0.69,0.19458763,0.6933333,0.19458763,0.69666666,0.19458763,0.7,0.19458763,0.7033333,0.19458763,0.70666665,0.19458763,0.71,0.19458763,0.7133333,0.19458763,0.71666664,0.19458763,0.72,0.19458763,0.72333336,0.19458763,0.7266667,0.19458763,0.73,0.19458763,0.73333335,0.19458763,0.7366667,0.19458763,0.74,0.19458763,0.74333334,0.19458763,0.74666667,0.19458763,0.75,0.19458763,0.75333333,0.19458763,0.75666666,0.19458763,0.76,0.19458763,0.7633333,0.19458763,0.76666665,0.19458763,0.77,0.19458763,0.7733333,0.19458763,0.77666664,0.19458763,0.78,0.19458763,0.78333336,0.19458763,0.7866667,0.19458763,0.79,0.19458763,0.79333335,0.19458763,0.7966667,0.19458763,0.8,0.19458763,0.80333334,0.19458763,0.8066667,0.19458763,0.81,0.19458763,0.81333333,0.19458763,0.81666666,0.19458763,0.82,0.19458763,0.8233333,0.19458763,0.82666665,0.19458763,0.83,0.19458763,0.8333333,0.19458763,0.83666664,0.19458763,0.8433333,0.19458763,0.8466667,0.19458763,0.85,0.19458763,0.85333335,0.19458763,0.8566667,0.19458763,0.86,0.19458763,0.86333334,0.19458763,0.8666667,0.19458763,0.87,0.19458763,0.87333333,0.19458763,0.87666667,0.19458763,0.88,0.19458763,0.8833333,0.19458763,0.88666666,0.19458763,0.89,0.19458763,0.8933333,0.19458763,0.89666665,0.19458763,0.9,0.19458763,0.9033333,0.19458763,0.9066667,0.19458763,0.91,0.19458763,0.91333336,0.19458763,0.9166667,0.19458763,0.92,0.19458763,0.92333335,0.19458763,0.9266667,0.19458763,0.93,0.19458763,0.93333334,0.19458763,0.93666667,0.19458763,0.94,0.19458763,0.9433333,0.19458763,0.94666666,0.19458763,0.05,0.19716495,0.053333335,0.19716495,0.05666667,0.19716495,0.06,0.19716495,0.06333333,0.19716495,0.06666667,0.19716495,0.07,0.19716495,0.07333333,0.19716495,0.07666667,0.19716495,0.08,0.19716495,0.083333336,0.19716495,0.086666666,0.19716495,0.09,0.19716495,0.093333334,0.19716495,0.096666664,0.19716495,0.1,0.19716495,0.10333333,0.19716495,0.10666667,0.19716495,0.11,0.19716495,0.11333334,0.19716495,0.11666667,0.19716495,0.12,0.19716495,0.123333335,0.19716495,0.12666667,0.19716495,0.13,0.19716495,0.13333334,0.19716495,0.13666667,0.19716495,0.14,0.19716495,0.14333333,0.19716495,0.14666666,0.19716495,0.15,0.19716495,0.15333334,0.19716495,0.15666667,0.19716495,0.16,0.19716495,0.16333333,0.19716495,0.16666667,0.19716495,0.17,0.19716495,0.17333333,0.19716495,0.17666666,0.19716495,0.18,0.19716495,0.18333334,0.19716495,0.18666667,0.19716495,0.19,0.19716495,0.19333333,0.19716495,0.19666667,0.19716495,0.2,0.19716495,0.20333333,0.19716495,0.20666666,0.19716495,0.21,0.19716495,0.21333334,0.19716495,0.21666667,0.19716495,0.22,0.19716495,0.22333333,0.19716495,0.22666667,0.19716495,0.23,0.19716495,0.23333333,0.19716495,0.23666666,0.19716495,0.24,0.19716495,0.24333334,0.19716495,0.24666667,0.19716495,0.25,0.19716495,0.25333333,0.19716495,0.25666666,0.19716495,0.26,0.19716495,0.26333332,0.19716495,0.26666668,0.19716495,0.27,0.19716495,0.27333334,0.19716495,0.27666667,0.19716495,0.28,0.19716495,0.28333333,0.19716495,0.28666666,0.19716495,0.29,0.19716495,0.29333332,0.19716495,0.29666665,0.19716495,0.3,0.19716495,0.30333334,0.19716495,0.30666667,0.19716495,0.31,0.19716495,0.31333333,0.19716495,0.31666666,0.19716495,0.32,0.19716495,0.32333332,0.19716495,0.32666665,0.19716495,0.33,0.19716495,0.33333334,0.19716495,0.33666667,0.19716495,0.34,0.19716495,0.34333333,0.19716495,0.34666666,0.19716495,0.35,0.19716495,0.35333332,0.19716495,0.35666665,0.19716495,0.36,0.19716495,0.36333334,0.19716495,0.36666667,0.19716495,0.37,0.19716495,0.37333333,0.19716495,0.37666667,0.19716495,0.38,0.19716495,0.38333333,0.19716495,0.38666666,0.19716495,0.39,0.19716495,0.39333335,0.19716495,0.39666668,0.19716495,0.4,0.19716495,0.40333334,0.19716495,0.40666667,0.19716495,0.41,0.19716495,0.41333333,0.19716495,0.41666666,0.19716495,0.42,0.19716495,0.42333335,0.19716495,0.42666668,0.19716495,0.43,0.19716495,0.43333334,0.19716495,0.43666667,0.19716495,0.44,0.19716495,0.44333333,0.19716495,0.44666666,0.19716495,0.45,0.19716495,0.45333335,0.19716495,0.45666668,0.19716495,0.46,0.19716495,0.46333334,0.19716495,0.46666667,0.19716495,0.47,0.19716495,0.47333333,0.19716495,0.47666666,0.19716495,0.48,0.19716495,0.48333332,0.19716495,0.48666668,0.19716495,0.49,0.19716495,0.49333334,0.19716495,0.49666667,0.19716495,0.5,0.19716495,0.50333333,0.19716495,0.50666666,0.19716495,0.51,0.19716495,0.5133333,0.19716495,0.51666665,0.19716495,0.52,0.19716495,0.5233333,0.19716495,0.52666664,0.19716495,0.53,0.19716495,0.53333336,0.19716495,0.5366667,0.19716495,0.54,0.19716495,0.54333335,0.19716495,0.5466667,0.19716495,0.55,0.19716495,0.55333334,0.19716495,0.5566667,0.19716495,0.56,0.19716495,0.56333333,0.19716495,0.56666666,0.19716495,0.57,0.19716495,0.5733333,0.19716495,0.57666665,0.19716495,0.58,0.19716495,0.5833333,0.19716495,0.58666664,0.19716495,0.59,0.19716495,0.5933333,0.19716495,0.5966667,0.19716495,0.6,0.19716495,0.60333335,0.19716495,0.6066667,0.19716495,0.61,0.19716495,0.61333334,0.19716495,0.6166667,0.19716495,0.62,0.19716495,0.62333333,0.19716495,0.62666667,0.19716495,0.63,0.19716495,0.6333333,0.19716495,0.63666666,0.19716495,0.64,0.19716495,0.6433333,0.19716495,0.64666665,0.19716495,0.65,0.19716495,0.6533333,0.19716495,0.6566667,0.19716495,0.66,0.19716495,0.66333336,0.19716495,0.6666667,0.19716495,0.67,0.19716495,0.67333335,0.19716495,0.6766667,0.19716495,0.68,0.19716495,0.68333334,0.19716495,0.68666667,0.19716495,0.69,0.19716495,0.6933333,0.19716495,0.69666666,0.19716495,0.7,0.19716495,0.7033333,0.19716495,0.70666665,0.19716495,0.71,0.19716495,0.7133333,0.19716495,0.71666664,0.19716495,0.72,0.19716495,0.72333336,0.19716495,0.7266667,0.19716495,0.73,0.19716495,0.73333335,0.19716495,0.7366667,0.19716495,0.74,0.19716495,0.74333334,0.19716495,0.74666667,0.19716495,0.75,0.19716495,0.75333333,0.19716495,0.75666666,0.19716495,0.76,0.19716495,0.7633333,0.19716495,0.76666665,0.19716495,0.77,0.19716495,0.7733333,0.19716495,0.77666664,0.19716495,0.78,0.19716495,0.78333336,0.19716495,0.7866667,0.19716495,0.79,0.19716495,0.79333335,0.19716495,0.7966667,0.19716495,0.8,0.19716495,0.80333334,0.19716495,0.8066667,0.19716495,0.81,0.19716495,0.81333333,0.19716495,0.81666666,0.19716495,0.82,0.19716495,0.8233333,0.19716495,0.82666665,0.19716495,0.83,0.19716495,0.8333333,0.19716495,0.83666664,0.19716495,0.84,0.19716495,0.8433333,0.19716495,0.8466667,0.19716495,0.85,0.19716495,0.85333335,0.19716495,0.8566667,0.19716495,0.86,0.19716495,0.86333334,0.19716495,0.8666667,0.19716495,0.87,0.19716495,0.87333333,0.19716495,0.87666667,0.19716495,0.88,0.19716495,0.8833333,0.19716495,0.88666666,0.19716495,0.89,0.19716495,0.8933333,0.19716495,0.89666665,0.19716495,0.9,0.19716495,0.9033333,0.19716495,0.9066667,0.19716495,0.91,0.19716495,0.91333336,0.19716495,0.9166667,0.19716495,0.92,0.19716495,0.92333335,0.19716495,0.9266667,0.19716495,0.93,0.19716495,0.93333334,0.19716495,0.93666667,0.19716495,0.94,0.19716495,0.9433333,0.19716495,0.94666666,0.19716495,0.05,0.19974227,0.053333335,0.19974227,0.05666667,0.19974227,0.06,0.19974227,0.06333333,0.19974227,0.06666667,0.19974227,0.07,0.19974227,0.07333333,0.19974227,0.07666667,0.19974227,0.08,0.19974227,0.083333336,0.19974227,0.086666666,0.19974227,0.09,0.19974227,0.093333334,0.19974227,0.096666664,0.19974227,0.1,0.19974227,0.10333333,0.19974227,0.10666667,0.19974227,0.11,0.19974227,0.11333334,0.19974227,0.11666667,0.19974227,0.12,0.19974227,0.123333335,0.19974227,0.12666667,0.19974227,0.13,0.19974227,0.13333334,0.19974227,0.13666667,0.19974227,0.14,0.19974227,0.14333333,0.19974227,0.14666666,0.19974227,0.15,0.19974227,0.15333334,0.19974227,0.15666667,0.19974227,0.16,0.19974227,0.16333333,0.19974227,0.16666667,0.19974227,0.17,0.19974227,0.17333333,0.19974227,0.17666666,0.19974227,0.18,0.19974227,0.18333334,0.19974227,0.18666667,0.19974227,0.19,0.19974227,0.19333333,0.19974227,0.19666667,0.19974227,0.2,0.19974227,0.20333333,0.19974227,0.20666666,0.19974227,0.21,0.19974227,0.21333334,0.19974227,0.21666667,0.19974227,0.22,0.19974227,0.22333333,0.19974227,0.22666667,0.19974227,0.23,0.19974227,0.23333333,0.19974227,0.23666666,0.19974227,0.24,0.19974227,0.24333334,0.19974227,0.24666667,0.19974227,0.25,0.19974227,0.25333333,0.19974227,0.25666666,0.19974227,0.26,0.19974227,0.26333332,0.19974227,0.26666668,0.19974227,0.27,0.19974227,0.27333334,0.19974227,0.27666667,0.19974227,0.28,0.19974227,0.28333333,0.19974227,0.28666666,0.19974227,0.29,0.19974227,0.29333332,0.19974227,0.29666665,0.19974227,0.3,0.19974227,0.30333334,0.19974227,0.30666667,0.19974227,0.31,0.19974227,0.31333333,0.19974227,0.31666666,0.19974227,0.32,0.19974227,0.32333332,0.19974227,0.32666665,0.19974227,0.33,0.19974227,0.33333334,0.19974227,0.33666667,0.19974227,0.34,0.19974227,0.34333333,0.19974227,0.34666666,0.19974227,0.35,0.19974227,0.35333332,0.19974227,0.35666665,0.19974227,0.36,0.19974227,0.36333334,0.19974227,0.36666667,0.19974227,0.37,0.19974227,0.37333333,0.19974227,0.37666667,0.19974227,0.38,0.19974227,0.38333333,0.19974227,0.38666666,0.19974227,0.39,0.19974227,0.39333335,0.19974227,0.39666668,0.19974227,0.4,0.19974227,0.40333334,0.19974227,0.40666667,0.19974227,0.41,0.19974227,0.41333333,0.19974227,0.41666666,0.19974227,0.42,0.19974227,0.42333335,0.19974227,0.42666668,0.19974227,0.43,0.19974227,0.43333334,0.19974227,0.43666667,0.19974227,0.44,0.19974227,0.44333333,0.19974227,0.44666666,0.19974227,0.45,0.19974227,0.45333335,0.19974227,0.45666668,0.19974227,0.46,0.19974227,0.46333334,0.19974227,0.46666667,0.19974227,0.47,0.19974227,0.47333333,0.19974227,0.47666666,0.19974227,0.48,0.19974227,0.48333332,0.19974227,0.48666668,0.19974227,0.49,0.19974227,0.49333334,0.19974227,0.49666667,0.19974227,0.5,0.19974227,0.50333333,0.19974227,0.50666666,0.19974227,0.51,0.19974227,0.5133333,0.19974227,0.51666665,0.19974227,0.52,0.19974227,0.5233333,0.19974227,0.52666664,0.19974227,0.53,0.19974227,0.53333336,0.19974227,0.5366667,0.19974227,0.54,0.19974227,0.54333335,0.19974227,0.5466667,0.19974227,0.55,0.19974227,0.55333334,0.19974227,0.5566667,0.19974227,0.56,0.19974227,0.56333333,0.19974227,0.56666666,0.19974227,0.57,0.19974227,0.5733333,0.19974227,0.57666665,0.19974227,0.58,0.19974227,0.5833333,0.19974227,0.58666664,0.19974227,0.59,0.19974227,0.5933333,0.19974227,0.5966667,0.19974227,0.6,0.19974227,0.60333335,0.19974227,0.6066667,0.19974227,0.61,0.19974227,0.61333334,0.19974227,0.6166667,0.19974227,0.62,0.19974227,0.62333333,0.19974227,0.62666667,0.19974227,0.63,0.19974227,0.6333333,0.19974227,0.63666666,0.19974227,0.64,0.19974227,0.6433333,0.19974227,0.64666665,0.19974227,0.65,0.19974227,0.6533333,0.19974227,0.6566667,0.19974227,0.66,0.19974227,0.66333336,0.19974227,0.6666667,0.19974227,0.67,0.19974227,0.67333335,0.19974227,0.6766667,0.19974227,0.68,0.19974227,0.68333334,0.19974227,0.68666667,0.19974227,0.69,0.19974227,0.6933333,0.19974227,0.69666666,0.19974227,0.7,0.19974227,0.7033333,0.19974227,0.70666665,0.19974227,0.71,0.19974227,0.7133333,0.19974227,0.71666664,0.19974227,0.72,0.19974227,0.72333336,0.19974227,0.7266667,0.19974227,0.73,0.19974227,0.73333335,0.19974227,0.7366667,0.19974227,0.74,0.19974227,0.74333334,0.19974227,0.74666667,0.19974227,0.75,0.19974227,0.75333333,0.19974227,0.75666666,0.19974227,0.76,0.19974227,0.7633333,0.19974227,0.76666665,0.19974227,0.77,0.19974227,0.7733333,0.19974227,0.77666664,0.19974227,0.78,0.19974227,0.78333336,0.19974227,0.7866667,0.19974227,0.79,0.19974227,0.79333335,0.19974227,0.7966667,0.19974227,0.8,0.19974227,0.80333334,0.19974227,0.8066667,0.19974227,0.81,0.19974227,0.81333333,0.19974227,0.81666666,0.19974227,0.82,0.19974227,0.8233333,0.19974227,0.82666665,0.19974227,0.83,0.19974227,0.8333333,0.19974227,0.83666664,0.19974227,0.84,0.19974227,0.8433333,0.19974227,0.8466667,0.19974227,0.85,0.19974227,0.85333335,0.19974227,0.8566667,0.19974227,0.86,0.19974227,0.86333334,0.19974227,0.8666667,0.19974227,0.87,0.19974227,0.87333333,0.19974227,0.87666667,0.19974227,0.88,0.19974227,0.8833333,0.19974227,0.88666666,0.19974227,0.89,0.19974227,0.8933333,0.19974227,0.89666665,0.19974227,0.9,0.19974227,0.9033333,0.19974227,0.9066667,0.19974227,0.91,0.19974227,0.91333336,0.19974227,0.9166667,0.19974227,0.92,0.19974227,0.92333335,0.19974227,0.9266667,0.19974227,0.93,0.19974227,0.93333334,0.19974227,0.93666667,0.19974227,0.94,0.19974227,0.9433333,0.19974227,0.94666666,0.19974227,0.05,0.20231959,0.053333335,0.20231959,0.05666667,0.20231959,0.06,0.20231959,0.06333333,0.20231959,0.06666667,0.20231959,0.07,0.20231959,0.07333333,0.20231959,0.07666667,0.20231959,0.08,0.20231959,0.083333336,0.20231959,0.086666666,0.20231959,0.09,0.20231959,0.093333334,0.20231959,0.096666664,0.20231959,0.1,0.20231959,0.10333333,0.20231959,0.10666667,0.20231959,0.11,0.20231959,0.11333334,0.20231959,0.11666667,0.20231959,0.12,0.20231959,0.123333335,0.20231959,0.12666667,0.20231959,0.13,0.20231959,0.13333334,0.20231959,0.13666667,0.20231959,0.14,0.20231959,0.14333333,0.20231959,0.14666666,0.20231959,0.15,0.20231959,0.15333334,0.20231959,0.15666667,0.20231959,0.16,0.20231959,0.16333333,0.20231959,0.16666667,0.20231959,0.17,0.20231959,0.17333333,0.20231959,0.17666666,0.20231959,0.18,0.20231959,0.18333334,0.20231959,0.18666667,0.20231959,0.19,0.20231959,0.19333333,0.20231959,0.19666667,0.20231959,0.2,0.20231959,0.20333333,0.20231959,0.20666666,0.20231959,0.21,0.20231959,0.21333334,0.20231959,0.21666667,0.20231959,0.22,0.20231959,0.22333333,0.20231959,0.22666667,0.20231959,0.23,0.20231959,0.23333333,0.20231959,0.23666666,0.20231959,0.24,0.20231959,0.24333334,0.20231959,0.24666667,0.20231959,0.25,0.20231959,0.25333333,0.20231959,0.25666666,0.20231959,0.26,0.20231959,0.26333332,0.20231959,0.26666668,0.20231959,0.27,0.20231959,0.27333334,0.20231959,0.27666667,0.20231959,0.28,0.20231959,0.28333333,0.20231959,0.28666666,0.20231959,0.29,0.20231959,0.29333332,0.20231959,0.29666665,0.20231959,0.3,0.20231959,0.30333334,0.20231959,0.30666667,0.20231959,0.31,0.20231959,0.31333333,0.20231959,0.31666666,0.20231959,0.32,0.20231959,0.32333332,0.20231959,0.32666665,0.20231959,0.33,0.20231959,0.33333334,0.20231959,0.33666667,0.20231959,0.34,0.20231959,0.34333333,0.20231959,0.34666666,0.20231959,0.35,0.20231959,0.35333332,0.20231959,0.35666665,0.20231959,0.36,0.20231959,0.36333334,0.20231959,0.36666667,0.20231959,0.37,0.20231959,0.37333333,0.20231959,0.37666667,0.20231959,0.38,0.20231959,0.38333333,0.20231959,0.38666666,0.20231959,0.39,0.20231959,0.39333335,0.20231959,0.39666668,0.20231959,0.4,0.20231959,0.40333334,0.20231959,0.40666667,0.20231959,0.41,0.20231959,0.41333333,0.20231959,0.41666666,0.20231959,0.42,0.20231959,0.42333335,0.20231959,0.42666668,0.20231959,0.43,0.20231959,0.43333334,0.20231959,0.43666667,0.20231959,0.44,0.20231959,0.44333333,0.20231959,0.44666666,0.20231959,0.45,0.20231959,0.45333335,0.20231959,0.45666668,0.20231959,0.46,0.20231959,0.46333334,0.20231959,0.46666667,0.20231959,0.47,0.20231959,0.47333333,0.20231959,0.47666666,0.20231959,0.48,0.20231959,0.48333332,0.20231959,0.48666668,0.20231959,0.49,0.20231959,0.49333334,0.20231959,0.49666667,0.20231959,0.5,0.20231959,0.50333333,0.20231959,0.50666666,0.20231959,0.51,0.20231959,0.5133333,0.20231959,0.51666665,0.20231959,0.52,0.20231959,0.5233333,0.20231959,0.52666664,0.20231959,0.53,0.20231959,0.53333336,0.20231959,0.5366667,0.20231959,0.54,0.20231959,0.54333335,0.20231959,0.5466667,0.20231959,0.55,0.20231959,0.55333334,0.20231959,0.5566667,0.20231959,0.56,0.20231959,0.56333333,0.20231959,0.56666666,0.20231959,0.57,0.20231959,0.5733333,0.20231959,0.57666665,0.20231959,0.58,0.20231959,0.5833333,0.20231959,0.58666664,0.20231959,0.59,0.20231959,0.5933333,0.20231959,0.5966667,0.20231959,0.6,0.20231959,0.60333335,0.20231959,0.6066667,0.20231959,0.61,0.20231959,0.61333334,0.20231959,0.6166667,0.20231959,0.62,0.20231959,0.62333333,0.20231959,0.62666667,0.20231959,0.63,0.20231959,0.6333333,0.20231959,0.63666666,0.20231959,0.64,0.20231959,0.6433333,0.20231959,0.64666665,0.20231959,0.65,0.20231959,0.6533333,0.20231959,0.6566667,0.20231959,0.66,0.20231959,0.66333336,0.20231959,0.6666667,0.20231959,0.67,0.20231959,0.67333335,0.20231959,0.6766667,0.20231959,0.68,0.20231959,0.68333334,0.20231959,0.68666667,0.20231959,0.69,0.20231959,0.6933333,0.20231959,0.69666666,0.20231959,0.7,0.20231959,0.7033333,0.20231959,0.70666665,0.20231959,0.71,0.20231959,0.7133333,0.20231959,0.71666664,0.20231959,0.72,0.20231959,0.72333336,0.20231959,0.7266667,0.20231959,0.73,0.20231959,0.73333335,0.20231959,0.7366667,0.20231959,0.74,0.20231959,0.74333334,0.20231959,0.74666667,0.20231959,0.75,0.20231959,0.75333333,0.20231959,0.75666666,0.20231959,0.76,0.20231959,0.7633333,0.20231959,0.76666665,0.20231959,0.77,0.20231959,0.7733333,0.20231959,0.77666664,0.20231959,0.78,0.20231959,0.78333336,0.20231959,0.7866667,0.20231959,0.79,0.20231959,0.79333335,0.20231959,0.7966667,0.20231959,0.8,0.20231959,0.80333334,0.20231959,0.8066667,0.20231959,0.81,0.20231959,0.81333333,0.20231959,0.81666666,0.20231959,0.82,0.20231959,0.8233333,0.20231959,0.82666665,0.20231959,0.83,0.20231959,0.8333333,0.20231959,0.83666664,0.20231959,0.84,0.20231959,0.8433333,0.20231959,0.8466667,0.20231959,0.85,0.20231959,0.85333335,0.20231959,0.8566667,0.20231959,0.86,0.20231959,0.86333334,0.20231959,0.8666667,0.20231959,0.87,0.20231959,0.87333333,0.20231959,0.87666667,0.20231959,0.88,0.20231959,0.8833333,0.20231959,0.88666666,0.20231959,0.89,0.20231959,0.8933333,0.20231959,0.89666665,0.20231959,0.9,0.20231959,0.9033333,0.20231959,0.9066667,0.20231959,0.91,0.20231959,0.91333336,0.20231959,0.9166667,0.20231959,0.92,0.20231959,0.92333335,0.20231959,0.9266667,0.20231959,0.93,0.20231959,0.93666667,0.20231959,0.94,0.20231959,0.9433333,0.20231959,0.94666666,0.20231959,0.05,0.20489691,0.053333335,0.20489691,0.05666667,0.20489691,0.06,0.20489691,0.06333333,0.20489691,0.06666667,0.20489691,0.07,0.20489691,0.07333333,0.20489691,0.07666667,0.20489691,0.08,0.20489691,0.083333336,0.20489691,0.086666666,0.20489691,0.09,0.20489691,0.093333334,0.20489691,0.096666664,0.20489691,0.1,0.20489691,0.10333333,0.20489691,0.10666667,0.20489691,0.11,0.20489691,0.11333334,0.20489691,0.11666667,0.20489691,0.12,0.20489691,0.123333335,0.20489691,0.12666667,0.20489691,0.13,0.20489691,0.13333334,0.20489691,0.13666667,0.20489691,0.14,0.20489691,0.14333333,0.20489691,0.14666666,0.20489691,0.15,0.20489691,0.15333334,0.20489691,0.15666667,0.20489691,0.16,0.20489691,0.16333333,0.20489691,0.16666667,0.20489691,0.17,0.20489691,0.17333333,0.20489691,0.17666666,0.20489691,0.18,0.20489691,0.18333334,0.20489691,0.18666667,0.20489691,0.19,0.20489691,0.19333333,0.20489691,0.19666667,0.20489691,0.2,0.20489691,0.20333333,0.20489691,0.20666666,0.20489691,0.21,0.20489691,0.21333334,0.20489691,0.21666667,0.20489691,0.22,0.20489691,0.22333333,0.20489691,0.22666667,0.20489691,0.23,0.20489691,0.23333333,0.20489691,0.23666666,0.20489691,0.24,0.20489691,0.24333334,0.20489691,0.24666667,0.20489691,0.25,0.20489691,0.25333333,0.20489691,0.25666666,0.20489691,0.26,0.20489691,0.26333332,0.20489691,0.26666668,0.20489691,0.27,0.20489691,0.27333334,0.20489691,0.27666667,0.20489691,0.28,0.20489691,0.28333333,0.20489691,0.28666666,0.20489691,0.29,0.20489691,0.29333332,0.20489691,0.29666665,0.20489691,0.3,0.20489691,0.30333334,0.20489691,0.30666667,0.20489691,0.31,0.20489691,0.31333333,0.20489691,0.31666666,0.20489691,0.32,0.20489691,0.32333332,0.20489691,0.32666665,0.20489691,0.33,0.20489691,0.33333334,0.20489691,0.33666667,0.20489691,0.34,0.20489691,0.34333333,0.20489691,0.34666666,0.20489691,0.35,0.20489691,0.35333332,0.20489691,0.35666665,0.20489691,0.36,0.20489691,0.36333334,0.20489691,0.36666667,0.20489691,0.37,0.20489691,0.37333333,0.20489691,0.37666667,0.20489691,0.38,0.20489691,0.38333333,0.20489691,0.38666666,0.20489691,0.39,0.20489691,0.39333335,0.20489691,0.39666668,0.20489691,0.4,0.20489691,0.40333334,0.20489691,0.40666667,0.20489691,0.41,0.20489691,0.41333333,0.20489691,0.41666666,0.20489691,0.42,0.20489691,0.42333335,0.20489691,0.42666668,0.20489691,0.43,0.20489691,0.43333334,0.20489691,0.43666667,0.20489691,0.44,0.20489691,0.44333333,0.20489691,0.44666666,0.20489691,0.45,0.20489691,0.45333335,0.20489691,0.45666668,0.20489691,0.46,0.20489691,0.46333334,0.20489691,0.46666667,0.20489691,0.47,0.20489691,0.47333333,0.20489691,0.47666666,0.20489691,0.48,0.20489691,0.48333332,0.20489691,0.48666668,0.20489691,0.49,0.20489691,0.49333334,0.20489691,0.49666667,0.20489691,0.5,0.20489691,0.50333333,0.20489691,0.50666666,0.20489691,0.51,0.20489691,0.5133333,0.20489691,0.51666665,0.20489691,0.52,0.20489691,0.5233333,0.20489691,0.52666664,0.20489691,0.53,0.20489691,0.53333336,0.20489691,0.5366667,0.20489691,0.54,0.20489691,0.54333335,0.20489691,0.5466667,0.20489691,0.55,0.20489691,0.55333334,0.20489691,0.5566667,0.20489691,0.56,0.20489691,0.56333333,0.20489691,0.56666666,0.20489691,0.57,0.20489691,0.5733333,0.20489691,0.57666665,0.20489691,0.58,0.20489691,0.5833333,0.20489691,0.58666664,0.20489691,0.59,0.20489691,0.5933333,0.20489691,0.5966667,0.20489691,0.6,0.20489691,0.60333335,0.20489691,0.6066667,0.20489691,0.61,0.20489691,0.61333334,0.20489691,0.6166667,0.20489691,0.62,0.20489691,0.62333333,0.20489691,0.62666667,0.20489691,0.63,0.20489691,0.6333333,0.20489691,0.63666666,0.20489691,0.64,0.20489691,0.6433333,0.20489691,0.64666665,0.20489691,0.65,0.20489691,0.6533333,0.20489691,0.6566667,0.20489691,0.66,0.20489691,0.66333336,0.20489691,0.6666667,0.20489691,0.67,0.20489691,0.67333335,0.20489691,0.6766667,0.20489691,0.68,0.20489691,0.68333334,0.20489691,0.68666667,0.20489691,0.69,0.20489691,0.6933333,0.20489691,0.69666666,0.20489691,0.7,0.20489691,0.7033333,0.20489691,0.70666665,0.20489691,0.71,0.20489691,0.7133333,0.20489691,0.71666664,0.20489691,0.72,0.20489691,0.72333336,0.20489691,0.7266667,0.20489691,0.73,0.20489691,0.73333335,0.20489691,0.7366667,0.20489691,0.74,0.20489691,0.74333334,0.20489691,0.74666667,0.20489691,0.75,0.20489691,0.75333333,0.20489691,0.75666666,0.20489691,0.76,0.20489691,0.7633333,0.20489691,0.76666665,0.20489691,0.77,0.20489691,0.7733333,0.20489691,0.77666664,0.20489691,0.78,0.20489691,0.78333336,0.20489691,0.7866667,0.20489691,0.79,0.20489691,0.79333335,0.20489691,0.7966667,0.20489691,0.8,0.20489691,0.80333334,0.20489691,0.8066667,0.20489691,0.81,0.20489691,0.81333333,0.20489691,0.81666666,0.20489691,0.82,0.20489691,0.8233333,0.20489691,0.82666665,0.20489691,0.83,0.20489691,0.8333333,0.20489691,0.83666664,0.20489691,0.84,0.20489691,0.8433333,0.20489691,0.8466667,0.20489691,0.85,0.20489691,0.85333335,0.20489691,0.8566667,0.20489691,0.86,0.20489691,0.86333334,0.20489691,0.8666667,0.20489691,0.87,0.20489691,0.87333333,0.20489691,0.87666667,0.20489691,0.88,0.20489691,0.8833333,0.20489691,0.88666666,0.20489691,0.89,0.20489691,0.8933333,0.20489691,0.89666665,0.20489691,0.9,0.20489691,0.9033333,0.20489691,0.9066667,0.20489691,0.91,0.20489691,0.91333336,0.20489691,0.9166667,0.20489691,0.92,0.20489691,0.92333335,0.20489691,0.9266667,0.20489691,0.93,0.20489691,0.93333334,0.20489691,0.94,0.20489691,0.9433333,0.20489691,0.94666666,0.20489691,0.05,0.20747423,0.053333335,0.20747423,0.05666667,0.20747423,0.06,0.20747423,0.06333333,0.20747423,0.06666667,0.20747423,0.07,0.20747423,0.07333333,0.20747423,0.07666667,0.20747423,0.08,0.20747423,0.083333336,0.20747423,0.086666666,0.20747423,0.09,0.20747423,0.093333334,0.20747423,0.096666664,0.20747423,0.1,0.20747423,0.10333333,0.20747423,0.10666667,0.20747423,0.11,0.20747423,0.11333334,0.20747423,0.11666667,0.20747423,0.12,0.20747423,0.123333335,0.20747423,0.12666667,0.20747423,0.13,0.20747423,0.13333334,0.20747423,0.13666667,0.20747423,0.14,0.20747423,0.14333333,0.20747423,0.14666666,0.20747423,0.15,0.20747423,0.15333334,0.20747423,0.15666667,0.20747423,0.16,0.20747423,0.16333333,0.20747423,0.16666667,0.20747423,0.17,0.20747423,0.17333333,0.20747423,0.17666666,0.20747423,0.18,0.20747423,0.18333334,0.20747423,0.18666667,0.20747423,0.19,0.20747423,0.19333333,0.20747423,0.19666667,0.20747423,0.2,0.20747423,0.20333333,0.20747423,0.20666666,0.20747423,0.21,0.20747423,0.21333334,0.20747423,0.21666667,0.20747423,0.22,0.20747423,0.22333333,0.20747423,0.22666667,0.20747423,0.23,0.20747423,0.23333333,0.20747423,0.23666666,0.20747423,0.24,0.20747423,0.24333334,0.20747423,0.24666667,0.20747423,0.25,0.20747423,0.25333333,0.20747423,0.25666666,0.20747423,0.26,0.20747423,0.26333332,0.20747423,0.26666668,0.20747423,0.27,0.20747423,0.27333334,0.20747423,0.27666667,0.20747423,0.28,0.20747423,0.28333333,0.20747423,0.28666666,0.20747423,0.29,0.20747423,0.29333332,0.20747423,0.29666665,0.20747423,0.3,0.20747423,0.30333334,0.20747423,0.30666667,0.20747423,0.31,0.20747423,0.31333333,0.20747423,0.31666666,0.20747423,0.32,0.20747423,0.32333332,0.20747423,0.32666665,0.20747423,0.33,0.20747423,0.33333334,0.20747423,0.33666667,0.20747423,0.34,0.20747423,0.34333333,0.20747423,0.34666666,0.20747423,0.35,0.20747423,0.35333332,0.20747423,0.35666665,0.20747423,0.36,0.20747423,0.36333334,0.20747423,0.36666667,0.20747423,0.37,0.20747423,0.37333333,0.20747423,0.37666667,0.20747423,0.38,0.20747423,0.38333333,0.20747423,0.38666666,0.20747423,0.39,0.20747423,0.39333335,0.20747423,0.39666668,0.20747423,0.4,0.20747423,0.40333334,0.20747423,0.40666667,0.20747423,0.41,0.20747423,0.41333333,0.20747423,0.41666666,0.20747423,0.42,0.20747423,0.42333335,0.20747423,0.42666668,0.20747423,0.43,0.20747423,0.43333334,0.20747423,0.43666667,0.20747423,0.44,0.20747423,0.44333333,0.20747423,0.44666666,0.20747423,0.45,0.20747423,0.45333335,0.20747423,0.45666668,0.20747423,0.46,0.20747423,0.46333334,0.20747423,0.46666667,0.20747423,0.47,0.20747423,0.47333333,0.20747423,0.47666666,0.20747423,0.48,0.20747423,0.48333332,0.20747423,0.48666668,0.20747423,0.49,0.20747423,0.49333334,0.20747423,0.49666667,0.20747423,0.5,0.20747423,0.50333333,0.20747423,0.50666666,0.20747423,0.51,0.20747423,0.5133333,0.20747423,0.51666665,0.20747423,0.52,0.20747423,0.5233333,0.20747423,0.52666664,0.20747423,0.53,0.20747423,0.53333336,0.20747423,0.5366667,0.20747423,0.54,0.20747423,0.54333335,0.20747423,0.5466667,0.20747423,0.55,0.20747423,0.55333334,0.20747423,0.5566667,0.20747423,0.56,0.20747423,0.56333333,0.20747423,0.56666666,0.20747423,0.57,0.20747423,0.5733333,0.20747423,0.57666665,0.20747423,0.58,0.20747423,0.5833333,0.20747423,0.58666664,0.20747423,0.59,0.20747423,0.5933333,0.20747423,0.5966667,0.20747423,0.6,0.20747423,0.60333335,0.20747423,0.6066667,0.20747423,0.61,0.20747423,0.61333334,0.20747423,0.6166667,0.20747423,0.62,0.20747423,0.62333333,0.20747423,0.62666667,0.20747423,0.63,0.20747423,0.6333333,0.20747423,0.63666666,0.20747423,0.64,0.20747423,0.6433333,0.20747423,0.64666665,0.20747423,0.65,0.20747423,0.6533333,0.20747423,0.6566667,0.20747423,0.66,0.20747423,0.66333336,0.20747423,0.6666667,0.20747423,0.67,0.20747423,0.67333335,0.20747423,0.6766667,0.20747423,0.68,0.20747423,0.68333334,0.20747423,0.68666667,0.20747423,0.69,0.20747423,0.6933333,0.20747423,0.69666666,0.20747423,0.7,0.20747423,0.7033333,0.20747423,0.70666665,0.20747423,0.71,0.20747423,0.7133333,0.20747423,0.71666664,0.20747423,0.72,0.20747423,0.72333336,0.20747423,0.7266667,0.20747423,0.73,0.20747423,0.73333335,0.20747423,0.7366667,0.20747423,0.74,0.20747423,0.74333334,0.20747423,0.74666667,0.20747423,0.75,0.20747423,0.75333333,0.20747423,0.75666666,0.20747423,0.76,0.20747423,0.7633333,0.20747423,0.76666665,0.20747423,0.77,0.20747423,0.7733333,0.20747423,0.77666664,0.20747423,0.78,0.20747423,0.78333336,0.20747423,0.7866667,0.20747423,0.79,0.20747423,0.79333335,0.20747423,0.7966667,0.20747423,0.8,0.20747423,0.80333334,0.20747423,0.8066667,0.20747423,0.81,0.20747423,0.81333333,0.20747423,0.81666666,0.20747423,0.82,0.20747423,0.8233333,0.20747423,0.82666665,0.20747423,0.83,0.20747423,0.8333333,0.20747423,0.83666664,0.20747423,0.84,0.20747423,0.8433333,0.20747423,0.8466667,0.20747423,0.85,0.20747423,0.85333335,0.20747423,0.8566667,0.20747423,0.86,0.20747423,0.86333334,0.20747423,0.8666667,0.20747423,0.87,0.20747423,0.87333333,0.20747423,0.87666667,0.20747423,0.88,0.20747423,0.8833333,0.20747423,0.88666666,0.20747423,0.89,0.20747423,0.8933333,0.20747423,0.89666665,0.20747423,0.9,0.20747423,0.9033333,0.20747423,0.9066667,0.20747423,0.91,0.20747423,0.91333336,0.20747423,0.9166667,0.20747423,0.92,0.20747423,0.92333335,0.20747423,0.9266667,0.20747423,0.93,0.20747423,0.93333334,0.20747423,0.93666667,0.20747423,0.94,0.20747423,0.9433333,0.20747423,0.94666666,0.20747423,0.05,0.21005155,0.053333335,0.21005155,0.05666667,0.21005155,0.06,0.21005155,0.06333333,0.21005155,0.06666667,0.21005155,0.07,0.21005155,0.07333333,0.21005155,0.07666667,0.21005155,0.08,0.21005155,0.083333336,0.21005155,0.086666666,0.21005155,0.09,0.21005155,0.093333334,0.21005155,0.096666664,0.21005155,0.1,0.21005155,0.10333333,0.21005155,0.10666667,0.21005155,0.11,0.21005155,0.11333334,0.21005155,0.11666667,0.21005155,0.12,0.21005155,0.123333335,0.21005155,0.12666667,0.21005155,0.13,0.21005155,0.13333334,0.21005155,0.13666667,0.21005155,0.14,0.21005155,0.14333333,0.21005155,0.14666666,0.21005155,0.15,0.21005155,0.15333334,0.21005155,0.15666667,0.21005155,0.16,0.21005155,0.16333333,0.21005155,0.16666667,0.21005155,0.17,0.21005155,0.17333333,0.21005155,0.17666666,0.21005155,0.18,0.21005155,0.18333334,0.21005155,0.18666667,0.21005155,0.19,0.21005155,0.19333333,0.21005155,0.19666667,0.21005155,0.2,0.21005155,0.20333333,0.21005155,0.20666666,0.21005155,0.21,0.21005155,0.21333334,0.21005155,0.21666667,0.21005155,0.22,0.21005155,0.22333333,0.21005155,0.22666667,0.21005155,0.23,0.21005155,0.23333333,0.21005155,0.23666666,0.21005155,0.24,0.21005155,0.24333334,0.21005155,0.24666667,0.21005155,0.25,0.21005155,0.25333333,0.21005155,0.25666666,0.21005155,0.26,0.21005155,0.26333332,0.21005155,0.26666668,0.21005155,0.27,0.21005155,0.27333334,0.21005155,0.27666667,0.21005155,0.28,0.21005155,0.28333333,0.21005155,0.28666666,0.21005155,0.29,0.21005155,0.29333332,0.21005155,0.29666665,0.21005155,0.3,0.21005155,0.30333334,0.21005155,0.30666667,0.21005155,0.31,0.21005155,0.31333333,0.21005155,0.31666666,0.21005155,0.32,0.21005155,0.32333332,0.21005155,0.32666665,0.21005155,0.33,0.21005155,0.33333334,0.21005155,0.33666667,0.21005155,0.34,0.21005155,0.34333333,0.21005155,0.34666666,0.21005155,0.35,0.21005155,0.35333332,0.21005155,0.35666665,0.21005155,0.36,0.21005155,0.36333334,0.21005155,0.36666667,0.21005155,0.37,0.21005155,0.37333333,0.21005155,0.37666667,0.21005155,0.38,0.21005155,0.38333333,0.21005155,0.38666666,0.21005155,0.39,0.21005155,0.39333335,0.21005155,0.39666668,0.21005155,0.4,0.21005155,0.40333334,0.21005155,0.40666667,0.21005155,0.41,0.21005155,0.41333333,0.21005155,0.41666666,0.21005155,0.42,0.21005155,0.42333335,0.21005155,0.42666668,0.21005155,0.43,0.21005155,0.43333334,0.21005155,0.43666667,0.21005155,0.44,0.21005155,0.44333333,0.21005155,0.44666666,0.21005155,0.45,0.21005155,0.45333335,0.21005155,0.45666668,0.21005155,0.46,0.21005155,0.46333334,0.21005155,0.46666667,0.21005155,0.47,0.21005155,0.47333333,0.21005155,0.47666666,0.21005155,0.48,0.21005155,0.48333332,0.21005155,0.48666668,0.21005155,0.49,0.21005155,0.49333334,0.21005155,0.49666667,0.21005155,0.5,0.21005155,0.50333333,0.21005155,0.50666666,0.21005155,0.51,0.21005155,0.5133333,0.21005155,0.51666665,0.21005155,0.52,0.21005155,0.5233333,0.21005155,0.52666664,0.21005155,0.53,0.21005155,0.53333336,0.21005155,0.5366667,0.21005155,0.54,0.21005155,0.54333335,0.21005155,0.5466667,0.21005155,0.55,0.21005155,0.55333334,0.21005155,0.5566667,0.21005155,0.56,0.21005155,0.56333333,0.21005155,0.56666666,0.21005155,0.57,0.21005155,0.5733333,0.21005155,0.57666665,0.21005155,0.58,0.21005155,0.5833333,0.21005155,0.58666664,0.21005155,0.59,0.21005155,0.5933333,0.21005155,0.5966667,0.21005155,0.6,0.21005155,0.60333335,0.21005155,0.6066667,0.21005155,0.61,0.21005155,0.61333334,0.21005155,0.6166667,0.21005155,0.62,0.21005155,0.62333333,0.21005155,0.62666667,0.21005155,0.63,0.21005155,0.6333333,0.21005155,0.63666666,0.21005155,0.64,0.21005155,0.6433333,0.21005155,0.64666665,0.21005155,0.65,0.21005155,0.6533333,0.21005155,0.6566667,0.21005155,0.66,0.21005155,0.66333336,0.21005155,0.6666667,0.21005155,0.67,0.21005155,0.67333335,0.21005155,0.6766667,0.21005155,0.68,0.21005155,0.68333334,0.21005155,0.68666667,0.21005155,0.69,0.21005155,0.6933333,0.21005155,0.69666666,0.21005155,0.7,0.21005155,0.7033333,0.21005155,0.70666665,0.21005155,0.71,0.21005155,0.7133333,0.21005155,0.71666664,0.21005155,0.72,0.21005155,0.72333336,0.21005155,0.7266667,0.21005155,0.73,0.21005155,0.73333335,0.21005155,0.7366667,0.21005155,0.74,0.21005155,0.74333334,0.21005155,0.74666667,0.21005155,0.75,0.21005155,0.75333333,0.21005155,0.75666666,0.21005155,0.76,0.21005155,0.7633333,0.21005155,0.76666665,0.21005155,0.77,0.21005155,0.7733333,0.21005155,0.77666664,0.21005155,0.78,0.21005155,0.78333336,0.21005155,0.7866667,0.21005155,0.79,0.21005155,0.79333335,0.21005155,0.7966667,0.21005155,0.8,0.21005155,0.80333334,0.21005155,0.8066667,0.21005155,0.81,0.21005155,0.81333333,0.21005155,0.81666666,0.21005155,0.82,0.21005155,0.8233333,0.21005155,0.82666665,0.21005155,0.83,0.21005155,0.8333333,0.21005155,0.83666664,0.21005155,0.84,0.21005155,0.8433333,0.21005155,0.8466667,0.21005155,0.85,0.21005155,0.85333335,0.21005155,0.8566667,0.21005155,0.86,0.21005155,0.86333334,0.21005155,0.8666667,0.21005155,0.87,0.21005155,0.87333333,0.21005155,0.87666667,0.21005155,0.88,0.21005155,0.8833333,0.21005155,0.88666666,0.21005155,0.89,0.21005155,0.8933333,0.21005155,0.89666665,0.21005155,0.9,0.21005155,0.9033333,0.21005155,0.9066667,0.21005155,0.91,0.21005155,0.91333336,0.21005155,0.9166667,0.21005155,0.92,0.21005155,0.92333335,0.21005155,0.9266667,0.21005155,0.93,0.21005155,0.93333334,0.21005155,0.93666667,0.21005155,0.94,0.21005155,0.9433333,0.21005155,0.94666666,0.21005155,0.05,0.21262887,0.053333335,0.21262887,0.05666667,0.21262887,0.06,0.21262887,0.06333333,0.21262887,0.06666667,0.21262887,0.07,0.21262887,0.07333333,0.21262887,0.07666667,0.21262887,0.08,0.21262887,0.083333336,0.21262887,0.086666666,0.21262887,0.09,0.21262887,0.093333334,0.21262887,0.096666664,0.21262887,0.1,0.21262887,0.10333333,0.21262887,0.10666667,0.21262887,0.11,0.21262887,0.11333334,0.21262887,0.11666667,0.21262887,0.12,0.21262887,0.123333335,0.21262887,0.12666667,0.21262887,0.13,0.21262887,0.13333334,0.21262887,0.13666667,0.21262887,0.14,0.21262887,0.14333333,0.21262887,0.14666666,0.21262887,0.15,0.21262887,0.15333334,0.21262887,0.15666667,0.21262887,0.16,0.21262887,0.16333333,0.21262887,0.16666667,0.21262887,0.17,0.21262887,0.17333333,0.21262887,0.17666666,0.21262887,0.18,0.21262887,0.18333334,0.21262887,0.18666667,0.21262887,0.19,0.21262887,0.19333333,0.21262887,0.19666667,0.21262887,0.2,0.21262887,0.20333333,0.21262887,0.20666666,0.21262887,0.21,0.21262887,0.21333334,0.21262887,0.21666667,0.21262887,0.22,0.21262887,0.22333333,0.21262887,0.22666667,0.21262887,0.23,0.21262887,0.23333333,0.21262887,0.23666666,0.21262887,0.24,0.21262887,0.24333334,0.21262887,0.24666667,0.21262887,0.25,0.21262887,0.25333333,0.21262887,0.25666666,0.21262887,0.26,0.21262887,0.26333332,0.21262887,0.26666668,0.21262887,0.27,0.21262887,0.27333334,0.21262887,0.27666667,0.21262887,0.28,0.21262887,0.28333333,0.21262887,0.28666666,0.21262887,0.29,0.21262887,0.29333332,0.21262887,0.29666665,0.21262887,0.3,0.21262887,0.30333334,0.21262887,0.30666667,0.21262887,0.31,0.21262887,0.31333333,0.21262887,0.31666666,0.21262887,0.32,0.21262887,0.32333332,0.21262887,0.32666665,0.21262887,0.33,0.21262887,0.33333334,0.21262887,0.33666667,0.21262887,0.34,0.21262887,0.34333333,0.21262887,0.34666666,0.21262887,0.35,0.21262887,0.35333332,0.21262887,0.35666665,0.21262887,0.36,0.21262887,0.36333334,0.21262887,0.36666667,0.21262887,0.37,0.21262887,0.37333333,0.21262887,0.37666667,0.21262887,0.38,0.21262887,0.38333333,0.21262887,0.38666666,0.21262887,0.39,0.21262887,0.39333335,0.21262887,0.39666668,0.21262887,0.4,0.21262887,0.40333334,0.21262887,0.40666667,0.21262887,0.41,0.21262887,0.41333333,0.21262887,0.41666666,0.21262887,0.42,0.21262887,0.42333335,0.21262887,0.42666668,0.21262887,0.43,0.21262887,0.43333334,0.21262887,0.43666667,0.21262887,0.44,0.21262887,0.44333333,0.21262887,0.44666666,0.21262887,0.45,0.21262887,0.45333335,0.21262887,0.45666668,0.21262887,0.46,0.21262887,0.46333334,0.21262887,0.46666667,0.21262887,0.47,0.21262887,0.47333333,0.21262887,0.47666666,0.21262887,0.48,0.21262887,0.48333332,0.21262887,0.48666668,0.21262887,0.49,0.21262887,0.49333334,0.21262887,0.49666667,0.21262887,0.5,0.21262887,0.50333333,0.21262887,0.50666666,0.21262887,0.51,0.21262887,0.5133333,0.21262887,0.51666665,0.21262887,0.52,0.21262887,0.5233333,0.21262887,0.52666664,0.21262887,0.53,0.21262887,0.53333336,0.21262887,0.5366667,0.21262887,0.54,0.21262887,0.54333335,0.21262887,0.5466667,0.21262887,0.55,0.21262887,0.55333334,0.21262887,0.5566667,0.21262887,0.56,0.21262887,0.56333333,0.21262887,0.56666666,0.21262887,0.57,0.21262887,0.5733333,0.21262887,0.57666665,0.21262887,0.58,0.21262887,0.5833333,0.21262887,0.58666664,0.21262887,0.59,0.21262887,0.5933333,0.21262887,0.5966667,0.21262887,0.6,0.21262887,0.60333335,0.21262887,0.6066667,0.21262887,0.61,0.21262887,0.61333334,0.21262887,0.6166667,0.21262887,0.62,0.21262887,0.62333333,0.21262887,0.62666667,0.21262887,0.63,0.21262887,0.6333333,0.21262887,0.63666666,0.21262887,0.64,0.21262887,0.6433333,0.21262887,0.64666665,0.21262887,0.65,0.21262887,0.6533333,0.21262887,0.6566667,0.21262887,0.66,0.21262887,0.66333336,0.21262887,0.6666667,0.21262887,0.67,0.21262887,0.67333335,0.21262887,0.6766667,0.21262887,0.68,0.21262887,0.68333334,0.21262887,0.68666667,0.21262887,0.69,0.21262887,0.6933333,0.21262887,0.69666666,0.21262887,0.7,0.21262887,0.7033333,0.21262887,0.70666665,0.21262887,0.71,0.21262887,0.7133333,0.21262887,0.71666664,0.21262887,0.72,0.21262887,0.72333336,0.21262887,0.7266667,0.21262887,0.73,0.21262887,0.73333335,0.21262887,0.7366667,0.21262887,0.74,0.21262887,0.74333334,0.21262887,0.74666667,0.21262887,0.75,0.21262887,0.75333333,0.21262887,0.75666666,0.21262887,0.76,0.21262887,0.7633333,0.21262887,0.76666665,0.21262887,0.77,0.21262887,0.7733333,0.21262887,0.77666664,0.21262887,0.78,0.21262887,0.78333336,0.21262887,0.7866667,0.21262887,0.79,0.21262887,0.79333335,0.21262887,0.7966667,0.21262887,0.8,0.21262887,0.80333334,0.21262887,0.8066667,0.21262887,0.81,0.21262887,0.81333333,0.21262887,0.81666666,0.21262887,0.8233333,0.21262887,0.82666665,0.21262887,0.83,0.21262887,0.8333333,0.21262887,0.83666664,0.21262887,0.84,0.21262887,0.8433333,0.21262887,0.8466667,0.21262887,0.85,0.21262887,0.85333335,0.21262887,0.8566667,0.21262887,0.86,0.21262887,0.86333334,0.21262887,0.8666667,0.21262887,0.87,0.21262887,0.87333333,0.21262887,0.87666667,0.21262887,0.88,0.21262887,0.8833333,0.21262887,0.88666666,0.21262887,0.89,0.21262887,0.8933333,0.21262887,0.89666665,0.21262887,0.9,0.21262887,0.9033333,0.21262887,0.9066667,0.21262887,0.91,0.21262887,0.91333336,0.21262887,0.9166667,0.21262887,0.92,0.21262887,0.92333335,0.21262887,0.9266667,0.21262887,0.93,0.21262887,0.93333334,0.21262887,0.93666667,0.21262887,0.94,0.21262887,0.9433333,0.21262887,0.05,0.21520619,0.053333335,0.21520619,0.05666667,0.21520619,0.06,0.21520619,0.06333333,0.21520619,0.06666667,0.21520619,0.07,0.21520619,0.07333333,0.21520619,0.07666667,0.21520619,0.08,0.21520619,0.083333336,0.21520619,0.086666666,0.21520619,0.09,0.21520619,0.093333334,0.21520619,0.096666664,0.21520619,0.1,0.21520619,0.10333333,0.21520619,0.10666667,0.21520619,0.11,0.21520619,0.11333334,0.21520619,0.11666667,0.21520619,0.12,0.21520619,0.123333335,0.21520619,0.12666667,0.21520619,0.13,0.21520619,0.13333334,0.21520619,0.13666667,0.21520619,0.14,0.21520619,0.14333333,0.21520619,0.14666666,0.21520619,0.15,0.21520619,0.15333334,0.21520619,0.15666667,0.21520619,0.16,0.21520619,0.16333333,0.21520619,0.16666667,0.21520619,0.17,0.21520619,0.17333333,0.21520619,0.17666666,0.21520619,0.18,0.21520619,0.18333334,0.21520619,0.18666667,0.21520619,0.19,0.21520619,0.19333333,0.21520619,0.19666667,0.21520619,0.2,0.21520619,0.20333333,0.21520619,0.20666666,0.21520619,0.21,0.21520619,0.21333334,0.21520619,0.21666667,0.21520619,0.22,0.21520619,0.22333333,0.21520619,0.22666667,0.21520619,0.23,0.21520619,0.23333333,0.21520619,0.23666666,0.21520619,0.24,0.21520619,0.24333334,0.21520619,0.24666667,0.21520619,0.25,0.21520619,0.25333333,0.21520619,0.25666666,0.21520619,0.26,0.21520619,0.26333332,0.21520619,0.26666668,0.21520619,0.27,0.21520619,0.27333334,0.21520619,0.27666667,0.21520619,0.28,0.21520619,0.28333333,0.21520619,0.28666666,0.21520619,0.29,0.21520619,0.29333332,0.21520619,0.29666665,0.21520619,0.3,0.21520619,0.30333334,0.21520619,0.30666667,0.21520619,0.31,0.21520619,0.31333333,0.21520619,0.31666666,0.21520619,0.32,0.21520619,0.32333332,0.21520619,0.32666665,0.21520619,0.33,0.21520619,0.33333334,0.21520619,0.33666667,0.21520619,0.34,0.21520619,0.34333333,0.21520619,0.34666666,0.21520619,0.35,0.21520619,0.35333332,0.21520619,0.35666665,0.21520619,0.36,0.21520619,0.36333334,0.21520619,0.36666667,0.21520619,0.37,0.21520619,0.37333333,0.21520619,0.37666667,0.21520619,0.38,0.21520619,0.38333333,0.21520619,0.38666666,0.21520619,0.39,0.21520619,0.39333335,0.21520619,0.39666668,0.21520619,0.4,0.21520619,0.40333334,0.21520619,0.40666667,0.21520619,0.41,0.21520619,0.41333333,0.21520619,0.41666666,0.21520619,0.42,0.21520619,0.42333335,0.21520619,0.42666668,0.21520619,0.43,0.21520619,0.43333334,0.21520619,0.43666667,0.21520619,0.44,0.21520619,0.44333333,0.21520619,0.44666666,0.21520619,0.45,0.21520619,0.45333335,0.21520619,0.45666668,0.21520619,0.46,0.21520619,0.46333334,0.21520619,0.46666667,0.21520619,0.47,0.21520619,0.47333333,0.21520619,0.47666666,0.21520619,0.48,0.21520619,0.48333332,0.21520619,0.48666668,0.21520619,0.49,0.21520619,0.49333334,0.21520619,0.49666667,0.21520619,0.5,0.21520619,0.50333333,0.21520619,0.50666666,0.21520619,0.51,0.21520619,0.5133333,0.21520619,0.51666665,0.21520619,0.52,0.21520619,0.5233333,0.21520619,0.52666664,0.21520619,0.53,0.21520619,0.53333336,0.21520619,0.5366667,0.21520619,0.54,0.21520619,0.54333335,0.21520619,0.5466667,0.21520619,0.55,0.21520619,0.55333334,0.21520619,0.5566667,0.21520619,0.56,0.21520619,0.56333333,0.21520619,0.56666666,0.21520619,0.57,0.21520619,0.5733333,0.21520619,0.57666665,0.21520619,0.58,0.21520619,0.5833333,0.21520619,0.58666664,0.21520619,0.59,0.21520619,0.5933333,0.21520619,0.5966667,0.21520619,0.6,0.21520619,0.60333335,0.21520619,0.6066667,0.21520619,0.61,0.21520619,0.61333334,0.21520619,0.6166667,0.21520619,0.62,0.21520619,0.62333333,0.21520619,0.62666667,0.21520619,0.63,0.21520619,0.6333333,0.21520619,0.63666666,0.21520619,0.64,0.21520619,0.6433333,0.21520619,0.64666665,0.21520619,0.65,0.21520619,0.6533333,0.21520619,0.6566667,0.21520619,0.66,0.21520619,0.66333336,0.21520619,0.6666667,0.21520619,0.67,0.21520619,0.67333335,0.21520619,0.6766667,0.21520619,0.68,0.21520619,0.68333334,0.21520619,0.68666667,0.21520619,0.69,0.21520619,0.6933333,0.21520619,0.69666666,0.21520619,0.7,0.21520619,0.7033333,0.21520619,0.70666665,0.21520619,0.71,0.21520619,0.7133333,0.21520619,0.71666664,0.21520619,0.72,0.21520619,0.72333336,0.21520619,0.7266667,0.21520619,0.73,0.21520619,0.73333335,0.21520619,0.7366667,0.21520619,0.74,0.21520619,0.74333334,0.21520619,0.74666667,0.21520619,0.75,0.21520619,0.75333333,0.21520619,0.75666666,0.21520619,0.76,0.21520619,0.7633333,0.21520619,0.76666665,0.21520619,0.77,0.21520619,0.7733333,0.21520619,0.77666664,0.21520619,0.78,0.21520619,0.78333336,0.21520619,0.7866667,0.21520619,0.79,0.21520619,0.79333335,0.21520619,0.7966667,0.21520619,0.8,0.21520619,0.80333334,0.21520619,0.8066667,0.21520619,0.81,0.21520619,0.81333333,0.21520619,0.81666666,0.21520619,0.82,0.21520619,0.8233333,0.21520619,0.82666665,0.21520619,0.83,0.21520619,0.8333333,0.21520619,0.83666664,0.21520619,0.84,0.21520619,0.8433333,0.21520619,0.8466667,0.21520619,0.85,0.21520619,0.85333335,0.21520619,0.8566667,0.21520619,0.86,0.21520619,0.86333334,0.21520619,0.8666667,0.21520619,0.87,0.21520619,0.87333333,0.21520619,0.87666667,0.21520619,0.88,0.21520619,0.8833333,0.21520619,0.88666666,0.21520619,0.89,0.21520619,0.8933333,0.21520619,0.89666665,0.21520619,0.9,0.21520619,0.9033333,0.21520619,0.9066667,0.21520619,0.91,0.21520619,0.91333336,0.21520619,0.9166667,0.21520619,0.92,0.21520619,0.92333335,0.21520619,0.9266667,0.21520619,0.93,0.21520619,0.93333334,0.21520619,0.93666667,0.21520619,0.94,0.21520619,0.9433333,0.21520619,0.94666666,0.21520619,0.05,0.21778351,0.053333335,0.21778351,0.05666667,0.21778351,0.06,0.21778351,0.06333333,0.21778351,0.06666667,0.21778351,0.07,0.21778351,0.07333333,0.21778351,0.07666667,0.21778351,0.08,0.21778351,0.083333336,0.21778351,0.086666666,0.21778351,0.09,0.21778351,0.093333334,0.21778351,0.096666664,0.21778351,0.1,0.21778351,0.10333333,0.21778351,0.10666667,0.21778351,0.11,0.21778351,0.11333334,0.21778351,0.11666667,0.21778351,0.12,0.21778351,0.123333335,0.21778351,0.12666667,0.21778351,0.13,0.21778351,0.13333334,0.21778351,0.13666667,0.21778351,0.14,0.21778351,0.14333333,0.21778351,0.14666666,0.21778351,0.15,0.21778351,0.15333334,0.21778351,0.15666667,0.21778351,0.16,0.21778351,0.16333333,0.21778351,0.16666667,0.21778351,0.17,0.21778351,0.17333333,0.21778351,0.17666666,0.21778351,0.18,0.21778351,0.18333334,0.21778351,0.18666667,0.21778351,0.19,0.21778351,0.19333333,0.21778351,0.19666667,0.21778351,0.2,0.21778351,0.20333333,0.21778351,0.20666666,0.21778351,0.21,0.21778351,0.21333334,0.21778351,0.21666667,0.21778351,0.22,0.21778351,0.22333333,0.21778351,0.22666667,0.21778351,0.23,0.21778351,0.23333333,0.21778351,0.23666666,0.21778351,0.24,0.21778351,0.24333334,0.21778351,0.24666667,0.21778351,0.25,0.21778351,0.25333333,0.21778351,0.25666666,0.21778351,0.26,0.21778351,0.26333332,0.21778351,0.26666668,0.21778351,0.27,0.21778351,0.27333334,0.21778351,0.27666667,0.21778351,0.28,0.21778351,0.28333333,0.21778351,0.28666666,0.21778351,0.29,0.21778351,0.29333332,0.21778351,0.29666665,0.21778351,0.3,0.21778351,0.30333334,0.21778351,0.30666667,0.21778351,0.31,0.21778351,0.31333333,0.21778351,0.31666666,0.21778351,0.32,0.21778351,0.32333332,0.21778351,0.32666665,0.21778351,0.33,0.21778351,0.33333334,0.21778351,0.33666667,0.21778351,0.34,0.21778351,0.34333333,0.21778351,0.34666666,0.21778351,0.35,0.21778351,0.35333332,0.21778351,0.35666665,0.21778351,0.36,0.21778351,0.36333334,0.21778351,0.36666667,0.21778351,0.37,0.21778351,0.37333333,0.21778351,0.37666667,0.21778351,0.38,0.21778351,0.38333333,0.21778351,0.38666666,0.21778351,0.39,0.21778351,0.39333335,0.21778351,0.39666668,0.21778351,0.4,0.21778351,0.40333334,0.21778351,0.40666667,0.21778351,0.41,0.21778351,0.41333333,0.21778351,0.41666666,0.21778351,0.42,0.21778351,0.42333335,0.21778351,0.42666668,0.21778351,0.43,0.21778351,0.43333334,0.21778351,0.43666667,0.21778351,0.44,0.21778351,0.44333333,0.21778351,0.44666666,0.21778351,0.45,0.21778351,0.45333335,0.21778351,0.45666668,0.21778351,0.46,0.21778351,0.46333334,0.21778351,0.46666667,0.21778351,0.47,0.21778351,0.47333333,0.21778351,0.47666666,0.21778351,0.48,0.21778351,0.48333332,0.21778351,0.48666668,0.21778351,0.49,0.21778351,0.49333334,0.21778351,0.49666667,0.21778351,0.5,0.21778351,0.50333333,0.21778351,0.50666666,0.21778351,0.51,0.21778351,0.5133333,0.21778351,0.51666665,0.21778351,0.52,0.21778351,0.5233333,0.21778351,0.52666664,0.21778351,0.53,0.21778351,0.53333336,0.21778351,0.5366667,0.21778351,0.54,0.21778351,0.54333335,0.21778351,0.5466667,0.21778351,0.55,0.21778351,0.55333334,0.21778351,0.5566667,0.21778351,0.56,0.21778351,0.56333333,0.21778351,0.56666666,0.21778351,0.57,0.21778351,0.5733333,0.21778351,0.57666665,0.21778351,0.58,0.21778351,0.5833333,0.21778351,0.58666664,0.21778351,0.59,0.21778351,0.5933333,0.21778351,0.5966667,0.21778351,0.6,0.21778351,0.60333335,0.21778351,0.6066667,0.21778351,0.61,0.21778351,0.61333334,0.21778351,0.6166667,0.21778351,0.62,0.21778351,0.62333333,0.21778351,0.62666667,0.21778351,0.63,0.21778351,0.6333333,0.21778351,0.63666666,0.21778351,0.64,0.21778351,0.6433333,0.21778351,0.64666665,0.21778351,0.65,0.21778351,0.6533333,0.21778351,0.6566667,0.21778351,0.66,0.21778351,0.66333336,0.21778351,0.6666667,0.21778351,0.67,0.21778351,0.67333335,0.21778351,0.6766667,0.21778351,0.68,0.21778351,0.68333334,0.21778351,0.68666667,0.21778351,0.69,0.21778351,0.6933333,0.21778351,0.69666666,0.21778351,0.7,0.21778351,0.7033333,0.21778351,0.70666665,0.21778351,0.71,0.21778351,0.7133333,0.21778351,0.71666664,0.21778351,0.72,0.21778351,0.72333336,0.21778351,0.7266667,0.21778351,0.73,0.21778351,0.73333335,0.21778351,0.7366667,0.21778351,0.74,0.21778351,0.74333334,0.21778351,0.74666667,0.21778351,0.75,0.21778351,0.75333333,0.21778351,0.75666666,0.21778351,0.76,0.21778351,0.7633333,0.21778351,0.76666665,0.21778351,0.77,0.21778351,0.7733333,0.21778351,0.77666664,0.21778351,0.78,0.21778351,0.78333336,0.21778351,0.7866667,0.21778351,0.79,0.21778351,0.79333335,0.21778351,0.7966667,0.21778351,0.8,0.21778351,0.80333334,0.21778351,0.8066667,0.21778351,0.81,0.21778351,0.81333333,0.21778351,0.82,0.21778351,0.8233333,0.21778351,0.82666665,0.21778351,0.83,0.21778351,0.8333333,0.21778351,0.83666664,0.21778351,0.84,0.21778351,0.8433333,0.21778351,0.8466667,0.21778351,0.85,0.21778351,0.85333335,0.21778351,0.8566667,0.21778351,0.86,0.21778351,0.86333334,0.21778351,0.8666667,0.21778351,0.87,0.21778351,0.87333333,0.21778351,0.87666667,0.21778351,0.88,0.21778351,0.8833333,0.21778351,0.88666666,0.21778351,0.89,0.21778351,0.8933333,0.21778351,0.89666665,0.21778351,0.9,0.21778351,0.9033333,0.21778351,0.9066667,0.21778351,0.91,0.21778351,0.91333336,0.21778351,0.9166667,0.21778351,0.92,0.21778351,0.92333335,0.21778351,0.9266667,0.21778351,0.93,0.21778351,0.93333334,0.21778351,0.93666667,0.21778351,0.94,0.21778351,0.9433333,0.21778351,0.94666666,0.21778351,0.05,0.22036083,0.053333335,0.22036083,0.05666667,0.22036083,0.06,0.22036083,0.06333333,0.22036083,0.06666667,0.22036083,0.07,0.22036083,0.07333333,0.22036083,0.07666667,0.22036083,0.08,0.22036083,0.083333336,0.22036083,0.086666666,0.22036083,0.09,0.22036083,0.093333334,0.22036083,0.096666664,0.22036083,0.1,0.22036083,0.10333333,0.22036083,0.10666667,0.22036083,0.11,0.22036083,0.11333334,0.22036083,0.11666667,0.22036083,0.12,0.22036083,0.123333335,0.22036083,0.12666667,0.22036083,0.13,0.22036083,0.13333334,0.22036083,0.13666667,0.22036083,0.14,0.22036083,0.14333333,0.22036083,0.14666666,0.22036083,0.15,0.22036083,0.15333334,0.22036083,0.15666667,0.22036083,0.16,0.22036083,0.16333333,0.22036083,0.16666667,0.22036083,0.17,0.22036083,0.17333333,0.22036083,0.17666666,0.22036083,0.18,0.22036083,0.18333334,0.22036083,0.18666667,0.22036083,0.19,0.22036083,0.19333333,0.22036083,0.19666667,0.22036083,0.2,0.22036083,0.20333333,0.22036083,0.20666666,0.22036083,0.21,0.22036083,0.21333334,0.22036083,0.21666667,0.22036083,0.22,0.22036083,0.22333333,0.22036083,0.22666667,0.22036083,0.23,0.22036083,0.23333333,0.22036083,0.23666666,0.22036083,0.24,0.22036083,0.24333334,0.22036083,0.24666667,0.22036083,0.25,0.22036083,0.25333333,0.22036083,0.25666666,0.22036083,0.26,0.22036083,0.26333332,0.22036083,0.26666668,0.22036083,0.27,0.22036083,0.27333334,0.22036083,0.27666667,0.22036083,0.28,0.22036083,0.28333333,0.22036083,0.28666666,0.22036083,0.29,0.22036083,0.29333332,0.22036083,0.29666665,0.22036083,0.3,0.22036083,0.30333334,0.22036083,0.30666667,0.22036083,0.31,0.22036083,0.31333333,0.22036083,0.31666666,0.22036083,0.32,0.22036083,0.32333332,0.22036083,0.32666665,0.22036083,0.33,0.22036083,0.33333334,0.22036083,0.33666667,0.22036083,0.34,0.22036083,0.34333333,0.22036083,0.34666666,0.22036083,0.35,0.22036083,0.35333332,0.22036083,0.35666665,0.22036083,0.36,0.22036083,0.36333334,0.22036083,0.36666667,0.22036083,0.37,0.22036083,0.37333333,0.22036083,0.37666667,0.22036083,0.38,0.22036083,0.38333333,0.22036083,0.38666666,0.22036083,0.39,0.22036083,0.39333335,0.22036083,0.39666668,0.22036083,0.4,0.22036083,0.40333334,0.22036083,0.40666667,0.22036083,0.41,0.22036083,0.41333333,0.22036083,0.41666666,0.22036083,0.42,0.22036083,0.42333335,0.22036083,0.42666668,0.22036083,0.43,0.22036083,0.43333334,0.22036083,0.43666667,0.22036083,0.44,0.22036083,0.44333333,0.22036083,0.44666666,0.22036083,0.45,0.22036083,0.45333335,0.22036083,0.45666668,0.22036083,0.46,0.22036083,0.46333334,0.22036083,0.46666667,0.22036083,0.47,0.22036083,0.47333333,0.22036083,0.47666666,0.22036083,0.48,0.22036083,0.48333332,0.22036083,0.48666668,0.22036083,0.49,0.22036083,0.49333334,0.22036083,0.49666667,0.22036083,0.5,0.22036083,0.50333333,0.22036083,0.50666666,0.22036083,0.51,0.22036083,0.5133333,0.22036083,0.51666665,0.22036083,0.52,0.22036083,0.5233333,0.22036083,0.52666664,0.22036083,0.53,0.22036083,0.53333336,0.22036083,0.5366667,0.22036083,0.54,0.22036083,0.54333335,0.22036083,0.5466667,0.22036083,0.55,0.22036083,0.55333334,0.22036083,0.5566667,0.22036083,0.56,0.22036083,0.56333333,0.22036083,0.56666666,0.22036083,0.57,0.22036083,0.5733333,0.22036083,0.57666665,0.22036083,0.58,0.22036083,0.5833333,0.22036083,0.58666664,0.22036083,0.59,0.22036083,0.5933333,0.22036083,0.5966667,0.22036083,0.6,0.22036083,0.60333335,0.22036083,0.6066667,0.22036083,0.61,0.22036083,0.61333334,0.22036083,0.6166667,0.22036083,0.62,0.22036083,0.62333333,0.22036083,0.62666667,0.22036083,0.63,0.22036083,0.6333333,0.22036083,0.63666666,0.22036083,0.64,0.22036083,0.6433333,0.22036083,0.64666665,0.22036083,0.65,0.22036083,0.6533333,0.22036083,0.6566667,0.22036083,0.66,0.22036083,0.66333336,0.22036083,0.6666667,0.22036083,0.67,0.22036083,0.67333335,0.22036083,0.6766667,0.22036083,0.68,0.22036083,0.68333334,0.22036083,0.68666667,0.22036083,0.69,0.22036083,0.6933333,0.22036083,0.69666666,0.22036083,0.7,0.22036083,0.7033333,0.22036083,0.70666665,0.22036083,0.71,0.22036083,0.7133333,0.22036083,0.71666664,0.22036083,0.72,0.22036083,0.72333336,0.22036083,0.7266667,0.22036083,0.73,0.22036083,0.73333335,0.22036083,0.7366667,0.22036083,0.74,0.22036083,0.74333334,0.22036083,0.74666667,0.22036083,0.75,0.22036083,0.75333333,0.22036083,0.75666666,0.22036083,0.76,0.22036083,0.7633333,0.22036083,0.76666665,0.22036083,0.77,0.22036083,0.7733333,0.22036083,0.77666664,0.22036083,0.78,0.22036083,0.78333336,0.22036083,0.7866667,0.22036083,0.79,0.22036083,0.79333335,0.22036083,0.7966667,0.22036083,0.8,0.22036083,0.80333334,0.22036083,0.8066667,0.22036083,0.81,0.22036083,0.81666666,0.22036083,0.82,0.22036083,0.8233333,0.22036083,0.82666665,0.22036083,0.83,0.22036083,0.8333333,0.22036083,0.83666664,0.22036083,0.84,0.22036083,0.8433333,0.22036083,0.8466667,0.22036083,0.85,0.22036083,0.85333335,0.22036083,0.8566667,0.22036083,0.86,0.22036083,0.86333334,0.22036083,0.8666667,0.22036083,0.87,0.22036083,0.87333333,0.22036083,0.87666667,0.22036083,0.88,0.22036083,0.8833333,0.22036083,0.88666666,0.22036083,0.89,0.22036083,0.8933333,0.22036083,0.89666665,0.22036083,0.9,0.22036083,0.9033333,0.22036083,0.9066667,0.22036083,0.91,0.22036083,0.91333336,0.22036083,0.9166667,0.22036083,0.92,0.22036083,0.92333335,0.22036083,0.9266667,0.22036083,0.93,0.22036083,0.93333334,0.22036083,0.93666667,0.22036083,0.94,0.22036083,0.9433333,0.22036083,0.94666666,0.22036083,0.05,0.22293815,0.053333335,0.22293815,0.05666667,0.22293815,0.06,0.22293815,0.06333333,0.22293815,0.06666667,0.22293815,0.07,0.22293815,0.07333333,0.22293815,0.07666667,0.22293815,0.08,0.22293815,0.083333336,0.22293815,0.086666666,0.22293815,0.09,0.22293815,0.093333334,0.22293815,0.096666664,0.22293815,0.1,0.22293815,0.10333333,0.22293815,0.10666667,0.22293815,0.11,0.22293815,0.11333334,0.22293815,0.11666667,0.22293815,0.12,0.22293815,0.123333335,0.22293815,0.12666667,0.22293815,0.13,0.22293815,0.13333334,0.22293815,0.13666667,0.22293815,0.14,0.22293815,0.14333333,0.22293815,0.14666666,0.22293815,0.15,0.22293815,0.15333334,0.22293815,0.15666667,0.22293815,0.16,0.22293815,0.16333333,0.22293815,0.16666667,0.22293815,0.17,0.22293815,0.17333333,0.22293815,0.17666666,0.22293815,0.18,0.22293815,0.18333334,0.22293815,0.18666667,0.22293815,0.19,0.22293815,0.19333333,0.22293815,0.19666667,0.22293815,0.2,0.22293815,0.20333333,0.22293815,0.20666666,0.22293815,0.21,0.22293815,0.21333334,0.22293815,0.21666667,0.22293815,0.22,0.22293815,0.22333333,0.22293815,0.22666667,0.22293815,0.23,0.22293815,0.23333333,0.22293815,0.23666666,0.22293815,0.24,0.22293815,0.24333334,0.22293815,0.24666667,0.22293815,0.25,0.22293815,0.25333333,0.22293815,0.25666666,0.22293815,0.26,0.22293815,0.26333332,0.22293815,0.26666668,0.22293815,0.27,0.22293815,0.27333334,0.22293815,0.27666667,0.22293815,0.28,0.22293815,0.28333333,0.22293815,0.28666666,0.22293815,0.29,0.22293815,0.29333332,0.22293815,0.29666665,0.22293815,0.3,0.22293815,0.30333334,0.22293815,0.30666667,0.22293815,0.31,0.22293815,0.31333333,0.22293815,0.31666666,0.22293815,0.32,0.22293815,0.32333332,0.22293815,0.32666665,0.22293815,0.33,0.22293815,0.33333334,0.22293815,0.33666667,0.22293815,0.34,0.22293815,0.34333333,0.22293815,0.34666666,0.22293815,0.35,0.22293815,0.35333332,0.22293815,0.35666665,0.22293815,0.36,0.22293815,0.36333334,0.22293815,0.36666667,0.22293815,0.37,0.22293815,0.37333333,0.22293815,0.37666667,0.22293815,0.38,0.22293815,0.38333333,0.22293815,0.38666666,0.22293815,0.39,0.22293815,0.39333335,0.22293815,0.39666668,0.22293815,0.4,0.22293815,0.40333334,0.22293815,0.40666667,0.22293815,0.41,0.22293815,0.41333333,0.22293815,0.41666666,0.22293815,0.42,0.22293815,0.42333335,0.22293815,0.42666668,0.22293815,0.43,0.22293815,0.43333334,0.22293815,0.43666667,0.22293815,0.44,0.22293815,0.44333333,0.22293815,0.44666666,0.22293815,0.45,0.22293815,0.45333335,0.22293815,0.45666668,0.22293815,0.46,0.22293815,0.46333334,0.22293815,0.46666667,0.22293815,0.47,0.22293815,0.47333333,0.22293815,0.47666666,0.22293815,0.48,0.22293815,0.48333332,0.22293815,0.48666668,0.22293815,0.49,0.22293815,0.49333334,0.22293815,0.49666667,0.22293815,0.5,0.22293815,0.50333333,0.22293815,0.50666666,0.22293815,0.51,0.22293815,0.5133333,0.22293815,0.51666665,0.22293815,0.52,0.22293815,0.5233333,0.22293815,0.52666664,0.22293815,0.53,0.22293815,0.53333336,0.22293815,0.5366667,0.22293815,0.54,0.22293815,0.54333335,0.22293815,0.5466667,0.22293815,0.55,0.22293815,0.55333334,0.22293815,0.5566667,0.22293815,0.56,0.22293815,0.56333333,0.22293815,0.56666666,0.22293815,0.57,0.22293815,0.5733333,0.22293815,0.57666665,0.22293815,0.58,0.22293815,0.5833333,0.22293815,0.58666664,0.22293815,0.59,0.22293815,0.5933333,0.22293815,0.5966667,0.22293815,0.6,0.22293815,0.60333335,0.22293815,0.6066667,0.22293815,0.61,0.22293815,0.61333334,0.22293815,0.6166667,0.22293815,0.62,0.22293815,0.62333333,0.22293815,0.62666667,0.22293815,0.63,0.22293815,0.6333333,0.22293815,0.63666666,0.22293815,0.64,0.22293815,0.6433333,0.22293815,0.64666665,0.22293815,0.65,0.22293815,0.6533333,0.22293815,0.6566667,0.22293815,0.66,0.22293815,0.66333336,0.22293815,0.6666667,0.22293815,0.67,0.22293815,0.67333335,0.22293815,0.6766667,0.22293815,0.68,0.22293815,0.68333334,0.22293815,0.68666667,0.22293815,0.69,0.22293815,0.6933333,0.22293815,0.69666666,0.22293815,0.7,0.22293815,0.7033333,0.22293815,0.70666665,0.22293815,0.71,0.22293815,0.7133333,0.22293815,0.71666664,0.22293815,0.72,0.22293815,0.72333336,0.22293815,0.7266667,0.22293815,0.73,0.22293815,0.73333335,0.22293815,0.7366667,0.22293815,0.74,0.22293815,0.74333334,0.22293815,0.74666667,0.22293815,0.75,0.22293815,0.75333333,0.22293815,0.75666666,0.22293815,0.76,0.22293815,0.7633333,0.22293815,0.76666665,0.22293815,0.77,0.22293815,0.7733333,0.22293815,0.77666664,0.22293815,0.78,0.22293815,0.78333336,0.22293815,0.7866667,0.22293815,0.79,0.22293815,0.79333335,0.22293815,0.7966667,0.22293815,0.8,0.22293815,0.80333334,0.22293815,0.8066667,0.22293815,0.81,0.22293815,0.81333333,0.22293815,0.81666666,0.22293815,0.82,0.22293815,0.8233333,0.22293815,0.82666665,0.22293815,0.83,0.22293815,0.8333333,0.22293815,0.83666664,0.22293815,0.84,0.22293815,0.8433333,0.22293815,0.8466667,0.22293815,0.85,0.22293815,0.85333335,0.22293815,0.8566667,0.22293815,0.86,0.22293815,0.86333334,0.22293815,0.8666667,0.22293815,0.87,0.22293815,0.87333333,0.22293815,0.87666667,0.22293815,0.88,0.22293815,0.8833333,0.22293815,0.88666666,0.22293815,0.89,0.22293815,0.8933333,0.22293815,0.89666665,0.22293815,0.9,0.22293815,0.9033333,0.22293815,0.9066667,0.22293815,0.91,0.22293815,0.91333336,0.22293815,0.9166667,0.22293815,0.92,0.22293815,0.92333335,0.22293815,0.9266667,0.22293815,0.93,0.22293815,0.93333334,0.22293815,0.93666667,0.22293815,0.94,0.22293815,0.9433333,0.22293815,0.94666666,0.22293815,0.05,0.22551547,0.053333335,0.22551547,0.05666667,0.22551547,0.06,0.22551547,0.06333333,0.22551547,0.06666667,0.22551547,0.07,0.22551547,0.07333333,0.22551547,0.07666667,0.22551547,0.08,0.22551547,0.083333336,0.22551547,0.086666666,0.22551547,0.09,0.22551547,0.093333334,0.22551547,0.096666664,0.22551547,0.1,0.22551547,0.10333333,0.22551547,0.10666667,0.22551547,0.11,0.22551547,0.11333334,0.22551547,0.11666667,0.22551547,0.12,0.22551547,0.123333335,0.22551547,0.12666667,0.22551547,0.13,0.22551547,0.13333334,0.22551547,0.13666667,0.22551547,0.14,0.22551547,0.14333333,0.22551547,0.14666666,0.22551547,0.15,0.22551547,0.15333334,0.22551547,0.15666667,0.22551547,0.16,0.22551547,0.16333333,0.22551547,0.16666667,0.22551547,0.17,0.22551547,0.17333333,0.22551547,0.17666666,0.22551547,0.18,0.22551547,0.18333334,0.22551547,0.18666667,0.22551547,0.19,0.22551547,0.19333333,0.22551547,0.19666667,0.22551547,0.2,0.22551547,0.20333333,0.22551547,0.20666666,0.22551547,0.21,0.22551547,0.21333334,0.22551547,0.21666667,0.22551547,0.22,0.22551547,0.22333333,0.22551547,0.22666667,0.22551547,0.23,0.22551547,0.23333333,0.22551547,0.23666666,0.22551547,0.24,0.22551547,0.24333334,0.22551547,0.24666667,0.22551547,0.25,0.22551547,0.25333333,0.22551547,0.25666666,0.22551547,0.26,0.22551547,0.26333332,0.22551547,0.26666668,0.22551547,0.27,0.22551547,0.27333334,0.22551547,0.27666667,0.22551547,0.28,0.22551547,0.28333333,0.22551547,0.28666666,0.22551547,0.29,0.22551547,0.29333332,0.22551547,0.29666665,0.22551547,0.3,0.22551547,0.30333334,0.22551547,0.30666667,0.22551547,0.31,0.22551547,0.31333333,0.22551547,0.31666666,0.22551547,0.32,0.22551547,0.32333332,0.22551547,0.32666665,0.22551547,0.33,0.22551547,0.33333334,0.22551547,0.33666667,0.22551547,0.34,0.22551547,0.34333333,0.22551547,0.34666666,0.22551547,0.35,0.22551547,0.35333332,0.22551547,0.35666665,0.22551547,0.36,0.22551547,0.36333334,0.22551547,0.36666667,0.22551547,0.37,0.22551547,0.37333333,0.22551547,0.37666667,0.22551547,0.38,0.22551547,0.38333333,0.22551547,0.38666666,0.22551547,0.39,0.22551547,0.39333335,0.22551547,0.39666668,0.22551547,0.4,0.22551547,0.40333334,0.22551547,0.40666667,0.22551547,0.41,0.22551547,0.41333333,0.22551547,0.41666666,0.22551547,0.42,0.22551547,0.42333335,0.22551547,0.42666668,0.22551547,0.43,0.22551547,0.43333334,0.22551547,0.43666667,0.22551547,0.44,0.22551547,0.44333333,0.22551547,0.44666666,0.22551547,0.45,0.22551547,0.45333335,0.22551547,0.45666668,0.22551547,0.46,0.22551547,0.46333334,0.22551547,0.46666667,0.22551547,0.47,0.22551547,0.47333333,0.22551547,0.47666666,0.22551547,0.48,0.22551547,0.48333332,0.22551547,0.48666668,0.22551547,0.49,0.22551547,0.49333334,0.22551547,0.49666667,0.22551547,0.5,0.22551547,0.50333333,0.22551547,0.50666666,0.22551547,0.51,0.22551547,0.5133333,0.22551547,0.51666665,0.22551547,0.52,0.22551547,0.5233333,0.22551547,0.52666664,0.22551547,0.53,0.22551547,0.53333336,0.22551547,0.5366667,0.22551547,0.54,0.22551547,0.54333335,0.22551547,0.5466667,0.22551547,0.55,0.22551547,0.55333334,0.22551547,0.5566667,0.22551547,0.56,0.22551547,0.56333333,0.22551547,0.56666666,0.22551547,0.57,0.22551547,0.5733333,0.22551547,0.57666665,0.22551547,0.58,0.22551547,0.5833333,0.22551547,0.58666664,0.22551547,0.59,0.22551547,0.5933333,0.22551547,0.5966667,0.22551547,0.6,0.22551547,0.60333335,0.22551547,0.6066667,0.22551547,0.61,0.22551547,0.61333334,0.22551547,0.6166667,0.22551547,0.62,0.22551547,0.62333333,0.22551547,0.62666667,0.22551547,0.63,0.22551547,0.6333333,0.22551547,0.63666666,0.22551547,0.64,0.22551547,0.6433333,0.22551547,0.64666665,0.22551547,0.65,0.22551547,0.6533333,0.22551547,0.6566667,0.22551547,0.66,0.22551547,0.66333336,0.22551547,0.6666667,0.22551547,0.67,0.22551547,0.67333335,0.22551547,0.6766667,0.22551547,0.68,0.22551547,0.68333334,0.22551547,0.68666667,0.22551547,0.69,0.22551547,0.6933333,0.22551547,0.69666666,0.22551547,0.7,0.22551547,0.7033333,0.22551547,0.70666665,0.22551547,0.71,0.22551547,0.7133333,0.22551547,0.71666664,0.22551547,0.72,0.22551547,0.72333336,0.22551547,0.7266667,0.22551547,0.73,0.22551547,0.73333335,0.22551547,0.7366667,0.22551547,0.74,0.22551547,0.74333334,0.22551547,0.74666667,0.22551547,0.75,0.22551547,0.75333333,0.22551547,0.75666666,0.22551547,0.76,0.22551547,0.7633333,0.22551547,0.76666665,0.22551547,0.77,0.22551547,0.7733333,0.22551547,0.77666664,0.22551547,0.78,0.22551547,0.78333336,0.22551547,0.7866667,0.22551547,0.79,0.22551547,0.79333335,0.22551547,0.7966667,0.22551547,0.8,0.22551547,0.80333334,0.22551547,0.8066667,0.22551547,0.81,0.22551547,0.81333333,0.22551547,0.81666666,0.22551547,0.82,0.22551547,0.8233333,0.22551547,0.82666665,0.22551547,0.83,0.22551547,0.8333333,0.22551547,0.83666664,0.22551547,0.84,0.22551547,0.8433333,0.22551547,0.8466667,0.22551547,0.85,0.22551547,0.85333335,0.22551547,0.8566667,0.22551547,0.86,0.22551547,0.86333334,0.22551547,0.8666667,0.22551547,0.87,0.22551547,0.87333333,0.22551547,0.87666667,0.22551547,0.88,0.22551547,0.8833333,0.22551547,0.88666666,0.22551547,0.89,0.22551547,0.8933333,0.22551547,0.89666665,0.22551547,0.9,0.22551547,0.9033333,0.22551547,0.9066667,0.22551547,0.91,0.22551547,0.91333336,0.22551547,0.9166667,0.22551547,0.92,0.22551547,0.92333335,0.22551547,0.9266667,0.22551547,0.93,0.22551547,0.93333334,0.22551547,0.93666667,0.22551547,0.94,0.22551547,0.9433333,0.22551547,0.94666666,0.22551547,0.05,0.22809279,0.053333335,0.22809279,0.05666667,0.22809279,0.06,0.22809279,0.06333333,0.22809279,0.06666667,0.22809279,0.07,0.22809279,0.07333333,0.22809279,0.07666667,0.22809279,0.08,0.22809279,0.083333336,0.22809279,0.086666666,0.22809279,0.09,0.22809279,0.093333334,0.22809279,0.096666664,0.22809279,0.1,0.22809279,0.10333333,0.22809279,0.10666667,0.22809279,0.11,0.22809279,0.11333334,0.22809279,0.11666667,0.22809279,0.12,0.22809279,0.123333335,0.22809279,0.12666667,0.22809279,0.13,0.22809279,0.13333334,0.22809279,0.13666667,0.22809279,0.14,0.22809279,0.14333333,0.22809279,0.14666666,0.22809279,0.15,0.22809279,0.15333334,0.22809279,0.15666667,0.22809279,0.16,0.22809279,0.16333333,0.22809279,0.16666667,0.22809279,0.17,0.22809279,0.17333333,0.22809279,0.17666666,0.22809279,0.18,0.22809279,0.18333334,0.22809279,0.18666667,0.22809279,0.19,0.22809279,0.19333333,0.22809279,0.19666667,0.22809279,0.2,0.22809279,0.20333333,0.22809279,0.20666666,0.22809279,0.21,0.22809279,0.21333334,0.22809279,0.21666667,0.22809279,0.22,0.22809279,0.22333333,0.22809279,0.22666667,0.22809279,0.23,0.22809279,0.23333333,0.22809279,0.23666666,0.22809279,0.24,0.22809279,0.24333334,0.22809279,0.24666667,0.22809279,0.25,0.22809279,0.25333333,0.22809279,0.25666666,0.22809279,0.26,0.22809279,0.26333332,0.22809279,0.26666668,0.22809279,0.27,0.22809279,0.27333334,0.22809279,0.27666667,0.22809279,0.28,0.22809279,0.28333333,0.22809279,0.28666666,0.22809279,0.29,0.22809279,0.29333332,0.22809279,0.29666665,0.22809279,0.3,0.22809279,0.30333334,0.22809279,0.30666667,0.22809279,0.31,0.22809279,0.31333333,0.22809279,0.31666666,0.22809279,0.32,0.22809279,0.32333332,0.22809279,0.32666665,0.22809279,0.33,0.22809279,0.33333334,0.22809279,0.33666667,0.22809279,0.34,0.22809279,0.34333333,0.22809279,0.34666666,0.22809279,0.35,0.22809279,0.35333332,0.22809279,0.35666665,0.22809279,0.36,0.22809279,0.36333334,0.22809279,0.36666667,0.22809279,0.37,0.22809279,0.37333333,0.22809279,0.37666667,0.22809279,0.38,0.22809279,0.38333333,0.22809279,0.38666666,0.22809279,0.39,0.22809279,0.39333335,0.22809279,0.39666668,0.22809279,0.4,0.22809279,0.40333334,0.22809279,0.40666667,0.22809279,0.41,0.22809279,0.41333333,0.22809279,0.41666666,0.22809279,0.42,0.22809279,0.42333335,0.22809279,0.42666668,0.22809279,0.43,0.22809279,0.43333334,0.22809279,0.43666667,0.22809279,0.44,0.22809279,0.44333333,0.22809279,0.44666666,0.22809279,0.45,0.22809279,0.45333335,0.22809279,0.45666668,0.22809279,0.46,0.22809279,0.46333334,0.22809279,0.46666667,0.22809279,0.47,0.22809279,0.47333333,0.22809279,0.47666666,0.22809279,0.48,0.22809279,0.48333332,0.22809279,0.48666668,0.22809279,0.49,0.22809279,0.49333334,0.22809279,0.49666667,0.22809279,0.5,0.22809279,0.50333333,0.22809279,0.50666666,0.22809279,0.51,0.22809279,0.5133333,0.22809279,0.51666665,0.22809279,0.52,0.22809279,0.5233333,0.22809279,0.52666664,0.22809279,0.53,0.22809279,0.53333336,0.22809279,0.5366667,0.22809279,0.54,0.22809279,0.54333335,0.22809279,0.5466667,0.22809279,0.55,0.22809279,0.55333334,0.22809279,0.5566667,0.22809279,0.56,0.22809279,0.56333333,0.22809279,0.56666666,0.22809279,0.57,0.22809279,0.5733333,0.22809279,0.57666665,0.22809279,0.58,0.22809279,0.5833333,0.22809279,0.58666664,0.22809279,0.59,0.22809279,0.5933333,0.22809279,0.5966667,0.22809279,0.6,0.22809279,0.60333335,0.22809279,0.6066667,0.22809279,0.61,0.22809279,0.61333334,0.22809279,0.6166667,0.22809279,0.62,0.22809279,0.62333333,0.22809279,0.62666667,0.22809279,0.63,0.22809279,0.6333333,0.22809279,0.63666666,0.22809279,0.64,0.22809279,0.6433333,0.22809279,0.64666665,0.22809279,0.65,0.22809279,0.6533333,0.22809279,0.6566667,0.22809279,0.66,0.22809279,0.66333336,0.22809279,0.6666667,0.22809279,0.67,0.22809279,0.67333335,0.22809279,0.6766667,0.22809279,0.68,0.22809279,0.68333334,0.22809279,0.68666667,0.22809279,0.69,0.22809279,0.6933333,0.22809279,0.69666666,0.22809279,0.7,0.22809279,0.7033333,0.22809279,0.70666665,0.22809279,0.71,0.22809279,0.7133333,0.22809279,0.71666664,0.22809279,0.72,0.22809279,0.72333336,0.22809279,0.7266667,0.22809279,0.73,0.22809279,0.73333335,0.22809279,0.7366667,0.22809279,0.74,0.22809279,0.74333334,0.22809279,0.74666667,0.22809279,0.75,0.22809279,0.75333333,0.22809279,0.75666666,0.22809279,0.76,0.22809279,0.7633333,0.22809279,0.76666665,0.22809279,0.77,0.22809279,0.7733333,0.22809279,0.77666664,0.22809279,0.78,0.22809279,0.78333336,0.22809279,0.7866667,0.22809279,0.79,0.22809279,0.79333335,0.22809279,0.7966667,0.22809279,0.8,0.22809279,0.80333334,0.22809279,0.8066667,0.22809279,0.81,0.22809279,0.81333333,0.22809279,0.81666666,0.22809279,0.82,0.22809279,0.8233333,0.22809279,0.82666665,0.22809279,0.83,0.22809279,0.8333333,0.22809279,0.83666664,0.22809279,0.84,0.22809279,0.8433333,0.22809279,0.8466667,0.22809279,0.85,0.22809279,0.85333335,0.22809279,0.8566667,0.22809279,0.86,0.22809279,0.86333334,0.22809279,0.8666667,0.22809279,0.87,0.22809279,0.87333333,0.22809279,0.87666667,0.22809279,0.88,0.22809279,0.8833333,0.22809279,0.88666666,0.22809279,0.89,0.22809279,0.8933333,0.22809279,0.89666665,0.22809279,0.9,0.22809279,0.9033333,0.22809279,0.9066667,0.22809279,0.91,0.22809279,0.91333336,0.22809279,0.9166667,0.22809279,0.92,0.22809279,0.92333335,0.22809279,0.9266667,0.22809279,0.93,0.22809279,0.93333334,0.22809279,0.93666667,0.22809279,0.94,0.22809279,0.9433333,0.22809279,0.94666666,0.22809279,0.05,0.23067011,0.053333335,0.23067011,0.05666667,0.23067011,0.06,0.23067011,0.06333333,0.23067011,0.06666667,0.23067011,0.07,0.23067011,0.07333333,0.23067011,0.07666667,0.23067011,0.08,0.23067011,0.083333336,0.23067011,0.086666666,0.23067011,0.09,0.23067011,0.093333334,0.23067011,0.096666664,0.23067011,0.1,0.23067011,0.10333333,0.23067011,0.10666667,0.23067011,0.11,0.23067011,0.11333334,0.23067011,0.11666667,0.23067011,0.12,0.23067011,0.123333335,0.23067011,0.12666667,0.23067011,0.13,0.23067011,0.13333334,0.23067011,0.13666667,0.23067011,0.14,0.23067011,0.14333333,0.23067011,0.14666666,0.23067011,0.15,0.23067011,0.15333334,0.23067011,0.15666667,0.23067011,0.16,0.23067011,0.16333333,0.23067011,0.16666667,0.23067011,0.17,0.23067011,0.17333333,0.23067011,0.17666666,0.23067011,0.18,0.23067011,0.18333334,0.23067011,0.18666667,0.23067011,0.19,0.23067011,0.19333333,0.23067011,0.19666667,0.23067011,0.2,0.23067011,0.20333333,0.23067011,0.20666666,0.23067011,0.21,0.23067011,0.21333334,0.23067011,0.21666667,0.23067011,0.22,0.23067011,0.22333333,0.23067011,0.22666667,0.23067011,0.23,0.23067011,0.23333333,0.23067011,0.23666666,0.23067011,0.24,0.23067011,0.24333334,0.23067011,0.24666667,0.23067011,0.25,0.23067011,0.25333333,0.23067011,0.25666666,0.23067011,0.26,0.23067011,0.26333332,0.23067011,0.26666668,0.23067011,0.27,0.23067011,0.27333334,0.23067011,0.27666667,0.23067011,0.28,0.23067011,0.28333333,0.23067011,0.28666666,0.23067011,0.29,0.23067011,0.29333332,0.23067011,0.29666665,0.23067011,0.3,0.23067011,0.30333334,0.23067011,0.30666667,0.23067011,0.31,0.23067011,0.31333333,0.23067011,0.31666666,0.23067011,0.32,0.23067011,0.32333332,0.23067011,0.32666665,0.23067011,0.33,0.23067011,0.33333334,0.23067011,0.33666667,0.23067011,0.34,0.23067011,0.34333333,0.23067011,0.34666666,0.23067011,0.35,0.23067011,0.35333332,0.23067011,0.35666665,0.23067011,0.36,0.23067011,0.36333334,0.23067011,0.36666667,0.23067011,0.37,0.23067011,0.37333333,0.23067011,0.37666667,0.23067011,0.38,0.23067011,0.38333333,0.23067011,0.38666666,0.23067011,0.39,0.23067011,0.39333335,0.23067011,0.39666668,0.23067011,0.4,0.23067011,0.40333334,0.23067011,0.40666667,0.23067011,0.41,0.23067011,0.41333333,0.23067011,0.41666666,0.23067011,0.42,0.23067011,0.42333335,0.23067011,0.42666668,0.23067011,0.43,0.23067011,0.43333334,0.23067011,0.43666667,0.23067011,0.44,0.23067011,0.44333333,0.23067011,0.44666666,0.23067011,0.45,0.23067011,0.45333335,0.23067011,0.45666668,0.23067011,0.46,0.23067011,0.46333334,0.23067011,0.46666667,0.23067011,0.47,0.23067011,0.47333333,0.23067011,0.47666666,0.23067011,0.48,0.23067011,0.48333332,0.23067011,0.48666668,0.23067011,0.49,0.23067011,0.49333334,0.23067011,0.49666667,0.23067011,0.5,0.23067011,0.50333333,0.23067011,0.50666666,0.23067011,0.51,0.23067011,0.5133333,0.23067011,0.51666665,0.23067011,0.52,0.23067011,0.5233333,0.23067011,0.52666664,0.23067011,0.53,0.23067011,0.53333336,0.23067011,0.5366667,0.23067011,0.54,0.23067011,0.54333335,0.23067011,0.5466667,0.23067011,0.55,0.23067011,0.55333334,0.23067011,0.5566667,0.23067011,0.56,0.23067011,0.56333333,0.23067011,0.56666666,0.23067011,0.57,0.23067011,0.5733333,0.23067011,0.57666665,0.23067011,0.58,0.23067011,0.5833333,0.23067011,0.58666664,0.23067011,0.59,0.23067011,0.5933333,0.23067011,0.5966667,0.23067011,0.6,0.23067011,0.60333335,0.23067011,0.6066667,0.23067011,0.61,0.23067011,0.61333334,0.23067011,0.6166667,0.23067011,0.62,0.23067011,0.62333333,0.23067011,0.62666667,0.23067011,0.63,0.23067011,0.6333333,0.23067011,0.63666666,0.23067011,0.64,0.23067011,0.6433333,0.23067011,0.64666665,0.23067011,0.65,0.23067011,0.6533333,0.23067011,0.6566667,0.23067011,0.66,0.23067011,0.66333336,0.23067011,0.6666667,0.23067011,0.67,0.23067011,0.67333335,0.23067011,0.6766667,0.23067011,0.68,0.23067011,0.68333334,0.23067011,0.68666667,0.23067011,0.69,0.23067011,0.6933333,0.23067011,0.69666666,0.23067011,0.7,0.23067011,0.7033333,0.23067011,0.70666665,0.23067011,0.71,0.23067011,0.7133333,0.23067011,0.71666664,0.23067011,0.72,0.23067011,0.72333336,0.23067011,0.7266667,0.23067011,0.73,0.23067011,0.73333335,0.23067011,0.7366667,0.23067011,0.74,0.23067011,0.74333334,0.23067011,0.74666667,0.23067011,0.75,0.23067011,0.75333333,0.23067011,0.75666666,0.23067011,0.76,0.23067011,0.7633333,0.23067011,0.76666665,0.23067011,0.77,0.23067011,0.7733333,0.23067011,0.77666664,0.23067011,0.78,0.23067011,0.78333336,0.23067011,0.7866667,0.23067011,0.79,0.23067011,0.79333335,0.23067011,0.7966667,0.23067011,0.8,0.23067011,0.80333334,0.23067011,0.8066667,0.23067011,0.81,0.23067011,0.81333333,0.23067011,0.81666666,0.23067011,0.82,0.23067011,0.8233333,0.23067011,0.82666665,0.23067011,0.83,0.23067011,0.8333333,0.23067011,0.83666664,0.23067011,0.84,0.23067011,0.8433333,0.23067011,0.8466667,0.23067011,0.85,0.23067011,0.85333335,0.23067011,0.8566667,0.23067011,0.86,0.23067011,0.86333334,0.23067011,0.8666667,0.23067011,0.87,0.23067011,0.87333333,0.23067011,0.87666667,0.23067011,0.88,0.23067011,0.8833333,0.23067011,0.88666666,0.23067011,0.89,0.23067011,0.8933333,0.23067011,0.89666665,0.23067011,0.9,0.23067011,0.9033333,0.23067011,0.9066667,0.23067011,0.91,0.23067011,0.91333336,0.23067011,0.9166667,0.23067011,0.92,0.23067011,0.92333335,0.23067011,0.9266667,0.23067011,0.93,0.23067011,0.93333334,0.23067011,0.93666667,0.23067011,0.94,0.23067011,0.9433333,0.23067011,0.94666666,0.23067011,0.05,0.23324743,0.053333335,0.23324743,0.05666667,0.23324743,0.06,0.23324743,0.06333333,0.23324743,0.06666667,0.23324743,0.07,0.23324743,0.07333333,0.23324743,0.07666667,0.23324743,0.08,0.23324743,0.083333336,0.23324743,0.086666666,0.23324743,0.09,0.23324743,0.093333334,0.23324743,0.096666664,0.23324743,0.1,0.23324743,0.10333333,0.23324743,0.10666667,0.23324743,0.11,0.23324743,0.11333334,0.23324743,0.11666667,0.23324743,0.12,0.23324743,0.123333335,0.23324743,0.12666667,0.23324743,0.13,0.23324743,0.13333334,0.23324743,0.13666667,0.23324743,0.14,0.23324743,0.14333333,0.23324743,0.14666666,0.23324743,0.15,0.23324743,0.15333334,0.23324743,0.15666667,0.23324743,0.16,0.23324743,0.16333333,0.23324743,0.16666667,0.23324743,0.17,0.23324743,0.17333333,0.23324743,0.17666666,0.23324743,0.18,0.23324743,0.18333334,0.23324743,0.18666667,0.23324743,0.19,0.23324743,0.19333333,0.23324743,0.19666667,0.23324743,0.2,0.23324743,0.20333333,0.23324743,0.20666666,0.23324743,0.21,0.23324743,0.21333334,0.23324743,0.21666667,0.23324743,0.22,0.23324743,0.22333333,0.23324743,0.22666667,0.23324743,0.23,0.23324743,0.23333333,0.23324743,0.23666666,0.23324743,0.24,0.23324743,0.24333334,0.23324743,0.24666667,0.23324743,0.25,0.23324743,0.25333333,0.23324743,0.25666666,0.23324743,0.26,0.23324743,0.26333332,0.23324743,0.26666668,0.23324743,0.27,0.23324743,0.27333334,0.23324743,0.27666667,0.23324743,0.28,0.23324743,0.28333333,0.23324743,0.28666666,0.23324743,0.29,0.23324743,0.29333332,0.23324743,0.29666665,0.23324743,0.3,0.23324743,0.30333334,0.23324743,0.30666667,0.23324743,0.31,0.23324743,0.31333333,0.23324743,0.31666666,0.23324743,0.32,0.23324743,0.32333332,0.23324743,0.32666665,0.23324743,0.33,0.23324743,0.33333334,0.23324743,0.33666667,0.23324743,0.34,0.23324743,0.34333333,0.23324743,0.34666666,0.23324743,0.35,0.23324743,0.35333332,0.23324743,0.35666665,0.23324743,0.36,0.23324743,0.36333334,0.23324743,0.36666667,0.23324743,0.37,0.23324743,0.37333333,0.23324743,0.37666667,0.23324743,0.38,0.23324743,0.38333333,0.23324743,0.38666666,0.23324743,0.39,0.23324743,0.39333335,0.23324743,0.39666668,0.23324743,0.4,0.23324743,0.40333334,0.23324743,0.40666667,0.23324743,0.41,0.23324743,0.41333333,0.23324743,0.41666666,0.23324743,0.42,0.23324743,0.42333335,0.23324743,0.42666668,0.23324743,0.43,0.23324743,0.43333334,0.23324743,0.43666667,0.23324743,0.44,0.23324743,0.44333333,0.23324743,0.44666666,0.23324743,0.45,0.23324743,0.45333335,0.23324743,0.45666668,0.23324743,0.46,0.23324743,0.46333334,0.23324743,0.46666667,0.23324743,0.47,0.23324743,0.47333333,0.23324743,0.47666666,0.23324743,0.48,0.23324743,0.48333332,0.23324743,0.48666668,0.23324743,0.49,0.23324743,0.49333334,0.23324743,0.49666667,0.23324743,0.5,0.23324743,0.50333333,0.23324743,0.50666666,0.23324743,0.51,0.23324743,0.5133333,0.23324743,0.51666665,0.23324743,0.52,0.23324743,0.5233333,0.23324743,0.52666664,0.23324743,0.53,0.23324743,0.53333336,0.23324743,0.5366667,0.23324743,0.54,0.23324743,0.54333335,0.23324743,0.5466667,0.23324743,0.55,0.23324743,0.55333334,0.23324743,0.5566667,0.23324743,0.56,0.23324743,0.56333333,0.23324743,0.56666666,0.23324743,0.57,0.23324743,0.5733333,0.23324743,0.57666665,0.23324743,0.58,0.23324743,0.5833333,0.23324743,0.58666664,0.23324743,0.59,0.23324743,0.5933333,0.23324743,0.5966667,0.23324743,0.6,0.23324743,0.60333335,0.23324743,0.6066667,0.23324743,0.61,0.23324743,0.61333334,0.23324743,0.6166667,0.23324743,0.62,0.23324743,0.62333333,0.23324743,0.62666667,0.23324743,0.63,0.23324743,0.6333333,0.23324743,0.63666666,0.23324743,0.64,0.23324743,0.6433333,0.23324743,0.64666665,0.23324743,0.65,0.23324743,0.6533333,0.23324743,0.6566667,0.23324743,0.66,0.23324743,0.66333336,0.23324743,0.6666667,0.23324743,0.67,0.23324743,0.67333335,0.23324743,0.6766667,0.23324743,0.68,0.23324743,0.68333334,0.23324743,0.68666667,0.23324743,0.69,0.23324743,0.6933333,0.23324743,0.69666666,0.23324743,0.7,0.23324743,0.7033333,0.23324743,0.70666665,0.23324743,0.71,0.23324743,0.7133333,0.23324743,0.71666664,0.23324743,0.72,0.23324743,0.72333336,0.23324743,0.7266667,0.23324743,0.73,0.23324743,0.73333335,0.23324743,0.7366667,0.23324743,0.74,0.23324743,0.74333334,0.23324743,0.74666667,0.23324743,0.75,0.23324743,0.75333333,0.23324743,0.75666666,0.23324743,0.76,0.23324743,0.7633333,0.23324743,0.76666665,0.23324743,0.77,0.23324743,0.7733333,0.23324743,0.77666664,0.23324743,0.78,0.23324743,0.78333336,0.23324743,0.7866667,0.23324743,0.79,0.23324743,0.79333335,0.23324743,0.7966667,0.23324743,0.8,0.23324743,0.80333334,0.23324743,0.8066667,0.23324743,0.81,0.23324743,0.81333333,0.23324743,0.81666666,0.23324743,0.82,0.23324743,0.8233333,0.23324743,0.82666665,0.23324743,0.83,0.23324743,0.8333333,0.23324743,0.83666664,0.23324743,0.84,0.23324743,0.8433333,0.23324743,0.8466667,0.23324743,0.85,0.23324743,0.85333335,0.23324743,0.8566667,0.23324743,0.86,0.23324743,0.86333334,0.23324743,0.8666667,0.23324743,0.87,0.23324743,0.87333333,0.23324743,0.87666667,0.23324743,0.88,0.23324743,0.8833333,0.23324743,0.88666666,0.23324743,0.89,0.23324743,0.8933333,0.23324743,0.89666665,0.23324743,0.9,0.23324743,0.9033333,0.23324743,0.9066667,0.23324743,0.91,0.23324743,0.91333336,0.23324743,0.9166667,0.23324743,0.92,0.23324743,0.92333335,0.23324743,0.9266667,0.23324743,0.93,0.23324743,0.93333334,0.23324743,0.93666667,0.23324743,0.94,0.23324743,0.9433333,0.23324743,0.94666666,0.23324743,0.05,0.23582475,0.053333335,0.23582475,0.05666667,0.23582475,0.06,0.23582475,0.06333333,0.23582475,0.06666667,0.23582475,0.07,0.23582475,0.07333333,0.23582475,0.07666667,0.23582475,0.08,0.23582475,0.083333336,0.23582475,0.086666666,0.23582475,0.09,0.23582475,0.093333334,0.23582475,0.096666664,0.23582475,0.1,0.23582475,0.10333333,0.23582475,0.10666667,0.23582475,0.11,0.23582475,0.11333334,0.23582475,0.11666667,0.23582475,0.12,0.23582475,0.123333335,0.23582475,0.12666667,0.23582475,0.13,0.23582475,0.13333334,0.23582475,0.13666667,0.23582475,0.14,0.23582475,0.14333333,0.23582475,0.14666666,0.23582475,0.15,0.23582475,0.15333334,0.23582475,0.15666667,0.23582475,0.16,0.23582475,0.16333333,0.23582475,0.16666667,0.23582475,0.17,0.23582475,0.17333333,0.23582475,0.17666666,0.23582475,0.18,0.23582475,0.18333334,0.23582475,0.18666667,0.23582475,0.19,0.23582475,0.19333333,0.23582475,0.19666667,0.23582475,0.2,0.23582475,0.20333333,0.23582475,0.20666666,0.23582475,0.21,0.23582475,0.21333334,0.23582475,0.21666667,0.23582475,0.22,0.23582475,0.22333333,0.23582475,0.23,0.23582475,0.23333333,0.23582475,0.23666666,0.23582475,0.24,0.23582475,0.24333334,0.23582475,0.24666667,0.23582475,0.25,0.23582475,0.25333333,0.23582475,0.25666666,0.23582475,0.26,0.23582475,0.26333332,0.23582475,0.26666668,0.23582475,0.27,0.23582475,0.27333334,0.23582475,0.27666667,0.23582475,0.28,0.23582475,0.28333333,0.23582475,0.28666666,0.23582475,0.29,0.23582475,0.29333332,0.23582475,0.29666665,0.23582475,0.3,0.23582475,0.30333334,0.23582475,0.30666667,0.23582475,0.31,0.23582475,0.31333333,0.23582475,0.31666666,0.23582475,0.32,0.23582475,0.32333332,0.23582475,0.32666665,0.23582475,0.33,0.23582475,0.33333334,0.23582475,0.33666667,0.23582475,0.34,0.23582475,0.34333333,0.23582475,0.34666666,0.23582475,0.35,0.23582475,0.35333332,0.23582475,0.35666665,0.23582475,0.36,0.23582475,0.36333334,0.23582475,0.36666667,0.23582475,0.37,0.23582475,0.37333333,0.23582475,0.37666667,0.23582475,0.38,0.23582475,0.38333333,0.23582475,0.38666666,0.23582475,0.39,0.23582475,0.39333335,0.23582475,0.39666668,0.23582475,0.4,0.23582475,0.40333334,0.23582475,0.40666667,0.23582475,0.41,0.23582475,0.41333333,0.23582475,0.41666666,0.23582475,0.42,0.23582475,0.42333335,0.23582475,0.42666668,0.23582475,0.43,0.23582475,0.43333334,0.23582475,0.43666667,0.23582475,0.44,0.23582475,0.44333333,0.23582475,0.44666666,0.23582475,0.45,0.23582475,0.45333335,0.23582475,0.45666668,0.23582475,0.46,0.23582475,0.46333334,0.23582475,0.46666667,0.23582475,0.47,0.23582475,0.47333333,0.23582475,0.47666666,0.23582475,0.48,0.23582475,0.48333332,0.23582475,0.48666668,0.23582475,0.49,0.23582475,0.49333334,0.23582475,0.49666667,0.23582475,0.5,0.23582475,0.50333333,0.23582475,0.50666666,0.23582475,0.51,0.23582475,0.5133333,0.23582475,0.51666665,0.23582475,0.52,0.23582475,0.5233333,0.23582475,0.52666664,0.23582475,0.53,0.23582475,0.53333336,0.23582475,0.5366667,0.23582475,0.54,0.23582475,0.54333335,0.23582475,0.5466667,0.23582475,0.55,0.23582475,0.55333334,0.23582475,0.5566667,0.23582475,0.56,0.23582475,0.56333333,0.23582475,0.56666666,0.23582475,0.57,0.23582475,0.5733333,0.23582475,0.57666665,0.23582475,0.58,0.23582475,0.5833333,0.23582475,0.58666664,0.23582475,0.59,0.23582475,0.5933333,0.23582475,0.5966667,0.23582475,0.6,0.23582475,0.60333335,0.23582475,0.6066667,0.23582475,0.61,0.23582475,0.61333334,0.23582475,0.6166667,0.23582475,0.62,0.23582475,0.62333333,0.23582475,0.62666667,0.23582475,0.63,0.23582475,0.6333333,0.23582475,0.63666666,0.23582475,0.64,0.23582475,0.6433333,0.23582475,0.64666665,0.23582475,0.65,0.23582475,0.6533333,0.23582475,0.6566667,0.23582475,0.66,0.23582475,0.66333336,0.23582475,0.6666667,0.23582475,0.67,0.23582475,0.67333335,0.23582475,0.6766667,0.23582475,0.68,0.23582475,0.68333334,0.23582475,0.68666667,0.23582475,0.69,0.23582475,0.6933333,0.23582475,0.69666666,0.23582475,0.7,0.23582475,0.7033333,0.23582475,0.70666665,0.23582475,0.71,0.23582475,0.7133333,0.23582475,0.71666664,0.23582475,0.72,0.23582475,0.72333336,0.23582475,0.7266667,0.23582475,0.73,0.23582475,0.73333335,0.23582475,0.7366667,0.23582475,0.74,0.23582475,0.74333334,0.23582475,0.74666667,0.23582475,0.75,0.23582475,0.75333333,0.23582475,0.75666666,0.23582475,0.76,0.23582475,0.7633333,0.23582475,0.76666665,0.23582475,0.77,0.23582475,0.7733333,0.23582475,0.77666664,0.23582475,0.78,0.23582475,0.78333336,0.23582475,0.7866667,0.23582475,0.79,0.23582475,0.79333335,0.23582475,0.7966667,0.23582475,0.8,0.23582475,0.80333334,0.23582475,0.8066667,0.23582475,0.81,0.23582475,0.81333333,0.23582475,0.81666666,0.23582475,0.82,0.23582475,0.8233333,0.23582475,0.82666665,0.23582475,0.83,0.23582475,0.8333333,0.23582475,0.83666664,0.23582475,0.84,0.23582475,0.8433333,0.23582475,0.8466667,0.23582475,0.85,0.23582475,0.85333335,0.23582475,0.8566667,0.23582475,0.86,0.23582475,0.86333334,0.23582475,0.8666667,0.23582475,0.87,0.23582475,0.87333333,0.23582475,0.87666667,0.23582475,0.88,0.23582475,0.8833333,0.23582475,0.88666666,0.23582475,0.89,0.23582475,0.8933333,0.23582475,0.89666665,0.23582475,0.9,0.23582475,0.9033333,0.23582475,0.9066667,0.23582475,0.91,0.23582475,0.91333336,0.23582475,0.9166667,0.23582475,0.92,0.23582475,0.92333335,0.23582475,0.9266667,0.23582475,0.93,0.23582475,0.93333334,0.23582475,0.93666667,0.23582475,0.94,0.23582475,0.9433333,0.23582475,0.94666666,0.23582475,0.05,0.23840207,0.053333335,0.23840207,0.05666667,0.23840207,0.06,0.23840207,0.06333333,0.23840207,0.06666667,0.23840207,0.07,0.23840207,0.07333333,0.23840207,0.07666667,0.23840207,0.08,0.23840207,0.083333336,0.23840207,0.086666666,0.23840207,0.09,0.23840207,0.093333334,0.23840207,0.096666664,0.23840207,0.1,0.23840207,0.10333333,0.23840207,0.10666667,0.23840207,0.11,0.23840207,0.11333334,0.23840207,0.11666667,0.23840207,0.12,0.23840207,0.123333335,0.23840207,0.12666667,0.23840207,0.13,0.23840207,0.13333334,0.23840207,0.13666667,0.23840207,0.14,0.23840207,0.14333333,0.23840207,0.14666666,0.23840207,0.15,0.23840207,0.15333334,0.23840207,0.15666667,0.23840207,0.16,0.23840207,0.16333333,0.23840207,0.16666667,0.23840207,0.17,0.23840207,0.17333333,0.23840207,0.17666666,0.23840207,0.18,0.23840207,0.18333334,0.23840207,0.18666667,0.23840207,0.19,0.23840207,0.19333333,0.23840207,0.19666667,0.23840207,0.2,0.23840207,0.20333333,0.23840207,0.20666666,0.23840207,0.21,0.23840207,0.21333334,0.23840207,0.22,0.23840207,0.22333333,0.23840207,0.22666667,0.23840207,0.23,0.23840207,0.23333333,0.23840207,0.23666666,0.23840207,0.24,0.23840207,0.24333334,0.23840207,0.24666667,0.23840207,0.25333333,0.23840207,0.25666666,0.23840207,0.26,0.23840207,0.26333332,0.23840207,0.26666668,0.23840207,0.27,0.23840207,0.27333334,0.23840207,0.27666667,0.23840207,0.28,0.23840207,0.28333333,0.23840207,0.28666666,0.23840207,0.29,0.23840207,0.29333332,0.23840207,0.29666665,0.23840207,0.3,0.23840207,0.30333334,0.23840207,0.30666667,0.23840207,0.31,0.23840207,0.31333333,0.23840207,0.31666666,0.23840207,0.32,0.23840207,0.32333332,0.23840207,0.32666665,0.23840207,0.33,0.23840207,0.33333334,0.23840207,0.33666667,0.23840207,0.34,0.23840207,0.34333333,0.23840207,0.34666666,0.23840207,0.35,0.23840207,0.35333332,0.23840207,0.35666665,0.23840207,0.36,0.23840207,0.36333334,0.23840207,0.36666667,0.23840207,0.37,0.23840207,0.37333333,0.23840207,0.37666667,0.23840207,0.38,0.23840207,0.38333333,0.23840207,0.38666666,0.23840207,0.39,0.23840207,0.39333335,0.23840207,0.39666668,0.23840207,0.4,0.23840207,0.40333334,0.23840207,0.40666667,0.23840207,0.41,0.23840207,0.41333333,0.23840207,0.41666666,0.23840207,0.42,0.23840207,0.42333335,0.23840207,0.42666668,0.23840207,0.43,0.23840207,0.43333334,0.23840207,0.43666667,0.23840207,0.44,0.23840207,0.44333333,0.23840207,0.44666666,0.23840207,0.45,0.23840207,0.45333335,0.23840207,0.45666668,0.23840207,0.46,0.23840207,0.46333334,0.23840207,0.46666667,0.23840207,0.47,0.23840207,0.47333333,0.23840207,0.47666666,0.23840207,0.48,0.23840207,0.48333332,0.23840207,0.48666668,0.23840207,0.49,0.23840207,0.49333334,0.23840207,0.49666667,0.23840207,0.5,0.23840207,0.50333333,0.23840207,0.50666666,0.23840207,0.51,0.23840207,0.5133333,0.23840207,0.51666665,0.23840207,0.52,0.23840207,0.5233333,0.23840207,0.52666664,0.23840207,0.53,0.23840207,0.53333336,0.23840207,0.5366667,0.23840207,0.54,0.23840207,0.54333335,0.23840207,0.5466667,0.23840207,0.55,0.23840207,0.55333334,0.23840207,0.5566667,0.23840207,0.56,0.23840207,0.56333333,0.23840207,0.56666666,0.23840207,0.57,0.23840207,0.5733333,0.23840207,0.57666665,0.23840207,0.58,0.23840207,0.5833333,0.23840207,0.58666664,0.23840207,0.59,0.23840207,0.5933333,0.23840207,0.5966667,0.23840207,0.6,0.23840207,0.60333335,0.23840207,0.6066667,0.23840207,0.61,0.23840207,0.61333334,0.23840207,0.6166667,0.23840207,0.62,0.23840207,0.62333333,0.23840207,0.62666667,0.23840207,0.63,0.23840207,0.6333333,0.23840207,0.63666666,0.23840207,0.64,0.23840207,0.6433333,0.23840207,0.64666665,0.23840207,0.65,0.23840207,0.6533333,0.23840207,0.6566667,0.23840207,0.66,0.23840207,0.66333336,0.23840207,0.6666667,0.23840207,0.67,0.23840207,0.67333335,0.23840207,0.6766667,0.23840207,0.68,0.23840207,0.68333334,0.23840207,0.68666667,0.23840207,0.69,0.23840207,0.6933333,0.23840207,0.69666666,0.23840207,0.7,0.23840207,0.7033333,0.23840207,0.70666665,0.23840207,0.71,0.23840207,0.7133333,0.23840207,0.71666664,0.23840207,0.72,0.23840207,0.72333336,0.23840207,0.7266667,0.23840207,0.73,0.23840207,0.73333335,0.23840207,0.7366667,0.23840207,0.74,0.23840207,0.74333334,0.23840207,0.74666667,0.23840207,0.75,0.23840207,0.75333333,0.23840207,0.75666666,0.23840207,0.76,0.23840207,0.7633333,0.23840207,0.76666665,0.23840207,0.77,0.23840207,0.7733333,0.23840207,0.77666664,0.23840207,0.78,0.23840207,0.78333336,0.23840207,0.7866667,0.23840207,0.79,0.23840207,0.79333335,0.23840207,0.7966667,0.23840207,0.8,0.23840207,0.80333334,0.23840207,0.8066667,0.23840207,0.81,0.23840207,0.81333333,0.23840207,0.81666666,0.23840207,0.82,0.23840207,0.8233333,0.23840207,0.82666665,0.23840207,0.83,0.23840207,0.8333333,0.23840207,0.83666664,0.23840207,0.84,0.23840207,0.8433333,0.23840207,0.8466667,0.23840207,0.85,0.23840207,0.85333335,0.23840207,0.8566667,0.23840207,0.86,0.23840207,0.86333334,0.23840207,0.8666667,0.23840207,0.87,0.23840207,0.87333333,0.23840207,0.87666667,0.23840207,0.88,0.23840207,0.8833333,0.23840207,0.88666666,0.23840207,0.89,0.23840207,0.8933333,0.23840207,0.89666665,0.23840207,0.9,0.23840207,0.9033333,0.23840207,0.9066667,0.23840207,0.91,0.23840207,0.91333336,0.23840207,0.9166667,0.23840207,0.92,0.23840207,0.92333335,0.23840207,0.9266667,0.23840207,0.93,0.23840207,0.93333334,0.23840207,0.93666667,0.23840207,0.94,0.23840207,0.9433333,0.23840207,0.94666666,0.23840207,0.05,0.24097939,0.053333335,0.24097939,0.05666667,0.24097939,0.06,0.24097939,0.06333333,0.24097939,0.06666667,0.24097939,0.07,0.24097939,0.07333333,0.24097939,0.07666667,0.24097939,0.08,0.24097939,0.083333336,0.24097939,0.086666666,0.24097939,0.09,0.24097939,0.093333334,0.24097939,0.096666664,0.24097939,0.1,0.24097939,0.10333333,0.24097939,0.10666667,0.24097939,0.11,0.24097939,0.11333334,0.24097939,0.11666667,0.24097939,0.12,0.24097939,0.123333335,0.24097939,0.12666667,0.24097939,0.13,0.24097939,0.13333334,0.24097939,0.13666667,0.24097939,0.14,0.24097939,0.14333333,0.24097939,0.14666666,0.24097939,0.15,0.24097939,0.15333334,0.24097939,0.15666667,0.24097939,0.16,0.24097939,0.16333333,0.24097939,0.16666667,0.24097939,0.17,0.24097939,0.17333333,0.24097939,0.17666666,0.24097939,0.18,0.24097939,0.18333334,0.24097939,0.18666667,0.24097939,0.19,0.24097939,0.19333333,0.24097939,0.19666667,0.24097939,0.2,0.24097939,0.20333333,0.24097939,0.20666666,0.24097939,0.21,0.24097939,0.21333334,0.24097939,0.21666667,0.24097939,0.22,0.24097939,0.22333333,0.24097939,0.22666667,0.24097939,0.23,0.24097939,0.23333333,0.24097939,0.23666666,0.24097939,0.24,0.24097939,0.24333334,0.24097939,0.24666667,0.24097939,0.25,0.24097939,0.25333333,0.24097939,0.25666666,0.24097939,0.26,0.24097939,0.26333332,0.24097939,0.26666668,0.24097939,0.27,0.24097939,0.27333334,0.24097939,0.27666667,0.24097939,0.28,0.24097939,0.28333333,0.24097939,0.28666666,0.24097939,0.29,0.24097939,0.29333332,0.24097939,0.29666665,0.24097939,0.3,0.24097939,0.30333334,0.24097939,0.30666667,0.24097939,0.31,0.24097939,0.31333333,0.24097939,0.31666666,0.24097939,0.32,0.24097939,0.32333332,0.24097939,0.32666665,0.24097939,0.33,0.24097939,0.33333334,0.24097939,0.33666667,0.24097939,0.34,0.24097939,0.34333333,0.24097939,0.34666666,0.24097939,0.35,0.24097939,0.35333332,0.24097939,0.35666665,0.24097939,0.36,0.24097939,0.36333334,0.24097939,0.36666667,0.24097939,0.37,0.24097939,0.37333333,0.24097939,0.37666667,0.24097939,0.38,0.24097939,0.38333333,0.24097939,0.38666666,0.24097939,0.39,0.24097939,0.39333335,0.24097939,0.39666668,0.24097939,0.4,0.24097939,0.40333334,0.24097939,0.40666667,0.24097939,0.41,0.24097939,0.41333333,0.24097939,0.41666666,0.24097939,0.42,0.24097939,0.42333335,0.24097939,0.42666668,0.24097939,0.43,0.24097939,0.43333334,0.24097939,0.43666667,0.24097939,0.44,0.24097939,0.44333333,0.24097939,0.44666666,0.24097939,0.45,0.24097939,0.45333335,0.24097939,0.45666668,0.24097939,0.46,0.24097939,0.46333334,0.24097939,0.46666667,0.24097939,0.47,0.24097939,0.47333333,0.24097939,0.47666666,0.24097939,0.48,0.24097939,0.48333332,0.24097939,0.48666668,0.24097939,0.49,0.24097939,0.49333334,0.24097939,0.49666667,0.24097939,0.5,0.24097939,0.50333333,0.24097939,0.50666666,0.24097939,0.51,0.24097939,0.5133333,0.24097939,0.51666665,0.24097939,0.52,0.24097939,0.5233333,0.24097939,0.52666664,0.24097939,0.53,0.24097939,0.53333336,0.24097939,0.5366667,0.24097939,0.54,0.24097939,0.54333335,0.24097939,0.5466667,0.24097939,0.55,0.24097939,0.55333334,0.24097939,0.5566667,0.24097939,0.56,0.24097939,0.56333333,0.24097939,0.56666666,0.24097939,0.57,0.24097939,0.5733333,0.24097939,0.57666665,0.24097939,0.58,0.24097939,0.5833333,0.24097939,0.58666664,0.24097939,0.59,0.24097939,0.5933333,0.24097939,0.5966667,0.24097939,0.6,0.24097939,0.60333335,0.24097939,0.6066667,0.24097939,0.61,0.24097939,0.61333334,0.24097939,0.6166667,0.24097939,0.62,0.24097939,0.62333333,0.24097939,0.62666667,0.24097939,0.63,0.24097939,0.6333333,0.24097939,0.63666666,0.24097939,0.64,0.24097939,0.6433333,0.24097939,0.64666665,0.24097939,0.65,0.24097939,0.6533333,0.24097939,0.6566667,0.24097939,0.66,0.24097939,0.66333336,0.24097939,0.6666667,0.24097939,0.67,0.24097939,0.67333335,0.24097939,0.6766667,0.24097939,0.68,0.24097939,0.68333334,0.24097939,0.68666667,0.24097939,0.69,0.24097939,0.6933333,0.24097939,0.69666666,0.24097939,0.7,0.24097939,0.7033333,0.24097939,0.70666665,0.24097939,0.71,0.24097939,0.7133333,0.24097939,0.71666664,0.24097939,0.72,0.24097939,0.72333336,0.24097939,0.7266667,0.24097939,0.73,0.24097939,0.73333335,0.24097939,0.7366667,0.24097939,0.74,0.24097939,0.74333334,0.24097939,0.74666667,0.24097939,0.75,0.24097939,0.75333333,0.24097939,0.75666666,0.24097939,0.76,0.24097939,0.7633333,0.24097939,0.76666665,0.24097939,0.77,0.24097939,0.7733333,0.24097939,0.77666664,0.24097939,0.78,0.24097939,0.78333336,0.24097939,0.7866667,0.24097939,0.79,0.24097939,0.79333335,0.24097939,0.7966667,0.24097939,0.8,0.24097939,0.80333334,0.24097939,0.8066667,0.24097939,0.81,0.24097939,0.81333333,0.24097939,0.81666666,0.24097939,0.82,0.24097939,0.8233333,0.24097939,0.82666665,0.24097939,0.83,0.24097939,0.8333333,0.24097939,0.83666664,0.24097939,0.84,0.24097939,0.8433333,0.24097939,0.8466667,0.24097939,0.85,0.24097939,0.85333335,0.24097939,0.8566667,0.24097939,0.86,0.24097939,0.86333334,0.24097939,0.8666667,0.24097939,0.87,0.24097939,0.87333333,0.24097939,0.87666667,0.24097939,0.88,0.24097939,0.8833333,0.24097939,0.88666666,0.24097939,0.89,0.24097939,0.8933333,0.24097939,0.89666665,0.24097939,0.9,0.24097939,0.9033333,0.24097939,0.9066667,0.24097939,0.91,0.24097939,0.91333336,0.24097939,0.9166667,0.24097939,0.92,0.24097939,0.92333335,0.24097939,0.9266667,0.24097939,0.93,0.24097939,0.93333334,0.24097939,0.93666667,0.24097939,0.94,0.24097939,0.9433333,0.24097939,0.94666666,0.24097939,0.05,0.24355671,0.053333335,0.24355671,0.05666667,0.24355671,0.06,0.24355671,0.06333333,0.24355671,0.06666667,0.24355671,0.07,0.24355671,0.07333333,0.24355671,0.07666667,0.24355671,0.08,0.24355671,0.083333336,0.24355671,0.086666666,0.24355671,0.09,0.24355671,0.093333334,0.24355671,0.096666664,0.24355671,0.1,0.24355671,0.10333333,0.24355671,0.10666667,0.24355671,0.11,0.24355671,0.11333334,0.24355671,0.11666667,0.24355671,0.12,0.24355671,0.123333335,0.24355671,0.12666667,0.24355671,0.13,0.24355671,0.13333334,0.24355671,0.13666667,0.24355671,0.14,0.24355671,0.14333333,0.24355671,0.14666666,0.24355671,0.15,0.24355671,0.15333334,0.24355671,0.15666667,0.24355671,0.16,0.24355671,0.16333333,0.24355671,0.16666667,0.24355671,0.17,0.24355671,0.17333333,0.24355671,0.17666666,0.24355671,0.18,0.24355671,0.18333334,0.24355671,0.18666667,0.24355671,0.19,0.24355671,0.19333333,0.24355671,0.19666667,0.24355671,0.2,0.24355671,0.20333333,0.24355671,0.20666666,0.24355671,0.21,0.24355671,0.21333334,0.24355671,0.21666667,0.24355671,0.22,0.24355671,0.22333333,0.24355671,0.22666667,0.24355671,0.23,0.24355671,0.23333333,0.24355671,0.23666666,0.24355671,0.24,0.24355671,0.24333334,0.24355671,0.24666667,0.24355671,0.25,0.24355671,0.25333333,0.24355671,0.26,0.24355671,0.26333332,0.24355671,0.26666668,0.24355671,0.27,0.24355671,0.27333334,0.24355671,0.27666667,0.24355671,0.28,0.24355671,0.28333333,0.24355671,0.28666666,0.24355671,0.29,0.24355671,0.29333332,0.24355671,0.29666665,0.24355671,0.3,0.24355671,0.30333334,0.24355671,0.30666667,0.24355671,0.31,0.24355671,0.31333333,0.24355671,0.31666666,0.24355671,0.32,0.24355671,0.32333332,0.24355671,0.32666665,0.24355671,0.33,0.24355671,0.33333334,0.24355671,0.33666667,0.24355671,0.34,0.24355671,0.34333333,0.24355671,0.34666666,0.24355671,0.35,0.24355671,0.35333332,0.24355671,0.35666665,0.24355671,0.36,0.24355671,0.36333334,0.24355671,0.36666667,0.24355671,0.37,0.24355671,0.37333333,0.24355671,0.37666667,0.24355671,0.38,0.24355671,0.38333333,0.24355671,0.38666666,0.24355671,0.39,0.24355671,0.39333335,0.24355671,0.39666668,0.24355671,0.4,0.24355671,0.40333334,0.24355671,0.40666667,0.24355671,0.41,0.24355671,0.41333333,0.24355671,0.41666666,0.24355671,0.42,0.24355671,0.42333335,0.24355671,0.42666668,0.24355671,0.43,0.24355671,0.43333334,0.24355671,0.43666667,0.24355671,0.44,0.24355671,0.44333333,0.24355671,0.44666666,0.24355671,0.45,0.24355671,0.45333335,0.24355671,0.45666668,0.24355671,0.46,0.24355671,0.46333334,0.24355671,0.46666667,0.24355671,0.47,0.24355671,0.47333333,0.24355671,0.47666666,0.24355671,0.48,0.24355671,0.48333332,0.24355671,0.48666668,0.24355671,0.49,0.24355671,0.49333334,0.24355671,0.49666667,0.24355671,0.5,0.24355671,0.50333333,0.24355671,0.50666666,0.24355671,0.51,0.24355671,0.5133333,0.24355671,0.51666665,0.24355671,0.52,0.24355671,0.5233333,0.24355671,0.52666664,0.24355671,0.53,0.24355671,0.53333336,0.24355671,0.5366667,0.24355671,0.54,0.24355671,0.54333335,0.24355671,0.5466667,0.24355671,0.55,0.24355671,0.55333334,0.24355671,0.5566667,0.24355671,0.56,0.24355671,0.56333333,0.24355671,0.56666666,0.24355671,0.57,0.24355671,0.5733333,0.24355671,0.57666665,0.24355671,0.58,0.24355671,0.5833333,0.24355671,0.58666664,0.24355671,0.59,0.24355671,0.5933333,0.24355671,0.5966667,0.24355671,0.6,0.24355671,0.60333335,0.24355671,0.6066667,0.24355671,0.61,0.24355671,0.61333334,0.24355671,0.6166667,0.24355671,0.62,0.24355671,0.62333333,0.24355671,0.62666667,0.24355671,0.63,0.24355671,0.6333333,0.24355671,0.63666666,0.24355671,0.64,0.24355671,0.6433333,0.24355671,0.64666665,0.24355671,0.65,0.24355671,0.6533333,0.24355671,0.6566667,0.24355671,0.66,0.24355671,0.66333336,0.24355671,0.6666667,0.24355671,0.67,0.24355671,0.67333335,0.24355671,0.6766667,0.24355671,0.68,0.24355671,0.68333334,0.24355671,0.68666667,0.24355671,0.69,0.24355671,0.6933333,0.24355671,0.69666666,0.24355671,0.7,0.24355671,0.7033333,0.24355671,0.70666665,0.24355671,0.71,0.24355671,0.7133333,0.24355671,0.71666664,0.24355671,0.72,0.24355671,0.72333336,0.24355671,0.7266667,0.24355671,0.73,0.24355671,0.73333335,0.24355671,0.7366667,0.24355671,0.74,0.24355671,0.74333334,0.24355671,0.74666667,0.24355671,0.75,0.24355671,0.75333333,0.24355671,0.75666666,0.24355671,0.76,0.24355671,0.7633333,0.24355671,0.76666665,0.24355671,0.77,0.24355671,0.7733333,0.24355671,0.77666664,0.24355671,0.78,0.24355671,0.78333336,0.24355671,0.7866667,0.24355671,0.79,0.24355671,0.79333335,0.24355671,0.7966667,0.24355671,0.8,0.24355671,0.80333334,0.24355671,0.8066667,0.24355671,0.81,0.24355671,0.81333333,0.24355671,0.81666666,0.24355671,0.82,0.24355671,0.8233333,0.24355671,0.82666665,0.24355671,0.83,0.24355671,0.8333333,0.24355671,0.83666664,0.24355671,0.84,0.24355671,0.8433333,0.24355671,0.8466667,0.24355671,0.85,0.24355671,0.85333335,0.24355671,0.8566667,0.24355671,0.86,0.24355671,0.86333334,0.24355671,0.8666667,0.24355671,0.87,0.24355671,0.87333333,0.24355671,0.87666667,0.24355671,0.88,0.24355671,0.8833333,0.24355671,0.88666666,0.24355671,0.89,0.24355671,0.8933333,0.24355671,0.89666665,0.24355671,0.9,0.24355671,0.9033333,0.24355671,0.9066667,0.24355671,0.91,0.24355671,0.91333336,0.24355671,0.9166667,0.24355671,0.92,0.24355671,0.92333335,0.24355671,0.9266667,0.24355671,0.93,0.24355671,0.93333334,0.24355671,0.93666667,0.24355671,0.94,0.24355671,0.9433333,0.24355671,0.94666666,0.24355671,0.05,0.24613403,0.053333335,0.24613403,0.05666667,0.24613403,0.06,0.24613403,0.06333333,0.24613403,0.06666667,0.24613403,0.07,0.24613403,0.07333333,0.24613403,0.07666667,0.24613403,0.08,0.24613403,0.083333336,0.24613403,0.086666666,0.24613403,0.09,0.24613403,0.093333334,0.24613403,0.096666664,0.24613403,0.1,0.24613403,0.10333333,0.24613403,0.10666667,0.24613403,0.11,0.24613403,0.11333334,0.24613403,0.11666667,0.24613403,0.12,0.24613403,0.123333335,0.24613403,0.12666667,0.24613403,0.13,0.24613403,0.13333334,0.24613403,0.13666667,0.24613403,0.14,0.24613403,0.14333333,0.24613403,0.14666666,0.24613403,0.15,0.24613403,0.15333334,0.24613403,0.15666667,0.24613403,0.16,0.24613403,0.16333333,0.24613403,0.16666667,0.24613403,0.17,0.24613403,0.17333333,0.24613403,0.17666666,0.24613403,0.18,0.24613403,0.18333334,0.24613403,0.18666667,0.24613403,0.19,0.24613403,0.19333333,0.24613403,0.19666667,0.24613403,0.2,0.24613403,0.20333333,0.24613403,0.20666666,0.24613403,0.21333334,0.24613403,0.21666667,0.24613403,0.22,0.24613403,0.22333333,0.24613403,0.22666667,0.24613403,0.23,0.24613403,0.23333333,0.24613403,0.23666666,0.24613403,0.24,0.24613403,0.24333334,0.24613403,0.24666667,0.24613403,0.25,0.24613403,0.25333333,0.24613403,0.26,0.24613403,0.26333332,0.24613403,0.26666668,0.24613403,0.27,0.24613403,0.27333334,0.24613403,0.27666667,0.24613403,0.28,0.24613403,0.28333333,0.24613403,0.28666666,0.24613403,0.29,0.24613403,0.29333332,0.24613403,0.29666665,0.24613403,0.3,0.24613403,0.30333334,0.24613403,0.30666667,0.24613403,0.31,0.24613403,0.31333333,0.24613403,0.31666666,0.24613403,0.32,0.24613403,0.32333332,0.24613403,0.32666665,0.24613403,0.33,0.24613403,0.33333334,0.24613403,0.33666667,0.24613403,0.34,0.24613403,0.34333333,0.24613403,0.34666666,0.24613403,0.35,0.24613403,0.35333332,0.24613403,0.35666665,0.24613403,0.36,0.24613403,0.36333334,0.24613403,0.36666667,0.24613403,0.37,0.24613403,0.37333333,0.24613403,0.37666667,0.24613403,0.38,0.24613403,0.38333333,0.24613403,0.38666666,0.24613403,0.39,0.24613403,0.39333335,0.24613403,0.39666668,0.24613403,0.4,0.24613403,0.40333334,0.24613403,0.40666667,0.24613403,0.41,0.24613403,0.41333333,0.24613403,0.41666666,0.24613403,0.42,0.24613403,0.42333335,0.24613403,0.42666668,0.24613403,0.43,0.24613403,0.43333334,0.24613403,0.43666667,0.24613403,0.44,0.24613403,0.44333333,0.24613403,0.44666666,0.24613403,0.45,0.24613403,0.45333335,0.24613403,0.45666668,0.24613403,0.46,0.24613403,0.46333334,0.24613403,0.46666667,0.24613403,0.47,0.24613403,0.47333333,0.24613403,0.47666666,0.24613403,0.48,0.24613403,0.48333332,0.24613403,0.48666668,0.24613403,0.49,0.24613403,0.49333334,0.24613403,0.49666667,0.24613403,0.5,0.24613403,0.50333333,0.24613403,0.50666666,0.24613403,0.51,0.24613403,0.5133333,0.24613403,0.51666665,0.24613403,0.52,0.24613403,0.5233333,0.24613403,0.52666664,0.24613403,0.53,0.24613403,0.53333336,0.24613403,0.5366667,0.24613403,0.54,0.24613403,0.54333335,0.24613403,0.5466667,0.24613403,0.55,0.24613403,0.55333334,0.24613403,0.5566667,0.24613403,0.56,0.24613403,0.56333333,0.24613403,0.56666666,0.24613403,0.57,0.24613403,0.5733333,0.24613403,0.57666665,0.24613403,0.58,0.24613403,0.5833333,0.24613403,0.58666664,0.24613403,0.59,0.24613403,0.5933333,0.24613403,0.5966667,0.24613403,0.6,0.24613403,0.60333335,0.24613403,0.6066667,0.24613403,0.61,0.24613403,0.61333334,0.24613403,0.6166667,0.24613403,0.62,0.24613403,0.62333333,0.24613403,0.62666667,0.24613403,0.63,0.24613403,0.6333333,0.24613403,0.63666666,0.24613403,0.64,0.24613403,0.6433333,0.24613403,0.64666665,0.24613403,0.65,0.24613403,0.6533333,0.24613403,0.6566667,0.24613403,0.66,0.24613403,0.66333336,0.24613403,0.6666667,0.24613403,0.67,0.24613403,0.67333335,0.24613403,0.6766667,0.24613403,0.68,0.24613403,0.68333334,0.24613403,0.68666667,0.24613403,0.69,0.24613403,0.6933333,0.24613403,0.69666666,0.24613403,0.7,0.24613403,0.7033333,0.24613403,0.70666665,0.24613403,0.71,0.24613403,0.7133333,0.24613403,0.71666664,0.24613403,0.72,0.24613403,0.72333336,0.24613403,0.7266667,0.24613403,0.73,0.24613403,0.73333335,0.24613403,0.7366667,0.24613403,0.74,0.24613403,0.74333334,0.24613403,0.74666667,0.24613403,0.75,0.24613403,0.75333333,0.24613403,0.75666666,0.24613403,0.76,0.24613403,0.7633333,0.24613403,0.76666665,0.24613403,0.77,0.24613403,0.7733333,0.24613403,0.77666664,0.24613403,0.78,0.24613403,0.78333336,0.24613403,0.7866667,0.24613403,0.79,0.24613403,0.79333335,0.24613403,0.7966667,0.24613403,0.8,0.24613403,0.80333334,0.24613403,0.8066667,0.24613403,0.81,0.24613403,0.81333333,0.24613403,0.81666666,0.24613403,0.82,0.24613403,0.8233333,0.24613403,0.82666665,0.24613403,0.83,0.24613403,0.8333333,0.24613403,0.83666664,0.24613403,0.84,0.24613403,0.8433333,0.24613403,0.8466667,0.24613403,0.85,0.24613403,0.85333335,0.24613403,0.8566667,0.24613403,0.86,0.24613403,0.86333334,0.24613403,0.8666667,0.24613403,0.87,0.24613403,0.87333333,0.24613403,0.87666667,0.24613403,0.88,0.24613403,0.8833333,0.24613403,0.88666666,0.24613403,0.89,0.24613403,0.8933333,0.24613403,0.89666665,0.24613403,0.9,0.24613403,0.9033333,0.24613403,0.9066667,0.24613403,0.91,0.24613403,0.91333336,0.24613403,0.9166667,0.24613403,0.92,0.24613403,0.92333335,0.24613403,0.9266667,0.24613403,0.93,0.24613403,0.93333334,0.24613403,0.93666667,0.24613403,0.94,0.24613403,0.9433333,0.24613403,0.94666666,0.24613403,0.05,0.24871135,0.053333335,0.24871135,0.05666667,0.24871135,0.06,0.24871135,0.06333333,0.24871135,0.06666667,0.24871135,0.07,0.24871135,0.07333333,0.24871135,0.07666667,0.24871135,0.08,0.24871135,0.083333336,0.24871135,0.086666666,0.24871135,0.09,0.24871135,0.093333334,0.24871135,0.096666664,0.24871135,0.1,0.24871135,0.10333333,0.24871135,0.10666667,0.24871135,0.11,0.24871135,0.11333334,0.24871135,0.11666667,0.24871135,0.12,0.24871135,0.123333335,0.24871135,0.12666667,0.24871135,0.13,0.24871135,0.13333334,0.24871135,0.13666667,0.24871135,0.14,0.24871135,0.14333333,0.24871135,0.14666666,0.24871135,0.15,0.24871135,0.15333334,0.24871135,0.15666667,0.24871135,0.16,0.24871135,0.16333333,0.24871135,0.16666667,0.24871135,0.17,0.24871135,0.17333333,0.24871135,0.17666666,0.24871135,0.18,0.24871135,0.18333334,0.24871135,0.18666667,0.24871135,0.19,0.24871135,0.19333333,0.24871135,0.19666667,0.24871135,0.2,0.24871135,0.20333333,0.24871135,0.20666666,0.24871135,0.21333334,0.24871135,0.21666667,0.24871135,0.22,0.24871135,0.22333333,0.24871135,0.22666667,0.24871135,0.23,0.24871135,0.23333333,0.24871135,0.23666666,0.24871135,0.24,0.24871135,0.24333334,0.24871135,0.24666667,0.24871135,0.25,0.24871135,0.25333333,0.24871135,0.26,0.24871135,0.26333332,0.24871135,0.26666668,0.24871135,0.27,0.24871135,0.27333334,0.24871135,0.27666667,0.24871135,0.28,0.24871135,0.28333333,0.24871135,0.28666666,0.24871135,0.29,0.24871135,0.29333332,0.24871135,0.29666665,0.24871135,0.3,0.24871135,0.30333334,0.24871135,0.30666667,0.24871135,0.31,0.24871135,0.31333333,0.24871135,0.31666666,0.24871135,0.32,0.24871135,0.32333332,0.24871135,0.32666665,0.24871135,0.33,0.24871135,0.33333334,0.24871135,0.33666667,0.24871135,0.34666666,0.24871135,0.35,0.24871135,0.35333332,0.24871135,0.39333335,0.24871135,0.39666668,0.24871135,0.4,0.24871135,0.40333334,0.24871135,0.40666667,0.24871135,0.41,0.24871135,0.41333333,0.24871135,0.41666666,0.24871135,0.42,0.24871135,0.42333335,0.24871135,0.42666668,0.24871135,0.43,0.24871135,0.43333334,0.24871135,0.43666667,0.24871135,0.44,0.24871135,0.44333333,0.24871135,0.44666666,0.24871135,0.45,0.24871135,0.45333335,0.24871135,0.45666668,0.24871135,0.46,0.24871135,0.46333334,0.24871135,0.46666667,0.24871135,0.47,0.24871135,0.47333333,0.24871135,0.47666666,0.24871135,0.48,0.24871135,0.48333332,0.24871135,0.48666668,0.24871135,0.49,0.24871135,0.49333334,0.24871135,0.49666667,0.24871135,0.5,0.24871135,0.50333333,0.24871135,0.50666666,0.24871135,0.51,0.24871135,0.5133333,0.24871135,0.51666665,0.24871135,0.52,0.24871135,0.5233333,0.24871135,0.52666664,0.24871135,0.53,0.24871135,0.53333336,0.24871135,0.5366667,0.24871135,0.54,0.24871135,0.54333335,0.24871135,0.5466667,0.24871135,0.55,0.24871135,0.55333334,0.24871135,0.5566667,0.24871135,0.56,0.24871135,0.56333333,0.24871135,0.56666666,0.24871135,0.57,0.24871135,0.5733333,0.24871135,0.57666665,0.24871135,0.58,0.24871135,0.5833333,0.24871135,0.58666664,0.24871135,0.59,0.24871135,0.5933333,0.24871135,0.5966667,0.24871135,0.6,0.24871135,0.60333335,0.24871135,0.6066667,0.24871135,0.61,0.24871135,0.61333334,0.24871135,0.6166667,0.24871135,0.62,0.24871135,0.62333333,0.24871135,0.62666667,0.24871135,0.63,0.24871135,0.6333333,0.24871135,0.63666666,0.24871135,0.64,0.24871135,0.6433333,0.24871135,0.64666665,0.24871135,0.65,0.24871135,0.6533333,0.24871135,0.6566667,0.24871135,0.66,0.24871135,0.66333336,0.24871135,0.6666667,0.24871135,0.67,0.24871135,0.67333335,0.24871135,0.6766667,0.24871135,0.68,0.24871135,0.68333334,0.24871135,0.68666667,0.24871135,0.69,0.24871135,0.6933333,0.24871135,0.69666666,0.24871135,0.7,0.24871135,0.7033333,0.24871135,0.70666665,0.24871135,0.71,0.24871135,0.7133333,0.24871135,0.71666664,0.24871135,0.72,0.24871135,0.72333336,0.24871135,0.7266667,0.24871135,0.73,0.24871135,0.73333335,0.24871135,0.7366667,0.24871135,0.74,0.24871135,0.74333334,0.24871135,0.74666667,0.24871135,0.75,0.24871135,0.75333333,0.24871135,0.75666666,0.24871135,0.76,0.24871135,0.7633333,0.24871135,0.76666665,0.24871135,0.77,0.24871135,0.7733333,0.24871135,0.77666664,0.24871135,0.78,0.24871135,0.78333336,0.24871135,0.7866667,0.24871135,0.79,0.24871135,0.79333335,0.24871135,0.7966667,0.24871135,0.8,0.24871135,0.80333334,0.24871135,0.8066667,0.24871135,0.81,0.24871135,0.81333333,0.24871135,0.81666666,0.24871135,0.82,0.24871135,0.8233333,0.24871135,0.82666665,0.24871135,0.83,0.24871135,0.8333333,0.24871135,0.83666664,0.24871135,0.84,0.24871135,0.8433333,0.24871135,0.8466667,0.24871135,0.85,0.24871135,0.85333335,0.24871135,0.8566667,0.24871135,0.86,0.24871135,0.86333334,0.24871135,0.8666667,0.24871135,0.87,0.24871135,0.87333333,0.24871135,0.87666667,0.24871135,0.88,0.24871135,0.8833333,0.24871135,0.88666666,0.24871135,0.89,0.24871135,0.8933333,0.24871135,0.89666665,0.24871135,0.9,0.24871135,0.9033333,0.24871135,0.9066667,0.24871135,0.91,0.24871135,0.91333336,0.24871135,0.9166667,0.24871135,0.92,0.24871135,0.92333335,0.24871135,0.9266667,0.24871135,0.93,0.24871135,0.93333334,0.24871135,0.93666667,0.24871135,0.94,0.24871135,0.9433333,0.24871135,0.94666666,0.24871135,0.05,0.25128865,0.053333335,0.25128865,0.05666667,0.25128865,0.06,0.25128865,0.06333333,0.25128865,0.06666667,0.25128865,0.07,0.25128865,0.07333333,0.25128865,0.07666667,0.25128865,0.08,0.25128865,0.083333336,0.25128865,0.086666666,0.25128865,0.09,0.25128865,0.093333334,0.25128865,0.096666664,0.25128865,0.1,0.25128865,0.10333333,0.25128865,0.10666667,0.25128865,0.11,0.25128865,0.11333334,0.25128865,0.11666667,0.25128865,0.12,0.25128865,0.123333335,0.25128865,0.12666667,0.25128865,0.13,0.25128865,0.13333334,0.25128865,0.13666667,0.25128865,0.14,0.25128865,0.14333333,0.25128865,0.14666666,0.25128865,0.15,0.25128865,0.15333334,0.25128865,0.15666667,0.25128865,0.16,0.25128865,0.16333333,0.25128865,0.16666667,0.25128865,0.17,0.25128865,0.17333333,0.25128865,0.17666666,0.25128865,0.18,0.25128865,0.18333334,0.25128865,0.18666667,0.25128865,0.19,0.25128865,0.19333333,0.25128865,0.19666667,0.25128865,0.2,0.25128865,0.20333333,0.25128865,0.20666666,0.25128865,0.21,0.25128865,0.21333334,0.25128865,0.21666667,0.25128865,0.22,0.25128865,0.22333333,0.25128865,0.22666667,0.25128865,0.23,0.25128865,0.23333333,0.25128865,0.23666666,0.25128865,0.24,0.25128865,0.24333334,0.25128865,0.24666667,0.25128865,0.25,0.25128865,0.25333333,0.25128865,0.26,0.25128865,0.26333332,0.25128865,0.26666668,0.25128865,0.27,0.25128865,0.27333334,0.25128865,0.27666667,0.25128865,0.28,0.25128865,0.28333333,0.25128865,0.28666666,0.25128865,0.29,0.25128865,0.29333332,0.25128865,0.29666665,0.25128865,0.3,0.25128865,0.30333334,0.25128865,0.30666667,0.25128865,0.31,0.25128865,0.31333333,0.25128865,0.31666666,0.25128865,0.32,0.25128865,0.32333332,0.25128865,0.32666665,0.25128865,0.33,0.25128865,0.33333334,0.25128865,0.34,0.25128865,0.34333333,0.25128865,0.34666666,0.25128865,0.35,0.25128865,0.35333332,0.25128865,0.35666665,0.25128865,0.36,0.25128865,0.36333334,0.25128865,0.36666667,0.25128865,0.37,0.25128865,0.37333333,0.25128865,0.37666667,0.25128865,0.38,0.25128865,0.38333333,0.25128865,0.38666666,0.25128865,0.39,0.25128865,0.39666668,0.25128865,0.4,0.25128865,0.40333334,0.25128865,0.40666667,0.25128865,0.41,0.25128865,0.41333333,0.25128865,0.41666666,0.25128865,0.42,0.25128865,0.42333335,0.25128865,0.42666668,0.25128865,0.43,0.25128865,0.43333334,0.25128865,0.43666667,0.25128865,0.44,0.25128865,0.44333333,0.25128865,0.44666666,0.25128865,0.45,0.25128865,0.45333335,0.25128865,0.45666668,0.25128865,0.46,0.25128865,0.46333334,0.25128865,0.46666667,0.25128865,0.47,0.25128865,0.47333333,0.25128865,0.47666666,0.25128865,0.48,0.25128865,0.48333332,0.25128865,0.48666668,0.25128865,0.49,0.25128865,0.49333334,0.25128865,0.49666667,0.25128865,0.5,0.25128865,0.50333333,0.25128865,0.50666666,0.25128865,0.51,0.25128865,0.5133333,0.25128865,0.51666665,0.25128865,0.52,0.25128865,0.5233333,0.25128865,0.52666664,0.25128865,0.53,0.25128865,0.53333336,0.25128865,0.5366667,0.25128865,0.54,0.25128865,0.54333335,0.25128865,0.5466667,0.25128865,0.55,0.25128865,0.55333334,0.25128865,0.5566667,0.25128865,0.56,0.25128865,0.56333333,0.25128865,0.56666666,0.25128865,0.57,0.25128865,0.5733333,0.25128865,0.57666665,0.25128865,0.58,0.25128865,0.5833333,0.25128865,0.58666664,0.25128865,0.59,0.25128865,0.5933333,0.25128865,0.5966667,0.25128865,0.6,0.25128865,0.60333335,0.25128865,0.6066667,0.25128865,0.61,0.25128865,0.61333334,0.25128865,0.6166667,0.25128865,0.62,0.25128865,0.62333333,0.25128865,0.62666667,0.25128865,0.63,0.25128865,0.6333333,0.25128865,0.63666666,0.25128865,0.64,0.25128865,0.6433333,0.25128865,0.64666665,0.25128865,0.65,0.25128865,0.6533333,0.25128865,0.6566667,0.25128865,0.66,0.25128865,0.66333336,0.25128865,0.6666667,0.25128865,0.67,0.25128865,0.67333335,0.25128865,0.6766667,0.25128865,0.68,0.25128865,0.68333334,0.25128865,0.68666667,0.25128865,0.69,0.25128865,0.6933333,0.25128865,0.69666666,0.25128865,0.7,0.25128865,0.7033333,0.25128865,0.70666665,0.25128865,0.71,0.25128865,0.7133333,0.25128865,0.71666664,0.25128865,0.72,0.25128865,0.72333336,0.25128865,0.7266667,0.25128865,0.73,0.25128865,0.73333335,0.25128865,0.7366667,0.25128865,0.74,0.25128865,0.74333334,0.25128865,0.74666667,0.25128865,0.75,0.25128865,0.75333333,0.25128865,0.75666666,0.25128865,0.76,0.25128865,0.7633333,0.25128865,0.76666665,0.25128865,0.77,0.25128865,0.7733333,0.25128865,0.77666664,0.25128865,0.78,0.25128865,0.78333336,0.25128865,0.7866667,0.25128865,0.79,0.25128865,0.79333335,0.25128865,0.7966667,0.25128865,0.8,0.25128865,0.80333334,0.25128865,0.8066667,0.25128865,0.81,0.25128865,0.81333333,0.25128865,0.81666666,0.25128865,0.82,0.25128865,0.8233333,0.25128865,0.82666665,0.25128865,0.83,0.25128865,0.8333333,0.25128865,0.83666664,0.25128865,0.84,0.25128865,0.8433333,0.25128865,0.8466667,0.25128865,0.85,0.25128865,0.85333335,0.25128865,0.8566667,0.25128865,0.86,0.25128865,0.86333334,0.25128865,0.8666667,0.25128865,0.87,0.25128865,0.87333333,0.25128865,0.87666667,0.25128865,0.88,0.25128865,0.8833333,0.25128865,0.88666666,0.25128865,0.89,0.25128865,0.8933333,0.25128865,0.89666665,0.25128865,0.9,0.25128865,0.9033333,0.25128865,0.9066667,0.25128865,0.91,0.25128865,0.91333336,0.25128865,0.9166667,0.25128865,0.92,0.25128865,0.92333335,0.25128865,0.9266667,0.25128865,0.93,0.25128865,0.93333334,0.25128865,0.93666667,0.25128865,0.94,0.25128865,0.9433333,0.25128865,0.94666666,0.25128865,0.05,0.253866,0.053333335,0.253866,0.05666667,0.253866,0.06,0.253866,0.06333333,0.253866,0.06666667,0.253866,0.07,0.253866,0.07333333,0.253866,0.07666667,0.253866,0.08,0.253866,0.083333336,0.253866,0.086666666,0.253866,0.09,0.253866,0.093333334,0.253866,0.096666664,0.253866,0.1,0.253866,0.10333333,0.253866,0.10666667,0.253866,0.11,0.253866,0.11333334,0.253866,0.11666667,0.253866,0.12,0.253866,0.123333335,0.253866,0.12666667,0.253866,0.13,0.253866,0.13333334,0.253866,0.13666667,0.253866,0.14,0.253866,0.14333333,0.253866,0.14666666,0.253866,0.15,0.253866,0.15333334,0.253866,0.15666667,0.253866,0.16,0.253866,0.16333333,0.253866,0.16666667,0.253866,0.17,0.253866,0.17333333,0.253866,0.17666666,0.253866,0.18,0.253866,0.18333334,0.253866,0.18666667,0.253866,0.19,0.253866,0.19333333,0.253866,0.19666667,0.253866,0.2,0.253866,0.20333333,0.253866,0.20666666,0.253866,0.21,0.253866,0.21333334,0.253866,0.21666667,0.253866,0.22,0.253866,0.22333333,0.253866,0.22666667,0.253866,0.23,0.253866,0.23333333,0.253866,0.23666666,0.253866,0.24,0.253866,0.24333334,0.253866,0.24666667,0.253866,0.25,0.253866,0.25333333,0.253866,0.26,0.253866,0.26333332,0.253866,0.26666668,0.253866,0.27,0.253866,0.27333334,0.253866,0.27666667,0.253866,0.28,0.253866,0.28333333,0.253866,0.28666666,0.253866,0.29,0.253866,0.29333332,0.253866,0.29666665,0.253866,0.3,0.253866,0.30333334,0.253866,0.30666667,0.253866,0.31,0.253866,0.31333333,0.253866,0.31666666,0.253866,0.32,0.253866,0.32333332,0.253866,0.32666665,0.253866,0.33,0.253866,0.33666667,0.253866,0.34,0.253866,0.34333333,0.253866,0.34666666,0.253866,0.35,0.253866,0.35333332,0.253866,0.35666665,0.253866,0.36,0.253866,0.36333334,0.253866,0.36666667,0.253866,0.37,0.253866,0.37333333,0.253866,0.37666667,0.253866,0.38,0.253866,0.38333333,0.253866,0.38666666,0.253866,0.39,0.253866,0.4,0.253866,0.40333334,0.253866,0.40666667,0.253866,0.41,0.253866,0.41333333,0.253866,0.41666666,0.253866,0.42,0.253866,0.42333335,0.253866,0.42666668,0.253866,0.43,0.253866,0.43333334,0.253866,0.43666667,0.253866,0.44,0.253866,0.44333333,0.253866,0.44666666,0.253866,0.45,0.253866,0.45333335,0.253866,0.45666668,0.253866,0.46,0.253866,0.46333334,0.253866,0.46666667,0.253866,0.47,0.253866,0.47333333,0.253866,0.47666666,0.253866,0.48,0.253866,0.48333332,0.253866,0.48666668,0.253866,0.49,0.253866,0.49333334,0.253866,0.49666667,0.253866,0.5,0.253866,0.50333333,0.253866,0.50666666,0.253866,0.51,0.253866,0.5133333,0.253866,0.51666665,0.253866,0.52,0.253866,0.5233333,0.253866,0.52666664,0.253866,0.53,0.253866,0.53333336,0.253866,0.5366667,0.253866,0.54,0.253866,0.54333335,0.253866,0.5466667,0.253866,0.55,0.253866,0.55333334,0.253866,0.5566667,0.253866,0.56,0.253866,0.56333333,0.253866,0.56666666,0.253866,0.57,0.253866,0.5733333,0.253866,0.57666665,0.253866,0.58,0.253866,0.5833333,0.253866,0.58666664,0.253866,0.59,0.253866,0.5933333,0.253866,0.5966667,0.253866,0.6,0.253866,0.60333335,0.253866,0.6066667,0.253866,0.61,0.253866,0.61333334,0.253866,0.6166667,0.253866,0.62,0.253866,0.62333333,0.253866,0.62666667,0.253866,0.63,0.253866,0.6333333,0.253866,0.63666666,0.253866,0.64,0.253866,0.6433333,0.253866,0.64666665,0.253866,0.65,0.253866,0.6533333,0.253866,0.6566667,0.253866,0.66,0.253866,0.66333336,0.253866,0.6666667,0.253866,0.67,0.253866,0.67333335,0.253866,0.6766667,0.253866,0.68,0.253866,0.68333334,0.253866,0.68666667,0.253866,0.69,0.253866,0.6933333,0.253866,0.69666666,0.253866,0.7,0.253866,0.7033333,0.253866,0.70666665,0.253866,0.71,0.253866,0.7133333,0.253866,0.71666664,0.253866,0.72,0.253866,0.72333336,0.253866,0.7266667,0.253866,0.73,0.253866,0.73333335,0.253866,0.7366667,0.253866,0.74,0.253866,0.74333334,0.253866,0.74666667,0.253866,0.75,0.253866,0.75333333,0.253866,0.75666666,0.253866,0.76,0.253866,0.7633333,0.253866,0.76666665,0.253866,0.77,0.253866,0.7733333,0.253866,0.77666664,0.253866,0.78,0.253866,0.78333336,0.253866,0.7866667,0.253866,0.79,0.253866,0.79333335,0.253866,0.7966667,0.253866,0.8,0.253866,0.80333334,0.253866,0.8066667,0.253866,0.81,0.253866,0.81333333,0.253866,0.81666666,0.253866,0.82,0.253866,0.8233333,0.253866,0.82666665,0.253866,0.83,0.253866,0.8333333,0.253866,0.83666664,0.253866,0.84,0.253866,0.8433333,0.253866,0.8466667,0.253866,0.85,0.253866,0.85333335,0.253866,0.8566667,0.253866,0.86,0.253866,0.86333334,0.253866,0.8666667,0.253866,0.87,0.253866,0.87333333,0.253866,0.87666667,0.253866,0.88,0.253866,0.8833333,0.253866,0.88666666,0.253866,0.89,0.253866,0.8933333,0.253866,0.89666665,0.253866,0.9,0.253866,0.9033333,0.253866,0.9066667,0.253866,0.91,0.253866,0.91333336,0.253866,0.9166667,0.253866,0.92,0.253866,0.92333335,0.253866,0.9266667,0.253866,0.93,0.253866,0.93333334,0.253866,0.93666667,0.253866,0.94,0.253866,0.9433333,0.253866,0.94666666,0.253866,0.05,0.2564433,0.053333335,0.2564433,0.05666667,0.2564433,0.06,0.2564433,0.06333333,0.2564433,0.06666667,0.2564433,0.07,0.2564433,0.07333333,0.2564433,0.07666667,0.2564433,0.08,0.2564433,0.083333336,0.2564433,0.086666666,0.2564433,0.09,0.2564433,0.093333334,0.2564433,0.096666664,0.2564433,0.1,0.2564433,0.10333333,0.2564433,0.10666667,0.2564433,0.11,0.2564433,0.11333334,0.2564433,0.11666667,0.2564433,0.12,0.2564433,0.123333335,0.2564433,0.12666667,0.2564433,0.13,0.2564433,0.13333334,0.2564433,0.13666667,0.2564433,0.14,0.2564433,0.14333333,0.2564433,0.14666666,0.2564433,0.15,0.2564433,0.15333334,0.2564433,0.15666667,0.2564433,0.16,0.2564433,0.16333333,0.2564433,0.16666667,0.2564433,0.17,0.2564433,0.17333333,0.2564433,0.17666666,0.2564433,0.18,0.2564433,0.18333334,0.2564433,0.18666667,0.2564433,0.19,0.2564433,0.19333333,0.2564433,0.19666667,0.2564433,0.2,0.2564433,0.20333333,0.2564433,0.20666666,0.2564433,0.21,0.2564433,0.21333334,0.2564433,0.21666667,0.2564433,0.22,0.2564433,0.22333333,0.2564433,0.22666667,0.2564433,0.23,0.2564433,0.23333333,0.2564433,0.23666666,0.2564433,0.24,0.2564433,0.24333334,0.2564433,0.24666667,0.2564433,0.25,0.2564433,0.25333333,0.2564433,0.25666666,0.2564433,0.26,0.2564433,0.26333332,0.2564433,0.26666668,0.2564433,0.27,0.2564433,0.27333334,0.2564433,0.27666667,0.2564433,0.28,0.2564433,0.28333333,0.2564433,0.28666666,0.2564433,0.29,0.2564433,0.29333332,0.2564433,0.29666665,0.2564433,0.3,0.2564433,0.30333334,0.2564433,0.30666667,0.2564433,0.31,0.2564433,0.31333333,0.2564433,0.31666666,0.2564433,0.32,0.2564433,0.32333332,0.2564433,0.32666665,0.2564433,0.33,0.2564433,0.33333334,0.2564433,0.33666667,0.2564433,0.34,0.2564433,0.34333333,0.2564433,0.34666666,0.2564433,0.35,0.2564433,0.35333332,0.2564433,0.35666665,0.2564433,0.36,0.2564433,0.36333334,0.2564433,0.36666667,0.2564433,0.37,0.2564433,0.37333333,0.2564433,0.37666667,0.2564433,0.38,0.2564433,0.38333333,0.2564433,0.38666666,0.2564433,0.39,0.2564433,0.39333335,0.2564433,0.4,0.2564433,0.40333334,0.2564433,0.40666667,0.2564433,0.41,0.2564433,0.41333333,0.2564433,0.41666666,0.2564433,0.42,0.2564433,0.42333335,0.2564433,0.42666668,0.2564433,0.43,0.2564433,0.43333334,0.2564433,0.43666667,0.2564433,0.44,0.2564433,0.44333333,0.2564433,0.44666666,0.2564433,0.45,0.2564433,0.45333335,0.2564433,0.45666668,0.2564433,0.46,0.2564433,0.46333334,0.2564433,0.46666667,0.2564433,0.47,0.2564433,0.47333333,0.2564433,0.47666666,0.2564433,0.48,0.2564433,0.48333332,0.2564433,0.48666668,0.2564433,0.49,0.2564433,0.49333334,0.2564433,0.49666667,0.2564433,0.5,0.2564433,0.50333333,0.2564433,0.50666666,0.2564433,0.51,0.2564433,0.5133333,0.2564433,0.51666665,0.2564433,0.52,0.2564433,0.5233333,0.2564433,0.52666664,0.2564433,0.53,0.2564433,0.53333336,0.2564433,0.5366667,0.2564433,0.54,0.2564433,0.54333335,0.2564433,0.5466667,0.2564433,0.55,0.2564433,0.55333334,0.2564433,0.5566667,0.2564433,0.56,0.2564433,0.56333333,0.2564433,0.56666666,0.2564433,0.57,0.2564433,0.5733333,0.2564433,0.57666665,0.2564433,0.58,0.2564433,0.5833333,0.2564433,0.58666664,0.2564433,0.59,0.2564433,0.5933333,0.2564433,0.5966667,0.2564433,0.6,0.2564433,0.60333335,0.2564433,0.6066667,0.2564433,0.61,0.2564433,0.61333334,0.2564433,0.6166667,0.2564433,0.62,0.2564433,0.62333333,0.2564433,0.62666667,0.2564433,0.63,0.2564433,0.6333333,0.2564433,0.63666666,0.2564433,0.64,0.2564433,0.6433333,0.2564433,0.64666665,0.2564433,0.65,0.2564433,0.6533333,0.2564433,0.6566667,0.2564433,0.66,0.2564433,0.66333336,0.2564433,0.6666667,0.2564433,0.67,0.2564433,0.67333335,0.2564433,0.6766667,0.2564433,0.68,0.2564433,0.68333334,0.2564433,0.68666667,0.2564433,0.69,0.2564433,0.6933333,0.2564433,0.69666666,0.2564433,0.7,0.2564433,0.7033333,0.2564433,0.70666665,0.2564433,0.71,0.2564433,0.7133333,0.2564433,0.71666664,0.2564433,0.72,0.2564433,0.72333336,0.2564433,0.7266667,0.2564433,0.73,0.2564433,0.73333335,0.2564433,0.7366667,0.2564433,0.74,0.2564433,0.74333334,0.2564433,0.74666667,0.2564433,0.75,0.2564433,0.75333333,0.2564433,0.75666666,0.2564433,0.76,0.2564433,0.7633333,0.2564433,0.76666665,0.2564433,0.77,0.2564433,0.7733333,0.2564433,0.77666664,0.2564433,0.78,0.2564433,0.78333336,0.2564433,0.7866667,0.2564433,0.79,0.2564433,0.79333335,0.2564433,0.7966667,0.2564433,0.8,0.2564433,0.80333334,0.2564433,0.8066667,0.2564433,0.81,0.2564433,0.81333333,0.2564433,0.81666666,0.2564433,0.82,0.2564433,0.8233333,0.2564433,0.82666665,0.2564433,0.83,0.2564433,0.8333333,0.2564433,0.83666664,0.2564433,0.84,0.2564433,0.8433333,0.2564433,0.8466667,0.2564433,0.85,0.2564433,0.85333335,0.2564433,0.8566667,0.2564433,0.86,0.2564433,0.86333334,0.2564433,0.8666667,0.2564433,0.87,0.2564433,0.87333333,0.2564433,0.87666667,0.2564433,0.88,0.2564433,0.8833333,0.2564433,0.88666666,0.2564433,0.89,0.2564433,0.8933333,0.2564433,0.89666665,0.2564433,0.9,0.2564433,0.9033333,0.2564433,0.9066667,0.2564433,0.91,0.2564433,0.91333336,0.2564433,0.9166667,0.2564433,0.92,0.2564433,0.92333335,0.2564433,0.9266667,0.2564433,0.93,0.2564433,0.93333334,0.2564433,0.93666667,0.2564433,0.94,0.2564433,0.9433333,0.2564433,0.94666666,0.2564433,0.05,0.25902063,0.053333335,0.25902063,0.05666667,0.25902063,0.06,0.25902063,0.06333333,0.25902063,0.06666667,0.25902063,0.07,0.25902063,0.07333333,0.25902063,0.07666667,0.25902063,0.08,0.25902063,0.083333336,0.25902063,0.086666666,0.25902063,0.09,0.25902063,0.093333334,0.25902063,0.096666664,0.25902063,0.1,0.25902063,0.10333333,0.25902063,0.10666667,0.25902063,0.11,0.25902063,0.11333334,0.25902063,0.11666667,0.25902063,0.12,0.25902063,0.123333335,0.25902063,0.12666667,0.25902063,0.13,0.25902063,0.13333334,0.25902063,0.13666667,0.25902063,0.14,0.25902063,0.14333333,0.25902063,0.14666666,0.25902063,0.15,0.25902063,0.15333334,0.25902063,0.15666667,0.25902063,0.16,0.25902063,0.16333333,0.25902063,0.16666667,0.25902063,0.17,0.25902063,0.17333333,0.25902063,0.17666666,0.25902063,0.18,0.25902063,0.18333334,0.25902063,0.18666667,0.25902063,0.19,0.25902063,0.19333333,0.25902063,0.19666667,0.25902063,0.2,0.25902063,0.20333333,0.25902063,0.20666666,0.25902063,0.21,0.25902063,0.21333334,0.25902063,0.21666667,0.25902063,0.22,0.25902063,0.22333333,0.25902063,0.22666667,0.25902063,0.23,0.25902063,0.23333333,0.25902063,0.23666666,0.25902063,0.24,0.25902063,0.24333334,0.25902063,0.24666667,0.25902063,0.25,0.25902063,0.25333333,0.25902063,0.25666666,0.25902063,0.26,0.25902063,0.26333332,0.25902063,0.26666668,0.25902063,0.27,0.25902063,0.27333334,0.25902063,0.27666667,0.25902063,0.28,0.25902063,0.28333333,0.25902063,0.28666666,0.25902063,0.29,0.25902063,0.29333332,0.25902063,0.29666665,0.25902063,0.3,0.25902063,0.30333334,0.25902063,0.30666667,0.25902063,0.31,0.25902063,0.31333333,0.25902063,0.31666666,0.25902063,0.32,0.25902063,0.32333332,0.25902063,0.32666665,0.25902063,0.33333334,0.25902063,0.33666667,0.25902063,0.34,0.25902063,0.34333333,0.25902063,0.34666666,0.25902063,0.35,0.25902063,0.35333332,0.25902063,0.35666665,0.25902063,0.36,0.25902063,0.36333334,0.25902063,0.36666667,0.25902063,0.37,0.25902063,0.37333333,0.25902063,0.37666667,0.25902063,0.38,0.25902063,0.38333333,0.25902063,0.38666666,0.25902063,0.39,0.25902063,0.39333335,0.25902063,0.39666668,0.25902063,0.40333334,0.25902063,0.40666667,0.25902063,0.41,0.25902063,0.41333333,0.25902063,0.41666666,0.25902063,0.42,0.25902063,0.42333335,0.25902063,0.42666668,0.25902063,0.43,0.25902063,0.43333334,0.25902063,0.43666667,0.25902063,0.44,0.25902063,0.44333333,0.25902063,0.44666666,0.25902063,0.45,0.25902063,0.45333335,0.25902063,0.45666668,0.25902063,0.46,0.25902063,0.46333334,0.25902063,0.46666667,0.25902063,0.47,0.25902063,0.47333333,0.25902063,0.47666666,0.25902063,0.48,0.25902063,0.48333332,0.25902063,0.48666668,0.25902063,0.49,0.25902063,0.49333334,0.25902063,0.49666667,0.25902063,0.5,0.25902063,0.50333333,0.25902063,0.50666666,0.25902063,0.51,0.25902063,0.5133333,0.25902063,0.51666665,0.25902063,0.52,0.25902063,0.5233333,0.25902063,0.52666664,0.25902063,0.53,0.25902063,0.53333336,0.25902063,0.5366667,0.25902063,0.54,0.25902063,0.54333335,0.25902063,0.5466667,0.25902063,0.55,0.25902063,0.55333334,0.25902063,0.5566667,0.25902063,0.56,0.25902063,0.56333333,0.25902063,0.56666666,0.25902063,0.57,0.25902063,0.5733333,0.25902063,0.57666665,0.25902063,0.58,0.25902063,0.5833333,0.25902063,0.58666664,0.25902063,0.59,0.25902063,0.5933333,0.25902063,0.5966667,0.25902063,0.6,0.25902063,0.60333335,0.25902063,0.6066667,0.25902063,0.61,0.25902063,0.61333334,0.25902063,0.6166667,0.25902063,0.62,0.25902063,0.62333333,0.25902063,0.62666667,0.25902063,0.63,0.25902063,0.6333333,0.25902063,0.63666666,0.25902063,0.64,0.25902063,0.6433333,0.25902063,0.64666665,0.25902063,0.65,0.25902063,0.6533333,0.25902063,0.6566667,0.25902063,0.66,0.25902063,0.66333336,0.25902063,0.6666667,0.25902063,0.67,0.25902063,0.67333335,0.25902063,0.6766667,0.25902063,0.68,0.25902063,0.68333334,0.25902063,0.68666667,0.25902063,0.69,0.25902063,0.6933333,0.25902063,0.69666666,0.25902063,0.7,0.25902063,0.7033333,0.25902063,0.70666665,0.25902063,0.71,0.25902063,0.7133333,0.25902063,0.71666664,0.25902063,0.72,0.25902063,0.72333336,0.25902063,0.7266667,0.25902063,0.73,0.25902063,0.73333335,0.25902063,0.7366667,0.25902063,0.74,0.25902063,0.74333334,0.25902063,0.74666667,0.25902063,0.75,0.25902063,0.75333333,0.25902063,0.75666666,0.25902063,0.76,0.25902063,0.7633333,0.25902063,0.76666665,0.25902063,0.77,0.25902063,0.7733333,0.25902063,0.77666664,0.25902063,0.78,0.25902063,0.78333336,0.25902063,0.7866667,0.25902063,0.79,0.25902063,0.79333335,0.25902063,0.7966667,0.25902063,0.8,0.25902063,0.80333334,0.25902063,0.8066667,0.25902063,0.81,0.25902063,0.81333333,0.25902063,0.81666666,0.25902063,0.82,0.25902063,0.8233333,0.25902063,0.82666665,0.25902063,0.83,0.25902063,0.8333333,0.25902063,0.83666664,0.25902063,0.84,0.25902063,0.8433333,0.25902063,0.8466667,0.25902063,0.85,0.25902063,0.85333335,0.25902063,0.8566667,0.25902063,0.86,0.25902063,0.86333334,0.25902063,0.8666667,0.25902063,0.87,0.25902063,0.87333333,0.25902063,0.87666667,0.25902063,0.88,0.25902063,0.8833333,0.25902063,0.88666666,0.25902063,0.89,0.25902063,0.8933333,0.25902063,0.89666665,0.25902063,0.9,0.25902063,0.9033333,0.25902063,0.9066667,0.25902063,0.91,0.25902063,0.91333336,0.25902063,0.9166667,0.25902063,0.92,0.25902063,0.92333335,0.25902063,0.9266667,0.25902063,0.93,0.25902063,0.93333334,0.25902063,0.93666667,0.25902063,0.94,0.25902063,0.9433333,0.25902063,0.94666666,0.25902063,0.05,0.26159793,0.053333335,0.26159793,0.05666667,0.26159793,0.06,0.26159793,0.06333333,0.26159793,0.06666667,0.26159793,0.07,0.26159793,0.07333333,0.26159793,0.07666667,0.26159793,0.08,0.26159793,0.083333336,0.26159793,0.086666666,0.26159793,0.09,0.26159793,0.093333334,0.26159793,0.096666664,0.26159793,0.1,0.26159793,0.10333333,0.26159793,0.10666667,0.26159793,0.11,0.26159793,0.11333334,0.26159793,0.11666667,0.26159793,0.12,0.26159793,0.123333335,0.26159793,0.12666667,0.26159793,0.13,0.26159793,0.13333334,0.26159793,0.13666667,0.26159793,0.14,0.26159793,0.14333333,0.26159793,0.14666666,0.26159793,0.15,0.26159793,0.15333334,0.26159793,0.15666667,0.26159793,0.16,0.26159793,0.16333333,0.26159793,0.16666667,0.26159793,0.17,0.26159793,0.17333333,0.26159793,0.17666666,0.26159793,0.18,0.26159793,0.18333334,0.26159793,0.18666667,0.26159793,0.19,0.26159793,0.19333333,0.26159793,0.19666667,0.26159793,0.2,0.26159793,0.20333333,0.26159793,0.20666666,0.26159793,0.21,0.26159793,0.21333334,0.26159793,0.21666667,0.26159793,0.22,0.26159793,0.22333333,0.26159793,0.22666667,0.26159793,0.23,0.26159793,0.23333333,0.26159793,0.23666666,0.26159793,0.24,0.26159793,0.24333334,0.26159793,0.24666667,0.26159793,0.25,0.26159793,0.25333333,0.26159793,0.25666666,0.26159793,0.26,0.26159793,0.26333332,0.26159793,0.26666668,0.26159793,0.27,0.26159793,0.27333334,0.26159793,0.27666667,0.26159793,0.28,0.26159793,0.28333333,0.26159793,0.28666666,0.26159793,0.29,0.26159793,0.29333332,0.26159793,0.29666665,0.26159793,0.3,0.26159793,0.30333334,0.26159793,0.30666667,0.26159793,0.31,0.26159793,0.31333333,0.26159793,0.31666666,0.26159793,0.32,0.26159793,0.32333332,0.26159793,0.32666665,0.26159793,0.33,0.26159793,0.33333334,0.26159793,0.33666667,0.26159793,0.34,0.26159793,0.34333333,0.26159793,0.34666666,0.26159793,0.35,0.26159793,0.35333332,0.26159793,0.35666665,0.26159793,0.36,0.26159793,0.36333334,0.26159793,0.36666667,0.26159793,0.37,0.26159793,0.37333333,0.26159793,0.37666667,0.26159793,0.38,0.26159793,0.38333333,0.26159793,0.38666666,0.26159793,0.39,0.26159793,0.39333335,0.26159793,0.39666668,0.26159793,0.4,0.26159793,0.40333334,0.26159793,0.40666667,0.26159793,0.41666666,0.26159793,0.42,0.26159793,0.42333335,0.26159793,0.42666668,0.26159793,0.43,0.26159793,0.43333334,0.26159793,0.43666667,0.26159793,0.44,0.26159793,0.44333333,0.26159793,0.44666666,0.26159793,0.45,0.26159793,0.45333335,0.26159793,0.45666668,0.26159793,0.46,0.26159793,0.46333334,0.26159793,0.46666667,0.26159793,0.47,0.26159793,0.47333333,0.26159793,0.47666666,0.26159793,0.48,0.26159793,0.48333332,0.26159793,0.48666668,0.26159793,0.49,0.26159793,0.49333334,0.26159793,0.49666667,0.26159793,0.5,0.26159793,0.50333333,0.26159793,0.50666666,0.26159793,0.51,0.26159793,0.5133333,0.26159793,0.51666665,0.26159793,0.52,0.26159793,0.5233333,0.26159793,0.52666664,0.26159793,0.53,0.26159793,0.53333336,0.26159793,0.5366667,0.26159793,0.54,0.26159793,0.54333335,0.26159793,0.5466667,0.26159793,0.55,0.26159793,0.55333334,0.26159793,0.5566667,0.26159793,0.56,0.26159793,0.56333333,0.26159793,0.56666666,0.26159793,0.57,0.26159793,0.5733333,0.26159793,0.57666665,0.26159793,0.58,0.26159793,0.5833333,0.26159793,0.58666664,0.26159793,0.59,0.26159793,0.5933333,0.26159793,0.5966667,0.26159793,0.6,0.26159793,0.60333335,0.26159793,0.6066667,0.26159793,0.61,0.26159793,0.61333334,0.26159793,0.6166667,0.26159793,0.62,0.26159793,0.62333333,0.26159793,0.62666667,0.26159793,0.63,0.26159793,0.6333333,0.26159793,0.63666666,0.26159793,0.64,0.26159793,0.6433333,0.26159793,0.64666665,0.26159793,0.65,0.26159793,0.6533333,0.26159793,0.6566667,0.26159793,0.66,0.26159793,0.66333336,0.26159793,0.6666667,0.26159793,0.67,0.26159793,0.67333335,0.26159793,0.6766667,0.26159793,0.68,0.26159793,0.68333334,0.26159793,0.68666667,0.26159793,0.69,0.26159793,0.6933333,0.26159793,0.69666666,0.26159793,0.7,0.26159793,0.7033333,0.26159793,0.70666665,0.26159793,0.71,0.26159793,0.7133333,0.26159793,0.71666664,0.26159793,0.72,0.26159793,0.72333336,0.26159793,0.7266667,0.26159793,0.73,0.26159793,0.73333335,0.26159793,0.7366667,0.26159793,0.74,0.26159793,0.74333334,0.26159793,0.74666667,0.26159793,0.75,0.26159793,0.75333333,0.26159793,0.75666666,0.26159793,0.76,0.26159793,0.76666665,0.26159793,0.77,0.26159793,0.7733333,0.26159793,0.77666664,0.26159793,0.78,0.26159793,0.78333336,0.26159793,0.7866667,0.26159793,0.79,0.26159793,0.79333335,0.26159793,0.7966667,0.26159793,0.8,0.26159793,0.80333334,0.26159793,0.8066667,0.26159793,0.81,0.26159793,0.81333333,0.26159793,0.81666666,0.26159793,0.82,0.26159793,0.8233333,0.26159793,0.82666665,0.26159793,0.83,0.26159793,0.8333333,0.26159793,0.83666664,0.26159793,0.84,0.26159793,0.8433333,0.26159793,0.8466667,0.26159793,0.85,0.26159793,0.85333335,0.26159793,0.8566667,0.26159793,0.86,0.26159793,0.86333334,0.26159793,0.8666667,0.26159793,0.87,0.26159793,0.87333333,0.26159793,0.87666667,0.26159793,0.88,0.26159793,0.8833333,0.26159793,0.88666666,0.26159793,0.89,0.26159793,0.8933333,0.26159793,0.89666665,0.26159793,0.9,0.26159793,0.9033333,0.26159793,0.9066667,0.26159793,0.91,0.26159793,0.91333336,0.26159793,0.9166667,0.26159793,0.92,0.26159793,0.92333335,0.26159793,0.9266667,0.26159793,0.93,0.26159793,0.93333334,0.26159793,0.93666667,0.26159793,0.94,0.26159793,0.9433333,0.26159793,0.94666666,0.26159793,0.05,0.26417527,0.053333335,0.26417527,0.05666667,0.26417527,0.06,0.26417527,0.06333333,0.26417527,0.06666667,0.26417527,0.07,0.26417527,0.07333333,0.26417527,0.07666667,0.26417527,0.08,0.26417527,0.083333336,0.26417527,0.086666666,0.26417527,0.09,0.26417527,0.093333334,0.26417527,0.096666664,0.26417527,0.1,0.26417527,0.10333333,0.26417527,0.10666667,0.26417527,0.11,0.26417527,0.11333334,0.26417527,0.11666667,0.26417527,0.12,0.26417527,0.123333335,0.26417527,0.12666667,0.26417527,0.13,0.26417527,0.13333334,0.26417527,0.13666667,0.26417527,0.14,0.26417527,0.14333333,0.26417527,0.14666666,0.26417527,0.15,0.26417527,0.15333334,0.26417527,0.15666667,0.26417527,0.16,0.26417527,0.16333333,0.26417527,0.16666667,0.26417527,0.17,0.26417527,0.17333333,0.26417527,0.17666666,0.26417527,0.18,0.26417527,0.18333334,0.26417527,0.18666667,0.26417527,0.19,0.26417527,0.19333333,0.26417527,0.19666667,0.26417527,0.2,0.26417527,0.20333333,0.26417527,0.20666666,0.26417527,0.21,0.26417527,0.21333334,0.26417527,0.21666667,0.26417527,0.22,0.26417527,0.22333333,0.26417527,0.22666667,0.26417527,0.23,0.26417527,0.23333333,0.26417527,0.23666666,0.26417527,0.24,0.26417527,0.24333334,0.26417527,0.24666667,0.26417527,0.25333333,0.26417527,0.25666666,0.26417527,0.26,0.26417527,0.26333332,0.26417527,0.26666668,0.26417527,0.27,0.26417527,0.27333334,0.26417527,0.27666667,0.26417527,0.28,0.26417527,0.28333333,0.26417527,0.28666666,0.26417527,0.29,0.26417527,0.29333332,0.26417527,0.29666665,0.26417527,0.3,0.26417527,0.30333334,0.26417527,0.30666667,0.26417527,0.31,0.26417527,0.31333333,0.26417527,0.31666666,0.26417527,0.32,0.26417527,0.32333332,0.26417527,0.32666665,0.26417527,0.33,0.26417527,0.33333334,0.26417527,0.33666667,0.26417527,0.34,0.26417527,0.34333333,0.26417527,0.34666666,0.26417527,0.35,0.26417527,0.35333332,0.26417527,0.35666665,0.26417527,0.36,0.26417527,0.36333334,0.26417527,0.36666667,0.26417527,0.37,0.26417527,0.37333333,0.26417527,0.37666667,0.26417527,0.38,0.26417527,0.38333333,0.26417527,0.38666666,0.26417527,0.39,0.26417527,0.39333335,0.26417527,0.39666668,0.26417527,0.4,0.26417527,0.40333334,0.26417527,0.40666667,0.26417527,0.41,0.26417527,0.41333333,0.26417527,0.41666666,0.26417527,0.42,0.26417527,0.42333335,0.26417527,0.42666668,0.26417527,0.43,0.26417527,0.43333334,0.26417527,0.43666667,0.26417527,0.44,0.26417527,0.44333333,0.26417527,0.44666666,0.26417527,0.45,0.26417527,0.45333335,0.26417527,0.45666668,0.26417527,0.46,0.26417527,0.46333334,0.26417527,0.46666667,0.26417527,0.47,0.26417527,0.47333333,0.26417527,0.47666666,0.26417527,0.48,0.26417527,0.48333332,0.26417527,0.48666668,0.26417527,0.49,0.26417527,0.49333334,0.26417527,0.49666667,0.26417527,0.5,0.26417527,0.50333333,0.26417527,0.50666666,0.26417527,0.51,0.26417527,0.5133333,0.26417527,0.51666665,0.26417527,0.52,0.26417527,0.5233333,0.26417527,0.52666664,0.26417527,0.53,0.26417527,0.53333336,0.26417527,0.5366667,0.26417527,0.54,0.26417527,0.54333335,0.26417527,0.5466667,0.26417527,0.55,0.26417527,0.55333334,0.26417527,0.5566667,0.26417527,0.56,0.26417527,0.56333333,0.26417527,0.56666666,0.26417527,0.57,0.26417527,0.5733333,0.26417527,0.57666665,0.26417527,0.58,0.26417527,0.5833333,0.26417527,0.58666664,0.26417527,0.59,0.26417527,0.5933333,0.26417527,0.5966667,0.26417527,0.6,0.26417527,0.60333335,0.26417527,0.6066667,0.26417527,0.61,0.26417527,0.61333334,0.26417527,0.6166667,0.26417527,0.62,0.26417527,0.62333333,0.26417527,0.62666667,0.26417527,0.63,0.26417527,0.6333333,0.26417527,0.63666666,0.26417527,0.64,0.26417527,0.6433333,0.26417527,0.64666665,0.26417527,0.65,0.26417527,0.6533333,0.26417527,0.6566667,0.26417527,0.66,0.26417527,0.66333336,0.26417527,0.6666667,0.26417527,0.67,0.26417527,0.67333335,0.26417527,0.6766667,0.26417527,0.68,0.26417527,0.68333334,0.26417527,0.68666667,0.26417527,0.69,0.26417527,0.6933333,0.26417527,0.69666666,0.26417527,0.7,0.26417527,0.7033333,0.26417527,0.70666665,0.26417527,0.71,0.26417527,0.7133333,0.26417527,0.71666664,0.26417527,0.72,0.26417527,0.72333336,0.26417527,0.7266667,0.26417527,0.73,0.26417527,0.73333335,0.26417527,0.7366667,0.26417527,0.74,0.26417527,0.74333334,0.26417527,0.74666667,0.26417527,0.75,0.26417527,0.75333333,0.26417527,0.75666666,0.26417527,0.76,0.26417527,0.7633333,0.26417527,0.77,0.26417527,0.7733333,0.26417527,0.77666664,0.26417527,0.78,0.26417527,0.78333336,0.26417527,0.7866667,0.26417527,0.79,0.26417527,0.79333335,0.26417527,0.7966667,0.26417527,0.8,0.26417527,0.80333334,0.26417527,0.8066667,0.26417527,0.81,0.26417527,0.81333333,0.26417527,0.81666666,0.26417527,0.82,0.26417527,0.8233333,0.26417527,0.82666665,0.26417527,0.83,0.26417527,0.8333333,0.26417527,0.83666664,0.26417527,0.84,0.26417527,0.8433333,0.26417527,0.8466667,0.26417527,0.85,0.26417527,0.85333335,0.26417527,0.8566667,0.26417527,0.86,0.26417527,0.86333334,0.26417527,0.8666667,0.26417527,0.87,0.26417527,0.87333333,0.26417527,0.87666667,0.26417527,0.88,0.26417527,0.8833333,0.26417527,0.88666666,0.26417527,0.89,0.26417527,0.8933333,0.26417527,0.89666665,0.26417527,0.9,0.26417527,0.9033333,0.26417527,0.9066667,0.26417527,0.91,0.26417527,0.91333336,0.26417527,0.9166667,0.26417527,0.92,0.26417527,0.92333335,0.26417527,0.9266667,0.26417527,0.93,0.26417527,0.93333334,0.26417527,0.93666667,0.26417527,0.94,0.26417527,0.9433333,0.26417527,0.94666666,0.26417527,0.05,0.26675257,0.053333335,0.26675257,0.05666667,0.26675257,0.06,0.26675257,0.06333333,0.26675257,0.06666667,0.26675257,0.07,0.26675257,0.07333333,0.26675257,0.07666667,0.26675257,0.08,0.26675257,0.083333336,0.26675257,0.086666666,0.26675257,0.09,0.26675257,0.093333334,0.26675257,0.096666664,0.26675257,0.1,0.26675257,0.10333333,0.26675257,0.10666667,0.26675257,0.11,0.26675257,0.11333334,0.26675257,0.11666667,0.26675257,0.12,0.26675257,0.123333335,0.26675257,0.12666667,0.26675257,0.13,0.26675257,0.13333334,0.26675257,0.13666667,0.26675257,0.14,0.26675257,0.14333333,0.26675257,0.14666666,0.26675257,0.15,0.26675257,0.15333334,0.26675257,0.15666667,0.26675257,0.16,0.26675257,0.16333333,0.26675257,0.16666667,0.26675257,0.17,0.26675257,0.17333333,0.26675257,0.17666666,0.26675257,0.18,0.26675257,0.18333334,0.26675257,0.18666667,0.26675257,0.19,0.26675257,0.19333333,0.26675257,0.19666667,0.26675257,0.2,0.26675257,0.20333333,0.26675257,0.20666666,0.26675257,0.21,0.26675257,0.21333334,0.26675257,0.21666667,0.26675257,0.22,0.26675257,0.22333333,0.26675257,0.22666667,0.26675257,0.23,0.26675257,0.23333333,0.26675257,0.23666666,0.26675257,0.24,0.26675257,0.24333334,0.26675257,0.24666667,0.26675257,0.25,0.26675257,0.25333333,0.26675257,0.25666666,0.26675257,0.26,0.26675257,0.26333332,0.26675257,0.26666668,0.26675257,0.27,0.26675257,0.27333334,0.26675257,0.27666667,0.26675257,0.28,0.26675257,0.28333333,0.26675257,0.28666666,0.26675257,0.29,0.26675257,0.29333332,0.26675257,0.29666665,0.26675257,0.3,0.26675257,0.30333334,0.26675257,0.30666667,0.26675257,0.31,0.26675257,0.31333333,0.26675257,0.31666666,0.26675257,0.32,0.26675257,0.32333332,0.26675257,0.32666665,0.26675257,0.33,0.26675257,0.33333334,0.26675257,0.33666667,0.26675257,0.34,0.26675257,0.34333333,0.26675257,0.34666666,0.26675257,0.35,0.26675257,0.35333332,0.26675257,0.35666665,0.26675257,0.36,0.26675257,0.36333334,0.26675257,0.36666667,0.26675257,0.37,0.26675257,0.37333333,0.26675257,0.37666667,0.26675257,0.38,0.26675257,0.38333333,0.26675257,0.38666666,0.26675257,0.39,0.26675257,0.39333335,0.26675257,0.39666668,0.26675257,0.4,0.26675257,0.40333334,0.26675257,0.40666667,0.26675257,0.41,0.26675257,0.41333333,0.26675257,0.41666666,0.26675257,0.42,0.26675257,0.42333335,0.26675257,0.42666668,0.26675257,0.43,0.26675257,0.43333334,0.26675257,0.43666667,0.26675257,0.44,0.26675257,0.44333333,0.26675257,0.44666666,0.26675257,0.45,0.26675257,0.45333335,0.26675257,0.45666668,0.26675257,0.46,0.26675257,0.46333334,0.26675257,0.46666667,0.26675257,0.47,0.26675257,0.47333333,0.26675257,0.47666666,0.26675257,0.48,0.26675257,0.48333332,0.26675257,0.48666668,0.26675257,0.49,0.26675257,0.49333334,0.26675257,0.49666667,0.26675257,0.5,0.26675257,0.50333333,0.26675257,0.50666666,0.26675257,0.51,0.26675257,0.5133333,0.26675257,0.51666665,0.26675257,0.52,0.26675257,0.5233333,0.26675257,0.52666664,0.26675257,0.53,0.26675257,0.53333336,0.26675257,0.5366667,0.26675257,0.54,0.26675257,0.54333335,0.26675257,0.5466667,0.26675257,0.55,0.26675257,0.55333334,0.26675257,0.5566667,0.26675257,0.56,0.26675257,0.56333333,0.26675257,0.56666666,0.26675257,0.57,0.26675257,0.5733333,0.26675257,0.57666665,0.26675257,0.58,0.26675257,0.5833333,0.26675257,0.58666664,0.26675257,0.59,0.26675257,0.5933333,0.26675257,0.5966667,0.26675257,0.6,0.26675257,0.60333335,0.26675257,0.6066667,0.26675257,0.61,0.26675257,0.61333334,0.26675257,0.6166667,0.26675257,0.62,0.26675257,0.62333333,0.26675257,0.62666667,0.26675257,0.63,0.26675257,0.6333333,0.26675257,0.63666666,0.26675257,0.64,0.26675257,0.6433333,0.26675257,0.64666665,0.26675257,0.65,0.26675257,0.6533333,0.26675257,0.6566667,0.26675257,0.66,0.26675257,0.66333336,0.26675257,0.6666667,0.26675257,0.67,0.26675257,0.67333335,0.26675257,0.6766667,0.26675257,0.68,0.26675257,0.68333334,0.26675257,0.68666667,0.26675257,0.69,0.26675257,0.6933333,0.26675257,0.69666666,0.26675257,0.7,0.26675257,0.7033333,0.26675257,0.70666665,0.26675257,0.71,0.26675257,0.7133333,0.26675257,0.71666664,0.26675257,0.72,0.26675257,0.72333336,0.26675257,0.7266667,0.26675257,0.73,0.26675257,0.73333335,0.26675257,0.7366667,0.26675257,0.74,0.26675257,0.74333334,0.26675257,0.74666667,0.26675257,0.75,0.26675257,0.75333333,0.26675257,0.75666666,0.26675257,0.76,0.26675257,0.7633333,0.26675257,0.76666665,0.26675257,0.7733333,0.26675257,0.77666664,0.26675257,0.78,0.26675257,0.78333336,0.26675257,0.7866667,0.26675257,0.79,0.26675257,0.79333335,0.26675257,0.7966667,0.26675257,0.8,0.26675257,0.80333334,0.26675257,0.8066667,0.26675257,0.81,0.26675257,0.81333333,0.26675257,0.81666666,0.26675257,0.82,0.26675257,0.8233333,0.26675257,0.82666665,0.26675257,0.83,0.26675257,0.8333333,0.26675257,0.83666664,0.26675257,0.84,0.26675257,0.8433333,0.26675257,0.8466667,0.26675257,0.85,0.26675257,0.85333335,0.26675257,0.8566667,0.26675257,0.86,0.26675257,0.86333334,0.26675257,0.8666667,0.26675257,0.87,0.26675257,0.87333333,0.26675257,0.87666667,0.26675257,0.88,0.26675257,0.8833333,0.26675257,0.88666666,0.26675257,0.89,0.26675257,0.8933333,0.26675257,0.89666665,0.26675257,0.9,0.26675257,0.9033333,0.26675257,0.9066667,0.26675257,0.91,0.26675257,0.91333336,0.26675257,0.9166667,0.26675257,0.92,0.26675257,0.92333335,0.26675257,0.9266667,0.26675257,0.93,0.26675257,0.93333334,0.26675257,0.93666667,0.26675257,0.94,0.26675257,0.9433333,0.26675257,0.94666666,0.26675257,0.05,0.2693299,0.053333335,0.2693299,0.05666667,0.2693299,0.06,0.2693299,0.06333333,0.2693299,0.06666667,0.2693299,0.07,0.2693299,0.07333333,0.2693299,0.07666667,0.2693299,0.08,0.2693299,0.083333336,0.2693299,0.086666666,0.2693299,0.09,0.2693299,0.093333334,0.2693299,0.096666664,0.2693299,0.1,0.2693299,0.10333333,0.2693299,0.10666667,0.2693299,0.11,0.2693299,0.11333334,0.2693299,0.11666667,0.2693299,0.12,0.2693299,0.123333335,0.2693299,0.12666667,0.2693299,0.13,0.2693299,0.13333334,0.2693299,0.13666667,0.2693299,0.14,0.2693299,0.14333333,0.2693299,0.14666666,0.2693299,0.15,0.2693299,0.15333334,0.2693299,0.15666667,0.2693299,0.16,0.2693299,0.16333333,0.2693299,0.16666667,0.2693299,0.17,0.2693299,0.17333333,0.2693299,0.17666666,0.2693299,0.18,0.2693299,0.18333334,0.2693299,0.18666667,0.2693299,0.19,0.2693299,0.19333333,0.2693299,0.19666667,0.2693299,0.2,0.2693299,0.20333333,0.2693299,0.20666666,0.2693299,0.21,0.2693299,0.21333334,0.2693299,0.21666667,0.2693299,0.22,0.2693299,0.22333333,0.2693299,0.22666667,0.2693299,0.23,0.2693299,0.23333333,0.2693299,0.23666666,0.2693299,0.24,0.2693299,0.24333334,0.2693299,0.24666667,0.2693299,0.25,0.2693299,0.25333333,0.2693299,0.25666666,0.2693299,0.26,0.2693299,0.26333332,0.2693299,0.26666668,0.2693299,0.27,0.2693299,0.27333334,0.2693299,0.27666667,0.2693299,0.28,0.2693299,0.28333333,0.2693299,0.28666666,0.2693299,0.29,0.2693299,0.29333332,0.2693299,0.29666665,0.2693299,0.3,0.2693299,0.30333334,0.2693299,0.30666667,0.2693299,0.31,0.2693299,0.31333333,0.2693299,0.31666666,0.2693299,0.32,0.2693299,0.32666665,0.2693299,0.33,0.2693299,0.33333334,0.2693299,0.33666667,0.2693299,0.34,0.2693299,0.34333333,0.2693299,0.34666666,0.2693299,0.35,0.2693299,0.35333332,0.2693299,0.35666665,0.2693299,0.36,0.2693299,0.36333334,0.2693299,0.36666667,0.2693299,0.37,0.2693299,0.37333333,0.2693299,0.37666667,0.2693299,0.38,0.2693299,0.38333333,0.2693299,0.38666666,0.2693299,0.39,0.2693299,0.39333335,0.2693299,0.39666668,0.2693299,0.4,0.2693299,0.40333334,0.2693299,0.40666667,0.2693299,0.41,0.2693299,0.41333333,0.2693299,0.41666666,0.2693299,0.42,0.2693299,0.42333335,0.2693299,0.42666668,0.2693299,0.43,0.2693299,0.43333334,0.2693299,0.43666667,0.2693299,0.44,0.2693299,0.44333333,0.2693299,0.44666666,0.2693299,0.45,0.2693299,0.45333335,0.2693299,0.45666668,0.2693299,0.46,0.2693299,0.46333334,0.2693299,0.46666667,0.2693299,0.47,0.2693299,0.47333333,0.2693299,0.47666666,0.2693299,0.48,0.2693299,0.48333332,0.2693299,0.48666668,0.2693299,0.49,0.2693299,0.49333334,0.2693299,0.49666667,0.2693299,0.5,0.2693299,0.50333333,0.2693299,0.50666666,0.2693299,0.51,0.2693299,0.5133333,0.2693299,0.51666665,0.2693299,0.52,0.2693299,0.5233333,0.2693299,0.52666664,0.2693299,0.53,0.2693299,0.53333336,0.2693299,0.5366667,0.2693299,0.54,0.2693299,0.54333335,0.2693299,0.5466667,0.2693299,0.55,0.2693299,0.55333334,0.2693299,0.5566667,0.2693299,0.56,0.2693299,0.56333333,0.2693299,0.56666666,0.2693299,0.57,0.2693299,0.5733333,0.2693299,0.57666665,0.2693299,0.58,0.2693299,0.5833333,0.2693299,0.58666664,0.2693299,0.59,0.2693299,0.5933333,0.2693299,0.5966667,0.2693299,0.6,0.2693299,0.60333335,0.2693299,0.6066667,0.2693299,0.61,0.2693299,0.61333334,0.2693299,0.6166667,0.2693299,0.62,0.2693299,0.62333333,0.2693299,0.62666667,0.2693299,0.63,0.2693299,0.6333333,0.2693299,0.63666666,0.2693299,0.64,0.2693299,0.6433333,0.2693299,0.64666665,0.2693299,0.65,0.2693299,0.6533333,0.2693299,0.6566667,0.2693299,0.66,0.2693299,0.66333336,0.2693299,0.6666667,0.2693299,0.67,0.2693299,0.67333335,0.2693299,0.6766667,0.2693299,0.68,0.2693299,0.68333334,0.2693299,0.68666667,0.2693299,0.69,0.2693299,0.6933333,0.2693299,0.69666666,0.2693299,0.7,0.2693299,0.7033333,0.2693299,0.70666665,0.2693299,0.71,0.2693299,0.7133333,0.2693299,0.71666664,0.2693299,0.72,0.2693299,0.72333336,0.2693299,0.7266667,0.2693299,0.73,0.2693299,0.73333335,0.2693299,0.7366667,0.2693299,0.74,0.2693299,0.74333334,0.2693299,0.74666667,0.2693299,0.75,0.2693299,0.75333333,0.2693299,0.75666666,0.2693299,0.76,0.2693299,0.7633333,0.2693299,0.76666665,0.2693299,0.77,0.2693299,0.7733333,0.2693299,0.77666664,0.2693299,0.78,0.2693299,0.78333336,0.2693299,0.7866667,0.2693299,0.79,0.2693299,0.79333335,0.2693299,0.7966667,0.2693299,0.8,0.2693299,0.80333334,0.2693299,0.8066667,0.2693299,0.81,0.2693299,0.81333333,0.2693299,0.81666666,0.2693299,0.82,0.2693299,0.8233333,0.2693299,0.82666665,0.2693299,0.83,0.2693299,0.8333333,0.2693299,0.83666664,0.2693299,0.84,0.2693299,0.8433333,0.2693299,0.8466667,0.2693299,0.85,0.2693299,0.85333335,0.2693299,0.8566667,0.2693299,0.86,0.2693299,0.86333334,0.2693299,0.8666667,0.2693299,0.87,0.2693299,0.87333333,0.2693299,0.87666667,0.2693299,0.88,0.2693299,0.8833333,0.2693299,0.88666666,0.2693299,0.89,0.2693299,0.8933333,0.2693299,0.89666665,0.2693299,0.9,0.2693299,0.9033333,0.2693299,0.9066667,0.2693299,0.91,0.2693299,0.91333336,0.2693299,0.9166667,0.2693299,0.92,0.2693299,0.92333335,0.2693299,0.9266667,0.2693299,0.93,0.2693299,0.93333334,0.2693299,0.93666667,0.2693299,0.94,0.2693299,0.9433333,0.2693299,0.94666666,0.2693299,0.05,0.2719072,0.053333335,0.2719072,0.05666667,0.2719072,0.06,0.2719072,0.06333333,0.2719072,0.06666667,0.2719072,0.07,0.2719072,0.07333333,0.2719072,0.07666667,0.2719072,0.08,0.2719072,0.083333336,0.2719072,0.086666666,0.2719072,0.09,0.2719072,0.093333334,0.2719072,0.096666664,0.2719072,0.1,0.2719072,0.10333333,0.2719072,0.10666667,0.2719072,0.11,0.2719072,0.11333334,0.2719072,0.11666667,0.2719072,0.12,0.2719072,0.123333335,0.2719072,0.12666667,0.2719072,0.13,0.2719072,0.13333334,0.2719072,0.13666667,0.2719072,0.14,0.2719072,0.14333333,0.2719072,0.14666666,0.2719072,0.15,0.2719072,0.15333334,0.2719072,0.15666667,0.2719072,0.16,0.2719072,0.16333333,0.2719072,0.16666667,0.2719072,0.17,0.2719072,0.17333333,0.2719072,0.17666666,0.2719072,0.18,0.2719072,0.18333334,0.2719072,0.18666667,0.2719072,0.19,0.2719072,0.19333333,0.2719072,0.19666667,0.2719072,0.2,0.2719072,0.20333333,0.2719072,0.20666666,0.2719072,0.21,0.2719072,0.21333334,0.2719072,0.21666667,0.2719072,0.22,0.2719072,0.22333333,0.2719072,0.22666667,0.2719072,0.23,0.2719072,0.23333333,0.2719072,0.23666666,0.2719072,0.24,0.2719072,0.24333334,0.2719072,0.24666667,0.2719072,0.25,0.2719072,0.25333333,0.2719072,0.25666666,0.2719072,0.26,0.2719072,0.26333332,0.2719072,0.26666668,0.2719072,0.27,0.2719072,0.27333334,0.2719072,0.27666667,0.2719072,0.28,0.2719072,0.28333333,0.2719072,0.28666666,0.2719072,0.29,0.2719072,0.29333332,0.2719072,0.29666665,0.2719072,0.3,0.2719072,0.30333334,0.2719072,0.30666667,0.2719072,0.31,0.2719072,0.31333333,0.2719072,0.31666666,0.2719072,0.32333332,0.2719072,0.32666665,0.2719072,0.33,0.2719072,0.33333334,0.2719072,0.33666667,0.2719072,0.34,0.2719072,0.34333333,0.2719072,0.34666666,0.2719072,0.35,0.2719072,0.35333332,0.2719072,0.35666665,0.2719072,0.36,0.2719072,0.36333334,0.2719072,0.36666667,0.2719072,0.37,0.2719072,0.37333333,0.2719072,0.37666667,0.2719072,0.38,0.2719072,0.38333333,0.2719072,0.38666666,0.2719072,0.39,0.2719072,0.39333335,0.2719072,0.39666668,0.2719072,0.4,0.2719072,0.40333334,0.2719072,0.40666667,0.2719072,0.41,0.2719072,0.41333333,0.2719072,0.41666666,0.2719072,0.42,0.2719072,0.42333335,0.2719072,0.42666668,0.2719072,0.43,0.2719072,0.43333334,0.2719072,0.43666667,0.2719072,0.44,0.2719072,0.44333333,0.2719072,0.44666666,0.2719072,0.45,0.2719072,0.45333335,0.2719072,0.45666668,0.2719072,0.46,0.2719072,0.46333334,0.2719072,0.46666667,0.2719072,0.47,0.2719072,0.47333333,0.2719072,0.47666666,0.2719072,0.48,0.2719072,0.48333332,0.2719072,0.48666668,0.2719072,0.49,0.2719072,0.49333334,0.2719072,0.49666667,0.2719072,0.5,0.2719072,0.50333333,0.2719072,0.50666666,0.2719072,0.51,0.2719072,0.5133333,0.2719072,0.51666665,0.2719072,0.52,0.2719072,0.5233333,0.2719072,0.52666664,0.2719072,0.53,0.2719072,0.53333336,0.2719072,0.5366667,0.2719072,0.54,0.2719072,0.54333335,0.2719072,0.5466667,0.2719072,0.55,0.2719072,0.55333334,0.2719072,0.5566667,0.2719072,0.56,0.2719072,0.56333333,0.2719072,0.56666666,0.2719072,0.57,0.2719072,0.5733333,0.2719072,0.57666665,0.2719072,0.58,0.2719072,0.5833333,0.2719072,0.58666664,0.2719072,0.59,0.2719072,0.5933333,0.2719072,0.5966667,0.2719072,0.6,0.2719072,0.60333335,0.2719072,0.6066667,0.2719072,0.61,0.2719072,0.61333334,0.2719072,0.6166667,0.2719072,0.62,0.2719072,0.62333333,0.2719072,0.62666667,0.2719072,0.63,0.2719072,0.6333333,0.2719072,0.63666666,0.2719072,0.64,0.2719072,0.6433333,0.2719072,0.64666665,0.2719072,0.65,0.2719072,0.6533333,0.2719072,0.6566667,0.2719072,0.66,0.2719072,0.66333336,0.2719072,0.6666667,0.2719072,0.67,0.2719072,0.67333335,0.2719072,0.6766667,0.2719072,0.68,0.2719072,0.68333334,0.2719072,0.68666667,0.2719072,0.69,0.2719072,0.6933333,0.2719072,0.69666666,0.2719072,0.7,0.2719072,0.7033333,0.2719072,0.70666665,0.2719072,0.71,0.2719072,0.7133333,0.2719072,0.71666664,0.2719072,0.72,0.2719072,0.72333336,0.2719072,0.7266667,0.2719072,0.73,0.2719072,0.73333335,0.2719072,0.7366667,0.2719072,0.74,0.2719072,0.74333334,0.2719072,0.74666667,0.2719072,0.75,0.2719072,0.75333333,0.2719072,0.75666666,0.2719072,0.76,0.2719072,0.7633333,0.2719072,0.76666665,0.2719072,0.77,0.2719072,0.7733333,0.2719072,0.77666664,0.2719072,0.78,0.2719072,0.78333336,0.2719072,0.7866667,0.2719072,0.79,0.2719072,0.79333335,0.2719072,0.7966667,0.2719072,0.8,0.2719072,0.80333334,0.2719072,0.8066667,0.2719072,0.81,0.2719072,0.81333333,0.2719072,0.81666666,0.2719072,0.82,0.2719072,0.8233333,0.2719072,0.82666665,0.2719072,0.83,0.2719072,0.8333333,0.2719072,0.83666664,0.2719072,0.84,0.2719072,0.8433333,0.2719072,0.8466667,0.2719072,0.85,0.2719072,0.85333335,0.2719072,0.8566667,0.2719072,0.86,0.2719072,0.86333334,0.2719072,0.8666667,0.2719072,0.87,0.2719072,0.87333333,0.2719072,0.87666667,0.2719072,0.88,0.2719072,0.8833333,0.2719072,0.88666666,0.2719072,0.89,0.2719072,0.8933333,0.2719072,0.89666665,0.2719072,0.9,0.2719072,0.9033333,0.2719072,0.9066667,0.2719072,0.91,0.2719072,0.91333336,0.2719072,0.9166667,0.2719072,0.92,0.2719072,0.92333335,0.2719072,0.9266667,0.2719072,0.93,0.2719072,0.93333334,0.2719072,0.93666667,0.2719072,0.94,0.2719072,0.9433333,0.2719072,0.94666666,0.2719072,0.05,0.27448454,0.053333335,0.27448454,0.05666667,0.27448454,0.06,0.27448454,0.06333333,0.27448454,0.06666667,0.27448454,0.07,0.27448454,0.07333333,0.27448454,0.07666667,0.27448454,0.08,0.27448454,0.083333336,0.27448454,0.086666666,0.27448454,0.09,0.27448454,0.093333334,0.27448454,0.096666664,0.27448454,0.1,0.27448454,0.10333333,0.27448454,0.10666667,0.27448454,0.11,0.27448454,0.11333334,0.27448454,0.11666667,0.27448454,0.12,0.27448454,0.123333335,0.27448454,0.12666667,0.27448454,0.13,0.27448454,0.13333334,0.27448454,0.13666667,0.27448454,0.14,0.27448454,0.14333333,0.27448454,0.14666666,0.27448454,0.15,0.27448454,0.15333334,0.27448454,0.15666667,0.27448454,0.16,0.27448454,0.16333333,0.27448454,0.16666667,0.27448454,0.17,0.27448454,0.17333333,0.27448454,0.17666666,0.27448454,0.18,0.27448454,0.18333334,0.27448454,0.18666667,0.27448454,0.19,0.27448454,0.19333333,0.27448454,0.19666667,0.27448454,0.2,0.27448454,0.20333333,0.27448454,0.20666666,0.27448454,0.21,0.27448454,0.21333334,0.27448454,0.21666667,0.27448454,0.22,0.27448454,0.22333333,0.27448454,0.22666667,0.27448454,0.23,0.27448454,0.23333333,0.27448454,0.23666666,0.27448454,0.24,0.27448454,0.24333334,0.27448454,0.24666667,0.27448454,0.25,0.27448454,0.25333333,0.27448454,0.25666666,0.27448454,0.26,0.27448454,0.26333332,0.27448454,0.26666668,0.27448454,0.27,0.27448454,0.27333334,0.27448454,0.27666667,0.27448454,0.28,0.27448454,0.28333333,0.27448454,0.28666666,0.27448454,0.29,0.27448454,0.29333332,0.27448454,0.29666665,0.27448454,0.3,0.27448454,0.30333334,0.27448454,0.30666667,0.27448454,0.31,0.27448454,0.31333333,0.27448454,0.31666666,0.27448454,0.32,0.27448454,0.32333332,0.27448454,0.32666665,0.27448454,0.33,0.27448454,0.33333334,0.27448454,0.33666667,0.27448454,0.34,0.27448454,0.34333333,0.27448454,0.34666666,0.27448454,0.35,0.27448454,0.35333332,0.27448454,0.35666665,0.27448454,0.36,0.27448454,0.36333334,0.27448454,0.36666667,0.27448454,0.37,0.27448454,0.37333333,0.27448454,0.37666667,0.27448454,0.38,0.27448454,0.38333333,0.27448454,0.38666666,0.27448454,0.39,0.27448454,0.39333335,0.27448454,0.39666668,0.27448454,0.4,0.27448454,0.40333334,0.27448454,0.40666667,0.27448454,0.41,0.27448454,0.41333333,0.27448454,0.41666666,0.27448454,0.42,0.27448454,0.42333335,0.27448454,0.42666668,0.27448454,0.43,0.27448454,0.43333334,0.27448454,0.43666667,0.27448454,0.44,0.27448454,0.44333333,0.27448454,0.44666666,0.27448454,0.45,0.27448454,0.45333335,0.27448454,0.45666668,0.27448454,0.46,0.27448454,0.46333334,0.27448454,0.46666667,0.27448454,0.47,0.27448454,0.47333333,0.27448454,0.47666666,0.27448454,0.48,0.27448454,0.48333332,0.27448454,0.48666668,0.27448454,0.49,0.27448454,0.49333334,0.27448454,0.49666667,0.27448454,0.5,0.27448454,0.50333333,0.27448454,0.50666666,0.27448454,0.51,0.27448454,0.5133333,0.27448454,0.51666665,0.27448454,0.52,0.27448454,0.5233333,0.27448454,0.52666664,0.27448454,0.53,0.27448454,0.53333336,0.27448454,0.5366667,0.27448454,0.54,0.27448454,0.54333335,0.27448454,0.5466667,0.27448454,0.55,0.27448454,0.55333334,0.27448454,0.5566667,0.27448454,0.56,0.27448454,0.56333333,0.27448454,0.56666666,0.27448454,0.57,0.27448454,0.5733333,0.27448454,0.57666665,0.27448454,0.58,0.27448454,0.5833333,0.27448454,0.58666664,0.27448454,0.59,0.27448454,0.5933333,0.27448454,0.5966667,0.27448454,0.6,0.27448454,0.60333335,0.27448454,0.6066667,0.27448454,0.61,0.27448454,0.61333334,0.27448454,0.6166667,0.27448454,0.62,0.27448454,0.62333333,0.27448454,0.62666667,0.27448454,0.63,0.27448454,0.6333333,0.27448454,0.63666666,0.27448454,0.64,0.27448454,0.6433333,0.27448454,0.64666665,0.27448454,0.65,0.27448454,0.6533333,0.27448454,0.6566667,0.27448454,0.66,0.27448454,0.66333336,0.27448454,0.6666667,0.27448454,0.67,0.27448454,0.67333335,0.27448454,0.6766667,0.27448454,0.68,0.27448454,0.68333334,0.27448454,0.68666667,0.27448454,0.69,0.27448454,0.6933333,0.27448454,0.69666666,0.27448454,0.7,0.27448454,0.7033333,0.27448454,0.70666665,0.27448454,0.71,0.27448454,0.7133333,0.27448454,0.71666664,0.27448454,0.72,0.27448454,0.72333336,0.27448454,0.7266667,0.27448454,0.73,0.27448454,0.73333335,0.27448454,0.7366667,0.27448454,0.74,0.27448454,0.74333334,0.27448454,0.74666667,0.27448454,0.75,0.27448454,0.75333333,0.27448454,0.75666666,0.27448454,0.76,0.27448454,0.7633333,0.27448454,0.76666665,0.27448454,0.77,0.27448454,0.7733333,0.27448454,0.77666664,0.27448454,0.78,0.27448454,0.78333336,0.27448454,0.7866667,0.27448454,0.79,0.27448454,0.79333335,0.27448454,0.7966667,0.27448454,0.8,0.27448454,0.80333334,0.27448454,0.8066667,0.27448454,0.81,0.27448454,0.81333333,0.27448454,0.81666666,0.27448454,0.82,0.27448454,0.8233333,0.27448454,0.82666665,0.27448454,0.83,0.27448454,0.8333333,0.27448454,0.83666664,0.27448454,0.84,0.27448454,0.8433333,0.27448454,0.8466667,0.27448454,0.85,0.27448454,0.85333335,0.27448454,0.8566667,0.27448454,0.86,0.27448454,0.86333334,0.27448454,0.8666667,0.27448454,0.87,0.27448454,0.87666667,0.27448454,0.88,0.27448454,0.8833333,0.27448454,0.88666666,0.27448454,0.89,0.27448454,0.8933333,0.27448454,0.89666665,0.27448454,0.9,0.27448454,0.9033333,0.27448454,0.9066667,0.27448454,0.91,0.27448454,0.91333336,0.27448454,0.9166667,0.27448454,0.92,0.27448454,0.92333335,0.27448454,0.9266667,0.27448454,0.93,0.27448454,0.93333334,0.27448454,0.93666667,0.27448454,0.94,0.27448454,0.9433333,0.27448454,0.94666666,0.27448454,0.05,0.27706185,0.053333335,0.27706185,0.05666667,0.27706185,0.06,0.27706185,0.06333333,0.27706185,0.06666667,0.27706185,0.07,0.27706185,0.07333333,0.27706185,0.07666667,0.27706185,0.08,0.27706185,0.083333336,0.27706185,0.086666666,0.27706185,0.09,0.27706185,0.093333334,0.27706185,0.096666664,0.27706185,0.1,0.27706185,0.10333333,0.27706185,0.10666667,0.27706185,0.11,0.27706185,0.11333334,0.27706185,0.11666667,0.27706185,0.12,0.27706185,0.123333335,0.27706185,0.12666667,0.27706185,0.13,0.27706185,0.13333334,0.27706185,0.13666667,0.27706185,0.14,0.27706185,0.14333333,0.27706185,0.14666666,0.27706185,0.15,0.27706185,0.15333334,0.27706185,0.15666667,0.27706185,0.16,0.27706185,0.16333333,0.27706185,0.16666667,0.27706185,0.17,0.27706185,0.17333333,0.27706185,0.17666666,0.27706185,0.18,0.27706185,0.18333334,0.27706185,0.18666667,0.27706185,0.19,0.27706185,0.19333333,0.27706185,0.19666667,0.27706185,0.2,0.27706185,0.20333333,0.27706185,0.20666666,0.27706185,0.21,0.27706185,0.21333334,0.27706185,0.21666667,0.27706185,0.22,0.27706185,0.22333333,0.27706185,0.22666667,0.27706185,0.23,0.27706185,0.23333333,0.27706185,0.23666666,0.27706185,0.24,0.27706185,0.24333334,0.27706185,0.24666667,0.27706185,0.25,0.27706185,0.25333333,0.27706185,0.25666666,0.27706185,0.26,0.27706185,0.26333332,0.27706185,0.26666668,0.27706185,0.27,0.27706185,0.27333334,0.27706185,0.27666667,0.27706185,0.28,0.27706185,0.28333333,0.27706185,0.28666666,0.27706185,0.29,0.27706185,0.29333332,0.27706185,0.29666665,0.27706185,0.3,0.27706185,0.30333334,0.27706185,0.30666667,0.27706185,0.31333333,0.27706185,0.31666666,0.27706185,0.32,0.27706185,0.32333332,0.27706185,0.32666665,0.27706185,0.33,0.27706185,0.33333334,0.27706185,0.33666667,0.27706185,0.34,0.27706185,0.34333333,0.27706185,0.34666666,0.27706185,0.35,0.27706185,0.35333332,0.27706185,0.35666665,0.27706185,0.36,0.27706185,0.36333334,0.27706185,0.36666667,0.27706185,0.37,0.27706185,0.37333333,0.27706185,0.37666667,0.27706185,0.38,0.27706185,0.38333333,0.27706185,0.38666666,0.27706185,0.39,0.27706185,0.39333335,0.27706185,0.39666668,0.27706185,0.4,0.27706185,0.40333334,0.27706185,0.40666667,0.27706185,0.41,0.27706185,0.41333333,0.27706185,0.41666666,0.27706185,0.42,0.27706185,0.42333335,0.27706185,0.42666668,0.27706185,0.43,0.27706185,0.43333334,0.27706185,0.43666667,0.27706185,0.44,0.27706185,0.44333333,0.27706185,0.44666666,0.27706185,0.45,0.27706185,0.45333335,0.27706185,0.45666668,0.27706185,0.46,0.27706185,0.46333334,0.27706185,0.46666667,0.27706185,0.47,0.27706185,0.47333333,0.27706185,0.47666666,0.27706185,0.48,0.27706185,0.48333332,0.27706185,0.48666668,0.27706185,0.49,0.27706185,0.49333334,0.27706185,0.49666667,0.27706185,0.5,0.27706185,0.50333333,0.27706185,0.50666666,0.27706185,0.51,0.27706185,0.5133333,0.27706185,0.51666665,0.27706185,0.52,0.27706185,0.5233333,0.27706185,0.52666664,0.27706185,0.53,0.27706185,0.53333336,0.27706185,0.5366667,0.27706185,0.54,0.27706185,0.54333335,0.27706185,0.5466667,0.27706185,0.55,0.27706185,0.55333334,0.27706185,0.5566667,0.27706185,0.56,0.27706185,0.56333333,0.27706185,0.56666666,0.27706185,0.57,0.27706185,0.5733333,0.27706185,0.57666665,0.27706185,0.58,0.27706185,0.5833333,0.27706185,0.58666664,0.27706185,0.59,0.27706185,0.5933333,0.27706185,0.5966667,0.27706185,0.6,0.27706185,0.60333335,0.27706185,0.6066667,0.27706185,0.61,0.27706185,0.61333334,0.27706185,0.6166667,0.27706185,0.62,0.27706185,0.62333333,0.27706185,0.64,0.27706185,0.68333334,0.27706185,0.68666667,0.27706185,0.69,0.27706185,0.6933333,0.27706185,0.69666666,0.27706185,0.7,0.27706185,0.7033333,0.27706185,0.70666665,0.27706185,0.71,0.27706185,0.7133333,0.27706185,0.71666664,0.27706185,0.72,0.27706185,0.72333336,0.27706185,0.7266667,0.27706185,0.73,0.27706185,0.73333335,0.27706185,0.7366667,0.27706185,0.74,0.27706185,0.74333334,0.27706185,0.74666667,0.27706185,0.75,0.27706185,0.75333333,0.27706185,0.75666666,0.27706185,0.76,0.27706185,0.7633333,0.27706185,0.76666665,0.27706185,0.77,0.27706185,0.7733333,0.27706185,0.77666664,0.27706185,0.78,0.27706185,0.78333336,0.27706185,0.7866667,0.27706185,0.79,0.27706185,0.79333335,0.27706185,0.7966667,0.27706185,0.8,0.27706185,0.80333334,0.27706185,0.8066667,0.27706185,0.81,0.27706185,0.81333333,0.27706185,0.81666666,0.27706185,0.82,0.27706185,0.8233333,0.27706185,0.82666665,0.27706185,0.83,0.27706185,0.8333333,0.27706185,0.83666664,0.27706185,0.84,0.27706185,0.8433333,0.27706185,0.8466667,0.27706185,0.85,0.27706185,0.85333335,0.27706185,0.8566667,0.27706185,0.86,0.27706185,0.86333334,0.27706185,0.8666667,0.27706185,0.8833333,0.27706185,0.88666666,0.27706185,0.89,0.27706185,0.8933333,0.27706185,0.89666665,0.27706185,0.9,0.27706185,0.9033333,0.27706185,0.9066667,0.27706185,0.91,0.27706185,0.91333336,0.27706185,0.9166667,0.27706185,0.92,0.27706185,0.92333335,0.27706185,0.9266667,0.27706185,0.93,0.27706185,0.93333334,0.27706185,0.93666667,0.27706185,0.94,0.27706185,0.9433333,0.27706185,0.94666666,0.27706185,0.05,0.27963918,0.053333335,0.27963918,0.05666667,0.27963918,0.06,0.27963918,0.06333333,0.27963918,0.06666667,0.27963918,0.07,0.27963918,0.07333333,0.27963918,0.07666667,0.27963918,0.08,0.27963918,0.083333336,0.27963918,0.086666666,0.27963918,0.09,0.27963918,0.093333334,0.27963918,0.096666664,0.27963918,0.1,0.27963918,0.10333333,0.27963918,0.10666667,0.27963918,0.11,0.27963918,0.11333334,0.27963918,0.11666667,0.27963918,0.12,0.27963918,0.123333335,0.27963918,0.12666667,0.27963918,0.13,0.27963918,0.13333334,0.27963918,0.13666667,0.27963918,0.14,0.27963918,0.14333333,0.27963918,0.14666666,0.27963918,0.15,0.27963918,0.15333334,0.27963918,0.15666667,0.27963918,0.16,0.27963918,0.16333333,0.27963918,0.16666667,0.27963918,0.17,0.27963918,0.17333333,0.27963918,0.17666666,0.27963918,0.18,0.27963918,0.18333334,0.27963918,0.18666667,0.27963918,0.19,0.27963918,0.19333333,0.27963918,0.19666667,0.27963918,0.2,0.27963918,0.20333333,0.27963918,0.20666666,0.27963918,0.21,0.27963918,0.21333334,0.27963918,0.21666667,0.27963918,0.22,0.27963918,0.22333333,0.27963918,0.22666667,0.27963918,0.23,0.27963918,0.23333333,0.27963918,0.23666666,0.27963918,0.24,0.27963918,0.24333334,0.27963918,0.24666667,0.27963918,0.25,0.27963918,0.25333333,0.27963918,0.25666666,0.27963918,0.26,0.27963918,0.26333332,0.27963918,0.26666668,0.27963918,0.27,0.27963918,0.27333334,0.27963918,0.27666667,0.27963918,0.28,0.27963918,0.28333333,0.27963918,0.28666666,0.27963918,0.29,0.27963918,0.29333332,0.27963918,0.29666665,0.27963918,0.3,0.27963918,0.30333334,0.27963918,0.31,0.27963918,0.31333333,0.27963918,0.31666666,0.27963918,0.32,0.27963918,0.32333332,0.27963918,0.32666665,0.27963918,0.33,0.27963918,0.33333334,0.27963918,0.33666667,0.27963918,0.34,0.27963918,0.34333333,0.27963918,0.34666666,0.27963918,0.35,0.27963918,0.35333332,0.27963918,0.35666665,0.27963918,0.36,0.27963918,0.36333334,0.27963918,0.36666667,0.27963918,0.37,0.27963918,0.37333333,0.27963918,0.37666667,0.27963918,0.38,0.27963918,0.38333333,0.27963918,0.38666666,0.27963918,0.39,0.27963918,0.39333335,0.27963918,0.39666668,0.27963918,0.4,0.27963918,0.40333334,0.27963918,0.40666667,0.27963918,0.41,0.27963918,0.41333333,0.27963918,0.41666666,0.27963918,0.42,0.27963918,0.42333335,0.27963918,0.42666668,0.27963918,0.43,0.27963918,0.43333334,0.27963918,0.43666667,0.27963918,0.44,0.27963918,0.44333333,0.27963918,0.44666666,0.27963918,0.45,0.27963918,0.45333335,0.27963918,0.45666668,0.27963918,0.46,0.27963918,0.46333334,0.27963918,0.46666667,0.27963918,0.47,0.27963918,0.47333333,0.27963918,0.47666666,0.27963918,0.48,0.27963918,0.48333332,0.27963918,0.48666668,0.27963918,0.49,0.27963918,0.49333334,0.27963918,0.49666667,0.27963918,0.5,0.27963918,0.50333333,0.27963918,0.50666666,0.27963918,0.51,0.27963918,0.5133333,0.27963918,0.51666665,0.27963918,0.52,0.27963918,0.5233333,0.27963918,0.52666664,0.27963918,0.53,0.27963918,0.53333336,0.27963918,0.5366667,0.27963918,0.54,0.27963918,0.54333335,0.27963918,0.5466667,0.27963918,0.55,0.27963918,0.55333334,0.27963918,0.5566667,0.27963918,0.56,0.27963918,0.56333333,0.27963918,0.56666666,0.27963918,0.57,0.27963918,0.5733333,0.27963918,0.57666665,0.27963918,0.58,0.27963918,0.5833333,0.27963918,0.58666664,0.27963918,0.59,0.27963918,0.5933333,0.27963918,0.5966667,0.27963918,0.6,0.27963918,0.60333335,0.27963918,0.6066667,0.27963918,0.61,0.27963918,0.61333334,0.27963918,0.6166667,0.27963918,0.62,0.27963918,0.62333333,0.27963918,0.6566667,0.27963918,0.69,0.27963918,0.6933333,0.27963918,0.69666666,0.27963918,0.7,0.27963918,0.7033333,0.27963918,0.70666665,0.27963918,0.71,0.27963918,0.7133333,0.27963918,0.71666664,0.27963918,0.72,0.27963918,0.72333336,0.27963918,0.7266667,0.27963918,0.73,0.27963918,0.73333335,0.27963918,0.7366667,0.27963918,0.74,0.27963918,0.74333334,0.27963918,0.74666667,0.27963918,0.75,0.27963918,0.75333333,0.27963918,0.75666666,0.27963918,0.76,0.27963918,0.7633333,0.27963918,0.76666665,0.27963918,0.77,0.27963918,0.7733333,0.27963918,0.77666664,0.27963918,0.78,0.27963918,0.78333336,0.27963918,0.7866667,0.27963918,0.79,0.27963918,0.79333335,0.27963918,0.7966667,0.27963918,0.8,0.27963918,0.80333334,0.27963918,0.8066667,0.27963918,0.81,0.27963918,0.81333333,0.27963918,0.81666666,0.27963918,0.82,0.27963918,0.8233333,0.27963918,0.82666665,0.27963918,0.83,0.27963918,0.8333333,0.27963918,0.83666664,0.27963918,0.84,0.27963918,0.8433333,0.27963918,0.8466667,0.27963918,0.85,0.27963918,0.85333335,0.27963918,0.8566667,0.27963918,0.86,0.27963918,0.86333334,0.27963918,0.8666667,0.27963918,0.87,0.27963918,0.8833333,0.27963918,0.88666666,0.27963918,0.89,0.27963918,0.8933333,0.27963918,0.89666665,0.27963918,0.9,0.27963918,0.9033333,0.27963918,0.9066667,0.27963918,0.91,0.27963918,0.91333336,0.27963918,0.9166667,0.27963918,0.92,0.27963918,0.92333335,0.27963918,0.9266667,0.27963918,0.93,0.27963918,0.93333334,0.27963918,0.93666667,0.27963918,0.94,0.27963918,0.9433333,0.27963918,0.94666666,0.27963918,0.05,0.2822165,0.053333335,0.2822165,0.05666667,0.2822165,0.06,0.2822165,0.06333333,0.2822165,0.06666667,0.2822165,0.07,0.2822165,0.07333333,0.2822165,0.07666667,0.2822165,0.08,0.2822165,0.083333336,0.2822165,0.086666666,0.2822165,0.09,0.2822165,0.093333334,0.2822165,0.096666664,0.2822165,0.1,0.2822165,0.10333333,0.2822165,0.10666667,0.2822165,0.11,0.2822165,0.11333334,0.2822165,0.11666667,0.2822165,0.12,0.2822165,0.123333335,0.2822165,0.12666667,0.2822165,0.13,0.2822165,0.13333334,0.2822165,0.13666667,0.2822165,0.14,0.2822165,0.14333333,0.2822165,0.14666666,0.2822165,0.15,0.2822165,0.15333334,0.2822165,0.15666667,0.2822165,0.16,0.2822165,0.16333333,0.2822165,0.16666667,0.2822165,0.17,0.2822165,0.17333333,0.2822165,0.17666666,0.2822165,0.18,0.2822165,0.18333334,0.2822165,0.18666667,0.2822165,0.19,0.2822165,0.19333333,0.2822165,0.19666667,0.2822165,0.2,0.2822165,0.20333333,0.2822165,0.20666666,0.2822165,0.21,0.2822165,0.21333334,0.2822165,0.21666667,0.2822165,0.22,0.2822165,0.22333333,0.2822165,0.22666667,0.2822165,0.23,0.2822165,0.23333333,0.2822165,0.23666666,0.2822165,0.24,0.2822165,0.24333334,0.2822165,0.24666667,0.2822165,0.25,0.2822165,0.25333333,0.2822165,0.25666666,0.2822165,0.26,0.2822165,0.26333332,0.2822165,0.26666668,0.2822165,0.27,0.2822165,0.27333334,0.2822165,0.27666667,0.2822165,0.28,0.2822165,0.28333333,0.2822165,0.28666666,0.2822165,0.29,0.2822165,0.29333332,0.2822165,0.29666665,0.2822165,0.3,0.2822165,0.30333334,0.2822165,0.31,0.2822165,0.31333333,0.2822165,0.31666666,0.2822165,0.32,0.2822165,0.32333332,0.2822165,0.32666665,0.2822165,0.33,0.2822165,0.33333334,0.2822165,0.33666667,0.2822165,0.34,0.2822165,0.34333333,0.2822165,0.34666666,0.2822165,0.35,0.2822165,0.35333332,0.2822165,0.35666665,0.2822165,0.36,0.2822165,0.36333334,0.2822165,0.36666667,0.2822165,0.37,0.2822165,0.37333333,0.2822165,0.37666667,0.2822165,0.38,0.2822165,0.38333333,0.2822165,0.38666666,0.2822165,0.39,0.2822165,0.39333335,0.2822165,0.39666668,0.2822165,0.4,0.2822165,0.40333334,0.2822165,0.40666667,0.2822165,0.41,0.2822165,0.41333333,0.2822165,0.41666666,0.2822165,0.42,0.2822165,0.42333335,0.2822165,0.42666668,0.2822165,0.43,0.2822165,0.43333334,0.2822165,0.43666667,0.2822165,0.44,0.2822165,0.44333333,0.2822165,0.44666666,0.2822165,0.45,0.2822165,0.45333335,0.2822165,0.45666668,0.2822165,0.46,0.2822165,0.46333334,0.2822165,0.46666667,0.2822165,0.47,0.2822165,0.47333333,0.2822165,0.47666666,0.2822165,0.48,0.2822165,0.48333332,0.2822165,0.48666668,0.2822165,0.49,0.2822165,0.49333334,0.2822165,0.49666667,0.2822165,0.5,0.2822165,0.50333333,0.2822165,0.50666666,0.2822165,0.51,0.2822165,0.5133333,0.2822165,0.51666665,0.2822165,0.52,0.2822165,0.5233333,0.2822165,0.52666664,0.2822165,0.53,0.2822165,0.53333336,0.2822165,0.5366667,0.2822165,0.54,0.2822165,0.54333335,0.2822165,0.5466667,0.2822165,0.55,0.2822165,0.55333334,0.2822165,0.5566667,0.2822165,0.56,0.2822165,0.56333333,0.2822165,0.56666666,0.2822165,0.57,0.2822165,0.5733333,0.2822165,0.57666665,0.2822165,0.58,0.2822165,0.5833333,0.2822165,0.58666664,0.2822165,0.59,0.2822165,0.5933333,0.2822165,0.5966667,0.2822165,0.6,0.2822165,0.60333335,0.2822165,0.6066667,0.2822165,0.61,0.2822165,0.61333334,0.2822165,0.6933333,0.2822165,0.69666666,0.2822165,0.7,0.2822165,0.7033333,0.2822165,0.70666665,0.2822165,0.71,0.2822165,0.7133333,0.2822165,0.71666664,0.2822165,0.72,0.2822165,0.72333336,0.2822165,0.7266667,0.2822165,0.73,0.2822165,0.73333335,0.2822165,0.7366667,0.2822165,0.74,0.2822165,0.74333334,0.2822165,0.74666667,0.2822165,0.75,0.2822165,0.75333333,0.2822165,0.75666666,0.2822165,0.76,0.2822165,0.7633333,0.2822165,0.76666665,0.2822165,0.77,0.2822165,0.7733333,0.2822165,0.77666664,0.2822165,0.78,0.2822165,0.78333336,0.2822165,0.7866667,0.2822165,0.79,0.2822165,0.79333335,0.2822165,0.7966667,0.2822165,0.8,0.2822165,0.80333334,0.2822165,0.8066667,0.2822165,0.81,0.2822165,0.81333333,0.2822165,0.81666666,0.2822165,0.82,0.2822165,0.8233333,0.2822165,0.82666665,0.2822165,0.83,0.2822165,0.8333333,0.2822165,0.83666664,0.2822165,0.84,0.2822165,0.8433333,0.2822165,0.8466667,0.2822165,0.85,0.2822165,0.85333335,0.2822165,0.8566667,0.2822165,0.86,0.2822165,0.86333334,0.2822165,0.8666667,0.2822165,0.8833333,0.2822165,0.89,0.2822165,0.8933333,0.2822165,0.89666665,0.2822165,0.9,0.2822165,0.9033333,0.2822165,0.9066667,0.2822165,0.91,0.2822165,0.91333336,0.2822165,0.9166667,0.2822165,0.92,0.2822165,0.92333335,0.2822165,0.9266667,0.2822165,0.93,0.2822165,0.93333334,0.2822165,0.93666667,0.2822165,0.94,0.2822165,0.9433333,0.2822165,0.94666666,0.2822165,0.05,0.28479382,0.053333335,0.28479382,0.05666667,0.28479382,0.06,0.28479382,0.06333333,0.28479382,0.06666667,0.28479382,0.07,0.28479382,0.07333333,0.28479382,0.07666667,0.28479382,0.08,0.28479382,0.083333336,0.28479382,0.086666666,0.28479382,0.09,0.28479382,0.093333334,0.28479382,0.096666664,0.28479382,0.1,0.28479382,0.10333333,0.28479382,0.10666667,0.28479382,0.11,0.28479382,0.11333334,0.28479382,0.11666667,0.28479382,0.12,0.28479382,0.123333335,0.28479382,0.12666667,0.28479382,0.13,0.28479382,0.13333334,0.28479382,0.13666667,0.28479382,0.14,0.28479382,0.14333333,0.28479382,0.14666666,0.28479382,0.15,0.28479382,0.15333334,0.28479382,0.15666667,0.28479382,0.16,0.28479382,0.16333333,0.28479382,0.16666667,0.28479382,0.17,0.28479382,0.17333333,0.28479382,0.17666666,0.28479382,0.18,0.28479382,0.18333334,0.28479382,0.18666667,0.28479382,0.19,0.28479382,0.19333333,0.28479382,0.19666667,0.28479382,0.2,0.28479382,0.20333333,0.28479382,0.20666666,0.28479382,0.21,0.28479382,0.21333334,0.28479382,0.21666667,0.28479382,0.22,0.28479382,0.22333333,0.28479382,0.22666667,0.28479382,0.23,0.28479382,0.23333333,0.28479382,0.23666666,0.28479382,0.24,0.28479382,0.24333334,0.28479382,0.24666667,0.28479382,0.25,0.28479382,0.25333333,0.28479382,0.25666666,0.28479382,0.26,0.28479382,0.26333332,0.28479382,0.26666668,0.28479382,0.27,0.28479382,0.27333334,0.28479382,0.27666667,0.28479382,0.28,0.28479382,0.28333333,0.28479382,0.28666666,0.28479382,0.29,0.28479382,0.29333332,0.28479382,0.29666665,0.28479382,0.3,0.28479382,0.30333334,0.28479382,0.31,0.28479382,0.31333333,0.28479382,0.31666666,0.28479382,0.32,0.28479382,0.32333332,0.28479382,0.32666665,0.28479382,0.33,0.28479382,0.33333334,0.28479382,0.33666667,0.28479382,0.34,0.28479382,0.34333333,0.28479382,0.34666666,0.28479382,0.35,0.28479382,0.35333332,0.28479382,0.35666665,0.28479382,0.36,0.28479382,0.36333334,0.28479382,0.36666667,0.28479382,0.37,0.28479382,0.37333333,0.28479382,0.37666667,0.28479382,0.38,0.28479382,0.38333333,0.28479382,0.38666666,0.28479382,0.39,0.28479382,0.39333335,0.28479382,0.39666668,0.28479382,0.4,0.28479382,0.40333334,0.28479382,0.40666667,0.28479382,0.41,0.28479382,0.41333333,0.28479382,0.41666666,0.28479382,0.42,0.28479382,0.42333335,0.28479382,0.42666668,0.28479382,0.43,0.28479382,0.43333334,0.28479382,0.43666667,0.28479382,0.44,0.28479382,0.44333333,0.28479382,0.44666666,0.28479382,0.45,0.28479382,0.45333335,0.28479382,0.45666668,0.28479382,0.46,0.28479382,0.46333334,0.28479382,0.46666667,0.28479382,0.47,0.28479382,0.47333333,0.28479382,0.47666666,0.28479382,0.48,0.28479382,0.48333332,0.28479382,0.48666668,0.28479382,0.49,0.28479382,0.49333334,0.28479382,0.49666667,0.28479382,0.5,0.28479382,0.50333333,0.28479382,0.50666666,0.28479382,0.51,0.28479382,0.5133333,0.28479382,0.51666665,0.28479382,0.52,0.28479382,0.5233333,0.28479382,0.52666664,0.28479382,0.53,0.28479382,0.53333336,0.28479382,0.5366667,0.28479382,0.54,0.28479382,0.54333335,0.28479382,0.5466667,0.28479382,0.55,0.28479382,0.55333334,0.28479382,0.5566667,0.28479382,0.56,0.28479382,0.56333333,0.28479382,0.56666666,0.28479382,0.57,0.28479382,0.5733333,0.28479382,0.57666665,0.28479382,0.58,0.28479382,0.5833333,0.28479382,0.58666664,0.28479382,0.59,0.28479382,0.5933333,0.28479382,0.5966667,0.28479382,0.6,0.28479382,0.60333335,0.28479382,0.6066667,0.28479382,0.61,0.28479382,0.6566667,0.28479382,0.69666666,0.28479382,0.7,0.28479382,0.7033333,0.28479382,0.70666665,0.28479382,0.71,0.28479382,0.7133333,0.28479382,0.71666664,0.28479382,0.72,0.28479382,0.72333336,0.28479382,0.7266667,0.28479382,0.73,0.28479382,0.73333335,0.28479382,0.7366667,0.28479382,0.74,0.28479382,0.74333334,0.28479382,0.74666667,0.28479382,0.75,0.28479382,0.75333333,0.28479382,0.75666666,0.28479382,0.76,0.28479382,0.7633333,0.28479382,0.76666665,0.28479382,0.77,0.28479382,0.7733333,0.28479382,0.77666664,0.28479382,0.78,0.28479382,0.78333336,0.28479382,0.7866667,0.28479382,0.79,0.28479382,0.79333335,0.28479382,0.8,0.28479382,0.80333334,0.28479382,0.8066667,0.28479382,0.81,0.28479382,0.81333333,0.28479382,0.81666666,0.28479382,0.82,0.28479382,0.8233333,0.28479382,0.82666665,0.28479382,0.83,0.28479382,0.8333333,0.28479382,0.83666664,0.28479382,0.84,0.28479382,0.8433333,0.28479382,0.8466667,0.28479382,0.85333335,0.28479382,0.8566667,0.28479382,0.86,0.28479382,0.86333334,0.28479382,0.88666666,0.28479382,0.89,0.28479382,0.8933333,0.28479382,0.89666665,0.28479382,0.9,0.28479382,0.9033333,0.28479382,0.9066667,0.28479382,0.91,0.28479382,0.91333336,0.28479382,0.9166667,0.28479382,0.92,0.28479382,0.92333335,0.28479382,0.9266667,0.28479382,0.93,0.28479382,0.93333334,0.28479382,0.93666667,0.28479382,0.94,0.28479382,0.9433333,0.28479382,0.94666666,0.28479382,0.05,0.28737113,0.053333335,0.28737113,0.05666667,0.28737113,0.06,0.28737113,0.06333333,0.28737113,0.06666667,0.28737113,0.07,0.28737113,0.07333333,0.28737113,0.07666667,0.28737113,0.08,0.28737113,0.083333336,0.28737113,0.086666666,0.28737113,0.09,0.28737113,0.093333334,0.28737113,0.096666664,0.28737113,0.1,0.28737113,0.10333333,0.28737113,0.10666667,0.28737113,0.11,0.28737113,0.11333334,0.28737113,0.11666667,0.28737113,0.12,0.28737113,0.123333335,0.28737113,0.12666667,0.28737113,0.13,0.28737113,0.13333334,0.28737113,0.13666667,0.28737113,0.14,0.28737113,0.14333333,0.28737113,0.14666666,0.28737113,0.15,0.28737113,0.15333334,0.28737113,0.15666667,0.28737113,0.16,0.28737113,0.16333333,0.28737113,0.16666667,0.28737113,0.17,0.28737113,0.17333333,0.28737113,0.17666666,0.28737113,0.18,0.28737113,0.18333334,0.28737113,0.18666667,0.28737113,0.19,0.28737113,0.19333333,0.28737113,0.19666667,0.28737113,0.2,0.28737113,0.20333333,0.28737113,0.20666666,0.28737113,0.21,0.28737113,0.21333334,0.28737113,0.21666667,0.28737113,0.22,0.28737113,0.22333333,0.28737113,0.22666667,0.28737113,0.23,0.28737113,0.23333333,0.28737113,0.23666666,0.28737113,0.24,0.28737113,0.24333334,0.28737113,0.24666667,0.28737113,0.25,0.28737113,0.25333333,0.28737113,0.25666666,0.28737113,0.26,0.28737113,0.26333332,0.28737113,0.26666668,0.28737113,0.27,0.28737113,0.27333334,0.28737113,0.27666667,0.28737113,0.28,0.28737113,0.28333333,0.28737113,0.28666666,0.28737113,0.29,0.28737113,0.29333332,0.28737113,0.29666665,0.28737113,0.3,0.28737113,0.30333334,0.28737113,0.31,0.28737113,0.31333333,0.28737113,0.31666666,0.28737113,0.32,0.28737113,0.32333332,0.28737113,0.32666665,0.28737113,0.33,0.28737113,0.33333334,0.28737113,0.33666667,0.28737113,0.34,0.28737113,0.34333333,0.28737113,0.34666666,0.28737113,0.35,0.28737113,0.35333332,0.28737113,0.35666665,0.28737113,0.36,0.28737113,0.36333334,0.28737113,0.36666667,0.28737113,0.37,0.28737113,0.37333333,0.28737113,0.37666667,0.28737113,0.38,0.28737113,0.38333333,0.28737113,0.39666668,0.28737113,0.4,0.28737113,0.40333334,0.28737113,0.40666667,0.28737113,0.41,0.28737113,0.41666666,0.28737113,0.42,0.28737113,0.42333335,0.28737113,0.42666668,0.28737113,0.43,0.28737113,0.43333334,0.28737113,0.43666667,0.28737113,0.44,0.28737113,0.44333333,0.28737113,0.44666666,0.28737113,0.45,0.28737113,0.45333335,0.28737113,0.45666668,0.28737113,0.46,0.28737113,0.46333334,0.28737113,0.46666667,0.28737113,0.47,0.28737113,0.47333333,0.28737113,0.47666666,0.28737113,0.48,0.28737113,0.48333332,0.28737113,0.48666668,0.28737113,0.49,0.28737113,0.49333334,0.28737113,0.49666667,0.28737113,0.5,0.28737113,0.50333333,0.28737113,0.50666666,0.28737113,0.51,0.28737113,0.5133333,0.28737113,0.51666665,0.28737113,0.52,0.28737113,0.5233333,0.28737113,0.52666664,0.28737113,0.53,0.28737113,0.53333336,0.28737113,0.5366667,0.28737113,0.54,0.28737113,0.54333335,0.28737113,0.5466667,0.28737113,0.55,0.28737113,0.55333334,0.28737113,0.5566667,0.28737113,0.56,0.28737113,0.56333333,0.28737113,0.56666666,0.28737113,0.57,0.28737113,0.5733333,0.28737113,0.57666665,0.28737113,0.5833333,0.28737113,0.58666664,0.28737113,0.59,0.28737113,0.5933333,0.28737113,0.5966667,0.28737113,0.6,0.28737113,0.60333335,0.28737113,0.6066667,0.28737113,0.6566667,0.28737113,0.7033333,0.28737113,0.70666665,0.28737113,0.71,0.28737113,0.7133333,0.28737113,0.71666664,0.28737113,0.72,0.28737113,0.72333336,0.28737113,0.7266667,0.28737113,0.73,0.28737113,0.73333335,0.28737113,0.7366667,0.28737113,0.74,0.28737113,0.74333334,0.28737113,0.74666667,0.28737113,0.75,0.28737113,0.75333333,0.28737113,0.75666666,0.28737113,0.76,0.28737113,0.7633333,0.28737113,0.76666665,0.28737113,0.77,0.28737113,0.7733333,0.28737113,0.77666664,0.28737113,0.78,0.28737113,0.78333336,0.28737113,0.7866667,0.28737113,0.79,0.28737113,0.79333335,0.28737113,0.7966667,0.28737113,0.8,0.28737113,0.80333334,0.28737113,0.8066667,0.28737113,0.81,0.28737113,0.81333333,0.28737113,0.81666666,0.28737113,0.82,0.28737113,0.8233333,0.28737113,0.82666665,0.28737113,0.83,0.28737113,0.8333333,0.28737113,0.83666664,0.28737113,0.84,0.28737113,0.8433333,0.28737113,0.8466667,0.28737113,0.85,0.28737113,0.85333335,0.28737113,0.8566667,0.28737113,0.86,0.28737113,0.86333334,0.28737113,0.8666667,0.28737113,0.87,0.28737113,0.89,0.28737113,0.89666665,0.28737113,0.9,0.28737113,0.9033333,0.28737113,0.9066667,0.28737113,0.91,0.28737113,0.91333336,0.28737113,0.9166667,0.28737113,0.92,0.28737113,0.92333335,0.28737113,0.9266667,0.28737113,0.93,0.28737113,0.93333334,0.28737113,0.93666667,0.28737113,0.94,0.28737113,0.9433333,0.28737113,0.94666666,0.28737113,0.05,0.28994846,0.053333335,0.28994846,0.05666667,0.28994846,0.06,0.28994846,0.06333333,0.28994846,0.06666667,0.28994846,0.07,0.28994846,0.07333333,0.28994846,0.07666667,0.28994846,0.08,0.28994846,0.083333336,0.28994846,0.086666666,0.28994846,0.09,0.28994846,0.093333334,0.28994846,0.096666664,0.28994846,0.1,0.28994846,0.10333333,0.28994846,0.10666667,0.28994846,0.11,0.28994846,0.11333334,0.28994846,0.11666667,0.28994846,0.12,0.28994846,0.123333335,0.28994846,0.12666667,0.28994846,0.13,0.28994846,0.13333334,0.28994846,0.13666667,0.28994846,0.14,0.28994846,0.14333333,0.28994846,0.14666666,0.28994846,0.15,0.28994846,0.15333334,0.28994846,0.15666667,0.28994846,0.16,0.28994846,0.16333333,0.28994846,0.16666667,0.28994846,0.17,0.28994846,0.17333333,0.28994846,0.17666666,0.28994846,0.18,0.28994846,0.18333334,0.28994846,0.18666667,0.28994846,0.19,0.28994846,0.19333333,0.28994846,0.19666667,0.28994846,0.2,0.28994846,0.20333333,0.28994846,0.20666666,0.28994846,0.21,0.28994846,0.21333334,0.28994846,0.21666667,0.28994846,0.22,0.28994846,0.22333333,0.28994846,0.22666667,0.28994846,0.23,0.28994846,0.23333333,0.28994846,0.23666666,0.28994846,0.24,0.28994846,0.24333334,0.28994846,0.24666667,0.28994846,0.25,0.28994846,0.25333333,0.28994846,0.25666666,0.28994846,0.26,0.28994846,0.26333332,0.28994846,0.26666668,0.28994846,0.27,0.28994846,0.27333334,0.28994846,0.27666667,0.28994846,0.28,0.28994846,0.28333333,0.28994846,0.28666666,0.28994846,0.29,0.28994846,0.29333332,0.28994846,0.29666665,0.28994846,0.3,0.28994846,0.30333334,0.28994846,0.30666667,0.28994846,0.31333333,0.28994846,0.31666666,0.28994846,0.32,0.28994846,0.32333332,0.28994846,0.32666665,0.28994846,0.34,0.28994846,0.34333333,0.28994846,0.34666666,0.28994846,0.35,0.28994846,0.35333332,0.28994846,0.36666667,0.28994846,0.37,0.28994846,0.37333333,0.28994846,0.37666667,0.28994846,0.38,0.28994846,0.38333333,0.28994846,0.38666666,0.28994846,0.39,0.28994846,0.39666668,0.28994846,0.4,0.28994846,0.41333333,0.28994846,0.41666666,0.28994846,0.42,0.28994846,0.42333335,0.28994846,0.42666668,0.28994846,0.43,0.28994846,0.43333334,0.28994846,0.43666667,0.28994846,0.44,0.28994846,0.44333333,0.28994846,0.44666666,0.28994846,0.45,0.28994846,0.45333335,0.28994846,0.45666668,0.28994846,0.46,0.28994846,0.46333334,0.28994846,0.46666667,0.28994846,0.47,0.28994846,0.47333333,0.28994846,0.47666666,0.28994846,0.48,0.28994846,0.48333332,0.28994846,0.48666668,0.28994846,0.49,0.28994846,0.49333334,0.28994846,0.49666667,0.28994846,0.5,0.28994846,0.50333333,0.28994846,0.50666666,0.28994846,0.51,0.28994846,0.5133333,0.28994846,0.51666665,0.28994846,0.52,0.28994846,0.5233333,0.28994846,0.52666664,0.28994846,0.53,0.28994846,0.53333336,0.28994846,0.5366667,0.28994846,0.54,0.28994846,0.54333335,0.28994846,0.5466667,0.28994846,0.55,0.28994846,0.55333334,0.28994846,0.5566667,0.28994846,0.56,0.28994846,0.56333333,0.28994846,0.56666666,0.28994846,0.57,0.28994846,0.57666665,0.28994846,0.58,0.28994846,0.5833333,0.28994846,0.58666664,0.28994846,0.59,0.28994846,0.5933333,0.28994846,0.5966667,0.28994846,0.6,0.28994846,0.60333335,0.28994846,0.6166667,0.28994846,0.62,0.28994846,0.62333333,0.28994846,0.6333333,0.28994846,0.63666666,0.28994846,0.64,0.28994846,0.6433333,0.28994846,0.6533333,0.28994846,0.6566667,0.28994846,0.71,0.28994846,0.7133333,0.28994846,0.71666664,0.28994846,0.72,0.28994846,0.72333336,0.28994846,0.7266667,0.28994846,0.73,0.28994846,0.73333335,0.28994846,0.7366667,0.28994846,0.74,0.28994846,0.74333334,0.28994846,0.74666667,0.28994846,0.75,0.28994846,0.75333333,0.28994846,0.75666666,0.28994846,0.76,0.28994846,0.7633333,0.28994846,0.76666665,0.28994846,0.77,0.28994846,0.7733333,0.28994846,0.77666664,0.28994846,0.78,0.28994846,0.78333336,0.28994846,0.7866667,0.28994846,0.79,0.28994846,0.79333335,0.28994846,0.7966667,0.28994846,0.8,0.28994846,0.81,0.28994846,0.81333333,0.28994846,0.81666666,0.28994846,0.82,0.28994846,0.8233333,0.28994846,0.82666665,0.28994846,0.83,0.28994846,0.8333333,0.28994846,0.83666664,0.28994846,0.84,0.28994846,0.8433333,0.28994846,0.8466667,0.28994846,0.85,0.28994846,0.85333335,0.28994846,0.8566667,0.28994846,0.86,0.28994846,0.86333334,0.28994846,0.8666667,0.28994846,0.87333333,0.28994846,0.88666666,0.28994846,0.89,0.28994846,0.8933333,0.28994846,0.89666665,0.28994846,0.9,0.28994846,0.9033333,0.28994846,0.91,0.28994846,0.91333336,0.28994846,0.9166667,0.28994846,0.92,0.28994846,0.92333335,0.28994846,0.9266667,0.28994846,0.93,0.28994846,0.93333334,0.28994846,0.93666667,0.28994846,0.94,0.28994846,0.9433333,0.28994846,0.94666666,0.28994846,0.05,0.29252577,0.053333335,0.29252577,0.05666667,0.29252577,0.06,0.29252577,0.06333333,0.29252577,0.06666667,0.29252577,0.07,0.29252577,0.07333333,0.29252577,0.07666667,0.29252577,0.08,0.29252577,0.083333336,0.29252577,0.086666666,0.29252577,0.09,0.29252577,0.093333334,0.29252577,0.096666664,0.29252577,0.1,0.29252577,0.10333333,0.29252577,0.10666667,0.29252577,0.11,0.29252577,0.11333334,0.29252577,0.11666667,0.29252577,0.12,0.29252577,0.123333335,0.29252577,0.12666667,0.29252577,0.13,0.29252577,0.13333334,0.29252577,0.13666667,0.29252577,0.14,0.29252577,0.14333333,0.29252577,0.14666666,0.29252577,0.15,0.29252577,0.15333334,0.29252577,0.15666667,0.29252577,0.16,0.29252577,0.16333333,0.29252577,0.16666667,0.29252577,0.17,0.29252577,0.17333333,0.29252577,0.17666666,0.29252577,0.18,0.29252577,0.18333334,0.29252577,0.18666667,0.29252577,0.19,0.29252577,0.19333333,0.29252577,0.19666667,0.29252577,0.2,0.29252577,0.20333333,0.29252577,0.20666666,0.29252577,0.21,0.29252577,0.21333334,0.29252577,0.21666667,0.29252577,0.22,0.29252577,0.22333333,0.29252577,0.22666667,0.29252577,0.23,0.29252577,0.23333333,0.29252577,0.23666666,0.29252577,0.24,0.29252577,0.24333334,0.29252577,0.24666667,0.29252577,0.25,0.29252577,0.25333333,0.29252577,0.25666666,0.29252577,0.26,0.29252577,0.26333332,0.29252577,0.26666668,0.29252577,0.27,0.29252577,0.27333334,0.29252577,0.27666667,0.29252577,0.28,0.29252577,0.28333333,0.29252577,0.28666666,0.29252577,0.29,0.29252577,0.29333332,0.29252577,0.29666665,0.29252577,0.3,0.29252577,0.30333334,0.29252577,0.30666667,0.29252577,0.31,0.29252577,0.31333333,0.29252577,0.31666666,0.29252577,0.32,0.29252577,0.35333332,0.29252577,0.35666665,0.29252577,0.36,0.29252577,0.36333334,0.29252577,0.36666667,0.29252577,0.37,0.29252577,0.37333333,0.29252577,0.38,0.29252577,0.38666666,0.29252577,0.39,0.29252577,0.40333334,0.29252577,0.40666667,0.29252577,0.41,0.29252577,0.41333333,0.29252577,0.41666666,0.29252577,0.42,0.29252577,0.42333335,0.29252577,0.42666668,0.29252577,0.43,0.29252577,0.43333334,0.29252577,0.43666667,0.29252577,0.44,0.29252577,0.44333333,0.29252577,0.44666666,0.29252577,0.45,0.29252577,0.45333335,0.29252577,0.45666668,0.29252577,0.46,0.29252577,0.46333334,0.29252577,0.46666667,0.29252577,0.47,0.29252577,0.47333333,0.29252577,0.47666666,0.29252577,0.48,0.29252577,0.48333332,0.29252577,0.48666668,0.29252577,0.49,0.29252577,0.49333334,0.29252577,0.49666667,0.29252577,0.5,0.29252577,0.50333333,0.29252577,0.50666666,0.29252577,0.51,0.29252577,0.5133333,0.29252577,0.51666665,0.29252577,0.52,0.29252577,0.5233333,0.29252577,0.52666664,0.29252577,0.53,0.29252577,0.53333336,0.29252577,0.5366667,0.29252577,0.54,0.29252577,0.54333335,0.29252577,0.5466667,0.29252577,0.55,0.29252577,0.55333334,0.29252577,0.5566667,0.29252577,0.56,0.29252577,0.56333333,0.29252577,0.56666666,0.29252577,0.5733333,0.29252577,0.57666665,0.29252577,0.58,0.29252577,0.5833333,0.29252577,0.58666664,0.29252577,0.59,0.29252577,0.5933333,0.29252577,0.60333335,0.29252577,0.6166667,0.29252577,0.62,0.29252577,0.62333333,0.29252577,0.62666667,0.29252577,0.63,0.29252577,0.6333333,0.29252577,0.63666666,0.29252577,0.64,0.29252577,0.6433333,0.29252577,0.64666665,0.29252577,0.65,0.29252577,0.6533333,0.29252577,0.6566667,0.29252577,0.66,0.29252577,0.66333336,0.29252577,0.6666667,0.29252577,0.7133333,0.29252577,0.71666664,0.29252577,0.72,0.29252577,0.72333336,0.29252577,0.7266667,0.29252577,0.73,0.29252577,0.73333335,0.29252577,0.7366667,0.29252577,0.74,0.29252577,0.74333334,0.29252577,0.74666667,0.29252577,0.75,0.29252577,0.75333333,0.29252577,0.75666666,0.29252577,0.76,0.29252577,0.7633333,0.29252577,0.76666665,0.29252577,0.77,0.29252577,0.7733333,0.29252577,0.77666664,0.29252577,0.78,0.29252577,0.78333336,0.29252577,0.7866667,0.29252577,0.79,0.29252577,0.79333335,0.29252577,0.7966667,0.29252577,0.8,0.29252577,0.80333334,0.29252577,0.8066667,0.29252577,0.81,0.29252577,0.81333333,0.29252577,0.81666666,0.29252577,0.82,0.29252577,0.8233333,0.29252577,0.82666665,0.29252577,0.83,0.29252577,0.8333333,0.29252577,0.83666664,0.29252577,0.84,0.29252577,0.8433333,0.29252577,0.8466667,0.29252577,0.85,0.29252577,0.85333335,0.29252577,0.8566667,0.29252577,0.86,0.29252577,0.86333334,0.29252577,0.8666667,0.29252577,0.87666667,0.29252577,0.8833333,0.29252577,0.8933333,0.29252577,0.89666665,0.29252577,0.9,0.29252577,0.9033333,0.29252577,0.9066667,0.29252577,0.91,0.29252577,0.91333336,0.29252577,0.9166667,0.29252577,0.92,0.29252577,0.92333335,0.29252577,0.9266667,0.29252577,0.93,0.29252577,0.93333334,0.29252577,0.93666667,0.29252577,0.94,0.29252577,0.9433333,0.29252577,0.94666666,0.29252577,0.05,0.2951031,0.053333335,0.2951031,0.05666667,0.2951031,0.06,0.2951031,0.06333333,0.2951031,0.06666667,0.2951031,0.07,0.2951031,0.07333333,0.2951031,0.07666667,0.2951031,0.08,0.2951031,0.083333336,0.2951031,0.086666666,0.2951031,0.09,0.2951031,0.093333334,0.2951031,0.096666664,0.2951031,0.1,0.2951031,0.10333333,0.2951031,0.10666667,0.2951031,0.11,0.2951031,0.11333334,0.2951031,0.11666667,0.2951031,0.12,0.2951031,0.123333335,0.2951031,0.12666667,0.2951031,0.13,0.2951031,0.13333334,0.2951031,0.13666667,0.2951031,0.14,0.2951031,0.14333333,0.2951031,0.14666666,0.2951031,0.15,0.2951031,0.15333334,0.2951031,0.15666667,0.2951031,0.16,0.2951031,0.16333333,0.2951031,0.16666667,0.2951031,0.17,0.2951031,0.17333333,0.2951031,0.17666666,0.2951031,0.18,0.2951031,0.18333334,0.2951031,0.18666667,0.2951031,0.19,0.2951031,0.19333333,0.2951031,0.19666667,0.2951031,0.2,0.2951031,0.20333333,0.2951031,0.20666666,0.2951031,0.21,0.2951031,0.21333334,0.2951031,0.21666667,0.2951031,0.22,0.2951031,0.22333333,0.2951031,0.22666667,0.2951031,0.23,0.2951031,0.23333333,0.2951031,0.23666666,0.2951031,0.24,0.2951031,0.24333334,0.2951031,0.24666667,0.2951031,0.25,0.2951031,0.25333333,0.2951031,0.25666666,0.2951031,0.26,0.2951031,0.26333332,0.2951031,0.26666668,0.2951031,0.27,0.2951031,0.27333334,0.2951031,0.27666667,0.2951031,0.28,0.2951031,0.28333333,0.2951031,0.28666666,0.2951031,0.29,0.2951031,0.29333332,0.2951031,0.29666665,0.2951031,0.3,0.2951031,0.30333334,0.2951031,0.30666667,0.2951031,0.31,0.2951031,0.31333333,0.2951031,0.31666666,0.2951031,0.32,0.2951031,0.32333332,0.2951031,0.32666665,0.2951031,0.33,0.2951031,0.33333334,0.2951031,0.33666667,0.2951031,0.34,0.2951031,0.34333333,0.2951031,0.34666666,0.2951031,0.35,0.2951031,0.35333332,0.2951031,0.35666665,0.2951031,0.36,0.2951031,0.36333334,0.2951031,0.36666667,0.2951031,0.37,0.2951031,0.37333333,0.2951031,0.37666667,0.2951031,0.38,0.2951031,0.38333333,0.2951031,0.38666666,0.2951031,0.39,0.2951031,0.39333335,0.2951031,0.39666668,0.2951031,0.4,0.2951031,0.40333334,0.2951031,0.40666667,0.2951031,0.41,0.2951031,0.41333333,0.2951031,0.41666666,0.2951031,0.42,0.2951031,0.42333335,0.2951031,0.42666668,0.2951031,0.43,0.2951031,0.43333334,0.2951031,0.43666667,0.2951031,0.44,0.2951031,0.44333333,0.2951031,0.44666666,0.2951031,0.45,0.2951031,0.45333335,0.2951031,0.45666668,0.2951031,0.46,0.2951031,0.46333334,0.2951031,0.46666667,0.2951031,0.47,0.2951031,0.47333333,0.2951031,0.47666666,0.2951031,0.48,0.2951031,0.48333332,0.2951031,0.48666668,0.2951031,0.49,0.2951031,0.49333334,0.2951031,0.49666667,0.2951031,0.5,0.2951031,0.50333333,0.2951031,0.50666666,0.2951031,0.51,0.2951031,0.5133333,0.2951031,0.51666665,0.2951031,0.52,0.2951031,0.5233333,0.2951031,0.52666664,0.2951031,0.53,0.2951031,0.53333336,0.2951031,0.5366667,0.2951031,0.54,0.2951031,0.54333335,0.2951031,0.5466667,0.2951031,0.55,0.2951031,0.55333334,0.2951031,0.5566667,0.2951031,0.56,0.2951031,0.56333333,0.2951031,0.57,0.2951031,0.5733333,0.2951031,0.57666665,0.2951031,0.58,0.2951031,0.5833333,0.2951031,0.58666664,0.2951031,0.59,0.2951031,0.61333334,0.2951031,0.6166667,0.2951031,0.62,0.2951031,0.62333333,0.2951031,0.62666667,0.2951031,0.63,0.2951031,0.6333333,0.2951031,0.63666666,0.2951031,0.64,0.2951031,0.6433333,0.2951031,0.64666665,0.2951031,0.65,0.2951031,0.6533333,0.2951031,0.6566667,0.2951031,0.66,0.2951031,0.66333336,0.2951031,0.6666667,0.2951031,0.72,0.2951031,0.72333336,0.2951031,0.7266667,0.2951031,0.73,0.2951031,0.73333335,0.2951031,0.7366667,0.2951031,0.74,0.2951031,0.74333334,0.2951031,0.74666667,0.2951031,0.75,0.2951031,0.75333333,0.2951031,0.75666666,0.2951031,0.76,0.2951031,0.7633333,0.2951031,0.76666665,0.2951031,0.77,0.2951031,0.7733333,0.2951031,0.77666664,0.2951031,0.78,0.2951031,0.78333336,0.2951031,0.7866667,0.2951031,0.79,0.2951031,0.79333335,0.2951031,0.7966667,0.2951031,0.8,0.2951031,0.80333334,0.2951031,0.8066667,0.2951031,0.81,0.2951031,0.81333333,0.2951031,0.81666666,0.2951031,0.82,0.2951031,0.8233333,0.2951031,0.82666665,0.2951031,0.83,0.2951031,0.8333333,0.2951031,0.83666664,0.2951031,0.84,0.2951031,0.8433333,0.2951031,0.8466667,0.2951031,0.85,0.2951031,0.85333335,0.2951031,0.8566667,0.2951031,0.86333334,0.2951031,0.8666667,0.2951031,0.8933333,0.2951031,0.89666665,0.2951031,0.9,0.2951031,0.9033333,0.2951031,0.9066667,0.2951031,0.91,0.2951031,0.91333336,0.2951031,0.9166667,0.2951031,0.92,0.2951031,0.92333335,0.2951031,0.9266667,0.2951031,0.93,0.2951031,0.93333334,0.2951031,0.93666667,0.2951031,0.94,0.2951031,0.9433333,0.2951031,0.94666666,0.2951031,0.05,0.2976804,0.053333335,0.2976804,0.05666667,0.2976804,0.06,0.2976804,0.06333333,0.2976804,0.06666667,0.2976804,0.07,0.2976804,0.07333333,0.2976804,0.07666667,0.2976804,0.08,0.2976804,0.083333336,0.2976804,0.086666666,0.2976804,0.09,0.2976804,0.093333334,0.2976804,0.096666664,0.2976804,0.1,0.2976804,0.10333333,0.2976804,0.10666667,0.2976804,0.11,0.2976804,0.11333334,0.2976804,0.11666667,0.2976804,0.12,0.2976804,0.123333335,0.2976804,0.12666667,0.2976804,0.13,0.2976804,0.13333334,0.2976804,0.13666667,0.2976804,0.14,0.2976804,0.14333333,0.2976804,0.14666666,0.2976804,0.15,0.2976804,0.15333334,0.2976804,0.15666667,0.2976804,0.16,0.2976804,0.16333333,0.2976804,0.16666667,0.2976804,0.17,0.2976804,0.17333333,0.2976804,0.17666666,0.2976804,0.18,0.2976804,0.18333334,0.2976804,0.18666667,0.2976804,0.19,0.2976804,0.19333333,0.2976804,0.19666667,0.2976804,0.2,0.2976804,0.20333333,0.2976804,0.20666666,0.2976804,0.21,0.2976804,0.21333334,0.2976804,0.21666667,0.2976804,0.22,0.2976804,0.22333333,0.2976804,0.22666667,0.2976804,0.23,0.2976804,0.23333333,0.2976804,0.23666666,0.2976804,0.24,0.2976804,0.24333334,0.2976804,0.24666667,0.2976804,0.25,0.2976804,0.25333333,0.2976804,0.25666666,0.2976804,0.26,0.2976804,0.26333332,0.2976804,0.26666668,0.2976804,0.27,0.2976804,0.27333334,0.2976804,0.27666667,0.2976804,0.28,0.2976804,0.28333333,0.2976804,0.28666666,0.2976804,0.29,0.2976804,0.29333332,0.2976804,0.29666665,0.2976804,0.3,0.2976804,0.30333334,0.2976804,0.30666667,0.2976804,0.31,0.2976804,0.31333333,0.2976804,0.31666666,0.2976804,0.32,0.2976804,0.32333332,0.2976804,0.32666665,0.2976804,0.33,0.2976804,0.33333334,0.2976804,0.33666667,0.2976804,0.34,0.2976804,0.34333333,0.2976804,0.34666666,0.2976804,0.35,0.2976804,0.35333332,0.2976804,0.35666665,0.2976804,0.36,0.2976804,0.36333334,0.2976804,0.36666667,0.2976804,0.37,0.2976804,0.37333333,0.2976804,0.37666667,0.2976804,0.39,0.2976804,0.39333335,0.2976804,0.39666668,0.2976804,0.4,0.2976804,0.40333334,0.2976804,0.40666667,0.2976804,0.41,0.2976804,0.41333333,0.2976804,0.41666666,0.2976804,0.42,0.2976804,0.42333335,0.2976804,0.42666668,0.2976804,0.43,0.2976804,0.43333334,0.2976804,0.43666667,0.2976804,0.44,0.2976804,0.44333333,0.2976804,0.44666666,0.2976804,0.45,0.2976804,0.45333335,0.2976804,0.45666668,0.2976804,0.46,0.2976804,0.46333334,0.2976804,0.46666667,0.2976804,0.47,0.2976804,0.47333333,0.2976804,0.47666666,0.2976804,0.48,0.2976804,0.48333332,0.2976804,0.48666668,0.2976804,0.49,0.2976804,0.49333334,0.2976804,0.49666667,0.2976804,0.5,0.2976804,0.50333333,0.2976804,0.50666666,0.2976804,0.51,0.2976804,0.5133333,0.2976804,0.51666665,0.2976804,0.52,0.2976804,0.5233333,0.2976804,0.52666664,0.2976804,0.53,0.2976804,0.53333336,0.2976804,0.5366667,0.2976804,0.54,0.2976804,0.54333335,0.2976804,0.5466667,0.2976804,0.55,0.2976804,0.55333334,0.2976804,0.5566667,0.2976804,0.56333333,0.2976804,0.56666666,0.2976804,0.57,0.2976804,0.5733333,0.2976804,0.57666665,0.2976804,0.58,0.2976804,0.5833333,0.2976804,0.58666664,0.2976804,0.61333334,0.2976804,0.6166667,0.2976804,0.62,0.2976804,0.62333333,0.2976804,0.62666667,0.2976804,0.63,0.2976804,0.6333333,0.2976804,0.63666666,0.2976804,0.64,0.2976804,0.6433333,0.2976804,0.64666665,0.2976804,0.65,0.2976804,0.6533333,0.2976804,0.6566667,0.2976804,0.66,0.2976804,0.66333336,0.2976804,0.6666667,0.2976804,0.72,0.2976804,0.72333336,0.2976804,0.7266667,0.2976804,0.73,0.2976804,0.73333335,0.2976804,0.7366667,0.2976804,0.74,0.2976804,0.74333334,0.2976804,0.74666667,0.2976804,0.75,0.2976804,0.75333333,0.2976804,0.75666666,0.2976804,0.76,0.2976804,0.7633333,0.2976804,0.76666665,0.2976804,0.77,0.2976804,0.7733333,0.2976804,0.77666664,0.2976804,0.78,0.2976804,0.78333336,0.2976804,0.7866667,0.2976804,0.79,0.2976804,0.79333335,0.2976804,0.7966667,0.2976804,0.8,0.2976804,0.80333334,0.2976804,0.8066667,0.2976804,0.81,0.2976804,0.81333333,0.2976804,0.81666666,0.2976804,0.82,0.2976804,0.8233333,0.2976804,0.82666665,0.2976804,0.83,0.2976804,0.8333333,0.2976804,0.83666664,0.2976804,0.84,0.2976804,0.8433333,0.2976804,0.8466667,0.2976804,0.85,0.2976804,0.85333335,0.2976804,0.8566667,0.2976804,0.8666667,0.2976804,0.87,0.2976804,0.89,0.2976804,0.8933333,0.2976804,0.89666665,0.2976804,0.9,0.2976804,0.9033333,0.2976804,0.9066667,0.2976804,0.91,0.2976804,0.91333336,0.2976804,0.9166667,0.2976804,0.92,0.2976804,0.92333335,0.2976804,0.9266667,0.2976804,0.93,0.2976804,0.93333334,0.2976804,0.93666667,0.2976804,0.94,0.2976804,0.9433333,0.2976804,0.94666666,0.2976804,0.05,0.30025774,0.053333335,0.30025774,0.05666667,0.30025774,0.06,0.30025774,0.06333333,0.30025774,0.06666667,0.30025774,0.07,0.30025774,0.07333333,0.30025774,0.07666667,0.30025774,0.08,0.30025774,0.083333336,0.30025774,0.086666666,0.30025774,0.09,0.30025774,0.093333334,0.30025774,0.096666664,0.30025774,0.1,0.30025774,0.10333333,0.30025774,0.10666667,0.30025774,0.11,0.30025774,0.11333334,0.30025774,0.11666667,0.30025774,0.12,0.30025774,0.123333335,0.30025774,0.12666667,0.30025774,0.13,0.30025774,0.13333334,0.30025774,0.13666667,0.30025774,0.14,0.30025774,0.14333333,0.30025774,0.14666666,0.30025774,0.15,0.30025774,0.15333334,0.30025774,0.15666667,0.30025774,0.16,0.30025774,0.16333333,0.30025774,0.16666667,0.30025774,0.17,0.30025774,0.17333333,0.30025774,0.17666666,0.30025774,0.18,0.30025774,0.18333334,0.30025774,0.18666667,0.30025774,0.19,0.30025774,0.19333333,0.30025774,0.19666667,0.30025774,0.2,0.30025774,0.20333333,0.30025774,0.20666666,0.30025774,0.21,0.30025774,0.21333334,0.30025774,0.21666667,0.30025774,0.22,0.30025774,0.22333333,0.30025774,0.22666667,0.30025774,0.23,0.30025774,0.23333333,0.30025774,0.23666666,0.30025774,0.24,0.30025774,0.24333334,0.30025774,0.24666667,0.30025774,0.25,0.30025774,0.25333333,0.30025774,0.25666666,0.30025774,0.26,0.30025774,0.26333332,0.30025774,0.26666668,0.30025774,0.27,0.30025774,0.27333334,0.30025774,0.27666667,0.30025774,0.28,0.30025774,0.28333333,0.30025774,0.28666666,0.30025774,0.29,0.30025774,0.29333332,0.30025774,0.29666665,0.30025774,0.3,0.30025774,0.30333334,0.30025774,0.30666667,0.30025774,0.31,0.30025774,0.31333333,0.30025774,0.31666666,0.30025774,0.32,0.30025774,0.32333332,0.30025774,0.32666665,0.30025774,0.33,0.30025774,0.33333334,0.30025774,0.33666667,0.30025774,0.34,0.30025774,0.34333333,0.30025774,0.34666666,0.30025774,0.35,0.30025774,0.35333332,0.30025774,0.35666665,0.30025774,0.36,0.30025774,0.36333334,0.30025774,0.36666667,0.30025774,0.39,0.30025774,0.39333335,0.30025774,0.39666668,0.30025774,0.4,0.30025774,0.40333334,0.30025774,0.40666667,0.30025774,0.41,0.30025774,0.41333333,0.30025774,0.41666666,0.30025774,0.42,0.30025774,0.42333335,0.30025774,0.42666668,0.30025774,0.43,0.30025774,0.43333334,0.30025774,0.43666667,0.30025774,0.44,0.30025774,0.44333333,0.30025774,0.44666666,0.30025774,0.45,0.30025774,0.45333335,0.30025774,0.45666668,0.30025774,0.46,0.30025774,0.46333334,0.30025774,0.46666667,0.30025774,0.47,0.30025774,0.47333333,0.30025774,0.47666666,0.30025774,0.48,0.30025774,0.48333332,0.30025774,0.48666668,0.30025774,0.49,0.30025774,0.49333334,0.30025774,0.49666667,0.30025774,0.5,0.30025774,0.50333333,0.30025774,0.50666666,0.30025774,0.51,0.30025774,0.5133333,0.30025774,0.51666665,0.30025774,0.52,0.30025774,0.5233333,0.30025774,0.52666664,0.30025774,0.53,0.30025774,0.53333336,0.30025774,0.5366667,0.30025774,0.54,0.30025774,0.54333335,0.30025774,0.5466667,0.30025774,0.55,0.30025774,0.55333334,0.30025774,0.56,0.30025774,0.56333333,0.30025774,0.56666666,0.30025774,0.57,0.30025774,0.5733333,0.30025774,0.57666665,0.30025774,0.58,0.30025774,0.61333334,0.30025774,0.6166667,0.30025774,0.62,0.30025774,0.62333333,0.30025774,0.62666667,0.30025774,0.63,0.30025774,0.6333333,0.30025774,0.63666666,0.30025774,0.64,0.30025774,0.6433333,0.30025774,0.64666665,0.30025774,0.65,0.30025774,0.6533333,0.30025774,0.6566667,0.30025774,0.66,0.30025774,0.66333336,0.30025774,0.6666667,0.30025774,0.72333336,0.30025774,0.7266667,0.30025774,0.73,0.30025774,0.73333335,0.30025774,0.7366667,0.30025774,0.74,0.30025774,0.74333334,0.30025774,0.74666667,0.30025774,0.75,0.30025774,0.75333333,0.30025774,0.75666666,0.30025774,0.76,0.30025774,0.7633333,0.30025774,0.76666665,0.30025774,0.77,0.30025774,0.7733333,0.30025774,0.77666664,0.30025774,0.78,0.30025774,0.78333336,0.30025774,0.7866667,0.30025774,0.79,0.30025774,0.79333335,0.30025774,0.7966667,0.30025774,0.8,0.30025774,0.80333334,0.30025774,0.8066667,0.30025774,0.81,0.30025774,0.81333333,0.30025774,0.81666666,0.30025774,0.82,0.30025774,0.8233333,0.30025774,0.82666665,0.30025774,0.83,0.30025774,0.8333333,0.30025774,0.83666664,0.30025774,0.84,0.30025774,0.8433333,0.30025774,0.8466667,0.30025774,0.85,0.30025774,0.85333335,0.30025774,0.8566667,0.30025774,0.86333334,0.30025774,0.8666667,0.30025774,0.8833333,0.30025774,0.8933333,0.30025774,0.89666665,0.30025774,0.9,0.30025774,0.9033333,0.30025774,0.9066667,0.30025774,0.91,0.30025774,0.91333336,0.30025774,0.9166667,0.30025774,0.92,0.30025774,0.92333335,0.30025774,0.9266667,0.30025774,0.93,0.30025774,0.93333334,0.30025774,0.93666667,0.30025774,0.94,0.30025774,0.9433333,0.30025774,0.94666666,0.30025774,0.05,0.30283505,0.053333335,0.30283505,0.05666667,0.30283505,0.06,0.30283505,0.06333333,0.30283505,0.06666667,0.30283505,0.07,0.30283505,0.07333333,0.30283505,0.07666667,0.30283505,0.08,0.30283505,0.083333336,0.30283505,0.086666666,0.30283505,0.09,0.30283505,0.093333334,0.30283505,0.096666664,0.30283505,0.1,0.30283505,0.10333333,0.30283505,0.10666667,0.30283505,0.11,0.30283505,0.11333334,0.30283505,0.11666667,0.30283505,0.12,0.30283505,0.123333335,0.30283505,0.12666667,0.30283505,0.13,0.30283505,0.13333334,0.30283505,0.13666667,0.30283505,0.14,0.30283505,0.14333333,0.30283505,0.14666666,0.30283505,0.15,0.30283505,0.15333334,0.30283505,0.15666667,0.30283505,0.16,0.30283505,0.16333333,0.30283505,0.16666667,0.30283505,0.17,0.30283505,0.17333333,0.30283505,0.17666666,0.30283505,0.18,0.30283505,0.18333334,0.30283505,0.18666667,0.30283505,0.19,0.30283505,0.19333333,0.30283505,0.19666667,0.30283505,0.2,0.30283505,0.20333333,0.30283505,0.20666666,0.30283505,0.21,0.30283505,0.21333334,0.30283505,0.21666667,0.30283505,0.22,0.30283505,0.22333333,0.30283505,0.22666667,0.30283505,0.23,0.30283505,0.23333333,0.30283505,0.23666666,0.30283505,0.24,0.30283505,0.24333334,0.30283505,0.24666667,0.30283505,0.25,0.30283505,0.25333333,0.30283505,0.25666666,0.30283505,0.26,0.30283505,0.26333332,0.30283505,0.26666668,0.30283505,0.27,0.30283505,0.27333334,0.30283505,0.27666667,0.30283505,0.28,0.30283505,0.28333333,0.30283505,0.28666666,0.30283505,0.29,0.30283505,0.29333332,0.30283505,0.29666665,0.30283505,0.3,0.30283505,0.30333334,0.30283505,0.30666667,0.30283505,0.31,0.30283505,0.31333333,0.30283505,0.31666666,0.30283505,0.32,0.30283505,0.32333332,0.30283505,0.34333333,0.30283505,0.34666666,0.30283505,0.35,0.30283505,0.35333332,0.30283505,0.35666665,0.30283505,0.36,0.30283505,0.36333334,0.30283505,0.37,0.30283505,0.37333333,0.30283505,0.37666667,0.30283505,0.38,0.30283505,0.38333333,0.30283505,0.38666666,0.30283505,0.39,0.30283505,0.39333335,0.30283505,0.39666668,0.30283505,0.4,0.30283505,0.40333334,0.30283505,0.40666667,0.30283505,0.41,0.30283505,0.41333333,0.30283505,0.41666666,0.30283505,0.42,0.30283505,0.42333335,0.30283505,0.42666668,0.30283505,0.43,0.30283505,0.43333334,0.30283505,0.43666667,0.30283505,0.44,0.30283505,0.44666666,0.30283505,0.45,0.30283505,0.45333335,0.30283505,0.45666668,0.30283505,0.46,0.30283505,0.46333334,0.30283505,0.46666667,0.30283505,0.47,0.30283505,0.47333333,0.30283505,0.47666666,0.30283505,0.48,0.30283505,0.48333332,0.30283505,0.48666668,0.30283505,0.49,0.30283505,0.49333334,0.30283505,0.49666667,0.30283505,0.5,0.30283505,0.50333333,0.30283505,0.50666666,0.30283505,0.51,0.30283505,0.5133333,0.30283505,0.51666665,0.30283505,0.52,0.30283505,0.5233333,0.30283505,0.52666664,0.30283505,0.53,0.30283505,0.53333336,0.30283505,0.5366667,0.30283505,0.54,0.30283505,0.54333335,0.30283505,0.5466667,0.30283505,0.55,0.30283505,0.55333334,0.30283505,0.5566667,0.30283505,0.56,0.30283505,0.56333333,0.30283505,0.56666666,0.30283505,0.57,0.30283505,0.5733333,0.30283505,0.58,0.30283505,0.61333334,0.30283505,0.6166667,0.30283505,0.62,0.30283505,0.62333333,0.30283505,0.62666667,0.30283505,0.63,0.30283505,0.6333333,0.30283505,0.63666666,0.30283505,0.64,0.30283505,0.6433333,0.30283505,0.64666665,0.30283505,0.65,0.30283505,0.6533333,0.30283505,0.6566667,0.30283505,0.66,0.30283505,0.66333336,0.30283505,0.6666667,0.30283505,0.69,0.30283505,0.70666665,0.30283505,0.7266667,0.30283505,0.73,0.30283505,0.73333335,0.30283505,0.7366667,0.30283505,0.74,0.30283505,0.74333334,0.30283505,0.74666667,0.30283505,0.75,0.30283505,0.75333333,0.30283505,0.75666666,0.30283505,0.76,0.30283505,0.7633333,0.30283505,0.76666665,0.30283505,0.77,0.30283505,0.7733333,0.30283505,0.77666664,0.30283505,0.78,0.30283505,0.78333336,0.30283505,0.7866667,0.30283505,0.79,0.30283505,0.79333335,0.30283505,0.7966667,0.30283505,0.8,0.30283505,0.80333334,0.30283505,0.8066667,0.30283505,0.81,0.30283505,0.81333333,0.30283505,0.81666666,0.30283505,0.82,0.30283505,0.8233333,0.30283505,0.82666665,0.30283505,0.83,0.30283505,0.8333333,0.30283505,0.83666664,0.30283505,0.84,0.30283505,0.8433333,0.30283505,0.8466667,0.30283505,0.85,0.30283505,0.85333335,0.30283505,0.8566667,0.30283505,0.86333334,0.30283505,0.8666667,0.30283505,0.88666666,0.30283505,0.89,0.30283505,0.8933333,0.30283505,0.89666665,0.30283505,0.9,0.30283505,0.9033333,0.30283505,0.9066667,0.30283505,0.91,0.30283505,0.91333336,0.30283505,0.9166667,0.30283505,0.92,0.30283505,0.92333335,0.30283505,0.9266667,0.30283505,0.93,0.30283505,0.93333334,0.30283505,0.93666667,0.30283505,0.94,0.30283505,0.9433333,0.30283505,0.94666666,0.30283505,0.05,0.30541238,0.053333335,0.30541238,0.05666667,0.30541238,0.06,0.30541238,0.06333333,0.30541238,0.06666667,0.30541238,0.07,0.30541238,0.07333333,0.30541238,0.07666667,0.30541238,0.08,0.30541238,0.083333336,0.30541238,0.086666666,0.30541238,0.09,0.30541238,0.093333334,0.30541238,0.096666664,0.30541238,0.1,0.30541238,0.10333333,0.30541238,0.10666667,0.30541238,0.11,0.30541238,0.11333334,0.30541238,0.11666667,0.30541238,0.12,0.30541238,0.123333335,0.30541238,0.12666667,0.30541238,0.13,0.30541238,0.13333334,0.30541238,0.13666667,0.30541238,0.14,0.30541238,0.14333333,0.30541238,0.14666666,0.30541238,0.15,0.30541238,0.15333334,0.30541238,0.15666667,0.30541238,0.16,0.30541238,0.16333333,0.30541238,0.16666667,0.30541238,0.17,0.30541238,0.17333333,0.30541238,0.17666666,0.30541238,0.18,0.30541238,0.18333334,0.30541238,0.18666667,0.30541238,0.19,0.30541238,0.19333333,0.30541238,0.19666667,0.30541238,0.2,0.30541238,0.20333333,0.30541238,0.20666666,0.30541238,0.21,0.30541238,0.21333334,0.30541238,0.21666667,0.30541238,0.22,0.30541238,0.22333333,0.30541238,0.22666667,0.30541238,0.23,0.30541238,0.23333333,0.30541238,0.23666666,0.30541238,0.24,0.30541238,0.24333334,0.30541238,0.24666667,0.30541238,0.25,0.30541238,0.25333333,0.30541238,0.25666666,0.30541238,0.26,0.30541238,0.26333332,0.30541238,0.26666668,0.30541238,0.27,0.30541238,0.27333334,0.30541238,0.27666667,0.30541238,0.28,0.30541238,0.28333333,0.30541238,0.28666666,0.30541238,0.29,0.30541238,0.29333332,0.30541238,0.29666665,0.30541238,0.3,0.30541238,0.30333334,0.30541238,0.30666667,0.30541238,0.31,0.30541238,0.31333333,0.30541238,0.31666666,0.30541238,0.32,0.30541238,0.32333332,0.30541238,0.32666665,0.30541238,0.33,0.30541238,0.33333334,0.30541238,0.33666667,0.30541238,0.34,0.30541238,0.34666666,0.30541238,0.35,0.30541238,0.35333332,0.30541238,0.35666665,0.30541238,0.36,0.30541238,0.36333334,0.30541238,0.36666667,0.30541238,0.37,0.30541238,0.37333333,0.30541238,0.37666667,0.30541238,0.38,0.30541238,0.38333333,0.30541238,0.38666666,0.30541238,0.39,0.30541238,0.39333335,0.30541238,0.39666668,0.30541238,0.4,0.30541238,0.40333334,0.30541238,0.40666667,0.30541238,0.41,0.30541238,0.41333333,0.30541238,0.41666666,0.30541238,0.42,0.30541238,0.42333335,0.30541238,0.42666668,0.30541238,0.43,0.30541238,0.43333334,0.30541238,0.43666667,0.30541238,0.44,0.30541238,0.44333333,0.30541238,0.44666666,0.30541238,0.45,0.30541238,0.45333335,0.30541238,0.45666668,0.30541238,0.46,0.30541238,0.46333334,0.30541238,0.46666667,0.30541238,0.47,0.30541238,0.47333333,0.30541238,0.47666666,0.30541238,0.48,0.30541238,0.48333332,0.30541238,0.48666668,0.30541238,0.49,0.30541238,0.49333334,0.30541238,0.49666667,0.30541238,0.5,0.30541238,0.50333333,0.30541238,0.50666666,0.30541238,0.51,0.30541238,0.5133333,0.30541238,0.51666665,0.30541238,0.52,0.30541238,0.5233333,0.30541238,0.52666664,0.30541238,0.53,0.30541238,0.53333336,0.30541238,0.5366667,0.30541238,0.54,0.30541238,0.54333335,0.30541238,0.5466667,0.30541238,0.55,0.30541238,0.55333334,0.30541238,0.5566667,0.30541238,0.56,0.30541238,0.56333333,0.30541238,0.56666666,0.30541238,0.57,0.30541238,0.61,0.30541238,0.61333334,0.30541238,0.6166667,0.30541238,0.62,0.30541238,0.62333333,0.30541238,0.62666667,0.30541238,0.63,0.30541238,0.6333333,0.30541238,0.63666666,0.30541238,0.64,0.30541238,0.6433333,0.30541238,0.64666665,0.30541238,0.65,0.30541238,0.6533333,0.30541238,0.6566667,0.30541238,0.66,0.30541238,0.66333336,0.30541238,0.6666667,0.30541238,0.70666665,0.30541238,0.7266667,0.30541238,0.73,0.30541238,0.73333335,0.30541238,0.7366667,0.30541238,0.74,0.30541238,0.74333334,0.30541238,0.74666667,0.30541238,0.75,0.30541238,0.75333333,0.30541238,0.75666666,0.30541238,0.76,0.30541238,0.7633333,0.30541238,0.76666665,0.30541238,0.77,0.30541238,0.7733333,0.30541238,0.77666664,0.30541238,0.78,0.30541238,0.78333336,0.30541238,0.7866667,0.30541238,0.79,0.30541238,0.79333335,0.30541238,0.7966667,0.30541238,0.8,0.30541238,0.80333334,0.30541238,0.8066667,0.30541238,0.81,0.30541238,0.81333333,0.30541238,0.81666666,0.30541238,0.82,0.30541238,0.8233333,0.30541238,0.82666665,0.30541238,0.83,0.30541238,0.8333333,0.30541238,0.83666664,0.30541238,0.84,0.30541238,0.8433333,0.30541238,0.8466667,0.30541238,0.85,0.30541238,0.85333335,0.30541238,0.8566667,0.30541238,0.86,0.30541238,0.86333334,0.30541238,0.8666667,0.30541238,0.87,0.30541238,0.8833333,0.30541238,0.88666666,0.30541238,0.89,0.30541238,0.8933333,0.30541238,0.89666665,0.30541238,0.9,0.30541238,0.9033333,0.30541238,0.9066667,0.30541238,0.91,0.30541238,0.91333336,0.30541238,0.9166667,0.30541238,0.92,0.30541238,0.92333335,0.30541238,0.9266667,0.30541238,0.93,0.30541238,0.93333334,0.30541238,0.93666667,0.30541238,0.94,0.30541238,0.9433333,0.30541238,0.94666666,0.30541238,0.05,0.3079897,0.053333335,0.3079897,0.05666667,0.3079897,0.06,0.3079897,0.06333333,0.3079897,0.06666667,0.3079897,0.07,0.3079897,0.07333333,0.3079897,0.07666667,0.3079897,0.08,0.3079897,0.083333336,0.3079897,0.086666666,0.3079897,0.09,0.3079897,0.093333334,0.3079897,0.096666664,0.3079897,0.1,0.3079897,0.10333333,0.3079897,0.10666667,0.3079897,0.11,0.3079897,0.11333334,0.3079897,0.11666667,0.3079897,0.12,0.3079897,0.123333335,0.3079897,0.12666667,0.3079897,0.13,0.3079897,0.13333334,0.3079897,0.13666667,0.3079897,0.14,0.3079897,0.14333333,0.3079897,0.14666666,0.3079897,0.15,0.3079897,0.15333334,0.3079897,0.15666667,0.3079897,0.16,0.3079897,0.16333333,0.3079897,0.16666667,0.3079897,0.17,0.3079897,0.17333333,0.3079897,0.17666666,0.3079897,0.18,0.3079897,0.18333334,0.3079897,0.18666667,0.3079897,0.19,0.3079897,0.19333333,0.3079897,0.19666667,0.3079897,0.2,0.3079897,0.20333333,0.3079897,0.20666666,0.3079897,0.21,0.3079897,0.21333334,0.3079897,0.21666667,0.3079897,0.22,0.3079897,0.22333333,0.3079897,0.22666667,0.3079897,0.23,0.3079897,0.23333333,0.3079897,0.23666666,0.3079897,0.24,0.3079897,0.24333334,0.3079897,0.24666667,0.3079897,0.25,0.3079897,0.25333333,0.3079897,0.25666666,0.3079897,0.26,0.3079897,0.26333332,0.3079897,0.26666668,0.3079897,0.27,0.3079897,0.27333334,0.3079897,0.27666667,0.3079897,0.28,0.3079897,0.28333333,0.3079897,0.28666666,0.3079897,0.29,0.3079897,0.29333332,0.3079897,0.29666665,0.3079897,0.3,0.3079897,0.30333334,0.3079897,0.30666667,0.3079897,0.31,0.3079897,0.31333333,0.3079897,0.31666666,0.3079897,0.32333332,0.3079897,0.32666665,0.3079897,0.33,0.3079897,0.33333334,0.3079897,0.33666667,0.3079897,0.34333333,0.3079897,0.34666666,0.3079897,0.35,0.3079897,0.35333332,0.3079897,0.35666665,0.3079897,0.36,0.3079897,0.36333334,0.3079897,0.36666667,0.3079897,0.37,0.3079897,0.37333333,0.3079897,0.37666667,0.3079897,0.38,0.3079897,0.38666666,0.3079897,0.39,0.3079897,0.39333335,0.3079897,0.39666668,0.3079897,0.4,0.3079897,0.40333334,0.3079897,0.40666667,0.3079897,0.41,0.3079897,0.41333333,0.3079897,0.41666666,0.3079897,0.42,0.3079897,0.42333335,0.3079897,0.42666668,0.3079897,0.43,0.3079897,0.43333334,0.3079897,0.43666667,0.3079897,0.44,0.3079897,0.44333333,0.3079897,0.44666666,0.3079897,0.45,0.3079897,0.45333335,0.3079897,0.45666668,0.3079897,0.46,0.3079897,0.46333334,0.3079897,0.46666667,0.3079897,0.47,0.3079897,0.47333333,0.3079897,0.47666666,0.3079897,0.48,0.3079897,0.48333332,0.3079897,0.48666668,0.3079897,0.49,0.3079897,0.49333334,0.3079897,0.49666667,0.3079897,0.5,0.3079897,0.50333333,0.3079897,0.50666666,0.3079897,0.51,0.3079897,0.5133333,0.3079897,0.51666665,0.3079897,0.52,0.3079897,0.5233333,0.3079897,0.52666664,0.3079897,0.53,0.3079897,0.53333336,0.3079897,0.5366667,0.3079897,0.54,0.3079897,0.54333335,0.3079897,0.5466667,0.3079897,0.55333334,0.3079897,0.5566667,0.3079897,0.56,0.3079897,0.56333333,0.3079897,0.56666666,0.3079897,0.61333334,0.3079897,0.6166667,0.3079897,0.62,0.3079897,0.62333333,0.3079897,0.62666667,0.3079897,0.63,0.3079897,0.6333333,0.3079897,0.63666666,0.3079897,0.64,0.3079897,0.6433333,0.3079897,0.64666665,0.3079897,0.65,0.3079897,0.6533333,0.3079897,0.6566667,0.3079897,0.66,0.3079897,0.66333336,0.3079897,0.6666667,0.3079897,0.69,0.3079897,0.73,0.3079897,0.73333335,0.3079897,0.7366667,0.3079897,0.74,0.3079897,0.74333334,0.3079897,0.74666667,0.3079897,0.75,0.3079897,0.75333333,0.3079897,0.75666666,0.3079897,0.76,0.3079897,0.7633333,0.3079897,0.76666665,0.3079897,0.77,0.3079897,0.7733333,0.3079897,0.77666664,0.3079897,0.78,0.3079897,0.78333336,0.3079897,0.7866667,0.3079897,0.79,0.3079897,0.79333335,0.3079897,0.7966667,0.3079897,0.8,0.3079897,0.80333334,0.3079897,0.8066667,0.3079897,0.81,0.3079897,0.81333333,0.3079897,0.81666666,0.3079897,0.82,0.3079897,0.8233333,0.3079897,0.82666665,0.3079897,0.83,0.3079897,0.8333333,0.3079897,0.83666664,0.3079897,0.84,0.3079897,0.8433333,0.3079897,0.8466667,0.3079897,0.85,0.3079897,0.85333335,0.3079897,0.8566667,0.3079897,0.86,0.3079897,0.86333334,0.3079897,0.8666667,0.3079897,0.87,0.3079897,0.87333333,0.3079897,0.88,0.3079897,0.8833333,0.3079897,0.88666666,0.3079897,0.89,0.3079897,0.8933333,0.3079897,0.9,0.3079897,0.9033333,0.3079897,0.9066667,0.3079897,0.91,0.3079897,0.91333336,0.3079897,0.9166667,0.3079897,0.92,0.3079897,0.92333335,0.3079897,0.9266667,0.3079897,0.93,0.3079897,0.93333334,0.3079897,0.93666667,0.3079897,0.94,0.3079897,0.9433333,0.3079897,0.94666666,0.3079897,0.05,0.31056702,0.053333335,0.31056702,0.05666667,0.31056702,0.06,0.31056702,0.06333333,0.31056702,0.06666667,0.31056702,0.07,0.31056702,0.07333333,0.31056702,0.07666667,0.31056702,0.08,0.31056702,0.083333336,0.31056702,0.086666666,0.31056702,0.09,0.31056702,0.093333334,0.31056702,0.096666664,0.31056702,0.1,0.31056702,0.10333333,0.31056702,0.10666667,0.31056702,0.11,0.31056702,0.11333334,0.31056702,0.11666667,0.31056702,0.12,0.31056702,0.123333335,0.31056702,0.12666667,0.31056702,0.13,0.31056702,0.13333334,0.31056702,0.13666667,0.31056702,0.14,0.31056702,0.14333333,0.31056702,0.14666666,0.31056702,0.15,0.31056702,0.15333334,0.31056702,0.15666667,0.31056702,0.16,0.31056702,0.16333333,0.31056702,0.16666667,0.31056702,0.17,0.31056702,0.17333333,0.31056702,0.17666666,0.31056702,0.18,0.31056702,0.18333334,0.31056702,0.18666667,0.31056702,0.19,0.31056702,0.19333333,0.31056702,0.19666667,0.31056702,0.2,0.31056702,0.20333333,0.31056702,0.20666666,0.31056702,0.21,0.31056702,0.21333334,0.31056702,0.21666667,0.31056702,0.22,0.31056702,0.22333333,0.31056702,0.22666667,0.31056702,0.23,0.31056702,0.23333333,0.31056702,0.23666666,0.31056702,0.24,0.31056702,0.24333334,0.31056702,0.24666667,0.31056702,0.25,0.31056702,0.25333333,0.31056702,0.25666666,0.31056702,0.26,0.31056702,0.26333332,0.31056702,0.26666668,0.31056702,0.27,0.31056702,0.27333334,0.31056702,0.27666667,0.31056702,0.28,0.31056702,0.28333333,0.31056702,0.28666666,0.31056702,0.29,0.31056702,0.29333332,0.31056702,0.29666665,0.31056702,0.3,0.31056702,0.30333334,0.31056702,0.30666667,0.31056702,0.31,0.31056702,0.31333333,0.31056702,0.31666666,0.31056702,0.32,0.31056702,0.32333332,0.31056702,0.32666665,0.31056702,0.33,0.31056702,0.33333334,0.31056702,0.33666667,0.31056702,0.34,0.31056702,0.34333333,0.31056702,0.34666666,0.31056702,0.35,0.31056702,0.35333332,0.31056702,0.35666665,0.31056702,0.36,0.31056702,0.36333334,0.31056702,0.36666667,0.31056702,0.37,0.31056702,0.37333333,0.31056702,0.37666667,0.31056702,0.38,0.31056702,0.38333333,0.31056702,0.38666666,0.31056702,0.39,0.31056702,0.39333335,0.31056702,0.39666668,0.31056702,0.4,0.31056702,0.40333334,0.31056702,0.40666667,0.31056702,0.41,0.31056702,0.41333333,0.31056702,0.41666666,0.31056702,0.42,0.31056702,0.42333335,0.31056702,0.42666668,0.31056702,0.43,0.31056702,0.43333334,0.31056702,0.43666667,0.31056702,0.44,0.31056702,0.44333333,0.31056702,0.44666666,0.31056702,0.45,0.31056702,0.45333335,0.31056702,0.45666668,0.31056702,0.46,0.31056702,0.46333334,0.31056702,0.46666667,0.31056702,0.47,0.31056702,0.47333333,0.31056702,0.47666666,0.31056702,0.48,0.31056702,0.48333332,0.31056702,0.48666668,0.31056702,0.49,0.31056702,0.49333334,0.31056702,0.49666667,0.31056702,0.5,0.31056702,0.50333333,0.31056702,0.50666666,0.31056702,0.51,0.31056702,0.5133333,0.31056702,0.51666665,0.31056702,0.52,0.31056702,0.5233333,0.31056702,0.52666664,0.31056702,0.53,0.31056702,0.53333336,0.31056702,0.5366667,0.31056702,0.54,0.31056702,0.54333335,0.31056702,0.5466667,0.31056702,0.55,0.31056702,0.55333334,0.31056702,0.5566667,0.31056702,0.56,0.31056702,0.56333333,0.31056702,0.61333334,0.31056702,0.6166667,0.31056702,0.62,0.31056702,0.62333333,0.31056702,0.62666667,0.31056702,0.63,0.31056702,0.6333333,0.31056702,0.63666666,0.31056702,0.64,0.31056702,0.6433333,0.31056702,0.64666665,0.31056702,0.65,0.31056702,0.6533333,0.31056702,0.6566667,0.31056702,0.66,0.31056702,0.66333336,0.31056702,0.6666667,0.31056702,0.7366667,0.31056702,0.74,0.31056702,0.74333334,0.31056702,0.74666667,0.31056702,0.75,0.31056702,0.75333333,0.31056702,0.75666666,0.31056702,0.76,0.31056702,0.7633333,0.31056702,0.76666665,0.31056702,0.77,0.31056702,0.7733333,0.31056702,0.77666664,0.31056702,0.78,0.31056702,0.78333336,0.31056702,0.7866667,0.31056702,0.79,0.31056702,0.79333335,0.31056702,0.7966667,0.31056702,0.8,0.31056702,0.80333334,0.31056702,0.8066667,0.31056702,0.81,0.31056702,0.81333333,0.31056702,0.81666666,0.31056702,0.82,0.31056702,0.8233333,0.31056702,0.82666665,0.31056702,0.83,0.31056702,0.8333333,0.31056702,0.83666664,0.31056702,0.84,0.31056702,0.8433333,0.31056702,0.8466667,0.31056702,0.85,0.31056702,0.85333335,0.31056702,0.8566667,0.31056702,0.86,0.31056702,0.86333334,0.31056702,0.8666667,0.31056702,0.87,0.31056702,0.87333333,0.31056702,0.87666667,0.31056702,0.88,0.31056702,0.88666666,0.31056702,0.89,0.31056702,0.9,0.31056702,0.9033333,0.31056702,0.9066667,0.31056702,0.91,0.31056702,0.91333336,0.31056702,0.9166667,0.31056702,0.92,0.31056702,0.92333335,0.31056702,0.9266667,0.31056702,0.93,0.31056702,0.93333334,0.31056702,0.93666667,0.31056702,0.94,0.31056702,0.9433333,0.31056702,0.94666666,0.31056702,0.05,0.31314433,0.053333335,0.31314433,0.05666667,0.31314433,0.06,0.31314433,0.06333333,0.31314433,0.06666667,0.31314433,0.07,0.31314433,0.07333333,0.31314433,0.07666667,0.31314433,0.08,0.31314433,0.083333336,0.31314433,0.086666666,0.31314433,0.09,0.31314433,0.093333334,0.31314433,0.096666664,0.31314433,0.1,0.31314433,0.10333333,0.31314433,0.10666667,0.31314433,0.11,0.31314433,0.11333334,0.31314433,0.11666667,0.31314433,0.12,0.31314433,0.123333335,0.31314433,0.12666667,0.31314433,0.13,0.31314433,0.13333334,0.31314433,0.13666667,0.31314433,0.14,0.31314433,0.14333333,0.31314433,0.14666666,0.31314433,0.15,0.31314433,0.15333334,0.31314433,0.15666667,0.31314433,0.16,0.31314433,0.16333333,0.31314433,0.16666667,0.31314433,0.17,0.31314433,0.17333333,0.31314433,0.17666666,0.31314433,0.18,0.31314433,0.18333334,0.31314433,0.18666667,0.31314433,0.19,0.31314433,0.19333333,0.31314433,0.19666667,0.31314433,0.2,0.31314433,0.20333333,0.31314433,0.20666666,0.31314433,0.21,0.31314433,0.21333334,0.31314433,0.21666667,0.31314433,0.22,0.31314433,0.22333333,0.31314433,0.22666667,0.31314433,0.23,0.31314433,0.23333333,0.31314433,0.23666666,0.31314433,0.24,0.31314433,0.24333334,0.31314433,0.24666667,0.31314433,0.25,0.31314433,0.25333333,0.31314433,0.25666666,0.31314433,0.26,0.31314433,0.26333332,0.31314433,0.26666668,0.31314433,0.27,0.31314433,0.27333334,0.31314433,0.27666667,0.31314433,0.28,0.31314433,0.28333333,0.31314433,0.28666666,0.31314433,0.29,0.31314433,0.29333332,0.31314433,0.29666665,0.31314433,0.3,0.31314433,0.30333334,0.31314433,0.30666667,0.31314433,0.31,0.31314433,0.31333333,0.31314433,0.31666666,0.31314433,0.32,0.31314433,0.32333332,0.31314433,0.32666665,0.31314433,0.33,0.31314433,0.33333334,0.31314433,0.33666667,0.31314433,0.34,0.31314433,0.34333333,0.31314433,0.34666666,0.31314433,0.35,0.31314433,0.35333332,0.31314433,0.35666665,0.31314433,0.36,0.31314433,0.36333334,0.31314433,0.36666667,0.31314433,0.37,0.31314433,0.37333333,0.31314433,0.37666667,0.31314433,0.38,0.31314433,0.38333333,0.31314433,0.38666666,0.31314433,0.39,0.31314433,0.39333335,0.31314433,0.39666668,0.31314433,0.4,0.31314433,0.40333334,0.31314433,0.40666667,0.31314433,0.41,0.31314433,0.41333333,0.31314433,0.41666666,0.31314433,0.42,0.31314433,0.42333335,0.31314433,0.42666668,0.31314433,0.43,0.31314433,0.43333334,0.31314433,0.43666667,0.31314433,0.44,0.31314433,0.44666666,0.31314433,0.45,0.31314433,0.45333335,0.31314433,0.45666668,0.31314433,0.46,0.31314433,0.46333334,0.31314433,0.46666667,0.31314433,0.47,0.31314433,0.47333333,0.31314433,0.47666666,0.31314433,0.48,0.31314433,0.48333332,0.31314433,0.48666668,0.31314433,0.49,0.31314433,0.49333334,0.31314433,0.49666667,0.31314433,0.5,0.31314433,0.50333333,0.31314433,0.50666666,0.31314433,0.51,0.31314433,0.5133333,0.31314433,0.51666665,0.31314433,0.52,0.31314433,0.5233333,0.31314433,0.52666664,0.31314433,0.53,0.31314433,0.53333336,0.31314433,0.5366667,0.31314433,0.54,0.31314433,0.5466667,0.31314433,0.55,0.31314433,0.55333334,0.31314433,0.5566667,0.31314433,0.56,0.31314433,0.56333333,0.31314433,0.61333334,0.31314433,0.6166667,0.31314433,0.62,0.31314433,0.62333333,0.31314433,0.62666667,0.31314433,0.63,0.31314433,0.6333333,0.31314433,0.63666666,0.31314433,0.64,0.31314433,0.6433333,0.31314433,0.64666665,0.31314433,0.65,0.31314433,0.6533333,0.31314433,0.6566667,0.31314433,0.66,0.31314433,0.66333336,0.31314433,0.6666667,0.31314433,0.69,0.31314433,0.74,0.31314433,0.74333334,0.31314433,0.74666667,0.31314433,0.75,0.31314433,0.75333333,0.31314433,0.75666666,0.31314433,0.76,0.31314433,0.7633333,0.31314433,0.76666665,0.31314433,0.77,0.31314433,0.7733333,0.31314433,0.77666664,0.31314433,0.78,0.31314433,0.78333336,0.31314433,0.7866667,0.31314433,0.79,0.31314433,0.79333335,0.31314433,0.7966667,0.31314433,0.8,0.31314433,0.80333334,0.31314433,0.8066667,0.31314433,0.81,0.31314433,0.81333333,0.31314433,0.81666666,0.31314433,0.82,0.31314433,0.8233333,0.31314433,0.82666665,0.31314433,0.83,0.31314433,0.8333333,0.31314433,0.83666664,0.31314433,0.84,0.31314433,0.8433333,0.31314433,0.8466667,0.31314433,0.85,0.31314433,0.85333335,0.31314433,0.8566667,0.31314433,0.86,0.31314433,0.86333334,0.31314433,0.8666667,0.31314433,0.87,0.31314433,0.87333333,0.31314433,0.87666667,0.31314433,0.88,0.31314433,0.88666666,0.31314433,0.8933333,0.31314433,0.89666665,0.31314433,0.9,0.31314433,0.9033333,0.31314433,0.91,0.31314433,0.91333336,0.31314433,0.9166667,0.31314433,0.92,0.31314433,0.92333335,0.31314433,0.9266667,0.31314433,0.93,0.31314433,0.93333334,0.31314433,0.93666667,0.31314433,0.94,0.31314433,0.9433333,0.31314433,0.94666666,0.31314433,0.05,0.31572166,0.053333335,0.31572166,0.05666667,0.31572166,0.06,0.31572166,0.06333333,0.31572166,0.06666667,0.31572166,0.07,0.31572166,0.07333333,0.31572166,0.07666667,0.31572166,0.08,0.31572166,0.083333336,0.31572166,0.086666666,0.31572166,0.09,0.31572166,0.093333334,0.31572166,0.096666664,0.31572166,0.1,0.31572166,0.10333333,0.31572166,0.10666667,0.31572166,0.11,0.31572166,0.11333334,0.31572166,0.11666667,0.31572166,0.12,0.31572166,0.123333335,0.31572166,0.12666667,0.31572166,0.13,0.31572166,0.13333334,0.31572166,0.13666667,0.31572166,0.14,0.31572166,0.14333333,0.31572166,0.14666666,0.31572166,0.15,0.31572166,0.15333334,0.31572166,0.15666667,0.31572166,0.16,0.31572166,0.16333333,0.31572166,0.16666667,0.31572166,0.17,0.31572166,0.17333333,0.31572166,0.17666666,0.31572166,0.18,0.31572166,0.18333334,0.31572166,0.18666667,0.31572166,0.19,0.31572166,0.19333333,0.31572166,0.19666667,0.31572166,0.2,0.31572166,0.20333333,0.31572166,0.20666666,0.31572166,0.21,0.31572166,0.21333334,0.31572166,0.21666667,0.31572166,0.22,0.31572166,0.22333333,0.31572166,0.22666667,0.31572166,0.23,0.31572166,0.23333333,0.31572166,0.23666666,0.31572166,0.24,0.31572166,0.24333334,0.31572166,0.24666667,0.31572166,0.25,0.31572166,0.25333333,0.31572166,0.25666666,0.31572166,0.26,0.31572166,0.26333332,0.31572166,0.26666668,0.31572166,0.27,0.31572166,0.27333334,0.31572166,0.27666667,0.31572166,0.28,0.31572166,0.28333333,0.31572166,0.28666666,0.31572166,0.29,0.31572166,0.29333332,0.31572166,0.29666665,0.31572166,0.3,0.31572166,0.30333334,0.31572166,0.30666667,0.31572166,0.31,0.31572166,0.31333333,0.31572166,0.31666666,0.31572166,0.32,0.31572166,0.32333332,0.31572166,0.32666665,0.31572166,0.33333334,0.31572166,0.33666667,0.31572166,0.34,0.31572166,0.34333333,0.31572166,0.34666666,0.31572166,0.35,0.31572166,0.35333332,0.31572166,0.35666665,0.31572166,0.36,0.31572166,0.36333334,0.31572166,0.36666667,0.31572166,0.37,0.31572166,0.37333333,0.31572166,0.37666667,0.31572166,0.38,0.31572166,0.38333333,0.31572166,0.38666666,0.31572166,0.39,0.31572166,0.39333335,0.31572166,0.39666668,0.31572166,0.4,0.31572166,0.40333334,0.31572166,0.40666667,0.31572166,0.41,0.31572166,0.41333333,0.31572166,0.42,0.31572166,0.42333335,0.31572166,0.42666668,0.31572166,0.43,0.31572166,0.43333334,0.31572166,0.43666667,0.31572166,0.44,0.31572166,0.44333333,0.31572166,0.44666666,0.31572166,0.45,0.31572166,0.45333335,0.31572166,0.45666668,0.31572166,0.46,0.31572166,0.46333334,0.31572166,0.46666667,0.31572166,0.47,0.31572166,0.47333333,0.31572166,0.47666666,0.31572166,0.48,0.31572166,0.48333332,0.31572166,0.48666668,0.31572166,0.49,0.31572166,0.49333334,0.31572166,0.49666667,0.31572166,0.5,0.31572166,0.50333333,0.31572166,0.50666666,0.31572166,0.51,0.31572166,0.5133333,0.31572166,0.51666665,0.31572166,0.52,0.31572166,0.5233333,0.31572166,0.52666664,0.31572166,0.53,0.31572166,0.53333336,0.31572166,0.5366667,0.31572166,0.54,0.31572166,0.5466667,0.31572166,0.55,0.31572166,0.55333334,0.31572166,0.5566667,0.31572166,0.56,0.31572166,0.61333334,0.31572166,0.6166667,0.31572166,0.62,0.31572166,0.62333333,0.31572166,0.62666667,0.31572166,0.63,0.31572166,0.6333333,0.31572166,0.63666666,0.31572166,0.64,0.31572166,0.6433333,0.31572166,0.64666665,0.31572166,0.65,0.31572166,0.6533333,0.31572166,0.6566667,0.31572166,0.66,0.31572166,0.66333336,0.31572166,0.6666667,0.31572166,0.71,0.31572166,0.74333334,0.31572166,0.74666667,0.31572166,0.75,0.31572166,0.75333333,0.31572166,0.75666666,0.31572166,0.76,0.31572166,0.7633333,0.31572166,0.76666665,0.31572166,0.77,0.31572166,0.7733333,0.31572166,0.77666664,0.31572166,0.78,0.31572166,0.78333336,0.31572166,0.7866667,0.31572166,0.79,0.31572166,0.79333335,0.31572166,0.7966667,0.31572166,0.8,0.31572166,0.80333334,0.31572166,0.8066667,0.31572166,0.81,0.31572166,0.81333333,0.31572166,0.81666666,0.31572166,0.82,0.31572166,0.8233333,0.31572166,0.82666665,0.31572166,0.83,0.31572166,0.8333333,0.31572166,0.83666664,0.31572166,0.84,0.31572166,0.8433333,0.31572166,0.8466667,0.31572166,0.85,0.31572166,0.85333335,0.31572166,0.8566667,0.31572166,0.86,0.31572166,0.86333334,0.31572166,0.8666667,0.31572166,0.87,0.31572166,0.87333333,0.31572166,0.87666667,0.31572166,0.88,0.31572166,0.8833333,0.31572166,0.88666666,0.31572166,0.89,0.31572166,0.8933333,0.31572166,0.89666665,0.31572166,0.9,0.31572166,0.9033333,0.31572166,0.9066667,0.31572166,0.91,0.31572166,0.91333336,0.31572166,0.9166667,0.31572166,0.92,0.31572166,0.92333335,0.31572166,0.9266667,0.31572166,0.93,0.31572166,0.93333334,0.31572166,0.93666667,0.31572166,0.94,0.31572166,0.9433333,0.31572166,0.94666666,0.31572166,0.05,0.31829897,0.053333335,0.31829897,0.05666667,0.31829897,0.06,0.31829897,0.06333333,0.31829897,0.06666667,0.31829897,0.07,0.31829897,0.07333333,0.31829897,0.07666667,0.31829897,0.08,0.31829897,0.083333336,0.31829897,0.086666666,0.31829897,0.09,0.31829897,0.093333334,0.31829897,0.096666664,0.31829897,0.1,0.31829897,0.10333333,0.31829897,0.10666667,0.31829897,0.11,0.31829897,0.11333334,0.31829897,0.11666667,0.31829897,0.12,0.31829897,0.123333335,0.31829897,0.12666667,0.31829897,0.13,0.31829897,0.13333334,0.31829897,0.13666667,0.31829897,0.14,0.31829897,0.14333333,0.31829897,0.14666666,0.31829897,0.15,0.31829897,0.15333334,0.31829897,0.15666667,0.31829897,0.16,0.31829897,0.16333333,0.31829897,0.16666667,0.31829897,0.17,0.31829897,0.17333333,0.31829897,0.17666666,0.31829897,0.18,0.31829897,0.18333334,0.31829897,0.18666667,0.31829897,0.19,0.31829897,0.19333333,0.31829897,0.19666667,0.31829897,0.2,0.31829897,0.20333333,0.31829897,0.20666666,0.31829897,0.21,0.31829897,0.21333334,0.31829897,0.21666667,0.31829897,0.22,0.31829897,0.22333333,0.31829897,0.22666667,0.31829897,0.23,0.31829897,0.23333333,0.31829897,0.23666666,0.31829897,0.24,0.31829897,0.24333334,0.31829897,0.24666667,0.31829897,0.25,0.31829897,0.25333333,0.31829897,0.25666666,0.31829897,0.26,0.31829897,0.26333332,0.31829897,0.26666668,0.31829897,0.27,0.31829897,0.27333334,0.31829897,0.27666667,0.31829897,0.28,0.31829897,0.28333333,0.31829897,0.28666666,0.31829897,0.29,0.31829897,0.29333332,0.31829897,0.29666665,0.31829897,0.3,0.31829897,0.30333334,0.31829897,0.30666667,0.31829897,0.31,0.31829897,0.31333333,0.31829897,0.32,0.31829897,0.32333332,0.31829897,0.33,0.31829897,0.33333334,0.31829897,0.33666667,0.31829897,0.34,0.31829897,0.34333333,0.31829897,0.34666666,0.31829897,0.35,0.31829897,0.35333332,0.31829897,0.35666665,0.31829897,0.36,0.31829897,0.36333334,0.31829897,0.36666667,0.31829897,0.37,0.31829897,0.37333333,0.31829897,0.37666667,0.31829897,0.38,0.31829897,0.38333333,0.31829897,0.38666666,0.31829897,0.39,0.31829897,0.39333335,0.31829897,0.39666668,0.31829897,0.4,0.31829897,0.40333334,0.31829897,0.40666667,0.31829897,0.41,0.31829897,0.41333333,0.31829897,0.41666666,0.31829897,0.42,0.31829897,0.42333335,0.31829897,0.42666668,0.31829897,0.43,0.31829897,0.43333334,0.31829897,0.43666667,0.31829897,0.44,0.31829897,0.44333333,0.31829897,0.44666666,0.31829897,0.45,0.31829897,0.45333335,0.31829897,0.45666668,0.31829897,0.46,0.31829897,0.46333334,0.31829897,0.46666667,0.31829897,0.47,0.31829897,0.47333333,0.31829897,0.47666666,0.31829897,0.48,0.31829897,0.48333332,0.31829897,0.48666668,0.31829897,0.49,0.31829897,0.49333334,0.31829897,0.49666667,0.31829897,0.5,0.31829897,0.50333333,0.31829897,0.50666666,0.31829897,0.51,0.31829897,0.5133333,0.31829897,0.51666665,0.31829897,0.52,0.31829897,0.5233333,0.31829897,0.52666664,0.31829897,0.53,0.31829897,0.53333336,0.31829897,0.5366667,0.31829897,0.54,0.31829897,0.54333335,0.31829897,0.5466667,0.31829897,0.55,0.31829897,0.55333334,0.31829897,0.5566667,0.31829897,0.56333333,0.31829897,0.61333334,0.31829897,0.6166667,0.31829897,0.62,0.31829897,0.62333333,0.31829897,0.62666667,0.31829897,0.63,0.31829897,0.6333333,0.31829897,0.63666666,0.31829897,0.64,0.31829897,0.6433333,0.31829897,0.64666665,0.31829897,0.65,0.31829897,0.6533333,0.31829897,0.6566667,0.31829897,0.66,0.31829897,0.66333336,0.31829897,0.6666667,0.31829897,0.69,0.31829897,0.70666665,0.31829897,0.71,0.31829897,0.7133333,0.31829897,0.7266667,0.31829897,0.74666667,0.31829897,0.75,0.31829897,0.75333333,0.31829897,0.75666666,0.31829897,0.76,0.31829897,0.7633333,0.31829897,0.76666665,0.31829897,0.77,0.31829897,0.7733333,0.31829897,0.77666664,0.31829897,0.78,0.31829897,0.78333336,0.31829897,0.7866667,0.31829897,0.79,0.31829897,0.79333335,0.31829897,0.7966667,0.31829897,0.8,0.31829897,0.80333334,0.31829897,0.8066667,0.31829897,0.81,0.31829897,0.81333333,0.31829897,0.81666666,0.31829897,0.82,0.31829897,0.8233333,0.31829897,0.82666665,0.31829897,0.83,0.31829897,0.8333333,0.31829897,0.83666664,0.31829897,0.84,0.31829897,0.8433333,0.31829897,0.8466667,0.31829897,0.85,0.31829897,0.85333335,0.31829897,0.8566667,0.31829897,0.86,0.31829897,0.86333334,0.31829897,0.8666667,0.31829897,0.87,0.31829897,0.87333333,0.31829897,0.87666667,0.31829897,0.88,0.31829897,0.8833333,0.31829897,0.88666666,0.31829897,0.89,0.31829897,0.8933333,0.31829897,0.89666665,0.31829897,0.9,0.31829897,0.9033333,0.31829897,0.9066667,0.31829897,0.91,0.31829897,0.91333336,0.31829897,0.9166667,0.31829897,0.92,0.31829897,0.92333335,0.31829897,0.9266667,0.31829897,0.93,0.31829897,0.93333334,0.31829897,0.93666667,0.31829897,0.94,0.31829897,0.9433333,0.31829897,0.94666666,0.31829897,0.05,0.3208763,0.053333335,0.3208763,0.05666667,0.3208763,0.06,0.3208763,0.06333333,0.3208763,0.06666667,0.3208763,0.07,0.3208763,0.07333333,0.3208763,0.07666667,0.3208763,0.08,0.3208763,0.083333336,0.3208763,0.086666666,0.3208763,0.09,0.3208763,0.093333334,0.3208763,0.096666664,0.3208763,0.1,0.3208763,0.10333333,0.3208763,0.10666667,0.3208763,0.11,0.3208763,0.11333334,0.3208763,0.11666667,0.3208763,0.12,0.3208763,0.123333335,0.3208763,0.12666667,0.3208763,0.13,0.3208763,0.13333334,0.3208763,0.13666667,0.3208763,0.14,0.3208763,0.14333333,0.3208763,0.14666666,0.3208763,0.15,0.3208763,0.15333334,0.3208763,0.15666667,0.3208763,0.16,0.3208763,0.16333333,0.3208763,0.16666667,0.3208763,0.17,0.3208763,0.17333333,0.3208763,0.17666666,0.3208763,0.18,0.3208763,0.18333334,0.3208763,0.18666667,0.3208763,0.19,0.3208763,0.19333333,0.3208763,0.19666667,0.3208763,0.2,0.3208763,0.20333333,0.3208763,0.20666666,0.3208763,0.21,0.3208763,0.21333334,0.3208763,0.21666667,0.3208763,0.22,0.3208763,0.22333333,0.3208763,0.22666667,0.3208763,0.23,0.3208763,0.23333333,0.3208763,0.23666666,0.3208763,0.24,0.3208763,0.24333334,0.3208763,0.24666667,0.3208763,0.25,0.3208763,0.25333333,0.3208763,0.25666666,0.3208763,0.26,0.3208763,0.26333332,0.3208763,0.26666668,0.3208763,0.27,0.3208763,0.27333334,0.3208763,0.27666667,0.3208763,0.28,0.3208763,0.28333333,0.3208763,0.28666666,0.3208763,0.29,0.3208763,0.29333332,0.3208763,0.29666665,0.3208763,0.3,0.3208763,0.30333334,0.3208763,0.30666667,0.3208763,0.31,0.3208763,0.31333333,0.3208763,0.31666666,0.3208763,0.32666665,0.3208763,0.33,0.3208763,0.33333334,0.3208763,0.33666667,0.3208763,0.34,0.3208763,0.34333333,0.3208763,0.34666666,0.3208763,0.35,0.3208763,0.35333332,0.3208763,0.35666665,0.3208763,0.36,0.3208763,0.36333334,0.3208763,0.36666667,0.3208763,0.37,0.3208763,0.37333333,0.3208763,0.37666667,0.3208763,0.38,0.3208763,0.38333333,0.3208763,0.38666666,0.3208763,0.39,0.3208763,0.39333335,0.3208763,0.39666668,0.3208763,0.4,0.3208763,0.40333334,0.3208763,0.40666667,0.3208763,0.41,0.3208763,0.41333333,0.3208763,0.41666666,0.3208763,0.42,0.3208763,0.42333335,0.3208763,0.42666668,0.3208763,0.43,0.3208763,0.43333334,0.3208763,0.43666667,0.3208763,0.44,0.3208763,0.44333333,0.3208763,0.44666666,0.3208763,0.45,0.3208763,0.45333335,0.3208763,0.45666668,0.3208763,0.46,0.3208763,0.46333334,0.3208763,0.46666667,0.3208763,0.47,0.3208763,0.47333333,0.3208763,0.47666666,0.3208763,0.48,0.3208763,0.48333332,0.3208763,0.48666668,0.3208763,0.49,0.3208763,0.49333334,0.3208763,0.49666667,0.3208763,0.5,0.3208763,0.50333333,0.3208763,0.50666666,0.3208763,0.51,0.3208763,0.5133333,0.3208763,0.52,0.3208763,0.5233333,0.3208763,0.52666664,0.3208763,0.53,0.3208763,0.53333336,0.3208763,0.5366667,0.3208763,0.54,0.3208763,0.54333335,0.3208763,0.5466667,0.3208763,0.55,0.3208763,0.55333334,0.3208763,0.56666666,0.3208763,0.61333334,0.3208763,0.6166667,0.3208763,0.62,0.3208763,0.62333333,0.3208763,0.62666667,0.3208763,0.63,0.3208763,0.6333333,0.3208763,0.63666666,0.3208763,0.64,0.3208763,0.6433333,0.3208763,0.64666665,0.3208763,0.65,0.3208763,0.6533333,0.3208763,0.6566667,0.3208763,0.66,0.3208763,0.66333336,0.3208763,0.6666667,0.3208763,0.69,0.3208763,0.70666665,0.3208763,0.71,0.3208763,0.7133333,0.3208763,0.72,0.3208763,0.72333336,0.3208763,0.7266667,0.3208763,0.73,0.3208763,0.75,0.3208763,0.75333333,0.3208763,0.75666666,0.3208763,0.76,0.3208763,0.7633333,0.3208763,0.76666665,0.3208763,0.77,0.3208763,0.7733333,0.3208763,0.77666664,0.3208763,0.78,0.3208763,0.78333336,0.3208763,0.7866667,0.3208763,0.79,0.3208763,0.79333335,0.3208763,0.7966667,0.3208763,0.8,0.3208763,0.80333334,0.3208763,0.8066667,0.3208763,0.81,0.3208763,0.81333333,0.3208763,0.81666666,0.3208763,0.82,0.3208763,0.8233333,0.3208763,0.82666665,0.3208763,0.83,0.3208763,0.8333333,0.3208763,0.83666664,0.3208763,0.84,0.3208763,0.8433333,0.3208763,0.8466667,0.3208763,0.85,0.3208763,0.85333335,0.3208763,0.8566667,0.3208763,0.86,0.3208763,0.86333334,0.3208763,0.8666667,0.3208763,0.87,0.3208763,0.87333333,0.3208763,0.87666667,0.3208763,0.88,0.3208763,0.8833333,0.3208763,0.88666666,0.3208763,0.89,0.3208763,0.8933333,0.3208763,0.89666665,0.3208763,0.9,0.3208763,0.9033333,0.3208763,0.9066667,0.3208763,0.91,0.3208763,0.91333336,0.3208763,0.9166667,0.3208763,0.92,0.3208763,0.92333335,0.3208763,0.9266667,0.3208763,0.93,0.3208763,0.93333334,0.3208763,0.93666667,0.3208763,0.94,0.3208763,0.9433333,0.3208763,0.94666666,0.3208763,0.05,0.3234536,0.053333335,0.3234536,0.05666667,0.3234536,0.06,0.3234536,0.06333333,0.3234536,0.06666667,0.3234536,0.07,0.3234536,0.07333333,0.3234536,0.07666667,0.3234536,0.08,0.3234536,0.083333336,0.3234536,0.086666666,0.3234536,0.09,0.3234536,0.093333334,0.3234536,0.096666664,0.3234536,0.1,0.3234536,0.10333333,0.3234536,0.10666667,0.3234536,0.11,0.3234536,0.11333334,0.3234536,0.11666667,0.3234536,0.12,0.3234536,0.123333335,0.3234536,0.12666667,0.3234536,0.13,0.3234536,0.13333334,0.3234536,0.13666667,0.3234536,0.14,0.3234536,0.14333333,0.3234536,0.14666666,0.3234536,0.15,0.3234536,0.15333334,0.3234536,0.15666667,0.3234536,0.16,0.3234536,0.16333333,0.3234536,0.16666667,0.3234536,0.17,0.3234536,0.17333333,0.3234536,0.17666666,0.3234536,0.18,0.3234536,0.18333334,0.3234536,0.18666667,0.3234536,0.19,0.3234536,0.19333333,0.3234536,0.19666667,0.3234536,0.2,0.3234536,0.20333333,0.3234536,0.20666666,0.3234536,0.21,0.3234536,0.21333334,0.3234536,0.21666667,0.3234536,0.22,0.3234536,0.22333333,0.3234536,0.22666667,0.3234536,0.23,0.3234536,0.23333333,0.3234536,0.23666666,0.3234536,0.24,0.3234536,0.24333334,0.3234536,0.24666667,0.3234536,0.25,0.3234536,0.25333333,0.3234536,0.25666666,0.3234536,0.26,0.3234536,0.26333332,0.3234536,0.26666668,0.3234536,0.27,0.3234536,0.27333334,0.3234536,0.27666667,0.3234536,0.28,0.3234536,0.28333333,0.3234536,0.28666666,0.3234536,0.29,0.3234536,0.29333332,0.3234536,0.29666665,0.3234536,0.3,0.3234536,0.30333334,0.3234536,0.30666667,0.3234536,0.31,0.3234536,0.31333333,0.3234536,0.31666666,0.3234536,0.32,0.3234536,0.32333332,0.3234536,0.32666665,0.3234536,0.33,0.3234536,0.33333334,0.3234536,0.33666667,0.3234536,0.34,0.3234536,0.34333333,0.3234536,0.34666666,0.3234536,0.35,0.3234536,0.35333332,0.3234536,0.35666665,0.3234536,0.36,0.3234536,0.36333334,0.3234536,0.36666667,0.3234536,0.37,0.3234536,0.37333333,0.3234536,0.37666667,0.3234536,0.38,0.3234536,0.38333333,0.3234536,0.38666666,0.3234536,0.39,0.3234536,0.39333335,0.3234536,0.39666668,0.3234536,0.4,0.3234536,0.40333334,0.3234536,0.40666667,0.3234536,0.41,0.3234536,0.41333333,0.3234536,0.41666666,0.3234536,0.42,0.3234536,0.42333335,0.3234536,0.42666668,0.3234536,0.43,0.3234536,0.43333334,0.3234536,0.43666667,0.3234536,0.44,0.3234536,0.44333333,0.3234536,0.44666666,0.3234536,0.45,0.3234536,0.45333335,0.3234536,0.45666668,0.3234536,0.46,0.3234536,0.46333334,0.3234536,0.46666667,0.3234536,0.47,0.3234536,0.47333333,0.3234536,0.47666666,0.3234536,0.48,0.3234536,0.48333332,0.3234536,0.48666668,0.3234536,0.49,0.3234536,0.49333334,0.3234536,0.49666667,0.3234536,0.5,0.3234536,0.50333333,0.3234536,0.50666666,0.3234536,0.51,0.3234536,0.5133333,0.3234536,0.51666665,0.3234536,0.52,0.3234536,0.5233333,0.3234536,0.52666664,0.3234536,0.53,0.3234536,0.53333336,0.3234536,0.5366667,0.3234536,0.54,0.3234536,0.54333335,0.3234536,0.5466667,0.3234536,0.55,0.3234536,0.55333334,0.3234536,0.61333334,0.3234536,0.6166667,0.3234536,0.62,0.3234536,0.62333333,0.3234536,0.62666667,0.3234536,0.63,0.3234536,0.6333333,0.3234536,0.63666666,0.3234536,0.64,0.3234536,0.6433333,0.3234536,0.64666665,0.3234536,0.65,0.3234536,0.6533333,0.3234536,0.6566667,0.3234536,0.66,0.3234536,0.66333336,0.3234536,0.6666667,0.3234536,0.67,0.3234536,0.6933333,0.3234536,0.70666665,0.3234536,0.71,0.3234536,0.7133333,0.3234536,0.71666664,0.3234536,0.72,0.3234536,0.72333336,0.3234536,0.7266667,0.3234536,0.73,0.3234536,0.75,0.3234536,0.75333333,0.3234536,0.75666666,0.3234536,0.76,0.3234536,0.7633333,0.3234536,0.76666665,0.3234536,0.77,0.3234536,0.7733333,0.3234536,0.77666664,0.3234536,0.78,0.3234536,0.78333336,0.3234536,0.7866667,0.3234536,0.79,0.3234536,0.79333335,0.3234536,0.7966667,0.3234536,0.8,0.3234536,0.80333334,0.3234536,0.8066667,0.3234536,0.81,0.3234536,0.81333333,0.3234536,0.81666666,0.3234536,0.82,0.3234536,0.8233333,0.3234536,0.82666665,0.3234536,0.83,0.3234536,0.8333333,0.3234536,0.83666664,0.3234536,0.84,0.3234536,0.8433333,0.3234536,0.8466667,0.3234536,0.85,0.3234536,0.85333335,0.3234536,0.8566667,0.3234536,0.86,0.3234536,0.86333334,0.3234536,0.8666667,0.3234536,0.87,0.3234536,0.87333333,0.3234536,0.87666667,0.3234536,0.88,0.3234536,0.8833333,0.3234536,0.88666666,0.3234536,0.89,0.3234536,0.8933333,0.3234536,0.89666665,0.3234536,0.9,0.3234536,0.9033333,0.3234536,0.9066667,0.3234536,0.91,0.3234536,0.91333336,0.3234536,0.9166667,0.3234536,0.92,0.3234536,0.92333335,0.3234536,0.9266667,0.3234536,0.93,0.3234536,0.93333334,0.3234536,0.93666667,0.3234536,0.94,0.3234536,0.9433333,0.3234536,0.94666666,0.3234536,0.05,0.32603094,0.053333335,0.32603094,0.05666667,0.32603094,0.06,0.32603094,0.06333333,0.32603094,0.06666667,0.32603094,0.07,0.32603094,0.07333333,0.32603094,0.07666667,0.32603094,0.08,0.32603094,0.083333336,0.32603094,0.086666666,0.32603094,0.09,0.32603094,0.093333334,0.32603094,0.096666664,0.32603094,0.1,0.32603094,0.10333333,0.32603094,0.10666667,0.32603094,0.11,0.32603094,0.11333334,0.32603094,0.11666667,0.32603094,0.12,0.32603094,0.123333335,0.32603094,0.12666667,0.32603094,0.13,0.32603094,0.13333334,0.32603094,0.13666667,0.32603094,0.14,0.32603094,0.14333333,0.32603094,0.14666666,0.32603094,0.15,0.32603094,0.15333334,0.32603094,0.15666667,0.32603094,0.16,0.32603094,0.16333333,0.32603094,0.16666667,0.32603094,0.17,0.32603094,0.17333333,0.32603094,0.17666666,0.32603094,0.18,0.32603094,0.18333334,0.32603094,0.18666667,0.32603094,0.19,0.32603094,0.19333333,0.32603094,0.19666667,0.32603094,0.2,0.32603094,0.20333333,0.32603094,0.20666666,0.32603094,0.21,0.32603094,0.21333334,0.32603094,0.21666667,0.32603094,0.22,0.32603094,0.22333333,0.32603094,0.22666667,0.32603094,0.23,0.32603094,0.23333333,0.32603094,0.23666666,0.32603094,0.24,0.32603094,0.24333334,0.32603094,0.24666667,0.32603094,0.25,0.32603094,0.25333333,0.32603094,0.25666666,0.32603094,0.26,0.32603094,0.26333332,0.32603094,0.26666668,0.32603094,0.27,0.32603094,0.27333334,0.32603094,0.27666667,0.32603094,0.28,0.32603094,0.28333333,0.32603094,0.28666666,0.32603094,0.29,0.32603094,0.29333332,0.32603094,0.29666665,0.32603094,0.3,0.32603094,0.30333334,0.32603094,0.30666667,0.32603094,0.31,0.32603094,0.31333333,0.32603094,0.31666666,0.32603094,0.32,0.32603094,0.32333332,0.32603094,0.32666665,0.32603094,0.33,0.32603094,0.33333334,0.32603094,0.33666667,0.32603094,0.34,0.32603094,0.34333333,0.32603094,0.34666666,0.32603094,0.35,0.32603094,0.35333332,0.32603094,0.35666665,0.32603094,0.36,0.32603094,0.36333334,0.32603094,0.36666667,0.32603094,0.37,0.32603094,0.37333333,0.32603094,0.37666667,0.32603094,0.38,0.32603094,0.38333333,0.32603094,0.38666666,0.32603094,0.39,0.32603094,0.39333335,0.32603094,0.39666668,0.32603094,0.4,0.32603094,0.40333334,0.32603094,0.40666667,0.32603094,0.41,0.32603094,0.41333333,0.32603094,0.41666666,0.32603094,0.42,0.32603094,0.42333335,0.32603094,0.42666668,0.32603094,0.43,0.32603094,0.43333334,0.32603094,0.43666667,0.32603094,0.44,0.32603094,0.44333333,0.32603094,0.44666666,0.32603094,0.45,0.32603094,0.45333335,0.32603094,0.45666668,0.32603094,0.46,0.32603094,0.46333334,0.32603094,0.46666667,0.32603094,0.47,0.32603094,0.47333333,0.32603094,0.47666666,0.32603094,0.48,0.32603094,0.48333332,0.32603094,0.48666668,0.32603094,0.49,0.32603094,0.49333334,0.32603094,0.49666667,0.32603094,0.5,0.32603094,0.50333333,0.32603094,0.50666666,0.32603094,0.51,0.32603094,0.5133333,0.32603094,0.51666665,0.32603094,0.52,0.32603094,0.52666664,0.32603094,0.53,0.32603094,0.53333336,0.32603094,0.54,0.32603094,0.54333335,0.32603094,0.5466667,0.32603094,0.55,0.32603094,0.61333334,0.32603094,0.6166667,0.32603094,0.62,0.32603094,0.62333333,0.32603094,0.62666667,0.32603094,0.63,0.32603094,0.6333333,0.32603094,0.63666666,0.32603094,0.64,0.32603094,0.6433333,0.32603094,0.64666665,0.32603094,0.65,0.32603094,0.6533333,0.32603094,0.6566667,0.32603094,0.66,0.32603094,0.66333336,0.32603094,0.6666667,0.32603094,0.67,0.32603094,0.68666667,0.32603094,0.69,0.32603094,0.6933333,0.32603094,0.69666666,0.32603094,0.7,0.32603094,0.7033333,0.32603094,0.70666665,0.32603094,0.71,0.32603094,0.7133333,0.32603094,0.71666664,0.32603094,0.72,0.32603094,0.72333336,0.32603094,0.7266667,0.32603094,0.73,0.32603094,0.73333335,0.32603094,0.74666667,0.32603094,0.75,0.32603094,0.75333333,0.32603094,0.75666666,0.32603094,0.76,0.32603094,0.7633333,0.32603094,0.76666665,0.32603094,0.77,0.32603094,0.7733333,0.32603094,0.77666664,0.32603094,0.78,0.32603094,0.78333336,0.32603094,0.7866667,0.32603094,0.79,0.32603094,0.79333335,0.32603094,0.7966667,0.32603094,0.8,0.32603094,0.80333334,0.32603094,0.8066667,0.32603094,0.81,0.32603094,0.81333333,0.32603094,0.81666666,0.32603094,0.82,0.32603094,0.8233333,0.32603094,0.82666665,0.32603094,0.83,0.32603094,0.8333333,0.32603094,0.83666664,0.32603094,0.84,0.32603094,0.8433333,0.32603094,0.8466667,0.32603094,0.85,0.32603094,0.85333335,0.32603094,0.8566667,0.32603094,0.86,0.32603094,0.86333334,0.32603094,0.8666667,0.32603094,0.87,0.32603094,0.87333333,0.32603094,0.87666667,0.32603094,0.88,0.32603094,0.8833333,0.32603094,0.88666666,0.32603094,0.89,0.32603094,0.8933333,0.32603094,0.89666665,0.32603094,0.9,0.32603094,0.9033333,0.32603094,0.9066667,0.32603094,0.91,0.32603094,0.91333336,0.32603094,0.9166667,0.32603094,0.92,0.32603094,0.92333335,0.32603094,0.9266667,0.32603094,0.93,0.32603094,0.93333334,0.32603094,0.93666667,0.32603094,0.94,0.32603094,0.9433333,0.32603094,0.94666666,0.32603094],"colors":[[89,149,166],[91,151,168],[94,152,171],[97,154,172],[93,155,171],[94,156,172],[95,157,173],[97,158,174],[101,161,177],[102,162,178],[102,161,178],[104,162,180],[103,162,179],[105,163,179],[105,164,180],[105,164,180],[105,164,180],[104,163,180],[105,164,179],[106,165,182],[107,167,182],[108,167,182],[109,168,184],[109,167,184],[109,168,185],[109,168,186],[110,168,186],[111,169,186],[112,169,186],[111,169,186],[112,169,189],[113,170,188],[114,171,189],[116,173,190],[117,174,191],[117,173,191],[119,175,192],[119,174,192],[121,175,193],[120,175,193],[118,173,191],[116,172,190],[116,173,190],[117,174,191],[118,174,192],[120,174,193],[121,175,194],[119,174,192],[121,175,193],[124,176,195],[125,177,195],[122,177,196],[122,177,196],[124,178,197],[124,178,197],[124,178,197],[122,178,197],[121,178,196],[123,178,198],[122,177,197],[119,176,195],[117,175,194],[117,175,194],[121,178,197],[121,178,197],[121,179,197],[121,179,198],[122,180,199],[121,179,198],[123,179,199],[121,181,199],[122,181,200],[121,180,199],[121,180,199],[123,181,200],[122,182,200],[122,182,201],[123,182,201],[123,181,201],[123,181,202],[123,181,202],[125,181,201],[126,182,202],[124,184,203],[123,183,203],[123,182,203],[123,183,203],[121,182,201],[121,181,201],[124,181,202],[125,181,202],[122,180,203],[122,181,202],[124,181,203],[124,181,203],[123,182,202],[121,180,201],[121,179,200],[121,179,201],[124,181,203],[126,182,204],[125,181,203],[125,181,202],[126,181,202],[125,180,202],[124,180,201],[124,180,201],[124,180,201],[124,180,200],[125,181,201],[124,181,202],[126,182,204],[125,181,203],[126,182,202],[126,182,202],[124,182,201],[124,182,201],[124,181,201],[123,181,202],[122,180,201],[123,180,202],[121,179,200],[122,179,201],[122,179,201],[122,179,201],[120,178,199],[121,178,200],[121,178,198],[121,178,199],[118,177,198],[119,178,198],[119,177,198],[120,178,199],[123,179,200],[123,180,201],[124,180,201],[125,181,201],[124,180,201],[125,180,201],[124,180,201],[123,179,200],[122,180,200],[121,179,199],[120,178,199],[121,177,198],[120,178,197],[119,178,197],[118,177,196],[118,177,196],[117,177,197],[115,175,196],[114,173,195],[103,164,185],[105,167,187],[112,173,193],[115,173,194],[115,174,193],[115,175,194],[115,173,193],[114,173,193],[115,174,193],[114,173,192],[110,170,189],[103,163,184],[104,166,185],[111,171,190],[113,171,190],[110,170,189],[109,170,190],[111,169,189],[113,170,189],[112,169,190],[111,169,188],[111,169,189],[110,168,188],[110,168,189],[112,169,189],[112,170,189],[113,170,187],[116,170,186],[124,170,185],[137,173,184],[170,143,134],[170,130,115],[166,117,98],[166,117,98],[166,112,90],[161,105,80],[161,104,77],[165,106,80],[167,108,80],[168,108,82],[168,109,81],[169,112,80],[172,115,82],[172,114,82],[171,113,81],[169,113,81],[171,113,83],[172,114,83],[172,116,85],[172,116,85],[172,116,85],[172,116,85],[170,115,84],[158,101,77],[150,98,85],[175,147,149],[173,131,115],[162,104,77],[166,107,80],[165,108,79],[166,109,78],[164,106,77],[164,107,76],[165,109,78],[167,112,77],[168,112,77],[165,109,75],[164,107,77],[161,104,76],[164,107,77],[166,110,78],[163,107,77],[164,109,76],[166,113,78],[167,113,78],[161,104,76],[158,101,73],[154,97,73],[153,95,75],[152,95,73],[151,92,71],[154,94,69],[156,97,68],[160,102,70],[166,108,74],[170,112,78],[170,112,78],[167,111,76],[168,111,77],[168,110,76],[168,109,77],[166,109,75],[167,109,75],[164,105,74],[163,104,73],[163,104,74],[160,101,74],[157,100,72],[157,98,72],[155,97,70],[156,96,70],[156,98,72],[157,101,74],[158,105,78],[157,115,94],[153,132,121],[132,156,161],[111,151,162],[101,155,170],[99,158,174],[101,160,177],[100,159,175],[101,159,175],[103,160,176],[103,160,177],[104,161,177],[104,162,177],[103,162,177],[104,164,179],[106,165,181],[106,165,181],[106,164,180],[106,165,181],[107,166,182],[107,166,182],[109,166,183],[109,167,183],[108,167,183],[109,167,183],[108,167,182],[109,168,184],[111,169,185],[112,170,186],[112,169,186],[113,170,186],[113,171,186],[114,170,186],[116,171,188],[116,171,189],[116,171,189],[117,171,190],[119,173,191],[119,173,191],[119,175,192],[120,176,193],[122,176,194],[122,176,194],[122,176,194],[122,176,194],[121,177,194],[122,177,195],[122,176,194],[121,176,193],[120,175,193],[121,176,194],[122,177,195],[125,177,195],[123,177,194],[125,178,196],[127,179,198],[128,180,198],[129,180,200],[127,180,199],[127,181,199],[128,181,200],[126,181,199],[127,180,198],[127,181,200],[126,181,199],[127,181,200],[126,180,198],[121,177,197],[120,177,197],[122,178,198],[123,179,199],[125,179,200],[124,180,200],[125,181,201],[125,181,201],[126,181,202],[126,182,203],[125,182,202],[126,183,202],[126,183,203],[126,182,202],[126,183,202],[125,183,202],[125,182,202],[125,182,202],[125,182,202],[125,181,202],[125,181,202],[125,182,201],[127,183,203],[126,184,204],[127,184,205],[127,183,204],[125,183,204],[125,182,203],[124,181,203],[123,181,202],[123,180,203],[123,180,203],[122,181,202],[122,181,203],[124,182,203],[124,182,203],[124,182,203],[124,180,203],[124,181,203],[124,181,203],[124,181,203],[127,181,203],[127,181,202],[125,181,201],[125,181,201],[124,180,201],[125,181,201],[125,181,202],[124,180,201],[125,181,201],[126,182,202],[126,182,203],[126,182,204],[126,182,204],[126,182,203],[126,182,203],[127,183,204],[125,181,203],[124,181,203],[125,181,203],[125,181,203],[124,180,202],[124,180,202],[123,179,200],[124,180,202],[121,179,200],[123,179,202],[122,179,199],[121,179,200],[119,178,199],[119,178,199],[119,178,199],[121,179,201],[122,181,201],[125,182,202],[125,181,202],[125,180,201],[125,181,201],[127,183,203],[125,182,202],[124,182,201],[123,181,201],[123,178,199],[121,177,198],[121,177,197],[121,177,197],[119,177,196],[118,176,195],[118,176,195],[117,177,196],[115,175,194],[111,172,193],[101,162,184],[104,165,185],[111,172,192],[111,170,191],[110,169,190],[112,170,192],[111,169,190],[114,173,192],[115,174,193],[112,173,192],[109,169,188],[102,161,181],[106,165,185],[113,171,190],[115,172,192],[113,170,190],[111,170,191],[113,170,191],[113,170,190],[113,170,189],[112,170,190],[112,169,190],[111,169,188],[111,168,188],[115,169,189],[115,170,190],[114,169,187],[116,168,185],[126,169,182],[141,168,176],[169,140,124],[165,110,89],[160,103,80],[163,106,80],[166,109,82],[166,107,82],[167,108,80],[170,111,83],[172,114,86],[173,115,87],[174,116,84],[174,116,84],[174,115,86],[173,116,83],[174,118,84],[173,116,83],[172,116,83],[172,116,82],[173,117,83],[174,117,84],[174,118,85],[174,119,85],[174,118,84],[170,114,84],[155,97,76],[157,114,106],[185,155,145],[165,109,87],[164,104,78],[161,102,79],[157,98,74],[155,95,71],[154,94,71],[154,95,70],[156,97,72],[156,97,73],[152,94,72],[151,93,70],[151,93,69],[152,94,70],[155,97,73],[155,96,74],[154,96,72],[157,101,76],[157,101,74],[152,95,72],[154,99,83],[155,103,89],[155,104,92],[154,103,91],[157,109,98],[165,114,102],[161,103,82],[160,100,73],[163,104,72],[168,109,74],[172,113,78],[170,112,77],[170,112,77],[171,112,78],[170,113,76],[170,112,78],[171,113,77],[169,111,75],[169,110,76],[168,110,75],[166,109,75],[166,108,76],[164,107,75],[164,106,75],[163,104,76],[160,102,75],[160,101,74],[159,101,74],[157,100,74],[156,103,83],[155,119,105],[118,135,143],[102,141,155],[100,153,169],[103,159,174],[106,164,181],[107,164,180],[106,164,179],[107,164,180],[107,164,181],[109,165,181],[110,166,182],[108,165,182],[107,167,183],[108,167,184],[109,167,184],[109,167,185],[109,168,185],[111,168,185],[112,170,186],[113,170,187],[113,170,185],[112,170,186],[112,170,186],[115,171,188],[117,173,189],[117,173,190],[119,173,191],[119,173,191],[117,173,190],[117,174,190],[120,174,192],[121,174,192],[120,174,191],[120,175,192],[122,175,193],[122,175,193],[123,176,195],[125,177,195],[125,178,197],[123,177,195],[124,178,196],[123,177,196],[122,177,195],[123,178,196],[123,177,195],[124,178,194],[124,177,194],[124,177,196],[124,177,195],[125,178,197],[125,178,196],[127,180,198],[128,180,199],[130,181,199],[131,181,200],[128,181,200],[128,182,200],[127,182,200],[128,182,200],[129,181,201],[129,181,200],[130,182,201],[127,182,200],[126,180,199],[123,178,198],[121,178,197],[122,179,198],[124,180,200],[126,180,200],[125,181,201],[126,182,202],[126,182,202],[129,182,203],[128,183,203],[128,183,203],[128,184,205],[127,184,204],[127,183,203],[127,183,203],[127,183,203],[126,182,202],[126,182,203],[125,183,202],[125,181,202],[126,182,202],[126,182,202],[126,182,202],[127,183,203],[127,183,204],[127,183,204],[127,183,204],[126,182,204],[126,182,204],[125,181,204],[124,180,202],[124,181,201],[122,180,202],[125,182,204],[129,182,205],[127,183,205],[126,182,204],[125,181,203],[126,181,203],[127,180,203],[127,181,203],[127,181,203],[128,181,202],[126,180,202],[126,180,201],[125,181,202],[124,180,200],[125,181,202],[125,181,201],[125,181,201],[127,182,202],[127,182,203],[127,183,204],[126,182,204],[126,182,204],[126,183,203],[127,183,204],[125,181,203],[125,181,203],[126,182,203],[125,181,203],[124,181,202],[123,180,201],[124,180,201],[124,180,201],[121,179,200],[122,179,200],[123,179,201],[122,179,200],[118,178,199],[119,178,199],[119,178,199],[122,180,201],[123,181,201],[126,182,202],[126,181,202],[126,182,202],[125,181,201],[126,182,202],[126,182,202],[124,181,200],[125,181,200],[125,178,198],[128,179,197],[136,181,201],[138,182,203],[127,180,199],[122,176,197],[118,175,196],[118,176,196],[108,168,189],[88,151,175],[89,152,175],[103,164,185],[109,169,190],[106,167,187],[104,165,185],[106,166,187],[104,164,185],[111,168,189],[114,171,192],[106,168,190],[90,154,176],[91,152,172],[106,166,186],[113,171,191],[115,173,192],[115,172,192],[115,170,193],[116,171,192],[114,171,190],[114,170,190],[113,169,189],[113,169,189],[112,169,188],[113,169,189],[115,170,190],[116,169,190],[117,169,189],[119,169,186],[128,167,178],[144,166,173],[172,132,110],[172,113,87],[171,111,85],[172,115,84],[173,117,85],[174,116,86],[174,115,85],[174,115,84],[176,118,86],[176,118,85],[175,118,83],[176,117,85],[176,117,86],[175,118,85],[177,119,87],[176,119,87],[176,119,86],[176,118,87],[176,118,86],[176,119,86],[176,120,86],[175,118,86],[174,118,86],[169,112,83],[157,99,78],[169,129,119],[178,150,142],[185,149,137],[178,129,116],[168,108,93],[168,109,94],[168,121,110],[174,136,125],[172,135,126],[173,135,128],[170,128,121],[162,111,99],[158,104,88],[166,129,123],[178,146,144],[178,147,143],[180,150,147],[194,166,166],[195,168,169],[180,144,141],[158,104,92],[154,99,87],[162,123,118],[178,131,118],[163,104,75],[161,103,71],[167,109,76],[173,114,80],[171,113,79],[172,113,80],[172,114,79],[173,115,79],[173,115,80],[173,114,78],[173,113,78],[172,112,79],[169,111,76],[169,111,77],[169,111,78],[168,111,77],[168,110,76],[167,109,77],[167,110,77],[166,109,78],[167,110,79],[164,109,81],[162,108,86],[159,116,99],[153,139,134],[121,130,136],[107,131,141],[101,148,159],[103,155,169],[110,167,184],[109,167,184],[111,168,183],[110,167,182],[110,168,184],[111,168,185],[112,168,184],[112,168,186],[113,170,187],[113,170,187],[111,169,186],[111,169,186],[112,171,186],[117,172,189],[116,171,188],[114,169,186],[116,171,188],[115,172,188],[116,172,190],[118,174,192],[121,175,192],[121,176,194],[121,175,192],[120,175,191],[118,175,191],[120,176,192],[120,177,193],[119,176,193],[120,175,192],[121,175,192],[124,176,194],[122,177,194],[125,177,194],[126,179,196],[126,178,196],[124,178,196],[123,179,196],[121,178,195],[122,178,196],[121,178,196],[125,179,198],[125,179,196],[127,179,197],[125,179,197],[124,178,197],[122,177,197],[124,179,197],[127,179,198],[130,181,200],[131,180,199],[129,181,199],[128,181,200],[128,182,200],[128,181,200],[128,182,200],[128,182,200],[130,182,201],[130,182,200],[127,180,200],[125,179,200],[124,178,199],[124,178,198],[125,179,200],[123,180,199],[125,182,201],[126,182,202],[129,182,202],[127,182,203],[127,183,202],[128,184,203],[128,184,203],[129,185,204],[130,185,205],[129,184,204],[127,183,203],[127,183,203],[126,182,202],[126,182,202],[126,182,202],[125,182,202],[124,182,202],[125,181,202],[126,182,202],[126,182,203],[127,183,204],[127,183,205],[126,182,204],[125,181,204],[124,180,202],[124,181,203],[124,179,202],[124,181,202],[123,181,202],[125,181,203],[128,182,204],[127,183,204],[127,182,204],[126,180,203],[126,181,203],[128,180,204],[128,181,203],[128,181,202],[128,181,202],[127,181,202],[124,180,200],[124,180,201],[122,180,199],[124,180,200],[125,181,201],[125,181,201],[125,181,202],[128,182,205],[128,182,204],[127,182,204],[126,182,204],[126,182,204],[125,181,202],[123,181,203],[124,181,203],[124,180,202],[125,181,203],[124,181,203],[121,180,202],[121,179,201],[122,179,200],[122,179,200],[123,178,200],[122,180,200],[122,179,200],[119,177,198],[119,178,198],[121,178,199],[123,179,201],[125,181,202],[125,181,202],[127,181,203],[126,181,202],[127,181,203],[125,181,202],[125,181,201],[127,181,200],[138,184,202],[159,191,209],[173,197,214],[181,201,219],[183,203,219],[178,199,217],[164,193,211],[147,186,205],[124,178,198],[98,160,181],[79,143,168],[85,149,172],[100,163,183],[106,168,188],[103,165,186],[103,165,185],[104,167,186],[101,163,185],[104,165,187],[109,168,191],[92,153,177],[79,140,166],[93,152,174],[106,164,183],[114,172,191],[116,172,192],[116,172,192],[116,172,192],[113,171,190],[115,170,190],[116,170,191],[116,171,190],[117,169,190],[116,167,188],[116,168,188],[121,169,188],[120,168,188],[120,168,188],[120,167,184],[128,165,176],[148,162,164],[172,135,113],[176,118,88],[179,120,91],[178,121,90],[177,119,88],[176,119,87],[176,119,85],[175,117,83],[176,119,84],[177,119,85],[176,119,84],[177,119,84],[177,119,86],[177,119,87],[177,119,88],[178,119,88],[178,119,87],[178,119,87],[176,120,87],[178,120,88],[178,120,87],[176,120,87],[176,119,86],[172,115,84],[159,100,77],[167,115,96],[180,150,145],[172,127,116],[168,110,96],[172,125,119],[187,164,163],[168,123,112],[182,158,157],[182,149,146],[168,119,112],[190,165,165],[178,139,131],[164,102,77],[164,103,73],[167,108,75],[173,114,81],[173,114,81],[173,114,81],[173,114,81],[174,116,81],[174,116,81],[174,116,80],[174,115,79],[173,114,79],[171,112,77],[171,112,78],[170,112,78],[169,111,77],[168,110,77],[170,112,79],[170,111,79],[168,110,79],[167,111,79],[168,112,83],[165,110,85],[163,116,97],[157,139,133],[107,128,136],[104,144,154],[103,152,165],[114,170,187],[113,170,186],[114,170,186],[112,170,185],[113,171,186],[115,170,187],[116,170,188],[118,171,190],[118,172,190],[116,171,189],[116,171,189],[115,171,187],[117,172,189],[113,165,180],[104,156,171],[94,145,164],[98,153,170],[103,157,176],[110,163,181],[115,170,187],[121,176,192],[123,177,194],[122,176,193],[122,176,193],[122,176,193],[123,177,193],[124,177,195],[121,177,194],[121,176,192],[121,175,193],[123,177,195],[122,177,194],[122,177,193],[124,178,194],[126,179,197],[124,179,196],[124,179,196],[122,178,195],[123,178,195],[122,178,195],[125,179,196],[123,177,196],[123,178,197],[126,178,198],[124,178,198],[123,178,197],[126,179,198],[129,180,199],[129,180,199],[131,181,200],[128,181,200],[127,181,200],[127,181,200],[127,181,200],[126,181,200],[127,181,201],[128,182,201],[128,182,200],[126,179,200],[124,178,199],[122,176,197],[123,177,197],[121,173,193],[119,175,194],[123,181,199],[127,182,201],[126,181,200],[121,178,197],[126,183,201],[127,184,202],[128,186,203],[130,186,205],[131,185,206],[131,185,205],[129,185,204],[130,185,205],[127,184,204],[126,182,202],[128,182,203],[127,182,202],[126,182,202],[127,183,203],[127,183,203],[127,183,203],[129,184,205],[129,185,204],[127,183,204],[125,182,203],[123,180,202],[124,179,202],[123,180,201],[125,179,202],[125,181,201],[124,178,199],[123,177,199],[126,180,201],[127,181,203],[126,182,204],[125,181,202],[124,181,202],[124,180,201],[124,180,201],[125,182,203],[125,182,202],[125,180,202],[124,179,201],[123,179,199],[124,180,200],[123,180,201],[123,181,202],[125,181,203],[126,181,203],[127,182,203],[128,181,203],[125,181,203],[126,182,204],[124,181,203],[123,181,203],[123,180,201],[125,181,202],[126,181,203],[125,182,203],[120,180,201],[122,179,201],[122,179,201],[123,179,201],[123,178,201],[123,179,201],[123,178,200],[120,177,199],[120,177,199],[122,179,201],[123,179,201],[124,180,202],[125,181,201],[124,180,200],[124,181,201],[124,181,201],[124,180,200],[126,179,200],[152,190,208],[174,201,218],[195,206,223],[196,206,222],[199,207,222],[197,207,221],[198,206,222],[194,204,221],[184,200,216],[163,191,210],[129,179,198],[101,162,184],[100,161,182],[100,163,181],[98,162,182],[93,157,176],[99,162,181],[96,159,180],[93,155,178],[105,164,187],[111,171,193],[108,168,190],[103,162,184],[108,164,187],[113,169,189],[117,173,193],[117,173,193],[116,172,192],[115,172,191],[113,171,190],[116,172,191],[120,172,192],[121,170,189],[127,169,187],[130,167,184],[131,168,185],[132,169,186],[131,167,184],[128,167,184],[125,166,182],[133,164,173],[174,132,108],[178,119,90],[180,121,93],[179,120,91],[178,120,90],[176,117,86],[176,119,86],[176,118,86],[177,120,85],[178,120,86],[178,119,86],[178,120,85],[179,122,88],[178,120,87],[177,119,87],[179,120,88],[178,119,87],[179,120,87],[177,119,87],[179,120,88],[178,120,88],[178,120,88],[176,119,86],[174,117,84],[162,102,79],[164,105,81],[185,143,122],[203,187,183],[188,169,170],[172,124,115],[184,156,156],[186,166,163],[175,153,149],[186,159,161],[185,162,159],[173,143,141],[184,164,162],[164,130,121],[177,160,159],[177,139,131],[166,106,80],[165,105,74],[168,109,76],[173,114,80],[173,115,81],[174,116,80],[174,116,82],[174,117,81],[175,117,81],[173,115,80],[174,116,80],[174,116,79],[173,115,79],[172,113,79],[173,114,80],[170,112,77],[169,111,77],[171,112,78],[170,112,81],[171,111,80],[170,111,79],[169,111,80],[166,111,85],[165,115,94],[158,136,129],[111,124,129],[106,137,146],[107,147,157],[116,171,187],[116,170,189],[116,171,188],[116,171,187],[116,172,188],[116,171,187],[114,171,188],[115,172,188],[116,172,190],[116,172,188],[115,169,185],[100,155,171],[79,131,151],[69,116,141],[65,112,140],[66,113,142],[66,116,146],[65,116,146],[71,123,149],[76,128,154],[94,147,170],[115,170,189],[123,177,195],[123,177,194],[124,177,195],[121,177,194],[120,173,192],[119,173,190],[121,175,193],[119,175,192],[121,175,193],[121,176,194],[122,176,194],[123,177,195],[123,178,195],[124,179,195],[124,178,196],[124,178,196],[126,177,194],[127,178,194],[123,173,188],[108,152,168],[120,168,187],[128,177,199],[125,178,197],[125,177,196],[125,178,198],[126,178,197],[127,179,198],[126,179,199],[126,179,199],[128,180,200],[126,181,200],[124,180,200],[126,180,201],[124,180,200],[125,179,199],[126,179,200],[125,179,199],[124,179,198],[121,176,196],[119,173,191],[88,127,141],[99,147,165],[125,179,199],[128,181,201],[119,168,187],[88,126,143],[117,160,177],[106,151,169],[120,171,191],[129,184,202],[128,183,202],[128,185,202],[128,184,202],[122,177,197],[125,181,201],[126,182,202],[128,182,204],[127,182,202],[128,182,203],[128,182,203],[127,183,203],[127,183,203],[128,182,204],[129,185,205],[128,184,204],[126,182,204],[124,180,203],[125,179,202],[124,180,202],[123,179,201],[125,172,192],[98,133,151],[82,117,137],[105,147,167],[128,177,197],[122,172,192],[121,176,197],[126,180,201],[127,179,201],[125,179,201],[125,181,202],[124,181,202],[125,180,201],[124,179,200],[123,179,199],[123,179,200],[124,179,200],[123,179,201],[124,181,202],[125,180,203],[126,181,202],[126,181,203],[125,180,203],[125,180,203],[126,180,203],[110,157,177],[110,158,177],[122,179,200],[124,181,202],[124,182,202],[122,180,201],[124,180,201],[124,179,202],[124,179,200],[124,179,201],[123,178,200],[121,178,199],[121,177,198],[120,177,198],[123,179,202],[123,179,201],[125,181,202],[124,180,202],[125,181,202],[124,180,201],[124,180,200],[125,180,200],[137,183,202],[180,203,222],[194,207,224],[190,203,217],[191,203,217],[194,204,219],[196,204,219],[194,203,219],[194,204,220],[173,190,206],[166,188,206],[166,198,214],[115,172,191],[101,164,184],[94,158,180],[77,141,166],[78,141,164],[86,148,171],[74,136,161],[83,145,168],[101,162,182],[113,172,192],[115,173,195],[113,171,193],[114,171,193],[116,173,194],[119,174,194],[118,174,194],[117,173,193],[116,172,192],[116,172,191],[120,173,193],[136,176,194],[142,177,193],[144,172,184],[146,169,179],[148,167,177],[149,166,176],[153,163,170],[153,166,174],[153,164,171],[172,130,103],[176,118,88],[179,120,92],[179,120,92],[178,119,89],[176,117,86],[176,119,87],[178,119,88],[179,120,89],[179,120,87],[179,119,89],[179,121,88],[180,121,88],[178,120,86],[179,121,86],[177,120,86],[177,119,85],[176,119,86],[177,120,86],[178,119,88],[176,118,85],[176,119,86],[177,119,85],[174,116,81],[160,100,76],[161,102,84],[170,116,96],[180,133,115],[189,159,148],[181,153,150],[189,169,168],[172,127,113],[175,137,129],[184,165,161],[181,156,154],[181,145,137],[174,118,107],[191,173,170],[184,158,157],[170,146,145],[154,112,104],[170,146,142],[181,136,123],[165,106,78],[163,103,71],[167,108,73],[172,115,78],[173,116,79],[173,116,79],[174,116,81],[175,117,82],[175,117,83],[174,116,81],[175,117,81],[174,116,80],[173,115,78],[173,115,79],[173,115,80],[171,112,78],[170,112,78],[171,112,79],[170,112,80],[171,112,79],[170,112,80],[169,111,80],[167,110,83],[167,115,92],[159,135,127],[115,128,130],[114,170,187],[116,170,188],[116,170,188],[117,171,189],[114,171,187],[114,171,188],[115,171,189],[118,173,190],[118,172,191],[116,169,187],[98,150,168],[70,122,144],[60,113,140],[61,113,142],[64,115,144],[64,116,147],[66,118,150],[68,120,149],[68,122,151],[67,123,152],[72,128,154],[97,152,174],[119,175,193],[122,176,194],[122,176,195],[121,173,192],[101,139,155],[97,141,159],[120,173,192],[120,174,192],[121,175,193],[121,174,193],[124,176,196],[124,177,196],[123,177,194],[122,176,194],[123,177,194],[124,176,194],[126,177,193],[124,175,192],[113,158,174],[72,99,116],[108,148,167],[126,177,196],[123,174,193],[125,176,195],[124,178,197],[124,177,196],[124,177,196],[125,177,194],[121,170,187],[121,172,187],[120,172,187],[121,178,196],[120,173,192],[118,170,189],[113,167,186],[122,175,193],[124,178,196],[123,176,193],[118,171,188],[112,156,169],[71,93,105],[96,139,153],[124,180,200],[126,181,201],[110,156,176],[64,95,113],[113,154,168],[85,120,136],[118,167,185],[127,179,196],[125,180,198],[128,182,199],[126,170,186],[88,125,138],[116,163,180],[125,180,198],[127,180,200],[125,179,199],[125,179,200],[125,180,201],[125,180,200],[126,178,199],[126,180,201],[129,184,206],[130,182,203],[129,182,204],[128,181,203],[128,181,202],[126,179,201],[122,177,198],[106,149,169],[65,84,103],[71,95,115],[76,113,134],[117,166,184],[90,126,142],[106,155,174],[123,178,198],[122,176,197],[122,176,197],[123,178,200],[125,179,201],[124,179,200],[122,178,198],[122,179,198],[124,180,200],[126,180,200],[123,179,200],[123,179,201],[126,180,203],[127,180,202],[124,178,199],[123,177,198],[124,177,199],[120,176,195],[76,107,123],[89,125,144],[121,178,197],[124,181,201],[122,180,199],[123,179,199],[123,178,200],[121,177,198],[120,177,197],[120,176,196],[120,176,198],[119,176,197],[118,176,196],[120,176,197],[123,179,200],[122,179,199],[124,181,201],[126,181,203],[127,181,204],[126,180,203],[125,181,201],[128,179,200],[163,192,210],[198,208,223],[192,204,220],[181,197,211],[181,197,211],[181,196,211],[184,197,212],[187,199,214],[189,203,218],[161,181,201],[160,181,200],[188,203,218],[147,185,205],[108,166,187],[93,158,181],[78,143,168],[91,151,173],[89,151,172],[84,146,170],[96,157,178],[103,164,183],[115,173,193],[120,174,195],[117,174,196],[117,175,196],[118,175,196],[118,174,194],[118,174,194],[117,173,193],[117,172,193],[115,171,191],[116,171,190],[129,172,190],[148,174,187],[165,144,136],[171,134,120],[163,118,104],[159,112,97],[159,124,112],[155,121,110],[150,115,102],[169,139,117],[180,134,105],[178,119,89],[179,120,90],[179,120,89],[178,119,88],[177,118,87],[178,119,87],[178,119,87],[179,120,88],[180,121,89],[178,120,89],[179,120,87],[179,120,87],[179,120,87],[180,121,88],[177,120,86],[176,119,85],[178,120,86],[177,119,86],[176,119,85],[177,118,85],[176,117,86],[176,118,85],[167,108,76],[154,92,73],[158,100,87],[182,144,138],[186,150,141],[176,133,116],[178,146,139],[187,162,158],[192,172,172],[177,141,138],[183,146,143],[188,168,162],[182,158,154],[174,132,121],[171,115,103],[187,170,167],[178,149,142],[171,152,154],[173,137,125],[166,107,79],[163,105,71],[165,109,73],[171,115,76],[173,116,79],[173,116,79],[175,117,82],[175,118,83],[175,118,83],[175,117,83],[176,117,82],[174,116,81],[174,116,81],[173,115,80],[172,114,80],[171,112,79],[172,112,79],[171,112,79],[171,112,80],[172,113,81],[169,110,79],[170,112,79],[167,111,83],[167,116,94],[162,131,119],[145,130,127],[119,98,92],[125,91,83],[115,170,187],[117,170,188],[116,171,188],[116,171,188],[116,171,190],[116,171,189],[116,171,189],[120,172,190],[119,172,189],[99,152,171],[69,116,140],[63,111,137],[63,114,141],[63,118,145],[72,125,153],[99,148,176],[85,137,166],[67,126,156],[69,125,155],[71,126,156],[70,127,156],[84,139,163],[113,168,186],[121,175,195],[122,175,194],[118,167,184],[77,106,122],[89,126,143],[119,173,191],[120,174,192],[121,174,192],[114,163,178],[107,154,168],[115,166,182],[122,176,194],[122,176,195],[116,166,180],[100,146,161],[100,146,161],[116,166,180],[108,150,166],[66,88,102],[99,135,149],[101,142,157],[100,146,167],[117,172,192],[121,177,197],[123,177,196],[122,171,187],[98,135,150],[75,108,125],[72,105,121],[86,123,138],[110,159,173],[95,129,143],[84,116,130],[82,114,131],[101,140,157],[123,173,188],[111,154,169],[83,117,130],[77,107,119],[60,77,91],[90,129,146],[126,180,200],[127,180,199],[104,150,170],[62,86,103],[103,141,155],[73,107,122],[114,156,170],[101,141,155],[90,131,145],[111,156,172],[103,142,155],[64,80,96],[85,117,134],[118,165,182],[113,154,169],[94,135,151],[100,142,158],[121,167,183],[118,161,176],[99,132,148],[92,131,149],[105,151,171],[127,177,198],[129,182,204],[129,181,205],[128,181,202],[127,179,202],[123,176,199],[90,125,148],[62,81,102],[79,111,126],[93,133,152],[117,166,183],[79,115,130],[108,152,171],[114,161,178],[99,143,162],[91,135,155],[101,147,167],[121,175,196],[125,173,192],[108,145,165],[96,133,153],[97,135,154],[107,152,173],[123,179,201],[123,178,199],[124,180,200],[119,170,188],[97,141,163],[93,136,157],[97,139,158],[107,159,175],[64,92,109],[82,122,141],[123,176,194],[111,152,171],[96,134,155],[112,156,174],[122,176,195],[117,169,187],[106,151,171],[100,146,165],[101,150,169],[117,170,190],[121,174,193],[111,157,174],[99,145,163],[101,147,165],[110,160,177],[125,180,202],[126,181,203],[126,182,203],[126,181,202],[133,182,200],[180,202,219],[201,209,226],[192,204,220],[179,197,211],[178,196,210],[179,197,211],[181,198,212],[184,200,213],[186,203,217],[161,185,203],[161,182,201],[195,204,219],[172,197,215],[125,172,192],[105,167,187],[102,163,184],[105,163,184],[106,165,187],[109,166,189],[110,166,190],[114,171,192],[118,175,195],[119,175,196],[120,176,196],[119,175,197],[120,176,196],[120,175,195],[116,173,193],[117,173,193],[117,172,193],[116,171,191],[115,171,191],[117,168,187],[131,165,179],[146,159,164],[164,146,137],[172,126,106],[160,107,86],[154,98,79],[152,96,78],[152,97,80],[153,99,84],[167,126,104],[178,132,102],[179,119,89],[179,120,90],[178,120,89],[177,119,88],[178,117,87],[177,118,86],[177,118,85],[179,120,86],[178,120,87],[178,120,87],[179,120,87],[178,120,85],[177,119,84],[179,121,86],[177,119,84],[178,120,85],[176,120,84],[176,120,85],[176,120,85],[176,120,85],[175,118,84],[174,118,85],[168,109,82],[156,95,73],[169,112,99],[199,176,177],[194,174,175],[188,168,165],[179,143,131],[183,151,137],[182,152,139],[184,151,142],[176,137,125],[171,119,106],[193,170,166],[172,132,118],[186,155,145],[176,132,116],[166,107,77],[164,106,72],[169,111,77],[173,115,79],[174,116,80],[174,116,80],[175,117,82],[175,117,82],[176,118,82],[175,117,82],[176,115,83],[176,116,82],[175,117,82],[174,116,80],[173,115,79],[172,113,78],[171,113,78],[172,113,80],[172,113,81],[172,113,83],[170,112,80],[170,112,80],[170,111,80],[168,112,85],[165,126,108],[152,133,128],[125,111,112],[121,91,85],[122,82,74],[115,171,188],[116,172,189],[116,172,189],[116,171,188],[116,171,188],[116,172,189],[116,171,188],[120,172,190],[113,165,184],[74,124,148],[64,111,138],[63,111,141],[63,115,146],[70,122,151],[124,162,184],[164,192,210],[129,170,193],[77,134,162],[72,128,159],[72,127,158],[72,128,159],[77,133,160],[103,156,177],[118,174,192],[117,174,192],[110,164,182],[75,97,114],[92,130,147],[118,174,192],[120,174,192],[113,155,170],[80,112,125],[68,101,114],[83,119,133],[109,156,172],[116,165,179],[83,111,127],[69,99,115],[71,102,117],[87,125,138],[97,138,151],[63,84,96],[73,96,109],[68,98,115],[102,150,172],[117,175,194],[120,176,197],[120,175,194],[100,137,151],[65,88,105],[78,115,133],[70,101,119],[69,90,104],[96,130,145],[63,84,98],[74,102,118],[83,113,128],[72,98,114],[102,145,160],[74,100,116],[70,100,117],[80,114,131],[63,81,96],[96,134,150],[123,178,199],[123,179,201],[107,157,178],[64,88,103],[104,143,159],[68,99,114],[107,146,159],[77,107,122],[68,87,101],[97,133,151],[93,134,150],[67,79,99],[94,128,148],[103,145,160],[73,96,107],[71,93,104],[71,90,104],[93,127,143],[92,125,139],[60,79,96],[70,100,118],[75,102,117],[103,141,158],[125,181,202],[129,182,204],[127,181,204],[126,180,202],[124,178,200],[107,154,176],[76,106,125],[71,97,113],[90,124,142],[115,164,181],[75,105,121],[106,145,161],[88,118,135],[59,84,102],[74,101,119],[74,98,119],[101,147,165],[95,133,151],[69,91,111],[77,104,123],[66,88,105],[82,116,137],[120,176,198],[122,178,198],[123,177,195],[83,111,127],[70,96,115],[76,102,122],[63,80,97],[94,135,151],[66,93,111],[84,124,141],[102,142,157],[72,98,114],[74,105,123],[81,111,129],[106,149,165],[91,125,140],[63,83,101],[67,99,118],[71,99,117],[102,146,163],[109,156,172],[70,100,118],[74,103,120],[68,93,109],[77,109,125],[126,180,200],[125,181,202],[126,181,203],[127,181,202],[144,186,205],[191,206,223],[201,209,227],[196,206,223],[176,195,211],[167,187,204],[175,193,209],[185,201,216],[176,196,211],[166,187,203],[162,185,203],[181,197,214],[182,200,216],[134,173,193],[111,171,191],[114,171,191],[115,172,191],[116,173,193],[117,173,195],[119,174,196],[119,175,196],[121,176,197],[120,176,196],[120,176,196],[121,176,196],[120,176,196],[122,175,196],[120,174,195],[118,173,193],[118,173,193],[118,173,193],[113,170,190],[114,169,187],[115,165,180],[131,161,170],[144,155,160],[162,144,137],[168,127,111],[158,105,87],[153,98,78],[151,97,77],[152,101,82],[169,127,103],[175,127,100],[179,118,88],[180,119,90],[177,119,88],[178,120,89],[176,117,87],[178,117,87],[177,117,85],[178,118,86],[179,120,87],[178,119,86],[178,119,86],[178,120,86],[178,120,85],[180,121,87],[177,119,84],[177,119,82],[177,119,83],[176,119,83],[178,119,87],[177,116,85],[174,116,82],[175,117,83],[170,112,80],[161,99,76],[162,103,80],[188,152,141],[194,164,156],[176,120,103],[177,125,104],[194,166,151],[187,158,146],[175,122,103],[188,147,134],[180,136,124],[173,115,98],[196,169,162],[195,181,175],[172,125,110],[172,128,114],[186,167,163],[193,176,171],[169,123,104],[164,106,78],[163,105,72],[169,110,77],[172,114,78],[174,115,79],[174,116,81],[174,117,81],[173,116,80],[174,116,79],[176,117,80],[175,116,81],[176,116,81],[176,116,83],[174,115,80],[172,114,77],[172,114,78],[171,112,77],[172,112,79],[172,114,78],[170,113,78],[169,111,78],[169,111,79],[167,110,80],[169,112,89],[164,126,111],[151,133,127],[126,111,110],[121,91,85],[121,83,75],[116,172,189],[116,171,190],[116,171,190],[116,172,191],[116,172,189],[116,172,189],[115,172,188],[116,170,188],[100,154,173],[65,114,140],[62,112,142],[62,114,146],[66,119,150],[91,135,162],[168,189,206],[182,199,212],[164,189,207],[99,145,171],[70,126,157],[69,127,157],[69,127,160],[74,131,160],[91,146,170],[116,170,191],[118,174,193],[114,166,183],[69,95,110],[107,154,171],[119,175,192],[113,165,181],[71,100,114],[62,94,113],[77,113,128],[70,98,112],[81,114,129],[81,117,132],[57,81,100],[98,141,163],[83,128,142],[66,94,108],[85,119,134],[62,79,92],[56,69,83],[80,115,135],[115,170,188],[117,175,195],[119,175,195],[117,172,190],[80,113,129],[74,103,119],[105,164,179],[87,126,141],[69,87,103],[99,136,155],[60,86,103],[103,143,162],[102,147,163],[65,89,107],[89,122,137],[65,85,103],[94,135,153],[107,154,167],[62,83,97],[90,125,143],[123,178,198],[124,178,199],[107,152,171],[62,87,104],[95,134,153],[59,84,101],[98,138,154],[77,113,128],[71,93,106],[94,132,150],[112,161,178],[66,85,105],[102,142,162],[86,116,133],[60,71,86],[71,96,110],[69,86,102],[78,111,129],[90,120,138],[64,85,105],[105,151,173],[81,113,130],[83,116,132],[126,179,199],[127,181,203],[127,182,204],[127,180,203],[124,178,201],[114,166,187],[101,144,165],[81,114,131],[72,91,110],[102,141,159],[63,88,105],[95,130,148],[64,89,108],[65,96,115],[105,146,167],[70,92,113],[87,124,139],[69,96,113],[75,112,132],[106,154,173],[69,96,112],[75,103,123],[121,177,199],[123,178,198],[108,154,174],[60,77,97],[90,131,148],[103,147,164],[62,84,99],[94,133,149],[70,98,117],[83,117,136],[76,102,120],[79,110,131],[107,157,177],[72,103,120],[77,109,126],[75,105,120],[58,83,103],[90,142,161],[72,102,118],[83,119,135],[80,115,132],[68,98,117],[101,146,167],[74,98,110],[67,93,108],[125,179,199],[126,180,203],[126,181,201],[126,181,202],[147,188,206],[194,207,224],[201,209,227],[185,202,220],[133,165,188],[121,161,183],[130,162,183],[160,184,204],[122,159,182],[121,159,180],[135,166,187],[179,193,211],[198,205,221],[188,202,218],[138,175,193],[113,170,191],[116,172,193],[117,173,194],[117,175,195],[119,175,195],[120,176,196],[121,176,197],[121,176,197],[122,177,197],[122,177,197],[121,176,197],[121,175,196],[121,175,196],[121,174,195],[119,174,194],[120,174,195],[118,173,193],[115,172,191],[114,170,190],[114,166,186],[120,161,174],[132,157,168],[143,153,159],[171,133,117],[162,110,91],[150,96,77],[147,96,78],[168,126,104],[173,124,98],[174,113,85],[176,115,86],[177,117,87],[175,117,84],[174,115,83],[175,116,83],[176,118,84],[176,117,84],[178,117,85],[178,117,85],[179,119,87],[179,120,87],[179,120,86],[179,119,85],[177,117,83],[177,117,84],[177,119,83],[177,119,83],[178,118,85],[176,117,84],[175,116,83],[174,116,82],[173,115,79],[166,107,80],[166,104,78],[170,112,87],[181,137,118],[191,165,158],[195,176,176],[192,171,167],[184,153,138],[180,126,105],[174,114,90],[171,112,89],[176,122,100],[187,146,128],[193,157,144],[189,152,138],[180,136,119],[170,115,92],[174,112,88],[178,130,112],[191,161,149],[190,156,146],[178,122,105],[177,113,92],[189,144,126],[194,161,146],[186,147,130],[175,117,101],[186,150,141],[185,158,145],[166,114,86],[164,104,75],[163,104,72],[168,110,76],[172,113,78],[172,114,77],[173,115,79],[174,116,80],[174,116,79],[173,115,77],[174,115,79],[175,116,79],[174,116,79],[174,116,80],[174,116,80],[172,114,79],[170,112,79],[170,110,77],[169,109,78],[168,109,77],[169,111,77],[167,108,77],[166,107,77],[165,106,77],[164,108,81],[166,127,113],[154,133,128],[124,110,109],[119,91,86],[120,88,82],[116,171,189],[115,171,190],[117,172,191],[116,172,191],[116,172,190],[116,173,190],[112,171,188],[108,168,185],[85,139,161],[64,111,139],[63,113,143],[61,115,148],[68,120,152],[119,156,178],[174,193,208],[175,191,204],[179,197,213],[132,169,190],[73,126,155],[67,126,156],[67,127,158],[70,130,161],[82,142,168],[111,168,188],[116,174,192],[110,163,180],[74,97,115],[111,161,177],[119,173,191],[102,151,163],[64,89,105],[91,126,145],[108,161,175],[79,102,118],[70,91,110],[71,106,123],[65,91,111],[105,152,168],[91,139,149],[62,82,101],[85,119,134],[62,76,91],[58,71,87],[74,104,120],[105,156,173],[119,175,196],[120,176,196],[116,172,191],[83,119,140],[70,96,113],[86,123,137],[75,102,116],[66,86,102],[98,138,156],[65,90,110],[110,155,176],[109,157,176],[67,93,112],[92,128,149],[70,98,114],[81,114,129],[84,118,132],[58,75,91],[86,130,150],[122,178,197],[123,178,197],[111,157,175],[60,86,106],[97,137,155],[63,91,107],[102,148,165],[89,128,143],[70,90,106],[83,106,124],[118,162,182],[68,93,113],[105,150,171],[91,124,143],[67,88,106],[84,111,128],[77,105,123],[95,137,157],[99,133,153],[74,100,122],[120,172,194],[83,120,139],[70,102,118],[123,167,186],[108,152,174],[125,177,200],[126,181,203],[121,175,196],[95,137,158],[91,124,146],[90,121,137],[60,76,93],[96,135,155],[64,89,103],[94,129,150],[71,94,115],[89,121,143],[120,169,192],[76,99,121],[81,115,131],[70,98,113],[89,124,141],[103,152,169],[63,80,96],[70,95,114],[122,177,199],[124,179,200],[102,146,167],[61,85,103],[97,133,150],[99,140,156],[56,79,94],[90,130,147],[68,92,112],[79,114,133],[74,100,118],[80,112,132],[106,152,170],[76,103,120],[72,102,121],[76,107,123],[66,100,119],[109,168,189],[79,112,129],[74,107,123],[73,104,121],[75,108,127],[109,160,176],[77,97,110],[73,103,119],[120,172,190],[119,170,192],[128,181,202],[127,180,201],[147,186,206],[195,207,224],[202,209,226],[186,202,219],[151,183,203],[117,162,186],[106,151,175],[136,170,192],[107,152,175],[109,158,182],[102,149,174],[158,177,196],[196,203,219],[187,202,216],[135,173,190],[111,170,191],[116,173,194],[119,173,195],[120,174,195],[119,175,195],[118,176,196],[120,176,197],[121,176,197],[123,177,197],[122,176,197],[121,176,197],[121,176,197],[122,175,196],[122,174,196],[120,174,196],[122,174,196],[121,173,196],[117,173,194],[115,171,189],[116,168,186],[120,165,181],[125,160,173],[133,155,164],[175,139,119],[156,103,85],[149,98,77],[168,127,104],[172,124,99],[164,102,80],[162,101,78],[166,104,78],[165,104,76],[164,105,76],[167,107,79],[170,110,80],[172,112,81],[175,115,83],[177,117,84],[177,118,85],[178,118,85],[178,118,85],[178,117,84],[176,117,83],[176,117,84],[178,117,85],[178,119,86],[178,120,86],[176,119,82],[176,117,81],[176,117,84],[174,116,83],[169,111,81],[166,106,79],[165,104,77],[170,110,83],[174,118,91],[178,124,102],[178,123,102],[176,119,92],[171,113,86],[165,107,79],[167,110,81],[169,110,83],[174,114,87],[173,114,90],[173,114,91],[170,112,85],[166,107,80],[171,108,82],[172,112,85],[177,119,91],[180,118,96],[176,113,89],[173,109,85],[174,114,88],[178,118,94],[174,115,92],[171,111,86],[181,136,117],[193,170,167],[187,164,157],[172,124,104],[163,106,77],[163,102,72],[164,104,73],[167,108,75],[170,112,76],[172,113,76],[173,114,78],[173,114,79],[174,115,81],[171,113,78],[170,112,77],[171,112,77],[172,113,79],[170,112,78],[172,113,79],[168,108,77],[166,106,78],[164,105,77],[162,102,75],[160,101,74],[159,102,75],[161,101,77],[160,101,78],[159,101,79],[159,104,83],[164,129,117],[154,134,128],[125,111,108],[119,94,90],[123,102,97],[117,171,190],[117,171,191],[118,172,191],[117,171,189],[119,173,192],[119,172,193],[116,172,190],[107,164,185],[78,132,155],[62,111,142],[62,114,145],[65,118,150],[80,127,158],[151,177,197],[177,194,208],[175,191,205],[185,200,213],[157,185,203],[78,130,158],[66,122,154],[69,125,157],[70,129,161],[85,144,170],[112,170,189],[114,175,192],[98,149,166],[65,86,101],[92,127,143],[99,142,157],[93,135,151],[68,101,117],[81,114,128],[89,124,140],[70,88,108],[76,119,140],[90,139,156],[66,103,121],[79,116,131],[69,96,113],[69,97,121],[95,140,159],[63,92,112],[74,106,126],[72,105,124],[91,133,151],[116,170,191],[120,175,196],[121,176,197],[105,156,178],[81,114,134],[73,99,117],[70,91,111],[77,109,129],[104,147,169],[81,118,141],[115,165,185],[113,162,182],[74,109,132],[101,150,173],[93,133,153],[74,108,126],[70,103,122],[76,108,127],[103,154,174],[121,179,198],[120,178,197],[110,161,182],[80,117,140],[102,152,174],[82,119,140],[101,151,168],[77,117,135],[69,94,114],[95,127,149],[121,168,190],[84,117,142],[113,159,182],[109,155,177],[82,110,131],[77,105,124],[74,103,124],[102,150,171],[97,135,156],[75,105,126],[122,173,196],[96,135,159],[82,119,139],[105,146,164],[80,117,139],[126,176,197],[127,182,202],[120,174,195],[84,132,151],[67,96,116],[67,93,112],[71,106,127],[105,152,171],[71,100,121],[100,141,164],[85,115,140],[100,138,161],[123,172,191],[71,97,121],[81,119,140],[83,114,133],[74,98,116],[72,99,116],[57,70,86],[78,107,127],[123,177,200],[124,178,200],[117,166,191],[77,116,137],[74,104,120],[72,99,117],[60,79,98],[90,133,152],[70,97,120],[87,124,147],[91,127,149],[77,104,124],[75,104,123],[67,90,111],[95,136,159],[85,119,141],[76,117,141],[115,172,193],[80,114,134],[72,110,129],[79,118,138],[69,98,117],[71,105,121],[65,78,93],[79,104,123],[104,149,167],[85,127,149],[117,172,193],[124,179,199],[139,182,202],[188,203,220],[201,209,225],[190,205,222],[157,188,207],[113,156,179],[134,170,191],[157,185,203],[138,175,197],[109,156,181],[93,143,169],[150,172,192],[192,201,217],[180,198,214],[127,169,188],[113,171,192],[115,173,195],[118,174,196],[121,174,196],[120,176,197],[117,175,195],[121,176,197],[121,176,197],[123,177,198],[123,176,198],[122,176,197],[121,176,197],[122,176,198],[123,175,196],[120,175,195],[121,174,195],[120,174,196],[120,173,195],[118,171,191],[119,170,188],[124,167,185],[129,164,178],[135,161,172],[174,134,116],[161,110,90],[152,100,82],[168,128,109],[176,142,121],[173,127,108],[168,119,100],[159,102,80],[156,98,76],[155,97,75],[157,97,74],[156,96,74],[156,97,75],[161,101,76],[164,105,79],[166,107,79],[170,109,81],[173,111,81],[174,113,82],[174,114,81],[175,115,81],[175,114,82],[179,118,86],[178,118,86],[176,117,83],[175,115,79],[177,116,83],[176,117,83],[172,113,83],[167,110,78],[164,106,77],[166,106,78],[166,106,78],[168,107,80],[166,106,82],[164,106,79],[161,107,77],[164,110,79],[165,112,81],[164,107,78],[166,107,79],[164,106,78],[163,104,77],[162,105,76],[162,104,74],[166,107,79],[166,104,78],[166,107,76],[166,107,80],[166,106,79],[165,107,79],[165,107,78],[166,105,77],[164,104,75],[164,103,74],[167,106,78],[171,120,97],[180,138,124],[187,150,140],[179,137,123],[169,120,100],[164,107,79],[160,101,72],[161,102,72],[164,104,73],[166,107,75],[167,108,75],[168,109,75],[169,110,77],[168,109,77],[171,110,78],[167,107,77],[164,105,75],[163,103,75],[162,102,76],[161,102,75],[162,102,75],[160,100,75],[158,98,75],[157,99,77],[157,101,81],[158,105,86],[156,109,91],[158,108,92],[161,116,101],[164,125,110],[166,133,119],[165,141,135],[150,133,130],[124,110,109],[117,89,83],[124,98,90],[118,172,191],[118,172,192],[117,171,190],[117,171,190],[113,171,188],[112,171,189],[111,171,187],[106,166,184],[79,132,158],[62,113,143],[61,115,147],[67,120,152],[102,144,170],[174,195,210],[174,193,206],[167,186,199],[178,193,207],[170,193,208],[102,149,170],[67,122,152],[66,124,154],[72,130,159],[91,149,173],[114,172,191],[117,173,193],[97,140,158],[63,92,108],[73,104,121],[75,112,130],[90,137,156],[88,129,145],[73,108,126],[73,104,127],[81,122,145],[110,169,189],[115,170,190],[90,135,154],[74,113,133],[82,120,142],[106,157,180],[113,165,188],[97,148,170],[105,160,182],[95,145,166],[106,154,175],[120,174,195],[122,177,198],[123,178,199],[118,175,195],[111,161,183],[102,148,168],[111,157,176],[118,168,189],[122,174,195],[123,173,194],[123,177,197],[121,174,194],[111,163,187],[115,172,193],[120,170,191],[114,163,185],[114,166,188],[113,166,187],[119,174,195],[125,179,199],[125,179,199],[119,175,196],[115,169,191],[120,175,197],[111,166,188],[115,172,192],[111,164,184],[104,153,176],[118,170,192],[123,177,200],[121,166,190],[123,176,197],[126,179,200],[116,165,186],[107,154,175],[114,163,183],[125,180,200],[114,163,185],[114,158,181],[127,179,201],[113,167,189],[113,163,188],[117,170,191],[113,160,182],[127,179,201],[126,180,202],[123,178,200],[111,165,189],[91,140,163],[93,137,159],[99,155,175],[110,168,188],[92,137,160],[115,162,185],[102,149,172],[118,165,188],[120,172,193],[94,135,159],[105,155,179],[106,155,176],[88,122,143],[85,117,135],[67,85,102],[85,122,143],[123,176,198],[125,179,202],[123,178,201],[108,160,183],[93,140,161],[94,138,158],[91,134,156],[108,159,183],[98,144,170],[113,163,186],[119,170,192],[105,151,172],[83,121,144],[94,136,159],[118,172,194],[105,153,177],[105,156,180],[117,174,195],[95,142,165],[92,142,164],[100,152,172],[82,119,140],[79,114,133],[69,91,106],[80,112,130],[104,151,172],[99,143,166],[121,176,199],[123,180,201],[126,181,200],[170,196,212],[198,207,223],[177,195,214],[118,156,180],[110,155,178],[138,170,189],[174,192,209],[174,197,216],[123,164,187],[106,150,175],[164,185,203],[188,202,218],[162,189,205],[118,166,186],[115,172,194],[117,175,196],[118,175,196],[119,175,197],[119,176,197],[119,176,197],[122,177,197],[122,176,198],[122,176,197],[121,175,197],[120,175,197],[120,176,197],[121,175,196],[122,175,196],[121,174,195],[121,174,195],[121,174,195],[121,173,194],[122,172,192],[126,170,188],[134,168,182],[144,168,179],[164,147,136],[165,121,107],[158,104,88],[155,99,81],[150,96,79],[157,118,104],[175,153,144],[174,157,155],[172,152,151],[171,140,130],[170,133,124],[169,130,120],[169,127,115],[165,120,107],[161,116,99],[157,105,86],[152,96,77],[153,96,75],[156,95,75],[157,96,73],[157,97,74],[160,100,76],[164,103,79],[164,104,75],[169,107,78],[172,111,81],[172,111,80],[170,111,78],[172,113,80],[173,114,82],[171,112,79],[171,112,81],[168,111,80],[166,109,79],[163,107,76],[163,105,76],[162,105,75],[164,107,78],[167,110,81],[169,113,84],[171,116,87],[169,114,84],[167,111,80],[165,110,79],[165,110,77],[166,110,78],[166,111,78],[167,111,78],[167,107,78],[166,108,80],[166,108,80],[168,109,81],[167,109,79],[166,110,79],[165,107,75],[164,105,77],[161,102,71],[161,101,71],[164,103,75],[164,105,78],[167,109,86],[165,108,84],[160,102,77],[157,99,73],[157,98,73],[159,100,72],[162,103,72],[165,105,76],[163,101,75],[163,101,75],[159,99,72],[157,99,75],[157,99,73],[156,98,73],[156,97,75],[156,98,78],[157,103,83],[159,107,88],[163,116,100],[160,112,94],[162,120,105],[166,129,118],[168,140,133],[167,146,143],[166,150,146],[167,146,141],[164,148,144],[123,112,111],[117,85,79],[119,81,72],[120,173,193],[118,172,192],[116,171,189],[116,171,189],[115,171,189],[115,172,191],[113,171,190],[107,169,188],[90,144,169],[62,114,144],[63,117,147],[73,123,154],[122,159,182],[168,189,207],[139,169,186],[116,149,167],[146,169,182],[157,181,194],[107,154,174],[68,121,150],[66,121,152],[72,133,159],[104,162,185],[116,174,195],[114,171,192],[106,161,182],[98,150,172],[103,155,176],[107,159,178],[110,166,185],[114,168,188],[109,162,182],[111,162,184],[116,173,194],[119,177,197],[122,176,197],[118,172,193],[112,168,189],[114,172,192],[117,174,195],[115,174,193],[114,173,193],[118,174,195],[117,173,194],[119,175,196],[123,178,198],[125,179,199],[125,179,199],[124,177,198],[123,176,197],[123,177,199],[125,179,200],[125,180,200],[127,181,201],[128,181,201],[127,180,201],[126,180,201],[126,178,199],[127,179,200],[130,180,202],[125,179,199],[126,179,200],[125,179,199],[127,180,201],[128,180,202],[127,180,201],[125,180,201],[128,181,202],[128,181,202],[122,180,201],[121,181,201],[121,181,200],[125,180,201],[129,182,203],[130,183,204],[131,182,204],[132,184,205],[133,185,206],[133,184,205],[131,183,205],[128,182,203],[129,182,203],[129,180,203],[129,181,202],[129,181,202],[129,181,203],[130,182,204],[130,183,204],[127,180,201],[130,182,203],[127,181,202],[128,180,202],[123,177,200],[121,174,197],[120,175,196],[123,177,198],[121,176,198],[123,177,199],[127,178,201],[125,178,199],[129,179,201],[123,176,199],[122,174,196],[121,173,196],[111,161,183],[84,115,137],[75,106,127],[64,87,109],[98,140,162],[127,179,202],[129,180,203],[127,181,204],[122,178,202],[124,178,202],[124,178,200],[122,178,198],[120,178,200],[122,177,200],[126,180,203],[126,181,203],[123,179,201],[120,176,198],[121,178,200],[125,179,201],[123,178,198],[121,176,198],[121,177,199],[118,174,197],[116,172,193],[110,162,182],[80,119,137],[79,112,129],[62,89,106],[97,140,163],[119,175,197],[123,178,200],[126,180,202],[127,182,203],[126,181,200],[152,189,205],[188,202,218],[178,196,216],[148,175,199],[139,170,192],[151,175,194],[182,194,211],[188,201,217],[158,183,202],[154,180,201],[180,196,212],[179,200,216],[135,176,192],[114,169,189],[119,173,196],[119,175,197],[120,175,197],[121,174,197],[121,174,197],[120,176,198],[120,176,196],[119,175,196],[119,175,196],[120,175,195],[120,175,196],[121,176,196],[122,175,196],[123,175,196],[123,175,196],[121,173,195],[122,174,195],[121,173,194],[134,175,195],[143,173,186],[153,169,178],[170,139,125],[168,120,96],[157,101,83],[153,96,82],[150,92,79],[145,92,79],[143,95,81],[149,117,109],[167,151,150],[171,152,146],[171,141,130],[170,135,123],[169,128,115],[166,123,106],[164,116,99],[162,111,91],[154,96,76],[154,95,75],[154,95,72],[156,98,73],[156,96,75],[155,96,75],[160,101,75],[165,106,75],[166,107,76],[168,108,79],[168,109,81],[167,108,79],[166,110,79],[166,109,78],[167,110,80],[168,111,80],[170,114,84],[171,114,83],[171,115,85],[172,116,87],[172,115,85],[171,116,83],[171,115,81],[171,115,81],[170,114,80],[170,114,80],[170,114,82],[170,113,81],[171,115,82],[171,115,82],[171,114,81],[172,114,82],[170,113,80],[168,110,81],[163,106,79],[159,102,75],[158,100,73],[156,97,73],[156,97,73],[155,97,75],[152,95,72],[151,95,70],[151,96,72],[153,96,74],[156,97,70],[154,95,70],[156,95,72],[154,97,72],[155,101,78],[158,108,88],[159,109,89],[160,114,97],[162,124,110],[164,132,121],[167,140,134],[167,148,144],[170,153,149],[117,89,84],[120,80,73],[119,173,191],[119,172,192],[117,171,190],[118,172,190],[118,172,191],[117,172,192],[113,171,190],[111,170,189],[97,155,177],[71,123,152],[65,117,147],[75,124,153],[103,144,166],[115,157,178],[93,138,163],[79,123,149],[85,124,147],[100,142,163],[77,132,157],[60,117,146],[66,121,151],[86,146,171],[114,173,193],[117,175,195],[117,174,194],[116,174,194],[118,174,195],[121,177,199],[116,173,194],[116,175,194],[119,176,196],[118,175,195],[120,175,195],[120,177,197],[121,178,197],[123,178,197],[123,178,198],[120,177,196],[119,177,196],[119,177,196],[118,176,195],[119,175,195],[120,176,196],[119,176,196],[119,177,196],[123,178,198],[125,179,200],[126,180,200],[126,180,200],[126,180,200],[126,180,200],[127,182,200],[128,181,201],[127,181,202],[128,181,200],[128,181,200],[127,180,201],[128,181,201],[129,181,201],[128,181,200],[127,181,202],[127,181,202],[127,181,202],[128,182,202],[127,181,202],[128,181,202],[126,182,202],[129,182,203],[129,182,203],[126,182,203],[125,183,204],[127,183,204],[129,182,204],[131,184,204],[130,184,204],[133,185,206],[133,184,206],[134,185,207],[134,185,206],[134,185,207],[134,185,207],[131,183,204],[132,184,204],[132,183,204],[130,183,204],[131,183,204],[133,184,205],[132,183,204],[130,182,203],[132,183,203],[131,182,203],[132,181,202],[130,180,202],[126,179,200],[126,179,200],[128,179,201],[129,180,202],[129,180,202],[130,181,202],[131,181,202],[130,181,202],[128,180,202],[127,179,202],[124,176,199],[110,161,183],[90,128,148],[86,123,143],[90,131,153],[120,172,194],[128,180,201],[129,180,202],[129,181,203],[129,180,204],[129,180,204],[132,183,205],[127,181,203],[126,182,204],[127,181,204],[130,182,204],[129,183,205],[128,183,206],[126,182,204],[128,182,204],[128,182,203],[126,180,201],[124,179,200],[123,178,199],[121,177,199],[119,176,198],[109,163,185],[82,122,142],[78,114,131],[93,131,151],[123,173,195],[124,180,204],[126,183,205],[129,182,205],[127,183,203],[125,182,201],[134,182,202],[168,192,211],[186,201,218],[187,202,218],[185,200,216],[187,201,216],[195,203,219],[197,205,221],[192,203,220],[184,199,215],[181,198,214],[144,181,199],[118,170,190],[117,173,194],[119,175,196],[122,176,198],[121,175,197],[120,176,197],[122,176,198],[122,176,197],[122,177,197],[121,176,197],[122,176,196],[122,177,197],[122,177,197],[121,176,197],[123,175,196],[122,174,196],[123,174,196],[123,174,195],[125,175,196],[128,174,195],[155,180,194],[163,180,191],[171,153,145],[176,143,126],[170,134,113],[166,124,104],[155,106,91],[150,97,85],[145,93,80],[143,93,79],[139,96,82],[132,103,96],[135,117,116],[152,137,138],[170,154,153],[170,150,147],[172,137,126],[170,130,115],[166,122,105],[165,116,97],[162,110,90],[159,105,87],[153,96,76],[151,95,72],[153,95,72],[153,95,72],[155,96,73],[154,97,72],[158,101,74],[162,104,78],[162,104,76],[163,106,78],[164,107,79],[163,106,78],[164,107,78],[169,112,84],[170,113,84],[170,114,85],[171,114,85],[171,113,85],[168,112,80],[168,112,79],[169,112,80],[170,114,83],[169,112,82],[168,112,81],[168,109,79],[169,110,80],[171,111,82],[166,108,80],[160,102,76],[156,98,72],[153,96,70],[152,94,70],[150,93,69],[147,92,69],[145,93,72],[147,94,73],[149,97,77],[151,102,84],[152,100,80],[153,106,87],[156,116,101],[160,126,114],[165,140,129],[168,150,142],[169,148,142],[169,151,146],[165,153,148],[118,98,98],[120,94,91],[119,173,192],[117,171,191],[117,171,190],[117,171,190],[117,171,190],[118,172,191],[117,172,190],[114,173,192],[106,166,187],[87,144,170],[72,124,155],[72,123,155],[77,128,155],[78,130,156],[74,123,152],[69,117,148],[69,119,151],[72,123,153],[66,122,151],[62,121,149],[75,134,160],[105,166,187],[122,177,197],[122,177,197],[121,175,195],[122,177,197],[123,178,197],[122,177,197],[122,176,197],[121,176,196],[121,176,196],[120,177,196],[119,177,196],[121,178,197],[123,179,199],[125,179,199],[124,178,198],[122,178,197],[121,178,197],[122,178,198],[119,176,196],[119,177,196],[120,177,196],[121,177,197],[121,178,197],[122,179,198],[124,179,200],[125,180,200],[126,180,200],[127,180,200],[127,181,200],[127,181,201],[129,183,202],[126,182,202],[128,182,201],[129,182,200],[128,180,201],[129,181,201],[129,182,201],[130,182,202],[129,182,203],[130,182,203],[128,183,203],[128,183,203],[127,183,203],[125,181,201],[126,182,202],[128,182,203],[128,182,204],[127,182,203],[127,182,203],[127,183,203],[129,183,204],[130,184,205],[131,184,205],[133,184,205],[133,184,205],[136,185,207],[134,186,207],[131,186,206],[131,186,206],[131,185,205],[129,184,204],[129,184,204],[129,184,204],[131,183,204],[134,184,206],[132,183,204],[131,183,203],[131,183,204],[129,182,203],[130,181,202],[129,179,201],[127,178,200],[126,178,199],[127,178,200],[127,179,201],[128,179,201],[129,180,201],[130,180,202],[129,181,202],[129,180,203],[127,179,203],[126,178,201],[124,179,201],[124,176,198],[122,171,193],[122,174,194],[127,180,202],[129,180,202],[128,179,201],[129,180,203],[129,180,204],[128,179,203],[130,182,205],[130,182,205],[127,182,204],[128,181,204],[129,183,204],[130,184,205],[128,183,204],[128,184,206],[128,183,205],[129,182,204],[128,180,202],[126,180,202],[124,179,201],[123,178,200],[122,177,200],[119,175,198],[117,170,192],[118,170,191],[126,176,198],[128,181,203],[126,181,203],[126,183,204],[128,183,205],[128,183,204],[130,183,205],[130,182,203],[139,181,200],[165,190,208],[181,198,214],[190,202,218],[194,204,219],[196,206,221],[200,207,223],[195,204,221],[179,198,215],[149,183,202],[119,171,191],[119,174,195],[120,175,196],[122,176,198],[123,176,198],[122,175,197],[119,176,196],[120,175,196],[122,176,197],[123,177,197],[121,176,197],[123,176,197],[123,177,197],[121,175,196],[121,176,196],[121,175,196],[120,174,195],[123,174,196],[122,174,193],[122,173,193],[130,175,194],[148,177,193],[164,175,184],[169,144,137],[163,134,125],[159,124,114],[153,115,104],[145,105,93],[137,99,89],[128,97,92],[129,107,103],[137,122,118],[145,131,127],[146,130,126],[144,124,119],[142,116,108],[141,120,117],[143,127,123],[163,147,145],[166,130,117],[163,123,108],[163,119,100],[162,114,94],[162,111,93],[157,107,88],[154,100,79],[154,99,78],[154,98,77],[153,97,75],[154,98,75],[154,98,74],[153,96,72],[157,98,76],[156,100,79],[157,101,78],[158,100,78],[157,100,77],[156,100,76],[156,101,75],[155,99,74],[156,100,73],[157,100,76],[155,99,76],[156,100,77],[157,100,76],[159,100,75],[159,100,76],[156,100,75],[153,99,75],[153,99,78],[154,102,82],[151,99,81],[151,105,89],[153,113,100],[154,121,110],[156,132,124],[159,144,139],[164,140,132],[164,146,138],[118,173,193],[119,172,193],[119,173,193],[118,173,193],[118,173,192],[117,172,191],[117,173,191],[118,173,193],[113,171,191],[109,166,189],[92,148,174],[80,135,162],[76,130,159],[76,130,158],[73,125,155],[70,122,153],[72,125,157],[73,129,160],[76,135,163],[83,144,168],[107,165,187],[121,176,196],[125,179,199],[124,178,199],[124,178,198],[123,177,197],[124,178,198],[124,179,199],[125,179,198],[123,178,197],[123,177,197],[120,177,197],[119,177,196],[122,179,198],[124,179,199],[125,179,200],[123,178,198],[123,177,197],[124,178,198],[123,178,197],[121,177,198],[119,176,198],[119,177,196],[120,177,196],[121,178,197],[124,180,199],[124,179,199],[125,180,200],[127,181,201],[128,181,201],[127,181,201],[128,181,200],[129,183,202],[128,182,202],[128,181,202],[128,181,201],[128,181,201],[128,181,201],[129,183,203],[128,182,202],[128,183,203],[128,183,203],[128,183,203],[128,182,203],[126,182,202],[126,182,202],[126,182,203],[127,182,203],[130,184,204],[130,182,203],[127,182,203],[126,182,202],[127,182,203],[128,184,205],[131,184,205],[133,184,206],[134,185,207],[135,186,208],[135,186,207],[130,186,206],[130,187,206],[130,185,205],[130,184,205],[128,183,203],[128,184,204],[131,184,205],[132,184,204],[133,184,204],[131,184,204],[129,183,203],[129,182,203],[129,181,202],[127,180,201],[128,179,202],[126,179,201],[128,178,201],[126,178,200],[128,179,201],[131,180,202],[133,181,203],[132,180,202],[131,180,202],[130,179,202],[128,179,202],[125,180,201],[123,178,199],[122,176,198],[125,178,200],[126,179,201],[128,181,202],[129,180,203],[128,179,203],[129,180,204],[128,180,203],[128,182,204],[127,181,204],[129,182,204],[128,182,204],[128,184,204],[131,184,204],[130,185,206],[130,185,206],[130,183,206],[128,181,204],[128,180,203],[125,180,202],[124,179,201],[122,178,200],[126,178,202],[124,178,201],[122,176,199],[121,178,200],[127,179,202],[128,182,204],[127,182,203],[127,183,203],[126,182,203],[128,184,204],[128,183,204],[130,183,203],[130,182,203],[130,180,201],[136,182,200],[150,188,204],[159,191,208],[174,196,213],[169,194,211],[159,187,207],[136,176,197],[120,172,194],[119,176,197],[120,175,197],[122,176,199],[123,176,198],[123,177,198],[120,176,197],[120,175,197],[122,176,197],[121,176,196],[122,176,196],[123,177,197],[123,176,197],[123,176,197],[121,176,197],[121,175,196],[119,175,196],[119,173,194],[118,173,195],[118,173,194],[119,173,194],[124,173,191],[129,172,191],[140,168,183],[146,164,176],[149,161,170],[149,159,167],[145,156,164],[138,118,114],[134,108,99],[130,108,102],[128,110,108],[137,123,120],[142,127,124],[144,125,119],[141,112,101],[141,108,98],[137,108,102],[117,124,130],[110,131,144],[128,146,158],[137,148,159],[138,149,157],[140,148,155],[166,140,131],[169,136,123],[170,134,119],[166,129,112],[166,127,112],[167,127,111],[161,116,100],[158,110,92],[158,112,93],[158,112,93],[161,115,98],[160,115,99],[160,113,96],[157,105,84],[157,106,85],[158,107,86],[159,110,89],[162,117,100],[164,122,106],[157,112,97],[156,111,97],[159,120,104],[159,125,112],[160,132,122],[161,137,131],[163,139,133],[165,139,133],[166,147,142],[141,152,157],[140,150,156],[136,149,156],[128,112,108],[132,116,113],[117,124,131],[115,121,129],[113,119,127],[112,117,124],[118,123,132],[120,174,194],[121,174,195],[121,175,194],[120,175,192],[119,174,193],[117,173,191],[119,173,193],[119,174,194],[119,174,195],[117,173,194],[107,168,191],[95,155,180],[85,147,173],[83,146,172],[79,140,166],[78,139,166],[84,146,171],[89,150,176],[100,159,184],[113,171,192],[122,176,196],[124,178,199],[125,179,199],[125,179,199],[124,178,198],[124,178,198],[124,178,199],[124,180,199],[123,179,198],[124,179,198],[122,178,198],[120,178,197],[120,178,197],[122,179,198],[125,179,200],[124,180,200],[124,179,199],[123,179,197],[124,179,199],[123,178,198],[122,177,197],[119,177,196],[121,178,197],[121,178,197],[123,179,198],[123,179,198],[125,179,200],[127,179,201],[128,181,201],[128,181,202],[128,180,202],[128,181,202],[129,182,202],[128,182,201],[127,182,201],[128,181,201],[128,182,200],[128,181,202],[129,183,203],[128,183,203],[129,184,204],[130,184,204],[130,184,204],[130,184,204],[128,182,204],[127,183,204],[126,182,203],[128,183,204],[128,182,204],[129,183,204],[129,184,204],[128,182,203],[129,183,203],[130,185,205],[130,185,205],[131,185,206],[133,185,207],[133,186,207],[132,185,206],[131,186,206],[133,186,207],[133,185,206],[134,185,205],[132,184,204],[130,183,204],[131,185,205],[132,184,203],[133,184,204],[130,183,203],[128,183,203],[127,182,203],[128,181,202],[128,180,202],[128,180,201],[127,179,202],[127,180,200],[126,180,200],[128,179,202],[131,180,202],[132,180,203],[133,181,203],[131,180,202],[132,179,202],[128,179,201],[128,180,202],[127,180,202],[123,179,200],[123,178,200],[124,179,200],[126,180,202],[128,180,203],[128,180,204],[128,180,204],[127,181,203],[127,182,204],[127,182,204],[128,182,204],[127,182,204],[128,182,204],[131,184,205],[130,183,205],[131,184,206],[130,183,206],[129,182,204],[126,182,204],[126,181,203],[124,179,202],[124,179,201],[125,179,202],[121,179,200],[123,178,199],[122,179,200],[125,180,202],[126,181,203],[127,183,204],[128,183,203],[127,183,203],[128,184,203],[127,183,203],[130,183,203],[131,183,204],[127,182,204],[121,180,200],[121,176,197],[125,175,195],[127,176,197],[124,175,196],[124,176,196],[121,174,196],[120,177,198],[122,178,200],[122,177,199],[122,177,199],[120,177,197],[122,177,197],[122,176,198],[121,175,198],[123,177,197],[122,176,198],[122,176,198],[124,176,197],[124,177,198],[122,176,197],[122,175,197],[121,174,197],[118,173,195],[117,172,193],[118,173,195],[119,173,194],[118,173,194],[121,173,194],[120,170,190],[123,168,186],[127,166,183],[127,162,178],[126,160,175],[124,158,173],[128,155,168],[133,153,166],[133,150,162],[133,145,156],[134,144,155],[135,143,153],[132,139,148],[130,136,145],[144,132,128],[148,122,117],[146,116,110],[107,116,128],[101,122,137],[110,147,161],[114,151,166],[115,151,166],[115,149,164],[119,150,163],[119,149,162],[124,147,160],[132,148,160],[133,147,158],[136,149,158],[142,150,158],[166,152,148],[167,152,148],[166,153,146],[165,153,148],[168,153,149],[168,149,142],[167,151,144],[166,152,146],[172,155,154],[144,153,161],[141,150,156],[136,149,157],[132,149,158],[128,150,158],[124,148,158],[121,150,158],[123,151,158],[119,149,158],[118,148,158],[124,148,157],[122,128,136],[114,122,131],[107,118,129],[106,119,130],[105,119,130],[105,121,133],[108,122,132],[110,124,135],[112,130,140],[121,175,193],[120,174,194],[121,174,194],[119,174,194],[120,174,195],[121,174,195],[120,174,194],[121,174,195],[121,175,194],[120,174,194],[116,173,193],[116,173,194],[116,173,195],[114,171,193],[114,171,192],[110,169,192],[111,170,192],[115,172,193],[120,175,196],[123,178,198],[122,177,196],[126,179,200],[126,179,199],[124,178,198],[123,178,198],[123,179,198],[125,180,199],[124,180,198],[122,179,198],[122,179,198],[122,179,198],[121,179,198],[123,179,198],[123,179,198],[124,180,200],[124,179,199],[124,179,200],[124,178,198],[124,178,199],[124,179,200],[124,179,199],[123,178,198],[121,179,198],[122,179,198],[124,178,199],[125,179,200],[125,180,200],[124,180,200],[128,181,201],[129,182,203],[128,181,202],[128,181,202],[128,183,202],[126,182,202],[126,182,202],[125,181,201],[127,182,201],[128,182,203],[130,184,204],[128,184,204],[129,185,204],[130,185,205],[129,185,204],[129,185,204],[127,183,203],[127,183,204],[127,184,204],[126,183,203],[127,184,203],[127,184,204],[129,184,204],[128,183,204],[128,182,204],[131,185,206],[131,185,206],[131,186,205],[130,185,205],[130,184,204],[131,186,206],[131,186,206],[133,185,207],[133,185,206],[133,186,205],[132,184,203],[131,185,204],[131,184,205],[130,184,204],[131,183,204],[129,183,202],[127,182,203],[128,182,203],[128,181,203],[127,180,201],[127,180,202],[128,180,202],[128,180,201],[128,180,202],[127,178,201],[128,179,201],[130,181,203],[130,181,202],[128,179,201],[130,179,201],[130,180,201],[128,180,201],[127,180,202],[126,179,201],[125,178,200],[126,179,202],[127,179,202],[127,180,202],[128,180,202],[127,179,203],[128,181,204],[126,181,203],[127,182,203],[129,182,204],[129,182,204],[131,183,204],[131,184,205],[130,183,206],[129,184,205],[128,183,205],[129,182,205],[127,182,204],[127,182,203],[128,181,203],[124,179,202],[124,179,202],[123,178,201],[123,179,201],[124,181,201],[125,180,202],[124,182,202],[126,182,204],[127,183,205],[128,183,205],[128,184,205],[128,184,206],[127,183,204],[130,184,205],[131,184,206],[128,182,203],[124,180,202],[122,177,200],[122,177,199],[123,178,199],[126,179,201],[126,179,200],[125,180,201],[125,180,201],[125,180,201],[125,179,200],[122,177,198],[122,177,198],[122,177,197],[121,177,198],[122,176,199],[122,176,198],[122,175,196],[121,175,196],[123,177,197],[123,177,197],[121,174,197],[118,172,194],[109,162,183],[101,154,175],[91,144,165],[88,141,162],[96,151,171],[106,160,181],[108,164,184],[112,169,189],[114,169,189],[115,168,188],[116,166,186],[116,163,181],[115,161,180],[114,160,178],[113,158,176],[115,158,175],[113,155,170],[115,153,169],[118,149,164],[116,146,161],[116,142,157],[115,137,151],[116,133,146],[116,130,143],[120,128,139],[119,127,138],[122,128,139],[114,124,136],[101,127,143],[98,150,167],[103,157,173],[104,157,175],[105,156,174],[107,156,173],[110,155,171],[111,154,171],[111,152,169],[111,152,168],[110,151,167],[111,150,166],[113,150,166],[116,150,164],[118,150,162],[118,149,161],[121,149,161],[125,152,164],[122,150,163],[130,151,162],[137,151,160],[140,153,161],[140,153,161],[142,154,161],[144,155,162],[146,156,162],[148,158,164],[144,156,163],[148,157,164],[147,159,165],[147,159,167],[143,155,164],[137,154,164],[134,153,162],[136,155,163],[132,152,163],[128,153,163],[121,151,161],[117,149,161],[116,149,164],[114,149,163],[113,149,161],[111,148,161],[111,149,162],[108,150,163],[108,151,163],[111,153,166],[111,153,165],[112,153,164],[113,153,165],[112,154,167],[118,155,166],[127,153,164],[131,148,156],[134,146,154],[133,146,156],[129,143,152],[124,139,148],[117,133,145],[110,128,139],[108,124,133],[106,123,136],[103,127,140],[101,131,145],[98,134,150],[102,139,155],[102,139,154],[106,141,156],[106,146,161],[121,175,194],[121,175,193],[121,175,193],[120,175,194],[118,174,194],[121,174,194],[120,174,194],[120,175,194],[122,175,195],[122,175,196],[121,175,195],[119,174,194],[120,174,195],[119,173,194],[118,173,193],[115,172,192],[116,172,192],[117,174,193],[123,177,196],[123,177,197],[123,177,197],[124,178,198],[125,178,199],[126,178,199],[124,179,199],[124,179,199],[126,180,199],[124,180,199],[124,179,198],[121,177,197],[121,178,197],[122,179,198],[122,178,198],[123,179,199],[126,180,201],[126,181,200],[125,180,200],[125,179,200],[125,179,200],[126,180,200],[123,179,199],[122,178,198],[120,178,197],[124,179,199],[126,179,200],[125,179,199],[125,179,200],[125,181,201],[128,181,201],[129,182,203],[127,182,202],[129,182,203],[128,182,202],[128,182,203],[126,182,203],[126,181,201],[127,182,202],[126,182,202],[130,184,204],[128,183,203],[128,184,204],[129,184,204],[131,185,205],[130,185,207],[128,184,205],[128,184,204],[131,185,205],[130,185,205],[129,184,204],[128,184,203],[128,184,204],[128,183,203],[129,183,204],[130,185,204],[132,186,206],[131,186,206],[132,186,206],[133,186,207],[130,186,206],[133,186,207],[134,185,207],[134,186,207],[134,185,204],[132,183,202],[131,185,204],[133,185,206],[133,184,205],[133,184,205],[132,184,205],[129,183,203],[129,183,203],[130,183,204],[128,181,202],[128,179,201],[129,180,202],[129,180,202],[128,180,202],[129,181,203],[130,181,203],[129,181,202],[130,180,203],[130,181,203],[129,180,202],[128,180,202],[128,179,201],[127,179,201],[128,179,201],[126,178,201],[126,179,202],[125,179,200],[125,180,201],[125,179,201],[125,180,202],[125,180,201],[125,180,202],[127,181,203],[129,182,204],[130,183,205],[131,184,205],[131,184,207],[129,184,207],[131,184,206],[129,184,207],[127,183,205],[128,182,205],[128,182,203],[127,182,205],[124,180,202],[124,179,202],[124,179,201],[125,179,202],[127,180,202],[129,180,203],[127,182,203],[126,181,203],[127,183,205],[127,183,205],[127,183,205],[127,183,205],[127,183,204],[129,185,205],[130,185,206],[127,182,204],[125,180,203],[124,179,202],[125,179,202],[127,180,203],[128,181,202],[126,180,201],[127,180,201],[128,180,201],[128,180,201],[126,178,200],[124,177,200],[123,177,199],[121,177,197],[122,176,199],[122,176,199],[121,176,199],[120,176,198],[117,175,196],[122,177,197],[123,178,198],[118,170,191],[91,145,165],[72,120,147],[67,113,142],[64,110,138],[64,109,136],[65,113,139],[66,115,142],[72,124,148],[91,149,169],[109,168,189],[115,172,194],[116,171,192],[114,169,190],[113,168,189],[112,168,188],[110,168,188],[110,168,189],[107,165,185],[108,164,183],[110,160,179],[106,158,178],[105,157,178],[104,154,175],[103,154,173],[102,150,167],[103,140,154],[105,137,151],[106,131,149],[105,126,142],[109,127,142],[110,130,144],[104,122,137],[103,131,147],[99,156,174],[102,161,179],[104,163,181],[105,162,181],[106,162,181],[106,161,179],[105,160,179],[105,160,179],[103,159,179],[103,157,177],[101,156,173],[102,155,170],[103,152,169],[104,152,168],[105,151,168],[105,151,168],[105,152,169],[105,151,167],[110,151,167],[111,152,168],[112,152,168],[111,152,168],[112,152,168],[115,155,168],[118,155,168],[120,153,165],[120,154,166],[119,154,165],[121,154,165],[120,154,167],[121,155,168],[124,157,168],[123,157,168],[118,155,168],[117,155,166],[116,154,165],[114,153,166],[113,153,166],[112,152,163],[111,150,164],[107,149,163],[106,151,165],[104,152,166],[103,151,167],[105,151,168],[102,152,167],[102,152,166],[105,151,167],[104,154,167],[107,155,169],[108,156,170],[110,157,171],[111,156,171],[112,158,171],[112,158,172],[112,158,172],[120,157,170],[126,155,165],[129,153,164],[126,150,161],[117,145,157],[112,142,156],[109,141,155],[108,139,152],[103,138,152],[103,143,157],[100,147,162],[99,150,165],[100,152,169],[102,154,172],[100,153,170],[102,154,170],[104,156,173],[120,174,193],[120,174,193],[121,175,194],[120,175,194],[119,174,195],[121,174,194],[120,174,194],[120,174,194],[121,174,195],[122,175,196],[120,175,195],[118,174,193],[118,173,194],[120,173,194],[116,172,192],[116,172,193],[117,173,193],[120,175,195],[123,177,197],[123,177,197],[122,177,197],[122,178,198],[122,179,198],[124,179,198],[124,179,198],[124,179,199],[126,179,200],[124,180,200],[121,178,198],[122,179,198],[122,179,198],[124,180,199],[122,179,198],[125,179,199],[126,181,200],[127,180,201],[126,179,200],[125,179,200],[125,179,200],[126,179,200],[123,179,198],[120,178,197],[122,178,197],[124,179,199],[123,179,197],[123,179,197],[124,180,200],[126,181,201],[127,181,202],[128,181,201],[129,182,203],[129,182,202],[128,182,202],[127,181,202],[127,182,202],[125,181,201],[127,182,202],[128,182,204],[129,183,204],[129,183,203],[128,184,204],[129,185,205],[131,187,206],[129,185,206],[131,184,206],[130,184,204],[131,185,205],[130,184,205],[129,185,205],[130,185,205],[129,184,204],[129,184,204],[128,184,204],[130,184,203],[131,185,206],[131,185,205],[131,185,206],[133,186,207],[132,186,206],[132,185,206],[134,186,206],[135,186,207],[133,185,206],[132,183,204],[131,185,204],[130,184,203],[131,183,205],[132,183,205],[132,183,204],[131,183,203],[131,184,204],[129,182,203],[127,180,202],[127,180,202],[128,181,203],[128,181,202],[129,182,203],[130,182,203],[131,183,204],[130,182,203],[129,180,203],[129,180,203],[129,180,203],[128,179,201],[129,179,202],[127,179,201],[126,179,202],[127,178,201],[126,179,201],[125,179,201],[124,180,202],[125,181,202],[124,180,201],[124,179,201],[124,180,201],[126,181,202],[128,182,203],[130,183,204],[132,185,206],[132,185,206],[131,185,206],[129,184,205],[130,184,206],[130,184,205],[128,183,203],[127,183,203],[126,182,204],[127,181,203],[126,180,203],[125,180,202],[126,181,203],[127,181,203],[127,182,203],[129,182,203],[127,183,203],[127,183,203],[128,183,204],[128,184,204],[127,183,203],[128,184,204],[129,184,205],[129,182,205],[128,183,205],[125,181,203],[125,180,202],[126,180,202],[127,180,203],[128,181,203],[129,182,204],[129,182,202],[128,180,203],[128,181,202],[126,179,200],[124,178,200],[124,178,200],[123,177,200],[123,177,199],[122,177,199],[121,176,198],[119,176,197],[117,176,197],[120,178,197],[118,176,196],[91,148,169],[63,114,142],[61,111,141],[61,109,140],[62,109,138],[61,107,136],[61,108,138],[60,110,140],[62,110,140],[71,118,145],[99,157,178],[118,174,194],[118,174,194],[117,173,193],[115,172,193],[115,171,191],[115,171,192],[115,171,192],[111,168,189],[109,167,188],[110,167,189],[107,165,185],[106,165,186],[104,162,184],[102,162,183],[100,160,180],[99,158,177],[102,157,176],[102,153,172],[101,149,167],[103,144,163],[105,137,155],[104,133,150],[99,141,160],[101,159,178],[104,163,184],[106,164,184],[109,165,186],[108,165,184],[108,165,184],[109,164,187],[108,164,186],[106,164,185],[105,163,184],[104,161,181],[100,159,177],[99,159,178],[99,158,176],[100,156,175],[99,155,174],[98,156,173],[100,155,172],[101,155,173],[102,154,174],[102,155,174],[102,155,172],[102,155,171],[106,156,172],[107,157,173],[106,156,171],[105,156,170],[106,156,171],[108,158,172],[109,158,172],[111,157,171],[109,156,170],[109,157,170],[109,157,171],[107,157,170],[108,156,170],[106,156,171],[104,154,169],[105,155,169],[103,155,170],[101,156,169],[102,156,170],[103,156,173],[102,157,172],[104,155,170],[104,155,170],[105,156,171],[105,155,170],[107,157,172],[109,158,173],[109,158,171],[110,158,172],[113,160,173],[113,159,173],[113,160,174],[114,160,176],[114,158,173],[117,156,170],[121,155,168],[114,151,165],[108,148,163],[106,149,164],[104,149,165],[101,148,163],[101,151,168],[103,154,172],[103,157,173],[103,158,173],[105,158,175],[105,158,175],[105,158,176],[105,159,177],[107,163,179],[118,173,192],[119,174,192],[120,174,194],[119,175,195],[118,174,194],[121,175,194],[120,174,193],[120,174,194],[121,174,194],[122,175,196],[120,175,195],[119,174,195],[119,173,194],[120,174,195],[119,174,195],[119,174,196],[120,174,196],[120,176,196],[122,177,197],[123,177,197],[122,177,197],[121,177,197],[122,177,197],[122,178,197],[123,179,198],[123,179,198],[125,179,200],[126,180,201],[122,179,199],[123,179,199],[123,179,199],[123,179,199],[124,179,199],[127,180,200],[127,180,201],[128,181,201],[127,181,200],[126,179,200],[126,179,200],[126,179,200],[125,179,200],[121,179,198],[122,179,198],[124,178,199],[123,179,198],[122,179,196],[123,180,199],[124,180,200],[128,181,201],[128,182,201],[128,182,201],[126,181,202],[127,181,202],[125,181,201],[126,181,201],[125,181,201],[127,182,203],[128,184,204],[127,182,203],[128,183,203],[129,184,205],[129,184,205],[130,186,206],[130,186,206],[130,186,205],[132,185,206],[130,185,206],[131,185,206],[130,185,206],[130,185,206],[130,185,205],[129,184,204],[128,184,204],[129,184,204],[130,184,204],[129,185,205],[130,184,205],[130,185,206],[131,185,206],[133,185,207],[134,185,207],[133,186,207],[133,184,205],[133,184,205],[134,185,207],[132,184,206],[133,184,205],[133,184,205],[131,184,204],[130,182,202],[130,183,203],[129,182,203],[127,181,202],[127,181,202],[128,181,202],[128,181,202],[130,181,204],[130,181,203],[130,181,204],[130,181,203],[128,180,203],[129,180,203],[128,180,203],[126,180,202],[127,180,201],[125,179,201],[127,178,202],[125,179,202],[125,179,200],[125,180,202],[124,179,202],[124,180,202],[123,178,201],[122,177,199],[123,178,200],[123,178,201],[126,181,203],[128,183,203],[131,185,206],[132,186,207],[131,185,205],[131,184,206],[131,184,206],[130,184,205],[128,183,203],[126,182,204],[126,181,203],[126,179,202],[126,180,203],[126,181,203],[127,181,204],[126,181,203],[127,181,204],[129,182,205],[127,183,203],[127,183,203],[127,183,203],[129,185,205],[129,184,204],[130,184,204],[129,183,205],[129,182,205],[129,182,205],[125,181,203],[125,180,202],[125,181,202],[126,181,201],[127,180,201],[128,181,202],[129,182,203],[129,183,203],[128,182,203],[127,180,202],[124,179,201],[123,178,200],[122,178,200],[121,177,199],[121,177,198],[120,177,199],[121,177,199],[119,175,196],[121,176,197],[118,175,195],[83,140,163],[61,112,141],[61,112,141],[58,109,137],[67,119,147],[68,121,151],[62,111,143],[60,107,139],[60,110,142],[62,111,141],[76,132,156],[111,169,190],[119,175,195],[119,175,195],[117,173,193],[117,173,195],[117,173,195],[115,172,194],[113,171,192],[114,171,191],[111,169,189],[111,169,190],[111,168,190],[108,167,188],[108,167,187],[105,165,186],[105,165,185],[103,164,185],[102,162,184],[98,160,182],[96,159,178],[99,154,173],[101,153,170],[100,156,177],[103,162,183],[104,165,185],[106,166,186],[108,166,188],[110,166,187],[109,165,188],[108,166,188],[109,167,188],[107,167,188],[104,165,185],[102,162,182],[103,162,182],[103,162,181],[102,162,182],[104,162,181],[102,161,180],[100,160,178],[100,159,177],[98,159,177],[100,159,180],[100,159,180],[100,160,180],[102,161,180],[103,160,178],[104,162,181],[103,162,180],[101,160,177],[106,162,179],[106,163,179],[106,162,178],[106,161,178],[106,161,176],[108,162,177],[107,162,177],[109,161,177],[110,161,175],[109,160,175],[107,159,175],[108,159,175],[106,160,175],[106,159,175],[106,161,175],[107,161,178],[107,160,178],[105,159,175],[109,158,175],[109,158,174],[108,157,173],[107,159,173],[109,159,175],[109,160,174],[110,160,175],[112,160,175],[110,160,175],[113,161,175],[114,161,177],[111,161,175],[113,159,175],[110,159,173],[107,156,172],[105,156,172],[103,156,174],[102,157,175],[102,158,175],[105,159,177],[107,161,179],[109,161,180],[108,162,180],[108,162,180],[107,161,179],[109,162,180],[110,162,181],[107,164,181],[117,172,192],[119,172,192],[120,173,194],[116,174,193],[118,174,193],[120,176,194],[121,175,194],[122,176,196],[122,176,195],[123,178,197],[123,177,196],[122,176,196],[120,175,196],[122,176,197],[122,177,197],[120,175,196],[122,176,197],[124,177,199],[124,177,198],[124,177,200],[124,178,198],[123,177,197],[123,177,198],[123,178,198],[125,179,199],[124,178,200],[124,180,200],[124,180,200],[124,180,200],[124,179,199],[123,179,199],[124,180,200],[125,179,200],[126,180,199],[127,180,200],[127,181,200],[127,181,201],[127,180,201],[126,179,200],[125,180,200],[122,179,198],[123,180,199],[123,178,198],[125,179,200],[122,178,197],[124,179,198],[124,180,200],[125,180,200],[128,182,202],[129,182,202],[128,182,201],[128,182,201],[125,181,201],[126,180,201],[126,182,201],[125,181,201],[127,182,203],[129,185,204],[129,183,204],[130,183,203],[131,184,204],[130,184,206],[130,185,207],[131,187,207],[131,187,207],[132,186,207],[130,185,205],[129,186,206],[132,186,207],[131,185,207],[130,185,207],[130,185,205],[128,184,204],[129,184,205],[129,185,204],[129,185,205],[129,185,204],[130,185,205],[131,184,205],[131,185,206],[132,186,206],[132,186,207],[131,185,206],[131,185,206],[132,184,205],[131,184,205],[131,184,204],[131,185,205],[130,184,204],[129,182,203],[130,182,203],[131,182,203],[129,180,202],[129,181,202],[129,181,202],[129,182,202],[131,182,203],[130,182,204],[128,180,203],[129,180,203],[129,180,204],[129,180,203],[127,180,203],[127,180,201],[127,180,201],[127,180,201],[126,179,201],[124,178,201],[124,178,201],[125,180,202],[125,181,202],[121,180,201],[122,178,200],[121,177,199],[122,177,200],[123,178,201],[126,181,203],[126,182,204],[130,185,205],[132,185,206],[132,186,208],[132,185,207],[131,184,207],[130,184,206],[129,182,205],[127,183,204],[126,181,203],[126,181,203],[126,180,203],[125,180,203],[127,181,203],[127,182,204],[127,183,205],[129,183,205],[127,184,204],[128,184,205],[129,184,205],[130,184,205],[131,185,205],[131,185,205],[130,184,205],[130,184,206],[128,183,206],[126,181,204],[126,180,203],[125,181,202],[125,181,203],[126,181,203],[129,182,203],[129,182,203],[129,182,203],[129,182,202],[125,180,202],[126,180,202],[125,180,202],[123,178,200],[123,178,199],[120,176,198],[121,177,199],[122,176,198],[120,177,197],[119,177,198],[116,174,194],[87,140,166],[61,110,142],[62,111,141],[64,115,142],[95,151,174],[95,155,175],[72,126,154],[54,105,136],[58,108,139],[60,110,141],[82,137,161],[116,171,193],[119,174,196],[120,175,195],[118,173,195],[117,173,193],[118,174,196],[116,172,193],[114,170,192],[115,171,192],[113,172,192],[114,170,191],[110,168,190],[110,168,189],[111,169,190],[111,168,190],[110,168,190],[108,167,189],[108,166,188],[108,165,188],[100,163,184],[99,161,183],[107,163,184],[108,164,185],[109,166,188],[107,166,188],[108,168,189],[107,166,187],[111,168,188],[111,167,189],[109,167,188],[109,167,189],[108,168,189],[105,166,186],[104,165,185],[105,165,186],[106,165,186],[106,163,185],[106,163,184],[106,164,183],[105,163,182],[104,162,181],[102,163,180],[102,164,180],[103,163,181],[103,164,183],[106,164,183],[106,164,184],[107,165,184],[106,165,183],[107,165,182],[109,165,183],[110,167,185],[108,165,182],[110,167,184],[110,165,183],[112,166,184],[112,165,183],[112,166,182],[112,164,180],[112,164,180],[111,163,179],[110,162,178],[110,161,178],[111,163,179],[109,162,178],[110,161,178],[109,161,178],[109,161,178],[109,160,177],[111,162,177],[110,160,175],[107,159,175],[108,160,174],[110,159,175],[111,160,175],[113,161,177],[113,161,177],[112,161,176],[111,161,176],[112,162,179],[112,162,177],[110,161,177],[108,161,177],[108,162,179],[105,161,179],[105,162,179],[106,163,180],[109,163,181],[109,163,181],[109,164,183],[110,165,185],[110,164,183],[107,163,181],[108,164,183],[109,164,182],[110,165,182],[118,174,193],[117,174,194],[117,173,193],[119,175,194],[120,175,193],[121,176,195],[121,176,195],[121,176,196],[122,176,196],[123,177,197],[123,177,197],[121,176,197],[121,176,196],[121,176,196],[120,176,196],[120,176,196],[123,177,197],[124,178,198],[123,177,198],[124,178,199],[124,178,199],[122,177,197],[122,178,198],[124,179,199],[125,180,200],[126,179,200],[125,180,200],[123,179,198],[124,179,200],[124,180,199],[124,179,199],[123,179,199],[125,180,200],[128,182,200],[127,180,200],[127,181,200],[127,180,201],[126,180,200],[127,180,201],[124,180,200],[124,179,200],[125,181,201],[124,179,199],[124,178,198],[124,179,199],[124,179,199],[124,179,199],[125,179,200],[126,180,200],[128,181,201],[128,181,202],[128,181,202],[125,181,201],[126,180,201],[127,181,201],[124,181,201],[126,182,202],[128,184,202],[129,183,203],[130,184,203],[130,184,202],[131,185,204],[130,186,205],[130,186,206],[130,186,206],[131,185,205],[132,186,205],[130,186,205],[131,186,207],[130,185,207],[130,185,207],[130,185,205],[129,184,206],[128,184,206],[128,183,203],[130,185,204],[129,184,205],[130,185,206],[130,185,205],[131,185,205],[132,186,207],[132,185,207],[131,185,206],[131,184,205],[131,184,205],[130,184,204],[130,184,204],[131,184,205],[130,184,204],[128,182,203],[132,183,204],[130,181,203],[129,180,202],[129,181,202],[129,181,202],[130,181,203],[129,182,203],[128,181,202],[127,181,202],[128,181,202],[128,180,202],[129,180,203],[126,181,201],[126,180,201],[126,180,201],[127,180,201],[125,179,201],[123,178,200],[124,179,200],[124,180,201],[124,180,202],[124,179,201],[123,178,200],[122,178,200],[123,177,199],[123,178,200],[124,180,202],[126,182,204],[129,184,206],[133,186,207],[132,185,206],[131,185,207],[132,185,208],[131,184,207],[130,183,206],[128,182,204],[126,181,203],[124,180,202],[126,180,203],[125,180,203],[126,181,202],[128,181,204],[127,182,204],[129,183,204],[130,184,206],[130,184,206],[130,184,206],[131,184,205],[131,184,206],[133,186,208],[131,185,206],[129,184,205],[126,181,204],[126,180,203],[126,179,202],[125,181,203],[126,180,203],[127,181,203],[130,181,205],[132,183,205],[131,182,205],[130,182,203],[128,181,202],[126,180,203],[126,180,201],[125,179,200],[124,178,201],[123,177,200],[122,177,199],[124,177,198],[123,178,198],[123,177,198],[114,174,193],[83,137,162],[62,111,143],[61,110,144],[61,110,141],[73,121,148],[72,124,149],[64,116,143],[56,107,138],[58,108,140],[62,114,143],[104,158,179],[120,174,196],[121,174,197],[118,174,195],[117,172,195],[118,174,195],[119,174,195],[118,173,195],[118,173,194],[116,172,194],[115,171,192],[114,170,192],[113,170,191],[113,170,191],[112,170,191],[113,171,192],[113,171,192],[112,170,191],[110,168,189],[110,167,190],[109,167,188],[107,166,187],[111,167,189],[112,168,189],[112,168,189],[112,168,190],[112,168,189],[112,168,190],[113,169,190],[113,169,190],[112,169,189],[112,168,189],[110,168,189],[110,167,189],[108,166,187],[107,165,186],[109,166,189],[110,165,187],[112,166,187],[109,165,185],[105,163,182],[105,163,183],[106,163,183],[108,165,184],[107,165,183],[107,166,183],[109,167,186],[108,167,186],[110,168,186],[110,168,186],[110,168,185],[112,169,185],[112,169,185],[111,169,186],[111,168,186],[115,168,186],[115,168,186],[114,166,184],[114,166,185],[114,166,184],[113,166,184],[112,166,182],[110,163,179],[111,163,179],[112,164,180],[112,164,181],[111,163,180],[113,163,178],[111,163,179],[110,162,178],[108,160,176],[108,161,176],[107,160,175],[111,160,175],[113,160,176],[113,160,174],[115,161,176],[115,162,177],[116,162,176],[113,161,176],[114,161,176],[115,163,177],[114,163,179],[111,164,180],[110,164,182],[109,163,182],[108,163,182],[109,164,182],[110,165,183],[110,165,183],[111,165,183],[111,165,184],[111,165,184],[110,165,184],[110,165,184],[110,164,183],[110,165,184],[122,176,194],[119,175,194],[118,174,194],[118,174,192],[121,174,193],[121,175,195],[121,176,196],[123,177,195],[123,176,197],[122,177,196],[122,176,196],[120,177,197],[121,177,197],[122,176,196],[122,175,196],[123,177,197],[124,178,198],[124,178,199],[124,178,198],[124,178,198],[123,179,198],[122,179,198],[124,179,199],[122,178,198],[123,179,199],[124,180,200],[126,179,200],[128,180,201],[126,179,200],[125,179,200],[126,180,201],[126,180,201],[125,179,200],[125,180,199],[127,182,201],[126,181,201],[126,181,201],[125,180,200],[125,180,200],[124,179,199],[126,179,199],[126,180,200],[126,180,200],[126,180,199],[124,178,198],[124,178,198],[123,179,199],[124,178,199],[126,180,201],[127,180,201],[129,181,202],[127,181,200],[126,179,200],[126,179,200],[127,180,201],[126,181,201],[126,183,203],[129,183,203],[131,183,203],[130,183,204],[127,184,203],[130,186,206],[130,186,206],[129,185,205],[132,186,207],[132,186,207],[131,185,205],[130,185,205],[132,186,207],[130,185,206],[128,184,206],[130,184,206],[129,183,205],[129,183,204],[128,183,205],[129,183,205],[132,185,207],[131,185,206],[130,183,205],[130,184,205],[130,184,206],[130,183,206],[131,185,207],[130,183,205],[131,184,205],[132,184,205],[133,184,206],[131,184,205],[131,183,204],[130,184,204],[128,182,204],[128,182,203],[129,181,202],[129,179,202],[129,180,202],[129,180,202],[128,180,202],[127,180,201],[127,180,202],[129,180,204],[129,181,203],[128,180,203],[128,182,203],[127,180,202],[127,180,202],[126,180,201],[125,180,200],[123,178,199],[125,180,201],[124,180,202],[123,178,201],[123,178,200],[123,178,199],[122,177,200],[120,177,199],[123,178,200],[124,178,201],[126,181,203],[129,183,205],[130,185,206],[130,185,205],[131,184,206],[132,185,208],[132,184,207],[128,182,205],[127,182,204],[125,181,203],[126,179,202],[126,180,203],[125,179,202],[127,180,203],[128,181,203],[129,182,204],[130,184,204],[131,184,205],[131,184,206],[131,185,206],[131,184,206],[132,186,207],[131,185,206],[131,185,206],[129,183,204],[126,181,203],[126,180,203],[125,180,203],[125,181,203],[125,180,203],[128,181,204],[131,181,205],[131,183,204],[131,182,204],[130,182,204],[129,182,203],[127,182,202],[127,180,201],[126,179,201],[124,178,201],[125,178,201],[124,178,201],[121,177,198],[124,178,199],[124,178,199],[112,171,191],[83,136,160],[60,110,141],[61,110,142],[62,110,143],[61,110,140],[61,110,140],[59,108,139],[60,108,140],[58,107,139],[81,134,158],[112,170,187],[122,176,196],[120,175,196],[120,174,195],[119,174,194],[121,175,196],[122,175,196],[122,175,196],[118,174,194],[117,173,195],[116,172,192],[114,171,192],[114,170,191],[112,170,191],[113,170,191],[114,171,192],[114,171,192],[113,171,192],[111,169,190],[111,169,190],[111,169,190],[111,168,190],[113,168,190],[114,170,191],[112,170,190],[113,170,190],[114,169,190],[113,169,190],[113,169,190],[112,170,190],[112,169,190],[112,169,189],[112,168,189],[112,168,189],[111,166,188],[110,166,187],[110,166,188],[111,166,188],[110,165,188],[108,165,186],[105,164,184],[106,164,185],[109,165,184],[112,166,185],[110,166,184],[107,165,184],[109,166,186],[111,168,186],[112,169,188],[114,169,189],[114,170,189],[114,170,188],[115,171,188],[114,170,187],[113,169,187],[113,169,186],[117,169,187],[118,168,188],[118,168,187],[116,167,185],[115,167,185],[113,167,182],[110,165,181],[113,165,181],[113,165,182],[115,165,182],[115,165,181],[118,164,181],[117,162,179],[114,162,178],[113,160,173],[109,160,174],[106,159,174],[108,158,172],[109,157,171],[111,156,168],[112,156,167],[113,157,168],[117,160,174],[117,159,171],[117,160,173],[118,160,172],[116,163,176],[115,164,181],[114,166,183],[112,165,184],[111,164,183],[110,165,183],[110,165,182],[109,165,183],[111,166,184],[110,164,183],[109,165,182],[108,164,182],[108,165,182],[106,165,181],[107,165,182],[123,176,195],[121,176,195],[119,174,194],[117,174,192],[120,174,192],[121,175,195],[121,175,194],[122,177,195],[123,177,196],[121,176,196],[122,177,197],[122,177,197],[122,177,197],[122,176,197],[122,176,196],[123,177,197],[124,178,198],[124,178,198],[124,178,198],[125,179,199],[124,178,197],[124,179,198],[124,180,199],[123,179,199],[123,179,198],[124,179,200],[127,180,200],[126,180,201],[125,179,200],[125,179,200],[125,179,199],[126,180,200],[123,179,199],[125,180,200],[125,181,200],[125,182,200],[125,181,201],[124,180,200],[124,180,200],[125,179,200],[125,179,200],[125,180,200],[124,180,200],[125,180,199],[125,179,200],[125,179,200],[125,179,199],[126,179,200],[128,180,202],[128,181,201],[127,180,201],[127,180,201],[127,180,201],[126,179,200],[127,180,201],[126,181,202],[128,183,203],[131,183,203],[135,184,205],[133,184,205],[130,185,205],[132,186,206],[130,186,206],[129,186,205],[130,187,206],[130,186,207],[131,186,207],[132,186,207],[133,186,207],[130,186,206],[129,185,205],[130,184,205],[131,183,205],[131,183,205],[129,182,205],[129,183,205],[133,184,206],[131,184,206],[129,182,204],[129,183,204],[130,185,205],[131,185,207],[131,185,206],[130,184,205],[130,182,204],[132,183,205],[135,184,206],[133,185,206],[134,184,205],[133,184,205],[131,182,204],[131,182,204],[131,182,203],[129,181,202],[129,180,202],[129,180,202],[128,180,202],[129,181,202],[129,182,202],[128,181,202],[128,181,202],[129,181,202],[129,182,203],[127,181,202],[126,182,204],[125,181,202],[126,182,202],[126,181,202],[125,180,200],[126,180,203],[124,179,202],[126,180,204],[123,178,200],[122,177,199],[122,177,199],[123,178,200],[125,178,201],[127,181,203],[128,182,204],[131,184,207],[131,186,207],[131,185,207],[131,185,207],[131,184,206],[130,183,205],[128,182,203],[128,181,204],[126,179,201],[127,180,203],[127,180,203],[130,182,204],[130,182,204],[130,182,204],[132,183,204],[130,184,204],[131,185,205],[130,185,205],[131,185,206],[132,186,206],[131,186,206],[131,185,207],[127,182,205],[127,181,204],[127,181,203],[124,179,202],[124,180,202],[125,180,202],[128,181,203],[130,182,204],[131,182,204],[130,182,203],[130,182,203],[128,182,202],[128,181,202],[127,180,201],[126,180,202],[125,178,201],[125,179,202],[125,178,201],[124,178,198],[122,177,197],[122,177,197],[113,171,192],[77,131,157],[59,109,140],[60,110,142],[60,110,143],[59,110,141],[57,109,139],[58,109,139],[60,107,139],[61,108,139],[67,117,144],[95,150,169],[119,172,193],[121,174,195],[121,174,195],[122,175,195],[125,176,197],[125,176,197],[124,175,196],[122,174,195],[121,174,195],[117,173,194],[117,172,193],[115,171,191],[115,170,192],[114,171,191],[115,172,193],[114,171,192],[114,172,193],[114,171,192],[113,170,191],[113,169,190],[114,169,191],[114,169,191],[116,171,191],[114,170,190],[114,170,190],[115,170,190],[116,171,191],[115,171,191],[115,171,190],[115,171,191],[114,171,191],[113,169,189],[112,167,189],[111,167,188],[111,167,188],[110,167,187],[110,167,187],[109,166,186],[109,167,187],[108,166,185],[109,165,186],[110,166,186],[113,167,185],[110,166,185],[110,166,186],[113,168,188],[113,169,188],[114,170,188],[115,171,189],[116,171,191],[117,171,189],[117,171,189],[116,171,189],[119,172,190],[114,171,188],[117,170,188],[118,170,188],[118,169,187],[116,169,187],[111,168,185],[114,167,184],[114,166,182],[116,165,182],[116,166,182],[114,162,177],[111,158,172],[114,162,177],[114,163,179],[113,159,174],[120,147,156],[115,134,138],[117,129,130],[137,126,113],[139,125,110],[126,151,154],[117,165,179],[115,166,182],[114,166,183],[113,166,184],[112,165,184],[111,166,183],[110,166,183],[111,165,184],[111,165,184],[110,165,181],[108,165,182],[107,166,182],[106,166,182],[108,167,184],[122,177,197],[122,176,196],[121,175,195],[122,175,196],[122,175,196],[122,176,196],[123,176,195],[123,176,195],[126,178,197],[122,178,197],[121,176,196],[122,177,197],[122,177,197],[121,176,196],[121,176,196],[123,177,197],[124,178,198],[123,178,198],[124,179,198],[125,178,198],[125,178,198],[125,179,199],[123,178,198],[125,179,199],[124,179,200],[126,180,199],[125,180,199],[126,180,200],[126,179,200],[125,179,199],[126,179,200],[126,180,200],[126,180,201],[126,182,202],[128,183,202],[128,182,202],[125,182,201],[125,181,200],[124,180,200],[123,179,199],[126,180,201],[125,179,200],[126,180,201],[126,179,200],[127,179,201],[125,179,200],[127,180,201],[127,180,200],[129,180,201],[128,182,201],[128,181,202],[128,180,202],[127,180,201],[126,179,200],[127,180,201],[127,181,202],[129,183,203],[131,185,205],[132,184,205],[132,184,205],[131,185,206],[133,186,207],[131,187,207],[131,187,206],[132,188,209],[132,188,208],[131,186,206],[132,187,208],[134,187,208],[133,187,207],[130,186,207],[130,185,205],[131,184,206],[131,183,205],[130,183,206],[131,184,206],[133,185,206],[130,184,204],[130,184,204],[129,185,205],[131,184,205],[131,186,206],[132,186,207],[131,186,206],[130,184,205],[132,185,206],[135,185,207],[136,184,208],[136,184,207],[134,183,205],[131,183,204],[131,182,203],[130,182,203],[129,181,202],[129,180,202],[129,180,202],[127,180,202],[130,182,202],[130,181,203],[130,182,203],[130,182,203],[133,183,204],[130,182,203],[127,181,202],[127,181,202],[128,182,202],[126,182,202],[126,182,202],[125,181,201],[125,181,203],[127,180,203],[127,180,203],[124,178,201],[123,177,200],[123,177,200],[123,178,200],[123,179,200],[128,180,203],[130,183,204],[132,186,207],[131,185,206],[132,186,208],[132,186,207],[133,184,206],[131,183,204],[129,182,203],[128,181,204],[126,180,203],[128,180,202],[129,181,204],[131,181,205],[131,182,205],[131,182,204],[132,183,204],[132,185,206],[130,185,205],[131,187,206],[133,187,208],[131,186,206],[131,186,207],[131,186,207],[128,183,204],[125,181,203],[126,181,204],[125,181,203],[124,179,202],[127,180,202],[127,180,202],[130,183,203],[131,184,204],[131,184,205],[129,183,203],[130,182,203],[129,182,204],[128,181,202],[125,179,201],[125,179,201],[126,178,201],[124,178,200],[128,178,200],[129,179,199],[130,180,200],[130,180,200],[103,158,179],[63,113,143],[58,110,141],[58,109,142],[58,109,140],[57,110,140],[58,109,140],[59,107,139],[60,109,140],[61,109,138],[71,121,144],[108,160,181],[121,174,195],[119,174,194],[117,172,192],[119,173,194],[125,177,198],[124,176,197],[122,175,196],[122,174,195],[121,173,194],[119,173,194],[115,172,193],[116,171,192],[116,172,193],[117,173,193],[117,173,194],[117,172,194],[115,173,193],[118,172,193],[117,172,192],[116,171,191],[114,170,190],[116,170,190],[115,170,191],[115,171,192],[115,170,192],[116,172,192],[116,172,191],[117,171,191],[115,170,191],[115,171,190],[114,170,190],[113,169,189],[111,168,188],[111,167,187],[111,167,187],[110,167,188],[111,167,188],[112,166,188],[112,167,187],[112,167,187],[111,167,187],[113,166,187],[112,166,186],[112,167,186],[115,169,187],[115,169,188],[115,169,189],[115,170,189],[117,171,190],[118,172,191],[119,172,191],[118,170,189],[118,171,190],[120,172,191],[118,172,191],[118,169,188],[118,170,187],[117,169,187],[114,168,186],[114,166,184],[113,165,181],[112,164,180],[115,163,178],[98,135,149],[73,100,114],[96,140,154],[114,162,174],[117,151,161],[123,96,85],[112,84,73],[123,84,66],[150,102,79],[156,109,81],[157,114,84],[158,117,87],[159,118,89],[161,121,91],[162,122,93],[160,123,96],[148,129,111],[126,152,156],[115,166,182],[114,166,184],[114,166,185],[112,165,184],[110,165,182],[109,166,183],[109,165,182],[111,165,183],[111,165,183],[111,165,182],[111,165,183],[111,167,184],[110,166,184],[122,177,197],[121,176,196],[122,176,196],[122,174,196],[120,175,196],[121,176,196],[123,176,194],[125,177,196],[125,178,196],[124,178,197],[121,176,197],[122,178,197],[122,176,196],[122,178,197],[121,177,197],[123,179,199],[124,179,197],[124,180,199],[125,179,200],[126,180,199],[125,179,200],[125,179,200],[125,179,199],[125,179,200],[126,180,200],[126,180,199],[126,180,200],[127,181,200],[127,180,200],[128,181,201],[128,181,201],[128,182,201],[128,182,201],[127,181,202],[128,182,201],[129,182,202],[129,183,203],[126,181,201],[126,181,201],[125,179,200],[124,180,199],[124,179,199],[126,179,200],[127,180,201],[126,180,201],[127,179,201],[127,180,201],[126,180,200],[128,180,200],[128,181,201],[126,180,201],[127,180,201],[127,180,201],[127,180,201],[127,180,201],[126,181,201],[129,183,203],[131,184,204],[128,183,203],[131,184,206],[132,185,207],[133,187,208],[133,186,208],[131,186,207],[132,187,208],[131,187,207],[131,187,208],[132,187,207],[133,187,208],[132,187,208],[133,187,208],[131,185,205],[129,183,205],[129,185,206],[127,183,205],[129,184,205],[131,184,206],[132,185,206],[133,184,205],[131,184,205],[133,185,206],[131,185,206],[131,185,207],[131,184,206],[132,185,206],[134,185,207],[134,184,206],[136,184,207],[134,185,207],[133,184,206],[130,183,204],[130,183,204],[128,182,203],[129,181,202],[128,180,202],[128,179,202],[126,179,201],[129,180,202],[129,181,202],[130,182,203],[131,182,203],[130,182,203],[130,182,203],[129,182,202],[127,182,202],[128,182,202],[128,182,203],[126,181,203],[126,181,202],[126,180,203],[126,180,203],[127,180,203],[125,179,202],[122,177,200],[123,177,200],[123,178,200],[123,178,200],[126,179,203],[131,183,204],[132,186,206],[132,186,207],[132,186,206],[133,186,207],[132,184,207],[129,182,204],[128,181,204],[127,181,204],[125,181,202],[127,181,201],[126,181,202],[128,182,205],[130,181,204],[129,183,204],[130,183,204],[132,185,207],[132,186,207],[133,187,208],[133,186,208],[132,185,206],[131,186,206],[131,185,205],[129,183,203],[127,182,204],[128,181,204],[126,181,203],[124,179,202],[125,180,202],[128,181,203],[129,182,204],[128,182,204],[129,182,204],[129,182,204],[128,182,203],[128,181,203],[128,180,203],[125,179,202],[125,179,203],[130,179,204],[133,181,203],[141,183,203],[147,183,202],[156,187,206],[154,189,207],[111,162,182],[63,114,143],[60,111,143],[61,108,140],[64,116,145],[86,143,168],[91,146,171],[82,133,161],[55,106,136],[61,107,139],[63,110,137],[92,143,164],[116,170,190],[108,161,181],[87,137,161],[93,147,170],[120,173,194],[125,176,197],[124,176,197],[123,175,196],[122,174,196],[121,174,195],[117,173,193],[116,172,192],[117,172,193],[118,174,194],[121,174,195],[117,173,194],[116,172,193],[116,172,193],[118,172,193],[116,170,191],[116,171,191],[116,171,191],[113,171,191],[113,170,190],[114,171,191],[115,171,191],[117,172,192],[116,172,190],[116,171,191],[117,171,191],[114,170,190],[113,169,189],[113,169,189],[112,168,188],[113,169,189],[111,167,189],[111,167,189],[113,167,188],[115,166,189],[111,165,186],[113,167,188],[114,168,188],[113,166,187],[114,168,186],[115,168,187],[114,168,188],[117,170,188],[119,171,191],[118,172,190],[117,172,189],[118,173,189],[118,172,189],[120,172,189],[118,170,189],[119,171,189],[118,170,188],[117,169,187],[115,168,187],[116,168,187],[115,167,186],[113,166,184],[111,163,178],[113,160,176],[79,107,120],[67,87,100],[106,146,156],[116,157,165],[133,95,82],[127,85,72],[109,73,64],[120,80,62],[151,98,69],[159,106,77],[163,113,79],[165,117,80],[168,121,85],[168,121,88],[167,123,87],[166,124,90],[162,125,94],[151,132,111],[121,154,158],[113,164,179],[113,165,183],[111,165,183],[111,165,183],[108,165,183],[108,165,182],[108,164,182],[110,164,183],[111,165,183],[112,165,184],[112,165,184],[112,166,185],[121,177,196],[122,176,196],[123,177,197],[124,176,196],[121,174,195],[122,176,196],[123,177,195],[123,178,196],[125,178,197],[125,180,200],[123,179,198],[123,178,198],[123,178,198],[124,178,198],[125,179,199],[123,179,197],[124,179,198],[123,179,198],[127,180,201],[126,179,200],[125,179,200],[125,179,200],[125,179,200],[126,180,200],[126,180,200],[125,179,199],[125,179,199],[126,180,201],[126,180,199],[128,181,201],[128,181,201],[129,182,203],[128,181,202],[129,182,201],[130,182,201],[130,182,202],[129,182,202],[126,181,201],[126,180,201],[126,179,201],[125,179,200],[125,179,200],[126,179,200],[127,179,201],[127,180,200],[126,180,201],[126,180,201],[126,180,201],[128,180,201],[127,180,201],[127,180,201],[128,179,201],[125,179,200],[126,179,201],[127,180,201],[127,181,201],[129,182,202],[129,183,203],[128,183,203],[127,183,203],[129,184,204],[132,185,207],[134,187,208],[133,187,208],[131,187,207],[131,187,207],[131,187,207],[132,188,209],[132,188,208],[132,187,207],[134,187,208],[133,186,207],[128,184,204],[130,185,206],[129,185,205],[128,184,204],[131,185,207],[133,185,206],[133,184,206],[130,183,204],[132,183,204],[131,185,207],[130,184,205],[131,184,206],[129,184,205],[134,185,207],[135,185,207],[134,184,205],[132,184,206],[132,183,205],[132,183,204],[131,182,204],[129,181,202],[130,181,203],[126,180,202],[127,180,201],[127,179,202],[126,180,201],[128,180,201],[130,182,203],[130,182,203],[130,181,203],[129,182,203],[130,182,203],[128,182,202],[128,182,202],[129,182,203],[127,181,202],[127,181,203],[125,180,202],[125,180,202],[126,180,201],[127,179,201],[123,178,199],[123,178,198],[125,179,201],[122,177,199],[125,179,202],[130,182,204],[130,184,204],[132,185,206],[131,185,206],[132,185,206],[131,184,206],[129,182,205],[127,182,204],[126,181,203],[124,179,202],[127,180,203],[128,181,204],[128,181,203],[128,181,204],[129,182,205],[130,183,206],[131,185,205],[132,185,206],[133,186,207],[133,186,208],[132,186,207],[130,184,207],[130,185,206],[130,183,205],[128,181,204],[128,180,204],[127,180,203],[125,179,202],[126,179,202],[125,179,202],[125,181,202],[126,181,203],[126,181,202],[127,182,203],[128,182,202],[129,182,204],[128,181,202],[127,179,201],[130,180,200],[137,181,201],[152,186,207],[159,189,209],[161,191,207],[165,191,207],[162,190,207],[120,165,185],[64,114,145],[60,109,142],[61,108,140],[82,133,159],[111,169,188],[110,168,188],[107,162,184],[60,111,141],[61,106,139],[62,107,138],[68,117,143],[90,140,164],[63,111,140],[56,105,136],[88,142,166],[121,174,195],[125,176,197],[123,176,196],[124,176,197],[122,174,196],[121,174,195],[118,174,194],[117,173,193],[117,173,193],[118,174,194],[121,176,196],[118,174,195],[119,173,194],[117,173,195],[117,172,194],[116,171,192],[115,170,191],[115,171,193],[116,171,192],[117,171,192],[117,172,192],[117,172,193],[117,172,192],[118,172,192],[117,172,193],[117,171,192],[116,171,190],[115,170,189],[114,169,189],[113,169,189],[112,168,188],[112,168,188],[112,168,188],[113,168,188],[114,167,188],[112,167,187],[113,166,188],[110,167,186],[114,167,187],[116,168,187],[115,168,187],[116,169,188],[117,170,189],[118,170,190],[120,171,193],[119,171,193],[119,172,191],[117,173,190],[119,170,189],[118,171,188],[117,170,187],[118,170,187],[117,169,187],[117,168,185],[116,167,186],[114,167,185],[111,165,182],[109,161,178],[104,149,165],[72,92,101],[82,99,107],[118,154,160],[117,137,140],[129,99,89],[135,89,74],[122,81,68],[105,70,58],[124,82,63],[154,99,68],[162,109,72],[167,115,74],[172,120,77],[170,120,79],[173,123,83],[173,125,85],[173,126,88],[168,126,89],[162,126,96],[146,134,114],[119,155,160],[112,165,182],[112,165,184],[110,164,182],[107,164,181],[106,164,181],[107,165,182],[105,164,181],[106,165,181],[108,165,182],[111,165,183],[112,165,184],[123,177,196],[122,177,195],[123,176,196],[123,177,196],[122,176,196],[124,177,198],[122,177,196],[124,177,196],[124,178,197],[126,181,199],[125,179,198],[124,178,198],[124,178,198],[123,177,197],[124,178,198],[124,178,197],[124,178,198],[124,179,199],[125,179,200],[125,178,199],[125,180,201],[124,178,199],[125,179,199],[125,179,200],[125,179,200],[124,178,199],[125,180,200],[124,180,200],[126,180,199],[128,181,200],[128,181,200],[129,180,201],[129,182,201],[129,182,201],[130,182,203],[128,182,201],[127,182,202],[127,182,201],[128,181,201],[127,180,201],[125,179,200],[125,179,200],[125,179,200],[126,179,200],[127,180,201],[126,179,200],[127,180,201],[125,180,200],[124,180,200],[128,181,201],[129,180,201],[129,180,201],[127,180,200],[127,180,201],[127,180,201],[128,181,200],[129,182,201],[129,182,203],[129,183,202],[133,184,205],[133,185,206],[132,185,207],[131,187,207],[131,187,208],[131,187,207],[130,186,206],[131,187,206],[131,187,207],[132,188,208],[131,187,207],[132,186,208],[132,186,207],[130,185,205],[130,185,204],[130,184,204],[130,184,205],[129,184,204],[132,184,207],[131,184,204],[132,183,206],[130,182,205],[130,185,206],[129,185,204],[131,184,206],[129,184,206],[133,185,207],[136,185,207],[134,185,206],[131,185,205],[132,185,206],[134,182,204],[132,182,204],[131,182,204],[129,180,202],[127,180,201],[125,179,202],[127,180,202],[127,180,201],[128,181,202],[129,182,203],[131,183,204],[130,183,204],[129,182,203],[128,182,202],[126,182,202],[127,182,202],[129,182,203],[130,182,203],[127,181,202],[128,181,202],[125,179,200],[126,179,201],[126,178,200],[125,178,199],[123,178,199],[123,178,199],[122,178,199],[124,179,201],[128,182,202],[129,184,204],[131,185,204],[130,185,206],[131,186,207],[131,185,207],[129,182,205],[126,182,204],[124,181,203],[125,180,202],[125,180,203],[128,180,203],[128,180,204],[128,181,204],[129,182,203],[130,183,206],[130,184,204],[131,185,205],[133,186,207],[134,186,208],[133,186,207],[133,186,208],[131,185,206],[130,183,206],[127,181,204],[127,180,203],[125,180,203],[124,178,201],[123,178,201],[124,180,202],[125,181,202],[126,182,202],[126,182,203],[127,182,204],[127,181,204],[128,180,203],[128,179,203],[127,178,200],[138,176,194],[145,179,196],[163,190,207],[165,189,206],[155,175,193],[168,188,205],[169,192,207],[140,179,200],[65,114,144],[61,110,143],[60,108,140],[65,115,142],[80,130,154],[89,139,162],[82,133,158],[58,107,140],[57,106,140],[54,105,138],[51,103,133],[54,106,137],[53,104,137],[65,122,152],[97,154,176],[114,169,188],[120,174,194],[124,176,196],[123,176,196],[123,175,196],[121,174,195],[118,173,193],[119,173,194],[120,174,195],[119,173,194],[120,174,195],[117,173,193],[118,174,195],[119,174,195],[116,172,194],[115,171,192],[117,173,194],[115,172,192],[117,172,193],[117,171,191],[118,172,192],[118,172,193],[119,172,193],[118,172,192],[117,172,191],[118,172,193],[118,172,192],[116,170,189],[113,170,188],[113,169,188],[114,167,188],[114,167,188],[114,168,188],[112,168,188],[111,167,187],[110,165,188],[111,167,187],[113,167,187],[114,167,187],[114,168,186],[114,168,186],[116,168,188],[119,170,189],[115,170,188],[115,170,189],[117,171,191],[118,172,191],[118,173,191],[119,172,192],[120,171,191],[117,170,188],[118,171,189],[117,170,188],[117,168,186],[115,168,187],[112,167,185],[109,165,183],[107,159,177],[99,135,149],[68,82,92],[90,102,105],[129,105,95],[138,92,77],[136,88,73],[120,79,65],[103,70,57],[131,87,66],[159,103,72],[166,111,77],[170,116,77],[173,121,77],[175,123,81],[174,124,81],[177,125,84],[177,127,84],[175,127,86],[169,127,89],[161,128,94],[147,135,117],[116,156,163],[113,165,183],[111,164,182],[109,164,182],[107,164,182],[107,164,182],[107,164,182],[108,165,184],[108,165,183],[108,164,183],[109,166,185],[123,177,196],[123,177,196],[123,177,197],[124,178,197],[123,177,196],[124,177,197],[124,178,198],[123,178,197],[125,179,198],[127,181,199],[125,179,199],[124,178,198],[124,178,197],[123,177,198],[123,176,197],[124,178,198],[123,178,198],[124,178,198],[125,179,200],[125,179,200],[125,179,200],[125,179,200],[124,178,199],[125,179,199],[126,179,200],[124,179,199],[124,180,199],[123,179,199],[125,179,198],[126,179,200],[127,180,200],[128,179,200],[128,181,200],[128,181,201],[128,182,202],[130,182,201],[129,183,201],[129,183,201],[131,182,201],[127,180,200],[126,179,200],[124,179,200],[124,178,199],[125,179,199],[126,179,199],[127,180,199],[127,179,201],[124,179,200],[124,179,199],[128,180,202],[129,181,202],[129,180,201],[127,180,200],[126,179,200],[126,179,201],[128,181,201],[129,183,202],[129,183,203],[129,183,203],[133,184,206],[133,184,207],[131,186,207],[133,188,208],[134,188,208],[132,188,208],[130,186,206],[130,186,206],[132,188,208],[131,188,207],[131,188,208],[130,187,207],[133,186,207],[132,186,207],[131,185,206],[131,185,206],[130,184,204],[130,185,206],[131,185,207],[127,183,205],[129,183,205],[129,182,205],[130,184,206],[132,184,206],[130,184,205],[130,183,206],[132,185,207],[132,185,207],[131,185,206],[130,184,205],[132,184,205],[132,182,204],[132,183,204],[127,180,202],[127,181,202],[128,180,201],[126,179,201],[125,179,202],[127,180,202],[127,180,202],[128,181,202],[129,181,202],[131,183,203],[132,183,204],[131,183,204],[129,181,204],[128,181,204],[129,181,204],[130,181,205],[128,181,204],[127,179,202],[127,179,201],[123,179,199],[126,178,200],[126,177,199],[124,177,198],[124,178,201],[123,177,200],[123,179,202],[127,181,204],[129,183,204],[131,184,206],[130,185,206],[131,186,208],[130,184,207],[129,183,206],[126,182,204],[125,181,203],[124,179,202],[124,180,202],[126,179,202],[126,180,203],[127,181,203],[128,182,204],[130,183,206],[129,184,206],[131,185,207],[133,186,207],[132,186,207],[133,186,208],[132,186,207],[130,183,206],[129,182,206],[128,182,205],[125,180,203],[123,179,202],[123,178,200],[123,179,201],[124,179,202],[124,181,203],[125,181,203],[126,181,203],[127,182,204],[127,183,204],[128,180,204],[126,178,200],[127,177,197],[142,160,171],[151,157,168],[171,187,203],[167,187,205],[157,175,193],[169,188,205],[170,191,207],[152,184,202],[78,122,150],[61,109,143],[62,110,145],[59,108,141],[59,109,140],[59,110,137],[57,108,137],[56,106,141],[55,105,139],[52,103,136],[52,104,138],[56,107,142],[63,112,148],[66,118,151],[68,120,151],[73,128,154],[103,160,181],[121,174,195],[123,175,196],[122,175,196],[121,174,195],[121,174,194],[121,174,195],[120,174,193],[122,175,195],[120,175,194],[118,173,193],[118,174,195],[118,174,195],[118,172,195],[117,172,194],[116,172,194],[118,172,194],[117,173,193],[118,172,194],[119,172,193],[118,172,192],[117,172,192],[117,171,191],[115,170,192],[117,172,193],[119,172,193],[118,171,190],[116,170,190],[115,170,188],[115,169,188],[115,167,188],[115,167,188],[112,167,188],[111,167,187],[111,167,187],[113,167,188],[114,168,187],[114,168,186],[114,168,186],[114,168,187],[115,168,188],[113,169,187],[116,170,188],[116,171,189],[113,171,188],[117,173,191],[116,172,190],[117,171,190],[119,170,188],[117,171,188],[118,170,189],[116,170,188],[117,168,187],[117,168,187],[115,167,186],[114,166,182],[111,159,175],[91,127,138],[71,76,79],[113,104,99],[126,87,74],[129,81,69],[126,81,68],[110,75,63],[103,69,54],[143,93,67],[161,104,72],[166,111,75],[170,115,76],[172,119,76],[175,123,80],[177,126,83],[178,128,85],[177,127,82],[178,131,84],[174,129,85],[168,128,92],[159,128,99],[144,137,122],[117,155,163],[111,163,178],[111,163,180],[110,164,181],[109,163,181],[109,165,183],[109,165,184],[109,164,184],[109,166,185],[109,166,185],[122,176,196],[123,177,197],[126,178,199],[127,178,200],[126,178,198],[124,178,198],[124,178,197],[124,178,197],[126,179,200],[127,181,200],[127,181,199],[127,180,201],[126,179,200],[125,178,199],[123,177,197],[124,178,198],[124,178,198],[124,178,199],[126,179,200],[126,179,200],[125,180,200],[127,181,202],[125,180,200],[125,179,200],[125,179,200],[124,178,198],[123,179,198],[125,179,200],[124,178,199],[125,179,200],[128,180,200],[129,180,201],[130,181,201],[129,182,200],[128,181,202],[129,182,201],[129,182,201],[129,183,202],[129,180,201],[127,180,200],[125,179,200],[124,179,199],[124,179,199],[125,178,199],[127,179,199],[128,180,199],[128,179,201],[127,180,201],[125,180,201],[129,180,202],[129,181,202],[128,181,200],[126,180,200],[128,180,200],[126,180,199],[127,180,201],[129,182,203],[127,183,204],[129,183,204],[131,184,205],[131,184,206],[130,186,207],[132,188,208],[133,188,209],[131,187,207],[131,187,207],[130,186,206],[131,187,207],[132,188,208],[132,188,208],[132,187,208],[134,187,208],[131,186,206],[131,186,207],[131,185,206],[131,185,205],[131,185,205],[130,184,204],[127,184,205],[128,184,206],[130,183,206],[130,183,205],[131,184,207],[131,184,207],[130,183,206],[132,186,208],[132,186,207],[132,186,207],[131,185,207],[132,184,205],[132,183,204],[131,182,204],[129,181,205],[128,180,202],[128,179,202],[128,179,201],[127,179,202],[126,179,202],[126,180,201],[126,180,201],[127,181,202],[131,183,204],[131,182,203],[128,181,202],[130,181,204],[130,182,203],[130,182,203],[129,180,203],[129,180,203],[125,179,202],[125,178,201],[125,179,202],[124,178,200],[124,178,199],[124,176,199],[124,177,200],[123,178,200],[124,180,202],[127,182,203],[129,182,203],[130,184,205],[131,185,205],[133,186,207],[131,186,208],[130,183,205],[129,181,202],[126,180,202],[124,179,201],[124,179,202],[124,179,202],[125,181,203],[127,181,204],[129,182,205],[129,182,205],[130,183,206],[131,185,207],[131,185,206],[131,185,207],[129,184,207],[129,186,206],[129,184,206],[130,183,206],[127,182,205],[124,180,203],[123,179,202],[123,178,201],[123,178,200],[123,178,201],[125,181,203],[127,182,203],[128,182,203],[128,182,205],[128,182,204],[129,181,204],[124,178,198],[131,170,187],[172,183,196],[172,192,208],[171,191,208],[173,193,209],[171,191,207],[157,187,206],[86,129,156],[62,110,143],[63,111,145],[59,109,142],[57,108,141],[55,106,139],[56,107,137],[57,107,140],[52,102,136],[47,101,133],[52,106,141],[60,111,147],[62,111,148],[59,110,145],[54,108,140],[74,127,160],[110,164,187],[121,174,196],[121,174,195],[121,174,195],[122,174,195],[121,174,194],[121,175,193],[121,174,195],[122,175,195],[120,174,193],[119,174,193],[120,174,195],[118,173,194],[117,172,193],[116,171,193],[117,172,195],[115,173,193],[118,172,194],[119,172,194],[117,173,193],[117,173,193],[116,172,192],[116,171,191],[116,170,189],[117,171,191],[117,172,191],[117,171,191],[116,170,189],[116,170,191],[115,170,190],[110,168,186],[110,168,187],[110,167,186],[111,167,186],[111,167,187],[111,167,187],[113,168,187],[113,168,186],[114,167,186],[113,167,186],[112,167,187],[113,167,188],[115,169,187],[114,170,187],[115,171,189],[116,172,190],[115,174,191],[119,173,191],[118,171,190],[119,170,189],[116,170,188],[116,170,188],[116,168,187],[117,168,187],[115,166,185],[110,164,180],[110,161,175],[86,107,115],[88,76,74],[99,75,72],[104,73,64],[106,74,61],[111,72,64],[103,69,60],[108,74,58],[148,96,70],[160,105,71],[166,111,73],[168,114,74],[171,119,75],[176,124,80],[177,127,82],[178,128,84],[179,130,84],[182,133,86],[180,131,88],[175,131,92],[166,129,94],[157,129,102],[139,137,125],[114,157,167],[112,162,178],[112,165,182],[110,164,182],[108,165,182],[109,164,183],[109,165,184],[110,165,183],[110,164,183],[119,175,195],[120,176,196],[124,177,197],[127,178,198],[123,178,198],[124,179,199],[125,179,199],[126,179,200],[127,180,201],[126,180,199],[127,180,201],[127,179,201],[127,179,200],[125,179,198],[126,178,199],[126,178,198],[126,177,199],[125,178,199],[125,179,199],[126,180,199],[126,180,200],[127,180,200],[124,179,199],[123,179,199],[125,179,200],[125,179,201],[126,180,201],[125,179,200],[124,179,199],[124,179,200],[126,179,200],[128,181,201],[128,181,200],[128,181,201],[128,181,201],[129,181,202],[129,182,202],[128,181,200],[127,180,200],[125,180,200],[126,180,201],[125,179,200],[125,179,200],[127,180,198],[127,180,200],[128,179,201],[128,181,201],[129,182,202],[126,181,201],[128,182,201],[130,182,202],[128,181,200],[127,181,200],[128,182,201],[129,182,202],[129,182,202],[128,181,202],[126,182,203],[129,183,204],[130,185,205],[127,185,204],[131,187,207],[130,189,208],[134,188,209],[132,188,208],[132,188,208],[132,188,208],[132,188,208],[131,187,206],[133,188,208],[135,187,209],[134,187,207],[132,186,207],[133,186,207],[132,186,207],[132,186,207],[132,186,207],[131,185,207],[129,185,205],[130,184,206],[130,183,206],[130,184,207],[130,184,207],[128,184,206],[129,183,205],[131,185,208],[133,186,207],[135,188,209],[133,185,207],[133,185,207],[133,184,206],[129,182,203],[128,182,204],[127,181,204],[127,180,202],[127,179,201],[127,178,201],[127,178,202],[128,179,201],[131,182,203],[131,182,203],[131,182,203],[130,181,204],[130,181,204],[130,182,203],[130,181,204],[130,182,203],[129,181,203],[128,180,203],[127,180,202],[127,179,203],[128,180,202],[126,179,202],[122,177,200],[124,177,200],[124,177,200],[123,178,201],[125,180,202],[126,181,203],[128,181,204],[131,185,205],[132,186,207],[133,187,207],[132,185,207],[132,185,207],[130,182,203],[127,181,202],[123,178,201],[126,180,203],[126,180,201],[128,180,203],[129,181,204],[129,183,204],[129,182,204],[130,183,206],[130,184,206],[131,185,206],[132,186,208],[130,184,206],[127,184,204],[130,185,207],[129,184,206],[127,182,204],[124,180,202],[123,178,201],[123,178,201],[124,179,202],[125,179,202],[126,181,204],[128,182,205],[128,182,205],[130,183,206],[129,182,204],[126,181,203],[131,180,201],[133,175,194],[146,169,187],[147,167,184],[158,184,200],[173,193,209],[175,193,208],[174,192,209],[172,192,208],[163,189,208],[93,134,160],[56,106,139],[56,105,140],[54,105,138],[52,103,136],[48,102,134],[54,103,135],[57,105,137],[54,103,138],[56,108,145],[60,113,150],[60,113,149],[61,116,150],[65,120,152],[77,137,166],[100,161,185],[118,174,196],[121,175,196],[120,173,195],[120,173,194],[119,172,193],[119,173,193],[121,173,194],[122,174,195],[121,174,195],[121,174,195],[119,174,194],[121,174,195],[120,174,192],[117,172,193],[117,172,195],[116,171,193],[114,172,193],[117,172,193],[120,173,194],[118,174,194],[117,173,193],[116,172,192],[118,172,193],[117,171,192],[118,170,191],[121,170,192],[118,171,192],[116,170,190],[116,170,190],[115,170,189],[112,169,188],[112,170,187],[112,168,187],[112,167,185],[112,167,186],[111,167,187],[112,168,188],[111,168,187],[112,169,186],[111,168,187],[111,169,187],[111,169,188],[113,169,188],[115,170,188],[115,170,189],[118,172,191],[119,173,191],[119,172,191],[120,172,191],[117,171,189],[116,170,188],[117,170,188],[115,169,186],[115,168,185],[115,166,184],[114,166,183],[103,151,164],[77,89,91],[83,71,70],[99,77,74],[109,79,74],[112,78,70],[111,76,66],[105,73,61],[98,69,57],[114,76,59],[150,98,69],[159,105,72],[164,109,75],[168,114,74],[172,120,75],[175,123,79],[178,127,83],[180,130,86],[182,132,87],[182,133,86],[180,133,87],[179,133,91],[175,132,93],[166,129,94],[162,127,95],[152,128,103],[119,150,152],[110,165,180],[111,165,182],[108,164,181],[111,165,184],[110,164,183],[110,164,182],[110,164,182],[121,174,195],[121,177,197],[122,177,197],[122,177,196],[122,177,197],[124,179,198],[125,179,199],[124,178,197],[123,179,198],[125,179,199],[127,180,198],[128,180,200],[127,181,199],[127,181,199],[126,178,200],[125,178,198],[127,178,200],[128,179,200],[127,180,199],[127,180,199],[126,180,200],[126,179,199],[123,177,197],[124,178,198],[124,179,199],[126,179,201],[126,180,201],[126,179,200],[123,179,199],[125,179,200],[126,179,200],[127,181,201],[127,182,202],[126,182,200],[130,182,203],[130,182,203],[130,182,203],[127,180,201],[127,180,201],[127,180,201],[126,179,200],[125,179,200],[125,179,200],[124,178,198],[126,179,200],[127,180,201],[127,180,201],[127,181,201],[128,182,201],[129,182,202],[128,181,201],[128,181,200],[127,180,201],[128,181,201],[128,181,200],[128,181,201],[127,181,203],[126,181,203],[127,183,203],[128,182,204],[128,184,204],[129,186,205],[132,187,208],[135,189,210],[136,189,210],[134,188,208],[132,188,208],[131,187,208],[132,188,208],[133,187,208],[134,187,208],[133,186,208],[132,186,207],[132,186,207],[132,186,207],[133,187,207],[132,186,207],[130,186,205],[131,184,207],[130,183,207],[130,183,206],[130,183,207],[129,184,205],[127,183,205],[128,184,204],[129,185,205],[132,186,207],[134,187,208],[135,185,208],[134,185,207],[133,184,206],[133,183,206],[130,182,203],[130,182,203],[126,179,202],[125,179,202],[126,179,203],[127,180,202],[127,180,203],[128,181,203],[129,182,204],[130,181,204],[131,183,204],[130,182,203],[131,182,203],[131,182,203],[132,183,204],[129,182,204],[127,181,202],[126,180,202],[125,179,202],[126,179,202],[124,177,200],[122,177,199],[123,177,200],[124,178,201],[124,179,202],[125,179,202],[127,180,203],[127,182,203],[131,184,206],[132,186,207],[133,187,208],[133,186,208],[133,185,207],[128,182,203],[128,181,204],[124,178,201],[125,179,201],[127,180,203],[128,180,202],[128,180,204],[130,181,205],[129,182,204],[130,182,206],[131,185,206],[131,185,206],[131,185,207],[130,184,205],[128,184,205],[131,185,206],[128,185,204],[127,183,204],[124,179,201],[123,179,201],[124,178,201],[125,179,202],[124,179,202],[126,182,204],[126,182,202],[127,182,204],[126,182,202],[127,183,204],[126,182,204],[129,181,202],[129,179,201],[132,178,199],[137,178,198],[147,181,201],[164,190,205],[175,194,210],[173,192,209],[172,193,208],[160,187,208],[96,135,164],[57,105,140],[51,105,141],[52,107,143],[55,110,145],[52,104,138],[56,106,140],[63,112,148],[63,113,150],[61,114,151],[62,115,152],[62,115,151],[63,117,151],[70,123,156],[79,137,166],[102,164,185],[120,175,195],[121,175,196],[121,174,195],[120,173,194],[120,173,194],[120,173,194],[120,173,194],[121,174,195],[122,175,196],[121,173,195],[120,173,194],[120,173,194],[119,172,193],[118,172,193],[119,172,193],[118,172,193],[119,172,194],[119,172,193],[120,173,194],[119,174,194],[119,174,193],[119,172,193],[119,172,193],[118,171,192],[120,171,192],[120,170,191],[118,171,191],[116,170,188],[118,171,189],[115,170,188],[113,169,189],[112,168,187],[112,168,187],[113,169,187],[111,167,185],[111,167,186],[111,167,187],[111,168,188],[111,168,186],[113,169,187],[110,168,187],[111,169,188],[113,170,189],[114,169,189],[116,172,190],[118,172,191],[120,173,193],[118,172,190],[118,172,191],[114,170,188],[114,171,188],[116,171,187],[118,169,187],[115,168,184],[114,167,185],[113,163,180],[104,136,149],[101,75,68],[127,83,72],[132,88,73],[135,91,76],[133,90,76],[119,83,71],[102,72,59],[120,79,63],[150,99,68],[160,106,74],[164,110,74],[169,117,75],[171,121,76],[176,125,82],[177,128,83],[178,128,84],[182,130,86],[183,135,87],[181,134,87],[180,134,89],[179,134,90],[177,133,93],[169,129,93],[158,123,94],[142,130,112],[123,154,154],[112,165,179],[113,165,182],[112,165,184],[109,165,184],[109,163,183],[107,163,182],[120,174,195],[119,175,196],[120,177,196],[119,177,196],[123,179,198],[125,179,198],[125,178,199],[124,178,197],[125,179,199],[125,179,199],[127,179,200],[127,179,200],[128,181,200],[128,181,200],[126,179,199],[126,178,199],[129,179,200],[128,178,200],[125,178,199],[127,180,201],[126,179,199],[125,178,199],[124,179,199],[123,178,198],[124,179,199],[124,179,200],[125,179,201],[125,179,202],[123,179,199],[125,179,199],[127,179,201],[128,180,202],[128,181,201],[128,182,200],[129,182,202],[129,181,202],[129,180,202],[128,181,202],[126,180,200],[127,180,201],[128,179,201],[127,180,201],[127,179,201],[124,179,199],[125,179,200],[127,179,200],[128,181,202],[127,180,201],[128,181,201],[129,181,202],[129,181,203],[128,181,202],[128,181,202],[128,182,201],[128,181,201],[128,181,202],[125,180,202],[125,181,202],[127,182,204],[128,183,204],[126,182,204],[128,183,204],[134,187,207],[136,190,210],[136,190,210],[135,188,209],[134,187,208],[134,187,208],[134,187,208],[134,187,208],[136,186,208],[135,186,208],[134,186,208],[135,186,208],[132,186,207],[133,186,207],[132,186,207],[132,185,207],[132,185,207],[130,184,206],[130,184,205],[130,184,205],[130,184,205],[129,184,204],[130,183,204],[131,186,206],[133,186,208],[135,186,208],[134,185,207],[133,186,207],[131,185,205],[128,183,203],[129,182,204],[129,181,202],[128,179,202],[125,180,202],[126,180,203],[127,180,203],[126,180,203],[126,181,203],[126,182,204],[129,182,204],[130,182,203],[130,181,202],[128,180,202],[127,182,202],[128,181,203],[127,180,202],[128,181,202],[127,180,202],[126,179,202],[126,179,202],[125,179,202],[125,178,201],[123,178,200],[125,179,202],[125,179,201],[126,179,203],[127,180,203],[128,182,204],[130,184,204],[132,186,207],[132,186,207],[133,186,207],[132,185,206],[130,184,204],[128,181,202],[127,180,203],[126,179,202],[126,180,202],[127,179,203],[127,180,203],[128,181,202],[131,183,205],[130,182,206],[130,184,205],[131,184,206],[130,186,206],[128,184,205],[129,183,205],[131,184,205],[129,184,204],[126,182,205],[125,181,203],[125,181,203],[125,179,201],[125,179,202],[125,179,202],[125,180,202],[128,181,203],[127,182,203],[126,182,203],[127,181,203],[126,182,204],[126,182,204],[126,179,202],[128,180,203],[131,182,203],[130,180,201],[146,185,203],[172,192,208],[170,191,207],[163,190,207],[125,165,189],[79,128,160],[68,120,160],[69,122,160],[67,120,157],[66,118,158],[64,121,158],[64,122,158],[65,119,156],[65,117,154],[64,115,152],[64,114,152],[63,116,151],[63,116,150],[63,114,149],[63,117,150],[82,142,165],[122,175,196],[119,172,194],[120,173,194],[119,173,194],[121,174,194],[120,174,193],[121,174,195],[121,174,195],[120,173,194],[120,173,194],[119,172,194],[120,173,194],[118,172,193],[118,172,193],[119,172,194],[119,172,193],[122,173,195],[121,174,194],[121,173,194],[121,174,194],[122,173,194],[121,174,193],[119,172,193],[120,172,194],[119,171,192],[117,170,191],[117,170,189],[117,169,188],[117,170,188],[118,170,188],[113,169,188],[113,167,188],[113,168,188],[112,168,188],[112,168,188],[113,167,187],[111,167,187],[112,168,188],[114,168,189],[111,167,187],[111,167,187],[109,168,186],[111,169,186],[117,171,190],[115,169,189],[118,172,191],[118,171,191],[119,173,191],[117,170,188],[115,170,188],[114,170,186],[116,171,187],[117,170,187],[116,167,185],[114,166,183],[113,162,179],[93,127,139],[84,71,72],[110,75,64],[137,89,75],[143,91,77],[142,92,76],[140,91,76],[122,82,68],[99,68,55],[119,80,64],[153,100,72],[158,104,72],[164,110,77],[168,116,77],[171,121,75],[176,126,82],[177,126,82],[178,128,84],[179,130,84],[181,135,87],[182,135,87],[183,136,88],[180,133,85],[179,133,89],[175,131,92],[166,127,91],[155,121,91],[136,132,116],[119,154,160],[112,164,178],[110,164,180],[108,165,183],[108,165,184],[108,164,183],[119,173,194],[119,176,196],[119,176,196],[120,177,197],[124,178,199],[124,179,197],[123,178,197],[125,178,199],[126,179,199],[126,179,200],[125,179,200],[127,179,200],[128,180,200],[127,180,200],[126,179,199],[125,179,199],[129,179,201],[126,178,199],[125,179,199],[127,180,201],[125,179,200],[125,179,200],[124,179,200],[123,179,198],[124,179,200],[123,179,199],[126,180,201],[126,180,200],[126,179,200],[127,180,201],[126,180,200],[127,180,200],[128,181,201],[128,182,201],[128,181,200],[129,182,201],[128,181,202],[130,180,202],[128,180,202],[128,180,201],[128,179,201],[128,180,201],[128,179,201],[126,179,200],[126,179,200],[127,180,200],[130,182,203],[129,181,202],[127,180,201],[129,182,200],[130,182,201],[130,183,201],[128,182,200],[128,181,201],[127,181,201],[127,181,201],[127,181,201],[128,182,201],[129,181,202],[129,182,203],[128,183,203],[129,185,205],[133,187,208],[134,188,209],[136,189,208],[136,188,209],[135,188,209],[134,187,209],[134,187,208],[133,187,207],[133,186,208],[135,186,208],[134,185,206],[135,186,207],[135,186,208],[134,185,207],[135,186,206],[135,187,208],[132,185,207],[131,185,205],[130,183,204],[131,183,204],[131,182,206],[130,183,206],[132,184,206],[134,185,207],[135,186,208],[136,186,208],[133,186,207],[132,185,207],[133,185,207],[130,184,204],[129,182,203],[128,181,202],[128,181,202],[127,180,203],[126,180,202],[126,179,203],[126,180,202],[127,180,203],[127,181,204],[128,181,204],[128,182,203],[129,181,202],[128,180,202],[129,182,203],[127,182,203],[127,181,203],[128,181,202],[126,180,201],[126,180,201],[126,179,202],[125,179,201],[123,179,201],[123,178,201],[125,179,201],[126,179,201],[127,180,202],[128,182,202],[129,183,203],[129,184,204],[132,185,206],[132,186,206],[135,186,208],[132,186,207],[131,185,205],[127,182,202],[127,180,202],[127,180,203],[128,180,203],[127,180,202],[127,181,203],[127,180,203],[128,181,204],[129,183,205],[131,184,204],[132,185,205],[130,184,204],[130,183,203],[130,184,204],[130,184,205],[129,185,205],[126,182,204],[125,181,203],[124,180,203],[125,179,202],[126,180,203],[126,180,202],[127,180,203],[125,181,203],[126,182,203],[128,182,203],[128,181,203],[126,181,203],[125,181,203],[126,180,203],[126,181,203],[127,180,203],[123,179,200],[129,179,200],[148,187,206],[144,180,200],[94,136,165],[72,121,156],[68,121,157],[71,124,162],[69,123,161],[65,121,157],[67,120,158],[66,119,157],[62,119,155],[64,118,154],[66,118,155],[63,117,153],[62,115,152],[61,115,151],[63,117,153],[70,125,156],[81,138,166],[89,146,170],[125,176,197],[124,175,196],[121,174,195],[121,173,194],[122,174,195],[121,174,195],[122,174,195],[122,175,196],[121,173,194],[121,174,195],[121,174,195],[121,173,195],[121,174,193],[118,173,192],[118,173,193],[119,173,194],[123,173,194],[123,175,196],[125,175,196],[122,174,194],[122,173,194],[119,173,193],[120,174,192],[119,172,193],[121,173,193],[120,172,192],[117,170,189],[116,169,188],[118,169,188],[115,169,187],[116,168,187],[116,168,188],[115,167,188],[113,167,188],[112,168,188],[113,167,188],[112,167,188],[111,167,187],[111,167,187],[113,167,187],[112,167,187],[111,167,186],[111,168,185],[115,170,188],[117,171,192],[118,171,192],[119,173,193],[120,172,191],[119,172,190],[116,170,189],[116,170,188],[116,170,188],[118,169,186],[117,167,183],[115,163,177],[122,158,167],[91,97,101],[89,68,64],[120,81,68],[140,89,74],[143,90,76],[144,91,76],[138,87,73],[114,76,66],[99,69,56],[129,84,65],[150,98,68],[155,103,71],[160,107,74],[167,114,75],[169,119,72],[174,123,78],[176,124,81],[178,128,84],[180,131,86],[180,133,86],[181,134,88],[181,134,86],[182,133,86],[180,132,85],[179,133,86],[175,132,90],[166,125,89],[156,122,91],[139,136,122],[114,161,171],[111,163,179],[109,165,182],[107,164,183],[109,165,183],[120,175,195],[119,175,195],[120,176,196],[122,177,197],[123,177,197],[125,179,200],[124,178,198],[126,179,200],[126,180,200],[126,178,200],[127,179,200],[128,178,201],[127,179,200],[125,178,199],[126,179,199],[126,178,199],[128,179,200],[125,178,198],[124,179,198],[126,179,199],[125,179,200],[126,179,200],[125,179,200],[126,179,200],[124,179,199],[124,179,199],[129,181,202],[128,180,201],[127,180,201],[127,180,201],[126,180,201],[126,180,201],[128,181,201],[130,183,202],[129,182,202],[128,181,202],[129,181,201],[128,181,201],[129,182,201],[128,180,201],[128,180,201],[127,180,201],[129,181,200],[127,181,199],[128,179,201],[130,181,200],[131,181,201],[131,181,201],[132,182,202],[131,182,201],[132,182,202],[131,183,202],[130,182,201],[128,183,201],[128,181,201],[129,181,201],[129,181,200],[129,181,200],[130,182,199],[130,182,198],[128,180,194],[124,177,190],[127,179,194],[133,187,206],[135,189,210],[137,189,210],[136,187,209],[134,187,208],[134,187,208],[136,189,208],[134,186,208],[134,185,206],[134,186,207],[134,185,207],[135,186,208],[134,187,207],[133,186,207],[131,186,206],[131,184,206],[131,184,205],[132,184,205],[131,183,204],[131,184,205],[131,184,207],[131,183,205],[136,185,207],[134,185,207],[134,186,208],[132,186,207],[132,185,208],[131,184,207],[129,182,205],[128,181,203],[129,182,203],[128,181,202],[127,180,202],[124,179,202],[126,180,201],[125,179,202],[128,180,203],[129,180,203],[128,181,204],[128,181,202],[127,180,201],[128,181,202],[128,181,202],[129,182,203],[129,182,203],[128,181,202],[125,181,202],[126,180,202],[126,179,201],[125,178,201],[124,178,198],[124,178,199],[124,178,201],[126,179,202],[128,180,201],[130,182,203],[130,184,204],[131,185,205],[134,186,206],[134,186,206],[135,186,206],[132,186,207],[131,185,205],[126,182,202],[128,181,202],[128,181,202],[127,179,203],[127,180,203],[128,181,204],[128,181,203],[128,182,204],[128,182,205],[130,184,204],[130,184,204],[128,183,204],[128,183,203],[129,184,203],[129,183,205],[128,182,205],[127,182,205],[126,181,204],[126,181,204],[124,180,202],[125,180,202],[127,181,203],[127,180,202],[126,181,203],[126,181,202],[128,181,203],[127,181,203],[128,181,204],[126,181,204],[125,181,203],[127,180,203],[126,180,202],[126,179,202],[126,179,200],[124,176,197],[106,157,182],[70,120,153],[64,116,152],[68,120,157],[66,121,158],[68,120,159],[64,115,154],[67,116,155],[67,116,155],[59,112,151],[65,122,156],[82,139,171],[76,130,164],[65,114,153],[62,110,149],[58,111,146],[75,127,159],[110,166,187],[122,173,196],[124,175,196],[125,176,197],[124,175,195],[122,174,195],[122,173,195],[121,174,195],[122,174,195],[121,174,195],[122,174,195],[121,174,194],[121,174,194],[121,173,195],[122,172,193],[121,172,191],[120,171,190],[119,170,187],[113,161,177],[114,164,183],[122,170,188],[126,173,194],[125,173,193],[120,169,189],[122,171,192],[122,173,193],[122,172,192],[119,170,188],[118,169,188],[118,168,188],[116,167,186],[117,168,187],[117,168,187],[116,166,186],[116,167,187],[115,167,188],[116,167,187],[114,167,188],[111,167,187],[113,166,187],[113,166,187],[111,166,186],[110,166,186],[111,166,186],[111,168,186],[113,169,186],[116,169,187],[119,171,190],[119,171,190],[120,171,191],[118,171,189],[115,169,187],[117,169,190],[117,169,189],[116,167,185],[115,166,180],[120,164,177],[116,130,135],[91,77,75],[89,66,62],[105,75,69],[113,77,66],[114,77,66],[120,79,63],[124,78,64],[106,70,60],[103,72,61],[133,87,67],[148,96,68],[153,102,70],[158,106,74],[164,111,73],[169,117,72],[173,122,75],[176,124,79],[179,127,83],[179,130,85],[178,130,82],[180,132,85],[182,133,86],[181,132,86],[181,131,86],[178,132,85],[179,133,90],[172,129,89],[162,122,88],[154,121,91],[117,157,165],[110,164,178],[109,164,182],[106,164,181],[120,174,195],[118,174,194],[121,175,195],[123,176,197],[124,178,198],[125,178,199],[124,178,198],[125,179,200],[126,179,200],[125,179,200],[127,179,201],[127,178,201],[127,178,201],[127,178,200],[127,178,200],[127,178,200],[124,178,198],[126,178,200],[126,180,198],[126,179,199],[126,179,200],[126,179,200],[127,179,200],[127,178,199],[128,180,199],[129,182,203],[130,182,203],[129,180,202],[129,180,202],[128,180,202],[128,181,201],[129,182,201],[128,182,201],[129,182,200],[129,183,202],[129,183,201],[129,181,200],[128,181,201],[128,181,201],[128,180,201],[128,180,201],[129,181,201],[129,180,202],[130,181,201],[129,180,201],[131,181,200],[133,182,202],[130,181,201],[133,182,202],[133,183,201],[134,183,201],[134,183,202],[135,183,201],[132,182,200],[126,180,197],[126,179,199],[128,180,199],[129,181,199],[125,179,193],[112,162,167],[81,131,130],[67,118,114],[86,136,134],[116,170,180],[134,189,208],[136,190,208],[135,189,207],[135,189,207],[135,188,207],[137,188,208],[135,187,207],[134,185,207],[134,185,207],[137,186,207],[138,187,208],[136,187,208],[135,186,208],[134,185,207],[134,186,208],[133,185,207],[133,184,206],[132,184,205],[132,184,206],[133,184,206],[133,185,208],[134,185,207],[135,186,208],[133,185,207],[134,185,207],[134,186,209],[134,186,208],[133,184,206],[129,182,204],[130,182,203],[129,181,203],[128,181,203],[127,181,204],[125,179,202],[127,180,203],[128,179,202],[127,179,203],[128,180,202],[128,181,202],[126,180,202],[127,180,202],[128,181,202],[129,182,203],[128,181,203],[128,181,202],[127,181,201],[127,180,202],[127,180,202],[125,178,200],[124,178,198],[125,179,199],[124,179,201],[127,180,201],[126,180,202],[128,182,203],[129,183,203],[134,185,207],[134,185,207],[135,187,206],[135,188,207],[132,186,207],[132,184,205],[130,182,203],[128,181,202],[128,181,202],[127,180,202],[127,180,202],[128,180,202],[129,182,203],[129,182,203],[130,184,204],[128,183,203],[130,184,204],[129,183,204],[128,183,203],[129,184,204],[130,184,204],[130,183,205],[130,183,204],[129,183,204],[127,181,204],[128,181,203],[126,180,203],[127,180,201],[127,180,202],[128,182,202],[126,182,203],[128,181,203],[128,181,202],[128,181,202],[129,182,203],[130,181,203],[127,181,203],[127,181,203],[125,179,202],[125,179,202],[123,176,199],[104,159,184],[77,130,161],[63,113,150],[64,114,153],[63,117,153],[65,116,155],[63,113,151],[59,109,146],[58,109,144],[82,136,166],[105,163,188],[114,172,198],[101,162,190],[78,136,169],[65,116,151],[58,106,140],[57,108,140],[96,150,173],[127,176,197],[127,177,197],[126,176,197],[125,175,195],[124,174,195],[124,174,194],[123,173,194],[123,174,196],[122,173,195],[122,175,196],[123,175,194],[122,174,193],[121,172,194],[122,171,193],[122,171,191],[120,170,186],[104,152,166],[67,112,125],[58,100,115],[78,121,136],[115,162,178],[114,160,175],[79,126,143],[104,154,171],[120,170,189],[123,172,192],[122,171,191],[120,170,189],[119,170,189],[119,169,188],[117,168,187],[117,168,186],[119,168,187],[118,167,185],[117,168,186],[116,168,186],[117,168,187],[115,168,186],[114,167,186],[116,168,186],[115,167,186],[116,167,186],[117,168,187],[116,167,186],[116,166,185],[114,161,176],[113,164,178],[122,172,187],[120,169,186],[112,160,174],[76,124,136],[81,125,136],[115,164,180],[119,168,185],[114,163,175],[117,130,130],[105,82,76],[93,67,62],[91,66,58],[98,68,63],[105,74,65],[105,73,64],[104,71,62],[102,71,61],[97,68,59],[108,73,60],[138,90,70],[151,99,71],[155,104,71],[158,107,74],[163,113,76],[170,118,77],[175,124,79],[175,125,79],[178,128,82],[179,129,84],[180,130,85],[182,132,88],[182,132,89],[181,131,87],[181,131,87],[181,131,88],[180,134,88],[177,132,91],[169,126,90],[161,121,88],[154,123,95],[116,158,167],[110,165,180],[108,163,181],[121,174,195],[118,175,196],[121,174,195],[123,177,197],[124,178,198],[123,177,197],[123,177,197],[125,179,200],[123,178,199],[123,177,198],[125,178,199],[125,178,198],[125,178,198],[125,178,199],[125,178,199],[126,178,201],[125,179,199],[124,178,198],[124,179,198],[125,179,200],[126,179,200],[126,178,200],[127,178,200],[127,178,198],[129,180,200],[131,180,202],[130,180,202],[129,180,201],[130,181,202],[129,181,202],[129,181,202],[131,181,201],[129,182,202],[129,183,201],[128,183,200],[129,183,201],[132,181,201],[131,181,201],[129,181,200],[129,181,201],[129,181,202],[130,181,201],[129,181,201],[131,181,202],[130,182,201],[130,181,200],[132,181,201],[133,182,202],[133,182,202],[134,184,201],[136,183,201],[136,183,201],[137,184,201],[129,179,193],[106,157,165],[103,152,159],[112,164,170],[120,172,179],[89,135,136],[69,112,107],[63,107,101],[59,106,100],[64,111,101],[86,135,137],[127,181,197],[136,190,208],[135,189,208],[135,189,207],[137,188,208],[136,188,209],[135,187,207],[135,186,208],[134,186,208],[135,187,207],[138,187,208],[138,187,209],[136,187,209],[137,187,209],[135,186,208],[134,185,207],[133,186,207],[133,184,206],[134,184,206],[133,184,206],[134,185,207],[136,186,208],[135,185,208],[137,186,208],[136,186,208],[136,186,209],[134,185,207],[131,185,205],[133,184,205],[133,182,204],[133,183,203],[129,180,202],[128,180,202],[127,180,203],[128,181,202],[128,180,202],[128,180,203],[128,180,202],[128,181,202],[127,180,202],[128,181,202],[127,180,202],[128,181,203],[129,182,203],[129,182,203],[129,182,203],[129,180,202],[129,181,202],[127,179,202],[125,177,200],[128,178,201],[129,180,202],[129,181,202],[130,182,203],[132,183,204],[132,183,204],[133,185,207],[135,186,208],[135,187,206],[135,186,208],[136,185,208],[130,184,204],[131,184,204],[131,183,204],[129,181,202],[127,180,202],[129,181,202],[129,182,203],[131,183,204],[131,183,204],[129,183,203],[131,184,205],[128,183,204],[129,184,205],[131,185,205],[130,184,204],[131,183,204],[133,184,205],[133,185,206],[131,184,204],[129,182,203],[129,181,202],[127,180,201],[128,182,203],[130,182,203],[130,183,204],[130,182,203],[128,182,203],[128,182,203],[128,181,202],[130,182,203],[131,183,204],[129,183,204],[128,181,203],[125,180,201],[125,180,201],[123,177,200],[117,173,197],[109,167,192],[81,137,168],[63,115,152],[61,112,150],[59,112,149],[68,122,156],[86,142,170],[107,159,186],[118,171,195],[123,177,200],[120,176,198],[119,175,198],[113,171,196],[106,162,187],[97,152,179],[95,148,176],[112,165,187],[128,178,198],[129,178,198],[128,177,197],[127,176,196],[126,175,195],[125,174,194],[125,174,195],[123,173,195],[123,175,196],[123,174,196],[123,175,196],[126,175,196],[123,174,195],[120,173,192],[122,171,190],[110,159,175],[60,104,119],[47,88,103],[49,91,105],[53,96,110],[80,123,138],[69,112,125],[48,92,106],[56,101,116],[96,146,162],[125,173,190],[126,171,191],[124,170,189],[122,170,189],[120,170,188],[119,169,188],[119,167,187],[122,169,187],[123,168,187],[119,168,185],[117,168,185],[117,168,187],[115,167,184],[117,168,186],[114,168,185],[114,168,182],[116,168,182],[117,169,183],[118,169,185],[103,153,169],[63,103,116],[56,98,108],[79,127,138],[104,153,166],[72,119,131],[48,94,103],[55,91,100],[88,127,134],[115,159,169],[125,137,140],[125,91,84],[108,72,67],[96,66,57],[118,78,66],[140,91,74],[142,93,72],[141,92,72],[133,89,73],[116,80,70],[99,69,58],[114,76,61],[145,95,71],[155,102,71],[155,104,70],[159,107,72],[165,113,74],[169,117,77],[174,122,80],[175,124,79],[178,127,82],[177,128,83],[178,129,84],[181,130,85],[182,132,87],[182,132,88],[181,130,86],[181,131,86],[182,134,88],[182,133,89],[177,133,90],[173,130,92],[161,122,88],[154,124,96],[127,146,142],[110,162,174],[110,164,180],[121,175,195],[120,174,195],[123,176,197],[123,177,197],[121,176,196],[123,177,197],[123,177,198],[125,179,200],[124,178,198],[126,176,196],[126,176,198],[127,177,198],[126,178,197],[125,178,197],[127,178,198],[127,178,198],[128,179,199],[127,179,198],[125,179,198],[127,178,200],[128,180,202],[128,179,201],[126,179,200],[127,180,200],[127,180,200],[129,182,201],[129,182,202],[129,181,202],[128,181,201],[130,181,200],[132,182,201],[134,184,203],[131,183,202],[130,184,202],[130,184,202],[132,184,203],[134,184,204],[133,182,202],[132,181,201],[132,181,201],[132,181,201],[133,182,202],[131,181,201],[129,181,202],[131,181,202],[131,180,200],[133,181,201],[133,182,202],[131,181,201],[132,182,202],[133,183,200],[135,183,201],[135,183,201],[120,171,185],[71,122,125],[63,107,104],[73,120,116],[76,125,122],[64,107,101],[60,104,99],[59,105,100],[61,107,100],[64,108,102],[71,118,114],[122,174,186],[138,189,208],[137,189,208],[137,189,208],[136,189,208],[136,188,207],[136,187,208],[135,187,208],[134,186,207],[136,187,206],[137,187,207],[135,187,208],[136,187,209],[136,187,209],[136,187,209],[133,185,206],[133,185,208],[133,185,207],[134,185,206],[133,184,206],[134,185,207],[135,185,207],[135,186,208],[136,185,208],[135,186,208],[135,186,208],[134,186,208],[132,184,205],[132,183,204],[132,182,203],[132,182,204],[130,182,203],[130,182,202],[128,181,202],[128,181,202],[129,182,203],[131,182,203],[128,180,201],[127,180,201],[127,180,202],[128,181,202],[128,181,202],[129,181,202],[129,182,203],[132,183,204],[131,182,203],[129,182,203],[129,181,205],[129,181,203],[128,179,203],[128,179,203],[127,180,202],[128,180,201],[130,181,204],[132,183,204],[133,184,205],[133,185,206],[135,185,207],[135,186,208],[133,185,207],[134,185,207],[132,183,204],[133,184,205],[132,183,204],[128,181,203],[129,182,203],[130,182,203],[130,182,203],[131,182,203],[131,184,204],[131,184,204],[132,185,206],[132,185,206],[130,184,204],[132,185,206],[131,184,204],[130,184,204],[132,184,205],[134,185,207],[133,185,206],[131,182,203],[128,180,201],[128,181,202],[130,182,203],[131,182,203],[132,183,204],[131,184,205],[129,184,204],[127,183,203],[127,182,203],[129,183,203],[129,183,203],[129,182,203],[129,182,203],[128,181,202],[125,181,201],[125,179,200],[123,177,200],[120,176,199],[114,172,196],[106,163,188],[102,160,185],[105,163,187],[112,169,192],[118,173,198],[121,174,198],[125,176,198],[126,178,200],[126,178,200],[125,176,197],[124,176,197],[119,175,195],[118,171,193],[119,173,196],[126,177,198],[127,178,199],[127,178,197],[127,177,197],[126,176,195],[126,175,195],[126,175,195],[125,175,195],[123,175,196],[122,174,194],[123,175,195],[126,175,197],[127,176,197],[124,174,195],[121,173,192],[122,172,189],[82,127,142],[43,89,102],[46,91,105],[51,93,107],[50,93,107],[53,99,111],[49,93,107],[49,92,107],[49,93,107],[67,114,128],[109,159,174],[120,169,185],[123,171,186],[121,170,186],[119,170,186],[115,167,184],[115,166,184],[117,165,183],[120,169,185],[124,171,189],[122,169,187],[120,168,184],[103,148,164],[72,117,132],[84,135,148],[104,155,167],[99,147,159],[95,143,156],[101,152,164],[76,125,139],[43,91,103],[42,90,100],[46,94,102],[64,108,120],[50,96,107],[49,92,100],[56,89,97],[73,96,96],[106,119,121],[119,92,87],[128,84,78],[103,69,61],[100,65,56],[128,83,66],[144,93,72],[145,94,72],[146,94,73],[141,93,74],[122,82,67],[99,69,60],[115,79,66],[144,94,74],[151,99,73],[156,104,73],[160,109,73],[161,110,73],[166,115,76],[171,121,78],[174,123,79],[175,125,79],[176,128,81],[177,128,83],[180,130,85],[181,131,84],[181,131,85],[180,130,85],[180,130,85],[181,131,86],[180,133,86],[179,134,91],[178,134,93],[171,128,90],[163,122,89],[156,122,91],[143,131,112],[120,154,159],[122,175,196],[123,175,196],[121,174,195],[123,176,197],[124,178,198],[124,178,198],[124,178,199],[125,179,200],[124,178,199],[123,177,197],[124,178,198],[127,178,200],[126,179,199],[127,179,198],[126,178,198],[128,180,201],[129,179,201],[130,180,200],[129,180,199],[131,180,200],[131,180,200],[132,181,201],[130,181,203],[129,180,201],[130,180,201],[132,181,201],[132,182,202],[129,182,200],[131,182,201],[133,183,202],[134,184,203],[133,183,203],[132,184,203],[135,185,204],[134,184,203],[133,183,203],[135,184,204],[132,181,201],[132,181,201],[132,181,201],[133,182,202],[134,182,202],[134,182,202],[132,181,201],[133,182,201],[131,181,201],[131,182,201],[132,181,201],[134,181,201],[134,183,200],[133,183,201],[134,185,203],[136,184,204],[108,163,177],[60,111,109],[55,105,96],[61,106,100],[58,104,98],[58,104,98],[59,105,99],[59,105,99],[60,106,100],[64,109,103],[74,123,124],[131,182,198],[139,189,209],[136,189,208],[137,189,208],[137,189,208],[137,189,208],[136,188,207],[135,188,207],[135,187,207],[136,188,207],[136,188,207],[134,186,208],[134,187,208],[134,186,208],[134,187,208],[133,186,207],[132,186,207],[135,186,208],[136,184,207],[133,184,206],[133,184,207],[135,186,208],[135,186,208],[135,185,208],[137,186,209],[136,186,208],[136,185,208],[133,184,205],[133,184,205],[132,183,204],[130,183,204],[130,182,203],[133,182,204],[129,181,203],[128,180,201],[129,182,203],[129,182,203],[129,181,203],[128,179,201],[129,179,201],[128,180,201],[128,180,203],[128,181,202],[128,181,202],[130,182,203],[131,182,203],[131,182,203],[129,181,204],[129,180,204],[129,180,204],[129,180,204],[128,180,202],[128,180,202],[128,181,204],[131,183,205],[131,185,205],[133,186,205],[134,185,206],[134,186,207],[131,185,205],[130,184,204],[131,184,204],[132,183,204],[130,184,204],[127,182,202],[129,182,203],[129,180,202],[130,182,203],[130,182,203],[131,182,203],[133,185,206],[132,185,206],[134,185,207],[132,184,205],[133,184,205],[130,183,204],[131,183,204],[130,182,203],[131,183,204],[132,183,204],[131,182,203],[128,180,201],[128,180,201],[130,183,203],[133,184,205],[132,184,204],[132,183,204],[130,184,204],[128,183,203],[131,183,204],[132,182,204],[130,182,203],[129,182,203],[129,182,203],[127,180,201],[125,179,201],[124,178,200],[121,178,198],[122,177,198],[124,178,201],[126,178,200],[125,177,199],[122,176,199],[124,177,200],[125,177,198],[126,177,198],[127,178,200],[128,179,200],[126,177,200],[125,176,198],[125,176,197],[124,175,196],[125,176,196],[125,176,197],[127,177,199],[129,177,199],[129,178,198],[127,177,198],[128,176,196],[126,175,195],[125,176,195],[125,176,195],[125,173,194],[121,173,194],[121,174,193],[122,174,195],[119,172,193],[120,171,193],[123,172,189],[102,149,163],[52,98,112],[44,92,107],[46,94,108],[48,94,108],[47,95,108],[48,96,108],[47,96,107],[47,95,108],[49,94,106],[53,95,107],[63,106,118],[69,113,127],[80,126,138],[87,134,147],[71,119,131],[68,116,130],[104,153,169],[113,161,175],[104,153,164],[86,137,146],[94,146,156],[92,142,154],[47,96,107],[39,84,97],[50,97,110],[63,110,124],[48,97,110],[48,95,106],[54,99,114],[52,102,115],[45,95,107],[46,96,106],[46,96,106],[48,97,108],[53,95,105],[55,91,99],[62,90,94],[113,95,89],[123,90,80],[123,78,72],[95,66,57],[98,68,57],[133,86,65],[140,90,71],[144,94,74],[145,93,75],[137,89,72],[107,74,64],[96,68,57],[125,84,67],[142,93,68],[149,97,71],[151,99,71],[155,104,71],[159,107,72],[165,114,75],[169,119,77],[171,121,78],[174,125,79],[175,126,80],[177,128,81],[178,128,81],[181,130,84],[179,129,82],[181,130,82],[180,130,83],[180,130,84],[180,131,86],[180,133,86],[180,135,90],[178,135,93],[172,129,91],[161,121,86],[155,121,91],[123,177,196],[123,177,197],[123,177,197],[123,177,196],[124,178,198],[126,179,200],[125,179,200],[124,178,199],[125,179,198],[123,177,197],[124,178,198],[125,179,198],[126,179,198],[127,179,198],[127,179,200],[127,180,201],[126,179,200],[127,179,200],[128,180,199],[128,180,199],[131,180,200],[131,180,200],[130,180,200],[129,180,201],[131,181,201],[129,181,200],[129,181,201],[131,182,201],[131,181,201],[132,181,201],[133,182,202],[134,184,203],[133,183,202],[134,184,203],[134,184,203],[136,184,205],[134,182,202],[132,181,202],[131,181,200],[131,180,200],[129,180,199],[132,181,201],[133,181,201],[131,181,201],[130,180,200],[131,180,201],[130,181,201],[131,179,199],[134,181,199],[135,182,200],[137,184,200],[136,184,200],[132,180,198],[119,172,189],[73,126,128],[56,103,96],[59,104,98],[59,104,98],[57,103,97],[56,104,97],[58,105,99],[59,105,101],[64,107,104],[72,120,122],[131,181,197],[138,188,208],[138,190,208],[136,189,207],[140,189,209],[139,189,208],[136,188,207],[136,188,207],[136,188,207],[136,188,207],[135,187,207],[134,187,208],[134,187,208],[134,187,208],[134,187,208],[134,186,208],[132,186,207],[135,187,208],[135,185,208],[134,185,207],[135,185,207],[136,185,208],[136,186,208],[136,185,208],[137,185,208],[137,186,208],[138,185,208],[135,184,206],[133,183,205],[132,183,204],[131,182,203],[129,180,202],[130,180,202],[129,180,202],[129,180,202],[130,181,202],[132,181,203],[129,179,201],[129,179,201],[128,179,201],[128,181,203],[128,181,204],[129,181,204],[128,181,203],[130,182,203],[129,182,203],[131,182,204],[130,181,204],[128,180,204],[128,181,204],[129,181,204],[129,180,202],[128,181,201],[129,182,204],[132,184,206],[131,184,204],[135,185,207],[133,184,206],[132,186,207],[134,185,206],[133,184,205],[133,184,205],[132,183,204],[128,182,202],[126,182,202],[126,181,202],[129,182,203],[129,181,202],[131,182,203],[132,184,204],[134,186,205],[133,185,205],[133,183,203],[133,183,204],[133,183,204],[132,183,203],[129,182,199],[128,181,194],[128,179,190],[125,177,189],[125,179,190],[127,180,196],[127,180,199],[132,182,204],[133,184,205],[132,183,204],[131,184,204],[129,184,204],[129,184,204],[132,184,205],[130,182,203],[129,180,202],[128,181,202],[128,180,203],[128,180,204],[125,179,201],[123,177,197],[124,178,198],[123,179,199],[123,179,200],[125,179,201],[127,179,203],[124,179,200],[125,178,199],[126,177,199],[125,176,197],[123,177,197],[126,179,200],[127,177,199],[127,177,198],[125,176,195],[124,175,196],[123,175,194],[124,176,195],[129,178,200],[131,179,199],[131,178,199],[130,177,198],[129,177,197],[127,175,195],[124,174,194],[126,173,193],[127,173,193],[125,172,190],[121,169,185],[114,163,179],[107,157,172],[96,147,163],[103,154,171],[66,114,128],[41,90,103],[43,93,107],[46,94,109],[49,96,109],[51,98,111],[50,97,110],[49,96,109],[48,95,108],[49,96,108],[48,95,108],[49,95,107],[49,96,107],[48,93,106],[49,95,107],[45,92,104],[45,91,103],[51,95,107],[64,107,120],[50,96,106],[45,92,104],[53,102,110],[70,117,126],[42,93,103],[39,90,100],[42,93,103],[45,95,106],[40,95,104],[44,96,106],[49,96,106],[51,99,111],[48,99,109],[46,99,108],[47,98,108],[48,98,108],[55,96,104],[60,92,101],[70,89,91],[94,84,78],[114,85,75],[129,85,72],[114,77,67],[90,65,56],[97,68,60],[111,74,61],[115,75,63],[113,74,62],[111,72,60],[107,69,58],[95,66,55],[96,69,57],[128,86,68],[139,92,67],[143,93,68],[149,97,71],[152,99,68],[156,104,72],[161,111,72],[170,117,77],[171,122,76],[173,123,76],[175,126,80],[176,128,79],[177,128,80],[176,127,80],[178,128,81],[180,130,83],[180,130,83],[180,130,84],[178,129,84],[179,130,84],[178,132,85],[178,133,89],[174,131,90],[165,122,85],[160,118,84],[154,122,93],[125,177,196],[125,177,197],[124,177,196],[123,177,196],[124,178,198],[127,179,200],[126,179,199],[125,179,199],[124,178,197],[124,178,198],[125,179,199],[128,177,199],[128,178,199],[128,179,199],[128,179,201],[127,178,200],[126,179,200],[127,180,201],[129,181,200],[129,180,201],[128,180,200],[131,180,200],[132,181,201],[132,182,202],[132,181,201],[131,180,201],[132,181,202],[132,181,201],[131,181,200],[129,180,199],[132,183,202],[134,183,203],[133,184,203],[134,184,203],[134,184,203],[134,183,202],[130,179,198],[129,181,200],[131,181,201],[132,181,201],[131,181,200],[129,181,200],[133,181,201],[131,180,200],[131,182,201],[128,182,200],[129,181,201],[129,181,200],[135,182,201],[135,181,201],[136,183,201],[137,184,200],[122,175,193],[114,171,182],[73,126,127],[56,104,97],[58,105,98],[62,104,99],[61,103,97],[61,103,97],[61,104,99],[59,105,101],[61,108,106],[90,143,150],[138,188,206],[140,189,208],[140,189,209],[138,189,208],[142,189,209],[139,188,208],[139,187,207],[136,188,207],[136,188,207],[137,189,208],[138,189,208],[138,188,209],[136,188,209],[135,188,209],[135,188,209],[134,187,208],[133,187,208],[137,185,208],[136,186,208],[135,184,207],[136,185,208],[137,187,209],[133,186,208],[135,186,208],[135,186,208],[133,187,208],[134,187,208],[135,185,205],[133,184,205],[132,183,204],[133,183,204],[131,182,204],[132,182,203],[132,182,203],[130,181,202],[130,182,203],[130,182,203],[131,180,202],[128,179,201],[128,179,202],[128,180,203],[127,180,203],[128,181,204],[129,181,205],[129,183,203],[129,182,203],[129,182,203],[129,182,203],[129,181,205],[128,181,203],[129,181,203],[129,182,203],[128,182,202],[129,183,203],[132,184,205],[132,184,205],[132,185,206],[131,185,205],[132,186,206],[135,186,208],[134,185,206],[133,184,205],[130,183,203],[130,182,202],[129,181,202],[126,181,201],[126,180,199],[126,180,199],[128,181,202],[129,182,202],[134,184,205],[133,183,203],[132,182,202],[133,183,202],[133,182,202],[133,182,202],[115,166,173],[89,135,124],[79,120,104],[79,120,105],[74,116,103],[115,160,154],[119,171,177],[127,180,193],[131,183,202],[133,184,207],[130,182,203],[132,184,205],[128,183,204],[131,183,204],[131,182,203],[129,181,204],[129,182,204],[128,180,202],[127,180,203],[125,179,202],[124,178,199],[124,177,200],[126,179,201],[125,178,200],[126,179,200],[128,179,201],[126,179,200],[127,180,201],[127,179,200],[126,177,198],[127,178,198],[129,179,200],[129,180,199],[130,178,199],[129,178,198],[124,174,193],[122,174,192],[123,175,194],[125,178,196],[128,180,198],[131,179,197],[130,173,192],[116,163,181],[104,152,170],[100,149,167],[108,160,178],[117,167,185],[105,152,167],[68,109,123],[62,104,119],[57,103,114],[48,97,109],[48,94,109],[48,93,110],[45,94,108],[46,96,109],[48,96,110],[49,96,110],[50,97,112],[48,98,112],[49,97,109],[48,96,109],[50,96,110],[50,96,110],[50,97,109],[50,97,108],[49,96,108],[49,95,107],[47,95,106],[47,95,107],[48,95,107],[47,95,106],[44,92,103],[47,96,105],[43,94,102],[47,96,105],[45,94,104],[44,94,104],[42,94,101],[47,97,103],[47,97,103],[44,97,103],[47,98,104],[47,99,104],[48,100,103],[50,101,102],[53,99,103],[53,98,105],[55,95,102],[68,91,96],[102,87,78],[126,85,72],[128,83,72],[107,73,63],[91,66,56],[96,67,59],[102,71,63],[103,72,64],[105,74,66],[104,73,66],[100,70,62],[92,65,57],[102,72,59],[119,81,65],[142,94,69],[148,97,71],[151,100,72],[153,101,70],[155,103,71],[161,108,74],[170,116,79],[172,119,80],[173,119,76],[174,122,78],[175,123,79],[175,125,78],[176,124,78],[178,125,81],[178,127,81],[179,129,82],[180,129,82],[178,129,82],[178,130,84],[179,131,85],[178,132,86],[177,131,89],[170,126,86],[165,119,81],[158,116,78],[125,176,196],[123,176,196],[123,177,196],[124,178,197],[125,178,198],[124,178,196],[124,178,196],[126,178,198],[124,178,198],[124,178,198],[124,177,198],[128,179,199],[128,177,198],[128,177,198],[127,178,199],[127,179,199],[127,180,199],[127,179,200],[129,181,201],[129,180,202],[128,180,200],[130,180,200],[132,181,201],[132,181,201],[132,181,201],[131,180,201],[131,180,200],[131,181,201],[131,181,199],[131,180,200],[133,182,201],[132,182,200],[133,183,201],[130,179,197],[126,176,195],[111,161,177],[101,153,167],[122,174,191],[130,179,199],[131,180,199],[131,180,200],[130,181,201],[132,180,200],[130,180,200],[129,181,200],[128,180,199],[129,180,199],[128,180,199],[130,181,198],[133,182,197],[129,175,191],[104,151,160],[87,139,146],[83,138,143],[68,119,117],[55,103,96],[59,103,96],[62,104,97],[59,103,95],[60,103,96],[62,104,98],[61,105,97],[65,110,102],[91,143,141],[121,175,185],[134,186,204],[137,186,206],[137,189,208],[137,187,207],[139,188,208],[138,187,207],[136,187,206],[136,187,206],[135,187,206],[136,188,209],[138,188,209],[137,188,208],[136,187,208],[137,189,209],[135,186,208],[135,186,208],[136,186,208],[136,185,207],[135,186,208],[135,185,207],[135,185,207],[134,185,207],[136,186,208],[137,185,208],[136,187,207],[136,186,207],[136,184,205],[137,184,205],[136,183,204],[135,182,202],[136,183,203],[134,182,203],[133,181,203],[130,182,203],[131,181,203],[129,181,202],[129,180,200],[127,179,199],[125,179,200],[126,178,200],[128,179,202],[128,181,204],[132,181,205],[132,181,203],[131,181,203],[128,181,202],[129,182,203],[130,182,203],[131,182,203],[130,181,203],[130,182,203],[128,181,202],[128,181,202],[133,184,205],[133,184,206],[132,185,206],[132,185,206],[134,184,206],[133,184,206],[132,183,204],[132,183,204],[130,181,202],[129,181,202],[130,182,201],[128,180,200],[124,179,195],[125,176,189],[114,166,175],[117,168,177],[123,175,185],[124,178,186],[129,181,193],[131,183,198],[132,183,195],[119,166,163],[87,123,89],[82,118,77],[86,120,83],[84,118,82],[80,115,82],[78,113,82],[76,114,92],[78,123,111],[100,155,161],[127,183,201],[133,184,205],[133,184,205],[133,184,205],[130,183,204],[129,182,203],[130,182,203],[129,181,203],[128,180,202],[128,179,203],[125,179,201],[124,177,199],[123,177,200],[125,177,200],[126,178,199],[128,179,201],[127,178,200],[128,178,200],[126,178,199],[125,178,200],[126,177,199],[126,177,198],[129,178,198],[128,179,198],[131,179,199],[125,174,194],[113,161,178],[74,121,134],[58,106,122],[67,115,132],[109,162,177],[121,171,186],[101,149,165],[62,102,115],[49,89,100],[50,91,105],[53,97,107],[75,121,133],[62,109,121],[50,95,109],[49,96,109],[46,95,108],[43,95,107],[49,97,110],[50,97,111],[45,96,110],[44,97,109],[46,98,111],[46,97,111],[49,97,109],[50,98,109],[50,98,109],[46,97,107],[47,97,107],[48,97,109],[49,97,108],[47,98,107],[46,97,105],[47,98,105],[46,97,105],[50,97,106],[48,95,105],[46,94,103],[44,94,100],[44,95,99],[46,96,99],[46,95,96],[48,97,100],[45,94,103],[46,95,101],[50,97,100],[50,98,100],[49,98,99],[50,100,98],[50,100,97],[51,100,95],[57,102,93],[61,101,94],[64,100,93],[76,95,89],[110,86,76],[125,86,74],[130,83,70],[128,81,70],[101,71,57],[94,67,57],[121,84,71],[134,89,77],[132,89,74],[130,86,73],[128,85,72],[112,78,68],[99,70,63],[100,69,56],[132,86,64],[154,97,69],[153,98,70],[154,101,71],[154,102,70],[159,105,73],[163,109,74],[167,111,74],[171,116,76],[170,116,73],[174,122,78],[174,122,78],[175,123,79],[176,121,78],[174,122,78],[176,123,80],[178,126,82],[178,126,82],[178,126,81],[178,127,82],[177,128,83],[177,129,84],[178,130,88],[174,129,88],[168,121,85],[162,117,79],[125,176,195],[123,176,196],[122,176,195],[124,177,196],[125,177,197],[126,178,198],[125,178,197],[130,179,201],[127,178,199],[124,178,199],[124,177,198],[128,178,199],[128,178,199],[128,178,198],[131,180,200],[128,179,198],[129,180,200],[128,179,201],[128,181,201],[129,181,201],[128,180,200],[130,179,199],[131,180,200],[132,181,201],[130,179,201],[131,180,201],[132,181,201],[131,180,200],[131,180,200],[132,181,199],[133,181,199],[132,182,198],[126,176,190],[102,149,161],[69,115,122],[58,106,109],[67,121,125],[113,168,178],[130,180,199],[131,181,200],[131,180,200],[134,181,201],[135,181,201],[133,180,201],[129,181,200],[129,180,199],[129,179,199],[132,181,199],[133,182,199],[128,181,199],[111,167,178],[62,109,105],[64,109,101],[63,109,103],[59,106,100],[56,105,98],[59,104,97],[61,104,97],[61,104,98],[62,105,99],[60,105,99],[61,105,98],[64,110,101],[73,121,117],[85,130,132],[107,157,164],[133,184,199],[138,189,207],[139,188,207],[139,188,207],[139,187,208],[139,186,207],[139,187,207],[136,188,207],[136,188,207],[136,188,208],[136,188,209],[136,187,209],[136,187,208],[136,188,207],[136,187,207],[134,187,208],[137,186,208],[137,186,206],[137,186,207],[135,186,208],[134,185,207],[135,186,208],[135,186,207],[137,185,207],[137,185,207],[136,185,205],[137,184,205],[136,183,203],[136,183,203],[136,183,203],[135,182,204],[136,183,203],[133,182,202],[134,182,202],[132,181,202],[131,180,202],[128,179,200],[127,178,200],[128,180,202],[128,179,202],[129,180,202],[129,180,202],[132,182,203],[132,181,203],[133,183,203],[132,182,204],[131,182,203],[130,182,203],[131,182,203],[130,182,203],[130,182,203],[130,183,203],[133,185,207],[135,185,207],[135,185,207],[134,185,206],[134,185,205],[133,184,204],[132,183,203],[131,182,201],[130,182,203],[128,182,200],[128,182,200],[125,180,196],[123,177,190],[107,152,148],[85,126,112],[81,122,107],[80,121,104],[84,125,109],[96,141,133],[112,162,164],[121,171,170],[97,142,117],[82,121,79],[84,121,79],[85,123,79],[83,120,76],[81,117,73],[79,117,73],[78,114,75],[75,112,78],[76,125,106],[113,167,176],[129,182,202],[132,185,206],[131,184,204],[130,182,203],[129,181,203],[130,182,203],[129,181,203],[129,182,203],[130,182,203],[128,179,201],[127,178,200],[127,178,200],[125,177,199],[128,179,201],[128,179,201],[128,179,201],[128,180,200],[128,179,200],[128,178,200],[127,178,198],[125,176,197],[126,177,196],[127,179,198],[126,177,195],[108,158,174],[56,102,117],[51,94,106],[51,94,106],[52,95,108],[56,100,115],[70,119,132],[50,98,111],[50,95,109],[48,92,106],[50,93,106],[50,95,106],[49,97,110],[47,96,109],[50,97,110],[53,98,112],[47,98,110],[47,99,112],[50,98,111],[53,99,113],[49,100,112],[47,100,111],[50,99,112],[51,99,112],[52,98,112],[52,98,110],[47,99,104],[47,99,105],[47,99,104],[49,99,105],[48,98,104],[48,99,102],[52,99,101],[50,98,102],[49,98,99],[49,98,99],[48,98,98],[47,97,99],[52,98,95],[55,101,95],[54,100,86],[63,102,85],[64,104,83],[64,106,79],[66,105,76],[69,106,75],[70,107,73],[65,105,83],[64,105,85],[65,106,83],[65,107,81],[70,107,80],[75,107,83],[82,104,83],[93,97,81],[106,91,78],[123,88,75],[133,87,74],[134,86,73],[123,80,69],[96,69,61],[111,74,65],[131,90,74],[140,91,74],[143,95,76],[142,94,73],[140,93,76],[134,88,74],[101,72,63],[100,71,59],[145,92,72],[155,98,71],[157,100,72],[158,103,72],[159,104,72],[161,107,75],[163,109,77],[165,110,75],[168,113,74],[170,115,74],[170,116,74],[172,120,76],[173,121,77],[173,121,77],[173,121,77],[173,121,77],[176,123,80],[177,123,81],[178,124,81],[178,126,82],[179,127,83],[178,126,83],[175,127,82],[173,127,85],[172,126,87],[167,121,83],[125,177,196],[122,175,194],[122,175,195],[123,177,195],[125,178,197],[125,178,196],[127,178,198],[129,179,199],[127,179,198],[126,177,197],[125,176,195],[128,178,198],[129,178,198],[128,179,198],[129,178,199],[128,179,199],[127,178,199],[130,180,200],[131,180,200],[130,180,200],[129,179,199],[131,180,200],[132,181,201],[132,180,201],[130,180,200],[131,180,200],[129,181,200],[132,180,200],[131,179,198],[133,179,198],[132,179,194],[106,155,164],[70,114,121],[54,97,106],[53,98,103],[54,106,109],[70,128,129],[96,148,153],[122,171,183],[133,182,198],[134,183,200],[131,181,197],[134,182,201],[131,180,198],[130,180,199],[128,179,197],[128,179,198],[125,176,190],[114,166,181],[111,167,180],[97,154,160],[64,111,108],[62,106,98],[62,106,99],[59,104,96],[59,106,97],[58,105,96],[59,104,98],[59,105,97],[61,105,99],[59,105,99],[59,105,99],[62,105,100],[66,110,103],[69,111,107],[78,125,125],[123,174,187],[136,187,205],[141,189,209],[142,190,208],[140,188,207],[138,187,206],[140,187,207],[139,188,207],[139,188,208],[139,188,208],[139,188,209],[139,188,208],[138,187,209],[138,187,209],[136,187,208],[135,186,208],[137,187,207],[137,186,207],[137,186,206],[137,185,208],[136,185,208],[135,185,208],[137,186,208],[135,186,208],[135,187,206],[135,185,205],[136,184,205],[136,184,205],[138,184,205],[136,184,204],[133,183,203],[135,183,204],[135,182,204],[136,182,204],[135,181,203],[135,180,204],[135,180,202],[130,179,201],[129,180,202],[129,180,202],[131,180,202],[130,180,202],[131,182,202],[131,182,203],[132,183,204],[133,183,203],[131,182,202],[130,181,203],[130,182,203],[131,182,203],[130,182,203],[132,183,204],[133,184,206],[134,185,208],[133,185,207],[134,186,205],[134,184,203],[133,184,203],[131,183,203],[131,183,203],[130,184,204],[130,182,200],[129,181,198],[125,178,189],[103,153,142],[81,121,83],[79,119,77],[77,119,75],[79,119,78],[82,119,80],[82,120,87],[89,135,112],[99,146,119],[87,129,89],[86,124,79],[85,125,78],[87,126,81],[85,123,79],[83,120,75],[80,119,74],[81,118,76],[79,118,75],[79,117,74],[83,126,101],[116,170,174],[132,185,204],[132,183,204],[131,183,204],[132,183,204],[128,181,202],[128,181,201],[130,182,202],[128,182,201],[128,180,201],[128,178,200],[127,178,200],[125,178,200],[127,178,200],[128,179,201],[129,180,200],[129,181,200],[129,180,201],[128,180,200],[128,178,198],[125,176,196],[125,176,198],[125,176,196],[124,175,194],[84,131,147],[50,94,107],[47,92,107],[49,95,109],[52,98,112],[51,101,114],[54,103,115],[52,100,112],[50,98,110],[50,96,108],[50,97,107],[51,98,108],[49,98,110],[50,99,111],[51,98,111],[52,99,112],[50,100,111],[50,101,111],[50,100,108],[50,100,105],[50,101,106],[49,100,106],[49,100,109],[52,99,108],[52,98,108],[53,97,106],[52,99,102],[53,100,100],[52,100,99],[51,100,100],[51,100,98],[51,100,96],[57,102,92],[63,103,87],[64,103,84],[66,103,81],[66,105,75],[59,104,88],[62,106,85],[70,107,78],[71,108,75],[71,108,75],[72,108,75],[71,109,73],[71,108,72],[72,108,70],[73,109,68],[75,110,69],[75,110,68],[75,109,67],[78,110,69],[83,109,70],[83,108,70],[93,104,72],[106,96,69],[119,91,71],[132,88,72],[135,88,72],[136,87,71],[122,81,69],[91,65,57],[102,71,63],[123,82,66],[126,83,68],[123,83,68],[121,81,70],[119,79,68],[116,79,68],[100,69,60],[108,74,63],[149,94,73],[157,100,72],[159,103,72],[158,103,72],[159,104,72],[159,106,72],[161,106,74],[160,107,73],[164,110,75],[167,111,75],[166,111,75],[168,113,74],[172,119,75],[172,120,76],[172,120,76],[172,119,77],[172,120,77],[174,119,77],[174,121,78],[176,123,80],[177,124,81],[175,123,80],[174,122,79],[171,121,78],[171,122,79],[169,120,80],[123,176,194],[124,176,195],[125,177,196],[125,177,197],[124,177,196],[125,177,196],[127,178,198],[129,178,198],[127,179,198],[125,177,197],[126,178,198],[127,177,196],[128,177,197],[128,179,199],[128,177,199],[128,178,198],[128,177,199],[131,180,200],[131,180,200],[131,180,200],[129,180,199],[131,180,200],[132,181,201],[132,181,201],[132,181,201],[132,181,201],[131,181,198],[132,179,198],[132,178,196],[128,175,190],[100,147,154],[63,105,108],[55,95,101],[55,95,100],[53,99,104],[61,115,119],[63,121,121],[64,112,113],[98,147,154],[127,177,189],[121,172,181],[103,151,161],[107,157,165],[127,177,191],[128,180,197],[122,175,189],[123,174,188],[98,147,153],[66,117,118],[63,115,116],[65,117,116],[64,108,101],[60,105,97],[60,105,97],[59,105,95],[59,104,94],[59,106,96],[59,105,98],[60,105,99],[59,105,99],[58,105,99],[58,106,100],[64,106,101],[66,109,102],[66,108,101],[63,107,101],[93,143,148],[130,180,194],[129,181,195],[139,189,208],[139,188,207],[139,187,208],[139,188,206],[141,188,206],[141,188,206],[142,188,206],[141,188,207],[140,187,208],[140,188,209],[138,187,208],[139,187,208],[137,187,209],[138,187,209],[140,187,209],[137,186,207],[138,186,207],[136,186,208],[137,186,208],[140,187,209],[139,186,208],[137,185,206],[139,185,206],[135,184,205],[134,183,203],[136,184,205],[134,184,203],[134,184,203],[133,184,203],[133,183,204],[133,182,203],[133,182,203],[132,180,202],[133,181,202],[131,180,202],[131,180,202],[131,180,202],[129,180,202],[130,182,203],[130,183,203],[130,182,203],[132,183,203],[132,182,203],[133,184,205],[131,182,203],[131,182,203],[130,182,203],[130,182,203],[132,183,204],[133,184,206],[133,184,205],[133,184,205],[134,185,204],[132,184,202],[132,186,198],[129,182,198],[127,180,196],[126,180,195],[126,179,194],[127,180,195],[123,176,184],[95,150,141],[80,124,88],[82,121,79],[80,121,77],[80,123,80],[80,121,79],[81,123,80],[84,125,84],[87,129,80],[87,129,80],[87,127,79],[87,127,80],[87,128,80],[87,127,79],[82,123,77],[80,122,75],[80,123,74],[80,121,75],[79,120,74],[77,120,82],[94,142,123],[124,175,185],[133,183,202],[133,182,202],[133,184,203],[128,181,202],[128,181,201],[129,181,201],[128,180,201],[127,179,200],[127,178,200],[127,178,200],[128,178,200],[128,178,200],[128,180,200],[129,181,202],[132,183,202],[129,181,200],[131,180,198],[117,164,182],[112,162,180],[109,159,179],[119,169,190],[116,166,186],[70,118,135],[50,95,109],[48,95,109],[50,97,111],[50,99,112],[50,101,114],[49,102,114],[48,101,113],[48,99,111],[48,99,111],[49,98,109],[50,98,108],[50,98,109],[51,99,109],[52,99,110],[51,100,110],[50,101,106],[50,101,106],[54,101,107],[53,101,103],[53,101,100],[53,101,100],[54,101,99],[57,101,95],[59,101,95],[61,100,92],[62,101,93],[61,101,96],[63,103,90],[66,105,88],[68,107,84],[70,108,84],[71,109,79],[75,108,78],[72,106,74],[74,107,74],[74,107,70],[74,107,67],[75,109,67],[79,111,68],[80,111,68],[80,111,69],[79,111,70],[76,112,66],[76,111,67],[79,112,66],[77,112,65],[80,112,65],[81,111,67],[80,110,64],[82,111,64],[90,110,65],[98,105,62],[112,96,61],[123,91,65],[130,89,66],[137,89,72],[139,89,74],[135,86,69],[113,75,61],[92,66,57],[94,69,63],[103,70,59],[105,70,59],[105,70,59],[106,72,62],[106,71,60],[100,71,61],[91,67,59],[114,76,63],[150,97,75],[157,100,74],[159,102,72],[160,103,71],[159,102,70],[159,105,71],[159,103,70],[157,102,69],[161,105,70],[162,107,71],[163,107,71],[164,108,72],[167,112,74],[167,113,72],[167,115,75],[167,114,75],[170,114,77],[170,116,77],[172,117,77],[172,118,78],[171,117,77],[170,116,77],[169,116,77],[167,114,75],[169,116,79],[168,117,79],[125,177,195],[128,177,196],[129,178,197],[128,177,197],[127,179,197],[128,179,198],[128,179,198],[126,176,196],[126,176,196],[124,175,195],[127,178,197],[128,178,197],[128,178,198],[131,178,199],[129,178,198],[132,179,199],[132,180,199],[132,181,199],[131,180,200],[128,180,199],[130,180,199],[132,181,201],[133,182,201],[133,182,202],[131,182,200],[132,181,200],[130,179,198],[129,179,196],[128,175,190],[95,139,147],[53,97,101],[49,92,95],[52,92,97],[53,93,98],[54,108,110],[62,118,122],[60,114,114],[58,106,102],[64,111,109],[82,131,131],[67,112,111],[62,105,103],[82,129,130],[120,172,181],[119,172,181],[95,149,152],[80,135,135],[64,111,103],[59,106,97],[60,108,96],[60,109,99],[62,106,96],[61,105,95],[61,104,93],[60,104,91],[61,105,93],[61,106,96],[62,106,98],[62,107,98],[60,105,98],[60,106,99],[60,107,100],[63,107,102],[64,108,105],[65,107,104],[65,109,106],[82,128,129],[89,134,143],[82,127,138],[121,167,184],[140,189,207],[140,188,206],[140,188,207],[142,189,207],[142,188,206],[143,189,207],[140,188,206],[141,187,208],[141,187,208],[141,187,208],[140,187,208],[138,187,207],[138,187,208],[138,187,208],[138,187,207],[137,187,207],[137,186,207],[140,187,208],[140,186,208],[138,185,207],[139,185,206],[140,185,207],[135,184,205],[135,185,204],[134,185,205],[134,186,205],[133,184,205],[134,185,205],[133,184,205],[133,183,205],[134,183,204],[133,181,202],[132,181,203],[131,180,202],[130,180,202],[130,180,202],[132,181,203],[128,181,202],[129,182,203],[131,183,204],[132,183,204],[132,183,205],[132,183,204],[132,183,204],[130,182,203],[132,183,204],[132,183,204],[133,182,204],[133,183,205],[133,184,205],[133,184,205],[132,184,201],[128,180,186],[114,163,153],[105,151,130],[99,145,122],[98,143,121],[103,152,131],[115,170,175],[120,174,180],[102,157,146],[81,126,86],[83,124,80],[82,124,80],[78,124,77],[79,126,77],[80,126,80],[82,128,84],[86,129,82],[88,129,80],[86,130,79],[85,130,79],[85,130,81],[85,128,79],[84,128,79],[82,124,77],[81,124,77],[80,124,77],[79,122,76],[80,120,76],[79,122,85],[104,156,149],[130,182,197],[133,183,202],[135,184,202],[131,183,198],[126,179,192],[115,172,180],[116,172,180],[126,178,196],[127,179,197],[129,179,199],[128,179,199],[128,180,199],[128,180,199],[130,181,200],[132,181,201],[132,181,201],[121,169,185],[76,119,135],[52,95,110],[50,94,108],[62,106,120],[78,121,137],[56,103,118],[48,95,109],[49,97,110],[52,100,113],[54,101,114],[49,102,113],[49,102,112],[49,100,110],[48,100,109],[50,100,111],[51,100,110],[52,100,107],[50,98,104],[51,100,105],[52,100,104],[51,100,102],[52,102,101],[52,102,100],[55,102,98],[61,104,97],[65,103,96],[65,104,91],[67,107,89],[69,106,81],[70,106,77],[71,107,78],[76,107,75],[77,108,72],[79,108,72],[79,111,72],[78,112,70],[76,110,74],[76,111,69],[77,111,69],[77,110,67],[78,110,65],[77,109,62],[77,109,62],[77,110,60],[81,112,62],[82,113,64],[83,113,65],[82,113,65],[81,114,64],[83,114,64],[82,113,62],[82,113,64],[82,113,64],[86,113,66],[87,113,66],[87,113,65],[95,110,63],[107,103,62],[119,96,64],[132,88,66],[138,89,67],[141,88,69],[143,89,73],[130,84,70],[105,71,63],[99,68,60],[112,77,66],[119,80,67],[119,81,67],[122,80,68],[122,83,68],[119,83,69],[100,72,63],[92,68,59],[110,77,62],[149,98,74],[153,98,74],[152,99,70],[153,99,71],[151,98,69],[152,97,69],[152,97,69],[152,97,69],[151,97,71],[153,98,72],[152,99,70],[153,99,70],[155,101,69],[157,103,70],[161,106,74],[161,110,75],[162,109,74],[162,109,75],[164,109,76],[163,109,75],[164,110,76],[165,111,77],[163,109,76],[161,109,76],[160,108,77],[161,108,77],[128,178,197],[127,178,195],[129,178,196],[128,177,196],[126,177,194],[129,179,196],[127,179,195],[116,166,179],[85,133,139],[95,146,153],[119,171,185],[126,178,193],[126,177,191],[125,175,190],[126,175,191],[129,178,197],[129,179,198],[131,180,199],[131,180,199],[132,181,201],[132,180,200],[133,179,200],[132,180,200],[134,180,201],[130,179,197],[128,178,195],[127,177,192],[126,177,189],[91,139,146],[53,96,101],[48,89,95],[48,89,94],[48,91,95],[53,100,103],[60,116,117],[61,118,118],[56,109,104],[54,104,96],[58,106,98],[62,109,103],[58,104,98],[58,105,97],[65,112,108],[91,143,144],[68,119,117],[53,105,98],[61,113,106],[59,107,99],[59,106,97],[60,107,98],[62,107,96],[67,106,96],[67,106,95],[68,105,93],[63,100,86],[63,103,92],[65,106,95],[66,108,96],[68,108,97],[66,107,99],[61,106,97],[60,106,97],[63,108,103],[65,107,104],[64,106,106],[64,105,105],[64,103,104],[64,104,104],[64,101,105],[87,127,137],[136,184,202],[142,188,206],[140,186,204],[129,177,195],[134,181,199],[144,189,210],[144,189,209],[141,187,208],[140,187,208],[138,187,207],[141,187,208],[142,189,209],[142,188,208],[141,187,206],[138,187,207],[138,187,207],[138,187,207],[140,187,208],[139,186,207],[139,187,207],[140,185,207],[139,184,206],[137,184,205],[134,184,203],[134,186,205],[134,185,205],[134,186,205],[135,186,205],[135,185,206],[134,184,204],[134,183,205],[133,181,203],[132,181,203],[130,179,201],[131,180,202],[131,180,202],[131,180,202],[129,182,202],[129,182,203],[130,183,204],[132,183,204],[133,184,205],[132,183,204],[132,183,205],[132,182,204],[132,182,203],[133,183,204],[133,183,205],[134,183,205],[132,183,203],[133,184,200],[118,168,168],[92,140,115],[83,127,88],[84,127,84],[83,127,81],[84,129,84],[84,132,88],[87,135,93],[97,148,111],[93,145,104],[78,127,78],[80,127,78],[80,128,79],[80,128,78],[81,130,78],[83,132,81],[83,132,83],[83,131,81],[86,132,82],[85,132,79],[81,131,78],[85,133,82],[82,131,80],[80,131,80],[80,129,78],[80,127,77],[78,126,78],[79,124,78],[80,122,77],[79,121,76],[83,132,104],[116,169,170],[132,184,197],[130,180,191],[118,168,171],[106,158,151],[81,135,116],[81,133,114],[95,144,131],[108,160,166],[129,179,197],[131,180,198],[129,180,199],[130,180,200],[131,181,201],[131,181,200],[129,179,198],[91,141,155],[51,96,109],[52,96,109],[49,95,107],[49,96,108],[58,100,115],[53,99,111],[51,99,111],[53,102,113],[51,101,112],[52,103,112],[51,103,112],[54,102,108],[52,102,105],[51,101,104],[55,101,104],[56,102,102],[53,99,102],[55,100,100],[58,101,98],[61,103,96],[67,104,92],[70,106,85],[72,108,84],[72,108,83],[76,109,81],[74,107,82],[73,108,81],[75,109,77],[79,111,74],[80,111,70],[79,111,71],[81,111,70],[82,112,69],[82,111,67],[83,113,68],[83,113,66],[82,113,67],[84,113,66],[84,112,64],[84,112,64],[82,112,63],[81,112,60],[79,111,60],[80,111,59],[81,113,60],[83,113,62],[81,114,62],[83,114,63],[81,114,62],[84,114,63],[82,113,59],[82,113,60],[83,114,62],[83,115,61],[85,115,61],[89,113,63],[96,109,62],[109,102,63],[126,95,65],[138,90,69],[143,89,70],[145,89,74],[143,89,72],[131,82,69],[100,69,64],[106,71,63],[126,84,69],[139,91,70],[143,92,74],[143,91,73],[140,92,73],[130,88,71],[103,73,66],[94,67,59],[121,86,73],[146,95,74],[146,95,73],[145,93,71],[146,94,68],[146,94,71],[146,93,71],[146,93,70],[146,92,73],[143,92,74],[144,93,76],[140,91,75],[147,96,74],[147,97,72],[150,98,72],[151,101,76],[153,104,77],[156,106,79],[156,105,76],[159,105,76],[159,108,77],[160,109,78],[161,109,82],[157,106,82],[157,108,83],[155,106,80],[155,105,81],[129,176,195],[130,178,195],[125,176,188],[117,172,180],[113,168,177],[116,172,179],[120,173,181],[97,144,148],[65,107,105],[83,124,127],[112,164,173],[114,165,172],[89,140,141],[73,121,120],[74,121,125],[118,167,180],[128,177,192],[129,178,194],[129,181,194],[128,179,196],[134,181,199],[133,180,199],[133,180,198],[133,180,197],[111,162,174],[93,146,155],[89,141,151],[82,132,139],[55,99,101],[53,91,94],[48,87,91],[42,88,91],[49,103,103],[61,117,114],[63,117,116],[60,112,106],[53,105,97],[52,104,95],[56,105,96],[58,105,97],[55,104,95],[53,104,94],[54,103,94],[57,105,96],[51,102,90],[54,103,92],[56,104,89],[56,105,91],[57,105,92],[67,106,92],[77,106,94],[82,106,96],[87,105,95],[95,103,93],[81,99,89],[95,106,98],[92,109,101],[81,107,98],[80,106,100],[75,107,100],[64,107,99],[61,108,99],[61,108,102],[58,106,102],[60,105,103],[63,104,105],[60,103,102],[62,104,103],[70,109,113],[121,168,184],[127,176,189],[94,137,146],[67,111,122],[98,141,155],[135,182,200],[143,188,209],[142,187,208],[141,187,208],[138,186,206],[139,187,207],[142,189,207],[141,188,206],[141,188,207],[139,186,207],[139,186,207],[139,187,206],[140,186,207],[139,186,207],[139,186,207],[136,185,206],[136,184,205],[135,185,204],[135,184,203],[136,185,205],[134,185,205],[137,186,206],[135,185,205],[136,185,205],[136,184,204],[137,184,204],[134,183,203],[133,182,204],[132,181,203],[131,180,203],[131,180,202],[133,181,203],[132,182,202],[130,182,203],[131,182,203],[131,182,203],[130,182,203],[133,184,205],[133,184,205],[132,183,204],[131,183,204],[131,182,203],[133,183,203],[133,183,202],[133,183,201],[121,172,175],[92,140,120],[81,127,84],[81,127,81],[82,129,81],[80,128,81],[80,129,82],[83,133,84],[86,136,83],[81,133,84],[80,133,86],[81,131,81],[80,130,78],[80,130,79],[80,132,82],[81,133,82],[82,134,82],[84,133,82],[83,133,82],[84,133,83],[80,133,79],[82,133,79],[81,133,79],[81,131,80],[81,133,81],[79,130,80],[77,128,78],[76,127,79],[76,126,78],[73,124,77],[72,122,77],[77,127,83],[99,151,132],[115,170,168],[97,150,133],[77,129,99],[71,121,87],[70,119,81],[69,117,82],[70,118,86],[83,132,121],[117,167,176],[128,177,191],[115,164,178],[103,153,167],[107,158,174],[125,175,193],[126,177,193],[86,137,150],[53,98,110],[53,97,107],[49,96,106],[50,96,108],[54,97,108],[52,98,108],[54,100,107],[55,102,109],[56,103,109],[56,103,107],[55,102,104],[56,102,102],[58,101,97],[61,101,94],[60,101,96],[63,104,95],[64,105,94],[67,106,89],[70,105,87],[73,109,80],[75,109,78],[76,110,78],[74,111,76],[75,111,76],[77,111,74],[78,110,71],[80,112,69],[81,112,65],[83,114,66],[84,113,67],[83,112,67],[82,112,64],[85,113,67],[85,114,64],[86,114,63],[87,115,64],[87,114,64],[88,115,65],[89,115,65],[87,113,64],[85,112,63],[85,114,62],[85,114,62],[83,114,60],[84,115,59],[85,115,62],[84,115,61],[83,116,62],[86,116,64],[86,116,64],[86,116,61],[84,116,61],[84,115,61],[86,115,61],[88,116,61],[93,117,63],[97,112,64],[114,104,71],[138,108,84],[149,109,91],[151,101,85],[152,102,89],[149,101,87],[127,83,72],[95,67,63],[96,68,63],[136,103,88],[150,110,90],[150,108,91],[153,110,95],[150,111,96],[139,102,88],[109,78,68],[99,74,67],[129,102,92],[154,121,108],[152,111,98],[153,115,102],[155,120,106],[159,125,114],[160,127,117],[161,129,118],[162,125,113],[149,114,102],[152,119,108],[153,123,113],[157,128,120],[160,132,123],[162,135,126],[162,137,129],[165,136,125],[167,134,119],[170,139,123],[173,143,127],[173,143,128],[173,143,129],[169,139,128],[171,136,123],[160,127,114],[157,126,114],[155,124,113],[128,175,192],[120,167,177],[104,153,151],[78,129,123],[70,123,118],[85,138,134],[101,153,151],[72,123,115],[57,107,98],[58,106,99],[74,121,117],[70,117,111],[61,109,100],[60,107,100],[64,111,107],[87,138,142],[87,139,140],[70,120,121],[90,140,140],[116,166,174],[132,179,197],[132,179,197],[132,180,197],[106,156,164],[61,110,105],[56,106,100],[60,107,104],[57,103,104],[52,95,97],[50,90,93],[47,90,94],[52,101,102],[56,113,109],[62,116,111],[62,113,107],[54,107,97],[53,104,94],[55,105,95],[56,106,96],[56,106,96],[55,106,96],[57,106,94],[56,105,95],[55,106,93],[54,104,92],[53,105,92],[56,105,93],[58,105,92],[63,108,94],[76,107,95],[122,96,98],[141,96,102],[150,98,104],[150,101,105],[138,96,99],[147,100,104],[152,102,108],[137,104,106],[117,106,105],[82,110,103],[70,109,104],[64,107,102],[63,107,103],[63,107,103],[62,106,102],[61,104,101],[61,105,103],[64,106,108],[85,132,135],[79,124,127],[60,103,108],[60,101,107],[67,105,114],[120,166,180],[144,188,209],[143,187,208],[139,186,206],[139,186,206],[141,187,207],[145,189,209],[143,188,207],[141,187,206],[141,187,206],[141,187,207],[141,187,208],[141,187,208],[140,186,207],[138,186,207],[138,186,206],[134,185,205],[136,185,205],[136,185,205],[136,185,205],[135,186,205],[136,186,205],[137,186,206],[136,186,205],[136,185,205],[136,186,205],[136,184,206],[133,183,203],[132,181,203],[133,181,202],[132,181,203],[134,181,204],[133,182,204],[133,182,204],[133,182,204],[134,182,204],[134,183,205],[136,184,207],[135,183,205],[133,183,204],[133,183,202],[133,183,202],[133,182,202],[134,182,202],[131,182,196],[100,151,131],[82,129,85],[82,128,83],[81,129,79],[78,129,78],[78,127,80],[79,129,80],[83,134,83],[84,135,82],[82,135,84],[80,135,84],[81,134,82],[80,133,80],[82,132,80],[81,133,82],[82,134,84],[83,134,84],[85,137,85],[84,135,84],[83,135,83],[81,133,81],[83,136,81],[82,135,81],[82,134,81],[81,132,80],[78,131,79],[80,131,80],[77,129,79],[76,127,78],[74,125,78],[76,127,80],[78,127,79],[82,135,88],[80,137,96],[73,130,85],[72,127,84],[70,123,81],[68,120,78],[68,117,80],[65,114,77],[66,116,84],[88,139,129],[89,139,147],[57,105,115],[60,106,117],[63,110,121],[87,137,151],[99,153,166],[71,120,130],[52,99,106],[51,98,105],[50,97,105],[50,96,105],[52,97,105],[54,98,103],[57,99,101],[61,102,100],[65,104,98],[64,106,99],[64,105,97],[67,106,92],[68,106,87],[69,105,82],[74,106,77],[79,110,77],[80,111,70],[79,111,69],[79,110,76],[81,112,72],[81,112,71],[83,114,72],[84,116,72],[84,116,72],[87,115,70],[86,114,70],[86,114,68],[85,116,65],[86,117,64],[88,117,65],[88,117,67],[90,117,66],[90,117,66],[88,117,64],[88,117,63],[88,117,63],[88,116,64],[90,118,64],[90,119,64],[90,118,65],[89,117,64],[88,117,62],[88,117,64],[87,117,64],[84,116,58],[87,117,61],[87,117,61],[86,118,60],[88,118,62],[88,119,63],[90,118,64],[89,117,64],[90,117,64],[91,118,63],[93,119,64],[94,119,66],[97,118,68],[109,114,77],[145,127,111],[163,136,130],[167,141,136],[168,141,137],[165,137,133],[151,124,122],[108,83,82],[96,73,68],[143,119,107],[164,139,127],[165,139,130],[163,138,126],[159,136,123],[146,120,109],[103,78,71],[97,75,70],[152,133,125],[173,155,149],[175,156,152],[175,156,154],[172,157,154],[171,156,151],[173,153,148],[172,155,149],[170,153,145],[167,151,142],[167,151,142],[168,153,144],[170,154,146],[170,151,144],[170,153,145],[171,155,149],[172,156,149],[175,158,150],[172,156,149],[175,159,153],[175,157,153],[174,156,147],[172,152,145],[170,149,142],[168,147,140],[167,147,139],[166,146,139],[124,173,182],[95,143,145],[63,111,99],[60,110,96],[59,109,97],[64,113,100],[74,126,115],[61,112,99],[56,106,94],[59,107,98],[62,108,100],[60,106,97],[54,105,95],[53,103,96],[57,106,100],[63,112,109],[58,106,104],[56,104,102],[59,108,104],[78,129,133],[127,175,189],[131,179,195],[127,175,190],[85,137,140],[57,106,99],[59,106,99],[60,104,100],[54,100,100],[47,95,95],[45,95,95],[49,99,98],[58,112,109],[58,113,109],[56,110,101],[53,107,94],[54,107,96],[54,105,95],[55,106,94],[58,106,96],[57,108,95],[55,106,94],[57,107,93],[57,107,94],[56,106,92],[54,106,92],[52,105,89],[56,105,93],[59,106,93],[72,106,93],[90,103,92],[131,95,98],[154,96,107],[168,98,113],[171,100,113],[171,101,112],[174,103,113],[179,108,118],[186,112,126],[185,111,124],[175,106,119],[155,100,110],[121,102,105],[79,109,104],[68,109,104],[64,107,102],[62,106,102],[63,106,101],[63,105,100],[62,104,100],[61,105,103],[68,114,116],[65,108,112],[64,106,110],[62,104,106],[64,102,106],[113,155,165],[148,190,204],[134,176,190],[119,163,178],[106,153,170],[110,154,172],[135,179,199],[146,189,208],[145,187,209],[145,187,208],[146,188,208],[145,187,208],[142,187,206],[142,187,206],[143,186,206],[140,185,205],[138,185,204],[138,185,204],[138,185,205],[138,185,206],[138,185,206],[138,185,206],[138,186,206],[137,186,206],[137,185,206],[137,185,205],[137,185,205],[137,185,205],[134,183,203],[132,182,203],[132,181,202],[134,181,204],[137,182,205],[134,182,204],[134,183,205],[136,183,206],[135,184,206],[135,184,206],[134,183,205],[134,182,205],[134,183,203],[133,182,202],[134,182,202],[134,182,201],[126,178,191],[91,141,115],[83,129,85],[83,132,86],[82,132,83],[80,132,82],[77,129,80],[77,128,79],[78,133,81],[80,136,83],[82,136,83],[82,137,84],[81,136,83],[82,136,83],[81,135,82],[81,136,83],[82,136,84],[83,137,84],[84,137,84],[85,136,85],[84,135,84],[81,134,84],[80,134,84],[79,134,82],[81,133,82],[80,132,81],[79,132,81],[79,132,82],[76,131,82],[74,129,81],[73,127,79],[73,127,79],[75,127,80],[77,130,83],[78,132,88],[73,130,84],[74,129,85],[72,125,83],[70,123,80],[68,120,78],[68,118,80],[66,116,78],[69,119,95],[56,108,105],[52,101,103],[53,102,104],[55,101,106],[53,101,108],[54,104,116],[58,103,112],[53,98,103],[52,97,101],[50,96,100],[52,97,101],[55,98,100],[59,100,96],[65,102,90],[69,106,90],[73,108,87],[76,111,85],[76,109,82],[80,111,77],[82,111,75],[81,110,72],[83,111,71],[85,113,69],[86,115,68],[86,114,66],[87,115,67],[88,116,68],[88,117,66],[91,119,70],[91,120,70],[90,119,71],[93,121,71],[91,119,67],[90,119,66],[90,119,66],[91,121,66],[93,121,67],[90,118,66],[91,118,65],[92,119,66],[91,118,64],[92,118,64],[92,118,64],[92,118,64],[91,118,63],[92,120,65],[92,120,65],[92,118,64],[90,118,62],[90,118,63],[89,118,64],[88,118,62],[88,118,61],[88,118,62],[87,119,62],[88,119,62],[91,119,64],[92,120,65],[89,121,64],[94,121,67],[93,122,65],[95,123,67],[95,123,67],[100,125,71],[117,128,89],[148,140,119],[165,146,137],[169,149,142],[168,148,141],[167,146,140],[159,137,131],[96,79,78],[85,68,70],[102,84,83],[108,89,84],[108,88,83],[129,108,101],[123,102,94],[111,92,86],[91,74,70],[98,79,75],[160,142,134],[174,160,154],[176,160,156],[178,162,158],[177,162,158],[177,162,157],[177,162,156],[175,160,154],[173,158,152],[172,158,151],[170,156,149],[172,157,150],[173,159,151],[174,160,151],[173,158,150],[175,161,154],[175,161,154],[177,161,153],[175,161,153],[177,162,155],[179,162,156],[177,162,153],[175,160,153],[173,158,152],[172,154,146],[172,152,147],[169,150,143],[101,149,141],[67,115,106],[58,108,94],[58,109,95],[56,108,94],[60,108,95],[58,110,95],[56,108,94],[55,105,91],[55,106,93],[59,107,98],[58,107,96],[51,104,94],[50,102,94],[55,104,97],[57,110,106],[60,111,108],[62,111,108],[62,110,106],[75,128,129],[123,172,181],[128,176,187],[116,167,175],[76,128,129],[58,108,100],[58,104,98],[58,104,98],[53,100,96],[52,99,96],[57,106,103],[59,112,106],[53,110,102],[53,108,99],[54,106,96],[53,106,94],[55,106,94],[53,106,93],[55,106,93],[56,108,95],[56,108,95],[57,109,95],[56,108,93],[56,108,93],[54,109,92],[56,106,92],[56,106,92],[58,106,92],[65,109,95],[87,105,93],[112,100,95],[150,95,105],[175,99,115],[179,101,118],[181,103,117],[183,106,118],[188,111,123],[193,116,127],[192,117,129],[192,118,129],[185,110,123],[171,102,117],[140,101,110],[73,108,103],[65,107,102],[62,106,102],[62,106,100],[62,104,100],[61,104,101],[58,104,100],[61,108,110],[64,108,112],[65,107,111],[65,107,108],[65,106,108],[99,143,150],[127,169,178],[87,128,136],[64,103,108],[62,101,106],[66,101,109],[110,156,170],[147,189,209],[144,187,207],[144,186,208],[144,186,207],[143,185,207],[145,187,206],[145,187,207],[144,186,206],[143,185,205],[142,185,204],[143,185,205],[146,185,206],[145,185,206],[144,186,205],[144,185,205],[147,187,207],[142,186,205],[142,186,207],[140,186,206],[140,186,205],[141,185,206],[138,184,205],[136,183,204],[133,183,202],[133,181,202],[133,181,204],[136,183,205],[136,183,204],[136,183,204],[136,183,206],[134,183,205],[134,183,205],[134,183,204],[134,182,204],[131,181,201],[130,179,197],[128,177,188],[119,170,168],[83,132,96],[82,131,86],[82,134,86],[82,134,85],[81,133,83],[77,132,82],[77,131,81],[76,134,80],[77,136,80],[79,137,82],[79,136,82],[81,137,84],[81,136,84],[81,136,83],[79,135,84],[79,135,85],[78,134,83],[79,133,82],[78,133,83],[81,134,84],[79,134,84],[77,133,82],[77,133,82],[78,132,83],[78,132,83],[76,132,82],[75,131,82],[75,130,82],[73,129,81],[73,128,81],[71,127,80],[71,127,81],[73,128,83],[74,128,84],[75,128,84],[74,127,87],[74,126,85],[72,124,82],[69,121,80],[65,117,78],[60,116,79],[57,113,85],[51,105,90],[53,105,99],[53,104,101],[54,102,104],[52,101,104],[54,100,100],[52,98,97],[53,97,95],[59,98,94],[58,99,96],[59,99,91],[66,102,87],[72,105,83],[76,107,77],[80,109,73],[85,111,74],[86,113,73],[83,113,71],[83,114,72],[87,115,70],[87,115,71],[88,116,68],[89,117,67],[89,118,68],[90,119,69],[91,119,70],[91,121,66],[93,122,70],[93,122,70],[95,123,70],[96,125,72],[96,125,70],[96,126,68],[95,124,67],[93,123,66],[94,123,68],[95,125,69],[93,122,67],[95,121,66],[93,121,64],[93,120,64],[93,119,65],[95,120,66],[94,120,66],[95,121,67],[95,123,68],[94,121,66],[93,119,66],[93,117,63],[93,118,64],[92,120,66],[91,120,65],[90,120,63],[91,121,65],[91,121,66],[91,120,65],[92,121,66],[92,121,66],[89,120,62],[93,122,66],[94,124,67],[97,125,69],[97,125,68],[100,127,74],[112,129,85],[152,143,126],[165,149,141],[169,151,144],[169,151,145],[168,149,145],[159,138,135],[101,85,84],[83,71,71],[95,80,80],[103,84,84],[106,87,84],[111,91,87],[113,93,89],[103,85,84],[88,73,74],[92,76,75],[154,138,130],[178,162,157],[181,165,161],[181,166,161],[181,166,160],[181,166,160],[178,164,157],[179,164,158],[177,162,155],[175,161,153],[175,161,152],[174,160,151],[176,161,152],[176,162,153],[175,162,153],[175,161,154],[178,164,157],[179,164,158],[180,165,158],[181,166,159],[181,165,158],[179,164,157],[178,163,156],[175,161,154],[173,158,151],[172,156,148],[170,153,145],[73,123,109],[58,108,91],[57,108,90],[59,110,93],[58,110,94],[63,112,97],[60,112,96],[59,110,95],[58,109,94],[60,108,97],[56,106,95],[55,107,96],[54,106,97],[49,101,95],[49,99,96],[55,105,104],[62,112,111],[61,114,112],[65,117,115],[71,122,119],[86,135,136],[86,135,136],[68,118,117],[58,108,103],[57,106,98],[56,104,98],[57,105,97],[54,104,97],[53,103,95],[56,107,99],[51,108,98],[51,108,96],[53,106,95],[54,107,94],[55,107,95],[54,108,95],[56,109,93],[56,109,94],[58,111,95],[57,110,95],[59,111,95],[57,109,94],[59,110,93],[56,109,91],[56,107,92],[57,108,93],[61,110,94],[72,110,94],[139,93,100],[168,96,112],[179,99,117],[180,100,118],[182,102,119],[184,105,119],[187,110,123],[191,116,126],[193,119,128],[194,120,129],[191,116,125],[188,110,125],[160,102,116],[75,108,103],[63,107,101],[60,106,101],[60,106,102],[59,105,103],[59,105,103],[61,107,106],[62,108,108],[63,107,107],[61,107,107],[62,109,112],[64,110,114],[68,113,118],[67,111,117],[64,107,114],[65,105,111],[64,105,112],[60,102,110],[95,144,158],[144,191,207],[143,186,201],[132,173,186],[114,158,173],[114,157,175],[141,177,194],[148,187,206],[146,185,205],[146,184,203],[145,182,202],[143,182,202],[147,184,203],[148,184,202],[147,185,201],[152,185,203],[153,185,204],[153,184,203],[149,184,204],[149,184,205],[146,184,204],[142,183,203],[138,182,203],[135,182,202],[134,182,202],[134,182,202],[135,183,205],[137,184,207],[137,184,205],[136,183,206],[136,183,206],[134,182,205],[134,182,203],[133,182,203],[131,180,201],[116,166,165],[94,143,130],[85,134,114],[81,129,91],[78,129,82],[82,133,85],[83,135,86],[80,135,85],[77,133,82],[75,131,80],[76,132,82],[73,133,81],[74,135,80],[76,133,83],[77,134,83],[76,134,82],[81,137,87],[81,136,86],[77,135,86],[75,136,84],[76,134,85],[76,132,82],[77,133,83],[77,132,83],[76,131,82],[74,129,82],[73,129,81],[74,131,81],[75,131,81],[75,130,82],[73,129,80],[73,128,80],[74,130,82],[72,128,80],[70,125,79],[71,126,83],[71,126,83],[72,127,83],[72,127,82],[70,127,83],[69,126,83],[71,123,82],[69,120,81],[65,118,78],[62,117,79],[60,114,81],[57,110,86],[58,110,90],[55,107,92],[54,104,99],[51,102,98],[55,102,93],[57,101,90],[60,101,86],[66,101,83],[71,104,79],[76,108,74],[82,110,75],[86,111,73],[85,112,70],[86,112,69],[87,113,70],[88,114,69],[90,117,69],[89,116,69],[90,118,69],[91,119,68],[89,118,66],[91,120,66],[93,122,69],[93,121,70],[93,122,71],[93,123,67],[96,126,69],[96,125,68],[96,126,68],[96,126,68],[98,127,70],[99,128,70],[97,128,68],[96,128,64],[97,128,67],[97,127,69],[95,125,69],[96,123,68],[95,123,65],[95,122,66],[95,122,67],[96,122,68],[96,123,69],[97,124,69],[95,122,67],[95,122,68],[97,122,68],[96,121,68],[94,120,66],[93,119,66],[93,120,66],[94,121,67],[93,121,66],[93,121,66],[92,120,65],[91,121,66],[93,122,67],[92,121,66],[94,124,68],[95,125,68],[96,126,68],[95,127,68],[99,129,73],[115,134,89],[159,147,133],[171,154,145],[170,152,147],[171,154,148],[169,153,148],[159,141,139],[98,84,83],[93,78,77],[140,126,119],[170,154,148],[174,157,151],[175,156,151],[160,142,137],[141,123,123],[96,80,81],[93,78,76],[163,146,141],[184,166,160],[184,166,162],[182,167,162],[182,167,162],[182,167,161],[182,167,161],[180,165,159],[179,164,158],[176,162,155],[176,162,154],[176,162,153],[176,162,153],[178,163,154],[178,163,156],[177,164,157],[180,165,159],[180,165,159],[180,166,159],[182,166,159],[182,166,159],[181,166,158],[182,165,159],[177,162,155],[174,160,152],[172,158,149],[171,155,147],[59,112,93],[59,111,93],[61,111,92],[61,111,93],[60,113,92],[59,118,92],[60,119,93],[60,117,95],[60,113,94],[60,112,95],[60,111,97],[57,109,95],[54,105,95],[52,101,93],[52,96,95],[49,93,95],[51,96,99],[55,105,106],[61,114,114],[63,120,119],[65,121,118],[63,114,109],[59,108,101],[57,106,99],[55,106,97],[54,106,96],[54,106,97],[54,107,97],[53,106,97],[53,106,96],[53,108,94],[53,107,95],[55,108,95],[55,108,94],[57,109,96],[56,110,95],[58,111,95],[59,112,96],[59,112,95],[60,112,96],[60,112,96],[57,110,94],[58,111,93],[57,112,92],[59,110,92],[58,111,92],[61,111,91],[74,112,94],[145,93,101],[173,96,113],[179,100,118],[183,100,119],[184,101,120],[185,104,120],[188,108,121],[188,111,124],[191,117,126],[191,116,125],[192,114,123],[189,108,122],[163,102,117],[77,109,101],[64,107,102],[62,107,103],[58,106,101],[58,105,98],[59,105,101],[59,106,102],[58,107,102],[58,107,104],[57,106,104],[62,109,110],[60,110,113],[64,113,116],[64,111,116],[64,110,115],[64,107,113],[63,105,111],[60,103,111],[112,161,174],[133,179,192],[107,150,160],[82,117,123],[71,100,106],[77,98,102],[163,179,193],[164,175,190],[160,169,181],[158,176,188],[142,180,199],[138,182,204],[134,182,203],[135,182,203],[137,183,205],[137,184,207],[137,184,207],[137,184,207],[135,183,205],[135,184,204],[133,181,201],[130,176,191],[91,138,114],[76,123,83],[77,127,83],[77,128,81],[79,130,83],[81,132,84],[80,134,83],[81,136,85],[76,132,81],[75,131,80],[75,130,81],[71,131,78],[71,132,77],[72,130,80],[71,131,81],[72,132,82],[74,132,83],[74,131,85],[71,129,83],[71,132,84],[68,131,81],[68,129,81],[71,129,83],[72,129,83],[70,127,82],[67,125,81],[68,125,81],[68,126,81],[69,127,81],[68,126,79],[70,127,80],[71,127,81],[73,128,83],[73,128,81],[71,126,82],[68,124,80],[67,125,79],[70,126,82],[68,126,81],[67,126,82],[66,125,81],[69,123,81],[67,120,81],[67,119,79],[67,117,78],[65,116,78],[63,115,80],[62,113,81],[59,110,83],[57,107,90],[54,106,88],[58,107,87],[63,107,82],[67,106,79],[72,105,77],[73,106,73],[79,108,73],[85,112,73],[88,113,71],[90,114,70],[89,113,69],[91,114,70],[91,117,69],[93,118,71],[92,117,68],[92,119,69],[92,120,71],[92,120,68],[91,120,65],[93,122,66],[94,122,67],[94,122,67],[94,124,67],[96,125,69],[98,126,69],[98,128,69],[99,129,71],[100,130,71],[101,131,71],[101,130,72],[101,129,70],[100,129,70],[100,129,72],[99,128,71],[98,126,69],[98,125,68],[97,124,66],[97,123,64],[97,124,65],[97,123,67],[96,123,67],[97,124,67],[96,123,66],[96,122,66],[94,120,66],[95,119,66],[94,120,66],[95,120,66],[95,120,67],[95,120,67],[96,122,68],[94,122,67],[91,121,65],[92,121,67],[93,122,67],[94,124,68],[95,127,70],[96,128,70],[97,129,70],[99,132,73],[109,133,81],[129,140,101],[169,152,142],[171,153,144],[170,153,145],[168,152,147],[158,140,137],[101,85,85],[91,76,75],[163,146,139],[177,160,152],[175,159,151],[176,160,152],[174,158,150],[167,151,144],[106,90,87],[94,79,76],[161,144,138],[184,167,160],[183,168,161],[184,170,163],[185,170,163],[185,170,164],[183,168,163],[182,167,162],[180,165,160],[177,163,156],[178,163,156],[178,163,156],[179,163,156],[180,165,158],[178,164,158],[179,164,158],[180,165,159],[181,167,160],[182,167,159],[182,168,159],[183,169,160],[181,167,158],[181,167,158],[178,163,156],[175,160,153],[172,158,151],[170,156,147],[75,116,95],[76,118,96],[75,116,93],[73,115,92],[71,118,90],[70,123,93],[68,125,93],[65,125,93],[66,123,93],[64,120,93],[61,117,94],[57,112,95],[54,109,95],[54,102,95],[53,95,96],[54,92,96],[53,88,94],[46,89,93],[53,106,109],[60,120,120],[60,118,116],[61,116,111],[58,110,101],[57,109,98],[56,108,97],[52,107,93],[54,108,97],[55,108,95],[56,108,97],[55,108,97],[55,110,96],[56,108,95],[57,109,95],[59,110,95],[56,111,94],[56,110,94],[59,112,94],[59,112,94],[59,112,95],[59,113,94],[57,112,93],[58,112,93],[59,112,94],[60,113,92],[58,111,91],[60,112,91],[67,114,92],[77,115,95],[109,102,93],[140,89,95],[170,94,108],[179,99,114],[181,102,117],[186,104,120],[188,106,121],[188,106,122],[188,107,122],[190,109,122],[189,110,123],[189,110,122],[188,108,123],[159,100,115],[74,109,103],[63,107,101],[60,106,102],[58,106,100],[57,106,99],[59,105,100],[60,104,101],[62,106,101],[58,106,102],[58,106,101],[61,108,103],[62,110,108],[66,113,116],[61,114,116],[62,111,115],[62,107,113],[63,104,110],[64,105,110],[87,133,142],[69,114,123],[64,101,110],[72,102,107],[77,97,104],[171,116,111],[198,135,127],[201,132,121],[202,131,123],[200,128,116],[192,127,117],[180,129,123],[184,129,124],[184,128,123],[189,130,125],[188,128,122],[190,129,121],[188,129,121],[188,132,124],[192,149,144],[188,163,160],[158,177,191],[140,182,201],[139,182,203],[138,182,204],[138,182,204],[137,183,204],[137,184,205],[137,184,205],[137,184,205],[135,183,203],[134,182,199],[111,161,157],[73,121,82],[75,125,81],[76,127,81],[77,128,81],[77,129,82],[78,129,81],[78,132,82],[76,131,81],[72,128,78],[73,129,79],[73,128,80],[70,129,78],[68,128,77],[68,127,78],[66,126,77],[67,126,77],[66,126,77],[69,127,80],[68,126,80],[67,127,81],[64,126,78],[65,125,78],[65,124,77],[67,125,79],[66,125,81],[66,124,81],[66,125,81],[67,125,80],[67,125,80],[66,123,79],[66,124,79],[67,125,78],[67,125,78],[67,125,78],[66,125,78],[63,122,75],[61,123,75],[65,125,79],[65,124,79],[66,123,79],[67,121,79],[65,122,80],[64,121,79],[64,119,77],[65,117,78],[66,116,78],[65,116,78],[65,115,78],[63,113,78],[63,113,80],[62,111,79],[62,110,79],[64,110,76],[68,108,74],[71,106,71],[75,106,68],[79,106,67],[86,111,71],[90,115,68],[91,115,70],[90,115,68],[91,115,68],[91,116,68],[94,118,71],[95,118,68],[95,120,70],[93,121,70],[93,122,70],[94,123,68],[94,123,68],[95,124,69],[96,126,70],[98,125,68],[98,127,69],[97,127,69],[100,130,69],[100,130,69],[100,130,71],[101,131,71],[101,130,72],[101,130,72],[101,130,71],[102,130,72],[100,129,71],[101,126,70],[101,125,68],[97,125,65],[97,123,66],[95,123,64],[96,123,64],[97,123,66],[97,122,67],[97,124,67],[95,122,64],[95,120,65],[93,120,64],[94,122,65],[96,122,67],[97,122,68],[95,121,67],[94,122,68],[88,117,64],[86,116,63],[92,121,67],[92,121,66],[95,125,69],[97,127,71],[96,128,70],[96,128,70],[97,129,71],[101,129,74],[135,140,105],[170,151,141],[173,154,146],[173,153,147],[169,152,144],[161,145,139],[102,87,84],[88,74,70],[148,131,122],[172,153,144],[173,155,147],[174,157,146],[172,156,143],[156,138,131],[96,81,79],[90,76,72],[159,144,137],[184,169,161],[185,170,160],[186,171,163],[186,171,162],[186,171,162],[185,170,165],[184,168,162],[181,166,162],[180,165,159],[177,165,158],[178,163,156],[180,164,158],[181,164,158],[181,166,159],[180,165,159],[182,166,160],[183,169,162],[184,169,162],[185,170,162],[183,169,160],[183,168,160],[182,167,159],[181,164,158],[177,160,154],[174,159,152],[171,156,148],[96,113,97],[99,114,96],[100,114,96],[99,118,96],[94,126,97],[87,130,97],[75,129,93],[69,129,92],[67,127,92],[66,127,92],[62,125,89],[59,121,91],[59,117,92],[59,113,92],[54,96,97],[53,91,96],[48,87,92],[44,86,90],[46,95,98],[52,107,107],[59,114,113],[60,117,113],[59,112,105],[57,108,98],[55,108,96],[54,108,94],[54,109,95],[55,110,96],[56,110,97],[56,110,97],[58,110,97],[56,108,95],[57,109,95],[58,111,95],[61,113,95],[58,112,94],[59,113,94],[60,114,93],[60,114,95],[59,113,93],[59,113,95],[60,113,94],[59,114,93],[60,114,92],[60,114,93],[61,115,92],[66,118,94],[72,118,94],[106,104,94],[146,86,97],[166,92,108],[178,98,113],[182,100,118],[184,103,119],[186,106,120],[188,105,121],[186,105,120],[187,106,120],[187,108,120],[188,108,121],[182,103,120],[152,97,109],[72,108,102],[62,107,101],[60,106,102],[60,106,102],[58,105,101],[57,105,100],[60,105,102],[62,105,102],[63,107,103],[62,107,103],[61,107,105],[64,110,109],[67,116,120],[67,116,120],[63,114,118],[62,112,116],[61,109,113],[63,107,111],[65,109,115],[63,106,111],[69,105,108],[74,103,105],[146,111,105],[196,124,112],[202,125,113],[202,125,109],[204,125,112],[203,124,111],[200,122,113],[196,119,109],[194,122,110],[193,122,111],[196,125,113],[197,124,112],[198,124,114],[199,126,116],[202,134,124],[207,161,155],[208,174,169],[144,180,199],[144,182,202],[143,182,205],[140,182,204],[140,182,204],[140,184,204],[140,184,205],[138,184,205],[137,184,204],[135,182,198],[99,149,134],[76,124,81],[76,126,81],[77,127,81],[76,128,81],[78,129,81],[79,130,82],[77,130,81],[75,130,80],[72,128,79],[71,127,79],[70,126,78],[70,128,81],[67,125,78],[66,125,78],[65,124,77],[63,123,76],[63,123,76],[64,122,77],[63,122,78],[62,122,79],[62,122,79],[62,122,79],[62,122,78],[63,122,78],[63,121,78],[63,121,79],[63,121,79],[65,123,80],[66,123,79],[64,123,78],[65,123,79],[65,123,77],[66,124,77],[66,123,77],[64,123,77],[62,121,75],[61,121,75],[64,123,76],[64,123,77],[65,123,77],[66,121,79],[65,120,79],[62,119,76],[62,118,76],[63,117,76],[65,117,76],[66,116,76],[65,115,75],[65,115,74],[64,113,75],[63,112,76],[60,112,71],[59,111,69],[63,110,71],[69,108,69],[74,106,68],[81,105,67],[86,108,67],[90,114,67],[93,117,66],[93,116,65],[94,116,66],[94,116,66],[96,117,69],[97,120,68],[96,122,68],[96,122,68],[94,122,68],[97,123,69],[99,126,71],[100,126,72],[99,126,70],[99,127,69],[99,128,70],[100,128,69],[100,130,71],[101,131,70],[101,131,69],[103,131,71],[103,130,72],[103,131,73],[103,131,73],[102,130,73],[102,130,72],[101,128,70],[100,126,68],[99,124,67],[96,124,65],[95,122,64],[96,121,63],[98,123,65],[99,123,66],[99,123,66],[96,121,64],[95,120,64],[94,122,65],[95,123,67],[98,123,69],[99,121,68],[94,120,68],[85,113,71],[63,94,72],[63,92,63],[81,109,62],[94,123,68],[95,126,70],[96,126,70],[96,128,70],[99,130,74],[100,130,74],[102,132,76],[130,137,103],[166,150,138],[173,154,144],[174,154,147],[172,153,146],[158,141,136],[99,84,82],[82,71,68],[105,88,85],[118,100,97],[115,96,94],[112,94,91],[108,89,86],[102,85,83],[86,73,69],[94,79,73],[166,152,143],[184,168,160],[187,172,164],[188,172,164],[187,172,163],[186,170,163],[186,171,164],[185,170,162],[184,169,162],[182,167,162],[180,166,160],[179,165,159],[181,165,159],[181,166,160],[182,167,161],[182,167,161],[182,167,161],[183,169,161],[185,170,163],[187,172,165],[187,172,166],[185,170,163],[184,169,160],[182,166,159],[178,162,155],[176,160,153],[173,158,150],[123,103,98],[121,106,98],[124,108,100],[120,113,98],[107,121,96],[93,130,94],[81,132,92],[72,132,90],[69,131,90],[68,130,90],[64,128,90],[60,125,88],[55,121,86],[57,119,89],[56,111,95],[50,98,95],[44,87,90],[49,90,92],[48,92,93],[50,97,97],[54,106,104],[61,116,113],[64,116,110],[58,111,98],[57,109,96],[57,110,96],[56,111,96],[59,111,98],[59,110,98],[58,112,98],[57,112,96],[58,112,96],[57,112,95],[60,113,95],[62,113,95],[62,115,96],[61,115,95],[61,115,94],[60,116,95],[62,116,98],[62,116,97],[62,115,95],[60,114,93],[61,115,94],[60,115,92],[62,117,92],[68,120,92],[72,121,94],[84,117,94],[129,95,96],[155,89,102],[176,97,112],[182,100,117],[183,101,119],[183,103,119],[183,103,119],[182,103,116],[182,103,116],[184,105,118],[184,104,119],[173,99,115],[137,94,105],[84,105,101],[65,108,100],[58,106,101],[61,106,101],[60,105,102],[60,105,102],[58,105,101],[58,105,101],[61,105,102],[63,106,103],[63,107,102],[63,106,105],[63,110,111],[64,118,119],[67,120,122],[67,119,122],[65,115,119],[61,113,116],[62,111,117],[65,109,115],[67,110,114],[72,108,109],[79,105,106],[120,104,100],[185,121,112],[202,127,116],[199,126,112],[199,124,110],[202,125,111],[201,124,110],[199,122,110],[197,122,111],[198,125,114],[197,126,114],[197,123,111],[197,122,111],[200,123,113],[201,125,117],[208,141,133],[213,172,165],[210,173,168],[197,169,165],[159,175,188],[149,180,199],[143,180,201],[144,182,203],[144,182,203],[143,183,204],[141,184,205],[137,184,203],[137,184,203],[130,180,191],[86,134,104],[76,124,81],[75,125,80],[75,126,80],[76,126,80],[76,127,81],[77,129,82],[76,127,81],[72,128,80],[70,126,79],[69,127,79],[68,126,77],[67,127,78],[66,124,79],[61,121,76],[61,120,76],[60,119,77],[58,119,75],[61,119,77],[60,120,77],[60,118,77],[60,117,77],[61,118,77],[60,118,78],[61,119,79],[62,119,78],[63,119,77],[64,120,78],[63,120,78],[62,120,78],[64,120,79],[64,121,78],[63,120,78],[67,121,79],[64,120,77],[63,120,76],[61,118,74],[62,119,76],[63,120,76],[63,120,77],[65,120,77],[66,119,78],[65,119,78],[67,118,78],[63,117,76],[64,117,76],[66,117,77],[65,115,75],[66,116,76],[66,114,74],[64,113,73],[64,113,76],[63,113,73],[62,112,72],[65,111,71],[68,108,69],[71,106,65],[79,104,65],[85,108,66],[89,112,68],[95,117,68],[95,117,67],[94,116,66],[96,116,67],[96,118,68],[96,118,68],[100,121,70],[99,124,69],[99,125,70],[100,125,71],[101,125,71],[101,126,71],[101,126,69],[101,126,67],[103,128,70],[103,127,69],[105,130,71],[105,131,72],[105,132,72],[107,132,72],[108,132,75],[108,132,74],[109,132,74],[107,131,74],[105,128,72],[104,127,71],[102,124,67],[100,122,66],[99,121,64],[97,119,63],[97,120,62],[98,122,65],[100,123,64],[100,122,64],[98,122,66],[95,119,66],[93,117,64],[91,115,63],[92,116,64],[96,120,67],[91,118,71],[73,103,71],[46,82,75],[43,77,73],[56,87,69],[87,115,69],[95,126,72],[91,124,74],[91,124,71],[87,120,69],[96,127,72],[105,134,80],[133,139,106],[167,151,136],[173,154,144],[175,155,146],[174,153,146],[166,146,143],[107,91,89],[87,73,72],[112,98,93],[126,109,104],[129,112,107],[126,109,105],[105,86,85],[104,87,85],[84,73,69],[94,80,73],[159,145,135],[185,169,161],[187,173,163],[188,174,165],[188,173,165],[188,172,165],[187,171,165],[188,171,166],[186,171,165],[186,170,163],[183,168,161],[183,169,162],[183,168,161],[182,167,161],[182,169,160],[182,169,161],[183,170,161],[184,170,162],[186,171,164],[188,173,167],[189,174,168],[189,173,165],[186,170,162],[183,167,160],[180,164,158],[177,160,153],[175,158,150],[152,97,104],[155,99,105],[154,99,104],[146,104,103],[126,114,100],[99,128,95],[86,133,93],[76,133,92],[69,130,89],[68,131,90],[69,130,90],[65,127,92],[57,123,87],[57,121,87],[58,121,91],[55,108,95],[54,97,95],[52,93,93],[52,94,92],[50,93,91],[49,101,99],[59,114,112],[65,117,110],[60,113,99],[60,113,96],[60,113,97],[63,115,98],[64,114,99],[63,113,99],[61,113,99],[59,113,97],[60,113,96],[60,113,96],[60,113,96],[60,114,95],[62,115,95],[63,116,96],[61,115,95],[61,116,96],[63,116,97],[64,116,96],[61,115,95],[60,114,94],[61,115,93],[63,118,93],[65,118,93],[68,118,92],[74,122,94],[82,121,92],[108,109,93],[144,93,98],[159,96,105],[174,100,114],[178,100,116],[179,101,118],[178,102,116],[177,100,114],[175,100,113],[174,100,114],[169,97,112],[157,94,108],[112,96,101],[76,105,100],[65,109,103],[59,108,101],[62,106,103],[62,106,102],[58,106,101],[58,105,101],[59,104,100],[62,105,102],[62,105,102],[61,106,101],[61,106,104],[61,112,113],[66,123,125],[68,125,126],[69,123,125],[68,119,122],[64,115,120],[63,114,119],[66,115,119],[70,113,117],[77,111,114],[173,118,109],[201,130,118],[206,138,127],[205,139,126],[205,139,125],[203,131,118],[202,125,112],[200,124,110],[201,129,118],[206,142,129],[200,142,128],[203,144,130],[204,145,130],[201,131,119],[202,125,112],[209,151,139],[212,174,166],[211,174,167],[206,172,166],[188,159,155],[166,171,185],[158,174,193],[155,180,200],[150,181,200],[144,182,201],[145,182,200],[132,180,193],[128,179,191],[126,174,180],[87,133,102],[74,122,79],[75,123,79],[73,124,80],[73,124,79],[73,125,79],[75,127,80],[73,125,81],[71,124,79],[68,123,79],[69,124,79],[68,123,77],[66,123,77],[66,123,80],[62,120,77],[59,117,77],[58,117,77],[59,116,76],[60,116,75],[59,115,76],[60,114,75],[63,115,77],[62,116,76],[59,115,77],[60,115,77],[62,116,77],[63,117,77],[62,116,76],[62,118,76],[62,117,77],[63,118,77],[61,117,75],[61,117,76],[64,118,78],[63,119,76],[60,117,75],[61,118,73],[61,118,74],[62,118,74],[60,116,74],[61,118,76],[64,118,76],[63,117,75],[63,116,73],[64,116,74],[63,116,75],[65,116,76],[64,115,75],[65,115,75],[65,113,73],[66,113,74],[64,112,73],[66,111,74],[67,110,72],[67,109,70],[68,108,69],[73,105,67],[80,104,67],[85,106,66],[93,111,68],[94,115,66],[97,115,67],[97,115,68],[97,114,67],[99,116,69],[100,118,69],[101,120,69],[101,123,70],[101,124,69],[101,124,68],[102,126,71],[101,125,70],[101,125,69],[102,124,68],[103,125,68],[103,125,69],[104,124,68],[107,128,72],[109,130,72],[110,130,72],[112,130,72],[112,129,72],[113,130,74],[112,129,75],[110,126,73],[110,125,72],[107,122,67],[104,120,66],[103,119,64],[101,118,66],[99,118,64],[99,116,64],[99,114,63],[99,115,63],[102,117,65],[100,114,65],[93,112,63],[83,99,65],[78,96,62],[84,107,66],[78,106,73],[53,88,76],[40,79,78],[40,79,78],[48,84,78],[78,110,73],[83,117,74],[74,111,75],[57,94,81],[54,87,72],[76,106,72],[106,131,83],[126,141,103],[169,153,143],[174,155,147],[175,156,147],[174,155,147],[160,141,137],[100,84,84],[91,77,75],[147,135,128],[177,163,155],[176,162,154],[176,161,153],[177,160,154],[161,145,142],[100,85,85],[91,76,72],[161,147,138],[186,170,162],[188,172,164],[190,174,167],[188,174,166],[189,172,166],[188,172,166],[188,172,166],[187,171,163],[186,170,163],[185,170,163],[184,170,162],[184,170,161],[185,170,162],[185,170,161],[183,170,160],[183,170,161],[186,171,163],[187,172,165],[189,174,168],[190,176,167],[188,174,166],[186,171,163],[183,168,161],[183,166,159],[178,161,154],[175,158,151],[170,100,115],[170,101,116],[166,100,112],[158,97,106],[151,100,103],[133,114,101],[94,133,95],[79,134,94],[70,131,90],[69,131,90],[70,131,91],[67,128,91],[65,124,92],[64,123,93],[65,122,95],[60,114,95],[59,107,97],[55,101,94],[50,98,94],[48,97,92],[47,97,92],[51,104,97],[61,114,104],[60,114,99],[60,114,95],[61,115,95],[64,116,98],[64,115,99],[62,115,97],[61,114,97],[60,114,97],[60,114,96],[60,113,95],[59,113,94],[59,112,92],[60,112,92],[60,114,93],[60,115,95],[61,114,95],[62,115,95],[61,115,95],[59,115,93],[60,115,92],[62,116,94],[62,117,93],[66,120,95],[65,120,95],[71,121,96],[80,123,97],[89,117,95],[118,104,95],[144,97,99],[155,99,106],[161,99,109],[166,100,112],[161,103,109],[161,102,108],[168,98,110],[167,98,111],[157,98,109],[130,100,104],[89,104,100],[68,107,101],[58,108,101],[59,107,102],[62,106,102],[62,106,102],[61,105,101],[61,105,101],[61,105,101],[62,106,101],[62,105,101],[57,106,104],[60,109,109],[67,121,125],[71,127,131],[71,126,131],[71,126,130],[69,123,126],[67,121,126],[69,121,124],[73,119,123],[76,116,119],[85,111,114],[128,107,102],[190,123,114],[206,145,138],[215,170,164],[214,172,164],[213,170,160],[205,142,128],[202,124,111],[202,125,112],[204,140,129],[215,168,160],[213,172,164],[213,171,160],[213,169,157],[205,140,127],[202,126,111],[206,141,127],[215,170,163],[212,175,166],[206,169,156],[195,147,130],[199,138,122],[188,144,136],[178,155,159],[159,174,183],[139,156,157],[96,127,117],[90,135,128],[95,141,129],[81,126,92],[74,119,80],[73,121,79],[72,120,78],[72,120,77],[73,122,79],[73,124,79],[72,122,78],[69,122,79],[67,120,78],[67,120,77],[67,118,77],[67,119,78],[67,120,80],[63,117,77],[59,112,76],[60,112,77],[61,113,77],[60,113,77],[59,112,76],[59,112,76],[60,114,78],[60,113,78],[60,113,78],[59,113,78],[61,114,76],[62,114,76],[61,114,76],[61,114,76],[62,114,76],[61,114,76],[61,116,75],[62,114,75],[62,116,76],[61,117,74],[60,117,73],[60,117,74],[61,116,74],[60,115,73],[59,116,73],[58,116,73],[60,116,73],[58,115,71],[60,115,73],[63,116,73],[62,115,73],[63,114,74],[63,114,75],[64,114,74],[64,113,73],[64,112,72],[65,112,72],[66,111,74],[67,109,74],[67,107,72],[67,105,70],[72,104,67],[81,104,67],[85,104,65],[92,108,65],[96,113,67],[98,115,68],[99,113,68],[98,113,67],[99,114,68],[100,115,68],[102,117,68],[105,120,69],[107,122,71],[107,122,71],[105,120,70],[102,119,67],[102,116,65],[106,114,67],[106,118,67],[110,120,71],[111,119,71],[114,119,71],[116,119,72],[118,119,74],[117,120,73],[116,121,72],[119,121,74],[121,119,74],[121,115,72],[120,112,69],[122,107,71],[118,106,67],[122,104,69],[122,102,70],[114,103,69],[119,93,73],[118,86,70],[121,87,70],[122,92,70],[122,92,70],[116,86,71],[104,76,71],[96,76,73],[69,87,76],[52,85,80],[42,84,82],[40,84,83],[41,82,81],[52,90,78],[66,101,80],[48,90,77],[42,83,84],[41,82,82],[56,89,71],[100,125,83],[134,141,109],[168,152,140],[174,155,146],[174,155,148],[174,155,148],[165,148,141],[105,91,90],[100,85,82],[171,157,148],[184,168,159],[182,166,155],[182,165,156],[182,164,157],[175,159,153],[108,95,92],[95,81,78],[172,156,148],[187,171,164],[188,174,165],[190,175,166],[189,175,166],[188,174,167],[187,173,166],[187,173,167],[187,174,167],[187,171,164],[185,170,162],[185,170,162],[185,170,163],[185,170,162],[185,170,161],[183,170,161],[183,169,161],[185,171,162],[188,172,165],[189,174,166],[191,174,168],[191,175,168],[188,173,164],[184,169,160],[181,164,157],[176,161,153],[174,160,151],[180,106,123],[179,107,122],[174,104,118],[168,100,113],[156,100,105],[140,109,102],[98,133,97],[82,134,94],[73,131,91],[70,132,91],[67,131,90],[66,129,91],[66,125,92],[64,123,91],[63,120,90],[62,116,95],[62,114,98],[61,110,98],[54,105,95],[52,102,94],[49,102,94],[48,102,93],[57,109,98],[61,114,98],[61,115,95],[62,116,96],[64,117,96],[62,117,96],[59,116,94],[61,115,95],[61,115,96],[61,114,95],[60,114,94],[59,112,91],[56,109,89],[55,109,88],[58,111,91],[59,114,91],[58,112,91],[57,111,90],[59,112,91],[59,114,92],[61,117,94],[64,117,94],[63,118,93],[64,120,94],[65,119,94],[69,121,95],[71,121,96],[82,120,100],[94,115,96],[120,103,97],[132,103,101],[134,103,102],[130,108,104],[121,113,104],[122,110,102],[133,105,102],[135,106,107],[116,106,102],[75,108,100],[66,107,101],[56,106,99],[55,105,99],[59,104,101],[62,106,102],[61,105,101],[60,104,101],[62,105,102],[63,106,102],[64,107,103],[62,106,101],[63,110,108],[67,122,124],[72,128,132],[72,127,132],[71,126,131],[69,124,130],[71,124,130],[72,123,127],[73,121,125],[83,119,122],[93,112,113],[149,112,105],[195,125,116],[210,158,150],[213,175,166],[213,174,166],[214,174,164],[209,156,144],[201,124,111],[202,124,111],[204,142,131],[215,173,163],[212,175,167],[213,175,166],[212,171,161],[207,147,135],[202,126,112],[201,132,118],[214,165,154],[212,172,161],[203,150,133],[201,134,115],[202,134,115],[201,133,113],[200,135,115],[196,136,120],[194,143,134],[175,148,143],[136,120,104],[98,108,86],[79,111,81],[74,112,81],[71,112,80],[70,113,78],[71,116,77],[69,117,78],[70,116,79],[73,117,80],[71,118,78],[69,116,77],[67,114,75],[66,115,75],[66,113,76],[66,113,75],[64,114,75],[63,114,75],[60,112,73],[60,111,75],[59,109,75],[58,109,75],[58,110,77],[59,110,78],[59,110,77],[59,112,77],[58,111,77],[57,110,77],[55,110,74],[59,110,77],[62,109,76],[61,110,73],[61,112,74],[60,112,74],[59,111,73],[60,112,74],[60,112,74],[62,113,76],[62,114,74],[59,113,74],[62,113,75],[64,114,76],[63,115,76],[61,115,76],[60,114,74],[59,113,73],[58,113,74],[60,114,75],[61,114,75],[60,114,73],[63,113,73],[64,112,74],[63,111,73],[65,111,72],[64,110,72],[67,111,73],[68,110,74],[67,107,72],[67,105,71],[71,102,68],[80,96,65],[90,94,66],[93,97,67],[102,97,70],[107,100,70],[109,107,73],[112,107,76],[110,103,71],[109,100,69],[111,101,69],[116,99,73],[120,98,76],[117,103,73],[120,100,73],[118,98,72],[118,94,70],[116,89,68],[118,85,69],[122,87,70],[126,91,72],[135,90,78],[132,93,76],[133,95,74],[138,95,78],[141,94,80],[144,94,81],[146,93,82],[148,93,80],[141,92,76],[142,89,75],[144,87,77],[146,84,79],[147,81,79],[149,80,79],[147,79,80],[146,78,81],[141,77,78],[142,77,78],[140,77,76],[140,76,76],[136,74,76],[126,72,75],[115,74,76],[105,76,76],[61,84,82],[49,86,86],[43,86,87],[41,86,87],[43,87,88],[44,88,87],[42,85,85],[41,86,83],[42,86,83],[51,87,77],[88,116,83],[128,134,106],[163,150,135],[173,154,144],[174,155,147],[175,158,150],[161,142,135],[98,84,83],[92,77,74],[162,147,139],[185,169,159],[183,166,155],[183,166,154],[184,166,156],[168,152,143],[100,86,85],[93,78,77],[157,143,139],[187,170,164],[187,172,165],[188,173,166],[189,175,168],[189,175,168],[188,173,167],[187,173,167],[189,174,167],[187,172,165],[186,171,165],[184,171,163],[184,170,161],[186,170,164],[185,170,161],[185,170,161],[185,170,161],[187,172,165],[188,174,165],[189,175,166],[190,175,166],[190,175,166],[188,171,164],[184,170,161],[179,164,158],[177,162,154],[174,160,151],[180,110,123],[181,110,124],[178,108,121],[173,103,117],[158,98,106],[141,108,102],[100,132,97],[83,137,96],[72,133,91],[70,133,91],[67,132,91],[65,130,94],[62,126,92],[62,124,91],[62,120,91],[62,117,94],[61,117,95],[59,117,93],[55,115,92],[56,112,96],[56,111,97],[55,109,97],[59,111,97],[61,114,96],[64,115,96],[65,118,98],[63,117,97],[61,118,95],[59,117,95],[60,116,95],[63,116,96],[61,116,95],[61,115,94],[59,112,92],[57,111,91],[57,111,90],[56,110,89],[57,111,89],[54,109,89],[54,109,89],[57,110,89],[59,113,90],[63,118,95],[63,117,94],[61,118,93],[61,120,94],[65,120,95],[64,121,92],[70,121,96],[76,121,98],[82,119,97],[86,119,97],[91,118,97],[99,114,98],[94,120,100],[91,122,103],[88,123,102],[89,120,99],[90,117,102],[85,115,103],[73,111,101],[68,110,103],[60,106,100],[57,104,99],[57,105,100],[59,104,99],[60,105,100],[59,105,100],[60,104,100],[59,104,100],[62,106,101],[62,106,101],[62,105,100],[60,109,103],[63,118,117],[72,128,130],[72,128,132],[72,128,132],[70,126,130],[72,124,128],[74,123,126],[79,122,126],[93,119,121],[134,115,110],[185,121,112],[201,130,119],[216,165,157],[214,174,166],[213,175,167],[211,173,164],[211,159,148],[203,125,112],[201,124,112],[209,148,136],[213,174,166],[212,175,167],[212,174,167],[213,173,163],[211,151,139],[202,125,111],[203,128,113],[213,158,142],[211,157,142],[202,137,119],[201,131,113],[201,133,114],[199,132,114],[201,132,114],[202,132,113],[202,130,112],[196,126,110],[158,116,99],[106,103,80],[77,106,76],[73,107,77],[70,108,77],[68,108,78],[69,112,75],[68,111,77],[68,112,76],[68,114,75],[68,114,76],[68,112,76],[65,110,75],[65,111,75],[64,110,76],[65,109,76],[65,108,77],[63,108,79],[61,107,76],[60,107,75],[59,107,74],[56,106,72],[58,107,75],[57,105,75],[57,106,76],[58,107,76],[56,107,74],[55,107,74],[54,107,73],[58,107,76],[61,106,76],[60,106,75],[57,107,74],[56,106,73],[57,107,74],[57,108,73],[57,109,74],[58,109,75],[58,108,74],[57,108,72],[60,110,74],[62,112,74],[60,111,73],[61,111,75],[62,113,76],[63,112,75],[60,111,74],[59,111,74],[60,112,74],[60,110,73],[61,110,76],[63,110,75],[63,109,73],[63,108,71],[63,108,71],[66,109,72],[66,108,71],[69,103,69],[75,99,69],[82,94,69],[100,82,71],[114,78,72],[120,78,75],[125,75,78],[127,74,79],[127,73,79],[129,75,78],[128,74,76],[127,74,76],[124,79,73],[127,78,76],[128,77,77],[128,76,77],[127,73,75],[126,71,75],[129,72,76],[127,71,72],[125,71,71],[126,69,71],[129,69,75],[136,69,79],[141,71,81],[148,72,83],[152,73,84],[156,74,85],[155,79,84],[155,79,85],[154,80,83],[154,78,81],[155,76,82],[152,74,81],[152,74,81],[153,75,81],[153,76,80],[153,75,81],[152,76,83],[149,76,82],[151,77,81],[149,75,80],[152,74,79],[153,74,79],[149,73,82],[134,72,79],[124,74,78],[104,79,83],[65,86,87],[57,87,89],[47,89,91],[45,90,91],[42,89,90],[42,90,91],[41,88,89],[39,88,85],[47,89,83],[72,103,78],[116,124,100],[165,149,137],[173,154,143],[176,157,148],[176,158,149],[162,145,138],[97,83,81],[85,71,69],[107,91,85],[114,94,91],[127,108,104],[123,106,101],[114,99,93],[141,122,114],[98,83,80],[100,85,84],[170,154,151],[188,170,166],[188,172,167],[188,173,167],[189,175,168],[187,173,166],[188,173,167],[186,173,166],[187,172,166],[188,173,167],[186,172,165],[184,171,163],[184,171,162],[186,171,163],[186,170,161],[185,170,161],[185,170,162],[187,171,165],[187,173,165],[189,174,167],[189,174,165],[189,174,167],[187,172,165],[184,170,161],[180,165,157],[175,161,152],[173,158,150],[180,110,123],[180,110,123],[180,109,122],[174,103,116],[160,98,106],[140,107,102],[90,133,97],[78,137,94],[70,134,90],[70,132,92],[69,132,94],[70,130,96],[66,126,97],[64,122,95],[62,118,93],[61,118,93],[62,118,95],[60,119,94],[59,118,92],[60,118,94],[61,119,94],[63,117,96],[63,116,97],[64,117,97],[63,117,96],[64,119,97],[64,120,96],[64,120,97],[61,118,96],[59,117,96],[63,117,95],[64,118,94],[63,116,94],[62,115,95],[61,116,95],[59,114,93],[57,112,90],[58,112,91],[60,115,93],[60,114,93],[61,113,91],[61,114,92],[63,117,94],[63,119,95],[64,120,97],[65,122,99],[62,123,97],[61,123,96],[64,124,97],[70,124,97],[76,123,98],[74,125,98],[77,125,99],[79,125,99],[77,125,100],[77,124,101],[78,123,100],[80,122,101],[77,118,100],[69,112,99],[64,111,100],[62,110,106],[62,108,106],[62,107,103],[62,106,102],[63,104,101],[61,104,100],[61,103,101],[58,103,99],[58,103,100],[59,106,101],[60,107,101],[60,105,100],[59,107,103],[63,113,112],[71,126,128],[73,128,132],[75,128,133],[76,126,130],[79,126,129],[83,126,127],[91,123,121],[156,119,108],[194,125,111],[205,133,122],[216,161,150],[215,166,154],[215,165,152],[212,163,150],[212,147,135],[201,123,110],[203,125,112],[207,136,119],[213,158,147],[213,159,149],[212,163,153],[209,159,149],[208,140,129],[203,123,110],[204,125,109],[208,142,123],[205,142,124],[203,131,115],[204,130,114],[203,130,113],[201,130,111],[200,130,111],[202,130,111],[200,128,111],[195,123,108],[184,123,111],[142,110,93],[91,103,78],[74,103,77],[69,105,77],[67,106,76],[69,109,77],[69,109,78],[68,108,78],[68,108,76],[69,108,77],[65,105,75],[65,106,76],[63,106,76],[63,105,76],[63,106,78],[60,105,75],[60,104,76],[60,104,76],[61,105,75],[60,104,75],[60,104,75],[58,104,75],[57,105,76],[56,104,75],[56,104,75],[57,105,76],[56,105,74],[54,104,75],[56,104,75],[60,103,75],[59,103,75],[58,103,74],[57,102,73],[57,103,73],[58,105,73],[56,105,74],[57,105,74],[57,106,74],[57,106,74],[59,107,73],[61,109,75],[61,110,76],[61,110,75],[62,111,76],[62,111,76],[62,111,76],[61,110,75],[62,110,74],[60,108,73],[61,108,77],[62,107,76],[65,107,75],[65,105,73],[65,104,73],[64,105,69],[67,102,69],[82,95,72],[102,85,75],[112,77,76],[116,72,76],[118,71,75],[122,71,75],[125,72,78],[128,71,80],[128,71,80],[127,74,80],[128,76,81],[130,77,81],[130,74,79],[134,75,85],[132,73,85],[133,76,84],[134,75,84],[134,77,85],[134,78,85],[134,78,84],[134,77,84],[128,70,77],[129,65,75],[135,66,78],[140,68,79],[146,72,81],[153,76,85],[158,76,85],[160,79,88],[161,80,89],[159,79,88],[159,79,87],[158,78,86],[158,78,85],[158,78,86],[158,77,85],[159,77,85],[159,76,85],[160,78,88],[159,78,89],[160,79,88],[157,78,86],[159,77,86],[160,77,85],[160,76,84],[157,72,84],[146,71,79],[134,73,81],[108,78,84],[93,81,85],[71,87,89],[59,89,91],[50,91,92],[46,93,93],[46,93,94],[47,91,94],[42,90,89],[47,91,89],[61,96,82],[92,111,93],[158,144,131],[173,154,142],[177,157,147],[178,158,149],[168,150,142],[102,86,83],[91,76,74],[120,101,96],[127,108,102],[123,106,102],[125,109,105],[111,95,94],[104,90,88],[91,75,75],[98,85,81],[174,160,153],[186,172,166],[187,174,168],[187,174,168],[189,176,169],[186,172,166],[186,172,166],[185,173,166],[185,172,166],[187,173,167],[187,172,166],[185,171,165],[186,171,164],[185,170,163],[185,170,163],[183,170,161],[185,170,163],[186,171,164],[189,174,166],[190,175,168],[191,175,167],[190,175,167],[188,173,166],[187,170,164],[182,167,158],[178,162,154],[173,159,150],[179,108,121],[179,109,121],[178,104,118],[170,99,112],[158,95,106],[123,113,99],[86,134,96],[73,135,91],[69,133,89],[67,131,90],[69,131,94],[65,127,94],[62,125,94],[63,121,94],[62,118,92],[62,119,93],[63,119,93],[61,120,93],[62,119,93],[63,120,93],[65,121,95],[65,120,96],[64,119,96],[64,121,95],[66,122,97],[64,122,95],[65,122,96],[68,125,99],[63,122,95],[64,120,94],[63,118,93],[63,118,94],[61,117,93],[63,119,95],[62,118,95],[62,116,96],[61,116,95],[61,116,94],[62,120,95],[64,119,96],[63,117,94],[65,119,94],[63,118,95],[65,120,96],[67,122,100],[68,123,100],[68,124,101],[67,125,101],[67,124,98],[68,125,97],[69,126,99],[69,127,102],[72,127,101],[73,126,100],[71,127,101],[70,125,100],[71,124,100],[72,123,100],[66,115,100],[58,105,95],[55,105,98],[61,111,109],[65,113,114],[62,111,109],[62,108,105],[63,106,102],[61,103,102],[61,101,101],[59,101,102],[57,104,103],[58,104,102],[59,104,101],[61,106,100],[62,108,102],[60,111,109],[70,125,127],[74,128,132],[76,129,132],[81,126,129],[87,125,126],[98,123,119],[157,118,113],[190,121,113],[201,124,112],[204,127,115],[210,144,131],[209,143,128],[207,140,124],[206,137,122],[205,129,116],[202,124,112],[201,123,109],[197,120,106],[203,130,116],[203,129,117],[202,126,117],[201,127,116],[201,123,113],[202,122,109],[201,121,108],[203,124,110],[204,127,113],[203,129,113],[203,129,113],[203,129,111],[202,129,111],[201,128,111],[200,127,109],[198,125,108],[194,123,108],[195,130,119],[180,126,113],[112,104,83],[69,99,75],[65,102,76],[65,103,77],[67,103,80],[67,104,79],[67,104,80],[66,104,78],[63,101,75],[62,100,76],[62,101,75],[62,101,75],[62,100,75],[61,102,75],[59,101,75],[58,100,75],[58,101,75],[59,101,74],[60,102,74],[59,102,75],[58,104,76],[57,102,76],[56,102,75],[59,102,76],[59,103,76],[58,102,75],[55,101,74],[55,100,74],[58,100,75],[57,99,73],[56,100,72],[57,101,72],[58,101,73],[58,101,73],[57,101,74],[58,102,73],[56,102,72],[57,103,72],[59,104,73],[62,106,76],[62,107,77],[60,108,75],[60,108,75],[61,108,75],[60,108,76],[60,106,74],[62,105,74],[62,106,74],[64,105,77],[64,106,76],[64,104,75],[65,101,74],[64,100,70],[73,96,70],[89,92,74],[112,81,79],[119,76,79],[119,75,80],[121,74,82],[129,80,89],[136,89,96],[142,97,102],[144,99,105],[147,104,110],[148,100,107],[150,105,111],[152,108,113],[157,114,118],[161,120,123],[157,118,121],[165,127,129],[172,133,137],[167,128,135],[163,123,128],[160,115,121],[167,122,129],[154,107,115],[138,81,92],[132,69,80],[135,66,80],[141,68,80],[150,72,81],[158,76,87],[162,79,90],[162,79,89],[163,81,91],[163,80,90],[161,78,88],[162,80,89],[163,80,90],[161,78,87],[161,78,88],[161,77,87],[162,79,90],[163,80,91],[164,80,91],[163,79,90],[162,78,90],[162,78,90],[161,77,89],[160,76,88],[155,73,86],[149,72,82],[140,71,79],[122,74,82],[95,80,86],[76,88,89],[59,91,94],[53,93,94],[48,95,93],[51,94,94],[50,94,93],[49,94,90],[55,96,90],[93,110,99],[160,143,132],[171,151,141],[174,155,145],[177,157,148],[163,142,136],[98,82,79],[95,80,78],[164,147,140],[180,162,153],[179,161,154],[178,162,154],[175,161,153],[156,141,137],[96,80,80],[98,84,82],[166,154,147],[187,173,166],[188,175,169],[188,175,169],[188,175,169],[187,173,167],[186,173,166],[186,172,166],[185,172,166],[186,172,164],[185,172,165],[184,172,165],[184,170,164],[184,170,163],[184,170,163],[183,171,163],[184,171,163],[185,171,164],[187,172,165],[190,174,167],[192,176,168],[192,176,169],[190,175,167],[187,170,164],[183,166,158],[178,162,154],[175,159,151],[176,102,115],[174,101,114],[172,98,112],[163,96,108],[152,97,105],[111,119,98],[81,139,96],[72,135,92],[66,131,90],[64,130,91],[64,128,94],[63,127,95],[61,123,93],[60,120,92],[61,119,92],[61,119,92],[63,122,92],[65,122,93],[65,122,94],[67,122,94],[66,122,95],[65,122,97],[66,123,96],[67,124,96],[69,126,99],[67,127,98],[70,129,100],[71,128,101],[70,127,101],[67,124,98],[64,119,94],[62,119,93],[62,120,93],[62,121,94],[63,120,96],[62,120,96],[63,118,95],[65,120,96],[65,121,97],[65,121,97],[66,121,95],[66,121,97],[67,122,96],[65,123,97],[66,124,98],[68,124,99],[69,125,99],[69,126,100],[68,124,99],[66,125,99],[67,125,100],[68,125,102],[69,125,103],[69,125,103],[70,123,102],[68,124,101],[69,123,100],[69,121,102],[64,114,100],[57,103,99],[52,97,98],[54,97,99],[61,109,111],[66,116,117],[65,114,114],[63,113,109],[59,106,105],[59,105,106],[65,113,115],[70,119,124],[66,113,117],[60,105,107],[59,104,103],[59,105,103],[58,109,109],[70,124,126],[76,129,132],[80,128,130],[91,122,120],[109,121,116],[142,123,115],[178,123,113],[199,124,117],[201,123,114],[203,125,112],[204,123,112],[205,127,113],[205,127,112],[204,126,111],[204,126,112],[203,125,111],[202,124,111],[199,120,107],[198,117,105],[199,117,106],[200,118,108],[199,119,108],[200,119,109],[201,119,111],[200,120,107],[199,118,107],[200,118,108],[200,120,109],[199,121,108],[200,123,108],[201,124,108],[201,127,111],[200,125,110],[198,124,108],[197,123,107],[192,121,106],[187,122,110],[162,115,99],[90,96,74],[65,97,77],[64,99,77],[64,101,79],[63,102,78],[63,101,77],[64,101,78],[63,100,76],[58,96,75],[60,96,77],[59,97,75],[60,98,75],[60,97,75],[58,97,75],[57,97,75],[56,97,74],[58,98,75],[58,98,74],[59,99,75],[58,100,75],[57,101,76],[56,99,76],[57,99,76],[58,100,77],[57,99,74],[56,98,73],[56,98,74],[56,99,75],[60,98,76],[59,97,75],[59,97,76],[57,97,73],[56,98,73],[55,98,71],[55,98,74],[57,98,73],[55,99,72],[55,100,72],[57,101,73],[58,103,74],[59,104,74],[58,105,74],[60,105,75],[61,107,75],[60,105,75],[60,105,74],[60,103,73],[62,103,74],[65,102,73],[65,101,75],[67,101,74],[70,97,73],[77,93,72],[97,84,74],[111,78,77],[122,76,82],[124,74,83],[128,76,86],[138,91,103],[148,113,120],[172,141,147],[180,152,156],[184,158,161],[185,159,161],[181,155,157],[189,165,167],[192,169,170],[195,169,170],[193,168,170],[182,159,160],[194,172,173],[197,176,177],[197,175,178],[192,173,175],[186,164,165],[193,170,172],[182,155,160],[160,118,127],[140,89,99],[134,71,84],[135,66,78],[140,67,78],[146,69,79],[156,74,86],[162,79,89],[162,78,90],[162,78,90],[162,79,89],[162,78,89],[162,78,89],[161,77,87],[162,77,88],[162,78,90],[162,79,90],[162,79,89],[163,79,91],[163,79,89],[161,77,86],[164,78,89],[164,78,92],[163,78,91],[160,76,88],[157,73,85],[149,71,79],[138,70,78],[127,72,79],[105,81,86],[76,89,92],[62,94,97],[50,97,98],[48,96,96],[51,95,96],[54,95,94],[57,98,93],[89,107,98],[151,140,129],[170,149,141],[172,153,145],[175,157,148],[169,149,143],[102,85,82],[105,90,85],[180,164,155],[191,173,163],[186,171,160],[184,169,160],[180,165,159],[171,155,151],[105,89,90],[104,88,87],[178,163,157],[189,175,170],[189,175,170],[188,176,169],[187,174,169],[187,174,168],[187,173,167],[187,173,166],[186,173,165],[186,172,165],[184,171,164],[183,170,163],[185,171,164],[183,170,162],[183,169,162],[185,171,164],[183,171,163],[186,172,165],[188,174,167],[192,177,169],[192,177,169],[190,175,167],[187,171,164],[184,167,159],[178,162,155],[176,160,151],[164,96,104],[161,94,104],[161,94,105],[154,96,105],[125,113,101],[84,141,99],[79,139,96],[67,135,93],[64,130,91],[64,129,95],[63,128,95],[62,126,95],[61,124,93],[57,121,91],[60,122,93],[59,121,91],[60,123,92],[63,123,93],[66,125,95],[65,125,94],[67,126,95],[68,128,96],[69,128,97],[70,129,98],[71,131,100],[70,130,98],[71,129,99],[71,130,100],[71,130,102],[68,128,98],[65,121,95],[63,119,93],[63,120,94],[64,122,96],[65,122,95],[66,122,96],[66,122,97],[66,122,96],[66,122,97],[66,122,97],[67,123,98],[66,122,98],[68,124,99],[66,124,99],[66,126,99],[67,125,99],[69,126,100],[69,126,100],[69,126,100],[67,125,99],[67,125,101],[67,124,101],[65,124,102],[66,123,101],[66,122,100],[67,121,99],[67,121,100],[66,122,100],[63,116,96],[59,105,99],[56,97,97],[53,92,93],[53,94,96],[65,113,115],[71,123,124],[68,120,120],[62,112,111],[63,110,111],[79,126,130],[92,139,144],[95,142,151],[93,141,148],[90,137,142],[72,123,126],[73,125,129],[78,131,134],[83,134,137],[97,125,126],[179,128,115],[194,127,114],[201,125,114],[203,124,113],[202,124,112],[203,124,111],[204,123,109],[202,122,108],[203,123,111],[202,124,111],[201,124,109],[202,124,110],[202,124,111],[199,119,109],[195,114,106],[189,107,98],[196,113,103],[199,117,108],[199,116,105],[200,118,108],[198,118,106],[198,116,106],[199,115,107],[199,116,106],[199,117,107],[198,117,106],[197,120,105],[198,121,108],[199,123,112],[197,123,112],[194,122,109],[189,119,108],[180,118,106],[130,102,88],[71,91,74],[65,95,78],[64,97,79],[63,100,81],[61,100,80],[61,99,79],[62,98,79],[60,96,78],[58,94,76],[57,93,76],[58,94,76],[58,95,76],[56,94,76],[57,95,75],[55,94,74],[53,95,72],[53,94,72],[56,95,73],[56,97,75],[56,98,75],[56,98,76],[55,96,76],[56,96,76],[57,97,77],[57,96,76],[55,94,73],[54,94,73],[53,94,73],[55,94,74],[55,94,74],[55,94,74],[55,94,72],[55,95,72],[55,95,72],[53,94,71],[55,96,73],[54,97,73],[55,98,75],[56,99,74],[58,101,73],[57,102,74],[59,102,76],[58,102,75],[60,103,76],[60,101,75],[60,101,74],[61,100,74],[61,101,73],[65,98,73],[68,96,73],[73,94,73],[85,89,75],[101,79,75],[112,76,77],[118,76,80],[128,76,86],[133,80,92],[150,103,114],[164,124,132],[190,165,171],[192,173,175],[189,168,171],[170,143,145],[142,91,103],[136,73,85],[135,67,78],[135,66,76],[140,69,76],[152,72,82],[159,76,87],[162,78,88],[162,79,89],[163,79,90],[163,79,90],[162,78,89],[163,78,88],[164,79,89],[164,79,91],[164,79,90],[163,79,90],[164,79,91],[163,79,89],[165,79,90],[166,79,93],[166,79,94],[163,79,91],[162,77,88],[157,73,83],[147,70,80],[139,70,79],[123,74,84],[105,80,86],[78,91,94],[64,96,99],[54,97,99],[50,98,97],[51,96,97],[56,99,95],[99,112,103],[158,145,133],[171,149,142],[173,152,145],[176,156,148],[163,143,137],[98,81,79],[96,81,77],[167,151,142],[187,169,160],[185,167,158],[185,167,158],[183,164,159],[163,147,142],[100,84,82],[102,87,84],[174,161,152],[191,176,169],[192,176,172],[188,175,169],[186,173,166],[187,173,166],[186,173,165],[185,171,163],[184,171,163],[186,171,165],[186,171,165],[186,171,164],[185,169,164],[185,170,164],[186,171,165],[189,174,167],[193,177,171],[193,177,171],[190,175,168],[188,172,165],[184,167,159],[180,163,155],[177,160,152],[162,95,105],[161,95,106],[153,98,103],[118,118,97],[88,142,100],[84,145,102],[74,141,96],[65,134,93],[63,129,93],[63,128,95],[62,127,93],[63,125,93],[60,124,93],[59,123,92],[60,123,92],[61,123,91],[61,124,91],[63,125,92],[66,127,94],[66,129,94],[68,130,97],[71,133,98],[75,134,100],[75,134,99],[75,133,97],[74,131,96],[72,130,98],[71,131,99],[71,131,99],[70,131,99],[69,126,97],[65,121,94],[66,121,95],[67,125,96],[68,125,96],[66,123,97],[67,122,97],[66,122,97],[66,122,97],[67,123,100],[68,124,101],[69,124,100],[67,123,98],[67,124,98],[66,124,98],[66,125,99],[68,125,99],[66,124,98],[68,125,99],[67,125,99],[68,126,100],[67,124,101],[65,123,100],[65,123,100],[66,124,101],[70,123,102],[67,121,100],[67,122,100],[64,118,98],[58,108,98],[54,98,95],[55,93,95],[52,88,90],[56,98,100],[66,116,116],[68,123,122],[73,122,122],[64,111,108],[67,110,110],[93,135,139],[110,153,160],[114,155,160],[116,156,162],[117,157,163],[116,158,164],[116,158,164],[109,150,153],[157,126,119],[189,128,116],[195,127,113],[200,125,113],[202,125,110],[203,124,108],[204,124,109],[203,124,108],[201,121,106],[202,122,107],[202,122,109],[201,121,109],[202,122,110],[202,122,109],[200,120,109],[194,114,107],[186,104,97],[193,111,100],[198,115,106],[199,116,106],[199,117,107],[199,117,110],[194,114,107],[195,114,106],[194,113,104],[194,112,104],[197,114,103],[197,116,103],[197,117,105],[197,120,111],[194,127,117],[192,128,117],[185,120,111],[159,113,102],[94,95,84],[70,93,83],[64,95,83],[62,97,82],[59,97,81],[61,97,82],[61,98,82],[62,98,81],[59,96,80],[54,91,75],[55,90,75],[57,92,78],[55,93,80],[55,93,79],[53,93,76],[51,92,74],[49,91,72],[52,93,73],[53,94,72],[56,95,73],[54,96,73],[54,96,75],[54,94,75],[54,93,74],[53,93,74],[57,94,75],[54,93,73],[52,92,72],[54,93,74],[56,93,75],[52,91,72],[52,91,72],[55,92,73],[55,94,74],[55,93,73],[54,92,73],[55,93,74],[56,94,74],[55,95,74],[54,97,75],[55,97,76],[55,99,75],[56,100,75],[57,100,77],[58,101,76],[58,100,76],[61,98,75],[63,97,74],[68,97,75],[74,92,74],[82,88,73],[91,84,74],[102,80,76],[113,76,77],[127,74,83],[133,76,91],[141,94,106],[165,126,134],[180,144,151],[194,169,172],[196,176,178],[196,177,179],[175,146,151],[164,121,129],[147,89,102],[132,68,83],[133,66,76],[139,67,77],[147,71,79],[154,73,82],[160,76,86],[162,78,88],[164,79,90],[164,79,91],[165,79,91],[164,78,89],[165,79,90],[165,80,91],[164,78,89],[165,80,91],[165,79,90],[165,79,90],[165,80,92],[165,81,91],[165,80,91],[164,78,91],[161,75,87],[156,72,85],[150,71,80],[138,69,80],[126,74,83],[101,85,90],[82,91,96],[65,96,98],[55,99,97],[54,101,98],[55,101,95],[90,114,107],[155,143,131],[167,149,139],[172,152,144],[175,155,148],[168,149,142],[101,85,84],[94,78,76],[117,99,97],[125,105,103],[135,116,109],[136,117,111],[132,111,107],[117,100,97],[92,76,76],[100,86,85],[175,162,156],[191,176,169],[192,176,173],[191,176,172],[187,174,168],[188,175,169],[187,174,167],[186,173,166],[185,171,164],[185,172,165],[186,171,165],[186,171,165],[186,171,165],[185,170,163],[184,169,162],[187,172,165],[190,176,167],[193,178,170],[193,178,170],[193,176,170],[190,173,167],[184,168,160],[181,164,156],[177,160,152],[136,113,103],[128,118,104],[115,126,102],[98,141,105],[85,146,104],[80,142,101],[71,138,98],[67,134,96],[65,129,96],[64,128,95],[63,125,93],[64,125,94],[61,123,94],[60,122,93],[60,122,92],[62,123,92],[62,125,92],[66,128,93],[67,129,93],[68,131,94],[73,136,99],[75,137,99],[79,136,99],[81,136,99],[84,134,97],[79,124,90],[77,119,89],[76,128,98],[78,135,103],[81,137,105],[81,136,103],[74,129,97],[68,126,96],[68,126,96],[66,126,95],[65,125,97],[67,124,98],[67,124,97],[65,124,97],[66,125,99],[68,125,99],[68,125,98],[69,126,99],[66,124,98],[66,124,98],[65,124,97],[65,124,98],[64,123,96],[65,123,96],[67,125,99],[69,124,100],[68,125,99],[67,123,98],[66,123,100],[67,123,100],[67,122,99],[66,122,98],[66,120,98],[65,119,99],[63,113,99],[58,102,97],[54,93,93],[51,89,90],[52,92,92],[57,102,101],[67,117,115],[72,122,119],[67,113,110],[63,105,101],[68,107,104],[103,142,147],[120,156,162],[122,158,162],[124,159,162],[126,161,163],[133,165,169],[132,163,168],[178,130,123],[189,128,117],[195,127,113],[198,125,114],[200,125,109],[201,124,111],[197,123,108],[185,115,103],[182,112,101],[188,115,102],[197,118,105],[200,120,108],[202,121,109],[201,122,110],[195,118,107],[192,116,106],[193,114,104],[196,116,104],[195,116,104],[197,116,106],[199,117,108],[190,113,109],[161,96,95],[146,85,84],[144,83,82],[149,90,86],[176,105,97],[194,114,102],[194,115,106],[195,118,110],[192,126,119],[190,128,124],[176,125,121],[148,125,121],[106,125,122],[81,117,117],[73,111,112],[73,112,109],[72,110,107],[72,109,106],[70,108,105],[69,104,102],[61,99,96],[58,97,93],[57,94,83],[57,94,85],[55,93,83],[54,92,83],[52,92,82],[52,93,82],[55,96,85],[55,95,84],[58,97,83],[57,97,83],[55,96,83],[59,98,87],[63,101,95],[62,99,95],[64,100,95],[66,101,94],[67,103,97],[57,97,83],[60,98,86],[65,100,90],[67,101,92],[68,103,94],[68,105,95],[67,105,96],[68,104,95],[67,105,99],[70,108,103],[71,108,101],[71,109,102],[72,112,105],[71,113,105],[71,112,105],[70,110,103],[67,108,101],[63,105,89],[63,103,86],[63,100,82],[68,98,79],[75,93,76],[91,84,75],[99,80,75],[106,78,76],[114,76,80],[123,73,80],[134,78,91],[155,108,119],[180,149,157],[193,169,175],[185,161,165],[174,139,148],[152,105,118],[137,77,87],[133,66,77],[132,65,75],[141,68,77],[151,73,82],[157,75,86],[163,77,89],[164,78,89],[164,79,90],[165,78,89],[165,79,90],[163,78,89],[164,78,91],[164,78,91],[163,79,90],[164,78,90],[165,79,91],[165,80,91],[164,79,91],[164,79,90],[161,75,87],[160,73,86],[156,72,83],[152,72,82],[144,72,81],[133,74,83],[114,79,88],[84,92,95],[66,99,100],[61,102,100],[61,103,99],[97,118,111],[159,144,133],[168,149,140],[169,150,141],[174,155,147],[165,145,140],[96,82,80],[93,78,76],[109,93,89],[115,96,93],[118,100,97],[118,101,97],[107,91,88],[104,87,89],[89,72,75],[105,91,89],[179,167,161],[192,178,172],[192,178,172],[189,176,170],[188,175,168],[187,174,168],[187,172,166],[186,171,165],[186,171,165],[186,171,165],[186,171,166],[185,170,165],[185,170,164],[187,172,166],[190,175,168],[194,178,172],[194,179,172],[193,177,171],[190,174,167],[186,169,163],[182,165,158],[179,162,155],[106,137,100],[103,139,101],[97,142,100],[89,144,100],[81,144,100],[77,143,98],[70,138,97],[68,133,96],[66,130,97],[63,126,95],[63,124,95],[63,125,95],[61,123,94],[62,123,93],[62,125,92],[61,124,90],[65,128,93],[69,131,93],[71,134,96],[71,136,96],[75,139,97],[82,140,99],[86,139,98],[90,134,98],[97,131,99],[97,125,95],[91,110,89],[89,125,98],[92,139,108],[99,143,111],[101,140,109],[100,137,106],[82,131,98],[72,129,97],[69,130,98],[67,128,97],[67,126,97],[68,125,98],[69,127,99],[68,127,100],[68,127,99],[68,127,97],[70,127,101],[67,126,102],[68,124,101],[64,123,96],[63,122,96],[64,121,97],[65,122,99],[67,124,100],[69,125,102],[68,124,101],[68,123,100],[68,122,100],[68,124,100],[66,122,99],[67,123,99],[65,122,96],[65,120,99],[65,117,100],[63,107,99],[55,96,95],[54,94,95],[54,94,95],[57,94,96],[59,104,101],[69,120,117],[68,120,116],[63,107,102],[63,105,101],[83,120,119],[119,154,159],[123,158,163],[124,158,160],[131,162,164],[136,164,167],[136,162,165],[176,132,121],[187,130,118],[194,128,116],[196,126,114],[198,124,113],[188,118,111],[149,98,93],[123,81,83],[120,75,78],[122,76,78],[144,92,91],[180,116,106],[200,121,108],[199,121,109],[194,119,109],[191,117,107],[190,116,107],[192,117,107],[191,117,107],[193,117,106],[193,115,110],[152,95,96],[107,74,82],[100,74,82],[100,74,82],[103,75,80],[127,82,80],[175,107,100],[193,117,108],[192,120,110],[187,124,118],[183,126,122],[158,134,133],[130,147,147],[114,150,152],[110,150,156],[107,150,155],[105,149,153],[107,149,152],[107,149,152],[106,146,151],[101,141,143],[82,125,126],[82,124,126],[85,132,132],[77,122,121],[56,95,95],[53,92,89],[52,93,87],[59,102,98],[84,129,128],[85,130,128],[79,122,120],[75,119,118],[89,130,132],[96,137,139],[94,136,137],[99,141,142],[102,141,143],[106,143,145],[107,143,146],[106,144,146],[109,145,148],[110,144,148],[100,134,136],[101,137,137],[102,137,137],[102,137,137],[102,137,138],[104,138,143],[103,140,144],[105,141,144],[105,141,145],[102,138,142],[100,136,139],[98,135,136],[99,135,137],[100,134,137],[97,131,133],[100,131,133],[97,127,126],[88,113,104],[96,94,85],[107,81,79],[111,77,77],[122,74,80],[128,75,85],[134,79,92],[156,111,122],[188,160,165],[197,175,179],[196,177,180],[193,172,176],[179,151,157],[160,116,125],[140,83,94],[133,68,79],[132,65,74],[134,65,74],[144,69,78],[157,74,85],[163,78,88],[163,78,88],[164,78,89],[163,80,90],[165,79,91],[164,79,91],[165,79,90],[163,79,89],[165,80,92],[165,80,91],[165,80,92],[165,79,92],[165,80,91],[163,78,89],[163,76,89],[162,76,88],[161,76,87],[154,74,83],[147,72,82],[134,74,83],[117,81,89],[69,101,101],[68,103,104],[96,116,113],[152,143,135],[170,150,141],[172,152,143],[173,156,147],[168,148,140],[103,87,84],[109,96,93],[170,156,150],[178,160,153],[177,161,153],[181,164,156],[178,164,158],[95,81,81],[104,90,90],[162,147,143],[190,176,171],[189,176,170],[188,175,168],[188,175,169],[187,173,166],[187,172,166],[187,171,166],[187,171,167],[189,172,167],[187,172,166],[188,172,166],[188,173,167],[189,175,168],[193,178,172],[194,179,173],[193,177,171],[190,175,168],[187,171,164],[182,168,159],[180,163,156],[96,141,100],[93,142,100],[90,141,99],[84,141,97],[77,139,98],[72,138,97],[71,135,98],[67,131,96],[63,122,93],[57,117,86],[59,121,91],[58,123,92],[62,124,95],[64,124,96],[61,127,92],[66,130,96],[70,134,96],[74,136,97],[74,139,98],[77,140,98],[81,143,100],[89,143,100],[95,135,96],[107,128,95],[119,124,99],[127,121,101],[114,109,92],[122,115,101],[123,130,111],[120,133,108],[124,133,111],[128,135,113],[110,133,106],[89,136,102],[81,135,100],[68,129,97],[68,128,98],[70,127,100],[69,128,100],[71,130,102],[68,128,100],[66,127,99],[68,127,101],[69,125,104],[64,121,100],[60,115,98],[66,121,103],[63,119,100],[63,120,101],[64,122,101],[65,124,101],[65,123,100],[65,123,100],[63,122,98],[64,122,99],[68,124,102],[67,124,101],[65,123,99],[66,121,99],[64,118,98],[64,111,98],[60,103,98],[56,98,97],[57,98,97],[57,96,98],[55,97,97],[64,116,114],[70,122,119],[65,109,106],[65,107,103],[86,122,124],[119,156,159],[119,157,160],[134,170,172],[148,181,183],[141,171,174],[137,161,163],[170,136,129],[181,135,124],[188,133,121],[191,130,123],[185,123,119],[122,83,81],[93,74,80],[100,83,92],[103,90,99],[99,83,94],[100,74,79],[132,87,88],[186,122,112],[187,125,118],[188,124,118],[189,120,111],[188,118,111],[187,118,113],[184,119,112],[182,118,111],[142,92,92],[91,71,80],[94,84,97],[94,73,77],[130,89,88],[172,117,111],[176,125,117],[170,129,123],[125,149,151],[120,153,155],[114,153,156],[114,154,159],[108,148,151],[106,146,149],[113,152,155],[117,158,160],[118,157,161],[107,148,150],[73,113,115],[76,116,118],[91,136,137],[74,118,119],[57,95,96],[58,96,96],[55,95,94],[64,107,103],[98,143,143],[92,139,138],[67,110,110],[58,101,101],[78,119,122],[112,151,156],[121,158,162],[119,157,159],[119,156,158],[116,153,157],[116,151,155],[114,151,154],[116,151,155],[119,150,155],[120,151,155],[118,150,153],[117,149,153],[115,150,154],[114,147,151],[115,146,152],[114,147,151],[115,148,154],[116,149,154],[116,149,154],[115,146,152],[114,146,151],[114,144,147],[115,143,147],[110,138,142],[110,136,137],[112,128,129],[127,81,88],[129,75,87],[128,77,86],[137,79,92],[148,96,109],[164,123,134],[188,159,165],[199,178,180],[196,176,179],[184,159,164],[159,116,126],[143,88,99],[133,73,82],[131,64,75],[131,63,71],[138,65,76],[152,71,80],[159,75,85],[162,78,88],[163,78,89],[165,79,90],[163,80,90],[164,80,91],[164,80,90],[164,80,91],[164,80,91],[165,81,93],[165,81,91],[165,80,90],[163,78,90],[164,77,92],[164,77,92],[161,77,89],[159,77,87],[155,75,87],[146,74,85],[140,74,85],[122,81,89],[100,90,93],[79,101,101],[106,118,115],[157,144,137],[169,149,142],[170,151,143],[174,155,146],[162,142,135],[98,81,77],[109,95,89],[182,168,162],[191,174,166],[193,174,166],[192,173,164],[191,173,164],[176,162,157],[103,89,88],[91,78,78],[154,140,136],[193,178,172],[194,179,175],[195,180,176],[190,177,170],[186,174,168],[186,172,166],[186,171,166],[188,173,168],[189,172,169],[188,171,167],[188,172,167],[187,172,166],[189,174,168],[191,176,169],[193,179,171],[195,178,172],[191,175,169],[188,171,165],[182,167,159],[179,164,158],[84,139,97],[81,139,98],[78,136,98],[76,135,97],[69,130,94],[67,128,93],[63,126,92],[57,119,87],[48,111,78],[51,116,83],[57,122,90],[56,123,89],[62,126,93],[65,129,95],[66,131,94],[72,137,97],[77,140,98],[80,141,99],[81,142,99],[88,147,99],[90,147,101],[100,137,99],[127,123,101],[146,117,105],[156,114,109],[157,110,107],[150,109,103],[161,112,113],[168,115,117],[171,118,120],[172,119,120],[166,122,117],[130,131,109],[106,135,104],[90,139,104],[77,136,101],[70,132,99],[69,128,99],[68,128,99],[70,129,101],[68,128,100],[67,128,101],[68,128,101],[68,126,102],[60,115,98],[48,101,92],[52,106,96],[61,114,103],[63,116,105],[64,121,103],[62,120,102],[64,122,102],[67,122,101],[63,119,97],[64,121,99],[66,124,102],[67,123,101],[68,123,102],[67,122,101],[68,119,100],[64,114,98],[59,111,98],[56,108,98],[56,105,100],[56,102,100],[58,103,100],[58,103,102],[70,115,115],[74,115,116],[75,115,116],[96,132,136],[120,156,159],[127,163,165],[154,188,190],[159,191,195],[151,182,188],[124,157,159],[136,157,160],[165,146,142],[165,146,139],[171,144,139],[148,120,121],[86,77,77],[135,136,152],[93,78,86],[93,73,75],[132,113,111],[156,138,140],[149,134,134],[162,129,126],[160,125,124],[111,87,91],[82,72,82],[122,120,133],[176,183,199],[177,182,197],[84,75,79],[91,78,82],[123,150,153],[121,153,158],[117,153,157],[115,155,159],[107,149,152],[79,118,119],[71,109,111],[89,124,127],[113,150,154],[116,157,161],[90,131,135],[55,94,97],[54,94,97],[73,114,116],[61,103,105],[58,99,100],[57,100,100],[58,102,100],[59,103,102],[83,126,127],[60,104,105],[51,95,95],[53,96,97],[64,105,107],[116,153,158],[122,158,163],[123,158,160],[125,158,161],[125,160,162],[123,157,160],[119,155,156],[122,155,159],[123,154,160],[123,154,158],[124,153,157],[121,152,155],[121,152,156],[117,151,152],[117,149,152],[119,150,155],[119,151,155],[119,151,156],[118,150,155],[116,148,154],[117,148,154],[119,144,149],[116,144,149],[116,139,143],[123,100,107],[131,79,91],[134,75,88],[135,76,91],[145,87,104],[163,122,132],[190,161,167],[190,163,168],[193,170,173],[204,185,184],[198,177,176],[200,180,179],[204,185,183],[203,183,183],[198,178,177],[204,185,184],[199,181,179],[194,174,173],[173,148,153],[153,106,116],[136,76,86],[131,65,75],[129,62,74],[133,63,73],[145,68,76],[158,74,85],[163,79,89],[165,80,91],[165,80,90],[163,79,90],[166,80,92],[166,80,91],[165,81,92],[165,81,92],[165,80,91],[165,80,91],[165,79,90],[165,79,92],[165,79,92],[163,79,91],[163,79,92],[160,78,90],[155,73,87],[148,74,84],[137,77,83],[125,80,85],[156,139,133],[169,148,141],[172,152,147],[173,154,147],[163,145,140],[98,83,78],[110,93,88],[178,163,154],[188,173,163],[190,173,165],[189,171,164],[187,170,160],[169,154,147],[127,114,109],[88,75,75],[150,136,133],[194,179,175],[195,181,176],[194,180,175],[191,179,172],[191,178,172],[189,176,170],[188,175,169],[187,173,167],[187,173,168],[187,172,169],[187,172,168],[187,172,168],[187,172,166],[188,173,167],[190,174,168],[191,176,169],[193,177,169],[190,175,167],[187,172,164],[182,167,160],[179,164,157],[74,136,93],[73,135,94],[74,134,98],[67,126,93],[58,117,85],[55,115,84],[53,114,83],[53,113,85],[49,114,82],[55,122,88],[59,125,90],[58,126,90],[61,128,92],[66,131,94],[70,135,94],[79,139,95],[81,143,97],[86,145,98],[88,146,98],[94,149,101],[101,142,101],[134,118,100],[160,107,106],[169,110,113],[172,108,114],[174,108,115],[172,109,114],[177,111,119],[182,116,123],[187,119,126],[185,121,126],[182,120,125],[167,120,118],[137,126,108],[100,138,104],[86,139,103],[74,137,102],[70,131,99],[67,129,98],[67,127,100],[67,128,101],[68,128,101],[67,127,99],[66,126,100],[64,118,101],[55,98,97],[49,95,95],[48,96,95],[57,108,104],[62,118,107],[64,119,106],[63,120,104],[65,121,99],[65,120,99],[64,122,100],[66,123,102],[70,123,103],[70,123,104],[68,122,101],[67,119,99],[62,115,97],[62,114,98],[60,112,99],[61,109,100],[61,107,100],[61,106,101],[59,105,100],[63,109,105],[81,125,123],[101,137,143],[109,147,152],[107,149,148],[124,162,162],[151,183,184],[157,191,191],[150,184,185],[125,158,161],[130,162,165],[130,162,166],[131,162,165],[135,159,162],[141,156,157],[130,150,156],[127,152,157],[122,151,155],[120,150,153],[120,148,153],[121,150,156],[124,146,150],[78,72,80],[166,172,188],[172,179,195],[123,136,142],[120,145,148],[120,150,150],[121,152,154],[119,153,156],[115,152,157],[115,153,158],[88,132,135],[60,100,106],[58,96,102],[64,98,103],[89,122,127],[108,150,154],[78,122,125],[55,97,99],[54,98,99],[57,100,103],[58,103,103],[60,103,104],[59,103,103],[59,104,103],[57,102,103],[63,109,109],[54,100,102],[55,99,100],[56,99,99],[65,105,105],[112,149,152],[121,156,160],[120,155,157],[117,150,154],[115,146,151],[121,153,157],[128,159,162],[127,157,161],[127,158,161],[126,157,161],[126,155,159],[125,154,157],[124,153,158],[121,152,155],[119,152,155],[121,152,155],[124,153,157],[124,153,158],[120,150,156],[118,149,155],[118,148,153],[118,143,148],[118,139,140],[125,89,99],[136,77,92],[139,74,90],[138,75,90],[143,88,103],[173,135,145],[195,175,177],[196,176,178],[198,170,168],[179,146,143],[179,147,142],[186,154,149],[180,147,143],[174,141,137],[165,132,128],[186,151,148],[190,154,149],[186,150,144],[183,144,140],[174,137,131],[168,131,123],[174,136,129],[182,145,142],[196,173,176],[188,168,170],[172,137,145],[144,95,105],[129,68,79],[129,63,72],[132,62,72],[143,66,76],[151,70,80],[163,79,89],[165,80,90],[164,78,89],[165,79,91],[166,80,92],[165,80,91],[164,81,91],[165,80,91],[165,81,91],[164,80,91],[166,80,93],[165,79,89],[165,79,89],[165,80,91],[162,78,91],[158,75,88],[155,75,86],[149,74,84],[141,75,82],[119,82,87],[125,107,110],[162,141,137],[170,149,143],[173,152,146],[175,155,149],[158,140,134],[95,79,79],[94,77,78],[114,96,92],[123,105,101],[161,142,135],[155,137,131],[145,128,120],[139,122,114],[109,93,90],[88,75,75],[158,145,142],[196,179,177],[197,180,177],[193,180,174],[193,181,174],[189,177,170],[188,175,169],[186,174,167],[187,174,168],[189,174,170],[188,174,169],[187,174,169],[186,171,167],[187,172,167],[188,172,168],[188,173,168],[191,175,169],[192,177,170],[190,175,168],[188,173,164],[183,167,159],[181,165,157],[70,134,92],[70,133,95],[69,130,95],[59,120,89],[59,120,90],[59,120,90],[60,119,90],[57,117,90],[59,123,91],[63,127,94],[62,127,93],[61,127,92],[64,131,95],[66,132,96],[71,135,97],[78,140,97],[82,144,97],[87,146,97],[92,147,98],[95,147,100],[118,128,99],[156,106,103],[170,106,111],[177,107,116],[179,107,117],[181,108,118],[182,109,119],[185,112,123],[192,118,128],[195,121,130],[194,122,130],[190,120,129],[178,117,123],[149,124,113],[112,135,105],[89,141,104],[77,138,101],[71,133,100],[67,129,98],[68,127,101],[67,128,98],[69,128,99],[70,127,101],[68,126,100],[64,117,100],[54,99,95],[50,94,92],[46,90,89],[47,95,92],[58,110,105],[66,122,113],[65,121,109],[63,119,101],[65,120,99],[63,121,99],[67,122,100],[67,121,101],[71,124,104],[70,123,103],[68,121,101],[66,118,100],[64,117,99],[64,115,101],[63,112,99],[64,110,99],[62,110,99],[61,108,99],[58,107,99],[71,116,113],[92,131,134],[98,138,139],[95,139,136],[101,143,140],[118,157,156],[122,162,161],[114,154,155],[114,153,156],[122,160,164],[126,162,166],[129,161,165],[131,161,166],[126,161,165],[110,144,149],[83,97,103],[74,83,87],[97,105,112],[114,121,130],[84,91,96],[68,75,80],[72,86,92],[108,132,137],[116,147,151],[115,146,150],[113,144,148],[114,146,149],[113,145,149],[112,143,147],[112,142,145],[99,117,121],[76,80,88],[80,82,90],[116,121,133],[115,120,132],[77,79,89],[71,76,82],[85,105,110],[102,127,132],[108,141,145],[109,141,144],[112,146,148],[114,149,153],[111,150,153],[107,148,150],[82,127,129],[58,101,105],[59,98,104],[62,99,105],[64,102,106],[80,122,122],[64,108,109],[57,100,102],[56,101,102],[57,103,104],[57,105,105],[59,106,105],[60,106,105],[60,106,104],[57,106,105],[56,105,105],[55,101,102],[55,101,102],[58,102,101],[65,105,105],[102,141,142],[102,142,144],[80,118,122],[84,117,122],[77,109,114],[90,121,126],[122,153,158],[128,157,161],[130,157,161],[130,158,162],[129,156,161],[128,156,160],[125,154,158],[124,153,157],[123,153,156],[124,154,157],[125,154,158],[127,153,158],[126,152,157],[123,148,154],[122,145,151],[121,137,139],[125,84,90],[134,74,86],[142,73,89],[141,76,93],[156,102,115],[184,145,154],[194,171,175],[202,176,172],[168,117,107],[139,92,84],[139,92,83],[140,90,81],[135,84,77],[132,82,73],[133,82,74],[136,84,76],[142,89,82],[144,90,82],[145,89,83],[140,86,81],[140,85,77],[142,87,80],[148,95,92],[184,159,160],[178,152,156],[151,107,117],[130,70,82],[127,61,74],[128,62,75],[138,64,73],[157,73,84],[164,79,89],[164,78,89],[164,78,90],[165,79,91],[165,80,91],[163,79,89],[164,79,90],[165,80,91],[165,80,92],[165,82,94],[165,80,93],[165,81,93],[166,81,93],[163,79,91],[160,76,87],[157,76,86],[156,76,86],[149,76,86],[144,76,85],[138,80,88],[152,111,111],[173,145,141],[174,152,146],[177,155,150],[165,144,138],[100,84,80],[95,78,77],[116,98,93],[112,93,90],[116,95,94],[117,97,96],[116,96,96],[110,92,87],[97,80,81],[89,75,76],[194,179,174],[198,180,178],[190,177,171],[188,175,169],[187,174,167],[187,174,168],[189,175,170],[189,174,170],[188,173,169],[187,173,168],[187,173,167],[188,173,168],[188,172,168],[191,174,168],[189,175,167],[189,175,167],[187,171,164],[184,169,161],[182,165,158],[70,134,99],[67,131,98],[64,128,97],[60,123,94],[61,124,95],[60,123,94],[62,122,94],[61,122,93],[62,123,93],[64,126,95],[64,128,96],[61,126,92],[66,130,95],[69,133,97],[71,135,97],[78,140,96],[84,144,99],[90,146,97],[94,147,97],[104,141,99],[138,111,99],[166,103,108],[176,104,114],[182,105,117],[185,106,119],[185,107,121],[187,109,123],[190,113,127],[193,119,128],[195,122,131],[195,123,132],[194,121,130],[182,117,126],[165,117,119],[116,133,107],[93,141,104],[79,139,102],[71,136,101],[68,130,99],[68,129,100],[68,129,99],[69,129,99],[64,127,98],[66,125,99],[65,122,100],[55,103,96],[51,94,91],[46,88,85],[41,86,82],[48,97,95],[59,114,109],[64,120,112],[62,118,103],[61,117,97],[63,120,97],[66,121,98],[69,122,100],[71,123,102],[69,121,101],[67,120,102],[68,119,103],[67,117,101],[66,116,101],[63,112,99],[64,110,100],[63,110,99],[62,108,99],[59,107,99],[65,108,103],[77,119,116],[76,118,117],[78,120,118],[81,122,121],[88,127,128],[93,133,134],[98,138,140],[100,141,143],[103,144,147],[110,148,150],[113,151,152],[113,151,154],[113,155,158],[104,149,151],[95,125,129],[78,93,97],[72,83,89],[67,80,85],[67,81,86],[72,86,91],[83,109,112],[96,128,130],[95,130,131],[93,129,129],[90,126,126],[90,124,126],[88,119,121],[91,114,116],[94,114,117],[91,109,110],[78,83,91],[72,84,90],[75,91,96],[76,107,107],[89,125,127],[90,128,130],[91,128,131],[92,131,134],[94,133,137],[91,131,134],[88,129,131],[77,120,121],[62,102,106],[62,101,105],[65,101,106],[69,103,107],[67,104,106],[61,103,104],[57,102,103],[59,104,105],[57,105,104],[58,107,105],[58,107,106],[59,108,106],[60,107,106],[60,107,106],[57,106,105],[55,104,104],[57,103,104],[59,103,103],[62,103,103],[78,118,120],[67,109,110],[61,102,104],[62,101,104],[60,98,101],[65,100,105],[112,144,148],[129,157,161],[130,158,162],[122,151,155],[120,149,153],[121,149,155],[126,155,159],[125,154,158],[125,154,158],[125,154,158],[124,154,158],[125,154,158],[125,152,156],[126,145,151],[128,88,100],[133,71,89],[136,76,87],[141,76,89],[147,84,98],[163,108,122],[185,153,159],[207,184,188],[200,174,170],[157,105,96],[133,77,71],[123,73,70],[116,67,68],[123,70,67],[119,70,66],[118,69,65],[117,69,67],[120,71,68],[121,71,68],[120,71,68],[119,70,69],[126,73,70],[140,85,79],[146,95,91],[187,162,163],[192,173,175],[178,152,156],[150,107,114],[135,82,91],[129,63,78],[130,61,77],[141,65,76],[158,73,84],[163,77,87],[161,77,87],[163,78,89],[163,79,89],[163,77,87],[164,78,89],[164,79,90],[164,80,90],[165,81,93],[165,81,92],[165,81,93],[164,80,93],[165,81,92],[163,79,91],[162,79,89],[161,77,88],[157,77,88],[152,75,88],[149,75,86],[145,82,88],[154,114,111],[172,145,139],[175,155,147],[156,137,129],[98,79,76],[112,95,92],[170,153,149],[184,168,162],[185,169,164],[185,167,164],[179,165,160],[172,159,155],[118,104,102],[89,76,75],[196,180,176],[195,180,176],[192,179,173],[192,177,173],[190,176,170],[188,173,169],[188,174,168],[189,175,170],[190,173,170],[191,173,170],[188,173,168],[188,173,168],[188,173,168],[189,174,169],[189,173,167],[188,173,166],[187,172,165],[187,172,165],[184,169,162],[182,165,160],[68,132,98],[68,132,101],[64,129,96],[62,126,96],[61,126,96],[60,124,95],[64,124,95],[63,123,94],[63,124,94],[64,124,94],[62,124,94],[64,126,96],[67,129,95],[69,132,95],[73,136,95],[79,142,96],[86,145,97],[91,147,98],[98,147,100],[107,134,96],[152,105,103],[170,103,110],[179,104,115],[183,104,117],[186,106,120],[187,107,121],[187,108,121],[190,111,124],[194,116,127],[196,121,130],[196,123,131],[197,122,132],[186,117,128],[171,114,121],[126,129,109],[95,141,105],[78,140,102],[71,134,98],[70,132,98],[69,131,100],[71,131,101],[68,130,99],[64,128,97],[62,125,97],[62,124,97],[58,114,99],[53,98,92],[49,88,86],[47,87,85],[49,89,89],[50,98,97],[56,111,106],[58,119,107],[63,118,102],[64,119,99],[66,121,98],[71,123,100],[71,124,100],[71,123,102],[69,121,103],[68,120,103],[68,119,102],[67,118,102],[64,115,100],[65,111,100],[64,109,99],[63,108,99],[60,105,98],[61,106,99],[70,115,107],[68,112,108],[70,114,110],[72,116,112],[73,115,113],[81,121,122],[88,127,129],[87,128,129],[89,131,128],[93,131,130],[93,132,130],[91,131,131],[90,131,131],[92,127,130],[91,120,123],[90,107,110],[85,98,102],[79,93,97],[79,96,100],[78,103,106],[76,111,110],[78,118,118],[78,118,116],[79,119,115],[79,118,116],[77,116,113],[80,106,104],[83,93,97],[75,104,104],[71,111,107],[71,114,109],[70,116,112],[72,118,116],[73,120,118],[77,120,120],[77,119,119],[73,115,116],[66,108,109],[65,108,108],[65,105,106],[66,102,105],[68,99,104],[66,99,104],[65,100,102],[60,98,99],[57,101,102],[59,104,104],[57,105,104],[59,108,104],[60,109,106],[61,109,106],[61,109,106],[63,109,107],[62,107,108],[59,105,105],[60,104,104],[61,104,105],[60,104,104],[62,105,106],[60,104,106],[61,103,105],[61,102,104],[58,99,101],[61,100,103],[108,141,145],[119,152,155],[106,136,139],[84,115,119],[76,107,112],[87,116,121],[122,150,154],[126,154,158],[126,153,158],[128,155,159],[126,154,158],[125,154,158],[124,148,152],[128,91,100],[135,73,89],[138,72,90],[141,75,93],[153,96,111],[175,138,145],[186,150,157],[198,172,168],[152,100,93],[125,73,70],[92,52,60],[79,40,51],[82,43,55],[84,46,56],[87,47,57],[91,52,57],[95,54,61],[94,55,59],[93,55,60],[96,57,63],[102,59,64],[131,79,73],[150,98,95],[191,166,166],[192,171,174],[179,156,160],[156,117,122],[136,80,92],[129,63,77],[130,61,74],[143,66,77],[158,74,84],[160,76,86],[161,77,87],[162,78,89],[163,77,88],[163,77,88],[164,79,90],[164,79,91],[165,81,93],[167,83,95],[167,83,95],[167,83,94],[167,82,93],[165,81,91],[163,79,88],[162,79,88],[161,77,89],[157,78,86],[154,75,83],[151,73,84],[146,83,89],[161,119,115],[173,150,140],[165,143,135],[100,80,76],[125,107,104],[190,173,168],[193,176,170],[194,176,168],[193,175,169],[190,173,168],[185,171,164],[126,113,111],[92,79,77],[195,180,175],[194,179,175],[195,182,176],[191,179,171],[190,176,169],[189,174,168],[188,173,167],[189,174,170],[189,175,169],[191,175,169],[189,174,168],[190,174,168],[188,173,167],[188,173,168],[188,173,167],[187,172,167],[185,170,164],[186,170,164],[185,170,163],[183,167,161],[68,130,96],[67,130,97],[65,129,97],[63,127,99],[62,126,97],[62,125,97],[64,124,96],[64,124,94],[63,123,95],[64,123,96],[65,124,97],[63,124,93],[64,128,93],[66,132,95],[71,135,94],[76,140,94],[81,143,95],[88,147,97],[95,149,99],[109,135,97],[149,100,99],[167,100,106],[177,104,113],[183,105,117],[185,105,118],[185,106,119],[186,106,120],[189,109,123],[193,113,127],[196,120,131],[196,121,132],[197,121,133],[186,116,127],[166,116,120],[119,132,108],[89,145,103],[77,140,100],[73,135,100],[73,133,100],[73,133,102],[70,132,100],[71,131,102],[68,127,100],[66,125,99],[64,124,99],[64,121,102],[61,107,98],[53,94,91],[48,90,86],[49,91,86],[48,93,89],[49,104,97],[60,117,107],[62,117,104],[63,119,99],[66,120,99],[68,123,99],[70,124,100],[69,123,102],[70,123,103],[70,121,104],[69,120,104],[68,118,102],[65,116,100],[64,112,101],[64,111,100],[59,108,97],[61,108,99],[65,112,103],[68,112,107],[66,111,107],[69,112,108],[68,112,106],[70,112,106],[70,112,107],[73,114,111],[75,116,115],[77,119,116],[80,121,119],[81,123,117],[80,121,115],[81,112,109],[84,98,99],[76,90,93],[72,105,104],[74,119,114],[73,117,112],[76,117,113],[76,117,114],[81,112,108],[103,80,80],[100,78,79],[101,75,79],[101,75,77],[100,76,80],[95,80,86],[77,99,99],[70,115,111],[71,118,113],[71,119,114],[72,119,115],[71,120,116],[72,120,117],[71,119,116],[72,117,115],[71,116,115],[71,116,113],[74,114,109],[75,110,107],[84,95,94],[95,81,84],[94,79,82],[74,83,84],[69,84,86],[63,93,94],[60,104,102],[61,109,104],[61,109,104],[61,110,105],[61,108,103],[60,108,104],[63,106,106],[63,106,105],[62,105,104],[61,105,106],[61,105,106],[61,105,106],[59,107,107],[60,106,106],[60,104,105],[59,100,102],[66,106,109],[93,130,132],[77,113,116],[60,98,101],[58,96,98],[58,96,98],[67,99,102],[119,147,151],[127,154,158],[127,154,158],[124,154,158],[125,154,158],[126,154,157],[122,133,137],[121,88,96],[133,76,87],[135,75,89],[141,81,98],[157,114,126],[187,160,165],[197,178,180],[196,170,164],[146,96,88],[121,71,70],[83,44,58],[74,38,56],[76,41,56],[80,42,57],[79,42,55],[83,48,58],[90,52,62],[91,55,63],[91,57,64],[94,57,65],[98,58,64],[128,79,71],[146,93,86],[184,151,151],[196,177,178],[191,173,172],[186,167,171],[181,156,160],[165,123,132],[133,71,84],[128,60,74],[128,60,72],[144,68,79],[158,75,84],[161,77,87],[160,76,86],[163,76,88],[164,77,90],[165,79,90],[163,79,90],[163,79,92],[166,81,94],[167,83,95],[166,82,94],[166,82,93],[166,82,93],[164,80,91],[164,80,91],[162,78,91],[159,79,88],[157,78,87],[153,74,86],[149,72,85],[147,76,83],[162,112,112],[156,125,121],[99,76,75],[112,95,91],[177,161,154],[192,175,168],[193,175,168],[193,175,168],[191,174,167],[186,171,163],[124,111,108],[91,77,75],[192,177,173],[192,179,173],[196,182,175],[192,180,173],[191,178,171],[190,176,169],[188,174,167],[189,174,168],[189,174,170],[190,175,170],[190,176,169],[189,175,168],[187,173,167],[189,174,168],[190,174,168],[188,173,169],[187,172,166],[185,170,163],[185,169,163],[185,170,163],[183,167,162],[66,128,95],[66,129,95],[66,129,96],[64,127,96],[64,127,99],[64,124,96],[65,124,98],[66,125,97],[64,124,97],[64,124,96],[64,125,96],[63,124,93],[62,126,91],[64,130,93],[70,136,95],[75,139,94],[78,142,96],[86,147,96],[94,152,101],[118,131,100],[144,98,96],[163,97,105],[177,103,113],[183,105,118],[185,106,119],[187,107,121],[187,107,121],[188,108,124],[189,111,126],[194,117,130],[194,118,131],[194,118,132],[178,113,125],[162,115,119],[108,136,108],[89,145,104],[77,140,101],[72,135,99],[72,133,99],[72,132,101],[71,131,102],[70,131,101],[67,129,97],[65,127,97],[64,124,97],[64,124,100],[60,118,98],[58,106,96],[56,98,95],[52,94,91],[46,91,88],[44,94,90],[54,109,102],[61,115,104],[63,118,100],[66,120,99],[69,123,100],[70,124,103],[68,122,104],[68,122,104],[68,121,104],[68,121,104],[68,119,103],[66,116,103],[65,113,102],[65,112,103],[61,110,101],[62,111,102],[64,111,103],[65,111,105],[65,111,106],[66,111,106],[67,112,105],[67,110,105],[65,108,103],[63,108,99],[66,108,103],[67,111,105],[73,115,111],[75,119,111],[74,113,105],[79,97,92],[91,82,84],[93,75,80],[96,73,77],[95,72,76],[94,71,76],[93,72,78],[74,107,104],[74,121,114],[73,119,110],[73,118,108],[74,117,106],[84,103,96],[98,80,80],[106,74,77],[105,71,76],[105,71,75],[105,72,76],[99,74,77],[84,93,94],[74,114,111],[72,120,115],[69,122,116],[68,122,115],[71,120,115],[71,120,115],[71,120,115],[70,119,114],[72,118,113],[73,118,113],[82,117,109],[85,118,109],[84,99,92],[100,83,80],[104,76,77],[101,71,76],[97,68,72],[89,63,68],[79,67,71],[62,92,91],[61,107,101],[61,111,104],[61,111,104],[60,110,102],[63,109,101],[63,105,98],[64,100,96],[64,101,98],[61,102,101],[60,105,104],[61,105,105],[60,106,107],[60,107,107],[60,108,107],[60,107,107],[58,101,103],[62,103,105],[66,107,109],[61,101,103],[59,100,101],[59,97,101],[58,96,100],[64,100,104],[116,145,151],[128,154,158],[123,153,156],[123,153,157],[122,151,155],[125,145,147],[125,102,111],[133,77,89],[136,75,87],[137,81,94],[166,123,134],[189,164,170],[204,185,184],[195,167,161],[145,93,85],[119,71,71],[83,45,59],[76,40,56],[78,43,58],[80,43,58],[81,43,58],[85,48,61],[90,54,66],[94,57,69],[94,58,70],[95,59,70],[98,59,65],[128,79,71],[143,91,86],[184,151,154],[192,174,173],[189,170,173],[186,167,171],[186,160,166],[157,110,120],[129,65,79],[127,61,73],[134,65,74],[148,69,79],[158,75,85],[160,76,86],[163,77,88],[164,77,89],[163,76,90],[164,79,92],[162,79,91],[165,80,93],[166,82,94],[166,81,94],[167,82,94],[167,83,94],[167,82,93],[166,81,93],[165,80,94],[163,79,93],[159,78,89],[157,77,89],[154,74,88],[151,72,86],[147,74,85],[144,87,93],[116,72,79],[105,68,73],[146,128,122],[173,155,147],[171,154,146],[166,150,141],[169,152,146],[166,151,145],[115,100,97],[93,79,77],[170,157,152],[194,179,173],[194,179,174],[193,179,174],[196,182,177],[195,182,175],[194,180,174],[191,178,172],[190,177,170],[188,175,168],[188,174,169],[189,174,169],[191,175,171],[192,176,171],[189,175,169],[187,173,167],[188,173,168],[189,174,168],[188,173,168],[187,172,167],[188,170,165],[187,170,165],[184,169,163],[184,167,163],[65,127,95],[67,128,96],[66,129,96],[65,127,96],[64,127,97],[65,127,96],[62,125,95],[63,125,94],[65,127,97],[64,127,97],[62,126,94],[63,126,95],[65,128,93],[69,132,93],[75,138,95],[79,141,96],[84,145,96],[90,149,99],[96,151,101],[109,135,100],[136,98,94],[156,94,101],[169,99,109],[178,104,116],[183,106,119],[183,105,120],[184,106,121],[184,107,123],[185,108,125],[189,113,128],[190,114,128],[188,113,129],[171,111,121],[149,119,115],[93,143,105],[85,143,106],[74,138,101],[72,135,100],[72,132,99],[70,131,99],[71,130,99],[72,130,101],[70,130,99],[65,127,97],[65,125,98],[65,124,98],[61,120,96],[64,114,98],[58,110,98],[54,102,96],[51,98,92],[51,100,92],[51,102,95],[59,111,101],[64,118,102],[67,121,98],[67,123,98],[69,124,103],[68,122,104],[70,121,104],[69,121,104],[67,120,102],[69,120,103],[68,117,103],[69,115,102],[66,112,104],[63,112,104],[62,111,103],[62,110,103],[63,111,104],[66,113,107],[66,114,107],[65,112,105],[68,112,105],[64,108,100],[64,108,99],[65,108,99],[68,111,103],[67,112,104],[69,112,103],[72,105,97],[97,76,80],[99,72,77],[99,72,78],[96,70,77],[95,70,78],[74,105,101],[73,125,115],[73,123,112],[73,120,107],[73,116,103],[81,117,100],[84,103,88],[98,91,82],[102,84,80],[105,73,77],[107,73,77],[103,73,77],[71,111,102],[71,123,115],[70,123,116],[68,124,115],[68,124,116],[71,123,117],[71,123,116],[70,121,114],[66,117,110],[71,116,110],[81,118,109],[117,123,108],[150,133,113],[148,112,96],[160,115,101],[147,102,98],[106,73,75],[93,63,68],[83,67,70],[68,89,87],[60,108,101],[60,113,104],[62,113,104],[63,114,105],[61,113,103],[63,112,100],[65,103,93],[68,93,85],[68,92,84],[63,94,86],[58,94,87],[57,99,94],[61,106,104],[61,107,106],[61,107,107],[61,108,107],[59,104,105],[60,104,105],[61,103,105],[61,102,103],[60,101,101],[61,99,102],[57,95,98],[66,100,104],[112,142,148],[123,150,156],[119,148,152],[119,151,151],[120,148,151],[130,82,94],[139,76,90],[138,78,90],[163,119,129],[197,172,176],[193,165,158],[141,89,80],[122,72,71],[82,43,57],[74,37,54],[79,42,59],[79,42,58],[80,43,57],[85,48,61],[91,55,67],[94,58,70],[96,58,71],[98,59,72],[100,60,67],[126,77,70],[144,92,87],[186,155,156],[197,178,180],[191,172,174],[196,177,180],[187,159,164],[155,105,116],[129,68,80],[128,61,72],[139,64,75],[152,72,82],[159,75,86],[160,76,87],[162,78,89],[161,77,89],[163,79,90],[163,80,92],[164,80,92],[165,81,93],[165,81,93],[165,80,93],[167,82,94],[167,83,95],[168,83,94],[167,81,95],[165,80,94],[162,78,91],[159,78,89],[154,75,87],[151,73,85],[148,72,81],[141,72,79],[136,73,81],[123,71,79],[112,81,84],[109,85,83],[109,89,84],[109,93,87],[104,88,83],[99,83,80],[92,76,75],[92,78,77],[170,157,151],[196,181,174],[194,179,174],[194,180,174],[192,180,173],[197,183,178],[197,182,178],[197,182,178],[196,181,176],[191,178,172],[188,175,169],[187,175,168],[188,174,169],[192,176,172],[191,177,171],[190,175,169],[189,175,168],[189,175,169],[189,174,168],[189,174,168],[188,173,168],[187,172,166],[188,171,167],[186,169,163],[183,168,162],[63,127,91],[66,128,95],[66,128,96],[66,129,98],[66,128,98],[68,129,97],[65,127,95],[65,127,95],[66,128,97],[66,128,98],[64,126,95],[64,126,94],[64,127,94],[67,133,93],[74,139,95],[80,142,98],[81,145,97],[87,147,97],[93,151,100],[103,146,103],[119,111,95],[143,94,95],[161,97,105],[170,102,112],[176,104,117],[177,104,119],[177,104,119],[178,106,119],[179,106,121],[181,110,122],[181,110,123],[172,110,120],[158,113,117],[107,136,107],[91,145,107],[79,140,105],[72,135,100],[73,134,101],[71,131,99],[71,130,99],[71,128,100],[71,127,101],[71,128,101],[67,124,99],[67,124,99],[68,124,99],[65,123,99],[67,121,101],[63,120,102],[65,119,104],[58,113,99],[55,106,96],[50,103,93],[56,109,96],[64,117,101],[66,122,99],[67,123,99],[68,123,103],[69,123,104],[70,122,104],[70,123,104],[69,122,103],[70,120,103],[69,120,103],[68,116,102],[69,114,103],[65,112,105],[63,111,103],[63,111,104],[67,113,105],[66,115,107],[66,115,107],[65,113,106],[67,113,107],[64,108,100],[66,107,99],[64,107,99],[63,107,99],[65,110,101],[67,110,102],[68,106,98],[82,97,93],[96,75,79],[102,73,78],[100,73,77],[98,72,79],[90,76,82],[72,103,99],[73,122,114],[73,127,113],[74,127,111],[74,124,106],[71,114,97],[83,116,93],[94,119,94],[96,114,89],[94,104,85],[101,90,79],[98,83,75],[96,84,80],[76,99,93],[67,123,113],[66,125,116],[67,126,115],[67,126,116],[68,124,116],[70,121,114],[70,121,113],[70,119,112],[65,112,105],[71,108,97],[90,110,99],[155,134,113],[193,145,120],[191,133,110],[205,145,122],[167,122,106],[97,72,68],[88,66,69],[79,88,86],[60,108,99],[57,112,102],[59,114,104],[61,116,105],[62,117,103],[64,117,102],[66,115,100],[64,107,91],[76,108,85],[79,102,84],[75,102,85],[65,95,82],[58,93,85],[62,105,100],[63,110,105],[60,108,104],[60,107,104],[58,107,103],[58,106,104],[62,105,105],[60,103,100],[58,99,97],[61,100,102],[62,97,101],[68,102,106],[95,125,130],[90,119,123],[85,116,118],[110,131,133],[123,137,141],[132,98,107],[139,78,91],[140,75,91],[157,107,118],[194,165,170],[203,177,173],[146,98,89],[122,71,71],[83,44,58],[75,38,54],[77,40,57],[77,41,58],[78,42,56],[83,47,59],[89,54,65],[93,57,68],[94,56,68],[95,56,69],[97,58,66],[124,76,71],[141,91,84],[189,159,158],[193,174,177],[182,147,155],[148,96,107],[130,65,76],[130,63,74],[136,64,75],[153,71,83],[159,75,87],[160,76,89],[162,78,91],[161,78,92],[164,78,91],[165,80,92],[166,81,93],[166,81,92],[167,82,93],[166,81,94],[166,82,93],[168,82,93],[165,80,92],[164,79,93],[161,78,89],[158,77,87],[155,75,85],[152,74,84],[148,73,81],[146,72,80],[140,71,79],[134,71,80],[134,82,88],[145,119,117],[144,126,121],[145,129,123],[146,131,125],[135,120,115],[103,86,86],[93,77,77],[168,155,149],[195,181,174],[195,178,174],[193,179,174],[192,180,173],[194,180,174],[196,182,177],[197,182,177],[195,181,176],[187,174,169],[187,174,169],[188,175,169],[192,176,172],[193,177,173],[191,176,169],[189,175,168],[188,175,168],[188,173,169],[189,174,169],[188,173,167],[187,172,167],[187,170,165],[186,170,163],[183,169,162],[64,127,93],[66,129,94],[65,129,95],[67,130,97],[67,129,98],[68,130,98],[66,128,96],[65,127,96],[65,127,96],[66,128,98],[61,124,92],[63,125,94],[66,127,95],[68,132,96],[74,137,98],[77,140,96],[78,143,97],[88,147,97],[93,150,99],[98,152,104],[101,145,102],[132,106,97],[155,99,103],[164,100,108],[170,101,113],[170,103,113],[168,105,114],[169,109,116],[170,106,117],[169,107,116],[168,111,117],[156,116,116],[124,129,109],[92,143,104],[88,144,108],[78,140,104],[75,135,101],[73,132,101],[71,130,100],[68,130,99],[68,127,99],[68,127,100],[67,125,99],[67,123,99],[69,123,101],[70,124,104],[67,123,102],[66,123,103],[66,124,104],[64,122,102],[62,120,101],[63,120,100],[61,116,98],[62,117,99],[67,122,102],[70,123,103],[70,123,103],[71,123,103],[70,124,103],[69,121,101],[69,122,102],[68,121,102],[70,121,102],[69,120,103],[68,118,101],[69,116,103],[66,113,104],[65,111,102],[66,112,103],[69,116,106],[69,117,109],[68,116,109],[66,113,107],[67,112,105],[64,108,100],[65,107,99],[64,106,98],[65,106,98],[66,107,99],[67,107,100],[70,104,96],[82,91,88],[95,74,76],[100,71,76],[99,72,78],[94,77,83],[81,97,94],[74,125,113],[74,127,116],[74,129,112],[80,131,110],[91,131,104],[91,126,97],[80,114,87],[86,115,85],[82,111,81],[88,116,84],[100,116,88],[93,109,85],[87,113,98],[74,120,109],[65,124,113],[66,125,114],[66,126,114],[66,126,116],[65,124,113],[65,122,112],[66,120,112],[68,118,112],[69,108,101],[76,95,84],[99,94,80],[166,130,108],[194,137,112],[191,132,107],[195,137,112],[151,114,93],[92,78,68],[68,103,95],[59,112,101],[59,114,103],[59,115,103],[62,117,103],[65,120,102],[69,122,103],[72,121,98],[70,114,89],[71,109,80],[79,116,84],[74,112,80],[74,110,85],[65,103,85],[67,112,99],[65,114,104],[60,109,101],[59,108,100],[58,107,99],[57,106,101],[59,104,102],[58,100,97],[59,100,97],[59,101,102],[61,99,102],[61,97,100],[61,94,98],[62,92,98],[63,92,96],[116,101,107],[139,80,94],[144,78,91],[152,96,109],[189,160,165],[199,178,180],[203,174,170],[150,104,96],[125,74,74],[89,48,59],[74,37,53],[75,39,56],[77,40,56],[79,43,56],[83,45,58],[86,49,61],[89,54,63],[90,52,63],[91,54,66],[94,56,66],[117,70,68],[139,88,83],[185,157,157],[196,177,178],[194,173,178],[169,132,142],[139,79,91],[128,63,75],[129,61,73],[137,63,75],[153,70,83],[159,75,87],[161,77,89],[160,77,89],[163,77,88],[162,77,89],[164,80,91],[165,80,92],[166,80,93],[165,80,91],[165,79,91],[167,81,94],[165,80,92],[162,78,89],[160,77,88],[159,75,86],[155,73,83],[153,72,83],[151,73,84],[148,72,83],[142,71,80],[139,70,79],[139,74,81],[162,121,116],[188,161,153],[191,172,165],[189,172,166],[179,165,158],[121,104,104],[95,79,77],[171,156,151],[195,180,174],[194,179,173],[193,178,172],[193,179,173],[194,179,172],[195,181,175],[197,182,178],[191,178,172],[190,177,170],[187,173,168],[188,173,169],[191,176,170],[193,176,170],[193,177,170],[191,175,169],[189,174,168],[188,174,167],[188,174,168],[188,173,167],[187,172,165],[185,170,163],[184,168,162],[182,168,161],[66,128,94],[66,129,94],[68,131,96],[68,131,95],[68,130,98],[67,129,99],[67,127,100],[66,127,100],[64,124,98],[59,118,95],[53,113,88],[61,122,92],[68,130,95],[70,131,94],[73,135,96],[77,139,97],[81,142,97],[85,145,98],[91,148,99],[96,151,103],[102,149,105],[109,136,102],[122,121,99],[147,107,103],[151,106,106],[150,111,108],[145,121,111],[134,126,108],[131,126,107],[137,122,106],[133,124,106],[118,131,105],[94,142,104],[88,143,104],[81,140,104],[75,137,102],[73,133,101],[72,132,100],[70,130,98],[67,126,97],[66,126,99],[65,125,99],[66,125,99],[68,124,100],[70,124,100],[69,124,103],[68,124,103],[67,125,103],[66,124,102],[67,125,103],[69,127,106],[71,127,105],[69,125,104],[67,124,104],[70,126,103],[68,124,102],[71,124,103],[72,126,103],[73,126,103],[70,123,103],[71,123,103],[70,122,103],[70,121,102],[70,122,104],[70,119,102],[71,117,104],[70,117,105],[68,113,104],[69,114,105],[70,118,108],[72,116,108],[68,111,104],[66,109,101],[67,109,102],[67,108,101],[65,106,99],[65,106,99],[59,107,97],[63,106,97],[68,103,95],[76,93,85],[90,79,79],[101,76,81],[102,77,81],[83,107,102],[76,128,117],[78,130,118],[77,130,115],[77,130,112],[88,133,106],[99,134,102],[100,133,99],[90,121,90],[75,107,76],[76,106,78],[94,127,86],[105,138,98],[92,134,106],[77,127,109],[69,125,113],[67,126,114],[69,127,115],[66,126,114],[64,125,114],[69,125,114],[67,123,113],[68,121,112],[67,118,108],[72,109,100],[95,81,71],[109,89,70],[135,104,83],[135,102,81],[146,103,82],[111,90,73],[87,84,70],[72,90,79],[59,102,93],[58,111,99],[60,116,102],[60,117,104],[62,118,103],[67,121,102],[75,126,101],[86,131,99],[90,129,97],[77,114,83],[73,111,78],[68,107,73],[84,125,87],[96,137,96],[86,132,104],[70,122,103],[62,112,102],[60,110,100],[61,108,99],[61,105,98],[59,101,94],[56,96,90],[57,97,94],[61,102,103],[62,100,103],[61,97,100],[60,94,99],[60,94,98],[72,97,101],[127,87,95],[144,77,92],[147,79,94],[177,134,143],[204,184,185],[202,175,170],[150,104,94],[125,74,72],[93,52,58],[74,37,54],[73,37,54],[75,40,55],[79,42,57],[84,46,60],[86,49,62],[87,52,63],[89,52,64],[88,52,63],[91,55,62],[115,69,67],[135,84,78],[176,141,142],[194,176,175],[192,171,175],[166,126,135],[133,72,86],[128,60,74],[130,60,73],[141,63,77],[153,70,83],[161,77,88],[159,76,88],[161,76,88],[162,76,87],[163,78,91],[165,79,91],[166,81,92],[166,80,92],[165,79,92],[165,79,92],[165,79,91],[162,78,89],[160,75,87],[157,73,85],[155,72,83],[154,72,82],[152,71,83],[150,71,83],[146,70,82],[145,70,82],[144,70,80],[141,78,81],[170,125,119],[189,164,156],[192,172,162],[186,167,158],[125,109,107],[95,77,76],[167,150,147],[195,178,172],[195,178,171],[193,178,172],[194,179,173],[194,179,173],[195,180,174],[196,181,175],[196,183,176],[195,182,175],[193,180,173],[191,178,170],[188,174,167],[188,173,167],[190,175,168],[190,176,169],[192,178,169],[192,177,169],[192,177,170],[189,174,168],[188,173,167],[188,172,167],[187,172,166],[187,172,166],[184,169,163],[182,166,160],[182,165,159],[69,127,94],[69,129,94],[68,131,96],[70,132,97],[67,130,101],[66,128,103],[66,124,104],[65,123,104],[60,115,99],[53,104,92],[50,105,88],[62,123,90],[69,129,95],[70,130,94],[71,132,94],[76,138,97],[82,142,98],[84,144,97],[87,147,98],[92,148,102],[94,149,103],[94,149,103],[97,148,106],[97,142,102],[107,136,102],[113,133,104],[110,141,107],[106,146,107],[106,144,106],[106,144,106],[100,145,105],[94,144,105],[89,142,104],[80,139,102],[78,139,102],[77,137,103],[75,134,103],[73,132,101],[71,130,100],[71,129,101],[68,128,101],[69,128,102],[67,127,101],[68,125,100],[70,126,101],[68,125,102],[69,125,102],[69,127,104],[70,128,103],[70,128,104],[71,128,107],[72,130,107],[71,127,105],[70,127,106],[70,126,103],[70,126,101],[72,126,103],[72,126,103],[71,125,102],[71,125,102],[71,124,101],[70,123,102],[70,122,102],[71,122,102],[71,121,102],[71,120,103],[70,118,102],[70,117,104],[68,116,104],[65,115,103],[66,113,102],[67,110,102],[66,108,101],[66,108,100],[66,108,100],[65,108,100],[64,107,101],[60,107,98],[60,107,96],[72,97,91],[98,81,82],[103,83,86],[84,118,107],[80,132,119],[80,134,122],[78,132,119],[78,132,116],[78,133,114],[93,124,103],[100,111,87],[105,119,90],[103,126,96],[82,114,83],[75,106,75],[96,129,93],[98,134,101],[78,128,108],[70,127,110],[68,127,112],[68,128,114],[70,130,116],[68,129,114],[66,128,114],[67,126,112],[68,125,111],[70,122,111],[69,117,106],[83,104,95],[98,86,79],[102,79,72],[99,82,71],[100,87,72],[94,79,69],[91,72,70],[83,77,71],[80,91,79],[68,98,88],[58,106,95],[59,114,100],[62,118,103],[62,119,103],[64,121,104],[67,122,102],[71,125,101],[88,130,97],[96,133,96],[91,127,91],[73,109,76],[69,104,73],[89,127,88],[101,139,98],[80,127,98],[66,121,99],[64,115,103],[61,113,103],[62,111,102],[63,107,98],[59,95,88],[61,85,79],[62,93,87],[61,103,101],[61,103,103],[64,100,102],[63,97,100],[64,97,99],[85,104,106],[113,94,100],[135,80,93],[143,78,92],[157,100,113],[200,176,179],[197,180,178],[202,175,171],[150,103,93],[125,75,70],[91,52,57],[73,39,54],[73,39,54],[73,41,53],[81,45,56],[90,52,60],[93,57,61],[92,58,61],[94,57,62],[91,54,58],[98,59,61],[116,70,66],[138,84,79],[181,147,147],[197,178,178],[196,179,174],[194,176,173],[199,181,179],[193,175,173],[184,163,165],[158,113,125],[135,73,87],[131,62,75],[133,61,74],[144,66,76],[157,74,84],[158,75,86],[158,74,87],[160,75,90],[163,78,92],[163,78,90],[165,79,91],[164,79,92],[164,78,91],[160,76,89],[159,75,87],[159,75,86],[157,74,85],[155,72,85],[154,71,84],[152,71,80],[151,70,80],[148,69,83],[143,68,82],[140,68,80],[138,68,80],[137,68,78],[135,73,76],[148,102,97],[163,136,129],[156,134,126],[106,89,86],[95,77,77],[174,156,152],[196,178,173],[196,178,173],[196,178,173],[194,178,173],[195,179,174],[195,180,174],[195,180,174],[196,181,175],[195,181,175],[194,179,173],[193,178,172],[189,174,168],[191,175,169],[191,176,169],[193,177,171],[192,177,169],[193,178,169],[192,177,169],[193,176,169],[190,173,168],[188,173,167],[187,172,166],[187,172,166],[185,169,164],[181,166,160],[182,164,159],[67,128,92],[70,129,95],[68,129,97],[67,129,99],[66,129,106],[65,124,108],[63,121,108],[62,115,104],[52,100,93],[53,97,92],[51,107,87],[65,125,93],[69,129,95],[70,130,96],[70,133,95],[75,136,98],[81,140,98],[85,144,96],[86,146,98],[89,147,100],[91,148,101],[92,147,101],[92,147,101],[93,146,104],[93,144,102],[95,144,103],[95,146,105],[97,146,105],[96,145,104],[94,143,103],[93,144,103],[88,143,103],[83,140,102],[78,139,101],[78,138,102],[79,137,104],[75,135,103],[76,134,102],[74,133,101],[72,131,101],[71,130,102],[70,129,103],[68,126,102],[69,127,103],[68,127,102],[69,127,102],[68,128,103],[70,129,103],[70,129,103],[71,129,103],[73,129,105],[73,129,104],[72,129,104],[71,129,104],[72,126,103],[73,127,105],[73,127,106],[72,126,105],[72,126,104],[72,126,102],[72,126,102],[71,124,100],[73,123,100],[73,122,100],[72,122,101],[72,121,101],[74,122,103],[73,121,104],[70,118,103],[68,118,101],[67,114,101],[64,109,101],[66,108,100],[66,108,100],[66,108,100],[65,108,100],[63,108,101],[61,107,102],[64,106,100],[71,101,96],[78,93,88],[86,121,106],[81,138,119],[78,135,119],[80,135,123],[81,134,123],[80,134,119],[82,131,114],[99,101,91],[108,83,77],[109,91,76],[109,102,84],[95,101,83],[84,96,78],[77,102,81],[73,112,96],[72,125,109],[67,128,112],[65,129,114],[67,129,115],[69,131,116],[68,131,114],[66,129,112],[66,129,111],[71,127,111],[68,123,107],[74,114,101],[98,91,84],[105,78,74],[102,76,70],[102,78,70],[101,76,70],[93,70,69],[87,66,67],[77,89,81],[66,111,100],[61,117,104],[59,116,102],[61,118,102],[63,121,103],[64,122,103],[66,123,105],[68,121,104],[69,121,102],[81,112,86],[90,109,80],[98,120,88],[85,107,80],[82,99,77],[96,109,86],[83,101,76],[69,112,94],[67,120,104],[66,118,105],[64,116,103],[65,116,103],[64,110,100],[64,94,87],[67,79,75],[62,95,93],[63,103,101],[64,102,100],[66,100,100],[69,100,100],[85,98,98],[123,81,92],[136,79,89],[149,85,98],[179,137,144],[203,186,183],[203,174,168],[151,102,92],[126,76,70],[97,57,59],[82,46,56],[92,59,61],[104,71,60],[129,93,74],[146,108,83],[159,120,92],[152,116,92],[157,121,94],[157,122,94],[156,115,94],[140,91,80],[140,90,82],[180,151,150],[197,178,179],[196,178,172],[196,176,170],[199,182,177],[197,181,178],[198,181,177],[195,176,171],[195,178,175],[180,150,156],[159,109,123],[134,70,85],[129,61,75],[130,62,73],[143,67,77],[156,73,83],[158,74,87],[157,73,88],[159,75,88],[158,77,88],[158,75,87],[160,77,88],[160,77,88],[158,76,88],[153,71,86],[151,71,85],[148,70,84],[146,69,81],[145,67,80],[141,67,76],[142,68,78],[139,66,77],[136,65,77],[134,66,78],[131,64,76],[128,63,73],[129,66,75],[123,66,73],[111,73,76],[100,74,73],[87,71,70],[90,74,72],[165,148,143],[195,178,171],[194,178,170],[195,177,172],[194,177,171],[194,180,172],[194,179,173],[194,179,173],[195,180,175],[195,180,174],[194,178,173],[193,176,171],[189,172,165],[189,172,166],[190,174,166],[192,175,169],[192,176,168],[193,177,168],[191,176,167],[193,176,169],[192,174,168],[187,173,167],[187,172,166],[189,171,166],[186,170,164],[181,166,160],[180,163,157],[65,129,92],[67,129,95],[66,127,100],[65,125,104],[67,124,112],[64,123,113],[61,115,108],[53,95,92],[51,96,90],[53,97,92],[57,110,89],[67,128,94],[69,130,94],[71,131,95],[73,133,95],[75,134,95],[78,137,95],[83,143,97],[85,146,99],[87,147,102],[88,148,103],[89,146,103],[87,145,99],[87,143,100],[87,143,99],[88,144,102],[86,145,104],[85,144,103],[86,142,101],[84,140,100],[82,140,98],[82,140,100],[79,137,100],[77,136,100],[78,136,103],[79,136,104],[76,135,103],[76,135,103],[76,134,103],[75,132,102],[71,131,102],[70,130,102],[70,128,102],[69,127,103],[67,127,103],[69,127,103],[66,127,102],[68,129,102],[70,128,102],[71,127,101],[71,127,102],[71,128,102],[73,129,104],[72,127,103],[72,126,104],[75,129,108],[73,127,104],[72,127,105],[73,128,104],[73,129,102],[73,128,103],[73,125,101],[76,125,101],[76,123,100],[75,122,100],[74,123,101],[75,124,103],[75,125,104],[75,124,105],[72,120,103],[70,118,102],[66,110,100],[66,108,100],[64,107,99],[63,107,100],[63,107,100],[65,107,101],[63,106,100],[65,105,99],[68,105,100],[74,105,101],[78,117,108],[77,137,116],[79,139,119],[78,137,117],[79,135,118],[79,136,120],[79,133,118],[83,130,113],[101,101,91],[111,82,83],[119,75,79],[115,75,74],[113,79,75],[104,81,77],[94,79,76],[81,94,85],[74,115,103],[70,125,111],[68,129,112],[66,130,112],[67,130,113],[70,132,116],[68,131,115],[67,129,112],[70,128,110],[71,126,109],[83,121,103],[91,103,88],[111,80,72],[117,78,71],[124,81,76],[116,76,71],[100,71,69],[93,67,69],[83,76,74],[70,107,97],[62,119,104],[63,121,105],[60,121,103],[64,124,104],[64,124,104],[64,124,104],[66,124,105],[68,123,105],[71,117,101],[91,91,82],[103,78,74],[98,87,73],[93,84,72],[94,80,72],[94,77,71],[83,80,71],[70,113,99],[66,122,106],[67,122,107],[68,121,106],[68,120,103],[70,115,102],[71,95,88],[75,67,69],[76,68,70],[67,82,81],[63,100,95],[63,102,97],[67,101,97],[74,97,96],[97,87,89],[126,77,86],[141,80,91],[153,100,109],[198,173,175],[200,173,167],[148,100,90],[135,79,72],[124,76,69],[159,118,89],[195,156,106],[207,171,118],[204,169,121],[206,171,121],[208,173,124],[208,171,122],[207,172,122],[203,168,121],[198,161,117],[179,131,104],[145,94,84],[182,154,152],[198,179,178],[200,182,180],[197,177,170],[198,176,165],[202,182,171],[200,179,169],[199,178,163],[197,176,161],[195,172,159],[199,178,169],[185,166,166],[182,154,159],[150,102,112],[129,64,80],[128,60,75],[131,64,73],[144,70,79],[152,72,84],[149,69,84],[147,70,84],[143,68,79],[141,67,79],[141,70,78],[141,69,78],[143,68,79],[140,65,77],[138,65,77],[137,66,76],[134,64,74],[133,61,74],[132,61,74],[131,62,72],[132,62,73],[130,62,74],[130,63,77],[128,64,76],[125,64,74],[126,66,75],[126,69,76],[131,86,91],[137,112,111],[102,87,86],[92,78,76],[172,155,149],[193,177,168],[193,178,168],[195,177,172],[194,178,172],[193,178,172],[193,178,171],[194,179,173],[194,179,173],[194,179,172],[192,177,171],[194,177,171],[192,176,169],[189,172,164],[188,172,163],[189,173,165],[191,174,166],[191,174,166],[191,174,167],[192,175,168],[192,176,169],[190,174,167],[187,172,165],[186,170,164],[184,168,162],[182,164,160],[180,163,158],[65,129,90],[65,129,94],[65,126,103],[64,123,109],[66,123,114],[62,118,111],[57,103,99],[55,94,91],[55,97,91],[54,102,90],[65,119,93],[71,132,96],[71,133,95],[71,132,95],[72,131,95],[73,133,93],[75,134,92],[79,139,94],[82,142,98],[85,144,101],[87,145,104],[85,144,102],[82,141,99],[81,141,99],[82,142,99],[82,141,99],[80,142,101],[81,142,101],[78,140,98],[78,139,98],[79,138,97],[79,138,99],[78,137,101],[78,136,101],[77,136,102],[78,136,103],[78,136,103],[75,134,103],[75,134,104],[74,132,102],[71,131,100],[71,130,102],[70,130,103],[69,128,101],[67,127,101],[69,129,102],[67,128,103],[67,128,103],[69,128,102],[70,125,101],[67,122,100],[68,125,102],[68,125,100],[65,121,98],[70,121,100],[73,128,105],[73,129,104],[73,129,103],[74,130,103],[76,133,104],[79,132,104],[79,130,102],[81,128,101],[80,119,92],[75,115,89],[82,130,100],[82,132,103],[81,130,105],[81,128,105],[79,128,105],[75,125,104],[69,117,102],[66,111,100],[63,107,99],[63,107,100],[62,106,99],[63,106,99],[63,105,99],[64,104,98],[65,105,99],[68,110,104],[73,124,113],[77,135,116],[78,134,117],[76,132,113],[79,132,114],[78,133,114],[80,129,112],[88,114,99],[111,84,81],[118,77,80],[118,74,79],[114,72,76],[109,70,75],[108,71,76],[95,81,82],[81,107,101],[66,124,111],[67,128,112],[68,130,112],[68,131,114],[70,133,114],[71,132,115],[69,130,113],[68,128,109],[71,129,108],[91,126,104],[144,135,111],[172,131,112],[171,116,98],[185,124,107],[188,129,115],[148,99,91],[102,70,71],[89,73,74],[69,104,94],[63,121,105],[62,125,107],[63,125,106],[63,125,105],[65,125,105],[64,125,105],[65,127,104],[67,125,106],[67,123,105],[79,107,93],[97,78,77],[110,71,76],[109,71,72],[104,70,71],[100,67,69],[99,69,70],[86,79,71],[66,113,97],[64,124,106],[66,124,107],[66,124,106],[68,122,104],[72,122,104],[75,98,88],[83,66,68],[79,63,67],[66,96,92],[66,103,96],[67,102,95],[115,82,88],[130,77,87],[144,83,95],[173,133,140],[201,172,166],[147,100,89],[142,88,75],[176,127,99],[201,159,103],[205,165,108],[205,168,118],[208,170,121],[207,170,123],[207,172,124],[207,171,121],[207,169,120],[206,169,121],[204,166,120],[198,158,119],[159,111,97],[177,144,142],[197,179,175],[199,180,179],[195,177,175],[200,181,179],[203,186,182],[203,185,180],[203,183,173],[200,176,162],[200,168,143],[202,171,138],[203,168,127],[202,164,121],[201,165,123],[199,165,126],[200,172,145],[200,181,174],[191,172,170],[188,170,169],[194,175,176],[181,153,158],[147,98,107],[128,65,78],[129,64,76],[131,65,76],[133,65,77],[131,63,77],[130,61,75],[130,61,75],[130,62,76],[131,64,76],[131,65,75],[131,65,76],[132,65,76],[132,64,75],[130,64,74],[127,65,73],[130,63,75],[130,64,76],[128,65,75],[127,70,78],[128,71,80],[130,70,81],[128,74,82],[128,79,84],[135,89,93],[145,99,103],[162,126,126],[178,157,151],[117,101,98],[89,77,75],[160,145,141],[191,176,167],[193,178,167],[195,178,171],[194,178,172],[193,178,172],[193,178,170],[193,178,170],[192,177,170],[192,176,171],[187,171,167],[167,149,146],[151,137,130],[142,128,122],[136,122,116],[133,120,112],[134,120,112],[132,116,108],[165,147,141],[170,153,145],[189,173,166],[191,175,169],[190,173,166],[187,170,164],[184,168,162],[182,165,160],[180,163,158]]}]}}

		// const tmpData1 = {"result":{"text":[{"left":0.4309999942779541,"right":0.5609999895095825,"top":0.5094433426856995,"bottom":0.5751649737358093,"score":0.8339493274688721,"content":"Cc","characters":[{"character":"C","centerLoc":[0.47766668,0.53908247],"poly":[0.45433334,0.50944334,0.50266665,0.50944334,0.50266665,0.56872165,0.45433334,0.56872165]},{"character":"c","centerLoc":[0.531,0.55068046],"poly":[0.5126667,0.53135055,0.551,0.53135055,0.551,0.56872165,0.5126667,0.56872165]}]}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.4259999990463257,"right":0.5609999895095825,"top":0.5081546306610107,"bottom":0.5777422785758972,"score":0.8703044652938843,"content":"Cc","characters":[{"character":"C","centerLoc":[0.476,0.5377938],"poly":[0.451,0.50815463,0.501,0.50815463,0.501,0.56872165,0.451,0.56872165]},{"character":"c","centerLoc":[0.5276667,0.54939175],"poly":[0.5093334,0.53135055,0.54766667,0.53135055,0.54766667,0.56872165,0.5093334,0.56872165]}]}]}}
		// const tmpData1 =  {"result":{"text":[{"points":[0.749,0.505,0.601,0.522]}]}}
		// const tmpData1 = {"result":{"text":[{"symbol":[4,2,3,3,3]}]}};
		// const tmpData1 = {"result":{"text":[{"points":[0.20666666,0.45618558,0.21,0.45618558,0.21333334,0.45618558,0.21666667,0.45618558,0.22,0.45618558,0.22333333,0.45618558,0.22666667,0.45618558,0.23,0.45618558,0.23333333,0.45618558,0.2,0.45876288,0.20333333,0.45876288,0.20666666,0.45876288,0.21,0.45876288,0.21333334,0.45876288,0.21666667,0.45876288,0.22,0.45876288,0.22333333,0.45876288,0.22666667,0.45876288,0.23,0.45876288,0.23333333,0.45876288,0.23666666,0.45876288,0.24,0.45876288,0.19,0.46134022,0.19333333,0.46134022,0.19666667,0.46134022,0.2,0.46134022,0.20333333,0.46134022,0.20666666,0.46134022,0.21,0.46134022,0.21333334,0.46134022,0.21666667,0.46134022,0.22,0.46134022,0.22333333,0.46134022,0.22666667,0.46134022,0.23,0.46134022,0.23333333,0.46134022,0.23666666,0.46134022,0.24,0.46134022,0.24333334,0.46134022,0.24666667,0.46134022,0.25,0.46134022,0.17666666,0.46391752,0.18333334,0.46391752,0.18666667,0.46391752,0.19,0.46391752,0.19333333,0.46391752,0.19666667,0.46391752,0.24333334,0.46391752,0.24666667,0.46391752,0.25,0.46391752,0.25333333,0.46391752,0.25666666,0.46391752,0.26333332,0.46391752,0.17333333,0.46649486,0.17666666,0.46649486,0.18,0.46649486,0.18333334,0.46649486,0.25666666,0.46649486,0.26,0.46649486,0.26333332,0.46649486,0.26666668,0.46649486,0.17,0.46907216,0.17333333,0.46907216,0.17666666,0.46907216,0.26333332,0.46907216,0.26666668,0.46907216,0.27,0.46907216,0.16333333,0.4716495,0.16666667,0.4716495,0.17,0.4716495,0.17333333,0.4716495,0.26666668,0.4716495,0.27,0.4716495,0.27333334,0.4716495,0.27666667,0.4716495,0.16,0.4742268,0.16333333,0.4742268,0.16666667,0.4742268,0.27333334,0.4742268,0.27666667,0.4742268,0.28,0.4742268,0.15666667,0.47680414,0.16,0.47680414,0.16333333,0.47680414,0.27666667,0.47680414,0.28,0.47680414,0.28333333,0.47680414,0.15666667,0.47938144,0.16,0.47938144,0.28,0.47938144,0.28333333,0.47938144,0.15333334,0.48195878,0.15666667,0.48195878,0.28333333,0.48195878,0.28666666,0.48195878,0.14666666,0.48453608,0.15,0.48453608,0.15333334,0.48453608,0.28666666,0.48453608,0.29,0.48453608,0.29333332,0.48453608,0.14666666,0.48711342,0.15,0.48711342,0.15333334,0.48711342,0.28666666,0.48711342,0.29,0.48711342,0.29333332,0.48711342,0.14333333,0.48969072,0.14666666,0.48969072,0.15,0.48969072,0.29,0.48969072,0.29333332,0.48969072,0.29666665,0.48969072,0.14333333,0.49226806,0.14666666,0.49226806,0.29333332,0.49226806,0.29666665,0.49226806,0.14333333,0.49484536,0.29666665,0.49484536,0.14,0.4974227,0.14333333,0.4974227,0.29666665,0.4974227,0.3,0.4974227,0.14,0.5,0.3,0.5,0.13666667,0.5025773,0.14,0.5025773,0.3,0.5025773,0.30333334,0.5025773,0.13666667,0.5051546,0.14,0.5051546,0.3,0.5051546,0.30333334,0.5051546,0.13333334,0.507732,0.13666667,0.507732,0.14,0.507732,0.3,0.507732,0.30333334,0.507732,0.30666667,0.507732,0.13333334,0.5103093,0.13666667,0.5103093,0.30333334,0.5103093,0.30666667,0.5103093,0.13333334,0.5128866,0.13666667,0.5128866,0.30333334,0.5128866,0.30666667,0.5128866,0.13333334,0.5154639,0.13666667,0.5154639,0.30333334,0.5154639,0.30666667,0.5154639,0.13333334,0.51804125,0.13666667,0.51804125,0.30333334,0.51804125,0.30666667,0.51804125,0.13333334,0.52061856,0.13666667,0.52061856,0.30333334,0.52061856,0.30666667,0.52061856,0.13333334,0.52319586,0.13666667,0.52319586,0.30333334,0.52319586,0.30666667,0.52319586,0.13,0.52577317,0.13333334,0.52577317,0.13666667,0.52577317,0.30333334,0.52577317,0.30666667,0.52577317,0.31,0.52577317,0.13333334,0.52835053,0.13666667,0.52835053,0.30333334,0.52835053,0.30666667,0.52835053,0.13333334,0.53092784,0.13666667,0.53092784,0.30333334,0.53092784,0.30666667,0.53092784,0.13333334,0.53350514,0.13666667,0.53350514,0.30333334,0.53350514,0.30666667,0.53350514,0.13333334,0.53608245,0.13666667,0.53608245,0.30333334,0.53608245,0.30666667,0.53608245,0.13333334,0.5386598,0.13666667,0.5386598,0.30333334,0.5386598,0.30666667,0.5386598,0.13333334,0.5412371,0.13666667,0.5412371,0.30333334,0.5412371,0.30666667,0.5412371,0.13333334,0.5438144,0.13666667,0.5438144,0.14,0.5438144,0.3,0.5438144,0.30333334,0.5438144,0.30666667,0.5438144,0.13666667,0.5463917,0.14,0.5463917,0.3,0.5463917,0.30333334,0.5463917,0.13666667,0.5489691,0.14,0.5489691,0.3,0.5489691,0.30333334,0.5489691,0.14,0.5515464,0.3,0.5515464,0.14,0.5541237,0.14333333,0.5541237,0.29666665,0.5541237,0.3,0.5541237,0.14333333,0.556701,0.29666665,0.556701,0.14333333,0.55927837,0.14666666,0.55927837,0.29333332,0.55927837,0.29666665,0.55927837,0.14333333,0.5618557,0.14666666,0.5618557,0.15,0.5618557,0.29,0.5618557,0.29333332,0.5618557,0.29666665,0.5618557,0.14666666,0.564433,0.15,0.564433,0.15333334,0.564433,0.28666666,0.564433,0.29,0.564433,0.29333332,0.564433,0.14666666,0.5670103,0.15,0.5670103,0.15333334,0.5670103,0.28666666,0.5670103,0.29,0.5670103,0.29333332,0.5670103,0.15333334,0.56958765,0.15666667,0.56958765,0.28333333,0.56958765,0.28666666,0.56958765,0.15666667,0.57216495,0.16,0.57216495,0.28,0.57216495,0.28333333,0.57216495,0.15666667,0.57474226,0.16,0.57474226,0.16333333,0.57474226,0.27666667,0.57474226,0.28,0.57474226,0.28333333,0.57474226,0.16,0.57731956,0.16333333,0.57731956,0.16666667,0.57731956,0.27333334,0.57731956,0.27666667,0.57731956,0.28,0.57731956,0.16333333,0.5798969,0.16666667,0.5798969,0.17,0.5798969,0.17333333,0.5798969,0.26666668,0.5798969,0.27,0.5798969,0.27333334,0.5798969,0.27666667,0.5798969,0.17,0.58247423,0.17333333,0.58247423,0.17666666,0.58247423,0.26333332,0.58247423,0.26666668,0.58247423,0.27,0.58247423,0.17333333,0.58505154,0.17666666,0.58505154,0.18,0.58505154,0.18333334,0.58505154,0.25666666,0.58505154,0.26,0.58505154,0.26333332,0.58505154,0.26666668,0.58505154,0.17666666,0.58762884,0.18333334,0.58762884,0.18666667,0.58762884,0.19,0.58762884,0.19333333,0.58762884,0.19666667,0.58762884,0.24333334,0.58762884,0.24666667,0.58762884,0.25,0.58762884,0.25333333,0.58762884,0.25666666,0.58762884,0.26333332,0.58762884,0.19,0.5902062,0.19333333,0.5902062,0.19666667,0.5902062,0.2,0.5902062,0.20333333,0.5902062,0.20666666,0.5902062,0.21,0.5902062,0.21333334,0.5902062,0.21666667,0.5902062,0.22,0.5902062,0.22333333,0.5902062,0.22666667,0.5902062,0.23,0.5902062,0.23333333,0.5902062,0.23666666,0.5902062,0.24,0.5902062,0.24333334,0.5902062,0.24666667,0.5902062,0.25,0.5902062,0.2,0.5927835,0.20333333,0.5927835,0.20666666,0.5927835,0.21,0.5927835,0.21333334,0.5927835,0.21666667,0.5927835,0.22,0.5927835,0.22333333,0.5927835,0.22666667,0.5927835,0.23,0.5927835,0.23333333,0.5927835,0.23666666,0.5927835,0.24,0.5927835,0.20666666,0.5953608,0.21,0.5953608,0.21333334,0.5953608,0.21666667,0.5953608,0.22,0.5953608,0.22333333,0.5953608,0.22666667,0.5953608,0.23,0.5953608,0.23333333,0.5953608]}]}}


		// const tmpData1 = {"result":{"text":[{"type":1,"points":[0.23666666,0.45360824,0.24,0.45360824,0.22,0.45618558,0.22333333,0.45618558,0.22666667,0.45618558,0.23,0.45618558,0.23333333,0.45618558,0.24333334,0.45618558,0.24666667,0.45618558,0.25,0.45618558,0.25333333,0.45618558,0.25666666,0.45618558,0.26,0.45618558,0.20666666,0.45876288,0.21,0.45876288,0.21333334,0.45876288,0.21666667,0.45876288,0.26333332,0.45876288,0.26666668,0.45876288,0.27,0.45876288,0.27333334,0.45876288,0.19666667,0.46134022,0.2,0.46134022,0.20333333,0.46134022,0.27666667,0.46134022,0.28,0.46134022,0.28333333,0.46134022,0.17666666,0.46391752,0.18,0.46391752,0.18333334,0.46391752,0.18666667,0.46391752,0.19,0.46391752,0.19333333,0.46391752,0.28666666,0.46391752,0.29,0.46391752,0.29333332,0.46391752,0.29666665,0.46391752,0.3,0.46391752,0.30333334,0.46391752,0.30666667,0.46391752,0.31,0.46391752,0.31333333,0.46391752,0.31666666,0.46391752,0.32,0.46391752,0.32333332,0.46391752,0.32666665,0.46391752,0.17,0.46649486,0.17333333,0.46649486,0.28666666,0.46649486,0.33,0.46649486,0.33333334,0.46649486,0.33666667,0.46649486,0.34,0.46649486,0.34333333,0.46649486,0.34666666,0.46649486,0.35,0.46649486,0.35333332,0.46649486,0.35666665,0.46649486,0.36,0.46649486,0.36333334,0.46649486,0.36666667,0.46649486,0.37,0.46649486,0.16666667,0.46907216,0.28666666,0.46907216,0.16333333,0.4716495,0.28666666,0.4716495,0.16333333,0.4742268,0.28666666,0.4742268,0.16333333,0.47680414,0.28666666,0.47680414,0.16,0.47938144,0.28666666,0.47938144,0.16,0.48195878,0.28666666,0.48195878,0.16,0.48453608,0.28666666,0.48453608,0.16,0.48711342,0.29,0.48711342,0.15666667,0.48969072,0.29,0.48969072,0.15333334,0.49226806,0.29,0.49226806,0.15333334,0.49484536,0.29,0.49484536,0.15333334,0.4974227,0.29,0.4974227,0.15,0.5,0.29,0.5,0.15,0.5025773,0.29,0.5025773,0.15,0.5051546,0.29,0.5051546,0.15,0.507732,0.28666666,0.507732,0.15,0.5103093,0.28666666,0.5103093,0.15,0.5128866,0.28666666,0.5128866,0.15,0.5154639,0.28666666,0.5154639,0.15,0.51804125,0.28666666,0.51804125,0.15,0.52061856,0.28666666,0.52061856,0.15,0.52319586,0.28333333,0.52319586,0.15333334,0.52577317,0.28333333,0.52577317,0.15333334,0.52835053,0.28,0.52835053,0.15333334,0.53092784,0.27666667,0.53092784,0.15333334,0.53350514,0.27333334,0.53350514,0.15333334,0.53608245,0.26666668,0.53608245,0.27,0.53608245,0.15333334,0.5386598,0.25666666,0.5386598,0.26,0.5386598,0.26333332,0.5386598,0.15666667,0.5412371,0.25,0.5412371,0.25333333,0.5412371,0.15666667,0.5438144,0.24333334,0.5438144,0.24666667,0.5438144,0.15666667,0.5463917,0.23333333,0.5463917,0.23666666,0.5463917,0.24,0.5463917,0.16,0.5489691,0.23,0.5489691,0.16333333,0.5515464,0.22333333,0.5515464,0.22666667,0.5515464,0.16666667,0.5541237,0.17,0.5541237,0.17333333,0.5541237,0.17666666,0.5541237,0.18,0.5541237,0.18333334,0.5541237,0.18666667,0.5541237,0.19,0.5541237,0.19333333,0.5541237,0.19666667,0.5541237,0.2,0.5541237,0.20333333,0.5541237,0.20666666,0.5541237,0.21,0.5541237,0.21333334,0.5541237,0.21666667,0.5541237,0.22,0.5541237]}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.22833333909511566,"right":0.3166666626930237,"top":0.5590206384658813,"bottom":0.628608226776123,"score":0.8552894592285156,"content":"Aa"},{"left":0.6816666126251221,"right":0.7666666507720947,"top":0.42257729172706604,"bottom":0.49860823154449463,"score":0.8148108720779419,"content":"Aa"},{"left":0.6983333230018616,"right":0.7666666507720947,"top":0.5564433336257935,"bottom":0.628608226776123,"score":0.7532452344894409,"content":"Aa"}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.09814612567424774,"right":0.4471101462841034,"top":0.006644518114626408,"bottom":0.15614618360996246,"score":1,"content":"CTrace,write,and say."},{"left":0.10796073824167252,"right":0.5049073100090027,"top":0.1827242523431778,"bottom":0.4518272280693054,"score":0.9702169299125671,"content":"AAAA"},{"left":0.5834242105484009,"right":0.659760057926178,"top":0.17607973515987396,"bottom":0.4485049843788147,"score":0.9523985981941223,"content":"A"},{"left":0.6706652045249939,"right":0.8298800587654114,"top":0.15614618360996246,"bottom":0.43853819370269775,"score":0.9089533090591431,"content":"A"},{"left":0.5866957306861877,"right":0.6521264910697937,"top":0.634551465511322,"bottom":0.8504983186721802,"score":0.8326067328453064,"content":"a"},{"left":0.7699018716812134,"right":0.8276990056037903,"top":0.6411960124969482,"bottom":0.8039867281913757,"score":0.8035371899604797,"content":"a"}]}}
		cb(tmpData1);
		return;
	// const tmpData = {"allText":"Look and Trace\nblackboard\nwindow","block":[{"line":[{"word":[{"content":"Look","cornerPoint":[{"x":87,"y":203},{"x":83,"y":166},{"x":93,"y":164},{"x":97,"y":201}],"location":{"bottom":97,"left":85,"right":124,"top":83},"recognizedLanguage":"und"},{"content":"and","cornerPoint":[{"x":85,"y":161},{"x":82,"y":138},{"x":90,"y":137},{"x":93,"y":160}],"location":{"bottom":93,"left":127,"right":151,"top":82},"recognizedLanguage":"und"},{"content":"Trace","cornerPoint":[{"x":81,"y":132},{"x":77,"y":96},{"x":86,"y":95},{"x":90,"y":131}],"location":{"bottom":90,"left":156,"right":193,"top":77},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"blackboard","cornerPoint":[{"x":119,"y":129},{"x":116,"y":58},{"x":131,"y":57},{"x":134,"y":128}],"location":{"bottom":134,"left":159,"right":231,"top":116},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"window","cornerPoint":[{"x":171,"y":123},{"x":166,"y":72},{"x":177,"y":70},{"x":182,"y":121}],"location":{"bottom":182,"left":165,"right":218,"top":166},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"Trace ttre letters\nLook! She is Short\nShe is a\ngirl.\nShe is a\ngirl.\nShe is smiling. She is","block":[{"line":[{"word":[{"content":"Trace","cornerPoint":[{"x":460,"y":366},{"x":416,"y":366},{"x":416,"y":354},{"x":460,"y":354}],"location":{"bottom":126,"left":20,"right":64,"top":114},"recognizedLanguage":"und"},{"content":"ttre","cornerPoint":[{"x":412,"y":367},{"x":387,"y":367},{"x":387,"y":354},{"x":412,"y":354}],"location":{"bottom":126,"left":68,"right":93,"top":113},"recognizedLanguage":"und"},{"content":"letters","cornerPoint":[{"x":384,"y":367},{"x":334,"y":367},{"x":334,"y":354},{"x":384,"y":354}],"location":{"bottom":126,"left":96,"right":146,"top":113},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Look!","cornerPoint":[{"x":340,"y":316},{"x":300,"y":318},{"x":299,"y":305},{"x":339,"y":303}],"location":{"bottom":177,"left":140,"right":181,"top":162},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"e-Tnace the lettEr5\nAa Aa\nAa\nB b Bb Bbb\nBb\nCc\nCc","block":[{"line":[{"word":[{"content":"e-Tnace","cornerPoint":[{"x":399,"y":393},{"x":317,"y":395},{"x":316,"y":379},{"x":398,"y":377}],"location":{"bottom":103,"left":81,"right":164,"top":85},"recognizedLanguage":"und"},{"content":"the","cornerPoint":[{"x":313,"y":396},{"x":282,"y":396},{"x":281,"y":380},{"x":312,"y":380}],"location":{"bottom":100,"left":167,"right":199,"top":84},"recognizedLanguage":"und"},{"content":"lettEr5","cornerPoint":[{"x":278,"y":397},{"x":217,"y":398},{"x":216,"y":382},{"x":277,"y":381}],"location":{"bottom":99,"left":202,"right":264,"top":82},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Aa","cornerPoint":[{"x":436,"y":362},{"x":349,"y":363},{"x":348,"y":322},{"x":435,"y":321}],"location":{"bottom":159,"left":44,"right":132,"top":117},"recognizedLanguage":"und"}]}]}]}

		cb(tmpData);
	},


	checkGameEnd( arr ) {

		console.log(' in checkGameEnd arr.length: ', arr.length);
		if (!arr) {
			arr = this.animaNodeArr;
		}
		const isEnd = arr.every(node => {
			return node.isShowEnd;
		})

		if (isEnd) {
			this.gameEnd();
		} else {

			this.resetHelperTime();

			// this.endTesting();

			// setTimeout(() => {
			// 	this.startTesting();
			// }, 8000);

		}
	},














	bigStarArr: null,
	initStar() {
		const gArr = this.data.groupArr;
		if (gArr.length <= 1) {
			return;
		}

		this.cleanStar();

		this.bigStarArr = [];

		let baseX = this.canvas.width / 2 - 80 * this._mapScaleMin;
		let baseY = this.canvas.height / 2 - 80 * this._mapScaleMin;
		let disH = 80 * this._mapScaleMin;
		let disScale = 1;
		if (gArr.length > 5) {
			disH = (400 / gArr.length) * this._mapScaleMin;
			disScale = 5 / gArr.length;
		}
		for (let i = 0; i < gArr.length; i++) {
			const starBg = getSprNode('star_bg');
			this.canvas.addChild(starBg, 10);
			starBg.x = baseX;
			starBg.y = baseY - i * disH;
			starBg.scale = disScale;

			const starTop = getSprNode('star');
			starBg.addChild(starTop);
			starTop.active = false;
			starBg.star = starTop;

			const starBig = getSprNode('icon_bigstar');
			starTop.addChild(starBig);
			starBig.angle = -90;
			starBg.starBig = starBig;

			this.bigStarArr.push(starBg);
		}

		console.log("bigStarArr: ", this.bigStarArr);
	},

	cleanStar() {
		if (this.bigStarArr && this.bigStarArr.length > 0) {
			for (let i=0; i<this.bigStarArr.length; i++) {
				this.bigStarArr[i].removeFromParent();
			}
		}
	},


	showBigStar() {
		if (!this.bigStarArr || this.bigStarArr.length <= 0) {
			this.checkGameEnd();
			return;
		}
		const bigStarBg = this.bigStarArr[this.curGroupIndex];

		const starBig = bigStarBg.starBig;
		starBig.scale = 1;
		const star = bigStarBg.star;
		star.active = true;
		star.scaleX = 0.7 / bigStarBg.scale;
		star.scaleY = 1 / bigStarBg.scale;
		star.angle = 90;
		const canvas = cc.find('Canvas');
		const startPos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 2));
		const middlePos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 4));
		star.x = startPos.x;
		star.y = startPos.y - starBig.height;

		console.log('middlePos = ' + JSON.stringify(middlePos));
		const time = 1;
		cc.tween(star)
			.to(0.3, { y: middlePos.y + 80 }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y + 40, scaleX: 1.2 / bigStarBg.scale, scaleY: 0.8 / bigStarBg.scale }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y, scaleX: 1 / bigStarBg.scale, scaleY: 1 / bigStarBg.scale }, { easing: 'quadOut' })
			.delay(0.1)
			.to(0.8, { angle: -720, scale: 1 })
			.start();

		cc.tween(star)
			.delay(0.6)
			.to(0.8, { x: 0 }, { easing: 'quadIn' })
			.start();
		cc.tween(star)
			.delay(0.6)
			.to(0.8, { y: 0 }, { easing: 'quadOut' })
			.start();

		cc.tween(starBig)
			.delay(0.6)
			.to(0.8, { scale: 0 }, { easing: 'quadOut' })
			.call(() => {
				this.checkGameEnd();
				playAudio(this.starCountClip);
			})
			.start();

		playAudio(this.bigStarClip);
	},

	// checkGameEnd() {
	
	// 	this.curGroupIndex ++;
	// 	this.setCurGroupAndQuestion();



	// 	if (!this.curQuestionData) {
	// 		// this.gameEnd();
	// 		return;
	// 	}

	// 	this.showChangeQuesAnim();
	// },

	


	checkBtn: null,
	initBtn() {
		const checkBtn = getSprNode("btn_check");
		checkBtn.scale = this._mapScaleMin;
		this.canvas.addChild(checkBtn);
		checkBtn.x = -500 * this._mapScaleMin;
		checkBtn.y = -35 * this._mapScaleMin;
		checkBtn.baseX = checkBtn.x;
		checkBtn.baseY = checkBtn.y;
		checkBtn.opacity = 0;
		this.checkBtn = checkBtn;

		checkBtn.on(cc.Node.EventType.TOUCH_START, () => {
			if (checkBtn.opacity == 0) {
				return;
			}
			showBtnAnima(checkBtn);
			this.checkBtnClick();
		})

	},

	refreshCheckBtn() {

		this.checkBtn.opacity = 0;

		const arr = this.curOptionArr;
		for (let i=0; i<arr.length; i++) {
			if (arr[i].light.opacity > 254) {
				this.checkBtn.opacity = 255;
				return;
			}
		}
	},

	tryagain: null,
	initIcon() {
		const icon = getSprNode("try_again");
		icon.opacity = 0;
		icon.scale = this._mapScaleMin;
		this.canvas.addChild(icon);

		this.tryagain = icon;
	},

	showTryAgain() {
		const time = 0.3;
		cc.tween(this.tryagain)
			.to(time, {opacity: 255}, {easing: "cubicOut"})
			.delay(0.3)
			.to(time, {opacity: 0}, {easing: "cubicIn"})
			.start();
	},


	initQuestion() {
		this.initPicQuestion();
		this.initTextQuestion();
		this.initVideoQuestion();
		this.initAudioQuestion();
	},

	quesPicBg: null,
	initPicQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesPicBg = picBg;
		picBg.active = false;

		this.addQuesAudio(picBg)
	},

	quesTextBg: null,
	initTextQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesTextBg = picBg;


		const labelNode = new cc.Node();
		labelNode.parent = picBg;
		const label = labelNode.addComponent(cc.RichText);
		const size = 80
		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		// label.string = `<outline color=#a83c13 width=2><size=${size}><color=#ffffff>${this.data.title || " " }</color></size></outline>`
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.CENTER

		label.maxWidth = 648;
	
		picBg.label = label;

		picBg.active = false;
		this.addQuesAudio(picBg)
	},

	quesVideoBg: null,
	videoNode: null,
	initVideoQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesVideoBg = picBg;

		const videoNode = new cc.Node();
		const vPlayer = videoNode.addComponent(cc.VideoPlayer);
		picBg.addChild(videoNode);

		videoNode.width = 678;
		videoNode.height = 396;
		this.videoNode = videoNode;

		picBg.video = vPlayer;


		const btnNode = new cc.Node();
		picBg.addChild(btnNode);
		btnNode.x = picBg.width / 2 + 50;

		const playBtn = getSprNode("video_play");
		btnNode.addChild(playBtn);

		const pauseBtn = getSprNode("video_pause");
		btnNode.addChild(pauseBtn);
		pauseBtn.active = false;


		videoNode.player = vPlayer;
		videoNode.playBtn = playBtn;
		videoNode.pauseBtn = pauseBtn;

		playBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.play();
			playBtn.active = false;
			pauseBtn.active = true;
		})

		pauseBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.pause();
			pauseBtn.active = false;
			playBtn.active = true;
		})

		videoNode.on('completed', () => {
			pauseBtn.active = false;
			playBtn.active = true;
		})


		picBg.active = false;
	},

	quesAudioBg: null,
	initAudioQuestion() {

		
		const audioNode = new cc.Node();
		audioNode.active = false;

		this.canvas.addChild(audioNode);
		audioNode.x = 440 * this._mapScaleMin;
		audioNode.y = -60 * this._mapScaleMin;
		this.quesAudioBg = audioNode;
		
		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/audio_big"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('audio_big')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}

			if (!audioNode.audioClip) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('audio_big');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

	},


	addQuesAudio(bg) {
		const audioNode = new cc.Node();
		bg.addChild(audioNode);
		audioNode.x = bg.width / 2 + 50;


		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/ques_audio"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('ques_audio')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('ques_audio');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

		bg.audioNode = audioNode;
	},

	initOption() {
		this.initPicOption();
		this.initAudioOption();
		this.initTextOption();

		this.initPicOptionBig();
		this.initAudioOptionBig();
		this.initTextOptionBig();
	},

	optionPicBgArr: null,
	initPicOption() {
		// console.log('this.data: ', this.data);
		this.optionPicBgArr = [];
		for (let i=0; i<4; i++) {
		
			const pic = this.getOnePicOption();
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.y = -235 * this._mapScaleMin;
			this.optionPicBgArr.push(pic);

		} 
	},

	optionPicBgBigArr: null,
	initPicOptionBig() {
		this.optionPicBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;


		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}
			const pic = this.getOnePicOption(true);
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.x = baseX + count * disW;
			pic.y = baseY;
			this.optionPicBgBigArr.push(pic);

			count ++;
		} 
	},

	getOnePicOption(isBig = false) {
		const picBgParent = new cc.Node();

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const light = getSprNode(lightResName);
		picBgParent.addChild(light);
		light.opacity = 0;
		picBgParent.light = light;

		const picBg = getSprNode(bgResName);
		picBgParent.addChild(picBg);
		picBgParent.picBg = picBg;

		picBgParent.width = picBg.width;
		picBgParent.height = picBg.height;


		const soundNode = new cc.Node();
		picBgParent.addChild(soundNode);
		picBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = picBgParent.width / 2 - soundIconTop.width / 2;
		soundNode.y = picBgParent.height / 2 //- soundIconTop.height / 2;
		soundNode.active = false;


		picBgParent.active = false;


		picBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}

			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return picBgParent;
	},

	addIconRight(bg) {

		const px = bg.width / 2;
		const py = -bg.height / 2 ;
		const worldPos = bg.convertToWorldSpaceAR(cc.v2(px, py));
		const localPos = this.canvas.convertToNodeSpaceAR(worldPos);


		const iconRight = getSprNode('icon_right');
		iconRight.scale = this._mapScaleMin;
		this.canvas.addChild(iconRight, 1);
		iconRight.x = localPos.x;
		iconRight.y = localPos.y + 50 * this._mapScaleMin;

		bg.iconRight = iconRight;


		this.showOneFirework(cc.v2(0, -bg.height / 3), bg, cc.find('paperBase').children, 200, 300, 20, 1);
	},


	optionAudioBgArr: null,
	initAudioOption() {
		this.optionAudioBgArr = [];
		for (let i=0; i<4; i++) {
		
			const audio = this.getOneAudioOption();
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.y = -235 * this._mapScaleMin;
			this.optionAudioBgArr.push(audio);
		} 
	},

	optionAudioBgBigArr: null,
	initAudioOptionBig() {

		this.optionAudioBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;

		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}

			const audio = this.getOneAudioOption(true);
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.x = baseX + count * disW;
			audio.y = baseY;
			this.optionAudioBgBigArr.push(audio);

			count ++;
		} 
	},


	optionTextBgArr: null,
	initTextOption() {
		this.optionTextBgArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption();
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			// textOption.y = -235 * this._mapScaleMin;
			this.optionTextBgArr.push(textOption);
		} 
	},

	optionTextBgBigArr: null,
	initTextOptionBig() {

		const baseX = -180 * this._mapScaleMin;
		const disW = 100 * this._mapScaleMin;
		let baseY = 220 * this._mapScaleMin;
		const disH = 150 * this._mapScaleMin;

		this.optionTextBgBigArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption(true);
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			textOption.x = baseX;
			textOption.y = baseY - i * disH;
			this.optionTextBgBigArr.push(textOption);
		}
	},

	getOneAudioOption(isBig=false) {

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const audioBgNode = new cc.Node();

		const light = getSprNode(lightResName);
		audioBgNode.addChild(light);
		light.opacity = 0;
		audioBgNode.light = light;

		const picBg = getSprNode(bgResName);
		audioBgNode.addChild(picBg);
		audioBgNode.picBg = picBg;

		audioBgNode.width = picBg.width;
		audioBgNode.height = picBg.height;

		const animNode = cc.instantiate(cc.find("Canvas/res/anim/op_audio"))
		audioBgNode.addChild(animNode);
		animNode.anchorX = 0.6;


		const animTop = getSprNode('op_audio');
		audioBgNode.addChild(animTop);
		animTop.anchorX = 0.6;

		const anim = animNode.getComponent(cc.Animation);
		animNode.opacity = 0;

		audioBgNode.anim = anim;
		audioBgNode.animNode = animNode;
		audioBgNode.animTop = animTop;
		
		audioBgNode.showAnim = () => {
			this.playItemAnim(audioBgNode);
			cc.audioEngine.stop(audioBgNode.audioId);
		}
		audioBgNode.stopAnim = () => {
			cc.audioEngine.stop(audioBgNode.audioId);
			this.stopItemAnim(audioBgNode);
		}

		audioBgNode.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
				
				audioBgNode.showAnim();
				if (audioBgNode.audioClip) {
					audioBgNode.audioId = playAudio(audioBgNode.audioClip, () => {
						this.stopItemAnim(audioBgNode);
					});
				}

			} else {
				light.opacity = 0;
				audioBgNode.stopAnim();
			}

			this.refreshCheckBtn();

		});

		audioBgNode.active = false;

		return audioBgNode;
	},

	getOneTextOption(isBig=false) {

		let lightResName = "option_text_bg_l";
		let bgResName = "option_text_bg";
		if (isBig) {
			lightResName = "op_text_bg_big_l";
			bgResName = "op_text_bg_big";
		}

		const textBgParent = new cc.Node();
		textBgParent.active = false;

		const light = getSprNode(lightResName);
		textBgParent.addChild(light);
		light.opacity = 0;
		textBgParent.light = light;

		const textBg = getSprNode(bgResName);
		textBgParent.addChild(textBg);
		textBgParent.textBg = textBg;

		textBgParent.width = textBg.width;
		textBgParent.height = textBg.height;

		const labelNode = new cc.Node();
		labelNode.parent = textBgParent;
		const label = labelNode.addComponent(cc.Label);

		label.fontSize = 56;
		label.lineHeight = 56;
		if (isBig) {
			label.fontSize = 64;
			label.lineHeight = 64;
		}

		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		textBgParent.label = label;

		const color = new cc.Color();
		cc.Color.fromHEX(color, '#023659' );
		labelNode.color = color;


		const soundNode = new cc.Node();
		textBgParent.addChild(soundNode);
		textBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = textBgParent.width / 2 - 15; // - soundIconTop.width / 2;
		soundNode.y = textBgParent.height / 2 - 15; //- soundIconTop.height / 2;
		soundNode.active = false;


		textBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}
			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return textBgParent;
	},

	playItemAnim(item) {
		item.anim.play();
		item.animNode.opacity = 255;
		item.animTop.opacity = 0;
	},

	stopItemAnim(item) {
		item.animNode.opacity = 0;
		item.animTop.opacity = 255;
	},

	setCurQuestion() {
		
		switch(this.curQuestionData.questionType) {
			case "pic":
				this.setQuestionPic();
				break;
			case "text":
				this.setQuestionText();
				break;
			case "video":
				this.setQuestionVideo();
				break;
			case "audio":
				this.setQuestionAudio();
				break;
		}

		this.refreshCheckBtnPos();
	},

	refreshCheckBtnPos() {
		if (this.curQuestionData.questionType == 'audio') {
			this.checkBtn.x = 440 * this._mapScaleMin;
			this.checkBtn.y = -240 * this._mapScaleMin;
		} else {
			this.checkBtn.x = this.checkBtn.baseX;
			this.checkBtn.y = this.checkBtn.baseY;
		}
	},

	curQuesBg: null,
	setQuestionPic() {

		this.curQuesBg = this.quesPicBg;
		this.curQuesBg.active = true;


		if (this.quesPicBg.pic) {
			this.quesPicBg.pic.removeFromParent();
			this.quesPicBg.pic = null;
		}
		if (this.curQuestionData.pic_url) {
			getSprNodeByUrl(this.curQuestionData.pic_url, (spr) => {
				const sprNode = spr.node;
				setSprNodeMaxLen(sprNode, 678, 396);
				this.quesPicBg.addChild(sprNode)
				this.quesPicBg.pic = sprNode;
			})
		}
	
		const audioNode = this.quesPicBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionText() {
		this.curQuesBg = this.quesTextBg;
		this.curQuesBg.active = true;

		
		const label = this.curQuesBg.label;
		const size = 80; 
		label.string = `<size=${size}><color=#fff4b6>${this.curQuestionData.text}</color></size>`

		const maxH = this.curQuesBg.height * 0.98;

		if (label.node.height > maxH) {
			label.node.scale = maxH / label.node.height
		} else {
			label.node.scale = 1;
		}


		const audioNode = this.curQuesBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionVideo() {
		this.curQuesBg = this.quesVideoBg;
		this.curQuesBg.active = true;
		this.videoNode.active = true;

		if (this.curQuestionData.video_url) {
			this.curQuesBg.video.remoteURL = this.curQuestionData.video_url;
		}
	},

	setQuestionAudio() {
		this.curQuesBg = this.quesAudioBg;
		this.curQuesBg.active = true;


		this.curQuesBg.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				this.curQuesBg.audioClip = audioClip;
			});
		}
	},



	setCurOption() {
		const arr = this.curQuestionData.answerArr;

		const isBig = this.curQuestionData.questionType == 'audio';

		switch(this.curQuestionData.answerType) {
			case "pic":
				this.setOptionPic(arr, isBig);
				break;
			case "audio":
				this.setOptionAudio(arr, isBig);
				break;
			case "text":
				this.setOptionText(arr, isBig);
				break;
		}
		
	},



	curOptionArr: null,
	setOptionPic(arr, isBig=false) {

		let opItemArr = this.optionPicBgArr;
		if (isBig) {
			opItemArr = this.optionPicBgBigArr;
		}
		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const picBg = opItemArr[i].picBg;
			picBg.removeAllChildren();
			
			const data = arr[i];
			if (data.pic_url) {
				getSprNodeByUrl, getSprNodeByUrl(data.pic_url, (spr) => {
					let maxW = 280;
					let maxH = 190;
					if (isBig) {
						maxW = 366;
						maxH = 248;
					}

					setSprNodeMaxLen(spr.node, maxW, maxH);
					console.log('spr: ', spr);
					picBg.addChild(spr.node);
				})
			}

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},


	setOptionAudio(arr, isBig=false) {

		let opItemArr = this.optionAudioBgArr;
		if (isBig) {
			opItemArr = this.optionAudioBgBigArr;
		}

		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if(!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const data = arr[i];

			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					opItemArr[i].audioClip = audioClip;
				});
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},

	setOptionAudioBig(arr) {
		this.curOptionArr = [];
		for (let i=0; i<arr.length; i++) {
			
			this.optionAudioBgArr[i].active = true;

			const data = arr[i];

			this.optionAudioBgArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					this.optionAudioBgArr[i].audioClip = audioClip;
				});
			}

			this.optionAudioBgArr[i].data = data;
			this.curOptionArr.push(this.optionAudioBgArr[i]);
		}
	},


	setOptionText(options, isBig=false) {

		console.log(' in setOptionText, isBig: ', isBig);

		let opItemArr = this.optionTextBgArr;
		if (isBig) {
			opItemArr = this.optionTextBgBigArr
		}

		this.curOptionArr = [];
		const disW = 315 * this._mapScaleMin;
		const disH = 120 * this._mapScaleMin;
		const baseX = - disW ;
		let baseY = -235 * this._mapScaleMin;
		if (options.length > 2) {
			baseY = -170 * this._mapScaleMin;
		}
		let count = 0;
		for (let i=0; i<options.length; i++) {

			if ( i == 2 ) {
				baseY -= disH;
				count = 0;
			}
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + count * disW * 2;
				opItemArr[i].y = baseY;
			}
		
			const data = options[i];

			opItemArr[i].label.string = data.text;
			opItemArr[i].label["_forceUpdateRenderData"](true);
			if (opItemArr[i].label.node.width > opItemArr[i].width * 0.9) {
				opItemArr[i].label.node.scale = opItemArr[i].width * 0.9 / opItemArr[i].label.node.width;
			} else {
				opItemArr[i].label.node.scale = 1;
			}
			

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);

			count++;
		}
	},



	shakeArr: null,
	wrongArr: null,
	checkBtnClick() {

		this.shakeArr = [];
		this.wrongArr = [];
		this.checkItemWrong();

		if (this.wrongArr.length > 0) {
			//有选错的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		const isRightAll = this.checkItemRightCount();
		if (!isRightAll) {
			// 有漏选的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		this.showAllRight();
		this.showMask();

		playAudio(this.rightClip, () => {
			this.playAnswerAudio(0);
		})
		
	},

	playAnswerAudio(index) {
		const arr = this.curOptionArr;
		if (!arr[index]) {

			// delayCall(0.5, () => {
				this.changeNextQuestion();
			// })

		} else {
			if ( arr[index].light.opacity > 254 && arr[index].audioClip ) {
				playAudio(arr[index].audioClip, () => {
					this.playAnswerAudio(index + 1);
				})
			} else {
				this.playAnswerAudio(index + 1);
			}
		}
	},


	checkItemWrong() {
		const arr = this.curOptionArr;
		console.log('arr: ', arr);
		for (let i=0; i<arr.length; i++) {
			const itemBg = arr[i];
			if (itemBg.light.opacity >= 254) {
				this.shakeArr.push(itemBg);
				console.log('aaa', itemBg.data);;
				if (itemBg.data.answerRight == '0') {
					this.wrongArr.push(itemBg);
				}
			}
		}
	},

	checkItemRightCount() {
		let rightTotalCount = 0;
		const answerArr = this.curQuestionData.answerArr;
		for (let i=0; i<answerArr.length; i++) {
			if (answerArr[i].answerRight == '1') {
				rightTotalCount ++;
			}
		}

		let curRightCount = 0;
		const curOptionArr = this.curOptionArr;
		for (let i=0; i<curOptionArr.length; i++) {
			if (curOptionArr[i].light.opacity > 254) {
				curRightCount ++;
			}
		}

		return rightTotalCount == curRightCount;
	},

	itemShake() {
		let rate = 1;
		if (this.curQuestionData.answerType == 'text') {
			rate = 0.5;
		}

		const arr = this.shakeArr;
		for (let i=0; i<arr.length; i++) {
			this.rotateShake(arr[i], rate);
			if (arr[i].stopAnim) {
				arr[i].stopAnim();
			}
		}

		this.showTryAgain();
	},

	hideLight() {
		const arr = this.curOptionArr;
		for (let i=0; i<arr.length;