// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

// import { getSprNode } from "./util";
import { getSprNode, playAudioByUrl, showBtnAnima, getScaleRateBy2Node, localPosTolocalPos, randomSortByArr, loadDragonBones, playAudio, showTrebleFirework, getSprNodeByUrl, setSprNodeMaxLen, delayCall, asyncDelay, RandomInt, exchangeNodePos, onHomeworkFinish} from "../script/OP72_util";

cc.Class({
	extends: cc.Component,

	properties: {
		baseWidth: {
			default: 1920,
			type: cc.Integer
		},
		baseHeight: {
			default: 1200,
			type: cc.Integer
		}
	},

	onLoad() {
		cc.debug.setDisplayStats(false);
		this.initSceneData();
		this.initSize();
	},

	initSceneData() {
		this._imageResList = [];
		this._audioResList = [];
		this._animaResList = [];
	},


	_designSize: null,
	_frameSize: null,
	_mapScaleMin: null,
	_mapScaleMax: null,
	_cocosScale: null,
	canvas: null,
	initSize() {


		// 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
		let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
		let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
		let f = screen_size >= design_size
		cc.Canvas.instance.fitHeight = f
		cc.Canvas.instance.fitWidth = !f

		const frameSize = cc.view.getFrameSize();
		this._frameSize = frameSize;

		this._designSize = cc.view.getDesignResolutionSize();

		let sx = cc.winSize.width / frameSize.width;
		let sy = cc.winSize.height / frameSize.height;
		this._cocosScale = Math.min(sx, sy);

		sx = frameSize.width / this._designSize.width;
		sy = frameSize.height / this._designSize.height;
		this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
		this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;

		this.canvas = cc.find('Canvas');


		// cc.log('cc.Canvas: ', cc.Canvas);
	},

	start() {

		console.log(' in start 1 ');

		let getData = this.getData.bind(this);
		if (window && window.courseware) {
			getData = window.courseware.getData;

			console.log(' in start 2 ');

		}
		getData((data) => {
			console.log('data:', data);
			this.data = data || this.getDefaultData();
			this.preloadItem()
		})
	},

	_imageResList: null,
	_audioResList: null,
	_animaResList: null,
	preloadItem() {
		this.addPreloadImage();
		this.addPreloadAudio();
		this.addPreloadAnima();
		this.preload();
	},


	getData(func) {
		if (window && window.courseware) {
			window.courseware.getData(func, 'dfzx_cocos_dqq');
			return;
		}
		
		const middleLayer = cc.find('middleLayer');
		if (middleLayer) {
			const middleLayerComponent = middleLayer.getComponent('middleLayer');
			middleLayerComponent.getData(func);
			return;
		}
		
		func(this.getDefaultData());
	},

	getDefaultData() {

		
		return this.item = {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"45","bgItem":{"url":"https://teach.cdn.ireadabc.com/457c72a9cb0f903e45e151f5a4c836e1.png","rect":{"x":224.33,"y":0,"width":1130.34,"height":595}},"hotZoneItemArr":[{"id":"1669027968644","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":440.5,"posY":169.5,"rect":{"x":99.67,"y":95,"width":233,"height":149},"rectNew":1},{"id":"1669028023205","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":443.499071286044,"posY":346.5004510516205,"rect":{"x":102.67,"y":272,"width":233,"height":149},"rectNew":2},{"id":"1669028023430","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/0a425bcf53cf83eca9b725f62957d873.json","name":"db_letter_i_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/65ba76a8bcbb05c926be163c60a67ab0.json","name":"db_letter_i_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/364b37a6c1e6c7b6f4a270cb81ec5f0b.png","name":"db_letter_i_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":443.4990792692586,"posY":513.501366460219,"rect":{"x":102.67,"y":439,"width":233,"height":149},"rectNew":3},{"id":"1669028023680","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/7fd4e5db04c04cdcf0dc6b0c12fc4764.json","name":"db_letter_k_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/c5c2c04b305ae8890c9f050d7cbbf97a.json","name":"db_letter_k_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/4d31a35f1a705b9ab198f044ed391fc0.png","name":"db_letter_k_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1189.499071286044,"posY":170.50045105162047,"rect":{"x":848.67,"y":96,"width":233,"height":149},"rectNew":4},{"id":"1669028023942","index":4,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1189.499071286044,"posY":342.5004510516205,"rect":{"x":848.67,"y":268,"width":233,"height":149},"rectNew":5},{"id":"1669028024195","index":5,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/c6709d297504ba62f2d13a2eb44da44d.json","name":"db_letter_m_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/022e2f69c84cf184a5bc81c2e979681e.json","name":"db_letter_m_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/e8f339a51ca03184dc747c1af75fb169.png","name":"db_letter_m_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"1","posX":1192.501069750746,"posY":513.5013691212904,"rect":{"x":851.67,"y":439,"width":233,"height":149},"rectNew":6},{"id":"1669028676925","index":6,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":660.5,"posY":240.5,"rect":{"x":411.67,"y":216,"width":49,"height":49},"pointItem":7,"linkItem":16},{"id":"1669028762010","index":7,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":811.4996567217756,"posY":241.50063998769747,"rect":{"x":562.67,"y":217,"width":49,"height":49},"pointItem":8,"linkItem":18},{"id":"1669028762200","index":8,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":959.4996567217756,"posY":239.50063998769747,"rect":{"x":710.67,"y":215,"width":49,"height":49},"pointItem":9,"linkItem":14},{"id":"1669028762448","index":9,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":661.4996567217756,"posY":440.50063998769747,"rect":{"x":412.67,"y":416,"width":49,"height":49},"pointItem":10,"linkItem":15},{"id":"1669028762652","index":10,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":810.4996567217756,"posY":440.50063998769747,"rect":{"x":561.67,"y":416,"width":49,"height":49},"pointItem":11,"linkItem":13},{"id":"1669028762878","index":11,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":959.4996567217756,"posY":438.50063998769747,"rect":{"x":710.67,"y":414,"width":49,"height":49},"pointItem":12,"linkItem":17},{"id":"1669028763095","index":12,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":169.50063998769747,"rect":{"x":298.67,"y":145,"width":49,"height":49},"pointItem":13,"linkItem":11},{"id":"1669028763723","index":13,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":342.50063998769747,"rect":{"x":298.67,"y":318,"width":49,"height":49},"pointItem":14,"linkItem":9},{"id":"1669028763919","index":14,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":547.4996567217756,"posY":515.5006399876975,"rect":{"x":298.67,"y":491,"width":49,"height":49},"pointItem":15,"linkItem":10},{"id":"1669028764788","index":15,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1084.4996567217756,"posY":169.50063998769747,"rect":{"x":835.67,"y":145,"width":49,"height":49},"pointItem":16,"linkItem":7},{"id":"1669028765508","index":16,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1085.4996567217756,"posY":341.50063998769747,"rect":{"x":836.67,"y":317,"width":49,"height":49},"pointItem":17,"linkItem":12},{"id":"1669028766684","index":17,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"0","posX":1085.4996567217756,"posY":514.5006399876975,"rect":{"x":836.67,"y":490,"width":49,"height":49},"pointItem":18,"linkItem":8},{"id":"1669028965617","index":18,"audio_url":"https://teach.cdn.ireadabc.com/fa4edbee3e71acaac5426787327cc70e.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":555.5,"posY":98.5,"rect":{"x":305.67,"y":73,"width":51,"height":51}},{"id":"1669028987109","index":19,"audio_url":"https://teach.cdn.ireadabc.com/e7bcf57e7c23c38c0d276aa94b44cdad.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":564.4993746481958,"posY":268.5002674376865,"rect":{"x":314.67,"y":243,"width":51,"height":51}},{"id":"1669028988980","index":20,"audio_url":"https://teach.cdn.ireadabc.com/48bc4f1bf13394bc9dbc0a2943aa49bc.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":563.4993746481958,"posY":434.5002674376865,"rect":{"x":313.67,"y":409,"width":51,"height":51}},{"id":"1669028989259","index":21,"audio_url":"https://teach.cdn.ireadabc.com/b1cfbb3de49089766cc3445728a4ada7.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1311.499374648196,"posY":94.50026743768646,"rect":{"x":1061.67,"y":69,"width":51,"height":51}},{"id":"1669028989473","index":22,"audio_url":"https://teach.cdn.ireadabc.com/22b083172dcc1cd6cb29c31542df5fc5.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1308.499374648196,"posY":266.5002674376865,"rect":{"x":1058.67,"y":241,"width":51,"height":51}},{"id":"1669028989757","index":23,"audio_url":"https://teach.cdn.ireadabc.com/37e1f105a64fdfd3424e2dc8676b00a9.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1313.499374648196,"posY":438.5002674376865,"rect":{"x":1063.67,"y":413,"width":51,"height":51}}],"typeArr":[{"gIdx":"1","name":"手写"},{"gIdx":"0","name":"连线"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/58c55c5d77576fad7c547123ba68d02a.png","rect":{"x":162.95,"y":0,"width":1253.11,"height":1621}},"hotZoneItemArr2":[{"id":"1669028281208","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":405.5,"posY":715.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":112.05,"y":640,"width":261,"height":151}},{"id":"1669028304948","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":404.4954815894788,"posY":908.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":111.05,"y":833,"width":261,"height":151}},{"id":"1669028305153","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Ii","posX":406.4954815894788,"posY":1094.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":113.05,"y":1019,"width":261,"height":151}},{"id":"1669028305356","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Kk","posX":1232.495481589479,"posY":715.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":939.02,"y":640,"width":261,"height":151}},{"id":"1669028305571","index":4,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":1230.495481589479,"posY":910.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":937.02,"y":835,"width":261,"height":151}},{"id":"1669028305755","index":5,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"6","labelText":"Mm","posX":1233.495481589479,"posY":1101.499102675038,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":940.02,"y":1026,"width":261,"height":151}},{"id":"1669028350559","index":6,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":649.5,"posY":793.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":463.05,"y":770,"width":47,"height":47}},{"id":"1669028390520","index":7,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":812.4951755834819,"posY":792.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.05,"y":769,"width":47,"height":47}},{"id":"1669028390701","index":8,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":979.4951755834819,"posY":794.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":793.03,"y":771,"width":47,"height":47}},{"id":"1669028390911","index":9,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":648.4951755834819,"posY":1013.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":462.05,"y":990,"width":47,"height":47}},{"id":"1669028391078","index":10,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":812.4951755834819,"posY":1016.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.05,"y":993,"width":47,"height":47}},{"id":"1669028391273","index":11,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":978.4951755834819,"posY":1014.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":792.03,"y":991,"width":47,"height":47}},{"id":"1669028427605","index":12,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":520.4951755834819,"posY":715.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":334.05,"y":692,"width":47,"height":47}},{"id":"1669028427782","index":13,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":523.4951755834819,"posY":904.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":337.05,"y":881,"width":47,"height":47}},{"id":"1669028427990","index":14,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":523.4951755834819,"posY":1094.4990048534487,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":337.05,"y":1071,"width":47,"height":47}},{"id":"1669028428167","index":15,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1119.4951755834818,"posY":715.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":933.03,"y":692,"width":47,"height":47}},{"id":"1669028428404","index":16,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1116.4951755834818,"posY":902.4990048534488,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":930.03,"y":879,"width":47,"height":47}},{"id":"1669028428589","index":17,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"0","posX":1118.4951755834818,"posY":1096.4990048534487,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":932.03,"y":1073,"width":47,"height":47}}],"firstGIdx":"1","begin_audio_url":"https://teach.cdn.ireadabc.com/165a2ffaf57e33e73a2ba10e5f81a38c.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/36e09d2c6e5b7191f2eaa367211a30e3.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/822af0678dc62dc2846ff8fa0f773ccc.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/822af0678dc62dc2846ff8fa0f773ccc.mp3","isDebug":true}

		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"9","bgItem":{"url":"https://teach.cdn.ireadabc.com/684f085ef1286bef60066720162381b8.png","rect":{"x":196.6,"y":0,"width":1057.8,"height":548}},"hotZoneItemArr":[{"id":"1669017611587","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":692.9602814259316,"posY":185.7589939450262,"rect":{"x":418.73,"y":149.83,"width":42.5,"height":42.5},"pointItem":1,"linkItem":9},{"id":"1669017628260","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":895.1838773664921,"posY":185.66390047751776,"rect":{"x":604.98,"y":149.75,"width":42.5,"height":42.5},"pointItem":2,"linkItem":10},{"id":"1669017628745","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":1077.07009039729,"posY":252.81717081690795,"rect":{"x":772.49,"y":211.59,"width":42.5,"height":42.5},"pointItem":3,"linkItem":11},{"id":"1669017629096","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":1084.4044361247306,"posY":406.36600093794283,"rect":{"x":779.25,"y":353.01,"width":42.5,"height":42.5},"pointItem":4,"linkItem":12},{"id":"1669017629331","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":910.7574753538651,"posY":448.46716877009555,"rect":{"x":619.32,"y":391.79,"width":42.5,"height":42.5},"pointItem":5,"linkItem":13},{"id":"1669017629556","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":681.5308422309823,"posY":448.3720753025871,"rect":{"x":408.21,"y":391.7,"width":42.5,"height":42.5},"pointItem":6,"linkItem":14},{"id":"1669017629775","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":500.83481613520166,"posY":398.3169356130275,"rect":{"x":241.78,"y":345.6,"width":42.5,"height":42.5},"pointItem":7,"linkItem":15},{"id":"1669017630034","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":499.92990960271015,"posY":251.81717081690795,"rect":{"x":240.94,"y":210.67,"width":42.5,"height":42.5},"pointItem":8,"linkItem":16},{"id":"1669017679915","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":746.6841125703726,"posY":244.38773162195878,"rect":{"x":468.21,"y":203.83,"width":42.5,"height":42.5},"pointItem":9,"linkItem":1},{"id":"1669017680161","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":850.0336442094241,"posY":245.6730120244842,"rect":{"x":563.4,"y":205.02,"width":42.5,"height":42.5},"pointItem":10,"linkItem":2},{"id":"1669017680397","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":906.2329426914074,"posY":277.34474066168775,"rect":{"x":615.16,"y":234.18,"width":42.5,"height":42.5},"pointItem":11,"linkItem":3},{"id":"1669017680628","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":905.3280361589159,"posY":363.9304873783493,"rect":{"x":614.32,"y":313.93,"width":42.5,"height":42.5},"pointItem":12,"linkItem":4},{"id":"1669017681310","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":849.223831144441,"posY":395.69730948306136,"rect":{"x":562.65,"y":343.18,"width":42.5,"height":42.5},"pointItem":13,"linkItem":5},{"id":"1669017681516","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":747.7792060378811,"posY":396.6022160155529,"rect":{"x":469.21,"y":344.02,"width":42.5,"height":42.5},"pointItem":14,"linkItem":6},{"id":"1669017681761","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":684.5308422309823,"posY":360.0255808458578,"rect":{"x":410.97,"y":310.33,"width":42.5,"height":42.5},"pointItem":15,"linkItem":7},{"id":"1669017681968","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":273.3834705509816},"gIdx":"0","posX":684.3406552959655,"posY":279.05946025916234,"rect":{"x":410.79,"y":235.76,"width":42.5,"height":42.5},"pointItem":16,"linkItem":8},{"id":"1669169946060","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"skeJsonData":{"url":"https://teach.cdn.ireadabc.com/b213e3ebfa399bead9cef9a5b6089a5c.json","name":"db_letter_c_ske.json"},"texJsonData":{"url":"https://teach.cdn.ireadabc.com/f2f7de385d5ec34d1f51c1d0d639d0db.json","name":"db_letter_c_tex.json"},"texPngData":{"url":"https://teach.cdn.ireadabc.com/bc2ecbb4ccad7ed8717ab0c6b9a15a40.png","name":"db_letter_c_tex.png"},"dragDot":{"x":725.5,"y":274},"gIdx":"1","posX":731.5,"posY":299,"rect":{"x":434.9,"y":231,"width":200,"height":136},"rectNew":17}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"bgItem2":{"url":"https://teach.cdn.ireadabc.com/7975e4a930fe51033b0e1321260d4046.png","rect":{"x":148.42,"y":0,"width":1154.16,"height":1493}},"hotZoneItemArr2":[{"id":"1669017732389","index":0,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":684.5,"posY":746.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":454.12,"y":661.3,"width":52.5,"height":52.5}},{"id":"1669017744633","index":1,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":905.4951316891791,"posY":743.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":657.65,"y":658.54,"width":52.5,"height":52.5}},{"id":"1669017744849","index":2,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1101.495131689179,"posY":819.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":838.17,"y":728.54,"width":52.5,"height":52.5}},{"id":"1669017745296","index":3,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":1110.495131689179,"posY":986.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":846.46,"y":882.35,"width":52.5,"height":52.5}},{"id":"1669017745504","index":4,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":923.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":674.23,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745728","index":5,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":673.4951316891791,"posY":1029.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":443.99,"y":921.96,"width":52.5,"height":52.5}},{"id":"1669017745946","index":6,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":477.49513168917906,"posY":977.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":263.46,"y":874.06,"width":52.5,"height":52.5}},{"id":"1669017747640","index":7,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":475.49513168917906,"posY":815.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":261.62,"y":724.85,"width":52.5,"height":52.5}},{"id":"1669017780767","index":8,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":510.3,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781123","index":9,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":810.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":610.67,"y":720.25,"width":52.5,"height":52.5}},{"id":"1669017781698","index":10,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":918.4951316891791,"posY":847.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":669.62,"y":754.33,"width":52.5,"height":52.5}},{"id":"1669017782166","index":11,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":916.4951316891791,"posY":935.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":667.78,"y":835.38,"width":52.5,"height":52.5}},{"id":"1669017783084","index":12,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":854.4951316891791,"posY":972.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":610.67,"y":869.46,"width":52.5,"height":52.5}},{"id":"1669017783667","index":13,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":745.4951316891791,"posY":976.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":510.3,"y":873.14,"width":52.5,"height":52.5}},{"id":"1669017784240","index":14,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":678.4951392139167,"posY":937.4988242597458,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":448.59,"y":837.22,"width":52.5,"height":52.5}},{"id":"1669017785006","index":15,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":744.797656744775},"gIdx":"0","posX":675.4951316891791,"posY":843.4990637972269,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":445.83,"y":750.64,"width":52.5,"height":52.5}},{"id":"1669170012773","index":16,"itemType":"rect","fontScale":1.13359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13359375,"dragDot":{"x":725.5,"y":746.5},"gIdx":"6","labelText":"Cc","posX":734.5,"posY":820.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":486.08,"y":745,"width":200,"height":151}}],"begin_audio_url":"https://teach.cdn.ireadabc.com/d9b3da5d0b70ff3f18d873c801bd6738.mp3","idle_audio_url":"https://teach.cdn.ireadabc.com/dcab0b2e68914fe53a20f84d2bd03b26.mp3","finish_right_audio_url":"https://teach.cdn.ireadabc.com/0f7b10efe5f6684bddcb6a2795f4d4a3.mp3","change_step_audio_url":"https://teach.cdn.ireadabc.com/244fbb2af5518b573085fc80c0c3c064.mp3","idle_2_audio_url":"https://teach.cdn.ireadabc.com/af2e83f337b4a5e86be034c7ffcee9ca.mp3","firstGIdx":"1"}
		return {"book_id":"Oxford_Phonics_World_1_SB","part_name":"d","page_id":"13","bgItem":{"url":"http://teach.cdn.ireadabc.com/c5adfdc66a6e6c96ebe6da6565ec1f70.png","rect":{"x":219.09,"y":0,"width":1140.81,"height":595}},"hotZoneItemArr":[{"id":"1669018212234","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":465.5733991394584,"posY":265.738764146509,"rect":{"x":179.75,"y":199,"width":133.47,"height":133.47},"circleItem":1},{"id":"1669018428827","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":700.1100806305817,"posY":398.36855045738866,"rect":{"x":417.82,"y":335.17,"width":126.4,"height":126.4},"circleItem":2},{"id":"1669018440517","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":929.0410565137215,"posY":131.18563112412767,"rect":{"x":636.78,"y":58,"width":146.37,"height":146.37},"circleItem":3},{"id":"1669022543478","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"skeJsonData":{"url":"http://teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":789.5,"y":297.5},"gIdx":"2","posX":1168.5790418503811,"posY":528.7355952934026,"rect":{"x":882.76,"y":462,"width":133.47,"height":133.47},"circleItem":4},{"id":"1669088187793","index":4,"audio_url":"http://teach.cdn.ireadabc.com/253021eecc33765f06675cdad73b3a01.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":508.5,"posY":91.5,"rect":{"x":263.91,"y":66,"width":51,"height":51}},{"id":"1669088213504","index":5,"audio_url":"http://teach.cdn.ireadabc.com/2518788213ccb81735afd87efcea0d4b.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":746.5041818824636,"posY":85.5002731976987,"rect":{"x":501.91,"y":60,"width":51,"height":51}},{"id":"1669088213739","index":6,"audio_url":"http://teach.cdn.ireadabc.com/63d19e1ff307a581b796c8dd185def79.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":986.5041818824636,"posY":83.5002731976987,"rect":{"x":741.91,"y":58,"width":51,"height":51}},{"id":"1669088214011","index":7,"audio_url":"http://teach.cdn.ireadabc.com/4529ba230c0521bf20493eae24299643.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1199.5041818824636,"posY":97.5002731976987,"rect":{"x":954.91,"y":72,"width":51,"height":51}},{"id":"1669088215319","index":8,"audio_url":"http://teach.cdn.ireadabc.com/2c3a3676cd313c128abc9a47846bf379.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":521.5041818824636,"posY":239.5002731976987,"rect":{"x":276.91,"y":214,"width":51,"height":51}},{"id":"1669088215558","index":9,"audio_url":"http://teach.cdn.ireadabc.com/8517c90273b266fdeae51c7db4d78c4d.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":749.5041818824636,"posY":237.5002731976987,"rect":{"x":504.91,"y":212,"width":51,"height":51}},{"id":"1669088215822","index":10,"audio_url":"http://teach.cdn.ireadabc.com/3bb98de81b960185c16d81da98a35c0c.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":987.5041818824636,"posY":238.5002731976987,"rect":{"x":742.91,"y":213,"width":51,"height":51}},{"id":"1669088216062","index":11,"audio_url":"http://teach.cdn.ireadabc.com/1e79b88dd5762bc75dc4ca8114124eff.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1207.5041818824636,"posY":240.50027319769868,"rect":{"x":962.91,"y":215,"width":51,"height":51}},{"id":"1669088216898","index":12,"audio_url":"http://teach.cdn.ireadabc.com/02914cba7db081e503c3d66c7d01026f.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":517.5041818824636,"posY":365.5002731976987,"rect":{"x":272.91,"y":340,"width":51,"height":51}},{"id":"1669088217138","index":13,"audio_url":"http://teach.cdn.ireadabc.com/abccf8f6ce8893cf6c3ba8c43202fe0c.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":754.5041818824636,"posY":362.5002731976987,"rect":{"x":509.91,"y":337,"width":51,"height":51}},{"id":"1669088217360","index":14,"audio_url":"http://teach.cdn.ireadabc.com/625a6ca75e12a8db5e845566934dc2d5.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":995.5041818824636,"posY":364.5002731976987,"rect":{"x":750.91,"y":339,"width":51,"height":51}},{"id":"1669088217595","index":15,"audio_url":"http://teach.cdn.ireadabc.com/b2979f011a3377e73e8a0815f7cd4d93.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1214.5041818824636,"posY":361.5002731976987,"rect":{"x":969.91,"y":336,"width":51,"height":51}},{"id":"1669088218362","index":16,"audio_url":"http://teach.cdn.ireadabc.com/5caffaa50b270c638cb2cee922d8da4f.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":510.5041818824636,"posY":491.5002731976987,"rect":{"x":265.91,"y":466,"width":51,"height":51}},{"id":"1669088218571","index":17,"audio_url":"http://teach.cdn.ireadabc.com/eb58af12affc6159b6299ac73b8aacd6.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":760.5041818824636,"posY":489.5002731976987,"rect":{"x":515.91,"y":464,"width":51,"height":51}},{"id":"1669088218819","index":18,"audio_url":"http://teach.cdn.ireadabc.com/fc549fddfeed935929831d457d2544d6.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1001.5041818824636,"posY":489.5002731976987,"rect":{"x":756.91,"y":464,"width":51,"height":51}},{"id":"1669088219087","index":19,"audio_url":"http://teach.cdn.ireadabc.com/84ce55828bd07b8e7efb25bc31c4d0ed.mp3","itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":297.5},"gIdx":"3","posX":1214.5041818824636,"posY":489.5002731976987,"rect":{"x":969.91,"y":464,"width":51,"height":51}}],"typeArr":[{"gIdx":"2","name":"画圈"}],"bgItem2":{"url":"http://teach.cdn.ireadabc.com/2b25e222cf2e751984a18c7a589194f4.png","rect":{"x":162.95,"y":0,"width":1253.11,"height":1621}},"hotZoneItemArr2":[{"id":"1669018544051","index":0,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":439.49543894929894,"posY":821.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":160.04,"y":726,"width":233.01,"height":191}},{"id":"1669018570547","index":1,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":689.4954389492989,"posY":960.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":402.04,"y":850,"width":249.01,"height":221}},{"id":"1669018571312","index":2,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":946.4944845617431,"posY":673.4986123129693,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":673.04,"y":586,"width":221.01,"height":175}},{"id":"1669022636621","index":3,"itemType":"rect","fontScale":1.23359375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.23359375,"dragDot":{"x":789.5,"y":810.5},"gIdx":"7","posX":1203.495438949299,"posY":1107.4989697380065,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":942.04,"y":1026,"width":197.01,"height":163}}],"begin_audio_url":"http://teach.cdn.ireadabc.com/a382738d66f84a7dc453e1aee978f286.mp3","idle_audio_url":"http://teach.cdn.ireadabc.com/a4758f8c14cb5859b3395514578a5f0f.mp3","finish_right_audio_url":"http://teach.cdn.ireadabc.com/b019c28398d252f09042114e1260779c.mp3"}
		
		return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/1911e3568e927257c91a8fd25d118398.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":313.64,"y":0,"width":1130.71,"height":666}},"hotZoneItemArr":[{"id":"1668059700120","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":774,"posY":221,"rect":{"x":434.36,"y":195,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1668059708822","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":840.0046289463639,"posY":286.00078101674904,"rect":{"x":500.36,"y":260,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1668059715388","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":999.0048621911851,"posY":221.00101072755757,"rect":{"x":659.4,"y":195,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1668059723401","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0054240991628,"posY":285.00078101674904,"rect":{"x":609.41,"y":259,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1668059730444","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1199.015247433881,"posY":294.00100719354515,"rect":{"x":859.42,"y":268,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1668059737547","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.026130972331,"posY":322.0010389996571,"rect":{"x":671.43,"y":296,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1668059742714","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1206.0354666133326,"posY":463.00113795200537,"rect":{"x":866.44,"y":437,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1668059747117","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.0461557810982,"posY":415.00163624775934,"rect":{"x":671.45,"y":389,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1668059754005","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1017.0554666840126,"posY":508.00146661516226,"rect":{"x":677.46,"y":482,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1668059760443","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0654879234274,"posY":451.0017952783191,"rect":{"x":609.47,"y":425,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1668059768151","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":767.0752476459216,"posY":505.00159383961,"rect":{"x":427.44,"y":479,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1668059772490","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":836.0846044909979,"posY":451.0017846762818,"rect":{"x":496.44,"y":425,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1668059780036","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":569.0848483378562,"posY":455.00159383961005,"rect":{"x":229.44,"y":429,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1668059786972","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0839047565349,"posY":416.0016079756598,"rect":{"x":430.44,"y":390,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1668059793504","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":567.0846150930352,"posY":293.0014701491747,"rect":{"x":227.44,"y":267,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1668059803802","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0838976885101,"posY":321.00103546564463,"rect":{"x":430.44,"y":295,"width":52,"height":52},"linkItem":15,"pointItem":16},{"id":"1668062996049","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/8d6671efb002131453b527eeed3bf97f.json","name":"C大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/73fe384407514cdb6367e836a45cfa03.json","name":"C大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ef6a958b04c1fed3a47881a592483df7.png","name":"C大黑_tex.png"},"dragDot":{"x":879,"y":333},"gIdx":"1","posX":890,"posY":368,"rect":{"x":464.36,"y":293,"width":224,"height":150},"rectNew":17}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":177.27,"y":0,"width":1403.46,"height":1816}},"hotZoneItemArr2":[{"id":"1668060479065","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"0","posX":761,"posY":837,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":555.73,"y":809,"width":56,"height":56}},{"id":"1668060505242","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":831.0000317275176,"posY":909.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":627.73,"y":884,"width":52,"height":52}},{"id":"1668060522174","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1010.0000129061089,"posY":836.9997553216862,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":806.73,"y":811,"width":52,"height":52}},{"id":"1668060535017","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999647770779,"posY":906.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":748.73,"y":881,"width":52,"height":52}},{"id":"1668060544062","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1228.9999803719595,"posY":917.9997561283179,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1025.73,"y":892,"width":52,"height":52}},{"id":"1668060551250","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1021.9999058929563,"posY":947.999753170668,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":818.73,"y":922,"width":52,"height":52}},{"id":"1668060557455","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1236.9999615505508,"posY":1105.99974510435,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1033.73,"y":1080,"width":52,"height":52}},{"id":"1668060563678","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1020.9999037419382,"posY":1052.9997026217416,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":817.73,"y":1027,"width":52,"height":52}},{"id":"1668060572236","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1028.9999618194279,"posY":1155.9997168722368,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":825.73,"y":1130,"width":52,"height":52}},{"id":"1668060578650","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999596684097,"posY":1092.9996891778783,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":748.73,"y":1067,"width":52,"height":52}},{"id":"1668060585215","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":750.9999803719595,"posY":1152.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":547.73,"y":1127,"width":52,"height":52}},{"id":"1668060594729","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":830.0000344162903,"posY":1092.99968998451,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":626.73,"y":1067,"width":52,"height":52}},{"id":"1668060603472","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":530.0000131749862,"posY":1095.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":326.73,"y":1070,"width":52,"height":52}},{"id":"1668060610498","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":755.0000938381665,"posY":1050.9997053105142,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":551.73,"y":1025,"width":52,"height":52}},{"id":"1668060616544","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":528.0000333407812,"posY":914.9997174099913,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":324.73,"y":889,"width":52,"height":52}},{"id":"1668060624038","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":754.0000943759211,"posY":947.9997539772997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":550.73,"y":922,"width":52,"height":52}},{"id":"1668060653013","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"6","labelText":"Cc","posX":890,"posY":1001,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":583.73,"y":913,"width":258,"height":176}}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"firstGIdx":"0","change_step_audio_url":"http://staging-teach.cdn.ireadabc.com/5d328902664fecfc2c17552394c29921.mp3","idle_2_audio_url":"http://staging-teach.cdn.ireadabc.com/13b05d0e777233d9fd9b661c76ebee2e.mp3","isDebug":true}
		return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3229f6873c4294acd59fb89dc7eab0aa.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/1911e3568e927257c91a8fd25d118398.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":313.64,"y":0,"width":1130.71,"height":666}},"hotZoneItemArr":[{"id":"1668059700120","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":774,"posY":221,"rect":{"x":434.36,"y":195,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1668059708822","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":840.0046289463639,"posY":286.00078101674904,"rect":{"x":500.36,"y":260,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1668059715388","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":999.0048621911851,"posY":221.00101072755757,"rect":{"x":659.4,"y":195,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1668059723401","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0054240991628,"posY":285.00078101674904,"rect":{"x":609.41,"y":259,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1668059730444","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1199.015247433881,"posY":294.00100719354515,"rect":{"x":859.42,"y":268,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1668059737547","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.026130972331,"posY":322.0010389996571,"rect":{"x":671.43,"y":296,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1668059742714","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1206.0354666133326,"posY":463.00113795200537,"rect":{"x":866.44,"y":437,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1668059747117","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1011.0461557810982,"posY":415.00163624775934,"rect":{"x":671.45,"y":389,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1668059754005","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":1017.0554666840126,"posY":508.00146661516226,"rect":{"x":677.46,"y":482,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1668059760443","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":949.0654879234274,"posY":451.0017952783191,"rect":{"x":609.47,"y":425,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1668059768151","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":767.0752476459216,"posY":505.00159383961,"rect":{"x":427.44,"y":479,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1668059772490","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":836.0846044909979,"posY":451.0017846762818,"rect":{"x":496.44,"y":425,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1668059780036","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":569.0848483378562,"posY":455.00159383961005,"rect":{"x":229.44,"y":429,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1668059786972","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0839047565349,"posY":416.0016079756598,"rect":{"x":430.44,"y":390,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1668059793504","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":567.0846150930352,"posY":293.0014701491747,"rect":{"x":227.44,"y":267,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1668059803802","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":333},"gIdx":"0","posX":770.0838976885101,"posY":321.00103546564463,"rect":{"x":430.44,"y":295,"width":52,"height":52},"linkItem":15,"pointItem":16},{"id":"1668062996049","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/8d6671efb002131453b527eeed3bf97f.json","name":"C大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/73fe384407514cdb6367e836a45cfa03.json","name":"C大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ef6a958b04c1fed3a47881a592483df7.png","name":"C大黑_tex.png"},"dragDot":{"x":879,"y":333},"gIdx":"1","posX":890,"posY":368,"rect":{"x":464.36,"y":293,"width":224,"height":150},"rectNew":17}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":177.27,"y":0,"width":1403.46,"height":1816}},"hotZoneItemArr2":[{"id":"1668060479065","index":0,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"0","posX":761,"posY":837,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":555.73,"y":809,"width":56,"height":56}},{"id":"1668060505242","index":1,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":831.0000317275176,"posY":909.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":627.73,"y":884,"width":52,"height":52}},{"id":"1668060522174","index":2,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1010.0000129061089,"posY":836.9997553216862,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":806.73,"y":811,"width":52,"height":52}},{"id":"1668060535017","index":3,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999647770779,"posY":906.9997749497267,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":748.73,"y":881,"width":52,"height":52}},{"id":"1668060544062","index":4,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1228.9999803719595,"posY":917.9997561283179,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1025.73,"y":892,"width":52,"height":52}},{"id":"1668060551250","index":5,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1021.9999058929563,"posY":947.999753170668,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":818.73,"y":922,"width":52,"height":52}},{"id":"1668060557455","index":6,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1236.9999615505508,"posY":1105.99974510435,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1033.73,"y":1080,"width":52,"height":52}},{"id":"1668060563678","index":7,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1020.9999037419382,"posY":1052.9997026217416,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":817.73,"y":1027,"width":52,"height":52}},{"id":"1668060572236","index":8,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":1028.9999618194279,"posY":1155.9997168722368,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":825.73,"y":1130,"width":52,"height":52}},{"id":"1668060578650","index":9,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":951.9999596684097,"posY":1092.9996891778783,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":748.73,"y":1067,"width":52,"height":52}},{"id":"1668060585215","index":10,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":750.9999803719595,"posY":1152.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":547.73,"y":1127,"width":52,"height":52}},{"id":"1668060594729","index":11,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":830.0000344162903,"posY":1092.99968998451,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":626.73,"y":1067,"width":52,"height":52}},{"id":"1668060603472","index":12,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":530.0000131749862,"posY":1095.9997061171462,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":326.73,"y":1070,"width":52,"height":52}},{"id":"1668060610498","index":13,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":755.0000938381665,"posY":1050.9997053105142,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":551.73,"y":1025,"width":52,"height":52}},{"id":"1668060616544","index":14,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":528.0000333407812,"posY":914.9997174099913,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":324.73,"y":889,"width":52,"height":52}},{"id":"1668060624038","index":15,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":907.9999999999999},"gIdx":"0","posX":754.0000943759211,"posY":947.9997539772997,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":550.73,"y":922,"width":52,"height":52}},{"id":"1668060653013","index":16,"itemType":"rect","fontScale":1.3734375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3734375,"dragDot":{"x":879,"y":908},"gIdx":"6","labelText":"Cc","posX":890,"posY":1001,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":583.73,"y":913,"width":258,"height":176}}],"typeArr":[{"gIdx":"0","name":"连线"},{"gIdx":"1","name":"手写"}],"firstGIdx":"0","change_step_audio_url":"http://staging-teach.cdn.ireadabc.com/5d328902664fecfc2c17552394c29921.mp3","idle_2_audio_url":"http://staging-teach.cdn.ireadabc.com/13b05d0e777233d9fd9b661c76ebee2e.mp3","isDebug":true}
		// return {"page_id":"22","book_id":"opw1","part_name":"c","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b5fb215276c7afd3779887787bce8ccb.png","rect":{"x":250.35,"y":0,"width":889.29,"height":531}},"hotZoneItemArr":[{"id":"1667901785398","index":0,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":703,"posY":266.5,"rect":{"x":419.65,"y":233.5,"width":66,"height":66},"signItem":1},{"id":"1667902509387","index":1,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":984.0050081832392,"posY":266.50027243388246,"rect":{"x":700.65,"y":233.5,"width":66,"height":66},"signItem":2},{"id":"1667902517894","index":2,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/0a7875b1266391503571437db9db3a0f.json","name":"ku_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/422a6815028fe9f40298d9c369492b96.json","name":"ku_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/19bac79724d78938de8a654d47885586.png","name":"ku_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":423.0052954399782,"posY":484.50027243388246,"rect":{"x":139.66,"y":451.5,"width":66,"height":66},"signItem":3},{"id":"1667902630462","index":3,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2add1099280b35cd2d1f42f32a2fdf40.json","name":"xiao_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/31a43a4fe41219b8d5ea2a6444ee7945.json","name":"xiao_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/5607c1521c271c88969a814c522b6039.png","name":"xiao_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":701.0052954399782,"posY":484.50027243388246,"rect":{"x":417.66,"y":451.5,"width":66,"height":66},"signItem":4},{"id":"1667902644903","index":4,"itemType":"rect","fontScale":1.0859375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.0859375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/0a7875b1266391503571437db9db3a0f.json","name":"ku_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/422a6815028fe9f40298d9c369492b96.json","name":"ku_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/19bac79724d78938de8a654d47885586.png","name":"ku_tex.png"},"dragDot":{"x":695,"y":265.5},"gIdx":"4","posX":983.0147219589887,"posY":485.5004952878651,"rect":{"x":699.66,"y":452.5,"width":66,"height":66},"signItem":5}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/8c5a7ff4254cbc7922cb79e4794729c7.png","rect":{"x":143.31,"y":0,"width":1172.38,"height":1517}},"hotZoneItemArr2":[{"id":"1667902765218","index":0,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":716,"posY":443.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":573.08,"y":429.83,"width":70.24,"height":70.24}},{"id":"1667902778386","index":1,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":1028.9949114424535,"posY":445.49812930355085,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":901.22,"y":431.93,"width":70.24,"height":70.24}},{"id":"1667902784590","index":2,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":403.99359119896144,"posY":688.4981208674902,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"cry","key":"2"},"rect":{"x":245.98,"y":686.68,"width":70.24,"height":70.24}},{"id":"1667902791896","index":3,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":716.986227510095,"posY":687.4970958861212,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"smile","key":"4"},"rect":{"x":574.12,"y":685.63,"width":70.24,"height":70.24}},{"id":"1667902798477","index":4,"itemType":"rect","fontScale":1.13984375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.13984375,"dragDot":{"x":729.5,"y":759.4147482014389},"gIdx":"8","posX":1029.9849072666034,"posY":687.4971001041515,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"dropDownItem":{"label":"cry","key":"2"},"rect":{"x":902.26,"y":685.63,"width":70.24,"height":70.24}}]}
		// return {"page_id":"13","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bg_pic_url":"http://staging-teach.cdn.ireadabc.com/103588a383dfef103f7d88081131a58b.png","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b11402c53d03d9b8966c1a5386c4d0b4.png","rect":{"x":382.88,"y":0,"width":1467.24,"height":841}},"hotZoneItemArr":[{"id":"1667284178410","index":0,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":652.5,"posY":380.5,"rect":{"x":169.62,"y":302,"width":200,"height":157},"circleItem":1},{"id":"1667285795465","index":1,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1004.5005700463794,"posY":566.4995325373978,"rect":{"x":521.62,"y":488,"width":200,"height":157},"circleItem":2},{"id":"1667285801759","index":2,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1679.500137597402,"posY":754.4993040274268,"rect":{"x":1196.62,"y":676,"width":200,"height":157},"circleItem":3}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/ef323091055c36876dfe25b5e8ed0128.png","rect":{"x":196.5,"y":0,"width":1536,"height":1987}},"hotZoneItemArr2":[{"id":"1667284877942","index":0,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":620.5,"posY":1160.5,"multRect":[{"color":"#ff0000","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20},{"color":"#00ff00","width":20,"height":20,"x":20,"y":20}],"rect":{"x":184.68,"y":904.39,"width":306.26,"height":204.23}},{"id":"1667284894146","index":1,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":988.5001409500544,"posY":1354.4996702166568,"multRect":[{"color":"#ffff00","width":20,"height":20,"x":20,"y":20},{"color":"#ffff00","width":20,"height":20,"x":20,"y":20},{"color":"#ffff00","width":20,"height":20,"x":20,"y":20}],"rect":{"x":525.99,"y":1079.53,"width":261.98,"height":190.46}},{"id":"1667284911442","index":2,"itemType":"rect","fontScale":1.50703125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.50703125,"dragDot":{"x":964.5,"y":989.551948051948},"gIdx":"7","posX":1700.5000363742076,"posY":1549.4996150869986,"multRect":[{"color":"#0000ff","width":20,"height":20,"x":20,"y":20},{"color":"#0000ff","width":20,"height":20,"x":20,"y":20}],"rect":{"x":1140.35,"y":1250.58,"width":268.3,"height":186.62}}],"isDebug":false}
		// return {"page_id":"9","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/739005c0435dcb9f32da08998711b4f9.png","rect":{"x":234.22,"y":0,"width":867.56,"height":511}},"hotZoneItemArr":[{"id":"1667887774583","index":0,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":590,"posY":170.5,"rect":{"x":336.28,"y":151,"width":39,"height":39},"linkItem":2,"pointItem":1},{"id":"1667887788202","index":1,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":638.0000145894242,"posY":221.4999681090152,"rect":{"x":384.28,"y":202,"width":39,"height":39},"linkItem":1,"pointItem":2},{"id":"1667887795720","index":2,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":761.000005611317,"posY":170.49995856977634,"rect":{"x":507.28,"y":151,"width":39,"height":39},"linkItem":4,"pointItem":3},{"id":"1667887801441","index":3,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":720.9999826049174,"posY":220.4999681090152,"rect":{"x":467.28,"y":201,"width":39,"height":39},"linkItem":3,"pointItem":4},{"id":"1667887806805","index":4,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":911.9999900866734,"posY":226.49995875682023,"rect":{"x":658.28,"y":207,"width":39,"height":39},"linkItem":6,"pointItem":5},{"id":"1667887814385","index":5,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":767.9999543612886,"posY":247.49995763455684,"rect":{"x":514.28,"y":228,"width":39,"height":39},"linkItem":5,"pointItem":6},{"id":"1667887820091","index":6,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":919.99998129561,"posY":356.499953706635,"rect":{"x":666.28,"y":337,"width":39,"height":39},"linkItem":8,"pointItem":7},{"id":"1667887826462","index":7,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":769.9999528649374,"posY":320.4999333188499,"rect":{"x":516.28,"y":301,"width":39,"height":39},"linkItem":7,"pointItem":8},{"id":"1667887833937","index":8,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":771.9999809215223,"posY":389.49994005243036,"rect":{"x":518.28,"y":370,"width":39,"height":39},"linkItem":10,"pointItem":9},{"id":"1667887840312","index":9,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":720.9999805474345,"posY":348.4999271464013,"rect":{"x":467.28,"y":329,"width":39,"height":39},"linkItem":9,"pointItem":10},{"id":"1667887846297","index":10,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":580.9999900866734,"posY":388.4999348152012,"rect":{"x":327.28,"y":369,"width":39,"height":39},"linkItem":12,"pointItem":11},{"id":"1667887879817","index":11,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":637.0000162728193,"posY":347.49992733344516,"rect":{"x":383.28,"y":328,"width":39,"height":39},"linkItem":11,"pointItem":12},{"id":"1667887885876","index":12,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":431.0000057983608,"posY":349.499935002245,"rect":{"x":177.28,"y":330,"width":39,"height":39},"linkItem":14,"pointItem":13},{"id":"1667887891550","index":13,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":584.0000443294042,"posY":320.49993462815723,"rect":{"x":330.28,"y":301,"width":39,"height":39},"linkItem":13,"pointItem":14},{"id":"1667887898232","index":14,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":429.0000157116875,"posY":226.49994005243036,"rect":{"x":175.28,"y":207,"width":39,"height":39},"linkItem":16,"pointItem":15},{"id":"1667887904615","index":15,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":255.5},"gIdx":"0","posX":585.000044703492,"posY":247.49995763455684,"rect":{"x":331.28,"y":228,"width":39,"height":39},"linkItem":15,"pointItem":16}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/587034b4ac726f8f7a3c94d2ace95ded.png","rect":{"x":129.72,"y":0,"width":1076.55,"height":1393}},"hotZoneItemArr2":[{"id":"1667887944389","index":0,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":577,"posY":643.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":424.78,"y":621,"width":45,"height":45}},{"id":"1667887960040","index":1,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":632.004792675414,"posY":698.5014661615592,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":479.78,"y":676,"width":45,"height":45}},{"id":"1667887965560","index":2,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":769.0049179883678,"posY":641.5015914745129,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":616.79,"y":619,"width":45,"height":45}},{"id":"1667887978234","index":3,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":724.0052301315435,"posY":698.5014616047245,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":571.8,"y":676,"width":45,"height":45}},{"id":"1667887985592","index":4,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":936.0151276255474,"posY":705.5015914745129,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":783.81,"y":683,"width":45,"height":45}},{"id":"1667887992372","index":5,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":779.0256106728078,"posY":728.5016074234343,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":626.82,"y":706,"width":45,"height":45}},{"id":"1667887999027","index":6,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":942.0352529840694,"posY":848.5016598270331,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":789.83,"y":826,"width":45,"height":45}},{"id":"1667888007133","index":7,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":778.0456243888804,"posY":807.501933237114,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":625.84,"y":785,"width":45,"height":45}},{"id":"1667888014504","index":8,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":784.0552507512206,"posY":886.501839822003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":631.85,"y":864,"width":45,"height":45}},{"id":"1667888022599","index":9,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":724.0652644445088,"posY":839.5020198169731,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":571.86,"y":817,"width":45,"height":45}},{"id":"1667888029229","index":10,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":570.0751277622525,"posY":884.501912731358,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":417.86,"y":862,"width":45,"height":45}},{"id":"1667888036936","index":11,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":630.084776908766,"posY":839.5020152601384,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":477.86,"y":817,"width":45,"height":45}},{"id":"1667888043743","index":12,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":401.08491361380663,"posY":842.501912731358,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":248.86,"y":820,"width":45,"height":45}},{"id":"1667888050282","index":13,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":573.0843918562354,"posY":807.50191956661,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":420.86,"y":785,"width":45,"height":45}},{"id":"1667888056672","index":14,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":399.0847837440182,"posY":702.501839822003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":246.86,"y":680,"width":45,"height":45}},{"id":"1667888064637","index":15,"itemType":"rect","fontScale":1.04375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.04375,"dragDot":{"x":668,"y":696.5},"gIdx":"0","posX":572.0843872994008,"posY":727.5016005881822,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":419.86,"y":705,"width":45,"height":45}}],"isDebug":false}
		// return {"page_id":"82","book_id":"opw3","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/48ecdccc083571a554a0393e88aa8e17.png","rect":{"x":0,"y":44.55,"width":2178,"height":731.91}},"hotZoneItemArr":[{"id":"1667527075823","index":0,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":353.49534883720935,"rect":{"x":987.5,"y":269.45,"width":79,"height":79},"circleItem":1,"signItem":1},{"id":"1667527184155","index":1,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1299,"posY":353.49534883720935,"rect":{"x":1259.5,"y":269.45,"width":79,"height":79},"circleItem":2,"signItem":2},{"id":"1667527190579","index":2,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":460.49534883720935,"rect":{"x":987.5,"y":376.45,"width":79,"height":79},"signItem":3},{"id":"1667527194988","index":3,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1300,"posY":463.49534883720935,"rect":{"x":1260.5,"y":379.45,"width":79,"height":79},"signItem":4},{"id":"1667527200554","index":4,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1028,"posY":571.4953488372093,"rect":{"x":988.5,"y":487.45,"width":79,"height":79},"signItem":5},{"id":"1667527205347","index":5,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1300,"posY":570.4953488372093,"rect":{"x":1260.5,"y":486.45,"width":79,"height":79},"signItem":6},{"id":"1667527210543","index":6,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1027,"posY":677.4953488372093,"rect":{"x":987.5,"y":593.45,"width":79,"height":79},"signItem":7},{"id":"1667527216357","index":7,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1299,"posY":678.4953488372093,"rect":{"x":1259.5,"y":594.45,"width":79,"height":79},"signItem":8},{"id":"1667527221859","index":8,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1628,"posY":355.49534883720935,"rect":{"x":1588.5,"y":271.45,"width":79,"height":79},"signItem":9},{"id":"1667527229299","index":9,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":353.49534883720935,"rect":{"x":1860.5,"y":269.45,"width":79,"height":79},"signItem":10},{"id":"1667527237415","index":10,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1627,"posY":460.49534883720935,"rect":{"x":1587.5,"y":376.45,"width":79,"height":79},"signItem":11},{"id":"1667527242936","index":11,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":461.49534883720935,"rect":{"x":1860.5,"y":377.45,"width":79,"height":79},"signItem":12},{"id":"1667527249982","index":12,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1626,"posY":569.4953488372093,"rect":{"x":1586.5,"y":485.45,"width":79,"height":79},"signItem":13},{"id":"1667527256608","index":13,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":571.4953488372093,"rect":{"x":1860.5,"y":487.45,"width":79,"height":79},"signItem":14},{"id":"1667527262126","index":14,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1627,"posY":678.4953488372093,"rect":{"x":1587.5,"y":594.45,"width":79,"height":79},"signItem":15},{"id":"1667527269087","index":15,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":410.5},"gIdx":"4","posX":1900,"posY":679.4953488372093,"rect":{"x":1860.5,"y":595.45,"width":79,"height":79},"signItem":16}],"part_name":"e","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/cdc23fe114c7fbe4ce688c5b7cdff70e.png","rect":{"x":224.98,"y":0,"width":1728.05,"height":2236}},"hotZoneItemArr2":[{"id":"1667527318185","index":0,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1068,"posY":1726,"rect":{"x":811.02,"y":1694,"width":64,"height":64}},{"id":"1667527349948","index":1,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1265.9950206411086,"posY":1725.9983039012782,"rect":{"x":1009.02,"y":1694,"width":64,"height":64}},{"id":"1667527354975","index":2,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1067.9948260712667,"posY":1803.9983039012782,"rect":{"x":811.01,"y":1772,"width":64,"height":64}},{"id":"1667527363008","index":3,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.9850206509354,"posY":1803.9982272525526,"rect":{"x":1010.01,"y":1772,"width":64,"height":64}},{"id":"1667527368695","index":4,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1068.9848250984178,"posY":1883.9982272525526,"rect":{"x":812,"y":1852,"width":64,"height":64}},{"id":"1667527374694","index":5,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.9750196780863,"posY":1882.9981486384752,"rect":{"x":1010,"y":1851,"width":64,"height":64}},{"id":"1667527380289","index":6,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1066.9748251082444,"posY":1962.998149621151,"rect":{"x":809.99,"y":1931,"width":64,"height":64}},{"id":"1667527388175","index":7,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1266.965021653265,"posY":1960.9980710070736,"rect":{"x":1009.99,"y":1929,"width":64,"height":64}},{"id":"1667527393603","index":8,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1506.964825118071,"posY":1724.9980729724255,"rect":{"x":1249.98,"y":1693,"width":64,"height":64}},{"id":"1667527399645","index":9,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.9545892856654,"posY":1724.998304883954,"rect":{"x":1448.97,"y":1693,"width":64,"height":64}},{"id":"1667527406504","index":10,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1505.9443937429746,"posY":1803.998304883954,"rect":{"x":1248.96,"y":1772,"width":64,"height":64}},{"id":"1667527414914","index":11,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.934590287995,"posY":1804.9982272525526,"rect":{"x":1448.95,"y":1773,"width":64,"height":64}},{"id":"1667527423039","index":12,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1506.924393762628,"posY":1883.9982262698766,"rect":{"x":1249.94,"y":1852,"width":64,"height":64}},{"id":"1667527431966","index":13,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.9145893249724,"posY":1883.9981486384752,"rect":{"x":1448.93,"y":1852,"width":64,"height":64}},{"id":"1667527439422","index":14,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1507.9043937822817,"posY":1962.9981486384752,"rect":{"x":1250.92,"y":1931,"width":64,"height":64}},{"id":"1667527445613","index":15,"itemType":"rect","fontScale":1.7015625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.7015625,"dragDot":{"x":1089,"y":1118},"gIdx":"8","posX":1705.8945883619504,"posY":1963.9980710070736,"rect":{"x":1448.91,"y":1932,"width":64,"height":64}}],"isDebug":false}
		return this.item = {"begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","page_id":"7","book_id":"opw1","part_name":"d","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/75bcd934bdd589d901b1d1dcf9e05e2b.png","rect":{"x":455.89,"y":0,"width":1729.22,"height":992}},"hotZoneItemArr":[{"id":"1667291729830","index":0,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":496},"gIdx":"0","posX":714.5,"posY":509,"rect":{"x":232.61,"y":483,"width":52,"height":52},"linkItem":2,"pointItem":1},{"id":"1667291758660","index":1,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":863.4985828918223,"posY":708.0011902773308,"rect":{"x":381.61,"y":682,"width":52,"height":52},"linkItem":1,"pointItem":2},{"id":"1667291766274","index":2,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1038.4989313227106,"posY":767.0016556313363,"rect":{"x":556.61,"y":741,"width":52,"height":52},"linkItem":4,"pointItem":3},{"id":"1667291773931","index":3,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1208.4993405536202,"posY":565.0017936006144,"rect":{"x":726.61,"y":539,"width":52,"height":52},"linkItem":3,"pointItem":4},{"id":"1667291781144","index":4,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1365.499738092218,"posY":554.0013212312218,"rect":{"x":883.61,"y":528,"width":52,"height":52},"linkItem":6,"pointItem":5},{"id":"1667291787620","index":5,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1519.500105230805,"posY":368.0012955081361,"rect":{"x":1037.61,"y":342,"width":52,"height":52},"linkItem":5,"pointItem":6},{"id":"1667291794068","index":6,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1697.5004653540052,"posY":452.00086055414096,"rect":{"x":1215.61,"y":426,"width":52,"height":52},"linkItem":8,"pointItem":7},{"id":"1667291799074","index":7,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1762.5008816003017,"posY":565.0010569849775,"rect":{"x":1280.61,"y":539,"width":52,"height":52},"linkItem":7,"pointItem":8},{"id":"1667291806543","index":8,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1672.501033600354,"posY":721.0013212312218,"rect":{"x":1190.61,"y":695,"width":52,"height":52},"linkItem":10,"pointItem":9},{"id":"1667291814677","index":9,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1477.5008231387435,"posY":705.0016860313468,"rect":{"x":995.61,"y":679,"width":52,"height":52},"linkItem":9,"pointItem":10},{"id":"1667291823228","index":10,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1371.5003671385873,"posY":813.0016486159494,"rect":{"x":889.61,"y":787,"width":52,"height":52},"linkItem":12,"pointItem":11},{"id":"1667291830926","index":11,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1199.5001192615794,"posY":812.0019011698821,"rect":{"x":717.61,"y":786,"width":52,"height":52},"linkItem":11,"pointItem":12},{"id":"1667291842195","index":12,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1326.4997170460567,"posY":247.00189883141968,"rect":{"x":844.61,"y":221,"width":52,"height":52},"linkItem":14,"pointItem":13},{"id":"1667291853247","index":13,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1130.500014030774,"posY":267.00057760019786,"rect":{"x":648.61,"y":241,"width":52,"height":52},"linkItem":13,"pointItem":14},{"id":"1667291861161","index":14,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":1060.4995556921554,"posY":407.00062436944467,"rect":{"x":578.61,"y":381,"width":52,"height":52},"linkItem":16,"pointItem":15},{"id":"1667291869501","index":15,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"0","posX":891.4993919997917,"posY":447.0009517541722,"rect":{"x":409.61,"y":421,"width":52,"height":52},"linkItem":15,"pointItem":16}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/71e68ebc76a7ce04eef418353d3f1844.png","rect":{"x":191.67,"y":0,"width":1499.67,"height":1940}},"hotZoneItemArr2":[{"id":"1667380287432","index":0,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":670.5,"posY":1410.5,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":277.93,"y":1022.76,"width":36.15,"height":36.15}},{"id":"1667380314762","index":1,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":827.4994456359115,"posY":1617.5012714317836,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":393.79,"y":1175.51,"width":36.15,"height":36.15}},{"id":"1667380322503","index":2,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1007.4995871564998,"posY":1680.5014580226232,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":526.61,"y":1222,"width":36.15,"height":36.15}},{"id":"1667380329891","index":3,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1185.4997494094036,"posY":1470.5015148111395,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":657.96,"y":1067.03,"width":36.15,"height":36.15}},{"id":"1667380339099","index":4,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1346.4999098594978,"posY":1458.5013255160848,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":776.77,"y":1058.18,"width":36.15,"height":36.15}},{"id":"1667380346091","index":5,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1507.5000549857066,"posY":1264.5013146992246,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":895.57,"y":915.02,"width":36.15,"height":36.15}},{"id":"1667380353829","index":6,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1690.500200111915,"posY":1351.5011398266504,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1030.61,"y":979.22,"width":36.15,"height":36.15}},{"id":"1667380360920","index":7,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1756.500365069034,"posY":1469.5012182488872,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight","value":true}]},"rect":{"x":1079.31,"y":1066.3,"width":36.15,"height":36.15}},{"id":"1667380368760","index":8,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1664.5004245617654,"posY":1629.5013246146798,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":1011.42,"y":1184.36,"width":36.15,"height":36.15}},{"id":"1667380374561","index":9,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1462.5003416325035,"posY":1613.5014688394833,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":862.36,"y":1172.56,"width":36.15,"height":36.15}},{"id":"1667380381923","index":10,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1350.500159548689,"posY":1725.501454417003,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":779.72,"y":1255.2,"width":36.15,"height":36.15}},{"id":"1667380387739","index":11,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1174.5000585913265,"posY":1723.5015553743654,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":649.84,"y":1253.73,"width":36.15,"height":36.15}},{"id":"1667380395200","index":12,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1306.4998999440427,"posY":1140.5015535715554,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":747.24,"y":823.52,"width":36.15,"height":36.15}},{"id":"1667380402254","index":13,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1101.5000189295056,"posY":1160.5010280524275,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":595.97,"y":838.28,"width":36.15,"height":36.15}},{"id":"1667380408975","index":14,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":1028.499834141476,"posY":1304.501046080528,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":542.1,"y":944.53,"width":36.15,"height":36.15}},{"id":"1667380417184","index":15,"itemType":"rect","fontScale":1.47109375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.47109375,"dragDot":{"x":941.5,"y":962.739595488137},"gIdx":"0","posX":853.4997683389092,"posY":1346.5011758828512,"checkbox":{"title":"答案","list":[{"label":"正确","key":"isRight"}]},"rect":{"x":412.97,"y":975.53,"width":36.15,"height":36.15}}],"isDebug":true}
	
	},

	preload() {
		const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
		console.log(' in preload preloadArr: ', preloadArr);
		cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {
			console.log(' preload data, ', data);


			this.addServerListener();
			// if (window && window["air"]) {
			// 	window["air"].hideAirClassLoading();
			// }
		});
	},

	addServerListener() {
		
		if (window && window["air"]) {
			// cc.find('Canvas').opacity = 0;
			// window.air.onCourseInScreen = (next) => {
			// 	//  cc.find('Canvas').opacity = 255;
			// 	this.loadEnd();
			// 	next();
			// }
			this.loadEnd();
			window.air.hideAirClassLoading();
		} else {
			this.loadEnd();
		}


		if (window.air) {

			window.air.osmoHandwritingCallback = (data) => {

				if (!data) {
					console.log('data is not exist!!!');
					return;
				}

				console.log('osmoHandwritingCallback data: ', data);

				if (typeof (data) == 'string') {
					console.log('data is string ');
					const dataObj = JSON.parse(data);

					this.photoEnd(dataObj);
					return;
				}

				// 哲学逻辑
				this.photoEnd(data);

			}

			
		}

	},

	addPreloadImage() {
	
		if (this.data.bg_pic_url) {
			this._imageResList.push({ url: this.data.bg_pic_url || ''});
		}

		if (this.data.bgItem) {
			this._imageResList.push({ url: this.data.bgItem.url || ''});
		}

		if (this.data.bgItem2) {
			this._imageResList.push({ url: this.data.bgItem2.url || ''});
		}

		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.pic_url) {
				this._imageResList.push({ url: item.pic_url || ''});
			}
		})
	},

	addPreloadAudio() {

		if (this.data.questionArr) {
			const arr = this.data.questionArr;
			for (let i=0 ;i<arr.length; i++) {
				this._audioResList.push({url: arr[i].audio_url || ''});
				this._audioResList.push({url: arr[i].video_url || ''});
			}
		}

	},

	addPreloadAnima() {
		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.skeJsonData) {
				this._animaResList.push({ url: item.skeJsonData.url || '' });
				this._animaResList.push({ url: item.texJsonData.url || ''});
				this._animaResList.push({ url: item.texPngData.url || ''});
			}
		})
	},

	loadEnd() {
		console.log(' in loadEnd');

		// this.data.isDebug = true;

		this.initData();
		this.initView();
		// this.initMusic();

		// this.startTesting();

		// cc.debug.setDisplayStats(true);

	},

	initMusic() {
		cc.assetManager.loadRemote(this.data.bg_audio_url, (err, clip) => {
			cc.audioEngine.setMusicVolume(0.3);
			const audioID = cc.audioEngine.playMusic(clip, true);
		});
	},

	curGroupIndex: null,
	curQuestionIndex: null,
	curQuestionData: null,

	picNodeArr: null,


	firstItemData: null,
	bottomItemData: null,
	animaNodeArr: null,
	circleAnimaNodeArr: null,
	signAnimaNodeArr: null,

	initData() {
		console.log(' in initData');

		// this.curGroupIndex = 0;
		// this.curQuestionIndex = 0;
		// this.setCurGroupAndQuestion()

		// console.log('this.curQuestionData', this.curQuestionData)

		this.CHECK_TYPE_LINE = 'LINE';
		this.CHECK_TYPE_WRITE = 'WRITE';
		this.CHECK_TYPE_CIRCLE = 'CIRCLE';
		this.CHECK_TYPE_SIGN = 'SIGN';



		this.totalLineArr = [];
		this.rectNodeArr = [];

		this.animaNodeArr = [];

		this.circleAnimaNodeArr = [];
		this.signAnimaNodeArr = [];

		this.picNodeArr = [];
		this.initAudioEffect();

		this.linkRectGroup = [];

		this.centerItemArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '1');
		this.benchmark1Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '3')[0];
		this.benchmark2Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '4')[0];
		this.firstItemData = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '5')[0];

		this.lineRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '0');
		this.newRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '6');
		this.circleRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '7');
		this.signRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '8');


		if (this.benchmark1Data) {
			this.initCheckBase();
		} 

		this.initTypeArr();
	},

	initTypeArr() {
		const typeArr = this.data.typeArr;
		
		console.log('this.data.typeArr: ', this.data);

		if (!this.data.firstGIdx) {
			this.data.firstGIdx = typeArr[0].gIdx;
		}

		this.typeArr = [];
		const firstType = typeArr.find((t) => {
			return t.gIdx == this.data.firstGIdx;
		})

		const index = typeArr.indexOf(firstType);
		typeArr.splice(index, 1);

		this.typeArr = [firstType];
		this.typeArr = this.typeArr.concat(typeArr)
		this.typeArrIndex = 0;

		console.log("this.typeArr: ", this.typeArr);
	},

	initCheckBase() {


		console.log('benchmark1Data: ', this.benchmark1Data);
		console.log('benchmark2Data: ', this.benchmark2Data);
		console.log('centerItemArr: ', this.centerItemArr);

		const benchmark1Rect = this.benchmark1Data.rect;
		const benchmark2Rect = this.benchmark2Data.rect;
		
		const benchmark1CenterY = (benchmark1Rect.y + benchmark1Rect.height / 2);
		const benchmark2CenterY = (benchmark2Rect.y + benchmark2Rect.height / 2);
		
		let unitH = benchmark2CenterY - benchmark1CenterY;
		let unitW = benchmark2Rect.x + benchmark2Rect.width - benchmark1Rect.x;
		let baseX = benchmark1Rect.x;
		let baseY = benchmark1CenterY;


		if (this.firstItemData) {
			const firstItemRect = this.firstItemData.rect;
			baseX = firstItemRect.x + firstItemRect.width / 2;
			baseY = firstItemRect.y + firstItemRect.height / 2;
			unitW = benchmark1Rect.x + benchmark1Rect.width - (firstItemRect.x + firstItemRect.width / 2);
			unitH = (firstItemRect.y + firstItemRect.height / 2) - benchmark1CenterY;
		}


		for(let i=0; i<this.centerItemArr.length; i++) {

			const itemRect = this.centerItemArr[i].rect;
			const x = itemRect.x + itemRect.width / 2;
			const y = itemRect.y + itemRect.height / 2;

			const unitX = (x - baseX) / unitW;
			const unitY = (y - baseY) / unitH;
			const unitW2 = itemRect.width / unitW;
			const unitH2 = itemRect.height / unitH;


			this.centerItemArr[i].unitX = unitX;
			this.centerItemArr[i].unitY = unitY;
			this.centerItemArr[i].unitW = unitW2;
			this.centerItemArr[i].unitH = unitH2;

			// console.log('unitX: ', unitX)
			// console.log('unitY: ', unitY)
		}

		console.log('unitH: ', unitH)
		console.log('unitW: ', unitW)
		console.log('baseX: ', baseX)
		console.log('baseY: ', baseY)

	
		const centerX = this.data.bgItem2.rect.width / 2;
		this.centerUnitW = (centerX - baseX) / unitW;



	},

	getGroupArrByGIdx(arr, gIdx) {
		const groupArr = [];
		for (let i=0; i<arr.length; i++) {
			if (arr[i].gIdx == gIdx) {

				const data = JSON.parse(JSON.stringify(arr[i]));
				groupArr.push(data);
			}
		}

		return groupArr;
	},

	curGroup: null,
	setCurGroupAndQuestion() {
		this.curGroup = this.data.groupArr[this.curGroupIndex];

		if (!this.curGroup) {
			this.gameEnd();
		} else {
			this.curQuestionIndex = 0;
			this.setCurQuestionData();
		}
	},

	setCurQuestionData() {
		this.curQuestionData = this.curGroup.questionArr[this.curQuestionIndex];

		if (!this.curQuestionData) {

			this.hideVideo();
			this.showBigStar();
		}
	},

	hideVideo() {
		this.videoNode.active = false;

		this.videoNode.player.pause();
		this.videoNode.pauseBtn.active = false;
		this.videoNode.playBtn.active = true;
	},


	rightClip: null,
	wrongClip: null,
	bigStarClip: null,
	btnClip: null,
	finishClip: null,
	selectClip: null,
	starCountClip: null,
	initAudioEffect() {
		this.rightClip = cc.find('Canvas/res/audio/right').getComponent(cc.AudioSource).clip;
		this.wrongClip = cc.find('Canvas/res/audio/wrong').getComponent(cc.AudioSource).clip;
		this.bigStarClip = cc.find('Canvas/res/audio/big_star').getComponent(cc.AudioSource).clip;
		this.btnClip = cc.find('Canvas/res/audio/btn').getComponent(cc.AudioSource).clip;
		this.finishClip = cc.find('Canvas/res/audio/finish').getComponent(cc.AudioSource).clip;
		this.selectClip = cc.find('Canvas/res/audio/select').getComponent(cc.AudioSource).clip;
		this.starCountClip = cc.find('Canvas/res/audio/star_count').getComponent(cc.AudioSource).clip;
	},



	initView() {

		console.log(' in initView');

		this.initBg();
		this.initHotZone();
		this.initDebugLayer();

		console.log(' in initView 2');

	
		this.initCat();
	
	},


	initCat() {

		const cat = cc.find("Canvas/catNode/cat")
		cat.parent.zIndex = 10;
		this.cat = cat;

		this.canTouch = false;
		this.playCatAudio(this.data.begin_audio_url, () => {
			this.canTouch = true;
			// this.isPanelMoveEnd = true;

			this.catBeginEnd = true;
			this.checkStart();
		});

		this.curCatAudioUrl = this.data.idle_audio_url;

		const clickBox = cc.find("Canvas/catNode/clickBox")
		clickBox.on('touchstart', () => {

			console.log(' in cat touchstart')

			let url = this.curCatAudioUrl;
			if (!url) {
				return;
			}
 
			if (!this.canTouch) {
				return;
			}
			
			this.canTouch = false;

			this.playCatAudio(url, () => {
				this.canTouch = true;
			})

		})
	},

	playCatAudio(audioUrl, cb=null) {

		console.log('_ playCatAudio:  ', audioUrl);

		if (this.curCatAudioId) {
			cc.audioEngine.pauseEffect(this.curCatAudioId);
		}

		if (audioUrl) {

			this.playCatAnim('begin');
			playAudioByUrl(audioUrl, () => {
				this.playCatAnim('normal');
				cb && cb();
			})
		} else {
			cb && cb();

		}
		
	},

	playCatAnim(name, times = 0) {
		const cat = cc.find("Canvas/catNode/cat")		
		var dragonDisplay = cat.getComponent(dragonBones.ArmatureDisplay);
		const state = dragonDisplay.playAnimation(name, times);
	},
	


	initTestPointArr() {
		
		const linkeItemArr = this.data.hotZoneItemArr.filter(hzItem => {
			return hzItem.gIdx == '0';
		})

		const bgRect = this.data.bgItem2.rect;

		const setDebugCenterPos = (hzItem) => {

			const debugItemIndex = (Number(hzItem.pointItem) - 1) 
			const debugItem = this.data.hotZoneItemArr2[debugItemIndex];
			const {rect} = debugItem

			const left = Math.round( (rect.x ) / bgRect.width  * 1000 ) / 1000;
			const right =  Math.round( (rect.x + rect.width) / bgRect.width * 1000 ) / 1000;
			const top =  Math.round( (rect.y ) / bgRect.height * 1000 ) / 1000;
			const bottom =  Math.round( (rect.y + rect.height) / bgRect.height * 1000 ) / 1000;
	
			
			const x = left + (right - left) / 2;
			const y = bottom - (bottom - top) / 2;

			hzItem.debugCenterPos = [x, y];
		}

		console.log('linkeItemArr: ', linkeItemArr);

		linkeItemArr.forEach(hzItem => {
			return setDebugCenterPos(hzItem);
		})

		const startPosObj = {};
		const endPosObj = {};

		for (let i=0; i<linkeItemArr.length; i++) {
			const index = this.data.hotZoneItemArr.indexOf(linkeItemArr[i]);
			const key = (index + 1).toString();
			if (!startPosObj[key] && !endPosObj[key]) {
				startPosObj[key] = linkeItemArr[i];


				const endKey = linkeItemArr[i].linkItem.toString();
				const endIndex = Number(endKey) - 1;
				const endItem = this.data.hotZoneItemArr[endIndex];
				endPosObj[endKey] = endItem;
			}
		}

		console.log('startPosObj: ', startPosObj);
		console.log('endPosObj: ', endPosObj);

		
		console.log('this.end_points: ', this.end_points);

	
	},

	checkStart() {

		console.log(' in checkStart')
		if (this.debugBgImg && this.hzLoadEnd && this.catBeginEnd) {
			this.startTesting();
		}

	},

	getSendCirclePoints(tempCirclePointArr) {

		console.log('tempCirclePointArr: ' , tempCirclePointArr);


		
		const sendCirclePointArr = [];

		for (let i=0; i<tempCirclePointArr.length; i++) {
			const {left, top, right, bottom} = tempCirclePointArr[i];

			const newLeft = left + (right - left) / 2;
			const newTop = top + (bottom - top) / 2;
			const data = {
				left: newLeft,
				right: newLeft,
				top: newTop,
				bottom: newTop
			}

			sendCirclePointArr.push(data);
			// const tempLink1 = tempCirclePointArr[i];
			// const key2 = tempLink1.linkItem;
			// const tempLink2 = tempCirclePointArr[Number(key2)-1];

			// if (!tempLink1.isGetLinked && !tempLink2.isGetLinked) {
			// 	tempLink1.isGetLinked = true;
			// 	tempLink2.isGetLinked = true;

			// 	const pKey1 = tempLink1.pointItem;
			// 	const pKey2 = tempLink2.pointItem;

			// 	const pointItem1 = this.data.hotZoneItemArr2[Number(pKey1) - 1];
			// 	const pointItem2 = this.data.hotZoneItemArr2[Number(pKey2) - 1];

			// 	const region1 = this.getRegionByRect(pointItem1.rect, bgRect);
			// 	const region2 = this.getRegionByRect(pointItem2.rect, bgRect);

			// 	let x1 = region1.left + (region1.right - region1.left) / 2;
			// 	let y1 = region1.top + (region1.bottom - region1.top) / 2;

			// 	let x2 = region2.left + (region2.right - region2.left) / 2;
			// 	let y2 = region2.top + (region2.bottom - region2.top) / 2;

			// 	x1 = Math.floor(x1 * 1000) / 1000;
			// 	y1 = Math.floor(y1 * 1000) / 1000;
			// 	x2 = Math.floor(x2 * 1000) / 1000;
			// 	y2 = Math.floor(y2 * 1000) / 1000;

			// 	sendCirclePointArr.push( {left:x1, top: y1, right:x2, bottom: y2} )
			// }
		}

		console.log("sendCirclePointArr: ", sendCirclePointArr);
		return sendCirclePointArr;
	},


	getSendLinePoints() {

		const hotZoneItemArr = JSON.parse( JSON.stringify(this.data.hotZoneItemArr) );

		const tempLinkArr = this.getGroupArrByGIdx(hotZoneItemArr, '0');

		console.log('tempLinkArr: ' , tempLinkArr);

		const bgRect = this.data.bgItem2.rect;
		
		const sendLinkPointArr = [];


		for (let i=0; i<tempLinkArr.length; i++) {
			const tempLink1 = tempLinkArr[i];
			const key2 = tempLink1.linkItem;
			const tempLink2 = hotZoneItemArr[Number(key2)-1];

			if (!tempLink1.isGetLinked && !tempLink2.isGetLinked) {
				tempLink1.isGetLinked = true;
				tempLink2.isGetLinked = true;

				const pKey1 = tempLink1.pointItem;
				const pKey2 = tempLink2.pointItem;

				const pointItem1 = this.data.hotZoneItemArr2[Number(pKey1) - 1];
				const pointItem2 = this.data.hotZoneItemArr2[Number(pKey2) - 1];

				const region1 = this.getRegionByRect(pointItem1.rect, bgRect);
				const region2 = this.getRegionByRect(pointItem2.rect, bgRect);

				let x1 = region1.left + (region1.right - region1.left) / 2;
				let y1 = region1.top + (region1.bottom - region1.top) / 2;

				let x2 = region2.left + (region2.right - region2.left) / 2;
				let y2 = region2.top + (region2.bottom - region2.top) / 2;

				x1 = Math.floor(x1 * 1000) / 1000;
				y1 = Math.floor(y1 * 1000) / 1000;
				x2 = Math.floor(x2 * 1000) / 1000;
				y2 = Math.floor(y2 * 1000) / 1000;

				sendLinkPointArr.push( {left:x1, top: y1, right:x2, bottom: y2} )
			}
		}

		console.log("sendLinkPointArr: ", sendLinkPointArr);
		return sendLinkPointArr;

		// for (let i=0; i<regions.length; i++) {
		// 	const oneRegion = regions[i];
		// 	console.log('oneRegion: ', oneRegion);
		// 	const x = oneRegion.left + (oneRegion.right - oneRegion.left) / 2;
		// 	const y = oneRegion.top + (oneRegion.bottom - oneRegion.top) / 2;
		// }
	},


	//调起检测
	startTesting() {

		this.isGameEnd = false;


		const writeRegions = this.getRegionsByGidx('6')
		const circleRegions = this.getRegionsByGidx('7')
		const signRegions = this.getRegionsByGidx('8')

		// this.changeRegionTo4Pos(signRegions);


		// let lineRegions = this.getRegionsByGidx('0')

		const newPoints = this.getSendLinePoints();
		const newCirclePoints = this.getSendCirclePoints(circleRegions);

		console.log('writeRegions: ', writeRegions);
		console.log('circleRegions: ', circleRegions);
		console.log('newPoints: ', newPoints);
		console.log('signRegions: ', JSON.stringify(signRegions));
		console.log('newCirclePoints: ', newCirclePoints);

		

	 

		// const tempType = this.typeArr[this.typeArrIndex];
		// this.curCheckType = '';
		// switch(tempType.gIdx) {
		// 	case "0":
		// 		// 连线
		// 		this.curCheckGroup = this.CHECK_TYPE_LINE;
		// 		break;

		// 	case "1":
		// 		// 手写
		// 		this.curCheckGroup = this.CHECK_TYPE_WRITE;
		// 		break;

		// 	case "2":
		// 		// 画圈
		// 		this.curCheckGroup = this.CHECK_TYPE_CIRCLE;
		// 		break;

		// 	case "4":
		// 		// 符号
		// 		this.curCheckGroup = this.CHECK_TYPE_SIGN;
		// 		break;
		// 	}

		// 	// setInterval(() => {
		// 		this.getPhotoData((data) => { 
		// 			this.photoEnd(data);
		// 		});    
		// 	// }, 3000);

		// 	console.log('curCheckGroup: ', JSON.stringify( this.curCheckGroup ));

		// return;





		// write_regions : []

		let lineType = 1;
		let circleSize = 1;

		if (this.data.lineType == '0') {
			lineType = 0;
		}
		if (this.data.circleSize == '0') {
			circleSize = 0;
		}
		
		

		const para = {
			"library_id": "iplayabc",
			"page_id": this.data.page_id, //27,
			"book_id": this.data.book_id,//"opw1",
			"part_name": this.data.part_name, //"d",
		
			"write_regions": [],
			"circle_regions": [],//circleRegions,
			"line_regions": [],
			'sign_regions': [],
			
			lineType,
			circleSize
		}

		const curCheckGroup = this.typeArr[this.typeArrIndex];
		this.curCheckType = '';
		switch(curCheckGroup.gIdx) {
			case "0":
				// 连线
				para.line_regions = newPoints;
				this.curCheckGroup = this.CHECK_TYPE_LINE;
				break;

			case "1":
				// 手写
				para.write_regions = writeRegions;
				this.curCheckGroup = this.CHECK_TYPE_WRITE;
				break;

			case "2":
				// 画圈
				para.circle_regions = newCirclePoints;
				this.curCheckGroup = this.CHECK_TYPE_CIRCLE;
				break;

			case "4":
				// 符号
				para.sign_regions = signRegions;
				this.curCheckGroup = this.CHECK_TYPE_SIGN;
				break;
				
		}


		console.log('curCheckGroup: ', JSON.stringify( this.curCheckGroup ));
		console.log('para: ', JSON.stringify( para ));


		const cw = window.courseware;
		if (!cw || !cw.openOsmoHandwriting) {

			console.log('cw.openOsmoHandwriting not exist');
			return;
		}

		cw.openOsmoHandwriting(para);


	},

	//结束检测
	endTesting() {
		
		const cw = window.courseware;
		if (!cw || !cw.closeOsmoHandwriting) {

			return;
		}
		cw.closeOsmoHandwriting();


		// const cw = window.courseware;
		// if (!cw || !cw.closeOsmoHandwritingMlkit) {

		// 	return;
		// }
		// cw.closeOsmoHandwritingMlkit();
		// // this.isTesting = false;
	},

	changeRegionTo4Pos(regions) {

		for (let i=0; i<regions.length; i++) {
			const {left, top, right, bottom} = regions[i];
			regions[i] = [

					left, top,
					right, top,
					right, bottom,
					left, bottom

			]
		}
		
	},

	getRegionsByGidx(gIdx) {

		const arr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, gIdx);
		const bgRect = this.data.bgItem2.rect;
		
		console.log("arr:", arr);
		const newLocationArr = [];
		for (let i=0; i<arr.length; i++) {

			const hzItem = arr[i];
			const regionRect = hzItem.rect;

			const region = this.getRegionByRect(regionRect, bgRect);

			newLocationArr.push(region)
		}

		return newLocationArr;

	},

	getRegionByRect(regionRect, bgRect) {

		const left = Math.round( (regionRect.x ) / bgRect.width  * 1000 ) / 1000;
		const right =  Math.round( (regionRect.x + regionRect.width) / bgRect.width * 1000 ) / 1000;
		const top =  Math.round( (regionRect.y ) / bgRect.height * 1000 ) / 1000;
		const bottom =  Math.round( (regionRect.y + regionRect.height) / bgRect.height * 1000 ) / 1000;

		return {left, top, right, bottom};
	},



	changeWriteData(result) {
		const curTextArr = result.text;
		const bboxTextArr = [];
		for (let i=0; i<curTextArr.length; i++) {

			const score = curTextArr[i].score;

			const {left, right, top, bottom} = curTextArr[i];
			const text = curTextArr[i].content;

			console.log('text..', JSON.stringify( curTextArr[i] ));
			console.log('text..', text);
			const disW = (right - left) / text.length;
			const disH = (bottom - top);
			for (let j=0; j<text.length; j++) {

				const x1 = left + j * disW;
				const y1 = top;

				const x2 = x1 + disW;
				const y2 = y1;

				const x3 = x2;
				const y3 = y2 + disH;

				const x4 = x1;
				const y4 = y3;

				// const bbox = [{x1, y1}, {x2, y2}, {x3, y3}, {x4, y4}]
				const bbox = {left: x1, right: x2, top: y1, bottom: y3}


				// this.changeBboxPos(bbox);

				const content = text[j];
				bboxTextArr.push({bbox, content, score});
			}

		}

		result.text = bboxTextArr;

	},


	locate(x1, y1, x2, y2, x3, y3) {
			var a, b;
			a = (y2 - y1) / (x2 - x1);
			b = y1 - a * x1;

			var xMiddle = (x1 + x2) / 2;
			var yMiddle = (y1 + y2) / 2;
			var c, lastX, lastY;
			if (a != 0) {
					c = yMiddle - (-1 / a) * xMiddle;
					lastX = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) - 2 * c * y1 + 2 * c * y3) / (2 * ((x1 - x3) - (1 / a) * (y1 - y3)));
					lastY = (-1 / a) * lastX + c;
			} else {
					lastX = c = xMiddle;
					lastY = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) + 2 * lastX * (x3 - x1)) / (2 * (y1 - y3));
			}
			console.log("定位点X坐标: " + lastX);
			console.log("定位点Y坐标: " + lastY);

			return {x: lastX, y: lastY};
	},

	

	setOneAnswerDataCircle(colorRect, answerData) {
		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);


		// const targetLabelText = colorRect.labelText;

		// const newRectCheckArr = this.newRectCheckArr;
		const checkArr = this.circleRectCheckArr;

		for (let i=0; i<checkArr.length; i++) {

			const checkRect = checkArr[i].ccRect;
			const key = checkArr[i].data.index + 1;

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (checkRect.contains(dotV2)) {

				answerData[key] = {isFinish: true};

			}

		}

	},


	setOneAnswerDataLink(firstPos, lastPos, answerData) {


		const w = this.debugLayer.width;
    const h = this.debugLayer.height;
    const checkP1 = cc.v2(firstPos.x * w, -firstPos.y * h);
    const checkP2 = cc.v2(lastPos.x * w, -lastPos.y * h);



		let firstPosRectId = -1;
		let lastPosRectId = -1;

		const worldPos1 = this.debugLayer.convertToWorldSpaceAR(cc.v2(checkP1.x, checkP1.y));
		const worldPos2 = this.debugLayer.convertToWorldSpaceAR(cc.v2(checkP2.x, checkP2.y));


		// console.log('worldPos1: ', JSON.stringify(worldPos1));
		// console.log('worldPos2: ', JSON.stringify(worldPos2));

		for (let i=0; i<this.linkRectGroup.length; i++) {
			const rect = this.linkRectGroup[i].ccRect;

			// console.log('rect: ', JSON.stringify(rect));


      if (rect.contains(worldPos1)) {
        firstPosRectId = i;
        // break;
			} 
      if (rect.contains(worldPos2)) {
        lastPosRectId = i;
        // break;
			} 
		}

		console.log('firstPosRectId: ', firstPosRectId);
		console.log('lastPosRectId: ', lastPosRectId);

		if (firstPosRectId != -1 && lastPosRectId != -1 && firstPosRectId != lastPosRectId) {

      answerData[firstPosRectId.toString()] = [firstPosRectId, lastPosRectId];
      this.addDebugLayerDot(checkP1.x, checkP1.y, 10, cc.Color.GREEN);
      this.addDebugLayerDot(checkP2.x, checkP2.y, 10, cc.Color.GREEN);
    }

	},

	addDebugLayerDot(x, y, r=10, color = null) {
    const dotNode = new cc.Node();

    const ctx = dotNode.addComponent(cc.Graphics);
    ctx.fillColor = color || cc.Color.BLUE;
    ctx.circle(x, y, r);
    ctx.fill();

    this.debugDrawLayer.addChild(dotNode);

    const w = this.debugLayer.width;
    const h = this.debugLayer.height;
    const rateX = x / w;
    const rateY = y / h;
    
    console.log('ratePos: {x: ' + rateX + ', y: ' + rateY + '}')
  },

	photoEndLineRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}



		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const points = oneTextData.points;

			const point1_x = points[0];
			const point1_y = points[1];
			const point2_x = points[2];
			const point2_y = points[3];

			// const rect1 = {
			// 	x:point1_x,
			// 	y: -point1_y,
			// 	width: 0.01,
			// 	height: 0.01
			// }

			// const colorRect1 = this.getColorDot(rect1.x, rect1.y, rect1.width, rect1.height, "purple");
			// this.debugDrawLayer.addChild(colorRect1, 1);
		

			// const rect2 = {
			// 	x:point2_x,
			// 	y: -point2_y,
			// 	width: 0.01,
			// 	height: 0.01
			// }

			// const colorRect2 = this.getColorDot(rect2.x, rect2.y, rect1.width, rect1.height, "purple");
			// this.debugDrawLayer.addChild(colorRect2, 1);

			this.drawUserLine([{x:point1_x, y: point1_y}, {x: point2_x, y: point2_y}]);

			this.setOneAnswerDataLink({x:point1_x, y: point1_y}, {x: point2_x, y: point2_y}, answerData);
		}


		this.showLinkAnswer(answerData);
	},

	drawUserLine(path) {
		this.drawOnePath(path);
	},

	drawOnePath(path) {
    const lineNode = new cc.Node();
    this.debugDrawLayer.addChild(lineNode);

    const w = this.debugLayer.width;
    const h = this.debugLayer.height;



    const subY = 0; //-canvas.height / 2;
    const ctx = lineNode.addComponent(cc.Graphics);
    ctx.lineWidth = 10;
    ctx.strokeColor = cc.Color.RED;
    ctx.fillColor = cc.Color.BLACK;
    

    ctx.moveTo(path[0].x * w, -path[0].y * h + subY);

    for (let i = 1; i < path.length; i++) {
      const x = path[i].x * w;
      const y = -path[i].y * h + subY;

      ctx.lineTo(x, y);
    }
    ctx.stroke();
  },

	showLinkAnswer(answerData) {

    for (let key in answerData) {

      const tempArr = answerData[key];

      const firstItemIndex = tempArr[0];
      const lastItemIndex = tempArr[1];

			const debugFirstItem = this.linkRectGroup[firstItemIndex];
			const debugLastItem = this.linkRectGroup[lastItemIndex];

			console.log('linkdebugId: ', debugFirstItem.linkData.linkDebugItemId);
			console.log('debugLastItem.linkData.debugItemId: ', debugLastItem.linkData.debugItemId)
			console.log('debugFirstItem.isRightPoint: ', debugFirstItem.isRightPoint)

			const hzItemIdFirst = debugFirstItem.linkData.hzItemId
			const hzItemIdLast = debugLastItem.linkData.hzItemId
			const startItem = this.getItemById(hzItemIdFirst);
			const endItem = this.getItemById(hzItemIdLast);
			if (startItem.isShowEnd || endItem.isShowEnd) {
				return;
			}

			if ((startItem.isRightPoint && endItem.isRightPoint) && debugFirstItem.linkData.linkDebugItemId == debugLastItem.linkData.debugItemId) {
				
				const {hzItemId, linkHzItemId} = debugFirstItem.linkData
				this.showSuccess(hzItemId, linkHzItemId);

			} else {			

			}

    }


		// for (let key in answerData) {

    //   const tempArr = answerData[key];

    //   const firstItemIndex = tempArr[0];
    //   const lastItemIndex = tempArr[1];

		// 	const debugFirstItem = this.linkRectGroup[firstItemIndex];
		// 	const debugLastItem = this.linkRectGroup[lastItemIndex];

		// 	console.log('linkdebugId: ', debugFirstItem.linkData.linkDebugItemId);
		// 	console.log('debugLastItem.linkData.debugItemId: ', debugLastItem.linkData.debugItemId)
		// 	console.log('debugFirstItem.isRightPoint: ', debugFirstItem.isRightPoint)

		// 	const hzItemIdFirst = debugFirstItem.linkData.hzItemId
		// 	const hzItemIdLast = debugLastItem.linkData.hzItemId
		// 	const startItem = this.getItemById(hzItemIdFirst);
		// 	const endItem = this.getItemById(hzItemIdLast);
		// 	if (startItem.isShowEnd || endItem.isShowEnd) {
		// 		return;
		// 	}

		// 	if (debugFirstItem.isRightPoint && debugFirstItem.linkData.linkDebugItemId == debugLastItem.linkData.debugItemId) {
				
		// 		// const {hzItemId, linkHzItemId} = debugFirstItem.linkData
		// 		// this.showSuccess(hzItemId, linkHzItemId);

		// 	} else {			

				
		// 		this.showFail(hzItemIdFirst, hzItemIdLast);
		// 		this.playCatAudio(this.data.error_link_audio_url);

		// 	}

    // }


  },

	showSuccess(startItemId, endItemId) {

		console.log( ' in showSuccess');

		const startItem = this.getItemById(startItemId);
		const endItem = this.getItemById(endItemId);

		if (startItem.isShowEnd || endItem.isShowEnd) {
			return;
		}
		startItem.isShowEnd = true;
		endItem.isShowEnd = true;

		const isLinked = this.checkIsLinked(startItem, endItem);
		if (isLinked) {
			return;
		}

		this.addLinkItem(startItem, endItem);
		this.addLinkItem(endItem, startItem);




		const pos1 = startItem.getPosition();
		pos1.x += startItem.width / 2;
		pos1.y += startItem.height / 2;
		const pos2 = endItem.getPosition();
		pos2.x += endItem.width / 2;
		pos2.y += endItem.height / 2;

		const greenColor = new cc.Color();
		greenColor.fromHEX("#519F00"); 
		const line = this.getLine(pos1, pos2, greenColor);
		this.addLinkLine(startItem, endItem, line);
		line.isRight = true;

		const maskNode = new cc.Node();
		maskNode.width = 0;
		maskNode.height = 0;
		maskNode.x = pos1.x;
		maskNode.y = pos1.y;
		this.hotZoneBg.addChild(maskNode);


		const mask = maskNode.addComponent(cc.Mask);
		mask.type = cc.Mask.Type.ELLIPSE;
		mask.segments = 32;

		maskNode.addChild(line);
		// line.mask = mask;

		this.isCurLinked = true;

		cc.tween(maskNode)
			.to(1.5, {width: this.canvas.width * 2, height: this.canvas.height * 2}, {easing: 'sineOut'})
			.call(() => {
				maskNode.removeComponent(cc.Mask);
			})
			.start();
		
		playAudio(this.rightClip, () => {
			
		})
		
		if (!this.isGameEnd) {
			const arr = this.rectNodeArr.filter((r) => {
				return r.isRightPoint == true;
			})
			this.checkGameEnd(arr);
		}
	},

	addLinkLine(item1, item2, line) {
		if ( !item1.lineArr ) {
			item1.lineArr = [];
		}

		if (!item2.lineArr) {
			item2.lineArr = [];
		}
		
		item1.lineArr.push(line);
		item2.lineArr.push(line);
		line.itemArr = [item1, item2];
		this.totalLineArr.push(line);
	},

	checkIsLinked(startItem, endItem) {
		const linkItemArr1 = startItem.linkItemArr || [];
		const linkItemArr2 = endItem.linkItemArr || [];

		return (linkItemArr1.indexOf(endItem) != -1 && linkItemArr2.indexOf(startItem) != -1);
	},

	addLinkItem(item, linkItem) {
		if (!item.linkItemArr) {
			item.linkItemArr = [];
		}

		if (item.linkItemArr.indexOf(linkItem) == -1) {
			item.linkItemArr.push(linkItem);
		}
	},

	getLine(item1, item2, color=cc.Color.BLACK) {
		const lineNode = new cc.Node();


		const ctx = lineNode.addComponent(cc.Graphics);
		ctx.lineWidth = 5;
    ctx.strokeColor = color;
    ctx.fillColor = color;

    ctx.moveTo(0, 0);
		ctx.lineTo(item2.x - item1.x, item2.y - item1.y);
		ctx.stroke();

		const dot1 = this.getDot(0, 0, ctx.lineWidth/2, ctx.strokeColor);
		dot1.parent = lineNode;

		const dot2 = this.getDot(item2.x - item1.x, item2.y - item1.y, ctx.lineWidth/2, ctx.strokeColor);
		dot2.parent = lineNode;

		return lineNode;
	},

	getDot(x, y, r, color) {

		const dotNode = new cc.Node();

    const ctx = dotNode.addComponent(cc.Graphics);
    ctx.fillColor = color || cc.Color.BLUE;
    ctx.circle(x, y, r);
    ctx.fill();

		return dotNode;
	},


	getItemById(id) {

		console.log('getItemById id:', id);
		console.log('this.rectNodeArr: ', this.rectNodeArr);

		const targetItem = this.rectNodeArr.find( node => {

			const data = node.data;

			console.log('data~~: ', JSON.stringify(data));


			if (data && (data.index + 1 == id)) {
				return true;
			}
		})
		return targetItem;
	},

	photoEndSignRect(data) {

		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const symbol = textArr[0]?.symbol
		if (!symbol) {
			return;
		}

		// return 
		const answerData = {};


		for (let i=0; i<this.signRectCheckArr.length; i++) {
			
			const signDebugItem = this.signRectCheckArr[i];
			const dropDownItem = signDebugItem.data.dropDownItem;

			const curSignKey = symbol[i].toString();
			
			if (dropDownItem.key == curSignKey) {


				const label = this.getLabel(dropDownItem.label, signDebugItem.ccRect.width);
				label.x = signDebugItem.x;
				label.y = signDebugItem.y;
				label.color = cc.Color.BLACK;
	
				this.debugDrawLayer.addChild(label, 2);


				const key = signDebugItem.data.index + 1;
				answerData[key] = {isFinish: true};

			}
		}

		this.showSignAnswer(answerData);

		return ;

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];

			const signId = '2'

			// const points = oneTextData.points;

			// const tempDisNum = Math.floor(points.length / 2);
			// const point1_x = points[0];
			// const point1_y = points[1];
			// const point2_x = points[tempDisNum];
			// const point2_y = points[tempDisNum + 1];

			// let centerPX = Number(point1_x) + (point2_x - point1_x) / 2;
			// let centerPY = Number(point1_y) + (point2_y - point1_y) / 2;

			// console.log('centerPX: ' ,centerPX);
			// console.log('centerPY: ' ,centerPY);

			// const colorRect = this.getColorDot(centerPX, -centerPY, 0.02, 0.02, "purple");
			// this.debugDrawLayer.addChild(colorRect, 1);


			// this.setOneAnswerDataCircle(colorRect, answerData);

		}

		console.log('answerData: ' , answerData);


		// this.showCircleAnswer(answerData);

	},

	showSignAnswer(answerData) {

		console.log('answerData: ', answerData);
		if (Object.keys(answerData).length == 0) {
			return;
		}

		console.log("signAnimaNodeArr: ", this.signAnimaNodeArr);

		for (let i = 0; i < this.signAnimaNodeArr.length; i++) {

			const animaNode = this.signAnimaNodeArr[i];

			const key = animaNode.data.signItem // i.toString();


			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showSign')
				this.showSign(animaNode);

			} else {

				animaNode.hitCount = 0;
			}
		}

	},

	showSign(node, isRight = true) {

		console.log('in showCircle 1');


		node.hitCount++;
		if (node.hitCount < 1) {
			return;
		}


		console.log('in showCircle 2');


		if (node.isShowEnd) {
			return;
		}

		console.log('in showCircle 3');

		node.isShowEnd = true;
		node.isRight = isRight;


		// node.playRightAnim();
		this.playRightAnim(node);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.signAnimaNodeArr);
		}

		return;

	},

	photoEndCircleRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const points = oneTextData.points;

			const tempDisNum = Math.floor(points.length / 2);
			const point1_x = points[0];
			const point1_y = points[1];
			const point2_x = points[tempDisNum];
			const point2_y = points[tempDisNum + 1];
			// const point3_x = points[tempDisNum*2];
			// const point3_y = points[tempDisNum*2 + 1];

			// let centerP = this.locate(point1_x, point1_y, point2_x, point2_y, point3_x, point3_y);
			let centerPX = Number(point1_x) + (point2_x - point1_x) / 2;
			let centerPY = Number(point1_y) + (point2_y - point1_y) / 2;

			console.log('centerPX: ' ,centerPX);
			console.log('centerPY: ' ,centerPY);


			const colorRect = this.getColorDot(centerPX, -centerPY, 0.02, 0.02, "purple");
			this.debugDrawLayer.addChild(colorRect, 1);


			this.setOneAnswerDataCircle(colorRect, answerData);


			// console.log('points: ', points);
		
			// for (let j=0; j<points.length; j+=2) {
			// 	const x = points[j]//centerP.x
			// 	const y = -points[j+1]//-centerP.y
			// 	const w = 0.01;
			// 	const h = 0.01;
	
			// 	const rect = {
			// 		x, y,
			// 		width: w,
			// 		height: h
			// 	}
	

	
			// 	const colorRect = this.getColorDot(rect.x, rect.y, w, h, "red");
			// 	this.debugDrawLayer.addChild(colorRect, 1);


			// 	// this.setCirclePosInRectArr(colorRect);
				
	
			// }
		


		}

		console.log('answerData: ' , answerData);


		this.showCircleAnswer(answerData);

		// this.showUserRightNew(answerData);
	},

	showCircleAnswer(answerData) {

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.circleAnimaNodeArr.length; i++) {

			const animaNode = this.circleAnimaNodeArr[i];

			const key = animaNode.data.circleItem // i.toString();

			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showLetter')
				this.showCircle(animaNode);
				// this.showCircle2(animaNode);

			} else {

				animaNode.hitCount = 0;
			}
		}

	},

	showCircle(node, isRight = true) {

		console.log('in showCircle 1');


		node.hitCount++;
		if (node.hitCount < 1) {
			return;
		}


		console.log('in showCircle 2');


		if (node.isShowEnd) {
			return;
		}

		console.log('in showCircle 3');

		node.isShowEnd = true;
		node.isRight = isRight;



		// this.playRightAnim(node);
		this.showCircle2(node);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.circleAnimaNodeArr);
		}

		return;

	},
	

	photoEndNewRect(data) {

		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const x = oneTextData.left//oneTextData.left + (oneTextData.right - oneTextData.left) / 2;
			const y = -oneTextData.bottom//-oneTextData.top - (oneTextData.bottom - oneTextData.top) / 2;
			const w = oneTextData.right - oneTextData.left;
			const h = oneTextData.bottom - oneTextData.top;

			const rect = {
				x, y,
				width: w,
				height: h
			}

			console.log('oneTextData: ', oneTextData);

			const content = oneTextData.content;
			const colorRect = this.getColorRect(rect, "red");
			colorRect.labelText = content;
			this.debugDrawLayer.addChild(colorRect, 1);

			const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
			label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
			label.color = cc.Color.BLACK;

			this.debugDrawLayer.addChild(label, 2);

			this.setOneAnswerDataNew(colorRect, answerData);

		}

		console.log('answerData:' , answerData);
		this.showUserRightNew(answerData);
	},

	showUserRightNew(answerData) {

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.animaNodeArr.length; i++) {

			const animaNode = this.animaNodeArr[i];

			const key = animaNode.data.rectNew // i.toString();

			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showLetter')
				this.showLetter(animaNode);
			} else {

				animaNode.hitCount = 0;
			}
		}
	},

	photoEnd(data) {
		
		console.log(' this.photo end ', data);


		// if (this.newRectArr && this.newRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_WRITE) {
			this.photoEndNewRect(data);
			return;
		}


		// if (this.circleRectArr && this.circleRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_CIRCLE) {
			this.photoEndCircleRect(data);
			return;
		}

		// if (this.lineRectArr && this.lineRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_LINE) {
			this.photoEndLineRect(data);
			return;
		}

		// if (this.signRectArr && this.signRectArr.length > 0) {
		if (this.curCheckGroup == this.CHECK_TYPE_SIGN) {
			this.photoEndSignRect(data);
			return;
		}

		


		// this.changeBboxPos(data);

		const isRightArea = this.checkIsRightArea(data);
		if (!isRightArea) {
			console.log('没有检测到区域')
			return;
		}



		if (this.isCanDraw) {
			return;
		}
		this.isCanDraw = true;


		delayCall(0.01, () => {
			this.isCanDraw = false;
		})



		this.debugDrawLayer.removeAllChildren();

		// const benchmark1Text = this.benchmark1Data.labelText
		// const benchmark1TextArr = benchmark1Text.split(' ');
		// const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, data?.result?.text);

		// const benchmark2Text = this.benchmark2Data.labelText
		// const benchmark2TextArr = benchmark2Text.split(' ');
		// const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr,  data?.result?.text);




		const answerData = this.getAnswerData(data);

		this.showUserRight(answerData, data);

		return;


		const answerWrongData = this.getAnswerWrongData(data);
		let isShowWrong = false;
		if (this.oldAnswerWrongData) {
		
			for (let key in answerWrongData) {
				const wrongData = answerWrongData[key];
				const oldWrongData = this.oldAnswerWrongData[key];
				if (oldWrongData && oldWrongData.sentence == wrongData.sentence) {
					wrongData.count += oldWrongData.count;

					if (wrongData.count >= 3) {
						isShowWrong = true;
					}
				}
			}
		}

		if (isShowWrong) {
			this.showUserWrong(answerWrongData);
		}

		this.oldAnswerWrongData = answerWrongData;


		console.log('answerWrongData: ', JSON.stringify( answerWrongData) );
	},







	checkIsRightArea(data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}

		const benchmark1Text = this.benchmark1Data.labelText
		const benchmark1TextArr = benchmark1Text.split(' ');
		console.log('benchmark1TextArr: ', benchmark1TextArr);
		// const letter = this.data.letter || 'Aa';

		const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, text, false);
		if (!benchmark1LabelData) {
			console.log('!benchmark1LabelData')
			return false;
		}
		this.benchmark1LabelData = benchmark1LabelData;
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		

		if ( this.firstItemData ) {

			const firstText = this.firstItemData.labelText
			const firstTextArr = firstText.split(' ');

			const firstItemLabelData = this.getTopLeftLetter2(firstText, text, this.benchmark1LabelData);

			if (!firstItemLabelData) {
				return false;
			}
			this.firstItemLabelData = firstItemLabelData;

			console.log('firstItemLabelData: ', firstItemLabelData);
			return true

		} else if (this.benchmark2Data) {
		
			const benchmark2Text = this.benchmark2Data.labelText
			const benchmark2TextArr = benchmark2Text.split(' ');
			const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr, text, false);
			if (!benchmark2LabelData) {
				return false;
			}
			this.benchmark2LabelData = benchmark2LabelData;
			return true;
		}



		return false;

	


		// const block = data?.block
		// if (!block) {
		// 	return false;
		// }

		// const topText = this.topItemData.labelText
		// const topTextArr = topText.split(' ');
		// console.log('topTextArr: ', topTextArr);
		// // const letter = this.data.letter || 'Aa';

		// const topLabelData = this.getPhotoLabelData(topTextArr, block);
		// if (!topLabelData) {
		// 	console.log('!topLabelData')
		// 	return false;
		// }
		// this.topLabelData = topLabelData;
		// console.log('topLabelData: ', topLabelData);

		

		// if (this.bottomItemData) {
			
		// 	const bottomText = this.bottomItemData.labelText
		// 	const bottomTextArr = bottomText.split(' ');
		// 	const bottomLabelData = this.getPhotoLabelData(bottomTextArr, block);
		// 	if (!bottomLabelData) {
		// 		return false;
		// 	}
		// 	this.bottomLabelData = bottomLabelData;
		// 	return true

		// } else if (this.firstItemData) {

		// 	const firstText = this.firstItemData.labelText
		// 	const firstTextArr = firstText.split(' ');
		// 	const topLeftLetter = this.getPhotoLabelData(firstTextArr, block);


		// 	// const topLeftLetter = this.getTopLeftLetter(this.firstItemData.labelText, block, topLabelData);
		// 	if (!topLeftLetter) {
		// 		return false;
		// 	}
		// 	this.topLeftLetter = topLeftLetter;

		// 	console.log('topLeftLetter: ', topLeftLetter);
		// 	return true;
		// }



		// return false;

	
	},

	changeBboxPos(data) {

		const text = data?.result?.text;
		if (!text) {
			return;
		}


		for (let i=0; i<text.length; i++) {

			let {left, top, right, bottom} = text[i];

			const q_left = this.ques_region[0];
			const q_top = this.ques_region[1];
			const q_right = this.ques_region[2];
			const q_bottom = this.ques_region[7];

			const rect = {x: q_left, y: q_top, width: q_right - q_left, height: q_bottom - q_top};

			text[i].left = q_left + left * rect.width;
			text[i].top = q_top + top * rect.height;
			text[i].right = q_left + right * rect.width;
			text[i].bottom = q_top + bottom * rect.height;

		}

		// console.log('bbox: ', bbox);
		// const x1 = bbox[0].x1;
		// const y1 = bbox[0].y1;
		// const x2 = bbox[1].x2;
		// const y2 = bbox[1].y2;
		// const x3 = bbox[2].x3;
		// const y3 = bbox[2].y3;
		// const x4 = bbox[3].x4;
		// const y4 = bbox[3].y4;

		// const left = this.ques_region[0];
		// const top = this.ques_region[1];
		// const right = this.ques_region[2];
		// const bottom = this.ques_region[7];

		// const rect = {x: left, y:top, width: right - left, height: bottom - top};

		// const y1_new = top + y1 * rect.height;
		// const y2_new = y1_new;
		// const y3_new = top + y3 * rect.height;
		// const y4_new = y3_new;

		// const x1_new = left + x1 * rect.width;
		// const x2_new = left + x2 * rect.width;
		// const x3_new = x2_new;
		// const x4_new = x1_new;

		// bbox[0].x1 = x1_new;
		// bbox[0].y1 = y1_new;
		// bbox[1].x2 = x2_new;
		// bbox[1].y2 = y2_new;
		// bbox[2].x3 = x3_new;
		// bbox[2].y3 = y3_new;
		// bbox[3].x4 = x4_new;
		// bbox[3].y4 = y4_new;

		// console.log('~~rect: ', rect);

	
	},



	getTopLeftLetter2(text, block, topLabelData) {

		const benchmark1Rect = this.benchmark1Data.rect;

		const rect = {
			x: topLabelData.left, 
			y: -topLabelData.bottom, 
			width: Math.abs( topLabelData.right - topLabelData.left ), 
			height: Math.abs( topLabelData.bottom - topLabelData.top ), 
		}                        
		const colorRect = this.getColorRect(rect, "green");
		this.debugDrawLayer.addChild(colorRect);
		


		const tempUnitW = benchmark1Rect.x + benchmark1Rect.width;
		const tempUnitH = benchmark1Rect.y + benchmark1Rect.height;
		const tempBaseX = benchmark1Rect.x + benchmark1Rect.width / 2;
		const tempBaseY = benchmark1Rect.y + benchmark1Rect.height / 2;


		const firstItemData = this.firstItemData;		
		const firstItemRect = this.firstItemData.rect;

	
		const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		const unitX = (firstItemX - tempBaseX) / tempUnitW;
		const unitY = (firstItemY - tempBaseY) / tempUnitH;
		const unitW2 = firstItemRect.width / tempUnitW;
		const unitH2 = firstItemRect.height / tempUnitH;



		console.log('tempUnitW: ', tempUnitW);
		console.log('tempUnitH: ', tempUnitH);
		console.log('tempBaseX: ', tempBaseX);
		console.log('tempBaseY: ', tempBaseY);

		console.log('firstItemY: ', firstItemY);
		console.log('tempBaseY: ', tempBaseY);
		console.log('tempUnitH: ', tempUnitH);

		firstItemData.unitX = unitX;
		firstItemData.unitY = unitY;
		firstItemData.unitW = unitW2;
		firstItemData.unitH = unitH2;



		const topLocationLeft = topLabelData.left;
		const topLocationTop = topLabelData.top;
		const topLocationRight = topLabelData.right;
		const topLocationBottom = topLabelData.bottom;

		const baseX = topLocationLeft + (topLocationRight - topLocationLeft) / 2;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight;
		const unitH = topLocationTop + (topLocationBottom - topLocationTop);
		

		const checkLetter = firstItemData;

		console.log('baseY: ', baseY);
		console.log('checkLetter.unitY: ', checkLetter.unitY);
		console.log('unitH: ', unitH);


		let x = baseX + checkLetter.unitX * unitW;
		const y = baseY + checkLetter.unitY * unitH;
		const w = checkLetter.unitW * unitW;
		const h = checkLetter.unitH * unitH;
		const r = Math.min(w, h) / 2;


		console.log(' baseX:  ', baseX);
		console.log(' checkLetter.unitX:  ', checkLetter.unitX);
		console.log(' unitW:  ', unitW);
		console.log(' x:  ', x);
		console.log(' y:  ', y);
		console.log(' r:  ', r);
		console.log(' checkLetter:  ', checkLetter);

		const dot = this.getColorDot(x, -y, r, r, 'blue');
		this.debugDrawLayer.addChild(dot, 5);

		dot.labelText = checkLetter.labelText;


		const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		let topLeftLetterData;


		const {dotRect, labelText} = dot
		


		for (let i=0; i<wordDataArr.length; i++) {

			// const tempWordArr = wordDataArr[i].word;
			const tempWordArr = this.getTempWordArr(wordDataArr[i],['']);



			for (let k=0; k<tempWordArr.length; k++) {
					
				const {location , content} = tempWordArr[k];

				const rect = {
					x: location.left, 
					y: -location.bottom, 
					width: Math.abs( location.right - location.left ), 
					height: Math.abs( location.bottom - location.top ), 
				}                        
				const colorRect = this.getColorRect(rect, "purple");
				colorRect.labelText = content;
				this.debugDrawLayer.addChild(colorRect);

				// console.log('colorRect: ', colorRect);

				const label = this.getLabel(content);
				label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
				label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
				label.color = cc.Color.GREEN;
				this.debugDrawLayer.addChild(label);




				///------

				const checkRect = colorRect.ccRect;
				const targetLabelText = colorRect.labelText;

				const {dotRect, labelText, key} = dot;

				if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && checkRect.intersects(dotRect)) {
					return tempWordArr[k];
				}

				///------
				

			}





			// const lineRect = this.getLineRect( wordDataArr[i] );
			// const isInLineRect = lineRect.intersects(dotRect)
			// if (!isInLineRect) {
			// 	continue;
			// }

			// for (let k=0; k<tempWordArr.length; k++) {
			// 	const {location , content} = tempWordArr[k];

			// 	const tempRect = {
			// 		x: location.left, 
			// 		y: -location.bottom, 
			// 		width: Math.abs( location.right - location.left ), 
			// 		height: Math.abs( location.bottom - location.top ), 
			// 	}
			// 	const colorRect = this.getColorRect(tempRect);
			// 	colorRect.labelText = content;
			// 	// this.debugDrawLayer.addChild(colorRect);

			// 	const label = this.getLabel(content);
			// 	label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			// 	label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
			// 	label.color = cc.Color.GREEN;
			// 	// this.debugDrawLayer.addChild(label);
				


						
			// 	const rect = colorRect.ccRect;
			// 	const targetLabelText = colorRect.labelText;



			

			// 	// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
			// 	// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


			// 	const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

			// 	if (isInLineText) {
			// 	// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
			// 		topLeftLetterData = wordDataArr[i];
			// 		// answerData[i.toString()] = colorRect;
			// 		// return;
			// 	}

			// }
			
		}

			
		return null;


	},


	getTopLeftLetter(text, block, topLabelData) {

		// const topItemRect = this.topItemData.rect;

		// const tempUnitW = topItemRect.width;
		// const tempUnitH = topItemRect.height;
		// const tempBaseX = topItemRect.x;
		// const tempBaseY = topItemRect.y + topItemRect.height / 2;


		// const firstItemData = this.firstItemData;
		// console.log('firstItemData: ', firstItemData);
		
		// const firstItemRect = this.firstItemData.rect;


	
		// const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		// const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		// const unitX = (firstItemX - tempBaseX) / tempUnitW;
		// const unitY = (firstItemY - tempBaseY) / tempUnitH;
		// const unitW2 = firstItemRect.width / tempUnitW;
		// const unitH2 = firstItemRect.height / tempUnitH;


		// console.log('firstItemY: ', firstItemY);
		// console.log('tempBaseY: ', tempBaseY);
		// console.log('tempUnitH: ', tempUnitH);

		// firstItemData.unitX = unitX;
		// firstItemData.unitY = unitY;
		// firstItemData.unitW = unitW2;
		// firstItemData.unitH = unitH2;



		// // const topLabelData = this.topLabelData;

		// const firstTopWordLocation = topLabelData.word[0].location;
		// const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		// const topLocationLeft = firstTopWordLocation.left;
		// const topLocationTop = firstTopWordLocation.top;
		// const topLocationRight = lastTopWordLocation.right;
		// const topLocationBottom = lastTopWordLocation.bottom;

		// const baseX = topLocationLeft;
		// const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		// const unitW = topLocationRight - topLocationLeft;
		// const unitH = topLocationBottom - topLocationTop;
		

		// const checkLetter = firstItemData;

		// console.log('baseY: ', baseY);
		// console.log('checkLetter.unitY: ', checkLetter.unitY);
		// console.log('unitH: ', unitH);


		// let x = baseX + checkLetter.unitX * unitW;
		// const y = baseY + checkLetter.unitY * unitH;
		// const w = checkLetter.unitW * unitW;
		// const h = checkLetter.unitH * unitH;
		// const r = Math.min(w, h) / 2;

		// 	// const centerX = baseX + this.centerUnitW * unitW;
		// 	// x += (centerX - x) * 0.005  * (y * 0.05);

		// console.log(' x:  ', x);
		// console.log(' y:  ', y);
		// console.log(' r:  ', r);

		// const dot = this.getColorDot(x, -y, r, r, 'purple');
		// this.debugDrawLayer.addChild(dot, 5);

		// dot.labelText = checkLetter.labelText;


		// const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// let topLeftLetterData;


		// const {dotRect, labelText} = dot
		


		// for (let i=0; i<wordDataArr.length; i++) {

		// 	const tempWordArr = wordDataArr[i].word;

		// 	const lineRect = this.getLineRect( wordDataArr[i] );
		// 	const isInLineRect = lineRect.intersects(dotRect)
		// 	if (!isInLineRect) {
		// 		continue;
		// 	}

		// 	for (let k=0; k<tempWordArr.length; k++) {
		// 		const {location , content} = tempWordArr[k];

		// 		const tempRect = {
		// 			x: location.left, 
		// 			y: -location.bottom, 
		// 			width: Math.abs( location.right - location.left ), 
		// 			height: Math.abs( location.bottom - location.top ), 
		// 		}
		// 		const colorRect = this.getColorRect(tempRect);
		// 		colorRect.labelText = content;
		// 		// this.debugDrawLayer.addChild(colorRect);

		// 		const label = this.getLabel(content);
		// 		label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
		// 		label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
		// 		label.color = cc.Color.GREEN;
		// 		// this.debugDrawLayer.addChild(label);
				


						
		// 		const rect = colorRect.ccRect;
		// 		const targetLabelText = colorRect.labelText;



			

		// 		// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
		// 		// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


		// 		const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

		// 		if (isInLineText) {
		// 		// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
		// 			topLeftLetterData = wordDataArr[i];
		// 			// answerData[i.toString()] = colorRect;
		// 			// return;
		// 		}

		// 	}
			
		// }

			
		// return topLeftLetterData;









		// // const topRect = this.topItemData.rect;

		// // const topCenterY = (topRect.y + topRect.height / 2);
		// // const bottomCenterY = (bottomRect.y + bottomRect.height / 2);
		
		// // const unitH = bottomCenterY - topCenterY;
		// // const unitW = topRect.width;
		// // const baseX = topRect.x;
		// // const baseY = topRect.y + topRect.height;


		

		// // const titleBottom = this.getTitleBottom();
		// // console.log("titleBottom: ", titleBottom);

		// // let topLeftLetter;
		// // const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// // for (let i=0; i<wordDataArr.length; i++) {

		// // 	const tempWordArr = wordDataArr[i].word;
		// // 	for (let k=0; k<tempWordArr.length; k++) {
		// // 		const {location , content} = tempWordArr[k];


		// // 		// console.log('location: ~~ ', location);

		// // 		// if (location.top <= titleBottom) {
		// // 		// 	continue;
		// // 		// }

		// // 		wordDataArr[i].tmpLen = this.getToZeroLen(location)

					



		// // 		if (!topLeftLetter) {
		// // 			topLeftLetter = wordDataArr[i];
		// // 		} else {
		// // 			if (topLeftLetter.tmpLen > wordDataArr[i].tmpLen) {
		// // 				topLeftLetter = wordDataArr[i];
		// // 			}
		// // 		}
		// // 	}
			
		// // }

		// // return topLeftLetter;


	},

	getLineRect(line) {

		const tempWordArr = line.word;

		let sentenceRect;
		let left;
		let right;
		for (let k=0; k<tempWordArr.length; k++) {
			const {location , content} = tempWordArr[k];

			const tempRect = {
				x: location.left, 
				y: -location.bottom, 
				width: Math.abs( location.right - location.left ), 
				height: Math.abs( location.bottom - location.top ), 
			}
			const colorRect = this.getColorRect(tempRect);
			colorRect.labelText = content;
			// this.debugDrawLayer.addChild(colorRect);

					
			const rect = colorRect.ccRect;
			if (!sentenceRect) {
				sentenceRect = rect;
				left = rect.x;
				right = rect.x + rect.width;
			} else {
				if (rect.x + rect.width > right) {
					right = rect.x + rect.width;
				}
			}



		


		}

		if (sentenceRect) {
			sentenceRect.width = right - left;
		}

		return sentenceRect;



	},

	checkWordIsInLine(line, text) {

		console.log(" in checkWordIsInLine ");
		console.log(" line:  ", line);
		console.log(" word:  ", text);

		const textArr = text.trim().toLowerCase().split('');

		const word = line.word;
		let sentence = ''
		word.forEach(item => {
			sentence += item.content + ' ';
		});

		sentence.trim();
		sentence = sentence.toLowerCase();

		line.sentence = sentence;

		console.log(" sentence:  ", sentence);
		

		if (this.checkIsInsert(textArr, sentence)) {
			return true;
		}

		
		return false;

	},


	getTitleBottom() {
		let maxBottom = 0;
		const word = this.topLabelData.word;
		for (let i=0; i<word.length; i++) {
			if (word[i].location.bottom > maxBottom) {
				maxBottom = word[i].location.bottom;
			}
		}

		return maxBottom;
	},

	getToZeroLen(location) {
		const {top, left} = location;
		const len = Math.sqrt( Math.pow(left, 2) + Math.pow(top, 2) );
		return len;
	},



	getPhotoLabelData(textArr, block, isShow=true) {


		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}

			const sentence = line.content;


			if (isShow) {
				const label = this.getLabel(sentence, 150);
				label.x = line.left * this.debugBgImg.width;
				label.y = -(line.top + (line.bottom - line.top) / 2) * this.debugBgImg.height;
				label.parent = this.debugDrawLayer;
				label.zIndex = 200;
				// label.color = cc.Color.RED;
				const l = label.getComponent(cc.Label);
				label.anchorX = 0;
				console.log(' sentence~:  ', sentence);
			}




			if (this.checkIsInsert(textArr, sentence)) {
				return line;
			}

		}

		return false;

		// for(let j=0; j<block.length; j++) {

		// 	const line = block[j].line;
		// 	if (!line) {
		// 		continue;
		// 	}

		// 	for (let i=0; i<line.length; i++) {

		// 		const word = line[i].word;
		// 		let sentence = ''
		// 		word.forEach(item => {
		// 			sentence += item.content + ' ';
		// 		});
	
		// 		sentence.trim();
		// 		sentence = sentence.toLowerCase();
	
		// 		line[i].sentence = sentence;

		// 		if (this.checkIsInsert(textArr, sentence)) {
		// 			return line[i];
		// 		}
		// 	}
		// }

		// return false;
	},

	checkIsInsert(textArr, sentence) {
		// console.log('textArr: ', textArr);
		// console.log('sentence: ', sentence);

		sentence = sentence.toLowerCase();

		let index = -1;
		for (let i=0; i<textArr.length; i++) {
			index = sentence.indexOf(textArr[i].toLowerCase(), index);
			// console.log('index: ', index);
			if (index == -1) {
				return false;
			}
		}

		return true;
	},


	showUserRight(answerData, data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log('answerData: ', answerData);
		// console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}



		for (let i = 0; i < this.animaNodeArr.length; i++) {

			const animaNode = this.animaNodeArr[i];

			const key = animaNode.data.rectItem // i.toString();

			console.log('key: ', key)

			console.log('~key: ', key)

			if (!animaNode.hitCount) {
				animaNode.hitCount = 0;
			}

			if (answerData[key] && answerData[key].isFinish) {
				this.showLetter(animaNode);
				// this.removeLine(answerData[key].line, block);
			} else {

				animaNode.hitCount = 0;
			}
		}


		// for (let i = 0; i < this.picNodeArr.length; i++) {

		// 	const picNode = this.picNodeArr[i];

		// 	const key = picNode.data.rectItem // i.toString();

		// 	console.log('key: ', key)

		// 	if (answerData[key] && answerData[key].isFinish) {
		// 		this.showLetter(picNode);
		// 		this.removeLine(answerData[key].line, block);
		// 	} else {

		// 		picNode.hitCount = 0;
		// 	}
		// }


	},

	removeLine(line, block) {

		console.log('block: ', JSON.stringify(block));
		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
	
			const index = lineArr.indexOf(line);
			if (index != -1) {
				lineArr.splice(index, 1);
				console.log(' ```splice lineArr.length: ' , lineArr.length);
			}
		}
	},

	showUserWrong(answerData) {

		console.log('answerData: ', answerData);
		console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.picNodeArr.length; i++) {

			const picNode = this.picNodeArr[i];

			const key = picNode.data.rectItem // i.toString();

			console.log('key: ', key)

			if (answerData[key] && answerData[key].count >= 3) {
				this.showLetter(picNode, false);
			}
		}


	},

	

	showLetter(picNode, isRight = true) {

		// let writeRect = this.writeNodeArr[Number(index)];

		console.log('in showLetter 1');


		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}


		console.log('in showLetter 2');


		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetter 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.playRightAnim();
		this.playRightAnim(picNode);

		if (!this.isGameEnd) {
			this.checkGameEnd(this.animaNodeArr);
		}

		return;


		picNode.answerPic.active = true;



		if (!isRight) {
			console.log(' ~ !isRight');
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#ef7961')
			playAudio(this.wrongClip);

			if (!this.isGameEnd) {
				this.checkGameEnd();
			}
			return;
		} else {
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#548fd4')
			playAudio(this.rightClip);

		}

		this.showAnimaStar(picNode, ()=> {
			
			if (!this.isGameEnd) {
				this.checkGameEnd();
			}

		});

	
	},

	showAnimaStar(node, cb) {

		const resDragonBone = cc.find("Canvas/res/anim/right")
		const dNode = cc.instantiate(resDragonBone)
		node.addChild(dNode, 20);

		const dragonDisplay = dNode.getComponent(dragonBones.ArmatureDisplay);

		dragonDisplay.playAnimation('newAnimation', 1);

		dragonDisplay.on(dragonBones.EventObject.COMPLETE, ()=> {
			console.log('play end');
			cb && cb();
		})
		

	},


	getAnswerData(data) {
		
		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log(' in getAnswerData: ', text);


		const benchmark1LabelData = this.benchmark1LabelData;
		let benchmark2LabelData ;

		const centerItemArr = this.centerItemArr;

		const benchmark1Left = benchmark1LabelData.left;
		const benchmark1Top = benchmark1LabelData.top;
		const benchmark1Right = benchmark1LabelData.right;
		const benchmark1Bottom = benchmark1LabelData.bottom;

		let baseX;
		let baseY;
		let unitW;
		let unitH;

		if (this.benchmark2LabelData) {
			benchmark2LabelData = this.benchmark2LabelData;


			const benchmark2Left = benchmark2LabelData.left;
			const benchmark2Top = benchmark2LabelData.top;
			const benchmark2Right = benchmark2LabelData.right;
			const benchmark2Bottom = benchmark2LabelData.bottom;


			const bottomLocation = benchmark2LabelData;

			baseX = benchmark1Left;
			baseY =	benchmark1Top + (benchmark1Bottom - benchmark1Top) / 2;
			unitW = benchmark2Right - benchmark1Left;
			unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;


			const benchmark2Rect = {
				x: benchmark2Left, 
				y: -benchmark2Bottom,
				width: Math.abs( benchmark2Left - benchmark2Right ), 
				height: Math.abs( benchmark2Top - benchmark2Bottom ), 
			}
			
			const colorbenchmark2Rect = this.getColorRect(benchmark2Rect, 'green');
			this.debugDrawLayer.addChild(colorbenchmark2Rect);
		} 

	



		if (this.firstItemLabelData) {
			const {location} = this.firstItemLabelData;
			const firstItemLeft = location.left;
			const firstItemRight = location.right;
			const firstItemTop = location.top;
			const firstItemBottom = location.bottom;

			console.log(' location: ', location);
			console.log(' firstItemLeft: ', firstItemLeft);
			console.log(' firstItemRight: ', firstItemRight);
			console.log(' firstItemTop: ', firstItemTop);
			console.log(' firstItemBottom: ', firstItemBottom);

			baseX = firstItemLeft + (firstItemRight - firstItemLeft) / 2;
			baseY =	firstItemTop + (firstItemBottom - firstItemTop) / 2;
			unitW = benchmark1Left + (benchmark1Right -  benchmark1Left) - ( firstItemLeft + (firstItemRight - firstItemLeft) / 2 );
			unitH = ( firstItemTop + (firstItemBottom - firstItemTop) / 2 ) - (benchmark1Top + (benchmark1Bottom -  benchmark1Top) / 2);
		}


		console.log(' baseX ~~~ ', baseX);
		console.log(' baseY ~~~ ', baseY);
		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = 1 //this.data.scaleOffY || 0.055;
		let postionRate = 1 //this.data.positionOffY || 0.4;

		// if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
		// 	postionRate *= 1.7;
    // }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			// const centerX = baseX + this.centerUnitW * unitW;

			// const tempR = scaleRate * (checkLetter.unitY * unitH);
			// const newR = r - tempR; 

			// let newW = w - tempR; 
			// let newH = h - tempR;


			// const rate = newR / r;

			// const tempY = ( y - (baseY) ) * postionRate;
			// y = y - tempY * (1 - rate);


			// const tempX = (centerX - x) * postionRate;
			// x = x + tempX * (1-rate);


			// const newScale = 1.4;
			// const edgeOff = (newScale - 1) / 2;
			// x -= edgeOff * newW;
			// y += edgeOff * newH;
			// newW *= newScale;
			// newH *= newScale;

			// const dot = this.getColorDot(x, -y, newW, newH);

			const dot = this.getColorDot(x, -y, w / 2, h / 2);



			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}



		// console.log('dotArr: ', dotArr);
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		const answerData = {};

		for (let j=0; j<this.centerItemArr.length; j++) {
			const checkLetter = this.centerItemArr[j];

			const wordDataArr = this.getPhotoWordArr(checkLetter.labelText, text, benchmark1LabelData);

			console.log('~~~wordDataArr: ', wordDataArr);


			for (let i=0; i<wordDataArr.length; i++) {

				const tempWordArr = this.getTempWordArr(wordDataArr[i],['']); // wordDataArr[i].word;

				for (let k=0; k<tempWordArr.length; k++) {
					
					const {location , content} = tempWordArr[k];

					const rect = {
						x: location.left, 
						y: -location.bottom, 
						width: Math.abs( location.right - location.left ), 
						height: Math.abs( location.bottom - location.top ), 
					}                        
					const colorRect = this.getColorRect(rect, "purple");
					colorRect.labelText = content;
					this.debugDrawLayer.addChild(colorRect);

					// console.log('colorRect: ', colorRect);

					const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
					label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
					label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
					label.color = cc.Color.BLACK;

					this.debugDrawLayer.addChild(label);
					
	
					this.setOneAnswerData(colorRect, dotArr, answerData, wordDataArr[i]);
	
				}
				
			}

		
		}



		const benchmark1Rect = {
			x: benchmark1Left, 
			y: -benchmark1Bottom,
			width: Math.abs( benchmark1Left - benchmark1Right ), 
			height: Math.abs( benchmark1Top - benchmark1Bottom ), 
		}

		console.log('benchmark1Rect: ', benchmark1Rect);
		
		const colorbenchmark1Rect = this.getColorRect(benchmark1Rect, 'green');
		this.debugDrawLayer.addChild(colorbenchmark1Rect);





		// const rectTop = {
		// 	x: topLocationLeft, 
		// 	y: -topLocationBottom,
		// 	width: Math.abs( topLocationLeft - topLocationRight ), 
		// 	height: Math.abs( topLocationTop - topLocationBottom ), 
		// }
		
		// const colorRectTop = this.getColorRect(rectTop, 'green');
		// this.debugDrawLayer.addChild(colorRectTop);



		// const rectBottom = {
		// 	x: bottomLocation.left, 
		// 	y: -bottomLocation.bottom,
		// 	width: Math.abs( bottomLocation.left - bottomLocation.right ), 
		// 	height: Math.abs( bottomLocation.top - bottomLocation.bottom ), 
		// }
		
		// const colorRectBottom = this.getColorRect(rectBottom, 'green');
		// this.debugDrawLayer.addChild(colorRectBottom);






		return answerData;


	},

	getTempWordArr(line, splitText) {

		const lineBox = {left: line.left, top: line.top, right: line.right, bottom: line.bottom};
		const baseX = lineBox.left;

		let textIndex = 0;
		const oneDisW = (lineBox.right - lineBox.left) / line.content.length;

		const arr = line.content.split(splitText);
		const wordArr = [];
		for (let i=0; i<arr.length; i++) {
			const content = arr[i];
			const location = {}
			location.left = baseX + textIndex * oneDisW;
			location.right = location.left + oneDisW * content.length;
			location.top = lineBox.top;
			location.bottom = lineBox.bottom;
			
			wordArr.push({content, location});

			textIndex += content.length;
		}

		return wordArr;
	},




	getAnswerWrongData(data) {
		
		const block = data?.block
		if (!block) {
			return false;
		}


		console.log(' in getAnswerWrongData: ', block);

		const endKeyObj = {};
		for (let j = 0; j < this.picNodeArr.length; j++) {

			const picNode = this.picNodeArr[j];

			const key = picNode.data.rectItem // i.toString();

			if (picNode.isShowEnd) {
				endKeyObj[key] = true;
			}
		}


		const topLabelData = this.topLabelData;
		let bottomLabelData ;
		if (this.bottomLabelData) {
			bottomLabelData = this.bottomLabelData;
		} else {
			bottomLabelData = this.topLeftLetter;
		}
		// const bottomLabelData = this.bottomLabelData;
		const centerItemArr = this.centerItemArr;

		// console.log('topLabelData: ', topLabelData);

		const firstTopWordLocation = topLabelData.word[0].location;
		const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		const topLocationLeft = firstTopWordLocation.left;
		const topLocationTop = firstTopWordLocation.top;
		const topLocationRight = lastTopWordLocation.right;
		const topLocationBottom = lastTopWordLocation.bottom;


		const bottomLocation = bottomLabelData.word[0].location;

		const baseX = topLocationLeft;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight - topLocationLeft;
		const unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;

		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = this.data.scaleOffY || 0.055;
		let postionRate = this.data.positionOffY || 0.4;

		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			postionRate *= 1.7;
    }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			const key = centerItemArr[i].index + 1;
			if (endKeyObj[key]) {
				continue;
			}

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			const centerX = baseX + this.centerUnitW * unitW;
	
			
		
			// y -= ( y - (baseY + unitH) ) * 0.35;



			const tempR = scaleRate * (checkLetter.unitY * unitH);
			const newR = r - tempR; 

			let newW = w - tempR; 
			let newH = h - tempR;


			const rate = newR / r;

			const tempY = ( y - (baseY) ) * postionRate;
			y = y - tempY * (1 - rate);


			const tempX = (centerX - x) * postionRate;
			x = x + tempX * (1-rate);




			const newScale = 1.4;
			const edgeOff = (newScale - 1) / 2;
			x -= edgeOff * newW;
			y += edgeOff * newH;
			newW *= newScale;
			newH *= newScale;

			const dot = this.getColorDot(x, -y, newW, newH);
			// const dot = this.getColorDot(x, -y, newR, newR);

			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;
			dot.centerPos = cc.v2(dot.x+ dot.width / 2, dot.y + dot.height / 2);

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}


		console.log('topLabelData: ', topLabelData);

		const answerData = {};


		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
			if (!lineArr) {
				continue;
			}

			for (let m=0; m<lineArr.length; m++) {
				const line = lineArr[m];
				
				
				console.log('line: ', JSON.stringify(line));
				const lineRect = this.getLineRect( line );
				console.log('lineRect: ~  ', JSON.stringify(lineRect));
				const lineCenterPos = cc.v2(lineRect.x + lineRect.width / 2, lineRect.y + lineRect.height / 2);

	
				const tempDotArr = [];
				for (let j=0; j<dotArr.length; j++) {
					const isInLineRect = lineRect.intersects(dotArr[j].dotRect)
					if (isInLineRect) {
						tempDotArr.push(dotArr[j]);
					}
				}
				if (tempDotArr.length > 0) {
					const colorRect = this.getColorRect(lineRect, 'purple');
					this.debugDrawLayer.addChild(colorRect);

					console.log('tempDotArr.length > 0')
					let minDistance;
					let curDot;
					for (let j=0; j<tempDotArr.length; j++) {
						const curDistance = cc.Vec2.distance(lineCenterPos, tempDotArr[j].centerPos);
						if (minDistance == null || minDistance > curDistance) {
							minDistance = curDistance;
							curDot = tempDotArr[j];
						}
					}
	
					const tempWordArr = line.word;
					let sentence = ''
					tempWordArr.forEach(item => {
						sentence += item.content.trim();
					});
	
					console.log('sentence: ', sentence);
					console.log('curDot.labelText: ', curDot.labelText);
					if (sentence.length >= curDot.labelText.length) {
						if (!answerData[curDot.key]) {
							answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
						} else {                                        
							const oldData = answerData[curDot.key];
							if (oldData.minDistance > minDistance) {
								answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
							}
						}
					}
				} else {

					const colorRect = this.getColorRect(lineRect, 'red');
					this.debugDrawLayer.addChild(colorRect);
				}
			}

	
		}


		return answerData;


	},


	setCirclePosInRectArr(colorRect) {


		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);

		const circleRectCheckArr = this.circleRectCheckArr;

		for (let i=0; i<circleRectCheckArr.length; i++) {

			const checkRect = circleRectCheckArr[i].ccRect;
			const key = circleRectCheckArr[i].data.index + 1;

			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (checkRect.contains(dotV2)) {
				if (!colorRect.inRectArr) {
					colorRect.inRectArr = []
				}
				colorRect.inRectArr.push(key);
			}

		}
	},



	setOneAnswerDataNew(colorRect, answerData) {
		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);


		const targetLabelText = colorRect.labelText;

		const newRectCheckArr = this.newRectCheckArr;

		for (let i=0; i<newRectCheckArr.length; i++) {

			const labelText = newRectCheckArr[i].data.labelText;
			const checkRect = newRectCheckArr[i].ccRect;
			const key = newRectCheckArr[i].data.index + 1;


			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			// if (labelText == targetLabelText && checkRect.contains(dotV2)) {
			if (checkRect.contains(dotV2)) {
				// const len = targetLabelText.trim().length;

				// console.log('len: ', len);

				// if (newRectCheckArr[i].data.isFuzzy) {

				const index = labelText.indexOf("||");
				if (index != -1) {
					const keyArr = labelText.split("||");

					for (let j=0; j<keyArr.length; j++) {

						if (targetLabelText.indexOf(keyArr[j]) != -1 ) {
							answerData[key] = {isFinish: true};
							break;
						}

					}
				} else {

					if (targetLabelText.indexOf(labelText) != -1 ) {
						answerData[key] = {isFinish: true};
					}
				}


					// if (targetLabelText.indexOf(labelText) != -1 ) {
					// 	answerData[key] = {isFinish: true};
					// }

				// } else {
				// 	if (labelText == targetLabelText) {
				// 		answerData[key] = {isFinish: true};
				// 	}
				// }


			}

		}
	},

	setOneAnswerData(colorRect, dotArr, answerData, line) {

		console.log(' in setOneAnswerData')
		console.log('colorRect: ', colorRect)
		console.log('dotArr: ', dotArr)
		console.log('answerData: ', answerData)

		
		const rect = colorRect.ccRect;
		const targetLabelText = colorRect.labelText;

		for (let i=0; i<dotArr.length; i++) {

			const {dotRect, labelText, key} = dotArr[i];

				console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
				console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );
				console.log('rect.intersects(dotRect) : ', rect.intersects(dotRect) );

			if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
				const len = targetLabelText.trim().length;

				console.log('len: ', len);

				if (!answerData[key]) {
					answerData[key] = {colorRect, count: len};
				} else {
					answerData[key].count += len;

					// console.log('len: ', len);
					// console.log('	answerData[key].count: ', 	answerData[key].count);

				}

				if ( labelText.length <= 1) {
					answerData[key].isFinish = true;
					answerData[key].line = line;

				} else {
					if (answerData[key].count >= labelText.length) {
						answerData[key].isFinish = true;
						answerData[key].line = line;
					}
				}
				

			
				// return;
			}

		}

	},

	getColorRect(rect, color=null) {

		if (!color) {
			color = 'red'
		}


		rect.x *= this.debugBgImg.width;
		rect.y *= this.debugBgImg.height;
		rect.width *= this.debugBgImg.width;
		rect.height *= this.debugBgImg.height;

		const node = getSprNode(color);
		node.anchorX = 0;
		node.anchorY = 0;
		node.x = rect.x;
		node.y = rect.y;
		node.scaleX = rect.width / node.width;
		node.scaleY = rect.height / node.height;

		node.ccRect = new cc.Rect(rect.x, rect.y, rect.width, rect.height);



		return node;
	},



	getColorDot(x, y, w=100, h=100, color='red') {
		const node = new cc.Node();

		if (!h) {
			h = w;
		}

		x *= this.debugBgImg.width;
		y *= this.debugBgImg.height;
		w *= this.debugBgImg.width;
		h *= this.debugBgImg.height;

		if (this.debugLayer.parent && this.debugLayer.active) {

			const rect = {
				x:- w/2,
				y: - h/ 2, 
				width:w, 
				height:h
			}
			// const colorDot = this.getColorRect(rect,'blue');
			// colorDot.fillColor = cc.Color.BLUE;
			// colorDot.fillRect( - r/2, - r/ 2, r, r);

			const colorDot = getSprNode(color);

			
			// colorDot.anchorX = 0;
			// colorDot.anchorY = 0;
			// colorDot.x = rect.x;
			// colorDot.y = rect.y;
			colorDot.scaleX = rect.width / colorDot.width;
			colorDot.scaleY = rect.height / colorDot.height;
			node.addChild(colorDot);



			// const rect1 = new cc.Rect(node.x -r/2, node.y -r/2, r, r);
			// const colorDot = this.getColorRect(rect1, 'green');

			// colorDot.dotRect = rect1;
			// return colorDot;
		}

		node.x = x;
		node.y = y;


		// node.opacity = 0.5;

		const rect = new cc.Rect(node.x -w/2, node.y -h/2, w, h);
		node.dotRect = rect;
		node.ccRect = rect;
		return node;
	},

	



	checkHasAnswer(data, text) {

		text = text.toLowerCase();
		text = text.replace(/(^\s+)|(\s+$)/g,"");



		// -----
		let sentence = data.allText.replace('/\n/g', "");

		sentence = sentence.trim();
		sentence = sentence.toLowerCase();
		 


		if (sentence.indexOf(text) != -1) {

			// this.setTestLabel(line[i])

			return true;
		}
		// -----



		const block = data.block;
		for (let j = 0; j < block.length; j++) {

			const line = block[j].line;
			if (!line) {
				continue;
			}


			for (let i = 0; i < line.length; i++) {

				const word = line[i].word;
				const location = line[i].word[0].location;
		
				// console.log(' center line: ', line[i]);


				let sentence = ''
				word.forEach(item => {
					sentence += item.content.trim();
				});

				sentence = sentence.trim();
				sentence = sentence.toLowerCase();

				line[i].sentence = sentence;
				console.log('sentence: ' + sentence + ', text: ' + text);


				if (sentence.indexOf(text) != -1) {


					if (sentence) {
						this.setTestLabel(line[i])
					}

					// line[i].tmpLen = this.getToZeroLen(location)
					// if (!topLeftLetter) {
					// 	topLeftLetter = line[i];
					// } else {
					// 	if (topLeftLetter.tmpLen > line[i].tmpLen) {
					// 		topLeftLetter = line[i];
					// 	}
					// }

					return true;
				}
			}
		}

	},

	


	setTestLabel(labelData) {

		if (!this.debugLayer.parent || !this.debugLayer.active) {
			return;
		}
		// console.log('labelData: ', labelData)
		const location = labelData.word[0].location;
		const label = this.getLabel(labelData.sentence);
		label.anchorX = 0;
		// label.anchorY = 1;
		label.x = location.left;
		label.y = -location.top
		label.zIndex = 50;


		const rect = {};
		rect.width = location.right - location.left;
		rect.height = location.bottom - location.top;
		rect.x = location.left;
		rect.y = -location.top;
		// const colorRect = this.getColorRect(rect, cc.Color.YELLOW);
		// this.debugLayer.addChild(colorRect);

		this.debugLayer.addChild(label);
	},

	getLabel(text, fontSize = 20) {
		const labelNode = new cc.Node();
		const label = labelNode.addComponent(cc.Label);
		label.string = text;
		labelNode.color = cc.Color.BLACK;
		label.fontSize = fontSize;
		label.lineHeight = fontSize;
		return labelNode;
	},



	debugLayer: null,
	initDebugLayer() {


		console.log(' in initDebugLayer');
		const layer = new cc.Node();

		if (this.data.isDebug) {
			layer.parent = cc.find('Canvas');
		}


		layer.width = this.canvas.width / 2;
		layer.height = this.canvas.height / 2;

		layer.zIndex = 100;
		layer.anchorX = 0;
		layer.anchorY = 1;


		if (!this.data.bgItem2) {
			return;
		}


		cc.loader.load({url: this.data.bgItem2.url}, (err, img) => {

			this.debugBgImg = img;
			this.checkBg = img;
			layer.width = img.width;
			layer.height = img.height;

			layer.data = this.data.bgItem2;

			const sprNode = layer;
	
			var sf = new cc.SpriteFrame(img);

			const spr = sprNode.addComponent(cc.Sprite);
			spr.spriteFrame = sf			

			const sx = this.canvas.width / 2 / layer.width;
			const sy = (this.canvas.height) / 2 / layer.height;
			const s = Math.min(sx, sy);
			layer.scale = s;

			this.addNewRect();
			this.addCircleItem();
			this.addSignItem();

			this.initDebugRect();

			this.checkStart();
	
		});

		layer.x = -this.canvas.width / 2 + 10;
		layer.y = this.canvas.height / 2 - this.canvas.height / 3;
		layer.opacity = 150;

		// layer.scale = 2;
		this.debugLayer = layer;

		// const bgRectNode = new cc.Node();
		// const ctx = bgRectNode.addComponent(cc.Graphics);
		// ctx.fillRect(0, -layer.height, layer.width, layer.height);
		// ctx.fillColor = cc.Color.YELLOW.setA(100);
		// ctx.fill();
		// layer.addChild(bgRectNode);


		const drawLayer = new cc.Node();
    this.debugLayer.addChild(drawLayer, 2);

    this.debugDrawLayer = drawLayer;



	},

	initDebugRect() {

		console.log(' in initDebugRect');

		
		this.linkRectGroup = [];
		this.data.hotZoneItemArr2.forEach((item) => {
			switch (item.gIdx) {
				case "0":
					this.setOneDebugLinkRect(item);
					break;

				// case "1":
				// 	this.setOneDebugWriteRect(item);
				// 	break;

				default:
					break;
			}

		});
	

	},

	setOneDebugLinkRect(data) {
		const rate = (this.debugLayer.scale * this.debugLayer.width) / this.data.bgItem2.rect.width;
	
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.debugLayer.addChild(rectNode);

		let ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.debugLayer.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.height * scale - data.rect.y * scale;
	

		rectNode.anchorX = 0;
		rectNode.anchorY = 0;

		if (this.data.isDebug) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();


		rectNode['data'] = data;
		rectNode.opacity = 100;

		rectNode['ccRect'] = rectNode.getBoundingBoxToWorld()


		rectNode.isRightPoint = data.checkbox.list[0].value == true;

		this.linkRectGroup.push(rectNode);

		this.setLinkDataByDebugItem(rectNode, data.index);

	},

	setLinkDataByDebugItem(item, index) {

		let hzItemId;
		let debugItemId;
		let linkHzItemId;
		let linkDebugItemId;


		debugItemId = index + 1;

		const hzItem = this.getHzItemByPoint(debugItemId)

		hzItemId = this.data.hotZoneItemArr.indexOf(hzItem) + 1;

		console.log(' hzItem: ', hzItem);
		console.log(' debugItemId: ', debugItemId);

		linkHzItemId = hzItem.linkItem;

		const linkHzItem = this.data.hotZoneItemArr[linkHzItemId-1]

		linkDebugItemId = linkHzItem.pointItem;


		const linkData = {hzItemId, debugItemId, linkHzItemId, linkDebugItemId};
		item.linkData = linkData;

	},

	getHzItemByPoint(pointId, gidx = '0') {
		
		const hzItem = this.data.hotZoneItemArr.find((item) => {

			if (item.gIdx == gidx) {
				return item.pointItem == pointId
			}
		});

		return hzItem;
	},

	addSignItem() {
		if (!this.signRectArr) {
			return;
		}

		this.signRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.signRectArr.length; i++) {
			const oneData = this.signRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.signRectCheckArr.push(rect);
			console.log('oneData: ', oneData);
		}
	},

	addCircleItem() {

		if (!this.circleRectArr) {
			return;
		}

		this.circleRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.circleRectArr.length; i++) {
			const oneData = this.circleRectArr[i];
			const rect = this.setDebugRectDot(oneData, bg);
			this.circleRectCheckArr.push(rect);
			console.log('oneData: ', oneData);
		}
	},


	setDebugRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'blue');
		colorRect.opacity = 180;
		colorRect.data = data;
		bg.addChild(colorRect, 20);

		return colorRect;
	},

	addNewRect() {
		
		if (!this.newRectArr) {
			return;
		}

		this.newRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.newRectArr.length; i++) {
			const oneData = this.newRectArr[i];
			this.setNewRectDot(oneData, bg);
			console.log('oneData: ', oneData);
		}

	},


	setNewRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'green');
		colorRect.opacity = 180;
		colorRect.data = data;
		bg.addChild(colorRect, 20);

		this.newRectCheckArr.push(colorRect);                                                                                                                                                                                        


		// if (this.data.bgItem.isShowDebugLine || true) {
		// 	ctx.rect(0, 0, rectNode.width, rectNode.height);
		// }
		// ctx.stroke();
		// ctx.fill();

	},
	 


	getPhotoWordArr(text, block, benchmark1Data) {


		const wordArr = [];
		// const maxLen = 10;

		text = text.trim();

		const topY = -benchmark1Data.top;

		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}


			const sentence = line.content;
			if (sentence.indexOf(text) != -1 ) {
				wordArr.push( line );
			}

			// for (let i=0; i<line.length; i++) {


			// 	const location = line[i].word[0].location;

			// 	const curTop = -location.top;
			// 	if (curTop >= topY ) {
			// 		continue;
			// 	}


			// 	let word = line[i].word;
			// 	let sentence = ''

			// 	// if (word.length > maxLen) {
			// 	// 	console.log('continue ', word.length);
			// 	// 	continue;
			// 	// }

			// 	line[i].word = word = this.checkCutWordData(word);
			// 	// console.log('word1~ ', word);


			// 	word.forEach(item => {
			// 		sentence += item.content + '';
			// 	});

			// 	sentence = sentence.trim().toLowerCase();

			// 	text = text.toLowerCase();

			// 	line[i].sentence = sentence;
			// 	console.log('sentence: ', sentence);
			// 	console.log('text: ', text);

			// 	console.log('index: ', sentence.indexOf(text));
			// 	if (sentence.indexOf(text) != -1 ) {
			// 		wordArr.push( line[i] );
			// 	}
			// }
		}

		return wordArr;
	},


	checkCutWordData(wordArr) {


		// console.log('wordArr: ', wordArr);

		let newWordArr = [];
		for(let i=0; i<wordArr.length; i++) {

			let wordObj = wordArr[i];

			wordObj.content = wordObj.content.trim();

			if (wordObj.content.length > 1) {

				const tmpArr = [];
				const w = wordObj.location.right - wordObj.location.left
				const subW = w / wordObj.content.length;
				for (let j=0; j<wordObj.content.length; j++) {

					const subWordObj = {};
					subWordObj.content = wordObj.content[j];
					subWordObj.location = {
						top: wordObj.location.top,
						bottom: wordObj.location.bottom,
						left: wordObj.location.left + subW * j,
						right: wordObj.location.left + subW * (j + 1)
					}

					tmpArr.push(subWordObj);
				}
				newWordArr = newWordArr.concat(tmpArr)


			} else {
				newWordArr.push(wordObj)
			}

		}

		// console.log('newWordArr: ', newWordArr);
		return newWordArr;
	},

	getPhotoData(cb) {
	

		

		const tmpData1 = {"result":{"text":[{"left":0.4309999942779541,"right":0.5609999895095825,"top":0.5094433426856995,"bottom":0.5751649737358093,"score":0.8339493274688721,"content":"Cc","characters":[{"character":"C","centerLoc":[0.47766668,0.53908247],"poly":[0.45433334,0.50944334,0.50266665,0.50944334,0.50266665,0.56872165,0.45433334,0.56872165]},{"character":"c","centerLoc":[0.531,0.55068046],"poly":[0.5126667,0.53135055,0.551,0.53135055,0.551,0.56872165,0.5126667,0.56872165]}]}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.4259999990463257,"right":0.5609999895095825,"top":0.5081546306610107,"bottom":0.5777422785758972,"score":0.8703044652938843,"content":"Cc","characters":[{"character":"C","centerLoc":[0.476,0.5377938],"poly":[0.451,0.50815463,0.501,0.50815463,0.501,0.56872165,0.451,0.56872165]},{"character":"c","centerLoc":[0.5276667,0.54939175],"poly":[0.5093334,0.53135055,0.54766667,0.53135055,0.54766667,0.56872165,0.5093334,0.56872165]}]}]}}
		// const tmpData1 =  {"result":{"text":[{"points":[0.749,0.505,0.601,0.522]}]}}
		// const tmpData1 = {"result":{"text":[{"symbol":[4,2,3,3,3]}]}};
		// const tmpData1 = {"result":{"text":[{"points":[0.20666666,0.45618558,0.21,0.45618558,0.21333334,0.45618558,0.21666667,0.45618558,0.22,0.45618558,0.22333333,0.45618558,0.22666667,0.45618558,0.23,0.45618558,0.23333333,0.45618558,0.2,0.45876288,0.20333333,0.45876288,0.20666666,0.45876288,0.21,0.45876288,0.21333334,0.45876288,0.21666667,0.45876288,0.22,0.45876288,0.22333333,0.45876288,0.22666667,0.45876288,0.23,0.45876288,0.23333333,0.45876288,0.23666666,0.45876288,0.24,0.45876288,0.19,0.46134022,0.19333333,0.46134022,0.19666667,0.46134022,0.2,0.46134022,0.20333333,0.46134022,0.20666666,0.46134022,0.21,0.46134022,0.21333334,0.46134022,0.21666667,0.46134022,0.22,0.46134022,0.22333333,0.46134022,0.22666667,0.46134022,0.23,0.46134022,0.23333333,0.46134022,0.23666666,0.46134022,0.24,0.46134022,0.24333334,0.46134022,0.24666667,0.46134022,0.25,0.46134022,0.17666666,0.46391752,0.18333334,0.46391752,0.18666667,0.46391752,0.19,0.46391752,0.19333333,0.46391752,0.19666667,0.46391752,0.24333334,0.46391752,0.24666667,0.46391752,0.25,0.46391752,0.25333333,0.46391752,0.25666666,0.46391752,0.26333332,0.46391752,0.17333333,0.46649486,0.17666666,0.46649486,0.18,0.46649486,0.18333334,0.46649486,0.25666666,0.46649486,0.26,0.46649486,0.26333332,0.46649486,0.26666668,0.46649486,0.17,0.46907216,0.17333333,0.46907216,0.17666666,0.46907216,0.26333332,0.46907216,0.26666668,0.46907216,0.27,0.46907216,0.16333333,0.4716495,0.16666667,0.4716495,0.17,0.4716495,0.17333333,0.4716495,0.26666668,0.4716495,0.27,0.4716495,0.27333334,0.4716495,0.27666667,0.4716495,0.16,0.4742268,0.16333333,0.4742268,0.16666667,0.4742268,0.27333334,0.4742268,0.27666667,0.4742268,0.28,0.4742268,0.15666667,0.47680414,0.16,0.47680414,0.16333333,0.47680414,0.27666667,0.47680414,0.28,0.47680414,0.28333333,0.47680414,0.15666667,0.47938144,0.16,0.47938144,0.28,0.47938144,0.28333333,0.47938144,0.15333334,0.48195878,0.15666667,0.48195878,0.28333333,0.48195878,0.28666666,0.48195878,0.14666666,0.48453608,0.15,0.48453608,0.15333334,0.48453608,0.28666666,0.48453608,0.29,0.48453608,0.29333332,0.48453608,0.14666666,0.48711342,0.15,0.48711342,0.15333334,0.48711342,0.28666666,0.48711342,0.29,0.48711342,0.29333332,0.48711342,0.14333333,0.48969072,0.14666666,0.48969072,0.15,0.48969072,0.29,0.48969072,0.29333332,0.48969072,0.29666665,0.48969072,0.14333333,0.49226806,0.14666666,0.49226806,0.29333332,0.49226806,0.29666665,0.49226806,0.14333333,0.49484536,0.29666665,0.49484536,0.14,0.4974227,0.14333333,0.4974227,0.29666665,0.4974227,0.3,0.4974227,0.14,0.5,0.3,0.5,0.13666667,0.5025773,0.14,0.5025773,0.3,0.5025773,0.30333334,0.5025773,0.13666667,0.5051546,0.14,0.5051546,0.3,0.5051546,0.30333334,0.5051546,0.13333334,0.507732,0.13666667,0.507732,0.14,0.507732,0.3,0.507732,0.30333334,0.507732,0.30666667,0.507732,0.13333334,0.5103093,0.13666667,0.5103093,0.30333334,0.5103093,0.30666667,0.5103093,0.13333334,0.5128866,0.13666667,0.5128866,0.30333334,0.5128866,0.30666667,0.5128866,0.13333334,0.5154639,0.13666667,0.5154639,0.30333334,0.5154639,0.30666667,0.5154639,0.13333334,0.51804125,0.13666667,0.51804125,0.30333334,0.51804125,0.30666667,0.51804125,0.13333334,0.52061856,0.13666667,0.52061856,0.30333334,0.52061856,0.30666667,0.52061856,0.13333334,0.52319586,0.13666667,0.52319586,0.30333334,0.52319586,0.30666667,0.52319586,0.13,0.52577317,0.13333334,0.52577317,0.13666667,0.52577317,0.30333334,0.52577317,0.30666667,0.52577317,0.31,0.52577317,0.13333334,0.52835053,0.13666667,0.52835053,0.30333334,0.52835053,0.30666667,0.52835053,0.13333334,0.53092784,0.13666667,0.53092784,0.30333334,0.53092784,0.30666667,0.53092784,0.13333334,0.53350514,0.13666667,0.53350514,0.30333334,0.53350514,0.30666667,0.53350514,0.13333334,0.53608245,0.13666667,0.53608245,0.30333334,0.53608245,0.30666667,0.53608245,0.13333334,0.5386598,0.13666667,0.5386598,0.30333334,0.5386598,0.30666667,0.5386598,0.13333334,0.5412371,0.13666667,0.5412371,0.30333334,0.5412371,0.30666667,0.5412371,0.13333334,0.5438144,0.13666667,0.5438144,0.14,0.5438144,0.3,0.5438144,0.30333334,0.5438144,0.30666667,0.5438144,0.13666667,0.5463917,0.14,0.5463917,0.3,0.5463917,0.30333334,0.5463917,0.13666667,0.5489691,0.14,0.5489691,0.3,0.5489691,0.30333334,0.5489691,0.14,0.5515464,0.3,0.5515464,0.14,0.5541237,0.14333333,0.5541237,0.29666665,0.5541237,0.3,0.5541237,0.14333333,0.556701,0.29666665,0.556701,0.14333333,0.55927837,0.14666666,0.55927837,0.29333332,0.55927837,0.29666665,0.55927837,0.14333333,0.5618557,0.14666666,0.5618557,0.15,0.5618557,0.29,0.5618557,0.29333332,0.5618557,0.29666665,0.5618557,0.14666666,0.564433,0.15,0.564433,0.15333334,0.564433,0.28666666,0.564433,0.29,0.564433,0.29333332,0.564433,0.14666666,0.5670103,0.15,0.5670103,0.15333334,0.5670103,0.28666666,0.5670103,0.29,0.5670103,0.29333332,0.5670103,0.15333334,0.56958765,0.15666667,0.56958765,0.28333333,0.56958765,0.28666666,0.56958765,0.15666667,0.57216495,0.16,0.57216495,0.28,0.57216495,0.28333333,0.57216495,0.15666667,0.57474226,0.16,0.57474226,0.16333333,0.57474226,0.27666667,0.57474226,0.28,0.57474226,0.28333333,0.57474226,0.16,0.57731956,0.16333333,0.57731956,0.16666667,0.57731956,0.27333334,0.57731956,0.27666667,0.57731956,0.28,0.57731956,0.16333333,0.5798969,0.16666667,0.5798969,0.17,0.5798969,0.17333333,0.5798969,0.26666668,0.5798969,0.27,0.5798969,0.27333334,0.5798969,0.27666667,0.5798969,0.17,0.58247423,0.17333333,0.58247423,0.17666666,0.58247423,0.26333332,0.58247423,0.26666668,0.58247423,0.27,0.58247423,0.17333333,0.58505154,0.17666666,0.58505154,0.18,0.58505154,0.18333334,0.58505154,0.25666666,0.58505154,0.26,0.58505154,0.26333332,0.58505154,0.26666668,0.58505154,0.17666666,0.58762884,0.18333334,0.58762884,0.18666667,0.58762884,0.19,0.58762884,0.19333333,0.58762884,0.19666667,0.58762884,0.24333334,0.58762884,0.24666667,0.58762884,0.25,0.58762884,0.25333333,0.58762884,0.25666666,0.58762884,0.26333332,0.58762884,0.19,0.5902062,0.19333333,0.5902062,0.19666667,0.5902062,0.2,0.5902062,0.20333333,0.5902062,0.20666666,0.5902062,0.21,0.5902062,0.21333334,0.5902062,0.21666667,0.5902062,0.22,0.5902062,0.22333333,0.5902062,0.22666667,0.5902062,0.23,0.5902062,0.23333333,0.5902062,0.23666666,0.5902062,0.24,0.5902062,0.24333334,0.5902062,0.24666667,0.5902062,0.25,0.5902062,0.2,0.5927835,0.20333333,0.5927835,0.20666666,0.5927835,0.21,0.5927835,0.21333334,0.5927835,0.21666667,0.5927835,0.22,0.5927835,0.22333333,0.5927835,0.22666667,0.5927835,0.23,0.5927835,0.23333333,0.5927835,0.23666666,0.5927835,0.24,0.5927835,0.20666666,0.5953608,0.21,0.5953608,0.21333334,0.5953608,0.21666667,0.5953608,0.22,0.5953608,0.22333333,0.5953608,0.22666667,0.5953608,0.23,0.5953608,0.23333333,0.5953608]}]}}


		// const tmpData1 = {"result":{"text":[{"type":1,"points":[0.23666666,0.45360824,0.24,0.45360824,0.22,0.45618558,0.22333333,0.45618558,0.22666667,0.45618558,0.23,0.45618558,0.23333333,0.45618558,0.24333334,0.45618558,0.24666667,0.45618558,0.25,0.45618558,0.25333333,0.45618558,0.25666666,0.45618558,0.26,0.45618558,0.20666666,0.45876288,0.21,0.45876288,0.21333334,0.45876288,0.21666667,0.45876288,0.26333332,0.45876288,0.26666668,0.45876288,0.27,0.45876288,0.27333334,0.45876288,0.19666667,0.46134022,0.2,0.46134022,0.20333333,0.46134022,0.27666667,0.46134022,0.28,0.46134022,0.28333333,0.46134022,0.17666666,0.46391752,0.18,0.46391752,0.18333334,0.46391752,0.18666667,0.46391752,0.19,0.46391752,0.19333333,0.46391752,0.28666666,0.46391752,0.29,0.46391752,0.29333332,0.46391752,0.29666665,0.46391752,0.3,0.46391752,0.30333334,0.46391752,0.30666667,0.46391752,0.31,0.46391752,0.31333333,0.46391752,0.31666666,0.46391752,0.32,0.46391752,0.32333332,0.46391752,0.32666665,0.46391752,0.17,0.46649486,0.17333333,0.46649486,0.28666666,0.46649486,0.33,0.46649486,0.33333334,0.46649486,0.33666667,0.46649486,0.34,0.46649486,0.34333333,0.46649486,0.34666666,0.46649486,0.35,0.46649486,0.35333332,0.46649486,0.35666665,0.46649486,0.36,0.46649486,0.36333334,0.46649486,0.36666667,0.46649486,0.37,0.46649486,0.16666667,0.46907216,0.28666666,0.46907216,0.16333333,0.4716495,0.28666666,0.4716495,0.16333333,0.4742268,0.28666666,0.4742268,0.16333333,0.47680414,0.28666666,0.47680414,0.16,0.47938144,0.28666666,0.47938144,0.16,0.48195878,0.28666666,0.48195878,0.16,0.48453608,0.28666666,0.48453608,0.16,0.48711342,0.29,0.48711342,0.15666667,0.48969072,0.29,0.48969072,0.15333334,0.49226806,0.29,0.49226806,0.15333334,0.49484536,0.29,0.49484536,0.15333334,0.4974227,0.29,0.4974227,0.15,0.5,0.29,0.5,0.15,0.5025773,0.29,0.5025773,0.15,0.5051546,0.29,0.5051546,0.15,0.507732,0.28666666,0.507732,0.15,0.5103093,0.28666666,0.5103093,0.15,0.5128866,0.28666666,0.5128866,0.15,0.5154639,0.28666666,0.5154639,0.15,0.51804125,0.28666666,0.51804125,0.15,0.52061856,0.28666666,0.52061856,0.15,0.52319586,0.28333333,0.52319586,0.15333334,0.52577317,0.28333333,0.52577317,0.15333334,0.52835053,0.28,0.52835053,0.15333334,0.53092784,0.27666667,0.53092784,0.15333334,0.53350514,0.27333334,0.53350514,0.15333334,0.53608245,0.26666668,0.53608245,0.27,0.53608245,0.15333334,0.5386598,0.25666666,0.5386598,0.26,0.5386598,0.26333332,0.5386598,0.15666667,0.5412371,0.25,0.5412371,0.25333333,0.5412371,0.15666667,0.5438144,0.24333334,0.5438144,0.24666667,0.5438144,0.15666667,0.5463917,0.23333333,0.5463917,0.23666666,0.5463917,0.24,0.5463917,0.16,0.5489691,0.23,0.5489691,0.16333333,0.5515464,0.22333333,0.5515464,0.22666667,0.5515464,0.16666667,0.5541237,0.17,0.5541237,0.17333333,0.5541237,0.17666666,0.5541237,0.18,0.5541237,0.18333334,0.5541237,0.18666667,0.5541237,0.19,0.5541237,0.19333333,0.5541237,0.19666667,0.5541237,0.2,0.5541237,0.20333333,0.5541237,0.20666666,0.5541237,0.21,0.5541237,0.21333334,0.5541237,0.21666667,0.5541237,0.22,0.5541237]}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.22833333909511566,"right":0.3166666626930237,"top":0.5590206384658813,"bottom":0.628608226776123,"score":0.8552894592285156,"content":"Aa"},{"left":0.6816666126251221,"right":0.7666666507720947,"top":0.42257729172706604,"bottom":0.49860823154449463,"score":0.8148108720779419,"content":"Aa"},{"left":0.6983333230018616,"right":0.7666666507720947,"top":0.5564433336257935,"bottom":0.628608226776123,"score":0.7532452344894409,"content":"Aa"}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.09814612567424774,"right":0.4471101462841034,"top":0.006644518114626408,"bottom":0.15614618360996246,"score":1,"content":"CTrace,write,and say."},{"left":0.10796073824167252,"right":0.5049073100090027,"top":0.1827242523431778,"bottom":0.4518272280693054,"score":0.9702169299125671,"content":"AAAA"},{"left":0.5834242105484009,"right":0.659760057926178,"top":0.17607973515987396,"bottom":0.4485049843788147,"score":0.9523985981941223,"content":"A"},{"left":0.6706652045249939,"right":0.8298800587654114,"top":0.15614618360996246,"bottom":0.43853819370269775,"score":0.9089533090591431,"content":"A"},{"left":0.5866957306861877,"right":0.6521264910697937,"top":0.634551465511322,"bottom":0.8504983186721802,"score":0.8326067328453064,"content":"a"},{"left":0.7699018716812134,"right":0.8276990056037903,"top":0.6411960124969482,"bottom":0.8039867281913757,"score":0.8035371899604797,"content":"a"}]}}
		cb(tmpData1);
		return;
	// const tmpData = {"allText":"Look and Trace\nblackboard\nwindow","block":[{"line":[{"word":[{"content":"Look","cornerPoint":[{"x":87,"y":203},{"x":83,"y":166},{"x":93,"y":164},{"x":97,"y":201}],"location":{"bottom":97,"left":85,"right":124,"top":83},"recognizedLanguage":"und"},{"content":"and","cornerPoint":[{"x":85,"y":161},{"x":82,"y":138},{"x":90,"y":137},{"x":93,"y":160}],"location":{"bottom":93,"left":127,"right":151,"top":82},"recognizedLanguage":"und"},{"content":"Trace","cornerPoint":[{"x":81,"y":132},{"x":77,"y":96},{"x":86,"y":95},{"x":90,"y":131}],"location":{"bottom":90,"left":156,"right":193,"top":77},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"blackboard","cornerPoint":[{"x":119,"y":129},{"x":116,"y":58},{"x":131,"y":57},{"x":134,"y":128}],"location":{"bottom":134,"left":159,"right":231,"top":116},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"window","cornerPoint":[{"x":171,"y":123},{"x":166,"y":72},{"x":177,"y":70},{"x":182,"y":121}],"location":{"bottom":182,"left":165,"right":218,"top":166},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"Trace ttre letters\nLook! She is Short\nShe is a\ngirl.\nShe is a\ngirl.\nShe is smiling. She is","block":[{"line":[{"word":[{"content":"Trace","cornerPoint":[{"x":460,"y":366},{"x":416,"y":366},{"x":416,"y":354},{"x":460,"y":354}],"location":{"bottom":126,"left":20,"right":64,"top":114},"recognizedLanguage":"und"},{"content":"ttre","cornerPoint":[{"x":412,"y":367},{"x":387,"y":367},{"x":387,"y":354},{"x":412,"y":354}],"location":{"bottom":126,"left":68,"right":93,"top":113},"recognizedLanguage":"und"},{"content":"letters","cornerPoint":[{"x":384,"y":367},{"x":334,"y":367},{"x":334,"y":354},{"x":384,"y":354}],"location":{"bottom":126,"left":96,"right":146,"top":113},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Look!","cornerPoint":[{"x":340,"y":316},{"x":300,"y":318},{"x":299,"y":305},{"x":339,"y":303}],"location":{"bottom":177,"left":140,"right":181,"top":162},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"e-Tnace the lettEr5\nAa Aa\nAa\nB b Bb Bbb\nBb\nCc\nCc","block":[{"line":[{"word":[{"content":"e-Tnace","cornerPoint":[{"x":399,"y":393},{"x":317,"y":395},{"x":316,"y":379},{"x":398,"y":377}],"location":{"bottom":103,"left":81,"right":164,"top":85},"recognizedLanguage":"und"},{"content":"the","cornerPoint":[{"x":313,"y":396},{"x":282,"y":396},{"x":281,"y":380},{"x":312,"y":380}],"location":{"bottom":100,"left":167,"right":199,"top":84},"recognizedLanguage":"und"},{"content":"lettEr5","cornerPoint":[{"x":278,"y":397},{"x":217,"y":398},{"x":216,"y":382},{"x":277,"y":381}],"location":{"bottom":99,"left":202,"right":264,"top":82},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Aa","cornerPoint":[{"x":436,"y":362},{"x":349,"y":363},{"x":348,"y":322},{"x":435,"y":321}],"location":{"bottom":159,"left":44,"right":132,"top":117},"recognizedLanguage":"und"}]}]}]}

		cb(tmpData);
	},


	checkGameEnd( arr ) {

		console.log(' in checkGameEnd arr.length: ', arr.length);
		if (!arr) {
			arr = this.animaNodeArr;
		}
		const isEnd = arr.every(node => {
			return node.isShowEnd;
		})

		if (isEnd) {
			this.gameEnd();
		} else {


			// this.endTesting();

			// setTimeout(() => {
			// 	this.startTesting();
			// }, 8000);

		}
	},














	bigStarArr: null,
	initStar() {
		const gArr = this.data.groupArr;
		if (gArr.length <= 1) {
			return;
		}

		this.cleanStar();

		this.bigStarArr = [];

		let baseX = this.canvas.width / 2 - 80 * this._mapScaleMin;
		let baseY = this.canvas.height / 2 - 80 * this._mapScaleMin;
		let disH = 80 * this._mapScaleMin;
		let disScale = 1;
		if (gArr.length > 5) {
			disH = (400 / gArr.length) * this._mapScaleMin;
			disScale = 5 / gArr.length;
		}
		for (let i = 0; i < gArr.length; i++) {
			const starBg = getSprNode('star_bg');
			this.canvas.addChild(starBg, 10);
			starBg.x = baseX;
			starBg.y = baseY - i * disH;
			starBg.scale = disScale;

			const starTop = getSprNode('star');
			starBg.addChild(starTop);
			starTop.active = false;
			starBg.star = starTop;

			const starBig = getSprNode('icon_bigstar');
			starTop.addChild(starBig);
			starBig.angle = -90;
			starBg.starBig = starBig;

			this.bigStarArr.push(starBg);
		}

		console.log("bigStarArr: ", this.bigStarArr);
	},

	cleanStar() {
		if (this.bigStarArr && this.bigStarArr.length > 0) {
			for (let i=0; i<this.bigStarArr.length; i++) {
				this.bigStarArr[i].removeFromParent();
			}
		}
	},


	showBigStar() {
		if (!this.bigStarArr || this.bigStarArr.length <= 0) {
			this.checkGameEnd();
			return;
		}
		const bigStarBg = this.bigStarArr[this.curGroupIndex];

		const starBig = bigStarBg.starBig;
		starBig.scale = 1;
		const star = bigStarBg.star;
		star.active = true;
		star.scaleX = 0.7 / bigStarBg.scale;
		star.scaleY = 1 / bigStarBg.scale;
		star.angle = 90;
		const canvas = cc.find('Canvas');
		const startPos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 2));
		const middlePos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 4));
		star.x = startPos.x;
		star.y = startPos.y - starBig.height;

		console.log('middlePos = ' + JSON.stringify(middlePos));
		const time = 1;
		cc.tween(star)
			.to(0.3, { y: middlePos.y + 80 }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y + 40, scaleX: 1.2 / bigStarBg.scale, scaleY: 0.8 / bigStarBg.scale }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y, scaleX: 1 / bigStarBg.scale, scaleY: 1 / bigStarBg.scale }, { easing: 'quadOut' })
			.delay(0.1)
			.to(0.8, { angle: -720, scale: 1 })
			.start();

		cc.tween(star)
			.delay(0.6)
			.to(0.8, { x: 0 }, { easing: 'quadIn' })
			.start();
		cc.tween(star)
			.delay(0.6)
			.to(0.8, { y: 0 }, { easing: 'quadOut' })
			.start();

		cc.tween(starBig)
			.delay(0.6)
			.to(0.8, { scale: 0 }, { easing: 'quadOut' })
			.call(() => {
				this.checkGameEnd();
				playAudio(this.starCountClip);
			})
			.start();

		playAudio(this.bigStarClip);
	},

	// checkGameEnd() {
	
	// 	this.curGroupIndex ++;
	// 	this.setCurGroupAndQuestion();



	// 	if (!this.curQuestionData) {
	// 		// this.gameEnd();
	// 		return;
	// 	}

	// 	this.showChangeQuesAnim();
	// },

	


	checkBtn: null,
	initBtn() {
		const checkBtn = getSprNode("btn_check");
		checkBtn.scale = this._mapScaleMin;
		this.canvas.addChild(checkBtn);
		checkBtn.x = -500 * this._mapScaleMin;
		checkBtn.y = -35 * this._mapScaleMin;
		checkBtn.baseX = checkBtn.x;
		checkBtn.baseY = checkBtn.y;
		checkBtn.opacity = 0;
		this.checkBtn = checkBtn;

		checkBtn.on(cc.Node.EventType.TOUCH_START, () => {
			if (checkBtn.opacity == 0) {
				return;
			}
			showBtnAnima(checkBtn);
			this.checkBtnClick();
		})

	},

	refreshCheckBtn() {

		this.checkBtn.opacity = 0;

		const arr = this.curOptionArr;
		for (let i=0; i<arr.length; i++) {
			if (arr[i].light.opacity > 254) {
				this.checkBtn.opacity = 255;
				return;
			}
		}
	},

	tryagain: null,
	initIcon() {
		const icon = getSprNode("try_again");
		icon.opacity = 0;
		icon.scale = this._mapScaleMin;
		this.canvas.addChild(icon);

		this.tryagain = icon;
	},

	showTryAgain() {
		const time = 0.3;
		cc.tween(this.tryagain)
			.to(time, {opacity: 255}, {easing: "cubicOut"})
			.delay(0.3)
			.to(time, {opacity: 0}, {easing: "cubicIn"})
			.start();
	},


	initQuestion() {
		this.initPicQuestion();
		this.initTextQuestion();
		this.initVideoQuestion();
		this.initAudioQuestion();
	},

	quesPicBg: null,
	initPicQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesPicBg = picBg;
		picBg.active = false;

		this.addQuesAudio(picBg)
	},

	quesTextBg: null,
	initTextQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesTextBg = picBg;


		const labelNode = new cc.Node();
		labelNode.parent = picBg;
		const label = labelNode.addComponent(cc.RichText);
		const size = 80
		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		// label.string = `<outline color=#a83c13 width=2><size=${size}><color=#ffffff>${this.data.title || " " }</color></size></outline>`
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.CENTER

		label.maxWidth = 648;
	
		picBg.label = label;

		picBg.active = false;
		this.addQuesAudio(picBg)
	},

	quesVideoBg: null,
	videoNode: null,
	initVideoQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesVideoBg = picBg;

		const videoNode = new cc.Node();
		const vPlayer = videoNode.addComponent(cc.VideoPlayer);
		picBg.addChild(videoNode);

		videoNode.width = 678;
		videoNode.height = 396;
		this.videoNode = videoNode;

		picBg.video = vPlayer;


		const btnNode = new cc.Node();
		picBg.addChild(btnNode);
		btnNode.x = picBg.width / 2 + 50;

		const playBtn = getSprNode("video_play");
		btnNode.addChild(playBtn);

		const pauseBtn = getSprNode("video_pause");
		btnNode.addChild(pauseBtn);
		pauseBtn.active = false;


		videoNode.player = vPlayer;
		videoNode.playBtn = playBtn;
		videoNode.pauseBtn = pauseBtn;

		playBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.play();
			playBtn.active = false;
			pauseBtn.active = true;
		})

		pauseBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.pause();
			pauseBtn.active = false;
			playBtn.active = true;
		})

		videoNode.on('completed', () => {
			pauseBtn.active = false;
			playBtn.active = true;
		})


		picBg.active = false;
	},

	quesAudioBg: null,
	initAudioQuestion() {

		
		const audioNode = new cc.Node();
		audioNode.active = false;

		this.canvas.addChild(audioNode);
		audioNode.x = 440 * this._mapScaleMin;
		audioNode.y = -60 * this._mapScaleMin;
		this.quesAudioBg = audioNode;
		
		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/audio_big"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('audio_big')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}

			if (!audioNode.audioClip) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('audio_big');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

	},


	addQuesAudio(bg) {
		const audioNode = new cc.Node();
		bg.addChild(audioNode);
		audioNode.x = bg.width / 2 + 50;


		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/ques_audio"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('ques_audio')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('ques_audio');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

		bg.audioNode = audioNode;
	},

	initOption() {
		this.initPicOption();
		this.initAudioOption();
		this.initTextOption();

		this.initPicOptionBig();
		this.initAudioOptionBig();
		this.initTextOptionBig();
	},

	optionPicBgArr: null,
	initPicOption() {
		// console.log('this.data: ', this.data);
		this.optionPicBgArr = [];
		for (let i=0; i<4; i++) {
		
			const pic = this.getOnePicOption();
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.y = -235 * this._mapScaleMin;
			this.optionPicBgArr.push(pic);

		} 
	},

	optionPicBgBigArr: null,
	initPicOptionBig() {
		this.optionPicBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;


		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}
			const pic = this.getOnePicOption(true);
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.x = baseX + count * disW;
			pic.y = baseY;
			this.optionPicBgBigArr.push(pic);

			count ++;
		} 
	},

	getOnePicOption(isBig = false) {
		const picBgParent = new cc.Node();

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const light = getSprNode(lightResName);
		picBgParent.addChild(light);
		light.opacity = 0;
		picBgParent.light = light;

		const picBg = getSprNode(bgResName);
		picBgParent.addChild(picBg);
		picBgParent.picBg = picBg;

		picBgParent.width = picBg.width;
		picBgParent.height = picBg.height;


		const soundNode = new cc.Node();
		picBgParent.addChild(soundNode);
		picBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = picBgParent.width / 2 - soundIconTop.width / 2;
		soundNode.y = picBgParent.height / 2 //- soundIconTop.height / 2;
		soundNode.active = false;


		picBgParent.active = false;


		picBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}

			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return picBgParent;
	},

	addIconRight(bg) {

		const px = bg.width / 2;
		const py = -bg.height / 2 ;
		const worldPos = bg.convertToWorldSpaceAR(cc.v2(px, py));
		const localPos = this.canvas.convertToNodeSpaceAR(worldPos);


		const iconRight = getSprNode('icon_right');
		iconRight.scale = this._mapScaleMin;
		this.canvas.addChild(iconRight, 1);
		iconRight.x = localPos.x;
		iconRight.y = localPos.y + 50 * this._mapScaleMin;

		bg.iconRight = iconRight;


		this.showOneFirework(cc.v2(0, -bg.height / 3), bg, cc.find('paperBase').children, 200, 300, 20, 1);
	},


	optionAudioBgArr: null,
	initAudioOption() {
		this.optionAudioBgArr = [];
		for (let i=0; i<4; i++) {
		
			const audio = this.getOneAudioOption();
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.y = -235 * this._mapScaleMin;
			this.optionAudioBgArr.push(audio);
		} 
	},

	optionAudioBgBigArr: null,
	initAudioOptionBig() {

		this.optionAudioBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;

		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}

			const audio = this.getOneAudioOption(true);
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.x = baseX + count * disW;
			audio.y = baseY;
			this.optionAudioBgBigArr.push(audio);

			count ++;
		} 
	},


	optionTextBgArr: null,
	initTextOption() {
		this.optionTextBgArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption();
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			// textOption.y = -235 * this._mapScaleMin;
			this.optionTextBgArr.push(textOption);
		} 
	},

	optionTextBgBigArr: null,
	initTextOptionBig() {

		const baseX = -180 * this._mapScaleMin;
		const disW = 100 * this._mapScaleMin;
		let baseY = 220 * this._mapScaleMin;
		const disH = 150 * this._mapScaleMin;

		this.optionTextBgBigArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption(true);
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			textOption.x = baseX;
			textOption.y = baseY - i * disH;
			this.optionTextBgBigArr.push(textOption);
		}
	},

	getOneAudioOption(isBig=false) {

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const audioBgNode = new cc.Node();

		const light = getSprNode(lightResName);
		audioBgNode.addChild(light);
		light.opacity = 0;
		audioBgNode.light = light;

		const picBg = getSprNode(bgResName);
		audioBgNode.addChild(picBg);
		audioBgNode.picBg = picBg;

		audioBgNode.width = picBg.width;
		audioBgNode.height = picBg.height;

		const animNode = cc.instantiate(cc.find("Canvas/res/anim/op_audio"))
		audioBgNode.addChild(animNode);
		animNode.anchorX = 0.6;


		const animTop = getSprNode('op_audio');
		audioBgNode.addChild(animTop);
		animTop.anchorX = 0.6;

		const anim = animNode.getComponent(cc.Animation);
		animNode.opacity = 0;

		audioBgNode.anim = anim;
		audioBgNode.animNode = animNode;
		audioBgNode.animTop = animTop;
		
		audioBgNode.showAnim = () => {
			this.playItemAnim(audioBgNode);
			cc.audioEngine.stop(audioBgNode.audioId);
		}
		audioBgNode.stopAnim = () => {
			cc.audioEngine.stop(audioBgNode.audioId);
			this.stopItemAnim(audioBgNode);
		}

		audioBgNode.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
				
				audioBgNode.showAnim();
				if (audioBgNode.audioClip) {
					audioBgNode.audioId = playAudio(audioBgNode.audioClip, () => {
						this.stopItemAnim(audioBgNode);
					});
				}

			} else {
				light.opacity = 0;
				audioBgNode.stopAnim();
			}

			this.refreshCheckBtn();

		});

		audioBgNode.active = false;

		return audioBgNode;
	},

	getOneTextOption(isBig=false) {

		let lightResName = "option_text_bg_l";
		let bgResName = "option_text_bg";
		if (isBig) {
			lightResName = "op_text_bg_big_l";
			bgResName = "op_text_bg_big";
		}

		const textBgParent = new cc.Node();
		textBgParent.active = false;

		const light = getSprNode(lightResName);
		textBgParent.addChild(light);
		light.opacity = 0;
		textBgParent.light = light;

		const textBg = getSprNode(bgResName);
		textBgParent.addChild(textBg);
		textBgParent.textBg = textBg;

		textBgParent.width = textBg.width;
		textBgParent.height = textBg.height;

		const labelNode = new cc.Node();
		labelNode.parent = textBgParent;
		const label = labelNode.addComponent(cc.Label);

		label.fontSize = 56;
		label.lineHeight = 56;
		if (isBig) {
			label.fontSize = 64;
			label.lineHeight = 64;
		}

		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		textBgParent.label = label;

		const color = new cc.Color();
		cc.Color.fromHEX(color, '#023659' );
		labelNode.color = color;


		const soundNode = new cc.Node();
		textBgParent.addChild(soundNode);
		textBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = textBgParent.width / 2 - 15; // - soundIconTop.width / 2;
		soundNode.y = textBgParent.height / 2 - 15; //- soundIconTop.height / 2;
		soundNode.active = false;


		textBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}
			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return textBgParent;
	},

	playItemAnim(item) {
		item.anim.play();
		item.animNode.opacity = 255;
		item.animTop.opacity = 0;
	},

	stopItemAnim(item) {
		item.animNode.opacity = 0;
		item.animTop.opacity = 255;
	},

	setCurQuestion() {
		
		switch(this.curQuestionData.questionType) {
			case "pic":
				this.setQuestionPic();
				break;
			case "text":
				this.setQuestionText();
				break;
			case "video":
				this.setQuestionVideo();
				break;
			case "audio":
				this.setQuestionAudio();
				break;
		}

		this.refreshCheckBtnPos();
	},

	refreshCheckBtnPos() {
		if (this.curQuestionData.questionType == 'audio') {
			this.checkBtn.x = 440 * this._mapScaleMin;
			this.checkBtn.y = -240 * this._mapScaleMin;
		} else {
			this.checkBtn.x = this.checkBtn.baseX;
			this.checkBtn.y = this.checkBtn.baseY;
		}
	},

	curQuesBg: null,
	setQuestionPic() {

		this.curQuesBg = this.quesPicBg;
		this.curQuesBg.active = true;


		if (this.quesPicBg.pic) {
			this.quesPicBg.pic.removeFromParent();
			this.quesPicBg.pic = null;
		}
		if (this.curQuestionData.pic_url) {
			getSprNodeByUrl(this.curQuestionData.pic_url, (spr) => {
				const sprNode = spr.node;
				setSprNodeMaxLen(sprNode, 678, 396);
				this.quesPicBg.addChild(sprNode)
				this.quesPicBg.pic = sprNode;
			})
		}
	
		const audioNode = this.quesPicBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionText() {
		this.curQuesBg = this.quesTextBg;
		this.curQuesBg.active = true;

		
		const label = this.curQuesBg.label;
		const size = 80; 
		label.string = `<size=${size}><color=#fff4b6>${this.curQuestionData.text}</color></size>`

		const maxH = this.curQuesBg.height * 0.98;

		if (label.node.height > maxH) {
			label.node.scale = maxH / label.node.height
		} else {
			label.node.scale = 1;
		}


		const audioNode = this.curQuesBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionVideo() {
		this.curQuesBg = this.quesVideoBg;
		this.curQuesBg.active = true;
		this.videoNode.active = true;

		if (this.curQuestionData.video_url) {
			this.curQuesBg.video.remoteURL = this.curQuestionData.video_url;
		}
	},

	setQuestionAudio() {
		this.curQuesBg = this.quesAudioBg;
		this.curQuesBg.active = true;


		this.curQuesBg.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				this.curQuesBg.audioClip = audioClip;
			});
		}
	},



	setCurOption() {
		const arr = this.curQuestionData.answerArr;

		const isBig = this.curQuestionData.questionType == 'audio';

		switch(this.curQuestionData.answerType) {
			case "pic":
				this.setOptionPic(arr, isBig);
				break;
			case "audio":
				this.setOptionAudio(arr, isBig);
				break;
			case "text":
				this.setOptionText(arr, isBig);
				break;
		}
		
	},



	curOptionArr: null,
	setOptionPic(arr, isBig=false) {

		let opItemArr = this.optionPicBgArr;
		if (isBig) {
			opItemArr = this.optionPicBgBigArr;
		}
		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const picBg = opItemArr[i].picBg;
			picBg.removeAllChildren();
			
			const data = arr[i];
			if (data.pic_url) {
				getSprNodeByUrl, getSprNodeByUrl(data.pic_url, (spr) => {
					let maxW = 280;
					let maxH = 190;
					if (isBig) {
						maxW = 366;
						maxH = 248;
					}

					setSprNodeMaxLen(spr.node, maxW, maxH);
					console.log('spr: ', spr);
					picBg.addChild(spr.node);
				})
			}

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},


	setOptionAudio(arr, isBig=false) {

		let opItemArr = this.optionAudioBgArr;
		if (isBig) {
			opItemArr = this.optionAudioBgBigArr;
		}

		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if(!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const data = arr[i];

			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					opItemArr[i].audioClip = audioClip;
				});
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},

	setOptionAudioBig(arr) {
		this.curOptionArr = [];
		for (let i=0; i<arr.length; i++) {
			
			this.optionAudioBgArr[i].active = true;

			const data = arr[i];

			this.optionAudioBgArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					this.optionAudioBgArr[i].audioClip = audioClip;
				});
			}

			this.optionAudioBgArr[i].data = data;
			this.curOptionArr.push(this.optionAudioBgArr[i]);
		}
	},


	setOptionText(options, isBig=false) {

		console.log(' in setOptionText, isBig: ', isBig);

		let opItemArr = this.optionTextBgArr;
		if (isBig) {
			opItemArr = this.optionTextBgBigArr
		}

		this.curOptionArr = [];
		const disW = 315 * this._mapScaleMin;
		const disH = 120 * this._mapScaleMin;
		const baseX = - disW ;
		let baseY = -235 * this._mapScaleMin;
		if (options.length > 2) {
			baseY = -170 * this._mapScaleMin;
		}
		let count = 0;
		for (let i=0; i<options.length; i++) {

			if ( i == 2 ) {
				baseY -= disH;
				count = 0;
			}
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + count * disW * 2;
				opItemArr[i].y = baseY;
			}
		
			const data = options[i];

			opItemArr[i].label.string = data.text;
			opItemArr[i].label["_forceUpdateRenderData"](true);
			if (opItemArr[i].label.node.width > opItemArr[i].width * 0.9) {
				opItemArr[i].label.node.scale = opItemArr[i].width * 0.9 / opItemArr[i].label.node.width;
			} else {
				opItemArr[i].label.node.scale = 1;
			}
			

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);

			count++;
		}
	},



	shakeArr: null,
	wrongArr: null,
	checkBtnClick() {

		this.shakeArr = [];
		this.wrongArr = [];
		this.checkItemWrong();

		if (this.wrongArr.length > 0) {
			//有选错的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		const isRightAll = this.checkItemRightCount();
		if (!isRightAll) {
			// 有漏选的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		this.showAllRight();
		this.showMask();

		playAudio(this.rightClip, () => {
			this.playAnswerAudio(0);
		})
		
	},

	playAnswerAudio(index) {
		const arr = this.curOptionArr;
		if (!arr[index]) {

			// delayCall(0.5, () => {
				this.changeNextQuestion();
			// })

		} else {
			if ( arr[index].light.opacity > 254 && arr[index].audioClip ) {
				playAudio(arr[index].audioClip, () => {
					this.playAnswerAudio(index + 1);
				})
			} else {
				this.playAnswerAudio(index + 1);
			}
		}
	},


	checkItemWrong() {
		const arr = this.curOptionArr;
		console.log('arr: ', arr);
		for (let i=0; i<arr.length; i++) {
			const itemBg = arr[i];
			if (itemBg.light.opacity >= 254) {
				this.shakeArr.push(itemBg);
				console.log('aaa', itemBg.data);;
				if (itemBg.data.answerRight == '0') {
					this.wrongArr.push(itemBg);
				}
			}
		}
	},

	checkItemRightCount() {
		let rightTotalCount = 0;
		const answerArr = this.curQuestionData.answerArr;
		for (let i=0; i<answerArr.length; i++) {
			if (answerArr[i].answerRight == '1') {
				rightTotalCount ++;
			}
		}

		let curRightCount = 0;
		const curOptionArr = this.curOptionArr;
		for (let i=0; i<curOptionArr.length; i++) {
			if (curOptionArr[i].light.opacity > 254) {
				curRightCount ++;
			}
		}

		return rightTotalCount == curRightCount;
	},

	itemShake() {
		let rate = 1;
		if (this.curQuestionData.answerType == 'text') {
			rate = 0.5;
		}

		const arr = this.shakeArr;
		for (let i=0; i<arr.length; i++) {
			this.rotateShake(arr[i], rate);
			if (arr[i].stopAnim) {
				arr[i].stopAnim();
			}
		}

		this.showTryAgain();
	},

	hideLight() {
		const arr = this.curOptionArr;
		for (let i=0; i<arr.length; i++) {
			arr[i].light.opacity = 0;
		}
		this.checkBtn.opacity = 0;
	},

	rotateShake(item, rate = 1) {

		const time = 0.9;
		cc.tween(item)
			.to(time / 6 / 2, {angle: -20 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 12 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: -7 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 4 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: -2 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 1 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 0 * rate}, {easing: 'sineInOut'})
			.start();

	},

	showAllRight() {
		const curOptionArr = this.curOptionArr;
		for (let i=0; i<curOptionArr.length; i++) {
			if (curOptionArr[i].light.opacity > 254) {
				this.addIconRight(curOptionArr[i]);
			}
		}
	},

	changeNextQuestion() {
		console.log(' in changeNextQuestion')

		this.curQuestionIndex ++ ;
		this.setCurQuestionData();

		if (!this.curQuestionData) {
			// this.gameEnd();
			return;
		}

		this.showChangeQuesAnim();
	
	},

	showChangeQuesAnim() {
		this.hideLight();

		this.hideCurOptionAnim(() => {
			this.setCurOption();
			this.showCurOptionAnim();
			this.hideMask();
		});

		this.hideCurQuestion(() => {
			this.setCurQuestion();
			this.showCurQuestionAnim();
		});
	},


	maskLayer: null,
	initMask() {
		const maskLayer = new cc.Node();
		maskLayer.width = this.canvas.width;
		maskLayer.height = this.canvas.height;
		this.canvas.addChild(maskLayer, 20);

		maskLayer.addComponent(cc.BlockInputEvents);
		this.maskLayer = maskLayer;
		this.maskLayer.active = false;
	},

	showMask() {
		this.maskLayer.active = true;
	},

	hideMask() {
		this.maskLayer.active = false;
	},

	hideCurOptionAnim(cb) {
		const arr = this.curOptionArr;
		const time = 0.5;
		for (let i=0; i<arr.length; i++) {
			if (arr[i].iconRight) {
				arr[i].iconRight.removeFromParent();
				arr[i].iconRight = null;
			}
			cc.tween(arr[i])
				.to(time, {opacity: 0}, {easing: "cubicOut"})
				.call(() => {
					arr[i].active = false;
				})
				.start();
		}
		delayCall(time, () => {
			cb();
		})
	},

	showCurOptionAnim(cb=null) {
		const arr = this.curOptionArr;
		const time = 0.5;
		for (let i=0; i<arr.length; i++) {
			arr[i].opacity = 0;
			cc.tween(arr[i])
				.to(time, {opacity: 255}, {easing: "cubicIn"})
				.start();
		}

		if (cb) {
			delayCall(time, () => {
				cb();
			})
		}
	
	},

	hideCurQuestion(cb) {
		const time = 0.5;
		cc.tween(this.curQuesBg)
			.to(time, {opacity: 0}, {easing: "cubicOut"})
			.call(() => {
				this.curQuesBg.active = false;
				cb();
			})
			.start();
	},

	showCurQuestionAnim() {

		this.curQuesBg.active = true;
		this.curQuesBg.opacity = 0;

		const time = 0.5;
		cc.tween(this.curQuesBg)
			.to(time, {opacity: 255}, {easing: "cubicIn"})
			.start();
	},


	changeStep() {

		this.typeArrIndex ++;
		this.curCatAudioUrl = this.data.idle_2_audio_url;
		
		if (!this.data.change_step_audio_url) {
			this.startTesting();
			return;
		}
		playAudioByUrl(this.data.change_step_audio_url, () => {
			this.startTesting();
		})

	},

	gameEnd() {
		console.log('game end !')

		this.isGameEnd = true;
		this.endTesting();


		if (this.typeArrIndex < this.typeArr.length - 1) {

			this.changeStep();

			return;
		}





		// this.showRestart();
		// this.showGoodjob();
		// this.showOneFirework(cc.v2(0, -this.canvas.height / 2), this.canvas, cc.find('paperBase').children, this.canvas.width / 2.5, this.canvas.height * 2, 100, 1);
		playAudio(this.finishClip);

		if (!this.data.finish_right_audio_url) {
			const endData = this.getEndData();
			onHomeworkFinish(endData);
		}
		
		playAudioByUrl(this.data.finish_right_audio_url, () => {
			const endData = this.getEndData();
			onHomeworkFinish(endData);
		})

	

		const camera = cc.find('Canvas/Main Camera');
		camera.zIndex = 100;

		showTrebleFirework(camera, cc.find('RibbonNodeBase').children);


	

	},

	getEndData() {

		return {};

		const arr = this.picNodeArr;
		const customData = [];
		let stone = 0;
		const oneQuesStone = 10 / arr.length;
		arr.forEach(node => {
			customData.push({isRight: node.isRight})
			if (node.isRight) {
				stone += oneQuesStone;
			}
		})
		stone = Math.round(stone * 10) / 10;
		return {customData, stone};
	},

	showGoodjob() {

		const icon = getSprNode("goodjob");
		icon.scale = this._mapScaleMin;
		icon.baseS = icon.scale;
		this.canvas.addChild(icon, 20);


		const time = 1;
		icon.scale = 0;
		cc.tween(icon)
			.to(0.8,  {scale: icon.baseS}, {easing: "elasticOut"})
			.delay(1)
			.to(0.5, {scale: 0} , {easing: "cubicIn"})

			.start();



	},

	showRestart() {

		const btn = getSprNode("btn_restart");
		btn.scale = this._mapScaleMin;
		btn.baseS = btn.scale;
		this.canvas.addChild(btn, 21);

		btn.on(cc.Node.EventType.TOUCH_START, () => {
			// btn.removeFromParent();
			// this.initData();
			// this.initStar();
			// this.showChangeQuesAnim();
			// playAudio(this.btnClip);

			const middleLayer = cc.find('middleLayer');
			if (middleLayer) {
				middleLayer.getComponent('middleLayer').reloadBundle();
			}
		})

		const time = 0.9;
		btn.scale = 0;
		cc.tween(btn)
			.delay(2.5)
			.to(time,  {scale: btn.baseS}, {easing: "elasticOut"})
			.start();

	},



	async showOneFirework(pos, parentNode, nodeList, w, h, n, timeRate=1) {

		for (let i = 0; i < 3; i++) {
				this.showFirework(pos, parentNode, nodeList, w, h, n, timeRate);
				await asyncDelay(0.1);
		}
	},

	showFirework(pos, parentNode, nodeList, width = 200, height = 500, number = 30, timeRate=1) {
			const subTime = 1;
			for (let i = 0; i < number; i++) {
					const quad = this.createQuads(pos, parentNode, nodeList);
					const targetX = RandomInt(width / 2, -width / 2);
					const targetY = RandomInt(height);

					cc.tween(quad)
							.by(0.5 * timeRate, { x: targetX })
							.by((2 + subTime *  Math.random()) * timeRate, { x: targetX * 2 })
							.start();

					cc.tween(quad)
							.by(0.5 * timeRate, { y: targetY }, { easing: 'quadOut' })
							.to((3 + subTime * Math.random()) * timeRate, { y: -parentNode.height * 2 }, { easing: 'quadIn' })
							.removeSelf()
							.start();

					cc.tween(quad)
							.delay(1  * timeRate)
							.to((0.5 + subTime * Math.random()) * timeRate , { opacity: 0 })
							.start();
			}
	},

	createQuads(pos, parentNode, nodeList) {
			const quadBase = cc.instantiate(nodeList[RandomInt(nodeList.length)]);

			quadBase.x = pos.x;
			quadBase.y = pos.y;
			quadBase.z = pos.z;
			quadBase.angle = RandomInt(180);
			quadBase.parent = parentNode;

			const quad = quadBase.getChildByName('quad');
			quad.x = 0;
			quad.y = 0;
			quad.angle = RandomInt(180);

			const paper = quad.getChildByName('paper');
			paper.scaleX = Math.random() * 0.8 + 0.2;
			paper.scaleY = Math.random() * 0.8 + 0.2;

			quadBase.scaleX = Math.random();
			cc.tween(quadBase)
					.to((1 - quadBase.scaleX) * 0.3, { scaleX: 1 })
					.call(() => {
							const time = Math.random() * 0.2;
							cc.tween(quadBase)
									.to(0.1 + time, { scaleX: -1 })
									.to(0.1 + time, { scaleX: 1 })
									.union()
									.repeatForever()
									.start();
					})
					.start();


			return quadBase;
	},


















	restart() {
		
	},


	initTitle() {

		const offX = 96;
		const offY = 11;
		const title = getSprNode('title_bg');
		title.parent = this.canvas;
		title.scale = this._mapScaleMin;
		title.zIndex = 10;

		title.x = -this.canvas.width / 2 + title.width / 2 * title.scale + offX;
		title.y = this.canvas.height / 2 - title.height / 2 * title.scale - offY;

		// console.log('this.data: ', this.data);

		title.addComponent(cc.Button)
		title.on('click', () => {
			if (this.data.title_audio_url) {
				playAudioByUrl(this.data.title_audio_url);
			}
		})

		const labelNode = new cc.Node();
		labelNode.parent = title;
		const label = labelNode.addComponent(cc.RichText);
		const size = 42
		label.font = cc.find('Canvas/res/font/aharoni').getComponent(cc.Label).font;
		label.string = `<outline color=#a83c13 width=2><size=${size}><color=#ffffff>${this.data.title || " " }</color></size></outline>`
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.LEFT
		labelNode.anchorX = 0;
		labelNode.anchorY = 1
		labelNode.x = -title.width / 2 + 90;

		const maxLen = 305;
		if (labelNode.width > maxLen) {
			labelNode.scale = maxLen / labelNode.width;
		}

		labelNode.y = labelNode.height / 2 * labelNode.scale + 15;

	},


	initBg() {
		
		console.log("this.data.bg_pic_url: ", this.data.bg_pic_url);

		const bg = getSprNode('bg');
		const scaleX =  this.canvas.width / bg.width
		const scaleY = this.canvas.height / bg.height 
		const scale = Math.max(scaleX, scaleY);
		bg.scale = scale;
		this.canvas.addChild(bg);
	},
	


	initHotZone() {
		this.initHotZoneBg();
	},


	hotZoneBg: null,
	initHotZoneBg() {
		this.hotZoneBg = new cc.Node();
		this.hotZoneBg.name = 'hotZoneBg';
		this.hotZoneBg.parent = cc.find('Canvas');
		this.hotZoneBg.zIndex = 4;

		if (!this.data.bgItem) {
			return;
		}

		cc.loader.load({url: this.data.bgItem.url}, (err, img) => {

			// this.addMask(this.hotZoneBg);

			this.hotZoneBg.width = img.width;
			this.hotZoneBg.height = img.height;


			const sprNode = new cc.Node();
			sprNode.name = 'bgItemSpr'
			var sf = new cc.SpriteFrame(img);
			// const spr = this.hotZoneBg.addComponent(cc.Sprite);
			const spr = sprNode.addComponent(cc.Sprite);
			spr.spriteFrame = sf
			sprNode.width = this.hotZoneBg.width;
			sprNode.height = this.hotZoneBg.height;
			sprNode.parent = this.hotZoneBg;
			window['bg'] =sprNode 


			// const sx = this.canvas.width / this.hotZoneBg.width;
			// const sy = (this.canvas.height) / this.hotZoneBg.height;
			// const s = Math.min(sx, sy);
			// this.hotZoneBg.scale = s;


			const panel = getSprNode('panel');
			panel.scale = this._mapScaleMin * 1.5;
			this.canvas.addChild(panel);
			panel.x = -this.canvas.width;



			const parent = panel;
			const sx = parent.width / this.hotZoneBg.width;
			const sy = parent.height / this.hotZoneBg.height;
			const s = Math.min(sx, sy);

			this.hotZoneBg.scale = s * 0.9;
			this.hotZoneBg.parent = panel;

			// this.data.bgItem.isShowDebugLine = true;
			this.initHotZoneItem();



			cc.tween(panel)
			.to(1, {x: 0}, {easing: 'cubicOut'})
			.call(() => {
				this.hzLoadEnd = true;
				this.checkStart();
			})
			.start();
			
		});

	},

	initHotZoneItem() {

		this.picNodeArr = [];

		this.data.hotZoneItemArr.forEach((item) => {
			console.log('item.gIdx: ', item.gIdx);
			switch (item.gIdx) {

				case "0":
					this.setOneLinkRect(item);

					break;

				case "1":
					this.setOneWriteAnima(item);
					break;

				case "2":
					this.setOneCircleAnima(item);
					break;

				case "3":
					this.setOneAudioBtn(item);
					break;

				case "4":
					this.setOneSignAnima(item);
					break;
				// case "0":
				// 	this.setOneHotZonePic(item);
				// 	break;
						
				default:
					break;
			}

		});

	},

	setOneLinkRect(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		// rectNode.scale = 1 / data.mapScale;

		rectNode.anchorX = rectNode.anchorY = 0;


		if (this.data.isDebug) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();

		rectNode.data = data;

		console.log(" data is ~~~ : ", data);

		this.rectNodeArr.push(rectNode)


		const debugItemId = data.pointItem;
		const debugItemData = this.data.hotZoneItemArr2[Number(debugItemId) - 1];
		rectNode.isRightPoint = debugItemData.checkbox.list[0].value == true;

		console.log('debugItemData.checkbox.list[0].value: ', debugItemData.checkbox.list[0].value);

	},


	addMask(node) {
		const mask = node.addComponent(cc.Mask);
		mask.type = cc.Mask.Type.RECT;
	},


	setOneDragAction(data) {

		const rate =  (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY ;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		const {x, y, width, height} = rectNode;
		// rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(-rectNode.width / 2, -rectNode.height / 2, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();
		rectNode.x += rectNode.width / 2;
		rectNode.y += rectNode.height / 2;

		rectNode.baseX = rectNode.x;
		rectNode.baseY = rectNode.y;
		rectNode.targetOff();

		rectNode.on(cc.Node.EventType.TOUCH_START, () => {

			if (rectNode.isDragEnd) {
				if (rectNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
				}
				return;
			}
			this._curShowItem = rectNode;
		})
		

		const realRate = this.hotZoneBg.width / this.data.bgItem.rect.width;
		rectNode.targetPx = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
		rectNode.targetPy = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				rectNode.audioClip = audioClip;
			});
		}



		console.log('setOneAction ~~ data: ', data)
		const actionData = data['actionData_' + data.gIdx];
		if (!actionData) {
			return;
		}
		if (actionData.type == 'text') {
			const label = this.setOneActionText(rectNode, actionData);
			label.node.scale = scale * data.fontScale;

			label.node.targetOff();
		
	

			// label.overflow = cc.Label.Overflow.NONE;
			// label.node.setContentSize(new cc.Size(0, lineHeight));
			label["_forceUpdateRenderData"](true);
		
			
		} else if (actionData.type == 'pic') {

			const pic = this.setOneActionPic(rectNode, actionData);

		} else if (actionData.type == 'anima') {

			const anima = this.setOneActionAnima(rectNode, actionData);
		}
	},



	setOneAction(data) {

		const rate =  (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY ;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		const {x, y, width, height} = rectNode;
		rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();



		console.log('setOneAction ~~ data: ', data)
		const actionData = data['actionData_' + data.gIdx];
		if (!actionData) {
			return;
		}
		if (actionData.type == 'text') {
			const label = this.setOneActionText(rectNode, actionData);
			label.node.scale = scale * data.fontScale;

			// label.overflow = cc.Label.Overflow.NONE;
			// label.node.setContentSize(new cc.Size(0, lineHeight));
			label["_forceUpdateRenderData"](true);
		
			
		} else if (actionData.type == 'pic') {

			const pic = this.setOneActionPic(rectNode, actionData);

		} else if (actionData.type == 'anima') {

			const anima = this.setOneActionAnima(rectNode, actionData);
		}
	},

	setOneActionText(rectNode, actionData) {


		const labelNode = new cc.Node();
		labelNode.parent = rectNode;
		const label = labelNode.addComponent(cc.Label);

		label.font = cc.find('Canvas/res/font/ahronbd-1').getComponent(cc.Label).font;
		label.string = actionData.text;
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		// label.lineHeight = size;
		// label.horizontalAlign = cc.macro.TextAlignment.LEFT
		// labelNode.anchorX = 0;
		// labelNode.anchorY = 1
		labelNode.color = cc.Color.BLACK;


		const opArr = actionData.changeOption
		// console.log('opArr', opArr);


		const tweenArr = [];

		for (let i = 0; i < opArr.length; i++ ) {

			const opData = opArr[i];
			console.log('opArr[0]', opArr[i])
			if (opData[0] == 'fontColor') {
				const color = new cc.Color();
				cc.Color.fromHEX(color, opData[1] );
				labelNode.color = color;

			} else if (opData[0] == 'opacity') {
				// console.log('opData: ', opData)
				labelNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
				// console.log(labelNode.opacity);
				tweenArr.push({item: labelNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[0]},)

			} else {
				label[opData[0]] = opData[1];
				tweenArr.push({item: label, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[0]})

			}
		}


		// if (actionData.audio_url) {
		// 	cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
		// 		labelNode.audioClip = audioClip;
		// 	});
		// }


		label.lineHeight = label.fontSize;

		// labelNode.y += rectNode.height / 2;
		// labelNode.x += rectNode.width / 2;
		

		// rectNode.addComponent(cc.Button);
		// rectNode.on('click', () => {

		// 	if (labelNode.audioClip) {
		// 		cc.audioEngine.stopAllEffects();
		// 		cc.audioEngine.playEffect(labelNode.audioClip, false, 0.8);
		// 	}

		// 	if (labelNode.isClicked) {
		// 		// return;
		// 	}
		// 	labelNode.isClicked = true;

		// 	for (let i=0; i<tweenArr.length; i++) {
		// 		const tweenData = tweenArr[i];

		// 		if (tweenData.optionName == 'opacity') {
		// 			console.log('~~~ ',  tweenData.item[tweenData.optionName] );

		// 			cc.tween(tweenData.item)
		// 				.to(actionData.changeTime,  JSON.parse(tweenData.option) )
		// 				.start();
		// 		}
				

		// 	}

		// });


		return label;
	},

	setOneActionPic(rectNode, actionData) {

		console.log('setOneActionPic actionData: ', actionData)
		const picNode = new cc.Node();
		rectNode.addChild(picNode);

		cc.loader.load({url: actionData.pic_url}, (err, img) => {

			const spr = picNode.addComponent(cc.Sprite);
			spr.spriteFrame = new cc.SpriteFrame(img)

			picNode.y += rectNode.height / 2;
			picNode.x += rectNode.width / 2;

			picNode.scaleX = rectNode.width / picNode.width;
			picNode.scaleY = rectNode.height / picNode.height;

			const opArr = actionData.changeOption	
			const tweenArr = [];
	
			for (let i = 0; i < opArr.length; i++ ) {
	
				const opData = opArr[i];
				console.log('opData: ~~~ ', opData);

				if (opData[0] == 'opacity') {
					picNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
					console.log(picNode.opacity);
					tweenArr.push({item: picNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[0]},)
	
				}  else {
					// picNode[opData[0]] = Number(opData[1]);
					// tweenArr.push({item: picNode, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[0]})
				}

	
				if (actionData.audio_url) {
					cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
						rectNode.audioClip = audioClip;
					});
				}
				

				rectNode.addComponent(cc.Button);
				rectNode.on('click', () => {

					if (rectNode.audioClip) {
						cc.audioEngine.stopAllEffects();
						cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
					}
		
					if (rectNode.isClicked) {
						// return;
					}
					rectNode.isClicked = true;

					for (let i=0; i<tweenArr.length; i++) {
						const tweenData = tweenArr[i];
		
						if (tweenData.optionName == 'opacity') {
							cc.tween(tweenData.item)
								.to(actionData.changeTime,  JSON.parse(tweenData.option) )
								.start();
						}
					}
		
				});
			}

		});
	},

	setOneActionAnima(rectNode, actionData) {


		const animaNode = new cc.Node();
		rectNode.addChild(animaNode);

		if (actionData.audio_url) {
			cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
				rectNode.audioClip = audioClip;
			});
		}

		const data = actionData;

		const dragonDisplay = animaNode.addComponent(dragonBones.ArmatureDisplay);
		if (!data.texPngData) {
			return
		}



		const image = data.texPngData.url//"http://staging-teach.cdn.ireadabc.com/5a0c5af3e952acd0ac83a6e5c6f03ff1.png";
		const ske = data.skeJsonData.url//"http://staging-teach.cdn.ireadabc.com/bd825dcceea298d1146be8067ae3d17f.json";
		const atlas = data.texJsonData.url//"http://staging-teach.cdn.ireadabc.com/246f8991b729fa3e5a7f4802de828efa.json";
		cc.loader.load(image, (error, texture) => {

			cc.loader.load({url: atlas, type: 'txt'}, (error, atlasJson) => {

				cc.loader.load({url: ske, type: 'txt'}, (error, dragonBonesJson) => {

					const atlas = new dragonBones.DragonBonesAtlasAsset();
					atlas.atlasJson = atlasJson;
					atlas.texture = texture;

					const asset = new dragonBones.DragonBonesAsset();
					asset.dragonBonesJson = dragonBonesJson;

					dragonDisplay.dragonAtlasAsset = atlas;
					dragonDisplay.dragonAsset = asset;


					let json = JSON.parse(asset.dragonBonesJson);
					let armatures = json["armature"];
					let armatureNames = [];
					for (let i = 0; i < armatures.length; i++) {
						armatureNames.push(armatures[i].name);
					}
					// console.log('armatureNames: ', armatureNames);

					let animationNames = [];

					if (armatureNames.length > 0) {
						let defaultArmatureName = armatureNames[0];
						dragonDisplay.armatureName = defaultArmatureName;
						// let animationNames = dragonDisplay.getAnimationNames(defaultArmatureName);
						let defaultArmature = armatures[0];
						let animations = defaultArmature.animation;
						for (let i = 0; i < animations.length; i++) {
							animationNames.push(animations[i].name);
						}

						// rectNode.addComponent(cc.Button);
						// rectNode.on('click', () => {
						// 	if (rectNode.isClicked) {
						// 		// return;
						// 	}
						// 	rectNode.isClicked = true;
						// 	console.log('clicked');

						// 	if (rectNode.audioClip) {
						// 		cc.audioEngine.stopAllEffects();
						// 		cc.director.emit('STOP_ALL_AUDIO')
						// 		cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
						// 	}

						// 	if (animationNames.length > 0) {
						// 		dragonDisplay.playAnimation(animationNames[0], 1);
						// 	}
						// });
					}


					// animaNode.x = rectNode.x + rectNode.width / 2;
					// animaNode.y = rectNode.y + rectNode.height / 2;

					// const sx = rectNode.width / animaNode.width;
					// const sy = rectNode.height / animaNode.height;
					// const scale = Math.min(sx, sy);
					// animaNode.scale = scale;
					


			


					animaNode.y += rectNode.height / 2;
					animaNode.x += rectNode.width / 2;

					animaNode.scaleX = rectNode.width / animaNode.width;
					animaNode.scaleY = rectNode.height / animaNode.height;
		
					const opArr = actionData.changeOption	
					const tweenArr = [];
			
					for (let i = 0; i < opArr.length; i++ ) {
			
						const opData = opArr[i];
						console.log('opData: ~~~ ', opData);
		
						if (opData[0] == 'opacity') {
							animaNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
							console.log(animaNode.opacity);
							tweenArr.push({item: animaNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[2] == null ? '' : opData[0]},)
			
						}  else {
							// animaNode[opData[0]] = Number(opData[1]);
							// tweenArr.push({item: animaNode, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[2] == null ? '' : opData[0]})
						}
		
			
						if (actionData.audio_url) {
							cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
								rectNode.audioClip = audioClip;
							});
						}
						
		
						rectNode.addComponent(cc.Button);
						rectNode.on('click', () => {
		
							if (rectNode.audioClip) {
								cc.audioEngine.stopAllEffects();
								cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
							}
				
							if (rectNode.isClicked) {
								// return;
							}
							rectNode.isClicked = true;
		
							for (let j=0; j<tweenArr.length; j++) {
								const tweenData = tweenArr[j];
				
								console.log('tweenData: ', tweenData);

								if (tweenData.optionName) {

									cc.tween(tweenData.item)
										.to(actionData.changeTime,  JSON.parse(tweenData.option))
										.start();

								}

							}
						
							if (animationNames.length > 0) {
								dragonDisplay.playAnimation(animationNames[0], 1);
							}
				
						});
					}
		
					
				});
			});
		});

	},
	

	setOneWriteAnima(data) {

		const animaNode = this.setOneAnimaSmall(data);

		const letterH = 125;
		const rectNode = animaNode.rectNode;
		const sy = rectNode.height / letterH
		animaNode.scale = sy

		this.animaNodeArr.push(animaNode);

	},


	setOneCircleAnima(data) {



		const animaNode = this.setOneAnimaSmall(data);
		const circle = this.getCircleNode(animaNode);
		animaNode.ctxCircle = circle;

		// this.showCircle2(animaNode);

		this.circleAnimaNodeArr.push(animaNode);
	},

	showCircle2(animaNode) {
		const ctxCircle = animaNode.ctxCircle;

		let a = 0;

		const showColorAnim = () => {

			a ++;
			const color = cc.Color.BLACK;
			color.a = a;

			ctxCircle.strokeColor = color
			ctxCircle.stroke();

			if (a < 10 && !this.isDestroy) {
				delayCall(0.1, () => {
					showColorAnim();
				})
			}
		
		}
	
		showColorAnim();
		
		playAudio(this.rightClip, () => {
			
		})
	},

	setOneSignAnima(data) {
		const animaNode = this.setOneAnimaSmall(data);

		const signW = 200;
		const signH = 200;
		const rectNode = animaNode.rectNode;
		const sx = rectNode.width / signW;
		const sy = rectNode.height / signH;
		const minS = Math.min(sx, sy);
		animaNode.scale = minS;

		this.signAnimaNodeArr.push(animaNode);
	},

	setOneAudioBtn(data) {

		const btn = this.getAudioSpr(data);
		btn.addComponent(cc.Button);
		btn.on("click", () => {

			if (!this.canTouch) {
				return;
			}
			if (data.audio_url) {

				cc.audioEngine.stopAllEffects();
				playAudioByUrl(data.audio_url);
			}
		})
	},

	getCircleNode(animaNode) {

		const rectNode = animaNode.rectNode;

		console.log('rectNode: ',rectNode);

		const node = new cc.Node();
		rectNode.parent.addChild(node);
		const ctx = node.addComponent(cc.Graphics);
		ctx.ellipse(0, 0, rectNode.width / 2, rectNode.height / 2 );
		let strokeColor = cc.Color.BLACK;
		strokeColor.a = 0;
		ctx.lineWidth = 7;
		ctx.strokeColor = strokeColor;

		node.x = rectNode.x + rectNode.width / 2;
		node.y = rectNode.y + rectNode.height / 2;

		ctx.stroke();

		return ctx;
		// ctx.fill();
	},


	getAudioSpr(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const picNode = new cc.Node();
		picNode.name= 'pic' + data.index;
		picNode.data = data;
		this.hotZoneBg.addChild(picNode);

		const sprNode = getSprNode("btn_sound");
		sprNode.anchorX = 0;
		sprNode.anchorY = 0;

		picNode.anchorX = 0;
		picNode.anchorY = 0;

		
		picNode.addChild(sprNode);

		const scale = rate / this.hotZoneBg.scaleY;

		picNode.width = sprNode.width = data.rect.width * scale;
		picNode.height = sprNode.height = data.rect.height * scale;
		picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;


		return picNode;

	},

	setOneAnimaSmall(data) {


		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

		rectNode.anchorX = rectNode.anchorY = 0;


		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();




		const animaNode = new cc.Node();
		animaNode.name = 'anima_' + data.index;
		this.hotZoneBg.addChild(animaNode);

		animaNode.data = data;
		animaNode.rectNode = rectNode;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				animaNode.audioClip = audioClip;
			});
		}


		const dragonDisplay = animaNode.addComponent(dragonBones.ArmatureDisplay);
		if (!data.texPngData) {
			return animaNode
		}
		
		const image = data.texPngData.url//"http://staging-teach.cdn.ireadabc.com/5a0c5af3e952acd0ac83a6e5c6f03ff1.png";
		const ske = data.skeJsonData.url//"http://staging-teach.cdn.ireadabc.com/bd825dcceea298d1146be8067ae3d17f.json";
		const atlas = data.texJsonData.url//"http://staging-teach.cdn.ireadabc.com/246f8991b729fa3e5a7f4802de828efa.json";
		cc.loader.load(image, (error, texture) => {

			cc.loader.load({url: atlas, type: 'txt'}, (error, atlasJson) => {

				cc.loader.load({url: ske, type: 'txt'}, (error, dragonBonesJson) => {

					const atlas = new dragonBones.DragonBonesAtlasAsset();
					atlas.atlasJson = atlasJson;
					atlas.texture = texture;

					const asset = new dragonBones.DragonBonesAsset();
					asset.dragonBonesJson = dragonBonesJson;

					dragonDisplay.dragonAtlasAsset = atlas;
					dragonDisplay.dragonAsset = asset;

					

					let json = JSON.parse(asset.dragonBonesJson);
					let armatures = json["armature"];
					// console.log('armatures: ', armatures);
					let armatureNames = [];
					for (let i = 0; i < armatures.length; i++) {
						armatureNames.push(armatures[i].name);
					}
					// console.log('armatureNames: ', armatureNames);
					if (armatureNames.length > 0) {
						let defaultArmatureName = armatureNames[0];
						dragonDisplay.armatureName = defaultArmatureName;
						// let animationNames = dragonDisplay.getAnimationNames(defaultArmatureName);
						let defaultArmature = armatures[0];
						let animations = defaultArmature.animation;
						let animationNames = [];
						for (let i = 0; i < animations.length; i++) {
							animationNames.push(animations[i].name);
						}

						animaNode.animationNames = animationNames;

						rectNode.addComponent(cc.Button);
						rectNode.on('click', () => {
							if (rectNode.isClicked) {
								// return;
							}
							rectNode.isClicked = true;
							console.log('clicked');

							if (animaNode.audioClip) {
								cc.audioEngine.stopAllEffects();
								cc.director.emit('STOP_ALL_AUDIO')
								cc.audioEngine.playEffect(animaNode.audioClip, false, 0.8);
							}

							if (animationNames.length > 0) {
								dragonDisplay.playAnimation(animationNames[0], 1);
							}
						});

						// animaNode.playRightAnim = () => {
						// 	animaNode.active = true;
						// 	if (animationNames.length > 0) {
						// 		dragonDisplay.playAnimation(animationNames[0], 1);
						// 	}
						// }
						animaNode.dragonDisplay = dragonDisplay;
					}


					animaNode.x = rectNode.x + rectNode.width / 2;
					animaNode.y = rectNode.y + rectNode.height / 2;

					const sx = rectNode.width / animaNode.width;
					const sy = rectNode.height / animaNode.height;
					const scale = Math.min(sx, sy);
					// animaNode.scale = scale;

					// animaNode.active = false;
					animaNode.opacity = 0;
					animaNode.hitCount = 0;
					// animaNode.opacity = 20;
			
					
				});
			});
		});


		return animaNode;

	},

	playRightAnim(animaNode) {
		const animationNames = animaNode.animationNames;
		const dragonDisplay = animaNode.dragonDisplay;

		animaNode.active = true;
		animaNode.opacity = 255;
		// animaNode.opacity = 255;
		if (dragonDisplay && animationNames && animationNames.length > 0) {
			dragonDisplay.playAnimation(animationNames[0], 1);
		}

		playAudio(this.rightClip, () => {
			
		})
	},

	setOneHotZonePic(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const picNode = new cc.Node();
		picNode.name= 'pic' + data.index;
		picNode.data = data;
		this.hotZoneBg.addChild(picNode);

		this.picNodeArr.push(picNode);
		picNode.hitCount = 0;

		cc.loader.load({url: data.pic_url}, (err, img) => {

			const spr = picNode.addComponent(cc.Sprite);
			spr.spriteFrame = new cc.SpriteFrame(img)

			const scale = rate / this.hotZoneBg.scaleY;

			picNode.width = data.rect.width * scale;
			picNode.height = data.rect.height * scale;
			picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
			picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

			picNode.x += picNode.width / 2 * picNode.scaleX;
			picNode.y += picNode.height / 2 * picNode.scaleX;


			getSprNodeByUrl(data.answer_pic_url, (spr) => {

				const sprNode = spr.node;
				sprNode.active = false;
				picNode.addChild(sprNode);
				picNode.answerPic = sprNode;

				picNode.isLoadEnd = true;
				// this.checkStart();
			})

			// picNode.anchorX = picNode.anchorY = 0;

			// if (data.audio_url) {
			// 	this.addPicAudio(picNode);
			// }

			// this.addDragPoint(picNode, data)

		});

	},

	addDragPoint(picNode, data) {


		picNode.baseX = picNode.x;
		picNode.baseY = picNode.y;

		const realRate = this.hotZoneBg.width / this.data.bgItem.rect.width;
		picNode.targetPx = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
		picNode.targetPy = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				picNode.audioClip = audioClip;
			});
		}


		picNode.on(cc.Node.EventType.TOUCH_START, () => {
			if (picNode.isDragEnd) {
				if (picNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(picNode.audioClip, false, 0.8);
				}
				return;
			}
			this._curShowItem = picNode;

			// picNode.x = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
			// picNode.y = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;

		})
	},


	setOnePic(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const picNode = new cc.Node();
		picNode.name= 'pic' + data.index;
		picNode.data = data;
		this.hotZoneBg.addChild(picNode);

		getSprNodeByUrl(data.pic_url, (spr) => {

			const sprNode = spr.node;
			picNode.addChild(sprNode);

			const scale = rate / this.hotZoneBg.scaleY;

			picNode.width = sprNode.width = data.rect.width * scale;
			picNode.height = sprNode.height = data.rect.height * scale;
			picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
			picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

			// sprNode.anchorX = sprNode.anchorY = 0;


		})

		return picNode;

		// cc.loader.load({url: data.pic_url}, (err, img) => {

		// 	const spr = picNode.addComponent(cc.Sprite);
		// 	spr.spriteFrame = new cc.SpriteFrame(img)

		// 	const scale = rate / this.hotZoneBg.scaleY;

		// 	picNode.width = data.rect.width * scale;
		// 	picNode.height = data.rect.height * scale;
		// 	picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		// 	picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

		// 	picNode.anchorX = picNode.anchorY = 0;

		// 	// if (data.audio_url) {
		// 	// 	this.addPicAudio(picNode);
		// 	// }

		// });

		// picNode.on('touchstart', () => {
		// 	this.show
		// })

	},


	setOneRect(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY;
		// console.log('scale: ', scale);
		// console.log('scale2: ', scale / data.mapScale);


		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		// rectNode.scale = 1 / data.mapScale;

		rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine || this.data.isDebug || true) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();

		this.linkRectGroup.push(rectNode);

		// console.log('```data: ', data)

		// this.dragEndRectArr.push(rectNode);

		// if (data.audio_url) {
		// 	cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
		// 		rectNode.audioClip = audioClip;
		// 	});
		// }



	},

	addPicAudio(picNode) {
		const data = picNode.data;
		
		cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
			picNode.audioClip = audioClip;
		});

		picNode.addComponent(cc.Button);
		picNode.on('click', () => {
				
				if (picNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(picNode.audioClip, false, 0.8);
				}
		});
	},


	initListener() {

		const canvas = cc.find('Canvas');
		
		let downFlag = false;

		const touchMove = (e) => {
			this.canvasTouchMove(e);
			if (canvas.hasEventListener(cc.Node.EventType.MOUSE_MOVE)) {
				canvas.off(cc.Node.EventType.MOUSE_MOVE, mouseMove)
			}
		}

		const mouseMove = (e) => {
			if (!downFlag) {
				return;
			}
			this.canvasTouchMove(e);
			if (canvas.hasEventListener(cc.Node.EventType.TOUCH_MOVE)) {
				canvas.off(cc.Node.EventType.TOUCH_MOVE, touchMove)
				this.removeHtmlCanvasListener('touchmove');
			}
		}

		const touchEnd = (e) => {
		
			downFlag = false;
			this.canvasTouchEnd(e);

			if (canvas.hasEventListener(cc.Node.EventType.MOUSE_UP)) {
				canvas.off(cc.Node.EventType.MOUSE_UP, mouseUp)
			}
			if (canvas.hasEventListener(cc.Node.EventType.MOUSE_LEAVE)) {
				canvas.off(cc.Node.EventType.MOUSE_LEAVE, mouseUp)
			}
			this.removeHtmlTouchEnd();
		}

		const mouseUp = (e) => {
	
			downFlag = false;

			this.canvasTouchEnd(e);

			if (canvas.hasEventListener(cc.Node.EventType.TOUCH_END)) {
				canvas.off(cc.Node.EventType.TOUCH_END, touchEnd)
			}
			if (canvas.hasEventListener(cc.Node.EventType.TOUCH_CANCEL)) {
				canvas.off(cc.Node.EventType.TOUCH_CANCEL, touchEnd)
			}
		}
		

		canvas.on(cc.Node.EventType.TOUCH_MOVE, touchMove)
		canvas.on(cc.Node.EventType.MOUSE_MOVE, mouseMove)

		canvas.on(cc.Node.EventType.TOUCH_END, touchEnd)
		canvas.on(cc.Node.EventType.TOUCH_CANCEL, touchEnd)
		canvas.on(cc.Node.EventType.MOUSE_UP, mouseUp)

	},

	removeHtmlCanvasListener(type) {
		const canvasHtml = document.querySelector('canvas');
		canvasHtml.addEventListener(type, (e) => {})
	},	
	removeHtmlTouchEnd() {
		const canvasHtml = document.querySelector('canvas');
		canvasHtml.removeEventListener('touchend', this.htmlCanvasTouchendFunc, this);
	},

	canvasTouchMove(e) {

		if (!this._curShowItem) {
			return;
		}
		const pos = e.getLocation();
		this._curShowItem.x = pos.x - e.currentTarget.width / 2;
		this._curShowItem.y = pos.y - e.currentTarget.height / 2;

		// console.log('pos: ', pos.x);
	},

	canvasTouchEnd(e) {

		if (!this._curShowItem) {
			return;
		}
		this.checkOnDragEndRect();
		this._curShowItem = null;
	},



	checkOnDragEndRect() {

		console.log('emptyGroupArr: ',  this.emptyGroupArr);
		for (let i = 0; i < this.dragEndRectArr.length; i++) {

			const rect = this.dragEndRectArr[i];

			const worldPos = this._curShowItem.parent.convertToWorldSpaceAR(cc.v2(this._curShowItem.x, this._curShowItem.y));
			const worldRect = rect.getBoundingBoxToWorld();
			if (worldRect.contains(worldPos)) {
			
				console.log('rect in ')
				this.checkIsDragEndTarget(rect);
				// removeItemFromArr(this.emptyGroupArr, letterGroup);
				// this.showLetterSuccess(letterGroup);
				// this.checkGroupEnd();
				return;
			}
			
		}

		this.itemBack();
	},

	itemBack() {

		cc.audioEngine.playEffect(this.wrongClip, false, 0.8);

		cc.tween(this._curShowItem)
			.to(0.5, {x: this._curShowItem.baseX, y: this._curShowItem.baseY}, {easing: "elasticOut"})
			.start();
	},

	checkIsDragEndTarget(rect) {

		const worldPos = this._curShowItem.parent.convertToWorldSpaceAR(cc.v2(this._curShowItem.targetPx, this._curShowItem.targetPy));
		const worldRect = rect.getBoundingBoxToWorld();
		if (worldRect.contains(worldPos)) {
			this._curShowItem.x = this._curShowItem.targetPx;
			this._curShowItem.y = this._curShowItem.targetPy;
			this._curShowItem.isDragEnd = true;


			cc.audioEngine.playEffect(this.rightClip, false, 0.8);

		} else {
			this.itemBack();
		}
	},


	onDestroy() {
		this.isDestroy = true;
	},


});
