import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef } from '@angular/core';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  picArr = {
    audio_url: "",
    list: [],
  };
  _item: any;
  KEY = 'hw_006';
  errs = [];

  // @Input()
  set item(item) {
    this._item = item;
    // this.init();

  }
  get item() {
    return this._item;
  }

  @Output()
  update = new EventEmitter();



  constructor(private appRef: ApplicationRef) {

  }


  ngOnInit() {

    this.item = {};
    this.item.contentObj = {};

    const getData = (<any>window).courseware.getData;
    getData((data) => {

      if (data) {
        this.item = data;
      } else {
        this.item = {};
      }

      if (!this.item.contentObj) {
        this.item.contentObj = {};
      }

      console.log('~data:', data);
      this.init();
      this.refresh();

    }, this.KEY);

    // this.initData();
  }
  ngOnChanges() {

  }

  ngOnDestroy() {
  }


  init() {
    //在卡片组之上需要增加 两个组 0根->picArr  1题组->testlet  2页面->page  3卡片对->itemData
    if (this.item.contentObj.picArr) {
      this.picArr = this.item.contentObj.picArr;
      this.check();
    } else {
      this.picArr = this.getDefaultPicArr();
      this.item.contentObj.picArr = this.picArr;
    }
    console.log('item:', this.item);
  }

  cardItemData() {
    return {
      cardId: "",
      radioValue: "1",
      title: "",
      pic_url: "",
      audio_url: ""
    };
  }

  getDefaultPicArr() {
    let obj: any = {};
    let arr = [];
    //在卡片组之上需要增加 两个组 0根->picArr  1题组->testlet  2页面->page  3卡片对->itemData
    //默认 题组1 页面1 卡片对2个
    for (let i = 0; i < 6; i++) {
      let item = this.cardItemData();
      arr.push(item);
    }
    obj.list = arr;
    obj.audio_url = "";
    return obj;
  }



  initData() {


  }



  onImageUploadSuccessByItem(e, item) {
    item.pic_url = e.url;
    this.save();
  }

  onAudioUploadSuccessByItem(e, item) {
    item.audio_url = e.url;
    this.save();
  }

  radioClick(it, radioValue) {
    it.radioValue = radioValue;
    this.saveItem();
  }

  clickCheckBox() {
    console.log(' in clickCheckBox');
    this.saveItem();
  }


  saveItem() {

    console.log(' in saveItem');
    // this.update.emit(this.item);
    this.save();
  }

  check() {
    if (!this.picArr) return;
    // let picArr = this.picArr.list;
    // function tia(info) {
    //   let str = "";
    //   if (info.radioValue == "A") {
    //     if (!info.title) str += ",图片";
    //   } else if (info.radioValue == "B") {
    //     if (!info.pic_url) str += ",图片";
    //   } else if (info.radioValue == "C") {
    //     if (!info.audio_url) str += ",音频";
    //   } else {
    //     str += "卡片"
    //   }
    //   if (str) str += "未上传"
    //   return str;
    // }
    // this.errs.length = 0;
    // for (let m = 0; m < picArr.length; m++) {
    //   for (let n = 0; n < picArr[m].length; n++) {
    //     if (picArr[m][n].length < 2) {
    //       this.errs.push(`星-${m + 1} 页-${n + 1} 卡片少于2个`);
    //     }
    //     for (let i = 0; i < picArr[m][n].length; i++) {
    //       let item = picArr[m][n][i];
    //       let left = item.left;
    //       let right = item.right;
    //       let code0 = tia(left);
    //       let code1 = tia(right);
    //       if (code0) this.errs.push(`星-${m + 1} 页-${n + 1} 第${i + 1}个卡片 左侧${code0}`);
    //       if (code1) this.errs.push(`星-${m + 1} 页-${n + 1} 第${i + 1}个卡片 右侧${code1}`);
    //     }
    //   }
    // }
    // console.log("this.errs");
    // console.log(this.errs);
    // console.log("-------------------------");
  }


  save() {
    //触发一次检测
    // this.item.picArr;
    // this.message.create("error", `This is a message of error`);
    this.check();

    (<any>window).courseware.setData(this.item, null, this.KEY);
    console.log('this.item = ' + JSON.stringify(this.item));
    this.refresh();
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}

