import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "OP_08_2";
  // 储存对象
  item;


  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {

  }

  createShell() {
    this.item.wordList.push({
      word: '',
      audio: '',
      backWord: '',
      backWordAudio: '',
    });
    this.save();
  }

  removeShell(idx) {
    this.item.wordList.splice(idx, 1);
    this.save();
  }

  ngOnInit() {

    this.item = {};

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      console.log('this.item: ', this.item);
      // this.item = {"text":"A","letterArr":[{"audio_url":"http://staging-teach.cdn.ireadabc.com/23c84741caea3e275dc63ce295251b70.mp3"},{"audio_url":"http://staging-teach.cdn.ireadabc.com/5dc8f9037da728e11534bbe5e66a0f3a.mp3","is_right":true},{"audio_url":"http://staging-teach.cdn.ireadabc.com/41e3536366a031d6ab79dd552fbe2d14.mp3","is_right":true},{"audio_url":"http://staging-teach.cdn.ireadabc.com/b780c5f3fd3148366e3309f2874be5fb.mp3"},{"audio_url":"http://staging-teach.cdn.ireadabc.com/434afb6f866e916cf02c4dafb2b91458.mp3","is_right":true},{"audio_url":"http://staging-teach.cdn.ireadabc.com/4ac05847481732301a4ad66138e4c058.mp3"},{"audio_url":"http://staging-teach.cdn.ireadabc.com/fa5e4d4542227efbec5b187a09b6d2c7.mp3"},{"audio_url":"http://staging-teach.cdn.ireadabc.com/0bd079041c169536e6fc77f9e35768ef.mp3","is_right":true}],"end_audio_url":"http://staging-teach.cdn.ireadabc.com/847a2e0c9469914063f26d5590001c67.mp3","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/d3006e57a96a41ffe83b5beadeaea432.mp3","tip_audio_url":"http://staging-teach.cdn.ireadabc.com/0eb830a7919409e77cc09c340e53f15d.mp3","skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/63d51fdbf082695c1cb091070aee4c04.json","name":"correct_particle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/f7b4fbcb62a41687c07495e4317ed2ff.json","name":"correct_particle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/2346ea6aeb206068c2f1f079c0bd735c.png","name":"correct_particle_tex.png"},"letter":"E","letterAnim":{"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a017f5393a91158025a305b5f11d8a19.json","name":"Aa_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/e7b93cb591e5597880ad8051e1863705.json","name":"Aa_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/f9f00f4a0053ed31769ad3691946f607.png","name":"Aa_tex.png"}},"isDebug":true}

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);
  }

  ngOnChanges() {
  }

  ngOnDestroy() {
  }

  init() {

    if (!this.item.letterArr) {
      this.initItemLetterArr();
    }

    if (!this.item.letterAnim) {
      this.item.letterAnim = {};
    }
  }

  initItemLetterArr() {
    this.item.letterArr = [];
    for (let i=0; i<8; i++) {
      this.item.letterArr.push({'audio_url': ''});
    }
  }


  saveAnim(data, item = null) {

    if (!item) {
      item = this.item;
    }
    console.log('in saveAnim:  ', data);
    item['skeJsonData'] = data['skeJsonData'];
    item['texJsonData'] = data['texJsonData'];
    item['texPngData'] = data['texPngData'];
    this.save();
  }

  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key) {

    this.item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key, item=null) {
    if (!item) {
      item = this.item;
    }
    item[key] = e.url;
    this.save();
  }

  onWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].audio = e.url;
    this.save();
  }

  onBackWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].backWordAudio = e.url;
    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);

    this.refresh();
    console.log('this.item = ' + JSON.stringify(this.item));
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}