// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

// import { getSprNode } from "./util";
import { getSprNode, playAudioByUrl, showBtnAnima, getScaleRateBy2Node, localPosTolocalPos, randomSortByArr, loadDragonBones, playAudio, showTrebleFirework, getSprNodeByUrl, setSprNodeMaxLen, delayCall, asyncDelay, RandomInt, exchangeNodePos, onHomeworkFinish} from "../script/util";

cc.Class({
	extends: cc.Component,

	properties: {
		baseWidth: {
			default: 1920,
			type: cc.Integer
		},
		baseHeight: {
			default: 1200,
			type: cc.Integer
		}
	},

	onLoad() {
		cc.debug.setDisplayStats(false);
		this.initSceneData();
		this.initSize();
	},

	initSceneData() {
		this._imageResList = [];
		this._audioResList = [];
		this._animaResList = [];
	},


	_designSize: null,
	_frameSize: null,
	_mapScaleMin: null,
	_mapScaleMax: null,
	_cocosScale: null,
	canvas: null,
	initSize() {


		// 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
		let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
		let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
		let f = screen_size >= design_size
		cc.Canvas.instance.fitHeight = f
		cc.Canvas.instance.fitWidth = !f

		const frameSize = cc.view.getFrameSize();
		this._frameSize = frameSize;

		this._designSize = cc.view.getDesignResolutionSize();

		let sx = cc.winSize.width / frameSize.width;
		let sy = cc.winSize.height / frameSize.height;
		this._cocosScale = Math.min(sx, sy);

		sx = frameSize.width / this._designSize.width;
		sy = frameSize.height / this._designSize.height;
		this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
		this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;

		this.canvas = cc.find('Canvas');


		// cc.log('cc.Canvas: ', cc.Canvas);
	},

	start() {

		console.log(' in start 1 ');

		let getData = this.getData.bind(this);
		if (window && window.courseware) {
			getData = window.courseware.getData;

			console.log(' in start 2 ');

		}
		getData((data) => {
			console.log('data:', data);
			this.data = data || this.getDefaultData();
			this.preloadItem()
		})
	},

	_imageResList: null,
	_audioResList: null,
	_animaResList: null,
	preloadItem() {
		this.addPreloadImage();
		this.addPreloadAudio();
		this.addPreloadAnima();
		this.preload();
	},


	getData(func) {
		if (window && window.courseware) {
			window.courseware.getData(func, 'dfzx_cocos_dqq');
			return;
		}
		
		const middleLayer = cc.find('middleLayer');
		if (middleLayer) {
			const middleLayerComponent = middleLayer.getComponent('middleLayer');
			middleLayerComponent.getData(func);
			return;
		}
		
		func(this.getDefaultData());
	},

	getDefaultData() {

		return {"page_id":"5","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bg_pic_url":"http://staging-teach.cdn.ireadabc.com/5a7e40d2a1cb79aeab851dd380b697fb.png","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/fe69c5379b3126229842e54bffb429f7.png","rect":{"x":395.46,"y":0,"width":1533.07,"height":875}},"hotZoneItemArr":[{"id":"1667204308783","index":0,"itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a017f5393a91158025a305b5f11d8a19.json","name":"Aa_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/e7b93cb591e5597880ad8051e1863705.json","name":"Aa_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ce2dbe0d0ad9cad3631309d85b82f1e1.png","name":"Aa_tex.png"},"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"1","posX":1752.4841734414226,"posY":285.99933067521255,"rect":{"x":998.06,"y":153.48,"width":299.02,"height":197.58},"rectNew":1},{"id":"1667204370017","index":1,"itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a017f5393a91158025a305b5f11d8a19.json","name":"Aa_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/e7b93cb591e5597880ad8051e1863705.json","name":"Aa_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ce2dbe0d0ad9cad3631309d85b82f1e1.png","name":"Aa_tex.png"},"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"1","posX":847.4859110008995,"posY":610.998716967671,"rect":{"x":199.81,"y":440.15,"width":299.02,"height":197.58},"rectNew":2},{"id":"1667204377049","index":2,"itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/22b806df84ccaa12f683bbead214b401.json","name":"x_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/3707850cc73c25c4ad359600d067be8a.json","name":"x_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/88f471a5d5a9a5c6121aafa2275dcbec.png","name":"x_tex.png"},"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"1","posX":1295.4850518103412,"posY":667.9986076510152,"rect":{"x":594.97,"y":490.42,"width":299.02,"height":197.58},"rectNew":3},{"id":"1667204385330","index":3,"itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a017f5393a91158025a305b5f11d8a19.json","name":"Aa_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/e7b93cb591e5597880ad8051e1863705.json","name":"Aa_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ce2dbe0d0ad9cad3631309d85b82f1e1.png","name":"Aa_tex.png"},"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"1","posX":1777.4741331860437,"posY":621.9986862822941,"rect":{"x":1020.1,"y":449.85,"width":299.02,"height":197.58},"rectNew":4},{"id":"1667357944092","index":4,"audio_url":"http://staging-teach.cdn.ireadabc.com/1a4ca873ff98e4528c6cf4bd4af2affb.mp3","itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"3","posX":1033.5,"posY":187,"rect":{"x":486.92,"y":138.48,"width":52.92,"height":52.92}},{"id":"1667358192264","index":5,"audio_url":"http://staging-teach.cdn.ireadabc.com/a7c95c047e5ee688af32c5b85df4abce.mp3","itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"3","posX":1474.4955504285404,"posY":160.9996413646554,"rect":{"x":875.91,"y":115.55,"width":52.92,"height":52.92}},{"id":"1667358213239","index":6,"audio_url":"http://staging-teach.cdn.ireadabc.com/18dc846899b20f7c63a1afd29e0b478e.mp3","itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"3","posX":1910.4947046628347,"posY":177.99969122839315,"rect":{"x":1260.48,"y":130.54,"width":52.92,"height":52.92}},{"id":"1667358221452","index":7,"audio_url":"http://staging-teach.cdn.ireadabc.com/55b8017a6204f6aaa876b4acc1d3ad19.mp3","itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"3","posX":1010.4838685054881,"posY":501.99965862518,"rect":{"x":466.62,"y":416.33,"width":52.92,"height":52.92}},{"id":"1667358232076","index":8,"audio_url":"http://staging-teach.cdn.ireadabc.com/91b08d44d67b518beec267237c27f200.mp3","itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"3","posX":1455.4755945771267,"posY":556.9990372462943,"rect":{"x":859.13,"y":464.84,"width":52.92,"height":52.92}},{"id":"1667358238658","index":9,"audio_url":"http://staging-teach.cdn.ireadabc.com/b780c5f3fd3148366e3309f2874be5fb.mp3","itemType":"rect","fontScale":1.815625,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.815625,"dragDot":{"x":1162,"y":436.46497538811053},"gIdx":"3","posX":1938.474741140077,"posY":515.9989317653107,"rect":{"x":1285.16,"y":428.68,"width":52.92,"height":52.92}}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/e94766af9c75bcdc8308a914929afc74.png","rect":{"x":277.69,"y":0,"width":2085.62,"height":2698}},"hotZoneItemArr2":[{"id":"1667204631307","index":0,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1349},"gIdx":"6","labelText":"Aa","posX":1787.5,"posY":1255,"rect":{"x":1328.31,"y":1133,"width":363,"height":244}},{"id":"1667204648423","index":1,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1349},"gIdx":"6","labelText":"Aa","posX":814.5001194509741,"posY":1602.0003210085065,"rect":{"x":355.31,"y":1480,"width":363,"height":244}},{"id":"1667204655483","index":2,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1349},"gIdx":"6","labelText":"X","posX":1292.4998705734629,"posY":1662.00040976544,"rect":{"x":833.31,"y":1540,"width":363,"height":244}},{"id":"1667204665055","index":3,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1349},"gIdx":"6","labelText":"Aa","posX":1811.4999928380573,"posY":1615.00042511246,"rect":{"x":1352.31,"y":1493,"width":363,"height":244}}],"isDebug":false}
		return {"page_id":"5","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bg_pic_url":"http://staging-teach.cdn.ireadabc.com/5a7e40d2a1cb79aeab851dd380b697fb.png","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/6f81dd60dd115bb7224c018d9a65fc7f.png","rect":{"x":451.47,"y":0,"width":1738.07,"height":992}},"hotZoneItemArr":[{"id":"1667204308783","index":0,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a017f5393a91158025a305b5f11d8a19.json","name":"Aa_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/e7b93cb591e5597880ad8051e1863705.json","name":"Aa_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ce2dbe0d0ad9cad3631309d85b82f1e1.png","name":"Aa_tex.png"},"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"1","posX":1752.4841734414226,"posY":285.99933067521255,"rect":{"x":1131.51,"y":174,"width":339,"height":224},"rectNew":1},{"id":"1667204370017","index":1,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a017f5393a91158025a305b5f11d8a19.json","name":"Aa_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/e7b93cb591e5597880ad8051e1863705.json","name":"Aa_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ce2dbe0d0ad9cad3631309d85b82f1e1.png","name":"Aa_tex.png"},"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"1","posX":847.4859110008995,"posY":610.998716967671,"rect":{"x":226.52,"y":499,"width":339,"height":224},"rectNew":2},{"id":"1667204377049","index":2,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/22b806df84ccaa12f683bbead214b401.json","name":"x_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/3707850cc73c25c4ad359600d067be8a.json","name":"x_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/88f471a5d5a9a5c6121aafa2275dcbec.png","name":"x_tex.png"},"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"1","posX":1295.4850518103412,"posY":667.9986076510152,"rect":{"x":674.52,"y":556,"width":339,"height":224},"rectNew":3},{"id":"1667204385330","index":3,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a017f5393a91158025a305b5f11d8a19.json","name":"Aa_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/e7b93cb591e5597880ad8051e1863705.json","name":"Aa_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/ce2dbe0d0ad9cad3631309d85b82f1e1.png","name":"Aa_tex.png"},"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"1","posX":1777.4741331860437,"posY":621.9986862822941,"rect":{"x":1156.5,"y":510,"width":339,"height":224},"rectNew":4},{"id":"1667357944092","index":4,"audio_url":"http://staging-teach.cdn.ireadabc.com/1a4ca873ff98e4528c6cf4bd4af2affb.mp3","itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":496},"gIdx":"3","posX":1033.5,"posY":187,"rect":{"x":552.03,"y":157,"width":60,"height":60}},{"id":"1667358192264","index":5,"audio_url":"http://staging-teach.cdn.ireadabc.com/a7c95c047e5ee688af32c5b85df4abce.mp3","itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"3","posX":1474.4955504285404,"posY":160.9996413646554,"rect":{"x":993.03,"y":131,"width":60,"height":60}},{"id":"1667358213239","index":6,"audio_url":"http://staging-teach.cdn.ireadabc.com/18dc846899b20f7c63a1afd29e0b478e.mp3","itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"3","posX":1910.4947046628347,"posY":177.99969122839315,"rect":{"x":1429.02,"y":148,"width":60,"height":60}},{"id":"1667358221452","index":7,"audio_url":"http://staging-teach.cdn.ireadabc.com/55b8017a6204f6aaa876b4acc1d3ad19.mp3","itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"3","posX":1010.4838685054881,"posY":501.99965862518,"rect":{"x":529.01,"y":472,"width":60,"height":60}},{"id":"1667358232076","index":8,"audio_url":"http://staging-teach.cdn.ireadabc.com/91b08d44d67b518beec267237c27f200.mp3","itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"3","posX":1455.4755945771267,"posY":556.9990372462943,"rect":{"x":974.01,"y":527,"width":60,"height":60}},{"id":"1667358238658","index":9,"audio_url":"http://staging-teach.cdn.ireadabc.com/b780c5f3fd3148366e3309f2874be5fb.mp3","itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":495.99999999999994},"gIdx":"3","posX":1938.474741140077,"posY":515.9989317653107,"rect":{"x":1457,"y":486,"width":60,"height":60}}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/e94766af9c75bcdc8308a914929afc74.png","rect":{"x":277.69,"y":0,"width":2085.62,"height":2698}},"hotZoneItemArr2":[{"id":"1667204631307","index":0,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1349},"gIdx":"6","labelText":"Aa","posX":1787.5,"posY":1255,"rect":{"x":1328.31,"y":1133,"width":363,"height":244}},{"id":"1667204648423","index":1,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1349},"gIdx":"6","labelText":"Aa","posX":814.5001194509741,"posY":1602.0003210085065,"rect":{"x":355.31,"y":1480,"width":363,"height":244}},{"id":"1667204655483","index":2,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1349},"gIdx":"6","labelText":"X","posX":1292.4998705734629,"posY":1662.00040976544,"rect":{"x":833.31,"y":1540,"width":363,"height":244}},{"id":"1667204665055","index":3,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1349},"gIdx":"6","labelText":"Aa","posX":1811.4999928380573,"posY":1615.00042511246,"rect":{"x":1352.31,"y":1493,"width":363,"height":244}}],"isDebug":false}
		return {"page_id":"13","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3","bg_pic_url":"http://staging-teach.cdn.ireadabc.com/103588a383dfef103f7d88081131a58b.png","bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b11402c53d03d9b8966c1a5386c4d0b4.png","rect":{"x":382.88,"y":0,"width":1467.24,"height":841}},"hotZoneItemArr":[{"id":"1667284178410","index":0,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":652.5,"posY":380.5,"rect":{"x":169.62,"y":302,"width":200,"height":157},"circleItem":1},{"id":"1667285795465","index":1,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1004.5005700463794,"posY":566.4995325373978,"rect":{"x":521.62,"y":488,"width":200,"height":157},"circleItem":2},{"id":"1667285801759","index":2,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/29b438b66c46206a683982c2dec2c1c6.json","name":"draw_circle_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/2e0851230cec969f8a805563c9cbb177.json","name":"draw_circle_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/9531e99ab1f656893c74ee5868632f6a.png","name":"draw_circle_tex.png"},"dragDot":{"x":1116.5,"y":420.5},"gIdx":"2","posX":1679.500137597402,"posY":754.4993040274268,"rect":{"x":1196.62,"y":676,"width":200,"height":157},"circleItem":3}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/ef323091055c36876dfe25b5e8ed0128.png","rect":{"x":231,"y":0,"width":1771,"height":2291}},"hotZoneItemArr2":[{"id":"1667284877942","index":0,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"dragDot":{"x":1116.5,"y":1145.5},"gIdx":"7","posX":620.5,"posY":1160.5,"rect":{"x":289,"y":1081,"width":201,"height":159}},{"id":"1667284894146","index":1,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"dragDot":{"x":1116.5,"y":1145.5},"gIdx":"7","posX":988.5001409500544,"posY":1354.4996702166568,"rect":{"x":668,"y":1271,"width":179,"height":167}},{"id":"1667284911442","index":2,"itemType":"rect","fontScale":1.74453125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.74453125,"dragDot":{"x":1116.5,"y":1145.5},"gIdx":"7","posX":1700.5000363742076,"posY":1549.4996150869986,"rect":{"x":1388,"y":1473,"width":163,"height":153}}],"isDebug":false}
	
		return {
			"page_id":"5",
			"book_id":"opw1",
			"part_name":"d",
			"begin_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3",
			"idle_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3",
			"finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3",
			"finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3",
			"error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3",
			"error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/3d307a02663e1cd667b7c951340ec98b.mp3",
			"bg_pic_url":"http://staging-teach.cdn.ireadabc.com/103588a383dfef103f7d88081131a58b.png",
			"bgItem":{
					"url":"http://staging-teach.cdn.ireadabc.com/a719aea051e0cb4c78c3b863d6d4b432.png",
					"rect":{
							"x":451.47,
							"y":0,
							"width":1738.07,
							"height":992
					}
			},
			"hotZoneItemArr":[
					{
							"id":"1667204308783",
							"index":0,
							"itemType":"rect",
							"fontScale":2.06328125,
							"imgScale":1,
							"imgSizeW":0,
							"imgSizeH":0,
							"mapScale":2.06328125,
							"skeJsonData":{
									"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json",
									"name":"A大黑_ske.json"
							},
							"texJsonData":{
									"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json",
									"name":"A大黑_tex.json"
							},
							"texPngData":{
									"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png",
									"name":"A大黑_tex.png"
							},
							"dragDot":{
									"x":1320.5,
									"y":496
							},
							"gIdx":"1",
							"posX":1751.5,
							"posY":349,
							"rect":{
									"x":1130.53,
									"y":237,
									"width":339,
									"height":224
							},
							"rectItem":1,
							"rectNew":1
					},
					{
							"id":"1667204370017",
							"index":1,
							"itemType":"rect",
							"fontScale":2.06328125,
							"imgScale":1,
							"imgSizeW":0,
							"imgSizeH":0,
							"mapScale":2.06328125,
							"skeJsonData":{
									"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json",
									"name":"A大黑_ske.json"
							},
							"texJsonData":{
									"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json",
									"name":"A大黑_tex.json"
							},
							"texPngData":{
									"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png",
									"name":"A大黑_tex.png"
							},
							"dragDot":{
									"x":1320.5,
									"y":495.99999999999994
							},
							"gIdx":"1",
							"posX":845.4941734222443,
							"posY":668.9993306752126,
							"rect":{
									"x":224.52,
									"y":557,
									"width":339,
									"height":224
							},
							"rectItem":2,
							"rectNew":2
					},
					{
							"id":"1667204377049",
							"index":2,
							"itemType":"rect",
							"fontScale":2.06328125,
							"imgScale":1,
							"imgSizeW":0,
							"imgSizeH":0,
							"mapScale":2.06328125,
							"skeJsonData":{
									"url":"http://staging-teach.cdn.ireadabc.com/635f6425c4fc681b360f823ee87bd241.json",
									"name":"X大黑_ske.json"
							},
							"texJsonData":{
									"url":"http://staging-teach.cdn.ireadabc.com/d3f43dfcca2d63e95777f27c09f9da91.json",
									"name":"X大黑_tex.json"
							},
							"texPngData":{
									"url":"http://staging-teach.cdn.ireadabc.com/722e8495d43b7027a594f6e373f5ceed.png",
									"name":"X大黑_tex.png"
							},
							"dragDot":{
									"x":1320.5,
									"y":495.99999999999994
							},
							"gIdx":"1",
							"posX":1293.4859110008995,
							"posY":725.998716967671,
							"rect":{
									"x":672.52,
									"y":614,
									"width":339,
									"height":224
							},
							"rectItem":3,
							"rectNew":3
					},
					{
							"id":"1667204385330",
							"index":3,
							"itemType":"rect",
							"fontScale":2.06328125,
							"imgScale":1,
							"imgSizeW":0,
							"imgSizeH":0,
							"mapScale":2.06328125,
							"skeJsonData":{
									"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json",
									"name":"A大黑_ske.json"
							},
							"texJsonData":{
									"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json",
									"name":"A大黑_tex.json"
							},
							"texPngData":{
									"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png",
									"name":"A大黑_tex.png"
							},
							"dragDot":{
									"x":1320.5,
									"y":495.99999999999994
							},
							"gIdx":"1",
							"posX":1772.4850518103412,
							"posY":684.9986076510152,
							"rect":{
									"x":1151.52,
									"y":573,
									"width":339,
									"height":224
							},
							"rectItem":4,
							"rectNew":4
					}
			],
			"bgItem2":{
					"url":"http://staging-teach.cdn.ireadabc.com/e94766af9c75bcdc8308a914929afc74.png",
					"rect":{
							"x":277.69,
							"y":0,
							"width":2085.62,
							"height":2698
					}
			},
			"hotZoneItemArr2":[
					{
							"id":"1667204631307",
							"index":0,
							"itemType":"rect",
							"fontScale":2.06328125,
							"imgScale":1,
							"imgSizeW":0,
							"imgSizeH":0,
							"mapScale":2.06328125,
							"dragDot":{
									"x":1320.5,
									"y":1349
							},
							"gIdx":"6",
							"labelText":"Aa",
							"posX":1787.5,
							"posY":1255,
							"rect":{
									"x":1328.31,
									"y":1133,
									"width":363,
									"height":244
							}
					},
					{
							"id":"1667204648423",
							"index":1,
							"itemType":"rect",
							"fontScale":2.06328125,
							"imgScale":1,
							"imgSizeW":0,
							"imgSizeH":0,
							"mapScale":2.06328125,
							"dragDot":{
									"x":1320.5,
									"y":1349
							},
							"gIdx":"6",
							"labelText":"Aa",
							"posX":814.5001194509741,
							"posY":1602.0003210085065,
							"rect":{
									"x":355.31,
									"y":1480,
									"width":363,
									"height":244
							}
					},
					{
							"id":"1667204655483",
							"index":2,
							"itemType":"rect",
							"fontScale":2.06328125,
							"imgScale":1,
							"imgSizeW":0,
							"imgSizeH":0,
							"mapScale":2.06328125,
							"dragDot":{
									"x":1320.5,
									"y":1349
							},
							"gIdx":"6",
							"labelText":"X",
							"posX":1292.4998705734629,
							"posY":1662.00040976544,
							"rect":{
									"x":833.31,
									"y":1540,
									"width":363,
									"height":244
							}
					},
					{
							"id":"1667204665055",
							"index":3,
							"itemType":"rect",
							"fontScale":2.06328125,
							"imgScale":1,
							"imgSizeW":0,
							"imgSizeH":0,
							"mapScale":2.06328125,
							"dragDot":{
									"x":1320.5,
									"y":1349
							},
							"gIdx":"6",
							"labelText":"Aa",
							"posX":1811.4999928380573,
							"posY":1615.00042511246,
							"rect":{
									"x":1352.31,
									"y":1493,
									"width":363,
									"height":244
							}
					}
			],
			"isDebug":false
	}
		// return {"bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/756f53dfb74f400a33f036b6a352346a.png","rect":{"x":140.31,"y":0,"width":1713.38,"height":753}},"hotZoneItemArr":[{"id":"1648109513339","index":0,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json","name":"A大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json","name":"A大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png","name":"A大黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":651.9775376995343,"posY":333.11899227435464,"rect":{"x":439.55,"y":261,"width":144.24,"height":144.24},"rectItem":1},{"id":"1666579559326","index":1,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json","name":"A大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json","name":"A大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png","name":"A大黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":818.9792800693633,"posY":333.1207054065696,"rect":{"x":606.55,"y":261,"width":144.24,"height":144.24},"rectItem":2},{"id":"1666579574503","index":2,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json","name":"A大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json","name":"A大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png","name":"A大黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":985.9796252790716,"posY":333.1207011966951,"rect":{"x":773.55,"y":261,"width":144.24,"height":144.24},"rectItem":3},{"id":"1666579582478","index":3,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json","name":"A大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json","name":"A大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png","name":"A大黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":1151.9799768035916,"posY":333.1207011966951,"rect":{"x":939.55,"y":261,"width":144.24,"height":144.24},"rectItem":4},{"id":"1666579590315","index":4,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json","name":"A大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json","name":"A大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png","name":"A大黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":1317.9803262231742,"posY":333.1207011966951,"rect":{"x":1105.55,"y":261,"width":144.24,"height":144.24},"rectItem":5},{"id":"1666579597434","index":5,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json","name":"A大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json","name":"A大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png","name":"A大黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":1484.9806756427568,"posY":332.1207011966951,"rect":{"x":1272.55,"y":260,"width":144.24,"height":144.24},"rectItem":6},{"id":"1666579606163","index":6,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/14c5231012b4a1f3ac898ca6f83bc213.json","name":"A大黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/a9e874a147023e0944cf89c351661218.json","name":"A大黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/8e12ae87d2c1a7bb6fc320272a930d9b.png","name":"A大黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":1652.981027167277,"posY":333.1206990917579,"rect":{"x":1440.55,"y":261,"width":144.24,"height":144.24},"rectItem":7},{"id":"1666579650281","index":7,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/356e9e26a2a74c57791fff7471142d54.json","name":"A小黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/9a262fdad701a170994510e1562baa76.json","name":"A小黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/500b883b3c0c0613a6de963f3deb7f72.png","name":"A小黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":655.9792779644263,"posY":592.1207054065696,"rect":{"x":475.55,"y":552,"width":80.24,"height":80.24},"rectItem":8},{"id":"1666579715448","index":8,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/356e9e26a2a74c57791fff7471142d54.json","name":"A小黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/9a262fdad701a170994510e1562baa76.json","name":"A小黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/500b883b3c0c0613a6de963f3deb7f72.png","name":"A小黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":821.9792821743006,"posY":592.1212463754416,"rect":{"x":641.55,"y":552,"width":80.24,"height":80.24},"rectItem":9},{"id":"1666579721185","index":9,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/356e9e26a2a74c57791fff7471142d54.json","name":"A小黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/9a262fdad701a170994510e1562baa76.json","name":"A小黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/500b883b3c0c0613a6de963f3deb7f72.png","name":"A小黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":987.9796315938834,"posY":592.1212463754416,"rect":{"x":807.55,"y":552,"width":80.24,"height":80.24},"rectItem":10},{"id":"1666579748477","index":10,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/356e9e26a2a74c57791fff7471142d54.json","name":"A小黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/9a262fdad701a170994510e1562baa76.json","name":"A小黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/500b883b3c0c0613a6de963f3deb7f72.png","name":"A小黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":1152.979981013466,"posY":591.1212463754416,"rect":{"x":972.55,"y":551,"width":80.24,"height":80.24},"rectItem":11},{"id":"1666579759406","index":11,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/356e9e26a2a74c57791fff7471142d54.json","name":"A小黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/9a262fdad701a170994510e1562baa76.json","name":"A小黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/500b883b3c0c0613a6de963f3deb7f72.png","name":"A小黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":1319.9803283281115,"posY":592.1212442705043,"rect":{"x":1139.55,"y":552,"width":80.24,"height":80.24},"rectItem":12},{"id":"1666579767617","index":12,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/356e9e26a2a74c57791fff7471142d54.json","name":"A小黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/9a262fdad701a170994510e1562baa76.json","name":"A小黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/500b883b3c0c0613a6de963f3deb7f72.png","name":"A小黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":1486.9806798526315,"posY":591.1212463754416,"rect":{"x":1306.55,"y":551,"width":80.24,"height":80.24},"rectItem":13},{"id":"1666579776491","index":13,"itemType":"rect","fontScale":1.5578125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.5578125,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/356e9e26a2a74c57791fff7471142d54.json","name":"A小黑_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/9a262fdad701a170994510e1562baa76.json","name":"A小黑_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/500b883b3c0c0613a6de963f3deb7f72.png","name":"A小黑_tex.png"},"dragDot":{"x":997,"y":377.9515186915889},"gIdx":"1","posX":1652.9810313771513,"posY":591.1212442705043,"rect":{"x":1472.55,"y":551,"width":80.24,"height":80.24},"rectItem":14}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/e94766af9c75bcdc8308a914929afc74.png","rect":{"x":277.69,"y":0,"width":2085.62,"height":2698}},"hotZoneItemArr2":[{"id":"1648109571306","index":0,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"A","posX":719.8113247477669,"posY":320.51428676094304,"rect":{"x":610.86,"y":338.08,"width":134.68,"height":167.1}},{"id":"1666579968289","index":1,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"A","posX":867.8193744304583,"posY":321.51572337261587,"rect":{"x":806.89,"y":339.39,"width":132.02,"height":167.1}},{"id":"1666579994615","index":2,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"A","posX":1015.8247084640105,"posY":320.51572562952305,"rect":{"x":1001.58,"y":338.08,"width":132.02,"height":167.1}},{"id":"1666580015202","index":3,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"A","posX":1162.825042486278,"posY":320.51572337261587,"rect":{"x":1194.96,"y":338.08,"width":132.02,"height":167.1}},{"id":"1666580027207","index":4,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"A","posX":1310.8253742516388,"posY":319.51572337261587,"rect":{"x":1389.65,"y":336.76,"width":132.02,"height":167.1}},{"id":"1666580037250","index":5,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"A","posX":1458.8357082964758,"posY":319.51572111570863,"rect":{"x":1584.35,"y":336.76,"width":132.02,"height":167.1}},{"id":"1666580046055","index":6,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"A","posX":1606.8460423413126,"posY":319.51572111570863,"rect":{"x":1779.04,"y":336.76,"width":132.02,"height":167.1}},{"id":"1666580062206","index":7,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"a","posX":720.8563763861493,"posY":552.5157211157086,"rect":{"x":632.01,"y":680.09,"width":95.09,"height":93.43}},{"id":"1666580091178","index":8,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"a","posX":868.8593767776417,"posY":551.5162469750896,"rect":{"x":826.71,"y":678.78,"width":95.09,"height":93.43}},{"id":"1666580100237","index":9,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"a","posX":1015.8597130568169,"posY":552.5162469750896,"rect":{"x":1020.09,"y":680.09,"width":95.09,"height":93.43}},{"id":"1666580136217","index":10,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"a","posX":1162.86004256527,"posY":551.5162469750896,"rect":{"x":1213.45,"y":678.78,"width":95.09,"height":93.43}},{"id":"1666580149733","index":11,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"a","posX":1311.8603743306307,"posY":552.5162447181824,"rect":{"x":1409.49,"y":680.09,"width":95.09,"height":93.43}},{"id":"1666580185791","index":12,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"a","posX":1459.8707106323745,"posY":551.5162469750896,"rect":{"x":1604.16,"y":678.78,"width":95.09,"height":93.43}},{"id":"1666580196584","index":13,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1364.465245327103},"gIdx":"1","labelText":"a","posX":1607.8810446772115,"posY":551.5162447181824,"rect":{"x":1798.86,"y":678.78,"width":95.09,"height":93.43}},{"id":"1666580942163","index":14,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1358.2474924774324},"gIdx":"3","labelText":"rac w a say","posX":852.5209556527826,"posY":265.6527451973004,"rect":{"x":279.35,"y":233,"width":590.96,"height":65.31}},{"id":"1666581259730","index":15,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1358.2474924774324},"gIdx":"4","labelText":"Lis Aa ","posX":665.8463653932971,"posY":587.3348101283482,"rect":{"x":282.46,"y":925.58,"width":1103.35,"height":76.59}},{"id":"1666582092777","index":16,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1358.2474924774324},"gIdx":"2","posX":1327.5481309684806,"posY":608.7920397020446,"rect":{"x":75.1,"y":212.18,"width":1949.51,"height":793.22}},{"id":"1666679136549","index":17,"itemType":"rect","fontScale":2.06328125,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":2.06328125,"dragDot":{"x":1320.5,"y":1349},"gIdx":"5","labelText":"A","posX":559.5,"posY":425,"rect":{"x":220.31,"y":341,"width":123,"height":168}}],"firstPart":"0","isDebug":false,"page_id":"5","book_id":"opw1","part_name":"c","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/5a1a2670845bfe76662e86d9a3a69f81.mp3","change_stage_audio_url":"http://staging-teach.cdn.ireadabc.com/4c0379bc0f3bd0722874b2e11fb35336.mp3","stage_1_audio_url":"http://staging-teach.cdn.ireadabc.com/495324991838775e49e3ca6593d432c9.mp3","stage_2_audio_url":"http://staging-teach.cdn.ireadabc.com/17cc0e2a383e4632147dc495a1397915.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/ae270b1453fa86f7d4ee432382f60a70.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/a5b132bdb52a57cb9bd214bc24d77d0b.mp3","error_audio_url":"http://staging-teach.cdn.ireadabc.com/7586220a8fe9fcf2c34bbaf3908e1fcd.mp3","idle_audio_url":"http://staging-teach.cdn.ireadabc.com/e91133b3e83cae39db5c769812efdec1.mp3","isGuide":false,"error_link_audio_url":"http://staging-teach.cdn.ireadabc.com/6e72b37ac065de9467e4def6a2f0e252.mp3","error_write_audio_url":"http://staging-teach.cdn.ireadabc.com/41a94792d1e1a01f58adea3ab7af7628.mp3"}
	
	},

	preload() {
		const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
		console.log(' in preload preloadArr: ', preloadArr);
		cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {
			console.log(' preload data, ', data);


			this.addServerListener();
			// if (window && window["air"]) {
			// 	window["air"].hideAirClassLoading();
			// }
		});
	},

	addServerListener() {
		
		if (window && window["air"]) {
			// cc.find('Canvas').opacity = 0;
			// window.air.onCourseInScreen = (next) => {
			// 	//  cc.find('Canvas').opacity = 255;
			// 	this.loadEnd();
			// 	next();
			// }
			this.loadEnd();
			window.air.hideAirClassLoading();
		} else {
			this.loadEnd();
		}


		if (window.air) {

			window.air.osmoHandwritingCallback = (data) => {

				if (!data) {
					console.log('data is not exist!!!');
					return;
				}

				console.log('osmoHandwritingCallback data: ', data);

				if (typeof (data) == 'string') {
					console.log('data is string ');
					const dataObj = JSON.parse(data);

					this.photoEnd(dataObj);
					return;
				}

				// 哲学逻辑
				this.photoEnd(data);

			}

			
		}

	},

	addPreloadImage() {
	
		if (this.data.bg_pic_url) {
			this._imageResList.push({ url: this.data.bg_pic_url || ''});
		}

		if (this.data.bgItem) {
			this._imageResList.push({ url: this.data.bgItem.url || ''});
		}

		if (this.data.bgItem2) {
			this._imageResList.push({ url: this.data.bgItem2.url || ''});
		}

		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.pic_url) {
				this._imageResList.push({ url: item.pic_url || ''});
			}
		})
	},

	addPreloadAudio() {

		if (this.data.questionArr) {
			const arr = this.data.questionArr;
			for (let i=0 ;i<arr.length; i++) {
				this._audioResList.push({url: arr[i].audio_url || ''});
				this._audioResList.push({url: arr[i].video_url || ''});
			}
		}

	},

	addPreloadAnima() {
		if (!this.data.hotZoneItemArr) {
			return;
		}
		this.data.hotZoneItemArr.forEach((item) => {
			if (item.skeJsonData) {
				this._animaResList.push({ url: item.skeJsonData.url || '' });
				this._animaResList.push({ url: item.texJsonData.url || ''});
				this._animaResList.push({ url: item.texPngData.url || ''});
			}
		})
	},

	loadEnd() {
		console.log(' in loadEnd');
		this.initData();
		this.initView();
		// this.initMusic();

		// this.startTesting();

		cc.debug.setDisplayStats(true);

	},

	initMusic() {
		cc.assetManager.loadRemote(this.data.bg_audio_url, (err, clip) => {
			cc.audioEngine.setMusicVolume(0.3);
			const audioID = cc.audioEngine.playMusic(clip, true);
		});
	},

	curGroupIndex: null,
	curQuestionIndex: null,
	curQuestionData: null,

	picNodeArr: null,


	firstItemData: null,
	bottomItemData: null,
	animaNodeArr: null,

	initData() {
		console.log(' in initData');

		// this.curGroupIndex = 0;
		// this.curQuestionIndex = 0;
		// this.setCurGroupAndQuestion()

		// console.log('this.curQuestionData', this.curQuestionData)

		this.animaNodeArr = [];

		this.picNodeArr = [];
		this.initAudioEffect();


		this.centerItemArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '1');
		this.benchmark1Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '3')[0];
		this.benchmark2Data = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '4')[0];
		this.firstItemData = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '5')[0];

		this.newRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '6');
		this.circleRectArr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, '7');


		if (this.benchmark1Data) {
			this.initCheckBase();
		} 
	},

	initCheckBase() {


		console.log('benchmark1Data: ', this.benchmark1Data);
		console.log('benchmark2Data: ', this.benchmark2Data);
		console.log('centerItemArr: ', this.centerItemArr);

		const benchmark1Rect = this.benchmark1Data.rect;
		const benchmark2Rect = this.benchmark2Data.rect;
		
		const benchmark1CenterY = (benchmark1Rect.y + benchmark1Rect.height / 2);
		const benchmark2CenterY = (benchmark2Rect.y + benchmark2Rect.height / 2);
		
		let unitH = benchmark2CenterY - benchmark1CenterY;
		let unitW = benchmark2Rect.x + benchmark2Rect.width - benchmark1Rect.x;
		let baseX = benchmark1Rect.x;
		let baseY = benchmark1CenterY;


		if (this.firstItemData) {
			const firstItemRect = this.firstItemData.rect;
			baseX = firstItemRect.x + firstItemRect.width / 2;
			baseY = firstItemRect.y + firstItemRect.height / 2;
			unitW = benchmark1Rect.x + benchmark1Rect.width - (firstItemRect.x + firstItemRect.width / 2);
			unitH = (firstItemRect.y + firstItemRect.height / 2) - benchmark1CenterY;
		}


		for(let i=0; i<this.centerItemArr.length; i++) {

			const itemRect = this.centerItemArr[i].rect;
			const x = itemRect.x + itemRect.width / 2;
			const y = itemRect.y + itemRect.height / 2;

			const unitX = (x - baseX) / unitW;
			const unitY = (y - baseY) / unitH;
			const unitW2 = itemRect.width / unitW;
			const unitH2 = itemRect.height / unitH;


			this.centerItemArr[i].unitX = unitX;
			this.centerItemArr[i].unitY = unitY;
			this.centerItemArr[i].unitW = unitW2;
			this.centerItemArr[i].unitH = unitH2;

			// console.log('unitX: ', unitX)
			// console.log('unitY: ', unitY)
		}

		console.log('unitH: ', unitH)
		console.log('unitW: ', unitW)
		console.log('baseX: ', baseX)
		console.log('baseY: ', baseY)

	
		const centerX = this.data.bgItem2.rect.width / 2;
		this.centerUnitW = (centerX - baseX) / unitW;



	},

	getGroupArrByGIdx(arr, gIdx) {
		const groupArr = [];
		for (let i=0; i<arr.length; i++) {
			if (arr[i].gIdx == gIdx) {
				groupArr.push(arr[i]);
			}
		}

		return groupArr;
	},

	curGroup: null,
	setCurGroupAndQuestion() {
		this.curGroup = this.data.groupArr[this.curGroupIndex];

		if (!this.curGroup) {
			this.gameEnd();
		} else {
			this.curQuestionIndex = 0;
			this.setCurQuestionData();
		}
	},

	setCurQuestionData() {
		this.curQuestionData = this.curGroup.questionArr[this.curQuestionIndex];

		if (!this.curQuestionData) {

			this.hideVideo();
			this.showBigStar();
		}
	},

	hideVideo() {
		this.videoNode.active = false;

		this.videoNode.player.pause();
		this.videoNode.pauseBtn.active = false;
		this.videoNode.playBtn.active = true;
	},


	rightClip: null,
	wrongClip: null,
	bigStarClip: null,
	btnClip: null,
	finishClip: null,
	selectClip: null,
	starCountClip: null,
	initAudioEffect() {
		this.rightClip = cc.find('Canvas/res/audio/right').getComponent(cc.AudioSource).clip;
		this.wrongClip = cc.find('Canvas/res/audio/wrong').getComponent(cc.AudioSource).clip;
		this.bigStarClip = cc.find('Canvas/res/audio/big_star').getComponent(cc.AudioSource).clip;
		this.btnClip = cc.find('Canvas/res/audio/btn').getComponent(cc.AudioSource).clip;
		this.finishClip = cc.find('Canvas/res/audio/finish').getComponent(cc.AudioSource).clip;
		this.selectClip = cc.find('Canvas/res/audio/select').getComponent(cc.AudioSource).clip;
		this.starCountClip = cc.find('Canvas/res/audio/star_count').getComponent(cc.AudioSource).clip;
	},



	initView() {

		console.log(' in initView');

		this.initBg();
		this.initHotZone();
		this.initDebugLayer();

		console.log(' in initView 2');

		// this.initQuestion();
		// this.initOption();
		// this.initBtn();
		// this.initIcon();
		// this.initMask();

		// this.setCurQuestion();
		// this.setCurOption();

		// this.initStar();
	},

	checkStart() {
		for (let i=0; i<this.picNodeArr.length; i++) {
			if (!this.picNodeArr[i].isLoadEnd) {
				return;
			}
		}

		if (this.isTestStart) {
			return;
		}
		this.isTestStart = true;

		this.startTesting();
	},

	//调起检测
	startTesting() {

		// this.ques_region = [
		// 	0, 0.077,
		// 	1, 0.077,
		// 	1, 0.331,
		// 	0, 0.331,
		// ]



		const writeRegions = this.getRegionsByGidx('6')
		const circleRegions = this.getRegionsByGidx('7')
		const lineRegions = this.getRegionsByGidx('8')
		console.log('writeRegions: ', writeRegions);
		console.log('circleRegions: ', circleRegions);
		

		this.getPhotoData((data) => { 
			this.photoEnd(data);
		});     
		return;

		const cw = window.courseware;
		if (!cw || !cw.openOsmoHandwriting) {

			console.log('cw.openOsmoHandwriting not exist');
			return;
		}


		// write_regions : []


		const para = {
			"library_id": "iplayabc",
			"page_id": this.data.page_id, //27,
			"book_id": this.data.book_id,//"opw1",
			"part_name": this.data.part_name, //"d",
			// "is_hand_writing": true,
			// "is_line_link": false,
			"write_regions": writeRegions,
			"circle_regions": circleRegions,
			"line_regions": lineRegions,
		}


		// const para = {
		// 	"library_id": "iplayabc",
		// 	'page_id': 5,
		// 	'book_id': 'opw1',
		// 	'part_name': 'c',
		// 	'is_hand_writing': true,
		// 	'is_line_link': false,
		// 	'ques_region' : [
		// 		0, 0.077,
		// 		1, 0.077,
		// 		1, 0.331,
		// 		0, 0.331,
		// 	]
		// }
		cw.openOsmoHandwriting(para);


		// setInterval(() => {
		// this.getPhotoData((data) => {
		// 	this.photoEnd(data);
		// });           

		// }, 1000);
	},

	//结束检测
	endTesting() {
		
		const cw = window.courseware;
		if (!cw || !cw.closeOsmoHandwriting) {

			return;
		}
		cw.closeOsmoHandwriting();


		// const cw = window.courseware;
		// if (!cw || !cw.closeOsmoHandwritingMlkit) {

		// 	return;
		// }
		// cw.closeOsmoHandwritingMlkit();
		// // this.isTesting = false;
	},

	getRegionsByGidx(gIdx) {

		const arr = this.getGroupArrByGIdx(this.data.hotZoneItemArr2, gIdx);
		const bgRect = this.data.bgItem2.rect;
		
		console.log("arr:", arr);
		const newLocationArr = [];
		for (let i=0; i<arr.length; i++) {

			const hzItem = arr[i];
			const regionRect = hzItem.rect;

			const left = Math.round( (regionRect.x ) / bgRect.width  * 1000 ) / 1000;
			const right =  Math.round( (regionRect.x + regionRect.width) / bgRect.width * 1000 ) / 1000;
			const top =  Math.round( (regionRect.y ) / bgRect.height * 1000 ) / 1000;
			const bottom =  Math.round( (regionRect.y + regionRect.height) / bgRect.height * 1000 ) / 1000;

			newLocationArr.push({left, top, right, bottom})
		}

		return newLocationArr;

	},



	changeWriteData(result) {
		const curTextArr = result.text;
		const bboxTextArr = [];
		for (let i=0; i<curTextArr.length; i++) {

			const score = curTextArr[i].score;

			const {left, right, top, bottom} = curTextArr[i];
			const text = curTextArr[i].content;

			console.log('text..', JSON.stringify( curTextArr[i] ));
			console.log('text..', text);
			const disW = (right - left) / text.length;
			const disH = (bottom - top);
			for (let j=0; j<text.length; j++) {

				const x1 = left + j * disW;
				const y1 = top;

				const x2 = x1 + disW;
				const y2 = y1;

				const x3 = x2;
				const y3 = y2 + disH;

				const x4 = x1;
				const y4 = y3;

				// const bbox = [{x1, y1}, {x2, y2}, {x3, y3}, {x4, y4}]
				const bbox = {left: x1, right: x2, top: y1, bottom: y3}


				// this.changeBboxPos(bbox);

				const content = text[j];
				bboxTextArr.push({bbox, content, score});
			}

		}

		result.text = bboxTextArr;

	},


	locate(x1, y1, x2, y2, x3, y3) {
			var a, b;
			a = (y2 - y1) / (x2 - x1);
			b = y1 - a * x1;

			var xMiddle = (x1 + x2) / 2;
			var yMiddle = (y1 + y2) / 2;
			var c, lastX, lastY;
			if (a != 0) {
					c = yMiddle - (-1 / a) * xMiddle;
					lastX = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) - 2 * c * y1 + 2 * c * y3) / (2 * ((x1 - x3) - (1 / a) * (y1 - y3)));
					lastY = (-1 / a) * lastX + c;
			} else {
					lastX = c = xMiddle;
					lastY = (Math.pow(x1, 2) + Math.pow(y1, 2) - Math.pow(x3, 2) - Math.pow(y3, 2) + 2 * lastX * (x3 - x1)) / (2 * (y1 - y3));
			}
			console.log("定位点X坐标: " + lastX);
			console.log("定位点Y坐标: " + lastY);

			return {x: lastX, y: lastY};
	},

	photoEndCircleRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}



		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const points = oneTextData.points;

			const tempDisNum = Math.floor(points.length / 3);
			const point1_x = points[0];
			const point1_y = points[1];
			const point2_x = points[tempDisNum];
			const point2_y = points[tempDisNum + 1];
			const point3_x = points[tempDisNum*2];
			const point3_y = points[tempDisNum*2 + 1];

			let centerP = this.locate(point1_x, point1_y, point2_x, point2_y, point3_x, point3_y);


			console.log("~~centerP: ", centerP)

		
			for (let j=0; j<points.length; j+=2) {
				const x = points[j]//centerP.x
				const y = -points[j+1]//-centerP.y
				const w = 0.01;
				const h = 0.01;
	
				const rect = {
					x, y,
					width: w,
					height: h
				}
	
				console.log('oneTextData: ', oneTextData);
	
				const colorRect = this.getColorDot(rect.x, rect.y, w, h, "red");
				this.debugDrawLayer.addChild(colorRect, 1);


				this.setCirclePosInRectArr(colorRect);
				
	
			}
		


		}


		// this.showUserRightNew(answerData);
	},

	photoEndNewRect(data) {
		const textArr = data?.result?.text;
		if (!textArr) {
			return;
		}

		const answerData = {};

		for (let i=0; i<textArr.length; i++) {
			const oneTextData = textArr[i];
			const x = oneTextData.left//oneTextData.left + (oneTextData.right - oneTextData.left) / 2;
			const y = -oneTextData.bottom//-oneTextData.top - (oneTextData.bottom - oneTextData.top) / 2;
			const w = oneTextData.right - oneTextData.left;
			const h = oneTextData.bottom - oneTextData.top;

			const rect = {
				x, y,
				width: w,
				height: h
			}

			console.log('oneTextData: ', oneTextData);

			const content = oneTextData.content;
			const colorRect = this.getColorRect(rect, "red");
			colorRect.labelText = content;
			this.debugDrawLayer.addChild(colorRect, 1);

			const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
			label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
			label.color = cc.Color.BLACK;

			this.debugDrawLayer.addChild(label, 2);

			this.setOneAnswerDataNew(colorRect, answerData);

		}

		console.log('answerData:' , answerData);
		this.showUserRightNew(answerData);
	},

	showUserRightNew(answerData) {

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.animaNodeArr.length; i++) {

			const animaNode = this.animaNodeArr[i];

			const key = animaNode.data.rectNew // i.toString();

			console.log('~animaNode.data: ', animaNode.data)
			console.log('~key: ', key)


			if (answerData[key] && answerData[key].isFinish) {
				console.log('~showLetter')
				this.showLetter(animaNode);
			} else {

				animaNode.hitCount = 0;
			}
		}
	},

	photoEnd(data) {
		
		console.log(' this.photo end ', data);
		console.log('this.newRectArr ', this.newRectArr);
		if (this.newRectArr && this.newRectArr.length > 0) {
			this.photoEndNewRect(data);
			return;
		}


		if (this.circleRectArr) {
			this.photoEndCircleRect(data);
			return;
		}


		// this.changeBboxPos(data);

		const isRightArea = this.checkIsRightArea(data);
		if (!isRightArea) {
			console.log('没有检测到区域')
			return;
		}



		if (this.isCanDraw) {
			return;
		}
		this.isCanDraw = true;


		delayCall(0.01, () => {
			this.isCanDraw = false;
		})



		this.debugDrawLayer.removeAllChildren();

		// const benchmark1Text = this.benchmark1Data.labelText
		// const benchmark1TextArr = benchmark1Text.split(' ');
		// const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, data?.result?.text);

		// const benchmark2Text = this.benchmark2Data.labelText
		// const benchmark2TextArr = benchmark2Text.split(' ');
		// const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr,  data?.result?.text);




		const answerData = this.getAnswerData(data);

		this.showUserRight(answerData, data);

		return;


		const answerWrongData = this.getAnswerWrongData(data);
		let isShowWrong = false;
		if (this.oldAnswerWrongData) {
		
			for (let key in answerWrongData) {
				const wrongData = answerWrongData[key];
				const oldWrongData = this.oldAnswerWrongData[key];
				if (oldWrongData && oldWrongData.sentence == wrongData.sentence) {
					wrongData.count += oldWrongData.count;

					if (wrongData.count >= 3) {
						isShowWrong = true;
					}
				}
			}
		}

		if (isShowWrong) {
			this.showUserWrong(answerWrongData);
		}

		this.oldAnswerWrongData = answerWrongData;


		console.log('answerWrongData: ', JSON.stringify( answerWrongData) );
	},







	checkIsRightArea(data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}

		const benchmark1Text = this.benchmark1Data.labelText
		const benchmark1TextArr = benchmark1Text.split(' ');
		console.log('benchmark1TextArr: ', benchmark1TextArr);
		// const letter = this.data.letter || 'Aa';

		const benchmark1LabelData = this.getPhotoLabelData(benchmark1TextArr, text, false);
		if (!benchmark1LabelData) {
			console.log('!benchmark1LabelData')
			return false;
		}
		this.benchmark1LabelData = benchmark1LabelData;
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		

		if ( this.firstItemData ) {

			const firstText = this.firstItemData.labelText
			const firstTextArr = firstText.split(' ');

			const firstItemLabelData = this.getTopLeftLetter2(firstText, text, this.benchmark1LabelData);

			if (!firstItemLabelData) {
				return false;
			}
			this.firstItemLabelData = firstItemLabelData;

			console.log('firstItemLabelData: ', firstItemLabelData);
			return true

		} else if (this.benchmark2Data) {
		
			const benchmark2Text = this.benchmark2Data.labelText
			const benchmark2TextArr = benchmark2Text.split(' ');
			const benchmark2LabelData = this.getPhotoLabelData(benchmark2TextArr, text, false);
			if (!benchmark2LabelData) {
				return false;
			}
			this.benchmark2LabelData = benchmark2LabelData;
			return true;
		}



		return false;

	


		// const block = data?.block
		// if (!block) {
		// 	return false;
		// }

		// const topText = this.topItemData.labelText
		// const topTextArr = topText.split(' ');
		// console.log('topTextArr: ', topTextArr);
		// // const letter = this.data.letter || 'Aa';

		// const topLabelData = this.getPhotoLabelData(topTextArr, block);
		// if (!topLabelData) {
		// 	console.log('!topLabelData')
		// 	return false;
		// }
		// this.topLabelData = topLabelData;
		// console.log('topLabelData: ', topLabelData);

		

		// if (this.bottomItemData) {
			
		// 	const bottomText = this.bottomItemData.labelText
		// 	const bottomTextArr = bottomText.split(' ');
		// 	const bottomLabelData = this.getPhotoLabelData(bottomTextArr, block);
		// 	if (!bottomLabelData) {
		// 		return false;
		// 	}
		// 	this.bottomLabelData = bottomLabelData;
		// 	return true

		// } else if (this.firstItemData) {

		// 	const firstText = this.firstItemData.labelText
		// 	const firstTextArr = firstText.split(' ');
		// 	const topLeftLetter = this.getPhotoLabelData(firstTextArr, block);


		// 	// const topLeftLetter = this.getTopLeftLetter(this.firstItemData.labelText, block, topLabelData);
		// 	if (!topLeftLetter) {
		// 		return false;
		// 	}
		// 	this.topLeftLetter = topLeftLetter;

		// 	console.log('topLeftLetter: ', topLeftLetter);
		// 	return true;
		// }



		// return false;

	
	},

	changeBboxPos(data) {

		const text = data?.result?.text;
		if (!text) {
			return;
		}


		for (let i=0; i<text.length; i++) {

			let {left, top, right, bottom} = text[i];

			const q_left = this.ques_region[0];
			const q_top = this.ques_region[1];
			const q_right = this.ques_region[2];
			const q_bottom = this.ques_region[7];

			const rect = {x: q_left, y: q_top, width: q_right - q_left, height: q_bottom - q_top};

			text[i].left = q_left + left * rect.width;
			text[i].top = q_top + top * rect.height;
			text[i].right = q_left + right * rect.width;
			text[i].bottom = q_top + bottom * rect.height;

		}

		// console.log('bbox: ', bbox);
		// const x1 = bbox[0].x1;
		// const y1 = bbox[0].y1;
		// const x2 = bbox[1].x2;
		// const y2 = bbox[1].y2;
		// const x3 = bbox[2].x3;
		// const y3 = bbox[2].y3;
		// const x4 = bbox[3].x4;
		// const y4 = bbox[3].y4;

		// const left = this.ques_region[0];
		// const top = this.ques_region[1];
		// const right = this.ques_region[2];
		// const bottom = this.ques_region[7];

		// const rect = {x: left, y:top, width: right - left, height: bottom - top};

		// const y1_new = top + y1 * rect.height;
		// const y2_new = y1_new;
		// const y3_new = top + y3 * rect.height;
		// const y4_new = y3_new;

		// const x1_new = left + x1 * rect.width;
		// const x2_new = left + x2 * rect.width;
		// const x3_new = x2_new;
		// const x4_new = x1_new;

		// bbox[0].x1 = x1_new;
		// bbox[0].y1 = y1_new;
		// bbox[1].x2 = x2_new;
		// bbox[1].y2 = y2_new;
		// bbox[2].x3 = x3_new;
		// bbox[2].y3 = y3_new;
		// bbox[3].x4 = x4_new;
		// bbox[3].y4 = y4_new;

		// console.log('~~rect: ', rect);

	
	},



	getTopLeftLetter2(text, block, topLabelData) {

		const benchmark1Rect = this.benchmark1Data.rect;

		const rect = {
			x: topLabelData.left, 
			y: -topLabelData.bottom, 
			width: Math.abs( topLabelData.right - topLabelData.left ), 
			height: Math.abs( topLabelData.bottom - topLabelData.top ), 
		}                        
		const colorRect = this.getColorRect(rect, "green");
		this.debugDrawLayer.addChild(colorRect);
		


		const tempUnitW = benchmark1Rect.x + benchmark1Rect.width;
		const tempUnitH = benchmark1Rect.y + benchmark1Rect.height;
		const tempBaseX = benchmark1Rect.x + benchmark1Rect.width / 2;
		const tempBaseY = benchmark1Rect.y + benchmark1Rect.height / 2;


		const firstItemData = this.firstItemData;		
		const firstItemRect = this.firstItemData.rect;

	
		const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		const unitX = (firstItemX - tempBaseX) / tempUnitW;
		const unitY = (firstItemY - tempBaseY) / tempUnitH;
		const unitW2 = firstItemRect.width / tempUnitW;
		const unitH2 = firstItemRect.height / tempUnitH;



		console.log('tempUnitW: ', tempUnitW);
		console.log('tempUnitH: ', tempUnitH);
		console.log('tempBaseX: ', tempBaseX);
		console.log('tempBaseY: ', tempBaseY);

		console.log('firstItemY: ', firstItemY);
		console.log('tempBaseY: ', tempBaseY);
		console.log('tempUnitH: ', tempUnitH);

		firstItemData.unitX = unitX;
		firstItemData.unitY = unitY;
		firstItemData.unitW = unitW2;
		firstItemData.unitH = unitH2;



		const topLocationLeft = topLabelData.left;
		const topLocationTop = topLabelData.top;
		const topLocationRight = topLabelData.right;
		const topLocationBottom = topLabelData.bottom;

		const baseX = topLocationLeft + (topLocationRight - topLocationLeft) / 2;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight;
		const unitH = topLocationTop + (topLocationBottom - topLocationTop);
		

		const checkLetter = firstItemData;

		console.log('baseY: ', baseY);
		console.log('checkLetter.unitY: ', checkLetter.unitY);
		console.log('unitH: ', unitH);


		let x = baseX + checkLetter.unitX * unitW;
		const y = baseY + checkLetter.unitY * unitH;
		const w = checkLetter.unitW * unitW;
		const h = checkLetter.unitH * unitH;
		const r = Math.min(w, h) / 2;


		console.log(' baseX:  ', baseX);
		console.log(' checkLetter.unitX:  ', checkLetter.unitX);
		console.log(' unitW:  ', unitW);
		console.log(' x:  ', x);
		console.log(' y:  ', y);
		console.log(' r:  ', r);
		console.log(' checkLetter:  ', checkLetter);

		const dot = this.getColorDot(x, -y, r, r, 'blue');
		this.debugDrawLayer.addChild(dot, 5);

		dot.labelText = checkLetter.labelText;


		const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		let topLeftLetterData;


		const {dotRect, labelText} = dot
		


		for (let i=0; i<wordDataArr.length; i++) {

			// const tempWordArr = wordDataArr[i].word;
			const tempWordArr = this.getTempWordArr(wordDataArr[i],['']);



			for (let k=0; k<tempWordArr.length; k++) {
					
				const {location , content} = tempWordArr[k];

				const rect = {
					x: location.left, 
					y: -location.bottom, 
					width: Math.abs( location.right - location.left ), 
					height: Math.abs( location.bottom - location.top ), 
				}                        
				const colorRect = this.getColorRect(rect, "purple");
				colorRect.labelText = content;
				this.debugDrawLayer.addChild(colorRect);

				// console.log('colorRect: ', colorRect);

				const label = this.getLabel(content);
				label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
				label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
				label.color = cc.Color.GREEN;
				this.debugDrawLayer.addChild(label);




				///------

				const checkRect = colorRect.ccRect;
				const targetLabelText = colorRect.labelText;

				const {dotRect, labelText, key} = dot;

				if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && checkRect.intersects(dotRect)) {
					return tempWordArr[k];
				}

				///------
				

			}





			// const lineRect = this.getLineRect( wordDataArr[i] );
			// const isInLineRect = lineRect.intersects(dotRect)
			// if (!isInLineRect) {
			// 	continue;
			// }

			// for (let k=0; k<tempWordArr.length; k++) {
			// 	const {location , content} = tempWordArr[k];

			// 	const tempRect = {
			// 		x: location.left, 
			// 		y: -location.bottom, 
			// 		width: Math.abs( location.right - location.left ), 
			// 		height: Math.abs( location.bottom - location.top ), 
			// 	}
			// 	const colorRect = this.getColorRect(tempRect);
			// 	colorRect.labelText = content;
			// 	// this.debugDrawLayer.addChild(colorRect);

			// 	const label = this.getLabel(content);
			// 	label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
			// 	label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
			// 	label.color = cc.Color.GREEN;
			// 	// this.debugDrawLayer.addChild(label);
				


						
			// 	const rect = colorRect.ccRect;
			// 	const targetLabelText = colorRect.labelText;



			

			// 	// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
			// 	// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


			// 	const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

			// 	if (isInLineText) {
			// 	// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
			// 		topLeftLetterData = wordDataArr[i];
			// 		// answerData[i.toString()] = colorRect;
			// 		// return;
			// 	}

			// }
			
		}

			
		return null;


	},


	getTopLeftLetter(text, block, topLabelData) {

		// const topItemRect = this.topItemData.rect;

		// const tempUnitW = topItemRect.width;
		// const tempUnitH = topItemRect.height;
		// const tempBaseX = topItemRect.x;
		// const tempBaseY = topItemRect.y + topItemRect.height / 2;


		// const firstItemData = this.firstItemData;
		// console.log('firstItemData: ', firstItemData);
		
		// const firstItemRect = this.firstItemData.rect;


	
		// const firstItemX = firstItemRect.x + firstItemRect.width / 2;
		// const firstItemY = firstItemRect.y + firstItemRect.height / 2;

		// const unitX = (firstItemX - tempBaseX) / tempUnitW;
		// const unitY = (firstItemY - tempBaseY) / tempUnitH;
		// const unitW2 = firstItemRect.width / tempUnitW;
		// const unitH2 = firstItemRect.height / tempUnitH;


		// console.log('firstItemY: ', firstItemY);
		// console.log('tempBaseY: ', tempBaseY);
		// console.log('tempUnitH: ', tempUnitH);

		// firstItemData.unitX = unitX;
		// firstItemData.unitY = unitY;
		// firstItemData.unitW = unitW2;
		// firstItemData.unitH = unitH2;



		// // const topLabelData = this.topLabelData;

		// const firstTopWordLocation = topLabelData.word[0].location;
		// const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		// const topLocationLeft = firstTopWordLocation.left;
		// const topLocationTop = firstTopWordLocation.top;
		// const topLocationRight = lastTopWordLocation.right;
		// const topLocationBottom = lastTopWordLocation.bottom;

		// const baseX = topLocationLeft;
		// const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		// const unitW = topLocationRight - topLocationLeft;
		// const unitH = topLocationBottom - topLocationTop;
		

		// const checkLetter = firstItemData;

		// console.log('baseY: ', baseY);
		// console.log('checkLetter.unitY: ', checkLetter.unitY);
		// console.log('unitH: ', unitH);


		// let x = baseX + checkLetter.unitX * unitW;
		// const y = baseY + checkLetter.unitY * unitH;
		// const w = checkLetter.unitW * unitW;
		// const h = checkLetter.unitH * unitH;
		// const r = Math.min(w, h) / 2;

		// 	// const centerX = baseX + this.centerUnitW * unitW;
		// 	// x += (centerX - x) * 0.005  * (y * 0.05);

		// console.log(' x:  ', x);
		// console.log(' y:  ', y);
		// console.log(' r:  ', r);

		// const dot = this.getColorDot(x, -y, r, r, 'purple');
		// this.debugDrawLayer.addChild(dot, 5);

		// dot.labelText = checkLetter.labelText;


		// const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// let topLeftLetterData;


		// const {dotRect, labelText} = dot
		


		// for (let i=0; i<wordDataArr.length; i++) {

		// 	const tempWordArr = wordDataArr[i].word;

		// 	const lineRect = this.getLineRect( wordDataArr[i] );
		// 	const isInLineRect = lineRect.intersects(dotRect)
		// 	if (!isInLineRect) {
		// 		continue;
		// 	}

		// 	for (let k=0; k<tempWordArr.length; k++) {
		// 		const {location , content} = tempWordArr[k];

		// 		const tempRect = {
		// 			x: location.left, 
		// 			y: -location.bottom, 
		// 			width: Math.abs( location.right - location.left ), 
		// 			height: Math.abs( location.bottom - location.top ), 
		// 		}
		// 		const colorRect = this.getColorRect(tempRect);
		// 		colorRect.labelText = content;
		// 		// this.debugDrawLayer.addChild(colorRect);

		// 		const label = this.getLabel(content);
		// 		label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
		// 		label.y = colorRect.y - colorRect.height / 2 //* colorRect.scaleY;
		// 		label.color = cc.Color.GREEN;
		// 		// this.debugDrawLayer.addChild(label);
				


						
		// 		const rect = colorRect.ccRect;
		// 		const targetLabelText = colorRect.labelText;



			

		// 		// console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
		// 		// console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );


		// 		const isInLineText = this.checkWordIsInLine(wordDataArr[i], labelText);

		// 		if (isInLineText) {
		// 		// if (targetLabelText.toLowerCase().indexOf(labelText.toLowerCase()) != -1  && rect.intersects(dotRect)) {
		// 			topLeftLetterData = wordDataArr[i];
		// 			// answerData[i.toString()] = colorRect;
		// 			// return;
		// 		}

		// 	}
			
		// }

			
		// return topLeftLetterData;









		// // const topRect = this.topItemData.rect;

		// // const topCenterY = (topRect.y + topRect.height / 2);
		// // const bottomCenterY = (bottomRect.y + bottomRect.height / 2);
		
		// // const unitH = bottomCenterY - topCenterY;
		// // const unitW = topRect.width;
		// // const baseX = topRect.x;
		// // const baseY = topRect.y + topRect.height;


		

		// // const titleBottom = this.getTitleBottom();
		// // console.log("titleBottom: ", titleBottom);

		// // let topLeftLetter;
		// // const wordDataArr =  this.getPhotoWordArr(text, block, topLabelData);
		// // for (let i=0; i<wordDataArr.length; i++) {

		// // 	const tempWordArr = wordDataArr[i].word;
		// // 	for (let k=0; k<tempWordArr.length; k++) {
		// // 		const {location , content} = tempWordArr[k];


		// // 		// console.log('location: ~~ ', location);

		// // 		// if (location.top <= titleBottom) {
		// // 		// 	continue;
		// // 		// }

		// // 		wordDataArr[i].tmpLen = this.getToZeroLen(location)

					



		// // 		if (!topLeftLetter) {
		// // 			topLeftLetter = wordDataArr[i];
		// // 		} else {
		// // 			if (topLeftLetter.tmpLen > wordDataArr[i].tmpLen) {
		// // 				topLeftLetter = wordDataArr[i];
		// // 			}
		// // 		}
		// // 	}
			
		// // }

		// // return topLeftLetter;


	},

	getLineRect(line) {

		const tempWordArr = line.word;

		let sentenceRect;
		let left;
		let right;
		for (let k=0; k<tempWordArr.length; k++) {
			const {location , content} = tempWordArr[k];

			const tempRect = {
				x: location.left, 
				y: -location.bottom, 
				width: Math.abs( location.right - location.left ), 
				height: Math.abs( location.bottom - location.top ), 
			}
			const colorRect = this.getColorRect(tempRect);
			colorRect.labelText = content;
			// this.debugDrawLayer.addChild(colorRect);

					
			const rect = colorRect.ccRect;
			if (!sentenceRect) {
				sentenceRect = rect;
				left = rect.x;
				right = rect.x + rect.width;
			} else {
				if (rect.x + rect.width > right) {
					right = rect.x + rect.width;
				}
			}



		


		}

		if (sentenceRect) {
			sentenceRect.width = right - left;
		}

		return sentenceRect;



	},

	checkWordIsInLine(line, text) {

		console.log(" in checkWordIsInLine ");
		console.log(" line:  ", line);
		console.log(" word:  ", text);

		const textArr = text.trim().toLowerCase().split('');

		const word = line.word;
		let sentence = ''
		word.forEach(item => {
			sentence += item.content + ' ';
		});

		sentence.trim();
		sentence = sentence.toLowerCase();

		line.sentence = sentence;

		console.log(" sentence:  ", sentence);
		

		if (this.checkIsInsert(textArr, sentence)) {
			return true;
		}

		
		return false;

	},


	getTitleBottom() {
		let maxBottom = 0;
		const word = this.topLabelData.word;
		for (let i=0; i<word.length; i++) {
			if (word[i].location.bottom > maxBottom) {
				maxBottom = word[i].location.bottom;
			}
		}

		return maxBottom;
	},

	getToZeroLen(location) {
		const {top, left} = location;
		const len = Math.sqrt( Math.pow(left, 2) + Math.pow(top, 2) );
		return len;
	},



	getPhotoLabelData(textArr, block, isShow=true) {


		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}

			const sentence = line.content;


			if (isShow) {
				const label = this.getLabel(sentence, 150);
				label.x = line.left * this.debugBgImg.width;
				label.y = -(line.top + (line.bottom - line.top) / 2) * this.debugBgImg.height;
				label.parent = this.debugDrawLayer;
				label.zIndex = 200;
				// label.color = cc.Color.RED;
				const l = label.getComponent(cc.Label);
				label.anchorX = 0;
				console.log(' sentence~:  ', sentence);
			}




			if (this.checkIsInsert(textArr, sentence)) {
				return line;
			}

		}

		return false;

		// for(let j=0; j<block.length; j++) {

		// 	const line = block[j].line;
		// 	if (!line) {
		// 		continue;
		// 	}

		// 	for (let i=0; i<line.length; i++) {

		// 		const word = line[i].word;
		// 		let sentence = ''
		// 		word.forEach(item => {
		// 			sentence += item.content + ' ';
		// 		});
	
		// 		sentence.trim();
		// 		sentence = sentence.toLowerCase();
	
		// 		line[i].sentence = sentence;

		// 		if (this.checkIsInsert(textArr, sentence)) {
		// 			return line[i];
		// 		}
		// 	}
		// }

		// return false;
	},

	checkIsInsert(textArr, sentence) {
		// console.log('textArr: ', textArr);
		// console.log('sentence: ', sentence);

		sentence = sentence.toLowerCase();

		let index = -1;
		for (let i=0; i<textArr.length; i++) {
			index = sentence.indexOf(textArr[i].toLowerCase(), index);
			// console.log('index: ', index);
			if (index == -1) {
				return false;
			}
		}

		return true;
	},


	showUserRight(answerData, data) {

		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log('answerData: ', answerData);
		// console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}



		for (let i = 0; i < this.animaNodeArr.length; i++) {

			const animaNode = this.animaNodeArr[i];

			const key = animaNode.data.rectItem // i.toString();

			console.log('key: ', key)

			if (answerData[key] && answerData[key].isFinish) {
				this.showLetter(animaNode);
				// this.removeLine(answerData[key].line, block);
			} else {

				animaNode.hitCount = 0;
			}
		}


		// for (let i = 0; i < this.picNodeArr.length; i++) {

		// 	const picNode = this.picNodeArr[i];

		// 	const key = picNode.data.rectItem // i.toString();

		// 	console.log('key: ', key)

		// 	if (answerData[key] && answerData[key].isFinish) {
		// 		this.showLetter(picNode);
		// 		this.removeLine(answerData[key].line, block);
		// 	} else {

		// 		picNode.hitCount = 0;
		// 	}
		// }


	},

	removeLine(line, block) {

		console.log('block: ', JSON.stringify(block));
		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
	
			const index = lineArr.indexOf(line);
			if (index != -1) {
				lineArr.splice(index, 1);
				console.log(' ```splice lineArr.length: ' , lineArr.length);
			}
		}
	},

	showUserWrong(answerData) {

		console.log('answerData: ', answerData);
		console.log('this.picNodeArr: ', this.picNodeArr);

		if (Object.keys(answerData).length == 0) {
			return;
		}


		for (let i = 0; i < this.picNodeArr.length; i++) {

			const picNode = this.picNodeArr[i];

			const key = picNode.data.rectItem // i.toString();

			console.log('key: ', key)

			if (answerData[key] && answerData[key].count >= 3) {
				this.showLetter(picNode, false);
			}
		}


	},

	

	showLetter(picNode, isRight = true) {

		// let writeRect = this.writeNodeArr[Number(index)];

		console.log('in showLetter 1');


		picNode.hitCount++;
		if (picNode.hitCount < 1) {
			return;
		}


		console.log('in showLetter 2');


		if (picNode.isShowEnd) {
			return;
		}

		console.log('in showLetter 3');

		picNode.isShowEnd = true;
		picNode.isRight = isRight;


		// picNode.playRightAnim();
		this.playRightAnim(picNode);

		if (!this.isGameEnd) {
			this.checkGameEnd();
		}

		return;


		picNode.answerPic.active = true;



		if (!isRight) {
			console.log(' ~ !isRight');
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#ef7961')
			playAudio(this.wrongClip);

			if (!this.isGameEnd) {
				this.checkGameEnd();
			}
			return;
		} else {
			picNode.answerPic.color = cc.Color.fromHEX(new cc.Color(), '#548fd4')
			playAudio(this.rightClip);

		}

		this.showAnimaStar(picNode, ()=> {
			
			if (!this.isGameEnd) {
				this.checkGameEnd();
			}

		});

	
	},

	showAnimaStar(node, cb) {

		const resDragonBone = cc.find("Canvas/res/anim/right")
		const dNode = cc.instantiate(resDragonBone)
		node.addChild(dNode, 20);

		const dragonDisplay = dNode.getComponent(dragonBones.ArmatureDisplay);

		dragonDisplay.playAnimation('newAnimation', 1);

		dragonDisplay.on(dragonBones.EventObject.COMPLETE, ()=> {
			console.log('play end');
			cb && cb();
		})
		

	},


	getAnswerData(data) {
		
		const text = data?.result?.text
		if (!text) {
			return false;
		}


		console.log(' in getAnswerData: ', text);


		const benchmark1LabelData = this.benchmark1LabelData;
		let benchmark2LabelData ;

		const centerItemArr = this.centerItemArr;

		const benchmark1Left = benchmark1LabelData.left;
		const benchmark1Top = benchmark1LabelData.top;
		const benchmark1Right = benchmark1LabelData.right;
		const benchmark1Bottom = benchmark1LabelData.bottom;

		let baseX;
		let baseY;
		let unitW;
		let unitH;

		if (this.benchmark2LabelData) {
			benchmark2LabelData = this.benchmark2LabelData;


			const benchmark2Left = benchmark2LabelData.left;
			const benchmark2Top = benchmark2LabelData.top;
			const benchmark2Right = benchmark2LabelData.right;
			const benchmark2Bottom = benchmark2LabelData.bottom;


			const bottomLocation = benchmark2LabelData;

			baseX = benchmark1Left;
			baseY =	benchmark1Top + (benchmark1Bottom - benchmark1Top) / 2;
			unitW = benchmark2Right - benchmark1Left;
			unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;


			const benchmark2Rect = {
				x: benchmark2Left, 
				y: -benchmark2Bottom,
				width: Math.abs( benchmark2Left - benchmark2Right ), 
				height: Math.abs( benchmark2Top - benchmark2Bottom ), 
			}
			
			const colorbenchmark2Rect = this.getColorRect(benchmark2Rect, 'green');
			this.debugDrawLayer.addChild(colorbenchmark2Rect);
		} 

	



		if (this.firstItemLabelData) {
			const {location} = this.firstItemLabelData;
			const firstItemLeft = location.left;
			const firstItemRight = location.right;
			const firstItemTop = location.top;
			const firstItemBottom = location.bottom;

			console.log(' location: ', location);
			console.log(' firstItemLeft: ', firstItemLeft);
			console.log(' firstItemRight: ', firstItemRight);
			console.log(' firstItemTop: ', firstItemTop);
			console.log(' firstItemBottom: ', firstItemBottom);

			baseX = firstItemLeft + (firstItemRight - firstItemLeft) / 2;
			baseY =	firstItemTop + (firstItemBottom - firstItemTop) / 2;
			unitW = benchmark1Left + (benchmark1Right -  benchmark1Left) - ( firstItemLeft + (firstItemRight - firstItemLeft) / 2 );
			unitH = ( firstItemTop + (firstItemBottom - firstItemTop) / 2 ) - (benchmark1Top + (benchmark1Bottom -  benchmark1Top) / 2);
		}


		console.log(' baseX ~~~ ', baseX);
		console.log(' baseY ~~~ ', baseY);
		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = 1 //this.data.scaleOffY || 0.055;
		let postionRate = 1 //this.data.positionOffY || 0.4;

		// if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
		// 	postionRate *= 1.7;
    // }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			// const centerX = baseX + this.centerUnitW * unitW;

			// const tempR = scaleRate * (checkLetter.unitY * unitH);
			// const newR = r - tempR; 

			// let newW = w - tempR; 
			// let newH = h - tempR;


			// const rate = newR / r;

			// const tempY = ( y - (baseY) ) * postionRate;
			// y = y - tempY * (1 - rate);


			// const tempX = (centerX - x) * postionRate;
			// x = x + tempX * (1-rate);


			// const newScale = 1.4;
			// const edgeOff = (newScale - 1) / 2;
			// x -= edgeOff * newW;
			// y += edgeOff * newH;
			// newW *= newScale;
			// newH *= newScale;

			// const dot = this.getColorDot(x, -y, newW, newH);

			const dot = this.getColorDot(x, -y, w / 2, h / 2);



			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}



		// console.log('dotArr: ', dotArr);
		console.log('benchmark1LabelData: ', benchmark1LabelData);

		const answerData = {};

		for (let j=0; j<this.centerItemArr.length; j++) {
			const checkLetter = this.centerItemArr[j];

			const wordDataArr = this.getPhotoWordArr(checkLetter.labelText, text, benchmark1LabelData);

			console.log('~~~wordDataArr: ', wordDataArr);


			for (let i=0; i<wordDataArr.length; i++) {

				const tempWordArr = this.getTempWordArr(wordDataArr[i],['']); // wordDataArr[i].word;

				for (let k=0; k<tempWordArr.length; k++) {
					
					const {location , content} = tempWordArr[k];

					const rect = {
						x: location.left, 
						y: -location.bottom, 
						width: Math.abs( location.right - location.left ), 
						height: Math.abs( location.bottom - location.top ), 
					}                        
					const colorRect = this.getColorRect(rect, "purple");
					colorRect.labelText = content;
					this.debugDrawLayer.addChild(colorRect);

					// console.log('colorRect: ', colorRect);

					const label = this.getLabel(content, colorRect.scaleX *  colorRect.width);
					label.x = colorRect.x + colorRect.width / 2 * colorRect.scaleX;
					label.y = colorRect.y + colorRect.height / 2 * colorRect.scaleY;
					label.color = cc.Color.BLACK;

					this.debugDrawLayer.addChild(label);
					
	
					this.setOneAnswerData(colorRect, dotArr, answerData, wordDataArr[i]);
	
				}
				
			}

		
		}



		const benchmark1Rect = {
			x: benchmark1Left, 
			y: -benchmark1Bottom,
			width: Math.abs( benchmark1Left - benchmark1Right ), 
			height: Math.abs( benchmark1Top - benchmark1Bottom ), 
		}

		console.log('benchmark1Rect: ', benchmark1Rect);
		
		const colorbenchmark1Rect = this.getColorRect(benchmark1Rect, 'green');
		this.debugDrawLayer.addChild(colorbenchmark1Rect);





		// const rectTop = {
		// 	x: topLocationLeft, 
		// 	y: -topLocationBottom,
		// 	width: Math.abs( topLocationLeft - topLocationRight ), 
		// 	height: Math.abs( topLocationTop - topLocationBottom ), 
		// }
		
		// const colorRectTop = this.getColorRect(rectTop, 'green');
		// this.debugDrawLayer.addChild(colorRectTop);



		// const rectBottom = {
		// 	x: bottomLocation.left, 
		// 	y: -bottomLocation.bottom,
		// 	width: Math.abs( bottomLocation.left - bottomLocation.right ), 
		// 	height: Math.abs( bottomLocation.top - bottomLocation.bottom ), 
		// }
		
		// const colorRectBottom = this.getColorRect(rectBottom, 'green');
		// this.debugDrawLayer.addChild(colorRectBottom);






		return answerData;


	},

	getTempWordArr(line, splitText) {

		const lineBox = {left: line.left, top: line.top, right: line.right, bottom: line.bottom};
		const baseX = lineBox.left;

		let textIndex = 0;
		const oneDisW = (lineBox.right - lineBox.left) / line.content.length;

		const arr = line.content.split(splitText);
		const wordArr = [];
		for (let i=0; i<arr.length; i++) {
			const content = arr[i];
			const location = {}
			location.left = baseX + textIndex * oneDisW;
			location.right = location.left + oneDisW * content.length;
			location.top = lineBox.top;
			location.bottom = lineBox.bottom;
			
			wordArr.push({content, location});

			textIndex += content.length;
		}

		return wordArr;
	},




	getAnswerWrongData(data) {
		
		const block = data?.block
		if (!block) {
			return false;
		}


		console.log(' in getAnswerWrongData: ', block);

		const endKeyObj = {};
		for (let j = 0; j < this.picNodeArr.length; j++) {

			const picNode = this.picNodeArr[j];

			const key = picNode.data.rectItem // i.toString();

			if (picNode.isShowEnd) {
				endKeyObj[key] = true;
			}
		}


		const topLabelData = this.topLabelData;
		let bottomLabelData ;
		if (this.bottomLabelData) {
			bottomLabelData = this.bottomLabelData;
		} else {
			bottomLabelData = this.topLeftLetter;
		}
		// const bottomLabelData = this.bottomLabelData;
		const centerItemArr = this.centerItemArr;

		// console.log('topLabelData: ', topLabelData);

		const firstTopWordLocation = topLabelData.word[0].location;
		const lastTopWordLocation = topLabelData.word[topLabelData.word.length - 1].location
		const topLocationLeft = firstTopWordLocation.left;
		const topLocationTop = firstTopWordLocation.top;
		const topLocationRight = lastTopWordLocation.right;
		const topLocationBottom = lastTopWordLocation.bottom;


		const bottomLocation = bottomLabelData.word[0].location;

		const baseX = topLocationLeft;
		const baseY =	topLocationTop + (topLocationBottom - topLocationTop) / 2;
		const unitW = topLocationRight - topLocationLeft;
		const unitH = bottomLocation.top + (bottomLocation.bottom - bottomLocation.top) / 2 - baseY;

		console.log(' unitW ~~~ ', unitW);
		console.log(' unitH ~~~ ', unitH);


		const scaleRate = this.data.scaleOffY || 0.055;
		let postionRate = this.data.positionOffY || 0.4;

		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			postionRate *= 1.7;
    }


		const dotArr = [];
		for (let i=0; i<this.centerItemArr.length; i++) {
			const checkLetter = this.centerItemArr[i];

			const key = centerItemArr[i].index + 1;
			if (endKeyObj[key]) {
				continue;
			}

			let x = baseX + checkLetter.unitX * unitW;
			const y = baseY + checkLetter.unitY * unitH;
			const w = checkLetter.unitW * unitW;
			const h = checkLetter.unitH * unitH;
			const r = Math.min(w, h)

			// console.log('w: ', w);
			// console.log('h: ', h);
			// console.log('y: ', y);

			const centerX = baseX + this.centerUnitW * unitW;
	
			
		
			// y -= ( y - (baseY + unitH) ) * 0.35;



			const tempR = scaleRate * (checkLetter.unitY * unitH);
			const newR = r - tempR; 

			let newW = w - tempR; 
			let newH = h - tempR;


			const rate = newR / r;

			const tempY = ( y - (baseY) ) * postionRate;
			y = y - tempY * (1 - rate);


			const tempX = (centerX - x) * postionRate;
			x = x + tempX * (1-rate);




			const newScale = 1.4;
			const edgeOff = (newScale - 1) / 2;
			x -= edgeOff * newW;
			y += edgeOff * newH;
			newW *= newScale;
			newH *= newScale;

			const dot = this.getColorDot(x, -y, newW, newH);
			// const dot = this.getColorDot(x, -y, newR, newR);

			this.debugDrawLayer.addChild(dot, 5);

			dot.key = centerItemArr[i].index + 1;
			dot.centerPos = cc.v2(dot.x+ dot.width / 2, dot.y + dot.height / 2);

			dot.labelText = checkLetter.labelText;
			dotArr.push(dot);


		}


		console.log('topLabelData: ', topLabelData);

		const answerData = {};


		for (let i=0; i<block.length; i++) {
			const lineArr = block[i].line;
			if (!lineArr) {
				continue;
			}

			for (let m=0; m<lineArr.length; m++) {
				const line = lineArr[m];
				
				
				console.log('line: ', JSON.stringify(line));
				const lineRect = this.getLineRect( line );
				console.log('lineRect: ~  ', JSON.stringify(lineRect));
				const lineCenterPos = cc.v2(lineRect.x + lineRect.width / 2, lineRect.y + lineRect.height / 2);

	
				const tempDotArr = [];
				for (let j=0; j<dotArr.length; j++) {
					const isInLineRect = lineRect.intersects(dotArr[j].dotRect)
					if (isInLineRect) {
						tempDotArr.push(dotArr[j]);
					}
				}
				if (tempDotArr.length > 0) {
					const colorRect = this.getColorRect(lineRect, 'purple');
					this.debugDrawLayer.addChild(colorRect);

					console.log('tempDotArr.length > 0')
					let minDistance;
					let curDot;
					for (let j=0; j<tempDotArr.length; j++) {
						const curDistance = cc.Vec2.distance(lineCenterPos, tempDotArr[j].centerPos);
						if (minDistance == null || minDistance > curDistance) {
							minDistance = curDistance;
							curDot = tempDotArr[j];
						}
					}
	
					const tempWordArr = line.word;
					let sentence = ''
					tempWordArr.forEach(item => {
						sentence += item.content.trim();
					});
	
					console.log('sentence: ', sentence);
					console.log('curDot.labelText: ', curDot.labelText);
					if (sentence.length >= curDot.labelText.length) {
						if (!answerData[curDot.key]) {
							answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
						} else {                                        
							const oldData = answerData[curDot.key];
							if (oldData.minDistance > minDistance) {
								answerData[curDot.key] = {sentence, lineCenterPos, minDistance, count: 1}
							}
						}
					}
				} else {

					const colorRect = this.getColorRect(lineRect, 'red');
					this.debugDrawLayer.addChild(colorRect);
				}
			}

	
		}


		return answerData;


	},


	setCirclePosInRectArr(colorRect) {


		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);

		const circleRectCheckArr = this.circleRectCheckArr;

		for (let i=0; i<circleRectCheckArr.length; i++) {

			const checkRect = circleRectCheckArr[i].ccRect;
			const key = circleRectCheckArr[i].data.index + 1;

			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (checkRect.contains(dotV2)) {
				if (!colorRect.inRectArr) {
					colorRect.inRectArr = []
				}
				colorRect.inRectArr.push(key);
			}

		}
	},



	setOneAnswerDataNew(colorRect, answerData) {
		const rect = colorRect.ccRect;
		const dotV2 = new cc.Vec2(rect.x + rect.width/2, rect.y + rect.height / 2);


		const targetLabelText = colorRect.labelText;

		const newRectCheckArr = this.newRectCheckArr;

		for (let i=0; i<newRectCheckArr.length; i++) {

			const labelText = newRectCheckArr[i].data.labelText;
			const checkRect = newRectCheckArr[i].ccRect;
			const key = newRectCheckArr[i].data.index + 1;


			console.log("labelText: ", labelText);
			console.log("key: ", key);

			// if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
			if (labelText == targetLabelText && checkRect.contains(dotV2)) {
				const len = targetLabelText.trim().length;

				console.log('len: ', len);

				answerData[key] = {isFinish: true};

			}

		}
	},

	setOneAnswerData(colorRect, dotArr, answerData, line) {

		console.log(' in setOneAnswerData')
		console.log('colorRect: ', colorRect)
		console.log('dotArr: ', dotArr)
		console.log('answerData: ', answerData)

		
		const rect = colorRect.ccRect;
		const targetLabelText = colorRect.labelText;

		for (let i=0; i<dotArr.length; i++) {

			const {dotRect, labelText, key} = dotArr[i];

				console.log('targetLabelText.toLowerCase() : ', targetLabelText.toLowerCase() );
				console.log('labelText.toLowerCase()  : ', labelText.toLowerCase()  );
				console.log('rect.intersects(dotRect) : ', rect.intersects(dotRect) );

			if (labelText.toLowerCase().indexOf(targetLabelText.toLowerCase()) != -1 && rect.intersects(dotRect)) {
				const len = targetLabelText.trim().length;

				console.log('len: ', len);

				if (!answerData[key]) {
					answerData[key] = {colorRect, count: len};
				} else {
					answerData[key].count += len;

					// console.log('len: ', len);
					// console.log('	answerData[key].count: ', 	answerData[key].count);

				}

				if ( labelText.length <= 1) {
					answerData[key].isFinish = true;
					answerData[key].line = line;

				} else {
					if (answerData[key].count >= labelText.length) {
						answerData[key].isFinish = true;
						answerData[key].line = line;
					}
				}
				

			
				// return;
			}

		}

	},

	getColorRect(rect, color=null) {

		if (!color) {
			color = 'red'
		}


		rect.x *= this.debugBgImg.width;
		rect.y *= this.debugBgImg.height;
		rect.width *= this.debugBgImg.width;
		rect.height *= this.debugBgImg.height;

		const node = getSprNode(color);
		node.anchorX = 0;
		node.anchorY = 0;
		node.x = rect.x;
		node.y = rect.y;
		node.scaleX = rect.width / node.width;
		node.scaleY = rect.height / node.height;

		node.ccRect = new cc.Rect(rect.x, rect.y, rect.width, rect.height);



		return node;
	},



	getColorDot(x, y, w=100, h=100, color='red') {
		const node = new cc.Node();

		if (!h) {
			h = w;
		}

		x *= this.debugBgImg.width;
		y *= this.debugBgImg.height;
		w *= this.debugBgImg.width;
		h *= this.debugBgImg.height;

		if (this.debugLayer.parent && this.debugLayer.active) {

			const rect = {
				x:- w/2,
				y: - h/ 2, 
				width:w, 
				height:h
			}
			// const colorDot = this.getColorRect(rect,'blue');
			// colorDot.fillColor = cc.Color.BLUE;
			// colorDot.fillRect( - r/2, - r/ 2, r, r);

			const colorDot = getSprNode(color);

			
			// colorDot.anchorX = 0;
			// colorDot.anchorY = 0;
			// colorDot.x = rect.x;
			// colorDot.y = rect.y;
			colorDot.scaleX = rect.width / colorDot.width;
			colorDot.scaleY = rect.height / colorDot.height;
			node.addChild(colorDot);



			// const rect1 = new cc.Rect(node.x -r/2, node.y -r/2, r, r);
			// const colorDot = this.getColorRect(rect1, 'green');

			// colorDot.dotRect = rect1;
			// return colorDot;
		}

		node.x = x;
		node.y = y;


		// node.opacity = 0.5;

		const rect = new cc.Rect(node.x -w/2, node.y -h/2, w, h);
		node.dotRect = rect;
		return node;
	},

	



	checkHasAnswer(data, text) {

		text = text.toLowerCase();
		text = text.replace(/(^\s+)|(\s+$)/g,"");



		// -----
		let sentence = data.allText.replace('/\n/g', "");

		sentence = sentence.trim();
		sentence = sentence.toLowerCase();
		 


		if (sentence.indexOf(text) != -1) {

			// this.setTestLabel(line[i])

			return true;
		}
		// -----



		const block = data.block;
		for (let j = 0; j < block.length; j++) {

			const line = block[j].line;
			if (!line) {
				continue;
			}


			for (let i = 0; i < line.length; i++) {

				const word = line[i].word;
				const location = line[i].word[0].location;
		
				// console.log(' center line: ', line[i]);


				let sentence = ''
				word.forEach(item => {
					sentence += item.content.trim();
				});

				sentence = sentence.trim();
				sentence = sentence.toLowerCase();

				line[i].sentence = sentence;
				console.log('sentence: ' + sentence + ', text: ' + text);


				if (sentence.indexOf(text) != -1) {


					if (sentence) {
						this.setTestLabel(line[i])
					}

					// line[i].tmpLen = this.getToZeroLen(location)
					// if (!topLeftLetter) {
					// 	topLeftLetter = line[i];
					// } else {
					// 	if (topLeftLetter.tmpLen > line[i].tmpLen) {
					// 		topLeftLetter = line[i];
					// 	}
					// }

					return true;
				}
			}
		}

	},

	


	setTestLabel(labelData) {

		if (!this.debugLayer.parent || !this.debugLayer.active) {
			return;
		}
		// console.log('labelData: ', labelData)
		const location = labelData.word[0].location;
		const label = this.getLabel(labelData.sentence);
		label.anchorX = 0;
		// label.anchorY = 1;
		label.x = location.left;
		label.y = -location.top
		label.zIndex = 50;


		const rect = {};
		rect.width = location.right - location.left;
		rect.height = location.bottom - location.top;
		rect.x = location.left;
		rect.y = -location.top;
		// const colorRect = this.getColorRect(rect, cc.Color.YELLOW);
		// this.debugLayer.addChild(colorRect);

		this.debugLayer.addChild(label);
	},

	getLabel(text, fontSize = 20) {
		const labelNode = new cc.Node();
		const label = labelNode.addComponent(cc.Label);
		label.string = text;
		labelNode.color = cc.Color.BLACK;
		label.fontSize = fontSize;
		label.lineHeight = fontSize;
		return labelNode;
	},



	debugLayer: null,
	initDebugLayer() {


		console.log(' in initDebugLayer');
		const layer = new cc.Node();

		if (this.data.isDebug) {
			layer.parent = cc.find('Canvas');
		}


		layer.width = this.canvas.width / 2;
		layer.height = this.canvas.height / 2;

		layer.zIndex = 100;
		layer.anchorX = 0;
		layer.anchorY = 1;




		if (!this.data.bgItem2) {
			return;
		}


		cc.loader.load({url: this.data.bgItem2.url}, (err, img) => {

			this.debugBgImg = img;
			this.checkBg = img;
			layer.width = img.width;
			layer.height = img.height;

			layer.data = this.data.bgItem2;

			const sprNode = layer;
	
			var sf = new cc.SpriteFrame(img);

			const spr = sprNode.addComponent(cc.Sprite);
			spr.spriteFrame = sf			

			const sx = this.canvas.width / 2 / layer.width;
			const sy = (this.canvas.height) / 2 / layer.height;
			const s = Math.min(sx, sy);
			layer.scale = s;

			this.addNewRect();
			this.addCircleItem();

			this.startTesting();
	
		});

		layer.x = -this.canvas.width / 2 + 10;
		layer.y = this.canvas.height / 2 - this.canvas.height / 3;
		layer.opacity = 150;

		// layer.scale = 2;
		this.debugLayer = layer;

		// const bgRectNode = new cc.Node();
		// const ctx = bgRectNode.addComponent(cc.Graphics);
		// ctx.fillRect(0, -layer.height, layer.width, layer.height);
		// ctx.fillColor = cc.Color.YELLOW.setA(100);
		// ctx.fill();
		// layer.addChild(bgRectNode);


		const drawLayer = new cc.Node();
    this.debugLayer.addChild(drawLayer, 2);

    this.debugDrawLayer = drawLayer;



	},

	addCircleItem() {

		if (!this.circleRectArr) {
			return;
		}

		this.circleRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.circleRectArr.length; i++) {
			const oneData = this.circleRectArr[i];
			this.setCircleRectDot(oneData, bg);
			console.log('oneData: ', oneData);
		}
	},


	setCircleRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'blue');
		colorRect.opacity = 180;
		colorRect.data = data;
		bg.addChild(colorRect, 20);

		this.circleRectCheckArr.push(colorRect);                                                                                                                                                                                        


		// if (this.data.bgItem.isShowDebugLine || true) {
		// 	ctx.rect(0, 0, rectNode.width, rectNode.height);
		// }
		// ctx.stroke();
		// ctx.fill();

	},

	addNewRect() {
		
		if (!this.newRectArr) {
			return;
		}

		this.newRectCheckArr = [];
		const bg = this.debugLayer;
		for (let i=0; i<this.newRectArr.length; i++) {
			const oneData = this.newRectArr[i];
			this.setNewRectDot(oneData, bg);
			console.log('oneData: ', oneData);
		}

	},


	setNewRectDot(data, bg) {
		const bgData = bg.data;
		const rate = (bg.scale * bg.width) / bgData.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		bg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / bg.scaleY;

		console.log('scale: ', scale);

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = data.rect.x * scale;
		rectNode.y =  - data.rect.y * scale - data.rect.height * scale;


		rectNode.anchorX = rectNode.anchorY = 0;


		rectNode.x /= bg.width;
		rectNode.y /= bg.height;
		rectNode.width /= bg.width;
		rectNode.height /= bg.height;
		const colorRect = this.getColorRect(rectNode, 'green');
		colorRect.opacity = 180;
		colorRect.data = data;
		bg.addChild(colorRect, 20);

		this.newRectCheckArr.push(colorRect);                                                                                                                                                                                        


		// if (this.data.bgItem.isShowDebugLine || true) {
		// 	ctx.rect(0, 0, rectNode.width, rectNode.height);
		// }
		// ctx.stroke();
		// ctx.fill();

	},
	 


	getPhotoWordArr(text, block, benchmark1Data) {


		const wordArr = [];
		// const maxLen = 10;

		text = text.trim();

		const topY = -benchmark1Data.top;

		for(let j=0; j<block.length; j++) {

			const line = block[j];
			if (!line) {
				continue;
			}


			const sentence = line.content;
			if (sentence.indexOf(text) != -1 ) {
				wordArr.push( line );
			}

			// for (let i=0; i<line.length; i++) {


			// 	const location = line[i].word[0].location;

			// 	const curTop = -location.top;
			// 	if (curTop >= topY ) {
			// 		continue;
			// 	}


			// 	let word = line[i].word;
			// 	let sentence = ''

			// 	// if (word.length > maxLen) {
			// 	// 	console.log('continue ', word.length);
			// 	// 	continue;
			// 	// }

			// 	line[i].word = word = this.checkCutWordData(word);
			// 	// console.log('word1~ ', word);


			// 	word.forEach(item => {
			// 		sentence += item.content + '';
			// 	});

			// 	sentence = sentence.trim().toLowerCase();

			// 	text = text.toLowerCase();

			// 	line[i].sentence = sentence;
			// 	console.log('sentence: ', sentence);
			// 	console.log('text: ', text);

			// 	console.log('index: ', sentence.indexOf(text));
			// 	if (sentence.indexOf(text) != -1 ) {
			// 		wordArr.push( line[i] );
			// 	}
			// }
		}

		return wordArr;
	},


	checkCutWordData(wordArr) {


		// console.log('wordArr: ', wordArr);

		let newWordArr = [];
		for(let i=0; i<wordArr.length; i++) {

			let wordObj = wordArr[i];

			wordObj.content = wordObj.content.trim();

			if (wordObj.content.length > 1) {

				const tmpArr = [];
				const w = wordObj.location.right - wordObj.location.left
				const subW = w / wordObj.content.length;
				for (let j=0; j<wordObj.content.length; j++) {

					const subWordObj = {};
					subWordObj.content = wordObj.content[j];
					subWordObj.location = {
						top: wordObj.location.top,
						bottom: wordObj.location.bottom,
						left: wordObj.location.left + subW * j,
						right: wordObj.location.left + subW * (j + 1)
					}

					tmpArr.push(subWordObj);
				}
				newWordArr = newWordArr.concat(tmpArr)


			} else {
				newWordArr.push(wordObj)
			}

		}

		// console.log('newWordArr: ', newWordArr);
		return newWordArr;
	},

	getPhotoData(cb) {
	
		// const tmpData1 = {"result":{"text":[{"type":1,"points":[0.23666666,0.45360824,0.24,0.45360824,0.22,0.45618558,0.22333333,0.45618558,0.22666667,0.45618558,0.23,0.45618558,0.23333333,0.45618558,0.24333334,0.45618558,0.24666667,0.45618558,0.25,0.45618558,0.25333333,0.45618558,0.25666666,0.45618558,0.26,0.45618558,0.20666666,0.45876288,0.21,0.45876288,0.21333334,0.45876288,0.21666667,0.45876288,0.26333332,0.45876288,0.26666668,0.45876288,0.27,0.45876288,0.27333334,0.45876288,0.19666667,0.46134022,0.2,0.46134022,0.20333333,0.46134022,0.27666667,0.46134022,0.28,0.46134022,0.28333333,0.46134022,0.17666666,0.46391752,0.18,0.46391752,0.18333334,0.46391752,0.18666667,0.46391752,0.19,0.46391752,0.19333333,0.46391752,0.28666666,0.46391752,0.29,0.46391752,0.29333332,0.46391752,0.29666665,0.46391752,0.3,0.46391752,0.30333334,0.46391752,0.30666667,0.46391752,0.31,0.46391752,0.31333333,0.46391752,0.31666666,0.46391752,0.32,0.46391752,0.32333332,0.46391752,0.32666665,0.46391752,0.17,0.46649486,0.17333333,0.46649486,0.28666666,0.46649486,0.33,0.46649486,0.33333334,0.46649486,0.33666667,0.46649486,0.34,0.46649486,0.34333333,0.46649486,0.34666666,0.46649486,0.35,0.46649486,0.35333332,0.46649486,0.35666665,0.46649486,0.36,0.46649486,0.36333334,0.46649486,0.36666667,0.46649486,0.37,0.46649486,0.16666667,0.46907216,0.28666666,0.46907216,0.16333333,0.4716495,0.28666666,0.4716495,0.16333333,0.4742268,0.28666666,0.4742268,0.16333333,0.47680414,0.28666666,0.47680414,0.16,0.47938144,0.28666666,0.47938144,0.16,0.48195878,0.28666666,0.48195878,0.16,0.48453608,0.28666666,0.48453608,0.16,0.48711342,0.29,0.48711342,0.15666667,0.48969072,0.29,0.48969072,0.15333334,0.49226806,0.29,0.49226806,0.15333334,0.49484536,0.29,0.49484536,0.15333334,0.4974227,0.29,0.4974227,0.15,0.5,0.29,0.5,0.15,0.5025773,0.29,0.5025773,0.15,0.5051546,0.29,0.5051546,0.15,0.507732,0.28666666,0.507732,0.15,0.5103093,0.28666666,0.5103093,0.15,0.5128866,0.28666666,0.5128866,0.15,0.5154639,0.28666666,0.5154639,0.15,0.51804125,0.28666666,0.51804125,0.15,0.52061856,0.28666666,0.52061856,0.15,0.52319586,0.28333333,0.52319586,0.15333334,0.52577317,0.28333333,0.52577317,0.15333334,0.52835053,0.28,0.52835053,0.15333334,0.53092784,0.27666667,0.53092784,0.15333334,0.53350514,0.27333334,0.53350514,0.15333334,0.53608245,0.26666668,0.53608245,0.27,0.53608245,0.15333334,0.5386598,0.25666666,0.5386598,0.26,0.5386598,0.26333332,0.5386598,0.15666667,0.5412371,0.25,0.5412371,0.25333333,0.5412371,0.15666667,0.5438144,0.24333334,0.5438144,0.24666667,0.5438144,0.15666667,0.5463917,0.23333333,0.5463917,0.23666666,0.5463917,0.24,0.5463917,0.16,0.5489691,0.23,0.5489691,0.16333333,0.5515464,0.22333333,0.5515464,0.22666667,0.5515464,0.16666667,0.5541237,0.17,0.5541237,0.17333333,0.5541237,0.17666666,0.5541237,0.18,0.5541237,0.18333334,0.5541237,0.18666667,0.5541237,0.19,0.5541237,0.19333333,0.5541237,0.19666667,0.5541237,0.2,0.5541237,0.20333333,0.5541237,0.20666666,0.5541237,0.21,0.5541237,0.21333334,0.5541237,0.21666667,0.5541237,0.22,0.5541237]}]}}
		const tmpData1 = {"result":{"text":[{"left":0.22833333909511566,"right":0.3166666626930237,"top":0.5590206384658813,"bottom":0.628608226776123,"score":0.8552894592285156,"content":"Aa"},{"left":0.6816666126251221,"right":0.7666666507720947,"top":0.42257729172706604,"bottom":0.49860823154449463,"score":0.8148108720779419,"content":"Aa"},{"left":0.6983333230018616,"right":0.7666666507720947,"top":0.5564433336257935,"bottom":0.628608226776123,"score":0.7532452344894409,"content":"Aa"}]}}
		// const tmpData1 = {"result":{"text":[{"left":0.09814612567424774,"right":0.4471101462841034,"top":0.006644518114626408,"bottom":0.15614618360996246,"score":1,"content":"CTrace,write,and say."},{"left":0.10796073824167252,"right":0.5049073100090027,"top":0.1827242523431778,"bottom":0.4518272280693054,"score":0.9702169299125671,"content":"AAAA"},{"left":0.5834242105484009,"right":0.659760057926178,"top":0.17607973515987396,"bottom":0.4485049843788147,"score":0.9523985981941223,"content":"A"},{"left":0.6706652045249939,"right":0.8298800587654114,"top":0.15614618360996246,"bottom":0.43853819370269775,"score":0.9089533090591431,"content":"A"},{"left":0.5866957306861877,"right":0.6521264910697937,"top":0.634551465511322,"bottom":0.8504983186721802,"score":0.8326067328453064,"content":"a"},{"left":0.7699018716812134,"right":0.8276990056037903,"top":0.6411960124969482,"bottom":0.8039867281913757,"score":0.8035371899604797,"content":"a"}]}}
		cb(tmpData1);
		return;
	// const tmpData = {"allText":"Look and Trace\nblackboard\nwindow","block":[{"line":[{"word":[{"content":"Look","cornerPoint":[{"x":87,"y":203},{"x":83,"y":166},{"x":93,"y":164},{"x":97,"y":201}],"location":{"bottom":97,"left":85,"right":124,"top":83},"recognizedLanguage":"und"},{"content":"and","cornerPoint":[{"x":85,"y":161},{"x":82,"y":138},{"x":90,"y":137},{"x":93,"y":160}],"location":{"bottom":93,"left":127,"right":151,"top":82},"recognizedLanguage":"und"},{"content":"Trace","cornerPoint":[{"x":81,"y":132},{"x":77,"y":96},{"x":86,"y":95},{"x":90,"y":131}],"location":{"bottom":90,"left":156,"right":193,"top":77},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"blackboard","cornerPoint":[{"x":119,"y":129},{"x":116,"y":58},{"x":131,"y":57},{"x":134,"y":128}],"location":{"bottom":134,"left":159,"right":231,"top":116},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"window","cornerPoint":[{"x":171,"y":123},{"x":166,"y":72},{"x":177,"y":70},{"x":182,"y":121}],"location":{"bottom":182,"left":165,"right":218,"top":166},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"Trace ttre letters\nLook! She is Short\nShe is a\ngirl.\nShe is a\ngirl.\nShe is smiling. She is","block":[{"line":[{"word":[{"content":"Trace","cornerPoint":[{"x":460,"y":366},{"x":416,"y":366},{"x":416,"y":354},{"x":460,"y":354}],"location":{"bottom":126,"left":20,"right":64,"top":114},"recognizedLanguage":"und"},{"content":"ttre","cornerPoint":[{"x":412,"y":367},{"x":387,"y":367},{"x":387,"y":354},{"x":412,"y":354}],"location":{"bottom":126,"left":68,"right":93,"top":113},"recognizedLanguage":"und"},{"content":"letters","cornerPoint":[{"x":384,"y":367},{"x":334,"y":367},{"x":334,"y":354},{"x":384,"y":354}],"location":{"bottom":126,"left":96,"right":146,"top":113},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Look!","cornerPoint":[{"x":340,"y":316},{"x":300,"y":318},{"x":299,"y":305},{"x":339,"y":303}],"location":{"bottom":177,"left":140,"right":181,"top":162},"recognizedLanguage":"und"}]}]}]}
		// const tmpData = {"allText":"e-Tnace the lettEr5\nAa Aa\nAa\nB b Bb Bbb\nBb\nCc\nCc","block":[{"line":[{"word":[{"content":"e-Tnace","cornerPoint":[{"x":399,"y":393},{"x":317,"y":395},{"x":316,"y":379},{"x":398,"y":377}],"location":{"bottom":103,"left":81,"right":164,"top":85},"recognizedLanguage":"und"},{"content":"the","cornerPoint":[{"x":313,"y":396},{"x":282,"y":396},{"x":281,"y":380},{"x":312,"y":380}],"location":{"bottom":100,"left":167,"right":199,"top":84},"recognizedLanguage":"und"},{"content":"lettEr5","cornerPoint":[{"x":278,"y":397},{"x":217,"y":398},{"x":216,"y":382},{"x":277,"y":381}],"location":{"bottom":99,"left":202,"right":264,"top":82},"recognizedLanguage":"und"}]}]},{"line":[{"word":[{"content":"Aa","cornerPoint":[{"x":436,"y":362},{"x":349,"y":363},{"x":348,"y":322},{"x":435,"y":321}],"location":{"bottom":159,"left":44,"right":132,"top":117},"recognizedLanguage":"und"}]}]}]}

		cb(tmpData);
	},


	checkGameEnd() {


		

		const arr = this.animaNodeArr;
		const isEnd = arr.every(node => {
			return node.isShowEnd;
		})

		if (isEnd) {
			this.gameEnd();
		} else {


			// this.endTesting();

			// setTimeout(() => {
			// 	this.startTesting();
			// }, 8000);

		}
	},














	bigStarArr: null,
	initStar() {
		const gArr = this.data.groupArr;
		if (gArr.length <= 1) {
			return;
		}

		this.cleanStar();

		this.bigStarArr = [];

		let baseX = this.canvas.width / 2 - 80 * this._mapScaleMin;
		let baseY = this.canvas.height / 2 - 80 * this._mapScaleMin;
		let disH = 80 * this._mapScaleMin;
		let disScale = 1;
		if (gArr.length > 5) {
			disH = (400 / gArr.length) * this._mapScaleMin;
			disScale = 5 / gArr.length;
		}
		for (let i = 0; i < gArr.length; i++) {
			const starBg = getSprNode('star_bg');
			this.canvas.addChild(starBg, 10);
			starBg.x = baseX;
			starBg.y = baseY - i * disH;
			starBg.scale = disScale;

			const starTop = getSprNode('star');
			starBg.addChild(starTop);
			starTop.active = false;
			starBg.star = starTop;

			const starBig = getSprNode('icon_bigstar');
			starTop.addChild(starBig);
			starBig.angle = -90;
			starBg.starBig = starBig;

			this.bigStarArr.push(starBg);
		}

		console.log("bigStarArr: ", this.bigStarArr);
	},

	cleanStar() {
		if (this.bigStarArr && this.bigStarArr.length > 0) {
			for (let i=0; i<this.bigStarArr.length; i++) {
				this.bigStarArr[i].removeFromParent();
			}
		}
	},


	showBigStar() {
		if (!this.bigStarArr || this.bigStarArr.length <= 0) {
			this.checkGameEnd();
			return;
		}
		const bigStarBg = this.bigStarArr[this.curGroupIndex];

		const starBig = bigStarBg.starBig;
		starBig.scale = 1;
		const star = bigStarBg.star;
		star.active = true;
		star.scaleX = 0.7 / bigStarBg.scale;
		star.scaleY = 1 / bigStarBg.scale;
		star.angle = 90;
		const canvas = cc.find('Canvas');
		const startPos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 2));
		const middlePos = exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 4));
		star.x = startPos.x;
		star.y = startPos.y - starBig.height;

		console.log('middlePos = ' + JSON.stringify(middlePos));
		const time = 1;
		cc.tween(star)
			.to(0.3, { y: middlePos.y + 80 }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y + 40, scaleX: 1.2 / bigStarBg.scale, scaleY: 0.8 / bigStarBg.scale }, { easing: 'quadOut' })
			.to(0.1, { y: middlePos.y, scaleX: 1 / bigStarBg.scale, scaleY: 1 / bigStarBg.scale }, { easing: 'quadOut' })
			.delay(0.1)
			.to(0.8, { angle: -720, scale: 1 })
			.start();

		cc.tween(star)
			.delay(0.6)
			.to(0.8, { x: 0 }, { easing: 'quadIn' })
			.start();
		cc.tween(star)
			.delay(0.6)
			.to(0.8, { y: 0 }, { easing: 'quadOut' })
			.start();

		cc.tween(starBig)
			.delay(0.6)
			.to(0.8, { scale: 0 }, { easing: 'quadOut' })
			.call(() => {
				this.checkGameEnd();
				playAudio(this.starCountClip);
			})
			.start();

		playAudio(this.bigStarClip);
	},

	// checkGameEnd() {
	
	// 	this.curGroupIndex ++;
	// 	this.setCurGroupAndQuestion();



	// 	if (!this.curQuestionData) {
	// 		// this.gameEnd();
	// 		return;
	// 	}

	// 	this.showChangeQuesAnim();
	// },

	


	checkBtn: null,
	initBtn() {
		const checkBtn = getSprNode("btn_check");
		checkBtn.scale = this._mapScaleMin;
		this.canvas.addChild(checkBtn);
		checkBtn.x = -500 * this._mapScaleMin;
		checkBtn.y = -35 * this._mapScaleMin;
		checkBtn.baseX = checkBtn.x;
		checkBtn.baseY = checkBtn.y;
		checkBtn.opacity = 0;
		this.checkBtn = checkBtn;

		checkBtn.on(cc.Node.EventType.TOUCH_START, () => {
			if (checkBtn.opacity == 0) {
				return;
			}
			showBtnAnima(checkBtn);
			this.checkBtnClick();
		})

	},

	refreshCheckBtn() {

		this.checkBtn.opacity = 0;

		const arr = this.curOptionArr;
		for (let i=0; i<arr.length; i++) {
			if (arr[i].light.opacity > 254) {
				this.checkBtn.opacity = 255;
				return;
			}
		}
	},

	tryagain: null,
	initIcon() {
		const icon = getSprNode("try_again");
		icon.opacity = 0;
		icon.scale = this._mapScaleMin;
		this.canvas.addChild(icon);

		this.tryagain = icon;
	},

	showTryAgain() {
		const time = 0.3;
		cc.tween(this.tryagain)
			.to(time, {opacity: 255}, {easing: "cubicOut"})
			.delay(0.3)
			.to(time, {opacity: 0}, {easing: "cubicIn"})
			.start();
	},


	initQuestion() {
		this.initPicQuestion();
		this.initTextQuestion();
		this.initVideoQuestion();
		this.initAudioQuestion();
	},

	quesPicBg: null,
	initPicQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesPicBg = picBg;
		picBg.active = false;

		this.addQuesAudio(picBg)
	},

	quesTextBg: null,
	initTextQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesTextBg = picBg;


		const labelNode = new cc.Node();
		labelNode.parent = picBg;
		const label = labelNode.addComponent(cc.RichText);
		const size = 80
		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		// label.string = `<outline color=#a83c13 width=2><size=${size}><color=#ffffff>${this.data.title || " " }</color></size></outline>`
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.CENTER

		label.maxWidth = 648;
	
		picBg.label = label;

		picBg.active = false;
		this.addQuesAudio(picBg)
	},

	quesVideoBg: null,
	videoNode: null,
	initVideoQuestion() {
		const picBg = getSprNode("ques_pic_bg");
		this.canvas.addChild(picBg);
		picBg.scale = this._mapScaleMin;
		picBg.y = 130 * this._mapScaleMin
		this.quesVideoBg = picBg;

		const videoNode = new cc.Node();
		const vPlayer = videoNode.addComponent(cc.VideoPlayer);
		picBg.addChild(videoNode);

		videoNode.width = 678;
		videoNode.height = 396;
		this.videoNode = videoNode;

		picBg.video = vPlayer;


		const btnNode = new cc.Node();
		picBg.addChild(btnNode);
		btnNode.x = picBg.width / 2 + 50;

		const playBtn = getSprNode("video_play");
		btnNode.addChild(playBtn);

		const pauseBtn = getSprNode("video_pause");
		btnNode.addChild(pauseBtn);
		pauseBtn.active = false;


		videoNode.player = vPlayer;
		videoNode.playBtn = playBtn;
		videoNode.pauseBtn = pauseBtn;

		playBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.play();
			playBtn.active = false;
			pauseBtn.active = true;
		})

		pauseBtn.on(cc.Node.EventType.TOUCH_START, () => {
			vPlayer.pause();
			pauseBtn.active = false;
			playBtn.active = true;
		})

		videoNode.on('completed', () => {
			pauseBtn.active = false;
			playBtn.active = true;
		})


		picBg.active = false;
	},

	quesAudioBg: null,
	initAudioQuestion() {

		
		const audioNode = new cc.Node();
		audioNode.active = false;

		this.canvas.addChild(audioNode);
		audioNode.x = 440 * this._mapScaleMin;
		audioNode.y = -60 * this._mapScaleMin;
		this.quesAudioBg = audioNode;
		
		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/audio_big"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('audio_big')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}

			if (!audioNode.audioClip) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('audio_big');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

	},


	addQuesAudio(bg) {
		const audioNode = new cc.Node();
		bg.addChild(audioNode);
		audioNode.x = bg.width / 2 + 50;


		const audioAnimNode = cc.instantiate(cc.find("Canvas/res/anim/ques_audio"));
		audioNode.addChild(audioAnimNode);

		const iconTop = getSprNode('ques_audio')
		audioNode.addChild(iconTop);
		iconTop.opacity = 255;

		iconTop.addComponent(cc.BlockInputEvents);
		iconTop.on(cc.Node.EventType.TOUCH_START, () => {

			if (iconTop.opacity == 0) {
				return;
			}
			const anim = audioAnimNode.getComponent(cc.Animation);
			anim.play('ques_audio');
			iconTop.opacity = 0;
			audioAnimNode.opacity = 255;

			if (audioNode.audioClip) {
				playAudio(audioNode.audioClip, () => {
					iconTop.opacity = 255;
					audioAnimNode.opacity = 0;
					anim.stop();
				});
			}
		})

		bg.audioNode = audioNode;
	},

	initOption() {
		this.initPicOption();
		this.initAudioOption();
		this.initTextOption();

		this.initPicOptionBig();
		this.initAudioOptionBig();
		this.initTextOptionBig();
	},

	optionPicBgArr: null,
	initPicOption() {
		// console.log('this.data: ', this.data);
		this.optionPicBgArr = [];
		for (let i=0; i<4; i++) {
		
			const pic = this.getOnePicOption();
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.y = -235 * this._mapScaleMin;
			this.optionPicBgArr.push(pic);

		} 
	},

	optionPicBgBigArr: null,
	initPicOptionBig() {
		this.optionPicBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;


		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}
			const pic = this.getOnePicOption(true);
			this.canvas.addChild(pic);
			pic.scale = this._mapScaleMin;
			pic.x = baseX + count * disW;
			pic.y = baseY;
			this.optionPicBgBigArr.push(pic);

			count ++;
		} 
	},

	getOnePicOption(isBig = false) {
		const picBgParent = new cc.Node();

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const light = getSprNode(lightResName);
		picBgParent.addChild(light);
		light.opacity = 0;
		picBgParent.light = light;

		const picBg = getSprNode(bgResName);
		picBgParent.addChild(picBg);
		picBgParent.picBg = picBg;

		picBgParent.width = picBg.width;
		picBgParent.height = picBg.height;


		const soundNode = new cc.Node();
		picBgParent.addChild(soundNode);
		picBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = picBgParent.width / 2 - soundIconTop.width / 2;
		soundNode.y = picBgParent.height / 2 //- soundIconTop.height / 2;
		soundNode.active = false;


		picBgParent.active = false;


		picBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}

			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return picBgParent;
	},

	addIconRight(bg) {

		const px = bg.width / 2;
		const py = -bg.height / 2 ;
		const worldPos = bg.convertToWorldSpaceAR(cc.v2(px, py));
		const localPos = this.canvas.convertToNodeSpaceAR(worldPos);


		const iconRight = getSprNode('icon_right');
		iconRight.scale = this._mapScaleMin;
		this.canvas.addChild(iconRight, 1);
		iconRight.x = localPos.x;
		iconRight.y = localPos.y + 50 * this._mapScaleMin;

		bg.iconRight = iconRight;


		this.showOneFirework(cc.v2(0, -bg.height / 3), bg, cc.find('paperBase').children, 200, 300, 20, 1);
	},


	optionAudioBgArr: null,
	initAudioOption() {
		this.optionAudioBgArr = [];
		for (let i=0; i<4; i++) {
		
			const audio = this.getOneAudioOption();
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.y = -235 * this._mapScaleMin;
			this.optionAudioBgArr.push(audio);
		} 
	},

	optionAudioBgBigArr: null,
	initAudioOptionBig() {

		this.optionAudioBgBigArr = [];

		const baseX = -380 * this._mapScaleMin;
		const disW = 440 * this._mapScaleMin;
		let baseY = 170 * this._mapScaleMin;
		const disH = 350 * this._mapScaleMin;
		let count = 0;

		for (let i=0; i<4; i++) {
		
			if (i==2) {
				count = 0;
				baseY -= disH;
			}

			const audio = this.getOneAudioOption(true);
			this.canvas.addChild(audio);
			audio.scale = this._mapScaleMin;
			audio.x = baseX + count * disW;
			audio.y = baseY;
			this.optionAudioBgBigArr.push(audio);

			count ++;
		} 
	},


	optionTextBgArr: null,
	initTextOption() {
		this.optionTextBgArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption();
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			// textOption.y = -235 * this._mapScaleMin;
			this.optionTextBgArr.push(textOption);
		} 
	},

	optionTextBgBigArr: null,
	initTextOptionBig() {

		const baseX = -180 * this._mapScaleMin;
		const disW = 100 * this._mapScaleMin;
		let baseY = 220 * this._mapScaleMin;
		const disH = 150 * this._mapScaleMin;

		this.optionTextBgBigArr = [];
		for (let i=0; i<4; i++) {
		
			const textOption = this.getOneTextOption(true);
			this.canvas.addChild(textOption);
			textOption.scale = this._mapScaleMin;
			textOption.x = baseX;
			textOption.y = baseY - i * disH;
			this.optionTextBgBigArr.push(textOption);
		}
	},

	getOneAudioOption(isBig=false) {

		let lightResName = "option_pic_bg_l";
		let bgResName = "option_pic_bg";
		if (isBig) {
			lightResName = "op_pic_bg_big_l";
			bgResName = "op_pic_bg_big";
		}

		const audioBgNode = new cc.Node();

		const light = getSprNode(lightResName);
		audioBgNode.addChild(light);
		light.opacity = 0;
		audioBgNode.light = light;

		const picBg = getSprNode(bgResName);
		audioBgNode.addChild(picBg);
		audioBgNode.picBg = picBg;

		audioBgNode.width = picBg.width;
		audioBgNode.height = picBg.height;

		const animNode = cc.instantiate(cc.find("Canvas/res/anim/op_audio"))
		audioBgNode.addChild(animNode);
		animNode.anchorX = 0.6;


		const animTop = getSprNode('op_audio');
		audioBgNode.addChild(animTop);
		animTop.anchorX = 0.6;

		const anim = animNode.getComponent(cc.Animation);
		animNode.opacity = 0;

		audioBgNode.anim = anim;
		audioBgNode.animNode = animNode;
		audioBgNode.animTop = animTop;
		
		audioBgNode.showAnim = () => {
			this.playItemAnim(audioBgNode);
			cc.audioEngine.stop(audioBgNode.audioId);
		}
		audioBgNode.stopAnim = () => {
			cc.audioEngine.stop(audioBgNode.audioId);
			this.stopItemAnim(audioBgNode);
		}

		audioBgNode.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
				
				audioBgNode.showAnim();
				if (audioBgNode.audioClip) {
					audioBgNode.audioId = playAudio(audioBgNode.audioClip, () => {
						this.stopItemAnim(audioBgNode);
					});
				}

			} else {
				light.opacity = 0;
				audioBgNode.stopAnim();
			}

			this.refreshCheckBtn();

		});

		audioBgNode.active = false;

		return audioBgNode;
	},

	getOneTextOption(isBig=false) {

		let lightResName = "option_text_bg_l";
		let bgResName = "option_text_bg";
		if (isBig) {
			lightResName = "op_text_bg_big_l";
			bgResName = "op_text_bg_big";
		}

		const textBgParent = new cc.Node();
		textBgParent.active = false;

		const light = getSprNode(lightResName);
		textBgParent.addChild(light);
		light.opacity = 0;
		textBgParent.light = light;

		const textBg = getSprNode(bgResName);
		textBgParent.addChild(textBg);
		textBgParent.textBg = textBg;

		textBgParent.width = textBg.width;
		textBgParent.height = textBg.height;

		const labelNode = new cc.Node();
		labelNode.parent = textBgParent;
		const label = labelNode.addComponent(cc.Label);

		label.fontSize = 56;
		label.lineHeight = 56;
		if (isBig) {
			label.fontSize = 64;
			label.lineHeight = 64;
		}

		label.font = cc.find('Canvas/res/font/Berlin-Sans-FB').getComponent(cc.Label).font;
		textBgParent.label = label;

		const color = new cc.Color();
		cc.Color.fromHEX(color, '#023659' );
		labelNode.color = color;


		const soundNode = new cc.Node();
		textBgParent.addChild(soundNode);
		textBgParent.soundIcon = soundNode;

		const soundIconAnim = cc.instantiate(cc.find("Canvas/res/anim/laba"))
		soundNode.addChild(soundIconAnim);
		soundIconAnim.opacity = 0;

		const soundIconTop = getSprNode('btn_laba')
		soundNode.addChild(soundIconTop);
		soundIconTop.opacity = 255;

		soundNode.x = textBgParent.width / 2 - 15; // - soundIconTop.width / 2;
		soundNode.y = textBgParent.height / 2 - 15; //- soundIconTop.height / 2;
		soundNode.active = false;


		textBgParent.on(cc.Node.EventType.TOUCH_START, () => {
			if( light.opacity == 0 ) {
				light.opacity = 255;
				playAudio(this.selectClip);
			} else {
				light.opacity = 0;
			}
			this.refreshCheckBtn();
		})


		soundIconTop.addComponent(cc.BlockInputEvents);
		soundIconTop.on(cc.Node.EventType.TOUCH_START, () => {
			const anim = soundIconAnim.getComponent(cc.Animation);
			anim.play('laba');
			soundIconTop.opacity = 0;
			soundIconAnim.opacity = 255;

			if (soundNode.audioClip) {
				playAudio(soundNode.audioClip, () => {
					soundIconTop.opacity = 255;
					soundIconAnim.opacity = 0;
					anim.stop();
				});
			}
		})

		return textBgParent;
	},

	playItemAnim(item) {
		item.anim.play();
		item.animNode.opacity = 255;
		item.animTop.opacity = 0;
	},

	stopItemAnim(item) {
		item.animNode.opacity = 0;
		item.animTop.opacity = 255;
	},

	setCurQuestion() {
		
		switch(this.curQuestionData.questionType) {
			case "pic":
				this.setQuestionPic();
				break;
			case "text":
				this.setQuestionText();
				break;
			case "video":
				this.setQuestionVideo();
				break;
			case "audio":
				this.setQuestionAudio();
				break;
		}

		this.refreshCheckBtnPos();
	},

	refreshCheckBtnPos() {
		if (this.curQuestionData.questionType == 'audio') {
			this.checkBtn.x = 440 * this._mapScaleMin;
			this.checkBtn.y = -240 * this._mapScaleMin;
		} else {
			this.checkBtn.x = this.checkBtn.baseX;
			this.checkBtn.y = this.checkBtn.baseY;
		}
	},

	curQuesBg: null,
	setQuestionPic() {

		this.curQuesBg = this.quesPicBg;
		this.curQuesBg.active = true;


		if (this.quesPicBg.pic) {
			this.quesPicBg.pic.removeFromParent();
			this.quesPicBg.pic = null;
		}
		if (this.curQuestionData.pic_url) {
			getSprNodeByUrl(this.curQuestionData.pic_url, (spr) => {
				const sprNode = spr.node;
				setSprNodeMaxLen(sprNode, 678, 396);
				this.quesPicBg.addChild(sprNode)
				this.quesPicBg.pic = sprNode;
			})
		}
	
		const audioNode = this.quesPicBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionText() {
		this.curQuesBg = this.quesTextBg;
		this.curQuesBg.active = true;

		
		const label = this.curQuesBg.label;
		const size = 80; 
		label.string = `<size=${size}><color=#fff4b6>${this.curQuestionData.text}</color></size>`

		const maxH = this.curQuesBg.height * 0.98;

		if (label.node.height > maxH) {
			label.node.scale = maxH / label.node.height
		} else {
			label.node.scale = 1;
		}


		const audioNode = this.curQuesBg.audioNode;
		audioNode.active = false;
		audioNode.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				audioNode.audioClip = audioClip;
			});	
			audioNode.active = true;
		}
	},

	setQuestionVideo() {
		this.curQuesBg = this.quesVideoBg;
		this.curQuesBg.active = true;
		this.videoNode.active = true;

		if (this.curQuestionData.video_url) {
			this.curQuesBg.video.remoteURL = this.curQuestionData.video_url;
		}
	},

	setQuestionAudio() {
		this.curQuesBg = this.quesAudioBg;
		this.curQuesBg.active = true;


		this.curQuesBg.audioClip = null;
		if (this.curQuestionData.audio_url) {
			cc.assetManager.loadRemote(this.curQuestionData.audio_url, (err, audioClip) => {
				this.curQuesBg.audioClip = audioClip;
			});
		}
	},



	setCurOption() {
		const arr = this.curQuestionData.answerArr;

		const isBig = this.curQuestionData.questionType == 'audio';

		switch(this.curQuestionData.answerType) {
			case "pic":
				this.setOptionPic(arr, isBig);
				break;
			case "audio":
				this.setOptionAudio(arr, isBig);
				break;
			case "text":
				this.setOptionText(arr, isBig);
				break;
		}
		
	},



	curOptionArr: null,
	setOptionPic(arr, isBig=false) {

		let opItemArr = this.optionPicBgArr;
		if (isBig) {
			opItemArr = this.optionPicBgBigArr;
		}
		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const picBg = opItemArr[i].picBg;
			picBg.removeAllChildren();
			
			const data = arr[i];
			if (data.pic_url) {
				getSprNodeByUrl, getSprNodeByUrl(data.pic_url, (spr) => {
					let maxW = 280;
					let maxH = 190;
					if (isBig) {
						maxW = 366;
						maxH = 248;
					}

					setSprNodeMaxLen(spr.node, maxW, maxH);
					console.log('spr: ', spr);
					picBg.addChild(spr.node);
				})
			}

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},


	setOptionAudio(arr, isBig=false) {

		let opItemArr = this.optionAudioBgArr;
		if (isBig) {
			opItemArr = this.optionAudioBgBigArr;
		}

		this.curOptionArr = [];
		const disW = 158 * this._mapScaleMin;
		const baseX = -(arr.length - 1) * disW;
		for (let i=0; i<arr.length; i++) {
			
			opItemArr[i].active = true;
			if(!isBig) {
				opItemArr[i].x = baseX + i * disW * 2;
			}

			const data = arr[i];

			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					opItemArr[i].audioClip = audioClip;
				});
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);
		}
	},

	setOptionAudioBig(arr) {
		this.curOptionArr = [];
		for (let i=0; i<arr.length; i++) {
			
			this.optionAudioBgArr[i].active = true;

			const data = arr[i];

			this.optionAudioBgArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					this.optionAudioBgArr[i].audioClip = audioClip;
				});
			}

			this.optionAudioBgArr[i].data = data;
			this.curOptionArr.push(this.optionAudioBgArr[i]);
		}
	},


	setOptionText(options, isBig=false) {

		console.log(' in setOptionText, isBig: ', isBig);

		let opItemArr = this.optionTextBgArr;
		if (isBig) {
			opItemArr = this.optionTextBgBigArr
		}

		this.curOptionArr = [];
		const disW = 315 * this._mapScaleMin;
		const disH = 120 * this._mapScaleMin;
		const baseX = - disW ;
		let baseY = -235 * this._mapScaleMin;
		if (options.length > 2) {
			baseY = -170 * this._mapScaleMin;
		}
		let count = 0;
		for (let i=0; i<options.length; i++) {

			if ( i == 2 ) {
				baseY -= disH;
				count = 0;
			}
			
			opItemArr[i].active = true;
			if (!isBig) {
				opItemArr[i].x = baseX + count * disW * 2;
				opItemArr[i].y = baseY;
			}
		
			const data = options[i];

			opItemArr[i].label.string = data.text;
			opItemArr[i].label["_forceUpdateRenderData"](true);
			if (opItemArr[i].label.node.width > opItemArr[i].width * 0.9) {
				opItemArr[i].label.node.scale = opItemArr[i].width * 0.9 / opItemArr[i].label.node.width;
			} else {
				opItemArr[i].label.node.scale = 1;
			}
			

			const soundIcon = opItemArr[i].soundIcon;
			soundIcon.active = false;
			soundIcon.audioClip = null;
			opItemArr[i].audioClip = null;
			if (data.audio_url) {
				cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
					soundIcon.audioClip = audioClip;
					opItemArr[i].audioClip = audioClip;
				});
				
				soundIcon.active = true;
			}

			opItemArr[i].data = data;
			this.curOptionArr.push(opItemArr[i]);

			count++;
		}
	},



	shakeArr: null,
	wrongArr: null,
	checkBtnClick() {

		this.shakeArr = [];
		this.wrongArr = [];
		this.checkItemWrong();

		if (this.wrongArr.length > 0) {
			//有选错的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		const isRightAll = this.checkItemRightCount();
		if (!isRightAll) {
			// 有漏选的
			this.itemShake();
			this.hideLight();
			playAudio(this.wrongClip);
			return;
		}

		this.showAllRight();
		this.showMask();

		playAudio(this.rightClip, () => {
			this.playAnswerAudio(0);
		})
		
	},

	playAnswerAudio(index) {
		const arr = this.curOptionArr;
		if (!arr[index]) {

			// delayCall(0.5, () => {
				this.changeNextQuestion();
			// })

		} else {
			if ( arr[index].light.opacity > 254 && arr[index].audioClip ) {
				playAudio(arr[index].audioClip, () => {
					this.playAnswerAudio(index + 1);
				})
			} else {
				this.playAnswerAudio(index + 1);
			}
		}
	},


	checkItemWrong() {
		const arr = this.curOptionArr;
		console.log('arr: ', arr);
		for (let i=0; i<arr.length; i++) {
			const itemBg = arr[i];
			if (itemBg.light.opacity >= 254) {
				this.shakeArr.push(itemBg);
				console.log('aaa', itemBg.data);;
				if (itemBg.data.answerRight == '0') {
					this.wrongArr.push(itemBg);
				}
			}
		}
	},

	checkItemRightCount() {
		let rightTotalCount = 0;
		const answerArr = this.curQuestionData.answerArr;
		for (let i=0; i<answerArr.length; i++) {
			if (answerArr[i].answerRight == '1') {
				rightTotalCount ++;
			}
		}

		let curRightCount = 0;
		const curOptionArr = this.curOptionArr;
		for (let i=0; i<curOptionArr.length; i++) {
			if (curOptionArr[i].light.opacity > 254) {
				curRightCount ++;
			}
		}

		return rightTotalCount == curRightCount;
	},

	itemShake() {
		let rate = 1;
		if (this.curQuestionData.answerType == 'text') {
			rate = 0.5;
		}

		const arr = this.shakeArr;
		for (let i=0; i<arr.length; i++) {
			this.rotateShake(arr[i], rate);
			if (arr[i].stopAnim) {
				arr[i].stopAnim();
			}
		}

		this.showTryAgain();
	},

	hideLight() {
		const arr = this.curOptionArr;
		for (let i=0; i<arr.length; i++) {
			arr[i].light.opacity = 0;
		}
		this.checkBtn.opacity = 0;
	},

	rotateShake(item, rate = 1) {

		const time = 0.9;
		cc.tween(item)
			.to(time / 6 / 2, {angle: -20 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 12 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: -7 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 4 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: -2 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 1 * rate}, {easing: 'sineInOut'})
			.to(time / 6, {angle: 0 * rate}, {easing: 'sineInOut'})
			.start();

	},

	showAllRight() {
		const curOptionArr = this.curOptionArr;
		for (let i=0; i<curOptionArr.length; i++) {
			if (curOptionArr[i].light.opacity > 254) {
				this.addIconRight(curOptionArr[i]);
			}
		}
	},

	changeNextQuestion() {
		console.log(' in changeNextQuestion')

		this.curQuestionIndex ++ ;
		this.setCurQuestionData();

		if (!this.curQuestionData) {
			// this.gameEnd();
			return;
		}

		this.showChangeQuesAnim();
	
	},

	showChangeQuesAnim() {
		this.hideLight();

		this.hideCurOptionAnim(() => {
			this.setCurOption();
			this.showCurOptionAnim();
			this.hideMask();
		});

		this.hideCurQuestion(() => {
			this.setCurQuestion();
			this.showCurQuestionAnim();
		});
	},


	maskLayer: null,
	initMask() {
		const maskLayer = new cc.Node();
		maskLayer.width = this.canvas.width;
		maskLayer.height = this.canvas.height;
		this.canvas.addChild(maskLayer, 20);

		maskLayer.addComponent(cc.BlockInputEvents);
		this.maskLayer = maskLayer;
		this.maskLayer.active = false;
	},

	showMask() {
		this.maskLayer.active = true;
	},

	hideMask() {
		this.maskLayer.active = false;
	},

	hideCurOptionAnim(cb) {
		const arr = this.curOptionArr;
		const time = 0.5;
		for (let i=0; i<arr.length; i++) {
			if (arr[i].iconRight) {
				arr[i].iconRight.removeFromParent();
				arr[i].iconRight = null;
			}
			cc.tween(arr[i])
				.to(time, {opacity: 0}, {easing: "cubicOut"})
				.call(() => {
					arr[i].active = false;
				})
				.start();
		}
		delayCall(time, () => {
			cb();
		})
	},

	showCurOptionAnim(cb=null) {
		const arr = this.curOptionArr;
		const time = 0.5;
		for (let i=0; i<arr.length; i++) {
			arr[i].opacity = 0;
			cc.tween(arr[i])
				.to(time, {opacity: 255}, {easing: "cubicIn"})
				.start();
		}

		if (cb) {
			delayCall(time, () => {
				cb();
			})
		}
	
	},

	hideCurQuestion(cb) {
		const time = 0.5;
		cc.tween(this.curQuesBg)
			.to(time, {opacity: 0}, {easing: "cubicOut"})
			.call(() => {
				this.curQuesBg.active = false;
				cb();
			})
			.start();
	},

	showCurQuestionAnim() {

		this.curQuesBg.active = true;
		this.curQuesBg.opacity = 0;

		const time = 0.5;
		cc.tween(this.curQuesBg)
			.to(time, {opacity: 255}, {easing: "cubicIn"})
			.start();
	},



	gameEnd() {
		console.log('game end !')

		this.isGameEnd = true;

		// this.showRestart();
		// this.showGoodjob();
		// this.showOneFirework(cc.v2(0, -this.canvas.height / 2), this.canvas, cc.find('paperBase').children, this.canvas.width / 2.5, this.canvas.height * 2, 100, 1);
		playAudio(this.finishClip);


		const camera = cc.find('Canvas/Main Camera');
		camera.zIndex = 100;

		showTrebleFirework(camera, cc.find('RibbonNodeBase').children);


		const endData = this.getEndData();
		onHomeworkFinish(endData);

		this.endTesting();
	},

	getEndData() {

		return {};

		const arr = this.picNodeArr;
		const customData = [];
		let stone = 0;
		const oneQuesStone = 10 / arr.length;
		arr.forEach(node => {
			customData.push({isRight: node.isRight})
			if (node.isRight) {
				stone += oneQuesStone;
			}
		})
		stone = Math.round(stone * 10) / 10;
		return {customData, stone};
	},

	showGoodjob() {

		const icon = getSprNode("goodjob");
		icon.scale = this._mapScaleMin;
		icon.baseS = icon.scale;
		this.canvas.addChild(icon, 20);


		const time = 1;
		icon.scale = 0;
		cc.tween(icon)
			.to(0.8,  {scale: icon.baseS}, {easing: "elasticOut"})
			.delay(1)
			.to(0.5, {scale: 0} , {easing: "cubicIn"})

			.start();



	},

	showRestart() {

		const btn = getSprNode("btn_restart");
		btn.scale = this._mapScaleMin;
		btn.baseS = btn.scale;
		this.canvas.addChild(btn, 21);

		btn.on(cc.Node.EventType.TOUCH_START, () => {
			// btn.removeFromParent();
			// this.initData();
			// this.initStar();
			// this.showChangeQuesAnim();
			// playAudio(this.btnClip);

			const middleLayer = cc.find('middleLayer');
			if (middleLayer) {
				middleLayer.getComponent('middleLayer').reloadBundle();
			}
		})

		const time = 0.9;
		btn.scale = 0;
		cc.tween(btn)
			.delay(2.5)
			.to(time,  {scale: btn.baseS}, {easing: "elasticOut"})
			.start();

	},



	async showOneFirework(pos, parentNode, nodeList, w, h, n, timeRate=1) {

		for (let i = 0; i < 3; i++) {
				this.showFirework(pos, parentNode, nodeList, w, h, n, timeRate);
				await asyncDelay(0.1);
		}
	},

	showFirework(pos, parentNode, nodeList, width = 200, height = 500, number = 30, timeRate=1) {
			const subTime = 1;
			for (let i = 0; i < number; i++) {
					const quad = this.createQuads(pos, parentNode, nodeList);
					const targetX = RandomInt(width / 2, -width / 2);
					const targetY = RandomInt(height);

					cc.tween(quad)
							.by(0.5 * timeRate, { x: targetX })
							.by((2 + subTime *  Math.random()) * timeRate, { x: targetX * 2 })
							.start();

					cc.tween(quad)
							.by(0.5 * timeRate, { y: targetY }, { easing: 'quadOut' })
							.to((3 + subTime * Math.random()) * timeRate, { y: -parentNode.height * 2 }, { easing: 'quadIn' })
							.removeSelf()
							.start();

					cc.tween(quad)
							.delay(1  * timeRate)
							.to((0.5 + subTime * Math.random()) * timeRate , { opacity: 0 })
							.start();
			}
	},

	createQuads(pos, parentNode, nodeList) {
			const quadBase = cc.instantiate(nodeList[RandomInt(nodeList.length)]);

			quadBase.x = pos.x;
			quadBase.y = pos.y;
			quadBase.z = pos.z;
			quadBase.angle = RandomInt(180);
			quadBase.parent = parentNode;

			const quad = quadBase.getChildByName('quad');
			quad.x = 0;
			quad.y = 0;
			quad.angle = RandomInt(180);

			const paper = quad.getChildByName('paper');
			paper.scaleX = Math.random() * 0.8 + 0.2;
			paper.scaleY = Math.random() * 0.8 + 0.2;

			quadBase.scaleX = Math.random();
			cc.tween(quadBase)
					.to((1 - quadBase.scaleX) * 0.3, { scaleX: 1 })
					.call(() => {
							const time = Math.random() * 0.2;
							cc.tween(quadBase)
									.to(0.1 + time, { scaleX: -1 })
									.to(0.1 + time, { scaleX: 1 })
									.union()
									.repeatForever()
									.start();
					})
					.start();


			return quadBase;
	},


















	restart() {
		
	},


	initTitle() {

		const offX = 96;
		const offY = 11;
		const title = getSprNode('title_bg');
		title.parent = this.canvas;
		title.scale = this._mapScaleMin;
		title.zIndex = 10;

		title.x = -this.canvas.width / 2 + title.width / 2 * title.scale + offX;
		title.y = this.canvas.height / 2 - title.height / 2 * title.scale - offY;

		// console.log('this.data: ', this.data);

		title.addComponent(cc.Button)
		title.on('click', () => {
			if (this.data.title_audio_url) {
				playAudioByUrl(this.data.title_audio_url);
			}
		})

		const labelNode = new cc.Node();
		labelNode.parent = title;
		const label = labelNode.addComponent(cc.RichText);
		const size = 42
		label.font = cc.find('Canvas/res/font/aharoni').getComponent(cc.Label).font;
		label.string = `<outline color=#a83c13 width=2><size=${size}><color=#ffffff>${this.data.title || " " }</color></size></outline>`
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.LEFT
		labelNode.anchorX = 0;
		labelNode.anchorY = 1
		labelNode.x = -title.width / 2 + 90;

		const maxLen = 305;
		if (labelNode.width > maxLen) {
			labelNode.scale = maxLen / labelNode.width;
		}

		labelNode.y = labelNode.height / 2 * labelNode.scale + 15;

	},


	initBg() {
		
		console.log("this.data.bg_pic_url: ", this.data.bg_pic_url);

		if (!this.data.bg_pic_url) {
			return;
		}

		getSprNodeByUrl(this.data.bg_pic_url, (spr) => {

			this.canvas.addChild(spr.node);
			const sx = this.canvas.width / spr.node.width;
			const sy = this.canvas.height / spr.node.height;
			spr.node.scale = Math.max(sx, sy);
		});

	},
	


	initHotZone() {
		this.initHotZoneBg();
	},


	hotZoneBg: null,
	initHotZoneBg() {
		this.hotZoneBg = new cc.Node();

		this.hotZoneBg.name = 'hotZoneBg';
		this.hotZoneBg.parent = cc.find('Canvas');
		this.hotZoneBg.zIndex = 4;

		if (!this.data.bgItem) {
			return;
		}

		cc.loader.load({url: this.data.bgItem.url}, (err, img) => {

			// this.addMask(this.hotZoneBg);

			this.hotZoneBg.width = img.width;
			this.hotZoneBg.height = img.height;



			const sprNode = new cc.Node();
			sprNode.name = 'bgItemSpr'
			var sf = new cc.SpriteFrame(img);
			// const spr = this.hotZoneBg.addComponent(cc.Sprite);
			const spr = sprNode.addComponent(cc.Sprite);
			spr.spriteFrame = sf
			sprNode.width = this.hotZoneBg.width;
			sprNode.height = this.hotZoneBg.height;
			sprNode.parent = this.hotZoneBg;
			window['bg'] =sprNode 


			const sx = this.canvas.width / this.hotZoneBg.width;
			const sy = (this.canvas.height) / this.hotZoneBg.height;
			const s = Math.min(sx, sy);
			this.hotZoneBg.scale = s;

			// this.data.bgItem.isShowDebugLine = true;
			this.initHotZoneItem();


	
		});

	},

	initHotZoneItem() {

		this.picNodeArr = [];

		this.data.hotZoneItemArr.forEach((item) => {
			// console.log('item.gIdx: ', item.gIdx);
			switch (item.gIdx) {

				case "1":
					this.setOneAnimaSmall(item);
					break;
				case "3":
					this.setOneAudioBtn(item);
					break;
						
				default:
					break;
			}

		});

	},


	addMask(node) {
		const mask = node.addComponent(cc.Mask);
		mask.type = cc.Mask.Type.RECT;
	},


	setOneDragAction(data) {

		const rate =  (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY ;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		const {x, y, width, height} = rectNode;
		// rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(-rectNode.width / 2, -rectNode.height / 2, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();
		rectNode.x += rectNode.width / 2;
		rectNode.y += rectNode.height / 2;

		rectNode.baseX = rectNode.x;
		rectNode.baseY = rectNode.y;
		rectNode.targetOff();

		rectNode.on(cc.Node.EventType.TOUCH_START, () => {

			if (rectNode.isDragEnd) {
				if (rectNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
				}
				return;
			}
			this._curShowItem = rectNode;
		})
		

		const realRate = this.hotZoneBg.width / this.data.bgItem.rect.width;
		rectNode.targetPx = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
		rectNode.targetPy = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				rectNode.audioClip = audioClip;
			});
		}



		console.log('setOneAction ~~ data: ', data)
		const actionData = data['actionData_' + data.gIdx];
		if (!actionData) {
			return;
		}
		if (actionData.type == 'text') {
			const label = this.setOneActionText(rectNode, actionData);
			label.node.scale = scale * data.fontScale;

			label.node.targetOff();
		
	

			// label.overflow = cc.Label.Overflow.NONE;
			// label.node.setContentSize(new cc.Size(0, lineHeight));
			label["_forceUpdateRenderData"](true);
		
			
		} else if (actionData.type == 'pic') {

			const pic = this.setOneActionPic(rectNode, actionData);

		} else if (actionData.type == 'anima') {

			const anima = this.setOneActionAnima(rectNode, actionData);
		}
	},



	setOneAction(data) {

		const rate =  (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;
		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);

		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY ;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		const {x, y, width, height} = rectNode;
		rectNode.anchorX = rectNode.anchorY = 0;

		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();



		console.log('setOneAction ~~ data: ', data)
		const actionData = data['actionData_' + data.gIdx];
		if (!actionData) {
			return;
		}
		if (actionData.type == 'text') {
			const label = this.setOneActionText(rectNode, actionData);
			label.node.scale = scale * data.fontScale;

			// label.overflow = cc.Label.Overflow.NONE;
			// label.node.setContentSize(new cc.Size(0, lineHeight));
			label["_forceUpdateRenderData"](true);
		
			
		} else if (actionData.type == 'pic') {

			const pic = this.setOneActionPic(rectNode, actionData);

		} else if (actionData.type == 'anima') {

			const anima = this.setOneActionAnima(rectNode, actionData);
		}
	},

	setOneActionText(rectNode, actionData) {


		const labelNode = new cc.Node();
		labelNode.parent = rectNode;
		const label = labelNode.addComponent(cc.Label);

		label.font = cc.find('Canvas/res/font/ahronbd-1').getComponent(cc.Label).font;
		label.string = actionData.text;
		// label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		// label.lineHeight = size;
		// label.horizontalAlign = cc.macro.TextAlignment.LEFT
		// labelNode.anchorX = 0;
		// labelNode.anchorY = 1
		labelNode.color = cc.Color.BLACK;


		const opArr = actionData.changeOption
		// console.log('opArr', opArr);


		const tweenArr = [];

		for (let i = 0; i < opArr.length; i++ ) {

			const opData = opArr[i];
			console.log('opArr[0]', opArr[i])
			if (opData[0] == 'fontColor') {
				const color = new cc.Color();
				cc.Color.fromHEX(color, opData[1] );
				labelNode.color = color;

			} else if (opData[0] == 'opacity') {
				// console.log('opData: ', opData)
				labelNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
				// console.log(labelNode.opacity);
				tweenArr.push({item: labelNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[0]},)

			} else {
				label[opData[0]] = opData[1];
				tweenArr.push({item: label, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[0]})

			}
		}


		// if (actionData.audio_url) {
		// 	cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
		// 		labelNode.audioClip = audioClip;
		// 	});
		// }


		label.lineHeight = label.fontSize;

		// labelNode.y += rectNode.height / 2;
		// labelNode.x += rectNode.width / 2;
		

		// rectNode.addComponent(cc.Button);
		// rectNode.on('click', () => {

		// 	if (labelNode.audioClip) {
		// 		cc.audioEngine.stopAllEffects();
		// 		cc.audioEngine.playEffect(labelNode.audioClip, false, 0.8);
		// 	}

		// 	if (labelNode.isClicked) {
		// 		// return;
		// 	}
		// 	labelNode.isClicked = true;

		// 	for (let i=0; i<tweenArr.length; i++) {
		// 		const tweenData = tweenArr[i];

		// 		if (tweenData.optionName == 'opacity') {
		// 			console.log('~~~ ',  tweenData.item[tweenData.optionName] );

		// 			cc.tween(tweenData.item)
		// 				.to(actionData.changeTime,  JSON.parse(tweenData.option) )
		// 				.start();
		// 		}
				

		// 	}

		// });


		return label;
	},

	setOneActionPic(rectNode, actionData) {

		console.log('setOneActionPic actionData: ', actionData)
		const picNode = new cc.Node();
		rectNode.addChild(picNode);

		cc.loader.load({url: actionData.pic_url}, (err, img) => {

			const spr = picNode.addComponent(cc.Sprite);
			spr.spriteFrame = new cc.SpriteFrame(img)

			picNode.y += rectNode.height / 2;
			picNode.x += rectNode.width / 2;

			picNode.scaleX = rectNode.width / picNode.width;
			picNode.scaleY = rectNode.height / picNode.height;

			const opArr = actionData.changeOption	
			const tweenArr = [];
	
			for (let i = 0; i < opArr.length; i++ ) {
	
				const opData = opArr[i];
				console.log('opData: ~~~ ', opData);

				if (opData[0] == 'opacity') {
					picNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
					console.log(picNode.opacity);
					tweenArr.push({item: picNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[0]},)
	
				}  else {
					// picNode[opData[0]] = Number(opData[1]);
					// tweenArr.push({item: picNode, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[0]})
				}

	
				if (actionData.audio_url) {
					cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
						rectNode.audioClip = audioClip;
					});
				}
				

				rectNode.addComponent(cc.Button);
				rectNode.on('click', () => {

					if (rectNode.audioClip) {
						cc.audioEngine.stopAllEffects();
						cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
					}
		
					if (rectNode.isClicked) {
						// return;
					}
					rectNode.isClicked = true;

					for (let i=0; i<tweenArr.length; i++) {
						const tweenData = tweenArr[i];
		
						if (tweenData.optionName == 'opacity') {
							cc.tween(tweenData.item)
								.to(actionData.changeTime,  JSON.parse(tweenData.option) )
								.start();
						}
					}
		
				});
			}

		});
	},

	setOneActionAnima(rectNode, actionData) {


		const animaNode = new cc.Node();
		rectNode.addChild(animaNode);

		if (actionData.audio_url) {
			cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
				rectNode.audioClip = audioClip;
			});
		}

		const data = actionData;

		const dragonDisplay = animaNode.addComponent(dragonBones.ArmatureDisplay);
		if (!data.texPngData) {
			return
		}



		const image = data.texPngData.url//"http://staging-teach.cdn.ireadabc.com/5a0c5af3e952acd0ac83a6e5c6f03ff1.png";
		const ske = data.skeJsonData.url//"http://staging-teach.cdn.ireadabc.com/bd825dcceea298d1146be8067ae3d17f.json";
		const atlas = data.texJsonData.url//"http://staging-teach.cdn.ireadabc.com/246f8991b729fa3e5a7f4802de828efa.json";
		cc.loader.load(image, (error, texture) => {

			cc.loader.load({url: atlas, type: 'txt'}, (error, atlasJson) => {

				cc.loader.load({url: ske, type: 'txt'}, (error, dragonBonesJson) => {

					const atlas = new dragonBones.DragonBonesAtlasAsset();
					atlas.atlasJson = atlasJson;
					atlas.texture = texture;

					const asset = new dragonBones.DragonBonesAsset();
					asset.dragonBonesJson = dragonBonesJson;

					dragonDisplay.dragonAtlasAsset = atlas;
					dragonDisplay.dragonAsset = asset;


					let json = JSON.parse(asset.dragonBonesJson);
					let armatures = json["armature"];
					let armatureNames = [];
					for (let i = 0; i < armatures.length; i++) {
						armatureNames.push(armatures[i].name);
					}
					// console.log('armatureNames: ', armatureNames);

					let animationNames = [];

					if (armatureNames.length > 0) {
						let defaultArmatureName = armatureNames[0];
						dragonDisplay.armatureName = defaultArmatureName;
						// let animationNames = dragonDisplay.getAnimationNames(defaultArmatureName);
						let defaultArmature = armatures[0];
						let animations = defaultArmature.animation;
						for (let i = 0; i < animations.length; i++) {
							animationNames.push(animations[i].name);
						}

						// rectNode.addComponent(cc.Button);
						// rectNode.on('click', () => {
						// 	if (rectNode.isClicked) {
						// 		// return;
						// 	}
						// 	rectNode.isClicked = true;
						// 	console.log('clicked');

						// 	if (rectNode.audioClip) {
						// 		cc.audioEngine.stopAllEffects();
						// 		cc.director.emit('STOP_ALL_AUDIO')
						// 		cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
						// 	}

						// 	if (animationNames.length > 0) {
						// 		dragonDisplay.playAnimation(animationNames[0], 1);
						// 	}
						// });
					}


					// animaNode.x = rectNode.x + rectNode.width / 2;
					// animaNode.y = rectNode.y + rectNode.height / 2;

					// const sx = rectNode.width / animaNode.width;
					// const sy = rectNode.height / animaNode.height;
					// const scale = Math.min(sx, sy);
					// animaNode.scale = scale;
					


			


					animaNode.y += rectNode.height / 2;
					animaNode.x += rectNode.width / 2;

					animaNode.scaleX = rectNode.width / animaNode.width;
					animaNode.scaleY = rectNode.height / animaNode.height;
		
					const opArr = actionData.changeOption	
					const tweenArr = [];
			
					for (let i = 0; i < opArr.length; i++ ) {
			
						const opData = opArr[i];
						console.log('opData: ~~~ ', opData);
		
						if (opData[0] == 'opacity') {
							animaNode.opacity = Number( opData[1] / 100 * 255 ) + 0.1;
							console.log(animaNode.opacity);
							tweenArr.push({item: animaNode , option: `{"${opData[0]}" : ${opData[2] / 100 * 255}}`, optionName: opData[2] == null ? '' : opData[0]},)
			
						}  else {
							// animaNode[opData[0]] = Number(opData[1]);
							// tweenArr.push({item: animaNode, option: `{"${opData[0]}" : ${opData[2]}}`, optionName: opData[2] == null ? '' : opData[0]})
						}
		
			
						if (actionData.audio_url) {
							cc.assetManager.loadRemote(actionData.audio_url, (err, audioClip) => {
								rectNode.audioClip = audioClip;
							});
						}
						
		
						rectNode.addComponent(cc.Button);
						rectNode.on('click', () => {
		
							if (rectNode.audioClip) {
								cc.audioEngine.stopAllEffects();
								cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
							}
				
							if (rectNode.isClicked) {
								// return;
							}
							rectNode.isClicked = true;
		
							for (let j=0; j<tweenArr.length; j++) {
								const tweenData = tweenArr[j];
				
								console.log('tweenData: ', tweenData);

								if (tweenData.optionName) {

									cc.tween(tweenData.item)
										.to(actionData.changeTime,  JSON.parse(tweenData.option))
										.start();

								}

							}
						
							if (animationNames.length > 0) {
								dragonDisplay.playAnimation(animationNames[0], 1);
							}
				
						});
					}
		
					
				});
			});
		});

	},
	



	setOneAnimaSmall(data) {


		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY;

		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

		rectNode.anchorX = rectNode.anchorY = 0;


		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();




		const animaNode = new cc.Node();
		animaNode.name = 'anima_' + data.index;
		this.hotZoneBg.addChild(animaNode);

		animaNode.data = data;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				animaNode.audioClip = audioClip;
			});
		}


		const dragonDisplay = animaNode.addComponent(dragonBones.ArmatureDisplay);
		if (!data.texPngData) {
			return
		}
		
		const image = data.texPngData.url//"http://staging-teach.cdn.ireadabc.com/5a0c5af3e952acd0ac83a6e5c6f03ff1.png";
		const ske = data.skeJsonData.url//"http://staging-teach.cdn.ireadabc.com/bd825dcceea298d1146be8067ae3d17f.json";
		const atlas = data.texJsonData.url//"http://staging-teach.cdn.ireadabc.com/246f8991b729fa3e5a7f4802de828efa.json";
		cc.loader.load(image, (error, texture) => {

			cc.loader.load({url: atlas, type: 'txt'}, (error, atlasJson) => {

				cc.loader.load({url: ske, type: 'txt'}, (error, dragonBonesJson) => {

					const atlas = new dragonBones.DragonBonesAtlasAsset();
					atlas.atlasJson = atlasJson;
					atlas.texture = texture;

					const asset = new dragonBones.DragonBonesAsset();
					asset.dragonBonesJson = dragonBonesJson;

					dragonDisplay.dragonAtlasAsset = atlas;
					dragonDisplay.dragonAsset = asset;

					

					let json = JSON.parse(asset.dragonBonesJson);
					let armatures = json["armature"];
					// console.log('armatures: ', armatures);
					let armatureNames = [];
					for (let i = 0; i < armatures.length; i++) {
						armatureNames.push(armatures[i].name);
					}
					// console.log('armatureNames: ', armatureNames);
					if (armatureNames.length > 0) {
						let defaultArmatureName = armatureNames[0];
						dragonDisplay.armatureName = defaultArmatureName;
						// let animationNames = dragonDisplay.getAnimationNames(defaultArmatureName);
						let defaultArmature = armatures[0];
						let animations = defaultArmature.animation;
						let animationNames = [];
						for (let i = 0; i < animations.length; i++) {
							animationNames.push(animations[i].name);
						}

						animaNode.animationNames = animationNames;

						rectNode.addComponent(cc.Button);
						rectNode.on('click', () => {
							if (rectNode.isClicked) {
								// return;
							}
							rectNode.isClicked = true;
							console.log('clicked');

							if (animaNode.audioClip) {
								cc.audioEngine.stopAllEffects();
								cc.director.emit('STOP_ALL_AUDIO')
								cc.audioEngine.playEffect(animaNode.audioClip, false, 0.8);
							}

							if (animationNames.length > 0) {
								dragonDisplay.playAnimation(animationNames[0], 1);
							}
						});

						// animaNode.playRightAnim = () => {
						// 	animaNode.active = true;
						// 	if (animationNames.length > 0) {
						// 		dragonDisplay.playAnimation(animationNames[0], 1);
						// 	}
						// }
						animaNode.dragonDisplay = dragonDisplay;
						this.animaNodeArr.push(animaNode);
					}


					animaNode.x = rectNode.x + rectNode.width / 2;
					animaNode.y = rectNode.y + rectNode.height / 2;

					const sx = rectNode.width / animaNode.width;
					const sy = rectNode.height / animaNode.height;
					const scale = Math.min(sx, sy);
					// animaNode.scale = scale;

					animaNode.active = false;
					animaNode.hitCount = 0;

					const animaNodeH = 426
					animaNode.scale = rectNode.height / animaNodeH;
					// animaNode.opacity = 20;
			
					
				});
			});
		});

	},

	playRightAnim(animaNode) {
		const animationNames = animaNode.animationNames;
		const dragonDisplay = animaNode.dragonDisplay;

		animaNode.active = true;
		// animaNode.opacity = 255;
		if (dragonDisplay && animationNames && animationNames.length > 0) {
			dragonDisplay.playAnimation(animationNames[0], 1);
		}
	},

	setOneHotZonePic(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const picNode = new cc.Node();
		picNode.name= 'pic' + data.index;
		picNode.data = data;
		this.hotZoneBg.addChild(picNode);

		this.picNodeArr.push(picNode);
		picNode.hitCount = 0;

		cc.loader.load({url: data.pic_url}, (err, img) => {

			const spr = picNode.addComponent(cc.Sprite);
			spr.spriteFrame = new cc.SpriteFrame(img)

			const scale = rate / this.hotZoneBg.scaleY;

			picNode.width = data.rect.width * scale;
			picNode.height = data.rect.height * scale;
			picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
			picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

			picNode.x += picNode.width / 2 * picNode.scaleX;
			picNode.y += picNode.height / 2 * picNode.scaleX;


			getSprNodeByUrl(data.answer_pic_url, (spr) => {

				const sprNode = spr.node;
				sprNode.active = false;
				picNode.addChild(sprNode);
				picNode.answerPic = sprNode;

				picNode.isLoadEnd = true;
				this.checkStart();
			})

			// picNode.anchorX = picNode.anchorY = 0;

			// if (data.audio_url) {
			// 	this.addPicAudio(picNode);
			// }

			// this.addDragPoint(picNode, data)

		});

	},

	addDragPoint(picNode, data) {


		picNode.baseX = picNode.x;
		picNode.baseY = picNode.y;

		const realRate = this.hotZoneBg.width / this.data.bgItem.rect.width;
		picNode.targetPx = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
		picNode.targetPy = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;


		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				picNode.audioClip = audioClip;
			});
		}


		picNode.on(cc.Node.EventType.TOUCH_START, () => {
			if (picNode.isDragEnd) {
				if (picNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(picNode.audioClip, false, 0.8);
				}
				return;
			}
			this._curShowItem = picNode;

			// picNode.x = -this.hotZoneBg.width / 2 + ( data.dragDot.x - this.data.bgItem.rect.x ) * realRate;
			// picNode.y = this.hotZoneBg.height / 2 - (data.dragDot.y - this.data.bgItem.rect.y) * realRate;

		})
	},

	setOneAudioBtn(data) {
		this.setOnePic(data);
	},


	setOnePic(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const picNode = new cc.Node();
		picNode.name= 'pic' + data.index;
		picNode.data = data;
		this.hotZoneBg.addChild(picNode);

		const sprNode = getSprNode("btn_sound");
		sprNode.anchorX = 0;
		sprNode.anchorY = 0;

		// getSprNodeByUrl(data.pic_url, (spr) => {

		// 	const sprNode = spr.node;
			picNode.addChild(sprNode);

			const scale = rate / this.hotZoneBg.scaleY;

			picNode.width = sprNode.width = data.rect.width * scale;
			picNode.height = sprNode.height = data.rect.height * scale;
			picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
			picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;


		// })


		// cc.loader.load({url: data.pic_url}, (err, img) => {

		// 	const spr = picNode.addComponent(cc.Sprite);
		// 	spr.spriteFrame = new cc.SpriteFrame(img)

		// 	const scale = rate / this.hotZoneBg.scaleY;

		// 	picNode.width = data.rect.width * scale;
		// 	picNode.height = data.rect.height * scale;
		// 	picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		// 	picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

		// 	picNode.anchorX = picNode.anchorY = 0;

		// 	// if (data.audio_url) {
		// 	// 	this.addPicAudio(picNode);
		// 	// }

		// });

		// picNode.on('touchstart', () => {
		// 	this.show
		// })

	},

	setOneRect(data) {
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		const rectNode = new cc.Node();
		rectNode.name = 'rect' + data.index;
		this.hotZoneBg.addChild(rectNode);


		const ctx = rectNode.addComponent(cc.Graphics);
		// 红色矩形
		ctx.lineWidth = 4;
		ctx.strokeColor = cc.Color.BLACK;
		ctx.fillColor = cc.Color.WHITE.setA(100);

		const scale = rate / this.hotZoneBg.scaleY;
		// console.log('scale: ', scale);
		// console.log('scale2: ', scale / data.mapScale);


		rectNode.width = data.rect.width * scale;
		rectNode.height = data.rect.height * scale;
		rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;
		// rectNode.scale = 1 / data.mapScale;

		rectNode.anchorX = rectNode.anchorY = 0;


		if (this.data.bgItem.isShowDebugLine) {
			ctx.rect(0, 0, rectNode.width, rectNode.height);
		}
		ctx.stroke();
		ctx.fill();

		// console.log('```data: ', data)

		this.dragEndRectArr.push(rectNode);

		if (data.audio_url) {
			cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
				rectNode.audioClip = audioClip;
			});
		}

		// rectNode.addComponent(cc.Button);
		// rectNode.on('click', () => {
		// 	if (rectNode.isClicked) {
		// 		// return;
		// 	}
		// 	rectNode.isClicked = true;
		// 	console.log('clicked');

		// 	if (rectNode.audioClip) {
		// 		cc.audioEngine.stopAllEffects();
		// 		cc.audioEngine.playEffect(rectNode.audioClip, false, 0.8);
		// 	}
		// });


	},

	addPicAudio(picNode) {
		const data = picNode.data;
		
		cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
			picNode.audioClip = audioClip;
		});

		picNode.addComponent(cc.Button);
		picNode.on('click', () => {
				if (picNode.audioClip) {
					cc.audioEngine.stopAllEffects();
					cc.audioEngine.playEffect(picNode.audioClip, false, 0.8);
				}
		});
	},


	initListener() {

		const canvas = cc.find('Canvas');
		
		let downFlag = false;

		const touchMove = (e) => {
			this.canvasTouchMove(e);
			if (canvas.hasEventListener(cc.Node.EventType.MOUSE_MOVE)) {
				canvas.off(cc.Node.EventType.MOUSE_MOVE, mouseMove)
			}
		}

		const mouseMove = (e) => {
			if (!downFlag) {
				return;
			}
			this.canvasTouchMove(e);
			if (canvas.hasEventListener(cc.Node.EventType.TOUCH_MOVE)) {
				canvas.off(cc.Node.EventType.TOUCH_MOVE, touchMove)
				this.removeHtmlCanvasListener('touchmove');
			}
		}

		const touchEnd = (e) => {
		
			downFlag = false;
			this.canvasTouchEnd(e);

			if (canvas.hasEventListener(cc.Node.EventType.MOUSE_UP)) {
				canvas.off(cc.Node.EventType.MOUSE_UP, mouseUp)
			}
			if (canvas.hasEventListener(cc.Node.EventType.MOUSE_LEAVE)) {
				canvas.off(cc.Node.EventType.MOUSE_LEAVE, mouseUp)
			}
			this.removeHtmlTouchEnd();
		}

		const mouseUp = (e) => {
	
			downFlag = false;

			this.canvasTouchEnd(e);

			if (canvas.hasEventListener(cc.Node.EventType.TOUCH_END)) {
				canvas.off(cc.Node.EventType.TOUCH_END, touchEnd)
			}
			if (canvas.hasEventListener(cc.Node.EventType.TOUCH_CANCEL)) {
				canvas.off(cc.Node.EventType.TOUCH_CANCEL, touchEnd)
			}
		}
		

		canvas.on(cc.Node.EventType.TOUCH_MOVE, touchMove)
		canvas.on(cc.Node.EventType.MOUSE_MOVE, mouseMove)

		canvas.on(cc.Node.EventType.TOUCH_END, touchEnd)
		canvas.on(cc.Node.EventType.TOUCH_CANCEL, touchEnd)
		canvas.on(cc.Node.EventType.MOUSE_UP, mouseUp)

	},

	removeHtmlCanvasListener(type) {
		const canvasHtml = document.querySelector('canvas');
		canvasHtml.addEventListener(type, (e) => {})
	},	
	removeHtmlTouchEnd() {
		const canvasHtml = document.querySelector('canvas');
		canvasHtml.removeEventListener('touchend', this.htmlCanvasTouchendFunc, this);
	},

	canvasTouchMove(e) {

		if (!this._curShowItem) {
			return;
		}
		const pos = e.getLocation();
		this._curShowItem.x = pos.x - e.currentTarget.width / 2;
		this._curShowItem.y = pos.y - e.currentTarget.height / 2;

		// console.log('pos: ', pos.x);
	},

	canvasTouchEnd(e) {

		if (!this._curShowItem) {
			return;
		}
		this.checkOnDragEndRect();
		this._curShowItem = null;
	},



	checkOnDragEndRect() {

		console.log('emptyGroupArr: ',  this.emptyGroupArr);
		for (let i = 0; i < this.dragEndRectArr.length; i++) {

			const rect = this.dragEndRectArr[i];

			const worldPos = this._curShowItem.parent.convertToWorldSpaceAR(cc.v2(this._curShowItem.x, this._curShowItem.y));
			const worldRect = rect.getBoundingBoxToWorld();
			if (worldRect.contains(worldPos)) {
			
				console.log('rect in ')
				this.checkIsDragEndTarget(rect);
				// removeItemFromArr(this.emptyGroupArr, letterGroup);
				// this.showLetterSuccess(letterGroup);
				// this.checkGroupEnd();
				return;
			}
			
		}

		this.itemBack();
	},

	itemBack() {

		cc.audioEngine.playEffect(this.wrongClip, false, 0.8);

		cc.tween(this._curShowItem)
			.to(0.5, {x: this._curShowItem.baseX, y: this._curShowItem.baseY}, {easing: "elasticOut"})
			.start();
	},

	checkIsDragEndTarget(rect) {

		const worldPos = this._curShowItem.parent.convertToWorldSpaceAR(cc.v2(this._curShowItem.targetPx, this._curShowItem.targetPy));
		const worldRect = rect.getBoundingBoxToWorld();
		if (worldRect.contains(worldPos)) {
			this._curShowItem.x = this._curShowItem.targetPx;
			this._curShowItem.y = this._curShowItem.targetPy;
			this._curShowItem.isDragEnd = true;


			cc.audioEngine.playEffect(this.rightClip, false, 0.8);

		} else {
			this.itemBack();
		}
	},



});
