import {
  Component,
  EventEmitter,
  Input,
  OnDestroy,
  OnChanges,
  OnInit,
  Output,
  ApplicationRef,
  ChangeDetectorRef,
  AfterViewInit
} from '@angular/core';
import { JsonPipe } from '@angular/common';
import { removeItemFromArr } from '../play/Unit';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy, AfterViewInit {

  // 储存数据用
  saveKey = "OP_08_360";
  // 储存对象
  item;
  // 公式键盘
  fboard = null;

  partArr = [
    {
      name: '连线部分'
    },
    {
      name: '书写部分'
    }
  ]

  customTypeGroupArr = [
    {
      name: '连接点',
      rect: true,
      // isShowPos: true,
      isCopy: true,
      isShowPos: true,
      centerDot: true,

      // label: '答案',
    },

    {
      name: '书写区',
      rect: true,
      isShowPos: true,
      isCopy: true,
      anima: true,
    },

    {
      name: '画圈区',
      rect: true,
      isShowPos: true,
      isCopy: true,
      anima: true,
    },
    
    {
      name: '音频区',
      rect: true,
      audio: true,
      isCopy: true,
    },




    // {
    //   name: '图片',
    //   // audio: true,
    //   pic: true,
    //   // rect: true,
    //   isShowPos: true,
    //   isCopy: true,
    //   // isShowPos: true,

    //   // label: '答案',
    // },
  ];

  customTypeGroupArr2 = [
    {
      name: '连线Point',
      rect: true,
      isCopy: true,
      isShowPos: true,
      centerDot: true,
      // checkbox: {
      //   title: '答案',
      //   list: [
      //     {label: '正确', key: 'isRight'},
      //   ]
      // },
    },
    {
      name: '书写Rect',
      rect: true,
      label: '答案',
      isCopy: true,
      isShowPos: true,
    },

    {
      name: 'part区域',
      rect: true,
    },

    {
      name: '参照物1(标题)',
      rect: true,
      label: '参照文本',
    },

    {
      name: '参照物2(标题)',
      rect: true,  
      label: '参照文本',
    },

    {
      name: '参照物2(字母)',
      rect: true,  
      label: '参照文本',
    },

    {
      name: '书写区(新)',
      rect: true,  
      label: '字母',
      isCopy: true,
    },


    {
      name: '画圈区域',
      rect: true,  
      isCopy: true,
    },
  ]

  audioTypeArr = [
    {key: 'begin', info: '开始音频'},
    {key: 'tip', info: '待机音频'},
    {key: 'end', info: '结束音频'},
    // {key: 'finish_wrong', info: '结束有错音频'},
    // {key: 'error_link', info: '连线错误音频'},
    // {key: 'error_write', info: '手写错误音频'},

  ]


  

  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {

  }

  createShell() {
    this.item.wordList.push({
      word: '',
      audio: '',
      backWord: '',
      backWordAudio: '',
    });
    this.save();
  }

  removeShell(idx) {
    this.item.wordList.splice(idx, 1);
    this.save();
  }

  ngOnInit() {

    this.item = {};

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }
      

      // console.log('this.item: ', this.item);
      // this.item = this.item = {"bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/7d6b46d6720b392580889d0dd04b6420.png","rect":{"x":257.28,"y":0,"width":1197.43,"height":649}},"hotZoneItemArr":[{"id":"1646272837425","index":0,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":590,"posY":176.5,"rect":{"x":303.22,"y":147,"width":59,"height":59},"pointItem":1,"linkItem":2},{"id":"1646272855605","index":1,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":879.0040594146337,"posY":250.5006241219465,"rect":{"x":592.22,"y":221,"width":59,"height":59},"pointItem":2,"linkItem":1},{"id":"1646272905559","index":2,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":589.0050813480192,"posY":358.5008857934708,"rect":{"x":302.22,"y":329,"width":59,"height":59},"pointItem":3,"linkItem":4},{"id":"1646272910295","index":3,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":878.0040558785321,"posY":462.50126769245213,"rect":{"x":591.22,"y":433,"width":59,"height":59},"pointItem":4,"linkItem":3},{"id":"1646273022334","index":4,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":588.0050778119175,"posY":539.5016354470268,"rect":{"x":301.22,"y":510,"width":59,"height":59},"pointItem":5,"linkItem":6},{"id":"1646273029597","index":5,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":1034.0040523424304,"posY":463.5019077268562,"rect":{"x":747.23,"y":434,"width":59,"height":59},"pointItem":6,"linkItem":5},{"id":"1646273043323","index":6,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":1169.0056294437795,"posY":175.50163898312854,"rect":{"x":882.24,"y":146,"width":59,"height":59},"pointItem":7,"linkItem":8},{"id":"1646273051443","index":7,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":1034.0161068528673,"posY":252.50062058584479,"rect":{"x":747.25,"y":223,"width":59,"height":59},"pointItem":8,"linkItem":7},{"id":"1646273059048","index":8,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":1169.0256295145016,"posY":359.50089286567413,"rect":{"x":882.26,"y":330,"width":59,"height":59},"pointItem":9,"linkItem":10},{"id":"1646273067487","index":9,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":719.0361069235894,"posY":253.50127122855383,"rect":{"x":432.26,"y":224,"width":59,"height":59},"pointItem":10,"linkItem":9},{"id":"1646273076602","index":10,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":1172.0445157131944,"posY":539.5008964017758,"rect":{"x":885.27,"y":510,"width":59,"height":59},"pointItem":11,"linkItem":12},{"id":"1646273087987","index":11,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":324.5},"gIdx":"0","posX":720.0461175672554,"posY":"462","rect":{"x":433.27,"y":432.5,"width":59,"height":59},"pointItem":12,"linkItem":11},{"id":"1646273106333","index":12,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/c788cc41fc9f3e191ee149382c7c3f8c.json","name":"NewProject_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/57c3cc3ef7297912a0c065a5b59efabf.json","name":"NewProject_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/60969a6073044170d25a072de7469810.png","name":"NewProject_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"1","posX":484,"posY":176.5,"rect":{"x":122.72,"y":112,"width":208,"height":129},"rectItem":13},{"id":"1646273826736","index":13,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/c788cc41fc9f3e191ee149382c7c3f8c.json","name":"NewProject_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/57c3cc3ef7297912a0c065a5b59efabf.json","name":"NewProject_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/60969a6073044170d25a072de7469810.png","name":"NewProject_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"1","posX":"484","posY":"359","rect":{"x":122.72,"y":294.5,"width":208,"height":129},"rectItem":14},{"id":"1646273889510","index":14,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/c788cc41fc9f3e191ee149382c7c3f8c.json","name":"NewProject_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/57c3cc3ef7297912a0c065a5b59efabf.json","name":"NewProject_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/60969a6073044170d25a072de7469810.png","name":"NewProject_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"1","posX":"484","posY":"542","rect":{"x":122.72,"y":477.5,"width":208,"height":129},"rectItem":15},{"id":"1646273970571","index":15,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/c788cc41fc9f3e191ee149382c7c3f8c.json","name":"NewProject_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/57c3cc3ef7297912a0c065a5b59efabf.json","name":"NewProject_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/60969a6073044170d25a072de7469810.png","name":"NewProject_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"1","posX":1281,"posY":"176.5","rect":{"x":919.72,"y":112,"width":208,"height":129},"rectItem":16},{"id":"1646274154020","index":16,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/c788cc41fc9f3e191ee149382c7c3f8c.json","name":"NewProject_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/57c3cc3ef7297912a0c065a5b59efabf.json","name":"NewProject_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/60969a6073044170d25a072de7469810.png","name":"NewProject_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"1","posX":1280.0065028608942,"posY":"359","rect":{"x":918.73,"y":294.5,"width":208,"height":129},"rectItem":17},{"id":"1646274185650","index":17,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/c788cc41fc9f3e191ee149382c7c3f8c.json","name":"NewProject_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/57c3cc3ef7297912a0c065a5b59efabf.json","name":"NewProject_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/60969a6073044170d25a072de7469810.png","name":"NewProject_tex.png"},"dragDot":{"x":856,"y":324.5},"gIdx":"1","posX":1280.0065028608942,"posY":"542","rect":{"x":918.73,"y":477.5,"width":208,"height":129},"rectItem":18}],"bgItem2":{"url":"http://staging-teach.cdn.ireadabc.com/c828fb2b6a660dd84e4adca8b4d9cfe1.png","rect":{"x":172.43,"y":0,"width":1367.14,"height":1769}},"hotZoneItemArr2":[{"id":"1646274300617","index":0,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":550,"posY":781.5,"rect":{"x":345.57,"y":749.5,"width":64,"height":64}},{"id":"1646274313449","index":1,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":880.0007601601027,"posY":865.4980586107176,"rect":{"x":675.57,"y":833.5,"width":64,"height":64}},{"id":"1646274323188","index":2,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":552.9999403795997,"posY":988.4978499393169,"rect":{"x":348.57,"y":956.5,"width":64,"height":64}},{"id":"1646274330494","index":3,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":879.0007527075528,"posY":1107.4975443847657,"rect":{"x":674.57,"y":1075.5,"width":64,"height":64}},{"id":"1646274371581","index":4,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":550.9999428637831,"posY":1196.4972487669481,"rect":{"x":346.57,"y":1164.5,"width":64,"height":64}},{"id":"1646274378707","index":5,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":1059.0007576759194,"posY":1108.4970276746305,"rect":{"x":854.57,"y":1076.5,"width":64,"height":64}},{"id":"1646274400443","index":6,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":1213.9994957107815,"posY":782.4972462827648,"rect":{"x":1009.57,"y":750.5,"width":64,"height":64}},{"id":"1646274416591","index":7,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":1058.9991106623634,"posY":867.4980561265343,"rect":{"x":854.57,"y":835.5,"width":64,"height":64}},{"id":"1646274429496","index":8,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":1214.9994957107815,"posY":988.4978449709502,"rect":{"x":1010.57,"y":956.5,"width":64,"height":64}},{"id":"1646274438428","index":9,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":699.99910817818,"posY":867.4975443847657,"rect":{"x":495.57,"y":835.5,"width":64,"height":64}},{"id":"1646274447497","index":10,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":1212.0003875326015,"posY":1196.4978449709502,"rect":{"x":1007.57,"y":1164.5,"width":64,"height":64}},{"id":"1646274457862","index":11,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"0","posX":699.9991156307301,"posY":1107.4970276746305,"rect":{"x":495.57,"y":1075.5,"width":64,"height":64}},{"id":"1646274486862","index":12,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"1","labelText":"Hh","posX":430,"posY":781.5,"rect":{"x":136.57,"y":710,"width":242,"height":143}},{"id":"1646274518475","index":13,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"1","labelText":"Gg","posX":"430","posY":"991","rect":{"x":136.57,"y":919.5,"width":242,"height":143}},{"id":"1646274565261","index":14,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"1","labelText":"Hh","posX":"430","posY":"1201","rect":{"x":136.57,"y":1129.5,"width":242,"height":143}},{"id":"1646274607872","index":15,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"1","labelText":"Ee","posX":1341,"posY":"781","rect":{"x":1047.57,"y":709.5,"width":242,"height":143}},{"id":"1646274739058","index":16,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"1","labelText":"Hh","posX":1341,"posY":"991","rect":{"x":1047.57,"y":919.5,"width":242,"height":143}},{"id":"1646274744902","index":17,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"1","labelText":"Hh","posX":1341,"posY":"1201","rect":{"x":1047.57,"y":1129.5,"width":242,"height":143}},{"id":"1646274947024","index":18,"itemType":"rect","fontScale":1.3375,"imgScale":1,"imgSizeW":0,"imgSizeH":0,"mapScale":1.3375,"dragDot":{"x":856,"y":884.5000000000001},"gIdx":"2","posX":857,"posY":958.5,"rect":{"x":17.57,"y":595,"width":1334,"height":727}}],"firstPart":"0","isDebug":true,"page_id":"27","book_id":"opw1","part_name":"d","begin_audio_url":"http://staging-teach.cdn.ireadabc.com/0e67aa701df18cbb5581ffb81ffa7836.mp3","change_stage_audio_url":"http://staging-teach.cdn.ireadabc.com/4c0379bc0f3bd0722874b2e11fb35336.mp3","stage_1_audio_url":"http://staging-teach.cdn.ireadabc.com/495324991838775e49e3ca6593d432c9.mp3","stage_2_audio_url":"http://staging-teach.cdn.ireadabc.com/17cc0e2a383e4632147dc495a1397915.mp3","finish_right_audio_url":"http://staging-teach.cdn.ireadabc.com/fe226bc303f03ea994cb9a93d1620284.mp3","finish_wrong_audio_url":"http://staging-teach.cdn.ireadabc.com/b985b71cd2f3c2d31e45992e4ae69d7f.mp3"}

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);
  }
  ngAfterViewInit() {



  }
  ngOnChanges() {
  }

  ngOnDestroy() {
  }


  init() {

 

    if (this.item.helpTime == null) {
      this.item.helpTime = 10;
    }

  }


  addForeground() {
    if (!this.item.foregroundArr) {
      this.item.foregroundArr = [];
    }

    this.item.foregroundArr.push({})
  }


  saveLinkItem(hzItem, linkItemId) {
    hzItem.linkItem = linkItemId;
    this.save();
  }

  savePointItem(hzItem, pointItemId) {
    hzItem.pointItem = pointItemId;
    this.save();
  }

  saveRectItem(hzItem, rectItemId) {
    hzItem.rectItem = rectItemId;
    this.save();
  }
  saveRectNew(hzItem, rectItemId) {
    hzItem.rectNew = rectItemId;
    this.save();
  }

  saveCircleItem(hzItem, rectItemId) {
    hzItem.circleItem = rectItemId;
    this.save();
  }
  


  addWrongAnswer() {

    console.log(' in addWrongAnswer');

    this.item.choiceQuesArr.push({
      optionArr: [
        {id: 'A'},
        {id: 'B'},
        {id: 'C'},
        {id: 'D'},
      ]
    })

    this.save();
  }

  deleteWrongAnswer(choiceQues) {
    removeItemFromArr( this.item.choiceQuesArr, choiceQues );
    this.save();
  }




  onSaveCustomAction(e) {
    console.log('e:', e);
    this.item.customAction = e;
    this.save();
  }


  saveHotZone(group, e) {
    console.log('e: ', e);
    const {bgItem, hotZoneItemArr} = e;

    group.bgItem = bgItem;
    group.hotZoneItemArr = hotZoneItemArr;

    this.save();
  }

  saveHotZone2(group, e) {
    console.log('e: ', e);
    const {bgItem, hotZoneItemArr} = e;

    group.bgItem2 = bgItem;
    group.hotZoneItemArr2 = hotZoneItemArr;


    this.save();
  }


  onRadioChange(e, item) {
    item.firstPart = e;
    this.save();
  }


  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key, item=null) {
    if (!item) {
      item = this.item;
    }

    item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key, item=null) {
    if (item == null) {
      item = this.item;
    }
    item[key] = e.url;
    this.save();
  }

  onWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].audio = e.url;
    this.save();
  }

  onBackWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].backWordAudio = e.url;
    this.save();
  }

  onVideoUploadSuccess(e, item=null) {

    console.log(' in onVideoUploadSuccess')
    if (!item) {
      item = this.item;
    }
    item.video_url = e.url;
    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);

    this.refresh();
    console.log('this.item = ' + JSON.stringify(this.item));
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}
