import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "OP_18";
  // 储存对象
  item;

  animArr = [
    {key: 'letter_big_0', title: '大写彩色动画'},
    {key: 'letter_big_1', title: '大写黑色动画'},
    {key: 'letter_small_0', title: '小写彩色动画'},
    {key: 'letter_small_1', title: '小写黑色动画'},
  ]

  customTypeGroupArr2 = [
    {
      name: '连线Point',
      rect: true,
      isCopy: true,
      isShowPos: true,
      centerDot: true,
      // checkbox: {
      //   title: '答案',
      //   list: [
      //     {label: '正确', key: 'isRight'},
      //   ]
      // },
    },
    {
      name: '书写Rect',
      rect: true,
      label: '答案',
      isCopy: true,
      isShowPos: true,
    },

    {
      name: 'part区域',
      rect: true,
    },

    {
      name: '参照物1(标题)',
      rect: true,
      label: '参照文本',
    },

    {
      name: '参照物2(标题)',
      rect: true,  
      label: '参照文本',
    },

    {
      name: '参照物2(字母)',
      rect: true,  
      label: '参照文本',
    },
  ]

  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {

  }

  createShell() {
    this.item.wordList.push({
      word: '',
      audio: '',
      backWord: '',
      backWordAudio: '',
    });
    this.save();
  }

  removeShell(idx) {
    this.item.wordList.splice(idx, 1);
    this.save();
  }

  ngOnInit() {

    this.item = {};

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);
  }

  ngOnChanges() {
  }

  ngOnDestroy() {
  }

  init() {

    if (!this.item.animArr) {
      this.item.animArr = this.animArr;
    }
  }

  saveHotZone2(group, e) {
    console.log('e: ', e);
    const {bgItem, hotZoneItemArr} = e;

    group.bgItem2 = bgItem;
    group.hotZoneItemArr2 = hotZoneItemArr;

    this.save();
  }


  saveAnimArr(data, anim) {
    console.log('data: ', data);
    console.log('anim: ', anim);

    anim["skeJsonData"] = data.skeJsonData;
    anim["texJsonData"] = data.texJsonData; 
    anim["texPngData"] = data.texPngData;   
    this.save();
  }


  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key) {

    this.item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key) {
    this.item[key] = e.url;
    this.save();
  }

  onWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].audio = e.url;
    this.save();
  }

  onBackWordAudioUploadSuccess(e, idx) {
    this.item.wordList[idx].backWordAudio = e.url;
    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);

    this.refresh();
    console.log('this.item = ' + JSON.stringify(this.item));
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}