import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef} from '@angular/core';
import defauleFormData from '../../assets/play/default/formData/defaultData.js'

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})


export class FormComponent implements OnInit, OnChanges, OnDestroy {

  _item: any;
  KEY = 'DataKey_PU03';
  checkOptionsOne = []

  set item(item) {
    this._item = item;
  }
  get item() {
    return this._item;
  }
  contentObj =  {
    "version": "1.0",
    key: "DataKey_PU03",
    mainQuestion:{
      type: "Text",
      text: "",
      image_url: "",
      shortAudio_url: "",
      longAudio_url: ""
    },
    textUp:[],
    textDown:[]
  }

  @Output()
  update = new EventEmitter();
  constructor(private appRef: ApplicationRef) {

  }

  ngOnInit() {
    this.item = {};
    this.item.contentObj = {};
    const getData = (<any> window).courseware.getData;
    getData((data) => {
      console.log("读取数据", data)
      if (data) {
        this.item = data;
      } else {
        this.item = {};
      }
      if ( !this.item.contentObj ) {
        this.item.contentObj = {};
      }
      this.init();
      this.refresh();
      // this.save()
    }, this.KEY);
  }
  ngOnChanges() {

  }

  ngOnDestroy() {
  }

  init() {
    if (Object.keys(this.item.contentObj).length != 0 && this.item.contentObj.version && this.item.contentObj.version==defauleFormData.version) {
      console.log("读取数据", this.item.contentObj)
      this.contentObj = this.item.contentObj;
    } else {
      this.contentObj = defauleFormData;
      // console.log("使用默认数据", this.contentObj)
      this.item.contentObj = this.contentObj;
    }
    this.updateCheckbox()
  }

  cardItemData(){
    return {audio_url:"", type:"text", text:"", image_url:""}
  }

  cardChoiceData(){
    return { isText: true, text: "", image_url: "" }
  }


  initData() {

  }

  handleMoveItemUp(items, index){
    if(index!=0){
      items[index] = items.splice(index-1, 1, items[index])[0];
    }else{
      items.push(items.shift());
    }
    this.save()
  }

  handleMoveItemDown(items, index){
    if(index!=items.length-1){
      items[index] = items.splice(index+1, 1, items[index])[0];
    }else{
      items.unshift( items.splice(index,1)[0]);
    }
    this.save()
  }

  deleteItem(item, index){
    item.splice(index,1)
    this.updateCheckbox()
    this.save()
  }

  addItem(item, type) { 
    let newItem = null
    switch(type){
      case "card": newItem = {text:"", lineTo: []}
      default: newItem = {text:"", lineTo: []}
    }
    item.push(newItem);
    this.updateCheckbox()
    this.saveItem();
  }

  onImageUploadSuccessByItem(e, item, key) {
    item[key] = e.url
    this.save(); 
  }

 
  onAudioUploadSuccessByItem(e, item, key) { 
    item[key] = e.url
    this.save();
  }


  saveItem() {
    this.save();
  }

  save() {
    this.item.contentObj.textUp.forEach((item, index) => {
      let newLineTo = []
      item.checkOptions.forEach( option=> {
        if(option.checked){
          newLineTo.push(option.value)
        }
      });
      item.lineTo = JSON.parse(JSON.stringify(newLineTo))
    });

    (<any> window).courseware.setData(this.item, null, this.KEY);
    this.refresh();
    console.log("保存", this.item)
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

  updateCheckbox(){
    let check = []

    this.item.contentObj.textDown.forEach((item, index) => {
      check.push({label:index+1, value:index, checked:false})
    });

    let length = check.length
    this.item.contentObj.textUp.forEach((item, index) => {
      let _check = JSON.parse(JSON.stringify(check))
      item.lineTo.forEach(option=> {
        if(option<length){
          _check[Number(option)].checked = true
        }
      });
      item.checkOptions = _check
    });
  }
}

