import {ApplicationRef, Component, EventEmitter, Input, OnChanges, OnDestroy, Output} from '@angular/core';
import { NzMessageService, UploadXHRArgs, UploadFile } from 'ng-zorro-antd';


@Component({
  selector: 'app-custom-action',
  templateUrl: './custom-action.component.html',
  styleUrls: ['./custom-action.component.scss']
})
export class CustomActionComponent implements OnDestroy, OnChanges {
  uploading = false;
  progress = 0;
  @Input()
  btnName = '配置变化状态';

  @Input()
  option = []

  @Input()
  item;

  @Input()
  type = 'text'
  

  @Output()
  save = new EventEmitter();

  @Output()
  refreshEmitter = new EventEmitter();

  uploadUrl;
  uploadData;

  panelVisible = false;
  pasteData = '';



  constructor(private appRef: ApplicationRef, private nzMessageService: NzMessageService) {

    window['air'].getUploadCallback = (url, data) => {
      this.uploadUrl = url;
      this.uploadData = data;
    };

    const tmpId = setInterval(() => {
      console.log(' in setInterval')
      this.uploadUrl = (<any> window).courseware.uploadUrl();
      this.uploadData = (<any> window).courseware.uploadData();
      if (this.uploadUrl) {
        clearInterval(tmpId);
      }
    }, 500)

  }

  ngOnInit() {
    this.initItem();
  }

  ngOnChanges() {
 
  }

  initItem() {

    console.log('```this.item: ', this.item);
    
    if (!this.item) {
      this.item = {
        type: this.type,
        // skeJsonData: {},
        // texJsonData: {},
        // texPngData: {},


        // changeStart: [
        
        // ],
        // changeEnd: [
        
        // ],
        // changeTime: 0.3
      };

      if (this.option) {
        this.item.changeOption = JSON.parse(JSON.stringify(this.option));
      }
    }

    console.log('initItem', this.item);

  }

  setAnimaBtnClick() {
    this.panelVisible = true;
    this.refresh();
  }

  panelCancel() {
    this.panelVisible = false;
    this.refresh();
  }

  panelOk() {
    // this.sendItemDragonBoneData();
    this.panelVisible = false;
    this.refresh();
    this.save.emit(this.item);
  }

  saveText(t) {

  }

  radioChange(e) {
    this.item.type = e;
    console.log('e: ', e);
  }


  onItemImgUploadSuccess(e, item) {
    item.pic_url = e.url;
    this.refresh();
  }


  onItemAudioUploadSuccess(e, item) {
    item.audio_url = e.url;
    this.refresh();
  }

  saveAnima(e) {
    console.log("~ e: ", e);
  }

  copyChangeData() {

    console.log('this.item: ', this.item);

    const jsonData = {
      changeOption: this.item.changeOption,
      changeTime : this.item.changeTime
      // bgItem,
      // hotZoneItemArr,
      // isHasRect: this.isHasRect,
      // isHasPic: this.isHasPic,
      // isHasText: this.isHasText,
      // isHasAudio: this.isHasAudio,
      // isHasAnima: this.isHasAnima,
      // hotZoneFontObj: this.hotZoneFontObj,
      // defaultItemType: this.defaultItemType,
      // hotZoneImgSize: this.hotZoneImgSize,
    };


    const oInput = document.createElement('input');
    oInput.value = JSON.stringify(jsonData);
    document.body.appendChild(oInput);
    oInput.select(); // 选择对象
    document.execCommand('Copy'); // 执行浏览器复制命令

    document.body.removeChild(oInput);
    this.nzMessageService.success('复制成功');
    
  }

  importData() {
    if (!this.pasteData) {
      return;
    }


    try {
      const data = JSON.parse(this.pasteData);
      console.log('data:', data);
      const {
        changeOption,
        changeTime
      } = data;

      this.item.changeOption = changeOption;
      this.item.changeTime = changeTime;

      this.pasteData = '';
    } catch (e) {
      console.log('err: ', e);
      this.nzMessageService.error('导入失败');
    }
  }


  /**
   * 刷新 渲染页面
   */
  refresh() {

    // this.refreshEmitter.emit();
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }


  closePanel() {
    console.log(' in closePanel ');
    this.refresh();
  }



  ngOnDestroy() {
  }

}
