const tools = require("../script/tools");


cc.Class({
    extends: cc.Component,

    properties: {
        label: cc.Label,
        tipClip: cc.AudioClip
    },

    data: null,
    onLoad() {
        this._show = false
    },

    onEnable() {
        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this)
        cc.systemEvent.on('changeAnswerState', this.onChangeState, this)
    },

    onDisable() {
        this.node.off(cc.Node.EventType.TOUCH_START, this.onTouchStart, this)
        cc.systemEvent.off('changeAnswerState', this.onChangeState, this)
    },

    initWithData(data, scale) {
        let action = data['actionData_']
        if (!action) {
            this.node.active = false
            return
        } else {
            this.node.action = true
        }
        this.data = data
        let rect = this.data.rect
        this.node.x = (rect.x + rect.width / 2) * scale
        this.node.y = (-rect.y - rect.height / 2) * scale

        this.label.node.active = false
        let option = action.changeOption
        this.label.node.color = option[0][1] ? cc.color(option[0][1]) : cc.color(0, 0, 0)
        let num = Number(option[1][1]) * scale * data.fontScale
        this.label.fontSize = num
        this.label.lineHeight = num
        this.label.string = action.text ? action.text : ''
        this.node.width = rect.width * scale
        this.node.height = rect.height * scale
    },

    onTouchStart() {
        if (this._show) return
        this._show = true
        this.label.node.active = true
        cc.audioEngine.play(this.tipClip)
    },

    /** 改变答案显示状态 */
    onChangeState(show) {
        this.label.node.active = show
        this._show =show
    }
});
