const tools = require("./tools");

cc.Class({
	extends: cc.Component,

	properties: {
		picNode: {
			type: cc.Node,
			default: null
		},
		picTempNode: {
			type: cc.Node,
			default: null
		},
		leftNode: {
			type: cc.Node,
			default: null
		},
		rightNode: {
			type: cc.Node,
			default: null
		},
		checkNode: {
			type: cc.Node,
			default: null
		},
		bgAudioNode: cc.Node,
		btnClip: cc.AudioClip,
		tipClip: cc.AudioClip
	},

	// 生命周期 onLoad
	onLoad() {
		this.initSceneData();
		this.initSize();
	},

	_imageResList: null,
	_audioResList: null,
	_animaResList: null,
	initSceneData() {
		this._imageResList = [];
		this._audioResList = [];
		this._animaResList = [];
	},

	_designSize: null,  // 设计分辨率
	_frameSize: null,  // 屏幕分辨率
	_mapScaleMin: null,  // 场景中常用缩放（取大值）
	_mapScaleMax: null,  // 场景中常用缩放（取小值）
	_cocosScale: null,  // cocos 自缩放 （较少用到）
	initSize() {
		// 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
		let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
		let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
		let f = screen_size >= design_size
		cc.Canvas.instance.fitHeight = f
		cc.Canvas.instance.fitWidth = !f

		const frameSize = cc.view.getFrameSize();
		this._frameSize = frameSize;

		this._designSize = cc.view.getDesignResolutionSize();

		let sx = cc.winSize.width / frameSize.width;
		let sy = cc.winSize.height / frameSize.height;
		this._cocosScale = Math.min(sx, sy);

		sx = frameSize.width / this._designSize.width;
		sy = frameSize.height / this._designSize.height;
		this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
		this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;
	},


	// 生命周期 start
	start() {
		let getData = this.getData.bind(this);
		if (window && window.courseware) {
			getData = window.courseware.getData;
		}

		getData((data) => {
			console.log('data:', data);
			this.data = (data && data.length) ? data : this.getDefaultData();
			this.data = JSON.parse(JSON.stringify(this.data))
			this.preloadItem()
		})
		//init show
		this.picNode.opacity = 0
		this.leftNode.active = false
		this.rightNode.active = false
		this.answerState = false
	},

	onEnable() {

	},

	onDisable() {

	},


	getData(cb) {
		cb(this.getDefaultData());
	},

	getDefaultData() {
		const dataJson = ' [{"bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b90a006ba41723ec11970051e92f43e0.png","rect":{"x":125.28,"y":0,"width":508.44,"height":286},"bgAudioUrl":"http://staging-teach.cdn.ireadabc.com/c8a7dd49a778b0b6dd509aac0ef437ff.mp3"},"hotZoneItemArr":[{"id":"1620909579034","index":0,"itemType":"text","fontScale":0.59296875,"imgScale":1,"mapScale":0.59296875,"gIdx":"0","actionData_":{"type":"text","changeOption":[["fontColor","#000000"],["fontSize","60"]],"text":"aaaaaaaaaaaaaa","audio_url":"http://staging-teach.cdn.ireadabc.com/c8a7dd49a778b0b6dd509aac0ef437ff.mp3"},"rect":{"width":292.76,"height":35.58,"x":12.63,"y":26.79}},{"id":"1620915585437","index":1,"pic_url":"http://staging-teach.cdn.ireadabc.com/31bde9b15582618fa5db4ac7cbc275b4.gif","itemType":"pic","fontScale":0.59296875,"imgScale":0.14977973568281938,"mapScale":0.59296875,"gIdx":"2","actionData_":{"type":"text","changeOption":[["fontColor","#000000"],["fontSize","100"]],"text":"bbbbbbbbbbb"},"rect":{"x":328.41,"y":11,"width":161.61,"height":68}},{"id":"1620920750092","index":2,"itemType":"text","fontScale":0.59296875,"imgScale":1,"mapScale":0.59296875,"gIdx":"0","actionData_":{"type":"text","changeOption":[["fontColor","#000000"],["fontSize","100"]],"text":"嗯？","audio_url":"http://staging-teach.cdn.ireadabc.com/7df4cc83a6c76dc6f0a526d07e6f1987.mp3"},"rect":{"width":118.58,"height":59.3,"x":203.93,"y":129.35}}]},{"bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/b90a006ba41723ec11970051e92f43e0.png","bgAudioUrl":"http://staging-teach.cdn.ireadabc.com/8f73a6b73a217d25ca4f4a2e234c1513.mp3","rect":{"x":222.44,"y":0,"width":903.11,"height":508}},"hotZoneItemArr":[{"id":"1620920863432","index":0,"pic_url":"http://staging-teach.cdn.ireadabc.com/335dea1b83498b0c7c05be637dc13dad.jpeg","itemType":"text","fontScale":1.053125,"imgScale":0.22391857506361323,"mapScale":1.053125,"gIdx":"0","actionData_":{"type":"text","changeOption":[["fontColor","#FF0000"],["fontSize","100"]],"text":"This is a test"},"rect":{"width":558.89,"height":105.31,"x":13.12,"y":6.34}},{"id":"1620920877342","index":1,"itemType":"text","fontScale":1.053125,"imgScale":1,"mapScale":1.053125,"gIdx":"1","actionData_":{"type":"text","changeOption":[["fontColor","#0000FF"],["fontSize","100"]],"text":"you are so good"},"rect":{"width":734.29,"height":105.31,"x":106.43,"y":151.34}},{"id":"1620922839187","index":2,"itemType":"text","fontScale":1.053125,"imgScale":1,"mapScale":1.053125,"gIdx":"0","actionData_":{"type":"text","changeOption":[["fontColor","#000000"],["fontSize","100"]],"text":"_______________"},"rect":{"width":728.12,"height":105.31,"x":109.5,"y":170.34}}]}]'
		const data = JSON.parse(dataJson);
		return data;
	},

	preloadItem() {
		this.addPreload()
		this.preload();
	},

	addPreload() {
		for (let item of this.data) {
			item.bgAudioUrl && this._audioResList.push({ url: item.bgAudioUrl })
			for (let item of item.hotZoneItemArr) {
				item.audio_url && this._audioResList.push({ url: item.audio_url })
			}
		}
	},

	preload() {

		const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
		cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {

			this.loadEnd();
			if (window && window["air"]) {
				window["air"].hideAirClassLoading();
			}

			cc.debug.setDisplayStats(false);
		});
	},


	loadEnd() {
		this.initData();
		this.initView();
		// this.initListener();
	},

	_cantouch: null,
	initData() {
		// 所有全局变量 默认都是null 
		this._cantouch = true;
	},

	initView() {
		this.initBg();
		this.initPic();
	},

	initBg() {
		// const bgNode = cc.find('Canvas/bg');
		// bgNode.scale = this._mapScaleMax;
		// cc.find('Canvas/bottomPart').scale = this._mapScaleMin
	},

	initPic() {
		this.picNode.opacity = 0
		cc.Tween.stopAllByTarget(this.picNode)
		cc.tween(this.picNode).to(1, { opacity: 255 }, { easing: 'cubicInOut' }).start()
		this.curPage = 0
		if (this.data.length == 1) {
			this.leftNode.active = false
			this.rightNode.active = false
		} else {
			this.leftNode.active = false
			this.rightNode.active = true
		}
		this.setContent(this.picNode, this.data[0])
	},
	curPage: null,

	onClickRight() {
		if (!this._cantouch) {
			return;
		}

		this.curPage += 1

		if (this.curPage == 1) {
			this.leftNode.active = true
			this.leftNode.scale = 1
		}

		if (this.curPage == this.data.length - 1) {
			this.rightNode.active = false
		}

		this.leftMove()

		cc.audioEngine.play(this.btnClip, false, 0.5)
	},

	onClickLeft() {
		if (!this._cantouch) {
			return;
		}
		this.curPage -= 1
		if (this.curPage == 0) {
			this.leftNode.active = false
		}

		if (this.curPage == this.data.length - 2) {
			this.rightNode.active = true
			this.rightNode.scale = 1
		}
		this.rightMove()

		cc.audioEngine.play(this.btnClip, false, 0.8)
	},



	/** 左移动 */
	leftMove() {
		this.stopAudio()
		this._cantouch = false;
		let width = cc.winSize.width
		this.picNode.x = 0
		this.picTempNode.x = width
		this.setContent(this.picTempNode, this.data[this.curPage])
		cc.tween(this.picNode)
			.to(1, { x: -width }, { easing: 'cubicInOut' })
			.start();

		cc.tween(this.picTempNode)
			.to(1, { x: 0 }, { easing: 'cubicInOut' })
			.call(() => {
				let temp = this.picNode
				this.picNode = this.picTempNode
				this.picTempNode = temp
				this._cantouch = true;
			})
			.start();
	},

	/** 右移动 */
	rightMove() {
		this.stopAudio()
		this._cantouch = false;
		let width = cc.winSize.width
		this.picNode.x = 0
		this.picTempNode.x = -width
		this.setContent(this.picTempNode, this.data[this.curPage])
		cc.tween(this.picNode)
			.to(1, { x: width }, { easing: 'cubicInOut' })
			.start();

		cc.tween(this.picTempNode)
			.to(1, { x: 0 }, { easing: 'cubicInOut' })
			.call(() => {
				let temp = this.picNode
				this.picNode = this.picTempNode
				this.picTempNode = temp
				this._cantouch = true
			})
			.start();
	},
	stopAudio() {
		cc.systemEvent.emit('stopBgMusic')
		cc.systemEvent.emit('stopWordsMusic')
		this.answerState = false
		this.checkNode.children[0].active = false
		this.checkNode.children[1].active = true
	},

	// ------------------------------------------------
	/**设置显示区域内容 */
	setContent(picNode, data) {
		if (!data) {
			console.log('数据错误')
			return
		}
		picNode.getComponent('picNode').initWithData(data)
		let url = data.bgItem.bgAudioUrl
		if (url && url != '') {
			this.bgAudioNode.active = true
			this.bgAudioNode.getComponent('audioItem').init(url)
		} else {
			this.bgAudioNode.active = false
		}
	},

	answerState: null,

	/** 点击切换答案显示 */
	onCheckall() {
		cc.audioEngine.playEffect(this.btnClip)
		cc.audioEngine.playEffect(this.tipClip)
		this.answerState = !this.answerState
		this.checkNode.children[0].active = this.answerState
		this.checkNode.children[1].active = !this.answerState
		cc.systemEvent.emit('changeAnswerState', this.answerState)
	}
	// ------------------------------------------
});
