cc.Class({
    extends: cc.Component,

    properties: {
        playBtn: cc.Node,
        label: cc.Label,
        tiao: cc.Node
    },
    onload() {
        this._clip = null
        this._play = false
        this._audioId = null
        this._totoalTime = null
        this._nowTime = null
    },
    onEnable() {
        cc.systemEvent.on('stopBgMusic', this.onEvent, this)
    },

    onDisable() {
        cc.systemEvent.off('stopBgMusic', this.onEvent, this)
    },
    init(url) {
        this.stopAudio()
        this.playBtn.children[0].active = false
        this.playBtn.children[1].active = true
        cc.assetManager.loadRemote(url, (err, audioClip) => {
            if (err) return
            this.clip = audioClip
            this._totoalTime = audioClip.duration
            this.label.string = '0:00/' + this.transTime(this._totoalTime)
            this.tiao.children[0].getComponent(cc.Sprite).fillRange = 0
            this.tiao.children[1].x =12
        })
    },

    onPlay() {
        this._play = !this._play
        this.playBtn.children[0].active = this._play
        this.playBtn.children[1].active = !this._play
        if (this._play) {
            if (this._audioId != null) {
                cc.audioEngine.resume(this._audioId)
            } else {
                this._audioId = cc.audioEngine.play(this.clip, false, 0.8);
                cc.audioEngine.setFinishCallback(this._audioId, this.stopAudio.bind(this));
                this._nowTime = 0
            }
            cc.systemEvent.emit('stopWordsMusic')
            this.schedule(this.onTimeLoop)
        } else {
            this.stopAudio()
        }
    },

    /** 定时回调 */
    onTimeLoop(dt) {
        this._nowTime += dt
        this.label.string = this.transTime(this._nowTime) + '/' + this.transTime(this._totoalTime)
        if (this._nowTime > this._totoalTime) this._nowTime = this._totoalTime
        let scale = this._nowTime / this._totoalTime
        this.tiao.children[0].getComponent(cc.Sprite).fillRange = scale
        this.tiao.children[1].x = 12 + 364 * scale
    },

    onEvent() {
        if (!this._play) return
        this.onStopAudio()
    },

    onStopAudio() {
        if (this._nowTime < this._totoalTime) {
            cc.audioEngine.pause(this._audioId)
            this._play = false
            this.playBtn.children[0].active = false
            this.playBtn.children[1].active = true
            this.unscheduleAllCallbacks()
        } else {
            this.stopAudio()
        }
    },

    stopAudio() {
        if (this._audioId != null) {
            cc.audioEngine.stop(this._audioId)
            this._audioId = null
            this.unscheduleAllCallbacks()
            this._play = false
            this.playBtn.children[0].active = false
            this.playBtn.children[1].active = true
            this.tiao.children[0].getComponent(cc.Sprite).fillRange = 1
            this.tiao.children[1].x = 12 + 364 * 1
        }
    },

    /** 秒转分钟 */
    transTime(time) {
        let temp = Math.floor(time / 60)
        time = (time - 60 * temp).toFixed(0)
        if (time < 10) time = '0' + time
        return temp + ':' + time
    }
});
