import {
  MySprite,
  getMinScale,
  ShapeRect,
  tweenChange,
  randomSortByArr,
  Label,
  showPopParticle,
  moveItem,
  removeItemFromArr,
  rotateItem
} from "./Unit";

const myUtility = {};

// 系统缩放比例
myUtility.mapScale = 1;

// 音乐 和 图片的缓冲区
myUtility.audio = new Map();
myUtility.images = new Map();
myUtility.imagesOriginSize = new Map();

// 坐标原点 包含缩放
myUtility.originX = 0;
myUtility.originY = 0;

myUtility.setOrigin = (x, y)=>{
  myUtility.originX = x;
  myUtility.originY = y;
}
myUtility.getOrigin = ()=>{
  return {
    x: myUtility.originX,
    y: myUtility.originY
  }
}

// 坐标原点 包含缩放
myUtility.relativeOriginX = 0;
myUtility.relativeOriginY = 0;

myUtility.setRelativeOrigin = (x, y)=>{
  myUtility.relativeOriginX = x;
  myUtility.relativeOriginY = y;
}
myUtility.getRelativeOrigin = ()=>{
  return {
    x: myUtility.relativeOriginX,
    y: myUtility.relativeOriginY
  }
}

// 存放音乐和图片的地址
const audioObj = {}
const imageObj = {}
// 添加音乐
myUtility.audio.add = ( key, url ) => {
  audioObj[key] = url
};
// 添加音乐
myUtility.images.add = ( key, url ) => {
  imageObj[key] = url
};

// 播放音乐
myUtility.audio.playAudio = function(key, now = false, callback = null) {
  const audio = myUtility.audio.get(key);
  if (audio) {
    if (now) {
      audio.pause();
      audio.currentTime = 0;
    }
    if (callback) {
      audio.onended = () => {
        callback();
      };
    }
    audio.play();
  }
}

// 异步加载图片 音频资源
myUtility.loadResources = ()=> {
  const pr = [];
  for(let key in imageObj){
    const p = preloadImage(imageObj[key]).then(img => {
      myUtility.images.set(key, img);
      myUtility.imagesOriginSize.set(key, {width:img.width, height:img.height});
    }).catch(err => console.log(key));
    pr.push(p);
  };
  for(let key in audioObj){
    const a = preloadAudio(audioObj[key]).then((music) => {
      myUtility.audio.set(key, music);
    }).catch(err => console.log(key));
    pr.push(a);
  };
  return Promise.all(pr);
}

// 预加载图片
const preloadImage = (url) => {
  return new Promise((resolve, reject) => {
    const img = new Image();
    img.src = url;
    img.onload = () => resolve(img);
    img.onerror = reject;
    img.src = url;
  });
}
// 预加载音频
const preloadAudio = (url) => {
  return new Promise((resolve, reject) => {
    const audio = new Audio();
    audio.oncanplay = a => {
      resolve(audio);
    };
    audio.onerror = () => {
      reject();
    };
    audio.src = url;
    audio.load();
  });
}

// 缓存页面元素
myUtility.cartoonElementsBuffer = {}
myUtility.createCartoonElement = (key, element, width, heigth, initX, initY)=>{
  myUtility.cartoonElementsBuffer[key] = {}
  myUtility.cartoonElementsBuffer[key].id = key;
  myUtility.cartoonElementsBuffer[key].width = width;
  myUtility.cartoonElementsBuffer[key].heigth = heigth;
  myUtility.cartoonElementsBuffer[key].initX = initX;
  myUtility.cartoonElementsBuffer[key].initY = initY;
  myUtility.cartoonElementsBuffer[key].ref = element;
  return myUtility.cartoonElementsBuffer[key]
}
myUtility.getCartoonElementRef = (key)=>{
  if(myUtility.cartoonElementsBuffer[key]){
    return myUtility.cartoonElementsBuffer[key].ref;
  }else{
    return undefined
  }
}
myUtility.getCartoonElement = (key)=>{
  return myUtility.cartoonElementsBuffer[key]
}

myUtility.setCartoonElementPosition = (key, posi)=>{
  myUtility.cartoonElementsBuffer[key].ref.x = posi.x
  myUtility.cartoonElementsBuffer[key].ref.y = posi.y
  myUtility.cartoonElementsBuffer[key].x = posi.x
  myUtility.cartoonElementsBuffer[key].y = posi.y
}

myUtility.setCartoonElementPositionX = (key, x)=>{
  myUtility.cartoonElementsBuffer[key].ref.x = x
  myUtility.cartoonElementsBuffer[key].x = x
}

myUtility.setCartoonElementRelativePositionX = (key, x)=>{
  myUtility.cartoonElementsBuffer[key].relativeX = x
}

myUtility.setCartoonElementPositionY = (key, y)=>{
  myUtility.cartoonElementsBuffer[key].ref.y = y
  myUtility.cartoonElementsBuffer[key].y = y
}

myUtility.setCartoonElementRelativePositionY = (key, y)=>{
  myUtility.cartoonElementsBuffer[key].relativeY = y
}

myUtility.getCartoonElementPosition = (key)=>{
  return {
    x: myUtility.cartoonElementsBuffer[key].x,
    y: myUtility.cartoonElementsBuffer[key].y
  }
}

myUtility.getCartoonElementRelativePosition = (key)=>{
  return {
    x: myUtility.cartoonElementsBuffer[key].relativeX,
    y: myUtility.cartoonElementsBuffer[key].relativeY
  }
}

myUtility.animation = {}
myUtility.animation.move = (eleKey, distPosition, runTime, callback )=>{
  tweenChange(myUtility.cartoonElementsBuffer[eleKey].ref, distPosition, runTime, ()=>{
    callback && callback()
  });
}
myUtility.animation.scaleChange = myUtility.animation.move;

export default myUtility
