import {
  MySprite,
  getMinScale,
  ShapeRect,
  tweenChange,
  randomSortByArr,
  Label,
  showPopParticle,
  moveItem,
  removeItemFromArr,
  rotateItem
} from "./Unit";

export class CartoonAnimation {
  animations = {}
  currentRef;
  constructor(ref){
    this.currentRef = ref
  }
  add(key:string, func:Function){
    this.animations[key] = func
  }
  move = (ele, distPosition, runTime, callback?:Function )=>{
    tweenChange(ele, distPosition, runTime, ()=>{
      callback && callback()
    });
  }
  scaleChange = this.move;
  run( key:string ){
    this.animations[key]()
  }
  overCard = function (callback?: any){
    let w = this.currentRef.scaleX;
    this.scaleChange(this.currentRef, { scaleX: 0 }, 0.3, () => {
      this.currentRef.frontSide.visible = !this.currentRef.frontSide.visible;
      this.currentRef.backSide.visible = !this.currentRef.backSide.visible;
      this.scaleChange(this.currentRef, { scaleX: w }, 0.3, () => {
        callback && callback();
      });
    });
  }

}