import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef} from '@angular/core';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})

export class FormComponent implements OnInit, OnChanges, OnDestroy {

  _item: any;
  dataArray: Array<Object> = []; 
  hotZoneItemArr: Array<Object> = [];
  bgItem: Object;

  KEY = 'DataKey_PicturePuzzle';

  set item(item) {
    this._item = item;
  }
  get item() {
    return this._item;
  }

  @Output()
  update = new EventEmitter();
  constructor(private appRef: ApplicationRef) {

  }

  ngOnInit() {
    this.item = {};
    this.item.contentObj = {};
    const getData = (<any> window).courseware.getData;
    getData((data) => {
      console.log("读取数据", data)
      if (data) {
        this.item = data;
      } else {
        this.item = {};
      }
      if ( !this.item.contentObj ) {
        this.item.contentObj = {};
      }
      this.init();
      this.refresh();
      // this.saveItem();
    }, this.KEY);
  }
  ngOnChanges() {

  }

  ngOnDestroy() {
  }

  saveData(e){
    console.log("HotZone保存", e)
    this.bgItem = e.bgItem;
    this.hotZoneItemArr.length = 0;
    e.hotZoneItemArr.forEach(item => {
      console.log(item)
      this.hotZoneItemArr.push(item)
    });
    this.save();
  }

  init() {
    if (this.item.contentObj.dataArray) {
      this.dataArray = this.item.contentObj.dataArray;
    } else {
      this.dataArray = this.getDefaultPicArr();
      this.item.contentObj.dataArray = this.dataArray;
    }

    if (this.item.contentObj.hotZoneItemArr) {
      this.hotZoneItemArr = this.item.contentObj.hotZoneItemArr;
    } else {
      this.hotZoneItemArr = this.getDefaultPicArr();
      this.item.contentObj.hotZoneItemArr = this.hotZoneItemArr;
    }

    if (this.item.contentObj.bgItem) {
      this.bgItem = this.item.contentObj.bgItem;
    } else {
      this.bgItem = {}
      this.item.contentObj.bgItem = this.bgItem;
    }
  }

  cardItemData(){
    return {
      audio_url: "",
      image_url: "",
      hotZoneIndex: -1
    };
  }

  cardChoiceData(){
    return { isText: true, text: "", image_url: "" }
  }

  getDefaultPicArr() {
    let arr = []; 
    return arr;
  }

  initData() {

  }


  addChoice(questionIndex) { 
    let item = this.cardChoiceData();  
    this.dataArray[questionIndex].choice.incorrect.push(item);
    this.saveItem();
  }

  onImageUploadSuccessByItem(e, item) {
    item.image_url = e.url
    this.save(); 
  }
 
  onAudioUploadSuccessByItem(e, item) { 
    item.audio_url = e.url; 
    this.save();
  }

  onTitleAudioUploadSuccess(e) { 
    this.item.contentObj.titleAudio_url = e.url;
    this.save();
  }

  addItem() { 
    let item = this.cardItemData();  
    this.dataArray.push(item);
    this.saveItem();
  }

  radioClick(it, radioValue) {
    it.radioValue = radioValue;
    this.saveItem();
  }

  clickCheckBox() {
    this.saveItem();
  }

  saveItem() {
    this.save();
  }

  save() {
    (<any> window).courseware.setData(this.item, null, this.KEY);
    this.refresh();
    console.log("保存", this.item)
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }
}

