// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
import {
    exchangeNodePos,
    asyncTweenTo,
    asyncPlayDragonBoneAnimation,
    asyncDelayTime,
    RandomInt
} from '../script/SN11_utils';

cc.Class({
    extends: cc.Component,

    properties: {
        ribbonPrefab: {
            type: cc.Prefab,
            default: null,
        },
        结束: {
            default: null,
            type: cc.AudioClip
        },
        点击: {
            default: null,
            type: cc.AudioClip
        },
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    async start() {
        cc.audioEngine.play(this['结束']);

        const btnRestart = cc.find('Canvas/game_end/BtnRestart');
        btnRestart.active = false;
        btnRestart.opacity = 0;
        const nodeCharactor = cc.find('Canvas/game_end/NodeCharactor');
        await asyncTweenTo(nodeCharactor, 0.6, { y: 150 }, { easing: 'quadOut' });

        this.showRibbons();

        nodeCharactor.zIndex = 10;
        await asyncTweenTo(nodeCharactor, 0.6 / 3, { y: 50 }, { easing: 'quadIn' });

        asyncPlayDragonBoneAnimation(nodeCharactor, 'wave', -1);

        await asyncDelayTime(1);

        this.showFinishStone();

        await asyncDelayTime(3);

        btnRestart.active = true;
        btnRestart.zIndex = 30;
        await asyncTweenTo(btnRestart, 0.3, { opacity: 255 });

        btnRestart.on('click', () => {
            btnRestart.off('click');
            cc.tween(btnRestart)
                .to(0.3, { scale: 3, opacity: 0 })
                .call(() => {

                    cc.audioEngine.play(this['点击']);
                    btnRestart.active = false;


                    const middleLayer = cc.find('middleLayer');
                    if (middleLayer) {
                        middleLayer.getComponent('middleLayer').reloadBundle();
                    } else {

                        cc.audioEngine.stopAll();
                        cc.director.loadScene('SN11', () => {});
                    }

                    // cc.director.loadScene('SN11', () => {
                    //     const btnStart = cc.find(`Canvas/game_end/BtnStart`);
                    //     btnStart.active = false;
                    //     // cc.find(`Canvas`).getComponent('tyzdc').gameStart();
                    // });
                })
                .start();
        });
    },

    showFinishStone() {
        const stoneNodeBase = cc.find('Canvas/game_end/StoneNodeBase');
        stoneNodeBase.active = true;
        stoneNodeBase.zIndex = 25;
        stoneNodeBase.opacity = 255;

        const nodeLight = cc.find('Canvas/game_end/StoneNodeBase/NodeLight');
        nodeLight.opacity = 0;
        cc.tween(nodeLight)
            .to(3, { opacity: 255, angle: -360 })
            .by(3, { angle: -360 })
            .repeatForever()
            .start();

        for (let index = 0; index < 6; index++) {
            const nodeStar = cc.find(`Canvas/game_end/StoneNodeBase/NodeStarBase/NodeStar_${index}`);
            nodeStar.scale = Math.random() * 0.7 + 0.3;
            cc.tween(nodeStar)
                .to(1, { scale: 0, opacity: 0 })
                .delay(Math.random())
                .to(1, { scale: Math.random() * 0.7 + 0.3, opacity: 255 })
                .union()
                .repeatForever()
                .start();
        }
    },

    showRibbons() {
        for (let index = 0; index < 50; index++) {
            let node = cc.instantiate(this.ribbonPrefab);
            node.getChildByName(`Ribbon_${RandomInt(4)}`).active = true;
            node.x = RandomInt(-640, 640);
            node.y = RandomInt(360, 360 + 720);
            node.zIndex = 20;
            node.parent = this.node;

            cc.tween(node)
                .by(1, { x: RandomInt(-100, 100), y: RandomInt(-300, -350), angle: RandomInt(-30, 30) })
                .repeatForever()
                .start();
        }
    },

    // update (dt) {},
});
