import {Component, ElementRef, EventEmitter, Input, Output, OnInit, OnChanges, ViewChild} from '@angular/core';
import {NzMessageService, UploadChangeParam, UploadFile, UploadFileStatus} from 'ng-zorro-antd';
import {DomSanitizer, SafeResourceUrl} from '@angular/platform-browser';


@Component({
  selector: 'upload-dragon-bones',
  templateUrl: './upload-dragon-bones.component.html',
  styleUrls: ['./upload-dragon-bones.component.scss']
})
export class UploadDragonBonesComponent implements OnInit, OnChanges {
  @Input() dragonBones = {
    skeJsonData: {url: "", name: ""},
    texJsonData: {url: "", name: ""},
    texPngData: {url: "", name: ""}
  };
  @Input() buttonText: string = "配置骨骼动画"
  @Output() change = new EventEmitter();
  @ViewChild('videoNode', {static: true }) videoNode: ElementRef;

  uploadUrl;
  uploadData;
  animaPanelVisible: boolean = false;
  isSkeJsonLoading = false;
  isTexJsonLoading = false;
  isTexPngLoading = false;
  skeJsonData = {};
  texJsonData = {};
  texPngData = {};
  _dragonBones = {
    skeJsonData: {url: "", name: ""},
    texJsonData: {url: "", name: ""},
    texPngData: {url: "", name: ""}
  };

  constructor(private nzMessageService: NzMessageService) {
    this.uploadUrl = (<any> window).courseware.uploadUrl();
    this.uploadData = (<any> window).courseware.uploadData();
    window['air'].getUploadCallback = (url, data) => {
      this.uploadUrl = url;
      this.uploadData = data;
    };
  }

  ngOnInit() {
    if(this.dragonBones) {
      if(!this.dragonBones.skeJsonData) {
        this.dragonBones.skeJsonData = {url: "", name: ""}
      }
      if(!this.dragonBones.texJsonData) {
        this.dragonBones.texJsonData = {url: "", name: ""}
      }
      if(!this.dragonBones.texPngData) {
        this.dragonBones.texPngData = {url: "", name: ""}
      }
    } else {
      this.dragonBones = {
        skeJsonData: {url: "", name: ""},
        texJsonData: {url: "", name: ""},
        texPngData: {url: "", name: ""}
      };
    }
    this._dragonBones = this.dragonBones;
  }

  ngOnChanges() {

  }

  animaPanelCancel() {
    this.animaPanelVisible = false;
  }

  animaPanelOk() {
    this.animaPanelVisible = false;
    this.change.emit({
      texPngData: this.texPngData,
      texJsonData: this.texJsonData,
      skeJsonData: this.skeJsonData,
    })
  }

  setAnimaBtnClick(dragonBones) {
    const {skeJsonData, texJsonData, texPngData} = dragonBones;
    this.skeJsonData = skeJsonData || {};
    this.texJsonData = texJsonData || {};
    this.texPngData = texPngData || {};

    this.animaPanelVisible = true;
  }

  skeJsonHandleChange(e) {
    switch (e.type) {
      case 'start':
        this.isSkeJsonLoading = true;
        break;

      case 'success':
        this.skeJsonData['url'] = e.file.response.url;
        this.skeJsonData['name'] = e.file.name;
        this.nzMessageService.success('上传成功');
        this.isSkeJsonLoading = false;
        break;

      case 'progress':
        break;
    }
  }

  texJsonHandleChange(e) {
    switch (e.type) {
      case 'start':
        this.isTexJsonLoading = true;
        break;

      case 'success':
        this.texJsonData['url'] = e.file.response.url;
        this.texJsonData['name'] = e.file.name;
        this.nzMessageService.success('上传成功');
        this.isTexJsonLoading = false;
        break;

      case 'progress':
        break;
    }
  }

  texPngHandleChange(e) {
    switch (e.type) {
      case 'start':
        this.isTexPngLoading = true;
        break;

      case 'success':
        this.texPngData['url'] = e.file.response.url;
        this.texPngData['name'] = e.file.name;
        this.nzMessageService.success('上传成功');
        this.isTexPngLoading = false;
        break;

      case 'progress':
        break;
    }
  }
  
}

