cc.Class({
    extends: cc.Component,

    properties: {
        spfBase: [cc.SpriteFrame],
        sprBg: cc.Sprite,
        labText: cc.Label,
        nodLight: cc.Node,
        dragonBone: dragonBones.ArmatureDisplay,
        audRight: cc.AudioClip,
        audWrong: cc.AudioClip,
    },

    // onLoad () {},

    start() {

    },

    onEnable() {
        this.node.on('touchstart', this.onTouchStart, this);
    },
    onDisable() {
        this.node.off('touchstart', this.onTouchStart, this);
    },
    onTouchStart() {
        if (GameData.isAudio) {
            return;
        }
        if (GameData.currOptionIndex == this.index) {
            this.chooseRight();
        } else {
            this.chooseWrong();
        }
    },

    setInfo(data, index, scene, optionCount) {
        this.scene = scene;
        this.data = data;
        this.index = index;
        this.labText.string = index;
        this.loadDragonBone();
        if (optionCount == 3) {
            this.sprBg.spriteFrame = this.spfBase[0];
        } else {
            this.sprBg.spriteFrame = this.spfBase[1];
        }
    },
    loadDragonBone() {
        GameData.dragonBoneCount++;
        this.dragonBone.dragonAtlasAsset = null;
        this.dragonBone.dragonAsset = null;
        this.dragonBone.armatureName = '';
        var imageUrl = this.data.optionDragonBone.texPngData.url;
        var skeUrl = this.data.optionDragonBone.skeJsonData.url;
        var atlasUrl = this.data.optionDragonBone.texJsonData.url;
        // imageUrl = 'http://127.0.0.1/NewProject_2_tex.png';
        // skeUrl = 'http://127.0.0.1/NewProject_2_ske.json';
        // atlasUrl = 'http://127.0.0.1/NewProject_2_tex.json';
        cc.assetManager.loadAny([{ url: atlasUrl, ext: '.txt' }, { url: skeUrl, ext: '.txt' }], (error, assets) => {
            if (error) {
                console.log(error)
            }
            else {
                cc.assetManager.loadRemote(imageUrl, (error, texture) => {
                    if (error) {
                        console.log(error)
                    }
                    else {
                        var atlas = new dragonBones.DragonBonesAtlasAsset();
                        atlas._uuid = atlasUrl;
                        atlas.atlasJson = assets[0];
                        atlas.texture = texture;

                        var asset = new dragonBones.DragonBonesAsset();
                        asset._uuid = skeUrl;
                        asset.dragonBonesJson = assets[1];

                        this.dragonBone.dragonAtlasAsset = atlas;
                        this.dragonBone.dragonAsset = asset;
                        let data = asset._dragonBonesJsonData.armature[0];
                        if (!data) {
                            return;
                        }
                        this.dragonBone.armatureName = data.name;
                        this.animationName = data.animation[0].name;


                        GameData.dragonBoneCount--;
                        if (GameData.dragonBoneCount == 0) {
                            this.dragonBone.premultipliedAlpha = true;
                            atlas.texture.setPremultiplyAlpha(true);
                        }
                    }
                });
            }
        });
    },
    chooseRight() {
        this.node.zIndex = 5;
        this.playAudioRight();
        this.nodLight.active = true;
        this.scene.moveToQuestion(this);
    },
    chooseWrong() {
        this.playAudioWrong();
        cc.tween(this.node)
            .to(0.2, { y: -150 })
            .to(0.2, { y: 0 })
            .start()

    },

    playAudioRight() {
        GameData.isAudio = true;
        let id = cc.audioEngine.play(this.audRight, false, 1);
        cc.audioEngine.setFinishCallback(id, () => {
            GameData.isAudio = false;
        })
    },
    playAudioWrong() {
        GameData.isAudio = true;
        let id = cc.audioEngine.play(this.audWrong, false, 1);
        cc.audioEngine.setFinishCallback(id, () => {
            GameData.isAudio = false;
        })
    },
    // update (dt) {},
});
