cc.Class({
    extends: cc.Component,

    properties: {
        nodBg1: cc.Node,
        nodBg2: cc.Node,
        dragonBone: dragonBones.ArmatureDisplay,
        labText: cc.Label,
        labQuestion1: cc.Label,
        labQuestion2: cc.Label,
        labQuestion3: cc.Label,
    },
    // onLoad () {},

    start() {

    },

    onEnable() {
        this.node.on('touchstart', this.onTouchStart, this);
    },
    onDisable() {
        this.node.off('touchstart', this.onTouchStart, this);
    },

    setInfo(data, index, scene) {
        this.scene = scene;
        this.data = data;
        this.index = index;
        this.labText.string = index;
        this.updateLabels();
        this.loadDragonBone();
    },

    loadDragonBone() {
        GameData.dragonBoneCount++;
        this.dragonBone.dragonAtlasAsset = null;
        this.dragonBone.dragonAsset = null;
        this.dragonBone.armatureName = '';
        var imageUrl = this.data.optionDragonBone.texPngData.url;
        var skeUrl = this.data.optionDragonBone.skeJsonData.url;
        var atlasUrl = this.data.optionDragonBone.texJsonData.url;
        // imageUrl = 'http://127.0.0.1/NewProject_2_tex.png';
        // skeUrl = 'http://127.0.0.1/NewProject_2_ske.json';
        // atlasUrl = 'http://127.0.0.1/NewProject_2_tex.json';

        // imageUrl = 'http://127.0.0.1/walkingfish_tex.png';
        // skeUrl = 'http://127.0.0.1/walkingfish_ske.json';
        // atlasUrl = 'http://127.0.0.1/walkingfish_tex.json';
        cc.assetManager.loadAny([{ url: atlasUrl, ext: '.txt' }, { url: skeUrl, ext: '.txt' }], (error, assets) => {
            if (error) {
                console.log(error)
            }
            else {
                cc.assetManager.loadRemote(imageUrl, (error, texture) => {
                    if (error) {
                        console.log(error)
                    }
                    else {
                        var atlas = new dragonBones.DragonBonesAtlasAsset();
                        atlas._uuid = atlasUrl;
                        atlas.atlasJson = assets[0];
                        atlas.texture = texture;

                        var asset = new dragonBones.DragonBonesAsset();
                        asset._uuid = skeUrl;
                        asset.dragonBonesJson = assets[1];

                        this.dragonBone.dragonAtlasAsset = atlas;
                        this.dragonBone.dragonAsset = asset;
                        let data = asset._dragonBonesJsonData.armature[0];
                        if (!data) {
                            return;
                        }
                        this.dragonBone.armatureName = data.name;
                        this.animationName = data.animation[0].name;

                        GameData.dragonBoneCount--;
                        if (GameData.dragonBoneCount == 0) {
                            this.dragonBone.premultipliedAlpha = true;
                            atlas.texture.setPremultiplyAlpha(true);
                        }
                    }
                });
            }
        });
    },

    updateLabels() {
        this.labQuestion1.string = this.data.text;
        this.labQuestion2.string = this.data.text;
        this.labQuestion3.string = this.data.text;
        this.labQuestion1._forceUpdateRenderData();
        this.labQuestion2._forceUpdateRenderData();
        this.labQuestion3._forceUpdateRenderData();

        if (this.labQuestion1.node.width > 145) {
            this.labQuestion1.node.scale = 145 / this.labQuestion1.node.width;
            this.labQuestion2.node.scale = 145 / this.labQuestion1.node.width;
            this.labQuestion3.node.scale = 145 / this.labQuestion1.node.width;
        }
    },

    setChooseRight(dragonBone, animationName) {
        this.isRight = true;
        this.animationName2 = animationName;
        this.nodBg1.active = false;
        this.nodBg2.active = true;
        this.labQuestion1.node.parent.active = false;
        this.labQuestion2.node.parent.active = false;
        this.labQuestion3.node.active = true;
        this.nodDragonBone2 = cc.instantiate(dragonBone.node);
        this.nodDragonBone2.parent = this.node;
        this.nodDragonBone2.x = 40;
        this.nodDragonBone2.y = this.dragonBone.node.y;
        this.dragonBone.node.x = -40;
        this.playAudioOption(true);

        this.dragonBone.playAnimation(this.animationName, 0);
        this.nodDragonBone2.getComponent(dragonBones.ArmatureDisplay).playAnimation(animationName, 0);
    },
    stopRightAnimation() {
        this.dragonBone.playAnimation(this.animationName, 1);
        this.nodDragonBone2.getComponent(dragonBones.ArmatureDisplay).playAnimation(this.animationName2, 1);
    },

    setGray() {
        this.isGray = true;
        this.labQuestion1.node.parent.active = false;
        this.labQuestion2.node.parent.active = false;
        this.nodBg1.color = new cc.Color().fromHEX('#7E7E7E');
        this.dragonBone.node.color = new cc.Color().fromHEX('#7E7E7E');
    },
    setNormal() {
        this.isGray = false;
        this.nodBg1.color = new cc.Color().fromHEX('#ffffff');
        this.dragonBone.node.color = new cc.Color().fromHEX('#ffffff');
    },

    onTouchStart() {
        if (this.isRight) {
            return;
        }
        if (this.isGray) {
            return;
        }
        if (GameData.isAudio) {
            return;
        }
        this.showQipao();
        this.playAudioOption();
    },

    showQipao() {
        if (this.index == 3) {
            this.labQuestion1.node.parent.active = false;
            this.labQuestion2.node.parent.active = true;
        } else {
            this.labQuestion1.node.parent.active = true;
            this.labQuestion2.node.parent.active = false;
        }
    },

    playAudioOption(showNext) {
        GameData.isAudio = true;
        let url = this.data.optionAudio;
        // url = 'http://127.0.0.1/iamflying.mp3';
        cc.assetManager.loadRemote(url, null, (err, clip) => {
            if (err) {
                console.log(err)
                return;
            }
            let id = cc.audioEngine.play(clip, false, 1);
            cc.audioEngine.setFinishCallback(id, () => {
                GameData.isAudio = false;
                if (showNext) {
                    this.scene.showNext(this.index);
                }
            })
        });
    },
    // update (dt) {},
});
