const { showFireworks } = require("./utils");

cc.Class({
    extends: cc.Component,

    properties: {
        audOver:cc.AudioClip,
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.node.getChildByName('bg_verygood').zIndex = 99;
    },

    start() {
        showFireworks(
            this.node,
            this.node.getChildByName('RibbonNodeBase').children,
            cc.v2(0, -400), cc.v2(0, 1000), 200, 200
        );
        showFireworks(
            this.node,
            this.node.getChildByName('RibbonNodeBase').children,
            cc.v2(-600, -400), cc.v2(200, 1000), 200, 200
        );
        showFireworks(
            this.node,
            this.node.getChildByName('RibbonNodeBase').children,
            cc.v2(600, -400), cc.v2(-200, 1000), 200, 200
        );
        this.playAudioOver();
    },

    playAudioOver() {
		GameData.isAudio = true;
		let id = cc.audioEngine.play(this.audOver, false, 1);
		cc.audioEngine.setFinishCallback(id, () => {
			GameData.isAudio = false;
		})
    },
    // update (dt) {},
});
