import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "DataKey_Cocos_FT11";
  // 储存对象
  item;

  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {

  }

  addQuestion() {
    this.item.questionList.push({
      "questionAudio": "",
      "questionText": "",
      "optionList": [{
        "text":"",
        "optionDragonBone": {
          "skeJsonData": { "url": "" },
          "texJsonData": { "url": "" },
          "texPngData": { "url": "" },
          "skeJsonData2": { "url": "" },
          "texJsonData2": { "url": "" },
          "texPngData2": { "url": "" }
        },
        "optionAudio": ""
      }, {
        "text":"",
        "optionDragonBone": {
          "skeJsonData": { "url": "" },
          "texJsonData": { "url": "" },
          "texPngData": { "url": "" },
          "skeJsonData2": { "url": "" },
          "texJsonData2": { "url": "" },
          "texPngData2": { "url": "" }
        },
        "optionAudio": ""
      }, {
        "text":"",
        "optionDragonBone": {
          "skeJsonData": { "url": "" },
          "texJsonData": { "url": "" },
          "texPngData": { "url": "" },
          "skeJsonData2": { "url": "" },
          "texJsonData2": { "url": "" },
          "texPngData2": { "url": "" }
        },
        "optionAudio": ""
      }]
    });
    this.save();
  }

  removeQuestion(idx) {
    this.item.questionList.splice(idx, 1);
    this.save();
  }

  addOption(questionIdx) {
    this.item.questionList[questionIdx].optionList.push({
        "text":"",
        "optionDragonBone": {
        "skeJsonData": { "url": "" },
        "texJsonData": { "url": "" },
        "texPngData": { "url": "" },
        "skeJsonData2": { "url": "" },
        "texJsonData2": { "url": "" },
        "texPngData2": { "url": "" }
      },
      "optionAudio": ""
    });
    this.save();
  }

  removeOption(questionIdx, optionIdx) {
    this.item.questionList[questionIdx].optionList.splice(optionIdx, 1);
    this.save();
  }

  ngOnInit() {
    this.item = {
      questionList: []
    };

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);
  }

  ngOnChanges() {
  }

  ngOnDestroy() {
  }

  init() {

  }

  onOptionUploadSuccess(e, questionIdx, optionIdx) {
    this.item.questionList[questionIdx].optionList[optionIdx].optionAudio = e.url;
    this.save();
  }

  onQuestionAudioUploadSuccess(e, questionIdx) {
    this.item.questionList[questionIdx].questionAudio = e.url;
    this.save();
    // questionText
  }

  radioClick(questionIdx, optionIdx) {
    this.item.questionList[questionIdx].rightOptionIdx = optionIdx;
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.save();
  }

  saveAnima(event, group) {
    group.skeJsonData = event.skeJsonData;
    group.texJsonData = event.texJsonData;
    group.texPngData = event.texPngData;
    this.save();
  }
  saveAnima2(event, group) {
    group.skeJsonData = event.skeJsonData2;
    group.texJsonData = event.texJsonData2;
    group.texPngData = event.texPngData2;
    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);

    this.refresh();
    console.log('this.item = ' + JSON.stringify(this.item));
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}
