/****
 * 批量编译打包模板工具
 * 运行 npm run publish T_01 命令来打包T_01模板
 * 运行 npm run publish T_01,T_02,T_03,T_04  命令来分别打包 T_01,T_02,T_03,T_04 这四个模板，注意逗号要用英文的
 * 运行 npm run publish all 命令来打包所有模板
 */

const spawn = require('child_process').spawn;
const path = require("path");
const fs = require("fs");
const os = require('os');
const compressing = require("compressing");

//Linux系统上'Linux'
//macOS 系统上'Darwin'
//Windows系统上'Windows_NT'
let sysType = os.type();

Date.prototype.Format = function(fmt) {
  var o = {
      "M+" : this.getMonth() + 1,
      "d+" : this.getDate(),
      "h+" : this.getHours(),
      "m+" : this.getMinutes(),
      "s+" : this.getSeconds(),
      "q+" : Math.floor((this.getMonth() + 3) / 3),
      "S" : this.getMilliseconds()
  };
  if (/(y+)/.test(fmt))
      fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
  for (var k in o)
  if (new RegExp("(" + k + ")").test(fmt))
      fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
  return fmt;
}

function clean(zipPath){
  if(fs.existsSync(zipPath)){
    fs.unlinkSync(zipPath);
  }
}

const runSpawn = async function (){

  await new Promise(function(resolve,reject){

    let pkg = require("../package.json");

    let ls;
    if(sysType==="Windows_NT"){
      //ng build --prod --build--optimizer --base-href /ng-one/
      ls = spawn("cmd.exe", ['/c', 'ng', 'build', '--prod', '--build--optimizer', '--base-href', '/template-base-href/'] );
    }else{
      ls = spawn("ng", ['build', '--prod', '--build--optimizer', '--base-href', '/template-base-href/'] );
    }

    ls.stdout.on('data', (data) => {
      console.log(` ${data}`);
    });

    ls.stderr.on('data', (data) => {
      console.log(`stderr: ${data}`);
      reject();
    });

    ls.on('close', (code) => {
      console.log(`child process exited with code ${code}`);
      //要压缩的目录
      let zippath = path.resolve(__dirname,"../dist", pkg.name);
      //压缩包的存放目录
      let date = new Date();
      // let zipname = pkg.name+"_"+date.Format("yyyyMMdd hh-mm-ss");
      let zipname = 'form';
      let zipdir = path.resolve(__dirname,"../publish/"+zipname+".zip");
      clean(zipdir); //删除原有的包

      const tarStream = new compressing.zip.Stream();
      fs.readdir(zippath,function(err,files){
        if(err){
          console.log("======文件打开异常======");
          console.log(err);
          reject();
        }
        for(let i=0;i<files.length;i++){
          tarStream.addEntry(zippath+"/"+files[i]);
        }
        let writeStream = fs.createWriteStream(zipdir);
        tarStream.pipe(writeStream);
        writeStream.on('close', () => {
            console.log(`模板 ${pkg.name} 打包已完成！`);
            resolve();
        })
      });

    });

  });
}

// let projects = "";
// if(process.argv.length<3){
//   console.log("缺少参数");
//   return;
// }
// projects = process.argv[2];

let exec = async function(){
  //压缩模板
  await runSpawn();
}

exec();



