import Cartoon from "./Cartoon"
import defaultData from "./defaultData"
import { jelly } from "./utils"

export default class GameLogic {
  g_cartoon = null;
  g_formData = null
  g_enableClick = true;
  g_canvas = null;
  g_systemOption = null;
  g_useDefaultData = false;
  g_curDragonDisplay = null;
  
  m_questionAudioPlayed = false;
  m_currentQuestion = -1;
  m_questionDone = false;
  m_currentQuestionArray = []
  m_gameEnd = false;
  constructor(formData, systemOption) {
    this.g_systemOption = systemOption;
    this.g_canvas = cc.find('Canvas');
    this.g_cartoon = new Cartoon(cc);

    if(!formData.contentObj.dataArray || formData.contentObj.dataArray.length == 0) {
      this.g_useDefaultData = true;
      this.g_formData = defaultData
      console.warn("User default data =>", this.g_formData)
    } else {
      this.g_formData = formData.contentObj;
      console.log("User saved data =>", this.g_formData)
    }
    
    this.disableClick("Sysyem_init")
    this.g_cartoon.initLocalAudios([])
    this.initMaskLayer();
  
    this.initBg()
    this.initNodes();
    this.resetPosition();
    this.addEventListener();
    this.initBottomButtons();
    this.initDragonContainers();
    this.loadQuestion(true)
    this.enableClick("Sysyem_init_done")

  }

  initNodes() {
  	this.g_cartoon.initCartoonElement("bgMain", this.g_cartoon.getNodeByPath(`Canvas/bgMain`))
  	this.g_cartoon.initCartoonElement("textDragonContainer", this.g_cartoon.getNodeByPath(`Canvas/text_container/DB`))
  	this.g_cartoon.initCartoonElement("rightDragonContainer", this.g_cartoon.getNodeByPath(`Canvas/right_container/dragonBones`))
    this.g_cartoon.initCartoonElement(`video_container`, this.g_cartoon.getNodeByPath(`Canvas/video_container`));
    this.g_cartoon.initCartoonElement(`video_container_video`, this.g_cartoon.getNodeByPath(`Canvas/video_container/video`));
    
    this.g_cartoon.initCartoonElement(`bottomButtons`, this.g_cartoon.getNodeByPath(`Canvas/bottomButtons`));
    this.g_cartoon.initCartoonElement(`btn_left`, this.g_cartoon.getNodeByPath(`Canvas/bottomButtons/btn_left`));
    this.g_cartoon.initCartoonElement(`btn_restart`, this.g_cartoon.getNodeByPath(`Canvas/bottomButtons/btn_restart`));
    this.g_cartoon.initCartoonElement(`btn_right`, this.g_cartoon.getNodeByPath(`Canvas/bottomButtons/btn_right`));
  }

  addEventListener() {
  	this.g_cartoon.subscribeTouchEvent("bgMain", ()=>{
  		this.playCurrentQuestion()
  	})
  }

  initBg() {
    const bgNode_A = cc.find('Canvas/bgMain/bg_A');
    bgNode_A.scale = this.g_systemOption.mapScaleMax;
    // bgNode_A.height = cc.winSize.height;
    // bgNode_A.width = cc.winSize.width;
    console.log(bgNode_A.height, bgNode_A.width)
  }

	playCurrentQuestion() {
    let rightDragon = this.g_cartoon.getCartoonElement("rightDragonContainer")
		var container = this.g_cartoon.getCartoonElement("video_container_video")
    this.g_cartoon.getCartoonElement("textDragonContainer").play()
		this.g_cartoon.playVideo(container.node.getComponent(cc.VideoPlayer), ()=>{
      rightDragon.play()
    })
	}

  initVideo() {
    var container = this.g_cartoon.getCartoonElement("video_container_video")
    var video = container.node.getComponent(cc.VideoPlayer)
  }

  initDragonContainers() {
		let textDragon = this.g_cartoon.getCartoonElement("textDragonContainer")
		textDragon.node.opacity = 255;
		textDragon.show = (callBack) => {
  		if(textDragon.node.opacity == 255) {
				if(callBack) {
        	callback()
        }
  		} else {
  			this.g_cartoon.tweenChange(textDragon.node, {opacity: 255}, 0.3, ()=>{
	        if(callBack) {
	        	callback()
	        }
	      });
  		}
  	}

  	textDragon.dragonBonesLoaded = null;
  	textDragon.play = (callback)=>{
  		if(textDragon.dragonBonesLoaded) {
  			textDragon.dragonBonesLoaded.showDragonBones(1, null, ()=>{

  			})
  		}
  	}

  	textDragon.setDragonBones = (dragon) => {
  		if(dragon && dragon.texPngData.url && dragon.skeJsonData.url && dragon.texJsonData.url) {
	      textDragon.dragonBones.setDragonBones(dragon, null, (handle)=>{
	      	textDragon.dragonBonesLoaded = handle;
	      })
	    } else{
        textDragon.dragonBones.deleteDragonBones()
	    	textDragon.dragonBonesLoaded = null;
	    }
  	}


  	let rightDragon = this.g_cartoon.getCartoonElement("rightDragonContainer")
  	rightDragon.node.opacity = 255;
  	rightDragon.show = (callBack) => {
  		if(rightDragon.node.opacity == 255) {
				if(callBack) {
        	callback()
        }
  		} else {
  			this.g_cartoon.tweenChange(rightDragon.node, {opacity: 255}, 0.3, ()=>{
	        if(callBack) {
	        	callback()
	        }
	      });
  		}
  	}

  	rightDragon.dragonBonesLoaded = null;
  	rightDragon.play = (callback)=>{
  		if(rightDragon.dragonBonesLoaded) {
  			rightDragon.dragonBonesLoaded.showDragonBones(1, null, ()=>{

  			})
  		}
  	}

  	rightDragon.setDragonBones = (dragon) => {
  		if(dragon && dragon.texPngData.url && dragon.skeJsonData.url && dragon.texJsonData.url) {
	      rightDragon.dragonBones.setDragonBones(dragon, null, (handle)=>{
	      	// let sx = 498 / handle._animationLoaded.node.width;
	      	// let sy = 98 / handle._animationLoaded.node.height;
	      	// let s = Math.min(sx, sy)
	      	// handle._animationLoaded.node.setScale(s, s)
	      	// handle._animationLoaded.node.width *= s;
	      	// handle._animationLoaded.node.height *= s;

	      	rightDragon.dragonBonesLoaded = handle;
	        // rightDragon.show(()=>{
	        //   handle.showDragonBones(0);
	        // }, ()=>{
	        //   // handle.showDragonBones();
	        // })
	      })
	    } else{
        rightDragon.dragonBones.deleteDragonBones()
	    	rightDragon.dragonBonesLoaded = null;
	    }
  	}
  }

  loadQuestion(isNext) {
  	if(isNext) {
			this.m_currentQuestion++;
  	} else {
  		this.m_currentQuestion--;
  	}

  	if(this.m_currentQuestion >= this.g_formData.dataArray.length) {
  		this.m_currentQuestion = this.g_formData.dataArray.length-1
  		return false;
  	} else if(this.m_currentQuestion <= -1) {
			this.m_currentQuestion = 0;
			return false;
  	}

  	let textDragon = this.g_formData.dataArray[this.m_currentQuestion].textDragonBones
  	let rightDragon = this.g_formData.dataArray[this.m_currentQuestion].rightDragonBones
  	this.g_cartoon.getCartoonElement("textDragonContainer").setDragonBones(textDragon)
  	this.g_cartoon.getCartoonElement("rightDragonContainer").setDragonBones(rightDragon)

    let video = this.g_cartoon.getCartoonElement("video_container_video")
    if(this.g_formData.dataArray[this.m_currentQuestion].video_url) {
      video.node.active = true;
      this.g_cartoon.getVideo(this.g_formData.dataArray[this.m_currentQuestion].video_url).then((clip=>{
        video.node.getComponent(cc.VideoPlayer).clip = clip
        this.playCurrentQuestion()
      }))
    } else {
      video.node.active = false;
      this.playCurrentQuestion()
    }

  	this.checkButtonDisable();
  	return true;
  }

	resetPosition() {
    const bottomButtons = this.g_cartoon.getCartoonElement("bottomButtons");
    bottomButtons.node.y = -cc.winSize.height / 2 + 50
  }

	initBottomButtons() {
		const btnLeft = this.g_cartoon.getCartoonElement("btn_left");
		const btnRight = this.g_cartoon.getCartoonElement("btn_right");
		const btnRestart = this.g_cartoon.getCartoonElement("btn_restart");

		this.g_cartoon.subscribeTouchEvent(btnLeft.key, ()=>{
			if(btnLeft.disable) {
				return
			}
			this.disableClick("btn_left")
			jelly(btnLeft.node)
			this.showMaskLayer(()=>{
				this.loadQuestion(false)
				this.hideMaskLayer(()=>{
					this.enableClick("btn_left")
				})
			})
		})

		this.g_cartoon.subscribeTouchEvent(btnRight.key, ()=>{
			if(btnRight.disable) {
				return
			}
			this.disableClick("btn_right")
			jelly(btnRight.node)
			this.showMaskLayer(()=>{
				this.loadQuestion(true)
				this.hideMaskLayer(()=>{
					this.enableClick("btn_right")
				})
			})
		})

		this.g_cartoon.subscribeTouchEvent(btnRestart.key, ()=>{
			jelly(btnRestart.node)
			this.playCurrentQuestion()
		})
	}

	checkButtonDisable() {
		const btnLeft = this.g_cartoon.getCartoonElement("btn_left");
		const btnRight = this.g_cartoon.getCartoonElement("btn_right");
		console.log("Check button disabe " + this.m_currentQuestion)
		if(this.m_currentQuestion <= 0) {
			btnLeft.node.opacity = 128;
			btnLeft.disable = true;
		} else {
			btnLeft.node.opacity = 255;
			btnLeft.disable = false;
		}

		if(this.m_currentQuestion >= this.g_formData.dataArray.length-1) {
			btnRight.node.opacity = 128;
			btnRight.disable = true;
		} else {
			btnRight.node.opacity = 255;
			btnRight.disable = false;
		}		
	}
  










  // Common function
  maskLayer = null;
  initMaskLayer() {
    const parentNode = this.g_cartoon.getNodeByPath("MaskLayer")
    parentNode.x = cc.winSize.width / 2
    parentNode.y = cc.winSize.height / 2
    const bNode = this.getSprNode('black');
    bNode.scaleX = cc.winSize.width / bNode.width;
    bNode.scaleY = cc.winSize.height / bNode.height;
    bNode.x = 0
    bNode.y = 0
    parentNode.setSiblingIndex(255)
    bNode.parent = cc.find('MaskLayer');
    bNode.active = false;
    this.maskLayer = bNode;
  }

  showMaskLayer(cb) {
    this.maskLayer.opacity = 0;
    this.maskLayer.active = true;
    cc.tween(this.maskLayer)
      .to(0.5, {opacity: 255}, {easing: 'sineOut'})
      .call(() => {
        cb()
      })
      .start()
  }

  hideMaskLayer(cb = null) {
    this.maskLayer.opacity = 255;
    cc.tween(this.maskLayer)
    .to(0.5, {opacity: 0}, {easing: 'sineIn'})
    .call(() => {
      this.maskLayer.active = false;
      if (cb) {
        cb()
      }
    })
    .start()
  }





  // Common API
  getSpriteFrimeByUrl(url, cb) {
		cc.assetManager.loadRemote(url, (err, img) => {
			const spriteFrame = new cc.SpriteFrame(img)
			if (cb) {
				cb(spriteFrame);
			}
		})
  }

  getSpriteFrimeByResName(name) {
    const sf = cc.find('Canvas/res/img/' + name).getComponent(cc.Sprite).spriteFrame;
    // const node = new cc.Node();
    // node.addComponent(cc.Sprite).spriteFrame = sf;
    return sf;
  }

  getSprNode(resName) {
    const sf = cc.find('Canvas/res/img/' + resName).getComponent(cc.Sprite).spriteFrame;
    const node = new cc.Node();
    node.addComponent(cc.Sprite).spriteFrame = sf;
    return node;
  }



  // Sysyem function
  checkClickEnable(eventName) {
    if(this.g_enableClick) {
      return true;
    } else {
      console.log(`Click disabled by event [${this.g_disableClickEventName}]!`)
      return false;
    }
  }

  disableClick(eventName) {
    this.g_enableClick = false;
    this.g_disableClickEventName = eventName
    // console.log(`Click disabled! [${eventName}]`)
  }

  enableClick(eventName) {
    this.g_enableClick = true;
    this.g_disableClickEventName = ""
    // console.log(`Click enabled! [${eventName}]`)
  }

}
