// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
import GameLogic from "./GameLogic"

// cc.game.onStart = function(){
// 	cc.director.runScene(new MyScene());
// 	console.log("Test")
// 	cc.game.run();
// };
// cc.game.run();
cc.Class({

	extends: cc.Component,
	gameLogic: null,
	properties: {

	},

	onStart() {
		
	},

	// 生命周期 onLoad
	onLoad() {
		this.initSceneData();
		this.initSize();
	},

	_imageResList: null,
	_audioResList: null,
	_animaResList: null,
	initSceneData() {
		this._imageResList = [];
		this._audioResList = [];
		this._animaResList = [];
	},

	_designSize: null,  // 设计分辨率
	_frameSize: null,  // 屏幕分辨率
	_mapScaleMin: null,  // 场景中常用缩放（取大值）
	_mapScaleMax: null,  // 场景中常用缩放（取小值）
	_cocosScale: null,  // cocos 自缩放 （较少用到）
	initSize() {

		// 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
		let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
		let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
		let f = screen_size >= design_size
		cc.Canvas.instance.fitHeight = f
		cc.Canvas.instance.fitWidth = !f

		const frameSize = cc.view.getFrameSize();
		this._frameSize = frameSize;

		this._designSize = cc.view.getDesignResolutionSize();

		let sx = cc.winSize.width / frameSize.width;
		let sy = cc.winSize.height / frameSize.height;
		this._cocosScale = Math.min(sx, sy);

		sx = frameSize.width / this._designSize.width;
		sy = frameSize.height / this._designSize.height;
		this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
		this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;
	},


	// 生命周期 start
	start() {
		let getData = this.getData.bind(this);
		if (window && window.courseware) {
			getData = window.courseware.getData;
		}

		getData((data) => {
			this.data = data || this.getDefaultData();
			this.data = JSON.parse(JSON.stringify(this.data))
			this.preloadItem()

			// 添加游戏逻辑
			this.gameLogic = new GameLogic(this.data, {
				designSize: this._designSize,
				frameSize: this._frameSize,
				mapScaleMin: this._mapScaleMin,
				mapScaleMax: this._mapScaleMax,
				cocosScale: this._cocosScale,
			});
		})
	},

	onDestory() {
		cc.audioEngine.stopAll()
	},

	getData(cb) {
		cb(this.getDefaultData());
	},

	getDefaultData() {
		// const dataJson = '{"contentObj":{"version":"1.0","key":"DataKey_Sbox_FT_08","bgMusic":"","titleText":"TEstd","questionAudio_url":"","dataArray":[{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/06cc843598a912921f6ca3acfde6220b.png","audio_url":"http://staging-teach.cdn.ireadabc.com/3b5540cc95a006dff8c41dba7537075a.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/571974922f6678111348a5643dba7e20.png"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/78579114773af12a7aec6723e3b9d475.png"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/c99e82e1c3f087c6dc0469e30c624f70.png"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/5b45c89ac9e899d76522767219b1346b.png"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/2e28eae8f0e0f01193da6f3677379ed3.png"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/fad2dac4f8b59a185dc30d42617c2ca8.png"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/6c3fca11052464102407f173e4a83db9.png"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/ec82c796af801486548ae98623f614d2.png"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/ac4b9422df1556f80ac5c3058cd3d670.png"}]}}'
		// const dataJson = '{"contentObj":{"version":"1.0","key":"DataKey_Sbox_FT_08","bgMusic":"http://staging-teach.cdn.ireadabc.com/ad58bae62ea02cf215ce7dee22df306f.mp3","titleText":"TEstd","questionAudio_url":"http://staging-teach.cdn.ireadabc.com/2bf96923b83ee0c5f20930386ce07384.mp3","dataArray":[{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/06cc843598a912921f6ca3acfde6220b.png","audio_url":"http://staging-teach.cdn.ireadabc.com/3b5540cc95a006dff8c41dba7537075a.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/571974922f6678111348a5643dba7e20.png","audio_url":"http://staging-teach.cdn.ireadabc.com/ae7c0930a45d0ffc9f13182298e2be71.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/78579114773af12a7aec6723e3b9d475.png","audio_url":"http://staging-teach.cdn.ireadabc.com/c14938125a52096dc0be9fbbf6638cb2.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/c99e82e1c3f087c6dc0469e30c624f70.png","audio_url":"http://staging-teach.cdn.ireadabc.com/135c628899396df62c14567f46d61f3f.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/5b45c89ac9e899d76522767219b1346b.png","audio_url":"http://staging-teach.cdn.ireadabc.com/3b5540cc95a006dff8c41dba7537075a.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/2e28eae8f0e0f01193da6f3677379ed3.png","audio_url":"http://staging-teach.cdn.ireadabc.com/cb0ac1d1bcdfdaf768f0a06d3fff37a3.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/fad2dac4f8b59a185dc30d42617c2ca8.png","audio_url":"http://staging-teach.cdn.ireadabc.com/9df3f14bc88bcffc49b6717c40428ed8.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/6c3fca11052464102407f173e4a83db9.png","audio_url":"http://staging-teach.cdn.ireadabc.com/d5a5ac2f45431a8a15492cb9f78e0396.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/ec82c796af801486548ae98623f614d2.png","audio_url":"http://staging-teach.cdn.ireadabc.com/fb08783926362bf64232e2ec6966011d.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/ac4b9422df1556f80ac5c3058cd3d670.png","audio_url":"http://staging-teach.cdn.ireadabc.com/fb08783926362bf64232e2ec6966011d.mp3"}]}}'
		// const dataJson = '{"contentObj":{"version":"1.0","key":"DataKey_Sbox_FT_08","bgMusic":"http://staging-teach.cdn.ireadabc.com/2bf96923b83ee0c5f20930386ce07384.mp3","titleText":"TEstd","questionAudio_url":"http://staging-teach.cdn.ireadabc.com/2bf96923b83ee0c5f20930386ce07384.mp3","dataArray":[{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/06cc843598a912921f6ca3acfde6220b.png","audio_url":"http://staging-teach.cdn.ireadabc.com/3b5540cc95a006dff8c41dba7537075a.mp3"},{"text":"","image_url":"http://staging-teach.cdn.ireadabc.com/571974922f6678111348a5643dba7e20.png","audio_url":"http://staging-teach.cdn.ireadabc.com/ae7c0930a45d0ffc9f13182298e2be71.mp3"}]}}'
		const dataJson = '{"contentObj":{"version":"1.0","key":"DataKey_Sbx_Pronunciation", "dataArray":[{"video_url":"http://staging-teach.cdn.ireadabc.com/82438e44e9e106cfa43d1fd62a24d61b.mp4","textDragonBones":{"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/2d668f8049bc98c0e026921ef316a0fd.png","name":"sb_boy_tex.png"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/ecc48e23d55b1af8eb40d997dc573791.json","name":"sb_boy_tex.json"},"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/363ea3636888e4f70037d69794956daa.json","name":"sb_boy_ske.json"}},"rightDragonBones":{"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/2d668f8049bc98c0e026921ef316a0fd.png","name":"sb_boy_tex.png"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/ecc48e23d55b1af8eb40d997dc573791.json","name":"sb_boy_tex.json"},"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/8b1a3ca16c2810028d61b80978631edf.json","name":"sb_boy_ske.json"}}},{"video_url":"http://staging-teach.cdn.ireadabc.com/f25bb33cdb266345667a1bec58818175.mp4","textDragonBones":{"skeJsonData":{"url":"","name":""},"texJsonData":{"url":"","name":""},"texPngData":{"url":"","name":""}},"rightDragonBones":{"skeJsonData":{"url":"","name":""},"texJsonData":{"url":"","name":""},"texPngData":{"url":"","name":""}}}],"theme":"D"},"border_image_url":"http://staging-teach.cdn.ireadabc.com/e9ce15bcb9165a8416799df5597f01e6.jpg","video_image_url":"http://staging-teach.cdn.ireadabc.com/308cc7a44debd884b12508a7fcad83ab.jpg","text_image_url":"http://staging-teach.cdn.ireadabc.com/389033602b7468ceb2a34845b0063ea1.jpg"}'
		const data = JSON.parse(dataJson);
		return data;
	},

	preloadItem() {
		this.addPreloadImage();
		this.addPreloadAudio();
		this.addPreloadAnima();
		this.preload();
	},


	addPreloadImage() {

		if (!this.data.dataArray) {
			return;
		}

		this.data.dataArray.forEach(item=>{
			this._imageResList.push({ url: item.question.centerImage_url});
		})
	

	},

	addPreloadAudio() {

		this._audioResList.push({ url: this.data.audio_url });
	},

	addPreloadAnima() {
		if (!this.data.dataArray) {
			return;
		}
		this.data.dataArray.forEach((item) => {
			if (item.dragonBones) {
				this._animaResList.push({url: item.dragonBones.skeJsonData.url});
				this._animaResList.push({url: item.dragonBones.texJsonData.url});
				this._animaResList.push({url: item.dragonBones.texPngData.url});
			}
		})
	},

	preload() {

		const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
		cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {

			this.loadEnd();
			if (window && window["air"]) {
				window["air"].hideAirClassLoading();
			}

			cc.debug.setDisplayStats(false);
		});
	},


	loadEnd() {
		this.initData();
	},

	_cantouch: null,
	initData() {
		// 所有全局变量 默认都是null 
		this._cantouch = true;
	},


















	// ------------------------------------------------
	getSprNode(resName) {
		const sf = cc.find('Canvas/res/img/' + resName).getComponent(cc.Sprite).spriteFrame;
		const node = new cc.Node();
		node.addComponent(cc.Sprite).spriteFrame = sf;
		return node;
	},

	getSprNode(resName) {
		const sf = cc.find(resName).getComponent(cc.Sprite).spriteFrame;
		const node = new cc.Node();
		node.addComponent(cc.Sprite).spriteFrame = sf;
		return node;
	},


	getSpriteFrimeByUrl(url, cb) {
		cc.assetManager.loadRemote(url, (err, img) => {
			const spriteFrame = new cc.SpriteFrame(img)
			if (cb) {
				cb(spriteFrame);
			}
		})
	},

	getSprNodeByUrl(url, cb) {
		const node = new cc.Node();
		const spr = node.addComponent(cc.Sprite);
		this.getSpriteFrimeByUrl(url, (sf) => {
			spr.spriteFrame = sf;
			if (cb) {
				cb(node);
			}
		})
	},

	playAudioByUrl(audio_url, cb = null) {
		if (audio_url) {
			cc.assetManager.loadRemote(audio_url, (err, audioClip) => {
				const audioId = cc.audioEngine.play(audioClip, false, 0.8);
				if (cb) {
					cc.audioEngine.setFinishCallback(audioId, () => {
						cb();
					});
				}
			});
		}
	},

	// ------------------------------------------

});
