export function getPosByAngle(angle, len) {

    const radian = angle * Math.PI / 180;
    const x = Math.sin(radian) * len;
    const y = Math.cos(radian) * len;

    return { x, y };

}

export function getAngleByPos(px, py, mx, my) {

    const x = Math.abs(px - mx);
    const y = Math.abs(py - my);

    const z = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
    const cos = y / z;
    const radina = Math.acos(cos); // 用反三角函数求弧度
    let angle = Math.floor(180 / (Math.PI / radina) * 100) / 100; // 将弧度转换成角度

    if (mx > px && my > py) {// 鼠标在第四象限
        angle = 180 - angle;
    }
    if (mx === px && my > py) {// 鼠标在y轴负方向上
        angle = 180;
    }
    if (mx > px && my === py) {// 鼠标在x轴正方向上
        angle = 90;
    }
    if (mx < px && my > py) {// 鼠标在第三象限
        angle = 180 + angle;
    }
    if (mx < px && my === py) {// 鼠标在x轴负方向
        angle = 270;
    }
    if (mx < px && my < py) {// 鼠标在第二象限
        angle = 360 - angle;
    }

    // console.log('angle: ', angle);
    return angle;

}

export function exchangeNodePos(baseNode, targetNode) {
    return baseNode.convertToNodeSpaceAR(targetNode._parent.convertToWorldSpaceAR(cc.v2(targetNode.x, targetNode.y)));
}

export function RandomInt(a, b = 0) {
    let max = Math.max(a, b);
    let min = Math.min(a, b);
    return Math.floor(Math.random() * (max - min) + min);
}

export function Between(a, b, c) {
    return [a, b, c].sort((a, b) => a - b)[1];
}

export function randomSortByArr(arr) {
    const newArr = [];
    const tmpArr = arr.concat();
    while (tmpArr.length > 0) {
        const randomIndex = Math.floor(tmpArr.length * Math.random());
        newArr.push(tmpArr[randomIndex]);
        tmpArr.splice(randomIndex, 1);
    }
    return newArr;
}

export async function asyncTweenTo(node, duration, obj, ease = undefined) {
    return new Promise((resolve, reject) => {
        cc.tween(node)
            .to(duration, obj, ease)
            .call(() => {
                resolve();
            })
            .start();
    });
}

export async function asyncTweenBy(node, duration, obj, ease = undefined) {
    return new Promise((resolve, reject) => {
        cc.tween(node)
            .by(duration, obj, ease)
            .call(() => {
                resolve();
            })
            .start();
    });
}

export async function asyncPlayDragonBoneAnimation(node, animationName, time = 1, onFrameEvent) {
    return new Promise((resolve, reject) => {
        node.getComponent(dragonBones.ArmatureDisplay)
            .once(dragonBones.EventObject.COMPLETE, () => {
                resolve();
            });

        node.getComponent(dragonBones.ArmatureDisplay)
            .on(dragonBones.EventObject.FRAME_EVENT, ({ name }) => {
                if (onFrameEvent && typeof (onFrameEvent) == 'function') {
                    onFrameEvent(name);
                }
            });

        node.getComponent(dragonBones.ArmatureDisplay)
            .playAnimation(animationName, time);
    });
}

export async function asyncPlayEffectByUrl(url, loop = false) {
    return new Promise((resolve, reject) => {
        cc.assetManager.loadRemote(url, (err, clip) => {
            console.log(clip);
            cc.audioEngine.playEffect(clip, loop);
            resolve();
        });
    });
}

export function jelly(node) {
    console.log("Jelly")
    return new Promise((resolve, reject) => {
        cc.tween(node)
            .to(0.1, { scaleX: 0.9, scaleY: 1.1 })
            .to(0.1, { scaleX: 1.1, scaleY: 0.9 })
            .to(0.1, { scaleX: 1, scaleY: 1 })
            .call(resolve)
            .start();
    });
}

export async function asyncDelay(time) {
    return new Promise((resolve, reject) => {
        setTimeout(() => {
            resolve();
        }, time * 1000);
    })
}

export async function showFireworks(baseNode, nodeList, pos = cc.v2(0, 0), side = cc.v2(0, 100), range = 50, number = 100) {
    new Array(number).fill(' ').forEach(async (_, i) => {

        let rabbonNode = new cc.Node();
        rabbonNode.parent = baseNode;
        rabbonNode.x = pos.x;
        rabbonNode.y = pos.y;
        rabbonNode.angle = 60 * Math.random() - 30;

        let node = cc.instantiate(nodeList[RandomInt(nodeList.length)]);
        node.parent = rabbonNode;
        node.active = true;
        node.x = 0;
        node.y = 0;
        node.angle = 0;

        const rate = Math.random();
        const angle = Math.PI * (Math.random() * 2 - 1);

        await asyncTweenBy(rabbonNode, 0.3, {
            x: side.x * rate + Math.cos(angle) * range * rate,
            y: side.y * rate + Math.sin(angle) * range * rate
        }, {
            easing: 'quadIn'
        });

        cc.tween(rabbonNode)
            .by(8, { y: -2000 })
            .start();

        rabbonFall(rabbonNode);

        await asyncDelay(Math.random());
        cc.tween(node)
            .by(0.15, { x: -10, angle: -10 })
            .by(0.3, { x: 20, angle: 20 })
            .by(0.15, { x: -10, angle: -10 })
            .union()
            .repeatForever()
            .start();

        cc.tween(rabbonNode)
            .delay(5)
            .to(0.3, { opacity: 0 })
            .call(() => {
                node.stopAllActions();
                node.active = false;
                node.parent = null;
                node = null;
            })
            .start();
    });
}

async function rabbonFall(node) {
    const time = 1 + Math.random();
    const offsetX = RandomInt(-200, 200) * time;
    await asyncTweenBy(node, time, { x: offsetX, angle: offsetX * 60 / 200 });
    rabbonFall(node);
}