import {
    Label,
    MySprite, ShapeRectNew,
    ShapeCircle,
    tweenChange,
    ShapeRect
} from './Unit';

import {
    Exercises
} from './Exercises';

export class Skin {

    skinType;

    images;

    scaleX = 1;

    scaleY = 1;

    bg;

    intervalHeight = 0;

    intervalWidth = 0;

    contentBgWidth = 0;



    constructor(skinType, images) {
        this.skinType = skinType;

        this.images = images;

        
    }

    setScaleXY(sacle: number) {
        this.scaleX = this.scaleY = sacle;

        if (this.skinType == 'B') {
            this.intervalHeight = 56 * this.scaleY;

            this.intervalWidth = 28 * this.scaleX;
        
            this.contentBgWidth = 348 * this.scaleX;
        }
        else{
            this.intervalHeight = 110 * this.scaleY;

            this.intervalWidth = 63 * this.scaleX;
        
            this.contentBgWidth = 320 * this.scaleX;
        }
    }

    initBg(renderArr, canvasWidth: number, canvasHeight: number) {

        if (this.skinType == 'B') {
            const bg = new MySprite();
            bg.init(this.images.get('skin_2_bg'));
            let bgScale = Math.max(canvasWidth / bg.width, canvasHeight / bg.height);
            bg.setScaleXY(bgScale);
            bg.x = canvasWidth / 2;
            bg.y = canvasHeight / 2;

            this.bg = bg;

            renderArr.push(bg);

            const grass = new MySprite();
            grass.init(this.images.get('grass'));
            grass.scaleX = this.scaleX;
            grass.scaleY = this.scaleY;
            grass.x = canvasWidth - grass.getBoundingBox().width / 2;
            grass.y = canvasHeight - grass.getBoundingBox().height / 2;
            renderArr.push(grass);

        }

    }

    initExercises(exercises: Exercises, i) {

        if (this.skinType == 'B') {
            this.setExercisesSkinB(exercises);
        }
        else {
            this.setExercisesSkinA(exercises, i);
        }

    }

    private setExercisesSkinA(exercises: Exercises, i) {
        const getColor = (i) => {
            if (i % 2 == 0) {
                return { bgColor: "#E5E4E3" };
            }
            else {
                return { bgColor: "#C7C8CB" };
            }
        }

        //背景
        const bg = new ShapeRect();
        exercises.bg = bg;
        bg.fillColor = getColor(i).bgColor;

        bg.setSize(320 * this.scaleX, 88 * this.scaleY);

        const textLabel = new Label();
        exercises.textLabel = textLabel;
        textLabel.text = exercises.exercisesData.text;
        textLabel.textAlign = 'middle';
        textLabel.fontSize = 48;
        textLabel.fontName = "FUTURAB";
        textLabel.fontColor = "#626262";
        textLabel.setMaxSize(bg.width);
        textLabel.refreshSize();
        textLabel.x = (bg.width - textLabel.width) / 2;
        textLabel.y = bg.height / 2;
        bg.addChild(textLabel);

        const indexBg = new MySprite();
        indexBg.init(this.images.get('skin_2_index_bg'));
        indexBg.scaleX = this.scaleX;
        indexBg.scaleY = this.scaleY;
        indexBg.x = bg.width / 2;
        indexBg.y = - indexBg.getBoundingBox().height / 2 + 14 * this.scaleY;
        exercises.indexBg = indexBg;
        bg.addChild(indexBg);

        const indexLabel = new Label();
        exercises.indexLabel = indexLabel;
        indexLabel.text = exercises.exercisesData.index;
        indexLabel.textAlign = 'middle';
        indexLabel.fontSize = 48;
        indexLabel.fontName = "BRLNSDB";
        indexLabel.fontColor = "#000000";
        indexLabel.setMaxSize(indexBg.getBoundingBox().width);
        indexLabel.refreshSize();
        indexLabel.x = - indexLabel.width / 2 + 6 * this.scaleX;
        indexLabel.y = - 6 * this.scaleY;
        indexLabel.alpha = 0;
        indexBg.addChild(indexLabel);
    }

    private setExercisesSkinB(exercises: Exercises) {

        const textLabel = new Label();
        exercises.textLabel = textLabel;
        textLabel.text = exercises.exercisesData.text;
        textLabel.textAlign = 'middle';
        textLabel.fontSize = 48;
        textLabel.fontName = "GOTHIC";
        textLabel.fontColor = "#000000";
        textLabel.refreshSize();

        
        
       

        const indexLabel = new Label();
        exercises.indexLabel = indexLabel;
        indexLabel.text = exercises.exercisesData.index;
        indexLabel.textAlign = 'middle';
        indexLabel.fontSize = 36;
        indexLabel.fontName = "BRLNSDB";
        indexLabel.fontColor = "#316900";
        indexLabel.alpha = 0;
        indexLabel.refreshSize();

        const indexBg = new ShapeRect();
        indexBg.setSize(40 * this.scaleX, 40 * this.scaleY);
        indexBg.visible = false;
        indexBg.childDepandVisible = false;
        indexBg.addChild(indexLabel);
        exercises.indexBg = indexBg;
        indexLabel.x = (indexBg.width - indexLabel.getBoundingBox().width )/ 2;
        indexLabel.y = indexBg.height / 2

        //树桩
        const stump = new MySprite();
        exercises.bg = stump;

        //默认大树桩
        let imageKey = "stump_b";


        let textMargin = { marginTop: 37 * this.scaleY, marginLeft: 70 * this.scaleX, maxWidth: 219 * this.scaleX };

        let indexMargin = { marginTop: 93 * this.scaleY, marginLeft: 164 * this.scaleX };
        if (textLabel.width < 110 * this.scaleX) {

            //取小树桩
            imageKey = "stump_s"
            indexMargin.marginLeft = 109 * this.scaleX;
            indexMargin.marginTop = 91 * this.scaleY;

            textMargin.marginLeft = 71 * this.scaleX;
            textMargin.marginTop = 31 * this.scaleY;
            textMargin.maxWidth = 110 * this.scaleX;
        }
        else if (textLabel.width <= 153 * this.scaleX) {

            //取中等树桩
            imageKey = "stump_m"

            indexMargin.marginLeft = 151 * this.scaleX;
            indexMargin.marginTop = 90 * this.scaleY;

            textMargin.marginLeft = 89 * this.scaleX;
            textMargin.marginTop = 28 * this.scaleY;
            textMargin.maxWidth = 153 * this.scaleX;
        }
        else {

            //设置最大宽度
            textLabel.setMaxSize(219 * this.scaleX);
        }

        stump.init(this.images.get(imageKey));
        stump.scaleX = this.scaleX;
        stump.scaleY = this.scaleY;

        let width = stump.getBoundingBox().width;

        let height = stump.getBoundingBox().height

        textLabel.x = -width / 2 + textMargin.marginLeft + (textMargin.maxWidth - textLabel.getBoundingBox().width) / 2;
        textLabel.y = -height / 2 + textMargin.marginTop + textLabel.getBoundingBox().height / 2;
        stump.addChild(textLabel);

        indexBg.x = -width / 2 + indexMargin.marginLeft;
        indexBg.y = -height / 2 + indexMargin.marginTop;
        stump.addChild(indexBg);


    }

    getIntervalHeight(){
        return this.intervalHeight;
    }

    getIntervalWidth(){
        return this.intervalWidth;
    }

    getContentBgWidth(){
        return this.contentBgWidth;
    }
}