import {
    Label,
    MySprite, ShapeRectNew,
    ShapeCircle,
    tweenChange,
    ShapeRect
} from './Unit';

import {
    playAudio,
    pauseAudio

} from './AudioUtil';

import {
    Skin
} from './Skin'

export class Exercises {

    audio;

    indexAudio;

    images;

    exercisesData;

    bg;

    //隐藏背景
    bg2;

    textLabel;

    indexLabel;

    indexBg;

    index;

    indexShowed = false;

    scaleX = 1;

    scaleY = 1;

    constructor(exercisesData, images) {
        this.exercisesData = exercisesData;

        this.images = images;

        this.index = exercisesData.index;
    }

    init(skin: Skin, i) {

        skin.initExercises(this, i);


    }

    initBg2(width, height) {

        //最底部背景
        const bg2 = new ShapeRect();
        bg2.alpha = 0;
        bg2.addChild(this.bg);
        bg2.setSize(width, height);

        if (this.bg instanceof ShapeRect) {
            this.bg.x = (width - this.bg.width) / 2;
            this.bg.y = 0;
        }
        else {
            this.bg.x = width / 2;
            this.bg.y = height - this.bg.getBoundingBox().height / 2;
        }


        this.bg2 = bg2;
    }

    checkRight(curIndex) {
        if (!curIndex) {
            return;
        }

        if (curIndex == this.index) {
            this.indexLabel.alpha = 1;
            this.indexShowed = true;
            return true;
        }
        else {
            return false;
        }

    }

    playAudio(type, callback = null) {

        if (type == 'T') {
            playAudio(this.audio, true);
            return this.audio;
        }
        else if (type == 'I') {
            playAudio(this.indexAudio, true);
            return this.indexAudio;
        }
    }

    getHeight() {
        return this.bg.getBoundingBox().height;
    }

    getWidth() {
        return this.bg.getBoundingBox().width;
    }
}