import {
    Label,
    MySprite, ShapeRectNew,
    ShapeCircle,
    tweenChange,
    ShapeRect
} from './Unit';

import {
    playAudio,
    pauseAudio

} from './AudioUtil';

export class Listening {

    audio;

    images;

    bg;

    btnPlay;

    btnStop;

    playing = false;

    constructor(audio, images) {
        this.audio = audio;

        this.images = images;
    }

    init(scaleX = 1, scaleY = 1) {

        const bg = new ShapeRect();

        const btnPlay = new MySprite();
        btnPlay.init(this.images.get('play'));
        btnPlay.scaleX = scaleX;
        btnPlay.scaleY = scaleY;
        btnPlay.x = btnPlay.getBoundingBox().width / 2
        btnPlay.y = btnPlay.getBoundingBox().height / 2
        this.btnPlay = btnPlay;
        bg.addChild(btnPlay);


        const btnStop = new MySprite();
        btnStop.init(this.images.get('stop'));
        btnStop.x = btnPlay.x;
        btnStop.y = btnPlay.y;
        btnStop.alpha = 0;
        btnStop.scaleX = scaleX;
        btnStop.scaleY = scaleY;
        this.btnStop = btnStop;
        bg.addChild(btnStop);

        bg.setSize(btnPlay.getBoundingBox().width, btnPlay.getBoundingBox().height);
        bg.alpha = 0;
        this.bg = bg;
    }

    play(callback = null){
       console.log('playing:', this.playing);
        if(!this.playing){
            this.playAudio(callback);
            return this.audio;
        }
        else{
            this.pauseAudio(callback);
        }

        return null;
    }

    playAudio(callback = null){
        
        this.btnPlay.alpha = 0;
        this.btnStop.alpha = 1;

        playAudio(this.audio, false, callback);

        this.playing = true;

        return this.audio;
    }

    pauseAudio(callback){

        this.btnPlay.alpha = 1;
        this.btnStop.alpha = 0;

        this.playing = false;

        pauseAudio(this.audio, false, callback)
    }
}