
import {
    Label,
    MySprite, ShapeRect,

} from './Unit';

import {
    playAudio,
    pauseAudio

} from './AudioUtil';

export class Title {

    titleBg: ShapeRect;

    audio;

    images;

    titleData;


    constructor(titleData, images) {

        this.titleData = titleData;

        this.images = images;
    }

    init(mapScaleX = 1, mapScaleY = 1) {
        //初始化标题1背景
        const titePart1Bg = new MySprite();
        titePart1Bg.init(this.images.get('titlePart1Bg'));
        titePart1Bg.scaleX = mapScaleX;
        titePart1Bg.scaleY = mapScaleY;
        titePart1Bg.x = titePart1Bg.getBoundingBox().width / 2;
        

        //标题1内容
        const part1 = new Label();
        part1.text = this.titleData.part1;
        part1.textAlign = 'middle';
        part1.fontSize = 48;
        part1.fontName = "BRLNSDB";
        part1.fontColor = "#AB5B22";
        part1.refreshSize();
        part1.x = - part1.getBoundingBox().width / 2;
        titePart1Bg.addChild(part1);

        //标题2内容
        const part2 = new Label();
        part2.text = this.titleData.part2;
        part2.fontSize = 36;
        part2.fontName = "FUTURAB";
        part2.fontColor = "#000000";
        part2.refreshSize();
        part2.x = titePart1Bg.getBoundingBox().width + 11 * mapScaleX;
        part2.y = 10 * mapScaleY + part2.getBoundingBox().height / 2;

        let height = Math.max(titePart1Bg.getBoundingBox().height, part2.getBoundingBox().height);
        let width = titePart1Bg.getBoundingBox().width + part2.getBoundingBox().width + 11 * mapScaleX;


        let titleBg = new ShapeRect();
        titleBg.setSize(width, height);
        titleBg.alpha = 0;


        titePart1Bg.y = height / 2;
        titleBg.addChild(titePart1Bg);

        part2.y = height / 2;
        titleBg.addChild(part2);

        this.titleBg = titleBg;
    }

    getTitleBg(){
        return this.titleBg;
    }

    setAudio(audio){
        this.audio = audio;
    }

    playAudio(callback = null){
        playAudio(this.audio, true, callback);
        return this.audio;
    }

    pasueAudio(callback){
        pauseAudio(this.audio, true, callback)
    }
}

export function getDefaultTile() {
    let title = {
        part1: 'A',
        part2: 'Read and point',
        audio_url: ''
    };

    return title;
}