import {
  AfterViewInit,
  Component,
  ElementRef, 
  Input,
  OnChanges,
  OnDestroy,
  OnInit, 
  ViewChild
} from '@angular/core'; 


@Component({
  selector: 'app-player-content-wrapper',
  templateUrl: './player-content-wrapper.component.html',
  styleUrls: ['./player-content-wrapper.component.scss']
})
export class PlayerContentWrapperComponent implements OnInit, OnChanges, OnDestroy, AfterViewInit {


  @ViewChild('wrapperEl') wrapperEl: ElementRef;

  // // aspect ratio?
  @Input() ratio;
  _w: string;
  _h: string;
 
  constructor() { 
    if (window.innerHeight < window.innerWidth) {
      this._h = '100%';
      this._w = 'auto';
    } else {
      this._w = '100%';
      this._h = 'auto';
    } 
  }
  ngOnInit() {
    if (!this.ratio) {
      this.ratio = '20-9';
    }


  }
  ngOnChanges() {

  }
  ngOnDestroy(): void {

  }

  ngAfterViewInit() {

  }
}

