import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef} from '@angular/core';



@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "YM-42";
  // 储存对象
  item;

  constructor(private appRef: ApplicationRef,private changeDetectorRef: ChangeDetectorRef) {

  }


  ngOnInit() {

    this.item = {};

    this.item.title = this.getDefaultTile();

    this.item.exercisesArr = [];

    console.log('item:', this.item);

    // 获取存储的数据
    (<any> window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      console.log('item:', this.item);
      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);

  }


  ngOnChanges() {
  }

  ngOnDestroy() {
  }

  init() {

    if(!this.item.title){
      this.item.title = this.getDefaultTile();
    }

    //设置默认皮肤
    if(!this.item.skin){
      this.item.skin = "A";
    }

    if(!this.item.exercisesArr || this.item.exercisesArr.length == 0){

      this.item.exercisesArr = [];

      for(let i = 0; i < 6; ++ i){

        let exercises = this.getDefaultExercisesItem();

        this.item.exercisesArr.push(exercises);

      }
    }
  }


  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, item, key) {

    item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, item, key) {

    item[key] = e.url;
    this.save();
  }



  /**
   * 储存数据
   */
  save() {
    (<any> window).courseware.setData(this.item, null, this.saveKey);
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }


  /**
   * 获取缺省的练习题内容
   */
  getDefaultExercisesItem(){
    const exercises = {
      text:'',
      pic_url:'',
      audio_url:'',
      letters:[]
    };

    return exercises;
  }

  getDefaultTile(){
    const title = {
      part1:'',
      part2:'',
      audio_url:''
    };

    return title;
  }

  /**
   * 获取默认的字母
   */
  getDefaultLetter(){
    let letter = {
      val:'',
      isColor:'0'
    };

    return letter;
  }

  addLetter(exercises) {

    let letter = this.getDefaultLetter();

    exercises.letters = [...exercises.letters, letter];

    this.save();
  }

  delLetter(exercises, index) {
    if (index !== -1) {
      exercises.letters.splice(index, 1);
      exercises.letters = [...exercises.letters];
      this.save();
    }
  }
}

