import {
    Label,
    MySprite, ShapeRectNew,
    ShapeCircle,
    tweenChange,
    ShapeRect
} from './Unit';

import {
    playAudio,
    pauseAudio

} from './AudioUtil';

export class Exercises {

    audio;

    images;

    exercisesData;

    bg;

    textLabelArr = [];

    bigCard;

    cardBg;

    contentBg1;

    closePic;

    overturnPic;

    contentBg2;

    canClick = true;

    canClickCard = false;

    showed = false;

    curCard;

    showBg;

    scaleX = 1;

    scaleY = 1;

    skin;

    constructor(exercisesData, images) {
        this.exercisesData = exercisesData;

        this.images = images;
    }

    init(skin, scaleX = 1, scaleY = 1) {

        this.scaleX = scaleX;

        this.scaleY = scaleY;

        this.skin = skin;

        let type = '1';

        if (this.exercisesData.index % 2 == 0) {
            type = '2';
        }

        let outLineColor = "#aacce9";

        if (skin == 'A') {
            this.initA(scaleX, scaleY, type);
            outLineColor = "#fbd8c1";
        }
        else {
            this.initB(scaleX, scaleY, type);
        }

        let width = 1101 * scaleX;
        let height = 479 * scaleY;

        const cardBg = new MySprite();
        cardBg.init(this.images.get('box'));
        cardBg.scaleX = scaleX;
        cardBg.scaleY = scaleY;
        cardBg.alpha = 0;
        this.cardBg = cardBg;

        const bigCard = new ShapeRectNew();
        bigCard.setOutLine(outLineColor, 20 * scaleY);
        bigCard.setSize(width, height, 25 * scaleY);
        bigCard.x = -width / 2;
        bigCard.y = -height / 2;
        this.bigCard = bigCard;

        cardBg.addChild(bigCard);

        this.initBigCard1(bigCard, skin);

        this.initBigCard2(bigCard, skin);

        //默认显示内容1
        this.showBg = this.contentBg1;

        this.closePic = this.getColsePic(bigCard);

        this.overturnPic = this.getOverturnPic(bigCard);

        cardBg.setScaleXY(0);
    }

    /**
     * 设置最大的宽度，并返回新的最大宽度
     * @param textLabelArr 
     * @param w 
     */
    private setMaxScale(textLabelArr, w){

        let scale = 1;      

        let width = 0;

        for(let i = 0; i < textLabelArr.length; ++i){
            var textLabel = textLabelArr[i];
            width += textLabel.getBoundingBox().width;

            scale = textLabel.scaleX;
        }

        if(width >= w){
            scale *= w / width;
        }
        else{
            return width;
        }
        
        width = 0;

        //设置scale，并重新计算宽度
        for(let i = 0; i < textLabelArr.length; ++i){

            var textLabel = textLabelArr[i];
            textLabel.setScaleXY(scale);
            textLabel.refreshSize();
           
            width += textLabel.getBoundingBox().width;
        }

        return width;
    }

    /**
     * 设置x坐标
     * @param textLabelArr 
     * @param totalWidth
     * @param skin 
     */
    private resetX(textLabelArr, totalWidth, skin){

        var startX = 0;

        if(skin == 'B'){
            startX = (this.bg.width - totalWidth) / 2;
        }
        else{
            startX = this.scaleX * 100;
        }

        for (let i = 0; i < textLabelArr.length; ++i) {

            var textLabel = textLabelArr[i];

            textLabel.x = startX;

            startX += textLabel.getBoundingBox().width;
            
        }
    }

    private addText(bg: ShapeRectNew, skin) {

        let totalWidth = 0;

        for (let i = 0; i < this.exercisesData.letters.length; ++i) {

            var letter = this.exercisesData.letters[i];

            //内容
            const text = new Label();
            text.text = letter.val;

            text.fontName = "GOTHIC";
            let fontColor = "";

            let fontSize = 48;

            if (skin == 'B') {
                if (letter.isColor === '0') {
                    fontColor = "#717071";
                }
                else {
                    fontColor = "#cc2a2e";
                }
                
            }
            else {
                fontSize = 56;
                if (letter.isColor === '0') {
                    fontColor = "#000000";
                }
                else {
                    fontColor = "#cc2a2e";
                }
            }
            text.fontColor = fontColor;
            text.fontSize = fontSize;
            text.y = bg.height / 2;
            
            this.textLabelArr.push(text);
            text.refreshSize();

            totalWidth += text.getBoundingBox().width;
            bg.addChild(text);
        }

        //计算最大的scale
        totalWidth = this.setMaxScale(this.textLabelArr, bg.width - 96 * this.scaleX);

        this.resetX(this.textLabelArr, totalWidth, this.skin);
    }

    private initB(scaleX = 1, scaleY = 1, type) {

        const getColor = (type) => {
            if (type == '1') {
                return { outLine: '#53748f', index: '#f5af80' };
            }
            else {
                return { outLine: '#aacce9', index: '#f5af80' };
            }
        };

        let color = getColor(type);

        let width = 560 * scaleX;
        let height = 96 * scaleY;

        const bg = new ShapeRectNew();
        bg.setOutLine(color.outLine, 8 * scaleY);
        bg.setSize(width, height, 48 * scaleY);
        this.bg = bg;



        const indexBg = new ShapeCircle();
        indexBg.setRadius(30 * scaleX);
        indexBg.fillColor = color.index;
        indexBg.x = width / 2;
        indexBg.y = -(indexBg.height / 2 - 10 * scaleY);
        bg.addChild(indexBg);

        //顺序
        const index = new Label();
        index.text = this.exercisesData.index;
        index.textAlign = 'middle';
        index.fontSize = 48;
        index.fontName = "BRLNSDB";
        index.fontColor = "#FFFFFF";
        index.setMaxSize(indexBg.width);
        index.x = - index.width / 2;
        indexBg.addChild(index);

        //内容
        this.addText(bg, this.skin);
    }

    private initA(scaleX = 1, scaleY = 1, type) {

        const getColor = (type) => {
            if (type == '1') {
                return { fillColor: '#E5E3E4', index: '#fbd8c1' };
            }
            else {
                return { fillColor: '#E5E3E4', index: '#fbd8c1' };
            }
        };

        let color = getColor(type);

        let width = 550 * scaleX;
        let height = 80 * scaleY;

        const bg = new ShapeRectNew();
        bg.fillColor = color.fillColor;
        bg.setSize(width, height, 40 * scaleY);
        this.bg = bg;

        const indexBg = new ShapeCircle();
        indexBg.setRadius(44 * scaleX);
        indexBg.fillColor = color.index;
        indexBg.x = 44 * scaleX;
        indexBg.y = height / 2;
        bg.addChild(indexBg);

        //顺序
        const index = new Label();
        index.text = this.exercisesData.index;
        index.textAlign = 'middle';
        index.fontSize = 64;
        index.fontName = "TCB";
        index.fontColor = '#ec6101';
        index.setMaxSize(45 * scaleX);
        index.x = - index.width / 2;
        indexBg.addChild(index);

        //内容
        this.addText(bg, this.skin);
    }

    private getContentBg(parent) {
        let width = parent.width - 40 * parent.scaleX;

        let height = parent.height - 40 * parent.scaleY;

        const constantBg = new ShapeRect();
        constantBg.setSize(width, height);
        constantBg.fillColor = '#FFFFFF';
        constantBg.alpha = 1;
        constantBg.visible = false;
        constantBg.x = 20 * parent.scaleX;
        constantBg.y = 20 * parent.scaleY;
        parent.addChild(constantBg);

        return constantBg;
    }


    private initBigCard1(parent, skin) {

        const addText = (bg: ShapeRect, skin, fontSize) => {

            let totalWidth = 0;

            let textLabelArr = [];

            for (let i = 0; i < this.exercisesData.letters.length; ++i) {

                let letter = this.exercisesData.letters[i];

                //内容
                const text = new Label();
                text.text = letter.val;
                text.fontName = "GOTHICB";
                let fontColor = "";

                if (skin == 'B') {
                    if (letter.isColor === '0') {
                        fontColor = "#717071";
                    }
                    else {
                        fontColor = "#cc2a2e";
                    }
                }
                else {
                    if (letter.isColor === '0') {
                        fontColor = "#000000";
                    }
                    else {
                        fontColor = "#cc2a2e";
                    }
                }
                text.fontColor = fontColor;
                text.fontSize = fontSize;
                text.y = bg.height / 2;

                textLabelArr.push(text);
                text.refreshSize();

                totalWidth += text.getBoundingBox().width;

            }
            
            totalWidth = this.setMaxScale(textLabelArr, 960 * this.scaleX);
            
            var startX = (bg.width - totalWidth) / 2;

            for (let i = 0; i < textLabelArr.length; ++i) {

                var textLabel = textLabelArr[i];

                textLabel.x = startX;

                startX += textLabel.getBoundingBox().width;

                bg.addChild(textLabel);

            }
        }

        const contentBg = this.getContentBg(parent);
        contentBg.childDepandAlpha = true;
        contentBg.visible = true;
        this.contentBg1 = contentBg;

        //内容
        addText(contentBg, skin, 96)

    }

    private initBigCard2(parent, skin) {

        const addText = (bg: ShapeRect, skin, fontSize) => {

            let totalWidth = 0;

            var textLabelArr = [];

            var sHeight = 0;

            let height = 0;

            for (let i = 0; i < this.exercisesData.letters.length; ++i) {

                var letter = this.exercisesData.letters[i];

                //内容
                const text = new Label();
                text.text = letter.val;

                text.fontName = "GOTHICB";
                let fontColor = "";

                if (skin == 'B') {
                    if (letter.isColor === '0') {
                        fontColor = "#717071";
                    }
                    else {
                        fontColor = "#cc2a2e";
                    }
                }
                else {
                    if (letter.isColor === '0') {
                        fontColor = "#000000";
                    }
                    else {
                        fontColor = "#cc2a2e";
                    }
                }
                text.fontColor = fontColor;
                text.fontSize = fontSize;
                text.y = bg.height - text.getBoundingBox().height / 2 - 40 * this.scaleY;

                textLabelArr.push(text);
                text.refreshSize();

                totalWidth += text.getBoundingBox().width;

                sHeight = text.getBoundingBox().height;
                height = text.height;
            }

            totalWidth = this.setMaxScale(textLabelArr, (960 - 90) * this.scaleX);

            var startX = (bg.width - totalWidth) / 2;

            for (let i = 0; i < textLabelArr.length; ++i) {

                var textLabel = textLabelArr[i];

                textLabel.x = startX;

                startX += textLabel.getBoundingBox().width;

                bg.addChild(textLabel);

            }

            return { height: height, sHeight: sHeight };
        }

        const contentBg = this.getContentBg(parent);
        contentBg.childDepandAlpha = true;
        this.contentBg2 = contentBg;

        let width = contentBg.width;

        let height = contentBg.height;

        //内容
        let textHeight = addText(contentBg, skin, 72);

        //图片最大高度和宽度
        let maxWidth = width - 40 * this.scaleY;
        let maxHeight = height - 80 * this.scaleX - textHeight.height;

        const contentPic = new MySprite();
        contentPic.init(this.images.get(this.exercisesData.pic_url));
        let scale = Math.min(maxHeight / contentPic.height, maxWidth / contentPic.width);

        //如果小于1,则缩放图片
        if (scale < 1) {
            contentPic.setScaleXY(scale);
        }

        contentPic.x = width / 2;
        contentPic.y = height - textHeight.sHeight - 17 * this.scaleY - contentPic.getBoundingBox().height / 2 - 22 * this.scaleY;
        contentBg.addChild(contentPic);
    }

    private getColsePic(parent) {
        const closePic = new MySprite();
        closePic.init(this.images.get('close'));
        closePic.scaleX = parent.scaleX;
        closePic.scaleY = parent.scaleY;

        closePic.x = parent.width;

        closePic.y = 0;
        parent.addChild(closePic);

        return closePic;
    }

    private getOverturnPic(parent) {
        const overturnPic = new MySprite();
        overturnPic.init(this.images.get('overturn'));
        overturnPic.scaleX = parent.scaleX;
        overturnPic.scaleY = parent.scaleY;

        overturnPic.x = parent.width - 10 * parent.scaleX - overturnPic.getBoundingBox().width / 2;

        overturnPic.y = parent.height - 10 * parent.scaleY - overturnPic.getBoundingBox().height / 2;
        parent.addChild(overturnPic);

        return overturnPic;
    }

    /**
     * 显示大卡片
     */
    showBigCard(toX: number, toY: number, callback = null) {

        if (this.showed) {
            return;
        }

        this.cardBg.x = this.bg.x;

        this.cardBg.y = this.bg.y;

        tweenChange(this.cardBg, { scaleX: 1, scaleY: 1, x: toX, y: toY }, 0.5, () => {
            this.canClickCard = true;
            this.showed = true;
            if (callback) {
                callback();
            }
        });
    }


    overturn(scaleX: number, callback = null) {

        if (!this.canClick) {
            return;
        }

        if (!this.canClickCard) {
            return;
        }

        let w = scaleX;

        this.canClickCard = false;

        let tScaleX = this.closePic.scaleX;

        let tScaleY = this.closePic.scaleY;

        tweenChange(this.closePic, { scaleX: tScaleX * 1.1, scaleY: tScaleY * 1.1 }, 0.1, () => {
            tweenChange(this.closePic, { scaleX: 0, scaleY: 0 }, 0.4, () => {

            });
        });

        tweenChange(this.overturnPic, { scaleX: tScaleX * 1.1, scaleY: tScaleY * 1.1 }, 0.1, () => {
            tweenChange(this.overturnPic, { scaleX: 0, scaleY: 0 }, 0.4, () => {

            });
        });


        tweenChange(this.showBg, { alpha: 0 }, 0.5, () => {

            tweenChange(this.cardBg, { scaleX: 0 }, 0.3, () => {

                this.contentBg2.visible = !this.contentBg2.visible;

                this.contentBg2.visible ? this.showBg = this.contentBg2 : this.showBg = this.contentBg1;

                this.showBg.alpha = 0;

                tweenChange(this.cardBg, { scaleX: w }, 0.3, () => {

                    tweenChange(this.showBg, { alpha: 1 }, 0.5, () => {

                    });
                    tweenChange(this.closePic, { scaleX: tScaleX * 1.1, scaleY: tScaleY * 1.1 }, 0.4, () => {
                        tweenChange(this.closePic, { scaleX: tScaleX, scaleY: tScaleY }, 0.1, () => {

                        });
                    });

                    tweenChange(this.overturnPic, { scaleX: tScaleX * 1.1, scaleY: tScaleY * 1.1 }, 0.4, () => {
                        tweenChange(this.overturnPic, { scaleX: tScaleX, scaleY: tScaleY }, 0.1, () => {
                            this.canClickCard = true;

                            callback && callback();
                        });
                    });
                });

            });
        });


    }

    close(callback = null) {

        this.canClickCard = false;

        this.showed = false;

        this.pasueAudio();

        let toX = this.bg.x;

        let toY = this.bg.y;

        tweenChange(this.cardBg, { scaleX: 0, scaleY: 0, x: toX, y: toY }, 0.5, () => {

            if (this.contentBg2.visible) {
                this.contentBg1.visible = true;
                this.contentBg2.visible = false;
            }

            this.contentBg1.alpha = 1;

            callback && callback();
        });

    }

    resetText(scale, skin = 'A') {

        var totalWidth = 0
        
        for (let i = 0; i < this.textLabelArr.length; ++i) {
            var textLabel = this.textLabelArr[i];

            textLabel.setScaleXY(scale);

            textLabel.refreshSize();

            totalWidth += textLabel.getBoundingBox().width;
        }

        this.resetX(this.textLabelArr, totalWidth, skin);
    }

    playAudio(callback = null) {
        playAudio(this.audio, true, callback);

        return this.audio;
    }

    pasueAudio(callback = null) {
        pauseAudio(this.audio, true, callback)
    }
}


/**
* 获取缺省的练习题内容
*/
export function getDefaultExercisesItem() {
    let exercises = {
        text: "This is apple",
        pic_url: "",
        audio_url: "",
        index: 0
    }

    return exercises;
}